// +w1680 +h600 +a0.3

camera {                   
	orthographic
	right x*image_width/image_height
	location <0, 0, -2>
	look_at <0, 0, 0>
}

light_source {<1, 3, -5> color rgb 1.4} 

#declare showSea = 1;
#declare showCity = 1;
#declare showLand = 1;

#local Plane = union {
	triangle{<-0.5, -0.5, 0>, <-0.5, 0.5, 0>, <0.5, 0.5, 0>}
	triangle{<-0.5, -0.5, 0>, <0.5, -0.5, 0>, <0.5, 0.5, 0>}
}

#declare Bgr = object {
	Plane
	pigment{color rgb 1}
	finish{ambient 1}
	scale 1.1
	translate<0, 0, 0.01>
}

#include "filters.inc"                               
#declare n = 220;

#if(showSea = 1)
	#declare Sea = pigment {
		image_map{    
			tga "seascape.tga" 
			map_type 0
			interpolate 0
			once
		} 
	} 
	
	union {
		union {
			object{Plane pigment{Sea translate<-0.5, -0.5, 0>} finish{ambient 0.4} translate z*0.005}
			union{Pollock(Sea, n, n, 1, 1, finish{ambient 0.4 phong 0.25}) translate<-0.5, -0.5, -0.01>}
			scale 0.9
		}      
		object{Bgr}
		scale 0.7
		translate -x*0.895
	}         
#end

#if(showCity = 1)
	#declare City = pigment {
		image_map{    
			tga "cityscape.tga" 
			map_type 0
			interpolate 0
			once
		} 
	} 
	
	union {
		union {
			object{Plane pigment{City translate<-0.5, -0.5, 0>} finish{ambient 0.4} translate z*0.005}
			union{Pollock(City, n, n, 1, 1, finish{ambient 0.4 phong 0.25}) translate<-0.5, -0.5, -0.01>}
			scale 0.9
		}      
		object{Bgr}
		scale 0.7
	}         
#end

#if(showLand = 1)
	#declare Land = pigment {
		image_map{    
			tga "landscape.tga" 
			map_type 0
			interpolate 0
			once
		} 
	} 
	
	union {
		union {
			object{Plane pigment{Land translate<-0.5, -0.5, 0>} finish{ambient 0.4} translate z*0.005}
			union{Pollock(Land, n, n, 1, 1, finish{ambient 0.4 phong 0.25}) translate<-0.5, -0.5, -0.01>}
			scale 0.9
		}      
		object{Bgr}
		scale 0.7
		translate x*0.895
	}         
#end



background{color rgb 0}