camera { 
	orthographic
	right x*image_width/image_height
	location <0, 0, -1.5>
	look_at 0
}

light_source {<2, 5, -5> color rgb 2 }

#declare Plane = union {
	triangle{<-0.5, -0.5, 0>, <-0.5, 0.5, 0>, <0.5, 0.5, 0>}
	triangle{<-0.5, -0.5, 0>, <0.5, -0.5, 0>, <0.5, 0.5, 0>}
}

#declare Tree = union {
	difference {
		cylinder{0, <0, 0, -0.0001>, 0.1}
		plane{y, 0}
		scale<1, 3, 1>
	}
	difference {
		cylinder{0, <0, 0, -0.0001>, 0.1}
		plane{-y, 0}
		scale<1, 0.75, 1>
	}
	scale<1, 1.2, 1>
}

#declare C1 = <0, 1.0, 0.5>*0.7;
#declare C2 = <0, 0.8.0, 0.2>*0.7;
#declare C3 = <0, 1.0, 0.4>*0.7;

#declare C4 = <0.7, 0.2, 0>*0.8;
#declare C5 = <0.83, 0.4, 0>*0.8;
#declare C6 = <1, 0.5, 0>*0.8;

#declare C7 = <0, 0.8, 1>*0.7;
#declare C8 = <0, 1, 0.9>*0.7;
#declare C9 = <1, 1, 1>*0.7;

#declare Fin = finish{diffuse 0.8 phong 0.7};

#declare Back = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C1 color rgb C1]
			[1/3 (1/3)*2 color rgb C2 color rgb C2]
			[(1/3)*2 1 color rgb C3 color rgb C3]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare BackDark = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C1*0.7 color rgb C1*0.7]
			[1/3 (1/3)*2 color rgb C2*0.7 color rgb C2*0.7]
			[(1/3)*2 1 color rgb C3*0.7 color rgb C3*0.7]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare River = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C7 color rgb C7]
			[1/3 (1/3)*2 color rgb C8 color rgb C8]
			[(1/3)*2 1 color rgb C9 color rgb C9]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare RiverDark = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C7*0.7 color rgb C7*0.8]
			[1/3 (1/3)*2 color rgb C8*0.7 color rgb C8*0.8]
			[(1/3)*2 1 color rgb C9*0.7 color rgb C9*0.8]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare TreeTxt = texture{
	pigment {
		granite 
		color_map {
			[0 1/3 color rgb C4 color rgb C4]
			[1/3 (1/3)*2 color rgb C5 color rgb C5]
			[(1/3)*2 1 color rgb C6 color rgb C6]
		} 
		scale 0.01
	}
	finish{Fin}
}


difference {
	object{Plane}
	plane{y, 0 rotate z*15 translate<0, -0.14, 0>}
	
	texture{Back}           
}

object{
	Plane
	translate<0, 0, 0.0003>
	
	texture{River}           
}

object{
	Tree
	pigment{color rgb C4} 
	finish{Fin}         
	scale 0.8
	translate<-0.28, -0.03, -0.001>
	no_shadow
}

object{
	Tree
	pigment{color rgb C5} 
	finish{Fin}         
	scale 1.2
	translate<-0.1, -0.0, -0.001>
	no_shadow
} 

object{
	Tree
	pigment{color rgb C6} 
	finish{Fin}         
	scale 1
	translate<0.1, 0.05, -0.001>
	no_shadow
}

// shadows

object{
	Tree
	texture{RiverDark}         
	scale 0.8
	scale<1, -1, 1>
	translate<-0.28, -0.07, 0.0001>
	no_shadow
}

object{
	Tree
	texture{RiverDark} 
	scale 1.2
	scale<1, -1, 1>
	translate<-0.1, -0.0, 0.0002>
	no_shadow
} 

object{
	Tree
	texture{RiverDark}         
	scale<1, -1, 1>
	translate<0.1, -0.0, 0.0001>
	no_shadow
}




difference {
	object{
		Tree 
		scale 0.8
		scale<1, -1, 1>
		translate<-0.28, 0, -0.0001>
		
	}
	plane{y, 0 rotate z*15 translate<0, -0.07, 0>}
	
	translate -y*0.07
	
	texture{BackDark}           
	no_shadow
}

difference {
	object{
		Tree 
		scale 1.2
		scale<1, -1, 1>
		translate<-0.1, -0.0, -0.0001>
	}
	plane{y, 0 rotate z*15 translate<0, -0.14, 0>}
	
	texture{BackDark}           
	no_shadow
}

difference {
	object{
		Tree 
		scale<1, -1, 1>
		translate<0.1, -0.0, -0.0001>
	}
	plane{y, 0 rotate z*15 translate<0, -0.14, 0>}
	
	texture{BackDark}           
	no_shadow
}


background{color rgb 1}
 