#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "stones1.inc"
#include "finish.inc"
#include "shapes.inc"
#include "metals.inc"
#include "glass.inc"
#include "woods.inc"


camera {
  location <50,75,-700>
  right <4/3, 0, 0>
  up <0, 1, 0>
  direction <0, 0, 1>
  look_at <0, 75, 0>
}

light_source { <0, 200, -150> color White }

sky_sphere {S_Cloud3}

plane {
        y, 0
        texture { pigment { Green }
                  finish { ambient 0.05 diffuse 0.7 }
                  normal { dents 15 scale .5 }
                }
      }
                     
#declare Floor =
box { <0,0,0>,<600,5,600>
    texture { pigment { SteelBlue }
              finish { ambient 0.05 diffuse 0.6 }
              normal { bumps 1 } 
    }
    translate <-300,0,-500>
}                            

#declare Wall1 =
box { <0,0,0>, <600,240,20> 
}

#declare Wall2 = 
box { <0,0,0>, <640,240,20> 
}

#declare Window1 =
box { <0,0,0>, <50,100,40>
    translate <100,50,-5>
}
 
#declare Window2 =
box { <0,0,0>, <50,100,40>
    translate <450,50,-5>
}

#declare Window3 =
box { <0,0,0>, <150,100,40>
    translate <225,50,-5>
}

#declare Wall1done =
difference { object {Wall1}
             object {Window1}
             object {Window2}
     texture { pigment { Gray95}
             finish { ambient 0.2 diffuse 0.5 }
             normal { bumps .15 scale .1 }
     }
     translate <-300,0,100>
}

#declare Wall2done =
difference { object {Wall2}
             object {Window3}
     texture { pigment { Gray95}
             finish { ambient 0.2 diffuse 0.5 }
             normal { bumps .15 scale .1 }
     }
     rotate <0,90,0>
     translate <-320,0,120>
     
}

#declare Ceiling =
box { <0,0,0>, <600,20,600>
    texture { pigment { Gray95 }
              finish { ambient 0.2 diffuse 0.5 }
              normal { bumps .15 scale .1 }
    }
    translate <-300,220,-500>
}

#declare Bulb =
sphere { <0,0,0>,4
       texture { pigment { color rgb <0.95,0.95,0.5> }
                 finish { ambient 0.8 diffuse 0.1 reflection 0.9 }
               }
       translate <0,217,-150>
}

#declare Glassdome =
sphere { <0,0,0>,15
       material {M_Glass3}
       clipped_by { box { <-20,-20,-20>,<20,-5,20> } }
       translate <0,220,-150>
}

#declare Wooddomebase =
difference{ cylinder { <0,0,0>,<0,4.5,0>,25 }
            torus { 25,6
                    translate <0,-2,0> }
    texture { DMFWood6 }
    translate <0,215.5,-150>
}

#declare MetalPlate = 
cylinder { <0,0,0>,<0,0.5,0>,16
         texture { Silver2 }
         translate <0,215,-150>
}

#declare Wall1moulding =
difference { box { <0,0,0>,<600,20,40>}
             cylinder{<-10,3,3>,<610,3,3>,16 }
                
    texture { DMFWood6 }
    translate <-300,200,79>
}

#declare Wall2moulding =
difference { box { <0,0,0>,<599,20,40>}
             cylinder{<-10,3,3>,<610,3,3>,16 }
                
    texture { DMFWood6 } 
    rotate <0,270,0>
    
    translate <-279,200,-499>
}

#declare Wall3moulding =
difference { box { <0,0,0>,<600,20,40>}
             cylinder{<-10,3,3>,<610,3,3>,16 }
                
    texture { DMFWood6 } 
    rotate <0,90,0>
    translate <279,200,100>
}

#declare House =
union { object{Floor}
        object{Wall1done}
        object{Wall2done}
        object{Ceiling}
        object{Wall1moulding}
        object{Wall2moulding}
        object{Wall3moulding}
        object{Glassdome}
        object{Wooddomebase}
        object{MetalPlate}
        object{Bulb}
      }             
      
object { House }

