#declare _aspect = image_width/image_height;
#declare _size = 1;

global_settings {
	number_of_waves 35
	assumed_gamma 1.0
}

camera {
  orthographic
  location <0,0,-90>    // position & direction of view
  look_at  <0,0,0>
  right _aspect*_size*x            // horizontal size of view
  up _size*y               // vertical size of view
}

#debug concat("aspect ratio: ",str(_aspect,1,6),"\n")
			
#macro WaveSet(n,nm,pt,sz)
	#local sca = int(rand(wsd)*nm-n)+1;
	#local ofp = rand(wsd); // phase offset
	#local opx = rand(wsd)*2; // x offset
	#local opy = rand(wsd)*2; // y offset
	#local ofx = rand(wsd)*_size; // x offset
	#local ofy = rand(wsd)*_size; // y offset
	#local ptLiq1 = function { pattern { waves turbulence 0.86 scale _size/sz } }
	#local ptLiq2 = function { pattern { ripples turbulence 0.41 scale _size/sz/2 } }
	#local ptLiq3 = function { pattern { crackle turbulence 1.41 omega 0.69 scale _size/sz*3 } }
	#local ptLiq4 = function { pattern { granite scale _size/sz/3 } }
	#local ptLiq5 = function { pattern { agate agate_turb 0.67 scale _size/sz/5 } }
	
	#declare pgWave[n-1] = function {
		pattern {
			#switch(mod(n,pt))
				#case (0)
					function { ptLiq4(pow(cos(pi*(x+opx)),2),pow(sin(pi*(y+opy)),2),z) }
				#break
				#case (1)
					function { -ptLiq3(pow(cos(pi*(x+opx)),2),pow(sin(pi*(y+opy)),2),z) }
				#break
				#case (2)
					function { ptLiq2(pow(cos(pi*(x+opx)),2),pow(sin(pi*(y+opy)),2),z) }
				#break
				#case (3)
					function { -ptLiq1(pow(cos(pi*(x+opx)),2),pow(sin(pi*(y+opy)),2),z) }
				#break
				#case (4)
					function { ptLiq5(pow(cos(pi*(x+opx)),2),pow(sin(pi*(y+opy)),2),z) }
				#break
			#end
			//scale sca				
			phase ofp
			translate <ofx,ofy,0>
		}	
	}
#end

#macro gridWave(nm,sz,fn,sz)
	#declare pgWave = array[nm]
	function { (
	#local to = nm;
	#while (to>0)
		WaveSet(to,nm,fn,sz)
		pow(pgWave[to-1](x,y,z),2.5)
		#local to = to - 1;
		#if (to>0) + #end
	#end
	) }
#end

// River/stream
#declare mapLiq1 = color_map {
	[ 0.00 rgb <0.000,0.000,0.000> ]
	[ 0.03 rgb <0.000,0.076,0.324> ]
	[ 0.13 rgb <0.000,0.231,0.479> ]
	[ 0.66 rgb <0.118,0.423,0.763> ]
	[ 0.80 rgb <0.213,0.459,1.000> ]
	[ 1.00 rgb <0.654,1.000,1.000> ]
}

#declare mapLiq2 = color_map {
	[ 0.05 rgb <0.000,0.000,0.000> ]
	[ 0.08 rgb <0.000,0.076,0.324> ]
	[ 0.23 rgb <0.000,0.231,0.479> ]
	[ 0.46 rgb <0.118,0.423,0.763> ]
	[ 0.70 rgb <0.213,0.459,1.000> ]
	[ 0.99 rgb <0.654,1.000,1.000> ]
}

#declare mapLiq3 = color_map {
	[ 0.00 rgb <0.000,0.000,0.500> ]
	[ 0.90 rgb <0.000,1.000,1.000> ]
	[ 1.00 rgb <0.750,1.000,1.000> ]
}

// Ice
#declare mapLiq4 = color_map {
	[ 0.00 rgb <0.000,0.500,1.000> ]
	[ 0.30 rgb <0.000,1.000,1.000> ]
	[ 1.00 rgb <0.750,1.000,1.000> ]
}

// Ocean
#declare mapLiq5 = color_map {
	[ 0.05 rgb <0.000,0.334,0.000> ]
	[ 0.08 rgb <0.000,0.376,0.224> ]
	[ 0.23 rgb <0.000,0.485,0.359> ]
	[ 0.46 rgb <0.118,0.623,0.463> ]
	[ 0.90 rgb <0.213,0.859,0.641> ]
	[ 0.99 rgb <0.354,1.000,0.782> ]
}

// Swamp
#declare mapLiq6 = color_map {
	[ 0.00 rgb <0.000,0.060,0.000> ]
	[ 0.30 rgb <0.000,0.130,0.010> ]
	[ 1.00 rgb <0.010,0.350,0.045> ]
}

// Blood
#declare mapLiq7 = color_map {
	[ 0.00 rgb <0.040,0.000,0.000> ]
	[ 0.90 rgb <0.120,0.000,0.010> ]
	[ 1.00 rgb <0.310,0.050,0.045> ]
}

// Lava
#declare mapLiq8 = color_map {
	[ 0.00 rgb <0.840,0.120,0.000> ]
	[ 0.70 rgb <0.930,0.450,0.010> ]
	[ 0.80 rgb <1.000,0.750,0.080> ]
	[ 0.90 rgb <1.000,1.000,0.210> ]
	[ 1.00 rgb <1.000,1.000,1.000> ]
}

#declare wsd = seed(544);
#declare wnm = 7;
#declare nwv = 3;
#declare _div = 1.0;

#declare texLiq1 = texture {
	pigment {
		gridWave(7,_size,3,7)
		triangle_wave
		color_map { mapLiq1 }
		phase clock
	}
	finish {
		ambient 1
		diffuse 0
	}
}

#declare texLiq4 = texture {
	pigment {
		gridWave(9,_size,4,4)
		triangle_wave
		color_map { mapLiq4 }
		phase clock
	}
	finish {
		ambient 1
		diffuse 0
	}
}

box { 
	-.5,.5 
	scale _size 
	texture { 
		average
		texture_map {
			[ 1 texLiq1 ]
			[ 3 texLiq4 ]
		}
		scale <_aspect,1,1> 
	}
} 

