
// Persistence of Vision Ray Tracer Scene Description File
// File: glider.pov
// Vers: 3.5
// Desc: Glider - IRTC Minimalism
// Date: 2005-08-31
// Auth: Stephen Cavilia sac7352@rit.edu
//

#version 3.5;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <-11.0, 6, -4.0>
//  location <-2, 6, 4>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <-2.0, 0.0,  1.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1.5, 1.5, 1.5>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { checker
	pigment { color rgb <0.4,0,0.2> },
	pigment { color rgb <0.3,0,0> } }
}



#declare wing1 = intersection {

	box { <0, 0, -1>, <6, 0.05, 1> }
	cylinder { <1, -0.1, 0>, <1, 0.1, 0>, 5.5 scale 0.26*z }

}

#declare wing2 = box {
	<-0.25, 0, -1>, <0.25, 0.05, 1>
}

#declare t1 = 	texture {
	pigment {
		color rgb <1,1,0>
	}
}

#declare wingfull = union {
	object {wing1 rotate 3.5*z translate .25*x}
	object {wing1 scale -1*x rotate -3.5*z translate -.25*x}
	object {wing2}
	texture {
		pigment {
			image_map { png "wing.png" once }
			rotate -90*x
			scale <12.5,1,2>
			translate <-6.25,0,1>
			quick_color rgb <1,1,0>
		}
	}
}

#declare fuselage = difference {
	box { <-0.08, -.2, -2>, <0.08, 0.3, 7> }
	box { <-0.1, 0, -1.2>, <0.1, 0.05, 1.46> }
	box { <-0.1, 0, 5>, <0.1, 0.05, 7.1> }
	cylinder { <-0.1, 1, -0.1>, <0.1, 1, -0.1>, 0.85 scale <1, 1, 1.63> }
	box { <-0.025, 0.1, -1.1>, <0.025, 0.31, 0.9> }
	box { <-0.025, 0.1, 4.8>, <0.025, 0.31, 7.1> }
	texture {
		pigment {
			image_map { png "wood.png" }
			rotate 90*y
			scale <1,1,5>
			rotate 30*z
			quick_color rgb <1,1,0>
		}
	}
}
	
#declare htail = difference {
	box { <-2, 0, -0.4>, <2, 0.05, 1.4> }
	box { <0, -0.1, 0>, <-3, 0.1, 1> rotate -25*y translate 1.6*z}
	box { <0, -0.1, 0>, <3, 0.1, 1> rotate 25*y translate 1.6*z}
	box { <-0.4, -0.1, 0>, <0.4, 0.1, -0.5> }
	box { <0, -0.1, 0>, <1, 0.1, -0.4> rotate 40*y translate 0.4*x }
	box { <0, -0.1, 0>, <-1, 0.1, -0.4> rotate -40*y translate -0.4*x }
	rotate 180*y
	texture {
		pigment {
			image_map { png "htail.png" once }
			rotate -90*x
			scale <4.02,1,2.02>
			translate <-2.01,0,0.4>
			quick_color rgb <1,1,0>
		}
	}
}

#declare vtail = difference {
	box { <-0.025, 0, 0>, <0.025, 1.8, 1.8> }
	box { <-0.05, 0, 0>, <0.05, 2, -1> rotate 25*x }
	texture {
		pigment {
			image_map { png "vtail.png" once }
			rotate 90*y
			scale 2
			translate 1.95*z
			quick_color rgb <1,1,0>
		}
	}
}

union {
	object {wingfull}
	object {fuselage}
	object {htail translate 6.5*z}
	object {vtail translate <0, 0.2, 4.9>}
	/*texture {t1}*/
}





