// Persistence of Vision Ray Tracer Scene Description File
// File: sks_mage.pov
// Vers: 3.6
// Desc: IRTC, July/August 2005--"Minimalism"
// Date: 08/05/2005
// Auth: Copyright  2005 by Sherry K. Shaw


//------------------------------------------------------------------------------
//  "Magenta"
//
//  Additional command line stuff:
//    +A0.05 -J +R5
//------------------------------------------------------------------------------


////////////////////////////////////////////////////////////////////////////////
// Initialization
////////////////////////////////////////////////////////////////////////////////

#include "rad_def.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 10
  photons {
    spacing 0.025
    autostop 0
    jitter 0
  }
  ambient_light 0
  radiosity {
    Rad_Settings(Radiosity_IndoorHQ, on, off)
  }
}


////////////////////////////////////////////////////////////////////////////////
// Declarations
////////////////////////////////////////////////////////////////////////////////

#declare THING_MAT =
material {
  texture {
    pigment {
      rgbt < 0, 0, 0, 1 >
    }
    finish {
      ambient 0
      diffuse 0
      reflection {
        0.01, 0.95
        fresnel
      }
      conserve_energy
      phong 40
      phong_size 12
      metallic 1
      specular 75
      roughness 0.0004
    }
  }
  interior {
    ior 1.35
    fade_color < 0.45, 0.15, 0.45 >
    fade_power 2
    fade_distance 0.375
  }
}

#declare THING_OBJ =
julia_fractal {
  < 0.51, 0.05, 0.73, 0.16 >
  quaternion
  sqr
  max_iteration 5
  precision 10
  hollow
  photons {
    target
    reflection on
    refraction on
    collect off
  }
  rotate y*18                   // Stand it upright...
  rotate x*-35
  rotate z*-1.8
  translate < 0, 1.2475, 0 >    // ...and set it on the ground.
}


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// The Scene
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//------------------------------------------------------------------------------
// Camera
//------------------------------------------------------------------------------

camera {
  right x*image_width/image_height
  location < 0, 2.25, -5 >
  look_at < 0, 1.25, 0 >
  angle 50
}


//------------------------------------------------------------------------------
// Light source
//------------------------------------------------------------------------------

light_source {
  < -10000, 10000, -10000 >
  color rgb < 1.0, 1.0, 1.0 >
  photons {
    refraction on
    reflection on
  }
} 


//------------------------------------------------------------------------------
// Environment
//------------------------------------------------------------------------------

sphere {
  < 0, 0, 0 >, 100000
  hollow
  texture {
    pigment {
      color rgb 0
    }
    finish {
      ambient 0
      diffuse 1
    }
  }
  photons {
    collect off
  }
}
                                                                                                                                                                                   
plane {
  y, 0
  texture {
    pigment {
      color rgb < 0.0, 0.0, 0.0 >
    }
    finish {
      ambient 0
      diffuse 0
      reflection {
        1.0
        metallic 0.25
      }
    }
    normal {
      wrinkles
      scale 1.5
    }
  }
  photons {
    collect on
  }
  hollow
}


//------------------------------------------------------------------------------
// The magenta thing
//------------------------------------------------------------------------------

object {
  THING_OBJ
  material {
    THING_MAT
  }
  rotate y*-51
}

