
#declare WheelDustShape=
union{
  difference{
    box{<-6,-11,-4><3.95,4.8,8>} 
    union{
      cylinder{<-10,0,0><10,0,0>2.0 translate<0,0,-0.4>}
      box{<-1.251,0,0><1.251,10,-10>} 
      
      box{<-10,-10,10><10,3,0> rotate -20*y rotate -14*x translate<-2.5, 0, 6.5>}
      
      cylinder{<-10,0,0><10,0,0>1.75 scale<1,1,1.5>translate<0,4.8,0>} 
      #declare N=0;
      #while (N<=125)
        box{<-10,3.05,-10><10,10,0> rotate -N*x}
        #declare N=N+5;
      #end 
    } 
    box{<-10,2.785,-10><10,10,1.8> rotate -16*x}         
    box{<-10,-10,-10><0,10,10>rotate -5*y translate<-4.6,0,0>}
  }
  translate<0,3.1,0>    
}

#declare WheelDust=
object{WheelDustShape   

// pigment{rgbt<0,1,0,0>} /* 
  texture{pigment{rgbt<0,0,0,1>}finish{ambient 0 diffuse 0}} 
  hollow
  interior{
    media {  
      absorption <0.75,0.9,1>*2
      emission rgb<77,57,26>/150
      density { 
	  cylindrical
	  turbulence 1
	  omega 0.85  
          rotate 90*z
          scale <5,5,8>  
          translate<-0.5,2,1>    
      }
    } 
    media {  
      absorption <0.75,0.9,1>*2
      density { 
	  cylindrical
	  turbulence 1
	  omega 0.85  
          rotate 90*z
          scale <5,5,8>  
          translate<-0.5,1.5,1>    
      }
    } 
    media {  
      absorption <0.75,0.9,1>*2
      density { 
	  cylindrical
	  turbulence 1
	  omega 0.85  
          rotate 90*z
          scale <5,5,8>  
          translate<-0.5,0,1>    
      }
    } 
  }   
// */
}

#declare RotSeed = seed(0);

#macro RandomRot()
  <rand(RotSeed)*360,rand(RotSeed)*360,rand(RotSeed)*360>
#end


#macro SmokeAndFire(a)

difference{

  box{<-1,0.5,-2><1,20,30> }
  box{<-10,0.4,-2><10,-20,31> rotate -14*x} 
  
  texture{pigment{rgbt<0,0,0,1>}finish{ambient 0 diffuse 0}} 

  hollow
  interior{     
    
    //Fire
      media {              
        emission .6
        density { 
	  spherical
	  color_map{
	    [0   Black]
	    [0.5 rgb<1,.2,0>*2]
	    [1   rgb<1,.9,0>*3]
	  }	     
	  turbulence <0,0.5,0>
	  omega 0
	  scale <0.2, 1.5, 0.2> 
	  rotate rand(RotSeed)*360*y
	  translate <0,0.5,0>
        }
      }                                              
    
    //straight up guv
    #declare N=1;
    #while (N<18) 
      media {              
        absorption <.9,.9,1>*1/N
        density { 
	  spherical	     
	  omega 0.5*N/20  
        }      
        #declare s = 0.1 + N/15;
        scale <s,1,s>
        rotate RandomRot()
        rotate a*y
        translate<0,N/4,(N/18)*(N/18)*(N/18)>        
      }                                              
      #declare N=N+1;
    #end 
    
    //now curve around and away
    #declare N=1;
    #while (N<25) 
      media { 
        emission 0.01                      
        absorption <.9,.9,1>*(0.02 + 0.2/N)
        density { 
	  spherical	     
	  turbulence 0.75
	  omega 0.5  
        }      
        #declare s = 1.5 + N/8;
        scale <s,s,s>
        rotate RandomRot()
        translate<0, 4 + N/3, N+0.5>        
      }
      #declare N=N+0.5;
    #end 
    
  }
  translate <0,6.8,-5.45> 
}  

#end