#include "Shapes.inc"
#include "Nuts.inc"
#include "Exhausts.inc"
#include "Tank.inc"

#declare Flange =
union{
  object{ sqfillet(0.75,4.8,.125, .125) rotate 180*x  }
  intersection{
    object{rbox(1,1,5.05,.2)}
    box{<-10,0,-10><10,.1,10>}
  } 
}

#declare plugH = 3;
#declare plugR = .7;
#declare plugh = 3;
#declare plugr = .6; 
#declare leadr = .5;          

#declare aa = seed(0);

#macro plug(A)
union{
  cylinder{<0,0,0>, <0,plugH,0>,plugR}       
  sphere{ <0,plugH,0>, plugR}
  union {  
    cylinder{<0,0,0>, <0,plugh,0>,plugr  }
    torus {  plugr - .2, .2  translate<0,plugh,0>  }
    rotate<-90,0,0>
    translate<0,plugH,-plugR/2>
  } 
  
  #declare x1 = 10;
  #declare a1 = 20 + A;
  
  union{
    object{tube(x1,a1,leadr)  rotate -90*x   rotate 180*z  translate<0, plugH, -plugh-0.2>} 
    object{tube(6,140,leadr) rotate -90*x   translate <0,-x1,0> rotate a1*x translate <0,x1,0>   translate<0, plugH, -plugh-0.2>} 
    translate <0,-plugH,0>
    rotate 30*z 
    translate <0, plugH,0>

  }
  translate<0,-.4,0>
  pigment{rgb<1,.3,.3>}
  scale .075 
  rotate -80*y
}     
#end

#declare R=0.08;
#declare Intake =
union{
   
   #declare N=0;
   #while (N<6)
     union{
     object{tube(1,50,R) rotate -90*z rotate 90*x}
   
     #declare L = 0.3;
     union{
       cylinder{<0,0,0><L,0,0>R}
       object{tube(.6,70,R)rotate -90*z rotate -90*x translate<L,0,0>}  
       translate<0,-1,0> rotate 50*z  translate<0,1,0>
     }
     translate<0,0,-R-1.75+N*0.7>
  
     #declare N=N+1;
     }
  #end
    
  texture{ChromeTex}

}

#declare Block=
union{                   
 
  
  union{
  
    //Exhaust stubs
    #declare N = 0;
    #while (N<6)
      
      cylinder{<0,0,0><-.5,0,0> ExhaustR1 translate<0,0.4,-1.75+N*0.7> texture{ChromeTex}} 
      
      union{
        object{dohnut(ExhaustR1 + 0.1, 0.05, ExhaustR1, 0.02, .1)}
        object{rfillet(ExhaustR1 + 0.1, 0.05)}
        translate <0,0.375,0> 
        rotate 90*z 
        translate<0,0.4,-1.75+N*0.7>
      }
      
      #declare N = N + 1;
    #end
      
    //Head
    difference{
      object{ rbox(1.05, 1.5 , 5.1  ,.225) } 
      union{
         box{<-10,-10,-10><10,0,10>}
         #declare N = 0;
         #while (N<6)
           cylinder{<0,-10,0><0,10,0> .15 translate<0,0,-1.75+N*0.7> }  
           #declare N = N + 1;
         #end        
      }
      scale<1,.5,1> 
      translate<0,0.8125,0>
      texture{HeadTex}
    }  

    union{
      #declare N = 0;
      #while (N<6)
        
        torus{.15,.05 translate<0,0.8125+0.375-0.05,-1.75+N*0.7> } 
        object{plug((0.5-rand(aa))*10)   
        translate<0,0.8125+0.375-0.05,-1.75+N*0.7> }
         
        #declare N = N + 1;
      #end        
      texture{HeadTex}
    }
    
    //Main Cylinder Block 
    difference{
       object{ rbox(0.75, 1.9 ,4.8,.125) }
       box{<0,0,-10><.5,.7,10> translate<-0.25,0,0>}
    }
    
    
    height_field{jpeg "BlkplateR.jpg"
       smooth     
       rotate 90*x
       translate <0,1,0> 
       rotate  90*z
       translate <1,0,0> 
       rotate  90*z
       translate <1,0,0> 
       scale <0.5, 0.7, 0.05>
       translate<-0.25,0, -2.4>
    }
    
    height_field{jpeg "BlkplateL.jpg"
       smooth     
       rotate 90*x
       translate <0,1,0> 
       rotate  90*z
       translate <1,0,0> 
       rotate  90*z
       translate <1,0,0> 
       scale <0.5, 0.7, 0.05>
       translate<-0.25,0, -2.4>
       rotate 180*y
    }
    
    object{ Flange translate<0,.8,0>}
    
    union{
      object{ Flange }
      object{ rbox(0.75, 4 ,4.8,.125) scale<1,.4,1> translate <0,.5,0> }
      intersection{
        object{ rbox(0.65, 4 ,4.7,.125) }
        box{<-10,0,-10><10,.1,10>} 
        translate <0,-0.4,0> 
        texture{ChromeTex}
      }
      scale <0.6,0.3,0.6>
      rotate 90*z translate<.375,.4,.7>
    }
    
    union{
      object{ Flange }
      object{ rbox(0.75, 4 ,4.8,.125) scale<1,.4,1> translate <0,.5,0> }
      intersection{
        object{ rbox(0.65, 4 ,4.7,.125) }
        box{<-10,0,-10><10,.1,10>} 
        translate <0,-0.4,0> 
        texture{ChromeTex}
      }
      scale <0.6,0.3,0.6>
      rotate 90*z translate<.375,.4,-.7>
    }
    
    //Air Intake 
    #ifdef (HighDef)
      object{Intake translate<.38,.4,0>}
    #end
    
    rotate 20*z
    translate<-0.55,1.2,0>
  }

  
  union{ 
    
    #ifdef (HighDef)
      difference{
       object{ rbox(0.9,0.5,4.8,.1) texture{ChromeTex}}
       union{
         #declare N2 = 0;
         #while (N2<3)
       
          #declare N1=0;
          #while (N1<4.3)
            cylinder{<0,0,0><0,-1,0>.11 translate<0.25-N2*0.25,0,-2.1 + N1>}
            #declare N1 = N1 + 0.3; 
          #end        
        
          #declare N2=N2+1;
        #end
       }  
       texture{AirFilterTex} 
      }
   #end
    
    difference{
     object{ rbox(0.95,0.55,4.85,.125) }
     box{<-10,-10,-10><10,0,10>       rotate 15*z } 
     texture{FilterCoverTex}
    }
    
    #declare aL = 4.7;
    object{ rbox(0.8,0.3,aL,.1)  translate<0,0,0> texture{AirFilterTex}}    

        #declare N1=0;
        #while (N1<5)
          object{BoltHeadWash scale.05 rotate 90*z translate<-0.475,0.0,-aL/2+aL/10+N1*aL/5> texture{ChromeTex}}
          #declare N1 = N1 + 1; 
        #end        

    translate<-1.3,3,0>  
  } 
  

}


#declare Sump=
union{

  object{rbox(1.5,1.5,4.8,.125) }
  object{rbox(1.4,0.5,4.7,.125) translate -.7*y texture{DirtyChromeTex}}
  
  object{
    Flange
    translate <0,-0.31,0>
    rotate 20*z
    translate<-0.55,1.2,0>
  }
  object{
    Flange
    translate <0,-0.31,0>
    rotate -20*z
    translate<0.55,1.2,0>
  }
  object{
    Flange 
    rotate 180*x
    translate <0,-0.1,0>
    rotate 20*z
    translate<-0.55,1.2,0>
  }
  object{
    Flange
    rotate 180*x
    translate <0,-0.1,0>
    rotate -20*z
    translate<0.55,1.2,0>
  }
      
  #declare w = 4.5;
  #declare h = 1.3; 
  
  height_field{ 
    jpeg "Sumplate.jpg" 
    smooth  
    translate<-0.5,0,-0.5> 
    scale<w,0.05,h> 
    rotate -90*y rotate 90*z  
    translate <-0.74,-0.01, 0> 
  }
  height_field{ 
    jpeg "Sumplate.jpg" 
    smooth  
    translate<-0.5,0,-0.5> 
    scale<w,0.05,h> 
    rotate -90*y rotate 90*z 
    rotate 180*y 
    translate <-0.74,-0.01, 0> 
  } 
  
  union{
  difference{
    union{ 
      intersection{
         object{Flange rotate 90*x translate <0,-2.025,0>}
         box{<-10,0,-10><10,10,10>} 
      }
      intersection{
         object{Flange rotate 90*x translate <0, 2.025,0>}
         box{<-10,-10,-10><10,0,10>} 
      }
      #declare w = 0.75;
      object{ rbox(w,w,0.5,0.125)}
      scale <1.2,1.2,.5>
      }
      union{
      #declare N=-2;
      #while (N<=2)
        cylinder{<0,0,0><0,0,-1>.06  translate<-0.51,-N*0.19,0>} 
        cylinder{<0,0,0><0,0,-1>.06  translate< 0.51,-N*0.19,0>} 
        cylinder{<0,0,0><0,0,-1>.06  translate<-N*0.19, 0.51, 0>} 
        cylinder{<0,0,0><0,0,-1>.06  translate<-N*0.19,-0.51, 0>} 
        #declare N=N+1;
      #end
      }
    }

    union{
      #declare N=-2;
      #while (N<=2)
      object{BoltHeadWash scale 0.035 rotate -90*x  translate<-0.51,-N*0.19,0>} 
      object{BoltHeadWash scale 0.035 rotate -90*x  translate< 0.51,-N*0.19,0>} 
      object{BoltHeadWash scale 0.035 rotate -90*x  translate<-N*0.19, -0.51, 0>} 
      object{BoltHeadWash scale 0.035 rotate -90*x  translate<-N*0.19,  0.51, 0>} 
      #declare N=N+1;
      #end    
      texture{ChromeTex} 
    }     
    
    scale 1.1
    translate <0,0,-2.45>         
  }
   
  union{
    #declare N=-2.1;
    #while (N<=2.1)
       object{BoltHeadWash scale 0.05 rotate 90*z translate<-.7,-0.825,N> texture{DirtyChromeTex}}
       #declare N = N + 0.3;
    #end 
  }
  
  union{
    object{rfillet(.08,.04)rotate -90*x}
    cylinder{<0,0,0><0,0,-0.2,>0.07} 
    object{tube(0.9,20,.095) rotate -90*x rotate 90*z translate<0, 0, -0.1> pigment{White*0.1}}
    cylinder{<0,0,-.15><0,0,-.18>.1 texture{AlloyTex}}
    translate <-0.3,-0.3,-2.58> 
  }
  
  union{
    object{rfillet(.08,.04)rotate -90*x}
    cylinder{<0,0,0><0,0,-0.2,>0.07} 
    object{tube(0.4,90,.095) rotate -90*x rotate 130*z translate<0, 0, -0.1> pigment{White*0.1}}
    cylinder{<0,0,-.15><0,0,-.18>.1 texture{AlloyTex}}
    translate <-0.45,1.4,-2.4> 
  }
}
           
//Radiator           
#declare W = 1.4;
#declare H = 1.8;
#declare D = 0.4;

#declare Radiator = 
union{
   
   #ifdef (HighDef)
     
     #declare d1 = .02;
     
     #declare N = 0;
     #while (N < H)  
        box{<-W/2, 0, -D/2><W/2, d1, D/2> translate N*y }
        #declare N = N + 3*d1;        
     #end
     
     #declare N=-W/2+.1;
     #while (N<W/2)
       object{rbox(0.05, H, D+0.05, 0.01) translate<N, H/2, 0>}
       #declare N = N + 0.1;
     #end
   #else
     box{<-W/2,0,-D/2><W/2,H,D/2>}
   #end

   
   union{
     intersection{
       object{rbox(W+.15, .5, D+0.15, 0.1)}
       box{<-10,0,-10><10,10,10>}
       translate H*y
     }
     
     intersection{
       object{rbox(W+.15, .5, D+0.15, 0.1)}
       box{<-10,0,-10><10,10,10>}
       rotate 180*z
     }

     intersection{
       object{rbox(.2, H+.2, D+0.08, 0.08)}
       box{<0,-10,-10><-10,10,10>}
       translate <-W/2+.055, H/2, 0>
     }
     
     intersection{
       object{rbox(.2, H+.2, D+0.08, 0.08)}
       box{<0,-10,-10>< 10,10,10>}
       translate < W/2-.055, H/2, 0>
     }
     
     union{
       cylinder{<0,0,0><0,.2,0>0.15}
       object{rfillet(0.15, 0.05)}
       translate <0, H+0.25, 0>
     }                         
     
     texture{ChromeTex}      
   }
   
   difference{
     #declare R = 0.7;
     cylinder{<0,0,0><0,0, 0.4>R}
     cylinder{<0,0,-1><0,0,1>R-0.02} 
     translate <0,H/2+0.1,0.3>
     texture{FanTex}  
   }
   
   cylinder{<0,0,0.19><0,0,.21>R-0.01
      translate <0,H/2+0.1,0.3>
      pigment{Black}
   }
   
   blob{
     threshold 0.6
     cylinder{<0,0,0><0,2,0>1.5, 1 scale<1,.5,1>} 
     #declare N = 0;
     #while (N < 360) 
       cylinder{<0,0,0><0,1,0>0.2, 1 translate  0.65*x rotate N*y}
       #declare N = N + 60;
     #end
     scale<1,.4,1> 
     scale 0.25
     translate<0, H+.4, 0>
     texture{ChromeTex} 
   }
  
   pigment{White*0.3}
}


#declare Engine=
union{                                   
   
   union{
     object{Sump }
     object{Block}   
     object{Block rotate 180*y}   
     object{ManifoldRight translate<-0.0342, 0.09397, 0>}   
     object{ManifoldLeft  translate< 0.0342, 0.09397, 0>}        
     object{Radiator translate<0,-0.3,-3.5>}
     
     texture{RoughAlloyTex}
   }
   
   object{Tank translate< 0, 0.2, -4.5>}
   
   scale 0.95
   translate<0, 2.5, -8.1>
   
    
}
