#include "Shapes.inc"
#include "FullPullTex.inc"

#declare ExhaustR1 = 0.15;
#declare ExhaustR2 = 0.18;
#declare L = 2.3;
#declare H = 4.5;

#declare RearPipe =  
union{
  intersection{
    blob{
      threshold 0.1
      cylinder{<0,0,6><0,0,-1.206>  ExhaustR1*1.21, 1}
      cylinder{<0,0,6><0,0, 0.1>    ExhaustR2*1.21, 1}
    }    
  
    cylinder{<0,0,L><0,0,-1.205> 10} 
  } 
  
  #declare R = 0.5;
  object{tube(R, 90, ExhaustR2) rotate 90*x translate <0,0,L> }
  cylinder{<0,0,0><0,H,0>ExhaustR2 translate<0, R, L+R>}
}

#declare ManifoldRight=
union{
   
 #ifdef (HighDef)
   #declare l = 0.598;    

     union{ 
       object{tube(.5, 81, ExhaustR1) rotate 90*y rotate 90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <-0.5,0,0> rotate -9*z translate -0.5*y} 
       object{ tube(.3, 75, ExhaustR1) rotate -180*z rotate 180*y translate <-0.5,-l,0> rotate -9*z translate -0.5*y}  
       rotate -15*x
       translate<-.5,0.3, -1.75> rotate 20*z translate<-0.55,1.2,0> 
     }

   #declare l = 0.495;    

     union{ 
       object{tube(.5, 80, ExhaustR1) rotate 90*y rotate 90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <-0.5,0,0> rotate -10*z translate -0.5*y} 
       object{ tube(.3, 90, ExhaustR1) rotate -180*z rotate 180*y translate <-0.5,-l,0> rotate -10*z translate -0.5*y}  
       translate<-.5,0.3, -1.05> rotate 20*z translate<-0.55,1.2,0> 
     }

   #declare l = 0.45;    

     union{ 
       object{tube(.5, 80, ExhaustR1) rotate 90*y rotate 90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <-0.5,0,0> rotate -10*z translate -0.5*y} 
       object{ tube(.3, 105, ExhaustR1) rotate -180*z rotate 180*y translate <-0.5,-l,0> rotate -10*z translate -0.5*y}  
       rotate 15*x
       translate<-.5,0.3, -0.35> rotate 20*z translate<-0.55,1.2,0> 
     }

   #declare l = 0.599;    

     union{ 
       object{tube(.5, 81, ExhaustR1) rotate 90*y rotate 90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <-0.5,0,0> rotate -9*z translate -0.5*y} 
       object{ tube(.3, 75, ExhaustR1) rotate -180*z rotate 180*y translate <-0.5,-l,0> rotate -9*z translate -0.5*y}  
       rotate -15*x
       translate<-.5,0.3,  0.35> rotate 20*z translate<-0.55,1.2,0> 
     }

   #declare l = 0.495;    

     union{ 
       object{tube(.5, 80, ExhaustR1) rotate 90*y rotate 90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <-0.5,0,0> rotate -10*z translate -0.5*y} 
       object{ tube(.3, 90, ExhaustR1) rotate -180*z rotate 180*y translate <-0.5,-l,0> rotate -10*z translate -0.5*y}  
       translate<-.5,0.3, 1.05> rotate 20*z translate<-0.55,1.2,0> 
     }

   #declare l = 0.45;    

     union{ 
       object{tube(.5, 80, ExhaustR1) rotate 90*y rotate 90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <-0.5,0,0> rotate -10*z translate -0.5*y} 
       object{ tube(.3, 105, ExhaustR1) rotate -180*z rotate 180*y translate <-0.5,-l,0> rotate -10*z translate -0.5*y}  
       rotate 15*x
       translate<-.5,0.3, 1.75> rotate 20*z translate<-0.55,1.2,0> 
     }

 #end  

   object{RearPipe translate <-1.3075,-0.0301,0>}
   
   texture{ChromeTex}
}

#declare ManifoldLeft=
union{
   
 #ifdef (HighDef)
   
   #declare l = 0.598;    
     
     union{ 
       object{tube(.5, 81, ExhaustR1) rotate -90*y rotate -90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <0.5,0,0> rotate 9*z translate -0.5*y} 
       object{ tube(.3, 75, ExhaustR1) rotate -180*z rotate 180*y translate <0.5,-l,0> rotate 9*z translate -0.5*y}  
       rotate -15*x
       translate<0.5,0.3, -1.75> rotate -20*z translate< 0.55,1.2,0> 
     }

   #declare l = 0.495;    

     union{ 
       object{tube(.5, 80, ExhaustR1) rotate -90*y rotate -90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <0.5,0,0> rotate 10*z translate -0.5*y} 
       object{ tube(.3, 90, ExhaustR1) rotate -180*z rotate 180*y translate <0.5,-l,0> rotate 10*z translate -0.5*y}  
       translate<0.5,0.3, -1.05> rotate -20*z translate<0.55,1.2,0> 
     }

   #declare l = 0.45;    

     union{ 
       object{tube(.5, 80, ExhaustR1) rotate -90*y rotate -90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <0.5,0,0> rotate 10*z translate -0.5*y} 
       object{ tube(.3, 105, ExhaustR1) rotate -180*z rotate 180*y translate <0.5,-l,0> rotate 10*z translate -0.5*y}  
       rotate 15*x
       translate<0.5,0.3, -0.35> rotate -20*z translate<0.55,1.2,0> 
     }

   #declare l = 0.599;    

     union{ 
       object{tube(.5, 81, ExhaustR1) rotate -90*y rotate -90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <0.5,0,0> rotate 9*z translate -0.5*y} 
       object{ tube(.3, 75, ExhaustR1) rotate -180*z rotate 180*y translate <0.5,-l,0> rotate 9*z translate -0.5*y}  
       rotate -15*x
       translate<0.5,0.3, 0.35> rotate -20*z translate< 0.55,1.2,0> 
     }

   #declare l = 0.495;    

     union{ 
       object{tube(.5, 80, ExhaustR1) rotate -90*y rotate -90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <0.5,0,0> rotate 10*z translate -0.5*y} 
       object{ tube(.3, 90, ExhaustR1) rotate -180*z rotate 180*y translate <0.5,-l,0> rotate 10*z translate -0.5*y}  
       translate<.5,0.3, 1.05> rotate -20*z translate<0.55,1.2,0> 
     }

   #declare l = 0.45;    

     union{ 
       object{tube(.5, 80, ExhaustR1) rotate -90*y rotate -90*z }
       cylinder{<0,0,0><0,-l,0> ExhaustR1 translate <0.5,0,0> rotate 10*z translate -0.5*y} 
       object{ tube(.3, 105, ExhaustR1) rotate -180*z rotate 180*y translate <0.5,-l,0> rotate 10*z translate -0.5*y}  
       rotate 15*x
       translate<.5,0.3, 1.75> rotate -20*z translate<0.55,1.2,0> 
     }
   
   #end
   
    object{RearPipe translate <1.3075,-0.0301,0>}
   

   
   texture{ChromeTex}
}
