#include "functions.inc"


#declare Flag1 =    

union{
  difference{
  
    isosurface{
      function { 
        f_rounded_box(
          x+0.1*(z+1.5)*f_noise3d(0, 5*y, 0)-0.25*(z+1.5)*f_noise3d(0, y-1, 0), 
          y+0.125*(z+1.5)*f_noise3d(0, (z+1.5)*y, 1*(z+1.5)), 
          z+0.0125*(z+1.5)*f_noise3d(0, (z+1.5)*y, z+1.5), 
          0.1, .005, 1, 1.5)
      }             
      max_gradient 3
      contained_by { box { -3, 3 } }
    }
  
    cylinder{<-10,0,0><10,0,0> 1 scale <1,1.55,1> translate <0,-0.08,-2.25> pigment{rgb<.25,0,0>}} 
  
    pigment{
      image_map{
        jpeg "Flag1.jpg" 
        interpolate 2
      }      
      translate<-0.5,-0.5,0>
      rotate 90*z
      rotate 90*y   
      scale 2.4
      translate <0,-0.125,0>
    } 
    
    normal{          
      bump_map{
        jpeg "FlagB.jpg" 
        bump_size 10
        interpolate 2
      }      
      translate<-0.5,-0.5,0>
      rotate 90*z
      rotate 90*y 
      rotate -90*x  
      scale <1,2.,3>
      translate <0,-0.05,0>
    }               
  
    finish{ambient 0.6} 
    translate<0,0,1.6> 
    rotate -9*y
    scale<1,1,1> 
    scale 1.5
  }  

  torus{.1, 0.025 translate<0,-1.4,0> pigment{Black}}
  torus{.1, 0.025 rotate 10*x translate<0,-1.5,0> pigment{Black}}
  torus{.1, 0.025 translate<0, 1.35,0> pigment{Black}}
  torus{.1, 0.025 rotate 20*x translate<0, 1.35,0> pigment{Black}}
  
  torus{.1, 0.025  scale <.5,1,1.5> rotate -20*x translate<0,-1.4,0.3> pigment{Black}}
  torus{.1, 0.025  scale <.5,1,1.5> rotate  20*x translate<0, 1.3,0.3> pigment{Black}}

}


#declare Flag2 =    

union{
  difference{
  
    isosurface{
      function { 
        f_rounded_box(
          x+0.2*(z+1.5)*f_noise3d(0, 4*y, 0), 
          y+0.15*(z+1.5)*f_noise3d(0, (z+1.5)*y, 1*(z+1.5)), 
          z+0.125*(z+1.5)*f_noise3d(0, (z+1.5)*y, z+1.5), 
          0.1, .005, 1, 1.5)
      }             
      max_gradient 3
      contained_by { box { -3, 3 } }
    }
  
    cylinder{<-10,0,0><10,0,0> 1 scale <1,1.55,1> translate <0,-0.08,-2.25>} 
  
    pigment{
      image_map{
        jpeg "Flag2.jpg" 
        interpolate 2.0
      }      
      translate<-0.5,-0.5,0>
      rotate 90*z
      rotate 90*y
      rotate 3*x   
      scale 2.4
      translate <0,-.15,0.05>
    }               
  
    
    normal{          
      bump_map{
        jpeg "FlagB.jpg" 
        bump_size 8
        interpolate 2
      }      
      translate<-0.5,-0.5,0>
      rotate 90*z
      rotate 90*y 
      rotate -90*x 
      rotate 180*z 
      scale <1,2.,3>
      translate <0,0.05,0>
    }               

    finish{ambient 0.5} 
    translate<0,0,1.55> 
    rotate 8*y 
    scale<1,1,1> 
    scale 1.5
  }  

  torus{.1, 0.025 translate<0,-1.4,0> pigment{Black}}
  torus{.1, 0.025 translate<0,-1.33,0> pigment{Black}}
  torus{.1, 0.025 translate<0, 1.3,0> pigment{Black}}
  torus{.1, 0.025 rotate -20*x translate<0, 1.2,0> pigment{Black}}

}
