#include "colors.inc"

light_source {
    <20, 20, -50>
    color  0.75 * White 
}                

light_source {
    <0, 5, -40>
    color  1 * White
    shadowless 
}                

camera{ 
    location <0,  5, -24>
    look_at  <0,  5.75,   0> 
    right image_width*x
    up    image_height*y
    angle 45
} 


#declare Sky = rgb<207/255, 221/255, 252/255>;  

sky_sphere{
  pigment{ 
    gradient y
    color_map {
      [0 0.45   color White     color White]
      [0.45 .55 color White     color Sky]
      [0.55 1   color Sky       color Sky]
    }
    scale 2
    translate -1
  }
  pigment{
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 0.2 color rgb <0.95, 0.95, 0.95>
                 color rgb <0.95, 0.95, 0.95>]
        [0.2 0.5 color rgb <0.95, 0.95, 0.95>
                 color rgbt <1, 1, 1, 1>]
        [0.5 1.0 color rgbt <1, 1, 1, 1>
                 color rgbt <1, 1, 1, 1>]
    }
    scale <0.2, 0.5, 0.2>
    rotate -90*z 
    rotate 10*y
  }
}


#declare HighDef = true; 
//#declare Driver     = true; 
#declare Motor      = true;
//#declare Spectators = true;    

//#declare Rotate     = true;
#declare Dust       = true;  
#declare Smoke      = true;  
//#declare Blur       = true; 

#include "Tractor.inc" 
#include "Sled.inc"  
#include "Scenery.inc"

union{
  
  object{Tractor rotate 14*x}
  object{Sled   }                               
  object{Scenery}
  
  rotate -40*y 
  translate <-2.8,0,0>
}

