#include "Metals.inc"

#declare Col1 = rgb<198/255, 226/255, 255/255>;   
#declare Col1 = rgb<1,1,1>;
#declare Col2 = rgb<1,0,0>;
#declare Col3 = rgb<47/255,47/255,220/255>; 



#declare Col1Tex = 
texture{
  pigment{ Col1 } 
  finish{phong 1 phong_size 200 reflection {0.0}}
}

#declare Col2Tex = 
texture{
  pigment{ Col2 } 
  finish{phong 1 phong_size 200 reflection {0.0}}
}

#declare Col3Tex = 
texture{
  pigment{ Col3 } 
  finish{phong 1 phong_size 200 reflection {0.0}}
}
 
#declare HeadTex = Col3Tex;

#declare FilterCoverTex = Col2Tex;

#declare FanTex = Col2Tex;

#declare ChromeTex = texture{T_Chrome_3D}

#declare LeatherTex = 
texture{
  pigment{ White*.3 }
  normal{wrinkles bump_size 1 scale .00125}
  finish{phong .8 phong_size 20}
}


#declare AlloyTex =
texture{pigment {color rgb <0.9843137,0.9843137,0.9843137> transmit 0} 
        finish{phong 1 phong_size 6.868523 diffuse 0.6*1 }}


#declare PolishedAlloyTex =
texture{pigment {color White*0.5 transmit 0}
        normal{bumps bump_size 0.5 scale 2} 
        finish{phong 1 phong_size 70 reflection{0.3} }}


#declare BodyTex = 
texture{
  pigment{
    crackle
    turbulence .6
    color_map{
      [0    Col2]
      [0.01 Col2]
      [0.05 Col1]
      [1    Col2]
    }
  } 
  scale .6
  finish{phong 1 phong_size 200 }
}


#declare Wheel1Tex =
texture{
  pigment{
    cylindrical
    turbulence .005
    color_map{
      [0     Col1]
      [0.45  Col1]
      [0.55  Col2 ]   
      [1     Col2 ]   
    }  
    rotate 90*z                   
    scale 1
  }
  finish{phong 1 phong_size 200}
}

#declare Wheel2Tex =
texture{
  pigment{
    cylindrical
    turbulence .005
    color_map{
      [0     Col1]
      [0.4   Col1]
      [0.65  Col2 ]   
      [1     Col2 ]   
    }  
    rotate 90*z                   
    scale 1
  }
  finish{phong 1 phong_size 200}
}

#declare SeatTex =
texture{
  pigment{White*0.1}
  normal{bumps bump_size 1 scale 0.25}
  finish{phong 0.4 phong_size 40}
}

#declare HubTex     = ChromeTex;

#declare Col3_dark = rgb<.1,.1,.7>;

#declare GuardTex =
texture{
  pigment{
    cylindrical
    turbulence 0
    color_map{
     [  0.0  Col1   ]
     [  0.1  Col1   ]
     [  0.25 Col2   ] 
     [  0.25 Col1   ]
     [  0.26 Col1   ]
     [  0.26 Col3_dark   ]
     [  0.27 Col3_dark   ]
     [  0.27 Col2   ]   
     [  0.3  Col2   ]
     [  0.4  Black  ]
     [  0.5  Col3_dark   ]
     [  1.0  Col3_dark   ]
    }         
    scale 4
    rotate -35*x
    translate <-0, 4, -1.5>
  }
}
texture{
 pigment{
   image_map{ jpeg "Logo.jpg" once interpolate 2.0 } 
   translate <-0.5,-0.5,0>
   scale <7.5,1.25,1>            
   rotate 10*x
   translate <0, 7.5, 0>
 }
  finish{phong 1 phong_size 200 reflection {0.1}}
}
texture{
  pigment{
    gradient y
    turbulence 0
    color_map{
     [  0.0  Clear   ]
     [  0.9  Clear   ]
     [  0.93 Clear   ]
     [  0.97 Col3_dark   ]
     [  0.98 Col2   ]
     [  1.0  Col2     ]
    }         
    scale 6.5
    translate <0, 1.5, 0>
  }
  finish{phong 1 phong_size 200 reflection {0.1}}
}

#declare PostTex =
texture{
pigment{
  gradient y
  color_map{
   [  0.0  Col3  ] 
   [  0.5  Black ]
   [  1.0  Col2  ]
  }         
  translate <0, -0, 0>
  scale <1,1.6,1>
}
  finish{phong 1 phong_size 200 reflection {0.1}}
}


#declare AirFilterTex =
texture{
  pigment{ rgb<1,1,0.8> } 
  normal{bumps bump_size 0.5 scale 0.01}       
}

#declare SledPlateTex =
texture{
  pigment{
    bozo
    color_map{
      [0 rgb<88/255, 64/255, 39/255>]
      [1 rgb<57/255, 51/255, 45/255>*1.5]
    
    }
  }
  normal{bumps bump_size 0.5 scale 0.1}
}

#declare PlateTex =
texture{
  pigment{
    checker Red White  
    translate -0.5*y
    scale <1,20,1>
  }
}

#declare GirderTex =
texture{
  pigment{
    bozo
    color_map{
      [0 rgb<88/255, 64/255, 39/255>*0.5]
      [1 rgb<57/255, 51/255, 45/255>]
    
    }
  }
  normal{bumps bump_size 0.25 scale 1}
  finish{phong 0.75 phong_size 60 }
}
  
#declare SledTex =
texture{
  pigment{  rgb<231/255, 128/255, 24/255> }
  finish{phong 0.5 phong_size 60 }
}

#declare BarrierTex =
texture{
  pigment{  White*0.75 }
  finish{phong 0.9 phong_size 100 }
}
#declare ChassisTex = 
texture{ 
  pigment{Red}
  finish{phong 1 phong_size 200}
}

#declare Dirt=
texture{
  pigment{rgb<77,57,26>/150}
  normal{bumps bump_size 0.1 scale 0.01}
}

#declare DirtyChassisTex = 
texture{ 
    gradient y 
    turbulence 0.2
    texture_map{
      [0   Dirt]
      [0.2 Dirt]
      [0.4 ChassisTex]
      [1   ChassisTex]
    }           
    translate<0,-0.32,0.6>
    rotate -4*x
    scale<1,3,1>
}

#declare CleanBoxTex =
texture{
  pigment{
  gradient y
  turbulence 0.025
  color_map{
   [  0.0    Col2   ]   
   [  0.2    Col2   ]   
   [  0.5    Black   ]   
   [  0.6    Col3   ]   
   [  1.0    Col3   ]
  }
  }  
  finish{phong 1 phong_size 200 reflection {0.1}}
}
 
#declare BoxTex = 
texture{ 
    gradient y 
    turbulence 0.1
    texture_map{
      [0   Dirt]
      [0.2 Dirt]
      [0.4 CleanBoxTex]
      [1   CleanBoxTex]
    }           
    translate -0.7*y       
    scale 2.7 
}

#declare RoughAlloyTex =
texture{
  pigment {color White*0.5 transmit 0}
  normal{bumps bump_size 0.3 scale 0.02} 
  finish{phong .6 phong_size 7 } 

}

  
#declare DirtyChromeTex =
texture{  
  gradient y     
  turbulence .25
  texture_map{
    [0    Dirt]
    [0.2  Dirt]
    [0.5  ChromeTex]
    [1    ChromeTex]
  }  
  scale 0.5
  translate<0,-0.02,0>
}
 

#declare TyreTex = 
texture{
  pigment{White*0.2}   
  normal{bumps bump_size 0.2 scale .01}
  finish{phong .6 phong_size 20}
}

#declare DirtyTyreTex =
texture{
  cylindrical   
  turbulence 0.0125
  texture_map{
    [0   Dirt]
    [0.4 Dirt]
    [0.5 TyreTex]
    [1   TyreTex]       
  }          
  scale 2
  rotate 90*z
}  
    
