#include "functions.inc"     
#include "FullPullTex.inc"

#declare cornerR = 0.25;
#declare seatW = 1;
#declare seatH = 1.75;
#declare seatL = 1;
#declare seatD = 0.25;


#macro Cushion(X, Y) 
   isosurface{
      function{ f_rounded_box(
         x + 0.025*f_noise3d(0, 6*y, 6*z), 
         y + 0.025*f_noise3d(6*x, 0, 6*z), 
         z + 0.025*f_noise3d(6*x, 0, 6*z), 
         cornerR, X, Y,seatD) 
      }
      contained_by{ box{<-X, -Y, -seatD><X, Y, seatD>} }
      accuracy 0.01
      max_gradient 3
   }
#end   


#declare Seat =
union{ 
  object{Cushion(seatW, seatH) translate <0, seatH, 0> rotate 7*x}
  object{Cushion(seatW, seatL) rotate 90*x translate <0, 0, -seatL>} 
  
  texture{SeatTex}
}
 