#include "FullPullTex.inc"   
#include "Shapes.inc"


// Tyre inner radius
#declare TR = 1.5;    
// Tyre thickness
#declare TT = 2; 
//Tyre width
#declare TW = 1.75;  
//Tread width
#declare tW = 0.2;




#declare BackTyre = 


difference{
  
  blob{
    threshold .1
    cylinder{<-TW/5, 0, 0> <TW/5, 0, 0> TR+TT, 1 }  
    sphere{ < TW/2 +TR, 0, 0> TR+TT*.8, -1 scale<1,1,1>}
    sphere{ <-TW/2 -TR, 0, 0> TR+TT*.8, -1 scale<1,1,1>} 
    
    #ifdef (HighDef)
      #declare N = 0;
      #while (N<360)
      
        cylinder{<  0, 0, 0><TW, 0, 0> tW, -1 rotate -20*y rotate  30*z translate <0,0, -TT*.8 -TR> rotate N*x }
        cylinder{<-TW, 0, 0>< 0, 0, 0> tW, -1 rotate  20*y rotate -30*z translate <0,0, -TT*.8 -TR> rotate N*x } 
      
        #declare N=N+12;
      #end
    #end
  }
  
  

  cylinder{ <-2*TW, 0, 0> <2*TW, 0, 0> TR }
  
  
  texture{DirtyTyreTex scale 2.75}
  
}    

#declare BackRim =

lathe
{
  cubic_spline 
  11
  <1.55,-0.69>
  <1.52,1.16>
  <1.61,1.3 >
  <1.61,1.37>
  <1.48,1.3>
  <1.42,0.52>
  <1.02,0.39>
  <0.62,0.39>
  <0.53,0.25>
  <0.04,0.27>
  <-0.85,0.06>

  rotate -90*z
  translate .05*x
  
  texture{Wheel1Tex scale 2.5}  
  
}

#declare Hub =

sphere{<0,0,0> .65 scale<.6, 0, 0> translate .2*x texture{HubTex}}

#declare LeftBackWheel =
  union{
    object{BackRim}    
    object{BackRim rotate 180*y}    
    object{Hub}
    
    #declare rn = seed(0);
    #include "Nuts.inc"
    #declare nutN = 0;
    #while (nutN<360)
      object{BoltHeadWash scale 0.1 rotate 360*rand(rn)*y rotate -90*z translate< .455, 0, .8> rotate nutN*x texture{ChromeTex}  }
      #declare nutN = nutN + 45;
    #end    
  }

#declare RightBackWheel =
  union{
    object{BackRim}    
    object{BackRim rotate 180*y}    
    object{Hub     rotate 180*y}
    
    union{
      #declare rn = seed(0);
      #include "Nuts.inc"
      #declare nutN = 0;
      #while (nutN<360)
        object{BoltHeadWash scale 0.1 rotate 360*rand(rn)*y rotate -90*z translate< .455, 0, .8> rotate nutN*x texture{ChromeTex}  }
        #declare nutN = nutN + 45;
      #end
      rotate 180*y
    }
  }
  
  

//Front inner radius
#declare TR = 0.75;
//Front width
#declare TW = .5;
//Front depth 
#declare TD = .3;
//Tread Depth
#declare DD = .075;
 
#declare FrontTyre =
difference{
  torus{ TR + TD/4, TD 
  scale<1, TW/TD, 1>
  rotate 90*z }
  
  union{
  
    cylinder{ <-100,0,0><100,0,0> TR }  
    torus{ TR + TD + DD/2, DD rotate 90 *z  translate -3*DD*x}
    torus{ TR + TD + DD/2 + .025, DD rotate 90 *z  }
    torus{ TR + TD + DD/2, DD rotate 90 *z  translate  3*DD*x}
  }
    

  texture{DirtyTyreTex}

}

#declare FrontHub =

lathe
{
  cubic_spline 
  8
  <0.31,-0.26>
  <0.74,0.43>
  <0.65,0.41>
  <0.57,0.12>
  <0.4,0.14>
  <0.41,0.19>
  <0.,0.19>
  <-0.77,0.2>



  rotate -90*z  
  texture{Wheel2Tex}  
  
}
                                    
#declare FrontWheel =
  union{
    object{FrontTyre} 
    object{FrontHub}
    object{FrontHub rotate 180*y}
    
  
  }
  
#declare RightFrontWheel =

  union{
    object{FrontWheel}
    sphere{<0,0,0> .2 scale<.5,1,1> translate -0.2*x texture{ChromeTex} }
    union{
      #declare rn = seed(0);
      #include "Nuts.inc"
      #declare nutN = 0;
      #while (nutN<360)
        object{BoltHeadWash scale 0.06 rotate 360*rand(rn)*y rotate -90*z translate< .21, 0, .3> rotate nutN*x texture{ChromeTex}  }
        #declare nutN = nutN + 72;
      #end
      rotate 180*y
    } 
    translate<0, TR + TD - 0.1, 0>                           
  }  
  
#declare LeftFrontWheel =

  union{
    object{FrontWheel}
    sphere{<0,0,0> .2 scale<.5,1,1> translate 0.2*x texture{ChromeTex} }
    union{
      #declare rn = seed(0);
      #include "Nuts.inc"
      #declare nutN = 0;
      #while (nutN<360)
        object{BoltHeadWash scale 0.06 rotate 360*rand(rn)*y rotate -90*z translate<  .21, 0, .3> rotate nutN*x texture{ChromeTex}  }
        #declare nutN = nutN + 72;
      #end
    }     
    translate<0, TR + TD - 0.1, 0>                  
  }  
  
#declare MudGuard = 

#declare th = 0.05;
#declare w = 8;
#declare R = 3.1;
#declare ww = 1.2;
#declare RR = 1.75;

intersection{
  
  difference{
    union{ 
      
      difference{        
        cylinder{<-w/2, 0, 0><w/2, 0, 0> R} 
        union{
        
          cylinder{<-w,0,0><w,0,0>R-th}
          box{<-w,-R-1,0><w, R+1, R+1>}        
          box{<-w,-R-1,-R-1><w, 0, R+1>}
        }
    } 

    difference{        
      cylinder{<-ww-th, 0, 0><ww+th, 0, 0> R} 
      union{        
        box{<-w,-R-1,0><w, R+1, R+1>}        
        box{<-w,-R-1,-R-1><w, 0, R+1>}
      }
    } 
    
    
    difference{        
      cylinder{<-w/2, 0, 0><w/2, 0, 0> RR}      
      union{
        
        cylinder{<-w,0,0><w,0,0>RR-th}
        box{<-w,-RR-1,0><w, RR+1, RR+1>}        
        box{<-w,-RR-1,-RR-1><w, 0, RR+1>}
      }
      rotate 180*x      
      scale<1,1,1.5>
      translate<0, R+RR-th, 0>
    } 
    
    box{<-w/2, 0, 0><w/2, -4, th> translate<0,0,-R> }
    
  }
  
  box{<-ww,-10,0,><ww,10,-10>}
  
  }
  
  
  union{
    union{
      cylinder{< ww,0,-10>< ww,0,10> w/2 - ww}
      cylinder{<-ww,0,-10><-ww,0,10> w/2 - ww} 
      scale <1,.75,1>
    }
    box{<-10,0,-10><10,10,10>}
    translate <0,.5, 0>
  }  
    
  translate <0, R, 0>
} 


#declare Disc =
lathe
{
  cubic_spline 
  6
  <-0.71,2.21>
  <0.54, 1.67>
  <0.42, 1.52>
  <0.2,  1.42>
  <0.12, 1.24>
  <0.1,  1>
}                          

#declare FrontAxle =
union{
    
  object{rbox(2.4,.3,.3,.05) }
   
  object{rbox(2,.5,.5,.15) scale <0.1,1,1> translate<-0.5, 0, 0>}
  object{rbox(2,.5,.5,.15) scale <0.1,1,1> translate< 0.5, 0, 0>}
  object{rbox(2,.5,.5,.15) scale <0.1,1,1> translate<-0.5, 0.3, 0>}
  object{rbox(2,.5,.5,.15) scale <0.1,1,1> translate< 0.5, 0.3, 0>}
  
  cylinder{<0,-.15,0><0,.15,0>.175 translate< 1.2, 0, 0>}
  cylinder{<0,-.15,0><0,.15,0>.175 translate<-1.2, 0, 0>}
  union{  
    object {Disc rotate  90*z translate <-.2 ,    0, 0>}
    object {Disc rotate -90*z translate < .2 ,    0, 0>}
    object{rbox(.1,.4,.4,.01) translate <-1.5 ,    0, 0>}
    object{rbox(.5,.1,.4,.01) translate <-1.3 ,  .21, 0>}
    object{rbox(.5,.1,.4,.01) translate <-1.3 , -.21, 0>}
    sphere{<0,0,0>0.1 scale <1,.95,1> translate <-1.25 ,  .2, 0>}
    sphere{<0,0,0>0.1 scale <1,.95,1> translate <-1.25 , -.2, 0>}
    object{rbox(.1,.4,.4,.01) translate < 1.5 ,    0, 0>}
    object{rbox(.5,.1,.4,.01) translate < 1.3 ,  .21, 0>}
    object{rbox(.5,.1,.4,.01) translate < 1.3 , -.21, 0>}
    sphere{<0,0,0>0.1 scale <1,.95,1> translate < 1.24 ,  .2, 0>}
    sphere{<0,0,0>0.1 scale <1,.95,1> translate < 1.24 , -.2, 0>}  
    
    object{rbox(.15,.1,.8,.01) translate <-1.175 , .21, 0.4>}
    object{rbox(.15,.1,.8,.01) translate < 1.175 , .21, 0.4>}  
    cylinder{<-1.2,.21,0.8>< 1.2,.21,0.8>0.08}
    sphere{ <-1.2,.21,0.8>0.1}
    sphere{ < 1.2,.21,0.8>0.1}
  }
  
  translate< 0, TR + TD - 0.1, 0>
}  
