/*
daz - pov pipeline			-noted here as a reminder to myself, there's a lot of people in this scene so I want to do this the simplest way possible

--
daz/poseray side:

each guy must be exported separately, to allow the same material names!
SWITCH OFF COINCIDENT BITS IN POSERAY! DAZ likes to hide things with materials, but any coincedent faces (e.g. alternative coincident collars) piss off pov
[avoid multiple image-file copies]

--
minimal changes to poseray output:
geom.inc - comment out materials! main pov source will include them directly

--
pov source:

#include "guy1_POV_mat.inc"
#declare <materialVariation> = <whatever knobs I twiddle>;
       //e.g. pants = "pinstripeblue", initial defaults at top of pov source
#include "material_override.inc"  //load shared materials
#include "guy1_POV_geom.inc"
#declare guy1_variation1 = object { <poseraybojectname> };


test this - one guy in scene twice with different materials (crucial thing,
redeclaration of a bunch of things must use latest declaration without
screwing stuff declared from previous. i.e. must behave like variables).

--
QED
--
*/



//--------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                global setup
//--------------------------------------------------------------------------------------------------------------------------------------------------

#version unofficial megapov 1.21;

#include "colors.inc" //used by poseray generated material files
#include "functions.inc"
#include "transforms.inc"
#include "rad_def.inc"

#declare crowd = on;
#declare boyEnable = on;
#declare placeholders = off;
#declare focalblur = on;
#declare hairFull = on;

global_settings {
	max_trace_level 8
	assumed_gamma 1
}

#declare defaultDiffuse = .6;
#default {	//material_override will use these defaults as much as possible.
	pigment { rgb 1 }
	finish { brilliance 2 diffuse defaultDiffuse ambient 0 } //brilliance 2 gives nice smooth lighting.
}

//--------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                characters
//--------------------------------------------------------------------------------------------------------------------------------------------------

//import poseray stuff

#declare standin = //roughly person sized
	union {
		union {
			//cylinder { 0, y*9, 1 }
			cone { 0, 0, y*(9*9-1*1)/9, 1 }
			sphere { 0, 1 translate y*9 }
			scale <.11,.065,.04>
		}
		intersection {
			sphere { 0, 1 }
			cone { -z, 2, z, 0 }
			scale <.03,.05,.04> translate y*.7
		}
	}

#if (!placeholders)
	//shared material defs, from poseray with some tweaking.
	//these get overridden by material_override, to allow variation without needing to re-load textures or hand-edit every single poseray file.
	#if (boyEnable | crowd)
		#include "dazTextures.inc"
	#end

	#if (crowd)
		#declare jacketColour = .1;
		#declare trouserColour = .1;    //grey
		#declare shirtColour = .8;
		#declare hairColour = <.2,.13,.1>;
		#include "material_override.inc"
		#include "guy1_POV_geom.inc"
		#declare guy1_variation1 = object { guy1_ double_illuminate };
	
		#declare jacketColour = .01;
		#declare trouserColour = .01;   //black
		#declare shirtColour = <.8,.7,.4>;
		#declare hairColour = <.6,.7,1.1>; //it's very yellow by default so compensate to get a more natural blonde
		#declare tiePattern = pigment { uv_mapping gradient x+y frequency 20 colour_map { [.1 rgb .7][.1 rgb x*.5][.5 rgb x*.5][.5 rgb .7][.6 rgb .7][.6 rgb z*.7] } }
		#include "material_override.inc"
		#include "guy1_POV_geom.inc"
		#declare guy1_variation2 = object { guy1_ double_illuminate };
	
		#declare jacketColour = <.01,.02,.06>;
		#declare trouserColour = <.01,.02,.06>; //navy blue
		#declare shirtColour = <.6,.7,1>*.8;
		#declare hairColour = <.03,.04,.08>; //some blue to balance to black
		#declare tiePattern = pigment { uv_mapping cells scale 1/20 colour_map { [0 rgb <.01,.02,.06>][1 rgb <.4,.6,.8>] } }
		#include "material_override.inc"
		#include "guy2_POV_geom.inc"
		#declare guy2_variation1 = object { guy2_ double_illuminate };
	
		#declare jacketColour = .05;
		#declare trouserColour = .05;	//dark grey
		#declare shirtColour = <.8,.7,.5>;
		#declare hairColour = <1,.8,.7>;//<.8,.3,.1>; //red head (use sparingly, looks too obvious)
		#declare tiePattern = pigment { uv_mapping gradient x+y frequency 20 colour_map { [.1 rgb .7][.1 rgb y*.3][.5 rgb y*.3][.5 rgb .7][.6 rgb .7][.6 rgb z*.7] } }
		#include "material_override.inc"
		#include "guy2_POV_geom.inc"
		#declare guy2_variation2 = object { guy2_ double_illuminate };
	
		#declare jacketColour = .01;
		#declare trouserColour = .01;	//black
		#declare shirtColour = .8;
		#declare hairColour = <.7,.5,.4>;
		#declare tiePattern = pigment { uv_mapping quilted scale .004 colour_map { [0 rgb .2][1 rgb 1] } }
		#include "material_override.inc"
		#include "guy3_POV_geom.inc"
		#declare guy3_variation1 = object { guy3_ double_illuminate };
	
		#declare jacketColour = <.095,.11,.1>;  //greenish
		#declare trouserColour = <.095,.11,.1>;
		#declare shirtColour = <.8,.7,.6>;
		#declare hairColour = <.3,.2,.15>;
		#declare tiePattern = pigment { uv_mapping quilted scale .004 colour_map { [0 rgb .03][1 rgb <.7,.5,.3>] } }
		#include "material_override.inc"
		#include "guy3_POV_geom.inc"
		#declare guy3_variation2 = object { guy3_ double_illuminate };
	#end

	/* white suit, orange shirt
	#declare jacketColour = 1;
	#declare trouserColour = 1;
	#declare shirtColour = <.2,.05,.01>;*/
	
	//girl


	#if (boyEnable)
		//the boy - DO NOT INCLUDE ANY ADULTS AFTER THIS! I screw with some global vars.
		#declare childSkin = on;	
	
		//replace shirt colour with a "borrowed from dad" effect	
		#declare p_map10 =
			pigment {
				uv_mapping
				pigment_pattern { quilted scale .002 }	//stitching
				pigment_map {
					[0 gradient x frequency 30 colour_map { [.15 rgb 1][.2 rgb <.8,.5,.4>][.4 rgb <.8,.5,.4>][.45 rgb 1] }]
					[2 rgb 0]
				}
			} 
		
		#declare trouserColour = <.15,.14,.12>;
		#declare shirtColour = .8;
		#declare hairColour = <.8,.4,.3>;
		#include "material_override.inc"
		#include "boy_POV_geom.inc"
		#declare boy = object { boy_ double_illuminate };
	#end
	
#else
	#declare guy1_variation1 = object { standin pigment { rgb .1 } };
	#declare guy1_variation2 = object { standin pigment { rgb z } };
	#declare guy2_variation1 = object { standin pigment { rgb y } };
	#declare guy2_variation2 = object { standin pigment { rgb y+z } };
	#declare guy3_variation1 = object { standin pigment { rgb x } };
	#declare guy3_variation2 = object { standin pigment { rgb x+z } };
	#declare boy = object { standin };
#end


#if (boyEnable)
	union {
		//the boy
		object { boy }
		
		//briefcase
		union {
			union {
				//main case
				superellipsoid { <.1,.1> scale <.02,.07,.1> }
	
				//handle
				cylinder { -z,z,1 scale <.004,.004,.03> translate y*.09 }
				cylinder { -y,y,1 scale <.004,.01,.004> translate <0,.08,.03> }
				cylinder { -y,y,1 scale <.004,.01,.004> translate <0,.08,-.03> }
				sphere { <0,.09,.03>, .004 }
				sphere { <0,.09,.03>, .004 }
				
				pigment { rgb .1 }
				normal { crackle .1 scale .003 slope_map { [0 <0,0>][.1 <1,1>][.1 <1,0>] } }
				finish { phong .3 phong_size 50 }
			}
			intersection {		//metal strip
				superellipsoid { <.1,.1> scale <.02,.071,.101> }
				plane { -x, .005 }
				plane { x, .005 }
				intersection {
					plane { -x, -.0005 }
					plane { x, -.0005 }
					inverse
				}
				finish { diffuse .1 phong .2 phong_size 10 specular .7 roughness 1/1000 }
			}
	
			translate <.152,.23,.02>
		}

		scale .97 //I made him big in Daz but now he's too tall!		
		rotate 200*y
		translate 0
	}
#end

#if (crowd)
	//the crowd
	//place them - this is the main crowd around the boy
	object { guy1_variation1 rotate 10*y translate <.2,0,-1.2> }
	object { guy1_variation2 rotate 150*y translate <-.7,0,1> }
	object { guy2_variation1 rotate 180*y translate <.4,0,-1> }
	object { guy2_variation2 rotate 210*y translate <-.4,0,1.5> }
	object { guy3_variation1 rotate 150*y translate <-.4,0,-1> }
	object { guy1_variation2 rotate -20*y translate <.4,0,1.5> }

	//clone them (clones should always face different direction so duplication is not obvious)
	//these guys are outside of the main group, mostly in the distance
	object { guy2_variation1 rotate -50*y translate <.6,0,6> }
	object { guy3_variation2 rotate -80*y translate <2,0,7> }
	object { guy1_variation1 rotate -50*y translate <1.1,0,5> }
	object { guy3_variation1 rotate 30*y translate <-.1,0,2.5> }	//DON'T MOVE THIS GUY! he's doing a great depth thing behind the boy.
	object { guy2_variation2 rotate 20*y translate <1,0,2.7> }
	object { guy3_variation2 rotate 210*y translate <.2,0,3.2> }
#end

                                                    

#if ( 0 )
	//ruler
	box { <0,0,.1>, <.05,2,.11>  pigment { gradient y frequency 100 colour_map { [.5 rgb 0][.5 rgb 1] } } }
	box { <.05,0,.1>, <.1,2,.11> pigment { gradient y frequency 10 colour_map { [.05 rgb 0][.05 rgb 1] } } }
	box { <.1,0,.1>, <.2,2,.11>  pigment { gradient y frequency 1 colour_map { [.005 rgb 0][.005 rgb 1] } } }
	
	//lighting comparison objects
	difference {
		union {
			sphere { <-.4,.2,0>, .2 }
			sphere { <-.4,.4,0>, .1 }
		}
		sphere { <-.4,.2,-.2>, .1 }
	}
	
	difference {
		superellipsoid { <.1,.1> }
		sphere { 0, 1.25 }
		scale .2
		translate <.4,.2,0>
	}
#end


//--------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                background
//--------------------------------------------------------------------------------------------------------------------------------------------------

//for a real weight, not a weighted average
#declare sumRealWeight = 0;
#macro RealWeight( w )
	#declare sumRealWeight = sumRealWeight + w;
	(w)
#end

#macro GetRealWeightSum()
	(sumRealWeight)
	#declare sumRealWeight = 0;
#end

#declare rs=seed(15);
#macro PavingSlab( posidx )
	//superellipsoid { <.03,.15>
	box { -.99, .99
		rotate x*90
		scale <.1,.01,.1>
		
		pigment { rgb .4 }
		finish { brilliance .5 }
		normal {
			pigment_pattern {
				average //averaged normals compute lighting for each normal, then average the results, but I want it to average the normals before computing lighting.
				pigment_map {
					[RealWeight(.01)
						pigment_pattern {
							cylindrical
							scale .5 translate .5
							warp { repeat x } warp { repeat y } warp { repeat z }
							colour_map { [.5 rgb 1][1 rgb 0] }
						}
						cubic_wave
						scale .01
						colour_map { [0 rgb 1][1 rgb 0] }
					]
					[RealWeight(.3)
						//cracks
						pigment_pattern { granite poly_wave 1/4 }
						cubic_wave
						translate -3*posidx //randomize per tile
					]
					[RealWeight(.009)
						//general noise
						granite poly_wave 2 colour_map { [0 rgb 1][1 rgb 0] } scale .015
					]
				}
			} GetRealWeightSum()
			accuracy 1/3000
		}

		rotate (<rand(rs),rand(rs),rand(rs)>*2-1)*<.5,.5,.5>   //nudge orientation
		translate -.01*y + .2*<posidx.x,0,posidx.y>
	}
	//mortar, on 2 sides
	union {
		difference {
			cylinder { <1,0,-1>, <1,0,1>, .1 }
			cylinder { <1,.1,-1.1>, <1,.1,1.1>, .02 }
		}
		difference {
			cylinder { <-1,0,1>, <1,0,1>, .1 }
			cylinder { <-1.1,.1,1>, <1.1,.1,1>, .02 }
		}
		translate -.1*y
		scale .1
		translate .2*<posidx.x,0,posidx.y>
		
		pigment { rgb <.2,.2,.15> }
	}
#end

union {
	#local Z=-3;
	#while ( Z < 60 )
		#local X=-17;
		#while ( X < 4 )
			PavingSlab(<X,Z>)
			#local X=X+1;
		#end
		#local Z=Z+1;
	#end
	rotate y*15
}


//random stuff

//trash can
#declare trashCan =
	union {
		difference {
			cone { 0, .1, .3*y, .125 }
			cone { 0, .08, .301*y, .105 }
			texture{ pigment { rgb <.9,.88,.8> } normal{ granite -.1 scale .04 } }
		}
		union {
			difference {
				sphere { .3*y, .125 }
				plane { y, .3 }
				sphere { 0, 1 scale <.07,.05,.2> translate <0,.355,0> } //hole
				sphere { .3*y, .11 } //inside
			}
			//rim
			superellipsoid { <1,.1> rotate x*90 scale <.13,.01,.13> translate .3*y }

			pigment { rgb .2 }
			finish { specular .3 roughness 1/200 reflection { .0, .2 falloff 5 } }
			//normal { wrinkles 1 scale .1 } //scratches
		}
	}

object {
	trashCan
	translate <-1.35,0,2.1>
	rotate y*15
}

object {
	trashCan
	//cylinder { 0, y*20, .5 pigment { rgb x } }
	rotate 90*y
	translate <-2.4,0,11.8>
	rotate y*15
}


//buildings (ground level facades)
#declare cement = texture{ normal{ granite -.1 scale .04 } }

//no specular
#declare glass = texture { pigment { rgb <.03,.1,.05> } finish { brilliance 4 specular 0 roughness 1/100 reflection { .05, 1 falloff 5 } } normal { spotted .3 scale .3 } }
union {
	box { 0,1 scale <1,9,4> texture { glass } }
	box { 0,1 scale <1.1,9,.1> translate 4*z }
	box { 0,1 scale <1.1,.3,4.1> translate y}
	difference {
		union {
			box { 0,1 scale <.5,1,.1> translate x+0*z}
			box { 0,1 scale <.5,1,.1> translate x+1*z}
			box { 0,1 scale <.5,1,.1> translate x+2*z}
			box { 0,1 scale <.5,1,.1> translate x+3*z}
			box { 0,1 scale <.5,1,.1> translate x+4*z}
		}
		box { 0, 1 scale <.3,.9,5> translate x*1.1-z/2 }
	}
	texture { cement }
	
	translate <-3,0,2>
	rotate y*15
}

#declare glass = texture { pigment { rgb <.03,.1,.05> } finish { brilliance 4 specular 3 roughness 1/100 reflection { .05, 1 falloff 5 } } normal { spotted .3 scale .3 } }
union {
	#local rs = seed(21);
	#local X=0;
	#while ( X < 8 )
		#local Y=0;
		#while ( Y < 3 )
			union {
				box { 0, <.5,-.5,.01> texture { glass translate (X*Y)*z } }
				difference { //frame
					box { <0,0,-.003>, <.5,-.5,.01> }
					box { <.03,.03,-.01>, <.47,-.47,.02> }
					pigment { rgb .04 }
					finish { specular .2 roughness 1/100 }
				}
				#if ( rand(rs) > .8 )
					//open window
					 rotate x*20
				#end
				translate x*X*.7+y*(Y+1)*1
			}
			#local Y = Y + 1;
		#end
		#local X = X + 1;
	#end

	#local X=0;
	#while ( X <= 8 )
		box { <-.2,0,-.05>, <0,20,2> translate x*X*.7 }
		#local X = X + 1;
	#end

	#local Y=0;
	#while ( Y < 3 )
		box { <0,0,-.02>, <8*.7,.5,.4> translate y*Y*1 }
		#local Y = Y + 1;
	#end
	
	box { <0,0,1.9>, <8*.7,20,2> }

	texture { cement }
	
	translate <-3,0,12>
	rotate y*15
}

intersection {
	box { 0, 1 }
	box { 0, 1 translate -.5 rotate y*45 scale 1.2 translate .5 }
	
	scale <8,30,4>
	
	texture {
		//glass
		pigment { rgb <.03,.1,.05> } finish { brilliance 4 specular 3 roughness 1/100 reflection { .05, 1 falloff 5 } } normal { spotted 1 scale 2
		warp { repeat x*.5 offset z-y } warp { repeat y*1 offset -y*2 } warp { repeat z*.5 offset x+y }
		} 
	}
	
	rotate y*85
	translate <-1,-5, 40> 
}

//ground/horizon
plane {
	y, -5
	pigment { rgb .2 }
	//normal { granite scale .1 }
}


//--------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                  lights
//--------------------------------------------------------------------------------------------------------------------------------------------------

light_source {
	//<-2,3,-1>*1000,
	<-1,3,-2>*1000,
	rgb <2,1.7,1.5>*1.5
	parallel point_at 0
	area_light x*400,z*400,16,16 adaptive 1 orient jitter
}

//highlights
light_source { <5,1,5>*1000, rgb .7 parallel point_at 0 }

//fill lights (fake rad)
light_source {	//sky light
	<3,2,-1>*1000, rgb <.2,.3,.5>
	parallel point_at 0
	shadowless
}

light_source {	//sky light
	<-2,3,-1>*1000, rgb <.2,.3,.5>
	parallel point_at 0
	shadowless
}

light_source {	//bounced
	//<-1,-2,-3>*1000, rgb .5 //too much light under the chin
	<-1,0,-3>*1000, rgb .3 //too much light under the chin
	parallel point_at 0
	shadowless
}
light_source {	//bounced
	<-1,-2,3>*1000, rgb .3 //too much light under the chin
	parallel point_at 0
	shadowless
}



//--------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                reflections
//--------------------------------------------------------------------------------------------------------------------------------------------------

//glow, to put nice highlights on shiny things.
sphere {
	0, 1
	
	pigment {
		pigment_pattern {
			pigment_pattern {
				aoi
				colour_map {
					[0 rgb 1]
					[.5 rgb 0]
				}
			}
			cubic_wave
		}
		poly_wave 5
		colour_map {
			[0 rgb 40 transmit 1]
			[1 rgb 40 transmit 0]
		}
	}
	finish { diffuse 0 ambient 1 }

	scale 4
	translate <3,3,-10>
}


//sphere { <.015,.705,-.02>, .004 finish { diffuse 0 reflection {.05,1 falloff 5} } }

//skyline for reflections
union {
	box { 0, <15,60,5> translate <0,0,-20> }
	box { 0, <15,60,5> translate <-50,0,-20> }
	box { 0, <15,60,5> translate <40,0,-30> }
	box { 0, <15,60,5> translate <-20,0,-50> }
	no_shadow
	no_image
}

//background { rgb .3*<.6,.9,1.5> }

#macro LazySky( _col, _pow, _transTop, _transBot )
	pigment {
		planar
		poly_wave _pow
		colour_map {
			[0 rgb _col transmit _transTop]
			[1 rgb _col transmit _transBot]
		}
	}
#end

sky_sphere {
	LazySky( z, 1, .5, 0 )
	LazySky( <1,1.2,1.4>, 4, 1, 0 )
}


//--------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                   view
//--------------------------------------------------------------------------------------------------------------------------------------------------


camera {
	right		x*image_width/image_height
	up			y

	direction	z*3 location <0,.8,-3> look_at <0,.4,0> //the shot

//	direction	z*2.4 location <0,.6,-2> look_at <0,.4,0> //full body and most of comparison objects
//	direction	z*5 location <0,.7,-2> look_at <0,.6,0> //head & waist framed
//	direction	z*10 location <0,.7,-2> look_at <0,.68,0> //head zoom
//	direction	z*50 location <0,.8,-3> look_at <-.01,.7,0> //eyes
//	direction	z*200 location <0,.8,-3> look_at <.015,.705,-.02> //left eye
//	direction	z*14 location <0,.7,-2> look_at <0,.63,0> //collar
//	direction	z*10 location <2,1,-3> look_at <.1,0,-.1> //paving slab
//	direction	z*8 location <1,2,-3>*15 look_at <0,2,3> //overhead

#if (focalblur)
	focal_point <0,.6,0> blur_samples 40 aperture .03
#end
}

//vignetting
#if (1)
	disc {
		0, z, 1
		pigment {
			spherical
			cubic_wave
			colour_map { [0 rgb 0][1 rgb 0 transmit 1] }
		}
		scale 1
		translate z*3
		scale .1
		Reorient_Trans(z, <0,.4,0>-<0,.8,-3>)
		translate <0,.8,-3>
	}
#end

//view frustum
#if (0)
	intersection {
		plane { x*3-z*image_width/image_height, 0 }
		plane { -x*3-z*image_width/image_height, 0 }
		plane { y*3-z, 0 }
		plane { -y*3-z, 0 }
		plane { z, 8 }
		
		pigment { gradient z scale 8 colour_map { [0 rgb <.3,.6,1> transmit .5][1 rgb <.3,.6,1> transmit 1] } }
		
		Reorient_Trans( z, <0,.4,0>-<0,.8,-3> )
		translate <0,.8,-3>
		
		hollow on
	}
#end
