/*
#include "colors.inc"
background { color SkyBlue}
camera {
    location <-3, -2, 17>
    look_at  <0, -4, 0>
    //location <7, 0, -3>
    //look_at  <0, 0, 0>
}
//light_source { <17, 9, 12> color White}
//light_source { <-8, 2, 6> color White}

sky_sphere{S_Cloud4}
plane {
    y*1.4, -10.01
    pigment{P_WoodGrain1A}
    //pigment {checker Black,White scale 4}
    texture{T_Wood16}
    //finish { reflection {.4} }

  }
*/
#declare pet = object{
difference{
  intersection{
    union{ 
      difference{
        sphere { <0, .5, 0>, 1
          pigment{color Red}
          scale<2,1,1>
          normal {wrinkles 0.3}
          finish{ ambient 0.2 diffuse 0.7 phong 0.2 phong_size 10}
        }
        sphere { <0, .5, 0>, .999
          pigment{color Red}
          scale<2,1,1>
          normal {wrinkles 0.3}
          finish{ ambient 0.2 diffuse 0.7 phong 0.6 phong_size 10}
        }
      }
      difference{
        sphere { <0, -.5, 0>, 1
          pigment{color Red}
          scale<2,1,1>
          normal {wrinkles 0.3}
          finish{ ambient 0.2 diffuse 0.7 phong 0.6 phong_size 10}
        }
        sphere { <0, -.5, 0>, .999
          pigment{color Red}
          scale<2,1,1>
          normal {wrinkles 0.3}
          finish{ ambient 0.2 diffuse 0.7 phong 0.6 phong_size 10}
        }
      }  
    }
    sphere { <0, 0, 0>, 1
      pigment{color Red}
      scale<1.6,1,1>
      normal {wrinkles 0.3 scale <0.0001,0.0001,1000>}
      finish{ ambient 0.2 diffuse 0.7 phong 0.6 phong_size 10}
    }
  }
  sphere { <0, 0, 0>, 1
    pigment{color Red}
    scale<2,1,1>
    finish {
            ambient .2
            diffuse .6
            roughness .2
          }
    translate<0,0,-.19>
  }
}
rotate<0,15,0>
}

/*
#declare mini = object{
  difference{
    difference{
      sphere { <0, 0, 0>, .09
        pigment{color Red}
        scale<0,0,3.5>
      }
      sphere { <0, 0, 0>, .0899
        pigment{color Red}
        scale<0,0,3.5>
      }
    }
    box{<0,5,5>,<5,-5,-5>
      pigment{color Red}
    }
  }
  rotate<20,0,0>
  translate<-.3,0,.8>  
}

#declare i = 0;
#while(i < 2)
object{mini
  rotate<0,0,i>
  translate<4,0,0>
}
#declare i = i+40;
#end

#include "functions.inc"

#declare Sphere = function {f_sphere(x, y, z, .3) - f_noise3d(x * 5, y * 5, z * 5) * 0.8}
isosurface {
  function { Sphere(0,0,.4) }
  //max_gradient 4
  contained_by { sphere{<0,0,.4>,.31} }
  //threshold Threshold
  pigment {color White}
}
*/
 
   
#declare main = merge {
object{pet
  rotate<0,0,90>
  translate<0,-1.4,0>
}
object{pet
  rotate<0,0,270>
  translate<0,1.4,0>
}
object{pet
  rotate<0,0,180>
  translate<1.4,0,0>
}
object{pet
  rotate<0,0,0>
  translate<-1.4,0,0>
}
object{pet
  rotate<0,0,-30>
  translate<-1.2,.7,0>
}
object{pet
  rotate<0,0,210>
  translate<1.2,.7,0>
}
object{pet
  rotate<0,0,30>
  translate<-1.2,-.7,0>
}
object{pet
  rotate<0,0,-210>
  translate<1.2,-.7,0>
}
object{pet
  rotate<0,0,-60>
  translate<-.7,1.2,0>
}
object{pet
  rotate<0,0,240>
  translate<.7,1.2,0>
}
object{pet
  rotate<0,0,60>
  translate<-.7,-1.2,0>
}
object{pet
  rotate<0,-30,-60>
  translate<.7,-1.2,0>
}
}
#declare flower = merge{
object{main}
object{main
  rotate<0,0,15>
  scale .95
  translate<0,0,-.4>
}
sphere{<0,0,.4>,.31
  //pigment{color White}
  pigment {
    granite
    turbulence 1
    color_map {
      [0.0 color Gray30]
      [0.5 color White]
      [1.0 color Gray30]
    }
  }
  finish {
        roughness .9
    }
}
}
#declare PT0 = <4.50, -1.50>;
#declare PT1 = <1.50, -3.00>;
#declare PT2 = <1.00, -4.50>;
#declare PT3 = <2.00, -5.50>;
#declare PT4 = <3.00, -8.00>;
#declare PT4 = <1.00, -10.00>;

#declare vaseM = lathe {
    quadratic_spline
    5,
    PT0,
    PT1,
    PT2,
    PT3,
    PT4
    pigment { rgbt<.3,.01,.8,.3> }
}


//put it all together

#declare fullflowerthing = merge{

object{flower
 translate<1.8,1.5,0>
 rotate<0,15,0>
 translate<0,0,.7>
}
object{flower
 translate<-1.8,-.5,0>
 rotate<0,-30,0>
 translate<0,0,.7>
}
difference{  
  object{vaseM
   hollow
  }
  union{
    cylinder{<0,-2.9,0>,<0,-3.16,0>,1.3
      pigment { rgbt<.3,.01,.8,.3> }
    }
    cylinder{<0,-3.15,0>,<0,-3.3,0>,1.2
      pigment { rgbt<.3,.01,.8,.3> }
    }
  }
}
     
sphere_sweep {
  cubic_spline
  5,
  <.9,-10,0>, .12
  <.84,-9.94,0>, .1
  <-.7, -4.00,-.1>, .09
  <-1.7,-.9,-.4>, .1
  <-1.9,-.8,-.6>, .11
  tolerance 0.1
  pigment{color ForestGreen}
}
sphere_sweep {
  cubic_spline
  5,
  <0,-10,.9>, .12
  <0,-9.94,.84>, .1
  <-.1, -4.00,.73>, .09
  <1.7,1.9,-.4>, .1
  <1.9,1.8,-.6>, .11
  tolerance 0.1
  pigment{color ForestGreen}
}
}
