// Persistence of Vision Ray Tracer Scene Description File
// File: wheel.pov
// Vers: 3.6
// Desc: speedy wheel
// Date: 20051202
// Auth: Roef Mahlmann
//

#version 3.6;
#include "colors.inc"

//-----------------------------------------------------------------------------
#declare simple=0;              //1=simpel 0=niet simpel
#declare multiple=1;            //0=een 1=meerdere standen;
#declare multicolor=0;          //veel kleuren

//-----------------------------------------------------------------------------
global_settings {
  assumed_gamma 1.0
  ambient_light 2
}

//-----------------------------------------------------------------------------
camera{location <-5,54,-145> look_at<5,33,0>angle 25}  //final view
//camera{location <0,54,550> look_at<0,53,-100>angle 22}    //wall
//camera{location <-150,154,-150> look_at<0,30,0>}        //overview

light_source {<-200, 200, -300>  color White }
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

plane { y, 0 pigment { color rgb <0.9,0.7,0.5> } }

//--- band --------------------------------------------------------------------
#macro band(transp)
  intersection{
    difference{
      cylinder{<0,-10,0><0,10,0>,28}
      cylinder{<0,-11,0><0,11,0>,22}
    }  
    torus{33,19}
    texture{pigment{color rgbt<0.1,0.1,0.1,transp>}}
  rotate<90,0,0>         
  }
#end

//--- velg --------------------------------------------------------------------
#macro velg(transp)
  union{
    torus{22,0.2 translate<0,-9.5,0>}   //randje
    difference{
      cylinder{<0,9.5,0><0,-9.5,0>22}
      cylinder{<0,10 ,0><0,-10 ,0>20}
      torus{18,2.7 translate<0,-9.5,0>}
      texture{pigment{color rgbt<0.6,0.6,0.6,transp>}}
    }
    torus{20.2,0.2 translate<0,-7.7,0>} //randje
    difference{
      torus{13,10}
      torus{13,7}
      cylinder{<0,0,0><0,10,0>,23.1}
      #declare R0=5;	//aantal spaken
      #declare R1=1.7;	//grootte van de ronding
      #declare R2=7;	//hoever uit het midden
      #declare R3=R0;	//spaken teller
      #while (R3>0)
        union{
          cylinder{<R2,-10,0><R2,10,0>,R1}
          box{<0,-10,R1><18,10,-R1>rotate<0, 180/R0+3,0>translate<R2,0,0>}
          box{<0,-10,R1><18,10,-R1>rotate<0,-180/R0-3,0>translate<R2,0,0>}
          pigment{color Red}
          rotate<0,R3*360/R0,0>
        }
      cylinder{<0,-10,0><0,10,0>,1 scale<12,1,9>translate<21,0,0>
        rotate<0,R3*360/R0,0>
      }
      #declare R3=R3-1;
    #end
    }
#if (simple=0)
    cylinder{<0,0,0><0,-2,0>,3
      texture{
        pigment{color rgbt<0.6,0.6,0.6,transp>}
        finish{reflection 0.7}
      }
    }
    texture{pigment{color rgbt<0.6,0.6,0.6,transp>}finish{reflection 0.07}}
#else
    texture{pigment{color rgbt<0.6,0.6,0.6,transp>}}
#end
  rotate<90,0,0>         
  }
#end
//--- remschijf ---------------------------------------------------------------
#macro remschijf(transp)
  difference{  
    cylinder{<0,0,0><0,0.5,0>,14}
#if (simple=0) 
    union{
      #declare gt_tt=40;
      #declare gt_nr=0;
      #while (gt_nr<gt_tt)
        cylinder{< 7,-0.1,0>< 7,0.6,0>,0.20 rotate<0,gt_nr/gt_tt*360,0>}
        cylinder{< 8,-0.1,0>< 8,0.6,0>,0.20 rotate<0,gt_nr/gt_tt*360+7,0>}
        cylinder{< 9,-0.1,0>< 9,0.6,0>,0.20 rotate<0,gt_nr/gt_tt*360+14,0>}
        cylinder{<10,-0.1,0><10,0.6,0>,0.20 rotate<0,gt_nr/gt_tt*360+21,0>}
        cylinder{<11,-0.1,0><11,0.6,0>,0.20 rotate<0,gt_nr/gt_tt*360+28,0>}
        cylinder{<12,-0.1,0><12,0.6,0>,0.20 rotate<0,gt_nr/gt_tt*360+35,0>}
        #declare gt_nr=gt_nr+1;
      #end
      pigment{color Red}
    }
  texture{pigment{rgbt<0.50,0.50,0.50,transp>} finish{reflection 0.75} }
#else
  texture{pigment{rgbt<0.50,0.50,0.50,transp>}}
#end    
  translate<0,-1,0>
  rotate<90,0,0>            //rechtop zetten
}
#end

//--- remklauw ----------------------------------------------------------------
#macro remklauw(transp)
superellipsoid {
  <0.5, 0.5> 
  scale <5,5,5>
  translate<-12,0,0>
  texture{pigment{rgbt<1,0,0,transp>}}
  rotate<90,0,0>         
}
#end

//--- bodywork ----------------------------------------------------------------
#macro body(transp)
union{
  difference{
    difference{                         //body
      union{
        sphere{<0,0,0>,50  #if (multicolor=1) pigment{color Blue} #end }
        cylinder{<0,0,0><0,0,200>,50}
        sphere{<0,0,200>,50 #if (multicolor=1) pigment{color Green} #end }
      }
      box{<-50,-60,-50><50,-20,50>}     //grondspeling
      scale<3,1,0.3>
      translate<70,0,0>
    }
    cylinder{<0,0,-50><0,0,20>,30 pigment{color Gray30}}        //wielkast
  }
  union{
    sphere{<0,0,0>,40 #if (multicolor=1) pigment{color Red} #end }
    cylinder{<0,0,0><0,0,50>,40}
    sphere{<0,0,50>,40 #if (multicolor=1) pigment{color Red} #end }
    scale<2,1,0.5>
    translate<100,40,20>
  }
#if (simple=0)
  texture{pigment{rgbt<1,1,0,transp>}finish{reflection 0.3}}
#else
  texture{pigment{rgbt<1,1,0,transp>}}
#end
}
#end  

//--- wall used for reflection ------------------------------------------------
box{<-100,0,-150><100,200,-160>
  texture{pigment{
    brick      
    color rgb<0.7,0.5,0.0>,          // color of mortar
    color rgb<0.5,0.3,0.0>            // color of brick
    brick_size <15,7,7>   // size of brick    (optional)
    mortar     0.5       // width of mortar  (optional)
    turbulence 0.2
  }}
  no_shadow
}
box{<-100,0,-50><100,5,-150>
  texture{pigment{
    brick      
    color rgb<0.1,0.1,0.1>,          // color of mortar
    color rgb<0.3,0.3,0.3>            // color of brick
    brick_size <30,30,30>   // size of brick    (optional)
    mortar     0.5       // width of mortar  (optional)
    turbulence 0.2
  }}
  no_shadow
}


//--- car multiple ------------------------------------------------------------
#if (multiple=1 )
#declare rol=1;
#declare rtt=5;
#while (rol<=rtt)
  #declare afst=rol*5;                     //horizontale verplaatsing
  #declare drai=-afst/(2*3.14*30)*360;      //rotatie vh wiel
  #declare transp=rol/rtt;
  object{band(transp) rotate<0,0,drai> translate<afst,30,0>}
  object{velg(transp) rotate<0,0,drai> translate<afst,30,0>}
  object{remschijf(transp) rotate<0,0,drai> translate<afst,30,0>}
  object{remklauw(transp) rotate<0,0,0> translate<afst,30,0>}
  object{body(transp)translate<afst,30,0>}
  #declare rol=rol+1;
#end

#else
//--- car once ----------------------------------------------------------------
union{
  object{band(0)}
  object{velg(0)}
  object{remschijf(0)}
  object{remklauw(0)}
  object{body(0)}
  translate<0,30,0>
}
#end
