// Abandon All Hope
// A scene of the Ninth Circle of Hell from Dante's Divine Comedy, a.k.a. Dante's Inferno
// POV-Ray script by Alexandre Dorion (alexandre.dorion@rogers.com)
// For submission to IRTC Fire & Ice - February 2006

#declare eternity = on;  // turns on focal blur and softer lighting. Very long render time!!
#declare terror = on;  // tilts the camera
#declare gas = on;   // turns on the fire on the upper levels. Kept off during troubleshooting for faster render.

// HEADER
#version 3.6;
global_settings {assumed_gamma .8 max_trace_level 7}
#include "colors.inc"
#include "textures.inc"
#include "functions.inc"
#include "lucifer.inc"
#include "skull.inc"
#declare evil = seed(666);
#declare lucy_spot= <-35,3,100>;

// CAMERA
camera {location <0,4,-3> right x*image_width/image_height look_at <0,4,0>
	#if (terror = on) rotate z*7 #end
	#if (eternity = on) focal_point lucy_spot blur_samples 20 aperture .15 #end }

// FOG
fog {fog_type 2 distance 280 color rgb <.2,.2,.25> fog_offset 1 fog_alt 2 turbulence .6 }

// FROZEN LAKE                                                                            
plane { y, 0 texture { pigment {crackle color_map{[0 rgbt <0,0,0,.3>][1 rgb <.3,.3,.3,.3>]} turbulence .6 scale 7}
	normal {crackle .1 turbulence .6 scale 7} finish { ambient .2 diffuse .4 phong .4 reflection 0} } }


// STONE TEXTURES
#declare layered_stone = texture{ pigment{ granite scale 3 turbulence .5 
	color_map{[0 color rgb 0][.1 color rgb .5][.3 color rgb .3][1 color rgb 0]} scale .1 }             
	normal {bumps .75 scale .01} finish {ambient 0 diffuse .5 phong .1} scale .5}

#declare flat_stone =  texture { Rust finish {ambient 0 diffuse 0.2 phong 0.1 } }

#declare flat_stone2 =  texture { Rust normal {bumps .3 scale .1 } finish {ambient 0 diffuse 0.2 phong 0.1 } }

// STAIRS
#declare q1 = isosurface { function{ f_rounded_box(x,y,z,0.3,1.4,0.9,0.9)-(f_noise3d(x,y,z))*.15} contained_by {box {<-2,-1,-1>,<2,1,1>}} scale x*2 } ;

#declare stairway = union { 
#declare n = 0;
#while (n < 35)
        #declare m=0;
        #while (m<=n)
                object {q1 texture {flat_stone2 rotate 90*rand(evil)} rotate z*(-5+10*rand(evil)) translate <-.2+.4*rand(evil),.1+n-m,5+n>}
                #declare m=m+1;
        #end           
        #declare n=n+1;
#end
union {
#declare k=-15;
#while (k<15)
	#declare j=0;
	#while (j<16)
		object {q1 texture {flat_stone2 rotate 90*rand(evil)} rotate z*90 translate <-.2+j,-2.5,5-k> translate y*.1*rand(evil)}
		object {q1 texture {flat_stone2 rotate 90*rand(evil)} rotate z*90 translate <-.2-j,-2.5,5-k> translate y*.1*rand(evil) }
		#declare j=j+1.5;
        #end
 	#declare k=k+1.5;
#end }}
object {stairway scale .8 rotate y*60 translate <4,0,25>}

// STALAGMITES
height_field{ jpeg "hell.jpg" smooth texture {flat_stone} scale <100,8,100> translate <-50,-1.5,2> }
height_field{ jpeg "hell.jpg" smooth texture {flat_stone} scale <150,10,150> translate <-75,-5,125> }


// UPPER CIRCLES
#declare q2 = isosurface { function{ f_torus( x,y,z, 0.75, 0.25)-(f_noise3d(10*x,2*y,2*z)*.2)} contained_by {box {-1,1}} }

#declare n = 1;

#declare circles = union {
#while (n<8)
	object {q2 texture {layered_stone} rotate y*180*rand(evil) scale <1000,100,1000> translate n*<0,100,100>}
	#declare n=n+1;
#end }
object {circles}

// FIRE
#declare fire1 = color_map {[0 color rgbt <0,0,0,1>][.3 color rgbt <1,0,0,.4>][.6 color rgbt <1,.5,0,.1>][1 color rgbt <1,0,0,0>]}

#declare fire2 = color_map {[0 color rgbt <0,0,0,1>][.4 color rgbt <1,0,0,.4>][.8 color rgbt <1,.5,0,.1>][1 color rgbt <1,0,0,0>]}

#declare air = material {texture{pigment{rgbt <0,0,0,1>} finish {ambient 0 diffuse 0 reflection 0 } } }

#declare firelight = light_source { <0,1,0> color Red*.4 fade_distance 80 fade_power 2
	#if (eternity = on) area_light <2,0,0> <0,0,2> 4,4 adaptive 0 jitter circular orient #end }

#declare fireball1 = union { sphere { 0, 1 hollow on material { air } interior
	{ media { emission 3 density { spherical color_map { fire1 } turbulence (2+rand(evil)) scale .3 rotate y*(35+10*rand(evil))} }
	media { emission 3 density { spherical color_map { fire2 } turbulence (2+rand(evil)) scale .3 } }
	} scale (1+rand(evil)) rotate y*180*rand(evil) } object {firelight} }

#declare firecolumn1 = union{ cylinder { 0, y, 1 hollow on material { air } interior {
	media { emission 3 density { spherical color_map { fire1 } turbulence (2+rand(evil)) scale .3 rotate y*(-90+180*rand(evil))} }
	} } object {firelight} }

#declare firecolumn2 = union{ cylinder { 0, y, 1 hollow on material { air } interior {
	media { emission 3.5 density { spherical color_map { fire2 } turbulence (2+rand(evil)) scale .2 rotate y*(-90+180*rand(evil))} }
	} } object {firelight scale .2} }


#if (gas = on)
#declare fc1=1;
#while (fc1<60)
	#declare fc_loc = trace (circles, <-400+800*rand(evil),5000,480+600*rand(evil)>,-y);
	#if (vlength(fc_loc) > 0)
		object {firecolumn1 scale rand(evil)*<20,70,20> rotate (-90+180*rand(evil))*y translate fc_loc}
		#declare fc1=fc1+1;
	#end
#end 
#end

//THE BOSS
object {lucy scale 4 rotate <0,130,0> translate lucy_spot}

light_source {lucy_spot+<20,5,-20>, color rgb <1,.1.1> fade_distance 75 fade_power 2
	#if (eternity = on) area_light <2,0,0> <0,0,2> 4,4 adaptive 0 jitter circular orient #end }   

object {firecolumn1 scale <1,12,1> rotate <90,-50,0> translate lucy_spot+<19,3.7,-20>} 

object {fireball1 scale <3,2,2> translate lucy_spot+<21,3.7,-20>}    

//SKULLS
#declare skloc = <0,4,0>;

#declare s = 0;

#while (s<10)
        object {skull translate -skloc scale 2 rotate <15,-10+20*rand(evil),10*rand(evil)> translate <9.4+s,0.1+.15*rand(evil),24.2+s*.15>}
        #declare s=s+1.2;
#end
object {skull translate -skloc scale 2 rotate <15,45,0> translate <6,0,30.5>}
object {skull translate -skloc scale 2 rotate <15,-45,30> translate <-2.5,0,8>}
light_source { <-5,5,-5> rgb <1,1,0>*.06 spotlight radius 1 falloff 10 point_at <-2.5,0,8> fade_distance 50 fade_power 2 }

//BIG FLAME
#if (gas = on)
	object {firecolumn2 rotate y*180 scale <5,25,3> translate <13.5,0,22>}
#end

//SMOKE
#declare smoke = color_map {[0 color rgbt <0,0,0,1*.01>][.3 color rgbt <.2,.2,.2,.2>*.01][1 color rgbt <.1,.1,.1,.2>*.01]}
cylinder { 75*y, 200*y, 350 hollow on material {air} interior{ media{ emission .3 density {cylindrical color_map {smoke}
turbulence 3 scale 180}}} scale <1.5,1,1> translate <50,25,0> } 
