#include "colors.inc"
#include "woods.inc"
#include "stones.inc"
#include "metals.inc"
#include "atextures.inc"    
#include "aobjects.inc"

//+H228 +W432 +AM2 +A0.2 +R5
//+W1024 +H512 +AM2 +A0.2 +R5
//Window Pane  +sc0.507042 +sr0.091858 +ec0.649452 +er0.674322

#declare constructionlight=0;
#declare mediacandle=1;
#declare smoke=0;
#declare radio=1;
#declare radioQuality=0.01; //Lower=BetterLongerRenderTimes {0.004}
#declare widescreen=0;
		
camera { location <0*Feet,0*Feet,-5*Feet>
        look_at <0,0,0>
        translate <0,0,5*Feet>
        //rotate y*-10
        #if (widescreen=1)
        up y right x*16/9
        #end
        translate <0*Feet,1.7*Feet,10*Feet>
        }
#if ( constructionlight = on )
light_source {
  0*x
  color rgb <1,1,1>
  translate <0*Feet, 6*Feet, 6*Feet>
}
#end


//// ////////// ////
//// // Room // ////
//// ////////// ////
box { <-8*Feet, 0*Feet, 0*Feet>, <-6*Feet, 8*Feet, 12*Feet> hollow on texture { Stucco } }//-XWall
box { <6*Feet, 0*Feet, 0*Feet>, <8*Feet, 8*Feet, 12*Feet> hollow on texture { Stucco } }//+XWall
box { <-8*Feet, 0*Feet, 0*Feet>, <8*Feet, 8*Feet, -2*Feet> hollow on texture { Stucco } }//-ZWall
box { <-8*Feet, 8*Feet, -2*Feet>, <8*Feet, 8*Feet, 12.5*Feet> hollow on texture { Stucco } }//+YWall
box { <-8*Feet, 0*Feet, -2*Feet>, <8*Feet, 1*Feet, 12.5*Feet>  hollow on texture { T_Stone24 } }//Floor
difference {
box { <-8*Feet, 0*Feet, 12*Feet>, <8*Feet, 8*Feet, 12.5*Feet> hollow on texture { Stucco } }//+ZWall
box { <-1*Feet, 1*Feet, 11*Feet>, <1*Feet, 4*Feet, 15*Feet> texture { Stucco } }//Window Cutout
           }
union {
box { <-1*Feet, 1*Feet, 13*Feet+10.45>, <-.5*Feet, 2*Feet, 13*Feet+11> texture { GGlass1 } texture { frost1 } }//Glass Pannel
box { <-1*Feet, 1*Feet, 13*Feet+10.45>, <-.5*Feet, 2*Feet, 13*Feet+11> texture { GGlass1 } texture { frost2 } translate x*.5*Feet }//Glass Pannel
box { <-1*Feet, 1*Feet, 13*Feet+10.45>, <-.5*Feet, 2*Feet, 13*Feet+11> texture { GGlass1 } texture { frost3 } translate x*1*Feet }//Glass Pannel
box { <-1*Feet, 1*Feet, 13*Feet+10.45>, <-.5*Feet, 2*Feet, 13*Feet+11> texture { GGlass1 } texture { frost1 } translate x*1.5*Feet }//Glass Pannel
box { <-1*Feet, 1*Feet, 13*Feet+10.45>, <-.5*Feet, 2*Feet, 13*Feet+11> texture { GGlass1 } texture { frost2 } translate y*1*Feet }//Glass Pannel
box { <-1*Feet, 1*Feet, 13*Feet+10.45>, <-.5*Feet, 2*Feet, 13*Feet+11> texture { GGlass1 } texture { frost3 } translate y*1*Feet translate x*.5*Feet }//Glass Pannel
box { <-1*Feet, 1*Feet, 13*Feet+10.45>, <-.5*Feet, 2*Feet, 13*Feet+11> texture { GGlass1 } texture { frost1 } translate y*1*Feet translate x*1*Feet }//Glass Pannel
box { <-1*Feet, 1*Feet, 13*Feet+10.45>, <-.5*Feet, 2*Feet, 13*Feet+11> texture { GGlass1 } texture { frost2 } translate y*1*Feet translate x*1.5*Feet }//Glass Pannel
//box { <-1*Feet, 1*Feet, 13*Feet+10.45>, <1*Feet, 4*Feet, 13*Feet+11> texture { GGlass1 } texture { frost1 scale <.5*Feet,2*Feet,.5*Feet> } }//Glass Sheet
box { <-.5*Inch, 1*Feet, 13*Feet+10.35>, <.5*Inch, 4*Feet, 13*Feet+11.1> texture { Stucco } }//Y
box { <-.5*Inch, 1*Feet, 13*Feet+10.35>, <.5*Inch, 4*Feet, 13*Feet+11.1> texture { Stucco } translate x*-6 }//Y
box { <-.5*Inch, 1*Feet, 13*Feet+10.35>, <.5*Inch, 4*Feet, 13*Feet+11.1> texture { Stucco } translate x*6 }//Y
box { <-1*Feet, -.5*Inch, 13*Feet+10.35>, <1*Feet, .5*Inch, 13*Feet+11.1> texture { Stucco } translate y*2*Foot }//X
box { <-1*Feet, -.5*Inch, 13*Feet+10.35>, <1*Feet, .5*Inch, 13*Feet+11.1> texture { Stucco } translate y*3*Foot }//X
translate z*-1.5*Feet
}

box { <-1*Feet, 0*Feet, 12.5*Feet>, <1*Feet, 1*Feet, 12.7*Feet> texture { Stucco } }//Outside Ledge
//// ///////////////////// ////
//// // Objects in Room // ////
//// ///////////////////// ////
object { Table translate <0*Feet,0*Feet,11*Feet> }

//// ////////////////////// ////
//// // Objects on Table // ////
//// ////////////////////// ////
object { PaperWriting rotate x*90 scale <.4,1,.8> rotate y*-15 translate <0*Feet,1.42*Feet,10.64*Feet> }
object { Paper rotate x*90 scale <.4,1,.8> rotate y*6 translate <-.1*Feet,1.4186*Feet,10.7*Feet> }
object { Paper rotate x*90 scale <.4,1,.8> rotate y*11 translate <-.05*Feet,1.4172*Feet,10.68*Feet> }

object { #include "candle.inc" translate <-5,0,0> }

//// //////////////////////// ////
//// // Inside Environment // ////
//// //////////////////////// ////
#if (smoke = on)
box { <-6*Feet, 0*Feet, 0*Feet>, <6*Feet, 8*Feet, 12*Feet>
texture { pigment { rgbf 1 } } 
hollow on
interior {
media {
  scattering { 3, rgb 0.005}
  intervals 1
  samples 1
  method 3
    density { marble
      color_map {
        [0.0 rgb .5]
        [1.0 rgb .4]
      }
  warp {
    turbulence 0.4*x
    octaves 2
  }
  }
}
}
no_shadow
}
#end

//// ///////////////////////// ////
//// // Outside Environment // ////
//// ///////////////////////// ////

/*light_source {
  0*x
  color rgb <1,1,1>*.2
  translate <20*Miles, 20*Miles, 30*Miles>
}*/

sky_sphere{
/* pigment{
  gradient y 
  color_map{[0 rgb <.65,.65,.7>][.4 rgb <.35,.35,.4>][.7 rgb <.05,.05,.3>][1 rgb <0,0,.3>]}
  scale 2 translate -1
  }*/
  pigment { color Black }
 }
 
#include "snowcodes.inc"

#if (radio = on )
global_settings {
  radiosity {
    pretrace_start 0.18           // start pretrace at this size
    pretrace_end   radioQuality   // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 10              // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
  }
}
#end
