global_settings {
    max_trace_level 30
    photons {count 250000  max_trace_level 10}
}

#declare camera_location = <0.04, 0.5, -10>;
camera {
    location camera_location
    up y
    right 4/3*x*0.5
    look_at 0.575*y
    angle 25.9/2
    /* focal_point 0.1*y
    aperture 0.15
    blur_samples 100
    confidence 0.95
    variance 1/256 */
}

#declare main_light_loc = <-100, 190, -300>;
#declare bubble_inner_rad = 0.55;
#declare bubble_outer_rad = 0.575;
#declare fire_diam = 0.3;
#declare fire_height = 0.35;

#declare baby_obj =
union {
    sphere {
        0, bubble_inner_rad-0.0003
        clipped_by {box {<-1, -1, -1>, <1, 1, 0>}}
        pigment {
            image_pattern {
                sys "baby_mm.bmp"
                map_type 0
                interpolate 2
                once
            }
            pigment_map {
                [0
                    image_map {
                        sys "baby.bmp"
                        map_type 0
                        interpolate 0
                        transmit all 1
                    }
                ]
                [1
                    image_map {
                        sys "baby.bmp"
                        map_type 0
                        interpolate 0
                    }
                ]
            }
            translate -0.5
            scale 0.99
            rotate -87*z
        }
        finish {ambient 1.232  diffuse 0}
    }
    sphere {
        0, bubble_inner_rad-0.0003
        clipped_by {box {<-1, -1, 0>, <1, 1, 1>}}
        pigment {color rgbt 1}
        translate 0.5e-4*z
    }
    translate <-0.024, -0.02, 0>
    no_shadow
    hollow
    scale <1, 1, 0.02>
}

#declare baby_shadow =
sphere {
    0, bubble_inner_rad-0.0003
    clipped_by {box {<-1, -1, -1>, <1, 1, 0>}}
    pigment {
        image_pattern {
            sys "baby_mm.bmp"
            map_type 0
            interpolate 2
            once
        }
        pigment_map {
            [0  color rgbt 1]
            [1
                image_map {
                    sys "baby.bmp"
                    map_type 0
                    interpolate 0
                }
            ]
        }
        translate -0.5
        scale 0.99
        rotate -87*z
    }
    finish {ambient 1  diffuse 0}
    translate <-0.024, -0.02, 0>
    no_image
    no_reflection
    scale <1, 1, 0.02>
}

#declare bubble_cloud_alt = 0.55;
#declare bubble_cloud_turb =
function {
    pigment {
        bozo
        scale 0.04
        color_map {
            [0  color rgb 0]
            [1  color rgb 1]
        }
    }
}
#declare bubble_cloud_dens =
density {
    function {
        y+bubble_cloud_turb (x, y, z).gray*y+bubble_cloud_turb (3*x, 4.5*y, 3*z).gray*1.2*y
        +bubble_cloud_turb (7*x, 7*y, 7*z).gray*0.2*y-
        0.7*sqrt (x*x+z*z)
    }
    turbulence 0.05
    omega 0.05
    lambda 2.5
    color_map {
        [0  color rgb 1]
        [bubble_cloud_alt/6
            color rgb 0.35
        ]
        [bubble_cloud_alt/4
            color rgb 0
        ]
        [0.8  color rgb 0]
        [1    color rgb 1]
    }
    scale 15
    translate -y
    scale 0.5
}
#declare bubble_cloud_obj =
sphere {
    0, 1
    hollow
    pigment {color rgbt 1}
    interior {
        media {
            samples 13, 15
            scattering {
                3,
                color rgb 40
                extinction 0.41
            }
            absorption 0.2
            density {
                onion
                density_map {
                    [0     bubble_cloud_dens]
                    [0.44  bubble_cloud_dens]
                    [0.5   color rgb 0]
                    [1     color rgb 0]
                }
                scale 2
            }
        }
    }
    finish {ambient 1}
    scale bubble_inner_rad-0.0001
}

#declare ice_bubble_obj =
difference {
    sphere {0, bubble_outer_rad}
    sphere {0, bubble_inner_rad}
    hollow
    pigment {color rgb 1  filter 0.985}
    finish {
        reflection {0.8  fresnel}
        ambient 0.35
        diffuse 0.75
        phong 0.015
        phong_size 180
        conserve_energy
        brilliance 2.2
    }
    normal {
        average
        normal_map {
            [bumps 0.175  scale 0.275]
            [wrinkles 0.045  scale 0.1]
            /* [
                crackle  0.15
                turbulence 0.3
                scale 0.3
                slope_map {
                    [0,     <0, 0>]
                    [0.007, <1, 0>]
                    [1,     <1, 0>]
                }
            ] */
        }
    }
    interior {
        ior 1.33
        media {
            scattering {1,  color rgb 6  extinction 0}
            absorption 0.02
            density {color rgb 1}
        }
    }
}

#declare fire_onion =
pigment {
    object {
        sphere {0, 0.5}
        pigment {color rgb 0}
        pigment {
            onion
            sine_wave
            phase 0.25
            color_map {
                [0    color rgb 0]
                [0.1  color rgb 1]
                [1    color rgb 1]
            }
        }
    }
}
#declare fire_onion2 =
pigment {
    object {
        sphere {0, 0.5}
        pigment {color rgb 0}
        pigment {
            onion
            sine_wave
            phase 0.25
            color_map {
                [0    color rgb 0]
                [1    color rgb 1]
            }
        }
    }
}
#declare fire_pigm =
pigment {
    object {
        cylinder {-y, 0, 0.5}
        pigment {
            pigment_pattern {fire_onion2  scale 0.9*<1, 1+fire_height, 1>}
            pigment_map {
                [0  fire_onion  scale <1, 1+fire_height, 1>]
                [1  color rgb 0]
            }
        }
        pigment {
            pigment_pattern {fire_onion2  scale 0.9}
            pigment_map {
                [0  fire_onion]
                [1  color rgb 0]
            }
        }
    }
    scale (1+fire_diam)/0.9
}
#declare fire_func =
function {
    pigment {
        pigment_pattern {fire_pigm}
        color_map {
            [0  color rgb 0]
            [1  color rgb 1]
        }
    }
}
#declare fire_turb_func =
function {
    pigment {
        bozo
        scale <1, 1.5, 1>*0.15
        turbulence <0.19, 0.4, 0.19>*7
        lambda 1.5
        translate <0.2, -1.2, 0>
        color_map {
            [0  color rgb -0.225]
            [1  color rgb 0.225]
        }
    }
}
#declare fire_obj =
difference {
    sphere {(bubble_outer_rad+fire_height+0.25)*y/2, fire_height/2+2*bubble_outer_rad  scale <1, 1, 0.6>}
    sphere {0, bubble_outer_rad+0.0001}
    blob {
        sphere {-(bubble_outer_rad-0.03)*y, 0.06, 1  scale <2.5, 1, 2.5>}
        sphere {-(bubble_outer_rad+0.047)*y, 0.06, 0.55}
        threshold 0.4999
    }
    sphere {-(bubble_outer_rad+0.12)*y, 0.00972}
    hollow
    no_shadow
    pigment {color rgbt 1}    
    interior {
        media {
            method 3
            emission 0.7
            intervals 1
            samples 100, 100
            density {
                function {
                    fire_func (
                        x*(1+(0.7*fire_turb_func (0.7*x, 0.7*y, 0.7*z).gray)),
                        y*(1+fire_turb_func (x, y, z).gray*2*(y+1.4*bubble_outer_rad)*(1.2-sqrt (x*x+z*z))),
                        z*(1+(0.7*fire_turb_func (0.7*x, 0.7*y, 0.7*z).gray))
                    ).gray
                }
                scale <1.025, 1, 1.025>
                color_map {
                    [0     color rgb 0]
                    [0.3   color rgb 0]
                    [0.65  color rgb <0.3, 0, 0>]
                    [0.87  color rgb <1, 0.4, 0>*0.9]
                    [1     color rgb <1, 0.65, 0>*2.5]
                }
            }
        }
        media {
            method 3
            absorption color rgb <0.75, 0.75, 1.65>*0.8
            intervals 1
            samples 100, 100
            density {
                function {
                    fire_func (
                        x*(1+(0.7*fire_turb_func (0.7*x, 0.7*y, 0.7*z).gray)),
                        y*(1+fire_turb_func (x, y, z).gray*2*(y+1.4*bubble_outer_rad)*(1.2-sqrt (x*x+z*z))),
                        z*(1+(0.7*fire_turb_func (0.7*x, 0.7*y, 0.7*z).gray))
                    ).gray
                }
                scale <1.025, 1, 1.025>
                color_map {
                    [0     color rgb 0]
                    [0.3   color rgb 0]
                    [0.65  color rgb 0.1]
                    [0.87  color rgb 0.5]
                    [1     color rgb 4.25/3]
                }
            }
        }
        media {
            method 3
            emission 1.02
            absorption color rgb 0.7
            intervals 1
            samples 50, 50
            density {
                function {
                    fire_func (
                        x*(1+(0.7*fire_turb_func (0.7*x, 0.7*y, 0.7*z).gray)),
                        y*(1+fire_turb_func (x, y, z).gray*2*(y+1.4*bubble_outer_rad)*(1.2-sqrt (x*x+z*z))),
                        z*(1+(0.7*fire_turb_func (0.7*x, 0.7*y, 0.7*z).gray))
                    ).gray
                }
                scale <1.025, 1, 1.025>
                color_map {
                    [0      color rgb 0]
                    [0.05   color rgb 0]
                    [0.175  color rgb <0.05, 0.3, 1.1>*0.3]
                    [0.3    color rgb <0.05, 0.2, 1>*0.05]
                    [0.5    color rgb 0]
                    [1      color rgb 0]
                }
            }
        }
        media {
            method 3
            emission 0.02
            intervals 1
            samples 50, 50
            density {
                function {
                    fire_func (
                        x*(1+(0.7*fire_turb_func (0.7*x, 0.7*y, 0.7*z).gray)),
                        y*(1+fire_turb_func (x, y, z).gray*2*(y+1.4*bubble_outer_rad)*(1.2-sqrt (x*x+z*z))),
                        z*(1+(0.7*fire_turb_func (0.7*x, 0.7*y, 0.7*z).gray))
                    ).gray
                }
                scale <1.025, 1, 1.025>
                color_map {
                    [0    color rgb 0]
                    [0.3  color rgb <0.3, 0.1, 0>]
                    [0.5  color rgb <1.5, 1.3, 0.4>*5]
                    [0.6  color rgb 0]
                    [1    color rgb 0]
                }
            }
        }
    }
}

#declare ice_crystal_func =
function {
    pigment {
        bozo
        turbulence 0.3
        lambda 1.34
        scale 1
        color_map {
            [0  color rgb 0]
            [1  color rgb 1]
        }
    }
}
#declare icy_floor_obj =
intersection {
    isosurface {
        function {
            sqrt (y*y+z*z+0.25*x*x)-1
            -ice_crystal_func (10*x, 3*y, 10*z).gray*0.8*pow (0.3*z, 2)
            -ice_crystal_func (3*x, 1*y, 3*z).gray*2*pow (0.3*z, 2)
        }
        contained_by {sphere {0, 2}}
        all_intersections
        max_gradient 2
        inverse
    }
    box {<-1, -2, -0.5>, <1, 0.35, 2>}
    pigment {color rgb <0.983, 0.997, 1>*0.975}
    finish {
        reflection {0.8  fresnel}
        ambient 0.28
        diffuse 0.675
        phong 0.05
        phong_size 180
        brilliance 1.4
    }
    interior {ior 1.33}
    translate y
    scale <6, 4, 7>
    translate -y-z
}

#declare puddle_obj =
disc {
    0, y, 4
    pigment {color rgbt 1}
    finish {
        reflection {1  fresnel}
        phong 0.01
        phong_size 180
        conserve_energy
    }
    normal {ripples 0.08  scale 0.5  frequency 2}
    interior {
        ior 1.33
        fade_color rgb <0, 0.6, 1>
        fade_power 1000
        fade_distance 0.75
    }
    hollow
    photons {target  reflection on  refraction on}
    translate -0.75*y
}

#declare water_drops_obj =
union {
    difference {
        blob {
            sphere {-(bubble_outer_rad-0.03)*y, 0.06, 1  scale <2.5, 1, 2.5>}
            sphere {-(bubble_outer_rad+0.047)*y, 0.06, 0.55}
            threshold 0.5
        }
        sphere {0, bubble_outer_rad+0.00025}
    }
    sphere {-(bubble_outer_rad+0.12)*y, 0.0097}
    pigment {color rgbt 1}
    finish {
        reflection {1  fresnel}
        phong 0.01
        phong_size 180
        conserve_energy
    }
    interior {
        ior 1.33
        fade_color rgb <0, 0.6, 1>
        fade_power 1000
        fade_distance 0.75
    }
    hollow
    photons {target  reflection on  refraction on}
}


union {
    object {baby_obj}
    object {baby_shadow}
    object {ice_bubble_obj  photons {target  reflection on  refraction on  collect off}}
    object {bubble_cloud_obj}
    object {fire_obj}
    object {water_drops_obj}
    light_source {0  color rgb <0.8, 0.72, 0>*0.42  shadowless  fade_power 1.4  fade_distance 1.5}
    scale 1.2
    translate 0.1*y
}
object {icy_floor_obj}
object {puddle_obj}

light_source {
    main_light_loc
    color rgb 1
    photons {reflection on  refraction on}
    /* area_light <-7.5, -7.5, 0>, <7.5, 7.5, 0>, 12, 12
    adaptive 1
    jitter
    circular
    orient */
}

light_source {-200*y  color rgb 0.25  shadowless}

sky_sphere {
    pigment {
        wrinkles
        scale 0.25
        turbulence 1
        color_map {
            [0  color rgb <0.25, 0.25, 0.3>]
            [1  color rgb <0.9, 0.9, 1>]
        }
    }
}
