#include "setBackgroundMacro.inc"

//Please make sure that you have read the note in setBackgroundMacro.inc before rendering!!

//variables for the setBackground macro
#declare loc = <0.00, -1.00,  2.00>;  
#declare loo = <0.00, -1.00, 25.00>; 
#declare ang = 60;        
#declare aspect = image_width/image_height;

setBackground("backgroundimage.jpg", 1000)     


camera {
  location loc
  look_at loo
  right aspect*x
  angle ang
}         


//Lake texture

#declare S = seed(0);

//base texture
#declare mytex = texture {
  pigment { rgb 0 }
  normal { bumps 0.11 scale 0.10 } 
  finish { reflection 1.00 }
}          

//1st part of laketexture
#declare longripplestex = texture {
    //blurred reflection as described at http://tag.povray.org/povQandT/languageQandT.html#blurredreflection 
    average 
    texture_map {
      #local i=0;
      #while (i<30) //blur_samples
        #local mytex = texture { mytex rotate y*360*rand(S) }
        [1 mytex]
        #local i=i+1;
      #end 
    }
    scale z*5
  }
  
//2nd base texture  
#declare mytex = texture {
  pigment { rgb 0 }
  normal { wrinkles 0.01 scale 0.001 } 
  finish { reflection 1.00 }
} 

//2nd part of laketexture
#declare blurtex = texture {
    average 
    texture_map {
      #local i=0;
      #while (i<5)
        #local mytex = texture { mytex rotate y*360*rand(S) }
        [1 mytex]
        #local i=i+1;
      #end 
    }
    scale <1.00, 1.00, 0.50>
  }

//The lake
plane {
  y, -2
  texture {
    average 
    texture_map {
      [3 longripplestex]
      [2 blurtex]
    }
    scale <0.02, 100.00, 0.02> 
    warp { turbulence 0.05 } 
    scale <50.00, 0.01, 50.00>
  }
}            

#declare light_color = <1.50, 0.75, 0.375>;

union {
  light_source {
    vrotate(-200*y, <-92.00, 21.50, 0.00>)
    rgb light_color
  }
  light_source {
    vrotate(-150*y, <-92.00, 21.50, 0.00>)
    rgb light_color      
    translate x*-20
   }
  light_source {
    vrotate(-100*y, <-92.00, 21.50, 0.00>)
    rgb light_color       
    translate x*-10
  } 
  translate y*30
}


#local hf_trans = transform {
  //one could surely simplify this ;)
  translate <-0.50, -0.375, -0.50>
  scale 5
  rotate y*180                     
  scale <30, 4, 50>
  translate <-25, -2, 25>
  scale <-1, 1, 1>    
  rotate y*-10   
  translate z*10    
}  

//The land
#declare hf = height_field {
  sys "hf1map.bmp" //render with hf1map.pov. i used resolution 900x900
  smooth     
  transform { hf_trans }
    
  texture { //let there be snow
    pigment { rgb <0.80, 0.90, 1.00> }
    finish { ambient 0.35 diffuse 0.15 specular 0.35 roughness 0.20 metallic }
    normal { granite 0.25 scale 0.50 }
  }
}             

object { hf }

//The ice floes
height_field {
  sys "hf2map.bmp" //render with hf2map.pov. i used resolution 450x450
  smooth     
  transform { hf_trans }
  
  translate <0.00, 2.40, 0.00>  
  scale y*0.05       
  translate y*-2
  
  #local tex1 = texture { //transparent
    pigment { rgbf 1 }
  }; 
  
  #local tex2 = texture { //actual ice floe texture
    pigment {
      crackle
      color_map {
        [0.00 rgbf <1.00, 1.00, 1.00, 1.00>]
        [0.02 rgbf <0.80, 0.90, 1.00, 0.25>]
        [1.00 rgbf <0.80, 0.90, 1.00, 0.25>]
      }
      scale 0.75
      rotate 60
    }  
    finish { 
      ambient 0.35 
      diffuse 0.15 
      specular 0.35 
      roughness 0.20 
      metallic 
    }
    normal {
      crackle
      slope_map {
        [0.00 0.00]
        [0.01 0.00]
        [0.02 0.05]
        [1.00 0.05]
      }
      scale 0.75
      rotate 60
    }           
  };  
  
  texture {
    gradient y
    texture_map {
      [0.00 tex1] //waterlevel
      [0.01 tex2]
      [1.00 tex2]  
    } 
  }
}

#include "tanne.pov" //not attached!

//function providing the threshold for the tree placement algorithm below
#declare func = function {
  pigment {
    bozo 
    pigment_map { 
      [0.0 rgb 0.0]  //dense area
      [0.4 rgb 0.0]
      [0.6 rgb 0.7]  //less dense area
      [1.0 rgb 0.7] 
    } 
    scale 15 
    rotate y*180
  }
}

#declare S = seed(0);

#declare i=0;
#while (i<2000) //Number of trees
  
  #local Norm = <0, 0, 0>; 
  #local pnt = trace(hf, <-50, 100, -90>+<150*rand(S), 0, 250*rand(S)>, -y, Norm); 
  
  #if(vlength(pnt)!=0)
  
    #if(pnt.y>-1.90) //i don't want trees standing in the lake
      
      #if(func(pnt.x, pnt.y, pnt.z).x<rand(S)) 
      //this is where the function comes into play
      //a tree is planted when rand(S) (0.0 to 1.0) is bigger
      //than the threshold (0.0 to 0.7), otherwise not
      
        //Fill your own tree here or use the dummy cylinder below. TREE height should be 1
        object {
          TREE 
          scale 1.50 + 1.875*rand(S)
          rotate y*360*rand(S) 
          translate pnt 
          translate y*-0.55 //the tree trunk was to long ;)
        }
        /*cylinder { //dummy cylinder for test renders
          0, y, 0.10 
          scale 1.50+1.875*rand(S)
          pigment { rgb z } 
          finish { ambient 1 } 
          translate pnt 
        }*/
      #end  
      #declare i=i+1;
    #end
  #end                                             
#end                                                          

