/*
  * IMPORTANT NOTE!
  * The normal usage of this macro needs the "scale 2" at the last texture block to be 
  * commented out (as it is now) to make the image fit to screen. To render firelake
  * it has to be commented IN because the background wallpaper is twice as big as the 
  * part you actually see. This was necessary since the lake reflects parts of the 
  * wallpaper that are not directly visible by the camera.
  * 
  */

//######################################################################################################  
//## setBackgroundMacro by Roman Reiner - limdaepl@gmx.de ##############################################
//######################################################################################################  
  

#include "transforms.inc"

#macro setBackground(imagefilename, dist) //dist is the distance of the wallpaper plane from the camera

  #local vect = vnormalize(loo-loc);
  
  #local back = texture {
    pigment {
      image_map {
        jpeg imagefilename //replace this with appropriate fileformat if it differs from jpg
        //interpolate 2    //not necessary if resolutions fits or antialiasing is used
        once
      }  
      translate <-.5,-.5,0>
      scale 2*dist*tan(radians(.5*ang))       
      scale y*image_height/image_width
    }  
    finish { ambient 1 diffuse 0 }
  } 
  
  plane { 
    y, 0
    texture { back rotate x*90 /*scale 2*/ }  //<-- here!
    Reorient_Trans(y,-vect)
    translate loc
    translate dist*vect
  } 
  
#end       
