/*************** Tree made by: ******************

Arbaro 2.0 - creates trees objects for rendering from xml parameter files
(c) 2003-2004 by Wolfram Diestel <diestel@steloj.de> (GPL see file COPYING)


<?xml version='1.0' ?>

<arbaro>
  <species name='black_tupelo'>
    <!-- general params -->
    <param name='Shape' value='7'/>
    <param name='Levels' value='4'/>
    <param name='Scale' value='23.0'/>
    <param name='ScaleV' value='5.0'/>
    <param name='BaseSize' value='0.165'/>
    <param name='Ratio' value='0.015'/>
    <param name='RatioPower' value='0.9'/>
    <param name='Flare' value='1.0'/>
    <param name='Lobes' value='3'/>
    <param name='LobeDepth' value='0.1'/>
    <param name='Smooth' value='0.5'/>
    <param name='Leaves' value='0'/>
    <param name='LeafShape' value='0'/>
    <param name='LeafScale' value='0.3'/>
    <param name='LeafScaleX' value='0.5'/>
    <param name='LeafQuality' value='1.0'/>
    <param name='LeafStemLen' value='0.5'/>
    <param name='LeafDistrib' value='4'/>
    <param name='LeafBend' value='0.3'/>
    <param name='AttractionUp' value='2.0'/>
    <param name='PruneRatio' value='0.0'/>
    <param name='PrunePowerLow' value='0.5'/>
    <param name='PrunePowerHigh' value='0.5'/>
    <param name='PruneWidth' value='0.5'/>
    <param name='PruneWidthPeak' value='0.5'/>
    <param name='0Scale' value='1.0'/>
    <param name='0ScaleV' value='0.0'/>
    <param name='0BaseSplits' value='0'/>
    <!-- level 0 -->
    <param name='0DownAngle' value='0.0'/>
    <param name='0DownAngleV' value='0.0'/>
    <param name='0Rotate' value='0.0'/>
    <param name='0RotateV' value='0.0'/>
    <param name='0Branches' value='1'/>
    <param name='0BranchDist' value='0.0'/>
    <param name='0Length' value='1.0'/>
    <param name='0LengthV' value='0.0'/>
    <param name='0Taper' value='1.1'/>
    <param name='0SegSplits' value='0.0'/>
    <param name='0SplitAngle' value='0.0'/>
    <param name='0SplitAngleV' value='0.0'/>
    <param name='0CurveRes' value='10'/>
    <param name='0Curve' value='0.0'/>
    <param name='0CurveBack' value='0.0'/>
    <param name='0CurveV' value='40.0'/>
    <!-- level 1 -->
    <param name='1DownAngle' value='60.0'/>
    <param name='1DownAngleV' value='-40.0'/>
    <param name='1Rotate' value='140.0'/>
    <param name='1RotateV' value='0.0'/>
    <param name='1Branches' value='45'/>
    <param name='1BranchDist' value='1.0'/>
    <param name='1Length' value='0.3'/>
    <param name='1LengthV' value='0.05'/>
    <param name='1Taper' value='0.95'/>
    <param name='1SegSplits' value='0.2'/>
    <param name='1SplitAngle' value='5.0'/>
    <param name='1SplitAngleV' value='10.0'/>
    <param name='1CurveRes' value='10'/>
    <param name='1Curve' value='-10.0'/>
    <param name='1CurveBack' value='-10.0'/>
    <param name='1CurveV' value='90.0'/>
    <!-- level 2 -->
    <param name='2DownAngle' value='30.0'/>
    <param name='2DownAngleV' value='10.0'/>
    <param name='2Rotate' value='140.0'/>
    <param name='2RotateV' value='0.0'/>
    <param name='2Branches' value='24'/>
    <param name='2BranchDist' value='1.0'/>
    <param name='2Length' value='0.6'/>
    <param name='2LengthV' value='0.1'/>
    <param name='2Taper' value='1.0'/>
    <param name='2SegSplits' value='0.0'/>
    <param name='2SplitAngle' value='0.0'/>
    <param name='2SplitAngleV' value='0.0'/>
    <param name='2CurveRes' value='10'/>
    <param name='2Curve' value='-10.0'/>
    <param name='2CurveBack' value='0.0'/>
    <param name='2CurveV' value='150.0'/>
    <!-- level 3 -->
    <param name='3DownAngle' value='45.0'/>
    <param name='3DownAngleV' value='10.0'/>
    <param name='3Rotate' value='140.0'/>
    <param name='3RotateV' value='0.0'/>
    <param name='3Branches' value='14'/>
    <param name='3BranchDist' value='1.0'/>
    <param name='3Length' value='0.4'/>
    <param name='3LengthV' value='0.0'/>
    <param name='3Taper' value='1.0'/>
    <param name='3SegSplits' value='0.0'/>
    <param name='3SplitAngle' value='0.0'/>
    <param name='3SplitAngleV' value='0.0'/>
    <param name='3CurveRes' value='1'/>
    <param name='3Curve' value='0.0'/>
    <param name='3CurveBack' value='0.0'/>
    <param name='3CurveV' value='0.0'/>
  </species>
</arbaro>
************************************************/
#declare black_tupelo_13_height = 26.73103;
#declare black_tupelo_13_stems = 
  mesh2 {
    vertex_vectors { 76518
    /* stem 0*/ 
    /*0*/ <0,0,0>,
    /*1*/ <0.73476,0,-0.04279>,<0.60915,0,0.30592>,<0.33192,0,0.50466>,
            <0.03828,0,0.65727>,<-0.33032,0,0.65771>,<-0.56951,0,0.37457>,
            <-0.60301,0,0.03512>,<-0.58835,0,-0.29548>,<-0.40444,0,-0.61492>,
            <-0.03963,0,-0.6805>,<0.27109,0,-0.53978>,<0.55007,0,-0.36179>,
            
    /*2*/ <0.73198,0.00438,-0.04263>,<0.60684,0.00438,0.30477>,<0.33067,0.00438,0.50276>,
            <0.03814,0.00438,0.65479>,<-0.32907,0.00438,0.65523>,<-0.56736,0.00438,0.37316>,
            <-0.60073,0.00438,0.03499>,<-0.58613,0.00438,-0.29437>,<-0.40291,0.00438,-0.6126>,
            <-0.03948,0.00438,-0.67793>,<0.27007,0.00438,-0.53774>,<0.54799,0.00438,-0.36042>,
            
    /*3*/ <0.72922,0.00877,-0.04247>,<0.60456,0.00877,0.30362>,<0.32942,0.00877,0.50086>,
            <0.03799,0.00877,0.65232>,<-0.32783,0.00877,0.65276>,<-0.56522,0.00877,0.37175>,
            <-0.59847,0.00877,0.03486>,<-0.58392,0.00877,-0.29326>,<-0.40139,0.00877,-0.61029>,
            <-0.03934,0.00877,-0.67538>,<0.26905,0.00877,-0.53572>,<0.54593,0.00877,-0.35906>,
            
    /*4*/ <0.72377,0.01754,-0.04215>,<0.60004,0.01754,0.30135>,<0.32696,0.01754,0.49712>,
            <0.03771,0.01754,0.64744>,<-0.32538,0.01754,0.64788>,<-0.561,0.01754,0.36897>,
            <-0.594,0.01754,0.0346>,<-0.57956,0.01754,-0.29106>,<-0.39839,0.01754,-0.60573>,
            <-0.03904,0.01754,-0.67032>,<0.26704,0.01754,-0.53171>,<0.54185,0.01754,-0.35638>,
            
    /*5*/ <0.7131,0.03507,-0.04153>,<0.59119,0.03507,0.29691>,<0.32214,0.03507,0.48979>,
            <0.03715,0.03507,0.63789>,<-0.32058,0.03507,0.63833>,<-0.55272,0.03507,0.36353>,
            <-0.58524,0.03507,0.03409>,<-0.57101,0.03507,-0.28677>,<-0.39252,0.03507,-0.59679>,
            <-0.03847,0.03507,-0.66044>,<0.2631,0.03507,-0.52387>,<0.53386,0.03507,-0.35112>,
            
    /*6*/ <0.69265,0.07014,-0.04034>,<0.57424,0.07014,0.28839>,<0.3129,0.07014,0.47574>,
            <0.03609,0.07014,0.6196>,<-0.31139,0.07014,0.62002>,<-0.53688,0.07014,0.35311>,
            <-0.56845,0.07014,0.03311>,<-0.55464,0.07014,-0.27855>,<-0.38126,0.07014,-0.57968>,
            <-0.03736,0.07014,-0.6415>,<0.25555,0.07014,-0.50885>,<0.51855,0.07014,-0.34105>,
            
    /*7*/ <0.65511,0.14029,-0.03816>,<0.54312,0.14029,0.27276>,<0.29594,0.14029,0.44996>,
            <0.03413,0.14029,0.58602>,<-0.29451,0.14029,0.58642>,<-0.50778,0.14029,0.33397>,
            <-0.53765,0.14029,0.03131>,<-0.52458,0.14029,-0.26345>,<-0.3606,0.14029,-0.54826>,
            <-0.03534,0.14029,-0.60674>,<0.2417,0.14029,-0.48127>,<0.49044,0.14029,-0.32257>,
            
    /*8*/ <0.59176,0.28058,-0.03447>,<0.4906,0.28058,0.24639>,<0.26733,0.28058,0.40645>,
            <0.03083,0.28058,0.52936>,<-0.26603,0.28058,0.52972>,<-0.45868,0.28058,0.30168>,
            <-0.48566,0.28058,0.02829>,<-0.47385,0.28058,-0.23798>,<-0.32573,0.28058,-0.49525>,
            <-0.03192,0.28058,-0.54807>,<0.21833,0.28058,-0.43474>,<0.44302,0.28058,-0.29138>,
            
    /*9*/ <0.50099,0.56115,-0.02918>,<0.41534,0.56115,0.20859>,<0.22632,0.56115,0.3441>,
            <0.0261,0.56115,0.44816>,<-0.22523,0.56115,0.44846>,<-0.38832,0.56115,0.2554>,
            <-0.41116,0.56115,0.02395>,<-0.40117,0.56115,-0.20147>,<-0.27577,0.56115,-0.41928>,
            <-0.02702,0.56115,-0.464>,<0.18484,0.56115,-0.36805>,<0.37506,0.56115,-0.24668>,
            
    /*10*/ <0.40497,1.12231,-0.02359>,<0.33574,1.12231,0.16861>,<0.18294,1.12231,0.27815>,
            <0.0211,1.12231,0.36226>,<-0.18206,1.12231,0.36251>,<-0.31389,1.12231,0.20645>,
            <-0.33236,1.12231,0.01936>,<-0.32428,1.12231,-0.16286>,<-0.22291,1.12231,-0.33892>,
            <-0.02184,1.12231,-0.37506>,<0.14941,1.12231,-0.29751>,<0.30318,1.12231,-0.1994>,
            
    /*11*/ <0.34107,2.24461,-0.01987>,<0.28277,2.24461,0.14201>,<0.15408,2.24461,0.23426>,
            <0.01777,2.24461,0.3051>,<-0.15333,2.24461,0.30531>,<-0.26437,2.24461,0.17388>,
            <-0.27992,2.24461,0.0163>,<-0.27311,2.24461,-0.13716>,<-0.18774,2.24461,-0.28545>,
            <-0.0184,2.24461,-0.31589>,<0.12584,2.24461,-0.25057>,<0.25534,2.24461,-0.16794>,
            
    /*12*/ <0.33392,4.48482,-0.01502>,<0.28216,4.48537,0.12868>,<0.16794,4.48687,0.21057>,
            <0.04695,4.48847,0.27345>,<-0.10492,4.49058,0.27364>,<-0.20347,4.49209,0.15697>,
            <-0.21727,4.49244,0.01709>,<-0.21123,4.49252,-0.11913>,<-0.13545,4.49162,-0.25076>,
            <0.01485,4.48956,-0.27779>,<0.14288,4.48772,-0.2198>,<0.25782,4.48603,-0.14646>,
            
    /*13*/ <0.24022,6.7382,-0.09014>,<0.19413,6.74135,0.03773>,<0.09245,6.74111,0.11066>,
            <-0.01524,6.74013,0.16669>,<-0.1504,6.7365,0.16694>,<-0.23809,6.73058,0.0632>,
            <-0.25035,6.72598,-0.06124>,<-0.24494,6.72197,-0.18245>,<-0.17747,6.71977,-0.29961>,
            <-0.04369,6.72255,-0.32375>,<0.07024,6.72738,-0.27223>,<0.17253,6.73237,-0.20705>,
            
    /*14*/ <0.20416,8.96504,-0.30034>,<0.16364,8.97561,-0.18873>,<0.07441,8.98154,-0.12519>,
            <-0.02008,8.98605,-0.07642>,<-0.13862,8.9859,-0.07639>,<-0.21545,8.97717,-0.16711>,
            <-0.2261,8.96681,-0.2758>,<-0.22127,8.95675,-0.38165>,<-0.16201,8.9471,-0.48386>,
            <-0.04466,8.94527,-0.50474>,<0.05522,8.94969,-0.4596>,<0.14488,8.95524,-0.40252>,
            
    /*15*/ <0.18796,11.20285,-0.45348>,<0.15314,11.20978,-0.35739>,<0.07645,11.21415,-0.30273>,
            <-0.00475,11.21767,-0.26079>,<-0.10662,11.21844,-0.26084>,<-0.17264,11.21353,-0.33902>,
            <-0.18179,11.20711,-0.43263>,<-0.17763,11.20076,-0.52378>,<-0.12669,11.19428,-0.61177>,
            <-0.02585,11.19227,-0.62968>,<0.05998,11.19432,-0.59073>,<0.13703,11.19714,-0.54152>,
            
    /*16*/ <0.15589,13.44307,-0.61493>,<0.12676,13.44894,-0.53457>,<0.06263,13.45231,-0.48883>,
            <-0.00529,13.45491,-0.45372>,<-0.09049,13.45495,-0.45372>,<-0.14571,13.45022,-0.51907>,
            <-0.15336,13.44451,-0.59733>,<-0.14989,13.43895,-0.67355>,<-0.10729,13.43357,-0.74714>,
            <-0.02294,13.43243,-0.76216>,<0.04884,13.43476,-0.72963>,<0.11328,13.43773,-0.68852>,
            
    /*17*/ <0.12291,15.68107,-0.78747>,<0.09948,15.68611,-0.72286>,<0.04789,15.68898,-0.68608>,
            <-0.00674,15.69118,-0.65785>,<-0.07527,15.69119,-0.65785>,<-0.11968,15.6871,-0.71039>,
            <-0.12584,15.6822,-0.77332>,<-0.12304,15.67742,-0.8346>,<-0.08878,15.6728,-0.89377>,
            <-0.02093,15.67186,-0.90585>,<0.03681,15.67389,-0.8797>,<0.08864,15.67646,-0.84664>,
            
    /*18*/ <0.09022,17.91901,-0.96024>,<0.07249,17.92283,-0.91134>,<0.03345,17.92501,-0.88351>,
            <-0.00789,17.92669,-0.86215>,<-0.05975,17.9267,-0.86215>,<-0.09336,17.92361,-0.90191>,
            <-0.09802,17.91989,-0.94953>,<-0.09591,17.91627,-0.9959>,<-0.06998,17.91277,-1.04068>,
            <-0.01864,17.91205,-1.04982>,<0.02506,17.91358,-1.03003>,<0.06429,17.91552,-1.00502>,
            
    /*19*/ <0.08184,20.15357,-1.16199>,<0.06981,20.15672,-1.12885>,<0.04333,20.15874,-1.11001>,
            <0.01528,20.16036,-1.09556>,<-0.01991,20.16075,-1.09559>,<-0.04272,20.15855,-1.12256>,
            <-0.04588,20.15564,-1.15484>,<-0.04445,20.15276,-1.18628>,<-0.02686,20.1498,-1.21661>,
            <0.00798,20.14885,-1.22278>,<0.03763,20.14975,-1.20933>,<0.06424,20.151,-1.19235>,
            
    /*20*/ <0.1361,21.27011,-1.21139>,<0.12689,21.27184,-1.18605>,<0.10669,21.27377,-1.1717>,
            <0.08531,21.27562,-1.16072>,<0.0585,21.27732,-1.16083>,<0.04117,21.27748,-1.18154>,
            <0.0388,21.27652,-1.20626>,<0.03993,21.27536,-1.23032>,<0.05337,21.27346,-1.2535>,
            <0.07991,21.27157,-1.25812>,<0.10248,21.2706,-1.24775>,<0.12273,21.26991,-1.23468>,
            
    /*21*/ <0.16329,21.83012,-1.2362>,<0.15551,21.83158,-1.2148>,<0.13845,21.83321,-1.20268>,
            <0.12038,21.83477,-1.1934>,<0.09774,21.83621,-1.1935>,<0.08309,21.83634,-1.21099>,
            <0.08109,21.83553,-1.23188>,<0.08205,21.83455,-1.2522>,<0.0934,21.83295,-1.27178>,
            <0.11582,21.83135,-1.27569>,<0.13489,21.83053,-1.26693>,<0.152,21.82995,-1.25588>,
            
    /*22*/ <0.17689,22.11012,-1.24861>,<0.16982,22.11145,-1.22918>,<0.15433,22.11293,-1.21817>,
            <0.13792,22.11435,-1.20974>,<0.11735,22.11565,-1.20983>,<0.10405,22.11578,-1.22572>,
            <0.10224,22.11503,-1.24468>,<0.10311,22.11415,-1.26314>,<0.11342,22.11269,-1.28092>,
            <0.13378,22.11124,-1.28447>,<0.15109,22.1105,-1.27652>,<0.16663,22.10997,-1.26649>,
            
    /*23*/ <0.18368,22.25012,-1.25482>,<0.17698,22.25138,-1.23637>,<0.16226,22.25279,-1.22591>,
            <0.14669,22.25414,-1.21791>,<0.12716,22.25537,-1.21799>,<0.11453,22.25549,-1.23308>,
            <0.11281,22.25479,-1.25109>,<0.11363,22.25394,-1.26861>,<0.12342,22.25256,-1.2855>,
            <0.14276,22.25118,-1.28886>,<0.1592,22.25048,-1.28131>,<0.17395,22.24998,-1.27179>,
            
    /*24*/ <0.18708,22.32012,-1.25792>,<0.18056,22.32135,-1.23996>,<0.16623,22.32272,-1.22978>,
            <0.15107,22.32403,-1.22199>,<0.13207,22.32523,-1.22208>,<0.11977,22.32535,-1.23676>,
            <0.11809,22.32466,-1.25429>,<0.1189,22.32384,-1.27135>,<0.12843,22.3225,-1.28778>,
            <0.14725,22.32116,-1.29106>,<0.16325,22.32047,-1.28371>,<0.17761,22.31998,-1.27444>,
            
    /*25*/ <0.18878,22.35513,-1.25947>,<0.18234,22.35633,-1.24176>,<0.16822,22.35768,-1.23172>,
            <0.15326,22.35898,-1.22403>,<0.13452,22.36016,-1.22412>,<0.12239,22.36028,-1.2386>,
            <0.12074,22.3596,-1.25589>,<0.12153,22.35879,-1.27271>,<0.13093,22.35747,-1.28892>,
            <0.14949,22.35614,-1.29216>,<0.16527,22.35547,-1.2849>,<0.17943,22.35498,-1.27576>,
            
    /*26*/ <0.18502,22.37293,-1.26>,<0.17942,22.37398,-1.2446>,<0.16714,22.37515,-1.23587>,
            <0.15413,22.37628,-1.22919>,<0.13783,22.37731,-1.22926>,<0.12728,22.37741,-1.24185>,
            <0.12584,22.37682,-1.25689>,<0.12653,22.37612,-1.27152>,<0.13471,22.37496,-1.28562>,
            <0.15085,22.37381,-1.28843>,<0.16457,22.37323,-1.28212>,<0.17689,22.37281,-1.27417>,
            
    /*27*/ <0.17793,22.38217,-1.26>,<0.17365,22.38298,-1.24821>,<0.16425,22.38387,-1.24154>,
            <0.15431,22.38474,-1.23643>,<0.14184,22.38552,-1.23648>,<0.13378,22.3856,-1.24612>,
            <0.13267,22.38515,-1.25761>,<0.1332,22.38461,-1.2688>,<0.13945,22.38373,-1.27958>,
            <0.1518,22.38285,-1.28173>,<0.16229,22.3824,-1.27691>,<0.17171,22.38208,-1.27083>,
            
    /*28*/ <0.17155,22.38698,-1.25984>,<0.16842,22.38757,-1.25122>,<0.16154,22.38823,-1.24633>,
            <0.15425,22.38886,-1.24258>,<0.14512,22.38944,-1.24263>,<0.13922,22.38949,-1.24968>,
            <0.13841,22.38916,-1.2581>,<0.1388,22.38877,-1.26629>,<0.14338,22.38812,-1.27419>,
            <0.15242,22.38748,-1.27576>,<0.1601,22.38715,-1.27223>,<0.167,22.38691,-1.26778>,
            
    /*29*/ <0.15363,22.39255,-1.25908>

    /* stem 0.0*/ 
    /*0*/ <0.02205,3.83199,0.00185>,
    /*1*/ <-0.03241,3.83269,0.04756>,<0.01329,3.8988,0.02456>,<0.0711,3.87257,-0.02982>,
            <0.06114,3.79026,-0.04043>,<-0.00284,3.76561,0.00739>,
    /*2*/ <0.22472,3.76327,0.34453>,<0.26608,3.8231,0.32371>,<0.3184,3.79937,0.2745>,
            <0.30938,3.72487,0.26489>,<0.25148,3.70256,0.30817>,
    /*3*/ <0.45791,3.75879,0.66172>,<0.49145,3.81292,0.6387>,<0.54353,3.79097,0.60141>,
            <0.54218,3.72327,0.60138>,<0.48926,3.70338,0.63865>,
    /*4*/ <0.70981,3.73854,0.97375>,<0.73958,3.78629,0.95359>,<0.78357,3.76697,0.91804>,
            <0.78099,3.70728,0.91623>,<0.7354,3.68971,0.95066>,
    /*5*/ <0.94776,3.71831,1.291>,<0.97423,3.75967,1.27443>,<1.01344,3.74286,1.24499>,
            <1.0112,3.69111,1.24337>,<0.97061,3.67593,1.27181>,
    /*6*/ <1.19587,3.70952,1.60465>,<1.21728,3.7446,1.58925>,<1.25008,3.73037,1.5638>,
            <1.24894,3.6865,1.56348>,<1.21544,3.67361,1.58872>,
    /*7*/ <1.44688,3.7009,1.91507>,<1.46428,3.72963,1.90227>,<1.49092,3.71798,1.88114>,
            <1.49,3.68204,1.88089>,<1.46278,3.67149,1.90186>,
    /*8*/ <1.68834,3.69691,2.23148>,<1.70202,3.7193,2.22168>,<1.72329,3.71022,2.2059>,
            <1.72277,3.68222,2.20594>,<1.70117,3.67399,2.22176>,
    /*9*/ <1.97592,3.71596,2.51223>,<1.984,3.73192,2.50314>,<1.99767,3.72532,2.49003>,
            <1.99804,3.70528,2.49101>,<1.9846,3.6995,2.50473>,
    /*10*/ <2.28848,3.71803,2.76276>,<2.29314,3.72765,2.75705>,<2.30046,3.72361,2.74826>,
            <2.30031,3.71149,2.74854>,<2.29291,3.70804,2.7575>,
    /*11*/ <2.5788,3.76886,3.03045>,<2.58024,3.77216,3.02833>,<2.58309,3.77081,3.02559>,
            <2.58342,3.76666,3.02602>,<2.58077,3.76546,3.02902>,
    /*12*/ <2.58127,3.76879,3.02788>

    /* stem 0.0c0*/ 
    /*0*/ <0.74987,3.73776,0.94245>,
    /*1*/ <0.7374,3.73843,0.99174>,<0.74339,3.78623,0.95636>,<0.75833,3.76705,0.90176>,
            <0.76158,3.70739,0.90339>,<0.74864,3.6897,0.959>,
    /*2*/ <1.12513,3.762,1.08251>,<1.13032,3.80345,1.05184>,<1.14328,3.78681,1.00449>,
            <1.14609,3.73508,1.0059>,<1.13487,3.71974,1.05412>,
    /*3*/ <1.51717,3.79,1.15944>,<1.52027,3.825,1.13314>,<1.52993,3.8108,1.09275>,
            <1.53279,3.76702,1.09409>,<1.5249,3.75417,1.1353>,
    /*4*/ <1.91396,3.839,1.20213>,<1.9132,3.86731,1.17999>,<1.91884,3.8554,1.14654>,
            <1.92309,3.81974,1.14802>,<1.92007,3.8096,1.18237>,
    /*5*/ <2.31256,3.87068,1.22458>,<2.31206,3.89273,1.20732>,<2.31473,3.88325,1.1811>,
            <2.31689,3.85535,1.18216>,<2.31554,3.84758,1.20903>,
    /*6*/ <2.71202,3.87508,1.23551>,<2.71239,3.8909,1.22318>,<2.7133,3.88406,1.20434>,
            <2.7135,3.86401,1.20503>,<2.71271,3.85846,1.2243>,
    /*7*/ <3.11112,3.86821,1.24032>,<3.11149,3.87776,1.23287>,<3.11175,3.87363,1.22148>,
            <3.11154,3.86152,1.22189>,<3.11115,3.85817,1.23353>,
    /*8*/ <3.51021,3.86219,1.23426>,<3.51026,3.86549,1.23169>,<3.51025,3.86406,1.22776>,
            <3.51019,3.85989,1.22791>,<3.51016,3.85873,1.23192>,
    /*9*/ <3.51021,3.86207,1.23071>

    /* stem 0.0c0c0*/ 
    /*0*/ <2.71278,3.8745,1.21847>,
    /*1*/ <2.7047,3.87508,1.23349>,<2.70988,3.89088,1.22228>,<2.71907,3.88405,1.2058>,
            <2.71958,3.86402,1.20684>,<2.71069,3.85848,1.22396>,
    /*2*/ <3.05901,3.89345,1.41584>,<3.06214,3.903,1.40906>,<3.0677,3.89887,1.39911>,
            <3.068,3.88677,1.39974>,<3.06263,3.88342,1.41008>,
    /*3*/ <3.42168,3.93177,1.57877>,<3.42249,3.93504,1.57629>,<3.42429,3.9336,1.5728>,
            <3.42458,3.92945,1.57312>,<3.42297,3.92831,1.57681>,
    /*4*/ <3.4232,3.93164,1.57556>

    /* stem 0.0c0.0*/ 
    /*0*/ <0.99835,3.75299,1.00509>,
    /*1*/ <1.0057,3.76441,0.97314>,<1.01079,3.72243,1.01589>,<0.97855,3.77212,1.02623>,
            
    /*2*/ <1.15188,3.84541,1.03952>,<1.15645,3.80763,1.07799>,<1.12745,3.85235,1.0873>,
            
    /*3*/ <1.28783,3.93464,1.12179>,<1.29049,3.90086,1.15592>,<1.26168,3.9389,1.16194>,
            
    /*4*/ <1.40276,4.04558,1.2036>,<1.40761,4.01834,1.23531>,<1.37766,4.04784,1.23731>,
            
    /*5*/ <1.51604,4.1651,1.27019>,<1.52258,4.1439,1.29864>,<1.49606,4.1683,1.30006>,
            
    /*6*/ <1.62119,4.30022,1.3159>,<1.62964,4.2858,1.34089>,<1.60585,4.30418,1.34146>,
            
    /*7*/ <1.71957,4.43994,1.376>,<1.72564,4.42768,1.39578>,<1.70597,4.44152,1.39576>,
            
    /*8*/ <1.81053,4.58165,1.44008>,<1.81502,4.57244,1.45492>,<1.7999,4.58227,1.45463>,
            
    /*9*/ <1.86492,4.73802,1.51178>,<1.86812,4.73248,1.52195>,<1.857,4.73689,1.52075>,
            
    /*10*/ <1.93353,4.8996,1.54219>,<1.93556,4.89783,1.54757>,<1.93008,4.90025,1.54708>,
            
    /*11*/ <1.99495,5.06722,1.56208>

    /* stem 0.0c0.0.0*/ 
    /*0*/ <1.08658,3.80232,1.04304>,
    /*1*/ <1.08927,3.79079,1.05179>,<1.08676,3.81596,1.04857>,<1.08372,3.80021,1.02875>,
            
    /*2*/ <1.76317,3.85151,0.9003>

    /* stem 0.0c0.0.1*/ 
    /*0*/ <1.18725,3.86308,1.09267>,
    /*1*/ <1.17961,3.87496,1.09222>,<1.20074,3.86319,1.08845>,<1.18141,3.85108,1.09734>,
            
    /*2*/ <1.37898,4.00974,1.70968>

    /* stem 0.0c0.0.2*/ 
    /*0*/ <1.32473,3.96816,1.17696>,
    /*1*/ <1.33473,3.96239,1.17047>,<1.3265,3.97249,1.18935>,<1.31297,3.9696,1.17105>,
            
    /*2*/ <1.50095,4.51738,0.96012>

    /* stem 0.0c0.0.3*/ 
    /*0*/ <1.46142,4.10622,1.26176>,
    /*1*/ <1.45586,4.10574,1.27267>,<1.46469,4.11703,1.25702>,<1.4637,4.09588,1.25559>,
            
    /*2*/ <1.9645,4.06555,1.51629>

    /* stem 0.0c0.0.4*/ 
    /*0*/ <1.54229,4.1985,1.30197>,
    /*1*/ <1.54058,4.20313,1.29143>,<1.55311,4.19702,1.306>,<1.53317,4.19534,1.30849>,
            
    /*2*/ <1.52821,4.68656,1.51868>

    /* stem 0.0c0.0.5*/ 
    /*0*/ <1.5965,4.26802,1.32375>,
    /*1*/ <1.60344,4.26095,1.32901>,<1.59492,4.27837,1.32778>,<1.59113,4.26473,1.31447>,
            
    /*2*/ <1.98625,4.43846,1.03811>

    /* stem 0.0c0.0.6*/ 
    /*0*/ <1.68598,4.39217,1.37131>,
    /*1*/ <1.67723,4.39763,1.37303>,<1.69363,4.39626,1.36548>,<1.68708,4.38262,1.37543>,
            
    /*2*/ <1.88046,4.58175,1.75968>

    /* stem 0.0c0.0.7*/ 
    /*0*/ <1.74658,4.48237,1.40878>,
    /*1*/ <1.75341,4.48099,1.40174>,<1.74936,4.48349,1.41822>,<1.73698,4.48264,1.40638>,
            
    /*2*/ <1.77394,4.92375,1.34853>

    /* stem 0.0c0.0.8*/ 
    /*0*/ <1.82359,4.62203,1.46868>,
    /*1*/ <1.82154,4.61912,1.47703>,<1.82211,4.63069,1.4664>,<1.82713,4.61628,1.46261>,
            
    /*2*/ <2.19654,4.71869,1.59424>

    /* stem 0.0c0.0.9*/ 
    /*0*/ <1.91454,4.85582,1.53832>,
    /*1*/ <1.91242,4.85732,1.53478>,<1.91881,4.85669,1.53886>,<1.91239,4.85345,1.54133>,
            
    /*2*/ <1.83463,5.14254,1.70728>

    /* stem 0.0c0.0.10*/ 
    /*0*/ <1.96553,4.98737,1.55426>,
    /*1*/ <1.96701,4.98678,1.55468>,<1.96494,4.98872,1.55499>,<1.96464,4.98661,1.55309>,
            
    /*2*/ <2.09731,5.16283,1.33789>

    /* stem 0.0c0.1*/ 
    /*0*/ <1.23608,3.76862,1.06118>,
    /*1*/ <1.23446,3.74018,1.0783>,<1.2491,3.79577,1.07525>,<1.22467,3.76991,1.02999>,
            
    /*2*/ <1.38953,3.69903,1.01813>,<1.4027,3.74907,1.01539>,<1.38072,3.72579,0.97465>,
            
    /*3*/ <1.55661,3.72177,0.95159>,<1.55217,3.76745,0.9554>,<1.53977,3.74629,0.91642>,
            
    /*4*/ <1.69304,3.79585,0.85914>,<1.6798,3.8327,0.86865>,<1.6669,3.81472,0.83497>,
            
    /*5*/ <1.8078,3.90821,0.78647>,<1.7899,3.9351,0.79869>,<1.78269,3.92232,0.76741>,
            
    /*6*/ <1.91362,4.03074,0.72645>,<1.89689,4.05133,0.73762>,<1.89234,4.04209,0.71074>,
            
    /*7*/ <2.012,4.16252,0.67474>,<1.99745,4.17761,0.68426>,<1.99461,4.17114,0.66234>,
            
    /*8*/ <2.1133,4.28885,0.62002>,<2.1028,4.30067,0.62698>,<2.10041,4.29553,0.61066>,
            
    /*9*/ <2.22056,4.40839,0.56175>,<2.21398,4.41673,0.5662>,<2.21217,4.4131,0.55542>,
            
    /*10*/ <2.31268,4.54234,0.50516>,<2.30901,4.54603,0.50762>,<2.30817,4.54431,0.50219>,
            
    /*11*/ <2.39472,4.68928,0.4715>

    /* stem 0.0c0.1.0*/ 
    /*0*/ <1.3432,3.7382,1.02075>,
    /*1*/ <1.34755,3.75144,1.02231>,<1.3462,3.73117,1.00899>,<1.33586,3.73199,1.03096>,
            
    /*2*/ <1.90161,3.52315,1.29157>

    /* stem 0.0c0.1.1*/ 
    /*0*/ <1.46326,3.73399,0.97465>,
    /*1*/ <1.46032,3.72587,0.96438>,<1.47492,3.73264,0.98115>,<1.45453,3.74347,0.97841>,
            
    /*2*/ <1.73075,4.13757,0.57881>

    /* stem 0.0c0.1.2*/ 
    /*0*/ <1.60902,3.77677,0.90149>,
    /*1*/ <1.61607,3.77661,0.91195>,<1.60846,3.78721,0.89441>,<1.60251,3.7665,0.8981>,
            
    /*2*/ <2.06661,3.58992,0.58996>

    /* stem 0.0c0.1.3*/ 
    /*0*/ <1.74823,3.87908,0.8121>,
    /*1*/ <1.73949,3.88513,0.80722>,<1.75792,3.87679,0.80594>,<1.74729,3.8753,0.82313>,
            
    /*2*/ <1.9676,4.33698,0.98746>

    /* stem 0.0c0.1.4*/ 
    /*0*/ <1.82492,3.95685,0.76685>,
    /*1*/ <1.8323,3.94892,0.76425>,<1.82814,3.96575,0.77273>,<1.81431,3.95587,0.76358>,
            
    /*2*/ <1.9357,4.20177,0.33491>

    /* stem 0.0c0.1.5*/ 
    /*0*/ <1.88378,4.02229,0.7344>,
    /*1*/ <1.88116,4.0287,0.74257>,<1.88512,4.02639,0.72461>,<1.88505,4.0118,0.73603>,
            
    /*2*/ <2.35525,4.09396,0.8293>

    /* stem 0.0c0.1.6*/ 
    /*0*/ <1.94496,4.09795,0.70251>,
    /*1*/ <1.9423,4.09618,0.69281>,<1.9548,4.09915,0.70497>,<1.93779,4.09853,0.70975>,
            
    /*2*/ <1.90812,4.5523,0.62948>

    /* stem 0.0c0.1.7*/ 
    /*0*/ <2.05212,4.23115,0.64719>,
    /*1*/ <2.05855,4.22851,0.65344>,<2.05074,4.24023,0.64545>,<2.04706,4.22471,0.64268>,
            
    /*2*/ <2.34054,4.217,0.34425>

    /* stem 0.0c0.1.8*/ 
    /*0*/ <2.16283,4.35634,0.58896>,
    /*1*/ <2.15665,4.36173,0.58818>,<2.16805,4.35511,0.5827>,<2.1638,4.35217,0.596>,
            
    /*2*/ <2.38499,4.62987,0.72021>

    /* stem 0.0c0.1.9*/ 
    /*0*/ <2.28437,4.50858,0.52021>,
    /*1*/ <2.28663,4.50593,0.51782>,<2.28632,4.51124,0.52285>,<2.28015,4.50857,0.51996>,
            
    /*2*/ <2.29781,4.73349,0.2841>

    /* stem 0.0c0.1.10*/ 
    /*0*/ <2.35185,4.61593,0.48844>,
    /*1*/ <2.35171,4.61639,0.49005>,<2.35169,4.61708,0.48722>,<2.35215,4.61433,0.48804>,
            
    /*2*/ <2.64199,4.66761,0.49901>

    /* stem 0.0c0.2*/ 
    /*0*/ <2.14706,3.85654,1.18859>,
    /*1*/ <2.14469,3.88286,1.19222>,<2.16311,3.8471,1.1695>,<2.13337,3.83966,1.20406>,
            
    /*2*/ <2.25076,3.8773,1.28234>,<2.26734,3.84511,1.2619>,<2.24057,3.83842,1.293>,
            
    /*3*/ <2.36244,3.90472,1.35146>,<2.38023,3.87702,1.33467>,<2.36217,3.87089,1.36633>,
            
    /*4*/ <2.44621,3.98118,1.41616>,<2.47067,3.96172,1.40787>,<2.45434,3.95639,1.43526>,
            
    /*5*/ <2.53312,4.08024,1.45004>,<2.55468,4.06436,1.44288>,<2.54511,4.06384,1.46889>,
            
    /*6*/ <2.61244,4.18265,1.50003>,<2.63162,4.17085,1.49488>,<2.62175,4.16835,1.51561>,
            
    /*7*/ <2.67926,4.29678,1.53726>,<2.69553,4.28878,1.53365>,<2.68818,4.28757,1.55057>,
            
    /*8*/ <2.75584,4.41004,1.56603>,<2.76751,4.40318,1.56305>,<2.7626,4.40321,1.57602>,
            
    /*9*/ <2.82517,4.52784,1.58985>,<2.83319,4.52368,1.58794>,<2.83,4.52381,1.59661>,
            
    /*10*/ <2.89458,4.64755,1.60453>,<2.89858,4.64544,1.60356>,<2.89712,4.64575,1.60794>,
            
    /*11*/ <2.96759,4.76605,1.60021>

    /* stem 0.0c0.2.0*/ 
    /*0*/ <2.19706,3.85516,1.23134>,
    /*1*/ <2.20255,3.84772,1.22468>,<2.19683,3.85361,1.24263>,<2.19179,3.86414,1.22672>,
            
    /*2*/ <2.65073,4.14635,1.28039>

    /* stem 0.0c0.2.1*/ 
    /*0*/ <2.3045,3.8673,1.31117>,
    /*1*/ <2.2988,3.86733,1.32031>,<2.31257,3.87431,1.30982>,<2.30213,3.86025,1.30337>,
            
    /*2*/ <2.62917,3.53277,1.51482>

    /* stem 0.0c0.2.2*/ 
    /*0*/ <2.43366,3.94475,1.40158>,
    /*1*/ <2.43511,3.9501,1.39332>,<2.44121,3.94312,1.40785>,<2.42465,3.94102,1.40357>,
            
    /*2*/ <2.3245,4.33319,1.634>

    /* stem 0.0c0.2.3*/ 
    /*0*/ <2.51289,4.03237,1.44163>,
    /*1*/ <2.51794,4.02639,1.44678>,<2.511,4.04093,1.44491>,<2.50973,4.02978,1.4332>,
            
    /*2*/ <2.87816,4.18305,1.25866>

    /* stem 0.0c0.2.4*/ 
    /*0*/ <2.5816,4.11967,1.47775>,
    /*1*/ <2.57441,4.12475,1.4783>,<2.58931,4.12319,1.47531>,<2.58108,4.11107,1.47964>,
            
    /*2*/ <2.66826,4.2001,1.86755>

    /* stem 0.0c0.2.5*/ 
    /*0*/ <2.72831,4.35364,1.55574>,
    /*1*/ <2.73347,4.3515,1.55078>,<2.73035,4.35546,1.56269>,<2.72113,4.35396,1.55375>,
            
    /*2*/ <2.76934,4.67532,1.45951>

    /* stem 0.0c0.2.6*/ 
    /*0*/ <2.79854,4.4703,1.58088>,
    /*1*/ <2.79722,4.46981,1.58729>,<2.79763,4.476,1.57778>,<2.80078,4.46509,1.57759>,
            
    /*2*/ <3.08508,4.55192,1.64619>

    /* stem 0.0c0.2.7*/ 
    /*0*/ <2.86808,4.59463,1.59943>,
    /*1*/ <2.86647,4.59589,1.59622>,<2.87178,4.59525,1.60008>,<2.866,4.59274,1.60199>,
            
    /*2*/ <2.80709,4.82796,1.72195>

    /* stem 0.0c0.2.8*/ 
    /*0*/ <2.92328,4.6911,1.60342>,
    /*1*/ <2.92466,4.69031,1.60393>,<2.92287,4.69258,1.60409>,<2.92231,4.69043,1.60224>,
            
    /*2*/ <3.05229,4.80587,1.43138>

    /* stem 0.0c0.3*/ 
    /*0*/ <2.49875,3.87204,1.209>,
    /*1*/ <2.49959,3.85821,1.19363>,<2.50515,3.86682,1.22798>,<2.49152,3.89109,1.2054>,
            
    /*2*/ <2.61692,3.89872,1.16637>,<2.62192,3.90647,1.19729>,<2.60965,3.92831,1.17696>,
            
    /*3*/ <2.72346,3.96481,1.13517>,<2.72787,3.97146,1.16272>,<2.71221,3.98882,1.14611>,
            
    /*4*/ <2.80476,4.05179,1.08904>,<2.8109,4.05887,1.11231>,<2.79201,4.07023,1.10032>,
            
    /*5*/ <2.88319,4.15239,1.06427>,<2.88589,4.15581,1.08534>,<2.86992,4.16564,1.0748>,
            
    /*6*/ <2.94867,4.25995,1.04185>,<2.9508,4.26261,1.05945>,<2.93658,4.26951,1.051>,
            
    /*7*/ <3.00043,4.3738,1.01719>,<3.0023,4.37621,1.03119>,<2.99017,4.38034,1.02478>,
            
    /*8*/ <3.05795,4.48285,0.98841>,<3.05952,4.48495,0.99884>,<3.05058,4.48838,0.99395>,
            
    /*9*/ <3.11159,4.59696,0.96871>,<3.11239,4.59791,0.97577>,<3.10641,4.60016,0.97251>,
            
    /*10*/ <3.159,4.71545,0.97927>,<3.15904,4.71516,0.98284>,<3.15615,4.71647,0.98118>,
            
    /*11*/ <3.21737,4.82703,0.99631>

    /* stem 0.0c0.3.0*/ 
    /*0*/ <2.54931,3.88889,1.1966>,
    /*1*/ <2.5512,3.88957,1.20523>,<2.55048,3.89585,1.19125>,<2.54624,3.88125,1.19333>,
            
    /*2*/ <3.01324,3.7412,1.10664>

    /* stem 0.0c0.3.1*/ 
    /*0*/ <2.66589,3.94141,1.16496>,
    /*1*/ <2.66161,3.94549,1.15907>,<2.67302,3.93754,1.163>,<2.66305,3.94119,1.1728>,
            
    /*2*/ <2.90211,4.32818,1.26117>

    /* stem 0.0c0.3.2*/ 
    /*0*/ <2.83008,4.09515,1.09136>,
    /*1*/ <2.83589,4.09056,1.09137>,<2.83032,4.10144,1.09527>,<2.82402,4.09345,1.08745>,
            
    /*2*/ <2.98349,4.28927,0.76962>

    /* stem 0.0c0.3.3*/ 
    /*0*/ <2.91501,4.21502,1.06187>,
    /*1*/ <2.9111,4.21844,1.06629>,<2.91584,4.21737,1.05553>,<2.91807,4.20924,1.06379>,
            
    /*2*/ <3.20996,4.40867,1.17276>

    /* stem 0.0c0.3.4*/ 
    /*0*/ <2.96142,4.29868,1.04266>,
    /*1*/ <2.9616,4.29714,1.03642>,<2.96676,4.30065,1.04563>,<2.9559,4.29824,1.04592>,
            
    /*2*/ <2.88671,4.62654,0.95951>

    /* stem 0.0c0.3.5*/ 
    /*0*/ <3.01991,4.41822,1.01269>,
    /*1*/ <3.02323,4.41781,1.01752>,<3.01689,4.42315,1.01162>,<3.01961,4.41372,1.00893>,
            
    /*2*/ <3.26483,4.53394,0.85459>

    /* stem 0.0c0.3.6*/ 
    /*0*/ <3.12682,4.6392,0.97538>,
    /*1*/ <3.12383,4.6405,0.97434>,<3.12972,4.64015,0.97384>,<3.12691,4.63696,0.97796>,
            
    /*2*/ <3.15257,4.83014,1.14039>

    /* stem 0.0c0.3.7*/ 
    /*0*/ <3.17872,4.75447,0.98639>,
    /*1*/ <3.17984,4.75394,0.98587>,<3.17875,4.75509,0.98759>,<3.17755,4.75438,0.98572>,
            
    /*2*/ <3.22297,4.94829,0.88501>

    /* stem 0.0c0.4*/ 
    /*0*/ <2.88622,3.87161,1.2235>,
    /*1*/ <2.88582,3.87209,1.23761>,<2.89263,3.88191,1.21626>,<2.88021,3.86083,1.21662>,
            
    /*2*/ <2.98371,3.81445,1.24094>,<2.98984,3.82329,1.22173>,<2.97866,3.80432,1.22206>,
            
    /*3*/ <3.09651,3.80237,1.24444>,<3.09823,3.81146,1.22719>,<3.09613,3.79201,1.22783>,
            
    /*4*/ <3.2097,3.81695,1.22442>,<3.20615,3.82536,1.20993>,<3.20839,3.80838,1.20965>,
            
    /*5*/ <3.31286,3.8583,1.19753>,<3.30726,3.86497,1.18571>,<3.31248,3.85129,1.18463>,
            
    /*6*/ <3.40388,3.92171,1.17265>,<3.39801,3.92663,1.16311>,<3.40467,3.91648,1.16162>,
            
    /*7*/ <3.48192,4.00225,1.15659>,<3.47683,4.00582,1.14903>,<3.48363,3.99894,1.14754>,
            
    /*8*/ <3.53948,4.09958,1.15679>,<3.53551,4.10202,1.15111>,<3.54175,4.09833,1.14992>,
            
    /*9*/ <3.58956,4.20174,1.15399>,<3.58675,4.20307,1.15021>,<3.59108,4.20092,1.14941>,
            
    /*10*/ <3.62933,4.30811,1.14659>,<3.62784,4.30856,1.14471>,<3.63009,4.30769,1.1443>,
            
    /*11*/ <3.66472,4.41589,1.13974>

    /* stem 0.0c0.4.0*/ 
    /*0*/ <2.9572,3.82983,1.22694>,
    /*1*/ <2.95927,3.83297,1.22233>,<2.95767,3.8239,1.22695>,<2.95467,3.83262,1.23154>,
            
    /*2*/ <3.3446,3.86059,1.42188>

    /* stem 0.0c0.4.1*/ 
    /*0*/ <3.04649,3.80734,1.23096>,
    /*1*/ <3.04585,3.80183,1.23212>,<3.04957,3.81063,1.2344>,<3.04406,3.80957,1.22634>,
            
    /*2*/ <3.38444,3.72162,1.01107>

    /* stem 0.0c0.4.2*/ 
    /*0*/ <3.26158,3.83839,1.20146>,
    /*1*/ <3.26062,3.84245,1.20421>,<3.2643,3.83878,1.19728>,<3.25981,3.83393,1.20289>,
            
    /*2*/ <3.56061,3.78072,1.39067>

    /* stem 0.0c0.4.3*/ 
    /*0*/ <3.33796,3.877,1.18232>,
    /*1*/ <3.33777,3.8756,1.1778>,<3.34215,3.8777,1.18442>,<3.33395,3.87772,1.18474>,
            
    /*2*/ <3.33502,4.1991,1.08201>

    /* stem 0.0c0.4.4*/ 
    /*0*/ <3.44906,3.96975,1.15701>,
    /*1*/ <3.45088,3.96866,1.16073>,<3.44874,3.97388,1.15591>,<3.44756,3.96671,1.15438>,
            
    /*2*/ <3.71821,3.95462,1.02104>

    /* stem 0.0c0.4.5*/ 
    /*0*/ <3.52279,4.07288,1.15218>,
    /*1*/ <3.51967,4.07476,1.1508>,<3.52635,4.07392,1.151>,<3.52234,4.06997,1.15472>,
            
    /*2*/ <3.53899,4.24954,1.35732>

    /* stem 0.0c0.4.6*/ 
    /*0*/ <3.61507,4.27086,1.1473>,
    /*1*/ <3.61674,4.27019,1.14667>,<3.61503,4.27233,1.14852>,<3.61344,4.27005,1.14673>,
            
    /*2*/ <3.60585,4.40977,0.97868>

    /* stem 0.0c0.4.7*/ 
    /*0*/ <3.64958,4.3701,1.14206>,
    /*1*/ <3.6493,4.37022,1.14258>,<3.6495,4.37046,1.14159>,<3.64994,4.36962,1.14201>,
            
    /*2*/ <3.8003,4.47713,1.19894>

    /* stem 0.0c1*/ 
    /*0*/ <1.47097,3.70041,1.89625>,
    /*1*/ <1.4404,3.70089,1.89627>,<1.46199,3.72961,1.89743>,<1.49599,3.71797,1.89695>,
            <1.49542,3.68206,1.8955>,<1.46106,3.6715,1.89508>,
    /*2*/ <1.44718,3.68471,2.29479>,<1.46399,3.70708,2.29569>,<1.49049,3.69801,2.29532>,
            <1.49004,3.67003,2.29419>,<1.46327,3.66181,2.29386>,
    /*3*/ <1.4716,3.70388,2.6935>,<1.48361,3.71989,2.69219>,<1.50258,3.71338,2.69167>,
            <1.50229,3.69334,2.69265>,<1.48314,3.68747,2.69378>,
    /*4*/ <1.48567,3.7318,3.09073>,<1.49293,3.74147,3.08991>,<1.5044,3.73757,3.08998>,
            <1.50424,3.72548,3.09083>,<1.49266,3.72191,3.0913>,
    /*5*/ <1.48955,3.80146,3.4832>,<1.49204,3.80476,3.48263>,<1.496,3.80345,3.4829>,
            <1.49595,3.79933,3.48363>,<1.49196,3.79811,3.48382>,
    /*6*/ <1.4931,3.80142,3.48323>

    /* stem 0.0c1.0*/ 
    /*0*/ <1.47098,3.6943,2.04766>,
    /*1*/ <1.46656,3.72193,2.04878>,<1.49229,3.68294,2.06185>,<1.45409,3.67802,2.03236>,
            
    /*2*/ <1.38239,3.70108,2.16128>,<1.40556,3.66599,2.17305>,<1.37117,3.66156,2.1465>,
            
    /*3*/ <1.30357,3.72708,2.26622>,<1.31785,3.69629,2.28505>,<1.28654,3.69241,2.26245>,
            
    /*4*/ <1.21334,3.77201,2.36136>,<1.22156,3.74638,2.38207>,<1.19625,3.7427,2.35972>,
            
    /*5*/ <1.12489,3.8455,2.43636>,<1.12709,3.82651,2.45832>,<1.1067,3.82281,2.43788>,
            
    /*6*/ <1.05294,3.94785,2.49331>,<1.05154,3.93567,2.51424>,<1.03429,3.93289,2.49741>,
            
    /*7*/ <0.97937,4.05714,2.54425>,<0.97756,4.04834,2.56145>,<0.96411,4.04568,2.54772>,
            
    /*8*/ <0.94181,4.18097,2.59773>,<0.94024,4.17506,2.61093>,<0.92892,4.17556,2.60179>,
            
    /*9*/ <0.90996,4.3092,2.64869>,<0.90884,4.30555,2.65761>,<0.90125,4.30606,2.65159>,
            
    /*10*/ <0.88626,4.42966,2.72117>,<0.88585,4.42717,2.72532>,<0.88192,4.42803,2.72261>,
            
    /*11*/ <0.87008,4.5602,2.77357>

    /* stem 0.0c1.0.0*/ 
    /*0*/ <1.40764,3.68076,2.13197>,
    /*1*/ <1.41503,3.67262,2.13621>,<1.396,3.67927,2.13304>,<1.41189,3.69037,2.12666>,
            
    /*2*/ <1.41848,3.93935,2.60877>

    /* stem 0.0c1.0.1*/ 
    /*0*/ <1.35433,3.68733,2.20275>,
    /*1*/ <1.34539,3.68813,2.19579>,<1.35646,3.6956,2.21024>,<1.36115,3.67826,2.20221>,
            
    /*2*/ <1.05807,3.44408,2.55546>

    /* stem 0.0c1.0.2*/ 
    /*0*/ <1.2617,3.72676,2.31406>,
    /*1*/ <1.26937,3.73273,2.3184>,<1.25571,3.72048,2.32023>,<1.26002,3.72707,2.30355>,
            
    /*2*/ <0.94531,4.08887,2.37533>

    /* stem 0.0c1.0.3*/ 
    /*0*/ <1.14637,3.80861,2.42162>,
    /*1*/ <1.1411,3.80058,2.42355>,<1.14189,3.8168,2.41864>,<1.1561,3.80846,2.42266>,
            
    /*2*/ <1.10337,3.93789,2.84186>

    /* stem 0.0c1.0.4*/ 
    /*0*/ <1.07033,3.9036,2.48278>,
    /*1*/ <1.0722,3.90879,2.4755>,<1.07046,3.90726,2.49115>,<1.06832,3.89476,2.4817>,
            
    /*2*/ <0.67403,3.99771,2.44773>

    /* stem 0.0c1.0.5*/ 
    /*0*/ <0.95966,4.09886,2.57115>,
    /*1*/ <0.96273,4.09684,2.5782>,<0.95212,4.10134,2.57066>,<0.96412,4.0984,2.56459>,
            
    /*2*/ <1.06544,4.42947,2.61981>

    /* stem 0.0c1.0.6*/ 
    /*0*/ <0.91795,4.25868,2.63435>,
    /*1*/ <0.91216,4.25856,2.6311>,<0.92202,4.2639,2.6337>,<0.91969,4.25359,2.63825>,
            
    /*2*/ <0.78075,4.39533,2.87394>

    /* stem 0.0c1.0.7*/ 
    /*0*/ <0.89524,4.37003,2.68924>,
    /*1*/ <0.8992,4.37111,2.68861>,<0.89349,4.37062,2.69295>,<0.89304,4.36837,2.68615>,
            
    /*2*/ <0.81381,4.62364,2.61082>

    /* stem 0.0c1.0.8*/ 
    /*0*/ <0.87437,4.52147,2.75873>,
    /*1*/ <0.87389,4.52118,2.75934>,<0.8742,4.52219,2.75838>,<0.87502,4.52103,2.75848>,
            
    /*2*/ <1.01065,4.63099,2.91907>

    /* stem 0.0c1.1*/ 
    /*0*/ <1.4946,3.765,3.27828>,
    /*1*/ <1.49997,3.76046,3.27913>,<1.48849,3.76394,3.2817>,<1.49535,3.77061,3.27402>,
            
    /*2*/ <1.53281,3.81461,3.35554>,<1.52247,3.81774,3.35785>,<1.52865,3.82375,3.35094>,
            
    /*3*/ <1.56554,3.88166,3.4219>,<1.55631,3.88431,3.42387>,<1.56132,3.88888,3.41678>,
            
    /*4*/ <1.61077,3.957,3.46786>,<1.60317,3.9601,3.47037>,<1.60658,3.96262,3.4629>,
            
    /*5*/ <1.63827,4.03754,3.52044>,<1.63121,4.03911,3.52181>,<1.63451,4.04188,3.51584>,
            
    /*6*/ <1.64877,4.12665,3.56485>,<1.64268,4.1271,3.56546>,<1.64543,4.12928,3.56043>,
            
    /*7*/ <1.66159,4.2135,3.61087>,<1.65674,4.21396,3.61142>,<1.65894,4.21575,3.60742>,
            
    /*8*/ <1.67561,4.3087,3.63613>,<1.67199,4.30914,3.63658>,<1.67353,4.30978,3.6333>,
            
    /*9*/ <1.68492,4.40629,3.65267>,<1.68249,4.40649,3.65295>,<1.6835,4.40677,3.65073>,
            
    /*10*/ <1.69338,4.50341,3.67124>,<1.69216,4.5035,3.67137>,<1.69267,4.50366,3.67027>,
            
    /*11*/ <1.70524,4.59975,3.69176>

    /* stem 0.0c1.1.0*/ 
    /*0*/ <1.50557,3.78265,3.30342>,
    /*1*/ <1.5027,3.78308,3.30436>,<1.5076,3.78491,3.30364>,<1.5064,3.77996,3.30225>,
            
    /*2*/ <1.60444,3.65902,3.6589>

    /* stem 0.0c1.1.1*/ 
    /*0*/ <1.57774,3.91226,3.43768>,
    /*1*/ <1.57917,3.91277,3.43544>,<1.57889,3.91254,3.44011>,<1.57516,3.91148,3.43749>,
            
    /*2*/ <1.47784,4.23778,3.44748>

    /* stem 0.0c1.1.2*/ 
    /*0*/ <1.6138,3.97981,3.48013>,
    /*1*/ <1.61389,3.97839,3.48225>,<1.61299,3.98223,3.48025>,<1.61451,3.97882,3.47789>,
            
    /*2*/ <1.91348,4.07756,3.53254>

    /* stem 0.0c1.1.3*/ 
    /*0*/ <1.6426,4.10334,3.55138>,
    /*1*/ <1.64104,4.10425,3.54996>,<1.64456,4.10447,3.5518>,<1.6422,4.10131,3.55238>,
            
    /*2*/ <1.51948,4.23527,3.77126>

    /* stem 0.0c1.1.4*/ 
    /*0*/ <1.6654,4.25532,3.62088>,
    /*1*/ <1.66737,4.25499,3.62097>,<1.66449,4.25636,3.62233>,<1.66434,4.25462,3.61934>,
            
    /*2*/ <1.70567,4.4621,3.4982>

    /* stem 0.0c1.1.5*/ 
    /*0*/ <1.67959,4.3668,3.64527>,
    /*1*/ <1.67821,4.36677,3.64627>,<1.67984,4.36811,3.6442>,<1.68072,4.36553,3.64533>,
            
    /*2*/ <1.78895,4.47193,3.79923>

    /* stem 0.0c1.1.6*/ 
    /*0*/ <1.69861,4.54875,3.68074>,
    /*1*/ <1.69871,4.54882,3.68038>,<1.69878,4.54894,3.68101>,<1.69835,4.5485,3.68082>,
            
    /*2*/ <1.57829,4.67046,3.67126>

    /* stem 0.0c2*/ 
    /*0*/ <1.98805,3.7156,2.50023>,
    /*1*/ <1.97213,3.71598,2.50638>,<1.98308,3.73191,2.50098>,<2.00089,3.72529,2.49453>,
            <2.00095,3.70528,2.49596>,<1.98318,3.69953,2.50328>,
    /*2*/ <2.12257,3.74274,2.87486>,<2.12918,3.75236,2.8716>,<2.13994,3.74836,2.8677>,
            <2.13998,3.73627,2.86857>,<2.12925,3.73279,2.87299>,
    /*3*/ <2.27112,3.72474,3.24461>,<2.27353,3.72806,3.24384>,<2.2772,3.72668,3.24237>,
            <2.27704,3.7225,3.24223>,<2.27328,3.7213,3.24361>,
    /*4*/ <2.27444,3.72466,3.24333>

    /* stem 0.0c2.0*/ 
    /*0*/ <2.19745,3.73431,3.0419>,
    /*1*/ <2.19654,3.74144,3.04259>,<2.20407,3.73147,3.04222>,<2.19173,3.73003,3.0409>,
            
    /*2*/ <2.18733,3.73003,3.14101>,<2.1941,3.72106,3.14068>,<2.183,3.71977,3.13949>,
            
    /*3*/ <2.16097,3.7593,3.2294>,<2.16591,3.75161,3.23343>,<2.15629,3.7506,3.2309>,
            
    /*4*/ <2.13648,3.81259,3.30787>,<2.14027,3.8067,3.3131>,<2.13182,3.80589,3.31101>,
            
    /*5*/ <2.13126,3.87682,3.38287>,<2.13461,3.87188,3.38739>,<2.12714,3.87196,3.38681>,
            
    /*6*/ <2.14135,3.95582,3.44082>,<2.14422,3.95233,3.44513>,<2.13801,3.95301,3.44529>,
            
    /*7*/ <2.14698,4.04161,3.49013>,<2.14932,4.03932,3.4939>,<2.14434,4.03966,3.49389>,
            
    /*8*/ <2.14964,4.12898,3.53755>,<2.1514,4.12738,3.54044>,<2.14766,4.12753,3.54038>,
            
    /*9*/ <2.14283,4.22034,3.57585>,<2.14399,4.21957,3.57793>,<2.1415,4.21945,3.57777>,
            
    /*10*/ <2.16018,4.31022,3.61488>,<2.16076,4.30969,3.61585>,<2.15953,4.30991,3.6159>,
            
    /*11*/ <2.18215,4.39625,3.65991>

    /* stem 0.0c2.0.0*/ 
    /*0*/ <2.19069,3.72654,3.11348>,
    /*1*/ <2.19291,3.72447,3.11347>,<2.18798,3.72586,3.11469>,<2.19117,3.72929,3.11229>,
            
    /*2*/ <2.31008,3.85199,3.45247>

    /* stem 0.0c2.0.1*/ 
    /*0*/ <2.15057,3.77686,3.26475>,
    /*1*/ <2.14798,3.777,3.26384>,<2.15193,3.77915,3.26539>,<2.15179,3.77441,3.26502>,
            
    /*2*/ <2.03679,3.75452,3.58457>

    /* stem 0.0c2.0.2*/ 
    /*0*/ <2.13271,3.85212,3.36101>,
    /*1*/ <2.13496,3.85305,3.36036>,<2.13212,3.85183,3.36345>,<2.13104,3.85148,3.35922>,
            
    /*2*/ <2.0159,4.13958,3.36752>

    /* stem 0.0c2.0.3*/ 
    /*0*/ <2.13802,3.92877,3.42568>,
    /*1*/ <2.13713,3.92757,3.42749>,<2.13752,3.93105,3.42541>,<2.13942,3.92769,3.42413>,
            
    /*2*/ <2.36629,3.99758,3.58374>

    /* stem 0.0c2.0.4*/ 
    /*0*/ <2.14804,4.07811,3.51286>,
    /*1*/ <2.14741,4.07904,3.51116>,<2.14937,4.07904,3.5141>,<2.14734,4.07625,3.51333>,
            
    /*2*/ <1.9627,4.1789,3.63628>

    /* stem 0.0c2.0.5*/ 
    /*0*/ <2.14635,4.17147,3.55733>,
    /*1*/ <2.14789,4.17119,3.55827>,<2.14491,4.17223,3.55814>,<2.14625,4.17097,3.55558>,
            
    /*2*/ <2.21815,4.37,3.49712>

    /* stem 0.0c2.0.6*/ 
    /*0*/ <2.17535,4.36956,3.64619>,
    /*1*/ <2.17513,4.36959,3.64624>,<2.17547,4.36973,3.64612>,<2.17544,4.36936,3.64621>,
            
    /*2*/ <2.21486,4.40518,3.80406>

    /* stem 0.0.0*/ 
    /*0*/ <0.25131,3.76888,0.27602>,
    /*1*/ <0.27865,3.79465,0.25909>,<0.26284,3.73085,0.28689>,<0.21244,3.78115,0.28207>,
            
    /*2*/ <0.3297,3.86494,0.45856>,<0.31547,3.80751,0.48358>,<0.27011,3.85278,0.47924>,
            
    /*3*/ <0.37867,3.9911,0.61761>,<0.37076,3.94839,0.65467>,<0.3273,3.98284,0.64113>,
            
    /*4*/ <0.43512,4.12796,0.77444>,<0.42906,4.09227,0.80888>,<0.3908,4.12201,0.79673>,
            
    /*5*/ <0.49,4.27691,0.92094>,<0.48567,4.24839,0.95258>,<0.45227,4.27241,0.94068>,
            
    /*6*/ <0.57797,4.43227,1.03636>,<0.57661,4.41196,1.06567>,<0.54931,4.43347,1.05759>,
            
    /*7*/ <0.65777,4.60546,1.13855>,<0.65782,4.59136,1.16338>,<0.6349,4.60651,1.15562>,
            
    /*8*/ <0.69298,4.7906,1.25115>,<0.69274,4.77982,1.26964>,<0.67458,4.78801,1.26179>,
            
    /*9*/ <0.74814,4.95827,1.37914>,<0.7477,4.9499,1.3907>,<0.736,4.95693,1.38653>,
            
    /*10*/ <0.80805,5.13245,1.49384>,<0.80798,5.12865,1.49988>,<0.80209,5.13207,1.49775>,
            
    /*11*/ <0.84635,5.33379,1.56493>

    /* stem 0.0.0.0*/ 
    /*0*/ <0.28963,3.8208,0.41694>,
    /*1*/ <0.28869,3.80461,0.42316>,<0.28137,3.83373,0.42508>,<0.29884,3.82406,0.40258>,
            
    /*2*/ <0.96616,3.96024,0.88233>

    /* stem 0.0.0.1*/ 
    /*0*/ <0.32296,3.88568,0.52824>,
    /*1*/ <0.31214,3.89714,0.52254>,<0.33738,3.89054,0.53526>,<0.31936,3.86937,0.52691>,
            
    /*2*/ <-0.03295,3.90604,1.24505>

    /* stem 0.0.0.2*/ 
    /*0*/ <0.35059,3.95364,0.61244>,
    /*1*/ <0.36617,3.94933,0.6108>,<0.34368,3.95373,0.62716>,<0.3419,3.95785,0.59936>,
            
    /*2*/ <0.56439,4.69111,0.70799>

    /* stem 0.0.0.3*/ 
    /*0*/ <0.37707,4.01688,0.68534>,
    /*1*/ <0.36429,4.01296,0.69376>,<0.38071,4.0321,0.68315>,<0.3862,4.0056,0.67912>,
            
    /*2*/ <0.79136,4.00756,1.31014>

    /* stem 0.0.0.4*/ 
    /*0*/ <0.44418,4.18216,0.85825>,
    /*1*/ <0.44808,4.19111,0.8473>,<0.45334,4.17986,0.86946>,<0.43111,4.17552,0.85797>,
            
    /*2*/ <0.16588,4.71604,1.19547>

    /* stem 0.0.0.5*/ 
    /*0*/ <0.49173,4.2933,0.95779>,
    /*1*/ <0.49758,4.28387,0.96622>,<0.48585,4.30474,0.96315>,<0.49177,4.29129,0.94399>,
            
    /*2*/ <1.06179,4.60733,0.91349>

    /* stem 0.0.0.6*/ 
    /*0*/ <0.53741,4.37276,1.01497>,
    /*1*/ <0.52616,4.38002,1.01388>,<0.5493,4.37833,1.0121>,<0.53679,4.35994,1.01893>,
            
    /*2*/ <0.59651,4.55403,1.61165>

    /* stem 0.0.0.7*/ 
    /*0*/ <0.62031,4.53748,1.11645>,
    /*1*/ <0.63114,4.53574,1.11054>,<0.62005,4.53827,1.12888>,<0.60974,4.53841,1.10992>,
            
    /*2*/ <0.69246,5.10769,1.08146>

    /* stem 0.0.0.8*/ 
    /*0*/ <0.66014,4.65152,1.18203>,
    /*1*/ <0.6542,4.64726,1.19131>,<0.65761,4.66226,1.17783>,<0.6686,4.64503,1.17695>,
            
    /*2*/ <1.02779,4.86876,1.51683>

    /* stem 0.0.0.9*/ 
    /*0*/ <0.72402,4.89619,1.34204>,
    /*1*/ <0.7227,4.90216,1.33455>,<0.73115,4.89787,1.34837>,<0.71823,4.88852,1.34321>,
            
    /*2*/ <0.43115,5.15716,1.60208>

    /* stem 0.0.0.10*/ 
    /*0*/ <0.7578,4.99429,1.41037>,
    /*1*/ <0.76312,4.9904,1.41354>,<0.75318,4.99821,1.41448>,<0.75708,4.99426,1.40308>,
            
    /*2*/ <1.02791,5.34154,1.38266>

    /* stem 0.0.0.11*/ 
    /*0*/ <0.79324,5.09478,1.47413>,
    /*1*/ <0.78848,5.096,1.47485>,<0.79656,5.09829,1.47295>,<0.79469,5.09005,1.4746>,
            
    /*2*/ <0.86934,5.15707,1.8732>

    /* stem 0.0.0.12*/ 
    /*0*/ <0.82779,5.24046,1.53373>,
    /*1*/ <0.82916,5.24062,1.53242>,<0.82805,5.24115,1.53547>,<0.82615,5.2396,1.53329>,
            
    /*2*/ <0.68592,5.56712,1.426>

    /* stem 0.0.1*/ 
    /*0*/ <0.34358,3.7612,0.40117>,
    /*1*/ <0.33709,3.72164,0.4052>,<0.33527,3.78618,0.43165>,<0.35839,3.77576,0.36665>,
            
    /*2*/ <0.53493,3.70077,0.47892>,<0.53329,3.75885,0.50273>,<0.5541,3.74947,0.44423>,
            
    /*3*/ <0.73853,3.73876,0.55849>,<0.72339,3.79011,0.57427>,<0.74488,3.78173,0.52344>,
            
    /*4*/ <0.9223,3.83725,0.63229>,<0.89731,3.87823,0.64134>,<0.9184,3.8716,0.59779>,
            
    /*5*/ <1.07937,3.96904,0.70387>,<1.05182,4.00017,0.70881>,<1.07211,3.99574,0.67246>,
            
    /*6*/ <1.21126,4.12394,0.77516>,<1.18462,4.14637,0.77731>,<1.20319,4.14411,0.74786>,
            
    /*7*/ <1.33831,4.28083,0.84213>,<1.31663,4.29834,0.84369>,<1.33139,4.29647,0.82008>,
            
    /*8*/ <1.42856,4.45955,0.91938>,<1.41012,4.46944,0.91894>,<1.42282,4.47022,0.90232>,
            
    /*9*/ <1.51485,4.64638,0.97492>,<1.50233,4.65255,0.97449>,<1.51035,4.65224,0.96307>,
            
    /*10*/ <1.58852,4.82025,1.07014>,<1.58222,4.82323,1.06984>,<1.58677,4.82415,1.06463>,
            
    /*11*/ <1.65919,5.00018,1.15798>

    /* stem 0.0.1.0*/ 
    /*0*/ <0.48877,3.74291,0.45574>,
    /*1*/ <0.48725,3.7573,0.4646>,<0.50331,3.73935,0.44779>,<0.47574,3.7321,0.45485>,
            
    /*2*/ <0.75879,3.36286,1.11934>

    /* stem 0.0.1.1*/ 
    /*0*/ <0.59555,3.74588,0.49688>,
    /*1*/ <0.60204,3.74066,0.48271>,<0.60045,3.73924,0.5111>,<0.58417,3.75773,0.49683>,
            
    /*2*/ <1.15865,4.28715,0.55554>

    /* stem 0.0.1.2*/ 
    /*0*/ <0.67882,3.76034,0.52969>,
    /*1*/ <0.6742,3.75461,0.54393>,<0.68773,3.77363,0.52892>,<0.67452,3.75278,0.51624>,
            
    /*2*/ <1.3115,3.338,0.56468>

    /* stem 0.0.1.3*/ 
    /*0*/ <0.80308,3.80532,0.57941>,
    /*1*/ <0.80042,3.81747,0.57037>,<0.81676,3.79832,0.57904>,<0.79206,3.80018,0.58881>,
            
    /*2*/ <1.0439,4.24805,1.10372>

    /* stem 0.0.1.4*/ 
    /*0*/ <0.97036,3.90921,0.6503>,
    /*1*/ <0.97925,3.89789,0.65097>,<0.96892,3.91792,0.66169>,<0.9629,3.91181,0.63825>,
            
    /*2*/ <1.47736,4.29383,0.41986>

    /* stem 0.0.1.5*/ 
    /*0*/ <1.10117,4.02625,0.71321>,
    /*1*/ <1.09103,4.03178,0.72029>,<1.1095,4.03414,0.70601>,<1.10297,4.01282,0.71333>,
            
    /*2*/ <1.48186,4.08197,1.21454>

    /* stem 0.0.1.6*/ 
    /*0*/ <1.15978,4.09282,0.74508>,
    /*1*/ <1.16535,4.09359,0.73324>,<1.16728,4.09198,0.7558>,<1.14672,4.09289,0.7462>,
            
    /*2*/ <1.16661,4.70062,0.78774>

    /* stem 0.0.1.7*/ 
    /*0*/ <1.23496,4.18015,0.7855>,
    /*1*/ <1.23638,4.1741,0.79639>,<1.23271,4.19248,0.78543>,<1.2358,4.17386,0.77468>,
            
    /*2*/ <1.80533,4.28424,0.7689>

    /* stem 0.0.1.8*/ 
    /*0*/ <1.38593,4.40062,0.88405>,
    /*1*/ <1.37846,4.40697,0.87865>,<1.39681,4.40319,0.88361>,<1.38251,4.39171,0.8899>,
            
    /*2*/ <1.33376,4.69339,1.29999>

    /* stem 0.0.1.9*/ 
    /*0*/ <1.46233,4.55318,0.94056>,
    /*1*/ <1.47158,4.54916,0.93917>,<1.46001,4.55767,0.94941>,<1.45539,4.55272,0.93312>,
            
    /*2*/ <1.61507,4.96262,0.77277>

    /* stem 0.0.1.10*/ 
    /*0*/ <1.52741,4.69133,0.99399>,
    /*1*/ <1.52203,4.69111,0.99861>,<1.52912,4.69745,0.99082>,<1.53108,4.68544,0.99253>,
            
    /*2*/ <1.79893,4.78108,1.31391>

    /* stem 0.0.1.11*/ 
    /*0*/ <1.5748,4.79776,1.05419>,
    /*1*/ <1.57587,4.7996,1.0501>,<1.57796,4.79762,1.05754>,<1.57058,4.79607,1.05492>,
            
    /*2*/ <1.45438,5.15413,1.18306>

    /* stem 0.0.1.12*/ 
    /*0*/ <1.60798,4.87616,1.0953>,
    /*1*/ <1.60916,4.87464,1.09735>,<1.6064,4.8784,1.09595>,<1.60837,4.87545,1.09261>,
            
    /*2*/ <1.91252,5.09443,1.08168>

    /* stem 0.0.2*/ 
    /*0*/ <0.45105,3.75898,0.55257>,
    /*1*/ <0.43576,3.79322,0.56393>,<0.48873,3.75688,0.54202>,<0.42867,3.72683,0.55176>,
            
    /*2*/ <0.48949,3.74855,0.75743>,<0.53717,3.71585,0.73771>,<0.48311,3.6888,0.74648>,
            
    /*3*/ <0.55111,3.77181,0.94234>,<0.59583,3.74285,0.93185>,<0.55098,3.71802,0.94973>,
            
    /*4*/ <0.6221,3.83897,1.11719>,<0.66251,3.81478,1.11091>,<0.62595,3.79451,1.13349>,
            
    /*5*/ <0.70584,3.95375,1.25892>,<0.74135,3.93428,1.25459>,<0.71394,3.9209,1.28157>,
            
    /*6*/ <0.82254,4.08739,1.36214>,<0.85031,4.06904,1.35555>,<0.83234,4.06309,1.38371>,
            
    /*7*/ <0.91131,4.23261,1.47354>,<0.93552,4.22067,1.47062>,<0.91964,4.21421,1.49167>,
            
    /*8*/ <0.96416,4.39506,1.58304>,<0.98362,4.38908,1.5831>,<0.97109,4.38312,1.598>,
            
    /*9*/ <1.02585,4.58166,1.63795>,<1.03882,4.57763,1.6379>,<1.03147,4.5767,1.64927>,
            
    /*10*/ <1.06698,4.76678,1.71731>,<1.07361,4.76535,1.71751>,<1.06967,4.76393,1.72285>,
            
    /*11*/ <1.08255,4.96395,1.77131>

    /* stem 0.0.2.0*/ 
    /*0*/ <0.47617,3.73913,0.64621>,
    /*1*/ <0.49069,3.73269,0.64095>,<0.46766,3.73164,0.65852>,<0.47015,3.75306,0.63916>,
            
    /*2*/ <0.86715,4.18074,1.18525>

    /* stem 0.0.2.1*/ 
    /*0*/ <0.52146,3.72542,0.80356>,
    /*1*/ <0.50715,3.72067,0.80884>,<0.52757,3.73934,0.80848>,<0.52967,3.71626,0.79337>,
            
    /*2*/ <0.85387,3.37302,1.38795>

    /* stem 0.0.2.2*/ 
    /*0*/ <0.58079,3.75925,0.97877>,
    /*1*/ <0.5868,3.77114,0.97163>,<0.58883,3.75185,0.98922>,<0.56674,3.75475,0.97546>,
            
    /*2*/ <0.32321,4.19286,1.48377>

    /* stem 0.0.2.3*/ 
    /*0*/ <0.62645,3.80554,1.09422>,
    /*1*/ <0.62996,3.79205,1.09824>,<0.61926,3.8142,1.10338>,<0.63013,3.81037,1.08105>,
            
    /*2*/ <1.21872,4.03398,1.34332>

    /* stem 0.0.2.4*/ 
    /*0*/ <0.66298,3.85369,1.16573>,
    /*1*/ <0.65157,3.86192,1.16548>,<0.6758,3.85946,1.16624>,<0.66157,3.83969,1.16546>,
            
    /*2*/ <0.64115,3.84326,1.82452>

    /* stem 0.0.2.5*/ 
    /*0*/ <0.7527,3.97488,1.2938>,
    /*1*/ <0.76293,3.97211,1.28603>,<0.75415,3.97476,1.30687>,<0.74101,3.97777,1.28851>,
            
    /*2*/ <0.90454,4.56701,1.28238>

    /* stem 0.0.2.6*/ 
    /*0*/ <0.86017,4.11622,1.39927>,
    /*1*/ <0.85462,4.112,1.40926>,<0.8601,4.12816,1.39684>,<0.8658,4.1085,1.39171>,
            
    /*2*/ <1.33654,4.17847,1.69033>

    /* stem 0.0.2.7*/ 
    /*0*/ <0.94394,4.29393,1.52554>,
    /*1*/ <0.94197,4.30033,1.51671>,<0.95288,4.29576,1.53182>,<0.93697,4.2857,1.52808>,
            
    /*2*/ <0.67592,4.61015,1.81468>

    /* stem 0.0.2.8*/ 
    /*0*/ <0.98542,4.42905,1.59936>,
    /*1*/ <0.99357,4.42511,1.60431>,<0.9789,4.43531,1.60434>,<0.98378,4.42674,1.58945>,
            
    /*2*/ <1.24137,4.79777,1.47115>

    /* stem 0.0.2.9*/ 
    /*0*/ <1.0131,4.51787,1.6245>,
    /*1*/ <1.00443,4.52013,1.62606>,<1.01878,4.52393,1.62079>,<1.01609,4.50956,1.62666>,
            
    /*2*/ <1.12364,4.66247,2.02912>

    /* stem 0.0.2.10*/ 
    /*0*/ <1.04936,4.66364,1.67699>,
    /*1*/ <1.05366,4.6645,1.67281>,<1.05035,4.6653,1.68273>,<1.04408,4.66112,1.67543>,
            
    /*2*/ <0.89764,5.03088,1.59673>

    /* stem 0.0.2.11*/ 
    /*0*/ <1.07706,4.87653,1.74838>,
    /*1*/ <1.07691,4.8761,1.75004>,<1.07613,4.87782,1.74773>,<1.07816,4.87566,1.74737>,
            
    /*2*/ <1.33235,5.10283,1.83028>

    /* stem 0.0.3*/ 
    /*0*/ <0.61094,3.74916,0.76436>,
    /*1*/ <0.63823,3.73577,0.74221>,<0.60211,3.73126,0.79623>,<0.59248,3.78045,0.75463>,
            
    /*2*/ <0.76755,3.84528,0.84176>,<0.73505,3.84122,0.89037>,<0.72638,3.88549,0.85293>,
            
    /*3*/ <0.88196,3.97874,0.9356>,<0.85269,3.97492,0.97854>,<0.84107,4.01037,0.94216>,
            
    /*4*/ <0.97616,4.13291,1.01906>,<0.95033,4.12941,1.05647>,<0.93703,4.15613,1.022>,
            
    /*5*/ <1.07498,4.29439,1.05721>,<1.05731,4.29768,1.0919>,<1.04179,4.31477,1.06037>,
            
    /*6*/ <1.15601,4.47355,1.07521>,<1.14203,4.47754,1.10435>,<1.12655,4.48725,1.0774>,
            
    /*7*/ <1.22525,4.65782,1.08212>,<1.21431,4.66151,1.10547>,<1.20105,4.66731,1.08381>,
            
    /*8*/ <1.29575,4.84104,1.09142>,<1.28749,4.84367,1.10893>,<1.27765,4.84829,1.0927>,
            
    /*9*/ <1.37162,5.02078,1.11686>,<1.3658,5.02183,1.12846>,<1.35969,5.02593,1.11771>,
            
    /*10*/ <1.44724,5.20165,1.1182>,<1.44463,5.20282,1.12405>,<1.44128,5.20426,1.11865>,
            
    /*11*/ <1.52654,5.37947,1.09404>

    /* stem 0.0.3.0*/ 
    /*0*/ <0.68311,3.80827,0.81755>,
    /*1*/ <0.67573,3.80487,0.83133>,<0.68866,3.82304,0.81488>,<0.68492,3.79691,0.80643>,
            
    /*2*/ <1.34992,3.61292,1.12599>

    /* stem 0.0.3.1*/ 
    /*0*/ <0.78349,3.90312,0.89337>,
    /*1*/ <0.7822,3.91254,0.88141>,<0.79665,3.90235,0.9011>,<0.77163,3.89446,0.89759>,
            
    /*2*/ <0.55587,4.4295,1.33251>

    /* stem 0.0.3.2*/ 
    /*0*/ <0.87268,4.01028,0.96392>,
    /*1*/ <0.88235,4.00107,0.96973>,<0.8683,4.02195,0.97145>,<0.86739,4.00782,0.95058>,
            
    /*2*/ <1.3841,4.37666,0.69357>

    /* stem 0.0.3.3*/ 
    /*0*/ <0.92365,4.09077,1.00665>,
    /*1*/ <0.91137,4.09689,1.00977>,<0.93337,4.09782,0.99929>,<0.92623,4.07759,1.01089>,
            
    /*2*/ <1.18152,4.32188,1.56814>

    /* stem 0.0.3.4*/ 
    /*0*/ <1.00525,4.21929,1.0508>,
    /*1*/ <1.01287,4.2169,1.04011>,<1.01093,4.22252,1.06244>,<0.99197,4.21844,1.04986>,
            
    /*2*/ <0.97785,4.82073,0.89702>

    /* stem 0.0.3.5*/ 
    /*0*/ <1.09734,4.3857,1.07728>,
    /*1*/ <1.09768,4.38443,1.08966>,<1.09425,4.39664,1.07222>,<1.10011,4.37602,1.06996>,
            
    /*2*/ <1.65065,4.54269,1.0784>

    /* stem 0.0.3.6*/ 
    /*0*/ <1.16523,4.53959,1.08724>,
    /*1*/ <1.15781,4.54274,1.07882>,<1.17597,4.54411,1.08752>,<1.1619,4.53194,1.09537>,
            
    /*2*/ <0.98848,4.94109,1.39291>

    /* stem 0.0.3.7*/ 
    /*0*/ <1.24348,4.73647,1.09341>,
    /*1*/ <1.25328,4.73247,1.09457>,<1.2397,4.74346,1.10051>,<1.23745,4.73349,1.08515>,
            
    /*2*/ <1.42319,5.10076,0.83061>

    /* stem 0.0.3.8*/ 
    /*0*/ <1.30924,4.89484,1.10428>,
    /*1*/ <1.30151,4.89754,1.10971>,<1.31361,4.90135,1.09836>,<1.31261,4.88562,1.10478>,
            
    /*2*/ <1.58106,5.01192,1.43329>

    /* stem 0.0.3.9*/ 
    /*0*/ <1.34502,4.97595,1.11488>,
    /*1*/ <1.34758,4.97588,1.10677>,<1.35064,4.97736,1.12111>,<1.33683,4.97461,1.11677>,
            
    /*2*/ <1.27117,5.38965,1.08795>

    /* stem 0.0.3.10*/ 
    /*0*/ <1.40687,5.11707,1.12064>,
    /*1*/ <1.40895,5.11619,1.12571>,<1.40404,5.12173,1.11957>,<1.40763,5.1133,1.11663>,
            
    /*2*/ <1.73304,5.29177,1.01778>

    /* stem 0.0.3.11*/ 
    /*0*/ <1.49071,5.30248,1.10549>,
    /*1*/ <1.48934,5.30302,1.10478>,<1.49217,5.30281,1.1048>,<1.49064,5.30162,1.10688>,
            
    /*2*/ <1.51009,5.58638,1.2822>

    /* stem 0.0.4*/ 
    /*0*/ <0.88528,3.72606,1.12951>,
    /*1*/ <0.85825,3.71469,1.14837>,<0.89884,3.75758,1.13571>,<0.89875,3.70591,1.10445>,
            
    /*2*/ <0.97504,3.64318,1.26625>,<1.01158,3.68177,1.25486>,<1.0115,3.63527,1.22673>,
            
    /*3*/ <1.07393,3.64857,1.41612>,<1.10149,3.68378,1.39783>,<1.11372,3.63754,1.39103>,
            
    /*4*/ <1.18347,3.67352,1.56093>,<1.20428,3.70425,1.54068>,<1.21752,3.66422,1.53769>,
            
    /*5*/ <1.26275,3.7345,1.7091>,<1.28026,3.7599,1.69009>,<1.29543,3.72739,1.69516>,
            
    /*6*/ <1.33937,3.82889,1.84496>,<1.35188,3.84803,1.82524>,<1.36694,3.82335,1.83394>,
            
    /*7*/ <1.4243,3.93814,1.96412>,<1.43278,3.95182,1.94611>,<1.4457,3.93306,1.95414>,
            
    /*8*/ <1.4815,4.07938,2.06143>,<1.48698,4.0879,2.04641>,<1.49842,4.07708,2.05538>,
            
    /*9*/ <1.51022,4.23987,2.13891>,<1.51365,4.24459,2.12834>,<1.52185,4.23959,2.13566>,
            
    /*10*/ <1.53408,4.41518,2.17993>,<1.53564,4.4164,2.17422>,<1.53988,4.41489,2.17825>,
            
    /*11*/ <1.5272,4.59425,2.20189>

    /* stem 0.0.4.0*/ 
    /*0*/ <0.94459,3.68829,1.19178>,
    /*1*/ <0.95343,3.70017,1.19056>,<0.95023,3.67464,1.19016>,<0.93012,3.69006,1.19461>,
            
    /*2*/ <1.07569,3.6609,1.87897>

    /* stem 0.0.4.1*/ 
    /*0*/ <1.03987,3.65475,1.31289>,
    /*1*/ <1.04141,3.64075,1.3122>,<1.03852,3.6611,1.32542>,<1.03967,3.66242,1.30105>,
            
    /*2*/ <1.69637,3.72545,1.34755>

    /* stem 0.0.4.2*/ 
    /*0*/ <1.15438,3.66986,1.48135>,
    /*1*/ <1.14588,3.67873,1.48607>,<1.16718,3.67281,1.48052>,<1.15009,3.65804,1.47746>,
            
    /*2*/ <1.24129,3.45239,2.04686>

    /* stem 0.0.4.3*/ 
    /*0*/ <1.23157,3.70366,1.60463>,
    /*1*/ <1.24272,3.70324,1.59908>,<1.23052,3.70084,1.61672>,<1.22147,3.70689,1.59808>,
            
    /*2*/ <1.31997,4.25619,1.74108>

    /* stem 0.0.4.4*/ 
    /*0*/ <1.3041,3.77179,1.74402>,
    /*1*/ <1.29769,3.76568,1.7516>,<1.30388,3.78344,1.74426>,<1.31072,3.76625,1.73619>,
            
    /*2*/ <1.71243,3.77228,2.08917>

    /* stem 0.0.4.5*/ 
    /*0*/ <1.33202,3.80718,1.79609>,
    /*1*/ <1.33147,3.81667,1.78994>,<1.34147,3.80469,1.80183>,<1.32313,3.80017,1.79651>,
            
    /*2*/ <1.14943,4.06346,2.20772>

    /* stem 0.0.4.6*/ 
    /*0*/ <1.38498,3.87598,1.88221>,
    /*1*/ <1.39198,3.86814,1.88448>,<1.38103,3.88211,1.89011>,<1.38194,3.87769,1.87205>,
            
    /*2*/ <1.75519,4.18968,1.82403>

    /* stem 0.0.4.7*/ 
    /*0*/ <1.4677,4.02685,2.01568>,
    /*1*/ <1.45846,4.0291,2.01758>,<1.47425,4.0339,2.01447>,<1.47038,4.01756,2.01499>,
            
    /*2*/ <1.55408,4.0202,2.44299>

    /* stem 0.0.4.8*/ 
    /*0*/ <1.49939,4.14488,2.0861>,
    /*1*/ <1.50588,4.14679,2.08014>,<1.50086,4.14609,2.09491>,<1.49143,4.14176,2.08325>,
            
    /*2*/ <1.36207,4.52155,2.05729>

    /* stem 0.0.4.9*/ 
    /*0*/ <1.52161,4.29347,2.14722>,
    /*1*/ <1.5211,4.29211,2.15297>,<1.51852,4.29799,2.14495>,<1.52523,4.29031,2.14374>,
            
    /*2*/ <1.79462,4.51929,2.22535>

    /* stem 0.0.4.10*/ 
    /*0*/ <1.53301,4.48299,2.18669>,
    /*1*/ <1.53176,4.48316,2.18492>,<1.53457,4.48444,2.18706>,<1.53269,4.48135,2.18808>,
            
    /*2*/ <1.32864,4.66143,2.34881>

    /* stem 0.0.5*/ 
    /*0*/ <1.31006,3.70599,1.69022>,
    /*1*/ <1.3228,3.73224,1.68098>,<1.32655,3.68021,1.6904>,<1.28083,3.70552,1.69927>,
            
    /*2*/ <1.36649,3.75942,1.8286>,<1.36986,3.7126,1.83708>,<1.32871,3.73538,1.84507>,
            
    /*3*/ <1.41336,3.80359,1.96743>,<1.41803,3.76318,1.97943>,<1.38107,3.78301,1.98566>,
            
    /*4*/ <1.45791,3.88042,2.08958>,<1.46484,3.84873,2.10759>,<1.43133,3.86449,2.10999>,
            
    /*5*/ <1.51413,3.98502,2.18185>,<1.52311,3.96254,2.20248>,<1.49434,3.97587,2.205>,
            
    /*6*/ <1.55625,4.11581,2.24744>,<1.56612,4.10263,2.26821>,<1.54088,4.11072,2.26843>,
            
    /*7*/ <1.61376,4.25191,2.29035>,<1.62245,4.24319,2.30761>,<1.60284,4.25119,2.30851>,
            
    /*8*/ <1.6712,4.39261,2.32313>,<1.67813,4.387,2.3363>,<1.66337,4.39288,2.33697>,
            
    /*9*/ <1.71721,4.54019,2.32825>,<1.72256,4.53839,2.33723>,<1.71244,4.54154,2.33762>,
            
    /*10*/ <1.77006,4.6862,2.31685>,<1.77286,4.68563,2.32132>,<1.76788,4.68744,2.32152>,
            
    /*11*/ <1.80539,4.83196,2.27499>

    /* stem 0.0.5.0*/ 
    /*0*/ <1.33735,3.72408,1.77926>,
    /*1*/ <1.34041,3.71157,1.78087>,<1.33235,3.73086,1.78913>,<1.33929,3.72982,1.76778>,
            
    /*2*/ <1.89248,3.88192,1.9521>

    /* stem 0.0.5.1*/ 
    /*0*/ <1.37504,3.75514,1.89421>,
    /*1*/ <1.36522,3.76263,1.89512>,<1.38632,3.75931,1.89723>,<1.3736,3.74347,1.89029>,
            
    /*2*/ <1.29408,3.58366,2.43431>

    /* stem 0.0.5.2*/ 
    /*0*/ <1.42165,3.81339,2.02379>,
    /*1*/ <1.43257,3.81342,2.01964>,<1.41967,3.81084,2.03502>,<1.4127,3.8159,2.01671>,
            
    /*2*/ <1.46799,4.33263,2.14967>

    /* stem 0.0.5.3*/ 
    /*0*/ <1.47043,3.89998,2.1327>,
    /*1*/ <1.465,3.89562,2.1412>,<1.47112,3.91089,2.13163>,<1.47516,3.89342,2.12526>,
            
    /*2*/ <1.89256,3.89935,2.40176>

    /* stem 0.0.5.4*/ 
    /*0*/ <1.52197,4.00974,2.21337>,
    /*1*/ <1.51978,4.01466,2.20461>,<1.53043,4.01222,2.21868>,<1.51571,4.00235,2.21682>,
            
    /*2*/ <1.27908,4.32688,2.45214>

    /* stem 0.0.5.5*/ 
    /*0*/ <1.59575,4.20779,2.29014>,
    /*1*/ <1.60284,4.2036,2.29423>,<1.59129,4.21457,2.29447>,<1.59312,4.2052,2.28171>,
            
    /*2*/ <1.85343,4.48266,2.12541>

    /* stem 0.0.5.6*/ 
    /*0*/ <1.65151,4.34325,2.32209>,
    /*1*/ <1.64372,4.34604,2.32389>,<1.65663,4.34784,2.31715>,<1.65419,4.33585,2.32525>,
            
    /*2*/ <1.78479,4.5205,2.62473>

    /* stem 0.0.5.7*/ 
    /*0*/ <1.68734,4.44358,2.33292>,
    /*1*/ <1.69202,4.44222,2.32665>,<1.69032,4.44704,2.33943>,<1.67968,4.44149,2.33269>,
            
    /*2*/ <1.6056,4.75766,2.20357>

    /* stem 0.0.5.8*/ 
    /*0*/ <1.74231,4.60901,2.32755>,
    /*1*/ <1.74263,4.60936,2.3322>,<1.73984,4.61216,2.32513>,<1.74447,4.60551,2.32531>,
            
    /*2*/ <1.994,4.783,2.29759>

    /* stem 0.0.5.9*/ 
    /*0*/ <1.78692,4.75544,2.2986>,
    /*1*/ <1.78576,4.75537,2.29749>,<1.78831,4.75619,2.29828>,<1.78669,4.75475,2.30004>,
            
    /*2*/ <1.6836,4.98621,2.39278>

    /* stem 0.1*/ 
    /*0*/ <0.02886,4.3222,0.00243>,
    /*1*/ <0.04216,4.32211,-0.07295>,<0.02479,4.39449,-0.0224>,<0.01306,4.36698,0.06246>,
            <0.02317,4.27759,0.06436>,<0.04115,4.24985,-0.01933>,
    /*2*/ <-0.3826,4.27264,-0.1404>,<-0.39831,4.33815,-0.09465>,<-0.40893,4.31325,-0.01785>,
            <-0.39978,4.23235,-0.01613>,<-0.3835,4.20725,-0.09187>,
    /*3*/ <-0.82142,4.23347,-0.15881>,<-0.82913,4.29267,-0.11701>,<-0.83118,4.27101,-0.04745>,
            <-0.82475,4.19842,-0.04626>,<-0.81871,4.17522,-0.11509>,
    /*4*/ <-1.25273,4.16198,-0.14401>,<-1.26075,4.21404,-0.10706>,<-1.25658,4.19561,-0.04556>,
            <-1.24599,4.13215,-0.0445>,<-1.24361,4.11138,-0.10534>,
    /*5*/ <-1.67098,4.04565,-0.10431>,<-1.68087,4.0901,-0.07209>,<-1.67257,4.0751,-0.019>,
            <-1.65754,4.02138,-0.01841>,<-1.65656,4.00317,-0.07114>,
    /*6*/ <-2.09078,3.94743,-0.06371>,<-2.09754,3.98549,-0.03655>,<-2.09097,3.97267,0.00844>,
            <-2.08015,3.92669,0.00909>,<-2.08003,3.91109,-0.03551>,
    /*7*/ <-2.50593,3.83545,0.00576>,<-2.51104,3.8667,0.028>,<-2.5029,3.85685,0.06452>,
            <-2.49277,3.81951,0.06486>,<-2.49464,3.80628,0.02855>,
    /*8*/ <-2.9261,3.76178,0.08353>,<-2.92763,3.78667,0.10048>,<-2.9215,3.77894,0.12896>,
            <-2.91618,3.74927,0.12962>,<-2.91902,3.73867,0.10155>,
    /*9*/ <-3.34856,3.72178,0.17289>,<-3.34798,3.73983,0.18473>,<-3.3435,3.73429,0.20512>,
            <-3.34131,3.71282,0.20588>,<-3.34444,3.70509,0.18596>,
    /*10*/ <-3.77223,3.69895,0.25816>,<-3.77152,3.70988,0.26524>,<-3.76907,3.70652,0.27761>,
            <-3.76826,3.69351,0.27816>,<-3.77021,3.68883,0.26614>,
    /*11*/ <-4.19065,3.72219,0.36968>,<-4.18987,3.72596,0.37201>,<-4.18888,3.72479,0.37624>,
            <-4.18905,3.72031,0.37653>,<-4.19015,3.7187,0.37247>,
    /*12*/ <-4.18972,3.72239,0.37339>

    /* stem 0.1c0*/ 
    /*0*/ <-1.25193,4.16303,-0.08929>,
    /*1*/ <-1.23198,4.16203,-0.14024>,<-1.25159,4.21434,-0.10833>,<-1.27168,4.19574,-0.05011>,
            <-1.26447,4.13194,-0.04604>,<-1.23994,4.11111,-0.10174>,
    /*2*/ <-1.63475,4.10706,-0.2891>,<-1.65176,4.15242,-0.26143>,<-1.66918,4.13629,-0.21094>,
            <-1.66293,4.08097,-0.2074>,<-1.64166,4.0629,-0.25571>,
    /*3*/ <-2.03215,4.03145,-0.44151>,<-2.04858,4.06953,-0.41889>,<-2.06322,4.05591,-0.37609>,
            <-2.05585,4.0094,-0.37226>,<-2.03664,3.99429,-0.41269>,
    /*4*/ <-2.45064,3.96328,-0.54925>,<-2.46121,3.99494,-0.52968>,<-2.46945,3.98437,-0.49338>,
            <-2.46397,3.94618,-0.49051>,<-2.45234,3.93314,-0.52504>,
    /*5*/ <-2.86861,3.91045,-0.65081>,<-2.87582,3.93526,-0.63529>,<-2.88216,3.92703,-0.60699>,
            <-2.87886,3.89713,-0.60502>,<-2.87048,3.88688,-0.6321>,
    /*6*/ <-3.29668,3.84449,-0.70067>,<-3.30096,3.86236,-0.68934>,<-3.30287,3.8568,-0.66856>,
            <-3.29975,3.83548,-0.66705>,<-3.29593,3.82787,-0.68689>,
    /*7*/ <-3.72853,3.80083,-0.71712>,<-3.73003,3.81177,-0.71015>,<-3.73039,3.80849,-0.69753>,
            <-3.72911,3.79553,-0.69669>,<-3.72796,3.7908,-0.7088>,
    /*8*/ <-4.15576,3.76582,-0.7705>,<-4.15641,3.76958,-0.76811>,<-4.15692,3.76842,-0.7638>,
            <-4.15659,3.76394,-0.76351>,<-4.15587,3.76233,-0.76765>,
    /*9*/ <-4.15631,3.76601,-0.76672>

    /* stem 0.1c0c0*/ 
    /*0*/ <-3.29924,3.8454,-0.6825>,
    /*1*/ <-3.28433,3.84452,-0.69321>,<-3.29496,3.86249,-0.6877>,<-3.3115,3.85684,-0.67501>,
            <-3.31109,3.83538,-0.67267>,<-3.2943,3.82776,-0.68392>,
    /*2*/ <-3.54321,3.80205,-1.03758>,<-3.54963,3.81291,-1.03425>,<-3.55962,3.80949,-1.02658>,
            <-3.55937,3.79652,-1.02517>,<-3.54923,3.79192,-1.03196>,
    /*3*/ <-3.81733,3.80223,-1.37328>,<-3.81926,3.80599,-1.37176>,<-3.82267,3.80481,-1.36907>,
            <-3.82284,3.80032,-1.36893>,<-3.81954,3.79872,-1.37153>,
    /*4*/ <-3.82033,3.80241,-1.37091>

    /* stem 0.1c0c0.0*/ 
    /*0*/ <-3.42201,3.82462,-0.85169>,
    /*1*/ <-3.43405,3.82533,-0.84304>,<-3.41839,3.81185,-0.85834>,<-3.4136,3.83667,-0.8537>,
            
    /*2*/ <-3.5019,3.85704,-0.94264>,<-3.4878,3.84491,-0.9564>,<-3.48349,3.86725,-0.95223>,
            
    /*3*/ <-3.55185,3.92411,-1.03636>,<-3.54004,3.91426,-1.05002>,<-3.53329,3.93155,-1.04116>,
            
    /*4*/ <-3.59768,4.00394,-1.11998>,<-3.58795,3.99619,-1.13298>,<-3.58111,4.00994,-1.12361>,
            
    /*5*/ <-3.64874,4.095,-1.18573>,<-3.64155,4.09005,-1.19845>,<-3.63477,4.10047,-1.18931>,
            
    /*6*/ <-3.6964,4.20089,-1.22872>,<-3.6914,4.19857,-1.24033>,<-3.68463,4.20517,-1.23162>,
            
    /*7*/ <-3.73057,4.31397,-1.27015>,<-3.72649,4.31195,-1.27936>,<-3.72075,4.31636,-1.27205>,
            
    /*8*/ <-3.77544,4.42616,-1.29701>,<-3.77276,4.42559,-1.30421>,<-3.76835,4.42868,-1.29869>,
            
    /*9*/ <-3.83441,4.5342,-1.31134>,<-3.83293,4.53441,-1.31626>,<-3.82999,4.5365,-1.31261>,
            
    /*10*/ <-3.87104,4.64878,-1.34654>,<-3.87007,4.6484,-1.34889>,<-3.86861,4.64943,-1.34705>,
            
    /*11*/ <-3.88088,4.76924,-1.37775>

    /* stem 0.1c0c0.0.0*/ 
    /*0*/ <-3.45887,3.84158,-0.90439>,
    /*1*/ <-3.4557,3.83743,-0.90795>,<-3.46039,3.84724,-0.90675>,<-3.46052,3.84007,-0.89848>,
            
    /*2*/ <-3.87622,3.66206,-1.06666>

    /* stem 0.1c0c0.0.1*/ 
    /*0*/ <-3.51172,3.88367,-0.98796>,
    /*1*/ <-3.51067,3.88872,-0.98487>,<-3.51725,3.88248,-0.98997>,<-3.50723,3.87982,-0.98904>,
            
    /*2*/ <-3.41731,4.1022,-1.37725>

    /* stem 0.1c0c0.0.2*/ 
    /*0*/ <-3.61462,4.04809,-1.1575>,
    /*1*/ <-3.61871,4.04495,-1.1586>,<-3.6128,4.05141,-1.16116>,<-3.61235,4.04789,-1.15275>,
            
    /*2*/ <-3.86225,4.32596,-1.02791>

    /* stem 0.1c0c0.0.3*/ 
    /*0*/ <-3.6542,4.12226,-1.20196>,
    /*1*/ <-3.64977,4.12355,-1.20386>,<-3.65696,4.12565,-1.19956>,<-3.65586,4.11758,-1.20246>,
            
    /*2*/ <-3.81839,4.21504,-1.52164>

    /* stem 0.1c0c0.0.4*/ 
    /*0*/ <-3.70344,4.24202,-1.24805>,
    /*1*/ <-3.70593,4.2426,-1.24424>,<-3.70503,4.24351,-1.25208>,<-3.69936,4.23994,-1.24782>,
            
    /*2*/ <-3.55426,4.54103,-1.19644>

    /* stem 0.1c0c0.0.5*/ 
    /*0*/ <-3.75653,4.38867,-1.29113>,
    /*1*/ <-3.75706,4.38754,-1.29505>,<-3.75469,4.39223,-1.29025>,<-3.75785,4.38623,-1.2881>,
            
    /*2*/ <-4.02185,4.52688,-1.29496>

    /* stem 0.1c0c0.0.6*/ 
    /*0*/ <-3.85461,4.60239,-1.33357>,
    /*1*/ <-3.85316,4.60324,-1.33233>,<-3.85651,4.60325,-1.33371>,<-3.85416,4.60067,-1.33468>,
            
    /*2*/ <-3.77868,4.74059,-1.51645>

    /* stem 0.1c0c0.0.7*/ 
    /*0*/ <-3.87448,4.69902,-1.3601>,
    /*1*/ <-3.87534,4.69893,-1.36012>,<-3.87407,4.69944,-1.36073>,<-3.87403,4.69868,-1.35944>,
            
    /*2*/ <-3.89603,4.88416,-1.24936>

    /* stem 0.1c0.0*/ 
    /*0*/ <-1.42527,4.13916,-0.15671>,
    /*1*/ <-1.43992,4.15287,-0.12389>,<-1.4341,4.10357,-0.16833>,<-1.40178,4.16105,-0.17791>,
            
    /*2*/ <-1.59711,4.22386,-0.22822>,<-1.59187,4.17948,-0.26822>,<-1.56278,4.23121,-0.27685>,
            
    /*3*/ <-1.7178,4.348,-0.32857>,<-1.72014,4.31403,-0.36958>,<-1.68243,4.35168,-0.36829>,
            
    /*4*/ <-1.82059,4.49043,-0.42709>,<-1.82428,4.46295,-0.46459>,<-1.788,4.49197,-0.46042>,
            
    /*5*/ <-1.90695,4.64227,-0.52932>,<-1.91028,4.61934,-0.5619>,<-1.87754,4.64162,-0.55639>,
            
    /*6*/ <-1.96606,4.80773,-0.62891>,<-1.96941,4.79026,-0.65708>,<-1.94036,4.80491,-0.64992>,
            
    /*7*/ <-2.01893,4.97729,-0.72357>,<-2.02185,4.96409,-0.74653>,<-1.99831,4.97491,-0.74028>,
            
    /*8*/ <-2.05308,5.15577,-0.81037>,<-2.05552,5.14701,-0.82818>,<-2.03739,5.15324,-0.8225>,
            
    /*9*/ <-2.08939,5.34157,-0.8759>,<-2.09131,5.33706,-0.88829>,<-2.07914,5.34082,-0.88438>,
            
    /*10*/ <-2.082,5.53382,-0.93739>,<-2.08298,5.53195,-0.94371>,<-2.07679,5.53248,-0.94131>,
            
    /*11*/ <-2.07735,5.72286,-1.00763>

    /* stem 0.1c0.0.0*/ 
    /*0*/ <-1.55038,4.19622,-0.2364>,
    /*1*/ <-1.5507,4.18286,-0.24546>,<-1.55099,4.21075,-0.24342>,<-1.54944,4.19505,-0.22033>,
            
    /*2*/ <-2.31706,4.18497,-0.19254>

    /* stem 0.1c0.0.1*/ 
    /*0*/ <-1.66202,4.29185,-0.31988>,
    /*1*/ <-1.65227,4.30342,-0.31718>,<-1.67718,4.29435,-0.31954>,<-1.65661,4.27779,-0.32291>,
            
    /*2*/ <-1.6517,4.44887,-1.02969>

    /* stem 0.1c0.0.2*/ 
    /*0*/ <-1.74411,4.38946,-0.3896>,
    /*1*/ <-1.75664,4.3839,-0.38429>,<-1.74309,4.39299,-0.40383>,<-1.73261,4.39148,-0.38067>,
            
    /*2*/ <-1.9673,5.02881,-0.24674>

    /* stem 0.1c0.0.3*/ 
    /*0*/ <-1.86076,4.56885,-0.50689>,
    /*1*/ <-1.85215,4.5671,-0.51724>,<-1.8623,4.58115,-0.50136>,<-1.86783,4.55831,-0.50208>,
            
    /*2*/ <-2.3275,4.69456,-0.91632>

    /* stem 0.1c0.0.4*/ 
    /*0*/ <-1.91587,4.68303,-0.57725>,
    /*1*/ <-1.91672,4.68923,-0.56597>,<-1.92556,4.68372,-0.58574>,<-1.90534,4.67613,-0.58005>,
            
    /*2*/ <-1.66465,5.16687,-0.82437>

    /* stem 0.1c0.0.5*/ 
    /*0*/ <-1.94143,4.75356,-0.61795>,
    /*1*/ <-1.94845,4.7466,-0.6256>,<-1.93505,4.76331,-0.62246>,<-1.94079,4.75076,-0.60578>,
            
    /*2*/ <-2.39451,5.09756,-0.5152>

    /* stem 0.1c0.0.6*/ 
    /*0*/ <-1.99456,4.91402,-0.70574>,
    /*1*/ <-1.98369,4.91798,-0.7048>,<-2.00352,4.92125,-0.70426>,<-1.99646,4.90283,-0.70818>,
            
    /*2*/ <-1.99025,5.02652,-1.22606>

    /* stem 0.1c0.0.7*/ 
    /*0*/ <-2.02623,5.03877,-0.76776>,
    /*1*/ <-2.03581,5.03931,-0.76251>,<-2.02588,5.03998,-0.77862>,<-2.01702,5.03702,-0.76215>,
            
    /*2*/ <-1.96741,5.53004,-0.71101>

    /* stem 0.1c0.0.8*/ 
    /*0*/ <-2.06445,5.23015,-0.84636>,
    /*1*/ <-2.06087,5.22789,-0.85534>,<-2.0625,5.23901,-0.84232>,<-2.06999,5.22356,-0.84142>,
            
    /*2*/ <-2.43338,5.39792,-1.03598>

    /* stem 0.1c0.0.9*/ 
    /*0*/ <-2.08256,5.46959,-0.92184>,
    /*1*/ <-2.08095,5.47094,-0.91718>,<-2.08609,5.4724,-0.92423>,<-2.08064,5.46544,-0.9241>,
            
    /*2*/ <-1.80372,5.68519,-1.08082>

    /* stem 0.1c0.0.10*/ 
    /*0*/ <-2.07845,5.65859,-0.98504>,
    /*1*/ <-2.07955,5.65838,-0.98569>,<-2.07749,5.65928,-0.98559>,<-2.07829,5.65811,-0.98384>,
            
    /*2*/ <-2.20828,5.94311,-0.8547>

    /* stem 0.1c0.1*/ 
    /*0*/ <-1.85173,4.06963,-0.32543>,
    /*1*/ <-1.84019,4.03894,-0.33944>,<-1.86693,4.09418,-0.34635>,<-1.84807,4.07577,-0.2905>,
            
    /*2*/ <-2.00722,3.96559,-0.3072>,<-2.03128,4.0153,-0.31343>,<-2.01431,3.99874,-0.26316>,
            
    /*3*/ <-2.19801,3.98534,-0.24451>,<-2.19676,4.03316,-0.25686>,<-2.18352,4.01904,-0.2114>,
            
    /*4*/ <-2.37335,4.0446,-0.20169>,<-2.36358,4.08473,-0.21445>,<-2.35747,4.07305,-0.17328>,
            
    /*5*/ <-2.51881,4.16177,-0.15012>,<-2.50074,4.1909,-0.16417>,<-2.49586,4.18143,-0.12869>,
            
    /*6*/ <-2.6367,4.30376,-0.10886>,<-2.61751,4.3241,-0.12196>,<-2.61489,4.31756,-0.0919>,
            
    /*7*/ <-2.73358,4.46049,-0.07349>,<-2.71629,4.47415,-0.08464>,<-2.71474,4.46965,-0.06041>,
            
    /*8*/ <-2.82168,4.622,-0.04632>,<-2.80808,4.63121,-0.05488>,<-2.80735,4.62853,-0.03656>,
            
    /*9*/ <-2.86977,4.8031,-0.0342>,<-2.8595,4.80641,-0.0402>,<-2.85946,4.80561,-0.02788>,
            
    /*10*/ <-2.90903,4.98088,-0.06974>,<-2.90363,4.98159,-0.07266>,<-2.90403,4.98271,-0.0666>,
            
    /*11*/ <-2.92363,5.16104,-0.11241>

    /* stem 0.1c0.1.0*/ 
    /*0*/ <-1.92839,4.03431,-0.31118>,
    /*1*/ <-1.93516,4.04728,-0.31545>,<-1.93369,4.02654,-0.29919>,<-1.91632,4.02911,-0.3189>,
            
    /*2*/ <-2.36655,3.66251,-0.7455>

    /* stem 0.1c0.1.1*/ 
    /*0*/ <-2.13707,4.00638,-0.25571>,
    /*1*/ <-2.13378,4.00003,-0.24344>,<-2.14875,4.00249,-0.26281>,<-2.12869,4.01661,-0.26089>,
            
    /*2*/ <-2.49053,4.46347,0.07566>

    /* stem 0.1c0.1.2*/ 
    /*0*/ <-2.24461,4.02907,-0.2252>,
    /*1*/ <-2.24862,4.02601,-0.23791>,<-2.24833,4.04094,-0.21953>,<-2.23686,4.02026,-0.21817>,
            
    /*2*/ <-2.77089,3.75246,0.00776>

    /* stem 0.1c0.1.3*/ 
    /*0*/ <-2.4361,4.12364,-0.17167>,
    /*1*/ <-2.42795,4.13157,-0.16617>,<-2.44723,4.12123,-0.1662>,<-2.43313,4.11814,-0.18265>,
            
    /*2*/ <-2.67582,4.57169,-0.46135>

    /* stem 0.1c0.1.4*/ 
    /*0*/ <-2.58884,4.27538,-0.1192>,
    /*1*/ <-2.59686,4.26759,-0.11612>,<-2.59204,4.28523,-0.1244>,<-2.57764,4.27332,-0.11707>,
            
    /*2*/ <-2.63564,4.51074,0.35503>

    /* stem 0.1c0.1.5*/ 
    /*0*/ <-2.69082,4.4204,-0.08368>,
    /*1*/ <-2.68687,4.42496,-0.09256>,<-2.6927,4.42638,-0.07496>,<-2.69289,4.40987,-0.08352>,
            
    /*2*/ <-3.14457,4.50724,-0.24092>

    /* stem 0.1c0.1.6*/ 
    /*0*/ <-2.77966,4.56993,-0.05562>,
    /*1*/ <-2.77778,4.56936,-0.04592>,<-2.78845,4.5732,-0.05877>,<-2.77275,4.56723,-0.06216>,
            
    /*2*/ <-2.62245,4.98695,-0.06153>

    /* stem 0.1c0.1.7*/ 
    /*0*/ <-2.83774,4.7165,-0.03998>,
    /*1*/ <-2.84432,4.71502,-0.0458>,<-2.83284,4.72392,-0.0406>,<-2.83606,4.71057,-0.03355>,
            
    /*2*/ <-3.09873,4.90931,0.20633>

    /* stem 0.1c0.1.8*/ 
    /*0*/ <-2.88549,4.89857,-0.05292>,
    /*1*/ <-2.8804,4.89982,-0.05282>,<-2.88889,4.9012,-0.04992>,<-2.88718,4.8947,-0.05603>,
            
    /*2*/ <-2.93845,5.13622,-0.32043>

    /* stem 0.1c0.1.9*/ 
    /*0*/ <-2.91741,5.09936,-0.0977>,
    /*1*/ <-2.9184,5.09943,-0.09698>,<-2.91742,5.0999,-0.09881>,<-2.91642,5.09874,-0.09732>,
            
    /*2*/ <-2.80548,5.36049,0.03035>

    /* stem 0.1c0.2*/ 
    /*0*/ <-2.24352,3.99988,-0.45821>,
    /*1*/ <-2.24659,4.03184,-0.46616>,<-2.2617,3.9871,-0.43371>,<-2.22226,3.98068,-0.47478>,
            
    /*2*/ <-2.36889,3.98914,-0.57695>,<-2.3825,3.94888,-0.54775>,<-2.347,3.9431,-0.58471>,
            
    /*3*/ <-2.48835,4.00793,-0.68181>,<-2.50999,3.97152,-0.66427>,<-2.4804,3.96612,-0.69886>,
            
    /*4*/ <-2.6008,4.08488,-0.76727>,<-2.62768,4.05657,-0.75806>,<-2.60511,4.05283,-0.791>,
            
    /*5*/ <-2.68053,4.20763,-0.83708>,<-2.71011,4.19029,-0.83455>,<-2.69059,4.18698,-0.86266>,
            
    /*6*/ <-2.7232,4.35383,-0.90146>,<-2.75067,4.34576,-0.90256>,<-2.73343,4.34097,-0.92493>,
            
    /*7*/ <-2.75929,4.50861,-0.95967>,<-2.78156,4.50334,-0.96101>,<-2.76783,4.49977,-0.97901>,
            
    /*8*/ <-2.79664,4.6634,-1.0211>,<-2.81331,4.65931,-1.02206>,<-2.80298,4.65647,-1.0355>,
            
    /*9*/ <-2.8137,4.8266,-1.06021>,<-2.82504,4.82535,-1.06129>,<-2.81822,4.82388,-1.07039>,
            
    /*10*/ <-2.81998,4.9909,-1.10429>,<-2.82567,4.99061,-1.10491>,<-2.82224,4.98954,-1.10938>,
            
    /*11*/ <-2.84503,5.15791,-1.12781>

    /* stem 0.1c0.2.0*/ 
    /*0*/ <-2.33303,3.97104,-0.53968>,
    /*1*/ <-2.3382,3.96173,-0.5307>,<-2.33341,3.96847,-0.55336>,<-2.32747,3.98291,-0.53497>,
            
    /*2*/ <-2.91659,4.25906,-0.5773>

    /* stem 0.1c0.2.1*/ 
    /*0*/ <-2.40789,3.96745,-0.60664>,
    /*1*/ <-2.39893,3.96819,-0.61666>,<-2.41683,3.97735,-0.60486>,<-2.40792,3.9568,-0.59841>,
            
    /*2*/ <-2.80992,3.67347,-0.9881>

    /* stem 0.1c0.2.2*/ 
    /*0*/ <-2.5277,4.00624,-0.70825>,
    /*1*/ <-2.53104,4.01277,-0.6979>,<-2.53657,4.00246,-0.71651>,<-2.51549,4.00347,-0.71035>,
            
    /*2*/ <-2.46497,4.50943,-1.00569>

    /* stem 0.1c0.2.3*/ 
    /*0*/ <-2.65348,4.13146,-0.80933>,
    /*1*/ <-2.65854,4.12405,-0.81687>,<-2.65005,4.14207,-0.81295>,<-2.65186,4.12827,-0.79817>,
            
    /*2*/ <-3.13655,4.33118,-0.68181>

    /* stem 0.1c0.2.4*/ 
    /*0*/ <-2.72326,4.30165,-0.89034>,
    /*1*/ <-2.71336,4.3053,-0.88821>,<-2.73173,4.30821,-0.88939>,<-2.72468,4.29144,-0.89342>,
            
    /*2*/ <-2.67195,4.43576,-1.35818>

    /* stem 0.1c0.2.5*/ 
    /*0*/ <-2.75213,4.42292,-0.93721>,
    /*1*/ <-2.76131,4.42248,-0.93296>,<-2.75115,4.42587,-0.94685>,<-2.74393,4.4204,-0.93183>,
            
    /*2*/ <-2.70914,4.85709,-0.79991>

    /* stem 0.1c0.2.6*/ 
    /*0*/ <-2.783,4.56417,-0.98963>,
    /*1*/ <-2.7787,4.56204,-0.9977>,<-2.78235,4.57285,-0.98612>,<-2.78795,4.55762,-0.98508>,
            
    /*2*/ <-3.12758,4.67634,-1.20292>

    /* stem 0.1c0.2.7*/ 
    /*0*/ <-2.81335,4.76167,-1.04946>,
    /*1*/ <-2.81153,4.76353,-1.04202>,<-2.81965,4.76493,-1.05292>,<-2.80886,4.75656,-1.05346>,
            
    /*2*/ <-2.60265,5.04099,-1.17048>

    /* stem 0.1c0.2.8*/ 
    /*0*/ <-2.82051,4.89462,-1.0817>,
    /*1*/ <-2.8247,4.89375,-1.08471>,<-2.81631,4.89699,-1.0837>,<-2.82053,4.8931,-1.0767>,
            
    /*2*/ <-2.94701,5.19399,-0.99139>

    /* stem 0.1c0.2.9*/ 
    /*0*/ <-2.83575,5.0885,-1.11886>,
    /*1*/ <-2.8344,5.08866,-1.11897>,<-2.83645,5.08921,-1.11792>,<-2.8364,5.08761,-1.11967>,
            
    /*2*/ <-2.87788,5.29904,-1.31324>

    /* stem 0.1c0.3*/ 
    /*0*/ <-3.1797,3.86399,-0.66659>,
    /*1*/ <-3.17999,3.85181,-0.6502>,<-3.18225,3.85607,-0.68523>,<-3.17685,3.88408,-0.66432>,
            
    /*2*/ <-3.31463,3.87087,-0.64095>,<-3.31667,3.8747,-0.67248>,<-3.31181,3.89991,-0.65366>,
            
    /*3*/ <-3.44265,3.91551,-0.62034>,<-3.44631,3.91891,-0.64819>,<-3.43638,3.94028,-0.63251>,
            
    /*4*/ <-3.56662,3.97467,-0.60692>,<-3.5684,3.97724,-0.63148>,<-3.55829,3.99527,-0.61785>,
            
    /*5*/ <-3.6781,4.05856,-0.61774>,<-3.67597,4.05907,-0.63885>,<-3.66616,4.07356,-0.62684>,
            
    /*6*/ <-3.76132,4.16734,-0.64247>,<-3.75784,4.16633,-0.65978>,<-3.74774,4.17638,-0.6493>,
            
    /*7*/ <-3.82814,4.27687,-0.69485>,<-3.82347,4.27371,-0.70783>,<-3.81593,4.2823,-0.69949>,
            
    /*8*/ <-3.88467,4.39064,-0.74516>,<-3.88114,4.38827,-0.75488>,<-3.87516,4.39412,-0.74835>,
            
    /*9*/ <-3.91773,4.50438,-0.81532>,<-3.91484,4.5017,-0.8212>,<-3.91091,4.50557,-0.81677>,
            
    /*10*/ <-3.93405,4.62205,-0.88281>,<-3.93258,4.62065,-0.8857>,<-3.93056,4.6223,-0.88331>,
            
    /*11*/ <-3.93565,4.7444,-0.94309>

    /* stem 0.1c0.3.0*/ 
    /*0*/ <-3.25401,3.87383,-0.66058>,
    /*1*/ <-3.25477,3.87338,-0.66922>,<-3.2586,3.8797,-0.65612>,<-3.24866,3.86842,-0.6564>,
            
    /*2*/ <-3.64689,3.52643,-0.60786>

    /* stem 0.1c0.3.1*/ 
    /*0*/ <-3.36414,3.89865,-0.64709>,
    /*1*/ <-3.36136,3.90398,-0.64141>,<-3.37011,3.89326,-0.64514>,<-3.36096,3.89872,-0.65474>,
            
    /*2*/ <-3.71019,4.23027,-0.78828>

    /* stem 0.1c0.3.2*/ 
    /*0*/ <-3.64427,4.04198,-0.62539>,
    /*1*/ <-3.64849,4.03627,-0.62595>,<-3.64575,4.04788,-0.62911>,<-3.63858,4.0418,-0.62111>,
            
    /*2*/ <-3.8807,4.1849,-0.305>

    /* stem 0.1c0.3.3*/ 
    /*0*/ <-3.71702,4.1201,-0.63985>,
    /*1*/ <-3.71218,4.12307,-0.64347>,<-3.72066,4.12371,-0.6355>,<-3.71821,4.11352,-0.64059>,
            
    /*2*/ <-3.98016,4.19982,-0.92616>

    /* stem 0.1c0.3.4*/ 
    /*0*/ <-3.79879,4.23945,-0.68292>,
    /*1*/ <-3.80166,4.2402,-0.6775>,<-3.80199,4.23979,-0.68818>,<-3.79272,4.23838,-0.68307>,
            
    /*2*/ <-3.73636,4.59416,-0.69845>

    /* stem 0.1c0.3.5*/ 
    /*0*/ <-3.85722,4.3457,-0.72999>,
    /*1*/ <-3.85798,4.34315,-0.73501>,<-3.85543,4.35109,-0.72977>,<-3.85826,4.34285,-0.72517>,
            
    /*2*/ <-4.16953,4.44978,-0.73571>

    /* stem 0.1c0.3.6*/ 
    /*0*/ <-3.91916,4.53456,-0.835>,
    /*1*/ <-3.91666,4.53608,-0.83298>,<-3.92211,4.53636,-0.83582>,<-3.9187,4.53125,-0.8362>,
            
    /*2*/ <-3.79644,4.63304,-1.06047>

    /* stem 0.1c0.3.7*/ 
    /*0*/ <-3.9334,4.65942,-0.90213>,
    /*1*/ <-3.93481,4.65934,-0.90223>,<-3.93265,4.65987,-0.90324>,<-3.93275,4.65905,-0.90094>,
            
    /*2*/ <-3.95154,4.88568,-0.82205>

    /* stem 0.1c0.4*/ 
    /*0*/ <-3.84162,3.79215,-0.72202>,
    /*1*/ <-3.84029,3.79167,-0.7311>,<-3.84759,3.79821,-0.71857>,<-3.83697,3.78656,-0.7164>,
            
    /*2*/ <-3.9228,3.71515,-0.73821>,<-3.92937,3.72104,-0.72693>,<-3.91981,3.71055,-0.72498>,
            
    /*3*/ <-4.02058,3.67173,-0.76897>,<-4.02618,3.67682,-0.75873>,<-4.02114,3.66515,-0.75809>,
            
    /*4*/ <-4.11921,3.6619,-0.81972>,<-4.12434,3.66601,-0.81073>,<-4.12272,3.65503,-0.81168>,
            
    /*5*/ <-4.21414,3.6909,-0.87215>,<-4.2177,3.6943,-0.86397>,<-4.21914,3.68518,-0.86638>,
            
    /*6*/ <-4.28865,3.74597,-0.93444>,<-4.2921,3.74885,-0.92787>,<-4.29458,3.74195,-0.93097>,
            
    /*7*/ <-4.35879,3.82754,-0.97008>,<-4.36039,3.82885,-0.96406>,<-4.36372,3.82455,-0.96737>,
            
    /*8*/ <-4.4236,3.91535,-0.99859>,<-4.42463,3.91613,-0.99399>,<-4.4274,3.91324,-0.9966>,
            
    /*9*/ <-4.47383,4.01567,-1.01054>,<-4.47429,4.01584,-1.0074>,<-4.4765,4.01451,-1.00926>,
            
    /*10*/ <-4.53406,4.11108,-1.01575>,<-4.53424,4.11107,-1.01417>,<-4.53531,4.11034,-1.01509>,
            
    /*11*/ <-4.57794,4.21368,-0.99916>

    /* stem 0.1c0.4.0*/ 
    /*0*/ <-3.86936,3.76636,-0.72472>,
    /*1*/ <-3.87149,3.76838,-0.72208>,<-3.86947,3.76241,-0.72475>,<-3.86711,3.76829,-0.72734>,
            
    /*2*/ <-4.20868,3.7784,-1.00754>

    /* stem 0.1c0.4.1*/ 
    /*0*/ <-4.05699,3.66769,-0.77993>,
    /*1*/ <-4.05621,3.66437,-0.78076>,<-4.05833,3.66984,-0.78236>,<-4.05643,3.66886,-0.77667>,
            
    /*2*/ <-4.41505,3.55858,-0.67955>

    /* stem 0.1c0.4.2*/ 
    /*0*/ <-4.15317,3.67053,-0.83155>,
    /*1*/ <-4.15189,3.67348,-0.83222>,<-4.15627,3.67029,-0.83045>,<-4.15136,3.66781,-0.83199>,
            
    /*2*/ <-4.27251,3.64543,-1.17129>

    /* stem 0.1c0.4.3*/ 
    /*0*/ <-4.26362,3.72471,-0.90715>,
    /*1*/ <-4.26587,3.72359,-0.90549>,<-4.26373,3.72452,-0.91015>,<-4.26128,3.72602,-0.90581>,
            
    /*2*/ <-4.41696,4.01199,-0.91989>

    /* stem 0.1c0.4.4*/ 
    /*0*/ <-4.40573,3.88825,-0.98753>,
    /*1*/ <-4.40485,3.88811,-0.9899>,<-4.40585,3.89049,-0.98636>,<-4.4065,3.88615,-0.98634>,
            
    /*2*/ <-4.65544,3.92474,-1.08292>

    /* stem 0.1c0.4.5*/ 
    /*0*/ <-4.45137,3.9678,-1.00307>,
    /*1*/ <-4.45065,3.96842,-1.001>,<-4.45357,3.96796,-1.0036>,<-4.44988,3.96702,-1.0046>,
            
    /*2*/ <-4.41449,4.19829,-1.08485>

    /* stem 0.1c0.4.6*/ 
    /*0*/ <-4.56542,4.18402,-1.00373>,
    /*1*/ <-4.56565,4.18394,-1.00384>,<-4.5653,4.18423,-1.00382>,<-4.56532,4.18388,-1.00353>,
            
    /*2*/ <-4.66169,4.28903,-0.88074>

    /* stem 0.1c1*/ 
    /*0*/ <-2.50146,3.83695,0.03834>,
    /*1*/ <-2.49173,3.83517,0.00694>,<-2.50187,3.86739,0.02582>,<-2.51144,3.85755,0.06199>,
            <-2.50721,3.81925,0.06548>,<-2.49503,3.80542,0.03145>,
    /*2*/ <-2.9047,3.77893,-0.11013>,<-2.9126,3.80403,-0.09543>,<-2.92005,3.79636,-0.06724>,
            <-2.91675,3.76652,-0.06453>,<-2.90727,3.75575,-0.09103>,
    /*3*/ <-3.31417,3.73877,-0.24201>,<-3.31958,3.75679,-0.23141>,<-3.32581,3.7512,-0.2115>,
            <-3.32425,3.72973,-0.2098>,<-3.31706,3.72204,-0.22866>,
    /*4*/ <-3.72651,3.75384,-0.37356>,<-3.72844,3.76477,-0.3667>,<-3.73258,3.76138,-0.3548>,
            <-3.73321,3.74836,-0.35431>,<-3.72946,3.7437,-0.3659>,
    /*5*/ <-4.14651,3.76125,-0.48086>,<-4.1471,3.76501,-0.47847>,<-4.14826,3.76383,-0.47428>,
            <-4.14839,3.75934,-0.47409>,<-4.14731,3.75774,-0.47816>,
    /*6*/ <-4.14751,3.76144,-0.47717>

    /* stem 0.1c1.0*/ 
    /*0*/ <-3.14997,3.75665,-0.16667>,
    /*1*/ <-3.15028,3.77742,-0.17184>,<-3.16507,3.7486,-0.15382>,<-3.13456,3.74394,-0.17436>,
            
    /*2*/ <-3.22879,3.74676,-0.28157>,<-3.2421,3.72081,-0.26535>,<-3.21464,3.71662,-0.28383>,
            
    /*3*/ <-3.30669,3.76444,-0.38644>,<-3.32322,3.74117,-0.37836>,<-3.29991,3.7373,-0.39629>,
            
    /*4*/ <-3.39086,3.81448,-0.4784>,<-3.40773,3.7953,-0.4738>,<-3.3895,3.79244,-0.49204>,
            
    /*5*/ <-3.47254,3.87415,-0.5712>,<-3.48787,3.85829,-0.56834>,<-3.47208,3.85584,-0.58381>,
            
    /*6*/ <-3.54454,3.96209,-0.64439>,<-3.55921,3.95077,-0.64396>,<-3.54686,3.94942,-0.65772>,
            
    /*7*/ <-3.60245,4.06253,-0.71742>,<-3.61513,4.05489,-0.71824>,<-3.60478,4.05322,-0.72873>,
            
    /*8*/ <-3.65261,4.15801,-0.80462>,<-3.66219,4.15242,-0.80548>,<-3.65387,4.15031,-0.81255>,
            
    /*9*/ <-3.70858,4.26503,-0.87075>,<-3.71503,4.26142,-0.87134>,<-3.70992,4.26079,-0.87668>,
            
    /*10*/ <-3.75836,4.37524,-0.93763>,<-3.76165,4.37358,-0.93803>,<-3.75905,4.37318,-0.94063>,
            
    /*11*/ <-3.80858,4.47899,-1.01442>

    /* stem 0.1c1.0.0*/ 
    /*0*/ <-3.20408,3.73696,-0.24262>,
    /*1*/ <-3.20876,3.73097,-0.23774>,<-3.20106,3.73471,-0.25083>,<-3.20242,3.74519,-0.2393>,
            
    /*2*/ <-3.65547,3.91451,-0.45747>

    /* stem 0.1c1.0.1*/ 
    /*0*/ <-3.26994,3.73802,-0.33294>,
    /*1*/ <-3.26299,3.73838,-0.33802>,<-3.27596,3.74416,-0.33344>,<-3.27087,3.73152,-0.32736>,
            
    /*2*/ <-3.51257,3.47132,-0.68407>

    /* stem 0.1c1.0.2*/ 
    /*0*/ <-3.4481,3.84038,-0.54088>,
    /*1*/ <-3.45128,3.84443,-0.5354>,<-3.4524,3.83629,-0.5455>,<-3.44063,3.84042,-0.54174>,
            
    /*2*/ <-3.48106,4.17782,-0.80949>

    /* stem 0.1c1.0.3*/ 
    /*0*/ <-3.52221,3.91893,-0.62011>,
    /*1*/ <-3.5241,3.91383,-0.62453>,<-3.51933,3.92482,-0.62258>,<-3.52321,3.91814,-0.61322>,
            
    /*2*/ <-3.88575,4.08273,-0.65374>

    /* stem 0.1c1.0.4*/ 
    /*0*/ <-3.56801,3.98606,-0.67132>,
    /*1*/ <-3.56277,3.98993,-0.66998>,<-3.57417,3.9884,-0.67047>,<-3.56708,3.97986,-0.67351>,
            
    /*2*/ <-3.56948,4.11139,-1.02692>

    /* stem 0.1c1.0.5*/ 
    /*0*/ <-3.63901,4.11945,-0.77717>,
    /*1*/ <-3.64453,4.11838,-0.77525>,<-3.63804,4.12065,-0.7829>,<-3.63447,4.11933,-0.77336>,
            
    /*2*/ <-3.68105,4.44382,-0.71642>

    /* stem 0.1c1.0.6*/ 
    /*0*/ <-3.73267,4.31186,-0.9021>,
    /*1*/ <-3.73072,4.31116,-0.90471>,<-3.73292,4.31499,-0.90099>,<-3.73437,4.30942,-0.90059>,
            
    /*2*/ <-3.94333,4.35469,-1.07044>

    /* stem 0.1c1.0.7*/ 
    /*0*/ <-3.79098,4.4412,-0.98719>,
    /*1*/ <-3.79099,4.44165,-0.98656>,<-3.79161,4.44113,-0.98762>,<-3.79034,4.44082,-0.98738>,
            
    /*2*/ <-3.72061,4.62264,-1.11586>

    /* stem 0.1c2*/ 
    /*0*/ <-3.34516,3.72276,0.19092>,
    /*1*/ <-3.33921,3.72178,0.17356>,<-3.34221,3.73988,0.18495>,<-3.34929,3.73433,0.20458>,
            <-3.35066,3.71279,0.20533>,<-3.34443,3.70503,0.18616>,
    /*2*/ <-3.75014,3.74329,0.0391>,<-3.75195,3.75423,0.04598>,<-3.75623,3.75087,0.05784>,
            <-3.75706,3.73786,0.05829>,<-3.7533,3.73317,0.04671>,
    /*3*/ <-4.14195,3.83476,-0.11895>,<-4.14215,3.83848,-0.11642>,<-4.14406,3.83739,-0.1125>,
            <-4.14505,3.833,-0.11261>,<-4.14374,3.83138,-0.11659>,
    /*4*/ <-4.14339,3.835,-0.11542>

    /* stem 0.1c2.0*/ 
    /*0*/ <-3.89537,3.77701,-0.01039>,
    /*1*/ <-3.899,3.7721,-0.00453>,<-3.89566,3.77477,-0.01854>,<-3.89146,3.78414,-0.0081>,
            
    /*2*/ <-3.99392,3.8287,-0.01716>,<-3.99091,3.8311,-0.02977>,<-3.98713,3.83953,-0.02037>,
            
    /*3*/ <-4.07346,3.90707,-0.03186>,<-4.06997,3.90864,-0.04293>,<-4.06523,3.91504,-0.03434>,
            
    /*4*/ <-4.14434,3.99225,-0.04584>,<-4.14111,3.99344,-0.0555>,<-4.1365,3.99852,-0.04789>,
            
    /*5*/ <-4.20555,4.08519,-0.04776>,<-4.20316,4.08665,-0.05609>,<-4.19837,4.08995,-0.04951>,
            
    /*6*/ <-4.24599,4.18937,-0.05887>,<-4.24348,4.18965,-0.06574>,<-4.23924,4.19188,-0.06021>,
            
    /*7*/ <-4.2799,4.28971,-0.09526>,<-4.2774,4.2887,-0.10046>,<-4.27434,4.29129,-0.09619>,
            
    /*8*/ <-4.32933,4.38673,-0.11416>,<-4.32781,4.38673,-0.11828>,<-4.32544,4.38857,-0.11507>,
            
    /*9*/ <-4.3867,4.47755,-0.14297>,<-4.3856,4.4774,-0.14568>,<-4.3842,4.47894,-0.14362>,
            
    /*10*/ <-4.44835,4.56685,-0.16691>,<-4.44785,4.56684,-0.16829>,<-4.44714,4.5676,-0.16726>,
            
    /*11*/ <-4.50503,4.66101,-0.18402>

    /* stem 0.1c2.0.0*/ 
    /*0*/ <-3.95351,3.81124,-0.01774>,
    /*1*/ <-3.95299,3.81136,-0.02129>,<-3.95502,3.81402,-0.01606>,<-3.95252,3.80834,-0.01588>,
            
    /*2*/ <-4.34113,3.63923,-0.07999>

    /* stem 0.1c2.0.1*/ 
    /*0*/ <-4.08787,3.93202,-0.03982>,
    /*1*/ <-4.08678,3.93337,-0.03707>,<-4.09105,3.93209,-0.04052>,<-4.08579,3.93059,-0.04187>,
            
    /*2*/ <-4.03942,4.26647,-0.2235>

    /* stem 0.1c2.0.2*/ 
    /*0*/ <-4.18208,4.05686,-0.05067>,
    /*1*/ <-4.18442,4.05529,-0.05161>,<-4.18167,4.05963,-0.05164>,<-4.18017,4.05566,-0.04875>,
            
    /*2*/ <-4.37061,4.17802,0.21413>

    /* stem 0.1c2.0.3*/ 
    /*0*/ <-4.22732,4.15068,-0.05757>,
    /*1*/ <-4.22487,4.15155,-0.05854>,<-4.22862,4.15214,-0.05561>,<-4.22846,4.14836,-0.05857>,
            
    /*2*/ <-4.37776,4.32204,-0.28448>

    /* stem 0.1c2.0.4*/ 
    /*0*/ <-4.30024,4.33449,-0.10578>,
    /*1*/ <-4.30139,4.33429,-0.1037>,<-4.30137,4.33537,-0.10769>,<-4.29796,4.33381,-0.10596>,
            
    /*2*/ <-4.22018,4.5859,-0.03758>

    /* stem 0.1c2.0.5*/ 
    /*0*/ <-4.36988,4.45354,-0.13648>,
    /*1*/ <-4.36999,4.4529,-0.13828>,<-4.36935,4.45535,-0.13613>,<-4.37029,4.45236,-0.13502>,
            
    /*2*/ <-4.59814,4.52209,-0.14628>

    /* stem 0.1c2.0.6*/ 
    /*0*/ <-4.46517,4.59562,-0.17251>,
    /*1*/ <-4.46479,4.59591,-0.17216>,<-4.46575,4.59566,-0.17241>,<-4.46497,4.59529,-0.17295>,
            
    /*2*/ <-4.47519,4.75129,-0.29208>

    /* stem 0.1.0*/ 
    /*0*/ <-0.33571,4.27961,-0.0618>,
    /*1*/ <-0.34498,4.30848,-0.02836>,<-0.35423,4.23845,-0.06186>,<-0.30793,4.29191,-0.09519>,
            
    /*2*/ <-0.53162,4.39015,-0.15665>,<-0.53995,4.32712,-0.1868>,<-0.49828,4.37523,-0.2168>,
            
    /*3*/ <-0.72525,4.48426,-0.25027>,<-0.73858,4.43033,-0.27903>,<-0.70381,4.47348,-0.30803>,
            
    /*4*/ <-0.90445,4.61094,-0.34137>,<-0.92206,4.56742,-0.3695>,<-0.88616,4.60195,-0.39216>,
            
    /*5*/ <-1.07618,4.7563,-0.41852>,<-1.09493,4.72176,-0.44412>,<-1.06258,4.75002,-0.46298>,
            
    /*6*/ <-1.20307,4.93552,-0.51673>,<-1.22161,4.91039,-0.54024>,<-1.18843,4.92735,-0.55204>,
            
    /*7*/ <-1.34594,5.11569,-0.5769>,<-1.36214,5.09706,-0.5961>,<-1.3375,5.11301,-0.6069>,
            
    /*8*/ <-1.48922,5.29917,-0.63814>,<-1.50144,5.28531,-0.65258>,<-1.48285,5.29714,-0.66062>,
            
    /*9*/ <-1.62365,5.49364,-0.6743>,<-1.63284,5.48575,-0.6842>,<-1.62032,5.49342,-0.68958>,
            
    /*10*/ <-1.76273,5.68729,-0.70732>,<-1.76731,5.68331,-0.71226>,<-1.76114,5.68728,-0.71497>,
            
    /*11*/ <-1.89039,5.88893,-0.73802>

    /* stem 0.1.0.0*/ 
    /*0*/ <-0.47863,4.34403,-0.157>,
    /*1*/ <-0.48286,4.3264,-0.16257>,<-0.47628,4.35775,-0.1699>,<-0.47673,4.34795,-0.13854>,
            
    /*2*/ <-1.37415,4.54363,-0.10733>

    /* stem 0.1.0.1*/ 
    /*0*/ <-0.55786,4.38126,-0.20278>,
    /*1*/ <-0.54796,4.39577,-0.20867>,<-0.57385,4.38399,-0.19381>,<-0.55178,4.36403,-0.20586>,
            
    /*2*/ <-0.99784,4.36515,-0.98208>

    /* stem 0.1.0.2*/ 
    /*0*/ <-0.66294,4.43322,-0.25148>,
    /*1*/ <-0.67226,4.42785,-0.2371>,<-0.66895,4.42947,-0.26799>,<-0.64761,4.44233,-0.24936>,
            
    /*2*/ <-1.10393,5.17685,-0.2598>

    /* stem 0.1.0.3*/ 
    /*0*/ <-0.85877,4.56072,-0.34552>,
    /*1*/ <-0.85488,4.5556,-0.36107>,<-0.86283,4.57681,-0.34274>,<-0.85859,4.54976,-0.33276>,
            
    /*2*/ <-1.63219,4.38903,-0.48248>

    /* stem 0.1.0.4*/ 
    /*0*/ <-0.98063,4.6591,-0.40032>,
    /*1*/ <-0.97588,4.67,-0.38951>,<-0.99629,4.65703,-0.4033>,<-0.96972,4.65027,-0.40815>,
            
    /*2*/ <-0.94612,5.18909,-0.9497>

    /* stem 0.1.0.5*/ 
    /*0*/ <-1.10058,4.77529,-0.45882>,
    /*1*/ <-1.11224,4.76581,-0.46146>,<-1.09656,4.78556,-0.46937>,<-1.09294,4.77451,-0.44563>,
            
    /*2*/ <-1.55545,5.25317,-0.16699>

    /* stem 0.1.0.6*/ 
    /*0*/ <-1.1645,4.86714,-0.50656>,
    /*1*/ <-1.15236,4.87216,-0.51315>,<-1.17269,4.87618,-0.49835>,<-1.16846,4.85307,-0.50818>,
            
    /*2*/ <-1.53737,5.03631,-1.06469>

    /* stem 0.1.0.7*/ 
    /*0*/ <-1.30364,5.05124,-0.57556>,
    /*1*/ <-1.30903,5.05088,-0.56309>,<-1.31162,5.05337,-0.58635>,<-1.29027,5.04947,-0.57724>,
            
    /*2*/ <-1.21373,5.67646,-0.51855>

    /* stem 0.1.0.8*/ 
    /*0*/ <-1.4089,5.18701,-0.61749>,
    /*1*/ <-1.41074,5.18202,-0.6291>,<-1.40809,5.19967,-0.61604>,<-1.40788,5.17935,-0.60733>,
            
    /*2*/ <-1.99449,5.21547,-0.53698>

    /* stem 0.1.0.9*/ 
    /*0*/ <-1.53487,5.35794,-0.66093>,
    /*1*/ <-1.52688,5.36433,-0.65516>,<-1.54628,5.35902,-0.6583>,<-1.53147,5.35046,-0.66933>,
            
    /*2*/ <-1.58272,5.74962,-1.0291>

    /* stem 0.1.0.10*/ 
    /*0*/ <-1.65714,5.53546,-0.68927>,
    /*1*/ <-1.66366,5.53106,-0.68783>,<-1.6572,5.54089,-0.69515>,<-1.65056,5.53444,-0.68484>,
            
    /*2*/ <-1.81593,5.87328,-0.37572>

    /* stem 0.1.0.11*/ 
    /*0*/ <-1.73825,5.64998,-0.7062>,
    /*1*/ <-1.73519,5.65155,-0.71029>,<-1.74001,5.65358,-0.70265>,<-1.73955,5.64483,-0.70565>,
            
    /*2*/ <-2.10936,5.7166,-0.95833>

    /* stem 0.1.0.12*/ 
    /*0*/ <-1.84735,5.81995,-0.72901>,
    /*1*/ <-1.84743,5.82009,-0.72749>,<-1.84857,5.82025,-0.72988>,<-1.84603,5.8195,-0.72967>,
            
    /*2*/ <-1.73023,6.20626,-0.75889>

    /* stem 0.1.1*/ 
    /*0*/ <-0.48901,4.26427,-0.07761>,
    /*1*/ <-0.48472,4.22082,-0.08456>,<-0.50841,4.28974,-0.10811>,<-0.47391,4.28226,-0.04014>,
            
    /*2*/ <-0.69393,4.18821,0.01805>,<-0.71526,4.25024,-0.00314>,<-0.68421,4.24351,0.05803>,
            
    /*3*/ <-0.89888,4.196,0.14754>,<-0.91234,4.25109,0.12434>,<-0.87992,4.24675,0.17615>,
            
    /*4*/ <-1.10635,4.31145,0.22725>,<-1.09462,4.35387,0.19664>,<-1.07675,4.35148,0.24712>,
            
    /*5*/ <-1.28207,4.46584,0.28721>,<-1.26495,4.49742,0.25855>,<-1.25108,4.49621,0.30234>,
            
    /*6*/ <-1.44358,4.63588,0.32736>,<-1.426,4.65926,0.30266>,<-1.41628,4.65973,0.3397>,
            
    /*7*/ <-1.59294,4.80192,0.40114>,<-1.58076,4.8222,0.38168>,<-1.56962,4.81965,0.4101>,
            
    /*8*/ <-1.72169,4.9879,0.47328>,<-1.71128,5.00151,0.45797>,<-1.70262,4.99929,0.47914>,
            
    /*9*/ <-1.8192,5.20291,0.5046>,<-1.81033,5.20879,0.49359>,<-1.80553,5.20885,0.50813>,
            
    /*10*/ <-1.89557,5.42569,0.52305>,<-1.89083,5.42791,0.51747>,<-1.88851,5.4281,0.52476>,
            
    /*11*/ <-1.97832,5.64378,0.55243>

    /* stem 0.1.1.0*/ 
    /*0*/ <-0.62278,4.2406,-0.01231>,
    /*1*/ <-0.62959,4.25586,-0.02073>,<-0.62434,4.23866,0.00624>,<-0.6144,4.22728,-0.02243>,
            
    /*2*/ <-1.41851,3.82432,-0.1232>

    /* stem 0.1.1.1*/ 
    /*0*/ <-0.74201,4.2282,0.05206>,
    /*1*/ <-0.73274,4.2238,0.06697>,<-0.75793,4.2203,0.04864>,<-0.73535,4.24049,0.04056>,
            
    /*2*/ <-1.15004,4.86079,0.49227>

    /* stem 0.1.1.2*/ 
    /*0*/ <-0.86732,4.23069,0.13069>,
    /*1*/ <-0.87576,4.22306,0.11748>,<-0.87506,4.24336,0.13983>,<-0.85114,4.22564,0.13477>,
            
    /*2*/ <-1.17791,3.66053,0.65818>

    /* stem 0.1.1.3*/ 
    /*0*/ <-1.03228,4.30574,0.20075>,
    /*1*/ <-1.02348,4.31929,0.20428>,<-1.04319,4.29987,0.21172>,<-1.03018,4.29805,0.18625>,
            
    /*2*/ <-1.59613,4.75545,-0.11932>

    /* stem 0.1.1.4*/ 
    /*0*/ <-1.15474,4.39182,0.24483>,
    /*1*/ <-1.1621,4.3801,0.25251>,<-1.16312,4.40208,0.23615>,<-1.13901,4.39329,0.24582>,
            
    /*2*/ <-1.23388,4.83566,0.84596>

    /* stem 0.1.1.5*/ 
    /*0*/ <-1.3096,4.53074,0.29356>,
    /*1*/ <-1.30784,4.53587,0.27974>,<-1.31009,4.54021,0.30499>,<-1.31088,4.51614,0.29596>,
            
    /*2*/ <-2.00438,4.57978,0.22318>

    /* stem 0.1.1.6*/ 
    /*0*/ <-1.38441,4.60672,0.31222>,
    /*1*/ <-1.37914,4.60867,0.32543>,<-1.39861,4.60599,0.31019>,<-1.37549,4.6055,0.30103>,
            
    /*2*/ <-1.4058,5.27441,0.2222>

    /* stem 0.1.1.7*/ 
    /*0*/ <-1.49124,4.71854,0.35379>,
    /*1*/ <-1.5014,4.7118,0.34773>,<-1.48932,4.73176,0.35115>,<-1.483,4.71207,0.36248>,
            
    /*2*/ <-1.87854,4.87069,0.83417>

    /* stem 0.1.1.8*/ 
    /*0*/ <-1.65962,4.92366,0.44117>,
    /*1*/ <-1.65049,4.93139,0.43824>,<-1.66536,4.92472,0.45201>,<-1.663,4.91485,0.43325>,
            
    /*2*/ <-2.03611,5.27918,0.20688>

    /* stem 0.1.1.9*/ 
    /*0*/ <-1.74929,5.0752,0.48212>,
    /*1*/ <-1.75444,5.07132,0.49159>,<-1.75513,5.08161,0.47463>,<-1.73829,5.07267,0.48014>,
            
    /*2*/ <-1.60337,5.50862,0.7392>

    /* stem 0.1.1.10*/ 
    /*0*/ <-1.82625,5.24698,0.50568>,
    /*1*/ <-1.8274,5.24727,0.49773>,<-1.82198,5.25273,0.50934>,<-1.82936,5.24095,0.50998>,
            
    /*2*/ <-2.22648,5.50146,0.57313>

    /* stem 0.1.1.11*/ 
    /*0*/ <-1.86992,5.36737,0.51642>,
    /*1*/ <-1.86594,5.36847,0.52024>,<-1.87509,5.36949,0.51705>,<-1.86873,5.36414,0.51197>,
            
    /*2*/ <-1.74861,5.73142,0.28482>

    /* stem 0.1.1.12*/ 
    /*0*/ <-1.94875,5.56991,0.54197>,
    /*1*/ <-1.95015,5.56936,0.54189>,<-1.94839,5.57118,0.54123>,<-1.9477,5.56919,0.54278>,
            
    /*2*/ <-2.05031,5.78263,0.85976>

    /* stem 0.1.2*/ 
    /*0*/ <-0.74503,4.24133,-0.09232>,
    /*1*/ <-0.74705,4.27791,-0.11423>,<-0.76274,4.23865,-0.05358>,<-0.7253,4.20743,-0.10916>,
            
    /*2*/ <-0.94161,4.20743,-0.20568>,<-0.95573,4.17209,-0.1511>,<-0.92204,4.144,-0.20112>,
            
    /*3*/ <-1.11935,4.25967,-0.29927>,<-1.14966,4.22749,-0.25999>,<-1.13005,4.20248,-0.30986>,
            
    /*4*/ <-1.29919,4.35899,-0.37789>,<-1.32912,4.33262,-0.34492>,<-1.31916,4.31335,-0.3919>,
            
    /*5*/ <-1.44348,4.50357,-0.45586>,<-1.47563,4.48584,-0.43096>,<-1.46848,4.47071,-0.47204>,
            
    /*6*/ <-1.53702,4.68907,-0.52452>,<-1.56821,4.68055,-0.50662>,<-1.56352,4.66987,-0.54169>,
            
    /*7*/ <-1.61177,4.88663,-0.59917>,<-1.63782,4.88235,-0.58584>,<-1.63381,4.87333,-0.61372>,
            
    /*8*/ <-1.68568,5.0899,-0.66472>,<-1.70514,5.08648,-0.65464>,<-1.70246,5.08061,-0.67586>,
            
    /*9*/ <-1.76841,5.28557,-0.74435>,<-1.78134,5.28313,-0.7376>,<-1.77922,5.27839,-0.75144>,
            
    /*10*/ <-1.85228,5.48483,-0.81096>,<-1.85866,5.48343,-0.80751>,<-1.85777,5.48145,-0.81458>,
            
    /*11*/ <-1.91634,5.69444,-0.8653>

    /* stem 0.1.2.0*/ 
    /*0*/ <-0.87603,4.19638,-0.15531>,
    /*1*/ <-0.88125,4.18944,-0.13951>,<-0.8775,4.18659,-0.17038>,<-0.86936,4.21311,-0.15604>,
            
    /*2*/ <-1.67577,4.51009,-0.28144>

    /* stem 0.1.2.1*/ 
    /*0*/ <-1.04375,4.2043,-0.24178>,
    /*1*/ <-1.03696,4.19976,-0.25686>,<-1.05155,4.21948,-0.24012>,<-1.04275,4.19366,-0.22837>,
            
    /*2*/ <-1.75748,3.86157,-0.4601>

    /* stem 0.1.2.2*/ 
    /*0*/ <-1.17034,4.25134,-0.30642>,
    /*1*/ <-1.1685,4.26326,-0.29521>,<-1.18531,4.24526,-0.30959>,<-1.1572,4.24548,-0.31445>,
            
    /*2*/ <-1.27129,4.79269,-0.86605>

    /* stem 0.1.2.3*/ 
    /*0*/ <-1.25919,4.30242,-0.34621>,
    /*1*/ <-1.26649,4.28833,-0.34799>,<-1.26062,4.31364,-0.35748>,<-1.25046,4.3053,-0.33315>,
            
    /*2*/ <-1.87378,4.5766,0.00423>

    /* stem 0.1.2.4*/ 
    /*0*/ <-1.36236,4.38311,-0.39738>,
    /*1*/ <-1.3508,4.3908,-0.40387>,<-1.37209,4.39035,-0.38803>,<-1.36418,4.36817,-0.40026>,
            
    /*2*/ <-1.78642,4.54351,-0.96276>

    /* stem 0.1.2.5*/ 
    /*0*/ <-1.48729,4.53774,-0.4718>,
    /*1*/ <-1.49533,4.53822,-0.45993>,<-1.49317,4.54064,-0.48456>,<-1.47339,4.53436,-0.47091>,
            
    /*2*/ <-1.33398,5.18877,-0.39442>

    /* stem 0.1.2.6*/ 
    /*0*/ <-1.58698,4.76612,-0.55661>,
    /*1*/ <-1.58737,4.7614,-0.56885>,<-1.58256,4.77828,-0.55441>,<-1.591,4.75868,-0.54658>,
            
    /*2*/ <-2.15318,4.98344,-0.62249>

    /* stem 0.1.2.7*/ 
    /*0*/ <-1.67476,5.0183,-0.64354>,
    /*1*/ <-1.66714,5.0233,-0.63603>,<-1.68572,5.02258,-0.64456>,<-1.67142,5.00902,-0.65003>,
            
    /*2*/ <-1.50729,5.3532,-1.03628>

    /* stem 0.1.2.8*/ 
    /*0*/ <-1.70891,5.11358,-0.67634>,
    /*1*/ <-1.71939,5.10934,-0.67649>,<-1.70563,5.12082,-0.68439>,<-1.70172,5.1106,-0.66815>,
            
    /*2*/ <-1.87344,5.50971,-0.38759>

    /* stem 0.1.2.9*/ 
    /*0*/ <-1.75078,5.21839,-0.71865>,
    /*1*/ <-1.74282,5.2192,-0.72452>,<-1.75444,5.22643,-0.71412>,<-1.75507,5.20955,-0.71729>,
            
    /*2*/ <-2.04186,5.30118,-1.10166>

    /* stem 0.1.2.10*/ 
    /*0*/ <-1.83012,5.41759,-0.78927>,
    /*1*/ <-1.83171,5.41872,-0.78395>,<-1.83372,5.41849,-0.79355>,<-1.82494,5.41556,-0.7903>,
            
    /*2*/ <-1.6797,5.82255,-0.83038>

    /* stem 0.1.2.11*/ 
    /*0*/ <-1.87597,5.5526,-0.82884>,
    /*1*/ <-1.87709,5.55165,-0.83131>,<-1.87455,5.55509,-0.82878>,<-1.87628,5.55106,-0.82644>,
            
    /*2*/ <-2.21586,5.74448,-0.74908>

    /* stem 0.1.3*/ 
    /*0*/ <-1.04797,4.19701,-0.09294>,
    /*1*/ <-1.04511,4.18397,-0.05434>,<-1.06633,4.17375,-0.12105>,<-1.03247,4.23332,-0.10343>,
            
    /*2*/ <-1.23393,4.27896,-0.01256>,<-1.25303,4.26976,-0.0726>,<-1.22256,4.32337,-0.05675>,
            
    /*3*/ <-1.37652,4.42381,0.05343>,<-1.40322,4.42141,0.00358>,<-1.36168,4.459,0.01165>,
            
    /*4*/ <-1.49992,4.59083,0.11555>,<-1.52436,4.58985,0.07249>,<-1.48387,4.61795,0.07735>,
            
    /*5*/ <-1.60935,4.77191,0.16543>,<-1.6299,4.77054,0.12831>,<-1.59327,4.79176,0.13153>,
            
    /*6*/ <-1.70125,4.96112,0.21346>,<-1.71895,4.96096,0.18283>,<-1.68699,4.976,0.18471>,
            
    /*7*/ <-1.79075,5.15203,0.25899>,<-1.80485,5.15179,0.23445>,<-1.77913,5.16351,0.23588>,
            
    /*8*/ <-1.88294,5.34526,0.29111>,<-1.89295,5.34397,0.27244>,<-1.87374,5.35294,0.27359>,
            
    /*9*/ <-1.95756,5.54588,0.31834>,<-1.96434,5.54529,0.30594>,<-1.95107,5.55015,0.30651>,
            
    /*10*/ <-2.03663,5.73434,0.38187>,<-2.04039,5.7349,0.3759>,<-2.03384,5.73755,0.37621>,
            
    /*11*/ <-2.10512,5.93146,0.43625>

    /* stem 0.1.3.0*/ 
    /*0*/ <-1.16955,4.25743,-0.06351>,
    /*1*/ <-1.1758,4.2523,-0.07879>,<-1.17209,4.27366,-0.05815>,<-1.16078,4.24632,-0.0536>,
            
    /*2*/ <-1.87565,4.02627,0.30268>

    /* stem 0.1.3.1*/ 
    /*0*/ <-1.31705,4.37128,-0.00804>,
    /*1*/ <-1.30486,4.38104,-0.00307>,<-1.33084,4.37028,0.00076>,<-1.31544,4.3625,-0.02179>,
            
    /*2*/ <-1.62191,4.96089,-0.41966>

    /* stem 0.1.3.2*/ 
    /*0*/ <-1.40249,4.46441,0.0347>,
    /*1*/ <-1.41289,4.45425,0.04083>,<-1.4075,4.47635,0.02566>,<-1.38707,4.46264,0.03759>,
            
    /*2*/ <-1.46682,4.8974,0.64241>

    /* stem 0.1.3.3*/ 
    /*0*/ <-1.46656,4.55079,0.06907>,
    /*1*/ <-1.46369,4.55813,0.05598>,<-1.46626,4.5584,0.0823>,<-1.46972,4.53586,0.06891>,
            
    /*2*/ <-2.16926,4.70031,-0.00117>

    /* stem 0.1.3.4*/ 
    /*0*/ <-1.5797,4.72666,0.12641>,
    /*1*/ <-1.57468,4.72572,0.13973>,<-1.59312,4.73097,0.12412>,<-1.57132,4.72328,0.11536>,
            
    /*2*/ <-1.36961,5.36165,0.09166>

    /* stem 0.1.3.5*/ 
    /*0*/ <-1.64316,4.84443,0.16008>,
    /*1*/ <-1.65421,4.84104,0.15284>,<-1.63779,4.8569,0.15889>,<-1.63748,4.83533,0.1685>,
            
    /*2*/ <-2.01605,5.04992,0.63337>

    /* stem 0.1.3.6*/ 
    /*0*/ <-1.7561,5.08029,0.22344>,
    /*1*/ <-1.74512,5.08583,0.22196>,<-1.76309,5.08292,0.23332>,<-1.76009,5.07211,0.21503>,
            
    /*2*/ <-2.00871,5.50287,-0.06783>

    /* stem 0.1.3.7*/ 
    /*0*/ <-1.82992,5.23596,0.25815>,
    /*1*/ <-1.83645,5.23128,0.26646>,<-1.83489,5.24185,0.24953>,<-1.81843,5.23475,0.25845>,
            
    /*2*/ <-1.79039,5.68251,0.54055>

    /* stem 0.1.3.8*/ 
    /*0*/ <-1.90974,5.41857,0.29017>,
    /*1*/ <-1.90987,5.42016,0.27969>,<-1.90475,5.42544,0.29652>,<-1.91461,5.41011,0.29431>,
            
    /*2*/ <-2.31579,5.67333,0.33379>

    /* stem 0.1.3.9*/ 
    /*0*/ <-1.94615,5.51624,0.30544>,
    /*1*/ <-1.94076,5.51717,0.31233>,<-1.95469,5.51819,0.30624>,<-1.94299,5.51336,0.29775>,
            
    /*2*/ <-1.85983,5.94609,0.17991>

    /* stem 0.1.3.10*/ 
    /*0*/ <-1.99102,5.62641,0.33876>,
    /*1*/ <-1.99699,5.62438,0.33743>,<-1.98931,5.6325,0.33745>,<-1.98675,5.62237,0.34141>,
            
    /*2*/ <-2.11868,5.74623,0.72746>

    /* stem 0.1.3.11*/ 
    /*0*/ <-2.07023,5.83122,0.40644>,
    /*1*/ <-2.06859,5.83208,0.40548>,<-2.07063,5.83167,0.40844>,<-2.07149,5.82991,0.40539>,
            
    /*2*/ <-2.28104,6.11785,0.30093>

    /* stem 0.1.4*/ 
    /*0*/ <-1.97812,3.97438,-0.03236>,
    /*1*/ <-1.97774,3.9617,-0.06502>,<-1.99958,4.00081,-0.02408>,<-1.95704,3.96064,-0.00798>,
            
    /*2*/ <-2.10731,3.84374,-0.01696>,<-2.12696,3.87894,0.01989>,<-2.08867,3.84279,0.03437>,
            
    /*3*/ <-2.27235,3.81283,0.0822>,<-2.26753,3.85639,0.1031>,<-2.24847,3.81707,0.12426>,
            
    /*4*/ <-2.40507,3.86012,0.21441>,<-2.38626,3.89784,0.21974>,<-2.37474,3.86477,0.24379>,
            
    /*5*/ <-2.50498,3.93572,0.35303>,<-2.48468,3.96592,0.35177>,<-2.47517,3.9385,0.37375>,
            
    /*6*/ <-2.60557,4.05135,0.45224>,<-2.58528,4.0735,0.44794>,<-2.58278,4.05507,0.47192>,
            
    /*7*/ <-2.69851,4.18248,0.53906>,<-2.68094,4.19857,0.53442>,<-2.68033,4.18548,0.55486>,
            
    /*8*/ <-2.79429,4.32107,0.60623>,<-2.78072,4.33263,0.60256>,<-2.78145,4.32429,0.61872>,
            
    /*9*/ <-2.85601,4.46978,0.69521>,<-2.84619,4.47608,0.69188>,<-2.84616,4.46985,0.7023>,
            
    /*10*/ <-2.93892,4.61772,0.75764>,<-2.93414,4.62115,0.75616>,<-2.93448,4.61863,0.76167>,
            
    /*11*/ <-3.01413,4.77516,0.80886>

    /* stem 0.1.4.0*/ 
    /*0*/ <-2.04106,3.91645,-0.01059>,
    /*1*/ <-2.04792,3.92696,-0.00246>,<-2.04055,3.90234,-0.00567>,<-2.03471,3.92005,-0.02365>,
            
    /*2*/ <-2.64735,3.77825,-0.34371>

    /* stem 0.1.4.1*/ 
    /*0*/ <-2.16284,3.84577,0.04472>,
    /*1*/ <-2.15818,3.83301,0.04898>,<-2.17553,3.84696,0.03838>,<-2.15481,3.85733,0.0468>,
            
    /*2*/ <-2.4512,3.93892,0.63949>

    /* stem 0.1.4.2*/ 
    /*0*/ <-2.30277,3.84321,0.14219>,
    /*1*/ <-2.3104,3.84839,0.13244>,<-2.30188,3.84943,0.15404>,<-2.29602,3.83179,0.14008>,
            
    /*2*/ <-2.79262,3.51504,0.35127>

    /* stem 0.1.4.3*/ 
    /*0*/ <-2.43346,3.90682,0.28601>,
    /*1*/ <-2.42304,3.90974,0.2922>,<-2.44253,3.90046,0.29173>,<-2.43481,3.91027,0.27411>,
            
    /*2*/ <-2.67343,4.4021,0.45678>

    /* stem 0.1.4.4*/ 
    /*0*/ <-2.55554,4.02073,0.42346>,
    /*1*/ <-2.56403,4.01306,0.4234>,<-2.55763,4.03159,0.42054>,<-2.54497,4.01753,0.42643>,
            
    /*2*/ <-2.66161,4.13457,0.92356>

    /* stem 0.1.4.5*/ 
    /*0*/ <-2.66077,4.15396,0.51966>,
    /*1*/ <-2.65653,4.16125,0.51339>,<-2.66109,4.1555,0.53005>,<-2.6647,4.14512,0.51553>,
            
    /*2*/ <-3.08669,4.3638,0.47559>

    /* stem 0.1.4.6*/ 
    /*0*/ <-2.74591,4.27111,0.5826>,
    /*1*/ <-2.74487,4.26749,0.59161>,<-2.75427,4.27541,0.58>,<-2.73858,4.27042,0.5762>,
            
    /*2*/ <-2.58962,4.65765,0.71967>

    /* stem 0.1.4.7*/ 
    /*0*/ <-2.83061,4.42891,0.67074>,
    /*1*/ <-2.83638,4.42969,0.6652>,<-2.82583,4.43514,0.67248>,<-2.82961,4.4219,0.67455>,
            
    /*2*/ <-3.08089,4.54372,0.94791>

    /* stem 0.1.4.8*/ 
    /*0*/ <-2.91067,4.57625,0.74041>,
    /*1*/ <-2.9067,4.57812,0.74151>,<-2.91393,4.57588,0.74352>,<-2.91138,4.57475,0.7362>,
            
    /*2*/ <-3.03237,4.88828,0.64983>

    /* stem 0.1.4.9*/ 
    /*0*/ <-2.96562,4.67849,0.77764>,
    /*1*/ <-2.96724,4.67738,0.77856>,<-2.96604,4.6803,0.77652>,<-2.96357,4.67779,0.77785>,
            
    /*2*/ <-2.93332,4.85058,1.0427>

    /* stem 0.1.5*/ 
    /*0*/ <-2.282,3.89624,0.00545>,
    /*1*/ <-2.28726,3.92466,0.02157>,<-2.28363,3.86744,0.02169>,<-2.27511,3.89661,-0.02693>,
            
    /*2*/ <-2.45318,3.91119,-0.0156>,<-2.44991,3.8597,-0.0155>,<-2.44224,3.88595,-0.05925>,
            
    /*3*/ <-2.61304,3.9373,-0.0259>,<-2.62085,3.8921,-0.026>,<-2.61485,3.91442,-0.06561>,
            
    /*4*/ <-2.76371,4.00304,-0.03202>,<-2.78021,3.96646,-0.03238>,<-2.77097,3.98465,-0.06694>,
            
    /*5*/ <-2.89318,4.10506,-0.02894>,<-2.9148,4.07831,-0.02902>,<-2.90461,4.09227,-0.05876>,
            
    /*6*/ <-2.99433,4.23632,-0.01975>,<-3.01725,4.21912,-0.01937>,<-3.00703,4.22881,-0.04433>,
            
    /*7*/ <-3.09608,4.37274,-0.01187>,<-3.11468,4.35933,-0.01155>,<-3.10625,4.36677,-0.03154>,
            
    /*8*/ <-3.18989,4.51386,-0.00077>,<-3.20436,4.50456,-0.00046>,<-3.19795,4.51,-0.01546>,
            
    /*9*/ <-3.28557,4.65554,-0.00917>,<-3.29519,4.64929,-0.00903>,<-3.29026,4.65202,-0.01902>,
            
    /*10*/ <-3.37227,4.80184,-0.01614>,<-3.37725,4.799,-0.01608>,<-3.37473,4.80026,-0.02107>,
            
    /*11*/ <-3.45643,4.94857,0.00333>

    /* stem 0.1.5.0*/ 
    /*0*/ <-2.41,3.88807,-0.0219>,
    /*1*/ <-2.40964,3.87437,-0.01951>,<-2.41806,3.89314,-0.03203>,<-2.40231,3.89668,-0.01416>,
            
    /*2*/ <-2.90189,3.94855,0.39968>

    /* stem 0.1.5.1*/ 
    /*0*/ <-2.49229,3.89319,-0.03248>,
    /*1*/ <-2.49027,3.90168,-0.0428>,<-2.50195,3.89578,-0.02339>,<-2.48466,3.8821,-0.03125>,
            
    /*2*/ <-2.90672,3.56931,-0.38017>

    /* stem 0.1.5.2*/ 
    /*0*/ <-2.69301,3.94924,-0.04145>,
    /*1*/ <-2.69337,3.94928,-0.02891>,<-2.70347,3.94705,-0.04801>,<-2.6822,3.9514,-0.04742>,
            
    /*2*/ <-2.80916,4.51752,-0.04637>

    /* stem 0.1.5.3*/ 
    /*0*/ <-2.82081,4.02447,-0.04198>,
    /*1*/ <-2.82578,4.01873,-0.05106>,<-2.82155,4.03627,-0.04131>,<-2.8151,4.01841,-0.03356>,
            
    /*2*/ <-3.28404,3.97958,0.24>

    /* stem 0.1.5.4*/ 
    /*0*/ <-2.95424,4.1587,-0.03347>,
    /*1*/ <-2.94553,4.16508,-0.03172>,<-2.96316,4.1598,-0.02724>,<-2.95403,4.15122,-0.04145>,
            
    /*2*/ <-3.13618,4.49477,-0.3533>

    /* stem 0.1.5.5*/ 
    /*0*/ <-3.05559,4.29671,-0.0231>,
    /*1*/ <-3.06248,4.2914,-0.01793>,<-3.05846,4.30243,-0.03094>,<-3.04584,4.2963,-0.02043>,
            
    /*2*/ <-3.11785,4.65148,0.25844>

    /* stem 0.1.5.6*/ 
    /*0*/ <-3.12965,4.40372,-0.01498>,
    /*1*/ <-3.12742,4.40595,-0.02394>,<-3.12942,4.4104,-0.00823>,<-3.13212,4.39482,-0.01278>,
            
    /*2*/ <-3.53759,4.49744,-0.09347>

    /* stem 0.1.5.7*/ 
    /*0*/ <-3.23563,4.56822,-0.00838>,
    /*1*/ <-3.23327,4.57014,-0.00039>,<-3.2439,4.56832,-0.01054>,<-3.22972,4.5662,-0.01421>,
            
    /*2*/ <-3.2058,4.93332,-0.1048>

    /* stem 0.1.5.8*/ 
    /*0*/ <-3.31391,4.69363,-0.0139>,
    /*1*/ <-3.31818,4.6911,-0.0167>,<-3.31174,4.69853,-0.01585>,<-3.31181,4.69127,-0.00917>,
            
    /*2*/ <-3.54127,4.86892,0.1743>

    /* stem 0.1.5.9*/ 
    /*0*/ <-3.39784,4.84227,-0.0118>,
    /*1*/ <-3.39583,4.84344,-0.01225>,<-3.39905,4.8427,-0.0098>,<-3.39865,4.84066,-0.01335>,
            
    /*2*/ <-3.55498,5.05796,-0.15363>

    /* stem 0.1.6*/ 
    /*0*/ <-2.62142,3.81588,0.05844>,
    /*1*/ <-2.61522,3.78626,0.06439>,<-2.63715,3.82354,0.03305>,<-2.61188,3.83784,0.07789>,
            
    /*2*/ <-2.75146,3.77697,0.14414>,<-2.7712,3.81053,0.11593>,<-2.74845,3.82339,0.15629>,
            
    /*3*/ <-2.89227,3.81332,0.22378>,<-2.90199,3.84261,0.19423>,<-2.87947,3.85379,0.22879>,
            
    /*4*/ <-3.03285,3.88381,0.272>,<-3.03197,3.90682,0.24253>,<-3.01578,3.91697,0.27467>,
            
    /*5*/ <-3.156,3.98186,0.31177>,<-3.15137,3.99922,0.28523>,<-3.13628,4.00711,0.31238>,
            
    /*6*/ <-3.26212,4.09868,0.34382>,<-3.25597,4.1111,0.32099>,<-3.24269,4.117,0.34339>,
            
    /*7*/ <-3.37275,4.21176,0.35544>,<-3.36636,4.22043,0.33699>,<-3.35773,4.22696,0.35541>,
            
    /*8*/ <-3.47146,4.33626,0.3665>,<-3.46608,4.34211,0.35258>,<-3.45908,4.34643,0.36633>,
            
    /*9*/ <-3.56039,4.46799,0.35385>,<-3.55567,4.4705,0.3446>,<-3.55164,4.47411,0.35382>,
            
    /*10*/ <-3.62951,4.61076,0.35511>,<-3.62717,4.61203,0.35048>,<-3.62474,4.61317,0.3551>,
            
    /*11*/ <-3.71456,4.74283,0.33826>

    /* stem 0.1.6.0*/ 
    /*0*/ <-2.72569,3.80646,0.12022>,
    /*1*/ <-2.73163,3.81377,0.11131>,<-2.72787,3.80856,0.13282>,<-2.71758,3.79706,0.11652>,
            
    /*2*/ <-3.18507,3.41572,0.10593>

    /* stem 0.1.6.1*/ 
    /*0*/ <-2.83768,3.82343,0.18494>,
    /*1*/ <-2.83136,3.82458,0.19549>,<-2.84772,3.81625,0.18452>,<-2.83396,3.82944,0.17483>,
            
    /*2*/ <-3.16319,4.27013,0.33095>

    /* stem 0.1.6.2*/ 
    /*0*/ <-2.93267,3.85672,0.2301>,
    /*1*/ <-2.93874,3.84881,0.22374>,<-2.93621,3.868,0.23045>,<-2.92306,3.85335,0.23611>,
            
    /*2*/ <-3.24287,3.74592,0.66422>

    /* stem 0.1.6.3*/ 
    /*0*/ <-3.09694,3.95669,0.28626>,
    /*1*/ <-3.09071,3.96546,0.28464>,<-3.10309,3.95597,0.29521>,<-3.09703,3.94865,0.27894>,
            
    /*2*/ <-3.47116,4.17864,0.04684>

    /* stem 0.1.6.4*/ 
    /*0*/ <-3.2219,4.07508,0.32619>,
    /*1*/ <-3.2254,4.06957,0.33381>,<-3.22827,4.07925,0.31966>,<-3.21201,4.07642,0.3251>,
            
    /*2*/ <-3.24388,4.44737,0.58523>

    /* stem 0.1.6.5*/ 
    /*0*/ <-3.40159,4.2636,0.35379>,
    /*1*/ <-3.4021,4.26408,0.34504>,<-3.40004,4.27083,0.35849>,<-3.40263,4.25588,0.35783>,
            
    /*2*/ <-3.78628,4.32902,0.37987>

    /* stem 0.1.6.6*/ 
    /*0*/ <-3.49529,4.38416,0.35817>,
    /*1*/ <-3.49129,4.38748,0.36429>,<-3.5033,4.38455,0.35793>,<-3.49128,4.38046,0.35229>,
            
    /*2*/ <-3.47523,4.68946,0.17948>

    /* stem 0.1.6.7*/ 
    /*0*/ <-3.57632,4.51132,0.35156>,
    /*1*/ <-3.58097,4.50898,0.35065>,<-3.57518,4.51593,0.34925>,<-3.57281,4.50903,0.35478>,
            
    /*2*/ <-3.7024,4.66648,0.59883>

    /* stem 0.1.6.8*/ 
    /*0*/ <-3.65993,4.66106,0.34782>,
    /*1*/ <-3.65849,4.66191,0.34686>,<-3.66102,4.66209,0.34904>,<-3.66028,4.65918,0.34758>,
            
    /*2*/ <-3.83386,4.72085,0.14112>

    /* stem 0.2*/ 
    /*0*/ <0.02468,4.73058,-0.00566>,
    /*1*/ <0.06516,4.73407,0.06445>,<0.04165,4.80833,0.0096>,<-0.00532,4.77514,-0.06634>,
            <-0.01084,4.68036,-0.05843>,<0.03272,4.65498,0.0224>,
    /*2*/ <0.45992,4.69149,-0.17029>,<0.43864,4.7587,-0.21992>,<0.39613,4.72866,-0.28865>,
            <0.39114,4.64288,-0.28149>,<0.43056,4.61991,-0.20834>,
    /*3*/ <0.85426,4.63646,-0.40275>,<0.8368,4.69642,-0.44807>,<0.79835,4.66959,-0.50936>,
            <0.79206,4.59304,-0.50192>,<0.82661,4.57256,-0.43603>,
    /*4*/ <1.25313,4.58262,-0.62467>,<1.23854,4.63546,-0.6651>,<1.20602,4.6116,-0.72>,
            <1.20053,4.54402,-0.7135>,<1.22964,4.52611,-0.65458>,
    /*5*/ <1.63583,4.59838,-0.89136>,<1.61394,4.64457,-0.92095>,<1.58364,4.6239,-0.96724>,
            <1.5868,4.56492,-0.96626>,<1.61906,4.54915,-0.91936>,
    /*6*/ <1.99282,4.65611,-1.18346>,<1.9695,4.69471,-1.20508>,<1.94227,4.67699,-1.2431>,
            <1.94876,4.62743,-1.24498>,<1.98,4.61453,-1.20812>,
    /*7*/ <2.33313,4.75196,-1.48153>,<2.31134,4.78298,-1.49705>,<2.28904,4.76844,-1.52819>,
            <2.29705,4.72844,-1.53191>,<2.3243,4.71826,-1.50307>,
    /*8*/ <2.68566,4.861,-1.75476>,<2.66901,4.88528,-1.76708>,<2.65322,4.87445,-1.79262>,
            <2.66012,4.84349,-1.79608>,<2.68017,4.83517,-1.77268>,
    /*9*/ <3.01494,4.99073,-2.05362>,<3.00159,5.00762,-2.06133>,<2.98937,4.99951,-2.07887>,
            <2.99516,4.97762,-2.082>,<3.01096,4.97219,-2.06639>,
    /*10*/ <3.35577,5.15203,-2.31654>,<3.34762,5.16221,-2.3211>,<3.34122,5.15776,-2.33251>,
            <3.34542,5.14483,-2.33499>,<3.35441,5.1413,-2.32512>,
    /*11*/ <3.67626,5.32999,-2.59756>,<3.67322,5.33338,-2.59896>,<3.67088,5.33177,-2.60278>,
            <3.67247,5.32739,-2.60374>,<3.6758,5.32629,-2.60052>,
    /*12*/ <3.67372,5.32976,-2.60071>

    /* stem 0.2c0*/ 
    /*0*/ <1.22557,4.57996,-0.67557>,
    /*1*/ <1.20668,4.58293,-0.62088>,<1.22084,4.63591,-0.66128>,<1.24154,4.61157,-0.72143>,
            <1.24018,4.54354,-0.71821>,<1.21863,4.52584,-0.65606>,
    /*2*/ <1.64507,4.58094,-0.47748>,<1.65735,4.62688,-0.51252>,<1.6753,4.60577,-0.56468>,
            <1.67411,4.54678,-0.56188>,<1.65543,4.53143,-0.50799>,
    /*3*/ <2.1027,4.5695,-0.38448>,<2.11036,4.60838,-0.415>,<2.11996,4.59049,-0.46071>,
            <2.11824,4.54055,-0.45844>,<2.10757,4.52758,-0.41133>,
    /*4*/ <2.55401,4.52114,-0.29875>,<2.56248,4.55283,-0.32329>,<2.56876,4.53827,-0.36106>,
            <2.56417,4.49759,-0.35987>,<2.55506,4.487,-0.32136>,
    /*5*/ <3.00877,4.49391,-0.22244>,<3.01383,4.51872,-0.24187>,<3.0186,4.50738,-0.27131>,
            <3.01649,4.47556,-0.27009>,<3.01041,4.46723,-0.23988>,
    /*6*/ <3.46642,4.51423,-0.16213>,<3.46775,4.53202,-0.17644>,<3.47125,4.52388,-0.19752>,
            <3.4721,4.50106,-0.19623>,<3.46911,4.4951,-0.17436>,
    /*7*/ <3.92404,4.5461,-0.11075>,<3.92441,4.55681,-0.11946>,<3.92641,4.55188,-0.13221>,
            <3.92727,4.53812,-0.13138>,<3.92581,4.53455,-0.11812>,
    /*8*/ <4.37956,4.56343,-0.04303>,<4.37991,4.56714,-0.046>,<4.3807,4.56545,-0.05038>,
            <4.38084,4.56069,-0.05012>,<4.38014,4.55945,-0.04558>,
    /*9*/ <4.38023,4.56323,-0.04702>

    /* stem 0.2c0c0*/ 
    /*0*/ <3.46933,4.51326,-0.18134>,
    /*1*/ <3.45622,4.51422,-0.167>,<3.46481,4.53197,-0.17857>,<3.47964,4.52386,-0.19396>,
            <3.48022,4.5011,-0.19191>,<3.46574,4.49514,-0.17524>,
    /*2*/ <3.80189,4.55043,0.13623>,<3.80708,4.56116,0.12924>,<3.81604,4.55626,0.11994>,
            <3.81639,4.5425,0.12118>,<3.80765,4.5389,0.13125>,
    /*3*/ <4.14721,4.61233,0.43573>,<4.14884,4.616,0.43317>,<4.15198,4.61432,0.43001>,
            <4.1523,4.60961,0.43062>,<4.14935,4.60838,0.43415>,
    /*4*/ <4.14993,4.61213,0.43273>

    /* stem 0.2c0c0.0*/ 
    /*0*/ <3.97596,4.58027,0.27664>,
    /*1*/ <3.97219,4.57549,0.28181>,<3.97676,4.58806,0.27824>,<3.97892,4.57726,0.26985>,
            
    /*2*/ <4.09067,4.55077,0.34405>,<4.09479,4.56208,0.34084>,<4.09673,4.55237,0.33328>,
            
    /*3*/ <4.19915,4.5693,0.42493>,<4.20082,4.5793,0.42049>,<4.20565,4.5704,0.41604>,
            
    /*4*/ <4.29911,4.64355,0.48468>,<4.29726,4.6509,0.47866>,<4.30377,4.64416,0.47621>,
            
    /*5*/ <4.38706,4.72566,0.54811>,<4.38529,4.73176,0.54276>,<4.39145,4.72645,0.5411>,
            
    /*6*/ <4.45675,4.83085,0.6007>,<4.45446,4.83495,0.59562>,<4.46036,4.83143,0.59482>,
            
    /*7*/ <4.50164,4.94472,0.65984>,<4.49969,4.94771,0.65561>,<4.50487,4.94575,0.65546>,
            
    /*8*/ <4.54125,5.05938,0.72139>,<4.53978,5.06162,0.71822>,<4.54371,5.06028,0.71818>,
            
    /*9*/ <4.56441,5.18312,0.77357>,<4.56335,5.18429,0.7713>,<4.56606,5.18373,0.77144>,
            
    /*10*/ <4.58731,5.30903,0.82008>,<4.58677,5.30956,0.81892>,<4.58813,5.30929,0.819>,
            
    /*11*/ <4.60919,5.43669,0.86196>

    /* stem 0.2c0c0.0.0*/ 
    /*0*/ <4.06129,4.56206,0.32198>,
    /*1*/ <4.06217,4.56529,0.32162>,<4.06357,4.55964,0.32151>,<4.05813,4.56126,0.32281>,
            
    /*2*/ <4.18806,4.58362,0.82663>

    /* stem 0.2c0c0.0.1*/ 
    /*0*/ <4.25909,4.61566,0.45509>,
    /*1*/ <4.26099,4.61335,0.45479>,<4.25918,4.61737,0.45756>,<4.2571,4.61626,0.45291>,
            
    /*2*/ <4.56485,4.89335,0.25257>

    /* stem 0.2c0c0.0.2*/ 
    /*0*/ <4.33598,4.67963,0.50607>,
    /*1*/ <4.33389,4.68052,0.50779>,<4.33794,4.68147,0.50514>,<4.3361,4.67689,0.50529>,
            
    /*2*/ <4.58231,4.59237,0.85137>

    /* stem 0.2c0c0.0.3*/ 
    /*0*/ <4.42318,4.78112,0.57099>,
    /*1*/ <4.42422,4.78163,0.56863>,<4.42473,4.78103,0.57313>,<4.42059,4.78069,0.57123>,
            
    /*2*/ <4.36489,5.16957,0.62923>

    /* stem 0.2c0c0.0.4*/ 
    /*0*/ <4.52282,5.00613,0.68969>,
    /*1*/ <4.52325,5.00496,0.69155>,<4.52164,5.00803,0.6898>,<4.52357,5.00539,0.68771>,
            
    /*2*/ <4.80299,5.17772,0.73191>

    /* stem 0.2c0c0.0.5*/ 
    /*0*/ <4.55264,5.11965,0.74465>,
    /*1*/ <4.55106,5.12038,0.74363>,<4.55433,5.12074,0.74479>,<4.55253,5.11784,0.74551>,
            
    /*2*/ <4.44968,5.24637,0.99638>

    /* stem 0.2c0c0.0.6*/ 
    /*0*/ <4.59953,5.3802,0.84306>,
    /*1*/ <4.59988,5.38016,0.84302>,<4.5994,5.38039,0.84333>,<4.5993,5.38006,0.84282>,
            
    /*2*/ <4.61116,5.57347,0.71481>

    /* stem 0.2c0.0*/ 
    /*0*/ <1.33588,4.57956,-0.63744>,
    /*1*/ <1.32732,4.53975,-0.61311>,<1.34318,4.62034,-0.61437>,<1.33713,4.57857,-0.68485>,
            
    /*2*/ <1.57762,4.49476,-0.60795>,<1.59189,4.5673,-0.60908>,<1.58644,4.5297,-0.6725>,
            
    /*3*/ <1.83877,4.54939,-0.59083>,<1.82591,4.61377,-0.59369>,<1.83693,4.57997,-0.64897>,
            
    /*4*/ <2.06559,4.67413,-0.55271>,<2.03931,4.72502,-0.55782>,<2.06137,4.69926,-0.60426>,
            
    /*5*/ <2.27711,4.82003,-0.52911>,<2.25022,4.86107,-0.53386>,<2.26958,4.83953,-0.57375>,
            
    /*6*/ <2.42803,5.03,-0.49221>,<2.39584,5.05479,-0.49823>,<2.41936,5.04359,-0.52999>,
            
    /*7*/ <2.51852,5.27368,-0.47704>,<2.48848,5.28564,-0.4829>,<2.50895,5.27964,-0.5079>,
            
    /*8*/ <2.59574,5.51523,-0.45454>,<2.57291,5.52336,-0.45902>,<2.5887,5.52005,-0.47766>,
            
    /*9*/ <2.66373,5.75905,-0.42733>,<2.64835,5.76396,-0.43039>,<2.65906,5.76235,-0.44274>,
            
    /*10*/ <2.70735,6.00766,-0.39207>,<2.69949,6.0094,-0.3937>,<2.70502,6.0093,-0.39978>,
            
    /*11*/ <2.78188,6.2508,-0.38975>

    /* stem 0.2c0.0.0*/ 
    /*0*/ <1.50153,4.54703,-0.6324>,
    /*1*/ <1.50525,4.56647,-0.62922>,<1.51263,4.53672,-0.64552>,<1.48672,4.53791,-0.62245>,
            
    /*2*/ <2.12572,4.31105,0.08083>

    /* stem 0.2c0.0.1*/ 
    /*0*/ <1.73321,4.56061,-0.61873>,
    /*1*/ <1.73677,4.54824,-0.63269>,<1.74406,4.56072,-0.60314>,<1.71879,4.57287,-0.62035>,
            
    /*2*/ <2.29644,5.17033,-1.01525>

    /* stem 0.2c0.0.2*/ 
    /*0*/ <1.99439,4.66685,-0.5825>,
    /*1*/ <1.99122,4.66696,-0.56508>,<1.998,4.68199,-0.59094>,<1.99396,4.65159,-0.59147>,
            
    /*2*/ <2.82406,4.5539,-0.43072>

    /* stem 0.2c0.0.3*/ 
    /*0*/ <2.18534,4.78645,-0.55551>,
    /*1*/ <2.18126,4.79507,-0.5692>,<2.20092,4.78083,-0.55353>,<2.17384,4.78344,-0.54381>,
            
    /*2*/ <2.38275,5.46439,-0.18711>

    /* stem 0.2c0.0.4*/ 
    /*0*/ <2.31348,4.90535,-0.53311>,
    /*1*/ <2.32515,4.89583,-0.52812>,<2.30911,4.91782,-0.52431>,<2.30618,4.90242,-0.54689>,
            
    /*2*/ <2.81753,5.33541,-0.89188>

    /* stem 0.2c0.0.5*/ 
    /*0*/ <2.37408,4.98788,-0.51732>,
    /*1*/ <2.36202,4.99567,-0.51174>,<2.38312,4.9943,-0.528>,<2.37709,4.97367,-0.51221>,
            
    /*2*/ <2.79623,5.26605,0.00737>

    /* stem 0.2c0.0.6*/ 
    /*0*/ <2.4761,5.20354,-0.49491>,
    /*1*/ <2.48314,5.20175,-0.50722>,<2.48311,5.20789,-0.48324>,<2.46206,5.20098,-0.49428>,
            
    /*2*/ <2.3523,5.84203,-0.65857>

    /* stem 0.2c0.0.7*/ 
    /*0*/ <2.53416,5.36566,-0.48013>,
    /*1*/ <2.53584,5.36368,-0.46688>,<2.52779,5.37669,-0.48455>,<2.53886,5.35659,-0.48895>,
            
    /*2*/ <3.08269,5.6729,-0.50384>

    /* stem 0.2c0.0.8*/ 
    /*0*/ <2.61934,5.63363,-0.44949>,
    /*1*/ <2.6109,5.63709,-0.45727>,<2.63045,5.63808,-0.45033>,<2.61668,5.62573,-0.44087>,
            
    /*2*/ <2.47671,6.05508,-0.10737>

    /* stem 0.2c0.0.9*/ 
    /*0*/ <2.68458,5.90676,-0.41101>,
    /*1*/ <2.69115,5.90548,-0.41082>,<2.68173,5.91039,-0.40614>,<2.68085,5.90441,-0.41605>,
            
    /*2*/ <2.77186,6.31876,-0.66759>

    /* stem 0.2c0.0.10*/ 
    /*0*/ <2.73776,6.11378,-0.39282>,
    /*1*/ <2.73577,6.11439,-0.39113>,<2.73827,6.11538,-0.39492>,<2.73925,6.11158,-0.39242>,
            
    /*2*/ <3.0185,6.34857,-0.14595>

    /* stem 0.2c0.1*/ 
    /*0*/ <2.32891,4.54413,-0.38097>,
    /*1*/ <2.33186,4.58245,-0.37548>,<2.35293,4.52613,-0.40559>,<2.30193,4.5238,-0.36183>,
            
    /*2*/ <2.46881,4.5454,-0.21787>,<2.48778,4.49472,-0.24497>,<2.44188,4.49261,-0.20558>,
            
    /*3*/ <2.5869,4.59135,-0.06511>,<2.61587,4.54686,-0.07377>,<2.57355,4.54536,-0.0406>,
            
    /*4*/ <2.67844,4.6992,0.07872>,<2.71168,4.66614,0.08294>,<2.67279,4.66393,0.10938>,
            
    /*5*/ <2.75092,4.85271,0.1924>,<2.78337,4.8308,0.20214>,<2.75033,4.82929,0.22524>,
            
    /*6*/ <2.84376,5.01553,0.28973>,<2.87049,4.99654,0.29715>,<2.84471,4.99841,0.31865>,
            
    /*7*/ <2.93602,5.19212,0.35403>,<2.95832,5.17857,0.36058>,<2.93887,5.18209,0.37882>,
            
    /*8*/ <3,5.38593,0.40089>,<3.01801,5.37892,0.40667>,<3.00306,5.38061,0.42011>,
            
    /*9*/ <3.03669,5.58386,0.4668>,<3.04898,5.58041,0.47101>,<3.03851,5.57955,0.47941>,
            
    /*10*/ <3.09753,5.77632,0.53387>,<3.10351,5.77389,0.53575>,<3.0984,5.77398,0.54011>,
            
    /*11*/ <3.16893,5.9652,0.59903>

    /* stem 0.2c0.1.0*/ 
    /*0*/ <2.40465,4.52579,-0.29369>,
    /*1*/ <2.41174,4.51368,-0.30238>,<2.40109,4.52351,-0.27773>,<2.40112,4.5402,-0.30095>,
            
    /*2*/ <3.14528,4.81127,-0.08777>

    /* stem 0.2c0.1.1*/ 
    /*0*/ <2.52306,4.53363,-0.14918>,
    /*1*/ <2.51045,4.53584,-0.14012>,<2.53551,4.54305,-0.14772>,<2.52321,4.522,-0.15969>,
            
    /*2*/ <2.82158,4.05676,0.38272>

    /* stem 0.2c0.1.2*/ 
    /*0*/ <2.63498,4.6129,0.00756>,
    /*1*/ <2.64303,4.61968,-0.00277>,<2.64157,4.60698,0.01935>,<2.62032,4.61205,0.0061>,
            
    /*2*/ <2.56304,5.23916,0.36264>

    /* stem 0.2c0.1.3*/ 
    /*0*/ <2.72163,4.75055,0.14381>,
    /*1*/ <2.72367,4.74196,0.15442>,<2.71642,4.76314,0.14603>,<2.72479,4.74656,0.13099>,
            
    /*2*/ <3.34312,4.99422,0.22131>

    /* stem 0.2c0.1.4*/ 
    /*0*/ <2.81139,4.92803,0.25852>,
    /*1*/ <2.80233,4.93572,0.25382>,<2.82354,4.93197,0.25892>,<2.8083,4.9164,0.26281>,
            
    /*2*/ <2.71715,5.16114,0.82176>

    /* stem 0.2c0.1.5*/ 
    /*0*/ <2.91271,5.12158,0.34276>,
    /*1*/ <2.92321,5.11729,0.33982>,<2.91132,5.12723,0.35294>,<2.90358,5.12023,0.33552>,
            
    /*2*/ <3.04026,5.60598,0.09142>

    /* stem 0.2c0.1.6*/ 
    /*0*/ <2.96393,5.24588,0.37843>,
    /*1*/ <2.957,5.24612,0.38708>,<2.96504,5.25483,0.37197>,<2.96976,5.2367,0.37625>,
            
    /*2*/ <3.35423,5.42026,0.6865>

    /* stem 0.2c0.1.7*/ 
    /*0*/ <3.01726,5.44123,0.42804>,
    /*1*/ <3.01763,5.44423,0.41837>,<3.02469,5.44381,0.43443>,<3.00946,5.43564,0.43132>,
            
    /*2*/ <2.78048,5.83891,0.54235>

    /* stem 0.2c0.1.8*/ 
    /*0*/ <3.06505,5.65961,0.49839>,
    /*1*/ <3.06869,5.65708,0.50271>,<3.0617,5.66464,0.49973>,<3.06476,5.65711,0.49273>,
            
    /*2*/ <3.3831,5.90466,0.37375>

    /* stem 0.2c0.1.9*/ 
    /*0*/ <3.13738,5.87827,0.57053>,
    /*1*/ <3.13575,5.87892,0.57035>,<3.13876,5.8791,0.56977>,<3.13765,5.87678,0.57146>,
            
    /*2*/ <3.18286,6.07496,0.87156>

    /* stem 0.2c0.2*/ 
    /*0*/ <2.83593,4.50308,-0.28199>,
    /*1*/ <2.83878,4.4826,-0.30395>,<2.84687,4.49731,-0.25447>,<2.82215,4.52933,-0.28754>,
            
    /*2*/ <3.00554,4.56174,-0.35199>,<3.01282,4.57499,-0.30746>,<2.99057,4.60381,-0.33723>,
            
    /*3*/ <3.14966,4.68329,-0.40158>,<3.155,4.69412,-0.36156>,<3.12848,4.71563,-0.38567>,
            
    /*4*/ <3.27502,4.82957,-0.43149>,<3.27653,4.83623,-0.39556>,<3.25165,4.85324,-0.41628>,
            
    /*5*/ <3.35828,5.00254,-0.45894>,<3.35911,5.00751,-0.428>,<3.33424,5.01677,-0.4447>,
            
    /*6*/ <3.46154,5.16058,-0.47971>,<3.46189,5.16419,-0.45384>,<3.44282,5.17474,-0.46825>,
            
    /*7*/ <3.55435,5.32791,-0.49333>,<3.55413,5.33004,-0.47254>,<3.53847,5.33779,-0.48401>,
            
    /*8*/ <3.61658,5.50953,-0.50166>,<3.61616,5.51061,-0.48603>,<3.60356,5.51453,-0.4945>,
            
    /*9*/ <3.66982,5.69286,-0.50845>,<3.66951,5.69348,-0.49802>,<3.661,5.69575,-0.50365>,
            
    /*10*/ <3.70776,5.8767,-0.53989>,<3.70778,5.87765,-0.53475>,<3.70335,5.8781,-0.53747>,
            
    /*11*/ <3.72554,6.05702,-0.59877>

    /* stem 0.2c0.2.0*/ 
    /*0*/ <2.94131,4.55172,-0.31368>,
    /*1*/ <2.94427,4.55333,-0.30136>,<2.9421,4.56156,-0.32178>,<2.93755,4.54026,-0.3179>,
            
    /*2*/ <3.63915,4.37619,-0.4584>

    /* stem 0.2c0.2.1*/ 
    /*0*/ <3.06666,4.63309,-0.35506>,
    /*1*/ <3.05951,4.63801,-0.36362>,<3.07777,4.62905,-0.35799>,<3.06269,4.63222,-0.34357>,
            
    /*2*/ <3.33199,5.26182,-0.21586>

    /* stem 0.2c0.2.2*/ 
    /*0*/ <3.22565,4.79124,-0.40369>,
    /*1*/ <3.23426,4.78397,-0.40271>,<3.22554,4.80075,-0.39757>,<3.21714,4.78899,-0.4108>,
            
    /*2*/ <3.53712,5.0969,-0.87342>

    /* stem 0.2c0.2.3*/ 
    /*0*/ <3.31355,4.93332,-0.43073>,
    /*1*/ <3.30638,4.93794,-0.42434>,<3.3152,4.93716,-0.44054>,<3.31906,4.92487,-0.42732>,
            
    /*2*/ <3.73954,5.29772,-0.21624>

    /* stem 0.2c0.2.4*/ 
    /*0*/ <3.39195,5.07116,-0.45311>,
    /*1*/ <3.39328,5.06884,-0.46279>,<3.39979,5.07398,-0.44751>,<3.38279,5.07065,-0.44904>,
            
    /*2*/ <3.29964,5.60696,-0.59419>

    /* stem 0.2c0.2.5*/ 
    /*0*/ <3.57979,5.41959,-0.48855>,
    /*1*/ <3.58359,5.4187,-0.48102>,<3.57577,5.42682,-0.49045>,<3.57999,5.41324,-0.49418>,
            
    /*2*/ <3.97401,5.59156,-0.66762>

    /* stem 0.2c0.2.6*/ 
    /*0*/ <3.63174,5.5771,-0.49741>,
    /*1*/ <3.62477,5.57903,-0.50041>,<3.63831,5.57956,-0.50087>,<3.63213,5.5727,-0.49094>,
            
    /*2*/ <3.626,5.9292,-0.25765>

    /* stem 0.2c0.2.7*/ 
    /*0*/ <3.68258,5.7674,-0.51697>,
    /*1*/ <3.68702,5.76618,-0.51844>,<3.6819,5.77152,-0.51455>,<3.67884,5.76451,-0.51792>,
            
    /*2*/ <3.6248,5.94971,-0.84346>

    /* stem 0.2c0.2.8*/ 
    /*0*/ <3.7141,5.95027,-0.56226>,
    /*1*/ <3.71325,5.95086,-0.5608>,<3.71382,5.95107,-0.56384>,<3.71523,5.94888,-0.56215>,
            
    /*2*/ <3.96546,6.15902,-0.50143>

    /* stem 0.2c0.3*/ 
    /*0*/ <3.29527,4.50535,-0.20723>,
    /*1*/ <3.29193,4.50647,-0.18512>,<3.30646,4.52167,-0.2177>,<3.28742,4.48791,-0.21887>,
            
    /*2*/ <3.43951,4.42241,-0.16083>,<3.45258,4.43609,-0.19016>,<3.43545,4.4057,-0.1912>,
            
    /*3*/ <3.60624,4.4337,-0.12787>,<3.61114,4.44729,-0.15532>,<3.61265,4.41641,-0.15282>,
            
    /*4*/ <3.75807,4.4973,-0.08573>,<3.76058,4.5085,-0.11032>,<3.76979,4.48336,-0.10586>,
            
    /*5*/ <3.89647,4.58765,-0.04217>,<3.89767,4.59665,-0.06359>,<3.90896,4.57693,-0.05862>,
            
    /*6*/ <4.01142,4.70701,-0.00014>,<4.01149,4.71368,-0.01835>,<4.02395,4.6998,-0.01306>,
            
    /*7*/ <4.11031,4.84644,0.02195>,<4.10888,4.85004,0.00693>,<4.12057,4.84101,0.01165>,
            
    /*8*/ <4.19375,4.99584,0.03575>,<4.19225,4.99788,0.02439>,<4.20174,4.99224,0.02809>,
            
    /*9*/ <4.28042,5.14405,0.01565>,<4.27866,5.14415,0.0081>,<4.28516,5.14068,0.01053>,
            
    /*10*/ <4.37269,5.28625,-0.01251>,<4.37173,5.28618,-0.01627>,<4.37493,5.28435,-0.01504>,
            
    /*11*/ <4.4617,5.42632,-0.05681>

    /* stem 0.2c0.3.0*/ 
    /*0*/ <3.36,4.46845,-0.19558>,
    /*1*/ <3.36412,4.47344,-0.20264>,<3.36139,4.45899,-0.19496>,<3.35449,4.47291,-0.18914>,
            
    /*2*/ <3.89541,4.5726,0.19026>

    /* stem 0.2c0.3.1*/ 
    /*0*/ <3.56155,4.42927,-0.15557>,
    /*1*/ <3.56166,4.42064,-0.15336>,<3.56476,4.43535,-0.14992>,<3.55825,4.4318,-0.16344>,
            
    /*2*/ <4.11972,4.37071,-0.40898>

    /* stem 0.2c0.3.2*/ 
    /*0*/ <3.83227,4.54196,-0.0776>,
    /*1*/ <3.82758,4.54795,-0.07534>,<3.83859,4.54337,-0.08219>,<3.83063,4.53455,-0.07527>,
            
    /*2*/ <4.13754,4.61379,0.36447>

    /* stem 0.2c0.3.3*/ 
    /*0*/ <3.9613,4.65006,-0.0315>,
    /*1*/ <3.96553,4.64814,-0.03724>,<3.96425,4.65056,-0.02475>,<3.95413,4.65149,-0.03251>,
            
    /*2*/ <4.06857,5.13134,-0.11359>

    /* stem 0.2c0.3.4*/ 
    /*0*/ <4.06062,4.77089,0.00056>,
    /*1*/ <4.06027,4.76996,0.00735>,<4.06053,4.77724,-0.00205>,<4.06105,4.76547,-0.00363>,
            
    /*2*/ <4.52095,4.78794,0.02653>

    /* stem 0.2c0.3.5*/ 
    /*0*/ <4.14557,4.90427,0.01972>,
    /*1*/ <4.14211,4.90669,0.01498>,<4.15189,4.90487,0.01967>,<4.14271,4.90124,0.02452>,
            
    /*2*/ <4.11238,5.26972,0.2303>

    /* stem 0.2c0.3.6*/ 
    /*0*/ <4.31818,5.20015,0.00099>,
    /*1*/ <4.3212,5.1983,0.00152>,<4.31784,5.20345,0.00232>,<4.31549,5.19869,-0.00088>,
            
    /*2*/ <4.4475,5.32903,-0.28622>

    /* stem 0.2c0.3.7*/ 
    /*0*/ <4.40868,5.3421,-0.03155>,
    /*1*/ <4.40781,5.34285,-0.03087>,<4.40916,5.34253,-0.03273>,<4.40908,5.34092,-0.03106>,
            
    /*2*/ <4.63524,5.47683,0.10986>

    /* stem 0.2c1*/ 
    /*0*/ <2.31097,4.75002,-1.50835>,
    /*1*/ <2.34417,4.75189,-1.49791>,<2.31593,4.78128,-1.49377>,<2.28084,4.76746,-1.50978>,
            <2.28739,4.72954,-1.52381>,<2.32653,4.71992,-1.51648>,
    /*2*/ <2.4562,4.92408,-1.91089>,<2.43421,4.94698,-1.90766>,<2.40687,4.93621,-1.92013>,
            <2.41197,4.90667,-1.93106>,<2.44247,4.89917,-1.92535>,
    /*3*/ <2.5744,5.10877,-2.31609>,<2.55857,5.12507,-2.31353>,<2.53914,5.11761,-2.32301>,
            <2.54297,5.09669,-2.33143>,<2.56476,5.09123,-2.32715>,
    /*4*/ <2.68044,5.30371,-2.72097>,<2.67075,5.31336,-2.71902>,<2.65897,5.30876,-2.72457>,
            <2.66137,5.29627,-2.72995>,<2.67464,5.29315,-2.72773>,
    /*5*/ <2.78394,5.50942,-3.12063>,<2.78057,5.5127,-3.11987>,<2.77652,5.51113,-3.12181>,
            <2.77738,5.50688,-3.12378>,<2.78196,5.50582,-3.12305>,
    /*6*/ <2.78007,5.50919,-3.12183>

    /* stem 0.2c1.0*/ 
    /*0*/ <2.51292,5.04439,-2.18407>,
    /*1*/ <2.53385,5.04541,-2.17708>,<2.50246,5.06281,-2.19034>,<2.50245,5.02496,-2.18478>,
            
    /*2*/ <2.58635,5.0218,-2.33791>,<2.55811,5.03746,-2.34984>,<2.55809,5.00339,-2.34485>,
            
    /*3*/ <2.60601,5.04377,-2.50998>,<2.57928,5.05862,-2.51131>,<2.58015,5.02829,-2.5153>,
            
    /*4*/ <2.62292,5.11545,-2.66405>,<2.59907,5.12735,-2.66147>,<2.60078,5.10304,-2.67259>,
            
    /*5*/ <2.61899,5.2378,-2.78525>,<2.59832,5.24464,-2.77799>,<2.60001,5.22859,-2.79432>,
            
    /*6*/ <2.61451,5.37394,-2.88818>,<2.5973,5.37878,-2.88139>,<2.59868,5.36731,-2.89663>,
            
    /*7*/ <2.60479,5.51477,-2.98492>,<2.59105,5.51806,-2.97905>,<2.59211,5.50947,-2.99167>,
            
    /*8*/ <2.58217,5.67392,-3.04426>,<2.57204,5.67461,-3.03891>,<2.57258,5.67068,-3.04967>,
            
    /*9*/ <2.56496,5.83754,-3.08935>,<2.55822,5.83791,-3.08575>,<2.55852,5.83591,-3.09313>,
            
    /*10*/ <2.5336,5.99287,-3.1542>,<2.53024,5.993,-3.15238>,<2.53045,5.99156,-3.15592>,
            
    /*11*/ <2.50808,6.15116,-3.21291>

    /* stem 0.2c1.0.0*/ 
    /*0*/ <2.55428,5.02658,-2.30537>,
    /*1*/ <2.54754,5.03216,-2.30848>,<2.55549,5.0182,-2.30917>,<2.5598,5.02939,-2.29845>,
            
    /*2*/ <2.96762,5.28318,-2.73972>

    /* stem 0.2c1.0.1*/ 
    /*0*/ <2.58225,5.03683,-2.46232>,
    /*1*/ <2.58401,5.02827,-2.46325>,<2.58793,5.04283,-2.46531>,<2.57482,5.03938,-2.45839>,
            
    /*2*/ <2.29555,5.03717,-3.00462>

    /* stem 0.2c1.0.2*/ 
    /*0*/ <2.60645,5.19169,-2.74124>,
    /*1*/ <2.60982,5.19662,-2.73629>,<2.59977,5.19362,-2.74469>,<2.60976,5.18483,-2.74275>,
            
    /*2*/ <2.87859,5.41175,-3.14526>

    /* stem 0.2c1.0.3*/ 
    /*0*/ <2.60456,5.30979,-2.84078>,
    /*1*/ <2.59792,5.30793,-2.8431>,<2.60944,5.31244,-2.84547>,<2.60631,5.30901,-2.83376>,
            
    /*2*/ <2.44297,5.77113,-2.74891>

    /* stem 0.2c1.0.4*/ 
    /*0*/ <2.60033,5.43259,-2.92934>,
    /*1*/ <2.60686,5.43176,-2.93105>,<2.59798,5.43877,-2.92777>,<2.59615,5.42723,-2.9292>,
            
    /*2*/ <2.49356,5.50444,-3.37203>

    /* stem 0.2c1.0.5*/ 
    /*0*/ <2.58193,5.62363,-3.02591>,
    /*1*/ <2.57866,5.62505,-3.02096>,<2.57975,5.62486,-3.03147>,<2.5874,5.62099,-3.0253>,
            
    /*2*/ <2.7588,5.99227,-3.01442>

    /* stem 0.2c1.0.6*/ 
    /*0*/ <2.54105,5.9412,-3.13279>,
    /*1*/ <2.5407,5.94002,-3.13546>,<2.54253,5.94372,-3.13248>,<2.53991,5.93986,-3.13044>,
            
    /*2*/ <2.26231,6.10944,-3.17107>

    /* stem 0.2c1.0.7*/ 
    /*0*/ <2.52448,6.03969,-3.17165>,
    /*1*/ <2.52561,6.04021,-3.17071>,<2.52321,6.04056,-3.17188>,<2.52462,6.03832,-3.17235>,
            
    /*2*/ <2.65833,6.17423,-3.40669>

    /* stem 0.2c2*/ 
    /*0*/ <3.0024,4.98953,-2.06844>,
    /*1*/ <3.02114,4.99134,-2.06354>,<3.00525,5.00772,-2.06216>,<2.98543,4.99897,-2.06947>,
            <2.98907,4.97718,-2.07535>,<3.01114,4.97246,-2.07168>,
    /*2*/ <3.11356,5.12346,-2.49568>,<3.10396,5.13336,-2.49485>,<3.09199,5.12807,-2.49927>,
            <3.09419,5.1149,-2.50282>,<3.10752,5.11206,-2.50061>,
    /*3*/ <3.23103,5.20662,-2.93341>,<3.22785,5.21017,-2.93364>,<3.22372,5.20835,-2.93517>,
            <3.22435,5.20368,-2.93589>,<3.22886,5.20262,-2.9348>,
    /*4*/ <3.22716,5.20629,-2.93458>

    /* stem 0.2c2.0*/ 
    /*0*/ <3.13979,5.14759,-2.62967>,
    /*1*/ <3.1321,5.15294,-2.63085>,<3.1406,5.13941,-2.6343>,<3.14667,5.15043,-2.62387>,
            
    /*2*/ <3.19505,5.21854,-2.73686>,<3.2027,5.20636,-2.73996>,<3.20816,5.21629,-2.73058>,
            
    /*3*/ <3.23399,5.29358,-2.84607>,<3.24125,5.28361,-2.85041>,<3.2465,5.29253,-2.84242>,
            
    /*4*/ <3.2656,5.38173,-2.94872>,<3.27226,5.37379,-2.95357>,<3.27669,5.38109,-2.94595>,
            
    /*5*/ <3.29857,5.48492,-3.03634>,<3.30456,5.47891,-3.04126>,<3.308,5.4842,-3.03374>,
            
    /*6*/ <3.3085,5.59088,-3.12541>,<3.31356,5.58651,-3.13011>,<3.31657,5.59123,-3.12416>,
            
    /*7*/ <3.31075,5.70014,-3.21189>,<3.31479,5.69693,-3.2159>,<3.31722,5.70066,-3.21112>,
            
    /*8*/ <3.33663,5.82276,-3.27425>,<3.33971,5.82056,-3.27736>,<3.34138,5.82236,-3.27312>,
            
    /*9*/ <3.35826,5.94765,-3.33263>,<3.36033,5.94631,-3.33477>,<3.36144,5.94745,-3.33191>,
            
    /*10*/ <3.38335,6.07926,-3.37187>,<3.38441,6.07873,-3.373>,<3.38493,6.07909,-3.37149>,
            
    /*11*/ <3.4277,6.20622,-3.41002>

    /* stem 0.2c2.0.0*/ 
    /*0*/ <3.17448,5.18449,-2.68888>,
    /*1*/ <3.17603,5.18101,-2.69014>,<3.17668,5.18784,-2.68905>,<3.17074,5.18462,-2.68744>,
            
    /*2*/ <2.98675,5.2814,-3.18575>

    /* stem 0.2c2.0.1*/ 
    /*0*/ <3.2555,5.33281,-2.89603>,
    /*1*/ <3.25631,5.33533,-2.89362>,<3.25354,5.33365,-2.8989>,<3.25666,5.32946,-2.89557>,
            
    /*2*/ <3.65205,5.43675,-3.13681>

    /* stem 0.2c2.0.2*/ 
    /*0*/ <3.29178,5.4442,-3.0046>,
    /*1*/ <3.28927,5.44331,-3.00658>,<3.29482,5.44462,-3.00587>,<3.29125,5.44467,-3.00136>,
            
    /*2*/ <3.20208,5.86517,-3.08003>

    /* stem 0.2c2.0.3*/ 
    /*0*/ <3.309,5.54432,-3.08871>,
    /*1*/ <3.31209,5.54411,-3.08865>,<3.30763,5.54709,-3.08844>,<3.30728,5.54177,-3.08903>,
            
    /*2*/ <3.31988,5.58836,-3.49138>

    /* stem 0.2c2.0.4*/ 
    /*0*/ <3.32366,5.74543,-3.2363>,
    /*1*/ <3.32165,5.74654,-3.23491>,<3.32396,5.74598,-3.2389>,<3.32538,5.74377,-3.23507>,
            
    /*2*/ <3.5257,6.0135,-3.15708>

    /* stem 0.2c2.0.5*/ 
    /*0*/ <3.35153,5.89601,-3.30935>,
    /*1*/ <3.35192,5.89501,-3.31135>,<3.35302,5.8975,-3.30851>,<3.34965,5.89551,-3.30818>,
            
    /*2*/ <3.20425,6.12181,-3.45019>

    /* stem 0.2c2.0.6*/ 
    /*0*/ <3.41153,6.15891,-3.39592>,
    /*1*/ <3.41169,6.15895,-3.39561>,<3.41135,6.15918,-3.39606>,<3.41155,6.1586,-3.39609>,
            
    /*2*/ <3.60679,6.23412,-3.5049>

    /* stem 0.2.0*/ 
    /*0*/ <0.32145,4.69912,-0.17547>,
    /*1*/ <0.30233,4.73268,-0.2151>,<0.33192,4.64599,-0.18688>,<0.3301,4.71869,-0.12443>,
            
    /*2*/ <0.58747,4.80138,-0.28676>,<0.6141,4.72336,-0.26136>,<0.61246,4.78879,-0.20516>,
            
    /*3*/ <0.82143,4.95188,-0.36708>,<0.86627,4.89155,-0.35192>,<0.85216,4.94352,-0.29733>,
            
    /*4*/ <1.04904,5.11746,-0.46578>,<1.09191,5.0671,-0.45447>,<1.0799,5.11237,-0.40642>,
            
    /*5*/ <1.25094,5.29797,-0.58778>,<1.29187,5.25814,-0.581>,<1.28234,5.29691,-0.53961>,
            
    /*6*/ <1.42258,5.50729,-0.71236>,<1.4608,5.47848,-0.70983>,<1.45081,5.50828,-0.67364>,
            
    /*7*/ <1.58666,5.70338,-0.86979>,<1.61714,5.68019,-0.86804>,<1.61161,5.70666,-0.84086>,
            
    /*8*/ <1.76858,5.92189,-0.97788>,<1.79138,5.90445,-0.97608>,<1.78434,5.92125,-0.95383>,
            
    /*9*/ <1.90905,6.17716,-1.05102>,<1.92601,6.16823,-1.05086>,<1.91937,6.17647,-1.03488>,
            
    /*10*/ <2.04174,6.43878,-1.12141>,<2.05036,6.43458,-1.12141>,<2.04693,6.43849,-1.11336>,
            
    /*11*/ <2.14088,6.69857,-1.2367>

    /* stem 0.2.0.0*/ 
    /*0*/ <0.45193,4.73232,-0.21031>,
    /*1*/ <0.45848,4.7098,-0.20724>,<0.46589,4.74984,-0.2027>,<0.43143,4.73732,-0.22099>,
            
    /*2*/ <0.99744,4.74919,-1.24987>

    /* stem 0.2.0.1*/ 
    /*0*/ <0.66722,4.81197,-0.27376>,
    /*1*/ <0.66089,4.82909,-0.26042>,<0.67102,4.81559,-0.29574>,<0.66974,4.79124,-0.26511>,
            
    /*2*/ <1.73825,5.03498,-0.05168>

    /* stem 0.2.0.2*/ 
    /*0*/ <0.7864,4.88971,-0.31695>,
    /*1*/ <0.78366,4.8825,-0.33751>,<0.80664,4.89225,-0.30882>,<0.76892,4.89437,-0.30453>,
            
    /*2*/ <0.80291,5.90862,-0.67651>

    /* stem 0.2.0.3*/ 
    /*0*/ <0.99838,5.04263,-0.40793>,
    /*1*/ <1.00947,5.03812,-0.39101>,<0.99817,5.062,-0.41533>,<0.98749,5.02777,-0.41746>,
            
    /*2*/ <1.80037,4.82854,-0.9906>

    /* stem 0.2.0.4*/ 
    /*0*/ <1.16966,5.18735,-0.50289>,
    /*1*/ <1.15513,5.19946,-0.50824>,<1.18386,5.18279,-0.51568>,<1.16997,5.1798,-0.48474>,
            
    /*2*/ <1.68195,5.93525,-0.20059>

    /* stem 0.2.0.5*/ 
    /*0*/ <1.3283,5.35139,-0.60999>,
    /*1*/ <1.33906,5.33831,-0.61751>,<1.33587,5.36701,-0.60349>,<1.30997,5.34886,-0.60898>,
            
    /*2*/ <1.23121,5.73301,-1.41367>

    /* stem 0.2.0.6*/ 
    /*0*/ <1.3842,5.42179,-0.65254>,
    /*1*/ <1.38301,5.43181,-0.63754>,<1.38339,5.4297,-0.66878>,<1.38621,5.40386,-0.65131>,
            
    /*2*/ <2.24985,5.51888,-0.64837>

    /* stem 0.2.0.7*/ 
    /*0*/ <1.50571,5.57357,-0.7598>,
    /*1*/ <1.49637,5.56991,-0.77363>,<1.52273,5.57445,-0.76098>,<1.49803,5.57635,-0.7448>,
            
    /*2*/ <1.4524,6.37056,-0.9347>

    /* stem 0.2.0.8*/ 
    /*0*/ <1.73046,5.8525,-0.93754>,
    /*1*/ <1.74227,5.84696,-0.92963>,<1.72874,5.86758,-0.93914>,<1.72036,5.84297,-0.94386>,
            
    /*2*/ <2.12568,5.83344,-1.54062>

    /* stem 0.2.0.9*/ 
    /*0*/ <1.87891,6.09988,-1.02368>,
    /*1*/ <1.86813,6.10619,-1.02166>,<1.88562,6.10203,-1.0342>,<1.88299,6.09143,-1.01519>,
            
    /*2*/ <2.20945,6.56664,-0.71761>

    /* stem 0.2.0.10*/ 
    /*0*/ <1.9595,6.2589,-1.06918>,
    /*1*/ <1.96411,6.25474,-1.07608>,<1.96409,6.26409,-1.063>,<1.9503,6.25787,-1.06846>,
            
    /*2*/ <1.87758,6.74597,-1.41775>

    /* stem 0.2.0.11*/ 
    /*0*/ <2.00604,6.35448,-1.09573>,
    /*1*/ <2.00681,6.35607,-1.08867>,<2.00353,6.35952,-1.10034>,<2.00777,6.34786,-1.09818>,
            
    /*2*/ <2.54703,6.53294,-1.19488>

    /* stem 0.2.0.12*/ 
    /*0*/ <2.10631,6.60301,-1.19355>,
    /*1*/ <2.10482,6.60292,-1.19493>,<2.10812,6.60374,-1.19406>,<2.10597,6.60236,-1.19166>,
            
    /*2*/ <1.95451,7.07052,-1.05949>

    /* stem 0.2.1*/ 
    /*0*/ <0.39483,4.69134,-0.21746>,
    /*1*/ <0.39646,4.6381,-0.20476>,<0.43472,4.72479,-0.20043>,<0.35332,4.71114,-0.2472>,
            
    /*2*/ <0.54928,4.58839,-0.45623>,<0.58371,4.66641,-0.45234>,<0.51046,4.65413,-0.49442>,
            
    /*3*/ <0.71537,4.64102,-0.71837>,<0.73267,4.71077,-0.69402>,<0.67037,4.69956,-0.73587>,
            
    /*4*/ <0.87519,4.8095,-0.93084>,<0.87575,4.86158,-0.88964>,<0.82609,4.85415,-0.93309>,
            
    /*5*/ <0.98581,4.98152,-1.1513>,<0.98771,5.02646,-1.11642>,<0.94114,5.0166,-1.14761>,
            
    /*6*/ <1.05161,5.18768,-1.36462>,<1.05232,5.22214,-1.33205>,<1.01195,5.21169,-1.35464>,
            
    /*7*/ <1.12403,5.40818,-1.55492>,<1.12372,5.43349,-1.52665>,<1.09206,5.42678,-1.54646>,
            
    /*8*/ <1.22563,5.63988,-1.71461>,<1.22434,5.65679,-1.69176>,<1.20191,5.65462,-1.70914>,
            
    /*9*/ <1.33724,5.8781,-1.85661>,<1.33592,5.88851,-1.84081>,<1.32145,5.88799,-1.85306>,
            
    /*10*/ <1.46659,6.13636,-1.93719>,<1.46505,6.13999,-1.92856>,<1.45857,6.1411,-1.9354>,
            
    /*11*/ <1.55593,6.41368,-2.00516>

    /* stem 0.2.1.0*/ 
    /*0*/ <0.48219,4.65992,-0.36034>,
    /*1*/ <0.4945,4.6794,-0.3571>,<0.47321,4.65518,-0.38127>,<0.47888,4.64518,-0.34265>,
            
    /*2*/ <1.44696,4.09831,-0.64737>

    /* stem 0.2.1.1*/ 
    /*0*/ <0.6027,4.65277,-0.55379>,
    /*1*/ <0.58552,4.64576,-0.56607>,<0.6235,4.64756,-0.55974>,<0.59908,4.66499,-0.53554>,
            
    /*2*/ <0.65967,5.56816,-1.15581>

    /* stem 0.2.1.2*/ 
    /*0*/ <0.66739,4.67217,-0.65529>,
    /*1*/ <0.68512,4.66435,-0.64548>,<0.66798,4.69165,-0.66488>,<0.64907,4.6605,-0.65551>,
            
    /*2*/ <0.97079,4.21273,-1.57024>

    /* stem 0.2.1.3*/ 
    /*0*/ <0.76176,4.74126,-0.7895>,
    /*1*/ <0.74811,4.75699,-0.78753>,<0.76954,4.73646,-0.80832>,<0.76763,4.73032,-0.77266>,
            
    /*2*/ <1.53615,5.39376,-0.63569>

    /* stem 0.2.1.4*/ 
    /*0*/ <0.94181,4.9642,-1.08014>,
    /*1*/ <0.94425,4.9485,-1.09075>,<0.9552,4.97783,-1.08003>,<0.92598,4.96628,-1.06965>,
            
    /*2*/ <0.52342,5.38086,-1.79348>

    /* stem 0.2.1.5*/ 
    /*0*/ <0.98064,5.03516,-1.16718>,
    /*1*/ <0.98993,5.04532,-1.1547>,<0.96895,5.04341,-1.17902>,<0.98305,5.01676,-1.16781>,
            
    /*2*/ <1.65098,5.1427,-1.75401>

    /* stem 0.2.1.6*/ 
    /*0*/ <1.01441,5.13534,-1.2739>,
    /*1*/ <0.99793,5.13367,-1.28069>,<1.02846,5.13713,-1.28485>,<1.01685,5.13522,-1.25617>,
            
    /*2*/ <0.91992,5.99126,-1.25543>

    /* stem 0.2.1.7*/ 
    /*0*/ <1.07999,5.32666,-1.45695>,
    /*1*/ <1.0952,5.32002,-1.4585>,<1.07827,5.34301,-1.45419>,<1.06649,5.31695,-1.45817>,
            
    /*2*/ <1.0573,5.45679,-2.24171>

    /* stem 0.2.1.8*/ 
    /*0*/ <1.18818,5.58672,-1.65969>,
    /*1*/ <1.18052,5.59641,-1.65102>,<1.18732,5.58774,-1.67472>,<1.19669,5.57601,-1.65333>,
            
    /*2*/ <1.74622,6.02938,-1.66153>

    /* stem 0.2.1.9*/ 
    /*0*/ <1.26846,5.75543,-1.77011>,
    /*1*/ <1.26718,5.74857,-1.78222>,<1.2807,5.76119,-1.7666>,<1.2575,5.75653,-1.76151>,
            
    /*2*/ <1.09015,6.31624,-2.06933>

    /* stem 0.2.1.10*/ 
    /*0*/ <1.37731,5.97314,-1.87917>,
    /*1*/ <1.38249,5.9729,-1.87175>,<1.37375,5.98099,-1.88195>,<1.3757,5.96554,-1.88381>,
            
    /*2*/ <1.86049,6.07419,-2.21275>

    /* stem 0.2.1.11*/ 
    /*0*/ <1.41664,6.04897,-1.90408>,
    /*1*/ <1.41009,6.05161,-1.90636>,<1.42248,6.04907,-1.90866>,<1.41734,6.04622,-1.89723>,
            
    /*2*/ <1.55963,6.57025,-1.70972>

    /* stem 0.2.1.12*/ 
    /*0*/ <1.50896,6.27432,-1.96889>,
    /*1*/ <1.51129,6.27326,-1.96998>,<1.50907,6.27667,-1.96741>,<1.50653,6.27304,-1.9693>,
            
    /*2*/ <1.43584,6.54887,-2.39695>

    /* stem 0.2.2*/ 
    /*0*/ <0.6133,4.66223,-0.3415>,
    /*1*/ <0.63024,4.70895,-0.32295>,<0.61628,4.65164,-0.39339>,<0.59339,4.6261,-0.30815>,
            
    /*2*/ <0.89186,4.59388,-0.28718>,<0.87929,4.54231,-0.35058>,<0.85869,4.51931,-0.27387>,
            
    /*3*/ <1.16443,4.59524,-0.30759>,<1.16115,4.54986,-0.36532>,<1.16615,4.52248,-0.29729>,
            
    /*4*/ <1.41178,4.69786,-0.27135>,<1.43422,4.66184,-0.31967>,<1.43472,4.63894,-0.25958>,
            
    /*5*/ <1.61615,4.88262,-0.24741>,<1.64434,4.85767,-0.28768>,<1.65182,4.84238,-0.23525>,
            
    /*6*/ <1.79059,5.10326,-0.21885>,<1.81802,5.08673,-0.25179>,<1.82532,5.07525,-0.20791>,
            
    /*7*/ <1.93731,5.33781,-0.15332>,<1.96282,5.32956,-0.17845>,<1.96651,5.3176,-0.14389>,
            
    /*8*/ <2.0511,5.58535,-0.06915>,<2.07193,5.58232,-0.08694>,<2.0742,5.57255,-0.06127>,
            
    /*9*/ <2.17844,5.83688,-0.00614>,<2.19171,5.83357,-0.01842>,<2.19377,5.82816,-0.00097>,
            
    /*10*/ <2.31281,6.08913,0.03288>,<2.31914,6.08689,0.02661>,<2.32049,6.0848,0.03546>,
            
    /*11*/ <2.42609,6.35361,0.03654>

    /* stem 0.2.2.0*/ 
    /*0*/ <0.75613,4.60235,-0.32109>,
    /*1*/ <0.75423,4.59115,-0.3406>,<0.76708,4.59297,-0.30372>,<0.74709,4.62292,-0.31895>,
            
    /*2*/ <1.7093,5.05805,-0.67579>

    /* stem 0.2.2.1*/ 
    /*0*/ <0.99753,4.55353,-0.31209>,
    /*1*/ <0.99901,4.54911,-0.29114>,<1.00843,4.57005,-0.32038>,<0.98514,4.54142,-0.32476>,
            
    /*2*/ <1.81557,3.91767,-0.50408>

    /* stem 0.2.2.2*/ 
    /*0*/ <1.25175,4.59272,-0.31008>,
    /*1*/ <1.24748,4.60763,-0.32318>,<1.26825,4.58121,-0.31283>,<1.23953,4.58932,-0.29424>,
            
    /*2*/ <1.78398,5.22496,0.23612>

    /* stem 0.2.2.3*/ 
    /*0*/ <1.37146,4.64295,-0.29194>,
    /*1*/ <1.37906,4.62475,-0.29172>,<1.37652,4.65592,-0.27797>,<1.3588,4.64817,-0.30613>,
            
    /*2*/ <2.10354,4.94215,-0.83464>

    /* stem 0.2.2.4*/ 
    /*0*/ <1.5832,4.81074,-0.26367>,
    /*1*/ <1.57244,4.82085,-0.25254>,<1.59076,4.81842,-0.27871>,<1.58641,4.79294,-0.25978>,
            
    /*2*/ <2.29938,5.04486,0.21614>

    /* stem 0.2.2.5*/ 
    /*0*/ <1.69645,4.93811,-0.2464>,
    /*1*/ <1.70093,4.93698,-0.26351>,<1.70906,4.93908,-0.23398>,<1.67936,4.93827,-0.24171>,
            
    /*2*/ <1.68833,5.78811,-0.30439>

    /* stem 0.2.2.6*/ 
    /*0*/ <1.88416,5.20958,-0.19203>,
    /*1*/ <1.88818,5.20313,-0.17771>,<1.87723,5.22423,-0.19266>,<1.88706,5.20139,-0.20571>,
            
    /*2*/ <2.58098,5.53707,-0.24025>

    /* stem 0.2.2.7*/ 
    /*0*/ <2.0376,5.51578,-0.09444>,
    /*1*/ <2.02655,5.5228,-0.10085>,<2.05126,5.52057,-0.09616>,<2.03498,5.50396,-0.08631>,
            
    /*2*/ <1.96818,5.91277,0.46042>

    /* stem 0.2.2.8*/ 
    /*0*/ <2.11055,5.67275,-0.04901>,
    /*1*/ <2.12291,5.66755,-0.05208>,<2.10895,5.68049,-0.03775>,<2.0998,5.67021,-0.0572>,
            
    /*2*/ <2.24705,6.1993,-0.39149>

    /* stem 0.2.2.9*/ 
    /*0*/ <2.17054,5.79682,-0.01763>,
    /*1*/ <2.16354,5.79797,-0.00875>,<2.17185,5.8054,-0.02497>,<2.17623,5.78711,-0.01916>,
            
    /*2*/ <2.63045,6.0134,0.31748>

    /* stem 0.2.2.10*/ 
    /*0*/ <2.28086,6.01511,0.02029>,
    /*1*/ <2.28092,6.01614,0.01357>,<2.28642,6.01643,0.02399>,<2.27525,6.01275,0.02333>,
            
    /*2*/ <2.10666,6.53035,0.09812>

    /* stem 0.2.2.11*/ 
    /*0*/ <2.36656,6.20745,0.03386>,
    /*1*/ <2.36839,6.20667,0.03597>,<2.36499,6.20988,0.03412>,<2.3663,6.20581,0.03148>,
            
    /*2*/ <2.73135,6.46697,-0.18578>

    /* stem 0.2.3*/ 
    /*0*/ <0.89032,4.62449,-0.49635>,
    /*1*/ <0.86618,4.60504,-0.53668>,<0.92459,4.59649,-0.47128>,<0.88019,4.67194,-0.4811>,
            
    /*2*/ <1.06693,4.70227,-0.69734>,<1.1195,4.69457,-0.63849>,<1.07954,4.76248,-0.64732>,
            
    /*3*/ <1.27757,4.83442,-0.82946>,<1.31949,4.82597,-0.77344>,<1.27943,4.88368,-0.7791>,
            
    /*4*/ <1.44252,4.99821,-0.97189>,<1.4855,4.99474,-0.9278>,<1.44302,5.0394,-0.926>,
            
    /*5*/ <1.58028,5.16106,-1.13861>,<1.62136,5.1616,-1.10535>,<1.58346,5.1982,-1.10114>,
            
    /*6*/ <1.73393,5.31884,-1.30426>,<1.76706,5.3183,-1.27523>,<1.73656,5.35002,-1.27326>,
            
    /*7*/ <1.84214,5.54145,-1.43112>,<1.86923,5.54182,-1.40859>,<1.84,5.56011,-1.4013>,
            
    /*8*/ <1.94836,5.77507,-1.53424>,<1.96814,5.7743,-1.51673>,<1.94576,5.78706,-1.51083>,
            
    /*9*/ <2.02194,6.03621,-1.58978>,<2.03497,6.03534,-1.57797>,<2.01898,6.04088,-1.57306>,
            
    /*10*/ <2.0918,6.2978,-1.63836>,<2.0983,6.29731,-1.63243>,<2.09027,6.29992,-1.62995>,
            
    /*11*/ <2.18544,6.55513,-1.66738>

    /* stem 0.2.3.0*/ 
    /*0*/ <1.03192,4.69252,-0.61394>,
    /*1*/ <1.04666,4.687,-0.59938>,<1.0324,4.71203,-0.62281>,<1.01671,4.67853,-0.61962>,
            
    /*2*/ <1.65322,4.32844,-1.38123>

    /* stem 0.2.3.1*/ 
    /*0*/ <1.23047,4.80914,-0.75369>,
    /*1*/ <1.21788,4.82429,-0.75836>,<1.24128,4.80013,-0.76824>,<1.23225,4.80301,-0.73448>,
            
    /*2*/ <1.96058,5.45914,-0.61401>

    /* stem 0.2.3.2*/ 
    /*0*/ <1.32099,4.87649,-0.81987>,
    /*1*/ <1.32872,4.86068,-0.82864>,<1.33235,4.89202,-0.81582>,<1.30191,4.87676,-0.81513>,
            
    /*2*/ <1.1142,5.25036,-1.67499>

    /* stem 0.2.3.3*/ 
    /*0*/ <1.3959,4.95044,-0.88707>,
    /*1*/ <1.3987,4.96151,-0.87175>,<1.392,4.95837,-0.904>,<1.39699,4.93144,-0.88544>,
            
    /*2*/ <2.30108,4.98613,-1.07877>

    /* stem 0.2.3.4*/ 
    /*0*/ <1.52003,5.08513,-1.02094>,
    /*1*/ <1.50738,5.08241,-1.03358>,<1.5374,5.08667,-1.02573>,<1.5153,5.0863,-1.00352>,
            
    /*2*/ <1.42018,5.94658,-1.10599>

    /* stem 0.2.3.5*/ 
    /*0*/ <1.66747,5.24828,-1.19631>,
    /*1*/ <1.6815,5.24117,-1.19034>,<1.66746,5.26454,-1.2006>,<1.65346,5.23913,-1.19799>,
            
    /*2*/ <1.88576,5.05117,-1.94442>

    /* stem 0.2.3.6*/ 
    /*0*/ <1.814,5.47157,-1.36857>,
    /*1*/ <1.80255,5.48025,-1.36315>,<1.81881,5.47336,-1.38304>,<1.82064,5.46109,-1.35951>,
            
    /*2*/ <2.29549,5.96852,-1.14687>

    /* stem 0.2.3.7*/ 
    /*0*/ <1.92621,5.71668,-1.49184>,
    /*1*/ <1.92981,5.7097,-1.50343>,<1.93478,5.72644,-1.48661>,<1.91406,5.7139,-1.48548>,
            
    /*2*/ <1.63023,6.1726,-1.85798>

    /* stem 0.2.3.8*/ 
    /*0*/ <1.97024,5.83749,-1.53414>,
    /*1*/ <1.97466,5.83916,-1.52163>,<1.96243,5.84677,-1.53976>,<1.97363,5.82654,-1.54102>,
            
    /*2*/ <2.47498,6.13025,-1.75152>

    /* stem 0.2.3.9*/ 
    /*0*/ <2.00736,5.9723,-1.56523>,
    /*1*/ <1.99777,5.97352,-1.57139>,<2.01729,5.97635,-1.56924>,<2.007,5.96704,-1.55507>,
            
    /*2*/ <1.90353,6.48789,-1.30164>

    /* stem 0.2.3.10*/ 
    /*0*/ <2.07574,6.23052,-1.61972>,
    /*1*/ <2.08186,6.22877,-1.62046>,<2.07425,6.23541,-1.61584>,<2.07111,6.22739,-1.62286>,
            
    /*2*/ <2.12253,6.56301,-2.02053>

    /* stem 0.2.3.11*/ 
    /*0*/ <2.11809,6.3671,-1.64263>,
    /*1*/ <2.11575,6.36829,-1.63998>,<2.11871,6.36921,-1.64564>,<2.1198,6.36381,-1.64227>,
            
    /*2*/ <2.48951,6.58496,-1.41289>

    /* stem 0.2.4*/ 
    /*0*/ <1.1429,4.59094,-0.63137>,
    /*1*/ <1.1634,4.57646,-0.58943>,<1.15771,4.63229,-0.65282>,<1.10758,4.56407,-0.65187>,
            
    /*2*/ <1.34231,4.44304,-0.72863>,<1.3372,4.49329,-0.78568>,<1.29208,4.43189,-0.78483>,
            
    /*3*/ <1.55478,4.39462,-0.88297>,<1.53725,4.44509,-0.92461>,<1.51471,4.38227,-0.93616>,
            
    /*4*/ <1.773,4.43507,-1.02947>,<1.74634,4.47926,-1.05861>,<1.74284,4.4238,-1.07923>,
            
    /*5*/ <1.9474,4.58429,-1.1721>,<1.90989,4.61548,-1.18627>,<1.92154,4.57513,-1.21486>,
            
    /*6*/ <2.12237,4.75773,-1.25208>,<2.09165,4.78391,-1.26486>,<2.10756,4.75527,-1.29167>,
            
    /*7*/ <2.24544,4.98144,-1.3317>,<2.21565,4.9957,-1.33921>,<2.23245,4.97814,-1.36281>,
            
    /*8*/ <2.37284,5.20604,-1.36683>,<2.35118,5.21786,-1.37285>,<2.36521,5.20703,-1.39104>,
            
    /*9*/ <2.43751,5.45848,-1.42309>,<2.4213,5.46215,-1.42635>,<2.43143,5.4568,-1.43881>,
            
    /*10*/ <2.50897,5.70871,-1.45549>,<2.50097,5.71092,-1.45718>,<2.50615,5.70862,-1.46347>,
            
    /*11*/ <2.55295,5.96157,-1.51632>

    /* stem 0.2.4.0*/ 
    /*0*/ <1.26466,4.5002,-0.72221>,
    /*1*/ <1.26588,4.51558,-0.73593>,<1.2634,4.48064,-0.72871>,<1.26469,4.50438,-0.70199>,
            
    /*2*/ <2.27173,4.43141,-0.70936>

    /* stem 0.2.4.1*/ 
    /*0*/ <1.46889,4.42268,-0.8679>,
    /*1*/ <1.46417,4.4038,-0.86844>,<1.48698,4.42806,-0.86311>,<1.45553,4.43619,-0.87215>,
            
    /*2*/ <1.72104,4.3855,-1.77851>

    /* stem 0.2.4.2*/ 
    /*0*/ <1.5795,4.41511,-0.94296>,
    /*1*/ <1.58569,4.42737,-0.93003>,<1.57864,4.42018,-0.96111>,<1.57418,4.39778,-0.93775>,
            
    /*2*/ <2.43301,4.11551,-1.0671>

    /* stem 0.2.4.3*/ 
    /*0*/ <1.71786,4.43963,-1.03238>,
    /*1*/ <1.70807,4.43929,-1.04762>,<1.73361,4.43071,-1.03152>,<1.71191,4.44889,-1.01799>,
            
    /*2*/ <2.1364,5.15102,-1.31699>

    /* stem 0.2.4.4*/ 
    /*0*/ <1.81708,4.49932,-1.10528>,
    /*1*/ <1.83029,4.49045,-1.09801>,<1.81695,4.51681,-1.10476>,<1.804,4.49071,-1.11307>,
            
    /*2*/ <2.2344,4.52418,-1.8333>

    /* stem 0.2.4.5*/ 
    /*0*/ <2.00421,4.66659,-1.22488>,
    /*1*/ <1.99389,4.67872,-1.22177>,<2.01169,4.66578,-1.23925>,<2.00705,4.65527,-1.2136>,
            
    /*2*/ <2.58639,5.09047,-0.94586>

    /* stem 0.2.4.6*/ 
    /*0*/ <2.15448,4.84933,-1.29815>,
    /*1*/ <2.15994,4.84212,-1.31023>,<2.16334,4.85868,-1.2903>,<2.14015,4.8472,-1.29393>,
            
    /*2*/ <1.95105,5.39095,-1.71366>

    /* stem 0.2.4.7*/ 
    /*0*/ <2.28988,5.08533,-1.35896>,
    /*1*/ <2.29202,5.08603,-1.34535>,<2.28536,5.09642,-1.36582>,<2.29227,5.07353,-1.36572>,
            
    /*2*/ <2.89943,5.26876,-1.46404>

    /* stem 0.2.4.8*/ 
    /*0*/ <2.38286,5.28378,-1.39241>,
    /*1*/ <2.37316,5.28465,-1.40066>,<2.39408,5.2892,-1.39515>,<2.38133,5.27749,-1.38141>,
            
    /*2*/ <2.20531,5.7839,-1.1312>

    /* stem 0.2.4.9*/ 
    /*0*/ <2.40551,5.36789,-1.41016>,
    /*1*/ <2.41669,5.36493,-1.4099>,<2.40206,5.3779,-1.40549>,<2.39777,5.36083,-1.41508>,
            
    /*2*/ <2.48599,5.62872,-1.91074>

    /* stem 0.2.4.10*/ 
    /*0*/ <2.47081,5.59456,-1.44527>,
    /*1*/ <2.46561,5.59664,-1.44086>,<2.47148,5.59759,-1.45169>,<2.47536,5.58945,-1.44325>,
            
    /*2*/ <2.78184,5.95014,-1.24562>

    /* stem 0.2.4.11*/ 
    /*0*/ <2.53466,5.86468,-1.49418>,
    /*1*/ <2.53493,5.86421,-1.49598>,<2.53584,5.86587,-1.49334>,<2.53322,5.86394,-1.49323>,
            
    /*2*/ <2.27811,6.20618,-1.61914>

    /* stem 0.2.5*/ 
    /*0*/ <1.3896,4.58692,-0.78605>,
    /*1*/ <1.37438,4.62642,-0.80616>,<1.40279,4.55066,-0.81265>,<1.39164,4.58369,-0.73933>,
            
    /*2*/ <1.61076,4.71087,-0.80827>,<1.63633,4.64268,-0.81411>,<1.6263,4.67241,-0.74813>,
            
    /*3*/ <1.80778,4.84735,-0.82473>,<1.84477,4.79437,-0.83122>,<1.83303,4.81874,-0.77218>,
            
    /*4*/ <1.97631,5.02502,-0.82533>,<2.01785,4.98671,-0.83132>,<2.00124,5.00273,-0.77939>,
            
    /*5*/ <2.13805,5.21484,-0.82583>,<2.17541,5.18402,-0.83097>,<2.16042,5.19691,-0.78646>,
            
    /*6*/ <2.27894,5.41957,-0.82264>,<2.31258,5.39727,-0.82691>,<2.29874,5.40623,-0.78982>,
            
    /*7*/ <2.40844,5.6306,-0.8474>,<2.43602,5.61386,-0.85102>,<2.42647,5.6232,-0.82143>,
            
    /*8*/ <2.52815,5.84858,-0.87423>,<2.54939,5.83702,-0.87709>,<2.5421,5.84376,-0.85486>,
            
    /*9*/ <2.66081,6.05961,-0.90856>,<2.67449,6.05103,-0.91033>,<2.67002,6.05624,-0.89562>,
            
    /*10*/ <2.80833,6.26286,-0.92709>,<2.81491,6.25817,-0.92789>,<2.81251,6.26058,-0.92052>,
            
    /*11*/ <2.92419,6.48343,-0.95164>

    /* stem 0.2.5.0*/ 
    /*0*/ <1.56724,4.65378,-0.78917>,
    /*1*/ <1.57389,4.63591,-0.79413>,<1.5773,4.6648,-0.77629>,<1.55055,4.66064,-0.79708>,
            
    /*2*/ <2.06748,5.03963,-1.50979>

    /* stem 0.2.5.1*/ 
    /*0*/ <1.70414,4.73187,-0.79767>,
    /*1*/ <1.69893,4.74129,-0.78201>,<1.71201,4.74124,-0.81221>,<1.70149,4.7131,-0.79879>,
            
    /*2*/ <2.5387,4.59228,-0.43615>

    /* stem 0.2.5.2*/ 
    /*0*/ <1.95535,4.95796,-0.81134>,
    /*1*/ <1.95387,4.95908,-0.82872>,<1.97089,4.96035,-0.80373>,<1.94128,4.95447,-0.80159>,
            
    /*2*/ <1.79699,5.77871,-0.74532>

    /* stem 0.2.5.3*/ 
    /*0*/ <2.06049,5.08017,-0.81295>,
    /*1*/ <2.06987,5.0726,-0.80133>,<2.05794,5.0967,-0.81217>,<2.05367,5.07122,-0.82534>,
            
    /*2*/ <2.7125,5.20187,-1.25985>

    /* stem 0.2.5.4*/ 
    /*0*/ <2.20186,5.26473,-0.81401>,
    /*1*/ <2.18883,5.27339,-0.81509>,<2.21441,5.26832,-0.82272>,<2.20235,5.25248,-0.80422>,
            
    /*2*/ <2.45145,5.70843,-0.27157>

    /* stem 0.2.5.5*/ 
    /*0*/ <2.25913,5.351,-0.81347>,
    /*1*/ <2.2694,5.34424,-0.82242>,<2.26364,5.35853,-0.80105>,<2.24433,5.35024,-0.81695>,
            
    /*2*/ <2.31888,5.95397,-1.20066>

    /* stem 0.2.5.6*/ 
    /*0*/ <2.35259,5.50225,-0.82493>,
    /*1*/ <2.35045,5.50525,-0.81101>,<2.35198,5.51276,-0.83474>,<2.35535,5.48872,-0.82903>,
            
    /*2*/ <3.01499,5.61375,-0.74693>

    /* stem 0.2.5.7*/ 
    /*0*/ <2.49721,5.76215,-0.85816>,
    /*1*/ <2.4914,5.7637,-0.8697>,<2.50956,5.76591,-0.85653>,<2.49067,5.75683,-0.84825>,
            
    /*2*/ <2.30789,6.31059,-0.68893>

    /* stem 0.2.5.8*/ 
    /*0*/ <2.57958,5.90874,-0.87988>,
    /*1*/ <2.58952,5.90355,-0.87502>,<2.57579,5.91964,-0.87584>,<2.57343,5.90304,-0.88876>,
            
    /*2*/ <2.9013,6.16365,-1.26618>

    /* stem 0.2.5.9*/ 
    /*0*/ <2.74111,6.15942,-0.91513>,
    /*1*/ <2.73568,6.16341,-0.91326>,<2.74526,6.16141,-0.92041>,<2.7424,6.15343,-0.91174>,
            
    /*2*/ <3.02833,6.40101,-0.59775>

    /* stem 0.2.5.10*/ 
    /*0*/ <2.86914,6.37413,-0.93866>,
    /*1*/ <2.87018,6.37338,-0.94057>,<2.87031,6.37538,-0.93713>,<2.86692,6.37363,-0.93828>,
            
    /*2*/ <2.75265,6.73469,-1.14426>

    /* stem 0.2.6*/ 
    /*0*/ <1.84203,4.63389,-1.11833>,
    /*1*/ <1.84294,4.5916,-1.12579>,<1.87406,4.65256,-1.09664>,<1.8091,4.6575,-1.13256>,
            
    /*2*/ <1.95377,4.63269,-1.32054>,<1.98177,4.68755,-1.29431>,<1.92331,4.692,-1.32664>,
            
    /*3*/ <2.05467,4.73267,-1.51102>,<2.07433,4.77789,-1.47769>,<2.0211,4.78132,-1.50408>,
            
    /*4*/ <2.12347,4.87285,-1.68611>,<2.13891,4.90904,-1.652>,<2.09024,4.90979,-1.67052>,
            
    /*5*/ <2.17012,5.02691,-1.85111>,<2.18323,5.05669,-1.82055>,<2.1406,5.05552,-1.83373>,
            
    /*6*/ <2.2141,5.20238,-1.99501>,<2.22408,5.22404,-1.96646>,<2.1887,5.22351,-1.97792>,
            
    /*7*/ <2.25342,5.39026,-2.12142>,<2.26094,5.40564,-2.09708>,<2.23266,5.40533,-2.10634>,
            
    /*8*/ <2.31477,5.57307,-2.24212>,<2.32016,5.58404,-2.22345>,<2.29947,5.58553,-2.2317>,
            
    /*9*/ <2.37832,5.74481,-2.376>,<2.38225,5.75291,-2.36415>,<2.36841,5.75383,-2.36954>,
            
    /*10*/ <2.4341,5.92772,-2.50091>,<2.43597,5.93149,-2.49477>,<2.42901,5.93183,-2.49737>,
            
    /*11*/ <2.48201,6.11566,-2.62074>

    /* stem 0.2.6.0*/ 
    /*0*/ <1.91407,4.65783,-1.2453>,
    /*1*/ <1.92397,4.67075,-1.23724>,<1.90546,4.66138,-1.2609>,<1.91277,4.64135,-1.23776>,
            
    /*2*/ <2.61939,4.39699,-1.69383>

    /* stem 0.2.6.1*/ 
    /*0*/ <1.99969,4.71562,-1.4023>,
    /*1*/ <1.98484,4.71387,-1.41103>,<2.01479,4.71249,-1.41017>,<1.99943,4.72052,-1.38569>,
            
    /*2*/ <2.04305,5.51102,-1.63593>

    /* stem 0.2.6.2*/ 
    /*0*/ <2.08712,4.83718,-1.59206>,
    /*1*/ <2.10184,4.8304,-1.59153>,<2.08559,4.85302,-1.59516>,<2.07392,4.82811,-1.58949>,
            
    /*2*/ <2.0442,4.68526,-2.34749>

    /* stem 0.2.6.3*/ 
    /*0*/ <2.14105,4.97165,-1.75217>,
    /*1*/ <2.13303,4.98232,-1.74483>,<2.13987,4.97029,-1.76729>,<2.15024,4.96233,-1.74438>,
            
    /*2*/ <2.68381,5.43693,-1.8363>

    /* stem 0.2.6.4*/ 
    /*0*/ <2.17904,5.10167,-1.88211>,
    /*1*/ <2.1776,5.09263,-1.89319>,<2.19068,5.11002,-1.88113>,<2.16884,5.10234,-1.87202>,
            
    /*2*/ <1.86314,5.58312,-2.23371>

    /* stem 0.2.6.5*/ 
    /*0*/ <2.22699,5.29937,-2.03763>,
    /*1*/ <2.23614,5.30338,-2.02904>,<2.21705,5.30739,-2.0409>,<2.22777,5.28733,-2.04295>,
            
    /*2*/ <2.56139,5.5252,-2.49931>

    /* stem 0.2.6.6*/ 
    /*0*/ <2.27676,5.48059,-2.16344>,
    /*1*/ <2.26515,5.48267,-2.16626>,<2.28545,5.4826,-2.17165>,<2.27968,5.47652,-2.15239>,
            
    /*2*/ <2.32664,6.00689,-1.98231>

    /* stem 0.2.6.7*/ 
    /*0*/ <2.34019,5.656,-2.2933>,
    /*1*/ <2.34871,5.64998,-2.29672>,<2.34132,5.66685,-2.29197>,<2.33054,5.65119,-2.29122>,
            
    /*2*/ <2.20018,5.72945,-2.77211>

    /* stem 0.2.6.8*/ 
    /*0*/ <2.40391,5.838,-2.43206>,
    /*1*/ <2.40229,5.84198,-2.42719>,<2.40254,5.83966,-2.4382>,<2.4069,5.83237,-2.43081>,
            
    /*2*/ <2.80069,6.04145,-2.46594>

    /* stem 0.2.6.9*/ 
    /*0*/ <2.44847,5.98876,-2.53648>,
    /*1*/ <2.44726,5.98751,-2.53885>,<2.45107,5.99012,-2.53669>,<2.44706,5.98867,-2.53389>,
            
    /*2*/ <2.26215,6.33368,-2.62495>

    /* stem 0.2.7*/ 
    /*0*/ <2.10713,4.69314,-1.33582>,
    /*1*/ <2.12137,4.71956,-1.31029>,<2.10037,4.70355,-1.37322>,<2.09964,4.65632,-1.32396>,
            
    /*2*/ <2.31896,4.65977,-1.36471>,<2.30006,4.64536,-1.42135>,<2.29941,4.60285,-1.37701>,
            
    /*3*/ <2.51669,4.66536,-1.42466>,<2.50244,4.65244,-1.47576>,<2.51423,4.61299,-1.43991>,
            
    /*4*/ <2.7,4.71701,-1.5193>,<2.68175,4.70613,-1.5621>,<2.70451,4.67272,-1.53664>,
            
    /*5*/ <2.8534,4.80802,-1.63525>,<2.83402,4.79797,-1.6699>,<2.86158,4.77238,-1.65369>,
            
    /*6*/ <2.97204,4.93653,-1.75452>,<2.95459,4.9276,-1.78245>,<2.98251,4.91016,-1.77347>,
            
    /*7*/ <3.09825,5.07385,-1.8542>,<3.08612,5.06837,-1.87804>,<3.10794,5.05397,-1.8702>,
            
    /*8*/ <3.20757,5.24215,-1.91578>,<3.2003,5.24029,-1.93483>,<3.21771,5.23088,-1.92955>,
            
    /*9*/ <3.32069,5.41643,-1.96028>,<3.31649,5.41611,-1.97326>,<3.32793,5.40961,-1.96963>,
            
    /*10*/ <3.41126,5.60485,-2.0017>,<3.4091,5.60459,-2.00817>,<3.4152,5.60203,-2.00651>,
            
    /*11*/ <3.48896,5.79971,-2.04078>

    /* stem 0.2.7.0*/ 
    /*0*/ <2.20996,4.66361,-1.36262>,
    /*1*/ <2.20543,4.66246,-1.37875>,<2.21951,4.65165,-1.35571>,<2.20496,4.67673,-1.35341>,
            
    /*2*/ <2.89066,5.07869,-1.58374>

    /* stem 0.2.7.1*/ 
    /*0*/ <2.38632,4.63897,-1.4108>,
    /*1*/ <2.39021,4.62952,-1.39853>,<2.39588,4.65109,-1.41489>,<2.37287,4.63629,-1.41899>,
            
    /*2*/ <2.77669,4.16704,-1.89794>

    /* stem 0.2.7.2*/ 
    /*0*/ <2.56487,4.65964,-1.47378>,
    /*1*/ <2.55989,4.67384,-1.47526>,<2.57211,4.65293,-1.48524>,<2.56262,4.65215,-1.46084>,
            
    /*2*/ <3.20696,4.91197,-1.21613>

    /* stem 0.2.7.3*/ 
    /*0*/ <2.75408,4.73443,-1.58255>,
    /*1*/ <2.75523,4.72289,-1.59055>,<2.76565,4.74129,-1.57837>,<2.74135,4.73911,-1.57872>,
            
    /*2*/ <2.72771,5.12028,-2.14266>

    /* stem 0.2.7.4*/ 
    /*0*/ <2.90734,4.8562,-1.70925>,
    /*1*/ <2.91243,4.86123,-1.69837>,<2.9041,4.86402,-1.71916>,<2.90549,4.84333,-1.71024>,
            
    /*2*/ <3.48071,4.79207,-1.94775>

    /* stem 0.2.7.5*/ 
    /*0*/ <3.00639,4.96515,-1.7981>,
    /*1*/ <2.99759,4.96746,-1.8063>,<3.01813,4.965,-1.80158>,<3.00344,4.96298,-1.7864>,
            
    /*2*/ <3.04791,5.53495,-1.68209>

    /* stem 0.2.7.6*/ 
    /*0*/ <3.13935,5.13043,-1.88983>,
    /*1*/ <3.14887,5.12465,-1.88879>,<3.13857,5.14075,-1.88557>,<3.1306,5.12589,-1.89514>,
            
    /*2*/ <3.31136,5.33166,-2.34565>

    /* stem 0.2.7.7*/ 
    /*0*/ <3.23874,5.28483,-1.93767>,
    /*1*/ <3.23217,5.29038,-1.93196>,<3.24291,5.28892,-1.94617>,<3.24114,5.2752,-1.93486>,
            
    /*2*/ <3.60688,5.45261,-1.6765>

    /* stem 0.2.7.8*/ 
    /*0*/ <3.38768,5.55295,-1.99534>,
    /*1*/ <3.38843,5.55164,-2.00011>,<3.39138,5.55506,-1.99272>,<3.38324,5.55214,-1.9932>,
            
    /*2*/ <3.26305,5.9207,-2.1156>

    /* stem 0.2.7.9*/ 
    /*0*/ <3.43938,5.67375,-2.01807>,
    /*1*/ <3.44056,5.67368,-2.01583>,<3.43807,5.67581,-2.01875>,<3.4395,5.67175,-2.01962>,
            
    /*2*/ <3.74711,5.81626,-2.17688>

    /* stem 0.2.8*/ 
    /*0*/ <2.53621,4.81901,-1.67684>,
    /*1*/ <2.5185,4.81777,-1.70103>,<2.56139,4.80271,-1.67583>,<2.52875,4.83656,-1.65366>,
            
    /*2*/ <2.61682,4.96212,-1.77672>,<2.65542,4.94857,-1.75403>,<2.62605,4.97903,-1.73409>,
            
    /*3*/ <2.71993,5.09827,-1.85968>,<2.75393,5.08573,-1.83929>,<2.72916,5.11467,-1.8226>,
            
    /*4*/ <2.80909,5.24607,-1.93857>,<2.8401,5.2369,-1.92187>,<2.81675,5.25964,-1.90569>,
            
    /*5*/ <2.89107,5.40034,-2.01384>,<2.9181,5.39327,-1.99997>,<2.89736,5.41142,-1.98537>,
            
    /*6*/ <2.96285,5.57283,-2.05867>,<2.98531,5.56691,-2.04701>,<2.96627,5.57831,-2.03349>,
            
    /*7*/ <3.04224,5.74118,-2.10089>,<3.05983,5.7356,-2.09131>,<3.04485,5.74534,-2.08068>,
            
    /*8*/ <3.12538,5.90602,-2.14699>,<3.1385,5.90167,-2.13977>,<3.12747,5.90942,-2.13192>,
            
    /*9*/ <3.2145,6.05635,-2.22019>,<3.22335,6.05357,-2.21548>,<3.21665,6.05989,-2.21066>,
            
    /*10*/ <3.29321,6.2159,-2.28774>,<3.29774,6.21471,-2.28548>,<3.29421,6.21754,-2.28291>,
            
    /*11*/ <3.34008,6.38716,-2.35549>

    /* stem 0.2.8.0*/ 
    /*0*/ <2.57841,4.88205,-1.71098>,
    /*1*/ <2.5894,4.87708,-1.70656>,<2.57552,4.89435,-1.70864>,<2.5703,4.87472,-1.71773>,
            
    /*2*/ <2.92016,5.08147,-2.3379>

    /* stem 0.2.8.1*/ 
    /*0*/ <2.67388,5.01842,-1.78958>,
    /*1*/ <2.66548,5.02663,-1.78647>,<2.6787,5.01859,-1.80074>,<2.67745,5.01003,-1.78155>,
            
    /*2*/ <3.17622,5.44682,-1.56569>

    /* stem 0.2.8.2*/ 
    /*0*/ <2.79364,5.19969,-1.89568>,
    /*1*/ <2.79644,5.19321,-1.90443>,<2.80132,5.20643,-1.891>,<2.78317,5.19942,-1.89161>,
            
    /*2*/ <2.62574,5.66842,-2.29627>

    /* stem 0.2.8.3*/ 
    /*0*/ <2.85084,5.30301,-1.95>,
    /*1*/ <2.85463,5.3059,-1.94037>,<2.84689,5.31045,-1.95667>,<2.85102,5.29269,-1.95297>,
            
    /*2*/ <3.40359,5.3812,-2.19044>

    /* stem 0.2.8.4*/ 
    /*0*/ <2.94551,5.5086,-2.0289>,
    /*1*/ <2.93774,5.51017,-2.03471>,<2.9546,5.50966,-2.03247>,<2.94419,5.50599,-2.01953>,
            
    /*2*/ <2.94201,6.03849,-1.88146>

    /* stem 0.2.8.5*/ 
    /*0*/ <3.0897,5.82318,-2.11526>,
    /*1*/ <3.09724,5.8194,-2.11545>,<3.08864,5.83024,-2.11077>,<3.08323,5.8199,-2.11955>,
            
    /*2*/ <3.20713,6.07649,-2.48635>

    /* stem 0.2.8.6*/ 
    /*0*/ <3.17921,5.98959,-2.18174>,
    /*1*/ <3.17534,5.99404,-2.17738>,<3.1802,5.99132,-2.1888>,<3.1821,5.98341,-2.17905>,
            
    /*2*/ <3.52701,6.1954,-2.0824>

    /* stem 0.2.8.7*/ 
    /*0*/ <3.25983,6.14301,-2.25334>,
    /*1*/ <3.25968,6.14131,-2.25737>,<3.26345,6.14503,-2.25195>,<3.25636,6.14268,-2.25069>,
            
    /*2*/ <3.12984,6.4652,-2.38382>

    /* stem 0.2.8.8*/ 
    /*0*/ <3.32353,6.32428,-2.32972>,
    /*1*/ <3.32425,6.32443,-2.3289>,<3.32295,6.32513,-2.33011>,<3.32339,6.32327,-2.33016>,
            
    /*2*/ <3.55605,6.38531,-2.54291>

    /* stem 0.3*/ 
    /*0*/ <0.0123,5.19013,-0.02142>,
    /*1*/ <-0.06854,5.18695,-0.05078>,<-0.01666,5.27088,-0.0284>,<0.07524,5.24322,0.00363>,
            <0.08016,5.1422,0.00104>,<-0.0087,5.10742,-0.03259>,
    /*2*/ <-0.22837,5.16719,0.41533>,<-0.18142,5.24315,0.43559>,<-0.09825,5.21812,0.46458>,
            <-0.09379,5.12669,0.46223>,<-0.17421,5.09522,0.43179>,
    /*3*/ <-0.33644,5.2144,0.90362>,<-0.29018,5.2819,0.90803>,<-0.21409,5.25918,0.92831>,
            <-0.21333,5.17763,0.93643>,<-0.28895,5.14996,0.92118>,
    /*4*/ <-0.45272,5.28347,1.37618>,<-0.41148,5.34287,1.37838>,<-0.34495,5.32314,1.39882>,
            <-0.34507,5.25156,1.40926>,<-0.41168,5.22704,1.39526>,
    /*5*/ <-0.53405,5.42378,1.8466>,<-0.49607,5.47313,1.83905>,<-0.43807,5.45563,1.85533>,
            <-0.44021,5.39546,1.87294>,<-0.49952,5.37578,1.86755>,
    /*6*/ <-0.62541,5.56401,2.30916>,<-0.59339,5.60598,2.30332>,<-0.5445,5.59153,2.31825>,
            <-0.54632,5.54063,2.33332>,<-0.59632,5.52362,2.32771>,
    /*7*/ <-0.74014,5.77619,2.73633>,<-0.713,5.8091,2.72777>,<-0.67397,5.79893,2.74408>,
            <-0.67699,5.75973,2.76272>,<-0.71788,5.74568,2.75793>,
    /*8*/ <-0.84434,6.03574,3.14314>,<-0.82242,6.05984,3.13378>,<-0.79217,6.05222,3.14703>,
            <-0.79539,6.02341,3.16459>,<-0.82763,6.01322,3.16219>,
    /*9*/ <-0.94351,6.25962,3.5718>,<-0.92812,6.27756,3.56626>,<-0.90622,6.27159,3.57489>,
            <-0.90808,6.24995,3.58576>,<-0.93113,6.24256,3.58384>,
    /*10*/ <-1.04186,6.49882,3.99166>,<-1.03247,6.50946,3.98796>,<-1.01928,6.50594,3.99333>,
            <-1.02052,6.49311,4.00034>,<-1.03447,6.48871,3.99931>,
    /*11*/ <-1.14118,6.74414,4.40772>,<-1.13793,6.74779,4.4064>,<-1.13339,6.74659,4.40829>,
            <-1.13383,6.7422,4.41077>,<-1.13864,6.74069,4.41042>,
    /*12*/ <-1.13699,6.74428,4.40872>

    /* stem 0.3c0*/ 
    /*0*/ <-0.39318,5.28562,1.39158>,
    /*1*/ <-0.44152,5.28294,1.35359>,<-0.40476,5.34262,1.3715>,<-0.35201,5.32352,1.41717>,
            <-0.35615,5.25204,1.42747>,<-0.41147,5.22696,1.38818>,
    /*2*/ <-0.73897,5.35591,1.74011>,<-0.7071,5.40766,1.75564>,<-0.66135,5.3911,1.79524>,
            <-0.66494,5.32911,1.80417>,<-0.71291,5.30736,1.7701>,
    /*3*/ <-0.99021,5.4285,2.16585>,<-0.96115,5.47175,2.17621>,<-0.91888,5.4567,2.20464>,
            <-0.92182,5.40415,2.21185>,<-0.9659,5.38673,2.18788>,
    /*4*/ <-1.24867,5.54998,2.56578>,<-1.22345,5.58488,2.572>,<-1.1904,5.57317,2.59776>,
            <-1.1952,5.53103,2.60745>,<-1.23121,5.5167,2.58769>,
    /*5*/ <-1.49845,5.69461,2.96641>,<-1.47793,5.72136,2.96996>,<-1.45216,5.71221,2.98998>,
            <-1.45675,5.67981,2.99882>,<-1.48536,5.66893,2.98425>,
    /*6*/ <-1.68619,5.85312,3.39867>,<-1.67029,5.87146,3.39911>,<-1.65045,5.86392,3.41091>,
            <-1.6541,5.84091,3.41777>,<-1.67618,5.83423,3.4102>,
    /*7*/ <-1.846,5.99192,3.84554>,<-1.83634,6.00297,3.84572>,<-1.82398,5.99807,3.85192>,
            <-1.82599,5.98401,3.85557>,<-1.8396,5.98021,3.85162>,
    /*8*/ <-1.95006,6.13957,4.30595>,<-1.94659,6.14324,4.30561>,<-1.94219,6.14139,4.30728>,
            <-1.94293,6.13658,4.30866>,<-1.94779,6.13545,4.30784>,
    /*9*/ <-1.94591,6.13925,4.30707>

    /* stem 0.3c0c0*/ 
    /*0*/ <-1.66744,5.85273,3.40733>,
    /*1*/ <-1.6757,5.85249,3.3884>,<-1.66276,5.87061,3.3981>,<-1.65629,5.86401,3.42056>,
            <-1.66523,5.84182,3.42474>,<-1.67722,5.8347,3.40486>,
    /*2*/ <-2.08638,6.05279,3.57392>,<-2.07856,6.06374,3.57979>,<-2.07465,6.05976,3.59335>,
            <-2.08005,6.04635,3.59588>,<-2.0873,6.04205,3.58387>,
    /*3*/ <-2.49658,6.26457,3.74653>,<-2.49385,6.26833,3.74854>,<-2.49263,6.26702,3.75327>,
            <-2.49461,6.26246,3.75419>,<-2.49704,6.26094,3.75003>,
    /*4*/ <-2.49494,6.26467,3.75051>

    /* stem 0.3c0c0.0*/ 
    /*0*/ <-2.25262,6.1406,3.65374>,
    /*1*/ <-2.25755,6.13518,3.64836>,<-2.25246,6.14957,3.65223>,<-2.24786,6.13707,3.66064>,
            
    /*2*/ <-2.36737,6.15205,3.73345>,<-2.36279,6.16501,3.73693>,<-2.35865,6.15376,3.7445>,
            
    /*3*/ <-2.46945,6.20772,3.81388>,<-2.46283,6.21839,3.815>,<-2.46129,6.20911,3.82339>,
            
    /*4*/ <-2.55506,6.29755,3.88119>,<-2.54732,6.30539,3.88066>,<-2.54768,6.29858,3.88932>,
            
    /*5*/ <-2.63831,6.40513,3.9133>,<-2.631,6.41107,3.91258>,<-2.63301,6.40703,3.92088>,
            
    /*6*/ <-2.72332,6.51282,3.9402>,<-2.71726,6.51781,3.93962>,<-2.71909,6.51462,3.94659>,
            
    /*7*/ <-2.78371,6.63968,3.94176>,<-2.77806,6.64241,3.94119>,<-2.78041,6.64122,3.94691>,
            
    /*8*/ <-2.83845,6.76842,3.93612>,<-2.83413,6.77027,3.9357>,<-2.83602,6.76965,3.93998>,
            
    /*9*/ <-2.89079,6.89501,3.90825>,<-2.88787,6.89618,3.90798>,<-2.88932,6.89619,3.91078>,
            
    /*10*/ <-2.92128,7.02426,3.8636>,<-2.91974,7.02461,3.86354>,<-2.92056,7.02487,3.86486>,
            
    /*11*/ <-2.97302,7.14891,3.82698>

    /* stem 0.3c0c0.0.0*/ 
    /*0*/ <-2.33069,6.15216,3.71357>,
    /*1*/ <-2.32981,6.15587,3.714>,<-2.33202,6.15016,3.71656>,<-2.33023,6.15046,3.71017>,
            
    /*2*/ <-2.83222,6.28548,3.57938>

    /* stem 0.3c0c0.0.1*/ 
    /*0*/ <-2.50583,6.25463,3.84945>,
    /*1*/ <-2.50641,6.25225,3.85188>,<-2.50844,6.25651,3.84822>,<-2.50263,6.25512,3.84826>,
            
    /*2*/ <-2.42923,6.58128,4.18764>

    /* stem 0.3c0c0.0.2*/ 
    /*0*/ <-2.57846,6.33677,3.8945>,
    /*1*/ <-2.57911,6.3372,3.89134>,<-2.57792,6.33935,3.89642>,<-2.57834,6.33376,3.89575>,
            
    /*2*/ <-3.01572,6.3582,3.98803>

    /* stem 0.3c0c0.0.3*/ 
    /*0*/ <-2.67417,6.45787,3.92799>,
    /*1*/ <-2.67227,6.45886,3.9301>,<-2.67712,6.45775,3.92855>,<-2.67311,6.457,3.9253>,
            
    /*2*/ <-2.71676,6.84019,3.78687>

    /* stem 0.3c0c0.0.4*/ 
    /*0*/ <-2.80217,6.69071,3.94096>,
    /*1*/ <-2.80453,6.68968,3.94074>,<-2.80134,6.69242,3.93922>,<-2.80064,6.69003,3.94292>,
            
    /*2*/ <-2.93186,6.94762,4.13174>

    /* stem 0.3c0c0.0.5*/ 
    /*0*/ <-2.86171,6.83011,3.9237>,
    /*1*/ <-2.85988,6.8306,3.92241>,<-2.8625,6.83166,3.92519>,<-2.86276,6.82809,3.92348>,
            
    /*2*/ <-3.04563,6.94771,3.70564>

    /* stem 0.3c0c0.0.6*/ 
    /*0*/ <-2.945,7.08256,3.84674>,
    /*1*/ <-2.94517,7.08263,3.84719>,<-2.94529,7.08267,3.84636>,<-2.94456,7.08239,3.84666>,
            
    /*2*/ <-2.8581,7.30823,3.84455>

    /* stem 0.3c0.0*/ 
    /*0*/ <-0.47686,5.30561,1.49663>,
    /*1*/ <-0.49815,5.26339,1.48772>,<-0.50333,5.34565,1.50006>,<-0.42912,5.3078,1.50212>,
            
    /*2*/ <-0.52339,5.2278,1.74245>,<-0.52805,5.30183,1.75356>,<-0.46126,5.26777,1.75542>,
            
    /*3*/ <-0.5053,5.28549,2.01098>,<-0.51072,5.35056,1.9975>,<-0.45057,5.32192,1.99992>,
            
    /*4*/ <-0.47662,5.42588,2.24028>,<-0.48321,5.47591,2.21101>,<-0.42997,5.45325,2.21843>,
            
    /*5*/ <-0.43628,5.62039,2.41923>,<-0.44378,5.65509,2.38402>,<-0.39768,5.63774,2.39261>,
            
    /*6*/ <-0.38031,5.82361,2.57389>,<-0.38731,5.85019,2.54257>,<-0.34904,5.83493,2.54879>,
            
    /*7*/ <-0.35468,6.02972,2.72655>,<-0.36028,6.05016,2.70082>,<-0.32915,6.04079,2.7082>,
            
    /*8*/ <-0.34048,6.2391,2.87729>,<-0.34468,6.25401,2.85767>,<-0.32126,6.2479,2.86394>,
            
    /*9*/ <-0.37098,6.44015,3.03451>,<-0.37366,6.45025,3.02152>,<-0.35818,6.44805,3.02731>,
            
    /*10*/ <-0.39388,6.66578,3.16144>,<-0.39508,6.66984,3.15427>,<-0.38737,6.66892,3.1573>,
            
    /*11*/ <-0.4191,6.89852,3.27163>

    /* stem 0.3c0.0.0*/ 
    /*0*/ <-0.49424,5.28034,1.65779>,
    /*1*/ <-0.499,5.29997,1.66036>,<-0.48274,5.27076,1.6716>,<-0.50098,5.27028,1.64141>,
            
    /*2*/ <-1.31279,5.01677,2.15676>

    /* stem 0.3c0.0.1*/ 
    /*0*/ <-0.49851,5.28574,1.84447>,
    /*1*/ <-0.48261,5.2745,1.84589>,<-0.51253,5.28456,1.858>,<-0.50038,5.29816,1.82953>,
            
    /*2*/ <-0.06629,5.96097,2.35127>

    /* stem 0.3c0.0.2*/ 
    /*0*/ <-0.47626,5.38448,2.11131>,
    /*1*/ <-0.49429,5.38362,2.11392>,<-0.46746,5.40028,2.1136>,<-0.46704,5.36953,2.10643>,
            
    /*2*/ <-0.34465,5.18879,2.95812>

    /* stem 0.3c0.0.3*/ 
    /*0*/ <-0.43527,5.59115,2.3547>,
    /*1*/ <-0.42432,5.59863,2.34444>,<-0.43247,5.59094,2.37123>,<-0.44902,5.58387,2.34844>,
            
    /*2*/ <-0.83505,6.2811,2.43101>

    /* stem 0.3c0.0.4*/ 
    /*0*/ <-0.40768,5.70514,2.45175>,
    /*1*/ <-0.40771,5.69519,2.46438>,<-0.41518,5.71933,2.45267>,<-0.40016,5.70089,2.43819>,
            
    /*2*/ <0.23614,6.02819,2.70775>

    /* stem 0.3c0.0.5*/ 
    /*0*/ <-0.37965,5.80876,2.53343>,
    /*1*/ <-0.38935,5.81773,2.52538>,<-0.36673,5.81478,2.53941>,<-0.38288,5.79378,2.53549>,
            
    /*2*/ <-0.74041,5.9711,3.14944>

    /* stem 0.3c0.0.6*/ 
    /*0*/ <-0.35413,5.98886,2.67238>,
    /*1*/ <-0.34001,5.98623,2.67361>,<-0.36157,5.99374,2.68372>,<-0.3608,5.9866,2.65981>,
            
    /*2*/ <-0.21962,6.62591,2.48651>

    /* stem 0.3c0.0.7*/ 
    /*0*/ <-0.34063,6.16209,2.80288>,
    /*1*/ <-0.35227,6.15857,2.80854>,<-0.33904,6.17446,2.79796>,<-0.33059,6.15323,2.80214>,
            
    /*2*/ <-0.12913,6.35572,3.35815>

    /* stem 0.3c0.0.8*/ 
    /*0*/ <-0.34966,6.33493,2.9376>,
    /*1*/ <-0.34535,6.3426,2.92899>,<-0.34562,6.33579,2.94919>,<-0.35801,6.3264,2.9346>,
            
    /*2*/ <-0.7698,6.70454,3.05662>

    /* stem 0.3c0.0.9*/ 
    /*0*/ <-0.37975,6.5562,3.09216>,
    /*1*/ <-0.37749,6.55292,3.0982>,<-0.38534,6.56079,3.09242>,<-0.37643,6.5549,3.08587>,
            
    /*2*/ <-0.06082,6.93982,3.18097>

    /* stem 0.3c0.0.10*/ 
    /*0*/ <-0.40072,6.74163,3.19401>,
    /*1*/ <-0.40348,6.74214,3.19232>,<-0.39836,6.7439,3.19402>,<-0.40031,6.73884,3.19568>,
            
    /*2*/ <-0.58957,6.93449,3.56113>

    /* stem 0.3c0.1*/ 
    /*0*/ <-1.10979,5.50182,2.42513>,
    /*1*/ <-1.11126,5.54007,2.41243>,<-1.09701,5.49345,2.46245>,<-1.1211,5.47195,2.40051>,
            
    /*2*/ <-1.3115,5.55256,2.48599>,<-1.29867,5.5106,2.53101>,<-1.32036,5.49126,2.47527>,
            
    /*3*/ <-1.48569,5.60299,2.59061>,<-1.4728,5.56674,2.63113>,<-1.50384,5.55023,2.58771>,
            
    /*4*/ <-1.63778,5.7183,2.65629>,<-1.63959,5.69288,2.69802>,<-1.66658,5.67893,2.65971>,
            
    /*5*/ <-1.77706,5.86242,2.71728>,<-1.78158,5.84334,2.75432>,<-1.8064,5.83291,2.7222>,
            
    /*6*/ <-1.87866,6.04002,2.74963>,<-1.88676,6.03002,2.78209>,<-1.90827,6.02251,2.75563>,
            
    /*7*/ <-1.97078,6.2276,2.79193>,<-1.97702,6.21922,2.81784>,<-1.99518,6.21499,2.79703>,
            
    /*8*/ <-2.04637,6.42043,2.84213>,<-2.05095,6.41396,2.86153>,<-2.06524,6.41232,2.8463>,
            
    /*9*/ <-2.13619,6.60994,2.88472>,<-2.13934,6.6058,2.89768>,<-2.14847,6.6038,2.8873>,
            
    /*10*/ <-2.18321,6.81433,2.91676>,<-2.18502,6.81299,2.92337>,<-2.18982,6.81268,2.91831>,
            
    /*11*/ <-2.18877,7.02476,2.95009>

    /* stem 0.3c0.1.0*/ 
    /*0*/ <-1.20844,5.50986,2.46072>,
    /*1*/ <-1.20414,5.50076,2.47468>,<-1.22205,5.50521,2.45128>,<-1.19912,5.5236,2.4562>,
            
    /*2*/ <-1.69611,5.99328,2.92582>

    /* stem 0.3c0.1.1*/ 
    /*0*/ <-1.42122,5.55271,2.56365>,
    /*1*/ <-1.42989,5.55059,2.55023>,<-1.42485,5.56471,2.57378>,<-1.40893,5.54282,2.56695>,
            
    /*2*/ <-1.9001,5.08496,2.94661>

    /* stem 0.3c0.1.2*/ 
    /*0*/ <-1.55547,5.6256,2.63204>,
    /*1*/ <-1.54536,5.63526,2.63837>,<-1.56896,5.62304,2.6389>,<-1.55209,5.6185,2.61887>,
            
    /*2*/ <-1.85046,6.17917,2.25799>

    /* stem 0.3c0.1.3*/ 
    /*0*/ <-1.69852,5.75053,2.69292>,
    /*1*/ <-1.70777,5.74022,2.69697>,<-1.703,5.76133,2.68444>,<-1.68478,5.75005,2.69733>,
            
    /*2*/ <-1.86335,6.11571,3.24522>

    /* stem 0.3c0.1.4*/ 
    /*0*/ <-1.84798,5.95323,2.74934>,
    /*1*/ <-1.84301,5.95792,2.738>,<-1.84748,5.9606,2.76033>,<-1.85345,5.94118,2.7497>,
            
    /*2*/ <-2.3994,6.1992,2.60947>

    /* stem 0.3c0.1.5*/ 
    /*0*/ <-1.92208,6.09606,2.77613>,
    /*1*/ <-1.919,6.09498,2.78818>,<-1.93394,6.09819,2.77289>,<-1.91329,6.095,2.76733>,
            
    /*2*/ <-1.82646,6.66812,2.80266>

    /* stem 0.3c0.1.6*/ 
    /*0*/ <-2.02089,6.32688,2.82828>,
    /*1*/ <-2.02974,6.32522,2.82147>,<-2.01499,6.33648,2.82762>,<-2.01794,6.31894,2.83574>,
            
    /*2*/ <-2.33331,6.54308,3.18185>

    /* stem 0.3c0.1.7*/ 
    /*0*/ <-2.0856,6.48439,2.86437>,
    /*1*/ <-2.07609,6.48876,2.86422>,<-2.09236,6.48684,2.87197>,<-2.08834,6.47757,2.85693>,
            
    /*2*/ <-2.25455,6.8427,2.59833>

    /* stem 0.3c0.1.8*/ 
    /*0*/ <-2.16581,6.71979,2.9061>,
    /*1*/ <-2.16988,6.71834,2.91006>,<-2.16704,6.72371,2.90193>,<-2.1605,6.71731,2.90632>,
            
    /*2*/ <-2.03313,7.02622,3.15473>

    /* stem 0.3c0.1.9*/ 
    /*0*/ <-2.18701,6.89,2.93058>,
    /*1*/ <-2.18678,6.89037,2.92805>,<-2.18545,6.89123,2.93221>,<-2.18881,6.8884,2.93149>,
            
    /*2*/ <-2.43031,7.1741,2.94965>

    /* stem 0.3c0.2*/ 
    /*0*/ <-1.30956,5.60278,2.72781>,
    /*1*/ <-1.2905,5.58254,2.74753>,<-1.34336,5.5986,2.72673>,<-1.2948,5.6272,2.70917>,
            
    /*2*/ <-1.31302,5.71233,2.89662>,<-1.36059,5.72678,2.8779>,<-1.31689,5.75252,2.86209>,
            
    /*3*/ <-1.32918,5.87829,3.01482>,<-1.37115,5.88855,2.99577>,<-1.33164,5.90592,2.97661>,
            
    /*4*/ <-1.30084,6.04212,3.11989>,<-1.33747,6.05689,3.10776>,<-1.30351,6.06526,3.08576>,
            
    /*5*/ <-1.29876,6.21743,3.21975>,<-1.33051,6.2259,3.20655>,<-1.30107,6.23537,3.1893>,
            
    /*6*/ <-1.31386,6.39218,3.31613>,<-1.34023,6.39717,3.30385>,<-1.31569,6.40666,3.29048>,
            
    /*7*/ <-1.29422,6.56433,3.41057>,<-1.31531,6.57144,3.40269>,<-1.29584,6.57611,3.39018>,
            
    /*8*/ <-1.30038,6.73595,3.51223>,<-1.31624,6.73976,3.50534>,<-1.3015,6.74515,3.49714>,
            
    /*9*/ <-1.30657,6.90235,3.62044>,<-1.31715,6.90507,3.61598>,<-1.30733,6.90889,3.61065>,
            
    /*10*/ <-1.2907,7.07586,3.71643>,<-1.29599,7.07755,3.71443>,<-1.29112,7.07882,3.71134>,
            
    /*11*/ <-1.25272,7.2617,3.77741>

    /* stem 0.3c0.2.0*/ 
    /*0*/ <-1.32,5.66751,2.80433>,
    /*1*/ <-1.3339,5.66959,2.80067>,<-1.31109,5.67889,2.80581>,<-1.315,5.65404,2.80652>,
            
    /*2*/ <-1.50884,5.71835,3.55061>

    /* stem 0.3c0.2.1*/ 
    /*0*/ <-1.34043,5.84969,2.96569>,
    /*1*/ <-1.32801,5.8535,2.96192>,<-1.3436,5.84897,2.97882>,<-1.34969,5.84659,2.95632>,
            
    /*2*/ <-1.55329,6.52946,2.95153>

    /* stem 0.3c0.2.2*/ 
    /*0*/ <-1.33459,5.94218,3.02975>,
    /*1*/ <-1.3403,5.93643,3.03999>,<-1.33652,5.9549,3.02749>,<-1.32695,5.93521,3.02177>,
            
    /*2*/ <-0.79067,6.0937,3.41802>

    /* stem 0.3c0.2.3*/ 
    /*0*/ <-1.31124,6.17589,3.17563>,
    /*1*/ <-1.31407,6.18179,3.16567>,<-1.30176,6.17921,3.18203>,<-1.31789,6.16666,3.17917>,
            
    /*2*/ <-1.66815,6.55938,3.50481>

    /* stem 0.3c0.2.4*/ 
    /*0*/ <-1.31392,6.27622,3.23369>,
    /*1*/ <-1.30475,6.27338,3.23989>,<-1.32255,6.28193,3.23854>,<-1.31447,6.27334,3.22265>,
            
    /*2*/ <-1.05711,6.7879,3.08757>

    /* stem 0.3c0.2.5*/ 
    /*0*/ <-1.30372,6.64746,3.44814>,
    /*1*/ <-1.31331,6.64697,3.44855>,<-1.29937,6.65601,3.44738>,<-1.29847,6.63941,3.44849>,
            
    /*2*/ <-1.2846,6.68096,3.93421>

    /* stem 0.3c0.2.6*/ 
    /*0*/ <-1.30764,6.80141,3.54591>,
    /*1*/ <-1.30125,6.80493,3.54091>,<-1.30733,6.80224,3.5547>,<-1.31433,6.79706,3.54211>,
            
    /*2*/ <-1.53774,7.17992,3.51838>

    /* stem 0.3c0.2.7*/ 
    /*0*/ <-1.30366,6.97028,3.65278>,
    /*1*/ <-1.30422,6.96759,3.65759>,<-1.30676,6.97473,3.65173>,<-1.29999,6.96851,3.64904>,
            
    /*2*/ <-1.02683,7.20194,3.815>

    /* stem 0.3c0.2.8*/ 
    /*0*/ <-1.26664,7.19736,3.7553>,
    /*1*/ <-1.26733,7.19781,3.75443>,<-1.26555,7.19779,3.75547>,<-1.26706,7.19649,3.75599>,
            
    /*2*/ <-1.38825,7.42537,3.96838>

    /* stem 0.3c0.3*/ 
    /*0*/ <-1.53906,5.74823,3.12479>,
    /*1*/ <-1.56274,5.74873,3.11385>,<-1.52999,5.76931,3.13721>,<-1.52446,5.72667,3.12331>,
            
    /*2*/ <-1.63266,5.68918,3.26873>,<-1.60319,5.7077,3.28975>,<-1.59821,5.66933,3.27725>,
            
    /*3*/ <-1.73518,5.6828,3.4108>,<-1.70921,5.69795,3.43086>,<-1.71091,5.66199,3.42766>,
            
    /*4*/ <-1.8438,5.75,3.53383>,<-1.81922,5.76239,3.54941>,<-1.82923,5.73319,3.55631>,
            
    /*5*/ <-1.93171,5.84772,3.6589>,<-1.90816,5.85652,3.66903>,<-1.9195,5.83391,3.67878>,
            
    /*6*/ <-2.00588,5.97037,3.7675>,<-1.98545,5.97665,3.77482>,<-1.99676,5.96031,3.78555>,
            
    /*7*/ <-2.06478,6.11358,3.85918>,<-2.0479,6.11756,3.86425>,<-2.05811,6.10678,3.87454>,
            
    /*8*/ <-2.11594,6.26754,3.9367>,<-2.10314,6.27018,3.94031>,<-2.11126,6.26327,3.94868>,
            
    /*9*/ <-2.17626,6.42912,3.98416>,<-2.16798,6.43154,3.98685>,<-2.17368,6.42769,3.9927>,
            
    /*10*/ <-2.23195,6.58581,4.05467>,<-2.22772,6.58681,4.05593>,<-2.23045,6.58457,4.05875>,
            
    /*11*/ <-2.30268,6.73091,4.13431>

    /* stem 0.3c0.3.0*/ 
    /*0*/ <-1.5879,5.70804,3.22869>,
    /*1*/ <-1.58111,5.71456,3.23441>,<-1.58872,5.69735,3.23123>,<-1.59388,5.7122,3.22043>,
            
    /*2*/ <-2.09875,5.85226,3.67107>

    /* stem 0.3c0.3.1*/ 
    /*0*/ <-1.67271,5.68425,3.36139>,
    /*1*/ <-1.67465,5.67417,3.35941>,<-1.68045,5.69054,3.36455>,<-1.66304,5.68804,3.36022>,
            
    /*2*/ <-1.53941,5.53639,3.98248>

    /* stem 0.3c0.3.2*/ 
    /*0*/ <-1.86275,5.78357,3.5905>,
    /*1*/ <-1.86292,5.79082,3.58461>,<-1.86177,5.78504,3.59967>,<-1.86355,5.77487,3.58722>,
            
    /*2*/ <-2.43417,5.81543,3.64625>

    /* stem 0.3c0.3.3*/ 
    /*0*/ <-1.97064,5.92813,3.74031>,
    /*1*/ <-1.96606,5.92525,3.74688>,<-1.97881,5.93025,3.74142>,<-1.96705,5.92889,3.73263>,
            
    /*2*/ <-1.82933,6.41376,3.85456>

    /* stem 0.3c0.3.4*/ 
    /*0*/ <-2.02242,6.03131,3.81498>,
    /*1*/ <-2.02964,6.03036,3.81162>,<-2.01904,6.03858,3.81521>,<-2.01858,6.025,3.8181>,
            
    /*2*/ <-2.23307,6.11543,4.24412>

    /* stem 0.3c0.3.5*/ 
    /*0*/ <-2.0761,6.16829,3.89336>,
    /*1*/ <-2.06949,6.17131,3.89185>,<-2.07882,6.16856,3.90026>,<-2.07999,6.165,3.88797>,
            
    /*2*/ <-2.27438,6.55593,3.79984>

    /* stem 0.3c0.3.6*/ 
    /*0*/ <-2.20637,6.52129,4.02819>,
    /*1*/ <-2.20809,6.51947,4.03089>,<-2.20813,6.52395,4.02634>,<-2.20289,6.52045,4.02733>,
            
    /*2*/ <-2.09229,6.75682,4.25924>

    /* stem 0.3c0.3.7*/ 
    /*0*/ <-2.25188,6.62937,4.07986>,
    /*1*/ <-2.25223,6.63008,4.07821>,<-2.25123,6.63044,4.08119>,<-2.25218,6.6276,4.08017>,
            
    /*2*/ <-2.54947,6.69556,4.17134>

    /* stem 0.3c1*/ 
    /*0*/ <-0.70439,5.77792,2.74576>,
    /*1*/ <-0.72663,5.77691,2.7162>,<-0.69617,5.80691,2.72427>,<-0.67707,5.79685,2.76204>,
            <-0.69573,5.76064,2.77732>,<-0.72636,5.74831,2.74899>,
    /*2*/ <-1.05432,6.05006,2.9636>,<-1.03059,6.07343,2.96989>,<-1.01571,6.0656,2.99932>,
            <-1.03024,6.03738,3.01122>,<-1.05411,6.02778,2.98915>,
    /*3*/ <-1.32762,6.39325,3.19123>,<-1.30807,6.40743,3.19382>,<-1.29771,6.4021,3.21513>,
            <-1.31085,6.38463,3.2257>,<-1.32933,6.37916,3.21093>,
    /*4*/ <-1.59965,6.72689,3.43281>,<-1.5879,6.73551,3.43443>,<-1.58139,6.73199,3.44709>,
            <-1.58913,6.72118,3.45331>,<-1.60042,6.71803,3.44448>,
    /*5*/ <-1.85843,7.07558,3.6667>,<-1.85427,7.07842,3.66717>,<-1.85205,7.07723,3.67156>,
            <-1.85484,7.07366,3.67381>,<-1.85878,7.07264,3.6708>,
    /*6*/ <-1.85568,7.07551,3.67001>

    /* stem 0.3c1.0*/ 
    /*0*/ <-1.18343,6.23142,3.10302>,
    /*1*/ <-1.19874,6.23135,3.08386>,<-1.17345,6.25248,3.11066>,<-1.17809,6.21044,3.11453>,
            
    /*2*/ <-1.3336,6.25644,3.19472>,<-1.31085,6.27545,3.21884>,<-1.31502,6.23762,3.22232>,
            
    /*3*/ <-1.43464,6.34379,3.31531>,<-1.40679,6.35765,3.32897>,<-1.4186,6.32808,3.34082>,
            
    /*4*/ <-1.51997,6.46164,3.4142>,<-1.49417,6.47219,3.42455>,<-1.50803,6.45012,3.43887>,
            
    /*5*/ <-1.61328,6.57287,3.51339>,<-1.59185,6.58273,3.52304>,<-1.60312,6.56299,3.53457>,
            
    /*6*/ <-1.69567,6.71511,3.57249>,<-1.67747,6.72273,3.58032>,<-1.68991,6.71046,3.59239>,
            
    /*7*/ <-1.77676,6.86355,3.6207>,<-1.76223,6.86969,3.62701>,<-1.77269,6.86074,3.63695>,
            
    /*8*/ <-1.83976,7.01483,3.68997>,<-1.82812,7.01797,3.69409>,<-1.83594,7.01127,3.7016>,
            
    /*9*/ <-1.88228,7.17166,3.76012>,<-1.87422,7.1729,3.76248>,<-1.87964,7.16907,3.76777>,
            
    /*10*/ <-1.93156,7.33033,3.81819>,<-1.92759,7.33116,3.81945>,<-1.93033,7.32932,3.82213>,
            
    /*11*/ <-2.00258,7.48358,3.8679>

    /* stem 0.3c1.0.0*/ 
    /*0*/ <-1.28648,6.25037,3.18532>,
    /*1*/ <-1.28082,6.25695,3.19089>,<-1.29241,6.24339,3.19006>,<-1.28621,6.25077,3.17503>,
            
    /*2*/ <-1.79875,6.6875,3.18885>

    /* stem 0.3c1.0.1*/ 
    /*0*/ <-1.38855,6.31595,3.29181>,
    /*1*/ <-1.39315,6.30764,3.29403>,<-1.39369,6.32407,3.29004>,<-1.37879,6.31616,3.29135>,
            
    /*2*/ <-1.36282,6.46638,3.90722>

    /* stem 0.3c1.0.2*/ 
    /*0*/ <-1.56003,6.52289,3.47986>,
    /*1*/ <-1.55981,6.52871,3.47344>,<-1.55878,6.52543,3.48805>,<-1.5615,6.51454,3.47809>,
            
    /*2*/ <-2.10569,6.60691,3.53741>

    /* stem 0.3c1.0.3*/ 
    /*0*/ <-1.63129,6.62099,3.54318>,
    /*1*/ <-1.62791,6.61999,3.55058>,<-1.63924,6.62285,3.54252>,<-1.62671,6.62012,3.53643>,
            
    /*2*/ <-1.51351,7.1292,3.55791>

    /* stem 0.3c1.0.4*/ 
    /*0*/ <-1.71069,6.75735,3.59464>,
    /*1*/ <-1.71683,6.75516,3.59067>,<-1.708,6.76445,3.5939>,<-1.70725,6.75243,3.59935>,
            
    /*2*/ <-1.99558,6.90319,3.9551>

    /* stem 0.3c1.0.5*/ 
    /*0*/ <-1.78895,6.90774,3.64746>,
    /*1*/ <-1.78276,6.91086,3.64638>,<-1.7922,6.90842,3.65364>,<-1.79189,6.90393,3.64235>,
            
    /*2*/ <-1.9956,7.26593,3.49918>

    /* stem 0.3c1.0.6*/ 
    /*0*/ <-1.89238,7.21374,3.77855>,
    /*1*/ <-1.89456,7.21192,3.78171>,<-1.89413,7.21689,3.77631>,<-1.88845,7.21241,3.77764>,
            
    /*2*/ <-1.759,7.45088,4.00736>

    /* stem 0.3c1.0.7*/ 
    /*0*/ <-1.98056,7.43717,3.85338>,
    /*1*/ <-1.98064,7.43736,3.85266>,<-1.98039,7.43769,3.85388>,<-1.98065,7.43647,3.85359>,
            
    /*2*/ <-2.2677,7.48769,3.89819>

    /* stem 0.3c2*/ 
    /*0*/ <-0.92341,6.26026,3.57651>,
    /*1*/ <-0.93972,6.2588,3.56392>,<-0.92395,6.27725,3.56478>,<-0.90744,6.27221,3.58185>,
            <-0.913,6.25065,3.59154>,<-0.93295,6.24236,3.58046>,
    /*2*/ <-1.21403,6.48354,3.90662>,<-1.2045,6.49469,3.90714>,<-1.19453,6.49164,3.91746>,
            <-1.19789,6.47862,3.92331>,<-1.20994,6.47361,3.91661>,
    /*3*/ <-1.51964,6.66196,4.24906>,<-1.5167,6.66604,4.24962>,<-1.51334,6.66504,4.25326>,
            <-1.51419,6.66035,4.25495>,<-1.51809,6.65844,4.25235>,
    /*4*/ <-1.51639,6.66237,4.25185>

    /* stem 0.3c2.0*/ 
    /*0*/ <-1.28247,6.52904,3.99889>,
    /*1*/ <-1.2753,6.53602,4.00184>,<-1.28701,6.52291,4.006>,<-1.2851,6.5282,3.98883>,
            
    /*2*/ <-1.37884,6.63307,4.02026>,<-1.38938,6.62126,4.024>,<-1.38766,6.62603,4.00855>,
            
    /*3*/ <-1.47098,6.73998,4.03739>,<-1.48137,6.73058,4.04091>,<-1.47947,6.73443,4.02711>,
            
    /*4*/ <-1.55141,6.85501,4.06025>,<-1.56115,6.84764,4.06352>,<-1.55962,6.85111,4.05146>,
            
    /*5*/ <-1.62421,6.9716,4.09799>,<-1.63266,6.96547,4.1009>,<-1.63192,6.96922,4.09076>,
            
    /*6*/ <-1.68981,7.09316,4.13401>,<-1.69712,7.08852,4.13658>,<-1.69639,7.09144,4.12807>,
            
    /*7*/ <-1.74815,7.218,4.17147>,<-1.75415,7.21461,4.17363>,<-1.75357,7.21692,4.16681>,
            
    /*8*/ <-1.80217,7.34582,4.20589>,<-1.80676,7.34347,4.20757>,<-1.80626,7.34507,4.20242>,
            
    /*9*/ <-1.84117,7.47702,4.24643>,<-1.84433,7.47573,4.24764>,<-1.84403,7.47688,4.24423>,
            
    /*10*/ <-1.8533,7.61695,4.27179>,<-1.85494,7.61669,4.2725>,<-1.85475,7.61703,4.27073>,
            
    /*11*/ <-1.88551,7.75448,4.29562>

    /* stem 0.3c2.0.0*/ 
    /*0*/ <-1.31506,6.56003,4.00482>,
    /*1*/ <-1.31774,6.55688,4.00659>,<-1.31652,6.56254,4.00139>,<-1.31094,6.56066,4.00648>,
            
    /*2*/ <-1.519,6.93692,4.36765>

    /* stem 0.3c2.0.1*/ 
    /*0*/ <-1.51409,6.78842,4.04583>,
    /*1*/ <-1.51306,6.78984,4.04228>,<-1.51365,6.79066,4.04907>,<-1.51557,6.78476,4.04614>,
            
    /*2*/ <-1.96481,6.96516,3.98514>

    /* stem 0.3c2.0.2*/ 
    /*0*/ <-1.60894,6.93514,4.08564>,
    /*1*/ <-1.60759,6.93488,4.08901>,<-1.61248,6.93582,4.08514>,<-1.60675,6.93472,4.08276>,
            
    /*2*/ <-1.5247,7.37193,4.08608>

    /* stem 0.3c2.0.3*/ 
    /*0*/ <-1.66203,7.02992,4.11472>,
    /*1*/ <-1.66481,7.02899,4.11292>,<-1.66065,7.03305,4.11427>,<-1.66063,7.02773,4.11698>,
            
    /*2*/ <-1.90902,7.1823,4.41533>

    /* stem 0.3c2.0.4*/ 
    /*0*/ <-1.78423,7.29447,4.1917>,
    /*1*/ <-1.78162,7.29566,4.19128>,<-1.78595,7.29545,4.19381>,<-1.78512,7.29229,4.19>,
            
    /*2*/ <-1.92365,7.52203,3.97234>

    /* stem 0.3c2.0.5*/ 
    /*0*/ <-1.817,7.38607,4.21808>,
    /*1*/ <-1.8185,7.38501,4.22009>,<-1.81795,7.38817,4.21663>,<-1.81456,7.38502,4.21751>,
            
    /*2*/ <-1.68185,7.59014,4.4261>

    /* stem 0.3c2.0.6*/ 
    /*0*/ <-1.86597,7.66825,4.28061>,
    /*1*/ <-1.86601,7.66835,4.27997>,<-1.86562,7.66866,4.28099>,<-1.86627,7.66774,4.28088>,
            
    /*2*/ <-2.06978,7.80932,4.31666>

    /* stem 0.3.0*/ 
    /*0*/ <-0.10597,5.17597,0.3057>,
    /*1*/ <-0.06718,5.21373,0.32135>,<-0.10566,5.1243,0.32817>,<-0.14505,5.18988,0.26757>,
            
    /*2*/ <-0.25672,5.30705,0.54551>,<-0.29135,5.22656,0.55165>,<-0.3268,5.28558,0.49711>,
            
    /*3*/ <-0.44618,5.47688,0.70878>,<-0.48964,5.41425,0.72569>,<-0.5058,5.45705,0.66242>,
            
    /*4*/ <-0.57155,5.7074,0.84578>,<-0.61995,5.66663,0.87152>,<-0.6297,5.69744,0.81134>,
            
    /*5*/ <-0.66183,5.95316,0.99779>,<-0.70509,5.92277,1.02297>,<-0.71451,5.95065,0.97235>,
            
    /*6*/ <-0.73274,6.20134,1.16192>,<-0.7691,6.17735,1.18391>,<-0.77761,6.20215,1.14276>,
            
    /*7*/ <-0.79664,6.45866,1.31698>,<-0.82608,6.44093,1.3355>,<-0.83261,6.45959,1.30184>,
            
    /*8*/ <-0.86894,6.72025,1.46368>,<-0.89104,6.70694,1.47752>,<-0.89568,6.72009,1.45177>,
            
    /*9*/ <-0.87906,7.00682,1.56543>,<-0.89434,7.00254,1.5768>,<-0.89721,7.00893,1.55858>,
            
    /*10*/ <-0.92994,7.29353,1.67028>,<-0.93752,7.29041,1.67558>,<-0.93891,7.29351,1.66643>,
            
    /*11*/ <-1.00715,7.58374,1.74063>

    /* stem 0.3.0.0*/ 
    /*0*/ <-0.22434,5.23788,0.44962>,
    /*1*/ <-0.23073,5.21533,0.45406>,<-0.24091,5.25501,0.44873>,<-0.20139,5.24329,0.44606>,
            
    /*2*/ <-0.08936,5.42858,1.61112>

    /* stem 0.3.0.1*/ 
    /*0*/ <-0.33853,5.31684,0.57302>,
    /*1*/ <-0.34018,5.33172,0.55551>,<-0.332,5.32424,0.59383>,<-0.34341,5.29458,0.56972>,
            
    /*2*/ <-1.42752,5.51532,0.84408>

    /* stem 0.3.0.2*/ 
    /*0*/ <-0.42341,5.39607,0.64829>,
    /*1*/ <-0.41084,5.39226,0.66647>,<-0.44567,5.39362,0.64934>,<-0.41371,5.40232,0.62907>,
            
    /*2*/ <-0.52606,6.45791,0.94176>

    /* stem 0.3.0.3*/ 
    /*0*/ <-0.52142,5.52729,0.74547>,
    /*1*/ <-0.54074,5.52193,0.73747>,<-0.5137,5.54723,0.74256>,<-0.50983,5.51272,0.75637>,
            
    /*2*/ <-0.98151,5.83743,1.64887>

    /* stem 0.3.0.4*/ 
    /*0*/ <-0.66435,5.85669,0.94511>,
    /*1*/ <-0.64787,5.86594,0.93932>,<-0.67069,5.85855,0.96374>,<-0.67448,5.8456,0.93228>,
            
    /*2*/ <-1.18417,6.62466,0.69171>

    /* stem 0.3.0.5*/ 
    /*0*/ <-0.70554,5.98688,1.02705>,
    /*1*/ <-0.71182,5.97588,1.04129>,<-0.71664,6.00072,1.0201>,<-0.68817,5.98403,1.01977>,
            
    /*2*/ <-0.35153,6.57882,1.64058>

    /* stem 0.3.0.6*/ 
    /*0*/ <-0.74814,6.14913,1.13364>,
    /*1*/ <-0.75429,6.15736,1.11866>,<-0.73844,6.1585,1.14582>,<-0.75168,6.13154,1.13644>,
            
    /*2*/ <-1.48497,6.36447,1.55441>

    /* stem 0.3.0.7*/ 
    /*0*/ <-0.79298,6.34037,1.25068>,
    /*1*/ <-0.77844,6.33837,1.25952>,<-0.80741,6.34474,1.25881>,<-0.79308,6.338,1.23371>,
            
    /*2*/ <-0.61575,7.1337,1.13894>

    /* stem 0.3.0.8*/ 
    /*0*/ <-0.86127,6.62154,1.41188>,
    /*1*/ <-0.87633,6.61738,1.41247>,<-0.85729,6.63578,1.40681>,<-0.85019,6.61146,1.41636>,
            
    /*2*/ <-0.90553,6.88057,2.10473>

    /* stem 0.3.0.9*/ 
    /*0*/ <-0.88827,6.89333,1.52708>,
    /*1*/ <-0.87935,6.89682,1.51763>,<-0.8857,6.89591,1.54004>,<-0.89975,6.88725,1.52358>,
            
    /*2*/ <-1.18544,7.49003,1.46713>

    /* stem 0.3.0.10*/ 
    /*0*/ <-0.89704,7.04938,1.58263>,
    /*1*/ <-0.89734,7.04578,1.59241>,<-0.90438,7.05596,1.57927>,<-0.8894,7.04638,1.57622>,
            
    /*2*/ <-0.54674,7.53664,1.77245>

    /* stem 0.3.0.11*/ 
    /*0*/ <-0.92428,7.22173,1.64511>,
    /*1*/ <-0.92859,7.223,1.63971>,<-0.91921,7.22632,1.64673>,<-0.92503,7.21585,1.6489>,
            
    /*2*/ <-1.2921,7.50042,2.00454>

    /* stem 0.3.0.12*/ 
    /*0*/ <-0.95711,7.38047,1.69187>,
    /*1*/ <-0.95339,7.38113,1.69294>,<-0.96006,7.38162,1.6942>,<-0.95789,7.37865,1.68847>,
            
    /*2*/ <-0.96943,7.86186,1.43806>

    /* stem 0.3.1*/ 
    /*0*/ <-0.13841,5.17209,0.39544>,
    /*1*/ <-0.14483,5.11693,0.39074>,<-0.18162,5.20401,0.41027>,<-0.08878,5.19533,0.38532>,
            
    /*2*/ <-0.06867,5.08866,0.68398>,<-0.10179,5.16703,0.70156>,<-0.01823,5.15922,0.67911>,
            
    /*3*/ <0.02022,5.15055,0.98401>,<-0.01483,5.21929,0.98093>,<0.05932,5.2128,0.96036>,
            
    /*4*/ <0.105,5.28233,1.2568>,<0.07038,5.33829,1.24145>,<0.1354,5.3329,1.22387>,
            
    /*5*/ <0.14569,5.44243,1.51708>,<0.11491,5.48663,1.49578>,<0.17226,5.4848,1.48787>,
            
    /*6*/ <0.18061,5.6449,1.749>,<0.15407,5.67758,1.72538>,<0.20193,5.67636,1.71924>,
            
    /*7*/ <0.1588,5.87929,1.94865>,<0.13779,5.89959,1.92339>,<0.17626,5.90297,1.92364>,
            
    /*8*/ <0.13881,6.13193,2.12123>,<0.12323,6.14523,2.10076>,<0.15209,6.14751,2.10076>,
            
    /*9*/ <0.06838,6.37185,2.29412>,<0.05831,6.37972,2.27965>,<0.07708,6.38376,2.28166>,
            
    /*10*/ <0.01815,6.6001,2.48759>,<0.01286,6.60474,2.48098>,<0.02236,6.60634,2.48156>,
            
    /*11*/ <-0.02252,6.83486,2.67706>

    /* stem 0.3.1.0*/ 
    /*0*/ <-0.08942,5.15017,0.58538>,
    /*1*/ <-0.10192,5.16941,0.59082>,<-0.06943,5.14544,0.59695>,<-0.09692,5.13567,0.56838>,
            
    /*2*/ <-0.69262,4.53466,1.37609>

    /* stem 0.3.1.1*/ 
    /*0*/ <-0.0358,5.15624,0.78025>,
    /*1*/ <-0.01447,5.1505,0.77509>,<-0.04501,5.14926,0.79977>,<-0.04791,5.16896,0.7659>,
            
    /*2*/ <0.33636,6.08335,1.2877>

    /* stem 0.3.1.2*/ 
    /*0*/ <0.00833,5.18545,0.93012>,
    /*1*/ <-0.01029,5.17628,0.93739>,<0.01639,5.20332,0.94007>,<0.01888,5.17674,0.91291>,
            
    /*2*/ <0.57978,4.55525,1.5993>

    /* stem 0.3.1.3*/ 
    /*0*/ <0.04259,5.2259,1.04318>,
    /*1*/ <0.04892,5.24365,1.03297>,<0.05614,5.21566,1.05626>,<0.02272,5.2184,1.04032>,
            
    /*2*/ <-0.29451,5.81065,1.85037>

    /* stem 0.3.1.4*/ 
    /*0*/ <0.11687,5.36789,1.32536>,
    /*1*/ <0.12443,5.35146,1.33389>,<0.10575,5.38054,1.33614>,<0.12042,5.37167,1.30605>,
            
    /*2*/ <0.9187,5.86389,1.57007>

    /* stem 0.3.1.5*/ 
    /*0*/ <0.15574,5.53589,1.57676>,
    /*1*/ <0.13916,5.54345,1.57287>,<0.17003,5.5468,1.5817>,<0.15804,5.51743,1.57573>,
            
    /*2*/ <-0.08316,5.45762,2.44166>

    /* stem 0.3.1.6*/ 
    /*0*/ <0.16988,5.61559,1.67117>,
    /*1*/ <0.18734,5.61755,1.66691>,<0.16509,5.61209,1.68825>,<0.15722,5.61714,1.65837>,
            
    /*2*/ <0.11304,6.46983,1.83059>

    /* stem 0.3.1.7*/ 
    /*0*/ <0.16467,5.81837,1.86528>,
    /*1*/ <0.15459,5.80896,1.87488>,<0.16105,5.83458,1.86265>,<0.17837,5.81158,1.85829>,
            
    /*2*/ <0.59453,6.01944,2.51315>

    /* stem 0.3.1.8*/ 
    /*0*/ <0.14388,6.06769,2.05517>,
    /*1*/ <0.14318,6.07654,2.04262>,<0.15413,6.0708,2.06621>,<0.13433,6.05573,2.05669>,
            
    /*2*/ <-0.34179,6.49731,2.38528>

    /* stem 0.3.1.9*/ 
    /*0*/ <0.09233,6.29598,2.22333>,
    /*1*/ <0.10092,6.29181,2.23228>,<0.08059,6.30037,2.22708>,<0.09549,6.29576,2.21063>,
            
    /*2*/ <0.33599,6.90541,2.27325>

    /* stem 0.3.1.10*/ 
    /*0*/ <0.05478,6.43749,2.3371>,
    /*1*/ <0.04529,6.437,2.33525>,<0.05926,6.44608,2.3372>,<0.0598,6.42939,2.33884>,
            
    /*2*/ <-0.06446,6.4924,2.93657>

    /* stem 0.3.1.11*/ 
    /*0*/ <0.03055,6.54641,2.43294>,
    /*1*/ <0.03628,6.54969,2.43066>,<0.02942,6.5457,2.4398>,<0.02594,6.54383,2.42836>,
            
    /*2*/ <-0.25536,7.04915,2.43756>

    /* stem 0.3.1.12*/ 
    /*0*/ <0.00045,6.70316,2.5667>,
    /*1*/ <-0.00043,6.70111,2.56896>,<-0.00113,6.70589,2.56632>,<0.00292,6.70248,2.56482>,
            
    /*2*/ <0.32682,6.93929,2.90863>

    /* stem 0.3.2*/ 
    /*0*/ <-0.21769,5.19572,0.70507>,
    /*1*/ <-0.24422,5.2411,0.69435>,<-0.18099,5.1947,0.7442>,<-0.22785,5.15135,0.67666>,
            
    /*2*/ <-0.44804,5.16113,0.88713>,<-0.39112,5.11937,0.93199>,<-0.4333,5.08035,0.87122>,
            
    /*3*/ <-0.64134,5.16829,1.09028>,<-0.59621,5.13082,1.13595>,<-0.64352,5.094,1.09198>,
            
    /*4*/ <-0.7718,5.28138,1.31323>,<-0.73138,5.25043,1.35373>,<-0.78701,5.22214,1.33538>,
            
    /*5*/ <-0.83099,5.46666,1.52164>,<-0.79547,5.44074,1.55592>,<-0.84901,5.42528,1.55438>,
            
    /*6*/ <-0.86333,5.65856,1.73993>,<-0.83297,5.63502,1.76608>,<-0.87827,5.62492,1.7683>,
            
    /*7*/ <-0.87557,5.89064,1.90696>,<-0.85156,5.87537,1.93088>,<-0.88809,5.87019,1.93536>,
            
    /*8*/ <-0.88147,6.13799,2.05864>,<-0.86349,6.12755,2.07722>,<-0.89092,6.1245,2.08113>,
            
    /*9*/ <-0.8233,6.39779,2.17443>,<-0.81129,6.39011,2.18637>,<-0.82917,6.392,2.19109>,
            
    /*10*/ <-0.79073,6.65725,2.30437>,<-0.78471,6.65362,2.31045>,<-0.79379,6.65377,2.31242>,
            
    /*11*/ <-0.7785,6.9131,2.44423>

    /* stem 0.3.2.0*/ 
    /*0*/ <-0.33577,5.15258,0.81471>,
    /*1*/ <-0.31974,5.14465,0.82884>,<-0.35409,5.13988,0.80998>,<-0.33346,5.17321,0.8053>,
            
    /*2*/ <-0.87922,5.61159,1.68838>

    /* stem 0.3.2.1*/ 
    /*0*/ <-0.54395,5.12663,1.02036>,
    /*1*/ <-0.55866,5.11939,1.00647>,<-0.54812,5.14395,1.03238>,<-0.52506,5.11656,1.02224>,
            
    /*2*/ <-0.94905,4.50707,1.77256>

    /* stem 0.3.2.2*/ 
    /*0*/ <-0.65414,5.15495,1.15141>,
    /*1*/ <-0.64112,5.17104,1.15072>,<-0.65722,5.14489,1.16925>,<-0.66408,5.14893,1.13428>,
            
    /*2*/ <-1.41741,5.78242,1.37364>

    /* stem 0.3.2.3*/ 
    /*0*/ <-0.7426,5.23297,1.29933>,
    /*1*/ <-0.74423,5.21507,1.3078>,<-0.75824,5.24522,1.2989>,<-0.72532,5.23862,1.2913>,
            
    /*2*/ <-0.47121,5.60945,2.14809>

    /* stem 0.3.2.4*/ 
    /*0*/ <-0.78332,5.31354,1.40181>,
    /*1*/ <-0.79292,5.32432,1.38907>,<-0.77042,5.3217,1.41354>,<-0.78661,5.29459,1.40281>,
            
    /*2*/ <-1.45394,5.46358,2.03449>

    /* stem 0.3.2.5*/ 
    /*0*/ <-0.83392,5.49602,1.60078>,
    /*1*/ <-0.81697,5.49301,1.60613>,<-0.84732,5.49603,1.61284>,<-0.83747,5.49902,1.58336>,
            
    /*2*/ <-0.72189,6.34791,1.72467>

    /* stem 0.3.2.6*/ 
    /*0*/ <-0.86763,5.80623,1.874>,
    /*1*/ <-0.88276,5.80246,1.8782>,<-0.86423,5.82103,1.86852>,<-0.85591,5.7952,1.87528>,
            
    /*2*/ <-0.72671,6.03952,2.5919>

    /* stem 0.3.2.7*/ 
    /*0*/ <-0.87577,6.02571,2.01093>,
    /*1*/ <-0.86833,6.03245,1.99983>,<-0.87053,6.02638,2.02493>,<-0.88844,6.0183,2.00802>,
            
    /*2*/ <-1.24613,6.61625,2.12117>

    /* stem 0.3.2.8*/ 
    /*0*/ <-0.86168,6.20776,2.1053>,
    /*1*/ <-0.85901,6.2019,2.11774>,<-0.871,6.21818,2.10431>,<-0.85503,6.2032,2.09384>,
            
    /*2*/ <-0.38373,6.64505,2.20865>

    /* stem 0.3.2.9*/ 
    /*0*/ <-0.82946,6.35565,2.168>,
    /*1*/ <-0.83824,6.36009,2.16206>,<-0.81936,6.36115,2.1683>,<-0.83076,6.34572,2.17364>,
            
    /*2*/ <-1.01275,6.66451,2.66931>

    /* stem 0.3.2.10*/ 
    /*0*/ <-0.80607,6.51935,2.24425>,
    /*1*/ <-0.79797,6.51859,2.24379>,<-0.80956,6.52162,2.25126>,<-0.81068,6.51783,2.23771>,
            
    /*2*/ <-0.76378,7.06868,2.08706>

    /* stem 0.3.2.11*/ 
    /*0*/ <-0.78444,6.77663,2.37281>,
    /*1*/ <-0.7866,6.77586,2.37447>,<-0.7845,6.77914,2.37149>,<-0.78222,6.7749,2.37246>,
            
    /*2*/ <-0.55646,6.98968,2.76817>

    /* stem 0.3.3*/ 
    /*0*/ <-0.31196,5.24063,1.08382>,
    /*1*/ <-0.26553,5.22501,1.09835>,<-0.35362,5.21729,1.10201>,<-0.31673,5.27959,1.05109>,
            
    /*2*/ <-0.2769,5.40375,1.30879>,<-0.35619,5.39681,1.31208>,<-0.32298,5.45287,1.26625>,
            
    /*3*/ <-0.2533,5.59942,1.49757>,<-0.32332,5.59915,1.50808>,<-0.29493,5.64253,1.45986>,
            
    /*4*/ <-0.1809,5.79701,1.66739>,<-0.2398,5.80448,1.6851>,<-0.21731,5.83735,1.63763>,
            
    /*5*/ <-0.1259,6.04351,1.79217>,<-0.17681,6.04859,1.80642>,<-0.16015,6.06825,1.75999>,
            
    /*6*/ <-0.05315,6.26837,1.92962>,<-0.09492,6.27466,1.94281>,<-0.08059,6.29303,1.90518>,
            
    /*7*/ <-0.03649,6.51751,2.06056>,<-0.0712,6.51676,2.06748>,<-0.05943,6.53165,2.0376>,
            
    /*8*/ <-0.01393,6.77761,2.15256>,<-0.03985,6.77827,2.15832>,<-0.03137,6.786,2.13438>,
            
    /*9*/ <-0.03005,7.02668,2.27451>,<-0.04742,7.02455,2.27718>,<-0.04162,7.03221,2.26231>,
            
    /*10*/ <-0.05878,7.2605,2.41917>,<-0.06743,7.25895,2.42022>,<-0.06458,7.26361,2.41325>,
            
    /*11*/ <-0.0371,7.50912,2.53622>

    /* stem 0.3.3.0*/ 
    /*0*/ <-0.31648,5.35963,1.22612>,
    /*1*/ <-0.33729,5.35492,1.2294>,<-0.30985,5.38016,1.22665>,<-0.3023,5.3438,1.22233>,
            
    /*2*/ <-0.13312,5.27403,2.26727>

    /* stem 0.3.3.1*/ 
    /*0*/ <-0.30844,5.48911,1.36588>,
    /*1*/ <-0.29696,5.50037,1.35277>,<-0.30309,5.48786,1.38589>,<-0.32525,5.4791,1.35899>,
            
    /*2*/ <-0.87708,6.3047,1.56863>

    /* stem 0.3.3.2*/ 
    /*0*/ <-0.26942,5.66768,1.53588>,
    /*1*/ <-0.26688,5.65428,1.55001>,<-0.2778,5.68493,1.5401>,<-0.26359,5.66383,1.51753>,
            
    /*2*/ <0.58895,6.03688,1.7311>

    /* stem 0.3.3.3*/ 
    /*0*/ <-0.23202,5.76343,1.61992>,
    /*1*/ <-0.24555,5.77486,1.61292>,<-0.21487,5.7705,1.62423>,<-0.23563,5.74492,1.6226>,
            
    /*2*/ <-0.52216,5.94468,2.47687>

    /* stem 0.3.3.4*/ 
    /*0*/ <-0.18684,5.91935,1.71771>,
    /*1*/ <-0.16907,5.91611,1.7156>,<-0.19296,5.92678,1.73314>,<-0.19849,5.91515,1.70439>,
            
    /*2*/ <-0.08192,6.71921,1.37396>

    /* stem 0.3.3.5*/ 
    /*0*/ <-0.12199,6.14664,1.84399>,
    /*1*/ <-0.13442,6.14397,1.85525>,<-0.1185,6.16243,1.83877>,<-0.11304,6.13353,1.83794>,
            
    /*2*/ <0.4107,6.22974,2.45183>

    /* stem 0.3.3.6*/ 
    /*0*/ <-0.06228,6.44402,2.01377>,
    /*1*/ <-0.05975,6.45098,2.00027>,<-0.05336,6.44726,2.02589>,<-0.07372,6.43381,2.01514>,
            
    /*2*/ <-0.51726,6.97994,2.20501>

    /* stem 0.3.3.7*/ 
    /*0*/ <-0.04389,6.63383,2.09552>,
    /*1*/ <-0.03643,6.62895,2.10688>,<-0.05432,6.64364,2.09741>,<-0.04092,6.6289,2.08227>,
            
    /*2*/ <0.40953,7.13174,2.01167>

    /* stem 0.3.3.8*/ 
    /*0*/ <-0.03033,6.82316,2.16957>,
    /*1*/ <-0.04307,6.82467,2.16538>,<-0.02112,6.83262,2.16673>,<-0.02679,6.8122,2.17662>,
            
    /*2*/ <-0.17156,7.12194,2.70545>

    /* stem 0.3.3.9*/ 
    /*0*/ <-0.03708,6.97066,2.24291>,
    /*1*/ <-0.02644,6.97285,2.23947>,<-0.04054,6.974,2.25325>,<-0.04427,6.96512,2.23601>,
            
    /*2*/ <-0.21646,7.48518,2.01662>

    /* stem 0.3.3.10*/ 
    /*0*/ <-0.05114,7.13948,2.34134>,
    /*1*/ <-0.05488,7.13559,2.34694>,<-0.05333,7.14671,2.33951>,<-0.04521,7.13614,2.33758>,
            
    /*2*/ <0.29441,7.33796,2.7101>

    /* stem 0.3.3.11*/ 
    /*0*/ <-0.0515,7.37425,2.4717>,
    /*1*/ <-0.05206,7.37547,2.46927>,<-0.04965,7.37537,2.47344>,<-0.05281,7.37189,2.47241>,
            
    /*2*/ <-0.3994,7.62863,2.67871>

    /* stem 0.3.4*/ 
    /*0*/ <-0.37024,5.27291,1.30466>,
    /*1*/ <-0.41536,5.2545,1.29544>,<-0.36482,5.321,1.31549>,<-0.33054,5.24323,1.30304>,
            
    /*2*/ <-0.44144,5.20128,1.5561>,<-0.39595,5.26114,1.57414>,<-0.3651,5.19114,1.56294>,
            
    /*3*/ <-0.45431,5.26397,1.8252>,<-0.41196,5.3172,1.81541>,<-0.38641,5.25548,1.83156>,
            
    /*4*/ <-0.44244,5.38138,2.07207>,<-0.40573,5.42402,2.05084>,<-0.38286,5.37347,2.07403>,
            
    /*5*/ <-0.41407,5.52092,2.30214>,<-0.38327,5.5549,2.27862>,<-0.36309,5.51332,2.30143>,
            
    /*6*/ <-0.39002,5.7078,2.49486>,<-0.36494,5.7317,2.46947>,<-0.34741,5.70251,2.49564>,
            
    /*7*/ <-0.37698,5.93492,2.63807>,<-0.35717,5.94954,2.6141>,<-0.34278,5.93233,2.64012>,
            
    /*8*/ <-0.33173,6.16654,2.76898>,<-0.31721,6.17516,2.74951>,<-0.30635,6.1621,2.76889>,
            
    /*9*/ <-0.29943,6.38994,2.91038>,<-0.28958,6.39667,2.89802>,<-0.28242,6.38759,2.91072>,
            
    /*10*/ <-0.30157,6.61983,3.04475>,<-0.2966,6.62352,3.03879>,<-0.29302,6.61961,3.04555>,
            
    /*11*/ <-0.35509,6.85224,3.1638>

    /* stem 0.3.4.0*/ 
    /*0*/ <-0.38849,5.24007,1.45957>,
    /*1*/ <-0.37922,5.2583,1.46453>,<-0.3832,5.22246,1.4698>,<-0.40304,5.23945,1.44439>,
            
    /*2*/ <-1.1245,5.42457,2.15727>

    /* stem 0.3.4.1*/ 
    /*0*/ <-0.40594,5.23649,1.64371>,
    /*1*/ <-0.40179,5.21731,1.64848>,<-0.41899,5.2471,1.6549>,<-0.39704,5.24508,1.62773>,
            
    /*2*/ <0.33416,5.5398,2.21913>

    /* stem 0.3.4.2*/ 
    /*0*/ <-0.41584,5.30609,1.88167>,
    /*1*/ <-0.43095,5.31681,1.87706>,<-0.40206,5.31328,1.89276>,<-0.4145,5.28818,1.87519>,
            
    /*2*/ <-0.86145,5.00092,2.6332>

    /* stem 0.3.4.3*/ 
    /*0*/ <-0.41247,5.35936,1.99449>,
    /*1*/ <-0.39395,5.35983,1.99371>,<-0.42098,5.35545,2.01049>,<-0.42248,5.36279,1.97926>,
            
    /*2*/ <-0.42629,6.23089,2.19988>

    /* stem 0.3.4.4*/ 
    /*0*/ <-0.3959,5.47692,2.20588>,
    /*1*/ <-0.40858,5.46726,2.21297>,<-0.39462,5.49388,2.2098>,<-0.38449,5.46962,2.19488>,
            
    /*2*/ <0.10597,5.29061,2.84962>

    /* stem 0.3.4.5*/ 
    /*0*/ <-0.37684,5.62463,2.39326>,
    /*1*/ <-0.37518,5.63631,2.38192>,<-0.36769,5.62504,2.40682>,<-0.38765,5.61255,2.39104>,
            
    /*2*/ <-0.92458,6.04911,2.75009>

    /* stem 0.3.4.6*/ 
    /*0*/ <-0.36336,5.82274,2.55632>,
    /*1*/ <-0.3547,5.81578,2.56667>,<-0.37406,5.83256,2.56074>,<-0.36131,5.81988,2.54155>,
            
    /*2*/ <0.11231,6.35835,2.51854>

    /* stem 0.3.4.7*/ 
    /*0*/ <-0.33615,6.06787,2.70491>,
    /*1*/ <-0.34939,6.07139,2.70287>,<-0.32601,6.07642,2.70091>,<-0.33304,6.0558,2.71097>,
            
    /*2*/ <-0.3494,6.35551,3.28551>

    /* stem 0.3.4.8*/ 
    /*0*/ <-0.31262,6.2144,2.79239>,
    /*1*/ <-0.30083,6.21632,2.78711>,<-0.31476,6.21748,2.80489>,<-0.32227,6.2094,2.78515>,
            
    /*2*/ <-0.47808,6.77401,2.62635>

    /* stem 0.3.4.9*/ 
    /*0*/ <-0.30011,6.31437,2.85677>,
    /*1*/ <-0.30504,6.30911,2.86589>,<-0.30409,6.32469,2.85316>,<-0.29121,6.30932,2.85125>,
            
    /*2*/ <0.07087,6.58107,3.21081>

    /* stem 0.3.4.10*/ 
    /*0*/ <-0.29527,6.55855,3.00587>,
    /*1*/ <-0.29687,6.56164,3.0006>,<-0.29106,6.56106,3.00984>,<-0.29788,6.55296,3.00716>,
            
    /*2*/ <-0.67153,6.79223,3.2571>

    /* stem 0.3.4.11*/ 
    /*0*/ <-0.31333,6.68582,3.07689>,
    /*1*/ <-0.31051,6.68541,3.07904>,<-0.31652,6.68662,3.07827>,<-0.31296,6.68544,3.07336>,
            
    /*2*/ <-0.21486,7.14754,3.03695>

    /* stem 0.3.5*/ 
    /*0*/ <-0.43034,5.34411,1.58693>,
    /*1*/ <-0.40552,5.38412,1.57967>,<-0.41354,5.31066,1.61641>,<-0.47197,5.33753,1.5647>,
            
    /*2*/ <-0.52984,5.49114,1.77575>,<-0.53706,5.42503,1.80882>,<-0.58964,5.44921,1.76228>,
            
    /*3*/ <-0.65786,5.61585,1.95486>,<-0.66764,5.55984,1.98841>,<-0.71165,5.57939,1.94325>,
            
    /*4*/ <-0.75411,5.77563,2.11863>,<-0.76653,5.73232,2.15478>,<-0.80539,5.74923,2.11553>,
            
    /*5*/ <-0.81205,5.97857,2.24646>,<-0.82629,5.95093,2.285>,<-0.8591,5.9636,2.25016>,
            
    /*6*/ <-0.8582,6.19678,2.36647>,<-0.87062,6.1764,2.40013>,<-0.89794,6.18667,2.37097>,
            
    /*7*/ <-0.87567,6.4209,2.48314>,<-0.88571,6.40623,2.51095>,<-0.90787,6.41615,2.48859>,
            
    /*8*/ <-0.88183,6.64933,2.59568>,<-0.88936,6.6391,2.61693>,<-0.90602,6.64684,2.60032>,
            
    /*9*/ <-0.85201,6.89127,2.66076>,<-0.85674,6.88795,2.67622>,<-0.86794,6.89237,2.66494>,
            
    /*10*/ <-0.79519,7.12757,2.73877>,<-0.79758,7.12575,2.74645>,<-0.80301,7.12884,2.74107>,
            
    /*11*/ <-0.77664,7.36921,2.82191>

    /* stem 0.3.5.0*/ 
    /*0*/ <-0.50022,5.40778,1.69897>,
    /*1*/ <-0.49909,5.39052,1.70948>,<-0.51709,5.41894,1.69963>,<-0.48448,5.41387,1.6878>,
            
    /*2*/ <-0.14202,5.90347,2.47394>

    /* stem 0.3.5.1*/ 
    /*0*/ <-0.63493,5.53985,1.89961>,
    /*1*/ <-0.64558,5.54807,1.88617>,<-0.6267,5.5505,1.91305>,<-0.63251,5.521,1.89962>,
            
    /*2*/ <-1.38049,5.44436,2.43191>

    /* stem 0.3.5.2*/ 
    /*0*/ <-0.72324,5.66184,2.03904>,
    /*1*/ <-0.70694,5.66356,2.04669>,<-0.73809,5.66142,2.04936>,<-0.7247,5.66055,2.02105>,
            
    /*2*/ <-0.78769,6.52913,1.98183>

    /* stem 0.3.5.3*/ 
    /*0*/ <-0.80733,5.87106,2.20292>,
    /*1*/ <-0.82244,5.86468,2.20666>,<-0.80603,5.88686,2.19731>,<-0.79352,5.86163,2.2048>,
            
    /*2*/ <-0.73109,6.13325,2.95916>

    /* stem 0.3.5.4*/ 
    /*0*/ <-0.84754,6.04199,2.30198>,
    /*1*/ <-0.84023,6.04972,2.29015>,<-0.84436,6.04576,2.31711>,<-0.85802,6.03049,2.29868>,
            
    /*2*/ <-1.40433,6.55267,2.29167>

    /* stem 0.3.5.5*/ 
    /*0*/ <-0.86601,6.13726,2.35284>,
    /*1*/ <-0.8628,6.13065,2.36639>,<-0.87728,6.14773,2.35186>,<-0.85797,6.1334,2.34028>,
            
    /*2*/ <-0.38607,6.66701,2.49742>

    /* stem 0.3.5.6*/ 
    /*0*/ <-0.8821,6.29135,2.43208>,
    /*1*/ <-0.89364,6.29481,2.4238>,<-0.87219,6.30155,2.43543>,<-0.88047,6.27768,2.437>,
            
    /*2*/ <-1.23898,6.4523,2.99719>

    /* stem 0.3.5.7*/ 
    /*0*/ <-0.8911,6.53188,2.55028>,
    /*1*/ <-0.87774,6.53223,2.54986>,<-0.89761,6.53731,2.56062>,<-0.89796,6.52609,2.54036>,
            
    /*2*/ <-0.9151,7.0768,2.24905>

    /* stem 0.3.5.8*/ 
    /*0*/ <-0.87753,6.75403,2.63227>,
    /*1*/ <-0.88633,6.75309,2.64064>,<-0.87744,6.76347,2.62457>,<-0.86882,6.74554,2.63161>,
            
    /*2*/ <-0.5621,7.04916,2.99763>

    /* stem 0.3.5.9*/ 
    /*0*/ <-0.83035,7.00265,2.70271>,
    /*1*/ <-0.82945,7.00462,2.69577>,<-0.82567,7.00496,2.70778>,<-0.83593,6.99838,2.70459>,
            
    /*2*/ <-1.11554,7.4091,2.78068>

    /* stem 0.3.5.10*/ 
    /*0*/ <-0.79188,7.2013,2.76649>,
    /*1*/ <-0.79012,7.20028,2.7691>,<-0.79437,7.20344,2.76692>,<-0.79116,7.20019,2.76346>,
            
    /*2*/ <-0.50619,7.54604,2.70784>

    /* stem 0.3.6*/ 
    /*0*/ <-0.52568,5.48691,2.06084>,
    /*1*/ <-0.51964,5.44528,2.07479>,<-0.56505,5.50656,2.06612>,<-0.49234,5.50889,2.04161>,
            
    /*2*/ <-0.45175,5.53004,2.28423>,<-0.49262,5.58519,2.27642>,<-0.42718,5.58729,2.25436>,
            
    /*3*/ <-0.38502,5.6461,2.485>,<-0.42341,5.69228,2.47213>,<-0.36545,5.69399,2.45189>,
            
    /*4*/ <-0.33317,5.78275,2.67493>,<-0.3681,5.82017,2.6586>,<-0.31679,5.82261,2.64282>,
            
    /*5*/ <-0.26644,5.9156,2.85768>,<-0.2962,5.94857,2.8455>,<-0.2531,5.94933,2.82929>,
            
    /*6*/ <-0.16976,6.0749,3.00818>,<-0.19543,6.10138,2.99755>,<-0.16193,6.09859,2.97902>,
            
    /*7*/ <-0.07992,6.24881,3.14347>,<-0.10143,6.26832,3.13352>,<-0.07467,6.26608,3.11864>,
            
    /*8*/ <-0.00873,6.44291,3.2618>,<-0.0259,6.45523,3.25264>,<-0.00549,6.45422,3.24201>,
            
    /*9*/ <0.02954,6.65616,3.36029>,<0.01748,6.66203,3.35283>,<0.03142,6.66249,3.34643>,
            
    /*10*/ <0.04495,6.85618,3.48321>,<0.03893,6.8591,3.47945>,<0.04603,6.8602,3.47676>,
            
    /*11*/ <0.056,7.06376,3.59529>

    /* stem 0.3.6.0*/ 
    /*0*/ <-0.49161,5.527,2.1657>,
    /*1*/ <-0.5051,5.54023,2.16502>,<-0.47386,5.5318,2.1701>,<-0.49588,5.50896,2.16199>,
            
    /*2*/ <-0.67327,5.38734,3.05189>

    /* stem 0.3.6.1*/ 
    /*0*/ <-0.43344,5.60712,2.34301>,
    /*1*/ <-0.41616,5.60485,2.33852>,<-0.43924,5.60214,2.3593>,<-0.44493,5.61437,2.33121>,
            
    /*2*/ <-0.25008,6.39653,2.64961>

    /* stem 0.3.6.2*/ 
    /*0*/ <-0.37399,5.72113,2.53269>,
    /*1*/ <-0.38632,5.71342,2.54142>,<-0.37209,5.73795,2.53374>,<-0.36355,5.71201,2.52291>,
            
    /*2*/ <0.13058,5.62486,3.16081>

    /* stem 0.3.6.3*/ 
    /*0*/ <-0.30339,5.87748,2.75764>,
    /*1*/ <-0.3014,5.88988,2.74826>,<-0.29346,5.87495,2.76951>,<-0.31531,5.8676,2.75515>,
            
    /*2*/ <-0.73475,6.28503,3.20551>

    /* stem 0.3.6.4*/ 
    /*0*/ <-0.21201,6.03359,2.93803>,
    /*1*/ <-0.20402,6.02294,2.94379>,<-0.22002,6.0421,2.94661>,<-0.21198,6.03572,2.92368>,
            
    /*2*/ <0.31363,6.46298,3.00278>

    /* stem 0.3.6.5*/ 
    /*0*/ <-0.14027,6.15807,3.04862>,
    /*1*/ <-0.15268,6.16366,3.04989>,<-0.12927,6.16607,3.04732>,<-0.13886,6.14447,3.04866>,
            
    /*2*/ <-0.0715,6.16676,3.68309>

    /* stem 0.3.6.6*/ 
    /*0*/ <-0.0432,6.37217,3.20231>,
    /*1*/ <-0.03316,6.37291,3.19513>,<-0.04206,6.37278,3.2146>,<-0.05437,6.37081,3.19719>,
            
    /*2*/ <-0.10163,6.93938,3.17931>

    /* stem 0.3.6.7*/ 
    /*0*/ <0.00747,6.56124,3.30543>,
    /*1*/ <0.00429,6.55718,3.3151>,<0.0028,6.57035,3.30151>,<0.01532,6.5562,3.29968>,
            
    /*2*/ <0.36626,6.84773,3.54391>

    /* stem 0.3.6.8*/ 
    /*0*/ <0.03304,6.73991,3.40407>,
    /*1*/ <0.03041,6.74361,3.39864>,<0.03857,6.74242,3.40772>,<0.03015,6.7337,3.40586>,
            
    /*2*/ <-0.25939,6.96002,3.6955>

    /* stem 0.3.6.9*/ 
    /*0*/ <0.04905,6.95141,3.53208>,
    /*1*/ <0.05119,6.95075,3.53302>,<0.04745,6.9526,3.53346>,<0.04852,6.95088,3.52978>,
            
    /*2*/ <0.21054,7.30694,3.41252>

    /* stem 0.3.7*/ 
    /*0*/ <-0.64479,5.675,2.539>,
    /*1*/ <-0.67316,5.69716,2.51979>,<-0.61175,5.6932,2.55455>,<-0.64946,5.63463,2.54266>,
            
    /*2*/ <-0.77394,5.72383,2.70805>,<-0.71867,5.72027,2.73934>,<-0.75261,5.66755,2.72864>,
            
    /*3*/ <-0.85979,5.79429,2.88899>,<-0.80974,5.79102,2.91509>,<-0.84486,5.74673,2.91566>,
            
    /*4*/ <-0.95795,5.88164,3.05447>,<-0.91632,5.87992,3.08114>,<-0.948,5.84194,3.08226>,
            
    /*5*/ <-1.05504,5.97997,3.21843>,<-1.01939,5.97849,3.24134>,<-1.04746,5.94679,3.24372>,
            
    /*6*/ <-1.12754,6.12058,3.36099>,<-1.09725,6.11873,3.37909>,<-1.12391,6.09693,3.387>,
            
    /*7*/ <-1.18742,6.2674,3.50747>,<-1.16262,6.26489,3.5208>,<-1.18442,6.24853,3.52831>,
            
    /*8*/ <-1.23399,6.43549,3.63122>,<-1.21541,6.43369,3.64126>,<-1.23248,6.42351,3.64865>,
            
    /*9*/ <-1.23559,6.61669,3.74888>,<-1.22287,6.6136,3.75421>,<-1.23456,6.60921,3.76084>,
            
    /*10*/ <-1.25443,6.8002,3.85846>,<-1.24811,6.79919,3.86147>,<-1.25395,6.79673,3.8646>,
            
    /*11*/ <-1.29626,6.97891,3.97048>

    /* stem 0.3.7.0*/ 
    /*0*/ <-0.70919,5.69295,2.65482>,
    /*1*/ <-0.69406,5.69497,2.66292>,<-0.72104,5.68211,2.66121>,<-0.71248,5.70178,2.64033>,
            
    /*2*/ <-1.03186,6.30993,3.10392>

    /* stem 0.3.7.1*/ 
    /*0*/ <-0.79993,5.74607,2.82942>,
    /*1*/ <-0.81183,5.73493,2.82806>,<-0.80371,5.76191,2.83098>,<-0.78426,5.74138,2.82924>,
            
    /*2*/ <-0.81449,5.66642,3.60454>

    /* stem 0.3.7.2*/ 
    /*0*/ <-0.87259,5.80773,2.96233>,
    /*1*/ <-0.86863,5.82189,2.95706>,<-0.86948,5.80375,2.9771>,<-0.87967,5.79756,2.95283>,
            
    /*2*/ <-1.53189,6.07021,3.17221>

    /* stem 0.3.7.3*/ 
    /*0*/ <-0.98109,5.90845,3.13799>,
    /*1*/ <-0.97633,5.89827,3.14725>,<-0.99516,5.91222,3.13791>,<-0.97178,5.91487,3.12881>,
            
    /*2*/ <-0.85434,6.39279,3.60532>

    /* stem 0.3.7.4*/ 
    /*0*/ <-1.0751,6.03392,3.29887>,
    /*1*/ <-1.08563,6.03635,3.29075>,<-1.06894,6.04415,3.3052>,<-1.07074,6.02125,3.30066>,
            
    /*2*/ <-1.46752,5.9678,3.78796>

    /* stem 0.3.7.5*/ 
    /*0*/ <-1.15999,6.21681,3.47687>,
    /*1*/ <-1.14832,6.22028,3.47833>,<-1.16753,6.2164,3.48654>,<-1.16414,6.21375,3.46574>,
            
    /*2*/ <-1.30827,6.75503,3.38396>

    /* stem 0.3.7.6*/ 
    /*0*/ <-1.19274,6.31093,3.55493>,
    /*1*/ <-1.20089,6.30465,3.56045>,<-1.19551,6.32127,3.55028>,<-1.18184,6.30687,3.55407>,
            
    /*2*/ <-1.06631,6.55231,4.01589>

    /* stem 0.3.7.7*/ 
    /*0*/ <-1.22851,6.49067,3.67785>,
    /*1*/ <-1.22744,6.4963,3.66891>,<-1.22232,6.49277,3.68622>,<-1.23577,6.48294,3.67842>,
            
    /*2*/ <-1.55391,6.80822,3.83857>

    /* stem 0.3.7.8*/ 
    /*0*/ <-1.2405,6.69638,3.80257>,
    /*1*/ <-1.23698,6.69406,3.8073>,<-1.24555,6.69998,3.80385>,<-1.23896,6.69511,3.79657>,
            
    /*2*/ <-0.99621,7.04321,3.79124>

    /* stem 0.3.7.9*/ 
    /*0*/ <-1.27391,6.88757,3.91524>,
    /*1*/ <-1.27585,6.88752,3.91454>,<-1.27284,6.88935,3.91522>,<-1.27302,6.88585,3.91597>,
            
    /*2*/ <-1.39866,6.9667,4.25494>

    /* stem 0.3.8*/ 
    /*0*/ <-0.74907,5.88122,2.90707>,
    /*1*/ <-0.71636,5.88257,2.91527>,<-0.77145,5.86865,2.92897>,<-0.75939,5.89246,2.87697>,
            
    /*2*/ <-0.74625,6.0632,2.99105>,<-0.79583,6.05068,3.00338>,<-0.78498,6.07211,2.95658>,
            
    /*3*/ <-0.75274,6.23725,3.07717>,<-0.79708,6.22992,3.0901>,<-0.78775,6.25053,3.04917>,
            
    /*4*/ <-0.78648,6.40206,3.18725>,<-0.82476,6.38979,3.19489>,<-0.81691,6.41321,3.16227>,
            
    /*5*/ <-0.86102,6.56445,3.28397>,<-0.89233,6.54893,3.28684>,<-0.88513,6.56883,3.25888>,
            
    /*6*/ <-0.94215,6.72671,3.36637>,<-0.96803,6.71328,3.36837>,<-0.96139,6.72873,3.34446>,
            
    /*7*/ <-1.01568,6.88509,3.45828>,<-1.03655,6.87473,3.46017>,<-1.03167,6.88786,3.44145>,
            
    /*8*/ <-1.08435,7.03172,3.57132>,<-1.0999,7.02373,3.57269>,<-1.09701,7.03512,3.55967>,
            
    /*9*/ <-1.15183,7.1863,3.67539>,<-1.1623,7.18123,3.67647>,<-1.16013,7.18828,3.6674>,
            
    /*10*/ <-1.2001,7.3552,3.76595>,<-1.20554,7.35326,3.76687>,<-1.20428,7.35623,3.76199>,
            
    /*11*/ <-1.23104,7.54166,3.82496>

    /* stem 0.3.8.0*/ 
    /*0*/ <-0.76965,6.02096,2.96628>,
    /*1*/ <-0.78205,6.01682,2.97175>,<-0.76823,6.03406,2.96105>,<-0.75866,6.01201,2.96605>,
            
    /*2*/ <-0.5529,6.26947,3.6463>

    /* stem 0.3.8.1*/ 
    /*0*/ <-0.7769,6.12332,3.01429>,
    /*1*/ <-0.77187,6.1291,3.00291>,<-0.77141,6.12631,3.02649>,<-0.78741,6.11456,3.01345>,
            
    /*2*/ <-1.24447,6.67697,3.08892>

    /* stem 0.3.8.2*/ 
    /*0*/ <-0.79041,6.29958,3.11276>,
    /*1*/ <-0.7863,6.2933,3.12323>,<-0.80073,6.30726,3.11349>,<-0.78419,6.29819,3.10156>,
            
    /*2*/ <-0.38875,6.8248,3.27046>

    /* stem 0.3.8.3*/ 
    /*0*/ <-0.84871,6.4909,3.23481>,
    /*1*/ <-0.85809,6.49115,3.22746>,<-0.84376,6.50109,3.23851>,<-0.84428,6.48045,3.23845>,
            
    /*2*/ <-1.23274,6.49919,3.72553>

    /* stem 0.3.8.4*/ 
    /*0*/ <-0.93526,6.67714,3.33626>,
    /*1*/ <-0.92522,6.68144,3.33725>,<-0.94244,6.67801,3.34451>,<-0.93812,6.67196,3.32703>,
            
    /*2*/ <-1.12423,7.16732,3.11985>

    /* stem 0.3.8.5*/ 
    /*0*/ <-1.07212,6.98164,3.53021>,
    /*1*/ <-1.07779,6.97568,3.53463>,<-1.07533,6.98995,3.52743>,<-1.06323,6.97928,3.52856>,
            
    /*2*/ <-0.94494,7.17034,3.94748>

    /* stem 0.3.8.6*/ 
    /*0*/ <-1.11261,7.07565,3.59873>,
    /*1*/ <-1.11242,7.08065,3.59148>,<-1.10862,7.07841,3.60609>,<-1.1168,7.0679,3.59863>,
            
    /*2*/ <-1.48886,7.27698,3.72745>

    /* stem 0.3.8.7*/ 
    /*0*/ <-1.18243,7.27657,3.72252>,
    /*1*/ <-1.17952,7.2753,3.7263>,<-1.18678,7.27871,3.72338>,<-1.18097,7.27569,3.71789>,
            
    /*2*/ <-1.01384,7.62414,3.70984>

    /* stem 0.3.8.8*/ 
    /*0*/ <-1.21311,7.42091,3.78615>,
    /*1*/ <-1.2152,7.4208,3.78553>,<-1.21186,7.42256,3.78548>,<-1.21227,7.41936,3.78744>,
            
    /*2*/ <-1.30575,7.60512,4.06617>

    /* stem 0.4*/ 
    /*0*/ <0.00366,5.51095,-0.03242>,
    /*1*/ <0.08779,5.51217,-0.06309>,<0.02621,5.59621,-0.048>,<-0.06654,5.56243,-0.01138>,
            <-0.06228,5.45751,-0.00384>,<0.0331,5.42644,-0.0358>,
    /*2*/ <-0.09559,5.47025,-0.54296>,<-0.15133,5.54631,-0.5293>,<-0.23526,5.51574,-0.49616>,
            <-0.2314,5.42078,-0.48934>,<-0.14508,5.39267,-0.51826>,
    /*3*/ <-0.22274,5.39931,-1.0284>,<-0.27524,5.46643,-1.02523>,<-0.35245,5.43844,-1.00229>,
            <-0.34768,5.35401,-0.99127>,<-0.26751,5.32983,-1.00741>,
    /*4*/ <-0.34818,5.37372,-1.52676>,<-0.39337,5.43345,-1.51921>,<-0.46222,5.40848,-1.50182>,
            <-0.45958,5.33331,-1.49862>,<-0.3891,5.31183,-1.51403>,
    /*5*/ <-0.459,5.3043,-2.02367>,<-0.49934,5.35561,-2.02248>,<-0.55901,5.334,-2.00722>,
            <-0.55555,5.26934,-1.99897>,<-0.49374,5.25099,-2.00914>,
    /*6*/ <-0.61968,5.23897,-2.5147>,<-0.65301,5.28283,-2.51018>,<-0.7023,5.26508,-2.49257>,
            <-0.69943,5.21025,-2.4862>,<-0.64837,5.19411,-2.49988>,
    /*7*/ <-0.78684,5.19779,-3.00119>,<-0.81353,5.23392,-2.99554>,<-0.85392,5.21936,-2.98118>,
            <-0.85219,5.17424,-2.97796>,<-0.81073,5.16091,-2.99032>,
    /*8*/ <-0.91423,5.17775,-3.49704>,<-0.93513,5.20589,-3.49316>,<-0.96745,5.19441,-3.48496>,
            <-0.96653,5.15918,-3.48377>,<-0.93364,5.14888,-3.49124>,
    /*9*/ <-1.01373,5.1675,-4.00093>,<-1.02878,5.18766,-3.99861>,<-1.05226,5.17942,-3.99422>,
            <-1.05172,5.15416,-3.99381>,<-1.02791,5.14679,-3.99796>,
    /*10*/ <-1.13092,5.14009,-4.50288>,<-1.14004,5.15226,-4.50156>,<-1.15409,5.1473,-4.49826>,
            <-1.15366,5.13205,-4.49753>,<-1.13934,5.1276,-4.50038>,
    /*11*/ <-1.24907,5.12987,-5.00449>,<-1.25218,5.13407,-5.00389>,<-1.25704,5.13235,-5.0028>,
            <-1.25692,5.12709,-5.00272>,<-1.252,5.12555,-5.00376>,
    /*12*/ <-1.25344,5.12979,-5.00353>

    /* stem 0.4c0*/ 
    /*0*/ <-0.41049,5.37216,-1.51209>,
    /*1*/ <-0.34812,5.37372,-1.49767>,<-0.39314,5.43349,-1.50591>,<-0.46214,5.4085,-1.52269>,
            <-0.45976,5.33329,-1.52481>,<-0.3893,5.3118,-1.50935>,
    /*2*/ <-0.24083,5.39132,-2.00149>,<-0.27987,5.44314,-2.00864>,<-0.33969,5.42147,-2.02319>,
            <-0.33763,5.35626,-2.02503>,<-0.27653,5.33762,-2.01162>,
    /*3*/ <-0.13932,5.46421,-2.50193>,<-0.17348,5.50765,-2.50308>,<-0.22382,5.48942,-2.51684>,
            <-0.22076,5.43472,-2.52419>,<-0.16854,5.41915,-2.51497>,
    /*4*/ <-0.01049,5.55564,-2.98967>,<-0.03839,5.59128,-2.99082>,<-0.07891,5.57688,-3.00497>,
            <-0.07606,5.53234,-3.01256>,<-0.03377,5.51921,-3.00311>,
    /*5*/ <0.1161,5.66259,-3.47788>,<0.09412,5.69017,-3.4779>,<0.0626,5.67899,-3.48911>,
            <0.0651,5.64449,-3.49602>,<0.09816,5.63436,-3.48908>,
    /*6*/ <0.24227,5.7851,-3.96232>,<0.22636,5.80473,-3.96176>,<0.20386,5.79678,-3.97006>,
            <0.20585,5.77224,-3.97574>,<0.22959,5.76503,-3.97096>,
    /*7*/ <0.36161,5.94857,-4.43649>,<0.35173,5.96013,-4.43515>,<0.33821,5.95541,-4.44044>,
            <0.33974,5.94094,-4.44505>,<0.3542,5.93671,-4.4426>,
    /*8*/ <0.50324,6.14964,-4.88865>,<0.49979,6.15357,-4.88804>,<0.49523,6.15208,-4.89022>,
            <0.49586,6.14724,-4.89218>,<0.50081,6.14572,-4.89121>,
    /*9*/ <0.49899,6.14965,-4.89006>

    /* stem 0.4c0c0*/ 
    /*0*/ <0.22159,5.78478,-3.96817>,
    /*1*/ <0.24295,5.78511,-3.97047>,<0.22832,5.8049,-3.96477>,<0.20438,5.79688,-3.96377>,
            <0.20422,5.77213,-3.96885>,<0.22806,5.76485,-3.97299>,
    /*2*/ <0.17897,5.88842,-4.47136>,<0.17013,5.90038,-4.46791>,<0.15566,5.89554,-4.46731>,
            <0.15556,5.88058,-4.47038>,<0.16997,5.87619,-4.47288>,
    /*3*/ <0.15422,6.05316,-4.9581>,<0.1512,6.05721,-4.95663>,<0.14617,6.05569,-4.95697>,
            <0.14608,6.05071,-4.95865>,<0.15106,6.04914,-4.95935>,
    /*4*/ <0.14975,6.05318,-4.95794>

    /* stem 0.4c0c0.0*/ 
    /*0*/ <0.1815,5.85945,-4.33041>,
    /*1*/ <0.19313,5.84997,-4.33365>,<0.18259,5.87438,-4.33382>,<0.16878,5.85401,-4.32376>,
            
    /*2*/ <0.13025,5.82333,-4.47398>,<0.12076,5.8453,-4.47413>,<0.10833,5.82697,-4.46508>,
            
    /*3*/ <0.0778,5.86282,-4.61866>,<0.07202,5.88198,-4.61146>,<0.05821,5.86581,-4.61093>,
            
    /*4*/ <0.03949,5.91577,-4.76032>,<0.03454,5.93216,-4.75303>,<0.02196,5.91854,-4.75471>,
            
    /*5*/ <0.01774,6.02082,-4.87644>,<0.01438,6.03214,-4.86571>,<0.00267,6.02312,-4.87171>,
            
    /*6*/ <-0.02137,6.13735,-4.97514>,<-0.02368,6.14543,-4.96484>,<-0.03352,6.13796,-4.96977>,
            
    /*7*/ <-0.05684,6.26028,-5.06501>,<-0.05854,6.26623,-5.05636>,<-0.06655,6.26075,-5.06069>,
            
    /*8*/ <-0.09694,6.38879,-5.14488>,<-0.09805,6.39277,-5.13805>,<-0.10412,6.3888,-5.14139>,
            
    /*9*/ <-0.16335,6.51531,-5.20955>,<-0.16387,6.51755,-5.20475>,<-0.16777,6.5145,-5.20671>,
            
    /*10*/ <-0.21445,6.64307,-5.28257>,<-0.21477,6.6443,-5.28024>,<-0.21677,6.6429,-5.28129>,
            
    /*11*/ <-0.2644,6.77725,-5.34489>

    /* stem 0.4c0c0.0.0*/ 
    /*0*/ <0.14946,5.84513,-4.40342>,
    /*1*/ <0.14785,5.85145,-4.40395>,<0.14531,5.84051,-4.40545>,<0.15524,5.84343,-4.40085>,
            
    /*2*/ <0.39976,5.86261,-4.9537>

    /* stem 0.4c0c0.0.1*/ 
    /*0*/ <0.05105,5.89566,-4.68342>,
    /*1*/ <0.04788,5.89086,-4.68434>,<0.05524,5.89714,-4.68717>,<0.05002,5.89897,-4.67875>,
            
    /*2*/ <-0.29948,6.1807,-4.96237>

    /* stem 0.4c0c0.0.2*/ 
    /*0*/ <0.02208,5.97231,-4.81203>,
    /*1*/ <0.02736,5.97363,-4.81178>,<0.01834,5.97618,-4.81285>,<0.02055,5.96711,-4.81146>,
            
    /*2*/ <0.06166,5.90747,-5.29982>

    /* stem 0.4c0c0.0.3*/ 
    /*0*/ <-0.00724,6.08265,-4.92046>,
    /*1*/ <-0.01152,6.08347,-4.91786>,<-0.00727,6.08291,-4.92553>,<-0.00295,6.08156,-4.918>,
            
    /*2*/ <0.09222,6.52683,-4.89798>

    /* stem 0.4c0c0.0.4*/ 
    /*0*/ <-0.07299,6.3028,-5.08622>,
    /*1*/ <-0.07167,6.30086,-5.08992>,<-0.07156,6.30682,-5.08521>,<-0.07575,6.30071,-5.08353>,
            
    /*2*/ <-0.37421,6.45733,-5.27509>

    /* stem 0.4c0c0.0.5*/ 
    /*0*/ <-0.14606,6.47934,-5.18799>,
    /*1*/ <-0.14477,6.48136,-5.18541>,<-0.14945,6.47959,-5.18888>,<-0.14396,6.47708,-5.18967>,
            
    /*2*/ <-0.06994,6.71717,-5.41199>

    /* stem 0.4c0c0.0.6*/ 
    /*0*/ <-0.24594,6.72691,-5.32099>,
    /*1*/ <-0.24643,6.72665,-5.32115>,<-0.24568,6.72728,-5.32135>,<-0.24571,6.7268,-5.32047>,
            
    /*2*/ <-0.3827,6.92636,-5.21566>

    /* stem 0.4c0.0*/ 
    /*0*/ <-0.33643,5.38357,-1.83368>,
    /*1*/ <-0.3119,5.34289,-1.82947>,<-0.31489,5.42281,-1.85009>,<-0.38251,5.385,-1.82147>,
            
    /*2*/ <-0.37967,5.28287,-2.06884>,<-0.38235,5.3548,-2.0874>,<-0.44321,5.32077,-2.06163>,
            
    /*3*/ <-0.44919,5.31504,-2.32689>,<-0.44552,5.38067,-2.32013>,<-0.50267,5.34944,-2.30892>,
            
    /*4*/ <-0.49551,5.43966,-2.55816>,<-0.48837,5.49098,-2.53251>,<-0.54093,5.46703,-2.53512>,
            
    /*5*/ <-0.53169,5.60338,-2.75833>,<-0.52428,5.64239,-2.72868>,<-0.57004,5.62449,-2.7351>,
            
    /*6*/ <-0.57974,5.79962,-2.92391>,<-0.57227,5.82729,-2.89418>,<-0.6106,5.81305,-2.89998>,
            
    /*7*/ <-0.58128,6.02194,-3.05526>,<-0.57494,6.0389,-3.02762>,<-0.60619,6.03329,-3.03677>,
            
    /*8*/ <-0.54592,6.26401,-3.13901>,<-0.54168,6.27179,-3.11587>,<-0.56472,6.27202,-3.12498>,
            
    /*9*/ <-0.5297,6.51766,-3.18508>,<-0.52713,6.52067,-3.16904>,<-0.54252,6.52056,-3.17506>,
            
    /*10*/ <-0.49048,6.76377,-3.24015>,<-0.48917,6.76549,-3.23218>,<-0.49679,6.766,-3.23531>,
            
    /*11*/ <-0.45037,7.00181,-3.32353>

    /* stem 0.4c0.0.0*/ 
    /*0*/ <-0.38867,5.33231,-2.02478>,
    /*1*/ <-0.38602,5.35127,-2.03059>,<-0.40317,5.32126,-2.03302>,<-0.37682,5.3244,-2.01075>,
            
    /*2*/ <0.23058,5.03433,-2.71549>

    /* stem 0.4c0.0.1*/ 
    /*0*/ <-0.42428,5.32965,-2.15918>,
    /*1*/ <-0.43931,5.31769,-2.15667>,<-0.41277,5.32763,-2.17464>,<-0.42075,5.34362,-2.14623>,
            
    /*2*/ <-0.97361,5.91856,-2.64483>

    /* stem 0.4c0.0.2*/ 
    /*0*/ <-0.48719,5.40758,-2.43114>,
    /*1*/ <-0.46953,5.40697,-2.43482>,<-0.49702,5.4218,-2.43637>,<-0.49503,5.39398,-2.42222>,
            
    /*2*/ <-0.65841,5.01127,-3.18612>

    /* stem 0.4c0.0.3*/ 
    /*0*/ <-0.52112,5.52589,-2.61764>,
    /*1*/ <-0.53228,5.535,-2.60852>,<-0.52521,5.52063,-2.63333>,<-0.50587,5.52204,-2.61106>,
            
    /*2*/ <-0.21315,6.21426,-2.92893>

    /* stem 0.4c0.0.4*/ 
    /*0*/ <-0.54964,5.65525,-2.76841>,
    /*1*/ <-0.5498,5.64463,-2.78056>,<-0.5413,5.66899,-2.76982>,<-0.55781,5.65212,-2.75486>,
            
    /*2*/ <-1.16874,6.00097,-3.06217>

    /* stem 0.4c0.0.5*/ 
    /*0*/ <-0.57124,5.74535,-2.84685>,
    /*1*/ <-0.56126,5.75448,-2.83911>,<-0.58411,5.75146,-2.85316>,<-0.56835,5.7301,-2.84829>,
            
    /*2*/ <-0.20288,5.87421,-3.4737>

    /* stem 0.4c0.0.6*/ 
    /*0*/ <-0.58751,5.89243,-2.95459>,
    /*1*/ <-0.60208,5.89124,-2.95655>,<-0.57865,5.89429,-2.96622>,<-0.58182,5.89177,-2.94101>,
            
    /*2*/ <-0.65222,6.58086,-2.89375>

    /* stem 0.4c0.0.7*/ 
    /*0*/ <-0.56287,6.19085,-3.09803>,
    /*1*/ <-0.55156,6.18705,-3.10366>,<-0.56368,6.20263,-3.09214>,<-0.57337,6.18287,-3.09828>,
            
    /*2*/ <-0.74193,6.44342,-3.62808>

    /* stem 0.4c0.0.8*/ 
    /*0*/ <-0.54,6.42196,-3.15698>,
    /*1*/ <-0.54409,6.42431,-3.1466>,<-0.54427,6.42727,-3.16611>,<-0.53166,6.41429,-3.15822>,
            
    /*2*/ <-0.16115,6.825,-3.09928>

    /* stem 0.4c0.0.9*/ 
    /*0*/ <-0.51271,6.64186,-3.20602>,
    /*1*/ <-0.51505,6.64063,-3.21268>,<-0.50651,6.64527,-3.20497>,<-0.51659,6.63967,-3.20041>,
            
    /*2*/ <-0.75481,7.08117,-3.2021>

    /* stem 0.4c0.0.10*/ 
    /*0*/ <-0.47911,6.83894,-3.26322>,
    /*1*/ <-0.4763,6.83906,-3.26155>,<-0.48094,6.84164,-3.26356>,<-0.4801,6.83611,-3.26457>,
            
    /*2*/ <-0.25726,6.9419,-3.6429>

    /* stem 0.4c0.1*/ 
    /*0*/ <-0.25538,5.41628,-2.19346>,
    /*1*/ <-0.25018,5.46064,-2.1858>,<-0.28675,5.40189,-2.22282>,<-0.22922,5.38632,-2.17175>,
            
    /*2*/ <-0.08863,5.46805,-2.36554>,<-0.12155,5.41518,-2.39884>,<-0.06977,5.40117,-2.35289>,
            
    /*3*/ <0.0346,5.5568,-2.53621>,<0.01244,5.51329,-2.57568>,<0.06504,5.50233,-2.5432>,
            
    /*4*/ <0.13941,5.69737,-2.6896>,<0.12474,5.66435,-2.73099>,<0.17267,5.65657,-2.7053>,
            
    /*5*/ <0.23435,5.86552,-2.82755>,<0.22398,5.8407,-2.8662>,<0.26552,5.83475,-2.84484>,
            
    /*6*/ <0.32287,6.05988,-2.92968>,<0.31697,6.04455,-2.96531>,<0.3511,6.03872,-2.94684>,
            
    /*7*/ <0.41412,6.26047,-3.02775>,<0.40978,6.24894,-3.05663>,<0.4369,6.24392,-3.04164>,
            
    /*8*/ <0.49478,6.46587,-3.12533>,<0.49153,6.4573,-3.14702>,<0.51221,6.45433,-3.13616>,
            
    /*9*/ <0.5628,6.67933,-3.21386>,<0.56081,6.67416,-3.22855>,<0.57476,6.67264,-3.22151>,
            
    /*10*/ <0.64376,6.8937,-3.29033>,<0.64291,6.89149,-3.29782>,<0.64971,6.89025,-3.2941>,
            
    /*11*/ <0.72863,7.11011,-3.35624>

    /* stem 0.4c0.1.0*/ 
    /*0*/ <-0.13152,5.42534,-2.33024>,
    /*1*/ <-0.14217,5.41349,-2.34066>,<-0.11327,5.42118,-2.32677>,<-0.13913,5.44135,-2.32327>,
            
    /*2*/ <0.11653,5.87618,-3.09599>

    /* stem 0.4c0.1.1*/ 
    /*0*/ <-0.01244,5.48755,-2.48337>,
    /*1*/ <0.00227,5.48727,-2.4728>,<-0.01641,5.50239,-2.49298>,<-0.02318,5.47299,-2.48434>,
            
    /*2*/ <0.4611,5.1823,-3.15024>

    /* stem 0.4c0.1.2*/ 
    /*0*/ <0.11155,5.62601,-2.65926>,
    /*1*/ <0.09708,5.63467,-2.66104>,<0.121,5.62239,-2.67287>,<0.11658,5.62097,-2.64387>,
            
    /*2*/ <0.51645,6.32229,-2.56345>

    /* stem 0.4c0.1.3*/ 
    /*0*/ <0.20794,5.78627,-2.79825>,
    /*1*/ <0.21655,5.7754,-2.80603>,<0.21448,5.80019,-2.79422>,<0.19279,5.78322,-2.7945>,
            
    /*2*/ <-0.01453,6.0813,-3.45675>

    /* stem 0.4c0.1.4*/ 
    /*0*/ <0.28257,5.94007,-2.89307>,
    /*1*/ <0.2824,5.94688,-2.8797>,<0.27584,5.94649,-2.90485>,<0.28946,5.92684,-2.89466>,
            
    /*2*/ <0.88548,6.27382,-3.0553>

    /* stem 0.4c0.1.5*/ 
    /*0*/ <0.38092,6.16214,-3.00057>,
    /*1*/ <0.37294,6.16049,-3.01169>,<0.39397,6.16633,-3.00201>,<0.37584,6.1596,-2.98801>,
            
    /*2*/ <0.18915,6.77538,-2.95402>

    /* stem 0.4c0.1.6*/ 
    /*0*/ <0.47257,6.38844,-3.10416>,
    /*1*/ <0.48419,6.38581,-3.1002>,<0.46817,6.40016,-3.10335>,<0.46536,6.37934,-3.10893>,
            
    /*2*/ <0.67927,6.50243,-3.63454>

    /* stem 0.4c0.1.7*/ 
    /*0*/ <0.51926,6.52326,-3.16141>,
    /*1*/ <0.50918,6.52795,-3.15737>,<0.52263,6.5252,-3.17258>,<0.52596,6.51662,-3.15427>,
            
    /*2*/ <0.78966,6.96729,-3.00254>

    /* stem 0.4c0.1.8*/ 
    /*0*/ <0.617,6.81418,-3.26798>,
    /*1*/ <0.61932,6.81162,-3.27308>,<0.62063,6.81753,-3.2643>,<0.61107,6.81339,-3.26656>,
            
    /*2*/ <0.50794,7.19686,-3.50973>

    /* stem 0.4c0.1.9*/ 
    /*0*/ <0.67127,6.95956,-3.31337>,
    /*1*/ <0.67206,6.96011,-3.3104>,<0.66976,6.96175,-3.31502>,<0.672,6.95683,-3.31471>,
            
    /*2*/ <1.04455,7.12146,-3.44218>

    /* stem 0.4c0.2*/ 
    /*0*/ <-0.13867,5.49413,-2.67708>,
    /*1*/ <-0.16795,5.46705,-2.69045>,<-0.09834,5.48833,-2.68751>,<-0.14973,5.527,-2.65329>,
            
    /*2*/ <-0.19479,5.59241,-2.87238>,<-0.13214,5.61156,-2.86974>,<-0.17839,5.64636,-2.83894>,
            
    /*3*/ <-0.17766,5.73735,-3.05017>,<-0.12185,5.74797,-3.03718>,<-0.16394,5.78104,-3.01413>,
            
    /*4*/ <-0.20755,5.90375,-3.19376>,<-0.15882,5.91788,-3.18869>,<-0.19448,5.93794,-3.15826>,
            
    /*5*/ <-0.2157,6.06708,-3.34654>,<-0.17364,6.07672,-3.33953>,<-0.20482,6.09678,-3.31638>,
            
    /*6*/ <-0.23718,6.24258,-3.48268>,<-0.20219,6.25142,-3.47776>,<-0.22774,6.26532,-3.45583>,
            
    /*7*/ <-0.24913,6.42047,-3.61726>,<-0.22103,6.42656,-3.61249>,<-0.24157,6.43814,-3.59536>,
            
    /*8*/ <-0.29169,6.61142,-3.72333>,<-0.27089,6.61771,-3.72109>,<-0.28559,6.62294,-3.70579>,
            
    /*9*/ <-0.3197,6.81281,-3.81684>,<-0.30563,6.81598,-3.81478>,<-0.31543,6.81937,-3.80455>,
            
    /*10*/ <-0.35155,7.01731,-3.89918>,<-0.34453,7.01894,-3.89818>,<-0.34937,7.0203,-3.89291>,
            
    /*11*/ <-0.36017,7.22882,-3.96953>

    /* stem 0.4c0.2.0*/ 
    /*0*/ <-0.157,5.56965,-2.78993>,
    /*1*/ <-0.13942,5.57236,-2.79097>,<-0.16827,5.58323,-2.79239>,<-0.16332,5.55335,-2.78643>,
            
    /*2*/ <-0.18042,5.39815,-3.6295>

    /* stem 0.4c0.2.1*/ 
    /*0*/ <-0.16181,5.68268,-2.9428>,
    /*1*/ <-0.1759,5.69058,-2.93762>,<-0.1602,5.67796,-2.95901>,<-0.14933,5.67951,-2.93176>,
            
    /*2*/ <0.17533,6.39954,-3.11802>

    /* stem 0.4c0.2.2*/ 
    /*0*/ <-0.17049,5.8365,-3.106>,
    /*1*/ <-0.16641,5.82671,-3.1179>,<-0.16367,5.85085,-3.1048>,<-0.18139,5.83193,-3.09531>,
            
    /*2*/ <-0.71771,6.13258,-3.53716>

    /* stem 0.4c0.2.3*/ 
    /*0*/ <-0.19019,5.9666,-3.22511>,
    /*1*/ <-0.18394,5.97636,-3.21539>,<-0.20314,5.97011,-3.23208>,<-0.18348,5.95333,-3.22786>,
            
    /*2*/ <0.17817,6.26358,-3.76025>

    /* stem 0.4c0.2.4*/ 
    /*0*/ <-0.20955,6.16196,-3.39938>,
    /*1*/ <-0.2221,6.15723,-3.4031>,<-0.2001,6.16501,-3.40912>,<-0.20645,6.16363,-3.38591>,
            
    /*2*/ <-0.43269,6.77327,-3.42404>

    /* stem 0.4c0.2.5*/ 
    /*0*/ <-0.22687,6.30609,-3.51328>,
    /*1*/ <-0.21428,6.30467,-3.51648>,<-0.23173,6.318,-3.51102>,<-0.23459,6.2956,-3.51235>,
            
    /*2*/ <-0.37018,6.35916,-4.10066>

    /* stem 0.4c0.2.6*/ 
    /*0*/ <-0.26501,6.54378,-3.67454>,
    /*1*/ <-0.27132,6.54749,-3.66542>,<-0.26982,6.54338,-3.6852>,<-0.2539,6.54046,-3.67301>,
            
    /*2*/ <-0.10209,7.04713,-3.76685>

    /* stem 0.4c0.2.7*/ 
    /*0*/ <-0.30276,6.74639,-3.77864>,
    /*1*/ <-0.30399,6.74199,-3.78741>,<-0.2968,6.75424,-3.77783>,<-0.30749,6.74294,-3.77067>,
            
    /*2*/ <-0.67421,7.03806,-3.87286>

    /* stem 0.4c0.2.8*/ 
    /*0*/ <-0.32798,6.89973,-3.847>,
    /*1*/ <-0.32311,6.90218,-3.84316>,<-0.33353,6.9033,-3.84804>,<-0.32731,6.89371,-3.84982>,
            
    /*2*/ <-0.14221,7.08588,-4.20078>

    /* stem 0.4c0.2.9*/ 
    /*0*/ <-0.35304,7.10071,-3.92513>,
    /*1*/ <-0.3556,7.10055,-3.92517>,<-0.35177,7.10157,-3.92718>,<-0.35175,7.1,-3.92303>,
            
    /*2*/ <-0.37761,7.46335,-3.78757>

    /* stem 0.4c0.3*/ 
    /*0*/ <-0.00847,5.5861,-3.14104>,
    /*1*/ <0.02623,5.58666,-3.13129>,<-0.02327,5.61501,-3.15666>,<-0.02836,5.55662,-3.13517>,
            
    /*2*/ <0.07542,5.51458,-3.31552>,<0.03087,5.54009,-3.33835>,<0.02629,5.48754,-3.31901>,
            
    /*3*/ <0.16775,5.50133,-3.48846>,<0.1286,5.52164,-3.5119>,<0.13126,5.47212,-3.50606>,
            
    /*4*/ <0.27018,5.55077,-3.65426>,<0.23423,5.56788,-3.67227>,<0.24393,5.52575,-3.67864>,
            
    /*5*/ <0.36609,5.65133,-3.80164>,<0.33355,5.66466,-3.81454>,<0.3471,5.63232,-3.82773>,
            
    /*6*/ <0.41467,5.78556,-3.95254>,<0.38448,5.79223,-3.95682>,<0.39785,5.76923,-3.97315>,
            
    /*7*/ <0.43503,5.94208,-4.08306>,<0.41024,5.94501,-4.08399>,<0.42166,5.92995,-4.10031>,
            
    /*8*/ <0.44898,6.10908,-4.1988>,<0.43033,6.11077,-4.19911>,<0.43905,6.10084,-4.21238>,
            
    /*9*/ <0.44989,6.28403,-4.30398>,<0.43741,6.28447,-4.30373>,<0.44327,6.27877,-4.31317>,
            
    /*10*/ <0.40902,6.45365,-4.41208>,<0.40289,6.4528,-4.41126>,<0.40575,6.45033,-4.41623>,
            
    /*11*/ <0.35081,6.63896,-4.47367>

    /* stem 0.4c0.3.0*/ 
    /*0*/ <0.0316,5.53129,-3.28049>,
    /*1*/ <0.02123,5.54022,-3.28698>,<0.03334,5.51701,-3.28523>,<0.04024,5.53665,-3.26926>,
            
    /*2*/ <0.56025,5.76818,-3.79994>

    /* stem 0.4c0.3.1*/ 
    /*0*/ <0.10118,5.50497,-3.42735>,
    /*1*/ <0.10413,5.49112,-3.4245>,<0.1108,5.51309,-3.43443>,<0.08861,5.5107,-3.42313>,
            
    /*2*/ <-0.20442,5.30755,-4.06949>

    /* stem 0.4c0.3.2*/ 
    /*0*/ <0.21356,5.53143,-3.61259>,
    /*1*/ <0.21652,5.54341,-3.6071>,<0.20956,5.5307,-3.62547>,<0.21461,5.52017,-3.60519>,
            
    /*2*/ <0.86545,5.46155,-3.81094>

    /* stem 0.4c0.3.3*/ 
    /*0*/ <0.30046,5.60008,-3.74339>,
    /*1*/ <0.2925,5.59526,-3.75214>,<0.31308,5.59871,-3.74479>,<0.29579,5.60628,-3.73325>,
            
    /*2*/ <0.32458,6.1537,-4.07047>

    /* stem 0.4c0.3.4*/ 
    /*0*/ <0.37133,5.70893,-3.88008>,
    /*1*/ <0.38285,5.70792,-3.87705>,<0.36618,5.7197,-3.88051>,<0.36496,5.69915,-3.88268>,
            
    /*2*/ <0.52712,5.76048,-4.45485>

    /* stem 0.4c0.3.5*/ 
    /*0*/ <0.43102,6.02432,-4.1472>,
    /*1*/ <0.42248,6.02794,-4.14316>,<0.43262,6.02508,-4.15717>,<0.43796,6.01993,-4.14128>,
            
    /*2*/ <0.65064,6.46472,-4.07819>

    /* stem 0.4c0.3.6*/ 
    /*0*/ <0.44146,6.19365,-4.2546>,
    /*1*/ <0.44425,6.18924,-4.26197>,<0.44581,6.20108,-4.25187>,<0.43433,6.19063,-4.24995>,
            
    /*2*/ <0.16969,6.44526,-4.50791>

    /* stem 0.4c0.3.7*/ 
    /*0*/ <0.41818,6.39678,-4.37849>,
    /*1*/ <0.41996,6.39941,-4.37491>,<0.41426,6.39823,-4.3808>,<0.42032,6.39269,-4.37974>,
            
    /*2*/ <0.64127,6.59227,-4.63327>

    /* stem 0.4c0.3.8*/ 
    /*0*/ <0.36736,6.58283,-4.45549>,
    /*1*/ <0.36641,6.58244,-4.45583>,<0.36789,6.58357,-4.45608>,<0.36778,6.58249,-4.45455>,
            
    /*2*/ <0.20509,6.83337,-4.29098>

    /* stem 0.4c0.4*/ 
    /*0*/ <0.27298,5.8507,-4.15831>,
    /*1*/ <0.25848,5.86148,-4.15849>,<0.27583,5.83916,-4.17191>,<0.28463,5.85147,-4.14453>,
            
    /*2*/ <0.3453,5.97396,-4.23697>,<0.36092,5.95388,-4.24905>,<0.36884,5.96496,-4.2244>,
            
    /*3*/ <0.42075,6.09741,-4.30706>,<0.43597,6.08159,-4.31907>,<0.44238,6.09046,-4.29656>,
            
    /*4*/ <0.47584,6.23001,-4.37844>,<0.49004,6.21807,-4.39008>,<0.49591,6.22614,-4.37059>,
            
    /*5*/ <0.53202,6.36744,-4.44373>,<0.54441,6.35773,-4.45395>,<0.54913,6.36391,-4.43687>,
            
    /*6*/ <0.56138,6.50242,-4.5262>,<0.57179,6.49488,-4.53512>,<0.57642,6.50192,-4.52194>,
            
    /*7*/ <0.58719,6.64133,-4.60554>,<0.59559,6.6357,-4.61292>,<0.59926,6.64111,-4.60225>,
            
    /*8*/ <0.60994,6.78251,-4.68198>,<0.61628,6.77853,-4.68764>,<0.61901,6.78246,-4.67957>,
            
    /*9*/ <0.63371,6.92674,-4.75251>,<0.63796,6.92423,-4.75635>,<0.63975,6.92662,-4.75086>,
            
    /*10*/ <0.66296,7.06925,-4.82483>,<0.66507,7.0679,-4.8267>,<0.66596,7.06911,-4.82396>,
            
    /*11*/ <0.69836,7.21704,-4.88192>

    /* stem 0.4c0.4.0*/ 
    /*0*/ <0.33286,5.93035,-4.21337>,
    /*1*/ <0.33616,5.92494,-4.21759>,<0.33715,5.93533,-4.20951>,<0.32526,5.93079,-4.213>,
            
    /*2*/ <0.33091,6.31263,-4.70396>

    /* stem 0.4c0.4.1*/ 
    /*0*/ <0.3993,6.0331,-4.2756>,
    /*1*/ <0.40005,6.0363,-4.26913>,<0.39721,6.037,-4.28135>,<0.40062,6.02601,-4.27632>,
            
    /*2*/ <0.9628,6.15102,-4.39984>

    /* stem 0.4c0.4.2*/ 
    /*0*/ <0.52239,6.31373,-4.42163>,
    /*1*/ <0.51814,6.31322,-4.4263>,<0.52841,6.31524,-4.42297>,<0.52064,6.31274,-4.41561>,
            
    /*2*/ <0.40964,6.80604,-4.37352>

    /* stem 0.4c0.4.3*/ 
    /*0*/ <0.55654,6.43469,-4.48831>,
    /*1*/ <0.5624,6.43395,-4.48755>,<0.55405,6.44,-4.48725>,<0.55317,6.43013,-4.49012>,
            
    /*2*/ <0.63026,6.55876,-4.93879>

    /* stem 0.4c0.4.4*/ 
    /*0*/ <0.58197,6.56974,-4.56743>,
    /*1*/ <0.57762,6.57196,-4.56485>,<0.58233,6.56999,-4.57294>,<0.58596,6.56728,-4.56452>,
            
    /*2*/ <0.79349,6.94857,-4.53676>

    /* stem 0.4c0.4.5*/ 
    /*0*/ <0.60052,6.68319,-4.63044>,
    /*1*/ <0.60166,6.68068,-4.6348>,<0.6038,6.68669,-4.62854>,<0.5961,6.6822,-4.62797>,
            
    /*2*/ <0.41676,6.97153,-4.84469>

    /* stem 0.4c0.4.6*/ 
    /*0*/ <0.65526,7.01993,-4.80059>,
    /*1*/ <0.65633,7.02073,-4.79857>,<0.65363,7.02131,-4.80173>,<0.65581,7.01774,-4.80146>,
            
    /*2*/ <0.88295,7.14592,-4.97267>

    /* stem 0.4c0.4.7*/ 
    /*0*/ <0.68842,7.17328,-4.86517>,
    /*1*/ <0.68794,7.17329,-4.86541>,<0.68886,7.17337,-4.86545>,<0.68845,7.17317,-4.86465>,
            
    /*2*/ <0.66847,7.43789,-4.80915>

    /* stem 0.4c1*/ 
    /*0*/ <-0.82344,5.19725,-2.98924>,
    /*1*/ <-0.78495,5.19778,-2.98833>,<-0.81203,5.23401,-2.99017>,<-0.85488,5.21944,-2.99073>,
            <-0.85429,5.17419,-2.98923>,<-0.81107,5.16081,-2.98774>,
    /*2*/ <-0.78103,5.18076,-3.50345>,<-0.80212,5.20899,-3.50489>,<-0.83551,5.19763,-3.50532>,
            <-0.83505,5.16239,-3.50415>,<-0.80138,5.15196,-3.503>,
    /*3*/ <-0.78956,5.12785,-4.01684>,<-0.80467,5.148,-4.01891>,<-0.8286,5.13993,-4.01808>,
            <-0.82828,5.11479,-4.01549>,<-0.80415,5.10733,-4.01473>,
    /*4*/ <-0.79406,5.17239,-4.53009>,<-0.8032,5.18458,-4.52911>,<-0.81765,5.1797,-4.52964>,
            <-0.81745,5.16449,-4.53096>,<-0.80287,5.15997,-4.53124>,
    /*5*/ <-0.78872,5.21608,-5.04339>,<-0.79186,5.22029,-5.04311>,<-0.79685,5.21861,-5.04339>,
            <-0.79678,5.21337,-5.04384>,<-0.79176,5.2118,-5.04383>,
    /*6*/ <-0.79319,5.21603,-5.04351>

    /* stem 0.4c1.0*/ 
    /*0*/ <-0.80808,5.16068,-4.39745>,
    /*1*/ <-0.7929,5.16087,-4.39731>,<-0.81578,5.17264,-4.40278>,<-0.81557,5.14853,-4.39225>,
            
    /*2*/ <-0.79238,5.09857,-4.53998>,<-0.81297,5.10916,-4.5449>,<-0.81278,5.08747,-4.53543>,
            
    /*3*/ <-0.75352,5.10878,-4.68678>,<-0.77215,5.11742,-4.69134>,<-0.76981,5.09652,-4.69198>,
            
    /*4*/ <-0.70155,5.16164,-4.82186>,<-0.71807,5.16887,-4.82558>,<-0.71418,5.15164,-4.83077>,
            
    /*5*/ <-0.66752,5.2498,-4.94635>,<-0.68247,5.2548,-4.94705>,<-0.67808,5.2419,-4.95501>,
            
    /*6*/ <-0.63541,5.3525,-5.05853>,<-0.64798,5.35636,-5.05875>,<-0.64397,5.34657,-5.06656>,
            
    /*7*/ <-0.58236,5.45988,-5.15605>,<-0.59207,5.46377,-5.15719>,<-0.58864,5.4562,-5.16365>,
            
    /*8*/ <-0.5325,5.5839,-5.23541>,<-0.5399,5.58654,-5.23607>,<-0.5369,5.58179,-5.24161>,
            
    /*9*/ <-0.4997,5.7106,-5.32068>,<-0.5048,5.71189,-5.3208>,<-0.50278,5.70883,-5.32457>,
            
    /*10*/ <-0.45776,5.84355,-5.38928>,<-0.46027,5.8443,-5.38941>,<-0.45921,5.84294,-5.39139>,
            
    /*11*/ <-0.39942,5.98243,-5.42742>

    /* stem 0.4c1.0.0*/ 
    /*0*/ <-0.8067,5.11843,-4.49422>,
    /*1*/ <-0.81164,5.12215,-4.49591>,<-0.80644,5.11234,-4.4962>,<-0.80201,5.12081,-4.49054>,
            
    /*2*/ <-0.51021,5.2899,-4.98363>

    /* stem 0.4c1.0.1*/ 
    /*0*/ <-0.72811,5.1441,-4.78355>,
    /*1*/ <-0.72603,5.13895,-4.78473>,<-0.7248,5.14869,-4.78403>,<-0.73352,5.14467,-4.78188>,
            
    /*2*/ <-0.87628,5.19876,-5.28138>

    /* stem 0.4c1.0.2*/ 
    /*0*/ <-0.69306,5.20625,-4.88983>,
    /*1*/ <-0.69184,5.21034,-4.88656>,<-0.69552,5.20719,-4.89452>,<-0.69181,5.20121,-4.88842>,
            
    /*2*/ <-0.25617,5.2522,-5.10983>

    /* stem 0.4c1.0.3*/ 
    /*0*/ <-0.66282,5.28933,-4.99344>,
    /*1*/ <-0.6667,5.28761,-4.99618>,<-0.65843,5.29045,-4.99568>,<-0.66333,5.28992,-4.98844>,
            
    /*2*/ <-0.8067,5.71967,-5.05959>

    /* stem 0.4c1.0.4*/ 
    /*0*/ <-0.5734,5.49455,-5.18091>,
    /*1*/ <-0.56931,5.4935,-5.1799>,<-0.57491,5.49854,-5.18002>,<-0.576,5.49162,-5.1828>,
            
    /*2*/ <-0.45616,5.61631,-5.53027>

    /* stem 0.4c1.0.5*/ 
    /*0*/ <-0.51376,5.66833,-5.29392>,
    /*1*/ <-0.51653,5.67002,-5.29249>,<-0.51299,5.66876,-5.29735>,<-0.51176,5.66621,-5.29191>,
            
    /*2*/ <-0.31497,5.92834,-5.21682>

    /* stem 0.4c1.0.6*/ 
    /*0*/ <-0.41638,5.94295,-5.41678>,
    /*1*/ <-0.41625,5.94279,-5.41716>,<-0.41614,5.94323,-5.41657>,<-0.41676,5.94282,-5.41661>,
            
    /*2*/ <-0.53617,6.13787,-5.53967>

    /* stem 0.4c2*/ 
    /*0*/ <-1.03488,5.16711,-3.9971>,
    /*1*/ <-1.01653,5.1675,-4.0083>,<-1.02941,5.18766,-4.00018>,<-1.04985,5.17942,-3.98782>,
            <-1.04959,5.15416,-3.98828>,<-1.029,5.14679,-4.00094>,
    /*2*/ <-1.29225,5.17282,-4.44374>,<-1.30003,5.185,-4.43884>,<-1.31238,5.18002,-4.43137>,
            <-1.31223,5.16476,-4.43165>,<-1.29979,5.1603,-4.4393>,
    /*3*/ <-1.56727,5.19683,-4.87897>,<-1.56988,5.20102,-4.87716>,<-1.57417,5.19931,-4.87464>,
            <-1.57422,5.19405,-4.8749>,<-1.56996,5.19252,-4.87758>,
    /*4*/ <-1.5711,5.19674,-4.87665>

    /* stem 0.4c2.0*/ 
    /*0*/ <-1.50086,5.19041,-4.76131>,
    /*1*/ <-1.50521,5.19462,-4.75843>,<-1.50287,5.18429,-4.76321>,<-1.4945,5.19231,-4.76229>,
            
    /*2*/ <-1.53835,5.24327,-4.88115>,<-1.53624,5.23397,-4.88545>,<-1.52871,5.24119,-4.88463>,
            
    /*3*/ <-1.57643,5.3349,-4.9714>,<-1.57567,5.32856,-4.97817>,<-1.56836,5.33385,-4.97591>,
            
    /*4*/ <-1.60482,5.44114,-5.05098>,<-1.6044,5.43637,-5.05756>,<-1.59774,5.44017,-5.05486>,
            
    /*5*/ <-1.63084,5.55269,-5.12412>,<-1.63056,5.54895,-5.12999>,<-1.62478,5.55194,-5.12749>,
            
    /*6*/ <-1.64939,5.67416,-5.18187>,<-1.64929,5.6717,-5.18713>,<-1.64436,5.6736,-5.18472>,
            
    /*7*/ <-1.67585,5.79451,-5.23944>,<-1.67577,5.79253,-5.24365>,<-1.67186,5.79426,-5.24182>,
            
    /*8*/ <-1.70554,5.9165,-5.29164>,<-1.70552,5.91515,-5.29485>,<-1.70259,5.91645,-5.29349>,
            
    /*9*/ <-1.74627,6.02934,-5.35615>,<-1.74618,6.02822,-5.35818>,<-1.74431,6.02935,-5.3574>,
            
    /*10*/ <-1.78771,6.14416,-5.41625>,<-1.78769,6.14363,-5.41728>,<-1.78674,6.14418,-5.41688>,
            
    /*11*/ <-1.8062,6.2555,-5.49255>

    /* stem 0.4c2.0.0*/ 
    /*0*/ <-1.52134,5.22035,-4.83602>,
    /*1*/ <-1.52125,5.21772,-4.8371>,<-1.51991,5.22246,-4.83728>,<-1.52288,5.22087,-4.83368>,
            
    /*2*/ <-1.93981,5.32714,-5.13362>

    /* stem 0.4c2.0.1*/ 
    /*0*/ <-1.58493,5.37483,-5.00664>,
    /*1*/ <-1.58311,5.37619,-5.00547>,<-1.58724,5.37586,-5.00704>,<-1.58445,5.37243,-5.0074>,
            
    /*2*/ <-1.44095,5.53566,-5.41976>

    /* stem 0.4c2.0.2*/ 
    /*0*/ <-1.61714,5.50206,-5.09528>,
    /*1*/ <-1.61946,5.50162,-5.09511>,<-1.61617,5.50249,-5.0974>,<-1.61579,5.50206,-5.09333>,
            
    /*2*/ <-1.69226,5.92041,-5.04428>

    /* stem 0.4c2.0.3*/ 
    /*0*/ <-1.64214,5.6375,-5.1678>,
    /*1*/ <-1.64046,5.63713,-5.16914>,<-1.64219,5.63932,-5.16659>,<-1.64377,5.63606,-5.16767>,
            
    /*2*/ <-1.83007,5.82465,-5.45461>

    /* stem 0.4c2.0.4*/ 
    /*0*/ <-1.69566,5.87986,-5.27804>,
    /*1*/ <-1.69598,5.8805,-5.27633>,<-1.69694,5.88006,-5.27936>,<-1.69406,5.87902,-5.27842>,
            
    /*2*/ <-1.5648,6.16614,-5.36064>

    /* stem 0.4c2.0.5*/ 
    /*0*/ <-1.72973,5.98533,-5.33254>,
    /*1*/ <-1.73044,5.98443,-5.33366>,<-1.72878,5.98654,-5.33297>,<-1.72997,5.98501,-5.33099>,
            
    /*2*/ <-1.96218,6.16811,-5.3302>

    /* stem 0.4c2.0.6*/ 
    /*0*/ <-1.79511,6.18977,-5.4479>,
    /*1*/ <-1.79475,6.1899,-5.4478>,<-1.79541,6.19003,-5.44794>,<-1.79517,6.18939,-5.44797>,
            
    /*2*/ <-1.74032,6.21918,-5.67662>

    /* stem 0.4.0*/ 
    /*0*/ <-0.10871,5.48417,-0.34173>,
    /*1*/ <-0.15156,5.52039,-0.3293>,<-0.12023,5.43304,-0.36531>,<-0.05434,5.49908,-0.33059>,
            
    /*2*/ <-0.12326,5.64372,-0.6176>,<-0.09506,5.56511,-0.65>,<-0.03576,5.62454,-0.61876>,
            
    /*3*/ <-0.11635,5.8195,-0.86708>,<-0.09111,5.758,-0.91091>,<-0.03833,5.80618,-0.87579>,
            
    /*4*/ <-0.13948,6.01663,-1.10388>,<-0.11833,5.9673,-1.14832>,<-0.07166,6.00926,-1.11806>,
            
    /*5*/ <-0.20795,6.24155,-1.30007>,<-0.19247,6.207,-1.34626>,<-0.15177,6.24218,-1.32032>,
            
    /*6*/ <-0.27529,6.48885,-1.47945>,<-0.26342,6.4633,-1.52048>,<-0.22866,6.48994,-1.49683>,
            
    /*7*/ <-0.33908,6.74951,-1.64184>,<-0.33017,6.73114,-1.67602>,<-0.30186,6.75061,-1.65592>,
            
    /*8*/ <-0.35712,7.03115,-1.78314>,<-0.35057,7.01885,-1.80955>,<-0.32868,7.02905,-1.79199>,
            
    /*9*/ <-0.37458,7.32919,-1.87656>,<-0.37045,7.32388,-1.89529>,<-0.35569,7.32866,-1.88282>,
            
    /*10*/ <-0.43237,7.60997,-2.00698>,<-0.43019,7.6064,-2.01601>,<-0.42304,7.61048,-2.01041>,
            
    /*11*/ <-0.52347,7.86676,-2.1648>

    /* stem 0.4.0.0*/ 
    /*0*/ <-0.09626,5.54996,-0.49049>,
    /*1*/ <-0.0927,5.5277,-0.50004>,<-0.08372,5.56914,-0.49912>,<-0.11238,5.55305,-0.47232>,
            
    /*2*/ <-0.97773,5.75911,-1.30764>

    /* stem 0.4.0.1*/ 
    /*0*/ <-0.08398,5.65812,-0.69433>,
    /*1*/ <-0.07171,5.67432,-0.68258>,<-0.10324,5.66433,-0.70623>,<-0.077,5.63571,-0.69418>,
            
    /*2*/ <0.56434,5.85379,-1.64137>

    /* stem 0.4.0.2*/ 
    /*0*/ <-0.08275,5.74022,-0.80881>,
    /*1*/ <-0.10443,5.73444,-0.81319>,<-0.06759,5.74148,-0.82588>,<-0.07623,5.74473,-0.78737>,
            
    /*2*/ <-0.34285,6.83005,-0.95894>

    /* stem 0.4.0.3*/ 
    /*0*/ <-0.08913,5.84701,-0.94625>,
    /*1*/ <-0.06876,5.84181,-0.95306>,<-0.09537,5.86818,-0.94524>,<-0.10326,5.83104,-0.94046>,
            
    /*2*/ <-0.44644,5.7908,-1.97297>

    /* stem 0.4.0.4*/ 
    /*0*/ <-0.1564,6.1436,-1.24814>,
    /*1*/ <-0.16484,6.15389,-1.23294>,<-0.16544,6.14301,-1.26619>,<-0.13892,6.13389,-1.24527>,
            
    /*2*/ <0.33683,6.95139,-1.52138>

    /* stem 0.4.0.5*/ 
    /*0*/ <-0.19394,6.26473,-1.34655>,
    /*1*/ <-0.19911,6.25293,-1.36117>,<-0.18403,6.28109,-1.35027>,<-0.19868,6.26016,-1.3282>,
            
    /*2*/ <-1.00884,6.73728,-1.43945>

    /* stem 0.4.0.6*/ 
    /*0*/ <-0.23265,6.3999,-1.44192>,
    /*1*/ <-0.21757,6.40885,-1.43535>,<-0.24897,6.40896,-1.44348>,<-0.23142,6.38189,-1.44691>,
            
    /*2*/ <-0.01359,6.64861,-2.2849>

    /* stem 0.4.0.7*/ 
    /*0*/ <-0.30246,6.66146,-1.60818>,
    /*1*/ <-0.31924,6.65934,-1.60453>,<-0.2977,6.6681,-1.62344>,<-0.29044,6.65694,-1.59659>,
            
    /*2*/ <-0.32825,7.42464,-1.28419>

    /* stem 0.4.0.8*/ 
    /*0*/ <-0.33995,6.95487,-1.76025>,
    /*1*/ <-0.32927,6.95048,-1.77102>,<-0.33898,6.96913,-1.75352>,<-0.35161,6.94501,-1.75621>,
            
    /*2*/ <-0.76983,7.24053,-2.30362>

    /* stem 0.4.0.9*/ 
    /*0*/ <-0.36149,7.2513,-1.86218>,
    /*1*/ <-0.36194,7.25497,-1.84977>,<-0.36953,7.25663,-1.87081>,<-0.353,7.24228,-1.86595>,
            
    /*2*/ <0.09317,7.73238,-1.98826>

    /* stem 0.4.0.10*/ 
    /*0*/ <-0.37848,7.38015,-1.9086>,
    /*1*/ <-0.38464,7.37563,-1.91568>,<-0.37227,7.38804,-1.91138>,<-0.37854,7.37679,-1.89875>,
            
    /*2*/ <-0.84472,7.79664,-1.76895>

    /* stem 0.4.0.11*/ 
    /*0*/ <-0.40617,7.50673,-1.96532>,
    /*1*/ <-0.39868,7.50881,-1.96434>,<-0.41191,7.51145,-1.96285>,<-0.40792,7.49992,-1.96878>,
            
    /*2*/ <-0.41162,7.78268,-2.50553>

    /* stem 0.4.0.12*/ 
    /*0*/ <-0.45766,7.68805,-2.05828>,
    /*1*/ <-0.46109,7.688,-2.05625>,<-0.45762,7.68922,-2.06209>,<-0.45427,7.68694,-2.0565>,
            
    /*2*/ <-0.36996,8.21275,-1.89649>

    /* stem 0.4.1*/ 
    /*0*/ <-0.14251,5.47612,-0.43476>,
    /*1*/ <-0.13097,5.42046,-0.43413>,<-0.12318,5.50867,-0.47716>,<-0.17337,5.49922,-0.39299>,
            
    /*2*/ <-0.39213,5.3703,-0.59549>,<-0.38513,5.44969,-0.63421>,<-0.4303,5.44118,-0.55845>,
            
    /*3*/ <-0.68168,5.4407,-0.73907>,<-0.65349,5.51042,-0.7625>,<-0.68965,5.50396,-0.69282>,
            
    /*4*/ <-0.93819,5.58605,-0.86858>,<-0.90046,5.64203,-0.88246>,<-0.93373,5.63695,-0.82232>,
            
    /*5*/ <-1.16526,5.79159,-0.96206>,<-1.1247,5.83369,-0.97052>,<-1.1512,5.82833,-0.91799>,
            
    /*6*/ <-1.35211,6.02747,-1.05767>,<-1.31326,6.05738,-1.06219>,<-1.33782,6.0552,-1.01958>,
            
    /*7*/ <-1.53658,6.26769,-1.13321>,<-1.50531,6.29134,-1.1369>,<-1.52364,6.2882,-1.10218>,
            
    /*8*/ <-1.67363,6.53575,-1.22306>,<-1.6474,6.54929,-1.22424>,<-1.6631,6.54965,-1.19922>,
            
    /*9*/ <-1.82175,6.80624,-1.26872>,<-1.80458,6.81583,-1.26976>,<-1.81368,6.81378,-1.25242>,
            
    /*10*/ <-1.96824,7.07638,-1.31694>,<-1.95964,7.08113,-1.31745>,<-1.96423,7.08019,-1.30879>,
            
    /*11*/ <-2.10188,7.35229,-1.37062>

    /* stem 0.4.1.0*/ 
    /*0*/ <-0.26497,5.44987,-0.51073>,
    /*1*/ <-0.26079,5.46958,-0.52428>,<-0.28635,5.44715,-0.49952>,<-0.24778,5.43288,-0.50838>,
            
    /*2*/ <-0.70059,4.8753,-1.48103>

    /* stem 0.4.1.1*/ 
    /*0*/ <-0.44176,5.4297,-0.61556>,
    /*1*/ <-0.45293,5.42386,-0.59587>,<-0.44781,5.41975,-0.63582>,<-0.42454,5.4455,-0.61497>,
            
    /*2*/ <-1.21142,6.27563,-0.80121>

    /* stem 0.4.1.2*/ 
    /*0*/ <-0.63791,5.47624,-0.71306>,
    /*1*/ <-0.63066,5.46692,-0.73209>,<-0.64837,5.49604,-0.71356>,<-0.63469,5.46577,-0.69352>,
            
    /*2*/ <-1.60812,4.96066,-0.82987>

    /* stem 0.4.1.3*/ 
    /*0*/ <-0.77625,5.54058,-0.78282>,
    /*1*/ <-0.77263,5.55826,-0.77084>,<-0.79627,5.53249,-0.7844>,<-0.75984,5.53101,-0.79322>,
            
    /*2*/ <-0.95739,6.15432,-1.63339>

    /* stem 0.4.1.4*/ 
    /*0*/ <-1.03226,5.71684,-0.90261>,
    /*1*/ <-1.04548,5.7016,-0.90307>,<-1.03092,5.72952,-0.91825>,<-1.02038,5.7194,-0.8865>,
            
    /*2*/ <-1.71377,6.29558,-0.49192>

    /* stem 0.4.1.5*/ 
    /*0*/ <-1.21034,5.89517,-0.98272>,
    /*1*/ <-1.19622,5.90232,-0.99322>,<-1.22128,5.90675,-0.97236>,<-1.21353,5.87644,-0.98258>,
            
    /*2*/ <-1.78623,5.98782,-1.6945>

    /* stem 0.4.1.6*/ 
    /*0*/ <-1.31037,6.01734,-1.03413>,
    /*1*/ <-1.31737,6.01868,-1.01732>,<-1.32111,6.0197,-1.0487>,<-1.29264,6.01363,-1.03637>,
            
    /*2*/ <-1.12944,6.87892,-1.02784>

    /* stem 0.4.1.7*/ 
    /*0*/ <-1.43674,6.17539,-1.08886>,
    /*1*/ <-1.44016,6.16769,-1.10398>,<-1.43474,6.19257,-1.08815>,<-1.43532,6.1659,-1.07444>,
            
    /*2*/ <-2.25031,6.26444,-0.95036>

    /* stem 0.4.1.8*/ 
    /*0*/ <-1.62182,6.47049,-1.18959>,
    /*1*/ <-1.61057,6.47889,-1.18265>,<-1.63684,6.47463,-1.18794>,<-1.61806,6.45794,-1.19819>,
            
    /*2*/ <-1.5699,6.89982,-1.7934>

    /* stem 0.4.1.9*/ 
    /*0*/ <-1.73677,6.67738,-1.23938>,
    /*1*/ <-1.74906,6.67096,-1.23621>,<-1.7359,6.68583,-1.2508>,<-1.72534,6.67535,-1.23114>,
            
    /*2*/ <-1.91822,7.21442,-0.8557>

    /* stem 0.4.1.10*/ 
    /*0*/ <-1.86054,6.89567,-1.27953>,
    /*1*/ <-1.85491,6.89741,-1.28709>,<-1.86357,6.90292,-1.27404>,<-1.86315,6.88668,-1.27747>,
            
    /*2*/ <-2.36472,6.95894,-1.64089>

    /* stem 0.4.1.11*/ 
    /*0*/ <-1.93729,7.03179,-1.30538>,
    /*1*/ <-1.93752,7.03291,-1.29879>,<-1.94267,7.03301,-1.30917>,<-1.93168,7.02944,-1.30819>,
            
    /*2*/ <-1.75126,7.58008,-1.39249>

    /* stem 0.4.1.12*/ 
    /*0*/ <-2.01413,7.17847,-1.33483>,
    /*1*/ <-2.0161,7.17694,-1.33745>,<-2.01225,7.18149,-1.33551>,<-2.01405,7.17699,-1.33153>,
            
    /*2*/ <-2.44428,7.47949,-1.18811>

    /* stem 0.4.2*/ 
    /*0*/ <-0.24276,5.42729,-0.80523>,
    /*1*/ <-0.219,5.47458,-0.81787>,<-0.29385,5.41741,-0.82112>,<-0.21542,5.38989,-0.77669>,
            
    /*2*/ <-0.12008,5.35159,-1.06863>,<-0.18745,5.30013,-1.07155>,<-0.11687,5.27537,-1.03157>,
            
    /*3*/ <-0.04757,5.33943,-1.33994>,<-0.1046,5.29214,-1.35391>,<-0.03704,5.26498,-1.33439>,
            
    /*4*/ <-0.01706,5.38848,-1.62392>,<-0.06779,5.34847,-1.63724>,<-0.00645,5.3243,-1.63491>,
            
    /*5*/ <0.00452,5.51177,-1.88229>,<-0.03824,5.4803,-1.90174>,<0.01493,5.46157,-1.90614>,
            
    /*6*/ <0.00945,5.67783,-2.12233>,<-0.0262,5.65326,-2.14094>,<0.0183,5.64009,-2.14912>,
            
    /*7*/ <0.00766,5.84443,-2.36784>,<-0.02088,5.8243,-2.38202>,<0.01472,5.81415,-2.38916>,
            
    /*8*/ <0.00901,6.01618,-2.60858>,<-0.01235,6.00143,-2.61979>,<0.01437,5.99383,-2.62505>,
            
    /*9*/ <0.00975,6.2318,-2.80718>,<-0.00447,6.22366,-2.8165>,<0.01335,6.21947,-2.82098>,
            
    /*10*/ <0.02193,6.46977,-2.98107>,<0.01486,6.46646,-2.98635>,<0.02378,6.46438,-2.98858>,
            
    /*11*/ <0.02689,6.72198,-3.13578>

    /* stem 0.4.2.0*/ 
    /*0*/ <-0.16565,5.33726,-0.99708>,
    /*1*/ <-0.18553,5.32633,-0.99994>,<-0.14592,5.32591,-0.99934>,<-0.16549,5.35955,-0.99196>,
            
    /*2*/ <-0.14634,5.59041,-2.09906>

    /* stem 0.4.2.1*/ 
    /*0*/ <-0.10285,5.30402,-1.19787>,
    /*1*/ <-0.08215,5.29979,-1.19204>,<-0.10728,5.32095,-1.21107>,<-0.11913,5.29131,-1.19051>,
            
    /*2*/ <0.00853,4.66247,-2.05806>

    /* stem 0.4.2.2*/ 
    /*0*/ <-0.05336,5.31518,-1.42879>,
    /*1*/ <-0.0665,5.33132,-1.42721>,<-0.05678,5.3003,-1.44302>,<-0.03681,5.31392,-1.41614>,
            
    /*2*/ <0.50476,5.83611,-2.10765>

    /* stem 0.4.2.3*/ 
    /*0*/ <-0.03547,5.34528,-1.58741>,
    /*1*/ <-0.03571,5.32549,-1.59119>,<-0.02166,5.35705,-1.59618>,<-0.04903,5.35331,-1.57485>,
            
    /*2*/ <-0.64499,5.49722,-2.34304>

    /* stem 0.4.2.4*/ 
    /*0*/ <-0.01289,5.44866,-1.8241>,
    /*1*/ <-0.00089,5.4614,-1.81671>,<-0.02728,5.45443,-1.83508>,<-0.01051,5.43016,-1.82051>,
            
    /*2*/ <0.52426,5.37346,-2.56732>

    /* stem 0.4.2.5*/ 
    /*0*/ <-0.00349,5.55511,-1.99519>,
    /*1*/ <-0.02125,5.55259,-1.9975>,<0.0077,5.55421,-2.00938>,<0.00309,5.55854,-1.9787>,
            
    /*2*/ <-0.10722,6.40964,-2.13128>

    /* stem 0.4.2.6*/ 
    /*0*/ <0.00051,5.74863,-2.2675>,
    /*1*/ <0.01498,5.74201,-2.27216>,<-0.00204,5.76494,-2.26906>,<-0.01142,5.73893,-2.26127>,
            
    /*2*/ <-0.2865,5.63402,-2.99596>

    /* stem 0.4.2.7*/ 
    /*0*/ <0.00165,5.89171,-2.46628>,
    /*1*/ <-0.00387,5.90336,-2.45774>,<-0.00377,5.88934,-2.48058>,<0.01261,5.88242,-2.46054>,
            
    /*2*/ <0.51876,6.33495,-2.73597>

    /* stem 0.4.2.8*/ 
    /*0*/ <0.0046,6.0849,-2.69006>,
    /*1*/ <0.00002,6.07605,-2.70005>,<0.0164,6.09236,-2.69212>,<-0.0026,6.08628,-2.67801>,
            
    /*2*/ <-0.35116,6.57306,-2.95902>

    /* stem 0.4.2.9*/ 
    /*0*/ <0.00584,6.19279,-2.7862>,
    /*1*/ <0.01584,6.19673,-2.78165>,<-0.00225,6.20034,-2.78994>,<0.00392,6.1813,-2.78702>,
            
    /*2*/ <0.2661,6.18981,-3.35611>

    /* stem 0.4.2.10*/ 
    /*0*/ <0.01528,6.38193,-2.92548>,
    /*1*/ <0.00802,6.38285,-2.92477>,<0.01858,6.38352,-2.93185>,<0.01924,6.37941,-2.91982>,
            
    /*2*/ <0.10055,6.91664,-2.74723>

    /* stem 0.4.2.11*/ 
    /*0*/ <0.02357,6.59566,-3.06129>,
    /*1*/ <0.02535,6.5946,-3.06301>,<0.02375,6.59826,-3.06059>,<0.02161,6.59413,-3.06027>,
            
    /*2*/ <-0.27823,6.72144,-3.45163>

    /* stem 0.4.3*/ 
    /*0*/ <-0.31778,5.39226,-1.11621>,
    /*1*/ <-0.36505,5.37317,-1.10417>,<-0.28622,5.36564,-1.14843>,<-0.30208,5.43797,-1.09602>,
            
    /*2*/ <-0.47214,5.5117,-1.32779>,<-0.40119,5.50492,-1.36762>,<-0.41547,5.57002,-1.32045>,
            
    /*3*/ <-0.56043,5.70938,-1.51943>,<-0.49772,5.70405,-1.55557>,<-0.50475,5.75256,-1.50206>,
            
    /*4*/ <-0.63583,5.92519,-1.69152>,<-0.58093,5.92053,-1.72309>,<-0.58546,5.95903,-1.67279>,
            
    /*5*/ <-0.67682,6.17983,-1.82171>,<-0.62943,6.17496,-1.84805>,<-0.63117,6.19941,-1.79944>,
            
    /*6*/ <-0.76904,6.41793,-1.93149>,<-0.73191,6.42112,-1.95735>,<-0.73251,6.43998,-1.9161>,
            
    /*7*/ <-0.88671,6.64704,-2.04515>,<-0.85807,6.65163,-2.06696>,<-0.85875,6.66748,-2.03432>,
            
    /*8*/ <-1.0132,6.88122,-2.14237>,<-0.99247,6.88588,-2.15938>,<-0.99214,6.89647,-2.13431>,
            
    /*9*/ <-1.11119,7.14502,-2.19106>,<-1.09748,7.14832,-2.20248>,<-1.09573,7.15221,-2.18485>,
            
    /*10*/ <-1.17519,7.42144,-2.22003>,<-1.16818,7.42262,-2.22567>,<-1.16708,7.42381,-2.21674>,
            
    /*11*/ <-1.23817,7.69681,-2.24958>

    /* stem 0.4.3.0*/ 
    /*0*/ <-0.3984,5.49076,-1.27657>,
    /*1*/ <-0.38067,5.48562,-1.28865>,<-0.40611,5.51144,-1.27654>,<-0.40843,5.47524,-1.26452>,
            
    /*2*/ <-1.04169,5.25208,-2.11929>

    /* stem 0.4.3.1*/ 
    /*0*/ <-0.45968,5.59246,-1.40021>,
    /*1*/ <-0.4652,5.60537,-1.38418>,<-0.47148,5.59184,-1.41793>,<-0.44236,5.58017,-1.39851>,
            
    /*2*/ <0.1224,6.35538,-1.81461>

    /* stem 0.4.3.2*/ 
    /*0*/ <-0.53307,5.75431,-1.5515>,
    /*1*/ <-0.54152,5.74098,-1.56423>,<-0.52197,5.76964,-1.55878>,<-0.53572,5.75231,-1.5315>,
            
    /*2*/ <-1.34466,6.31756,-1.60273>

    /* stem 0.4.3.3*/ 
    /*0*/ <-0.58309,5.88782,-1.65817>,
    /*1*/ <-0.56605,5.89672,-1.65503>,<-0.59979,5.89739,-1.65511>,<-0.58345,5.86935,-1.66437>,
            
    /*2*/ <-0.57486,6.18877,-2.55549>

    /* stem 0.4.3.4*/ 
    /*0*/ <-0.62319,6.05937,-1.7592>,
    /*1*/ <-0.64062,6.05949,-1.75277>,<-0.61985,6.06326,-1.77705>,<-0.60911,6.05534,-1.74777>,
            
    /*2*/ <-0.54101,6.92913,-1.55383>

    /* stem 0.4.3.5*/ 
    /*0*/ <-0.70246,6.32345,-1.88732>,
    /*1*/ <-0.6942,6.32001,-1.90201>,<-0.70182,6.33926,-1.88058>,<-0.71136,6.31106,-1.87936>,
            
    /*2*/ <-1.37543,6.53259,-2.31458>

    /* stem 0.4.3.6*/ 
    /*0*/ <-0.81854,6.56384,-2.00331>,
    /*1*/ <-0.81635,6.57177,-1.98973>,<-0.83301,6.56305,-2.00981>,<-0.80625,6.55669,-2.01041>,
            
    /*2*/ <-0.67768,7.19359,-2.39367>

    /* stem 0.4.3.7*/ 
    /*0*/ <-0.90266,6.71696,-2.07438>,
    /*1*/ <-0.91297,6.70834,-2.08109>,<-0.89687,6.72877,-2.08164>,<-0.89813,6.71377,-2.06042>,
            
    /*2*/ <-1.41689,7.12926,-1.81341>

    /* stem 0.4.3.8*/ 
    /*0*/ <-1.01405,6.92555,-2.15222>,
    /*1*/ <-1.00117,6.93018,-2.15452>,<-1.02214,6.9319,-2.14291>,<-1.01883,6.91458,-2.15923>,
            
    /*2*/ <-1.2386,7.31967,-2.61631>

    /* stem 0.4.3.9*/ 
    /*0*/ <-1.07283,7.07547,-2.1795>,
    /*1*/ <-1.08058,7.07407,-2.17053>,<-1.07659,7.07962,-2.19005>,<-1.06131,7.07272,-2.17794>,
            
    /*2*/ <-0.96195,7.64579,-1.99449>

    /* stem 0.4.3.10*/ 
    /*0*/ <-1.14169,7.30903,-2.2092>,
    /*1*/ <-1.14134,7.30837,-2.21657>,<-1.13769,7.31424,-2.20576>,<-1.14603,7.3045,-2.20527>,
            
    /*2*/ <-1.55964,7.66393,-2.26095>

    /* stem 0.4.3.11*/ 
    /*0*/ <-1.1882,7.49538,-2.22845>,
    /*1*/ <-1.18594,7.49625,-2.22546>,<-1.19146,7.49733,-2.22903>,<-1.18719,7.49255,-2.23085>,
            
    /*2*/ <-0.9384,7.82756,-2.51426>

    /* stem 0.4.4*/ 
    /*0*/ <-0.37781,5.37924,-1.37252>,
    /*1*/ <-0.33083,5.36309,-1.3827>,<-0.39728,5.41839,-1.3982>,<-0.40531,5.35625,-1.33666>,
            
    /*2*/ <-0.43559,5.19194,-1.56922>,<-0.49539,5.24171,-1.58317>,<-0.50262,5.18578,-1.52778>,
            
    /*3*/ <-0.47747,5.09222,-1.81229>,<-0.53204,5.13537,-1.82214>,<-0.54207,5.07201,-1.79346>,
            
    /*4*/ <-0.52572,5.08822,-2.08513>,<-0.57107,5.12921,-2.07861>,<-0.58336,5.06905,-2.07569>,
            
    /*5*/ <-0.55497,5.16641,-2.34608>,<-0.59319,5.2001,-2.33263>,<-0.60523,5.15058,-2.34604>,
            
    /*6*/ <-0.57635,5.31901,-2.57419>,<-0.60766,5.34359,-2.55564>,<-0.61858,5.30778,-2.5786>,
            
    /*7*/ <-0.56201,5.50842,-2.76878>,<-0.58731,5.52717,-2.75321>,<-0.59566,5.50299,-2.77729>,
            
    /*8*/ <-0.54907,5.72238,-2.94051>,<-0.5682,5.73471,-2.92725>,<-0.57425,5.71889,-2.94743>,
            
    /*9*/ <-0.51538,5.94715,-3.09196>,<-0.52818,5.95534,-3.08315>,<-0.53198,5.94615,-3.09763>,
            
    /*10*/ <-0.48705,6.1853,-3.22517>,<-0.49353,6.18887,-3.22045>,<-0.49534,6.18484,-3.22804>,
            
    /*11*/ <-0.4349,6.41619,-3.36218>

    /* stem 0.4.4.0*/ 
    /*0*/ <-0.42613,5.29581,-1.46309>,
    /*1*/ <-0.44022,5.31094,-1.46951>,<-0.4331,5.27589,-1.45824>,<-0.40508,5.30059,-1.46152>,
            
    /*2*/ <-0.28324,4.9995,-2.47488>

    /* stem 0.4.4.1*/ 
    /*0*/ <-0.50519,5.13239,-1.73325>,
    /*1*/ <-0.5046,5.11381,-1.7254>,<-0.49523,5.13645,-1.75033>,<-0.51576,5.14691,-1.72404>,
            
    /*2*/ <-1.30128,4.88566,-2.25682>

    /* stem 0.4.4.2*/ 
    /*0*/ <-0.53011,5.09855,-1.89084>,
    /*1*/ <-0.51734,5.11304,-1.8931>,<-0.54798,5.10007,-1.89836>,<-0.52502,5.08253,-1.88106>,
            
    /*2*/ <-0.22569,4.70516,-2.6936>

    /* stem 0.4.4.3*/ 
    /*0*/ <-0.54774,5.09675,-2.0021>,
    /*1*/ <-0.56625,5.09406,-1.99912>,<-0.5385,5.086,-2.01467>,<-0.53846,5.11019,-1.9925>,
            
    /*2*/ <-0.74214,5.70261,-2.66289>

    /* stem 0.4.4.4*/ 
    /*0*/ <-0.57575,5.14494,-2.24818>,
    /*1*/ <-0.56092,5.13594,-2.2522>,<-0.57816,5.16141,-2.2545>,<-0.58817,5.13746,-2.23783>,
            
    /*2*/ <-0.95971,4.82245,-2.94216>

    /* stem 0.4.4.5*/ 
    /*0*/ <-0.59175,5.23949,-2.44283>,
    /*1*/ <-0.59626,5.25284,-2.43365>,<-0.59882,5.23684,-2.45785>,<-0.58017,5.22879,-2.43698>,
            
    /*2*/ <-0.01326,5.6746,-2.79162>

    /* stem 0.4.4.6*/ 
    /*0*/ <-0.59153,5.41552,-2.66521>,
    /*1*/ <-0.59777,5.40559,-2.67537>,<-0.58009,5.42501,-2.66967>,<-0.59673,5.41597,-2.6506>,
            
    /*2*/ <-1.08716,5.92329,-2.857>

    /* stem 0.4.4.7*/ 
    /*0*/ <-0.57712,5.56701,-2.81026>,
    /*1*/ <-0.56415,5.57047,-2.80464>,<-0.58743,5.5772,-2.81159>,<-0.57979,5.55336,-2.81454>,
            
    /*2*/ <-0.34625,5.71831,-3.43661>

    /* stem 0.4.4.8*/ 
    /*0*/ <-0.55864,5.75546,-2.95889>,
    /*1*/ <-0.57163,5.75864,-2.95751>,<-0.55244,5.75749,-2.97064>,<-0.55186,5.75024,-2.94852>,
            
    /*2*/ <-0.39769,6.3322,-2.77405>

    /* stem 0.4.4.9*/ 
    /*0*/ <-0.53373,5.89994,-3.05717>,
    /*1*/ <-0.52696,5.89411,-3.06403>,<-0.53133,5.91066,-3.05466>,<-0.54291,5.89506,-3.05283>,
            
    /*2*/ <-0.84635,6.07816,-3.51751>

    /* stem 0.4.4.10*/ 
    /*0*/ <-0.51086,6.05163,-3.14853>,
    /*1*/ <-0.51059,6.05551,-3.14159>,<-0.51481,6.05476,-3.15468>,<-0.50719,6.04462,-3.14931>,
            
    /*2*/ <-0.06033,6.30583,-3.30829>

    /* stem 0.4.4.11*/ 
    /*0*/ <-0.46245,6.30522,-3.29574>,
    /*1*/ <-0.46406,6.30458,-3.29747>,<-0.46015,6.30577,-3.29635>,<-0.46315,6.30532,-3.29339>,
            
    /*2*/ <-0.58336,6.75615,-3.35006>

    /* stem 0.4.5*/ 
    /*0*/ <-0.45827,5.33995,-1.74449>,
    /*1*/ <-0.4841,5.38073,-1.74483>,<-0.47916,5.29805,-1.75622>,<-0.41155,5.34108,-1.73241>,
            
    /*2*/ <-0.41819,5.4147,-1.99337>,<-0.41375,5.34029,-2.00363>,<-0.3529,5.37902,-1.9822>,
            
    /*3*/ <-0.34996,5.54345,-2.19142>,<-0.33845,5.48669,-2.22487>,<-0.28927,5.51538,-2.18979>,
            
    /*4*/ <-0.29049,5.70844,-2.3746>,<-0.27812,5.66456,-2.41129>,<-0.23607,5.68711,-2.37741>,
            
    /*5*/ <-0.20804,5.91098,-2.50678>,<-0.19408,5.88144,-2.54483>,<-0.16157,5.89216,-2.50817>,
            
    /*6*/ <-0.15806,6.12027,-2.64694>,<-0.14638,6.09659,-2.67934>,<-0.11809,6.10877,-2.65108>,
            
    /*7*/ <-0.13895,6.34464,-2.76809>,<-0.12922,6.32925,-2.79614>,<-0.10644,6.33936,-2.77385>,
            
    /*8*/ <-0.11817,6.57334,-2.8885>,<-0.11084,6.562,-2.90964>,<-0.09378,6.56933,-2.89278>,
            
    /*9*/ <-0.10947,6.80474,-3.00373>,<-0.10458,6.79771,-3.01809>,<-0.09318,6.80281,-3.00698>,
            
    /*10*/ <-0.15851,7.03099,-3.11718>,<-0.15617,7.02793,-3.1246>,<-0.15054,7.03163,-3.11965>,
            
    /*11*/ <-0.20258,7.26585,-3.2177>

    /* stem 0.4.5.0*/ 
    /*0*/ <-0.41046,5.36868,-1.93218>,
    /*1*/ <-0.41269,5.34883,-1.93579>,<-0.39485,5.37879,-1.94033>,<-0.42383,5.37843,-1.92043>,
            
    /*2*/ <-0.96054,5.5753,-2.72931>

    /* stem 0.4.5.1*/ 
    /*0*/ <-0.34493,5.47735,-2.1444>,
    /*1*/ <-0.33312,5.48789,-2.13358>,<-0.35522,5.48568,-2.15828>,<-0.34646,5.45847,-2.14135>,
            
    /*2*/ <0.3454,5.32391,-2.74836>

    /* stem 0.4.5.2*/ 
    /*0*/ <-0.30006,5.59201,-2.28524>,
    /*1*/ <-0.31752,5.59179,-2.29086>,<-0.28646,5.5922,-2.29754>,<-0.2962,5.59205,-2.26731>,
            
    /*2*/ <-0.31138,6.47688,-2.28464>

    /* stem 0.4.5.3*/ 
    /*0*/ <-0.24603,5.74421,-2.42428>,
    /*1*/ <-0.23082,5.73639,-2.42735>,<-0.24636,5.76039,-2.41796>,<-0.26092,5.73585,-2.42753>,
            
    /*2*/ <-0.24695,6.04735,-3.20058>

    /* stem 0.4.5.4*/ 
    /*0*/ <-0.17102,5.9715,-2.56985>,
    /*1*/ <-0.17809,5.98046,-2.55849>,<-0.17551,5.97301,-2.58525>,<-0.15946,5.96103,-2.56582>,
            
    /*2*/ <0.35782,6.51647,-2.67045>

    /* stem 0.4.5.5*/ 
    /*0*/ <-0.1576,6.03245,-2.60956>,
    /*1*/ <-0.16122,6.02464,-2.62277>,<-0.14448,6.04118,-2.6089>,<-0.1671,6.03153,-2.597>,
            
    /*2*/ <-0.54047,6.6263,-2.85584>

    /* stem 0.4.5.6*/ 
    /*0*/ <-0.13035,6.25915,-2.73812>,
    /*1*/ <-0.11873,6.26258,-2.73004>,<-0.14092,6.26895,-2.74022>,<-0.1314,6.24591,-2.74412>,
            
    /*2*/ <0.19205,6.48708,-3.29814>

    /* stem 0.4.5.7*/ 
    /*0*/ <-0.11913,6.41429,-2.81842>,
    /*1*/ <-0.13285,6.41543,-2.81819>,<-0.11201,6.41902,-2.8292>,<-0.11254,6.40842,-2.80786>,
            
    /*2*/ <-0.06676,6.98788,-2.53215>

    /* stem 0.4.5.8*/ 
    /*0*/ <-0.10405,6.72782,-2.97394>,
    /*1*/ <-0.09588,6.72436,-2.98074>,<-0.10327,6.73774,-2.96885>,<-0.11302,6.72136,-2.97224>,
            
    /*2*/ <-0.36135,6.97051,-3.40694>

    /* stem 0.4.5.9*/ 
    /*0*/ <-0.12134,6.88384,-3.04944>,
    /*1*/ <-0.12223,6.88711,-3.04229>,<-0.12612,6.88596,-3.05539>,<-0.11566,6.87846,-3.05066>,
            
    /*2*/ <0.2077,7.26051,-3.18049>

    /* stem 0.4.5.10*/ 
    /*0*/ <-0.18589,7.18303,-3.18353>,
    /*1*/ <-0.18682,7.18234,-3.18476>,<-0.18471,7.18419,-3.18391>,<-0.18613,7.18257,-3.18192>,
            
    /*2*/ <-0.48254,7.50039,-3.13801>

    /* stem 0.4.6*/ 
    /*0*/ <-0.55233,5.28618,-2.13828>,
    /*1*/ <-0.55757,5.24147,-2.13074>,<-0.52144,5.30077,-2.16855>,<-0.578,5.31632,-2.11553>,
            
    /*2*/ <-0.72506,5.2359,-2.30779>,<-0.69254,5.28927,-2.34182>,<-0.74344,5.30327,-2.2941>,
            
    /*3*/ <-0.89977,5.30214,-2.48153>,<-0.86194,5.34804,-2.50305>,<-0.90327,5.36023,-2.45674>,
            
    /*4*/ <-1.05681,5.42596,-2.63566>,<-1.01704,5.46243,-2.64802>,<-1.05114,5.47202,-2.60549>,
            
    /*5*/ <-1.17883,5.60339,-2.76708>,<-1.13882,5.6285,-2.77145>,<-1.16762,5.636,-2.7345>,
            
    /*6*/ <-1.29897,5.78246,-2.88241>,<-1.26558,5.8033,-2.88617>,<-1.28857,5.80835,-2.85441>,
            
    /*7*/ <-1.40267,5.97818,-2.98964>,<-1.37465,5.99274,-2.99131>,<-1.39311,5.99684,-2.96596>,
            
    /*8*/ <-1.46817,6.19732,-3.08338>,<-1.44564,6.20471,-3.08277>,<-1.45985,6.20843,-3.06414>,
            
    /*9*/ <-1.5717,6.40367,-3.15717>,<-1.5576,6.41081,-3.15779>,<-1.56613,6.41131,-3.14449>,
            
    /*10*/ <-1.68493,6.61305,-3.21045>,<-1.678,6.61684,-3.21086>,<-1.6819,6.61648,-3.204>,
            
    /*11*/ <-1.74773,6.84735,-3.24398>

    /* stem 0.4.6.0*/ 
    /*0*/ <-0.62854,5.28163,-2.21824>,
    /*1*/ <-0.61785,5.29381,-2.22912>,<-0.64766,5.28484,-2.21591>,<-0.62012,5.26624,-2.20969>,
            
    /*2*/ <-0.81055,4.75543,-2.98603>

    /* stem 0.4.6.1*/ 
    /*0*/ <-0.80975,5.30843,-2.40285>,
    /*1*/ <-0.82255,5.30889,-2.38972>,<-0.81253,5.2985,-2.41803>,<-0.79417,5.3179,-2.40081>,
            
    /*2*/ <-1.18455,6.0094,-2.7927>

    /* stem 0.4.6.2*/ 
    /*0*/ <-0.99185,5.41557,-2.58123>,
    /*1*/ <-0.98678,5.40565,-2.5942>,<-0.99192,5.43258,-2.583>,<-0.99686,5.40849,-2.5665>,
            
    /*2*/ <-1.76147,5.3838,-2.85796>

    /* stem 0.4.6.3*/ 
    /*0*/ <-1.11859,5.56182,-2.71168>,
    /*1*/ <-1.11252,5.57327,-2.70224>,<-1.13436,5.56127,-2.71449>,<-1.10888,5.55093,-2.71832>,
            
    /*2*/ <-1.02679,6.01363,-3.31839>

    /* stem 0.4.6.4*/ 
    /*0*/ <-1.19643,5.67223,-2.79066>,
    /*1*/ <-1.20868,5.66307,-2.79155>,<-1.19166,5.67987,-2.80305>,<-1.18894,5.67374,-2.77738>,
            
    /*2*/ <-1.62492,6.22851,-2.61252>

    /* stem 0.4.6.5*/ 
    /*0*/ <-1.24382,5.74002,-2.83575>,
    /*1*/ <-1.23156,5.74345,-2.84347>,<-1.25235,5.75085,-2.83012>,<-1.24755,5.72576,-2.83365>,
            
    /*2*/ <-1.62025,5.75126,-3.42797>

    /* stem 0.4.6.6*/ 
    /*0*/ <-1.33987,5.89836,-2.93098>,
    /*1*/ <-1.34621,5.9016,-2.91901>,<-1.34656,5.89999,-2.94308>,<-1.32682,5.89348,-2.93084>,
            
    /*2*/ <-1.11167,6.50729,-2.97508>

    /* stem 0.4.6.7*/ 
    /*0*/ <-1.4106,6.05394,-3.01082>,
    /*1*/ <-1.41308,6.04812,-3.02224>,<-1.40559,6.06599,-3.01059>,<-1.41312,6.04771,-2.99964>,
            
    /*2*/ <-1.97053,6.2865,-3.00764>

    /* stem 0.4.6.8*/ 
    /*0*/ <-1.51892,6.3202,-3.12023>,
    /*1*/ <-1.51095,6.32618,-3.11534>,<-1.52958,6.32289,-3.11875>,<-1.51622,6.31152,-3.12659>,
            
    /*2*/ <-1.49747,6.639,-3.54582>

    /* stem 0.4.6.9*/ 
    /*0*/ <-1.60248,6.47491,-3.17087>,
    /*1*/ <-1.60918,6.47159,-3.16918>,<-1.602,6.47979,-3.17676>,<-1.59626,6.47334,-3.16668>,
            
    /*2*/ <-1.71062,6.84547,-2.87194>

    /* stem 0.4.6.10*/ 
    /*0*/ <-1.72902,6.78172,-3.23392>,
    /*1*/ <-1.72819,6.7818,-3.2349>,<-1.72909,6.78267,-3.23305>,<-1.72978,6.78068,-3.2338>,
            
    /*2*/ <-2.01453,6.96388,-3.45881>

    /* stem 0.4.7*/ 
    /*0*/ <-0.72763,5.22197,-2.69463>,
    /*1*/ <-0.69817,5.24925,-2.7065>,<-0.76768,5.22867,-2.7048>,<-0.71703,5.188,-2.67259>,
            
    /*2*/ <-0.67227,5.1335,-2.89345>,<-0.73482,5.11499,-2.89192>,<-0.68924,5.07837,-2.86294>,
            
    /*3*/ <-0.65493,5.06738,-3.09835>,<-0.71047,5.05064,-3.09861>,<-0.66898,5.01325,-3.08296>,
            
    /*4*/ <-0.69194,5.08548,-3.31224>,<-0.74083,5.07361,-3.30553>,<-0.70686,5.03703,-3.31465>,
            
    /*5*/ <-0.72131,5.17341,-3.50548>,<-0.76381,5.16425,-3.50393>,<-0.73598,5.13552,-3.52103>,
            
    /*6*/ <-0.73928,5.30098,-3.6802>,<-0.77498,5.29485,-3.68173>,<-0.75209,5.27327,-3.69976>,
            
    /*7*/ <-0.73038,5.47201,-3.8114>,<-0.75895,5.4704,-3.81616>,<-0.74054,5.4561,-3.83342>,
            
    /*8*/ <-0.72457,5.65641,-3.93266>,<-0.74599,5.65518,-3.9362>,<-0.73212,5.64567,-3.95>,
            
    /*9*/ <-0.76351,5.84418,-4.0466>,<-0.77763,5.84102,-4.04742>,<-0.76859,5.83658,-4.05786>,
            
    /*10*/ <-0.8018,6.03637,-4.149>,<-0.80887,6.03486,-4.14944>,<-0.8044,6.03289,-4.1548>,
            
    /*11*/ <-0.84728,6.24262,-4.21423>

    /* stem 0.4.7.0*/ 
    /*0*/ <-0.71227,5.16181,-2.79478>,
    /*1*/ <-0.72988,5.15934,-2.796>,<-0.70108,5.14901,-2.80014>,<-0.70585,5.17708,-2.7882>,
            
    /*2*/ <-0.70496,5.49835,-3.58311>

    /* stem 0.4.7.1*/ 
    /*0*/ <-0.6878,5.07428,-2.99473>,
    /*1*/ <-0.67392,5.06566,-2.9907>,<-0.68738,5.08553,-3.00724>,<-0.70209,5.07166,-2.98625>,
            
    /*2*/ <-0.89277,4.4995,-3.51833>

    /* stem 0.4.7.2*/ 
    /*0*/ <-0.69207,5.05235,-3.17974>,
    /*1*/ <-0.69553,5.06778,-3.17765>,<-0.70082,5.04349,-3.18972>,<-0.67986,5.04577,-3.17186>,
            
    /*2*/ <-0.22623,5.23402,-3.74957>

    /* stem 0.4.7.3*/ 
    /*0*/ <-0.72122,5.0926,-3.36958>,
    /*1*/ <-0.72866,5.08037,-3.37423>,<-0.71193,5.0998,-3.37899>,<-0.72307,5.09764,-3.35552>,
            
    /*2*/ <-1.25916,5.5025,-3.58705>

    /* stem 0.4.7.4*/ 
    /*0*/ <-0.74631,5.20968,-3.57986>,
    /*1*/ <-0.73318,5.2139,-3.57783>,<-0.75613,5.21891,-3.58339>,<-0.74961,5.19623,-3.57836>,
            
    /*2*/ <-0.61599,5.10746,-4.21052>

    /* stem 0.4.7.5*/ 
    /*0*/ <-0.7517,5.34419,-3.72833>,
    /*1*/ <-0.76385,5.34747,-3.72509>,<-0.74798,5.34449,-3.74078>,<-0.74326,5.34061,-3.71912>,
            
    /*2*/ <-0.57928,5.91877,-3.66318>

    /* stem 0.4.7.6*/ 
    /*0*/ <-0.74096,5.51406,-3.851>,
    /*1*/ <-0.73502,5.50823,-3.85966>,<-0.73676,5.52452,-3.84684>,<-0.7511,5.50944,-3.84651>,
            
    /*2*/ <-1.0342,5.78429,-4.2342>

    /* stem 0.4.7.7*/ 
    /*0*/ <-0.75158,5.74393,-3.9936>,
    /*1*/ <-0.74963,5.74945,-3.98486>,<-0.75921,5.74699,-4.00017>,<-0.7459,5.73534,-3.99577>,
            
    /*2*/ <-0.43089,6.01803,-4.23837>

    /* stem 0.4.7.8*/ 
    /*0*/ <-0.78887,5.94542,-4.10488>,
    /*1*/ <-0.79358,5.94299,-4.10792>,<-0.78461,5.9486,-4.10788>,<-0.78843,5.94467,-4.09883>,
            
    /*2*/ <-1.01535,6.3078,-4.04323>

    /* stem 0.4.7.9*/ 
    /*0*/ <-0.81929,6.10492,-4.17241>,
    /*1*/ <-0.81658,6.10538,-4.17271>,<-0.82087,6.10678,-4.17109>,<-0.82043,6.1026,-4.17341>,
            
    /*2*/ <-0.88784,6.2849,-4.51081>

    /* stem 0.4.8*/ 
    /*0*/ <-0.91008,5.18278,-3.35094>,
    /*1*/ <-0.94154,5.18222,-3.34338>,<-0.89696,5.15825,-3.36747>,<-0.89173,5.20789,-3.34196>,
            
    /*2*/ <-0.98036,5.27295,-3.51198>,<-0.94024,5.25137,-3.53367>,<-0.93553,5.29605,-3.51071>,
            
    /*3*/ <-1.02063,5.4145,-3.63808>,<-0.98728,5.40096,-3.66482>,<-0.9795,5.43163,-3.63304>,
            
    /*4*/ <-1.06001,5.54688,-3.77698>,<-1.0303,5.53358,-3.79888>,<-1.02422,5.56248,-3.77305>,
            
    /*5*/ <-1.1286,5.68446,-3.89084>,<-1.10542,5.67729,-3.91413>,<-1.09892,5.70027,-3.89044>,
            
    /*6*/ <-1.21234,5.83551,-3.97714>,<-1.19517,5.83292,-3.99914>,<-1.18795,5.84931,-3.97758>,
            
    /*7*/ <-1.27793,5.99329,-4.07564>,<-1.2632,5.98952,-4.09212>,<-1.25757,6.00264,-4.07483>,
            
    /*8*/ <-1.35777,6.15623,-4.14349>,<-1.34792,6.15566,-4.15711>,<-1.34281,6.1639,-4.14337>,
            
    /*9*/ <-1.42897,6.32612,-4.2098>,<-1.42231,6.32557,-4.21881>,<-1.41874,6.3307,-4.2095>,
            
    /*10*/ <-1.48886,6.50071,-4.27483>,<-1.48547,6.5003,-4.27928>,<-1.48362,6.5027,-4.27456>,
            
    /*11*/ <-1.55268,6.68292,-4.30268>

    /* stem 0.4.8.0*/ 
    /*0*/ <-0.9375,5.24204,-3.46064>,
    /*1*/ <-0.92813,5.23444,-3.46709>,<-0.9373,5.25567,-3.46188>,<-0.94709,5.23602,-3.45294>,
            
    /*2*/ <-1.38827,5.19424,-4.05903>

    /* stem 0.4.8.1*/ 
    /*0*/ <-0.9819,5.37049,-3.6051>,
    /*1*/ <-0.98184,5.37907,-3.59548>,<-0.99181,5.3701,-3.61333>,<-0.97204,5.3623,-3.6065>,
            
    /*2*/ <-0.65573,5.83399,-4.02015>

    /* stem 0.4.8.2*/ 
    /*0*/ <-1.01958,5.48975,-3.72257>,
    /*1*/ <-1.02711,5.48175,-3.72791>,<-1.0113,5.49574,-3.72924>,<-1.02035,5.49175,-3.71055>,
            
    /*2*/ <-1.45688,5.97378,-3.83104>

    /* stem 0.4.8.3*/ 
    /*0*/ <-1.07034,5.60936,-3.834>,
    /*1*/ <-1.05975,5.61366,-3.83547>,<-1.07903,5.61634,-3.83106>,<-1.07224,5.59809,-3.83546>,
            
    /*2*/ <-1.19402,5.70802,-4.43346>

    /* stem 0.4.8.4*/ 
    /*0*/ <-1.1646,5.78042,-3.95126>,
    /*1*/ <-1.17219,5.78024,-3.94387>,<-1.16713,5.78212,-3.96141>,<-1.15448,5.77891,-3.9485>,
            
    /*2*/ <-1.10226,6.33668,-3.87367>

    /* stem 0.4.8.5*/ 
    /*0*/ <-1.30569,6.0726,-4.11267>,
    /*1*/ <-1.3042,6.06984,-4.12123>,<-1.30467,6.08138,-4.11047>,<-1.30819,6.06657,-4.1063>,
            
    /*2*/ <-1.76501,6.15189,-4.21787>

    /* stem 0.4.8.6*/ 
    /*0*/ <-1.39479,6.26217,-4.18768>,
    /*1*/ <-1.3912,6.26593,-4.18197>,<-1.40209,6.26393,-4.18947>,<-1.39107,6.25665,-4.19161>,
            
    /*2*/ <-1.2571,6.55237,-4.4651>

    /* stem 0.4.8.7*/ 
    /*0*/ <-1.46513,6.44338,-4.25507>,
    /*1*/ <-1.46898,6.44166,-4.25599>,<-1.46335,6.44625,-4.25776>,<-1.46305,6.44223,-4.25147>,
            
    /*2*/ <-1.63388,6.72189,-4.06907>

    /* stem 0.4.8.8*/ 
    /*0*/ <-1.50664,6.55751,-4.28442>,
    /*1*/ <-1.50473,6.55806,-4.28543>,<-1.50757,6.55891,-4.28295>,<-1.50762,6.55556,-4.28487>,
            
    /*2*/ <-1.68536,6.70598,-4.53931>

    /* stem 0.5*/ 
    /*0*/ <-0.01331,6.14072,-0.05401>,
    /*1*/ <-0.06149,6.14228,0.02942>,<-0.03123,6.23273,-0.0317>,<0.0238,6.19602,-0.12366>,
            <0.02755,6.08288,-0.11938>,<-0.02516,6.04967,-0.02476>,
    /*2*/ <0.42689,6.16873,0.30039>,<0.45428,6.25059,0.24508>,<0.50408,6.21737,0.16185>,
            <0.50748,6.11497,0.16573>,<0.45977,6.08491,0.25135>,
    /*3*/ <0.9421,6.25331,0.52295>,<0.95516,6.3252,0.46743>,<0.99488,6.29477,0.39051>,
            <1.00637,6.20408,0.39849>,<0.97376,6.17846,0.48034>,
    /*4*/ <1.46864,6.3859,0.68631>,<1.47039,6.4472,0.63339>,<1.5004,6.41914,0.56358>,
            <1.5172,6.34051,0.57336>,<1.49757,6.31997,0.64921>,
    /*5*/ <1.98669,6.50679,0.85532>,<1.98972,6.56033,0.80995>,<2.01625,6.53614,0.74958>,
            <2.0296,6.46766,0.75763>,<2.01134,6.44952,0.82298>,
    /*6*/ <2.49897,6.6482,1.0272>,<2.50022,6.6932,0.98833>,<2.52382,6.67302,0.93761>,
            <2.53716,6.61556,0.94513>,<2.5218,6.60022,1.0005>,
    /*7*/ <2.98357,6.83426,1.22591>,<2.98334,6.87075,1.19363>,<3.00648,6.85553,1.15355>,
            <3.02101,6.80965,1.16106>,<3.00685,6.7965,1.20578>,
    /*8*/ <3.50557,7.00127,1.36133>,<3.50376,7.02905,1.33554>,<3.51721,7.0155,1.30274>,
            <3.52733,6.97934,1.30826>,<3.52014,6.97055,1.34447>,
    /*9*/ <4.01541,7.19126,1.4904>,<4.01315,7.21083,1.47166>,<4.02311,7.20123,1.44825>,
            <4.03153,7.17574,1.45253>,<4.02677,7.16957,1.47858>,
    /*10*/ <4.51579,7.40458,1.61915>,<4.51395,7.41621,1.6077>,<4.52027,7.41054,1.59364>,
            <4.52601,7.3954,1.5964>,<4.52324,7.39172,1.61216>,
    /*11*/ <5.03038,7.57127,1.76027>,<5.03014,7.57543,1.75643>,<5.03222,7.57344,1.75156>,
            <5.03375,7.56804,1.75238>,<5.03261,7.5667,1.75776>,
    /*12*/ <5.03182,7.57098,1.75568>

    /* stem 0.5c0*/ 
    /*0*/ <1.49084,6.38255,0.62117>,
    /*1*/ <1.44689,6.38598,0.67412>,<1.46528,6.44649,0.62351>,<1.519,6.41863,0.56966>,
            <1.5338,6.3409,0.587>,<1.48924,6.32073,0.65156>,
    /*2*/ <1.87099,6.54038,1.00419>,<1.88694,6.59285,0.9603>,<1.93351,6.56869,0.91361>,
            <1.94635,6.50129,0.92864>,<1.90771,6.48379,0.98462>,
    /*3*/ <2.29114,6.69001,1.3402>,<2.30529,6.73468,1.30358>,<2.34512,6.71438,1.26435>,
            <2.35559,6.65716,1.27674>,<2.32223,6.6421,1.32362>,
    /*4*/ <2.67526,6.87991,1.69393>,<2.68613,6.91625,1.66336>,<2.72184,6.901,1.63395>,
            <2.73304,6.85524,1.64634>,<2.70425,6.84221,1.68341>,
    /*5*/ <2.99673,7.14061,2.06356>,<3.00391,7.16815,2.03845>,<3.03505,7.15849,2.01904>,
            <3.04713,7.12499,2.03215>,<3.02344,7.11393,2.05966>,
    /*6*/ <3.31004,7.40085,2.44543>,<3.31544,7.42081,2.42777>,<3.33811,7.4142,2.4143>,
            <3.34672,7.39015,2.42362>,<3.32937,7.3819,2.44286>,
    /*7*/ <3.62525,7.66324,2.82563>,<3.62847,7.67526,2.8149>,<3.64213,7.67123,2.80672>,
            <3.64736,7.65673,2.81239>,<3.63693,7.65179,2.82408>,
    /*8*/ <3.9407,7.96386,3.17679>,<3.94155,7.96776,3.17277>,<3.94623,7.96634,3.16992>,
            <3.94828,7.96157,3.17217>,<3.94486,7.96003,3.17642>,
    /*9*/ <3.94432,7.96391,3.17362>

    /* stem 0.5c0c0*/ 
    /*0*/ <3.32794,7.40158,2.4308>,
    /*1*/ <3.30569,7.40111,2.4371>,<3.31816,7.4214,2.42398>,<3.34414,7.4143,2.42028>,
            <3.34773,7.38962,2.43111>,<3.32397,7.38147,2.44151>,
    /*2*/ <3.44828,7.6356,2.92426>,<3.45581,7.64786,2.91633>,<3.47151,7.64357,2.9141>,
            <3.47368,7.62866,2.92064>,<3.45932,7.62374,2.92692>,
    /*3*/ <3.64431,7.86594,3.39618>,<3.64683,7.87004,3.39319>,<3.65208,7.86832,3.39195>,
            <3.65281,7.86316,3.39417>,<3.648,7.86169,3.39678>,
    /*4*/ <3.64881,7.86583,3.39446>

    /* stem 0.5c0c0.0*/ 
    /*0*/ <3.55755,7.75367,3.16324>,
    /*1*/ <3.55788,7.76196,3.15908>,<3.56529,7.74989,3.1667>,<3.54947,7.74915,3.16393>,
            
    /*2*/ <3.52886,7.83541,3.30541>,<3.53553,7.82455,3.31227>,<3.52129,7.82388,3.30978>,
            
    /*3*/ <3.50293,7.92203,3.44405>,<3.5087,7.91283,3.45094>,<3.49601,7.91232,3.44889>,
            
    /*4*/ <3.4999,8.01305,3.58292>,<3.50513,8.00479,3.5885>,<3.49389,8.00506,3.58809>,
            
    /*5*/ <3.51912,8.11675,3.71058>,<3.52373,8.10987,3.71553>,<3.51415,8.11074,3.71626>,
            
    /*6*/ <3.5495,8.23775,3.8192>,<3.5535,8.23259,3.82388>,<3.5456,8.23365,3.82491>,
            
    /*7*/ <3.59674,8.35745,3.92444>,<3.59991,8.35312,3.92799>,<3.59375,8.35443,3.92927>,
            
    /*8*/ <3.66609,8.49222,3.99069>,<3.66874,8.48944,3.99362>,<3.66439,8.49099,3.99503>,
            
    /*9*/ <3.70203,8.64691,4.03829>,<3.70405,8.64577,4.04052>,<3.70096,8.64626,4.04125>,
            
    /*10*/ <3.75019,8.80454,4.05803>,<3.75123,8.80409,4.05916>,<3.74973,8.8045,4.05957>,
            
    /*11*/ <3.7921,8.96208,4.09116>

    /* stem 0.5c0c0.0.0*/ 
    /*0*/ <3.54087,7.7964,3.24719>,
    /*1*/ <3.54325,7.79382,3.24897>,<3.53747,7.79744,3.24888>,<3.54189,7.79794,3.2437>,
            
    /*2*/ <3.8385,8.27958,3.54773>

    /* stem 0.5c0c0.0.1*/ 
    /*0*/ <3.50078,7.9717,3.53233>,
    /*1*/ <3.49737,7.97228,3.53187>,<3.50288,7.9743,3.53334>,<3.50209,7.96851,3.53179>,
            
    /*2*/ <3.40577,7.84083,4.06952>

    /* stem 0.5c0c0.0.2*/ 
    /*0*/ <3.50683,8.04654,3.63387>,
    /*1*/ <3.50972,8.04755,3.63259>,<3.50664,8.04566,3.63707>,<3.50412,8.04639,3.63195>,
            
    /*2*/ <3.38793,8.54698,3.76404>

    /* stem 0.5c0c0.0.3*/ 
    /*0*/ <3.52954,8.15463,3.75158>,
    /*1*/ <3.52852,8.15283,3.7539>,<3.52879,8.15764,3.75152>,<3.5313,8.15342,3.74934>,
            
    /*2*/ <3.93322,8.26034,4.01169>

    /* stem 0.5c0c0.0.4*/ 
    /*0*/ <3.63712,8.43372,3.9654>,
    /*1*/ <3.63605,8.43517,3.96354>,<3.6395,8.43427,3.96626>,<3.63582,8.43172,3.96639>,
            
    /*2*/ <3.47934,8.67598,4.24552>

    /* stem 0.5c0c0.0.5*/ 
    /*0*/ <3.68588,8.57509,4.01853>,
    /*1*/ <3.68798,8.57442,4.01914>,<3.68474,8.57659,4.01981>,<3.68493,8.57426,4.01663>,
            
    /*2*/ <3.82948,8.84941,3.82686>

    /* stem 0.5c0c0.0.6*/ 
    /*0*/ <3.76775,8.87002,4.07234>,
    /*1*/ <3.76726,8.8701,4.07256>,<3.76796,8.87038,4.072>,<3.76803,8.86957,4.07247>,
            
    /*2*/ <3.89112,9.0093,4.29393>

    /* stem 0.5c0.0*/ 
    /*0*/ <1.73502,6.47295,0.81797>,
    /*1*/ <1.72607,6.42805,0.84969>,<1.73527,6.52369,0.84095>,<1.74371,6.46711,0.76326>,
            
    /*2*/ <2.0259,6.40836,0.89661>,<2.03418,6.49444,0.88874>,<2.04178,6.44352,0.81882>,
            
    /*3*/ <2.32385,6.51913,0.94188>,<2.29921,6.59124,0.92957>,<2.32461,6.54853,0.87051>,
            
    /*4*/ <2.58625,6.65517,1.01617>,<2.55971,6.71592,1.0033>,<2.59116,6.68174,0.95428>,
            
    /*5*/ <2.8039,6.82687,1.14184>,<2.77572,6.87521,1.12701>,<2.81458,6.85212,1.09086>,
            
    /*6*/ <2.99234,7.05624,1.23621>,<2.96131,7.08932,1.21978>,<2.9962,7.07258,1.19099>,
            
    /*7*/ <3.15786,7.27491,1.3626>,<3.13352,7.30181,1.34943>,<3.16385,7.29113,1.3281>,
            
    /*8*/ <3.31728,7.53285,1.42427>,<3.29617,7.54908,1.41292>,<3.31782,7.53971,1.39615>,
            
    /*9*/ <3.4561,7.79786,1.48286>,<3.44142,7.80763,1.47502>,<3.45636,7.80223,1.46407>,
            
    /*10*/ <3.59105,8.07196,1.49362>,<3.58331,8.0761,1.48962>,<3.59045,8.0728,1.48403>,
            
    /*11*/ <3.69157,8.35791,1.45805>

    /* stem 0.5c0.0.0*/ 
    /*0*/ <1.97267,6.45373,0.85779>,
    /*1*/ <1.97423,6.47697,0.85969>,<1.98657,6.44226,0.84291>,<1.95721,6.44196,0.87078>,
            
    /*2*/ <2.76645,6.33219,1.69247>

    /* stem 0.5c0.0.1*/ 
    /*0*/ <2.13111,6.48468,0.88389>,
    /*1*/ <2.13915,6.46936,0.86929>,<2.14105,6.48742,0.90404>,<2.11312,6.49726,0.87833>,
            
    /*2*/ <2.80801,7.25862,0.44449>

    /* stem 0.5c0.0.2*/ 
    /*0*/ <2.42813,6.60897,0.94694>,
    /*1*/ <2.42155,6.61035,0.96704>,<2.44005,6.6244,0.93861>,<2.42281,6.59217,0.93518>,
            
    /*2*/ <3.28691,6.11608,1.26232>

    /* stem 0.5c0.0.3*/ 
    /*0*/ <2.71485,6.7879,1.07102>,
    /*1*/ <2.71613,6.79874,1.05476>,<2.73113,6.78181,1.08005>,<2.69728,6.78315,1.07826>,
            
    /*2*/ <2.71825,7.58014,1.59906>

    /* stem 0.5c0.0.4*/ 
    /*0*/ <2.83389,6.89421,1.13843>,
    /*1*/ <2.8443,6.88152,1.14763>,<2.83105,6.91124,1.14589>,<2.82633,6.88987,1.12176>,
            
    /*2*/ <3.58073,7.20255,0.71925>

    /* stem 0.5c0.0.5*/ 
    /*0*/ <2.92375,7.00158,1.18488>,
    /*1*/ <2.90943,7.01241,1.18757>,<2.939,7.00832,1.1777>,<2.92283,6.98402,1.18938>,
            
    /*2*/ <3.21757,7.19121,1.9868>

    /* stem 0.5c0.0.6*/ 
    /*0*/ <3.06348,7.17581,1.27805>,
    /*1*/ <3.07587,7.17307,1.26664>,<3.06721,7.17662,1.29468>,<3.04735,7.17775,1.27282>,
            
    /*2*/ <3.18145,7.98124,1.21268>

    /* stem 0.5c0.0.7*/ 
    /*0*/ <3.22025,7.39775,1.37451>,
    /*1*/ <3.21762,7.39547,1.38987>,<3.21733,7.4118,1.36803>,<3.22578,7.38598,1.36564>,
            
    /*2*/ <3.91937,7.61264,1.52589>

    /* stem 0.5c0.0.8*/ 
    /*0*/ <3.35979,7.63237,1.43314>,
    /*1*/ <3.35355,7.63849,1.42162>,<3.37341,7.63577,1.43665>,<3.35242,7.62285,1.44116>,
            
    /*2*/ <3.13226,8.13892,1.82538>

    /* stem 0.5c0.0.9*/ 
    /*0*/ <3.50485,7.90855,1.47989>,
    /*1*/ <3.51254,7.90453,1.48214>,<3.50238,7.91613,1.48399>,<3.49962,7.90498,1.47355>,
            
    /*2*/ <3.79543,8.23028,1.05945>

    /* stem 0.5c0.0.10*/ 
    /*0*/ <3.65656,8.26155,1.46857>,
    /*1*/ <3.65499,8.26221,1.46938>,<3.6571,8.26221,1.46689>,<3.65759,8.26023,1.46944>,
            
    /*2*/ <3.92983,8.62661,1.6997>

    /* stem 0.5c0.1*/ 
    /*0*/ <2.0509,6.58877,1.07568>,
    /*1*/ <2.03582,6.63921,1.07183>,<2.09973,6.57466,1.06142>,<2.01716,6.55244,1.09379>,
            
    /*2*/ <2.12915,6.68202,1.33929>,<2.18668,6.62392,1.32992>,<2.11236,6.60392,1.35906>,
            
    /*3*/ <2.19578,6.78317,1.58678>,<2.25064,6.73516,1.59272>,<2.18406,6.71787,1.61758>,
            
    /*4*/ <2.28749,6.92734,1.80958>,<2.33674,6.88707,1.81657>,<2.28149,6.8756,1.84677>,
            
    /*5*/ <2.3656,7.10076,2.01756>,<2.40948,7.06961,2.0282>,<2.36206,7.05994,2.05404>,
            
    /*6*/ <2.43743,7.2851,2.22284>,<2.47442,7.26032,2.23318>,<2.43476,7.25212,2.25439>,
            
    /*7*/ <2.5096,7.49022,2.40552>,<2.53974,7.47186,2.41513>,<2.5085,7.46658,2.4334>,
            
    /*8*/ <2.60186,7.69169,2.58848>,<2.62401,7.67668,2.59451>,<2.60107,7.67381,2.60926>,
            
    /*9*/ <2.73261,7.91545,2.70597>,<2.74736,7.90528,2.70962>,<2.73393,7.90665,2.72194>,
            
    /*10*/ <2.85552,8.15341,2.80518>,<2.86315,8.1488,2.8072>,<2.85651,8.14963,2.81344>,
            
    /*11*/ <2.94035,8.41258,2.89052>

    /* stem 0.5c0.1.0*/ 
    /*0*/ <2.11534,6.62235,1.26309>,
    /*1*/ <2.13314,6.60953,1.25927>,<2.10465,6.62103,1.28258>,<2.10823,6.63648,1.24743>,
            
    /*2*/ <2.76683,7.40462,1.67323>

    /* stem 0.5c0.1.1*/ 
    /*0*/ <2.16483,6.67228,1.42676>,
    /*1*/ <2.14431,6.67061,1.43287>,<2.17673,6.68884,1.4335>,<2.17346,6.65738,1.41392>,
            
    /*2*/ <2.46141,6.11555,2.27179>

    /* stem 0.5c0.1.2*/ 
    /*0*/ <2.26295,6.83244,1.72865>,
    /*1*/ <2.27395,6.84379,1.71656>,<2.27112,6.82443,1.74493>,<2.24379,6.82911,1.72447>,
            
    /*2*/ <2.01505,7.61732,2.2395>

    /* stem 0.5c0.1.3*/ 
    /*0*/ <2.34591,6.99941,1.9435>,
    /*1*/ <2.34784,6.98503,1.95519>,<2.33584,7.01423,1.94857>,<2.35406,6.99896,1.92676>,
            
    /*2*/ <3.08304,7.38126,2.29196>

    /* stem 0.5c0.1.4*/ 
    /*0*/ <2.39862,7.12977,2.09032>,
    /*1*/ <2.38614,7.14083,2.08433>,<2.41429,7.13612,2.0956>,<2.39542,7.11236,2.09104>,
            
    /*2*/ <2.09657,7.2179,2.88159>

    /* stem 0.5c0.1.5*/ 
    /*0*/ <2.47892,7.35563,2.31414>,
    /*1*/ <2.49465,7.35228,2.31192>,<2.47357,7.36011,2.3288>,<2.46855,7.35451,2.30171>,
            
    /*2*/ <2.61157,8.09585,2.13645>

    /* stem 0.5c0.1.6*/ 
    /*0*/ <2.54874,7.54339,2.47694>,
    /*1*/ <2.53751,7.54003,2.48639>,<2.55112,7.55769,2.47285>,<2.5576,7.53246,2.47158>,
            
    /*2*/ <2.98799,7.62821,3.0292>

    /* stem 0.5c0.1.7*/ 
    /*0*/ <2.67339,7.79478,2.65489>,
    /*1*/ <2.67449,7.80019,2.6429>,<2.68403,7.79365,2.66262>,<2.66165,7.79049,2.65914>,
            
    /*2*/ <2.55489,8.36287,2.90069>

    /* stem 0.5c0.1.8*/ 
    /*0*/ <2.79183,8.01714,2.75549>,
    /*1*/ <2.7963,8.0128,2.76082>,<2.78868,8.02437,2.75773>,<2.79052,8.01426,2.74793>,
            
    /*2*/ <3.26001,8.27696,2.57494>

    /* stem 0.5c0.1.9*/ 
    /*0*/ <2.89316,8.26174,2.84336>,
    /*1*/ <2.8903,8.26274,2.84303>,<2.89547,8.26334,2.8422>,<2.8937,8.25914,2.84484>,
            
    /*2*/ <2.93198,8.51394,3.2709>

    /* stem 0.5c0.2*/ 
    /*0*/ <2.57878,6.81588,1.54472>,
    /*1*/ <2.60906,6.78823,1.52756>,<2.57155,6.81648,1.58858>,<2.55573,6.84295,1.51802>,
            
    /*2*/ <2.78565,6.97075,1.55644>,<2.75189,6.99618,1.61136>,<2.73766,7.02,1.54786>,
            
    /*3*/ <2.92663,7.18814,1.60688>,<2.88932,7.20237,1.65378>,<2.87705,7.22338,1.5972>,
            
    /*4*/ <3.06531,7.39859,1.64297>,<3.03413,7.41297,1.68452>,<3.02198,7.42956,1.63469>,
            
    /*5*/ <3.16324,7.63944,1.65438>,<3.13545,7.64978,1.68981>,<3.12144,7.65746,1.64646>,
            
    /*6*/ <3.22977,7.88862,1.68062>,<3.20496,7.89273,1.70977>,<3.19353,7.89959,1.67366>,
            
    /*7*/ <3.32042,8.12013,1.73291>,<3.30049,8.12319,1.7562>,<3.2927,8.13261,1.72793>,
            
    /*8*/ <3.42369,8.35069,1.76134>,<3.40974,8.35511,1.77921>,<3.40318,8.36071,1.75779>,
            
    /*9*/ <3.53746,8.57791,1.78168>,<3.52854,8.58156,1.79369>,<3.52403,8.5851,1.7794>,
            
    /*10*/ <3.60106,8.82643,1.76738>,<3.59653,8.82805,1.77338>,<3.5937,8.82836,1.76623>,
            
    /*11*/ <3.69971,9.05994,1.74047>

    /* stem 0.5c0.2.0*/ 
    /*0*/ <2.7161,6.95332,1.56549>,
    /*1*/ <2.70882,6.95809,1.58202>,<2.7221,6.96655,1.55375>,<2.71738,6.9353,1.5607>,
            
    /*2*/ <3.60307,6.90918,1.96887>

    /* stem 0.5c0.2.1*/ 
    /*0*/ <2.80477,7.06522,1.58767>,
    /*1*/ <2.80377,7.06984,1.57022>,<2.82041,7.06687,1.59658>,<2.79011,7.05896,1.59621>,
            
    /*2*/ <2.57272,7.943,1.83313>

    /* stem 0.5c0.2.2*/ 
    /*0*/ <2.96379,7.30143,1.63539>,
    /*1*/ <2.97382,7.29284,1.64589>,<2.95661,7.31583,1.64047>,<2.96094,7.29563,1.6198>,
            
    /*2*/ <3.65246,7.74797,1.34326>

    /* stem 0.5c0.2.3*/ 
    /*0*/ <3.10007,7.55446,1.65974>,
    /*1*/ <3.08565,7.56057,1.65977>,<3.11072,7.55961,1.64948>,<3.10383,7.54322,1.66996>,
            
    /*2*/ <3.33705,8.11142,2.18523>

    /* stem 0.5c0.2.4*/ 
    /*0*/ <3.16557,7.73894,1.67255>,
    /*1*/ <3.17681,7.73669,1.66315>,<3.16794,7.74588,1.68543>,<3.15194,7.73424,1.66906>,
            
    /*2*/ <3.02196,8.40164,1.34199>

    /* stem 0.5c0.2.5*/ 
    /*0*/ <3.25864,8.01353,1.7144>,
    /*1*/ <3.25555,8.01191,1.72752>,<3.25581,8.02524,1.70816>,<3.26456,8.00343,1.70753>,
            
    /*2*/ <3.87392,8.25551,1.88914>

    /* stem 0.5c0.2.6*/ 
    /*0*/ <3.37431,8.27449,1.75658>,
    /*1*/ <3.36902,8.2782,1.74608>,<3.38646,8.27582,1.75815>,<3.36745,8.26945,1.76549>,
            
    /*2*/ <3.28157,8.83096,2.00022>

    /* stem 0.5c0.2.7*/ 
    /*0*/ <3.49408,8.5126,1.77919>,
    /*1*/ <3.50259,8.50789,1.78244>,<3.49028,8.52052,1.78445>,<3.48938,8.50938,1.77067>,
            
    /*2*/ <3.79988,8.85842,1.47967>

    /* stem 0.5c0.2.8*/ 
    /*0*/ <3.55407,8.66978,1.77921>,
    /*1*/ <3.54756,8.67172,1.78187>,<3.5564,8.67255,1.77288>,<3.55824,8.66506,1.78289>,
            
    /*2*/ <3.77175,9.05699,2.02893>

    /* stem 0.5c0.2.9*/ 
    /*0*/ <3.62812,8.89785,1.76037>,
    /*1*/ <3.62938,8.89696,1.75768>,<3.62972,8.89966,1.76231>,<3.62525,8.89693,1.76112>,
            
    /*2*/ <3.45814,9.26486,1.55925>

    /* stem 0.5c0.3*/ 
    /*0*/ <2.92704,7.06331,1.93017>,
    /*1*/ <2.90045,7.06264,1.95293>,<2.93802,7.09382,1.91698>,<2.94266,7.03348,1.92061>,
            
    /*2*/ <3.05267,7.08476,2.12607>,<3.08648,7.11283,2.09372>,<3.09066,7.05852,2.09698>,
            
    /*3*/ <3.17381,7.16849,2.30066>,<3.20292,7.19226,2.27>,<3.21391,7.14707,2.28377>,
            
    /*4*/ <3.30766,7.284,2.45449>,<3.32915,7.30228,2.42279>,<3.34252,7.2654,2.439>,
            
    /*5*/ <3.43342,7.41371,2.5993>,<3.45113,7.42867,2.57127>,<3.4641,7.39855,2.58699>,
            
    /*6*/ <3.51754,7.60012,2.70641>,<3.53044,7.6096,2.68066>,<3.54587,7.5917,2.69964>,
            
    /*7*/ <3.57289,7.80035,2.80576>,<3.58329,7.80802,2.78525>,<3.59645,7.79615,2.80181>,
            
    /*8*/ <3.60035,8.01491,2.88668>,<3.60806,8.02008,2.87104>,<3.61837,8.01365,2.88457>,
            
    /*9*/ <3.61674,8.23251,2.96341>,<3.62188,8.23597,2.95299>,<3.6288,8.23219,2.96221>,
            
    /*10*/ <3.64955,8.45139,3.03338>,<3.65209,8.4528,3.02805>,<3.65554,8.45082,3.03263>,
            
    /*11*/ <3.68166,8.67452,3.08708>

    /* stem 0.5c0.3.0*/ 
    /*0*/ <3.01164,7.07579,2.02939>,
    /*1*/ <3.01956,7.08553,2.02141>,<3.01855,7.06508,2.03706>,<2.9968,7.07676,2.02971>,
            
    /*2*/ <3.06227,7.61714,2.74012>

    /* stem 0.5c0.3.1*/ 
    /*0*/ <3.11589,7.11277,2.16412>,
    /*1*/ <3.11703,7.09964,2.16951>,<3.11232,7.12365,2.17259>,<3.11831,7.11503,2.15028>,
            
    /*2*/ <3.94003,7.25299,2.33141>

    /* stem 0.5c0.3.2*/ 
    /*0*/ <3.27007,7.23402,2.37177>,
    /*1*/ <3.26141,7.24398,2.37164>,<3.283,7.2365,2.37078>,<3.2658,7.22158,2.37289>,
            
    /*2*/ <3.31977,7.28725,3.15212>

    /* stem 0.5c0.3.3*/ 
    /*0*/ <3.39039,7.35129,2.51517>,
    /*1*/ <3.40085,7.34774,2.50954>,<3.38947,7.35066,2.52751>,<3.38085,7.35547,2.50845>,
            
    /*2*/ <3.65033,8.03204,2.5692>

    /* stem 0.5c0.3.4*/ 
    /*0*/ <3.47521,7.47231,2.6203>,
    /*1*/ <3.46861,7.46972,2.62963>,<3.47448,7.48291,2.61536>,<3.48255,7.46429,2.61591>,
            
    /*2*/ <3.97226,7.70015,3.03546>

    /* stem 0.5c0.3.5*/ 
    /*0*/ <3.59169,7.86648,2.82277>,
    /*1*/ <3.59086,7.87016,2.8135>,<3.59864,7.8701,2.82899>,<3.58556,7.85918,2.82581>,
            
    /*2*/ <3.21667,8.26026,3.01273>

    /* stem 0.5c0.3.6*/ 
    /*0*/ <3.61597,8.12916,2.9217>,
    /*1*/ <3.62208,8.12672,2.92736>,<3.60905,8.13363,2.92443>,<3.61678,8.12712,2.9133>,
            
    /*2*/ <3.86502,8.56477,2.84016>

    /* stem 0.5c0.3.7*/ 
    /*0*/ <3.64327,8.38518,3.00946>,
    /*1*/ <3.63876,8.38586,3.00927>,<3.64612,8.38818,3.00753>,<3.64494,8.38149,3.01158>,
            
    /*2*/ <3.66142,8.61217,3.38949>

    /* stem 0.5c0.3.8*/ 
    /*0*/ <3.66119,8.51869,3.04811>,
    /*1*/ <3.66317,8.51879,3.04667>,<3.66128,8.51961,3.05037>,<3.65913,8.51766,3.04729>,
            
    /*2*/ <3.53791,8.88178,2.90473>

    /* stem 0.5c0.4*/ 
    /*0*/ <3.21355,7.30448,2.286>,
    /*1*/ <3.22388,7.32021,2.26728>,<3.22875,7.28627,2.29791>,<3.18801,7.30695,2.2928>,
            
    /*2*/ <3.27565,7.45898,2.41631>,<3.28004,7.42844,2.44387>,<3.24337,7.44705,2.43928>,
            
    /*3*/ <3.33242,7.60866,2.54884>,<3.33731,7.58376,2.57547>,<3.30457,7.59996,2.57122>,
            
    /*4*/ <3.3423,7.78409,2.66186>,<3.34729,7.76697,2.68865>,<3.3173,7.77443,2.67967>,
            
    /*5*/ <3.35073,7.9683,2.75958>,<3.35512,7.95564,2.78369>,<3.32936,7.96116,2.77551>,
            
    /*6*/ <3.34962,8.15521,2.8557>,<3.35325,8.14507,2.876>,<3.33178,8.14872,2.86866>,
            
    /*7*/ <3.33371,8.33742,2.96099>,<3.33658,8.3287,2.97692>,<3.31945,8.33086,2.97058>,
            
    /*8*/ <3.32113,8.52283,3.05802>,<3.32325,8.51676,3.07022>,<3.31041,8.51838,3.06546>,
            
    /*9*/ <3.32438,8.70402,3.16466>,<3.32583,8.69948,3.17252>,<3.31724,8.70126,3.16975>,
            
    /*10*/ <3.32191,8.88982,3.26234>,<3.32263,8.88775,3.26639>,<3.31834,8.88848,3.26491>,
            
    /*11*/ <3.35237,9.07893,3.34797>

    /* stem 0.5c0.4.0*/ 
    /*0*/ <3.23511,7.36179,2.34609>,
    /*1*/ <3.2382,7.35333,2.35305>,<3.22833,7.3701,2.34989>,<3.2388,7.36194,2.33533>,
            
    /*2*/ <3.89296,7.79262,2.57778>

    /* stem 0.5c0.4.1*/ 
    /*0*/ <3.29184,7.51143,2.49077>,
    /*1*/ <3.28311,7.51707,2.48812>,<3.30139,7.51629,2.49134>,<3.29103,7.50094,2.49284>,
            
    /*2*/ <3.16757,7.66771,3.23231>

    /* stem 0.5c0.4.2*/ 
    /*0*/ <3.33993,7.86016,2.72056>,
    /*1*/ <3.34924,7.86048,2.71903>,<3.33649,7.86211,2.72913>,<3.33407,7.85789,2.71352>,
            
    /*2*/ <3.29063,8.50332,2.55428>

    /* stem 0.5c0.4.3*/ 
    /*0*/ <3.34494,8.09697,2.84047>,
    /*1*/ <3.33929,8.09405,2.8463>,<3.34316,8.10409,2.83594>,<3.35235,8.09277,2.83918>,
            
    /*2*/ <3.60943,8.433,3.26475>

    /* stem 0.5c0.4.4*/ 
    /*0*/ <3.33886,8.22318,2.90812>,
    /*1*/ <3.339,8.22719,2.901>,<3.34371,8.22557,2.91426>,<3.33387,8.21677,2.90911>,
            
    /*2*/ <2.93025,8.57018,3.0958>

    /* stem 0.5c0.4.5*/ 
    /*0*/ <3.32667,8.38434,2.99594>,
    /*1*/ <3.33144,8.38189,3.00134>,<3.32069,8.38864,2.99782>,<3.32789,8.38249,2.98867>,
            
    /*2*/ <3.61731,8.81584,2.93489>

    /* stem 0.5c0.4.6*/ 
    /*0*/ <3.32145,8.82808,3.23359>,
    /*1*/ <3.318,8.82836,3.23298>,<3.32352,8.83091,3.23335>,<3.32284,8.82496,3.23444>,
            
    /*2*/ <3.259,8.90626,3.62388>

    /* stem 0.5c0.4.7*/ 
    /*0*/ <3.32896,8.93714,3.28579>,
    /*1*/ <3.33066,8.93729,3.2848>,<3.32886,8.93772,3.28768>,<3.32735,8.9364,3.2849>,
            
    /*2*/ <3.23278,9.28086,3.17496>

    /* stem 0.5c0.5*/ 
    /*0*/ <3.78261,7.80641,2.98642>,
    /*1*/ <3.78478,7.7984,2.99129>,<3.77786,7.81356,2.99078>,<3.7852,7.80728,2.9772>,
            
    /*2*/ <3.92984,7.86709,3.0379>,<3.92362,7.88073,3.03744>,<3.93022,7.87508,3.02521>,
            
    /*3*/ <4.06152,7.96719,3.07238>,<4.05368,7.97793,3.07135>,<4.06005,7.97327,3.0606>,
            
    /*4*/ <4.17173,8.09183,3.09927>,<4.16322,8.0997,3.09796>,<4.16942,8.09622,3.08871>,
            
    /*5*/ <4.28804,8.21213,3.1044>,<4.28094,8.2191,3.1034>,<4.28531,8.21522,3.09529>,
            
    /*6*/ <4.38658,8.33965,3.14765>,<4.38024,8.34496,3.14661>,<4.3853,8.34321,3.14023>,
            
    /*7*/ <4.48263,8.46186,3.20814>,<4.47766,8.46622,3.20732>,<4.48205,8.4652,3.2024>,
            
    /*8*/ <4.56407,8.59661,3.26539>,<4.56003,8.59943,3.26456>,<4.56347,8.59887,3.26097>,
            
    /*9*/ <4.62573,8.74493,3.31308>,<4.62282,8.74639,3.31236>,<4.62519,8.74615,3.31003>,
            
    /*10*/ <4.70732,8.88856,3.33855>,<4.70592,8.88942,3.33824>,<4.70697,8.88905,3.337>,
            
    /*11*/ <4.77328,9.04045,3.36186>

    /* stem 0.5c0.5.0*/ 
    /*0*/ <3.83878,7.83266,3.00463>,
    /*1*/ <3.8369,7.83629,3.00519>,<3.84266,7.83254,3.00323>,<3.83678,7.82915,3.00547>,
            
    /*2*/ <4.06155,7.85294,3.61816>

    /* stem 0.5c0.5.1*/ 
    /*0*/ <4.11694,8.03848,3.08262>,
    /*1*/ <4.11918,8.03702,3.08016>,<4.11819,8.03936,3.08592>,<4.11345,8.03905,3.08179>,
            
    /*2*/ <4.24663,8.55744,2.89486>

    /* stem 0.5c0.5.2*/ 
    /*0*/ <4.20336,8.13204,3.09704>,
    /*1*/ <4.20303,8.13219,3.10048>,<4.20378,8.13494,3.09521>,<4.20326,8.12898,3.09543>,
            
    /*2*/ <4.73499,8.08777,3.14987>

    /* stem 0.5c0.5.3*/ 
    /*0*/ <4.35042,8.29955,3.13>,
    /*1*/ <4.34951,8.30114,3.12744>,<4.35346,8.29944,3.13078>,<4.34828,8.29808,3.13177>,
            
    /*2*/ <4.29701,8.69747,3.39592>

    /* stem 0.5c0.5.4*/ 
    /*0*/ <4.51649,8.5229,3.23115>,
    /*1*/ <4.51849,8.5213,3.23203>,<4.51572,8.52506,3.23262>,<4.51524,8.52235,3.2288>,
            
    /*2*/ <4.78984,8.75562,3.0324>

    /* stem 0.5c0.5.5*/ 
    /*0*/ <4.58181,8.64414,3.27861>,
    /*1*/ <4.57951,8.64488,3.27931>,<4.58315,8.64556,3.27704>,<4.58275,8.64199,3.27948>,
            
    /*2*/ <4.72982,8.82689,3.57108>

    /* stem 0.5c0.5.6*/ 
    /*0*/ <4.72642,8.93381,3.34501>,
    /*1*/ <4.72678,8.93374,3.34444>,<4.72673,8.93398,3.34559>,<4.72575,8.93371,3.345>,
            
    /*2*/ <4.6848,9.21999,3.2835>

    /* stem 0.5c1*/ 
    /*0*/ <3.00025,6.83334,1.18799>,
    /*1*/ <2.97123,6.83405,1.21755>,<2.9799,6.86932,1.18509>,<3.0167,6.85486,1.15663>,
            <3.03076,6.81066,1.1715>,<3.00266,6.7978,1.20916>,
    /*2*/ <3.34255,7.06869,1.56354>,<3.34931,7.09617,1.53824>,<3.37797,7.0849,1.51607>,
            <3.38893,7.05047,1.52766>,<3.36704,7.04045,1.557>,
    /*3*/ <3.70099,7.299,1.92393>,<3.70629,7.31899,1.90628>,<3.72735,7.31128,1.89092>,
            <3.73507,7.28652,1.89907>,<3.71878,7.27893,1.91947>,
    /*4*/ <4.08889,7.5126,2.26754>,<4.09202,7.52462,2.25679>,<4.10403,7.51951,2.24682>,
            <4.10833,7.50433,2.25141>,<4.09897,7.50006,2.26421>,
    /*5*/ <4.49352,7.71497,2.59705>,<4.49457,7.7191,2.59332>,<4.49854,7.71725,2.58973>,
            <4.49994,7.71197,2.59125>,<4.49684,7.71057,2.59577>,
    /*6*/ <4.49668,7.71477,2.59342>

    /* stem 0.5c1.0*/ 
    /*0*/ <3.19141,6.95634,1.37265>,
    /*1*/ <3.21787,6.93448,1.35982>,<3.17937,6.95229,1.40702>,<3.17698,6.98224,1.35111>,
            
    /*2*/ <3.37804,7.08975,1.43612>,<3.34339,7.10578,1.47861>,<3.34124,7.13272,1.42829>,
            
    /*3*/ <3.49103,7.2909,1.51679>,<3.45443,7.29828,1.5512>,<3.45038,7.31894,1.50499>,
            
    /*4*/ <3.60593,7.49303,1.53938>,<3.57801,7.50594,1.57143>,<3.56921,7.51579,1.52901>,
            
    /*5*/ <3.71973,7.69865,1.56089>,<3.69576,7.70962,1.58838>,<3.688,7.71773,1.55199>,
            
    /*6*/ <3.83335,7.89768,1.61915>,<3.81163,7.90408,1.64138>,<3.80774,7.91493,1.61182>,
            
    /*7*/ <3.95609,8.09629,1.63902>,<3.94069,8.10433,1.65753>,<3.9355,8.11,1.63333>,
            
    /*8*/ <4.07297,8.30024,1.66306>,<4.06108,8.30573,1.67687>,<4.05725,8.31006,1.65873>,
            
    /*9*/ <4.19364,8.4938,1.72315>,<4.18509,8.49655,1.73212>,<4.18364,8.5011,1.72036>,
            
    /*10*/ <4.28165,8.70764,1.77427>,<4.27713,8.70856,1.77862>,<4.27617,8.71038,1.77262>,
            
    /*11*/ <4.37285,8.92368,1.79724>

    /* stem 0.5c1.0.0*/ 
    /*0*/ <3.31102,7.0688,1.42776>,
    /*1*/ <3.30286,7.07117,1.44064>,<3.31503,7.08074,1.41886>,<3.31518,7.05448,1.42379>,
            
    /*2*/ <4.07592,7.16116,1.8956>

    /* stem 0.5c1.0.1*/ 
    /*0*/ <3.4,7.18908,1.47926>,
    /*1*/ <3.40109,7.19398,1.46531>,<3.41173,7.18979,1.48832>,<3.38717,7.18346,1.48417>,
            
    /*2*/ <3.15399,7.97539,1.73625>

    /* stem 0.5c1.0.2*/ 
    /*0*/ <3.53042,7.41329,1.53651>,
    /*1*/ <3.5386,7.40742,1.546>,<3.52368,7.42501,1.53947>,<3.52897,7.40744,1.52406>,
            
    /*2*/ <4.14997,7.83821,1.26493>

    /* stem 0.5c1.0.3*/ 
    /*0*/ <3.66552,7.64647,1.56084>,
    /*1*/ <3.65445,7.6529,1.56004>,<3.67571,7.6504,1.55411>,<3.6664,7.63613,1.56835>,
            
    /*2*/ <3.87202,8.0719,2.12206>

    /* stem 0.5c1.0.4*/ 
    /*0*/ <3.76077,7.80948,1.59629>,
    /*1*/ <3.77004,7.80601,1.58935>,<3.76285,7.81498,1.60685>,<3.74942,7.80746,1.59266>,
            
    /*2*/ <3.75299,8.42002,1.27995>

    /* stem 0.5c1.0.5*/ 
    /*0*/ <3.98295,8.16906,1.65074>,
    /*1*/ <3.98039,8.16943,1.66087>,<3.98335,8.17788,1.64513>,<3.98511,8.15989,1.64622>,
            
    /*2*/ <4.54745,8.23276,1.79089>

    /* stem 0.5c1.0.6*/ 
    /*0*/ <4.11938,8.39158,1.69274>,
    /*1*/ <4.11696,8.39562,1.68467>,<4.12838,8.39107,1.6952>,<4.1128,8.38805,1.69836>,
            
    /*2*/ <4.07966,8.85163,1.93504>

    /* stem 0.5c1.0.7*/ 
    /*0*/ <4.21352,8.55789,1.73954>,
    /*1*/ <4.21851,8.55513,1.74218>,<4.21024,8.56216,1.74276>,<4.21183,8.55638,1.73369>,
            
    /*2*/ <4.49336,8.90093,1.56988>

    /* stem 0.5c1.0.8*/ 
    /*0*/ <4.32109,8.80605,1.78516>,
    /*1*/ <4.31929,8.80679,1.78567>,<4.32228,8.80708,1.78392>,<4.32169,8.80428,1.78589>,
            
    /*2*/ <4.48983,8.99536,2.10496>

    /* stem 0.5c1.1*/ 
    /*0*/ <3.90498,7.40385,2.07981>,
    /*1*/ <3.89225,7.40435,2.09339>,<3.91506,7.41903,2.07593>,<3.90765,7.38818,2.07011>,
            
    /*2*/ <4.02507,7.34902,2.21748>,<4.0456,7.36224,2.20177>,<4.03893,7.33447,2.19653>,
            
    /*3*/ <4.16016,7.36557,2.3493>,<4.17547,7.37767,2.33242>,<4.17645,7.35197,2.33461>,
            
    /*4*/ <4.30685,7.40641,2.46534>,<4.31757,7.4168,2.4484>,<4.32089,7.39476,2.45203>,
            
    /*5*/ <4.43861,7.48938,2.57365>,<4.44649,7.49764,2.55802>,<4.45261,7.48024,2.56389>,
            
    /*6*/ <4.52641,7.60642,2.69143>,<4.53377,7.61362,2.67901>,<4.54071,7.60101,2.6863>,
            
    /*7*/ <4.60273,7.74673,2.79448>,<4.60814,7.75172,2.78388>,<4.61458,7.74304,2.79093>,
            
    /*8*/ <4.66022,7.91916,2.85198>,<4.66351,7.92111,2.84309>,<4.66935,7.91699,2.84962>,
            
    /*9*/ <4.7063,8.09459,2.90782>,<4.70851,8.09595,2.90191>,<4.71248,8.09349,2.90636>,
            
    /*10*/ <4.78303,8.26067,2.96087>,<4.78407,8.26119,2.95786>,<4.78595,8.25964,2.95997>,
            
    /*11*/ <4.88062,8.41607,3.01083>

    /* stem 0.5c1.1.0*/ 
    /*0*/ <3.96424,7.37895,2.13632>,
    /*1*/ <3.96959,7.38369,2.13279>,<3.96627,7.37156,2.13846>,<3.95686,7.38162,2.1377>,
            
    /*2*/ <4.17843,7.62962,2.79818>

    /* stem 0.5c1.1.1*/ 
    /*0*/ <4.09671,7.35597,2.26515>,
    /*1*/ <4.09607,7.34864,2.2667>,<4.09801,7.36089,2.27069>,<4.09605,7.35839,2.25806>,
            
    /*2*/ <4.78015,7.2768,2.17473>

    /* stem 0.5c1.1.2*/ 
    /*0*/ <4.34983,7.42805,2.48444>,
    /*1*/ <4.3458,7.43336,2.48522>,<4.35644,7.42893,2.48371>,<4.34724,7.42186,2.48439>,
            
    /*2*/ <4.42128,7.39354,3.09034>

    /* stem 0.5c1.1.3*/ 
    /*0*/ <4.46978,7.52118,2.59795>,
    /*1*/ <4.47526,7.51989,2.59523>,<4.46942,7.52165,2.60418>,<4.46467,7.52201,2.59445>,
            
    /*2*/ <4.58301,8.07379,2.56297>

    /* stem 0.5c1.1.4*/ 
    /*0*/ <4.58305,7.69954,2.75436>,
    /*1*/ <4.57993,7.69795,2.75876>,<4.58284,7.70486,2.75256>,<4.58638,7.69583,2.75178>,
            
    /*2*/ <4.95869,7.81955,3.0648>

    /* stem 0.5c1.1.5*/ 
    /*0*/ <4.64856,7.87047,2.8317>,
    /*1*/ <4.64778,7.87233,2.82698>,<4.65287,7.87163,2.83423>,<4.64503,7.86746,2.83388>,
            
    /*2*/ <4.44652,8.23599,3.00891>

    /* stem 0.5c1.1.6*/ 
    /*0*/ <4.74987,8.18453,2.93473>,
    /*1*/ <4.75177,8.1832,2.93616>,<4.74841,8.18649,2.93591>,<4.74944,8.18389,2.93213>,
            
    /*2*/ <5.00261,8.43525,2.83217>

    /* stem 0.5c1.1.7*/ 
    /*0*/ <4.85113,8.36842,2.99513>,
    /*1*/ <4.85064,8.3687,2.99521>,<4.85155,8.36868,2.99484>,<4.8512,8.3679,2.99534>,
            
    /*2*/ <4.96636,8.49016,3.26531>

    /* stem 0.5c2*/ 
    /*0*/ <4.02199,7.18973,1.46829>,
    /*1*/ <4.00489,7.19085,1.48382>,<4.01216,7.21059,1.46659>,<4.03301,7.2015,1.4517>,
            <4.03864,7.17614,1.45974>,<4.02126,7.16956,1.47958>,
    /*2*/ <4.36984,7.39027,1.85756>,<4.37423,7.4022,1.84715>,<4.38683,7.3967,1.83816>,
            <4.39023,7.38138,1.84301>,<4.37973,7.37741,1.855>,
    /*3*/ <4.72305,7.60858,2.23166>,<4.7245,7.61265,2.228>,<4.72894,7.61082,2.22501>,
            <4.73024,7.60561,2.22682>,<4.7266,7.60423,2.23093>,
    /*4*/ <4.72667,7.60838,2.22848>

    /* stem 0.5c2.0*/ 
    /*0*/ <4.55238,7.49833,2.03719>,
    /*1*/ <4.54531,7.49873,2.04341>,<4.55765,7.50597,2.03556>,<4.55419,7.4903,2.03261>,
            
    /*2*/ <4.65032,7.45275,2.16435>,<4.66143,7.45927,2.15728>,<4.65831,7.44516,2.15463>,
            
    /*3*/ <4.77417,7.4304,2.2751>,<4.78238,7.43691,2.26731>,<4.78114,7.42397,2.26612>,
            
    /*4*/ <4.90794,7.45814,2.37187>,<4.91292,7.46395,2.36339>,<4.91459,7.45269,2.36435>,
            
    /*5*/ <5.02542,7.5217,2.47079>,<5.02933,7.52645,2.46318>,<5.03236,7.5174,2.46538>,
            
    /*6*/ <5.14553,7.60296,2.55385>,<5.14797,7.60652,2.54692>,<5.15122,7.59939,2.54921>,
            
    /*7*/ <5.24533,7.69526,2.64916>,<5.24765,7.69828,2.64386>,<5.25055,7.69286,2.64607>,
            
    /*8*/ <5.33253,7.8042,2.74007>,<5.33417,7.80633,2.73598>,<5.33668,7.80264,2.73799>,
            
    /*9*/ <5.39674,7.93436,2.82168>,<5.39776,7.93565,2.81885>,<5.39971,7.93363,2.82053>,
            
    /*10*/ <5.45666,8.06988,2.89795>,<5.45715,8.07048,2.89651>,<5.45815,8.06954,2.89739>,
            
    /*11*/ <5.51339,8.20875,2.97051>

    /* stem 0.5c2.0.0*/ 
    /*0*/ <4.62374,7.4669,2.12036>,
    /*1*/ <4.62657,7.46923,2.11881>,<4.62456,7.46312,2.12126>,<4.6201,7.46836,2.121>,
            
    /*2*/ <4.799,7.64505,2.70866>

    /* stem 0.5c2.0.1*/ 
    /*0*/ <4.86943,7.44936,2.33552>,
    /*1*/ <4.86957,7.44593,2.3363>,<4.86924,7.45176,2.3381>,<4.86946,7.4504,2.33215>,
            
    /*2*/ <5.42791,7.47655,2.35033>

    /* stem 0.5c2.0.2*/ 
    /*0*/ <4.98397,7.49741,2.42804>,
    /*1*/ <4.98203,7.50001,2.42867>,<4.98726,7.4978,2.42785>,<4.98264,7.4944,2.42762>,
            
    /*2*/ <5.02599,7.40581,2.94016>

    /* stem 0.5c2.0.3*/ 
    /*0*/ <5.11159,7.57802,2.52431>,
    /*1*/ <5.11366,7.5771,2.52224>,<5.11238,7.57828,2.52726>,<5.10873,7.57868,2.52342>,
            
    /*2*/ <5.23968,8.0334,2.44988>

    /* stem 0.5c2.0.4*/ 
    /*0*/ <5.28351,7.74032,2.6841>,
    /*1*/ <5.28226,7.73946,2.6863>,<5.28416,7.74289,2.68386>,<5.2841,7.7386,2.68215>,
            
    /*2*/ <5.6462,7.66417,2.85974>

    /* stem 0.5c2.0.5*/ 
    /*0*/ <5.35168,7.83963,2.7603>,
    /*1*/ <5.35127,7.84107,2.75834>,<5.35387,7.83967,2.76143>,<5.34989,7.83815,2.76114>,
            
    /*2*/ <5.23028,8.11401,2.98652>

    /* stem 0.5c2.0.6*/ 
    /*0*/ <5.48217,8.13148,2.92974>,
    /*1*/ <5.48256,8.13121,2.92996>,<5.48185,8.13177,2.93003>,<5.4821,8.13147,2.92922>,
            
    /*2*/ <5.65894,8.35803,2.90007>

    /* stem 0.5.0*/ 
    /*0*/ <0.25803,6.15563,0.1024>,
    /*1*/ <0.28233,6.19792,0.05622>,<0.28416,6.09408,0.10862>,<0.2076,6.17491,0.14236>,
            
    /*2*/ <0.52709,6.32379,0.31001>,<0.52874,6.23033,0.35717>,<0.45984,6.30309,0.38753>,
            
    /*3*/ <0.74706,6.4735,0.57353>,<0.75041,6.39237,0.619>,<0.68389,6.45427,0.63911>,
            
    /*4*/ <0.93471,6.6968,0.79307>,<0.94851,6.63572,0.84513>,<0.88259,6.6827,0.85402>,
            
    /*5*/ <1.1111,6.94878,1.00165>,<1.12584,6.9003,1.04966>,<1.06697,6.93749,1.05454>,
            
    /*6*/ <1.28957,7.24054,1.12833>,<1.30883,7.20989,1.17385>,<1.25866,7.23908,1.17758>,
            
    /*7*/ <1.45054,7.55325,1.25514>,<1.46693,7.53059,1.29233>,<1.42529,7.55128,1.29418>,
            
    /*8*/ <1.54954,7.90259,1.32837>,<1.56464,7.89259,1.35821>,<1.53108,7.90219,1.35799>,
            
    /*9*/ <1.56251,8.26575,1.42362>,<1.57274,8.26046,1.44383>,<1.54954,8.26162,1.4425>,
            
    /*10*/ <1.59861,8.6346,1.457>,<1.60384,8.63334,1.46732>,<1.59228,8.63452,1.46676>,
            
    /*11*/ <1.60171,9.00811,1.44741>

    /* stem 0.5.0.0*/ 
    /*0*/ <0.43677,6.24971,0.28258>,
    /*1*/ <0.4409,6.22343,0.2922>,<0.43224,6.27089,0.30077>,<0.43719,6.25481,0.25475>,
            
    /*2*/ <1.84638,6.49518,0.34845>

    /* stem 0.5.0.1*/ 
    /*0*/ <0.54604,6.31412,0.39921>,
    /*1*/ <0.52842,6.33515,0.40178>,<0.57313,6.31894,0.39782>,<0.53657,6.28827,0.39803>,
            
    /*2*/ <0.63412,6.21874,1.78407>

    /* stem 0.5.0.2*/ 
    /*0*/ <0.6519,6.38773,0.52275>,
    /*1*/ <0.67345,6.38064,0.50851>,<0.65021,6.38117,0.54867>,<0.63202,6.40139,0.51108>,
            
    /*2*/ <1.25328,7.54746,0.85546>

    /* stem 0.5.0.3*/ 
    /*0*/ <0.78409,6.5078,0.67494>,
    /*1*/ <0.77038,6.49998,0.69531>,<0.79181,6.53234,0.67325>,<0.7901,6.49109,0.65626>,
            
    /*2*/ <1.87626,6.20712,1.29491>

    /* stem 0.5.0.4*/ 
    /*0*/ <0.99897,6.78216,0.91858>,
    /*1*/ <0.99753,6.79763,0.90038>,<1.0186,6.78154,0.93224>,<0.98076,6.7673,0.92311>,
            
    /*2*/ <0.51905,7.59193,1.64532>

    /* stem 0.5.0.5*/ 
    /*0*/ <1.13732,6.98765,1.05963>,
    /*1*/ <1.15295,6.97418,1.06904>,<1.12763,7.00407,1.07191>,<1.13139,6.9847,1.03794>,
            
    /*2*/ <1.94205,7.69983,0.74261>

    /* stem 0.5.0.6*/ 
    /*0*/ <1.24002,7.1553,1.12905>,
    /*1*/ <1.2211,7.16485,1.13398>,<1.25455,7.1657,1.11663>,<1.24442,7.13534,1.13655>,
            
    /*2*/ <1.68344,7.582,2.00482>

    /* stem 0.5.0.7*/ 
    /*0*/ <1.33599,7.32777,1.1974>,
    /*1*/ <1.34973,7.32669,1.18176>,<1.34267,7.33,1.21702>,<1.31556,7.32661,1.19342>,
            
    /*2*/ <1.29841,8.34207,1.09459>

    /* stem 0.5.0.8*/ 
    /*0*/ <1.47464,7.64003,1.2987>,
    /*1*/ <1.47356,7.63671,1.31764>,<1.46899,7.65699,1.29155>,<1.48136,7.62637,1.2869>,
            
    /*2*/ <2.34071,7.9733,1.40603>

    /* stem 0.5.0.9*/ 
    /*0*/ <1.55332,8.0343,1.38109>,
    /*1*/ <1.54307,8.03798,1.36751>,<1.56637,8.04502,1.3853>,<1.55053,8.0199,1.39046>,
            
    /*2*/ <1.04067,8.46076,1.88367>

    /* stem 0.5.0.10*/ 
    /*0*/ <1.56825,8.33007,1.44156>,
    /*1*/ <1.58009,8.32871,1.44425>,<1.56111,8.33689,1.44874>,<1.56356,8.32462,1.43169>,
            
    /*2*/ <1.73415,8.94498,1.02271>

    /* stem 0.5.0.11*/ 
    /*0*/ <1.59286,8.57957,1.45972>,
    /*1*/ <1.58602,8.57999,1.46324>,<1.59427,8.58391,1.45351>,<1.59829,8.57482,1.46241>,
            
    /*2*/ <1.83695,9.09156,1.87327>

    /* stem 0.5.0.12*/ 
    /*0*/ <1.59991,8.81407,1.45586>,
    /*1*/ <1.60126,8.81392,1.45265>,<1.60138,8.81612,1.45827>,<1.5971,8.81218,1.45666>,
            
    /*2*/ <1.21965,9.30268,1.27317>

    /* stem 0.5.1*/ 
    /*0*/ <0.42625,6.16488,0.19937>,
    /*1*/ <0.42268,6.10029,0.21173>,<0.43582,6.20738,0.24877>,<0.42026,6.18698,0.13763>,
            
    /*2*/ <0.78531,6.07803,0.16504>,<0.79714,6.1744,0.19838>,<0.78313,6.15604,0.09835>,
            
    /*3*/ <1.14375,6.21431,0.08597>,<1.12125,6.29493,0.12233>,<1.10762,6.27957,0.03341>,
            
    /*4*/ <1.44572,6.43875,0.03612>,<1.40743,6.49949,0.07105>,<1.40217,6.48912,-0.00795>,
            
    /*5*/ <1.69804,6.70323,-0.043>,<1.65993,6.7504,-0.01128>,<1.65125,6.7387,-0.07815>,
            
    /*6*/ <1.91334,6.99826,-0.10993>,<1.87693,7.03219,-0.0821>,<1.87093,7.02385,-0.1382>,
            
    /*7*/ <2.03968,7.34924,-0.15345>,<2.00449,7.36547,-0.12937>,<2.00107,7.36112,-0.17466>,
            
    /*8*/ <2.07797,7.71613,-0.20496>,<2.05005,7.72217,-0.18612>,<2.04724,7.7177,-0.21993>,
            
    /*9*/ <2.1023,8.08248,-0.19923>,<2.08341,8.08389,-0.18651>,<2.0819,8.08435,-0.20927>,
            
    /*10*/ <2.12708,8.44656,-0.22969>,<2.11769,8.44791,-0.22335>,<2.11683,8.44702,-0.23469>,
            
    /*11*/ <2.16154,8.81107,-0.22477>

    /* stem 0.5.1.0*/ 
    /*0*/ <0.67374,6.14526,0.16832>,
    /*1*/ <0.67734,6.16934,0.18174>,<0.68871,6.13965,0.14557>,<0.65518,6.12678,0.17766>,
            
    /*2*/ <1.6658,5.55227,0.96707>

    /* stem 0.5.1.1*/ 
    /*0*/ <0.8902,6.17456,0.13171>,
    /*1*/ <0.88798,6.16581,0.10644>,<0.9129,6.17042,0.14539>,<0.86971,6.18744,0.14329>,
            
    /*2*/ <1.3759,7.35154,-0.31832>

    /* stem 0.5.1.2*/ 
    /*0*/ <1.08156,6.24683,0.08989>,
    /*1*/ <1.08972,6.23864,0.1131>,<1.09013,6.26937,0.08034>,<1.06483,6.23248,0.07623>,
            
    /*2*/ <2.07498,5.6288,-0.47761>

    /* stem 0.5.1.3*/ 
    /*0*/ <1.25359,6.35653,0.05968>,
    /*1*/ <1.23911,6.37432,0.04966>,<1.27473,6.34964,0.04817>,<1.24694,6.34564,0.08122>,
            
    /*2*/ <1.88468,7.22895,0.69564>

    /* stem 0.5.1.4*/ 
    /*0*/ <1.51734,6.57613,0.00269>,
    /*1*/ <1.53215,6.55935,-0.00453>,<1.52459,6.59241,0.01804>,<1.49527,6.57665,-0.00545>,
            
    /*2*/ <1.8589,7.25757,-0.88056>

    /* stem 0.5.1.5*/ 
    /*0*/ <1.70082,6.77187,-0.05357>,
    /*1*/ <1.69395,6.78142,-0.03461>,<1.70533,6.78449,-0.07143>,<1.70319,6.7497,-0.05469>,
            
    /*2*/ <2.74634,6.86676,0.27758>

    /* stem 0.5.1.6*/ 
    /*0*/ <1.85759,6.97913,-0.10113>,
    /*1*/ <1.85246,6.97829,-0.12165>,<1.87792,6.97873,-0.09528>,<1.84238,6.98036,-0.08647>,
            
    /*2*/ <1.89267,8.01469,-0.15191>

    /* stem 0.5.1.7*/ 
    /*0*/ <1.95164,7.18985,-0.13147>,
    /*1*/ <1.967,7.1856,-0.11919>,<1.94287,7.20795,-0.13073>,<1.94503,7.176,-0.14449>,
            
    /*2*/ <2.5822,7.52259,-0.8055>

    /* stem 0.5.1.8*/ 
    /*0*/ <2.03428,7.5181,-0.17516>,
    /*1*/ <2.01587,7.52048,-0.17395>,<2.04412,7.52785,-0.18756>,<2.04284,7.50595,-0.16397>,
            
    /*2*/ <2.15872,8.16702,0.43392>

    /* stem 0.5.1.9*/ 
    /*0*/ <2.06667,7.81646,-0.20224>,
    /*1*/ <2.07906,7.81559,-0.21419>,<2.06764,7.8282,-0.18965>,<2.0533,7.80559,-0.20287>,
            
    /*2*/ <1.6515,8.35436,-0.67211>

    /* stem 0.5.1.10*/ 
    /*0*/ <2.09496,8.15043,-0.20402>,
    /*1*/ <2.09378,8.15154,-0.19217>,<2.08919,8.15793,-0.21133>,<2.10191,8.14182,-0.20855>,
            
    /*2*/ <2.67882,8.61394,-0.18919>

    /* stem 0.5.1.11*/ 
    /*0*/ <2.11584,8.39275,-0.22462>,
    /*1*/ <2.11159,8.39258,-0.23088>,<2.12217,8.39691,-0.22445>,<2.11377,8.38875,-0.21853>,
            
    /*2*/ <1.75575,8.93066,0.00561>

    /* stem 0.5.1.12*/ 
    /*0*/ <2.1388,8.60927,-0.22725>,
    /*1*/ <2.14229,8.60886,-0.22624>,<2.1368,8.61198,-0.22586>,<2.13732,8.60696,-0.22966>,
            
    /*2*/ <2.32145,8.98853,-0.70231>

    /* stem 0.5.2*/ 
    /*0*/ <0.63451,6.1946,0.29878>,
    /*1*/ <0.61421,6.25051,0.32318>,<0.68588,6.19315,0.26015>,<0.60343,6.14015,0.313>,
            
    /*2*/ <0.82781,6.19814,0.6039>,<0.89231,6.14652,0.54718>,<0.81811,6.09882,0.59474>,
            
    /*3*/ <1.06135,6.227,0.85973>,<1.12145,6.18215,0.81165>,<1.06668,6.13834,0.86658>,
            
    /*4*/ <1.25618,6.39209,1.08113>,<1.31983,6.35807,1.0517>,<1.28114,6.32426,1.11031>,
            
    /*5*/ <1.43903,6.60987,1.28536>,<1.4965,6.58377,1.26347>,<1.4666,6.55817,1.31745>,
            
    /*6*/ <1.57815,6.85652,1.4927>,<1.62959,6.83984,1.47945>,<1.60355,6.81759,1.52334>,
            
    /*7*/ <1.70404,7.12526,1.68614>,<1.74591,7.11336,1.67669>,<1.72567,7.09686,1.71277>,
            
    /*8*/ <1.82863,7.3821,1.90105>,<1.86012,7.37329,1.89419>,<1.84414,7.35941,1.92003>,
            
    /*9*/ <1.91039,7.67424,2.08212>,<1.93212,7.67045,2.07908>,<1.92178,7.66222,2.09701>,
            
    /*10*/ <1.96953,8.00531,2.19439>,<1.98051,8.00397,2.1931>,<1.9757,8.00152,2.20284>,
            
    /*11*/ <2.06331,8.33951,2.27765>

    /* stem 0.5.2.0*/ 
    /*0*/ <0.75504,6.16795,0.4601>,
    /*1*/ <0.77465,6.15811,0.44382>,<0.74669,6.15348,0.4817>,<0.74379,6.19227,0.45477>,
            
    /*2*/ <1.71042,6.78108,1.24031>

    /* stem 0.5.2.1*/ 
    /*0*/ <0.87976,6.15275,0.61946>,
    /*1*/ <0.86181,6.14392,0.63674>,<0.89636,6.17214,0.62638>,<0.88113,6.1422,0.59526>,
            
    /*2*/ <1.74904,5.25071,1.06166>

    /* stem 0.5.2.2*/ 
    /*0*/ <1.03752,6.17582,0.79515>,
    /*1*/ <1.04566,6.19764,0.78497>,<1.05397,6.16027,0.8067>,<1.01292,6.16956,0.79377>,
            
    /*2*/ <0.82425,6.77014,1.89884>

    /* stem 0.5.2.3*/ 
    /*0*/ <1.17376,6.26106,0.95113>,
    /*1*/ <1.18468,6.24012,0.95737>,<1.1654,6.27612,0.96846>,<1.1712,6.26695,0.92756>,
            
    /*2*/ <2.24939,6.82938,0.97635>

    /* stem 0.5.2.4*/ 
    /*0*/ <1.41846,6.52314,1.23283>,
    /*1*/ <1.39953,6.53437,1.23717>,<1.43645,6.53406,1.22506>,<1.4194,6.50099,1.23626>,
            
    /*2*/ <1.76057,6.69836,2.27092>

    /* stem 0.5.2.5*/ 
    /*0*/ <1.50889,6.66127,1.35261>,
    /*1*/ <1.5262,6.66252,1.33984>,<1.51134,6.65922,1.3739>,<1.48914,6.66208,1.34407>,
            
    /*2*/ <1.50795,7.71427,1.45406>

    /* stem 0.5.2.6*/ 
    /*0*/ <1.57217,6.77912,1.4499>,
    /*1*/ <1.56546,6.76885,1.46671>,<1.57128,6.79991,1.44937>,<1.57976,6.76862,1.43363>,
            
    /*2*/ <2.50574,6.82935,1.85313>

    /* stem 0.5.2.7*/ 
    /*0*/ <1.65404,6.95135,1.57855>,
    /*1*/ <1.64734,6.96398,1.56487>,<1.67101,6.9551,1.58802>,<1.64377,6.93497,1.58276>,
            
    /*2*/ <1.16853,7.43026,2.25836>

    /* stem 0.5.2.8*/ 
    /*0*/ <1.77562,7.22179,1.78213>,
    /*1*/ <1.79039,7.21189,1.78594>,<1.76702,7.23078,1.7954>,<1.76945,7.22271,1.76505>,
            
    /*2*/ <2.28261,7.92186,1.63646>

    /* stem 0.5.2.9*/ 
    /*0*/ <1.88708,7.53652,2.00546>,
    /*1*/ <1.87204,7.53772,2.0099>,<1.89496,7.54932,2.00084>,<1.89423,7.52253,2.00565>,
            
    /*2*/ <2.11398,7.66226,2.74079>

    /* stem 0.5.2.10*/ 
    /*0*/ <1.9311,7.72905,2.10595>,
    /*1*/ <1.93788,7.73105,2.09662>,<1.93448,7.73272,2.11653>,<1.92093,7.72339,2.10469>,
            
    /*2*/ <1.59231,8.36178,1.99484>

    /* stem 0.5.2.11*/ 
    /*0*/ <1.95635,7.88611,2.15791>,
    /*1*/ <1.95697,7.8833,2.1661>,<1.95161,7.89315,2.15607>,<1.96049,7.88188,2.15154>,
            
    /*2*/ <2.50807,8.28283,2.25259>

    /* stem 0.5.2.12*/ 
    /*0*/ <2.03172,8.21902,2.24864>,
    /*1*/ <2.03014,8.21979,2.24715>,<2.03376,8.22008,2.24881>,<2.03127,8.21718,2.24996>,
            
    /*2*/ <1.80858,8.58054,2.674>

    /* stem 0.5.3*/ 
    /*0*/ <0.90494,6.2396,0.42063>,
    /*1*/ <0.93186,6.21695,0.36926>,<0.92055,6.217,0.4765>,<0.86242,6.28485,0.41612>,
            
    /*2*/ <1.17788,6.45554,0.40048>,<1.16771,6.45559,0.497>,<1.11538,6.51666,0.44266>,
            
    /*3*/ <1.37584,6.74101,0.48194>,<1.35722,6.73146,0.56563>,<1.30681,6.78037,0.51553>,
            
    /*4*/ <1.58332,7.00335,0.54465>,<1.56968,6.99793,0.61869>,<1.52657,7.04239,0.57553>,
            
    /*5*/ <1.78207,7.27829,0.60884>,<1.77014,7.27338,0.67224>,<1.73188,7.30976,0.63484>,
            
    /*6*/ <1.95234,7.57398,0.6634>,<1.94289,7.57063,0.71638>,<1.9081,7.59656,0.68437>,
            
    /*7*/ <2.10841,7.8763,0.7225>,<2.10042,7.87293,0.76475>,<2.07203,7.89263,0.73894>,
            
    /*8*/ <2.20363,8.20712,0.74848>,<2.19848,8.20662,0.78042>,<2.17458,8.21507,0.76031>,
            
    /*9*/ <2.357,8.51167,0.7755>,<2.35378,8.51177,0.79683>,<2.33903,8.52036,0.78366>,
            
    /*10*/ <2.4597,8.84065,0.7766>,<2.45832,8.84122,0.78728>,<2.45021,8.84377,0.78065>,
            
    /*11*/ <2.53324,9.17604,0.80933>

    /* stem 0.5.3.0*/ 
    /*0*/ <1.03877,6.36677,0.43466>,
    /*1*/ <1.03918,6.36344,0.46095>,<1.03909,6.39119,0.4244>,<1.03805,6.34567,0.41865>,
            
    /*2*/ <2.37016,6.33935,0.41055>

    /* stem 0.5.3.1*/ 
    /*0*/ <1.20452,6.54842,0.4663>,
    /*1*/ <1.19248,6.56173,0.4483>,<1.22924,6.55244,0.47069>,<1.19184,6.53109,0.47992>,
            
    /*2*/ <0.90742,7.43957,1.32393>

    /* stem 0.5.3.2*/ 
    /*0*/ <1.42372,6.84626,0.54222>,
    /*1*/ <1.44188,6.83106,0.54445>,<1.42182,6.86478,0.55701>,<1.40745,6.84292,0.52519>,
            
    /*2*/ <2.06543,7.50454,-0.19964>

    /* stem 0.5.3.3*/ 
    /*0*/ <1.51816,6.96302,0.56817>,
    /*1*/ <1.50195,6.97326,0.58108>,<1.53022,6.97538,0.55279>,<1.52232,6.9404,0.57063>,
            
    /*2*/ <2.30247,7.19433,1.36928>

    /* stem 0.5.3.4*/ 
    /*0*/ <1.61727,7.09223,0.59644>,
    /*1*/ <1.62441,7.09155,0.57522>,<1.63194,7.09523,0.6131>,<1.59547,7.08991,0.601>,
            
    /*2*/ <1.48409,8.18631,0.5165>

    /* stem 0.5.3.5*/ 
    /*0*/ <1.85186,7.44046,0.66447>,
    /*1*/ <1.85743,7.43403,0.68315>,<1.84285,7.45877,0.66219>,<1.85529,7.42859,0.64808>,
            
    /*2*/ <2.751,7.86775,0.54348>

    /* stem 0.5.3.6*/ 
    /*0*/ <1.99987,7.70379,0.71025>,
    /*1*/ <1.98546,7.71299,0.70157>,<2.01784,7.71018,0.70836>,<1.9963,7.6882,0.72082>,
            
    /*2*/ <1.88865,8.23913,1.46191>

    /* stem 0.5.3.7*/ 
    /*0*/ <2.13957,8.03391,0.75185>,
    /*1*/ <2.1561,8.02918,0.74837>,<2.13621,8.04501,0.76502>,<2.12639,8.02755,0.74217>,
            
    /*2*/ <2.21431,8.68495,0.22256>

    /* stem 0.5.3.8*/ 
    /*0*/ <2.22111,8.26545,0.76714>,
    /*1*/ <2.21179,8.26932,0.78011>,<2.2216,8.27543,0.7541>,<2.22993,8.25159,0.76722>,
            
    /*2*/ <2.82389,8.65122,1.08519>

    /* stem 0.5.3.9*/ 
    /*0*/ <2.30021,8.41843,0.77831>,
    /*1*/ <2.30013,8.41952,0.76394>,<2.31258,8.41985,0.78558>,<2.28792,8.41593,0.78542>,
            
    /*2*/ <2.18371,9.14882,0.83425>

    /* stem 0.5.3.10*/ 
    /*0*/ <2.40353,8.67984,0.7834>,
    /*1*/ <2.40948,8.67799,0.79031>,<2.39866,8.68777,0.78345>,<2.40244,8.67376,0.77644>,
            
    /*2*/ <2.89691,8.98473,0.44005>

    /* stem 0.5.3.11*/ 
    /*0*/ <2.49904,9.02793,0.797>,
    /*1*/ <2.49639,9.02857,0.79661>,<2.50102,9.02937,0.79572>,<2.49972,9.02584,0.79867>,
            
    /*2*/ <2.52196,9.39922,1.25125>

    /* stem 0.5.4*/ 
    /*0*/ <1.2136,6.31201,0.53032>,
    /*1*/ <1.1997,6.29484,0.58608>,<1.23345,6.36769,0.52015>,<1.20766,6.2735,0.48472>,
            
    /*2*/ <1.51157,6.19426,0.62643>,<1.54195,6.25982,0.5671>,<1.51873,6.17505,0.53521>,
            
    /*3*/ <1.83294,6.14381,0.6837>,<1.85335,6.20331,0.62937>,<1.84545,6.12463,0.60381>,
            
    /*4*/ <2.16162,6.24315,0.68815>,<2.14723,6.29413,0.63832>,<2.16841,6.22778,0.6174>,
            
    /*5*/ <2.4641,6.3862,0.65319>,<2.44112,6.42649,0.61155>,<2.46484,6.3721,0.59248>,
            
    /*6*/ <2.72474,6.58862,0.59666>,<2.69646,6.61696,0.56356>,<2.72416,6.57662,0.54613>,
            
    /*7*/ <2.95564,6.8207,0.5872>,<2.93304,6.84305,0.56044>,<2.9604,6.81516,0.5463>,
            
    /*8*/ <3.17578,7.06612,0.53879>,<3.15624,7.0804,0.51915>,<3.17691,7.05975,0.5083>,
            
    /*9*/ <3.36739,7.33119,0.48825>,<3.35325,7.33937,0.47541>,<3.36824,7.3271,0.4679>,
            
    /*10*/ <3.51593,7.60873,0.38057>,<3.50768,7.61105,0.37469>,<3.51544,7.60537,0.37075>,
            
    /*11*/ <3.63142,7.91327,0.33065>

    /* stem 0.5.4.0*/ 
    /*0*/ <1.39852,6.25108,0.55767>,
    /*1*/ <1.4071,6.27149,0.54513>,<1.41029,6.22867,0.55507>,<1.37817,6.25308,0.57282>,
            
    /*2*/ <2.15735,6.53564,1.53972>

    /* stem 0.5.4.1*/ 
    /*0*/ <1.686,6.18315,0.608>,
    /*1*/ <1.68279,6.15946,0.60459>,<1.69719,6.19108,0.62787>,<1.67804,6.19891,0.59153>,
            
    /*2*/ <2.74168,6.12168,0.03841>

    /* stem 0.5.4.2*/ 
    /*0*/ <1.95409,6.19143,0.6421>,
    /*1*/ <1.949,6.20631,0.6588>,<1.96792,6.19775,0.62494>,<1.94536,6.17023,0.64258>,
            
    /*2*/ <2.85296,5.83429,1.23466>

    /* stem 0.5.4.3*/ 
    /*0*/ <2.09976,6.23662,0.64626>,
    /*1*/ <2.10071,6.23558,0.62404>,<2.11693,6.22946,0.65849>,<2.08163,6.24481,0.65626>,
            
    /*2*/ <2.53886,7.24226,0.61834>

    /* stem 0.5.4.4*/ 
    /*0*/ <2.24456,6.2952,0.63966>,
    /*1*/ <2.25155,6.28385,0.65662>,<2.25151,6.3154,0.6366>,<2.23063,6.28637,0.62576>,
            
    /*2*/ <3.05379,5.92898,0.06117>

    /* stem 0.5.4.5*/ 
    /*0*/ <2.58999,6.49765,0.59313>,
    /*1*/ <2.57768,6.51275,0.58969>,<2.60415,6.49324,0.58004>,<2.58814,6.48695,0.60967>,
            
    /*2*/ <3.19477,7.09392,1.04639>

    /* stem 0.5.4.6*/ 
    /*0*/ <2.82419,6.70205,0.56686>,
    /*1*/ <2.83532,6.69064,0.55769>,<2.83068,6.71182,0.58102>,<2.80657,6.70369,0.56186>,
            
    /*2*/ <3.04256,7.36015,0.01294>

    /* stem 0.5.4.7*/ 
    /*0*/ <3.06458,6.95294,0.54241>,
    /*1*/ <3.06181,6.95822,0.55814>,<3.06645,6.96413,0.52999>,<3.06549,6.93647,0.5391>,
            
    /*2*/ <3.85684,6.96959,0.67656>

    /* stem 0.5.4.8*/ 
    /*0*/ <3.22655,7.1464,0.50887>,
    /*1*/ <3.22076,7.14818,0.49442>,<3.24179,7.14879,0.51155>,<3.21708,7.14223,0.52063>,
            
    /*2*/ <3.08911,7.86194,0.652>

    /* stem 0.5.4.9*/ 
    /*0*/ <3.31307,7.26447,0.48878>,
    /*1*/ <3.32318,7.25815,0.4952>,<3.30896,7.27667,0.49297>,<3.30706,7.25858,0.47816>,
            
    /*2*/ <3.77989,7.57045,0.05471>

    /* stem 0.5.4.10*/ 
    /*0*/ <3.43673,7.46814,0.42712>,
    /*1*/ <3.42931,7.47292,0.42913>,<3.44095,7.46945,0.41922>,<3.43992,7.46206,0.433>,
            
    /*2*/ <3.80543,7.92541,0.7>

    /* stem 0.5.4.11*/ 
    /*0*/ <3.55387,7.71357,0.35992>,
    /*1*/ <3.55581,7.71235,0.35673>,<3.55559,7.71606,0.36243>,<3.55021,7.71231,0.3606>,
            
    /*2*/ <3.34318,8.16325,0.06011>

    /* stem 0.5.5*/ 
    /*0*/ <1.74089,6.44146,0.70741>,
    /*1*/ <1.74105,6.48754,0.67545>,<1.78249,6.40411,0.70297>,<1.69912,6.43272,0.7438>,
            
    /*2*/ <1.89827,6.63239,0.89498>,<1.93557,6.5573,0.91975>,<1.86053,6.58305,0.9565>,
            
    /*3*/ <2.00887,6.8478,1.05648>,<2.05363,6.79703,1.09466>,<1.9826,6.81389,1.12128>,
            
    /*4*/ <2.07162,7.10186,1.20268>,<2.11479,7.06883,1.24353>,<2.04938,7.07499,1.26106>,
            
    /*5*/ <2.15374,7.37167,1.30908>,<2.19181,7.34673,1.34548>,<2.13704,7.35654,1.36283>,
            
    /*6*/ <2.18012,7.66042,1.39396>,<2.21349,7.64837,1.42713>,<2.16645,7.64918,1.43919>,
            
    /*7*/ <2.24045,7.94989,1.47603>,<2.2668,7.93772,1.50186>,<2.22976,7.9424,1.51262>,
            
    /*8*/ <2.2756,8.2439,1.5508>,<2.2957,8.23691,1.57072>,<2.26759,8.23835,1.57827>,
            
    /*9*/ <2.30716,8.53701,1.63624>,<2.32052,8.53204,1.64944>,<2.30173,8.53263,1.65437>,
            
    /*10*/ <2.34076,8.83862,1.65541>,<2.3476,8.83758,1.66223>,<2.33828,8.83845,1.6648>,
            
    /*11*/ <2.33108,9.1391,1.71743>

    /* stem 0.5.5.0*/ 
    /*0*/ <1.82436,6.5208,0.82226>,
    /*1*/ <1.83748,6.50125,0.82623>,<1.81288,6.53135,0.84034>,<1.82272,6.5298,0.8002>,
            
    /*2*/ <2.77471,7.20042,1.02864>

    /* stem 0.5.5.1*/ 
    /*0*/ <1.94514,6.68288,0.99094>,
    /*1*/ <1.92415,6.69022,0.99559>,<1.96121,6.69766,0.98464>,<1.95007,6.66077,0.99259>,
            
    /*2*/ <2.23362,6.8274,2.06594>

    /* stem 0.5.5.2*/ 
    /*0*/ <2.0422,6.9317,1.15277>,
    /*1*/ <2.05808,6.93545,1.13902>,<2.04448,6.93683,1.17335>,<2.02404,6.92281,1.14593>,
            
    /*2*/ <1.64972,7.88278,0.95889>

    /* stem 0.5.5.3*/ 
    /*0*/ <2.12784,7.24736,1.29764>,
    /*1*/ <2.12542,7.24112,1.31622>,<2.121,7.26507,1.29219>,<2.1371,7.23588,1.2845>,
            
    /*2*/ <2.96745,7.64643,1.54068>

    /* stem 0.5.5.4*/ 
    /*0*/ <2.1659,7.41579,1.35494>,
    /*1*/ <2.15546,7.42083,1.33996>,<2.1816,7.42548,1.35923>,<2.16064,7.40107,1.36563>,
            
    /*2*/ <1.67387,7.97782,1.88685>

    /* stem 0.5.5.5*/ 
    /*0*/ <2.17825,7.55655,1.39366>,
    /*1*/ <2.19573,7.55375,1.39824>,<2.16773,7.5674,1.40394>,<2.1713,7.54849,1.37879>,
            
    /*2*/ <2.4175,8.25092,0.90554>

    /* stem 0.5.5.6*/ 
    /*0*/ <2.21559,7.7951,1.4577>,
    /*1*/ <2.20017,7.79626,1.46514>,<2.22084,7.80735,1.44689>,<2.22575,7.78169,1.46106>,
            
    /*2*/ <2.54997,8.20595,2.08599>

    /* stem 0.5.5.7*/ 
    /*0*/ <2.25787,8.0498,1.52189>,
    /*1*/ <2.26484,8.05232,1.50777>,<2.26282,8.05781,1.53477>,<2.24596,8.03926,1.52314>,
            
    /*2*/ <1.75678,8.59855,1.37299>

    /* stem 0.5.5.8*/ 
    /*0*/ <2.29573,8.39672,1.60934>,
    /*1*/ <2.29899,8.39287,1.62222>,<2.28769,8.40777,1.60724>,<2.30052,8.3895,1.59855>,
            
    /*2*/ <2.8402,8.78926,1.58867>

    /* stem 0.5.5.9*/ 
    /*0*/ <2.32397,8.66692,1.65286>,
    /*1*/ <2.31682,8.66792,1.64789>,<2.33108,8.67183,1.65135>,<2.32402,8.66103,1.65934>,
            
    /*2*/ <2.11572,9.08654,2.03588>

    /* stem 0.5.5.10*/ 
    /*0*/ <2.33465,9.04258,1.69927>,
    /*1*/ <2.33645,9.04267,1.69913>,<2.3338,9.04345,1.70059>,<2.33371,9.04161,1.69808>,
            
    /*2*/ <2.29096,9.45691,1.39862>

    /* stem 0.5.6*/ 
    /*0*/ <2.24232,6.56971,0.88261>,
    /*1*/ <2.25701,6.51953,0.8806>,<2.24298,6.59536,0.92821>,<2.22698,6.59424,0.83901>,
            
    /*2*/ <2.52314,6.60483,0.83179>,<2.51052,6.67308,0.87463>,<2.49611,6.67207,0.79436>,
            
    /*3*/ <2.771,6.76524,0.80589>,<2.74184,6.81812,0.84602>,<2.73392,6.81874,0.77395>,
            
    /*4*/ <2.97247,6.97893,0.8012>,<2.93518,7.0159,0.8368>,<2.93115,7.01832,0.77353>,
            
    /*5*/ <3.11127,7.23713,0.79703>,<3.07223,7.25936,0.82766>,<3.06825,7.26059,0.77345>,
            
    /*6*/ <3.23287,7.49293,0.83222>,<3.19784,7.50693,0.85733>,<3.19752,7.51325,0.81246>,
            
    /*7*/ <3.37391,7.73517,0.85781>,<3.34744,7.74907,0.87832>,<3.34664,7.75336,0.84233>,
            
    /*8*/ <3.52375,7.97441,0.84135>,<3.50561,7.98734,0.85693>,<3.50273,7.98731,0.8299>,
            
    /*9*/ <3.67816,8.21076,0.86835>,<3.6653,8.21834,0.87863>,<3.66501,8.22058,0.86064>,
            
    /*10*/ <3.84445,8.43927,0.85257>,<3.83873,8.44397,0.8578>,<3.83775,8.44406,0.84879>,
            
    /*11*/ <4.01969,8.66203,0.84564>

    /* stem 0.5.6.0*/ 
    /*0*/ <2.42572,6.62473,0.84901>,
    /*1*/ <2.42348,6.64113,0.86364>,<2.43529,6.62858,0.82948>,<2.41839,6.60448,0.85392>,
            
    /*2*/ <3.39545,6.37708,1.27552>

    /* stem 0.5.6.1*/ 
    /*0*/ <2.66005,6.74466,0.8179>,
    /*1*/ <2.65972,6.74176,0.7972>,<2.67798,6.74261,0.82846>,<2.64245,6.74961,0.82805>,
            
    /*2*/ <2.85746,7.73904,0.67538>

    /* stem 0.5.6.2*/ 
    /*0*/ <2.8687,6.92433,0.80572>,
    /*1*/ <2.87683,6.91684,0.82201>,<2.86559,6.94371,0.80429>,<2.86369,6.91244,0.79086>,
            
    /*2*/ <3.73886,7.03584,0.42298>

    /* stem 0.5.6.3*/ 
    /*0*/ <3.01035,7.11983,0.80176>,
    /*1*/ <2.99466,7.12845,0.79673>,<3.02667,7.12542,0.79481>,<3.00972,7.10562,0.81375>,
            
    /*2*/ <3.10574,7.69352,1.48689>

    /* stem 0.5.6.4*/ 
    /*0*/ <3.15926,7.40365,0.82016>,
    /*1*/ <3.17367,7.39742,0.81326>,<3.16,7.41328,0.83434>,<3.1441,7.40026,0.81289>,
            
    /*2*/ <3.22968,8.07909,0.35803>

    /* stem 0.5.6.5*/ 
    /*0*/ <3.30621,7.66384,0.85083>,
    /*1*/ <3.29976,7.66626,0.86504>,<3.30881,7.67605,0.84116>,<3.31006,7.64921,0.84629>,
            
    /*2*/ <3.98921,7.75213,1.14597>

    /* stem 0.5.6.6*/ 
    /*0*/ <3.44343,7.87991,0.85001>,
    /*1*/ <3.4398,7.88128,0.83592>,<3.45691,7.88342,0.85446>,<3.4336,7.87502,0.85965>,
            
    /*2*/ <3.23669,8.52537,0.9663>

    /* stem 0.5.6.7*/ 
    /*0*/ <3.6056,8.1226,0.85855>,
    /*1*/ <3.61371,8.11627,0.86578>,<3.60141,8.13387,0.8622>,<3.60169,8.11765,0.84768>,
            
    /*2*/ <4.07739,8.39269,0.56593>

    /* stem 0.5.6.8*/ 
    /*0*/ <3.7478,8.3201,0.8618>,
    /*1*/ <3.74142,8.32498,0.86255>,<3.75348,8.32171,0.85631>,<3.74849,8.31362,0.86655>,
            
    /*2*/ <4.02542,8.62575,1.23829>

    /* stem 0.5.6.9*/ 
    /*0*/ <3.90621,8.52311,0.85033>,
    /*1*/ <3.90797,8.52158,0.84798>,<3.90774,8.52481,0.85272>,<3.9029,8.52293,0.85029>,
            
    /*2*/ <3.8872,8.93295,0.57001>

    /* stem 0.5.7*/ 
    /*0*/ <3.27941,6.92329,1.26529>,
    /*1*/ <3.26517,6.94747,1.28858>,<3.30322,6.93425,1.23992>,<3.26984,6.88816,1.26735>,
            
    /*2*/ <3.44399,6.90553,1.4357>,<3.47823,6.89363,1.39191>,<3.4482,6.85215,1.41659>,
            
    /*3*/ <3.6221,6.94723,1.57244>,<3.65422,6.93694,1.53481>,<3.63888,6.90003,1.56574>,
            
    /*4*/ <3.78845,7.04921,1.69488>,<3.81787,7.04088,1.66293>,<3.81172,7.01161,1.6955>,
            
    /*5*/ <3.95329,7.17139,1.80794>,<3.97827,7.16418,1.78036>,<3.9754,7.14067,1.80995>,
            
    /*6*/ <4.06425,7.33841,1.91919>,<4.08866,7.33595,1.8993>,<4.08803,7.31867,1.92573>,
            
    /*7*/ <4.13549,7.54317,2.00146>,<4.15568,7.54262,1.98629>,<4.15706,7.53276,2.00952>,
            
    /*8*/ <4.19858,7.75705,2.0749>,<4.21376,7.75675,2.06356>,<4.21507,7.75026,2.08132>,
            
    /*9*/ <4.29006,7.97076,2.11999>,<4.29949,7.96861,2.11187>,<4.3008,7.96549,2.12404>,
            
    /*10*/ <4.38242,8.18619,2.14241>,<4.38698,8.18475,2.13829>,<4.38787,8.18373,2.14446>,
            
    /*11*/ <4.45772,8.40865,2.15269>

    /* stem 0.5.7.0*/ 
    /*0*/ <3.34444,6.90881,1.32007>,
    /*1*/ <3.35445,6.9082,1.30803>,<3.34384,6.89701,1.33037>,<3.33502,6.92121,1.32181>,
            
    /*2*/ <3.98638,7.32412,1.83266>

    /* stem 0.5.7.1*/ 
    /*0*/ <3.53681,6.90329,1.4777>,
    /*1*/ <3.53098,6.89437,1.48788>,<3.54394,6.91551,1.48183>,<3.53551,6.89999,1.4634>,
            
    /*2*/ <4.27356,6.46134,1.51282>

    /* stem 0.5.7.2*/ 
    /*0*/ <3.70884,6.97254,1.61094>,
    /*1*/ <3.70574,6.98466,1.60492>,<3.72211,6.96896,1.61289>,<3.69867,6.96401,1.615>,
            
    /*2*/ <3.69881,7.32822,2.33251>

    /* stem 0.5.7.3*/ 
    /*0*/ <3.85622,7.07236,1.71986>,
    /*1*/ <3.86471,7.06247,1.71856>,<3.85597,7.07938,1.73092>,<3.84798,7.07524,1.71009>,
            
    /*2*/ <4.36554,7.54755,1.43021>

    /* stem 0.5.7.4*/ 
    /*0*/ <4.01696,7.23299,1.84912>,
    /*1*/ <4.00686,7.23533,1.85536>,<4.02249,7.24184,1.84299>,<4.02154,7.22178,1.84901>,
            
    /*2*/ <4.39642,7.38248,2.40689>

    /* stem 0.5.7.5*/ 
    /*0*/ <4.17188,7.62048,2.027>,
    /*1*/ <4.17626,7.62243,2.01782>,<4.17692,7.62282,2.03574>,<4.16247,7.61619,2.02744>,
            
    /*2*/ <3.93084,8.14925,2.02437>

    /* stem 0.5.7.6*/ 
    /*0*/ <4.26652,7.89454,2.10297>,
    /*1*/ <4.26877,7.89195,2.1108>,<4.26347,7.90244,2.10178>,<4.26733,7.88922,2.09631>,
            
    /*2*/ <4.73943,8.06514,2.02385>

    /* stem 0.5.7.7*/ 
    /*0*/ <4.35068,8.09949,2.13262>,
    /*1*/ <4.34666,8.10141,2.13016>,<4.35538,8.10083,2.13121>,<4.35,8.09625,2.13647>,
            
    /*2*/ <4.33883,8.44857,2.42455>

    /* stem 0.5.7.8*/ 
    /*0*/ <4.4371,8.34452,2.14954>,
    /*1*/ <4.43808,8.34422,2.14935>,<4.43691,8.34522,2.1503>,<4.43631,8.34414,2.14898>,
            
    /*2*/ <4.47769,8.63842,1.89232>

    /* stem 0.6*/ 
    /*0*/ <-0.02057,6.4104,-0.06326>,
    /*1*/ <-0.03778,6.40659,-0.16095>,<-0.02589,6.50356,-0.09713>,<-0.00665,6.47179,0.01349>,
            <-0.00665,6.35519,0.01804>,<-0.02588,6.31489,-0.08977>,
    /*2*/ <-0.60518,6.41083,-0.05158>,<-0.59443,6.49858,0.00617>,<-0.57702,6.46983,0.10629>,
            <-0.57701,6.36431,0.11041>,<-0.59442,6.32784,0.01284>,
    /*3*/ <-1.16616,6.36484,0.11067>,<-1.15844,6.44323,0.16292>,<-1.13254,6.41775,0.25018>,
            <-1.12425,6.3236,0.25186>,<-1.14503,6.29091,0.16564>,
    /*4*/ <-1.70394,6.33447,0.34843>,<-1.68939,6.40409,0.39204>,<-1.65688,6.38209,0.46566>,
            <-1.65133,6.29886,0.46755>,<-1.68041,6.26943,0.3951>,
    /*5*/ <-2.23614,6.30932,0.56705>,<-2.22412,6.36968,0.60508>,<-2.19787,6.35053,0.66972>,
            <-2.19367,6.27833,0.67165>,<-2.21732,6.25286,0.60819>,
    /*6*/ <-2.78249,6.33436,0.73696>,<-2.77092,6.38552,0.76861>,<-2.75494,6.36939,0.82551>,
            <-2.75663,6.30825,0.82903>,<-2.77366,6.2866,0.7743>,
    /*7*/ <-3.33816,6.38294,0.87715>,<-3.32847,6.42486,0.90297>,<-3.31845,6.41189,0.9504>,
            <-3.32193,6.36195,0.95388>,<-3.33411,6.34406,0.90861>,
    /*8*/ <-3.90212,6.41761,0.98595>,<-3.89653,6.45043,1.00644>,<-3.89055,6.4405,1.04377>,
            <-3.89245,6.40154,1.04636>,<-3.8996,6.38739,1.01063>,
    /*9*/ <-4.47088,6.39894,1.08014>,<-4.46943,6.4225,1.09522>,<-4.46521,6.4154,1.12198>,
            <-4.46405,6.38745,1.12344>,<-4.46756,6.37728,1.09758>,
    /*10*/ <-5.04119,6.41121,1.17239>,<-5.03959,6.42544,1.18139>,<-5.03733,6.42115,1.1976>,
            <-5.03753,6.40426,1.19862>,<-5.03992,6.39812,1.18303>,
    /*11*/ <-5.60927,6.3549,1.26091>,<-5.60931,6.35979,1.2641>,<-5.60839,6.35832,1.26967>,
            <-5.60778,6.35252,1.26992>,<-5.60832,6.35041,1.26451>,
    /*12*/ <-5.60861,6.35519,1.26582>

    /* stem 0.6c0*/ 
    /*0*/ <-1.67639,6.33779,0.41376>,
    /*1*/ <-1.72385,6.33455,0.36108>,<-1.69684,6.40403,0.39857>,<-1.64157,6.38196,0.45704>,
            <-1.63442,6.29884,0.4557>,<-1.68527,6.26954,0.39639>,
    /*2*/ <-2.14427,6.29202,0.75525>,<-2.12085,6.35227,0.78775>,<-2.07292,6.33313,0.83845>,
            <-2.06672,6.26105,0.83729>,<-2.11082,6.23565,0.78587>,
    /*3*/ <-2.59478,6.27013,1.10786>,<-2.57591,6.32113,1.13608>,<-2.53978,6.30468,1.18274>,
            <-2.53632,6.24352,1.18336>,<-2.57032,6.22216,1.13708>,
    /*4*/ <-3.03885,6.34206,1.47311>,<-3.01748,6.3835,1.49166>,<-2.98872,6.37004,1.53052>,
            <-2.99231,6.32029,1.53597>,<-3.02328,6.303,1.50049>,
    /*5*/ <-3.50354,6.42763,1.80034>,<-3.48754,6.46005,1.81523>,<-3.46755,6.45003,1.8473>,
            <-3.47119,6.41142,1.85223>,<-3.49343,6.39758,1.82321>,
    /*6*/ <-3.9728,6.55089,2.11287>,<-3.96041,6.57391,2.1229>,<-3.94704,6.56695,2.14651>,
            <-3.95118,6.53963,2.15107>,<-3.9671,6.5297,2.13027>,
    /*7*/ <-4.41583,6.6681,2.46824>,<-4.40782,6.68186,2.47395>,<-4.39858,6.67733,2.48739>,
            <-4.40088,6.66077,2.48997>,<-4.41155,6.65506,2.47814>,
    /*8*/ <-4.87995,6.82804,2.77057>,<-4.87714,6.83278,2.7725>,<-4.87447,6.83138,2.7775>,
            <-4.87564,6.82579,2.77866>,<-4.87903,6.82372,2.77438>,
    /*9*/ <-4.87725,6.82834,2.77472>

    /* stem 0.6c0c0*/ 
    /*0*/ <-3.95971,6.55222,2.13272>,
    /*1*/ <-3.98347,6.55152,2.13118>,<-3.96735,6.574,2.12683>,<-3.94066,6.56638,2.13062>,
            <-3.9403,6.53918,2.13732>,<-3.96676,6.53,2.13766>,
    /*2*/ <-4.01436,6.68913,2.69157>,<-4.00462,6.70271,2.68894>,<-3.9885,6.69811,2.69123>,
            <-3.98828,6.68168,2.69528>,<-4.00427,6.67613,2.69549>,
    /*3*/ <-4.05427,6.84743,3.24567>,<-4.0509,6.85208,3.24464>,<-4.04535,6.85054,3.24558>,
            <-4.04529,6.84493,3.24719>,<-4.0508,6.84301,3.24724>,
    /*4*/ <-4.04932,6.8476,3.24606>

    /* stem 0.6c0c0.0*/ 
    /*0*/ <-3.97968,6.62027,2.4101>,
    /*1*/ <-3.9766,6.63868,2.4058>,<-3.96726,6.61082,2.4212>,<-3.99517,6.6113,2.40329>,
            
    /*2*/ <-4.05003,6.67586,2.52118>,<-4.04162,6.65079,2.53504>,<-4.06674,6.65122,2.51891>,
            
    /*3*/ <-4.10541,6.73486,2.63385>,<-4.09886,6.7137,2.64847>,<-4.12246,6.71468,2.63638>,
            
    /*4*/ <-4.16098,6.82635,2.71999>,<-4.15818,6.81162,2.73773>,<-4.17785,6.81133,2.72538>,
            
    /*5*/ <-4.20246,6.93317,2.80004>,<-4.20063,6.92193,2.81637>,<-4.21796,6.92253,2.80659>,
            
    /*6*/ <-4.25485,7.03663,2.88262>,<-4.25331,7.02699,2.89602>,<-4.26739,7.02683,2.88727>,
            
    /*7*/ <-4.32218,7.14731,2.93722>,<-4.3222,7.14158,2.94919>,<-4.33232,7.13955,2.94085>,
            
    /*8*/ <-4.3876,7.26099,2.99039>,<-4.38771,7.25684,2.99944>,<-4.39532,7.25537,2.9932>,
            
    /*9*/ <-4.42825,7.37619,3.0623>,<-4.42798,7.37281,3.06801>,<-4.43363,7.373,3.06452>,
            
    /*10*/ <-4.48585,7.49248,3.119>,<-4.48585,7.49107,3.122>,<-4.48849,7.49074,3.12001>,
            
    /*11*/ <-4.53944,7.59905,3.19598>

    /* stem 0.6c0c0.0.0*/ 
    /*0*/ <-4.01146,6.63723,2.46006>,
    /*1*/ <-4.00803,6.63112,2.46431>,<-4.01935,6.63912,2.46123>,<-4.00699,6.64145,2.45463>,
            
    /*2*/ <-3.86752,6.9937,2.85626>

    /* stem 0.6c0c0.0.1*/ 
    /*0*/ <-4.09203,6.7025,2.60513>,
    /*1*/ <-4.09841,6.70397,2.60121>,<-4.08889,6.70792,2.60946>,<-4.0888,6.69561,2.6047>,
            
    /*2*/ <-4.37118,6.54715,3.00145>

    /* stem 0.6c0c0.0.2*/ 
    /*0*/ <-4.19276,6.88813,2.78009>,
    /*1*/ <-4.18636,6.89009,2.78072>,<-4.19704,6.88894,2.7852>,<-4.19487,6.88537,2.77434>,
            
    /*2*/ <-4.30031,7.28919,2.62707>

    /* stem 0.6c0c0.0.3*/ 
    /*0*/ <-4.22374,6.95974,2.83396>,
    /*1*/ <-4.22791,6.95564,2.83659>,<-4.22557,6.96573,2.83259>,<-4.21775,6.95786,2.83271>,
            
    /*2*/ <-4.10461,7.08408,3.21676>

    /* stem 0.6c0c0.0.4*/ 
    /*0*/ <-4.3072,7.11195,2.92769>,
    /*1*/ <-4.30631,7.11481,2.92278>,<-4.30618,7.1145,2.93273>,<-4.3091,7.10652,2.92754>,
            
    /*2*/ <-4.6583,7.23488,2.93608>

    /* stem 0.6c0c0.0.5*/ 
    /*0*/ <-4.36664,7.21583,2.97541>,
    /*1*/ <-4.36432,7.21501,2.98013>,<-4.37191,7.21645,2.97511>,<-4.36368,7.21604,2.971>,
            
    /*2*/ <-4.32949,7.55251,3.01619>

    /* stem 0.6c0c0.0.6*/ 
    /*0*/ <-4.46925,7.45528,3.10329>,
    /*1*/ <-4.47141,7.4548,3.10211>,<-4.46842,7.45764,3.10345>,<-4.46793,7.45341,3.1043>,
            
    /*2*/ <-4.60394,7.48661,3.3366>

    /* stem 0.6c0c0.0.7*/ 
    /*0*/ <-4.50769,7.53422,3.15042>,
    /*1*/ <-4.50671,7.53481,3.15026>,<-4.50821,7.53423,3.15145>,<-4.50815,7.53362,3.14955>,
            
    /*2*/ <-4.63851,7.73271,3.08253>

    /* stem 0.6c0.0*/ 
    /*0*/ <-1.98545,6.30667,0.69416>,
    /*1*/ <-1.99395,6.34792,0.68937>,<-1.96934,6.29246,0.7307>,<-1.99306,6.27964,0.66242>,
            
    /*2*/ <-2.20068,6.31013,0.76831>,<-2.17853,6.26022,0.8055>,<-2.19989,6.24868,0.74405>,
            
    /*3*/ <-2.38538,6.37489,0.83707>,<-2.38544,6.33229,0.8775>,<-2.40847,6.3224,0.82438>,
            
    /*4*/ <-2.57128,6.46779,0.90946>,<-2.57553,6.43237,0.94645>,<-2.59735,6.4244,0.90061>,
            
    /*5*/ <-2.73126,6.60626,0.95659>,<-2.74336,6.58149,0.99095>,<-2.76118,6.57436,0.95131>,
            
    /*6*/ <-2.88164,6.76653,0.97794>,<-2.89605,6.74988,1.00731>,<-2.90889,6.74229,0.97376>,
            
    /*7*/ <-3.03188,6.93196,0.9824>,<-3.04492,6.92013,1.0059>,<-3.05382,6.91276,0.97891>,
            
    /*8*/ <-3.15501,7.11664,0.99818>,<-3.16538,7.10864,1.01588>,<-3.17351,7.10493,0.99575>,
            
    /*9*/ <-3.27773,7.30412,1.00529>,<-3.28496,7.29923,1.0171>,<-3.2901,7.29638,1.00364>,
            
    /*10*/ <-3.38698,7.49942,1.00211>,<-3.39089,7.49747,1.00801>,<-3.3934,7.49595,1.00128>,
            
    /*11*/ <-3.47671,7.7036,0.98137>

    /* stem 0.6c0.0.0*/ 
    /*0*/ <-2.12149,6.28461,0.74558>,
    /*1*/ <-2.11501,6.27326,0.75785>,<-2.13581,6.28004,0.73582>,<-2.11365,6.30053,0.74307>,
            
    /*2*/ <-2.63877,6.63324,1.34125>

    /* stem 0.6c0.0.1*/ 
    /*0*/ <-2.29876,6.3101,0.81157>,
    /*1*/ <-2.30467,6.31004,0.79558>,<-2.30108,6.32378,0.82145>,<-2.29054,6.29648,0.81766>,
            
    /*2*/ <-3.0061,6.00075,1.07423>

    /* stem 0.6c0.0.2*/ 
    /*0*/ <-2.50842,6.40342,0.89074>,
    /*1*/ <-2.49985,6.41261,0.90053>,<-2.52093,6.39529,0.89635>,<-2.50449,6.40234,0.87533>,
            
    /*2*/ <-2.95988,6.99074,0.73447>

    /* stem 0.6c0.0.3*/ 
    /*0*/ <-2.69481,6.54247,0.95168>,
    /*1*/ <-2.70454,6.5313,0.95242>,<-2.69901,6.5556,0.94621>,<-2.68089,6.54051,0.9564>,
            
    /*2*/ <-2.88283,6.74898,1.59239>

    /* stem 0.6c0.0.4*/ 
    /*0*/ <-2.78618,6.63245,0.97174>,
    /*1*/ <-2.77912,6.64004,0.962>,<-2.79185,6.63893,0.98308>,<-2.78759,6.61837,0.97016>,
            
    /*2*/ <-3.35424,6.72717,0.6339>

    /* stem 0.6c0.0.5*/ 
    /*0*/ <-2.86145,6.71536,0.98179>,
    /*1*/ <-2.86179,6.71341,0.99536>,<-2.87315,6.71681,0.97477>,<-2.84942,6.71587,0.97523>,
            
    /*2*/ <-2.83829,7.34902,1.07359>

    /* stem 0.6c0.0.6*/ 
    /*0*/ <-2.95389,6.81943,0.98741>,
    /*1*/ <-2.95936,6.81481,0.97648>,<-2.9513,6.83219,0.98854>,<-2.95102,6.81129,0.99722>,
            
    /*2*/ <-3.50546,6.91069,1.22444>

    /* stem 0.6c0.0.7*/ 
    /*0*/ <-3.11541,7.03346,0.9975>,
    /*1*/ <-3.10576,7.03941,1.00081>,<-3.12563,7.03515,1.00317>,<-3.11484,7.02582,0.98851>,
            
    /*2*/ <-3.24185,7.43149,0.65103>

    /* stem 0.6c0.0.8*/ 
    /*0*/ <-3.2236,7.20365,1.00594>,
    /*1*/ <-3.23179,7.19837,1.01019>,<-3.22506,7.20963,0.99728>,<-3.21396,7.20294,1.01034>,
            
    /*2*/ <-3.32603,7.5931,1.29239>

    /* stem 0.6c0.0.9*/ 
    /*0*/ <-3.35339,7.42864,1.0055>,
    /*1*/ <-3.35109,7.42975,1.00038>,<-3.35331,7.43263,1.00959>,<-3.35576,7.42354,1.00652>,
            
    /*2*/ <-3.73404,7.57806,0.86686>

    /* stem 0.6c0.0.10*/ 
    /*0*/ <-3.41948,7.56699,0.99624>,
    /*1*/ <-3.419,7.56749,0.99897>,<-3.42191,7.56779,0.99508>,<-3.41754,7.56569,0.99469>,
            
    /*2*/ <-3.26041,7.91642,0.90404>

    /* stem 0.6c0.1*/ 
    /*0*/ <-2.30015,6.28519,0.95009>,
    /*1*/ <-2.2801,6.26063,0.97498>,<-2.3313,6.27117,0.9287>,<-2.28904,6.32378,0.9466>,
            
    /*2*/ <-2.41404,6.31535,1.13033>,<-2.46011,6.32483,1.08868>,<-2.42208,6.37218,1.10479>,
            
    /*3*/ <-2.51137,6.40075,1.29713>,<-2.5571,6.4103,1.26653>,<-2.51729,6.4493,1.27017>,
            
    /*4*/ <-2.5837,6.55292,1.4366>,<-2.62331,6.56047,1.409>,<-2.58275,6.5866,1.40121>,
            
    /*5*/ <-2.61272,6.71085,1.57241>,<-2.64842,6.72155,1.5533>,<-2.61221,6.73877,1.54119>,
            
    /*6*/ <-2.63118,6.89816,1.67803>,<-2.66073,6.9055,1.66097>,<-2.63004,6.91582,1.64795>,
            
    /*7*/ <-2.65301,7.0654,1.80341>,<-2.67681,7.07246,1.79061>,<-2.65246,7.08255,1.78138>,
            
    /*8*/ <-2.69298,7.24203,1.91727>,<-2.71046,7.24556,1.90629>,<-2.69227,7.25377,1.89994>,
            
    /*9*/ <-2.73657,7.40025,2.05004>,<-2.74836,7.4031,2.04314>,<-2.73645,7.40942,2.03951>,
            
    /*10*/ <-2.77455,7.55281,2.19201>,<-2.78052,7.55446,2.1888>,<-2.77458,7.55764,2.18697>,
            
    /*11*/ <-2.84847,7.72041,2.3011>

    /* stem 0.6c0.1.0*/ 
    /*0*/ <-2.40406,6.32635,1.07441>,
    /*1*/ <-2.41708,6.32606,1.06362>,<-2.40245,6.33913,1.08538>,<-2.39264,6.31388,1.07422>,
            
    /*2*/ <-2.84332,5.91641,1.61597>

    /* stem 0.6c0.1.1*/ 
    /*0*/ <-2.4873,6.38476,1.20521>,
    /*1*/ <-2.47445,6.39418,1.20792>,<-2.49466,6.37738,1.21757>,<-2.49278,6.3827,1.19015>,
            
    /*2*/ <-2.95114,6.99196,1.29116>

    /* stem 0.6c0.1.2*/ 
    /*0*/ <-2.55576,6.47868,1.33295>,
    /*1*/ <-2.56329,6.46782,1.34079>,<-2.56215,6.49249,1.3309>,<-2.54184,6.47571,1.32717>,
            
    /*2*/ <-2.25005,6.71176,1.94972>

    /* stem 0.6c0.1.3*/ 
    /*0*/ <-2.60382,6.6074,1.45193>,
    /*1*/ <-2.60614,6.61671,1.44102>,<-2.59413,6.6106,1.46227>,<-2.61117,6.59489,1.45249>,
            
    /*2*/ <-3.09409,6.91224,1.81682>

    /* stem 0.6c0.1.4*/ 
    /*0*/ <-2.63063,6.79341,1.59631>,
    /*1*/ <-2.62066,6.78955,1.60443>,<-2.6413,6.79981,1.60135>,<-2.62992,6.79087,1.58314>,
            
    /*2*/ <-2.3441,7.34233,1.50551>

    /* stem 0.6c0.1.5*/ 
    /*0*/ <-2.64808,6.96823,1.71019>,
    /*1*/ <-2.66048,6.96745,1.70927>,<-2.64252,6.97937,1.71004>,<-2.64126,6.95787,1.71126>,
            
    /*2*/ <-2.69244,6.99821,2.28316>

    /* stem 0.6c0.1.6*/ 
    /*0*/ <-2.68776,7.19748,1.87466>,
    /*1*/ <-2.67915,7.20258,1.86984>,<-2.6891,7.19805,1.88568>,<-2.69504,7.19181,1.86847>,
            
    /*2*/ <-2.9672,7.61684,1.81913>

    /* stem 0.6c0.1.7*/ 
    /*0*/ <-2.72186,7.33448,1.98366>,
    /*1*/ <-2.72362,7.32786,1.99075>,<-2.72831,7.34174,1.98199>,<-2.71366,7.33384,1.97825>,
            
    /*2*/ <-2.49878,7.60283,2.28963>

    /* stem 0.6c0.1.8*/ 
    /*0*/ <-2.75091,7.44788,2.08621>,
    /*1*/ <-2.75434,7.45159,2.08151>,<-2.74599,7.45085,2.09002>,<-2.7524,7.44121,2.0871>,
            
    /*2*/ <-3.04172,7.55223,2.38056>

    /* stem 0.6c0.1.9*/ 
    /*0*/ <-2.8005,7.61005,2.2265>,
    /*1*/ <-2.79817,7.61016,2.22784>,<-2.80282,7.61033,2.22782>,<-2.8005,7.60967,2.22384>,
            
    /*2*/ <-2.78631,7.9795,2.1729>

    /* stem 0.6c0.2*/ 
    /*0*/ <-2.84159,6.31662,1.3707>,
    /*1*/ <-2.8646,6.31514,1.34207>,<-2.83822,6.34774,1.38997>,<-2.82196,6.28699,1.38005>,
            
    /*2*/ <-3.00348,6.25851,1.46133>,<-2.97973,6.28785,1.50444>,<-2.9651,6.23318,1.49551>,
            
    /*3*/ <-3.15222,6.2738,1.58016>,<-3.12421,6.30061,1.61319>,<-3.12634,6.24986,1.61692>,
            
    /*4*/ <-3.29059,6.34887,1.68963>,<-3.2604,6.37054,1.71422>,<-3.27339,6.32955,1.72592>,
            
    /*5*/ <-3.40912,6.47733,1.76327>,<-3.38053,6.49356,1.78272>,<-3.40092,6.46546,1.79864>,
            
    /*6*/ <-3.47955,6.6412,1.84337>,<-3.45103,6.64785,1.85586>,<-3.47211,6.63078,1.87251>,
            
    /*7*/ <-3.54834,6.80625,1.90956>,<-3.52575,6.81205,1.91979>,<-3.54304,6.79934,1.93349>,
            
    /*8*/ <-3.60604,6.97896,1.96973>,<-3.58879,6.9825,1.97711>,<-3.60226,6.97426,1.98785>,
            
    /*9*/ <-3.65188,7.15633,2.02687>,<-3.64018,7.15807,2.03158>,<-3.64938,7.15331,2.03898>,
            
    /*10*/ <-3.68894,7.33191,2.09566>,<-3.68299,7.3324,2.09788>,<-3.68758,7.32999,2.10158>,
            
    /*11*/ <-3.71454,7.50408,2.17654>

    /* stem 0.6c0.2.0*/ 
    /*0*/ <-2.95282,6.27189,1.4624>,
    /*1*/ <-2.94795,6.28183,1.47315>,<-2.95685,6.25755,1.46641>,<-2.95365,6.27629,1.44764>,
            
    /*2*/ <-3.64011,6.4946,1.56761>

    /* stem 0.6c0.2.1*/ 
    /*0*/ <-3.06487,6.26793,1.55014>,
    /*1*/ <-3.06704,6.25336,1.54917>,<-3.07617,6.27722,1.54818>,<-3.05139,6.2732,1.55306>,
            
    /*2*/ <-3.20298,6.24348,2.23127>

    /* stem 0.6c0.2.2*/ 
    /*0*/ <-3.21526,6.31793,1.66481>,
    /*1*/ <-3.21602,6.32875,1.6562>,<-3.21527,6.31996,1.67851>,<-3.21449,6.30507,1.65972>,
            
    /*2*/ <-3.86181,6.27708,1.67034>

    /* stem 0.6c0.2.3*/ 
    /*0*/ <-3.32427,6.402,1.73895>,
    /*1*/ <-3.31981,6.39951,1.75103>,<-3.33718,6.40244,1.73669>,<-3.31582,6.40404,1.72913>,
            
    /*2*/ <-3.32558,6.99912,1.86237>

    /* stem 0.6c0.2.4*/ 
    /*0*/ <-3.4314,6.55752,1.81853>,
    /*1*/ <-3.4416,6.55607,1.81208>,<-3.42552,6.56815,1.81829>,<-3.42709,6.54834,1.82521>,
            
    /*2*/ <-3.73293,6.73433,2.25596>

    /* stem 0.6c0.2.5*/ 
    /*0*/ <-3.49756,6.70958,1.88398>,
    /*1*/ <-3.48733,6.71432,1.88309>,<-3.50433,6.7123,1.89262>,<-3.50102,6.7021,1.87623>,
            
    /*2*/ <-3.70046,7.0939,1.60371>

    /* stem 0.6c0.2.6*/ 
    /*0*/ <-3.58125,6.92739,1.96125>,
    /*1*/ <-3.58717,6.92302,1.96823>,<-3.58502,6.93458,1.95519>,<-3.57155,6.92456,1.96034>,
            
    /*2*/ <-3.45938,7.24759,2.26534>

    /* stem 0.6c0.2.7*/ 
    /*0*/ <-3.62697,7.08154,2.00973>,
    /*1*/ <-3.62722,7.08407,2.00121>,<-3.62239,7.08633,2.01566>,<-3.63129,7.07421,2.01231>,
            
    /*2*/ <-3.96767,7.31027,2.08803>

    /* stem 0.6c0.2.8*/ 
    /*0*/ <-3.67398,7.27557,2.0774>,
    /*1*/ <-3.67077,7.27495,2.08098>,<-3.67843,7.2772,2.0784>,<-3.67273,7.27456,2.07283>,
            
    /*2*/ <-3.55721,7.62081,2.03301>

    /* stem 0.6c0.2.9*/ 
    /*0*/ <-3.69578,7.38855,2.12423>,
    /*1*/ <-3.69819,7.38834,2.12382>,<-3.69459,7.39059,2.12355>,<-3.69455,7.38671,2.12532>,
            
    /*2*/ <-3.75872,7.52597,2.42576>

    /* stem 0.6c0.3*/ 
    /*0*/ <-3.26307,6.38922,1.67699>,
    /*1*/ <-3.24624,6.41215,1.69564>,<-3.27684,6.36194,1.69194>,<-3.26614,6.39356,1.64339>,
            
    /*2*/ <-3.3973,6.49904,1.71892>,<-3.42484,6.45385,1.71559>,<-3.4152,6.48231,1.6719>,
            
    /*3*/ <-3.52662,6.59918,1.7655>,<-3.55616,6.56246,1.76474>,<-3.55003,6.58858,1.72599>,
            
    /*4*/ <-3.64887,6.7105,1.81819>,<-3.67704,6.68038,1.81867>,<-3.67139,6.70279,1.78451>,
            
    /*5*/ <-3.76821,6.83404,1.85492>,<-3.79394,6.80982,1.8557>,<-3.78611,6.82633,1.82544>,
            
    /*6*/ <-3.8454,6.9733,1.91457>,<-3.87066,6.95844,1.91761>,<-3.8648,6.97253,1.89241>,
            
    /*7*/ <-3.91632,7.11458,1.98872>,<-3.93681,7.10329,1.99156>,<-3.93278,7.11564,1.97189>,
            
    /*8*/ <-4.01078,7.24658,2.06098>,<-4.02507,7.23622,2.06193>,<-4.02226,7.2461,2.04754>,
            
    /*9*/ <-4.10262,7.374,2.13955>,<-4.11211,7.36704,2.14018>,<-4.11051,7.37398,2.1308>,
            
    /*10*/ <-4.19243,7.49981,2.22305>,<-4.19718,7.49634,2.22339>,<-4.19646,7.49992,2.21876>,
            
    /*11*/ <-4.27701,7.63237,2.30149>

    /* stem 0.6c0.3.0*/ 
    /*0*/ <-3.35198,6.4423,1.69196>,
    /*1*/ <-3.35914,6.42987,1.69354>,<-3.3564,6.45198,1.6822>,<-3.34042,6.44506,1.70013>,
            
    /*2*/ <-3.75049,6.73109,2.15831>

    /* stem 0.6c0.3.1*/ 
    /*0*/ <-3.45946,6.51585,1.71994>,
    /*1*/ <-3.45613,6.52478,1.70994>,<-3.46316,6.52051,1.73241>,<-3.45908,6.50226,1.71748>,
            
    /*2*/ <-4.07661,6.53315,1.53025>

    /* stem 0.6c0.3.2*/ 
    /*0*/ <-3.57662,6.61389,1.76673>,
    /*1*/ <-3.57353,6.6112,1.77915>,<-3.58909,6.61601,1.76341>,<-3.56725,6.61447,1.75764>,
            
    /*2*/ <-3.50527,7.20693,1.87753>

    /* stem 0.6c0.3.3*/ 
    /*0*/ <-3.74975,6.78799,1.83457>,
    /*1*/ <-3.75681,6.78406,1.82585>,<-3.74837,6.79966,1.83629>,<-3.74407,6.78024,1.84156>,
            
    /*2*/ <-4.17404,6.78712,2.17864>

    /* stem 0.6c0.3.4*/ 
    /*0*/ <-3.81538,6.88429,1.8718>,
    /*1*/ <-3.80532,6.88939,1.87247>,<-3.82256,6.88479,1.88051>,<-3.81827,6.87869,1.86242>,
            
    /*2*/ <-4.02139,7.31632,1.67737>

    /* stem 0.6c0.3.5*/ 
    /*0*/ <-3.98534,7.19354,2.02953>,
    /*1*/ <-3.99062,7.1873,2.03426>,<-3.98949,7.20048,2.02463>,<-3.97592,7.19285,2.02969>,
            
    /*2*/ <-3.97298,7.44259,2.372>

    /* stem 0.6c0.3.6*/ 
    /*0*/ <-4.08418,7.33665,2.11507>,
    /*1*/ <-4.08429,7.34067,2.10847>,<-4.08258,7.3402,2.12174>,<-4.08568,7.32907,2.11499>,
            
    /*2*/ <-4.45097,7.40856,2.16501>

    /* stem 0.6c0.3.7*/ 
    /*0*/ <-4.13911,7.41652,2.16682>,
    /*1*/ <-4.13585,7.41574,2.17131>,<-4.14466,7.41697,2.16742>,<-4.13682,7.41684,2.16172>,
            
    /*2*/ <-4.10682,7.76385,2.20325>

    /* stem 0.6c0.3.8*/ 
    /*0*/ <-4.21869,7.53689,2.24453>,
    /*1*/ <-4.22082,7.53614,2.24361>,<-4.21811,7.53925,2.24446>,<-4.21716,7.53529,2.24551>,
            
    /*2*/ <-4.35284,7.57794,2.52251>

    /* stem 0.6c0.4*/ 
    /*0*/ <-4.08635,6.58518,2.23093>,
    /*1*/ <-4.09146,6.56465,2.23123>,<-4.10089,6.59962,2.22571>,<-4.06669,6.59126,2.23584>,
            
    /*2*/ <-4.12949,6.57834,2.37091>,<-4.13798,6.60982,2.36594>,<-4.1072,6.60229,2.37506>,
            
    /*3*/ <-4.1609,6.65015,2.50211>,<-4.16585,6.67501,2.4874>,<-4.13892,6.66893,2.49724>,
            
    /*4*/ <-4.18351,6.75057,2.6104>,<-4.18683,6.76903,2.59291>,<-4.16342,6.76426,2.60225>,
            
    /*5*/ <-4.20556,6.84957,2.71473>,<-4.20839,6.86528,2.69961>,<-4.18834,6.86127,2.70766>,
            
    /*6*/ <-4.24004,6.96307,2.80123>,<-4.24167,6.974,2.78662>,<-4.22552,6.97242,2.79513>,
            
    /*7*/ <-4.29041,7.07431,2.8798>,<-4.29143,7.0826,2.86776>,<-4.27908,7.08262,2.87564>,
            
    /*8*/ <-4.34699,7.19866,2.93322>,<-4.34688,7.20317,2.92319>,<-4.33818,7.20428,2.92981>,
            
    /*9*/ <-4.36768,7.33387,2.98545>,<-4.36755,7.33661,2.97866>,<-4.36134,7.33607,2.98251>,
            
    /*10*/ <-4.40072,7.46143,3.04586>,<-4.40071,7.46304,3.04257>,<-4.39763,7.4629,3.04455>,
            
    /*11*/ <-4.42229,7.59699,3.09462>

    /* stem 0.6c0.4.0*/ 
    /*0*/ <-4.11105,6.59264,2.32046>,
    /*1*/ <-4.11476,6.6006,2.31877>,<-4.10593,6.59153,2.32772>,<-4.11245,6.58577,2.31488>,
            
    /*2*/ <-4.5623,6.44483,2.61582>

    /* stem 0.6c0.4.1*/ 
    /*0*/ <-4.1448,6.64137,2.45265>,
    /*1*/ <-4.13766,6.63839,2.45601>,<-4.1518,6.64182,2.45734>,<-4.14494,6.64392,2.44461>,
            
    /*2*/ <-4.01336,7.12542,2.6035>

    /* stem 0.6c0.4.2*/ 
    /*0*/ <-4.18922,6.80947,2.65403>,
    /*1*/ <-4.19656,6.80796,2.65383>,<-4.18682,6.81653,2.6532>,<-4.18427,6.80392,2.65505>,
            
    /*2*/ <-4.21391,6.87131,3.10881>

    /* stem 0.6c0.4.3*/ 
    /*0*/ <-4.2153,6.90488,2.74348>,
    /*1*/ <-4.21049,6.9089,2.74029>,<-4.21552,6.90458,2.7505>,<-4.21988,6.90117,2.73966>,
            
    /*2*/ <-4.48729,7.23464,2.74885>

    /* stem 0.6c0.4.4*/ 
    /*0*/ <-4.24986,7.00015,2.81639>,
    /*1*/ <-4.25047,6.9961,2.82155>,<-4.2545,7.00466,2.81517>,<-4.24461,6.99968,2.81245>,
            
    /*2*/ <-4.05551,7.26153,3.0442>

    /* stem 0.6c0.4.5*/ 
    /*0*/ <-4.32577,7.16293,2.91135>,
    /*1*/ <-4.32841,7.16398,2.90624>,<-4.32344,7.16735,2.9144>,<-4.32545,7.15747,2.91342>,
            
    /*2*/ <-4.62899,7.20807,3.07705>

    /* stem 0.6c0.4.6*/ 
    /*0*/ <-4.38283,7.3998,3.01367>,
    /*1*/ <-4.37994,7.39995,3.01495>,<-4.38535,7.40067,3.01535>,<-4.38318,7.39879,3.0107>,
            
    /*2*/ <-4.35406,7.66677,2.91889>

    /* stem 0.6c0.4.7*/ 
    /*0*/ <-4.41164,7.53363,3.07094>,
    /*1*/ <-4.41258,7.53338,3.07118>,<-4.41147,7.53445,3.0704>,<-4.41088,7.53306,3.07123>,
            
    /*2*/ <-4.3914,7.66644,3.28066>

    /* stem 0.6c1*/ 
    /*0*/ <-3.32822,6.38514,0.9186>,
    /*1*/ <-3.30882,6.38288,0.88065>,<-3.32091,6.42498,0.90513>,<-3.34312,6.41203,0.94822>,
            <-3.34474,6.36192,0.95038>,<-3.32354,6.34391,0.90863>,
    /*2*/ <-3.82736,6.38865,0.62569>,<-3.83679,6.42145,0.64475>,<-3.85408,6.41136,0.67833>,
            <-3.85535,6.37233,0.68001>,<-3.83883,6.35829,0.64748>,
    /*3*/ <-4.3483,6.4193,0.37646>,<-4.354,6.44276,0.39065>,<-4.36641,6.43552,0.4147>,
            <-4.36838,6.40759,0.41536>,<-4.35718,6.39756,0.39173>,
    /*4*/ <-4.85123,6.48414,0.10187>,<-4.85436,6.49829,0.1106>,<-4.86286,6.49403,0.1246>,
            <-4.86498,6.47724,0.12452>,<-4.85779,6.47113,0.11047>,
    /*5*/ <-5.3297,6.51421,-0.21837>,<-5.33126,6.51914,-0.21567>,<-5.33454,6.51771,-0.21106>,
            <-5.33501,6.5119,-0.21091>,<-5.33201,6.50973,-0.21543>,
    /*6*/ <-5.3325,6.51454,-0.21429>

    /* stem 0.6c1.0*/ 
    /*0*/ <-3.65834,6.38853,0.74955>,
    /*1*/ <-3.66937,6.41152,0.77156>,<-3.67148,6.35752,0.74958>,<-3.63416,6.39655,0.72752>,
            
    /*2*/ <-3.78916,6.46033,0.65534>,<-3.79105,6.41174,0.63557>,<-3.75747,6.44687,0.61571>,
            
    /*3*/ <-3.91237,6.52512,0.55861>,<-3.91875,6.48379,0.53789>,<-3.88861,6.51453,0.51987>,
            
    /*4*/ <-4.02099,6.62347,0.47311>,<-4.03273,6.5917,0.4503>,<-4.00178,6.61533,0.438>,
            
    /*5*/ <-4.13505,6.7323,0.40758>,<-4.14778,6.70723,0.38673>,<-4.12178,6.7278,0.3755>,
            
    /*6*/ <-4.23464,6.86086,0.35257>,<-4.24803,6.84305,0.33375>,<-4.22433,6.85789,0.32545>,
            
    /*7*/ <-4.29774,7.01203,0.29774>,<-4.31038,7.00125,0.28136>,<-4.28875,7.00853,0.2765>,
            
    /*8*/ <-4.3735,7.15593,0.23352>,<-4.3823,7.1464,0.22177>,<-4.36655,7.1529,0.21775>,
            
    /*9*/ <-4.44361,7.30395,0.17666>,<-4.44976,7.29817,0.16861>,<-4.43913,7.30222,0.16603>,
            
    /*10*/ <-4.50426,7.45341,0.11099>,<-4.50732,7.45051,0.10695>,<-4.50186,7.45222,0.10581>,
            
    /*11*/ <-4.57141,7.60221,0.05138>

    /* stem 0.6c1.0.0*/ 
    /*0*/ <-3.75015,6.42735,0.66296>,
    /*1*/ <-3.75242,6.41386,0.65932>,<-3.74748,6.43703,0.65298>,<-3.75055,6.43117,0.67659>,
            
    /*2*/ <-4.39999,6.55121,0.60897>

    /* stem 0.6c1.0.1*/ 
    /*0*/ <-3.83676,6.47044,0.59183>,
    /*1*/ <-3.82862,6.48078,0.5884>,<-3.84959,6.47287,0.59563>,<-3.83207,6.45768,0.59147>,
            
    /*2*/ <-4.02551,6.41843,-0.01207>

    /* stem 0.6c1.0.2*/ 
    /*0*/ <-3.9889,6.5831,0.47628>,
    /*1*/ <-3.99781,6.58035,0.4847>,<-3.99177,6.58371,0.46407>,<-3.97711,6.58523,0.48008>,
            
    /*2*/ <-4.10978,7.14882,0.53316>

    /* stem 0.6c1.0.3*/ 
    /*0*/ <-4.08737,6.67661,0.41601>,
    /*1*/ <-4.08425,6.67356,0.40497>,<-4.09041,6.68782,0.41843>,<-4.08744,6.66845,0.42463>,
            
    /*2*/ <-4.60789,6.56015,0.30146>

    /* stem 0.6c1.0.4*/ 
    /*0*/ <-4.18695,6.79039,0.36272>,
    /*1*/ <-4.18323,6.79661,0.37113>,<-4.19766,6.79082,0.3598>,<-4.17997,6.78372,0.35722>,
            
    /*2*/ <-4.08343,7.16632,0.03873>

    /* stem 0.6c1.0.5*/ 
    /*0*/ <-4.34221,7.09041,0.25018>,
    /*1*/ <-4.34982,7.08544,0.24778>,<-4.33929,7.09747,0.24471>,<-4.33752,7.08832,0.25805>,
            
    /*2*/ <-4.58509,7.35813,0.46611>

    /* stem 0.6c1.0.6*/ 
    /*0*/ <-4.3919,7.18974,0.21066>,
    /*1*/ <-4.3841,7.19219,0.20733>,<-4.39629,7.19517,0.21607>,<-4.39531,7.18187,0.20859>,
            
    /*2*/ <-4.57427,7.34995,-0.09809>

    /* stem 0.6c1.0.7*/ 
    /*0*/ <-4.47301,7.37347,0.14054>,
    /*1*/ <-4.47584,7.37409,0.14477>,<-4.47498,7.3746,0.13594>,<-4.46821,7.37172,0.1409>,
            
    /*2*/ <-4.35831,7.69395,0.17008>

    /* stem 0.6c1.0.8*/ 
    /*0*/ <-4.52634,7.50108,0.08945>,
    /*1*/ <-4.52651,7.50022,0.08736>,<-4.52544,7.50315,0.08976>,<-4.52706,7.49989,0.09124>,
            
    /*2*/ <-4.80448,7.62605,0.06082>

    /* stem 0.6c1.1*/ 
    /*0*/ <-4.63601,6.4563,0.24051>,
    /*1*/ <-4.63673,6.43795,0.23762>,<-4.63652,6.46802,0.22609>,<-4.63477,6.46293,0.25784>,
            
    /*2*/ <-4.77702,6.44398,0.2463>,<-4.77683,6.47104,0.23593>,<-4.77526,6.46647,0.2645>,
            
    /*3*/ <-4.9117,6.50103,0.25637>,<-4.90313,6.52326,0.24657>,<-4.90286,6.51947,0.27205>,
            
    /*4*/ <-5.01753,6.60111,0.25484>,<-5.00324,6.61626,0.24622>,<-5.00546,6.6143,0.26856>,
            
    /*5*/ <-5.10234,6.71015,0.2214>,<-5.0872,6.72019,0.21482>,<-5.0925,6.72173,0.23334>,
            
    /*6*/ <-5.18899,6.8197,0.20368>,<-5.17686,6.8286,0.19794>,<-5.1801,6.82861,0.21371>,
            
    /*7*/ <-5.26702,6.93659,0.18768>,<-5.25678,6.94299,0.1832>,<-5.25936,6.94299,0.19582>,
            
    /*8*/ <-5.34008,7.04917,0.14596>,<-5.33198,7.0534,0.14282>,<-5.33498,7.05482,0.1519>,
            
    /*9*/ <-5.41438,7.16059,0.10308>,<-5.40901,7.16345,0.10097>,<-5.41103,7.16443,0.10701>,
            
    /*10*/ <-5.49677,7.26929,0.0693>,<-5.49424,7.27091,0.06816>,<-5.49509,7.27122,0.07125>,
            
    /*11*/ <-5.5837,7.37854,0.05201>

    /* stem 0.6c1.1.0*/ 
    /*0*/ <-4.6925,6.45799,0.24389>,
    /*1*/ <-4.69254,6.46483,0.23979>,<-4.69755,6.45696,0.24997>,<-4.6874,6.45219,0.24192>,
            
    /*2*/ <-5.0647,6.2487,-0.10137>

    /* stem 0.6c1.1.1*/ 
    /*0*/ <-4.83478,6.48489,0.25316>,
    /*1*/ <-4.83521,6.48261,0.2603>,<-4.84059,6.48383,0.24852>,<-4.82854,6.48823,0.25065>,
            
    /*2*/ <-5.02575,6.94249,0.38749>

    /* stem 0.6c1.1.2*/ 
    /*0*/ <-5.03179,6.63943,0.24752>,
    /*1*/ <-5.0327,6.6368,0.24143>,<-5.03157,6.64607,0.2483>,<-5.03111,6.63541,0.25283>,
            
    /*2*/ <-5.47956,6.6472,0.31088>

    /* stem 0.6c1.1.3*/ 
    /*0*/ <-5.15231,6.78911,0.21121>,
    /*1*/ <-5.14843,6.79275,0.21412>,<-5.15828,6.7897,0.21211>,<-5.15022,6.78488,0.20739>,
            
    /*2*/ <-5.17223,7.05474,-0.09425>

    /* stem 0.6c1.1.4*/ 
    /*0*/ <-5.23267,6.8995,0.19472>,
    /*1*/ <-5.23729,6.89647,0.19573>,<-5.23256,6.90309,0.1904>,<-5.22816,6.89894,0.19802>,
            
    /*2*/ <-5.3612,7.16984,0.41601>

    /* stem 0.6c1.1.5*/ 
    /*0*/ <-5.29522,6.99195,0.16967>,
    /*1*/ <-5.29174,6.99283,0.16584>,<-5.29653,6.99581,0.17296>,<-5.29738,6.98721,0.1702>,
            
    /*2*/ <-5.5513,7.08521,-0.04135>

    /* stem 0.6c1.1.6*/ 
    /*0*/ <-5.43458,7.19247,0.09429>,
    /*1*/ <-5.43499,7.19313,0.0974>,<-5.43707,7.19259,0.09228>,<-5.43167,7.19168,0.09319>,
            
    /*2*/ <-5.38001,7.46576,0.04329>

    /* stem 0.6c1.1.7*/ 
    /*0*/ <-5.52384,7.30531,0.06391>,
    /*1*/ <-5.52442,7.30469,0.06298>,<-5.52353,7.30652,0.06375>,<-5.52358,7.30473,0.065>,
            
    /*2*/ <-5.74377,7.37506,0.15476>

    /* stem 0.6c2*/ 
    /*0*/ <-4.46743,6.40032,1.10367>,
    /*1*/ <-4.48114,6.39898,1.08424>,<-4.47188,6.42252,1.09626>,<-4.45646,6.41538,1.11852>,
            <-4.45619,6.38743,1.12026>,<-4.47145,6.37729,1.09907>,
    /*2*/ <-4.94806,6.41561,1.42431>,<-4.94246,6.42983,1.43157>,<-4.93315,6.42552,1.44502>,
            <-4.93298,6.40863,1.44607>,<-4.9422,6.40251,1.43327>,
    /*3*/ <-5.41473,6.45314,1.76304>,<-5.41266,6.45804,1.76544>,<-5.4095,6.45655,1.77012>,
            <-5.40962,6.45074,1.7706>,<-5.41285,6.44863,1.76623>,
    /*4*/ <-5.41187,6.45342,1.76709>

    /* stem 0.6c2.0*/ 
    /*0*/ <-5.23233,6.43935,1.64119>,
    /*1*/ <-5.23335,6.43088,1.64068>,<-5.23828,6.44458,1.63798>,<-5.22535,6.44259,1.64491>,
            
    /*2*/ <-5.29097,6.43218,1.74845>,<-5.29541,6.44451,1.74602>,<-5.28377,6.44272,1.75227>,
            
    /*3*/ <-5.36329,6.46482,1.84374>,<-5.36512,6.47542,1.83879>,<-5.35604,6.47384,1.84622>,
            
    /*4*/ <-5.4234,6.5324,1.92901>,<-5.42349,6.54052,1.92257>,<-5.4156,6.53922,1.92917>,
            
    /*5*/ <-5.48009,6.61707,1.99833>,<-5.47933,6.62302,1.99177>,<-5.47292,6.6223,1.99789>,
            
    /*6*/ <-5.53221,6.71086,2.05799>,<-5.5312,6.71523,2.0521>,<-5.52598,6.7148,2.05733>,
            
    /*7*/ <-5.59463,6.80739,2.10002>,<-5.59345,6.81036,2.09503>,<-5.58976,6.81074,2.09965>,
            
    /*8*/ <-5.63639,6.91738,2.13548>,<-5.63525,6.91911,2.13155>,<-5.63234,6.91913,2.13491>,
            
    /*9*/ <-5.676,7.0334,2.14004>,<-5.67497,7.03388,2.1373>,<-5.67323,7.03438,2.13963>,
            
    /*10*/ <-5.73445,7.14037,2.13328>,<-5.73392,7.14058,2.13191>,<-5.73316,7.14107,2.13308>,
            
    /*11*/ <-5.7842,7.24764,2.10181>

    /* stem 0.6c2.0.0*/ 
    /*0*/ <-5.2516,6.4395,1.67715>,
    /*1*/ <-5.25332,6.44261,1.67621>,<-5.25047,6.43899,1.68062>,<-5.25099,6.4369,1.67462>,
            
    /*2*/ <-5.67273,6.23788,1.78437>

    /* stem 0.6c2.0.1*/ 
    /*0*/ <-5.38935,6.50236,1.88235>,
    /*1*/ <-5.38716,6.50149,1.88459>,<-5.3925,6.50239,1.88311>,<-5.38838,6.50319,1.87937>,
            
    /*2*/ <-5.356,6.89915,2.00419>

    /* stem 0.6c2.0.2*/ 
    /*0*/ <-5.43936,6.56468,1.94952>,
    /*1*/ <-5.44207,6.56378,1.94839>,<-5.43861,6.56765,1.94953>,<-5.4374,6.5626,1.95065>,
            
    /*2*/ <-5.60059,6.60448,2.30379>

    /* stem 0.6c2.0.3*/ 
    /*0*/ <-5.49514,6.65216,2.01621>,
    /*1*/ <-5.49293,6.65384,2.01552>,<-5.49637,6.65239,2.01877>,<-5.49611,6.65025,2.01432>,
            
    /*2*/ <-5.72424,6.89858,1.88371>

    /* stem 0.6c2.0.4*/ 
    /*0*/ <-5.60934,6.85288,2.11245>,
    /*1*/ <-5.61033,6.85185,2.11441>,<-5.61051,6.85466,2.1113>,<-5.60718,6.85212,2.11165>,
            
    /*2*/ <-5.47311,7.05639,2.28779>

    /* stem 0.6c2.0.5*/ 
    /*0*/ <-5.66411,7.00332,2.13766>,
    /*1*/ <-5.66439,7.00331,2.13575>,<-5.66303,7.0047,2.13848>,<-5.66493,7.00195,2.13877>,
            
    /*2*/ <-5.87673,7.15351,2.16711>

    /* stem 0.6c2.0.6*/ 
    /*0*/ <-5.75588,7.18749,2.11921>,
    /*1*/ <-5.7556,7.18772,2.11953>,<-5.75635,7.18761,2.11918>,<-5.7557,7.18715,2.11893>,
            
    /*2*/ <-5.7079,7.33396,1.9736>

    /* stem 0.6.0*/ 
    /*0*/ <-0.34995,6.41265,-0.00533>,
    /*1*/ <-0.34311,6.44728,0.03224>,<-0.37733,6.36991,0.00368>,<-0.32941,6.42076,-0.05191>,
            
    /*2*/ <-0.57628,6.576,-0.051>,<-0.60709,6.50637,-0.0767>,<-0.56396,6.55213,-0.12674>,
            
    /*3*/ <-0.78955,6.73387,-0.11511>,<-0.82521,6.67728,-0.14021>,<-0.78378,6.71567,-0.18395>,
            
    /*4*/ <-0.95711,6.9364,-0.19713>,<-0.99634,6.89495,-0.2226>,<-0.9501,6.91935,-0.25685>,
            
    /*5*/ <-1.10979,7.13939,-0.3212>,<-1.14224,7.10282,-0.3431>,<-1.09866,7.11924,-0.36958>,
            
    /*6*/ <-1.24578,7.35554,-0.42613>,<-1.27506,7.32835,-0.44605>,<-1.23814,7.34109,-0.46767>,
            
    /*7*/ <-1.37081,7.59466,-0.46613>,<-1.39747,7.57839,-0.48346>,<-1.36902,7.59024,-0.50152>,
            
    /*8*/ <-1.48691,7.8448,-0.5035>,<-1.50747,7.83377,-0.51666>,<-1.48575,7.84184,-0.5301>,
            
    /*9*/ <-1.54254,8.11354,-0.5448>,<-1.55727,8.10936,-0.554>,<-1.54168,8.11129,-0.5625>,
            
    /*10*/ <-1.58569,8.38606,-0.58449>,<-1.59312,8.38436,-0.58914>,<-1.58526,8.38499,-0.59335>,
            
    /*11*/ <-1.57341,8.66119,-0.62672>

    /* stem 0.6.0.0*/ 
    /*0*/ <-0.52867,6.51426,-0.06643>,
    /*1*/ <-0.53835,6.49519,-0.06985>,<-0.53138,6.53047,-0.08054>,<-0.51629,6.51713,-0.04889>,
            
    /*2*/ <-1.37947,6.84777,0.47963>

    /* stem 0.6.0.1*/ 
    /*0*/ <-0.64358,6.59105,-0.10217>,
    /*1*/ <-0.63069,6.60439,-0.11207>,<-0.65629,6.59807,-0.08695>,<-0.64376,6.57071,-0.10747>,
            
    /*2*/ <-1.37617,6.77987,-0.80144>

    /* stem 0.6.0.2*/ 
    /*0*/ <-0.72769,6.65464,-0.12604>,
    /*1*/ <-0.73553,6.65128,-0.10734>,<-0.74013,6.65566,-0.14237>,<-0.7074,6.65697,-0.12841>,
            
    /*2*/ <-0.8254,7.64476,0.01054>

    /* stem 0.6.0.3*/ 
    /*0*/ <-0.906,6.84049,-0.19646>,
    /*1*/ <-0.90652,6.83324,-0.21441>,<-0.90352,6.8595,-0.19377>,<-0.90795,6.82872,-0.18121>,
            
    /*2*/ <-1.83716,6.96502,-0.21983>

    /* stem 0.6.0.4*/ 
    /*0*/ <-1.01111,6.97599,-0.2601>,
    /*1*/ <-1.00195,6.98859,-0.25003>,<-1.02945,6.97751,-0.26239>,<-1.00194,6.96188,-0.26787>,
            
    /*2*/ <-0.87819,7.46788,-0.99675>

    /* stem 0.6.0.5*/ 
    /*0*/ <-1.16142,7.19284,-0.37799>,
    /*1*/ <-1.17618,7.18394,-0.37761>,<-1.15684,7.20133,-0.39229>,<-1.15125,7.19327,-0.36408>,
            
    /*2*/ <-1.55959,7.86428,-0.10716>

    /* stem 0.6.0.6*/ 
    /*0*/ <-1.21613,7.28175,-0.41899>,
    /*1*/ <-1.20331,7.28489,-0.42928>,<-1.22305,7.2942,-0.4102>,<-1.22203,7.26616,-0.41749>,
            
    /*2*/ <-1.72937,7.41847,-1.01636>

    /* stem 0.6.0.7*/ 
    /*0*/ <-1.33765,7.50687,-0.47151>,
    /*1*/ <-1.34082,7.50754,-0.45631>,<-1.34832,7.51137,-0.48188>,<-1.32381,7.50171,-0.47635>,
            
    /*2*/ <-1.07265,8.19333,-0.44639>

    /* stem 0.6.0.8*/ 
    /*0*/ <-1.42521,7.68958,-0.49704>,
    /*1*/ <-1.43131,7.68518,-0.50956>,<-1.41912,7.70284,-0.49615>,<-1.42518,7.68074,-0.48541>,
            
    /*2*/ <-2.02741,7.95256,-0.29583>

    /* stem 0.6.0.9*/ 
    /*0*/ <-1.51876,7.96818,-0.53423>,
    /*1*/ <-1.50698,7.97116,-0.52953>,<-1.52898,7.97579,-0.53149>,<-1.52033,7.95759,-0.54165>,
            
    /*2*/ <-1.40315,8.30388,-1.03722>

    /* stem 0.6.0.10*/ 
    /*0*/ <-1.55726,8.17906,-0.56247>,
    /*1*/ <-1.5658,8.17815,-0.55965>,<-1.55542,8.1841,-0.56974>,<-1.55057,8.17493,-0.55802>,
            
    /*2*/ <-1.49677,8.63235,-0.23275>

    /* stem 0.6.0.11*/ 
    /*0*/ <-1.57573,8.30281,-0.5784>,
    /*1*/ <-1.57215,8.30262,-0.58406>,<-1.57412,8.30716,-0.57355>,<-1.58094,8.29866,-0.57758>,
            
    /*2*/ <-1.89995,8.66619,-0.79628>

    /* stem 0.6.0.12*/ 
    /*0*/ <-1.58017,8.53351,-0.60927>,
    /*1*/ <-1.57987,8.53381,-0.60692>,<-1.5819,8.53469,-0.61041>,<-1.57874,8.53202,-0.61047>,
            
    /*2*/ <-1.27825,8.89329,-0.69466>

    /* stem 0.6.1*/ 
    /*0*/ <-0.48939,6.4136,0.0192>,
    /*1*/ <-0.49092,6.36322,0.01246>,<-0.52087,6.44372,-0.00702>,<-0.45639,6.43385,0.05215>,
            
    /*2*/ <-0.67775,6.34716,0.21334>,<-0.70471,6.4196,0.1958>,<-0.64668,6.41072,0.24906>,
            
    /*3*/ <-0.89388,6.45371,0.38092>,<-0.89254,6.51401,0.34452>,<-0.85215,6.50651,0.40175>,
            
    /*4*/ <-1.08683,6.58524,0.53378>,<-1.08166,6.63562,0.49862>,<-1.04633,6.62926,0.54874>,
            
    /*5*/ <-1.26898,6.78914,0.61498>,<-1.25066,6.82126,0.57722>,<-1.22875,6.82182,0.62531>,
            
    /*6*/ <-1.41839,7.02499,0.64707>,<-1.39677,7.04393,0.61371>,<-1.38163,7.04794,0.65487>,
            
    /*7*/ <-1.56654,7.24919,0.69867>,<-1.55074,7.26637,0.67229>,<-1.53727,7.26781,0.70481>,
            
    /*8*/ <-1.70007,7.49253,0.70219>,<-1.68548,7.50129,0.68198>,<-1.67743,7.50535,0.70681>,
            
    /*9*/ <-1.7729,7.76067,0.71225>,<-1.76225,7.76435,0.69872>,<-1.75619,7.76537,0.71522>,
            
    /*10*/ <-1.84808,8.01884,0.65224>,<-1.84227,8.01915,0.64563>,<-1.83989,8.02172,0.65371>,
            
    /*11*/ <-1.95355,8.26964,0.619>

    /* stem 0.6.1.0*/ 
    /*0*/ <-0.59823,6.40131,0.13573>,
    /*1*/ <-0.60789,6.41925,0.12859>,<-0.59687,6.39748,0.15693>,<-0.58993,6.3872,0.12166>,
            
    /*2*/ <-1.52602,5.88841,0.10252>

    /* stem 0.6.1.1*/ 
    /*0*/ <-0.75118,6.42892,0.27696>,
    /*1*/ <-0.74079,6.42343,0.29393>,<-0.7715,6.42552,0.27575>,<-0.74124,6.43779,0.2612>,
            
    /*2*/ <-0.92683,7.33764,0.67828>

    /* stem 0.6.1.2*/ 
    /*0*/ <-0.84096,6.47264,0.34606>,
    /*1*/ <-0.85449,6.46518,0.3332>,<-0.84313,6.49129,0.35322>,<-0.82527,6.46144,0.35175>,
            
    /*2*/ <-1.36281,6.12312,1.09789>

    /* stem 0.6.1.3*/ 
    /*0*/ <-0.99351,6.56576,0.46552>,
    /*1*/ <-0.98207,6.58099,0.46744>,<-1.00265,6.55868,0.48078>,<-0.99581,6.55762,0.44835>,
            
    /*2*/ <-1.71237,7.1275,0.29553>

    /* stem 0.6.1.4*/ 
    /*0*/ <-1.12813,6.67837,0.55209>,
    /*1*/ <-1.13652,6.6663,0.5629>,<-1.13798,6.69002,0.54206>,<-1.1099,6.6788,0.55129>,
            
    /*2*/ <-1.11298,7.25978,1.21282>

    /* stem 0.6.1.5*/ 
    /*0*/ <-1.28614,6.86674,0.61386>,
    /*1*/ <-1.28468,6.87009,0.59715>,<-1.28494,6.87943,0.62527>,<-1.2888,6.85069,0.61917>,
            
    /*2*/ <-2.09525,6.98523,0.5671>

    /* stem 0.6.1.6*/ 
    /*0*/ <-1.37564,7.00339,0.63345>,
    /*1*/ <-1.36793,7.00642,0.64756>,<-1.39183,7.00548,0.63237>,<-1.36716,6.99827,0.62043>,
            
    /*2*/ <-1.26548,7.74342,0.41439>

    /* stem 0.6.1.7*/ 
    /*0*/ <-1.50602,7.19488,0.67601>,
    /*1*/ <-1.51843,7.18761,0.67083>,<-1.50235,7.20865,0.67045>,<-1.49729,7.1884,0.68676>,
            
    /*2*/ <-1.9053,7.50932,1.19029>

    /* stem 0.6.1.8*/ 
    /*0*/ <-1.62433,7.38873,0.69464>,
    /*1*/ <-1.61274,7.39545,0.68978>,<-1.63189,7.39439,0.7053>,<-1.62835,7.37637,0.68882>,
            
    /*2*/ <-2.00095,7.71908,0.2526>

    /* stem 0.6.1.9*/ 
    /*0*/ <-1.74079,7.6838,0.70519>,
    /*1*/ <-1.74624,7.68177,0.71534>,<-1.74571,7.6908,0.6972>,<-1.73041,7.67882,0.70302>,
            
    /*2*/ <-1.4672,8.14998,0.94517>

    /* stem 0.6.1.10*/ 
    /*0*/ <-1.77569,7.80181,0.70003>,
    /*1*/ <-1.77669,7.79944,0.69098>,<-1.77078,7.80949,0.70236>,<-1.77959,7.79649,0.70674>,
            
    /*2*/ <-2.24439,8.10993,0.67151>

    /* stem 0.6.1.11*/ 
    /*0*/ <-1.83052,7.97839,0.65994>,
    /*1*/ <-1.82643,7.98051,0.66364>,<-1.8361,7.98033,0.66029>,<-1.82905,7.97435,0.6559>,
            
    /*2*/ <-1.72083,8.35448,0.32377>

    /* stem 0.6.1.12*/ 
    /*0*/ <-1.89434,8.13539,0.63595>,
    /*1*/ <-1.89685,8.13429,0.63602>,<-1.89364,8.13705,0.63389>,<-1.89255,8.13482,0.63793>,
            
    /*2*/ <-2.05072,8.50885,0.88444>

    /* stem 0.6.2*/ 
    /*0*/ <-0.73015,6.40259,0.07512>,
    /*1*/ <-0.74035,6.44438,0.05042>,<-0.74487,6.39738,0.1222>,<-0.70521,6.36601,0.05274>,
            
    /*2*/ <-0.96999,6.3343,-0.03099>,<-0.97406,6.29199,0.03361>,<-0.93837,6.26377,-0.02891>,
            
    /*3*/ <-1.18407,6.35967,-0.14741>,<-1.21338,6.31629,-0.10287>,<-1.18447,6.29217,-0.16038>,
            
    /*4*/ <-1.40075,6.45043,-0.25349>,<-1.43392,6.41475,-0.21823>,<-1.41563,6.3952,-0.27208>,
            
    /*5*/ <-1.61178,6.59218,-0.31655>,<-1.64146,6.56292,-0.28621>,<-1.63505,6.5504,-0.3358>,
            
    /*6*/ <-1.81894,6.73823,-0.3986>,<-1.8458,6.71505,-0.37437>,<-1.83793,6.70333,-0.41494>,
            
    /*7*/ <-1.98328,6.91267,-0.50585>,<-2.00992,6.89841,-0.48949>,<-2.00112,6.88741,-0.52084>,
            
    /*8*/ <-2.15914,7.09858,-0.58358>,<-2.17799,7.08679,-0.57054>,<-2.17359,7.08066,-0.59519>,
            
    /*9*/ <-2.3385,7.28968,-0.63641>,<-2.35051,7.28127,-0.62744>,<-2.34872,7.27831,-0.64427>,
            
    /*10*/ <-2.52507,7.48087,-0.65234>,<-2.53052,7.47613,-0.64769>,<-2.53047,7.47547,-0.65626>,
            
    /*11*/ <-2.66953,7.69584,-0.71491>

    /* stem 0.6.2.0*/ 
    /*0*/ <-0.90158,6.32388,0.01278>,
    /*1*/ <-0.90448,6.31531,0.03158>,<-0.90517,6.31268,-0.00447>,<-0.89508,6.34366,0.01121>,
            
    /*2*/ <-1.87226,6.64229,0.00805>

    /* stem 0.6.2.1*/ 
    /*0*/ <-1.02445,6.30379,-0.04374>,
    /*1*/ <-1.01519,6.30007,-0.06135>,<-1.03965,6.31714,-0.04291>,<-1.01851,6.29416,-0.02694>,
            
    /*2*/ <-1.67015,5.58022,-0.23042>

    /* stem 0.6.2.2*/ 
    /*0*/ <-1.12159,6.31463,-0.09711>,
    /*1*/ <-1.12632,6.32983,-0.08542>,<-1.13514,6.30094,-0.10148>,<-1.10331,6.31312,-0.10444>,
            
    /*2*/ <-1.38823,6.82396,-0.86702>

    /* stem 0.6.2.3*/ 
    /*0*/ <-1.30311,6.37043,-0.19128>,
    /*1*/ <-1.3093,6.35292,-0.19421>,<-1.30694,6.38397,-0.20375>,<-1.29308,6.3744,-0.17588>,
            
    /*2*/ <-2.06966,6.56659,0.25722>

    /* stem 0.6.2.4*/ 
    /*0*/ <-1.56642,6.52454,-0.29362>,
    /*1*/ <-1.55602,6.53607,-0.30135>,<-1.5806,6.52993,-0.28521>,<-1.56265,6.50763,-0.2943>,
            
    /*2*/ <-2.00892,6.45397,-0.99423>

    /* stem 0.6.2.5*/ 
    /*0*/ <-1.68661,6.61049,-0.33606>,
    /*1*/ <-1.69438,6.60792,-0.32156>,<-1.69483,6.60838,-0.35039>,<-1.67063,6.61515,-0.33623>,
            
    /*2*/ <-1.90913,7.37326,-0.32039>

    /* stem 0.6.2.6*/ 
    /*0*/ <-1.7695,6.67134,-0.3697>,
    /*1*/ <-1.76832,6.66481,-0.38443>,<-1.77116,6.68733,-0.36806>,<-1.76903,6.66189,-0.35661>,
            
    /*2*/ <-2.53396,6.59496,-0.39726>

    /* stem 0.6.2.7*/ 
    /*0*/ <-1.89426,6.78503,-0.43605>,
    /*1*/ <-1.888,6.79599,-0.42734>,<-1.9095,6.78373,-0.43695>,<-1.88526,6.77539,-0.44387>,
            
    /*2*/ <-1.89979,7.23836,-1.0018>

    /* stem 0.6.2.8*/ 
    /*0*/ <-2.06932,6.97776,-0.53754>,
    /*1*/ <-2.0798,6.96842,-0.53709>,<-2.0693,6.98782,-0.54735>,<-2.05887,6.97706,-0.52819>,
            
    /*2*/ <-2.40465,7.37331,-0.13285>

    /* stem 0.6.2.9*/ 
    /*0*/ <-2.25252,7.17973,-0.6079>,
    /*1*/ <-2.2445,7.18473,-0.61616>,<-2.25853,7.18713,-0.59972>,<-2.25453,7.16734,-0.60781>,
            
    /*2*/ <-2.69337,7.24858,-0.9941>

    /* stem 0.6.2.10*/ 
    /*0*/ <-2.3705,7.30924,-0.6382>,
    /*1*/ <-2.37172,7.30885,-0.62903>,<-2.37776,7.30844,-0.64387>,<-2.36201,7.31043,-0.64169>,
            
    /*2*/ <-2.44074,7.85193,-0.62445>

    /* stem 0.6.2.11*/ 
    /*0*/ <-2.47619,7.42166,-0.64748>,
    /*1*/ <-2.47849,7.41905,-0.65284>,<-2.47485,7.4279,-0.64729>,<-2.47523,7.41802,-0.64232>,
            
    /*2*/ <-2.95189,7.51869,-0.49036>

    /* stem 0.6.2.12*/ 
    /*0*/ <-2.58299,7.56168,-0.67632>,
    /*1*/ <-2.5807,7.56344,-0.67534>,<-2.58588,7.56253,-0.67583>,<-2.58239,7.55907,-0.67778>,
            
    /*2*/ <-2.58399,7.78975,-1.08398>

    /* stem 0.6.3*/ 
    /*0*/ <-0.99626,6.38046,0.14764>,
    /*1*/ <-0.98305,6.36585,0.19165>,<-1.02445,6.35241,0.12038>,<-0.98128,6.42312,0.13089>,
            
    /*2*/ <-1.19443,6.4806,0.28789>,<-1.23169,6.4685,0.22375>,<-1.19284,6.53214,0.23321>,
            
    /*3*/ <-1.3861,6.63879,0.37163>,<-1.42039,6.62893,0.31515>,<-1.37679,6.67937,0.31938>,
            
    /*4*/ <-1.54563,6.80129,0.48432>,<-1.58249,6.7977,0.43909>,<-1.54076,6.83863,0.43961>,
            
    /*5*/ <-1.71079,6.95572,0.60781>,<-1.74308,6.95309,0.56958>,<-1.70844,6.98928,0.57069>,
            
    /*6*/ <-1.88059,7.14109,0.68984>,<-1.90384,7.13587,0.65555>,<-1.87294,7.16396,0.65575>,
            
    /*7*/ <-2.03059,7.34154,0.75997>,<-2.04944,7.33769,0.73266>,<-2.02283,7.35787,0.73187>,
            
    /*8*/ <-2.18638,7.54406,0.81088>,<-2.19939,7.53985,0.78988>,<-2.17958,7.55518,0.78948>,
            
    /*9*/ <-2.3265,7.75235,0.87219>,<-2.33586,7.75041,0.8585>,<-2.32209,7.75985,0.85793>,
            
    /*10*/ <-2.49335,7.94669,0.91547>,<-2.4974,7.94497,0.90837>,<-2.49107,7.95042,0.90835>,
            
    /*11*/ <-2.60098,8.17988,0.95026>

    /* stem 0.6.3.0*/ 
    /*0*/ <-1.11589,6.44498,0.20496>,
    /*1*/ <-1.127,6.43858,0.18898>,<-1.11935,6.46346,0.21309>,<-1.10133,6.43289,0.21281>,
            
    /*2*/ <-1.78586,6.0442,0.8309>

    /* stem 0.6.3.1*/ 
    /*0*/ <-1.31716,6.58524,0.29961>,
    /*1*/ <-1.30402,6.59871,0.30396>,<-1.33007,6.57971,0.31286>,<-1.31738,6.5773,0.282>,
            
    /*2*/ <-1.90493,7.25346,0.0056>

    /* stem 0.6.3.2*/ 
    /*0*/ <-1.44371,6.69882,0.3716>,
    /*1*/ <-1.45222,6.68452,0.37967>,<-1.45367,6.71253,0.36422>,<-1.42525,6.6994,0.37092>,
            
    /*2*/ <-1.42832,7.13067,1.15284>

    /* stem 0.6.3.3*/ 
    /*0*/ <-1.53273,6.78874,0.43702>,
    /*1*/ <-1.53367,6.7986,0.42218>,<-1.52852,6.7964,0.45258>,<-1.536,6.7712,0.43631>,
            
    /*2*/ <-2.36462,6.93755,0.58873>

    /* stem 0.6.3.4*/ 
    /*0*/ <-1.60777,6.86058,0.49451>,
    /*1*/ <-1.59807,6.85906,0.50877>,<-1.62481,6.85759,0.49528>,<-1.60044,6.86509,0.47949>,
            
    /*2*/ <-1.74017,7.661,0.67018>

    /* stem 0.6.3.5*/ 
    /*0*/ <-1.80135,7.05439,0.62389>,
    /*1*/ <-1.81329,7.04705,0.61629>,<-1.79971,7.0702,0.62275>,<-1.79106,7.04592,0.63262>,
            
    /*2*/ <-2.24359,7.14387,1.23177>

    /* stem 0.6.3.6*/ 
    /*0*/ <-1.93133,7.20792,0.68988>,
    /*1*/ <-1.92008,7.21738,0.68704>,<-1.93838,7.20841,0.70308>,<-1.93553,7.19796,0.67952>,
            
    /*2*/ <-2.39094,7.67524,0.42714>

    /* stem 0.6.3.7*/ 
    /*0*/ <-2.07336,7.39656,0.7555>,
    /*1*/ <-2.07888,7.38942,0.766>,<-2.08159,7.40292,0.74637>,<-2.0596,7.39732,0.75413>,
            
    /*2*/ <-2.06641,7.93029,1.12168>

    /* stem 0.6.3.8*/ 
    /*0*/ <-2.23997,7.62301,0.82113>,
    /*1*/ <-2.24211,7.62541,0.80905>,<-2.23692,7.63231,0.82891>,<-2.24087,7.6113,0.82543>,
            
    /*2*/ <-2.79953,7.70911,0.93749>

    /* stem 0.6.3.9*/ 
    /*0*/ <-2.27677,7.67776,0.83855>,
    /*1*/ <-2.26922,7.68022,0.84675>,<-2.28796,7.67858,0.84066>,<-2.27313,7.67447,0.82824>,
            
    /*2*/ <-2.26912,8.21359,0.67054>

    /* stem 0.6.3.10*/ 
    /*0*/ <-2.40838,7.84768,0.88603>,
    /*1*/ <-2.414,7.84316,0.8848>,<-2.40881,7.85468,0.88399>,<-2.40234,7.84519,0.88931>,
            
    /*2*/ <-2.60472,7.96824,1.33952>

    /* stem 0.6.3.11*/ 
    /*0*/ <-2.55964,8.09009,0.935>,
    /*1*/ <-2.55829,8.09088,0.934>,<-2.56018,8.09085,0.93661>,<-2.56046,8.08853,0.93439>,
            
    /*2*/ <-2.85781,8.33029,0.72143>

    /* stem 0.6.4*/ 
    /*0*/ <-1.28209,6.36027,0.24634>,
    /*1*/ <-1.29806,6.34229,0.20632>,<-1.29694,6.40214,0.26069>,<-1.25127,6.33637,0.27201>,
            
    /*2*/ <-1.48414,6.23509,0.33418>,<-1.48314,6.28895,0.38311>,<-1.44204,6.22977,0.3933>,
            
    /*3*/ <-1.68836,6.18232,0.47654>,<-1.6774,6.23448,0.51321>,<-1.6515,6.17748,0.52948>,
            
    /*4*/ <-1.90179,6.24138,0.60144>,<-1.87667,6.28648,0.62466>,<-1.87514,6.23647,0.65113>,
            
    /*5*/ <-2.11183,6.3308,0.7018>,<-2.08772,6.36833,0.72088>,<-2.09291,6.32736,0.74634>,
            
    /*6*/ <-2.3112,6.44931,0.7994>,<-2.2875,6.47883,0.81359>,<-2.29549,6.44653,0.83655>,
            
    /*7*/ <-2.48005,6.61811,0.88064>,<-2.45635,6.63812,0.88984>,<-2.46814,6.61636,0.91066>,
            
    /*8*/ <-2.62031,6.80432,0.9777>,<-2.60036,6.81695,0.98325>,<-2.60979,6.80147,0.99937>,
            
    /*9*/ <-2.71301,7.0088,1.09384>,<-2.69808,7.01462,1.09602>,<-2.70481,7.00518,1.1073>,
            
    /*10*/ <-2.79025,7.23788,1.15484>,<-2.78261,7.24035,1.15577>,<-2.78667,7.2373,1.16206>,
            
    /*11*/ <-2.82834,7.47546,1.22501>

    /* stem 0.6.4.0*/ 
    /*0*/ <-1.40702,6.28771,0.32878>,
    /*1*/ <-1.40901,6.30385,0.33996>,<-1.40852,6.26981,0.33694>,<-1.40353,6.28948,0.30945>,
            
    /*2*/ <-2.35141,6.28909,0.15836>

    /* stem 0.6.4.1*/ 
    /*0*/ <-1.56348,6.22668,0.43318>,
    /*1*/ <-1.55745,6.20895,0.43523>,<-1.58186,6.23018,0.431>,<-1.55113,6.24091,0.43331>,
            
    /*2*/ <-1.65662,6.2996,1.33734>

    /* stem 0.6.4.2*/ 
    /*0*/ <-1.72996,6.21347,0.53878>,
    /*1*/ <-1.73511,6.22351,0.52484>,<-1.73265,6.2193,0.55553>,<-1.7221,6.19759,0.53597>,
            
    /*2*/ <-2.50314,5.82945,0.54794>

    /* stem 0.6.4.3*/ 
    /*0*/ <-1.83096,6.24046,0.5956>,
    /*1*/ <-1.82217,6.2419,0.61055>,<-1.84598,6.23167,0.59516>,<-1.82475,6.2478,0.5811>,
            
    /*2*/ <-2.24713,6.94213,0.77264>

    /* stem 0.6.4.4*/ 
    /*0*/ <-2.0233,6.31172,0.68912>,
    /*1*/ <-2.03178,6.30074,0.68041>,<-2.02955,6.32661,0.69185>,<-2.00856,6.3078,0.6951>,
            
    /*2*/ <-2.35839,6.05073,1.34401>

    /* stem 0.6.4.5*/ 
    /*0*/ <-2.19552,6.39889,0.76871>,
    /*1*/ <-2.18854,6.41251,0.76677>,<-2.20174,6.39528,0.78236>,<-2.19628,6.38888,0.75699>,
            
    /*2*/ <-2.82949,6.69384,0.55773>

    /* stem 0.6.4.6*/ 
    /*0*/ <-2.34835,6.50728,0.83933>,
    /*1*/ <-2.35195,6.49849,0.85029>,<-2.35867,6.51279,0.83075>,<-2.33442,6.51057,0.83695>,
            
    /*2*/ <-2.40471,7.04634,1.25324>

    /* stem 0.6.4.7*/ 
    /*0*/ <-2.54814,6.72748,0.94612>,
    /*1*/ <-2.55212,6.7305,0.93408>,<-2.54588,6.73694,0.95481>,<-2.54641,6.71499,0.94948>,
            
    /*2*/ <-3.1249,6.69688,1.12937>

    /* stem 0.6.4.8*/ 
    /*0*/ <-2.64532,6.88223,1.02828>,
    /*1*/ <-2.63533,6.88319,1.03503>,<-2.6562,6.88184,1.03358>,<-2.64445,6.88168,1.01622>,
            
    /*2*/ <-2.6793,7.43806,1.00005>

    /* stem 0.6.4.9*/ 
    /*0*/ <-2.67222,6.93933,1.06002>,
    /*1*/ <-2.68209,6.93455,1.06025>,<-2.67106,6.94929,1.0556>,<-2.66353,6.93414,1.06421>,
            
    /*2*/ <-2.77004,7.16445,1.54171>

    /* stem 0.6.4.10*/ 
    /*0*/ <-2.76228,7.17019,1.1401>,
    /*1*/ <-2.75844,7.17258,1.13607>,<-2.76284,7.17267,1.1456>,<-2.76557,7.16531,1.13863>,
            
    /*2*/ <-3.11036,7.45369,0.97682>

    /* stem 0.6.4.11*/ 
    /*0*/ <-2.80678,7.35334,1.19025>,
    /*1*/ <-2.80685,7.35267,1.19256>,<-2.80862,7.35457,1.1893>,<-2.80488,7.35278,1.18889>,
            
    /*2*/ <-2.61722,7.72328,1.30311>

    /* stem 0.6.5*/ 
    /*0*/ <-1.5124,6.34713,0.34413>,
    /*1*/ <-1.5062,6.38743,0.36414>,<-1.51582,6.30953,0.36937>,<-1.51518,6.34444,0.29887>,
            
    /*2*/ <-1.74692,6.41392,0.37505>,<-1.75558,6.34381,0.37976>,<-1.75499,6.37523,0.31631>,
            
    /*3*/ <-1.93537,6.53994,0.37388>,<-1.97034,6.48784,0.37869>,<-1.95539,6.51057,0.32194>,
            
    /*4*/ <-2.08649,6.71592,0.38744>,<-2.12827,6.68041,0.39254>,<-2.11279,6.69772,0.34261>,
            
    /*5*/ <-2.24752,6.89815,0.39151>,<-2.28321,6.86755,0.3957>,<-2.26876,6.88124,0.3529>,
            
    /*6*/ <-2.39252,7.09028,0.39112>,<-2.42418,7.0672,0.39461>,<-2.41092,7.07713,0.35894>,
            
    /*7*/ <-2.50691,7.30047,0.39276>,<-2.53465,7.2859,0.39564>,<-2.52318,7.29239,0.36707>,
            
    /*8*/ <-2.61396,7.51595,0.4107>,<-2.63509,7.50569,0.41295>,<-2.627,7.51149,0.39155>,
            
    /*9*/ <-2.68907,7.74015,0.4528>,<-2.70387,7.73511,0.45461>,<-2.69874,7.7395,0.4404>,
            
    /*10*/ <-2.7852,7.96414,0.44963>,<-2.79244,7.96118,0.45046>,<-2.78946,7.96235,0.44327>,
            
    /*11*/ <-2.86533,8.19186,0.42923>

    /* stem 0.6.5.0*/ 
    /*0*/ <-1.6727,6.36751,0.35275>,
    /*1*/ <-1.67481,6.34899,0.35733>,<-1.68529,6.37599,0.34101>,<-1.658,6.37755,0.35992>,
            
    /*2*/ <-2.19408,6.6079,1.0852>

    /* stem 0.6.5.1*/ 
    /*0*/ <-1.82349,6.42534,0.35744>,
    /*1*/ <-1.81756,6.4343,0.34244>,<-1.8317,6.43464,0.3711>,<-1.82122,6.40708,0.35878>,
            
    /*2*/ <-2.61485,6.29842,-0.03135>

    /* stem 0.6.5.2*/ 
    /*0*/ <-1.99476,6.5617,0.3624>,
    /*1*/ <-1.99278,6.56186,0.37975>,<-2.0106,6.56389,0.3554>,<-1.98089,6.55934,0.35206>,
            
    /*2*/ <-1.87051,7.38993,0.34047>

    /* stem 0.6.5.3*/ 
    /*0*/ <-2.07323,6.65519,0.37049>,
    /*1*/ <-2.08294,6.64806,0.35863>,<-2.06896,6.6715,0.36924>,<-2.06779,6.646,0.3836>,
            
    /*2*/ <-2.73412,6.86051,0.78837>

    /* stem 0.6.5.4*/ 
    /*0*/ <-2.18679,6.78894,0.37708>,
    /*1*/ <-2.17456,6.79934,0.37845>,<-2.19925,6.78976,0.38726>,<-2.18657,6.77772,0.36552>,
            
    /*2*/ <-2.54371,7.27193,-0.09886>

    /* stem 0.6.5.5*/ 
    /*0*/ <-2.34313,6.98751,0.38085>,
    /*1*/ <-2.35299,6.98026,0.38945>,<-2.34781,6.99491,0.36872>,<-2.3286,6.98736,0.38438>,
            
    /*2*/ <-2.43168,7.56944,0.76988>

    /* stem 0.6.5.6*/ 
    /*0*/ <-2.48903,7.23073,0.38412>,
    /*1*/ <-2.48604,7.23251,0.37092>,<-2.48576,7.24036,0.39322>,<-2.49528,7.21931,0.38821>,
            
    /*2*/ <-3.05543,7.50848,0.29347>

    /* stem 0.6.5.7*/ 
    /*0*/ <-2.56697,7.38834,0.39387>,
    /*1*/ <-2.56158,7.38985,0.40541>,<-2.57883,7.39273,0.3917>,<-2.5605,7.38243,0.38449>,
            
    /*2*/ <-2.34159,7.91092,0.2202>

    /* stem 0.6.5.8*/ 
    /*0*/ <-2.63479,7.54089,0.41087>,
    /*1*/ <-2.64561,7.53838,0.40619>,<-2.62932,7.55127,0.40816>,<-2.62946,7.53302,0.41827>,
            
    /*2*/ <-2.87932,7.7836,0.84556>

    /* stem 0.6.5.9*/ 
    /*0*/ <-2.67505,7.66815,0.43563>,
    /*1*/ <-2.66564,7.6717,0.43267>,<-2.68013,7.67276,0.44356>,<-2.67937,7.65999,0.43067>,
            
    /*2*/ <-2.90446,7.9944,0.09874>

    /* stem 0.6.5.10*/ 
    /*0*/ <-2.724,7.80368,0.44884>,
    /*1*/ <-2.72803,7.80207,0.45527>,<-2.72753,7.80701,0.44279>,<-2.71645,7.80196,0.44846>,
            
    /*2*/ <-2.61458,8.24363,0.62718>

    /* stem 0.6.5.11*/ 
    /*0*/ <-2.82934,8.08371,0.43798>,
    /*1*/ <-2.8295,8.08349,0.43586>,<-2.82859,8.08553,0.43882>,<-2.82995,8.08211,0.43928>,
            
    /*2*/ <-3.2145,8.23841,0.44967>

    /* stem 0.6.6*/ 
    /*0*/ <-1.98974,6.32283,0.53654>,
    /*1*/ <-1.9846,6.28111,0.54458>,<-2.02248,6.33609,0.51235>,<-1.96215,6.3513,0.55268>,
            
    /*2*/ <-2.11417,6.30514,0.72935>,<-2.14825,6.35463,0.70035>,<-2.09396,6.36831,0.73664>,
            
    /*3*/ <-2.21259,6.42677,0.91392>,<-2.23623,6.46583,0.87607>,<-2.1821,6.47522,0.89842>,
            
    /*4*/ <-2.30215,6.56782,1.07343>,<-2.32069,6.59916,1.03645>,<-2.27327,6.60723,1.05593>,
            
    /*5*/ <-2.38458,6.72633,1.21825>,<-2.39914,6.75091,1.18416>,<-2.35823,6.75738,1.20037>,
            
    /*6*/ <-2.45121,6.88507,1.36618>,<-2.46397,6.90628,1.33859>,<-2.429,6.91012,1.35026>,
            
    /*7*/ <-2.50499,7.06359,1.49978>,<-2.51464,7.07888,1.47627>,<-2.48631,7.08106,1.48476>,
            
    /*8*/ <-2.55576,7.25335,1.61645>,<-2.56257,7.26341,1.59782>,<-2.54136,7.26512,1.60427>,
            
    /*9*/ <-2.5856,7.45591,1.71743>,<-2.59002,7.46192,1.70461>,<-2.57567,7.46216,1.70836>,
            
    /*10*/ <-2.62298,7.65971,1.81053>,<-2.62513,7.66244,1.80398>,<-2.61801,7.66283,1.80599>,
            
    /*11*/ <-2.66371,7.86778,1.89207>

    /* stem 0.6.6.0*/ 
    /*0*/ <-2.07084,6.33531,0.65315>,
    /*1*/ <-2.08199,6.34646,0.64421>,<-2.06424,6.34016,0.66932>,<-2.06629,6.31932,0.64593>,
            
    /*2*/ <-2.75712,5.96324,1.04482>

    /* stem 0.6.6.1*/ 
    /*0*/ <-2.18177,6.42062,0.84186>,
    /*1*/ <-2.16665,6.42076,0.84973>,<-2.19589,6.41686,0.85062>,<-2.18276,6.42425,0.82524>,
            
    /*2*/ <-2.2815,7.21035,1.02>

    /* stem 0.6.6.2*/ 
    /*0*/ <-2.24048,6.50218,0.95046>,
    /*1*/ <-2.25438,6.49354,0.9501>,<-2.24098,6.51839,0.95271>,<-2.22608,6.49462,0.94857>,
            
    /*2*/ <-2.19473,6.39659,1.72204>

    /* stem 0.6.6.3*/ 
    /*0*/ <-2.33119,6.65225,1.11302>,
    /*1*/ <-2.32418,6.66338,1.10523>,<-2.32968,6.65143,1.12821>,<-2.33971,6.64194,1.10562>,
            
    /*2*/ <-2.91214,7.07442,1.19368>

    /* stem 0.6.6.4*/ 
    /*0*/ <-2.39795,6.78482,1.23962>,
    /*1*/ <-2.3953,6.77559,1.25034>,<-2.41043,6.79198,1.23922>,<-2.38813,6.78689,1.22931>,
            
    /*2*/ <-2.12294,7.28457,1.60202>

    /* stem 0.6.6.5*/ 
    /*0*/ <-2.43063,6.86026,1.3127>,
    /*1*/ <-2.44095,6.86401,1.30421>,<-2.42247,6.86993,1.31841>,<-2.42847,6.84683,1.31549>,
            
    /*2*/ <-2.8335,6.90093,1.82042>

    /* stem 0.6.6.6*/ 
    /*0*/ <-2.46392,6.95166,1.39146>,
    /*1*/ <-2.451,6.9541,1.39347>,<-2.47213,6.9503,1.40183>,<-2.46863,6.95059,1.37906>,
            
    /*2*/ <-2.57715,7.56047,1.3819>

    /* stem 0.6.6.7*/ 
    /*0*/ <-2.53502,7.19449,1.56381>,
    /*1*/ <-2.54409,7.18875,1.56887>,<-2.53656,7.20548,1.55959>,<-2.5244,7.18925,1.56297>,
            
    /*2*/ <-2.3947,7.40076,2.04922>

    /* stem 0.6.6.8*/ 
    /*0*/ <-2.56936,7.36596,1.6611>,
    /*1*/ <-2.56709,7.37101,1.65209>,<-2.56423,7.36847,1.67001>,<-2.57677,7.35841,1.66121>,
            
    /*2*/ <-2.91605,7.70751,1.76503>

    /* stem 0.6.6.9*/ 
    /*0*/ <-2.60747,7.58489,1.77002>,
    /*1*/ <-2.60481,7.58303,1.77496>,<-2.61226,7.58833,1.77036>,<-2.60533,7.58332,1.76474>,
            
    /*2*/ <-2.35238,7.94122,1.76722>

    /* stem 0.6.6.10*/ 
    /*0*/ <-2.64427,7.77159,1.85229>,
    /*1*/ <-2.64607,7.77159,1.85143>,<-2.6432,7.77328,1.85237>,<-2.64353,7.76991,1.85308>,
            
    /*2*/ <-2.80807,7.85992,2.19328>

    /* stem 0.6.7*/ 
    /*0*/ <-2.54192,6.32676,0.72062>,
    /*1*/ <-2.54985,6.35086,0.68993>,<-2.54788,6.33939,0.75791>,<-2.52802,6.29003,0.71402>,
            
    /*2*/ <-2.7452,6.27542,0.68634>,<-2.74343,6.2651,0.74753>,<-2.72555,6.22068,0.70802>,
            
    /*3*/ <-2.9451,6.27935,0.67732>,<-2.94859,6.26909,0.73142>,<-2.94739,6.22728,0.69543>,
            
    /*4*/ <-3.13496,6.34609,0.66077>,<-3.14279,6.3377,0.70766>,<-3.15183,6.3032,0.67513>,
            
    /*5*/ <-3.30781,6.4578,0.65415>,<-3.31463,6.45088,0.69438>,<-3.33017,6.42506,0.66602>,
            
    /*6*/ <-3.46057,6.59761,0.65228>,<-3.46667,6.59223,0.6858>,<-3.48337,6.57364,0.66204>,
            
    /*7*/ <-3.60177,6.74958,0.69175>,<-3.60303,6.7421,0.71828>,<-3.62032,6.73087,0.69994>,
            
    /*8*/ <-3.71428,6.91954,0.73241>,<-3.71551,6.91436,0.7524>,<-3.73002,6.90792,0.73914>,
            
    /*9*/ <-3.81619,7.10007,0.74309>,<-3.81813,7.09842,0.75665>,<-3.8275,7.09367,0.74771>,
            
    /*10*/ <-3.90513,7.28901,0.74817>,<-3.90623,7.28844,0.75496>,<-3.91103,7.2863,0.75049>,
            
    /*11*/ <-3.99816,7.47606,0.73626>

    /* stem 0.6.7.0*/ 
    /*0*/ <-2.68206,6.27458,0.71586>,
    /*1*/ <-2.6826,6.27452,0.73264>,<-2.68812,6.26154,0.70722>,<-2.67545,6.28769,0.70773>,
            
    /*2*/ <-3.40318,6.62418,0.69368>

    /* stem 0.6.7.1*/ 
    /*0*/ <-2.82014,6.25564,0.70903>,
    /*1*/ <-2.81962,6.24542,0.69654>,<-2.82947,6.26878,0.70832>,<-2.81132,6.25271,0.72222>,
            
    /*2*/ <-3.40327,5.8578,1.01053>

    /* stem 0.6.7.2*/ 
    /*0*/ <-3.07216,6.3035,0.6885>,
    /*1*/ <-3.06753,6.31733,0.69175>,<-3.08498,6.29837,0.69423>,<-3.06398,6.29479,0.67953>,
            
    /*2*/ <-3.4216,6.55188,0.1288>

    /* stem 0.6.7.3*/ 
    /*0*/ <-3.24413,6.39591,0.67559>,
    /*1*/ <-3.2513,6.38561,0.68189>,<-3.25017,6.40347,0.66541>,<-3.23091,6.39864,0.67946>,
            
    /*2*/ <-3.46416,6.82365,1.12419>

    /* stem 0.6.7.4*/ 
    /*0*/ <-3.3773,6.50065,0.66963>,
    /*1*/ <-3.37347,6.50433,0.65748>,<-3.38167,6.50974,0.67823>,<-3.37676,6.48789,0.67318>,
            
    /*2*/ <-3.95295,6.41893,0.46341>

    /* stem 0.6.7.5*/ 
    /*0*/ <-3.57092,6.69937,0.6934>,
    /*1*/ <-3.56691,6.7003,0.70461>,<-3.58256,6.69768,0.69133>,<-3.56328,6.70012,0.68424>,
            
    /*2*/ <-3.64668,7.24351,0.67517>

    /* stem 0.6.7.6*/ 
    /*0*/ <-3.68944,6.86662,0.73093>,
    /*1*/ <-3.69791,6.86237,0.72543>,<-3.68594,6.87675,0.72863>,<-3.68446,6.86075,0.73874>,
            
    /*2*/ <-4.00394,7.05278,1.0715>

    /* stem 0.6.7.7*/ 
    /*0*/ <-3.74866,6.96628,0.74355>,
    /*1*/ <-3.7397,6.97128,0.74182>,<-3.7546,6.96892,0.75168>,<-3.75169,6.95866,0.73715>,
            
    /*2*/ <-3.9757,7.2811,0.47591>

    /* stem 0.6.7.8*/ 
    /*0*/ <-3.87141,7.20884,0.75035>,
    /*1*/ <-3.87472,7.20729,0.75465>,<-3.87353,7.21194,0.74615>,<-3.866,7.2073,0.75026>,
            
    /*2*/ <-3.77149,7.54831,0.94971>

    /* stem 0.6.7.9*/ 
    /*0*/ <-3.93578,7.34665,0.74654>,
    /*1*/ <-3.93568,7.34648,0.74381>,<-3.93512,7.349,0.74779>,<-3.93653,7.34447,0.74802>,
            
    /*2*/ <-4.28836,7.45575,0.72672>

    /* stem 0.6.8*/ 
    /*0*/ <-2.93124,6.35092,0.82531>,
    /*1*/ <-2.92246,6.35286,0.86196>,<-2.94862,6.32032,0.81167>,<-2.92264,6.37957,0.8023>,
            
    /*2*/ <-3.09845,6.43539,0.89586>,<-3.12199,6.4061,0.85059>,<-3.09861,6.45942,0.84216>,
            
    /*3*/ <-3.26682,6.54595,0.90112>,<-3.28628,6.51992,0.86016>,<-3.25784,6.56314,0.85256>,
            
    /*4*/ <-3.41504,6.66594,0.93091>,<-3.43817,6.64699,0.89628>,<-3.41084,6.68288,0.88862>,
            
    /*5*/ <-3.54802,6.79598,0.98463>,<-3.57249,6.78332,0.95673>,<-3.54732,6.81239,0.94902>,
            
    /*6*/ <-3.65216,6.96346,1.0123>,<-3.67369,6.9545,0.98941>,<-3.64744,6.97212,0.98115>,
            
    /*7*/ <-3.74716,7.13003,1.05236>,<-3.76539,7.12444,1.03447>,<-3.7442,7.13817,1.02769>,
            
    /*8*/ <-3.82244,7.29272,1.1272>,<-3.8378,7.29154,1.11508>,<-3.82178,7.30146,1.10966>,
            
    /*9*/ <-3.8997,7.46025,1.198>,<-3.90985,7.45927,1.18982>,<-3.89911,7.46577,1.18616>,
            
    /*10*/ <-3.95676,7.63776,1.26243>,<-3.96198,7.63762,1.25849>,<-3.95636,7.6402,1.25638>,
            
    /*11*/ <-3.98985,7.81454,1.34244>

    /* stem 0.6.8.0*/ 
    /*0*/ <-3.03871,6.40169,0.84836>,
    /*1*/ <-3.04565,6.39174,0.83794>,<-3.04373,6.41683,0.84952>,<-3.02675,6.3965,0.85763>,
            
    /*2*/ <-3.54069,6.19449,1.38008>

    /* stem 0.6.8.1*/ 
    /*0*/ <-3.15221,6.46423,0.86522>,
    /*1*/ <-3.14366,6.47702,0.86566>,<-3.16489,6.46315,0.87389>,<-3.14809,6.45252,0.85612>,
            
    /*2*/ <-3.54727,6.74709,0.32243>

    /* stem 0.6.8.2*/ 
    /*0*/ <-3.31324,6.57776,0.88094>,
    /*1*/ <-3.31901,6.5681,0.89007>,<-3.32133,6.58342,0.87034>,<-3.29939,6.58175,0.88241>,
            
    /*2*/ <-3.50287,7.08331,1.29583>

    /* stem 0.6.8.3*/ 
    /*0*/ <-3.4953,6.73777,0.93724>,
    /*1*/ <-3.49676,6.74185,0.92463>,<-3.49384,6.74673,0.94701>,<-3.49529,6.72474,0.94008>,
            
    /*2*/ <-4.11137,6.75424,1.01386>

    /* stem 0.6.8.4*/ 
    /*0*/ <-3.5871,6.84806,0.97289>,
    /*1*/ <-3.58009,6.85045,0.98314>,<-3.59959,6.84994,0.9732>,<-3.5816,6.84379,0.96234>,
            
    /*2*/ <-3.50869,7.39869,0.79084>

    /* stem 0.6.8.5*/ 
    /*0*/ <-3.7284,7.0886,1.0271>,
    /*1*/ <-3.73824,7.08377,1.02432>,<-3.7253,7.09832,1.02222>,<-3.72166,7.0837,1.03474>,
            
    /*2*/ <-3.964,7.35263,1.40397>

    /* stem 0.6.8.6*/ 
    /*0*/ <-3.77263,7.17549,1.05965>,
    /*1*/ <-3.76474,7.1813,1.05507>,<-3.77547,7.17737,1.06992>,<-3.77769,7.1678,1.05397>,
            
    /*2*/ <-4.10429,7.50582,0.90763>

    /* stem 0.6.8.7*/ 
    /*0*/ <-3.88167,7.415,1.17054>,
    /*1*/ <-3.88343,7.41093,1.17792>,<-3.88758,7.42013,1.16695>,<-3.87401,7.41395,1.16677>,
            
    /*2*/ <-3.72887,7.74428,1.38891>

    /* stem 0.6.8.8*/ 
    /*0*/ <-3.92439,7.53025,1.21759>,
    /*1*/ <-3.92698,7.53149,1.21222>,<-3.92058,7.53426,1.22013>,<-3.9256,7.525,1.22041>,
            
    /*2*/ <-4.226,7.69915,1.40239>

    /* stem 0.6.8.9*/ 
    /*0*/ <-3.96818,7.6934,1.28508>,
    /*1*/ <-3.96581,7.69332,1.28614>,<-3.97017,7.69441,1.28642>,<-3.96857,7.69247,1.28268>,
            
    /*2*/ <-3.89859,8.00771,1.15232>

    /* stem 0.6.9*/ 
    /*0*/ <-3.63996,6.40399,0.9735>,
    /*1*/ <-3.64561,6.38076,0.94938>,<-3.65657,6.43361,0.97277>,<-3.6177,6.39761,0.99834>,
            
    /*2*/ <-3.77349,6.31344,1.04896>,<-3.78335,6.36101,1.07002>,<-3.74837,6.3286,1.09303>,
            
    /*3*/ <-3.90959,6.31069,1.17572>,<-3.90471,6.35705,1.18217>,<-3.88003,6.32689,1.20855>,
            
    /*4*/ <-4.0503,6.38709,1.2603>,<-4.03254,6.42413,1.25746>,<-4.02567,6.40048,1.29046>,
            
    /*5*/ <-4.17362,6.48881,1.34083>,<-4.154,6.51767,1.33557>,<-4.15019,6.4989,1.36522>,
            
    /*6*/ <-4.27035,6.5997,1.44288>,<-4.25231,6.62203,1.43645>,<-4.247,6.60512,1.45993>,
            
    /*7*/ <-4.35274,6.72883,1.53215>,<-4.33658,6.74446,1.52521>,<-4.33356,6.73253,1.54527>,
            
    /*8*/ <-4.39633,6.88768,1.60205>,<-4.38226,6.89514,1.59446>,<-4.38097,6.88838,1.61071>,
            
    /*9*/ <-4.44532,7.04359,1.66494>,<-4.43599,7.04875,1.65997>,<-4.43525,7.04456,1.67093>,
            
    /*10*/ <-4.48895,7.21311,1.68088>,<-4.48399,7.21474,1.67818>,<-4.4841,7.21417,1.68403>,
            
    /*11*/ <-4.52994,7.38285,1.69902>

    /* stem 0.6.9.0*/ 
    /*0*/ <-3.69824,6.37239,1.01759>,
    /*1*/ <-3.70256,6.38572,1.02143>,<-3.69879,6.36153,1.02721>,<-3.69337,6.36994,1.00413>,
            
    /*2*/ <-4.33337,6.22515,0.81484>

    /* stem 0.6.9.1*/ 
    /*0*/ <-3.83271,6.33296,1.12924>,
    /*1*/ <-3.82665,6.3225,1.13565>,<-3.84571,6.33185,1.12513>,<-3.82577,6.34453,1.12695>,
            
    /*2*/ <-4.03042,6.5629,1.69158>

    /* stem 0.6.9.2*/ 
    /*0*/ <-3.99014,6.37978,1.24254>,
    /*1*/ <-3.99576,6.38161,1.23127>,<-3.98876,6.38951,1.25062>,<-3.9859,6.36821,1.24573>,
            
    /*2*/ <-4.51358,6.25437,1.48314>

    /* stem 0.6.9.3*/ 
    /*0*/ <-4.07506,6.43483,1.29399>,
    /*1*/ <-4.06654,6.43991,1.30108>,<-4.08527,6.43038,1.29896>,<-4.07338,6.43419,1.28193>,
            
    /*2*/ <-4.32298,6.93574,1.23289>

    /* stem 0.6.9.4*/ 
    /*0*/ <-4.21807,6.56656,1.40718>,
    /*1*/ <-4.22588,6.55868,1.40803>,<-4.221,6.5771,1.40512>,<-4.20733,6.5639,1.40837>,
            
    /*2*/ <-4.25184,6.6543,1.90638>

    /* stem 0.6.9.5*/ 
    /*0*/ <-4.37265,6.84318,1.58165>,
    /*1*/ <-4.36873,6.84754,1.57433>,<-4.37048,6.84579,1.59038>,<-4.37875,6.8362,1.58022>,
            
    /*2*/ <-4.68853,7.11982,1.57735>

    /* stem 0.6.9.6*/ 
    /*0*/ <-4.40578,6.94752,1.62554>,
    /*1*/ <-4.40377,6.94489,1.6337>,<-4.41313,6.95214,1.62408>,<-4.40043,6.94553,1.61883>,
            
    /*2*/ <-4.20826,7.28052,1.68425>

    /* stem 0.6.9.7*/ 
    /*0*/ <-4.47072,7.1602,1.676>,
    /*1*/ <-4.47397,7.15958,1.67298>,<-4.46778,7.16355,1.67547>,<-4.4704,7.15748,1.67954>,
            
    /*2*/ <-4.67223,7.36461,1.85128>

    /* stem 0.6.9.8*/ 
    /*0*/ <-4.50596,7.29137,1.68927>,
    /*1*/ <-4.50418,7.29183,1.68935>,<-4.50716,7.29212,1.69046>,<-4.50655,7.29017,1.68801>,
            
    /*2*/ <-4.55625,7.51936,1.49524>

    /* stem 0.7*/ 
    /*0*/ <-0.02949,6.93679,-0.0938>,
    /*1*/ <0.0508,6.94329,-0.0266>,<-0.00908,7.03837,-0.07741>,<-0.09716,6.99307,-0.15088>,
            <-0.09172,6.86999,-0.14547>,<-0.00028,6.83922,-0.06866>,
    /*2*/ <0.43767,6.93943,-0.50396>,<0.38348,7.02549,-0.54994>,<0.30377,6.98449,-0.61643>,
            <0.30869,6.8731,-0.61154>,<0.39145,6.84525,-0.54203>,
    /*3*/ <0.78378,6.95441,-1.02181>,<0.73019,7.03124,-1.05649>,<0.65435,6.99433,-1.11001>,
            <0.66107,6.89467,-1.1084>,<0.74106,6.87,-1.05389>,
    /*4*/ <1.16445,7.02469,-1.48788>,<1.11671,7.09255,-1.51773>,<1.05627,7.06088,-1.57358>,
            <1.06665,6.97344,-1.57824>,<1.13351,6.95107,-1.52528>,
    /*5*/ <1.55922,7.16313,-1.93318>,<1.51479,7.2212,-1.95553>,<1.46624,7.19482,-2.00838>,
            <1.48066,7.12045,-2.01869>,<1.53813,7.10086,-1.97222>,
    /*6*/ <1.93434,7.38328,-2.36766>,<1.89195,7.43027,-2.38132>,<1.85242,7.40865,-2.42782>,
            <1.87038,7.3483,-2.44289>,<1.92102,7.33262,-2.40571>,
    /*7*/ <2.30063,7.67947,-2.75842>,<2.26315,7.71608,-2.76661>,<2.23351,7.70029,-2.80764>,
            <2.25266,7.65392,-2.82482>,<2.29415,7.64106,-2.7944>,
    /*8*/ <2.63304,7.99283,-3.17382>,<2.60227,8.02001,-3.17851>,<2.57793,8.00657,-3.20907>,
            <2.59364,7.9711,-3.22325>,<2.6277,7.9626,-3.20147>,
    /*9*/ <2.98376,8.34676,-3.52775>,<2.96157,8.36609,-3.5309>,<2.94601,8.35834,-3.55485>,
            <2.95858,8.33421,-3.56651>,<2.98192,8.32706,-3.54976>,
    /*10*/ <3.25147,8.74009,-3.9221>,<3.23666,8.7501,-3.92242>,<3.2263,8.74422,-3.93575>,
            <3.23471,8.73056,-3.94367>,<3.25026,8.72801,-3.93523>,
    /*11*/ <3.52395,9.17169,-4.26233>,<3.51877,9.17503,-4.26234>,<3.51544,9.17338,-4.26727>,
            <3.51857,9.16902,-4.2703>,<3.52382,9.16797,-4.26725>,
    /*12*/ <3.52011,9.17142,-4.2659>

    /* stem 0.7c0*/ 
    /*0*/ <1.10752,7.02052,-1.53654>,
    /*1*/ <1.17553,7.02382,-1.50509>,<1.12223,7.09233,-1.52062>,<1.0486,7.0616,-1.55815>,
            <1.05639,6.97411,-1.56582>,<1.13484,6.95076,-1.53303>,
    /*2*/ <1.41977,7.09461,-2.06447>,<1.37355,7.15401,-2.07793>,<1.3097,7.12737,-2.11048>,
            <1.31645,7.0515,-2.11713>,<1.38448,7.03125,-2.08869>,
    /*3*/ <1.66924,7.20922,-2.61285>,<1.62884,7.25907,-2.6215>,<1.57583,7.23692,-2.65136>,
            <1.58347,7.17338,-2.66116>,<1.6412,7.15626,-2.63736>,
    /*4*/ <1.90793,7.32647,-3.16802>,<1.87448,7.36713,-3.17437>,<1.83069,7.34879,-3.19798>,
            <1.83706,7.29679,-3.20622>,<1.8848,7.283,-3.1877>,
    /*5*/ <2.14847,7.5003,-3.70507>,<2.12133,7.53134,-3.70763>,<2.088,7.51753,-3.72775>,
            <2.09454,7.47796,-3.73763>,<2.13191,7.4673,-3.72361>,
    /*6*/ <2.38954,7.74213,-4.21488>,<2.36914,7.76357,-4.21469>,<2.34597,7.75429,-4.2306>,
            <2.35205,7.72711,-4.24062>,<2.37898,7.71959,-4.2309>,
    /*7*/ <2.62995,8.00593,-4.71482>,<2.61743,8.01868,-4.71432>,<2.60357,8.01322,-4.72421>,
            <2.60752,7.99708,-4.73082>,<2.62383,7.99257,-4.72502>,
    /*8*/ <2.79358,8.31578,-5.22168>,<2.78896,8.31977,-5.2208>,<2.78401,8.31764,-5.22381>,
            <2.78558,8.31234,-5.22655>,<2.79149,8.31119,-5.22523>,
    /*9*/ <2.78873,8.31534,-5.22361>

    /* stem 0.7c0c0*/ 
    /*0*/ <2.36714,7.74134,-4.22634>,
    /*1*/ <2.39224,7.74195,-4.22451>,<2.37374,7.76393,-4.2174>,<2.34611,7.75469,-4.22263>,
            <2.34754,7.727,-4.23299>,<2.37605,7.71913,-4.23415>,
    /*2*/ <2.41869,7.95819,-4.79906>,<2.40752,7.97147,-4.79476>,<2.39083,7.96588,-4.79792>,
            <2.39169,7.94916,-4.80418>,<2.40891,7.9444,-4.80488>,
    /*3*/ <2.40265,8.20972,-5.36055>,<2.39877,8.21408,-5.35855>,<2.39302,8.21205,-5.3594>,
            <2.39333,8.20644,-5.36192>,<2.39928,8.205,-5.36263>,
    /*4*/ <2.39741,8.20946,-5.36061>

    /* stem 0.7c0c0.0*/ 
    /*0*/ <2.38631,7.85542,-4.52872>,
    /*1*/ <2.38192,7.87369,-4.52211>,<2.37587,7.84747,-4.54372>,<2.40115,7.84509,-4.52034>,
            
    /*2*/ <2.49395,7.9399,-4.63654>,<2.48851,7.9163,-4.65599>,<2.51126,7.91416,-4.63496>,
            
    /*3*/ <2.59777,8.01532,-4.75144>,<2.59338,7.99474,-4.76932>,<2.61433,7.99323,-4.75139>,
            
    /*4*/ <2.67896,8.12602,-4.85047>,<2.67758,8.11067,-4.86908>,<2.69663,8.10997,-4.85424>,
            
    /*5*/ <2.76183,8.24867,-4.93826>,<2.76168,8.23688,-4.95527>,<2.77751,8.23568,-4.94199>,
            
    /*6*/ <2.82791,8.38962,-5.00963>,<2.8288,8.38165,-5.02491>,<2.84215,8.38092,-5.014>,
            
    /*7*/ <2.87924,8.54637,-5.05622>,<2.88077,8.54213,-5.06927>,<2.89136,8.54129,-5.06045>,
            
    /*8*/ <2.90978,8.70919,-5.10506>,<2.91093,8.70613,-5.11488>,<2.91913,8.70649,-5.10857>,
            
    /*9*/ <2.93642,8.87357,-5.15252>,<2.93721,8.87162,-5.1591>,<2.94269,8.87194,-5.15491>,
            
    /*10*/ <2.94775,9.04156,-5.19194>,<2.94816,9.04078,-5.19527>,<2.95092,9.04108,-5.19322>,
            
    /*11*/ <2.98947,9.20806,-5.21633>

    /* stem 0.7c0c0.0.0*/ 
    /*0*/ <2.44282,7.88987,-4.58634>,
    /*1*/ <2.44026,7.88428,-4.5922>,<2.45105,7.89188,-4.58569>,<2.43715,7.89346,-4.58112>,
            
    /*2*/ <2.35499,8.39064,-5.02587>

    /* stem 0.7c0c0.0.1*/ 
    /*0*/ <2.56791,7.97576,-4.71989>,
    /*1*/ <2.57349,7.97656,-4.7143>,<2.56562,7.98206,-4.72415>,<2.56462,7.96866,-4.72122>,
            
    /*2*/ <3.00911,7.85058,-5.14232>

    /* stem 0.7c0c0.0.2*/ 
    /*0*/ <2.74393,8.20553,-4.9208>,
    /*1*/ <2.73781,8.20829,-4.92266>,<2.74906,8.20499,-4.92548>,<2.74492,8.20333,-4.91428>,
            
    /*2*/ <2.92202,8.69447,-4.78265>

    /* stem 0.7c0c0.0.3*/ 
    /*0*/ <2.80005,8.31239,-4.98075>,
    /*1*/ <2.80492,8.30884,-4.9834>,<2.80143,8.31772,-4.97716>,<2.79379,8.3106,-4.9817>,
            
    /*2*/ <2.78146,8.59815,-5.39784>

    /* stem 0.7c0c0.0.4*/ 
    /*0*/ <2.84923,8.43503,-5.03084>,
    /*1*/ <2.84753,8.43717,-5.0253>,<2.84765,8.43812,-5.03596>,<2.85249,8.4298,-5.03128>,
            
    /*2*/ <3.24985,8.68292,-5.00407>

    /* stem 0.7c0c0.0.5*/ 
    /*0*/ <2.89626,8.61259,-5.08207>,
    /*1*/ <2.89404,8.61152,-5.08714>,<2.901,8.6156,-5.08164>,<2.89372,8.61066,-5.07742>,
            
    /*2*/ <2.66719,8.97098,-5.05785>

    /* stem 0.7c0c0.0.6*/ 
    /*0*/ <2.94604,8.99289,-5.18262>,
    /*1*/ <2.94832,8.99302,-5.18147>,<2.94422,8.99462,-5.18207>,<2.94557,8.99105,-5.18434>,
            
    /*2*/ <3.058,9.1891,-5.42418>

    /* stem 0.7c0c0.0.7*/ 
    /*0*/ <2.96024,9.08765,-5.19984>,
    /*1*/ <2.95887,9.08802,-5.19958>,<2.96093,9.08821,-5.20097>,<2.96091,9.08672,-5.19898>,
            
    /*2*/ <3.05633,9.32106,-5.02466>

    /* stem 0.7c0.0*/ 
    /*0*/ <1.18025,7.04098,-1.69597>,
    /*1*/ <1.18395,7.0927,-1.68765>,<1.14676,7.0225,-1.73197>,<1.21004,7.00773,-1.6683>,
            
    /*2*/ <1.38722,7.10489,-1.88687>,<1.35375,7.04171,-1.92675>,<1.4107,7.02841,-1.86946>,
            
    /*3*/ <1.58332,7.14981,-2.08078>,<1.55819,7.09437,-2.12066>,<1.61001,7.08284,-2.07088>,
            
    /*4*/ <1.72314,7.30487,-2.24797>,<1.71227,7.26403,-2.2956>,<1.76373,7.257,-2.25875>,
            
    /*5*/ <1.86524,7.50585,-2.37464>,<1.86266,7.47884,-2.42201>,<1.90463,7.47054,-2.38811>,
            
    /*6*/ <2.00143,7.72193,-2.49673>,<2.00024,7.70086,-2.53702>,<2.03551,7.69443,-2.50904>,
            
    /*7*/ <2.1293,7.94178,-2.62465>,<2.1281,7.92459,-2.65669>,<2.15695,7.92048,-2.63491>,
            
    /*8*/ <2.20094,8.19892,-2.70617>,<2.2019,8.19082,-2.73221>,<2.2243,8.18948,-2.71668>,
            
    /*9*/ <2.32059,8.45253,-2.75677>,<2.32188,8.44871,-2.77451>,<2.33556,8.4445,-2.76328>,
            
    /*10*/ <2.38085,8.72398,-2.81284>,<2.3815,8.72215,-2.82173>,<2.38887,8.72161,-2.81642>,
            
    /*11*/ <2.4182,9.00434,-2.84042>

    /* stem 0.7c0.0.0*/ 
    /*0*/ <1.31235,7.05224,-1.82467>,
    /*1*/ <1.30122,7.0378,-1.83736>,<1.33449,7.051,-1.82323>,<1.30135,7.06792,-1.81342>,
            
    /*2*/ <1.40587,7.73082,-2.67892>

    /* stem 0.7c0.0.1*/ 
    /*0*/ <1.49721,7.08705,-2.00568>,
    /*1*/ <1.51194,7.08732,-1.99062>,<1.49846,7.10047,-2.02187>,<1.48123,7.07337,-2.00455>,
            
    /*2*/ <2.05149,6.39595,-2.53541>

    /* stem 0.7c0.0.2*/ 
    /*0*/ <1.63454,7.16552,-2.15081>,
    /*1*/ <1.61778,7.17552,-2.15556>,<1.64819,7.16148,-2.16499>,<1.63766,7.15955,-2.13188>,
            
    /*2*/ <2.08551,8.01321,-1.9579>

    /* stem 0.7c0.0.3*/ 
    /*0*/ <1.80677,7.38236,-2.3325>,
    /*1*/ <1.81847,7.36986,-2.3398>,<1.81336,7.39828,-2.32546>,<1.78848,7.37893,-2.33224>,
            
    /*2*/ <1.72199,7.7735,-3.13789>

    /* stem 0.7c0.0.4*/ 
    /*0*/ <1.92738,7.56666,-2.43904>,
    /*1*/ <1.92515,7.57596,-2.42437>,<1.92408,7.57396,-2.45462>,<1.9329,7.55007,-2.43814>,
            
    /*2*/ <2.72458,7.82936,-2.48463>

    /* stem 0.7c0.0.5*/ 
    /*0*/ <1.97001,7.6364,-2.47676>,
    /*1*/ <1.96209,7.63322,-2.49159>,<1.987,7.63831,-2.47638>,<1.96093,7.63767,-2.46232>,
            
    /*2*/ <1.88235,8.44095,-2.60238>

    /* stem 0.7c0.0.6*/ 
    /*0*/ <2.09381,7.85029,-2.59488>,
    /*1*/ <2.10736,7.84684,-2.58738>,<2.08961,7.86543,-2.59713>,<2.08446,7.8386,-2.60014>,
            
    /*2*/ <2.45942,7.85391,-3.25344>

    /* stem 0.7c0.0.7*/ 
    /*0*/ <2.17309,8.05919,-2.678>,
    /*1*/ <2.15949,8.06385,-2.67466>,<2.17878,8.06197,-2.69134>,<2.18101,8.05175,-2.66801>,
            
    /*2*/ <2.43641,8.65765,-2.44102>

    /* stem 0.7c0.0.8*/ 
    /*0*/ <2.24986,8.28223,-2.73458>,
    /*1*/ <2.2569,8.2771,-2.74508>,<2.25633,8.28912,-2.72474>,<2.23635,8.28048,-2.73392>,
            
    /*2*/ <2.16372,8.82445,-3.05751>

    /* stem 0.7c0.0.9*/ 
    /*0*/ <2.34482,8.53785,-2.78184>,
    /*1*/ <2.34569,8.53931,-2.77322>,<2.34088,8.54383,-2.78694>,<2.34789,8.53041,-2.78538>,
            
    /*2*/ <2.84772,8.78981,-2.87514>

    /* stem 0.7c0.0.10*/ 
    /*0*/ <2.40673,8.9105,-2.83262>,
    /*1*/ <2.4055,8.91055,-2.83386>,<2.4082,8.91142,-2.8328>,<2.40648,8.90953,-2.83118>,
            
    /*2*/ <2.20061,9.28427,-2.61636>

    /* stem 0.7c0.1*/ 
    /*0*/ <1.47147,7.141,-2.32474>,
    /*1*/ <1.44176,7.1089,-2.34564>,<1.5193,7.13314,-2.32446>,<1.45335,7.18096,-2.30413>,
            
    /*2*/ <1.46692,7.23902,-2.57002>,<1.53671,7.26084,-2.55096>,<1.47735,7.30387,-2.53266>,
            
    /*3*/ <1.4894,7.41229,-2.7715>,<1.55112,7.42939,-2.75125>,<1.49771,7.46297,-2.72821>,
            
    /*4*/ <1.50669,7.60843,-2.94752>,<1.5606,7.62203,-2.92844>,<1.51355,7.64774,-2.90437>,
            
    /*5*/ <1.49215,7.79697,-3.12252>,<1.53853,7.81263,-3.11061>,<1.49854,7.83184,-3.08673>,
            
    /*6*/ <1.45722,8.0063,-3.27594>,<1.49583,8.02014,-3.26697>,<1.46324,8.03204,-3.24333>,
            
    /*7*/ <1.42675,8.2276,-3.41341>,<1.45783,8.23748,-3.4054>,<1.43192,8.24606,-3.38583>,
            
    /*8*/ <1.39868,8.45668,-3.53664>,<1.42209,8.46344,-3.53026>,<1.40276,8.46919,-3.51517>,
            
    /*9*/ <1.36044,8.69324,-3.64037>,<1.37603,8.69788,-3.63621>,<1.36335,8.70052,-3.62552>,
            
    /*10*/ <1.32341,8.92949,-3.74401>,<1.33122,8.93178,-3.74191>,<1.32487,8.93312,-3.73658>,
            
    /*11*/ <1.29563,9.18488,-3.79293>

    /* stem 0.7c0.1.0*/ 
    /*0*/ <1.48595,7.22384,-2.47258>,
    /*1*/ <1.50593,7.22674,-2.469>,<1.47484,7.23871,-2.48128>,<1.47709,7.20608,-2.46745>,
            
    /*2*/ <1.70166,6.855,-3.37824>

    /* stem 0.7c0.1.1*/ 
    /*0*/ <1.49966,7.3204,-2.6138>,
    /*1*/ <1.48214,7.32812,-2.609>,<1.5046,7.31817,-2.63278>,<1.51224,7.3149,-2.59962>,
            
    /*2*/ <1.88632,8.19911,-2.61611>

    /* stem 0.7c0.1.2*/ 
    /*0*/ <1.51877,7.51595,-2.82514>,
    /*1*/ <1.52605,7.50417,-2.83732>,<1.52553,7.53305,-2.82367>,<1.50472,7.51063,-2.81443>,
            
    /*2*/ <0.94169,7.79736,-3.44241>

    /* stem 0.7c0.1.3*/ 
    /*0*/ <1.51688,7.73587,-3.03196>,
    /*1*/ <1.52195,7.7474,-3.02041>,<1.50274,7.73863,-3.04114>,<1.52596,7.72159,-3.03433>,
            
    /*2*/ <1.96214,8.11388,-3.60472>

    /* stem 0.7c0.1.4*/ 
    /*0*/ <1.49226,7.90934,-3.17882>,
    /*1*/ <1.47874,7.90269,-3.18436>,<1.50286,7.91568,-3.18907>,<1.49517,7.90966,-3.16304>,
            
    /*2*/ <1.13907,8.58375,-3.12724>

    /* stem 0.7c0.1.5*/ 
    /*0*/ <1.45591,8.12539,-3.32997>,
    /*1*/ <1.47044,8.12573,-3.33292>,<1.44845,8.13806,-3.32797>,<1.44883,8.11239,-3.32901>,
            
    /*2*/ <1.31647,8.15112,-4.01455>

    /* stem 0.7c0.1.6*/ 
    /*0*/ <1.4243,8.34303,-3.46053>,
    /*1*/ <1.41547,8.34715,-3.45096>,<1.42233,8.34651,-3.47359>,<1.43511,8.33545,-3.45705>,
            
    /*2*/ <1.76774,8.87296,-3.37168>

    /* stem 0.7c0.1.7*/ 
    /*0*/ <1.39055,8.56129,-3.5721>,
    /*1*/ <1.39052,8.5561,-3.58348>,<1.39585,8.57248,-3.57034>,<1.38526,8.55529,-3.56248>,
            
    /*2*/ <0.88609,8.81888,-3.68853>

    /* stem 0.7c0.1.8*/ 
    /*0*/ <1.34284,8.83602,-3.69732>,
    /*1*/ <1.34719,8.8388,-3.69285>,<1.33689,8.83907,-3.69864>,<1.34445,8.83018,-3.70046>,
            
    /*2*/ <1.55971,9.09737,-4.07093>

    /* stem 0.7c0.1.9*/ 
    /*0*/ <1.30565,9.10262,-3.77602>,
    /*1*/ <1.3041,9.1024,-3.7762>,<1.30647,9.10336,-3.77714>,<1.30637,9.10212,-3.77472>,
            
    /*2*/ <1.22681,9.48688,-3.58299>

    /* stem 0.7c0.2*/ 
    /*0*/ <1.779,7.28264,-2.99115>,
    /*1*/ <1.81904,7.28463,-2.97272>,<1.76205,7.31822,-3.01096>,<1.75592,7.24507,-2.98976>,
            
    /*2*/ <1.91179,7.2175,-3.17759>,<1.8605,7.24773,-3.212>,<1.85499,7.18189,-3.19292>,
            
    /*3*/ <2.01242,7.27713,-3.37817>,<1.96092,7.3039,-3.39734>,<1.97104,7.24486,-3.40953>,
            
    /*4*/ <2.11225,7.41046,-3.53869>,<2.06492,7.4315,-3.55202>,<2.08271,7.3877,-3.57703>,
            
    /*5*/ <2.22555,7.56111,-3.6725>,<2.18605,7.58026,-3.68571>,<2.20381,7.54546,-3.7097>,
            
    /*6*/ <2.32799,7.74213,-3.77934>,<2.29395,7.75637,-3.78925>,<2.31211,7.73225,-3.81265>,
            
    /*7*/ <2.401,7.92955,-3.90666>,<2.37205,7.9376,-3.91226>,<2.3867,7.91887,-3.93147>,
            
    /*8*/ <2.46174,8.12086,-4.02928>,<2.4397,8.12601,-4.03288>,<2.45098,8.11283,-4.04786>,
            
    /*9*/ <2.53909,8.32145,-4.11866>,<2.52479,8.32592,-4.12167>,<2.53274,8.31816,-4.13217>,
            
    /*10*/ <2.58412,8.53526,-4.20688>,<2.57666,8.53651,-4.20796>,<2.58085,8.53334,-4.21351>,
            
    /*11*/ <2.60866,8.76527,-4.24498>

    /* stem 0.7c0.2.0*/ 
    /*0*/ <1.82095,7.25362,-3.07916>,
    /*1*/ <1.80879,7.26459,-3.08857>,<1.82252,7.23533,-3.08357>,<1.83153,7.26095,-3.06534>,
            
    /*2*/ <2.47364,7.45602,-3.68643>

    /* stem 0.7c0.2.1*/ 
    /*0*/ <1.94787,7.25636,-3.33119>,
    /*1*/ <1.95341,7.2398,-3.33318>,<1.95844,7.26974,-3.33544>,<1.93175,7.25954,-3.32495>,
            
    /*2*/ <1.64166,7.24853,-4.1175>

    /* stem 0.7c0.2.2*/ 
    /*0*/ <2.04741,7.3597,-3.49592>,
    /*1*/ <2.04951,7.37161,-3.48459>,<2.03988,7.36316,-3.51027>,<2.05284,7.34434,-3.4929>,
            
    /*2*/ <2.74574,7.54319,-3.81811>

    /* stem 0.7c0.2.3*/ 
    /*0*/ <2.17339,7.52146,-3.65357>,
    /*1*/ <2.16427,7.5181,-3.66551>,<2.18869,7.521,-3.6552>,<2.16721,7.52527,-3.64>,
            
    /*2*/ <2.17326,8.22268,-3.85077>

    /* stem 0.7c0.2.4*/ 
    /*0*/ <2.24292,7.62677,-3.72646>,
    /*1*/ <2.25575,7.62268,-3.7205>,<2.23801,7.64053,-3.72463>,<2.23499,7.6171,-3.73423>,
            
    /*2*/ <2.57286,7.8209,-4.3045>

    /* stem 0.7c0.2.5*/ 
    /*0*/ <2.34236,7.81988,-3.84447>,
    /*1*/ <2.33117,7.82675,-3.84098>,<2.34684,7.82026,-3.85729>,<2.34907,7.81263,-3.83514>,
            
    /*2*/ <2.69682,8.32666,-3.70574>

    /* stem 0.7c0.2.6*/ 
    /*0*/ <2.41954,8.02679,-3.97831>,
    /*1*/ <2.42376,8.01962,-3.98748>,<2.42686,8.03545,-3.97334>,<2.40799,8.0253,-3.9741>,
            
    /*2*/ <2.23079,8.40643,-4.362>

    /* stem 0.7c0.2.7*/ 
    /*0*/ <2.50124,8.24502,-4.09088>,
    /*1*/ <2.50401,8.24809,-4.08123>,<2.4956,8.25142,-4.09701>,<2.50412,8.23556,-4.09441>,
            
    /*2*/ <2.93095,8.44522,-4.2776>

    /* stem 0.7c0.2.8*/ 
    /*0*/ <2.55123,8.40577,-4.15774>,
    /*1*/ <2.54549,8.40542,-4.16187>,<2.55755,8.40725,-4.16058>,<2.55066,8.40463,-4.15077>,
            
    /*2*/ <2.47489,8.86039,-4.0902>

    /* stem 0.7c0.2.9*/ 
    /*0*/ <2.59695,8.66942,-4.23019>,
    /*1*/ <2.59877,8.66918,-4.23028>,<2.59624,8.67065,-4.22903>,<2.59584,8.66842,-4.23126>,
            
    /*2*/ <2.61951,8.94904,-4.51377>

    /* stem 0.7c0.3*/ 
    /*0*/ <2.19637,7.57592,-3.8811>,
    /*1*/ <2.17034,7.59402,-3.8853>,<2.2061,7.55628,-3.90438>,<2.21265,7.57745,-3.85362>,
            
    /*2*/ <2.2862,7.73755,-3.96012>,<2.31838,7.70358,-3.97729>,<2.32428,7.72264,-3.93161>,
            
    /*3*/ <2.36668,7.90036,-4.02657>,<2.39948,7.87712,-4.0452>,<2.40371,7.89205,-4.0037>,
            
    /*4*/ <2.44712,8.07269,-4.08356>,<2.4766,8.05398,-4.10042>,<2.47928,8.06498,-4.06334>,
            
    /*5*/ <2.52515,8.24042,-4.15667>,<2.5499,8.2233,-4.17077>,<2.55335,8.23515,-4.13991>,
            
    /*6*/ <2.61886,8.40461,-4.22373>,<2.63892,8.38909,-4.23484>,<2.64134,8.39831,-4.20884>,
            
    /*7*/ <2.70775,8.57516,-4.27318>,<2.72453,8.56408,-4.28248>,<2.72552,8.56976,-4.26109>,
            
    /*8*/ <2.79655,8.75003,-4.30688>,<2.80948,8.74236,-4.31398>,<2.80959,8.74545,-4.29765>,
            
    /*9*/ <2.87269,8.93114,-4.33446>,<2.88165,8.92681,-4.33932>,<2.88157,8.92851,-4.32838>,
            
    /*10*/ <2.96758,9.10687,-4.33171>,<2.97203,9.1046,-4.33411>,<2.97162,9.10473,-4.32859>,
            
    /*11*/ <3.04182,9.29106,-4.33788>

    /* stem 0.7c0.3.0*/ 
    /*0*/ <2.28118,7.68476,-3.93745>,
    /*1*/ <2.28855,7.67562,-3.94402>,<2.28721,7.69387,-3.9296>,<2.2678,7.68479,-3.93872>,
            
    /*2*/ <2.33868,8.15734,-4.53029>

    /* stem 0.7c0.3.1*/ 
    /*0*/ <2.36546,7.83844,-4.00417>,
    /*1*/ <2.36465,7.84357,-3.99255>,<2.36122,7.84489,-4.01429>,<2.37052,7.82686,-4.00567>,
            
    /*2*/ <3.01217,8.13188,-4.08833>

    /* stem 0.7c0.3.2*/ 
    /*0*/ <2.5239,8.19044,-4.13734>,
    /*1*/ <2.51777,8.18916,-4.14656>,<2.53414,8.1948,-4.13801>,<2.5198,8.18734,-4.12745>,
            
    /*2*/ <2.28804,8.75516,-4.05861>

    /* stem 0.7c0.3.3*/ 
    /*0*/ <2.56799,8.27883,-4.1744>,
    /*1*/ <2.57725,8.27547,-4.17015>,<2.56421,8.28859,-4.172>,<2.56249,8.27244,-4.18104>,
            
    /*2*/ <2.86145,8.50564,-4.63543>

    /* stem 0.7c0.3.4*/ 
    /*0*/ <2.66785,8.46691,-4.24257>,
    /*1*/ <2.65967,8.47175,-4.23999>,<2.67286,8.46964,-4.2506>,<2.67102,8.45934,-4.23712>,
            
    /*2*/ <2.96177,8.80487,-3.94454>

    /* stem 0.7c0.3.5*/ 
    /*0*/ <2.76453,8.66252,-4.29012>,
    /*1*/ <2.76852,8.65917,-4.29741>,<2.76889,8.66838,-4.28492>,<2.75619,8.66,-4.28802>,
            
    /*2*/ <2.58786,9.02792,-4.55443>

    /* stem 0.7c0.3.6*/ 
    /*0*/ <2.91636,9.0014,-4.33299>,
    /*1*/ <2.91677,9.00111,-4.32794>,<2.91452,9.00561,-4.33515>,<2.91778,8.99747,-4.33589>,
            
    /*2*/ <3.28116,9.14961,-4.35442>

    /* stem 0.7c0.3.7*/ 
    /*0*/ <3.01914,9.2321,-4.33585>,
    /*1*/ <3.01845,9.23234,-4.33655>,<3.02012,9.23233,-4.33599>,<3.01885,9.23162,-4.335>,
            
    /*2*/ <2.96846,9.52619,-4.18674>

    /* stem 0.7c0.4*/ 
    /*0*/ <2.45765,7.83724,-4.40623>,
    /*1*/ <2.46567,7.81819,-4.41235>,<2.47081,7.85411,-4.40355>,<2.43648,7.83943,-4.40279>,
            
    /*2*/ <2.44193,7.86492,-4.58119>,<2.44656,7.89725,-4.57326>,<2.41566,7.88403,-4.57258>,
            
    /*3*/ <2.42335,7.96463,-4.73252>,<2.42847,7.98958,-4.71691>,<2.40055,7.97948,-4.7202>,
            
    /*4*/ <2.39877,8.0886,-4.86059>,<2.40388,8.10765,-4.84344>,<2.37933,8.09934,-4.8468>,
            
    /*5*/ <2.35659,8.22321,-4.97057>,<2.3615,8.2381,-4.95458>,<2.34066,8.23009,-4.9564>,
            
    /*6*/ <2.32391,8.37812,-5.05391>,<2.32874,8.38759,-5.03857>,<2.31098,8.38246,-5.04116>,
            
    /*7*/ <2.29593,8.53437,-5.13222>,<2.29987,8.54152,-5.11971>,<2.28559,8.53782,-5.122>,
            
    /*8*/ <2.31146,8.69351,-5.20688>,<2.31439,8.69798,-5.19703>,<2.30361,8.69762,-5.20003>,
            
    /*9*/ <2.32333,8.85646,-5.27519>,<2.32527,8.8592,-5.26852>,<2.31807,8.8589,-5.27049>,
            
    /*10*/ <2.33839,9.02008,-5.34053>,<2.33935,9.02138,-5.33716>,<2.33576,9.02131,-5.33818>,
            
    /*11*/ <2.35132,9.18628,-5.39964>

    /* stem 0.7c0.4.0*/ 
    /*0*/ <2.44,7.87173,-4.53662>,
    /*1*/ <2.44278,7.88016,-4.53476>,<2.43242,7.87041,-4.54138>,<2.44482,7.86464,-4.5337>,
            
    /*2*/ <2.79788,7.87965,-5.10822>

    /* stem 0.7c0.4.1*/ 
    /*0*/ <2.42939,7.91161,-4.62117>,
    /*1*/ <2.42183,7.90752,-4.62294>,<2.43585,7.9117,-4.62712>,<2.4305,7.91563,-4.61344>,
            
    /*2*/ <2.18995,8.46284,-4.87289>

    /* stem 0.7c0.4.2*/ 
    /*0*/ <2.36392,8.19514,-4.931>,
    /*1*/ <2.37105,8.19536,-4.93339>,<2.36011,8.20154,-4.92994>,<2.3606,8.18852,-4.92966>,
            
    /*2*/ <2.18975,8.17731,-5.45106>

    /* stem 0.7c0.4.3*/ 
    /*0*/ <2.33307,8.32575,-5.01311>,
    /*1*/ <2.32912,8.32792,-5.00768>,<2.33128,8.32751,-5.0197>,<2.33882,8.32183,-5.01194>,
            
    /*2*/ <2.6155,8.74987,-4.97686>

    /* stem 0.7c0.4.4*/ 
    /*0*/ <2.30686,8.46393,-5.08647>,
    /*1*/ <2.30624,8.46084,-5.09224>,<2.30986,8.46978,-5.08617>,<2.30449,8.46118,-5.08098>,
            
    /*2*/ <1.89226,8.67982,-5.15716>

    /* stem 0.7c0.4.5*/ 
    /*0*/ <2.29941,8.59341,-5.1515>,
    /*1*/ <2.30375,8.59494,-5.14744>,<2.29537,8.59762,-5.1534>,<2.29911,8.58767,-5.15366>,
            
    /*2*/ <2.56775,8.70288,-5.47947>

    /* stem 0.7c0.4.6*/ 
    /*0*/ <2.3289,8.92775,-5.30013>,
    /*1*/ <2.32553,8.92791,-5.30052>,<2.33094,8.92908,-5.30249>,<2.33022,8.92625,-5.29739>,
            
    /*2*/ <2.32421,9.23369,-5.13114>

    /* stem 0.7c0.4.7*/ 
    /*0*/ <2.34761,9.14073,-5.38283>,
    /*1*/ <2.34809,9.14058,-5.38314>,<2.34762,9.1412,-5.38247>,<2.34711,9.14042,-5.38289>,
            
    /*2*/ <2.26318,9.31535,-5.60447>

    /* stem 0.7c1*/ 
    /*0*/ <2.26882,7.67817,-2.79038>,
    /*1*/ <2.31372,7.67788,-2.78608>,<2.28111,7.71647,-2.76997>,<2.23151,7.70212,-2.78207>,
            <2.23347,7.65466,-2.80564>,<2.28428,7.63968,-2.80812>,
    /*2*/ <2.35793,7.95201,-3.33422>,<2.33252,7.98208,-3.32167>,<2.29388,7.9709,-3.3311>,
            <2.29541,7.93392,-3.34946>,<2.33499,7.92225,-3.35139>,
    /*3*/ <2.37094,8.27084,-3.86129>,<2.35254,8.29102,-3.84986>,<2.32483,8.2827,-3.85611>,
            <2.3261,8.25739,-3.87139>,<2.3546,8.25006,-3.87459>,
    /*4*/ <2.40586,8.6085,-4.37233>,<2.39474,8.62061,-4.36529>,<2.37804,8.61605,-4.36978>,
            <2.37884,8.60112,-4.37959>,<2.39603,8.59645,-4.38116>,
    /*5*/ <2.46759,8.90205,-4.90789>,<2.46382,8.90652,-4.90594>,<2.45807,8.90499,-4.90755>,
            <2.45829,8.89958,-4.91049>,<2.46418,8.89776,-4.9107>,
    /*6*/ <2.46239,8.90218,-4.90852>

    /* stem 0.7c1.0*/ 
    /*0*/ <2.28476,7.75885,-2.95148>,
    /*1*/ <2.25192,7.78308,-2.94259>,<2.28331,7.73288,-2.98415>,<2.31904,7.7606,-2.92769>,
            
    /*2*/ <2.33717,7.93938,-3.07327>,<2.36542,7.89419,-3.11068>,<2.39758,7.91914,-3.05986>,
            
    /*3*/ <2.40806,8.1091,-3.18841>,<2.43533,8.07384,-3.22531>,<2.46305,8.09395,-3.17866>,
            
    /*4*/ <2.50421,8.27253,-3.30883>,<2.52681,8.23839,-3.33863>,<2.55028,8.25516,-3.297>,
            
    /*5*/ <2.54189,8.45661,-3.40791>,<2.56405,8.43593,-3.43898>,<2.58469,8.4507,-3.40377>,
            
    /*6*/ <2.62211,8.63989,-3.51093>,<2.63984,8.61936,-3.53486>,<2.65607,8.62945,-3.50415>,
            
    /*7*/ <2.67535,8.833,-3.59637>,<2.69063,8.82005,-3.61725>,<2.70349,8.8275,-3.59242>,
            
    /*8*/ <2.73987,9.03834,-3.64301>,<2.75207,9.03115,-3.65946>,<2.76062,9.03298,-3.6396>,
            
    /*9*/ <2.83338,9.2331,-3.69673>,<2.84098,9.2268,-3.7073>,<2.84656,9.22779,-3.69399>,
            
    /*10*/ <2.94198,9.41365,-3.76587>,<2.94541,9.40979,-3.77093>,<2.94833,9.41055,-3.76435>,
            
    /*11*/ <3.0381,9.60183,-3.82905>

    /* stem 0.7c1.0.0*/ 
    /*0*/ <2.32123,7.82948,-3.00923>,
    /*1*/ <2.32632,7.81714,-3.02111>,<2.33228,7.84286,-3.00496>,<2.30509,7.82844,-3.00163>,
            
    /*2*/ <1.99111,8.30496,-3.64479>

    /* stem 0.7c1.0.1*/ 
    /*0*/ <2.39835,7.99794,-3.13472>,
    /*1*/ <2.4039,8.00518,-3.12054>,<2.38764,8.00621,-3.14478>,<2.40351,7.98243,-3.13884>,
            
    /*2*/ <3.02073,8.31209,-3.53891>

    /* stem 0.7c1.0.2*/ 
    /*0*/ <2.4587,8.13363,-3.22721>,
    /*1*/ <2.44597,8.13374,-3.237>,<2.47355,8.13371,-3.23335>,<2.45659,8.13344,-3.21129>,
            
    /*2*/ <2.45849,8.89739,-3.21827>

    /* stem 0.7c1.0.3*/ 
    /*0*/ <2.54029,8.32498,-3.35175>,
    /*1*/ <2.55486,8.32175,-3.35264>,<2.53589,8.33899,-3.34893>,<2.53011,8.3142,-3.35369>,
            
    /*2*/ <2.52837,8.46078,-4.04353>

    /* stem 0.7c1.0.4*/ 
    /*0*/ <2.58836,8.50728,-3.44955>,
    /*1*/ <2.57967,8.5151,-3.4419>,<2.58942,8.50944,-3.46331>,<2.596,8.49731,-3.44344>,
            
    /*2*/ <3.06855,8.93869,-3.34518>

    /* stem 0.7c1.0.5*/ 
    /*0*/ <2.72509,8.94664,-3.62821>,
    /*1*/ <2.72622,8.94384,-3.63947>,<2.73262,8.95402,-3.62326>,<2.71642,8.94205,-3.62191>,
            
    /*2*/ <2.41036,9.35765,-3.76186>

    /* stem 0.7c1.0.6*/ 
    /*0*/ <2.77927,9.09613,-3.66387>,
    /*1*/ <2.78497,9.09599,-3.6546>,<2.77419,9.10523,-3.66699>,<2.77866,9.08717,-3.67002>,
            
    /*2*/ <3.18471,9.23787,-3.91084>

    /* stem 0.7c1.0.7*/ 
    /*0*/ <2.91138,9.35257,-3.7452>,
    /*1*/ <2.90664,9.35455,-3.74724>,<2.91583,9.35219,-3.74846>,<2.91168,9.35098,-3.73992>,
            
    /*2*/ <3.02696,9.7443,-3.63362>

    /* stem 0.7c1.0.8*/ 
    /*0*/ <2.98718,9.49737,-3.79505>,
    /*1*/ <2.98904,9.49624,-3.79575>,<2.9874,9.49941,-3.79403>,<2.9851,9.49647,-3.79538>,
            
    /*2*/ <2.96529,9.67024,-4.13539>

    /* stem 0.7c1.1*/ 
    /*0*/ <2.36505,8.41534,-4.08167>,
    /*1*/ <2.36958,8.39814,-4.09265>,<2.37898,8.43087,-4.08034>,<2.34658,8.41701,-4.07201>,
            
    /*2*/ <2.30067,8.47357,-4.23521>,<2.30913,8.50302,-4.22413>,<2.27997,8.49055,-4.21663>,
            
    /*3*/ <2.22513,8.57382,-4.36223>,<2.23462,8.5979,-4.34921>,<2.20865,8.58702,-4.34239>,
            
    /*4*/ <2.19244,8.70243,-4.47993>,<2.20221,8.71969,-4.46415>,<2.17747,8.71424,-4.46322>,
            
    /*5*/ <2.16407,8.85475,-4.5684>,<2.1732,8.86605,-4.55225>,<2.15182,8.86218,-4.55207>,
            
    /*6*/ <2.13699,9.00661,-4.65235>,<2.14466,9.01573,-4.63872>,<2.12683,9.01261,-4.63861>,
            
    /*7*/ <2.09903,9.1458,-4.75024>,<2.10488,9.15456,-4.7403>,<2.09081,9.15121,-4.73962>,
            
    /*8*/ <2.05684,9.28419,-4.84929>,<2.06121,9.29091,-4.84196>,<2.05071,9.2882,-4.84127>,
            
    /*9*/ <2.00379,9.43257,-4.92816>,<2.0069,9.43653,-4.92296>,<2,9.43443,-4.92228>,
            
    /*10*/ <1.96192,9.58982,-4.9945>,<1.96357,9.59147,-4.99173>,<1.96006,9.59063,-4.9915>,
            
    /*11*/ <1.92676,9.75871,-5.02831>

    /* stem 0.7c1.1.0*/ 
    /*0*/ <2.32468,8.4588,-4.16637>,
    /*1*/ <2.32831,8.46657,-4.16411>,<2.31604,8.45834,-4.16833>,<2.32969,8.45148,-4.16667>,
            
    /*2*/ <2.46533,8.58209,-4.81669>

    /* stem 0.7c1.1.1*/ 
    /*0*/ <2.26496,8.5307,-4.2793>,
    /*1*/ <2.25771,8.52649,-4.2783>,<2.2678,8.53246,-4.28707>,<2.26939,8.53316,-4.27253>,
            
    /*2*/ <1.94371,9.08575,-4.27058>

    /* stem 0.7c1.1.2*/ 
    /*0*/ <2.18021,8.76859,-4.50266>,
    /*1*/ <2.18689,8.76788,-4.50594>,<2.17835,8.77502,-4.49933>,<2.17539,8.76287,-4.50271>,
            
    /*2*/ <1.9638,8.95529,-4.98338>

    /* stem 0.7c1.1.3*/ 
    /*0*/ <2.15206,8.9225,-4.59254>,
    /*1*/ <2.1492,8.92524,-4.58683>,<2.14895,8.9233,-4.59871>,<2.15803,8.91897,-4.59209>,
            
    /*2*/ <2.41658,9.3588,-4.66926>

    /* stem 0.7c1.1.4*/ 
    /*0*/ <2.11908,9.07422,-4.68835>,
    /*1*/ <2.11752,9.0703,-4.69319>,<2.12315,9.07907,-4.68934>,<2.11657,9.07327,-4.68252>,
            
    /*2*/ <1.75651,9.35559,-4.79898>

    /* stem 0.7c1.1.5*/ 
    /*0*/ <2.06831,9.24836,-4.81524>,
    /*1*/ <2.07286,9.25125,-4.8132>,<2.06328,9.25108,-4.81601>,<2.06878,9.24276,-4.8165>,
            
    /*2*/ <2.18113,9.34645,-5.20661>

    /* stem 0.7c1.1.6*/ 
    /*0*/ <1.98128,9.51792,-4.96085>,
    /*1*/ <1.97833,9.51743,-4.96017>,<1.98204,9.51922,-4.96352>,<1.98347,9.51711,-4.95887>,
            
    /*2*/ <1.96371,9.82717,-4.81519>

    /* stem 0.7c1.1.7*/ 
    /*0*/ <1.9519,9.63828,-5.00271>,
    /*1*/ <1.95283,9.63823,-5.00388>,<1.95206,9.63936,-5.00167>,<1.95082,9.63726,-5.00257>,
            
    /*2*/ <1.75946,9.82112,-5.16429>

    /* stem 0.7c2*/ 
    /*0*/ <2.96637,8.34649,-3.54595>,
    /*1*/ <2.99078,8.34837,-3.54007>,<2.96917,8.36625,-3.5306>,<2.94369,8.35682,-3.54235>,
            <2.94955,8.33312,-3.55908>,<2.97865,8.3279,-3.55767>,
    /*2*/ <3.07021,8.71268,-4.02846>,<3.05716,8.72348,-4.02274>,<3.04177,8.71778,-4.02984>,
            <3.04531,8.70346,-4.03995>,<3.06289,8.70031,-4.0391>,
    /*3*/ <3.1697,9.10421,-4.49055>,<3.16519,9.10788,-4.48849>,<3.15994,9.10614,-4.49122>,
            <3.16121,9.10141,-4.49496>,<3.16724,9.10022,-4.49454>,
    /*4*/ <3.16466,9.10397,-4.49195>

    /* stem 0.7c2.0*/ 
    /*0*/ <3.08461,8.81627,-4.15476>,
    /*1*/ <3.08925,8.80688,-4.16167>,<3.09193,8.82597,-4.15163>,<3.07264,8.81596,-4.15098>,
            
    /*2*/ <3.04531,8.88303,-4.29239>,<3.04772,8.90021,-4.28335>,<3.03036,8.8912,-4.28277>,
            
    /*3*/ <2.99804,8.96576,-4.41862>,<3.0005,8.98063,-4.40994>,<2.98504,8.97268,-4.40937>,
            
    /*4*/ <2.95767,9.07129,-4.53045>,<2.96054,9.08272,-4.52083>,<2.94659,9.07667,-4.52151>,
            
    /*5*/ <2.93059,9.19687,-4.62369>,<2.93352,9.20491,-4.61385>,<2.92121,9.20096,-4.61559>,
            
    /*6*/ <2.88193,9.32947,-4.69622>,<2.88469,9.33534,-4.6875>,<2.87466,9.33121,-4.68832>,
            
    /*7*/ <2.83108,9.4641,-4.7611>,<2.83342,9.46849,-4.75396>,<2.82541,9.46516,-4.7546>,
            
    /*8*/ <2.78354,9.60552,-4.81299>,<2.78548,9.60827,-4.80741>,<2.77939,9.60601,-4.80798>,
            
    /*9*/ <2.74265,9.74992,-4.86112>,<2.744,9.75159,-4.85734>,<2.73988,9.75028,-4.85779>,
            
    /*10*/ <2.7061,9.899,-4.89737>,<2.70682,9.89967,-4.89543>,<2.70474,9.89909,-4.89568>,
            
    /*11*/ <2.66461,10.03875,-4.95659>

    /* stem 0.7c2.0.0*/ 
    /*0*/ <3.06416,8.85164,-4.21656>,
    /*1*/ <3.0657,8.8563,-4.2144>,<3.05927,8.85116,-4.21871>,<3.06751,8.84745,-4.21656>,
            
    /*2*/ <3.28577,9.02968,-4.75891>

    /* stem 0.7c2.0.1*/ 
    /*0*/ <2.96768,9.04345,-4.48832>,
    /*1*/ <2.96369,9.04109,-4.48911>,<2.9703,9.0449,-4.49195>,<2.96905,9.04436,-4.48392>,
            
    /*2*/ <2.70004,9.49945,-4.5>

    /* stem 0.7c2.0.2*/ 
    /*0*/ <2.93617,9.16472,-4.59044>,
    /*1*/ <2.94038,9.16469,-4.59167>,<2.93429,9.16847,-4.58914>,<2.93384,9.161,-4.5905>,
            
    /*2*/ <2.80165,9.25686,-5.05243>

    /* stem 0.7c2.0.3*/ 
    /*0*/ <2.90094,9.276,-4.65951>,
    /*1*/ <2.89871,9.27703,-4.65619>,<2.8992,9.27602,-4.66324>,<2.9049,9.27496,-4.65908>,
            
    /*2*/ <3.0224,9.71346,-4.71378>

    /* stem 0.7c2.0.4*/ 
    /*0*/ <2.80175,9.55007,-4.7882>,
    /*1*/ <2.80128,9.54871,-4.79139>,<2.80354,9.55305,-4.78782>,<2.80045,9.54845,-4.7854>,
            
    /*2*/ <2.47867,9.74811,-4.82426>

    /* stem 0.7c2.0.5*/ 
    /*0*/ <2.75729,9.69704,-4.84042>,
    /*1*/ <2.75945,9.69823,-4.83875>,<2.75459,9.69831,-4.84049>,<2.75782,9.69459,-4.84203>,
            
    /*2*/ <2.85528,9.89109,-5.10408>

    /* stem 0.7c2.0.6*/ 
    /*0*/ <2.67754,9.99504,-4.93766>,
    /*1*/ <2.67716,9.99494,-4.93763>,<2.67769,9.99517,-4.938>,<2.67778,9.99501,-4.93734>,
            
    /*2*/ <2.61649,10.24176,-4.86666>

    /* stem 0.7.0*/ 
    /*0*/ <0.18087,6.93506,-0.34494>,
    /*1*/ <0.14266,6.97199,-0.37719>,<0.20176,6.88227,-0.37023>,<0.19817,6.95093,-0.28738>,
            
    /*2*/ <0.41716,7.13669,-0.50179>,<0.47035,7.05595,-0.49552>,<0.46712,7.11774,-0.42096>,
            
    /*3*/ <0.66842,7.31119,-0.64668>,<0.71964,7.242,-0.64412>,<0.71909,7.29762,-0.57837>,
            
    /*4*/ <0.8607,7.52991,-0.80778>,<0.91551,7.47855,-0.81392>,<0.9135,7.52457,-0.75428>,
            
    /*5*/ <1.08493,7.76382,-0.93326>,<1.13124,7.71895,-0.93705>,<1.12457,7.75401,-0.88321>,
            
    /*6*/ <1.22271,8.02491,-1.08813>,<1.26756,7.9966,-1.09733>,<1.26293,8.02582,-1.05236>,
            
    /*7*/ <1.35442,8.30557,-1.23394>,<1.39119,8.28477,-1.24233>,<1.38655,8.30621,-1.20527>,
            
    /*8*/ <1.47545,8.60707,-1.34419>,<1.50391,8.5936,-1.35137>,<1.49898,8.60629,-1.32208>,
            
    /*9*/ <1.5768,8.91553,-1.45303>,<1.59616,8.9077,-1.45826>,<1.59276,8.91576,-1.43858>,
            
    /*10*/ <1.60569,9.22227,-1.59847>,<1.61565,9.21993,-1.60182>,<1.61416,9.22461,-1.59224>,
            
    /*11*/ <1.59745,9.50919,-1.78574>

    /* stem 0.7.0.0*/ 
    /*0*/ <0.31164,7.01642,-0.40669>,
    /*1*/ <0.3247,6.99347,-0.40927>,<0.32436,7.03802,-0.39798>,<0.28586,7.01778,-0.41282>,
            
    /*2*/ <0.62724,7.33707,-1.66253>

    /* stem 0.7.0.1*/ 
    /*0*/ <0.50898,7.14471,-0.50717>,
    /*1*/ <0.50581,7.16334,-0.49015>,<0.51435,7.15038,-0.53138>,<0.50679,7.12041,-0.49999>,
            
    /*2*/ <1.7525,7.11179,-0.23906>

    /* stem 0.7.0.2*/ 
    /*0*/ <0.66815,7.25902,-0.60254>,
    /*1*/ <0.65992,7.25211,-0.62455>,<0.69208,7.25782,-0.59749>,<0.65244,7.26712,-0.58558>,
            
    /*2*/ <0.81191,8.39877,-1.01389>

    /* stem 0.7.0.3*/ 
    /*0*/ <0.79136,7.3878,-0.70046>,
    /*1*/ <0.80943,7.38309,-0.68603>,<0.78811,7.40974,-0.70854>,<0.77654,7.37057,-0.70683>,
            
    /*2*/ <1.46801,7.14748,-1.62571>

    /* stem 0.7.0.4*/ 
    /*0*/ <0.97089,7.59134,-0.83509>,
    /*1*/ <0.95402,7.60571,-0.8374>,<0.98595,7.58914,-0.85136>,<0.97269,7.57917,-0.81652>,
            
    /*2*/ <1.5811,8.38122,-0.37683>

    /* stem 0.7.0.5*/ 
    /*0*/ <1.14857,7.81436,-0.95893>,
    /*1*/ <1.15966,7.80146,-0.97107>,<1.1582,7.82953,-0.94826>,<1.12785,7.81209,-0.95746>,
            
    /*2*/ <1.02285,8.45091,-1.75>

    /* stem 0.7.0.6*/ 
    /*0*/ <1.22872,7.97186,-1.05303>,
    /*1*/ <1.23019,7.98154,-1.03558>,<1.22349,7.98182,-1.06959>,<1.23247,7.95222,-1.05393>,
            
    /*2*/ <2.16774,8.15978,-1.23657>

    /* stem 0.7.0.7*/ 
    /*0*/ <1.32455,8.18044,-1.16531>,
    /*1*/ <1.3125,8.17831,-1.17968>,<1.34229,8.18597,-1.16861>,<1.31885,8.17704,-1.14764>,
            
    /*2*/ <1.06833,9.05336,-1.08008>

    /* stem 0.7.0.8*/ 
    /*0*/ <1.41808,8.40586,-1.26668>,
    /*1*/ <1.43452,8.40135,-1.26196>,<1.41234,8.42239,-1.26406>,<1.40737,8.39385,-1.27403>,
            
    /*2*/ <1.69995,8.62626,-2.0379>

    /* stem 0.7.0.9*/ 
    /*0*/ <1.53201,8.72955,-1.38456>,
    /*1*/ <1.51873,8.73592,-1.37817>,<1.53723,8.73456,-1.39889>,<1.54007,8.71816,-1.37663>,
            
    /*2*/ <1.95381,9.26593,-1.04304>

    /* stem 0.7.0.10*/ 
    /*0*/ <1.59718,9.02737,-1.50452>,
    /*1*/ <1.6003,9.02303,-1.51313>,<1.60193,9.03558,-1.50097>,<1.58929,9.0235,-1.49947>,
            
    /*2*/ <1.17219,9.42771,-1.86067>

    /* stem 0.7.0.11*/ 
    /*0*/ <1.60708,9.15909,-1.56737>,
    /*1*/ <1.60988,9.16191,-1.56102>,<1.6011,9.16227,-1.57056>,<1.61026,9.15309,-1.57052>,
            
    /*2*/ <1.99711,9.54688,-1.91152>

    /* stem 0.7.0.12*/ 
    /*0*/ <1.60309,9.39674,-1.71197>,
    /*1*/ <1.60093,9.39604,-1.71286>,<1.60486,9.39745,-1.71348>,<1.60347,9.39672,-1.70956>,
            
    /*2*/ <1.41227,9.94532,-1.67757>

    /* stem 0.7.1*/ 
    /*0*/ <0.29238,6.93415,-0.47807>,
    /*1*/ <0.30317,6.87468,-0.46862>,<0.33913,6.97322,-0.48356>,<0.23484,6.95455,-0.48202>,
            
    /*2*/ <0.30648,6.82848,-0.80292>,<0.33885,6.91717,-0.81637>,<0.24499,6.90036,-0.81498>,
            
    /*3*/ <0.34487,6.92426,-1.14633>,<0.36995,7.00157,-1.12224>,<0.28776,6.98604,-1.13601>,
            
    /*4*/ <0.38236,7.10374,-1.44415>,<0.40211,7.16428,-1.40612>,<0.33073,7.15234,-1.42238>,
            
    /*5*/ <0.38726,7.29011,-1.72831>,<0.4049,7.34156,-1.69539>,<0.3432,7.32932,-1.70457>,
            
    /*6*/ <0.37802,7.50574,-1.99301>,<0.39298,7.54588,-1.96184>,<0.3415,7.53538,-1.96863>,
            
    /*7*/ <0.3529,7.75013,-2.22992>,<0.36524,7.77944,-2.2019>,<0.32404,7.77064,-2.20662>,
            
    /*8*/ <0.34066,8.03033,-2.42418>,<0.35012,8.04828,-2.39971>,<0.31912,8.04341,-2.40479>,
            
    /*9*/ <0.27723,8.31105,-2.6029>,<0.28366,8.32318,-2.58675>,<0.26328,8.31757,-2.58833>,
            
    /*10*/ <0.2191,8.6016,-2.76576>,<0.22243,8.60716,-2.75737>,<0.21219,8.60459,-2.75831>,
            
    /*11*/ <0.16106,8.92569,-2.84672>

    /* stem 0.7.1.0*/ 
    /*0*/ <0.29488,6.90447,-0.6678>,
    /*1*/ <0.30781,6.92677,-0.67112>,<0.27421,6.8991,-0.68263>,<0.30261,6.88754,-0.64966>,
            
    /*2*/ <1.07119,6.32452,-1.53988>

    /* stem 0.7.1.1*/ 
    /*0*/ <0.30566,6.90306,-0.88827>,
    /*1*/ <0.28272,6.89443,-0.89329>,<0.32387,6.90083,-0.90529>,<0.3104,6.91392,-0.86624>,
            
    /*2*/ <-0.00701,8.01358,-1.36815>

    /* stem 0.7.1.2*/ 
    /*0*/ <0.32845,6.95702,-1.08522>,
    /*1*/ <0.35134,6.94942,-1.08466>,<0.32336,6.97944,-1.09254>,<0.31065,6.9422,-1.07847>,
            
    /*2*/ <0.2262,6.56507,-2.21501>

    /* stem 0.7.1.3*/ 
    /*0*/ <0.34589,7.02345,-1.22504>,
    /*1*/ <0.33271,7.04087,-1.21654>,<0.34226,7.01554,-1.24681>,<0.36272,7.01393,-1.21177>,
            
    /*2*/ <1.10812,7.79984,-1.63458>

    /* stem 0.7.1.4*/ 
    /*0*/ <0.37553,7.24194,-1.58537>,
    /*1*/ <0.37323,7.22382,-1.59687>,<0.39149,7.25573,-1.59001>,<0.36187,7.24628,-1.56921>,
            
    /*2*/ <-0.26262,7.75251,-2.26204>

    /* stem 0.7.1.5*/ 
    /*0*/ <0.37638,7.37722,-1.78169>,
    /*1*/ <0.39125,7.38856,-1.77319>,<0.36089,7.38637,-1.79163>,<0.37698,7.35674,-1.78025>,
            
    /*2*/ <0.89913,7.33262,-2.63739>

    /* stem 0.7.1.6*/ 
    /*0*/ <0.37361,7.45304,-1.878>,
    /*1*/ <0.35365,7.45177,-1.87842>,<0.384,7.45291,-1.89509>,<0.38317,7.45442,-1.86049>,
            
    /*2*/ <0.31308,8.42447,-1.92192>

    /* stem 0.7.1.7*/ 
    /*0*/ <0.36394,7.59888,-2.04455>,
    /*1*/ <0.3791,7.59153,-2.05337>,<0.36283,7.61763,-2.04159>,<0.3499,7.58748,-2.03869>,
            
    /*2*/ <-0.05869,7.70197,-2.85636>

    /* stem 0.7.1.8*/ 
    /*0*/ <0.3422,7.89896,-2.30778>,
    /*1*/ <0.33843,7.90866,-2.29407>,<0.33338,7.90096,-2.32243>,<0.35479,7.88726,-2.30685>,
            
    /*2*/ <0.88688,8.46525,-2.5585>

    /* stem 0.7.1.9*/ 
    /*0*/ <0.2902,8.24811,-2.54688>,
    /*1*/ <0.28385,8.24041,-2.55636>,<0.29929,8.25769,-2.55075>,<0.28746,8.24622,-2.53352>,
            
    /*2*/ <-0.24112,8.73551,-2.58682>

    /* stem 0.7.1.10*/ 
    /*0*/ <0.26721,8.35522,-2.61484>,
    /*1*/ <0.2777,8.35887,-2.61213>,<0.25833,8.36238,-2.61422>,<0.26561,8.3444,-2.61816>,
            
    /*2*/ <0.37179,8.54155,-3.27215>

    /* stem 0.7.1.11*/ 
    /*0*/ <0.2365,8.51046,-2.70555>,
    /*1*/ <0.22891,8.51064,-2.70267>,<0.23781,8.51081,-2.71356>,<0.24278,8.50992,-2.70043>,
            
    /*2*/ <0.26484,9.15638,-2.67233>

    /* stem 0.7.1.12*/ 
    /*0*/ <0.18447,8.79341,-2.81121>,
    /*1*/ <0.18567,8.79304,-2.81339>,<0.18482,8.79555,-2.80993>,<0.18291,8.79164,-2.81031>,
            
    /*2*/ <-0.25289,9.0343,-3.09283>

    /* stem 0.7.2*/ 
    /*0*/ <0.43097,6.93646,-0.66027>,
    /*1*/ <0.45204,6.99012,-0.64409>,<0.40595,6.92914,-0.71418>,<0.43493,6.89012,-0.62255>,
            
    /*2*/ <0.7443,6.90722,-0.77182>,<0.70282,6.85234,-0.8349>,<0.7289,6.81722,-0.75244>,
            
    /*3*/ <1.01741,6.90413,-0.93973>,<0.98238,6.8566,-0.99802>,<1.02151,6.82147,-0.93383>,
            
    /*4*/ <1.27005,7.00041,-1.10441>,<1.249,6.96091,-1.16158>,<1.2926,6.93175,-1.11138>,
            
    /*5*/ <1.48193,7.20531,-1.21016>,<1.47837,7.18047,-1.2671>,<1.51973,7.15853,-1.22611>,
            
    /*6*/ <1.69362,7.42321,-1.33887>,<1.6891,7.4012,-1.38561>,<1.7258,7.38499,-1.35275>,
            
    /*7*/ <1.83048,7.69953,-1.42976>,<1.83037,7.68723,-1.46938>,<1.86302,7.67894,-1.44517>,
            
    /*8*/ <1.95143,7.98882,-1.52939>,<1.95117,7.97929,-1.559>,<1.97645,7.97477,-1.54143>,
            
    /*9*/ <2.07938,8.2822,-1.60359>,<2.07984,8.27727,-1.62374>,<2.09621,8.27318,-1.61168>,
            
    /*10*/ <2.14396,8.5972,-1.66746>,<2.14431,8.59523,-1.67764>,<2.15295,8.59462,-1.67193>,
            
    /*11*/ <2.19642,8.91373,-1.74294>

    /* stem 0.7.2.0*/ 
    /*0*/ <0.6717,6.87305,-0.76341>,
    /*1*/ <0.66044,6.8619,-0.78285>,<0.69018,6.86129,-0.75118>,<0.6645,6.89598,-0.7562>,
            
    /*2*/ <1.51145,7.38206,-1.54221>

    /* stem 0.7.2.1*/ 
    /*0*/ <0.83001,6.8596,-0.84984>,
    /*1*/ <0.8422,6.85329,-0.82979>,<0.83769,6.87827,-0.86336>,<0.81014,6.84723,-0.85637>,
            
    /*2*/ <1.51389,6.10552,-1.50301>

    /* stem 0.7.2.2*/ 
    /*0*/ <0.95557,6.8604,-0.92596>,
    /*1*/ <0.94846,6.87979,-0.93749>,<0.96589,6.84271,-0.9378>,<0.95238,6.85871,-0.90257>,
            
    /*2*/ <2.00639,7.35289,-0.7465>

    /* stem 0.7.2.3*/ 
    /*0*/ <1.09302,6.89453,-1.01218>,
    /*1*/ <1.09799,6.87285,-1.01774>,<1.10965,6.90865,-1.00512>,<1.07143,6.90209,-1.01366>,
            
    /*2*/ <1.27814,7.21231,-2.08492>

    /* stem 0.7.2.4*/ 
    /*0*/ <1.42716,7.11695,-1.20217>,
    /*1*/ <1.42567,7.1275,-1.18415>,<1.42586,7.12715,-1.22041>,<1.42995,7.0962,-1.20196>,
            
    /*2*/ <2.44316,7.25364,-1.19821>

    /* stem 0.7.2.5*/ 
    /*0*/ <1.53603,7.2266,-1.25985>,
    /*1*/ <1.52675,7.2253,-1.27775>,<1.55599,7.22376,-1.25858>,<1.52533,7.23076,-1.24321>,
            
    /*2*/ <1.68284,8.19015,-1.40596>

    /* stem 0.7.2.6*/ 
    /*0*/ <1.65557,7.35311,-1.33096>,
    /*1*/ <1.67011,7.34489,-1.32114>,<1.65219,7.37211,-1.32916>,<1.64441,7.34234,-1.34257>,
            
    /*2*/ <2.23765,7.52473,-2.04939>

    /* stem 0.7.2.7*/ 
    /*0*/ <1.79998,7.6034,-1.42154>,
    /*1*/ <1.78464,7.61203,-1.41772>,<1.80758,7.60529,-1.43775>,<1.80771,7.59288,-1.40914>,
            
    /*2*/ <2.25424,8.28174,-1.12937>

    /* stem 0.7.2.8*/ 
    /*0*/ <1.88224,7.7897,-1.48102>,
    /*1*/ <1.89007,7.78224,-1.4942>,<1.89102,7.7999,-1.47055>,<1.86563,7.78696,-1.47831>,
            
    /*2*/ <1.69965,8.43054,-1.9523>

    /* stem 0.7.2.9*/ 
    /*0*/ <2.0305,8.14836,-1.58263>,
    /*1*/ <2.03252,8.15085,-1.5684>,<2.02517,8.1589,-1.59119>,<2.0338,8.13534,-1.5883>,
            
    /*2*/ <2.6995,8.37696,-1.71785>

    /* stem 0.7.2.10*/ 
    /*0*/ <2.09698,8.33837,-1.62435>,
    /*1*/ <2.08908,8.33853,-1.63175>,<2.10607,8.34403,-1.62601>,<2.0958,8.33255,-1.61529>,
            
    /*2*/ <1.82225,8.86844,-1.31978>

    /* stem 0.7.2.11*/ 
    /*0*/ <2.13419,8.52948,-1.66>,
    /*1*/ <2.14129,8.52819,-1.6595>,<2.13141,8.53557,-1.65725>,<2.12986,8.52468,-1.66324>,
            
    /*2*/ <2.22464,8.81668,-2.20509>

    /* stem 0.7.2.12*/ 
    /*0*/ <2.18093,8.81388,-1.72077>,
    /*1*/ <2.17947,8.81434,-1.71968>,<2.18116,8.81471,-1.72244>,<2.18216,8.81258,-1.72019>,
            
    /*2*/ <2.48557,9.20775,-1.48249>

    /* stem 0.7.3*/ 
    /*0*/ <0.66369,6.94671,-0.99716>,
    /*1*/ <0.62066,6.92359,-1.02759>,<0.71622,6.92328,-0.99922>,<0.6542,6.99326,-0.96468>,
            
    /*2*/ <0.6981,7.11132,-1.26886>,<0.7841,7.11104,-1.24333>,<0.72828,7.17402,-1.21224>,
            
    /*3*/ <0.76627,7.31567,-1.50028>,<0.84309,7.31621,-1.47887>,<0.79248,7.36906,-1.44715>,
            
    /*4*/ <0.76769,7.54317,-1.71219>,<0.83641,7.55186,-1.70378>,<0.79159,7.58866,-1.66498>,
            
    /*5*/ <0.79325,7.80471,-1.89687>,<0.85193,7.80792,-1.88576>,<0.81318,7.83661,-1.85037>,
            
    /*6*/ <0.87707,8.08371,-2.03728>,<0.92423,8.07788,-2.02224>,<0.89167,8.10215,-1.99334>,
            
    /*7*/ <0.95244,8.3675,-2.15466>,<0.99023,8.3631,-2.14273>,<0.96354,8.38019,-2.11853>,
            
    /*8*/ <1.02332,8.65366,-2.26679>,<1.05173,8.6506,-2.25795>,<1.03157,8.66281,-2.23954>,
            
    /*9*/ <1.09049,8.95637,-2.33298>,<1.10931,8.95386,-2.3269>,<1.09536,8.95978,-2.31394>,
            
    /*10*/ <1.10996,9.25521,-2.42555>,<1.11958,9.25554,-2.42298>,<1.11257,9.25805,-2.41635>,
            
    /*11*/ <1.20277,9.54763,-2.50317>

    /* stem 0.7.3.0*/ 
    /*0*/ <0.71293,7.07154,-1.16165>,
    /*1*/ <0.73658,7.06805,-1.15722>,<0.70491,7.09352,-1.16827>,<0.6973,7.05305,-1.15946>,
            
    /*2*/ <0.88864,6.78542,-2.32441>

    /* stem 0.7.3.1*/ 
    /*0*/ <0.7692,7.2344,-1.36022>,
    /*1*/ <0.75172,7.24795,-1.35331>,<0.77193,7.22958,-1.38271>,<0.78395,7.22567,-1.34463>,
            
    /*2*/ <1.4392,8.15822,-1.47678>

    /* stem 0.7.3.2*/ 
    /*0*/ <0.80024,7.37565,-1.51571>,
    /*1*/ <0.80409,7.36051,-1.53153>,<0.80968,7.39574,-1.51701>,<0.78695,7.3707,-1.49859>,
            
    /*2*/ <-0.06392,7.74515,-2.07937>

    /* stem 0.7.3.3*/ 
    /*0*/ <0.79901,7.51213,-1.64658>,
    /*1*/ <0.80972,7.52501,-1.63325>,<0.78431,7.52029,-1.65983>,<0.80299,7.4911,-1.64665>,
            
    /*2*/ <1.5385,7.65493,-2.37894>

    /* stem 0.7.3.4*/ 
    /*0*/ <0.81312,7.7391,-1.82192>,
    /*1*/ <0.79431,7.73599,-1.82836>,<0.827,7.74642,-1.83453>,<0.81806,7.73488,-1.80286>,
            
    /*2*/ <0.57154,8.65276,-1.55714>

    /* stem 0.7.3.5*/ 
    /*0*/ <0.84466,7.90394,-1.92279>,
    /*1*/ <0.86245,7.89723,-1.92588>,<0.84205,7.92238,-1.9179>,<0.8295,7.89222,-1.92459>,
            
    /*2*/ <0.77444,8.13349,-2.82554>

    /* stem 0.7.3.6*/ 
    /*0*/ <0.94545,8.27776,-2.09899>,
    /*1*/ <0.93615,8.28544,-2.08652>,<0.94234,8.28145,-2.11566>,<0.95785,8.26638,-2.09479>,
            
    /*2*/ <1.50119,8.89599,-2.06551>

    /* stem 0.7.3.7*/ 
    /*0*/ <0.99811,8.49574,-2.18969>,
    /*1*/ <0.99634,8.49001,-2.2048>,<1.01029,8.50593,-2.18624>,<0.98769,8.49129,-2.17804>,
            
    /*2*/ <0.54456,9.09782,-2.36502>

    /* stem 0.7.3.8*/ 
    /*0*/ <1.05129,8.7311,-2.27226>,
    /*1*/ <1.06164,8.73149,-2.26129>,<1.04119,8.74224,-2.2735>,<1.05104,8.71957,-2.282>,
            
    /*2*/ <1.49481,9.08529,-2.70302>

    /* stem 0.7.3.9*/ 
    /*0*/ <1.07939,8.86571,-2.3035>,
    /*1*/ <1.06647,8.86798,-2.30535>,<1.0883,8.87103,-2.31174>,<1.08341,8.85812,-2.29341>,
            
    /*2*/ <1.11897,9.41462,-1.9063>

    /* stem 0.7.3.10*/ 
    /*0*/ <1.10575,9.09761,-2.37025>,
    /*1*/ <1.11293,9.09571,-2.37497>,<1.10518,9.1053,-2.366>,<1.09913,9.09183,-2.36978>,
            
    /*2*/ <0.845,9.355,-2.8707>

    /* stem 0.7.3.11*/ 
    /*0*/ <1.17537,9.45766,-2.47799>,
    /*1*/ <1.17491,9.45825,-2.47637>,<1.17478,9.4585,-2.47944>,<1.1764,9.45623,-2.47815>,
            
    /*2*/ <1.60318,9.76676,-2.47052>

    /* stem 0.7.4*/ 
    /*0*/ <0.82823,6.9697,-1.20544>,
    /*1*/ <0.87045,6.95362,-1.17229>,<0.8262,7.02228,-1.2247>,<0.78804,6.93321,-1.21932>,
            
    /*2*/ <1.02751,6.87127,-1.4218>,<0.98768,6.93306,-1.46896>,<0.95335,6.8529,-1.46412>,
            
    /*3*/ <1.1713,6.86953,-1.70136>,<1.1265,6.92808,-1.72571>,<1.10409,6.85465,-1.73725>,
            
    /*4*/ <1.24882,6.98294,-1.99022>,<1.20046,7.03034,-1.98487>,<1.18613,6.97024,-2.0131>,
            
    /*5*/ <1.32122,7.15676,-2.23376>,<1.27743,7.19325,-2.22188>,<1.26863,7.14768,-2.25704>,
            
    /*6*/ <1.39656,7.36404,-2.44648>,<1.35894,7.39192,-2.43374>,<1.35362,7.35833,-2.46834>,
            
    /*7*/ <1.51815,7.59829,-2.59329>,<1.48795,7.62076,-2.58378>,<1.48729,7.60029,-2.61676>,
            
    /*8*/ <1.64675,7.82517,-2.75261>,<1.62464,7.84294,-2.74605>,<1.62356,7.82664,-2.77014>,
            
    /*9*/ <1.70377,8.08006,-2.92013>,<1.68769,8.08849,-2.91327>,<1.68693,8.07797,-2.92956>,
            
    /*10*/ <1.74175,8.34179,-3.0756>,<1.7336,8.34542,-3.07179>,<1.73328,8.3405,-3.08015>,
            
    /*11*/ <1.76237,8.61705,-3.20869>

    /* stem 0.7.4.0*/ 
    /*0*/ <0.92954,6.91696,-1.36008>,
    /*1*/ <0.92184,6.93618,-1.37168>,<0.93084,6.89608,-1.37127>,<0.93594,6.91863,-1.3373>,
            
    /*2*/ <2.03423,7.16152,-1.6883>

    /* stem 0.7.4.1*/ 
    /*0*/ <1.03239,6.88525,-1.5317>,
    /*1*/ <1.0292,6.8627,-1.53327>,<1.05161,6.89465,-1.53967>,<1.01634,6.89842,-1.52217>,
            
    /*2*/ <0.54638,7.02417,-2.54119>

    /* stem 0.7.4.2*/ 
    /*0*/ <1.14569,6.90073,-1.76283>,
    /*1*/ <1.15989,6.91415,-1.7534>,<1.1338,6.90757,-1.77963>,<1.14339,6.88046,-1.75545>,
            
    /*2*/ <1.90449,6.56963,-2.43474>

    /* stem 0.7.4.3*/ 
    /*0*/ <1.19011,6.96374,-1.91954>,
    /*1*/ <1.17005,6.9632,-1.92544>,<1.20488,6.95563,-1.93195>,<1.19541,6.97237,-1.90124>,
            
    /*2*/ <1.30151,7.8718,-2.38025>

    /* stem 0.7.4.4*/ 
    /*0*/ <1.26896,7.12126,-2.17467>,
    /*1*/ <1.2855,7.11104,-2.17663>,<1.26948,7.1408,-2.17472>,<1.2519,7.11195,-2.17266>,
            
    /*2*/ <1.15757,7.12186,-3.11764>

    /* stem 0.7.4.5*/ 
    /*0*/ <1.34853,7.31744,-2.39384>,
    /*1*/ <1.34154,7.33073,-2.3836>,<1.34302,7.31536,-2.41104>,<1.36101,7.30621,-2.38687>,
            
    /*2*/ <1.984,7.85778,-2.6622>

    /* stem 0.7.4.6*/ 
    /*0*/ <1.44426,7.50822,-2.53591>,
    /*1*/ <1.44129,7.50046,-2.55076>,<1.45946,7.51522,-2.53286>,<1.43202,7.50897,-2.52411>,
            
    /*2*/ <1.1835,8.212,-2.85154>

    /* stem 0.7.4.7*/ 
    /*0*/ <1.57509,7.73644,-2.68936>,
    /*1*/ <1.58622,7.73751,-2.67844>,<1.56726,7.74923,-2.69382>,<1.57177,7.7226,-2.69583>,
            
    /*2*/ <2.08048,7.86175,-3.2167>

    /* stem 0.7.4.8*/ 
    /*0*/ <1.63948,7.86366,-2.77735>,
    /*1*/ <1.62492,7.86646,-2.77849>,<1.64817,7.8645,-2.78938>,<1.64534,7.86001,-2.76419>,
            
    /*2*/ <1.75951,8.54079,-2.64321>

    /* stem 0.7.4.9*/ 
    /*0*/ <1.67198,7.99685,-2.8649>,
    /*1*/ <1.68148,7.99038,-2.87121>,<1.67405,8.00909,-2.86069>,<1.66039,7.99107,-2.8628>,
            
    /*2*/ <1.44977,8.2328,-3.44168>

    /* stem 0.7.4.10*/ 
    /*0*/ <1.70404,8.14959,-2.96108>,
    /*1*/ <1.70268,8.1547,-2.95288>,<1.69898,8.15183,-2.96912>,<1.71046,8.14225,-2.96125>,
            
    /*2*/ <2.14899,8.54235,-3.13185>

    /* stem 0.7.4.11*/ 
    /*0*/ <1.75145,8.50244,-3.15322>,
    /*1*/ <1.75023,8.50167,-3.15506>,<1.75343,8.50364,-3.15355>,<1.75068,8.50202,-3.15105>,
            
    /*2*/ <1.48161,8.94726,-3.16279>

    /* stem 0.7.5*/ 
    /*0*/ <1.05529,7.01102,-1.47463>,
    /*1*/ <1.02929,7.0559,-1.48967>,<1.05869,6.96913,-1.50854>,<1.0779,7.00803,-1.42568>,
            
    /*2*/ <1.2822,7.1599,-1.59714>,<1.30865,7.0818,-1.61412>,<1.32595,7.11682,-1.53955>,
            
    /*3*/ <1.51289,7.31981,-1.65485>,<1.55175,7.2588,-1.67401>,<1.55266,7.28304,-1.60322>,
            
    /*4*/ <1.71402,7.49975,-1.75339>,<1.75115,7.4493,-1.77245>,<1.75829,7.47434,-1.71238>,
            
    /*5*/ <1.91437,7.69657,-1.83559>,<1.94877,7.65571,-1.85281>,<1.95183,7.67459,-1.80005>,
            
    /*6*/ <2.09111,7.91945,-1.89454>,<2.12395,7.89017,-1.91037>,<2.12342,7.90253,-1.86527>,
            
    /*7*/ <2.2672,8.15492,-1.8891>,<2.2959,8.13451,-1.90173>,<2.29014,8.13792,-1.86492>,
            
    /*8*/ <2.43596,8.39388,-1.90472>,<2.45748,8.3786,-1.91427>,<2.4543,8.38266,-1.88669>,
            
    /*9*/ <2.55294,8.64855,-1.98082>,<2.56807,8.63989,-1.98763>,<2.56769,8.64539,-1.96975>,
            
    /*10*/ <2.63361,8.9097,-2.08455>,<2.64138,8.90601,-2.08822>,<2.64149,8.90943,-2.07951>,
            
    /*11*/ <2.66558,9.18521,-2.1787>

    /* stem 0.7.5.0*/ 
    /*0*/ <1.22581,7.08492,-1.54887>,
    /*1*/ <1.2312,7.06431,-1.55698>,<1.24131,7.09707,-1.53739>,<1.2049,7.09338,-1.55223>,
            
    /*2*/ <1.57117,7.55519,-2.51313>

    /* stem 0.7.5.1*/ 
    /*0*/ <1.42553,7.20565,-1.61464>,
    /*1*/ <1.4235,7.21542,-1.59534>,<1.43152,7.21715,-1.63207>,<1.42157,7.18436,-1.61651>,
            
    /*2*/ <2.4511,6.99625,-1.40076>

    /* stem 0.7.5.2*/ 
    /*0*/ <1.63095,7.37234,-1.69042>,
    /*1*/ <1.62165,7.37241,-1.7087>,<1.65138,7.37087,-1.6893>,<1.61982,7.37374,-1.67324>,
            
    /*2*/ <1.70449,8.37108,-1.72405>

    /* stem 0.7.5.3*/ 
    /*0*/ <1.8681,7.60398,-1.79978>,
    /*1*/ <1.88163,7.59464,-1.79033>,<1.8668,7.62284,-1.79831>,<1.85588,7.59446,-1.81071>,
            
    /*2*/ <2.4345,7.69905,-2.51614>

    /* stem 0.7.5.4*/ 
    /*0*/ <1.971,7.71839,-1.84083>,
    /*1*/ <1.95713,7.72982,-1.83765>,<1.98181,7.72096,-1.8553>,<1.97405,7.70439,-1.82953>,
            
    /*2*/ <2.50068,8.22579,-1.35491>

    /* stem 0.7.5.5*/ 
    /*0*/ <2.05088,7.82296,-1.86856>,
    /*1*/ <2.05815,7.81389,-1.88183>,<2.06108,7.83241,-1.8577>,<2.03341,7.82258,-1.86614>,
            
    /*2*/ <1.9661,8.49681,-2.37563>

    /* stem 0.7.5.6*/ 
    /*0*/ <2.18633,8.00618,-1.888>,
    /*1*/ <2.18611,8.006,-1.8714>,<2.18582,8.02063,-1.89616>,<2.18706,7.9919,-1.89645>,
            
    /*2*/ <2.97787,8.04025,-1.87708>

    /* stem 0.7.5.7*/ 
    /*0*/ <2.33116,8.21124,-1.88997>,
    /*1*/ <2.32257,8.21627,-1.90181>,<2.34655,8.21255,-1.89049>,<2.32434,8.20491,-1.87762>,
            
    /*2*/ <2.28562,8.8714,-1.57689>

    /* stem 0.7.5.8*/ 
    /*0*/ <2.50917,8.52191,-1.94276>,
    /*1*/ <2.52148,8.51704,-1.94101>,<2.50544,8.53306,-1.93644>,<2.5006,8.51562,-1.95084>,
            
    /*2*/ <2.71927,8.87421,-2.4397>

    /* stem 0.7.5.9*/ 
    /*0*/ <2.6124,8.81657,-2.04765>,
    /*1*/ <2.60707,8.81965,-2.04377>,<2.61342,8.81849,-2.0546>,<2.61672,8.81157,-2.04459>,
            
    /*2*/ <2.96733,9.22433,-1.88315>

    /* stem 0.7.5.10*/ 
    /*0*/ <2.65715,9.09794,-2.14888>,
    /*1*/ <2.65743,9.09738,-2.15046>,<2.65813,9.09917,-2.14822>,<2.65588,9.09729,-2.14795>,
            
    /*2*/ <2.35061,9.43966,-2.32658>

    /* stem 0.7.6*/ 
    /*0*/ <1.36155,7.10822,-1.81368>,
    /*1*/ <1.36459,7.05865,-1.82658>,<1.40331,7.13304,-1.79717>,<1.31674,7.13297,-1.81728>,
            
    /*2*/ <1.42488,7.1353,-2.0865>,<1.45973,7.20225,-2.06003>,<1.38182,7.20219,-2.07813>,
            
    /*3*/ <1.53332,7.27366,-2.31484>,<1.55631,7.32639,-2.27306>,<1.49139,7.3296,-2.30188>,
            
    /*4*/ <1.62854,7.44149,-2.52177>,<1.64641,7.48416,-2.48017>,<1.58923,7.48654,-2.50457>,
            
    /*5*/ <1.71546,7.64225,-2.70148>,<1.72835,7.67419,-2.66077>,<1.67946,7.6764,-2.68195>,
            
    /*6*/ <1.84135,7.85939,-2.82899>,<1.84793,7.87942,-2.78987>,<1.8108,7.88739,-2.81295>,
            
    /*7*/ <1.95602,8.09128,-2.93636>,<1.96,8.10504,-2.90383>,<1.93022,8.11124,-2.92224>,
            
    /*8*/ <2.04895,8.35201,-2.99146>,<2.04978,8.35763,-2.96541>,<2.02763,8.36256,-2.97941>,
            
    /*9*/ <2.13161,8.59428,-3.09291>,<2.1333,8.60088,-3.07649>,<2.11788,8.60252,-3.08519>,
            
    /*10*/ <2.21348,8.84369,-3.18451>,<2.21421,8.84667,-3.17617>,<2.20654,8.84758,-3.18056>,
            
    /*11*/ <2.28068,9.10762,-3.24198>

    /* stem 0.7.6.0*/ 
    /*0*/ <1.40301,7.15727,-1.99239>,
    /*1*/ <1.41559,7.17331,-1.98507>,<1.39,7.1606,-2.0094>,<1.40343,7.1379,-1.98271>,
            
    /*2*/ <2.18151,6.84634,-2.64876>

    /* stem 0.7.6.1*/ 
    /*0*/ <1.45228,7.21726,-2.1386>,
    /*1*/ <1.43402,7.21499,-2.14857>,<1.47025,7.21389,-2.14878>,<1.45256,7.22291,-2.11846>,
            
    /*2*/ <1.4805,8.20324,-2.41549>

    /* stem 0.7.6.2*/ 
    /*0*/ <1.58075,7.40146,-2.41364>,
    /*1*/ <1.59807,7.39295,-2.41235>,<1.57946,7.42076,-2.41406>,<1.56471,7.39068,-2.41451>,
            
    /*2*/ <1.64258,7.38512,-3.35056>

    /* stem 0.7.6.3*/ 
    /*0*/ <1.67672,7.59474,-2.617>,
    /*1*/ <1.66684,7.60711,-2.60841>,<1.67715,7.59447,-2.63502>,<1.68619,7.58264,-2.60759>,
            
    /*2*/ <2.35722,8.13309,-2.60899>

    /* stem 0.7.6.4*/ 
    /*0*/ <1.73941,7.71748,-2.71396>,
    /*1*/ <1.73953,7.70842,-2.72865>,<1.75358,7.72595,-2.70893>,<1.72512,7.71807,-2.7043>,
            
    /*2*/ <1.48661,8.38675,-3.12883>

    /* stem 0.7.6.5*/ 
    /*0*/ <1.79526,7.81135,-2.77141>,
    /*1*/ <1.80474,7.81397,-2.75791>,<1.78638,7.8239,-2.77793>,<1.79465,7.79619,-2.77838>,
            
    /*2*/ <2.4107,8.00257,-3.24099>

    /* stem 0.7.6.6*/ 
    /*0*/ <1.90809,8.02248,-2.88197>,
    /*1*/ <1.89434,8.02662,-2.88784>,<1.92053,8.0217,-2.89119>,<1.90938,8.01913,-2.86689>,
            
    /*2*/ <2.0587,8.72643,-2.7385>

    /* stem 0.7.6.7*/ 
    /*0*/ <2.00996,8.26961,-2.9588>,
    /*1*/ <2.02239,8.26411,-2.96298>,<2.00968,8.27979,-2.94887>,<1.99782,8.26494,-2.96454>,
            
    /*2*/ <2.05578,8.73479,-3.43448>

    /* stem 0.7.6.8*/ 
    /*0*/ <2.08001,8.46458,-3.02579>,
    /*1*/ <2.07488,8.47091,-3.0155>,<2.07728,8.4686,-3.03798>,<2.08786,8.45425,-3.02388>,
            
    /*2*/ <2.56797,8.8377,-3.01203>

    /* stem 0.7.6.9*/ 
    /*0*/ <2.17345,8.73423,-3.13714>,
    /*1*/ <2.17162,8.73217,-3.14407>,<2.17941,8.73856,-3.136>,<2.16932,8.73196,-3.13136>,
            
    /*2*/ <1.86317,9.17458,-3.18591>

    /* stem 0.7.6.10*/ 
    /*0*/ <2.24792,8.98386,-3.21286>,
    /*1*/ <2.24979,8.98373,-3.21132>,<2.24639,8.98575,-3.21276>,<2.24757,8.98211,-3.2145>,
            
    /*2*/ <2.52036,9.22069,-3.52253>

    /* stem 0.7.7*/ 
    /*0*/ <1.73418,7.2884,-2.22631>,
    /*1*/ <1.75251,7.31888,-2.19419>,<1.71671,7.30491,-2.26777>,<1.73332,7.2414,-2.21697>,
            
    /*2*/ <1.98274,7.29011,-2.30544>,<1.95052,7.27753,-2.37165>,<1.96547,7.22037,-2.32593>,
            
    /*3*/ <2.19206,7.33785,-2.43929>,<2.15926,7.32768,-2.49613>,<2.19006,7.27711,-2.46607>,
            
    /*4*/ <2.36972,7.45485,-2.57539>,<2.33951,7.44593,-2.62422>,<2.37866,7.40672,-2.60671>,
            
    /*5*/ <2.52716,7.61653,-2.6875>,<2.50354,7.61064,-2.73095>,<2.54196,7.58116,-2.71929>,
            
    /*6*/ <2.64436,7.82414,-2.77025>,<2.62576,7.82072,-2.80719>,<2.66247,7.80249,-2.80068>,
            
    /*7*/ <2.70746,8.05318,-2.87142>,<2.69064,8.04614,-2.89917>,<2.72282,8.03834,-2.89684>,
            
    /*8*/ <2.77629,8.27063,-2.9944>,<2.76324,8.26386,-3.01451>,<2.78721,8.25742,-3.01246>,
            
    /*9*/ <2.84033,8.49669,-3.09617>,<2.83193,8.49313,-3.11003>,<2.84799,8.48913,-3.10881>,
            
    /*10*/ <2.92856,8.70571,-3.21957>,<2.92429,8.70366,-3.22638>,<2.93207,8.70095,-3.2254>,
            
    /*11*/ <2.99533,8.90628,-3.36714>

    /* stem 0.7.7.0*/ 
    /*0*/ <1.90886,7.26903,-2.30762>,
    /*1*/ <1.90036,7.26912,-2.3259>,<1.92159,7.25427,-2.3025>,<1.90462,7.2837,-2.29447>,
            
    /*2*/ <2.66107,7.7974,-2.65475>

    /* stem 0.7.7.1*/ 
    /*0*/ <2.11531,7.29854,-2.42677>,
    /*1*/ <2.12502,7.28627,-2.41586>,<2.12368,7.31454,-2.43291>,<2.09722,7.2948,-2.43153>,
            
    /*2*/ <2.40639,6.85544,-3.18398>

    /* stem 0.7.7.2*/ 
    /*0*/ <2.22624,7.34478,-2.50108>,
    /*1*/ <2.21743,7.36078,-2.49855>,<2.23142,7.33969,-2.51802>,<2.22987,7.33387,-2.48666>,
            
    /*2*/ <3.00698,7.75642,-2.38609>

    /* stem 0.7.7.3*/ 
    /*0*/ <2.40321,7.47776,-2.62985>,
    /*1*/ <2.40611,7.4665,-2.64263>,<2.41651,7.48484,-2.62139>,<2.38701,7.48194,-2.62553>,
            
    /*2*/ <2.41857,8.1008,-3.17549>

    /* stem 0.7.7.4*/ 
    /*0*/ <2.56108,7.66821,-2.7372>,
    /*1*/ <2.56604,7.67106,-2.7222>,<2.55586,7.68032,-2.74636>,<2.56133,7.65326,-2.74303>,
            
    /*2*/ <3.27117,7.78014,-2.99334>

    /* stem 0.7.7.5*/ 
    /*0*/ <2.68801,7.97637,-2.86001>,
    /*1*/ <2.67572,7.97656,-2.86755>,<2.70053,7.97921,-2.86656>,<2.68777,7.97334,-2.84592>,
            
    /*2*/ <2.61231,8.63463,-2.71987>

    /* stem 0.7.7.6*/ 
    /*0*/ <2.74924,8.18025,-2.96184>,
    /*1*/ <2.76176,8.17579,-2.96281>,<2.74694,8.19298,-2.95864>,<2.73903,8.17199,-2.96406>,
            
    /*2*/ <2.75691,8.33275,-3.56332>

    /* stem 0.7.7.7*/ 
    /*0*/ <2.80783,8.37846,-3.05606>,
    /*1*/ <2.80061,8.38387,-3.04817>,<2.80879,8.38274,-3.06721>,<2.81409,8.36878,-3.0528>,
            
    /*2*/ <3.23595,8.71028,-2.89188>

    /* stem 0.7.7.8*/ 
    /*0*/ <2.89147,8.61556,-3.17418>,
    /*1*/ <2.89111,8.61234,-3.18016>,<2.89713,8.6189,-3.17246>,<2.88617,8.61544,-3.16994>,
            
    /*2*/ <2.71191,9.03,-3.38669>

    /* stem 0.7.7.9*/ 
    /*0*/ <2.95532,8.78519,-3.28155>,
    /*1*/ <2.95728,8.78592,-3.2796>,<2.95337,8.7871,-3.28241>,<2.9553,8.78254,-3.28265>,
            
    /*2*/ <3.23127,8.91837,-3.60906>

    /* stem 0.7.8*/ 
    /*0*/ <2.16176,7.59317,-2.68031>,
    /*1*/ <2.13082,7.5919,-2.71139>,<2.19947,7.57152,-2.68602>,<2.15497,7.6161,-2.64354>,
            
    /*2*/ <2.22706,7.7807,-2.80872>,<2.28884,7.76236,-2.78589>,<2.24879,7.80248,-2.74766>,
            
    /*3*/ <2.27897,7.96476,-2.92758>,<2.33778,7.95798,-2.91381>,<2.30185,7.99145,-2.878>,
            
    /*4*/ <2.31963,8.15785,-3.04915>,<2.37169,8.15436,-3.0389>,<2.33992,8.1817,-3.00617>,
            
    /*5*/ <2.38078,8.36042,-3.1553>,<2.4245,8.3539,-3.14417>,<2.397,8.37691,-3.11602>,
            
    /*6*/ <2.43771,8.54787,-3.27842>,<2.47439,8.54319,-3.26973>,<2.45219,8.56453,-3.2475>,
            
    /*7*/ <2.47755,8.73665,-3.40665>,<2.50737,8.73472,-3.40111>,<2.48952,8.75101,-3.38269>,
            
    /*8*/ <2.51721,8.93183,-3.52864>,<2.53957,8.93035,-3.52446>,<2.52606,8.94197,-3.51025>,
            
    /*9*/ <2.58566,9.13493,-3.62593>,<2.6001,9.1322,-3.62204>,<2.59098,9.13981,-3.61256>,
            
    /*10*/ <2.66829,9.34189,-3.69804>,<2.67531,9.34,-3.69584>,<2.67064,9.34354,-3.69101>,
            
    /*11*/ <2.77439,9.53564,-3.77361>

    /* stem 0.7.8.0*/ 
    /*0*/ <2.20073,7.67212,-2.72234>,
    /*1*/ <2.21796,7.66545,-2.7189>,<2.19696,7.69031,-2.7195>,<2.18728,7.6606,-2.72863>,
            
    /*2*/ <2.44334,7.85637,-3.57901>

    /* stem 0.7.8.1*/ 
    /*0*/ <2.28758,7.90262,-2.86085>,
    /*1*/ <2.27502,7.91155,-2.85251>,<2.28806,7.90246,-2.87836>,<2.29967,7.89386,-2.85167>,
            
    /*2*/ <2.77781,8.58596,-2.85399>

    /* stem 0.7.8.2*/ 
    /*0*/ <2.32868,8.0871,-2.98128>,
    /*1*/ <2.33074,8.07793,-2.99485>,<2.33999,8.0984,-2.97716>,<2.31531,8.08498,-2.97183>,
            
    /*2*/ <1.94348,8.62733,-3.40493>

    /* stem 0.7.8.3*/ 
    /*0*/ <2.37523,8.27458,-3.09054>,
    /*1*/ <2.38309,8.27909,-3.07797>,<2.36443,8.28385,-3.09667>,<2.37817,8.26079,-3.09698>,
            
    /*2*/ <2.88416,8.58359,-3.51955>

    /* stem 0.7.8.4*/ 
    /*0*/ <2.424,8.44471,-3.19304>,
    /*1*/ <2.41045,8.44501,-3.19836>,<2.43533,8.44729,-3.20181>,<2.42622,8.44181,-3.17894>,
            
    /*2*/ <2.38263,9.11288,-3.04926>

    /* stem 0.7.8.5*/ 
    /*0*/ <2.50682,8.82314,-3.4496>,
    /*1*/ <2.51809,8.81902,-3.45275>,<2.50526,8.83498,-3.44624>,<2.49711,8.81542,-3.44981>,
            
    /*2*/ <2.40593,8.96492,-3.99567>

    /* stem 0.7.8.6*/ 
    /*0*/ <2.54928,9.00208,-3.55433>,
    /*1*/ <2.54403,9.00787,-3.54602>,<2.54846,9.00562,-3.56515>,<2.55536,8.99276,-3.55183>,
            
    /*2*/ <2.97538,9.29706,-3.49039>

    /* stem 0.7.8.7*/ 
    /*0*/ <2.63864,9.25646,-3.664>,
    /*1*/ <2.63771,9.25469,-3.66987>,<2.64378,9.25958,-3.66248>,<2.63443,9.25511,-3.65965>,
            
    /*2*/ <2.42665,9.64686,-3.74834>

    /* stem 0.7.8.8*/ 
    /*0*/ <2.70531,9.40562,-3.72086>,
    /*1*/ <2.70733,9.40542,-3.71873>,<2.70433,9.40826,-3.7217>,<2.70428,9.40319,-3.72214>,
            
    /*2*/ <3.00411,9.42692,-4.00165>

    /* stem 0.7.9*/ 
    /*0*/ <2.47307,7.86692,-3.03616>,
    /*1*/ <2.50488,7.84723,-3.02484>,<2.4724,7.90594,-3.03389>,<2.44192,7.8476,-3.04974>,
            
    /*2*/ <2.5804,7.8621,-3.22479>,<2.55116,7.91494,-3.23294>,<2.52373,7.86243,-3.2472>,
            
    /*3*/ <2.68177,7.93214,-3.39999>,<2.65139,7.97697,-3.40082>,<2.63518,7.93277,-3.4276>,
            
    /*4*/ <2.79055,8.02587,-3.5591>,<2.76197,8.06364,-3.55743>,<2.75152,8.02725,-3.58594>,
            
    /*5*/ <2.86683,8.16508,-3.71157>,<2.83784,8.19196,-3.70219>,<2.8312,8.16417,-3.73107>,
            
    /*6*/ <2.89729,8.34608,-3.83268>,<2.8705,8.36079,-3.81813>,<2.86655,8.34264,-3.84643>,
            
    /*7*/ <2.93001,8.52995,-3.93729>,<2.90845,8.54111,-3.9253>,<2.90562,8.52817,-3.94892>,
            
    /*8*/ <2.93,8.73026,-4.02031>,<2.91347,8.73504,-4.00953>,<2.91153,8.72732,-4.02821>,
            
    /*9*/ <2.89126,8.92717,-4.10111>,<2.88039,8.92852,-4.09314>,<2.87909,8.92319,-4.10551>,
            
    /*10*/ <2.85308,9.12425,-4.17599>,<2.84766,9.12484,-4.17197>,<2.84698,9.12233,-4.17823>,
            
    /*11*/ <2.78076,9.31783,-4.23503>

    /* stem 0.7.9.0*/ 
    /*0*/ <2.526,7.8756,-3.16988>,
    /*1*/ <2.52048,7.89112,-3.17105>,<2.52355,7.86501,-3.1823>,<2.53396,7.87068,-3.15627>,
            
    /*2*/ <3.24097,8.10435,-3.5055>

    /* stem 0.7.9.1*/ 
    /*0*/ <2.59025,7.90471,-3.29933>,
    /*1*/ <2.58783,7.89063,-3.30623>,<2.6049,7.91074,-3.29854>,<2.57801,7.91276,-3.29324>,
            
    /*2*/ <2.48088,8.26205,-3.99137>

    /* stem 0.7.9.2*/ 
    /*0*/ <2.70448,7.9869,-3.47778>,
    /*1*/ <2.71345,7.99324,-3.46775>,<2.69776,7.99526,-3.48808>,<2.70224,7.97221,-3.4775>,
            
    /*2*/ <3.27426,7.89165,-3.92704>

    /* stem 0.7.9.3*/ 
    /*0*/ <2.82481,8.13801,-3.67587>,
    /*1*/ <2.81228,8.13955,-3.68103>,<2.83526,8.13503,-3.68411>,<2.82689,8.13946,-3.66247>,
            
    /*2*/ <2.94071,8.78673,-3.76389>

    /* stem 0.7.9.4*/ 
    /*0*/ <2.8694,8.3031,-3.80123>,
    /*1*/ <2.88059,8.29848,-3.80503>,<2.86858,8.31501,-3.79696>,<2.85904,8.2958,-3.80172>,
            
    /*2*/ <2.75738,8.49996,-4.37134>

    /* stem 0.7.9.5*/ 
    /*0*/ <2.91703,8.66003,-3.98992>,
    /*1*/ <2.91253,8.66389,-3.98083>,<2.9142,8.66415,-3.99954>,<2.92435,8.65205,-3.98937>,
            
    /*2*/ <3.29427,9.00906,-3.95123>

    /* stem 0.7.9.6*/ 
    /*0*/ <2.90216,8.82181,-4.05684>,
    /*1*/ <2.89953,8.81777,-4.0655>,<2.90715,8.83037,-4.05668>,<2.8998,8.81729,-4.04835>,
            
    /*2*/ <2.49353,9.05978,-4.04372>

    /* stem 0.7.9.7*/ 
    /*0*/ <2.86116,9.05527,-4.14921>,
    /*1*/ <2.86546,9.05698,-4.1467>,<2.85688,9.05834,-4.14949>,<2.86113,9.0505,-4.15143>,
            
    /*2*/ <3.00161,9.21835,-4.50052>

    /* stem 0.7.9.8*/ 
    /*0*/ <2.82906,9.181,-4.19297>,
    /*1*/ <2.82646,9.18026,-4.1924>,<2.82969,9.18199,-4.19547>,<2.83102,9.18074,-4.19105>,
            
    /*2*/ <2.75565,9.53247,-4.07164>

    /* stem 0.8*/ 
    /*0*/ <-0.0299,7.2487,-0.12348>,
    /*1*/ <-0.13814,7.24855,-0.12358>,<-0.06347,7.34984,-0.14242>,<0.05759,7.31136,-0.13508>,
            <0.05775,7.18629,-0.11171>,<-0.06322,7.14746,-0.1046>,
    /*2*/ <-0.12862,7.36543,0.50171>,<-0.06105,7.4571,0.48466>,<0.04851,7.42227,0.4913>,
            <0.04865,7.30908,0.51246>,<-0.06082,7.27395,0.51889>,
    /*3*/ <-0.14112,7.50077,1.11973>,<-0.08068,7.58276,1.104>,<0.01732,7.55252,1.11423>,
            <0.01744,7.45184,1.13628>,<-0.08048,7.41986,1.13968>,
    /*4*/ <-0.07995,7.68897,1.73499>,<-0.02671,7.75815,1.70935>,<0.05956,7.72933,1.71096>,
            <0.05966,7.64234,1.7376>,<-0.02657,7.61739,1.75245>,
    /*5*/ <-0.01894,7.89523,2.33373>,<0.02704,7.95455,2.30941>,<0.10192,7.92981,2.31159>,
            <0.10222,7.85521,2.33726>,<0.02752,7.83385,2.35094>,
    /*6*/ <0.05857,8.15356,2.91188>,<0.097,8.20165,2.88593>,<0.1604,8.18073,2.88791>,
            <0.16117,8.11971,2.91508>,<0.09823,8.10292,2.92989>,
    /*7*/ <0.11922,8.44753,3.47118>,<0.15049,8.48606,3.44813>,<0.20265,8.46998,3.45188>,
            <0.20362,8.42151,3.47725>,<0.15206,8.40764,3.48918>,
    /*8*/ <0.13104,8.77052,4.01506>,<0.15536,8.80059,3.99714>,<0.19617,8.78995,4.00333>,
            <0.19708,8.7533,4.02507>,<0.15682,8.74129,4.03232>,
    /*9*/ <0.19559,9.14249,4.53091>,<0.21289,9.16201,4.51502>,<0.24204,9.15346,4.51812>,
            <0.24276,9.12865,4.53592>,<0.21405,9.12188,4.54383>,
    /*10*/ <0.25141,9.53547,5.02768>,<0.26181,9.54695,5.01766>,<0.27946,9.54206,5.0199>,
            <0.27997,9.52757,5.03131>,<0.26263,9.5235,5.03612>,
    /*11*/ <0.2822,9.9757,5.48513>,<0.28576,9.97942,5.4814>,<0.29187,9.97801,5.48248>,
            <0.29208,9.97342,5.48688>,<0.2861,9.97199,5.48852>,
    /*12*/ <0.28761,9.97571,5.48488>

    /* stem 0.8c0*/ 
    /*0*/ <-0.0028,7.68723,1.72907>,
    /*1*/ <-0.05329,7.6913,1.78758>,<-0.03668,7.75677,1.72664>,<0.02675,7.72614,1.66905>,
            <0.04934,7.64174,1.69441>,<-0.00013,7.62021,1.76767>,
    /*2*/ <0.40892,7.92584,2.15649>,<0.42333,7.98261,2.10364>,<0.47833,7.95605,2.05371>,
            <0.49791,7.88286,2.0757>,<0.45502,7.86419,2.13922>,
    /*3*/ <0.8554,8.22317,2.49967>,<0.86319,8.26862,2.45133>,<0.91094,8.24682,2.41001>,
            <0.93265,8.1879,2.43281>,<0.89833,8.17329,2.48823>,
    /*4*/ <1.27315,8.61747,2.77826>,<1.27324,8.64952,2.73392>,<1.31306,8.63221,2.70063>,
            <1.33758,8.58946,2.7244>,<1.31292,8.58035,2.77238>,
    /*5*/ <1.67017,9.07461,2.98283>,<1.6662,9.09522,2.94573>,<1.69681,9.08125,2.91956>,
            <1.7197,9.05201,2.94049>,<1.70324,9.04791,2.9796>,
    /*6*/ <2.02859,9.56349,3.1731>,<2.02485,9.57714,3.14603>,<2.04761,9.56819,3.12773>,
            <2.0654,9.54901,3.14348>,<2.05365,9.54611,3.17152>,
    /*7*/ <2.3947,10.04865,3.36189>,<2.39246,10.05692,3.34555>,<2.40608,10.05134,3.33443>,
            <2.41674,10.03962,3.34389>,<2.4097,10.03795,3.36087>,
    /*8*/ <2.77096,10.49921,3.605>,<2.77056,10.50254,3.59959>,<2.77534,10.50073,3.59581>,
            <2.77869,10.49628,3.59887>,<2.77599,10.49534,3.60455>,
    /*9*/ <2.77431,10.49882,3.60076>

    /* stem 0.8c0c0*/ 
    /*0*/ <2.04402,9.56079,3.15237>,
    /*1*/ <2.01919,9.5659,3.14668>,<2.04363,9.57836,3.13325>,<2.0686,9.56654,3.14625>,
            <2.0596,9.54676,3.16771>,<2.02907,9.54637,3.16798>,
    /*2*/ <2.02668,10.03216,3.57944>,<2.04144,10.03969,3.57133>,<2.05653,10.03255,3.57918>,
            <2.05109,10.0206,3.59215>,<2.03264,10.02036,3.59231>,
    /*3*/ <2.0299,10.51031,3.99873>,<2.03499,10.51285,3.99588>,<2.0402,10.51049,3.99868>,
            <2.03832,10.50649,4.00326>,<2.03196,10.50638,4.00329>,
    /*4*/ <2.03508,10.5093,3.99997>

    /* stem 0.8c0c0.0*/ 
    /*0*/ <2.03824,10.27864,3.79963>,
    /*1*/ <2.04055,10.27204,3.80727>,<2.02895,10.2832,3.79936>,<2.04523,10.28068,3.79227>,
            
    /*2*/ <2.10774,10.4164,3.91035>,<2.0973,10.42644,3.90323>,<2.11195,10.42417,3.89686>,
            
    /*3*/ <2.1958,10.57215,3.97749>,<2.18615,10.5805,3.97095>,<2.19815,10.57668,3.96408>,
            
    /*4*/ <2.27299,10.72665,4.05527>,<2.26452,10.73387,4.04948>,<2.27543,10.73125,4.04385>,
            
    /*5*/ <2.33992,10.89147,4.1229>,<2.33227,10.89682,4.11755>,<2.34177,10.89489,4.11287>,
            
    /*6*/ <2.42697,11.0512,4.17691>,<2.42077,11.05607,4.17264>,<2.42819,11.05349,4.16833>,
            
    /*7*/ <2.52557,11.20701,4.22166>,<2.5207,11.21109,4.21833>,<2.52635,11.20856,4.21471>,
            
    /*8*/ <2.6276,11.35797,4.27368>,<2.62407,11.36122,4.27124>,<2.6283,11.3593,4.26851>,
            
    /*9*/ <2.6842,11.52906,4.33374>,<2.68155,11.53061,4.33188>,<2.68475,11.53009,4.33035>,
            
    /*10*/ <2.727,11.70208,4.39867>,<2.72566,11.70278,4.39771>,<2.7273,11.70265,4.397>,
            
    /*11*/ <2.77902,11.87623,4.45306>

    /* stem 0.8c0c0.0.0*/ 
    /*0*/ <2.07502,10.35701,3.85627>,
    /*1*/ <2.0717,10.35956,3.8549>,<2.0791,10.35865,3.85651>,<2.07426,10.35283,3.85741>,
            
    /*2*/ <1.95051,10.56669,4.54846>

    /* stem 0.8c0c0.0.1*/ 
    /*0*/ <2.24118,10.6714,4.01931>,
    /*1*/ <2.2447,10.67023,4.01813>,<2.24069,10.67275,4.02293>,<2.23815,10.67122,4.01688>,
            
    /*2*/ <2.36939,11.26411,3.81591>

    /* stem 0.8c0c0.0.2*/ 
    /*0*/ <2.30872,10.82285,4.08797>,
    /*1*/ <2.3065,10.82256,4.09085>,<2.30938,10.82613,4.0865>,<2.31028,10.81986,4.08655>,
            
    /*2*/ <2.7744,10.89257,4.45416>

    /* stem 0.8c0c0.0.3*/ 
    /*0*/ <2.40239,11.01179,4.15822>,
    /*1*/ <2.40232,11.01291,4.15506>,<2.40512,11.01225,4.16012>,<2.39971,11.01021,4.1595>,
            
    /*2*/ <2.20338,11.48671,4.33072>

    /* stem 0.8c0c0.0.4*/ 
    /*0*/ <2.60048,11.32102,4.25763>,
    /*1*/ <2.60206,11.31936,4.25932>,<2.59938,11.32344,4.25864>,<2.60001,11.32027,4.25492>,
            
    /*2*/ <2.9723,11.54378,4.13055>

    /* stem 0.8c0c0.0.5*/ 
    /*0*/ <2.64688,11.42012,4.29279>,
    /*1*/ <2.64435,11.42101,4.29264>,<2.64888,11.42157,4.29174>,<2.6474,11.41777,4.29398>,
            
    /*2*/ <2.69602,11.61863,4.66405>

    /* stem 0.8c0c0.0.6*/ 
    /*0*/ <2.75749,11.80479,4.43033>,
    /*1*/ <2.75784,11.80476,4.43009>,<2.75752,11.80492,4.43074>,<2.75711,11.80469,4.43017>,
            
    /*2*/ <2.71785,12.11021,4.33565>

    /* stem 0.8c0.0*/ 
    /*0*/ <0.32516,7.85648,2.00027>,
    /*1*/ <0.30291,7.91386,1.99137>,<0.38349,7.84282,1.98362>,<0.28908,7.81277,2.02584>,
            
    /*2*/ <0.4157,7.99945,2.3045>,<0.48822,7.93552,2.29753>,<0.40325,7.90847,2.33552>,
            
    /*3*/ <0.52804,8.15957,2.57169>,<0.59667,8.10761,2.57538>,<0.52466,8.08694,2.61792>,
            
    /*4*/ <0.63286,8.39889,2.7732>,<0.69732,8.36173,2.78533>,<0.63791,8.34978,2.83018>,
            
    /*5*/ <0.70851,8.66963,2.96055>,<0.76589,8.64418,2.97591>,<0.71442,8.63271,3.01325>,
            
    /*6*/ <0.78389,8.95996,3.1221>,<0.83221,8.94067,3.13599>,<0.78996,8.93349,3.1686>,
            
    /*7*/ <0.86296,9.25099,3.28768>,<0.9015,9.23512,3.29858>,<0.86771,9.22945,3.32468>,
            
    /*8*/ <0.94944,9.54337,3.44608>,<0.97825,9.53112,3.45406>,<0.95314,9.52769,3.47409>,
            
    /*9*/ <0.98465,9.83969,3.61368>,<1.0043,9.83394,3.62039>,<0.98702,9.82923,3.63236>,
            
    /*10*/ <0.99982,10.14149,3.77597>,<1.00968,10.13921,3.77966>,<1.001,10.13653,3.78546>,
            
    /*11*/ <1.04885,10.45573,3.90579>

    /* stem 0.8c0.0.0*/ 
    /*0*/ <0.41153,7.92783,2.2442>,
    /*1*/ <0.4334,7.91406,2.24049>,<0.39875,7.92616,2.26691>,<0.40245,7.94327,2.22522>,
            
    /*2*/ <1.11918,8.92418,2.71597>

    /* stem 0.8c0.0.1*/ 
    /*0*/ <0.491,8.0303,2.44617>,
    /*1*/ <0.46846,8.02801,2.4569>,<0.50134,8.05297,2.44346>,<0.50318,8.00992,2.43814>,
            
    /*2*/ <1.03654,7.91523,3.56715>

    /* stem 0.8c0.0.2*/ 
    /*0*/ <0.62527,8.29713,2.73603>,
    /*1*/ <0.63494,8.308,2.71792>,<0.63657,8.29603,2.7563>,<0.60429,8.28738,2.73388>,
            
    /*2*/ <0.1326,9.28391,3.06482>

    /* stem 0.8c0.0.3*/ 
    /*0*/ <0.70783,8.56635,2.92789>,
    /*1*/ <0.71346,8.55364,2.94461>,<0.69705,8.58488,2.93147>,<0.71299,8.56052,2.90759>,
            
    /*2*/ <1.63592,9.08981,3.01328>

    /* stem 0.8c0.0.4*/ 
    /*0*/ <0.75108,8.7366,3.0304>,
    /*1*/ <0.73407,8.74525,3.02203>,<0.76951,8.7462,3.02882>,<0.74967,8.71833,3.04034>,
            
    /*2*/ <0.57023,9.22723,3.90626>

    /* stem 0.8c0.0.5*/ 
    /*0*/ <0.78486,8.8746,3.10456>,
    /*1*/ <0.80441,8.87199,3.10052>,<0.77896,8.87907,3.12329>,<0.77121,8.87275,3.08988>,
            
    /*2*/ <0.87121,9.83153,2.90351>

    /* stem 0.8c0.0.6*/ 
    /*0*/ <0.82497,9.03419,3.19139>,
    /*1*/ <0.812,9.03001,3.20507>,<0.82599,9.05208,3.1842>,<0.83693,9.02049,3.18491>,
            
    /*2*/ <1.44766,9.26453,3.85254>

    /* stem 0.8c0.0.7*/ 
    /*0*/ <0.89911,9.31598,3.34412>,
    /*1*/ <0.90009,9.32401,3.32823>,<0.91077,9.32016,3.35696>,<0.88648,9.30376,3.34718>,
            
    /*2*/ <0.37094,9.93191,3.62309>

    /* stem 0.8c0.0.8*/ 
    /*0*/ <0.97813,9.70302,3.55041>,
    /*1*/ <0.98707,9.69644,3.56073>,<0.96705,9.71237,3.55485>,<0.98026,9.70026,3.53567>,
            
    /*2*/ <1.45202,10.28391,3.51019>

    /* stem 0.8c0.0.9*/ 
    /*0*/ <1.00044,10.05814,3.73835>,
    /*1*/ <0.9928,10.05923,3.73682>,<1.00538,10.06427,3.73825>,<1.00315,10.05093,3.73998>,
            
    /*2*/ <0.88724,10.15942,4.37459>

    /* stem 0.8c0.0.10*/ 
    /*0*/ <1.03309,10.34569,3.8622>,
    /*1*/ <1.035,10.34581,3.8612>,<1.03294,10.34619,3.8643>,<1.03133,10.34507,3.86111>,
            
    /*2*/ <0.92449,10.89671,3.7238>

    /* stem 0.8c0.1*/ 
    /*0*/ <0.63051,8.04275,2.24765>,
    /*1*/ <0.67218,8.00662,2.2261>,<0.61595,8.0403,2.30499>,<0.60339,8.08135,2.21185>,
            
    /*2*/ <0.89576,8.23272,2.2956>,<0.84516,8.26303,2.36659>,<0.83385,8.29997,2.28276>,
            
    /*3*/ <1.11613,8.46659,2.34827>,<1.07284,8.49479,2.412>,<1.05927,8.5246,2.33678>,
            
    /*4*/ <1.30561,8.72638,2.43327>,<1.26043,8.74325,2.48645>,<1.25105,8.77142,2.42109>,
            
    /*5*/ <1.48378,8.98443,2.52505>,<1.44379,8.99727,2.57003>,<1.43641,9.0222,2.51425>,
            
    /*6*/ <1.642,9.26282,2.59385>,<1.60868,9.27342,2.63136>,<1.59984,9.29021,2.58372>,
            
    /*7*/ <1.82095,9.52928,2.62277>,<1.79755,9.54237,2.65381>,<1.78823,9.55286,2.61526>,
            
    /*8*/ <1.96985,9.8204,2.61199>,<1.95263,9.83061,2.63536>,<1.94305,9.83443,2.60638>,
            
    /*9*/ <2.10682,10.11651,2.60868>,<2.09494,10.12254,2.62427>,<2.08864,10.12523,2.60494>,
            
    /*10*/ <2.21993,10.42165,2.63803>,<2.21345,10.42348,2.64577>,<2.2106,10.42546,2.63612>,
            
    /*11*/ <2.33338,10.72578,2.66134>

    /* stem 0.8c0.1.0*/ 
    /*0*/ <0.78125,8.19001,2.29221>,
    /*1*/ <0.76972,8.19527,2.3138>,<0.79151,8.20841,2.2787>,<0.78251,8.16635,2.28414>,
            
    /*2*/ <1.86013,8.0384,2.90506>

    /* stem 0.8c0.1.1*/ 
    /*0*/ <1.01104,8.42183,2.34949>,
    /*1*/ <1.01009,8.42779,2.32669>,<1.03193,8.41889,2.36005>,<0.99111,8.41882,2.36174>,
            
    /*2*/ <1.02127,9.55435,2.64492>

    /* stem 0.8c0.1.2*/ 
    /*0*/ <1.14672,8.58024,2.3931>,
    /*1*/ <1.15837,8.5669,2.40723>,<1.14016,8.60086,2.39981>,<1.14162,8.57295,2.37226>,
            
    /*2*/ <2.10565,9.01013,2.00817>

    /* stem 0.8c0.1.3*/ 
    /*0*/ <1.38762,8.90778,2.50352>,
    /*1*/ <1.37074,8.91995,2.50334>,<1.40574,8.91502,2.49631>,<1.38638,8.88838,2.51092>,
            
    /*2*/ <1.62233,9.24746,3.43407>

    /* stem 0.8c0.1.4*/ 
    /*0*/ <1.50489,9.08623,2.55705>,
    /*1*/ <1.51956,9.08048,2.545>,<1.50908,9.09328,2.57511>,<1.48604,9.08493,2.55104>,
            
    /*2*/ <1.55843,9.97958,2.19581>

    /* stem 0.8c0.1.5*/ 
    /*0*/ <1.75379,9.47198,2.62339>,
    /*1*/ <1.75027,9.47263,2.64078>,<1.7508,9.4862,2.61319>,<1.76031,9.45711,2.6162>,
            
    /*2*/ <2.54762,9.74705,2.77393>

    /* stem 0.8c0.1.6*/ 
    /*0*/ <1.88405,9.695,2.62382>,
    /*1*/ <1.87658,9.69834,2.60939>,<1.89967,9.69993,2.62641>,<1.87589,9.68673,2.63566>,
            
    /*2*/ <1.61908,10.37957,2.91939>

    /* stem 0.8c0.1.7*/ 
    /*0*/ <1.99635,9.91364,2.61638>,
    /*1*/ <2.00943,9.90742,2.62179>,<1.99107,9.92692,2.6223>,<1.98854,9.90659,2.60504>,
            
    /*2*/ <2.38084,10.28831,2.11834>

    /* stem 0.8c0.1.8*/ 
    /*0*/ <2.14609,10.24777,2.62407>,
    /*1*/ <2.13776,10.25074,2.62714>,<2.15119,10.25319,2.61838>,<2.14932,10.23938,2.62668>,
            
    /*2*/ <2.43048,10.51648,3.13588>

    /* stem 0.8c0.1.9*/ 
    /*0*/ <2.28204,10.59507,2.6521>,
    /*1*/ <2.28331,10.59473,2.6499>,<2.28311,10.59641,2.654>,<2.2797,10.59407,2.65239>,
            
    /*2*/ <2.0586,11.06044,2.44977>

    /* stem 0.8c0.2*/ 
    /*0*/ <1.08555,8.40583,2.59115>,
    /*1*/ <1.05334,8.40992,2.63174>,<1.09901,8.44823,2.56428>,<1.10429,8.35934,2.57744>,
            
    /*2*/ <1.2891,8.45005,2.80811>,<1.3302,8.48453,2.74739>,<1.33496,8.40452,2.75924>,
            
    /*3*/ <1.51272,8.57437,2.96061>,<1.54004,8.60206,2.9>,<1.56102,8.53695,2.92249>,
            
    /*4*/ <1.70719,8.77587,3.06564>,<1.72202,8.79344,3.00697>,<1.75455,8.74748,3.03527>,
            
    /*5*/ <1.89817,8.99974,3.1282>,<1.90544,9.00926,3.07553>,<1.93775,8.97457,3.10142>,
            
    /*6*/ <2.08116,9.22926,3.17808>,<2.08606,9.23585,3.13382>,<2.11432,9.20855,3.15577>,
            
    /*7*/ <2.24811,9.47739,3.18725>,<2.24901,9.47874,3.15128>,<2.27459,9.46089,3.16927>,
            
    /*8*/ <2.41509,9.72301,3.14171>,<2.4129,9.71999,3.11496>,<2.43344,9.70851,3.1282>,
            
    /*9*/ <2.55439,9.98098,3.09911>,<2.55299,9.9791,3.08126>,<2.56745,9.97272,3.08988>,
            
    /*10*/ <2.67583,10.2484,3.124>,<2.67604,10.24927,3.11504>,<2.68306,10.24568,3.11938>,
            
    /*11*/ <2.74888,10.53442,3.08587>

    /* stem 0.8c0.2.0*/ 
    /*0*/ <1.22486,8.43012,2.69925>,
    /*1*/ <1.23449,8.44278,2.68399>,<1.23705,8.41648,2.71155>,<1.20304,8.43109,2.7022>,
            
    /*2*/ <1.36735,9.2591,3.47713>

    /* stem 0.8c0.2.1*/ 
    /*0*/ <1.45575,8.52449,2.86934>,
    /*1*/ <1.45952,8.50627,2.87858>,<1.45348,8.54167,2.88079>,<1.45423,8.52552,2.84864>,
            
    /*2*/ <2.51014,8.70842,2.80146>

    /* stem 0.8c0.2.2*/ 
    /*0*/ <1.59901,8.6358,2.96251>,
    /*1*/ <1.58444,8.64935,2.96289>,<1.61667,8.64038,2.95454>,<1.59593,8.61765,2.97009>,
            
    /*2*/ <1.92607,8.9618,3.87522>

    /* stem 0.8c0.2.3*/ 
    /*0*/ <1.8518,8.9204,3.07979>,
    /*1*/ <1.8641,8.91353,3.06823>,<1.85718,8.92737,3.09574>,<1.83412,8.9203,3.07539>,
            
    /*2*/ <1.9454,9.75351,2.68425>

    /* stem 0.8c0.2.4*/ 
    /*0*/ <1.96528,9.06031,3.11721>,
    /*1*/ <1.96103,9.05966,3.13411>,<1.96405,9.07536,3.10849>,<1.97077,9.04592,3.10904>,
            
    /*2*/ <2.79864,9.25443,3.33441>

    /* stem 0.8c0.2.5*/ 
    /*0*/ <2.20707,9.39626,3.16516>,
    /*1*/ <2.20088,9.40107,3.15163>,<2.22256,9.39667,3.16725>,<2.19777,9.39104,3.1766>,
            
    /*2*/ <2.14927,10.12276,3.45>

    /* stem 0.8c0.2.6*/ 
    /*0*/ <2.3183,9.56392,3.15394>,
    /*1*/ <2.33025,9.55678,3.15886>,<2.31502,9.57732,3.1592>,<2.30963,9.55767,3.14375>,
            
    /*2*/ <2.72091,9.87119,2.62279>

    /* stem 0.8c0.2.7*/ 
    /*0*/ <2.48852,9.84577,3.10942>,
    /*1*/ <2.47807,9.85199,3.11408>,<2.49446,9.85016,3.09869>,<2.49304,9.83517,3.1155>,
            
    /*2*/ <2.87632,10.22216,3.47788>

    /* stem 0.8c0.2.8*/ 
    /*0*/ <2.63018,10.13945,3.10769>,
    /*1*/ <2.63367,10.1386,3.10135>,<2.6339,10.14136,3.11366>,<2.62299,10.13841,3.10806>,
            
    /*2*/ <2.54301,10.69461,2.9847>

    /* stem 0.8c0.2.9*/ 
    /*0*/ <2.73066,10.46042,3.09455>,
    /*1*/ <2.73095,10.4605,3.09586>,<2.72984,10.46132,3.09398>,<2.73119,10.45943,3.0938>,
            
    /*2*/ <3.11881,10.74758,2.99115>

    /* stem 0.8c0.3*/ 
    /*0*/ <1.54908,8.90353,2.87632>,
    /*1*/ <1.55306,8.91744,2.83902>,<1.58156,8.89625,2.89853>,<1.51262,8.8969,2.89142>,
            
    /*2*/ <1.54552,9.16567,2.93506>,<1.57116,9.1466,2.98863>,<1.50912,9.14719,2.98222>,
            
    /*3*/ <1.57207,9.41689,3.00665>,<1.59504,9.40151,3.05471>,<1.54013,9.4083,3.05114>,
            
    /*4*/ <1.56987,9.67515,3.06542>,<1.59018,9.66614,3.10855>,<1.54187,9.66675,3.10414>,
            
    /*5*/ <1.58055,9.93584,3.10912>,<1.598,9.92943,3.14631>,<1.55662,9.9317,3.14287>,
            
    /*6*/ <1.62573,10.1923,3.09462>,<1.64088,10.19181,3.12579>,<1.60682,10.19763,3.12317>,
            
    /*7*/ <1.67727,10.44561,3.0438>,<1.69003,10.44828,3.06826>,<1.66287,10.45339,3.06617>,
            
    /*8*/ <1.76489,10.68211,2.96476>,<1.77468,10.68485,2.9829>,<1.75506,10.69134,2.9806>,
            
    /*9*/ <1.8481,10.92287,2.88687>,<1.85465,10.92472,2.89894>,<1.84148,10.9288,2.8975>,
            
    /*10*/ <1.92191,11.17326,2.83083>,<1.92505,11.17381,2.83698>,<1.91839,11.17562,2.83632>,
            
    /*11*/ <1.99458,11.42279,2.77304>

    /* stem 0.8c0.3.0*/ 
    /*0*/ <1.54619,9.00438,2.91362>,
    /*1*/ <1.55586,8.99971,2.92701>,<1.53153,9.01291,2.91619>,<1.5512,9.00052,2.89767>,
            
    /*2*/ <2.0606,9.9055,2.85695>

    /* stem 0.8c0.3.1*/ 
    /*0*/ <1.5556,9.28187,3.0033>,
    /*1*/ <1.54014,9.28451,2.99958>,<1.56684,9.29264,2.99914>,<1.55981,9.26846,3.01117>,
            
    /*2*/ <1.43034,9.73882,3.84845>

    /* stem 0.8c0.3.2*/ 
    /*0*/ <1.568,9.56694,3.071>,
    /*1*/ <1.58167,9.56834,3.06486>,<1.56501,9.57342,3.08425>,<1.55732,9.55907,3.06389>,
            
    /*2*/ <1.30118,10.31249,2.64663>

    /* stem 0.8c0.3.3*/ 
    /*0*/ <1.5745,9.84013,3.11872>,
    /*1*/ <1.56854,9.83846,3.13133>,<1.57077,9.85093,3.11056>,<1.58421,9.831,3.11428>,
            
    /*2*/ <2.171,10.30663,3.46286>

    /* stem 0.8c0.3.4*/ 
    /*0*/ <1.59809,10.04412,3.12497>,
    /*1*/ <1.5944,10.04388,3.11221>,<1.60945,10.05003,3.12849>,<1.59041,10.03845,3.13421>,
            
    /*2*/ <1.21644,10.71975,3.22244>

    /* stem 0.8c0.3.5*/ 
    /*0*/ <1.74109,10.62215,2.99857>,
    /*1*/ <1.75009,10.62101,3.00482>,<1.73534,10.63154,2.99887>,<1.73785,10.61391,2.99202>,
            
    /*2*/ <2.09778,10.85552,2.52799>

    /* stem 0.8c0.3.6*/ 
    /*0*/ <1.81568,10.83225,2.92624>,
    /*1*/ <1.80673,10.83556,2.92683>,<1.82124,10.83479,2.91889>,<1.81906,10.82638,2.93299>,
            
    /*2*/ <2.00452,11.28863,3.22774>

    /* stem 0.8c0.3.7*/ 
    /*0*/ <1.8825,11.04166,2.86654>,
    /*1*/ <1.88644,11.03949,2.86236>,<1.88439,11.04576,2.87069>,<1.87668,11.03972,2.86657>,
            
    /*2*/ <1.75154,11.43103,2.54135>

    /* stem 0.8c0.3.8*/ 
    /*0*/ <1.95668,11.29337,2.80515>,
    /*1*/ <1.95662,11.29389,2.80716>,<1.95576,11.29459,2.80373>,<1.95766,11.29164,2.80455>,
            
    /*2*/ <2.34691,11.53043,2.75575>

    /* stem 0.8c0.4*/ 
    /*0*/ <1.81246,9.23878,3.02193>,
    /*1*/ <1.82786,9.21913,3.04309>,<1.79259,9.26234,3.03296>,<1.81692,9.23488,2.98975>,
            
    /*2*/ <2.01706,9.37854,3.04831>,<1.98532,9.41742,3.03919>,<2.00721,9.39271,3.0003>,
            
    /*3*/ <2.20236,9.54232,3.0592>,<2.17349,9.57632,3.05102>,<2.1941,9.55528,3.01653>,
            
    /*4*/ <2.34643,9.74444,3.09226>,<2.31572,9.76818,3.08405>,<2.33967,9.75592,3.05488>,
            
    /*5*/ <2.46985,9.95728,3.12896>,<2.44194,9.97521,3.12145>,<2.46386,9.96674,3.09685>,
            
    /*6*/ <2.58047,10.17564,3.16909>,<2.55653,10.18934,3.16257>,<2.57547,10.18347,3.14232>,
            
    /*7*/ <2.67817,10.40056,3.20756>,<2.65845,10.41034,3.20211>,<2.67395,10.40636,3.18605>,
            
    /*8*/ <2.7665,10.62854,3.24765>,<2.75148,10.63531,3.24346>,<2.76332,10.63282,3.23151>,
            
    /*9*/ <2.83267,10.86882,3.24918>,<2.82215,10.87186,3.24624>,<2.8299,10.86978,3.23823>,
            
    /*10*/ <2.8562,11.11342,3.2089>,<2.85072,11.11378,3.20751>,<2.8546,11.11275,3.20351>,
            
    /*11*/ <2.83941,11.36008,3.19548>

    /* stem 0.8c0.4.0*/ 
    /*0*/ <1.95651,9.35768,3.02747>,
    /*1*/ <1.94775,9.3683,3.0274>,<1.96805,9.35823,3.01999>,<1.95373,9.34652,3.03502>,
            
    /*2*/ <2.41359,9.7398,3.76085>

    /* stem 0.8c0.4.1*/ 
    /*0*/ <2.0991,9.47927,3.03593>,
    /*1*/ <2.10607,9.47188,3.02755>,<2.10499,9.48475,3.04636>,<2.08623,9.48117,3.03389>,
            
    /*2*/ <2.28497,10.2109,2.54614>

    /* stem 0.8c0.4.2*/ 
    /*0*/ <2.41393,9.89113,3.1019>,
    /*1*/ <2.41082,9.89094,3.11296>,<2.41466,9.90115,3.09631>,<2.4163,9.88131,3.09642>,
            
    /*2*/ <3.15588,9.95348,3.31129>

    /* stem 0.8c0.4.3*/ 
    /*0*/ <2.51806,10.08111,3.13814>,
    /*1*/ <2.51455,10.08479,3.12863>,<2.5278,10.08399,3.14177>,<2.51183,10.07456,3.14402>,
            
    /*2*/ <2.22692,10.65269,3.46673>

    /* stem 0.8c0.4.4*/ 
    /*0*/ <2.63403,10.32463,3.18381>,
    /*1*/ <2.64201,10.32035,3.18779>,<2.63069,10.33321,3.18744>,<2.6294,10.32034,3.17619>,
            
    /*2*/ <3.0181,10.65136,2.76571>

    /* stem 0.8c0.4.5*/ 
    /*0*/ <2.71012,10.50595,3.21729>,
    /*1*/ <2.70169,10.50886,3.21972>,<2.71533,10.5111,3.21165>,<2.71333,10.4979,3.22049>,
            
    /*2*/ <2.94731,10.79196,3.69746>

    /* stem 0.8c0.4.6*/ 
    /*0*/ <2.84461,11.02567,3.2203>,
    /*1*/ <2.84706,11.02485,3.21667>,<2.84623,11.02827,3.22354>,<2.84055,11.0239,3.2207>,
            
    /*2*/ <2.65702,11.40851,3.00709>

    /* stem 0.8c0.4.7*/ 
    /*0*/ <2.84871,11.20103,3.20267>,
    /*1*/ <2.84894,11.20114,3.20477>,<2.84726,11.20222,3.20171>,<2.84994,11.19974,3.20154>,
            
    /*2*/ <3.14012,11.51915,3.15388>

    /* stem 0.8c0.5*/ 
    /*0*/ <2.62207,10.31307,3.49742>,
    /*1*/ <2.61469,10.31925,3.49717>,<2.63019,10.31505,3.49261>,<2.62134,10.30489,3.50247>,
            
    /*2*/ <2.68378,10.40624,3.64865>,<2.69773,10.40245,3.64454>,<2.68977,10.39331,3.65342>,
            
    /*3*/ <2.74065,10.52763,3.7781>,<2.75339,10.52483,3.77521>,<2.74696,10.51782,3.78459>,
            
    /*4*/ <2.80441,10.68014,3.86575>,<2.81537,10.67731,3.86282>,<2.81082,10.67344,3.87286>,
            
    /*5*/ <2.84294,10.83537,3.96281>,<2.85272,10.8341,3.96105>,<2.84853,10.83005,3.96919>,
            
    /*6*/ <2.84051,10.99716,4.05577>,<2.84883,10.99761,4.05526>,<2.84525,10.99382,4.06177>,
            
    /*7*/ <2.84517,11.16619,4.1376>,<2.85182,11.16631,4.13705>,<2.84896,11.16374,4.14252>,
            
    /*8*/ <2.8536,11.32191,4.24287>,<2.85859,11.32195,4.24245>,<2.85643,11.3195,4.24624>,
            
    /*9*/ <2.89175,11.48395,4.33053>,<2.89501,11.48351,4.32994>,<2.89364,11.48232,4.33274>,
            
    /*10*/ <2.90105,11.64443,4.42725>,<2.90271,11.64444,4.4271>,<2.902,11.64369,4.42841>,
            
    /*11*/ <2.87249,11.81358,4.50323>

    /* stem 0.8c0.5.0*/ 
    /*0*/ <2.67069,10.37537,3.60514>,
    /*1*/ <2.67446,10.37496,3.60367>,<2.66994,10.3746,3.60905>,<2.66767,10.37655,3.60268>,
            
    /*2*/ <2.80833,11.06254,3.76711>

    /* stem 0.8c0.5.1*/ 
    /*0*/ <2.77869,10.60042,3.82335>,
    /*1*/ <2.77675,10.59953,3.82631>,<2.77842,10.60377,3.82193>,<2.78091,10.59796,3.82181>,
            
    /*2*/ <3.25704,10.79852,4.19716>

    /* stem 0.8c0.5.2*/ 
    /*0*/ <2.8368,10.78672,3.93544>,
    /*1*/ <2.83653,10.78854,3.93262>,<2.8396,10.78691,3.93731>,<2.83427,10.78471,3.9364>,
            
    /*2*/ <2.60229,11.22594,4.24147>

    /* stem 0.8c0.5.3*/ 
    /*0*/ <2.84661,10.90734,4.00677>,
    /*1*/ <2.84885,10.90624,4.00876>,<2.84428,10.90923,4.00787>,<2.84669,10.90654,4.00368>,
            
    /*2*/ <3.15713,11.34936,3.90064>

    /* stem 0.8c0.5.4*/ 
    /*0*/ <2.85149,11.22391,4.17843>,
    /*1*/ <2.84877,11.22416,4.17827>,<2.85309,11.22602,4.17773>,<2.85261,11.22157,4.17929>,
            
    /*2*/ <2.83919,11.37911,4.61546>

    /* stem 0.8c0.5.5*/ 
    /*0*/ <2.87227,11.39103,4.28146>,
    /*1*/ <2.87425,11.39136,4.28001>,<2.87252,11.3911,4.28392>,<2.87005,11.39064,4.28045>,
            
    /*2*/ <2.80152,11.8013,4.2768>

    /* stem 0.8c0.5.6*/ 
    /*0*/ <2.88927,11.71702,4.46011>,
    /*1*/ <2.88912,11.71678,4.46058>,<2.88893,11.71738,4.45986>,<2.88975,11.71689,4.45988>,
            
    /*2*/ <3.03072,11.95966,4.62609>

    /* stem 0.8c1*/ 
    /*0*/ <0.16561,8.44655,3.46752>,
    /*1*/ <0.13398,8.44612,3.50167>,<0.13939,8.48477,3.46332>,<0.18103,8.47059,3.43078>,
            <0.20136,8.42318,3.44902>,<0.17228,8.40806,3.49283>,
    /*2*/ <0.54337,8.76368,3.87084>,<0.54759,8.79379,3.84096>,<0.58003,8.78274,3.81562>,
            <0.59587,8.74581,3.82983>,<0.57321,8.73403,3.86396>,
    /*3*/ <0.94665,9.08925,4.23941>,<0.9495,9.11069,4.21785>,<0.97294,9.10294,4.19987>,
            <0.98457,9.0767,4.21032>,<0.96832,9.06825,4.23475>,
    /*4*/ <1.31238,9.4678,4.59558>,<1.31336,9.48007,4.58184>,<1.32812,9.47596,4.57156>,
            <1.33626,9.46114,4.57895>,<1.32653,9.4561,4.5938>,
    /*5*/ <1.67443,9.85135,4.95122>,<1.67475,9.85556,4.94646>,<1.67986,9.85416,4.94294>,
            <1.6827,9.84909,4.94552>,<1.67934,9.84735,4.95064>,
    /*6*/ <1.67822,9.8515,4.94736>

    /* stem 0.8c1.0*/ 
    /*0*/ <0.77252,8.93197,4.03833>,
    /*1*/ <0.78114,8.94935,4.01421>,<0.79298,8.91315,4.05195>,<0.74344,8.93342,4.04884>,
            
    /*2*/ <0.84391,9.1264,4.16817>,<0.85456,9.09382,4.20213>,<0.80998,9.11206,4.19934>,
            
    /*3*/ <0.8488,9.32355,4.30885>,<0.85872,9.29955,4.34298>,<0.81764,9.30733,4.33344>,
            
    /*4*/ <0.85508,9.52953,4.43398>,<0.86385,9.51073,4.46526>,<0.82788,9.51707,4.45664>,
            
    /*5*/ <0.87929,9.74447,4.53925>,<0.88704,9.73034,4.56709>,<0.85629,9.73705,4.56047>,
            
    /*6*/ <0.88333,9.96531,4.64011>,<0.88981,9.95467,4.66385>,<0.86405,9.95813,4.6573>,
            
    /*7*/ <0.93356,10.1899,4.70871>,<0.93904,10.18295,4.72825>,<0.91878,10.1887,4.7242>,
            
    /*8*/ <0.98011,10.42171,4.76034>,<0.98449,10.41769,4.77528>,<0.96917,10.42147,4.77213>,
            
    /*9*/ <1.00495,10.64606,4.85477>,<1.00758,10.64189,4.86429>,<0.99731,10.64398,4.86201>,
            
    /*10*/ <0.99545,10.87176,4.94428>,<0.99676,10.86995,4.94915>,<0.99161,10.8703,4.94772>,
            
    /*11*/ <1.03164,11.10401,5.00324>

    /* stem 0.8c1.0.0*/ 
    /*0*/ <0.81206,9.04307,4.1325>,
    /*1*/ <0.81705,9.03425,4.14082>,<0.80606,9.05378,4.13713>,<0.81307,9.04119,4.11957>,
            
    /*2*/ <1.62723,9.50144,4.12969>

    /* stem 0.8c1.0.1*/ 
    /*0*/ <0.839,9.21283,4.2608>,
    /*1*/ <0.82787,9.21623,4.25636>,<0.84856,9.22081,4.26042>,<0.84058,9.20145,4.26562>,
            
    /*2*/ <0.61458,9.51941,5.05822>

    /* stem 0.8c1.0.2*/ 
    /*0*/ <0.86671,9.67257,4.52486>,
    /*1*/ <0.87716,9.67271,4.52202>,<0.86365,9.67658,4.53443>,<0.85933,9.66842,4.51812>,
            
    /*2*/ <0.77212,10.3527,4.20963>

    /* stem 0.8c1.0.3*/ 
    /*0*/ <0.87783,9.90322,4.62894>,
    /*1*/ <0.87194,9.90005,4.63641>,<0.87531,9.91139,4.62368>,<0.88625,9.89822,4.62672>,
            
    /*2*/ <1.23123,10.30015,5.07639>

    /* stem 0.8c1.0.4*/ 
    /*0*/ <0.90887,10.09149,4.6924>,
    /*1*/ <0.90804,10.0943,4.68346>,<0.91581,10.09488,4.69776>,<0.90276,10.08531,4.69597>,
            
    /*2*/ <0.52653,10.5775,4.88>

    /* stem 0.8c1.0.5*/ 
    /*0*/ <0.95441,10.30481,4.74504>,
    /*1*/ <0.96055,10.30237,4.75069>,<0.9486,10.31087,4.74729>,<0.95407,10.30118,4.73715>,
            
    /*2*/ <1.31384,10.72651,4.53575>

    /* stem 0.8c1.0.6*/ 
    /*0*/ <1.00094,10.70527,4.8838>,
    /*1*/ <0.99561,10.70529,4.88322>,<1.00382,10.70948,4.88217>,<1.00338,10.70105,4.88601>,
            
    /*2*/ <0.95386,10.90922,5.32616>

    /* stem 0.8c1.0.7*/ 
    /*0*/ <1.0102,10.9689,4.97071>,
    /*1*/ <1.01165,10.96892,4.96966>,<1.01028,10.96958,4.97237>,<1.00866,10.9682,4.9701>,
            
    /*2*/ <0.89681,11.34721,4.82111>

    /* stem 0.8c1.1*/ 
    /*0*/ <1.46402,9.62016,4.72826>,
    /*1*/ <1.46771,9.61098,4.73434>,<1.45787,9.62851,4.7335>,<1.46647,9.621,4.71693>,
            
    /*2*/ <1.6306,9.70563,4.77606>,<1.62173,9.72141,4.7753>,<1.62948,9.71465,4.76039>,
            
    /*3*/ <1.77919,9.82393,4.81674>,<1.76945,9.8367,4.81556>,<1.77729,9.83132,4.80257>,
            
    /*4*/ <1.90747,9.96442,4.8556>,<1.89739,9.97414,4.85408>,<1.90509,9.97018,4.84297>,
            
    /*5*/ <2.012,10.12254,4.89635>,<2.00227,10.12949,4.89464>,<2.00963,10.12701,4.88539>,
            
    /*6*/ <2.10993,10.28533,4.93203>,<2.10158,10.29075,4.93052>,<2.10773,10.28873,4.92282>,
            
    /*7*/ <2.16687,10.47036,4.94942>,<2.15937,10.47285,4.94791>,<2.16456,10.47182,4.94185>,
            
    /*8*/ <2.18068,10.66102,4.97952>,<2.17482,10.66168,4.97822>,<2.17895,10.66208,4.97383>,
            
    /*9*/ <2.17975,10.85374,4.9949>,<2.17583,10.85381,4.99399>,<2.17859,10.85406,4.99106>,
            
    /*10*/ <2.16822,11.04486,5.01896>,<2.16626,11.04481,5.0185>,<2.16763,11.04507,5.01705>,
            
    /*11*/ <2.17781,11.23222,5.06331>

    /* stem 0.8c1.1.0*/ 
    /*0*/ <1.55022,9.66966,4.75061>,
    /*1*/ <1.54765,9.67384,4.75124>,<1.55405,9.66956,4.74748>,<1.54895,9.66558,4.7531>,
            
    /*2*/ <2.00866,9.86658,5.30701>

    /* stem 0.8c1.1.1*/ 
    /*0*/ <1.84938,9.91104,4.83434>,
    /*1*/ <1.85212,9.90935,4.83138>,<1.85091,9.91243,4.8382>,<1.8451,9.91134,4.83344>,
            
    /*2*/ <1.94457,10.50542,4.58283>

    /* stem 0.8c1.1.2*/ 
    /*0*/ <1.9369,10.0199,4.86412>,
    /*1*/ <1.93591,10.0195,4.86815>,<1.93632,10.02354,4.86218>,<1.93848,10.01665,4.86203>,
            
    /*2*/ <2.50803,10.1954,5.02208>

    /* stem 0.8c1.1.3*/ 
    /*0*/ <2.03931,10.1779,4.90369>,
    /*1*/ <2.03791,10.17948,4.90043>,<2.04306,10.17833,4.90461>,<2.03695,10.17588,4.90604>,
            
    /*2*/ <1.91392,10.65709,5.18942>

    /* stem 0.8c1.1.4*/ 
    /*0*/ <2.17001,10.55527,4.95995>,
    /*1*/ <2.17301,10.55484,4.96119>,<2.16793,10.55737,4.96137>,<2.16908,10.5536,4.95728>,
            
    /*2*/ <2.33409,10.90422,4.68504>

    /* stem 0.8c1.1.5*/ 
    /*0*/ <2.17808,10.80454,4.98918>,
    /*1*/ <2.17557,10.80447,4.98993>,<2.17881,10.80606,4.98717>,<2.17986,10.80308,4.99043>,
            
    /*2*/ <2.24884,11.11628,5.25101>

    /* stem 0.8c1.1.6*/ 
    /*0*/ <2.17292,11.14453,5.04218>,
    /*1*/ <2.17322,11.14462,5.04173>,<2.17306,11.14476,5.04265>,<2.17249,11.1442,5.04215>,
            
    /*2*/ <1.98284,11.40482,4.96951>

    /* stem 0.8c2*/ 
    /*0*/ <0.22147,9.1417,4.52876>,
    /*1*/ <0.20248,9.14239,4.51104>,<0.22591,9.16188,4.51302>,<0.2432,9.15347,4.53675>,
            <0.23045,9.12879,4.54944>,<0.20529,9.12195,4.53355>,
    /*2*/ <-0.13357,9.51641,4.90081>,<-0.11941,9.52818,4.90201>,<-0.10897,9.5231,4.91634>,
            <-0.11667,9.50819,4.92401>,<-0.13188,9.50405,4.91441>,
    /*3*/ <-0.46443,9.91495,5.26971>,<-0.45945,9.9189,5.27001>,<-0.45595,9.91727,5.27507>,
            <-0.45877,9.91232,5.2779>,<-0.46401,9.91088,5.27458>,
    /*4*/ <-0.46052,9.91486,5.27345>

    /* stem 0.8.0*/ 
    /*0*/ <-0.03031,7.31061,0.20776>,
    /*1*/ <0.02771,7.35859,0.19886>,<-0.02253,7.24951,0.25196>,<-0.0961,7.32372,0.17245>,
            
    /*2*/ <-0.11382,7.58041,0.53685>,<-0.15903,7.48223,0.58465>,<-0.22525,7.54903,0.51308>,
            
    /*3*/ <-0.23644,7.85123,0.83388>,<-0.28137,7.77345,0.88835>,<-0.33716,7.82664,0.81698>,
            
    /*4*/ <-0.38604,8.19274,1.03327>,<-0.43228,8.13965,1.09237>,<-0.47244,8.16756,1.01455>,
            
    /*5*/ <-0.52469,8.55035,1.21803>,<-0.5658,8.50862,1.27072>,<-0.59946,8.53059,1.20295>,
            
    /*6*/ <-0.62755,8.90939,1.42207>,<-0.66189,8.87545,1.46657>,<-0.69144,8.89779,1.41237>,
            
    /*7*/ <-0.77852,9.26248,1.62004>,<-0.80541,9.23287,1.65409>,<-0.82794,9.24834,1.60924>,
            
    /*8*/ <-0.88345,9.60213,1.8561>,<-0.90318,9.57923,1.88137>,<-0.92178,9.595,1.85043>,
            
    /*9*/ <-0.9587,9.93272,2.11663>,<-0.97168,9.91713,2.13331>,<-0.98462,9.92939,2.11403>,
            
    /*10*/ <-1.03697,10.30674,2.30721>,<-1.04383,10.30072,2.31666>,<-1.04991,10.30498,2.30582>,
            
    /*11*/ <-1.06514,10.70269,2.46518>

    /* stem 0.8.0.0*/ 
    /*0*/ <-0.09535,7.41921,0.36931>,
    /*1*/ <-0.10267,7.39175,0.38482>,<-0.11592,7.4442,0.37005>,<-0.06746,7.42168,0.35306>,
            
    /*2*/ <0.65245,7.99414,1.73991>

    /* stem 0.8.0.1*/ 
    /*0*/ <-0.20949,7.63947,0.65502>,
    /*1*/ <-0.22131,7.65782,0.63332>,<-0.19419,7.65162,0.67879>,<-0.21298,7.60896,0.65294>,
            
    /*2*/ <-1.55165,7.73734,1.46898>

    /* stem 0.8.0.2*/ 
    /*0*/ <-0.24562,7.72448,0.74661>,
    /*1*/ <-0.21962,7.71974,0.76128>,<-0.27169,7.72512,0.76189>,<-0.24555,7.72859,0.71667>,
            
    /*2*/ <-0.08597,9.24343,0.9554>

    /* stem 0.8.0.3*/ 
    /*0*/ <-0.35855,7.9941,0.94784>,
    /*1*/ <-0.3853,7.98382,0.94637>,<-0.35278,8.02054,0.93827>,<-0.33755,7.97794,0.95887>,
            
    /*2*/ <-0.63839,8.53359,2.27034>

    /* stem 0.8.0.4*/ 
    /*0*/ <-0.47689,8.29394,1.11116>,
    /*1*/ <-0.45919,8.30803,1.09613>,<-0.47882,8.29864,1.13784>,<-0.49266,8.27516,1.0995>,
            
    /*2*/ <-1.43354,9.24385,0.87489>

    /* stem 0.8.0.5*/ 
    /*0*/ <-0.58369,8.60638,1.27322>,
    /*1*/ <-0.58476,8.59372,1.29542>,<-0.60087,8.6246,1.26805>,<-0.56543,8.60082,1.2562>,
            
    /*2*/ <0.18226,9.48122,1.80921>

    /* stem 0.8.0.6*/ 
    /*0*/ <-0.64636,8.84186,1.40449>,
    /*1*/ <-0.66082,8.84833,1.38596>,<-0.63034,8.85782,1.4136>,<-0.64791,8.81943,1.4139>,
            
    /*2*/ <-1.48283,9.23075,2.19359>

    /* stem 0.8.0.7*/ 
    /*0*/ <-0.76216,9.145,1.57132>,
    /*1*/ <-0.74124,9.14908,1.57937>,<-0.78029,9.14754,1.58489>,<-0.76496,9.13838,1.54969>,
            
    /*2*/ <-0.84972,10.2218,1.25299>

    /* stem 0.8.0.8*/ 
    /*0*/ <-0.86497,9.46039,1.77276>,
    /*1*/ <-0.88291,9.45111,1.77881>,<-0.86537,9.47991,1.76481>,<-0.84665,9.45015,1.77466>,
            
    /*2*/ <-0.74594,9.84959,2.72211>

    /* stem 0.8.0.9*/ 
    /*0*/ <-0.93819,9.76389,1.99556>,
    /*1*/ <-0.93181,9.77555,1.98219>,<-0.93089,9.76456,2.01292>,<-0.95187,9.75155,1.99156>,
            
    /*2*/ <-1.58477,10.40101,2.24265>

    /* stem 0.8.0.10*/ 
    /*0*/ <-0.99302,10.03857,2.17731>,
    /*1*/ <-0.98908,10.03368,2.1886>,<-1.00448,10.04445,2.17647>,<-0.98549,10.03757,2.16687>,
            
    /*2*/ <-0.62211,10.7897,2.37305>

    /* stem 0.8.0.11*/ 
    /*0*/ <-1.01752,10.16731,2.24158>,
    /*1*/ <-1.02616,10.16843,2.23603>,<-1.01043,10.17481,2.24168>,<-1.01598,10.15867,2.24704>,
            
    /*2*/ <-1.39059,10.51208,2.89196>

    /* stem 0.8.0.12*/ 
    /*0*/ <-1.05339,10.48563,2.38061>,
    /*1*/ <-1.0493,10.48602,2.38017>,<-1.05529,10.4873,2.38387>,<-1.05558,10.48357,2.37778>,
            
    /*2*/ <-1.15379,11.11383,2.00024>

    /* stem 0.8.1*/ 
    /*0*/ <-0.03049,7.33831,0.35597>,
    /*1*/ <-0.04339,7.26587,0.3695>,<-0.07717,7.39026,0.38278>,<0.0291,7.3588,0.31564>,
            
    /*2*/ <0.18815,7.29796,0.72089>,<0.15775,7.40991,0.73285>,<0.25339,7.38159,0.67242>,
            
    /*3*/ <0.35462,7.4751,1.08969>,<0.31155,7.56643,1.06625>,<0.40749,7.5445,1.0337>,
            
    /*4*/ <0.57312,7.73239,1.36814>,<0.52758,7.80495,1.33832>,<0.60579,7.78118,1.299>,
            
    /*5*/ <0.75627,8.03429,1.6119>,<0.71194,8.08914,1.57919>,<0.78127,8.07183,1.54858>,
            
    /*6*/ <0.84148,8.35611,1.87378>,<0.8022,8.39519,1.84019>,<0.86496,8.39116,1.82461>,
            
    /*7*/ <0.91699,8.71872,2.08756>,<0.88426,8.74456,2.05678>,<0.93448,8.74142,2.04437>,
            
    /*8*/ <0.9827,9.09305,2.27571>,<0.95773,9.11031,2.25142>,<0.99547,9.10827,2.2423>,
            
    /*9*/ <1.02651,9.50438,2.38136>,<1.00923,9.51123,2.36331>,<1.03442,9.51008,2.35735>,
            
    /*10*/ <1.05227,9.89515,2.53418>,<1.0437,9.89935,2.52542>,<1.05637,9.89957,2.52272>,
            
    /*11*/ <1.06692,10.31078,2.61366>

    /* stem 0.8.1.0*/ 
    /*0*/ <0.07675,7.34988,0.52026>,
    /*1*/ <0.06412,7.37858,0.52648>,<0.10815,7.34511,0.52385>,<0.05797,7.32594,0.51044>,
            
    /*2*/ <-0.16963,6.90343,2.07975>

    /* stem 0.8.1.1*/ 
    /*0*/ <0.2338,7.39877,0.78501>,
    /*1*/ <0.26143,7.38763,0.77789>,<0.2231,7.39609,0.8136>,<0.21686,7.41261,0.76356>,
            
    /*2*/ <0.88393,8.77256,1.1575>

    /* stem 0.8.1.2*/ 
    /*0*/ <0.33547,7.50521,1.01295>,
    /*1*/ <0.31103,7.49741,1.02749>,<0.34592,7.53267,1.01535>,<0.34945,7.48554,0.99601>,
            
    /*2*/ <1.16817,7.08548,2.18751>

    /* stem 0.8.1.3*/ 
    /*0*/ <0.50143,7.69483,1.24827>,
    /*1*/ <0.50754,7.71265,1.22754>,<0.52064,7.68896,1.26779>,<0.47613,7.68288,1.24947>,
            
    /*2*/ <0.02993,8.77324,2.03633>

    /* stem 0.8.1.4*/ 
    /*0*/ <0.64423,7.89459,1.43711>,
    /*1*/ <0.65597,7.87536,1.4514>,<0.63083,7.91408,1.44945>,<0.6459,7.89433,1.41049>,
            
    /*2*/ <1.76705,8.6267,1.50029>

    /* stem 0.8.1.5*/ 
    /*0*/ <0.77303,8.1499,1.65142>,
    /*1*/ <0.75018,8.15955,1.64739>,<0.79268,8.16516,1.65493>,<0.77623,8.12498,1.65194>,
            
    /*2*/ <0.55399,8.14773,2.88777>

    /* stem 0.8.1.6*/ 
    /*0*/ <0.81865,8.31663,1.79205>,
    /*1*/ <0.84111,8.31793,1.78324>,<0.81512,8.31451,1.81586>,<0.79972,8.31747,1.77706>,
            
    /*2*/ <0.79003,9.51403,1.89473>

    /* stem 0.8.1.7*/ 
    /*0*/ <0.87094,8.54326,1.94561>,
    /*1*/ <0.85963,8.53465,1.96362>,<0.86806,8.56524,1.93969>,<0.88513,8.52988,1.93351>,
            
    /*2*/ <1.72987,8.83908,2.62614>

    /* stem 0.8.1.8*/ 
    /*0*/ <0.94981,8.9445,2.17287>,
    /*1*/ <0.94603,8.95458,2.15496>,<0.96549,8.95068,2.18522>,<0.93792,8.92824,2.17842>,
            
    /*2*/ <0.31378,9.57749,2.66355>

    /* stem 0.8.1.9*/ 
    /*0*/ <0.9984,9.28259,2.30544>,
    /*1*/ <1.01342,9.27794,2.31635>,<0.9842,9.29317,2.3127>,<0.99757,9.27665,2.28726>,
            
    /*2*/ <1.43804,10.0601,2.03151>

    /* stem 0.8.1.10*/ 
    /*0*/ <1.03168,9.62649,2.41582>,
    /*1*/ <1.01902,9.62712,2.41644>,<1.03841,9.63679,2.41267>,<1.03762,9.61555,2.41833>,
            
    /*2*/ <1.08295,9.84269,3.2332>

    /* stem 0.8.1.11*/ 
    /*0*/ <1.04174,9.76954,2.47462>,
    /*1*/ <1.04918,9.7716,2.46834>,<1.04194,9.77311,2.4839>,<1.03411,9.7639,2.47162>,
            
    /*2*/ <0.64892,10.43331,2.22774>

    /* stem 0.8.1.12*/ 
    /*0*/ <1.06124,10.16564,2.58334>,
    /*1*/ <1.06088,10.16512,2.5859>,<1.05969,10.16737,2.58212>,<1.06316,10.16442,2.58202>,
            
    /*2*/ <1.51003,10.68964,2.75427>

    /* stem 0.8.2*/ 
    /*0*/ <-0.0374,7.40563,0.68478>,
    /*1*/ <-0.07374,7.46671,0.67007>,<0.03101,7.409,0.70879>,<-0.06946,7.3412,0.67548>,
            
    /*2*/ <-0.20568,7.47256,1.05614>,<-0.11141,7.42063,1.09098>,<-0.20183,7.3596,1.06101>,
            
    /*3*/ <-0.31898,7.60458,1.40631>,<-0.2394,7.5612,1.44987>,<-0.32565,7.51032,1.44072>,
            
    /*4*/ <-0.4513,7.82176,1.70669>,<-0.38755,7.79068,1.75876>,<-0.46498,7.74912,1.75441>,
            
    /*5*/ <-0.55448,8.10436,1.97097>,<-0.50109,8.08077,2.01874>,<-0.5706,8.05174,2.02254>,
            
    /*6*/ <-0.67695,8.4305,2.16525>,<-0.63592,8.4194,2.21155>,<-0.69403,8.39566,2.2147>,
            
    /*7*/ <-0.77763,8.78408,2.3364>,<-0.74508,8.7761,2.37388>,<-0.79267,8.76046,2.37817>,
            
    /*8*/ <-0.87636,9.12565,2.54171>,<-0.85128,9.1174,2.56863>,<-0.88686,9.10529,2.57167>,
            
    /*9*/ <-0.94172,9.45644,2.7749>,<-0.92439,9.44871,2.79139>,<-0.94842,9.44192,2.7943>,
            
    /*10*/ <-0.98589,9.78046,3.02003>,<-0.9771,9.77599,3.02783>,<-0.98918,9.77301,3.0296>,
            
    /*11*/ <-1.02493,10.10977,3.25753>

    /* stem 0.8.2.0*/ 
    /*0*/ <-0.10723,7.4118,0.88287>,
    /*1*/ <-0.07947,7.40258,0.89294>,<-0.13292,7.40064,0.89598>,<-0.10929,7.43217,0.85969>,
            
    /*2*/ <-0.09116,8.6003,1.92602>

    /* stem 0.8.2.1*/ 
    /*0*/ <-0.21312,7.46414,1.18909>,
    /*1*/ <-0.2402,7.45349,1.18416>,<-0.20959,7.49232,1.19715>,<-0.18957,7.44662,1.18598>,
            
    /*2*/ <-0.31928,7.06496,2.63283>

    /* stem 0.8.2.2*/ 
    /*0*/ <-0.27672,7.53788,1.37875>,
    /*1*/ <-0.26145,7.56172,1.3746>,<-0.27432,7.52345,1.40334>,<-0.29439,7.52847,1.35831>,
            
    /*2*/ <-1.35367,8.32632,1.94663>

    /* stem 0.8.2.3*/ 
    /*0*/ <-0.38441,7.70522,1.62958>,
    /*1*/ <-0.3842,7.6834,1.64588>,<-0.40675,7.72071,1.62785>,<-0.36228,7.71155,1.61502>,
            
    /*2*/ <0.0742,8.48275,2.66446>

    /* stem 0.8.2.4*/ 
    /*0*/ <-0.48041,7.91157,1.85255>,
    /*1*/ <-0.4955,7.92234,1.83452>,<-0.46361,7.92615,1.86575>,<-0.48214,7.88623,1.8574>,
            
    /*2*/ <-1.3867,8.14463,2.74975>

    /* stem 0.8.2.5*/ 
    /*0*/ <-0.58723,8.19864,2.07282>,
    /*1*/ <-0.56517,8.20145,2.08242>,<-0.60691,8.2038,2.08596>,<-0.58961,8.19067,2.05007>,
            
    /*2*/ <-0.55743,9.33485,1.6715>

    /* stem 0.8.2.6*/ 
    /*0*/ <-0.62951,8.31066,2.13714>,
    /*1*/ <-0.65013,8.30014,2.14192>,<-0.62919,8.33269,2.12861>,<-0.60922,8.29915,2.14091>,
            
    /*2*/ <-0.59231,8.73374,3.23029>

    /* stem 0.8.2.7*/ 
    /*0*/ <-0.73318,8.63897,2.30061>,
    /*1*/ <-0.7232,8.64947,2.2841>,<-0.73092,8.64625,2.32121>,<-0.74542,8.6212,2.29652>,
            
    /*2*/ <-1.60374,9.26746,2.17395>

    /* stem 0.8.2.8*/ 
    /*0*/ <-0.83202,8.98048,2.48233>,
    /*1*/ <-0.82751,8.97163,2.49992>,<-0.84974,8.9899,2.48001>,<-0.81881,8.97991,2.46706>,
            
    /*2*/ <-0.42718,9.8203,2.80096>

    /* stem 0.8.2.9*/ 
    /*0*/ <-0.90141,9.26543,2.66213>,
    /*1*/ <-0.91625,9.26946,2.65181>,<-0.88977,9.27889,2.66727>,<-0.8982,9.24794,2.66729>,
            
    /*2*/ <-1.38628,9.39778,3.4118>

    /* stem 0.8.2.10*/ 
    /*0*/ <-0.95297,9.55459,2.8639>,
    /*1*/ <-0.94091,9.55628,2.8639>,<-0.95921,9.55526,2.87433>,<-0.95878,9.55222,2.85347>,
            
    /*2*/ <-1.06515,10.35509,2.7451>

    /* stem 0.8.2.11*/ 
    /*0*/ <-0.97531,9.71404,2.98025>,
    /*1*/ <-0.98141,9.7099,2.98475>,<-0.97686,9.72195,2.97714>,<-0.96766,9.71027,2.97887>,
            
    /*2*/ <-0.70516,10.02325,3.63086>

    /* stem 0.8.2.12*/ 
    /*0*/ <-1.00573,9.95322,3.14869>,
    /*1*/ <-1.00541,9.95519,3.14592>,<-1.00434,9.9542,3.15164>,<-1.00745,9.95029,3.1485>,
            
    /*2*/ <-1.59533,10.28803,3.31756>

    /* stem 0.8.3*/ 
    /*0*/ <-0.04977,7.47933,1.02129>,
    /*1*/ <0.01624,7.45644,1.02873>,<-0.10271,7.44427,1.05139>,<-0.06285,7.53727,0.98375>,
            
    /*2*/ <0.04905,7.67789,1.35253>,<-0.05801,7.66694,1.37292>,<-0.02213,7.75063,1.31205>,
            
    /*3*/ <0.04666,7.96147,1.6385>,<-0.04893,7.949,1.65214>,<-0.01711,8.01428,1.58728>,
            
    /*4*/ <0.0556,8.29052,1.85808>,<-0.02787,8.2839,1.87376>,<-0.00059,8.32817,1.80628>,
            
    /*5*/ <0.07083,8.63406,2.05061>,<-0.0006,8.63028,2.0653>,<0.02246,8.66338,2.00443>,
            
    /*6*/ <0.06756,8.98563,2.23276>,<0.00794,8.98042,2.24377>,<0.02721,9.00711,2.19259>,
            
    /*7*/ <0.0517,9.34049,2.40549>,<0.004,9.33521,2.41368>,<0.01948,9.35596,2.37245>,
            
    /*8*/ <0.08026,9.70912,2.53473>,<0.04467,9.70961,2.54286>,<0.056,9.72033,2.50985>,
            
    /*9*/ <0.15301,10.0457,2.71846>,<0.12958,10.04776,2.72475>,<0.13747,10.05745,2.70386>,
            
    /*10*/ <0.19413,10.40954,2.86728>,<0.1823,10.40993,2.87009>,<0.18611,10.41393,2.85925>,
            
    /*11*/ <0.26041,10.7488,3.05416>

    /* stem 0.8.3.0*/ 
    /*0*/ <-0.0224,7.63156,1.24672>,
    /*1*/ <-0.04997,7.6244,1.25491>,<-0.01253,7.65925,1.25052>,<-0.00469,7.61103,1.23474>,
            
    /*2*/ <0.48094,7.26378,2.62064>

    /* stem 0.8.3.1*/ 
    /*0*/ <-0.00792,7.8716,1.52127>,
    /*1*/ <0.00573,7.88898,1.50394>,<0.00015,7.86932,1.54808>,<-0.02963,7.85651,1.5118>,
            
    /*2*/ <-0.89415,8.92326,1.87774>

    /* stem 0.8.3.2*/ 
    /*0*/ <-0.00445,8.0172,1.65452>,
    /*1*/ <0.00089,8.00208,1.67654>,<-0.02305,8.03705,1.65582>,<0.00882,8.01247,1.63121>,
            
    /*2*/ <0.97152,8.90745,2.02939>

    /* stem 0.8.3.3*/ 
    /*0*/ <0.00469,8.20921,1.78416>,
    /*1*/ <-0.01578,8.21905,1.77101>,<0.02606,8.22392,1.7881>,<0.00378,8.18465,1.79336>,
            
    /*2*/ <-0.50835,8.65149,2.91422>

    /* stem 0.8.3.4*/ 
    /*0*/ <0.02053,8.4804,1.94801>,
    /*1*/ <0.04535,8.47954,1.94674>,<0.00929,8.48289,1.97005>,<0.00695,8.47877,1.92724>,
            
    /*2*/ <0.05734,9.71529,1.8272>

    /* stem 0.8.3.5*/ 
    /*0*/ <0.03197,8.7543,2.09876>,
    /*1*/ <0.01437,8.74719,2.11264>,<0.03127,8.77563,2.08889>,<0.05026,8.74009,2.09476>,
            
    /*2*/ <0.58171,9.201,3.02521>

    /* stem 0.8.3.6*/ 
    /*0*/ <0.02775,9.24042,2.34613>,
    /*1*/ <0.03089,9.24973,2.32743>,<0.03723,9.24799,2.36342>,<0.01514,9.22353,2.34754>,
            
    /*2*/ <-0.78315,9.8604,2.51896>

    /* stem 0.8.3.7*/ 
    /*0*/ <0.034,9.43751,2.43067>,
    /*1*/ <0.0446,9.43085,2.44649>,<0.018,9.44945,2.43356>,<0.0394,9.43224,2.41197>,
            
    /*2*/ <0.61485,10.22937,2.37512>

    /* stem 0.8.3.8*/ 
    /*0*/ <0.07523,9.77615,2.56406>,
    /*1*/ <0.0581,9.78222,2.56041>,<0.08991,9.7864,2.55926>,<0.07768,9.75984,2.57252>,
            
    /*2*/ <0.05032,10.18501,3.36032>

    /* stem 0.8.3.9*/ 
    /*0*/ <0.11418,9.94095,2.65521>,
    /*1*/ <0.12914,9.94103,2.64866>,<0.11232,9.94251,2.67136>,<0.10107,9.9393,2.6456>,
            
    /*2*/ <0.07158,10.78473,2.56862>

    /* stem 0.8.3.10*/ 
    /*0*/ <0.1704,10.28111,2.81155>,
    /*1*/ <0.16589,10.2784,2.81952>,<0.16785,10.2892,2.80713>,<0.17746,10.27575,2.80798>,
            
    /*2*/ <0.67371,10.66653,3.22755>

    /* stem 0.8.3.11*/ 
    /*0*/ <0.21195,10.52431,2.92876>,
    /*1*/ <0.21109,10.52669,2.92483>,<0.21575,10.52528,2.9313>,<0.209,10.52096,2.93015>,
            
    /*2*/ <-0.14848,10.99219,3.29041>

    /* stem 0.8.4*/ 
    /*0*/ <-0.03737,7.56064,1.31571>,
    /*1*/ <-0.10124,7.53977,1.32744>,<-0.0187,7.62416,1.3321>,<0.00782,7.51799,1.28759>,
            
    /*2*/ <0.00793,7.42221,1.67287>,<0.08221,7.49816,1.67706>,<0.10608,7.40261,1.637>,
            
    /*3*/ <0.18776,7.4803,2.02491>,<0.23584,7.55306,1.98848>,<0.27248,7.46599,1.98555>,
            
    /*4*/ <0.37672,7.64222,2.32532>,<0.40816,7.70024,2.27548>,<0.44944,7.62968,2.288>,
            
    /*5*/ <0.576,7.90211,2.54063>,<0.59095,7.93983,2.48251>,<0.63515,7.88872,2.50393>,
            
    /*6*/ <0.76376,8.21696,2.66869>,<0.76858,8.23744,2.61349>,<0.81103,8.20313,2.63607>,
            
    /*7*/ <0.93384,8.50351,2.84334>,<0.94115,8.52528,2.80204>,<0.97365,8.49555,2.81915>,
            
    /*8*/ <1.08505,8.81891,2.99608>,<1.08939,8.83308,2.96388>,<1.11528,8.81367,2.97835>,
            
    /*9*/ <1.15337,9.17592,3.1084>,<1.15555,9.18296,3.08595>,<1.17453,9.17556,3.09791>,
            
    /*10*/ <1.16482,9.55289,3.16536>,<1.16576,9.5548,3.15374>,<1.17549,9.55351,3.16032>,
            
    /*11*/ <1.24361,9.92496,3.1997>

    /* stem 0.8.4.0*/ 
    /*0*/ <0.02959,7.48268,1.54153>,
    /*1*/ <0.04612,7.50611,1.54472>,<0.04081,7.45644,1.5457>,<0.00184,7.4855,1.53418>,
            
    /*2*/ <-0.3386,7.55009,2.95653>

    /* stem 0.8.4.1*/ 
    /*0*/ <0.16093,7.4747,1.85571>,
    /*1*/ <0.16752,7.44819,1.85708>,<0.148,7.48667,1.87663>,<0.16728,7.48923,1.83343>,
            
    /*2*/ <1.37638,7.80578,2.41775>

    /* stem 0.8.4.2*/ 
    /*0*/ <0.28275,7.54434,2.08351>,
    /*1*/ <0.26191,7.55953,2.08805>,<0.30687,7.55449,2.08474>,<0.27948,7.519,2.07775>,
            
    /*2*/ <0.34336,7.24565,3.36228>

    /* stem 0.8.4.3*/ 
    /*0*/ <0.34516,7.59916,2.18669>,
    /*1*/ <0.36704,7.59933,2.17337>,<0.34502,7.59104,2.21099>,<0.32342,7.60711,2.17572>,
            
    /*2*/ <0.58004,8.79486,2.58757>

    /* stem 0.8.4.4*/ 
    /*0*/ <0.48889,7.76084,2.38333>,
    /*1*/ <0.48027,7.75031,2.40351>,<0.48565,7.78469,2.37972>,<0.50073,7.74753,2.36676>,
            
    /*2*/ <1.53594,7.98835,2.94899>

    /* stem 0.8.4.5*/ 
    /*0*/ <0.69518,8.07201,2.57731>,
    /*1*/ <0.68691,8.08405,2.56022>,<0.71614,8.07571,2.58457>,<0.68249,8.05626,2.58714>,
            
    /*2*/ <0.31328,8.8278,3.29463>

    /* stem 0.8.4.6*/ 
    /*0*/ <0.88639,8.39976,2.75323>,
    /*1*/ <0.90243,8.38758,2.75772>,<0.87747,8.41099,2.76808>,<0.87926,8.40073,2.73388>,
            
    /*2*/ <1.51926,9.16111,2.55787>

    /* stem 0.8.4.7*/ 
    /*0*/ <0.99434,8.6037,2.86962>,
    /*1*/ <0.97677,8.60839,2.87665>,<1.0056,8.61743,2.86157>,<1.00064,8.58528,2.87064>,
            
    /*2*/ <1.38079,8.78272,3.71546>

    /* stem 0.8.4.8*/ 
    /*0*/ <1.12067,8.95485,3.02347>,
    /*1*/ <1.13076,8.95773,3.00924>,<1.1256,8.96116,3.03922>,<1.10566,8.94565,3.02194>,
            
    /*2*/ <0.69593,9.67377,2.86808>

    /* stem 0.8.4.9*/ 
    /*0*/ <1.15001,9.11667,3.07706>,
    /*1*/ <1.15118,9.11183,3.09102>,<1.14302,9.12942,3.0742>,<1.15582,9.10875,3.06596>,
            
    /*2*/ <1.84735,9.51661,3.15683>

    /* stem 0.8.4.10*/ 
    /*0*/ <1.16396,9.31809,3.12067>,
    /*1*/ <1.15605,9.31953,3.11301>,<1.17343,9.32384,3.12>,<1.16239,9.31092,3.12899>,
            
    /*2*/ <0.85794,9.87061,3.53979>

    /* stem 0.8.4.11*/ 
    /*0*/ <1.19249,9.67165,3.17247>,
    /*1*/ <1.19704,9.6707,3.17272>,<1.19055,9.67459,3.17552>,<1.18987,9.66965,3.16918>,
            
    /*2*/ <1.32127,10.18488,2.75881>

    /* stem 0.8.5*/ 
    /*0*/ <-0.01938,7.62652,1.53084>,
    /*1*/ <0.0138,7.681,1.51138>,<0.00617,7.58703,1.57811>,<-0.07811,7.61154,1.50302>,
            
    /*2*/ <-0.16374,7.87474,1.7739>,<-0.1706,7.79016,1.83396>,<-0.24646,7.81222,1.76638>,
            
    /*3*/ <-0.2906,8.10884,2.01769>,<-0.30077,8.04089,2.07948>,<-0.37037,8.06246,2.02266>,
            
    /*4*/ <-0.38545,8.38859,2.22667>,<-0.39815,8.33896,2.28923>,<-0.45866,8.3564,2.23852>,
            
    /*5*/ <-0.48571,8.68751,2.4188>,<-0.49792,8.64869,2.4749>,<-0.54879,8.66084,2.42943>,
            
    /*6*/ <-0.56706,8.9954,2.60585>,<-0.5776,8.96467,2.6536>,<-0.62038,8.97593,2.61647>,
            
    /*7*/ <-0.6307,9.31904,2.7702>,<-0.6398,9.29775,2.81018>,<-0.67394,9.30624,2.78024>,
            
    /*8*/ <-0.66111,9.6314,2.96954>,<-0.66751,9.61308,2.99825>,<-0.69373,9.62341,2.97808>,
            
    /*9*/ <-0.66678,9.96615,3.12353>,<-0.67112,9.95693,3.14426>,<-0.6886,9.963,3.13043>,
            
    /*10*/ <-0.68207,10.31125,3.25913>,<-0.68426,10.30718,3.26972>,<-0.69298,10.30961,3.26255>,
            
    /*11*/ <-0.64014,10.65431,3.39335>

    /* stem 0.8.5.0*/ 
    /*0*/ <-0.12624,7.7487,1.69067>,
    /*1*/ <-0.12376,7.72716,1.7088>,<-0.15156,7.76035,1.68595>,<-0.10341,7.7586,1.67727>,
            
    /*2*/ <0.09997,8.67358,2.75876>

    /* stem 0.8.5.1*/ 
    /*0*/ <-0.23991,7.91506,1.88205>,
    /*1*/ <-0.25734,7.92464,1.86369>,<-0.22554,7.9322,1.8973>,<-0.23683,7.88835,1.88515>,
            
    /*2*/ <-1.23,7.91006,2.82009>

    /* stem 0.8.5.2*/ 
    /*0*/ <-0.3418,8.13668,2.08795>,
    /*1*/ <-0.31726,8.13939,2.09508>,<-0.36056,8.13899,2.10535>,<-0.34757,8.13167,2.06342>,
            
    /*2*/ <-0.4108,9.39894,1.84619>

    /* stem 0.8.5.3*/ 
    /*0*/ <-0.39078,8.28889,2.19875>,
    /*1*/ <-0.41147,8.27708,2.20583>,<-0.391,8.31354,2.19562>,<-0.36987,8.27604,2.1948>,
            
    /*2*/ <-0.07189,8.44268,3.38751>

    /* stem 0.8.5.4*/ 
    /*0*/ <-0.45351,8.48538,2.32875>,
    /*1*/ <-0.44546,8.499,2.31098>,<-0.44577,8.48899,2.35096>,<-0.4693,8.46814,2.32431>,
            
    /*2*/ <-1.33756,9.24777,2.5129>

    /* stem 0.8.5.5*/ 
    /*0*/ <-0.5476,8.8142,2.52848>,
    /*1*/ <-0.54049,8.80494,2.5472>,<-0.56732,8.82408,2.52785>,<-0.53499,8.81358,2.51038>,
            
    /*2*/ <-0.08576,9.7543,2.81808>

    /* stem 0.8.5.6*/ 
    /*0*/ <-0.6093,9.09396,2.68192>,
    /*1*/ <-0.62666,9.09617,2.671>,<-0.59481,9.10863,2.68134>,<-0.60643,9.07708,2.69343>,
            
    /*2*/ <-1.0444,9.55495,3.46649>

    /* stem 0.8.5.7*/ 
    /*0*/ <-0.65649,9.40891,2.84958>,
    /*1*/ <-0.63776,9.41165,2.84765>,<-0.66467,9.41078,2.86666>,<-0.66705,9.4043,2.83443>,
            
    /*2*/ <-0.80473,10.30324,2.68083>

    /* stem 0.8.5.8*/ 
    /*0*/ <-0.67457,9.73401,3.03144>,
    /*1*/ <-0.68592,9.72864,3.04343>,<-0.67717,9.74903,3.02314>,<-0.66063,9.72436,3.02775>,
            
    /*2*/ <-0.24224,10.13363,3.61985>

    /* stem 0.8.5.9*/ 
    /*0*/ <-0.6751,9.86381,3.08911>,
    /*1*/ <-0.67488,9.87001,3.07516>,<-0.66648,9.86973,3.10023>,<-0.68394,9.85168,3.09193>,
            
    /*2*/ <-1.27466,10.34889,3.29518>

    /* stem 0.8.5.10*/ 
    /*0*/ <-0.68131,10.14665,3.20241>,
    /*1*/ <-0.67514,10.14414,3.20958>,<-0.68978,10.15108,3.20456>,<-0.67902,10.14474,3.19308>,
            
    /*2*/ <-0.35679,10.79293,3.14958>

    /* stem 0.8.5.11*/ 
    /*0*/ <-0.67238,10.41412,3.30314>,
    /*1*/ <-0.6769,10.41495,3.30253>,<-0.66926,10.41744,3.30224>,<-0.67097,10.40996,3.30465>,
            
    /*2*/ <-0.71701,10.62396,3.92337>

    /* stem 0.8.6*/ 
    /*0*/ <0.03453,7.83912,2.17003>,
    /*1*/ <0.04551,7.78104,2.18911>,<-0.01081,7.87241,2.19638>,<0.06888,7.86391,2.12461>,
            
    /*2*/ <0.26685,7.90539,2.4201>,<0.21617,7.98763,2.42665>,<0.28789,7.97997,2.36205>,
            
    /*3*/ <0.43737,8.0665,2.67836>,<0.38494,8.13449,2.67238>,<0.45739,8.1318,2.626>,
            
    /*4*/ <0.60909,8.24829,2.91869>,<0.56113,8.30585,2.91104>,<0.62343,8.30288,2.86883>,
            
    /*5*/ <0.7443,8.5215,3.10475>,<0.695,8.55903,3.08665>,<0.74869,8.55681,3.05089>,
            
    /*6*/ <0.86211,8.83335,3.21645>,<0.81786,8.85757,3.19777>,<0.8611,8.8525,3.16619>,
            
    /*7*/ <1.00561,9.11054,3.34909>,<0.97235,9.13466,3.33631>,<1.00635,9.12946,3.31045>,
            
    /*8*/ <1.13969,9.38073,3.5099>,<1.115,9.39924,3.50046>,<1.14145,9.39703,3.4821>,
            
    /*9*/ <1.30864,9.66472,3.60954>,<1.29212,9.67708,3.60345>,<1.30789,9.67259,3.58952>,
            
    /*10*/ <1.49486,9.92166,3.73635>,<1.4872,9.92874,3.7337>,<1.49508,9.92647,3.72673>,
            
    /*11*/ <1.65814,10.1988,3.85745>

    /* stem 0.8.6.0*/ 
    /*0*/ <0.16159,7.90684,2.30307>,
    /*1*/ <0.14546,7.92708,2.30818>,<0.18758,7.91089,2.30093>,<0.15174,7.88253,2.30011>,
            
    /*2*/ <0.30267,7.69116,3.60348>

    /* stem 0.8.6.1*/ 
    /*0*/ <0.36208,8.05265,2.56157>,
    /*1*/ <0.3836,8.04803,2.55008>,<0.35985,8.04841,2.58594>,<0.34277,8.06151,2.5487>,
            
    /*2*/ <0.73642,9.21035,2.79726>

    /* stem 0.8.6.2*/ 
    /*0*/ <0.50485,8.19078,2.76886>,
    /*1*/ <0.49099,8.18144,2.78551>,<0.51154,8.21335,2.77037>,<0.51202,8.17755,2.7507>,
            
    /*2*/ <1.45181,7.86939,3.37695>

    /* stem 0.8.6.3*/ 
    /*0*/ <0.67408,8.43644,3.00458>,
    /*1*/ <0.67204,8.4496,2.98718>,<0.69287,8.436,3.01583>,<0.65733,8.42374,3.01072>,
            
    /*2*/ <0.3104,9.22497,3.64322>

    /* stem 0.8.6.4*/ 
    /*0*/ <0.76388,8.63445,3.11385>,
    /*1*/ <0.77912,8.62467,3.12415>,<0.75398,8.6505,3.12269>,<0.75855,8.62818,3.09472>,
            
    /*2*/ <1.44666,9.2763,2.71333>

    /* stem 0.8.6.5*/ 
    /*0*/ <0.82346,8.78733,3.1709>,
    /*1*/ <0.80462,8.79363,3.17368>,<0.83716,8.79978,3.16319>,<0.82859,8.76858,3.17585>,
            
    /*2*/ <1.05698,9.08844,4.07099>

    /* stem 0.8.6.6*/ 
    /*0*/ <0.90843,8.96297,3.25103>,
    /*1*/ <0.92186,8.96261,3.23743>,<0.91296,8.9684,3.26879>,<0.89047,8.95791,3.24687>,
            
    /*2*/ <0.71106,9.84173,3.03287>

    /* stem 0.8.6.7*/ 
    /*0*/ <1.07692,9.28494,3.43101>,
    /*1*/ <1.07325,9.27745,3.44617>,<1.07559,9.3021,3.4293>,<1.08193,9.27527,3.41757>,
            
    /*2*/ <1.86799,9.36978,3.6649>

    /* stem 0.8.6.8*/ 
    /*0*/ <1.22454,9.54346,3.55344>,
    /*1*/ <1.21747,9.55175,3.54275>,<1.23979,9.54347,3.55426>,<1.21637,9.53516,3.56332>,
            
    /*2*/ <1.19907,10.12883,4.02418>

    /* stem 0.8.6.9*/ 
    /*0*/ <1.39199,9.79097,3.66264>,
    /*1*/ <1.39936,9.78504,3.66347>,<1.39055,9.79772,3.66917>,<1.38605,9.79016,3.65526>,
            
    /*2*/ <1.77553,10.2177,3.30688>

    /* stem 0.8.6.10*/ 
    /*0*/ <1.55407,10.02728,3.77885>,
    /*1*/ <1.55086,10.02834,3.7808>,<1.55603,10.02992,3.77675>,<1.55532,10.02359,3.77901>,
            
    /*2*/ <1.88929,10.16065,4.25929>

    /* stem 0.8.7*/ 
    /*0*/ <0.06561,7.96161,2.48055>,
    /*1*/ <0.0196,7.99823,2.46954>,<0.11952,7.98427,2.49319>,<0.05772,7.90233,2.47892>,
            
    /*2*/ <-0.05147,7.99582,2.79101>,<0.03846,7.98326,2.8123>,<-0.01716,7.90951,2.79945>,
            
    /*3*/ <-0.1827,8.07066,3.06403>,<-0.11048,8.05914,3.10308>,<-0.16339,7.99593,3.09426>,
            
    /*4*/ <-0.3116,8.21736,3.31934>,<-0.25017,8.20849,3.35688>,<-0.30198,8.1578,3.35961>,
            
    /*5*/ <-0.37407,8.41897,3.57301>,<-0.3181,8.40714,3.59736>,<-0.36697,8.37218,3.61333>,
            
    /*6*/ <-0.43965,8.63714,3.8073>,<-0.39352,8.62861,3.82929>,<-0.43468,8.60067,3.84376>,
            
    /*7*/ <-0.48506,8.89429,4.00278>,<-0.44823,8.88797,4.02072>,<-0.48222,8.87009,4.03631>,
            
    /*8*/ <-0.46434,9.1637,4.19447>,<-0.43636,9.15483,4.20472>,<-0.462,9.14602,4.21993>,
            
    /*9*/ <-0.48844,9.45476,4.33824>,<-0.46987,9.45227,4.3471>,<-0.48699,9.44598,4.35695>,
            
    /*10*/ <-0.49934,9.7625,4.4526>,<-0.49006,9.76134,4.45706>,<-0.49867,9.75907,4.46236>,
            
    /*11*/ <-0.50949,10.07361,4.55952>

    /* stem 0.8.7.0*/ 
    /*0*/ <0.02708,7.96225,2.64368>,
    /*1*/ <0.05189,7.96325,2.64953>,<0.01104,7.94893,2.65837>,<0.01832,7.97457,2.62314>,
            
    /*2*/ <-0.18308,9.00055,3.3559>

    /* stem 0.8.7.1*/ 
    /*0*/ <-0.07896,8.00118,2.93966>,
    /*1*/ <-0.09678,7.98559,2.93512>,<-0.08399,8.02293,2.94878>,<-0.05609,7.99503,2.93509>,
            
    /*2*/ <0.02406,7.55967,4.05012>

    /* stem 0.8.7.2*/ 
    /*0*/ <-0.20251,8.0985,3.18284>,
    /*1*/ <-0.19484,8.11855,3.17502>,<-0.20202,8.09404,3.20524>,<-0.21068,8.08293,3.16826>,
            
    /*2*/ <-1.23726,8.53756,3.29314>

    /* stem 0.8.7.3*/ 
    /*0*/ <-0.31055,8.26575,3.43191>,
    /*1*/ <-0.30452,8.25066,3.44589>,<-0.32989,8.27483,3.43363>,<-0.29724,8.27176,3.41622>,
            
    /*2*/ <0.09347,9.00806,4.05883>

    /* stem 0.8.7.4*/ 
    /*0*/ <-0.37248,8.46162,3.65941>,
    /*1*/ <-0.38868,8.46737,3.64904>,<-0.36105,8.47533,3.66861>,<-0.3677,8.44215,3.66058>,
            
    /*2*/ <-0.91954,8.37609,4.46637>

    /* stem 0.8.7.5*/ 
    /*0*/ <-0.4124,8.58944,3.79269>,
    /*1*/ <-0.39369,8.59361,3.7943>,<-0.42354,8.58895,3.80838>,<-0.41999,8.58577,3.77539>,
            
    /*2*/ <-0.60489,9.49628,3.68464>

    /* stem 0.8.7.6*/ 
    /*0*/ <-0.4487,8.76099,3.92915>,
    /*1*/ <-0.46169,8.75189,3.93818>,<-0.45219,8.77759,3.92243>,<-0.43223,8.75348,3.92684>,
            
    /*2*/ <-0.17774,9.12332,4.68376>

    /* stem 0.8.7.7*/ 
    /*0*/ <-0.46613,8.97188,4.08037>,
    /*1*/ <-0.46444,8.98144,4.06633>,<-0.45767,8.97604,4.0946>,<-0.47628,8.95815,4.08018>,
            
    /*2*/ <-1.09595,9.43426,4.31952>

    /* stem 0.8.7.8*/ 
    /*0*/ <-0.47019,9.32648,4.28812>,
    /*1*/ <-0.46211,9.32194,4.29925>,<-0.4813,9.33548,4.29044>,<-0.46716,9.32204,4.27468>,
            
    /*2*/ <-0.03306,9.88924,4.20069>

    /* stem 0.8.7.9*/ 
    /*0*/ <-0.48715,9.56804,4.38893>,
    /*1*/ <-0.49646,9.56857,4.38623>,<-0.48114,9.57544,4.38712>,<-0.48385,9.5601,4.39344>,
            
    /*2*/ <-0.63999,9.83347,4.96776>

    /* stem 0.8.7.10*/ 
    /*0*/ <-0.50276,9.91734,4.50845>,
    /*1*/ <-0.50002,9.91782,4.50734>,<-0.50349,9.91842,4.51114>,<-0.50476,9.91578,4.50686>,
            
    /*2*/ <-0.68428,10.39599,4.26656>

    /* stem 0.8.8*/ 
    /*0*/ <0.1442,8.32167,3.22975>,
    /*1*/ <0.19493,8.32059,3.22575>,<0.12109,8.29622,3.26728>,<0.11659,8.3482,3.19622>,
            
    /*2*/ <0.20852,8.55834,3.3988>,<0.14206,8.53641,3.43618>,<0.13801,8.58319,3.37223>,
            
    /*3*/ <0.15662,8.81069,3.5607>,<0.09762,8.78262,3.58724>,<0.09508,8.82013,3.52757>,
            
    /*4*/ <0.09787,9.05433,3.71703>,<0.04643,9.02865,3.73946>,<0.04428,9.06158,3.68731>,
            
    /*5*/ <0.08737,9.30338,3.86238>,<0.04262,9.28838,3.88625>,<0.0406,9.31501,3.84059>,
            
    /*6*/ <0.02638,9.55825,4.00735>,<-0.01046,9.54068,4.024>,<-0.01173,9.5622,3.98555>,
            
    /*7*/ <0.01346,9.82438,4.12243>,<-0.01668,9.81632,4.13888>,<-0.01745,9.83032,4.10652>,
            
    /*8*/ <0.04431,10.09962,4.21259>,<0.02198,10.0979,4.22666>,<0.02119,10.10623,4.20157>,
            
    /*9*/ <0.03257,10.36254,4.34945>,<0.01745,10.35804,4.35733>,<0.01716,10.36618,4.34169>,
            
    /*10*/ <0.02321,10.62433,4.48354>,<0.01565,10.62217,4.48753>,<0.01551,10.62618,4.47968>,
            
    /*11*/ <0.02475,10.89941,4.58779>

    /* stem 0.8.8.0*/ 
    /*0*/ <0.15362,8.44162,3.31689>,
    /*1*/ <0.13776,8.43374,3.32945>,<0.1526,8.46205,3.30965>,<0.17051,8.42906,3.31159>,
            
    /*2*/ <0.71176,8.79923,4.24641>

    /* stem 0.8.8.1*/ 
    /*0*/ <0.14709,8.64261,3.45544>,
    /*1*/ <0.1499,8.65399,3.43839>,<0.15426,8.64931,3.47365>,<0.13712,8.62452,3.45427>,
            
    /*2*/ <-0.79223,9.14886,3.63868>

    /* stem 0.8.8.2*/ 
    /*0*/ <0.07734,8.98235,3.67243>,
    /*1*/ <0.08724,8.97521,3.68698>,<0.06135,8.99207,3.67569>,<0.08342,8.97976,3.65462>,
            
    /*2*/ <0.59644,9.81697,3.72855>

    /* stem 0.8.8.3*/ 
    /*0*/ <0.05946,9.1922,3.79876>,
    /*1*/ <0.04236,9.19467,3.79384>,<0.07163,9.20507,3.79574>,<0.0644,9.17686,3.8067>,
            
    /*2*/ <-0.12548,9.56134,4.6269>

    /* stem 0.8.8.4*/ 
    /*0*/ <0.02492,9.44708,3.94518>,
    /*1*/ <0.04017,9.45267,3.94125>,<0.01826,9.45072,3.96007>,<0.01632,9.43785,3.93421>,
            
    /*2*/ <-0.31944,10.15684,3.61791>

    /* stem 0.8.8.5*/ 
    /*0*/ <-0.00423,9.73686,4.08499>,
    /*1*/ <-0.0116,9.73133,4.09725>,<-0.00843,9.75031,4.07894>,<0.00735,9.72895,4.07879>,
            
    /*2*/ <0.49626,10.10332,4.55159>

    /* stem 0.8.8.6*/ 
    /*0*/ <0.01837,10.01815,4.18637>,
    /*1*/ <0.01554,10.02277,4.17341>,<0.02934,10.02335,4.19343>,<0.01023,10.00834,4.19226>,
            
    /*2*/ <-0.39342,10.52165,4.45569>

    /* stem 0.8.8.7*/ 
    /*0*/ <0.02592,10.22633,4.27873>,
    /*1*/ <0.03588,10.22281,4.286>,<0.01639,10.23326,4.28382>,<0.02548,10.22293,4.26637>,
            
    /*2*/ <0.33718,10.77249,4.11742>

    /* stem 0.8.8.8*/ 
    /*0*/ <0.02079,10.46062,4.39984>,
    /*1*/ <0.01252,10.46045,4.39991>,<0.02477,10.46763,4.39801>,<0.02508,10.45377,4.4016>,
            
    /*2*/ <0.02252,10.60725,4.96687>

    /* stem 0.8.8.9*/ 
    /*0*/ <0.02118,10.75124,4.53168>,
    /*1*/ <0.02325,10.75183,4.52998>,<0.02113,10.75232,4.5342>,<0.01917,10.74957,4.53086>,
            
    /*2*/ <-0.23935,11.15099,4.35458>

    /* stem 0.8.9*/ 
    /*0*/ <0.20241,9.01136,4.34792>,
    /*1*/ <0.18028,8.99661,4.36089>,<0.20031,9.0406,4.34383>,<0.22665,8.99689,4.33903>,
            
    /*2*/ <0.28312,9.0352,4.57356>,<0.30114,9.07479,4.55821>,<0.32485,9.03545,4.55389>,
            
    /*3*/ <0.38647,9.17864,4.74612>,<0.39453,9.20715,4.71777>,<0.42214,9.17794,4.7259>,
            
    /*4*/ <0.47867,9.3468,4.89254>,<0.48385,9.36877,4.86465>,<0.50972,9.34597,4.87457>,
            
    /*5*/ <0.57427,9.52584,5.02233>,<0.57763,9.54287,4.99694>,<0.6003,9.52418,5.00604>,
            
    /*6*/ <0.64587,9.70527,5.16108>,<0.64917,9.72022,5.14053>,<0.66854,9.70581,5.14914>,
            
    /*7*/ <0.71049,9.90637,5.27636>,<0.71239,9.91625,5.2585>,<0.72849,9.90646,5.26656>,
            
    /*8*/ <0.76424,10.11898,5.37364>,<0.76536,10.12528,5.35966>,<0.77777,10.11909,5.36632>,
            
    /*9*/ <0.8107,10.33911,5.45639>,<0.81131,10.3427,5.4468>,<0.81971,10.33916,5.4515>,
            
    /*10*/ <0.80479,10.55542,5.55618>,<0.80514,10.55762,5.55157>,<0.80939,10.55651,5.55421>,
            
    /*11*/ <0.80256,10.77292,5.65617>

    /* stem 0.8.9.0*/ 
    /*0*/ <0.25512,9.03081,4.46>,
    /*1*/ <0.25818,9.04253,4.45653>,<0.26308,9.02405,4.46707>,<0.24411,9.02584,4.45641>,
            
    /*2*/ <-0.14469,9.36256,5.22809>

    /* stem 0.8.9.1*/ 
    /*0*/ <0.3285,9.08471,4.60556>,
    /*1*/ <0.33523,9.07541,4.60935>,<0.32216,9.09123,4.61352>,<0.32813,9.0875,4.5938>,
            
    /*2*/ <1.01938,9.62749,4.71194>

    /* stem 0.8.9.2*/ 
    /*0*/ <0.55386,9.47363,4.96598>,
    /*1*/ <0.54438,9.47759,4.96737>,<0.56193,9.47995,4.96437>,<0.55528,9.46337,4.96618>,
            
    /*2*/ <0.67574,9.50541,5.70147>

    /* stem 0.8.9.3*/ 
    /*0*/ <0.63217,9.65349,5.10525>,
    /*1*/ <0.63997,9.6548,5.09973>,<0.63303,9.6534,5.11486>,<0.62352,9.65228,5.10118>,
            
    /*2*/ <0.52936,10.33397,5.12122>

    /* stem 0.8.9.4*/ 
    /*0*/ <0.69284,9.8324,5.2218>,
    /*1*/ <0.69053,9.82857,5.22957>,<0.69058,9.84092,5.22015>,<0.69742,9.82772,5.21568>,
            
    /*2*/ <1.23901,10.02725,5.48058>

    /* stem 0.8.9.5*/ 
    /*0*/ <0.75262,10.05401,5.33499>,
    /*1*/ <0.74916,10.05785,5.32865>,<0.7601,10.05619,5.3375>,<0.74861,10.048,5.33883>,
            
    /*2*/ <0.5207,10.43708,5.69331>

    /* stem 0.8.9.6*/ 
    /*0*/ <0.80945,10.46928,5.51266>,
    /*1*/ <0.81325,10.46866,5.51423>,<0.80631,10.4703,5.51516>,<0.80881,10.46886,5.50857>,
            
    /*2*/ <0.90761,10.91824,5.45188>

    /* stem 0.8.9.7*/ 
    /*0*/ <0.80544,10.61205,5.58021>,
    /*1*/ <0.80333,10.61176,5.58075>,<0.80612,10.61399,5.57942>,<0.80688,10.61041,5.58047>,
            
    /*2*/ <0.88715,10.74634,5.97578>

    /* stem 0.8.10*/ 
    /*0*/ <0.24877,9.37734,4.82691>,
    /*1*/ <0.25167,9.39259,4.8146>,<0.26332,9.3715,4.83905>,<0.23133,9.36793,4.8271>,
            
    /*2*/ <0.18021,9.52597,4.9661>,<0.19069,9.50699,4.9881>,<0.16191,9.50377,4.97735>,
            
    /*3*/ <0.12145,9.69214,5.08004>,<0.12905,9.67925,5.10307>,<0.10338,9.67661,5.09369>,
            
    /*4*/ <0.07004,9.85964,5.20372>,<0.07699,9.84756,5.2233>,<0.05422,9.84614,5.21576>,
            
    /*5*/ <0.07154,10.04179,5.31227>,<0.07763,10.03182,5.32923>,<0.05755,10.03427,5.32538>,
            
    /*6*/ <0.07886,10.22263,5.42718>,<0.08392,10.2138,5.441>,<0.0672,10.21633,5.43809>,
            
    /*7*/ <0.10542,10.39121,5.55763>,<0.10937,10.38286,5.56779>,<0.09611,10.38609,5.56632>,
            
    /*8*/ <0.15873,10.56824,5.66339>,<0.16191,10.5626,5.67139>,<0.15214,10.56582,5.67092>,
            
    /*9*/ <0.20223,10.74017,5.78422>,<0.20424,10.73611,5.78938>,<0.19768,10.73809,5.78892>,
            
    /*10*/ <0.23305,10.93525,5.86487>,<0.2342,10.93389,5.86781>,<0.23086,10.93458,5.86742>,
            
    /*11*/ <0.25059,11.13141,5.94904>

    /* stem 0.8.10.0*/ 
    /*0*/ <0.20803,9.45458,4.91295>,
    /*1*/ <0.21213,9.45018,4.91884>,<0.19994,9.45661,4.91408>,<0.21202,9.45694,4.90592>,
            
    /*2*/ <0.43666,10.1594,5.28029>

    /* stem 0.8.10.1*/ 
    /*0*/ <0.0905,9.77359,5.15811>,
    /*1*/ <0.08379,9.77395,5.15481>,<0.09471,9.77975,5.15873>,<0.093,9.76706,5.1608>,
            
    /*2*/ <-0.21691,9.91979,5.7993>

    /* stem 0.8.10.2*/ 
    /*0*/ <0.06797,9.94036,5.26642>,
    /*1*/ <0.07469,9.94136,5.2646>,<0.0661,9.94051,5.2732>,<0.06311,9.9392,5.26146>,
            
    /*2*/ <-0.04377,10.60697,5.22032>

    /* stem 0.8.10.3*/ 
    /*0*/ <0.07147,10.09594,5.35965>,
    /*1*/ <0.06788,10.0931,5.36445>,<0.06981,10.10194,5.35738>,<0.07671,10.09277,5.35713>,
            
    /*2*/ <0.44394,10.36409,5.79696>

    /* stem 0.8.10.4*/ 
    /*0*/ <0.13931,10.50496,5.63311>,
    /*1*/ <0.13851,10.50788,5.62853>,<0.14364,10.50601,5.63631>,<0.13577,10.50099,5.63448>,
            
    /*2*/ <-0.13934,10.84572,5.8988>

    /* stem 0.8.10.5*/ 
    /*0*/ <0.16884,10.60986,5.69911>,
    /*1*/ <0.17258,10.60722,5.70156>,<0.16507,10.61217,5.70184>,<0.16886,10.61019,5.69392>,
            
    /*2*/ <0.43527,11.01249,5.72609>

    /* stem 0.8.10.6*/ 
    /*0*/ <0.24205,11.03742,5.90972>,
    /*1*/ <0.24111,11.03749,5.90975>,<0.24257,11.03809,5.9093>,<0.24247,11.03668,5.91013>,
            
    /*2*/ <0.26467,11.22197,6.22627>

    /* stem 0.9*/ 
    /*0*/ <-0.03047,7.68281,-0.16478>,
    /*1*/ <0.05606,7.67606,-0.23691>,<0.00454,7.78774,-0.18716>,<-0.09536,7.75441,-0.10647>,
            <-0.10559,7.62213,-0.10637>,<-0.012,7.5737,-0.18698>,
    /*2*/ <-0.37682,7.70911,-0.74253>,<-0.42345,7.81018,-0.6975>,<-0.51387,7.78001,-0.62448>,
            <-0.52312,7.6603,-0.62439>,<-0.43842,7.61648,-0.69734>,
    /*3*/ <-0.82511,7.7945,-1.23331>,<-0.8611,7.88414,-1.18621>,<-0.94123,7.85697,-1.11996>,
            <-0.95478,7.75053,-1.12612>,<-0.88301,7.71193,-1.19618>,
    /*4*/ <-1.2975,7.87898,-1.70212>,<-1.32771,7.95776,-1.65876>,<-1.3954,7.93313,-1.59703>,
            <-1.40702,7.83913,-1.60224>,<-1.34652,7.80566,-1.66719>,
    /*5*/ <-1.7642,8.02019,-2.15781>,<-1.78603,8.08743,-2.11575>,<-1.84561,8.06627,-2.06313>,
            <-1.8606,7.98596,-2.07266>,<-1.81029,7.95747,-2.13118>,
    /*6*/ <-2.28012,8.17151,-2.56388>,<-2.29517,8.22732,-2.52502>,<-2.34074,8.20781,-2.47608>,
            <-2.35385,8.13995,-2.4847>,<-2.31638,8.11751,-2.53896>,
    /*7*/ <-2.78185,8.2486,-2.99184>,<-2.79899,8.29543,-2.96413>,<-2.83659,8.27955,-2.92427>,
            <-2.84269,8.22291,-2.92734>,<-2.80886,8.20378,-2.96911>,
    /*8*/ <-3.27385,8.37572,-3.42224>,<-3.28539,8.41183,-3.39904>,<-3.31577,8.3997,-3.36895>,
            <-3.323,8.35609,-3.37356>,<-3.2971,8.34127,-3.40649>,
    /*9*/ <-3.73362,8.52422,-3.87798>,<-3.742,8.55015,-3.86151>,<-3.76529,8.54193,-3.84141>,
            <-3.7713,8.51092,-3.84545>,<-3.75172,8.49998,-3.86805>,
    /*10*/ <-4.16776,8.71685,-4.34411>,<-4.17236,8.73235,-4.33368>,<-4.18713,8.72767,-4.32228>,
            <-4.19166,8.70928,-4.32566>,<-4.17969,8.70259,-4.33915>,
    /*11*/ <-4.59541,8.93171,-4.80781>,<-4.59689,8.937,-4.80409>,<-4.60204,8.93541,-4.80022>,
            <-4.60375,8.92914,-4.80155>,<-4.59965,8.92685,-4.80624>,
    /*12*/ <-4.59955,8.93202,-4.80398>

    /* stem 0.9c0*/ 
    /*0*/ <-1.35483,7.88293,-1.64547>,
    /*1*/ <-1.32649,7.87934,-1.72094>,<-1.34094,7.95837,-1.6705>,<-1.37458,7.93315,-1.58547>,
            <-1.38093,7.83852,-1.58335>,<-1.3512,7.80527,-1.66707>,
    /*2*/ <-1.95258,7.91625,-1.9463>,<-1.96511,7.98478,-1.90257>,<-1.99428,7.9629,-1.82884>,
            <-1.99978,7.88085,-1.827>,<-1.97401,7.85202,-1.8996>,
    /*3*/ <-2.57824,7.98048,-2.16807>,<-2.58645,8.03832,-2.13013>,<-2.61156,8.01982,-2.06785>,
            <-2.61887,7.95055,-2.0673>,<-2.59827,7.92624,-2.12924>,
    /*4*/ <-3.2096,8.08381,-2.36352>,<-3.21254,8.13064,-2.33108>,<-3.23189,8.11529,-2.27966>,
            <-3.24091,8.05896,-2.28031>,<-3.22713,8.0395,-2.33214>,
    /*5*/ <-3.79471,8.2664,-2.61322>,<-3.79501,8.30247,-2.58725>,<-3.81534,8.29182,-2.54918>,
            <-3.82759,8.24916,-2.55163>,<-3.81484,8.23345,-2.5912>,
    /*6*/ <-4.35427,8.50572,-2.88144>,<-4.35304,8.53104,-2.86217>,<-4.36929,8.52406,-2.8357>,
            <-4.38057,8.49442,-2.83861>,<-4.37129,8.48309,-2.86688>,
    /*7*/ <-4.95373,8.70953,-3.09727>,<-4.95295,8.72479,-3.08558>,<-4.96099,8.71986,-3.06882>,
            <-4.96674,8.70154,-3.07014>,<-4.96225,8.69516,-3.08773>,
    /*8*/ <-5.54663,8.93641,-3.30089>,<-5.54613,8.94159,-3.29678>,<-5.54888,8.93988,-3.29099>,
            <-5.55108,8.93365,-3.29153>,<-5.54969,8.9315,-3.29765>,
    /*9*/ <-5.54848,8.93661,-3.29557>

    /* stem 0.9c0c0*/ 
    /*0*/ <-4.36569,8.50767,-2.85696>,
    /*1*/ <-4.36661,8.50487,-2.88389>,<-4.35369,8.52928,-2.86804>,<-4.35736,8.52382,-2.83688>,
            <-4.37254,8.49604,-2.83348>,<-4.37826,8.48432,-2.86253>,
    /*2*/ <-4.95155,8.82421,-2.8863>,<-4.94374,8.83895,-2.87673>,<-4.94596,8.83566,-2.8579>,
            <-4.95513,8.81887,-2.85585>,<-4.95858,8.8118,-2.8734>,
    /*3*/ <-5.54569,9.12302,-2.91595>,<-5.54329,9.12826,-2.91266>,<-5.54424,9.12723,-2.90618>,
            <-5.54723,9.12135,-2.90546>,<-5.54813,9.11875,-2.91149>,
    /*4*/ <-5.54571,9.12372,-2.91035>

    /* stem 0.9c0c0.0*/ 
    /*0*/ <-5.2461,8.97368,-2.89004>,
    /*1*/ <-5.24435,8.97574,-2.90075>,<-5.24885,8.98192,-2.88321>,<-5.24511,8.96339,-2.88616>,
            
    /*2*/ <-5.4261,8.94453,-2.93537>,<-5.43015,8.9501,-2.91959>,<-5.42679,8.93342,-2.92224>,
            
    /*3*/ <-5.60802,8.94738,-2.97808>,<-5.61134,8.95224,-2.96395>,<-5.61086,8.93724,-2.96697>,
            
    /*4*/ <-5.79351,8.97814,-2.9933>,<-5.79389,8.98247,-2.98063>,<-5.79584,8.9695,-2.98334>,
            
    /*5*/ <-5.95396,9.06198,-3.03598>,<-5.95498,9.06566,-3.02515>,<-5.95943,9.05554,-3.02821>,
            
    /*6*/ <-6.08481,9.18032,-3.09653>,<-6.08609,9.18354,-3.08761>,<-6.09126,9.17616,-3.09082>,
            
    /*7*/ <-6.20425,9.3184,-3.1408>,<-6.2047,9.32042,-3.13344>,<-6.20959,9.31528,-3.1363>,
            
    /*8*/ <-6.30633,9.4676,-3.18994>,<-6.30673,9.46917,-3.18443>,<-6.31069,9.46571,-3.18672>,
            
    /*9*/ <-6.42359,9.60766,-3.23374>,<-6.42381,9.60866,-3.23006>,<-6.42629,9.60613,-3.2315>,
            
    /*10*/ <-6.50128,9.77681,-3.25728>,<-6.50125,9.77709,-3.25539>,<-6.50277,9.77628,-3.25621>,
            
    /*11*/ <-6.57681,9.94709,-3.27977>

    /* stem 0.9c0c0.0.0*/ 
    /*0*/ <-5.3431,8.95712,-2.90911>,
    /*1*/ <-5.34426,8.95938,-2.90515>,<-5.34544,8.95325,-2.91038>,<-5.3396,8.95874,-2.9118>,
            
    /*2*/ <-5.8166,9.36411,-3.28048>

    /* stem 0.9c0c0.0.1*/ 
    /*0*/ <-5.73314,8.96637,-2.98041>,
    /*1*/ <-5.73365,8.96256,-2.98193>,<-5.73544,8.9695,-2.98185>,<-5.73034,8.96706,-2.97744>,
            
    /*2*/ <-6.16928,8.84885,-2.54066>

    /* stem 0.9c0c0.0.2*/ 
    /*0*/ <-5.90666,9.03526,-3.01632>,
    /*1*/ <-5.90473,9.03848,-3.01723>,<-5.91002,9.03549,-3.01441>,<-5.90524,9.0318,-3.01731>,
            
    /*2*/ <-6.19338,9.06268,-3.52455>

    /* stem 0.9c0c0.0.3*/ 
    /*0*/ <-6.02894,9.12705,-3.06411>,
    /*1*/ <-6.03121,9.12589,-3.06151>,<-6.03002,9.12709,-3.06757>,<-6.0256,9.12816,-3.06323>,
            
    /*2*/ <-6.21443,9.63597,-3.00025>

    /* stem 0.9c0c0.0.4*/ 
    /*0*/ <-6.25233,9.38583,-3.15961>,
    /*1*/ <-6.25166,9.38528,-3.16261>,<-6.25205,9.38871,-3.15846>,<-6.25328,9.3835,-3.15777>,
            
    /*2*/ <-6.68926,9.4735,-3.27329>

    /* stem 0.9c0c0.0.5*/ 
    /*0*/ <-6.37813,9.55175,-3.21396>,
    /*1*/ <-6.37722,9.55316,-3.21191>,<-6.38073,9.55166,-3.21445>,<-6.37643,9.55044,-3.21551>,
            
    /*2*/ <-6.34407,9.87984,-3.45443>

    /* stem 0.9c0c0.0.6*/ 
    /*0*/ <-6.54345,9.87136,-3.26934>,
    /*1*/ <-6.54388,9.87116,-3.26947>,<-6.5433,9.87178,-3.26955>,<-6.54318,9.87115,-3.26899>,
            
    /*2*/ <-6.69589,10.04281,-3.04592>

    /* stem 0.9c0.0*/ 
    /*0*/ <-1.66526,7.9011,-1.76289>,
    /*1*/ <-1.65736,7.96186,-1.77438>,<-1.70865,7.88247,-1.72219>,<-1.62978,7.85898,-1.79209>,
            
    /*2*/ <-1.8894,7.93766,-2.02803>,<-1.93556,7.86621,-1.98106>,<-1.86458,7.84507,-2.04397>,
            
    /*3*/ <-2.13705,7.96879,-2.25432>,<-2.18214,7.90624,-2.21539>,<-2.12683,7.88657,-2.27875>,
            
    /*4*/ <-2.37408,8.09603,-2.44703>,<-2.42366,8.04517,-2.42118>,<-2.38208,8.02971,-2.48237>,
            
    /*5*/ <-2.58043,8.32555,-2.56403>,<-2.63144,8.28938,-2.54709>,<-2.60514,8.28276,-2.60593>,
            
    /*6*/ <-2.7788,8.593,-2.6309>,<-2.82277,8.56488,-2.6171>,<-2.80563,8.56477,-2.6683>,
            
    /*7*/ <-2.91095,8.89729,-2.69525>,<-2.95054,8.88272,-2.68598>,<-2.9357,8.88063,-2.72648>,
            
    /*8*/ <-2.98967,9.22637,-2.72586>,<-3.02079,9.22001,-2.71951>,<-3.01012,9.21971,-2.75009>,
            
    /*9*/ <-3.08764,9.55414,-2.77721>,<-3.10818,9.54903,-2.77289>,<-3.10084,9.54804,-2.79318>,
            
    /*10*/ <-3.24841,9.8591,-2.81453>,<-3.25791,9.85457,-2.81211>,<-3.25462,9.85505,-2.82238>,
            
    /*11*/ <-3.42812,10.15337,-2.81575>

    /* stem 0.9c0.0.0*/ 
    /*0*/ <-1.83352,7.88791,-1.94828>,
    /*1*/ <-1.84839,7.87199,-1.93365>,<-1.83106,7.88357,-1.97405>,<-1.8211,7.90819,-1.93714>,
            
    /*2*/ <-2.88056,8.65508,-2.17755>

    /* stem 0.9c0.0.1*/ 
    /*0*/ <-1.98974,7.89686,-2.10339>,
    /*1*/ <-1.97276,7.89544,-2.12209>,<-2.0065,7.9158,-2.10294>,<-1.98995,7.87934,-2.08513>,
            
    /*2*/ <-2.79669,7.19872,-2.78285>

    /* stem 0.9c0.0.2*/ 
    /*0*/ <-2.32447,8.0186,-2.39374>,
    /*1*/ <-2.33045,8.03314,-2.37657>,<-2.34097,8.00789,-2.4062>,<-2.302,8.01475,-2.39845>,
            
    /*2*/ <-2.3306,8.89755,-3.14063>

    /* stem 0.9c0.0.3*/ 
    /*0*/ <-2.46387,8.1375,-2.4908>,
    /*1*/ <-2.47494,8.12193,-2.50242>,<-2.45935,8.1573,-2.50013>,<-2.45732,8.13326,-2.46985>,
            
    /*2*/ <-3.42009,8.53458,-2.11144>

    /* stem 0.9c0.0.4*/ 
    /*0*/ <-2.65165,8.3635,-2.58787>,
    /*1*/ <-2.63443,8.37537,-2.58971>,<-2.66807,8.37046,-2.57681>,<-2.65244,8.34466,-2.59711>,
            
    /*2*/ <-3.04,8.79566,-3.43613>

    /* stem 0.9c0.0.5*/ 
    /*0*/ <-2.75234,8.50424,-2.62187>,
    /*1*/ <-2.76555,8.49819,-2.60782>,<-2.75897,8.51114,-2.63967>,<-2.7325,8.5034,-2.61811>,
            
    /*2*/ <-2.78282,9.41921,-2.25611>

    /* stem 0.9c0.0.6*/ 
    /*0*/ <-2.85225,8.69411,-2.66323>,
    /*1*/ <-2.84861,8.69179,-2.68198>,<-2.84928,8.71119,-2.65489>,<-2.85885,8.67934,-2.65282>,
            
    /*2*/ <-3.7284,8.94441,-2.86409>

    /* stem 0.9c0.0.7*/ 
    /*0*/ <-2.9616,9.01833,-2.71404>,
    /*1*/ <-2.95289,9.02158,-2.699>,<-2.97815,9.02421,-2.71613>,<-2.95376,9.00921,-2.727>,
            
    /*2*/ <-2.66284,9.74242,-3.04322>

    /* stem 0.9c0.0.8*/ 
    /*0*/ <-3.05642,9.39889,-2.75836>,
    /*1*/ <-3.07026,9.3943,-2.76314>,<-3.04867,9.40946,-2.76634>,<-3.05034,9.39293,-2.7456>,
            
    /*2*/ <-3.37909,9.94505,-2.34919>

    /* stem 0.9c0.0.9*/ 
    /*0*/ <-3.17567,9.70215,-2.79858>,
    /*1*/ <-3.16781,9.70571,-2.80223>,<-3.18026,9.70682,-2.79188>,<-3.17895,9.69391,-2.80163>,
            
    /*2*/ <-3.5391,10.02156,-3.2702>

    /* stem 0.9c0.0.10*/ 
    /*0*/ <-3.33318,9.99168,-2.81607>,
    /*1*/ <-3.33449,9.9909,-2.81304>,<-3.33509,9.99325,-2.81839>,<-3.32996,9.99088,-2.81678>,
            
    /*2*/ <-3.15554,10.52016,-2.60456>

    /* stem 0.9c0.1*/ 
    /*0*/ <-2.22644,7.94492,-1.97378>,
    /*1*/ <-2.24584,7.9095,-1.93147>,<-2.23114,7.92885,-2.02981>,<-2.20235,7.9964,-1.96004>,
            
    /*2*/ <-2.53262,8.05235,-1.95147>,<-2.51939,8.06976,-2.03997>,<-2.49348,8.13056,-1.97718>,
            
    /*3*/ <-2.79163,8.25366,-1.98173>,<-2.77432,8.26613,-2.0599>,<-2.74291,8.31476,-2.00319>,
            
    /*4*/ <-3.00125,8.49987,-1.97147>,<-2.99007,8.51368,-2.04012>,<-2.95041,8.54542,-1.99065>,
            
    /*5*/ <-3.15728,8.78828,-1.97135>,<-3.14475,8.7961,-2.0303>,<-3.10627,8.81678,-1.98805>,
            
    /*6*/ <-3.29026,9.08264,-1.97565>,<-3.2791,9.08783,-2.02478>,<-3.24612,9.10323,-1.98956>,
            
    /*7*/ <-3.41447,9.37947,-1.98503>,<-3.40517,9.38281,-2.02432>,<-3.37864,9.3948,-1.99613>,
            
    /*8*/ <-3.55249,9.66831,-1.99683>,<-3.54558,9.67094,-2.02631>,<-3.5262,9.68106,-2.0052>,
            
    /*9*/ <-3.65614,9.97342,-2.01041>,<-3.65125,9.97454,-2.03004>,<-3.6377,9.97976,-2.01591>,
            
    /*10*/ <-3.74249,10.28247,-2.03317>,<-3.73991,10.28264,-2.04296>,<-3.73308,10.28507,-2.03588>,
            
    /*11*/ <-3.78803,10.59756,-1.9942>

    /* stem 0.9c0.1.0*/ 
    /*0*/ <-2.37282,8.01554,-1.98177>,
    /*1*/ <-2.37104,8.01642,-2.00662>,<-2.37806,8.03625,-1.9689>,<-2.36936,7.99396,-1.96977>,
            
    /*2*/ <-3.58879,7.76714,-2.07764>

    /* stem 0.9c0.1.1*/ 
    /*0*/ <-2.62401,8.16719,-2.0004>,
    /*1*/ <-2.61692,8.17902,-1.98119>,<-2.64661,8.16055,-2.00253>,<-2.6085,8.16202,-2.0175>,
            
    /*2*/ <-2.87268,9.18297,-2.53359>

    /* stem 0.9c0.1.2*/ 
    /*0*/ <-2.92466,8.45565,-2.00451>,
    /*1*/ <-2.94074,8.44192,-2.00989>,<-2.92154,8.47388,-2.01609>,<-2.9117,8.45116,-1.98754>,
            
    /*2*/ <-3.59399,8.98421,-1.35313>

    /* stem 0.9c0.1.3*/ 
    /*0*/ <-3.07912,8.69754,-1.9981>,
    /*1*/ <-3.06302,8.7066,-2.00709>,<-3.08755,8.70587,-1.98131>,<-3.08681,8.68015,-2.0059>,
            
    /*2*/ <-3.70225,9.23205,-2.57594>

    /* stem 0.9c0.1.4*/ 
    /*0*/ <-3.22162,8.98364,-1.99663>,
    /*1*/ <-3.22869,8.98035,-1.97916>,<-3.23177,8.99374,-2.00931>,<-3.2044,8.97684,-2.00141>,
            
    /*2*/ <-2.82763,9.7649,-1.68992>

    /* stem 0.9c0.1.5*/ 
    /*0*/ <-3.31078,9.18113,-1.99824>,
    /*1*/ <-3.31524,9.17889,-2.0157>,<-3.3013,9.19573,-1.99309>,<-3.3158,9.16876,-1.98593>,
            
    /*2*/ <-4.05711,9.61796,-1.86376>

    /* stem 0.9c0.1.6*/ 
    /*0*/ <-3.50212,9.59379,-2.00734>,
    /*1*/ <-3.49024,9.59989,-1.99833>,<-3.51745,9.59736,-2.00394>,<-3.49866,9.58412,-2.01974>,
            
    /*2*/ <-3.46314,10.20229,-2.47088>

    /* stem 0.9c0.1.7*/ 
    /*0*/ <-3.58651,9.80095,-2.01338>,
    /*1*/ <-3.60066,9.79599,-2.01187>,<-3.58294,9.81024,-2.02471>,<-3.57591,9.79661,-2.00357>,
            
    /*2*/ <-3.7388,10.3615,-1.60139>

    /* stem 0.9c0.1.8*/ 
    /*0*/ <-3.6764,10.07157,-2.02456>,
    /*1*/ <-3.66966,10.07312,-2.0316>,<-3.67719,10.07787,-2.01699>,<-3.68237,10.06371,-2.02508>,
            
    /*2*/ <-4.10406,10.41841,-2.35784>

    /* stem 0.9c0.1.9*/ 
    /*0*/ <-3.76081,10.42495,-2.0179>,
    /*1*/ <-3.76097,10.42449,-2.01473>,<-3.76321,10.42645,-2.01943>,<-3.75826,10.42391,-2.01955>,
            
    /*2*/ <-3.50776,10.91281,-1.93464>

    /* stem 0.9c0.2*/ 
    /*0*/ <-2.87841,8.02893,-2.20408>,
    /*1*/ <-2.86194,8.02689,-2.25544>,<-2.89586,8.07553,-2.18317>,<-2.87745,7.98437,-2.17364>,
            
    /*2*/ <-3.13712,7.96294,-2.33551>,<-3.16764,8.00671,-2.27047>,<-3.15107,7.92467,-2.26189>,
            
    /*3*/ <-3.41151,8.03737,-2.41343>,<-3.42028,8.076,-2.35>,<-3.43922,8.0037,-2.35267>,
            
    /*4*/ <-3.66923,8.13912,-2.50357>,<-3.67685,8.1724,-2.44775>,<-3.69923,8.1111,-2.45261>,
            
    /*5*/ <-3.89943,8.30197,-2.58592>,<-3.90044,8.32744,-2.53595>,<-3.93046,8.28079,-2.54427>,
            
    /*6*/ <-4.11336,8.5093,-2.61207>,<-4.10541,8.52388,-2.56837>,<-4.13704,8.49043,-2.57646>,
            
    /*7*/ <-4.26055,8.76401,-2.61574>,<-4.25051,8.771,-2.5804>,<-4.28225,8.75257,-2.58752>,
            
    /*8*/ <-4.43983,8.99734,-2.61811>,<-4.4329,9.00349,-2.59164>,<-4.45472,8.98667,-2.59688>,
            
    /*9*/ <-4.59431,9.24628,-2.57904>,<-4.58787,9.24787,-2.56156>,<-4.60374,9.23855,-2.56486>,
            
    /*10*/ <-4.72813,9.50476,-2.54186>,<-4.72481,9.50539,-2.53314>,<-4.73309,9.50133,-2.53472>,
            
    /*11*/ <-4.89047,9.74874,-2.54245>

    /* stem 0.9c0.2.0*/ 
    /*0*/ <-3.01002,7.99806,-2.24508>,
    /*1*/ <-3.01833,8.01317,-2.22979>,<-3.01817,7.97651,-2.24557>,<-2.99357,8.0045,-2.25987>,
            
    /*2*/ <-3.8085,8.31706,-2.99428>

    /* stem 0.9c0.2.1*/ 
    /*0*/ <-3.23447,7.98733,-2.31442>,
    /*1*/ <-3.23888,7.96625,-2.31885>,<-3.2427,8.00321,-2.32721>,<-3.22183,7.99253,-2.29719>,
            
    /*2*/ <-4.11358,8.03879,-1.68489>

    /* stem 0.9c0.2.2*/ 
    /*0*/ <-3.50393,8.0707,-2.40187>,
    /*1*/ <-3.49437,8.087,-2.41028>,<-3.51965,8.07357,-2.38873>,<-3.49777,8.05152,-2.40659>,
            
    /*2*/ <-4.15455,8.05269,-3.17617>

    /* stem 0.9c0.2.3*/ 
    /*0*/ <-3.78495,8.21432,-2.50747>,
    /*1*/ <-3.79442,8.20965,-2.49143>,<-3.79385,8.21345,-2.52446>,<-3.76659,8.21985,-2.50652>,
            
    /*2*/ <-4.05663,9.0996,-2.41019>

    /* stem 0.9c0.2.4*/ 
    /*0*/ <-3.99927,8.39083,-2.56832>,
    /*1*/ <-4.00014,8.38734,-2.58587>,<-3.99987,8.40778,-2.56251>,<-3.99778,8.37738,-2.55657>,
            
    /*2*/ <-4.85866,8.34205,-2.51573>

    /* stem 0.9c0.2.5*/ 
    /*0*/ <-4.20916,8.666,-2.59117>,
    /*1*/ <-4.19862,8.67241,-2.58046>,<-4.22501,8.66986,-2.59034>,<-4.20385,8.65572,-2.60271>,
            
    /*2*/ <-4.08781,9.26708,-3.07046>

    /* stem 0.9c0.2.6*/ 
    /*0*/ <-4.39368,8.93188,-2.60011>,
    /*1*/ <-4.40549,8.92286,-2.60031>,<-4.39381,8.94447,-2.60801>,<-4.38174,8.92831,-2.59202>,
            
    /*2*/ <-4.66353,9.27317,-2.05119>

    /* stem 0.9c0.2.7*/ 
    /*0*/ <-4.50911,9.10413,-2.58751>,
    /*1*/ <-4.50059,9.11057,-2.5963>,<-4.5142,9.11092,-2.57658>,<-4.51255,9.0909,-2.58964>,
            
    /*2*/ <-5.01939,9.29422,-2.94319>

    /* stem 0.9c0.2.8*/ 
    /*0*/ <-4.64554,9.342,-2.55647>,
    /*1*/ <-4.64643,9.34049,-2.54788>,<-4.65241,9.34471,-2.56117>,<-4.63777,9.3408,-2.56035>,
            
    /*2*/ <-4.50338,9.89728,-2.44397>

    /* stem 0.9c0.2.9*/ 
    /*0*/ <-4.84015,9.67257,-2.54063>,
    /*1*/ <-4.84083,9.67208,-2.54208>,<-4.83983,9.67419,-2.54035>,<-4.83979,9.67143,-2.53945>,
            
    /*2*/ <-5.28979,9.72905,-2.34995>

    /* stem 0.9c0.3*/ 
    /*0*/ <-3.40547,8.14228,-2.39816>,
    /*1*/ <-3.41101,8.17224,-2.36476>,<-3.43483,8.10825,-2.4031>,<-3.37058,8.14634,-2.42662>,
            
    /*2*/ <-3.56179,8.32357,-2.5316>,<-3.58323,8.26598,-2.56612>,<-3.5254,8.30026,-2.58728>,
            
    /*3*/ <-3.68528,8.51767,-2.65854>,<-3.71217,8.47627,-2.69711>,<-3.65695,8.50178,-2.71211>,
            
    /*4*/ <-3.8113,8.72681,-2.76899>,<-3.83687,8.69369,-2.8044>,<-3.78852,8.71586,-2.81763>,
            
    /*5*/ <-3.9253,8.95119,-2.8622>,<-3.9493,8.9265,-2.89418>,<-3.90687,8.94368,-2.90476>,
            
    /*6*/ <-4.02869,9.18383,-2.95357>,<-4.04931,9.16464,-2.98077>,<-4.01323,9.17745,-2.98897>,
            
    /*7*/ <-4.11449,9.42834,-3.02623>,<-4.13214,9.4159,-3.04891>,<-4.10263,9.42447,-3.05496>,
            
    /*8*/ <-4.207,9.67261,-3.09882>,<-4.22014,9.66298,-3.11575>,<-4.19818,9.66991,-3.12043>,
            
    /*9*/ <-4.32327,9.90693,-3.17083>,<-4.33166,9.89964,-3.18187>,<-4.31759,9.90555,-3.18536>,
            
    /*10*/ <-4.47116,10.12684,-3.22658>,<-4.4752,10.12288,-3.23199>,<-4.4687,10.12675,-3.23401>,
            
    /*11*/ <-4.63191,10.33226,-3.30176>

    /* stem 0.9c0.3.0*/ 
    /*0*/ <-3.5068,8.24561,-2.50764>,
    /*1*/ <-3.51508,8.22994,-2.51476>,<-3.4986,8.25825,-2.51937>,<-3.50672,8.24863,-2.48878>,
            
    /*2*/ <-4.40893,8.75815,-2.58622>

    /* stem 0.9c0.3.1*/ 
    /*0*/ <-3.59164,8.35157,-2.59639>,
    /*1*/ <-3.57567,8.36066,-2.59802>,<-3.60664,8.36031,-2.59015>,<-3.59261,8.33372,-2.601>,
            
    /*2*/ <-3.83284,8.60706,-3.53406>

    /* stem 0.9c0.3.2*/ 
    /*0*/ <-3.75532,8.61675,-2.74889>,
    /*1*/ <-3.76811,8.61473,-2.73776>,<-3.75871,8.61933,-2.76541>,<-3.73914,8.61618,-2.74348>,
            
    /*2*/ <-3.77204,9.52303,-2.60366>

    /* stem 0.9c0.3.3*/ 
    /*0*/ <-3.85443,8.79596,-2.83007>,
    /*1*/ <-3.85047,8.79197,-2.84524>,<-3.85047,8.81052,-2.82424>,<-3.86235,8.78539,-2.82073>,
            
    /*2*/ <-4.6088,9.11326,-3.11038>

    /* stem 0.9c0.3.4*/ 
    /*0*/ <-3.98112,9.06321,-2.93273>,
    /*1*/ <-3.97536,9.07016,-2.92086>,<-3.99568,9.06441,-2.93572>,<-3.97234,9.05506,-2.94159>,
            
    /*2*/ <-3.83715,9.70087,-3.37615>

    /* stem 0.9c0.3.5*/ 
    /*0*/ <-4.17706,9.58476,-3.08838>,
    /*1*/ <-4.18786,9.57966,-3.09215>,<-4.17066,9.59227,-3.09608>,<-4.17267,9.58234,-3.0769>,
            
    /*2*/ <-4.50102,10.09937,-2.85609>

    /* stem 0.9c0.3.6*/ 
    /*0*/ <-4.24145,9.73569,-3.13098>,
    /*1*/ <-4.2312,9.73943,-3.13551>,<-4.24732,9.74246,-3.12327>,<-4.24584,9.72519,-3.13415>,
            
    /*2*/ <-4.5415,10.0004,-3.5917>

    /* stem 0.9c0.3.7*/ 
    /*0*/ <-4.42381,10.05362,-3.21414>,
    /*1*/ <-4.42648,10.05309,-3.20881>,<-4.42711,10.0546,-3.21905>,<-4.41786,10.05317,-3.21458>,
            
    /*2*/ <-4.37991,10.56639,-3.14122>

    /* stem 0.9c0.3.8*/ 
    /*0*/ <-4.52289,10.19157,-3.25352>,
    /*1*/ <-4.52308,10.19044,-3.25637>,<-4.52219,10.19453,-3.25308>,<-4.52341,10.18974,-3.2511>,
            
    /*2*/ <-4.98716,10.30412,-3.26668>

    /* stem 0.9c0.4*/ 
    /*0*/ <-3.9163,8.31455,-2.63197>,
    /*1*/ <-3.92615,8.28134,-2.64079>,<-3.90684,8.33776,-2.65746>,<-3.9159,8.32455,-2.59765>,
            
    /*2*/ <-4.16071,8.35962,-2.65906>,<-4.14333,8.4104,-2.67406>,<-4.15149,8.39852,-2.62023>,
            
    /*3*/ <-4.37576,8.49585,-2.68007>,<-4.3496,8.53608,-2.69232>,<-4.3601,8.52689,-2.64479>,
            
    /*4*/ <-4.57958,8.64049,-2.68015>,<-4.55575,8.67495,-2.69124>,<-4.56236,8.66573,-2.64941>,
            
    /*5*/ <-4.75683,8.81938,-2.65965>,<-4.73226,8.84542,-2.6696>,<-4.73676,8.83687,-2.63373>,
            
    /*6*/ <-4.91686,9.01019,-2.64392>,<-4.89464,9.03002,-2.65238>,<-4.89919,9.02374,-2.62241>,
            
    /*7*/ <-5.06553,9.20534,-2.59984>,<-5.04761,9.22095,-2.60681>,<-5.04954,9.21412,-2.58309>,
            
    /*8*/ <-5.17428,9.42318,-2.54009>,<-5.15933,9.4325,-2.54597>,<-5.1605,9.42706,-2.52825>,
            
    /*9*/ <-5.27322,9.63373,-2.45298>,<-5.26338,9.64015,-2.45688>,<-5.26352,9.63536,-2.44546>,
            
    /*10*/ <-5.37031,9.85035,-2.38123>,<-5.36529,9.85336,-2.38325>,<-5.36553,9.85131,-2.37741>,
            
    /*11*/ <-5.4601,10.0812,-2.36948>

    /* stem 0.9c0.4.0*/ 
    /*0*/ <-4.06953,8.36332,-2.64443>,
    /*1*/ <-4.06492,8.37615,-2.65095>,<-4.08064,8.36362,-2.63417>,<-4.06304,8.35018,-2.64815>,
            
    /*2*/ <-4.71253,8.24213,-3.3373>

    /* stem 0.9c0.4.1*/ 
    /*0*/ <-4.22115,8.43246,-2.65814>,
    /*1*/ <-4.22542,8.4277,-2.64508>,<-4.23084,8.43387,-2.66889>,<-4.20719,8.4358,-2.66046>,
            
    /*2*/ <-4.38377,9.29204,-2.39842>

    /* stem 0.9c0.4.2*/ 
    /*0*/ <-4.61301,8.70683,-2.66844>,
    /*1*/ <-4.61613,8.70504,-2.68081>,<-4.61295,8.7187,-2.66347>,<-4.60996,8.69673,-2.66105>,
            
    /*2*/ <-5.37916,8.62504,-2.46356>

    /* stem 0.9c0.4.3*/ 
    /*0*/ <-4.81109,8.91408,-2.64801>,
    /*1*/ <-4.80339,8.92019,-2.64137>,<-4.82258,8.91379,-2.64504>,<-4.8073,8.90824,-2.65763>,
            
    /*2*/ <-4.93083,9.50635,-3.05447>

    /* stem 0.9c0.4.4*/ 
    /*0*/ <-4.99906,9.14311,-2.61232>,
    /*1*/ <-5.00738,9.13631,-2.61109>,<-5.00062,9.15279,-2.61686>,<-4.98918,9.14022,-2.60901>,
            
    /*2*/ <-5.12214,9.40043,-2.02105>

    /* stem 0.9c0.4.5*/ 
    /*0*/ <-5.10532,9.3125,-2.56953>,
    /*1*/ <-5.10027,9.31713,-2.57693>,<-5.10487,9.31607,-2.56012>,<-5.11083,9.3043,-2.57155>,
            
    /*2*/ <-5.58817,9.66377,-2.67966>

    /* stem 0.9c0.4.6*/ 
    /*0*/ <-5.30771,9.72439,-2.4227>,
    /*1*/ <-5.30703,9.7229,-2.41725>,<-5.31239,9.72718,-2.42432>,<-5.30371,9.72308,-2.42652>,
            
    /*2*/ <-5.08312,10.15238,-2.33422>

    /* stem 0.9c0.4.7*/ 
    /*0*/ <-5.42593,9.99693,-2.37357>,
    /*1*/ <-5.42674,9.99665,-2.37457>,<-5.42531,9.99808,-2.37353>,<-5.42576,9.99605,-2.37261>,
            
    /*2*/ <-5.74656,10.16483,-2.16339>

    /* stem 0.9c0.5*/ 
    /*0*/ <-4.16634,8.422,-2.75715>,
    /*1*/ <-4.15033,8.44582,-2.76868>,<-4.18759,8.42683,-2.73521>,<-4.1611,8.39336,-2.76757>,
            
    /*2*/ <-4.31682,8.47374,-2.93387>,<-4.35036,8.45664,-2.90374>,<-4.32651,8.42652,-2.93286>,
            
    /*3*/ <-4.47078,8.56282,-3.08063>,<-4.50298,8.54864,-3.05617>,<-4.48735,8.52389,-3.08746>,
            
    /*4*/ <-4.61846,8.71795,-3.17014>,<-4.64582,8.70543,-3.14777>,<-4.64101,8.69033,-3.18175>,
            
    /*5*/ <-4.71335,8.91878,-3.23065>,<-4.73945,8.91208,-3.21313>,<-4.73814,8.90331,-3.24403>,
            
    /*6*/ <-4.79657,9.12593,-3.30407>,<-4.81912,9.12216,-3.29011>,<-4.81753,9.11379,-3.31551>,
            
    /*7*/ <-4.85294,9.34602,-3.3613>,<-4.87139,9.34435,-3.35053>,<-4.87059,9.33914,-3.3713>,
            
    /*8*/ <-4.90683,9.5645,-3.43262>,<-4.92081,9.56382,-3.42473>,<-4.91999,9.55902,-3.44004>,
            
    /*9*/ <-4.96432,9.78979,-3.47466>,<-4.97346,9.7886,-3.4692>,<-4.97323,9.78669,-3.47974>,
            
    /*10*/ <-5.00379,10.01735,-3.52174>,<-5.00844,10.01715,-3.51909>,<-5.0083,10.01609,-3.52434>,
            
    /*11*/ <-5.02839,10.2503,-3.55032>

    /* stem 0.9c0.5.0*/ 
    /*0*/ <-4.23307,8.43426,-2.82447>,
    /*1*/ <-4.24254,8.43177,-2.81553>,<-4.23266,8.42739,-2.8358>,<-4.224,8.44364,-2.82207>,
            
    /*2*/ <-4.77628,9.06207,-3.22489>

    /* stem 0.9c0.5.1*/ 
    /*0*/ <-4.39957,8.49301,-2.98984>,
    /*1*/ <-4.39365,8.48746,-2.99935>,<-4.40218,8.50523,-2.99038>,<-4.40288,8.48636,-2.97979>,
            
    /*2*/ <-5.15931,8.31425,-3.35835>

    /* stem 0.9c0.5.2*/ 
    /*0*/ <-4.67536,8.79204,-3.19308>,
    /*1*/ <-4.67071,8.79684,-3.18431>,<-4.68591,8.7941,-3.19554>,<-4.66947,8.78517,-3.19938>,
            
    /*2*/ <-4.46181,9.36941,-3.62262>

    /* stem 0.9c0.5.3*/ 
    /*0*/ <-4.75207,8.96775,-3.24919>,
    /*1*/ <-4.76101,8.96329,-3.25203>,<-4.7475,8.97467,-3.25545>,<-4.74769,8.96528,-3.2401>,
            
    /*2*/ <-5.10932,9.48587,-2.93668>

    /* stem 0.9c0.5.4*/ 
    /*0*/ <-4.83742,9.22939,-3.33149>,
    /*1*/ <-4.82864,9.23065,-3.33481>,<-4.84188,9.23649,-3.32709>,<-4.84173,9.22104,-3.33256>,
            
    /*2*/ <-5.07511,9.4234,-3.88579>

    /* stem 0.9c0.5.5*/ 
    /*0*/ <-4.8826,9.41909,-3.38577>,
    /*1*/ <-4.88728,9.42039,-3.37842>,<-4.88579,9.4217,-3.39355>,<-4.87472,9.41517,-3.38533>,
            
    /*2*/ <-4.62731,9.94069,-3.31557>

    /* stem 0.9c0.5.6*/ 
    /*0*/ <-4.98429,9.87569,-3.49257>,
    /*1*/ <-4.98502,9.87457,-3.49739>,<-4.98182,9.87985,-3.49131>,<-4.98603,9.87264,-3.48901>,
            
    /*2*/ <-5.38872,10.11418,-3.48628>

    /* stem 0.9c0.5.7*/ 
    /*0*/ <-5.01573,10.11311,-3.53352>,
    /*1*/ <-5.01436,10.11338,-3.53235>,<-5.01717,10.11421,-3.53349>,<-5.01565,10.11174,-3.53471>,
            
    /*2*/ <-4.83258,10.36093,-3.80573>

    /* stem 0.9c0.6*/ 
    /*0*/ <-5.1245,8.77366,-3.14181>,
    /*1*/ <-5.13015,8.76979,-3.13033>,<-5.12796,8.76775,-3.15328>,<-5.11539,8.78343,-3.14181>,
            
    /*2*/ <-5.26977,8.90087,-3.15646>,<-5.2678,8.89903,-3.17711>,<-5.25649,8.91314,-3.1668>,
            
    /*3*/ <-5.38099,9.05849,-3.18045>,<-5.37933,9.057,-3.19882>,<-5.36712,9.06706,-3.18922>,
            
    /*4*/ <-5.48437,9.21881,-3.16289>,<-5.48501,9.22026,-3.17901>,<-5.47293,9.22717,-3.17073>,
            
    /*5*/ <-5.57708,9.38939,-3.15847>,<-5.57711,9.38983,-3.17234>,<-5.56655,9.39538,-3.16524>,
            
    /*6*/ <-5.62883,9.57687,-3.1653>,<-5.62856,9.57659,-3.17686>,<-5.61905,9.57942,-3.17092>,
            
    /*7*/ <-5.71368,9.74924,-3.15854>,<-5.71374,9.74963,-3.16778>,<-5.70653,9.75299,-3.16305>,
            
    /*8*/ <-5.79465,9.9248,-3.15353>,<-5.79466,9.92503,-3.16047>,<-5.78921,9.92745,-3.15692>,
            
    /*9*/ <-5.89462,10.09007,-3.1543>,<-5.89456,10.09012,-3.15892>,<-5.89117,10.09218,-3.15655>,
            
    /*10*/ <-5.95704,10.27183,-3.17982>,<-5.95687,10.27158,-3.18211>,<-5.95507,10.27237,-3.1809>,
            
    /*11*/ <-6.01612,10.45414,-3.20503>

    /* stem 0.9c0.6.0*/ 
    /*0*/ <-5.21933,8.86206,-3.15871>,
    /*1*/ <-5.21947,8.86085,-3.16422>,<-5.2196,8.86743,-3.15699>,<-5.21891,8.8579,-3.15492>,
            
    /*2*/ <-5.95899,8.81506,-3.12903>

    /* stem 0.9c0.6.1*/ 
    /*0*/ <-5.43858,9.15726,-3.17836>,
    /*1*/ <-5.43522,9.15907,-3.17508>,<-5.44347,9.15723,-3.17719>,<-5.43704,9.15548,-3.18281>,
            
    /*2*/ <-5.50418,9.75188,-3.43918>

    /* stem 0.9c0.6.2*/ 
    /*0*/ <-5.51849,9.29094,-3.16863>,
    /*1*/ <-5.52267,9.28865,-3.16869>,<-5.51794,9.29498,-3.1711>,<-5.51485,9.28919,-3.1661>,
            
    /*2*/ <-5.70314,9.61477,-2.67934>

    /* stem 0.9c0.6.3*/ 
    /*0*/ <-5.58885,9.44627,-3.16702>,
    /*1*/ <-5.58548,9.44713,-3.16984>,<-5.58992,9.44925,-3.16385>,<-5.59114,9.44244,-3.16736>,
            
    /*2*/ <-5.95605,9.6983,-3.52901>

    /* stem 0.9c0.6.4*/ 
    /*0*/ <-5.77057,9.87791,-3.15865>,
    /*1*/ <-5.77114,9.87752,-3.15504>,<-5.77337,9.87875,-3.16088>,<-5.76719,9.87747,-3.16004>,
            
    /*2*/ <-5.68583,10.32684,-3.09632>

    /* stem 0.9c0.6.5*/ 
    /*0*/ <-5.85197,10.02275,-3.15675>,
    /*1*/ <-5.85331,10.02194,-3.15956>,<-5.85113,10.02581,-3.15618>,<-5.85147,10.0205,-3.15449>,
            
    /*2*/ <-6.23402,10.09781,-2.99622>

    /* stem 0.9c0.6.6*/ 
    /*0*/ <-5.98641,10.36359,-3.19306>,
    /*1*/ <-5.98583,10.36381,-3.19281>,<-5.98698,10.3638,-3.1928>,<-5.98641,10.36316,-3.19357>,
            
    /*2*/ <-5.9928,10.61829,-3.40639>

    /* stem 0.9c1*/ 
    /*0*/ <-2.81379,8.25005,-2.95534>,
    /*1*/ <-2.80468,8.24867,-3.00298>,<-2.8082,8.29569,-2.97087>,<-2.81945,8.27964,-2.91729>,
            <-2.82288,8.22271,-2.91629>,<-2.81375,8.20356,-2.96925>,
    /*2*/ <-3.45996,8.28615,-3.11849>,<-3.4627,8.32278,-3.09347>,<-3.47146,8.31028,-3.05173>,
            <-3.47414,8.26592,-3.05095>,<-3.46703,8.25101,-3.09221>,
    /*3*/ <-4.12473,8.26595,-3.18985>,<-4.12774,8.29219,-3.17206>,<-4.1312,8.28316,-3.14173>,
            <-4.13033,8.25134,-3.14076>,<-4.12633,8.24071,-3.17051>,
    /*4*/ <-4.77999,8.3528,-3.27191>,<-4.77947,8.36854,-3.26085>,<-4.78276,8.36315,-3.24268>,
            <-4.78531,8.34408,-3.2425>,<-4.7836,8.33769,-3.26057>,
    /*5*/ <-5.43711,8.45163,-3.32988>,<-5.4367,8.45703,-3.32604>,<-5.43764,8.45514,-3.31975>,
            <-5.43863,8.44858,-3.31971>,<-5.4383,8.44641,-3.32597>,
    /*6*/ <-5.43768,8.45176,-3.32427>

    /* stem 0.9c1.0*/ 
    /*0*/ <-3.81052,8.27654,-3.12378>,
    /*1*/ <-3.81413,8.29791,-3.0999>,<-3.82568,8.24813,-3.12241>,<-3.79175,8.2836,-3.14902>,
            
    /*2*/ <-4.00196,8.3907,-3.21571>,<-4.01235,8.3459,-3.23596>,<-3.98182,8.37782,-3.25991>,
            
    /*3*/ <-4.19781,8.49738,-3.28683>,<-4.21194,8.45957,-3.30595>,<-4.18763,8.48875,-3.32946>,
            
    /*4*/ <-4.378,8.64059,-3.33229>,<-4.39686,8.61165,-3.35058>,<-4.3731,8.63528,-3.3707>,
            
    /*5*/ <-4.51682,8.8275,-3.36945>,<-4.5385,8.80844,-3.38645>,<-4.51351,8.82386,-3.40259>,
            
    /*6*/ <-4.61266,9.04219,-3.39629>,<-4.63362,9.0313,-3.41116>,<-4.61045,9.04006,-3.42404>,
            
    /*7*/ <-4.72576,9.25189,-3.42551>,<-4.74189,9.24185,-3.43726>,<-4.72394,9.25008,-3.44769>,
            
    /*8*/ <-4.83565,9.46279,-3.45002>,<-4.84792,9.45559,-3.45887>,<-4.83444,9.46171,-3.46669>,
            
    /*9*/ <-4.96629,9.66089,-3.48806>,<-4.97381,9.65498,-3.49383>,<-4.96515,9.65967,-3.4991>,
            
    /*10*/ <-5.09486,9.85898,-3.52722>,<-5.09862,9.85604,-3.53011>,<-5.09427,9.85835,-3.53273>,
            
    /*11*/ <-5.19292,10.07458,-3.55974>

    /* stem 0.9c1.0.0*/ 
    /*0*/ <-3.8843,8.31376,-3.16824>,
    /*1*/ <-3.88852,8.30109,-3.17185>,<-3.88553,8.32426,-3.17717>,<-3.87886,8.31593,-3.15571>,
            
    /*2*/ <-4.73585,8.50098,-2.83082>

    /* stem 0.9c1.0.1*/ 
    /*0*/ <-4.14325,8.45111,-3.28784>,
    /*1*/ <-4.13627,8.46069,-3.2927>,<-4.15328,8.45369,-3.2803>,<-4.1402,8.43896,-3.29051>,
            
    /*2*/ <-4.65513,8.47444,-3.97671>

    /* stem 0.9c1.0.2*/ 
    /*0*/ <-4.47186,8.75047,-3.37343>,
    /*1*/ <-4.47738,8.74817,-3.36381>,<-4.47766,8.75292,-3.38284>,<-4.46054,8.75032,-3.37363>,
            
    /*2*/ <-4.45879,9.47667,-3.19234>

    /* stem 0.9c1.0.3*/ 
    /*0*/ <-4.56815,8.92259,-3.39763>,
    /*1*/ <-4.56902,8.92104,-3.40815>,<-4.56401,8.93169,-3.3939>,<-4.57144,8.91505,-3.39083>,
            
    /*2*/ <-5.20716,9.2096,-3.38769>

    /* stem 0.9c1.0.4*/ 
    /*0*/ <-4.66382,9.12238,-3.42109>,
    /*1*/ <-4.65764,9.12649,-3.41449>,<-4.67344,9.12484,-3.42109>,<-4.66038,9.11581,-3.42769>,
            
    /*2*/ <-4.5408,9.60356,-3.83588>

    /* stem 0.9c1.0.5*/ 
    /*0*/ <-4.79208,9.36792,-3.4491>,
    /*1*/ <-4.80007,9.36379,-3.44942>,<-4.79056,9.37518,-3.45421>,<-4.78561,9.36479,-3.44368>,
            
    /*2*/ <-4.98549,9.70921,-3.02154>

    /* stem 0.9c1.0.6*/ 
    /*0*/ <-5.04404,9.77671,-3.51523>,
    /*1*/ <-5.04082,9.77826,-3.51801>,<-5.04627,9.77958,-3.51252>,<-5.04503,9.77228,-3.51515>,
            
    /*2*/ <-5.36185,9.8421,-3.84662>

    /* stem 0.9c1.0.7*/ 
    /*0*/ <-5.121,9.91385,-3.5377>,
    /*1*/ <-5.1216,9.9139,-3.53539>,<-5.12262,9.91441,-3.53937>,<-5.11878,9.91324,-3.53835>,
            
    /*2*/ <-5.00281,10.32208,-3.51569>

    /* stem 0.9c1.1*/ 
    /*0*/ <-5.06049,8.39507,-3.28481>,
    /*1*/ <-5.06202,8.38352,-3.28678>,<-5.0634,8.40292,-3.29315>,<-5.05604,8.39877,-3.27451>,
            
    /*2*/ <-5.237,8.39571,-3.21504>,<-5.23825,8.41317,-3.22078>,<-5.23163,8.40944,-3.204>,
            
    /*3*/ <-5.40872,8.46258,-3.15987>,<-5.40522,8.47716,-3.16645>,<-5.4014,8.4741,-3.15083>,
            
    /*4*/ <-5.56673,8.55585,-3.10701>,<-5.56192,8.56775,-3.11338>,<-5.55882,8.56522,-3.09963>,
            
    /*5*/ <-5.7048,8.6726,-3.04596>,<-5.69959,8.68198,-3.05193>,<-5.69646,8.67961,-3.0403>,
            
    /*6*/ <-5.8416,8.79766,-3.00512>,<-5.83657,8.80492,-3.01028>,<-5.83481,8.80359,-3.00029>,
            
    /*7*/ <-5.9552,8.9506,-2.99783>,<-5.94975,8.9549,-3.00215>,<-5.94934,8.95482,-2.99398>,
            
    /*8*/ <-6.05821,9.10969,-3.00845>,<-6.05374,9.11241,-3.01167>,<-6.05378,9.11279,-3.00554>,
            
    /*9*/ <-6.14916,9.27589,-3.01929>,<-6.14605,9.27748,-3.02142>,<-6.14608,9.27774,-3.01734>,
            
    /*10*/ <-6.24005,9.43985,-3.04701>,<-6.23846,9.44057,-3.04806>,<-6.23856,9.44086,-3.04604>,
            
    /*11*/ <-6.32204,9.61021,-3.03307>

    /* stem 0.9c1.1.0*/ 
    /*0*/ <-5.15946,8.40131,-3.24438>,
    /*1*/ <-5.16012,8.40572,-3.24668>,<-5.16121,8.40061,-3.23973>,<-5.15705,8.39759,-3.24674>,
            
    /*2*/ <-5.79506,8.16286,-3.51909>

    /* stem 0.9c1.1.1*/ 
    /*0*/ <-5.49291,8.52242,-3.12983>,
    /*1*/ <-5.49236,8.52098,-3.12565>,<-5.49675,8.52164,-3.13196>,<-5.48963,8.52463,-3.13188>,
            
    /*2*/ <-5.72822,9.07675,-2.9082>

    /* stem 0.9c1.1.2*/ 
    /*0*/ <-5.59947,8.59383,-3.09041>,
    /*1*/ <-5.60176,8.5929,-3.09387>,<-5.59952,8.59778,-3.08881>,<-5.59711,8.59082,-3.08855>,
            
    /*2*/ <-6.07213,8.44394,-2.73619>

    /* stem 0.9c1.1.3*/ 
    /*0*/ <-5.7894,8.7585,-3.01957>,
    /*1*/ <-5.78675,8.76103,-3.01835>,<-5.79252,8.75778,-3.01742>,<-5.78893,8.75669,-3.02295>,
            
    /*2*/ <-6.0577,9.16176,-3.27289>

    /* stem 0.9c1.1.4*/ 
    /*0*/ <-6.02809,9.07025,-3.00579>,
    /*1*/ <-6.03065,9.06865,-3.00459>,<-6.02851,9.07251,-3.00808>,<-6.0251,9.06958,-3.0047>,
            
    /*2*/ <-6.07468,9.38475,-2.68514>

    /* stem 0.9c1.1.5*/ 
    /*0*/ <-6.08626,9.16748,-3.0122>,
    /*1*/ <-6.0849,9.16806,-3.01489>,<-6.08662,9.16974,-3.01014>,<-6.08726,9.16465,-3.01156>,
            
    /*2*/ <-6.46328,9.26237,-3.18216>

    /* stem 0.9c1.1.6*/ 
    /*0*/ <-6.26075,9.48485,-3.04338>,
    /*1*/ <-6.26056,9.48487,-3.04253>,<-6.26151,9.48516,-3.04367>,<-6.26016,9.48453,-3.04394>,
            
    /*2*/ <-6.12498,9.79091,-3.07983>

    /* stem 0.9c2*/ 
    /*0*/ <-3.75279,8.52544,-3.85888>,
    /*1*/ <-3.75273,8.52446,-3.88595>,<-3.74612,8.55001,-3.86813>,<-3.74872,8.54161,-3.83753>,
            <-3.75694,8.51086,-3.83643>,<-3.75942,8.50026,-3.86636>,
    /*2*/ <-4.39652,8.69668,-3.88281>,<-4.39252,8.71212,-3.87204>,<-4.3941,8.70704,-3.85355>,
            <-4.39906,8.68847,-3.85289>,<-4.40056,8.68207,-3.87097>,
    /*3*/ <-5.03764,8.87044,-3.81108>,<-5.03588,8.87566,-3.80738>,<-5.0358,8.87373,-3.80103>,
            <-5.03751,8.86732,-3.80082>,<-5.03865,8.86529,-3.80703>,
    /*4*/ <-5.0371,8.87049,-3.80547>

    /* stem 0.9.0*/ 
    /*0*/ <-0.2325,7.69822,-0.40858>,
    /*1*/ <-0.27288,7.74978,-0.37185>,<-0.2664,7.63824,-0.43841>,<-0.15821,7.70665,-0.41547>,
            
    /*2*/ <-0.32652,7.95722,-0.73743>,<-0.3207,7.85683,-0.79733>,<-0.22332,7.9184,-0.77669>,
            
    /*3*/ <-0.41445,8.21024,-1.04979>,<-0.41347,8.13038,-1.11646>,<-0.32614,8.18383,-1.09802>,
            
    /*4*/ <-0.50475,8.48351,-1.35745>,<-0.50485,8.41639,-1.41895>,<-0.42795,8.46176,-1.40122>,
            
    /*5*/ <-0.53883,8.83192,-1.5798>,<-0.54209,8.7906,-1.64591>,<-0.47323,8.81503,-1.61853>,
            
    /*6*/ <-0.61269,9.17763,-1.81134>,<-0.61542,9.14191,-1.8656>,<-0.55875,9.16711,-1.84608>,
            
    /*7*/ <-0.74178,9.54751,-1.94392>,<-0.74734,9.52899,-1.99221>,<-0.70212,9.55007,-1.97749>,
            
    /*8*/ <-0.84709,9.93964,-2.06299>,<-0.8519,9.9278,-2.09986>,<-0.8171,9.94078,-2.08792>,
            
    /*9*/ <-0.89187,10.32087,-2.25338>,<-0.89419,10.30942,-2.27662>,<-0.87073,10.31651,-2.26789>,
            
    /*10*/ <-0.92716,10.7139,-2.40447>,<-0.92846,10.70935,-2.41658>,<-0.91665,10.71219,-2.41193>,
            
    /*11*/ <-0.96711,11.12187,-2.50849>

    /* stem 0.9.0.0*/ 
    /*0*/ <-0.27803,7.86604,-0.69425>,
    /*1*/ <-0.2819,7.83881,-0.70963>,<-0.25852,7.88796,-0.7057>,<-0.29367,7.87133,-0.66742>,
            
    /*2*/ <-1.49689,8.51267,-1.53249>

    /* stem 0.9.0.1*/ 
    /*0*/ <-0.31081,7.96845,-0.83982>,
    /*1*/ <-0.28804,7.98715,-0.83105>,<-0.33933,7.97945,-0.84311>,<-0.30507,7.93875,-0.8453>,
            
    /*2*/ <-0.00748,8.30447,-2.344>

    /* stem 0.9.0.2*/ 
    /*0*/ <-0.36354,8.11574,-1.01702>,
    /*1*/ <-0.39253,8.11128,-1.0121>,<-0.35335,8.11795,-1.04487>,<-0.34474,8.11799,-0.99408>,
            
    /*2*/ <-0.58763,9.6127,-0.98014>

    /* stem 0.9.0.3*/ 
    /*0*/ <-0.45379,8.37889,-1.31072>,
    /*1*/ <-0.43289,8.36883,-1.32643>,<-0.45879,8.40645,-1.31004>,<-0.46969,8.36139,-1.29569>,
            
    /*2*/ <-1.34209,8.24471,-2.40651>

    /* stem 0.9.0.4*/ 
    /*0*/ <-0.49911,8.63779,-1.50649>,
    /*1*/ <-0.50261,8.65141,-1.4839>,<-0.51553,8.6417,-1.52705>,<-0.47921,8.62027,-1.5085>,
            
    /*2*/ <0.30476,9.6038,-1.96427>

    /* stem 0.9.0.5*/ 
    /*0*/ <-0.54062,8.91427,-1.68058>,
    /*1*/ <-0.5539,8.90065,-1.69708>,<-0.52493,8.93218,-1.68878>,<-0.54303,8.90998,-1.65589>,
            
    /*2*/ <-1.47351,9.757,-1.62532>

    /* stem 0.9.0.6*/ 
    /*0*/ <-0.57468,9.06783,-1.77994>,
    /*1*/ <-0.55184,9.0754,-1.77608>,<-0.59332,9.08319,-1.77665>,<-0.57889,9.04491,-1.78709>,
            
    /*2*/ <-0.49353,9.41485,-2.94017>

    /* stem 0.9.0.7*/ 
    /*0*/ <-0.67037,9.37292,-1.91321>,
    /*1*/ <-0.68976,9.37006,-1.90146>,<-0.67068,9.38378,-1.93331>,<-0.65066,9.36491,-1.90485>,
            
    /*2*/ <-0.49483,10.3561,-1.38478>

    /* stem 0.9.0.8*/ 
    /*0*/ <-0.80373,9.80887,-2.0473>,
    /*1*/ <-0.79599,9.80558,-2.06628>,<-0.80183,9.82754,-2.0384>,<-0.81336,9.79349,-2.0372>,
            
    /*2*/ <-1.68828,10.09407,-2.45719>

    /* stem 0.9.0.9*/ 
    /*0*/ <-0.85469,10.06549,-2.14578>,
    /*1*/ <-0.84962,10.07416,-2.12904>,<-0.8684,10.07348,-2.15714>,<-0.84605,10.04883,-2.15115>,
            
    /*2*/ <-0.18727,10.55949,-2.6037>

    /* stem 0.9.0.10*/ 
    /*0*/ <-0.89225,10.38409,-2.29103>,
    /*1*/ <-0.90354,10.38047,-2.29793>,<-0.88192,10.39031,-2.29757>,<-0.89129,10.38149,-2.2776>,
            
    /*2*/ <-1.24521,11.15291,-2.11708>

    /* stem 0.9.0.11*/ 
    /*0*/ <-0.9123,10.59044,-2.36657>,
    /*1*/ <-0.90258,10.59093,-2.36779>,<-0.91718,10.59812,-2.3629>,<-0.91714,10.58226,-2.369>,
            
    /*2*/ <-1.02152,10.87841,-3.11649>

    /* stem 0.9.0.12*/ 
    /*0*/ <-0.95287,10.98617,-2.47622>,
    /*1*/ <-0.95458,10.98641,-2.47443>,<-0.95316,10.98736,-2.47838>,<-0.95089,10.98472,-2.47586>,
            
    /*2*/ <-0.59606,11.54319,-2.21415>

    /* stem 0.9.1*/ 
    /*0*/ <-0.36655,7.70846,-0.57034>,
    /*1*/ <-0.36232,7.63526,-0.57847>,<-0.34851,7.75289,-0.62639>,<-0.38881,7.73721,-0.50617>,
            
    /*2*/ <-0.75624,7.63465,-0.7106>,<-0.7438,7.74051,-0.75372>,<-0.78007,7.7264,-0.64552>,
            
    /*3*/ <-1.15727,7.73939,-0.83269>,<-1.12476,7.83088,-0.86463>,<-1.15726,7.8189,-0.76847>,
            
    /*4*/ <-1.49959,8.00678,-0.90098>,<-1.44382,8.07328,-0.92256>,<-1.46944,8.0622,-0.83759>,
            
    /*5*/ <-1.74876,8.35015,-0.9626>,<-1.68716,8.39318,-0.97778>,<-1.71307,8.38735,-0.90587>,
            
    /*6*/ <-1.91389,8.73629,-1.02451>,<-1.85566,8.76043,-1.03489>,<-1.87982,8.75961,-0.97576>,
            
    /*7*/ <-2.09894,9.10134,-1.08172>,<-2.05385,9.12368,-1.09063>,<-2.07245,9.12172,-1.04307>,
            
    /*8*/ <-2.251,9.48242,-1.15862>,<-2.21564,9.49596,-1.16462>,<-2.23085,9.49699,-1.12945>,
            
    /*9*/ <-2.32533,9.88565,-1.246>,<-2.30032,9.89001,-1.24891>,<-2.31123,9.89298,-1.22599>,
            
    /*10*/ <-2.40146,10.28697,-1.32233>,<-2.38898,10.28926,-1.32381>,<-2.39437,10.29043,-1.31228>,
            
    /*11*/ <-2.40165,10.68564,-1.44238>

    /* stem 0.9.1.0*/ 
    /*0*/ <-0.56738,7.7044,-0.63819>,
    /*1*/ <-0.56238,7.73079,-0.65456>,<-0.59531,7.69935,-0.62465>,<-0.54445,7.68307,-0.63537>,
            
    /*2*/ <-1.08388,6.97197,-1.97661>

    /* stem 0.9.1.1*/ 
    /*0*/ <-0.88863,7.73243,-0.74277>,
    /*1*/ <-0.89898,7.72393,-0.71592>,<-0.90308,7.72414,-0.76772>,<-0.86384,7.74921,-0.74466>,
            
    /*2*/ <-1.74083,8.99959,-0.67046>

    /* stem 0.9.1.2*/ 
    /*0*/ <-1.09629,7.78395,-0.80653>,
    /*1*/ <-1.09096,7.77287,-0.83285>,<-1.11207,7.8082,-0.80391>,<-1.08585,7.77078,-0.78284>,
            
    /*2*/ <-2.32581,6.97399,-0.71452>

    /* stem 0.9.1.3*/ 
    /*0*/ <-1.294,7.91054,-0.85154>,
    /*1*/ <-1.28214,7.93007,-0.83533>,<-1.32047,7.90264,-0.84687>,<-1.27938,7.8989,-0.87242>,
            
    /*2*/ <-1.75102,8.92037,-1.73418>

    /* stem 0.9.1.4*/ 
    /*0*/ <-1.60565,8.22828,-0.92092>,
    /*1*/ <-1.62661,8.2128,-0.92022>,<-1.60406,8.24727,-0.9387>,<-1.58627,8.22476,-0.90384>,
            
    /*2*/ <-2.18787,9.05406,-0.09054>

    /* stem 0.9.1.5*/ 
    /*0*/ <-1.76788,8.49287,-0.96822>,
    /*1*/ <-1.74949,8.49844,-0.98374>,<-1.77679,8.5101,-0.95292>,<-1.77737,8.47006,-0.96799>,
            
    /*2*/ <-2.5901,8.82668,-1.82289>

    /* stem 0.9.1.6*/ 
    /*0*/ <-1.8465,8.66973,-0.99789>,
    /*1*/ <-1.85193,8.6712,-0.97471>,<-1.86238,8.67658,-1.01432>,<-1.82519,8.6614,-1.00465>,
            
    /*2*/ <-1.40635,9.76951,-0.96482>

    /* stem 0.9.1.7*/ 
    /*0*/ <-2.0046,8.98212,-1.04974>,
    /*1*/ <-2.0132,8.97442,-1.06883>,<-1.99609,9.00272,-1.04885>,<-2.0045,8.96921,-1.03155>,
            
    /*2*/ <-2.99099,9.37685,-0.76447>

    /* stem 0.9.1.8*/ 
    /*0*/ <-2.12971,9.24614,-1.09925>,
    /*1*/ <-2.11215,9.25503,-1.09192>,<-2.1483,9.25539,-1.09605>,<-2.12869,9.228,-1.10979>,
            
    /*2*/ <-2.02383,9.76479,-1.9815>

    /* stem 0.9.1.9*/ 
    /*0*/ <-2.28733,9.76512,-1.21233>,
    /*1*/ <-2.30356,9.76294,-1.20755>,<-2.28376,9.77309,-1.22699>,<-2.27468,9.75934,-1.20246>,
            
    /*2*/ <-2.26541,10.54919,-0.78078>

    /* stem 0.9.1.10*/ 
    /*0*/ <-2.3317,9.98331,-1.25889>,
    /*1*/ <-2.32429,9.98272,-1.26958>,<-2.33018,9.9931,-1.25045>,<-2.34062,9.9741,-1.25664>,
            
    /*2*/ <-2.90308,10.43429,-1.6794>

    /* stem 0.9.1.11*/ 
    /*0*/ <-2.38245,10.22854,-1.30751>,
    /*1*/ <-2.38179,10.23032,-1.29923>,<-2.38847,10.23228,-1.31219>,<-2.37709,10.22303,-1.31111>,
            
    /*2*/ <-1.89258,10.81215,-1.47162>

    /* stem 0.9.1.12*/ 
    /*0*/ <-2.39764,10.4485,-1.36892>,
    /*1*/ <-2.40069,10.44751,-1.37195>,<-2.39411,10.45089,-1.37005>,<-2.39813,10.44711,-1.36477>,
            
    /*2*/ <-2.75656,11.0563,-1.20673>

    /* stem 0.9.2*/ 
    /*0*/ <-0.57632,7.73857,-0.81427>,
    /*1*/ <-0.54184,7.79809,-0.83462>,<-0.64446,7.74238,-0.79218>,<-0.54266,7.67525,-0.81599>,
            
    /*2*/ <-0.67106,7.7356,-1.21096>,<-0.76342,7.68546,-1.17277>,<-0.67179,7.62505,-1.19419>,
            
    /*3*/ <-0.79673,7.80977,-1.56707>,<-0.88355,7.76576,-1.54695>,<-0.80829,7.71253,-1.58413>,
            
    /*4*/ <-0.89552,8.02661,-1.8672>,<-0.97644,7.99483,-1.86476>,<-0.91563,7.95529,-1.91273>,
            
    /*5*/ <-1.01325,8.29509,-2.137>,<-1.08282,8.26839,-2.13489>,<-1.03377,8.24078,-2.18376>,
            
    /*6*/ <-1.16083,8.60087,-2.34911>,<-1.21808,8.57703,-2.34544>,<-1.18112,8.56189,-2.39302>,
            
    /*7*/ <-1.32762,8.93072,-2.50425>,<-1.37289,8.91057,-2.50039>,<-1.3464,8.9044,-2.54199>,
            
    /*8*/ <-1.48044,9.27696,-2.63601>,<-1.51502,9.26325,-2.63367>,<-1.49568,9.25973,-2.66534>,
            
    /*9*/ <-1.65893,9.6231,-2.74051>,<-1.68135,9.6126,-2.73844>,<-1.6694,9.61219,-2.76023>,
            
    /*10*/ <-1.80234,9.98129,-2.85234>,<-1.814,9.97706,-2.85162>,<-1.80773,9.97623,-2.86232>,
            
    /*11*/ <-1.97241,10.34573,-2.86416>

    /* stem 0.9.2.0*/ 
    /*0*/ <-0.65035,7.7053,-1.03696>,
    /*1*/ <-0.67759,7.69652,-1.0266>,<-0.63834,7.69185,-1.0615>,<-0.63511,7.72753,-1.0228>,
            
    /*2*/ <-1.33716,8.75822,-1.95046>

    /* stem 0.9.2.1*/ 
    /*0*/ <-0.72999,7.6997,-1.27439>,
    /*1*/ <-0.70517,7.68839,-1.2853>,<-0.74163,7.72384,-1.28637>,<-0.74315,7.68685,-1.25149>,
            
    /*2*/ <-1.52741,6.85129,-2.20901>

    /* stem 0.9.2.2*/ 
    /*0*/ <-0.78897,7.73702,-1.44722>,
    /*1*/ <-0.79954,7.762,-1.43822>,<-0.80493,7.71978,-1.46349>,<-0.76244,7.72929,-1.43996>,
            
    /*2*/ <-0.27476,8.38351,-2.63686>

    /* stem 0.9.2.3*/ 
    /*0*/ <-0.89158,7.90561,-1.7625>,
    /*1*/ <-0.90212,7.88409,-1.77483>,<-0.87847,7.92429,-1.77684>,<-0.89415,7.90846,-1.73582>,
            
    /*2*/ <-2.05466,8.58074,-1.94669>

    /* stem 0.9.2.4*/ 
    /*0*/ <-0.98685,8.13165,-2.01818>,
    /*1*/ <-0.96446,8.14342,-2.01562>,<-1.00821,8.14528,-2.02027>,<-0.98788,8.10625,-2.01865>,
            
    /*2*/ <-0.85174,8.1497,-3.28291>

    /* stem 0.9.2.5*/ 
    /*0*/ <-1.09562,8.38191,-2.22877>,
    /*1*/ <-1.11657,8.37998,-2.21737>,<-1.09505,8.38292,-2.25266>,<-1.07524,8.38283,-2.21627>,
            
    /*2*/ <-1.17874,9.56699,-2.18051>

    /* stem 0.9.2.6*/ 
    /*0*/ <-1.15572,8.5126,-2.31705>,
    /*1*/ <-1.14503,8.50468,-2.33604>,<-1.15193,8.53431,-2.30981>,<-1.17019,8.49882,-2.30529>,
            
    /*2*/ <-2.03109,8.88087,-2.96287>

    /* stem 0.9.2.7*/ 
    /*0*/ <-1.25561,8.72235,-2.42752>,
    /*1*/ <-1.25059,8.73323,-2.40899>,<-1.27522,8.72542,-2.43715>,<-1.24102,8.70839,-2.43641>,
            
    /*2*/ <-0.83849,9.53397,-3.01733>

    /* stem 0.9.2.8*/ 
    /*0*/ <-1.42366,9.09248,-2.58084>,
    /*1*/ <-1.43921,9.08283,-2.58926>,<-1.41248,9.10511,-2.59186>,<-1.41929,9.0895,-2.5614>,
            
    /*2*/ <-2.01813,9.83418,-2.33345>

    /* stem 0.9.2.9*/ 
    /*0*/ <-1.62572,9.52669,-2.72048>,
    /*1*/ <-1.61124,9.53268,-2.72452>,<-1.63555,9.53512,-2.71078>,<-1.63037,9.51226,-2.72614>,
            
    /*2*/ <-1.97619,9.90981,-3.40898>

    /* stem 0.9.2.10*/ 
    /*0*/ <-1.7044,9.70644,-2.77363>,
    /*1*/ <-1.71236,9.70632,-2.76392>,<-1.70846,9.70971,-2.78505>,<-1.69237,9.70329,-2.77191>,
            
    /*2*/ <-1.52313,10.48362,-2.61573>

    /* stem 0.9.2.11*/ 
    /*0*/ <-1.77629,9.89498,-2.83038>,
    /*1*/ <-1.77593,9.89256,-2.83886>,<-1.77274,9.90264,-2.82782>,<-1.7802,9.88973,-2.82446>,
            
    /*2*/ <-2.44182,10.24591,-2.9584>

    /* stem 0.9.2.12*/ 
    /*0*/ <-1.85221,10.07699,-2.85778>,
    /*1*/ <-1.8489,10.07855,-2.85402>,<-1.85717,10.0787,-2.85779>,<-1.85056,10.07371,-2.86152>,
            
    /*2*/ <-1.65831,10.6347,-3.26102>

    /* stem 0.9.3*/ 
    /*0*/ <-0.81995,7.78552,-1.08971>,
    /*1*/ <-0.87139,7.76567,-1.04759>,<-0.80908,7.75192,-1.14944>,<-0.77936,7.83899,-1.0721>,
            
    /*2*/ <-1.1084,8.01109,-1.23282>,<-1.05232,7.99871,-1.32449>,<-1.02557,8.07708,-1.25488>,
            
    /*3*/ <-1.29398,8.28128,-1.46129>,<-1.23501,8.26173,-1.53467>,<-1.21203,8.33052,-1.47155>,
            
    /*4*/ <-1.49513,8.55208,-1.6421>,<-1.44922,8.54133,-1.71178>,<-1.42549,8.59774,-1.65405>,
            
    /*5*/ <-1.65332,8.88992,-1.75476>,<-1.61795,8.88683,-1.81754>,<-1.58795,8.91977,-1.76083>,
            
    /*6*/ <-1.75087,9.25744,-1.85568>,<-1.72032,9.25238,-1.90718>,<-1.6929,9.27312,-1.85789>,
            
    /*7*/ <-1.78307,9.64445,-1.89767>,<-1.75903,9.64269,-1.93927>,<-1.73522,9.64912,-1.898>,
            
    /*8*/ <-1.86774,10.01545,-1.86289>,<-1.85126,10.02265,-1.89414>,<-1.83272,10.02402,-1.86324>,
            
    /*9*/ <-2.0176,10.36814,-1.82604>,<-2.00735,10.37505,-1.84666>,<-1.99562,10.37786,-1.82587>,
            
    /*10*/ <-2.14307,10.73612,-1.8611>,<-2.13703,10.73739,-1.87141>,<-2.13176,10.74019,-1.86097>,
            
    /*11*/ <-2.26439,11.10322,-1.89695>

    /* stem 0.9.3.0*/ 
    /*0*/ <-0.96812,7.93448,-1.20048>,
    /*1*/ <-0.95609,7.92723,-1.22632>,<-0.97689,7.96213,-1.19557>,<-0.97139,7.91409,-1.17954>,
            
    /*2*/ <-2.32332,7.60007,-1.73759>

    /* stem 0.9.3.1*/ 
    /*0*/ <-1.15734,8.16403,-1.38325>,
    /*1*/ <-1.15487,8.18283,-1.36276>,<-1.18117,8.16215,-1.39768>,<-1.13598,8.1471,-1.3893>,
            
    /*2*/ <-0.67032,9.1102,-2.31053>

    /* stem 0.9.3.2*/ 
    /*0*/ <-1.27332,8.3254,-1.51179>,
    /*1*/ <-1.29056,8.30655,-1.52024>,<-1.2625,8.3426,-1.52941>,<-1.26691,8.32704,-1.48571>,
            
    /*2*/ <-2.30532,9.17976,-1.3117>

    /* stem 0.9.3.3*/ 
    /*0*/ <-1.40605,8.49798,-1.62585>,
    /*1*/ <-1.3843,8.50972,-1.6334>,<-1.42515,8.51175,-1.6152>,<-1.40871,8.47245,-1.62897>,
            
    /*2*/ <-1.91896,8.6946,-2.79928>

    /* stem 0.9.3.4*/ 
    /*0*/ <-1.54816,8.7518,-1.73015>,
    /*1*/ <-1.56325,8.75069,-1.71087>,<-1.55708,8.75687,-1.7524>,<-1.52417,8.74783,-1.72717>,
            
    /*2*/ <-1.37623,9.94337,-1.52735>

    /* stem 0.9.3.5*/ 
    /*0*/ <-1.65105,9.01043,-1.80725>,
    /*1*/ <-1.65036,9.00467,-1.82976>,<-1.64123,9.03021,-1.80001>,<-1.66157,8.99641,-1.79199>,
            
    /*2*/ <-2.64398,9.56681,-1.98052>

    /* stem 0.9.3.6*/ 
    /*0*/ <-1.73389,9.38859,-1.88622>,
    /*1*/ <-1.72018,9.39155,-1.86992>,<-1.7512,9.40121,-1.88813>,<-1.73029,9.37302,-1.9006>,
            
    /*2*/ <-1.17691,10.06338,-2.47732>

    /* stem 0.9.3.7*/ 
    /*0*/ <-1.80161,9.8198,-1.89389>,
    /*1*/ <-1.82043,9.81554,-1.89708>,<-1.79289,9.83392,-1.90424>,<-1.79151,9.80995,-1.88034>,
            
    /*2*/ <-2.05741,10.45871,-1.23844>

    /* stem 0.9.3.8*/ 
    /*0*/ <-1.8879,10.10501,-1.86373>,
    /*1*/ <-1.87379,10.11229,-1.87268>,<-1.89233,10.11116,-1.84717>,<-1.89758,10.09159,-1.87136>,
            
    /*2*/ <-2.42417,10.69799,-2.22727>

    /* stem 0.9.3.9*/ 
    /*0*/ <-1.97959,10.31209,-1.83994>,
    /*1*/ <-1.9838,10.30861,-1.82587>,<-1.98863,10.32043,-1.84868>,<-1.96633,10.30724,-1.84526>,
            
    /*2*/ <-1.61717,10.99733,-1.56164>

    /* stem 0.9.3.10*/ 
    /*0*/ <-2.05005,10.4943,-1.84333>,
    /*1*/ <-2.05337,10.49217,-1.85422>,<-2.0443,10.50404,-1.84084>,<-2.05248,10.4867,-1.83494>,
            
    /*2*/ <-2.72318,10.85745,-1.70918>

    /* stem 0.9.3.11*/ 
    /*0*/ <-2.16914,10.82947,-1.87263>,
    /*1*/ <-2.16499,10.83115,-1.86999>,<-2.17392,10.83094,-1.87118>,<-2.16853,10.82631,-1.87672>,
            
    /*2*/ <-2.12609,11.37863,-2.28959>

    /* stem 0.9.4*/ 
    /*0*/ <-0.9736,7.81414,-1.25488>,
    /*1*/ <-0.93108,7.78798,-1.30099>,<-0.99954,7.87628,-1.26399>,<-0.99016,7.77817,-1.19967>,
            
    /*2*/ <-1.22961,7.64042,-1.48254>,<-1.29123,7.71989,-1.44924>,<-1.28279,7.63159,-1.39135>,
            
    /*3*/ <-1.57853,7.59892,-1.6556>,<-1.60957,7.67737,-1.61377>,<-1.6211,7.59389,-1.57176>,
            
    /*4*/ <-1.92189,7.67882,-1.81707>,<-1.92905,7.74653,-1.77069>,<-1.95885,7.67467,-1.74356>,
            
    /*5*/ <-2.21165,7.90656,-1.9419>,<-2.19646,7.95437,-1.8922>,<-2.24306,7.90304,-1.87876>,
            
    /*6*/ <-2.42994,8.22452,-1.99213>,<-2.40401,8.25036,-1.94605>,<-2.45279,8.21838,-1.93825>,
            
    /*7*/ <-2.59564,8.57273,-1.95314>,<-2.5683,8.58221,-1.91601>,<-2.61019,8.56167,-1.90976>,
            
    /*8*/ <-2.73878,8.92184,-1.94214>,<-2.71867,8.9298,-1.91423>,<-2.75098,8.9164,-1.90946>,
            
    /*9*/ <-2.85478,9.27119,-2.01392>,<-2.8425,9.27941,-1.9956>,<-2.86484,9.27258,-1.99268>,
            
    /*10*/ <-2.95285,9.64042,-2.01153>,<-2.94606,9.64235,-2.00212>,<-2.95735,9.63934,-2.00071>,
            
    /*11*/ <-2.95348,10.01942,-1.98513>

    /* stem 0.9.4.0*/ 
    /*0*/ <-1.12951,7.73458,-1.35352>,
    /*1*/ <-1.14486,7.75862,-1.34864>,<-1.14002,7.70883,-1.34552>,<-1.10365,7.73629,-1.36639>,
            
    /*2*/ <-1.77315,7.58962,-2.66566>

    /* stem 0.9.4.1*/ 
    /*0*/ <-1.44241,7.64284,-1.53095>,
    /*1*/ <-1.44356,7.61684,-1.5226>,<-1.45258,7.64983,-1.55534>,<-1.43108,7.66186,-1.51492>,
            
    /*2*/ <-2.66912,7.88395,-0.95019>

    /* stem 0.9.4.2*/ 
    /*0*/ <-1.71944,7.65013,-1.67072>,
    /*1*/ <-1.70729,7.66397,-1.68905>,<-1.7401,7.66007,-1.6585>,<-1.71094,7.62634,-1.66462>,
            
    /*2*/ <-2.50263,7.13753,-2.57735>

    /* stem 0.9.4.3*/ 
    /*0*/ <-1.83086,7.67572,-1.72531>,
    /*1*/ <-1.8414,7.67878,-1.70236>,<-1.84129,7.65966,-1.74205>,<-1.80989,7.68872,-1.73151>,
            
    /*2*/ <-2.55152,8.62001,-2.18221>

    /* stem 0.9.4.4*/ 
    /*0*/ <-2.05247,7.79145,-1.82965>,
    /*1*/ <-2.05492,7.77718,-1.84909>,<-2.04923,7.8153,-1.83247>,<-2.05327,7.78187,-1.8074>,
            
    /*2*/ <-3.24691,7.95748,-1.80113>

    /* stem 0.9.4.5*/ 
    /*0*/ <-2.3726,8.14874,-1.94432>,
    /*1*/ <-2.35644,8.16126,-1.93604>,<-2.39351,8.15237,-1.93834>,<-2.36784,8.13261,-1.95858>,
            
    /*2*/ <-2.48797,8.84447,-2.77021>

    /* stem 0.9.4.6*/ 
    /*0*/ <-2.51056,8.40251,-1.94248>,
    /*1*/ <-2.52819,8.39351,-1.9362>,<-2.51115,8.41796,-1.95634>,<-2.49233,8.39606,-1.93489>,
            
    /*2*/ <-2.58602,9.07764,-1.18686>

    /* stem 0.9.4.7*/ 
    /*0*/ <-2.65928,8.7366,-1.92426>,
    /*1*/ <-2.64992,8.74067,-1.94045>,<-2.65912,8.74905,-1.90972>,<-2.66881,8.72008,-1.9226>,
            
    /*2*/ <-3.42194,9.14256,-2.26333>

    /* stem 0.9.4.8*/ 
    /*0*/ <-2.77134,9.02768,-1.94546>,
    /*1*/ <-2.77037,9.03186,-1.92825>,<-2.78577,9.03198,-1.95484>,<-2.75788,9.0192,-1.9533>,
            
    /*2*/ <-2.41718,9.77655,-2.1473>

    /* stem 0.9.4.9*/ 
    /*0*/ <-2.81571,9.16004,-1.97512>,
    /*1*/ <-2.82601,9.15424,-1.9856>,<-2.80835,9.17372,-1.97801>,<-2.81277,9.15216,-1.96174>,
            
    /*2*/ <-3.42211,9.56498,-1.60358>

    /* stem 0.9.4.10*/ 
    /*0*/ <-2.89958,9.44454,-2.00262>,
    /*1*/ <-2.88952,9.44724,-2.00205>,<-2.90655,9.44899,-1.99625>,<-2.90268,9.43739,-2.00955>,
            
    /*2*/ <-3.0156,9.98322,-2.50625>

    /* stem 0.9.4.11*/ 
    /*0*/ <-2.9529,9.86261,-1.99327>,
    /*1*/ <-2.95514,9.86251,-1.99157>,<-2.95291,9.86429,-1.99552>,<-2.95064,9.86102,-1.99271>,
            
    /*2*/ <-2.70485,10.3398,-1.63822>

    /* stem 0.9.5*/ 
    /*0*/ <-1.2351,7.86133,-1.5228>,
    /*1*/ <-1.25142,7.91919,-1.49667>,<-1.28115,7.81579,-1.53298>,<-1.17271,7.84899,-1.53874>,
            
    /*2*/ <-1.30854,8.0475,-1.83299>,<-1.3353,7.95444,-1.86567>,<-1.2377,7.98432,-1.87085>,
            
    /*3*/ <-1.36406,8.26731,-2.0946>,<-1.39285,8.19887,-2.14694>,<-1.30498,8.22189,-2.14655>,
            
    /*4*/ <-1.45568,8.48751,-2.37001>,<-1.48064,8.42543,-2.41292>,<-1.40522,8.44989,-2.41856>,
            
    /*5*/ <-1.54422,8.7358,-2.6142>,<-1.5676,8.68757,-2.65625>,<-1.50248,8.70727,-2.65987>,
            
    /*6*/ <-1.58978,9.04274,-2.78704>,<-1.61233,9.01527,-2.83131>,<-1.5564,9.02482,-2.82932>,
            
    /*7*/ <-1.68537,9.33688,-2.98321>,<-1.70248,9.31038,-3.01588>,<-1.65899,9.32338,-3.01763>,
            
    /*8*/ <-1.75831,9.64829,-3.15368>,<-1.77194,9.63136,-3.1799>,<-1.73876,9.63908,-3.18001>,
            
    /*9*/ <-1.88522,9.9625,-3.28106>,<-1.89466,9.95191,-3.29879>,<-1.87344,9.95986,-3.3003>,
            
    /*10*/ <-1.95063,10.30536,-3.38204>,<-1.95585,10.30177,-3.39146>,<-1.94469,10.30387,-3.39159>,
            
    /*11*/ <-1.95389,10.66598,-3.42716>

    /* stem 0.9.5.0*/ 
    /*0*/ <-1.27727,7.95757,-1.76231>,
    /*1*/ <-1.28895,7.9337,-1.76984>,<-1.26164,7.97158,-1.78027>,<-1.2812,7.96744,-1.73681>,
            
    /*2*/ <-2.40511,8.64922,-2.20413>

    /* stem 0.9.5.1*/ 
    /*0*/ <-1.32604,8.12071,-2.00263>,
    /*1*/ <-1.30183,8.13059,-1.99949>,<-1.34621,8.13675,-2.0081>,<-1.33009,8.09478,-2.00031>,
            
    /*2*/ <-1.09606,7.96866,-3.29693>

    /* stem 0.9.5.2*/ 
    /*0*/ <-1.37894,8.28964,-2.20203>,
    /*1*/ <-1.40198,8.29204,-2.19211>,<-1.37619,8.28644,-2.22687>,<-1.35866,8.29042,-2.1871>,
            
    /*2*/ <-1.31447,9.53789,-2.35522>

    /* stem 0.9.5.3*/ 
    /*0*/ <-1.42966,8.41201,-2.34954>,
    /*1*/ <-1.41753,8.39801,-2.36532>,<-1.42772,8.43623,-2.35077>,<-1.44373,8.40178,-2.33252>,
            
    /*2*/ <-2.37381,8.44895,-3.10809>

    /* stem 0.9.5.4*/ 
    /*0*/ <-1.4856,8.56243,-2.50316>,
    /*1*/ <-1.48138,8.57903,-2.48726>,<-1.50635,8.56151,-2.51386>,<-1.46907,8.54675,-2.50836>,
            
    /*2*/ <-1.0863,9.25999,-3.33719>

    /* stem 0.9.5.5*/ 
    /*0*/ <-1.55169,8.79997,-2.6922>,
    /*1*/ <-1.56925,8.79169,-2.70255>,<-1.5359,8.81009,-2.7037>,<-1.54992,8.79813,-2.67035>,
            
    /*2*/ <-2.06849,9.74403,-2.57102>

    /* stem 0.9.5.6*/ 
    /*0*/ <-1.62492,9.14693,-2.89237>,
    /*1*/ <-1.60546,9.15084,-2.89613>,<-1.63711,9.16166,-2.88585>,<-1.63219,9.1283,-2.89514>,
            
    /*2*/ <-1.8504,9.37333,-3.82419>

    /* stem 0.9.5.7*/ 
    /*0*/ <-1.70669,9.42771,-3.06016>,
    /*1*/ <-1.71983,9.43133,-3.04737>,<-1.70959,9.43221,-3.07808>,<-1.69065,9.41958,-3.05504>,
            
    /*2*/ <-1.34088,10.24161,-2.91503>

    /* stem 0.9.5.8*/ 
    /*0*/ <-1.78543,9.71191,-3.19895>,
    /*1*/ <-1.78441,9.70611,-3.21514>,<-1.78182,9.72839,-3.19545>,<-1.79007,9.70122,-3.18625>,
            
    /*2*/ <-2.57731,9.91118,-3.32045>

    /* stem 0.9.5.9*/ 
    /*0*/ <-1.85434,9.88323,-3.26467>,
    /*1*/ <-1.8462,9.89031,-3.25475>,<-1.86816,9.88741,-3.26714>,<-1.84864,9.87197,-3.27212>,
            
    /*2*/ <-1.60743,10.37356,-3.81667>

    /* stem 0.9.5.10*/ 
    /*0*/ <-1.9013,10.04642,-3.31766>,
    /*1*/ <-1.91229,10.04383,-3.31945>,<-1.89558,10.05268,-3.32534>,<-1.89603,10.04275,-3.3082>,
            
    /*2*/ <-2.10304,10.6607,-2.96684>

    /* stem 0.9.5.11*/ 
    /*0*/ <-1.95272,10.54525,-3.41423>,
    /*1*/ <-1.95081,10.54516,-3.41528>,<-1.95313,10.54689,-3.41285>,<-1.95423,10.5437,-3.41456>,
            
    /*2*/ <-2.18863,10.87283,-3.87447>

    /* stem 0.9.6*/ 
    /*0*/ <-1.69273,7.98649,-1.98641>,
    /*1*/ <-1.71122,7.92803,-1.98584>,<-1.66372,8.00901,-2.03552>,<-1.70325,8.02245,-1.93786>,
            
    /*2*/ <-2.00637,8.02651,-2.11888>,<-1.96361,8.09939,-2.16359>,<-1.9992,8.11149,-2.0757>,
            
    /*3*/ <-2.25088,8.2435,-2.26656>,<-2.18928,8.29565,-2.29311>,<-2.22489,8.30733,-2.21686>,
            
    /*4*/ <-2.45702,8.49037,-2.39144>,<-2.39805,8.53088,-2.41164>,<-2.42803,8.53994,-2.34421>,
            
    /*5*/ <-2.62665,8.77205,-2.49608>,<-2.5717,8.80082,-2.5107>,<-2.59662,8.80744,-2.45242>,
            
    /*6*/ <-2.79703,9.06652,-2.52316>,<-2.75235,9.09212,-2.53616>,<-2.76695,9.08835,-2.48523>,
            
    /*7*/ <-2.96564,9.35438,-2.57494>,<-2.92961,9.37442,-2.58519>,<-2.94288,9.3739,-2.54483>,
            
    /*8*/ <-3.09831,9.64858,-2.68082>,<-3.06925,9.65994,-2.68726>,<-3.08211,9.6645,-2.65847>,
            
    /*9*/ <-3.19849,9.95396,-2.79193>,<-3.17833,9.95965,-2.79547>,<-3.18732,9.96356,-2.77662>,
            
    /*10*/ <-3.26714,10.25236,-2.9371>,<-3.25678,10.25429,-2.93842>,<-3.26168,10.25747,-2.92956>,
            
    /*11*/ <-3.36834,10.537,-3.08814>

    /* stem 0.9.6.0*/ 
    /*0*/ <-1.82143,8.02664,-2.04403>,
    /*1*/ <-1.80909,8.04368,-2.05973>,<-1.84128,8.03475,-2.02889>,<-1.81393,8.00149,-2.04348>,
            
    /*2*/ <-2.67271,7.75135,-3.01207>

    /* stem 0.9.6.1*/ 
    /*0*/ <-2.1396,8.21031,-2.20949>,
    /*1*/ <-2.15223,8.21028,-2.18852>,<-2.15127,8.20743,-2.23082>,<-2.11529,8.21322,-2.20913>,
            
    /*2*/ <-2.28299,9.41859,-2.29393>

    /* stem 0.9.6.2*/ 
    /*0*/ <-2.35305,8.43407,-2.33765>,
    /*1*/ <-2.35288,8.42359,-2.35815>,<-2.34834,8.45656,-2.33618>,<-2.35794,8.42207,-2.31862>,
            
    /*2*/ <-3.45866,8.67448,-2.47012>

    /* stem 0.9.6.3*/ 
    /*0*/ <-2.52442,8.67517,-2.44136>,
    /*1*/ <-2.51165,8.68776,-2.42924>,<-2.5455,8.67972,-2.44322>,<-2.5161,8.65802,-2.45163>,
            
    /*2*/ <-2.31868,9.28316,-3.2896>

    /* stem 0.9.6.4*/ 
    /*0*/ <-2.65146,8.88176,-2.4951>,
    /*1*/ <-2.66908,8.87131,-2.49359>,<-2.64849,8.89469,-2.51078>,<-2.6368,8.87929,-2.48091>,
            
    /*2*/ <-3.04843,9.62873,-1.95481>

    /* stem 0.9.6.5*/ 
    /*0*/ <-2.71195,8.98233,-2.505>,
    /*1*/ <-2.69905,8.98872,-2.51891>,<-2.71689,8.99425,-2.48969>,<-2.71992,8.96401,-2.5064>,
            
    /*2*/ <-3.45298,9.34426,-3.02596>

    /* stem 0.9.6.6*/ 
    /*0*/ <-2.84742,9.20582,-2.538>,
    /*1*/ <-2.8506,9.20735,-2.51949>,<-2.86129,9.20931,-2.55027>,<-2.83035,9.2008,-2.54425>,
            
    /*2*/ <-2.60037,10.08341,-2.56803>

    /* stem 0.9.6.7*/ 
    /*0*/ <-3.0294,9.54385,-2.63346>,
    /*1*/ <-3.03569,9.53582,-2.64714>,<-3.02283,9.55952,-2.63504>,<-3.02968,9.53621,-2.6182>,
            
    /*2*/ <-3.76463,9.8672,-2.48497>

    /* stem 0.9.6.8*/ 
    /*0*/ <-3.1492,9.84736,-2.74632>,
    /*1*/ <-3.13682,9.8534,-2.74167>,<-3.16196,9.85345,-2.74296>,<-3.14881,9.83523,-2.75432>,
            
    /*2*/ <-3.11701,10.25189,-3.35774>

    /* stem 0.9.6.9*/ 
    /*0*/ <-3.22523,10.10798,-2.86206>,
    /*1*/ <-3.234,10.10706,-2.85951>,<-3.22316,10.10966,-2.87084>,<-3.21854,10.10722,-2.85583>,
            
    /*2*/ <-3.25978,10.7596,-2.74562>

    /* stem 0.9.6.10*/ 
    /*0*/ <-3.29921,10.35371,-2.98872>,
    /*1*/ <-3.29686,10.35291,-2.99183>,<-3.29909,10.3573,-2.98701>,<-3.30168,10.35092,-2.98733>,
            
    /*2*/ <-3.72337,10.54407,-3.35853>

    /* stem 0.9.7*/ 
    /*0*/ <-2.10036,8.10853,-2.34142>,
    /*1*/ <-2.06565,8.14373,-2.37129>,<-2.14787,8.12948,-2.31611>,<-2.08757,8.0524,-2.33686>,
            
    /*2*/ <-2.23527,8.08098,-2.63116>,<-2.30927,8.06816,-2.58149>,<-2.255,7.99878,-2.60016>,
            
    /*3*/ <-2.41653,8.17098,-2.85928>,<-2.48136,8.16063,-2.81352>,<-2.45402,8.10028,-2.8584>,
            
    /*4*/ <-2.55884,8.37139,-3.0397>,<-2.61784,8.36449,-3.00262>,<-2.60596,8.32278,-3.0576>,
            
    /*5*/ <-2.68532,8.60479,-3.20549>,<-2.73666,8.6001,-3.17474>,<-2.72887,8.56846,-3.22515>,
            
    /*6*/ <-2.82851,8.83674,-3.3699>,<-2.87028,8.83111,-3.34297>,<-2.86405,8.80504,-3.38519>,
            
    /*7*/ <-2.90452,9.11591,-3.4808>,<-2.93935,9.11491,-3.46113>,<-2.93702,9.10063,-3.49843>,
            
    /*8*/ <-2.93586,9.39982,-3.60937>,<-2.96273,9.40322,-3.59644>,<-2.96067,9.39106,-3.6238>,
            
    /*9*/ <-3.01656,9.70199,-3.67247>,<-3.0337,9.69983,-3.66238>,<-3.03308,9.69592,-3.68199>,
            
    /*10*/ <-3.03231,10.009,-3.73761>,<-3.04112,10.0097,-3.73293>,<-3.0408,10.00764,-3.74272>,
            
    /*11*/ <-3.03029,10.31694,-3.80974>

    /* stem 0.9.7.0*/ 
    /*0*/ <-2.19464,8.07493,-2.49057>,
    /*1*/ <-2.21545,8.07563,-2.47758>,<-2.19045,8.05634,-2.50604>,<-2.17802,8.09281,-2.4881>,
            
    /*2*/ <-2.73561,8.70204,-3.39059>

    /* stem 0.9.7.1*/ 
    /*0*/ <-2.35016,8.09231,-2.71305>,
    /*1*/ <-2.33932,8.07735,-2.7273>,<-2.35516,8.11387,-2.7204>,<-2.35599,8.0857,-2.69146>,
            
    /*2*/ <-3.37324,7.7219,-3.10262>

    /* stem 0.9.7.2*/ 
    /*0*/ <-2.49266,8.20511,-2.89922>,
    /*1*/ <-2.48622,8.22162,-2.88591>,<-2.51259,8.20581,-2.90889>,<-2.47917,8.18791,-2.90286>,
            
    /*2*/ <-2.059,8.72644,-3.75517>

    /* stem 0.9.7.3*/ 
    /*0*/ <-2.63282,8.42783,-3.08631>,
    /*1*/ <-2.64969,8.4164,-3.09018>,<-2.62485,8.43992,-3.10115>,<-2.62393,8.42717,-3.06758>,
            
    /*2*/ <-3.22261,9.19387,-2.77922>

    /* stem 0.9.7.4*/ 
    /*0*/ <-2.773,8.68629,-3.26883>,
    /*1*/ <-2.75608,8.69064,-3.2768>,<-2.78455,8.7003,-3.26257>,<-2.77837,8.66793,-3.26711>,
            
    /*2*/ <-3.17796,8.72643,-4.10651>

    /* stem 0.9.7.5*/ 
    /*0*/ <-2.90581,9.02721,-3.44692>,
    /*1*/ <-2.91512,9.03053,-3.43265>,<-2.91298,9.02915,-3.46261>,<-2.88933,9.02194,-3.4455>,
            
    /*2*/ <-2.65084,9.81946,-3.46524>

    /* stem 0.9.7.6*/ 
    /*0*/ <-2.93623,9.21245,-3.52613>,
    /*1*/ <-2.93795,9.20559,-3.54097>,<-2.92584,9.22501,-3.52404>,<-2.94489,9.20673,-3.51338>,
            
    /*2*/ <-3.51265,9.71646,-3.69186>

    /* stem 0.9.7.7*/ 
    /*0*/ <-2.97858,9.50083,-3.63117>,
    /*1*/ <-2.96771,9.50545,-3.6219>,<-2.99172,9.50809,-3.63153>,<-2.97631,9.48896,-3.64008>,
            
    /*2*/ <-2.72841,9.92866,-4.13744>

    /* stem 0.9.7.8*/ 
    /*0*/ <-3.03198,9.82535,-3.69895>,
    /*1*/ <-3.04116,9.82499,-3.69918>,<-3.02741,9.83041,-3.70514>,<-3.02735,9.82064,-3.69254>,
            
    /*2*/ <-3.06045,10.32066,-3.3148>

    /* stem 0.9.7.9*/ 
    /*0*/ <-3.03316,10.20339,-3.78322>,
    /*1*/ <-3.03149,10.20305,-3.78449>,<-3.03318,10.20507,-3.78191>,<-3.03481,10.20205,-3.78325>,
            
    /*2*/ <-3.26385,10.4976,-4.16516>

    /* stem 0.9.8*/ 
    /*0*/ <-2.63864,8.22281,-2.80097>,
    /*1*/ <-2.67308,8.22438,-2.76163>,<-2.6392,8.18277,-2.83464>,<-2.60365,8.26128,-2.80666>,
            
    /*2*/ <-2.85488,8.36794,-2.93341>,<-2.82439,8.3305,-2.99912>,<-2.79239,8.40115,-2.97394>,
            
    /*3*/ <-2.98728,8.57041,-3.09779>,<-2.96167,8.53979,-3.15829>,<-2.92346,8.59154,-3.12488>,
            
    /*4*/ <-3.08349,8.78528,-3.27212>,<-3.05914,8.75627,-3.323>,<-3.02417,8.79807,-3.29056>,
            
    /*5*/ <-3.1738,9.01163,-3.42348>,<-3.15435,8.98981,-3.46931>,<-3.12292,9.02246,-3.43928>,
            
    /*6*/ <-3.25037,9.23177,-3.59809>,<-3.23265,9.21044,-3.63392>,<-3.20707,9.23871,-3.60946>,
            
    /*7*/ <-3.33677,9.45657,-3.75338>,<-3.32352,9.44152,-3.78357>,<-3.30266,9.46339,-3.76355>,
            
    /*8*/ <-3.38634,9.69813,-3.90624>,<-3.37615,9.68657,-3.92863>,<-3.35986,9.70048,-3.9119>,
            
    /*9*/ <-3.41201,9.94898,-4.04728>,<-3.40521,9.94154,-4.06234>,<-3.39415,9.94941,-4.05034>,
            
    /*10*/ <-3.40413,10.19169,-4.2054>,<-3.40064,10.18716,-4.21243>,<-3.39514,10.19097,-4.20631>,
            
    /*11*/ <-3.41266,10.43621,-4.35749>

    /* stem 0.9.8.0*/ 
    /*0*/ <-2.75169,8.31051,-2.9034>,
    /*1*/ <-2.7461,8.29765,-2.92058>,<-2.75571,8.33209,-2.90655>,<-2.75325,8.30179,-2.88308>,
            
    /*2*/ <-3.82464,8.08428,-3.0831>

    /* stem 0.9.8.1*/ 
    /*0*/ <-2.91816,8.50818,-3.08044>,
    /*1*/ <-2.90993,8.52308,-3.06847>,<-2.93876,8.50727,-3.08323>,<-2.90579,8.49418,-3.08961>,
            
    /*2*/ <-2.83331,9.12528,-3.90745>

    /* stem 0.9.8.2*/ 
    /*0*/ <-3.00945,8.67988,-3.21611>,
    /*1*/ <-3.02643,8.67005,-3.21862>,<-3.00146,8.68984,-3.2312>,<-3.00047,8.67975,-3.19849>,
            
    /*2*/ <-3.51059,9.47842,-2.95473>

    /* stem 0.9.8.3*/ 
    /*0*/ <-3.12121,8.93779,-3.39825>,
    /*1*/ <-3.10474,8.93954,-3.40605>,<-3.12964,8.95247,-3.39129>,<-3.12924,8.92137,-3.3974>,
            
    /*2*/ <-3.51328,9.08869,-4.19177>

    /* stem 0.9.8.4*/ 
    /*0*/ <-3.17944,9.0879,-3.506>,
    /*1*/ <-3.18882,9.09463,-3.49292>,<-3.18624,9.08698,-3.52204>,<-3.16325,9.08209,-3.50304>,
            
    /*2*/ <-2.86975,9.86116,-3.68183>

    /* stem 0.9.8.5*/ 
    /*0*/ <-3.26957,9.32558,-3.68034>,
    /*1*/ <-3.27151,9.31613,-3.69319>,<-3.26119,9.33925,-3.6816>,<-3.27599,9.32137,-3.66621>,
            
    /*2*/ <-3.92129,9.70792,-3.86272>

    /* stem 0.9.8.6*/ 
    /*0*/ <-3.34691,9.57156,-3.83943>,
    /*1*/ <-3.33624,9.57847,-3.83203>,<-3.3604,9.57741,-3.84007>,<-3.34411,9.55879,-3.84618>,
            
    /*2*/ <-3.16754,9.92047,-4.42447>

    /* stem 0.9.8.7*/ 
    /*0*/ <-3.38581,9.79418,-3.96985>,
    /*1*/ <-3.39926,9.79272,-3.96963>,<-3.37954,9.79732,-3.98142>,<-3.37863,9.7925,-3.95851>,
            
    /*2*/ <-3.4515,10.4183,-3.83592>

    /* stem 0.9.8.8*/ 
    /*0*/ <-3.40121,10.11078,-4.1577>,
    /*1*/ <-3.3957,10.10846,-4.16121>,<-3.40167,10.11748,-4.15599>,<-3.40627,10.10639,-4.1559>,
            
    /*2*/ <-3.66122,10.21465,-4.63468>

    /* stem 0.9.8.9*/ 
    /*0*/ <-3.40886,10.36252,-4.31278>,
    /*1*/ <-3.4092,10.3633,-4.31146>,<-3.40975,10.36271,-4.31405>,<-3.40763,10.36156,-4.31282>,
            
    /*2*/ <-3.12742,10.72662,-4.45635>

    /* stem 0.9.9*/ 
    /*0*/ <-3.57294,8.46657,-3.67465>,
    /*1*/ <-3.55975,8.44588,-3.69413>,<-3.57061,8.49727,-3.68049>,<-3.58845,8.45657,-3.64932>,
            
    /*2*/ <-3.7616,8.4391,-3.81849>,<-3.77138,8.48535,-3.8062>,<-3.78743,8.44872,-3.77816>,
            
    /*3*/ <-3.97561,8.47023,-3.92686>,<-3.97727,8.51122,-3.91263>,<-3.99419,8.47922,-3.88865>,
            
    /*4*/ <-4.18441,8.58798,-3.98476>,<-4.17161,8.6193,-3.96748>,<-4.19173,8.59368,-3.94792>,
            
    /*5*/ <-4.35868,8.74372,-4.0376>,<-4.34308,8.76722,-4.02132>,<-4.36467,8.74832,-4.00592>,
            
    /*6*/ <-4.51538,8.9112,-4.09856>,<-4.50143,8.92979,-4.08455>,<-4.5212,8.91569,-4.07243>,
            
    /*7*/ <-4.64505,9.09863,-4.16622>,<-4.6326,9.11185,-4.15433>,<-4.65028,9.10279,-4.14557>,
            
    /*8*/ <-4.77211,9.29832,-4.1998>,<-4.7617,9.30672,-4.19052>,<-4.77469,9.29959,-4.18378>,
            
    /*9*/ <-4.88969,9.50593,-4.18363>,<-4.88181,9.51004,-4.1774>,<-4.89022,9.50492,-4.17283>,
            
    /*10*/ <-4.99619,9.71743,-4.16866>,<-4.99216,9.71932,-4.16556>,<-4.99648,9.71698,-4.16326>,
            
    /*11*/ <-5.10584,9.92337,-4.20744>

    /* stem 0.9.9.0*/ 
    /*0*/ <-3.67886,8.4619,-3.74136>,
    /*1*/ <-3.68034,8.47508,-3.73993>,<-3.68902,8.4537,-3.73858>,<-3.66722,8.45691,-3.74557>,
            
    /*2*/ <-3.96705,8.52392,-4.61133>

    /* stem 0.9.9.1*/ 
    /*0*/ <-3.86586,8.47063,-3.84891>,
    /*1*/ <-3.87013,8.45997,-3.84355>,<-3.86647,8.47208,-3.86147>,<-3.86098,8.47982,-3.8417>,
            
    /*2*/ <-4.6523,8.82565,-3.76922>

    /* stem 0.9.9.2*/ 
    /*0*/ <-4.25351,8.66299,-3.98924>,
    /*1*/ <-4.24804,8.66583,-3.99857>,<-4.25919,8.67074,-3.98352>,<-4.25329,8.65241,-3.98563>,
            
    /*2*/ <-4.87018,8.5112,-4.39665>

    /* stem 0.9.9.3*/ 
    /*0*/ <-4.46728,8.87102,-4.06683>,
    /*1*/ <-4.46817,8.87391,-4.0571>,<-4.47547,8.87098,-4.07289>,<-4.45822,8.86816,-4.07049>,
            
    /*2*/ <-4.33716,9.51438,-4.24627>

    /* stem 0.9.9.4*/ 
    /*0*/ <-4.57952,9.01432,-4.12128>,
    /*1*/ <-4.58392,9.0088,-4.12775>,<-4.57682,9.0232,-4.12362>,<-4.57784,9.01097,-4.11248>,
            
    /*2*/ <-5.14216,9.23628,-3.92868>

    /* stem 0.9.9.5*/ 
    /*0*/ <-4.69983,9.19328,-4.1716>,
    /*1*/ <-4.69249,9.19815,-4.1708>,<-4.70706,9.1954,-4.16697>,<-4.69993,9.1863,-4.17702>,
            
    /*2*/ <-4.87873,9.53438,-4.6072>

    /* stem 0.9.9.6*/ 
    /*0*/ <-4.95838,9.6463,-4.16994>,
    /*1*/ <-4.96139,9.64463,-4.16753>,<-4.95941,9.64833,-4.17347>,<-4.95435,9.64594,-4.16882>,
            
    /*2*/ <-4.98863,10.03662,-3.93673>

    /* stem 0.9.9.7*/ 
    /*0*/ <-5.03933,9.80015,-4.18248>,
    /*1*/ <-5.03875,9.8001,-4.18427>,<-5.03921,9.80174,-4.18149>,<-5.04004,9.7986,-4.18168>,
            
    /*2*/ <-5.41811,9.90793,-4.30882>

    /* stem 0.9.10*/ 
    /*0*/ <-3.95751,8.61766,-4.08622>,
    /*1*/ <-3.95521,8.63852,-4.07983>,<-3.97746,8.60853,-4.08692>,<-3.93987,8.60592,-4.09191>,
            
    /*2*/ <-3.97793,8.7011,-4.28347>,<-3.99795,8.67411,-4.28985>,<-3.96412,8.67176,-4.29435>,
            
    /*3*/ <-3.99409,8.82376,-4.45047>,<-4.01266,8.80361,-4.46366>,<-3.98262,8.80169,-4.46796>,
            
    /*4*/ <-4.0137,8.99085,-4.57479>,<-4.03054,8.97744,-4.59044>,<-4.00441,8.9768,-4.59539>,
            
    /*5*/ <-4.03458,9.17012,-4.68802>,<-4.04915,9.15973,-4.70215>,<-4.02679,9.15951,-4.70664>,
            
    /*6*/ <-4.0419,9.35688,-4.79085>,<-4.05412,9.34964,-4.80347>,<-4.03542,9.34861,-4.80668>,
            
    /*7*/ <-4.0426,9.55022,-4.88137>,<-4.05239,9.54538,-4.89194>,<-4.03742,9.5443,-4.89438>,
            
    /*8*/ <-4.05049,9.73085,-4.99861>,<-4.0578,9.72595,-5.00585>,<-4.04657,9.72523,-5.00772>,
            
    /*9*/ <-4.05167,9.91422,-5.10891>,<-4.05654,9.91124,-5.11393>,<-4.04905,9.91061,-5.11507>,
            
    /*10*/ <-4.06809,10.1092,-5.19496>,<-4.07054,10.10789,-5.19755>,<-4.06681,10.10788,-5.19829>,
            
    /*11*/ <-4.08085,10.30689,-5.2764>

    /* stem 0.9.10.0*/ 
    /*0*/ <-3.97029,8.65441,-4.20159>,
    /*1*/ <-3.97697,8.64803,-4.20288>,<-3.96315,8.65495,-4.20755>,<-3.97076,8.66024,-4.19433>,
            
    /*2*/ <-4.39624,9.19363,-4.66303>

    /* stem 0.9.10.1*/ 
    /*0*/ <-3.98805,8.74457,-4.37303>,
    /*1*/ <-3.97924,8.74526,-4.37337>,<-3.99309,8.75168,-4.37452>,<-3.99181,8.73678,-4.3712>,
            
    /*2*/ <-4.00413,8.57352,-5.13428>

    /* stem 0.9.10.2*/ 
    /*0*/ <-4.02922,9.09609,-4.65753>,
    /*1*/ <-4.03511,9.0982,-4.65302>,<-4.02996,9.09634,-4.6652>,<-4.0226,9.09371,-4.65437>,
            
    /*2*/ <-3.80274,9.72694,-4.65798>

    /* stem 0.9.10.3*/ 
    /*0*/ <-4.04094,9.27408,-4.7586>,
    /*1*/ <-4.0397,9.27076,-4.76486>,<-4.03712,9.27991,-4.75679>,<-4.04601,9.27158,-4.75414>,
            
    /*2*/ <-4.46276,9.63677,-5.03463>

    /* stem 0.9.10.4*/ 
    /*0*/ <-4.04405,9.49228,-4.86444>,
    /*1*/ <-4.04074,9.49465,-4.85926>,<-4.04921,9.4956,-4.86685>,<-4.04219,9.4866,-4.86722>,
            
    /*2*/ <-3.70146,9.77347,-5.21127>

    /* stem 0.9.10.5*/ 
    /*0*/ <-4.04685,9.61203,-4.93079>,
    /*1*/ <-4.0527,9.61071,-4.93249>,<-4.04288,9.61451,-4.93492>,<-4.04496,9.61089,-4.92495>,
            
    /*2*/ <-4.19883,10.09846,-4.78581>

    /* stem 0.9.10.6*/ 
    /*0*/ <-4.06005,10.00522,-5.15266>,
    /*1*/ <-4.05691,10.00498,-5.15382>,<-4.06097,10.0079,-5.15088>,<-4.06225,10.00279,-5.15328>,
            
    /*2*/ <-4.17608,10.20127,-5.50693>

    /* stem 0.9.10.7*/ 
    /*0*/ <-4.07636,10.23489,-5.24758>,
    /*1*/ <-4.07676,10.23512,-5.24693>,<-4.0766,10.23513,-5.2483>,<-4.07573,10.23441,-5.24751>,
            
    /*2*/ <-3.85985,10.52308,-5.22133>

    /* stem 0.10*/ 
    /*0*/ <-0.03096,8.0547,-0.20016>,
    /*1*/ <-0.05137,8.06556,-0.08567>,<-0.05378,8.1671,-0.17807>,<-0.02465,8.1133,-0.301>,
            <-0.00424,7.97852,-0.28457>,<-0.02075,7.94901,-0.15149>,
    /*2*/ <0.62436,8.17988,0.01261>,<0.62218,8.27177,-0.07101>,<0.64854,8.22308,-0.18226>,
            <0.66701,8.1011,-0.16739>,<0.65207,8.0744,-0.04695>,
    /*3*/ <1.29004,8.2581,0.15708>,<1.29707,8.34173,0.0841>,<1.32527,8.29894,-0.0146>,
            <1.33566,8.18886,-0.00264>,<1.31388,8.16361,0.10347>,
    /*4*/ <1.9585,8.36318,0.30206>,<1.96202,8.43664,0.23702>,<1.9883,8.39906,0.15022>,
            <2.00103,8.30239,0.16161>,<1.98261,8.28021,0.25545>,
    /*5*/ <2.64477,8.46044,0.39357>,<2.64426,8.52351,0.3364>,<2.6605,8.48983,0.25992>,
            <2.67105,8.40593,0.26983>,<2.66133,8.38777,0.35243>,
    /*6*/ <3.33983,8.4807,0.44545>,<3.34255,8.53432,0.39735>,<3.34936,8.50512,0.3318>,
            <3.35085,8.43345,0.33938>,<3.34496,8.41836,0.40962>,
    /*7*/ <4.02815,8.50991,0.50509>,<4.03025,8.55383,0.4657>,<4.03682,8.52997,0.41209>,
            <4.03876,8.47129,0.41836>,<4.0334,8.45889,0.47584>,
    /*8*/ <4.70605,8.55765,0.61542>,<4.70902,8.59199,0.58496>,<4.71774,8.57366,0.54368>,
            <4.72015,8.52799,0.54863>,<4.71292,8.5181,0.59297>,
    /*9*/ <5.38615,8.70358,0.64569>,<5.38237,8.72729,0.62312>,<5.38707,8.71388,0.59339>,
            <5.39376,8.68189,0.59758>,<5.39319,8.67552,0.62991>,
    /*10*/ <6.06559,8.84457,0.60096>,<6.06197,8.85858,0.58729>,<6.06287,8.85003,0.56933>,
            <6.06704,8.83074,0.5719>,<6.06872,8.82736,0.59145>,
    /*11*/ <6.71905,9.0687,0.56176>,<6.71723,9.07337,0.55708>,<6.71794,9.07054,0.55087>,
            <6.7202,9.06411,0.55171>,<6.72088,9.06297,0.55845>,
    /*12*/ <6.71906,9.06794,0.55597>

    /* stem 0.10c0*/ 
    /*0*/ <1.97849,8.3563,0.22127>,
    /*1*/ <1.98663,8.36194,0.3042>,<1.96095,8.43482,0.24364>,<1.95951,8.39919,0.15217>,
            <1.98431,8.30428,0.1562>,<2.00107,8.28126,0.25015>,
    /*2*/ <2.65195,8.53203,0.21616>,<2.62969,8.59523,0.16366>,<2.62844,8.56433,0.08434>,
            <2.64994,8.48203,0.08783>,<2.66447,8.46207,0.1693>,
    /*3*/ <3.32061,8.68754,0.11843>,<3.30232,8.74119,0.07389>,<3.29984,8.71465,0.00691>,
            <3.31659,8.64461,0.01006>,<3.32942,8.62786,0.07899>,
    /*4*/ <3.97481,8.89218,0.02497>,<3.95676,8.93528,-0.01112>,<3.95648,8.91404,-0.0662>,
            <3.97436,8.85781,-0.06416>,<3.98569,8.8443,-0.00781>,
    /*5*/ <4.61887,9.12172,-0.09506>,<4.60248,9.1545,-0.12286>,<4.60128,9.13759,-0.16562>,
            <4.61694,9.09436,-0.16425>,<4.62782,9.08455,-0.12065>,
    /*6*/ <5.27782,9.31313,-0.16173>,<5.26899,9.33758,-0.18197>,<5.26975,9.32603,-0.21283>,
            <5.27905,9.29444,-0.21165>,<5.28404,9.28646,-0.18007>,
    /*7*/ <5.89686,9.61599,-0.22498>,<5.88908,9.62982,-0.23701>,<5.8907,9.62329,-0.25575>,
            <5.89948,9.60543,-0.25531>,<5.90329,9.60092,-0.23629>,
    /*8*/ <6.50449,9.93964,-0.3012>,<6.50157,9.94428,-0.30532>,<6.50209,9.94201,-0.31178>,
            <6.50533,9.93596,-0.31165>,<6.50681,9.93449,-0.30511>,
    /*9*/ <6.50406,9.93928,-0.30701>

    /* stem 0.10c0c0*/ 
    /*0*/ <5.27593,9.31153,-0.18965>,
    /*1*/ <5.26061,9.31181,-0.16617>,<5.26413,9.33685,-0.18731>,<5.28395,9.32689,-0.21168>,
            <5.29269,9.29571,-0.2056>,<5.27827,9.28638,-0.17748>,
    /*2*/ <5.8166,9.5352,0.1807>,<5.81872,9.55032,0.16793>,<5.8307,9.54431,0.15321>,
            <5.83598,9.52547,0.15688>,<5.82726,9.51984,0.17387>,
    /*3*/ <6.3671,9.72765,0.55277>,<6.36815,9.73299,0.54858>,<6.37238,9.73096,0.54357>,
            <6.37395,9.72436,0.54466>,<6.37069,9.72232,0.55034>,
    /*4*/ <6.37045,9.72766,0.54798>

    /* stem 0.10c0c0.0*/ 
    /*0*/ <6.23401,9.6794,0.45241>,
    /*1*/ <6.22869,9.68222,0.45858>,<6.23978,9.68476,0.44891>,<6.23356,9.67121,0.44975>,
            
    /*2*/ <6.34571,9.63604,0.57946>,<6.35569,9.63832,0.57075>,<6.3501,9.62613,0.57151>,
            
    /*3*/ <6.44307,9.65019,0.721>,<6.45278,9.65177,0.71422>,<6.44953,9.64076,0.71752>,
            
    /*4*/ <6.54089,9.71342,0.85022>,<6.54889,9.71468,0.84361>,<6.5478,9.7057,0.84884>,
            
    /*5*/ <6.60733,9.83313,0.95634>,<6.61427,9.83425,0.95079>,<6.61472,9.82817,0.95736>,
            
    /*6*/ <6.66674,9.96115,1.05853>,<6.67257,9.96213,1.05396>,<6.67307,9.95735,1.05967>,
            
    /*7*/ <6.71155,10.09856,1.15561>,<6.71629,10.09952,1.15211>,<6.71678,10.09598,1.15689>,
            
    /*8*/ <6.7846,10.23669,1.23457>,<6.78785,10.23676,1.23149>,<6.78836,10.23435,1.23523>,
            
    /*9*/ <6.82104,10.38273,1.32167>,<6.82339,10.38322,1.3199>,<6.82372,10.38164,1.32241>,
            
    /*10*/ <6.88276,10.53772,1.37374>,<6.88383,10.53765,1.3727>,<6.88408,10.53709,1.37407>,
            
    /*11*/ <6.92094,10.69471,1.43924>

    /* stem 0.10c0c0.0.0*/ 
    /*0*/ <6.26987,9.66527,0.48982>,
    /*1*/ <6.27262,9.6665,0.48764>,<6.26999,9.66181,0.49118>,<6.26701,9.66749,0.49062>,
            
    /*2*/ <6.60319,9.89459,1.04252>

    /* stem 0.10c0c0.0.1*/ 
    /*0*/ <6.48377,9.67066,0.7647>,
    /*1*/ <6.48296,9.66808,0.76657>,<6.48405,9.67365,0.76605>,<6.4843,9.67026,0.76148>,
            
    /*2*/ <7.06366,9.56796,0.8738>

    /* stem 0.10c0c0.0.2*/ 
    /*0*/ <6.58849,9.78886,0.91658>,
    /*1*/ <6.58696,9.79101,0.9151>,<6.59143,9.78923,0.91719>,<6.58707,9.78632,0.91745>,
            
    /*2*/ <6.46002,10.02365,1.39168>

    /* stem 0.10c0c0.0.3*/ 
    /*0*/ <6.65541,9.92657,1.03051>,
    /*1*/ <6.65795,9.92539,1.03055>,<6.6544,9.92778,1.03283>,<6.6539,9.92656,1.02817>,
            
    /*2*/ <6.86077,10.36117,0.89477>

    /* stem 0.10c0c0.0.4*/ 
    /*0*/ <6.7353,10.13712,1.17723>,
    /*1*/ <6.7333,10.13734,1.17866>,<6.7362,10.13909,1.17606>,<6.73639,10.13492,1.17698>,
            
    /*2*/ <6.98956,10.22436,1.51892>

    /* stem 0.10c0c0.0.5*/ 
    /*0*/ <6.80632,10.31536,1.2812>,
    /*1*/ <6.80714,10.3162,1.27945>,<6.80734,10.31553,1.28305>,<6.80446,10.31433,1.28111>,
            
    /*2*/ <6.62249,10.64262,1.3525>

    /* stem 0.10c0c0.0.6*/ 
    /*0*/ <6.89744,10.59587,1.39792>,
    /*1*/ <6.89761,10.59564,1.39837>,<6.89708,10.59628,1.39794>,<6.89763,10.5957,1.39744>,
            
    /*2*/ <7.1252,10.79865,1.41559>

    /* stem 0.10c0.0*/ 
    /*0*/ <2.32299,8.44461,0.18146>,
    /*1*/ <2.30902,8.50266,0.18941>,<2.35289,8.42732,0.13212>,<2.30704,8.40386,0.22285>,
            
    /*2*/ <2.59824,8.54447,0.34639>,<2.63772,8.47666,0.29482>,<2.59646,8.45554,0.37647>,
            
    /*3*/ <2.84078,8.69732,0.471>,<2.89387,8.64425,0.43453>,<2.86454,8.62802,0.51097>,
            
    /*4*/ <3.09539,8.86292,0.60154>,<3.14279,8.81704,0.57024>,<3.1174,8.80317,0.63729>,
            
    /*5*/ <3.32082,9.07589,0.69677>,<3.36606,9.04053,0.67184>,<3.34892,9.03199,0.73143>,
            
    /*6*/ <3.50582,9.33549,0.75762>,<3.54769,9.31112,0.73829>,<3.53639,9.30725,0.78906>,
            
    /*7*/ <3.70507,9.59024,0.83765>,<3.73817,9.57008,0.82216>,<3.72787,9.56549,0.86234>,
            
    /*8*/ <3.91128,9.8491,0.85303>,<3.93445,9.832,0.84076>,<3.93064,9.83322,0.8718>,
            
    /*9*/ <4.10321,10.11677,0.88505>,<4.11948,10.10647,0.87703>,<4.1162,10.10636,0.89763>,
            
    /*10*/ <4.3144,10.37296,0.87122>,<4.3218,10.36686,0.86712>,<4.32111,10.36798,0.87747>,
            
    /*11*/ <4.46444,10.66683,0.89014>

    /* stem 0.10c0.0.0*/ 
    /*0*/ <2.51349,8.47612,0.28588>,
    /*1*/ <2.5252,8.46101,0.26908>,<2.52055,8.47584,0.31034>,<2.49472,8.49153,0.27823>,
            
    /*2*/ <3.36365,9.39549,0.0515>

    /* stem 0.10c0.0.1*/ 
    /*0*/ <2.68633,8.54077,0.37851>,
    /*1*/ <2.67557,8.53968,0.40055>,<2.69735,8.56147,0.37124>,<2.68607,8.52117,0.36374>,
            
    /*2*/ <3.73709,8.15488,0.87245>

    /* stem 0.10c0.0.2*/ 
    /*0*/ <2.95145,8.71427,0.51631>,
    /*1*/ <2.95206,8.72769,0.49758>,<2.97109,8.70734,0.52617>,<2.93119,8.70779,0.52518>,
            
    /*2*/ <2.94543,9.64167,1.18026>

    /* stem 0.10c0.0.3*/ 
    /*0*/ <3.22538,8.93222,0.64873>,
    /*1*/ <3.23698,8.91652,0.65751>,<3.22137,8.95006,0.65985>,<3.21779,8.93007,0.62884>,
            
    /*2*/ <4.10216,9.36682,0.2672>

    /* stem 0.10c0.0.4*/ 
    /*0*/ <3.40442,9.13546,0.71976>,
    /*1*/ <3.38774,9.14598,0.72393>,<3.41964,9.14421,0.70985>,<3.40588,9.11619,0.72549>,
            
    /*2*/ <3.79732,9.4196,1.57456>

    /* stem 0.10c0.0.5*/ 
    /*0*/ <3.48539,9.25316,0.74678>,
    /*1*/ <3.49687,9.24873,0.73164>,<3.49321,9.25621,0.76439>,<3.46609,9.25454,0.7443>,
            
    /*2*/ <3.57682,10.17512,0.54667>

    /* stem 0.10c0.0.6*/ 
    /*0*/ <3.59812,9.40848,0.78947>,
    /*1*/ <3.59609,9.40445,0.80755>,<3.59576,9.42597,0.7835>,<3.60252,9.39501,0.77736>,
            
    /*2*/ <4.47331,9.57291,0.92425>

    /* stem 0.10c0.0.7*/ 
    /*0*/ <3.84151,9.72875,0.84917>,
    /*1*/ <3.83273,9.73616,0.83692>,<3.85824,9.73018,0.84956>,<3.83356,9.71991,0.86103>,
            
    /*2*/ <3.77454,10.39089,1.29772>

    /* stem 0.10c0.0.8*/ 
    /*0*/ <4.01342,9.96559,0.86991>,
    /*1*/ <4.02576,9.95685,0.87184>,<4.01049,9.97691,0.8797>,<4.004,9.96302,0.8582>,
            
    /*2*/ <4.40364,10.42556,0.45502>

    /* stem 0.10c0.0.9*/ 
    /*0*/ <4.24225,10.27256,0.87739>,
    /*1*/ <4.23695,10.27702,0.88191>,<4.24507,10.27552,0.87021>,<4.24472,10.26513,0.88006>,
            
    /*2*/ <4.73355,10.54567,1.18323>

    /* stem 0.10c0.0.10*/ 
    /*0*/ <4.3875,10.50932,0.8805>,
    /*1*/ <4.38841,10.50906,0.87746>,<4.38953,10.51045,0.88268>,<4.38456,10.50844,0.88137>,
            
    /*2*/ <4.19915,11.04065,0.77906>

    /* stem 0.10c0.1*/ 
    /*0*/ <3.13664,8.64185,0.08059>,
    /*1*/ <3.14016,8.60437,0.04024>,<3.17194,8.64017,0.12297>,<3.09782,8.68102,0.07856>,
            
    /*2*/ <3.32882,8.78767,-0.10603>,<3.35743,8.81989,-0.03157>,<3.29072,8.85666,-0.07155>,
            
    /*3*/ <3.5192,8.9915,-0.23132>,<3.54018,9.01623,-0.16208>,<3.48126,9.04901,-0.19814>,
            
    /*4*/ <3.67046,9.2564,-0.30221>,<3.68129,9.26853,-0.23731>,<3.62605,9.29191,-0.26695>,
            
    /*5*/ <3.80301,9.51586,-0.37681>,<3.81315,9.5276,-0.3216>,<3.76451,9.54539,-0.34623>,
            
    /*6*/ <3.93454,9.77984,-0.44219>,<3.94229,9.78833,-0.39581>,<3.90188,9.80336,-0.41642>,
            
    /*7*/ <4.05854,10.05051,-0.49523>,<4.06407,10.05598,-0.4578>,<4.03157,10.06764,-0.47423>,
            
    /*8*/ <4.18435,10.30292,-0.59062>,<4.19043,10.31058,-0.56366>,<4.16557,10.3185,-0.57557>,
            
    /*9*/ <4.32198,10.56214,-0.66215>,<4.32523,10.56586,-0.64368>,<4.30918,10.57208,-0.65201>,
            
    /*10*/ <4.43184,10.82982,-0.74524>,<4.43368,10.83206,-0.73613>,<4.42523,10.83432,-0.74>,
            
    /*11*/ <4.55695,11.09282,-0.82118>

    /* stem 0.10c0.1.0*/ 
    /*0*/ <3.2439,8.74374,-0.0047>,
    /*1*/ <3.25444,8.7495,0.01544>,<3.23773,8.76049,-0.01992>,<3.23952,8.72124,-0.00963>,
            
    /*2*/ <4.28121,8.65541,-0.52254>

    /* stem 0.10c0.1.1*/ 
    /*0*/ <3.40927,8.9093,-0.12644>,
    /*1*/ <3.39285,8.91631,-0.13979>,<3.4295,8.90517,-0.13487>,<3.40547,8.90642,-0.10466>,
            
    /*2*/ <3.70073,9.95234,0.06252>

    /* stem 0.10c0.1.2*/ 
    /*0*/ <3.56395,9.10655,-0.22196>,
    /*1*/ <3.5821,9.09583,-0.22298>,<3.56378,9.12631,-0.21455>,<3.54598,9.09752,-0.22835>,
            
    /*2*/ <3.72289,9.46653,-1.17848>

    /* stem 0.10c0.1.3*/ 
    /*0*/ <3.70546,9.3608,-0.29613>,
    /*1*/ <3.69442,9.37062,-0.28299>,<3.71016,9.36926,-0.31338>,<3.71181,9.34253,-0.29203>,
            
    /*2*/ <4.50238,9.72659,0.10007>

    /* stem 0.10c0.1.4*/ 
    /*0*/ <3.88839,9.71609,-0.39819>,
    /*1*/ <3.88827,9.7115,-0.41553>,<3.90253,9.7247,-0.39129>,<3.87437,9.71206,-0.38776>,
            
    /*2*/ <3.52381,10.47308,-0.59611>

    /* stem 0.10c0.1.5*/ 
    /*0*/ <4.01384,9.97776,-0.45847>,
    /*1*/ <4.02337,9.97621,-0.44496>,<4.00813,9.9927,-0.46293>,<4.01002,9.96438,-0.46751>,
            
    /*2*/ <4.66029,10.09266,-0.90148>

    /* stem 0.10c0.1.6*/ 
    /*0*/ <4.13086,10.21399,-0.53802>,
    /*1*/ <4.11708,10.21941,-0.54204>,<4.14279,10.21555,-0.54754>,<4.13271,10.20702,-0.52448>,
            
    /*2*/ <4.29238,10.85188,-0.23176>

    /* stem 0.10c0.1.7*/ 
    /*0*/ <4.22131,10.38671,-0.59919>,
    /*1*/ <4.23226,10.37914,-0.60469>,<4.22388,10.39729,-0.58976>,<4.20778,10.38369,-0.60311>,
            
    /*2*/ <4.27065,10.8289,-1.10906>

    /* stem 0.10c0.1.8*/ 
    /*0*/ <4.35306,10.64829,-0.67962>,
    /*1*/ <4.35038,10.65209,-0.67153>,<4.35091,10.65247,-0.68769>,<4.35791,10.6403,-0.67964>,
            
    /*2*/ <4.86899,10.96088,-0.65532>

    /* stem 0.10c0.1.9*/ 
    /*0*/ <4.47005,10.91398,-0.76582>,
    /*1*/ <4.4688,10.9135,-0.76935>,<4.47372,10.91466,-0.76519>,<4.46764,10.91378,-0.76291>,
            
    /*2*/ <4.37981,11.43578,-0.80539>

    /* stem 0.10c0.2*/ 
    /*0*/ <3.52586,8.74965,0.03097>,
    /*1*/ <3.53131,8.75328,0.08329>,<3.53754,8.79093,0.00032>,<3.50874,8.70473,0.0093>,
            
    /*2*/ <3.80065,8.66048,0.05639>,<3.80626,8.69437,-0.01829>,<3.78034,8.61679,-0.01021>,
            
    /*3*/ <4.08383,8.65083,0.03381>,<4.08086,8.68221,-0.03211>,<4.07875,8.60941,-0.02617>,
            
    /*4*/ <4.34045,8.75907,0.05121>,<4.33484,8.78479,-0.00705>,<4.35865,8.72584,-0.00029>,
            
    /*5*/ <4.57251,8.92548,0.06359>,<4.5625,8.94468,0.01325>,<4.59397,8.90031,0.0199>,
            
    /*6*/ <4.77911,9.11486,0.10153>,<4.77237,9.13173,0.05963>,<4.80222,9.09777,0.06605>,
            
    /*7*/ <4.91919,9.35081,0.16774>,<4.91393,9.36409,0.13412>,<4.94371,9.34424,0.14147>,
            
    /*8*/ <5.03658,9.61033,0.20773>,<5.03106,9.61729,0.18181>,<5.05501,9.60551,0.18803>,
            
    /*9*/ <5.11223,9.88829,0.1946>,<5.1072,9.88912,0.17706>,<5.12437,9.88466,0.18144>,
            
    /*10*/ <5.12331,10.17148,0.21714>,<5.12086,10.17242,0.20839>,<5.1297,10.17189,0.21063>,
            
    /*11*/ <5.11948,10.44318,0.30289>

    /* stem 0.10c0.2.0*/ 
    /*0*/ <3.70214,8.68928,0.01681>,
    /*1*/ <3.70489,8.70163,-0.00155>,<3.7102,8.6685,0.01758>,<3.69132,8.6977,0.0344>,
            
    /*2*/ <4.65179,9.07245,0.41719>

    /* stem 0.10c0.2.1*/ 
    /*0*/ <3.92524,8.6528,0.00138>,
    /*1*/ <3.92487,8.6322,0.00676>,<3.94011,8.66567,0.00953>,<3.91074,8.66053,-0.01216>,
            
    /*2*/ <4.5565,8.43166,-0.80095>

    /* stem 0.10c0.2.2*/ 
    /*0*/ <4.17898,8.68798,0.0003>,
    /*1*/ <4.17134,8.70474,0.00844>,<4.19239,8.68927,-0.01466>,<4.17321,8.66994,0.00713>,
            
    /*2*/ <4.90907,8.70251,0.65621>

    /* stem 0.10c0.2.3*/ 
    /*0*/ <4.50289,8.87058,0.02666>,
    /*1*/ <4.50861,8.86437,0.01024>,<4.51479,8.87182,0.04072>,<4.48526,8.87554,0.02903>,
            
    /*2*/ <4.70476,9.70379,-0.2178>

    /* stem 0.10c0.2.4*/ 
    /*0*/ <4.69572,9.03317,0.05718>,
    /*1*/ <4.69622,9.02881,0.07394>,<4.69662,9.04983,0.05253>,<4.69431,9.02086,0.04507>,
            
    /*2*/ <5.52326,8.97729,0.01777>

    /* stem 0.10c0.2.5*/ 
    /*0*/ <4.82285,9.17945,0.09529>,
    /*1*/ <4.81376,9.18805,0.08466>,<4.8392,9.18088,0.09513>,<4.81559,9.16943,0.10608>,
            
    /*2*/ <4.7765,9.76692,0.61001>

    /* stem 0.10c0.2.6*/ 
    /*0*/ <4.9851,9.48618,0.17087>,
    /*1*/ <4.99853,9.48003,0.17171>,<4.98025,9.4949,0.1818>,<4.97651,9.48361,0.1591>,
            
    /*2*/ <5.25898,10.04088,-0.15017>

    /* stem 0.10c0.2.7*/ 
    /*0*/ <5.07,9.72019,0.1893>,
    /*1*/ <5.05942,9.72325,0.19734>,<5.07244,9.72761,0.17812>,<5.07814,9.70971,0.19244>,
            
    /*2*/ <5.44099,10.11023,0.5292>

    /* stem 0.10c0.2.8*/ 
    /*0*/ <5.12008,10.04294,0.1995>,
    /*1*/ <5.12199,10.04359,0.19211>,<5.12329,10.04756,0.20471>,<5.11496,10.03768,0.20169>,
            
    /*2*/ <4.70888,10.41219,0.12591>

    /* stem 0.10c0.2.9*/ 
    /*0*/ <5.121,10.36268,0.27593>,
    /*1*/ <5.12168,10.36225,0.27728>,<5.1199,10.3638,0.27594>,<5.12143,10.36201,0.27459>,
            
    /*2*/ <5.45796,10.6964,0.21509>

    /* stem 0.10c0.3*/ 
    /*0*/ <4.12234,8.94324,-0.05068>,
    /*1*/ <4.1069,8.96903,-0.08757>,<4.15199,8.90671,-0.05792>,<4.10815,8.95397,-0.00654>,
            
    /*2*/ <4.31421,9.12811,-0.057>,<4.35478,9.07202,-0.03031>,<4.31533,9.11455,0.01593>,
            
    /*3*/ <4.49514,9.31143,-0.03303>,<4.5378,9.2675,-0.00856>,<4.49831,9.30126,0.03205>,
            
    /*4*/ <4.65902,9.512,-0.02404>,<4.70054,9.47821,-0.00251>,<4.66462,9.50602,0.03308>,
            
    /*5*/ <4.81245,9.72418,0.01699>,<4.84821,9.69567,0.03582>,<4.81363,9.71485,0.06554>,
            
    /*6*/ <4.94407,9.94473,0.00538>,<4.97744,9.9263,0.02102>,<4.95,9.94401,0.04616>,
            
    /*7*/ <5.07046,10.1735,-0.01355>,<5.09786,10.15998,-0.00117>,<5.07577,10.17386,0.01899>,
            
    /*8*/ <5.21743,10.39321,-0.02438>,<5.23682,10.38116,-0.01488>,<5.22082,10.3926,0.0001>,
            
    /*9*/ <5.38972,10.59214,-0.04287>,<5.40164,10.58275,-0.03641>,<5.39212,10.59192,-0.02656>,
            
    /*10*/ <5.5466,10.80232,-0.05874>,<5.55288,10.79803,-0.05555>,<5.5478,10.8022,-0.05058>,
            
    /*11*/ <5.67976,11.02795,-0.07834>

    /* stem 0.10c0.3.0*/ 
    /*0*/ <4.28297,9.06943,-0.02969>,
    /*1*/ <4.29477,9.05377,-0.02583>,<4.28263,9.08501,-0.01718>,<4.27151,9.06951,-0.04606>,
            
    /*2*/ <5.0256,9.50136,-0.54715>

    /* stem 0.10c0.3.1*/ 
    /*0*/ <4.3943,9.17333,-0.01631>,
    /*1*/ <4.38156,9.18466,-0.00722>,<4.40546,9.18063,-0.03029>,<4.39587,9.15471,-0.01142>,
            
    /*2*/ <5.06571,9.4023,0.63959>

    /* stem 0.10c0.3.2*/ 
    /*0*/ <4.62576,9.43754,0.00058>,
    /*1*/ <4.63115,9.43366,-0.01592>,<4.63772,9.44146,0.01316>,<4.6084,9.43751,0.0045>,
            
    /*2*/ <4.57497,10.2904,-0.21691>

    /* stem 0.10c0.3.3*/ 
    /*0*/ <4.74056,9.59213,0.01853>,
    /*1*/ <4.74337,9.58734,0.03454>,<4.73522,9.60786,0.01521>,<4.74309,9.58118,0.00584>,
            
    /*2*/ <5.53301,9.84801,-0.04426>

    /* stem 0.10c0.3.4*/ 
    /*0*/ <4.86519,9.78082,0.03479>,
    /*1*/ <4.85331,9.78718,0.02627>,<4.88016,9.78149,0.02934>,<4.86211,9.77378,0.04876>,
            
    /*2*/ <4.96802,10.46239,0.4007>

    /* stem 0.10c0.3.5*/ 
    /*0*/ <5.15432,10.28077,-0.00593>,
    /*1*/ <5.16536,10.27345,-0.00764>,<5.15463,10.29161,0.00189>,<5.14296,10.27727,-0.01203>,
            
    /*2*/ <5.31493,10.64092,-0.51171>

    /* stem 0.10c0.3.6*/ 
    /*0*/ <5.28794,10.46322,-0.0213>,
    /*1*/ <5.28199,10.46925,-0.01233>,<5.28995,10.46872,-0.03216>,<5.29187,10.45168,-0.01942>,
            
    /*2*/ <5.79951,10.67004,0.17843>

    /* stem 0.10c0.3.7*/ 
    /*0*/ <5.46715,10.68852,-0.04453>,
    /*1*/ <5.46712,10.68787,-0.05178>,<5.4733,10.69029,-0.04106>,<5.46103,10.68741,-0.04074>,
            
    /*2*/ <5.34834,11.19021,-0.08897>

    /* stem 0.10c0.3.8*/ 
    /*0*/ <5.59991,10.88917,-0.06405>,
    /*1*/ <5.60155,10.88846,-0.06176>,<5.59886,10.89187,-0.06431>,<5.59931,10.88718,-0.06608>,
            
    /*2*/ <5.9765,11.01296,-0.29633>

    /* stem 0.10c0.4*/ 
    /*0*/ <4.49257,9.07539,-0.11325>,
    /*1*/ <4.50737,9.03783,-0.10498>,<4.50385,9.10755,-0.09008>,<4.46648,9.08079,-0.14469>,
            
    /*2*/ <4.6979,9.08378,-0.25789>,<4.69473,9.14653,-0.24448>,<4.66109,9.12245,-0.29363>,
            
    /*3*/ <4.89491,9.18261,-0.38529>,<4.88154,9.23495,-0.36678>,<4.85959,9.21552,-0.41579>,
            
    /*4*/ <5.04474,9.34681,-0.51812>,<5.02391,9.38556,-0.49442>,<5.00425,9.36897,-0.53726>,
            
    /*5*/ <5.17969,9.52701,-0.62918>,<5.15912,9.55709,-0.60669>,<5.14406,9.54485,-0.64487>,
            
    /*6*/ <5.29066,9.72366,-0.73976>,<5.27194,9.74626,-0.71944>,<5.25904,9.73579,-0.75103>,
            
    /*7*/ <5.37087,9.94701,-0.82502>,<5.35374,9.96058,-0.80665>,<5.3443,9.95401,-0.83278>,
            
    /*8*/ <5.47264,10.16982,-0.86337>,<5.45918,10.17874,-0.84931>,<5.45383,10.17761,-0.87001>,
            
    /*9*/ <5.59907,10.37705,-0.90943>,<5.59085,10.38433,-0.9003>,<5.58721,10.3835,-0.91408>,
            
    /*10*/ <5.71059,10.59983,-0.92232>,<5.70593,10.60255,-0.91765>,<5.70454,10.60283,-0.92465>,
            
    /*11*/ <5.82703,10.81543,-0.96285>

    /* stem 0.10c0.4.0*/ 
    /*0*/ <4.56826,9.09202,-0.17321>,
    /*1*/ <4.56935,9.10863,-0.16723>,<4.5708,9.08862,-0.19037>,<4.56464,9.07882,-0.16202>,
            
    /*2*/ <5.51719,8.97081,-0.00879>

    /* stem 0.10c0.4.1*/ 
    /*0*/ <4.82647,9.1859,-0.35595>,
    /*1*/ <4.82168,9.17796,-0.36944>,<4.84237,9.18673,-0.35216>,<4.81536,9.193,-0.34625>,
            
    /*2*/ <4.8989,9.93982,-0.82509>

    /* stem 0.10c0.4.2*/ 
    /*0*/ <4.97301,9.31214,-0.47176>,
    /*1*/ <4.98375,9.31114,-0.46068>,<4.97051,9.32561,-0.47892>,<4.96476,9.29966,-0.47566>,
            
    /*2*/ <5.54676,9.11274,-1.04651>

    /* stem 0.10c0.4.3*/ 
    /*0*/ <5.09741,9.46121,-0.57562>,
    /*1*/ <5.08528,9.46863,-0.5788>,<5.10827,9.46048,-0.58531>,<5.09868,9.4545,-0.56273>,
            
    /*2*/ <5.41372,10.10919,-0.26961>

    /* stem 0.10c0.4.4*/ 
    /*0*/ <5.2143,9.6338,-0.6788>,
    /*1*/ <5.22305,9.62524,-0.6848>,<5.21879,9.64556,-0.67354>,<5.20106,9.63062,-0.67806>,
            
    /*2*/ <5.09923,9.96329,-1.317>

    /* stem 0.10c0.4.5*/ 
    /*0*/ <5.39534,10.03578,-0.83606>,
    /*1*/ <5.39278,10.03895,-0.82508>,<5.39236,10.04272,-0.84501>,<5.40089,10.02566,-0.83809>,
            
    /*2*/ <5.93632,10.32347,-0.79309>

    /* stem 0.10c0.4.6*/ 
    /*0*/ <5.55391,10.32082,-0.89407>,
    /*1*/ <5.5502,10.32119,-0.90276>,<5.5632,10.32205,-0.89284>,<5.54832,10.31923,-0.88661>,
            
    /*2*/ <5.47735,10.84704,-0.83937>

    /* stem 0.10c0.4.7*/ 
    /*0*/ <5.64383,10.48042,-0.91404>,
    /*1*/ <5.64887,10.47799,-0.91095>,<5.64096,10.48568,-0.91183>,<5.64167,10.47759,-0.91935>,
            
    /*2*/ <5.94411,10.75812,-1.18425>

    /* stem 0.10c0.4.8*/ 
    /*0*/ <5.78668,10.74359,-0.94896>,
    /*1*/ <5.78552,10.74429,-0.9487>,<5.78743,10.74388,-0.95009>,<5.7871,10.74259,-0.94809>,
            
    /*2*/ <6.00553,11.02414,-0.73012>

    /* stem 0.10c0.5*/ 
    /*0*/ <4.79209,9.17058,-0.14878>,
    /*1*/ <4.78448,9.20161,-0.1319>,<4.80219,9.17089,-0.18347>,<4.78962,9.13924,-0.13096>,
            
    /*2*/ <5.01199,9.21817,-0.06746>,<5.02792,9.19052,-0.11388>,<5.01661,9.16204,-0.06662>,
            
    /*3*/ <5.19648,9.3289,-0.00374>,<5.2224,9.30791,-0.04108>,<5.22014,9.28539,0.00359>,
            
    /*4*/ <5.37561,9.47295,0.04071>,<5.39875,9.45518,0.00802>,<5.40189,9.43877,0.04852>,
            
    /*5*/ <5.5261,9.65182,0.04637>,<5.54576,9.6368,0.01812>,<5.55447,9.62832,0.05365>,
            
    /*6*/ <5.64527,9.85192,0.06204>,<5.66415,9.84296,0.03874>,<5.67158,9.8362,0.06838>,
            
    /*7*/ <5.75193,10.06053,0.08754>,<5.76792,10.05498,0.0691>,<5.77362,10.04918,0.09277>,
            
    /*8*/ <5.88962,10.25588,0.09866>,<5.90027,10.24946,0.08459>,<5.9047,10.24533,0.10237>,
            
    /*9*/ <5.97257,10.47498,0.08184>,<5.98009,10.47158,0.07242>,<5.98417,10.47093,0.08424>,
            
    /*10*/ <6.04888,10.6983,0.06195>,<6.05266,10.69667,0.05724>,<6.05475,10.69649,0.06314>,
            
    /*11*/ <6.13154,10.9121,0.00028>

    /* stem 0.10c0.5.0*/ 
    /*0*/ <4.89656,9.17964,-0.11831>,
    /*1*/ <4.90104,9.1745,-0.13217>,<4.90388,9.17489,-0.10557>,<4.88474,9.18953,-0.1172>,
            
    /*2*/ <5.48215,9.88781,-0.19138>

    /* stem 0.10c0.5.1*/ 
    /*0*/ <5.08067,9.22755,-0.06071>,
    /*1*/ <5.07855,9.22293,-0.0469>,<5.08315,9.24179,-0.0634>,<5.08029,9.21792,-0.07182>,
            
    /*2*/ <5.93906,9.0941,0.02619>

    /* stem 0.10c0.5.2*/ 
    /*0*/ <5.47363,9.55529,0.0362>,
    /*1*/ <5.46635,9.56157,0.02779>,<5.48612,9.5538,0.03397>,<5.46843,9.55051,0.04684>,
            
    /*2*/ <5.61402,10.19581,0.3929>

    /* stem 0.10c0.5.3*/ 
    /*0*/ <5.57246,9.69154,0.04374>,
    /*1*/ <5.58297,9.68544,0.04411>,<5.57074,9.70111,0.05103>,<5.56369,9.68806,0.0361>,
            
    /*2*/ <5.83687,10.1174,-0.45327>

    /* stem 0.10c0.5.4*/ 
    /*0*/ <5.70859,9.94154,0.06878>,
    /*1*/ <5.7004,9.94472,0.07554>,<5.71216,9.94837,0.06081>,<5.7132,9.93154,0.06999>,
            
    /*2*/ <6.13675,10.18752,0.47162>

    /* stem 0.10c0.5.5*/ 
    /*0*/ <5.83223,10.15386,0.08925>,
    /*1*/ <5.83417,10.15314,0.07932>,<5.83971,10.1561,0.09573>,<5.82281,10.15233,0.0927>,
            
    /*2*/ <5.71809,10.7169,0.02641>

    /* stem 0.10c0.5.6*/ 
    /*0*/ <6.02079,10.601,0.06879>,
    /*1*/ <6.02328,10.60056,0.07328>,<6.01749,10.6049,0.06804>,<6.02159,10.59754,0.06504>,
            
    /*2*/ <6.36393,10.85973,-0.09649>

    /* stem 0.10c0.5.7*/ 
    /*0*/ <6.09243,10.80629,0.03006>,
    /*1*/ <6.09082,10.80671,0.02944>,<6.09389,10.80687,0.02922>,<6.09259,10.80529,0.03152>,
            
    /*2*/ <6.09117,11.14204,0.26048>

    /* stem 0.10c0.6*/ 
    /*0*/ <6.17039,9.76142,-0.27127>,
    /*1*/ <6.17149,9.75713,-0.28235>,<6.17855,9.75872,-0.263>,<6.16113,9.7684,-0.26847>,
            
    /*2*/ <6.2678,9.90448,-0.32853>,<6.27416,9.90591,-0.31111>,<6.25848,9.91461,-0.31603>,
            
    /*3*/ <6.32198,10.07046,-0.38086>,<6.3284,10.07318,-0.36587>,<6.31271,10.07732,-0.36902>,
            
    /*4*/ <6.37661,10.22233,-0.46132>,<6.38296,10.22663,-0.44906>,<6.3692,10.23018,-0.4517>,
            
    /*5*/ <6.39672,10.39409,-0.52202>,<6.40208,10.39732,-0.51132>,<6.38979,10.39828,-0.51264>,
            
    /*6*/ <6.43752,10.56441,-0.57253>,<6.4418,10.56619,-0.5633>,<6.43177,10.56814,-0.5648>,
            
    /*7*/ <6.48167,10.73702,-0.61141>,<6.48495,10.73793,-0.60388>,<6.47698,10.73968,-0.60515>,
            
    /*8*/ <6.5476,10.89917,-0.65983>,<6.55008,10.89989,-0.65419>,<6.54433,10.90189,-0.65532>,
            
    /*9*/ <6.61614,11.06184,-0.70441>,<6.61775,11.06222,-0.70062>,<6.61394,11.06362,-0.7014>,
            
    /*10*/ <6.69591,11.22157,-0.7401>,<6.69666,11.22164,-0.73817>,<6.69481,11.22246,-0.7386>,
            
    /*11*/ <6.79962,11.36822,-0.76935>

    /* stem 0.10c0.6.0*/ 
    /*0*/ <6.20458,9.8135,-0.28804>,
    /*1*/ <6.20699,9.81337,-0.28351>,<6.20317,9.818,-0.29006>,<6.20356,9.80914,-0.29053>,
            
    /*2*/ <6.83213,9.85828,-0.62232>

    /* stem 0.10c0.6.1*/ 
    /*0*/ <6.33677,10.11717,-0.39531>,
    /*1*/ <6.33251,10.11789,-0.39683>,<6.34035,10.11804,-0.39803>,<6.33745,10.11557,-0.39107>,
            
    /*2*/ <6.35891,10.70556,-0.17657>

    /* stem 0.10c0.6.2*/ 
    /*0*/ <6.38377,10.29051,-0.47712>,
    /*1*/ <6.38759,10.28948,-0.47873>,<6.3833,10.2941,-0.47487>,<6.38043,10.28794,-0.47777>,
            
    /*2*/ <6.25663,10.57889,-0.96455>

    /* stem 0.10c0.6.3*/ 
    /*0*/ <6.41382,10.4698,-0.53758>,
    /*1*/ <6.4122,10.4712,-0.53425>,<6.41317,10.47164,-0.54102>,<6.41609,10.46656,-0.53746>,
            
    /*2*/ <6.84517,10.77446,-0.45586>

    /* stem 0.10c0.6.4*/ 
    /*0*/ <6.52918,10.85582,-0.64282>,
    /*1*/ <6.52837,10.8552,-0.64594>,<6.53221,10.85687,-0.64209>,<6.52697,10.8554,-0.64043>,
            
    /*2*/ <6.39834,11.26703,-0.69086>

    /* stem 0.10c0.6.5*/ 
    /*0*/ <6.59496,11.01294,-0.68817>,
    /*1*/ <6.59704,11.01255,-0.68642>,<6.59391,11.01546,-0.68852>,<6.59393,11.01081,-0.68957>,
            
    /*2*/ <6.85061,11.07935,-0.97766>

    /* stem 0.10c0.6.6*/ 
    /*0*/ <6.76118,11.31405,-0.7581>,
    /*1*/ <6.76082,11.3143,-0.75813>,<6.76153,11.31412,-0.75836>,<6.7612,11.31372,-0.7578>,
            
    /*2*/ <6.87832,11.50779,-0.55024>

    /* stem 0.10c1*/ 
    /*0*/ <4.03348,8.50478,0.45542>,
    /*1*/ <4.00621,8.50926,0.49736>,<4.02178,8.55328,0.46122>,<4.05351,8.53027,0.41706>,
            <4.05755,8.47203,0.42591>,<4.02832,8.45905,0.47554>,
    /*2*/ <4.59169,8.60414,0.85451>,<4.60382,8.63843,0.82635>,<4.62854,8.62051,0.79195>,
            <4.63168,8.57514,0.79885>,<4.60891,8.56502,0.83751>,
    /*3*/ <5.20087,8.76149,1.15115>,<5.20593,8.78524,1.12887>,<5.22227,8.77206,1.10347>,
            <5.22731,8.74017,1.11005>,<5.21409,8.73363,1.13952>,
    /*4*/ <5.80103,8.93323,1.44987>,<5.8039,8.94753,1.43631>,<5.81407,8.93965,1.42112>,
            <5.81748,8.92048,1.42528>,<5.80942,8.91651,1.44304>,
    /*5*/ <6.42577,9.12864,1.68047>,<6.42618,9.13339,1.67553>,<6.4292,9.13052,1.67007>,
            <6.43066,9.124,1.67165>,<6.42854,9.12284,1.67807>,
    /*6*/ <6.42807,9.12788,1.67516>

    /* stem 0.10c1.0*/ 
    /*0*/ <4.85653,8.66462,0.94534>,
    /*1*/ <4.86564,8.68335,0.91767>,<4.87827,8.64086,0.95808>,<4.82569,8.66964,0.96026>,
            
    /*2*/ <4.95886,8.84284,1.06067>,<4.97023,8.8046,1.09704>,<4.9229,8.8305,1.099>,
            
    /*3*/ <5.04284,9.01792,1.18554>,<5.05498,8.98772,1.2208>,<5.01172,9.00849,1.22083>,
            
    /*4*/ <5.1645,9.18503,1.28817>,<5.1757,9.1587,1.3189>,<5.14083,9.18178,1.3227>,
            
    /*5*/ <5.26299,9.37748,1.36934>,<5.27547,9.35955,1.39794>,<5.24323,9.37549,1.39935>,
            
    /*6*/ <5.36718,9.57394,1.43626>,<5.37829,9.56024,1.46051>,<5.35163,9.5739,1.46191>,
            
    /*7*/ <5.4652,9.7704,1.51952>,<5.47353,9.75851,1.53862>,<5.45193,9.76893,1.53945>,
            
    /*8*/ <5.52455,9.96841,1.63233>,<5.5304,9.9589,1.64644>,<5.51327,9.96439,1.64576>,
            
    /*9*/ <5.60889,10.17517,1.69204>,<5.61349,10.17055,1.70211>,<5.60238,10.17508,1.70211>,
            
    /*10*/ <5.68505,10.39001,1.74167>,<5.68749,10.38805,1.74679>,<5.68184,10.39007,1.74673>,
            
    /*11*/ <5.73675,10.60318,1.82349>

    /* stem 0.10c1.0.0*/ 
    /*0*/ <4.90842,8.75357,1.02264>,
    /*1*/ <4.91376,8.74293,1.03131>,<4.90349,8.76612,1.02857>,<4.90802,8.75167,1.00804>,
            
    /*2*/ <5.73521,9.11109,0.95316>

    /* stem 0.10c1.0.1*/ 
    /*0*/ <4.9801,8.88726,1.12791>,
    /*1*/ <4.96816,8.89442,1.12584>,<4.99246,8.89304,1.12447>,<4.97967,8.87431,1.13342>,
            
    /*2*/ <5.04376,9.22103,1.91693>

    /* stem 0.10c1.0.2*/ 
    /*0*/ <5.19127,9.23556,1.33429>,
    /*1*/ <5.20165,9.23277,1.32802>,<5.19201,9.23992,1.34592>,<5.18015,9.23398,1.32893>,
            
    /*2*/ <5.21936,9.93563,1.06988>

    /* stem 0.10c1.0.3*/ 
    /*0*/ <5.32911,9.50027,1.43061>,
    /*1*/ <5.32477,9.49922,1.441>,<5.32899,9.51032,1.42542>,<5.33357,9.49128,1.42542>,
            
    /*2*/ <5.9307,9.64488,1.6968>

    /* stem 0.10c1.0.4*/ 
    /*0*/ <5.42807,9.69467,1.50365>,
    /*1*/ <5.42602,9.69938,1.49454>,<5.4377,9.69515,1.50775>,<5.4205,9.68947,1.50868>,
            
    /*2*/ <5.27364,10.21154,1.80583>

    /* stem 0.10c1.0.5*/ 
    /*0*/ <5.50571,9.90693,1.61014>,
    /*1*/ <5.51274,9.90233,1.61467>,<5.50075,9.91372,1.61467>,<5.50362,9.90473,1.60109>,
            
    /*2*/ <5.87024,10.29059,1.43309>

    /* stem 0.10c1.0.6*/ 
    /*0*/ <5.66266,10.327,1.73167>,
    /*1*/ <5.65846,10.32833,1.73239>,<5.66525,10.32922,1.7288>,<5.66427,10.32344,1.73383>,
            
    /*2*/ <5.80335,10.59086,2.06259>

    /* stem 0.10c1.0.7*/ 
    /*0*/ <5.7121,10.50176,1.78628>,
    /*1*/ <5.71327,10.50189,1.78514>,<5.71239,10.50227,1.78782>,<5.71064,10.50111,1.78589>,
            
    /*2*/ <5.57696,10.86625,1.69062>

    /* stem 0.10c1.1*/ 
    /*0*/ <6.00689,8.99422,1.51181>,
    /*1*/ <6.00878,8.982,1.51694>,<6.00761,9.005,1.51972>,<6.00429,8.99567,1.49875>,
            
    /*2*/ <6.19011,8.9966,1.48167>,<6.18907,9.0173,1.48417>,<6.18607,9.0089,1.46529>,
            
    /*3*/ <6.36175,9.06685,1.44708>,<6.35547,9.084,1.45036>,<6.35488,9.07703,1.43317>,
            
    /*4*/ <6.51841,9.16366,1.41526>,<6.51064,9.17751,1.41859>,<6.51103,9.17189,1.40337>,
            
    /*5*/ <6.65758,9.28682,1.39846>,<6.64887,9.29721,1.40156>,<6.65067,9.29337,1.38831>,
            
    /*6*/ <6.79476,9.41084,1.406>,<6.78714,9.41922,1.40849>,<6.78983,9.41692,1.39744>,
            
    /*7*/ <6.91041,9.55614,1.42053>,<6.90324,9.56172,1.4224>,<6.90596,9.56044,1.41362>,
            
    /*8*/ <7.01632,9.70816,1.43242>,<7.01069,9.71202,1.4338>,<7.01276,9.7111,1.42722>,
            
    /*9*/ <7.11317,9.8649,1.45358>,<7.10926,9.86723,1.45446>,<7.11081,9.86686,1.45011>,
            
    /*10*/ <7.17858,10.03623,1.483>,<7.17643,10.037,1.48337>,<7.17732,10.03703,1.48123>,
            
    /*11*/ <7.23017,10.20988,1.52237>

    /* stem 0.10c1.1.0*/ 
    /*0*/ <6.10454,9.00142,1.49311>,
    /*1*/ <6.10445,9.00688,1.49474>,<6.10666,9.00001,1.48801>,<6.1025,8.99737,1.49657>,
            
    /*2*/ <6.75498,8.92432,1.78553>

    /* stem 0.10c1.1.1*/ 
    /*0*/ <6.43286,9.12197,1.42847>,
    /*1*/ <6.43346,9.11954,1.42405>,<6.43672,9.12223,1.43176>,<6.42841,9.12413,1.4296>,
            
    /*2*/ <6.62582,9.65905,1.15983>

    /* stem 0.10c1.1.2*/ 
    /*0*/ <6.57003,9.22053,1.40576>,
    /*1*/ <6.57105,9.21999,1.4104>,<6.56958,9.22491,1.40391>,<6.56947,9.21669,1.40298>,
            
    /*2*/ <7.14626,9.22754,1.28072>

    /* stem 0.10c1.1.3*/ 
    /*0*/ <6.74876,9.37839,1.4016>,
    /*1*/ <6.74655,9.38104,1.39894>,<6.75297,9.37755,1.40083>,<6.74677,9.37658,1.40502>,
            
    /*2*/ <6.88692,9.79506,1.7027>

    /* stem 0.10c1.1.4*/ 
    /*0*/ <6.96152,9.63723,1.42519>,
    /*1*/ <6.96459,9.63506,1.42509>,<6.96115,9.63986,1.42784>,<6.95881,9.63676,1.42262>,
            
    /*2*/ <7.16482,9.93741,1.15614>

    /* stem 0.10c1.1.5*/ 
    /*0*/ <7.04491,9.76087,1.43813>,
    /*1*/ <7.04254,9.76205,1.4404>,<7.04605,9.76295,1.43557>,<7.04614,9.75762,1.43841>,
            
    /*2*/ <7.34962,9.89789,1.68519>

    /* stem 0.10c1.1.6*/ 
    /*0*/ <7.20279,10.11999,1.50168>,
    /*1*/ <7.20297,10.12009,1.50102>,<7.20326,10.12012,1.50219>,<7.20216,10.11976,1.50184>,
            
    /*2*/ <7.10044,10.4222,1.51976>

    /* stem 0.10c2*/ 
    /*0*/ <5.38851,8.70043,0.61794>,
    /*1*/ <5.36592,8.70363,0.63422>,<5.37995,8.72704,0.61576>,<5.40581,8.71367,0.6003>,
            <5.40776,8.68201,0.60922>,<5.3831,8.6758,0.63019>,
    /*2*/ <5.78268,8.87707,1.15917>,<5.79116,8.89121,1.14801>,<5.80678,8.88314,1.13868>,
            <5.80795,8.86401,1.14407>,<5.79306,8.86026,1.15673>,
    /*3*/ <6.19933,9.13196,1.65021>,<6.2018,9.1366,1.6458>,<6.20729,9.13386,1.64271>,
            <6.20821,9.12754,1.64521>,<6.20329,9.12636,1.64985>,
    /*4*/ <6.20398,9.13126,1.64676>

    /* stem 0.10.0*/ 
    /*0*/ <0.24866,8.10256,-0.15486>,
    /*1*/ <0.25145,8.14336,-0.21519>,<0.29407,8.04612,-0.1469>,<0.20045,8.11821,-0.10249>,
            
    /*2*/ <0.52566,8.38541,-0.03004>,<0.56403,8.2979,0.03142>,<0.47977,8.36278,0.07139>,
            
    /*3*/ <0.76935,8.65453,0.15566>,<0.80798,8.5817,0.21398>,<0.72704,8.63357,0.24492>,
            
    /*4*/ <0.93827,8.9883,0.29658>,<0.98351,8.94151,0.35633>,<0.90372,8.97362,0.37657>,
            
    /*5*/ <1.11922,9.3072,0.49571>,<1.1535,9.25939,0.54341>,<1.08523,9.28742,0.56044>,
            
    /*6*/ <1.35009,9.59815,0.66666>,<1.3773,9.55564,0.70454>,<1.32524,9.58594,0.72338>,
            
    /*7*/ <1.55328,9.91687,0.818>,<1.57786,9.88684,0.8503>,<1.53419,9.90822,0.86393>,
            
    /*8*/ <1.73479,10.26092,0.93787>,<1.75528,10.24189,0.9634>,<1.72161,10.25629,0.97307>,
            
    /*9*/ <1.84694,10.64481,1.0101>,<1.86265,10.63718,1.02833>,<1.83876,10.64312,1.03392>,
            
    /*10*/ <1.95899,11.03301,1.07842>,<1.96688,11.02933,1.08756>,<1.95493,11.03228,1.09035>,
            
    /*11*/ <2.1049,11.41332,1.12205>

    /* stem 0.10.0.0*/ 
    /*0*/ <0.45259,8.28543,-0.02179>,
    /*1*/ <0.46631,8.26102,-0.00928>,<0.44931,8.3112,-0.0055>,<0.44214,8.28406,-0.05059>,
            
    /*2*/ <1.8375,8.79409,-0.54827>

    /* stem 0.10.0.1*/ 
    /*0*/ <0.56433,8.39485,0.05461>,
    /*1*/ <0.54081,8.41277,0.05926>,<0.58985,8.40614,0.0438>,<0.56232,8.36563,0.06078>,
            
    /*2*/ <1.04824,8.66136,1.47567>

    /* stem 0.10.0.2*/ 
    /*0*/ <0.7095,8.55756,0.16164>,
    /*1*/ <0.72986,8.55246,0.14178>,<0.71672,8.55956,0.18954>,<0.68192,8.56067,0.15359>,
            
    /*2*/ <0.91802,10.00051,0.00458>

    /* stem 0.10.0.3*/ 
    /*0*/ <0.84091,8.76763,0.2628>,
    /*1*/ <0.83416,8.76061,0.28878>,<0.83535,8.79315,0.25345>,<0.85322,8.74914,0.24618>,
            
    /*2*/ <2.09656,9.20413,0.70702>

    /* stem 0.10.0.4*/ 
    /*0*/ <1.07475,9.2051,0.48547>,
    /*1*/ <1.06686,9.22061,0.46696>,<1.0974,9.2088,0.49635>,<1.05998,9.18588,0.49309>,
            
    /*2*/ <0.5351,9.96313,1.35094>

    /* stem 0.10.0.5*/ 
    /*0*/ <1.15351,9.32827,0.55755>,
    /*1*/ <1.17142,9.31182,0.56186>,<1.14764,9.34492,0.57482>,<1.14148,9.32807,0.53599>,
            
    /*2*/ <1.98278,10.10821,0.08774>

    /* stem 0.10.0.6*/ 
    /*0*/ <1.31616,9.53565,0.67345>,
    /*1*/ <1.29721,9.5447,0.68387>,<1.33187,9.54982,0.66334>,<1.31942,9.51244,0.67315>,
            
    /*2*/ <1.89995,9.60442,1.67632>

    /* stem 0.10.0.7*/ 
    /*0*/ <1.41058,9.67464,0.74083>,
    /*1*/ <1.42208,9.67615,0.72138>,<1.42156,9.67588,0.76061>,<1.38809,9.67188,0.74051>,
            
    /*2*/ <1.27429,10.78524,0.74643>

    /* stem 0.10.0.8*/ 
    /*0*/ <1.61552,10.01977,0.88191>,
    /*1*/ <1.61784,10.01227,0.90115>,<1.60642,10.03822,0.87897>,<1.6223,10.00882,0.8656>,
            
    /*2*/ <2.52088,10.47718,0.95102>

    /* stem 0.10.0.9*/ 
    /*0*/ <1.76589,10.35232,0.97497>,
    /*1*/ <1.75176,10.35833,0.96362>,<1.78336,10.35986,0.97328>,<1.76256,10.33877,0.98802>,
            
    /*2*/ <1.54497,11.00365,1.59474>

    /* stem 0.10.0.10*/ 
    /*0*/ <1.86972,10.71302,1.03534>,
    /*1*/ <1.88247,10.7095,1.03467>,<1.86561,10.72123,1.04488>,<1.86109,10.70833,1.02646>,
            
    /*2*/ <2.02406,11.36657,0.53977>

    /* stem 0.10.0.11*/ 
    /*0*/ <1.92674,10.91359,1.06689>,
    /*1*/ <1.91979,10.91456,1.07328>,<1.92891,10.92081,1.06111>,<1.93151,10.90541,1.06627>,
            
    /*2*/ <2.44616,11.17732,1.59153>

    /* stem 0.10.0.12*/ 
    /*0*/ <2.03394,11.22602,1.10409>,
    /*1*/ <2.03443,11.22618,1.10055>,<2.03655,11.22707,1.1063>,<2.03085,11.22482,1.10542>,
            
    /*2*/ <1.77688,11.88148,1.09767>

    /* stem 0.10.1*/ 
    /*0*/ <0.50362,8.14621,-0.11356>,
    /*1*/ <0.5119,8.07839,-0.093>,<0.52386,8.1993,-0.07039>,<0.4751,8.16095,-0.17728>,
            
    /*2*/ <0.876,8.07986,-0.25961>,<0.88676,8.18868,-0.23926>,<0.84288,8.15417,-0.33546>,
            
    /*3*/ <1.25074,8.19281,-0.39966>,<1.23406,8.28624,-0.37198>,<1.20919,8.25643,-0.46291>,
            
    /*4*/ <1.58788,8.40986,-0.50383>,<1.55191,8.48227,-0.47305>,<1.54063,8.46022,-0.55594>,
            
    /*5*/ <1.87886,8.68423,-0.58861>,<1.83766,8.73846,-0.55928>,<1.83186,8.72238,-0.63143>,
            
    /*6*/ <2.08557,9.03301,-0.66157>,<2.04113,9.06594,-0.63402>,<2.0383,9.05496,-0.69476>,
            
    /*7*/ <2.24484,9.39833,-0.73149>,<2.20686,9.42009,-0.70852>,<2.20478,9.41168,-0.75719>,
            
    /*8*/ <2.39585,9.76478,-0.79202>,<2.36695,9.78019,-0.77463>,<2.36573,9.77464,-0.81127>,
            
    /*9*/ <2.53912,10.13783,-0.76139>,<2.51859,10.14518,-0.74976>,<2.52004,10.14664,-0.77439>,
            
    /*10*/ <2.68994,10.5064,-0.72281>,<2.67972,10.51018,-0.71698>,<2.68053,10.51113,-0.72928>,
            
    /*11*/ <2.81699,10.88469,-0.6847>

    /* stem 0.10.1.0*/ 
    /*0*/ <0.71666,8.14311,-0.20962>,
    /*1*/ <0.72165,8.17121,-0.19947>,<0.72739,8.13465,-0.23666>,<0.70095,8.12347,-0.19274>,
            
    /*2*/ <2.02689,7.66897,0.45856>

    /* stem 0.10.1.1*/ 
    /*0*/ <0.97479,8.17143,-0.31718>,
    /*1*/ <0.9693,8.15817,-0.34248>,<0.99935,8.1656,-0.30272>,<0.95572,8.19054,-0.30634>,
            
    /*2*/ <1.6591,9.26377,-1.03869>

    /* stem 0.10.1.2*/ 
    /*0*/ <1.09832,8.20693,-0.36261>,
    /*1*/ <1.10937,8.20131,-0.33694>,<1.10333,8.23207,-0.37508>,<1.08225,8.18743,-0.37579>,
            
    /*2*/ <2.27827,7.65976,-0.99091>

    /* stem 0.10.1.3*/ 
    /*0*/ <1.36993,8.33184,-0.45343>,
    /*1*/ <1.35455,8.35038,-0.46596>,<1.39188,8.32176,-0.46585>,<1.36337,8.32337,-0.42847>,
            
    /*2*/ <2.13412,9.3308,0.08649>

    /* stem 0.10.1.4*/ 
    /*0*/ <1.695,8.57395,-0.54924>,
    /*1*/ <1.71068,8.55493,-0.55518>,<1.7036,8.59383,-0.53605>,<1.67071,8.57309,-0.55649>,
            
    /*2*/ <1.9974,9.16129,-1.63198>

    /* stem 0.10.1.5*/ 
    /*0*/ <1.88144,8.76734,-0.60405>,
    /*1*/ <1.87204,8.77725,-0.58412>,<1.88368,8.78051,-0.62419>,<1.88859,8.74426,-0.60385>,
            
    /*2*/ <2.97995,9.11096,-0.25723>

    /* stem 0.10.1.6*/ 
    /*0*/ <1.98179,8.93153,-0.6384>,
    /*1*/ <1.97727,8.92953,-0.66118>,<2.00245,8.93967,-0.63128>,<1.96566,8.92539,-0.62273>,
            
    /*2*/ <1.56141,10.00747,-0.64953>

    /* stem 0.10.1.7*/ 
    /*0*/ <2.16873,9.30033,-0.71132>,
    /*1*/ <2.1843,9.29593,-0.6972>,<2.15784,9.31878,-0.70988>,<2.16404,9.28628,-0.72686>,
            
    /*2*/ <2.87293,9.76489,-1.3436>

    /* stem 0.10.1.8*/ 
    /*0*/ <2.27012,9.52841,-0.75204>,
    /*1*/ <2.25141,9.53642,-0.75263>,<2.28349,9.5327,-0.76677>,<2.27545,9.51612,-0.73671>,
            
    /*2*/ <2.58974,10.3133,-0.2334>

    /* stem 0.10.1.9*/ 
    /*0*/ <2.48832,10.05032,-0.76958>,
    /*1*/ <2.50032,10.04629,-0.77947>,<2.49151,10.05783,-0.75574>,<2.47315,10.04684,-0.77352>,
            
    /*2*/ <2.4173,10.80754,-1.16425>

    /* stem 0.10.1.10*/ 
    /*0*/ <2.54567,10.18912,-0.75698>,
    /*1*/ <2.54267,10.18903,-0.74395>,<2.54492,10.20052,-0.76393>,<2.54941,10.17781,-0.76306>,
            
    /*2*/ <3.32945,10.35115,-0.57548>

    /* stem 0.10.1.11*/ 
    /*0*/ <2.63098,10.38742,-0.73595>,
    /*1*/ <2.62717,10.38995,-0.74428>,<2.64013,10.38931,-0.73414>,<2.62566,10.38301,-0.72942>,
            
    /*2*/ <2.43188,11.06767,-0.43863>

    /* stem 0.10.1.12*/ 
    /*0*/ <2.72598,10.62893,-0.71081>,
    /*1*/ <2.73017,10.62726,-0.70898>,<2.72364,10.63255,-0.70857>,<2.72415,10.62699,-0.71487>,
            
    /*2*/ <3.08277,11.09973,-1.09747>

    /* stem 0.10.2*/ 
    /*0*/ <0.75928,8.18399,-0.06379>,
    /*1*/ <0.74539,8.24673,-0.0365>,<0.8019,8.17852,-0.11881>,<0.73055,8.12673,-0.03606>,
            
    /*2*/ <1.05252,8.20355,0.20128>,<1.10338,8.14216,0.12721>,<1.03917,8.09555,0.20168>,
            
    /*3*/ <1.33953,8.32812,0.39508>,<1.40021,8.27681,0.33992>,<1.36253,8.2375,0.41987>,
            
    /*4*/ <1.66472,8.49081,0.53527>,<1.71203,8.44454,0.4825>,<1.69373,8.41516,0.55974>,
            
    /*5*/ <1.95283,8.68967,0.69342>,<2.00119,8.6542,0.65261>,<1.98301,8.62842,0.71794>,
            
    /*6*/ <2.24982,8.92594,0.78>,<2.2866,8.89446,0.74379>,<2.28158,8.87952,0.80215>,
            
    /*7*/ <2.53216,9.18355,0.8509>,<2.56255,9.15928,0.82215>,<2.56029,9.14878,0.8693>,
            
    /*8*/ <2.80083,9.44419,0.95911>,<2.82581,9.42783,0.93851>,<2.8215,9.41788,0.97313>,
            
    /*9*/ <3.03871,9.73783,1.04926>,<3.05638,9.72809,1.03592>,<3.05443,9.72248,1.05936>,
            
    /*10*/ <3.18629,10.08441,1.13837>,<3.19645,10.08182,1.13234>,<3.19556,10.07918,1.14411>,
            
    /*11*/ <3.31332,10.42243,1.28704>

    /* stem 0.10.2.0*/ 
    /*0*/ <0.99349,8.15572,0.12045>,
    /*1*/ <1.00909,8.1436,0.09876>,<0.99404,8.1439,0.14729>,<0.97734,8.17966,0.1153>,
            
    /*2*/ <2.15731,9.01754,0.47595>

    /* stem 0.10.2.1*/ 
    /*0*/ <1.12482,8.17353,0.2179>,
    /*1*/ <1.11136,8.16628,0.24209>,<1.14001,8.19775,0.21668>,<1.12308,8.15655,0.19493>,
            
    /*2*/ <2.30536,7.45538,0.65958>

    /* stem 0.10.2.2*/ 
    /*0*/ <1.28804,8.24571,0.33029>,
    /*1*/ <1.29047,8.2672,0.31296>,<1.31073,8.2331,0.34>,<1.26292,8.23682,0.33792>,
            
    /*2*/ <1.30896,9.12289,1.4213>

    /* stem 0.10.2.3*/ 
    /*0*/ <1.48262,8.34126,0.43524>,
    /*1*/ <1.49371,8.31724,0.43873>,<1.48209,8.35876,0.45538>,<1.47207,8.34778,0.41162>,
            
    /*2*/ <2.66819,8.83096,0.04089>

    /* stem 0.10.2.4*/ 
    /*0*/ <1.90449,8.60396,0.64615>,
    /*1*/ <1.8881,8.61861,0.65662>,<1.92307,8.61346,0.63363>,<1.90229,8.5798,0.64822>,
            
    /*2*/ <2.57278,8.6294,1.65704>

    /* stem 0.10.2.5*/ 
    /*0*/ <2.07276,8.73486,0.71587>,
    /*1*/ <2.08209,8.73117,0.69477>,<2.08555,8.73125,0.73508>,<2.05065,8.74217,0.71775>,
            
    /*2*/ <2.4332,9.83478,0.68273>

    /* stem 0.10.2.6*/ 
    /*0*/ <2.1796,8.8231,0.74764>,
    /*1*/ <2.18032,8.81463,0.76873>,<2.1787,8.8456,0.74445>,<2.17977,8.80908,0.72974>,
            
    /*2*/ <3.30244,8.86463,0.72563>

    /* stem 0.10.2.7*/ 
    /*0*/ <2.48072,9.09676,0.82911>,
    /*1*/ <2.47015,9.11098,0.81797>,<2.50162,9.09632,0.82836>,<2.47039,9.08299,0.84098>,
            
    /*2*/ <2.52267,9.74689,1.61936>

    /* stem 0.10.2.8*/ 
    /*0*/ <2.66744,9.28039,0.89538>,
    /*1*/ <2.68177,9.267,0.89332>,<2.66851,9.29385,0.90976>,<2.65203,9.28032,0.88307>,
            
    /*2*/ <3.13646,9.87342,0.30502>

    /* stem 0.10.2.9*/ 
    /*0*/ <2.93708,9.58502,1.00416>,
    /*1*/ <2.9256,9.59038,1.01598>,<2.94439,9.59644,0.99338>,<2.94126,9.56823,1.00313>,
            
    /*2*/ <3.57345,9.7085,1.56625>

    /* stem 0.10.2.10*/ 
    /*0*/ <3.07764,9.79798,1.0657>,
    /*1*/ <3.08058,9.79988,1.05359>,<3.08633,9.79975,1.07465>,<3.066,9.79431,1.06885>,
            
    /*2*/ <2.85574,10.5581,1.13096>

    /* stem 0.10.2.11*/ 
    /*0*/ <3.16051,10.00228,1.11794>,
    /*1*/ <3.16393,9.99906,1.12509>,<3.15595,10.00951,1.11825>,<3.16165,9.99826,1.11047>,
            
    /*2*/ <3.77641,10.39549,1.00015>

    /* stem 0.10.2.12*/ 
    /*0*/ <3.25418,10.25531,1.21405>,
    /*1*/ <3.2513,10.25681,1.21295>,<3.25719,10.2569,1.21366>,<3.25405,10.25223,1.21553>,
            
    /*2*/ <3.17741,10.54685,1.81375>

    /* stem 0.10.3*/ 
    /*0*/ <1.22538,8.23983,0.04515>,
    /*1*/ <1.24238,8.21193,-0.01332>,<1.25073,8.21585,0.10232>,<1.18302,8.2917,0.04644>,
            
    /*2*/ <1.52854,8.45049,-0.03624>,<1.53604,8.45402,0.06785>,<1.47511,8.52228,0.01755>,
            
    /*3*/ <1.77455,8.70983,-0.12143>,<1.79402,8.72258,-0.03159>,<1.72747,8.7729,-0.07225>,
            
    /*4*/ <1.99439,9.00739,-0.19704>,<2.01034,9.01725,-0.11803>,<1.94706,9.05538,-0.15175>,
            
    /*5*/ <2.24068,9.2873,-0.23951>,<2.24993,9.29107,-0.17062>,<2.20076,9.32963,-0.2013>,
            
    /*6*/ <2.47249,9.58838,-0.21732>,<2.47345,9.58441,-0.15946>,<2.43335,9.61715,-0.18562>,
            
    /*7*/ <2.68133,9.89646,-0.21934>,<2.68411,9.89573,-0.17302>,<2.64973,9.91893,-0.19384>,
            
    /*8*/ <2.87408,10.21704,-0.21882>,<2.8761,10.21641,-0.18408>,<2.84944,10.23246,-0.19967>,
            
    /*9*/ <3.03731,10.55314,-0.176>,<3.03735,10.55057,-0.15294>,<3.0193,10.56067,-0.16345>,
            
    /*10*/ <3.16868,10.89945,-0.20494>,<3.16967,10.90022,-0.1934>,<3.15985,10.90352,-0.19862>,
            
    /*11*/ <3.29351,11.25016,-0.23305>

    /* stem 0.10.3.0*/ 
    /*0*/ <1.35867,8.349,0.03183>,
    /*1*/ <1.36384,8.3461,0.05984>,<1.3571,8.37511,0.02019>,<1.35506,8.32579,0.01546>,
            
    /*2*/ <2.78484,8.3154,-0.23495>

    /* stem 0.10.3.1*/ 
    /*0*/ <1.67803,8.64523,-0.04341>,
    /*1*/ <1.65995,8.65731,-0.05895>,<1.70176,8.63819,-0.05349>,<1.67238,8.64019,-0.01778>,
            
    /*2*/ <2.18079,9.84327,0.30309>

    /* stem 0.10.3.2*/ 
    /*0*/ <1.81055,8.7954,-0.09174>,
    /*1*/ <1.83087,8.77958,-0.09386>,<1.81182,8.81606,-0.07628>,<1.78895,8.79055,-0.10507>,
            
    /*2*/ <2.26002,9.50511,-1.07745>

    /* stem 0.10.3.3*/ 
    /*0*/ <1.94056,8.96883,-0.13963>,
    /*1*/ <1.92871,8.98244,-0.12251>,<1.94794,8.97933,-0.16095>,<1.94503,8.94471,-0.13545>,
            
    /*2*/ <3.02934,9.26099,0.38132>

    /* stem 0.10.3.4*/ 
    /*0*/ <2.16461,9.22895,-0.19094>,
    /*1*/ <2.16455,9.22498,-0.21397>,<2.18481,9.22928,-0.17919>,<2.14447,9.23259,-0.17965>,
            
    /*2*/ <2.26015,10.36663,-0.38723>

    /* stem 0.10.3.5*/ 
    /*0*/ <2.32765,9.42728,-0.19688>,
    /*1*/ <2.33675,9.41915,-0.17828>,<2.31976,9.44807,-0.19724>,<2.32645,9.41461,-0.21513>,
            
    /*2*/ <3.31014,9.79453,-0.51667>

    /* stem 0.10.3.6*/ 
    /*0*/ <2.57742,9.76708,-0.19187>,
    /*1*/ <2.56127,9.77808,-0.19772>,<2.59509,9.7688,-0.20189>,<2.57589,9.75437,-0.176>,
            
    /*2*/ <2.85416,10.49996,0.42196>

    /* stem 0.10.3.7*/ 
    /*0*/ <2.75428,10.03858,-0.19771>,
    /*1*/ <2.76906,10.0294,-0.20523>,<2.7565,10.04871,-0.18186>,<2.7373,10.03762,-0.20605>,
            
    /*2*/ <2.95869,10.77895,-0.69943>

    /* stem 0.10.3.8*/ 
    /*0*/ <2.91158,10.31294,-0.19082>,
    /*1*/ <2.90375,10.31511,-0.17529>,<2.91171,10.32603,-0.20247>,<2.91929,10.29769,-0.19469>,
            
    /*2*/ <3.63421,10.59562,0.13437>

    /* stem 0.10.3.9*/ 
    /*0*/ <2.97845,10.44801,-0.17591>,
    /*1*/ <2.976,10.45089,-0.19099>,<2.99248,10.45053,-0.1697>,<2.96688,10.44262,-0.16705>,
            
    /*2*/ <2.76365,11.20289,0.00302>

    /* stem 0.10.3.10*/ 
    /*0*/ <3.12678,10.8001,-0.18882>,
    /*1*/ <3.13341,10.79804,-0.18366>,<3.12307,10.80789,-0.1882>,<3.12386,10.79437,-0.19461>,
            
    /*2*/ <3.58322,11.05638,-0.67261>

    /* stem 0.10.3.11*/ 
    /*0*/ <3.25788,11.15256,-0.22353>,
    /*1*/ <3.25613,11.15321,-0.22342>,<3.25898,11.15307,-0.22495>,<3.25853,11.15141,-0.22221>,
            
    /*2*/ <3.45909,11.64069,0.1056>

    /* stem 0.10.4*/ 
    /*0*/ <1.43388,8.26959,0.0939>,
    /*1*/ <1.42201,8.25255,0.15624>,<1.45694,8.32954,0.08004>,<1.42269,8.22668,0.04541>,
            
    /*2*/ <1.76528,8.12989,0.18113>,<1.79671,8.19918,0.11256>,<1.76589,8.1066,0.08139>,
            
    /*3*/ <2.13351,8.1458,0.21656>,<2.13809,8.2108,0.15297>,<2.14436,8.12318,0.12904>,
            
    /*4*/ <2.4785,8.27453,0.2495>,<2.46528,8.32794,0.19189>,<2.49404,8.25593,0.17361>,
            
    /*5*/ <2.78133,8.49208,0.2419>,<2.7539,8.5299,0.1921>,<2.79264,8.47587,0.17654>,
            
    /*6*/ <3.0193,8.75494,0.30331>,<2.99705,8.78619,0.26129>,<3.03957,8.74998,0.25037>,
            
    /*7*/ <3.25078,9.0379,0.34289>,<3.23047,9.06018,0.30877>,<3.26566,9.03261,0.30019>,
            
    /*8*/ <3.45198,9.34246,0.37468>,<3.4351,9.35694,0.34878>,<3.46343,9.33887,0.34271>,
            
    /*9*/ <3.60439,9.6739,0.40425>,<3.59202,9.68154,0.38674>,<3.61256,9.67243,0.38305>,
            
    /*10*/ <3.7039,10.01618,0.47831>,<3.69775,10.02005,0.46955>,<3.70866,10.01721,0.46802>,
            
    /*11*/ <3.79823,10.35355,0.58036>

    /* stem 0.10.4.0*/ 
    /*0*/ <1.62553,8.19992,0.11134>,
    /*1*/ <1.63479,8.22169,0.0965>,<1.63724,8.17477,0.10804>,<1.60455,8.20328,0.12947>,
            
    /*2*/ <2.55514,8.49927,1.13132>

    /* stem 0.10.4.1*/ 
    /*0*/ <1.91023,8.15066,0.14027>,
    /*1*/ <1.91159,8.12415,0.1378>,<1.92331,8.1629,0.16002>,<1.8958,8.16494,0.12298>,
            
    /*2*/ <2.98533,8.27913,-0.65112>

    /* stem 0.10.4.2*/ 
    /*0*/ <2.18435,8.17686,0.1714>,
    /*1*/ <2.17618,8.19358,0.18878>,<2.19774,8.18491,0.1513>,<2.17913,8.15208,0.17412>,
            
    /*2*/ <3.2647,8.02172,0.82884>

    /* stem 0.10.4.3*/ 
    /*0*/ <2.40966,8.26034,0.19707>,
    /*1*/ <2.41306,8.25858,0.17295>,<2.42651,8.25162,0.21244>,<2.38941,8.27081,0.20581>,
            
    /*2*/ <2.96851,9.34049,0.19706>

    /* stem 0.10.4.4*/ 
    /*0*/ <2.55395,8.33978,0.20462>,
    /*1*/ <2.56158,8.3293,0.22446>,<2.55514,8.36335,0.20247>,<2.54513,8.3267,0.18695>,
            
    /*2*/ <3.62983,8.24275,-0.26061>

    /* stem 0.10.4.5*/ 
    /*0*/ <2.86818,8.59977,0.22941>,
    /*1*/ <2.8538,8.61476,0.2225>,<2.88856,8.59965,0.22141>,<2.8622,8.5849,0.24433>,
            
    /*2*/ <3.18167,9.26402,1.01741>

    /* stem 0.10.4.6*/ 
    /*0*/ <3.12334,8.89092,0.2924>,
    /*1*/ <3.13845,8.87965,0.28525>,<3.1264,8.90299,0.30825>,<3.10517,8.89012,0.28369>,
            
    /*2*/ <3.38126,9.62108,-0.31316>

    /* stem 0.10.4.7*/ 
    /*0*/ <3.39551,9.26391,0.34504>,
    /*1*/ <3.38714,9.26751,0.36066>,<3.3981,9.27708,0.33292>,<3.40129,9.24713,0.34153>,
            
    /*2*/ <4.16281,9.45133,0.71298>

    /* stem 0.10.4.8*/ 
    /*0*/ <3.47245,9.39419,0.36063>,
    /*1*/ <3.4706,9.39691,0.34355>,<3.48774,9.39732,0.36833>,<3.45902,9.38833,0.37002>,
            
    /*2*/ <3.23543,10.1802,0.51167>

    /* stem 0.10.4.9*/ 
    /*0*/ <3.57502,9.61557,0.38477>,
    /*1*/ <3.58451,9.61016,0.39406>,<3.5689,9.62829,0.38734>,<3.57164,9.60826,0.37289>,
            
    /*2*/ <4.15053,9.96952,0.00328>

    /* stem 0.10.4.10*/ 
    /*0*/ <3.6767,9.9268,0.4505>,
    /*1*/ <3.66874,9.92921,0.4502>,<3.68269,9.93191,0.44782>,<3.67866,9.91928,0.45347>,
            
    /*2*/ <3.73397,10.19491,1.08971>

    /* stem 0.10.4.11*/ 
    /*0*/ <3.75177,10.18898,0.52722>,
    /*1*/ <3.75438,10.18885,0.52534>,<3.75203,10.18993,0.53028>,<3.74889,10.18815,0.52604>,
            
    /*2*/ <3.65347,10.78286,0.35009>

    /* stem 0.10.5*/ 
    /*0*/ <1.85825,8.33715,0.19315>,
    /*1*/ <1.85871,8.38836,0.15629>,<1.90147,8.29194,0.18489>,<1.81455,8.33116,0.23827>,
            
    /*2*/ <2.07036,8.54425,0.38634>,<2.10884,8.45746,0.41208>,<2.03061,8.49276,0.46013>,
            
    /*3*/ <2.24892,8.78418,0.52283>,<2.30085,8.72474,0.56044>,<2.23001,8.75384,0.60262>,
            
    /*4*/ <2.41991,9.05204,0.6602>,<2.46837,9.00453,0.69552>,<2.40444,9.02721,0.73089>,
            
    /*5*/ <2.56018,9.33315,0.81189>,<2.60328,9.2956,0.84402>,<2.54536,9.30972,0.87132>,
            
    /*6*/ <2.69001,9.62565,0.94544>,<2.72728,9.59726,0.97357>,<2.67878,9.60851,0.9961>,
            
    /*7*/ <2.80988,9.92467,1.07907>,<2.84013,9.90306,1.10208>,<2.80086,9.91097,1.11959>,
            
    /*8*/ <2.92046,10.23277,1.1967>,<2.94374,10.21817,1.21458>,<2.91419,10.2238,1.22761>,
            
    /*9*/ <3.02076,10.55213,1.2911>,<3.03677,10.54382,1.30346>,<3.01703,10.54746,1.31213>,
            
    /*10*/ <3.09854,10.88866,1.32236>,<3.10703,10.88626,1.32883>,<3.09719,10.88813,1.3332>,
            
    /*11*/ <3.22592,11.21309,1.30669>

    /* stem 0.10.5.0*/ 
    /*0*/ <1.96684,8.41975,0.30927>,
    /*1*/ <1.98044,8.39682,0.31286>,<1.96236,8.43613,0.33013>,<1.95773,8.42629,0.28483>,
            
    /*2*/ <3.1273,9.0674,0.05008>

    /* stem 0.10.5.1*/ 
    /*0*/ <2.2096,8.68642,0.52423>,
    /*1*/ <2.18866,8.69721,0.53276>,<2.22629,8.69992,0.51131>,<2.21386,8.66212,0.52862>,
            
    /*2*/ <2.79588,8.98182,1.58979>

    /* stem 0.10.5.2*/ 
    /*0*/ <2.30683,8.82932,0.5986>,
    /*1*/ <2.32136,8.82972,0.5792>,<2.31637,8.82925,0.62089>,<2.28276,8.82901,0.59572>,
            
    /*2*/ <2.28963,10.03551,0.61022>

    /* stem 0.10.5.3*/ 
    /*0*/ <2.3738,8.93651,0.65092>,
    /*1*/ <2.37257,8.92678,0.67243>,<2.36557,8.95839,0.64736>,<2.38325,8.92437,0.63297>,
            
    /*2*/ <3.43061,9.37601,0.91006>

    /* stem 0.10.5.4*/ 
    /*0*/ <2.47236,9.11307,0.73943>,
    /*1*/ <2.4602,9.12619,0.72548>,<2.49395,9.11833,0.74399>,<2.46293,9.09471,0.74883>,
            
    /*2*/ <2.13774,9.73121,1.61203>

    /* stem 0.10.5.5*/ 
    /*0*/ <2.66478,9.53227,0.93773>,
    /*1*/ <2.68333,9.5237,0.93894>,<2.65655,9.54124,0.95419>,<2.65445,9.53187,0.92006>,
            
    /*2*/ <3.08338,10.40102,0.67339>

    /* stem 0.10.5.6*/ 
    /*0*/ <2.73,9.69053,1.00573>,
    /*1*/ <2.71357,9.69245,1.01635>,<2.73793,9.70625,0.99698>,<2.7385,9.67291,1.00386>,
            
    /*2*/ <3.25433,9.86061,1.78646>

    /* stem 0.10.5.7*/ 
    /*0*/ <2.85364,10.01774,1.13812>,
    /*1*/ <2.85993,10.02147,1.12169>,<2.86362,10.02142,1.15262>,<2.83737,10.01032,1.14005>,
            
    /*2*/ <2.49928,10.80662,1.18163>

    /* stem 0.10.5.8*/ 
    /*0*/ <2.9547,10.31834,1.23879>,
    /*1*/ <2.96004,10.31269,1.25333>,<2.94516,10.33178,1.23817>,<2.95889,10.31056,1.22488>,
            
    /*2*/ <3.59514,10.77008,1.179>

    /* stem 0.10.5.9*/ 
    /*0*/ <2.99938,10.46449,1.2792>,
    /*1*/ <2.98757,10.46975,1.27321>,<3.01212,10.46984,1.27574>,<2.99844,10.45387,1.28865>,
            
    /*2*/ <2.94047,10.9632,1.83365>

    /* stem 0.10.5.10*/ 
    /*0*/ <3.07758,10.78339,1.32018>,
    /*1*/ <3.08543,10.78178,1.31824>,<3.0758,10.78754,1.32708>,<3.0715,10.78085,1.31522>,
            
    /*2*/ <3.11236,11.35934,0.98292>

    /* stem 0.10.5.11*/ 
    /*0*/ <3.17647,11.08436,1.31517>,
    /*1*/ <3.17514,11.085,1.31718>,<3.17623,11.08565,1.31305>,<3.17803,11.08242,1.31528>,
            
    /*2*/ <3.61216,11.44601,1.48778>

    /* stem 0.10.6*/ 
    /*0*/ <2.34266,8.40851,0.27561>,
    /*1*/ <2.35167,8.34914,0.27225>,<2.36495,8.43974,0.32193>,<2.31134,8.43666,0.23266>,
            
    /*2*/ <2.63033,8.40715,0.1029>,<2.64228,8.48869,0.14762>,<2.59403,8.48592,0.06727>,
            
    /*3*/ <2.92528,8.56966,0.01522>,<2.90606,8.63316,0.06566>,<2.88175,8.63442,-0.01405>,
            
    /*4*/ <3.16128,8.77119,-0.1199>,<3.14336,8.82475,-0.07376>,<3.11041,8.81997,-0.13865>,
            
    /*5*/ <3.36875,9.03197,-0.1914>,<3.34164,9.06668,-0.14704>,<3.31975,9.06811,-0.20558>,
            
    /*6*/ <3.55016,9.30472,-0.2571>,<3.52566,9.33106,-0.21942>,<3.507,9.33176,-0.26805>,
            
    /*7*/ <3.67135,9.61631,-0.30524>,<3.64816,9.63081,-0.2738>,<3.63295,9.63072,-0.31259>,
            
    /*8*/ <3.73727,9.94229,-0.34655>,<3.71875,9.94957,-0.32245>,<3.70698,9.94828,-0.35138>,
            
    /*9*/ <3.80113,10.26693,-0.31112>,<3.78795,10.2681,-0.29502>,<3.78108,10.27157,-0.31439>,
            
    /*10*/ <3.86714,10.59032,-0.32727>,<3.86084,10.59218,-0.31918>,<3.85707,10.59246,-0.32889>,
            
    /*11*/ <3.92428,10.91681,-0.32149>

    /* stem 0.10.6.0*/ 
    /*0*/ <2.52892,8.44321,0.16256>,
    /*1*/ <2.53441,8.46291,0.17765>,<2.53094,8.44557,0.13733>,<2.52141,8.42114,0.17269>,
            
    /*2*/ <3.73962,8.05911,0.22363>

    /* stem 0.10.6.1*/ 
    /*0*/ <2.79053,8.55116,0.05603>,
    /*1*/ <2.78543,8.5478,0.03273>,<2.81302,8.54793,0.06402>,<2.77314,8.55774,0.07133>,
            
    /*2*/ <3.03352,9.70327,-0.16323>

    /* stem 0.10.6.2*/ 
    /*0*/ <3.05009,8.73255,-0.06059>,
    /*1*/ <3.06509,8.72468,-0.04562>,<3.04937,8.75464,-0.06531>,<3.03581,8.71833,-0.07082>,
            
    /*2*/ <3.79022,8.58085,-0.88214>

    /* stem 0.10.6.3*/ 
    /*0*/ <3.24283,8.93284,-0.14673>,
    /*1*/ <3.2262,8.94611,-0.14797>,<3.25853,8.93405,-0.16109>,<3.24376,8.91835,-0.13112>,
            
    /*2*/ <3.74553,9.61958,0.46079>

    /* stem 0.10.6.4*/ 
    /*0*/ <3.39399,9.12892,-0.19971>,
    /*1*/ <3.40575,9.11778,-0.21177>,<3.40225,9.14273,-0.18751>,<3.37398,9.12624,-0.19984>,
            
    /*2*/ <3.30813,9.8068,-0.90895>

    /* stem 0.10.6.5*/ 
    /*0*/ <3.48137,9.25552,-0.23141>,
    /*1*/ <3.48011,9.26107,-0.21276>,<3.48053,9.26885,-0.24562>,<3.48347,9.23666,-0.23586>,
            
    /*2*/ <4.42293,9.35214,-0.19635>

    /* stem 0.10.6.6*/ 
    /*0*/ <3.59187,9.48076,-0.27376>,
    /*1*/ <3.58255,9.482,-0.28952>,<3.60911,9.48699,-0.27278>,<3.58394,9.4733,-0.25897>,
            
    /*2*/ <3.29042,10.27808,-0.03294>

    /* stem 0.10.6.7*/ 
    /*0*/ <3.68799,9.79584,-0.31994>,
    /*1*/ <3.70371,9.79312,-0.31451>,<3.67873,9.80816,-0.31313>,<3.68153,9.78623,-0.33219>,
            
    /*2*/ <3.96774,10.31142,-0.87218>

    /* stem 0.10.6.8*/ 
    /*0*/ <3.76595,10.15643,-0.31846>,
    /*1*/ <3.75294,10.1587,-0.31344>,<3.77075,10.16405,-0.32935>,<3.77416,10.14654,-0.31259>,
            
    /*2*/ <4.02693,10.64362,0.13755>

    /* stem 0.10.6.9*/ 
    /*0*/ <3.81003,10.3589,-0.31194>,
    /*1*/ <3.81482,10.35733,-0.32098>,<3.81394,10.36563,-0.30511>,<3.80133,10.35375,-0.30972>,
            
    /*2*/ <3.45006,10.84755,-0.58766>

    /* stem 0.10.6.10*/ 
    /*0*/ <3.90427,10.81288,-0.32265>,
    /*1*/ <3.90463,10.81279,-0.32077>,<3.90301,10.81417,-0.32333>,<3.90518,10.81169,-0.32386>,
            
    /*2*/ <4.31321,11.18369,-0.38237>

    /* stem 0.10.7*/ 
    /*0*/ <2.87828,8.46022,0.34249>,
    /*1*/ <2.87349,8.50107,0.38181>,<2.91356,8.46718,0.29839>,<2.84779,8.41242,0.34727>,
            
    /*2*/ <3.10437,8.36642,0.54161>,<3.14044,8.33591,0.46653>,<3.08124,8.28663,0.51052>,
            
    /*3*/ <3.34925,8.34841,0.70818>,<3.38973,8.31886,0.64731>,<3.35198,8.27044,0.69678>,
            
    /*4*/ <3.58593,8.42672,0.87406>,<3.62893,8.40173,0.82624>,<3.60642,8.36091,0.8771>,
            
    /*5*/ <3.83186,8.52825,1.03296>,<3.86848,8.50694,0.9917>,<3.8528,8.47314,1.03762>,
            
    /*6*/ <4.01144,8.72757,1.16737>,<4.04881,8.71469,1.13795>,<4.04212,8.69145,1.18089>,
            
    /*7*/ <4.1618,8.94982,1.31774>,<4.19442,8.94281,1.29674>,<4.18841,8.92382,1.33077>,
            
    /*8*/ <4.28133,9.19766,1.45748>,<4.30681,9.19417,1.44289>,<4.30294,9.1812,1.46918>,
            
    /*9*/ <4.39326,9.46097,1.57871>,<4.41023,9.45861,1.56896>,<4.40816,9.45115,1.58708>,
            
    /*10*/ <4.50596,9.72429,1.70097>,<4.51445,9.72311,1.6961>,<4.5134,9.71935,1.70515>,
            
    /*11*/ <4.57754,10.00034,1.82409>

    /* stem 0.10.7.0*/ 
    /*0*/ <2.97981,8.40269,0.41464>,
    /*1*/ <2.99183,8.39799,0.39398>,<2.97766,8.38542,0.43167>,<2.96994,8.42465,0.41826>,
            
    /*2*/ <4.01075,8.78125,0.92842>

    /* stem 0.10.7.1*/ 
    /*0*/ <3.21337,8.32264,0.57925>,
    /*1*/ <3.20124,8.31186,0.5956>,<3.22593,8.34121,0.58458>,<3.21295,8.31485,0.55758>,
            
    /*2*/ <4.10885,7.65329,0.80218>

    /* stem 0.10.7.2*/ 
    /*0*/ <3.51906,8.36612,0.79584>,
    /*1*/ <3.51942,8.38518,0.7862>,<3.53738,8.35623,0.80063>,<3.50038,8.35695,0.80067>,
            
    /*2*/ <3.52921,8.83883,1.73141>

    /* stem 0.10.7.3*/ 
    /*0*/ <3.68588,8.43079,0.91133>,
    /*1*/ <3.69481,8.41248,0.9099>,<3.68675,8.44123,0.92886>,<3.67608,8.43866,0.89524>,
            
    /*2*/ <4.5306,8.8664,0.60983>

    /* stem 0.10.7.4*/ 
    /*0*/ <3.97436,8.64319,1.11594>,
    /*1*/ <3.9596,8.65021,1.12472>,<3.986,8.65446,1.1069>,<3.97749,8.62491,1.11621>,
            
    /*2*/ <4.46251,8.73753,1.86156>

    /* stem 0.10.7.5*/ 
    /*0*/ <4.12674,8.85421,1.2582>,
    /*1*/ <4.13648,8.85723,1.24433>,<4.13401,8.85327,1.27378>,<4.10973,8.85215,1.25649>,
            
    /*2*/ <4.01794,9.66569,1.35838>

    /* stem 0.10.7.6*/ 
    /*0*/ <4.24066,9.06791,1.38748>,
    /*1*/ <4.24114,9.05993,1.4013>,<4.23409,9.08246,1.38688>,<4.24673,9.06134,1.37425>,
            
    /*2*/ <4.91524,9.37862,1.543>

    /* stem 0.10.7.7*/ 
    /*0*/ <4.37102,9.37513,1.54081>,
    /*1*/ <4.36251,9.38191,1.53345>,<4.38365,9.37868,1.5412>,<4.36689,9.36478,1.54777>,
            
    /*2*/ <4.24153,9.77729,2.06157>

    /* stem 0.10.7.8*/ 
    /*0*/ <4.45291,9.57805,1.63417>,
    /*1*/ <4.4611,9.5749,1.63381>,<4.45045,9.58311,1.64091>,<4.44718,9.57613,1.62779>,
            
    /*2*/ <4.631,10.07661,1.32417>

    /* stem 0.10.7.9*/ 
    /*0*/ <4.5342,9.81846,1.74342>,
    /*1*/ <4.53117,9.81823,1.74557>,<4.53486,9.82156,1.74146>,<4.53656,9.81559,1.74322>,
            
    /*2*/ <4.81755,10.02288,2.16433>

    /* stem 0.10.8*/ 
    /*0*/ <3.74673,8.49211,0.42595>,
    /*1*/ <3.75221,8.48684,0.37487>,<3.76823,8.45772,0.45792>,<3.71975,8.53178,0.44506>,
            
    /*2*/ <3.98471,8.64147,0.38908>,<3.99913,8.61527,0.46382>,<3.9555,8.68192,0.45225>,
            
    /*3*/ <4.20951,8.79814,0.37185>,<4.22945,8.77854,0.43772>,<4.18856,8.83654,0.42848>,
            
    /*4*/ <4.4059,8.98934,0.33176>,<4.43044,8.97729,0.38809>,<4.38643,9.0214,0.38189>,
            
    /*5*/ <4.60691,9.19173,0.33454>,<4.62239,9.17682,0.38371>,<4.58453,9.21438,0.37774>,
            
    /*6*/ <4.78091,9.41157,0.3424>,<4.79465,9.40015,0.3834>,<4.75988,9.42783,0.37836>,
            
    /*7*/ <4.97281,9.61472,0.35436>,<4.98264,9.6043,0.38714>,<4.95691,9.62883,0.38314>,
            
    /*8*/ <5.17005,9.81182,0.35714>,<5.17782,9.80431,0.3817>,<5.15898,9.8232,0.37878>,
            
    /*9*/ <5.3594,10.01729,0.35558>,<5.36498,10.01267,0.37193>,<5.35189,10.02471,0.37002>,
            
    /*10*/ <5.53566,10.23023,0.4098>,<5.5374,10.2269,0.41792>,<5.5307,10.23272,0.41681>,
            
    /*11*/ <5.67279,10.46307,0.48338>

    /* stem 0.10.8.0*/ 
    /*0*/ <3.91403,8.60274,0.43248>,
    /*1*/ <3.91984,8.59286,0.45098>,<3.91802,8.62396,0.42976>,<3.90423,8.5914,0.4167>,
            
    /*2*/ <4.86799,8.36896,0.00794>

    /* stem 0.10.8.1*/ 
    /*0*/ <4.05808,8.70022,0.42741>,
    /*1*/ <4.0463,8.71642,0.42114>,<4.07538,8.69505,0.4167>,<4.05257,8.68918,0.4444>,
            
    /*2*/ <4.61307,9.33263,1.01834>

    /* stem 0.10.8.2*/ 
    /*0*/ <4.29036,8.88281,0.39409>,
    /*1*/ <4.30188,8.869,0.38612>,<4.29834,8.89739,0.40461>,<4.27087,8.88204,0.39154>,
            
    /*2*/ <4.3733,9.41001,-0.39973>

    /* stem 0.10.8.3*/ 
    /*0*/ <4.50902,9.0981,0.36626>,
    /*1*/ <4.50333,9.10391,0.38264>,<4.51033,9.10988,0.35232>,<4.5134,9.08051,0.36381>,
            
    /*2*/ <5.34326,9.27407,0.5935>

    /* stem 0.10.8.4*/ 
    /*0*/ <4.67457,9.28238,0.36642>,
    /*1*/ <4.67152,9.285,0.34972>,<4.69066,9.28299,0.37242>,<4.66153,9.27914,0.37713>,
            
    /*2*/ <4.59093,10.0885,0.50851>

    /* stem 0.10.8.5*/ 
    /*0*/ <4.85504,9.49391,0.37077>,
    /*1*/ <4.86417,9.48493,0.38022>,<4.85131,9.50877,0.37509>,<4.84963,9.48803,0.357>,
            
    /*2*/ <5.47249,9.75121,0.01849>

    /* stem 0.10.8.6*/ 
    /*0*/ <5.0734,9.71805,0.37367>,
    /*1*/ <5.06321,9.7283,0.37462>,<5.08442,9.71962,0.36439>,<5.07257,9.70622,0.382>,
            
    /*2*/ <5.43527,10.033,0.85685>

    /* stem 0.10.8.7*/ 
    /*0*/ <5.27882,9.93184,0.36866>,
    /*1*/ <5.28529,9.92556,0.36>,<5.28464,9.93635,0.37877>,<5.26652,9.9336,0.36722>,
            
    /*2*/ <5.38834,10.45351,0.07269>

    /* stem 0.10.8.8*/ 
    /*0*/ <5.41709,10.08847,0.3821>,
    /*1*/ <5.41531,10.08801,0.39052>,<5.41815,10.09615,0.37834>,<5.41783,10.08126,0.37745>,
            
    /*2*/ <5.96397,10.0701,0.49735>

    /* stem 0.10.8.9*/ 
    /*0*/ <5.58783,10.31976,0.44125>,
    /*1*/ <5.58678,10.32115,0.43859>,<5.59088,10.32001,0.44208>,<5.58582,10.3181,0.44306>,
            
    /*2*/ <5.48465,10.72403,0.69533>

    /* stem 0.10.9*/ 
    /*0*/ <5.14321,8.6472,0.60312>,
    /*1*/ <5.14532,8.62995,0.63006>,<5.1473,8.67898,0.60407>,<5.13699,8.63266,0.57522>,
            
    /*2*/ <5.3684,8.60395,0.59208>,<5.37018,8.64808,0.56869>,<5.3609,8.6064,0.54273>,
            
    /*3*/ <5.58699,8.68064,0.55494>,<5.5711,8.71799,0.53687>,<5.57939,8.68268,0.51121>,
            
    /*4*/ <5.77128,8.81225,0.49661>,<5.74758,8.84012,0.48346>,<5.76004,8.81226,0.45939>,
            
    /*5*/ <5.92334,8.97343,0.43113>,<5.8985,8.9935,0.42163>,<5.91188,8.97211,0.39987>,
            
    /*6*/ <6.05134,9.15831,0.39323>,<6.02883,9.17279,0.38584>,<6.04329,9.15885,0.36667>,
            
    /*7*/ <6.16504,9.35342,0.35854>,<6.14619,9.36371,0.35286>,<6.15853,9.35375,0.33731>,
            
    /*8*/ <6.28628,9.54331,0.32924>,<6.27254,9.55166,0.32488>,<6.28169,9.54402,0.31324>,
            
    /*9*/ <6.40194,9.73887,0.326>,<6.39277,9.7444,0.32306>,<6.39951,9.74028,0.31525>,
            
    /*10*/ <6.47051,9.95554,0.34758>,<6.46549,9.95735,0.34604>,<6.46942,9.95649,0.34222>,
            
    /*11*/ <6.54242,10.17111,0.36341>

    /* stem 0.10.9.0*/ 
    /*0*/ <5.23365,8.63597,0.58883>,
    /*1*/ <5.2346,8.64901,0.58457>,<5.24103,8.62616,0.58263>,<5.22533,8.63274,0.59928>,
            
    /*2*/ <5.89933,8.77472,1.16126>

    /* stem 0.10.9.1*/ 
    /*0*/ <5.44607,8.64727,0.5553>,
    /*1*/ <5.44915,8.63594,0.54972>,<5.45437,8.65292,0.56358>,<5.43468,8.65297,0.55262>,
            
    /*2*/ <5.80123,9.05712,-0.08077>

    /* stem 0.10.9.2*/ 
    /*0*/ <5.82603,8.8908,0.45255>,
    /*1*/ <5.82565,8.8953,0.46303>,<5.82679,8.89763,0.44343>,<5.82564,8.87947,0.45117>,
            
    /*2*/ <6.54748,8.86158,0.49125>

    /* stem 0.10.9.3*/ 
    /*0*/ <5.99423,9.09699,0.39478>,
    /*1*/ <5.98984,9.09827,0.38535>,<6.00442,9.09903,0.39614>,<5.98843,9.09368,0.40286>,
            
    /*2*/ <5.84931,9.72001,0.5467>

    /* stem 0.10.9.4*/ 
    /*0*/ <6.11896,9.29384,0.36011>,
    /*1*/ <6.12678,9.28985,0.36415>,<6.11639,9.30286,0.36244>,<6.11371,9.28881,0.35375>,
            
    /*2*/ <6.45847,9.50623,-0.08782>

    /* stem 0.10.9.5*/ 
    /*0*/ <6.19388,9.4141,0.34139>,
    /*1*/ <6.18661,9.41918,0.3437>,<6.19904,9.41649,0.3342>,<6.196,9.40664,0.34627>,
            
    /*2*/ <6.52112,9.72858,0.68049>

    /* stem 0.10.9.6*/ 
    /*0*/ <6.41714,9.79948,0.32789>,
    /*1*/ <6.42039,9.79891,0.32344>,<6.41908,9.80197,0.33245>,<6.41194,9.79756,0.32779>,
            
    /*2*/ <6.27109,10.20451,0.16907>

    /* stem 0.10.9.7*/ 
    /*0*/ <6.49769,10.04129,0.35245>,
    /*1*/ <6.49777,10.0411,0.35437>,<6.49704,10.04294,0.35166>,<6.49827,10.03983,0.35131>,
            
    /*2*/ <6.86728,10.1875,0.35222>

    /* stem 0.10.10*/ 
    /*0*/ <5.70196,8.76612,0.6023>,
    /*1*/ <5.69716,8.78743,0.59545>,<5.71374,8.75207,0.58859>,<5.69499,8.75886,0.62286>,
            
    /*2*/ <5.87469,8.85214,0.67977>,<5.88962,8.82032,0.6736>,<5.87274,8.82643,0.70444>,
            
    /*3*/ <6.01073,8.96251,0.78087>,<6.03116,8.93825,0.78034>,<6.01078,8.9413,0.80445>,
            
    /*4*/ <6.16047,9.08967,0.83742>,<6.17881,9.06885,0.83655>,<6.16522,9.07441,0.86011>,
            
    /*5*/ <6.25954,9.25492,0.90145>,<6.27972,9.24242,0.90301>,<6.26518,9.24391,0.92178>,
            
    /*6*/ <6.34934,9.43463,0.94306>,<6.36694,9.42565,0.94473>,<6.35533,9.42776,0.96067>,
            
    /*7*/ <6.41226,9.62669,0.97981>,<6.42718,9.62161,0.98157>,<6.41753,9.62238,0.99413>,
            
    /*8*/ <6.42842,9.82761,1.0188>,<6.44012,9.82643,1.02059>,<6.43255,9.82528,1.0297>,
            
    /*9*/ <6.46129,10.02474,1.07541>,<6.46901,10.02324,1.07645>,<6.46395,10.02235,1.08248>,
            
    /*10*/ <6.49847,10.22755,1.08228>,<6.50234,10.22686,1.0828>,<6.49994,10.2272,1.08595>,
            
    /*11*/ <6.54579,10.42651,1.11551>

    /* stem 0.10.10.0*/ 
    /*0*/ <5.82845,8.81387,0.66205>,
    /*1*/ <5.83294,8.80593,0.65891>,<5.83042,8.81737,0.67083>,<5.82199,8.81832,0.65643>,
            
    /*2*/ <6.40487,9.26152,0.35408>

    /* stem 0.10.10.1*/ 
    /*0*/ <5.96776,8.90623,0.75167>,
    /*1*/ <5.96138,8.90841,0.75785>,<5.97282,8.9128,0.74782>,<5.96907,8.89749,0.74934>,
            
    /*2*/ <6.4724,8.83675,1.29688>

    /* stem 0.10.10.2*/ 
    /*0*/ <6.21356,9.15458,0.87378>,
    /*1*/ <6.21533,9.15646,0.86605>,<6.21928,9.15527,0.87954>,<6.20609,9.15202,0.87574>,
            
    /*2*/ <6.02939,9.77479,0.9828>

    /* stem 0.10.10.3*/ 
    /*0*/ <6.30123,9.3148,0.92388>,
    /*1*/ <6.30463,9.31177,0.93001>,<6.29837,9.32187,0.92421>,<6.30069,9.31076,0.91743>,
            
    /*2*/ <6.83724,9.54029,0.73784>

    /* stem 0.10.10.4*/ 
    /*0*/ <6.37325,9.47978,0.95875>,
    /*1*/ <6.36684,9.48219,0.95676>,<6.37916,9.48308,0.95649>,<6.37376,9.47408,0.96301>,
            
    /*2*/ <6.35868,9.81726,1.41345>

    /* stem 0.10.10.5*/ 
    /*0*/ <6.42576,9.71692,1.00259>,
    /*1*/ <6.43179,9.71691,1.0003>,<6.42433,9.72028,1.00792>,<6.42115,9.71357,0.99956>,
            
    /*2*/ <6.31848,10.12245,0.71816>

    /* stem 0.10.10.6*/ 
    /*0*/ <6.47478,10.08101,1.07968>,
    /*1*/ <6.47297,10.08123,1.08317>,<6.47417,10.08379,1.07697>,<6.4772,10.07801,1.07891>,
            
    /*2*/ <6.79472,10.29962,1.23194>

    /* stem 0.10.10.7*/ 
    /*0*/ <6.51937,10.31091,1.09705>,
    /*1*/ <6.51913,10.31116,1.09577>,<6.52051,10.3113,1.0976>,<6.51847,10.31025,1.09777>,
            
    /*2*/ <6.36618,10.62335,1.18872>

    /* stem 0.11*/ 
    /*0*/ <-0.03131,8.31982,-0.22538>,
    /*1*/ <-0.09099,8.30993,-0.32855>,<-0.03322,8.42748,-0.27745>,<0.0272,8.39625,-0.15439>,
            <0.00676,8.2594,-0.12944>,<-0.06629,8.20605,-0.23708>,
    /*2*/ <-0.69249,8.46293,0.01793>,<-0.6402,8.56932,0.06418>,<-0.58552,8.54106,0.17555>,
            <-0.60402,8.41721,0.19812>,<-0.67013,8.36892,0.10071>,
    /*3*/ <-1.28819,8.64213,0.3631>,<-1.23814,8.73645,0.4027>,<-1.18982,8.71132,0.50272>,
            <-1.20999,8.60145,0.52493>,<-1.27079,8.55869,0.43864>,
    /*4*/ <-1.8928,8.80917,0.69169>,<-1.85102,8.89314,0.72789>,<-1.81025,8.87153,0.81721>,
            <-1.82682,8.77422,0.8362>,<-1.87784,8.73568,0.75863>,
    /*5*/ <-2.44832,9.05606,1.07851>,<-2.40118,9.12496,1.10359>,<-2.36041,9.10414,1.17778>,
            <-2.38235,9.02237,1.19854>,<-2.43668,8.99265,1.13718>,
    /*6*/ <-2.99012,9.34013,1.43774>,<-2.94793,9.39739,1.45747>,<-2.91552,9.3808,1.52168>,
            <-2.93768,9.31328,1.54164>,<-2.98379,9.28814,1.48977>,
    /*7*/ <-3.48441,9.68651,1.82156>,<-3.44469,9.7303,1.83422>,<-3.41642,9.71558,1.8856>,
            <-3.43866,9.66271,1.90468>,<-3.48069,9.64474,1.8651>,
    /*8*/ <-3.99771,10.05254,2.13986>,<-3.96736,10.08709,2.15005>,<-3.94862,10.078,2.1923>,
            <-3.96738,10.03784,2.20821>,<-3.99773,10.02211,2.17581>,
    /*9*/ <-4.43769,10.5094,2.46746>,<-4.41218,10.53094,2.47236>,<-4.39813,10.52385,2.50222>,
            <-4.41497,10.49793,2.51577>,<-4.43941,10.489,2.49429>,
    /*10*/ <-4.87059,10.95788,2.81047>,<-4.85514,10.97085,2.81341>,<-4.84633,10.96623,2.83121>,
            <-4.85634,10.9504,2.83927>,<-4.87133,10.94524,2.82645>,
    /*11*/ <-5.32829,11.35292,3.18465>,<-5.32327,11.35767,3.1859>,<-5.32005,11.35591,3.1919>,
            <-5.32309,11.35006,3.19435>,<-5.32818,11.34821,3.18987>,
    /*12*/ <-5.32458,11.35295,3.18934>

    /* stem 0.11c0*/ 
    /*0*/ <-1.85175,8.81675,0.76632>,
    /*1*/ <-1.90975,8.80588,0.70444>,<-1.85698,8.88964,0.72192>,<-1.79697,8.87266,0.80077>,
            <-1.81266,8.77841,0.83202>,<-1.88237,8.73714,0.77248>,
    /*2*/ <-2.41234,9.03748,1.15056>,<-2.36658,9.11011,1.16571>,<-2.31455,9.09539,1.23409>,
            <-2.32816,9.01366,1.26119>,<-2.3886,8.97787,1.20956>,
    /*3*/ <-2.91944,9.30319,1.5685>,<-2.87911,9.36394,1.57999>,<-2.83734,9.35261,1.63978>,
            <-2.85185,9.28486,1.66524>,<-2.90259,9.25432,1.62119>,
    /*4*/ <-3.41844,9.59462,1.98341>,<-3.38387,9.64354,1.9916>,<-3.34977,9.63431,2.04066>,
            <-3.36327,9.57969,2.06279>,<-3.40571,9.55516,2.02741>,
    /*5*/ <-3.93959,9.867,2.37863>,<-3.91416,9.90594,2.38612>,<-3.88882,9.89945,2.42529>,
            <-3.89859,9.85652,2.442>,<-3.92997,9.83646,2.41317>,
    /*6*/ <-4.43867,10.15247,2.8>,<-4.41951,10.17985,2.80468>,<-4.40027,10.17459,2.83189>,
            <-4.40753,10.14396,2.84404>,<-4.43127,10.13029,2.82433>,
    /*7*/ <-4.94412,10.43752,3.2096>,<-4.93267,10.45413,3.21251>,<-4.92131,10.45111,3.22917>,
            <-4.92575,10.43263,3.23656>,<-4.93985,10.42423,3.22446>,
    /*8*/ <-5.41325,10.75235,3.64277>,<-5.40896,10.75788,3.64351>,<-5.40481,10.75668,3.64905>,
            <-5.40652,10.75042,3.65174>,<-5.41174,10.74775,3.64786>,
    /*9*/ <-5.40906,10.75302,3.64699>

    /* stem 0.11c0c0*/ 
    /*0*/ <-4.41945,10.15623,2.82099>,
    /*1*/ <-4.42541,10.15146,2.79331>,<-4.4075,10.1773,2.80558>,<-4.40611,10.17402,2.83914>,
            <-4.42316,10.14616,2.84761>,<-4.43508,10.13222,2.81929>,
    /*2*/ <-5.01839,10.53654,2.86638>,<-5.00757,10.55215,2.8738>,<-5.00673,10.55017,2.89407>,
            <-5.01703,10.53334,2.89919>,<-5.02424,10.52491,2.88208>,
    /*3*/ <-5.64954,10.85813,2.90939>,<-5.64649,10.8639,2.91199>,<-5.64642,10.86335,2.919>,
            <-5.64942,10.85723,2.92073>,<-5.65135,10.854,2.91479>,
    /*4*/ <-5.64864,10.85932,2.91518>

    /* stem 0.11c0c0.0*/ 
    /*0*/ <-4.7874,10.39306,2.85938>,
    /*1*/ <-4.78788,10.3958,2.83787>,<-4.78577,10.41027,2.87246>,<-4.78855,10.37311,2.86779>,
            
    /*2*/ <-5.00394,10.41087,2.84682>,<-5.00204,10.4239,2.87795>,<-5.00455,10.39045,2.87375>,
            
    /*3*/ <-5.20118,10.49897,2.86912>,<-5.19373,10.50937,2.8963>,<-5.20622,10.48219,2.89353>,
            
    /*4*/ <-5.38523,10.61074,2.89503>,<-5.37711,10.61907,2.91861>,<-5.39093,10.5968,2.91658>,
            
    /*5*/ <-5.54309,10.75652,2.92345>,<-5.53436,10.76237,2.94338>,<-5.54974,10.74595,2.94221>,
            
    /*6*/ <-5.66909,10.92863,2.96611>,<-5.65994,10.93153,2.98224>,<-5.67513,10.9205,2.98192>,
            
    /*7*/ <-5.77501,11.11094,3.01852>,<-5.76693,11.11216,3.03112>,<-5.77991,11.1046,3.03122>,
            
    /*8*/ <-5.87165,11.29999,3.06003>,<-5.86568,11.30107,3.06952>,<-5.87569,11.29591,3.06972>,
            
    /*9*/ <-5.96485,11.48443,3.12814>,<-5.9605,11.48444,3.13426>,<-5.96718,11.48101,3.13441>,
            
    /*10*/ <-6.0519,11.66758,3.20531>,<-6.04964,11.66743,3.2083>,<-6.05301,11.66578,3.20841>,
            
    /*11*/ <-6.12211,11.86639,3.25441>

    /* stem 0.11c0c0.0.0*/ 
    /*0*/ <-4.90758,10.4016,2.86316>,
    /*1*/ <-4.90699,10.40657,2.8709>,<-4.91339,10.39445,2.8627>,<-4.90237,10.40377,2.85587>,
            
    /*2*/ <-5.51187,10.91028,2.58298>

    /* stem 0.11c0c0.0.1*/ 
    /*0*/ <-5.28492,10.5483,2.89723>,
    /*1*/ <-5.28926,10.54161,2.89519>,<-5.28637,10.55547,2.89344>,<-5.27914,10.54784,2.90307>,
            
    /*2*/ <-5.7889,10.71825,3.41045>

    /* stem 0.11c0c0.0.2*/ 
    /*0*/ <-5.46697,10.6852,2.9238>,
    /*1*/ <-5.46264,10.69051,2.92034>,<-5.47103,10.68704,2.93005>,<-5.46725,10.67806,2.92101>,
            
    /*2*/ <-5.99669,10.8598,2.52822>

    /* stem 0.11c0c0.0.3*/ 
    /*0*/ <-5.62919,10.87371,2.96426>,
    /*1*/ <-5.63051,10.87122,2.97073>,<-5.6344,10.87655,2.96044>,<-5.62266,10.87335,2.9616>,
            
    /*2*/ <-5.50027,11.43354,3.20535>

    /* stem 0.11c0c0.0.4*/ 
    /*0*/ <-5.80429,11.16855,3.03929>,
    /*1*/ <-5.80675,11.16848,3.03361>,<-5.80197,11.17381,3.0416>,<-5.80416,11.16336,3.04267>,
            
    /*2*/ <-6.28651,11.29064,3.24594>

    /* stem 0.11c0c0.0.5*/ 
    /*0*/ <-5.92099,11.39786,3.10175>,
    /*1*/ <-5.91646,11.39928,3.1042>,<-5.92565,11.39824,3.10433>,<-5.92086,11.39607,3.09672>,
            
    /*2*/ <-5.97334,11.84213,2.94209>

    /* stem 0.11c0c0.0.6*/ 
    /*0*/ <-6.09363,11.78592,3.23542>,
    /*1*/ <-6.09442,11.7856,3.23562>,<-6.09357,11.78665,3.23494>,<-6.09291,11.78552,3.2357>,
            
    /*2*/ <-6.10112,11.99003,3.5413>

    /* stem 0.11c0.0*/ 
    /*0*/ <-2.04793,8.90523,0.93467>,
    /*1*/ <-2.0209,8.87265,0.9833>,<-2.11096,8.89885,0.9227>,<-2.01194,8.94419,0.89802>,
            
    /*2*/ <-2.09319,9.14829,1.19962>,<-2.17425,9.17187,1.14508>,<-2.08512,9.21267,1.12287>,
            
    /*3*/ <-2.19858,9.40192,1.42739>,<-2.2695,9.42036,1.37629>,<-2.19257,9.46388,1.36331>,
            
    /*4*/ <-2.25848,9.70141,1.62174>,<-2.32109,9.71858,1.57819>,<-2.25069,9.74581,1.55787>,
            
    /*5*/ <-2.36049,10.01378,1.77897>,<-2.41159,10.01981,1.73606>,<-2.35204,10.04671,1.72123>,
            
    /*6*/ <-2.44403,10.32605,1.93148>,<-2.48713,10.33256,1.89657>,<-2.43686,10.35269,1.88293>,
            
    /*7*/ <-2.48587,10.66331,2.04965>,<-2.52053,10.66939,2.02215>,<-2.47918,10.67929,2.00848>,
            
    /*8*/ <-2.53967,10.99854,2.16405>,<-2.56553,11.00212,2.14305>,<-2.53463,11.01045,2.13315>,
            
    /*9*/ <-2.60779,11.33774,2.25988>,<-2.62477,11.33878,2.24542>,<-2.60423,11.34473,2.23897>,
            
    /*10*/ <-2.66654,11.67707,2.35631>,<-2.67508,11.67781,2.34915>,<-2.66477,11.68054,2.34585>,
            
    /*11*/ <-2.64475,12.01413,2.47172>

    /* stem 0.11c0.0.0*/ 
    /*0*/ <-2.09758,9.09957,1.09248>,
    /*1*/ <-2.1218,9.10299,1.08064>,<-2.0835,9.12114,1.10112>,<-2.08744,9.07456,1.09569>,
            
    /*2*/ <-2.70817,9.00885,2.31507>

    /* stem 0.11c0.0.1*/ 
    /*0*/ <-2.19164,9.35885,1.32413>,
    /*1*/ <-2.16805,9.36883,1.32378>,<-2.20263,9.35274,1.34646>,<-2.20425,9.35499,1.30216>,
            
    /*2*/ <-2.68949,10.53877,1.40202>

    /* stem 0.11c0.0.2*/ 
    /*0*/ <-2.24283,9.54603,1.46779>,
    /*1*/ <-2.25703,9.53303,1.48306>,<-2.2514,9.56671,1.45766>,<-2.22007,9.53834,1.46263>,
            
    /*2*/ <-1.81073,10.18918,2.41633>

    /* stem 0.11c0.0.3*/ 
    /*0*/ <-2.32134,9.86068,1.65852>,
    /*1*/ <-2.32229,9.87106,1.6381>,<-2.31048,9.87077,1.67602>,<-2.33124,9.8402,1.66145>,
            
    /*2*/ <-3.28709,10.37152,1.96313>

    /* stem 0.11c0.0.4*/ 
    /*0*/ <-2.40429,10.1397,1.80301>,
    /*1*/ <-2.39016,10.13542,1.81865>,<-2.42402,10.14669,1.80795>,<-2.39869,10.13698,1.78242>,
            
    /*2*/ <-2.06005,11.13748,1.76473>

    /* stem 0.11c0.0.5*/ 
    /*0*/ <-2.43796,10.2682,1.86853>,
    /*1*/ <-2.45809,10.26526,1.86394>,<-2.42883,10.28644,1.86421>,<-2.42695,10.25289,1.87743>,
            
    /*2*/ <-2.69904,10.61732,2.79138>

    /* stem 0.11c0.0.6*/ 
    /*0*/ <-2.48329,10.56935,1.98937>,
    /*1*/ <-2.46682,10.57455,1.98054>,<-2.48658,10.57475,2.00771>,<-2.49647,10.55875,1.97987>,
            
    /*2*/ <-2.89657,11.35817,1.68282>

    /* stem 0.11c0.0.7*/ 
    /*0*/ <-2.52382,10.85608,2.09356>,
    /*1*/ <-2.52955,10.84952,2.10934>,<-2.53357,10.86852,2.0849>,<-2.50833,10.85021,2.08645>,
            
    /*2*/ <-2.09405,11.48391,2.51122>

    /* stem 0.11c0.0.8*/ 
    /*0*/ <-2.57775,11.16339,2.19481>,
    /*1*/ <-2.5834,11.16677,2.17992>,<-2.56692,11.17331,2.20186>,<-2.58292,11.15009,2.20265>,
            
    /*2*/ <-3.1673,11.58035,2.51317>

    /* stem 0.11c0.0.9*/ 
    /*0*/ <-2.6299,11.44586,2.28001>,
    /*1*/ <-2.62052,11.44575,2.28554>,<-2.63914,11.44868,2.28502>,<-2.63003,11.44314,2.26947>,
            
    /*2*/ <-2.51691,12.13133,2.10166>

    /* stem 0.11c0.0.10*/ 
    /*0*/ <-2.66085,11.78939,2.39052>,
    /*1*/ <-2.66507,11.78938,2.3914>,<-2.65896,11.79299,2.38905>,<-2.65851,11.78581,2.39111>,
            
    /*2*/ <-2.53836,11.9669,2.98226>

    /* stem 0.11c0.1*/ 
    /*0*/ <-2.63558,9.18731,1.42194>,
    /*1*/ <-2.67475,9.17917,1.37797>,<-2.62248,9.24232,1.44027>,<-2.60951,9.14044,1.44757>,
            
    /*2*/ <-2.91322,9.16478,1.60112>,<-2.86617,9.22161,1.65719>,<-2.85449,9.12992,1.66376>,
            
    /*3*/ <-3.17517,9.23148,1.77198>,<-3.13179,9.28011,1.82235>,<-3.14018,9.2,1.83958>,
            
    /*4*/ <-3.40124,9.38953,1.95881>,<-3.34911,9.42643,1.99222>,<-3.3715,9.36339,2.01904>,
            
    /*5*/ <-3.60304,9.58128,2.13222>,<-3.55494,9.61021,2.15803>,<-3.57912,9.56025,2.18516>,
            
    /*6*/ <-3.79987,9.8207,2.21211>,<-3.7613,9.84587,2.23511>,<-3.79017,9.81284,2.26205>,
            
    /*7*/ <-3.99623,10.0699,2.29128>,<-3.96498,10.08957,2.30954>,<-3.98873,10.06393,2.33134>,
            
    /*8*/ <-4.15269,10.35187,2.34962>,<-4.12735,10.36379,2.36265>,<-4.14801,10.34874,2.37999>,
            
    /*9*/ <-4.27156,10.64229,2.45194>,<-4.25322,10.64737,2.45979>,<-4.26707,10.63759,2.47148>,
            
    /*10*/ <-4.36201,10.9473,2.52661>,<-4.35265,10.94933,2.5304>,<-4.36001,10.94563,2.53658>,
            
    /*11*/ <-4.40904,11.25558,2.62758>

    /* stem 0.11c0.1.0*/ 
    /*0*/ <-2.75168,9.18003,1.52672>,
    /*1*/ <-2.74092,9.19883,1.53995>,<-2.76246,9.16052,1.53887>,<-2.75165,9.18073,1.50134>,
            
    /*2*/ <-3.85867,9.80197,1.54275>

    /* stem 0.11c0.1.1*/ 
    /*0*/ <-3.04389,9.21195,1.74512>,
    /*1*/ <-3.04854,9.18867,1.74661>,<-3.06093,9.22707,1.7383>,<-3.0222,9.2201,1.75046>,
            
    /*2*/ <-3.37266,9.3495,2.87102>

    /* stem 0.11c0.1.2*/ 
    /*0*/ <-3.30779,9.34725,1.93745>,
    /*1*/ <-3.30909,9.36312,1.92195>,<-3.30759,9.35273,1.95898>,<-3.30668,9.32589,1.93141>,
            
    /*2*/ <-4.40074,9.283,1.96382>

    /* stem 0.11c0.1.3*/ 
    /*0*/ <-3.48724,9.49852,2.08308>,
    /*1*/ <-3.47677,9.49417,2.10076>,<-3.50817,9.50029,2.08343>,<-3.47679,9.50109,2.06504>,
            
    /*2*/ <-3.39854,10.50469,2.27819>

    /* stem 0.11c0.1.4*/ 
    /*0*/ <-3.64525,9.66236,2.18368>,
    /*1*/ <-3.65918,9.65437,2.17195>,<-3.64023,9.68148,2.18155>,<-3.63633,9.65122,2.19754>,
            
    /*2*/ <-4.32744,9.91273,2.82358>

    /* stem 0.11c0.1.5*/ 
    /*0*/ <-3.91912,9.99468,2.28682>,
    /*1*/ <-3.90531,10.00606,2.28593>,<-3.92921,9.99398,2.3016>,<-3.92284,9.98401,2.27292>,
            
    /*2*/ <-4.43894,10.60006,1.96076>

    /* stem 0.11c0.1.6*/ 
    /*0*/ <-4.05065,10.19291,2.33327>,
    /*1*/ <-4.06009,10.18532,2.34493>,<-4.05793,10.20222,2.32131>,<-4.03392,10.19118,2.33355>,
            
    /*2*/ <-3.99161,10.84206,2.80326>

    /* stem 0.11c0.1.7*/ 
    /*0*/ <-4.22567,10.55163,2.43045>,
    /*1*/ <-4.22647,10.55571,2.41733>,<-4.21895,10.55933,2.43967>,<-4.2316,10.53983,2.43436>,
            
    /*2*/ <-4.82152,10.89888,2.57492>

    /* stem 0.11c0.1.8*/ 
    /*0*/ <-4.29012,10.7271,2.48054>,
    /*1*/ <-4.2836,10.7273,2.48843>,<-4.29944,10.73124,2.48149>,<-4.28733,10.72275,2.4717>,
            
    /*2*/ <-4.0547,11.30488,2.27125>

    /* stem 0.11c0.1.9*/ 
    /*0*/ <-4.39589,11.17585,2.60264>,
    /*1*/ <-4.3974,11.17568,2.60238>,<-4.39518,11.17714,2.60219>,<-4.3951,11.17473,2.60334>,
            
    /*2*/ <-4.50333,11.40303,3.08429>

    /* stem 0.11c0.2*/ 
    /*0*/ <-3.0362,9.40229,1.74186>,
    /*1*/ <-2.99962,9.44051,1.76018>,<-3.06113,9.36773,1.77818>,<-3.04786,9.39863,1.68722>,
            
    /*2*/ <-3.23096,9.63777,1.79345>,<-3.28631,9.57227,1.80964>,<-3.27437,9.60008,1.72779>,
            
    /*3*/ <-3.39461,9.87376,1.84982>,<-3.45511,9.82858,1.86763>,<-3.44512,9.85307,1.7947>,
            
    /*4*/ <-3.54318,10.13355,1.89407>,<-3.59958,10.09968,1.91078>,<-3.58836,10.11713,1.84615>,
            
    /*5*/ <-3.65689,10.41371,1.87393>,<-3.70975,10.39427,1.88855>,<-3.69409,10.39665,1.83257>,
            
    /*6*/ <-3.81102,10.68152,1.84271>,<-3.85257,10.6599,1.85526>,<-3.83946,10.662,1.80863>,
            
    /*7*/ <-3.91701,10.96224,1.81364>,<-3.95269,10.95038,1.82315>,<-3.94163,10.95072,1.78597>,
            
    /*8*/ <-4.03722,11.24162,1.77161>,<-4.06366,11.23184,1.77881>,<-4.05504,11.23136,1.75103>,
            
    /*9*/ <-4.14405,11.52507,1.79839>,<-4.16157,11.51833,1.80327>,<-4.15732,11.52169,1.78465>,
            
    /*10*/ <-4.21118,11.81468,1.86227>,<-4.22017,11.81217,1.86488>,<-4.2183,11.81463,1.85569>,
            
    /*11*/ <-4.30677,12.09323,1.94637>

    /* stem 0.11c0.2.0*/ 
    /*0*/ <-3.15523,9.50741,1.76021>,
    /*1*/ <-3.16926,9.49005,1.76861>,<-3.16386,9.52321,1.74457>,<-3.13256,9.50897,1.76745>,
            
    /*2*/ <-3.48904,10.20986,2.65398>

    /* stem 0.11c0.2.1*/ 
    /*0*/ <-3.36012,9.74591,1.81163>,
    /*1*/ <-3.35405,9.7548,1.79193>,<-3.35996,9.75856,1.83017>,<-3.36634,9.72437,1.81278>,
            
    /*2*/ <-4.41093,10.03926,1.62028>

    /* stem 0.11c0.2.2*/ 
    /*0*/ <-3.50145,9.97906,1.85961>,
    /*1*/ <-3.49532,9.97888,1.87993>,<-3.52052,9.98677,1.85434>,<-3.48852,9.97153,1.84455>,
            
    /*2*/ <-3.08592,10.92648,1.74276>

    /* stem 0.11c0.2.3*/ 
    /*0*/ <-3.65322,10.31423,1.87073>,
    /*1*/ <-3.66786,10.30783,1.8594>,<-3.64224,10.32937,1.86493>,<-3.64956,10.30547,1.88787>,
            
    /*2*/ <-4.25123,10.91442,2.30504>

    /* stem 0.11c0.2.4*/ 
    /*0*/ <-3.78866,10.5853,1.84467>,
    /*1*/ <-3.7727,10.59396,1.84306>,<-3.80171,10.59216,1.85539>,<-3.79157,10.56979,1.83555>,
            
    /*2*/ <-4.10599,11.04404,1.16541>

    /* stem 0.11c0.2.5*/ 
    /*0*/ <-3.8791,10.79263,1.82336>,
    /*1*/ <-3.89107,10.7895,1.83532>,<-3.88324,10.80134,1.80912>,<-3.86299,10.78704,1.82565>,
            
    /*2*/ <-3.68734,11.50006,2.20037>

    /* stem 0.11c0.2.6*/ 
    /*0*/ <-4.01426,11.14284,1.78043>,
    /*1*/ <-4.0121,11.14152,1.76514>,<-4.00905,11.15535,1.78793>,<-4.02162,11.13165,1.7882>,
            
    /*2*/ <-4.6541,11.48101,1.66091>

    /* stem 0.11c0.2.7*/ 
    /*0*/ <-4.0883,11.33674,1.77719>,
    /*1*/ <-4.08015,11.33847,1.7891>,<-4.1026,11.33929,1.77774>,<-4.08216,11.33245,1.76474>,
            
    /*2*/ <-3.9785,11.98939,1.60694>

    /* stem 0.11c0.2.8*/ 
    /*0*/ <-4.18752,11.67757,1.83039>,
    /*1*/ <-4.1954,11.67632,1.82845>,<-4.18347,11.68395,1.8272>,<-4.1837,11.67242,1.83552>,
            
    /*2*/ <-4.35486,12.01494,2.29346>

    /* stem 0.11c0.2.9*/ 
    /*0*/ <-4.28065,12.01235,1.92164>,
    /*1*/ <-4.27931,12.01299,1.921>,<-4.28104,12.01267,1.92319>,<-4.28162,12.01141,1.92074>,
            
    /*2*/ <-4.54463,12.42326,1.77304>

    /* stem 0.11c0.3*/ 
    /*0*/ <-3.62977,9.7273,2.20088>,
    /*1*/ <-3.64428,9.68465,2.21093>,<-3.65807,9.75687,2.17952>,<-3.58697,9.74039,2.21218>,
            
    /*2*/ <-3.73422,9.77738,2.4535>,<-3.74663,9.84238,2.42523>,<-3.68264,9.82755,2.45463>,
            
    /*3*/ <-3.85517,9.91653,2.66528>,<-3.85982,9.96913,2.62919>,<-3.8078,9.95952,2.66515>,
            
    /*4*/ <-4.00438,10.10504,2.81226>,<-3.99957,10.14224,2.77073>,<-3.96129,10.14075,2.81153>,
            
    /*5*/ <-4.10765,10.33669,2.93627>,<-4.09971,10.36223,2.89644>,<-4.06576,10.35927,2.9302>,
            
    /*6*/ <-4.2137,10.5829,3.01051>,<-4.20424,10.59833,2.97487>,<-4.17819,10.60045,3.00512>,
            
    /*7*/ <-4.31796,10.83101,3.07036>,<-4.30973,10.84195,3.04145>,<-4.28934,10.84461,3.06596>,
            
    /*8*/ <-4.39279,11.09204,3.12391>,<-4.3861,11.09883,3.1019>,<-4.37037,11.09963,3.11999>,
            
    /*9*/ <-4.4779,11.34539,3.18472>,<-4.47366,11.35056,3.17019>,<-4.46319,11.35118,3.18227>,
            
    /*10*/ <-4.5439,11.60145,3.26026>,<-4.54185,11.60423,3.25305>,<-4.53641,11.6039,3.2589>,
            
    /*11*/ <-4.60708,11.86045,3.32759>

    /* stem 0.11c0.3.0*/ 
    /*0*/ <-3.67694,9.77296,2.32658>,
    /*1*/ <-3.68345,9.78949,2.31814>,<-3.66478,9.77393,2.34202>,<-3.68259,9.75546,2.31959>,
            
    /*2*/ <-4.51383,9.78007,2.98541>

    /* stem 0.11c0.3.1*/ 
    /*0*/ <-3.79183,9.89402,2.56763>,
    /*1*/ <-3.77826,9.88851,2.57891>,<-3.80949,9.89148,2.57248>,<-3.78774,9.90207,2.55149>,
            
    /*2*/ <-3.79829,10.78449,3.00996>

    /* stem 0.11c0.3.2*/ 
    /*0*/ <-3.93735,10.0667,2.74799>,
    /*1*/ <-3.95189,10.06059,2.74083>,<-3.9357,10.08365,2.7511>,<-3.92448,10.05586,2.75203>,
            
    /*2*/ <-4.3016,9.94794,3.58898>

    /* stem 0.11c0.3.3*/ 
    /*0*/ <-4.06393,10.29371,2.88853>,
    /*1*/ <-4.05095,10.30214,2.88405>,<-4.07063,10.2963,2.90294>,<-4.0702,10.2827,2.87859>,
            
    /*2*/ <-4.56902,10.88975,2.54668>

    /* stem 0.11c0.3.4*/ 
    /*0*/ <-4.13517,10.45156,2.95206>,
    /*1*/ <-4.14111,10.44497,2.96458>,<-4.14412,10.45989,2.94279>,<-4.12027,10.44982,2.94882>,
            
    /*2*/ <-3.96419,11.11417,3.38233>

    /* stem 0.11c0.3.5*/ 
    /*0*/ <-4.35765,11.01216,3.09686>,
    /*1*/ <-4.36043,11.01401,3.08453>,<-4.3512,11.02107,3.10336>,<-4.36133,11.00141,3.1027>,
            
    /*2*/ <-4.92585,11.29925,3.26791>

    /* stem 0.11c0.3.6*/ 
    /*0*/ <-4.4353,11.24564,3.15291>,
    /*1*/ <-4.42681,11.24683,3.16>,<-4.44545,11.24922,3.15574>,<-4.43365,11.24088,3.14299>,
            
    /*2*/ <-4.31253,11.78152,2.91609>

    /* stem 0.11c0.3.7*/ 
    /*0*/ <-4.49882,11.44915,3.20992>,
    /*1*/ <-4.50597,11.4472,3.20995>,<-4.4968,11.45581,3.20736>,<-4.49368,11.44444,3.21245>,
            
    /*2*/ <-4.55388,11.65828,3.71082>

    /* stem 0.11c0.3.8*/ 
    /*0*/ <-4.56942,11.71444,3.28775>,
    /*1*/ <-4.56759,11.71535,3.28611>,<-4.56989,11.71568,3.29001>,<-4.57077,11.71228,3.28714>,
            
    /*2*/ <-4.89958,11.98221,3.07116>

    /* stem 0.11c0.4*/ 
    /*0*/ <-4.22363,10.04648,2.66132>,
    /*1*/ <-4.22854,10.07034,2.63889>,<-4.21536,10.0544,2.69238>,<-4.22698,10.0147,2.65267>,
            
    /*2*/ <-4.46408,10.07638,2.70179>,<-4.45222,10.06203,2.74993>,<-4.46268,10.0263,2.71419>,
            
    /*3*/ <-4.66794,10.16052,2.79695>,<-4.65403,10.14821,2.8389>,<-4.67817,10.11886,2.8132>,
            
    /*4*/ <-4.83373,10.30356,2.89492>,<-4.82156,10.29321,2.93174>,<-4.85045,10.27215,2.91349>,
            
    /*5*/ <-4.97654,10.47296,2.99265>,<-4.96603,10.46419,3.02421>,<-4.99359,10.44892,3.0104>,
            
    /*6*/ <-5.12642,10.6486,3.06484>,<-5.11977,10.64347,3.09225>,<-5.14176,10.62972,3.08002>,
            
    /*7*/ <-5.25111,10.84832,3.11965>,<-5.24661,10.84534,3.14194>,<-5.26546,10.83609,3.13271>,
            
    /*8*/ <-5.35457,11.05755,3.19144>,<-5.35051,11.05417,3.20781>,<-5.36559,11.04891,3.20143>,
            
    /*9*/ <-5.44115,11.27311,3.26497>,<-5.43835,11.27069,3.27583>,<-5.44872,11.26789,3.27181>,
            
    /*10*/ <-5.47944,11.49113,3.36822>,<-5.47778,11.48908,3.37331>,<-5.48331,11.48883,3.37178>,
            
    /*11*/ <-5.51037,11.71315,3.46389>

    /* stem 0.11c0.4.0*/ 
    /*0*/ <-4.35061,10.05101,2.69395>,
    /*1*/ <-4.34717,10.0495,2.70753>,<-4.36178,10.04421,2.68871>,<-4.34287,10.05932,2.6856>,
            
    /*2*/ <-4.90111,10.78527,2.91471>

    /* stem 0.11c0.4.1*/ 
    /*0*/ <-4.53178,10.08542,2.75484>,
    /*1*/ <-4.53885,10.07853,2.74571>,<-4.53404,10.09857,2.75659>,<-4.52243,10.07917,2.76222>,
            
    /*2*/ <-5.14939,9.89613,3.37644>

    /* stem 0.11c0.4.2*/ 
    /*0*/ <-4.89364,10.3598,2.95234>,
    /*1*/ <-4.8848,10.36759,2.95156>,<-4.90067,10.35977,2.96183>,<-4.89546,10.35204,2.94362>,
            
    /*2*/ <-5.36869,10.86394,2.60258>

    /* stem 0.11c0.4.3*/ 
    /*0*/ <-5.06077,10.55931,3.0472>,
    /*1*/ <-5.06542,10.55258,3.05439>,<-5.06687,10.56652,3.04175>,<-5.05003,10.55884,3.04545>,
            
    /*2*/ <-4.95609,11.03639,3.56168>

    /* stem 0.11c0.4.4*/ 
    /*0*/ <-5.20288,10.75978,3.10985>,
    /*1*/ <-5.20336,10.76202,3.10007>,<-5.20029,10.76686,3.1165>,<-5.20498,10.75047,3.11299>,
            
    /*2*/ <-5.82651,10.92344,3.178>

    /* stem 0.11c0.4.5*/ 
    /*0*/ <-5.32831,10.99489,3.18104>,
    /*1*/ <-5.32245,10.99547,3.18801>,<-5.3369,10.99777,3.18206>,<-5.32557,10.99144,3.17306>,
            
    /*2*/ <-5.17108,11.52682,3.00467>

    /* stem 0.11c0.4.6*/ 
    /*0*/ <-5.4557,11.3464,3.30556>,
    /*1*/ <-5.4611,11.34575,3.30495>,<-5.45325,11.35092,3.30368>,<-5.45274,11.34252,3.30805>,
            
    /*2*/ <-5.52988,11.56489,3.73436>

    /* stem 0.11c0.4.7*/ 
    /*0*/ <-5.49145,11.57313,3.40575>,
    /*1*/ <-5.4898,11.57379,3.40468>,<-5.4916,11.57353,3.40778>,<-5.49295,11.57206,3.40479>,
            
    /*2*/ <-5.69528,11.9379,3.31876>

    /* stem 0.11c0.5*/ 
    /*0*/ <-4.77817,10.35449,3.10156>,
    /*1*/ <-4.7669,10.35076,3.1186>,<-4.79758,10.34726,3.10016>,<-4.77002,10.36546,3.08593>,
            
    /*2*/ <-4.84192,10.53212,3.20538>,<-4.86952,10.52897,3.18879>,<-4.84472,10.54535,3.17598>,
            
    /*3*/ <-4.94003,10.70407,3.29085>,<-4.96339,10.699,3.27484>,<-4.94245,10.71595,3.26475>,
            
    /*4*/ <-5.03079,10.88281,3.36826>,<-5.05137,10.87864,3.35437>,<-5.03242,10.89231,3.34501>,
            
    /*5*/ <-5.11985,11.06744,3.43398>,<-5.1373,11.06353,3.42191>,<-5.12068,11.0745,3.4136>,
            
    /*6*/ <-5.20274,11.25595,3.49467>,<-5.21738,11.2529,3.48468>,<-5.20324,11.26142,3.47754>,
            
    /*7*/ <-5.28163,11.44706,3.55231>,<-5.29339,11.44474,3.54436>,<-5.28194,11.45122,3.53854>,
            
    /*8*/ <-5.35716,11.64656,3.5827>,<-5.36577,11.64433,3.5766>,<-5.35685,11.64839,3.57207>,
            
    /*9*/ <-5.40269,11.85675,3.57609>,<-5.40847,11.85543,3.57202>,<-5.40211,11.85671,3.56892>,
            
    /*10*/ <-5.40596,12.07075,3.57984>,<-5.40893,12.07077,3.57781>,<-5.40569,12.07085,3.57625>,
            
    /*11*/ <-5.41188,12.28522,3.58444>

    /* stem 0.11c0.5.0*/ 
    /*0*/ <-4.81347,10.44097,3.14384>,
    /*1*/ <-4.82153,10.43931,3.14053>,<-4.81045,10.4493,3.14418>,<-4.80844,10.43431,3.14683>,
            
    /*2*/ <-5.14508,10.53048,3.90353>

    /* stem 0.11c0.5.1*/ 
    /*0*/ <-4.97327,10.75539,3.29857>,
    /*1*/ <-4.96666,10.75949,3.29683>,<-4.97679,10.75632,3.30567>,<-4.97637,10.75035,3.29322>,
            
    /*2*/ <-5.3865,11.30466,3.02132>

    /* stem 0.11c0.5.2*/ 
    /*0*/ <-5.06928,10.94973,3.37971>,
    /*1*/ <-5.07242,10.94614,3.38542>,<-5.073,10.95514,3.37622>,<-5.06241,10.94791,3.3775>,
            
    /*2*/ <-4.80714,11.4109,3.81404>

    /* stem 0.11c0.5.3*/ 
    /*0*/ <-5.17405,11.17915,3.45988>,
    /*1*/ <-5.17533,11.18075,3.45338>,<-5.17124,11.18376,3.46403>,<-5.17558,11.17294,3.46222>,
            
    /*2*/ <-5.74071,11.37913,3.6207>

    /* stem 0.11c0.5.4*/ 
    /*0*/ <-5.31747,11.53281,3.5588>,
    /*1*/ <-5.31336,11.53369,3.5629>,<-5.32311,11.53395,3.56>,<-5.31595,11.5308,3.5535>,
            
    /*2*/ <-5.25381,12.02799,3.38921>

    /* stem 0.11c0.5.5*/ 
    /*0*/ <-5.38972,11.78693,3.57393>,
    /*1*/ <-5.39443,11.78592,3.57355>,<-5.38769,11.79019,3.57097>,<-5.38702,11.78469,3.57726>,
            
    /*2*/ <-5.48587,12.12281,3.8783>

    /* stem 0.11c0.5.6*/ 
    /*0*/ <-5.40903,12.16356,3.58077>,
    /*1*/ <-5.40808,12.16361,3.58008>,<-5.40905,12.16413,3.5818>,<-5.40998,12.16295,3.58042>,
            
    /*2*/ <-5.54404,12.46663,3.41131>

    /* stem 0.11c1*/ 
    /*0*/ <-3.45297,9.68797,1.86223>,
    /*1*/ <-3.49797,9.68695,1.83735>,<-3.45284,9.72597,1.82758>,<-3.40789,9.71247,1.8657>,
            <-3.42525,9.66511,1.89903>,<-3.48092,9.64934,1.88151>,
    /*2*/ <-3.76516,10.1287,2.32595>,<-3.73,10.1591,2.31833>,<-3.69498,10.14858,2.34803>,
            <-3.70851,10.11169,2.374>,<-3.75188,10.0994,2.36035>,
    /*3*/ <-4.0048,10.59554,2.80717>,<-3.97893,10.61616,2.80051>,<-3.95368,10.6083,2.82147>,
            <-3.96394,10.58283,2.84107>,<-3.99553,10.57494,2.83224>,
    /*4*/ <-4.24463,11.08212,3.26583>,<-4.22884,11.09426,3.2615>,<-4.21377,11.08988,3.27451>,
            <-4.22024,11.07503,3.28688>,<-4.23932,11.07023,3.28152>,
    /*5*/ <-4.49568,11.59223,3.69143>,<-4.49019,11.59633,3.68986>,<-4.48511,11.59507,3.69456>,
            <-4.48746,11.59018,3.69903>,<-4.49399,11.58842,3.6971>,
    /*6*/ <-4.49049,11.59245,3.6944>

    /* stem 0.11c1.0*/ 
    /*0*/ <-3.8054,10.27026,2.48885>,
    /*1*/ <-3.81198,10.29421,2.46192>,<-3.78232,10.27903,2.51592>,<-3.8219,10.23756,2.48872>,
            
    /*2*/ <-4.00317,10.38806,2.59702>,<-3.97648,10.3744,2.64563>,<-4.0121,10.33708,2.62115>,
            
    /*3*/ <-4.16862,10.54564,2.67612>,<-4.15314,10.53862,2.72395>,<-4.18987,10.5094,2.70462>,
            
    /*4*/ <-4.31721,10.73798,2.69946>,<-4.31028,10.73857,2.74333>,<-4.34371,10.71469,2.72644>,
            
    /*5*/ <-4.43654,10.95076,2.67009>,<-4.43486,10.95734,2.70755>,<-4.46455,10.9386,2.69283>,
            
    /*6*/ <-4.53288,11.18268,2.6499>,<-4.53078,11.18673,2.6813>,<-4.55722,11.17464,2.66859>,
            
    /*7*/ <-4.6449,11.41129,2.66897>,<-4.64165,11.4111,2.69414>,<-4.66288,11.40155,2.68402>,
            
    /*8*/ <-4.73133,11.64625,2.70002>,<-4.72844,11.64508,2.7188>,<-4.7452,11.6399,2.71141>,
            
    /*9*/ <-4.8069,11.88433,2.73463>,<-4.8049,11.88333,2.74712>,<-4.81626,11.88042,2.74227>,
            
    /*10*/ <-4.86538,12.12862,2.74247>,<-4.86453,12.1287,2.74876>,<-4.87025,12.12741,2.74635>,
            
    /*11*/ <-4.89944,12.37409,2.79164>

    /* stem 0.11c1.0.0*/ 
    /*0*/ <-3.95463,10.34513,2.59185>,
    /*1*/ <-3.94635,10.34389,2.60475>,<-3.96952,10.34128,2.59187>,<-3.94802,10.35022,2.57892>,
            
    /*2*/ <-4.18773,11.24776,2.82816>

    /* stem 0.11c1.0.1*/ 
    /*0*/ <-4.09199,10.45656,2.66516>,
    /*1*/ <-4.1023,10.44947,2.65743>,<-4.08993,10.47099,2.6632>,<-4.08372,10.44921,2.67486>,
            
    /*2*/ <-4.70515,10.63306,3.32125>

    /* stem 0.11c1.0.2*/ 
    /*0*/ <-4.36799,10.80995,2.71109>,
    /*1*/ <-4.35652,10.81609,2.7095>,<-4.37682,10.81464,2.71958>,<-4.37064,10.79911,2.7042>,
            
    /*2*/ <-4.69042,11.26048,2.12681>

    /* stem 0.11c1.0.3*/ 
    /*0*/ <-4.47941,11.03233,2.6817>,
    /*1*/ <-4.48754,11.0299,2.6905>,<-4.48316,11.03689,2.67099>,<-4.46752,11.03021,2.68361>,
            
    /*2*/ <-4.3987,11.72362,2.94738>

    /* stem 0.11c1.0.4*/ 
    /*0*/ <-4.60583,11.31697,2.67604>,
    /*1*/ <-4.60551,11.31789,2.66497>,<-4.60434,11.32595,2.68241>,<-4.60763,11.30706,2.68074>,
            
    /*2*/ <-5.26564,11.43267,2.66673>

    /* stem 0.11c1.0.5*/ 
    /*0*/ <-4.67315,11.47259,2.68997>,
    /*1*/ <-4.6669,11.47387,2.6983>,<-4.68297,11.47629,2.69016>,<-4.66959,11.4676,2.68144>,
            
    /*2*/ <-4.47142,12.01984,2.45434>

    /* stem 0.11c1.0.6*/ 
    /*0*/ <-4.82383,11.94467,2.74248>,
    /*1*/ <-4.82993,11.94327,2.74111>,<-4.82091,11.94952,2.73949>,<-4.82066,11.94122,2.74684>,
            
    /*2*/ <-4.97911,12.26331,3.1082>

    /* stem 0.11c1.0.7*/ 
    /*0*/ <-4.88168,12.24064,2.76679>,
    /*1*/ <-4.87996,12.24104,2.76586>,<-4.88214,12.24157,2.76848>,<-4.88293,12.23931,2.76602>,
            
    /*2*/ <-5.07811,12.55703,2.53933>

    /* stem 0.11c1.1*/ 
    /*0*/ <-4.31084,11.24148,3.4052>,
    /*1*/ <-4.30116,11.23867,3.41463>,<-4.32419,11.24028,3.40846>,<-4.30716,11.24549,3.39252>,
            
    /*2*/ <-4.3047,11.42799,3.47274>,<-4.32543,11.42945,3.46718>,<-4.3101,11.43413,3.45284>,
            
    /*3*/ <-4.27006,11.61338,3.52779>,<-4.2882,11.61802,3.52395>,<-4.27486,11.61958,3.51035>,
            
    /*4*/ <-4.24243,11.80478,3.57377>,<-4.25844,11.80806,3.57019>,<-4.24679,11.80924,3.55824>,
            
    /*5*/ <-4.23218,12.00465,3.57675>,<-4.2461,12.00549,3.5734>,<-4.23623,12.00513,3.563>,
            
    /*6*/ <-4.22279,12.20134,3.59401>,<-4.23438,12.20221,3.59123>,<-4.22612,12.20258,3.5826>,
            
    /*7*/ <-4.2039,12.39656,3.61854>,<-4.21313,12.39778,3.61639>,<-4.20653,12.39802,3.60947>,
            
    /*8*/ <-4.20325,12.59497,3.62952>,<-4.21021,12.59513,3.62782>,<-4.20525,12.5954,3.62265>,
            
    /*9*/ <-4.17901,12.78952,3.65355>,<-4.18361,12.79025,3.65249>,<-4.18032,12.79027,3.64902>,
            
    /*10*/ <-4.15863,12.98588,3.63242>,<-4.16095,12.98608,3.63189>,<-4.15935,12.98573,3.63015>,
            
    /*11*/ <-4.14398,13.18245,3.61266>

    /* stem 0.11c1.1.0*/ 
    /*0*/ <-4.31184,11.315,3.42817>,
    /*1*/ <-4.31773,11.3151,3.42761>,<-4.30861,11.31961,3.42631>,<-4.30917,11.3103,3.43059>,
            
    /*2*/ <-4.37312,11.64029,4.12759>

    /* stem 0.11c1.1.1*/ 
    /*0*/ <-4.26659,11.69126,3.53892>,
    /*1*/ <-4.26234,11.69138,3.53582>,<-4.26648,11.69357,3.54364>,<-4.27096,11.68882,3.53729>,
            
    /*2*/ <-4.48619,12.26997,3.26062>

    /* stem 0.11c1.1.2*/ 
    /*0*/ <-4.24578,11.86889,3.56853>,
    /*1*/ <-4.24694,11.86887,3.57335>,<-4.24817,11.87192,3.56543>,<-4.24223,11.86589,3.56683>,
            
    /*2*/ <-3.81229,12.32031,3.6752>

    /* stem 0.11c1.1.3*/ 
    /*0*/ <-4.23347,12.09394,3.57927>,
    /*1*/ <-4.23549,12.09443,3.5752>,<-4.22963,12.09623,3.58021>,<-4.2353,12.09117,3.58242>,
            
    /*2*/ <-4.54689,12.53643,3.78706>

    /* stem 0.11c1.1.4*/ 
    /*0*/ <-4.20683,12.52305,3.62234>,
    /*1*/ <-4.20332,12.52293,3.62387>,<-4.20944,12.5255,3.62371>,<-4.20772,12.52073,3.61943>,
            
    /*2*/ <-4.05955,12.85432,3.31255>

    /* stem 0.11c1.1.5*/ 
    /*0*/ <-4.19895,12.65138,3.63388>,
    /*1*/ <-4.20239,12.65169,3.63493>,<-4.19762,12.65362,3.63139>,<-4.19685,12.64884,3.63533>,
            
    /*2*/ <-4.07564,12.9357,3.95435>

    /* stem 0.11c1.1.6*/ 
    /*0*/ <-4.14988,13.10848,3.61974>,
    /*1*/ <-4.1496,13.10842,3.61931>,<-4.14976,13.10887,3.62007>,<-4.15027,13.10816,3.61985>,
            
    /*2*/ <-4.36073,13.30983,3.45515>

    /* stem 0.11c2*/ 
    /*0*/ <-4.42048,10.51022,2.49042>,
    /*1*/ <-4.44852,10.50917,2.48438>,<-4.42628,10.53106,2.47155>,<-4.39602,10.52416,2.4848>,
            <-4.39956,10.498,2.50582>,<-4.43201,10.48873,2.50556>,
    /*2*/ <-4.56969,10.95778,3.02226>,<-4.55626,10.97101,3.01451>,<-4.53798,10.96684,3.02252>,
            <-4.54012,10.95103,3.03522>,<-4.55972,10.94543,3.03506>,
    /*3*/ <-4.77248,11.41662,3.52284>,<-4.76794,11.4214,3.52039>,<-4.76184,11.42054,3.52379>,
            <-4.76262,11.41524,3.52834>,<-4.7692,11.41282,3.52775>,
    /*4*/ <-4.76682,11.41732,3.52462>

    /* stem 0.11.0*/ 
    /*0*/ <-0.35554,8.40103,-0.04559>,
    /*1*/ <-0.319,8.45394,-0.0036>,<-0.38066,8.33641,-0.01254>,<-0.36694,8.41272,-0.12064>,
            
    /*2*/ <-0.70217,8.64112,0.07988>,<-0.75767,8.53534,0.07184>,<-0.74532,8.60402,-0.02545>,
            
    /*3*/ <-0.9941,8.93319,0.14232>,<-1.07017,8.85876,0.14147>,<-1.04193,8.90701,0.05092>,
            
    /*4*/ <-1.20176,9.28598,0.23295>,<-1.28194,9.23885,0.23737>,<-1.25424,9.27613,0.15666>,
            
    /*5*/ <-1.41523,9.66622,0.26249>,<-1.48523,9.62806,0.26624>,<-1.45555,9.65012,0.19551>,
            
    /*6*/ <-1.59528,10.05963,0.26098>,<-1.6561,10.03292,0.26425>,<-1.62839,10.04539,0.20508>,
            
    /*7*/ <-1.77866,10.45284,0.27585>,<-1.82713,10.43104,0.27848>,<-1.80577,10.44279,0.23118>,
            
    /*8*/ <-1.96218,10.84644,0.29086>,<-1.99853,10.83009,0.29282>,<-1.98251,10.83891,0.25735>,
            
    /*9*/ <-2.04806,11.26189,0.35272>,<-2.07406,11.2566,0.3547>,<-2.06343,11.26234,0.331>,
            
    /*10*/ <-2.10529,11.68332,0.43544>,<-2.11842,11.68152,0.4366>,<-2.11315,11.68456,0.42477>,
            
    /*11*/ <-2.17547,12.11298,0.43468>

    /* stem 0.11.0.0*/ 
    /*0*/ <-0.54854,8.49891,-0.001>,
    /*1*/ <-0.56265,8.46955,0.00239>,<-0.56491,8.52337,-0.01535>,<-0.51808,8.50379,0.00996>,
            
    /*2*/ <-1.16228,8.96671,1.49675>

    /* stem 0.11.0.1*/ 
    /*0*/ <-0.81207,8.672,0.05991>,
    /*1*/ <-0.80021,8.68898,0.03634>,<-0.82321,8.68632,0.08551>,<-0.81279,8.6407,0.05787>,
            
    /*2*/ <-2.26747,8.74956,-0.61676>

    /* stem 0.11.0.2*/ 
    /*0*/ <-0.95278,8.81543,0.09246>,
    /*1*/ <-0.94953,8.81178,0.12258>,<-0.98045,8.8135,0.07974>,<-0.92834,8.82101,0.07505>,
            
    /*2*/ <-1.15475,10.34632,0.29996>

    /* stem 0.11.0.3*/ 
    /*0*/ <-1.13483,9.0731,0.15757>,
    /*1*/ <-1.15439,9.06742,0.13673>,<-1.12677,9.1006,0.16288>,<-1.12333,9.05129,0.1731>,
            
    /*2*/ <-2.2274,9.2021,1.14772>

    /* stem 0.11.0.4*/ 
    /*0*/ <-1.39115,9.53556,0.23184>,
    /*1*/ <-1.3676,9.548,0.23524>,<-1.41093,9.53914,0.24965>,<-1.39493,9.51953,0.21063>,
            
    /*2*/ <-1.84443,10.58904,-0.48337>

    /* stem 0.11.0.5*/ 
    /*0*/ <-1.51388,9.78913,0.24213>,
    /*1*/ <-1.53358,9.78042,0.25603>,<-1.51821,9.80143,0.22006>,<-1.48985,9.78555,0.25031>,
            
    /*2*/ <-1.56245,10.90576,0.87383>

    /* stem 0.11.0.6*/ 
    /*0*/ <-1.57835,9.93605,0.24288>,
    /*1*/ <-1.57164,9.93911,0.21905>,<-1.57639,9.95504,0.25893>,<-1.58701,9.91399,0.25066>,
            
    /*2*/ <-2.7381,10.29274,-0.03754>

    /* stem 0.11.0.7*/ 
    /*0*/ <-1.74629,10.31354,0.25586>,
    /*1*/ <-1.73772,10.31639,0.27718>,<-1.76822,10.3194,0.25133>,<-1.73293,10.30485,0.23908>,
            
    /*2*/ <-1.40635,11.37221,-0.02208>

    /* stem 0.11.0.8*/ 
    /*0*/ <-1.91423,10.68901,0.27336>,
    /*1*/ <-1.93173,10.68163,0.26362>,<-1.90624,10.70805,0.26798>,<-1.90471,10.67733,0.28849>,
            
    /*2*/ <-2.51209,11.1456,1.00203>

    /* stem 0.11.0.9*/ 
    /*0*/ <-2.01033,10.99126,0.30418>,
    /*1*/ <-1.99151,10.99562,0.2993>,<-2.01806,10.99813,0.32121>,<-2.02142,10.98003,0.29202>,
            
    /*2*/ <-2.31454,11.78953,-0.15574>

    /* stem 0.11.0.10*/ 
    /*0*/ <-2.07556,11.37521,0.36955>,
    /*1*/ <-2.08284,11.37216,0.38022>,<-2.07958,11.38478,0.36128>,<-2.06426,11.36868,0.36715>,
            
    /*2*/ <-1.63396,11.96695,0.83975>

    /* stem 0.11.0.11*/ 
    /*0*/ <-2.10585,11.62913,0.42127>,
    /*1*/ <-2.10681,11.63074,0.41281>,<-2.10013,11.63369,0.42592>,<-2.11059,11.62297,0.42508>,
            
    /*2*/ <-2.68124,12.17738,0.59128>

    /* stem 0.11.0.12*/ 
    /*0*/ <-2.1441,11.89959,0.43348>,
    /*1*/ <-2.14144,11.89997,0.43618>,<-2.14728,11.90169,0.43363>,<-2.14359,11.89711,0.43063>,
            
    /*2*/ <-1.81052,12.43275,0.03054>

    /* stem 0.11.1*/ 
    /*0*/ <-0.53723,8.44653,0.05516>,
    /*1*/ <-0.55459,8.37306,0.05704>,<-0.58308,8.49528,0.02017>,<-0.47402,8.47126,0.08827>,
            
    /*2*/ <-0.76689,8.4403,0.42076>,<-0.79254,8.5503,0.38757>,<-0.69438,8.52869,0.44886>,
            
    /*3*/ <-1.0526,8.62554,0.70278>,<-1.0511,8.71451,0.64772>,<-0.98309,8.70024,0.72595>,
            
    /*4*/ <-1.30653,8.89056,0.94368>,<-1.29335,8.959,0.8843>,<-1.23671,8.94862,0.95549>,
            
    /*5*/ <-1.56315,9.15629,1.15823>,<-1.54989,9.21328,1.10592>,<-1.5039,9.20659,1.16916>,
            
    /*6*/ <-1.79105,9.47352,1.34566>,<-1.77467,9.51487,1.29771>,<-1.73721,9.51024,1.35112>,
            
    /*7*/ <-1.99442,9.79759,1.5376>,<-1.98106,9.83002,1.49878>,<-1.94989,9.8249,1.54048>,
            
    /*8*/ <-2.15223,10.11149,1.77968>,<-2.14392,10.13791,1.75188>,<-2.1175,10.12976,1.77973>,
            
    /*9*/ <-2.28823,10.45479,1.9976>,<-2.28181,10.47047,1.97767>,<-2.26436,10.46543,1.9965>,
            
    /*10*/ <-2.35428,10.80438,2.2354>,<-2.35112,10.81208,2.22531>,<-2.34187,10.80814,2.23367>,
            
    /*11*/ <-2.38523,11.18353,2.43059>

    /* stem 0.11.1.0*/ 
    /*0*/ <-0.64802,8.47754,0.24351>,
    /*1*/ <-0.6596,8.50532,0.23213>,<-0.63772,8.47566,0.27394>,<-0.64674,8.45163,0.22447>,
            
    /*2*/ <-2.16659,8.04421,0.73091>

    /* stem 0.11.1.1*/ 
    /*0*/ <-0.79717,8.53514,0.46421>,
    /*1*/ <-0.77943,8.52611,0.48799>,<-0.82711,8.52709,0.46327>,<-0.78498,8.55221,0.44137>,
            
    /*2*/ <-1.17772,9.8592,1.2508>

    /* stem 0.11.1.2*/ 
    /*0*/ <-0.96458,8.63985,0.62886>,
    /*1*/ <-0.98729,8.62987,0.61212>,<-0.96678,8.6662,0.64289>,<-0.93968,8.62348,0.63158>,
            
    /*2*/ <-1.55664,7.94149,1.84808>

    /* stem 0.11.1.3*/ 
    /*0*/ <-1.17322,8.82594,0.82821>,
    /*1*/ <-1.1532,8.84617,0.82776>,<-1.18463,8.81777,0.85297>,<-1.18182,8.81389,0.8039>,
            
    /*2*/ <-2.19491,9.83396,0.68995>

    /* stem 0.11.1.4*/ 
    /*0*/ <-1.36477,9.01838,0.99937>,
    /*1*/ <-1.37292,8.9975,1.01458>,<-1.38263,9.03715,0.99145>,<-1.33877,9.02049,0.99207>,
            
    /*2*/ <-1.10654,9.74032,2.12849>

    /* stem 0.11.1.5*/ 
    /*0*/ <-1.58669,9.25621,1.18347>,
    /*1*/ <-1.59143,9.26655,1.16067>,<-1.57956,9.27102,1.20294>,<-1.58908,9.23107,1.18679>,
            
    /*2*/ <-2.80882,9.41534,1.50991>

    /* stem 0.11.1.6*/ 
    /*0*/ <-1.73719,9.4586,1.30659>,
    /*1*/ <-1.72089,9.45981,1.32452>,<-1.76081,9.46122,1.31147>,<-1.72987,9.45475,1.28378>,
            
    /*2*/ <-1.63952,10.65026,1.13723>

    /* stem 0.11.1.7*/ 
    /*0*/ <-1.90569,9.71109,1.46065>,
    /*1*/ <-1.92556,9.70102,1.45591>,<-1.90397,9.7338,1.45994>,<-1.88754,9.69846,1.46611>,
            
    /*2*/ <-2.19377,9.76701,2.54761>

    /* stem 0.11.1.8*/ 
    /*0*/ <-2.05521,9.96948,1.64607>,
    /*1*/ <-2.04176,9.98344,1.6374>,<-2.05626,9.96746,1.66718>,<-2.0676,9.95754,1.63363>,
            
    /*2*/ <-2.79433,10.70218,1.67916>

    /* stem 0.11.1.9*/ 
    /*0*/ <-2.23939,10.37042,1.92977>,
    /*1*/ <-2.24083,10.36063,1.94383>,<-2.25231,10.38076,1.92513>,<-2.22503,10.36985,1.92034>,
            
    /*2*/ <-1.88116,11.0442,2.43504>

    /* stem 0.11.1.10*/ 
    /*0*/ <-2.28735,10.50832,2.02187>,
    /*1*/ <-2.2955,10.51375,2.01169>,<-2.27741,10.51629,2.02796>,<-2.28913,10.49491,2.02595>,
            
    /*2*/ <-2.86495,10.76834,2.62356>

    /* stem 0.11.1.11*/ 
    /*0*/ <-2.3239,10.68585,2.14595>,
    /*1*/ <-2.31412,10.68577,2.14895>,<-2.33135,10.6872,2.15283>,<-2.32623,10.68458,2.13607>,
            
    /*2*/ <-2.28212,11.49773,2.03175>

    /* stem 0.11.1.12*/ 
    /*0*/ <-2.35931,10.91437,2.28779>,
    /*1*/ <-2.3642,10.91293,2.28962>,<-2.35863,10.91917,2.28536>,<-2.3551,10.91102,2.28839>,
            
    /*2*/ <-2.20262,11.23026,2.95613>

    /* stem 0.11.2*/ 
    /*0*/ <-0.80949,8.52258,0.20667>,
    /*1*/ <-0.81674,8.58106,0.16261>,<-0.79797,8.53202,0.27873>,<-0.81378,8.45467,0.17869>,
            
    /*2*/ <-1.22504,8.57399,0.23261>,<-1.20815,8.52985,0.33712>,<-1.22238,8.46024,0.24708>,
            
    /*3*/ <-1.59359,8.70146,0.31665>,<-1.58635,8.66434,0.41133>,<-1.62327,8.60594,0.33635>,
            
    /*4*/ <-1.89219,8.94446,0.43858>,<-1.88537,8.91322,0.52186>,<-1.94072,8.87402,0.46391>,
            
    /*5*/ <-2.1569,9.24318,0.47975>,<-2.16396,9.22795,0.55436>,<-2.21015,9.19388,0.50384>,
            
    /*6*/ <-2.37943,9.58464,0.52817>,<-2.38582,9.57282,0.59046>,<-2.42896,9.55052,0.5492>,
            
    /*7*/ <-2.54715,9.95064,0.62558>,<-2.5499,9.9372,0.67467>,<-2.589,9.92762,0.64339>,
            
    /*8*/ <-2.69676,10.32428,0.71933>,<-2.69904,10.31475,0.75628>,<-2.72881,10.30864,0.7331>,
            
    /*9*/ <-2.8779,10.68582,0.81489>,<-2.8793,10.67908,0.83944>,<-2.89852,10.67363,0.82361>,
            
    /*10*/ <-3.03051,11.05439,0.9261>,<-3.03105,11.05071,0.93829>,<-3.04107,11.04888,0.93063>,
            
    /*11*/ <-3.16502,11.4317,1.03074>

    /* stem 0.11.2.0*/ 
    /*0*/ <-1.02021,8.52195,0.24047>,
    /*1*/ <-1.01535,8.5151,0.27068>,<-1.04258,8.50697,0.22439>,<-1.00271,8.5438,0.22633>,
            
    /*2*/ <-2.08192,9.6486,0.66721>

    /* stem 0.11.2.1*/ 
    /*0*/ <-1.35711,8.57059,0.30216>,
    /*1*/ <-1.3671,8.55763,0.27717>,<-1.36784,8.59718,0.31052>,<-1.33638,8.55695,0.3188>,
            
    /*2*/ <-2.45254,7.8778,1.09923>

    /* stem 0.11.2.2*/ 
    /*0*/ <-1.45762,8.60629,0.32384>,
    /*1*/ <-1.44653,8.63193,0.33304>,<-1.47524,8.59071,0.34149>,<-1.45109,8.59624,0.29698>,
            
    /*2*/ <-2.64747,9.32096,-0.2329>

    /* stem 0.11.2.3*/ 
    /*0*/ <-1.82496,8.84319,0.44287>,
    /*1*/ <-1.83775,8.82209,0.4549>,<-1.83947,8.86195,0.42903>,<-1.79767,8.84553,0.44467>,
            
    /*2*/ <-1.96548,9.58917,1.60157>

    /* stem 0.11.2.4*/ 
    /*0*/ <-2.10204,9.13559,0.50217>,
    /*1*/ <-2.09636,9.14344,0.47838>,<-2.10345,9.15265,0.52133>,<-2.10632,9.11068,0.50681>,
            
    /*2*/ <-3.35424,9.30541,0.25894>

    /* stem 0.11.2.5*/ 
    /*0*/ <-2.22326,9.29442,0.52171>,
    /*1*/ <-2.215,9.29678,0.545>,<-2.24759,9.2958,0.51697>,<-2.2072,9.29069,0.50316>,
            
    /*2*/ <-2.123,10.51858,0.36237>

    /* stem 0.11.2.6*/ 
    /*0*/ <-2.36111,9.5112,0.54871>,
    /*1*/ <-2.379,9.50132,0.5367>,<-2.35522,9.53381,0.54472>,<-2.34911,9.49847,0.56469>,
            
    /*2*/ <-3.1128,9.8544,1.38623>

    /* stem 0.11.2.7*/ 
    /*0*/ <-2.51761,9.8385,0.62298>,
    /*1*/ <-2.49818,9.84815,0.61887>,<-2.5277,9.84179,0.64234>,<-2.52695,9.82556,0.60773>,
            
    /*2*/ <-3.03386,10.7007,0.20751>

    /* stem 0.11.2.8*/ 
    /*0*/ <-2.60467,10.04862,0.67366>,
    /*1*/ <-2.61559,10.04062,0.68979>,<-2.61347,10.06309,0.66115>,<-2.58497,10.04215,0.67005>,
            
    /*2*/ <-2.24671,10.79658,1.28717>

    /* stem 0.11.2.9*/ 
    /*0*/ <-2.77499,10.45307,0.77009>,
    /*1*/ <-2.77695,10.45671,0.75148>,<-2.76824,10.46653,0.78178>,<-2.77979,10.43597,0.77701>,
            
    /*2*/ <-3.63499,10.75486,0.91949>

    /* stem 0.11.2.10*/ 
    /*0*/ <-2.93478,10.80316,0.86113>,
    /*1*/ <-2.92635,10.80401,0.87001>,<-2.94667,10.80454,0.8638>,<-2.93131,10.80092,0.84957>,
            
    /*2*/ <-2.87121,11.61762,0.72265>

    /* stem 0.11.2.11*/ 
    /*0*/ <-2.99333,10.94929,0.90267>,
    /*1*/ <-3.00207,10.94617,0.90134>,<-2.9906,10.95738,0.89879>,<-2.98732,10.94432,0.90788>,
            
    /*2*/ <-3.23063,11.33838,1.54737>

    /* stem 0.11.2.12*/ 
    /*0*/ <-3.07453,11.16859,0.96221>,
    /*1*/ <-3.07068,11.1706,0.95958>,<-3.07568,11.1704,0.96683>,<-3.07724,11.16476,0.96024>,
            
    /*2*/ <-3.53371,11.65054,0.65873>

    /* stem 0.11.3*/ 
    /*0*/ <-1.16089,8.62674,0.40264>,
    /*1*/ <-1.13156,8.60873,0.4648>,<-1.22426,8.60036,0.38429>,<-1.12684,8.67113,0.35883>,
            
    /*2*/ <-1.31408,8.92052,0.63313>,<-1.39751,8.91299,0.56067>,<-1.30983,8.97668,0.53776>,
            
    /*3*/ <-1.50736,9.23557,0.78905>,<-1.5796,9.22595,0.72284>,<-1.50202,9.28328,0.70309>,
            
    /*4*/ <-1.68506,9.57008,0.92155>,<-1.74798,9.5613,0.86336>,<-1.67729,9.60653,0.84388>,
            
    /*5*/ <-1.86381,9.91886,1.01631>,<-1.9156,9.90757,0.9649>,<-1.8537,9.94394,0.9476>,
            
    /*6*/ <-2.03503,10.27374,1.08864>,<-2.07752,10.26312,1.04541>,<-2.02496,10.29148,1.03058>,
            
    /*7*/ <-2.25157,10.60918,1.1346>,<-2.28229,10.59514,1.09878>,<-2.24262,10.62223,1.08798>,
            
    /*8*/ <-2.43868,10.96094,1.1615>,<-2.46212,10.95116,1.1347>,<-2.43065,10.96854,1.12627>,
            
    /*9*/ <-2.64952,11.28768,1.2381>,<-2.66566,11.28186,1.22045>,<-2.64606,11.29576,1.21511>,
            
    /*10*/ <-2.85648,11.60901,1.34699>,<-2.86497,11.60669,1.33839>,<-2.8553,11.61382,1.33572>,
            
    /*11*/ <-3.0463,11.94082,1.45934>

    /* stem 0.11.3.0*/ 
    /*0*/ <-1.26679,8.80955,0.50557>,
    /*1*/ <-1.29167,8.80426,0.48937>,<-1.2587,8.83789,0.51197>,<-1.25,8.7865,0.51538>,
            
    /*2*/ <-2.09715,8.75485,1.79858>

    /* stem 0.11.3.1*/ 
    /*0*/ <-1.43404,9.09082,0.65689>,
    /*1*/ <-1.40988,9.10612,0.65567>,<-1.4522,9.09445,0.67872>,<-1.44005,9.07188,0.63628>,
            
    /*2*/ <-2.12627,10.12408,-0.0907>

    /* stem 0.11.3.2*/ 
    /*0*/ <-1.58316,9.35019,0.78079>,
    /*1*/ <-1.59749,9.33528,0.79853>,<-1.59475,9.37153,0.76846>,<-1.55726,9.34375,0.77539>,
            
    /*2*/ <-1.1668,10.1668,1.80342>

    /* stem 0.11.3.3*/ 
    /*0*/ <-1.64193,9.46214,0.82744>,
    /*1*/ <-1.64371,9.47157,0.80257>,<-1.63098,9.47708,0.84661>,<-1.65111,9.43776,0.83314>,
            
    /*2*/ <-2.8456,9.98117,1.11028>

    /* stem 0.11.3.4*/ 
    /*0*/ <-1.77199,9.71468,0.9156>,
    /*1*/ <-1.75694,9.71638,0.93597>,<-1.79613,9.7224,0.91698>,<-1.7629,9.70526,0.89386>,
            
    /*2*/ <-1.41952,10.88059,0.55777>

    /* stem 0.11.3.5*/ 
    /*0*/ <-1.96588,10.10841,1.0175>,
    /*1*/ <-1.98677,10.09985,1.01125>,<-1.95926,10.12964,1.01014>,<-1.95162,10.09575,1.03109>,
            
    /*2*/ <-2.4438,10.58495,1.96257>

    /* stem 0.11.3.6*/ 
    /*0*/ <-2.17498,10.47787,1.08656>,
    /*1*/ <-2.15885,10.4895,1.07829>,<-2.18559,10.48498,1.1039>,<-2.18051,10.45914,1.07748>,
            
    /*2*/ <-2.86077,10.98387,0.45991>

    /* stem 0.11.3.7*/ 
    /*0*/ <-2.30701,10.70037,1.1159>,
    /*1*/ <-2.31441,10.69473,1.13404>,<-2.31877,10.71072,1.10286>,<-2.28784,10.69566,1.11081>,
            
    /*2*/ <-1.99128,11.55746,1.51123>

    /* stem 0.11.3.8*/ 
    /*0*/ <-2.51819,11.0765,1.17049>,
    /*1*/ <-2.52368,11.07748,1.1529>,<-2.51487,11.09196,1.17999>,<-2.51603,11.06006,1.17857>,
            
    /*2*/ <-3.36797,11.09553,1.43657>

    /* stem 0.11.3.9*/ 
    /*0*/ <-2.62109,11.23737,1.21153>,
    /*1*/ <-2.60976,11.24231,1.22058>,<-2.6355,11.23716,1.21672>,<-2.61801,11.23264,1.19729>,
            
    /*2*/ <-2.73547,12.02311,0.92605>

    /* stem 0.11.3.10*/ 
    /*0*/ <-2.7192,11.39097,1.2615>,
    /*1*/ <-2.72915,11.38439,1.26212>,<-2.71928,11.4014,1.25568>,<-2.70916,11.38711,1.2667>,
            
    /*2*/ <-2.92482,11.76549,1.93595>

    /* stem 0.11.3.11*/ 
    /*0*/ <-2.9355,11.74511,1.38899>,
    /*1*/ <-2.93331,11.74736,1.3862>,<-2.93608,11.74658,1.39288>,<-2.93712,11.7414,1.38789>,
            
    /*2*/ <-3.51888,12.06019,1.18339>

    /* stem 0.11.4*/ 
    /*0*/ <-1.37642,8.68732,0.51801>,
    /*1*/ <-1.41171,8.65852,0.46548>,<-1.382,8.75551,0.53037>,<-1.33556,8.64794,0.55817>,
            
    /*2*/ <-1.7079,8.59366,0.70922>,<-1.68116,8.68095,0.76762>,<-1.63937,8.58414,0.79264>,
            
    /*3*/ <-2.0004,8.62963,0.97817>,<-1.959,8.70879,1.01422>,<-1.937,8.62223,1.05032>,
            
    /*4*/ <-2.22589,8.82662,1.25065>,<-2.16662,8.88618,1.2573>,<-2.16488,8.81911,1.30832>,
            
    /*5*/ <-2.41324,9.08746,1.47707>,<-2.35605,9.13158,1.47538>,<-2.36194,9.08206,1.52766>,
            
    /*6*/ <-2.57343,9.3845,1.67564>,<-2.52265,9.41646,1.67057>,<-2.53088,9.38033,1.71803>,
            
    /*7*/ <-2.75461,9.68592,1.83519>,<-2.71462,9.71259,1.83206>,<-2.72312,9.68648,1.87164>,
            
    /*8*/ <-2.91495,10.01309,1.97527>,<-2.88356,10.03063,1.97177>,<-2.89138,10.01358,2.00264>,
            
    /*9*/ <-3.10539,10.34213,2.04287>,<-3.08498,10.35477,2.04098>,<-3.09196,10.3463,2.06241>,
            
    /*10*/ <-3.29462,10.67673,2.10261>,<-3.28435,10.68293,2.10164>,<-3.28799,10.67895,2.11241>,
            
    /*11*/ <-3.47515,11.0206,2.12323>

    /* stem 0.11.4.0*/ 
    /*0*/ <-1.57258,8.64299,0.67409>,
    /*1*/ <-1.56844,8.6692,0.68674>,<-1.5814,8.62009,0.69027>,<-1.56789,8.63968,0.64525>,
            
    /*2*/ <-2.99832,8.99983,0.40159>

    /* stem 0.11.4.1*/ 
    /*0*/ <-1.75734,8.62911,0.82883>,
    /*1*/ <-1.75406,8.6019,0.8361>,<-1.78328,8.64057,0.8281>,<-1.73469,8.64488,0.82228>,
            
    /*2*/ <-1.62634,9.01316,2.20663>

    /* stem 0.11.4.2*/ 
    /*0*/ <-2.03563,8.71418,1.09635>,
    /*1*/ <-2.04707,8.72779,1.07652>,<-2.02682,8.72702,1.11796>,<-2.03299,8.68774,1.09457>,
            
    /*2*/ <-3.23171,8.5556,1.67801>

    /* stem 0.11.4.3*/ 
    /*0*/ <-2.15391,8.81641,1.23477>,
    /*1*/ <-2.13381,8.81803,1.25076>,<-2.17729,8.8109,1.24402>,<-2.15064,8.82031,1.20955>,
            
    /*2*/ <-2.38567,10.07406,1.39894>

    /* stem 0.11.4.4*/ 
    /*0*/ <-2.24302,8.92068,1.33829>,
    /*1*/ <-2.26408,8.90755,1.3353>,<-2.24335,8.94555,1.33588>,<-2.22164,8.90893,1.3437>,
            
    /*2*/ <-2.4878,9.0355,2.55653>

    /* stem 0.11.4.5*/ 
    /*0*/ <-2.44222,9.21603,1.57013>,
    /*1*/ <-2.42913,9.23114,1.55848>,<-2.44516,9.21847,1.59296>,<-2.45237,9.1985,1.55897>,
            
    /*2*/ <-3.36413,9.86958,1.38175>

    /* stem 0.11.4.6*/ 
    /*0*/ <-2.6003,9.48645,1.73676>,
    /*1*/ <-2.60085,9.47615,1.75572>,<-2.61724,9.49821,1.73038>,<-2.58283,9.48498,1.72418>,
            
    /*2*/ <-2.18679,10.33952,2.21182>

    /* stem 0.11.4.7*/ 
    /*0*/ <-2.79471,9.81993,1.89908>,
    /*1*/ <-2.80524,9.82156,1.88247>,<-2.78646,9.83594,1.90714>,<-2.79243,9.80229,1.90762>,
            
    /*2*/ <-3.58889,9.96839,2.41715>

    /* stem 0.11.4.8*/ 
    /*0*/ <-2.93009,10.07478,1.99433>,
    /*1*/ <-2.91518,10.08218,2.0021>,<-2.9465,10.07658,2.00237>,<-2.92858,10.06556,1.9785>,
            
    /*2*/ <-3.06827,10.82578,1.54385>

    /* stem 0.11.4.9*/ 
    /*0*/ <-3.05103,10.27604,2.03446>,
    /*1*/ <-3.06348,10.26779,2.03828>,<-3.05204,10.28695,2.02361>,<-3.03756,10.27337,2.04148>,
            
    /*2*/ <-3.24332,10.83585,2.61546>

    /* stem 0.11.4.10*/ 
    /*0*/ <-3.17687,10.48865,2.07287>,
    /*1*/ <-3.17207,10.49298,2.06404>,<-3.17646,10.49391,2.08247>,<-3.18209,10.47905,2.07212>,
            
    /*2*/ <-3.82946,10.85723,1.89892>

    /* stem 0.11.4.11*/ 
    /*0*/ <-3.35461,10.79977,2.11178>,
    /*1*/ <-3.35419,10.79977,2.11626>,<-3.35847,10.80112,2.10988>,<-3.35118,10.79843,2.1092>,
            
    /*2*/ <-3.11975,11.44053,2.09013>

    /* stem 0.11.5*/ 
    /*0*/ <-1.51198,8.72423,0.58882>,
    /*1*/ <-1.48573,8.78475,0.60752>,<-1.52984,8.67838,0.63657>,<-1.52037,8.70956,0.52238>,
            
    /*2*/ <-1.84086,8.92802,0.61719>,<-1.88056,8.8323,0.64333>,<-1.87203,8.86036,0.54055>,
            
    /*3*/ <-2.16662,9.11423,0.62247>,<-2.21324,9.03482,0.64582>,<-2.20154,9.0579,0.55441>,
            
    /*4*/ <-2.45653,9.35156,0.61861>,<-2.50866,9.29007,0.63893>,<-2.49367,9.30713,0.55896>,
            
    /*5*/ <-2.7197,9.62269,0.60495>,<-2.77049,9.57575,0.62206>,<-2.75462,9.58771,0.55363>,
            
    /*6*/ <-2.9931,9.88703,0.64715>,<-3.03257,9.84516,0.6618>,<-3.02595,9.86115,0.605>,
            
    /*7*/ <-3.20046,10.18805,0.73357>,<-3.2365,10.16019,0.74702>,<-3.23355,10.17514,0.70203>,
            
    /*8*/ <-3.4077,10.49225,0.83798>,<-3.43459,10.47116,0.84807>,<-3.43322,10.48356,0.81469>,
            
    /*9*/ <-3.5985,10.80752,0.93886>,<-3.61705,10.79448,0.94593>,<-3.6159,10.80234,0.92355>,
            
    /*10*/ <-3.7959,11.12627,1.0189>,<-3.80523,11.11982,1.02242>,<-3.80431,11.12324,1.01109>,
            
    /*11*/ <-3.97407,11.45612,1.09574>

    /* stem 0.11.5.0*/ 
    /*0*/ <-1.72488,8.81442,0.59579>,
    /*1*/ <-1.7349,8.78986,0.60769>,<-1.73713,8.82491,0.5716>,<-1.70261,8.8285,0.60809>,
            
    /*2*/ <-2.67194,9.59714,1.41462>

    /* stem 0.11.5.1*/ 
    /*0*/ <-2.05077,8.98411,0.60443>,
    /*1*/ <-2.04507,8.99463,0.57967>,<-2.05931,9.00057,0.62474>,<-2.04794,8.95711,0.60889>,
            
    /*2*/ <-3.36765,8.7814,0.21511>

    /* stem 0.11.5.2*/ 
    /*0*/ <-2.28265,9.1441,0.60694>,
    /*1*/ <-2.27861,9.14909,0.63243>,<-2.30644,9.1366,0.59863>,<-2.26291,9.1466,0.58976>,
            
    /*2*/ <-2.61256,10.40746,0.41163>

    /* stem 0.11.5.3*/ 
    /*0*/ <-2.43486,9.27278,0.60586>,
    /*1*/ <-2.44811,9.25699,0.59097>,<-2.43253,9.29729,0.59951>,<-2.42395,9.26406,0.62711>,
            
    /*2*/ <-3.49234,9.54299,1.25991>

    /* stem 0.11.5.4*/ 
    /*0*/ <-2.55551,9.39001,0.60234>,
    /*1*/ <-2.53751,9.40684,0.60066>,<-2.57439,9.39363,0.61786>,<-2.55464,9.36957,0.58851>,
            
    /*2*/ <-3.17827,9.96735,-0.29018>

    /* stem 0.11.5.5*/ 
    /*0*/ <-2.91189,9.75908,0.62058>,
    /*1*/ <-2.92196,9.74644,0.63619>,<-2.92424,9.77038,0.6056>,<-2.88948,9.76042,0.61996>,
            
    /*2*/ <-2.94493,10.63041,1.30488>

    /* stem 0.11.5.6*/ 
    /*0*/ <-3.14162,10.05141,0.69199>,
    /*1*/ <-3.14338,10.05606,0.67181>,<-3.13531,10.0659,0.70549>,<-3.14617,10.03226,0.69868>,
            
    /*2*/ <-4.10737,10.33297,0.84133>

    /* stem 0.11.5.7*/ 
    /*0*/ <-3.28714,10.27161,0.761>,
    /*1*/ <-3.27489,10.27447,0.776>,<-3.30646,10.27095,0.76413>,<-3.28008,10.26941,0.74288>,
            
    /*2*/ <-3.34125,11.2119,0.62586>

    /* stem 0.11.5.8*/ 
    /*0*/ <-3.45647,10.53623,0.8509>,
    /*1*/ <-3.47231,10.5282,0.84727>,<-3.45327,10.55305,0.84497>,<-3.44384,10.52743,0.86046>,
            
    /*2*/ <-3.79016,10.86002,1.58983>

    /* stem 0.11.5.9*/ 
    /*0*/ <-3.57903,10.74728,0.91871>,
    /*1*/ <-3.56861,10.75549,0.91198>,<-3.58341,10.75067,0.93251>,<-3.58507,10.73567,0.91163>,
            
    /*2*/ <-4.15633,11.23208,0.6163>

    /* stem 0.11.5.10*/ 
    /*0*/ <-3.72459,10.99329,0.98463>,
    /*1*/ <-3.72677,10.98979,0.99333>,<-3.73098,10.9987,0.97989>,<-3.71603,10.99136,0.98068>,
            
    /*2*/ <-3.44209,11.60243,1.29997>

    /* stem 0.11.5.11*/ 
    /*0*/ <-3.84664,11.20977,1.03784>,
    /*1*/ <-3.84851,11.2099,1.03313>,<-3.84399,11.2137,1.03963>,<-3.84741,11.20569,1.04076>,
            
    /*2*/ <-4.42115,11.488,1.27454>

    /* stem 0.11.6*/ 
    /*0*/ <-1.76646,8.79353,0.72177>,
    /*1*/ <-1.77174,8.73091,0.74431>,<-1.81271,8.81811,0.68038>,<-1.71494,8.83156,0.74062>,
            
    /*2*/ <-1.96752,8.85862,1.03352>,<-2.0044,8.9371,0.97599>,<-1.91641,8.94921,1.03021>,
            
    /*3*/ <-2.11137,9.07434,1.31921>,<-2.13962,9.13802,1.25835>,<-2.05537,9.14422,1.29603>,
            
    /*4*/ <-2.24331,9.3349,1.5629>,<-2.26368,9.38359,1.50154>,<-2.19026,9.38934,1.53512>,
            
    /*5*/ <-2.38941,9.61059,1.77187>,<-2.40388,9.64751,1.71494>,<-2.34285,9.65558,1.74693>,
            
    /*6*/ <-2.57457,9.90589,1.9154>,<-2.58102,9.92858,1.86262>,<-2.5347,9.94214,1.89445>,
            
    /*7*/ <-2.7937,10.18112,2.03439>,<-2.79742,10.19773,1.99139>,<-2.76355,10.21268,2.0191>,
            
    /*8*/ <-3.03878,10.45449,2.10428>,<-3.03853,10.46398,2.07092>,<-3.01615,10.47833,2.0932>,
            
    /*9*/ <-3.26054,10.7512,2.15457>,<-3.25933,10.75636,2.13206>,<-3.24396,10.76534,2.14682>,
            
    /*10*/ <-3.46912,11.06024,2.17098>,<-3.46782,11.06194,2.15962>,<-3.4603,11.06662,2.16706>,
            
    /*11*/ <-3.65969,11.3799,2.15304>

    /* stem 0.11.6.0*/ 
    /*0*/ <-1.88682,8.86799,0.90047>,
    /*1*/ <-1.90049,8.8862,0.88368>,<-1.88018,8.87542,0.92695>,<-1.8798,8.84235,0.89079>,
            
    /*2*/ <-3.14115,8.35093,1.36035>

    /* stem 0.11.6.1*/ 
    /*0*/ <-2.03109,9.01493,1.1495>,
    /*1*/ <-2.00777,9.01281,1.16274>,<-2.05432,9.01477,1.16306>,<-2.03117,9.01719,1.1227>,
            
    /*2*/ <-1.97343,10.36316,1.26343>

    /* stem 0.11.6.2*/ 
    /*0*/ <-2.17318,9.25542,1.42316>,
    /*1*/ <-2.19592,9.2446,1.42212>,<-2.17105,9.28048,1.42137>,<-2.15256,9.24119,1.426>,
            
    /*2*/ <-2.27748,9.35392,2.67509>

    /* stem 0.11.6.3*/ 
    /*0*/ <-2.30727,9.50671,1.64134>,
    /*1*/ <-2.29422,9.5228,1.62993>,<-2.30669,9.50561,1.66496>,<-2.3209,9.49173,1.62914>,
            
    /*2*/ <-3.19748,10.26975,1.69895>

    /* stem 0.11.6.4*/ 
    /*0*/ <-2.44024,9.7337,1.79329>,
    /*1*/ <-2.44112,9.72314,1.81293>,<-2.45903,9.74094,1.78366>,<-2.42057,9.73701,1.78327>,
            
    /*2*/ <-2.33658,10.69698,2.31545>

    /* stem 0.11.6.5*/ 
    /*0*/ <-2.49425,9.8178,1.83605>,
    /*1*/ <-2.50576,9.81979,1.81759>,<-2.48429,9.83524,1.84464>,<-2.4927,9.79837,1.84591>,
            
    /*2*/ <-3.37562,10.03857,2.40962>

    /* stem 0.11.6.6*/ 
    /*0*/ <-2.6908,10.08177,1.96222>,
    /*1*/ <-2.67501,10.09034,1.97163>,<-2.70861,10.08008,1.97178>,<-2.68878,10.07488,1.94324>,
            
    /*2*/ <-2.96281,10.9667,1.61221>

    /* stem 0.11.6.7*/ 
    /*0*/ <-2.89902,10.32158,2.04949>,
    /*1*/ <-2.91232,10.30858,2.05239>,<-2.90354,10.33805,2.0416>,<-2.88122,10.31811,2.05449>,
            
    /*2*/ <-3.06203,10.67198,2.87389>

    /* stem 0.11.6.8*/ 
    /*0*/ <-3.11043,10.56921,2.10898>,
    /*1*/ <-3.10274,10.57756,2.09589>,<-3.11263,10.57715,2.12423>,<-3.11593,10.55291,2.10683>,
            
    /*2*/ <-3.84945,10.85192,1.85523>

    /* stem 0.11.6.9*/ 
    /*0*/ <-3.33715,10.87699,2.15285>,
    /*1*/ <-3.33682,10.87646,2.16358>,<-3.34659,10.87786,2.14781>,<-3.32804,10.87664,2.14718>,
            
    /*2*/ <-3.28728,11.61298,2.18728>

    /* stem 0.11.6.10*/ 
    /*0*/ <-3.54067,11.18539,2.16092>,
    /*1*/ <-3.54285,11.18393,2.15777>,<-3.53882,11.18903,2.16063>,<-3.54035,11.1832,2.16437>,
            
    /*2*/ <-4.07333,11.47499,2.39431>

    /* stem 0.11.7*/ 
    /*0*/ <-2.03958,8.89923,0.89271>,
    /*1*/ <-2.05754,8.93557,0.84232>,<-2.01638,8.92728,0.94616>,<-2.04484,8.83484,0.88966>,
            
    /*2*/ <-2.38829,8.95274,0.98082>,<-2.35124,8.94528,1.07429>,<-2.37686,8.86209,1.02343>,
            
    /*3*/ <-2.68811,9.07692,1.11014>,<-2.6563,9.07068,1.19369>,<-2.70027,9.00164,1.15721>,
            
    /*4*/ <-2.98044,9.25349,1.16013>,<-2.96828,9.25379,1.23759>,<-3.0088,9.19539,1.2045>,
            
    /*5*/ <-3.24284,9.48587,1.23181>,<-3.22831,9.48363,1.2974>,<-3.27326,9.44093,1.27145>,
            
    /*6*/ <-3.47671,9.74873,1.27145>,<-3.46767,9.74961,1.32672>,<-3.5079,9.71695,1.30544>,
            
    /*7*/ <-3.71687,10.01273,1.30992>,<-3.70986,10.01361,1.35417>,<-3.7417,9.98714,1.33706>,
            
    /*8*/ <-3.96342,10.2714,1.34239>,<-3.95864,10.27251,1.37563>,<-3.98188,10.25198,1.36267>,
            
    /*9*/ <-4.14603,10.57005,1.42678>,<-4.14038,10.56781,1.44834>,<-4.15924,10.55847,1.44067>,
            
    /*10*/ <-4.32736,10.87655,1.4492>,<-4.32553,10.87702,1.46024>,<-4.33468,10.8719,1.45629>,
            
    /*11*/ <-4.49998,11.19025,1.47479>

    /* stem 0.11.7.0*/ 
    /*0*/ <-2.22218,8.91065,0.966>,
    /*1*/ <-2.21184,8.9134,0.99134>,<-2.24424,8.89477,0.9618>,<-2.21046,8.92379,0.94486>,
            
    /*2*/ <-3.05061,10.00301,1.18553>

    /* stem 0.11.7.1*/ 
    /*0*/ <-2.56901,9.00257,1.1073>,
    /*1*/ <-2.58206,8.98532,1.09317>,<-2.57862,9.02628,1.11087>,<-2.54634,8.9961,1.11787>,
            
    /*2*/ <-3.182,8.59395,2.17206>

    /* stem 0.11.7.2*/ 
    /*0*/ <-2.88372,9.17231,1.18495>,
    /*1*/ <-2.87142,9.1931,1.18294>,<-2.90019,9.16962,1.20252>,<-2.87954,9.1542,1.16938>,
            
    /*2*/ <-3.73719,9.60597,0.45115>

    /* stem 0.11.7.3*/ 
    /*0*/ <-3.09741,9.33457,1.22888>,
    /*1*/ <-3.10564,9.32078,1.24541>,<-3.11167,9.34334,1.21303>,<-3.07493,9.33959,1.2282>,
            
    /*2*/ <-3.27998,10.24236,1.89497>

    /* stem 0.11.7.4*/ 
    /*0*/ <-3.30508,9.53488,1.27517>,
    /*1*/ <-3.30576,9.53706,1.25352>,<-3.30576,9.55252,1.2879>,<-3.30372,9.51507,1.28408>,
            
    /*2*/ <-4.37335,9.47384,1.30248>

    /* stem 0.11.7.5*/ 
    /*0*/ <-3.41911,9.66454,1.29175>,
    /*1*/ <-3.40844,9.6718,1.30832>,<-3.44008,9.66365,1.29233>,<-3.4088,9.65816,1.2746>,
            
    /*2*/ <-3.46985,10.61727,0.90701>

    /* stem 0.11.7.6*/ 
    /*0*/ <-3.57702,9.84201,1.31386>,
    /*1*/ <-3.59178,9.82929,1.30954>,<-3.57751,9.86063,1.30674>,<-3.56178,9.83609,1.32529>,
            
    /*2*/ <-4.05862,10.1321,2.10612>

    /* stem 0.11.7.7*/ 
    /*0*/ <-3.81023,10.09749,1.34317>,
    /*1*/ <-3.79874,10.10915,1.33477>,<-3.81759,10.10195,1.35943>,<-3.81436,10.08138,1.3353>,
            
    /*2*/ <-4.49793,10.47637,0.92805>

    /* stem 0.11.7.8*/ 
    /*0*/ <-4.04094,10.38658,1.3919>,
    /*1*/ <-4.0442,10.38063,1.40717>,<-4.05256,10.39535,1.38369>,<-4.02607,10.38375,1.38483>,
            
    /*2*/ <-3.75984,11.06014,1.71432>

    /* stem 0.11.7.9*/ 
    /*0*/ <-4.25899,10.75479,1.44877>,
    /*1*/ <-4.26175,10.75364,1.44031>,<-4.25608,10.76284,1.45149>,<-4.25913,10.7479,1.45453>,
            
    /*2*/ <-4.90505,10.92482,1.63641>

    /* stem 0.11.7.10*/ 
    /*0*/ <-4.39679,10.99987,1.46298>,
    /*1*/ <-4.39378,11.00137,1.46497>,<-4.40045,11.00054,1.46417>,<-4.39613,10.99769,1.4598>,
            
    /*2*/ <-4.41904,11.51418,1.10621>

    /* stem 0.11.8*/ 
    /*0*/ <-2.56031,9.13991,1.23774>,
    /*1*/ <-2.52645,9.1436,1.2878>,<-2.60865,9.10348,1.2365>,<-2.54582,9.17266,1.18892>,
            
    /*2*/ <-2.72098,9.39309,1.39366>,<-2.79495,9.35699,1.3475>,<-2.73841,9.41925,1.30468>,
            
    /*3*/ <-2.88489,9.67627,1.46575>,<-2.95329,9.64837,1.426>,<-2.89548,9.69243,1.38411>,
            
    /*4*/ <-3.03905,9.96694,1.52495>,<-3.09932,9.94336,1.49031>,<-3.04697,9.97873,1.45294>,
            
    /*5*/ <-3.23512,10.23823,1.57178>,<-3.2822,10.2108,1.54033>,<-3.24036,10.24635,1.50961>,
            
    /*6*/ <-3.4093,10.52744,1.55466>,<-3.44771,10.50369,1.52801>,<-3.40788,10.52604,1.50226>,
            
    /*7*/ <-3.54985,10.8222,1.46909>,<-3.57994,10.80238,1.44763>,<-3.54441,10.81365,1.42839>,
            
    /*8*/ <-3.67879,11.11972,1.39563>,<-3.70196,11.10617,1.37921>,<-3.67516,11.11425,1.36486>,
            
    /*9*/ <-3.82475,11.39997,1.28076>,<-3.83907,11.38866,1.27044>,<-3.82117,11.39408,1.26095>,
            
    /*10*/ <-3.95885,11.6917,1.19471>,<-3.96639,11.68682,1.18931>,<-3.95745,11.68953,1.18455>,
            
    /*11*/ <-4.10581,11.97485,1.09601>

    /* stem 0.11.8.0*/ 
    /*0*/ <-2.64696,9.25318,1.288>,
    /*1*/ <-2.66802,9.241,1.27916>,<-2.64455,9.27878,1.28491>,<-2.6283,9.23978,1.29994>,
            
    /*2*/ <-3.23735,9.44622,2.42764>

    /* stem 0.11.8.1*/ 
    /*0*/ <-2.79859,9.47316,1.37124>,
    /*1*/ <-2.77951,9.48627,1.36268>,<-2.80867,9.47883,1.39303>,<-2.80758,9.45438,1.358>,
            
    /*2*/ <-3.57847,10.24215,0.81028>

    /* stem 0.11.8.2*/ 
    /*0*/ <-2.96567,9.77746,1.44847>,
    /*1*/ <-2.97375,9.76888,1.46837>,<-2.97937,9.79036,1.43502>,<-2.94388,9.77314,1.44202>,
            
    /*2*/ <-2.61639,10.72024,1.99671>

    /* stem 0.11.8.3*/ 
    /*0*/ <-3.19948,10.15701,1.52633>,
    /*1*/ <-3.20421,10.15757,1.50574>,<-3.19255,10.17445,1.53607>,<-3.20168,10.13901,1.5372>,
            
    /*2*/ <-4.17586,10.41597,1.75761>

    /* stem 0.11.8.4*/ 
    /*0*/ <-3.30164,10.31519,1.53701>,
    /*1*/ <-3.2886,10.32343,1.55021>,<-3.32163,10.31649,1.54034>,<-3.2947,10.30564,1.52049>,
            
    /*2*/ <-3.33002,11.16752,1.03269>

    /* stem 0.11.8.5*/ 
    /*0*/ <-3.39911,10.48079,1.52994>,
    /*1*/ <-3.41587,10.47092,1.52975>,<-3.39531,10.49377,1.51596>,<-3.38615,10.47769,1.54411>,
            
    /*2*/ <-3.80413,11.15832,2.04879>

    /* stem 0.11.8.6*/ 
    /*0*/ <-3.49699,10.68128,1.48415>,
    /*1*/ <-3.48271,10.6849,1.47309>,<-3.50419,10.69465,1.4946>,<-3.50409,10.66428,1.48477>,
            
    /*2*/ <-4.05901,10.89199,0.82737>

    /* stem 0.11.8.7*/ 
    /*0*/ <-3.60193,10.91638,1.42477>,
    /*1*/ <-3.60664,10.91814,1.44126>,<-3.6124,10.92179,1.41219>,<-3.58675,10.90919,1.42086>,
            
    /*2*/ <-3.24392,11.66075,1.44744>

    /* stem 0.11.8.8*/ 
    /*0*/ <-3.76019,11.26043,1.32273>,
    /*1*/ <-3.76463,11.25334,1.31029>,<-3.75569,11.27472,1.32201>,<-3.76026,11.25325,1.33589>,
            
    /*2*/ <-4.44733,11.48309,1.44098>

    /* stem 0.11.8.9*/ 
    /*0*/ <-3.90885,11.57348,1.2214>,
    /*1*/ <-3.90204,11.57739,1.22448>,<-3.91654,11.57655,1.22299>,<-3.90797,11.56651,1.21674>,
            
    /*2*/ <-3.87491,11.93447,0.68776>

    /* stem 0.11.8.10*/ 
    /*0*/ <-4.00439,11.77504,1.16146>,
    /*1*/ <-4.00814,11.77355,1.16275>,<-4.00394,11.77652,1.15752>,<-4.00108,11.77503,1.16411>,
            
    /*2*/ <-4.15314,12.31447,1.34759>

    /* stem 0.11.9*/ 
    /*0*/ <-2.86207,9.2959,1.43034>,
    /*1*/ <-2.89818,9.25902,1.40363>,<-2.87349,9.35289,1.43032>,<-2.81453,9.2758,1.45706>,
            
    /*2*/ <-3.06048,9.22953,1.67645>,<-3.03825,9.31401,1.70047>,<-2.98519,9.24463,1.72454>,
            
    /*3*/ <-3.27383,9.33464,1.8958>,<-3.23682,9.40607,1.89949>,<-3.21473,9.34666,1.94917>,
            
    /*4*/ <-3.50389,9.50543,2.03366>,<-3.46335,9.56306,2.03285>,<-3.46184,9.51969,2.08837>,
            
    /*5*/ <-3.69592,9.74311,2.14618>,<-3.65123,9.78326,2.1399>,<-3.65789,9.75338,2.19197>,
            
    /*6*/ <-3.86458,9.99673,2.24805>,<-3.82481,10.02684,2.24135>,<-3.83205,10.00422,2.28573>,
            
    /*7*/ <-4.02058,10.26472,2.32509>,<-3.98731,10.28658,2.31906>,<-3.99516,10.27151,2.35556>,
            
    /*8*/ <-4.1667,10.54019,2.39442>,<-4.14113,10.55552,2.38962>,<-4.14756,10.54516,2.41725>,
            
    /*9*/ <-4.25017,10.84705,2.44522>,<-4.2314,10.85313,2.44121>,<-4.23669,10.84858,2.46009>,
            
    /*10*/ <-4.37114,11.13983,2.45565>,<-4.36209,11.14381,2.45374>,<-4.365,11.14226,2.46325>,
            
    /*11*/ <-4.50139,11.42849,2.49223>

    /* stem 0.11.9.0*/ 
    /*0*/ <-2.98061,9.27219,1.62336>,
    /*1*/ <-2.97817,9.29616,1.6278>,<-2.97661,9.25595,1.64125>,<-2.98705,9.26447,1.60103>,
            
    /*2*/ <-4.1572,9.33293,1.94156>

    /* stem 0.11.9.1*/ 
    /*0*/ <-3.09383,9.29344,1.7665>,
    /*1*/ <-3.09027,9.27378,1.7792>,<-3.11588,9.30052,1.76158>,<-3.07535,9.30602,1.75873>,
            
    /*2*/ <-3.11048,9.92883,2.7547>

    /* stem 0.11.9.2*/ 
    /*0*/ <-3.34611,9.4367,1.97566>,
    /*1*/ <-3.354,9.44197,1.95571>,<-3.34257,9.45252,1.99067>,<-3.34177,9.41561,1.98061>,
            
    /*2*/ <-4.36216,9.31405,2.34492>

    /* stem 0.11.9.3*/ 
    /*0*/ <-3.57289,9.6453,2.10579>,
    /*1*/ <-3.55836,9.65115,2.11918>,<-3.59248,9.64357,2.11195>,<-3.56784,9.64119,2.08624>,
            
    /*2*/ <-3.73519,10.60865,1.86129>

    /* stem 0.11.9.4*/ 
    /*0*/ <-3.76534,9.90041,2.21515>,
    /*1*/ <-3.78116,9.88973,2.21453>,<-3.76482,9.91725,2.20613>,<-3.75003,9.89426,2.22478>,
            
    /*2*/ <-4.07799,10.31948,2.97931>

    /* stem 0.11.9.5*/ 
    /*0*/ <-3.92419,10.14745,2.29741>,
    /*1*/ <-3.91374,10.15684,2.28659>,<-3.92843,10.15384,2.31341>,<-3.93041,10.13167,2.29224>,
            
    /*2*/ <-4.61069,10.52736,1.96369>

    /* stem 0.11.9.6*/ 
    /*0*/ <-4.07923,10.41572,2.36809>,
    /*1*/ <-4.08023,10.41131,2.38375>,<-4.09264,10.42037,2.36006>,<-4.06483,10.41548,2.36046>,
            
    /*2*/ <-3.95293,11.1509,2.58318>

    /* stem 0.11.9.7*/ 
    /*0*/ <-4.17601,10.63057,2.4138>,
    /*1*/ <-4.18421,10.63024,2.40101>,<-4.16543,10.64131,2.41578>,<-4.17837,10.62016,2.42463>,
            
    /*2*/ <-4.66688,11.05805,2.71773>

    /* stem 0.11.9.8*/ 
    /*0*/ <-4.2968,10.98205,2.45279>,
    /*1*/ <-4.28897,10.98535,2.45572>,<-4.30434,10.98354,2.45745>,<-4.29709,10.97726,2.44519>,
            
    /*2*/ <-4.39587,11.50853,2.12441>

    /* stem 0.11.9.9*/ 
    /*0*/ <-4.42123,11.25875,2.47168>,
    /*1*/ <-4.42408,11.25725,2.47291>,<-4.42147,11.26123,2.46931>,<-4.41814,11.25776,2.47283>,
            
    /*2*/ <-4.44881,11.64058,2.87398>

    /* stem 0.11.10*/ 
    /*0*/ <-3.29741,9.5805,1.74585>,
    /*1*/ <-3.27196,9.62755,1.73642>,<-3.30881,9.56552,1.7968>,<-3.31147,9.54843,1.70432>,
            
    /*2*/ <-3.53559,9.76049,1.71946>,<-3.56874,9.70466,1.7738>,<-3.57115,9.68928,1.69057>,
            
    /*3*/ <-3.72056,9.96646,1.69067>,<-3.76819,9.9309,1.73684>,<-3.77091,9.91799,1.66274>,
            
    /*4*/ <-3.90432,10.19054,1.64682>,<-3.94912,10.16293,1.68641>,<-3.94967,10.14981,1.62188>,
            
    /*5*/ <-4.01915,10.44979,1.60971>,<-4.06321,10.43571,1.64207>,<-4.06513,10.42683,1.58636>,
            
    /*6*/ <-4.10873,10.72832,1.61028>,<-4.1456,10.71719,1.63728>,<-4.14955,10.71599,1.59042>,
            
    /*7*/ <-4.21468,11.00571,1.60055>,<-4.24392,10.99594,1.62213>,<-4.24657,10.9936,1.58467>,
            
    /*8*/ <-4.32836,11.27809,1.63019>,<-4.34926,11.2681,1.64632>,<-4.35259,11.26976,1.61835>,
            
    /*9*/ <-4.43083,11.55378,1.65384>,<-4.44504,11.54789,1.66467>,<-4.44715,11.5487,1.64599>,
            
    /*10*/ <-4.5218,11.8326,1.68855>,<-4.52894,11.82975,1.69398>,<-4.53012,11.83053,1.68467>,
            
    /*11*/ <-4.61015,12.1074,1.753>

    /* stem 0.11.10.0*/ 
    /*0*/ <-3.49726,9.68586,1.73214>,
    /*1*/ <-3.50504,9.67338,1.7496>,<-3.50891,9.68656,1.71253>,<-3.47783,9.69764,1.7343>,
            
    /*2*/ <-4.07896,10.57609,2.10951>

    /* stem 0.11.10.1*/ 
    /*0*/ <-3.64072,9.81117,1.71477>,
    /*1*/ <-3.63863,9.80992,1.69293>,<-3.64163,9.83079,1.72462>,<-3.64189,9.79279,1.72677>,
            
    /*2*/ <-4.71761,9.81298,1.61188>

    /* stem 0.11.10.2*/ 
    /*0*/ <-3.85098,10.0622,1.67244>,
    /*1*/ <-3.84272,10.07189,1.68854>,<-3.87117,10.06343,1.66898>,<-3.83905,10.05129,1.65981>,
            
    /*2*/ <-3.70438,10.87695,1.10702>

    /* stem 0.11.10.3*/ 
    /*0*/ <-3.98523,10.28724,1.63443>,
    /*1*/ <-4.00219,10.27932,1.62958>,<-3.97823,10.30211,1.62423>,<-3.97527,10.2803,1.64947>,
            
    /*2*/ <-4.4283,10.88674,2.2044>

    /* stem 0.11.10.4*/ 
    /*0*/ <-4.09572,10.59165,1.61268>,
    /*1*/ <-4.08021,10.59633,1.60512>,<-4.10242,10.60138,1.62611>,<-4.10454,10.57724,1.60682>,
            
    /*2*/ <-4.51967,11.08124,1.04653>

    /* stem 0.11.10.5*/ 
    /*0*/ <-4.20638,10.91907,1.60537>,
    /*1*/ <-4.21304,10.91721,1.62015>,<-4.2146,10.9269,1.59365>,<-4.19151,10.9131,1.6023>,
            
    /*2*/ <-3.8897,11.59149,1.83256>

    /* stem 0.11.10.6*/ 
    /*0*/ <-4.29526,11.15043,1.61866>,
    /*1*/ <-4.29946,11.15032,1.60407>,<-4.28686,11.16187,1.62406>,<-4.29946,11.1391,1.62785>,
            
    /*2*/ <-4.89295,11.50948,1.78801>

    /* stem 0.11.10.7*/ 
    /*0*/ <-4.38672,11.39542,1.64192>,
    /*1*/ <-4.37575,11.39861,1.64981>,<-4.39923,11.4006,1.645>,<-4.38518,11.38705,1.63095>,
            
    /*2*/ <-4.26509,11.9148,1.26271>

    /* stem 0.11.10.8*/ 
    /*0*/ <-4.4746,11.65988,1.66821>,
    /*1*/ <-4.48289,11.65724,1.66905>,<-4.47269,11.66677,1.66318>,<-4.46821,11.65564,1.67241>,
            
    /*2*/ <-4.54154,12.0163,2.13015>

    /* stem 0.11.10.9*/ 
    /*0*/ <-4.55596,11.92735,1.71136>,
    /*1*/ <-4.55375,11.92859,1.70889>,<-4.55641,11.92913,1.71438>,<-4.55773,11.92434,1.7108>,
            
    /*2*/ <-4.94557,12.19507,1.49638>

    /* stem 0.11.11*/ 
    /*0*/ <-4.10689,10.18959,2.26677>,
    /*1*/ <-4.11175,10.1657,2.29422>,<-4.13585,10.20211,2.24799>,<-4.07308,10.20097,2.2581>,
            
    /*2*/ <-4.13399,10.35966,2.45422>,<-4.15568,10.39243,2.41261>,<-4.09918,10.39141,2.42171>,
            
    /*3*/ <-4.18227,10.59529,2.5558>,<-4.19909,10.61171,2.51068>,<-4.14993,10.61664,2.52283>,
            
    /*4*/ <-4.20063,10.81779,2.67029>,<-4.21616,10.83634,2.63293>,<-4.17238,10.83585,2.641>,
            
    /*5*/ <-4.23605,11.04935,2.76848>,<-4.24891,11.06214,2.7349>,<-4.21172,11.06432,2.74318>,
            
    /*6*/ <-4.26338,11.28306,2.86151>,<-4.27407,11.29342,2.83341>,<-4.24297,11.29446,2.83995>,
            
    /*7*/ <-4.29908,11.51877,2.94601>,<-4.30747,11.52604,2.92312>,<-4.28272,11.52778,2.92873>,
            
    /*8*/ <-4.33643,11.75632,3.02395>,<-4.34264,11.76129,3.00661>,<-4.32411,11.7628,3.0109>,
            
    /*9*/ <-4.34362,11.9941,3.10834>,<-4.34786,11.99815,3.09706>,<-4.33536,11.99771,3.09937>,
            
    /*10*/ <-4.37663,12.21717,3.21953>,<-4.37879,12.21965,3.21409>,<-4.37258,12.21989,3.21545>,
            
    /*11*/ <-4.4074,12.45278,3.3059>

    /* stem 0.11.11.0*/ 
    /*0*/ <-4.12467,10.33945,2.39408>,
    /*1*/ <-4.13289,10.34732,2.38368>,<-4.11488,10.34688,2.40338>,<-4.12624,10.32416,2.39518>,
            
    /*2*/ <-4.82815,10.45829,3.03969>

    /* stem 0.11.11.1*/ 
    /*0*/ <-4.16126,10.53227,2.49633>,
    /*1*/ <-4.14778,10.53257,2.50203>,<-4.17289,10.53455,2.50493>,<-4.16312,10.52968,2.48204>,
            
    /*2*/ <-4.11035,11.42375,2.32814>

    /* stem 0.11.11.2*/ 
    /*0*/ <-4.20693,10.89726,2.67773>,
    /*1*/ <-4.21922,10.89384,2.68113>,<-4.20473,10.90879,2.67169>,<-4.19685,10.88915,2.68036>,
            
    /*2*/ <-4.10742,11.25502,3.39763>

    /* stem 0.11.11.3*/ 
    /*0*/ <-4.25176,11.22075,2.81611>,
    /*1*/ <-4.24579,11.22532,2.80683>,<-4.24916,11.2243,2.82721>,<-4.26034,11.21264,2.81428>,
            
    /*2*/ <-4.74219,11.75177,2.76168>

    /* stem 0.11.11.4*/ 
    /*0*/ <-4.28159,11.42855,2.89677>,
    /*1*/ <-4.27977,11.42494,2.90715>,<-4.2907,11.43455,2.89447>,<-4.2743,11.42617,2.88869>,
            
    /*2*/ <-3.94506,11.9925,3.03397>

    /* stem 0.11.11.5*/ 
    /*0*/ <-4.31149,11.61781,2.96484>,
    /*1*/ <-4.31928,11.6189,2.95802>,<-4.30381,11.62483,2.96513>,<-4.31137,11.6097,2.97136>,
            
    /*2*/ <-4.63063,11.94974,3.38314>

    /* stem 0.11.11.6*/ 
    /*0*/ <-4.3589,12.10624,3.15818>,
    /*1*/ <-4.35342,12.1069,3.15851>,<-4.36211,12.10751,3.1625>,<-4.36118,12.10431,3.15352>,
            
    /*2*/ <-4.40416,12.56929,2.98883>

    /* stem 0.11.11.7*/ 
    /*0*/ <-4.3879,12.30755,3.25029>,
    /*1*/ <-4.38965,12.30683,3.25156>,<-4.38817,12.3093,3.24885>,<-4.38587,12.30652,3.25047>,
            
    /*2*/ <-4.2727,12.58916,3.57014>

    /* stem 0.11.12*/ 
    /*0*/ <-4.64733,10.74142,2.66269>,
    /*1*/ <-4.65666,10.74719,2.64266>,<-4.63643,10.75715,2.67516>,<-4.64889,10.71993,2.67025>,
            
    /*2*/ <-4.84374,10.79615,2.74654>,<-4.82553,10.80511,2.77579>,<-4.83675,10.77161,2.77137>,
            
    /*3*/ <-4.98232,10.91215,2.87514>,<-4.95902,10.91731,2.89592>,<-4.97763,10.89191,2.89901>,
            
    /*4*/ <-5.08921,11.06268,2.99362>,<-5.06722,11.06562,3.01018>,<-5.08675,11.04696,3.01628>,
            
    /*5*/ <-5.19527,11.2387,3.05986>,<-5.17803,11.24345,3.07547>,<-5.19644,11.2299,3.08188>,
            
    /*6*/ <-5.2728,11.42113,3.15995>,<-5.25668,11.42189,3.17139>,<-5.27261,11.41184,3.17741>,
            
    /*7*/ <-5.34065,11.60955,3.24904>,<-5.32771,11.61007,3.25815>,<-5.34079,11.60288,3.26339>,
            
    /*8*/ <-5.39205,11.8059,3.3328>,<-5.38218,11.80579,3.3394>,<-5.39227,11.8013,3.34374>,
            
    /*9*/ <-5.43399,12.00686,3.41037>,<-5.42738,12.00664,3.41471>,<-5.4342,12.00404,3.41776>,
            
    /*10*/ <-5.43412,12.21295,3.48702>,<-5.43075,12.21227,3.48897>,<-5.43422,12.21161,3.49074>,
            
    /*11*/ <-5.3948,12.42608,3.52064>

    /* stem 0.11.12.0*/ 
    /*0*/ <-4.73738,10.76515,2.71149>,
    /*1*/ <-4.73235,10.76916,2.71882>,<-4.74395,10.75817,2.71332>,<-4.73585,10.76811,2.70232>,
            
    /*2*/ <-5.3429,11.35877,2.80199>

    /* stem 0.11.12.1*/ 
    /*0*/ <-4.90796,10.85225,2.83076>,
    /*1*/ <-4.9141,10.84542,2.83034>,<-4.91073,10.86097,2.82998>,<-4.89906,10.85035,2.83194>,
            
    /*2*/ <-5.00491,10.89141,3.62141>

    /* stem 0.11.12.2*/ 
    /*0*/ <-5.13041,11.13954,3.03648>,
    /*1*/ <-5.12654,11.14395,3.03087>,<-5.13168,11.14261,3.0439>,<-5.13301,11.13205,3.03468>,
            
    /*2*/ <-5.73894,11.4022,2.8238>

    /* stem 0.11.12.3*/ 
    /*0*/ <-5.23987,11.35407,3.13509>,
    /*1*/ <-5.23859,11.35102,3.14178>,<-5.24612,11.35796,3.1339>,<-5.23491,11.35321,3.12959>,
            
    /*2*/ <-4.94496,11.88337,3.31931>

    /* stem 0.11.12.4*/ 
    /*0*/ <-5.31547,11.55016,3.23041>,
    /*1*/ <-5.32042,11.55054,3.22567>,<-5.31239,11.55589,3.23263>,<-5.31359,11.54405,3.23294>,
            
    /*2*/ <-5.71152,11.60126,3.64814>

    /* stem 0.11.12.5*/ 
    /*0*/ <-5.35741,11.68641,3.28965>,
    /*1*/ <-5.35113,11.68779,3.29036>,<-5.36162,11.68799,3.29431>,<-5.35949,11.68345,3.28428>,
            
    /*2*/ <-5.43651,12.16732,3.05524>

    /* stem 0.11.12.6*/ 
    /*0*/ <-5.4324,12.10204,3.44905>,
    /*1*/ <-5.43515,12.10128,3.4511>,<-5.43247,12.10489,3.44702>,<-5.4296,12.09994,3.44904>,
            
    /*2*/ <-5.25792,12.33447,3.76869>

    /* stem 0.11.12.7*/ 
    /*0*/ <-5.42222,12.27273,3.49788>,
    /*1*/ <-5.42193,12.27291,3.49628>,<-5.42129,12.27351,3.49898>,<-5.42344,12.27176,3.49838>,
            
    /*2*/ <-5.66675,12.5751,3.48846>

    /* stem 0.12*/ 
    /*0*/ <-0.03202,8.86045,-0.27682>,
    /*1*/ <0.08567,8.86467,-0.23405>,<-0.00435,8.97996,-0.25135>,<-0.1326,8.93009,-0.30385>,
            <-0.12186,8.78397,-0.31899>,<0.01304,8.74354,-0.27585>,
    /*2*/ <0.32535,8.95518,-0.93731>,<0.24388,9.05951,-0.95297>,<0.12781,9.01438,-1.00049>,
            <0.13754,8.88215,-1.01419>,<0.25962,8.84556,-0.97515>,
    /*3*/ <0.56964,9.06689,-1.63479>,<0.49603,9.16,-1.64685>,<0.39285,9.1199,-1.69135>,
            <0.40269,9.00201,-1.70678>,<0.51195,8.96925,-1.67183>,
    /*4*/ <0.81765,9.23995,-2.31789>,<0.75055,9.32097,-2.32281>,<0.66088,9.28639,-2.36587>,
            <0.67256,9.184,-2.38756>,<0.76945,9.1553,-2.35791>,
    /*5*/ <1.05062,9.41484,-3.00957>,<0.99194,9.48474,-3.01258>,<0.91356,9.45428,-3.04818>,
            <0.92379,9.36554,-3.06716>,<1.0085,9.34117,-3.0433>,
    /*6*/ <1.34294,9.67209,-3.63899>,<1.29247,9.73067,-3.63935>,<1.22997,9.70812,-3.67891>,
            <1.24183,9.6356,-3.70301>,<1.31164,9.61334,-3.67833>,
    /*7*/ <1.61884,9.91171,-4.2948>,<1.57756,9.95974,-4.2953>,<1.52534,9.94035,-4.32544>,
            <1.53435,9.88034,-4.34357>,<1.59213,9.86264,-4.32463>,
    /*8*/ <1.90005,10.16103,-4.94136>,<1.86779,10.19837,-4.94152>,<1.82741,10.18353,-4.96567>,
            <1.8347,10.13702,-4.98044>,<1.87959,10.12311,-4.96541>,
    /*9*/ <2.16725,10.44275,-5.5819>,<2.14353,10.46894,-5.58066>,<2.11462,10.45832,-5.59801>,
            <2.12047,10.42557,-5.60997>,<2.153,10.41595,-5.60001>,
    /*10*/ <2.39496,10.8162,-6.19035>,<2.37968,10.83081,-6.18734>,<2.36232,10.82452,-6.19809>,
            <2.36688,10.80602,-6.20774>,<2.38705,10.80088,-6.20296>,
    /*11*/ <2.64627,11.27003,-6.72816>,<2.64085,11.27481,-6.72675>,<2.63512,11.27308,-6.73105>,
            <2.637,11.26723,-6.7351>,<2.64389,11.26535,-6.73332>,
    /*12*/ <2.64063,11.2701,-6.73088>

    /* stem 0.12c0*/ 
    /*0*/ <0.73422,9.23732,-2.35041>,
    /*1*/ <0.80099,9.2408,-2.2908>,<0.73957,9.32131,-2.3197>,<0.67075,9.28576,-2.39104>,
            <0.68963,9.18327,-2.40623>,<0.77013,9.15549,-2.34427>,
    /*2*/ <1.27258,9.41008,-2.84683>,<1.21932,9.47989,-2.8719>,<1.15964,9.44906,-2.93376>,
            <1.17602,9.36019,-2.94692>,<1.24582,9.3361,-2.8932>,
    /*3*/ <1.7451,9.61358,-3.38883>,<1.69856,9.67215,-3.40842>,<1.64946,9.64662,-3.46242>,
            <1.66565,9.57228,-3.47622>,<1.72476,9.55186,-3.43074>,
    /*4*/ <2.22464,9.77071,-3.94211>,<2.18852,9.81942,-3.96038>,<2.14728,9.79812,-4.00347>,
            <2.15791,9.73625,-4.01183>,<2.20572,9.71931,-3.9739>,
    /*5*/ <2.70292,9.89199,-4.5058>,<2.6758,9.93023,-4.5212>,<2.64282,9.91338,-4.5538>,
            <2.64955,9.86473,-4.55855>,<2.6867,9.85151,-4.52888>,
    /*6*/ <3.09593,10.0492,-5.13002>,<3.07383,10.07572,-5.13764>,<3.04786,10.06283,-5.15786>,
            <3.05391,10.02834,-5.16274>,<3.08362,10.01992,-5.14553>,
    /*7*/ <3.50674,10.17968,-5.74091>,<3.49393,10.1959,-5.74631>,<3.47841,10.18818,-5.75879>,
            <3.48163,10.16719,-5.76111>,<3.49914,10.16194,-5.75006>,
    /*8*/ <3.86771,10.29108,-6.38883>,<3.86316,10.29663,-6.3905>,<3.85748,10.29385,-6.39427>,
            <3.85851,10.28659,-6.39494>,<3.86484,10.28488,-6.39158>,
    /*9*/ <3.86234,10.29061,-6.39202>

    /* stem 0.12c0c0*/ 
    /*0*/ <3.07103,10.0472,-5.14676>,
    /*1*/ <3.10072,10.0483,-5.15139>,<3.08012,10.0755,-5.14217>,<3.04696,10.0636,-5.13929>,
            <3.04707,10.02904,-5.14673>,<3.0803,10.01959,-5.15421>,
    /*2*/ <2.97052,10.20315,-5.87201>,<2.95808,10.21959,-5.86643>,<2.93804,10.2124,-5.8647>,
            <2.93811,10.19152,-5.86919>,<2.95818,10.18581,-5.87371>,
    /*3*/ <2.79233,10.36239,-6.58256>,<2.7881,10.36798,-6.58032>,<2.78127,10.3654,-6.5793>,
            <2.78129,10.35822,-6.58092>,<2.78813,10.35636,-6.58293>,
    /*4*/ <2.78622,10.36207,-6.5812>

    /* stem 0.12c0c0.0*/ 
    /*0*/ <2.8456,10.30512,-6.3271>,
    /*1*/ <2.83596,10.30812,-6.32417>,<2.84679,10.29744,-6.33418>,<2.85405,10.30979,-6.32294>,
            
    /*2*/ <2.83461,10.43393,-6.46152>,<2.84436,10.42432,-6.47053>,<2.85089,10.43544,-6.46041>,
            
    /*3*/ <2.85088,10.57557,-6.58193>,<2.85965,10.56752,-6.59033>,<2.86528,10.57584,-6.57977>,
            
    /*4*/ <2.87623,10.7187,-6.69891>,<2.88393,10.71153,-6.70611>,<2.88876,10.71847,-6.69657>,
            
    /*5*/ <2.88001,10.87176,-6.80317>,<2.88666,10.86681,-6.81028>,<2.89084,10.87243,-6.80189>,
            
    /*6*/ <2.90195,11.04114,-6.87781>,<2.90757,11.0377,-6.88408>,<2.9109,11.04075,-6.87618>,
            
    /*7*/ <2.95314,11.21485,-6.92344>,<2.95769,11.21222,-6.92849>,<2.96004,11.21331,-6.92168>,
            
    /*8*/ <3.00052,11.37918,-6.99762>,<3.00376,11.37666,-7.00122>,<3.00576,11.37826,-6.99639>,
            
    /*9*/ <3.01248,11.53804,-7.09334>,<3.01463,11.53642,-7.0958>,<3.01609,11.53806,-7.09289>,
            
    /*10*/ <3.00487,11.69831,-7.18752>,<3.00594,11.69761,-7.18882>,<3.00668,11.69848,-7.1874>,
            
    /*11*/ <2.99126,11.84556,-7.30081>

    /* stem 0.12c0c0.0.0*/ 
    /*0*/ <2.84387,10.39956,-6.42974>,
    /*1*/ <2.84584,10.39667,-6.43243>,<2.84543,10.40368,-6.42939>,<2.84033,10.39834,-6.42739>,
            
    /*2*/ <2.41881,10.60563,-6.96189>

    /* stem 0.12c0c0.0.1*/ 
    /*0*/ <2.86496,10.61033,-6.6144>,
    /*1*/ <2.86582,10.61273,-6.61126>,<2.86278,10.61175,-6.61749>,<2.86627,10.60651,-6.61443>,
            
    /*2*/ <3.40592,10.79896,-6.90849>

    /* stem 0.12c0c0.0.2*/ 
    /*0*/ <2.88446,10.79648,-6.755>,
    /*1*/ <2.88151,10.79525,-6.7569>,<2.88731,10.79806,-6.7568>,<2.88456,10.79615,-6.75129>,
            
    /*2*/ <2.62864,11.32268,-6.70014>

    /* stem 0.12c0c0.0.3*/ 
    /*0*/ <2.90138,10.99602,-6.86016>,
    /*1*/ <2.90477,10.99563,-6.86009>,<2.9,10.99906,-6.85947>,<2.89938,10.99337,-6.86092>,
            
    /*2*/ <2.92649,11.12476,-7.37686>

    /* stem 0.12c0c0.0.4*/ 
    /*0*/ <2.98359,11.30796,-6.96695>,
    /*1*/ <2.98149,11.30926,-6.96538>,<2.984,11.30871,-6.96976>,<2.98529,11.3059,-6.96572>,
            
    /*2*/ <3.27639,11.62624,-6.83846>

    /* stem 0.12c0c0.0.5*/ 
    /*0*/ <3.00817,11.4477,-7.04017>,
    /*1*/ <3.00847,11.44631,-7.04246>,<3.00993,11.44965,-7.03955>,<3.00613,11.44714,-7.03851>,
            
    /*2*/ <2.77265,11.72278,-7.2379>

    /* stem 0.12c0c0.0.6*/ 
    /*0*/ <2.99803,11.77702,-7.24833>,
    /*1*/ <2.9983,11.77729,-7.24802>,<2.99764,11.77722,-7.24854>,<2.99816,11.77656,-7.24843>,
            
    /*2*/ <3.17825,11.87853,-7.49092>

    /* stem 0.12c0.0*/ 
    /*0*/ <1.01508,9.33655,-2.67082>,
    /*1*/ <0.98649,9.29545,-2.7086>,<1.07441,9.32676,-2.65301>,<0.98432,9.38744,-2.65084>,
            
    /*2*/ <1.10154,9.47603,-2.98165>,<1.18067,9.50421,-2.93161>,<1.09959,9.55882,-2.92966>,
            
    /*3*/ <1.16946,9.66847,-3.25898>,<1.24294,9.69721,-3.22254>,<1.16868,9.74082,-3.21083>,
            
    /*4*/ <1.29057,9.89286,-3.50744>,<1.35037,9.91049,-3.4639>,<1.28618,9.95091,-3.45852>,
            
    /*5*/ <1.44167,10.14026,-3.71076>,<1.48869,10.14925,-3.66652>,<1.4341,10.18476,-3.66375>,
            
    /*6*/ <1.50911,10.43414,-3.88575>,<1.55026,10.44565,-3.85222>,<1.50028,10.46376,-3.84109>,
            
    /*7*/ <1.63302,10.70558,-4.06406>,<1.66455,10.71134,-4.03472>,<1.62648,10.73178,-4.03001>,
            
    /*8*/ <1.80447,10.99526,-4.1704>,<1.82447,10.99339,-4.14474>,<1.79682,11.01051,-4.14263>,
            
    /*9*/ <1.99103,11.28974,-4.20845>,<2.00225,11.28535,-4.19036>,<1.98398,11.29706,-4.18925>,
            
    /*10*/ <2.1706,11.58677,-4.22772>,<2.17601,11.58429,-4.21863>,<2.16674,11.58992,-4.21807>,
            
    /*11*/ <2.34297,11.88406,-4.17071>

    /* stem 0.12c0.0.0*/ 
    /*0*/ <1.07414,9.42945,-2.81655>,
    /*1*/ <1.09771,9.43327,-2.80457>,<1.0631,9.44911,-2.83088>,<1.06162,9.40598,-2.81421>,
            
    /*2*/ <1.70551,8.98303,-3.91569>

    /* stem 0.12c0.0.1*/ 
    /*0*/ <1.17589,9.65146,-3.15487>,
    /*1*/ <1.15283,9.66086,-3.154>,<1.18402,9.64034,-3.17563>,<1.1908,9.65318,-3.135>,
            
    /*2*/ <1.60494,10.7419,-3.57101>

    /* stem 0.12c0.0.2*/ 
    /*0*/ <1.24713,9.80219,-3.34466>,
    /*1*/ <1.25952,9.78439,-3.35448>,<1.25787,9.82284,-3.33968>,<1.22399,9.79933,-3.33983>,
            
    /*2*/ <0.9724,10.20507,-4.42206>

    /* stem 0.12c0.0.3*/ 
    /*0*/ <1.37175,10.02132,-3.56425>,
    /*1*/ <1.37268,10.03543,-3.54695>,<1.36262,10.0279,-3.58355>,<1.37994,10.00063,-3.56224>,
            
    /*2*/ <2.35625,10.37771,-3.90832>

    /* stem 0.12c0.0.4*/ 
    /*0*/ <1.46954,10.22363,-3.72091>,
    /*1*/ <1.45606,10.21735,-3.73593>,<1.4887,10.23079,-3.72622>,<1.46385,10.22274,-3.70057>,
            
    /*2*/ <1.09225,11.18621,-3.78448>

    /* stem 0.12c0.0.5*/ 
    /*0*/ <1.50166,10.3667,-3.80946>,
    /*1*/ <1.5214,10.36527,-3.80461>,<1.49177,10.38431,-3.8068>,<1.49182,10.35051,-3.81697>,
            
    /*2*/ <1.74855,10.64447,-4.73215>

    /* stem 0.12c0.0.6*/ 
    /*0*/ <1.56651,10.55088,-3.93003>,
    /*1*/ <1.55094,10.56127,-3.92514>,<1.57187,10.54962,-3.94859>,<1.57674,10.54175,-3.91637>,
            
    /*2*/ <2.10704,11.31214,-3.82582>

    /* stem 0.12c0.0.7*/ 
    /*0*/ <1.69547,10.80797,-4.07842>,
    /*1*/ <1.70223,10.79867,-4.09214>,<1.70567,10.81986,-4.06977>,<1.6785,10.80538,-4.07335>,
            
    /*2*/ <1.43879,11.42429,-4.62241>

    /* stem 0.12c0.0.8*/ 
    /*0*/ <1.94276,11.21211,-4.18429>,
    /*1*/ <1.94433,11.21322,-4.17018>,<1.93929,11.22357,-4.19199>,<1.94465,11.19953,-4.19069>,
            
    /*2*/ <2.66444,11.36788,-4.27704>

    /* stem 0.12c0.0.9*/ 
    /*0*/ <2.07589,11.42911,-4.20791>,
    /*1*/ <2.07001,11.43205,-4.21492>,<2.08539,11.43031,-4.20877>,<2.07227,11.42496,-4.20003>,
            
    /*2*/ <2.02543,12.04091,-3.90916>

    /* stem 0.12c0.0.10*/ 
    /*0*/ <2.27488,11.76636,-4.19082>,
    /*1*/ <2.27699,11.76509,-4.19049>,<2.27425,11.76816,-4.18922>,<2.2734,11.76584,-4.19275>,
            
    /*2*/ <2.56387,12.16,-4.51849>

    /* stem 0.12c0.1*/ 
    /*0*/ <1.47694,9.51818,-3.1895>,
    /*1*/ <1.52003,9.52022,-3.14988>,<1.46416,9.56565,-3.22133>,<1.44663,9.46868,-3.19728>,
            
    /*2*/ <1.72624,9.42634,-3.37803>,<1.67596,9.46723,-3.44233>,<1.66018,9.37995,-3.42068>,
            
    /*3*/ <1.94224,9.4104,-3.61477>,<1.89141,9.44825,-3.66545>,<1.89087,9.36726,-3.66044>,
            
    /*4*/ <2.15916,9.46943,-3.84269>,<2.11017,9.5019,-3.88254>,<2.12135,9.43216,-3.88985>,
            
    /*5*/ <2.39864,9.57864,-4.01404>,<2.3601,9.60641,-4.05209>,<2.37785,9.54925,-4.06311>,
            
    /*6*/ <2.62812,9.77392,-4.10419>,<2.59695,9.79678,-4.13703>,<2.62461,9.75694,-4.15185>,
            
    /*7*/ <2.78901,10.03027,-4.22822>,<2.75662,10.04051,-4.25042>,<2.78471,10.01559,-4.2658>,
            
    /*8*/ <2.88507,10.30401,-4.37537>,<2.85812,10.3065,-4.38928>,<2.88083,10.29135,-4.40272>,
            
    /*9*/ <2.96179,10.57534,-4.53205>,<2.94344,10.57591,-4.54069>,<2.95872,10.56627,-4.54993>,
            
    /*10*/ <3.01535,10.84529,-4.69992>,<3.006,10.84491,-4.70383>,<3.0137,10.84039,-4.70864>,
            
    /*11*/ <3.07103,11.12879,-4.83998>

    /* stem 0.12c0.1.0*/ 
    /*0*/ <1.62913,9.45046,-3.35157>,
    /*1*/ <1.61797,9.46496,-3.36811>,<1.63508,9.42727,-3.35751>,<1.63435,9.45915,-3.32908>,
            
    /*2*/ <2.72596,9.83485,-3.75468>

    /* stem 0.12c0.1.1*/ 
    /*0*/ <1.81004,9.41569,-3.5432>,
    /*1*/ <1.81285,9.39274,-3.53897>,<1.82864,9.42902,-3.5486>,<1.78862,9.42532,-3.54202>,
            
    /*2*/ <1.64518,9.1871,-4.67454>

    /* stem 0.12c0.1.2*/ 
    /*0*/ <1.97542,9.42656,-3.71497>,
    /*1*/ <1.98028,9.4461,-3.70502>,<1.97452,9.42528,-3.73737>,<1.97146,9.4083,-3.70251>,
            
    /*2*/ <3.05387,9.17287,-3.74363>

    /* stem 0.12c0.1.3*/ 
    /*0*/ <2.19258,9.49548,-3.91467>,
    /*1*/ <2.18351,9.48839,-3.93238>,<2.21284,9.49106,-3.91068>,<2.18138,9.50699,-3.90096>,
            
    /*2*/ <2.47826,10.36006,-4.40697>

    /* stem 0.12c0.1.4*/ 
    /*0*/ <2.51099,9.68804,-4.09196>,
    /*1*/ <2.52173,9.68165,-4.0773>,<2.50878,9.70697,-4.09475>,<2.50246,9.67549,-4.10383>,
            
    /*2*/ <3.26627,9.69499,-4.6421>

    /* stem 0.12c0.1.5*/ 
    /*0*/ <2.69784,9.90418,-4.19044>,
    /*1*/ <2.68244,9.91313,-4.19217>,<2.70937,9.90348,-4.2041>,<2.7017,9.89592,-4.17504>,
            
    /*2*/ <3.08129,10.61948,-3.90297>

    /* stem 0.12c0.1.6*/ 
    /*0*/ <2.84037,10.20537,-4.33973>,
    /*1*/ <2.85064,10.19687,-4.349>,<2.84539,10.21898,-4.33243>,<2.82509,10.20027,-4.33775>,
            
    /*2*/ <2.62329,10.61639,-4.9572>

    /* stem 0.12c0.1.7*/ 
    /*0*/ <2.89914,10.3838,-4.43555>,
    /*1*/ <2.89888,10.3913,-4.42225>,<2.89102,10.38898,-4.4474>,<2.90752,10.37111,-4.437>,
            
    /*2*/ <3.46354,10.78095,-4.64851>

    /* stem 0.12c0.1.8*/ 
    /*0*/ <2.98567,10.71993,-4.62969>,
    /*1*/ <2.98033,10.71736,-4.63582>,<2.99323,10.72331,-4.63175>,<2.98346,10.71912,-4.62149>,
            
    /*2*/ <2.72659,11.29043,-4.64311>

    /* stem 0.12c0.1.9*/ 
    /*0*/ <3.04556,11.00637,-4.78168>,
    /*1*/ <3.04798,11.00618,-4.78104>,<3.04428,11.00847,-4.78115>,<3.04442,11.00447,-4.78287>,
            
    /*2*/ <3.19214,11.21862,-5.2646>

    /* stem 0.12c0.2*/ 
    /*0*/ <1.92175,9.68389,-3.6846>,
    /*1*/ <1.88497,9.71665,-3.70808>,<1.94566,9.64442,-3.71372>,<1.93463,9.69061,-3.63201>,
            
    /*2*/ <2.10537,9.9015,-3.78283>,<2.15999,9.8365,-3.7879>,<2.15007,9.87807,-3.71436>,
            
    /*3*/ <2.26841,10.13261,-3.83536>,<2.32934,10.08874,-3.84427>,<2.31239,10.11649,-3.77601>,
            
    /*4*/ <2.45379,10.36405,-3.88115>,<2.50513,10.32291,-3.88809>,<2.48983,10.34694,-3.82838>,
            
    /*5*/ <2.62588,10.58047,-3.98129>,<2.66913,10.54434,-3.98761>,<2.66246,10.5723,-3.93874>,
            
    /*6*/ <2.7738,10.82598,-4.05042>,<2.81332,10.80106,-4.05752>,<2.80393,10.81878,-4.01473>,
            
    /*7*/ <2.91526,11.08819,-4.05866>,<2.94834,11.07086,-4.06452>,<2.93681,11.07815,-4.02926>,
            
    /*8*/ <3.08514,11.33514,-4.04932>,<3.10855,11.31973,-4.05359>,<3.09959,11.32488,-4.02719>,
            
    /*9*/ <3.28079,11.56036,-4.02695>,<3.29523,11.5485,-4.02981>,<3.2892,11.55199,-4.01224>,
            
    /*10*/ <3.44818,11.79346,-3.95031>,<3.45606,11.78837,-3.95146>,<3.4518,11.78865,-3.94302>,
            
    /*11*/ <3.59464,12.02233,-3.82969>

    /* stem 0.12c0.2.0*/ 
    /*0*/ <2.05868,9.80276,-3.73331>,
    /*1*/ <2.07234,9.78488,-3.73854>,<2.0671,9.8206,-3.72129>,<2.0366,9.80279,-3.74011>,
            
    /*2*/ <2.35974,10.31781,-4.70897>

    /* stem 0.12c0.2.1*/ 
    /*0*/ <2.24891,10.03315,-3.79977>,
    /*1*/ <2.24108,10.04274,-3.78188>,<2.24783,10.04336,-3.81894>,<2.25782,10.01335,-3.79847>,
            
    /*2*/ <3.20561,10.47561,-3.61826>

    /* stem 0.12c0.2.2*/ 
    /*0*/ <2.39677,10.23331,-3.84317>,
    /*1*/ <2.39304,10.23207,-3.86343>,<2.4162,10.23459,-3.83631>,<2.38108,10.23328,-3.82976>,
            
    /*2*/ <2.34927,11.23972,-3.89619>

    /* stem 0.12c0.2.3*/ 
    /*0*/ <2.60142,10.49912,-3.93809>,
    /*1*/ <2.61522,10.49425,-3.92585>,<2.59687,10.51749,-3.94053>,<2.59215,10.48561,-3.94788>,
            
    /*2*/ <3.22602,10.56323,-4.61715>

    /* stem 0.12c0.2.4*/ 
    /*0*/ <2.74816,10.73091,-4.01666>,
    /*1*/ <2.73271,10.73976,-4.01699>,<2.75988,10.73296,-4.0299>,<2.75188,10.72,-4.00309>,
            
    /*2*/ <3.11145,11.38078,-3.59391>

    /* stem 0.12c0.2.5*/ 
    /*0*/ <2.83945,10.89732,-4.04398>,
    /*1*/ <2.85099,10.89095,-4.05461>,<2.8442,10.90804,-4.03176>,<2.82317,10.89296,-4.04556>,
            
    /*2*/ <2.72115,11.52152,-4.54626>

    /* stem 0.12c0.2.6*/ 
    /*0*/ <3.03309,11.22915,-4.0463>,
    /*1*/ <3.03039,11.23049,-4.03141>,<3.03357,11.24154,-4.05507>,<3.0353,11.21543,-4.05241>,
            
    /*2*/ <3.73763,11.2883,-3.92413>

    /* stem 0.12c0.2.7*/ 
    /*0*/ <3.1557,11.39559,-4.03718>,
    /*1*/ <3.15101,11.40064,-4.04963>,<3.16963,11.3935,-4.03513>,<3.14646,11.39262,-4.02676>,
            
    /*2*/ <3.21542,12.01936,-3.80646>

    /* stem 0.12c0.2.8*/ 
    /*0*/ <3.34311,11.63271,-3.99801>,
    /*1*/ <3.3495,11.62722,-3.9946>,<3.34103,11.64046,-3.99374>,<3.33881,11.63046,-4.00569>,
            
    /*2*/ <3.75741,11.91836,-4.31409>

    /* stem 0.12c0.2.9*/ 
    /*0*/ <3.50916,11.88319,-3.90075>,
    /*1*/ <3.50629,11.88454,-3.89994>,<3.51161,11.88507,-3.90182>,<3.50958,11.87995,-3.90049>,
            
    /*2*/ <3.67494,11.94389,-3.41354>

    /* stem 0.12c0.3*/ 
    /*0*/ <2.3404,9.80763,-4.15584>,
    /*1*/ <2.35363,9.75935,-4.15482>,<2.37523,9.84325,-4.15077>,<2.29235,9.8203,-4.16194>,
            
    /*2*/ <2.38787,9.76817,-4.42697>,<2.40731,9.84368,-4.42333>,<2.33271,9.82303,-4.43338>,
            
    /*3*/ <2.45851,9.8285,-4.69209>,<2.47154,9.89439,-4.6747>,<2.40804,9.87597,-4.69572>,
            
    /*4*/ <2.49978,9.96796,-4.93909>,<2.50851,10.0199,-4.9089>,<2.45272,10.00439,-4.9271>,
            
    /*5*/ <2.57829,10.15205,-5.13468>,<2.58213,10.18959,-5.09885>,<2.53718,10.18209,-5.12396>,
            
    /*6*/ <2.65148,10.36174,-5.30236>,<2.65299,10.389,-5.26867>,<2.6161,10.38407,-5.29094>,
            
    /*7*/ <2.72451,10.59241,-5.43809>,<2.72433,10.6105,-5.40849>,<2.69551,10.60835,-5.42768>,
            
    /*8*/ <2.75106,10.8448,-5.55164>,<2.75044,10.85587,-5.52811>,<2.72835,10.85223,-5.54135>,
            
    /*9*/ <2.77763,11.10202,-5.64612>,<2.77708,11.10831,-5.62996>,<2.76243,11.10648,-5.63905>,
            
    /*10*/ <2.84322,11.3481,-5.74559>,<2.84299,11.35153,-5.73763>,<2.83583,11.35146,-5.74253>,
            
    /*11*/ <2.86968,11.60136,-5.84895>

    /* stem 0.12c0.3.0*/ 
    /*0*/ <2.36324,9.8102,-4.33059>,
    /*1*/ <2.37197,9.82945,-4.32916>,<2.35052,9.80551,-4.34686>,<2.36724,9.79563,-4.31573>,
            
    /*2*/ <3.19586,9.4737,-4.88479>

    /* stem 0.12c0.3.1*/ 
    /*0*/ <2.41548,9.84245,-4.57429>,
    /*1*/ <2.39846,9.83391,-4.58068>,<2.4331,9.83679,-4.58209>,<2.41487,9.85665,-4.5601>,
            
    /*2*/ <2.32864,10.54106,-5.27687>

    /* stem 0.12c0.3.2*/ 
    /*0*/ <2.4678,9.93595,-4.81369>,
    /*1*/ <2.48631,9.93219,-4.81257>,<2.46194,9.95316,-4.81895>,<2.45514,9.92251,-4.80954>,
            
    /*2*/ <2.46598,9.66303,-5.70367>

    /* stem 0.12c0.3.3*/ 
    /*0*/ <2.52185,10.0757,-5.01081>,
    /*1*/ <2.50966,10.08738,-5.00511>,<2.52513,10.07405,-5.02826>,<2.53076,10.06567,-4.99908>,
            
    /*2*/ <3.1369,10.68963,-4.95328>

    /* stem 0.12c0.3.4*/ 
    /*0*/ <2.61325,10.30445,-5.22638>,
    /*1*/ <2.61543,10.29366,-5.23849>,<2.6231,10.31746,-5.22516>,<2.60124,10.30222,-5.2155>,
            
    /*2*/ <2.12007,10.72072,-5.68576>

    /* stem 0.12c0.3.5*/ 
    /*0*/ <2.7348,10.77738,-5.50596>,
    /*1*/ <2.74139,10.7819,-5.49468>,<2.72567,10.78554,-5.51235>,<2.73735,10.76471,-5.51084>,
            
    /*2*/ <3.2145,11.01914,-5.88285>

    /* stem 0.12c0.3.6*/ 
    /*0*/ <2.76033,11.00014,-5.59778>,
    /*1*/ <2.74917,10.99964,-5.60241>,<2.76954,11.00392,-5.60464>,<2.76227,10.99687,-5.58631>,
            
    /*2*/ <2.66148,11.56263,-5.4204>

    /* stem 0.12c0.3.7*/ 
    /*0*/ <2.7925,11.17771,-5.66888>,
    /*1*/ <2.80035,11.1748,-5.67058>,<2.79139,11.1858,-5.66639>,<2.78576,11.17252,-5.66967>,
            
    /*2*/ <2.73558,11.33185,-6.19517>

    /* stem 0.12c0.3.8*/ 
    /*0*/ <2.8525,11.45267,-5.78554>,
    /*1*/ <2.85096,11.45381,-5.78328>,<2.85173,11.45332,-5.78833>,<2.8548,11.45088,-5.78502>,
            
    /*2*/ <3.14462,11.83101,-5.77836>

    /* stem 0.12c0.4*/ 
    /*0*/ <2.53076,9.85519,-4.37302>,
    /*1*/ <2.54236,9.89485,-4.35416>,<2.51227,9.85431,-4.41449>,<2.53766,9.81642,-4.3504>,
            
    /*2*/ <2.78182,9.87132,-4.46296>,<2.75474,9.83484,-4.51724>,<2.77759,9.80073,-4.45957>,
            
    /*3*/ <2.98156,9.97123,-4.57193>,<2.96785,9.94144,-4.62564>,<3.00456,9.91366,-4.58273>,
            
    /*4*/ <3.14288,10.11829,-4.71446>,<3.12798,10.0916,-4.76026>,<3.17072,10.0736,-4.73058>,
            
    /*5*/ <3.29489,10.3013,-4.81171>,<3.28828,10.28449,-4.85532>,<3.32415,10.26858,-4.82908>,
            
    /*6*/ <3.44232,10.50674,-4.86938>,<3.44089,10.49772,-4.90764>,<3.46974,10.48333,-4.88511>,
            
    /*7*/ <3.58782,10.71966,-4.92286>,<3.5871,10.71301,-4.95361>,<3.61029,10.70169,-4.9356>,
            
    /*8*/ <3.69901,10.94116,-5.01689>,<3.69665,10.93335,-5.03903>,<3.71633,10.92865,-5.02689>,
            
    /*9*/ <3.83682,11.16011,-5.06223>,<3.83669,11.15726,-5.0777>,<3.84841,11.15174,-5.06878>,
            
    /*10*/ <3.96821,11.38515,-5.10298>,<3.96824,11.38387,-5.11074>,<3.97416,11.38121,-5.10629>,
            
    /*11*/ <4.07126,11.62284,-5.15326>

    /* stem 0.12c0.4.0*/ 
    /*0*/ <2.68631,9.84255,-4.44212>,
    /*1*/ <2.67856,9.83565,-4.45829>,<2.70029,9.83281,-4.43325>,<2.68007,9.85919,-4.43482>,
            
    /*2*/ <3.38084,10.34248,-4.98819>

    /* stem 0.12c0.4.1*/ 
    /*0*/ <2.89181,9.89576,-4.54402>,
    /*1*/ <2.90201,9.89037,-4.52991>,<2.89372,9.91258,-4.55074>,<2.87971,9.88432,-4.5514>,
            
    /*2*/ <3.56133,9.57781,-5.14933>

    /* stem 0.12c0.4.2*/ 
    /*0*/ <3.02667,9.9815,-4.63005>,
    /*1*/ <3.01375,9.99298,-4.63253>,<3.03803,9.97822,-4.64291>,<3.02824,9.9733,-4.61471>,
            
    /*2*/ <3.56487,10.65327,-4.32573>

    /* stem 0.12c0.4.3*/ 
    /*0*/ <3.21362,10.17591,-4.77658>,
    /*1*/ <3.22203,10.16484,-4.78484>,<3.22137,10.18692,-4.76759>,<3.19745,10.17598,-4.77729>,
            
    /*2*/ <3.24506,10.69247,-5.43681>

    /* stem 0.12c0.4.4*/ 
    /*0*/ <3.39144,10.41129,-4.86519>,
    /*1*/ <3.38984,10.41609,-4.85119>,<3.39054,10.42093,-4.87651>,<3.39394,10.39686,-4.86788>,
            
    /*2*/ <4.14496,10.53361,-4.82092>

    /* stem 0.12c0.4.5*/ 
    /*0*/ <3.62403,10.77072,-4.96135>,
    /*1*/ <3.61701,10.76973,-4.97227>,<3.63678,10.77327,-4.96201>,<3.6183,10.76915,-4.94976>,
            
    /*2*/ <3.49572,11.41673,-4.93753>

    /* stem 0.12c0.4.6*/ 
    /*0*/ <3.78884,11.07222,-5.05366>,
    /*1*/ <3.79756,11.06771,-5.04914>,<3.7868,11.08272,-5.05216>,<3.78216,11.06623,-5.05968>,
            
    /*2*/ <4.09628,11.19871,-5.52059>

    /* stem 0.12c0.4.7*/ 
    /*0*/ <3.93212,11.31668,-5.09577>,
    /*1*/ <3.92731,11.31968,-5.09424>,<3.93537,11.31847,-5.10033>,<3.93369,11.31191,-5.09273>,
            
    /*2*/ <4.20872,11.60387,-4.78678>

    /* stem 0.12c0.4.8*/ 
    /*0*/ <4.04305,11.556,-5.14025>,
    /*1*/ <4.04362,11.55555,-5.14129>,<4.04372,11.55661,-5.13937>,<4.0418,11.55583,-5.1401>,
            
    /*2*/ <3.96503,11.93699,-5.34634>

    /* stem 0.12c0.5*/ 
    /*0*/ <2.81249,9.9457,-4.74994>,
    /*1*/ <2.7853,9.93073,-4.77148>,<2.84763,9.93196,-4.75163>,<2.80452,9.9744,-4.72671>,
            
    /*2*/ <2.84209,10.09276,-4.94909>,<2.89819,10.09386,-4.93123>,<2.85939,10.13206,-4.90879>,
            
    /*3*/ <2.8969,10.24194,-5.13606>,<2.94702,10.24344,-5.12106>,<2.91315,10.27888,-5.10273>,
            
    /*4*/ <2.91121,10.42898,-5.29685>,<2.95592,10.4338,-5.28814>,<2.92515,10.45728,-5.26366>,
            
    /*5*/ <2.92541,10.63102,-5.44104>,<2.96369,10.63461,-5.43313>,<2.93719,10.65263,-5.41046>,
            
    /*6*/ <2.94483,10.85241,-5.55466>,<2.97663,10.85398,-5.54711>,<2.95433,10.86641,-5.52666>,
            
    /*7*/ <2.95559,11.07035,-5.66915>,<2.98108,11.07241,-5.66359>,<2.96325,11.082,-5.64701>,
            
    /*8*/ <2.99545,11.30442,-5.74731>,<3.01428,11.30329,-5.74187>,<3.00078,11.30981,-5.7292>,
            
    /*9*/ <3.07523,11.53566,-5.79514>,<3.08719,11.53261,-5.79081>,<3.07826,11.5374,-5.78253>,
            
    /*10*/ <3.1395,11.77268,-5.82304>,<3.14555,11.77138,-5.82091>,<3.14089,11.77314,-5.81667>,
            
    /*11*/ <3.20251,12.00742,-5.86613>

    /* stem 0.12c0.5.0*/ 
    /*0*/ <2.83502,10.01259,-4.82485>,
    /*1*/ <2.8508,10.01076,-4.82174>,<2.82903,10.02732,-4.8279>,<2.82523,9.9997,-4.82491>,
            
    /*2*/ <3.00549,9.8875,-5.76465>

    /* stem 0.12c0.5.1*/ 
    /*0*/ <2.90441,10.21339,-5.06697>,
    /*1*/ <2.89293,10.2223,-5.06319>,<2.90594,10.20874,-5.08116>,<2.91436,10.20914,-5.05657>,
            
    /*2*/ <3.398,10.9265,-5.2479>

    /* stem 0.12c0.5.2*/ 
    /*0*/ <2.93539,10.52139,-5.34219>,
    /*1*/ <2.93831,10.51353,-5.35274>,<2.94315,10.53204,-5.33937>,<2.92471,10.51859,-5.33445>,
            
    /*2*/ <2.48428,10.9716,-5.80213>

    /* stem 0.12c0.5.3*/ 
    /*0*/ <2.94933,10.73501,-5.47842>,
    /*1*/ <2.95498,10.73987,-5.46835>,<2.94032,10.74146,-5.48427>,<2.95267,10.72369,-5.48264>,
            
    /*2*/ <3.4474,11.04192,-5.90646>

    /* stem 0.12c0.5.4*/ 
    /*0*/ <2.96142,10.93387,-5.58391>,
    /*1*/ <2.95066,10.93202,-5.58809>,<2.96975,10.93816,-5.5909>,<2.96384,10.93144,-5.57274>,
            
    /*2*/ <2.78626,11.55764,-5.41015>

    /* stem 0.12c0.5.5*/ 
    /*0*/ <2.987,11.20247,-5.70385>,
    /*1*/ <2.99704,11.2001,-5.7061>,<2.98477,11.21097,-5.69798>,<2.97919,11.19636,-5.70748>,
            
    /*2*/ <2.9551,11.53717,-6.20028>

    /* stem 0.12c0.5.6*/ 
    /*0*/ <3.12444,11.70502,-5.81148>,
    /*1*/ <3.12159,11.70624,-5.80775>,<3.12448,11.70774,-5.81549>,<3.12724,11.70106,-5.8112>,
            
    /*2*/ <3.47335,11.9652,-5.63064>

    /* stem 0.12c0.5.7*/ 
    /*0*/ <3.1729,11.89245,-5.84366>,
    /*1*/ <3.17278,11.89212,-5.84548>,<3.17438,11.8933,-5.84297>,<3.17153,11.89193,-5.84254>,
            
    /*2*/ <2.9841,12.26824,-5.89915>

    /* stem 0.12c0.6*/ 
    /*0*/ <3.72824,10.25005,-6.16009>,
    /*1*/ <3.73727,10.24724,-6.15536>,<3.72773,10.25909,-6.16555>,<3.71973,10.24382,-6.15937>,
            
    /*2*/ <3.78916,10.15738,-6.31021>,<3.78057,10.16805,-6.31938>,<3.77338,10.1543,-6.31382>,
            
    /*3*/ <3.81412,10.15707,-6.49808>,<3.80523,10.16865,-6.49928>,<3.79974,10.15509,-6.50006>,
            
    /*4*/ <3.82915,10.24893,-6.66168>,<3.8208,10.25773,-6.65754>,<3.81661,10.24735,-6.66379>,
            
    /*5*/ <3.81645,10.37038,-6.80446>,<3.80937,10.37648,-6.79869>,<3.80566,10.36845,-6.80521>,
            
    /*6*/ <3.7761,10.51164,-6.92122>,<3.77056,10.5153,-6.91492>,<3.76724,10.50933,-6.92102>,
            
    /*7*/ <3.71503,10.66723,-7.00581>,<3.71105,10.66892,-6.99989>,<3.70812,10.66487,-7.00524>,
            
    /*8*/ <3.65608,10.8188,-7.09666>,<3.65302,10.82024,-7.09233>,<3.65088,10.81706,-7.09626>,
            
    /*9*/ <3.60595,10.9843,-7.16637>,<3.604,10.985,-7.16335>,<3.60242,10.98332,-7.1662>,
            
    /*10*/ <3.56035,11.16334,-7.19251>,<3.55946,11.16336,-7.1909>,<3.55857,11.16291,-7.19244>,
            
    /*11*/ <3.52726,11.34141,-7.2361>

    /* stem 0.12c0.6.0*/ 
    /*0*/ <3.75221,10.20913,-6.23018>,
    /*1*/ <3.75052,10.21247,-6.23271>,<3.75177,10.20483,-6.23152>,<3.75434,10.21008,-6.2263>,
            
    /*2*/ <4.38128,10.25607,-6.58809>

    /* stem 0.12c0.6.1*/ 
    /*0*/ <3.81346,10.20113,-6.57176>,
    /*1*/ <3.81282,10.1977,-6.57376>,<3.81649,10.20354,-6.57283>,<3.81107,10.20215,-6.5687>,
            
    /*2*/ <3.42803,10.50677,-6.97497>

    /* stem 0.12c0.6.2*/ 
    /*0*/ <3.81826,10.29176,-6.70859>,
    /*1*/ <3.82115,10.29374,-6.70714>,<3.81519,10.29356,-6.70989>,<3.81845,10.28797,-6.70874>,
            
    /*2*/ <4.06613,10.32566,-7.24995>

    /* stem 0.12c0.6.3*/ 
    /*0*/ <3.7863,10.4584,-6.87457>,
    /*1*/ <3.78291,10.45791,-6.87403>,<3.78743,10.45933,-6.87771>,<3.78855,10.45797,-6.87198>,
            
    /*2*/ <3.73205,10.97771,-6.74066>

    /* stem 0.12c0.6.4*/ 
    /*0*/ <3.67787,10.7546,-7.05645>,
    /*1*/ <3.67988,10.75411,-7.05855>,<3.67732,10.75736,-7.05555>,<3.6764,10.75234,-7.05524>,
            
    /*2*/ <3.35756,10.79372,-7.37202>

    /* stem 0.12c0.6.5*/ 
    /*0*/ <3.63136,10.89258,-7.12643>,
    /*1*/ <3.63121,10.89359,-7.12393>,<3.62929,10.89287,-7.12814>,<3.63359,10.89128,-7.12722>,
            
    /*2*/ <3.79148,11.2482,-7.2607>

    /* stem 0.12c0.6.6*/ 
    /*0*/ <3.54903,11.22092,-7.20625>,
    /*1*/ <3.54858,11.22072,-7.20677>,<3.54944,11.2215,-7.20634>,<3.54906,11.22056,-7.20564>,
            
    /*2*/ <3.31277,11.41151,-7.08073>

    /* stem 0.12c1*/ 
    /*0*/ <1.56964,9.91096,-4.31675>,
    /*1*/ <1.60411,9.912,-4.27535>,<1.56994,9.96092,-4.29659>,<1.53536,9.94079,-4.34568>,
            <1.54816,9.87943,-4.35479>,<1.59065,9.86164,-4.31132>,
    /*2*/ <2.15147,10.09678,-4.75125>,<2.12485,10.13489,-4.7678>,<2.09791,10.11921,-4.80604>,
            <2.10788,10.07141,-4.81314>,<2.14098,10.05755,-4.77927>,
    /*3*/ <2.72606,10.22854,-5.20973>,<2.70921,10.25647,-5.22335>,<2.69032,10.24538,-5.25109>,
            <2.69549,10.21059,-5.25462>,<2.71758,10.20018,-5.22906>,
    /*4*/ <3.30209,10.33418,-5.67619>,<3.29232,10.35114,-5.68474>,<3.2806,10.34437,-5.70126>,
            <3.28313,10.32323,-5.70293>,<3.29642,10.31693,-5.68743>,
    /*5*/ <3.89226,10.46968,-6.11488>,<3.88884,10.47552,-6.11779>,<3.8851,10.47325,-6.12371>,
            <3.8862,10.46601,-6.12447>,<3.89062,10.4638,-6.11901>,
    /*6*/ <3.8886,10.46966,-6.11997>

    /* stem 0.12c1.0*/ 
    /*0*/ <1.96875,10.04401,-4.65241>,
    /*1*/ <1.9828,10.00093,-4.65278>,<1.99799,10.07729,-4.64289>,<1.92546,10.0538,-4.66156>,
            
    /*2*/ <2.04038,10.02667,-4.90897>,<2.05405,10.0954,-4.90007>,<1.98878,10.07426,-4.91687>,
            
    /*3*/ <2.10873,10.13333,-5.15305>,<2.11572,10.19,-5.12692>,<2.05998,10.1728,-5.15017>,
            
    /*4*/ <2.1923,10.26323,-5.37036>,<2.19599,10.31009,-5.34192>,<2.14918,10.29716,-5.36761>,
            
    /*5*/ <2.23254,10.41652,-5.58693>,<2.23581,10.45494,-5.55989>,<2.194,10.44173,-5.57708>,
            
    /*6*/ <2.24208,10.60852,-5.77583>,<2.24443,10.63628,-5.74818>,<2.20936,10.62486,-5.76159>,
            
    /*7*/ <2.24966,10.78449,-5.97067>,<2.2517,10.80801,-5.94998>,<2.22356,10.79823,-5.95991>,
            
    /*8*/ <2.26212,10.99188,-6.13723>,<2.26344,11.00681,-6.11907>,<2.24245,11.00092,-6.12798>,
            
    /*9*/ <2.33251,11.21448,-6.26137>,<2.33277,11.22228,-6.24774>,<2.31957,11.22172,-6.25622>,
            
    /*10*/ <2.34388,11.45885,-6.365>,<2.3439,11.46202,-6.35782>,<2.3371,11.46075,-6.36154>,
            
    /*11*/ <2.35605,11.70205,-6.46659>

    /* stem 0.12c1.0.0*/ 
    /*0*/ <2.01231,10.05984,-4.84164>,
    /*1*/ <2.01911,10.0774,-4.8386>,<2.00218,10.05612,-4.85736>,<2.01564,10.046,-4.82894>,
            
    /*2*/ <2.86013,9.81604,-5.33024>

    /* stem 0.12c1.0.1*/ 
    /*0*/ <2.0679,10.12528,-5.04919>,
    /*1*/ <2.05325,10.1176,-5.05664>,<2.08427,10.12258,-5.05651>,<2.06617,10.13566,-5.03441>,
            
    /*2*/ <1.9471,10.89296,-5.60251>

    /* stem 0.12c1.0.2*/ 
    /*0*/ <2.13911,10.23091,-5.25713>,
    /*1*/ <2.1553,10.22713,-5.253>,<2.13514,10.24661,-5.26275>,<2.12688,10.219,-5.25564>,
            
    /*2*/ <2.29243,9.96828,-6.09923>

    /* stem 0.12c1.0.3*/ 
    /*0*/ <2.20607,10.38559,-5.49878>,
    /*1*/ <2.19478,10.39572,-5.49401>,<2.20557,10.37945,-5.51345>,<2.21787,10.38159,-5.48889>,
            
    /*2*/ <2.65502,11.01782,-5.7785>

    /* stem 0.12c1.0.4*/ 
    /*0*/ <2.2284,10.56407,-5.70216>,
    /*1*/ <2.23008,10.5536,-5.71244>,<2.23815,10.57511,-5.7012>,<2.21695,10.5635,-5.69285>,
            
    /*2*/ <1.81283,10.9734,-6.18754>

    /* stem 0.12c1.0.5*/ 
    /*0*/ <2.24919,10.90361,-6.04846>,
    /*1*/ <2.25614,10.91009,-6.04003>,<2.24002,10.90949,-6.055>,<2.25141,10.89125,-6.05035>,
            
    /*2*/ <2.67176,11.05002,-6.50913>

    /* stem 0.12c1.0.6*/ 
    /*0*/ <2.27428,11.05542,-6.16022>,
    /*1*/ <2.26348,11.05614,-6.16511>,<2.28397,11.05648,-6.16702>,<2.2754,11.05363,-6.14853>,
            
    /*2*/ <2.27294,11.64454,-6.06993>

    /* stem 0.12c1.0.7*/ 
    /*0*/ <2.33538,11.34764,-6.31165>,
    /*1*/ <2.34162,11.34643,-6.31361>,<2.334,11.35312,-6.30814>,<2.33051,11.34337,-6.31319>,
            
    /*2*/ <2.24776,11.60551,-6.74879>

    /* stem 0.12c1.0.8*/ 
    /*0*/ <2.34698,11.55009,-6.40044>,
    /*1*/ <2.34556,11.55115,-6.3982>,<2.34612,11.5507,-6.40309>,<2.34925,11.54842,-6.40003>,
            
    /*2*/ <2.62058,11.92226,-6.40294>

    /* stem 0.12c1.1*/ 
    /*0*/ <2.42094,10.16318,-5.01222>,
    /*1*/ <2.42734,10.19399,-4.99488>,<2.41407,10.16351,-5.04748>,<2.42141,10.13205,-4.9943>,
            
    /*2*/ <2.66397,10.16777,-5.04305>,<2.65203,10.14034,-5.09039>,<2.65864,10.11203,-5.04253>,
            
    /*3*/ <2.87314,10.25181,-5.09231>,<2.87226,10.22907,-5.13659>,<2.89076,10.20548,-5.09685>,
            
    /*4*/ <3.06416,10.38628,-5.1293>,<3.06901,10.3693,-5.16911>,<3.08863,10.3507,-5.13496>,
            
    /*5*/ <3.23679,10.54997,-5.15417>,<3.24398,10.53781,-5.18872>,<3.26211,10.52308,-5.1596>,
            
    /*6*/ <3.41433,10.71438,-5.16099>,<3.42196,10.70554,-5.18982>,<3.43546,10.69196,-5.1653>,
            
    /*7*/ <3.5831,10.88711,-5.15444>,<3.59051,10.8812,-5.17745>,<3.60102,10.87017,-5.15777>,
            
    /*8*/ <3.72915,11.07907,-5.14479>,<3.73543,11.07546,-5.16199>,<3.74408,11.06812,-5.14717>,
            
    /*9*/ <3.87192,11.27543,-5.13942>,<3.87604,11.27294,-5.1509>,<3.88201,11.26833,-5.14101>,
            
    /*10*/ <3.99236,11.48533,-5.12952>,<3.99462,11.4844,-5.13524>,<3.99777,11.48235,-5.13028>,
            
    /*11*/ <4.10359,11.70119,-5.12729>

    /* stem 0.12c1.1.0*/ 
    /*0*/ <2.547,10.15089,-5.03689>,
    /*1*/ <2.54376,10.14581,-5.05095>,<2.55816,10.14429,-5.02876>,<2.5391,10.16256,-5.03096>,
            
    /*2*/ <3.16909,10.75622,-5.3991>

    /* stem 0.12c1.1.1*/ 
    /*0*/ <2.7196,10.16475,-5.07255>,
    /*1*/ <2.72446,10.15995,-5.05959>,<2.72199,10.17863,-5.07659>,<2.71234,10.15567,-5.08148>,
            
    /*2*/ <3.4939,9.92041,-5.45381>

    /* stem 0.12c1.1.2*/ 
    /*0*/ <3.16832,10.46015,-5.15698>,
    /*1*/ <3.15978,10.46833,-5.16163>,<3.18017,10.46007,-5.16153>,<3.165,10.45207,-5.14777>,
            
    /*2*/ <3.37455,10.97519,-4.63031>

    /* stem 0.12c1.1.3*/ 
    /*0*/ <3.31925,10.60481,-5.16934>,
    /*1*/ <3.32702,10.59651,-5.17303>,<3.32246,10.61268,-5.16095>,<3.30828,10.60523,-5.17405>,
            
    /*2*/ <3.55405,11.04992,-5.67677>

    /* stem 0.12c1.1.4*/ 
    /*0*/ <3.49046,10.77364,-5.16854>,
    /*1*/ <3.48594,10.77748,-5.15919>,<3.49417,10.78071,-5.17621>,<3.49126,10.76272,-5.17022>,
            
    /*2*/ <4.08201,10.7733,-4.88288>

    /* stem 0.12c1.1.5*/ 
    /*0*/ <3.68244,11.00183,-5.15574>,
    /*1*/ <3.6817,11.00298,-5.16563>,<3.69142,11.00172,-5.15139>,<3.6742,11.00079,-5.15021>,
            
    /*2*/ <3.65583,11.58221,-5.08619>

    /* stem 0.12c1.1.6*/ 
    /*0*/ <3.94709,11.39837,-5.13657>,
    /*1*/ <3.95023,11.39642,-5.13314>,<3.9456,11.40318,-5.13619>,<3.94543,11.39551,-5.14039>,
            
    /*2*/ <4.31521,11.53276,-5.39689>

    /* stem 0.12c1.1.7*/ 
    /*0*/ <4.06572,11.62552,-5.12882>,
    /*1*/ <4.06461,11.62608,-5.12889>,<4.06668,11.62595,-5.1295>,<4.06588,11.62452,-5.12808>,
            
    /*2*/ <4.17155,11.8727,-4.82074>

    /* stem 0.12c1.2*/ 
    /*0*/ <3.50113,10.38169,-5.84156>,
    /*1*/ <3.49419,10.37693,-5.85272>,<3.51279,10.37525,-5.83731>,<3.49641,10.39289,-5.83464>,
            
    /*2*/ <3.60044,10.49277,-5.96641>,<3.61718,10.49126,-5.95254>,<3.60244,10.50713,-5.95014>,
            
    /*3*/ <3.71957,10.62285,-6.05221>,<3.73281,10.62005,-6.03835>,<3.71932,10.63378,-6.03622>,
            
    /*4*/ <3.83562,10.76982,-6.10886>,<3.84628,10.76645,-6.09612>,<3.83352,10.77738,-6.09384>,
            
    /*5*/ <3.9371,10.92694,-6.16064>,<3.94655,10.92449,-6.14988>,<3.93488,10.93281,-6.14753>,
            
    /*6*/ <4.03149,11.09099,-6.20443>,<4.03936,11.08895,-6.19545>,<4.02928,11.09532,-6.19334>,
            
    /*7*/ <4.10533,11.26532,-6.24631>,<4.11193,11.26428,-6.2393>,<4.10337,11.26838,-6.23733>,
            
    /*8*/ <4.15477,11.45378,-6.25049>,<4.15959,11.45268,-6.24517>,<4.15275,11.45451,-6.24354>,
            
    /*9*/ <4.21817,11.63404,-6.21176>,<4.22106,11.6323,-6.20828>,<4.21654,11.63366,-6.20721>,
            
    /*10*/ <4.24339,11.82518,-6.19445>,<4.24496,11.82482,-6.19264>,<4.2426,11.82509,-6.19216>,
            
    /*11*/ <4.30532,12.00877,-6.20141>

    /* stem 0.12c1.2.0*/ 
    /*0*/ <3.55324,10.43864,-5.89823>,
    /*1*/ <3.5581,10.4374,-5.895>,<3.55181,10.4443,-5.89943>,<3.54979,10.4342,-5.90025>,
            
    /*2*/ <3.96388,10.40819,-6.52863>

    /* stem 0.12c1.2.1*/ 
    /*0*/ <3.79321,10.71367,-6.07695>,
    /*1*/ <3.78905,10.71688,-6.07712>,<3.79636,10.71324,-6.08114>,<3.79422,10.7109,-6.0726>,
            
    /*2*/ <4.16225,11.20435,-5.84972>

    /* stem 0.12c1.2.2*/ 
    /*0*/ <3.89614,10.86075,-6.1299>,
    /*1*/ <3.89887,10.85797,-6.13293>,<3.89824,10.86444,-6.12739>,<3.89132,10.85984,-6.12939>,
            
    /*2*/ <3.77495,11.24261,-6.58951>

    /* stem 0.12c1.2.3*/ 
    /*0*/ <3.98016,10.99896,-6.1722>,
    /*1*/ <3.98002,11.00027,-6.16775>,<3.97922,11.00203,-6.17555>,<3.98125,10.99459,-6.17329>,
            
    /*2*/ <4.53103,11.14169,-6.19616>

    /* stem 0.12c1.2.4*/ 
    /*0*/ <4.1255,11.33759,-6.24305>,
    /*1*/ <4.12339,11.33804,-6.24638>,<4.12932,11.33868,-6.24295>,<4.1238,11.33605,-6.23981>,
            
    /*2*/ <3.99633,11.77641,-6.10148>

    /* stem 0.12c1.2.5*/ 
    /*0*/ <4.19872,11.57658,-6.22087>,
    /*1*/ <4.20159,11.57538,-6.21994>,<4.19733,11.57894,-6.21916>,<4.19726,11.5754,-6.22351>,
            
    /*2*/ <4.394,11.862,-6.45602>

    /* stem 0.12c1.2.6*/ 
    /*0*/ <4.28418,11.94578,-6.19855>,
    /*1*/ <4.28376,11.94592,-6.19838>,<4.28435,11.94597,-6.19896>,<4.28443,11.94543,-6.19833>,
            
    /*2*/ <4.43905,12.17428,-6.02449>

    /* stem 0.12c2*/ 
    /*0*/ <2.13977,10.44231,-5.59411>,
    /*1*/ <2.15749,10.44149,-5.56983>,<2.13359,10.46645,-5.57728>,<2.11823,10.45804,-5.60799>,
            <2.13265,10.42789,-5.61952>,<2.15691,10.41767,-5.59593>,
    /*2*/ <2.67254,10.83206,-5.94719>,<2.6581,10.84713,-5.9517>,<2.64882,10.84205,-5.97025>,
            <2.65753,10.82384,-5.97722>,<2.67219,10.81766,-5.96296>,
    /*3*/ <3.15078,11.23223,-6.3635>,<3.14553,11.23722,-6.36485>,<3.14202,11.23521,-6.37101>,
            <3.1451,11.22899,-6.37346>,<3.15051,11.22715,-6.36881>,
    /*4*/ <3.14679,11.23216,-6.36833>

    /* stem 0.12.0*/ 
    /*0*/ <0.07467,8.89911,-0.57418>,
    /*1*/ <0.01626,8.94573,-0.58907>,<0.08983,8.84089,-0.62095>,<0.11791,8.91071,-0.51252>,
            
    /*2*/ <0.28312,9.19436,-0.81829>,<0.34933,9.1,-0.84698>,<0.37461,9.16284,-0.74939>,
            
    /*3*/ <0.52994,9.50285,-0.97423>,<0.60045,9.43171,-1.00765>,<0.6093,9.47348,-0.91107>,
            
    /*4*/ <0.78362,9.80332,-1.15223>,<0.84321,9.73848,-1.18017>,<0.85384,9.77847,-1.09756>,
            
    /*5*/ <0.96948,10.16686,-1.25503>,<1.03109,10.1278,-1.28586>,<1.03189,10.14917,-1.20961>,
            
    /*6*/ <1.07433,10.55533,-1.38042>,<1.12901,10.53224,-1.40927>,<1.13076,10.55208,-1.34635>,
            
    /*7*/ <1.16207,10.95813,-1.49899>,<1.20639,10.94229,-1.52291>,<1.20756,10.95696,-1.47221>,
            
    /*8*/ <1.25258,11.37116,-1.58203>,<1.28613,11.36076,-1.60032>,<1.28633,11.36852,-1.56149>,
            
    /*9*/ <1.2572,11.77665,-1.71341>,<1.27979,11.77259,-1.72644>,<1.28032,11.7807,-1.70133>,
            
    /*10*/ <1.19323,12.18747,-1.81631>,<1.20431,12.1876,-1.82348>,<1.20468,12.19087,-1.8107>,
            
    /*11*/ <1.17539,12.61774,-1.84408>

    /* stem 0.12.0.0*/ 
    /*0*/ <0.27865,9.09706,-0.75448>,
    /*1*/ <0.29306,9.07118,-0.76658>,<0.29604,9.12253,-0.74595>,<0.24687,9.09746,-0.75089>,
            
    /*2*/ <0.11594,9.71425,-2.26741>

    /* stem 0.12.0.1*/ 
    /*0*/ <0.37023,9.19723,-0.82743>,
    /*1*/ <0.36835,9.21243,-0.80009>,<0.36703,9.21295,-0.85435>,<0.37529,9.1663,-0.82786>,
            
    /*2*/ <1.95347,9.45721,-0.86349>

    /* stem 0.12.0.2*/ 
    /*0*/ <0.49155,9.35469,-0.90664>,
    /*1*/ <0.47687,9.35263,-0.93322>,<0.52192,9.35656,-0.90614>,<0.47585,9.35488,-0.88056>,
            
    /*2*/ <0.39734,10.90383,-0.97473>

    /* stem 0.12.0.3*/ 
    /*0*/ <0.67811,9.59026,-1.0355>,
    /*1*/ <0.70139,9.57926,-1.02205>,<0.67448,9.61904,-1.03705>,<0.65846,9.57248,-1.04739>,
            
    /*2*/ <1.42454,9.61594,-2.30742>

    /* stem 0.12.0.4*/ 
    /*0*/ <0.95612,10.03657,-1.21839>,
    /*1*/ <0.93357,10.04939,-1.21228>,<0.96722,10.03984,-1.2424>,<0.96757,10.02048,-1.2005>,
            
    /*2*/ <1.67016,11.06819,-0.74745>

    /* stem 0.12.0.5*/ 
    /*0*/ <1.0462,10.28819,-1.29539>,
    /*1*/ <1.05798,10.27864,-1.31581>,<1.0568,10.30732,-1.28238>,<1.02382,10.27862,-1.28797>,
            
    /*2*/ <0.44139,11.12771,-2.03695>

    /* stem 0.12.0.6*/ 
    /*0*/ <1.08244,10.43187,-1.34171>,
    /*1*/ <1.08727,10.43821,-1.31826>,<1.06793,10.44627,-1.3557>,<1.09212,10.41113,-1.35117>,
            
    /*2*/ <2.07419,11.06612,-1.71747>

    /* stem 0.12.0.7*/ 
    /*0*/ <1.1346,10.66347,-1.41306>,
    /*1*/ <1.11643,10.66261,-1.42825>,<1.15562,10.67176,-1.42018>,<1.13174,10.65603,-1.39074>,
            
    /*2*/ <0.81482,11.74893,-1.09213>

    /* stem 0.12.0.8*/ 
    /*0*/ <1.24142,11.1991,-1.54759>,
    /*1*/ <1.26225,11.19507,-1.54689>,<1.23371,11.21673,-1.5386>,<1.22829,11.18551,-1.55727>,
            
    /*2*/ <1.37087,11.71265,-2.4439>

    /* stem 0.12.0.9*/ 
    /*0*/ <1.27311,11.66896,-1.67893>,
    /*1*/ <1.26013,11.67238,-1.66811>,<1.27296,11.67545,-1.6949>,<1.28626,11.65906,-1.67377>,
            
    /*2*/ <1.72027,12.41861,-1.37881>

    /* stem 0.12.0.10*/ 
    /*0*/ <1.24835,11.91504,-1.74836>,
    /*1*/ <1.25017,11.91229,-1.76061>,<1.25211,11.92624,-1.74375>,<1.24278,11.90659,-1.74072>,
            
    /*2*/ <0.47855,12.25132,-1.93787>

    /* stem 0.12.0.11*/ 
    /*0*/ <1.21466,12.10865,-1.79681>,
    /*1*/ <1.21937,12.1113,-1.78949>,<1.20671,12.11262,-1.79879>,<1.2179,12.10203,-1.80215>,
            
    /*2*/ <1.6031,12.66231,-2.24722>

    /* stem 0.12.0.12*/ 
    /*0*/ <1.19326,12.31526,-1.82487>,
    /*1*/ <1.18814,12.31486,-1.82644>,<1.19676,12.31805,-1.82784>,<1.19488,12.31287,-1.82034>,
            
    /*2*/ <1.0236,12.94579,-1.43206>

    /* stem 0.12.1*/ 
    /*0*/ <0.19028,8.941,-0.89641>,
    /*1*/ <0.20772,8.8689,-0.89953>,<0.24254,8.9924,-0.90831>,<0.12057,8.96172,-0.8814>,
            
    /*2*/ <0.11675,8.87218,-1.30806>,<0.14808,8.98333,-1.31597>,<0.03831,8.95572,-1.29175>,
            
    /*3*/ <0.05355,9.05555,-1.70821>,<0.08832,9.14563,-1.67269>,<-0.01202,9.1235,-1.66737>,
            
    /*4*/ <0.00957,9.3111,-2.05092>,<0.04191,9.38102,-2.00434>,<-0.04661,9.36463,-2.00527>,
            
    /*5*/ <-0.00234,9.64162,-2.32573>,<0.02621,9.68876,-2.27172>,<-0.05013,9.6801,-2.27893>,
            
    /*6*/ <0.03047,10.01863,-2.52353>,<0.05353,10.04568,-2.46994>,<-0.00979,10.04538,-2.48112>,
            
    /*7*/ <0.07941,10.42447,-2.6417>,<0.09671,10.43677,-2.59483>,<0.04644,10.4398,-2.6053>,
            
    /*8*/ <0.17626,10.8212,-2.73659>,<0.18862,10.82742,-2.70057>,<0.15177,10.83422,-2.70976>,
            
    /*9*/ <0.29987,11.21078,-2.82628>,<0.3079,11.21423,-2.80208>,<0.28379,11.22036,-2.80864>,
            
    /*10*/ <0.33107,11.61334,-2.93669>,<0.33539,11.61642,-2.92497>,<0.32277,11.61672,-2.92746>,
            
    /*11*/ <0.35382,12.01262,-3.0595>

    /* stem 0.12.1.0*/ 
    /*0*/ <0.13582,8.93861,-1.14593>,
    /*1*/ <0.14934,8.96685,-1.14915>,<0.10851,8.9325,-1.16033>,<0.14961,8.91648,-1.1283>,
            
    /*2*/ <0.93744,8.40711,-2.44037>

    /* stem 0.12.1.1*/ 
    /*0*/ <0.08625,8.98093,-1.40199>,
    /*1*/ <0.05802,8.96984,-1.4027>,<0.10287,8.98173,-1.42735>,<0.09784,8.99123,-1.37592>,
            
    /*2*/ <-0.46137,10.394,-1.71661>

    /* stem 0.12.1.2*/ 
    /*0*/ <0.06031,9.05777,-1.57147>,
    /*1*/ <0.08781,9.05018,-1.57913>,<0.04916,9.08368,-1.58025>,<0.04396,9.03946,-1.55505>,
            
    /*2*/ <-0.46649,8.40845,-2.82005>

    /* stem 0.12.1.3*/ 
    /*0*/ <0.02836,9.19563,-1.80361>,
    /*1*/ <0.01474,9.21497,-1.78794>,<0.01728,9.18698,-1.82826>,<0.05306,9.18493,-1.79463>,
            
    /*2*/ <0.73167,10.24535,-2.48824>

    /* stem 0.12.1.4*/ 
    /*0*/ <-0.0031,9.49683,-2.14386>,
    /*1*/ <-0.00846,9.47992,-2.16342>,<0.01576,9.51507,-2.14696>,<-0.01658,9.49551,-2.12119>,
            
    /*2*/ <-0.90204,10.3436,-2.62937>

    /* stem 0.12.1.5*/ 
    /*0*/ <0.00282,9.79676,-2.36103>,
    /*1*/ <0.02206,9.80285,-2.3466>,<-0.01491,9.81345,-2.36576>,<0.00131,9.77398,-2.37072>,
            
    /*2*/ <0.62884,10.17924,-3.35763>

    /* stem 0.12.1.6*/ 
    /*0*/ <0.01907,9.97455,-2.45778>,
    /*1*/ <-0.00477,9.97645,-2.45829>,<0.03209,9.98236,-2.47626>,<0.02989,9.96483,-2.43878>,
            
    /*2*/ <0.09359,11.04754,-1.95152>

    /* stem 0.12.1.7*/ 
    /*0*/ <0.03857,10.14769,-2.52579>,
    /*1*/ <0.0562,10.14133,-2.5393>,<0.04001,10.16707,-2.51328>,<0.01951,10.13468,-2.52477>,
            
    /*2*/ <-0.41248,10.74099,-3.39326>

    /* stem 0.12.1.8*/ 
    /*0*/ <0.12876,10.653,-2.67056>,
    /*1*/ <0.12499,10.65897,-2.65104>,<0.12267,10.66492,-2.68643>,<0.13862,10.6351,-2.67422>,
            
    /*2*/ <1.0199,11.1392,-2.64741>

    /* stem 0.12.1.9*/ 
    /*0*/ <0.22385,10.98773,-2.75559>,
    /*1*/ <0.21496,10.98637,-2.77252>,<0.24101,10.9962,-2.75443>,<0.21559,10.98062,-2.73983>,
            
    /*2*/ <-0.19019,11.8058,-2.60362>

    /* stem 0.12.1.10*/ 
    /*0*/ <0.30628,11.32697,-2.84512>,
    /*1*/ <0.31823,11.32732,-2.8406>,<0.29838,11.3368,-2.84308>,<0.30224,11.31678,-2.85169>,
            
    /*2*/ <0.56694,11.68542,-3.56151>

    /* stem 0.12.1.11*/ 
    /*0*/ <0.32418,11.54707,-2.90965>,
    /*1*/ <0.31602,11.54851,-2.90702>,<0.32705,11.55062,-2.91705>,<0.32947,11.5421,-2.90487>,
            
    /*2*/ <0.56388,12.18286,-2.51218>

    /* stem 0.12.1.12*/ 
    /*0*/ <0.33815,11.75415,-2.97502>,
    /*1*/ <0.34058,11.75272,-2.97895>,<0.33958,11.75809,-2.97261>,<0.3343,11.75165,-2.97352>,
            
    /*2*/ <-0.09745,12.17061,-3.3957>

    /* stem 0.12.2*/ 
    /*0*/ <0.27748,8.97709,-1.13518>,
    /*1*/ <0.30635,9.04056,-1.11428>,<0.22017,8.97619,-1.18007>,<0.3059,8.91451,-1.11119>,
            
    /*2*/ <0.55595,9.02543,-1.43851>,<0.47839,8.96749,-1.49772>,<0.55555,8.91198,-1.43573>,
            
    /*3*/ <0.78666,9.1625,-1.71691>,<0.73223,9.11455,-1.787>,<0.81083,9.06834,-1.74385>,
            
    /*4*/ <0.98867,9.35975,-2.00493>,<0.94159,9.31916,-2.06759>,<1.01712,9.28348,-2.03906>,
            
    /*5*/ <1.15888,9.60636,-2.2756>,<1.1199,9.57367,-2.3316>,<1.18823,9.54729,-2.31264>,
            
    /*6*/ <1.32632,9.89322,-2.50419>,<1.29713,9.87079,-2.55537>,<1.35446,9.84957,-2.53994>,
            
    /*7*/ <1.45898,10.21079,-2.7214>,<1.43571,10.19332,-2.76259>,<1.48339,10.17997,-2.75299>,
            
    /*8*/ <1.57989,10.55273,-2.9049>,<1.56334,10.54196,-2.93717>,<1.59942,10.5328,-2.93044>,
            
    /*9*/ <1.70618,10.90223,-3.07486>,<1.69547,10.89589,-3.09679>,<1.71942,10.8895,-3.09214>,
            
    /*10*/ <1.80088,11.26712,-3.2329>,<1.79552,11.26398,-3.24387>,<1.80776,11.26164,-3.24194>,
            
    /*11*/ <1.80139,11.66148,-3.33859>

    /* stem 0.12.2.0*/ 
    /*0*/ <0.41497,8.9723,-1.31061>,
    /*1*/ <0.39202,8.96135,-1.32829>,<0.444,8.96245,-1.31505>,<0.40889,8.9931,-1.28848>,
            
    /*2*/ <0.65452,10.14554,-2.3476>

    /* stem 0.12.2.1*/ 
    /*0*/ <0.57516,8.99521,-1.51082>,
    /*1*/ <0.59898,8.98595,-1.49536>,<0.57456,9.02281,-1.52222>,<0.55194,8.97686,-1.51489>,
            
    /*2*/ <1.20788,8.47892,-2.79436>

    /* stem 0.12.2.2*/ 
    /*0*/ <0.7393,9.09294,-1.70513>,
    /*1*/ <0.72241,9.116,-1.7078>,<0.75176,9.08151,-1.72834>,<0.74373,9.0813,-1.67926>,
            
    /*2*/ <1.89303,9.95983,-1.51262>

    /* stem 0.12.2.3*/ 
    /*0*/ <0.84578,9.18426,-1.84604>,
    /*1*/ <0.85074,9.1604,-1.85954>,<0.86583,9.20348,-1.8439>,<0.82077,9.1889,-1.83469>,
            
    /*2*/ <0.40944,9.77339,-3.04816>

    /* stem 0.12.2.4*/ 
    /*0*/ <1.09495,9.48638,-2.21216>,
    /*1*/ <1.1046,9.50015,-2.19292>,<1.0824,9.498,-2.23114>,<1.09784,9.461,-2.21241>,
            
    /*2*/ <2.1918,9.61777,-2.85673>

    /* stem 0.12.2.5*/ 
    /*0*/ <1.21255,9.67445,-2.38228>,
    /*1*/ <1.19327,9.67418,-2.39713>,<1.23485,9.67799,-2.39136>,<1.20953,9.67118,-2.35836>,
            
    /*2*/ <1.08262,10.8702,-2.23534>

    /* stem 0.12.2.6*/ 
    /*0*/ <1.28124,9.79359,-2.47366>,
    /*1*/ <1.30235,9.78328,-2.47123>,<1.27841,9.81627,-2.46768>,<1.26295,9.78123,-2.48207>,
            
    /*2*/ <1.56435,10.11654,-3.56424>

    /* stem 0.12.2.7*/ 
    /*0*/ <1.36,9.95373,-2.58739>,
    /*1*/ <1.34599,9.96721,-2.57568>,<1.36022,9.95456,-2.61007>,<1.3738,9.93944,-2.57642>,
            
    /*2*/ <2.15219,10.74636,-2.55094>

    /* stem 0.12.2.8*/ 
    /*0*/ <1.52143,10.37235,-2.83684>,
    /*1*/ <1.52236,10.36277,-2.85487>,<1.53645,10.38501,-2.83121>,<1.50548,10.36926,-2.82444>,
            
    /*2*/ <1.04044,11.1339,-3.26624>

    /* stem 0.12.2.9*/ 
    /*0*/ <1.66438,10.77642,-3.03258>,
    /*1*/ <1.67402,10.77934,-3.01885>,<1.65641,10.78933,-3.04028>,<1.66273,10.76059,-3.0386>,
            
    /*2*/ <2.36872,10.90082,-3.55335>

    /* stem 0.12.2.10*/ 
    /*0*/ <1.7198,10.94576,-3.10847>,
    /*1*/ <1.70699,10.94731,-3.11268>,<1.73009,10.94899,-3.11671>,<1.72232,10.94099,-3.09601>,
            
    /*2*/ <1.71547,11.72822,-2.80787>

    /* stem 0.12.2.11*/ 
    /*0*/ <1.77175,11.14856,-3.19195>,
    /*1*/ <1.78012,11.14513,-3.19506>,<1.77133,11.15721,-3.18788>,<1.76379,11.14333,-3.19291>,
            
    /*2*/ <1.64355,11.47274,-3.89433>

    /* stem 0.12.2.12*/ 
    /*0*/ <1.80139,11.434,-3.28188>,
    /*1*/ <1.79963,11.43491,-3.27821>,<1.79959,11.43526,-3.28543>,<1.80494,11.43182,-3.28201>,
            
    /*2*/ <2.1727,12.04009,-3.2552>

    /* stem 0.12.3*/ 
    /*0*/ <0.34164,9.00525,-1.30934>,
    /*1*/ <0.28056,8.97883,-1.33611>,<0.40438,8.97505,-1.32659>,<0.33998,9.06186,-1.26531>,
            
    /*2*/ <0.31853,9.22852,-1.6499>,<0.42997,9.22512,-1.64133>,<0.372,9.30324,-1.58618>,
            
    /*3*/ <0.34489,9.51538,-1.93477>,<0.44413,9.5139,-1.92922>,<0.39205,9.57592,-1.87159>,
            
    /*4*/ <0.37818,9.86211,-2.15169>,<0.46488,9.85931,-2.14536>,<0.41821,9.90126,-2.08514>,
            
    /*5*/ <0.40124,10.22671,-2.32599>,<0.47563,10.22553,-2.32127>,<0.43522,10.2546,-2.26578>,
            
    /*6*/ <0.38185,10.62071,-2.41437>,<0.44379,10.62518,-2.41243>,<0.41031,10.63503,-2.36104>,
            
    /*7*/ <0.34776,11.02157,-2.45243>,<0.39718,11.02667,-2.45114>,<0.37091,11.02843,-2.40899>,
            
    /*8*/ <0.30519,11.4189,-2.49652>,<0.34216,11.42354,-2.49565>,<0.32246,11.42494,-2.46404>,
            
    /*9*/ <0.23928,11.81652,-2.49389>,<0.26373,11.82095,-2.4934>,<0.25108,11.81871,-2.47213>,
            
    /*10*/ <0.13095,12.20168,-2.51959>,<0.14285,12.20524,-2.51941>,<0.13653,12.20417,-2.50877>,
            
    /*11*/ <-0.01281,12.5731,-2.57391>

    /* stem 0.12.3.0*/ 
    /*0*/ <0.35972,9.14545,-1.48893>,
    /*1*/ <0.38976,9.14036,-1.48988>,<0.34911,9.17402,-1.48851>,<0.34029,9.12196,-1.4884>,
            
    /*2*/ <0.31147,9.15029,-3.04427>

    /* stem 0.12.3.1*/ 
    /*0*/ <0.3816,9.36575,-1.74057>,
    /*1*/ <0.36232,9.38187,-1.72599>,<0.38039,9.36434,-1.76957>,<0.40209,9.35104,-1.72615>,
            
    /*2*/ <1.28357,10.52967,-1.83478>

    /* stem 0.12.3.2*/ 
    /*0*/ <0.40279,9.65055,-1.98525>,
    /*1*/ <0.404,9.63578,-2.00835>,<0.42107,9.67052,-1.98076>,<0.38331,9.64535,-1.96664>,
            
    /*2*/ <-0.43606,10.5582,-2.60973>

    /* stem 0.12.3.3*/ 
    /*0*/ <0.41549,9.81159,-2.08759>,
    /*1*/ <0.43165,9.82202,-2.06918>,<0.39414,9.82521,-2.09582>,<0.42067,9.78755,-2.09778>,
            
    /*2*/ <1.14938,10.37887,-3.05303>

    /* stem 0.12.3.4*/ 
    /*0*/ <0.4289,10.05515,-2.21599>,
    /*1*/ <0.40413,10.0536,-2.22153>,<0.44561,10.06148,-2.23409>,<0.43697,10.05038,-2.19234>,
            
    /*2*/ <0.28536,11.28422,-1.91885>

    /* stem 0.12.3.5*/ 
    /*0*/ <0.41995,10.50414,-2.3672>,
    /*1*/ <0.44067,10.50297,-2.37794>,<0.41642,10.5199,-2.35031>,<0.40276,10.48956,-2.37335>,
            
    /*2*/ <0.05392,11.26824,-3.1566>

    /* stem 0.12.3.6*/ 
    /*0*/ <0.38726,10.87317,-2.42163>,
    /*1*/ <0.37913,10.87445,-2.40152>,<0.37778,10.88402,-2.43789>,<0.40486,10.86105,-2.42547>,
            
    /*2*/ <1.01162,11.71649,-2.2228>

    /* stem 0.12.3.7*/ 
    /*0*/ <0.35768,11.14194,-2.45156>,
    /*1*/ <0.35144,11.13884,-2.47087>,<0.37121,11.15679,-2.4474>,<0.35038,11.13017,-2.43641>,
            
    /*2*/ <-0.39545,11.78899,-2.31206>

    /* stem 0.12.3.8*/ 
    /*0*/ <0.29933,11.55438,-2.48576>,
    /*1*/ <0.31505,11.55726,-2.47611>,<0.28334,11.56213,-2.48007>,<0.29961,11.54376,-2.5011>,
            
    /*2*/ <0.47388,12.28349,-2.98761>

    /* stem 0.12.3.9*/ 
    /*0*/ <0.26285,11.75539,-2.4863>,
    /*1*/ <0.24779,11.75267,-2.48391>,<0.26725,11.7659,-2.4968>,<0.27352,11.74761,-2.47819>,
            
    /*2*/ <0.24847,12.36127,-1.88583>

    /* stem 0.12.3.10*/ 
    /*0*/ <0.1687,12.09644,-2.50772>,
    /*1*/ <0.17459,12.09767,-2.51464>,<0.16887,12.10209,-2.50049>,<0.16263,12.08957,-2.50802>,
            
    /*2*/ <-0.33659,12.55792,-2.85629>

    /* stem 0.12.3.11*/ 
    /*0*/ <0.04784,12.42332,-2.5504>,
    /*1*/ <0.04768,12.42371,-2.54752>,<0.04554,12.42392,-2.55208>,<0.05031,12.42234,-2.5516>,
            
    /*2*/ <0.26817,13.06627,-2.62351>

    /* stem 0.12.4*/ 
    /*0*/ <0.42044,9.03983,-1.52323>,
    /*1*/ <0.48438,9.01816,-1.50318>,<0.41033,9.1069,-1.54218>,<0.36662,8.99443,-1.52434>,
            
    /*2*/ <0.56383,8.92768,-1.87899>,<0.49718,9.00754,-1.91409>,<0.45784,8.90631,-1.89804>,
            
    /*3*/ <0.69123,9.04311,-2.23682>,<0.62227,9.11203,-2.24088>,<0.60417,9.02278,-2.27593>,
            
    /*4*/ <0.72907,9.26217,-2.5812>,<0.66339,9.31144,-2.55774>,<0.64962,9.24138,-2.60456>,
            
    /*5*/ <0.76042,9.53356,-2.86844>,<0.70321,9.57036,-2.84144>,<0.69276,9.5183,-2.8918>,
            
    /*6*/ <0.80007,9.83593,-3.11858>,<0.75195,9.86401,-3.09377>,<0.74417,9.82605,-3.14086>,
            
    /*7*/ <0.82913,10.16187,-3.34157>,<0.79025,10.18137,-3.31945>,<0.78445,10.15438,-3.35968>,
            
    /*8*/ <0.85823,10.5063,-3.53256>,<0.82888,10.51921,-3.51493>,<0.82485,10.50184,-3.54688>,
            
    /*9*/ <0.91593,10.84887,-3.71658>,<0.8965,10.85856,-3.70544>,<0.89392,10.84741,-3.72699>,
            
    /*10*/ <0.98981,11.21011,-3.85607>,<0.98,11.21454,-3.85033>,<0.97901,11.21034,-3.86174>,
            
    /*11*/ <1.07102,11.58575,-3.94539>

    /* stem 0.12.4.0*/ 
    /*0*/ <0.4886,8.96627,-1.82003>,
    /*1*/ <0.47485,8.99074,-1.82925>,<0.481,8.93997,-1.83116>,<0.50994,8.96808,-1.79968>,
            
    /*2*/ <1.51235,9.13113,-2.90815>

    /* stem 0.12.4.1*/ 
    /*0*/ <0.57032,9.00119,-2.06766>,
    /*1*/ <0.56969,8.9742,-2.07644>,<0.5919,9.01806,-2.07515>,<0.54938,9.01132,-2.05138>,
            
    /*2*/ <-0.15141,9.40139,-3.24523>

    /* stem 0.12.4.2*/ 
    /*0*/ <0.64837,9.10614,-2.32398>,
    /*1*/ <0.66548,9.12282,-2.3111>,<0.62773,9.11634,-2.33837>,<0.65189,9.07927,-2.32248>,
            
    /*2*/ <1.44444,9.14813,-3.4357>

    /* stem 0.12.4.3*/ 
    /*0*/ <0.67282,9.23135,-2.51854>,
    /*1*/ <0.64727,9.22875,-2.52342>,<0.69016,9.22894,-2.53796>,<0.68103,9.23637,-2.49423>,
            
    /*2*/ <0.58678,10.5191,-2.75535>

    /* stem 0.12.4.4*/ 
    /*0*/ <0.6996,9.40518,-2.72311>,
    /*1*/ <0.7215,9.39511,-2.72966>,<0.69655,9.42996,-2.72378>,<0.68075,9.39047,-2.71589>,
            
    /*2*/ <0.30928,9.32529,-3.90496>

    /* stem 0.12.4.5*/ 
    /*0*/ <0.74683,9.72198,-3.01793>,
    /*1*/ <0.73802,9.73641,-3.00222>,<0.73966,9.723,-3.03985>,<0.76282,9.70653,-3.01173>,
            
    /*2*/ <1.56952,10.47943,-3.25203>

    /* stem 0.12.4.6*/ 
    /*0*/ <0.77758,9.95198,-3.19329>,
    /*1*/ <0.77128,9.94064,-3.21082>,<0.79531,9.96464,-3.19429>,<0.76615,9.95067,-3.17477>,
            
    /*2*/ <0.17037,10.77776,-3.50941>

    /* stem 0.12.4.7*/ 
    /*0*/ <0.82074,10.35122,-3.44349>,
    /*1*/ <0.83709,10.35523,-3.43322>,<0.80745,10.3654,-3.4468>,<0.81769,10.33303,-3.45045>,
            
    /*2*/ <1.27355,10.5861,-4.25552>

    /* stem 0.12.4.8*/ 
    /*0*/ <0.85244,10.58901,-3.57458>,
    /*1*/ <0.8343,10.59261,-3.57427>,<0.86244,10.59318,-3.58957>,<0.86058,10.58123,-3.5599>,
            
    /*2*/ <1.01915,11.39936,-3.23764>

    /* stem 0.12.4.9*/ 
    /*0*/ <0.89153,10.79566,-3.68613>,
    /*1*/ <0.90194,10.78891,-3.69498>,<0.89449,10.80923,-3.67988>,<0.87816,10.78883,-3.68354>,
            
    /*2*/ <0.56743,11.17542,-4.35689>

    /* stem 0.12.4.10*/ 
    /*0*/ <0.92778,10.96593,-3.76069>,
    /*1*/ <0.92672,10.9704,-3.74977>,<0.92322,10.97175,-3.76995>,<0.93339,10.95562,-3.76235>,
            
    /*2*/ <1.61104,11.35289,-3.853>

    /* stem 0.12.4.11*/ 
    /*0*/ <1.00571,11.30839,-3.87914>,
    /*1*/ <1.00294,11.30799,-3.88355>,<1.01053,11.3104,-3.87927>,<1.00367,11.30677,-3.87462>,
            
    /*2*/ <0.74037,11.94854,-3.76995>

    /* stem 0.12.5*/ 
    /*0*/ <0.54312,9.10945,-1.84977>,
    /*1*/ <0.50471,9.16603,-1.84998>,<0.53024,9.0592,-1.89434>,<0.59443,9.10311,-1.80498>,
            
    /*2*/ <0.74735,9.32158,-2.10071>,<0.77033,9.22543,-2.14063>,<0.8281,9.26495,-2.06021>,
            
    /*3*/ <0.95562,9.51874,-2.33961>,<0.98294,9.43927,-2.38343>,<1.03379,9.47338,-2.3111>,
            
    /*4*/ <1.15058,9.74809,-2.56659>,<1.17876,9.68327,-2.60996>,<1.22165,9.71135,-2.54478>,
            
    /*5*/ <1.29154,10.00435,-2.8013>,<1.31794,9.95316,-2.84295>,<1.35735,9.97989,-2.79018>,
            
    /*6*/ <1.34855,10.30096,-3.01835>,<1.37277,10.26667,-3.06013>,<1.40691,10.29084,-3.0182>,
            
    /*7*/ <1.43914,10.62146,-3.20609>,<1.45922,10.59631,-3.24086>,<1.48521,10.61059,-3.2039>,
            
    /*8*/ <1.47678,10.95542,-3.37935>,<1.49229,10.9398,-3.40725>,<1.51211,10.95159,-3.38022>,
            
    /*9*/ <1.45596,11.31737,-3.48332>,<1.46626,11.31235,-3.50406>,<1.47954,11.31849,-3.48541>,
            
    /*10*/ <1.43966,11.68694,-3.57825>,<1.4448,11.68468,-3.58868>,<1.45146,11.68739,-3.57927>,
            
    /*11*/ <1.40038,12.05255,-3.68084>

    /* stem 0.12.5.0*/ 
    /*0*/ <0.67768,9.20028,-1.99106>,
    /*1*/ <0.68007,9.17493,-2.00509>,<0.70154,9.21549,-1.98437>,<0.65145,9.21042,-1.98373>,
            
    /*2*/ <0.58956,9.90731,-3.28388>

    /* stem 0.12.5.1*/ 
    /*0*/ <0.89586,9.38328,-2.23372>,
    /*1*/ <0.9073,9.39665,-2.21263>,<0.88378,9.39737,-2.25398>,<0.89648,9.35583,-2.23456>,
            
    /*2*/ <2.10022,9.43174,-2.91822>

    /* stem 0.12.5.2*/ 
    /*0*/ <1.04401,9.54256,-2.40792>,
    /*1*/ <1.02317,9.54414,-2.42384>,<1.0681,9.53994,-2.41806>,<1.04076,9.5436,-2.38188>,
            
    /*2*/ <1.1714,10.85507,-2.44418>

    /* stem 0.12.5.3*/ 
    /*0*/ <1.14912,9.67177,-2.53275>,
    /*1*/ <1.17008,9.65785,-2.52951>,<1.15013,9.697,-2.53027>,<1.12714,9.66046,-2.53848>,
            
    /*2*/ <1.4141,9.78278,-3.76903>

    /* stem 0.12.5.4*/ 
    /*0*/ <1.27562,9.88997,-2.73147>,
    /*1*/ <1.26329,9.9069,-2.71979>,<1.27791,9.8911,-2.75531>,<1.28565,9.8719,-2.7193>,
            
    /*2*/ <2.27354,10.52949,-2.60494>

    /* stem 0.12.5.5*/ 
    /*0*/ <1.34153,10.089,-2.89047>,
    /*1*/ <1.33932,10.07599,-2.90909>,<1.35735,10.10543,-2.88984>,<1.32791,10.08557,-2.87247>,
            
    /*2*/ <0.59639,10.8226,-3.31441>

    /* stem 0.12.5.6*/ 
    /*0*/ <1.43064,10.49342,-3.15066>,
    /*1*/ <1.4447,10.49798,-3.1362>,<1.41749,10.50795,-3.15722>,<1.42974,10.47434,-3.15854>,
            
    /*2*/ <2.08598,10.76063,-3.87222>

    /* stem 0.12.5.7*/ 
    /*0*/ <1.47632,10.76728,-3.29691>,
    /*1*/ <1.45721,10.76783,-3.29943>,<1.48808,10.77273,-3.31117>,<1.48365,10.76128,-3.28012>,
            
    /*2*/ <1.4592,11.64531,-2.97545>

    /* stem 0.12.5.8*/ 
    /*0*/ <1.49036,10.99561,-3.40191>,
    /*1*/ <1.50534,10.99389,-3.412>,<1.48835,11.01001,-3.39104>,<1.47739,10.98294,-3.40267>,
            
    /*2*/ <1.10213,11.43234,-4.05249>

    /* stem 0.12.5.9*/ 
    /*0*/ <1.47379,11.22549,-3.46577>,
    /*1*/ <1.4696,11.22917,-3.45145>,<1.46551,11.23049,-3.47771>,<1.48624,11.21682,-3.46814>,
            
    /*2*/ <1.93524,11.89872,-3.50381>

    /* stem 0.12.5.10*/ 
    /*0*/ <1.45929,11.4505,-3.52402>,
    /*1*/ <1.45469,11.4478,-3.53387>,<1.46619,11.45928,-3.52328>,<1.45697,11.44442,-3.51491>,
            
    /*2*/ <0.86695,11.90364,-3.37174>

    /* stem 0.12.5.11*/ 
    /*0*/ <1.43038,11.80797,-3.61487>,
    /*1*/ <1.43447,11.80896,-3.61308>,<1.4267,11.81037,-3.61362>,<1.42998,11.80459,-3.61792>,
            
    /*2*/ <1.54434,12.24403,-4.11379>

    /* stem 0.12.6*/ 
    /*0*/ <0.64324,9.17644,-2.11206>,
    /*1*/ <0.63974,9.1122,-2.1298>,<0.70073,9.20974,-2.11844>,<0.58925,9.20739,-2.08792>,
            
    /*2*/ <0.54361,9.21909,-2.47267>,<0.59851,9.30688,-2.46245>,<0.49818,9.30476,-2.43498>,
            
    /*3*/ <0.40339,9.41212,-2.77637>,<0.45769,9.48438,-2.75679>,<0.37265,9.47934,-2.72078>,
            
    /*4*/ <0.29436,9.61991,-3.06862>,<0.3437,9.67992,-3.04598>,<0.26746,9.67784,-3.01894>,
            
    /*5*/ <0.21914,9.93317,-3.28513>,<0.26683,9.96946,-3.25021>,<0.20099,9.96873,-3.22841>,
            
    /*6*/ <0.21001,10.25286,-3.48145>,<0.25047,10.27602,-3.44728>,<0.19452,10.28242,-3.43426>,
            
    /*7*/ <0.20551,10.58397,-3.65538>,<0.23793,10.60027,-3.62671>,<0.19317,10.60519,-3.61619>,
            
    /*8*/ <0.27742,10.90915,-3.82398>,<0.30113,10.917,-3.79992>,<0.2681,10.92659,-3.79549>,
            
    /*9*/ <0.35915,11.21791,-4.01199>,<0.37511,11.22368,-3.99628>,<0.3533,11.23095,-3.99382>,
            
    /*10*/ <0.44939,11.55559,-4.14508>,<0.45698,11.55714,-4.13649>,<0.44602,11.56057,-4.1352>,
            
    /*11*/ <0.5576,11.88796,-4.27212>

    /* stem 0.12.6.0*/ 
    /*0*/ <0.58319,9.23898,-2.32658>,
    /*1*/ <0.60185,9.26019,-2.32562>,<0.55854,9.24242,-2.34>,<0.58917,9.21431,-2.31412>,
            
    /*2*/ <1.1788,8.77012,-3.54076>

    /* stem 0.12.6.1*/ 
    /*0*/ <0.4741,9.37433,-2.61467>,
    /*1*/ <0.44913,9.36884,-2.60657>,<0.48172,9.36834,-2.63967>,<0.49146,9.38583,-2.59776>,
            
    /*2*/ <0.07105,10.59385,-3.02993>

    /* stem 0.12.6.2*/ 
    /*0*/ <0.38326,9.50992,-2.8263>,
    /*1*/ <0.40216,9.49969,-2.84035>,<0.37631,9.53435,-2.82999>,<0.37132,9.49572,-2.80856>,
            
    /*2*/ <-0.47513,9.13285,-3.70601>

    /* stem 0.12.6.3*/ 
    /*0*/ <0.33498,9.59845,-2.95569>,
    /*1*/ <0.33069,9.61796,-2.94073>,<0.31723,9.59061,-2.97139>,<0.35703,9.58676,-2.95494>,
            
    /*2*/ <0.77226,10.36729,-3.8337>

    /* stem 0.12.6.4*/ 
    /*0*/ <0.25905,9.83419,-3.1679>,
    /*1*/ <0.24597,9.82088,-3.18223>,<0.2763,9.84753,-3.17671>,<0.25487,9.83415,-3.14475>,
            
    /*2*/ <-0.49235,10.71681,-3.30182>

    /* stem 0.12.6.5*/ 
    /*0*/ <0.22479,10.08038,-3.33317>,
    /*1*/ <0.24619,10.0841,-3.32848>,<0.21025,10.09718,-3.33278>,<0.21794,10.05987,-3.33825>,
            
    /*2*/ <0.42296,10.27647,-4.39203>

    /* stem 0.12.6.6*/ 
    /*0*/ <0.21465,10.46622,-3.56147>,
    /*1*/ <0.19624,10.46998,-3.55396>,<0.21811,10.46831,-3.5813>,<0.2296,10.46036,-3.54915>,
            
    /*2*/ <0.46625,11.41001,-3.41782>

    /* stem 0.12.6.7*/ 
    /*0*/ <0.23883,10.71858,-3.69881>,
    /*1*/ <0.24695,10.7091,-3.71307>,<0.24588,10.73529,-3.69331>,<0.22365,10.71136,-3.69007>,
            
    /*2*/ <-0.30979,11.1472,-4.2967>

    /* stem 0.12.6.8*/ 
    /*0*/ <0.29964,10.98413,-3.84862>,
    /*1*/ <0.30407,10.99237,-3.83377>,<0.29008,10.99245,-3.86077>,<0.30478,10.96755,-3.85132>,
            
    /*2*/ <1.00651,11.26262,-4.21398>

    /* stem 0.12.6.9*/ 
    /*0*/ <0.33591,11.1226,-3.93634>,
    /*1*/ <0.32347,11.12014,-3.94536>,<0.34979,11.12535,-3.94281>,<0.33447,11.1223,-3.92085>,
            
    /*2*/ <0.18015,11.91009,-3.93588>

    /* stem 0.12.6.10*/ 
    /*0*/ <0.38995,11.32782,-4.04364>,
    /*1*/ <0.40089,11.32516,-4.04308>,<0.38636,11.33778,-4.03976>,<0.38259,11.32052,-4.04809>,
            
    /*2*/ <0.49803,11.62907,-4.71691>

    /* stem 0.12.6.11*/ 
    /*0*/ <0.52441,11.78534,-4.23072>,
    /*1*/ <0.52294,11.78627,-4.22959>,<0.52463,11.78582,-4.23273>,<0.52565,11.78393,-4.22985>,
            
    /*2*/ <0.92676,12.23519,-4.07829>

    /* stem 0.12.7*/ 
    /*0*/ <0.8163,9.29626,-2.58162>,
    /*1*/ <0.85759,9.33781,-2.55637>,<0.77295,9.31612,-2.62399>,<0.81838,9.23484,-2.56451>,
            
    /*2*/ <1.08036,9.26803,-2.82189>,<1.00418,9.2485,-2.88274>,<1.04506,9.17536,-2.82922>,
            
    /*3*/ <1.32137,9.30975,-3.05418>,<1.26419,9.29043,-3.11875>,<1.31122,9.22602,-3.08063>,
            
    /*4*/ <1.48957,9.48086,-3.3045>,<1.43405,9.46332,-3.3554>,<1.4948,9.41626,-3.3467>,
            
    /*5*/ <1.63125,9.69911,-3.53798>,<1.58379,9.68456,-3.58192>,<1.6399,9.64927,-3.58083>,
            
    /*6*/ <1.7506,9.97615,-3.70607>,<1.71359,9.96864,-3.74639>,<1.76338,9.94496,-3.74985>,
            
    /*7*/ <1.79564,10.29366,-3.85079>,<1.76507,10.28479,-3.88145>,<1.80753,10.27524,-3.88917>,
            
    /*8*/ <1.79977,10.62142,-3.98216>,<1.77668,10.61331,-4.00452>,<1.80882,10.60994,-4.01191>,
            
    /*9*/ <1.81816,10.95373,-4.09839>,<1.80282,10.94957,-4.11375>,<1.82422,10.94674,-4.11846>,
            
    /*10*/ <1.85378,11.2868,-4.21056>,<1.84615,11.28516,-4.21838>,<1.85681,11.28328,-4.22058>,
            
    /*11*/ <1.88123,11.62404,-4.31254>

    /* stem 0.12.7.0*/ 
    /*0*/ <0.99091,9.24575,-2.78401>,
    /*1*/ <0.97054,9.24505,-2.80141>,<1.01017,9.22716,-2.78517>,<0.99202,9.26505,-2.76545>,
            
    /*2*/ <1.69076,10.02381,-3.63475>

    /* stem 0.12.7.1*/ 
    /*0*/ <1.11401,9.24303,-2.91105>,
    /*1*/ <1.12964,9.22739,-2.89731>,<1.12219,9.26672,-2.91805>,<1.09019,9.23497,-2.91779>,
            
    /*2*/ <1.59501,8.7493,-4.01989>

    /* stem 0.12.7.2*/ 
    /*0*/ <1.36901,9.34717,-3.18569>,
    /*1*/ <1.35703,9.36744,-3.17961>,<1.37424,9.34268,-3.209>,<1.37575,9.33141,-3.16846>,
            
    /*2*/ <2.42122,9.9319,-3.06218>

    /* stem 0.12.7.3*/ 
    /*0*/ <1.55277,9.57667,-3.46268>,
    /*1*/ <1.55213,9.56068,-3.47857>,<1.57144,9.58896,-3.4598>,<1.53473,9.58036,-3.44968>,
            
    /*2*/ <1.17536,10.32208,-4.19774>

    /* stem 0.12.7.4*/ 
    /*0*/ <1.65514,9.76232,-3.61648>,
    /*1*/ <1.66682,9.76731,-3.59928>,<1.64384,9.77746,-3.62649>,<1.65476,9.74218,-3.62367>,
            
    /*2*/ <2.47786,9.96768,-4.23479>

    /* stem 0.12.7.5*/ 
    /*0*/ <1.71766,9.90608,-3.70064>,
    /*1*/ <1.69897,9.90956,-3.70857>,<1.73404,9.90479,-3.71305>,<1.71996,9.90389,-3.68028>,
            
    /*2*/ <1.86414,10.89801,-3.61026>

    /* stem 0.12.7.6*/ 
    /*0*/ <1.77202,10.16538,-3.82198>,
    /*1*/ <1.78946,10.16007,-3.82832>,<1.76912,10.18336,-3.81562>,<1.75748,10.15269,-3.822>,
            
    /*2*/ <1.5388,10.43409,-4.68815>

    /* stem 0.12.7.7*/ 
    /*0*/ <1.79348,10.52104,-3.96381>,
    /*1*/ <1.78582,10.52679,-3.94907>,<1.78929,10.52826,-3.97928>,<1.80533,10.50808,-3.96308>,
            
    /*2*/ <2.40947,11.0898,-3.86515>

    /* stem 0.12.7.8*/ 
    /*0*/ <1.80588,10.79583,-4.05928>,
    /*1*/ <1.80208,10.79126,-4.07381>,<1.81736,10.80631,-4.05711>,<1.7982,10.78993,-4.04694>,
            
    /*2*/ <1.28958,11.37104,-4.10512>

    /* stem 0.12.7.9*/ 
    /*0*/ <1.83464,11.12643,-4.16617>,
    /*1*/ <1.8422,11.12734,-4.16066>,<1.82791,11.13299,-4.16604>,<1.83382,11.11896,-4.17182>,
            
    /*2*/ <2.15994,11.47045,-4.66891>

    /* stem 0.12.7.10*/ 
    /*0*/ <1.87388,11.53815,-4.28821>,
    /*1*/ <1.87228,11.53831,-4.28814>,<1.8747,11.53873,-4.28948>,<1.87467,11.53741,-4.28701>,
            
    /*2*/ <1.93545,12.05245,-4.01187>

    /* stem 0.12.8*/ 
    /*0*/ <1.14349,9.55287,-3.37827>,
    /*1*/ <1.09079,9.55276,-3.40385>,<1.18909,9.52765,-3.40502>,<1.15058,9.5782,-3.32593>,
            
    /*2*/ <1.16556,9.83156,-3.54565>,<1.25403,9.80896,-3.5467>,<1.21937,9.85446,-3.47552>,
            
    /*3*/ <1.24861,10.11477,-3.67808>,<1.32686,10.09325,-3.67816>,<1.29558,10.13228,-3.61424>,
            
    /*4*/ <1.3704,10.38026,-3.82256>,<1.43613,10.35371,-3.81834>,<1.41068,10.39404,-3.76571>,
            
    /*5*/ <1.44126,10.64339,-3.98072>,<1.50011,10.62787,-3.98188>,<1.47838,10.66141,-3.93596>,
            
    /*6*/ <1.50337,10.92361,-4.12521>,<1.55282,10.91251,-4.12725>,<1.53403,10.93734,-4.0872>,
            
    /*7*/ <1.57323,11.2042,-4.26762>,<1.61262,11.19453,-4.26879>,<1.59757,11.2145,-4.23683>,
            
    /*8*/ <1.60828,11.49549,-4.3948>,<1.63833,11.49132,-4.39725>,<1.6267,11.50375,-4.37202>,
            
    /*9*/ <1.6402,11.80902,-4.4644>,<1.6603,11.80689,-4.46624>,<1.65221,11.8117,-4.44826>,
            
    /*10*/ <1.73819,12.11348,-4.5164>,<1.74786,12.11045,-4.51687>,<1.74386,12.11326,-4.50798>,
            
    /*11*/ <1.84593,12.41379,-4.55869>

    /* stem 0.12.8.0*/ 
    /*0*/ <1.18536,9.72085,-3.46524>,
    /*1*/ <1.20854,9.71293,-3.46938>,<1.18143,9.74383,-3.45666>,<1.16611,9.70579,-3.46969>,
            
    /*2*/ <1.12254,10.14451,-4.6286>

    /* stem 0.12.8.1*/ 
    /*0*/ <1.2582,9.99633,-3.60105>,
    /*1*/ <1.24566,10.00756,-3.5847>,<1.25636,10.00259,-3.6236>,<1.27258,9.97884,-3.59486>,
            
    /*2*/ <2.12565,10.75946,-3.46011>

    /* stem 0.12.8.2*/ 
    /*0*/ <1.32312,10.18799,-3.69811>,
    /*1*/ <1.32041,10.1781,-3.71812>,<1.34313,10.1965,-3.69239>,<1.30581,10.18937,-3.68381>,
            
    /*2*/ <1.03483,11.16389,-4.14134>

    /* stem 0.12.8.3*/ 
    /*0*/ <1.43602,10.49631,-3.87576>,
    /*1*/ <1.4513,10.5007,-3.86228>,<1.42239,10.5111,-3.88124>,<1.43437,10.47714,-3.88375>,
            
    /*2*/ <2.04147,10.76726,-4.6507>

    /* stem 0.12.8.4*/ 
    /*0*/ <1.50277,10.78981,-4.04256>,
    /*1*/ <1.48377,10.7925,-4.04478>,<1.51454,10.79102,-4.05783>,<1.50999,10.7859,-4.02508>,
            
    /*2*/ <1.61406,11.70693,-3.88366>

    /* stem 0.12.8.5*/ 
    /*0*/ <1.55371,11.02721,-4.16626>,
    /*1*/ <1.56773,11.01958,-4.17479>,<1.55605,11.04255,-4.15693>,<1.53735,11.01951,-4.16705>,
            
    /*2*/ <1.37028,11.49046,-4.88191>

    /* stem 0.12.8.6*/ 
    /*0*/ <1.60971,11.35309,-4.32398>,
    /*1*/ <1.60615,11.35993,-4.30945>,<1.60309,11.35915,-4.33776>,<1.61989,11.3402,-4.32472>,
            
    /*2*/ <2.21949,11.83933,-4.40325>

    /* stem 0.12.8.7*/ 
    /*0*/ <1.63749,11.65087,-4.42333>,
    /*1*/ <1.63098,11.64845,-4.43627>,<1.64933,11.65952,-4.42257>,<1.63216,11.64463,-4.41115>,
            
    /*2*/ <1.21994,12.21281,-4.31823>

    /* stem 0.12.8.8*/ 
    /*0*/ <1.68032,11.90574,-4.47687>,
    /*1*/ <1.68892,11.90391,-4.47241>,<1.6749,11.91348,-4.47411>,<1.67715,11.89981,-4.48407>,
            
    /*2*/ <1.98321,12.27239,-4.91147>

    /* stem 0.12.8.9*/ 
    /*0*/ <1.77649,12.20986,-4.52828>,
    /*1*/ <1.77287,12.21122,-4.52744>,<1.77857,12.21146,-4.53126>,<1.77804,12.2069,-4.52615>,
            
    /*2*/ <2.00093,12.58603,-4.16876>

    /* stem 0.12.9*/ 
    /*0*/ <1.48356,9.83899,-4.12131>,
    /*1*/ <1.52589,9.80697,-4.11446>,<1.49071,9.89132,-4.12994>,<1.43408,9.81868,-4.11953>,
            
    /*2*/ <1.53131,9.7616,-4.40175>,<1.49965,9.83752,-4.41569>,<1.44868,9.77214,-4.40632>,
            
    /*3*/ <1.56303,9.78873,-4.6935>,<1.5328,9.85642,-4.69166>,<1.48979,9.79686,-4.70182>,
            
    /*4*/ <1.63478,9.93003,-4.94316>,<1.60318,9.98313,-4.92332>,<1.57207,9.93788,-4.95789>,
            
    /*5*/ <1.70504,10.11554,-5.16054>,<1.67556,10.15614,-5.13655>,<1.65134,10.12222,-5.17337>,
            
    /*6*/ <1.78098,10.31084,-5.36257>,<1.75588,10.34357,-5.34143>,<1.73657,10.31713,-5.37424>,
            
    /*7*/ <1.81997,10.51484,-5.57087>,<1.79957,10.53913,-5.55168>,<1.78339,10.51688,-5.57653>,
            
    /*8*/ <1.86284,10.73788,-5.75377>,<1.84714,10.75448,-5.73791>,<1.8355,10.73984,-5.75849>,
            
    /*9*/ <1.95376,10.96913,-5.90165>,<1.94321,10.98029,-5.89127>,<1.93639,10.97296,-5.90688>,
            
    /*10*/ <2.05173,11.23072,-5.98523>,<2.04587,11.23494,-5.97942>,<2.04327,11.23313,-5.98813>,
            
    /*11*/ <2.14338,11.49762,-6.05668>

    /* stem 0.12.9.0*/ 
    /*0*/ <1.48971,9.80803,-4.30398>,
    /*1*/ <1.48489,9.82983,-4.30784>,<1.4816,9.79202,-4.3178>,<1.50266,9.80225,-4.28631>,
            
    /*2*/ <2.40334,9.89725,-4.9438>

    /* stem 0.12.9.1*/ 
    /*0*/ <1.51419,9.80442,-4.57879>,
    /*1*/ <1.50495,9.78527,-4.5815>,<1.53225,9.80919,-4.58932>,<1.50538,9.8188,-4.56557>,
            
    /*2*/ <0.94719,10.19071,-5.37652>

    /* stem 0.12.9.2*/ 
    /*0*/ <1.57335,9.89568,-4.84291>,
    /*1*/ <1.59017,9.90238,-4.83407>,<1.56252,9.908,-4.85459>,<1.56737,9.87666,-4.84006>,
            
    /*2*/ <2.09649,9.61407,-5.6248>

    /* stem 0.12.9.3*/ 
    /*0*/ <1.65035,10.06533,-5.0783>,
    /*1*/ <1.63229,10.07008,-5.08051>,<1.6617,10.06432,-5.09326>,<1.65705,10.06158,-5.06114>,
            
    /*2*/ <1.86796,10.94215,-4.97201>

    /* stem 0.12.9.4*/ 
    /*0*/ <1.72041,10.23437,-5.26527>,
    /*1*/ <1.73224,10.22288,-5.27149>,<1.72426,10.25157,-5.26473>,<1.70472,10.22867,-5.25959>,
            
    /*2*/ <1.40349,10.33009,-6.04472>

    /* stem 0.12.9.5*/ 
    /*0*/ <1.78963,10.47112,-5.51198>,
    /*1*/ <1.78858,10.48275,-5.50097>,<1.78155,10.47238,-5.52579>,<1.79877,10.45823,-5.50918>,
            
    /*2*/ <2.38643,10.82528,-5.82898>

    /* stem 0.12.9.6*/ 
    /*0*/ <1.83074,10.66172,-5.68144>,
    /*1*/ <1.82231,10.65501,-5.69168>,<1.84413,10.66702,-5.68515>,<1.8258,10.66313,-5.66749>,
            
    /*2*/ <1.54084,11.27807,-5.84661>

    /* stem 0.12.9.7*/ 
    /*0*/ <1.87749,10.81359,-5.79535>,
    /*1*/ <1.8901,10.81214,-5.78951>,<1.87225,10.82635,-5.79756>,<1.87014,10.80229,-5.79899>,
            
    /*2*/ <2.1534,10.82464,-6.38787>

    /* stem 0.12.9.8*/ 
    /*0*/ <1.98352,11.07277,-5.93207>,
    /*1*/ <1.97579,11.07634,-5.9305>,<1.98805,11.07515,-5.93906>,<1.98672,11.06681,-5.92665>,
            
    /*2*/ <2.23905,11.49034,-5.62408>

    /* stem 0.12.9.9*/ 
    /*0*/ <2.07293,11.30424,-6.00377>,
    /*1*/ <2.07497,11.30269,-6.00672>,<2.07465,11.30675,-6.00132>,<2.06918,11.30327,-6.00326>,
            
    /*2*/ <1.93137,11.69722,-6.30736>

    /* stem 0.12.10*/ 
    /*0*/ <2.02273,10.32365,-5.32654>,
    /*1*/ <2.01144,10.35557,-5.31732>,<2.01213,10.30935,-5.35677>,<2.04462,10.30604,-5.30552>,
            
    /*2*/ <2.20089,10.4516,-5.43126>,<2.20151,10.41001,-5.46676>,<2.23075,10.40703,-5.42064>,
            
    /*3*/ <2.36944,10.57494,-5.5428>,<2.37328,10.54022,-5.57661>,<2.40098,10.53845,-5.53671>,
            
    /*4*/ <2.47938,10.75101,-5.64761>,<2.48743,10.72638,-5.68134>,<2.5152,10.72813,-5.64917>,
            
    /*5*/ <2.54703,10.93759,-5.7808>,<2.5531,10.91563,-5.80927>,<2.57997,10.92275,-5.78568>,
            
    /*6*/ <2.63028,11.12496,-5.90854>,<2.63557,11.10687,-5.93237>,<2.65728,11.11136,-5.9116>,
            
    /*7*/ <2.71073,11.33386,-5.99001>,<2.71671,11.32361,-6.01122>,<2.73292,11.32444,-5.99313>,
            
    /*8*/ <2.7826,11.54955,-6.06811>,<2.78726,11.54242,-6.08422>,<2.79949,11.54323,-6.07073>,
            
    /*9*/ <2.80687,11.76234,-6.17747>,<2.80975,11.75682,-6.18791>,<2.81849,11.75987,-6.18003>,
            
    /*10*/ <2.83919,11.96091,-6.31158>,<2.84056,11.95751,-6.31643>,<2.84496,11.95934,-6.31266>,
            
    /*11*/ <2.9163,12.16075,-6.42263>

    /* stem 0.12.10.0*/ 
    /*0*/ <2.14046,10.38568,-5.39719>,
    /*1*/ <2.13901,10.37585,-5.40823>,<2.15366,10.38761,-5.39063>,<2.12871,10.3936,-5.3927>,
            
    /*2*/ <2.35031,11.04685,-6.01342>

    /* stem 0.12.10.1*/ 
    /*0*/ <2.3154,10.50156,-5.50852>,
    /*1*/ <2.32225,10.50312,-5.49638>,<2.31282,10.51274,-5.51661>,<2.31113,10.48883,-5.51258>,
            
    /*2*/ <3.0728,10.37856,-5.92006>

    /* stem 0.12.10.2*/ 
    /*0*/ <2.52109,10.81316,-5.71373>,
    /*1*/ <2.50923,10.81469,-5.71744>,<2.53042,10.81432,-5.72198>,<2.5236,10.81046,-5.70177>,
            
    /*2*/ <2.56805,11.5618,-5.55478>

    /* stem 0.12.10.3*/ 
    /*0*/ <2.59499,11.00691,-5.84611>,
    /*1*/ <2.60455,11.00091,-5.84898>,<2.59595,11.01771,-5.84185>,<2.58447,11.00212,-5.8475>,
            
    /*2*/ <2.56251,11.26899,-6.50269>

    /* stem 0.12.10.4*/ 
    /*0*/ <2.69724,11.26571,-5.9748>,
    /*1*/ <2.69302,11.27046,-5.96639>,<2.69724,11.27057,-5.98415>,<2.70147,11.2561,-5.97385>,
            
    /*2*/ <3.25909,11.52591,-5.83984>

    /* stem 0.12.10.5*/ 
    /*0*/ <2.76055,11.45368,-6.04236>,
    /*1*/ <2.7582,11.45121,-6.05154>,<2.76836,11.45932,-6.04065>,<2.75509,11.45049,-6.03489>,
            
    /*2*/ <2.42552,11.92944,-6.08439>

    /* stem 0.12.10.6*/ 
    /*0*/ <2.82896,11.87504,-6.25796>,
    /*1*/ <2.83311,11.87611,-6.2554>,<2.82569,11.87864,-6.25902>,<2.82809,11.87036,-6.25945>,
            
    /*2*/ <3.05438,11.96115,-6.65878>

    /* stem 0.12.10.7*/ 
    /*0*/ <2.87302,12.04405,-6.35946>,
    /*1*/ <2.87109,12.04469,-6.3596>,<2.8743,12.04434,-6.36101>,<2.87366,12.04312,-6.35777>,
            
    /*2*/ <2.98456,12.41419,-6.19758>

    /* stem 0.12.11*/ 
    /*0*/ <2.31083,10.7102,-6.02689>,
    /*1*/ <2.30486,10.69375,-6.03943>,<2.33167,10.71519,-6.02486>,<2.29594,10.72167,-6.01637>,
            
    /*2*/ <2.29013,10.82634,-6.20267>,<2.31426,10.84563,-6.18956>,<2.28211,10.85147,-6.18192>,
            
    /*3*/ <2.29582,10.99639,-6.33503>,<2.3173,11.00882,-6.31846>,<2.28863,11.01447,-6.31241>,
            
    /*4*/ <2.30109,11.18093,-6.44138>,<2.31981,11.1898,-6.4255>,<2.2947,11.19389,-6.41964>,
            
    /*5*/ <2.32305,11.36955,-6.53563>,<2.33892,11.37526,-6.52093>,<2.31747,11.37992,-6.51661>,
            
    /*6*/ <2.33806,11.55696,-6.63059>,<2.35134,11.56216,-6.61859>,<2.33342,11.56556,-6.61471>,
            
    /*7*/ <2.3411,11.75135,-6.71346>,<2.35174,11.75543,-6.70383>,<2.33737,11.75718,-6.70025>,
            
    /*8*/ <2.35512,11.94752,-6.79039>,<2.36307,11.94999,-6.78291>,<2.3523,11.95174,-6.78042>,
            
    /*9*/ <2.37121,12.14961,-6.85021>,<2.37646,12.15078,-6.84505>,<2.36928,12.15185,-6.84337>,
            
    /*10*/ <2.3878,12.35022,-6.91265>,<2.39043,12.35084,-6.91008>,<2.38684,12.3514,-6.90924>,
            
    /*11*/ <2.42083,12.55488,-6.95242>

    /* stem 0.12.11.0*/ 
    /*0*/ <2.30172,10.78797,-6.12458>,
    /*1*/ <2.30929,10.7923,-6.12184>,<2.29487,10.79269,-6.12836>,<2.30101,10.77892,-6.12355>,
            
    /*2*/ <2.63107,10.67781,-6.85988>

    /* stem 0.12.11.1*/ 
    /*0*/ <2.30256,11.08412,-6.3676>,
    /*1*/ <2.29441,11.0847,-6.36697>,<2.30634,11.08677,-6.37437>,<2.30692,11.0809,-6.36146>,
            
    /*2*/ <2.3714,11.73821,-6.07356>

    /* stem 0.12.11.2*/ 
    /*0*/ <2.31385,11.26413,-6.4677>,
    /*1*/ <2.31921,11.26115,-6.47232>,<2.31535,11.27052,-6.46369>,<2.30699,11.26073,-6.46708>,
            
    /*2*/ <2.08293,11.63707,-6.9753>

    /* stem 0.12.11.3*/ 
    /*0*/ <2.33249,11.45245,-6.56465>,
    /*1*/ <2.33194,11.45577,-6.55834>,<2.32819,11.45432,-6.57006>,<2.33733,11.44726,-6.56555>,
            
    /*2*/ <2.74859,11.87299,-6.74958>

    /* stem 0.12.11.4*/ 
    /*0*/ <2.35049,11.85758,-6.74738>,
    /*1*/ <2.347,11.85595,-6.75203>,<2.35588,11.8601,-6.74839>,<2.34858,11.8567,-6.74172>,
            
    /*2*/ <2.13359,12.32244,-6.74827>

    /* stem 0.12.11.5*/ 
    /*0*/ <2.36654,12.07581,-6.82323>,
    /*1*/ <2.37146,12.07586,-6.82186>,<2.36361,12.0799,-6.82234>,<2.36456,12.07169,-6.8255>,
            
    /*2*/ <2.47922,12.2463,-7.23238>

    /* stem 0.12.11.6*/ 
    /*0*/ <2.40528,12.45714,-6.93242>,
    /*1*/ <2.40435,12.45737,-6.93203>,<2.40559,12.45758,-6.93329>,<2.40589,12.45648,-6.93192>,
            
    /*2*/ <2.54984,12.72996,-6.74434>

    /* stem 0.13*/ 
    /*0*/ <-0.03026,9.2148,-0.3041>,
    /*1*/ <-0.15153,9.21875,-0.26029>,<-0.07665,9.33319,-0.32583>,<0.06233,9.28401,-0.36134>,
            <0.07335,9.13918,-0.31775>,<-0.05882,9.09885,-0.2553>,
    /*2*/ <0.11753,9.44634,0.42785>,<0.1853,9.5499,0.36854>,<0.31108,9.50539,0.33641>,
            <0.32105,9.37432,0.37585>,<0.20143,9.33782,0.43237>,
    /*3*/ <0.38,9.80451,1.06223>,<0.43443,9.88999,0.99282>,<0.54889,9.85231,0.969>,
            <0.56519,9.74354,1.02369>,<0.46081,9.71399,1.08131>,
    /*4*/ <0.54899,10.14167,1.72214>,<0.59949,10.22178,1.66934>,<0.7038,10.19424,1.65851>,
            <0.71777,10.0971,1.70462>,<0.62209,10.06462,1.74395>,
    /*5*/ <0.74072,10.46954,2.39789>,<0.78467,10.53924,2.35261>,<0.87453,10.51416,2.3409>,
            <0.88611,10.42897,2.37894>,<0.80342,10.40139,2.41417>,
    /*6*/ <0.9324,10.82698,3.05668>,<0.9689,10.88462,3.01565>,<1.04513,10.86365,3.00626>,
            <1.05573,10.79304,3.04149>,<0.98606,10.77038,3.07264>,
    /*7*/ <1.08373,11.23694,3.69108>,<1.11302,11.28282,3.65518>,<1.17633,11.26776,3.651>,
            <1.18616,11.21258,3.68431>,<1.12893,11.19352,3.70908>,
    /*8*/ <1.22366,11.63538,4.33746>,<1.24669,11.67182,4.31058>,<1.29612,11.66042,4.30782>,
            <1.30364,11.61694,4.33299>,<1.25885,11.60146,4.35131>,
    /*9*/ <1.4389,12.06959,4.94578>,<1.45466,12.09364,4.92346>,<1.48938,12.08371,4.91894>,
            <1.49509,12.05354,4.93847>,<1.46389,12.04481,4.95505>,
    /*10*/ <1.62653,12.53363,5.53392>,<1.6359,12.54783,5.51999>,<1.65711,12.54237,5.51797>,
            <1.66084,12.5248,5.53064>,<1.64194,12.51939,5.5405>,
    /*11*/ <1.75884,13.04209,6.09955>,<1.76203,13.04688,6.0946>,<1.76946,13.04539,6.09436>,
            <1.77086,13.03968,6.09915>,<1.7643,13.03765,6.10236>,
    /*12*/ <1.7651,13.04234,6.09801>

    /* stem 0.13c0*/ 
    /*0*/ <0.63843,10.14388,1.69971>,
    /*1*/ <0.54658,10.14279,1.69139>,<0.61333,10.21814,1.65111>,<0.71477,10.19087,1.67799>,
            <0.71071,10.09866,1.73489>,<0.60676,10.06895,1.74318>,
    /*2*/ <0.49472,10.54956,2.34682>,<0.5526,10.6149,2.31188>,<0.64056,10.59125,2.33519>,
            <0.63704,10.51129,2.38454>,<0.54691,10.48553,2.39172>,
    /*3*/ <0.53001,11.04032,2.95427>,<0.57949,11.08783,2.91387>,<0.65406,11.0648,2.92963>,
            <0.65065,11.00305,2.97977>,<0.57399,10.98792,2.995>,
    /*4*/ <0.60774,11.58545,3.5018>,<0.64788,11.61935,3.46318>,<0.70888,11.59978,3.47539>,
            <0.70643,11.55379,3.52155>,<0.64392,11.54493,3.53787>,
    /*5*/ <0.72048,12.13784,4.03446>,<0.75154,12.16265,4.00284>,<0.79885,12.14609,4.0111>,
            <0.79702,12.11104,4.04784>,<0.74858,12.10595,4.06227>,
    /*6*/ <0.87016,12.76418,4.46571>,<0.89155,12.77755,4.43948>,<0.92548,12.76589,4.44561>,
            <0.92506,12.74533,4.47563>,<0.89087,12.74427,4.48806>,
    /*7*/ <1.00243,13.44221,4.81132>,<1.01501,13.44859,4.79445>,<1.03574,13.44269,4.79883>,
            <1.03596,13.43267,4.8184>,<1.01537,13.43237,4.82612>,
    /*8*/ <1.09432,14.12473,5.16051>,<1.09869,14.12714,5.1548>,<1.10589,14.12544,5.15647>,
            <1.10597,14.12198,5.16322>,<1.09882,14.12154,5.16572>,
    /*9*/ <1.10074,14.12417,5.16014>

    /* stem 0.13c0c0*/ 
    /*0*/ <0.90062,12.75944,4.4629>,
    /*1*/ <0.88664,12.76616,4.43611>,<0.92063,12.77529,4.44537>,<0.92697,12.76252,4.47886>,
            <0.8969,12.7455,4.49029>,<0.87197,12.74775,4.46387>,
    /*2*/ <0.63205,13.42595,4.74849>,<0.65259,13.43147,4.75409>,<0.65642,13.42376,4.77432>,
            <0.63825,13.41347,4.78123>,<0.62319,13.41483,4.76527>,
    /*3*/ <0.42062,14.12412,5.00167>,<0.42781,14.12572,5.00347>,<0.42895,14.12359,5.01065>,
            <0.42247,14.12067,5.01329>,<0.41732,14.12099,5.00774>,
    /*4*/ <0.42343,14.12302,5.00736>

    /* stem 0.13c0c0.0*/ 
    /*0*/ <0.48255,13.93207,4.94127>,
    /*1*/ <0.48942,13.93179,4.94823>,<0.47308,13.93175,4.94373>,<0.48514,13.93267,4.93185>,
            
    /*2*/ <0.48504,14.13457,4.95936>,<0.47033,14.13454,4.95531>,<0.48119,14.13536,4.94462>,
            
    /*3*/ <0.44474,14.3351,4.94607>,<0.43197,14.33234,4.94245>,<0.44158,14.33364,4.93297>,
            
    /*4*/ <0.43252,14.53396,4.97449>,<0.42105,14.53373,4.97144>,<0.42936,14.53542,4.96314>,
            
    /*5*/ <0.40737,14.73113,5.01629>,<0.39758,14.73049,5.01359>,<0.40463,14.73286,5.00665>,
            
    /*6*/ <0.38626,14.93025,5.05085>,<0.37809,14.92981,5.04862>,<0.384,14.93145,5.04277>,
            
    /*7*/ <0.33401,15.11803,5.10851>,<0.32763,15.11689,5.10653>,<0.33212,15.11948,5.10216>,
            
    /*8*/ <0.26902,15.29062,5.19319>,<0.26428,15.28961,5.19165>,<0.26741,15.29226,5.18865>,
            
    /*9*/ <0.24681,15.4756,5.27315>,<0.2435,15.47553,5.27243>,<0.2457,15.47677,5.27017>,
            
    /*10*/ <0.20483,15.64785,5.3723>,<0.20319,15.64771,5.37188>,<0.20426,15.64855,5.37086>,
            
    /*11*/ <0.16234,15.82592,5.46043>

    /* stem 0.13c0c0.0.0*/ 
    /*0*/ <0.48119,14.00654,4.94561>,
    /*1*/ <0.477,14.00649,4.94522>,<0.48344,14.00956,4.94374>,<0.48313,14.00358,4.94789>,
            
    /*2*/ <0.41386,14.46011,5.59458>

    /* stem 0.13c0c0.0.1*/ 
    /*0*/ <0.43202,14.45978,4.95884>,
    /*1*/ <0.43501,14.46026,4.95675>,<0.43188,14.46123,4.96221>,<0.42917,14.45785,4.95755>,
            
    /*2*/ <0.16058,15.03264,4.70088>

    /* stem 0.13c0c0.0.2*/ 
    /*0*/ <0.41054,14.67228,4.99941>,
    /*1*/ <0.4097,14.67148,5.00264>,<0.40887,14.67478,4.99778>,<0.41304,14.67057,4.99782>,
            
    /*2*/ <0.83248,15.0919,5.21275>

    /* stem 0.13c0c0.0.3*/ 
    /*0*/ <0.39008,14.85938,5.03482>,
    /*1*/ <0.3887,14.85974,5.03196>,<0.39209,14.8616,5.03592>,<0.38943,14.85679,5.03658>,
            
    /*2*/ <-0.05822,15.1419,5.2855>

    /* stem 0.13c0c0.0.4*/ 
    /*0*/ <0.30555,15.1871,5.13985>,
    /*1*/ <0.30802,15.18741,5.14109>,<0.30323,15.18779,5.1412>,<0.30541,15.18611,5.13726>,
            
    /*2*/ <0.33839,15.65283,4.9594>

    /* stem 0.13c0c0.0.5*/ 
    /*0*/ <0.25229,15.41625,5.24587>,
    /*1*/ <0.25016,15.41574,5.24646>,<0.25281,15.41835,5.24519>,<0.25391,15.41465,5.24596>,
            
    /*2*/ <0.34052,15.52926,5.65999>

    /* stem 0.13c0c0.0.6*/ 
    /*0*/ <0.18755,15.7185,5.40684>,
    /*1*/ <0.18785,15.71879,5.40641>,<0.18764,15.71865,5.4074>,<0.18718,15.71807,5.4067>,
            
    /*2*/ <-0.07465,15.95575,5.3824>

    /* stem 0.13c0.0*/ 
    /*0*/ <0.6072,10.34209,2.01866>,
    /*1*/ <0.65819,10.30499,2.0467>,<0.54389,10.33996,2.04603>,<0.61953,10.38132,1.96323>,
            
    /*2*/ <0.74249,10.60536,2.27378>,<0.63962,10.63683,2.27318>,<0.7077,10.67406,2.19866>,
            
    /*3*/ <0.81432,10.90238,2.51033>,<0.72233,10.92839,2.50804>,<0.78378,10.96434,2.4442>,
            
    /*4*/ <0.8122,11.24368,2.71633>,<0.72998,11.2522,2.70333>,<0.78454,11.28517,2.64913>,
            
    /*5*/ <0.79676,11.61555,2.84435>,<0.72636,11.61835,2.83092>,<0.77333,11.63762,2.78026>,
            
    /*6*/ <0.76018,11.98404,2.96087>,<0.70171,11.98311,2.9485>,<0.74084,12.00021,2.90668>,
            
    /*7*/ <0.7245,12.33647,3.10857>,<0.67765,12.33653,3.09903>,<0.70866,12.35322,3.06669>,
            
    /*8*/ <0.68699,12.69423,3.24948>,<0.65188,12.69402,3.24221>,<0.67517,12.70609,3.21777>,
            
    /*9*/ <0.64104,13.05485,3.38091>,<0.61769,13.05412,3.37582>,<0.63324,13.06206,3.35949>,
            
    /*10*/ <0.56025,13.41549,3.49629>,<0.54876,13.41405,3.49334>,<0.5565,13.41836,3.48531>,
            
    /*11*/ <0.50041,13.77582,3.61951>

    /* stem 0.13c0.0.0*/ 
    /*0*/ <0.64805,10.47762,2.12368>,
    /*1*/ <0.61934,10.48321,2.12763>,<0.66669,10.4997,2.11772>,<0.6581,10.44995,2.12568>,
            
    /*2*/ <0.88795,10.67126,3.59259>

    /* stem 0.13c0.0.1*/ 
    /*0*/ <0.74546,10.82492,2.40041>,
    /*1*/ <0.76645,10.83258,2.38427>,<0.74904,10.82297,2.42768>,<0.72088,10.8192,2.3893>,
            
    /*2*/ <0.37013,12.15732,2.545>

    /* stem 0.13c0.0.2*/ 
    /*0*/ <0.77438,11.07325,2.57456>,
    /*1*/ <0.76951,11.05976,2.59654>,<0.75884,11.09327,2.56773>,<0.79479,11.06671,2.5594>,
            
    /*2*/ <1.54342,11.90142,3.25296>

    /* stem 0.13c0.0.3*/ 
    /*0*/ <0.76825,11.52414,2.78315>,
    /*1*/ <0.75655,11.53089,2.7632>,<0.78869,11.53524,2.78947>,<0.75952,11.5063,2.79679>,
            
    /*2*/ <0.13925,12.31966,3.42135>

    /* stem 0.13c0.0.4*/ 
    /*0*/ <0.75708,11.72214,2.85085>,
    /*1*/ <0.77864,11.7212,2.85931>,<0.73962,11.72919,2.86437>,<0.75298,11.71604,2.82887>,
            
    /*2*/ <0.93543,12.80577,2.51665>

    /* stem 0.13c0.0.5*/ 
    /*0*/ <0.7401,11.92067,2.91616>,
    /*1*/ <0.71911,11.91679,2.9225>,<0.74551,11.94018,2.9069>,<0.75568,11.90504,2.9191>,
            
    /*2*/ <0.96401,12.33046,3.90948>

    /* stem 0.13c0.0.6*/ 
    /*0*/ <0.72612,12.08267,2.97917>,
    /*1*/ <0.73703,12.09081,2.96253>,<0.73212,12.08735,2.99928>,<0.70923,12.06983,2.9757>,
            
    /*2*/ <0.08837,12.92396,2.97322>

    /* stem 0.13c0.0.7*/ 
    /*0*/ <0.68682,12.52727,3.16688>,
    /*1*/ <0.68994,12.52031,3.18467>,<0.67173,12.53892,3.16356>,<0.6988,12.52258,3.15242>,
            
    /*2*/ <1.22005,13.27472,3.36602>

    /* stem 0.13c0.0.8*/ 
    /*0*/ <0.64975,12.88857,3.30844>,
    /*1*/ <0.63694,12.89124,3.29753>,<0.66127,12.90082,3.31121>,<0.65105,12.87365,3.31657>,
            
    /*2*/ <0.17537,13.19181,3.93979>

    /* stem 0.13c0.0.9*/ 
    /*0*/ <0.57441,13.32446,3.46116>,
    /*1*/ <0.5829,13.326,3.46189>,<0.56911,13.32621,3.46778>,<0.57122,13.32116,3.45382>,
            
    /*2*/ <0.4735,14.00269,3.20073>

    /* stem 0.13c0.0.10*/ 
    /*0*/ <0.52143,13.63765,3.57041>,
    /*1*/ <0.51939,13.63682,3.57188>,<0.5211,13.63963,3.56868>,<0.52381,13.63651,3.57067>,
            
    /*2*/ <0.67904,14.06972,4.03375>

    /* stem 0.13c0.1*/ 
    /*0*/ <0.58511,10.77506,2.63132>,
    /*1*/ <0.5208,10.77842,2.63109>,<0.62019,10.82897,2.62799>,<0.61436,10.71779,2.63487>,
            
    /*2*/ <0.52712,10.80016,2.98771>,<0.61657,10.84566,2.98492>,<0.61132,10.74559,2.99112>,
            
    /*3*/ <0.51418,10.89066,3.3293>,<0.59414,10.92986,3.32349>,<0.58822,10.84367,3.34587>,
            
    /*4*/ <0.51986,11.03082,3.66033>,<0.58982,11.06277,3.64685>,<0.58487,10.99108,3.67741>,
            
    /*5*/ <0.58068,11.22019,3.96492>,<0.63905,11.24214,3.9406>,<0.63685,11.18566,3.97645>,
            
    /*6*/ <0.62933,11.4226,4.25373>,<0.67809,11.44091,4.23377>,<0.67645,11.39537,4.26593>,
            
    /*7*/ <0.68129,11.65006,4.52467>,<0.72,11.66343,4.50694>,<0.71923,11.62933,4.53572>,
            
    /*8*/ <0.75107,11.90123,4.77092>,<0.77957,11.90932,4.75535>,<0.77963,11.88589,4.77925>,
            
    /*9*/ <0.86748,12.16924,4.98112>,<0.88546,12.172,4.9682>,<0.88625,12.15804,4.98558>,
            
    /*10*/ <0.93146,12.43245,5.21121>,<0.9409,12.43505,5.20588>,<0.94107,12.42768,5.21425>,
            
    /*11*/ <0.94711,12.72293,5.41724>

    /* stem 0.13c0.1.0*/ 
    /*0*/ <0.58503,10.79207,2.906>,
    /*1*/ <0.60664,10.80832,2.905>,<0.58379,10.77233,2.92447>,<0.56466,10.79555,2.88853>,
            
    /*2*/ <-0.01784,11.64726,3.77961>

    /* stem 0.13c0.1.1*/ 
    /*0*/ <0.57614,10.8385,3.14486>,
    /*1*/ <0.56994,10.814,3.15097>,<0.56148,10.85817,3.15351>,<0.59699,10.84335,3.1301>,
            
    /*2*/ <1.31575,10.91854,4.21629>

    /* stem 0.13c0.1.2*/ 
    /*0*/ <0.56533,10.92669,3.42345>,
    /*1*/ <0.55434,10.94707,3.41474>,<0.58607,10.92856,3.43681>,<0.55558,10.90443,3.41881>,
            
    /*2*/ <-0.10659,11.00579,4.45546>

    /* stem 0.13c0.1.3*/ 
    /*0*/ <0.59459,11.1316,3.82621>,
    /*1*/ <0.61546,11.12272,3.82802>,<0.58217,11.13538,3.84491>,<0.58613,11.13671,3.80571>,
            
    /*2*/ <1.02833,12.16626,3.9053>

    /* stem 0.13c0.1.4*/ 
    /*0*/ <0.64721,11.35205,4.15475>,
    /*1*/ <0.62741,11.34801,4.16047>,<0.65377,11.37193,4.15293>,<0.66045,11.33623,4.15083>,
            
    /*2*/ <0.93394,11.34757,5.14282>

    /* stem 0.13c0.1.5*/ 
    /*0*/ <0.67738,11.50018,4.347>,
    /*1*/ <0.68756,11.51241,4.33501>,<0.68391,11.49665,4.36549>,<0.66069,11.49147,4.3405>,
            
    /*2*/ <0.15824,12.25185,4.67344>

    /* stem 0.13c0.1.6*/ 
    /*0*/ <0.74212,11.78771,4.65968>,
    /*1*/ <0.74523,11.77491,4.67195>,<0.72997,11.80059,4.66298>,<0.75115,11.78764,4.64411>,
            
    /*2*/ <1.36052,12.27953,5.01614>

    /* stem 0.13c0.1.7*/ 
    /*0*/ <0.80486,11.98368,4.83504>,
    /*1*/ <0.79225,11.99323,4.82944>,<0.8203,11.99011,4.83638>,<0.80203,11.9677,4.83929>,
            
    /*2*/ <0.64433,12.21192,5.58661>

    /* stem 0.13c0.1.8*/ 
    /*0*/ <0.90948,12.30231,5.0972>,
    /*1*/ <0.91893,12.30124,5.09607>,<0.9059,12.30439,5.10585>,<0.90361,12.30131,5.0897>,
            
    /*2*/ <0.97031,12.98494,4.95848>

    /* stem 0.13c0.1.9*/ 
    /*0*/ <0.94145,12.54568,5.29137>,
    /*1*/ <0.9385,12.54425,5.29352>,<0.94168,12.54953,5.29068>,<0.94417,12.54326,5.28992>,
            
    /*2*/ <1.28264,12.61846,5.80855>

    /* stem 0.13c0.2*/ 
    /*0*/ <0.63651,11.36036,3.27902>,
    /*1*/ <0.68293,11.38321,3.25068>,<0.64046,11.34738,3.33644>,<0.58613,11.3505,3.24995>,
            
    /*2*/ <0.57682,11.67958,3.32806>,<0.5386,11.64733,3.40524>,<0.4897,11.65015,3.32741>,
            
    /*3*/ <0.45785,11.97615,3.38089>,<0.42246,11.95103,3.45017>,<0.38144,11.94713,3.37956>,
            
    /*4*/ <0.33253,12.27267,3.41047>,<0.30011,12.25412,3.47147>,<0.26617,12.24599,3.40903>,
            
    /*5*/ <0.23883,12.57246,3.48919>,<0.21285,12.55184,3.54075>,<0.18001,12.55516,3.48908>,
            
    /*6*/ <0.15268,12.87064,3.58355>,<0.13148,12.85192,3.62611>,<0.10338,12.8572,3.58376>,
            
    /*7*/ <0.07242,13.16749,3.68601>,<0.05561,13.15196,3.71988>,<0.03282,13.15736,3.68638>,
            
    /*8*/ <0.02717,13.4706,3.78419>,<0.01427,13.46076,3.8102>,<-0.00313,13.46615,3.78554>,
            
    /*9*/ <-0.07167,13.77025,3.86673>,<-0.0802,13.76307,3.88386>,<-0.09118,13.76417,3.86666>,
            
    /*10*/ <-0.12858,14.08046,3.93429>,<-0.13307,14.07788,3.9431>,<-0.13864,14.07872,3.93457>,
            
    /*11*/ <-0.18613,14.39675,3.97363>

    /* stem 0.13c0.2.0*/ 
    /*0*/ <0.59683,11.47716,3.30818>,
    /*1*/ <0.59022,11.46915,3.33127>,<0.58295,11.49478,3.29644>,<0.61731,11.46754,3.29682>,
            
    /*2*/ <1.31056,12.38487,3.82727>

    /* stem 0.13c0.2.1*/ 
    /*0*/ <0.47724,11.81006,3.3788>,
    /*1*/ <0.46876,11.81052,3.35662>,<0.48608,11.82983,3.38855>,<0.47688,11.78982,3.39124>,
            
    /*2*/ <-0.5924,12.08374,3.79341>

    /* stem 0.13c0.2.2*/ 
    /*0*/ <0.38417,12.04824,3.4116>,
    /*1*/ <0.40249,12.0546,3.42327>,<0.36377,12.05614,3.41739>,<0.38625,12.034,3.39415>,
            
    /*2*/ <0.5235,12.9152,2.72045>

    /* stem 0.13c0.2.3*/ 
    /*0*/ <0.23888,12.4637,3.48216>,
    /*1*/ <0.2196,12.45715,3.48561>,<0.24219,12.48027,3.47028>,<0.25486,12.45368,3.4906>,
            
    /*2*/ <0.18241,13.05879,4.29632>

    /* stem 0.13c0.2.4*/ 
    /*0*/ <0.16264,12.73655,3.56021>,
    /*1*/ <0.17348,12.74385,3.54593>,<0.16479,12.74308,3.5783>,<0.14963,12.72274,3.55639>,
            
    /*2*/ <-0.4891,13.39419,3.40087>

    /* stem 0.13c0.2.5*/ 
    /*0*/ <0.07923,13.05759,3.66366>,
    /*1*/ <0.08073,13.05233,3.6806>,<0.0666,13.06927,3.65906>,<0.09035,13.05119,3.65133>,
            
    /*2*/ <0.62034,13.70322,3.81616>

    /* stem 0.13c0.2.6*/ 
    /*0*/ <0.0391,13.26802,3.73151>,
    /*1*/ <0.02734,13.27014,3.71971>,<0.05075,13.27985,3.73396>,<0.0392,13.25407,3.74085>,
            
    /*2*/ <-0.43655,13.62497,4.26971>

    /* stem 0.13c0.2.7*/ 
    /*0*/ <-0.05588,13.68543,3.85122>,
    /*1*/ <-0.04314,13.68881,3.85352>,<-0.06536,13.68861,3.86011>,<-0.05914,13.67887,3.84002>,
            
    /*2*/ <-0.15765,14.29124,3.52615>

    /* stem 0.13c0.2.8*/ 
    /*0*/ <-0.10662,13.91882,3.90412>,
    /*1*/ <-0.11395,13.91664,3.9087>,<-0.10639,13.92638,3.8994>,<-0.09951,13.91344,3.90427>,
            
    /*2*/ <0.11824,14.22937,4.41175>

    /* stem 0.13c0.2.9*/ 
    /*0*/ <-0.16418,14.26443,3.95851>,
    /*1*/ <-0.16346,14.26481,3.95619>,<-0.1636,14.26604,3.96026>,<-0.16549,14.26243,3.95907>,
            
    /*2*/ <-0.63022,14.54112,3.85942>

    /* stem 0.13c0.3*/ 
    /*0*/ <0.69025,11.7308,3.64458>,
    /*1*/ <0.67943,11.69646,3.68228>,<0.65887,11.7717,3.63677>,<0.73246,11.72426,3.61468>,
            
    /*2*/ <0.84515,11.86377,3.87506>,<0.82664,11.93148,3.83411>,<0.89288,11.88879,3.81422>,
            
    /*3*/ <1.016,12.07478,4.03071>,<0.99215,12.12735,3.98728>,<1.05238,12.09115,3.97048>,
            
    /*4*/ <1.14811,12.30741,4.17948>,<1.12427,12.34871,4.13798>,<1.18108,12.32292,4.12783>,
            
    /*5*/ <1.28904,12.54808,4.30778>,<1.26722,12.58141,4.27106>,<1.31532,12.55836,4.26152>,
            
    /*6*/ <1.42984,12.78392,4.43789>,<1.41193,12.8122,4.40758>,<1.45189,12.7928,4.3995>,
            
    /*7*/ <1.51186,13.06526,4.53412>,<1.49436,13.08037,4.50637>,<1.52919,13.0714,4.50303>,
            
    /*8*/ <1.60408,13.32933,4.64971>,<1.59164,13.34284,4.6298>,<1.61744,13.33512,4.62687>,
            
    /*9*/ <1.64838,13.62432,4.72209>,<1.63918,13.62955,4.70745>,<1.65705,13.62711,4.70649>,
            
    /*10*/ <1.65425,13.9247,4.7749>,<1.64957,13.92626,4.76733>,<1.6586,13.92612,4.76711>,
            
    /*11*/ <1.66543,14.22965,4.76101>

    /* stem 0.13c0.3.0*/ 
    /*0*/ <0.7971,11.83716,3.77214>,
    /*1*/ <0.78906,11.85573,3.76339>,<0.81807,11.83635,3.77893>,<0.78418,11.81939,3.77409>,
            
    /*2*/ <0.46652,12.19482,4.8357>

    /* stem 0.13c0.3.1*/ 
    /*0*/ <0.9448,12.00515,3.92546>,
    /*1*/ <0.96163,11.99281,3.92367>,<0.93867,12.01184,3.94433>,<0.9341,12.01079,3.90836>,
            
    /*2*/ <1.58719,12.89703,3.81768>

    /* stem 0.13c0.3.2*/ 
    /*0*/ <1.0862,12.21298,4.07291>,
    /*1*/ <1.07001,12.21483,4.08405>,<1.09343,12.22865,4.06333>,<1.09515,12.19546,4.07135>,
            
    /*2*/ <1.67578,12.44123,4.89148>

    /* stem 0.13c0.3.3*/ 
    /*0*/ <1.20197,12.41249,4.19644>,
    /*1*/ <1.20846,12.41792,4.17982>,<1.21364,12.41068,4.21088>,<1.1838,12.40886,4.19863>,
            
    /*2*/ <1.0459,13.34022,4.43867>

    /* stem 0.13c0.3.4*/ 
    /*0*/ <1.33306,12.63326,4.32089>,
    /*1*/ <1.33748,12.62289,4.33424>,<1.32602,12.64895,4.32397>,<1.33567,12.62793,4.30446>,
            
    /*2*/ <2.15783,13.00063,4.33306>

    /* stem 0.13c0.3.5*/ 
    /*0*/ <1.54445,13.16523,4.55715>,
    /*1*/ <1.53236,13.17194,4.55179>,<1.55786,13.17115,4.55486>,<1.54314,13.15259,4.56481>,
            
    /*2*/ <1.47957,13.55902,5.19597>

    /* stem 0.13c0.3.6*/ 
    /*0*/ <1.62315,13.46049,4.66824>,
    /*1*/ <1.63618,13.4593,4.6653>,<1.61938,13.46632,4.67971>,<1.6139,13.45583,4.65973>,
            
    /*2*/ <1.60745,14.05943,4.35805>

    /* stem 0.13c0.3.7*/ 
    /*0*/ <1.65113,13.77389,4.74042>,
    /*1*/ <1.6462,13.77282,4.74646>,<1.65008,13.77995,4.73552>,<1.65709,13.7689,4.73928>,
            
    /*2*/ <2.00057,14.11321,5.08564>

    /* stem 0.13c0.3.8*/ 
    /*0*/ <1.65791,14.02725,4.76685>,
    /*1*/ <1.65783,14.02716,4.76338>,<1.66048,14.02893,4.76847>,<1.65544,14.02567,4.76869>,
            
    /*2*/ <1.36706,14.47685,4.76174>

    /* stem 0.13c0.4*/ 
    /*0*/ <0.7812,12.21441,4.08791>,
    /*1*/ <0.76114,12.23796,4.06007>,<0.82243,12.21792,4.09228>,<0.76002,12.18734,4.11138>,
            
    /*2*/ <0.72577,12.43296,4.25672>,<0.78093,12.41493,4.28571>,<0.72476,12.38741,4.3029>,
            
    /*3*/ <0.69295,12.65361,4.41581>,<0.74138,12.64103,4.44448>,<0.6908,12.62025,4.46279>,
            
    /*4*/ <0.6535,12.88314,4.5668>,<0.69555,12.87385,4.59311>,<0.65126,12.85572,4.6091>,
            
    /*5*/ <0.64363,13.1376,4.67271>,<0.67967,13.13014,4.69543>,<0.641,13.1214,4.71273>,
            
    /*6*/ <0.59404,13.39585,4.75565>,<0.62336,13.39522,4.7766>,<0.5915,13.38485,4.78988>,
            
    /*7*/ <0.54027,13.66261,4.80624>,<0.56327,13.66435,4.82353>,<0.53758,13.6571,4.83441>,
            
    /*8*/ <0.49613,13.93428,4.85314>,<0.51346,13.93515,4.86604>,<0.49403,13.93056,4.87434>,
            
    /*9*/ <0.44695,14.20661,4.88391>,<0.45839,14.20788,4.89259>,<0.44542,14.20492,4.89814>,
            
    /*10*/ <0.40375,14.48066,4.91617>,<0.40949,14.48115,4.9205>,<0.40298,14.4798,4.92328>,
            
    /*11*/ <0.36283,14.75481,4.94992>

    /* stem 0.13c0.4.0*/ 
    /*0*/ <0.75904,12.33138,4.20281>,
    /*1*/ <0.77539,12.32854,4.20885>,<0.74552,12.33249,4.21411>,<0.75622,12.33311,4.18546>,
            
    /*2*/ <0.91375,13.39409,4.28359>

    /* stem 0.13c0.4.1*/ 
    /*0*/ <0.71959,12.5666,4.39062>,
    /*1*/ <0.70394,12.56204,4.39363>,<0.72312,12.58247,4.38734>,<0.73172,12.5553,4.3909>,
            
    /*2*/ <0.85752,12.73848,5.37>

    /* stem 0.13c0.4.2*/ 
    /*0*/ <0.68463,12.77103,4.52585>,
    /*1*/ <0.69299,12.77921,4.51538>,<0.68781,12.77232,4.54116>,<0.67311,12.76156,4.521>,
            
    /*2*/ <0.06987,13.48482,4.59303>

    /* stem 0.13c0.4.3*/ 
    /*0*/ <0.65916,13.03509,4.65562>,
    /*1*/ <0.66081,13.02975,4.66913>,<0.64886,13.04512,4.65294>,<0.66779,13.03041,4.64479>,
            
    /*2*/ <1.23048,13.67001,4.83692>

    /* stem 0.13c0.4.4*/ 
    /*0*/ <0.6259,13.27589,4.73845>,
    /*1*/ <0.61624,13.27694,4.72881>,<0.63493,13.28601,4.74021>,<0.62652,13.26471,4.74632>,
            
    /*2*/ <0.1283,13.62638,5.2749>

    /* stem 0.13c0.4.5*/ 
    /*0*/ <0.53219,13.74945,4.83536>,
    /*1*/ <0.54385,13.75118,4.83682>,<0.52447,13.75433,4.84294>,<0.52826,13.74283,4.82632>,
            
    /*2*/ <0.49796,14.31497,4.43635>

    /* stem 0.13c0.4.6*/ 
    /*0*/ <0.48562,14.0169,4.87278>,
    /*1*/ <0.47675,14.01467,4.87863>,<0.48516,14.02426,4.86482>,<0.49495,14.01177,4.8749>,
            
    /*2*/ <0.64068,14.46771,5.28028>

    /* stem 0.13c0.4.7*/ 
    /*0*/ <0.43506,14.29933,4.90118>,
    /*1*/ <0.43696,14.30033,4.89461>,<0.437,14.30383,4.90606>,<0.43122,14.29384,4.90288>,
            
    /*2*/ <-0.02886,14.5962,4.81193>

    /* stem 0.13c0.4.8*/ 
    /*0*/ <0.37369,14.68486,4.94229>,
    /*1*/ <0.37412,14.68482,4.94326>,<0.37282,14.68544,4.94211>,<0.37414,14.68432,4.94149>,
            
    /*2*/ <0.63827,15.05226,4.84188>

    /* stem 0.13c0.5*/ 
    /*0*/ <0.86867,12.6136,4.36256>,
    /*1*/ <0.8998,12.60221,4.36921>,<0.84601,12.61643,4.3875>,<0.86019,12.62217,4.33097>,
            
    /*2*/ <0.97642,12.84728,4.41335>,<0.92801,12.86008,4.42981>,<0.94078,12.86525,4.37893>,
            
    /*3*/ <1.05098,13.08986,4.47144>,<1.00764,13.1003,4.48585>,<1.01977,13.10727,4.44113>,
            
    /*4*/ <1.16348,13.3134,4.52663>,<1.128,13.32822,4.54082>,<1.13789,13.33303,4.50133>,
            
    /*5*/ <1.31128,13.52025,4.56577>,<1.28391,13.53769,4.57924>,<1.29064,13.53946,4.5448>,
            
    /*6*/ <1.46053,13.73026,4.6048>,<1.43772,13.74478,4.61606>,<1.44325,13.7462,4.58734>,
            
    /*7*/ <1.61074,13.94311,4.6173>,<1.59303,13.95538,4.62651>,<1.59597,13.95468,4.60328>,
            
    /*8*/ <1.74691,14.16596,4.62917>,<1.73305,14.17429,4.63602>,<1.7353,14.17385,4.61861>,
            
    /*9*/ <1.8691,14.39648,4.6406>,<1.85953,14.40148,4.64514>,<1.86106,14.40124,4.63353>,
            
    /*10*/ <1.97158,14.636,4.62192>,<1.96672,14.63833,4.6242>,<1.9672,14.63767,4.6184>,
            
    /*11*/ <2.0532,14.88296,4.6024>

    /* stem 0.13c0.5.0*/ 
    /*0*/ <0.90766,12.73288,4.38447>,
    /*1*/ <0.89523,12.73569,4.39124>,<0.91212,12.74143,4.37374>,<0.91561,12.72151,4.38842>,
            
    /*2*/ <1.40239,13.31074,5.05114>

    /* stem 0.13c0.5.1*/ 
    /*0*/ <0.97103,12.92787,4.42447>,
    /*1*/ <0.97674,12.92906,4.41198>,<0.97814,12.93155,4.43569>,<0.9582,12.92299,4.42574>,
            
    /*2*/ <0.62405,13.82143,4.35142>

    /* stem 0.13c0.5.2*/ 
    /*0*/ <1.2055,13.40998,4.53946>,
    /*1*/ <1.20826,13.40583,4.55045>,<1.20309,13.42169,4.53788>,<1.20516,13.40243,4.53007>,
            
    /*2*/ <2.00821,13.55569,4.39304>

    /* stem 0.13c0.5.3*/ 
    /*0*/ <1.34436,13.59966,4.57602>,
    /*1*/ <1.33669,13.60623,4.57092>,<1.35511,13.59975,4.57251>,<1.34128,13.593,4.58463>,
            
    /*2*/ <1.50178,14.16892,5.07281>

    /* stem 0.13c0.5.4*/ 
    /*0*/ <1.54661,13.87755,4.61117>,
    /*1*/ <1.55472,13.8718,4.60885>,<1.5468,13.88356,4.61942>,<1.53829,13.87727,4.60525>,
            
    /*2*/ <1.80131,14.39178,4.23032>

    /* stem 0.13c0.5.5*/ 
    /*0*/ <1.65511,14.03886,4.62058>,
    /*1*/ <1.65004,14.04162,4.62822>,<1.65785,14.04532,4.61405>,<1.65745,14.02963,4.61946>,
            
    /*2*/ <2.19952,14.13723,4.94633>

    /* stem 0.13c0.5.6*/ 
    /*0*/ <1.92104,14.53021,4.62974>,
    /*1*/ <1.92066,14.53,4.62485>,<1.92525,14.53161,4.63182>,<1.91719,14.52901,4.63255>,
            
    /*2*/ <1.76495,15.01307,4.62102>

    /* stem 0.13c0.5.7*/ 
    /*0*/ <2.01334,14.76738,4.61139>,
    /*1*/ <2.0144,14.7671,4.61255>,<2.0124,14.76866,4.61147>,<2.01323,14.76638,4.61016>,
            
    /*2*/ <2.31792,15.00546,4.38848>

    /* stem 0.13c0.6*/ 
    /*0*/ <1.049,13.68058,4.93311>,
    /*1*/ <1.0356,13.67951,4.93826>,<1.05312,13.69252,4.92621>,<1.05827,13.66972,4.93487>,
            
    /*2*/ <1.10147,13.7647,5.12335>,<1.11724,13.77641,5.1125>,<1.12188,13.75589,5.12029>,
            
    /*3*/ <1.14486,13.89574,5.28629>,<1.15853,13.90516,5.27524>,<1.1638,13.8895,5.28641>,
            
    /*4*/ <1.18127,14.05441,5.42568>,<1.19292,14.06147,5.41477>,<1.19807,14.04981,5.42669>,
            
    /*5*/ <1.21312,14.22873,5.54617>,<1.22294,14.23395,5.53617>,<1.22763,14.22531,5.54744>,
            
    /*6*/ <1.23712,14.42009,5.6395>,<1.24517,14.42349,5.63062>,<1.24931,14.41793,5.64097>,
            
    /*7*/ <1.21809,14.62163,5.70607>,<1.22454,14.62461,5.69907>,<1.22785,14.62194,5.70809>,
            
    /*8*/ <1.16914,14.82217,5.76044>,<1.17392,14.82477,5.75531>,<1.17627,14.82346,5.76229>,
            
    /*9*/ <1.11219,15.01953,5.82025>,<1.11532,15.02148,5.81689>,<1.11691,15.02054,5.82152>,
            
    /*10*/ <1.05299,15.2082,5.90207>,<1.05449,15.20938,5.90046>,<1.05536,15.20868,5.90269>,
            
    /*11*/ <0.97121,15.38501,5.99053>

    /* stem 0.13c0.6.0*/ 
    /*0*/ <1.07785,13.71863,5.0161>,
    /*1*/ <1.08142,13.7226,5.01303>,<1.08008,13.71562,5.02099>,<1.07205,13.71766,5.01427>,
            
    /*2*/ <0.81782,14.33547,5.51277>

    /* stem 0.13c0.6.1*/ 
    /*0*/ <1.16473,13.93751,5.31855>,
    /*1*/ <1.16544,13.93379,5.32259>,<1.16165,13.94202,5.31945>,<1.16711,13.93672,5.31362>,
            
    /*2*/ <1.76628,14.3025,5.54946>

    /* stem 0.13c0.6.2*/ 
    /*0*/ <1.20564,14.14026,5.48142>,
    /*1*/ <1.20185,14.14264,5.47894>,<1.21015,14.14258,5.48202>,<1.20491,14.13557,5.48329>,
            
    /*2*/ <0.99106,14.40661,6.06595>

    /* stem 0.13c0.6.3*/ 
    /*0*/ <1.23557,14.35044,5.60267>,
    /*1*/ <1.24025,14.34998,5.60248>,<1.23348,14.35157,5.60673>,<1.23299,14.34978,5.59879>,
            
    /*2*/ <1.28976,14.95068,5.46413>

    /* stem 0.13c0.6.4*/ 
    /*0*/ <1.20007,14.71605,5.72995>,
    /*1*/ <1.197,14.71466,5.73221>,<1.19943,14.71904,5.72728>,<1.20378,14.71446,5.73036>,
            
    /*2*/ <1.31158,15.07095,6.09939>

    /* stem 0.13c0.6.5*/ 
    /*0*/ <1.13317,14.95846,5.80059>,
    /*1*/ <1.13376,14.95958,5.79751>,<1.13459,14.95995,5.80321>,<1.13115,14.95585,5.80106>,
            
    /*2*/ <0.77191,15.24375,5.83455>

    /* stem 0.13c0.6.6*/ 
    /*0*/ <1.00692,15.30924,5.95236>,
    /*1*/ <1.00723,15.30912,5.95289>,<1.00632,15.30936,5.95238>,<1.00722,15.30923,5.95182>,
            
    /*2*/ <1.08288,15.66398,5.98971>

    /* stem 0.13c1*/ 
    /*0*/ <1.13764,11.23872,3.67813>,
    /*1*/ <1.08448,11.23636,3.66246>,<1.12697,11.28332,3.64692>,<1.1842,11.26865,3.67452>,
            <1.17708,11.21262,3.70711>,<1.11545,11.19266,3.69965>,
    /*2*/ <0.89211,11.63096,4.29887>,<0.92521,11.66755,4.28676>,<0.9698,11.65612,4.30826>,
            <0.96425,11.61247,4.33365>,<0.91624,11.59692,4.32785>,
    /*3*/ <0.70646,12.12304,4.86484>,<0.73129,12.14677,4.85281>,<0.76267,12.13983,4.86989>,
            <0.75724,12.11181,4.89247>,<0.72249,12.10143,4.88935>,
    /*4*/ <0.52769,12.68008,5.36979>,<0.54318,12.69312,5.3612>,<0.56189,12.68961,5.37221>,
            <0.55797,12.6744,5.3876>,<0.53683,12.66852,5.3861>,
    /*5*/ <0.40968,13.26842,5.85941>,<0.41516,13.27242,5.85603>,<0.42169,13.27092,5.85959>,
            <0.42024,13.26599,5.86516>,<0.41282,13.26444,5.86506>,
    /*6*/ <0.41592,13.26844,5.86105>

    /* stem 0.13c1.0*/ 
    /*0*/ <1.05898,11.39059,3.92206>,
    /*1*/ <1.04508,11.34728,3.94455>,<1.0266,11.42962,3.91996>,<1.10525,11.39489,3.90167>,
            
    /*2*/ <1.15262,11.45379,4.20474>,<1.13599,11.52789,4.18261>,<1.20677,11.49664,4.16615>,
            
    /*3*/ <1.24829,11.64965,4.43089>,<1.22618,11.70476,4.39322>,<1.29207,11.68133,4.3859>,
            
    /*4*/ <1.3303,11.87262,4.62379>,<1.30858,11.91522,4.58508>,<1.36725,11.89711,4.58112>,
            
    /*5*/ <1.39876,12.11737,4.7917>,<1.37867,12.14922,4.75478>,<1.4297,12.13601,4.75326>,
            
    /*6*/ <1.45568,12.38169,4.93131>,<1.43789,12.40391,4.89782>,<1.48087,12.39471,4.89773>,
            
    /*7*/ <1.46874,12.65884,5.05194>,<1.4541,12.67263,5.0231>,<1.48907,12.66995,5.02549>,
            
    /*8*/ <1.49537,12.94949,5.13589>,<1.48422,12.95741,5.11334>,<1.5104,12.95458,5.11483>,
            
    /*9*/ <1.49512,13.24768,5.18719>,<1.48761,13.25062,5.17158>,<1.50513,13.25039,5.173>,
            
    /*10*/ <1.45127,13.52701,5.28514>,<1.44744,13.52921,5.27754>,<1.45612,13.53021,5.27855>,
            
    /*11*/ <1.44783,13.79209,5.42618>

    /* stem 0.13c1.0.0*/ 
    /*0*/ <1.11615,11.44563,4.0634>,
    /*1*/ <1.10826,11.46523,4.05896>,<1.13606,11.44358,4.07151>,<1.10412,11.42806,4.05975>,
            
    /*2*/ <0.68426,11.51648,5.14305>

    /* stem 0.13c1.0.1*/ 
    /*0*/ <1.20874,11.58242,4.29009>,
    /*1*/ <1.22698,11.57318,4.2904>,<1.20053,11.58944,4.30746>,<1.1987,11.58465,4.2724>,
            
    /*2*/ <1.70149,12.54955,4.13247>

    /* stem 0.13c1.0.2*/ 
    /*0*/ <1.28284,11.75262,4.46948>,
    /*1*/ <1.26542,11.75146,4.47798>,<1.29114,11.76994,4.46668>,<1.29196,11.73646,4.46378>,
            
    /*2*/ <1.73913,11.68353,5.39557>

    /* stem 0.13c1.0.3*/ 
    /*0*/ <1.37088,12.02177,4.68672>,
    /*1*/ <1.37883,12.02956,4.67262>,<1.37852,12.02265,4.70295>,<1.3553,12.01311,4.68459>,
            
    /*2*/ <0.89954,12.82578,4.86514>

    /* stem 0.13c1.0.4*/ 
    /*0*/ <1.42624,12.24513,4.8275>,
    /*1*/ <1.43034,12.2366,4.84144>,<1.4157,12.25825,4.82845>,<1.43268,12.24055,4.81262>,
            
    /*2*/ <2.11249,12.78705,4.95763>

    /* stem 0.13c1.0.5*/ 
    /*0*/ <1.48596,12.83592,5.08522>,
    /*1*/ <1.4744,12.83925,5.07778>,<1.49721,12.84449,5.08503>,<1.48627,12.82401,5.09285>,
            
    /*2*/ <1.22041,13.19664,5.65906>

    /* stem 0.13c1.0.6*/ 
    /*0*/ <1.49639,13.06815,5.14296>,
    /*1*/ <1.50947,13.0684,5.14177>,<1.49064,13.07363,5.15342>,<1.48906,13.06241,5.13369>,
            
    /*2*/ <1.45514,13.65119,4.81477>

    /* stem 0.13c1.0.7*/ 
    /*0*/ <1.47888,13.35705,5.21696>,
    /*1*/ <1.47326,13.35422,5.22221>,<1.47778,13.36429,5.21328>,<1.48561,13.35265,5.2154>,
            
    /*2*/ <1.76224,13.62962,5.66783>

    /* stem 0.13c1.0.8*/ 
    /*0*/ <1.45056,13.60163,5.32073>,
    /*1*/ <1.45075,13.6034,5.31752>,<1.4529,13.60247,5.32343>,<1.44804,13.599,5.32123>,
            
    /*2*/ <1.10705,13.96704,5.50355>

    /* stem 0.13c1.1*/ 
    /*0*/ <0.87921,11.76805,4.46586>,
    /*1*/ <0.86534,11.79363,4.43864>,<0.90777,11.77946,4.49119>,<0.86453,11.73106,4.46774>,
            
    /*2*/ <0.67503,11.87623,4.61909>,<0.71322,11.86348,4.66638>,<0.6743,11.81991,4.64528>,
            
    /*3*/ <0.5216,11.99545,4.81341>,<0.55931,11.98295,4.85175>,<0.51815,11.94776,4.84101>,
            
    /*4*/ <0.38726,12.1626,4.97705>,<0.41835,12.15347,5.01288>,<0.37867,12.12638,5.00784>,
            
    /*5*/ <0.23131,12.34003,5.11045>,<0.25449,12.33561,5.14448>,<0.22161,12.31116,5.1385>,
            
    /*6*/ <0.07697,12.54112,5.20686>,<0.09379,12.54016,5.23697>,<0.06564,12.52075,5.2323>,
            
    /*7*/ <-0.04133,12.76775,5.30768>,<-0.02675,12.7654,5.33101>,<-0.05153,12.7534,5.32894>,
            
    /*8*/ <-0.15369,13.00209,5.39479>,<-0.14306,13.0009,5.41251>,<-0.16188,12.99238,5.41113>,
            
    /*9*/ <-0.26316,13.23696,5.4874>,<-0.25595,13.2359,5.49912>,<-0.26856,13.23037,5.49826>,
            
    /*10*/ <-0.35541,13.48283,5.56751>,<-0.35182,13.48236,5.57339>,<-0.35831,13.48002,5.5731>,
            
    /*11*/ <-0.45104,13.72021,5.66895>

    /* stem 0.13c1.1.0*/ 
    /*0*/ <0.7399,11.82993,4.59501>,
    /*1*/ <0.75114,11.82925,4.60746>,<0.72507,11.82227,4.59667>,<0.7435,11.83828,4.58091>,
            
    /*2*/ <0.33335,12.70653,5.01035>

    /* stem 0.13c1.1.1*/ 
    /*0*/ <0.63842,11.89203,4.70453>,
    /*1*/ <0.6255,11.88362,4.69949>,<0.63755,11.90817,4.70594>,<0.65221,11.88431,4.70817>,
            
    /*2*/ <0.32896,11.79155,5.66361>

    /* stem 0.13c1.1.2*/ 
    /*0*/ <0.29607,12.26014,5.08114>,
    /*1*/ <0.30439,12.27056,5.07683>,<0.29339,12.25851,5.0948>,<0.29044,12.25135,5.0718>,
            
    /*2*/ <-0.38879,12.77649,5.00809>

    /* stem 0.13c1.1.3*/ 
    /*0*/ <0.16028,12.42758,5.17647>,
    /*1*/ <0.15774,12.42063,5.18737>,<0.15036,12.43253,5.16936>,<0.17274,12.42959,5.17269>,
            
    /*2*/ <0.18427,13.10262,5.61263>

    /* stem 0.13c1.1.4*/ 
    /*0*/ <0.04816,12.59292,5.25046>,
    /*1*/ <0.04328,12.59516,5.23927>,<0.05272,12.60229,5.25723>,<0.04848,12.58133,5.2549>,
            
    /*2*/ <-0.62801,12.69455,5.5653>

    /* stem 0.13c1.1.5*/ 
    /*0*/ <-0.08396,12.85436,5.35516>,
    /*1*/ <-0.07467,12.85667,5.36118>,<-0.09413,12.85482,5.36006>,<-0.08306,12.85159,5.34424>,
            
    /*2*/ <-0.13628,13.50866,5.18502>

    /* stem 0.13c1.1.6*/ 
    /*0*/ <-0.31244,13.36761,5.53607>,
    /*1*/ <-0.31777,13.36538,5.53681>,<-0.31179,13.37289,5.53372>,<-0.30776,13.36454,5.5377>,
            
    /*2*/ <-0.33719,13.58817,6.02431>

    /* stem 0.13c1.1.7*/ 
    /*0*/ <-0.39544,13.5819,5.61234>,
    /*1*/ <-0.39421,13.58305,5.61075>,<-0.39561,13.58273,5.61449>,<-0.39651,13.57993,5.61177>,
            
    /*2*/ <-0.78514,13.82905,5.4871>

    /* stem 0.13c1.2*/ 
    /*0*/ <0.45118,13.10864,5.7289>,
    /*1*/ <0.45943,13.10649,5.7337>,<0.44251,13.10728,5.73323>,<0.4516,13.11214,5.71977>,
            
    /*2*/ <0.46542,13.29613,5.80624>,<0.45019,13.29684,5.80582>,<0.45837,13.30121,5.79371>,
            
    /*3*/ <0.49517,13.47656,5.89178>,<0.48178,13.47868,5.8921>,<0.48901,13.4826,5.88132>,
            
    /*4*/ <0.53355,13.65941,5.97112>,<0.52192,13.66169,5.97162>,<0.52812,13.66459,5.96193>,
            
    /*5*/ <0.59442,13.84549,6.02442>,<0.58474,13.84846,6.02526>,<0.58959,13.84942,6.01638>,
            
    /*6*/ <0.65145,14.02621,6.097>,<0.64333,14.02855,6.09765>,<0.64763,14.03007,6.0905>,
            
    /*7*/ <0.70245,14.2089,6.17008>,<0.6959,14.21058,6.17051>,<0.69936,14.21189,6.16483>,
            
    /*8*/ <0.70733,14.40441,6.22833>,<0.70225,14.40458,6.22825>,<0.7049,14.40576,6.22407>,
            
    /*9*/ <0.70699,14.59407,6.30092>,<0.7036,14.59411,6.30084>,<0.70537,14.59514,6.29814>,
            
    /*10*/ <0.73058,14.78061,6.37718>,<0.7289,14.78082,6.37722>,<0.72978,14.78127,6.37584>,
            
    /*11*/ <0.74127,14.9696,6.45102>

    /* stem 0.13c1.2.0*/ 
    /*0*/ <0.45559,13.2313,5.77619>,
    /*1*/ <0.45149,13.23123,5.77674>,<0.45734,13.23439,5.77407>,<0.45794,13.22827,5.77774>,
            
    /*2*/ <0.53897,13.63671,6.43841>

    /* stem 0.13c1.2.1*/ 
    /*0*/ <0.51176,13.58688,5.93543>,
    /*1*/ <0.51419,13.58754,5.93274>,<0.5125,13.58794,5.93888>,<0.50859,13.58516,5.93468>,
            
    /*2*/ <0.21305,14.19259,5.8135>

    /* stem 0.13c1.2.2*/ 
    /*0*/ <0.55038,13.72973,5.98785>,
    /*1*/ <0.55038,13.72876,5.99122>,<0.54858,13.73255,5.98684>,<0.5522,13.72788,5.9855>,
            
    /*2*/ <1.07079,14.10118,6.09604>

    /* stem 0.13c1.2.3*/ 
    /*0*/ <0.61295,13.92064,6.0515>,
    /*1*/ <0.61102,13.92213,6.04934>,<0.61588,13.92187,6.05218>,<0.61194,13.91792,6.05297>,
            
    /*2*/ <0.37377,14.24814,6.49073>

    /* stem 0.13c1.2.4*/ 
    /*0*/ <0.70089,14.26784,6.18571>,
    /*1*/ <0.70363,14.2676,6.18622>,<0.69928,14.2694,6.18738>,<0.69975,14.2665,6.18353>,
            
    /*2*/ <0.78913,14.67063,5.89311>

    /* stem 0.13c1.2.5*/ 
    /*0*/ <0.70495,14.45298,6.24542>,
    /*1*/ <0.7027,14.45254,6.24656>,<0.70529,14.4551,6.24402>,<0.70687,14.45129,6.24567>,
            
    /*2*/ <0.85171,14.67542,6.61899>

    /* stem 0.13c1.2.6*/ 
    /*0*/ <0.73323,14.83787,6.39917>,
    /*1*/ <0.73348,14.83809,6.39857>,<0.73347,14.83813,6.39976>,<0.73274,14.83739,6.39918>,
            
    /*2*/ <0.48168,15.09383,6.38875>

    /* stem 0.13c2*/ 
    /*0*/ <1.46839,12.06906,4.93634>,
    /*1*/ <1.4606,12.0695,4.9663>,<1.45051,12.09386,4.94122>,<1.46513,12.08395,4.90939>,
            <1.48424,12.05346,4.91481>,<1.48145,12.04452,4.94998>,
    /*2*/ <2.09209,12.49123,5.11156>,<2.08599,12.50595,5.0964>,<2.09482,12.49996,5.07717>,
            <2.10637,12.48153,5.08045>,<2.10468,12.47614,5.1017>,
    /*3*/ <2.69651,12.95313,5.24951>,<2.69411,12.95799,5.24421>,<2.69727,12.95601,5.23761>,
            <2.70164,12.94993,5.23883>,<2.70117,12.94815,5.24619>,
    /*4*/ <2.69814,12.95304,5.24327>

    /* stem 0.13.0*/ 
    /*0*/ <0.08472,9.31657,0.00499>,
    /*1*/ <0.14075,9.36569,-0.03202>,<0.10994,9.25481,0.0547>,<0.00348,9.32922,-0.0077>,
            
    /*2*/ <0.12286,9.65531,0.34392>,<0.09513,9.55552,0.42196>,<-0.00068,9.62249,0.36581>,
            
    /*3*/ <0.1051,9.99262,0.6658>,<0.07999,9.91544,0.74766>,<-0.00486,9.967,0.68908>,
            
    /*4*/ <0.09678,10.38319,0.91768>,<0.07465,10.33066,1.00089>,<0.00049,10.36671,0.9428>,
            
    /*5*/ <0.04112,10.8067,1.12206>,<0.02141,10.76921,1.19744>,<-0.04121,10.78823,1.14094>,
            
    /*6*/ <-0.031,11.23374,1.31809>,<-0.04761,11.20319,1.38119>,<-0.09939,11.21659,1.33292>,
            
    /*7*/ <-0.19137,11.64785,1.49971>,<-0.20464,11.62192,1.54944>,<-0.2438,11.62515,1.50728>,
            
    /*8*/ <-0.2622,12.07682,1.67851>,<-0.27261,12.05982,1.71687>,<-0.30337,12.06702,1.68736>,
            
    /*9*/ <-0.37,12.51521,1.82624>,<-0.37724,12.50514,1.85226>,<-0.39718,12.50721,1.83155>,
            
    /*10*/ <-0.49236,12.96186,1.92792>,<-0.49628,12.95799,1.94124>,<-0.50593,12.95778,1.93054>,
            
    /*11*/ <-0.60081,13.41235,2.03117>

    /* stem 0.13.0.0*/ 
    /*0*/ <0.07566,9.53376,0.27948>,
    /*1*/ <0.07423,9.5063,0.30116>,<0.05133,9.55887,0.28139>,<0.10143,9.53612,0.25589>,
            
    /*2*/ <1.09593,10.43094,1.48337>

    /* stem 0.13.0.1*/ 
    /*0*/ <0.07022,9.67346,0.43534>,
    /*1*/ <0.04949,9.69155,0.41514>,<0.09385,9.68936,0.45417>,<0.06733,9.63947,0.43672>,
            
    /*2*/ <-1.08704,9.82562,1.75914>

    /* stem 0.13.0.2*/ 
    /*0*/ <0.06225,9.89726,0.64391>,
    /*1*/ <0.09431,9.89299,0.64972>,<0.04075,9.89602,0.66873>,<0.0517,9.90277,0.61329>,
            
    /*2*/ <0.24095,11.56229,0.88203>

    /* stem 0.13.0.3*/ 
    /*0*/ <0.05818,10.23383,0.87425>,
    /*1*/ <0.03052,10.22608,0.88627>,<0.06274,10.26246,0.86288>,<0.08127,10.21296,0.87362>,
            
    /*2*/ <0.54329,10.72682,2.30956>

    /* stem 0.13.0.4*/ 
    /*0*/ <0.03749,10.52906,1.03261>,
    /*1*/ <0.04916,10.54173,1.0084>,<0.04304,10.54047,1.05948>,<0.02029,10.50499,1.02995>,
            
    /*2*/ <-1.18229,11.41462,0.90842>

    /* stem 0.13.0.5*/ 
    /*0*/ <-0.00834,10.88798,1.19779>,
    /*1*/ <-0.00044,10.87811,1.2228>,<-0.02953,10.90622,1.19599>,<0.00495,10.8796,1.17459>,
            
    /*2*/ <0.90541,11.96247,1.33322>

    /* stem 0.13.0.6*/ 
    /*0*/ <-0.04119,11.10046,1.29202>,
    /*1*/ <-0.0635,11.10362,1.27713>,<-0.02425,11.12121,1.29553>,<-0.03581,11.07656,1.3034>,
            
    /*2*/ <-0.73035,11.47487,2.40386>

    /* stem 0.13.0.7*/ 
    /*0*/ <-0.11478,11.36688,1.407>,
    /*1*/ <-0.09058,11.37555,1.40779>,<-0.13009,11.36963,1.42748>,<-0.12366,11.35546,1.38574>,
            
    /*2*/ <-0.50936,12.50851,0.95852>

    /* stem 0.13.0.8*/ 
    /*0*/ <-0.24812,11.86155,1.61127>,
    /*1*/ <-0.26418,11.8532,1.62597>,<-0.25095,11.88259,1.60163>,<-0.22922,11.84886,1.60621>,
            
    /*2*/ <0.31357,12.34371,2.49851>

    /* stem 0.13.0.9*/ 
    /*0*/ <-0.33935,12.32709,1.77791>,
    /*1*/ <-0.33768,12.33358,1.75899>,<-0.33317,12.33868,1.79308>,<-0.3472,12.309,1.78165>,
            
    /*2*/ <-1.28209,12.74897,1.83938>

    /* stem 0.13.0.10*/ 
    /*0*/ <-0.40605,12.60395,1.85701>,
    /*1*/ <-0.39804,12.60334,1.86955>,<-0.41915,12.61102,1.85689>,<-0.40096,12.59749,1.8446>,
            
    /*2*/ <0.0385,13.42331,1.61282>

    /* stem 0.13.0.11*/ 
    /*0*/ <-0.48245,12.89854,1.92022>,
    /*1*/ <-0.49124,12.89692,1.91716>,<-0.47791,12.90638,1.91758>,<-0.47821,12.89232,1.92592>,
            
    /*2*/ <-0.80778,13.32591,2.62868>

    /* stem 0.13.0.12*/ 
    /*0*/ <-0.53634,13.12767,1.96964>,
    /*1*/ <-0.53167,13.12913,1.9678>,<-0.53817,13.12976,1.97407>,<-0.53918,13.12413,1.96705>,
            
    /*2*/ <-0.89769,13.73626,1.53361>

    /* stem 0.13.1*/ 
    /*0*/ <0.15865,9.38201,0.20373>,
    /*1*/ <0.15115,9.30545,0.23173>,<0.11994,9.44342,0.24158>,<0.20487,9.39716,0.13787>,
            
    /*2*/ <0.52297,9.37738,0.50412>,<0.49488,9.50155,0.51298>,<0.57131,9.45992,0.41965>,
            
    /*3*/ <0.83968,9.64695,0.77132>,<0.77903,9.7403,0.74954>,<0.86375,9.71028,0.68034>,
            
    /*4*/ <1.01515,10.01619,1.02548>,<0.94627,10.07659,0.98727>,<1.03398,10.06638,0.94195>,
            
    /*5*/ <1.05736,10.42992,1.25779>,<0.99355,10.46316,1.21239>,<1.07371,10.47057,1.18486>,
            
    /*6*/ <1.09008,10.86712,1.43435>,<1.03637,10.88876,1.39345>,<1.10304,10.89332,1.36976>,
            
    /*7*/ <1.08739,11.33958,1.49969>,<1.04404,11.34505,1.46352>,<1.0974,11.34797,1.44449>,
            
    /*8*/ <1.01157,11.80535,1.50542>,<0.97978,11.80111,1.47748>,<1.01946,11.80777,1.46369>,
            
    /*9*/ <0.96629,12.26854,1.51849>,<0.94487,12.2674,1.49993>,<0.97152,12.27027,1.49067>,
            
    /*10*/ <0.91327,12.73186,1.53246>,<0.90258,12.73113,1.52318>,<0.91588,12.7328,1.51856>,
            
    /*11*/ <0.877,13.19698,1.53718>

    /* stem 0.13.1.0*/ 
    /*0*/ <0.32495,9.41081,0.32705>,
    /*1*/ <0.31393,9.44324,0.33434>,<0.35786,9.4055,0.31634>,<0.30306,9.3837,0.33048>,
            
    /*2*/ <0.85267,9.20262,2.05167>

    /* stem 0.13.1.1*/ 
    /*0*/ <0.60125,9.50703,0.54013>,
    /*1*/ <0.62695,9.49367,0.52335>,<0.60035,9.50528,0.57354>,<0.57644,9.52214,0.52348>,
            
    /*2*/ <1.44798,11.00863,0.64151>

    /* stem 0.13.1.2*/ 
    /*0*/ <0.71595,9.60445,0.63829>,
    /*1*/ <0.69784,9.5989,0.66497>,<0.72642,9.63473,0.63162>,<0.72361,9.57972,0.61828>,
            
    /*2*/ <2.11554,9.31705,1.52909>

    /* stem 0.13.1.3*/ 
    /*0*/ <0.92779,9.90677,0.88107>,
    /*1*/ <0.92867,9.92433,0.85574>,<0.95211,9.90579,0.90001>,<0.90258,9.8902,0.88748>,
            
    /*2*/ <0.33945,11.11822,1.6999>

    /* stem 0.13.1.4*/ 
    /*0*/ <1.0111,10.17082,1.05337>,
    /*1*/ <1.0295,10.15782,1.07233>,<0.99106,10.19005,1.06314>,<1.01274,10.16459,1.02465>,
            
    /*2*/ <1.9914,11.28682,0.86719>

    /* stem 0.13.1.5*/ 
    /*0*/ <1.05279,10.59246,1.27655>,
    /*1*/ <1.02594,10.59627,1.27271>,<1.07025,10.61323,1.27279>,<1.06219,10.56788,1.28415>,
            
    /*2*/ <0.91367,10.94985,2.60416>

    /* stem 0.13.1.6*/ 
    /*0*/ <1.06727,10.76997,1.35146>,
    /*1*/ <1.09034,10.77345,1.33876>,<1.06592,10.7735,1.37775>,<1.04555,10.76295,1.33787>,
            
    /*2*/ <0.76909,12.05804,1.16283>

    /* stem 0.13.1.7*/ 
    /*0*/ <1.07636,11.17592,1.44367>,
    /*1*/ <1.06782,11.17243,1.46665>,<1.0663,11.19335,1.42925>,<1.09494,11.16199,1.43512>,
            
    /*2*/ <1.89076,11.99977,1.87144>

    /* stem 0.13.1.8*/ 
    /*0*/ <1.03923,11.57895,1.47584>,
    /*1*/ <1.03178,11.57839,1.45411>,<1.05436,11.59497,1.48238>,<1.03156,11.5635,1.49103>,
            
    /*2*/ <0.18329,12.27474,1.75146>

    /* stem 0.13.1.9*/ 
    /*0*/ <0.98461,12.01104,1.49146>,
    /*1*/ <1.00253,12.0122,1.5022>,<0.96747,12.02063,1.49865>,<0.98385,12.00028,1.47353>,
            
    /*2*/ <1.24225,12.86333,0.96902>

    /* stem 0.13.1.10*/ 
    /*0*/ <0.95264,12.34472,1.50659>,
    /*1*/ <0.93789,12.34301,1.50895>,<0.95762,12.35603,1.49803>,<0.96241,12.33512,1.51279>,
            
    /*2*/ <1.0111,12.90141,2.27639>

    /* stem 0.13.1.11*/ 
    /*0*/ <0.91783,12.66517,1.52161>,
    /*1*/ <0.9239,12.66616,1.51454>,<0.91901,12.67005,1.52952>,<0.91057,12.65931,1.52076>,
            
    /*2*/ <0.43129,13.31389,1.1946>

    /* stem 0.13.1.12*/ 
    /*0*/ <0.88669,13.06269,1.53359>,
    /*1*/ <0.88666,13.06262,1.53595>,<0.88505,13.06392,1.53242>,<0.88837,13.06152,1.5324>,
            
    /*2*/ <1.34402,13.69238,1.55729>

    /* stem 0.13.2*/ 
    /*0*/ <0.28776,9.52918,0.54209>,
    /*1*/ <0.24138,9.59155,0.52529>,<0.36634,9.53889,0.54933>,<0.25555,9.45712,0.55164>,
            
    /*2*/ <0.19531,9.66648,0.96827>,<0.30778,9.61909,0.98991>,<0.20807,9.54549,0.99199>,
            
    /*3*/ <0.19693,9.90172,1.33188>,<0.29702,9.86364,1.35782>,<0.20708,9.8101,1.39223>,
            
    /*4*/ <0.19667,10.17991,1.68052>,<0.28416,10.14923,1.70695>,<0.20536,10.10575,1.74151>,
            
    /*5*/ <0.21891,10.50369,1.98786>,<0.29404,10.47826,2.01104>,<0.2268,10.44768,2.0481>,
            
    /*6*/ <0.22441,10.86317,2.25128>,<0.2871,10.84653,2.27441>,<0.23109,10.8234,2.3071>,
            
    /*7*/ <0.20768,11.2544,2.46521>,<0.25768,11.24576,2.48664>,<0.2128,11.22896,2.51381>,
            
    /*8*/ <0.24036,11.62365,2.73228>,<0.27787,11.61186,2.74499>,<0.24426,11.5998,2.76579>,
            
    /*9*/ <0.30386,12.03992,2.88325>,<0.32903,12.03326,2.89225>,<0.30727,12.03051,2.90892>,
            
    /*10*/ <0.41081,12.44908,3.04531>,<0.42315,12.44449,3.04934>,<0.41242,12.44388,3.05796>,
            
    /*11*/ <0.49419,12.862,3.20739>

    /* stem 0.13.2.0*/ 
    /*0*/ <0.24888,9.59143,0.88049>,
    /*1*/ <0.28108,9.58411,0.88554>,<0.22546,9.57843,0.90047>,<0.24009,9.61175,0.85547>,
            
    /*2*/ <0.39266,10.94874,1.93225>

    /* stem 0.13.2.1*/ 
    /*0*/ <0.2359,9.69481,1.11179>,
    /*1*/ <0.20668,9.68315,1.11919>,<0.24289,9.72582,1.11764>,<0.25814,9.67545,1.09854>,
            
    /*2*/ <0.7824,9.28629,2.62615>

    /* stem 0.13.2.2*/ 
    /*0*/ <0.23441,9.80423,1.27815>,
    /*1*/ <0.24758,9.82818,1.26252>,<0.24761,9.79361,1.3047>,<0.20806,9.7909,1.26725>,
            
    /*2*/ <-0.64794,10.84836,2.13465>

    /* stem 0.13.2.3*/ 
    /*0*/ <0.23028,10.05486,1.59989>,
    /*1*/ <0.23807,10.03271,1.61818>,<0.20632,10.07144,1.60595>,<0.24645,10.06043,1.57554>,
            
    /*2*/ <1.09454,11.01384,2.39313>

    /* stem 0.13.2.4*/ 
    /*0*/ <0.23771,10.31185,1.86368>,
    /*1*/ <0.2145,10.32336,1.85256>,<0.25908,10.32832,1.87186>,<0.23956,10.28388,1.86661>,
            
    /*2*/ <-0.33694,10.41028,3.16566>

    /* stem 0.13.2.5*/ 
    /*0*/ <0.24684,10.57566,2.08624>,
    /*1*/ <0.27342,10.57711,2.0841>,<0.23494,10.58191,2.10932>,<0.23216,10.56794,2.06531>,
            
    /*2*/ <0.14457,11.85435,1.6868>

    /* stem 0.13.2.6*/ 
    /*0*/ <0.24725,10.736,2.20043>,
    /*1*/ <0.22915,10.72532,2.2155>,<0.24528,10.76083,2.19347>,<0.26733,10.72186,2.19233>,
            
    /*2*/ <0.91786,11.08459,3.25359>

    /* stem 0.13.2.7*/ 
    /*0*/ <0.23261,11.12138,2.42418>,
    /*1*/ <0.23455,11.13262,2.40314>,<0.24642,11.12796,2.44257>,<0.21685,11.10357,2.42682>,
            
    /*2*/ <-0.59487,11.90397,2.76578>

    /* stem 0.13.2.8*/ 
    /*0*/ <0.23734,11.39104,2.59256>,
    /*1*/ <0.25037,11.37981,2.60712>,<0.2209,11.40444,2.60017>,<0.24074,11.38886,2.57039>,
            
    /*2*/ <0.94709,12.24735,2.6172>

    /* stem 0.13.2.9*/ 
    /*0*/ <0.28364,11.82221,2.82091>,
    /*1*/ <0.26441,11.82607,2.81758>,<0.29763,11.8343,2.81355>,<0.28889,11.80628,2.83161>,
            
    /*2*/ <0.24919,12.36771,3.65075>

    /* stem 0.13.2.10*/ 
    /*0*/ <0.34892,12.17772,2.94913>,
    /*1*/ <0.36033,12.17736,2.94263>,<0.34878,12.18025,2.96202>,<0.33765,12.17556,2.94274>,
            
    /*2*/ <0.27828,13.05956,2.77563>

    /* stem 0.13.2.11*/ 
    /*0*/ <0.39794,12.37522,3.02408>,
    /*1*/ <0.39438,12.37295,3.03239>,<0.39643,12.3837,3.02053>,<0.40301,12.36901,3.01933>,
            
    /*2*/ <1.10258,12.65988,3.40362>

    /* stem 0.13.2.12*/ 
    /*0*/ <0.44106,12.58112,3.10176>,
    /*1*/ <0.43952,12.58319,3.09705>,<0.44578,12.58252,3.10388>,<0.43787,12.57767,3.10434>,
            
    /*2*/ <0.09186,13.18715,3.481>

    /* stem 0.13.3*/ 
    /*0*/ <0.37239,9.65014,0.75744>,
    /*1*/ <0.44454,9.62398,0.74378>,<0.33892,9.63776,0.82674>,<0.33372,9.68867,0.70181>,
            
    /*2*/ <0.60368,10.00786,0.89359>,<0.50862,10.02027,0.96825>,<0.50394,10.06609,0.85582>,
            
    /*3*/ <0.77875,10.37837,1.05071>,<0.69523,10.39126,1.11796>,<0.69216,10.43465,1.0191>,
            
    /*4*/ <0.96489,10.73631,1.2267>,<0.89166,10.74731,1.28542>,<0.89103,10.78925,1.20074>,
            
    /*5*/ <1.14984,11.10985,1.37344>,<1.08841,11.12149,1.42494>,<1.08504,11.15254,1.3502>,
            
    /*6*/ <1.30736,11.49632,1.528>,<1.2544,11.50251,1.5694>,<1.25179,11.52846,1.50714>,
            
    /*7*/ <1.5231,11.84137,1.68378>,<1.48353,11.8511,1.71922>,<1.48222,11.874,1.67033>,
            
    /*8*/ <1.6942,12.22513,1.83185>,<1.66305,12.22991,1.85729>,<1.66113,12.2452,1.81984>,
            
    /*9*/ <1.91584,12.59524,1.9093>,<1.89762,12.60275,1.92776>,<1.89449,12.61006,1.90196>,
            
    /*10*/ <2.17741,12.93028,2.02399>,<2.1685,12.93433,2.03329>,<2.1678,12.93918,2.02071>,
            
    /*11*/ <2.40682,13.29146,2.13655>

    /* stem 0.13.3.0*/ 
    /*0*/ <0.48053,9.89798,0.85394>,
    /*1*/ <0.45797,9.89847,0.87798>,<0.48721,9.92549,0.83704>,<0.49642,9.86999,0.8468>,
            
    /*2*/ <1.68797,10.29605,1.97914>

    /* stem 0.13.3.1*/ 
    /*0*/ <0.59974,10.15453,0.95803>,
    /*1*/ <0.60386,10.16504,0.92841>,<0.62186,10.16011,0.98005>,<0.5735,10.13845,0.96564>,
            
    /*2*/ <-0.14063,11.54767,1.34913>

    /* stem 0.13.3.2*/ 
    /*0*/ <0.75626,10.46431,1.09349>,
    /*1*/ <0.76997,10.44685,1.11386>,<0.74654,10.49174,1.10128>,<0.75228,10.45434,1.06534>,
            
    /*2*/ <2.11355,11.0599,0.69072>

    /* stem 0.13.3.3*/ 
    /*0*/ <0.87009,10.67351,1.19628>,
    /*1*/ <0.84552,10.68857,1.19285>,<0.89493,10.68351,1.18509>,<0.86982,10.64844,1.21092>,
            
    /*2*/ <1.1412,11.40176,2.44847>

    /* stem 0.13.3.4*/ 
    /*0*/ <0.9717,10.86538,1.27988>,
    /*1*/ <0.995,10.85885,1.26573>,<0.97334,10.87313,1.30677>,<0.94676,10.86415,1.26714>,
            
    /*2*/ <1.1087,12.2191,0.88124>

    /* stem 0.13.3.5*/ 
    /*0*/ <1.18363,11.3049,1.45342>,
    /*1*/ <1.17252,11.30054,1.47631>,<1.18357,11.32867,1.44336>,<1.19481,11.28549,1.4406>,
            
    /*2*/ <2.30482,11.55884,2.0463>

    /* stem 0.13.3.6*/ 
    /*0*/ <1.4149,11.73025,1.63462>,
    /*1*/ <1.41082,11.74195,1.61457>,<1.4356,11.73261,1.64563>,<1.39828,11.7162,1.64365>,
            
    /*2*/ <0.98685,12.62969,2.24646>

    /* stem 0.13.3.7*/ 
    /*0*/ <1.58084,12.03652,1.76067>,
    /*1*/ <1.59689,12.02525,1.7705>,<1.57023,12.05231,1.77162>,<1.57539,12.03201,1.73991>,
            
    /*2*/ <2.3022,12.76147,1.41387>

    /* stem 0.13.3.8*/ 
    /*0*/ <1.72476,12.31689,1.85366>,
    /*1*/ <1.70742,12.32667,1.85853>,<1.73742,12.32485,1.83966>,<1.72943,12.29915,1.86279>,
            
    /*2*/ <2.20836,12.81503,2.57436>

    /* stem 0.13.3.9*/ 
    /*0*/ <1.82352,12.47556,1.88661>,
    /*1*/ <1.834,12.47206,1.87205>,<1.83094,12.4827,1.9017>,<1.80562,12.47191,1.88607>,
            
    /*2*/ <1.65462,13.35469,1.55353>

    /* stem 0.13.3.10*/ 
    /*0*/ <1.98086,12.69934,1.94591>,
    /*1*/ <1.97971,12.69591,1.95873>,<1.9784,12.71187,1.94212>,<1.98447,12.69024,1.93688>,
            
    /*2*/ <2.83389,12.90687,2.07806>

    /* stem 0.13.3.11*/ 
    /*0*/ <2.247,13.04936,2.06155>,
    /*1*/ <2.24446,13.05218,2.05787>,<2.25226,13.04971,2.06199>,<2.24428,13.0462,2.0648>,
            
    /*2*/ <2.16614,13.63664,2.56629>

    /* stem 0.13.4*/ 
    /*0*/ <0.4319,9.73518,0.90886>,
    /*1*/ <0.36776,9.71443,0.94573>,<0.44787,9.80963,0.89848>,<0.48008,9.6815,0.88238>,
            
    /*2*/ <0.58918,9.72308,1.31981>,<0.66128,9.80876,1.27729>,<0.69027,9.69345,1.2628>,
            
    /*3*/ <0.72007,9.89556,1.69129>,<0.78006,9.96662,1.63943>,<0.82133,9.87262,1.6677>,
            
    /*4*/ <0.91258,10.15693,2.00145>,<0.95405,10.20699,1.93472>,<0.9973,10.1329,1.97103>,
            
    /*5*/ <1.11288,10.47184,2.23793>,<1.14142,10.50523,2.17124>,<1.1841,10.44961,2.20947>,
            
    /*6*/ <1.28194,10.81357,2.44656>,<1.30436,10.83879,2.38921>,<1.34289,10.79792,2.42491>,
            
    /*7*/ <1.42222,11.17931,2.63429>,<1.43947,11.19773,2.58741>,<1.47205,11.16929,2.61846>,
            
    /*8*/ <1.52633,11.57015,2.793>,<1.53873,11.58214,2.75699>,<1.56445,11.56502,2.78228>,
            
    /*9*/ <1.63002,11.9593,2.95633>,<1.63835,11.96756,2.93244>,<1.65545,11.95596,2.94922>,
            
    /*10*/ <1.71008,12.36788,3.08278>,<1.71406,12.37112,3.0705>,<1.72289,12.36663,3.07939>,
            
    /*11*/ <1.84027,12.77759,3.15587>

    /* stem 0.13.4.0*/ 
    /*0*/ <0.57258,9.73949,1.15604>,
    /*1*/ <0.5883,9.76632,1.14662>,<0.58845,9.71619,1.17221>,<0.54099,9.73596,1.14929>,
            
    /*2*/ <0.1809,10.47682,2.60306>

    /* stem 0.13.4.1*/ 
    /*0*/ <0.69698,9.80877,1.43636>,
    /*1*/ <0.70414,9.78029,1.44671>,<0.68096,9.82836,1.4545>,<0.70584,9.81766,1.40786>,
            
    /*2*/ <2.06252,10.36983,2.03582>

    /* stem 0.13.4.2*/ 
    /*0*/ <0.8232,9.98096,1.74886>,
    /*1*/ <0.79978,9.99891,1.74778>,<0.85047,9.99225,1.74882>,<0.81933,9.95171,1.74997>,
            
    /*2*/ <0.80019,10.04106,3.2492>

    /* stem 0.13.4.3*/ 
    /*0*/ <0.91298,10.10708,1.89928>,
    /*1*/ <0.93854,10.10364,1.88691>,<0.91062,10.10601,1.92776>,<0.88979,10.1116,1.88316>,
            
    /*2*/ <1.14086,11.53712,1.9721>

    /* stem 0.13.4.4*/ 
    /*0*/ <1.03091,10.28906,2.06353>,
    /*1*/ <1.01733,10.28045,2.08575>,<1.0342,10.31592,2.05901>,<1.04121,10.27082,2.04581>,
            
    /*2*/ <2.2163,10.26402,2.77806>

    /* stem 0.13.4.5*/ 
    /*0*/ <1.25585,10.70438,2.34974>,
    /*1*/ <1.25235,10.71875,2.32951>,<1.27569,10.70821,2.36455>,<1.2395,10.68618,2.35516>,
            
    /*2*/ <0.58775,11.50929,3.03691>

    /* stem 0.13.4.6*/ 
    /*0*/ <1.40299,11.06941,2.5538>,
    /*1*/ <1.41985,11.05761,2.56435>,<1.38891,11.08299,2.56614>,<1.4002,11.06764,2.53091>,
            
    /*2*/ <2.11713,11.95093,2.39855>

    /* stem 0.13.4.7*/ 
    /*0*/ <1.4771,11.31087,2.6675>,
    /*1*/ <1.45577,11.31525,2.66992>,<1.49029,11.32557,2.658>,<1.48525,11.2918,2.67458>,
            
    /*2*/ <1.67696,11.75367,3.63034>

    /* stem 0.13.4.8*/ 
    /*0*/ <1.55551,11.62132,2.79863>,
    /*1*/ <1.57045,11.6235,2.78492>,<1.55909,11.62525,2.81832>,<1.537,11.6152,2.79266>,
            
    /*2*/ <1.28779,12.56963,2.65761>

    /* stem 0.13.4.9*/ 
    /*0*/ <1.6124,11.8466,2.89638>,
    /*1*/ <1.60979,11.84022,2.91261>,<1.6047,11.86169,2.8915>,<1.62272,11.8379,2.88504>,
            
    /*2*/ <2.35432,12.32513,3.20403>

    /* stem 0.13.4.10*/ 
    /*0*/ <1.68183,12.18313,3.01771>,
    /*1*/ <1.67594,12.187,3.00904>,<1.69165,12.18779,3.02033>,<1.67791,12.17459,3.02376>,
            
    /*2*/ <1.28547,12.72873,3.53075>

    /* stem 0.13.4.11*/ 
    /*0*/ <1.76437,12.52839,3.10816>,
    /*1*/ <1.76868,12.52688,3.10918>,<1.76249,12.53192,3.11059>,<1.76194,12.52636,3.10471>,
            
    /*2*/ <2.05561,13.0236,2.61199>

    /* stem 0.13.5*/ 
    /*0*/ <0.50128,9.85089,1.12408>,
    /*1*/ <0.52939,9.91021,1.08718>,<0.54548,9.8106,1.16984>,<0.42896,9.83184,1.11521>,
            
    /*2*/ <0.42022,10.15679,1.41586>,<0.4347,10.06714,1.49026>,<0.32983,10.08626,1.44108>,
            
    /*3*/ <0.31357,10.45743,1.67791>,<0.32089,10.3916,1.75855>,<0.22999,10.40301,1.70859>,
            
    /*4*/ <0.23608,10.8062,1.88693>,<0.23932,10.7609,1.96613>,<0.15997,10.76984,1.92187>,
            
    /*5*/ <0.18946,11.17884,2.07446>,<0.1916,11.14495,2.14497>,<0.12314,11.15481,2.10835>,
            
    /*6*/ <0.14574,11.57067,2.22144>,<0.14686,11.54879,2.28287>,<0.09009,11.55434,2.25125>,
            
    /*7*/ <0.14777,11.97066,2.35602>,<0.14868,11.95477,2.4057>,<0.10305,11.96304,2.38179>,
            
    /*8*/ <0.19015,12.37312,2.47921>,<0.19095,12.36217,2.51677>,<0.15687,12.37099,2.49968>,
            
    /*9*/ <0.23547,12.75601,2.66531>,<0.23549,12.74495,2.68894>,<0.21304,12.75281,2.67824>,
            
    /*10*/ <0.28221,13.13976,2.84144>,<0.28226,13.1345,2.85338>,<0.27102,13.13834,2.84799>,
            
    /*11*/ <0.35163,13.52808,2.99864>

    /* stem 0.13.5.0*/ 
    /*0*/ <0.4195,10.04503,1.37395>,
    /*1*/ <0.42862,10.02262,1.39434>,<0.39289,10.06132,1.3792>,<0.43699,10.05114,1.3483>,
            
    /*2*/ <1.2612,11.14989,2.21139>

    /* stem 0.13.5.1*/ 
    /*0*/ <0.35672,10.21571,1.54421>,
    /*1*/ <0.33273,10.22253,1.52652>,<0.37372,10.23811,1.55623>,<0.36372,10.18648,1.54988>,
            
    /*2*/ <-0.56555,10.23952,2.8044>

    /* stem 0.13.5.2*/ 
    /*0*/ <0.26239,10.53935,1.78585>,
    /*1*/ <0.29072,10.54434,1.78755>,<0.24538,10.54502,1.8084>,<0.25107,10.52867,1.76159>,
            
    /*2*/ <0.05289,11.89714,1.28629>

    /* stem 0.13.5.3*/ 
    /*0*/ <0.22154,10.73279,1.89816>,
    /*1*/ <0.20121,10.72021,1.91243>,<0.21716,10.75785,1.88684>,<0.24626,10.72031,1.89522>,
            
    /*2*/ <0.67237,11.34655,3.0816>

    /* stem 0.13.5.4*/ 
    /*0*/ <0.20062,10.8762,1.97205>,
    /*1*/ <0.20458,10.88827,1.94806>,<0.21278,10.8859,1.9943>,<0.18451,10.85442,1.9738>,
            
    /*2*/ <-0.87444,11.69001,2.20426>

    /* stem 0.13.5.5*/ 
    /*0*/ <0.15476,11.29041,2.1561>,
    /*1*/ <0.16766,11.2843,2.17685>,<0.1344,11.30514,2.15782>,<0.16221,11.2818,2.13364>,
            
    /*2*/ <0.87901,12.30886,2.00564>

    /* stem 0.13.5.6*/ 
    /*0*/ <0.1312,11.82074,2.33579>,
    /*1*/ <0.1097,11.82326,2.32882>,<0.14619,11.83757,2.33274>,<0.13771,11.80139,2.34581>,
            
    /*2*/ <-0.14367,12.24739,3.33869>

    /* stem 0.13.5.7*/ 
    /*0*/ <0.16265,12.22212,2.45615>,
    /*1*/ <0.18202,12.22218,2.44831>,<0.15862,12.23198,2.47413>,<0.14731,12.21218,2.44602>,
            
    /*2*/ <-0.04984,13.07853,1.93844>

    /* stem 0.13.5.8*/ 
    /*0*/ <0.19005,12.45306,2.53799>,
    /*1*/ <0.18023,12.44681,2.55402>,<0.18539,12.47041,2.52966>,<0.20454,12.44196,2.5303>,
            
    /*2*/ <0.83111,12.89729,3.10405>

    /* stem 0.13.5.9*/ 
    /*0*/ <0.2165,12.66087,2.63521>,
    /*1*/ <0.21358,12.6682,2.62034>,<0.23001,12.66526,2.64425>,<0.2059,12.64915,2.64105>,
            
    /*2*/ <-0.27002,13.30665,3.04901>

    /* stem 0.13.5.10*/ 
    /*0*/ <0.24256,12.86265,2.72655>,
    /*1*/ <0.2524,12.85824,2.73363>,<0.23292,12.86907,2.73221>,<0.24236,12.86062,2.71382>,
            
    /*2*/ <0.66053,13.5979,2.60286>

    /* stem 0.13.5.11*/ 
    /*0*/ <0.3171,13.34368,2.92733>,
    /*1*/ <0.3136,13.34424,2.92759>,<0.31925,13.34634,2.92634>,<0.31845,13.34048,2.92805>,
            
    /*2*/ <0.39952,13.53598,3.62493>

    /* stem 0.13.6*/ 
    /*0*/ <0.59818,10.0579,1.53079>,
    /*1*/ <0.61958,9.99426,1.55809>,<0.54846,10.09744,1.56571>,<0.6265,10.08202,1.46858>,
            
    /*2*/ <0.91304,10.18905,1.76296>,<0.84904,10.28191,1.76982>,<0.91928,10.26803,1.68241>,
            
    /*3*/ <1.19295,10.45989,1.92344>,<1.12424,10.53314,1.92273>,<1.18358,10.51918,1.84291>,
            
    /*4*/ <1.4601,10.75767,2.0316>,<1.39591,10.81766,2.02971>,<1.44318,10.80159,1.95739>,
            
    /*5*/ <1.65259,11.07058,2.21178>,<1.59128,11.11381,2.20493>,<1.6432,11.11316,2.15036>,
            
    /*6*/ <1.74722,11.40616,2.43212>,<1.69145,11.43173,2.41884>,<1.74063,11.44248,2.38135>,
            
    /*7*/ <1.73475,11.75637,2.65188>,<1.689,11.76678,2.63399>,<1.72978,11.78341,2.60986>,
            
    /*8*/ <1.70254,12.11148,2.85289>,<1.66836,12.11736,2.8382>,<1.69897,12.1302,2.8204>,
            
    /*9*/ <1.64251,12.47256,3.03571>,<1.61996,12.47473,3.02488>,<1.64033,12.48391,3.01342>,
            
    /*10*/ <1.50568,12.82506,3.19319>,<1.49501,12.82406,3.18665>,<1.50486,12.83009,3.18172>,
            
    /*11*/ <1.36436,13.18902,3.31205>

    /* stem 0.13.6.0*/ 
    /*0*/ <0.81003,10.19294,1.67957>,
    /*1*/ <0.79092,10.2159,1.68595>,<0.83793,10.19888,1.66865>,<0.80124,10.16404,1.68412>,
            
    /*2*/ <1.36715,10.25243,3.13503>

    /* stem 0.13.6.1*/ 
    /*0*/ <1.00627,10.35247,1.80345>,
    /*1*/ <1.02562,10.34457,1.78286>,<1.01548,10.35894,1.83054>,<0.97769,10.35389,1.79694>,
            
    /*2*/ <1.16786,11.78135,1.40714>

    /* stem 0.13.6.2*/ 
    /*0*/ <1.25118,10.59533,1.93115>,
    /*1*/ <1.24564,10.59025,1.95788>,<1.25241,10.6215,1.92195>,<1.25549,10.57423,1.91361>,
            
    /*2*/ <2.62321,10.63344,2.22249>

    /* stem 0.13.6.3*/ 
    /*0*/ <1.36848,10.72237,1.97957>,
    /*1*/ <1.35993,10.738,1.95929>,<1.39485,10.72073,1.98517>,<1.35067,10.70837,1.99427>,
            
    /*2*/ <1.25151,11.77141,2.83721>

    /* stem 0.13.6.4*/ 
    /*0*/ <1.53486,10.95173,2.10119>,
    /*1*/ <1.55398,10.93579,2.10745>,<1.52568,10.96821,2.11859>,<1.52493,10.95118,2.07753>,
            
    /*2*/ <2.39222,11.83086,1.72091>

    /* stem 0.13.6.5*/ 
    /*0*/ <1.65429,11.18417,2.24655>,
    /*1*/ <1.63077,11.18749,2.25197>,<1.66802,11.20311,2.23976>,<1.66408,11.1619,2.24791>,
            
    /*2*/ <1.95016,11.3853,3.40577>

    /* stem 0.13.6.6*/ 
    /*0*/ <1.72194,11.60567,2.52641>,
    /*1*/ <1.73739,11.61453,2.5133>,<1.72322,11.60828,2.54834>,<1.70522,11.59418,2.5176>,
            
    /*2*/ <1.13379,12.51985,2.45148>

    /* stem 0.13.6.7*/ 
    /*0*/ <1.70728,11.90175,2.70967>,
    /*1*/ <1.70565,11.8913,2.72732>,<1.69454,11.91745,2.70579>,<1.72165,11.89652,2.69589>,
            
    /*2*/ <2.35572,12.53575,3.14496>

    /* stem 0.13.6.8*/ 
    /*0*/ <1.68026,12.18192,2.86982>,
    /*1*/ <1.66937,12.18788,2.85524>,<1.69434,12.19308,2.87642>,<1.67706,12.16481,2.87779>,
            
    /*2*/ <1.08962,12.57208,3.47017>

    /* stem 0.13.6.9*/ 
    /*0*/ <1.65322,12.35542,2.96085>,
    /*1*/ <1.66946,12.35537,2.96577>,<1.64104,12.35973,2.97184>,<1.64917,12.35116,2.94494>,
            
    /*2*/ <1.73018,13.19782,2.71576>

    /* stem 0.13.6.10*/ 
    /*0*/ <1.54209,12.72026,3.13781>,
    /*1*/ <1.53392,12.71609,3.1401>,<1.54211,12.72912,3.13452>,<1.55023,12.71556,3.13879>,
            
    /*2*/ <1.60942,12.98966,3.86601>

    /* stem 0.13.6.11*/ 
    /*0*/ <1.3999,13.09528,3.27977>,
    /*1*/ <1.40073,13.0961,3.27831>,<1.39993,13.09611,3.28145>,<1.39903,13.09364,3.27955>,
            
    /*2*/ <0.82305,13.41786,3.13244>

    /* stem 0.13.7*/ 
    /*0*/ <0.71687,10.28671,1.99569>,
    /*1*/ <0.6602,10.3263,1.99161>,<0.77959,10.31604,1.99684>,<0.71081,10.21779,1.99864>,
            
    /*2*/ <0.65046,10.34021,2.37858>,<0.75791,10.33097,2.38329>,<0.69601,10.24254,2.3849>,
            
    /*3*/ <0.65063,10.49183,2.72197>,<0.74615,10.48416,2.72694>,<0.69057,10.41244,2.75816>,
            
    /*4*/ <0.6147,10.70463,3.03113>,<0.69759,10.70181,3.04425>,<0.64769,10.64349,3.07829>,
            
    /*5*/ <0.64581,10.99947,3.2786>,<0.71717,10.99067,3.2818>,<0.67453,10.95615,3.32839>,
            
    /*6*/ <0.67782,11.31643,3.49478>,<0.73732,11.30953,3.49773>,<0.70214,11.28463,3.53943>,
            
    /*7*/ <0.67136,11.63165,3.71536>,<0.71902,11.62992,3.72052>,<0.69066,11.60734,3.75195>,
            
    /*8*/ <0.68479,11.965,3.9119>,<0.72056,11.96243,3.9149>,<0.69931,11.94833,3.94029>,
            
    /*9*/ <0.68268,12.27622,4.14356>,<0.70652,12.27505,4.14599>,<0.6923,12.26344,4.16144>,
            
    /*10*/ <0.65413,12.62187,4.31079>,<0.66599,12.6222,4.31256>,<0.6588,12.61754,4.32095>,
            
    /*11*/ <0.6311,12.97723,4.46291>

    /* stem 0.13.7.0*/ 
    /*0*/ <0.70741,10.29767,2.23296>,
    /*1*/ <0.73663,10.30027,2.234>,<0.69367,10.2791,2.25106>,<0.69193,10.31365,2.21381>,
            
    /*2*/ <0.57451,11.38433,3.24676>

    /* stem 0.13.7.1*/ 
    /*0*/ <0.69769,10.40956,2.61676>,
    /*1*/ <0.67803,10.39174,2.62442>,<0.69615,10.43602,2.62454>,<0.7189,10.40092,2.60132>,
            
    /*2*/ <1.41816,10.11166,3.77297>

    /* stem 0.13.7.2*/ 
    /*0*/ <0.66446,10.62551,2.9685>,
    /*1*/ <0.66746,10.64673,2.95408>,<0.67558,10.62403,2.99177>,<0.65033,10.60577,2.95966>,
            
    /*2*/ <-0.39363,11.14153,3.50729>

    /* stem 0.13.7.3*/ 
    /*0*/ <0.6663,10.83327,3.17421>,
    /*1*/ <0.67985,10.8196,3.18945>,<0.64745,10.84636,3.18293>,<0.6716,10.83385,3.15024>,
            
    /*2*/ <1.41353,11.78375,3.36263>

    /* stem 0.13.7.4*/ 
    /*0*/ <0.68597,11.06427,3.35107>,
    /*1*/ <0.66364,11.06911,3.34658>,<0.70224,11.08069,3.34825>,<0.69203,11.04301,3.35838>,
            
    /*2*/ <0.53836,11.39847,4.44526>

    /* stem 0.13.7.5*/ 
    /*0*/ <0.70171,11.25461,3.47802>,
    /*1*/ <0.72202,11.25847,3.46971>,<0.69778,11.25774,3.49972>,<0.68534,11.24762,3.46462>,
            
    /*2*/ <0.42099,12.29743,3.27677>

    /* stem 0.13.7.6*/ 
    /*0*/ <0.70266,11.38564,3.56684>,
    /*1*/ <0.69311,11.37446,3.58265>,<0.6952,11.40516,3.56141>,<0.71965,11.3773,3.55648>,
            
    /*2*/ <1.35354,11.83164,4.27542>

    /* stem 0.13.7.7*/ 
    /*0*/ <0.69754,11.78749,3.82393>,
    /*1*/ <0.6929,11.79701,3.80759>,<0.71205,11.79398,3.83518>,<0.68767,11.7715,3.82903>,
            
    /*2*/ <0.08411,12.32026,4.30823>

    /* stem 0.13.7.8*/ 
    /*0*/ <0.69677,12.15262,4.06369>,
    /*1*/ <0.71004,12.14709,4.07174>,<0.6838,12.15832,4.07212>,<0.69647,12.15247,4.04721>,
            
    /*2*/ <1.02744,12.92563,4.0503>

    /* stem 0.13.7.9*/ 
    /*0*/ <0.67667,12.44673,4.23286>,
    /*1*/ <0.66635,12.44567,4.23297>,<0.68092,12.45599,4.23093>,<0.68275,12.43852,4.2347>,
            
    /*2*/ <0.66755,12.60613,4.97477>

    /* stem 0.13.7.10*/ 
    /*0*/ <0.64416,12.81395,4.3951>,
    /*1*/ <0.64648,12.81494,4.39317>,<0.64439,12.81442,4.39822>,<0.64161,12.8125,4.39389>,
            
    /*2*/ <0.34215,13.39972,4.33051>

    /* stem 0.13.8*/ 
    /*0*/ <0.88442,10.60282,2.62179>,
    /*1*/ <0.94689,10.60354,2.60443>,<0.8648,10.56506,2.67071>,<0.84157,10.63986,2.59023>,
            
    /*2*/ <1.00196,10.87195,2.83797>,<0.92808,10.83732,2.89762>,<0.90717,10.90464,2.82519>,
            
    /*3*/ <1.01195,11.17992,3.03426>,<0.94602,11.14988,3.08739>,<0.92623,11.19728,3.01368>,
            
    /*4*/ <1.01474,11.48825,3.22145>,<0.95701,11.462,3.26791>,<0.93969,11.5019,3.20243>,
            
    /*5*/ <1.01512,11.78843,3.42151>,<0.96556,11.76404,3.46011>,<0.95082,11.80051,3.4054>,
            
    /*6*/ <0.97896,12.11612,3.57232>,<0.93748,12.09739,3.6052>,<0.9257,12.11921,3.55482>,
            
    /*7*/ <0.94549,12.44376,3.71693>,<0.91225,12.4294,3.74351>,<0.90287,12.44633,3.70298>,
            
    /*8*/ <0.91857,12.74785,3.90842>,<0.89384,12.73455,3.92705>,<0.88645,12.7516,3.89895>,
            
    /*9*/ <0.89986,13.0447,4.11079>,<0.8834,13.03567,4.12312>,<0.87841,13.04779,4.10488>,
            
    /*10*/ <0.88404,13.34844,4.30305>,<0.8758,13.3442,4.30939>,<0.87332,13.34997,4.30008>,
            
    /*11*/ <0.87296,13.66107,4.48094>

    /* stem 0.13.8.0*/ 
    /*0*/ <0.91044,10.71674,2.72015>,
    /*1*/ <0.89364,10.70461,2.73864>,<0.90668,10.74341,2.71336>,<0.931,10.7022,2.70844>,
            
    /*2*/ <1.77353,11.10211,3.75724>

    /* stem 0.13.8.1*/ 
    /*0*/ <0.95744,11.09877,2.99671>,
    /*1*/ <0.95621,11.1125,2.97499>,<0.9765,11.1029,3.01348>,<0.93961,11.0809,3.00166>,
            
    /*2*/ <0.23739,11.98356,3.59667>

    /* stem 0.13.8.2*/ 
    /*0*/ <0.96669,11.35552,3.15328>,
    /*1*/ <0.98326,11.34591,3.16844>,<0.94662,11.36614,3.16227>,<0.9702,11.35451,3.12913>,
            
    /*2*/ <1.54915,12.423,3.19319>

    /* stem 0.13.8.3*/ 
    /*0*/ <0.97313,11.60324,3.30936>,
    /*1*/ <0.95018,11.60523,3.30712>,<0.9864,11.62221,3.3099>,<0.98283,11.58229,3.31105>,
            
    /*2*/ <0.86561,11.6459,4.4499>

    /* stem 0.13.8.4*/ 
    /*0*/ <0.96261,11.94389,3.50154>,
    /*1*/ <0.9807,11.94998,3.49178>,<0.95925,11.94906,3.52206>,<0.94789,11.93264,3.49077>,
            
    /*2*/ <0.49877,12.83886,3.20024>

    /* stem 0.13.8.5*/ 
    /*0*/ <0.9318,12.29954,3.65986>,
    /*1*/ <0.92575,12.29161,3.67685>,<0.92125,12.31386,3.65136>,<0.94838,12.29315,3.65135>,
            
    /*2*/ <1.43355,12.9566,4.1446>

    /* stem 0.13.8.6*/ 
    /*0*/ <0.91357,12.53815,3.78253>,
    /*1*/ <0.90644,12.54685,3.76784>,<0.92647,12.54648,3.79285>,<0.90779,12.52113,3.78691>,
            
    /*2*/ <0.27401,12.8878,4.29956>

    /* stem 0.13.8.7*/ 
    /*0*/ <0.8935,12.8918,4.01093>,
    /*1*/ <0.90795,12.88806,4.01735>,<0.88099,12.89544,4.02064>,<0.89156,12.89191,3.99479>,
            
    /*2*/ <1.10032,13.65655,3.99099>

    /* stem 0.13.8.8*/ 
    /*0*/ <0.88261,13.19065,4.20574>,
    /*1*/ <0.87304,13.18928,4.20745>,<0.88598,13.19963,4.20362>,<0.88881,13.18305,4.20616>,
            
    /*2*/ <0.9877,13.31412,4.8937>

    /* stem 0.13.8.9*/ 
    /*0*/ <0.87495,13.52992,4.407>,
    /*1*/ <0.87659,13.531,4.40513>,<0.87558,13.53011,4.40963>,<0.87268,13.52864,4.40624>,
            
    /*2*/ <0.56755,14.05804,4.44213>

    /* stem 0.13.9*/ 
    /*0*/ <1.07775,11.06291,3.40452>,
    /*1*/ <1.03948,11.02929,3.4345>,<1.07013,11.12147,3.40219>,<1.12365,11.03796,3.37688>,
            
    /*2*/ <1.22336,11.06677,3.69964>,<1.25094,11.14973,3.67056>,<1.29911,11.07456,3.64778>,
            
    /*3*/ <1.41487,11.18987,3.94547>,<1.42675,11.2588,3.90287>,<1.47861,11.19598,3.8944>,
            
    /*4*/ <1.60409,11.41642,4.11343>,<1.59804,11.46251,4.05889>,<1.65269,11.41619,4.06075>,
            
    /*5*/ <1.77821,11.68578,4.20656>,<1.76432,11.71389,4.15374>,<1.81521,11.67974,4.15791>,
            
    /*6*/ <1.88004,11.99447,4.25453>,<1.86378,12.00786,4.20788>,<1.9117,11.99111,4.21445>,
            
    /*7*/ <1.99148,12.30532,4.23891>,<1.97621,12.30951,4.20114>,<2.01453,12.29604,4.20636>,
            
    /*8*/ <2.04602,12.62092,4.26465>,<2.03496,12.62562,4.23639>,<2.06489,12.62009,4.24044>,
            
    /*9*/ <2.07795,12.93898,4.31361>,<2.07068,12.94292,4.29488>,<2.09081,12.94046,4.29774>,
            
    /*10*/ <2.04376,13.24913,4.39768>,<2.04013,13.25142,4.38839>,<2.05018,13.25202,4.39024>,
            
    /*11*/ <1.98395,13.55734,4.48074>

    /* stem 0.13.9.0*/ 
    /*0*/ <1.19163,11.08448,3.57412>,
    /*1*/ <1.19563,11.10851,3.56837>,<1.21098,11.0694,3.57904>,<1.16827,11.07554,3.57493>,
            
    /*2*/ <1.11858,11.38616,4.78476>

    /* stem 0.13.9.1*/ 
    /*0*/ <1.36685,11.16753,3.81719>,
    /*1*/ <1.37941,11.14748,3.81749>,<1.35826,11.17642,3.83737>,<1.36287,11.17869,3.79671>,
            
    /*2*/ <2.35339,11.78789,3.96347>

    /* stem 0.13.9.2*/ 
    /*0*/ <1.55524,11.35501,4.01987>,
    /*1*/ <1.53679,11.36333,4.02895>,<1.57147,11.36862,4.0133>,<1.55745,11.33309,4.01737>,
            
    /*2*/ <2.01246,11.28822,5.01022>

    /* stem 0.13.9.3*/ 
    /*0*/ <1.691,11.54512,4.11892>,
    /*1*/ <1.70126,11.54522,4.10054>,<1.70178,11.54541,4.137>,<1.66995,11.54473,4.11922>,
            
    /*2*/ <1.67161,12.57638,4.11372>

    /* stem 0.13.9.4*/ 
    /*0*/ <1.84791,11.88343,4.20577>,
    /*1*/ <1.85095,11.87921,4.22439>,<1.83684,11.89854,4.20096>,<1.85594,11.87255,4.19195>,
            
    /*2*/ <2.60464,12.43877,4.20827>

    /* stem 0.13.9.5*/ 
    /*0*/ <1.95016,12.1803,4.21956>,
    /*1*/ <1.93661,12.18477,4.2087>,<1.967,12.18448,4.21507>,<1.94686,12.17166,4.23492>,
            
    /*2*/ <1.87171,12.93634,4.62795>

    /* stem 0.13.9.6*/ 
    /*0*/ <2.02538,12.48647,4.23366>,
    /*1*/ <2.04164,12.48375,4.23297>,<2.01938,12.49818,4.24361>,<2.01512,12.47747,4.22439>,
            
    /*2*/ <2.08893,13.01276,3.6524>

    /* stem 0.13.9.7*/ 
    /*0*/ <2.06212,12.7601,4.27093>,
    /*1*/ <2.05071,12.7595,4.2809>,<2.06354,12.77209,4.26173>,<2.07212,12.74871,4.27014>,
            
    /*2*/ <2.47392,13.08789,4.76185>

    /* stem 0.13.9.8*/ 
    /*0*/ <2.06559,13.06633,4.33852>,
    /*1*/ <2.06707,13.06908,4.32963>,<2.06923,13.0713,4.34566>,<2.06048,13.05861,4.34028>,
            
    /*2*/ <1.53129,13.42512,4.36073>

    /* stem 0.13.9.9*/ 
    /*0*/ <2.0274,13.3381,4.41734>,
    /*1*/ <2.02953,13.33748,4.42093>,<2.02388,13.34044,4.41734>,<2.02879,13.33637,4.41373>,
            
    /*2*/ <2.34068,13.80924,4.3126>

    /* stem 0.13.10*/ 
    /*0*/ <1.34981,11.8163,4.58031>,
    /*1*/ <1.35023,11.84733,4.55814>,<1.38228,11.80324,4.59544>,<1.31692,11.79834,4.58734>,
            
    /*2*/ <1.31149,12.0004,4.77823>,<1.34033,11.96072,4.81179>,<1.2815,11.95631,4.80451>,
            
    /*3*/ <1.30863,12.16792,4.98812>,<1.33483,12.13263,5.01743>,<1.282,12.13249,5.01688>,
            
    /*4*/ <1.29173,12.35844,5.17466>,<1.31425,12.33163,5.20486>,<1.26811,12.32995,5.20238>,
            
    /*5*/ <1.3095,12.56736,5.34181>,<1.32906,12.54519,5.3682>,<1.28952,12.54742,5.36962>,
            
    /*6*/ <1.3807,12.78675,5.47879>,<1.39727,12.76826,5.50056>,<1.36544,12.77533,5.50576>,
            
    /*7*/ <1.43719,13.02903,5.5776>,<1.45155,13.01813,5.59691>,<1.42578,13.02266,5.60057>,
            
    /*8*/ <1.49836,13.27117,5.68338>,<1.50901,13.26251,5.69767>,<1.48974,13.26615,5.7005>,
            
    /*9*/ <1.55608,13.52027,5.7701>,<1.56338,13.51533,5.77993>,<1.55052,13.51766,5.7818>,
            
    /*10*/ <1.56289,13.77877,5.84941>,<1.56664,13.77716,5.8546>,<1.56006,13.77716,5.85516>,
            
    /*11*/ <1.58069,14.02161,5.96947>

    /* stem 0.13.10.0*/ 
    /*0*/ <1.31991,11.93696,4.74863>,
    /*1*/ <1.32996,11.92774,4.75702>,<1.30612,11.9418,4.75518>,<1.32365,11.94133,4.73368>,
            
    /*2*/ <1.78975,12.78163,5.11352>

    /* stem 0.13.10.1*/ 
    /*0*/ <1.30921,12.09718,4.95003>,
    /*1*/ <1.2943,12.09917,4.94821>,<1.31794,12.1088,4.95432>,<1.31538,12.08357,4.94758>,
            
    /*2*/ <1.16387,11.86317,5.88134>

    /* stem 0.13.10.2*/ 
    /*0*/ <1.29786,12.41699,5.25384>,
    /*1*/ <1.30969,12.42051,5.24803>,<1.29619,12.41839,5.26732>,<1.28769,12.41207,5.24618>,
            
    /*2*/ <0.99971,13.21989,5.13345>

    /* stem 0.13.10.3*/ 
    /*0*/ <1.36095,12.71392,5.45702>,
    /*1*/ <1.35713,12.70874,5.4676>,<1.35931,12.72605,5.45511>,<1.3664,12.70697,5.44833>,
            
    /*2*/ <2.05379,12.85778,5.77708>

    /* stem 0.13.10.4*/ 
    /*0*/ <1.4133,12.91577,5.54954>,
    /*1*/ <1.40872,12.92056,5.54002>,<1.42343,12.91961,5.55367>,<1.40774,12.90713,5.55493>,
            
    /*2*/ <1.06419,13.39651,5.95924>

    /* stem 0.13.10.5*/ 
    /*0*/ <1.46541,13.13218,5.63742>,
    /*1*/ <1.4748,13.12833,5.64101>,<1.45918,13.13809,5.6439>,<1.46226,13.13013,5.62733>,
            
    /*2*/ <1.7718,13.68358,5.42926>

    /* stem 0.13.10.6*/ 
    /*0*/ <1.55983,13.64387,5.81404>,
    /*1*/ <1.55424,13.64359,5.81548>,<1.56186,13.6485,5.81124>,<1.56339,13.63953,5.8154>,
            
    /*2*/ <1.66802,13.87816,6.27904>

    /* stem 0.13.10.7*/ 
    /*0*/ <1.57591,13.95499,5.93768>,
    /*1*/ <1.57652,13.95532,5.9369>,<1.57618,13.95518,5.93866>,<1.57503,13.95447,5.93747>,
            
    /*2*/ <1.34874,14.34448,5.92427>

    /* stem 0.13.11*/ 
    /*0*/ <1.56117,12.31385,5.24843>,
    /*1*/ <1.57652,12.29688,5.25719>,<1.54104,12.31983,5.26105>,<1.56595,12.32484,5.22707>,
            
    /*2*/ <1.69713,12.46808,5.37087>,<1.6652,12.48874,5.37435>,<1.68762,12.49326,5.34376>,
            
    /*3*/ <1.77432,12.65147,5.50659>,<1.74335,12.66535,5.50596>,<1.76607,12.67345,5.48207>,
            
    /*4*/ <1.85099,12.8312,5.64266>,<1.82393,12.84343,5.64221>,<1.84385,12.85069,5.62141>,
            
    /*5*/ <1.87075,13.02448,5.7859>,<1.84635,13.03039,5.78162>,<1.86456,13.03975,5.76649>,
            
    /*6*/ <1.89748,13.24021,5.88765>,<1.8771,13.24472,5.88386>,<1.8919,13.24966,5.86949>,
            
    /*7*/ <1.87819,13.4494,6.00249>,<1.86184,13.45051,5.99805>,<1.87383,13.45712,5.98801>,
            
    /*8*/ <1.85939,13.66182,6.10937>,<1.84714,13.66256,6.10599>,<1.85615,13.66722,6.09831>,
            
    /*9*/ <1.82152,13.89291,6.16172>,<1.81349,13.89228,6.15903>,<1.81963,13.89451,6.1536>,
            
    /*10*/ <1.80139,14.11084,6.25377>,<1.79732,14.111,6.2526>,<1.80034,14.11239,6.24996>,
            
    /*11*/ <1.79173,14.30945,6.38439>

    /* stem 0.13.11.0*/ 
    /*0*/ <1.6043,12.3737,5.28888>,
    /*1*/ <1.59527,12.37849,5.29142>,<1.61261,12.37941,5.28582>,<1.60502,12.3632,5.2894>,
            
    /*2*/ <1.88722,12.43682,6.17564>

    /* stem 0.13.11.1*/ 
    /*0*/ <1.71153,12.54854,5.41194>,
    /*1*/ <1.71924,12.54983,5.40579>,<1.71293,12.54878,5.42179>,<1.70242,12.54702,5.40825>,
            
    /*2*/ <1.56724,13.4118,5.41142>

    /* stem 0.13.11.2*/ 
    /*0*/ <1.84967,12.93304,5.704>,
    /*1*/ <1.8473,12.92818,5.71081>,<1.84565,12.94059,5.70243>,<1.85606,12.93034,5.69875>,
            
    /*2*/ <2.35456,13.29087,6.13486>

    /* stem 0.13.11.3*/ 
    /*0*/ <1.87332,13.12783,5.82419>,
    /*1*/ <1.86986,13.13137,5.81775>,<1.88055,13.13039,5.82684>,<1.86953,13.12172,5.82798>,
            
    /*2*/ <1.55655,13.58561,6.24618>

    /* stem 0.13.11.4*/ 
    /*0*/ <1.87883,13.36306,5.94633>,
    /*1*/ <1.88556,13.36196,5.94933>,<1.87313,13.36516,5.95064>,<1.87781,13.36207,5.93902>,
            
    /*2*/ <2.0249,13.97198,5.84332>

    /* stem 0.13.11.5*/ 
    /*0*/ <1.86644,13.51245,6.02698>,
    /*1*/ <1.85967,13.51121,6.02835>,<1.86857,13.51897,6.02549>,<1.87107,13.50719,6.02711>,
            
    /*2*/ <1.96468,13.61284,6.60387>

    /* stem 0.13.11.6*/ 
    /*0*/ <1.8079,14.01469,6.21044>,
    /*1*/ <1.80995,14.01597,6.20786>,<1.80829,14.01585,6.21376>,<1.80545,14.01224,6.2097>,
            
    /*2*/ <1.49746,14.34975,6.13005>

    /* stem 0.13.11.7*/ 
    /*0*/ <1.79742,14.16793,6.28986>,
    /*1*/ <1.79757,14.16696,6.29131>,<1.79618,14.16916,6.28976>,<1.7985,14.16766,6.28851>,
            
    /*2*/ <2.06646,14.45171,6.44881>

    /* stem 0.14*/ 
    /*0*/ <-0.02734,9.59889,-0.33072>,
    /*1*/ <0.03716,9.5907,-0.44184>,<0.02131,9.71512,-0.35714>,<-0.06177,9.67892,-0.23593>,
            <-0.09727,9.53211,-0.24571>,<-0.03613,9.47759,-0.37297>,
    /*2*/ <-0.61154,9.77262,-0.81763>,<-0.62589,9.88523,-0.74098>,<-0.70108,9.85246,-0.63128>,
            <-0.73321,9.7196,-0.64014>,<-0.67787,9.67026,-0.75531>,
    /*3*/ <-1.214,10.05238,-1.20251>,<-1.21771,10.14982,-1.12821>,<-1.29222,10.12324,-1.03456>,
            <-1.33457,10.00937,-1.05098>,<-1.28623,9.96558,-1.15478>,
    /*4*/ <-1.86925,10.32524,-1.52987>,<-1.86915,10.40962,-1.46212>,<-1.92624,10.38214,-1.37439>,
            <-1.96164,10.28078,-1.38794>,<-1.92642,10.24561,-1.48403>,
    /*5*/ <-2.56947,10.5598,-1.78495>,<-2.56787,10.63227,-1.72536>,<-2.60783,10.60468,-1.64506>,
            <-2.63413,10.51516,-1.65503>,<-2.61042,10.48742,-1.74148>,
    /*6*/ <-3.30067,10.80023,-1.92936>,<-3.29243,10.85916,-1.8767>,<-3.31642,10.83231,-1.80587>,
            <-3.33948,10.7568,-1.81475>,<-3.32975,10.73697,-1.89108>,
    /*7*/ <-3.97052,11.13209,-2.10251>,<-3.95955,11.17867,-2.0584>,<-3.98498,11.15913,-2.00177>,
            <-4.01167,11.10047,-2.01088>,<-4.00273,11.08376,-2.07314>,
    /*8*/ <-4.60562,11.55513,-2.23029>,<-4.59143,11.5881,-2.19449>,<-4.61135,11.5729,-2.15041>,
            <-4.63785,11.53054,-2.15897>,<-4.63431,11.51955,-2.20834>,
    /*9*/ <-5.23804,12.00514,-2.25868>,<-5.22452,12.02637,-2.23249>,<-5.23585,12.01336,-2.20053>,
            <-5.25639,11.9841,-2.20696>,<-5.25774,11.97902,-2.2429>,
    /*10*/ <-5.87291,12.4426,-2.287>,<-5.86494,12.45556,-2.27119>,<-5.87167,12.44762,-2.25187>,
            <-5.88381,12.42975,-2.25574>,<-5.88458,12.42665,-2.27746>,
    /*11*/ <-6.50097,12.89177,-2.28298>,<-6.49796,12.89605,-2.27751>,<-6.50011,12.89319,-2.27085>,
            <-6.50445,12.88714,-2.27219>,<-6.50498,12.88626,-2.27969>,
    /*12*/ <-6.50169,12.89088,-2.27665>

    /* stem 0.14c0*/ 
    /*0*/ <-1.91054,10.32868,-1.44767>,
    /*1*/ <-1.81904,10.32298,-1.45594>,<-1.87469,10.40997,-1.42358>,<-1.97988,10.38461,-1.42451>,
            <-1.98925,10.28196,-1.45745>,<-1.88984,10.24387,-1.47687>,
    /*2*/ <-1.88242,10.56313,-2.18631>,<-1.93068,10.63856,-2.15825>,<-2.0219,10.61657,-2.15906>,
            <-2.03002,10.52756,-2.18762>,<-1.94382,10.49453,-2.20447>,
    /*3*/ <-2.0272,10.81471,-2.91019>,<-2.06754,10.87679,-2.88132>,<-2.14382,10.85555,-2.87467>,
            <-2.15062,10.78036,-2.89943>,<-2.07855,10.75512,-2.92139>,
    /*4*/ <-2.1029,11.05413,-3.63327>,<-2.13633,11.10621,-3.61315>,<-2.19952,11.09062,-3.61272>,
            <-2.20513,11.0289,-3.63258>,<-2.14542,11.00634,-3.64528>,
    /*5*/ <-2.18592,11.30767,-4.3577>,<-2.21189,11.34794,-4.34113>,<-2.26109,11.33571,-4.34059>,
            <-2.26553,11.28789,-4.35682>,<-2.21907,11.27055,-4.36739>,
    /*6*/ <-2.34504,11.59593,-5.06027>,<-2.36322,11.62353,-5.04519>,<-2.39801,11.61363,-5.04197>,
            <-2.40135,11.57991,-5.05505>,<-2.36861,11.56897,-5.06636>,
    /*7*/ <-2.52434,11.91438,-5.74078>,<-2.53509,11.93058,-5.7306>,<-2.55603,11.92445,-5.72833>,
            <-2.55824,11.90445,-5.7371>,<-2.53865,11.89823,-5.7448>,
    /*8*/ <-2.67433,12.22152,-6.43154>,<-2.67809,12.22722,-6.42827>,<-2.68536,12.22521,-6.42771>,
            <-2.6861,12.21827,-6.43063>,<-2.67929,12.21599,-6.433>,
    /*9*/ <-2.68064,12.22164,-6.43023>

    /* stem 0.14c0c0*/ 
    /*0*/ <-2.37525,11.59639,-5.05377>,
    /*1*/ <-2.34553,11.59551,-5.04534>,<-2.36876,11.62267,-5.03885>,<-2.40095,11.61352,-5.05298>,
            <-2.39762,11.5807,-5.06819>,<-2.36337,11.56957,-5.06348>,
    /*2*/ <-2.15801,11.92594,-5.71674>,<-2.17204,11.94235,-5.71282>,<-2.19149,11.93682,-5.72135>,
            <-2.18948,11.917,-5.73055>,<-2.16878,11.91027,-5.7277>,
    /*3*/ <-1.99499,12.2761,-6.38519>,<-1.99991,12.28162,-6.38358>,<-2.00665,12.27965,-6.38639>,
            <-2.0059,12.2729,-6.38974>,<-1.9987,12.27071,-6.389>,
    /*4*/ <-2.00123,12.2762,-6.38678>

    /* stem 0.14c0c0.0*/ 
    /*0*/ <-2.05651,12.16556,-6.17642>,
    /*1*/ <-2.06624,12.16885,-6.17725>,<-2.05291,12.15841,-6.18292>,<-2.05037,12.16943,-6.1691>,
            
    /*2*/ <-2.01293,12.29556,-6.28804>,<-2.00093,12.28617,-6.29314>,<-1.99865,12.29608,-6.28071>,
            
    /*3*/ <-1.94649,12.43043,-6.38172>,<-1.93575,12.42214,-6.38618>,<-1.93437,12.42978,-6.37419>,
            
    /*4*/ <-1.85718,12.56677,-6.4524>,<-1.84799,12.55904,-6.45586>,<-1.84761,12.56458,-6.44467>,
            
    /*5*/ <-1.78334,12.71608,-6.50884>,<-1.77481,12.71061,-6.51232>,<-1.77499,12.71447,-6.50234>,
            
    /*6*/ <-1.71243,12.85988,-6.58249>,<-1.70546,12.85506,-6.58531>,<-1.70521,12.85902,-6.57731>,
            
    /*7*/ <-1.6373,13.01246,-6.63037>,<-1.63155,13.00894,-6.63272>,<-1.63183,13.0112,-6.62596>,
            
    /*8*/ <-1.57153,13.17553,-6.64448>,<-1.56693,13.17354,-6.64635>,<-1.56758,13.17426,-6.64109>,
            
    /*9*/ <-1.53082,13.34547,-6.6662>,<-1.52762,13.34455,-6.6675>,<-1.52803,13.3451,-6.66399>,
            
    /*10*/ <-1.4867,13.51648,-6.66856>,<-1.48509,13.51606,-6.66921>,<-1.48534,13.51615,-6.66745>,
            
    /*11*/ <-1.44676,13.68759,-6.65138>

    /* stem 0.14c0c0.0.0*/ 
    /*0*/ <-2.03283,12.22304,-6.22659>,
    /*1*/ <-2.03004,12.22021,-6.22851>,<-2.03144,12.22706,-6.22542>,<-2.037,12.22185,-6.22583>,
            
    /*2*/ <-2.21366,12.46457,-6.84383>

    /* stem 0.14c0c0.0.1*/ 
    /*0*/ <-1.88524,12.51039,-6.42356>,
    /*1*/ <-1.88571,12.51239,-6.42027>,<-1.8861,12.51203,-6.42696>,<-1.88391,12.50676,-6.42344>,
            
    /*2*/ <-1.32694,12.7132,-6.46763>

    /* stem 0.14c0c0.0.2*/ 
    /*0*/ <-1.82038,12.62615,-6.4747>,
    /*1*/ <-1.822,12.6257,-6.47797>,<-1.81686,12.62719,-6.47452>,<-1.82228,12.62555,-6.47161>,
            
    /*2*/ <-1.98,13.16437,-6.46913>

    /* stem 0.14c0c0.0.3*/ 
    /*0*/ <-1.75149,12.76775,-6.5355>,
    /*1*/ <-1.7485,12.76709,-6.53395>,<-1.75266,12.77097,-6.53567>,<-1.75332,12.76519,-6.53688>,
            
    /*2*/ <-1.503,12.83441,-6.98838>

    /* stem 0.14c0c0.0.4*/ 
    /*0*/ <-1.60165,13.09132,-6.63671>,
    /*1*/ <-1.60428,13.09241,-6.63618>,<-1.59994,13.09257,-6.63869>,<-1.60073,13.08898,-6.63527>,
            
    /*2*/ <-1.43476,13.34528,-6.33088>

    /* stem 0.14c0c0.0.5*/ 
    /*0*/ <-1.55239,13.24415,-6.65293>,
    /*1*/ <-1.55084,13.24352,-6.655>,<-1.5514,13.24555,-6.6509>,<-1.55494,13.24338,-6.6529>,
            
    /*2*/ <-1.65569,13.57771,-6.8317>

    /* stem 0.14c0c0.0.6*/ 
    /*0*/ <-1.47491,13.56373,-6.66369>,
    /*1*/ <-1.47491,13.56366,-6.66295>,<-1.47519,13.56435,-6.664>,<-1.47463,13.56319,-6.66412>,
            
    /*2*/ <-1.19226,13.69782,-6.65075>

    /* stem 0.14c0.0*/ 
    /*0*/ <-1.93367,10.43676,-1.77791>,
    /*1*/ <-1.98321,10.40266,-1.7856>,<-1.88684,10.43122,-1.81603>,<-1.93095,10.47639,-1.7321>,
            
    /*2*/ <-2.11018,10.64204,-1.98118>,<-2.02344,10.66774,-2.00857>,<-2.06315,10.7084,-1.93304>,
            
    /*3*/ <-2.18496,10.94452,-2.1351>,<-2.10367,10.95709,-2.15225>,<-2.13627,10.98542,-2.08018>,
            
    /*4*/ <-2.24708,11.24412,-2.27392>,<-2.17559,11.25362,-2.28817>,<-2.20385,11.27724,-2.22454>,
            
    /*5*/ <-2.31799,11.55248,-2.38273>,<-2.25727,11.56284,-2.39597>,<-2.28009,11.57765,-2.33914>,
            
    /*6*/ <-2.37227,11.84768,-2.52969>,<-2.32094,11.85328,-2.53929>,<-2.34147,11.87173,-2.49462>,
            
    /*7*/ <-2.42687,12.14394,-2.67448>,<-2.38583,12.14847,-2.68221>,<-2.40218,12.16299,-2.64634>,
            
    /*8*/ <-2.41806,12.45455,-2.80958>,<-2.38676,12.45278,-2.81275>,<-2.39928,12.46461,-2.78637>,
            
    /*9*/ <-2.40166,12.76725,-2.9283>,<-2.3808,12.76576,-2.93027>,<-2.38917,12.77298,-2.91241>,
            
    /*10*/ <-2.37392,13.08232,-3.03776>,<-2.36351,13.08128,-3.03863>,<-2.36771,13.08477,-3.02965>,
            
    /*11*/ <-2.34293,13.39948,-3.13878>

    /* stem 0.14c0.0.0*/ 
    /*0*/ <-2.0081,10.5699,-1.8887>,
    /*1*/ <-1.98501,10.57387,-1.89943>,<-2.02369,10.58985,-1.88391>,<-2.0156,10.54597,-1.88275>,
            
    /*2*/ <-2.53166,10.44243,-3.06214>

    /* stem 0.14c0.0.1*/ 
    /*0*/ <-2.11402,10.85718,-2.06868>,
    /*1*/ <-2.12703,10.86368,-2.04931>,<-2.12399,10.85783,-2.09074>,<-2.09104,10.85003,-2.06599>,
            
    /*2*/ <-1.74411,11.99642,-2.20245>

    /* stem 0.14c0.0.2*/ 
    /*0*/ <-2.18607,11.15806,-2.21489>,
    /*1*/ <-2.18875,11.14793,-2.23506>,<-2.17337,11.17683,-2.21319>,<-2.1961,11.14942,-2.19641>,
            
    /*2*/ <-3.09336,11.79,-2.41191>

    /* stem 0.14c0.0.3*/ 
    /*0*/ <-2.24223,11.39226,-2.31053>,
    /*1*/ <-2.22657,11.4006,-2.29823>,<-2.26193,11.40108,-2.31039>,<-2.23818,11.37509,-2.32299>,
            
    /*2*/ <-1.96016,12.03534,-3.10567>

    /* stem 0.14c0.0.4*/ 
    /*0*/ <-2.29921,11.63343,-2.40763>,
    /*1*/ <-2.31926,11.62963,-2.40707>,<-2.29072,11.64098,-2.4246>,<-2.28764,11.62969,-2.39123>,
            
    /*2*/ <-2.4655,12.5596,-2.07863>

    /* stem 0.14c0.0.5*/ 
    /*0*/ <-2.33016,11.7853,-2.48459>,
    /*1*/ <-2.31464,11.78252,-2.49631>,<-2.33335,11.80293,-2.47652>,<-2.3425,11.77045,-2.48093>,
            
    /*2*/ <-2.8567,12.03632,-3.24114>

    /* stem 0.14c0.0.6*/ 
    /*0*/ <-2.38959,12.07651,-2.6302>,
    /*1*/ <-2.3937,12.08372,-2.61403>,<-2.40062,12.07914,-2.64439>,<-2.37444,12.06667,-2.63217>,
            
    /*2*/ <-1.94605,12.80186,-2.84066>

    /* stem 0.14c0.0.7*/ 
    /*0*/ <-2.4027,12.34372,-2.75262>,
    /*1*/ <-2.41024,12.3377,-2.76642>,<-2.39092,12.35567,-2.754>,<-2.40695,12.33778,-2.73744>,
            
    /*2*/ <-2.97057,12.9108,-2.6898>

    /* stem 0.14c0.0.8*/ 
    /*0*/ <-2.39544,12.62771,-2.86899>,
    /*1*/ <-2.38181,12.62944,-2.8633>,<-2.40531,12.6388,-2.86815>,<-2.3992,12.61488,-2.87551>,
            
    /*2*/ <-2.1601,12.88565,-3.51152>

    /* stem 0.14c0.0.9*/ 
    /*0*/ <-2.37573,12.9786,-2.9983>,
    /*1*/ <-2.38346,12.97985,-2.99633>,<-2.37268,12.98194,-3.005>,<-2.37105,12.97402,-2.99358>,
            
    /*2*/ <-2.20622,13.49791,-2.6622>

    /* stem 0.14c0.0.10*/ 
    /*0*/ <-2.3503,13.30774,-3.10882>,
    /*1*/ <-2.34933,13.30722,-3.11018>,<-2.34992,13.30925,-3.10799>,<-2.35166,13.30677,-3.10828>,
            
    /*2*/ <-2.68831,13.58427,-3.45588>

    /* stem 0.14c0.1*/ 
    /*0*/ <-2.02797,10.69289,-2.54>,
    /*1*/ <-1.97273,10.6914,-2.55065>,<-2.05552,10.74195,-2.54104>,<-2.05567,10.64531,-2.52831>,
            
    /*2*/ <-2.03703,10.6522,-2.8489>,<-2.11153,10.6977,-2.84025>,<-2.11167,10.61072,-2.82879>,
            
    /*3*/ <-2.08062,10.69678,-3.14706>,<-2.14625,10.73645,-3.13292>,<-2.14891,10.65928,-3.14381>,
            
    /*4*/ <-2.07307,10.79945,-3.4294>,<-2.13148,10.83341,-3.41989>,<-2.13272,10.76917,-3.44284>,
            
    /*5*/ <-2.07376,10.96887,-3.68751>,<-2.12399,10.99433,-3.67174>,<-2.1248,10.94546,-3.70386>,
            
    /*6*/ <-2.06047,11.21349,-3.87118>,<-2.10266,11.23015,-3.85337>,<-2.10252,11.20084,-3.89231>,
            
    /*7*/ <-2.04759,11.47467,-4.03322>,<-2.08147,11.48653,-4.01797>,<-2.08113,11.46596,-4.05109>,
            
    /*8*/ <-2.03837,11.74671,-4.17704>,<-2.06384,11.75448,-4.16496>,<-2.06349,11.74081,-4.19081>,
            
    /*9*/ <-2.04379,12.0314,-4.29547>,<-2.06081,12.03506,-4.2867>,<-2.06054,12.02758,-4.3047>,
            
    /*10*/ <-2.0388,12.29944,-4.44556>,<-2.0473,12.30202,-4.44154>,<-2.04718,12.29726,-4.45004>,
            
    /*11*/ <-2.06443,12.56068,-4.607>

    /* stem 0.14c0.1.0*/ 
    /*0*/ <-2.07233,10.66319,-2.7659>,
    /*1*/ <-2.0901,10.67875,-2.76446>,<-2.07616,10.64166,-2.77494>,<-2.05073,10.66916,-2.7583>,
            
    /*2*/ <-1.80686,11.0657,-3.83687>

    /* stem 0.14c0.1.1*/ 
    /*0*/ <-2.09687,10.6651,-2.91873>,
    /*1*/ <-2.09369,10.64264,-2.92241>,<-2.08423,10.68052,-2.93015>,<-2.1127,10.67215,-2.90363>,
            
    /*2*/ <-2.8757,10.69022,-3.7467>

    /* stem 0.14c0.1.2*/ 
    /*0*/ <-2.1211,10.73092,-3.235>,
    /*1*/ <-2.11,10.74815,-3.22836>,<-2.13691,10.7332,-3.24947>,<-2.1164,10.7114,-3.22716>,
            
    /*2*/ <-1.42461,10.584,-4.01866>

    /* stem 0.14c0.1.3*/ 
    /*0*/ <-2.11106,10.84755,-3.50204>,
    /*1*/ <-2.13019,10.84215,-3.50595>,<-2.09795,10.85015,-3.51726>,<-2.10505,10.85036,-3.4829>,
            
    /*2*/ <-2.36803,11.80002,-3.56106>

    /* stem 0.14c0.1.4*/ 
    /*0*/ <-2.09929,11.07594,-3.76777>,
    /*1*/ <-2.08175,11.07127,-3.77218>,<-2.10327,11.09344,-3.7626>,<-2.11285,11.06312,-3.76853>,
            
    /*2*/ <-2.25774,11.29463,-4.62938>

    /* stem 0.14c0.1.5*/ 
    /*0*/ <-2.07676,11.38129,-3.97553>,
    /*1*/ <-2.08537,11.38945,-3.96334>,<-2.08129,11.38309,-3.99182>,<-2.0636,11.37131,-3.97141>,
            
    /*2*/ <-1.57294,12.01689,-4.04527>

    /* stem 0.14c0.1.6*/ 
    /*0*/ <-2.06548,11.55962,-4.07842>,
    /*1*/ <-2.06808,11.55232,-4.09251>,<-2.05301,11.56963,-4.07673>,<-2.07536,11.55691,-4.06602>,
            
    /*2*/ <-2.50492,12.14447,-4.30061>

    /* stem 0.14c0.1.7*/ 
    /*0*/ <-2.05511,11.93443,-4.25535>,
    /*1*/ <-2.04514,11.93773,-4.2474>,<-2.06485,11.94302,-4.25762>,<-2.05535,11.92255,-4.26104>,
            
    /*2*/ <-1.72009,12.17688,-4.776>

    /* stem 0.14c0.1.8*/ 
    /*0*/ <-2.0516,12.11834,-4.3443>,
    /*1*/ <-2.06103,12.11857,-4.34457>,<-2.04664,12.11953,-4.35223>,<-2.04715,12.11693,-4.33612>,
            
    /*2*/ <-2.03974,12.72605,-4.2457>

    /* stem 0.14c0.1.9*/ 
    /*0*/ <-2.05104,12.38591,-4.49905>,
    /*1*/ <-2.04814,12.38482,-4.50118>,<-2.05124,12.38947,-4.49782>,<-2.05374,12.38345,-4.49814>,
            
    /*2*/ <-2.32627,12.52368,-4.94456>

    /* stem 0.14c0.2*/ 
    /*0*/ <-2.12713,10.94221,-3.27857>,
    /*1*/ <-2.1638,10.97615,-3.26415>,<-2.13881,10.90379,-3.31163>,<-2.07877,10.94668,-3.25994>,
            
    /*2*/ <-2.09183,11.13882,-3.48274>,<-2.06934,11.07369,-3.52547>,<-2.0153,11.11229,-3.47896>,
            
    /*3*/ <-2.03457,11.32919,-3.67385>,<-2.01239,11.27811,-3.71961>,<-1.96534,11.30915,-3.6747>,
            
    /*4*/ <-2.00177,11.53765,-3.85314>,<-1.98172,11.49758,-3.89752>,<-1.94028,11.5247,-3.85847>,
            
    /*5*/ <-1.94294,11.77119,-3.99721>,<-1.92452,11.74196,-4.03878>,<-1.89069,11.75757,-3.99962>,
            
    /*6*/ <-1.90447,12.02243,-4.10855>,<-1.8881,12.00397,-4.14624>,<-1.86027,12.01469,-4.11248>,
            
    /*7*/ <-1.93666,12.27477,-4.2169>,<-1.9238,12.2634,-4.24858>,<-1.90136,12.27686,-4.22381>,
            
    /*8*/ <-1.99552,12.5265,-4.32511>,<-1.9861,12.51881,-4.34924>,<-1.9695,12.53039,-4.33133>,
            
    /*9*/ <-2.07976,12.77659,-4.41947>,<-2.0739,12.77263,-4.43604>,<-2.06291,12.78076,-4.4243>,
            
    /*10*/ <-2.15005,13.02281,-4.5396>,<-2.14682,13.02003,-4.54754>,<-2.14144,13.02438,-4.54176>,
            
    /*11*/ <-2.16717,13.26508,-4.68461>

    /* stem 0.14c0.2.0*/ 
    /*0*/ <-2.07955,11.05788,-3.42984>,
    /*1*/ <-2.07709,11.0402,-3.4426>,<-2.0646,11.07395,-3.43037>,<-2.09694,11.05951,-3.41656>,
            
    /*2*/ <-2.63423,11.5481,-4.2162>

    /* stem 0.14c0.2.1*/ 
    /*0*/ <-2.03879,11.18046,-3.56661>,
    /*1*/ <-2.0279,11.1915,-3.55229>,<-2.05442,11.18968,-3.5774>,<-2.03405,11.16019,-3.57015>,
            
    /*2*/ <-1.36544,11.46585,-4.29857>

    /* stem 0.14c0.2.2*/ 
    /*0*/ <-1.99284,11.38732,-3.75819>,
    /*1*/ <-2.01154,11.38475,-3.76431>,<-1.9782,11.38906,-3.77147>,<-1.98878,11.38816,-3.73878>,
            
    /*2*/ <-2.11988,12.34485,-3.77291>

    /* stem 0.14c0.2.3*/ 
    /*0*/ <-1.94479,11.64787,-3.94645>,
    /*1*/ <-1.9278,11.64177,-3.95001>,<-1.94741,11.66535,-3.94136>,<-1.95915,11.63648,-3.94797>,
            
    /*2*/ <-2.03942,11.8814,-4.79764>

    /* stem 0.14c0.2.4*/ 
    /*0*/ <-1.90185,11.88517,-4.06709>,
    /*1*/ <-1.91075,11.89199,-4.05408>,<-1.9059,11.88918,-4.0833>,<-1.8889,11.87435,-4.0639>,
            
    /*2*/ <-1.3782,12.51931,-4.04127>

    /* stem 0.14c0.2.5*/ 
    /*0*/ <-1.91036,12.19893,-4.19949>,
    /*1*/ <-1.91276,12.19272,-4.21362>,<-1.90158,12.21176,-4.19799>,<-1.91675,12.19232,-4.18687>,
            
    /*2*/ <-2.51271,12.62128,-4.28312>

    /* stem 0.14c0.2.6*/ 
    /*0*/ <-1.95592,12.41359,-4.28879>,
    /*1*/ <-1.94522,12.41952,-4.28094>,<-1.96924,12.41942,-4.2885>,<-1.95331,12.40184,-4.29693>,
            
    /*2*/ <-1.79149,12.81565,-4.81648>

    /* stem 0.14c0.2.7*/ 
    /*0*/ <-2.02384,12.63928,-4.37667>,
    /*1*/ <-2.03641,12.63536,-4.37526>,<-2.02019,12.64609,-4.38743>,<-2.01491,12.63638,-4.36733>,
            
    /*2*/ <-2.15704,13.17292,-4.08401>

    /* stem 0.14c0.2.8*/ 
    /*0*/ <-2.09414,12.84964,-4.46116>,
    /*1*/ <-2.08742,12.84895,-4.46689>,<-2.09549,12.85724,-4.45681>,<-2.09951,12.84273,-4.45977>,
            
    /*2*/ <-2.4319,13.02832,-4.8787>

    /* stem 0.14c0.2.9*/ 
    /*0*/ <-2.15509,13.1259,-4.60337>,
    /*1*/ <-2.15577,13.12732,-4.60084>,<-2.15683,13.12622,-4.60577>,<-2.15267,13.12415,-4.6035>,
            
    /*2*/ <-1.8857,13.50902,-4.7461>

    /* stem 0.14c0.3*/ 
    /*0*/ <-2.20711,11.23295,-4.1317>,
    /*1*/ <-2.20308,11.18899,-4.14741>,<-2.18023,11.26682,-4.14972>,<-2.23803,11.24303,-4.09797>,
            
    /*2*/ <-2.37911,11.23975,-4.32067>,<-2.35854,11.30981,-4.32275>,<-2.41056,11.28839,-4.27617>,
            
    /*3*/ <-2.57281,11.35483,-4.45863>,<-2.54347,11.41246,-4.45282>,<-2.58669,11.3934,-4.40828>,
            
    /*4*/ <-2.72998,11.53367,-4.56931>,<-2.6932,11.57493,-4.55619>,<-2.73462,11.56118,-4.51982>,
            
    /*5*/ <-2.86109,11.73112,-4.66581>,<-2.82611,11.76205,-4.65198>,<-2.86314,11.75216,-4.62195>,
            
    /*6*/ <-2.99974,11.92414,-4.75075>,<-2.97096,11.95052,-4.73969>,<-3.00056,11.94071,-4.71372>,
            
    /*7*/ <-3.15392,12.10369,-4.83409>,<-3.13231,12.12661,-4.82624>,<-3.15475,12.11738,-4.80467>,
            
    /*8*/ <-3.28082,12.31884,-4.88995>,<-3.26188,12.33231,-4.88269>,<-3.27927,12.32619,-4.86679>,
            
    /*9*/ <-3.34176,12.56113,-4.94033>,<-3.3275,12.56619,-4.93446>,<-3.34036,12.56501,-4.92463>,
            
    /*10*/ <-3.38873,12.81067,-4.9412>,<-3.38137,12.8122,-4.93814>,<-3.38767,12.81103,-4.93316>,
            
    /*11*/ <-3.41505,13.05319,-5.0023>

    /* stem 0.14c0.3.0*/ 
    /*0*/ <-2.32133,11.26311,-4.24541>,
    /*1*/ <-2.31357,11.28108,-4.24844>,<-2.34053,11.26125,-4.24085>,<-2.30991,11.24699,-4.24693>,
            
    /*2*/ <-2.53876,11.19806,-5.18755>

    /* stem 0.14c0.3.1*/ 
    /*0*/ <-2.50269,11.3491,-4.39305>,
    /*1*/ <-2.51539,11.34092,-4.38203>,<-2.50423,11.34784,-4.41165>,<-2.48844,11.35855,-4.38547>,
            
    /*2*/ <-3.00106,12.10886,-4.40334>

    /* stem 0.14c0.3.2*/ 
    /*0*/ <-2.67959,11.51218,-4.52004>,
    /*1*/ <-2.67141,11.50974,-4.53529>,<-2.68253,11.52839,-4.5142>,<-2.68482,11.49842,-4.51062>,
            
    /*2*/ <-3.42156,11.52122,-4.91958>

    /* stem 0.14c0.3.3*/ 
    /*0*/ <-2.80517,11.68255,-4.61287>,
    /*1*/ <-2.80342,11.69093,-4.59884>,<-2.82007,11.68082,-4.6196>,<-2.79203,11.67591,-4.62018>,
            
    /*2*/ <-2.69734,12.34615,-5.02237>

    /* stem 0.14c0.3.4*/ 
    /*0*/ <-2.93302,11.86072,-4.69866>,
    /*1*/ <-2.9426,11.85063,-4.70518>,<-2.92701,11.87212,-4.70704>,<-2.92945,11.85942,-4.68377>,
            
    /*2*/ <-3.50044,12.28724,-4.5255>

    /* stem 0.14c0.3.5*/ 
    /*0*/ <-3.23367,12.25914,-4.86135>,
    /*1*/ <-3.22252,12.26516,-4.86401>,<-3.24205,12.26443,-4.853>,<-3.23645,12.24785,-4.86704>,
            
    /*2*/ <-3.50081,12.55391,-5.31599>

    /* stem 0.14c0.3.6*/ 
    /*0*/ <-3.30047,12.42669,-4.90239>,
    /*1*/ <-3.30873,12.4265,-4.89358>,<-3.30299,12.43206,-4.9129>,<-3.2897,12.42151,-4.90069>,
            
    /*2*/ <-3.09969,12.90939,-4.70371>

    /* stem 0.14c0.3.7*/ 
    /*0*/ <-3.3732,12.74761,-4.93637>,
    /*1*/ <-3.37296,12.74755,-4.94226>,<-3.37101,12.75219,-4.93338>,<-3.37562,12.74309,-4.93348>,
            
    /*2*/ <-3.80043,12.9644,-4.95555>

    /* stem 0.14c0.3.8*/ 
    /*0*/ <-3.40695,12.98597,-4.98429>,
    /*1*/ <-3.4062,12.98633,-4.98329>,<-3.40809,12.98657,-4.9845>,<-3.40657,12.98501,-4.98508>,
            
    /*2*/ <-3.21307,13.26638,-5.22993>

    /* stem 0.14c0.4*/ 
    /*0*/ <-2.26579,11.38244,-4.53014>,
    /*1*/ <-2.24304,11.41433,-4.52187>,<-2.30442,11.38729,-4.53945>,<-2.2499,11.34571,-4.52911>,
            
    /*2*/ <-2.18757,11.42966,-4.75285>,<-2.24281,11.40532,-4.76867>,<-2.19374,11.3679,-4.75937>,
            
    /*3*/ <-2.14478,11.50465,-4.96746>,<-2.19318,11.48407,-4.98511>,<-2.14744,11.45274,-4.98683>,
            
    /*4*/ <-2.12197,11.60829,-5.17858>,<-2.16471,11.59023,-5.19283>,<-2.12391,11.56516,-5.20077>,
            
    /*5*/ <-2.07373,11.76984,-5.33262>,<-2.10832,11.76056,-5.35381>,<-2.07261,11.74118,-5.36277>,
            
    /*6*/ <-2.05822,11.97291,-5.44876>,<-2.08708,11.96554,-5.46651>,<-2.05616,11.956,-5.47896>,
            
    /*7*/ <-2.04579,12.16325,-5.59539>,<-2.06903,12.15532,-5.60829>,<-2.04437,12.14659,-5.61752>,
            
    /*8*/ <-2.08345,12.36306,-5.71933>,<-2.10085,12.35508,-5.72747>,<-2.08266,12.35248,-5.73722>,
            
    /*9*/ <-2.11739,12.56858,-5.83329>,<-2.12907,12.56373,-5.83898>,<-2.11696,12.5621,-5.84554>,
            
    /*10*/ <-2.156,12.75557,-5.97732>,<-2.16173,12.75258,-5.97983>,<-2.15561,12.75147,-5.9829>,
            
    /*11*/ <-2.21405,12.92922,-6.13001>

    /* stem 0.14c0.4.0*/ 
    /*0*/ <-2.22481,11.39558,-4.69345>,
    /*1*/ <-2.24069,11.39179,-4.69774>,<-2.21193,11.38764,-4.70092>,<-2.22182,11.40731,-4.6817>,
            
    /*2*/ <-2.20369,12.03799,-5.33974>

    /* stem 0.14c0.4.1*/ 
    /*0*/ <-2.18248,11.44492,-4.88163>,
    /*1*/ <-2.16795,11.43808,-4.88104>,<-2.18397,11.46027,-4.88616>,<-2.19553,11.43641,-4.87768>,
            
    /*2*/ <-2.2675,11.19377,-5.70324>

    /* stem 0.14c0.4.2*/ 
    /*0*/ <-2.11428,11.66146,-5.25982>,
    /*1*/ <-2.12156,11.67096,-5.25208>,<-2.1171,11.6599,-5.27371>,<-2.10416,11.65351,-5.25367>,
            
    /*2*/ <-1.5993,12.18984,-5.42387>

    /* stem 0.14c0.4.3*/ 
    /*0*/ <-2.07245,11.90285,-5.43041>,
    /*1*/ <-2.07393,11.89668,-5.44179>,<-2.06236,11.9109,-5.42864>,<-2.08104,11.90097,-5.42081>,
            
    /*2*/ <-2.44773,12.42402,-5.66423>

    /* stem 0.14c0.4.4*/ 
    /*0*/ <-2.0579,12.08975,-5.55822>,
    /*1*/ <-2.04907,12.09427,-5.55131>,<-2.06608,12.09715,-5.56316>,<-2.05855,12.07785,-5.56017>,
            
    /*2*/ <-1.69297,12.15321,-6.06647>

    /* stem 0.14c0.4.5*/ 
    /*0*/ <-2.0712,12.25694,-5.66812>,
    /*1*/ <-2.0823,12.25526,-5.66762>,<-2.06622,12.25868,-5.67805>,<-2.06507,12.25687,-5.65869>,
            
    /*2*/ <-2.15487,12.82837,-5.60981>

    /* stem 0.14c0.4.6*/ 
    /*0*/ <-2.14468,12.68587,-5.92971>,
    /*1*/ <-2.14038,12.68446,-5.93272>,<-2.14523,12.69099,-5.92799>,<-2.14843,12.68216,-5.92843>,
            
    /*2*/ <-2.37734,12.78911,-6.31089>

    /* stem 0.14c0.4.7*/ 
    /*0*/ <-2.17637,12.81138,-6.02959>,
    /*1*/ <-2.177,12.81295,-6.02751>,<-2.17783,12.81149,-6.03184>,<-2.1743,12.80969,-6.02942>,
            
    /*2*/ <-1.92199,13.10911,-6.17875>

    /* stem 0.14c0.5*/ 
    /*0*/ <-2.34649,11.54019,-4.91622>,
    /*1*/ <-2.37812,11.53009,-4.91373>,<-2.32669,11.52729,-4.93967>,<-2.33467,11.5632,-4.89525>,
            
    /*2*/ <-2.43774,11.69273,-5.05592>,<-2.39144,11.69021,-5.07927>,<-2.39862,11.72253,-5.03929>,
            
    /*3*/ <-2.44866,11.86637,-5.20747>,<-2.40561,11.85749,-5.22149>,<-2.41296,11.88712,-5.1869>,
            
    /*4*/ <-2.47348,12.06619,-5.30421>,<-2.43646,12.06365,-5.32012>,<-2.44173,12.08059,-5.28385>,
            
    /*5*/ <-2.48778,12.26371,-5.41116>,<-2.45581,12.2597,-5.42378>,<-2.46057,12.27575,-5.3935>,
            
    /*6*/ <-2.53032,12.44056,-5.53706>,<-2.50406,12.43893,-5.54884>,<-2.50826,12.4548,-5.52513>,
            
    /*7*/ <-2.56953,12.62414,-5.66012>,<-2.54849,12.62273,-5.66947>,<-2.55175,12.63496,-5.65018>,
            
    /*8*/ <-2.6044,12.81794,-5.76796>,<-2.58866,12.81707,-5.77509>,<-2.59086,12.82511,-5.75993>,
            
    /*9*/ <-2.6258,13.02163,-5.86067>,<-2.61526,13.0208,-5.86528>,<-2.61662,13.02542,-5.8548>,
            
    /*10*/ <-2.67754,13.2292,-5.92465>,<-2.67246,13.22971,-5.92734>,<-2.67297,13.23129,-5.92182>,
            
    /*11*/ <-2.71591,13.4421,-5.98397>

    /* stem 0.14c0.5.0*/ 
    /*0*/ <-2.3843,11.63754,-5.00171>,
    /*1*/ <-2.37277,11.63517,-5.00951>,<-2.38919,11.6507,-5.00015>,<-2.39095,11.62675,-4.99547>,
            
    /*2*/ <-2.87903,11.53702,-5.7028>

    /* stem 0.14c0.5.1*/ 
    /*0*/ <-2.41653,11.79501,-5.13952>,
    /*1*/ <-2.42092,11.80312,-5.12984>,<-2.42251,11.79504,-5.15148>,<-2.40618,11.78687,-5.13724>,
            
    /*2*/ <-1.90563,12.37403,-5.39326>

    /* stem 0.14c0.5.2*/ 
    /*0*/ <-2.46063,12.18318,-5.36422>,
    /*1*/ <-2.46503,12.17767,-5.37361>,<-2.45201,12.19104,-5.36552>,<-2.46486,12.18081,-5.35351>,
            
    /*2*/ <-2.93857,12.69453,-5.43993>

    /* stem 0.14c0.5.3*/ 
    /*0*/ <-2.49675,12.37729,-5.48877>,
    /*1*/ <-2.48739,12.38193,-5.48568>,<-2.50561,12.38344,-5.49035>,<-2.49726,12.36651,-5.49029>,
            
    /*2*/ <-2.33094,12.45669,-6.10991>

    /* stem 0.14c0.5.4*/ 
    /*0*/ <-2.54066,12.55868,-5.61373>,
    /*1*/ <-2.55035,12.55828,-5.61098>,<-2.53819,12.55883,-5.6235>,<-2.53344,12.55893,-5.6067>,
            
    /*2*/ <-2.56438,13.15206,-5.6103>

    /* stem 0.14c0.5.5*/ 
    /*0*/ <-2.58058,12.74882,-5.72785>,
    /*1*/ <-2.57505,12.74607,-5.73473>,<-2.58027,12.75757,-5.72488>,<-2.58644,12.74282,-5.72395>,
            
    /*2*/ <-2.95966,12.88459,-6.08728>

    /* stem 0.14c0.5.6*/ 
    /*0*/ <-2.64267,13.11089,-5.88763>,
    /*1*/ <-2.64225,13.11254,-5.88267>,<-2.64655,13.11268,-5.89067>,<-2.63921,13.10745,-5.88955>,
            
    /*2*/ <-2.38409,13.44532,-6.02076>

    /* stem 0.14c0.5.7*/ 
    /*0*/ <-2.69928,13.3573,-5.96022>,
    /*1*/ <-2.7002,13.35687,-5.96108>,<-2.69845,13.35829,-5.96056>,<-2.69917,13.35673,-5.95902>,
            
    /*2*/ <-2.94536,13.61037,-5.81941>

    /* stem 0.14c0.6*/ 
    /*0*/ <-2.62275,12.09293,-6.13952>,
    /*1*/ <-2.6125,12.0891,-6.14326>,<-2.62479,12.10429,-6.13888>,<-2.63096,12.0854,-6.13642>,
            
    /*2*/ <-2.67548,12.08772,-6.31097>,<-2.68654,12.1014,-6.30703>,<-2.69209,12.08439,-6.30481>,
            
    /*3*/ <-2.71872,12.1605,-6.46952>,<-2.72747,12.17168,-6.4621>,<-2.73425,12.15788,-6.46659>,
            
    /*4*/ <-2.78269,12.25093,-6.61225>,<-2.78945,12.25975,-6.6037>,<-2.79583,12.24812,-6.60823>,
            
    /*5*/ <-2.86717,12.36069,-6.72836>,<-2.87175,12.36695,-6.71918>,<-2.87778,12.35758,-6.72367>,
            
    /*6*/ <-2.91184,12.50111,-6.82925>,<-2.91549,12.50581,-6.8212>,<-2.92146,12.49995,-6.8267>,
            
    /*7*/ <-2.94562,12.6467,-6.9277>,<-2.94855,12.65044,-6.92125>,<-2.95341,12.64614,-6.92594>,
            
    /*8*/ <-2.94764,12.80458,-7.01163>,<-2.94984,12.80721,-7.0067>,<-2.95358,12.80496,-7.01083>,
            
    /*9*/ <-2.96377,12.96943,-7.08096>,<-2.96522,12.97078,-7.07747>,<-2.96772,12.96936,-7.08026>,
            
    /*10*/ <-2.99911,13.14185,-7.11682>,<-2.99977,13.14211,-7.11495>,<-3.00104,13.14155,-7.11639>,
            
    /*11*/ <-3.03056,13.3153,-7.14874>

    /* stem 0.14c0.6.0*/ 
    /*0*/ <-2.65573,12.09199,-6.229>,
    /*1*/ <-2.6581,12.09623,-6.22817>,<-2.65803,12.0883,-6.2313>,<-2.65106,12.09146,-6.22752>,
            
    /*2*/ <-2.43476,12.33513,-6.83997>

    /* stem 0.14c0.6.1*/ 
    /*0*/ <-2.74882,12.19489,-6.51605>,
    /*1*/ <-2.75017,12.19108,-6.51785>,<-2.74659,12.19782,-6.51849>,<-2.74969,12.19575,-6.51181>,
            
    /*2*/ <-3.27894,12.46117,-6.67995>

    /* stem 0.14c0.6.2*/ 
    /*0*/ <-2.8131,12.28413,-6.64123>,
    /*1*/ <-2.80977,12.28662,-6.64127>,<-2.81687,12.2857,-6.64045>,<-2.81265,12.28006,-6.64197>,
            
    /*2*/ <-2.89042,12.37851,-7.20342>

    /* stem 0.14c0.6.3*/ 
    /*0*/ <-2.88371,12.39836,-6.75031>,
    /*1*/ <-2.88729,12.39833,-6.74881>,<-2.88322,12.39842,-6.75417>,<-2.88061,12.39835,-6.74796>,
            
    /*2*/ <-2.88583,12.93172,-6.7434>

    /* stem 0.14c0.6.4*/ 
    /*0*/ <-2.94989,12.74251,-6.97585>,
    /*1*/ <-2.94821,12.74122,-6.97827>,<-2.94882,12.74518,-6.97439>,<-2.95264,12.74114,-6.97489>,
            
    /*2*/ <-3.16996,12.98592,-7.25806>

    /* stem 0.14c0.6.5*/ 
    /*0*/ <-2.95686,12.87579,-7.03957>,
    /*1*/ <-2.9564,12.87698,-7.03688>,<-2.95874,12.87709,-7.04147>,<-2.95543,12.87331,-7.04036>,
            
    /*2*/ <-2.65874,13.09379,-7.18588>

    /* stem 0.14c0.6.6*/ 
    /*0*/ <-3.01065,13.20237,-7.12746>,
    /*1*/ <-3.01122,13.20219,-7.12791>,<-3.01017,13.20292,-7.12767>,<-3.01056,13.20202,-7.1268>,
            
    /*2*/ <-3.19187,13.41715,-6.98596>

    /* stem 0.14c1*/ 
    /*0*/ <-3.98589,11.13082,-2.04934>,
    /*1*/ <-4.00198,11.13039,-2.10231>,<-3.96556,11.17615,-2.07377>,<-3.95723,11.15927,-2.01147>,
            <-3.9885,11.10307,-2.00151>,<-4.01616,11.08522,-2.05765>,
    /*2*/ <-4.63666,11.51941,-1.89988>,<-4.60829,11.55507,-1.87765>,<-4.6018,11.54192,-1.82911>,
            <-4.62616,11.49813,-1.82135>,<-4.6477,11.48423,-1.86509>,
    /*3*/ <-5.26437,11.94882,-1.81486>,<-5.24478,11.97489,-1.79886>,<-5.24487,11.96862,-1.76308>,
            <-5.26451,11.93869,-1.75697>,<-5.27657,11.92645,-1.78897>,
    /*4*/ <-5.88002,12.40641,-1.73222>,<-5.8676,12.42174,-1.72262>,<-5.86783,12.41808,-1.70098>,
            <-5.88039,12.40049,-1.69721>,<-5.88793,12.39328,-1.71651>,
    /*5*/ <-6.44759,12.91483,-1.60304>,<-6.44268,12.9196,-1.59982>,<-6.44249,12.9181,-1.59241>,
            <-6.44728,12.91241,-1.59104>,<-6.45044,12.91038,-1.59762>,
    /*6*/ <-6.4461,12.91507,-1.59678>

    /* stem 0.14c1.0*/ 
    /*0*/ <-4.42571,11.39884,-1.91791>,
    /*1*/ <-4.45028,11.35886,-1.91863>,<-4.44066,11.43603,-1.94233>,<-4.38617,11.40163,-1.89277>,
            
    /*2*/ <-4.58045,11.44079,-1.71862>,<-4.5718,11.51023,-1.73995>,<-4.52275,11.47928,-1.69535>,
            
    /*3*/ <-4.70223,11.59893,-1.54646>,<-4.68375,11.65117,-1.58049>,<-4.64598,11.62851,-1.53266>,
            
    /*4*/ <-4.83653,11.79219,-1.44449>,<-4.81283,11.82899,-1.48086>,<-4.78851,11.81924,-1.43035>,
            
    /*5*/ <-4.93336,12.00452,-1.33633>,<-4.91112,12.03245,-1.36956>,<-4.88845,12.0215,-1.32779>,
            
    /*6*/ <-5.05374,12.20665,-1.25086>,<-5.03517,12.23015,-1.27833>,<-5.01844,12.22458,-1.24171>,
            
    /*7*/ <-5.16112,12.42011,-1.16521>,<-5.14555,12.43761,-1.18777>,<-5.13191,12.43279,-1.15865>,
            
    /*8*/ <-5.27277,12.61721,-1.05727>,<-5.26233,12.63237,-1.07326>,<-5.25111,12.62722,-1.05223>,
            
    /*9*/ <-5.39248,12.8089,-0.94638>,<-5.3858,12.81944,-0.95679>,<-5.37831,12.81601,-0.94278>,
            
    /*10*/ <-5.51772,13.00849,-0.85557>,<-5.5141,13.01338,-0.86096>,<-5.51073,13.01218,-0.85366>,
            
    /*11*/ <-5.60542,13.24185,-0.80999>

    /* stem 0.14c1.0.0*/ 
    /*0*/ <-4.50792,11.44714,-1.79398>,
    /*1*/ <-4.50851,11.46553,-1.80154>,<-4.50486,11.44449,-1.77451>,<-4.51038,11.43141,-1.80589>,
            
    /*2*/ <-5.46646,11.47998,-1.63909>

    /* stem 0.14c1.0.1*/ 
    /*0*/ <-4.5957,11.5237,-1.66623>,
    /*1*/ <-4.58697,11.51473,-1.65179>,<-4.61387,11.52932,-1.66439>,<-4.58626,11.52705,-1.6825>,
            
    /*2*/ <-4.30868,12.34195,-1.33147>

    /* stem 0.14c1.0.2*/ 
    /*0*/ <-4.77587,11.7626,-1.47942>,
    /*1*/ <-4.78873,11.75952,-1.49091>,<-4.77194,11.77905,-1.47487>,<-4.76693,11.74922,-1.47249>,
            
    /*2*/ <-5.33168,11.71973,-0.84589>

    /* stem 0.14c1.0.3*/ 
    /*0*/ <-4.84701,11.8855,-1.41437>,
    /*1*/ <-4.83178,11.89261,-1.41407>,<-4.85789,11.88839,-1.40189>,<-4.85136,11.87549,-1.42717>,
            
    /*2*/ <-5.1364,12.52286,-1.81448>

    /* stem 0.14c1.0.4*/ 
    /*0*/ <-5.00044,12.16355,-1.28177>,
    /*1*/ <-5.00926,12.1544,-1.27334>,<-5.00679,12.1734,-1.29152>,<-4.98526,12.16284,-1.28045>,
            
    /*2*/ <-5.02253,12.66482,-0.76055>

    /* stem 0.14c1.0.5*/ 
    /*0*/ <-5.21579,12.54754,-1.1047>,
    /*1*/ <-5.21602,12.55383,-1.11616>,<-5.21317,12.5541,-1.09371>,<-5.21817,12.5347,-1.10424>,
            
    /*2*/ <-5.81008,12.66032,-1.03049>

    /* stem 0.14c1.0.6*/ 
    /*0*/ <-5.31881,12.71254,-1.00932>,
    /*1*/ <-5.31187,12.71136,-0.9997>,<-5.33067,12.71277,-1.00813>,<-5.31389,12.7135,-1.02014>,
            
    /*2*/ <-5.30264,13.26688,-0.95293>

    /* stem 0.14c1.0.7*/ 
    /*0*/ <-5.4776,12.95546,-0.88287>,
    /*1*/ <-5.48269,12.95322,-0.8852>,<-5.47641,12.96135,-0.88332>,<-5.4737,12.9518,-0.88008>,
            
    /*2*/ <-5.70349,13.03326,-0.46496>

    /* stem 0.14c1.0.8*/ 
    /*0*/ <-5.57526,13.16564,-0.82544>,
    /*1*/ <-5.57392,13.16626,-0.82593>,<-5.57601,13.16626,-0.82424>,<-5.57583,13.16439,-0.82616>,
            
    /*2*/ <-5.78934,13.41814,-1.0898>

    /* stem 0.14c1.1*/ 
    /*0*/ <-4.79628,11.63682,-1.83853>,
    /*1*/ <-4.78108,11.66352,-1.86386>,<-4.80588,11.64776,-1.80147>,<-4.80188,11.59919,-1.85026>,
            
    /*2*/ <-5.00173,11.71624,-1.93443>,<-5.02405,11.70206,-1.87828>,<-5.02045,11.65835,-1.92219>,
            
    /*3*/ <-5.18761,11.82663,-2.01026>,<-5.21399,11.81623,-1.96293>,<-5.21768,11.78068,-2.00495>,
            
    /*4*/ <-5.3539,11.96595,-2.09499>,<-5.38071,11.95916,-2.05542>,<-5.38585,11.92981,-2.0934>,
            
    /*5*/ <-5.53895,12.10873,-2.15161>,<-5.55749,12.09982,-2.11571>,<-5.56513,12.07678,-2.14921>,
            
    /*6*/ <-5.69572,12.27878,-2.19333>,<-5.71175,12.27198,-2.16358>,<-5.72149,12.25589,-2.19247>,
            
    /*7*/ <-5.83927,12.46721,-2.20651>,<-5.85092,12.46053,-2.18242>,<-5.86147,12.45085,-2.206>,
            
    /*8*/ <-5.9714,12.66113,-2.23471>,<-5.98114,12.65746,-2.21684>,<-5.98867,12.64976,-2.2345>,
            
    /*9*/ <-6.08416,12.86258,-2.28438>,<-6.09154,12.86154,-2.27278>,<-6.09628,12.856,-2.28449>,
            
    /*10*/ <-6.19982,13.05978,-2.3486>,<-6.20366,13.05951,-2.34288>,<-6.20581,13.05638,-2.34863>,
            
    /*11*/ <-6.3043,13.27057,-2.38192>

    /* stem 0.14c1.1.0*/ 
    /*0*/ <-4.95376,11.67663,-1.89107>,
    /*1*/ <-4.95929,11.67561,-1.87526>,<-4.96357,11.67163,-1.90372>,<-4.93843,11.68265,-1.89421>,
            
    /*2*/ <-5.29673,12.51612,-1.95683>

    /* stem 0.14c1.1.1*/ 
    /*0*/ <-5.13453,11.76432,-1.9622>,
    /*1*/ <-5.13395,11.75585,-1.97566>,<-5.13828,11.77978,-1.96268>,<-5.13136,11.75734,-1.94825>,
            
    /*2*/ <-5.96409,11.56568,-1.87322>

    /* stem 0.14c1.1.2*/ 
    /*0*/ <-5.42213,11.99033,-2.0968>,
    /*1*/ <-5.41537,12.00134,-2.09057>,<-5.43564,11.98722,-2.09312>,<-5.41539,11.98245,-2.10669>,
            
    /*2*/ <-5.67867,12.45752,-2.64388>

    /* stem 0.14c1.1.3*/ 
    /*0*/ <-5.66191,12.21563,-2.16956>,
    /*1*/ <-5.67169,12.20751,-2.16703>,<-5.66293,12.22419,-2.17924>,<-5.65111,12.2152,-2.16241>,
            
    /*2*/ <-5.92925,12.6719,-1.73792>

    /* stem 0.14c1.1.4*/ 
    /*0*/ <-5.79958,12.39056,-2.19282>,
    /*1*/ <-5.79314,12.39457,-2.20216>,<-5.80413,12.39835,-2.18485>,<-5.80147,12.37875,-2.19144>,
            
    /*2*/ <-6.32475,12.43451,-2.53573>

    /* stem 0.14c1.1.5*/ 
    /*0*/ <-5.93371,12.58543,-2.21776>,
    /*1*/ <-5.93439,12.58667,-2.20681>,<-5.94228,12.58815,-2.22417>,<-5.92446,12.58146,-2.22231>,
            
    /*2*/ <-5.72914,13.11705,-2.26541>

    /* stem 0.14c1.1.6*/ 
    /*0*/ <-6.17002,13.00015,-2.32724>,
    /*1*/ <-6.17234,12.99757,-2.33105>,<-6.16809,13.00485,-2.32812>,<-6.16963,12.99804,-2.32256>,
            
    /*2*/ <-6.5676,13.18551,-2.21078>

    /* stem 0.14c1.1.7*/ 
    /*0*/ <-6.24299,13.14212,-2.36058>,
    /*1*/ <-6.24088,13.1432,-2.36013>,<-6.24498,13.14282,-2.35941>,<-6.2431,13.14034,-2.36221>,
            
    /*2*/ <-6.32071,13.41937,-2.65891>

    /* stem 0.14c1.2*/ 
    /*0*/ <-6.06049,12.57164,-1.67611>,
    /*1*/ <-6.06046,12.56835,-1.66176>,<-6.07304,12.57101,-1.68378>,<-6.04797,12.57555,-1.68279>,
            
    /*2*/ <-6.0943,12.74664,-1.62243>,<-6.10562,12.74903,-1.64225>,<-6.08306,12.75312,-1.64136>,
            
    /*3*/ <-6.14657,12.91387,-1.56534>,<-6.15684,12.91675,-1.58272>,<-6.13728,12.92239,-1.58138>,
            
    /*4*/ <-6.20564,13.07738,-1.50148>,<-6.21472,13.08014,-1.5166>,<-6.19781,13.0857,-1.5152>,
            
    /*5*/ <-6.25091,13.25813,-1.47655>,<-6.25799,13.25833,-1.49011>,<-6.24314,13.2619,-1.48918>,
            
    /*6*/ <-6.30535,13.43628,-1.46874>,<-6.31088,13.43519,-1.48018>,<-6.2987,13.43887,-1.47931>,
            
    /*7*/ <-6.35281,13.61628,-1.47474>,<-6.35708,13.61493,-1.4839>,<-6.34725,13.61754,-1.48319>,
            
    /*8*/ <-6.42693,13.78636,-1.48188>,<-6.42995,13.78481,-1.48873>,<-6.42296,13.78788,-1.48824>,
            
    /*9*/ <-6.48199,13.96312,-1.47321>,<-6.48424,13.96268,-1.47776>,<-6.47937,13.96418,-1.47745>,
            
    /*10*/ <-6.55406,14.12955,-1.43567>,<-6.55527,14.12955,-1.43791>,<-6.55292,14.13052,-1.43773>,
            
    /*11*/ <-6.58876,14.30921,-1.40372>

    /* stem 0.14c1.2.0*/ 
    /*0*/ <-6.08201,12.68482,-1.65019>,
    /*1*/ <-6.08596,12.68517,-1.65499>,<-6.07736,12.68893,-1.64967>,<-6.08271,12.68036,-1.6459>,
            
    /*2*/ <-6.50603,13.11658,-1.27055>

    /* stem 0.14c1.2.1*/ 
    /*0*/ <-6.16934,12.97966,-1.55167>,
    /*1*/ <-6.16406,12.98103,-1.55033>,<-6.1735,12.98061,-1.54803>,<-6.17045,12.97732,-1.55666>,
            
    /*2*/ <-6.25601,13.55829,-1.80276>

    /* stem 0.14c1.2.2*/ 
    /*0*/ <-6.22237,13.14629,-1.50165>,
    /*1*/ <-6.22687,13.14483,-1.49933>,<-6.22243,13.14994,-1.50545>,<-6.21781,13.1441,-1.50018>,
            
    /*2*/ <-6.14958,13.57067,-1.09429>

    /* stem 0.14c1.2.3*/ 
    /*0*/ <-6.27943,13.35335,-1.48041>,
    /*1*/ <-6.27761,13.35413,-1.48484>,<-6.27869,13.35658,-1.47687>,<-6.28198,13.34932,-1.47951>,
            
    /*2*/ <-6.73392,13.61064,-1.62105>

    /* stem 0.14c1.2.4*/ 
    /*0*/ <-6.39135,13.70555,-1.48359>,
    /*1*/ <-6.39034,13.70613,-1.47963>,<-6.39526,13.70606,-1.48481>,<-6.38846,13.70447,-1.48632>,
            
    /*2*/ <-6.30815,14.14165,-1.56813>

    /* stem 0.14c1.2.5*/ 
    /*0*/ <-6.46265,13.90177,-1.47967>,
    /*1*/ <-6.46543,13.90101,-1.48157>,<-6.46082,13.90462,-1.48035>,<-6.4617,13.89968,-1.47708>,
            
    /*2*/ <-6.69351,14.11099,-1.22608>

    /* stem 0.14c1.2.6*/ 
    /*0*/ <-6.57943,14.26096,-1.4127>,
    /*1*/ <-6.57905,14.26104,-1.41276>,<-6.57962,14.26108,-1.41238>,<-6.57963,14.26075,-1.41297>,
            
    /*2*/ <-6.65863,14.52265,-1.55683>

    /* stem 0.14c2*/ 
    /*0*/ <-5.24251,12.0016,-2.22831>,
    /*1*/ <-5.22604,12.00368,-2.25437>,<-5.2227,12.02511,-2.22523>,<-5.24674,12.01405,-2.20035>,
            <-5.26493,11.98578,-2.21411>,<-5.25213,11.97937,-2.2475>,
    /*2*/ <-5.75853,12.48439,-2.5381>,<-5.75652,12.49733,-2.5205>,<-5.77105,12.49065,-2.50546>,
            <-5.78203,12.47357,-2.51378>,<-5.7743,12.4697,-2.53395>,
    /*3*/ <-6.2283,13.03423,-2.80501>,<-6.22722,13.0383,-2.79872>,<-6.23255,13.03633,-2.79372>,
            <-6.23692,13.03104,-2.79692>,<-6.23429,13.02974,-2.80389>,
    /*4*/ <-6.23185,13.03393,-2.79965>

    /* stem 0.14.0*/ 
    /*0*/ <-0.2907,9.67313,-0.48906>,
    /*1*/ <-0.30772,9.72224,-0.43772>,<-0.33543,9.61684,-0.50203>,<-0.22894,9.68031,-0.52743>,
            
    /*2*/ <-0.50634,9.94118,-0.7234>,<-0.53128,9.84632,-0.78128>,<-0.43543,9.90344,-0.80414>,
            
    /*3*/ <-0.72626,10.18365,-0.95627>,<-0.75481,10.10512,-1.01343>,<-0.67169,10.15767,-1.03748>,
            
    /*4*/ <-0.94751,10.46107,-1.14796>,<-0.97903,10.3995,-1.20329>,<-0.90535,10.4441,-1.22399>,
            
    /*5*/ <-1.14425,10.76698,-1.33481>,<-1.17422,10.71859,-1.38505>,<-1.1078,10.7523,-1.39977>,
            
    /*6*/ <-1.32433,11.11177,-1.43018>,<-1.35643,11.08308,-1.47656>,<-1.3001,11.10927,-1.48858>,
            
    /*7*/ <-1.45891,11.47966,-1.56147>,<-1.48483,11.45767,-1.59899>,<-1.437,11.47244,-1.60653>,
            
    /*8*/ <-1.58817,11.84771,-1.69069>,<-1.60772,11.83157,-1.71895>,<-1.57171,11.84228,-1.72447>,
            
    /*9*/ <-1.72816,12.22224,-1.77566>,<-1.74186,12.21317,-1.79491>,<-1.71817,12.22113,-1.79888>,
            
    /*10*/ <-1.83241,12.60631,-1.88067>,<-1.83931,12.602,-1.89036>,<-1.8271,12.60485,-1.89206>,
            
    /*11*/ <-1.88734,13.00772,-1.94521>

    /* stem 0.14.0.0*/ 
    /*0*/ <-0.39937,9.79456,-0.64125>,
    /*1*/ <-0.41063,9.76853,-0.65398>,<-0.38934,9.81768,-0.65945>,<-0.39813,9.79747,-0.61032>,
            
    /*2*/ <-1.8589,10.42682,-0.64229>

    /* stem 0.14.0.1*/ 
    /*0*/ <-0.52487,9.93461,-0.80439>,
    /*1*/ <-0.50136,9.95307,-0.8073>,<-0.55254,9.94589,-0.80133>,<-0.52072,9.90486,-0.80454>,
            
    /*2*/ <-0.69996,9.91767,-2.32497>

    /* stem 0.14.0.2*/ 
    /*0*/ <-0.65429,10.07846,-0.93736>,
    /*1*/ <-0.67709,10.07406,-0.91993>,<-0.65825,10.08141,-0.96598>,<-0.62753,10.07991,-0.92618>,
            
    /*2*/ <-0.80457,11.53515,-0.76634>

    /* stem 0.14.0.3*/ 
    /*0*/ <-0.82324,10.28233,-1.09077>,
    /*1*/ <-0.81354,10.27376,-1.11529>,<-0.82793,10.3093,-1.08636>,<-0.82824,10.26392,-1.07064>,
            
    /*2*/ <-2.13558,10.12986,-1.55627>

    /* stem 0.14.0.4*/ 
    /*0*/ <-1.05817,10.61419,-1.29635>,
    /*1*/ <-1.05165,10.62972,-1.27684>,<-1.08218,10.61461,-1.30568>,<-1.04066,10.59824,-1.30652>,
            
    /*2*/ <-0.71433,11.52946,-2.13988>

    /* stem 0.14.0.5*/ 
    /*0*/ <-1.17093,10.8014,-1.38755>,
    /*1*/ <-1.19089,10.78901,-1.3953>,<-1.15998,10.81781,-1.40248>,<-1.16191,10.79738,-1.36486>,
            
    /*2*/ <-1.89786,11.69304,-0.94074>

    /* stem 0.14.0.6*/ 
    /*0*/ <-1.27889,11.00897,-1.44122>,
    /*1*/ <-1.25841,11.01746,-1.44958>,<-1.29384,11.02331,-1.42971>,<-1.28442,10.98614,-1.44436>,
            
    /*2*/ <-1.80552,11.27663,-2.45868>

    /* stem 0.14.0.7*/ 
    /*0*/ <-1.38795,11.27002,-1.5218>,
    /*1*/ <-1.40078,11.27154,-1.50348>,<-1.39602,11.27643,-1.5417>,<-1.36704,11.26209,-1.52021>,
            
    /*2*/ <-1.01283,12.29487,-1.34398>

    /* stem 0.14.0.8*/ 
    /*0*/ <-1.52976,11.66971,-1.65497>,
    /*1*/ <-1.53073,11.663,-1.67427>,<-1.52111,11.68778,-1.65084>,<-1.53746,11.65835,-1.63979>,
            
    /*2*/ <-2.41489,12.11926,-1.76702>

    /* stem 0.14.0.9*/ 
    /*0*/ <-1.67649,12.07607,-1.76021>,
    /*1*/ <-1.66491,12.08267,-1.74907>,<-1.69338,12.07968,-1.75834>,<-1.67118,12.06586,-1.77322>,
            
    /*2*/ <-1.5812,12.79234,-2.2835>

    /* stem 0.14.0.10*/ 
    /*0*/ <-1.75198,12.30292,-1.81116>,
    /*1*/ <-1.76451,12.29943,-1.81161>,<-1.74647,12.30877,-1.8214>,<-1.74494,12.30054,-1.80046>,
            
    /*2*/ <-1.96948,13.04611,-1.50301>

    /* stem 0.14.0.11*/ 
    /*0*/ <-1.816,12.54132,-1.87168>,
    /*1*/ <-1.80921,12.54186,-1.87676>,<-1.81808,12.54785,-1.86666>,<-1.82073,12.53425,-1.87163>,
            
    /*2*/ <-2.25869,12.83308,-2.43342>

    /* stem 0.14.0.12*/ 
    /*0*/ <-1.85139,12.74118,-1.9072>,
    /*1*/ <-1.85259,12.74169,-1.90255>,<-1.85415,12.74317,-1.91063>,<-1.84744,12.73869,-1.90842>,
            
    /*2*/ <-1.45851,13.34687,-1.87151>

    /* stem 0.14.1*/ 
    /*0*/ <-0.51953,9.73764,-0.62664>,
    /*1*/ <-0.52984,9.66844,-0.64194>,<-0.51748,9.78605,-0.67938>,<-0.51126,9.75843,-0.55861>,
            
    /*2*/ <-0.92613,9.72742,-0.60804>,<-0.91501,9.83327,-0.64174>,<-0.90941,9.80841,-0.53305>,
            
    /*3*/ <-1.30377,9.86608,-0.49748>,<-1.282,9.95632,-0.53257>,<-1.26272,9.93394,-0.43783>,
            
    /*4*/ <-1.6391,10.09373,-0.40806>,<-1.60214,10.16388,-0.44347>,<-1.59118,10.14699,-0.359>,
            
    /*5*/ <-1.94792,10.34051,-0.31671>,<-1.91275,10.39801,-0.34827>,<-1.90295,10.38355,-0.27592>,
            
    /*6*/ <-2.19377,10.65133,-0.2054>,<-2.15711,10.69187,-0.23472>,<-2.14701,10.67849,-0.17501>,
            
    /*7*/ <-2.41462,10.98413,-0.13891>,<-2.38163,11.01184,-0.16352>,<-2.37687,11.00522,-0.11458>,
            
    /*8*/ <-2.60157,11.34128,-0.09945>,<-2.57442,11.35822,-0.11845>,<-2.57219,11.3553,-0.08141>,
            
    /*9*/ <-2.75401,11.71272,-0.05415>,<-2.73515,11.72244,-0.06701>,<-2.73347,11.72012,-0.04237>,
            
    /*10*/ <-2.89417,12.08838,-0.01834>,<-2.88456,12.09279,-0.02481>,<-2.88382,12.09188,-0.01246>,
            
    /*11*/ <-3.02064,12.46612,-0.07513>

    /* stem 0.14.1.0*/ 
    /*0*/ <-0.74069,9.76662,-0.60863>,
    /*1*/ <-0.73831,9.79352,-0.6227>,<-0.75907,9.76361,-0.58453>,<-0.72469,9.74272,-0.61865>,
            
    /*2*/ <-1.91331,9.37683,-1.55157>

    /* stem 0.14.1.1*/ 
    /*0*/ <-1.01589,9.82463,-0.56587>,
    /*1*/ <-1.01215,9.81347,-0.53911>,<-1.03987,9.81802,-0.58124>,<-0.99566,9.8424,-0.57725>,
            
    /*2*/ <-1.71506,10.99672,0.0207>

    /* stem 0.14.1.2*/ 
    /*0*/ <-1.18443,9.88407,-0.51752>,
    /*1*/ <-1.19441,9.87654,-0.54307>,<-1.19074,9.90963,-0.50675>,<-1.16813,9.86604,-0.50274>,
            
    /*2*/ <-2.36074,9.3314,0.10498>

    /* stem 0.14.1.3*/ 
    /*0*/ <-1.38814,9.98816,-0.46175>,
    /*1*/ <-1.37241,10.00749,-0.45028>,<-1.40894,9.97722,-0.4476>,<-1.38307,9.97977,-0.48737>,
            
    /*2*/ <-2.23554,10.96768,-0.94992>

    /* stem 0.14.1.4*/ 
    /*0*/ <-1.79775,10.27891,-0.34938>,
    /*1*/ <-1.81135,10.25875,-0.34269>,<-1.80727,10.29572,-0.36559>,<-1.77465,10.28225,-0.33985>,
            
    /*2*/ <-2.28851,10.92899,0.61264>

    /* stem 0.14.1.5*/ 
    /*0*/ <-1.96419,10.42669,-0.29456>,
    /*1*/ <-1.95821,10.43885,-0.31463>,<-1.96758,10.4386,-0.27375>,<-1.96679,10.40262,-0.2953>,
            
    /*2*/ <-3.13176,10.561,-0.56151>

    /* stem 0.14.1.6*/ 
    /*0*/ <-2.095,10.58695,-0.23653>,
    /*1*/ <-2.08813,10.58455,-0.21441>,<-2.11765,10.58902,-0.24152>,<-2.07922,10.58729,-0.25365>,
            
    /*2*/ <-2.01211,11.73338,-0.13788>

    /* stem 0.14.1.7*/ 
    /*0*/ <-2.28178,10.8419,-0.17106>,
    /*1*/ <-2.29692,10.83426,-0.18487>,<-2.277,10.86324,-0.17079>,<-2.27142,10.8282,-0.15752>,
            
    /*2*/ <-3.04208,11.00275,0.57317>

    /* stem 0.14.1.8*/ 
    /*0*/ <-2.52645,11.24849,-0.11129>,
    /*1*/ <-2.50912,11.25798,-0.11158>,<-2.53987,11.25286,-0.09747>,<-2.53035,11.23463,-0.12481>,
            
    /*2*/ <-2.903,11.91799,-0.68881>

    /* stem 0.14.1.9*/ 
    /*0*/ <-2.63204,11.46598,-0.08566>,
    /*1*/ <-2.64434,11.45916,-0.07338>,<-2.63794,11.47639,-0.09999>,<-2.61383,11.46239,-0.0836>,
            
    /*2*/ <-2.54215,12.20989,0.41756>

    /* stem 0.14.1.10*/ 
    /*0*/ <-2.78924,11.8413,-0.04265>,
    /*1*/ <-2.788,11.84292,-0.05443>,<-2.78516,11.84956,-0.03501>,<-2.79455,11.83142,-0.0385>,
            
    /*2*/ <-3.50149,12.21439,-0.06594>

    /* stem 0.14.1.11*/ 
    /*0*/ <-2.83554,11.95894,-0.03129>,
    /*1*/ <-2.83053,11.96011,-0.02306>,<-2.84445,11.96266,-0.03212>,<-2.83162,11.95403,-0.03869>,
            
    /*2*/ <-2.535,12.61634,-0.3078>

    /* stem 0.14.1.12*/ 
    /*0*/ <-2.95934,12.2934,-0.04907>,
    /*1*/ <-2.96224,12.29221,-0.05012>,<-2.95784,12.2958,-0.05076>,<-2.95795,12.29218,-0.04634>,
            
    /*2*/ <-3.28836,12.76525,0.32774>

    /* stem 0.14.2*/ 
    /*0*/ <-0.79894,9.84035,-0.8026>,
    /*1*/ <-0.75967,9.89392,-0.82405>,<-0.85697,9.85221,-0.76569>,<-0.78016,9.77493,-0.81806>,
            
    /*2*/ <-0.97024,9.90747,-1.15291>,<-1.05781,9.86993,-1.10038>,<-0.98868,9.80038,-1.14751>,
            
    /*3*/ <-1.16998,10.04559,-1.44017>,<-1.25215,10.01441,-1.3998>,<-1.20344,9.9572,-1.46069>,
            
    /*4*/ <-1.33325,10.26313,-1.70409>,<-1.41014,10.24061,-1.67684>,<-1.37183,10.19556,-1.73736>,
            
    /*5*/ <-1.51984,10.54805,-1.88842>,<-1.58323,10.52567,-1.86116>,<-1.55995,10.49978,-1.9248>,
            
    /*6*/ <-1.63223,10.89118,-2.00684>,<-1.68852,10.88026,-1.98771>,<-1.67247,10.8659,-2.04419>,
            
    /*7*/ <-1.74519,11.24041,-2.14073>,<-1.79044,11.23236,-2.12572>,<-1.77715,11.21953,-2.1704>,
            
    /*8*/ <-1.84505,11.58609,-2.29159>,<-1.8794,11.58144,-2.28095>,<-1.8689,11.57015,-2.31377>,
            
    /*9*/ <-1.95674,11.93583,-2.4263>,<-1.9794,11.93188,-2.41885>,<-1.97272,11.92542,-2.44117>,
            
    /*10*/ <-2.03148,12.28334,-2.58602>,<-2.0431,12.28252,-2.5828>,<-2.0395,12.27835,-2.59356>,
            
    /*11*/ <-2.09767,12.62081,-2.77149>

    /* stem 0.14.2.0*/ 
    /*0*/ <-0.90748,9.85028,-0.97646>,
    /*1*/ <-0.93243,9.84502,-0.96119>,<-0.90083,9.83372,-1.00023>,<-0.88917,9.87212,-0.96797>,
            
    /*2*/ <-1.65537,10.82226,-1.86319>

    /* stem 0.14.2.1*/ 
    /*0*/ <-1.06576,9.9027,-1.22255>,
    /*1*/ <-1.04824,9.88965,-1.24077>,<-1.07619,9.92841,-1.22879>,<-1.07284,9.89003,-1.19809>,
            
    /*2*/ <-2.19688,9.2868,-1.86903>

    /* stem 0.14.2.2*/ 
    /*0*/ <-1.15237,9.96521,-1.35057>,
    /*1*/ <-1.1549,9.98932,-1.33709>,<-1.17493,9.95233,-1.36029>,<-1.12729,9.95398,-1.35433>,
            
    /*2*/ <-1.02463,10.65632,-2.5626>

    /* stem 0.14.2.3*/ 
    /*0*/ <-1.26056,10.07823,-1.52046>,
    /*1*/ <-1.27622,10.05792,-1.52803>,<-1.24637,10.09169,-1.53869>,<-1.2591,10.08508,-1.49465>,
            
    /*2*/ <-2.28662,10.9317,-1.68907>

    /* stem 0.14.2.4*/ 
    /*0*/ <-1.44243,10.34592,-1.77786>,
    /*1*/ <-1.42039,10.35605,-1.78364>,<-1.46144,10.36051,-1.77096>,<-1.44546,10.32119,-1.77897>,
            
    /*2*/ <-1.79905,10.44329,-2.96678>

    /* stem 0.14.2.5*/ 
    /*0*/ <-1.57862,10.60273,-1.91825>,
    /*1*/ <-1.59487,10.60351,-1.90126>,<-1.58376,10.61061,-1.93982>,<-1.55723,10.59408,-1.91368>,
            
    /*2*/ <-1.21231,11.66874,-1.61632>

    /* stem 0.14.2.6*/ 
    /*0*/ <-1.6352,10.78502,-1.98069>,
    /*1*/ <-1.63291,10.77836,-2.00221>,<-1.62949,10.8061,-1.97468>,<-1.64321,10.77061,-1.96516>,
            
    /*2*/ <-2.67711,11.12941,-2.19834>

    /* stem 0.14.2.7*/ 
    /*0*/ <-1.69859,10.99196,-2.05549>,
    /*1*/ <-1.68713,11.00138,-2.03973>,<-1.71949,10.99693,-2.05813>,<-1.68915,10.97756,-2.06862>,
            
    /*2*/ <-1.42778,11.77625,-2.72118>

    /* stem 0.14.2.8*/ 
    /*0*/ <-1.80797,11.36879,-2.20496>,
    /*1*/ <-1.82631,11.36231,-2.2086>,<-1.79815,11.37898,-2.2188>,<-1.79945,11.36509,-2.18749>,
            
    /*2*/ <-2.16796,12.19064,-1.8553>

    /* stem 0.14.2.9*/ 
    /*0*/ <-1.90942,11.72965,-2.35245>,
    /*1*/ <-1.89354,11.73129,-2.36067>,<-1.91639,11.7436,-2.34354>,<-1.91832,11.71408,-2.35313>,
            
    /*2*/ <-2.31014,11.99068,-3.07471>

    /* stem 0.14.2.10*/ 
    /*0*/ <-1.98835,12.027,-2.47223>,
    /*1*/ <-1.99385,12.03052,-2.46211>,<-1.9939,12.02828,-2.48285>,<-1.97731,12.02221,-2.47174>,
            
    /*2*/ <-1.67387,12.74409,-2.55025>

    /* stem 0.14.2.11*/ 
    /*0*/ <-2.0203,12.1906,-2.54633>,
    /*1*/ <-2.02215,12.18676,-2.55402>,<-2.01525,12.19779,-2.54612>,<-2.02348,12.18725,-2.53886>,
            
    /*2*/ <-2.62546,12.61665,-2.61325>

    /* stem 0.14.2.12*/ 
    /*0*/ <-2.05974,12.40498,-2.65446>,
    /*1*/ <-2.0563,12.40676,-2.6523>,<-2.06352,12.40727,-2.6549>,<-2.0594,12.40091,-2.6562>,
            
    /*2*/ <-1.82936,12.67406,-3.24039>

    /* stem 0.14.3*/ 
    /*0*/ <-1.01454,9.94115,-0.94554>,
    /*1*/ <-1.05644,9.92418,-0.89431>,<-1.02113,9.91096,-1.00649>,<-0.96605,9.9883,-0.93584>,
            
    /*2*/ <-1.2958,10.1987,-1.00826>,<-1.26401,10.1868,-1.10922>,<-1.21445,10.25641,-1.04564>,
            
    /*3*/ <-1.5439,10.4709,-1.08386>,<-1.52254,10.46665,-1.176>,<-1.47526,10.52576,-1.11912>,
            
    /*4*/ <-1.75943,10.76506,-1.22978>,<-1.72998,10.7504,-1.30582>,<-1.6909,10.80365,-1.25581>,
            
    /*5*/ <-1.93888,11.07535,-1.36812>,<-1.9133,11.06254,-1.43311>,<-1.87688,11.10363,-1.38809>,
            
    /*6*/ <-2.1054,11.3938,-1.49792>,<-2.08441,11.38371,-1.55231>,<-2.05287,11.41585,-1.51392>,
            
    /*7*/ <-2.27422,11.71183,-1.62303>,<-2.25775,11.70426,-1.66676>,<-2.2324,11.72981,-1.63601>,
            
    /*8*/ <-2.42978,12.02528,-1.78085>,<-2.41584,12.01697,-1.81242>,<-2.39762,12.03739,-1.7898>,
            
    /*9*/ <-2.60089,12.35403,-1.85563>,<-2.5941,12.35281,-1.87827>,<-2.58033,12.36363,-1.86235>,
            
    /*10*/ <-2.77872,12.68949,-1.8701>,<-2.77627,12.69049,-1.88164>,<-2.76875,12.69483,-1.8736>,
            
    /*11*/ <-2.89883,13.05235,-1.87244>

    /* stem 0.14.3.0*/ 
    /*0*/ <-1.13022,10.07073,-0.99723>,
    /*1*/ <-1.12524,10.06402,-1.0252>,<-1.13488,10.09848,-0.98949>,<-1.13054,10.04969,-0.97701>,
            
    /*2*/ <-2.58567,9.88637,-1.21222>

    /* stem 0.14.3.1*/ 
    /*0*/ <-1.34485,10.30683,-1.07878>,
    /*1*/ <-1.33384,10.32242,-1.05859>,<-1.37238,10.3034,-1.08022>,<-1.32833,10.29467,-1.09751>,
            
    /*2*/ <-1.44274,11.44017,-1.90101>

    /* stem 0.14.3.2*/ 
    /*0*/ <-1.58538,10.58356,-1.17249>,
    /*1*/ <-1.60499,10.56682,-1.17686>,<-1.57808,10.60031,-1.19119>,<-1.57307,10.58354,-1.14942>,
            
    /*2*/ <-2.44134,11.46699,-0.71519>

    /* stem 0.14.3.3*/ 
    /*0*/ <-1.69986,10.73698,-1.24643>,
    /*1*/ <-1.67957,10.74649,-1.2581>,<-1.71558,10.7523,-1.23392>,<-1.70442,10.71214,-1.24726>,
            
    /*2*/ <-2.3802,10.89717,-2.29851>

    /* stem 0.14.3.4*/ 
    /*0*/ <-1.86153,10.99955,-1.36152>,
    /*1*/ <-1.8733,11.00145,-1.34088>,<-1.87307,11.00262,-1.38215>,<-1.83821,10.99458,-1.36153>,
            
    /*2*/ <-1.6148,12.15711,-1.3275>

    /* stem 0.14.3.5*/ 
    /*0*/ <-2.01542,11.27644,-1.4736>,
    /*1*/ <-2.01772,11.26723,-1.49385>,<-2.00788,11.29742,-1.47165>,<-2.02065,11.26469,-1.4553>,
            
    /*2*/ <-3.05101,11.65344,-1.52743>

    /* stem 0.14.3.6*/ 
    /*0*/ <-2.14764,11.51966,-1.56766>,
    /*1*/ <-2.13392,11.53134,-1.5567>,<-2.1683,11.52363,-1.5663>,<-2.1407,11.50402,-1.57997>,
            
    /*2*/ <-2.07344,12.17711,-2.36126>

    /* stem 0.14.3.7*/ 
    /*0*/ <-2.37262,11.94504,-1.75444>,
    /*1*/ <-2.3896,11.93721,-1.75265>,<-2.36881,11.95593,-1.76928>,<-2.35944,11.94199,-1.7414>,
            
    /*2*/ <-2.66015,12.67407,-1.29349>

    /* stem 0.14.3.8*/ 
    /*0*/ <-2.46249,12.11606,-1.81362>,
    /*1*/ <-2.45055,12.11971,-1.82643>,<-2.4675,12.12885,-1.80216>,<-2.4694,12.09963,-1.81226>,
            
    /*2*/ <-3.10118,12.34096,-2.34445>

    /* stem 0.14.3.9*/ 
    /*0*/ <-2.5321,12.24569,-1.84151>,
    /*1*/ <-2.53429,12.24789,-1.82585>,<-2.5442,12.248,-1.85166>,<-2.51781,12.24119,-1.84702>,
            
    /*2*/ <-2.31399,13.03671,-1.92189>

    /* stem 0.14.3.10*/ 
    /*0*/ <-2.65225,12.46758,-1.86863>,
    /*1*/ <-2.6582,12.46407,-1.87771>,<-2.64715,12.47778,-1.86874>,<-2.65142,12.46089,-1.85943>,
            
    /*2*/ <-3.28255,12.7866,-1.57938>

    /* stem 0.14.3.11*/ 
    /*0*/ <-2.81567,12.81091,-1.87423>,
    /*1*/ <-2.81145,12.81235,-1.87321>,<-2.81927,12.81253,-1.87191>,<-2.81629,12.80785,-1.87757>,
            
    /*2*/ <-2.8787,13.30958,-2.31993>

    /* stem 0.14.4*/ 
    /*0*/ <-1.15378,10.00624,-1.03786>,
    /*1*/ <-1.12839,9.98016,-1.09456>,<-1.15611,10.07308,-1.0296>,<-1.17686,9.96549,-0.98941>,
            
    /*2*/ <-1.47242,9.99023,-1.2453>,<-1.49737,10.07385,-1.18683>,<-1.51605,9.97702,-1.15066>,
            
    /*3*/ <-1.81883,10.0835,-1.37997>,<-1.8236,10.15575,-1.32103>,<-1.85642,10.07223,-1.29525>,
            
    /*4*/ <-2.11037,10.25828,-1.53835>,<-2.1072,10.31746,-1.48212>,<-2.15351,10.25139,-1.46931>,
            
    /*5*/ <-2.36464,10.541,-1.61634>,<-2.34304,10.57675,-1.56014>,<-2.39596,10.53124,-1.55448>,
            
    /*6*/ <-2.57425,10.85194,-1.66815>,<-2.55183,10.87613,-1.62001>,<-2.60042,10.84399,-1.6166>,
            
    /*7*/ <-2.78481,11.16903,-1.66506>,<-2.76347,11.18363,-1.62619>,<-2.80228,11.15785,-1.62323>,
            
    /*8*/ <-2.94532,11.50884,-1.66406>,<-2.92804,11.51752,-1.63488>,<-2.95963,11.50259,-1.63273>,
            
    /*9*/ <-3.0315,11.87311,-1.68413>,<-3.01946,11.87741,-1.6646>,<-3.04215,11.8721,-1.66339>,
            
    /*10*/ <-3.11267,12.23996,-1.69795>,<-3.10659,12.24186,-1.68817>,<-3.11798,12.23936,-1.68757>,
            
    /*11*/ <-3.15914,12.61199,-1.72078>

    /* stem 0.14.4.0*/ 
    /*0*/ <-1.36488,10.01085,-1.13454>,
    /*1*/ <-1.36986,10.03624,-1.12246>,<-1.38599,9.99178,-1.13691>,<-1.33878,10.00454,-1.14425>,
            
    /*2*/ <-1.71383,10.55811,-2.42781>

    /* stem 0.14.4.1*/ 
    /*0*/ <-1.6438,10.05334,-1.25488>,
    /*1*/ <-1.65199,10.02757,-1.25168>,<-1.64701,10.06576,-1.27891>,<-1.63241,10.0667,-1.23406>,
            
    /*2*/ <-2.88233,10.49575,-0.86092>

    /* stem 0.14.4.2*/ 
    /*0*/ <-1.88285,10.13332,-1.36032>,
    /*1*/ <-1.86638,10.14676,-1.37538>,<-1.90485,10.14446,-1.35191>,<-1.87731,10.10875,-1.35365>,
            
    /*2*/ <-2.5071,9.70402,-2.42524>

    /* stem 0.14.4.3*/ 
    /*0*/ <-2.02967,10.22013,-1.44339>,
    /*1*/ <-2.04126,10.22191,-1.42105>,<-2.0415,10.20937,-1.46292>,<-2.00626,10.2291,-1.44621>,
            
    /*2*/ <-2.49986,11.34213,-1.7768>

    /* stem 0.14.4.4*/ 
    /*0*/ <-2.24315,10.40973,-1.53592>,
    /*1*/ <-2.24753,10.3996,-1.55714>,<-2.23811,10.43307,-1.53463>,<-2.24382,10.39652,-1.516>,
            
    /*2*/ <-3.39965,10.65288,-1.41321>

    /* stem 0.14.4.5*/ 
    /*0*/ <-2.43509,10.64927,-1.59574>,
    /*1*/ <-2.41926,10.66184,-1.58576>,<-2.45655,10.65072,-1.58898>,<-2.42947,10.63526,-1.61249>,
            
    /*2*/ <-2.61362,11.46156,-2.33522>

    /* stem 0.14.4.6*/ 
    /*0*/ <-2.64757,10.96573,-1.63604>,
    /*1*/ <-2.66447,10.95455,-1.63113>,<-2.6488,10.98064,-1.65057>,<-2.62944,10.96201,-1.62643>,
            
    /*2*/ <-2.88948,11.64752,-0.91603>

    /* stem 0.14.4.7*/ 
    /*0*/ <-2.83375,11.27622,-1.63995>,
    /*1*/ <-2.82331,11.2809,-1.65542>,<-2.83774,11.28953,-1.62664>,<-2.84021,11.25822,-1.63779>,
            
    /*2*/ <-3.61491,11.50146,-2.0989>

    /* stem 0.14.4.8*/ 
    /*0*/ <-2.96983,11.61688,-1.65178>,
    /*1*/ <-2.96923,11.61831,-1.63425>,<-2.98304,11.62426,-1.66076>,<-2.95723,11.60806,-1.66032>,
            
    /*2*/ <-2.52159,12.32948,-1.72536>

    /* stem 0.14.4.9*/ 
    /*0*/ <-3.00768,11.776,-1.66348>,
    /*1*/ <-3.01764,11.77281,-1.67464>,<-2.9995,11.78891,-1.664>,<-3.00591,11.76629,-1.65181>,
            
    /*2*/ <-3.58723,12.1597,-1.25596>

    /* stem 0.14.4.10*/ 
    /*0*/ <-3.07896,12.08984,-1.68279>,
    /*1*/ <-3.06976,12.09195,-1.68162>,<-3.08559,12.09467,-1.67799>,<-3.08152,12.0829,-1.68877>,
            
    /*2*/ <-3.12066,12.57294,-2.22625>

    /* stem 0.14.4.11*/ 
    /*0*/ <-3.12413,12.33353,-1.69864>,
    /*1*/ <-3.12837,12.33321,-1.69593>,<-3.12396,12.33649,-1.70273>,<-3.12005,12.33089,-1.69726>,
            
    /*2*/ <-2.92095,12.8457,-1.31982>

    /* stem 0.14.5*/ 
    /*0*/ <-1.41203,10.11998,-1.18858>,
    /*1*/ <-1.40816,10.17449,-1.15213>,<-1.46523,10.08164,-1.18476>,<-1.36271,10.10382,-1.22884>,
            
    /*2*/ <-1.56544,10.35997,-1.42464>,<-1.61681,10.27641,-1.45401>,<-1.52454,10.29637,-1.49367>,
            
    /*3*/ <-1.7372,10.58779,-1.63393>,<-1.78891,10.52047,-1.66677>,<-1.71057,10.54188,-1.70787>,
            
    /*4*/ <-1.92704,10.85876,-1.75458>,<-1.97919,10.80864,-1.78792>,<-1.91628,10.83415,-1.82955>,
            
    /*5*/ <-2.15565,11.13035,-1.81994>,<-2.2006,11.08718,-1.84779>,<-2.15355,11.11741,-1.88693>,
            
    /*6*/ <-2.37179,11.41723,-1.83392>,<-2.41315,11.38596,-1.85731>,<-2.37551,11.41275,-1.8905>,
            
    /*7*/ <-2.53607,11.73792,-1.89438>,<-2.57151,11.71694,-1.91372>,<-2.53622,11.73018,-1.93922>,
            
    /*8*/ <-2.68259,12.06565,-1.95874>,<-2.70976,12.05119,-1.97349>,<-2.68259,12.05964,-1.99233>,
            
    /*9*/ <-2.81524,12.40049,-2.01385>,<-2.83378,12.39189,-2.02384>,<-2.81549,12.39708,-2.03634>,
            
    /*10*/ <-2.98229,12.72442,-2.02141>,<-2.99144,12.71979,-2.02634>,<-2.98302,12.72398,-2.03275>,
            
    /*11*/ <-3.17524,13.03478,-2.02381>

    /* stem 0.14.5.0*/ 
    /*0*/ <-1.50317,10.23089,-1.34476>,
    /*1*/ <-1.52059,10.20967,-1.34967>,<-1.49013,10.24342,-1.36598>,<-1.49881,10.23959,-1.31862>,
            
    /*2*/ <-2.57485,11.13865,-1.46768>

    /* stem 0.14.5.1*/ 
    /*0*/ <-1.63264,10.39717,-1.53394>,
    /*1*/ <-1.6093,10.40668,-1.54266>,<-1.65106,10.41386,-1.52427>,<-1.63757,10.37098,-1.53489>,
            
    /*2*/ <-2.14988,10.53905,-2.76353>

    /* stem 0.14.5.2*/ 
    /*0*/ <-1.78571,10.6084,-1.69443>,
    /*1*/ <-1.79925,10.60823,-1.67301>,<-1.7973,10.61179,-1.71672>,<-1.76059,10.60518,-1.69358>,
            
    /*2*/ <-1.6288,11.86135,-1.58553>

    /* stem 0.14.5.3*/ 
    /*0*/ <-1.91142,10.79109,-1.77243>,
    /*1*/ <-1.9117,10.78138,-1.79473>,<-1.90728,10.81489,-1.76959>,<-1.91526,10.77701,-1.75297>,
            
    /*2*/ <-3.10042,11.00699,-1.85125>

    /* stem 0.14.5.4*/ 
    /*0*/ <-2.07484,10.99634,-1.82629>,
    /*1*/ <-2.0615,11.01018,-1.81338>,<-2.0977,10.99559,-1.82263>,<-2.06534,10.98327,-1.84286>,
            
    /*2*/ <-2.22405,11.8456,-2.58196>

    /* stem 0.14.5.5*/ 
    /*0*/ <-2.27146,11.24913,-1.85578>,
    /*1*/ <-2.2889,11.23632,-1.85362>,<-2.27178,11.26561,-1.86995>,<-2.25372,11.24545,-1.84377>,
            
    /*2*/ <-2.65253,11.89619,-1.09477>

    /* stem 0.14.5.6*/ 
    /*0*/ <-2.47989,11.59193,-1.89246>,
    /*1*/ <-2.46622,11.59638,-1.9063>,<-2.48554,11.60573,-1.8792>,<-2.48792,11.57367,-1.89189>,
            
    /*2*/ <-3.18455,11.8829,-2.49525>

    /* stem 0.14.5.7*/ 
    /*0*/ <-2.64648,11.95498,-1.95629>,
    /*1*/ <-2.64938,11.9569,-1.93847>,<-2.65951,11.95939,-1.96813>,<-2.63056,11.94864,-1.96226>,
            
    /*2*/ <-2.33578,12.77184,-1.99392>

    /* stem 0.14.5.8*/ 
    /*0*/ <-2.71924,12.13058,-1.98544>,
    /*1*/ <-2.72748,12.12531,-1.99969>,<-2.70975,12.14503,-1.98579>,<-2.72049,12.12141,-1.97084>,
            
    /*2*/ <-3.38426,12.57278,-1.76454>

    /* stem 0.14.5.9*/ 
    /*0*/ <-2.79284,12.32197,-2.01368>,
    /*1*/ <-2.77998,12.32752,-2.00962>,<-2.80523,12.32826,-2.00924>,<-2.79332,12.31013,-2.02219>,
            
    /*2*/ <-2.78903,12.77654,-2.6462>

    /* stem 0.14.5.10*/ 
    /*0*/ <-2.91939,12.59111,-2.02596>,
    /*1*/ <-2.9269,12.58735,-2.02217>,<-2.92025,12.59744,-2.03261>,<-2.91101,12.58854,-2.02311>,
            
    /*2*/ <-2.92874,13.10267,-1.53762>

    /* stem 0.14.5.11*/ 
    /*0*/ <-3.09739,12.90669,-2.02505>,
    /*1*/ <-3.0964,12.90731,-2.02748>,<-3.09752,12.90857,-2.02313>,<-3.09825,12.90418,-2.02455>,
            
    /*2*/ <-3.66618,13.06328,-2.21661>

    /* stem 0.14.6*/ 
    /*0*/ <-1.75543,10.26374,-1.36705>,
    /*1*/ <-1.78083,10.20559,-1.36503>,<-1.75299,10.29542,-1.42202>,<-1.73248,10.29022,-1.31411>,
            
    /*2*/ <-2.09384,10.35153,-1.2985>,<-2.06878,10.43238,-1.34979>,<-2.05032,10.42769,-1.25267>,
            
    /*3*/ <-2.39102,10.5551,-1.26967>,<-2.35323,10.61904,-1.31681>,<-2.34517,10.61834,-1.22921>,
            
    /*4*/ <-2.64141,10.81677,-1.26119>,<-2.59607,10.86285,-1.30299>,<-2.592,10.86426,-1.22613>,
            
    /*5*/ <-2.80396,11.14362,-1.26067>,<-2.75472,11.16892,-1.29657>,<-2.75161,11.17035,-1.23068>,
            
    /*6*/ <-2.90465,11.48644,-1.23759>,<-2.86136,11.50201,-1.2677>,<-2.85726,11.49949,-1.21293>,
            
    /*7*/ <-3.05408,11.79918,-1.24914>,<-3.02077,11.81496,-1.27316>,<-3.01926,11.81726,-1.22925>,
            
    /*8*/ <-3.14797,12.14261,-1.23998>,<-3.12155,12.15081,-1.25796>,<-3.11962,12.15044,-1.22503>,
            
    /*9*/ <-3.29818,12.45605,-1.2182>,<-3.28197,12.465,-1.23006>,<-3.28042,12.46423,-1.20813>,
            
    /*10*/ <-3.44191,12.77727,-1.2082>,<-3.43361,12.78135,-1.21415>,<-3.43299,12.78129,-1.20317>,
            
    /*11*/ <-3.52125,13.12091,-1.22185>

    /* stem 0.14.6.0*/ 
    /*0*/ <-1.92986,10.3412,-1.33016>,
    /*1*/ <-1.92483,10.36097,-1.34785>,<-1.94249,10.34675,-1.30695>,<-1.92227,10.31588,-1.33568>,
            
    /*2*/ <-3.12968,10.11195,-1.92795>

    /* stem 0.14.6.1*/ 
    /*0*/ <-2.17671,10.47394,-1.29003>,
    /*1*/ <-2.17684,10.47,-1.26456>,<-2.19867,10.4723,-1.30344>,<-2.15462,10.47951,-1.3021>,
            
    /*2*/ <-2.38885,11.73328,-1.09647>

    /* stem 0.14.6.2*/ 
    /*0*/ <-2.43213,10.66754,-1.26953>,
    /*1*/ <-2.44191,10.6586,-1.29>,<-2.42764,10.69143,-1.26759>,<-2.42684,10.6526,-1.251>,
            
    /*2*/ <-3.54415,10.8394,-0.81324>

    /* stem 0.14.6.3*/ 
    /*0*/ <-2.55078,10.78801,-1.26546>,
    /*1*/ <-2.53456,10.80375,-1.25851>,<-2.57118,10.78605,-1.25365>,<-2.54661,10.77423,-1.28422>,
            
    /*2*/ <-3.03422,11.59577,-1.96631>

    /* stem 0.14.6.4*/ 
    /*0*/ <-2.69198,11.00839,-1.26303>,
    /*1*/ <-2.7104,10.99894,-1.25425>,<-2.69376,11.02228,-1.28064>,<-2.67177,11.00397,-1.2542>,
            
    /*2*/ <-2.80511,11.87002,-0.5722>

    /* stem 0.14.6.5*/ 
    /*0*/ <-2.80165,11.26228,-1.25561>,
    /*1*/ <-2.79289,11.26632,-1.27458>,<-2.79859,11.27571,-1.2394>,<-2.81346,11.24481,-1.25286>,
            
    /*2*/ <-3.65428,11.7946,-1.53586>

    /* stem 0.14.6.6*/ 
    /*0*/ <-2.91938,11.58606,-1.24259>,
    /*1*/ <-2.91564,11.58861,-1.22337>,<-2.93675,11.59169,-1.2501>,<-2.90574,11.57789,-1.2543>,
            
    /*2*/ <-2.55722,12.45607,-1.42807>

    /* stem 0.14.6.7*/ 
    /*0*/ <-3.06572,11.92834,-1.24719>,
    /*1*/ <-3.07967,11.92458,-1.25805>,<-3.05487,11.94232,-1.25091>,<-3.06261,11.91813,-1.2326>,
            
    /*2*/ <-3.57591,12.45065,-0.77274>

    /* stem 0.14.6.8*/ 
    /*0*/ <-3.18853,12.2654,-1.23268>,
    /*1*/ <-3.17385,12.2728,-1.23346>,<-3.19968,12.27037,-1.22166>,<-3.19205,12.25302,-1.24293>,
            
    /*2*/ <-3.47451,12.77769,-1.75308>

    /* stem 0.14.6.9*/ 
    /*0*/ <-3.26287,12.41387,-1.22218>,
    /*1*/ <-3.27159,12.40885,-1.21293>,<-3.26762,12.42052,-1.23314>,<-3.24941,12.41224,-1.22048>,
            
    /*2*/ <-3.23278,13.05531,-0.84582>

    /* stem 0.14.6.10*/ 
    /*0*/ <-3.39339,12.6888,-1.21145>,
    /*1*/ <-3.39256,12.68945,-1.21955>,<-3.3905,12.69467,-1.20657>,<-3.39711,12.68227,-1.20824>,
            
    /*2*/ <-3.98303,13.00761,-1.2464>

    /* stem 0.14.6.11*/ 
    /*0*/ <-3.46174,12.88244,-1.21252>,
    /*1*/ <-3.45945,12.88316,-1.20878>,<-3.46567,12.88441,-1.21313>,<-3.46009,12.87975,-1.21564>,
            
    /*2*/ <-3.1772,13.36662,-1.47913>

    /* stem 0.14.7*/ 
    /*0*/ <-2.19439,10.42414,-1.55615>,
    /*1*/ <-2.16682,10.46138,-1.5955>,<-2.23752,10.44562,-1.51908>,<-2.17882,10.36542,-1.55386>,
            
    /*2*/ <-2.40263,10.38693,-1.82173>,<-2.46626,10.37274,-1.75295>,<-2.41343,10.30056,-1.78425>,
            
    /*3*/ <-2.6485,10.37365,-2.042>,<-2.70473,10.36151,-1.98047>,<-2.66792,10.29542,-2.01753>,
            
    /*4*/ <-2.87878,10.43083,-2.26717>,<-2.93192,10.42006,-2.21724>,<-2.90674,10.36338,-2.25707>,
            
    /*5*/ <-3.11159,10.57916,-2.44929>,<-3.15454,10.56959,-2.40396>,<-3.14644,10.52646,-2.44941>,
            
    /*6*/ <-3.26648,10.78598,-2.64587>,<-3.30945,10.78377,-2.61552>,<-3.30365,10.74994,-2.65543>,
            
    /*7*/ <-3.399,11.02925,-2.82905>,<-3.4341,11.02855,-2.80579>,<-3.4311,11.00431,-2.8401>,
            
    /*8*/ <-3.47772,11.27338,-3.03854>,<-3.5059,11.27683,-3.02469>,<-3.5026,11.25699,-3.04904>,
            
    /*9*/ <-3.54903,11.55628,-3.20196>,<-3.56757,11.55771,-3.19208>,<-3.56618,11.54746,-3.21042>,
            
    /*10*/ <-3.62735,11.86892,-3.29437>,<-3.63634,11.86846,-3.2889>,<-3.63617,11.86551,-3.29901>,
            
    /*11*/ <-3.70696,12.19086,-3.34292>

    /* stem 0.14.7.0*/ 
    /*0*/ <-2.35591,10.37512,-1.71567>,
    /*1*/ <-2.37401,10.37564,-1.6975>,<-2.35548,10.35603,-1.7328>,<-2.33824,10.39369,-1.71671>,
            
    /*2*/ <-3.11765,11.05634,-2.49415>

    /* stem 0.14.7.1*/ 
    /*0*/ <-2.48965,10.35091,-1.84366>,
    /*1*/ <-2.47673,10.33439,-1.85697>,<-2.49812,10.37163,-1.85443>,<-2.49411,10.34672,-1.81959>,
            
    /*2*/ <-3.5419,9.76654,-2.14037>

    /* stem 0.14.7.2*/ 
    /*0*/ <-2.81258,10.38016,-2.15323>,
    /*1*/ <-2.81208,10.4024,-2.1479>,<-2.83257,10.36984,-2.15739>,<-2.79308,10.36823,-2.1544>,
            
    /*2*/ <-2.71887,10.6409,-3.25021>

    /* stem 0.14.7.3*/ 
    /*0*/ <-3.04449,10.49671,-2.35912>,
    /*1*/ <-3.05786,10.48027,-2.35607>,<-3.04388,10.50664,-2.37808>,<-3.03174,10.50323,-2.3432>,
            
    /*2*/ <-3.78999,11.16261,-2.03447>

    /* stem 0.14.7.4*/ 
    /*0*/ <-3.16525,10.59666,-2.47068>,
    /*1*/ <-3.1475,10.60025,-2.48041>,<-3.17782,10.61228,-2.46615>,<-3.17042,10.57746,-2.46547>,
            
    /*2*/ <-3.62699,10.4814,-3.35514>

    /* stem 0.14.7.5*/ 
    /*0*/ <-3.23934,10.69891,-2.56812>,
    /*1*/ <-3.24996,10.7058,-2.55282>,<-3.24824,10.69506,-2.58544>,<-3.21983,10.69589,-2.56609>,
            
    /*2*/ <-3.06882,11.60476,-2.85745>

    /* stem 0.14.7.6*/ 
    /*0*/ <-3.37495,10.93105,-2.75758>,
    /*1*/ <-3.3766,10.91951,-2.77179>,<-3.37066,10.94868,-2.7605>,<-3.37759,10.92495,-2.74044>,
            
    /*2*/ <-4.23699,11.13053,-2.81957>

    /* stem 0.14.7.7*/ 
    /*0*/ <-3.46603,11.17049,-2.9531>,
    /*1*/ <-3.4546,11.18039,-2.9455>,<-3.48042,11.17716,-2.959>,<-3.46308,11.1539,-2.95478>,
            
    /*2*/ <-3.10972,11.30642,-3.66697>

    /* stem 0.14.7.8*/ 
    /*0*/ <-3.52105,11.38053,-3.10164>,
    /*1*/ <-3.53644,11.37734,-3.10103>,<-3.51468,11.38601,-3.11494>,<-3.51204,11.37824,-3.08896>,
            
    /*2*/ <-3.65701,12.07936,-2.87895>

    /* stem 0.14.7.9*/ 
    /*0*/ <-3.60785,11.75732,-3.26154>,
    /*1*/ <-3.60162,11.75718,-3.26689>,<-3.60869,11.76366,-3.25639>,<-3.61324,11.75112,-3.26134>,
            
    /*2*/ <-3.97421,12.06175,-3.6962>

    /* stem 0.14.7.10*/ 
    /*0*/ <-3.67102,12.03316,-3.3191>,
    /*1*/ <-3.67148,12.0335,-3.31619>,<-3.67295,12.03428,-3.32104>,<-3.66862,12.03171,-3.32006>,
            
    /*2*/ <-3.37613,12.52716,-3.32884>

    /* stem 0.14.8*/ 
    /*0*/ <-3.11528,10.73084,-1.82077>,
    /*1*/ <-3.12764,10.72827,-1.76686>,<-3.14402,10.70066,-1.85723>,<-3.0742,10.76359,-1.83823>,
            
    /*2*/ <-3.32218,10.95599,-1.80627>,<-3.33692,10.93114,-1.8876>,<-3.27408,10.98778,-1.8705>,
            
    /*3*/ <-3.4963,11.19973,-1.83061>,<-3.51304,11.18198,-1.90334>,<-3.45271,11.2267,-1.88769>,
            
    /*4*/ <-3.69299,11.42431,-1.83687>,<-3.70896,11.40994,-1.90047>,<-3.65964,11.45353,-1.88727>,
            
    /*5*/ <-3.85606,11.68173,-1.88362>,<-3.86675,11.