/*************** Tree made by: ******************

Arbaro 2.0 - creates trees objects for rendering from xml parameter files
(c) 2003-2004 by Wolfram Diestel <diestel@steloj.de> (GPL see file COPYING)


<?xml version='1.0' ?>

<arbaro>
  <species name='my_lombardy_poplar'>
    <!-- general params -->
    <param name='Shape' value='2'/>
    <param name='Levels' value='3'/>
    <param name='Scale' value='25.0'/>
    <param name='ScaleV' value='5.0'/>
    <param name='BaseSize' value='0.075'/>
    <param name='Ratio' value='0.015'/>
    <param name='RatioPower' value='1.3'/>
    <param name='Flare' value='0.8'/>
    <param name='Lobes' value='7'/>
    <param name='LobeDepth' value='0.05'/>
    <param name='Smooth' value='0.5'/>
    <param name='Leaves' value='0'/>
    <param name='LeafShape' value='0'/>
    <param name='LeafScale' value='0.2'/>
    <param name='LeafScaleX' value='1.0'/>
    <param name='LeafQuality' value='1.0'/>
    <param name='LeafStemLen' value='0.5'/>
    <param name='LeafDistrib' value='4'/>
    <param name='LeafBend' value='0.5'/>
    <param name='AttractionUp' value='0.5'/>
    <param name='PruneRatio' value='0.0'/>
    <param name='PrunePowerLow' value='0.5'/>
    <param name='PrunePowerHigh' value='0.5'/>
    <param name='PruneWidth' value='0.5'/>
    <param name='PruneWidthPeak' value='0.5'/>
    <param name='0Scale' value='0.8'/>
    <param name='0ScaleV' value='0.0'/>
    <param name='0BaseSplits' value='0'/>
    <!-- level 0 -->
    <param name='0DownAngle' value='0.0'/>
    <param name='0DownAngleV' value='0.0'/>
    <param name='0Rotate' value='0.0'/>
    <param name='0RotateV' value='0.0'/>
    <param name='0Branches' value='1'/>
    <param name='0BranchDist' value='0.0'/>
    <param name='0Length' value='1.0'/>
    <param name='0LengthV' value='0.0'/>
    <param name='0Taper' value='1.0'/>
    <param name='0SegSplits' value='0.0'/>
    <param name='0SplitAngle' value='0.0'/>
    <param name='0SplitAngleV' value='0.0'/>
    <param name='0CurveRes' value='1'/>
    <param name='0Curve' value='0.0'/>
    <param name='0CurveBack' value='0.0'/>
    <param name='0CurveV' value='15.0'/>
    <!-- level 1 -->
    <param name='1DownAngle' value='30.0'/>
    <param name='1DownAngleV' value='0.0'/>
    <param name='1Rotate' value='77.0'/>
    <param name='1RotateV' value='0.0'/>
    <param name='1Branches' value='40'/>
    <param name='1BranchDist' value='1.0'/>
    <param name='1Length' value='0.3'/>
    <param name='1LengthV' value='0.0'/>
    <param name='1Taper' value='1.0'/>
    <param name='1SegSplits' value='0.0'/>
    <param name='1SplitAngle' value='0.0'/>
    <param name='1SplitAngleV' value='0.0'/>
    <param name='1CurveRes' value='3'/>
    <param name='1Curve' value='-20.0'/>
    <param name='1CurveBack' value='0.0'/>
    <param name='1CurveV' value='0.0'/>
    <!-- level 2 -->
    <param name='2DownAngle' value='30.0'/>
    <param name='2DownAngleV' value='10.0'/>
    <param name='2Rotate' value='77.0'/>
    <param name='2RotateV' value='0.0'/>
    <param name='2Branches' value='30'/>
    <param name='2BranchDist' value='1.0'/>
    <param name='2Length' value='0.4'/>
    <param name='2LengthV' value='0.0'/>
    <param name='2Taper' value='1.0'/>
    <param name='2SegSplits' value='0.0'/>
    <param name='2SplitAngle' value='0.0'/>
    <param name='2SplitAngleV' value='0.0'/>
    <param name='2CurveRes' value='3'/>
    <param name='2Curve' value='-20.0'/>
    <param name='2CurveBack' value='0.0'/>
    <param name='2CurveV' value='40.0'/>
    <!-- level 3 -->
    <param name='3DownAngle' value='30.0'/>
    <param name='3DownAngleV' value='10.0'/>
    <param name='3Rotate' value='77.0'/>
    <param name='3RotateV' value='0.0'/>
  </species>
</arbaro>
************************************************/
#declare my_lombardy_poplar_13_height = 25.73852;
#declare my_lombardy_poplar_13_stems = 
  mesh2 {
    vertex_vectors { 10851
    /* stem 0*/ 
    /*0*/ <0,0,0>,
    /*1*/ <0.5514,0,-0.01375>,<0.51974,0,0.10507>,<0.45557,0,0.20556>,
            <0.41541,0,0.31466>,<0.35455,0,0.42253>,<0.24191,0,0.47186>,
            <0.12333,0,0.48435>,<0.01299,0,0.52096>,<-0.10929,0,0.54064>,
            <-0.21809,0,0.48333>,<-0.30178,0,0.39841>,<-0.39921,0,0.33497>,
            <-0.49083,0,0.25163>,<-0.51386,0,0.13084>,<-0.49965,0,0.01246>,
            <-0.51079,0,-0.10326>,<-0.50276,0,-0.22686>,<-0.42268,0,-0.32017>,
            <-0.32127,0,-0.38287>,<-0.23774,0,-0.46373>,<-0.13611,0,-0.53452>,
            <-0.01322,0,-0.53009>,<0.09903,0,-0.48989>,<0.21433,0,-0.47501>,
            <0.33304,0,-0.43968>,<0.4062,0,-0.34084>,<0.44476,0,-0.22802>,
            <0.50501,0,-0.12859>,
    /*2*/ <0.53327,0.04775,-0.0133>,<0.50265,0.04775,0.10161>,<0.44059,0.04775,0.1988>,
            <0.40174,0.04775,0.30431>,<0.34289,0.04775,0.40863>,<0.23395,0.04775,0.45634>,
            <0.11927,0.04775,0.46842>,<0.01256,0.04775,0.50383>,<-0.1057,0.04775,0.52286>,
            <-0.21091,0.04775,0.46743>,<-0.29186,0.04775,0.38531>,<-0.38608,0.04775,0.32396>,
            <-0.47469,0.04775,0.24336>,<-0.49696,0.04775,0.12654>,<-0.48322,0.04775,0.01205>,
            <-0.49399,0.04775,-0.09986>,<-0.48623,0.04775,-0.21939>,<-0.40878,0.04775,-0.30964>,
            <-0.3107,0.04775,-0.37028>,<-0.22992,0.04775,-0.44848>,<-0.13163,0.04775,-0.51694>,
            <-0.01278,0.04775,-0.51266>,<0.09578,0.04775,-0.47378>,<0.20728,0.04775,-0.45939>,
            <0.32209,0.04775,-0.42522>,<0.39284,0.04775,-0.32963>,<0.43013,0.04775,-0.22052>,
            <0.4884,0.04775,-0.12436>,
    /*3*/ <0.51638,0.09549,-0.01288>,<0.48673,0.09549,0.09839>,<0.42664,0.09549,0.19251>,
            <0.38902,0.09549,0.29467>,<0.33203,0.09549,0.3957>,<0.22654,0.09549,0.44189>,
            <0.1155,0.09549,0.45359>,<0.01217,0.09549,0.48788>,<-0.10235,0.09549,0.5063>,
            <-0.20424,0.09549,0.45263>,<-0.28262,0.09549,0.37311>,<-0.37385,0.09549,0.3137>,
            <-0.45966,0.09549,0.23565>,<-0.48122,0.09549,0.12253>,<-0.46792,0.09549,0.01167>,
            <-0.47835,0.09549,-0.0967>,<-0.47083,0.09549,-0.21245>,<-0.39584,0.09549,-0.29984>,
            <-0.30086,0.09549,-0.35856>,<-0.22264,0.09549,-0.43428>,<-0.12746,0.09549,-0.50057>,
            <-0.01238,0.09549,-0.49642>,<0.09274,0.09549,-0.45878>,<0.20072,0.09549,-0.44484>,
            <0.31189,0.09549,-0.41175>,<0.3804,0.09549,-0.31919>,<0.41652,0.09549,-0.21353>,
            <0.47294,0.09549,-0.12042>,
    /*4*/ <0.48601,0.19099,-0.01212>,<0.4581,0.19099,0.09261>,<0.40155,0.19099,0.18118>,
            <0.36614,0.19099,0.27734>,<0.3125,0.19099,0.37242>,<0.21322,0.19099,0.4159>,
            <0.1087,0.19099,0.42691>,<0.01145,0.19099,0.45918>,<-0.09633,0.19099,0.47652>,
            <-0.19222,0.19099,0.42601>,<-0.26599,0.19099,0.35116>,<-0.35186,0.19099,0.29525>,
            <-0.43262,0.19099,0.22179>,<-0.45292,0.19099,0.11533>,<-0.44039,0.19099,0.01098>,
            <-0.45022,0.19099,-0.09101>,<-0.44314,0.19099,-0.19995>,<-0.37255,0.19099,-0.2822>,
            <-0.28317,0.19099,-0.33747>,<-0.20955,0.19099,-0.40874>,<-0.11996,0.19099,-0.47113>,
            <-0.01165,0.19099,-0.46722>,<0.08729,0.19099,-0.4318>,<0.18891,0.19099,-0.41868>,
            <0.29355,0.19099,-0.38753>,<0.35803,0.19099,-0.30042>,<0.39202,0.19099,-0.20097>,
            <0.44512,0.19099,-0.11334>,
    /*5*/ <0.43674,0.38197,-0.01089>,<0.41166,0.38197,0.08322>,<0.36084,0.38197,0.16282>,
            <0.32902,0.38197,0.24922>,<0.28082,0.38197,0.33466>,<0.1916,0.38197,0.37373>,
            <0.09768,0.38197,0.38363>,<0.01029,0.38197,0.41263>,<-0.08656,0.38197,0.42821>,
            <-0.17273,0.38197,0.38282>,<-0.23903,0.38197,0.31556>,<-0.31619,0.38197,0.26531>,
            <-0.38876,0.38197,0.19931>,<-0.407,0.38197,0.10363>,<-0.39574,0.38197,0.00987>,
            <-0.40457,0.38197,-0.08179>,<-0.39821,0.38197,-0.17968>,<-0.33478,0.38197,-0.25359>,
            <-0.25446,0.38197,-0.30325>,<-0.1883,0.38197,-0.3673>,<-0.1078,0.38197,-0.42336>,
            <-0.01047,0.38197,-0.41985>,<0.07844,0.38197,-0.38802>,<0.16976,0.38197,-0.37623>,
            <0.26379,0.38197,-0.34824>,<0.32173,0.38197,-0.26996>,<0.35227,0.38197,-0.1806>,
            <0.39999,0.38197,-0.10185>,
    /*6*/ <0.37111,0.76394,-0.00925>,<0.3498,0.76394,0.07071>,<0.30662,0.76394,0.13835>,
            <0.27958,0.76394,0.21178>,<0.23862,0.76394,0.28438>,<0.16281,0.76394,0.31758>,
            <0.08301,0.76394,0.32598>,<0.00874,0.76394,0.35063>,<-0.07356,0.76394,0.36387>,
            <-0.14678,0.76394,0.3253>,<-0.20311,0.76394,0.26814>,<-0.26868,0.76394,0.22545>,
            <-0.33035,0.76394,0.16936>,<-0.34584,0.76394,0.08806>,<-0.33628,0.76394,0.00839>,
            <-0.34378,0.76394,-0.0695>,<-0.33838,0.76394,-0.15268>,<-0.28448,0.76394,-0.21549>,
            <-0.21622,0.76394,-0.25769>,<-0.16001,0.76394,-0.31211>,<-0.0916,0.76394,-0.35975>,
            <-0.0089,0.76394,-0.35677>,<0.06665,0.76394,-0.32972>,<0.14425,0.76394,-0.3197>,
            <0.22415,0.76394,-0.29592>,<0.27339,0.76394,-0.2294>,<0.29934,0.76394,-0.15346>,
            <0.33989,0.76394,-0.08655>,
    /*7*/ <0.30924,1.52788,-0.00771>,<0.29148,1.52788,0.05892>,<0.2555,1.52788,0.11529>,
            <0.23297,1.52788,0.17647>,<0.19884,1.52788,0.23697>,<0.13567,1.52788,0.26463>,
            <0.06917,1.52788,0.27164>,<0.00729,1.52788,0.29217>,<-0.06129,1.52788,0.3032>,
            <-0.12231,1.52788,0.27106>,<-0.16925,1.52788,0.22344>,<-0.22388,1.52788,0.18786>,
            <-0.27527,1.52788,0.14112>,<-0.28818,1.52788,0.07338>,<-0.28022,1.52788,0.00699>,
            <-0.28647,1.52788,-0.05791>,<-0.28196,1.52788,-0.12723>,<-0.23705,1.52788,-0.17956>,
            <-0.18018,1.52788,-0.21472>,<-0.13333,1.52788,-0.26007>,<-0.07633,1.52788,-0.29977>,
            <-0.00741,1.52788,-0.29729>,<0.05554,1.52788,-0.27475>,<0.1202,1.52788,-0.2664>,
            <0.18678,1.52788,-0.24658>,<0.22781,1.52788,-0.19115>,<0.24943,1.52788,-0.12788>,
            <0.28322,1.52788,-0.07212>,
    /*8*/ <0.26924,3.05577,-0.00671>,<0.25378,3.05577,0.0513>,<0.22245,3.05577,0.10037>,
            <0.20283,3.05577,0.15364>,<0.17312,3.05577,0.20631>,<0.11812,3.05577,0.2304>,
            <0.06022,3.05577,0.2365>,<0.00634,3.05577,0.25438>,<-0.05337,3.05577,0.26398>,
            <-0.10649,3.05577,0.236>,<-0.14736,3.05577,0.19454>,<-0.19492,3.05577,0.16356>,
            <-0.23966,3.05577,0.12287>,<-0.25091,3.05577,0.06389>,<-0.24397,3.05577,0.00608>,
            <-0.24941,3.05577,-0.05042>,<-0.24549,3.05577,-0.11077>,<-0.20639,3.05577,-0.15633>,
            <-0.15687,3.05577,-0.18695>,<-0.11609,3.05577,-0.22643>,<-0.06646,3.05577,-0.261>,
            <-0.00645,3.05577,-0.25883>,<0.04836,3.05577,-0.23921>,<0.10465,3.05577,-0.23194>,
            <0.16262,3.05577,-0.21469>,<0.19834,3.05577,-0.16643>,<0.21717,3.05577,-0.11134>,
            <0.24659,3.05577,-0.06279>,
    /*9*/ <0.23078,6.11153,-0.00576>,<0.21753,6.11153,0.04397>,<0.19067,6.11153,0.08603>,
            <0.17386,6.11153,0.13169>,<0.14839,6.11153,0.17684>,<0.10124,6.11153,0.19749>,
            <0.05162,6.11153,0.20271>,<0.00544,6.11153,0.21804>,<-0.04574,6.11153,0.22627>,
            <-0.09128,6.11153,0.20229>,<-0.1263,6.11153,0.16675>,<-0.16708,6.11153,0.1402>,
            <-0.20543,6.11153,0.10532>,<-0.21506,6.11153,0.05476>,<-0.20912,6.11153,0.00522>,
            <-0.21378,6.11153,-0.04322>,<-0.21042,6.11153,-0.09495>,<-0.1769,6.11153,-0.134>,
            <-0.13446,6.11153,-0.16024>,<-0.0995,6.11153,-0.19409>,<-0.05696,6.11153,-0.22371>,
            <-0.00553,6.11153,-0.22186>,<0.04145,6.11153,-0.20503>,<0.0897,6.11153,-0.1988>,
            <0.13939,6.11153,-0.18402>,<0.17,6.11153,-0.14265>,<0.18614,6.11153,-0.09543>,
            <0.21136,6.11153,-0.05382>,
    /*10*/ <0.15385,12.22307,-0.00384>,<0.14502,12.22307,0.02932>,<0.12711,12.22307,0.05736>,
            <0.11591,12.22307,0.0878>,<0.09892,12.22307,0.11789>,<0.0675,12.22307,0.13166>,
            <0.03441,12.22307,0.13514>,<0.00363,12.22307,0.14536>,<-0.03049,12.22307,0.15085>,
            <-0.06085,12.22307,0.13486>,<-0.0842,12.22307,0.11116>,<-0.11139,12.22307,0.09346>,
            <-0.13695,12.22307,0.07021>,<-0.14338,12.22307,0.03651>,<-0.13941,12.22307,0.00348>,
            <-0.14252,12.22307,-0.02881>,<-0.14028,12.22307,-0.0633>,<-0.11794,12.22307,-0.08933>,
            <-0.08964,12.22307,-0.10683>,<-0.06633,12.22307,-0.12939>,<-0.03798,12.22307,-0.14914>,
            <-0.00369,12.22307,-0.1479>,<0.02763,12.22307,-0.13669>,<0.0598,12.22307,-0.13254>,
            <0.09293,12.22307,-0.12268>,<0.11334,12.22307,-0.0951>,<0.1241,12.22307,-0.06362>,
            <0.14091,12.22307,-0.03588>,
    /*11*/ <0,24.44614,0>

    /* stem 0.0*/ 
    /*0*/ <0,2.01843,0>,
    /*1*/ <0.01724,2.01843,0.07469>,<-0.05619,2.05488,0.03728>,<-0.05197,2.04096,-0.05165>,
            <0.02407,1.99591,-0.0692>,<0.06684,1.98198,0.00888>,
    /*2*/ <1.2024,4.13539,-0.22515>,<1.15344,4.15969,-0.25009>,<1.15625,4.15041,-0.30937>,
            <1.20695,4.12037,-0.32107>,<1.23546,4.11109,-0.26902>,
    /*3*/ <2.14003,6.37993,-0.46784>,<2.11432,6.38955,-0.48003>,<2.1162,6.38587,-0.50978>,
            <2.14307,6.37398,-0.51598>,<2.1578,6.3703,-0.49006>,
    /*4*/ <2.81739,8.72169,-0.65045>

    /* stem 0.0.0*/ 
    /*0*/ <0.20735,2.38701,-0.04787>,
    /*1*/ <0.19018,2.39785,-0.03877>,<0.21556,2.39363,-0.06745>,<0.21629,2.36956,-0.03739>,
            
    /*2*/ <0.79595,2.96987,0.40454>,<0.81287,2.96706,0.38542>,<0.81336,2.95101,0.40546>,
            
    /*3*/ <1.27457,3.67791,0.79951>,<1.2835,3.67712,0.79031>,<1.28476,3.67025,0.80109>,
            
    /*4*/ <1.72418,4.48773,0.98079>

    /* stem 0.0.1*/ 
    /*0*/ <0.30036,2.55235,-0.06934>,
    /*1*/ <0.2879,2.55713,-0.08655>,<0.32205,2.55347,-0.07096>,<0.29113,2.54646,-0.05052>,
            
    /*2*/ <0.26601,3.44485,0.18466>,<0.28878,3.44241,0.19506>,<0.26816,3.43774,0.20868>,
            
    /*3*/ <0.28624,4.34736,0.40026>,<0.29763,4.34597,0.4054>,<0.28733,4.34451,0.41246>,
            
    /*4*/ <0.54846,5.23156,0.51151>

    /* stem 0.0.2*/ 
    /*0*/ <0.39174,2.7148,-0.09044>,
    /*1*/ <0.40271,2.70652,-0.10674>,<0.40207,2.72235,-0.07339>,<0.37045,2.71553,-0.09119>,
            
    /*2*/ <0.44111,3.53385,-0.49208>,<0.44069,3.54441,-0.46985>,<0.41961,3.53986,-0.48171>,
            
    /*3*/ <0.59681,4.38275,-0.79202>,<0.59646,4.38698,-0.78047>,<0.58614,4.38651,-0.78717>,
            
    /*4*/ <0.75215,5.1979,-1.17253>

    /* stem 0.0.3*/ 
    /*0*/ <0.51546,2.93472,-0.119>,
    /*1*/ <0.5321,2.92657,-0.10976>,<0.50703,2.95214,-0.11164>,<0.50726,2.92546,-0.13561>,
            
    /*2*/ <1.05828,3.41132,-0.64445>,<1.04157,3.42837,-0.6457>,<1.04172,3.41058,-0.66168>,
            
    /*3*/ <1.56686,4.02755,-1.04383>,<1.55771,4.03524,-1.0438>,<1.55931,4.02789,-1.05309>,
            
    /*4*/ <2.00535,4.74822,-1.33842>

    /* stem 0.0.4*/ 
    /*0*/ <0.61364,3.10924,-0.14167>,
    /*1*/ <0.61055,3.11351,-0.12215>,<0.60604,3.12133,-0.15599>,<0.62432,3.09288,-0.14687>,
            
    /*2*/ <1.34751,3.58896,-0.1166>,<1.34451,3.59417,-0.13916>,<1.3567,3.57521,-0.13308>,
            
    /*3*/ <1.9562,4.19528,-0.30317>,<1.95226,4.19596,-0.31414>,<1.96069,4.18835,-0.31143>,
            
    /*4*/ <2.42008,4.87964,-0.59756>

    /* stem 0.0.5*/ 
    /*0*/ <0.69328,3.25082,-0.16006>,
    /*1*/ <0.67599,3.26052,-0.1603>,<0.70665,3.25403,-0.17435>,<0.69721,3.23792,-0.14552>,
            
    /*2*/ <1.03152,3.89256,0.30934>,<1.05195,3.88823,0.29997>,<1.04567,3.87749,0.31919>,
            
    /*3*/ <1.29851,4.68065,0.53275>,<1.30873,4.67862,0.52799>,<1.30695,4.6761,0.53902>,
            
    /*4*/ <1.53878,5.49962,0.66482>

    /* stem 0.0.6*/ 
    /*0*/ <0.82493,3.48484,-0.19045>,
    /*1*/ <0.82033,3.48501,-0.20908>,<0.84324,3.48272,-0.18511>,<0.81123,3.4868,-0.17717>,
            
    /*2*/ <0.92391,4.32088,-0.22054>,<0.93918,4.31936,-0.20456>,<0.91784,4.32207,-0.19927>,
            
    /*3*/ <1.13163,5.1376,-0.22939>,<1.13907,5.13587,-0.22137>,<1.12864,5.13855,-0.21877>,
            
    /*4*/ <1.42986,5.92511,-0.19379>

    /* stem 0.0.7*/ 
    /*0*/ <0.91385,3.6429,-0.21098>,
    /*1*/ <0.92818,3.6338,-0.21894>,<0.91702,3.65496,-0.19697>,<0.89634,3.63993,-0.21702>,
            
    /*2*/ <1.00848,4.25097,-0.76466>,<1.00104,4.26508,-0.75002>,<0.98725,4.25506,-0.76338>,
            
    /*3*/ <1.15097,4.92413,-1.22521>,<1.1471,4.93045,-1.2173>,<1.14044,4.92663,-1.22494>,
            
    /*4*/ <1.33933,5.64667,-1.58301>

    /* stem 0.0.8*/ 
    /*0*/ <1.01121,3.81597,-0.23346>,
    /*1*/ <1.02188,3.81182,-0.2192>,<1.00265,3.83212,-0.23408>,<1.00909,3.80397,-0.24709>,
            
    /*2*/ <1.65654,4.13648,-0.60746>,<1.64372,4.15001,-0.61738>,<1.64801,4.13125,-0.62605>,
            
    /*3*/ <2.23551,4.56128,-0.98756>,<2.22818,4.56749,-0.99193>,<2.23133,4.55874,-0.99691>,
            
    /*4*/ <2.78775,5.11671,-1.19837>

    /* stem 0.0.9*/ 
    /*0*/ <1.13103,4.02896,-0.26112>,
    /*1*/ <1.12214,4.03575,-0.24738>,<1.1317,4.03779,-0.27646>,<1.13925,4.01336,-0.25951>,
            
    /*2*/ <1.78188,4.40434,-0.01016>,<1.78825,4.4057,-0.02954>,<1.79328,4.38942,-0.01824>,
            
    /*3*/ <2.35053,4.93283,0.14388>,<2.35306,4.93308,0.13398>,<2.35759,4.92639,0.14025>,
            
    /*4*/ <2.85046,5.54117,0.22891>

    /* stem 0.0.10*/ 
    /*0*/ <1.26655,4.31538,-0.29241>,
    /*1*/ <1.25213,4.32075,-0.29956>,<1.28091,4.31508,-0.30145>,<1.26662,4.31032,-0.27621>,
            
    /*2*/ <1.41278,5.03545,-0.07368>,<1.43197,5.03167,-0.07494>,<1.42244,5.02849,-0.05811>,
            
    /*3*/ <1.60643,5.76315,0.06888>,<1.61592,5.76083,0.06813>,<1.61142,5.76033,0.07682>,
            
    /*4*/ <1.82969,6.49406,0.12723>

    /* stem 0.0.11*/ 
    /*0*/ <1.34016,4.4905,-0.3094>,
    /*1*/ <1.34277,4.48784,-0.32551>,<1.35239,4.49625,-0.29987>,<1.3253,4.48742,-0.30282>,
            
    /*2*/ <1.12877,5.19311,-0.47128>,<1.13518,5.19872,-0.45419>,<1.11712,5.19284,-0.45616>,
            
    /*3*/ <0.95652,5.89732,-0.66544>,<0.95967,5.90048,-0.65699>,<0.95052,5.89796,-0.65804>,
            
    /*4*/ <0.83114,6.59037,-0.92544>

    /* stem 0.0.12*/ 
    /*0*/ <1.468,4.79469,-0.33892>,
    /*1*/ <1.48254,4.78855,-0.33918>,<1.46361,4.80406,-0.327>,<1.45786,4.79145,-0.35056>,
            
    /*2*/ <1.71497,5.36866,-0.70633>,<1.70235,5.37899,-0.69821>,<1.69851,5.37059,-0.71391>,
            
    /*3*/ <1.85635,6.05298,-0.90563>,<1.84931,6.05594,-0.90066>,<1.84807,6.05366,-0.90939>,
            
    /*4*/ <1.95735,6.76202,-1.01939>

    /* stem 0.0.13*/ 
    /*0*/ <1.54734,4.98343,-0.35723>,
    /*1*/ <1.55126,4.98322,-0.34242>,<1.53838,4.99463,-0.36262>,<1.55237,4.97245,-0.36665>,
            
    /*2*/ <2.12374,5.37196,-0.4938>,<2.11516,5.37956,-0.50726>,<2.12449,5.36478,-0.50994>,
            
    /*3*/ <2.57732,5.88248,-0.6858>,<2.57173,5.88515,-0.69211>,<2.57785,5.87903,-0.69393>,
            
    /*4*/ <2.99164,6.4478,-0.7844>

    /* stem 0.0.14*/ 
    /*0*/ <1.67179,5.27953,-0.38596>,
    /*1*/ <1.66002,5.28512,-0.37937>,<1.67626,5.28497,-0.39875>,<1.67908,5.26851,-0.37977>,
            
    /*2*/ <2.06073,5.73058,-0.05244>,<2.07156,5.73048,-0.06536>,<2.07344,5.71951,-0.05271>,
            
    /*3*/ <2.30002,6.30985,0.21231>,<2.30572,6.31038,0.20612>,<2.30761,6.30633,0.21326>,
            
    /*4*/ <2.48493,6.93058,0.42677>

    /* stem 0.0.15*/ 
    /*0*/ <1.74198,5.44654,-0.40217>,
    /*1*/ <1.7332,5.44918,-0.413>,<1.75593,5.44869,-0.40365>,<1.73681,5.44176,-0.38985>,
            
    /*2*/ <1.66198,6.07699,-0.19615>,<1.67713,6.07666,-0.18992>,<1.66438,6.07203,-0.18071>,
            
    /*3*/ <1.6573,6.72005,-0.01478>,<1.66491,6.71932,-0.01182>,<1.65848,6.7179,-0.00695>,
            
    /*4*/ <1.6601,7.34378,0.22541>

    /* stem 0.0.16*/ 
    /*0*/ <1.87861,5.77161,-0.43371>,
    /*1*/ <1.88569,5.7676,-0.44438>,<1.88489,5.77686,-0.42308>,<1.86525,5.77037,-0.43367>,
            
    /*2*/ <1.82851,6.35266,-0.69664>,<1.82798,6.35883,-0.68245>,<1.81488,6.3545,-0.68951>,
            
    /*3*/ <1.75734,6.95798,-0.89346>,<1.75711,6.9604,-0.8861>,<1.75056,6.95844,-0.88974>,
            
    /*4*/ <1.69533,7.5807,-1.02773>

    /* stem 0.0.17*/ 
    /*0*/ <1.95917,5.96329,-0.45231>,
    /*1*/ <1.97027,5.95914,-0.44705>,<1.95278,5.97321,-0.44695>,<1.95447,5.95752,-0.46292>,
            
    /*2*/ <2.28515,6.35885,-0.80648>,<2.27349,6.36823,-0.80641>,<2.27462,6.35777,-0.81706>,
            
    /*3*/ <2.55858,6.83296,-1.10508>,<2.55228,6.83697,-1.10456>,<2.55343,6.83257,-1.1105>,
            
    /*4*/ <2.78152,7.3861,-1.28572>

    /* stem 0.0.18*/ 
    /*0*/ <2.09006,6.2747,-0.48253>,
    /*1*/ <2.08831,6.2766,-0.47057>,<2.08564,6.28267,-0.49069>,<2.09622,6.26484,-0.48633>,
            
    /*2*/ <2.59816,6.58423,-0.44912>,<2.59638,6.58828,-0.46253>,<2.60343,6.57639,-0.45962>,
            
    /*3*/ <2.99426,7.02614,-0.50863>,<2.99216,7.02718,-0.51529>,<2.99741,7.02266,-0.51391>,
            
    /*4*/ <3.32049,7.522,-0.46644>

    /* stem 0.0.19*/ 
    /*0*/ <2.15421,6.44824,-0.49734>,
    /*1*/ <2.14287,6.45159,-0.49683>,<2.16114,6.45213,-0.50612>,<2.15863,6.44101,-0.48907>,
            
    /*2*/ <2.29662,6.91026,-0.17509>,<2.3088,6.91062,-0.18128>,<2.30712,6.90321,-0.16991>,
            
    /*3*/ <2.52291,7.41695,-0.00025>,<2.52849,7.4158,-0.00401>,<2.52825,7.41367,0.00248>,
            
    /*4*/ <2.77458,7.93315,0.08895>

    /* stem 0.0.20*/ 
    /*0*/ <2.22562,6.69304,-0.51383>,
    /*1*/ <2.22253,6.69321,-0.52469>,<2.23634,6.6952,-0.51096>,<2.218,6.6907,-0.50582>,
            
    /*2*/ <2.10187,7.2386,-0.47795>,<2.11108,7.23993,-0.4688>,<2.09885,7.23693,-0.46537>,
            
    /*3*/ <2.07358,7.79729,-0.43885>,<2.07827,7.79725,-0.43432>,<2.07201,7.79681,-0.43254>,
            
    /*4*/ <2.18005,8.3473,-0.416>

    /* stem 0.0.21*/ 
    /*0*/ <2.30252,6.95666,-0.53158>,
    /*1*/ <2.31148,6.9537,-0.53668>,<2.30311,6.96102,-0.5218>,<2.29297,6.95525,-0.53626>,
            
    /*2*/ <2.34447,7.44456,-0.75571>,<2.33889,7.44944,-0.74578>,<2.33213,7.44559,-0.75542>,
            
    /*3*/ <2.42296,7.94473,-0.9385>,<2.42017,7.94704,-0.93348>,<2.41685,7.94571,-0.93853>,
            
    /*4*/ <2.51718,8.4309,-1.14955>

    /* stem 0.0.22*/ 
    /*0*/ <2.36412,7.16781,-0.5458>,
    /*1*/ <2.37079,7.16639,-0.53812>,<2.3564,7.1745,-0.54472>,<2.36517,7.16255,-0.55456>,
            
    /*2*/ <2.67022,7.54588,-0.73214>,<2.66063,7.55129,-0.73654>,<2.66648,7.54332,-0.7431>,
            
    /*3*/ <2.91206,7.98214,-0.88277>,<2.90693,7.98433,-0.88476>,<2.9104,7.98116,-0.88837>,
            
    /*4*/ <3.10137,8.45573,-0.98876>

    /* stem 0.0.23*/ 
    /*0*/ <2.43584,7.4137,-0.56236>,
    /*1*/ <2.43055,7.41578,-0.55444>,<2.43428,7.41854,-0.57067>,<2.4427,7.40678,-0.56196>,
            
    /*2*/ <2.77036,7.75793,-0.42097>,<2.77285,7.75977,-0.43179>,<2.77846,7.75193,-0.42598>,
            
    /*3*/ <3.07644,8.15501,-0.42047>,<3.07674,8.15483,-0.42608>,<3.08045,8.15196,-0.42298>,
            
    /*4*/ <3.27204,8.61164,-0.47927>

    /* stem 0.0.24*/ 
    /*0*/ <2.50556,7.65269,-0.57845>,
    /*1*/ <2.4973,7.65486,-0.58199>,<2.51324,7.65424,-0.58336>,<2.50614,7.64897,-0.57001>,
            
    /*2*/ <2.53377,8.09355,-0.38964>,<2.5444,8.09313,-0.39055>,<2.53967,8.08962,-0.38165>,
            
    /*3*/ <2.60031,8.55327,-0.26738>,<2.60558,8.5527,-0.26798>,<2.60331,8.55177,-0.26324>,
            
    /*4*/ <2.73607,8.99228,-0.1257>

    /* stem 0.0.25*/ 
    /*0*/ <2.57125,7.8779,-0.59362>,
    /*1*/ <2.57249,7.87696,-0.60226>,<2.57792,7.88038,-0.58848>,<2.56335,7.87637,-0.59013>,
            
    /*2*/ <2.45764,8.31973,-0.66409>,<2.46125,8.32201,-0.6549>,<2.45154,8.31933,-0.656>,
            
    /*3*/ <2.47119,8.76847,-0.7681>,<2.47304,8.76951,-0.7635>,<2.46803,8.76948,-0.76427>,
            
    /*4*/ <2.48775,9.20809,-0.90703>

    /* stem 0.0.26*/ 
    /*0*/ <2.66041,8.18355,-0.6142>,
    /*1*/ <2.66603,8.18189,-0.61456>,<2.65854,8.18659,-0.60954>,<2.65667,8.18217,-0.61851>,
            
    /*2*/ <2.76162,8.55527,-0.81849>,<2.75663,8.55841,-0.81515>,<2.75538,8.55546,-0.82113>,
            
    /*3*/ <2.84248,8.96301,-0.95107>,<2.83987,8.96414,-0.94922>,<2.83938,8.96319,-0.95244>,
            
    /*4*/ <2.92545,9.38362,-1.0309>

    /* stem 0.0.27*/ 
    /*0*/ <2.72037,8.38909,-0.62805>,
    /*1*/ <2.72142,8.38902,-0.62457>,<2.71751,8.39109,-0.62904>,<2.72218,8.38716,-0.63053>,
            
    /*2*/ <2.97383,8.71574,-0.69537>,<2.97122,8.71712,-0.69834>,<2.97433,8.7145,-0.69934>,
            
    /*3*/ <3.15485,9.09315,-0.69108>,<3.15352,9.09381,-0.69256>,<3.15534,9.09294,-0.69311>,
            
    /*4*/ <3.35913,9.45882,-0.69581>

    /* stem 0.0.28*/ 
    /*0*/ <2.79575,8.6475,-0.64545>,
    /*1*/ <2.79508,8.64772,-0.64505>,<2.7959,8.6478,-0.64619>,<2.79627,8.64698,-0.64511>,
            
    /*2*/ <2.99299,8.95106,-0.48174>,<2.99354,8.95111,-0.48249>,<2.99378,8.95056,-0.48178>,
            
    /*3*/ <3.10192,9.2915,-0.30856>,<3.10221,9.29158,-0.30891>,<3.10236,9.29135,-0.30853>,
            
    /*4*/ <3.19887,9.65732,-0.1876>

    /* stem 0.1*/ 
    /*0*/ <0,2.7972,0>,
    /*1*/ <-0.06874,2.7972,0.03353>,<-0.04886,2.83357,-0.04626>,<0.03855,2.81968,-0.06211>,
            <0.07268,2.77473,0.00787>,<0.00637,2.76084,0.06698>,
    /*2*/ <0.48904,4.91051,1.11898>,<0.50229,4.93475,1.0658>,<0.56056,4.92549,1.05522>,
            <0.58332,4.89552,1.10188>,<0.53911,4.88626,1.14128>,
    /*3*/ <0.93565,7.15117,1.97652>,<0.94172,7.16077,1.94879>,<0.97107,7.1571,1.94393>,
            <0.98313,7.14523,1.96867>,<0.96124,7.14156,1.9888>,
    /*4*/ <1.26536,9.48889,2.59438>

    /* stem 0.1.0*/ 
    /*0*/ <0.08828,3.14601,0.181>,
    /*1*/ <0.07555,3.15685,0.16632>,<0.11032,3.14902,0.18098>,<0.07897,3.13216,0.19571>,
            
    /*2*/ <-0.01704,3.86647,0.7818>,<0.00614,3.86125,0.79157>,<-0.01477,3.85,0.80139>,
            
    /*3*/ <-0.01672,4.72057,1.17759>,<-0.00509,4.71834,1.18259>,<-0.01564,4.71526,1.18924>,
            
    /*4*/ <0.08297,5.60068,1.5037>

    /* stem 0.1.1*/ 
    /*0*/ <0.12607,3.29533,0.25849>,
    /*1*/ <0.14007,3.30011,0.24244>,<0.13349,3.29141,0.27863>,<0.10465,3.29446,0.25438>,
            
    /*2*/ <0.05992,4.20286,0.45154>,<0.05553,4.19705,0.47567>,<0.03631,4.19909,0.4595>,
            
    /*3*/ <-0.05998,5.10597,0.63967>,<-0.06221,5.10325,0.65177>,<-0.07175,5.10369,0.64355>,
            
    /*4*/ <-0.2205,5.97909,0.91977>

    /* stem 0.1.2*/ 
    /*0*/ <0.17238,3.47828,0.35342>,
    /*1*/ <0.19072,3.47,0.36043>,<0.15699,3.48334,0.36727>,<0.16942,3.4815,0.33256>,
            
    /*2*/ <0.53317,4.31295,0.43857>,<0.51068,4.32184,0.44312>,<0.51897,4.32062,0.41999>,
            
    /*3*/ <0.86318,5.11938,0.7084>,<0.85177,5.1234,0.71063>,<0.85682,5.12505,0.69953>,
            
    /*4*/ <1.1514,5.91073,1.06149>

    /* stem 0.1.3*/ 
    /*0*/ <0.23324,3.71878,0.47822>,
    /*1*/ <0.228,3.71064,0.49645>,<0.2223,3.73441,0.47036>,<0.24944,3.71128,0.46785>,
            
    /*2*/ <0.76348,4.295,0.90344>,<0.75968,4.31085,0.88605>,<0.77778,4.29543,0.88438>,
            
    /*3*/ <1.25947,4.9279,1.28826>,<1.25714,4.93533,1.27924>,<1.26665,4.92817,1.27875>,
            
    /*4*/ <1.60907,5.63665,1.69924>

    /* stem 0.1.4*/ 
    /*0*/ <0.27103,3.86806,0.55569>,
    /*1*/ <0.25131,3.87234,0.55707>,<0.28339,3.8805,0.54562>,<0.27838,3.85134,0.56438>,
            
    /*2*/ <0.40703,4.32028,1.29502>,<0.42841,4.32573,1.28739>,<0.42508,4.30629,1.29989>,
            
    /*3*/ <0.445,4.85315,1.98826>,<0.45581,4.8564,1.98527>,<0.45421,4.84727,1.99238>,
            
    /*4*/ <0.44662,5.52069,2.55664>

    /* stem 0.1.5*/ 
    /*0*/ <0.30851,4.01616,0.63254>,
    /*1*/ <0.30486,4.02585,0.61565>,<0.32601,4.01828,0.64159>,<0.29467,4.00435,0.64038>,
            
    /*2*/ <-0.00758,4.68929,1.07161>,<0.00653,4.68424,1.0889>,<-0.01437,4.67496,1.0881>,
            
    /*3*/ <-0.24772,5.3891,1.51645>,<-0.24055,5.38628,1.5249>,<-0.25134,5.38249,1.52505>,
            
    /*4*/ <-0.26237,6.19211,1.83115>

    /* stem 0.1.6*/ 
    /*0*/ <0.36825,4.25221,0.75503>,
    /*1*/ <0.38535,4.25238,0.74637>,<0.36714,4.24969,0.774>,<0.35226,4.25456,0.74472>,
            
    /*2*/ <0.42896,5.08487,0.86267>,<0.41682,5.08308,0.88109>,<0.4069,5.08633,0.86157>,
            
    /*3*/ <0.3957,5.88608,1.12511>,<0.38951,5.88307,1.13377>,<0.38467,5.88598,1.12425>,
            
    /*4*/ <0.44902,6.64297,1.48894>

    /* stem 0.1.7*/ 
    /*0*/ <0.41302,4.42907,0.84681>,
    /*1*/ <0.42396,4.42001,0.85894>,<0.39802,4.4384,0.85292>,<0.41706,4.4288,0.82857>,
            
    /*2*/ <0.88052,5.10194,0.94698>,<0.86323,5.11421,0.94297>,<0.87592,5.10781,0.92673>,
            
    /*3*/ <1.26716,5.823,1.06059>,<1.25802,5.82832,1.05844>,<1.26486,5.82591,1.05046>,
            
    /*4*/ <1.43458,6.61853,1.20938>

    /* stem 0.1.8*/ 
    /*0*/ <0.45312,4.58754,0.92904>,
    /*1*/ <0.44165,4.5834,0.94262>,<0.44963,4.60178,0.91816>,<0.46809,4.57745,0.92634>,
            
    /*2*/ <0.86192,5.06885,1.43759>,<0.86724,5.0811,1.42128>,<0.87955,5.06489,1.42674>,
            
    /*3*/ <1.14137,5.68406,1.88496>,<1.14361,5.68949,1.87621>,<1.15085,5.68311,1.88046>,
            
    /*4*/ <1.46071,6.31953,2.27528>

    /* stem 0.1.9*/ 
    /*0*/ <0.50617,4.79712,1.03779>,
    /*1*/ <0.4908,4.8039,1.03223>,<0.52143,4.80454,1.03281>,<0.50627,4.78292,1.04834>,
            
    /*2*/ <0.47398,5.2733,1.66913>,<0.4944,5.27373,1.66952>,<0.48429,5.25932,1.67988>,
            
    /*3*/ <0.48712,5.93175,2.10496>,<0.49734,5.93172,2.10482>,<0.49232,5.92688,2.11228>,
            
    /*4*/ <0.54126,6.67267,2.37653>

    /* stem 0.1.10*/ 
    /*0*/ <0.56831,5.0874,1.16522>,
    /*1*/ <0.57203,5.09276,1.14958>,<0.58052,5.0863,1.17692>,<0.55239,5.08315,1.16915>,
            
    /*2*/ <0.43091,5.81247,1.36882>,<0.43657,5.80816,1.38704>,<0.41782,5.80606,1.38187>,
            
    /*3*/ <0.39849,6.53557,1.61803>,<0.40141,6.5327,1.62692>,<0.39187,6.53302,1.62476>,
            
    /*4*/ <0.49554,7.21692,1.95426>

    /* stem 0.1.11*/ 
    /*0*/ <0.5948,5.22749,1.21953>,
    /*1*/ <0.61114,5.22481,1.21845>,<0.58818,5.23274,1.23381>,<0.58509,5.22491,1.20632>,
            
    /*2*/ <0.70844,5.94028,1.0038>,<0.69313,5.94556,1.01404>,<0.69107,5.94034,0.99572>,
            
    /*3*/ <0.83487,6.66468,0.84207>,<0.82721,6.66723,0.84722>,<0.82627,6.66531,0.83788>,
            
    /*4*/ <0.94082,7.40399,0.74249>

    /* stem 0.1.12*/ 
    /*0*/ <0.64647,5.50075,1.32547>,
    /*1*/ <0.65003,5.49456,1.33969>,<0.63602,5.5127,1.32438>,<0.65337,5.49498,1.31234>,
            
    /*2*/ <1.19171,5.97825,1.40864>,<1.18237,5.99034,1.39843>,<1.19394,5.97853,1.3904>,
            
    /*3*/ <1.63277,6.55072,1.51083>,<1.62733,6.55593,1.50556>,<1.63428,6.55125,1.50178>,
            
    /*4*/ <2.03335,7.15891,1.56091>

    /* stem 0.1.13*/ 
    /*0*/ <0.70483,5.80934,1.44511>,
    /*1*/ <0.69143,5.80913,1.45219>,<0.70824,5.8207,1.43568>,<0.71482,5.79818,1.44747>,
            
    /*2*/ <0.97286,6.17038,1.98502>,<0.98407,6.1781,1.97401>,<0.98845,6.16309,1.98187>,
            
    /*3*/ <1.18046,6.7419,2.33763>,<1.18536,6.74438,2.33082>,<1.18879,6.73929,2.33706>,
            
    /*4*/ <1.36783,7.37598,2.57602>

    /* stem 0.1.14*/ 
    /*0*/ <0.74253,6.00872,1.52241>,
    /*1*/ <0.73341,6.01434,1.51238>,<0.7561,6.01411,1.52382>,<0.73808,5.99772,1.53103>,
            
    /*2*/ <0.50855,6.46558,1.97642>,<0.52368,6.46543,1.98405>,<0.51166,6.4545,1.98885>,
            
    /*3*/ <0.2431,6.98421,2.33369>,<0.25028,6.9849,2.33812>,<0.24408,6.97983,2.34087>,
            
    /*4*/ <0.16482,7.55669,2.70332>

    /* stem 0.1.15*/ 
    /*0*/ <0.79679,6.29568,1.63367>,
    /*1*/ <0.80524,6.29828,1.62284>,<0.80136,6.29764,1.64673>,<0.78377,6.29112,1.63143>,
            
    /*2*/ <0.58711,6.92124,1.60814>,<0.58453,6.92081,1.62406>,<0.5728,6.91646,1.61386>,
            
    /*3*/ <0.45599,7.56347,1.68908>,<0.45494,7.56231,1.697>,<0.44867,7.56166,1.69196>,
            
    /*4*/ <0.38397,8.20724,1.81656>

    /* stem 0.1.16*/ 
    /*0*/ <0.83798,6.51347,1.71811>,
    /*1*/ <0.85,6.50945,1.72262>,<0.82875,6.51809,1.72675>,<0.83518,6.51288,1.70495>,
            
    /*2*/ <1.0732,7.10569,1.64605>,<1.05903,7.11144,1.6488>,<1.06332,7.10797,1.63428>,
            
    /*3*/ <1.35972,7.67661,1.60402>,<1.35295,7.68016,1.60538>,<1.35509,7.67855,1.59809>,
            
    /*4*/ <1.49018,8.29876,1.69378>

    /* stem 0.1.17*/ 
    /*0*/ <0.88718,6.77365,1.81898>,
    /*1*/ <0.88457,6.76954,1.83086>,<0.88051,6.78342,1.81396>,<0.89644,6.76801,1.81211>,
            
    /*2*/ <1.29843,7.17051,2.05572>,<1.29572,7.17976,2.04446>,<1.30635,7.16949,2.04322>,
            
    /*3*/ <1.59858,7.6722,2.25904>,<1.59654,7.67593,2.25297>,<1.6029,7.67211,2.25302>,
            
    /*4*/ <1.79939,8.23295,2.42676>

    /* stem 0.1.18*/ 
    /*0*/ <0.94638,7.08677,1.94037>,
    /*1*/ <0.93446,7.08864,1.94136>,<0.95288,7.09314,1.93238>,<0.95181,7.07852,1.94739>,
            
    /*2*/ <1.03729,7.50205,2.35139>,<1.04957,7.50505,2.34541>,<1.04886,7.4953,2.35541>,
            
    /*3*/ <1.16933,7.98266,2.67016>,<1.17529,7.98344,2.66658>,<1.17519,7.9796,2.67242>,
            
    /*4*/ <1.25244,8.50401,2.93568>

    /* stem 0.1.19*/ 
    /*0*/ <0.97784,7.29803,2.00486>,
    /*1*/ <0.97484,7.30132,1.99411>,<0.98862,7.30001,2.00876>,<0.97005,7.29276,2.01172>,
            
    /*2*/ <0.80884,7.81006,2.20006>,<0.81803,7.80919,2.20983>,<0.80564,7.80435,2.2118>,
            
    /*3*/ <0.7025,8.36575,2.28357>,<0.707,8.3659,2.28856>,<0.70057,8.36447,2.28988>,
            
    /*4*/ <0.68376,8.93169,2.37493>

    /* stem 0.1.20*/ 
    /*0*/ <1.008,7.52784,2.0667>,
    /*1*/ <1.01774,7.52801,2.06132>,<1.00775,7.5285,2.07781>,<0.99849,7.52702,2.06096>,
            
    /*2*/ <0.98672,8.08046,2.02992>,<0.98006,8.08079,2.04092>,<0.97388,8.0798,2.02968>,
            
    /*3*/ <1.05101,8.62982,2.04852>,<1.04772,8.63006,2.05404>,<1.04463,8.63061,2.04843>,
            
    /*4*/ <1.16019,9.16538,2.14001>

    /* stem 0.1.21*/ 
    /*0*/ <1.03144,7.70647,2.11476>,
    /*1*/ <1.03844,7.70351,2.12236>,<1.02316,7.71284,2.11728>,<1.03272,7.70306,2.10465>,
            
    /*2*/ <1.33725,8.13858,2.0116>,<1.32706,8.1448,2.00821>,<1.33344,8.13828,1.9998>,
            
    /*3*/ <1.567,8.62156,1.93928>,<1.56151,8.62397,1.9377>,<1.5652,8.62156,1.93334>,
            
    /*4*/ <1.7631,9.12374,1.94224>

    /* stem 0.1.22*/ 
    /*0*/ <1.06662,7.97456,2.1869>,
    /*1*/ <1.0607,7.97315,2.19505>,<1.06463,7.98214,2.18042>,<1.07454,7.9684,2.18524>,
            
    /*2*/ <1.36592,8.28894,2.46765>,<1.36854,8.29493,2.45789>,<1.37515,8.28577,2.46111>,
            
    /*3*/ <1.62295,8.62803,2.76021>,<1.62436,8.63114,2.75543>,<1.62791,8.62684,2.75729>,
            
    /*4*/ <1.82968,9.0256,3.01796>

    /* stem 0.1.23*/ 
    /*0*/ <1.09549,8.19454,2.24609>,
    /*1*/ <1.08663,8.19661,2.24273>,<1.10324,8.19915,2.2425>,<1.09661,8.18787,2.25305>,
            
    /*2*/ <1.04025,8.54978,2.59153>,<1.05132,8.55147,2.59138>,<1.0469,8.54395,2.59841>,
            
    /*3*/ <1.00983,8.90839,2.93674>,<1.01538,8.9091,2.93654>,<1.01315,8.90544,2.94014>,
            
    /*4*/ <0.9781,9.35686,3.15118>

    /* stem 0.1.24*/ 
    /*0*/ <1.1216,8.39344,2.29961>,
    /*1*/ <1.12319,8.39562,2.29073>,<1.12814,8.39498,2.30602>,<1.11346,8.38971,2.30209>,
            
    /*2*/ <0.94391,8.83589,2.36994>,<0.94721,8.83547,2.38013>,<0.93742,8.83195,2.37751>,
            
    /*3*/ <0.86268,9.30964,2.37884>,<0.86427,9.30984,2.38396>,<0.85911,9.30898,2.38279>,
            
    /*4*/ <0.81652,9.78872,2.40436>

    /* stem 0.1.25*/ 
    /*0*/ <1.15593,8.65507,2.37001>,
    /*1*/ <1.16459,8.65413,2.36928>,<1.15243,8.65747,2.37765>,<1.15078,8.6536,2.36311>,
            
    /*2*/ <1.19931,9.09644,2.24751>,<1.1912,9.09867,2.25309>,<1.1901,9.09609,2.24339>,
            
    /*3*/ <1.21551,9.53854,2.12038>,<1.21145,9.53953,2.1232>,<1.2109,9.53816,2.11837>,
            
    /*4*/ <1.21166,9.99241,2.04416>

    /* stem 0.1.26*/ 
    /*0*/ <1.18587,8.88316,2.43139>,
    /*1*/ <1.18768,8.88129,2.43746>,<1.18034,8.88667,2.43053>,<1.18958,8.88152,2.42618>,
            
    /*2*/ <1.41697,9.25539,2.48197>,<1.41207,9.25898,2.47735>,<1.41824,9.25554,2.47445>,
            
    /*3*/ <1.60267,9.65293,2.52809>,<1.60008,9.65443,2.52574>,<1.60335,9.65307,2.52433>,
            
    /*4*/ <1.76249,10.05343,2.6198>

    /* stem 0.1.27*/ 
    /*0*/ <1.22637,9.1918,2.51444>,
    /*1*/ <1.22356,9.19173,2.51605>,<1.22686,9.194,2.51211>,<1.2287,9.18966,2.51515>,
            
    /*2*/ <1.37995,9.45432,2.79715>,<1.38215,9.45584,2.79453>,<1.38338,9.45294,2.79655>,
            
    /*3*/ <1.551,9.73218,3.05421>,<1.55205,9.73284,3.0528>,<1.55269,9.73145,3.05387>,
            
    /*4*/ <1.70472,10.06766,3.24473>

    /* stem 0.1.28*/ 
    /*0*/ <1.25018,9.37321,2.56325>,
    /*1*/ <1.24934,9.37356,2.56238>,<1.25134,9.3737,2.56324>,<1.24986,9.37238,2.56414>,
            
    /*2*/ <1.12634,9.67231,2.79838>,<1.12767,9.6724,2.79896>,<1.12668,9.67152,2.79956>,
            
    /*3*/ <1.07154,9.98087,3.04728>,<1.07223,9.98082,3.04749>,<1.07171,9.98045,3.04784>,
            
    /*4*/ <1.02633,10.33831,3.22112>

    /* stem 0.2*/ 
    /*0*/ <0,3.33097,0>,
    /*1*/ <-0.04797,3.33097,-0.05924>,<0.03397,3.36722,-0.05782>,<0.06897,3.35337,0.02351>,
            <0.00865,3.30857,0.07235>,<-0.06362,3.29472,0.02121>,
    /*2*/ <-0.97778,5.43891,0.7264>,<-0.92316,5.46308,0.72735>,<-0.89983,5.45385,0.78157>,
            <-0.94003,5.42398,0.81413>,<-0.98821,5.41474,0.78003>,
    /*3*/ <-1.71102,7.67389,1.35286>,<-1.68273,7.68346,1.35254>,<-1.67144,7.6798,1.37995>,
            <-1.69275,7.66797,1.39721>,<-1.71722,7.66432,1.38047>,
    /*4*/ <-2.23755,10.00567,1.81193>

    /* stem 0.2.0*/ 
    /*0*/ <-0.13299,3.62738,0.1077>,
    /*1*/ <-0.12152,3.63825,0.09194>,<-0.13083,3.63324,0.12913>,<-0.14663,3.61065,0.10202>,
            
    /*2*/ <-0.83886,4.24866,0.00121>,<-0.84507,4.24532,0.026>,<-0.8556,4.23026,0.00793>,
            
    /*3*/ <-1.46364,4.95875,0.01295>,<-1.4661,4.95649,0.02539>,<-1.47301,4.95056,0.01627>,
            
    /*4*/ <-1.96747,5.75538,0.09105>

    /* stem 0.2.1*/ 
    /*0*/ <-0.20691,3.79212,0.16755>,
    /*1*/ <-0.1881,3.79691,0.1776>,<-0.2258,3.79364,0.17843>,<-0.20683,3.7858,0.14663>,
            
    /*2*/ <-0.2771,4.68295,-0.09416>,<-0.30224,4.68078,-0.0936>,<-0.28959,4.67555,-0.1148>,
            
    /*3*/ <-0.41015,5.58839,-0.26428>,<-0.42265,5.58673,-0.26385>,<-0.4165,5.58557,-0.2748>,
            
    /*4*/ <-0.56206,6.48685,-0.45652>

    /* stem 0.2.2*/ 
    /*0*/ <-0.30516,4.01108,0.24711>,
    /*1*/ <-0.30785,4.00283,0.26649>,<-0.32191,4.01826,0.2362>,<-0.28571,4.01216,0.23864>,
            
    /*2*/ <-0.19269,4.83111,0.62743>,<-0.20206,4.8414,0.60723>,<-0.17793,4.83734,0.60886>,
            
    /*3*/ <-0.20133,5.63916,1.04508>,<-0.20606,5.64439,1.03505>,<-0.1939,5.64378,1.03649>,
            
    /*4*/ <-0.36977,6.4624,1.39739>

    /* stem 0.2.3*/ 
    /*0*/ <-0.40448,4.23246,0.32754>,
    /*1*/ <-0.42341,4.22433,0.32653>,<-0.40005,4.24961,0.31699>,<-0.38999,4.22343,0.33911>,
            
    /*2*/ <-0.66631,4.72079,1.02459>,<-0.65073,4.73764,1.01823>,<-0.64403,4.72019,1.03297>,
            
    /*3*/ <-0.93083,5.34794,1.59919>,<-0.92258,5.35541,1.59496>,<-0.91997,5.34818,1.60405>,
            
    /*4*/ <-1.14818,6.07097,2.07226>

    /* stem 0.2.4*/ 
    /*0*/ <-0.49348,4.4308,0.39961>,
    /*1*/ <-0.49922,4.43504,0.38085>,<-0.48,4.44245,0.40886>,<-0.50122,4.41491,0.40913>,
            
    /*2*/ <-1.14133,4.9332,0.69706>,<-1.12852,4.93813,0.71573>,<-1.14267,4.91978,0.71591>,
            
    /*3*/ <-1.667,5.57485,0.96401>,<-1.66008,5.57685,0.97309>,<-1.66882,5.5693,0.97402>,
            
    /*4*/ <-1.95735,6.38256,1.11465>

    /* stem 0.2.5*/ 
    /*0*/ <-0.56352,4.58691,0.45633>,
    /*1*/ <-0.54802,4.59651,0.44903>,<-0.56663,4.58657,0.47572>,<-0.57592,4.57764,0.44424>,
            
    /*2*/ <-1.025,5.30667,0.38835>,<-1.0374,5.30005,0.40614>,<-1.04359,5.29409,0.38515>,
            
    /*3*/ <-1.5145,6.01084,0.42495>,<-1.5201,6.00657,0.43384>,<-1.5238,6.00455,0.42332>,
            
    /*4*/ <-1.94057,6.74231,0.56131>

    /* stem 0.2.6*/ 
    /*0*/ <-0.63508,4.74639,0.51428>,
    /*1*/ <-0.62277,4.74656,0.52902>,<-0.65397,4.74521,0.51755>,<-0.6285,4.74741,0.49626>,
            
    /*2*/ <-0.67439,5.58749,0.55422>,<-0.69518,5.58659,0.54658>,<-0.67821,5.58806,0.53238>,
            
    /*3*/ <-0.95916,6.38266,0.58301>,<-0.96895,6.37938,0.57896>,<-0.96087,6.38253,0.57206>,
            
    /*4*/ <-1.30157,7.15031,0.64693>

    /* stem 0.2.7*/ 
    /*0*/ <-0.7136,4.92139,0.57786>,
    /*1*/ <-0.72298,4.9123,0.59128>,<-0.72281,4.93227,0.56573>,<-0.695,4.91959,0.57657>,
            
    /*2*/ <-0.62223,5.56191,1.09261>,<-0.62213,5.57522,1.07557>,<-0.60358,5.56677,1.0828>,
            
    /*3*/ <-0.67486,6.22454,1.58259>,<-0.67482,6.23102,1.57394>,<-0.6655,6.22827,1.57867>,
            
    /*4*/ <-0.76136,6.93118,2.00367>

    /* stem 0.2.8*/ 
    /*0*/ <-0.8164,5.15051,0.66111>,
    /*1*/ <-0.83209,5.1464,0.65305>,<-0.80806,5.16611,0.65726>,<-0.80906,5.13902,0.67301>,
            
    /*2*/ <-1.22847,5.50967,1.25292>,<-1.21245,5.52281,1.25573>,<-1.21311,5.50475,1.26623>,
            
    /*3*/ <-1.61162,6.09673,1.64889>,<-1.60278,6.1023,1.64931>,<-1.60511,6.0956,1.65699>,
            
    /*4*/ <-2.05791,6.73473,1.85163>

    /* stem 0.2.9*/ 
    /*0*/ <-0.91345,5.36679,0.73969>,
    /*1*/ <-0.9115,5.37351,0.72362>,<-0.90374,5.37286,0.75296>,<-0.9251,5.35401,0.7425>,
            
    /*2*/ <-1.46331,5.90838,0.88657>,<-1.45813,5.90795,0.90613>,<-1.47237,5.89538,0.89915>,
            
    /*3*/ <-1.93678,6.50105,1.09119>,<-1.93369,6.50028,1.10079>,<-1.9417,6.49498,1.09762>,
            
    /*4*/ <-2.29307,7.18994,1.21001>

    /* stem 0.2.10*/ 
    /*0*/ <-1.00308,5.60978,0.81228>,
    /*1*/ <-0.98705,5.61513,0.81239>,<-1.01168,5.60857,0.82678>,<-1.01052,5.60565,0.79768>,
            
    /*2*/ <-1.2322,6.3341,0.73045>,<-1.24862,6.32973,0.74004>,<-1.24784,6.32778,0.72064>,
            
    /*3*/ <-1.43205,7.06559,0.81789>,<-1.44008,7.06288,0.82273>,<-1.44036,7.06396,0.81303>,
            
    /*4*/ <-1.60467,7.80853,0.85846>

    /* stem 0.2.11*/ 
    /*0*/ <-1.08134,5.84323,0.87565>,
    /*1*/ <-1.0767,5.8406,0.89107>,<-1.09716,5.84513,0.87211>,<-1.07017,5.84396,0.86378>,
            
    /*2*/ <-1.01369,6.57478,0.9915>,<-1.02733,6.5778,0.97886>,<-1.00935,6.57702,0.9733>,
            
    /*3*/ <-0.97909,7.296,1.16563>,<-0.98592,7.29789,1.15942>,<-0.97689,7.29811,1.15672>,
            
    /*4*/ <-1.06664,8.00115,1.38484>

    /* stem 0.2.12*/ 
    /*0*/ <-1.1651,6.09308,0.94348>,
    /*1*/ <-1.17798,6.08697,0.95005>,<-1.16635,6.10221,0.93077>,<-1.15097,6.09005,0.94961>,
            
    /*2*/ <-1.23299,6.67057,1.37143>,<-1.22523,6.68073,1.35857>,<-1.21498,6.67262,1.37113>,
            
    /*3*/ <-1.30057,7.35618,1.59257>,<-1.29639,7.35907,1.58506>,<-1.29156,7.35715,1.59249>,
            
    /*4*/ <-1.37546,8.05904,1.74056>

    /* stem 0.2.13*/ 
    /*0*/ <-1.25025,6.3471,1.01244>,
    /*1*/ <-1.26011,6.34689,1.00103>,<-1.23854,6.35659,1.0121>,<-1.25211,6.33782,1.02417>,
            
    /*2*/ <-1.6417,6.83351,1.32858>,<-1.62732,6.83997,1.33597>,<-1.63636,6.82746,1.34401>,
            
    /*3*/ <-1.91572,7.42373,1.58673>,<-1.90794,7.42601,1.58992>,<-1.91344,7.42133,1.59478>,
            
    /*4*/ <-2.04721,8.10264,1.69303>

    /* stem 0.2.14*/ 
    /*0*/ <-1.31409,6.53753,1.06413>,
    /*1*/ <-1.3064,6.54312,1.05303>,<-1.31272,6.54317,1.07754>,<-1.32315,6.5263,1.06181>,
            
    /*2*/ <-1.81701,6.97855,0.92486>,<-1.82123,6.97858,0.9412>,<-1.82818,6.96734,0.93071>,
            
    /*3*/ <-2.27273,7.4759,0.81981>,<-2.27476,7.47584,0.828>,<-2.27892,7.47088,0.82259>,
            
    /*4*/ <-2.71198,7.9952,0.75447>

    /* stem 0.2.15*/ 
    /*0*/ <-1.42295,6.86226,1.15228>,
    /*1*/ <-1.41063,6.86483,1.15802>,<-1.43454,6.86449,1.15949>,<-1.42368,6.85746,1.13933>,
            
    /*2*/ <-1.43752,7.47809,0.92979>,<-1.45346,7.47786,0.93078>,<-1.44622,7.47317,0.91733>,
            
    /*3*/ <-1.46929,8.1118,0.76921>,<-1.47725,8.11158,0.76975>,<-1.47368,8.11,0.76278>,
            
    /*4*/ <-1.47787,8.76346,0.70973>

    /* stem 0.2.16*/ 
    /*0*/ <-1.50625,7.11075,1.21974>,
    /*1*/ <-1.50792,7.1068,1.23226>,<-1.51611,7.11687,1.21336>,<-1.49473,7.10859,1.21359>,
            
    /*2*/ <-1.29302,7.6675,1.43333>,<-1.29848,7.67422,1.42073>,<-1.28422,7.6687,1.42088>,
            
    /*3*/ <-1.10033,8.24534,1.60789>,<-1.1032,8.24829,1.60145>,<-1.09597,8.24582,1.60163>,
            
    /*4*/ <-1.10069,8.84737,1.80345>

    /* stem 0.2.17*/ 
    /*0*/ <-1.56505,7.28616,1.26736>,
    /*1*/ <-1.5772,7.28205,1.26749>,<-1.56182,7.29638,1.2603>,<-1.55614,7.28006,1.27427>,
            
    /*2*/ <-1.69277,7.65305,1.748>,<-1.68251,7.6626,1.7432>,<-1.67873,7.65172,1.75252>,
            
    /*3*/ <-1.81444,8.1196,2.13511>,<-1.80909,8.12365,2.13198>,<-1.80753,8.11927,2.13775>,
            
    /*4*/ <-2.00841,8.59774,2.47435>

    /* stem 0.2.18*/ 
    /*0*/ <-1.64307,7.5189,1.33054>,
    /*1*/ <-1.64676,7.5208,1.31898>,<-1.63509,7.52662,1.33578>,<-1.64737,7.50928,1.33685>,
            
    /*2*/ <-2.09943,7.85377,1.52259>,<-2.09165,7.85765,1.5338>,<-2.09983,7.84608,1.53451>,
            
    /*3*/ <-2.45224,8.28908,1.73132>,<-2.44764,8.29035,1.73656>,<-2.45287,8.28566,1.7375>,
            
    /*4*/ <-2.71646,8.79284,1.91459>

    /* stem 0.2.19*/ 
    /*0*/ <-1.71404,7.7556,1.388>,
    /*1*/ <-1.70415,7.75891,1.38262>,<-1.71577,7.75831,1.3993>,<-1.7222,7.74957,1.3821>,
            
    /*2*/ <-1.95921,8.25292,1.2269>,<-1.96696,8.25252,1.23802>,<-1.97125,8.24669,1.22656>,
            
    /*3*/ <-2.16898,8.78253,1.13443>,<-2.17272,8.78208,1.14006>,<-2.17527,8.78003,1.13412>,
            
    /*4*/ <-2.33763,9.33312,1.09415>

    /* stem 0.2.20*/ 
    /*0*/ <-1.77755,8.02857,1.43943>,
    /*1*/ <-1.77011,8.02873,1.44773>,<-1.78828,8.03071,1.44153>,<-1.77426,8.02625,1.42904>,
            
    /*2*/ <-1.68262,8.56817,1.35343>,<-1.69473,8.56949,1.34929>,<-1.68538,8.56652,1.34097>,
            
    /*3*/ <-1.57621,9.11113,1.33314>,<-1.58219,9.11226,1.33107>,<-1.57747,9.11118,1.32683>,
            
    /*4*/ <-1.51488,9.66239,1.33135>

    /* stem 0.2.21*/ 
    /*0*/ <-1.83874,8.29159,1.48899>,
    /*1*/ <-1.84448,8.28867,1.49738>,<-1.84305,8.29769,1.4815>,<-1.8287,8.2884,1.48808>,
            
    /*2*/ <-1.68093,8.72456,1.75605>,<-1.67998,8.73057,1.74547>,<-1.67042,8.72438,1.74985>,
            
    /*3*/ <-1.54014,9.18374,1.98676>,<-1.53978,9.18642,1.98128>,<-1.53487,9.18371,1.98369>,
            
    /*4*/ <-1.35221,9.65918,2.13828>

    /* stem 0.2.22*/ 
    /*0*/ <-1.89084,8.51548,1.53117>,
    /*1*/ <-1.90004,8.51408,1.52726>,<-1.88478,8.52262,1.5274>,<-1.88769,8.50974,1.53885>,
            
    /*2*/ <-2.09049,8.85458,1.86175>,<-2.08032,8.86027,1.86184>,<-2.08226,8.85169,1.86948>,
            
    /*3*/ <-2.22011,9.22912,2.19006>,<-2.21477,9.23142,2.18959>,<-2.21588,9.22743,2.1937>,
            
    /*4*/ <-2.36686,9.62472,2.48312>

    /* stem 0.2.23*/ 
    /*0*/ <-1.94006,8.72704,1.57103>,
    /*1*/ <-1.93878,8.7291,1.56169>,<-1.93448,8.73122,1.57769>,<-1.94692,8.72081,1.5737>,
            
    /*2*/ <-2.26376,9.10186,1.60272>,<-2.26089,9.10328,1.61338>,<-2.26918,9.09634,1.61072>,
            
    /*3*/ <-2.53335,9.51741,1.59461>,<-2.53209,9.51837,1.59995>,<-2.53662,9.51541,1.59865>,
            
    /*4*/ <-2.64629,9.99952,1.62721>

    /* stem 0.2.24*/ 
    /*0*/ <-1.98465,8.91868,1.60714>,
    /*1*/ <-1.97567,8.92085,1.60669>,<-1.98962,8.92109,1.61454>,<-1.98864,8.91411,1.60017>,
            
    /*2*/ <-2.09003,9.3373,1.39665>,<-2.09933,9.33745,1.40188>,<-2.09868,9.3328,1.3923>,
            
    /*3*/ <-2.16065,9.8042,1.31276>,<-2.16523,9.80403,1.31549>,<-2.16521,9.80309,1.31024>,
            
    /*4*/ <-2.2238,10.27893,1.27777>

    /* stem 0.2.25*/ 
    /*0*/ <-2.05508,9.22142,1.66417>,
    /*1*/ <-2.05248,9.2205,1.67226>,<-2.0633,9.22303,1.66249>,<-2.04946,9.22073,1.65777>,
            
    /*2*/ <-1.97106,9.66759,1.6938>,<-1.97828,9.66927,1.68729>,<-1.96905,9.66774,1.68414>,
            
    /*3*/ <-1.94608,10.11982,1.73641>,<-1.94973,10.12035,1.73313>,<-1.94503,10.12024,1.73161>,
            
    /*4*/ <-1.97863,10.57179,1.77811>

    /* stem 0.2.26*/ 
    /*0*/ <-2.10423,9.43267,1.70397>,
    /*1*/ <-2.10944,9.4309,1.70693>,<-2.10457,9.43663,1.69916>,<-2.09869,9.43048,1.70583>,
            
    /*2*/ <-2.06612,9.76901,1.98086>,<-2.06288,9.77284,1.97568>,<-2.05896,9.76873,1.98012>,
            
    /*3*/ <-2.09475,10.16515,2.16384>,<-2.09313,10.16661,2.16097>,<-2.09116,10.16547,2.16377>,
            
    /*4*/ <-2.20248,10.55826,2.32154>

    /* stem 0.2.27*/ 
    /*0*/ <-2.15793,9.66348,1.74746>,
    /*1*/ <-2.16047,9.66341,1.74473>,<-2.15527,9.66609,1.74746>,<-2.15807,9.66095,1.7502>,
            
    /*2*/ <-2.40692,9.91671,1.96798>,<-2.40345,9.9185,1.96981>,<-2.40532,9.91508,1.97163>,
            
    /*3*/ <-2.53496,10.26529,2.1607>,<-2.53294,10.26571,2.16129>,<-2.53421,10.26454,2.16257>,
            
    /*4*/ <-2.68425,10.64455,2.25238>

    /* stem 0.2.28*/ 
    /*0*/ <-2.20012,9.84479,1.78162>,
    /*1*/ <-2.19919,9.84527,1.78021>,<-2.1996,9.84528,1.78322>,<-2.20156,9.84381,1.78143>,
            
    /*2*/ <-2.42118,10.18005,1.74936>,<-2.42146,10.18006,1.75136>,<-2.42276,10.17908,1.75017>,
            
    /*3*/ <-2.58366,10.54488,1.80303>,<-2.58371,10.54472,1.80403>,<-2.58448,10.54446,1.80344>,
            
    /*4*/ <-2.6384,10.93467,1.88874>

    /* stem 0.3*/ 
    /*0*/ <0,3.92474,0>,
    /*1*/ <0.04668,3.92474,-0.05975>,<0.06363,3.9608,0.01998>,<-0.00735,3.94703,0.0721>,
            <-0.06818,3.90246,0.02457>,<-0.03479,3.88869,-0.05691>,
    /*2*/ <-0.92395,6.024,-0.78602>,<-0.91265,6.04804,-0.73286>,<-0.95998,6.03886,-0.69812>,
            <-1.00053,6.00914,-0.7298>,<-0.97826,5.99996,-0.78413>,
    /*3*/ <-1.69609,8.24977,-1.3572>,<-1.68945,8.25929,-1.32985>,<-1.71349,8.25565,-1.31277>,
            <-1.73498,8.24388,-1.32957>,<-1.72423,8.24025,-1.35703>,
    /*4*/ <-2.25948,10.57195,-1.7653>

    /* stem 0.3.0*/ 
    /*0*/ <-0.15023,4.25496,-0.11738>,
    /*1*/ <-0.13248,4.26572,-0.10981>,<-0.17042,4.26067,-0.11042>,<-0.14781,4.23847,-0.1319>,
            
    /*2*/ <-0.20876,4.87537,-0.82008>,<-0.23405,4.872,-0.82048>,<-0.21898,4.8572,-0.8348>,
            
    /*3*/ <-0.28697,5.65406,-1.335>,<-0.29965,5.65267,-1.33533>,<-0.29242,5.64738,-1.34442>,
            
    /*4*/ <-0.40028,6.49516,-1.73626>

    /* stem 0.3.1*/ 
    /*0*/ <-0.24617,4.46583,-0.19233>,
    /*1*/ <-0.25164,4.47055,-0.17207>,<-0.26098,4.46655,-0.20791>,<-0.2259,4.4604,-0.19701>,
            
    /*2*/ <-0.04772,5.35328,-0.33005>,<-0.05394,5.35062,-0.35394>,<-0.03055,5.34651,-0.34668>,
            
    /*3*/ <-0.13569,6.23802,-0.56498>,<-0.13895,6.23472,-0.5765>,<-0.12699,6.23664,-0.57373>,
            
    /*4*/ <-0.23465,7.08097,-0.92153>

    /* stem 0.3.2*/ 
    /*0*/ <-0.32477,4.63858,-0.25374>,
    /*1*/ <-0.34406,4.63041,-0.25202>,<-0.31787,4.64544,-0.27238>,<-0.31237,4.6399,-0.23681>,
            
    /*2*/ <-0.6694,5.45438,-0.07343>,<-0.65194,5.46439,-0.087>,<-0.64827,5.4607,-0.06329>,
            
    /*3*/ <-1.07371,6.26117,-0.09611>,<-1.06472,6.26558,-0.10297>,<-1.06402,6.26627,-0.09087>,
            
    /*4*/ <-1.49075,7.05238,-0.22488>

    /* stem 0.3.3*/ 
    /*0*/ <-0.38462,4.77014,-0.3005>,
    /*1*/ <-0.3879,4.762,-0.3192>,<-0.37245,4.7867,-0.29843>,<-0.39351,4.76171,-0.28386>,
            
    /*2*/ <-1.09359,5.29727,-0.42082>,<-1.08329,5.31374,-0.40698>,<-1.09733,5.29708,-0.39727>,
            
    /*3*/ <-1.71184,5.90845,-0.61561>,<-1.70634,5.91637,-0.60859>,<-1.71478,5.90926,-0.60408>,
            
    /*4*/ <-2.10255,6.6694,-0.86799>

    /* stem 0.3.4*/ 
    /*0*/ <-0.48767,4.99665,-0.38101>,
    /*1*/ <-0.47072,5.00088,-0.3908>,<-0.49577,5.0102,-0.36869>,<-0.49652,4.97886,-0.38354>,
            
    /*2*/ <-0.93963,5.32415,-1.04928>,<-0.95633,5.33036,-1.03453>,<-0.95683,5.30947,-1.04443>,
            
    /*3*/ <-1.31159,5.86467,-1.61953>,<-1.31965,5.86748,-1.61172>,<-1.32144,5.85863,-1.61894>,
            
    /*4*/ <-1.56238,6.58048,-2.04574>

    /* stem 0.3.5*/ 
    /*0*/ <-0.57619,5.19122,-0.45017>,
    /*1*/ <-0.56568,5.20075,-0.43681>,<-0.59548,5.19391,-0.45114>,<-0.56743,5.17899,-0.46257>,
            
    /*2*/ <-0.45203,5.83869,-0.99099>,<-0.4719,5.83413,-1.00054>,<-0.4532,5.82418,-1.00816>,
            
    /*3*/ <-0.43494,6.54027,-1.47449>,<-0.44493,6.53756,-1.4789>,<-0.43545,6.53396,-1.48379>,
            
    /*4*/ <-0.58219,7.3188,-1.78807>

    /* stem 0.3.6*/ 
    /*0*/ <-0.66777,5.3925,-0.52172>,
    /*1*/ <-0.6792,5.39267,-0.50662>,<-0.67504,5.39042,-0.53908>,<-0.64906,5.39442,-0.51945>,
            
    /*2*/ <-0.75219,6.22036,-0.57887>,<-0.74942,6.21886,-0.60051>,<-0.7321,6.22153,-0.58743>,
            
    /*3*/ <-1.0367,6.97956,-0.77261>,<-1.03505,6.97755,-0.78324>,<-1.0271,6.98206,-0.77723>,
            
    /*4*/ <-1.46926,7.6728,-0.9354>

    /* stem 0.3.7*/ 
    /*0*/ <-0.73271,5.53524,-0.57245>,
    /*1*/ <-0.74776,5.52624,-0.57852>,<-0.72296,5.5459,-0.5841>,<-0.72741,5.53358,-0.55475>,
            
    /*2*/ <-1.20916,6.17442,-0.37659>,<-1.19263,6.18752,-0.38031>,<-1.1956,6.17932,-0.36075>,
            
    /*3*/ <-1.66775,6.82926,-0.19033>,<-1.65943,6.83572,-0.19225>,<-1.66102,6.83181,-0.18241>,
            
    /*4*/ <-2.1293,7.49572,-0.06219>

    /* stem 0.3.8*/ 
    /*0*/ <-0.83467,5.75935,-0.65212>,
    /*1*/ <-0.83039,5.75528,-0.66906>,<-0.82717,5.77357,-0.64413>,<-0.84645,5.7492,-0.64315>,
            
    /*2*/ <-1.42971,6.21912,-0.92578>,<-1.42757,6.23132,-0.90916>,<-1.44042,6.21507,-0.90851>,
            
    /*3*/ <-1.89894,6.77935,-1.24902>,<-1.89774,6.7853,-1.24062>,<-1.90554,6.7785,-1.24108>,
            
    /*4*/ <-2.25924,7.4371,-1.52868>

    /* stem 0.3.9*/ 
    /*0*/ <-0.91918,5.94511,-0.71815>,
    /*1*/ <-0.90316,5.9518,-0.71986>,<-0.93008,5.95155,-0.70613>,<-0.92431,5.932,-0.72844>,
            
    /*2*/ <-1.17958,6.46581,-1.24183>,<-1.19753,6.46565,-1.23268>,<-1.19368,6.45261,-1.24756>,
            
    /*3*/ <-1.31389,7.12899,-1.63065>,<-1.32307,7.12962,-1.62653>,<-1.32179,7.12476,-1.63526>,
            
    /*4*/ <-1.44307,7.87295,-1.83704>

    /* stem 0.3.10*/ 
    /*0*/ <-0.98932,6.12474,-0.77294>,
    /*1*/ <-0.9858,6.13012,-0.75722>,<-1.00458,6.1278,-0.77974>,<-0.97758,6.11631,-0.78186>,
            
    /*2*/ <-0.72727,6.79137,-1.0472>,<-0.7398,6.78983,-1.06221>,<-0.7218,6.78217,-1.06363>,
            
    /*3*/ <-0.44986,7.43518,-1.359>,<-0.45612,7.43433,-1.36649>,<-0.44723,7.43023,-1.36704>,
            
    /*4*/ <-0.28233,8.11715,-1.66741>

    /* stem 0.3.11*/ 
    /*0*/ <-1.09883,6.44692,-0.8585>,
    /*1*/ <-1.11269,6.44432,-0.85057>,<-1.09906,6.4501,-0.87437>,<-1.08474,6.44635,-0.85057>,
            
    /*2*/ <-1.16075,7.16765,-0.70778>,<-1.15166,7.1715,-0.72364>,<-1.14212,7.16901,-0.70777>,
            
    /*3*/ <-1.27548,7.8919,-0.6208>,<-1.27093,7.89364,-0.62877>,<-1.26626,7.89341,-0.62068>,
            
    /*4*/ <-1.4005,8.61999,-0.64657>

    /* stem 0.3.12*/ 
    /*0*/ <-1.14481,6.58218,-0.89442>,
    /*1*/ <-1.1542,6.57602,-0.9056>,<-1.13324,6.59223,-0.89845>,<-1.14699,6.57829,-0.87922>,
            
    /*2*/ <-1.60961,7.13698,-0.82457>,<-1.59564,7.14778,-0.81981>,<-1.6048,7.13849,-0.80698>,
            
    /*3*/ <-1.94776,7.7814,-0.81828>,<-1.93995,7.78555,-0.81594>,<-1.94563,7.7825,-0.80945>,
            
    /*4*/ <-2.18317,8.45333,-0.96446>

    /* stem 0.3.13*/ 
    /*0*/ <-1.25444,6.90472,-0.98008>,
    /*1*/ <-1.24556,6.90451,-0.99223>,<-1.25186,6.91462,-0.96904>,<-1.26591,6.89503,-0.97897>,
            
    /*2*/ <-1.66879,7.36571,-1.30325>,<-1.67299,7.37245,-1.28779>,<-1.68235,7.35939,-1.29441>,
            
    /*3*/ <-2.02085,7.95186,-1.45432>,<-2.02176,7.95356,-1.44584>,<-2.02778,7.94887,-1.45>,
            
    /*4*/ <-2.2271,8.59601,-1.62776>

    /* stem 0.3.14*/ 
    /*0*/ <-1.35374,7.19685,-1.05766>,
    /*1*/ <-1.34143,7.20233,-1.05275>,<-1.36626,7.20146,-1.05238>,<-1.35354,7.18674,-1.06784>,
            
    /*2*/ <-1.36934,7.67805,-1.52871>,<-1.3859,7.67747,-1.52847>,<-1.37742,7.66765,-1.53877>,
            
    /*3*/ <-1.4946,8.21402,-1.91763>,<-1.50275,8.21283,-1.91674>,<-1.49871,8.20923,-1.923>,
            
    /*4*/ <-1.67319,8.81131,-2.17212>

    /* stem 0.3.15*/ 
    /*0*/ <-1.43612,7.4392,-1.12202>,
    /*1*/ <-1.43893,7.44176,-1.10879>,<-1.44623,7.43936,-1.13136>,<-1.4232,7.43648,-1.12591>,
            
    /*2*/ <-1.33435,8.07702,-1.21428>,<-1.33922,8.07543,-1.22932>,<-1.32387,8.0735,-1.22569>,
            
    /*3*/ <-1.22303,8.68947,-1.41405>,<-1.22558,8.68761,-1.42134>,<-1.21789,8.68681,-1.41949>,
            
    /*4*/ <-1.18538,9.3343,-1.49896>

    /* stem 0.3.16*/ 
    /*0*/ <-1.50539,7.64299,-1.17614>,
    /*1*/ <-1.51801,7.63902,-1.17494>,<-1.50055,7.6462,-1.18808>,<-1.49762,7.64375,-1.1654>,
            
    /*2*/ <-1.69477,8.24216,-1.08693>,<-1.68313,8.24695,-1.09569>,<-1.68117,8.24532,-1.08057>,
            
    /*3*/ <-1.75536,8.87471,-1.12286>,<-1.74908,8.87511,-1.12725>,<-1.74846,8.8756,-1.11962>,
            
    /*4*/ <-1.82569,9.49447,-1.23986>

    /* stem 0.3.17*/ 
    /*0*/ <-1.58437,7.87534,-1.23785>,
    /*1*/ <-1.58722,7.87126,-1.24957>,<-1.57543,7.88425,-1.23621>,<-1.59047,7.87051,-1.22777>,
            
    /*2*/ <-2.01411,8.31085,-1.29433>,<-2.00626,8.31951,-1.28542>,<-2.01628,8.31035,-1.2798>,
            
    /*3*/ <-2.27353,8.86753,-1.33479>,<-2.26853,8.87025,-1.33015>,<-2.27483,8.8675,-1.32756>,
            
    /*4*/ <-2.45464,9.45117,-1.39892>

    /* stem 0.3.18*/ 
    /*0*/ <-1.68454,8.17002,-1.31611>,
    /*1*/ <-1.67431,8.17189,-1.32218>,<-1.68777,8.17758,-1.3073>,<-1.69154,8.16061,-1.31884>,
            
    /*2*/ <-1.96968,8.50141,-1.71047>,<-1.97866,8.5052,-1.70055>,<-1.98116,8.49389,-1.70824>,
            
    /*3*/ <-2.13733,8.94751,-2.05372>,<-2.1419,8.94956,-2.04889>,<-2.14383,8.94504,-2.05381>,
            
    /*4*/ <-2.1826,9.468,-2.32379>

    /* stem 0.3.19*/ 
    /*0*/ <-1.73198,8.33595,-1.35317>,
    /*1*/ <-1.72455,8.33924,-1.34479>,<-1.74323,8.33897,-1.35251>,<-1.72815,8.32963,-1.3622>,
            
    /*2*/ <-1.61444,8.82122,-1.63756>,<-1.62689,8.82104,-1.6427>,<-1.61684,8.81481,-1.64917>,
            
    /*3*/ <-1.5726,9.35987,-1.83139>,<-1.57888,9.35953,-1.83382>,<-1.57367,9.35773,-1.83769>,
            
    /*4*/ <-1.5155,9.91953,-1.94579>

    /* stem 0.3.20*/ 
    /*0*/ <-1.78437,8.55801,-1.3941>,
    /*1*/ <-1.7908,8.55818,-1.38495>,<-1.78862,8.56104,-1.40399>,<-1.77367,8.55482,-1.39336>,
            
    /*2*/ <-1.63815,9.08467,-1.29179>,<-1.6367,9.08658,-1.30448>,<-1.62673,9.08243,-1.29739>,
            
    /*3*/ <-1.57838,9.63228,-1.21981>,<-1.5777,9.63309,-1.22618>,<-1.57251,9.63203,-1.2225>,
            
    /*4*/ <-1.60177,10.17741,-1.11538>

    /* stem 0.3.21*/ 
    /*0*/ <-1.84049,8.79593,-1.43795>,
    /*1*/ <-1.85004,8.79299,-1.44168>,<-1.83349,8.80072,-1.44441>,<-1.83795,8.79407,-1.42776>,
            
    /*2*/ <-2.04755,9.27187,-1.30337>,<-2.03652,9.27703,-1.30519>,<-2.03949,9.2726,-1.29409>,
            
    /*3*/ <-2.21607,9.7749,-1.22457>,<-2.21037,9.777,-1.22558>,<-2.21214,9.77552,-1.21987>,
            
    /*4*/ <-2.3142,10.30182,-1.24584>

    /* stem 0.3.22*/ 
    /*0*/ <-1.90109,9.05278,-1.48529>,
    /*1*/ <-1.89934,9.05137,-1.49516>,<-1.8955,9.05939,-1.48006>,<-1.90842,9.04758,-1.48066>,
            
    /*2*/ <-2.23596,9.42509,-1.60453>,<-2.2334,9.43043,-1.59446>,<-2.24201,9.42255,-1.59486>,
            
    /*3*/ <-2.5054,9.85559,-1.68979>,<-2.50371,9.85771,-1.68462>,<-2.50861,9.85456,-1.68503>,
            
    /*4*/ <-2.75823,10.30285,-1.72564>

    /* stem 0.3.23*/ 
    /*0*/ <-1.96039,9.30415,-1.53163>,
    /*1*/ <-1.95107,9.3062,-1.53248>,<-1.96585,9.30914,-1.52553>,<-1.96425,9.29712,-1.53686>,
            
    /*2*/ <-2.05784,9.6293,-1.8902>,<-2.0677,9.63126,-1.88557>,<-2.06663,9.62325,-1.89313>,
            
    /*3*/ <-2.2105,10.04264,-2.114>,<-2.21509,10.04265,-2.11092>,<-2.21504,10.04003,-2.11579>,
            
    /*4*/ <-2.36725,10.48442,-2.26911>

    /* stem 0.3.24*/ 
    /*0*/ <-2.00972,9.51326,-1.57017>,
    /*1*/ <-2.0073,9.51541,-1.56162>,<-2.0179,9.5158,-1.57338>,<-2.00397,9.50857,-1.57551>,
            
    /*2*/ <-1.8197,9.92329,-1.72057>,<-1.82676,9.92355,-1.7284>,<-1.81748,9.91873,-1.72983>,
            
    /*3*/ <-1.68612,10.35949,-1.85673>,<-1.68973,10.35943,-1.86058>,<-1.68485,10.35764,-1.86151>,
            
    /*4*/ <-1.572,10.8144,-1.93769>

    /* stem 0.3.25*/ 
    /*0*/ <-2.05558,9.70763,-1.60599>,
    /*1*/ <-2.06304,9.70669,-1.60154>,<-2.05571,9.71091,-1.61409>,<-2.04799,9.70529,-1.60235>,
            
    /*2*/ <-2.01182,10.13125,-1.43198>,<-2.00694,10.13407,-1.44035>,<-2.00179,10.13032,-1.43252>,
            
    /*3*/ <-1.97457,10.58232,-1.34729>,<-1.97218,10.58298,-1.35169>,<-1.96954,10.58198,-1.3475>,
            
    /*4*/ <-1.96596,11.0418,-1.32518>

    /* stem 0.3.26*/ 
    /*0*/ <-2.11054,9.94061,-1.64893>,
    /*1*/ <-2.115,9.93866,-1.65378>,<-2.10491,9.94414,-1.65067>,<-2.11171,9.93902,-1.64235>,
            
    /*2*/ <-2.33466,10.3168,-1.60023>,<-2.32793,10.32045,-1.59815>,<-2.33246,10.31703,-1.59261>,
            
    /*3*/ <-2.51993,10.71638,-1.60296>,<-2.51646,10.71801,-1.60194>,<-2.51901,10.71685,-1.59913>,
            
    /*4*/ <-2.62745,11.13558,-1.68548>

    /* stem 0.3.27*/ 
    /*0*/ <-2.1807,10.23801,-1.70375>,
    /*1*/ <-2.17866,10.23793,-1.70676>,<-2.17973,10.2401,-1.70095>,<-2.18371,10.23598,-1.70355>,
            
    /*2*/ <-2.40106,10.55209,-1.86385>,<-2.40177,10.55354,-1.85997>,<-2.40442,10.55079,-1.86171>,
            
    /*3*/ <-2.61878,10.88542,-1.98409>,<-2.61904,10.88598,-1.98208>,<-2.62044,10.88473,-1.98301>,
            
    /*4*/ <-2.77849,11.24971,-2.10467>

    /* stem 0.3.28*/ 
    /*0*/ <-2.23668,10.4753,-1.74749>,
    /*1*/ <-2.23573,10.47559,-1.74714>,<-2.23755,10.47568,-1.74703>,<-2.23676,10.47463,-1.74829>,
            
    /*2*/ <-2.23521,10.78022,-2.00002>,<-2.23642,10.78028,-1.99995>,<-2.2359,10.77958,-2.00079>,
            
    /*3*/ <-2.2402,11.14219,-2.16013>,<-2.24081,11.14221,-2.16008>,<-2.24055,11.14199,-2.16058>,
            
    /*4*/ <-2.235,11.522,-2.27167>

    /* stem 0.4*/ 
    /*0*/ <0,4.33269,0>,
    /*1*/ <0.06839,4.33269,0.03189>,<-0.00513,4.36857,0.06619>,<-0.07156,4.35486,0.00901>,
            <-0.0391,4.31051,-0.06061>,<0.0474,4.2968,-0.04648>,
    /*2*/ <0.55595,6.42432,-1.0732>,<0.50694,6.44825,-1.05034>,<0.46265,6.43911,-1.08846>,
            <0.48429,6.40954,-1.13487>,<0.54196,6.4004,-1.12545>,
    /*3*/ <0.93744,8.64201,-1.95082>,<0.9124,8.65149,-1.93826>,<0.89046,8.64787,-1.95775>,
            <0.90194,8.63616,-1.98236>,<0.93097,8.63254,-1.97808>,
    /*4*/ <1.20739,10.95576,-2.58925>

    /* stem 0.4.0*/ 
    /*0*/ <0.07522,4.64097,-0.16131>,
    /*1*/ <0.07185,4.65171,-0.14235>,<0.06502,4.6476,-0.17971>,<0.08878,4.62359,-0.16188>,
            
    /*2*/ <0.79305,5.2164,-0.34273>,<0.7885,5.21366,-0.36764>,<0.80434,5.19765,-0.35575>,
            
    /*3*/ <1.38972,5.90253,-0.5679>,<1.3871,5.90088,-0.58025>,<1.39662,5.89438,-0.57484>,
            
    /*4*/ <1.88312,6.67426,-0.76524>

    /* stem 0.4.1*/ 
    /*0*/ <0.1281,4.85767,-0.2747>,
    /*1*/ <0.10719,4.86237,-0.27547>,<0.13985,4.85811,-0.29263>,<0.13725,4.85253,-0.256>,
            
    /*2*/ <0.30758,5.74543,-0.12687>,<0.32935,5.74258,-0.13831>,<0.32762,5.73887,-0.11389>,
            
    /*3*/ <0.47046,6.6394,-0.00375>,<0.4814,6.63828,-0.00945>,<0.48062,6.63673,0.00281>,
            
    /*4*/ <0.67596,7.53393,0.00829>

    /* stem 0.4.2*/ 
    /*0*/ <0.16403,5.00495,-0.35177>,
    /*1*/ <0.15802,4.99678,-0.37019>,<0.18404,5.01075,-0.34887>,<0.15004,5.00732,-0.33625>,
            
    /*2*/ <-0.03619,5.82809,-0.66757>,<-0.01885,5.83741,-0.65335>,<-0.04151,5.83512,-0.64494>,
            
    /*3*/ <0.04636,6.65946,-1.01436>,<0.05513,6.66201,-1.00636>,<0.04354,6.66432,-1.00359>,
            
    /*4*/ <0.21381,7.47739,-1.36142>

    /* stem 0.4.3*/ 
    /*0*/ <0.20364,5.1673,-0.43672>,
    /*1*/ <0.22106,5.15919,-0.44409>,<0.20442,5.18285,-0.42326>,<0.18545,5.15985,-0.4428>,
            
    /*2*/ <0.20168,5.74379,-1.11357>,<0.19059,5.75957,-1.09969>,<0.17794,5.74423,-1.11271>,
            
    /*3*/ <0.28338,6.41144,-1.69439>,<0.27778,6.41876,-1.68688>,<0.27156,6.41256,-1.69488>,
            
    /*4*/ <0.29874,7.18589,-2.13298>

    /* stem 0.4.4*/ 
    /*0*/ <0.24847,5.35099,-0.53284>,
    /*1*/ <0.26185,5.35523,-0.51849>,<0.23313,5.36348,-0.53627>,<0.25042,5.33426,-0.54375>,
            
    /*2*/ <0.7416,5.78881,-1.10356>,<0.72246,5.79431,-1.11541>,<0.73398,5.77483,-1.1204>,
            
    /*3*/ <1.17534,6.33792,-1.62291>,<1.16554,6.34043,-1.62857>,<1.17225,6.3317,-1.63219>,
            
    /*4*/ <1.59153,6.98148,-2.03758>

    /* stem 0.4.5*/ 
    /*0*/ <0.30354,5.57671,-0.65095>,
    /*1*/ <0.29291,5.58623,-0.63772>,<0.29872,5.5776,-0.66977>,<0.31899,5.56631,-0.64535>,
            
    /*2*/ <0.79218,6.26847,-0.73676>,<0.79605,6.26272,-0.75812>,<0.80957,6.25519,-0.74184>,
            
    /*3*/ <1.20073,6.99703,-0.89813>,<1.20242,6.99381,-0.90876>,<1.21,6.99131,-0.90086>,
            
    /*4*/ <1.46692,7.77446,-1.11828>

    /* stem 0.4.6*/ 
    /*0*/ <0.34359,5.74086,-0.73684>,
    /*1*/ <0.32625,5.74102,-0.7446>,<0.35892,5.73873,-0.74786>,<0.3456,5.74282,-0.71804>,
            
    /*2*/ <0.38108,6.57047,-0.83377>,<0.40285,6.56895,-0.83594>,<0.39398,6.57167,-0.81607>,
            
    /*3*/ <0.42491,7.389,-0.99512>,<0.43579,7.38827,-0.99625>,<0.43143,7.39044,-0.98642>,
            
    /*4*/ <0.5548,8.1699,-1.26475>

    /* stem 0.4.7*/ 
    /*0*/ <0.40408,5.98876,-0.86655>,
    /*1*/ <0.40657,5.97987,-0.88238>,<0.41713,5.99993,-0.86017>,<0.38854,5.98647,-0.8571>,
            
    /*2*/ <0.06984,6.60465,-1.27917>,<0.07688,6.61802,-1.26436>,<0.05783,6.60905,-1.26232>,
            
    /*3*/ <-0.15389,7.34738,-1.53126>,<-0.14949,7.35169,-1.52266>,<-0.15964,7.3487,-1.52248>,
            
    /*4*/ <-0.25694,8.14509,-1.65686>

    /* stem 0.4.8*/ 
    /*0*/ <0.43658,6.12197,-0.93625>,
    /*1*/ <0.45408,6.11789,-0.93589>,<0.43035,6.1357,-0.92648>,<0.42532,6.11231,-0.94639>,
            
    /*2*/ <0.57669,6.6154,-1.55133>,<0.56088,6.62727,-1.54505>,<0.55752,6.61168,-1.55833>,
            
    /*3*/ <0.70618,7.2309,-2.04744>,<0.69805,7.23594,-2.04342>,<0.69675,7.22965,-2.05157>,
            
    /*4*/ <0.74881,7.92792,-2.44098>

    /* stem 0.4.9*/ 
    /*0*/ <0.48859,6.33513,-1.04779>,
    /*1*/ <0.49385,6.3418,-1.03261>,<0.4771,6.34378,-1.05757>,<0.49483,6.31982,-1.0532>,
            
    /*2*/ <1.07772,6.70673,-1.40151>,<1.06655,6.70805,-1.41815>,<1.07837,6.69208,-1.41524>,
            
    /*3*/ <1.54602,7.23007,-1.7418>,<1.53996,7.23038,-1.74981>,<1.54754,7.2238,-1.7495>,
            
    /*4*/ <1.94048,7.79325,-2.11299>

    /* stem 0.4.10*/ 
    /*0*/ <0.53465,6.55757,-1.14655>,
    /*1*/ <0.52026,6.56289,-1.13965>,<0.53652,6.55772,-1.16327>,<0.54716,6.55209,-1.13674>,
            
    /*2*/ <0.80472,7.26813,-1.10402>,<0.81556,7.26468,-1.11977>,<0.82265,7.26093,-1.10208>,
            
    /*3*/ <1.04155,7.99006,-1.14839>,<1.04681,7.98792,-1.15626>,<1.05077,7.98716,-1.14743>,
            
    /*4*/ <1.22745,8.6836,-1.40248>

    /* stem 0.4.11*/ 
    /*0*/ <0.57721,6.79107,-1.23784>,
    /*1*/ <0.56633,6.78845,-1.24961>,<0.59249,6.79505,-1.24165>,<0.57282,6.7897,-1.22227>,
            
    /*2*/ <0.38543,7.50681,-1.23455>,<0.40287,7.51121,-1.22924>,<0.38975,7.50763,-1.21632>,
            
    /*3*/ <0.24122,8.22942,-1.14675>,<0.25009,8.23093,-1.1441>,<0.24356,8.22885,-1.13769>,
            
    /*4*/ <0.17792,8.96725,-1.11977>

    /* stem 0.4.12*/ 
    /*0*/ <0.62081,7.03019,-1.33132>,
    /*1*/ <0.62947,7.02411,-1.34284>,<0.62656,7.04174,-1.32247>,<0.60639,7.02472,-1.32865>,
            
    /*2*/ <0.35748,7.51155,-1.79778>,<0.35554,7.52331,-1.7842>,<0.34209,7.51196,-1.78832>,
            
    /*3*/ <0.17207,8.07928,-2.20065>,<0.1714,8.0844,-2.19323>,<0.16419,8.07989,-2.19627>,
            
    /*4*/ <0.04077,8.73207,-2.47665>

    /* stem 0.4.13*/ 
    /*0*/ <0.67379,7.32086,-1.44496>,
    /*1*/ <0.68753,7.32065,-1.43908>,<0.66475,7.33247,-1.4424>,<0.66911,7.30945,-1.45339>,
            
    /*2*/ <0.93012,7.63788,-2.00761>,<0.91494,7.64576,-2.00982>,<0.91784,7.63042,-2.01715>,
            
    /*3*/ <1.1528,8.09879,-2.477>,<1.1449,8.10223,-2.47744>,<1.1471,8.09578,-2.48273>,
            
    /*4*/ <1.33977,8.65929,-2.8424>

    /* stem 0.4.14*/ 
    /*0*/ <0.70524,7.49333,-1.51239>,
    /*1*/ <0.7032,7.49889,-1.49913>,<0.69713,7.49794,-1.52351>,<0.71538,7.48317,-1.51452>,
            
    /*2*/ <1.16156,7.98174,-1.63631>,<1.15751,7.98111,-1.65257>,<1.16968,7.97126,-1.64657>,
            
    /*3*/ <1.51551,8.53607,-1.80743>,<1.51306,8.53523,-1.8154>,<1.52012,8.53154,-1.81277>,
            
    /*4*/ <1.7786,9.13618,-1.98768>

    /* stem 0.4.15*/ 
    /*0*/ <0.76706,7.83245,-1.64496>,
    /*1*/ <0.7536,7.835,-1.64472>,<0.77403,7.83352,-1.65671>,<0.77355,7.82883,-1.63345>,
            
    /*2*/ <0.87883,8.45993,-1.51615>,<0.89245,8.45895,-1.52414>,<0.89213,8.45582,-1.50863>,
            
    /*3*/ <0.93581,9.09578,-1.39803>,<0.94269,9.09594,-1.40194>,<0.94259,9.0945,-1.39416>,
            
    /*4*/ <1.0299,9.72226,-1.25047>

    /* stem 0.4.16*/ 
    /*0*/ <0.79371,7.97866,-1.70212>,
    /*1*/ <0.78968,7.97467,-1.71421>,<0.80536,7.98504,-1.70073>,<0.78609,7.97626,-1.69141>,
            
    /*2*/ <0.49524,8.53412,-1.79589>,<0.50569,8.54104,-1.7869>,<0.49285,8.53519,-1.78069>,
            
    /*3*/ <0.31027,9.134,-1.90814>,<0.31583,9.13663,-1.90349>,<0.30885,9.13502,-1.90063>,
            
    /*4*/ <0.17534,9.7479,-2.01536>

    /* stem 0.4.17*/ 
    /*0*/ <0.83953,8.22999,-1.80038>,
    /*1*/ <0.85033,8.2259,-1.8058>,<0.83994,8.23893,-1.79128>,<0.82831,8.22514,-1.80405>,
            
    /*2*/ <0.79747,8.66592,-2.23301>,<0.79054,8.6746,-2.22333>,<0.78279,8.66541,-2.23185>,
            
    /*3*/ <0.73427,9.11265,-2.65206>,<0.73083,9.11688,-2.64709>,<0.72694,9.11232,-2.65137>,
            
    /*4*/ <0.70196,9.61474,-3.00694>

    /* stem 0.4.18*/ 
    /*0*/ <0.88724,8.49169,-1.90269>,
    /*1*/ <0.89553,8.49357,-1.89401>,<0.8775,8.49891,-1.90345>,<0.88868,8.48258,-1.9106>,
            
    /*2*/ <1.19015,8.85531,-2.25967>,<1.17813,8.85888,-2.26597>,<1.18558,8.84799,-2.27073>,
            
    /*3*/ <1.37349,9.28225,-2.62925>,<1.36692,9.28313,-2.63156>,<1.37117,9.27855,-2.63474>,
            
    /*4*/ <1.51971,9.7394,-2.97718>

    /* stem 0.4.19*/ 
    /*0*/ <0.93234,8.78189,-1.99941>,
    /*1*/ <0.92595,8.78514,-1.99042>,<0.92971,8.7856,-2.00997>,<0.94136,8.77494,-1.99783>,
            
    /*2*/ <1.26337,9.2363,-1.91829>,<1.26588,9.23661,-1.93133>,<1.27365,9.2295,-1.92323>,
            
    /*3*/ <1.54817,9.70815,-1.78569>,<1.54985,9.70898,-1.79205>,<1.55378,9.70547,-1.78801>,
            
    /*4*/ <1.80092,10.21496,-1.73909>

    /* stem 0.4.20*/ 
    /*0*/ <0.95686,8.97568,-2.05199>,
    /*1*/ <0.9466,8.97585,-2.05616>,<0.96554,8.97771,-2.05855>,<0.95843,8.97348,-2.04125>,
            
    /*2*/ <0.91163,9.51391,-1.93889>,<0.92425,9.51515,-1.94049>,<0.91952,9.51233,-1.92896>,
            
    /*3*/ <0.9058,10.06328,-1.88716>,<0.91213,10.06346,-1.88802>,<0.90973,10.06288,-1.88213>,
            
    /*4*/ <0.95196,10.61333,-1.88856>

    /* stem 0.4.21*/ 
    /*0*/ <0.99492,9.2765,-2.13361>,
    /*1*/ <0.99637,9.27363,-2.14352>,<1.00272,9.28086,-2.12825>,<0.98566,9.27502,-2.12906>,
            
    /*2*/ <0.84052,9.75138,-2.30119>,<0.84475,9.75619,-2.29101>,<0.83338,9.7523,-2.29155>,
            
    /*3*/ <0.7551,10.2638,-2.39277>,<0.75743,10.26518,-2.3874>,<0.75154,10.2641,-2.38793>,
            
    /*4*/ <0.71659,10.77923,-2.49344>

    /* stem 0.4.22*/ 
    /*0*/ <1.01848,9.46276,-2.18415>,
    /*1*/ <1.0284,9.46136,-2.18466>,<1.01472,9.46977,-2.17806>,<1.01234,9.45714,-2.18972>,
            
    /*2*/ <1.05375,9.80499,-2.56219>,<1.04463,9.81059,-2.55779>,<1.04304,9.80217,-2.56556>,
            
    /*3*/ <1.019,10.18471,-2.90386>,<1.01444,10.18688,-2.90104>,<1.01365,10.183,-2.90526>,
            
    /*4*/ <1.01875,10.6072,-3.19123>

    /* stem 0.4.23*/ 
    /*0*/ <1.05153,9.72397,-2.25502>,
    /*1*/ <1.05443,9.72599,-2.24624>,<1.04414,9.72858,-2.25875>,<1.05603,9.71735,-2.26009>,
            
    /*2*/ <1.35565,10.06657,-2.42704>,<1.3488,10.0683,-2.43539>,<1.35672,10.06081,-2.43628>,
            
    /*3*/ <1.53131,10.4936,-2.58905>,<1.52744,10.49377,-2.5929>,<1.53225,10.49139,-2.59396>,
            
    /*4*/ <1.65187,10.94463,-2.73552>

    /* stem 0.4.24*/ 
    /*0*/ <1.06932,9.86453,-2.29316>,
    /*1*/ <1.06151,9.86668,-2.28886>,<1.07063,9.86713,-2.30186>,<1.07581,9.85977,-2.28876>,
            
    /*2*/ <1.26027,10.27408,-2.13854>,<1.26635,10.27438,-2.14721>,<1.26981,10.26947,-2.13848>,
            
    /*3*/ <1.38689,10.71208,-1.99918>,<1.39003,10.71255,-2.00342>,<1.39196,10.71056,-1.99891>,
            
    /*4*/ <1.47246,11.15925,-1.85584>

    /* stem 0.4.25*/ 
    /*0*/ <1.10924,10.18004,-2.37877>,
    /*1*/ <1.10343,10.17913,-2.38482>,<1.117,10.18267,-2.38074>,<1.10728,10.17831,-2.37075>,
            
    /*2*/ <0.97573,10.60739,-2.32243>,<0.98478,10.60975,-2.31971>,<0.9783,10.60684,-2.31305>,
            
    /*3*/ <0.86623,11.03974,-2.25247>,<0.87081,11.04071,-2.25113>,<0.86754,11.03934,-2.2478>,
            
    /*4*/ <0.79376,11.48373,-2.21743>

    /* stem 0.4.26*/ 
    /*0*/ <1.13404,10.37609,-2.43196>,
    /*1*/ <1.13746,10.3743,-2.43695>,<1.13645,10.38014,-2.42778>,<1.12822,10.37382,-2.43115>,
            
    /*2*/ <0.97498,10.70723,-2.66466>,<0.97431,10.71113,-2.65855>,<0.96882,10.70691,-2.6608>,
            
    /*3*/ <0.90475,11.07792,-2.8803>,<0.90447,11.07972,-2.87715>,<0.90151,11.07826,-2.87869>,
            
    /*4*/ <0.8798,11.47317,-3.05999>

    /* stem 0.4.27*/ 
    /*0*/ <1.17016,10.66153,-2.50941>,
    /*1*/ <1.17314,10.66146,-2.50826>,<1.16795,10.66339,-2.50804>,<1.16938,10.65973,-2.51194>,
            
    /*2*/ <1.27613,10.9695,-2.76012>,<1.27267,10.97078,-2.75997>,<1.27363,10.96834,-2.76257>,
            
    /*3*/ <1.34317,11.31955,-2.96498>,<1.34139,11.32001,-2.96478>,<1.34194,11.31905,-2.96626>,
            
    /*4*/ <1.3989,11.70252,-3.10329>

    /* stem 0.4.28*/ 
    /*0*/ <1.19752,10.87781,-2.5681>,
    /*1*/ <1.19742,10.87805,-2.56729>,<1.19695,10.87804,-2.56868>,<1.1982,10.87735,-2.56832>,
            
    /*2*/ <1.39939,11.20791,-2.63656>,<1.39908,11.20791,-2.63749>,<1.39991,11.20745,-2.63725>,
            
    /*3*/ <1.57912,11.55268,-2.69329>,<1.57896,11.55269,-2.69375>,<1.57939,11.55248,-2.69364>,
            
    /*4*/ <1.73728,11.90349,-2.77287>

    /* stem 0.5*/ 
    /*0*/ <0,4.85964,0>,
    /*1*/ <-0.01557,4.85964,0.07327>,<-0.06516,4.89526,0.00981>,<-0.0247,4.88166,-0.06721>,
            <0.0499,4.83763,-0.05135>,<0.05554,4.82402,0.03547>,
    /*2*/ <1.16416,6.93945,0.2985>,<1.1311,6.9632,0.2562>,<1.15808,6.95413,0.20485>,
            <1.20781,6.92478,0.21542>,<1.21156,6.91571,0.2733>,
    /*3*/ <2.09977,9.14461,0.47185>,<2.08203,9.15401,0.45044>,<2.09598,9.15042,0.42486>,
            <2.12235,9.13879,0.43047>,<2.12469,9.1352,0.4595>,
    /*4*/ <2.77869,11.44528,0.59063>

    /* stem 0.5.0*/ 
    /*0*/ <0.1871,5.19095,0.03977>,
    /*1*/ <0.16806,5.20158,0.04074>,<0.20244,5.19731,0.02561>,<0.19079,5.17395,0.05295>,
            
    /*2*/ <0.52776,5.77195,0.68128>,<0.55068,5.7691,0.67119>,<0.54291,5.75353,0.68942>,
            
    /*3*/ <0.80502,6.49628,1.19054>,<0.81665,6.49529,1.18579>,<0.81359,6.48906,1.1963>,
            
    /*4*/ <1.08546,7.2969,1.57119>

    /* stem 0.5.1*/ 
    /*0*/ <0.25091,5.30394,0.05333>,
    /*1*/ <0.24695,5.30866,0.03273>,<0.27092,5.30552,0.06107>,<0.23487,5.29765,0.06621>,
            
    /*2*/ <0.08994,6.18302,0.27047>,<0.10592,6.18093,0.28936>,<0.08189,6.17568,0.29279>,
            
    /*3*/ <-0.09124,7.07604,0.3779>,<-0.08347,7.07654,0.38758>,<-0.09547,7.07389,0.38938>,
            
    /*4*/ <-0.27209,7.97445,0.451>

    /* stem 0.5.2*/ 
    /*0*/ <0.3573,5.49232,0.07595>,
    /*1*/ <0.37385,5.48417,0.06597>,<0.35871,5.49732,0.09627>,<0.33932,5.49548,0.0656>,
            
    /*2*/ <0.64256,6.31692,-0.15381>,<0.63247,6.32568,-0.13361>,<0.61954,6.32446,-0.15406>,
            
    /*3*/ <0.86665,7.17417,-0.32909>,<0.86133,7.17775,-0.31881>,<0.85495,7.17731,-0.3291>,
            
    /*4*/ <1.05196,8.0358,-0.5229>

    /* stem 0.5.3*/ 
    /*0*/ <0.481,5.71138,0.10224>,
    /*1*/ <0.49199,5.70335,0.1174>,<0.46807,5.72665,0.10602>,<0.48295,5.70413,0.0833>,
            
    /*2*/ <1.13096,6.28927,-0.04477>,<1.11501,6.3048,-0.05236>,<1.12493,6.28979,-0.0675>,
            
    /*3*/ <1.72038,6.93971,0.02011>,<1.71239,6.94744,0.0163>,<1.71934,6.9419,0.00861>,
            
    /*4*/ <2.26357,7.60572,0.21577>

    /* stem 0.5.4*/ 
    /*0*/ <0.59698,5.91674,0.12689>,
    /*1*/ <0.58616,5.92092,0.14294>,<0.59769,5.92955,0.11181>,<0.60709,5.89974,0.12592>,
            
    /*2*/ <1.27273,6.30518,0.49753>,<1.28042,6.31093,0.47678>,<1.28668,6.29106,0.48619>,
            
    /*3*/ <1.75814,6.91493,0.86219>,<1.76216,6.91797,0.85193>,<1.76759,6.90999,0.85805>,
            
    /*4*/ <2.27244,7.54224,1.15823>

    /* stem 0.5.5*/ 
    /*0*/ <0.71527,6.1262,0.15204>,
    /*1*/ <0.70017,6.1356,0.14474>,<0.73282,6.12905,0.14472>,<0.71282,6.11394,0.16664>,
            
    /*2*/ <0.8315,6.76088,0.69567>,<0.85327,6.75652,0.69566>,<0.83993,6.74644,0.71027>,
            
    /*3*/ <1.04486,7.42523,1.17031>,<1.05556,7.42231,1.16972>,<1.0492,7.41846,1.17796>,
            
    /*4*/ <1.35257,8.09601,1.57983>

    /* stem 0.5.6*/ 
    /*0*/ <0.81528,6.30329,0.17329>,
    /*1*/ <0.8189,6.30346,0.1549>,<0.82934,6.30179,0.1856>,<0.7976,6.30463,0.17938>,
            
    /*2*/ <0.88746,7.12745,0.18209>,<0.89442,7.12634,0.20256>,<0.87327,7.12824,0.19841>,
            
    /*3*/ <1.10453,7.92266,0.13347>,<1.10814,7.92237,0.14367>,<1.09786,7.92505,0.14164>,
            
    /*4*/ <1.31816,8.72185,0.11314>

    /* stem 0.5.7*/ 
    /*0*/ <0.90035,6.45393,0.19137>,
    /*1*/ <0.91634,6.44503,0.19024>,<0.8957,6.46249,0.20691>,<0.889,6.45426,0.17698>,
            
    /*2*/ <1.26982,7.12722,-0.07667>,<1.25607,7.13886,-0.06556>,<1.2516,7.13337,-0.08551>,
            
    /*3*/ <1.60732,7.85114,-0.23358>,<1.59991,7.85594,-0.22774>,<1.59833,7.85443,-0.23809>,
            
    /*4*/ <1.98112,8.57279,-0.26136>

    /* stem 0.5.8*/ 
    /*0*/ <1.03443,6.69136,0.21988>,
    /*1*/ <1.03796,6.68734,0.23674>,<1.02366,6.70487,0.21606>,<1.04167,6.68186,0.20682>,
            
    /*2*/ <1.6574,7.17961,0.21825>,<1.64787,7.1913,0.20447>,<1.65987,7.17596,0.19831>,
            
    /*3*/ <2.21571,7.73094,0.31197>,<2.21108,7.73689,0.30509>,<2.21819,7.7302,0.30209>,
            
    /*4*/ <2.66897,8.37086,0.42029>

    /* stem 0.5.9*/ 
    /*0*/ <1.10001,6.80747,0.23381>,
    /*1*/ <1.0864,6.81413,0.24234>,<1.10517,6.81457,0.21881>,<1.10844,6.79372,0.24029>,
            
    /*2*/ <1.56954,7.28924,0.6301>,<1.58206,7.28953,0.61441>,<1.58424,7.27563,0.62873>,
            
    /*3*/ <2.06855,7.79744,0.95102>,<2.07431,7.79707,0.94281>,<2.07594,7.79069,0.95038>,
            
    /*4*/ <2.37538,8.44559,1.25602>

    /* stem 0.5.10*/ 
    /*0*/ <1.24705,7.11131,0.26507>,
    /*1*/ <1.23722,7.11656,0.25277>,<1.26354,7.1115,0.26317>,<1.24039,7.10588,0.27927>,
            
    /*2*/ <1.26488,7.81433,0.53595>,<1.28243,7.81095,0.54288>,<1.26699,7.80721,0.55362>,
            
    /*3*/ <1.37106,8.55106,0.644>,<1.37986,8.54935,0.64739>,<1.37237,8.54955,0.65337>,
            
    /*4*/ <1.45949,9.29199,0.74827>

    /* stem 0.5.11*/ 
    /*0*/ <1.33388,7.3171,0.28352>,
    /*1*/ <1.34281,7.31451,0.2704>,<1.34083,7.32223,0.2971>,<1.318,7.31456,0.28308>,
            
    /*2*/ <1.23429,8.01256,0.06529>,<1.23297,8.01771,0.08309>,<1.21775,8.0126,0.07375>,
            
    /*3*/ <1.15797,8.68276,-0.22484>,<1.15723,8.68642,-0.21633>,<1.14962,8.6836,-0.22085>,
            
    /*4*/ <1.18094,9.39774,-0.3978>

    /* stem 0.5.12*/ 
    /*0*/ <1.42423,7.53123,0.30273>,
    /*1*/ <1.43733,7.52518,0.30855>,<1.4169,7.54266,0.31032>,<1.41846,7.52584,0.28932>,
            
    /*2*/ <1.81753,8.01297,-0.05413>,<1.80391,8.02463,-0.05295>,<1.80495,8.01341,-0.06695>,
            
    /*3*/ <2.2346,8.55897,-0.25549>,<2.22764,8.56461,-0.25481>,<2.22931,8.56046,-0.2626>,
            
    /*4*/ <2.59582,9.16692,-0.37526>

    /* stem 0.5.13*/ 
    /*0*/ <1.55333,7.8372,0.33017>,
    /*1*/ <1.55071,7.83699,0.34475>,<1.54566,7.84634,0.3214>,<1.56361,7.82826,0.32436>,
            
    /*2*/ <2.02949,8.32648,0.43244>,<2.02612,8.33271,0.41687>,<2.03809,8.32065,0.41885>,
            
    /*3*/ <2.49644,8.83262,0.48638>,<2.49443,8.83539,0.47855>,<2.50061,8.82957,0.47957>,
            
    /*4*/ <2.83564,9.43259,0.43846>

    /* stem 0.5.14*/ 
    /*0*/ <1.6602,8.0905,0.35289>,
    /*1*/ <1.64712,8.09593,0.35386>,<1.66828,8.09343,0.34158>,<1.66521,8.08214,0.36321>,
            
    /*2*/ <1.89743,8.62987,0.66818>,<1.91153,8.6282,0.66>,<1.90948,8.62067,0.67442>,
            
    /*3*/ <2.08459,9.24565,0.84367>,<2.09159,9.24477,0.8395>,<2.09123,9.24262,0.84741>,
            
    /*4*/ <2.31768,9.86089,0.9625>

    /* stem 0.5.15*/ 
    /*0*/ <1.74252,8.28559,0.37038>,
    /*1*/ <1.73925,8.28814,0.35729>,<1.75557,8.28657,0.37452>,<1.73273,8.28205,0.37934>,
            
    /*2*/ <1.64689,8.91506,0.50745>,<1.65778,8.91401,0.51893>,<1.64255,8.911,0.52215>,
            
    /*3*/ <1.635,9.55307,0.63731>,<1.64048,9.55207,0.64295>,<1.63278,9.55156,0.64477>,
            
    /*4*/ <1.71277,10.18609,0.76987>

    /* stem 0.5.16*/ 
    /*0*/ <1.86103,8.56648,0.39557>,
    /*1*/ <1.87167,8.56257,0.38907>,<1.86227,8.57252,0.40709>,<1.84916,8.56434,0.39056>,
            
    /*2*/ <1.89228,9.1174,0.09826>,<1.88601,9.12403,0.11028>,<1.87727,9.11858,0.09925>,
            
    /*3*/ <1.89129,9.66309,-0.21022>,<1.88817,9.6665,-0.20426>,<1.88378,9.66348,-0.20959>,
            
    /*4*/ <1.9661,10.22824,-0.47014>

    /* stem 0.5.17*/ 
    /*0*/ <1.93436,8.74028,0.41116>,
    /*1*/ <1.94201,8.73622,0.42039>,<1.92736,8.75068,0.41286>,<1.93372,8.73393,0.40023>,
            
    /*2*/ <2.3933,9.07985,0.19162>,<2.38353,9.08949,0.18659>,<2.38776,9.07832,0.17818>,
            
    /*3*/ <2.75039,9.54737,0.02164>,<2.7445,9.55118,0.01959>,<2.7479,9.54684,0.01479>,
            
    /*4*/ <3.03221,10.08979,0.01492>

    /* stem 0.5.18*/ 
    /*0*/ <2.04023,8.99118,0.43366>,
    /*1*/ <2.03368,8.99305,0.44363>,<2.04,8.99926,0.42469>,<2.04701,8.98124,0.43267>,
            
    /*2*/ <2.49024,9.27763,0.68526>,<2.49445,9.28176,0.67263>,<2.49912,9.26975,0.67795>,
            
    /*3*/ <2.86898,9.68653,0.8772>,<2.87058,9.68819,0.87063>,<2.87421,9.68326,0.87396>,
            
    /*4*/ <3.14665,10.14854,1.11478>

    /* stem 0.5.19*/ 
    /*0*/ <2.15191,9.30492,0.4574>,
    /*1*/ <2.14183,9.30813,0.45324>,<2.16131,9.30622,0.45115>,<2.15259,9.30042,0.46781>,
            
    /*2*/ <2.21906,9.82099,0.67228>,<2.23204,9.81972,0.67089>,<2.22622,9.81585,0.682>,
            
    /*3*/ <2.22182,10.35406,0.8497>,<2.22837,10.35422,0.84925>,<2.22551,10.35237,0.85486>,
            
    /*4*/ <2.22908,10.91029,0.93484>

    /* stem 0.5.20*/ 
    /*0*/ <2.19225,9.44268,0.46598>,
    /*1*/ <2.19401,9.44285,0.45506>,<2.20073,9.44402,0.47296>,<2.18202,9.44117,0.46991>,
            
    /*2*/ <2.11132,9.98811,0.4538>,<2.1158,9.98889,0.46574>,<2.10334,9.98699,0.46371>,
            
    /*3*/ <2.12099,10.53931,0.45176>,<2.12327,10.53932,0.45773>,<2.11696,10.53943,0.45671>,
            
    /*4*/ <2.1938,11.07884,0.36767>

    /* stem 0.5.21*/ 
    /*0*/ <2.27154,9.71344,0.48283>,
    /*1*/ <2.28158,9.71055,0.48201>,<2.26812,9.71808,0.49158>,<2.26492,9.71168,0.4749>,
            
    /*2*/ <2.39762,10.18438,0.27772>,<2.38865,10.1894,0.2841>,<2.38651,10.18514,0.27298>,
            
    /*3*/ <2.49411,10.70212,0.22339>,<2.48934,10.70341,0.22687>,<2.48867,10.7029,0.22088>,
            
    /*4*/ <2.60012,11.2197,0.24734>

    /* stem 0.5.22*/ 
    /*0*/ <2.33127,9.91742,0.49553>,
    /*1*/ <2.33401,9.91603,0.50509>,<2.32523,9.92506,0.4931>,<2.33458,9.91118,0.4884>,
            
    /*2*/ <2.74155,10.21615,0.42878>,<2.7357,10.22218,0.42079>,<2.74193,10.21292,0.41765>,
            
    /*3*/ <3.0821,10.5816,0.31333>,<3.07838,10.58391,0.30953>,<3.08215,10.57986,0.3078>,
            
    /*4*/ <3.34853,11.00413,0.20082>

    /* stem 0.5.23*/ 
    /*0*/ <2.40614,10.17307,0.51144>,
    /*1*/ <2.3982,10.17509,0.51625>,<2.40752,10.17676,0.5028>,<2.41269,10.16735,0.51527>,
            
    /*2*/ <2.62216,10.56297,0.71622>,<2.62838,10.56408,0.70725>,<2.63182,10.5578,0.71556>,
            
    /*3*/ <2.76538,11.00465,0.87203>,<2.76848,11.00526,0.86755>,<2.7706,11.00298,0.87206>,
            
    /*4*/ <2.80411,11.4615,1.04449>

    /* stem 0.5.24*/ 
    /*0*/ <2.46203,10.36395,0.52332>,
    /*1*/ <2.45613,10.36609,0.51673>,<2.47095,10.36523,0.52204>,<2.45902,10.36053,0.5312>,
            
    /*2*/ <2.42039,10.80439,0.69511>,<2.43027,10.80382,0.69864>,<2.42231,10.80069,0.70475>,
            
    /*3*/ <2.44065,11.26523,0.80557>,<2.4456,11.26465,0.80723>,<2.44161,11.26402,0.81059>,
            
    /*4*/ <2.54038,11.71364,0.92627>

    /* stem 0.5.25*/ 
    /*0*/ <2.53112,10.59986,0.53801>,
    /*1*/ <2.5358,10.59893,0.53084>,<2.53473,10.60308,0.54513>,<2.52282,10.59756,0.53805>,
            
    /*2*/ <2.41732,11.01896,0.40266>,<2.41661,11.02173,0.41218>,<2.40866,11.01805,0.40747>,
            
    /*3*/ <2.34473,11.45708,0.30414>,<2.34445,11.45815,0.30899>,<2.34034,11.4569,0.30647>,
            
    /*4*/ <2.31641,11.90473,0.22879>

    /* stem 0.5.26*/ 
    /*0*/ <2.59632,10.82251,0.55186>,
    /*1*/ <2.60235,10.8206,0.55423>,<2.59265,10.82706,0.55526>,<2.59396,10.81988,0.5461>,
            
    /*2*/ <2.79053,11.143,0.32846>,<2.78405,11.1473,0.32915>,<2.78493,11.14252,0.32304>,
            
    /*3*/ <2.95435,11.4734,0.09487>,<2.95103,11.47539,0.09533>,<2.95147,11.47301,0.09227>,
            
    /*4*/ <3.06782,11.81973,-0.14542>

    /* stem 0.5.27*/ 
    /*0*/ <2.68233,11.11624,0.57015>,
    /*1*/ <2.68183,11.11617,0.57368>,<2.68072,11.11873,0.56816>,<2.68445,11.11382,0.5686>,
            
    /*2*/ <3.005,11.36628,0.62392>,<3.00426,11.36798,0.62024>,<3.00675,11.36471,0.62053>,
            
    /*3*/ <3.23452,11.7081,0.63512>,<3.23384,11.70862,0.63324>,<3.23555,11.70748,0.63344>,
            
    /*4*/ <3.40205,12.08421,0.63054>

    /* stem 0.5.28*/ 
    /*0*/ <2.73207,11.2861,0.58072>,
    /*1*/ <2.73042,11.28657,0.58089>,<2.73302,11.2867,0.57941>,<2.73278,11.28502,0.58187>,
            
    /*2*/ <2.84207,11.59654,0.80336>,<2.84381,11.59663,0.80237>,<2.84365,11.59551,0.80401>,
            
    /*3*/ <2.94382,11.91503,1.01836>,<2.94469,11.91508,1.01787>,<2.94461,11.91454,1.01871>,
            
    /*4*/ <3.03392,12.26907,1.17507>

    /* stem 0.6*/ 
    /*0*/ <0,5.49472,0>,
    /*1*/ <-0.07409,5.49472,0.00129>,<-0.02396,5.52996,-0.06063>,<0.05928,5.5165,-0.03876>,
            <0.0606,5.47294,0.03667>,<-0.02183,5.45948,0.06143>,
    /*2*/ <-0.02861,7.55733,1.19153>,<0.00481,7.58082,1.15025>,<0.06031,7.57185,1.16483>,
            <0.06118,7.54281,1.21512>,<0.00623,7.53384,1.23162>,
    /*3*/ <0.01255,9.74425,2.1343>,<0.02924,9.75356,2.11244>,<0.05699,9.75,2.12019>,
            <0.05746,9.7385,2.14685>,<0.02999,9.73495,2.15557>,
    /*4*/ <0.04917,12.0259,2.81685>

    /* stem 0.6.0*/ 
    /*0*/ <0.0033,5.82199,0.18892>,
    /*1*/ <-0.00188,5.83251,0.17079>,<0.02146,5.82697,0.19948>,<-0.00969,5.80649,0.19649>,
            
    /*2*/ <-0.46014,6.45663,0.67221>,<-0.44458,6.45294,0.69134>,<-0.46535,6.43929,0.68935>,
            
    /*3*/ <-0.763,7.19619,1.13125>,<-0.75491,7.1939,1.14046>,<-0.76636,7.18897,1.14084>,
            
    /*4*/ <-0.77819,7.97705,1.62325>

    /* stem 0.6.1*/ 
    /*0*/ <0.00517,6.008,0.2963>,
    /*1*/ <0.02397,6.01262,0.28797>,<0.00341,6.00443,0.31699>,<-0.01186,6.00696,0.28394>,
            
    /*2*/ <-0.1371,6.89209,0.42992>,<-0.15081,6.88662,0.44927>,<-0.16099,6.88832,0.42723>,
            
    /*3*/ <-0.38297,7.73984,0.63844>,<-0.38958,7.73571,0.64778>,<-0.39466,7.73694,0.63679>,
            
    /*4*/ <-0.62495,8.55411,0.95246>

    /* stem 0.6.2*/ 
    /*0*/ <0.00683,6.17305,0.39157>,
    /*1*/ <0.02005,6.16504,0.40522>,<-0.01236,6.1778,0.39738>,<0.01282,6.1763,0.37212>,
            
    /*2*/ <0.28514,6.98694,0.62061>,<0.26353,6.99544,0.61539>,<0.28032,6.99444,0.59855>,
            
    /*3*/ <0.47966,7.80018,0.92477>,<0.46871,7.80392,0.922>,<0.47749,7.80481,0.91402>,
            
    /*4*/ <0.43888,8.65405,1.1781>

    /* stem 0.6.3*/ 
    /*0*/ <0.00829,6.31752,0.47497>,
    /*1*/ <-0.00391,6.30955,0.48898>,<0.00137,6.33184,0.4625>,<0.02741,6.31116,0.47343>,
            
    /*2*/ <0.25113,6.9296,1.05387>,<0.25464,6.94445,1.03622>,<0.27201,6.93067,1.04351>,
            
    /*3*/ <0.2964,7.70502,1.46185>,<0.29781,7.71042,1.4516>,<0.30712,7.70673,1.45757>,
            
    /*4*/ <0.3638,8.53205,1.74766>

    /* stem 0.6.4*/ 
    /*0*/ <0.01018,6.50511,0.58326>,
    /*1*/ <-0.00779,6.50927,0.57637>,<0.02531,6.51703,0.57915>,<0.01302,6.48903,0.59426>,
            
    /*2*/ <-0.16835,6.9637,1.28786>,<-0.14629,6.96887,1.28972>,<-0.15448,6.95021,1.2998>,
            
    /*3*/ <-0.23233,7.65777,1.78961>,<-0.22106,7.65917,1.78923>,<-0.22572,7.65282,1.79743>,
            
    /*4*/ <-0.22467,8.4249,2.17702>

    /* stem 0.6.5*/ 
    /*0*/ <0.01249,6.73396,0.71537>,
    /*1*/ <0.01617,6.74328,0.69915>,<0.02566,6.7332,0.72913>,<-0.00437,6.72539,0.71782>,
            
    /*2*/ <-0.29429,7.44384,1.03895>,<-0.28796,7.43712,1.05894>,<-0.30798,7.43191,1.05139>,
            
    /*3*/ <-0.50819,8.17954,1.37761>,<-0.50494,8.176,1.38751>,<-0.51535,8.17447,1.38427>,
            
    /*4*/ <-0.62185,8.93673,1.7182>

    /* stem 0.6.6*/ 
    /*0*/ <0.01418,6.90159,0.81214>,
    /*1*/ <0.03277,6.90176,0.81153>,<0.00541,6.90102,0.82854>,<0.00435,6.90201,0.79634>,
            
    /*2*/ <0.02023,7.724,0.83729>,<0.00198,7.72351,0.84863>,<0.00128,7.72417,0.82716>,
            
    /*3*/ <-0.13924,8.52368,0.96266>,<-0.1482,8.52112,0.96801>,<-0.14855,8.52272,0.95739>,
            
    /*4*/ <-0.28677,9.3066,1.16776>

    /* stem 0.6.7*/ 
    /*0*/ <0.01639,7.12121,0.93891>,
    /*1*/ <0.02101,7.11247,0.95397>,<0.00086,7.13032,0.93819>,<0.02729,7.12084,0.92458>,
            
    /*2*/ <0.39313,7.77333,1.21612>,<0.3797,7.78523,1.2056>,<0.39732,7.77891,1.19652>,
            
    /*3*/ <0.66757,8.47817,1.48589>,<0.66043,8.48319,1.48024>,<0.66977,8.48112,1.47616>,
            
    /*4*/ <0.83451,9.18606,1.82446>

    /* stem 0.6.8*/ 
    /*0*/ <0.01755,7.23667,1.00556>,
    /*1*/ <0.0019,7.23265,1.0128>,<0.01889,7.25034,0.99439>,<0.03186,7.22702,1.0095>,
            
    /*2*/ <0.16464,7.71568,1.61871>,<0.17597,7.72748,1.60644>,<0.18462,7.71193,1.61651>,
            
    /*3*/ <0.22553,8.28195,2.16774>,<0.23115,8.28762,2.16136>,<0.2357,8.281,2.16768>,
            
    /*4*/ <0.25966,8.94595,2.59831>

    /* stem 0.6.9*/ 
    /*0*/ <0.02019,7.49805,1.15645>,
    /*1*/ <0.00906,7.50457,1.14536>,<0.03573,7.5048,1.15786>,<0.01577,7.48479,1.16613>,
            
    /*2*/ <-0.24474,7.98277,1.68959>,<-0.22696,7.98293,1.69792>,<-0.24027,7.96959,1.70343>,
            
    /*3*/ <-0.36637,8.60618,2.11952>,<-0.35723,8.60561,2.12305>,<-0.36457,8.601,2.12766>,
            
    /*4*/ <-0.43588,9.32334,2.38192>

    /* stem 0.6.10*/ 
    /*0*/ <0.02168,7.67631,1.24198>,
    /*1*/ <0.03143,7.68154,1.22967>,<0.02687,7.67735,1.25766>,<0.00674,7.67003,1.23861>,
            
    /*2*/ <-0.27262,8.36666,1.28773>,<-0.27565,8.36387,1.30639>,<-0.28907,8.35899,1.29369>,
            
    /*3*/ <-0.52004,9.04927,1.4868>,<-0.521,9.04635,1.49585>,<-0.5283,9.04548,1.48975>,
            
    /*4*/ <-0.69374,9.73504,1.7412>

    /* stem 0.6.11*/ 
    /*0*/ <0.02364,7.93669,1.35429>,
    /*1*/ <0.03827,7.93413,1.35997>,<0.01172,7.94008,1.36425>,<0.02093,7.93587,1.33864>,
            
    /*2*/ <0.18251,8.64585,1.2947>,<0.16481,8.64981,1.29755>,<0.17095,8.647,1.28047>,
            
    /*3*/ <0.22125,9.36149,1.43072>,<0.21217,9.36179,1.43203>,<0.21564,9.3632,1.42365>,
            
    /*4*/ <0.16148,10.0804,1.5415>

    /* stem 0.6.12*/ 
    /*0*/ <0.02574,8.21517,1.47439>,
    /*1*/ <0.02307,8.20925,1.48815>,<0.01694,8.22641,1.46911>,<0.03719,8.20984,1.4659>,
            
    /*2*/ <0.45816,8.68586,1.77161>,<0.45408,8.6973,1.75891>,<0.46758,8.68625,1.75678>,
            
    /*3*/ <0.79515,9.23977,2.04877>,<0.79259,9.24477,2.04201>,<0.80018,9.24037,2.04159>,
            
    /*4*/ <1.0824,9.84107,2.27954>

    /* stem 0.6.13*/ 
    /*0*/ <0.0271,8.39703,1.55283>,
    /*1*/ <0.01235,8.39683,1.55356>,<0.03393,8.40676,1.54404>,<0.03503,8.38751,1.56088>,
            
    /*2*/ <0.03664,8.85089,2.07121>,<0.05103,8.85751,2.06486>,<0.05177,8.84468,2.07608>,
            
    /*3*/ <0.09166,9.40078,2.48358>,<0.0988,9.40316,2.47955>,<0.09925,9.39802,2.48634>,
            
    /*4*/ <0.16103,10.00371,2.81007>

    /* stem 0.6.14*/ 
    /*0*/ <0.02858,8.59308,1.63738>,
    /*1*/ <0.02466,8.59855,1.62476>,<0.04145,8.59614,1.64281>,<0.01963,8.58455,1.64457>,
            
    /*2*/ <-0.2331,9.13206,1.94164>,<-0.22191,9.13045,1.95367>,<-0.23645,9.12272,1.95484>,
            
    /*3*/ <-0.4039,9.72186,2.21316>,<-0.3982,9.72085,2.21905>,<-0.40589,9.71809,2.22023>,
            
    /*4*/ <-0.45874,10.3559,2.42792>

    /* stem 0.6.15*/ 
    /*0*/ <0.03119,8.93944,1.78676>,
    /*1*/ <0.04298,8.94194,1.78075>,<0.03018,8.94017,1.80017>,<0.02041,8.9362,1.77936>,
            
    /*2*/ <-0.11621,9.56209,1.73699>,<-0.12475,9.56091,1.74994>,<-0.13126,9.55826,1.73607>,
            
    /*3*/ <-0.29461,10.17129,1.83891>,<-0.29851,10.16913,1.84529>,<-0.3021,10.16923,1.83839>,
            
    /*4*/ <-0.43336,10.77679,1.99981>

    /* stem 0.6.16*/ 
    /*0*/ <0.03279,9.15274,1.87875>,
    /*1*/ <0.04146,9.14886,1.88759>,<0.0207,9.15568,1.88239>,<0.03623,9.15367,1.86628>,
            
    /*2*/ <0.21022,9.74217,1.97607>,<0.19638,9.74672,1.9726>,<0.20673,9.74538,1.96186>,
            
    /*3*/ <0.26788,10.34933,2.10725>,<0.26075,10.35048,2.10527>,<0.2662,10.35107,2.10017>,
            
    /*4*/ <0.3192,10.94504,2.28212>

    /* stem 0.6.17*/ 
    /*0*/ <0.03429,9.35165,1.96454>,
    /*1*/ <0.02711,9.34764,1.97396>,<0.0304,9.36104,1.95727>,<0.04537,9.34626,1.9624>,
            
    /*2*/ <0.29498,9.74674,2.34272>,<0.29718,9.75568,2.3316>,<0.30716,9.74582,2.33502>,
            
    /*3*/ <0.48793,10.22598,2.65972>,<0.48869,10.22977,2.65362>,<0.4942,10.22587,2.65616>,
            
    /*4*/ <0.63848,10.73689,2.9485>

    /* stem 0.6.18*/ 
    /*0*/ <0.03652,9.64795,2.09234>,
    /*1*/ <0.02558,9.64978,2.08829>,<0.04541,9.6548,2.08864>,<0.03858,9.63927,2.10008>,
            
    /*2*/ <-0.07148,10.01585,2.52759>,<-0.05826,10.0192,2.52782>,<-0.06281,10.00885,2.53545>,
            
    /*3*/ <-0.13613,10.46845,2.88424>,<-0.12943,10.4697,2.88394>,<-0.13191,10.46556,2.88875>,
            
    /*4*/ <-0.14803,10.93221,3.23288>

    /* stem 0.6.19*/ 
    /*0*/ <0.03812,9.91055,2.18365>,
    /*1*/ <0.03988,9.91372,2.17303>,<0.04495,9.91416,2.19179>,<0.02952,9.90377,2.18613>,
            
    /*2*/ <-0.28855,10.35703,2.25475>,<-0.28517,10.35732,2.26726>,<-0.29546,10.3504,2.26349>,
            
    /*3*/ <-0.55852,10.82929,2.37924>,<-0.55647,10.82889,2.38538>,<-0.56208,10.82614,2.38364>,
            
    /*4*/ <-0.78917,11.32871,2.46922>

    /* stem 0.6.20*/ 
    /*0*/ <0.039,10.08042,2.2345>,
    /*1*/ <0.04983,10.08058,2.23376>,<0.03419,10.0821,2.24408>,<0.03299,10.07858,2.22565>,
            
    /*2*/ <0.03134,10.61437,2.13289>,<0.02091,10.61538,2.13976>,<0.02011,10.61303,2.12748>,
            
    /*3*/ <0.02183,11.15617,2.09125>,<0.01662,11.15638,2.09473>,<0.0162,11.15589,2.08849>,
            
    /*4*/ <-0.00143,11.69764,2.13426>

    /* stem 0.6.21*/ 
    /*0*/ <0.04049,10.36444,2.31952>,
    /*1*/ <0.04348,10.36162,2.3289>,<0.03207,10.37016,2.31832>,<0.04591,10.36154,2.31132>,
            
    /*2*/ <0.3303,10.79374,2.3639>,<0.3227,10.79944,2.35685>,<0.33193,10.79369,2.35218>,
            
    /*3*/ <0.5489,11.26262,2.41661>,<0.54482,11.26496,2.41302>,<0.54987,11.26286,2.41078>,
            
    /*4*/ <0.72175,11.74388,2.50933>

    /* stem 0.6.22*/ 
    /*0*/ <0.04148,10.55538,2.37667>,
    /*1*/ <0.03296,10.55402,2.38139>,<0.0419,10.56143,2.36892>,<0.04959,10.5507,2.3797>,
            
    /*2*/ <0.14372,10.93952,2.68638>,<0.14968,10.94446,2.67807>,<0.15481,10.93731,2.68525>,
            
    /*3*/ <0.18646,11.39885,2.88908>,<0.18932,11.40063,2.88452>,<0.19212,11.39842,2.88894>,
            
    /*4*/ <0.1937,11.88036,3.03735>

    /* stem 0.6.23*/ 
    /*0*/ <0.04276,10.79904,2.44961>,
    /*1*/ <0.0364,10.80103,2.44308>,<0.05077,10.8038,2.44991>,<0.0411,10.7923,2.45583>,
            
    /*2*/ <-0.16461,11.12406,2.7415>,<-0.15503,11.1259,2.74605>,<-0.16148,11.11824,2.75>,
            
    /*3*/ <-0.37071,11.49742,2.96759>,<-0.36605,11.49857,2.97002>,<-0.36955,11.49521,2.97236>,
            
    /*4*/ <-0.56357,11.91747,3.10824>

    /* stem 0.6.24*/ 
    /*0*/ <0.04388,11.01328,2.51374>,
    /*1*/ <0.04885,11.01537,2.50668>,<0.04718,11.01421,2.52193>,<0.0356,11.01027,2.5126>,
            
    /*2*/ <-0.11401,11.45124,2.52455>,<-0.11512,11.45047,2.53471>,<-0.12283,11.44784,2.5285>,
            
    /*3*/ <-0.21428,11.89799,2.61044>,<-0.21466,11.89697,2.61545>,<-0.2188,11.89662,2.61244>,
            
    /*4*/ <-0.26622,12.3486,2.71534>

    /* stem 0.6.25*/ 
    /*0*/ <0.04488,11.2058,2.57136>,
    /*1*/ <0.0528,11.20489,2.57427>,<0.03851,11.2072,2.57678>,<0.04334,11.20531,2.56304>,
            
    /*2*/ <0.11518,11.64838,2.53515>,<0.10566,11.64993,2.53683>,<0.10888,11.64867,2.52766>,
            
    /*3*/ <0.08196,12.09221,2.60309>,<0.07714,12.09176,2.60385>,<0.07884,12.09258,2.59933>,
            
    /*4*/ <-0.04579,12.51016,2.71049>

    /* stem 0.6.26*/ 
    /*0*/ <0.04606,11.43079,2.63871>,
    /*1*/ <0.04516,11.42897,2.64482>,<0.0421,11.43511,2.63602>,<0.05091,11.4283,2.63529>,
            
    /*2*/ <0.30285,11.74832,2.7759>,<0.30081,11.75241,2.77003>,<0.30668,11.74787,2.76955>,
            
    /*3*/ <0.50524,12.08988,2.94214>,<0.50422,12.09193,2.9392>,<0.50744,12.09006,2.93914>,
            
    /*4*/ <0.60226,12.47709,3.10409>

    /* stem 0.6.27*/ 
    /*0*/ <0.04738,11.68405,2.71452>,
    /*1*/ <0.0437,11.68398,2.71483>,<0.04902,11.68672,2.71254>,<0.04943,11.68146,2.71618>,
            
    /*2*/ <0.06858,11.91793,3.05015>,<0.07213,11.91975,3.04862>,<0.07241,11.91625,3.05105>,
            
    /*3*/ <0.07132,12.22277,3.3236>,<0.07309,12.22356,3.32271>,<0.07325,12.22214,3.32429>,
            
    /*4*/ <0.0714,12.56744,3.54496>

    /* stem 0.6.28*/ 
    /*0*/ <0.04843,11.88424,2.77444>,
    /*1*/ <0.04796,11.88466,2.77305>,<0.04979,11.88471,2.77497>,<0.04754,11.88335,2.77532>,
            
    /*2*/ <-0.12079,12.20435,2.92698>,<-0.11957,12.20438,2.92826>,<-0.12107,12.20348,2.9285>,
            
    /*3*/ <-0.25184,12.54474,3.07304>,<-0.25121,12.54472,3.07366>,<-0.252,12.54435,3.07381>,
            
    /*4*/ <-0.37271,12.89011,3.21614>

    /* stem 0.7*/ 
    /*0*/ <0,6.06453,0>,
    /*1*/ <-0.01772,6.06453,-0.07108>,<0.05307,6.09937,-0.03656>,<0.05052,6.08606,0.04848>,
            <-0.02185,6.043,0.06653>,<-0.06402,6.0297,-0.00737>,
    /*2*/ <-1.15713,8.109,0.23817>,<-1.10993,8.13223,0.26118>,<-1.11163,8.12336,0.31788>,
            <-1.15988,8.09465,0.32991>,<-1.18799,8.08578,0.28065>,
    /*3*/ <-2.05849,10.27668,0.48807>,<-2.03372,10.28588,0.49929>,<-2.03502,10.28236,0.52775>,
            <-2.06059,10.27099,0.53412>,<-2.0751,10.26748,0.5096>,
    /*4*/ <-2.70954,12.53825,0.67556>

    /* stem 0.7.0*/ 
    /*0*/ <-0.14825,6.32918,0.03696>,
    /*1*/ <-0.13181,6.33966,0.02788>,<-0.15358,6.33319,0.05742>,<-0.15937,6.31468,0.0256>,
            
    /*2*/ <-0.71298,6.99682,-0.24882>,<-0.72749,6.99251,-0.22913>,<-0.73135,6.98017,-0.25034>,
            
    /*3*/ <-1.22657,7.74187,-0.41002>,<-1.23351,7.73936,-0.40003>,<-1.2367,7.73476,-0.41112>,
            
    /*4*/ <-1.6646,8.54646,-0.48871>

    /* stem 0.7.1*/ 
    /*0*/ <-0.24135,6.49537,0.06018>,
    /*1*/ <-0.22902,6.49998,0.0766>,<-0.26171,6.49094,0.06321>,<-0.23333,6.49518,0.04072>,
            
    /*2*/ <-0.4375,7.37466,-0.02158>,<-0.45929,7.36864,-0.03051>,<-0.44037,7.37146,-0.04551>,
            
    /*3*/ <-0.71194,8.23419,-0.08919>,<-0.72265,8.23051,-0.09361>,<-0.71343,8.23286,-0.10118>,
            
    /*4*/ <-1.02405,9.08287,-0.08288>

    /* stem 0.7.2*/ 
    /*0*/ <-0.34791,6.68557,0.08674>,
    /*1*/ <-0.35818,6.6776,0.10261>,<-0.35811,6.69471,0.07146>,<-0.32743,6.68441,0.08615>,
            
    /*2*/ <-0.29835,7.456,0.52357>,<-0.2983,7.46741,0.50281>,<-0.27784,7.46054,0.5126>,
            
    /*3*/ <-0.23722,8.22465,0.9614>,<-0.23722,8.23058,0.95114>,<-0.22698,8.22704,0.95593>,
            
    /*4*/ <-0.24468,9.04608,1.29723>

    /* stem 0.7.3*/ 
    /*0*/ <-0.46535,6.89523,0.11603>,
    /*1*/ <-0.48153,6.88737,0.10741>,<-0.45726,6.9119,0.10869>,<-0.45728,6.8864,0.13198>,
            
    /*2*/ <-0.98357,7.36471,0.62972>,<-0.96739,7.38107,0.63057>,<-0.96741,7.36407,0.6461>,
            
    /*3*/ <-1.46443,7.93905,1.06804>,<-1.45572,7.94658,1.06788>,<-1.45672,7.93911,1.07658>,
            
    /*4*/ <-1.93196,8.58725,1.40555>

    /* stem 0.7.4*/ 
    /*0*/ <-0.55145,7.04892,0.13749>,
    /*1*/ <-0.5488,7.05304,0.1186>,<-0.54356,7.06037,0.15118>,<-0.562,7.03335,0.14269>,
            
    /*2*/ <-1.25532,7.53155,0.13061>,<-1.25182,7.53643,0.15233>,<-1.26412,7.51841,0.14667>,
            
    /*3*/ <-1.80182,8.18328,0.1998>,<-1.79889,8.18469,0.21058>,<-1.80741,8.17782,0.20791>,
            
    /*4*/ <-2.16298,8.95283,0.27045>

    /* stem 0.7.5*/ 
    /*0*/ <-0.68989,7.29604,0.17201>,
    /*1*/ <-0.67346,7.30525,0.17195>,<-0.70029,7.29543,0.1877>,<-0.69592,7.28743,0.15637>,
            
    /*2*/ <-1.06963,7.99745,-0.05988>,<-1.08752,7.9909,-0.04938>,<-1.08461,7.98557,-0.07026>,
            
    /*3*/ <-1.45399,8.72137,-0.19174>,<-1.46275,8.71778,-0.18639>,<-1.46194,8.71626,-0.19713>,
            
    /*4*/ <-1.84716,9.45252,-0.21888>

    /* stem 0.7.6*/ 
    /*0*/ <-0.75694,7.41573,0.18873>,
    /*1*/ <-0.75219,7.41589,0.20662>,<-0.77465,7.41798,0.18383>,<-0.74398,7.41331,0.17573>,
            
    /*2*/ <-0.64036,8.22657,0.16323>,<-0.65533,8.22796,0.14804>,<-0.63488,8.22485,0.14264>,
            
    /*3*/ <-0.6184,9.04553,0.14277>,<-0.62593,9.04562,0.1352>,<-0.61561,9.04527,0.13246>,
            
    /*4*/ <-0.66012,9.86344,0.10743>

    /* stem 0.7.7*/ 
    /*0*/ <-0.89601,7.66398,0.2234>,
    /*1*/ <-0.90952,7.65533,0.23122>,<-0.89825,7.67132,0.20729>,<-0.88027,7.66531,0.2317>,
            
    /*2*/ <-1.14239,8.33731,0.57063>,<-1.13488,8.34797,0.55468>,<-1.12289,8.34396,0.57095>,
            
    /*3*/ <-1.40609,9.03059,0.86121>,<-1.40221,9.03555,0.85306>,<-1.39645,9.03421,0.86149>,
            
    /*4*/ <-1.61775,9.79478,0.94882>

    /* stem 0.7.8*/ 
    /*0*/ <-0.98429,7.82156,0.24541>,
    /*1*/ <-0.99469,7.81761,0.23201>,<-0.97279,7.83457,0.24397>,<-0.98538,7.81251,0.26025>,
            
    /*2*/ <-1.52691,8.32204,0.50372>,<-1.51231,8.33335,0.5117>,<-1.52071,8.31864,0.52255>,
            
    /*3*/ <-1.97989,8.9132,0.74431>,<-1.97182,8.918,0.74792>,<-1.97695,8.91167,0.75381>,
            
    /*4*/ <-2.35191,9.52733,1.05619>

    /* stem 0.7.9*/ 
    /*0*/ <-1.10731,8.04116,0.27608>,
    /*1*/ <-1.09909,8.04761,0.26288>,<-1.10613,8.04856,0.29116>,<-1.1167,8.02731,0.27421>,
            
    /*2*/ <-1.70662,8.47803,0.10204>,<-1.71132,8.47866,0.12089>,<-1.71836,8.4645,0.10959>,
            
    /*3*/ <-2.1458,9.07767,-0.05465>,<-2.14839,9.0783,-0.0453>,<-2.15362,9.07286,-0.05143>,
            
    /*4*/ <-2.529,9.7301,-0.1427>

    /* stem 0.7.10*/ 
    /*0*/ <-1.19625,8.2307,0.29826>,
    /*1*/ <-1.18223,8.23587,0.30491>,<-1.21002,8.23087,0.30706>,<-1.19649,8.22536,0.2828>,
            
    /*2*/ <-1.3298,8.92572,0.06586>,<-1.34833,8.92238,0.0673>,<-1.3393,8.91871,0.05113>,
            
    /*3*/ <-1.49618,9.64945,0.02444>,<-1.50536,9.64744,0.02528>,<-1.50139,9.64787,0.01673>,
            
    /*4*/ <-1.73657,10.35139,0.09194>

    /* stem 0.7.11*/ 
    /*0*/ <-1.3182,8.52206,0.32866>,
    /*1*/ <-1.3204,8.51954,0.34393>,<-1.33037,8.52545,0.31946>,<-1.30382,8.52118,0.3226>,
            
    /*2*/ <-1.22221,9.2213,0.46855>,<-1.22885,9.22524,0.45224>,<-1.21115,9.22239,0.45433>,
            
    /*3*/ <-1.21849,9.93311,0.57393>,<-1.22185,9.93441,0.56565>,<-1.21292,9.93417,0.56691>,
            
    /*4*/ <-1.28466,10.64533,0.65245>

    /* stem 0.7.12*/ 
    /*0*/ <-1.40485,8.72911,0.35027>,
    /*1*/ <-1.41878,8.72323,0.35077>,<-1.40143,8.73957,0.3399>,<-1.39435,8.72452,0.36014>,
            
    /*2*/ <-1.61157,9.23038,0.79533>,<-1.6,9.24128,0.78808>,<-1.59529,9.23124,0.80158>,
            
    /*3*/ <-1.88163,9.83026,1.03749>,<-1.87544,9.83479,1.03333>,<-1.8741,9.83208,1.04152>,
            
    /*4*/ <-2.13806,10.43499,1.28385>

    /* stem 0.7.13*/ 
    /*0*/ <-1.47893,8.90609,0.36874>,
    /*1*/ <-1.48294,8.90589,0.3546>,<-1.46965,8.9164,0.3736>,<-1.4842,8.89599,0.37801>,
            
    /*2*/ <-2.01256,9.3155,0.50404>,<-2.0037,9.32251,0.5167>,<-2.0134,9.3089,0.51965>,
            
    /*3*/ <-2.44708,9.83227,0.62552>,<-2.44201,9.83516,0.63167>,<-2.44813,9.82958,0.63349>,
            
    /*4*/ <-2.78815,10.41915,0.72509>

    /* stem 0.7.14*/ 
    /*0*/ <-1.59809,9.1908,0.39845>,
    /*1*/ <-1.58692,9.19616,0.39193>,<-1.60186,9.19567,0.41103>,<-1.6055,9.18058,0.39239>,
            
    /*2*/ <-1.97655,9.64611,0.10397>,<-1.98651,9.64578,0.1167>,<-1.98894,9.63572,0.10427>,
            
    /*3*/ <-2.33201,10.16865,-0.08988>,<-2.33663,10.16803,-0.08327>,<-2.3387,10.16411,-0.09003>,
            
    /*4*/ <-2.62744,10.75011,-0.19731>

    /* stem 0.7.15*/ 
    /*0*/ <-1.72272,9.48857,0.42952>,
    /*1*/ <-1.71432,9.49104,0.43953>,<-1.73585,9.4894,0.4315>,<-1.718,9.48527,0.41754>,
            
    /*2*/ <-1.70302,10.1039,0.27269>,<-1.71737,10.1028,0.26734>,<-1.70547,10.10005,0.25803>,
            
    /*3*/ <-1.85104,10.72021,0.22866>,<-1.85808,10.71839,0.2262>,<-1.85239,10.7194,0.22115>,
            
    /*4*/ <-2.02165,11.32169,0.33732>

    /* stem 0.7.16*/ 
    /*0*/ <-1.80609,9.68776,0.45031>,
    /*1*/ <-1.81268,9.68392,0.46062>,<-1.81232,9.6921,0.43997>,<-1.79328,9.68725,0.45033>,
            
    /*2*/ <-1.78799,10.25916,0.68489>,<-1.78775,10.26462,0.67112>,<-1.77506,10.26138,0.67803>,
            
    /*3*/ <-1.81553,10.85544,0.84618>,<-1.81538,10.85742,0.83905>,<-1.80905,10.8567,0.84282>,
            
    /*4*/ <-1.87256,11.46857,0.90329>

    /* stem 0.7.17*/ 
    /*0*/ <-1.88622,9.8792,0.47029>,
    /*1*/ <-1.8969,9.87524,0.46545>,<-1.88066,9.88923,0.46563>,<-1.8811,9.87314,0.47978>,
            
    /*2*/ <-2.19685,10.22385,0.85271>,<-2.18603,10.23318,0.85283>,<-2.18631,10.22245,0.86227>,
            
    /*3*/ <-2.40631,10.6919,1.16892>,<-2.40013,10.69536,1.16797>,<-2.40102,10.69112,1.17366>,
            
    /*4*/ <-2.67511,11.15788,1.43633>

    /* stem 0.7.18*/ 
    /*0*/ <-1.98948,10.12593,0.49603>,
    /*1*/ <-1.988,10.12775,0.48447>,<-1.98297,10.13193,0.50384>,<-1.99748,10.1181,0.4998>,
            
    /*2*/ <-2.39053,10.54455,0.50278>,<-2.38717,10.54734,0.5157>,<-2.39684,10.53812,0.51301>,
            
    /*3*/ <-2.72907,11.00811,0.58878>,<-2.72672,11.00869,0.59515>,<-2.73224,11.0049,0.59388>,
            
    /*4*/ <-2.9418,11.54657,0.58599>

    /* stem 0.7.19*/ 
    /*0*/ <-2.09371,10.41826,0.52202>,
    /*1*/ <-2.08304,10.42141,0.52135>,<-2.10016,10.42214,0.53024>,<-2.09793,10.41123,0.51447>,
            
    /*2*/ <-2.23332,10.85039,0.2033>,<-2.24474,10.85088,0.20923>,<-2.24325,10.84361,0.19871>,
            
    /*3*/ <-2.39304,11.33228,-0.0204>,<-2.39857,11.33201,-0.01712>,<-2.39818,11.32941,-0.023>,
            
    /*4*/ <-2.57665,11.82065,-0.20938>

    /* stem 0.7.20*/ 
    /*0*/ <-2.15442,10.62726,0.53716>,
    /*1*/ <-2.15132,10.62742,0.54739>,<-2.16437,10.63019,0.53454>,<-2.14758,10.62417,0.52954>,
            
    /*2*/ <-1.9875,11.13546,0.486>,<-1.9962,11.13731,0.47744>,<-1.98501,11.13329,0.4741>,
            
    /*3*/ <-1.88073,11.65992,0.438>,<-1.88518,11.66047,0.43375>,<-1.87941,11.65913,0.43202>,
            
    /*4*/ <-1.90385,12.18773,0.33694>

    /* stem 0.7.21*/ 
    /*0*/ <-2.21579,10.83852,0.55246>,
    /*1*/ <-2.22426,10.83569,0.55748>,<-2.21652,10.84431,0.54404>,<-2.20659,10.83555,0.55585>,
            
    /*2*/ <-2.19113,11.26531,0.84798>,<-2.18598,11.27105,0.83903>,<-2.17936,11.26522,0.8469>,
            
    /*3*/ <-2.20113,11.73585,1.06863>,<-2.19855,11.73819,1.06384>,<-2.19523,11.73617,1.0683>,
            
    /*4*/ <-2.20792,12.22265,1.25089>

    /* stem 0.7.22*/ 
    /*0*/ <-2.29855,11.12343,0.57309>,
    /*1*/ <-2.30493,11.12209,0.566>,<-2.29112,11.12944,0.57182>,<-2.2996,11.11877,0.58146>,
            
    /*2*/ <-2.57595,11.49765,0.7432>,<-2.56675,11.50255,0.74708>,<-2.5724,11.49544,0.75351>,
            
    /*3*/ <-2.80821,11.9253,0.83645>,<-2.80346,11.92752,0.83831>,<-2.80687,11.92489,0.84184>,
            
    /*4*/ <-2.98492,12.37469,0.95081>

    /* stem 0.7.23*/ 
    /*0*/ <-2.34855,11.29553,0.58556>,
    /*1*/ <-2.34364,11.29751,0.57794>,<-2.34593,11.29894,0.59377>,<-2.35607,11.29014,0.58496>,
            
    /*2*/ <-2.61836,11.6863,0.5057>,<-2.61988,11.68726,0.51626>,<-2.62664,11.68139,0.51038>,
            
    /*3*/ <-2.8193,12.12129,0.46165>,<-2.81993,12.12157,0.46696>,<-2.8238,12.11947,0.46391>,
            
    /*4*/ <-3.01965,12.55934,0.47102>

    /* stem 0.7.24*/ 
    /*0*/ <-2.42065,11.54375,0.60354>,
    /*1*/ <-2.41277,11.54581,0.60675>,<-2.42789,11.54625,0.60777>,<-2.42129,11.53918,0.59609>,
            
    /*2*/ <-2.42004,11.93817,0.36527>,<-2.43013,11.93847,0.36595>,<-2.42572,11.93376,0.35816>,
            
    /*3*/ <-2.45294,12.37254,0.21588>,<-2.45797,12.37237,0.21639>,<-2.45582,12.37102,0.21202>,
            
    /*4*/ <-2.48891,12.81136,0.08009>

    /* stem 0.7.25*/ 
    /*0*/ <-2.49362,11.79496,0.62173>,
    /*1*/ <-2.49462,11.79409,0.62965>,<-2.49999,11.79609,0.61699>,<-2.48626,11.79468,0.61856>,
            
    /*2*/ <-2.45544,12.22933,0.67926>,<-2.45902,12.23066,0.67082>,<-2.44986,12.22972,0.67187>,
            
    /*3*/ <-2.54238,12.6607,0.66124>,<-2.54408,12.6602,0.65696>,<-2.53958,12.66113,0.65758>,
            
    /*4*/ <-2.65543,13.08441,0.6903>

    /* stem 0.7.26*/ 
    /*0*/ <-2.55204,11.99605,0.63629>,
    /*1*/ <-2.55763,11.99439,0.63675>,<-2.5504,11.99969,0.63201>,<-2.54808,11.99406,0.64012>,
            
    /*2*/ <-2.63355,12.32592,0.88825>,<-2.62872,12.32945,0.88509>,<-2.62718,12.32571,0.8905>,
            
    /*3*/ <-2.75982,12.66937,1.09968>,<-2.75744,12.67121,1.09814>,<-2.75675,12.66966,1.10107>,
            
    /*4*/ <-2.8802,13.04491,1.25293>

    /* stem 0.7.27*/ 
    /*0*/ <-2.60889,12.19177,0.65047>,
    /*1*/ <-2.61004,12.1917,0.64691>,<-2.60593,12.19385,0.65144>,<-2.61071,12.18978,0.65306>,
            
    /*2*/ <-2.85485,12.508,0.72033>,<-2.85212,12.50943,0.72335>,<-2.8553,12.50672,0.72443>,
            
    /*3*/ <-3.05795,12.85466,0.7833>,<-3.0565,12.85524,0.78478>,<-3.05824,12.85412,0.78537>,
            
    /*4*/ <-3.19522,13.2309,0.85425>

    /* stem 0.7.28*/ 
    /*0*/ <-2.69282,12.4807,0.6714>,
    /*1*/ <-2.69232,12.48087,0.67108>,<-2.69293,12.48094,0.67196>,<-2.69322,12.4803,0.67114>,
            
    /*2*/ <-2.88628,12.77133,0.51508>,<-2.8867,12.77137,0.51566>,<-2.88689,12.77095,0.51512>,
            
    /*3*/ <-3.01219,13.12834,0.46029>,<-3.01237,13.12832,0.4606>,<-3.01253,13.12822,0.46029>,
            
    /*4*/ <-3.15103,13.48478,0.45708>

    /* stem 0.8*/ 
    /*0*/ <0,6.59018,0>,
    /*1*/ <0.06449,6.59018,-0.03286>,<0.04699,6.6246,0.04296>,<-0.03544,6.61145,0.05941>,
            <-0.0689,6.56891,-0.00624>,<-0.00714,6.55577,-0.06327>,
    /*2*/ <-0.48791,8.61566,-1.06386>,<-0.49957,8.6386,-1.01331>,<-0.55453,8.62984,-1.00235>,
            <-0.57683,8.60148,-1.04611>,<-0.53566,8.59271,-1.08413>,
    /*3*/ <-0.92996,10.7632,-1.8783>,<-0.93525,10.77229,-1.85196>,<-0.96294,10.76881,-1.84688>,
            <-0.97476,10.75758,-1.87008>,<-0.95438,10.75411,-1.8895>,
    /*4*/ <-1.25599,13.00376,-2.46501>

    /* stem 0.8.0*/ 
    /*0*/ <-0.07943,6.89323,-0.15589>,
    /*1*/ <-0.0671,6.90352,-0.14216>,<-0.09996,6.89806,-0.15735>,<-0.07124,6.87809,-0.16817>,
            
    /*2*/ <0.11958,7.51919,-0.7823>,<0.09767,7.51554,-0.79242>,<0.11682,7.50223,-0.79964>,
            
    /*3*/ <0.19947,8.25894,-1.29985>,<0.18843,8.25688,-1.30464>,<0.19835,8.25212,-1.30991>,
            
    /*4*/ <0.17895,9.06665,-1.71243>

    /* stem 0.8.1*/ 
    /*0*/ <-0.11593,7.03246,-0.22752>,
    /*1*/ <-0.12897,7.03701,-0.21203>,<-0.12266,7.03264,-0.24714>,<-0.09615,7.02773,-0.22338>,
            
    /*2*/ <0.09617,7.89983,-0.28511>,<0.10038,7.89691,-0.30852>,<0.11805,7.89364,-0.29267>,
            
    /*3*/ <0.09162,8.7913,-0.3087>,<0.09373,8.79107,-0.32049>,<0.10289,8.79132,-0.31277>,
            
    /*4*/ <-0.00605,9.67248,-0.1982>

    /* stem 0.8.2*/ 
    /*0*/ <-0.17153,7.24458,-0.33664>,
    /*1*/ <-0.18899,7.23675,-0.34297>,<-0.15834,7.25193,-0.35>,<-0.16725,7.24507,-0.31694>,
            
    /*2*/ <-0.55905,8.02715,-0.27873>,<-0.53862,8.03727,-0.28342>,<-0.54456,8.0327,-0.26138>,
            
    /*3*/ <-0.82614,8.8562,-0.17748>,<-0.81541,8.86003,-0.17988>,<-0.81844,8.85771,-0.16888>,
            
    /*4*/ <-1.10971,9.67638,-0.28522>

    /* stem 0.8.3*/ 
    /*0*/ <-0.23017,7.46831,-0.45173>,
    /*1*/ <-0.2255,7.46061,-0.46908>,<-0.22003,7.48349,-0.44473>,<-0.24497,7.46083,-0.44138>,
            
    /*2*/ <-0.76772,8.0016,-0.84774>,<-0.76407,8.01685,-0.83151>,<-0.7807,8.00175,-0.82928>,
            
    /*3*/ <-1.25705,8.56446,-1.26348>,<-1.25524,8.57212,-1.25539>,<-1.26401,8.56507,-1.25462>,
            
    /*4*/ <-1.77072,9.16864,-1.58372>

    /* stem 0.8.4*/ 
    /*0*/ <-0.28098,7.66218,-0.55146>,
    /*1*/ <-0.26247,7.6662,-0.55308>,<-0.29271,7.67459,-0.5431>,<-0.28777,7.64575,-0.5582>,
            
    /*2*/ <-0.41222,8.0276,-1.2925>,<-0.43238,8.0332,-1.28584>,<-0.42909,8.01397,-1.29591>,
            
    /*3*/ <-0.45418,8.6209,-1.87768>,<-0.46424,8.62366,-1.87427>,<-0.46299,8.61604,-1.88207>,
            
    /*4*/ <-0.48987,9.3226,-2.33134>

    /* stem 0.8.5*/ 
    /*0*/ <-0.35179,7.93232,-0.69042>,
    /*1*/ <-0.34815,7.94126,-0.6749>,<-0.36829,7.93378,-0.69816>,<-0.33893,7.92191,-0.69821>,
            
    /*2*/ <-0.09166,8.57742,-1.10868>,<-0.10509,8.57243,-1.12418>,<-0.08552,8.56452,-1.12422>,
            
    /*3*/ <0.05142,9.25091,-1.53833>,<0.0445,9.24778,-1.54566>,<0.05467,9.24509,-1.5465>,
            
    /*4*/ <-0.05024,9.9894,-1.85773>

    /* stem 0.8.6*/ 
    /*0*/ <-0.39205,8.08593,-0.76945>,
    /*1*/ <-0.40785,8.08609,-0.7611>,<-0.39137,8.08439,-0.78723>,<-0.37695,8.08731,-0.76001>,
            
    /*2*/ <-0.43166,8.87979,-0.8337>,<-0.42068,8.87866,-0.85113>,<-0.41106,8.88061,-0.83298>,
            
    /*3*/ <-0.33803,9.65267,-1.01648>,<-0.33251,9.6501,-1.0248>,<-0.32779,9.65167,-1.01576>,
            
    /*4*/ <-0.30649,10.37814,-1.34621>

    /* stem 0.8.7*/ 
    /*0*/ <-0.45659,8.33217,-0.89612>,
    /*1*/ <-0.46687,8.32382,-0.90711>,<-0.44372,8.3419,-0.90208>,<-0.4592,8.33078,-0.87917>,
            
    /*2*/ <-0.93706,8.93914,-0.92599>,<-0.92163,8.95119,-0.92263>,<-0.93195,8.94378,-0.90736>,
            
    /*3*/ <-1.32678,9.60267,-1.01801>,<-1.31849,9.60785,-1.01624>,<-1.3245,9.60536,-1.00873>,
            
    /*4*/ <-1.58598,10.31938,-1.15949>

    /* stem 0.8.8*/ 
    /*0*/ <-0.51187,8.54305,-1.0046>,
    /*1*/ <-0.50163,8.53927,-1.01717>,<-0.51013,8.55749,-0.9965>,<-0.52385,8.53239,-1.00014>,
            
    /*2*/ <-0.9795,8.87049,-1.49902>,<-0.98517,8.88263,-1.48524>,<-0.99432,8.8659,-1.48767>,
            
    /*3*/ <-1.38947,9.31906,-1.94755>,<-1.39173,9.32461,-1.94004>,<-1.39734,9.31716,-1.94237>,
            
    /*4*/ <-1.6367,9.8556,-2.4168>

    /* stem 0.8.9*/ 
    /*0*/ <-0.55255,8.72622,-1.08444>,
    /*1*/ <-0.53812,8.73113,-1.07903>,<-0.56588,8.73458,-1.08067>,<-0.55366,8.71295,-1.09364>,
            
    /*2*/ <-0.45578,9.14252,-1.68715>,<-0.47429,9.14482,-1.68824>,<-0.46614,9.13041,-1.69689>,
            
    /*3*/ <-0.44635,9.59943,-2.26843>,<-0.45567,9.60002,-2.2682>,<-0.45153,9.5934,-2.27334>,
            
    /*4*/ <-0.40943,10.17284,-2.73171>

    /* stem 0.8.10*/ 
    /*0*/ <-0.60171,8.97726,-1.18093>,
    /*1*/ <-0.60488,8.98218,-1.16651>,<-0.61288,8.97721,-1.19176>,<-0.58738,8.97238,-1.18452>,
            
    /*2*/ <-0.4237,9.64838,-1.35978>,<-0.42904,9.64507,-1.37662>,<-0.41204,9.64184,-1.37179>,
            
    /*3*/ <-0.44865,10.33769,-1.55264>,<-0.45145,10.33535,-1.56085>,<-0.44266,10.33614,-1.55915>,
            
    /*4*/ <-0.60533,11.01508,-1.72627>

    /* stem 0.8.11*/ 
    /*0*/ <-0.64391,9.19273,-1.26374>,
    /*1*/ <-0.65869,9.1903,-1.26251>,<-0.63767,9.19437,-1.27732>,<-0.63537,9.19351,-1.2514>,
            
    /*2*/ <-0.76385,9.87975,-1.23036>,<-0.74983,9.88246,-1.24023>,<-0.7483,9.88189,-1.22295>,
            
    /*3*/ <-0.93436,10.54229,-1.36564>,<-0.92727,10.54316,-1.37057>,<-0.92692,10.54499,-1.3621>,
            
    /*4*/ <-1.16262,11.13558,-1.6533>

    /* stem 0.8.12*/ 
    /*0*/ <-0.67748,9.36416,-1.32963>,
    /*1*/ <-0.68098,9.35847,-1.34263>,<-0.66549,9.3724,-1.32824>,<-0.68598,9.3616,-1.31802>,
            
    /*2*/ <-1.04639,9.9183,-1.48356>,<-1.03607,9.92758,-1.47397>,<-1.04972,9.92039,-1.46715>,
            
    /*3*/ <-1.41064,10.48975,-1.57579>,<-1.40525,10.49403,-1.57092>,<-1.41199,10.4903,-1.56748>,
            
    /*4*/ <-1.6175,11.10187,-1.79657>

    /* stem 0.8.13*/ 
    /*0*/ <-0.713,9.54554,-1.39934>,
    /*1*/ <-0.70058,9.54534,-1.40618>,<-0.71595,9.55605,-1.3903>,<-0.72247,9.53522,-1.40155>,
            
    /*2*/ <-0.97347,9.89889,-1.90215>,<-0.98372,9.90603,-1.89156>,<-0.98807,9.89215,-1.89907>,
            
    /*3*/ <-1.14733,10.41223,-2.29085>,<-1.15214,10.41517,-2.28491>,<-1.15518,10.40995,-2.29044>,
            
    /*4*/ <-1.31826,11.00884,-2.53764>

    /* stem 0.8.14*/ 
    /*0*/ <-0.75309,9.75023,-1.47802>,
    /*1*/ <-0.74442,9.75547,-1.46881>,<-0.76649,9.75281,-1.47703>,<-0.74835,9.74242,-1.48821>,
            
    /*2*/ <-0.67301,10.28213,-1.8423>,<-0.68773,10.28035,-1.84779>,<-0.67563,10.27343,-1.85524>,
            
    /*3*/ <-0.74575,10.84962,-2.15085>,<-0.75312,10.84762,-2.1529>,<-0.74706,10.84581,-2.15765>,
            
    /*4*/ <-0.8514,11.44414,-2.38966>

    /* stem 0.8.15*/ 
    /*0*/ <-0.81074,10.04465,-1.59117>,
    /*1*/ <-0.81842,10.04706,-1.58098>,<-0.81577,10.04425,-1.60314>,<-0.79804,10.04263,-1.5894>,
            
    /*2*/ <-0.7097,10.65765,-1.64928>,<-0.70794,10.65577,-1.66405>,<-0.69611,10.65469,-1.65489>,
            
    /*3*/ <-0.57125,11.25793,-1.75218>,<-0.57042,11.25654,-1.7595>,<-0.56453,11.25597,-1.75488>,
            
    /*4*/ <-0.47693,11.85795,-1.89509>

    /* stem 0.8.16*/ 
    /*0*/ <-0.83721,10.17981,-1.64312>,
    /*1*/ <-0.8486,10.17602,-1.64717>,<-0.82827,10.18306,-1.65149>,<-0.83476,10.18034,-1.6307>,
            
    /*2*/ <-1.04244,10.75647,-1.63151>,<-1.02889,10.76116,-1.63439>,<-1.03321,10.75935,-1.62053>,
            
    /*3*/ <-1.10557,11.36272,-1.7013>,<-1.09839,11.36336,-1.70259>,<-1.10094,11.36388,-1.69575>,
            
    /*4*/ <-1.09728,11.96628,-1.80544>

    /* stem 0.8.17*/ 
    /*0*/ <-0.89302,10.4648,-1.75265>,
    /*1*/ <-0.89078,10.46095,-1.7638>,<-0.8855,10.4725,-1.74734>,<-0.90278,10.46094,-1.74682>,
            
    /*2*/ <-1.19962,10.91259,-1.97733>,<-1.1961,10.92029,-1.96635>,<-1.20762,10.91258,-1.96601>,
            
    /*3*/ <-1.47046,11.38921,-2.18825>,<-1.46855,11.39282,-2.18265>,<-1.47457,11.38939,-2.18267>,
            
    /*4*/ <-1.62004,11.89236,-2.45078>

    /* stem 0.8.18*/ 
    /*0*/ <-0.92548,10.63054,-1.81636>,
    /*1*/ <-0.91405,10.63234,-1.8175>,<-0.93195,10.63799,-1.81021>,<-0.93044,10.6213,-1.82136>,
            
    /*2*/ <-1.01362,10.93936,-2.29082>,<-1.02555,10.94312,-2.28596>,<-1.02454,10.93199,-2.29339>,
            
    /*3*/ <-1.17917,11.299,-2.70604>,<-1.18488,11.30025,-2.70274>,<-1.18461,11.29523,-2.7072>,
            
    /*4*/ <-1.32507,11.74086,-3.03998>

    /* stem 0.8.19*/ 
    /*0*/ <-0.96293,10.84759,-1.88985>,
    /*1*/ <-0.95988,10.85073,-1.87962>,<-0.97341,10.84917,-1.89328>,<-0.9555,10.84287,-1.89667>,
            
    /*2*/ <-0.82201,11.34962,-2.07793>,<-0.83102,11.34858,-2.08704>,<-0.81908,11.34438,-2.0893>,
            
    /*3*/ <-0.78363,11.86055,-2.29067>,<-0.78828,11.85918,-2.2949>,<-0.78212,11.85809,-2.29641>,
            
    /*4*/ <-0.76109,12.38354,-2.47232>

    /* stem 0.8.20*/ 
    /*0*/ <-1.00603,11.1647,-1.97444>,
    /*1*/ <-1.01509,11.16485,-1.96924>,<-1.00594,11.16595,-1.98482>,<-0.99706,11.16329,-1.96927>,
            
    /*2*/ <-0.96668,11.68681,-1.90769>,<-0.96058,11.68754,-1.91807>,<-0.95466,11.68577,-1.90771>,
            
    /*3*/ <-0.86342,12.20528,-1.89677>,<-0.86044,12.20483,-1.902>,<-0.85749,12.20413,-1.89678>,
            
    /*4*/ <-0.81954,12.73017,-1.92711>

    /* stem 0.8.21*/ 
    /*0*/ <-1.0416,11.42638,-2.04425>,
    /*1*/ <-1.04816,11.42365,-2.05112>,<-1.03375,11.43184,-2.04679>,<-1.04287,11.42364,-2.03483>,
            
    /*2*/ <-1.31175,11.84629,-1.96237>,<-1.30215,11.85175,-1.95948>,<-1.30823,11.84628,-1.95151>,
            
    /*3*/ <-1.46871,12.31945,-1.86952>,<-1.46336,12.32101,-1.86826>,<-1.46681,12.31905,-1.86414>,
            
    /*4*/ <-1.52239,12.82113,-1.90645>

    /* stem 0.8.22*/ 
    /*0*/ <-1.06935,11.63058,-2.09872>,
    /*1*/ <-1.06397,11.62927,-2.10639>,<-1.06721,11.63743,-2.09256>,<-1.07687,11.62504,-2.0972>,
            
    /*2*/ <-1.34632,11.94222,-2.35409>,<-1.34848,11.94767,-2.34487>,<-1.35491,11.93941,-2.34797>,
            
    /*3*/ <-1.50593,12.33507,-2.59602>,<-1.50691,12.33762,-2.59129>,<-1.51082,12.3346,-2.59362>,
            
    /*4*/ <-1.56902,12.77591,-2.79744>

    /* stem 0.8.23*/ 
    /*0*/ <-1.10833,11.91738,-2.17522>,
    /*1*/ <-1.10018,11.91927,-2.17229>,<-1.11532,11.92177,-2.17201>,<-1.10948,11.9111,-2.18136>,
            
    /*2*/ <-1.05644,12.23771,-2.50822>,<-1.06653,12.23938,-2.50803>,<-1.06264,12.23227,-2.51427>,
            
    /*3*/ <-1.08342,12.62479,-2.76493>,<-1.08849,12.62493,-2.76425>,<-1.08651,12.62241,-2.76824>,
            
    /*4*/ <-1.10895,13.04655,-2.9585>

    /* stem 0.8.24*/ 
    /*0*/ <-1.14162,12.16234,-2.24056>,
    /*1*/ <-1.14292,12.1643,-2.23254>,<-1.14713,12.1647,-2.24639>,<-1.13482,12.15801,-2.24276>,
            
    /*2*/ <-0.91915,12.54369,-2.29223>,<-0.92196,12.54396,-2.30146>,<-0.91376,12.53949,-2.29905>,
            
    /*3*/ <-0.74,12.94926,-2.31254>,<-0.74131,12.94964,-2.31717>,<-0.737,12.94779,-2.31602>,
            
    /*4*/ <-0.62033,13.37703,-2.30653>

    /* stem 0.8.25*/ 
    /*0*/ <-1.1797,12.44249,-2.31529>,
    /*1*/ <-1.18568,12.44184,-2.31468>,<-1.17742,12.44478,-2.3204>,<-1.17601,12.44086,-2.3108>,
            
    /*2*/ <-1.20924,12.82989,-2.15288>,<-1.20373,12.83184,-2.1567>,<-1.2028,12.82923,-2.15029>,
            
    /*3*/ <-1.26902,13.23961,-2.07758>,<-1.26625,13.24039,-2.07955>,<-1.26585,13.23982,-2.07613>,
            
    /*4*/ <-1.36886,13.64206,-2.00537>

    /* stem 0.8.26*/ 
    /*0*/ <-1.20915,12.65917,-2.37309>,
    /*1*/ <-1.21023,12.65812,-2.37648>,<-1.206,12.66107,-2.37265>,<-1.21123,12.65831,-2.37014>,
            
    /*2*/ <-1.41257,13.00413,-2.41812>,<-1.40975,13.0061,-2.41557>,<-1.41324,13.00426,-2.41389>,
            
    /*3*/ <-1.55351,13.37945,-2.4605>,<-1.55199,13.38018,-2.45919>,<-1.55388,13.37956,-2.45839>,
            
    /*4*/ <-1.64778,13.76719,-2.51691>

    /* stem 0.8.27*/ 
    /*0*/ <-1.23862,12.87596,-2.43092>,
    /*1*/ <-1.23743,12.87593,-2.43163>,<-1.23875,12.87678,-2.42983>,<-1.23967,12.87516,-2.43131>,
            
    /*2*/ <-1.36751,13.1574,-2.65964>,<-1.36839,13.15797,-2.65845>,<-1.369,13.15688,-2.65943>,
            
    /*3*/ <-1.44097,13.49509,-2.82896>,<-1.44139,13.49532,-2.82833>,<-1.44175,13.49494,-2.82893>,
            
    /*4*/ <-1.47897,13.85464,-2.9609>

    /* stem 0.9*/ 
    /*0*/ <0,7.26209,0>,
    /*1*/ <0.04571,7.26209,0.05447>,<-0.03074,7.29591,0.05448>,<-0.0647,7.28299,-0.0208>,
            <-0.00925,7.2412,-0.06733>,<0.05899,7.22828,-0.02081>,
    /*2*/ <0.91418,9.26019,-0.70521>,<0.86322,9.28273,-0.7052>,<0.84057,9.27412,-0.75539>,
            <0.87754,9.24626,-0.78641>,<0.92303,9.23765,-0.75539>,
    /*3*/ <1.59898,11.37869,-1.31076>,<1.5726,11.38762,-1.31001>,<1.56162,11.38421,-1.33539>,
            <1.58122,11.37318,-1.35183>,<1.60431,11.36977,-1.33661>,
    /*4*/ <2.09065,13.58897,-1.75426>

    /* stem 0.9.0*/ 
    /*0*/ <0.13996,7.57854,-0.11744>,
    /*1*/ <0.12956,7.58864,-0.10263>,<0.13503,7.58142,-0.13736>,<0.15528,7.56556,-0.11233>,
            
    /*2*/ <0.71898,8.25834,-0.15495>,<0.72263,8.25353,-0.1781>,<0.73613,8.24295,-0.16142>,
            
    /*3*/ <1.26048,8.95403,-0.30441>,<1.26163,8.95078,-0.31587>,<1.26927,8.9466,-0.30767>,
            
    /*4*/ <1.71492,9.72157,-0.33138>

    /* stem 0.9.1*/ 
    /*0*/ <0.21443,7.74692,-0.17993>,
    /*1*/ <0.19684,7.75136,-0.18893>,<0.23176,7.74838,-0.1903>,<0.21468,7.74102,-0.16055>,
            
    /*2*/ <0.284,8.58658,0.06779>,<0.30729,8.58459,0.06688>,<0.2959,8.57969,0.08671>,
            
    /*3*/ <0.38633,9.44096,0.24071>,<0.39795,9.43975,0.24018>,<0.39238,9.43836,0.25036>,
            
    /*4*/ <0.54806,10.2947,0.36913>

    /* stem 0.9.2*/ 
    /*0*/ <0.31466,7.97354,-0.26403>,
    /*1*/ <0.31684,7.96591,-0.28198>,<0.33031,7.98016,-0.25421>,<0.29682,7.97455,-0.25589>,
            
    /*2*/ <0.20313,8.74547,-0.6198>,<0.21211,8.75497,-0.60128>,<0.18978,8.75123,-0.6024>,
            
    /*3*/ <0.18449,9.58247,-0.81371>,<0.18906,9.58498,-0.80365>,<0.1778,9.58447,-0.80479>,
            
    /*4*/ <0.29891,10.41057,-1.00285>

    /* stem 0.9.3*/ 
    /*0*/ <0.38959,8.14296,-0.3269>,
    /*1*/ <0.40719,8.13541,-0.32627>,<0.38524,8.15806,-0.31594>,<0.37633,8.13541,-0.3385>,
            
    /*2*/ <0.64564,8.65592,-0.94303>,<0.63101,8.67102,-0.93614>,<0.62507,8.65591,-0.95118>,
            
    /*3*/ <0.88482,9.29135,-1.44126>,<0.87704,9.29785,-1.43682>,<0.87472,9.29173,-1.44574>,
            
    /*4*/ <1.12645,10.00325,-1.81983>

    /* stem 0.9.4*/ 
    /*0*/ <0.49323,8.3773,-0.41387>,
    /*1*/ <0.49883,8.38121,-0.39665>,<0.48207,8.38903,-0.42287>,<0.49879,8.36166,-0.42208>,
            
    /*2*/ <1.15138,8.77095,-0.70404>,<1.14021,8.77616,-0.72152>,<1.15136,8.75791,-0.72099>,
            
    /*3*/ <1.61433,9.36584,-1.02763>,<1.60724,9.36716,-1.03553>,<1.61531,9.36024,-1.0367>,
            
    /*4*/ <1.93266,10.07363,-1.29125>

    /* stem 0.9.5*/ 
    /*0*/ <0.58613,8.58735,-0.49182>,
    /*1*/ <0.57208,8.59614,-0.4849>,<0.58808,8.58614,-0.50963>,<0.59823,8.57978,-0.48093>,
            
    /*2*/ <1.00107,9.27195,-0.48697>,<1.01174,9.26529,-0.50346>,<1.01851,9.26105,-0.48432>,
            
    /*3*/ <1.39106,9.96823,-0.43772>,<1.39684,9.96566,-0.44594>,<1.40002,9.9632,-0.43638>,
            
    /*4*/ <1.75617,10.68002,-0.46703>

    /* stem 0.9.6*/ 
    /*0*/ <0.65373,8.74019,-0.54854>,
    /*1*/ <0.64225,8.74034,-0.56181>,<0.67089,8.74193,-0.55177>,<0.64805,8.7383,-0.53205>,
            
    /*2*/ <0.57953,9.52098,-0.49081>,<0.59862,9.52203,-0.48411>,<0.5834,9.51961,-0.47096>,
            
    /*3*/ <0.59355,10.30699,-0.4634>,<0.60312,10.30677,-0.46008>,<0.59546,10.30667,-0.45345>,
            
    /*4*/ <0.65165,11.09034,-0.49713>

    /* stem 0.9.7*/ 
    /*0*/ <0.76944,9.00183,-0.64564>,
    /*1*/ <0.77767,8.99366,-0.65786>,<0.77806,9.00967,-0.63347>,<0.7526,9.00216,-0.64558>,
            
    /*2*/ <0.78609,9.63332,-1.07223>,<0.78635,9.64399,-1.05597>,<0.76937,9.63899,-1.06404>,
            
    /*3*/ <0.76444,10.25858,-1.50737>,<0.76463,10.26419,-1.49942>,<0.75611,10.26131,-1.50314>,
            
    /*4*/ <0.96595,10.89151,-1.88028>

    /* stem 0.9.8*/ 
    /*0*/ <0.82098,9.11837,-0.68889>,
    /*1*/ <0.83544,9.11461,-0.68178>,<0.81288,9.13207,-0.68441>,<0.81464,9.10842,-0.70048>,
            
    /*2*/ <1.19294,9.50399,-1.21584>,<1.1779,9.51563,-1.21759>,<1.17907,9.49986,-1.2283>,
            
    /*3*/ <1.51597,10.03264,-1.64145>,<1.50784,10.03765,-1.64151>,<1.5095,10.03116,-1.64831>,
            
    /*4*/ <1.75036,10.69332,-1.91286>

    /* stem 0.9.9*/ 
    /*0*/ <0.92017,9.37052,-0.77211>,
    /*1*/ <0.91817,9.37534,-0.7571>,<0.9109,9.37636,-0.78363>,<0.93143,9.35987,-0.7756>,
            
    /*2*/ <1.39567,9.91366,-0.87211>,<1.39083,9.91434,-0.8898>,<1.40451,9.90334,-0.88444>,
            
    /*3*/ <1.7763,10.52048,-1.00463>,<1.77353,10.52037,-1.01338>,<1.78126,10.51606,-1.01096>,
            
    /*4*/ <2.13452,11.13117,-1.17821>

    /* stem 0.9.10*/ 
    /*0*/ <0.97726,9.54329,-0.82002>,
    /*1*/ <0.96258,9.54818,-0.81986>,<0.98568,9.54453,-0.83293>,<0.9835,9.53715,-0.80727>,
            
    /*2*/ <1.18574,10.19437,-0.61505>,<1.20114,10.19194,-0.62376>,<1.19968,10.18702,-0.60666>,
            
    /*3*/ <1.35716,10.88323,-0.55075>,<1.36478,10.88181,-0.55519>,<1.36458,10.88102,-0.5463>,
            
    /*4*/ <1.45614,11.58351,-0.45928>

    /* stem 0.9.11*/ 
    /*0*/ <1.05157,9.76819,-0.88238>,
    /*1*/ <1.04708,9.76579,-0.8964>,<1.06602,9.77049,-0.87946>,<1.04162,9.76831,-0.87127>,
            
    /*2*/ <0.95809,10.44906,-0.97971>,<0.97072,10.45219,-0.96842>,<0.95445,10.45074,-0.96296>,
            
    /*3*/ <0.96185,11.13627,-1.07835>,<0.9682,11.13712,-1.0726>,<0.95999,11.13753,-1.07004>,
            
    /*4*/ <0.93448,11.8136,-1.22543>

    /* stem 0.9.12*/ 
    /*0*/ <1.13869,10.03183,-0.95547>,
    /*1*/ <1.1503,10.02628,-0.96166>,<1.14007,10.04083,-0.94448>,<1.1257,10.02838,-0.96029>,
            
    /*2*/ <1.16686,10.54593,-1.38598>,<1.16004,10.55563,-1.37452>,<1.15046,10.54733,-1.38506>,
            
    /*3*/ <1.20275,11.11992,-1.7329>,<1.19928,11.12399,-1.72663>,<1.19455,11.12071,-1.73253>,
            
    /*4*/ <1.28016,11.72408,-2.01471>

    /* stem 0.9.13*/ 
    /*0*/ <1.20195,10.22326,-1.00855>,
    /*1*/ <1.21116,10.22307,-0.99826>,<1.19133,10.2321,-1.00816>,<1.20334,10.21461,-1.01924>,
            
    /*2*/ <1.56849,10.66981,-1.31605>,<1.55527,10.67583,-1.32265>,<1.56328,10.66417,-1.33004>,
            
    /*3*/ <1.78992,11.1866,-1.65386>,<1.7825,11.18826,-1.65627>,<1.78713,11.18344,-1.66062>,
            
    /*4*/ <1.90626,11.78808,-1.8839>

    /* stem 0.9.14*/ 
    /*0*/ <1.2581,10.39321,-1.05567>,
    /*1*/ <1.25122,10.39834,-1.04537>,<1.25423,10.39576,-1.06826>,<1.26886,10.38553,-1.0534>,
            
    /*2*/ <1.62657,10.91607,-1.05834>,<1.62858,10.91435,-1.0736>,<1.63833,10.90752,-1.06369>,
            
    /*3*/ <1.92616,11.47978,-1.0858>,<1.92715,11.47894,-1.09344>,<1.93253,11.47632,-1.08853>,
            
    /*4*/ <2.20752,12.05296,-1.05614>

    /* stem 0.9.15*/ 
    /*0*/ <1.34319,10.65069,-1.12707>,
    /*1*/ <1.33169,10.65308,-1.13218>,<1.35377,10.65226,-1.1341>,<1.3441,10.64675,-1.11492>,
            
    /*2*/ <1.37356,11.23897,-0.94278>,<1.38828,11.23843,-0.94406>,<1.38183,11.23475,-0.93127>,
            
    /*3*/ <1.44202,11.84239,-0.83372>,<1.44935,11.84174,-0.83446>,<1.44622,11.8409,-0.82782>,
            
    /*4*/ <1.62425,12.43243,-0.84066>

    /* stem 0.9.16*/ 
    /*0*/ <1.40097,10.82555,-1.17555>,
    /*1*/ <1.40232,10.82185,-1.1873>,<1.41093,10.82848,-1.16879>,<1.38965,10.82633,-1.17056>,
            
    /*2*/ <1.35939,11.39429,-1.36839>,<1.36514,11.39871,-1.35605>,<1.35094,11.39728,-1.35723>,
            
    /*3*/ <1.38731,11.96503,-1.55693>,<1.39019,11.967,-1.55069>,<1.38309,11.96707,-1.55153>,
            
    /*4*/ <1.56964,12.51452,-1.72164>

    /* stem 0.9.17*/ 
    /*0*/ <1.49216,11.10153,-1.25207>,
    /*1*/ <1.50329,11.09776,-1.25239>,<1.48913,11.11029,-1.24484>,<1.48406,11.09653,-1.25898>,
            
    /*2*/ <1.61748,11.48272,-1.66799>,<1.60803,11.49107,-1.66296>,<1.60466,11.4819,-1.67238>,
            
    /*3*/ <1.72148,11.96066,-1.97683>,<1.7165,11.9639,-1.97356>,<1.71515,11.9605,-1.97927>,
            
    /*4*/ <1.93137,12.4477,-2.20477>

    /* stem 0.9.18*/ 
    /*0*/ <1.54308,11.25562,-1.29479>,
    /*1*/ <1.54669,11.25738,-1.28412>,<1.53415,11.26146,-1.29883>,<1.54839,11.24801,-1.30143>,
            
    /*2*/ <1.89363,11.66088,-1.47239>,<1.88527,11.66359,-1.4822>,<1.89476,11.65463,-1.48393>,
            
    /*3*/ <2.16694,12.12657,-1.63646>,<2.16248,12.12755,-1.64121>,<2.16787,12.12396,-1.64243>,
            
    /*4*/ <2.26231,12.66367,-1.78224>

    /* stem 0.9.19*/ 
    /*0*/ <1.60673,11.4789,-1.34821>,
    /*1*/ <1.59763,11.48198,-1.34304>,<1.60807,11.48127,-1.35876>,<1.61448,11.47346,-1.34281>,
            
    /*2*/ <1.83754,11.95304,-1.20895>,<1.8445,11.95256,-1.21943>,<1.84877,11.94736,-1.2088>,
            
    /*3*/ <2.04207,12.44832,-1.10897>,<2.04551,12.44801,-1.11424>,<2.04789,12.44593,-1.1088>,
            
    /*4*/ <2.12479,12.97998,-1.02432>

    /* stem 0.9.20*/ 
    /*0*/ <1.66775,11.745,-1.39941>,
    /*1*/ <1.66073,11.74516,-1.40698>,<1.67782,11.74551,-1.4017>,<1.66472,11.74434,-1.38956>,
            
    /*2*/ <1.6434,12.26707,-1.3755>,<1.65479,12.2673,-1.37198>,<1.64606,12.26653,-1.36389>,
            
    /*3*/ <1.63621,12.78314,-1.28615>,<1.64191,12.78295,-1.28439>,<1.63753,12.7822,-1.28041>,
            
    /*4*/ <1.62236,13.3013,-1.21636>

    /* stem 0.9.21*/ 
    /*0*/ <1.72163,11.97993,-1.44462>,
    /*1*/ <1.72682,11.97722,-1.45251>,<1.72568,11.98579,-1.43785>,<1.71239,11.97678,-1.4435>,
            
    /*2*/ <1.55706,12.38209,-1.6991>,<1.55629,12.3878,-1.68932>,<1.54743,12.38179,-1.69309>,
            
    /*3*/ <1.45324,12.83429,-1.89536>,<1.45304,12.83654,-1.89015>,<1.44833,12.83443,-1.89251>,
            
    /*4*/ <1.4684,13.31656,-2.03908>

    /* stem 0.9.22*/ 
    /*0*/ <1.76956,12.1889,-1.48484>,
    /*1*/ <1.77818,12.1876,-1.48135>,<1.76355,12.19466,-1.48048>,<1.76694,12.18445,-1.49268>,
            
    /*2*/ <1.93932,12.56035,-1.74848>,<1.92958,12.56506,-1.7479>,<1.93184,12.55825,-1.75604>,
            
    /*3*/ <2.0396,12.96484,-2.00005>,<2.03451,12.96656,-1.99936>,<2.03579,12.96356,-2.00369>,
            
    /*4*/ <2.19368,13.39361,-2.16801>

    /* stem 0.9.23*/ 
    /*0*/ <1.84831,12.53231,-1.55092>,
    /*1*/ <1.84731,12.53416,-1.5425>,<1.84328,12.53617,-1.55684>,<1.85435,12.5266,-1.55342>,
            
    /*2*/ <2.15251,12.87237,-1.58353>,<2.14982,12.87371,-1.59308>,<2.1572,12.86733,-1.59081>,
            
    /*3*/ <2.40948,13.24996,-1.58444>,<2.40826,13.25081,-1.58922>,<2.4123,13.24806,-1.58812>,
            
    /*4*/ <2.62388,13.65126,-1.54093>

    /* stem 0.9.24*/ 
    /*0*/ <1.8967,12.74329,-1.59152>,
    /*1*/ <1.88871,12.74523,-1.59098>,<1.90075,12.74441,-1.59861>,<1.90065,12.74023,-1.58496>,
            
    /*2*/ <1.99853,13.15212,-1.46537>,<2.00656,13.15158,-1.47046>,<2.00649,13.14879,-1.46136>,
            
    /*3*/ <2.10267,13.57336,-1.3942>,<2.10662,13.57285,-1.3968>,<2.10674,13.57203,-1.39211>,
            
    /*4*/ <2.2022,13.98846,-1.28854>

    /* stem 0.9.25*/ 
    /*0*/ <1.96175,13.02692,-1.6461>,
    /*1*/ <1.95981,13.02627,-1.65177>,<1.96753,13.02825,-1.64502>,<1.95791,13.02623,-1.64151>,
            
    /*2*/ <1.86952,13.43223,-1.66518>,<1.87466,13.43355,-1.66068>,<1.86825,13.4322,-1.65834>,
            
    /*3*/ <1.78937,13.83797,-1.70854>,<1.79193,13.83873,-1.70631>,<1.7887,13.83822,-1.70514>,
            
    /*4*/ <1.71308,14.24707,-1.71786>

    /* stem 0.9.26*/ 
    /*0*/ <1.99453,13.16984,-1.67361>,
    /*1*/ <1.99824,13.16857,-1.6758>,<1.99486,13.17232,-1.66987>,<1.99048,13.16863,-1.67514>,
            
    /*2*/ <1.98102,13.50601,-1.89756>,<1.97877,13.50851,-1.89361>,<1.97585,13.50606,-1.89712>,
            
    /*3*/ <1.98259,13.87576,-2.06113>,<1.98147,13.87672,-2.059>,<1.98001,13.87586,-2.06096>,
            
    /*4*/ <2.01123,14.25391,-2.20078>

    /* stem 0.9.27*/ 
    /*0*/ <2.04898,13.4073,-1.7193>,
    /*1*/ <2.05033,13.40726,-1.7179>,<2.04735,13.40834,-1.71906>,<2.04927,13.4063,-1.72095>,
            
    /*2*/ <2.22131,13.71379,-1.87445>,<2.21933,13.71451,-1.87522>,<2.2206,13.71315,-1.87648>,
            
    /*3*/ <2.40695,14.01407,-2.02625>,<2.40598,14.01446,-2.02666>,<2.4066,14.01376,-2.02728>,
            
    /*4*/ <2.57332,14.32453,-2.18005>

    /* stem 0.10*/ 
    /*0*/ <0,7.87886,0>,
    /*1*/ <-0.04201,7.87886,0.05575>,<-0.0589,7.91206,-0.01737>,<0.00561,7.89938,-0.06649>,
            <0.06236,7.85835,-0.02372>,<0.03293,7.84567,0.05183>,
    /*2*/ <0.88032,9.8488,0.72164>,<0.86906,9.87093,0.67289>,<0.91206,9.86247,0.64015>,
            <0.9499,9.83512,0.66866>,<0.93028,9.82667,0.71902>,
    /*3*/ <1.61386,11.93745,1.24526>,<1.6073,11.94622,1.22019>,<1.62916,11.94287,1.20409>,
            <1.64922,11.93203,1.2192>,<1.63976,11.92869,1.24465>,
    /*4*/ <2.14888,14.11658,1.6193>

    /* stem 0.10.0*/ 
    /*0*/ <0.10508,8.10675,0.07918>,
    /*1*/ <0.08843,8.11678,0.07243>,<0.1236,8.11113,0.07136>,<0.10321,8.09236,0.09376>,
            
    /*2*/ <0.21259,8.73256,0.70128>,<0.23604,8.72879,0.70056>,<0.22245,8.71628,0.7155>,
            
    /*3*/ <0.47201,9.3515,1.28628>,<0.48336,9.34834,1.28471>,<0.47684,9.3431,1.29315>,
            
    /*4*/ <0.75706,10.05844,1.74255>

    /* stem 0.10.1*/ 
    /*0*/ <0.23696,8.39277,0.17856>,
    /*1*/ <0.24166,8.39711,0.15984>,<0.25114,8.39158,0.1923>,<0.21807,8.38963,0.18354>,
            
    /*2*/ <0.14548,9.23567,0.33688>,<0.1518,9.23198,0.35852>,<0.12975,9.23069,0.35268>,
            
    /*3*/ <0.29175,10.04026,0.61286>,<0.29482,10.03627,0.62311>,<0.28391,10.03895,0.62106>,
            
    /*4*/ <0.53605,10.82481,0.87393>

    /* stem 0.10.2*/ 
    /*0*/ <0.31237,8.55631,0.23538>,
    /*1*/ <0.33008,8.5488,0.2335>,<0.30651,8.56308,0.25252>,<0.30051,8.55706,0.22013>,
            
    /*2*/ <0.62776,9.317,0.03552>,<0.61205,9.32652,0.0482>,<0.60804,9.32251,0.02661>,
            
    /*3*/ <0.99419,10.07222,-0.07308>,<0.98637,10.07701,-0.06671>,<0.98484,10.07617,-0.07773>,
            
    /*4*/ <1.39999,10.80626,-0.19091>

    /* stem 0.10.3*/ 
    /*0*/ <0.38356,8.71072,0.28904>,
    /*1*/ <0.38687,8.70327,0.3061>,<0.37113,8.72484,0.28713>,<0.3927,8.70406,0.27388>,
            
    /*2*/ <0.99548,9.25967,0.42436>,<0.98499,9.27405,0.41171>,<0.99937,9.26019,0.40288>,
            
    /*3*/ <1.36362,10.00197,0.52774>,<1.35647,10.00655,0.52087>,<1.36584,10.00244,0.51706>,
            
    /*4*/ <1.5402,10.81354,0.60104>

    /* stem 0.10.4*/ 
    /*0*/ <0.508,8.98059,0.3828>,
    /*1*/ <0.49277,8.98443,0.39196>,<0.51458,8.99247,0.37072>,<0.51664,8.96487,0.38573>,
            
    /*2*/ <0.93596,9.33245,0.9712>,<0.95051,9.33781,0.95705>,<0.95188,9.31941,0.96705>,
            
    /*3*/ <1.33927,9.83564,1.45776>,<1.34602,9.83782,1.45003>,<1.34797,9.82988,1.45662>,
            
    /*4*/ <1.70613,10.39211,1.91437>

    /* stem 0.10.5*/ 
    /*0*/ <0.56441,9.10292,0.42531>,
    /*1*/ <0.55456,9.11165,0.41325>,<0.58216,9.10476,0.42536>,<0.55649,9.09236,0.43733>,
            
    /*2*/ <0.49275,9.72593,0.917>,<0.51115,9.72133,0.92508>,<0.49404,9.71307,0.93306>,
            
    /*3*/ <0.50485,10.40061,1.33956>,<0.51407,10.3981,1.34341>,<0.50548,10.3952,1.3483>,
            
    /*4*/ <0.437,11.10975,1.69476>

    /* stem 0.10.6*/ 
    /*0*/ <0.68623,9.36714,0.51711>,
    /*1*/ <0.69634,9.36729,0.50327>,<0.69311,9.3655,0.53273>,<0.66925,9.36862,0.51534>,
            
    /*2*/ <0.75451,10.13533,0.56111>,<0.75236,10.13414,0.58076>,<0.73645,10.13622,0.56916>,
            
    /*3*/ <0.91795,10.86866,0.74283>,<0.91662,10.86664,0.75243>,<0.90899,10.86971,0.74692>,
            
    /*4*/ <0.98657,11.59697,0.99335>

    /* stem 0.10.7*/ 
    /*0*/ <0.75366,9.51338,0.56793>,
    /*1*/ <0.76735,9.50525,0.57316>,<0.74534,9.52342,0.57845>,<0.7483,9.51147,0.55217>,
            
    /*2*/ <1.19384,10.09339,0.35376>,<1.17917,10.1055,0.35729>,<1.18114,10.09754,0.33977>,
            
    /*3*/ <1.52554,10.76002,0.20003>,<1.51733,10.76467,0.20216>,<1.51902,10.76174,0.1931>,
            
    /*4*/ <1.86422,11.43237,0.10548>

    /* stem 0.10.8*/ 
    /*0*/ <0.84658,9.7149,0.63795>,
    /*1*/ <0.84298,9.71122,0.65333>,<0.83879,9.727,0.63046>,<0.85798,9.70649,0.63005>,
            
    /*2*/ <1.35923,10.18946,0.8831>,<1.35644,10.19998,0.86786>,<1.36924,10.1863,0.86759>,
            
    /*3*/ <1.77594,10.75903,1.10687>,<1.77398,10.76364,1.09896>,<1.78145,10.75801,1.09937>,
            
    /*4*/ <2.06427,11.41087,1.30717>

    /* stem 0.10.9*/ 
    /*0*/ <0.9347,9.92535,0.70434>,
    /*1*/ <0.91982,9.93011,0.70576>,<0.94453,9.93307,0.69488>,<0.93973,9.91287,0.71239>,
            
    /*2*/ <1.11414,10.35806,1.25283>,<1.13062,10.36004,1.24558>,<1.12742,10.34657,1.25726>,
            
    /*3*/ <1.24313,10.96932,1.61035>,<1.25124,10.97,1.60638>,<1.2504,10.96558,1.61424>,
            
    /*4*/ <1.45033,11.62166,1.83937>

    /* stem 0.10.10*/ 
    /*0*/ <1.01633,10.16231,0.76586>,
    /*1*/ <1.01295,10.16708,0.75193>,<1.03067,10.1623,0.77056>,<1.00535,10.15754,0.77507>,
            
    /*2*/ <0.9349,10.8178,0.99957>,<0.94671,10.8146,1.01199>,<0.92983,10.81144,1.015>,
            
    /*3*/ <0.83521,11.4963,1.13436>,<0.84102,11.49592,1.14086>,<0.83259,11.49437,1.14245>,
            
    /*4*/ <0.88251,12.18357,1.26284>

    /* stem 0.10.11*/ 
    /*0*/ <1.07142,10.32224,0.80738>,
    /*1*/ <1.0839,10.31987,0.79995>,<1.07193,10.32738,0.82115>,<1.05844,10.31947,0.80103>,
            
    /*2*/ <1.05948,10.96394,0.56311>,<1.0515,10.96895,0.57725>,<1.04251,10.96368,0.56383>,
            
    /*3*/ <1.07531,11.63253,0.40671>,<1.07132,11.63437,0.41397>,<1.06683,11.63283,0.40693>,
            
    /*4*/ <1.06928,12.31857,0.36663>

    /* stem 0.10.12*/ 
    /*0*/ <1.16209,10.58544,0.8757>,
    /*1*/ <1.17061,10.57997,0.88548>,<1.15196,10.59446,0.87944>,<1.16371,10.58189,0.86218>,
            
    /*2*/ <1.58847,11.08843,0.7994>,<1.57603,11.09809,0.79538>,<1.58387,11.08971,0.78387>,
            
    /*3*/ <2.01231,11.59773,0.77364>,<2.00624,11.60275,0.77164>,<2.01045,11.59894,0.76582>,
            
    /*4*/ <2.41562,12.12487,0.76417>

    /* stem 0.10.13*/ 
    /*0*/ <1.23586,10.79956,0.93129>,
    /*1*/ <1.22805,10.79938,0.94237>,<1.23329,10.80841,0.92133>,<1.24624,10.79091,0.93016>,
            
    /*2*/ <1.61998,11.22986,1.22023>,<1.62347,11.23588,1.2062>,<1.63211,11.22421,1.21208>,
            
    /*3*/ <1.90835,11.75722,1.45359>,<1.90975,11.75974,1.44631>,<1.91501,11.75524,1.44997>,
            
    /*4*/ <2.1337,12.30722,1.7034>

    /* stem 0.10.14*/ 
    /*0*/ <1.31972,11.04299,0.99448>,
    /*1*/ <1.3085,11.04796,0.99023>,<1.33097,11.04731,0.98965>,<1.31969,11.0337,1.00356>,
            
    /*2*/ <1.33635,11.48196,1.43754>,<1.35134,11.48152,1.43715>,<1.34381,11.47245,1.44642>,
            
    /*3*/ <1.44236,12.00131,1.76644>,<1.44976,12.00037,1.76563>,<1.44622,11.99737,1.77152>,
            
    /*4*/ <1.61125,12.58,1.92646>

    /* stem 0.10.15*/ 
    /*0*/ <1.363,11.16862,1.02709>,
    /*1*/ <1.36537,11.17098,1.01485>,<1.3722,11.17001,1.03572>,<1.35142,11.16488,1.03071>,
            
    /*2*/ <1.20062,11.75519,1.0999>,<1.20517,11.75454,1.11382>,<1.19132,11.75112,1.11047>,
            
    /*3*/ <1.09797,12.33817,1.26218>,<1.10044,12.33678,1.26893>,<1.09333,12.33595,1.2674>,
            
    /*4*/ <1.05209,12.92317,1.43933>

    /* stem 0.10.16*/ 
    /*0*/ <1.45484,11.43522,1.0963>,
    /*1*/ <1.46629,11.43162,1.09501>,<1.45112,11.43986,1.10681>,<1.44712,11.4342,1.08709>,
            
    /*2*/ <1.61171,11.97244,0.91034>,<1.6016,11.97793,0.91821>,<1.59893,11.97416,0.90506>,
            
    /*3*/ <1.77566,12.52821,0.80125>,<1.77049,12.53057,0.80528>,<1.76941,12.52955,0.79848>,
            
    /*4*/ <1.92936,13.09757,0.81395>

    /* stem 0.10.17*/ 
    /*0*/ <1.51476,11.60916,1.14146>,
    /*1*/ <1.51756,11.60542,1.15215>,<1.50697,11.61774,1.14013>,<1.51977,11.60432,1.13209>,
            
    /*2*/ <1.93935,11.99494,1.17386>,<1.93228,12.00315,1.16584>,<1.94082,11.9942,1.16048>,
            
    /*3*/ <2.20369,12.4956,1.27185>,<2.19942,12.49872,1.26768>,<2.20517,12.49615,1.2653>,
            
    /*4*/ <2.34662,13.05198,1.30282>

    /* stem 0.10.18*/ 
    /*0*/ <1.60094,11.85932,1.2064>,
    /*1*/ <1.59162,11.86104,1.21216>,<1.60311,11.86544,1.1974>,<1.6081,11.85149,1.20964>,
            
    /*2*/ <1.85752,12.23093,1.52521>,<1.86518,12.23386,1.51537>,<1.86851,12.22456,1.52353>,
            
    /*3*/ <2.05866,12.65793,1.81157>,<2.06251,12.65945,1.80668>,<2.06455,12.65543,1.81124>,
            
    /*4*/ <2.2352,13.11017,2.07567>

    /* stem 0.10.19*/ 
    /*0*/ <1.6486,12.0242,1.24231>,
    /*1*/ <1.64164,12.02723,1.23473>,<1.65905,12.02632,1.24115>,<1.64511,12.01904,1.25105>,
            
    /*2*/ <1.57574,12.49782,1.48847>,<1.58735,12.49722,1.49275>,<1.57806,12.49236,1.49935>,
            
    /*3*/ <1.64671,12.97934,1.72153>,<1.65251,12.97778,1.72307>,<1.64784,12.97658,1.72696>,
            
    /*4*/ <1.76449,13.49706,1.80935>

    /* stem 0.10.20*/ 
    /*0*/ <1.71694,12.31004,1.29381>,
    /*1*/ <1.72262,12.31019,1.28544>,<1.72105,12.3124,1.30275>,<1.70716,12.30753,1.29324>,
            
    /*2*/ <1.59822,12.80465,1.21417>,<1.59717,12.80612,1.22571>,<1.58791,12.80287,1.21938>,
            
    /*3*/ <1.5557,13.31676,1.1855>,<1.55525,13.31709,1.19131>,<1.55044,13.3165,1.18804>,
            
    /*4*/ <1.6162,13.81962,1.27934>

    /* stem 0.10.21*/ 
    /*0*/ <1.77933,12.57096,1.34082>,
    /*1*/ <1.78795,12.56832,1.34401>,<1.77382,12.57671,1.34611>,<1.77621,12.56784,1.33233>,
            
    /*2*/ <1.98638,12.9627,1.12455>,<1.97697,12.9683,1.12594>,<1.97856,12.96238,1.11676>,
            
    /*3*/ <2.22626,13.35786,0.95511>,<2.2217,13.36092,0.9557>,<2.22266,13.35829,0.95094>,
            
    /*4*/ <2.41328,13.78322,0.78921>

    /* stem 0.10.22*/ 
    /*0*/ <1.81775,12.73165,1.36977>,
    /*1*/ <1.81631,12.73037,1.3788>,<1.81241,12.7375,1.36504>,<1.82452,12.72709,1.36548>,
            
    /*2*/ <2.12059,13.08843,1.47492>,<2.11798,13.09318,1.46574>,<2.12606,13.08624,1.46604>,
            
    /*3*/ <2.28767,13.53346,1.54058>,<2.28583,13.53489,1.53579>,<2.29077,13.53296,1.53628>,
            
    /*4*/ <2.44755,13.98602,1.54566>

    /* stem 0.10.23*/ 
    /*0*/ <1.88314,13.00516,1.41905>,
    /*1*/ <1.87473,13.007,1.41997>,<1.88787,13.00933,1.41311>,<1.88683,12.99914,1.42407>,
            
    /*2*/ <1.98155,13.32736,1.72754>,<1.99031,13.3289,1.72297>,<1.98962,13.32212,1.73028>,
            
    /*3*/ <2.03798,13.69931,1.98537>,<2.04237,13.70021,1.98317>,<2.04217,13.69738,1.98729>,
            
    /*4*/ <2.06885,14.08758,2.22366>

    /* stem 0.10.24*/ 
    /*0*/ <1.94001,13.24299,1.4619>,
    /*1*/ <1.93771,13.24491,1.4543>,<1.94771,13.2443,1.46429>,<1.9346,13.23976,1.46711>,
            
    /*2*/ <1.82849,13.64514,1.59134>,<1.83516,13.64473,1.59801>,<1.82642,13.6417,1.59989>,
            
    /*3*/ <1.81611,14.07503,1.66558>,<1.8195,14.07459,1.66883>,<1.81496,14.07425,1.67009>,
            
    /*4*/ <1.92628,14.48512,1.77016>

    /* stem 0.10.25*/ 
    /*0*/ <2.0076,13.52569,1.51283>,
    /*1*/ <2.01293,13.52501,1.50952>,<2.00785,13.52732,1.51892>,<2.00202,13.52473,1.51005>,
            
    /*2*/ <1.99596,13.92436,1.40441>,<1.99258,13.9259,1.41068>,<1.98869,13.92417,1.40477>,
            
    /*3*/ <1.99368,14.31815,1.27975>,<1.99199,14.31913,1.28283>,<1.99004,14.3182,1.2799>,
            
    /*4*/ <2.05023,14.71726,1.18918>

    /* stem 0.10.26*/ 
    /*0*/ <2.05756,13.73463,1.55048>,
    /*1*/ <2.06025,13.73347,1.55331>,<2.05466,13.73735,1.55141>,<2.05775,13.73306,1.54672>,
            
    /*2*/ <2.30053,14.02792,1.44257>,<2.2968,14.0305,1.4413>,<2.29886,14.02765,1.43817>,
            
    /*3*/ <2.50383,14.36171,1.37963>,<2.50184,14.36282,1.37904>,<2.50311,14.36173,1.37739>,
            
    /*4*/ <2.66496,14.72074,1.3362>

    /* stem 0.10.27*/ 
    /*0*/ <2.11891,13.99123,1.59671>,
    /*1*/ <2.11818,13.99121,1.59783>,<2.1185,13.99196,1.59566>,<2.12005,13.99053,1.59664>,
            
    /*2*/ <2.30772,14.28659,1.72824>,<2.30794,14.2871,1.7268>,<2.30897,14.28615,1.72745>,
            
    /*3*/ <2.47849,14.61006,1.80859>,<2.47855,14.61021,1.80783>,<2.47912,14.60983,1.80819>,
            
    /*4*/ <2.54845,14.96188,1.91557>

    /* stem 0.11*/ 
    /*0*/ <0,8.22871,0>,
    /*1*/ <-0.06305,8.22871,-0.02807>,<0.00364,8.26153,-0.0606>,<0.06529,8.24899,-0.00938>,
            <0.03672,8.20843,0.0548>,<-0.0426,8.19589,0.04325>,
    /*2*/ <-0.50058,10.18141,1.01121>,<-0.45613,10.20329,0.98952>,<-0.41502,10.19493,1.02367>,
            <-0.43407,10.16789,1.06646>,<-0.48695,10.15953,1.05876>,
    /*3*/ <-0.84281,12.25179,1.83643>,<-0.82012,12.26045,1.82454>,<-0.79975,12.25714,1.84201>,
            <-0.80985,12.24643,1.8647>,<-0.83646,12.24312,1.86125>,
    /*4*/ <-1.08483,14.41185,2.43656>

    /* stem 0.11.0*/ 
    /*0*/ <-0.06196,8.49257,0.13917>,
    /*1*/ <-0.05917,8.50243,0.12172>,<-0.04914,8.49543,0.15456>,<-0.07757,8.47985,0.14122>,
            
    /*2*/ <-0.55916,9.15882,0.42051>,<-0.55247,9.15415,0.44241>,<-0.57142,9.14377,0.43352>,
            
    /*3*/ <-0.85028,9.89933,0.79037>,<-0.84622,9.89583,0.80075>,<-0.85713,9.89314,0.79754>,
            
    /*4*/ <-0.93992,10.66751,1.20503>

    /* stem 0.11.1*/ 
    /*0*/ <-0.11167,8.70425,0.25082>,
    /*1*/ <-0.0925,8.70856,0.25118>,<-0.12174,8.70279,0.26763>,<-0.12077,8.7014,0.23363>,
            
    /*2*/ <-0.28606,9.54351,0.21161>,<-0.30555,9.53967,0.22257>,<-0.30491,9.53874,0.19991>,
            
    /*3*/ <-0.49657,10.37486,0.24549>,<-0.50617,10.37228,0.25096>,<-0.50605,10.37277,0.23962>,
            
    /*4*/ <-0.75989,11.16992,0.43382>

    /* stem 0.11.2*/ 
    /*0*/ <-0.16342,8.92464,0.36706>,
    /*1*/ <-0.15769,8.91723,0.38364>,<-0.18108,8.93157,0.36532>,<-0.15151,8.9251,0.3522>,
            
    /*2*/ <0.11295,9.6738,0.62034>,<0.09736,9.68336,0.60813>,<0.11707,9.67904,0.59939>,
            
    /*3*/ <0.26583,10.44837,0.90042>,<0.25782,10.45234,0.89402>,<0.2681,10.4517,0.89018>,
            
    /*4*/ <0.43419,11.22005,1.17927>

    /* stem 0.11.3*/ 
    /*0*/ <-0.2028,9.09233,0.4555>,
    /*1*/ <-0.21842,9.085,0.46244>,<-0.20345,9.10827,0.44596>,<-0.18654,9.08371,0.45811>,
            
    /*2*/ <-0.10145,9.50899,1.15706>,<-0.09147,9.5245,1.14608>,<-0.08019,9.50812,1.15417>,
            
    /*3*/ <-0.06251,10.16794,1.64975>,<-0.05773,10.17356,1.64197>,<-0.05181,10.16798,1.64897>,
            
    /*4*/ <0.02831,10.84757,2.10432>

    /* stem 0.11.4*/ 
    /*0*/ <-0.23747,9.23996,0.53337>,
    /*1*/ <-0.24983,9.24381,0.52058>,<-0.22211,9.24965,0.53438>,<-0.24048,9.22643,0.54515>,
            
    /*2*/ <-0.60626,9.76151,1.02915>,<-0.58779,9.76541,1.03835>,<-0.60003,9.74993,1.04552>,
            
    /*3*/ <-0.88753,10.4198,1.4026>,<-0.87811,10.42144,1.40694>,<-0.88524,10.41556,1.41193>,
            
    /*4*/ <-1.02886,11.12251,1.77805>

    /* stem 0.11.5*/ 
    /*0*/ <-0.29225,9.47325,0.65641>,
    /*1*/ <-0.28287,9.48184,0.64431>,<-0.28675,9.47278,0.67309>,<-0.30714,9.46513,0.65185>,
            
    /*2*/ <-0.69115,10.13623,0.80052>,<-0.69374,10.13019,0.81971>,<-0.70733,10.12509,0.80555>,
            
    /*3*/ <-1.02598,10.8015,1.05581>,<-1.02678,10.7976,1.06513>,<-1.03431,10.79637,1.05845>,
            
    /*4*/ <-1.27006,11.48959,1.34889>

    /* stem 0.11.6*/ 
    /*0*/ <-0.3503,9.72041,0.78678>,
    /*1*/ <-0.33475,9.72056,0.79342>,<-0.36382,9.72077,0.79691>,<-0.35232,9.71991,0.77>,
            
    /*2*/ <-0.33722,10.48427,0.76789>,<-0.3566,10.48441,0.77022>,<-0.34893,10.48383,0.75228>,
            
    /*3*/ <-0.39004,11.23925,0.65413>,<-0.39972,11.23881,0.65528>,<-0.39581,11.23774,0.6464>,
            
    /*4*/ <-0.37704,12.00209,0.67716>

    /* stem 0.11.7*/ 
    /*0*/ <-0.39313,9.9028,0.88298>,
    /*1*/ <-0.39511,9.89484,0.8972>,<-0.40527,9.91212,0.87702>,<-0.379,9.90146,0.87471>,
            
    /*2*/ <-0.12257,10.4879,1.26111>,<-0.12935,10.49942,1.24766>,<-0.11183,10.49232,1.24612>,
            
    /*3*/ <0.05256,11.14016,1.58282>,<0.04883,11.14486,1.57548>,<0.05799,11.14244,1.57539>,
            
    /*4*/ <0.24987,11.83085,1.79204>

    /* stem 0.11.8*/ 
    /*0*/ <-0.4391,10.09859,0.98624>,
    /*1*/ <-0.45459,10.09498,0.98619>,<-0.43403,10.11196,0.97928>,<-0.42868,10.08882,0.99325>,
            
    /*2*/ <-0.53533,10.45577,1.61471>,<-0.52162,10.46709,1.61011>,<-0.51805,10.45167,1.61942>,
            
    /*3*/ <-0.69351,10.96393,2.1123>,<-0.68649,10.96907,2.10936>,<-0.68519,10.96292,2.11605>,
            
    /*4*/ <-0.78591,11.5277,2.56634>

    /* stem 0.11.9*/ 
    /*0*/ <-0.47698,10.28642,1.0713>,
    /*1*/ <-0.48162,10.2911,1.05735>,<-0.46637,10.29454,1.07903>,<-0.48293,10.27361,1.07753>,
            
    /*2*/ <-0.99645,10.67648,1.36387>,<-0.98628,10.67878,1.37832>,<-0.99732,10.66483,1.37732>,
            
    /*3*/ <-1.43573,11.14939,1.66508>,<-1.43021,11.15016,1.67203>,<-1.4367,11.14406,1.67215>,
            
    /*4*/ <-1.76814,11.72518,1.92015>

    /* stem 0.11.10*/ 
    /*0*/ <-0.51369,10.49568,1.15377>,
    /*1*/ <-0.50104,10.5004,1.14742>,<-0.51574,10.49734,1.16845>,<-0.52429,10.4893,1.14543>,
            
    /*2*/ <-0.79269,11.12093,1.03904>,<-0.8025,11.11889,1.05306>,<-0.8082,11.11353,1.0377>,
            
    /*3*/ <-1.01573,11.77791,1.03652>,<-1.02042,11.7764,1.04358>,<-1.02387,11.7752,1.03578>,
            
    /*4*/ <-1.18611,12.44881,1.08623>

    /* stem 0.11.11*/ 
    /*0*/ <-0.55123,10.70966,1.23809>,
    /*1*/ <-0.5414,10.70734,1.24835>,<-0.56479,10.7129,1.2417>,<-0.54751,10.70873,1.22421>,
            
    /*2*/ <-0.38789,11.36517,1.24328>,<-0.40348,11.36888,1.23884>,<-0.39196,11.3661,1.22718>,
            
    /*3*/ <-0.3243,12.03391,1.31555>,<-0.33223,12.03496,1.31328>,<-0.32623,12.03501,1.30753>,
            
    /*4*/ <-0.29267,12.70694,1.36767>

    /* stem 0.11.12*/ 
    /*0*/ <-0.58892,10.92448,1.32274>,
    /*1*/ <-0.59643,10.91908,1.3331>,<-0.59481,10.93325,1.31373>,<-0.57552,10.9211,1.32139>,
            
    /*2*/ <-0.42779,11.42692,1.71395>,<-0.42671,11.43637,1.70104>,<-0.41385,11.42827,1.70615>,
            
    /*3*/ <-0.32051,11.94948,2.09643>,<-0.32,11.95418,2.08995>,<-0.31342,11.95067,2.09289>,
            
    /*4*/ <-0.28718,12.51061,2.43625>

    /* stem 0.11.13*/ 
    /*0*/ <-0.62651,11.13869,1.40715>,
    /*1*/ <-0.63889,11.1385,1.40211>,<-0.61733,11.14697,1.40205>,<-0.6233,11.13059,1.41731>,
            
    /*2*/ <-0.81073,11.58983,1.81925>,<-0.79636,11.59547,1.8192>,<-0.80034,11.58455,1.82938>,
            
    /*3*/ <-0.97725,12.05421,2.22403>,<-0.97003,12.05695,2.22394>,<-0.97208,12.05165,2.22917>,
            
    /*4*/ <-1.02919,12.59675,2.55703>

    /* stem 0.11.14*/ 
    /*0*/ <-0.65227,11.28556,1.46503>,
    /*1*/ <-0.65065,11.29054,1.4531>,<-0.64365,11.28822,1.47443>,<-0.66251,11.27792,1.46756>,
            
    /*2*/ <-0.98545,11.79113,1.62158>,<-0.98078,11.78958,1.63579>,<-0.99336,11.78271,1.63122>,
            
    /*3*/ <-1.30308,12.29658,1.80841>,<-1.30063,12.29558,1.81545>,<-1.30705,12.29237,1.81322>,
            
    /*4*/ <-1.47575,12.88669,1.91777>

    /* stem 0.11.15*/ 
    /*0*/ <-0.7005,11.56043,1.57335>,
    /*1*/ <-0.68834,11.56274,1.57292>,<-0.70636,11.56013,1.58425>,<-0.7068,11.55844,1.56288>,
            
    /*2*/ <-0.80549,12.15096,1.52875>,<-0.81751,12.14922,1.5363>,<-0.8178,12.14809,1.52205>,
            
    /*3*/ <-0.91446,12.74045,1.57586>,<-0.92037,12.7391,1.57964>,<-0.92072,12.7396,1.57251>,
            
    /*4*/ <-1.00508,13.33126,1.64117>

    /* stem 0.11.16*/ 
    /*0*/ <-0.72513,11.70082,1.62867>,
    /*1*/ <-0.7213,11.69722,1.63952>,<-0.73595,11.70601,1.62751>,<-0.71814,11.69924,1.61898>,
            
    /*2*/ <-0.47859,12.22714,1.72545>,<-0.48835,12.233,1.71745>,<-0.47648,12.22849,1.71176>,
            
    /*3*/ <-0.39601,12.80979,1.7746>,<-0.40137,12.81095,1.77031>,<-0.39494,12.81026,1.76773>,
            
    /*4*/ <-0.4767,13.38845,1.85216>

    /* stem 0.11.17*/ 
    /*0*/ <-0.76623,11.93509,1.72099>,
    /*1*/ <-0.7759,11.9314,1.72605>,<-0.76655,11.94416,1.7139>,<-0.75626,11.92971,1.72302>,
            
    /*2*/ <-0.67487,12.27976,2.16414>,<-0.66863,12.28827,2.15604>,<-0.66177,12.27863,2.16211>,
            
    /*3*/ <-0.61461,12.70918,2.53263>,<-0.6116,12.71283,2.52795>,<-0.60801,12.7089,2.53194>,
            
    /*4*/ <-0.60173,13.23188,2.75741>

    /* stem 0.11.18*/ 
    /*0*/ <-0.80397,12.15018,1.80575>,
    /*1*/ <-0.81163,12.15189,1.79801>,<-0.79535,12.15701,1.80657>,<-0.80493,12.14165,1.81266>,
            
    /*2*/ <-1.09256,12.46682,2.15072>,<-1.08171,12.47024,2.15643>,<-1.08809,12.46,2.16049>,
            
    /*3*/ <-1.31499,12.87242,2.44795>,<-1.3093,12.87376,2.45046>,<-1.31313,12.86956,2.45332>,
            
    /*4*/ <-1.46419,13.32159,2.72856>

    /* stem 0.11.19*/ 
    /*0*/ <-0.83438,12.35508,1.87404>,
    /*1*/ <-0.82864,12.35807,1.86567>,<-0.83137,12.35788,1.88378>,<-0.84312,12.3493,1.87266>,
            
    /*2*/ <-1.11921,12.8029,1.82974>,<-1.12103,12.80277,1.84181>,<-1.12886,12.79705,1.8344>,
            
    /*3*/ <-1.34879,13.28282,1.81576>,<-1.34961,13.28264,1.82181>,<-1.35392,13.28047,1.81807>,
            
    /*4*/ <-1.54602,13.77575,1.85916>

    /* stem 0.11.20*/ 
    /*0*/ <-0.86006,12.56605,1.93174>,
    /*1*/ <-0.85063,12.5662,1.93538>,<-0.86794,12.56659,1.93806>,<-0.86162,12.56535,1.92176>,
            
    /*2*/ <-0.84784,13.07971,1.89742>,<-0.85938,13.07997,1.89921>,<-0.85517,13.07914,1.88834>,
            
    /*3*/ <-0.94377,13.58282,1.83271>,<-0.94946,13.58189,1.83364>,<-0.9473,13.5816,1.82822>,
            
    /*4*/ <-1.00592,14.08713,1.75039>

    /* stem 0.11.21*/ 
    /*0*/ <-0.88867,12.80094,1.99598>,
    /*1*/ <-0.88985,12.79829,2.00515>,<-0.89513,12.80669,1.99176>,<-0.88103,12.79785,1.99102>,
            
    /*2*/ <-0.63279,13.19613,2.14993>,<-0.63631,13.20173,2.14101>,<-0.6269,13.19584,2.14051>,
            
    /*3*/ <-0.45622,13.62242,2.32878>,<-0.45805,13.6251,2.32428>,<-0.45293,13.62295,2.32434>,
            
    /*4*/ <-0.3267,14.04507,2.55148>

    /* stem 0.11.22*/ 
    /*0*/ <-0.91892,13.04938,2.06393>,
    /*1*/ <-0.92791,13.04812,2.06455>,<-0.91559,13.05569,2.05827>,<-0.91326,13.04434,2.06896>,
            
    /*2*/ <-0.94624,13.37127,2.41159>,<-0.93803,13.37632,2.4074>,<-0.93647,13.36876,2.41453>,
            
    /*3*/ <-1.01418,13.76942,2.65993>,<-1.01004,13.77163,2.65757>,<-1.0094,13.76895,2.66205>,
            
    /*4*/ <-1.05022,14.19587,2.86554>

    /* stem 0.11.23*/ 
    /*0*/ <-0.94647,13.27559,2.1258>,
    /*1*/ <-0.94924,13.27743,2.11783>,<-0.9392,13.27919,2.12877>,<-0.95095,13.27016,2.13078>,
            
    /*2*/ <-1.189,13.62686,2.28529>,<-1.18231,13.62803,2.29258>,<-1.19014,13.62201,2.29393>,
            
    /*3*/ <-1.37654,14.01504,2.43247>,<-1.37306,14.0154,2.43602>,<-1.37732,14.01299,2.43695>,
            
    /*4*/ <-1.5125,14.43088,2.55961>

    /* stem 0.11.24*/ 
    /*0*/ <-0.98903,13.62516,2.2214>,
    /*1*/ <-0.98235,13.62702,2.21757>,<-0.9894,13.62585,2.22928>,<-0.99534,13.62261,2.21735>,
            
    /*2*/ <-1.12042,14.02851,2.17735>,<-1.12512,14.02773,2.18516>,<-1.12908,14.02557,2.17721>,
            
    /*3*/ <-1.21377,14.4438,2.1581>,<-1.21612,14.44348,2.16201>,<-1.21823,14.44282,2.15801>,
            
    /*4*/ <-1.24163,14.8558,2.26477>

    /* stem 0.11.25*/ 
    /*0*/ <-1.01075,13.80349,2.27017>,
    /*1*/ <-1.0062,13.80279,2.27474>,<-1.01663,13.80568,2.27177>,<-1.0094,13.80199,2.26401>,
            
    /*2*/ <-0.88196,14.18927,2.20702>,<-0.88891,14.1912,2.20504>,<-0.88409,14.18874,2.19987>,
            
    /*3*/ <-0.78107,14.58408,2.25958>,<-0.78453,14.58511,2.25861>,<-0.78188,14.58478,2.25599>,
            
    /*4*/ <-0.73142,14.97073,2.3912>

    /* stem 0.11.26*/ 
    /*0*/ <-1.04349,14.07243,2.34373>,
    /*1*/ <-1.0454,14.0714,2.34662>,<-1.04503,14.07448,2.34118>,<-1.04005,14.0714,2.34338>,
            
    /*2*/ <-0.92962,14.39173,2.53474>,<-0.92937,14.39379,2.53112>,<-0.92605,14.39173,2.53258>,
            
    /*3*/ <-0.79022,14.71207,2.70645>,<-0.79013,14.71303,2.7046>,<-0.78849,14.71194,2.7053>,
            
    /*4*/ <-0.65333,15.05834,2.82>

    /* stem 0.11.27*/ 
    /*0*/ <-1.06926,14.284,2.40159>,
    /*1*/ <-1.07054,14.28397,2.40112>,<-1.06834,14.28482,2.40102>,<-1.0689,14.2832,2.40264>,
            
    /*2*/ <-1.16311,14.55398,2.63881>,<-1.16164,14.55455,2.63874>,<-1.16202,14.55347,2.63982>,
            
    /*3*/ <-1.17685,14.88757,2.80186>,<-1.17608,14.88768,2.80171>,<-1.17631,14.88734,2.80238>,
            
    /*4*/ <-1.19717,15.255,2.85206>

    /* stem 0.12*/ 
    /*0*/ <0,8.86753,0>,
    /*1*/ <0.01287,8.86753,-0.06622>,<0.05852,8.89961,-0.00986>,<0.0233,8.88736,0.06013>,
            <-0.04412,8.8477,0.04702>,<-0.05057,8.83545,-0.03107>,
    /*2*/ <-1.07894,10.78643,-0.25554>,<-1.04851,10.80782,-0.21797>,<-1.07199,10.79965,-0.17131>,
            <-1.11694,10.77321,-0.18004>,<-1.12124,10.76505,-0.2321>,
    /*3*/ <-1.94473,12.82098,-0.40092>,<-1.92841,12.82945,-0.38192>,<-1.94057,12.82621,-0.35868>,
            <-1.9644,12.81574,-0.36331>,<-1.96697,12.81251,-0.38942>,
    /*4*/ <-2.57283,14.94365,-0.50011>

    /* stem 0.12.0*/ 
    /*0*/ <-0.12603,9.0899,-0.0245>,
    /*1*/ <-0.1087,9.09959,-0.02569>,<-0.1386,9.09381,-0.0096>,<-0.13077,9.0763,-0.0382>,
            
    /*2*/ <-0.49106,9.71094,-0.50489>,<-0.511,9.70709,-0.49417>,<-0.50578,9.69541,-0.51323>,
            
    /*3*/ <-0.78615,10.48791,-0.73954>,<-0.79602,10.48592,-0.73401>,<-0.79494,10.48299,-0.74506>,
            
    /*4*/ <-1.11788,11.28779,-0.73025>

    /* stem 0.12.1*/ 
    /*0*/ <-0.27248,9.34832,-0.05297>,
    /*1*/ <-0.26863,9.35252,-0.03466>,<-0.29053,9.34476,-0.05839>,<-0.2583,9.34767,-0.06585>,
            
    /*2*/ <-0.38171,10.16923,-0.20503>,<-0.39632,10.16405,-0.22085>,<-0.37483,10.16599,-0.22582>,
            
    /*3*/ <-0.66179,10.95112,-0.34395>,<-0.66879,10.94733,-0.35163>,<-0.65858,10.95047,-0.35452>,
            
    /*4*/ <-1.0945,11.66786,-0.43244>

    /* stem 0.12.2*/ 
    /*0*/ <-0.3797,9.53751,-0.07381>,
    /*1*/ <-0.39427,9.53026,-0.06468>,<-0.38229,9.54612,-0.09016>,<-0.36255,9.53614,-0.06659>,
            
    /*2*/ <-0.49851,10.24841,0.32658>,<-0.49052,10.25899,0.30959>,<-0.47736,10.25234,0.3253>,
            
    /*3*/ <-0.66817,10.99482,0.63287>,<-0.66405,10.99945,0.62407>,<-0.65772,10.99741,0.63254>,
            
    /*4*/ <-1.0232,11.70303,0.85781>

    /* stem 0.12.3*/ 
    /*0*/ <-0.50346,9.75587,-0.09786>,
    /*1*/ <-0.51344,9.74875,-0.11113>,<-0.49229,9.76963,-0.10135>,<-0.50465,9.74922,-0.0811>,
            
    /*2*/ <-1.10041,10.27196,0.05785>,<-1.08631,10.28589,0.06437>,<-1.09455,10.27228,0.07787>,
            
    /*3*/ <-1.64138,10.84126,0.23472>,<-1.63374,10.84766,0.2378>,<-1.63824,10.84124,0.24467>,
            
    /*4*/ <-2.03144,11.53878,0.33004>

    /* stem 0.12.4*/ 
    /*0*/ <-0.59062,9.90966,-0.11481>,
    /*1*/ <-0.58123,9.91339,-0.12928>,<-0.58819,9.91904,-0.10005>,<-0.60244,9.89656,-0.11509>,
            
    /*2*/ <-1.14276,10.42088,-0.35583>,<-1.14741,10.42465,-0.33634>,<-1.15691,10.40966,-0.34637>,
            
    /*3*/ <-1.62682,11.03384,-0.47707>,<-1.62825,11.03478,-0.46702>,<-1.63443,11.02882,-0.47252>,
            
    /*4*/ <-2.10627,11.66244,-0.48993>

    /* stem 0.12.5*/ 
    /*0*/ <-0.70248,10.10703,-0.13655>,
    /*1*/ <-0.68892,10.11541,-0.13029>,<-0.71777,10.10865,-0.12901>,<-0.70075,10.09705,-0.15035>,
            
    /*2*/ <-0.8546,10.71432,-0.58807>,<-0.87384,10.70982,-0.58721>,<-0.86249,10.70208,-0.60144>,
            
    /*3*/ <-0.9753,11.33358,-1.03135>,<-0.98503,11.3318,-1.0313>,<-0.97933,11.32787,-1.03835>,
            
    /*4*/ <-1.11744,12.00357,-1.38654>

    /* stem 0.12.6*/ 
    /*0*/ <-0.78529,10.25314,-0.15264>,
    /*1*/ <-0.78823,10.25329,-0.13617>,<-0.79803,10.25184,-0.16341>,<-0.76959,10.2543,-0.15835>,
            
    /*2*/ <-0.84958,11.00877,-0.1595>,<-0.85611,11.0078,-0.17766>,<-0.83716,11.00944,-0.17429>,
            
    /*3*/ <-0.9966,11.75217,-0.17886>,<-0.99984,11.75136,-0.18793>,<-0.9905,11.75325,-0.18628>,
            
    /*4*/ <-1.22771,12.46169,-0.31807>

    /* stem 0.12.7*/ 
    /*0*/ <-0.92048,10.49169,-0.17892>,
    /*1*/ <-0.93451,10.48388,-0.17768>,<-0.91614,10.49826,-0.19297>,<-0.91079,10.49293,-0.16612>,
            
    /*2*/ <-1.26286,11.11475,0.01285>,<-1.25061,11.12434,0.00266>,<-1.24705,11.12079,0.02056>,
            
    /*3*/ <-1.62933,11.73891,0.14536>,<-1.62321,11.74367,0.14023>,<-1.62177,11.74257,0.14935>,
            
    /*4*/ <-1.99709,12.37653,0.12288>

    /* stem 0.12.8*/ 
    /*0*/ <-1.02236,10.67146,-0.19873>,
    /*1*/ <-1.02574,10.66791,-0.21358>,<-1.01461,10.68462,-0.1954>,<-1.02674,10.66184,-0.1872>,
            
    /*2*/ <-1.64892,11.02243,-0.15113>,<-1.6415,11.03358,-0.13902>,<-1.64959,11.01839,-0.13355>,
            
    /*3*/ <-2.20348,11.47949,-0.10717>,<-2.19895,11.4845,-0.10117>,<-2.20427,11.47777,-0.09834>,
            
    /*4*/ <-2.62061,12.06027,-0.18496>

    /* stem 0.12.9*/ 
    /*0*/ <-1.13172,10.89081,-0.21998>,
    /*1*/ <-1.11946,10.89538,-0.22748>,<-1.13658,10.89858,-0.20801>,<-1.13912,10.87845,-0.22447>,
            
    /*2*/ <-1.52522,11.28638,-0.64272>,<-1.53664,11.28851,-0.62974>,<-1.53834,11.27509,-0.64071>,
            
    /*3*/ <-1.93844,11.72016,-1.00525>,<-1.94379,11.72086,-0.99842>,<-1.94511,11.71464,-1.00436>,
            
    /*4*/ <-2.25351,12.28536,-1.27081>

    /* stem 0.12.10*/ 
    /*0*/ <-1.25167,11.17409,-0.2433>,
    /*1*/ <-1.24296,11.17864,-0.23278>,<-1.26592,11.17564,-0.24202>,<-1.24613,11.16798,-0.2551>,
            
    /*2*/ <-1.20624,11.78317,-0.53146>,<-1.22155,11.78117,-0.53762>,<-1.20835,11.77606,-0.54634>,
            
    /*3*/ <-1.15905,12.4072,-0.7834>,<-1.16669,12.40654,-0.78661>,<-1.16009,12.40423,-0.79109>,
            
    /*4*/ <-1.13608,13.02744,-1.04993>

    /* stem 0.12.11*/ 
    /*0*/ <-1.32353,11.34381,-0.25727>,
    /*1*/ <-1.3311,11.34155,-0.24572>,<-1.32993,11.34586,-0.26953>,<-1.30957,11.34401,-0.25655>,
            
    /*2*/ <-1.34395,11.9922,-0.13281>,<-1.34317,11.99507,-0.14869>,<-1.32959,11.99384,-0.14003>,
            
    /*3*/ <-1.3329,12.65073,-0.07314>,<-1.33247,12.6515,-0.08117>,<-1.3257,12.65099,-0.07679>,
            
    /*4*/ <-1.41657,13.29497,0.04211>

    /* stem 0.12.12*/ 
    /*0*/ <-1.39972,11.52374,-0.27208>,
    /*1*/ <-1.41122,11.51846,-0.27695>,<-1.39294,11.53302,-0.27927>,<-1.395,11.51972,-0.26002>,
            
    /*2*/ <-1.74403,11.9889,0.0124>,<-1.73184,11.9986,0.01085>,<-1.73322,11.98974,0.02368>,
            
    /*3*/ <-1.93447,12.57324,0.21363>,<-1.92738,12.57614,0.21203>,<-1.9289,12.57321,0.21913>,
            
    /*4*/ <-2.08522,13.16959,0.40796>

    /* stem 0.12.13*/ 
    /*0*/ <-1.53915,11.85301,-0.29918>,
    /*1*/ <-1.53711,11.85284,-0.31179>,<-1.53345,11.86184,-0.29191>,<-1.54688,11.84436,-0.29383>,
            
    /*2*/ <-2.01749,12.2306,-0.39026>,<-2.01504,12.2366,-0.377>,<-2.024,12.22495,-0.37829>,
            
    /*3*/ <-2.37281,12.72409,-0.48626>,<-2.37116,12.72664,-0.47954>,<-2.37701,12.72225,-0.48048>,
            
    /*4*/ <-2.68288,13.25099,-0.56342>

    /* stem 0.12.14*/ 
    /*0*/ <-1.60588,12.01061,-0.31215>,
    /*1*/ <-1.59446,12.01535,-0.3132>,<-1.61333,12.01435,-0.30296>,<-1.60984,12.00212,-0.32029>,
            
    /*2*/ <-1.81314,12.45228,-0.66557>,<-1.82572,12.45161,-0.65874>,<-1.82339,12.44345,-0.6703>,
            
    /*3*/ <-2.10862,12.89491,-0.94998>,<-2.11441,12.89369,-0.94595>,<-2.11359,12.89024,-0.95217>,
            
    /*4*/ <-2.39756,13.37638,-1.16785>

    /* stem 0.12.15*/ 
    /*0*/ <-1.71451,12.26716,-0.33327>,
    /*1*/ <-1.7115,12.26935,-0.32206>,<-1.72554,12.26925,-0.33694>,<-1.70649,12.26286,-0.3408>,
            
    /*2*/ <-1.56097,12.80899,-0.47234>,<-1.57033,12.80893,-0.48227>,<-1.55763,12.80467,-0.48484>,
            
    /*3*/ <-1.37245,13.33142,-0.6401>,<-1.37707,13.33152,-0.64511>,<-1.37087,13.32892,-0.64624>,
            
    /*4*/ <-1.19408,13.853,-0.82095>

    /* stem 0.12.16*/ 
    /*0*/ <-1.78791,12.44051,-0.34754>,
    /*1*/ <-1.79711,12.43709,-0.34169>,<-1.78914,12.44522,-0.35786>,<-1.7775,12.43921,-0.34305>,
            
    /*2*/ <-1.83267,12.94926,-0.10594>,<-1.82736,12.95468,-0.11672>,<-1.8196,12.95067,-0.10685>,
            
    /*3*/ <-1.96734,13.47289,0.05609>,<-1.96466,13.47532,0.05059>,<-1.96098,13.47459,0.05601>,
            
    /*4*/ <-2.12768,14.00521,0.15701>

    /* stem 0.12.17*/ 
    /*0*/ <-1.92183,12.75677,-0.37357>,
    /*1*/ <-1.92843,12.75335,-0.38125>,<-1.91398,12.76364,-0.37593>,<-1.92308,12.75333,-0.36352>,
            
    /*2*/ <-2.25657,13.16638,-0.27872>,<-2.24694,13.17324,-0.27517>,<-2.25301,13.16637,-0.26689>,
            
    /*3*/ <-2.51747,13.63178,-0.33625>,<-2.51242,13.63487,-0.33449>,<-2.51656,13.63306,-0.33028>,
            
    /*4*/ <-2.70961,14.10845,-0.4926>

    /* stem 0.12.18*/ 
    /*0*/ <-1.97255,12.90105,-0.38342>,
    /*1*/ <-1.96691,12.90221,-0.39206>,<-1.96968,12.90583,-0.37467>,<-1.98106,12.8951,-0.38354>,
            
    /*2*/ <-2.2585,13.31912,-0.52205>,<-2.26034,13.32153,-0.51046>,<-2.26793,13.31438,-0.51637>,
            
    /*3*/ <-2.50113,13.76966,-0.63875>,<-2.50197,13.77075,-0.63292>,<-2.5061,13.76772,-0.63603>,
            
    /*4*/ <-2.75009,14.23259,-0.64792>

    /* stem 0.12.19*/ 
    /*0*/ <-2.06888,13.22884,-0.40215>,
    /*1*/ <-2.06023,13.23158,-0.39876>,<-2.07697,13.23182,-0.39775>,<-2.06943,13.22313,-0.40995>,
            
    /*2*/ <-2.07502,13.63247,-0.69338>,<-2.08617,13.63263,-0.69271>,<-2.08115,13.62684,-0.70084>,
            
    /*3*/ <-2.03372,14.05728,-0.94765>,<-2.03928,14.05787,-0.94762>,<-2.03678,14.05513,-0.9518>,
            
    /*4*/ <-1.97156,14.52808,-1.09518>

    /* stem 0.12.20*/ 
    /*0*/ <-2.11363,13.38113,-0.41085>,
    /*1*/ <-2.11496,13.38127,-0.40158>,<-2.1209,13.38233,-0.41663>,<-2.10505,13.37978,-0.41433>,
            
    /*2*/ <-2.03799,13.86014,-0.40101>,<-2.04195,13.86085,-0.41104>,<-2.03138,13.85915,-0.40951>,
            
    /*3*/ <-1.91607,14.32968,-0.41286>,<-1.91802,14.33009,-0.41788>,<-1.91284,14.32877,-0.4171>,
            
    /*4*/ <-1.92481,14.81416,-0.39988>

    /* stem 0.12.21*/ 
    /*0*/ <-2.20012,13.6754,-0.42766>,
    /*1*/ <-2.20849,13.67299,-0.42683>,<-2.19741,13.67938,-0.43497>,<-2.19445,13.67384,-0.42118>,
            
    /*2*/ <-2.3052,14.08304,-0.24107>,<-2.29782,14.08731,-0.24649>,<-2.29584,14.08361,-0.2373>,
            
    /*3*/ <-2.31102,14.52086,-0.09466>,<-2.30717,14.52197,-0.09773>,<-2.30627,14.5204,-0.09301>,
            
    /*4*/ <-2.32402,14.97032,0.00447>

    /* stem 0.12.22*/ 
    /*0*/ <-2.26259,13.888,-0.4398>,
    /*1*/ <-2.265,13.88684,-0.44768>,<-2.25745,13.89424,-0.4379>,<-2.26534,13.88291,-0.43383>,
            
    /*2*/ <-2.6117,14.15315,-0.37805>,<-2.60667,14.15808,-0.37153>,<-2.61193,14.15052,-0.36882>,
            
    /*3*/ <-2.88714,14.4864,-0.27966>,<-2.88392,14.48818,-0.27658>,<-2.8872,14.48502,-0.27506>,
            
    /*4*/ <-3.09426,14.87092,-0.20729>

    /* stem 0.12.23*/ 
    /*0*/ <-2.31383,14.06234,-0.44976>,
    /*1*/ <-2.30725,14.06403,-0.45391>,<-2.31521,14.06599,-0.44283>,<-2.31902,14.05699,-0.45255>,
            
    /*2*/ <-2.51947,14.37452,-0.65848>,<-2.52479,14.37583,-0.65109>,<-2.52732,14.36982,-0.65757>,
            
    /*3*/ <-2.70456,14.71846,-0.83338>,<-2.70715,14.71901,-0.82963>,<-2.70867,14.71642,-0.83311>,
            
    /*4*/ <-2.84657,15.09994,-0.96562>

    /* stem 0.12.24*/ 
    /*0*/ <-2.4144,14.40456,-0.46931>,
    /*1*/ <-2.41063,14.40591,-0.46524>,<-2.41989,14.406,-0.4687>,<-2.41268,14.40178,-0.474>,
            
    /*2*/ <-2.3407,14.75444,-0.64763>,<-2.34687,14.75451,-0.64994>,<-2.34207,14.7517,-0.65347>,
            
    /*3*/ <-2.31323,15.14221,-0.73797>,<-2.31633,15.14219,-0.73908>,<-2.31384,15.14153,-0.74114>,
            
    /*4*/ <-2.36164,15.53872,-0.73932>

    /* stem 0.12.25*/ 
    /*0*/ <-2.47875,14.62351,-0.48182>,
    /*1*/ <-2.48054,14.62315,-0.47896>,<-2.48023,14.62472,-0.48462>,<-2.47546,14.62267,-0.48188>,
            
    /*2*/ <-2.38669,14.97804,-0.376>,<-2.38649,14.97909,-0.37977>,<-2.38331,14.97772,-0.37794>,
            
    /*3*/ <-2.32071,15.32981,-0.24528>,<-2.32059,15.33047,-0.24711>,<-2.31898,15.32983,-0.2462>,
            
    /*4*/ <-2.29536,15.70066,-0.16026>

    /* stem 0.12.26*/ 
    /*0*/ <-2.53255,14.80661,-0.49228>,
    /*1*/ <-2.53386,14.8062,-0.49276>,<-2.53179,14.8076,-0.49301>,<-2.53201,14.80602,-0.49106>,
            
    /*2*/ <-2.69031,15.07188,-0.29562>,<-2.68893,15.07282,-0.29578>,<-2.68908,15.07177,-0.29449>,
            
    /*3*/ <-2.86564,15.36414,-0.16253>,<-2.86495,15.3646,-0.16262>,<-2.86509,15.36419,-0.1619>,
            
    /*4*/ <-2.98802,15.69729,-0.07304>

    /* stem 0.13*/ 
    /*0*/ <0,9.57592,0>,
    /*1*/ <0.06556,9.57592,-0.00229>,<0.02214,9.60711,0.05329>,<-0.05187,9.5952,0.03522>,
            <-0.0542,9.55664,-0.03152>,<0.01837,9.54472,-0.0547>,
    /*2*/ <0.00587,11.4539,-1.08512>,<-0.02308,11.4747,-1.04807>,<-0.07242,11.46676,-1.06011>,
            <-0.07398,11.44105,-1.10461>,<-0.02559,11.43311,-1.12006>,
    /*3*/ <-0.04596,13.44507,-1.94274>,<-0.0604,13.4533,-1.92313>,<-0.08508,13.45016,-1.92956>,
            <-0.08591,13.43998,-1.95315>,<-0.06173,13.43683,-1.9613>,
    /*4*/ <-0.08952,15.52248,-2.56353>

    /* stem 0.13.0*/ 
    /*0*/ <-0.00496,9.82205,-0.14202>,
    /*1*/ <-0.00006,9.83143,-0.12593>,<-0.02171,9.8259,-0.15069>,<0.0069,9.80881,-0.14943>,
            
    /*2*/ <0.37552,10.42557,-0.59438>,<0.36109,10.42188,-0.61088>,<0.38016,10.41049,-0.61004>,
            
    /*3*/ <0.62646,11.07527,-1.07265>,<0.61885,11.07266,-1.08032>,<0.62905,11.06829,-1.08091>,
            
    /*4*/ <0.82887,11.74024,-1.55268>

    /* stem 0.13.1*/ 
    /*0*/ <-0.00872,10.00873,-0.24973>,
    /*1*/ <-0.02531,10.01283,-0.24203>,<-0.00703,10.00773,-0.26837>,<0.00618,10.00562,-0.23879>,
            
    /*2*/ <0.16755,10.81698,-0.27081>,<0.17974,10.81357,-0.28837>,<0.18855,10.81216,-0.26865>,
            
    /*3*/ <0.40214,11.59692,-0.42467>,<0.40787,11.59358,-0.43323>,<0.41252,11.5941,-0.42347>,
            
    /*4*/ <0.62231,12.3724,-0.61132>

    /* stem 0.13.2*/ 
    /*0*/ <-0.01243,10.19265,-0.35585>,
    /*1*/ <-0.02433,10.18556,-0.36773>,<0.00354,10.19921,-0.36176>,<-0.01649,10.19317,-0.33807>,
            
    /*2*/ <-0.35721,10.91842,-0.46226>,<-0.33863,10.92753,-0.45829>,<-0.35198,10.9235,-0.44249>,
            
    /*3*/ <-0.48934,11.69097,-0.6727>,<-0.4794,11.69342,-0.67021>,<-0.48698,11.69411,-0.66292>,
            
    /*4*/ <-0.53918,12.47009,-0.89169>

    /* stem 0.13.3*/ 
    /*0*/ <-0.01719,10.42885,-0.49214>,
    /*1*/ <-0.00677,10.42191,-0.50453>,<-0.01256,10.44384,-0.48413>,<-0.03223,10.4208,-0.48776>,
            
    /*2*/ <-0.39224,10.83736,-1.05294>,<-0.3961,10.85198,-1.03934>,<-0.40921,10.83662,-1.04176>,
            
    /*3*/ <-0.79708,11.35256,-1.49517>,<-0.79805,11.35876,-1.48717>,<-0.8051,11.35166,-1.48899>,
            
    /*4*/ <-1.1061,12.00719,-1.80988>

    /* stem 0.13.4*/ 
    /*0*/ <-0.0201,10.57347,-0.57559>,
    /*1*/ <-0.00428,10.57711,-0.56983>,<-0.03282,10.58493,-0.57365>,<-0.0232,10.55838,-0.58328>,
            
    /*2*/ <0.16804,10.8894,-1.25819>,<0.14902,10.89461,-1.26073>,<0.15542,10.87691,-1.26716>,
            
    /*3*/ <0.34531,11.38115,-1.82909>,<0.33572,11.38357,-1.83007>,<0.33951,11.37606,-1.83536>,
            
    /*4*/ <0.56787,11.9768,-2.27119>

    /* stem 0.13.5*/ 
    /*0*/ <-0.02471,10.80216,-0.70754>,
    /*1*/ <-0.02767,10.81029,-0.69335>,<-0.03561,10.80305,-0.72006>,<-0.01085,10.79315,-0.70922>,
            
    /*2*/ <0.33367,11.41207,-0.96911>,<0.32838,11.40724,-0.98691>,<0.34489,11.40064,-0.97969>,
            
    /*3*/ <0.66359,11.996,-1.31599>,<0.66052,11.99277,-1.32448>,<0.66905,11.98998,-1.32108>,
            
    /*4*/ <0.9634,12.6288,-1.59428>

    /* stem 0.13.6*/ 
    /*0*/ <-0.02812,10.97135,-0.80516>,
    /*1*/ <-0.04427,10.97149,-0.80435>,<-0.02075,10.969,-0.81937>,<-0.01933,10.97356,-0.79177>,
            
    /*2*/ <-0.03855,11.70006,-0.92502>,<-0.02287,11.6984,-0.93503>,<-0.02192,11.70144,-0.91663>,
            
    /*3*/ <0.01268,12.40017,-1.15684>,<0.0205,12.39812,-1.1615>,<0.02097,12.40102,-1.15264>,
            
    /*4*/ <0.09718,13.05949,-1.47931>

    /* stem 0.13.7*/ 
    /*0*/ <-0.03285,11.20644,-0.94081>,
    /*1*/ <-0.03707,11.19889,-0.95374>,<-0.01956,11.21451,-0.9405>,<-0.04193,11.20591,-0.92818>,
            
    /*2*/ <-0.38492,11.78489,-1.17604>,<-0.37325,11.7953,-1.16721>,<-0.38816,11.78956,-1.159>,
            
    /*3*/ <-0.59795,12.44141,-1.37423>,<-0.59145,12.44509,-1.36923>,<-0.59954,12.44354,-1.36566>,
            
    /*4*/ <-0.74054,13.10639,-1.60069>

    /* stem 0.13.8*/ 
    /*0*/ <-0.0368,11.40207,-1.05369>,
    /*1*/ <-0.0236,11.39866,-1.06007>,<-0.03815,11.41459,-1.04545>,<-0.04863,11.39297,-1.05555>,
            
    /*2*/ <-0.21235,11.75623,-1.62993>,<-0.22205,11.76685,-1.62019>,<-0.22904,11.75244,-1.62692>,
            
    /*3*/ <-0.25715,12.30723,-2.05675>,<-0.26178,12.31154,-2.0508>,<-0.26581,12.30662,-2.05672>,
            
    /*4*/ <-0.20831,12.94053,-2.34775>

    /* stem 0.13.9*/ 
    /*0*/ <-0.03939,11.5566,-1.12787>,
    /*1*/ <-0.02961,11.56105,-1.11789>,<-0.05216,11.56367,-1.12927>,<-0.03639,11.54508,-1.13644>,
            
    /*2*/ <0.24949,11.9778,-1.5844>,<0.23446,11.97955,-1.59199>,<0.24497,11.96716,-1.59677>,
            
    /*3*/ <0.45554,12.50589,-1.9679>,<0.44784,12.50644,-1.97138>,<0.45375,12.50154,-1.97494>,
            
    /*4*/ <0.59061,13.09317,-2.29342>

    /* stem 0.13.10*/ 
    /*0*/ <-0.04318,11.80862,-1.23651>,
    /*1*/ <-0.05127,11.81306,-1.22591>,<-0.04766,11.80986,-1.24978>,<-0.03061,11.80292,-1.23384>,
            
    /*2*/ <0.23115,12.4115,-1.26749>,<0.23357,12.40936,-1.2834>,<0.24493,12.40474,-1.27278>,
            
    /*3*/ <0.35537,13.04074,-1.43521>,<0.35619,13.03856,-1.44298>,<0.36265,13.03859,-1.43807>,
            
    /*4*/ <0.41537,13.66756,-1.6427>

    /* stem 0.13.11*/ 
    /*0*/ <-0.04678,12.04803,-1.33972>,
    /*1*/ <-0.05927,12.04585,-1.34432>,<-0.03648,12.04899,-1.34837>,<-0.0446,12.04923,-1.32647>,
            
    /*2*/ <-0.14988,12.68032,-1.38477>,<-0.13469,12.68241,-1.38746>,<-0.1401,12.68257,-1.37287>,
            
    /*3*/ <-0.20026,13.30209,-1.53705>,<-0.19259,13.30246,-1.5383>,<-0.19546,13.30396,-1.53122>,
            
    /*4*/ <-0.13063,13.91362,-1.7227>

    /* stem 0.13.12*/ 
    /*0*/ <-0.04991,12.25573,-1.42926>,
    /*1*/ <-0.04784,12.25068,-1.44105>,<-0.04143,12.2642,-1.42424>,<-0.06046,12.25231,-1.42248>,
            
    /*2*/ <-0.36682,12.72329,-1.69474>,<-0.36255,12.73231,-1.68354>,<-0.37523,12.72438,-1.68237>,
            
    /*3*/ <-0.57743,13.23175,-1.98785>,<-0.57518,13.23604,-1.98213>,<-0.5821,13.23315,-1.98215>,
            
    /*4*/ <-0.76729,13.78576,-2.20515>

    /* stem 0.13.13*/ 
    /*0*/ <-0.05217,12.40557,-1.49385>,
    /*1*/ <-0.03956,12.4054,-1.4947>,<-0.05787,12.41372,-1.48605>,<-0.05908,12.3976,-1.50081>,
            
    /*2*/ <-0.06817,12.81867,-1.94385>,<-0.08038,12.82422,-1.93808>,<-0.08119,12.81347,-1.94792>,
            
    /*3*/ <-0.0276,13.33754,-2.26241>,<-0.0337,13.34001,-2.25926>,<-0.03409,13.33622,-2.26548>,
            
    /*4*/ <-0.02407,13.93018,-2.41241>

    /* stem 0.13.14*/ 
    /*0*/ <-0.05559,12.63274,-1.59179>,
    /*1*/ <-0.05208,12.63737,-1.58116>,<-0.06626,12.63591,-1.59654>,<-0.04842,12.62494,-1.59765>,
            
    /*2*/ <0.20588,13.08627,-1.86666>,<0.19642,13.08529,-1.87691>,<0.20832,13.07798,-1.87765>,
            
    /*3*/ <0.42409,13.57434,-2.11801>,<0.41936,13.57387,-2.12313>,<0.42558,13.57074,-2.12381>,
            
    /*4*/ <0.53993,14.10155,-2.35932>

    /* stem 0.13.15*/ 
    /*0*/ <-0.05905,12.86293,-1.69102>,
    /*1*/ <-0.06909,12.86508,-1.68567>,<-0.05861,12.86255,-1.70258>,<-0.04945,12.86115,-1.6848>,
            
    /*2*/ <0.04686,13.42414,-1.70136>,<0.05385,13.42246,-1.71263>,<0.05996,13.42152,-1.70078>,
            
    /*3*/ <0.08362,13.98195,-1.8171>,<0.08703,13.98061,-1.82269>,<0.09029,13.98158,-1.81694>,
            
    /*4*/ <0.14604,14.52848,-1.97195>

    /* stem 0.13.16*/ 
    /*0*/ <-0.06329,13.14445,-1.81238>,
    /*1*/ <-0.07073,13.14118,-1.81971>,<-0.05327,13.14733,-1.81568>,<-0.06588,13.14484,-1.80176>,
            
    /*2*/ <-0.23632,13.65895,-1.87727>,<-0.22468,13.66305,-1.87458>,<-0.23309,13.66139,-1.86531>,
            
    /*3*/ <-0.33474,14.16769,-2.04996>,<-0.32882,14.16936,-2.04855>,<-0.33338,14.16994,-2.04422>,
            
    /*4*/ <-0.40243,14.65403,-2.28972>

    /* stem 0.13.17*/ 
    /*0*/ <-0.06625,13.34083,-1.89704>,
    /*1*/ <-0.06035,13.33747,-1.90505>,<-0.06237,13.34783,-1.89025>,<-0.07602,13.3372,-1.89583>,
            
    /*2*/ <-0.24641,13.73325,-2.20363>,<-0.24775,13.74015,-2.19376>,<-0.25685,13.73307,-2.19749>,
            
    /*3*/ <-0.34208,14.15757,-2.50462>,<-0.34273,14.16099,-2.49966>,<-0.34754,14.1582,-2.50207>,
            
    /*4*/ <-0.43758,14.62448,-2.73644>

    /* stem 0.13.18*/ 
    /*0*/ <-0.0691,13.56814,-1.9788>,
    /*1*/ <-0.05977,13.56926,-1.97538>,<-0.07632,13.57436,-1.97577>,<-0.07121,13.5608,-1.98525>,
            
    /*2*/ <0.04249,13.88079,-2.36624>,<0.03146,13.88419,-2.3665>,<0.03487,13.87515,-2.37282>,
            
    /*3*/ <0.12463,14.26237,-2.69455>,<0.11903,14.26378,-2.69437>,<0.12093,14.25999,-2.69829>,
            
    /*4*/ <0.13993,14.71941,-2.92101>

    /* stem 0.13.19*/ 
    /*0*/ <-0.07111,13.76075,-2.03643>,
    /*1*/ <-0.07246,13.76345,-2.02733>,<-0.07718,13.76368,-2.04325>,<-0.0637,13.7551,-2.0387>,
            
    /*2*/ <0.2083,14.162,-2.10772>,<0.20515,14.16215,-2.11833>,<0.21414,14.15643,-2.1153>,
            
    /*3*/ <0.44553,14.56111,-2.27973>,<0.44338,14.56025,-2.28477>,<0.44823,14.55796,-2.2834>,
            
    /*4*/ <0.61803,15.00479,-2.41063>

    /* stem 0.13.20*/ 
    /*0*/ <-0.07431,14.06631,-2.12785>,
    /*1*/ <-0.08322,14.06644,-2.12709>,<-0.07042,14.06902,-2.13545>,<-0.06927,14.06346,-2.12102>,
            
    /*2*/ <-0.05945,14.50382,-1.96066>,<-0.05091,14.50553,-1.96623>,<-0.05015,14.50183,-1.95661>,
            
    /*3*/ <-0.07618,14.94697,-1.81088>,<-0.07192,14.94807,-1.81359>,<-0.07152,14.94644,-1.80871>,
            
    /*4*/ <-0.09896,15.39085,-1.66264>

    /* stem 0.13.21*/ 
    /*0*/ <-0.07575,14.20481,-2.16929>,
    /*1*/ <-0.07842,14.20242,-2.17718>,<-0.06808,14.20871,-2.1683>,<-0.08076,14.20329,-2.16238>,
            
    /*2*/ <-0.27778,14.61023,-2.23013>,<-0.27088,14.61442,-2.22421>,<-0.27934,14.61081,-2.22026>,
            
    /*3*/ <-0.41734,15.04301,-2.27919>,<-0.41368,15.04457,-2.27614>,<-0.41815,15.04334,-2.27426>,
            
    /*4*/ <-0.51199,15.48495,-2.34689>

    /* stem 0.13.22*/ 
    /*0*/ <-0.07925,14.53977,-2.26951>,
    /*1*/ <-0.07241,14.53866,-2.27346>,<-0.07948,14.54468,-2.26322>,<-0.08587,14.53596,-2.27184>,
            
    /*2*/ <-0.17137,14.86653,-2.53186>,<-0.17609,14.87055,-2.52504>,<-0.18035,14.86473,-2.53079>,
            
    /*3*/ <-0.23219,15.2285,-2.75378>,<-0.2345,15.23031,-2.75023>,<-0.23675,15.22794,-2.75348>,
            
    /*4*/ <-0.22851,15.58865,-2.98622>

    /* stem 0.13.23*/ 
    /*0*/ <-0.08076,14.6843,-2.31275>,
    /*1*/ <-0.07543,14.68594,-2.30746>,<-0.0874,14.68818,-2.31285>,<-0.07946,14.67877,-2.31794>,
            
    /*2*/ <0.09155,14.96681,-2.56647>,<0.08357,14.96831,-2.57007>,<0.08886,14.96204,-2.57346>,
            
    /*3*/ <0.14759,15.32178,-2.77863>,<0.14332,15.32175,-2.77986>,<0.14637,15.31975,-2.78239>,
            
    /*4*/ <0.19632,15.7012,-2.94405>

    /* stem 0.13.24*/ 
    /*0*/ <-0.08318,14.91548,-2.38192>,
    /*1*/ <-0.08667,14.91698,-2.37678>,<-0.08573,14.91593,-2.38776>,<-0.07713,14.91353,-2.38122>,
            
    /*2*/ <0.03903,15.29326,-2.40404>,<0.03965,15.29256,-2.41135>,<0.04539,15.29096,-2.407>,
            
    /*3*/ <0.12177,15.68047,-2.4384>,<0.12207,15.6801,-2.44205>,<0.12503,15.67966,-2.43991>,
            
    /*4*/ <0.16714,16.07515,-2.44967>

    /* stem 0.13.25*/ 
    /*0*/ <-0.08608,15.19305,-2.46497>,
    /*1*/ <-0.08934,15.19268,-2.4661>,<-0.08363,15.19427,-2.4671>,<-0.08527,15.1922,-2.46171>,
            
    /*2*/ <-0.16664,15.54185,-2.35504>,<-0.16283,15.54291,-2.3557>,<-0.16393,15.54153,-2.35211>,
            
    /*3*/ <-0.15376,15.91155,-2.29411>,<-0.1518,15.91156,-2.29455>,<-0.15241,15.91127,-2.29266>,
            
    /*4*/ <-0.14118,16.28524,-2.27423>

    /* stem 0.13.26*/ 
    /*0*/ <-0.08871,15.4447,-2.54026>,
    /*1*/ <-0.08861,15.44447,-2.54104>,<-0.08811,15.4451,-2.53987>,<-0.08941,15.44453,-2.53987>,
            
    /*2*/ <-0.22452,15.75203,-2.64998>,<-0.22419,15.75245,-2.6492>,<-0.22505,15.75207,-2.6492>,
            
    /*3*/ <-0.34233,16.07245,-2.74162>,<-0.34215,16.07263,-2.74122>,<-0.3426,16.07247,-2.74123>,
            
    /*4*/ <-0.41063,16.41019,-2.82041>

    /* stem 0.14*/ 
    /*0*/ <0,10.1626,0>,
    /*1*/ <0.01655,10.1626,0.06176>,<-0.04576,10.19301,0.03272>,<-0.04483,10.18139,-0.04154>,
            <0.01805,10.14381,-0.05839>,<0.05599,10.13219,0.00546>,
    /*2*/ <1.03796,12.00403,-0.23399>,<0.99642,12.0243,-0.25335>,<0.99704,12.01656,-0.30286>,
            <1.03896,11.9915,-0.31409>,<1.06425,11.98376,-0.27153>,
    /*3*/ <1.84593,13.95643,-0.47255>,<1.82414,13.96446,-0.48196>,<1.82484,13.96139,-0.50682>,
            <1.84706,13.95147,-0.51277>,<1.86009,13.9484,-0.49159>,
    /*4*/ <2.42946,15.9934,-0.65097>

    /* stem 0.14.0*/ 
    /*0*/ <0.11078,10.36124,-0.02968>,
    /*1*/ <0.09648,10.37044,-0.02145>,<0.11533,10.36498,-0.04763>,<0.12052,10.3483,-0.01997>,
            
    /*2*/ <0.62887,10.95747,0.23253>,<0.64144,10.95382,0.21508>,<0.6449,10.94271,0.23352>,
            
    /*3*/ <1.03363,11.62525,0.51369>,<1.0407,11.62454,0.50542>,<1.04274,11.61936,0.51479>,
            
    /*4*/ <1.38723,12.35456,0.70144>

    /* stem 0.14.1*/ 
    /*0*/ <0.23246,10.57943,-0.06229>,
    /*1*/ <0.22149,10.58344,-0.07637>,<0.2502,10.57602,-0.06518>,<0.22568,10.57883,-0.0453>,
            
    /*2*/ <0.39216,11.37111,0.02294>,<0.41129,11.36616,0.0304>,<0.39495,11.36803,0.04365>,
            
    /*3*/ <0.59481,12.15632,0.05427>,<0.60437,12.15377,0.05797>,<0.59642,12.15556,0.06468>,
            
    /*4*/ <0.68198,12.96249,0.03236>

    /* stem 0.14.2*/ 
    /*0*/ <0.36049,10.80901,-0.09659>,
    /*1*/ <0.3691,10.80214,-0.11042>,<0.36955,10.81614,-0.08319>,<0.34282,10.80875,-0.09617>,
            
    /*2*/ <0.34709,11.50762,-0.46711>,<0.34739,11.51695,-0.44896>,<0.32957,11.51202,-0.45761>,
            
    /*3*/ <0.38579,12.25277,-0.73174>,<0.38588,12.25624,-0.72214>,<0.37701,12.25496,-0.72703>,
            
    /*4*/ <0.48689,12.96093,-1.06718>

    /* stem 0.14.3*/ 
    /*0*/ <0.47496,11.01427,-0.12726>,
    /*1*/ <0.48898,11.00752,-0.1201>,<0.46613,11.02642,-0.11902>,<0.46977,11.00888,-0.14267>,
            
    /*2*/ <0.9175,11.55292,-0.45876>,<0.90227,11.56552,-0.45804>,<0.90469,11.55382,-0.4738>,
            
    /*3*/ <1.29397,12.17943,-0.70854>,<1.2857,12.1848,-0.70774>,<1.28778,12.18016,-0.71623>,
            
    /*4*/ <1.58494,12.89007,-0.78909>

    /* stem 0.14.4*/ 
    /*0*/ <0.55529,11.15832,-0.14879>,
    /*1*/ <0.5533,11.16186,-0.13255>,<0.55036,11.16931,-0.16042>,<0.56222,11.1438,-0.15341>,
            
    /*2*/ <1.24025,11.48348,-0.12412>,<1.23829,11.48844,-0.1427>,<1.2462,11.47143,-0.13802>,
            
    /*3*/ <1.78661,12.00853,-0.14903>,<1.78456,12.01031,-0.1583>,<1.79112,12.00359,-0.15601>,
            
    /*4*/ <2.24732,12.5958,-0.28772>

    /* stem 0.14.5*/ 
    /*0*/ <0.64138,11.31269,-0.17186>,
    /*1*/ <0.62713,11.32068,-0.17156>,<0.65161,11.31471,-0.18443>,<0.64539,11.30268,-0.15959>,
            
    /*2*/ <0.95732,11.88489,0.18428>,<0.97364,11.88091,0.1757>,<0.96949,11.87289,0.19226>,
            
    /*3*/ <1.28407,12.50204,0.44071>,<1.29205,12.49975,0.43624>,<1.2906,12.49683,0.44509>,
            
    /*4*/ <1.70936,13.09372,0.596>

    /* stem 0.14.6*/ 
    /*0*/ <0.77672,11.55537,-0.20812>,
    /*1*/ <0.77242,11.55551,-0.22322>,<0.79175,11.55764,-0.20421>,<0.76597,11.55296,-0.19693>,
            
    /*2*/ <0.65605,12.26652,-0.17825>,<0.66893,12.26795,-0.16558>,<0.65175,12.26483,-0.16073>,
            
    /*3*/ <0.59119,12.98392,-0.20987>,<0.59764,12.98484,-0.20356>,<0.58894,12.98416,-0.20109>,
            
    /*4*/ <0.73622,13.67853,-0.34089>

    /* stem 0.14.7*/ 
    /*0*/ <0.89367,11.76508,-0.23946>,
    /*1*/ <0.90502,11.75773,-0.24629>,<0.89649,11.77388,-0.22744>,<0.8795,11.76364,-0.24464>,
            
    /*2*/ <1.001,12.31005,-0.66967>,<0.99531,12.32081,-0.6571>,<0.98399,12.31399,-0.66857>,
            
    /*3*/ <1.24693,12.91037,-0.93848>,<1.24376,12.9148,-0.93163>,<1.23881,12.91364,-0.93876>,
            
    /*4*/ <1.47765,13.54956,-1.11854>

    /* stem 0.14.8*/ 
    /*0*/ <0.97609,11.91287,-0.26154>,
    /*1*/ <0.9851,11.90952,-0.25033>,<0.969,11.92583,-0.2617>,<0.97415,11.90326,-0.27259>,
            
    /*2*/ <1.50985,12.19474,-0.59356>,<1.49912,12.20561,-0.60114>,<1.50255,12.19057,-0.60841>,
            
    /*3*/ <1.92467,12.62929,-0.93348>,<1.9179,12.63367,-0.93626>,<1.92095,12.62716,-0.94086>,
            
    /*4*/ <2.22204,13.18412,-1.21429>

    /* stem 0.14.9*/ 
    /*0*/ <1.06636,12.09867,-0.28573>,
    /*1*/ <1.05902,12.10301,-0.27424>,<1.06493,12.1056,-0.29817>,<1.07512,12.0874,-0.28478>,
            
    /*2*/ <1.56798,12.50966,-0.10863>,<1.57192,12.51139,-0.12458>,<1.57871,12.49925,-0.11566>,
            
    /*3*/ <2.04187,12.94247,0.08874>,<2.04419,12.9436,0.08089>,<2.04772,12.93766,0.08542>,
            
    /*4*/ <2.41899,13.46983,0.26458>

    /* stem 0.14.10*/ 
    /*0*/ <1.15936,12.32189,-0.31065>,
    /*1*/ <1.14746,12.32625,-0.31604>,<1.17091,12.32237,-0.31815>,<1.15972,12.31706,-0.29776>,
            
    /*2*/ <1.27113,12.92676,-0.09207>,<1.28675,12.92417,-0.09347>,<1.2793,12.92063,-0.07987>,
            
    /*3*/ <1.33444,13.55707,0.05996>,<1.34235,13.55646,0.05941>,<1.33874,13.55514,0.06637>,
            
    /*4*/ <1.42281,14.20038,0.12524>

    /* stem 0.14.11*/ 
    /*0*/ <1.29761,12.65368,-0.34769>,
    /*1*/ <1.29922,12.65159,-0.36041>,<1.30796,12.65511,-0.33998>,<1.28564,12.65435,-0.34269>,
            
    /*2*/ <1.29005,13.26759,-0.45851>,<1.29588,13.26993,-0.44489>,<1.281,13.26943,-0.4467>,
            
    /*3*/ <1.34779,13.88957,-0.47406>,<1.3506,13.88953,-0.46712>,<1.34321,13.89019,-0.46816>,
            
    /*4*/ <1.43914,14.5033,-0.53506>

    /* stem 0.14.12*/ 
    /*0*/ <1.39952,12.89828,-0.375>,
    /*1*/ <1.41094,12.89345,-0.37561>,<1.39705,12.90738,-0.36693>,<1.39057,12.89401,-0.38247>,
            
    /*2*/ <1.5581,13.3046,-0.79073>,<1.54884,13.31389,-0.78495>,<1.54452,13.30497,-0.7953>,
            
    /*3*/ <1.62347,13.79314,-1.13984>,<1.61854,13.79662,-1.13598>,<1.61656,13.79279,-1.14171>,
            
    /*4*/ <1.75438,14.31466,-1.41108>

    /* stem 0.14.13*/ 
    /*0*/ <1.50968,13.16267,-0.40452>,
    /*1*/ <1.5131,13.1625,-0.39323>,<1.50235,13.17108,-0.40834>,<1.51359,13.15441,-0.41198>,
            
    /*2*/ <1.96584,13.49755,-0.5295>,<1.95867,13.50327,-0.53958>,<1.96617,13.49216,-0.54201>,
            
    /*3*/ <2.3274,13.93277,-0.65574>,<2.32313,13.93498,-0.66056>,<2.328,13.93048,-0.66213>,
            
    /*4*/ <2.60237,14.43093,-0.7658>

    /* stem 0.14.14*/ 
    /*0*/ <1.57039,13.30836,-0.42078>,
    /*1*/ <1.56133,13.31275,-0.41529>,<1.57176,13.31028,-0.432>,<1.57806,13.30205,-0.41506>,
            
    /*2*/ <1.86196,13.77931,-0.30041>,<1.86891,13.77766,-0.31156>,<1.87311,13.77218,-0.30026>,
            
    /*3*/ <2.17006,14.25597,-0.30493>,<2.1729,14.25412,-0.31061>,<2.17564,14.25241,-0.30483>,
            
    /*4*/ <2.40404,14.77113,-0.28361>

    /* stem 0.14.15*/ 
    /*0*/ <1.70645,13.63493,-0.45724>,
    /*1*/ <1.69954,13.63692,-0.46519>,<1.71698,13.63458,-0.45925>,<1.70284,13.63328,-0.44728>,
            
    /*2*/ <1.73835,14.16384,-0.36196>,<1.74997,14.16228,-0.358>,<1.74055,14.16141,-0.35002>,
            
    /*3*/ <1.73566,14.69761,-0.29819>,<1.7415,14.69743,-0.29615>,<1.73681,14.69693,-0.29214>,
            
    /*4*/ <1.79742,15.2254,-0.20951>

    /* stem 0.14.16*/ 
    /*0*/ <1.78214,13.81657,-0.47752>,
    /*1*/ <1.78729,13.81348,-0.48591>,<1.78729,13.81935,-0.46903>,<1.77183,13.81687,-0.47762>,
            
    /*2*/ <1.80183,14.30784,-0.65449>,<1.80183,14.31174,-0.64324>,<1.79152,14.31009,-0.64897>,
            
    /*3*/ <1.85637,14.82606,-0.7057>,<1.85622,14.82669,-0.69978>,<1.85117,14.82691,-0.70293>,
            
    /*4*/ <1.92089,15.32864,-0.83132>

    /* stem 0.14.17*/ 
    /*0*/ <1.8727,14.0681,-0.50179>,
    /*1*/ <1.8815,14.06583,-0.4982>,<1.86653,14.07352,-0.49651>,<1.87008,14.06494,-0.51065>,
            
    /*2*/ <2.06902,14.48242,-0.70384>,<2.05904,14.48755,-0.70271>,<2.0614,14.48183,-0.71213>,
            
    /*3*/ <2.30537,14.88866,-0.87511>,<2.30061,14.89164,-0.87471>,<2.30183,14.88892,-0.87949>,
            
    /*4*/ <2.53654,15.33256,-0.88943>

    /* stem 0.14.18*/ 
    /*0*/ <1.95075,14.33799,-0.5227>,
    /*1*/ <1.94962,14.33902,-0.51363>,<1.94568,14.34294,-0.52856>,<1.95696,14.33201,-0.52591>,
            
    /*2*/ <2.28274,14.68246,-0.51411>,<2.28012,14.68507,-0.52406>,<2.28763,14.67778,-0.5223>,
            
    /*3*/ <2.5199,15.09037,-0.59815>,<2.5178,15.09062,-0.60302>,<2.52241,15.0881,-0.60224>,
            
    /*4*/ <2.69577,15.52657,-0.68582>

    /* stem 0.14.19*/ 
    /*0*/ <2.01215,14.5503,-0.53915>,
    /*1*/ <2.00377,14.55277,-0.53848>,<2.01667,14.5521,-0.54643>,<2.01599,14.54603,-0.53255>,
            
    /*2*/ <2.13977,14.95362,-0.35655>,<2.14837,14.95317,-0.36185>,<2.14791,14.94912,-0.3526>,
            
    /*3*/ <2.27595,15.37982,-0.24674>,<2.28013,15.37923,-0.24952>,<2.28015,15.37796,-0.24462>,
            
    /*4*/ <2.39092,15.82195,-0.188>

    /* stem 0.14.20*/ 
    /*0*/ <2.08041,14.78638,-0.55745>,
    /*1*/ <2.07788,14.78651,-0.56532>,<2.08818,14.78852,-0.55557>,<2.07519,14.78412,-0.55145>,
            
    /*2*/ <1.95153,15.20603,-0.51506>,<1.9584,15.20738,-0.50856>,<1.94974,15.20444,-0.50581>,
            
    /*3*/ <1.84704,15.62738,-0.43489>,<1.85057,15.62767,-0.43168>,<1.84619,15.62633,-0.43031>,
            
    /*4*/ <1.7913,16.06045,-0.37308>

    /* stem 0.14.21*/ 
    /*0*/ <2.14822,15.02084,-0.57561>,
    /*1*/ <2.1546,15.01869,-0.57955>,<2.14891,15.02482,-0.56894>,<2.14115,15.01901,-0.57835>,
            
    /*2*/ <2.1419,15.38167,-0.7933>,<2.13811,15.38576,-0.78623>,<2.13294,15.38189,-0.7925>,
            
    /*3*/ <2.15554,15.76867,-0.95986>,<2.15363,15.77036,-0.95615>,<2.15106,15.76898,-0.95957>,
            
    /*4*/ <2.2688,16.15506,-1.08306>

    /* stem 0.14.22*/ 
    /*0*/ <2.19507,15.18285,-0.58817>,
    /*1*/ <2.20011,15.18181,-0.58275>,<2.1891,15.18718,-0.58693>,<2.19599,15.17957,-0.59482>,
            
    /*2*/ <2.40667,15.50727,-0.71615>,<2.39933,15.51085,-0.71894>,<2.40392,15.50578,-0.72419>,
            
    /*3*/ <2.5722,15.86939,-0.80479>,<2.56836,15.87086,-0.80608>,<2.571,15.86896,-0.80891>,
            
    /*4*/ <2.68793,16.25215,-0.8863>

    /* stem 0.14.23*/ 
    /*0*/ <2.26985,15.44146,-0.6082>,
    /*1*/ <2.26688,15.44269,-0.60341>,<2.26892,15.44448,-0.61304>,<2.27375,15.4372,-0.60817>,
            
    /*2*/ <2.54143,15.69408,-0.50017>,<2.54279,15.69527,-0.50659>,<2.54601,15.69042,-0.50335>,
            
    /*3*/ <2.81914,15.96046,-0.46086>,<2.81942,15.96068,-0.46418>,<2.82128,15.95849,-0.46249>,
            
    /*4*/ <3.04548,16.27301,-0.44487>

    /* stem 0.14.24*/ 
    /*0*/ <2.3155,15.59933,-0.62044>,
    /*1*/ <2.31177,15.6003,-0.62188>,<2.31888,15.60056,-0.62246>,<2.31587,15.59714,-0.61697>,
            
    /*2*/ <2.3176,15.91538,-0.4221>,<2.32234,15.91555,-0.42249>,<2.32033,15.91326,-0.41883>,
            
    /*3*/ <2.29089,16.26119,-0.28574>,<2.29326,16.26143,-0.28587>,<2.29226,16.26057,-0.28389>,
            
    /*4*/ <2.31603,16.61492,-0.1693>

    /* stem 0.14.25*/ 
    /*0*/ <2.38323,15.83354,-0.63858>,
    /*1*/ <2.38341,15.83336,-0.64024>,<2.38448,15.83417,-0.63767>,<2.3818,15.83308,-0.63784>,
            
    /*2*/ <2.25299,16.15833,-0.68907>,<2.2537,16.15888,-0.68736>,<2.25192,16.15815,-0.68747>,
            
    /*3*/ <2.14777,16.49268,-0.73539>,<2.14814,16.49292,-0.73453>,<2.14723,16.49262,-0.73459>,
            
    /*4*/ <2.07359,16.82435,-0.83254>

    /* stem 0.15*/ 
    /*0*/ <0,10.56946,0>,
    /*1*/ <-0.0554,10.56946,0.02945>,<-0.04138,10.5993,-0.03652>,<0.02982,10.5879,-0.05203>,
            <0.05981,10.55103,0.00437>,<0.00714,10.53963,0.05473>,
    /*2*/ <0.45494,12.38415,0.94471>,<0.46429,12.40404,0.90073>,<0.51175,12.39645,0.89039>,
            <0.53174,12.37186,0.92799>,<0.49663,12.36426,0.96156>,
    /*3*/ <0.86305,14.3082,1.6677>,<0.86723,14.31608,1.64479>,<0.89115,14.31307,1.63997>,
            <0.90175,14.30334,1.6599>,<0.88438,14.30033,1.67704>,
    /*4*/ <1.16365,16.3156,2.18851>

    /* stem 0.15.0*/ 
    /*0*/ <0.07642,10.8514,0.14372>,
    /*1*/ <0.06553,10.86031,0.13202>,<0.09362,10.85706,0.14634>,<0.0701,10.83682,0.1528>,
            
    /*2*/ <-0.18165,11.3413,0.73793>,<-0.16293,11.33913,0.74748>,<-0.17861,11.32564,0.75179>,
            
    /*3*/ <-0.27395,11.93807,1.28091>,<-0.2643,11.93617,1.28474>,<-0.27267,11.93118,1.28881>,
            
    /*4*/ <-0.31323,12.61338,1.72944>

    /* stem 0.15.1*/ 
    /*0*/ <0.11314,10.98688,0.21279>,
    /*1*/ <0.12417,10.99081,0.19921>,<0.11954,10.98573,0.2295>,<0.09571,10.98409,0.20965>,
            
    /*2*/ <-0.02346,11.76852,0.31225>,<-0.02655,11.76514,0.33245>,<-0.04244,11.76405,0.31922>,
            
    /*3*/ <-0.11152,12.54148,0.49844>,<-0.11297,12.53899,0.50839>,<-0.12107,12.53961,0.50198>,
            
    /*4*/ <-0.08363,13.27719,0.81111>

    /* stem 0.15.2*/ 
    /*0*/ <0.17142,11.2019,0.32239>,
    /*1*/ <0.18655,11.19515,0.32758>,<0.16043,11.20854,0.33406>,<0.16729,11.20199,0.30554>,
            
    /*2*/ <0.51979,11.89549,0.24686>,<0.50238,11.90441,0.25118>,<0.50695,11.90005,0.23216>,
            
    /*3*/ <0.68704,12.65893,0.21897>,<0.67753,12.66116,0.22119>,<0.68035,12.66019,0.21162>,
            
    /*4*/ <0.81006,13.42917,0.21105>

    /* stem 0.15.3*/ 
    /*0*/ <0.22139,11.38625,0.41637>,
    /*1*/ <0.21763,11.37961,0.43141>,<0.21266,11.39946,0.41057>,<0.23388,11.37968,0.40714>,
            
    /*2*/ <0.71458,11.85589,0.75999>,<0.71127,11.86912,0.7461>,<0.72541,11.85594,0.74381>,
            
    /*3*/ <1.11416,12.35811,1.16985>,<1.11269,12.36492,1.16305>,<1.1205,12.35913,1.16253>,
            
    /*4*/ <1.30487,13.02933,1.4797>

    /* stem 0.15.4*/ 
    /*0*/ <0.27226,11.57394,0.51205>,
    /*1*/ <0.25635,11.5774,0.51372>,<0.28238,11.58497,0.50544>,<0.27805,11.55944,0.51698>,
            
    /*2*/ <0.39446,11.85955,1.18969>,<0.41182,11.8646,1.18417>,<0.40893,11.84758,1.19187>,
            
    /*3*/ <0.48731,12.36374,1.72924>,<0.49587,12.36589,1.72585>,<0.49493,12.3591,1.73235>,
            
    /*4*/ <0.55151,12.92375,2.21658>

    /* stem 0.15.5*/ 
    /*0*/ <0.31882,11.74571,0.59961>,
    /*1*/ <0.31541,11.75349,0.58616>,<0.3339,11.74461,0.60457>,<0.30714,11.73902,0.60812>,
            
    /*2*/ <0.23748,12.36981,0.96865>,<0.2498,12.36388,0.98092>,<0.23196,12.36016,0.98329>,
            
    /*3*/ <0.19202,13.04534,1.23559>,<0.19816,13.04325,1.2421>,<0.18919,13.04202,1.24368>,
            
    /*4*/ <0.16111,13.71755,1.51771>

    /* stem 0.15.6*/ 
    /*0*/ <0.36288,11.90827,0.68248>,
    /*1*/ <0.37645,11.90841,0.67501>,<0.36256,11.90691,0.69791>,<0.34964,11.9095,0.67454>,
            
    /*2*/ <0.3998,12.61949,0.74092>,<0.39054,12.61849,0.75619>,<0.38193,12.62022,0.74061>,
            
    /*3*/ <0.41448,13.32114,0.8783>,<0.40979,13.31983,0.8858>,<0.40554,13.32143,0.8781>,
            
    /*4*/ <0.48101,14.00649,1.06857>

    /* stem 0.15.7*/ 
    /*0*/ <0.40854,12.07672,0.76835>,
    /*1*/ <0.41769,12.06941,0.77781>,<0.39594,12.08313,0.77352>,<0.41199,12.07761,0.75373>,
            
    /*2*/ <0.76492,12.66488,0.89354>,<0.75042,12.67402,0.89068>,<0.76112,12.67034,0.87748>,
            
    /*3*/ <1.11293,13.24645,1.06203>,<1.10577,13.25119,1.06068>,<1.11133,13.24975,1.05415>,
            
    /*4*/ <1.31375,13.86413,1.32121>

    /* stem 0.15.8*/ 
    /*0*/ <0.46782,12.29542,0.87984>,
    /*1*/ <0.45909,12.29213,0.89093>,<0.46548,12.30745,0.87211>,<0.47888,12.28668,0.87648>,
            
    /*2*/ <0.86505,12.64178,1.30765>,<0.86931,12.65199,1.2951>,<0.87824,12.63814,1.29802>,
            
    /*3*/ <1.22763,13.08,1.6788>,<1.22922,13.08455,1.67197>,<1.23441,13.07837,1.67419>,
            
    /*4*/ <1.54069,13.57852,2.01683>

    /* stem 0.15.9*/ 
    /*0*/ <0.51034,12.47533,0.9598>,
    /*1*/ <0.49773,12.47959,0.95532>,<0.52189,12.4823,0.95592>,<0.51139,12.4641,0.96817>,
            
    /*2*/ <0.44496,12.86926,1.48864>,<0.46107,12.87106,1.48903>,<0.45407,12.85893,1.4972>,
            
    /*3*/ <0.53777,13.31849,1.96865>,<0.54578,13.31823,1.96741>,<0.54234,13.31321,1.97277>,
            
    /*4*/ <0.70902,13.87345,2.28756>

    /* stem 0.15.10*/ 
    /*0*/ <0.56589,12.74965,1.06428>,
    /*1*/ <0.56839,12.75388,1.05183>,<0.57581,12.74895,1.07324>,<0.55346,12.7461,1.06777>,
            
    /*2*/ <0.44697,13.35326,1.23606>,<0.45191,13.34998,1.25034>,<0.43701,13.34808,1.24669>,
            
    /*3*/ <0.27765,13.93825,1.42962>,<0.28008,13.93664,1.43678>,<0.27276,13.93518,1.43477>,
            
    /*4*/ <0.20796,14.55595,1.5741>

    /* stem 0.15.11*/ 
    /*0*/ <0.61482,12.99127,1.1563>,
    /*1*/ <0.62741,12.9892,1.15503>,<0.61009,12.99533,1.16751>,<0.60696,12.98928,1.14637>,
            
    /*2*/ <0.70122,13.57576,0.97613>,<0.68968,13.57984,0.98445>,<0.6876,13.5758,0.97036>,
            
    /*3*/ <0.67213,14.19278,0.93176>,<0.66622,14.19287,0.93621>,<0.66533,14.1923,0.92889>,
            
    /*4*/ <0.66733,14.80999,0.95148>

    /* stem 0.15.12*/ 
    /*0*/ <0.66628,13.24541,1.2531>,
    /*1*/ <0.6694,13.24066,1.26392>,<0.65602,13.25196,1.25202>,<0.67343,13.24361,1.24335>,
            
    /*2*/ <0.97127,13.73803,1.3909>,<0.96235,13.74557,1.38296>,<0.97396,13.74,1.37718>,
            
    /*3*/ <1.17764,14.27106,1.55814>,<1.1729,14.27424,1.554>,<1.17926,14.27258,1.55145>,
            
    /*4*/ <1.35512,14.8157,1.72134>

    /* stem 0.15.13*/ 
    /*0*/ <0.71538,13.48783,1.34543>,
    /*1*/ <0.70526,13.48767,1.35123>,<0.71737,13.49606,1.33741>,<0.7235,13.47976,1.34765>,
            
    /*2*/ <0.93514,13.827,1.75364>,<0.94321,13.8326,1.74442>,<0.9473,13.82173,1.75125>,
            
    /*3*/ <1.10436,14.25936,2.09137>,<1.1082,14.26178,2.0864>,<1.11076,14.25736,2.09079>,
            
    /*4*/ <1.18893,14.78839,2.29831>

    /* stem 0.15.14*/ 
    /*0*/ <0.75145,13.66596,1.41327>,
    /*1*/ <0.74419,13.67027,1.40582>,<0.76184,13.67021,1.41411>,<0.74832,13.65741,1.41988>,
            
    /*2*/ <0.56725,14.03213,1.79323>,<0.57901,14.03209,1.79875>,<0.57,14.02356,1.8026>,
            
    /*3*/ <0.4168,14.41946,2.16692>,<0.42274,14.4193,2.16955>,<0.41809,14.41534,2.17177>,
            
    /*4*/ <0.39694,14.89578,2.45852>

    /* stem 0.15.15*/ 
    /*0*/ <0.80645,13.93753,1.5167>,
    /*1*/ <0.81259,13.93951,1.50824>,<0.81044,13.93849,1.52652>,<0.79631,13.9346,1.51535>,
            
    /*2*/ <0.66048,14.45246,1.52224>,<0.65905,14.45177,1.53442>,<0.64962,14.44918,1.52698>,
            
    /*3*/ <0.51907,14.96701,1.48958>,<0.51823,14.9672,1.49566>,<0.51356,14.96569,1.49197>,
            
    /*4*/ <0.47767,15.49223,1.39944>

    /* stem 0.15.16*/ 
    /*0*/ <0.86863,14.2446,1.63366>,
    /*1*/ <0.87763,14.24162,1.63668>,<0.86243,14.249,1.64008>,<0.86583,14.24317,1.62421>,
            
    /*2*/ <1.0667,14.69638,1.51027>,<1.05656,14.70129,1.51253>,<1.05883,14.69741,1.50196>,
            
    /*3*/ <1.27656,15.15847,1.52334>,<1.27143,15.1608,1.52451>,<1.27313,15.16018,1.51905>,
            
    /*4*/ <1.519,15.60053,1.5865>

    /* stem 0.15.17*/ 
    /*0*/ <0.90326,14.46293,1.69878>,
    /*1*/ <0.90179,14.46073,1.70789>,<0.89698,14.46831,1.69413>,<0.911,14.45975,1.69432>,
            
    /*2*/ <1.14622,14.86383,1.84149>,<1.14302,14.86889,1.83231>,<1.15237,14.86318,1.83244>,
            
    /*3*/ <1.29511,15.31207,1.97185>,<1.29328,15.31409,1.9671>,<1.29843,15.31227,1.96749>,
            
    /*4*/ <1.34432,15.76994,2.13835>

    /* stem 0.15.18*/ 
    /*0*/ <0.92518,14.61887,1.74>,
    /*1*/ <0.91612,14.6199,1.74093>,<0.92997,14.62483,1.73496>,<0.92944,14.61188,1.74411>,
            
    /*2*/ <0.98954,14.89,2.12714>,<0.99877,14.89328,2.12316>,<0.99842,14.88465,2.12926>,
            
    /*3*/ <0.96215,15.22871,2.45997>,<0.96679,15.23069,2.45837>,<0.96665,15.22698,2.46214>,
            
    /*4*/ <0.92992,15.62436,2.7243>

    /* stem 0.15.19*/ 
    /*0*/ <0.95246,14.81298,1.79131>,
    /*1*/ <0.94992,14.81545,1.7833>,<0.96043,14.81511,1.79423>,<0.94702,14.80837,1.7964>,
            
    /*2*/ <0.78205,15.20631,1.96036>,<0.78906,15.20608,1.96765>,<0.78012,15.20159,1.9691>,
            
    /*3*/ <0.58335,15.60223,2.08434>,<0.5866,15.60269,2.08819>,<0.58221,15.60028,2.08886>,
            
    /*4*/ <0.42508,16.02058,2.19478>

    /* stem 0.15.20*/ 
    /*0*/ <0.99698,15.12974,1.87504>,
    /*1*/ <1.00394,15.12986,1.87088>,<0.99704,15.13077,1.88309>,<0.98995,15.12859,1.87116>,
            
    /*2*/ <0.96146,15.55879,1.81765>,<0.95687,15.5594,1.82579>,<0.95214,15.55794,1.81784>,
            
    /*3*/ <0.94776,15.9922,1.79538>,<0.94547,15.99236,1.79947>,<0.94308,15.99208,1.79545>,
            
    /*4*/ <0.97407,16.42485,1.82175>

    /* stem 0.15.21*/ 
    /*0*/ <1.02487,15.32822,1.92751>,
    /*1*/ <1.03008,15.32609,1.93278>,<1.01874,15.33239,1.92961>,<1.0258,15.32617,1.92013>,
            
    /*2*/ <1.24315,15.67802,1.86035>,<1.23559,15.68222,1.85824>,<1.24029,15.67808,1.85192>,
            
    /*3*/ <1.41443,16.05879,1.84967>,<1.41048,16.06057,1.84865>,<1.41323,16.05924,1.84541>,
            
    /*4*/ <1.5509,16.45317,1.86911>

    /* stem 0.15.22*/ 
    /*0*/ <1.05633,15.552,1.98666>,
    /*1*/ <1.0523,15.55099,1.99262>,<1.05408,15.55658,1.98149>,<1.0626,15.54842,1.98587>,
            
    /*2*/ <1.24676,15.84994,2.17164>,<1.24794,15.85368,2.16422>,<1.25362,15.84823,2.16713>,
            
    /*3*/ <1.43723,16.19212,2.2534>,<1.43731,16.19307,2.24931>,<1.44047,16.1909,2.25102>,
            
    /*4*/ <1.57185,16.56637,2.28685>

    /* stem 0.15.23*/ 
    /*0*/ <1.09007,15.79206,2.05012>,
    /*1*/ <1.08502,15.79322,2.0484>,<1.09438,15.79405,2.04744>,<1.0908,15.78891,2.05451>,
            
    /*2*/ <1.08229,16.10036,2.27042>,<1.08853,16.10092,2.26978>,<1.08613,16.09749,2.27449>,
            
    /*3*/ <1.13914,16.43772,2.43417>,<1.14222,16.43751,2.43356>,<1.14107,16.43639,2.43627>,
            
    /*4*/ <1.17952,16.79298,2.55941>

    /* stem 0.15.24*/ 
    /*0*/ <1.11939,16.00067,2.10526>,
    /*1*/ <1.11984,16.00144,2.10211>,<1.12173,16.00134,2.10747>,<1.1166,15.99924,2.10622>,
            
    /*2*/ <0.97239,16.32621,2.16139>,<0.97365,16.32614,2.16496>,<0.97023,16.32474,2.16413>,
            
    /*3*/ <0.87812,16.66924,2.22582>,<0.87879,16.66909,2.22759>,<0.87698,16.66867,2.22722>,
            
    /*4*/ <0.7995,17.01831,2.27745>

    /* stem 0.15.25*/ 
    /*0*/ <1.14848,16.20763,2.15997>,
    /*1*/ <1.14959,16.20751,2.15984>,<1.14805,16.20784,2.16099>,<1.14779,16.20754,2.15908>,
            
    /*2*/ <1.17899,16.54552,2.10142>,<1.17796,16.54575,2.10219>,<1.17779,16.54554,2.10092>,
            
    /*3*/ <1.18423,16.87865,2.01446>,<1.18372,16.87876,2.01485>,<1.18363,16.8786,2.01423>,
            
    /*4*/ <1.19651,17.21909,1.96467>

    /* stem 0.16*/ 
    /*0*/ <0,11.28603,0>,
    /*1*/ <-0.0397,11.28603,-0.04567>,<0.02535,11.3148,-0.04681>,<0.05536,11.30381,0.01674>,
            <0.00887,11.26824,0.05715>,<-0.04988,11.25725,0.01859>,
    /*2*/ <-0.79549,13.05094,0.63806>,<-0.75213,13.07012,0.6373>,<-0.73212,13.06279,0.67966>,
            <-0.76311,13.03908,0.70661>,<-0.80228,13.03175,0.68089>,
    /*3*/ <-1.39145,14.92221,1.18284>,<-1.36901,14.9298,1.18181>,<-1.3593,14.9269,1.20324>,
            <-1.37573,14.91751,1.21752>,<-1.3956,14.91461,1.20492>,
    /*4*/ <-1.81934,16.87453,1.58153>

    /* stem 0.16.0*/ 
    /*0*/ <-0.1131,11.54558,0.09831>,
    /*1*/ <-0.10444,11.5542,0.08552>,<-0.11167,11.55093,0.11511>,<-0.12318,11.53161,0.09431>,
            
    /*2*/ <-0.73008,12.02913,-0.00963>,<-0.7349,12.02695,0.0101>,<-0.74257,12.01407,-0.00377>,
            
    /*3*/ <-1.15904,12.6906,-0.04301>,<-1.16142,12.68963,-0.03313>,<-1.16739,12.6854,-0.04026>,
            
    /*4*/ <-1.49779,13.40496,-0.05906>

    /* stem 0.16.1*/ 
    /*0*/ <-0.16039,11.65413,0.13943>,
    /*1*/ <-0.14515,11.65794,0.1469>,<-0.17445,11.65131,0.14929>,<-0.16158,11.65313,0.1221>,
            
    /*2*/ <-0.32491,12.41739,0.11252>,<-0.34444,12.41298,0.11411>,<-0.33587,12.41419,0.09599>,
            
    /*3*/ <-0.5451,13.16494,0.16689>,<-0.5547,13.16212,0.16767>,<-0.55073,13.16395,0.15863>,
            
    /*4*/ <-0.68932,13.9032,0.37407>

    /* stem 0.16.2*/ 
    /*0*/ <-0.27175,11.9097,0.23623>,
    /*1*/ <-0.27334,11.9032,0.25155>,<-0.28531,11.91468,0.22782>,<-0.25661,11.91122,0.22933>,
            
    /*2*/ <-0.20514,12.5975,0.54691>,<-0.21312,12.60515,0.53109>,<-0.19399,12.60284,0.53209>,
            
    /*3*/ <-0.28205,13.30229,0.81457>,<-0.28601,13.30509,0.80623>,<-0.27646,13.30566,0.80747>,
            
    /*4*/ <-0.31904,13.97668,1.15649>

    /* stem 0.16.3*/ 
    /*0*/ <-0.33855,12.06301,0.2943>,
    /*1*/ <-0.35354,12.05658,0.29402>,<-0.33524,12.07636,0.28553>,<-0.32688,12.05608,0.30334>,
            
    /*2*/ <-0.54222,12.48566,0.87106>,<-0.53002,12.49884,0.8654>,<-0.52445,12.48533,0.87727>,
            
    /*3*/ <-0.61559,13.08341,1.31115>,<-0.60889,13.08789,1.30628>,<-0.60657,13.08267,1.31376>,
            
    /*4*/ <-0.65889,13.78893,1.54339>

    /* stem 0.16.4*/ 
    /*0*/ <-0.42252,12.2557,0.36729>,
    /*1*/ <-0.42755,12.25904,0.35268>,<-0.41268,12.2656,0.37472>,<-0.42732,12.24247,0.37447>,
            
    /*2*/ <-0.99387,12.61436,0.63474>,<-0.98396,12.61873,0.64942>,<-0.99372,12.60331,0.64926>,
            
    /*3*/ <-1.46245,13.10915,0.88275>,<-1.45695,13.1109,0.88982>,<-1.46338,13.10446,0.89053>,
            
    /*4*/ <-1.82325,13.67092,1.16794>

    /* stem 0.16.5*/ 
    /*0*/ <-0.48662,12.40281,0.42301>,
    /*1*/ <-0.47465,12.41035,0.41686>,<-0.49063,12.40536,0.43768>,<-0.49457,12.39271,0.41449>,
            
    /*2*/ <-0.91552,12.92923,0.20856>,<-0.92617,12.9259,0.22244>,<-0.9288,12.91747,0.20698>,
            
    /*3*/ <-1.28124,13.53166,0.11266>,<-1.28634,13.52975,0.11971>,<-1.28874,13.527,0.11159>,
            
    /*4*/ <-1.59224,14.17144,0.08812>

    /* stem 0.16.6*/ 
    /*0*/ <-0.59058,12.64141,0.51339>,
    /*1*/ <-0.5807,12.64154,0.52441>,<-0.60501,12.63995,0.51639>,<-0.58604,12.64274,0.49936>,
            
    /*2*/ <-0.64383,13.32736,0.56632>,<-0.66003,13.3263,0.56097>,<-0.64739,13.32815,0.54962>,
            
    /*3*/ <-0.78567,13.99844,0.64457>,<-0.79365,13.99713,0.6418>,<-0.78747,13.99908,0.63624>,
            
    /*4*/ <-0.98864,14.64648,0.7671>

    /* stem 0.16.7*/ 
    /*0*/ <-0.65249,12.78348,0.5672>,
    /*1*/ <-0.65935,12.77647,0.57779>,<-0.65973,12.79267,0.55874>,<-0.63838,12.78129,0.56505>,
            
    /*2*/ <-0.51386,13.28417,1.00113>,<-0.51411,13.29497,0.98843>,<-0.49988,13.28738,0.99264>,
            
    /*3*/ <-0.39287,13.85132,1.35213>,<-0.3932,13.8558,1.34511>,<-0.38593,13.85264,1.34771>,
            
    /*4*/ <-0.34138,14.46587,1.63187>

    /* stem 0.16.8*/ 
    /*0*/ <-0.74298,12.99116,0.64586>,
    /*1*/ <-0.75524,12.988,0.6401>,<-0.73669,13.00315,0.64269>,<-0.73702,12.98233,0.6548>,
            
    /*2*/ <-1.06183,13.28402,1.14102>,<-1.04946,13.29411,1.14275>,<-1.04968,13.28023,1.15082>,
            
    /*3*/ <-1.26551,13.7283,1.5832>,<-1.25851,13.73218,1.58259>,<-1.25941,13.72635,1.58804>,
            
    /*4*/ <-1.40702,14.29438,1.88714>

    /* stem 0.16.9*/ 
    /*0*/ <-0.82389,13.21946,0.7162>,
    /*1*/ <-0.82243,13.22352,0.70355>,<-0.81598,13.22442,0.72575>,<-0.83326,13.21046,0.71928>,
            
    /*2*/ <-1.24121,13.69216,0.81019>,<-1.23691,13.69276,0.82498>,<-1.24842,13.68345,0.82067>,
            
    /*3*/ <-1.51874,14.22606,1.02344>,<-1.51562,14.22495,1.0304>,<-1.52255,14.222,1.02877>,
            
    /*4*/ <-1.64625,14.82156,1.21048>

    /* stem 0.16.10*/ 
    /*0*/ <-0.89531,13.43886,0.77829>,
    /*1*/ <-0.88314,13.44292,0.77794>,<-0.90248,13.44093,0.78874>,<-0.90033,13.43273,0.76818>,
            
    /*2*/ <-1.07416,13.98205,0.54296>,<-1.08705,13.98072,0.55016>,<-1.08562,13.97526,0.53646>,
            
    /*3*/ <-1.32234,14.51564,0.35052>,<-1.32851,14.51422,0.35438>,<-1.32794,14.51195,0.34735>,
            
    /*4*/ <-1.52893,15.08721,0.2384>

    /* stem 0.16.11*/ 
    /*0*/ <-0.95088,13.60954,0.82659>,
    /*1*/ <-0.94693,13.60753,0.83821>,<-0.96236,13.61388,0.82458>,<-0.94335,13.6072,0.81697>,
            
    /*2*/ <-0.73908,14.17365,0.86076>,<-0.74937,14.17788,0.85167>,<-0.73669,14.17343,0.8466>,
            
    /*3*/ <-0.64232,14.76362,0.94146>,<-0.64762,14.76516,0.93687>,<-0.6409,14.76439,0.93447>,
            
    /*4*/ <-0.66492,15.3631,1.01025>

    /* stem 0.16.12*/ 
    /*0*/ <-1.01764,13.8146,0.88462>,
    /*1*/ <-1.02727,13.80995,0.88997>,<-1.01894,13.82305,0.87626>,<-1.0067,13.81079,0.88762>,
            
    /*2*/ <-0.99381,14.22484,1.30191>,<-0.98826,14.23358,1.29277>,<-0.9801,14.2254,1.30034>,
            
    /*3*/ <-0.99301,14.69926,1.64587>,<-0.99024,14.703,1.64077>,<-0.98615,14.69973,1.64528>,
            
    /*4*/ <-0.97475,15.21383,1.9257>

    /* stem 0.16.13*/ 
    /*0*/ <-1.11226,14.10526,0.96687>,
    /*1*/ <-1.11994,14.10511,0.95859>,<-1.10481,14.11372,0.9675>,<-1.11204,14.09696,0.97452>,
            
    /*2*/ <-1.47225,14.39372,1.28495>,<-1.46216,14.39947,1.29089>,<-1.46698,14.38829,1.29557>,
            
    /*3*/ <-1.79275,14.77034,1.54764>,<-1.78747,14.77297,1.55041>,<-1.79066,14.76815,1.55342>,
            
    /*4*/ <-2.09135,15.2069,1.73165>

    /* stem 0.16.14*/ 
    /*0*/ <-1.17708,14.30436,1.02322>,
    /*1*/ <-1.17166,14.30851,1.01479>,<-1.17479,14.30767,1.03329>,<-1.18478,14.29692,1.02158>,
            
    /*2*/ <-1.54459,14.70089,0.97288>,<-1.54668,14.70032,0.98521>,<-1.55334,14.69316,0.9774>,
            
    /*3*/ <-1.84805,15.14815,0.92987>,<-1.84918,15.14801,0.93602>,<-1.85301,15.14503,0.93207>,
            
    /*4*/ <-2.16084,15.58974,0.98003>

    /* stem 0.16.15*/ 
    /*0*/ <-1.25228,14.53537,1.08859>,
    /*1*/ <-1.24295,14.53729,1.09255>,<-1.26051,14.53482,1.0948>,<-1.25339,14.534,1.07842>,
            
    /*2*/ <-1.32596,15.04978,1.03091>,<-1.33767,15.04813,1.03241>,<-1.33293,15.04759,1.02149>,
            
    /*3*/ <-1.48974,15.54617,0.99923>,<-1.49537,15.5444,1.00002>,<-1.49312,15.54479,0.99452>,
            
    /*4*/ <-1.64932,16.03981,1.06192>

    /* stem 0.16.16*/ 
    /*0*/ <-1.32325,14.75336,1.15028>,
    /*1*/ <-1.32416,14.75042,1.15963>,<-1.33123,14.7559,1.14513>,<-1.31436,14.75376,1.1461>,
            
    /*2*/ <-1.27238,15.228,1.31153>,<-1.2771,15.23166,1.30187>,<-1.26585,15.23023,1.30251>,
            
    /*3*/ <-1.26328,15.71013,1.45764>,<-1.26566,15.7117,1.45272>,<-1.26,15.71145,1.45319>,
            
    /*4*/ <-1.37825,16.19479,1.53567>

    /* stem 0.16.17*/ 
    /*0*/ <-1.40535,15.04227,1.22165>,
    /*1*/ <-1.41429,15.04013,1.22225>,<-1.40243,15.04808,1.21512>,<-1.39933,15.0386,1.22758>,
            
    /*2*/ <-1.4796,15.40976,1.51997>,<-1.47169,15.41506,1.51522>,<-1.46962,15.40874,1.52352>,
            
    /*3*/ <-1.54779,15.82232,1.75408>,<-1.54376,15.82453,1.75141>,<-1.54286,15.82206,1.75604>,
            
    /*4*/ <-1.6863,16.25542,1.90379>

    /* stem 0.16.18*/ 
    /*0*/ <-1.44862,15.23379,1.25926>,
    /*1*/ <-1.45145,15.23477,1.25098>,<-1.44153,15.23822,1.26206>,<-1.45287,15.22836,1.26476>,
            
    /*2*/ <-1.72245,15.58426,1.38838>,<-1.71583,15.58655,1.39577>,<-1.7234,15.57998,1.39757>,
            
    /*3*/ <-1.96378,15.97645,1.42504>,<-1.96073,15.97801,1.4288>,<-1.96492,15.97533,1.42987>,
            
    /*4*/ <-2.14073,16.40388,1.44634>

    /* stem 0.16.19*/ 
    /*0*/ <-1.50889,15.50053,1.31166>,
    /*1*/ <-1.50206,15.50286,1.30762>,<-1.51001,15.50278,1.31953>,<-1.5146,15.49595,1.30781>,
            
    /*2*/ <-1.70882,15.86898,1.1752>,<-1.71412,15.86892,1.18314>,<-1.71718,15.86436,1.17533>,
            
    /*3*/ <-1.88576,16.25652,1.06299>,<-1.8884,16.25649,1.06696>,<-1.89011,16.25455,1.06295>,
            
    /*4*/ <-1.98877,16.68487,1.07543>

    /* stem 0.16.20*/ 
    /*0*/ <-1.55791,15.71748,1.35427>,
    /*1*/ <-1.55248,15.7176,1.35991>,<-1.56532,15.71937,1.35593>,<-1.55592,15.71548,1.34697>,
            
    /*2*/ <-1.47123,16.1225,1.26974>,<-1.4798,16.12368,1.26709>,<-1.47353,16.12109,1.26111>,
            
    /*3*/ <-1.49813,16.54089,1.21105>,<-1.50247,16.54047,1.20987>,<-1.49924,16.54024,1.20671>,
            
    /*4*/ <-1.53457,16.96053,1.24201>

    /* stem 0.16.21*/ 
    /*0*/ <-1.6095,15.94582,1.39912>,
    /*1*/ <-1.61329,15.94379,1.4051>,<-1.61301,15.94885,1.39338>,<-1.6022,15.94483,1.39886>,
            
    /*2*/ <-1.55658,16.31105,1.56265>,<-1.55639,16.31442,1.55483>,<-1.54918,16.31174,1.55849>,
            
    /*3*/ <-1.56258,16.69557,1.68527>,<-1.56251,16.69689,1.68122>,<-1.55886,16.69628,1.68332>,
            
    /*4*/ <-1.53714,17.07596,1.81799>

    /* stem 0.16.22*/ 
    /*0*/ <-1.63993,16.08048,1.42557>,
    /*1*/ <-1.64649,16.07949,1.42304>,<-1.63587,16.0857,1.42296>,<-1.63741,16.07625,1.43069>,
            
    /*2*/ <-1.78567,16.32503,1.69564>,<-1.77859,16.32917,1.69559>,<-1.77962,16.32287,1.70074>,
            
    /*3*/ <-1.85865,16.65248,1.90029>,<-1.85481,16.65377,1.89963>,<-1.85567,16.6515,1.90294>,
            
    /*4*/ <-1.92023,17.00811,2.0542>

    /* stem 0.16.23*/ 
    /*0*/ <-1.6894,16.29943,1.46857>,
    /*1*/ <-1.68881,16.3007,1.46279>,<-1.68612,16.30233,1.47259>,<-1.69326,16.29528,1.47032>,
            
    /*2*/ <-1.95571,16.56087,1.49488>,<-1.95391,16.56195,1.50142>,<-1.95868,16.55725,1.4999>,
            
    /*3*/ <-2.19341,16.8465,1.53827>,<-2.19238,16.84689,1.54152>,<-2.19501,16.84482,1.54079>,
            
    /*4*/ <-2.39139,17.16048,1.58464>

    /* stem 0.16.24*/ 
    /*0*/ <-1.75493,16.58948,1.52554>,
    /*1*/ <-1.75208,16.59017,1.5253>,<-1.75625,16.58957,1.52817>,<-1.75646,16.58869,1.52315>,
            
    /*2*/ <-1.83888,16.92458,1.4701>,<-1.84166,16.92419,1.47202>,<-1.8418,16.9236,1.46867>,
            
    /*3*/ <-1.91795,17.26303,1.5103>,<-1.91928,17.2626,1.51126>,<-1.91946,17.26276,1.50958>,
            
    /*4*/ <-1.96034,17.60724,1.55571>

    /* stem 0.16.25*/ 
    /*0*/ <-1.78923,16.74129,1.55536>,
    /*1*/ <-1.78877,16.74114,1.55664>,<-1.7905,16.74177,1.55513>,<-1.78843,16.74096,1.55429>,
            
    /*2*/ <-1.66785,17.05581,1.54867>,<-1.669,17.05623,1.54766>,<-1.66762,17.05569,1.5471>,
            
    /*3*/ <-1.60719,17.38416,1.50051>,<-1.60781,17.3842,1.50001>,<-1.60709,17.38403,1.49973>,
            
    /*4*/ <-1.65555,17.71632,1.46796>

    /* stem 0.17*/ 
    /*0*/ <0,11.76579,0>,
    /*1*/ <0.03465,11.76579,-0.04769>,<0.04999,11.79382,0.0138>,<-0.00376,11.78312,0.05622>,
            <-0.05231,11.74847,0.02094>,<-0.02857,11.73776,-0.04327>,
    /*2*/ <-0.78483,13.49551,-0.61878>,<-0.7746,13.51419,-0.57779>,<-0.81043,13.50706,-0.54951>,
            <-0.8428,13.48396,-0.57303>,<-0.82697,13.47682,-0.61584>,
    /*3*/ <-1.43638,15.32946,-1.06788>,<-1.43048,15.33686,-1.04681>,<-1.44869,15.33403,-1.03289>,
            <-1.46585,15.32489,-1.04536>,<-1.45824,15.32206,-1.06698>,
    /*4*/ <-1.91136,17.24285,-1.38869>

    /* stem 0.17.0*/ 
    /*0*/ <-0.12218,12.02737,-0.08877>,
    /*1*/ <-0.10816,12.03576,-0.08337>,<-0.13773,12.03204,-0.08305>,<-0.12066,12.01433,-0.09989>,
            
    /*2*/ <-0.18148,12.52888,-0.67644>,<-0.2012,12.5264,-0.67623>,<-0.18981,12.51459,-0.68746>,
            
    /*3*/ <-0.36445,13.14192,-1.11298>,<-0.37411,13.13982,-1.11199>,<-0.36894,13.13598,-1.11956>,
            
    /*4*/ <-0.55369,13.75741,-1.54386>

    /* stem 0.17.1*/ 
    /*0*/ <-0.18555,12.16305,-0.13481>,
    /*1*/ <-0.18928,12.16674,-0.1188>,<-0.19777,12.16253,-0.1464>,<-0.16961,12.15987,-0.13923>,
            
    /*2*/ <-0.08084,12.90593,-0.26997>,<-0.08651,12.90313,-0.28837>,<-0.06773,12.90135,-0.28359>,
            
    /*3*/ <-0.14647,13.61863,-0.53544>,<-0.14931,13.61521,-0.54409>,<-0.13987,13.61674,-0.54233>,
            
    /*4*/ <-0.2551,14.33163,-0.78149>

    /* stem 0.17.2*/ 
    /*0*/ <-0.31171,12.43315,-0.22647>,
    /*1*/ <-0.32647,12.42688,-0.22464>,<-0.3076,12.44017,-0.24041>,<-0.30107,12.4324,-0.21437>,
            
    /*2*/ <-0.56521,13.07666,0.02909>,<-0.55263,13.08552,0.01858>,<-0.54827,13.08034,0.03594>,
            
    /*3*/ <-0.84923,13.75652,0.05456>,<-0.8424,13.75964,0.04904>,<-0.84133,13.75974,0.0583>,
            
    /*4*/ <-1.10765,14.44371,0.12394>

    /* stem 0.17.3*/ 
    /*0*/ <-0.38335,12.58653,-0.27852>,
    /*1*/ <-0.38635,12.58033,-0.29267>,<-0.37563,12.60019,-0.27739>,<-0.38809,12.57906,-0.2655>,
            
    /*2*/ <-1.01358,12.93967,-0.3116>,<-1.00643,12.95291,-0.30141>,<-1.01474,12.93883,-0.29349>,
            
    /*3*/ <-1.49747,13.47633,-0.35906>,<-1.49224,13.48159,-0.35381>,<-1.49854,13.47624,-0.35004>,
            
    /*4*/ <-1.88511,14.08259,-0.43216>

    /* stem 0.17.4*/ 
    /*0*/ <-0.49836,12.83275,-0.36208>,
    /*1*/ <-0.48585,12.83594,-0.3699>,<-0.50404,12.8429,-0.35246>,<-0.50519,12.81941,-0.36388>,
            
    /*2*/ <-0.88067,13.10452,-0.88225>,<-0.8928,13.10916,-0.87063>,<-0.89356,13.0935,-0.87824>,
            
    /*3*/ <-1.15152,13.5184,-1.37559>,<-1.15781,13.52092,-1.37011>,<-1.15903,13.51399,-1.37525>,
            
    /*4*/ <-1.28545,14.05719,-1.80121>

    /* stem 0.17.5*/ 
    /*0*/ <-0.58434,13.01684,-0.42455>,
    /*1*/ <-0.57611,13.02399,-0.41481>,<-0.59877,13.01918,-0.42505>,<-0.57816,13.00735,-0.43379>,
            
    /*2*/ <-0.48151,13.52493,-0.8699>,<-0.49662,13.52172,-0.87672>,<-0.48288,13.51384,-0.88255>,
            
    /*3*/ <-0.41287,14.10227,-1.22661>,<-0.4204,14.101,-1.23022>,<-0.41341,14.09793,-1.23383>,
            
    /*4*/ <-0.43957,14.66675,-1.61184>

    /* stem 0.17.6*/ 
    /*0*/ <-0.67642,13.21396,-0.49145>,
    /*1*/ <-0.68454,13.21408,-0.4799>,<-0.68235,13.21365,-0.50425>,<-0.66236,13.21414,-0.49019>,
            
    /*2*/ <-0.68956,13.87902,-0.49628>,<-0.6881,13.87873,-0.51251>,<-0.67477,13.87906,-0.50314>,
            
    /*3*/ <-0.73673,14.52682,-0.64511>,<-0.73587,14.52512,-0.65303>,<-0.7293,14.52665,-0.64846>,
            
    /*4*/ <-0.83022,15.15832,-0.83208>

    /* stem 0.17.7*/ 
    /*0*/ <-0.77808,13.43161,-0.56531>,
    /*1*/ <-0.78923,13.42503,-0.56935>,<-0.77052,13.43833,-0.57434>,<-0.77449,13.43147,-0.55223>,
            
    /*2*/ <-1.13624,13.95892,-0.46623>,<-1.12376,13.96779,-0.46956>,<-1.12642,13.96322,-0.45481>,
            
    /*3*/ <-1.43954,14.52797,-0.4372>,<-1.43286,14.53168,-0.43893>,<-1.43475,14.53029,-0.43146>,
            
    /*4*/ <-1.71816,15.10424,-0.51665>

    /* stem 0.17.8*/ 
    /*0*/ <-0.8506,13.6178,-0.618>,
    /*1*/ <-0.84816,13.61544,-0.63066>,<-0.84422,13.62741,-0.61177>,<-0.85943,13.61054,-0.61156>,
            
    /*2*/ <-1.30074,14.02172,-0.78915>,<-1.29811,14.02969,-0.77655>,<-1.30825,14.01845,-0.77642>,
            
    /*3*/ <-1.62603,14.53862,-0.93784>,<-1.62405,14.5418,-0.93126>,<-1.63039,14.53769,-0.93172>,
            
    /*4*/ <-1.95969,15.06828,-1.00029>

    /* stem 0.17.9*/ 
    /*0*/ <-0.91657,13.80683,-0.66593>,
    /*1*/ <-0.90458,13.81068,-0.66728>,<-0.92378,13.8117,-0.65672>,<-0.92135,13.79812,-0.67378>,
            
    /*2*/ <-1.09336,14.25288,-1.04594>,<-1.10616,14.25357,-1.03891>,<-1.10454,14.24452,-1.05028>,
            
    /*3*/ <-1.23536,14.81393,-1.24245>,<-1.24157,14.81376,-1.23858>,<-1.24149,14.81136,-1.24549>,
            
    /*4*/ <-1.3471,15.36882,-1.47467>

    /* stem 0.17.10*/ 
    /*0*/ <-0.97167,13.96473,-0.70596>,
    /*1*/ <-0.96873,13.96862,-0.69467>,<-0.98344,13.96458,-0.70954>,<-0.96285,13.96099,-0.71367>,
            
    /*2*/ <-0.9138,14.52581,-0.90549>,<-0.92361,14.52312,-0.9154>,<-0.90989,14.52073,-0.91815>,
            
    /*3*/ <-1.02666,15.08756,-1.07779>,<-1.03152,15.08521,-1.0824>,<-1.02476,15.08595,-1.08443>,
            
    /*4*/ <-1.08176,15.64915,-1.27675>

    /* stem 0.17.11*/ 
    /*0*/ <-1.04651,14.17918,-0.76033>,
    /*1*/ <-1.05641,14.17728,-0.7542>,<-1.04709,14.18159,-0.77187>,<-1.03603,14.17867,-0.75493>,
            
    /*2*/ <-1.08761,14.74392,-0.63646>,<-1.08139,14.74679,-0.64824>,<-1.07403,14.74485,-0.63695>,
            
    /*3*/ <-1.22808,15.30514,-0.66772>,<-1.22483,15.30567,-0.67368>,<-1.22148,15.30683,-0.66787>,
            
    /*4*/ <-1.36049,15.83811,-0.85474>

    /* stem 0.17.12*/ 
    /*0*/ <-1.11901,14.38692,-0.81301>,
    /*1*/ <-1.126,14.38252,-0.82075>,<-1.11148,14.39483,-0.81601>,<-1.11955,14.38342,-0.80225>,
            
    /*2*/ <-1.5003,14.78512,-0.70644>,<-1.49063,14.79333,-0.70328>,<-1.49601,14.78572,-0.69411>,
            
    /*3*/ <-1.81204,15.23273,-0.56926>,<-1.80662,15.23612,-0.56787>,<-1.80958,15.23263,-0.5632>,
            
    /*4*/ <-1.98298,15.76721,-0.54167>

    /* stem 0.17.13*/ 
    /*0*/ <-1.1879,14.58434,-0.86306>,
    /*1*/ <-1.18179,14.58419,-0.87206>,<-1.18592,14.59166,-0.85527>,<-1.19599,14.57716,-0.86186>,
            
    /*2*/ <-1.52775,14.9317,-1.10827>,<-1.5305,14.93668,-1.09708>,<-1.53721,14.92702,-1.10147>,
            
    /*3*/ <-1.8064,15.34404,-1.32789>,<-1.80761,15.34632,-1.32217>,<-1.81157,15.34223,-1.32482>,
            
    /*4*/ <-2.02206,15.819,-1.4837>

    /* stem 0.17.14*/ 
    /*0*/ <-1.27953,14.84691,-0.92963>,
    /*1*/ <-1.27059,14.85084,-0.92643>,<-1.2884,14.85066,-0.92601>,<-1.27961,14.83922,-0.93646>,
            
    /*2*/ <-1.28617,15.19581,-1.31709>,<-1.29804,15.19569,-1.31681>,<-1.29218,15.18807,-1.32378>,
            
    /*3*/ <-1.32432,15.60516,-1.6372>,<-1.33025,15.60491,-1.63687>,<-1.32738,15.60188,-1.64109>,
            
    /*4*/ <-1.44891,16.02714,-1.91767>

    /* stem 0.17.15*/ 
    /*0*/ <-1.32747,14.98429,-0.96447>,
    /*1*/ <-1.32917,14.98614,-0.95481>,<-1.33499,14.9847,-0.97102>,<-1.31826,14.98203,-0.96757>,
            
    /*2*/ <-1.23353,15.47984,-1.03629>,<-1.23741,15.47888,-1.0471>,<-1.22626,15.4771,-1.04479>,
            
    /*3*/ <-1.2755,15.985,-1.0778>,<-1.27748,15.98443,-1.08318>,<-1.27182,15.98498,-1.08224>,
            
    /*4*/ <-1.33657,16.47549,-1.20331>

    /* stem 0.17.16*/ 
    /*0*/ <-1.41012,15.22111,-1.02451>,
    /*1*/ <-1.41907,15.21829,-1.02335>,<-1.4074,15.22494,-1.03272>,<-1.40389,15.22012,-1.01747>,
            
    /*2*/ <-1.53444,15.66298,-0.85641>,<-1.52666,15.66741,-0.86266>,<-1.52432,15.6642,-0.85249>,
            
    /*3*/ <-1.64968,16.1064,-0.68608>,<-1.6458,16.10864,-0.6892>,<-1.64461,16.10701,-0.68413>,
            
    /*4*/ <-1.70816,16.57338,-0.55248>

    /* stem 0.17.17*/ 
    /*0*/ <-1.48716,15.49142,-1.08048>,
    /*1*/ <-1.48966,15.48936,-1.08875>,<-1.48045,15.49709,-1.07915>,<-1.49136,15.48781,-1.07354>,
            
    /*2*/ <-1.78995,15.84545,-1.08352>,<-1.78382,15.85061,-1.07712>,<-1.79109,15.84442,-1.07337>,
            
    /*3*/ <-2.06787,16.2188,-1.09972>,<-2.06474,16.22131,-1.09652>,<-2.0686,16.21851,-1.09465>,
            
    /*4*/ <-2.35557,16.58322,-1.13561>

    /* stem 0.17.18*/ 
    /*0*/ <-1.53474,15.68786,-1.11505>,
    /*1*/ <-1.52758,15.68881,-1.1195>,<-1.53615,15.69267,-1.10821>,<-1.54048,15.6821,-1.11744>,
            
    /*2*/ <-1.73128,15.99655,-1.376>,<-1.73698,15.99912,-1.36847>,<-1.73988,15.99208,-1.37463>,
            
    /*3*/ <-1.90329,16.32984,-1.62306>,<-1.90617,16.33117,-1.61932>,<-1.90776,16.32791,-1.62261>,
            
    /*4*/ <-2.07589,16.66215,-1.8716>

    /* stem 0.17.19*/ 
    /*0*/ <-1.58765,15.90633,-1.1535>,
    /*1*/ <-1.58234,15.9086,-1.14791>,<-1.59552,15.90723,-1.15216>,<-1.58509,15.90317,-1.16042>,
            
    /*2*/ <-1.56885,16.30179,-1.32439>,<-1.57764,16.30088,-1.32721>,<-1.57068,16.29817,-1.33273>,
            
    /*3*/ <-1.57742,16.71981,-1.42754>,<-1.58182,16.7194,-1.42894>,<-1.57835,16.71873,-1.43195>,
            
    /*4*/ <-1.59549,17.1399,-1.52307>

    /* stem 0.17.20*/ 
    /*0*/ <-1.64504,16.14328,-1.19519>,
    /*1*/ <-1.64917,16.1434,-1.18886>,<-1.64836,16.14438,-1.20189>,<-1.63759,16.14208,-1.19482>,
            
    /*2*/ <-1.58386,16.54829,-1.15651>,<-1.58332,16.54894,-1.1652>,<-1.57614,16.54741,-1.16048>,
            
    /*3*/ <-1.55765,16.95856,-1.17854>,<-1.55742,16.95833,-1.18289>,<-1.55377,16.95822,-1.18051>,
            
    /*4*/ <-1.55014,17.36839,-1.21359>

    /* stem 0.17.21*/ 
    /*0*/ <-1.70517,16.39156,-1.23888>,
    /*1*/ <-1.71158,16.38961,-1.24113>,<-1.70052,16.39431,-1.24343>,<-1.70342,16.39075,-1.23208>,
            
    /*2*/ <-1.84544,16.74819,-1.16289>,<-1.83806,16.75133,-1.16442>,<-1.83999,16.74895,-1.15686>,
            
    /*3*/ <-1.96116,17.1198,-1.12836>,<-1.95737,17.12108,-1.12916>,<-1.95851,17.12036,-1.12531>,
            
    /*4*/ <-2.11372,17.47905,-1.12012>

    /* stem 0.17.22*/ 
    /*0*/ <-1.77332,16.67292,-1.28839>,
    /*1*/ <-1.77251,16.67211,-1.29413>,<-1.7704,16.67715,-1.2856>,<-1.77705,16.66951,-1.28545>,
            
    /*2*/ <-2.04503,16.90802,-1.36405>,<-2.04362,16.91139,-1.35835>,<-2.04806,16.90629,-1.35826>,
            
    /*3*/ <-2.26838,17.1961,-1.41019>,<-2.26733,17.1974,-1.40725>,<-2.26999,17.19533,-1.40732>,
            
    /*4*/ <-2.44646,17.51142,-1.47026>

    /* stem 0.17.23*/ 
    /*0*/ <-1.83745,16.93771,-1.33499>,
    /*1*/ <-1.83442,16.93837,-1.33537>,<-1.83919,16.9394,-1.333>,<-1.83876,16.93535,-1.33659>,
            
    /*2*/ <-1.91569,17.15599,-1.59052>,<-1.91888,17.15667,-1.58893>,<-1.91859,17.15398,-1.59133>,
            
    /*3*/ <-1.9916,17.42282,-1.7956>,<-1.99316,17.42307,-1.79472>,<-1.9931,17.42198,-1.79616>,
            
    /*4*/ <-2.03406,17.69381,-2.00478>

    /* stem 0.17.24*/ 
    /*0*/ <-1.86805,17.06403,-1.35722>,
    /*1*/ <-1.8675,17.06446,-1.35552>,<-1.86981,17.06423,-1.35769>,<-1.86684,17.0634,-1.35844>,
            
    /*2*/ <-1.80527,17.37749,-1.45568>,<-1.80681,17.37734,-1.45713>,<-1.80482,17.37678,-1.45763>,
            
    /*3*/ <-1.79239,17.70034,-1.54226>,<-1.79317,17.70018,-1.54296>,<-1.79216,17.70006,-1.54325>,
            
    /*4*/ <-1.83927,18.02109,-1.6249>

    /* stem 0.18*/ 
    /*0*/ <0,12.23572,0>,
    /*1*/ <0.0528,12.23572,0.02241>,<-0.00214,12.26299,0.05042>,<-0.05413,12.25257,0.00875>,
            <-0.03131,12.21886,-0.04501>,<0.03478,12.20844,-0.03656>,
    /*2*/ <0.41731,13.92955,-0.88525>,<0.38068,13.94773,-0.86658>,<0.34602,13.94079,-0.89436>,
            <0.36124,13.91831,-0.9302>,<0.40529,13.91136,-0.92457>,
    /*3*/ <0.7024,15.72546,-1.60582>,<0.68372,15.73266,-1.59561>,<0.66653,15.72991,-1.60984>,
            <0.67459,15.72101,-1.62883>,<0.69676,15.71826,-1.62635>,
    /*4*/ <0.90398,17.59916,-2.12965>

    /* stem 0.18.0*/ 
    /*0*/ <0.04088,12.41693,-0.09631>,
    /*1*/ <0.0388,12.42519,-0.08166>,<0.03265,12.42211,-0.11019>,<0.05119,12.40351,-0.09708>,
            
    /*2*/ <0.62556,12.88252,-0.26265>,<0.62145,12.88046,-0.28167>,<0.63382,12.86806,-0.27293>,
            
    /*3*/ <1.13067,13.4291,-0.43871>,<1.12858,13.42806,-0.44821>,<1.13573,13.42275,-0.44416>,
            
    /*4*/ <1.49994,14.08005,-0.59723>

    /* stem 0.18.1*/ 
    /*0*/ <0.09344,12.64993,-0.22013>,
    /*1*/ <0.07751,12.65351,-0.22016>,<0.10192,12.6503,-0.23409>,<0.1009,12.64597,-0.20615>,
            
    /*2*/ <0.24369,13.36933,-0.10322>,<0.25996,13.36719,-0.11251>,<0.25928,13.36431,-0.09388>,
            
    /*3*/ <0.40743,14.09433,-0.0692>,<0.41546,14.09279,-0.07389>,<0.41535,14.09238,-0.06447>,
            
    /*4*/ <0.61138,14.78483,-0.25842>

    /* stem 0.18.2*/ 
    /*0*/ <0.12896,12.80736,-0.3038>,
    /*1*/ <0.12392,12.80118,-0.31758>,<0.14427,12.8113,-0.30197>,<0.11868,12.80961,-0.29186>,
            
    /*2*/ <-0.01732,13.47395,-0.56189>,<-0.00376,13.4807,-0.55149>,<-0.02082,13.47957,-0.54475>,
            
    /*3*/ <-0.08677,14.15198,-0.82253>,<-0.0799,14.15483,-0.81712>,<-0.08857,14.15511,-0.81407>,
            
    /*4*/ <-0.07809,14.84344,-1.05627>

    /* stem 0.18.3*/ 
    /*0*/ <0.1935,13.09346,-0.45585>,
    /*1*/ <0.20614,13.08748,-0.46173>,<0.19423,13.10622,-0.44767>,<0.18012,13.08668,-0.45815>,
            
    /*2*/ <0.10981,13.46952,-1.04411>,<0.10187,13.48201,-1.03474>,<0.09246,13.46898,-1.04172>,
            
    /*3*/ <0.04772,14.00021,-1.50289>,<0.04392,14.00516,-1.49674>,<0.03901,14.00009,-1.50193>,
            
    /*4*/ <0.17567,14.5991,-1.84718>

    /* stem 0.18.4*/ 
    /*0*/ <0.21882,13.20573,-0.51552>,
    /*1*/ <0.22911,13.20888,-0.50524>,<0.20715,13.21477,-0.51737>,<0.22021,13.19355,-0.52395>,
            
    /*2*/ <0.5826,13.57248,-0.97721>,<0.56796,13.57641,-0.9853>,<0.57667,13.56226,-0.98968>,
            
    /*3*/ <0.92221,14.07539,-1.30785>,<0.91503,14.07755,-1.31205>,<0.92039,14.07173,-1.3154>,
            
    /*4*/ <1.21029,14.63542,-1.59632>

    /* stem 0.18.5*/ 
    /*0*/ <0.27172,13.44021,-0.64014>,
    /*1*/ <0.26426,13.4472,-0.63016>,<0.26905,13.44252,-0.65397>,<0.28185,13.43092,-0.63627>,
            
    /*2*/ <0.72139,13.93845,-0.63907>,<0.72458,13.93533,-0.65495>,<0.73312,13.9276,-0.64315>,
            
    /*3*/ <0.99835,14.54437,-0.70571>,<0.99987,14.54285,-0.71367>,<1.00549,14.54091,-0.70795>,
            
    /*4*/ <1.21252,15.17238,-0.80515>

    /* stem 0.18.6*/ 
    /*0*/ <0.30838,13.60273,-0.72651>,
    /*1*/ <0.29554,13.60285,-0.73173>,<0.31925,13.60063,-0.73486>,<0.31036,13.6047,-0.71292>,
            
    /*2*/ <0.34695,14.24936,-0.83088>,<0.36275,14.24788,-0.83296>,<0.35683,14.2506,-0.81834>,
            
    /*3*/ <0.32378,14.88747,-0.97622>,<0.33169,14.88752,-0.97748>,<0.32879,14.88908,-0.97018>,
            
    /*4*/ <0.30896,15.52088,-1.14654>

    /* stem 0.18.7*/ 
    /*0*/ <0.35141,13.79346,-0.82787>,
    /*1*/ <0.35282,13.78696,-0.83948>,<0.3613,13.80122,-0.82329>,<0.3401,13.79219,-0.82082>,
            
    /*2*/ <0.10338,14.28889,-1.14523>,<0.10903,14.2984,-1.13444>,<0.09489,14.29237,-1.1328>,
            
    /*3*/ <-0.08248,14.81714,-1.45206>,<-0.0795,14.82151,-1.44644>,<-0.08685,14.81917,-1.44602>,
            
    /*4*/ <-0.26447,15.36855,-1.71827>

    /* stem 0.18.8*/ 
    /*0*/ <0.39325,13.99565,-0.92644>,
    /*1*/ <0.40592,13.99334,-0.9269>,<0.38884,14.00619,-0.92048>,<0.385,13.98744,-0.93195>,
            
    /*2*/ <0.44047,14.31122,-1.45824>,<0.42908,14.31979,-1.45396>,<0.42652,14.30729,-1.46161>,
            
    /*3*/ <0.41682,14.76331,-1.88378>,<0.41109,14.76643,-1.88021>,<0.40985,14.76137,-1.88552>,
            
    /*4*/ <0.41745,15.28479,-2.21931>

    /* stem 0.18.9*/ 
    /*0*/ <0.42677,14.19454,-1.00541>,
    /*1*/ <0.43071,14.1983,-0.99425>,<0.41727,14.20033,-1.01093>,<0.43234,14.18498,-1.01106>,
            
    /*2*/ <0.81474,14.57777,-1.26239>,<0.80578,14.57912,-1.2735>,<0.81583,14.56889,-1.27359>,
            
    /*3*/ <1.10716,15.03412,-1.52627>,<1.10226,15.0343,-1.53151>,<1.10809,15.03017,-1.53218>,
            
    /*4*/ <1.32833,15.52627,-1.79534>

    /* stem 0.18.10*/ 
    /*0*/ <0.46388,14.4147,-1.09283>,
    /*1*/ <0.45387,14.41846,-1.08759>,<0.46468,14.41452,-1.10471>,<0.47309,14.41111,-1.08619>,
            
    /*2*/ <0.6654,14.96239,-1.08358>,<0.67261,14.95976,-1.09499>,<0.67821,14.95749,-1.08264>,
            
    /*3*/ <0.81772,15.52027,-1.1603>,<0.82118,15.51858,-1.16599>,<0.82436,15.51855,-1.1599>,
            
    /*4*/ <0.92956,16.07588,-1.29943>

    /* stem 0.18.11*/ 
    /*0*/ <0.50347,14.64959,-1.1861>,
    /*1*/ <0.49557,14.64775,-1.19406>,<0.5137,14.65357,-1.18905>,<0.50114,14.64743,-1.17518>,
            
    /*2*/ <0.31119,15.17565,-1.12715>,<0.32328,15.17953,-1.12381>,<0.31491,15.17543,-1.11457>,
            
    /*3*/ <0.17386,15.72115,-1.14577>,<0.18,15.72279,-1.14413>,<0.17549,15.72182,-1.13945>,
            
    /*4*/ <0.00962,16.25766,-1.1909>

    /* stem 0.18.12*/ 
    /*0*/ <0.53967,14.86438,-1.27138>,
    /*1*/ <0.54541,14.86015,-1.2796>,<0.54411,14.87199,-1.265>,<0.52949,14.861,-1.26956>,
            
    /*2*/ <0.35501,15.24994,-1.60858>,<0.35414,15.25784,-1.59884>,<0.3444,15.25051,-1.60188>,
            
    /*3*/ <0.24378,15.70994,-1.87856>,<0.24359,15.71311,-1.87314>,<0.23835,15.7105,-1.87543>,
            
    /*4*/ <0.17521,16.20264,-2.10026>

    /* stem 0.18.13*/ 
    /*0*/ <0.56964,15.04218,-1.34198>,
    /*1*/ <0.57941,15.04204,-1.3382>,<0.56258,15.04884,-1.33802>,<0.56692,15.03567,-1.34973>,
            
    /*2*/ <0.71942,15.40597,-1.6956>,<0.70821,15.41051,-1.69548>,<0.7111,15.40173,-1.70329>,
            
    /*3*/ <0.86719,15.81198,-2.00016>,<0.86156,15.81417,-2.00003>,<0.8632,15.81031,-2.00438>,
            
    /*4*/ <0.96289,16.28298,-2.22134>

    /* stem 0.18.14*/ 
    /*0*/ <0.59946,15.2191,-1.41223>,
    /*1*/ <0.59837,15.22296,-1.40298>,<0.59312,15.2218,-1.4196>,<0.60689,15.21255,-1.41412>,
            
    /*2*/ <0.90975,15.61057,-1.53151>,<0.90625,15.60979,-1.54259>,<0.91543,15.60363,-1.53893>,
            
    /*3*/ <1.16156,16.04802,-1.6217>,<1.15993,16.04784,-1.62729>,<1.16491,16.04532,-1.62563>,
            
    /*4*/ <1.38469,16.50457,-1.69457>

    /* stem 0.18.15*/ 
    /*0*/ <0.63915,15.45458,-1.50573>,
    /*1*/ <0.62976,15.45635,-1.50524>,<0.64346,15.45401,-1.51425>,<0.64421,15.45337,-1.49771>,
            
    /*2*/ <0.72539,15.9398,-1.49092>,<0.73452,15.93823,-1.49692>,<0.73502,15.93781,-1.4859>,
            
    /*3*/ <0.88899,16.40584,-1.48852>,<0.8934,16.40434,-1.49149>,<0.89362,16.40424,-1.48597>,
            
    /*4*/ <1.04464,16.84979,-1.63616>

    /* stem 0.18.16*/ 
    /*0*/ <0.67406,15.66175,-1.58799>,
    /*1*/ <0.67103,15.65903,-1.59614>,<0.68264,15.66469,-1.58708>,<0.66853,15.66153,-1.58076>,
            
    /*2*/ <0.52994,16.10303,-1.6886>,<0.53767,16.10681,-1.68256>,<0.52827,16.1047,-1.67835>,
            
    /*3*/ <0.35897,16.54128,-1.75524>,<0.36281,16.54327,-1.75224>,<0.35825,16.54182,-1.75006>,
            
    /*4*/ <0.20469,16.98482,-1.82657>

    /* stem 0.18.17*/ 
    /*0*/ <0.69173,15.7847,-1.62962>,
    /*1*/ <0.6992,15.78265,-1.6339>,<0.69206,15.78956,-1.62223>,<0.68393,15.7819,-1.63273>,
            
    /*2*/ <0.65826,16.17095,-1.88546>,<0.6535,16.17555,-1.87767>,<0.64809,16.17045,-1.88467>,
            
    /*3*/ <0.56267,16.59422,-2.05442>,<0.56042,16.5955,-2.05002>,<0.55767,16.59338,-2.05377>,
            
    /*4*/ <0.505,17.03937,-2.17373>

    /* stem 0.18.18*/ 
    /*0*/ <0.72866,16.10042,-1.71662>,
    /*1*/ <0.73441,16.10134,-1.71085>,<0.72172,16.10477,-1.71622>,<0.72986,16.09516,-1.7228>,
            
    /*2*/ <0.91837,16.42006,-1.94858>,<0.9099,16.42235,-1.95216>,<0.91533,16.41594,-1.95654>,
            
    /*3*/ <1.01653,16.77002,-2.19457>,<1.01198,16.77043,-2.19585>,<1.01494,16.76778,-2.19843>,
            
    /*4*/ <1.09314,17.12104,-2.44548>

    /* stem 0.18.19*/ 
    /*0*/ <0.75795,16.35078,-1.78562>,
    /*1*/ <0.75388,16.35295,-1.77946>,<0.75552,16.35263,-1.79268>,<0.76445,16.34676,-1.78471>,
            
    /*2*/ <0.97279,16.70774,-1.76332>,<0.97389,16.70752,-1.77214>,<0.97984,16.7036,-1.76683>,
            
    /*3*/ <1.09253,17.10186,-1.70516>,<1.09327,17.10231,-1.70952>,<1.09653,17.10092,-1.70684>,
            
    /*4*/ <1.16737,17.51098,-1.67307>

    /* stem 0.18.20*/ 
    /*0*/ <0.78347,16.56892,-1.84573>,
    /*1*/ <0.77665,16.56903,-1.84823>,<0.78896,16.57079,-1.8501>,<0.78479,16.56694,-1.83887>,
            
    /*2*/ <0.74232,16.94884,-1.73095>,<0.75053,16.95001,-1.7322>,<0.74775,16.94745,-1.72471>,
            
    /*3*/ <0.66754,17.33821,-1.69427>,<0.6716,17.33907,-1.69488>,<0.67015,17.33842,-1.691>,
            
    /*4*/ <0.61,17.73298,-1.70015>

    /* stem 0.18.21*/ 
    /*0*/ <0.80606,16.76206,-1.89896>,
    /*1*/ <0.80679,16.76016,-1.90553>,<0.81121,16.76527,-1.89571>,<0.80018,16.76074,-1.89563>,
            
    /*2*/ <0.66675,17.09879,-2.0164>,<0.6697,17.1022,-2.00985>,<0.66234,17.09918,-2.0098>,
            
    /*3*/ <0.56164,17.45422,-2.11299>,<0.56321,17.45562,-2.10962>,<0.55941,17.45448,-2.10971>,
            
    /*4*/ <0.539,17.81841,-2.2284>

    /* stem 0.18.22*/ 
    /*0*/ <0.83446,17.00484,-1.96586>,
    /*1*/ <0.84044,17.004,-1.96639>,<0.83229,17.00876,-1.96177>,<0.83064,17.00177,-1.96944>,
            
    /*2*/ <0.85454,17.27017,-2.21218>,<0.8491,17.27334,-2.20911>,<0.848,17.26868,-2.21422>,
            
    /*3*/ <0.86985,17.57127,-2.41373>,<0.86712,17.5726,-2.41199>,<0.8666,17.57069,-2.41488>,
            
    /*4*/ <0.88922,17.89694,-2.57197>

    /* stem 0.18.23*/ 
    /*0*/ <0.86513,17.26704,-2.03812>,
    /*1*/ <0.86628,17.26777,-2.03502>,<0.86245,17.2687,-2.03937>,<0.86667,17.26466,-2.03998>,
            
    /*2*/ <1.07324,17.50379,-2.16737>,<1.07069,17.50442,-2.17027>,<1.0735,17.50172,-2.17068>,
            
    /*3*/ <1.26026,17.77113,-2.26467>,<1.25901,17.77148,-2.26614>,<1.26055,17.7703,-2.26642>,
            
    /*4*/ <1.41298,18.0624,-2.35353>

    /* stem 0.18.24*/ 
    /*0*/ <0.89322,17.50716,-2.10429>,
    /*1*/ <0.89244,17.50738,-2.10383>,<0.89323,17.5072,-2.10523>,<0.89399,17.50689,-2.10382>,
            
    /*2*/ <0.98829,17.81293,-2.08796>,<0.98882,17.81281,-2.0889>,<0.98932,17.8126,-2.08796>,
            
    /*3*/ <1.06549,18.12391,-2.09913>,<1.06575,18.12383,-2.0996>,<1.06601,18.12378,-2.09913>,
            
    /*4*/ <1.1128,18.43945,-2.1305>

    /* stem 0.19*/ 
    /*0*/ <0,12.83676,0>,
    /*1*/ <-0.0096,12.83676,0.05442>,<-0.04779,12.86304,0.00891>,<-0.01994,12.853,-0.04892>,
            <0.03547,12.82052,-0.03915>,<0.04186,12.81048,0.02472>,
    /*2*/ <0.92947,14.48273,0.2013>,<0.904,14.50025,0.17096>,<0.92257,14.49356,0.13241>,
            <0.95951,14.47191,0.13892>,<0.96377,14.46521,0.1815>,
    /*3*/ <1.67402,16.2279,0.31388>,<1.66039,16.23484,0.29855>,<1.67002,16.23219,0.27934>,
            <1.6896,16.22361,0.28279>,<1.69208,16.22096,0.30414>,
    /*4*/ <2.21404,18.04866,0.3904>

    /* stem 0.19.0*/ 
    /*0*/ <0.12926,13.06409,0.02279>,
    /*1*/ <0.11517,13.07198,0.02401>,<0.14023,13.06876,0.01184>,<0.13237,13.05153,0.03253>,
            
    /*2*/ <0.41956,13.52821,0.51969>,<0.43627,13.52607,0.51158>,<0.43103,13.51458,0.52537>,
            
    /*3*/ <0.71591,14.11507,0.85588>,<0.724,14.1136,0.85144>,<0.72245,14.10962,0.85975>,
            
    /*4*/ <1.0441,14.75311,1.0343>

    /* stem 0.19.1*/ 
    /*0*/ <0.24448,13.26674,0.04311>,
    /*1*/ <0.24107,13.27018,0.02821>,<0.25935,13.26711,0.04802>,<0.23303,13.26294,0.05309>,
            
    /*2*/ <0.16638,13.96326,0.21054>,<0.17856,13.96121,0.22374>,<0.16101,13.95843,0.22712>,
            
    /*3*/ <0.20259,14.66469,0.37147>,<0.2087,14.66296,0.3779>,<0.19989,14.66295,0.37992>,
            
    /*4*/ <0.31451,15.36316,0.50835>

    /* stem 0.19.2*/ 
    /*0*/ <0.31904,13.39788,0.05626>,
    /*1*/ <0.33087,13.39192,0.04855>,<0.32084,13.40236,0.07079>,<0.30541,13.39935,0.04942>,
            
    /*2*/ <0.50819,14.04168,-0.17111>,<0.50151,14.04863,-0.15628>,<0.49121,14.04663,-0.17053>,
            
    /*3*/ <0.69875,14.69502,-0.36798>,<0.69536,14.69832,-0.3605>,<0.6903,14.69762,-0.36772>,
            
    /*4*/ <0.99803,15.33288,-0.43974>

    /* stem 0.19.3*/ 
    /*0*/ <0.44733,13.62352,0.07888>,
    /*1*/ <0.45566,13.61771,0.08956>,<0.43825,13.63472,0.08189>,<0.44809,13.61812,0.06519>,
            
    /*2*/ <0.95437,14.06602,-0.06238>,<0.94276,14.07736,-0.06749>,<0.94932,14.06629,-0.07863>,
            
    /*3*/ <1.36568,14.60731,-0.17033>,<1.35898,14.612,-0.17266>,<1.3633,14.60756,-0.17849>,
            
    /*4*/ <1.64842,15.22445,-0.28453>

    /* stem 0.19.4*/ 
    /*0*/ <0.55034,13.80468,0.09704>,
    /*1*/ <0.54295,13.8077,0.10887>,<0.55089,13.81414,0.08636>,<0.55719,13.79221,0.09589>,
            
    /*2*/ <1.09326,14.08221,0.3769>,<1.09855,14.08651,0.3619>,<1.10275,14.07189,0.36825>,
            
    /*3*/ <1.60768,14.50666,0.46168>,<1.60834,14.50756,0.45351>,<1.61259,14.50165,0.45736>,
            
    /*4*/ <2.09094,14.96995,0.50605>

    /* stem 0.19.5*/ 
    /*0*/ <0.68544,14.04229,0.12086>,
    /*1*/ <0.67453,14.04897,0.11605>,<0.69715,14.04235,0.11381>,<0.68464,14.03554,0.13272>,
            
    /*2*/ <0.86589,14.58101,0.43445>,<0.88097,14.5766,0.43296>,<0.87263,14.57206,0.44556>,
            
    /*3*/ <1.07177,15.16782,0.61664>,<1.07927,15.1655,0.61579>,<1.07563,15.16462,0.62274>,
            
    /*4*/ <1.34141,15.7579,0.619>

    /* stem 0.19.6*/ 
    /*0*/ <0.79719,14.23884,0.14057>,
    /*1*/ <0.79928,14.23895,0.12756>,<0.80737,14.23971,0.14888>,<0.78492,14.23786,0.14526>,
            
    /*2*/ <0.7472,14.86754,0.12919>,<0.75259,14.86804,0.1434>,<0.73763,14.86681,0.14099>,
            
    /*3*/ <0.64857,15.49047,0.12245>,<0.65123,15.49101,0.12955>,<0.64382,15.48983,0.12835>,
            
    /*4*/ <0.74228,16.11073,0.06247>

    /* stem 0.19.7*/ 
    /*0*/ <0.89981,14.41933,0.15866>,
    /*1*/ <0.91088,14.41315,0.15749>,<0.89765,14.42661,0.16886>,<0.89092,14.41821,0.14964>,
            
    /*2*/ <1.14547,14.89838,-0.13679>,<1.13665,14.90735,-0.12921>,<1.13217,14.90175,-0.14203>,
            
    /*3*/ <1.37047,15.42409,-0.36188>,<1.36575,15.42792,-0.35776>,<1.36385,15.42583,-0.36454>,
            
    /*4*/ <1.62754,15.97993,-0.40746>

    /* stem 0.19.8*/ 
    /*0*/ <0.96688,14.55574,0.17049>,
    /*1*/ <0.97005,14.55351,0.18226>,<0.9596,14.56539,0.16775>,<0.97099,14.54832,0.16145>,
            
    /*2*/ <1.45548,14.90253,0.11325>,<1.44852,14.91045,0.10358>,<1.45611,14.89907,0.09938>,
            
    /*3*/ <1.89888,15.30492,0.05047>,<1.89498,15.30854,0.04569>,<1.89939,15.30334,0.04351>,
            
    /*4*/ <2.27358,15.77519,0.06733>

    /* stem 0.19.9*/ 
    /*0*/ <1.08624,14.83672,0.19153>,
    /*1*/ <1.0768,14.84028,0.19753>,<1.08826,14.84089,0.18075>,<1.09366,14.82898,0.19632>,
            
    /*2*/ <1.38689,15.27295,0.42111>,<1.39453,15.27336,0.40992>,<1.39813,15.26542,0.42031>,
            
    /*3*/ <1.65112,15.75956,0.5836>,<1.65478,15.75952,0.5779>,<1.65712,15.7564,0.58345>,
            
    /*4*/ <1.83144,16.30486,0.64047>

    /* stem 0.19.10*/ 
    /*0*/ <1.167,15.02683,0.20577>,
    /*1*/ <1.16002,15.03041,0.19763>,<1.17812,15.02872,0.20492>,<1.16287,15.02136,0.21477>,
            
    /*2*/ <1.09973,15.51766,0.46865>,<1.1118,15.51654,0.47351>,<1.10164,15.51163,0.48007>,
            
    /*3*/ <1.08848,16.03152,0.69255>,<1.09454,16.0307,0.69485>,<1.0894,16.02899,0.6985>,
            
    /*4*/ <1.1644,16.54598,0.90327>

    /* stem 0.19.11*/ 
    /*0*/ <1.24084,15.20066,0.21879>,
    /*1*/ <1.24659,15.1989,0.20969>,<1.24596,15.20349,0.22801>,<1.22999,15.19958,0.21869>,
            
    /*2*/ <1.19363,15.726,0.07892>,<1.1932,15.72907,0.09114>,<1.18256,15.72646,0.08493>,
            
    /*3*/ <1.27877,16.26461,0.05355>,<1.27851,16.26498,0.05983>,<1.27326,16.26565,0.05641>,
            
    /*4*/ <1.46556,16.77631,0.02903>

    /* stem 0.19.12*/ 
    /*0*/ <1.33095,15.41276,0.23468>,
    /*1*/ <1.33986,15.40871,0.23828>,<1.32537,15.41923,0.24067>,<1.32761,15.41035,0.2251>,
            
    /*2*/ <1.60283,15.82081,0.04096>,<1.59317,15.82783,0.04256>,<1.59466,15.82191,0.03217>,
            
    /*3*/ <1.87274,16.25675,-0.08031>,<1.8678,16.26009,-0.07944>,<1.86899,16.25783,-0.0849>,
            
    /*4*/ <2.15163,16.70311,-0.10553>

    /* stem 0.19.13*/ 
    /*0*/ <1.46153,15.72015,0.25771>,
    /*1*/ <1.46014,15.72001,0.26736>,<1.45785,15.72742,0.25236>,<1.46659,15.71301,0.25341>,
            
    /*2*/ <1.88284,15.98079,0.32835>,<1.88131,15.98573,0.31835>,<1.88713,15.97612,0.31905>,
            
    /*3*/ <2.2389,16.33066,0.36582>,<2.23752,16.33265,0.36073>,<2.24143,16.32862,0.36122>,
            
    /*4*/ <2.5515,16.72164,0.36752>

    /* stem 0.19.14*/ 
    /*0*/ <1.53824,15.90073,0.27123>,
    /*1*/ <1.52965,15.90431,0.27218>,<1.54375,15.90358,0.26423>,<1.54132,15.89431,0.27729>,
            
    /*2*/ <1.70998,16.25463,0.5544>,<1.71938,16.25414,0.5491>,<1.71776,16.24796,0.55781>,
            
    /*3*/ <1.89765,16.67388,0.70875>,<1.90206,16.67305,0.70575>,<1.90188,16.67125,0.71084>,
            
    /*4*/ <2.03396,17.11183,0.86423>

    /* stem 0.19.15*/ 
    /*0*/ <1.61813,16.0888,0.28532>,
    /*1*/ <1.61571,16.09047,0.27687>,<1.6268,16.08852,0.28751>,<1.61189,16.08743,0.29158>,
            
    /*2*/ <1.60832,16.54883,0.3724>,<1.61571,16.54753,0.37949>,<1.60577,16.54681,0.38221>,
            
    /*3*/ <1.72123,17.00182,0.40442>,<1.72489,17.00069,0.40789>,<1.72009,17.00177,0.40946>,
            
    /*4*/ <1.88106,17.44175,0.41791>

    /* stem 0.19.16*/ 
    /*0*/ <1.71937,16.37085,0.30317>,
    /*1*/ <1.72626,16.36904,0.29882>,<1.71997,16.3747,0.31055>,<1.71186,16.3688,0.30014>,
            
    /*2*/ <1.69877,16.76355,0.0965>,<1.69458,16.76732,0.10432>,<1.68917,16.76339,0.09738>,
            
    /*3*/ <1.62116,17.18264,-0.0324>,<1.61913,17.1836,-0.02813>,<1.61642,17.18198,-0.03177>,
            
    /*4*/ <1.58719,17.61955,-0.10499>

    /* stem 0.19.17*/ 
    /*0*/ <1.77022,16.54331,0.31214>,
    /*1*/ <1.77551,16.54146,0.31784>,<1.7649,16.54917,0.31336>,<1.77024,16.53932,0.3052>,
            
    /*2*/ <2.05032,16.82758,0.15247>,<2.04325,16.83272,0.14948>,<2.04682,16.82616,0.14404>,
            
    /*3*/ <2.27356,17.15099,-0.02316>,<2.26963,17.15307,-0.02438>,<2.27167,17.1501,-0.02727>,
            
    /*4*/ <2.4447,17.5217,-0.15776>

    /* stem 0.19.18*/ 
    /*0*/ <1.8588,16.84378,0.32776>,
    /*1*/ <1.85489,16.84461,0.33398>,<1.85741,16.84809,0.32191>,<1.8641,16.83863,0.32738>,
            
    /*2*/ <2.12709,17.11335,0.46621>,<2.12877,17.11567,0.45816>,<2.13324,17.10936,0.4618>,
            
    /*3*/ <2.34551,17.41263,0.62737>,<2.34653,17.41401,0.62346>,<2.34901,17.41114,0.62543>,
            
    /*4*/ <2.45528,17.75981,0.80296>

    /* stem 0.19.19*/ 
    /*0*/ <1.92298,17.06147,0.33907>,
    /*1*/ <1.91672,17.06344,0.33674>,<1.92871,17.06297,0.33539>,<1.92353,17.058,0.34509>,
            
    /*2*/ <1.95325,17.39763,0.52752>,<1.96124,17.39732,0.52661>,<1.95779,17.39401,0.53308>,
            
    /*3*/ <2.05663,17.72525,0.70621>,<2.06051,17.72447,0.70545>,<2.05882,17.72314,0.70885>,
            
    /*4*/ <2.14932,18.07691,0.83663>

    /* stem 0.19.20*/ 
    /*0*/ <1.97704,17.24482,0.34861>,
    /*1*/ <1.97786,17.24492,0.34204>,<1.98217,17.24604,0.3526>,<1.97109,17.2435,0.35117>,
            
    /*2*/ <1.89523,17.60683,0.33941>,<1.8981,17.60757,0.34645>,<1.89072,17.60588,0.3455>,
            
    /*3*/ <1.90867,17.97691,0.31915>,<1.91014,17.97707,0.32266>,<1.90636,17.97718,0.32217>,
            
    /*4*/ <1.93754,18.34665,0.3402>

    /* stem 0.19.21*/ 
    /*0*/ <2.03006,17.42463,0.35795>,
    /*1*/ <2.03604,17.4229,0.35725>,<2.02809,17.42699,0.36342>,<2.02603,17.42399,0.35319>,
            
    /*2*/ <2.11557,17.75141,0.2448>,<2.11028,17.75414,0.2489>,<2.1089,17.75213,0.24209>,
            
    /*3*/ <2.21641,18.08959,0.19718>,<2.2137,18.09071,0.19929>,<2.21319,18.09036,0.19573>,
            
    /*4*/ <2.26569,18.44266,0.20394>

    /* stem 0.19.22*/ 
    /*0*/ <2.12381,17.74261,0.37448>,
    /*1*/ <2.12475,17.74218,0.3774>,<2.12131,17.74435,0.37391>,<2.12535,17.7413,0.37215>,
            
    /*2*/ <2.31646,18.0093,0.35356>,<2.31416,18.01075,0.35123>,<2.31686,18.00872,0.35006>,
            
    /*3*/ <2.4544,18.30589,0.39258>,<2.45323,18.30659,0.39142>,<2.45479,18.30594,0.39084>,
            
    /*4*/ <2.55123,18.61759,0.43899>

    /* stem 0.19.23*/ 
    /*0*/ <2.17189,17.90571,0.38296>,
    /*1*/ <2.17071,17.90602,0.38374>,<2.17222,17.9065,0.38179>,<2.17275,17.90461,0.38336>,
            
    /*2*/ <2.34032,18.10317,0.56329>,<2.34133,18.10349,0.562>,<2.34168,18.10224,0.56304>,
            
    /*3*/ <2.49912,18.33969,0.70015>,<2.49958,18.33979,0.69946>,<2.49984,18.33927,0.70006>,
            
    /*4*/ <2.59805,18.62939,0.77851>

    /* stem 0.20*/ 
    /*0*/ <0,13.42339,0>,
    /*1*/ <-0.05307,13.42339,0.00278>,<-0.01869,13.44866,-0.04285>,<0.04152,13.439,-0.02927>,
            <0.04435,13.40777,0.02477>,<-0.01411,13.39811,0.04457>,
    /*2*/ <0.01288,15.02059,0.92274>,<0.0358,15.03744,0.89232>,<0.07594,15.03101,0.90137>,
            <0.07783,15.01018,0.93739>,<0.03886,15.00374,0.9506>,
    /*3*/ <0.0688,16.71406,1.6513>,<0.08022,16.72073,1.63521>,<0.1003,16.71818,1.64007>,
            <0.1013,16.70993,1.65917>,<0.08184,16.70738,1.66611>,
    /*4*/ <0.11418,18.48087,2.1786>

    /* stem 0.20.0*/ 
    /*0*/ <0.00495,13.5871,0.09439>,
    /*1*/ <0.00072,13.59476,0.08133>,<0.01949,13.58878,0.10013>,<-0.00537,13.57776,0.10171>,
            
    /*2*/ <-0.22025,14.15149,0.48555>,<-0.20774,14.1475,0.49809>,<-0.22431,14.14016,0.49914>,
            
    /*3*/ <-0.29273,14.78596,0.82204>,<-0.28634,14.78358,0.82803>,<-0.29505,14.78169,0.82971>,
            
    /*4*/ <-0.23067,15.41361,1.17549>

    /* stem 0.20.1*/ 
    /*0*/ <0.01184,13.81514,0.22587>,
    /*1*/ <0.02511,13.81846,0.21942>,<0.01088,13.81368,0.2409>,<-0.00048,13.81329,0.21729>,
            
    /*2*/ <-0.12224,14.50175,0.2792>,<-0.13173,14.49856,0.29352>,<-0.13931,14.4983,0.27778>,
            
    /*3*/ <-0.33423,15.15626,0.42357>,<-0.3387,15.15334,0.43048>,<-0.34257,15.15381,0.42267>,
            
    /*4*/ <-0.47475,15.83403,0.5341>

    /* stem 0.20.2*/ 
    /*0*/ <0.01838,14.03167,0.35071>,
    /*1*/ <0.02805,14.02601,0.36002>,<0.00634,14.03814,0.35575>,<0.02075,14.03085,0.33636>,
            
    /*2*/ <0.35425,14.62417,0.37736>,<0.33978,14.63226,0.37451>,<0.34938,14.6274,0.36158>,
            
    /*3*/ <0.53527,15.27848,0.44961>,<0.52738,15.2809,0.448>,<0.53289,15.28007,0.4417>,
            
    /*4*/ <0.52775,15.94021,0.61478>

    /* stem 0.20.3*/ 
    /*0*/ <0.02298,14.18393,0.4385>,
    /*1*/ <0.01477,14.17834,0.44862>,<0.01839,14.19503,0.43097>,<0.03579,14.17842,0.43591>,
            
    /*2*/ <0.28677,14.59555,0.89301>,<0.28918,14.60668,0.88124>,<0.30078,14.5956,0.88454>,
            
    /*3*/ <0.50427,15.11816,1.24867>,<0.50493,15.1226,1.24183>,<0.51129,15.11816,1.24446>,
            
    /*4*/ <0.60056,15.71214,1.53766>

    /* stem 0.20.4*/ 
    /*0*/ <0.02931,14.39333,0.55923>,
    /*1*/ <0.0167,14.39622,0.55489>,<0.03988,14.40084,0.55496>,<0.03135,14.38294,0.56784>,
            
    /*2*/ <-0.06058,14.79588,1.05925>,<-0.04512,14.79897,1.0593>,<-0.0508,14.78703,1.06788>,
            
    /*3*/ <-0.09436,15.26831,1.50179>,<-0.08657,15.26939,1.50131>,<-0.08953,15.26428,1.50653>,
            
    /*4*/ <-0.03683,15.81337,1.84825>

    /* stem 0.20.5*/ 
    /*0*/ <0.03559,14.60128,0.67913>,
    /*1*/ <0.03773,14.6077,0.66788>,<0.04396,14.60263,0.68915>,<0.02508,14.59351,0.68035>,
            
    /*2*/ <-0.29818,15.09269,0.8858>,<-0.29403,15.08931,0.89998>,<-0.30661,15.08323,0.89411>,
            
    /*3*/ <-0.45847,15.66026,1.10139>,<-0.45621,15.6583,1.10835>,<-0.46337,15.65709,1.10623>,
            
    /*4*/ <-0.53971,16.27155,1.22063>

    /* stem 0.20.6*/ 
    /*0*/ <0.04049,14.76335,0.77257>,
    /*1*/ <0.05318,14.76346,0.77171>,<0.03487,14.76459,0.78391>,<0.03342,14.76201,0.76208>,
            
    /*2*/ <0.03879,15.37311,0.70058>,<0.02658,15.37386,0.70872>,<0.02562,15.37214,0.69416>,
            
    /*3*/ <0.01072,15.97804,0.80375>,<0.00464,15.97712,0.80777>,<0.00412,15.97832,0.80055>,
            
    /*4*/ <0.00408,16.57141,0.96077>

    /* stem 0.20.7*/ 
    /*0*/ <0.04646,14.96104,0.88655>,
    /*1*/ <0.04995,14.95511,0.89666>,<0.03581,14.96705,0.88636>,<0.05362,14.96097,0.87664>,
            
    /*2*/ <0.32263,15.44914,1.08751>,<0.3132,15.4571,1.08064>,<0.32508,15.45305,1.07416>,
            
    /*3*/ <0.47017,16.00661,1.24204>,<0.46492,16.00915,1.23806>,<0.47133,16.00823,1.23526>,
            
    /*4*/ <0.48057,16.59878,1.31375>

    /* stem 0.20.8*/ 
    /*0*/ <0.04993,15.09469,0.9528>,
    /*1*/ <0.0396,15.09255,0.95832>,<0.05042,15.10261,0.94392>,<0.05979,15.08892,0.95618>,
            
    /*2*/ <0.16002,15.51708,1.34044>,<0.16723,15.52379,1.33084>,<0.17348,15.51466,1.33901>,
            
    /*3*/ <0.34379,16.00659,1.60366>,<0.34698,16.00854,1.59789>,<0.35033,16.00477,1.60256>,
            
    /*4*/ <0.37009,16.55861,1.78985>

    /* stem 0.20.9*/ 
    /*0*/ <0.05545,15.33916,1.05811>,
    /*1*/ <0.04775,15.34261,1.05052>,<0.06513,15.34495,1.0594>,<0.05348,15.32993,1.06441>,
            
    /*2*/ <-0.19355,15.66172,1.44583>,<-0.18196,15.66328,1.45175>,<-0.18973,15.65327,1.4551>,
            
    /*3*/ <-0.3913,16.05688,1.79323>,<-0.38539,16.05748,1.79598>,<-0.38971,16.05319,1.7984>,
            
    /*4*/ <-0.62828,16.50438,2.03625>

    /* stem 0.20.10*/ 
    /*0*/ <0.05944,15.51584,1.13422>,
    /*1*/ <0.0656,15.51931,1.12586>,<0.06313,15.51676,1.14449>,<0.04959,15.51147,1.13232>,
            
    /*2*/ <-0.16411,16.01412,1.16636>,<-0.16575,16.01242,1.17878>,<-0.17478,16.0089,1.17066>,
            
    /*3*/ <-0.36625,16.52154,1.1863>,<-0.36718,16.52097,1.19252>,<-0.37175,16.51931,1.18848>,
            
    /*4*/ <-0.43494,17.06334,1.20507>

    /* stem 0.20.11*/ 
    /*0*/ <0.06499,15.76143,1.24001>,
    /*1*/ <0.07467,15.75976,1.24339>,<0.05749,15.76396,1.24676>,<0.0628,15.76058,1.22989>,
            
    /*2*/ <0.18282,16.26964,1.17543>,<0.17137,16.27244,1.17767>,<0.1749,16.27019,1.16642>,
            
    /*3*/ <0.17664,16.79318,1.11513>,<0.17076,16.79329,1.11634>,<0.17265,16.79266,1.11068>,
            
    /*4*/ <0.25144,17.31275,1.10457>

    /* stem 0.20.12*/ 
    /*0*/ <0.06867,15.92443,1.31023>,
    /*1*/ <0.06723,15.92053,1.31935>,<0.06259,15.93166,1.30685>,<0.07618,15.9211,1.30448>,
            
    /*2*/ <0.37766,16.27599,1.51644>,<0.37457,16.28341,1.50811>,<0.38363,16.27637,1.50653>,
            
    /*3*/ <0.67062,16.67369,1.65251>,<0.66858,16.67676,1.64805>,<0.67331,16.6735,1.64738>,
            
    /*4*/ <0.93903,17.09265,1.77139>

    /* stem 0.20.13*/ 
    /*0*/ <0.07567,16.23461,1.44384>,
    /*1*/ <0.06636,16.23448,1.44463>,<0.07976,16.24029,1.43765>,<0.08089,16.22905,1.44924>,
            
    /*2*/ <0.09303,16.58294,1.78006>,<0.10196,16.58682,1.77541>,<0.10272,16.57933,1.78314>,
            
    /*3*/ <0.13276,16.96045,2.08134>,<0.1372,16.96209,2.07876>,<0.13761,16.9587,2.08294>,
            
    /*4*/ <0.24711,17.38127,2.2935>

    /* stem 0.20.14*/ 
    /*0*/ <0.07937,16.39853,1.51445>,
    /*1*/ <0.07663,16.40197,1.50661>,<0.08761,16.40038,1.51754>,<0.07387,16.39324,1.51921>,
            
    /*2*/ <-0.09142,16.77778,1.73365>,<-0.0841,16.77673,1.74093>,<-0.09326,16.77196,1.74204>,
            
    /*3*/ <-0.16465,17.21441,1.88966>,<-0.16093,17.21379,1.89323>,<-0.16585,17.21256,1.89436>,
            
    /*4*/ <-0.17213,17.66676,2.01723>

    /* stem 0.20.15*/ 
    /*0*/ <0.08363,16.58712,1.59569>,
    /*1*/ <0.091,16.58872,1.5916>,<0.08354,16.58638,1.60424>,<0.07634,16.58627,1.59123>,
            
    /*2*/ <0.01318,17.03395,1.63101>,<0.0082,17.03239,1.63944>,<0.0034,17.03232,1.63077>,
            
    /*3*/ <-0.02898,17.45358,1.7995>,<-0.03134,17.45178,1.80346>,<-0.03391,17.45313,1.79945>,
            
    /*4*/ <-0.06506,17.87056,1.97458>

    /* stem 0.20.16*/ 
    /*0*/ <0.08902,16.87534,1.69859>,
    /*1*/ <0.09455,16.87361,1.70408>,<0.08244,16.87936,1.70068>,<0.09006,16.87305,1.69101>,
            
    /*2*/ <0.29217,17.24469,1.61786>,<0.2841,17.24852,1.6156>,<0.28918,17.24432,1.60915>,
            
    /*3*/ <0.4757,17.63038,1.64983>,<0.47171,17.6324,1.64872>,<0.47471,17.63124,1.64541>,
            
    /*4*/ <0.60801,18.03039,1.73161>

    /* stem 0.20.17*/ 
    /*0*/ <0.09184,17.05507,1.75233>,
    /*1*/ <0.08767,17.05331,1.75846>,<0.08948,17.06055,1.74757>,<0.09836,17.05137,1.75095>,
            
    /*2*/ <0.296,17.33585,1.97823>,<0.29721,17.34067,1.97097>,<0.30313,17.33456,1.97322>,
            
    /*3*/ <0.49507,17.66723,2.12893>,<0.49526,17.66899,2.1249>,<0.49851,17.66639,2.12632>,
            
    /*4*/ <0.60221,18.06045,2.20363>

    /* stem 0.20.18*/ 
    /*0*/ <0.09572,17.30314,1.82649>,
    /*1*/ <0.08903,17.30394,1.82417>,<0.10099,17.30695,1.82356>,<0.09715,17.29854,1.83175>,
            
    /*2*/ <0.0333,17.58852,2.09008>,<0.04127,17.59052,2.08967>,<0.03871,17.58492,2.09513>,
            
    /*3*/ <0.05352,17.92763,2.28959>,<0.05756,17.92787,2.28883>,<0.05621,17.92596,2.29222>,
            
    /*4*/ <0.07295,18.26179,2.4964>

    /* stem 0.20.19*/ 
    /*0*/ <0.09863,17.48849,1.8819>,
    /*1*/ <0.09947,17.4904,1.87546>,<0.10323,17.49018,1.88657>,<0.09318,17.48488,1.88368>,
            
    /*2*/ <-0.08967,17.80952,1.94793>,<-0.08716,17.80937,1.95533>,<-0.09386,17.80584,1.95341>,
            
    /*3*/ <-0.16403,18.17187,2.02424>,<-0.16261,18.17142,2.02786>,<-0.1664,18.17079,2.02716>,
            
    /*4*/ <-0.24515,18.52805,2.12178>

    /* stem 0.20.20*/ 
    /*0*/ <0.10171,17.6856,1.94084>,
    /*1*/ <0.10807,17.6857,1.94018>,<0.09907,17.68691,1.9465>,<0.09801,17.6842,1.93582>,
            
    /*2*/ <0.09165,18.03609,1.85277>,<0.08565,18.0369,1.85698>,<0.08494,18.03509,1.84987>,
            
    /*3*/ <0.09719,18.39274,1.79535>,<0.09419,18.39314,1.79746>,<0.09382,18.39257,1.79384>,
            
    /*4*/ <0.10359,18.75391,1.78067>

    /* stem 0.20.21*/ 
    /*0*/ <0.10582,17.94768,2.01919>,
    /*1*/ <0.10755,17.9462,2.02403>,<0.10102,17.94997,2.01865>,<0.10889,17.94686,2.01489>,
            
    /*2*/ <0.24807,18.25264,2.06518>,<0.24372,18.25515,2.06159>,<0.24896,18.25308,2.05908>,
            
    /*3*/ <0.33038,18.5801,2.1042>,<0.32805,18.58092,2.10234>,<0.33085,18.58036,2.10116>,
            
    /*4*/ <0.40819,18.90684,2.15417>

    /* stem 0.20.22*/ 
    /*0*/ <0.10972,18.19666,2.09363>,
    /*1*/ <0.1073,18.19626,2.09508>,<0.10978,18.19844,2.09141>,<0.11209,18.19527,2.0944>,
            
    /*2*/ <0.18569,18.43657,2.2894>,<0.18734,18.43802,2.28695>,<0.18888,18.4359,2.28894>,
            
    /*3*/ <0.23155,18.69777,2.46619>,<0.23237,18.69847,2.46495>,<0.23318,18.69758,2.46606>,
            
    /*4*/ <0.26796,18.96067,2.6428>

    /* stem 0.20.23*/ 
    /*0*/ <0.11308,18.41103,2.15772>,
    /*1*/ <0.11259,18.41118,2.15724>,<0.11366,18.41142,2.15775>,<0.11299,18.41049,2.15816>,
            
    /*2*/ <-0.02052,18.59529,2.35457>,<-0.01981,18.59545,2.35491>,<-0.02025,18.59483,2.35518>,
            
    /*3*/ <-0.10834,18.84593,2.49599>,<-0.10797,18.84598,2.49614>,<-0.10824,18.84577,2.49635>,
            
    /*4*/ <-0.15986,19.12561,2.59435>

    /* stem 0.21*/ 
    /*0*/ <0,14.08776,0>,
    /*1*/ <-0.01397,14.08776,-0.04871>,<0.0358,14.11186,-0.02655>,<0.03609,14.10265,0.03229>,
            <-0.01349,14.07287,0.04651>,<-0.04443,14.06367,-0.00355>,
    /*2*/ <-0.86378,15.62739,0.21255>,<-0.8306,15.64346,0.22731>,<-0.83041,15.63732,0.26654>,
            <-0.86347,15.61746,0.27602>,<-0.88409,15.61133,0.24265>,
    /*3*/ <-1.536,17.25981,0.42287>,<-1.51861,17.26617,0.43002>,<-1.51882,17.26374,0.44973>,
            <-1.53634,17.25587,0.45475>,<-1.54696,17.25344,0.43816>,
    /*4*/ <-2.02148,18.96293,0.57965>

    /* stem 0.21.0*/ 
    /*0*/ <-0.09433,14.25773,0.02705>,
    /*1*/ <-0.08313,14.26502,0.02034>,<-0.09896,14.262,0.04062>,<-0.1009,14.24618,0.02019>,
            
    /*2*/ <-0.54455,14.69672,-0.27011>,<-0.5551,14.69471,-0.2566>,<-0.5564,14.68416,-0.27021>,
            
    /*3*/ <-0.92737,15.21836,-0.52166>,<-0.93285,15.21761,-0.51502>,<-0.93421,15.21312,-0.52227>,
            
    /*4*/ <-1.22841,15.84365,-0.56386>

    /* stem 0.21.1*/ 
    /*0*/ <-0.20715,14.46101,0.0594>,
    /*1*/ <-0.1983,14.46417,0.07036>,<-0.22144,14.46203,0.06113>,<-0.2017,14.45683,0.04671>,
            
    /*2*/ <-0.17984,15.1081,-0.13675>,<-0.19526,15.10667,-0.1429>,<-0.1821,15.1032,-0.15251>,
            
    /*3*/ <-0.15927,15.76556,-0.29283>,<-0.16698,15.76511,-0.29596>,<-0.1604,15.76374,-0.30088>,
            
    /*4*/ <-0.21833,16.43583,-0.36309>

    /* stem 0.21.2*/ 
    /*0*/ <-0.31924,14.66298,0.09154>,
    /*1*/ <-0.32583,14.65758,0.10254>,<-0.3265,14.66933,0.08151>,<-0.30539,14.66205,0.09057>,
            
    /*2*/ <-0.26272,15.23216,0.41693>,<-0.26317,15.23999,0.40291>,<-0.24909,15.23514,0.40895>,
            
    /*3*/ <-0.19572,15.80562,0.73257>,<-0.19596,15.80956,0.72557>,<-0.18892,15.8071,0.72855>,
            
    /*4*/ <-0.24521,16.43268,0.92724>

    /* stem 0.21.3*/ 
    /*0*/ <-0.3887,14.78814,0.11146>,
    /*1*/ <-0.39993,14.78279,0.10597>,<-0.38365,14.7998,0.1066>,<-0.38252,14.78184,0.12181>,
            
    /*2*/ <-0.75951,15.11646,0.52698>,<-0.74866,15.1278,0.5274>,<-0.7479,15.11583,0.53754>,
            
    /*3*/ <-1.15971,15.53197,0.81697>,<-1.15407,15.53744,0.81703>,<-1.15481,15.53249,0.82308>,
            
    /*4*/ <-1.51447,16.04783,0.97855>

    /* stem 0.21.4*/ 
    /*0*/ <-0.50297,14.99405,0.14423>,
    /*1*/ <-0.50164,14.99681,0.13151>,<-0.4967,15.00123,0.15318>,<-0.51058,14.98409,0.14799>,
            
    /*2*/ <-0.99373,15.38427,0.16858>,<-0.99044,15.38722,0.18303>,<-0.99969,15.37579,0.17957>,
            
    /*3*/ <-1.3777,15.87832,0.2087>,<-1.37564,15.87939,0.21589>,<-1.38153,15.87495,0.21427>,
            
    /*4*/ <-1.6332,16.44908,0.16809>

    /* stem 0.21.5*/ 
    /*0*/ <-0.60089,15.17049,0.1723>,
    /*1*/ <-0.58987,15.17667,0.17188>,<-0.60798,15.17091,0.18277>,<-0.60483,15.16388,0.16227>,
            
    /*2*/ <-0.87993,15.67026,-0.0419>,<-0.892,15.66642,-0.03464>,<-0.8899,15.66174,-0.04831>,
            
    /*3*/ <-1.17083,16.19582,-0.15344>,<-1.17661,16.19348,-0.14966>,<-1.17617,16.19219,-0.15683>,
            
    /*4*/ <-1.47094,16.72752,-0.18101>

    /* stem 0.21.6*/ 
    /*0*/ <-0.68808,15.32759,0.19731>,
    /*1*/ <-0.68453,15.3277,0.20903>,<-0.70002,15.32771,0.19452>,<-0.67971,15.32737,0.18836>,
            
    /*2*/ <-0.6781,15.92416,0.19738>,<-0.68843,15.92416,0.1877>,<-0.67489,15.92394,0.1836>,
            
    /*3*/ <-0.66666,16.5191,0.2309>,<-0.67184,16.51951,0.2261>,<-0.66507,16.5195,0.22402>,
            
    /*4*/ <-0.69029,17.09775,0.37156>

    /* stem 0.21.7*/ 
    /*0*/ <-0.80987,15.54703,0.23223>,
    /*1*/ <-0.81855,15.54134,0.23766>,<-0.81195,15.55264,0.22216>,<-0.79911,15.54709,0.23686>,
            
    /*2*/ <-0.94509,16.02193,0.52953>,<-0.94069,16.02946,0.51919>,<-0.93213,16.02577,0.52899>,
            
    /*3*/ <-1.06109,16.54191,0.75146>,<-1.05866,16.54488,0.74589>,<-1.05454,16.54357,0.75109>,
            
    /*4*/ <-1.24388,17.0723,0.88347>

    /* stem 0.21.8*/ 
    /*0*/ <-0.90134,15.74042,0.25845>,
    /*1*/ <-0.90862,15.7384,0.2501>,<-0.89457,15.74941,0.25797>,<-0.90083,15.73347,0.26729>,
            
    /*2*/ <-1.29311,16.04511,0.51589>,<-1.28375,16.05245,0.52114>,<-1.28793,16.04182,0.52735>,
            
    /*3*/ <-1.56451,16.44678,0.79711>,<-1.55883,16.44939,0.79893>,<-1.56167,16.44487,0.80265>,
            
    /*4*/ <-1.83608,16.87688,1.02859>

    /* stem 0.21.9*/ 
    /*0*/ <-0.97745,15.92399,0.28028>,
    /*1*/ <-0.97204,15.92728,0.27148>,<-0.9757,15.92881,0.28984>,<-0.98461,15.91588,0.27953>,
            
    /*2*/ <-1.36776,16.28394,0.166>,<-1.3702,16.28496,0.17824>,<-1.37614,16.27634,0.17137>,
            
    /*3*/ <-1.70635,16.70235,0.09568>,<-1.70734,16.70263,0.10186>,<-1.71101,16.69906,0.09826>,
            
    /*4*/ <-1.97732,17.17292,0.08757>

    /* stem 0.21.10*/ 
    /*0*/ <-1.09629,16.21059,0.31436>,
    /*1*/ <-1.08741,16.21382,0.3182>,<-1.10481,16.2113,0.31992>,<-1.09665,16.20666,0.30495>,
            
    /*2*/ <-1.17798,16.685,0.12272>,<-1.18959,16.68332,0.12387>,<-1.18415,16.68022,0.11389>,
            
    /*3*/ <-1.1899,17.16861,-0.0599>,<-1.19579,17.16861,-0.05962>,<-1.19308,17.16682,-0.06453>,
            
    /*4*/ <-1.20948,17.6774,-0.15445>

    /* stem 0.21.11*/ 
    /*0*/ <-1.18098,16.41483,0.33864>,
    /*1*/ <-1.18203,16.41326,0.3482>,<-1.18885,16.41551,0.33293>,<-1.17207,16.41573,0.33479>,
            
    /*2*/ <-1.19677,16.90751,0.42444>,<-1.20131,16.90901,0.41425>,<-1.19013,16.90915,0.4155>,
            
    /*3*/ <-1.25997,17.40254,0.46497>,<-1.26218,17.40271,0.4598>,<-1.25664,17.40336,0.46051>,
            
    /*4*/ <-1.31897,17.89482,0.53069>

    /* stem 0.21.12*/ 
    /*0*/ <-1.30912,16.72385,0.37538>,
    /*1*/ <-1.31745,16.72033,0.37597>,<-1.30738,16.73041,0.36936>,<-1.30251,16.72082,0.38081>,
            
    /*2*/ <-1.43001,17.04809,0.69844>,<-1.4233,17.05482,0.69404>,<-1.42005,17.04842,0.70167>,
            
    /*3*/ <-1.51654,17.43724,0.95495>,<-1.51297,17.43989,0.95219>,<-1.51155,17.43734,0.95654>,
            
    /*4*/ <-1.59715,17.82065,1.22065>

    /* stem 0.21.13*/ 
    /*0*/ <-1.40316,16.95067,0.40235>,
    /*1*/ <-1.40579,16.95055,0.39418>,<-1.39692,16.95604,0.40477>,<-1.40678,16.94542,0.4081>,
            
    /*2*/ <-1.71482,17.26788,0.49201>,<-1.7089,17.27154,0.49907>,<-1.71547,17.26446,0.50129>,
            
    /*3*/ <-1.95896,17.63138,0.61249>,<-1.95552,17.63261,0.61584>,<-1.95929,17.62966,0.61712>,
            
    /*4*/ <-2.09306,18.03656,0.76745>

    /* stem 0.21.14*/ 
    /*0*/ <-1.45927,17.08599,0.41844>,
    /*1*/ <-1.45279,17.08916,0.41435>,<-1.46022,17.08752,0.42653>,<-1.4648,17.08128,0.41444>,
            
    /*2*/ <-1.69199,17.44839,0.31975>,<-1.69694,17.4473,0.32787>,<-1.69999,17.44314,0.3198>,
            
    /*3*/ <-1.90474,17.83363,0.28097>,<-1.90704,17.8328,0.28509>,<-1.90894,17.83134,0.28094>,
            
    /*4*/ <-2.01203,18.25935,0.2373>

    /* stem 0.21.15*/ 
    /*0*/ <-1.56679,17.38295,0.44927>,
    /*1*/ <-1.5616,17.38399,0.45483>,<-1.57428,17.38325,0.4509>,<-1.56448,17.38162,0.44207>,
            
    /*2*/ <-1.56345,17.79305,0.37703>,<-1.5719,17.79256,0.37441>,<-1.56537,17.79147,0.36852>,
            
    /*3*/ <-1.58627,18.20533,0.32363>,<-1.59049,18.20495,0.32234>,<-1.58724,18.20474,0.31934>,
            
    /*4*/ <-1.6416,18.61748,0.30249>

    /* stem 0.21.16*/ 
    /*0*/ <-1.63743,17.62844,0.46953>,
    /*1*/ <-1.64113,17.62688,0.47549>,<-1.64082,17.6312,0.46382>,<-1.63035,17.62723,0.46927>,
            
    /*2*/ <-1.57277,17.99276,0.61038>,<-1.57257,17.99564,0.60259>,<-1.56559,17.993,0.60623>,
            
    /*3*/ <-1.5419,18.36498,0.74112>,<-1.54181,18.36637,0.73721>,<-1.53827,18.3654,0.73915>,
            
    /*4*/ <-1.58546,18.75133,0.81612>

    /* stem 0.21.17*/ 
    /*0*/ <-1.69661,17.83408,0.4865>,
    /*1*/ <-1.70277,17.83251,0.48411>,<-1.69243,17.83795,0.48281>,<-1.69464,17.83178,0.49257>,
            
    /*2*/ <-1.84355,18.1431,0.64886>,<-1.83666,18.14674,0.64799>,<-1.83813,18.14262,0.6545>,
            
    /*3*/ <-2.01028,18.44441,0.80568>,<-2.00695,18.44645,0.80535>,<-2.00766,18.44437,0.80859>,
            
    /*4*/ <-2.15709,18.77296,0.92393>

    /* stem 0.21.18*/ 
    /*0*/ <-1.73359,17.96257,0.4971>,
    /*1*/ <-1.7329,17.9633,0.49064>,<-1.73031,17.96646,0.5012>,<-1.73756,17.95794,0.49946>,
            
    /*2*/ <-2.01313,18.20181,0.48981>,<-2.01141,18.20392,0.49685>,<-2.01624,18.19824,0.49568>,
            
    /*3*/ <-2.22193,18.50207,0.53366>,<-2.22055,18.50255,0.53714>,<-2.22365,18.50047,0.53661>,
            
    /*4*/ <-2.38194,18.83237,0.55831>

    /* stem 0.21.19*/ 
    /*0*/ <-1.80452,18.20902,0.51744>,
    /*1*/ <-1.79872,18.21074,0.51687>,<-1.80781,18.21097,0.52215>,<-1.80701,18.20536,0.51329>,
            
    /*2*/ <-1.90057,18.48714,0.33268>,<-1.90663,18.48729,0.3362>,<-1.9061,18.48355,0.3303>,
            
    /*3*/ <-1.99793,18.79162,0.19686>,<-2.00089,18.79152,0.19872>,<-2.00079,18.79012,0.19551>,
            
    /*4*/ <-2.10365,19.11419,0.12269>

    /* stem 0.21.20*/ 
    /*0*/ <-1.86598,18.4226,0.53506>,
    /*1*/ <-1.86425,18.42268,0.54013>,<-1.87123,18.4229,0.53402>,<-1.86246,18.42221,0.53103>,
            
    /*2*/ <-1.84312,18.75127,0.52581>,<-1.84778,18.75142,0.52173>,<-1.84193,18.75095,0.51974>,
            
    /*3*/ <-1.85772,19.08051,0.523>,<-1.86004,19.08041,0.52096>,<-1.85712,19.08053,0.51996>,
            
    /*4*/ <-1.88868,19.40748,0.49362>

    /* stem 0.21.21*/ 
    /*0*/ <-1.93289,18.65509,0.55425>,
    /*1*/ <-1.93536,18.65425,0.55583>,<-1.9332,18.65659,0.5516>,<-1.9301,18.65444,0.5553>,
            
    /*2*/ <-1.92889,18.92464,0.70764>,<-1.92745,18.92619,0.70483>,<-1.92538,18.92476,0.70729>,
            
    /*3*/ <-1.92195,19.2036,0.84319>,<-1.92124,19.2043,0.84173>,<-1.9202,19.20365,0.84301>,
            
    /*4*/ <-1.95887,19.49793,0.93368>

    /* stem 0.21.22*/ 
    /*0*/ <-1.99645,18.87598,0.57247>,
    /*1*/ <-1.99705,18.87586,0.57186>,<-1.99582,18.87655,0.57236>,<-1.9965,18.87553,0.57321>,
            
    /*2*/ <-2.1626,19.08423,0.69132>,<-2.16178,19.08469,0.69165>,<-2.16223,19.08401,0.69221>,
            
    /*3*/ <-2.29148,19.3212,0.80248>,<-2.29103,19.32137,0.80262>,<-2.2913,19.32109,0.80293>,
            
    /*4*/ <-2.41949,19.56733,0.8926>

    /* stem 0.22*/ 
    /*0*/ <0,14.59566,0>,
    /*1*/ <0.04262,14.59566,-0.02362>,<0.03263,14.61883,0.0278>,<-0.02245,14.60998,0.0408>,
            <-0.0465,14.58134,-0.00258>,<-0.00629,14.57249,-0.0424>,
    /*2*/ <-0.38977,16.08967,-0.77016>,<-0.39643,16.10511,-0.73588>,<-0.43315,16.09921,-0.72721>,
            <-0.44918,16.08012,-0.75613>,<-0.42237,16.07422,-0.78268>,
    /*3*/ <-0.73524,17.6737,-1.3599>,<-0.73818,17.67982,-1.34206>,<-0.75668,17.67748,-1.33799>,
            <-0.76518,17.66992,-1.35333>,<-0.75193,17.66758,-1.36687>,
    /*4*/ <-0.98931,19.32635,-1.78477>

    /* stem 0.22.0*/ 
    /*0*/ <-0.04619,14.76068,-0.08333>,
    /*1*/ <-0.03747,14.76768,-0.07428>,<-0.06031,14.76342,-0.08329>,<-0.04078,14.75093,-0.09241>,
            
    /*2*/ <0.0521,15.24774,-0.54002>,<0.03688,15.2449,-0.54602>,<0.04989,15.23657,-0.55211>,
            
    /*3*/ <0.05308,15.79542,-0.93367>,<0.04542,15.7936,-0.9363>,<0.05202,15.79066,-0.94038>,
            
    /*4*/ <0.07793,16.41932,-1.18698>

    /* stem 0.22.1*/ 
    /*0*/ <-0.12245,15.03312,-0.2209>,
    /*1*/ <-0.13069,15.03612,-0.21039>,<-0.12768,15.03139,-0.23343>,<-0.10897,15.03185,-0.21888>,
            
    /*2*/ <-0.05016,15.66884,-0.33382>,<-0.04816,15.66569,-0.34917>,<-0.03568,15.66599,-0.33948>,
            
    /*3*/ <0.06253,16.2961,-0.46161>,<0.06354,16.29441,-0.46926>,<0.06972,16.2943,-0.46434>,
            
    /*4*/ <0.15029,16.90694,-0.6657>

    /* stem 0.22.2*/ 
    /*0*/ <-0.16742,15.19378,-0.30203>,
    /*1*/ <-0.17906,15.18862,-0.30579>,<-0.15834,15.19706,-0.31116>,<-0.16485,15.19567,-0.28913>,
            
    /*2*/ <-0.42223,15.77399,-0.3405>,<-0.40842,15.77961,-0.34408>,<-0.41275,15.77868,-0.32939>,
            
    /*3*/ <-0.62264,16.36755,-0.44478>,<-0.61548,16.36972,-0.44648>,<-0.61801,16.37014,-0.43925>,
            
    /*4*/ <-0.78404,16.96173,-0.59994>

    /* stem 0.22.3*/ 
    /*0*/ <-0.21565,15.3661,-0.38904>,
    /*1*/ <-0.21298,15.36103,-0.40055>,<-0.20922,15.37643,-0.38492>,<-0.22475,15.36082,-0.38165>,
            
    /*2*/ <-0.63824,15.73043,-0.65693>,<-0.63573,15.7407,-0.64651>,<-0.64608,15.73029,-0.64433>,
            
    /*3*/ <-1.00926,16.14716,-0.92462>,<-1.00775,16.15204,-0.91924>,<-1.01348,16.14739,-0.91852>,
            
    /*4*/ <-1.25926,16.67897,-1.12066>

    /* stem 0.22.4*/ 
    /*0*/ <-0.26947,15.55837,-0.48613>,
    /*1*/ <-0.25746,15.56099,-0.48761>,<-0.27695,15.56655,-0.48063>,<-0.27399,15.54758,-0.49016>,
            
    /*2*/ <-0.3814,15.8095,-1.02075>,<-0.39439,15.81321,-1.0161>,<-0.39241,15.80056,-1.02245>,
            
    /*3*/ <-0.57948,16.191,-1.44208>,<-0.58552,16.192,-1.4384>,<-0.58513,16.18681,-1.44329>,
            
    /*4*/ <-0.7151,16.65812,-1.79452>

    /* stem 0.22.5*/ 
    /*0*/ <-0.3415,15.8157,-0.61607>,
    /*1*/ <-0.33881,15.82145,-0.60619>,<-0.35245,15.81607,-0.62028>,<-0.33323,15.80959,-0.62175>,
            
    /*2*/ <-0.20524,16.28835,-0.91845>,<-0.21434,16.28476,-0.92785>,<-0.20152,16.28045,-0.92882>,
            
    /*3*/ <-0.12724,16.77868,-1.21276>,<-0.13183,16.77671,-1.21734>,<-0.12529,16.77515,-1.21821>,
            
    /*4*/ <-0.2166,17.26987,-1.50321>

    /* stem 0.22.6*/ 
    /*0*/ <-0.38126,15.95778,-0.68782>,
    /*1*/ <-0.39115,15.95788,-0.68214>,<-0.38123,15.95705,-0.69919>,<-0.37141,15.95841,-0.68212>,
            
    /*2*/ <-0.40298,16.5207,-0.72025>,<-0.39637,16.52015,-0.73161>,<-0.38983,16.52106,-0.72023>,
            
    /*3*/ <-0.37491,17.0842,-0.74107>,<-0.37159,17.08387,-0.74674>,<-0.36834,17.08392,-0.74102>,
            
    /*4*/ <-0.29279,17.63709,-0.82183>

    /* stem 0.22.7*/ 
    /*0*/ <-0.43474,16.16886,-0.78429>,
    /*1*/ <-0.44175,16.16467,-0.79151>,<-0.42541,16.17333,-0.78772>,<-0.43706,16.16858,-0.77365>,
            
    /*2*/ <-0.68643,16.6503,-0.8301>,<-0.67554,16.65607,-0.82757>,<-0.6833,16.65291,-0.81819>,
            
    /*3*/ <-0.85033,17.16771,-0.88812>,<-0.84453,17.16974,-0.88674>,<-0.84875,17.16891,-0.88214>,
            
    /*4*/ <-0.97913,17.6842,-1.00525>

    /* stem 0.22.8*/ 
    /*0*/ <-0.49049,16.43546,-0.88487>,
    /*1*/ <-0.48455,16.43361,-0.89308>,<-0.48798,16.44297,-0.87828>,<-0.49895,16.42981,-0.88326>,
            
    /*2*/ <-0.76698,16.77393,-1.17024>,<-0.76927,16.78017,-1.16038>,<-0.77658,16.7714,-1.1637>,
            
    /*3*/ <-0.95032,17.19749,-1.41351>,<-0.9512,17.20016,-1.40827>,<-0.95553,17.19689,-1.4107>,
            
    /*4*/ <-1.01987,17.69082,-1.56937>

    /* stem 0.22.9*/ 
    /*0*/ <-0.53033,16.62597,-0.95675>,
    /*1*/ <-0.52142,16.62897,-0.95375>,<-0.53839,16.63101,-0.95407>,<-0.53119,16.61794,-0.96242>,
            
    /*2*/ <-0.48197,16.91537,-1.3682>,<-0.49329,16.91674,-1.36842>,<-0.48849,16.90802,-1.37398>,
            
    /*3*/ <-0.46443,17.28057,-1.71657>,<-0.47011,17.28104,-1.71641>,<-0.46765,17.27743,-1.72007>,
            
    /*4*/ <-0.46229,17.70903,-1.98409>

    /* stem 0.22.10*/ 
    /*0*/ <-0.55441,16.74108,-1.00018>,
    /*1*/ <-0.55605,16.74413,-0.9912>,<-0.56123,16.74202,-1.0069>,<-0.54594,16.73711,-1.00243>,
            
    /*2*/ <-0.37739,17.18974,-1.11298>,<-0.38085,17.18833,-1.12345>,<-0.37066,17.18506,-1.12047>,
            
    /*3*/ <-0.21411,17.64004,-1.23899>,<-0.21587,17.63925,-1.24421>,<-0.21071,17.63779,-1.24276>,
            
    /*4*/ <-0.01526,18.07495,-1.36831>

    /* stem 0.22.11*/ 
    /*0*/ <-0.60264,16.97174,-1.0872>,
    /*1*/ <-0.61158,16.97028,-1.08614>,<-0.59946,16.97492,-1.09513>,<-0.5969,16.97004,-1.08033>,
            
    /*2*/ <-0.66326,17.41614,-0.93011>,<-0.65518,17.41924,-0.9361>,<-0.65347,17.41598,-0.92624>,
            
    /*3*/ <-0.68822,17.88819,-0.87647>,<-0.68408,17.8888,-0.87966>,<-0.68335,17.88825,-0.87447>,
            
    /*4*/ <-0.7407,18.36024,-0.86691>

    /* stem 0.22.12*/ 
    /*0*/ <-0.6397,17.14895,-1.15406>,
    /*1*/ <-0.64206,17.14556,-1.16175>,<-0.63296,17.15449,-1.15361>,<-0.64409,17.14682,-1.14681>,
            
    /*2*/ <-0.92705,17.50027,-1.22763>,<-0.92098,17.50622,-1.2222>,<-0.9284,17.50111,-1.21767>,
            
    /*3*/ <-1.0729,17.93225,-1.29315>,<-1.0692,17.93397,-1.29018>,<-1.07368,17.93276,-1.2882>,
            
    /*4*/ <-1.13955,18.37423,-1.40055>

    /* stem 0.22.13*/ 
    /*0*/ <-0.69025,17.39064,-1.24524>,
    /*1*/ <-0.68319,17.39053,-1.24945>,<-0.69115,17.39577,-1.23888>,<-0.6964,17.38563,-1.24739>,
            
    /*2*/ <-0.84204,17.6985,-1.51849>,<-0.84734,17.70199,-1.51144>,<-0.85084,17.69523,-1.51711>,
            
    /*3*/ <-0.97919,18.05703,-1.73115>,<-0.98167,18.05837,-1.72733>,<-0.9837,18.05564,-1.73064>,
            
    /*4*/ <-1.09666,18.46312,-1.84916>

    /* stem 0.22.14*/ 
    /*0*/ <-0.73247,17.59253,-1.32141>,
    /*1*/ <-0.72735,17.59551,-1.31634>,<-0.73981,17.59514,-1.32152>,<-0.73024,17.58694,-1.32635>,
            
    /*2*/ <-0.62031,17.88756,-1.60021>,<-0.62861,17.88731,-1.60367>,<-0.62224,17.88185,-1.60689>,
            
    /*3*/ <-0.53139,18.2106,-1.85492>,<-0.53555,18.21044,-1.85662>,<-0.53226,18.20803,-1.85852>,
            
    /*4*/ <-0.45954,18.60118,-1.99326>

    /* stem 0.22.15*/ 
    /*0*/ <-0.76282,17.76588,-1.37617>,
    /*1*/ <-0.76694,17.76689,-1.37006>,<-0.76588,17.76671,-1.38289>,<-0.75564,17.76406,-1.37555>,
            
    /*2*/ <-0.66574,18.16042,-1.3693>,<-0.66503,18.1603,-1.37786>,<-0.6582,18.15853,-1.37296>,
            
    /*3*/ <-0.68892,18.56524,-1.36945>,<-0.6886,18.56528,-1.37373>,<-0.68505,18.56549,-1.37131>,
            
    /*4*/ <-0.74771,18.95951,-1.44966>

    /* stem 0.22.16*/ 
    /*0*/ <-0.80045,18.02516,-1.44406>,
    /*1*/ <-0.80686,18.02366,-1.44623>,<-0.79598,18.02827,-1.44834>,<-0.79853,18.02356,-1.4376>,
            
    /*2*/ <-0.9267,18.36802,-1.32359>,<-0.91945,18.37109,-1.32499>,<-0.92115,18.36795,-1.31783>,
            
    /*3*/ <-1.08469,18.7127,-1.26269>,<-1.08116,18.71446,-1.26335>,<-1.08217,18.71335,-1.25965>,
            
    /*4*/ <-1.22314,19.07117,-1.2439>

    /* stem 0.22.17*/ 
    /*0*/ <-0.83992,18.29707,-1.51526>,
    /*1*/ <-0.83903,18.29559,-1.52142>,<-0.8361,18.30135,-1.51241>,<-0.84462,18.29428,-1.51193>,
            
    /*2*/ <-1.06545,18.56175,-1.61588>,<-1.0635,18.56559,-1.60988>,<-1.06918,18.56087,-1.60955>,
            
    /*3*/ <-1.29394,18.82631,-1.70984>,<-1.29296,18.82825,-1.70685>,<-1.29579,18.82587,-1.70668>,
            
    /*4*/ <-1.48005,19.136,-1.73779>

    /* stem 0.22.18*/ 
    /*0*/ <-0.86484,18.46877,-1.56021>,
    /*1*/ <-0.85885,18.46945,-1.56094>,<-0.86787,18.4724,-1.5564>,<-0.8678,18.46446,-1.56331>,
            
    /*2*/ <-0.9176,18.69419,-1.81957>,<-0.92361,18.69616,-1.81655>,<-0.92356,18.69087,-1.82115>,
            
    /*3*/ <-0.94661,18.94575,-2.05725>,<-0.94962,18.94679,-2.0558>,<-0.94964,18.94438,-2.05835>,
            
    /*4*/ <-0.91607,19.22032,-2.26772>

    /* stem 0.22.19*/ 
    /*0*/ <-0.90936,18.77548,-1.64052>,
    /*1*/ <-0.9077,18.77701,-1.6356>,<-0.91452,18.77621,-1.64199>,<-0.90585,18.77322,-1.64397>,
            
    /*2*/ <-0.83396,19.06779,-1.75268>,<-0.8385,19.06726,-1.75694>,<-0.83272,19.06526,-1.75826>,
            
    /*3*/ <-0.79004,19.37206,-1.84802>,<-0.79232,19.37174,-1.85013>,<-0.78937,19.37107,-1.85092>,
            
    /*4*/ <-0.78152,19.68113,-1.93814>

    /* stem 0.22.20*/ 
    /*0*/ <-0.93589,18.95827,-1.68838>,
    /*1*/ <-0.93896,18.95832,-1.68647>,<-0.93595,18.95897,-1.69193>,<-0.93275,18.9575,-1.68675>,
            
    /*2*/ <-0.89616,19.25648,-1.62841>,<-0.89416,19.25691,-1.63205>,<-0.89202,19.25593,-1.62859>,
            
    /*3*/ <-0.83118,19.55558,-1.60409>,<-0.83021,19.55553,-1.60594>,<-0.82913,19.55516,-1.60419>,
            
    /*4*/ <-0.79107,19.85677,-1.64671>

    /* stem 0.22.21*/ 
    /*0*/ <-0.97315,19.21497,-1.7556>,
    /*1*/ <-0.9739,19.21466,-1.75634>,<-0.97228,19.21556,-1.75591>,<-0.97326,19.21467,-1.75455>,
            
    /*2*/ <-1.12014,19.45408,-1.70437>,<-1.11907,19.45468,-1.70409>,<-1.11972,19.45409,-1.70318>,
            
    /*3*/ <-1.25249,19.70623,-1.72071>,<-1.25194,19.70652,-1.72057>,<-1.25234,19.70635,-1.72011>,
            
    /*4*/ <-1.36701,19.96018,-1.78227>

    /* stem 0.23*/ 
    /*0*/ <0,15.05171,0>,
    /*1*/ <0.03141,15.05171,0.03489>,<-0.01903,15.07403,0.03665>,<-0.04317,15.0655,-0.01223>,
            <-0.00765,15.03791,-0.04422>,<0.03844,15.02938,-0.01509>,
    /*2*/ <0.64389,16.5036,-0.53764>,<0.61026,16.51849,-0.53646>,<0.59416,16.5128,-0.56906>,
            <0.61784,16.4944,-0.59038>,<0.64857,16.48872,-0.57096>,
    /*3*/ <1.12688,18.04299,-0.99359>,<1.10949,18.04889,-0.99248>,<1.10166,18.04664,-1.00898>,
            <1.11422,18.03935,-1.02028>,<1.1298,18.0371,-1.01077>,
    /*4*/ <1.47374,19.64907,-1.32696>

    /* stem 0.23.0*/ 
    /*0*/ <0.08305,15.24526,-0.07478>,
    /*1*/ <0.07648,15.25197,-0.0647>,<0.08101,15.24886,-0.08791>,<0.09165,15.23495,-0.07172>,
            
    /*2*/ <0.57309,15.67404,-0.02855>,<0.57611,15.67196,-0.04402>,<0.58321,15.66269,-0.03323>,
            
    /*3*/ <0.99031,16.17486,-0.0177>,<0.9918,16.17385,-0.02545>,<0.99621,16.17006,-0.02002>,
            
    /*4*/ <1.31207,16.72953,-0.14057>

    /* stem 0.23.1*/ 
    /*0*/ <0.1586,15.42135,-0.1428>,
    /*1*/ <0.14682,15.42427,-0.14832>,<0.16941,15.42005,-0.15048>,<0.15956,15.41973,-0.12961>,
            
    /*2*/ <0.27329,16.04422,-0.07925>,<0.28835,16.0414,-0.08069>,<0.28178,16.04119,-0.06677>,
            
    /*3*/ <0.50098,16.63955,-0.08033>,<0.50815,16.63685,-0.08108>,<0.50517,16.638,-0.07407>,
            
    /*4*/ <0.73915,17.22618,-0.14435>

    /* stem 0.23.2*/ 
    /*0*/ <0.26152,15.66123,-0.23547>,
    /*1*/ <0.26252,15.65628,-0.24716>,<0.2718,15.66599,-0.22967>,<0.25023,15.66141,-0.22959>,
            
    /*2*/ <0.14433,16.20942,-0.48684>,<0.15051,16.21589,-0.47518>,<0.13613,16.21284,-0.47513>,
            
    /*3*/ <0.11155,16.78558,-0.69855>,<0.11472,16.78806,-0.6924>,<0.1074,16.7875,-0.69279>,
            
    /*4*/ <0.24728,17.37084,-0.82889>

    /* stem 0.23.3*/ 
    /*0*/ <0.3326,15.8269,-0.29947>,
    /*1*/ <0.34392,15.82205,-0.29946>,<0.33035,15.83729,-0.29325>,<0.32353,15.82136,-0.30571>,
            
    /*2*/ <0.47837,16.14501,-0.7857>,<0.46932,16.15517,-0.78156>,<0.46478,16.14455,-0.78987>,
            
    /*3*/ <0.68911,16.61095,-1.09725>,<0.68417,16.61517,-1.09436>,<0.6828,16.61173,-1.10043>,
            
    /*4*/ <0.87068,17.14367,-1.30335>

    /* stem 0.23.4*/ 
    /*0*/ <0.42644,16.04561,-0.38397>,
    /*1*/ <0.43038,16.04809,-0.37315>,<0.41887,16.05289,-0.3893>,<0.43007,16.03583,-0.38945>,
            
    /*2*/ <0.87246,16.3405,-0.60569>,<0.86479,16.34369,-0.61645>,<0.87226,16.33232,-0.61656>,
            
    /*3*/ <1.24129,16.75165,-0.77606>,<1.23727,16.75311,-0.78136>,<1.24218,16.74844,-0.78199>,
            
    /*4*/ <1.58679,17.20712,-0.863>

    /* stem 0.23.5*/ 
    /*0*/ <0.50773,16.23507,-0.45716>,
    /*1*/ <0.49903,16.2406,-0.45249>,<0.50978,16.23607,-0.46824>,<0.51437,16.22853,-0.45074>,
            
    /*2*/ <0.83607,16.67812,-0.3523>,<0.84324,16.6751,-0.36281>,<0.8463,16.67007,-0.35114>,
            
    /*3*/ <1.18852,17.11388,-0.31334>,<1.19171,17.11183,-0.31866>,<1.19358,17.10979,-0.31274>,
            
    /*4*/ <1.52612,17.56219,-0.32468>

    /* stem 0.23.6*/ 
    /*0*/ <0.57151,16.38374,-0.51459>,
    /*1*/ <0.56406,16.38383,-0.52263>,<0.58214,16.385,-0.51696>,<0.56834,16.38237,-0.50419>,
            
    /*2*/ <0.5142,16.92606,-0.46491>,<0.52625,16.92684,-0.46113>,<0.51705,16.92509,-0.45262>,
            
    /*3*/ <0.43125,17.46011,-0.54217>,<0.4372,17.46133,-0.54038>,<0.43255,17.46123,-0.53608>,
            
    /*4*/ <0.47113,17.9832,-0.69953>

    /* stem 0.23.7*/ 
    /*0*/ <0.65427,16.60131,-0.5891>,
    /*1*/ <0.65949,16.5973,-0.59721>,<0.65933,16.60691,-0.58187>,<0.64397,16.59974,-0.58822>,
            
    /*2*/ <0.5666,17.03888,-0.87132>,<0.5665,17.04529,-0.86109>,<0.55625,17.04051,-0.86533>,
            
    /*3*/ <0.56952,17.5216,-1.08565>,<0.56952,17.52408,-1.08015>,<0.56429,17.52288,-1.08292>,
            
    /*4*/ <0.69083,18.016,-1.2258>

    /* stem 0.23.8*/ 
    /*0*/ <0.72866,16.8334,-0.65609>,
    /*1*/ <0.73767,16.83162,-0.65228>,<0.72296,16.84056,-0.65222>,<0.72536,16.82803,-0.66377>,
            
    /*2*/ <0.9376,17.16812,-0.97572>,<0.9278,17.17409,-0.97567>,<0.9294,17.16573,-0.98337>,
            
    /*3*/ <1.08565,17.52728,-1.30375>,<1.08053,17.52983,-1.30331>,<1.08141,17.52582,-1.30732>,
            
    /*4*/ <1.26941,17.90161,-1.59295>

    /* stem 0.23.9*/ 
    /*0*/ <0.77744,16.98555,-0.70001>,
    /*1*/ <0.77655,16.98846,-0.6909>,<0.77161,16.98908,-0.70677>,<0.78415,16.9791,-0.70235>,
            
    /*2*/ <1.09828,17.35336,-0.7796>,<1.09498,17.35378,-0.79018>,<1.10335,17.34712,-0.78723>,
            
    /*3*/ <1.31279,17.78441,-0.89195>,<1.31078,17.7841,-0.8971>,<1.31574,17.78193,-0.89593>,
            
    /*4*/ <1.46486,18.24034,-1.00801>

    /* stem 0.23.10*/ 
    /*0*/ <0.85355,17.22298,-0.76854>,
    /*1*/ <0.84494,17.22585,-0.76814>,<0.85828,17.22388,-0.77623>,<0.85742,17.21921,-0.76124>,
            
    /*2*/ <0.99681,17.65183,-0.6268>,<1.0057,17.65051,-0.63219>,<1.00512,17.6474,-0.62219>,
            
    /*3*/ <1.17371,18.08747,-0.56582>,<1.17793,18.08619,-0.56866>,<1.17793,18.08546,-0.56347>,
            
    /*4*/ <1.39787,18.50473,-0.58761>

    /* stem 0.23.11*/ 
    /*0*/ <0.89854,17.36334,-0.80905>,
    /*1*/ <0.89561,17.36192,-0.8172>,<0.90704,17.36502,-0.80767>,<0.89296,17.36307,-0.80227>,
            
    /*2*/ <0.81531,17.81409,-0.86363>,<0.82294,17.81616,-0.85727>,<0.81355,17.81486,-0.85368>,
            
    /*3*/ <0.8649,18.27141,-0.90838>,<0.86873,18.27134,-0.90507>,<0.86398,18.27202,-0.90344>,
            
    /*4*/ <0.89555,18.72184,-1.0028>

    /* stem 0.23.12*/ 
    /*0*/ <0.95957,17.55372,-0.864>,
    /*1*/ <0.96625,17.55047,-0.86786>,<0.9606,17.55939,-0.85793>,<0.95187,17.55131,-0.86621>,
            
    /*2*/ <0.94854,17.87806,-1.16852>,<0.94477,17.884,-1.1619>,<0.93895,17.87862,-1.16742>,
            
    /*3*/ <0.92515,18.26194,-1.39388>,<0.92328,18.26414,-1.39>,<0.92036,18.26206,-1.39324>,
            
    /*4*/ <0.89665,18.66079,-1.5895>

    /* stem 0.23.13*/ 
    /*0*/ <1.02229,17.74937,-0.92047>,
    /*1*/ <1.0278,17.74926,-0.91473>,<1.01723,17.75549,-0.92102>,<1.02183,17.74336,-0.92566>,
            
    /*2*/ <1.29966,17.95225,-1.17556>,<1.29261,17.9564,-1.17974>,<1.29568,17.94832,-1.18284>,
            
    /*3*/ <1.52539,18.2321,-1.40794>,<1.5215,18.23383,-1.40968>,<1.52362,18.23036,-1.4118>,
            
    /*4*/ <1.74441,18.53419,-1.61736>

    /* stem 0.23.14*/ 
    /*0*/ <1.08154,17.9342,-0.97382>,
    /*1*/ <1.07786,17.93709,-0.96787>,<1.07999,17.93668,-0.9808>,<1.08676,17.92882,-0.97279>,
            
    /*2*/ <1.36932,18.22577,-0.93139>,<1.37074,18.22549,-0.94001>,<1.37526,18.22025,-0.93467>,
            
    /*3*/ <1.63429,18.53737,-0.98437>,<1.6344,18.53658,-0.98866>,<1.63726,18.5346,-0.98601>,
            
    /*4*/ <1.83595,18.89051,-1.0481>

    /* stem 0.23.15*/ 
    /*0*/ <1.14792,18.18463,-1.03359>,
    /*1*/ <1.14139,18.18558,-1.0361>,<1.15351,18.18639,-1.03754>,<1.14887,18.18191,-1.02714>,
            
    /*2*/ <1.13753,18.54492,-0.88321>,<1.14561,18.54546,-0.88417>,<1.14251,18.54248,-0.87724>,
            
    /*3*/ <1.15048,18.92062,-0.77751>,<1.15452,18.92066,-0.77807>,<1.15298,18.91969,-0.77442>,
            
    /*4*/ <1.17171,19.30991,-0.796>

    /* stem 0.23.16*/ 
    /*0*/ <1.18152,18.33563,-1.06384>,
    /*1*/ <1.18218,18.33417,-1.07042>,<1.18685,18.33784,-1.06031>,<1.17552,18.33489,-1.0608>,
            
    /*2*/ <1.09276,18.69109,-1.15668>,<1.09588,18.69354,-1.14995>,<1.08832,18.69157,-1.15027>,
            
    /*3*/ <0.99779,19.04037,-1.26446>,<0.9993,19.04182,-1.26116>,<0.99554,19.04076,-1.26128>,
            
    /*4*/ <0.8808,19.394,-1.32995>

    /* stem 0.23.17*/ 
    /*0*/ <1.25242,18.65432,-1.12769>,
    /*1*/ <1.25839,18.6529,-1.12819>,<1.2506,18.65853,-1.12358>,<1.24828,18.65154,-1.13129>,
            
    /*2*/ <1.2965,18.90582,-1.36903>,<1.2913,18.90957,-1.36595>,<1.28976,18.90491,-1.37109>,
            
    /*3*/ <1.29684,19.21681,-1.53386>,<1.29417,19.21792,-1.53179>,<1.29347,19.21629,-1.53487>,
            
    /*4*/ <1.36266,19.54167,-1.64932>

    /* stem 0.23.18*/ 
    /*0*/ <1.30182,18.87635,-1.17216>,
    /*1*/ <1.30376,18.87699,-1.1668>,<1.29788,18.87996,-1.17424>,<1.30382,18.87209,-1.17544>,
            
    /*2*/ <1.54511,19.07619,-1.27997>,<1.5412,19.07817,-1.28493>,<1.54515,19.07292,-1.28573>,
            
    /*3*/ <1.73182,19.31847,-1.41193>,<1.72948,19.31907,-1.4142>,<1.73187,19.31687,-1.41483>,
            
    /*4*/ <1.90525,19.59651,-1.46753>

    /* stem 0.23.19*/ 
    /*0*/ <1.35121,19.09834,-1.21663>,
    /*1*/ <1.34686,19.09984,-1.21396>,<1.35206,19.10016,-1.22157>,<1.35471,19.09502,-1.21438>,
            
    /*2*/ <1.50539,19.34477,-1.09724>,<1.50887,19.34497,-1.10231>,<1.51063,19.34155,-1.09752>,
            
    /*3*/ <1.66296,19.61037,-1.03782>,<1.66446,19.61009,-1.04048>,<1.66562,19.60883,-1.03793>,
            
    /*4*/ <1.74605,19.91093,-1.00179>

    /* stem 0.23.20*/ 
    /*0*/ <1.39351,19.28847,-1.25472>,
    /*1*/ <1.39103,19.28852,-1.25721>,<1.3969,19.28871,-1.25561>,<1.3926,19.28816,-1.25134>,
            
    /*2*/ <1.37591,19.5856,-1.23421>,<1.37982,19.58573,-1.23314>,<1.37695,19.58537,-1.2303>,
            
    /*3*/ <1.377,19.88392,-1.23259>,<1.37895,19.88392,-1.23207>,<1.37752,19.88392,-1.23063>,
            
    /*4*/ <1.40475,20.17942,-1.26292>

    /* stem 0.23.21*/ 
    /*0*/ <1.4533,19.55721,-1.30856>,
    /*1*/ <1.45375,19.55696,-1.30929>,<1.45374,19.55755,-1.30786>,<1.45241,19.55711,-1.30852>,
            
    /*2*/ <1.42102,19.81017,-1.41388>,<1.42102,19.81057,-1.41293>,<1.42013,19.81027,-1.41337>,
            
    /*3*/ <1.40307,20.07008,-1.50476>,<1.40307,20.07025,-1.50427>,<1.40262,20.07014,-1.50451>,
            
    /*4*/ <1.43213,20.32131,-1.61496>

    /* stem 0.24*/ 
    /*0*/ <0,15.77934,0>,
    /*1*/ <-0.02527,15.77934,0.03609>,<-0.03753,15.80029,-0.00966>,<0.00207,15.79229,-0.04206>,
            <0.03881,15.76639,-0.01633>,<0.02191,15.75839,0.03196>,
    /*2*/ <0.63703,17.16194,0.48191>,<0.62886,17.1759,0.45141>,<0.65526,17.17057,0.42981>,
            <0.67976,17.1533,0.44696>,<0.66849,17.14797,0.47916>,
    /*3*/ <1.16344,18.62785,0.83257>,<1.15875,18.63338,0.81691>,<1.17218,18.63127,0.80627>,
            <1.18517,18.62443,0.81536>,<1.17976,18.62232,0.83162>,
    /*4*/ <1.54693,20.15726,1.08317>

    /* stem 0.24.0*/ 
    /*0*/ <0.09529,15.98083,0.06672>,
    /*1*/ <0.08472,15.9871,0.06286>,<0.10653,15.98286,0.06076>,<0.09462,15.97252,0.07655>,
            
    /*2*/ <0.21586,16.44398,0.46093>,<0.2304,16.44115,0.45952>,<0.22246,16.43426,0.47005>,
            
    /*3*/ <0.38551,16.96688,0.74659>,<0.39268,16.96514,0.74562>,<0.38912,16.96294,0.75176>,
            
    /*4*/ <0.63628,17.47351,1.00232>

    /* stem 0.24.1*/ 
    /*0*/ <0.16723,16.13295,0.1171>,
    /*1*/ <0.16979,16.13569,0.10517>,<0.1765,16.13218,0.12546>,<0.15541,16.13098,0.12067>,
            
    /*2*/ <0.10766,16.72503,0.23162>,<0.11213,16.72268,0.24515>,<0.09807,16.72189,0.24195>,
            
    /*3*/ <0.12549,17.32104,0.33638>,<0.12775,17.31983,0.34313>,<0.12068,17.32029,0.34172>,
            
    /*4*/ <0.15919,17.90546,0.49417>

    /* stem 0.24.2*/ 
    /*0*/ <0.26624,16.3423,0.18643>,
    /*1*/ <0.27718,16.33764,0.18487>,<0.26345,16.34773,0.19674>,<0.2581,16.34152,0.17766>,
            
    /*2*/ <0.46027,16.85046,-0.03329>,<0.45112,16.85719,-0.02538>,<0.44755,16.85305,-0.03809>,
            
    /*3*/ <0.64599,17.38833,-0.17674>,<0.64121,17.39113,-0.1726>,<0.63973,17.38987,-0.17924>,
            
    /*4*/ <0.76524,17.94576,-0.31711>

    /* stem 0.24.3*/ 
    /*0*/ <0.34065,16.49962,0.23852>,
    /*1*/ <0.34304,16.49505,0.24892>,<0.33473,16.50958,0.23779>,<0.34418,16.49424,0.22887>,
            
    /*2*/ <0.83325,16.78967,0.26151>,<0.82771,16.79935,0.25409>,<0.83401,16.78913,0.24815>,
            
    /*3*/ <1.23733,17.18943,0.32745>,<1.23381,17.19367,0.32364>,<1.23831,17.18958,0.32083>,
            
    /*4*/ <1.57384,17.63946,0.43458>

    /* stem 0.24.4*/ 
    /*0*/ <0.44512,16.72052,0.31168>,
    /*1*/ <0.43605,16.72286,0.31757>,<0.44777,16.72672,0.3029>,<0.45154,16.71198,0.31455>,
            
    /*2*/ <0.73592,17.05464,0.64057>,<0.74373,17.05722,0.63079>,<0.74625,17.04738,0.63856>,
            
    /*3*/ <0.99579,17.44733,0.92729>,<0.9996,17.4485,0.9223>,<1.00131,17.44417,0.92668>,
            
    /*4*/ <1.22825,17.88849,1.16314>

    /* stem 0.24.5*/ 
    /*0*/ <0.51029,16.85831,0.35731>,
    /*1*/ <0.50412,16.86357,0.35026>,<0.52098,16.85884,0.35651>,<0.50576,16.85254,0.36515>,
            
    /*2*/ <0.50886,17.29504,0.67315>,<0.5201,17.29189,0.67732>,<0.50996,17.28769,0.68307>,
            
    /*3*/ <0.52203,17.75001,0.961>,<0.52765,17.74853,0.96314>,<0.52259,17.74672,0.96623>,
            
    /*4*/ <0.65206,18.20907,1.21218>

    /* stem 0.24.6*/ 
    /*0*/ <0.61479,17.07927,0.43048>,
    /*1*/ <0.62052,17.07936,0.42203>,<0.61915,17.07782,0.43959>,<0.60469,17.08064,0.42982>,
            
    /*2*/ <0.68464,17.59117,0.475>,<0.68373,17.59014,0.48671>,<0.67409,17.59202,0.4802>,
            
    /*3*/ <0.78111,18.09593,0.54359>,<0.78064,18.09526,0.54942>,<0.77588,18.09661,0.54621>,
            
    /*4*/ <0.92784,18.5832,0.64301>

    /* stem 0.24.7*/ 
    /*0*/ <0.69118,17.26751,0.48397>,
    /*1*/ <0.69968,17.26375,0.48703>,<0.68595,17.27325,0.48992>,<0.68792,17.26552,0.47497>,
            
    /*2*/ <0.93855,17.66769,0.30965>,<0.9294,17.67403,0.31158>,<0.93071,17.66887,0.30161>,
            
    /*3*/ <1.18504,18.10348,0.28838>,<1.18025,18.10628,0.28943>,<1.18176,18.10516,0.2841>,
            
    /*4*/ <1.37875,18.56659,0.28362>

    /* stem 0.24.8*/ 
    /*0*/ <0.75581,17.45041,0.52923>,
    /*1*/ <0.75422,17.44872,0.53831>,<0.75223,17.45808,0.52518>,<0.76098,17.44443,0.52418>,
            
    /*2*/ <1.15572,17.69758,0.65154>,<1.1544,17.70382,0.64278>,<1.16023,17.69472,0.64212>,
            
    /*3*/ <1.46801,18.05252,0.76343>,<1.46675,18.05511,0.75884>,<1.4708,18.05153,0.75889>,
            
    /*4*/ <1.69145,18.46594,0.88597>

    /* stem 0.24.9*/ 
    /*0*/ <0.82528,17.647,0.57786>,
    /*1*/ <0.81682,17.64971,0.57897>,<0.83068,17.65137,0.57223>,<0.82833,17.63991,0.5824>,
            
    /*2*/ <0.95556,17.93053,0.92753>,<0.9648,17.93164,0.92304>,<0.96323,17.924,0.92982>,
            
    /*3*/ <1.16367,18.25435,1.1962>,<1.16787,18.25418,1.1932>,<1.16748,18.25104,1.19729>,
            
    /*4*/ <1.35491,18.62866,1.40308>

    /* stem 0.24.10*/ 
    /*0*/ <0.90993,17.88658,0.63714>,
    /*1*/ <0.90778,17.88925,0.62943>,<0.91795,17.88716,0.63972>,<0.90407,17.88334,0.64228>,
            
    /*2*/ <0.82646,18.2967,0.79633>,<0.83324,18.2953,0.80318>,<0.82399,18.29275,0.80489>,
            
    /*3*/ <0.77006,18.72268,0.92044>,<0.77344,18.72214,0.92391>,<0.76876,18.72123,0.9249>,
            
    /*4*/ <0.83864,19.15788,0.99981>

    /* stem 0.24.11*/ 
    /*0*/ <0.98506,18.0992,0.68975>,
    /*1*/ <0.99169,18.09791,0.68548>,<0.98554,18.10029,0.69764>,<0.97795,18.09939,0.68612>,
            
    /*2*/ <1.03231,18.52104,0.62596>,<1.02821,18.52263,0.63407>,<1.02315,18.52203,0.62638>,
            
    /*3*/ <1.06465,18.94646,0.57755>,<1.06258,18.94711,0.58162>,<1.06006,18.94686,0.57777>,
            
    /*4*/ <1.08622,19.37253,0.52979>

    /* stem 0.24.12*/ 
    /*0*/ <1.07396,18.3508,0.752>,
    /*1*/ <1.07866,18.3479,0.75702>,<1.06812,18.35485,0.75425>,<1.07512,18.34965,0.74472>,
            
    /*2*/ <1.30437,18.6864,0.73797>,<1.29734,18.69104,0.73613>,<1.30201,18.68757,0.72977>,
            
    /*3*/ <1.48633,19.05115,0.73581>,<1.48257,19.05305,0.73489>,<1.48516,19.05174,0.7317>,
            
    /*4*/ <1.65915,19.41954,0.75278>

    /* stem 0.24.13*/ 
    /*0*/ <1.12247,18.48807,0.78596>,
    /*1*/ <1.11854,18.48797,0.79197>,<1.12201,18.49364,0.78146>,<1.12685,18.48259,0.78445>,
            
    /*2*/ <1.41272,18.66892,0.98434>,<1.41504,18.67271,0.97734>,<1.41827,18.66534,0.97933>,
            
    /*3*/ <1.60229,18.95199,1.18344>,<1.60338,18.95381,1.17988>,<1.60585,18.95095,1.18158>,
            
    /*4*/ <1.72428,19.26306,1.39419>

    /* stem 0.24.14*/ 
    /*0*/ <1.18716,18.69025,0.83126>,
    /*1*/ <1.18103,18.69213,0.8291>,<1.1927,18.69305,0.82856>,<1.18776,18.68557,0.83612>,
            
    /*2*/ <1.17368,18.96305,1.09253>,<1.18147,18.96367,1.09217>,<1.17817,18.95868,1.09721>,
            
    /*3*/ <1.20713,19.27728,1.30001>,<1.21101,19.27722,1.29953>,<1.20939,19.27538,1.30257>,
            
    /*4*/ <1.2999,19.61216,1.44913>

    /* stem 0.24.15*/ 
    /*0*/ <1.25318,18.95944,0.87748>,
    /*1*/ <1.25404,18.96028,0.87135>,<1.258,18.95999,0.88142>,<1.24749,18.95805,0.87968>,
            
    /*2*/ <1.18331,19.30638,0.91102>,<1.18595,19.30619,0.91773>,<1.17894,19.30489,0.91657>,
            
    /*3*/ <1.18885,19.66123,0.91261>,<1.19019,19.66121,0.91596>,<1.18662,19.66127,0.91544>,
            
    /*4*/ <1.22053,20.01456,0.93688>

    /* stem 0.24.16*/ 
    /*0*/ <1.31109,19.1956,0.91804>,
    /*1*/ <1.31671,19.19434,0.91732>,<1.30923,19.19782,0.92307>,<1.30733,19.19464,0.91372>,
            
    /*2*/ <1.36938,19.50487,0.80102>,<1.36439,19.50718,0.80485>,<1.36312,19.50507,0.79862>,
            
    /*3*/ <1.43817,19.82846,0.74408>,<1.43563,19.82937,0.74607>,<1.43511,19.8289,0.74279>,
            
    /*4*/ <1.50244,20.14672,0.6586>

    /* stem 0.24.17*/ 
    /*0*/ <1.36276,19.40628,0.95421>,
    /*1*/ <1.36437,19.40502,0.95922>,<1.35918,19.41027,0.95344>,<1.36472,19.40355,0.94998>,
            
    /*2*/ <1.60237,19.61456,0.93326>,<1.59891,19.61806,0.92941>,<1.6026,19.61358,0.9271>,
            
    /*3*/ <1.74859,19.89721,0.94027>,<1.74643,19.8984,0.93835>,<1.74901,19.89709,0.93717>,
            
    /*4*/ <1.86469,20.19034,0.98209>

    /* stem 0.24.18*/ 
    /*0*/ <1.40708,19.58702,0.98525>,
    /*1*/ <1.40284,19.58758,0.98799>,<1.40774,19.58971,0.981>,<1.41067,19.58375,0.98676>,
            
    /*2*/ <1.53734,19.80756,1.14727>,<1.5406,19.80898,1.14261>,<1.54255,19.805,1.14645>,
            
    /*3*/ <1.67537,20.04838,1.26949>,<1.67685,20.04882,1.26699>,<1.67798,20.0471,1.26909>,
            
    /*4*/ <1.7854,20.31704,1.35631>

    /* stem 0.24.19*/ 
    /*0*/ <1.4561,19.78687,1.01957>,
    /*1*/ <1.4537,19.78788,1.01714>,<1.4595,19.78786,1.01923>,<1.45509,19.78489,1.02234>,
            
    /*2*/ <1.40105,20.02504,1.16876>,<1.40492,20.02503,1.17015>,<1.40198,20.02305,1.17223>,
            
    /*3*/ <1.36699,20.27537,1.30355>,<1.36893,20.2753,1.30421>,<1.36743,20.27448,1.30534>,
            
    /*4*/ <1.36451,20.54288,1.40567>

    /* stem 0.24.20*/ 
    /*0*/ <1.53309,20.10084,1.07348>,
    /*1*/ <1.53338,20.10084,1.07302>,<1.53334,20.10092,1.07396>,<1.53256,20.10074,1.07346>,
            
    /*2*/ <1.48934,20.35621,1.05011>,<1.48931,20.35626,1.05073>,<1.4888,20.35615,1.05041>,
            
    /*3*/ <1.46317,20.61363,1.0233>,<1.46316,20.61366,1.02361>,<1.4629,20.61362,1.02344>,
            
    /*4*/ <1.4676,20.87314,1.00571>

    /* stem 0.25*/ 
    /*0*/ <0,16.25546,0>,
    /*1*/ <-0.03906,16.25546,-0.01578>,<0.00093,16.27549,-0.03705>,<0.03964,16.26784,-0.00712>,
            <0.02357,16.24308,0.03265>,<-0.02507,16.23542,0.0273>,
    /*2*/ <-0.31497,17.59137,0.7046>,<-0.28831,17.60472,0.69042>,<-0.2625,17.59962,0.71038>,
            <-0.27322,17.58311,0.73689>,<-0.30564,17.57801,0.73332>,
    /*3*/ <-0.53083,19.00779,1.27636>,<-0.51724,19.01308,1.26862>,<-0.50443,19.01106,1.27885>,
            <-0.51011,19.00452,1.2929>,<-0.52643,19.0025,1.29137>,
    /*4*/ <-0.68354,20.48556,1.69182>

    /* stem 0.25.0*/ 
    /*0*/ <-0.03574,16.42068,0.08845>,
    /*1*/ <-0.0344,16.42672,0.07771>,<-0.02825,16.42327,0.09798>,<-0.04455,16.41206,0.08965>,
            
    /*2*/ <-0.42119,16.84571,0.27002>,<-0.41709,16.84341,0.28353>,<-0.42796,16.83593,0.27798>,
            
    /*3*/ <-0.81372,17.27247,0.42943>,<-0.81196,17.27159,0.43631>,<-0.81728,17.26775,0.43346>,
            
    /*4*/ <-1.1744,17.72811,0.58523>

    /* stem 0.25.1*/ 
    /*0*/ <-0.07506,16.60251,0.18578>,
    /*1*/ <-0.06341,16.60512,0.1856>,<-0.08105,16.60266,0.19611>,<-0.08072,16.59974,0.17563>,
            
    /*2*/ <-0.19547,17.16899,0.10302>,<-0.20724,17.16735,0.11003>,<-0.20701,17.1654,0.09638>,
            
    /*3*/ <-0.43422,17.70315,0.06229>,<-0.43971,17.70101,0.06587>,<-0.43967,17.7005,0.05899>,
            
    /*4*/ <-0.59644,18.26279,0.1077>

    /* stem 0.25.2*/ 
    /*0*/ <-0.10997,16.76392,0.27218>,
    /*1*/ <-0.10614,16.75943,0.28211>,<-0.12028,16.76911,0.27179>,<-0.10349,16.76321,0.26265>,
            
    /*2*/ <0.13816,17.25861,0.40908>,<0.12874,17.26506,0.40219>,<0.13993,17.26113,0.3961>,
            
    /*3*/ <0.23483,17.80092,0.55826>,<0.22973,17.80291,0.55445>,<0.23587,17.80253,0.55188>,
            
    /*4*/ <0.35111,18.35268,0.64437>

    /* stem 0.25.3*/ 
    /*0*/ <-0.15892,16.99027,0.39335>,
    /*1*/ <-0.16802,16.98593,0.39777>,<-0.15969,16.99882,0.38648>,<-0.14906,16.98604,0.3958>,
            
    /*2*/ <-0.12262,17.33239,0.82143>,<-0.11707,17.34099,0.8139>,<-0.10998,17.33246,0.82011>,
            
    /*3*/ <-0.12466,17.74707,1.18172>,<-0.1219,17.75086,1.17744>,<-0.11833,17.74742,1.18141>,
            
    /*4*/ <-0.14876,18.21151,1.47414>

    /* stem 0.25.4*/ 
    /*0*/ <-0.19173,17.14197,0.47456>,
    /*1*/ <-0.19922,17.14422,0.46734>,<-0.18374,17.14879,0.47624>,<-0.19224,17.1329,0.4801>,
            
    /*2*/ <-0.48621,17.38995,0.84633>,<-0.47589,17.39299,0.85227>,<-0.48156,17.3824,0.85484>,
            
    /*3*/ <-0.77821,17.73112,1.13532>,<-0.7732,17.7328,1.13847>,<-0.77667,17.72814,1.14046>,
            
    /*4*/ <-1.00037,18.1425,1.39588>

    /* stem 0.25.5*/ 
    /*0*/ <-0.23982,17.36428,0.59357>,
    /*1*/ <-0.23466,17.36923,0.58641>,<-0.23746,17.36559,0.60331>,<-0.24733,17.35804,0.59097>,
            
    /*2*/ <-0.57066,17.75777,0.61751>,<-0.57253,17.75534,0.62877>,<-0.57911,17.75031,0.62055>,
            
    /*3*/ <-0.88446,18.15644,0.70545>,<-0.88505,18.15479,0.71102>,<-0.88875,18.15278,0.70697>,
            
    /*4*/ <-1.1258,18.60849,0.74528>

    /* stem 0.25.6*/ 
    /*0*/ <-0.27338,17.51949,0.67665>,
    /*1*/ <-0.26429,17.51957,0.68016>,<-0.28094,17.52087,0.68265>,<-0.27492,17.51802,0.66714>,
            
    /*2*/ <-0.24091,18.01262,0.59872>,<-0.25201,18.01349,0.60038>,<-0.24799,18.01159,0.59004>,
            
    /*3*/ <-0.18362,18.50688,0.64012>,<-0.18915,18.50748,0.64099>,<-0.18709,18.50768,0.63576>,
            
    /*4*/ <-0.16036,19.00529,0.67934>

    /* stem 0.25.7*/ 
    /*0*/ <-0.30907,17.71601,0.76497>,
    /*1*/ <-0.31009,17.71243,0.77351>,<-0.3164,17.71968,0.76056>,<-0.30073,17.71591,0.76086>,
            
    /*2*/ <-0.20974,18.14481,0.96337>,<-0.21395,18.14964,0.95475>,<-0.2035,18.14713,0.95494>,
            
    /*3*/ <-0.20691,18.58956,1.15103>,<-0.20906,18.59151,1.14651>,<-0.20372,18.59125,1.14705>,
            
    /*4*/ <-0.25786,19.03856,1.32117>

    /* stem 0.25.8*/ 
    /*0*/ <-0.34466,17.93625,0.85306>,
    /*1*/ <-0.35333,17.93466,0.85353>,<-0.3417,17.94335,0.84872>,<-0.33895,17.93074,0.85693>,
            
    /*2*/ <-0.37505,18.18411,1.24368>,<-0.3673,18.1899,1.24047>,<-0.36547,18.1815,1.24595>,
            
    /*3*/ <-0.35305,18.50669,1.57694>,<-0.34917,18.50895,1.57454>,<-0.34826,18.50532,1.57799>,
            
    /*4*/ <-0.27371,18.913,1.78675>

    /* stem 0.25.9*/ 
    /*0*/ <-0.37537,18.12629,0.92907>,
    /*1*/ <-0.37817,18.12884,0.92155>,<-0.36902,18.13036,0.9328>,<-0.37892,18.11965,0.93285>,
            
    /*2*/ <-0.66993,18.39942,1.12526>,<-0.66383,18.40043,1.13276>,<-0.67043,18.39329,1.13279>,
            
    /*3*/ <-0.85704,18.76173,1.30807>,<-0.85362,18.76178,1.31153>,<-0.85775,18.7593,1.31222>,
            
    /*4*/ <-0.98969,19.15552,1.47277>

    /* stem 0.25.10*/ 
    /*0*/ <-0.39658,18.25754,0.98156>,
    /*1*/ <-0.3898,18.26011,0.97786>,<-0.39696,18.25737,0.98969>,<-0.40297,18.25512,0.97713>,
            
    /*2*/ <-0.54636,18.66659,0.97989>,<-0.55114,18.66476,0.98777>,<-0.55514,18.66326,0.9794>,
            
    /*3*/ <-0.62078,19.09464,0.99487>,<-0.62323,19.0941,0.99885>,<-0.62541,19.09387,0.99469>,
            
    /*4*/ <-0.65291,19.5286,1.00819>

    /* stem 0.25.11*/ 
    /*0*/ <-0.43548,18.49832,1.07786>,
    /*1*/ <-0.43008,18.49709,1.08312>,<-0.4428,18.49888,1.07996>,<-0.43356,18.49898,1.0705>,
            
    /*2*/ <-0.38621,18.90668,1.1302>,<-0.39469,18.90787,1.12809>,<-0.38853,18.90794,1.12179>,
            
    /*3*/ <-0.41954,19.30852,1.22771>,<-0.42379,19.30847,1.22653>,<-0.42068,19.30945,1.22356>,
            
    /*4*/ <-0.48813,19.70968,1.30805>

    /* stem 0.25.12*/ 
    /*0*/ <-0.46931,18.70766,1.16158>,
    /*1*/ <-0.47302,18.70486,1.16709>,<-0.4727,18.71158,1.15658>,<-0.46221,18.70653,1.16108>,
            
    /*2*/ <-0.40478,19.0339,1.37729>,<-0.40457,19.03838,1.37029>,<-0.39758,19.03502,1.37328>,
            
    /*3*/ <-0.31514,19.35892,1.58595>,<-0.31505,19.36117,1.58246>,<-0.31158,19.35933,1.58384>,
            
    /*4*/ <-0.34553,19.72113,1.74394>

    /* stem 0.25.13*/ 
    /*0*/ <-0.50924,18.95476,1.26041>,
    /*1*/ <-0.51553,18.95467,1.2581>,<-0.50475,18.95895,1.25774>,<-0.50744,18.95067,1.2654>,
            
    /*2*/ <-0.60912,19.21701,1.50895>,<-0.60194,19.21987,1.5087>,<-0.60373,19.21435,1.51381>,
            
    /*3*/ <-0.72149,19.50248,1.72371>,<-0.71792,19.50397,1.72364>,<-0.71892,19.50148,1.72642>,
            
    /*4*/ <-0.81384,19.81413,1.91052>

    /* stem 0.25.14*/ 
    /*0*/ <-0.53244,19.13823,1.31783>,
    /*1*/ <-0.53176,19.13998,1.31177>,<-0.52852,19.14053,1.32225>,<-0.53703,19.13418,1.31946>,
            
    /*2*/ <-0.75575,19.41512,1.36878>,<-0.75359,19.41548,1.37577>,<-0.75927,19.41124,1.37391>,
            
    /*3*/ <-0.92859,19.72704,1.40988>,<-0.92749,19.72721,1.41337>,<-0.93065,19.72557,1.41253>,
            
    /*4*/ <-1.05587,20.05966,1.45742>

    /* stem 0.25.15*/ 
    /*0*/ <-0.55358,19.32674,1.37016>,
    /*1*/ <-0.54768,19.32755,1.36964>,<-0.55618,19.32704,1.37553>,<-0.55688,19.32564,1.36529>,
            
    /*2*/ <-0.5994,19.66451,1.32684>,<-0.60507,19.66418,1.33076>,<-0.60553,19.66324,1.32394>,
            
    /*3*/ <-0.57747,20.00588,1.34916>,<-0.58029,20.00595,1.35115>,<-0.58059,20.0062,1.34772>,
            
    /*4*/ <-0.61016,20.33447,1.44536>

    /* stem 0.25.16*/ 
    /*0*/ <-0.57253,19.49576,1.41707>,
    /*1*/ <-0.57062,19.49453,1.42226>,<-0.57785,19.49758,1.41637>,<-0.56913,19.49516,1.41258>,
            
    /*2*/ <-0.46916,19.80612,1.45645>,<-0.47398,19.80816,1.45252>,<-0.46817,19.80654,1.45>,
            
    /*3*/ <-0.39629,20.12024,1.52299>,<-0.39871,20.12123,1.52103>,<-0.39571,20.12079,1.51982>,
            
    /*4*/ <-0.38684,20.43019,1.63396>

    /* stem 0.25.17*/ 
    /*0*/ <-0.60329,19.77,1.4932>,
    /*1*/ <-0.6076,19.76881,1.49577>,<-0.6035,19.77321,1.48916>,<-0.59877,19.768,1.49466>,
            
    /*2*/ <-0.5609,20.00789,1.68189>,<-0.55817,20.01082,1.67749>,<-0.55501,20.00735,1.68116>,
            
    /*3*/ <-0.55673,20.25496,1.86276>,<-0.55536,20.25652,1.86063>,<-0.55376,20.25502,1.86264>,
            
    /*4*/ <-0.58004,20.51934,2.01614>

    /* stem 0.25.18*/ 
    /*0*/ <-0.62092,19.92718,1.53682>,
    /*1*/ <-0.62439,19.92772,1.53345>,<-0.61688,19.92989,1.53662>,<-0.62148,19.92391,1.5404>,
            
    /*2*/ <-0.75237,20.13198,1.70081>,<-0.74736,20.13343,1.70293>,<-0.75043,20.12945,1.70544>,
            
    /*3*/ <-0.86802,20.3581,1.84763>,<-0.86548,20.35876,1.84864>,<-0.86714,20.35699,1.85006>,
            
    /*4*/ <-0.96946,20.58597,2.00238>

    /* stem 0.25.19*/ 
    /*0*/ <-0.64348,20.12837,1.59267>,
    /*1*/ <-0.64173,20.12933,1.58992>,<-0.64213,20.12876,1.59576>,<-0.64658,20.12702,1.59233>,
            
    /*2*/ <-0.75429,20.38141,1.60775>,<-0.75455,20.38103,1.61164>,<-0.75751,20.37987,1.60935>,
            
    /*3*/ <-0.808,20.64904,1.652>,<-0.80808,20.64871,1.65393>,<-0.8097,20.64857,1.65285>,
            
    /*4*/ <-0.88451,20.91118,1.69661>

    /* stem 0.25.20*/ 
    /*0*/ <-0.67656,20.42333,1.67455>,
    /*1*/ <-0.676,20.42334,1.67474>,<-0.677,20.42347,1.67491>,<-0.67668,20.42318,1.67399>,
            
    /*2*/ <-0.65626,20.66502,1.60613>,<-0.65693,20.66511,1.60625>,<-0.65671,20.66492,1.60563>,
            
    /*3*/ <-0.62275,20.90956,1.55543>,<-0.62308,20.90962,1.55549>,<-0.62297,20.90954,1.55517>,
            
    /*4*/ <-0.57059,21.15606,1.55168>

    /* stem 0.26*/ 
    /*0*/ <0,16.82139,0>,
    /*1*/ <0.00623,16.82139,-0.03933>,<0.03432,16.84032,-0.00702>,<0.01498,16.83309,0.03499>,
            <-0.02506,16.80969,0.02865>,<-0.03047,16.80245,-0.01728>,
    /*2*/ <-0.72526,18.10051,-0.14175>,<-0.70653,18.11314,-0.12021>,<-0.71943,18.10832,-0.0922>,
            <-0.74612,18.09271,-0.09643>,<-0.74972,18.08789,-0.12705>,
    /*3*/ <-1.30515,19.45673,-0.22015>,<-1.29513,19.46173,-0.20928>,<-1.30183,19.45982,-0.19532>,
            <-1.31598,19.45364,-0.19756>,<-1.31803,19.45173,-0.21291>,
    /*4*/ <-1.72562,20.87169,-0.27331>

    /* stem 0.26.0*/ 
    /*0*/ <-0.07804,16.95824,-0.01236>,
    /*1*/ <-0.06782,16.96397,-0.01342>,<-0.08529,16.96075,-0.00345>,<-0.081,16.95,-0.02021>,
            
    /*2*/ <-0.33054,17.36438,-0.33737>,<-0.34219,17.36223,-0.33072>,<-0.33933,17.35506,-0.3419>,
            
    /*3*/ <-0.6448,17.82643,-0.48739>,<-0.6499,17.8243,-0.48345>,<-0.64961,17.82238,-0.48996>,
            
    /*4*/ <-0.91702,18.32722,-0.58229>

    /* stem 0.26.1*/ 
    /*0*/ <-0.18534,17.14642,-0.02936>,
    /*1*/ <-0.18269,17.14889,-0.01865>,<-0.19617,17.14622,-0.0326>,<-0.17717,17.14413,-0.03682>,
            
    /*2*/ <-0.15359,17.69195,-0.1555>,<-0.16258,17.69017,-0.16481>,<-0.1499,17.68878,-0.16762>,
            
    /*3*/ <-0.21073,18.2476,-0.19148>,<-0.21526,18.24687,-0.19612>,<-0.20897,18.24741,-0.19776>,
            
    /*4*/ <-0.25948,18.80367,-0.24649>

    /* stem 0.26.2*/ 
    /*0*/ <-0.28188,17.3157,-0.04464>,
    /*1*/ <-0.29019,17.31146,-0.03902>,<-0.28339,17.31906,-0.0549>,<-0.27205,17.31657,-0.04002>,
            
    /*2*/ <-0.41722,17.80998,0.14137>,<-0.41268,17.81504,0.13078>,<-0.40513,17.81338,0.1407>,
            
    /*3*/ <-0.6507,18.29213,0.23914>,<-0.64835,18.2944,0.23376>,<-0.64505,18.29491,0.2391>,
            
    /*4*/ <-0.89135,18.77955,0.1922>

    /* stem 0.26.3*/ 
    /*0*/ <-0.37348,17.47633,-0.05915>,
    /*1*/ <-0.37955,17.47219,-0.06667>,<-0.36827,17.48529,-0.06094>,<-0.3726,17.47151,-0.04985>,
            
    /*2*/ <-0.79163,17.75023,0.11802>,<-0.78412,17.75897,0.12184>,<-0.787,17.74978,0.12923>,
            
    /*3*/ <-1.19964,18.06949,0.22921>,<-1.1958,18.07379,0.2311>,<-1.19794,18.06969,0.23503>,
            
    /*4*/ <-1.53429,18.45226,0.38219>

    /* stem 0.26.4*/ 
    /*0*/ <-0.49052,17.68159,-0.07769>,
    /*1*/ <-0.48548,17.68371,-0.08609>,<-0.48992,17.68774,-0.0698>,<-0.49617,17.67332,-0.07718>,
            
    /*2*/ <-0.88893,17.9466,-0.25813>,<-0.89189,17.94928,-0.24727>,<-0.89606,17.93967,-0.25219>,
            
    /*3*/ <-1.24227,18.29111,-0.39156>,<-1.24339,18.29217,-0.38598>,<-1.24634,18.28806,-0.38879>,
            
    /*4*/ <-1.51593,18.71595,-0.46926>

    /* stem 0.26.5*/ 
    /*0*/ <-0.5684,17.81816,-0.09003>,
    /*1*/ <-0.5606,17.82291,-0.08675>,<-0.57686,17.81889,-0.08532>,<-0.56775,17.81268,-0.09802>,
            
    /*2*/ <-0.68526,18.21551,-0.36792>,<-0.6961,18.21283,-0.36697>,<-0.69003,18.2087,-0.37543>,
            
    /*3*/ <-0.81722,18.67839,-0.4945>,<-0.82262,18.67703,-0.49395>,<-0.82007,18.67641,-0.49889>,
            
    /*4*/ <-0.90675,19.15371,-0.61499>

    /* stem 0.26.6*/ 
    /*0*/ <-0.67954,18.01306,-0.10763>,
    /*1*/ <-0.68085,18.01314,-0.09847>,<-0.6868,18.01358,-0.11335>,<-0.67097,18.01246,-0.11107>,
            
    /*2*/ <-0.64681,18.49266,-0.10095>,<-0.65078,18.49295,-0.11086>,<-0.64023,18.49221,-0.10935>,
            
    /*3*/ <-0.72577,18.96445,-0.06135>,<-0.72779,18.96456,-0.0663>,<-0.72256,18.96537,-0.06552>,
            
    /*4*/ <-0.82234,19.4282,0.01896>

    /* stem 0.26.7*/ 
    /*0*/ <-0.7666,18.1878,-0.12142>,
    /*1*/ <-0.77473,18.18439,-0.12053>,<-0.76423,18.19172,-0.12901>,<-0.76083,18.18728,-0.11471>,
            
    /*2*/ <-0.92506,18.59326,0.04223>,<-0.91806,18.59815,0.03658>,<-0.91579,18.59519,0.04611>,
            
    /*3*/ <-1.05944,19.01607,0.18261>,<-1.05583,19.01822,0.17968>,<-1.05478,19.01695,0.18452>,
            
    /*4*/ <-1.21436,19.44915,0.25093>

    /* stem 0.26.8*/ 
    /*0*/ <-0.88765,18.47191,-0.14059>,
    /*1*/ <-0.88989,18.47043,-0.14839>,<-0.88268,18.47828,-0.13886>,<-0.89036,18.46703,-0.13451>,
            
    /*2*/ <-1.24071,18.73086,-0.09395>,<-1.2359,18.73609,-0.08759>,<-1.24102,18.72859,-0.08469>,
            
    /*3*/ <-1.53303,19.05252,-0.02025>,<-1.53002,19.05459,-0.01719>,<-1.53317,19.05137,-0.01563>,
            
    /*4*/ <-1.74219,19.43207,0.05899>

    /* stem 0.26.9*/ 
    /*0*/ <-0.98015,18.68903,-0.15524>,
    /*1*/ <-0.97395,18.6914,-0.15933>,<-0.98137,18.69182,-0.14806>,<-0.98512,18.68388,-0.15833>,
            
    /*2*/ <-1.20309,19.00679,-0.31927>,<-1.20804,19.00706,-0.31176>,<-1.21054,19.00178,-0.3186>,
            
    /*3*/ <-1.39823,19.36504,-0.42424>,<-1.40055,19.36493,-0.42038>,<-1.40222,19.36295,-0.42406>,
            
    /*4*/ <-1.54899,19.75426,-0.48107>

    /* stem 0.26.10*/ 
    /*0*/ <-1.0698,18.89945,-0.16944>,
    /*1*/ <-1.06516,18.90178,-0.16422>,<-1.07701,18.90076,-0.1688>,<-1.06722,18.89581,-0.17529>,
            
    /*2*/ <-1.02067,19.24985,-0.36248>,<-1.02857,19.24918,-0.36554>,<-1.02204,19.24588,-0.36987>,
            
    /*3*/ <-1.01688,19.63117,-0.4917>,<-1.02084,19.63073,-0.49317>,<-1.01754,19.62985,-0.49569>,
            
    /*4*/ <-1.11371,20.01739,-0.55466>

    /* stem 0.26.11*/ 
    /*0*/ <-1.17605,19.14885,-0.18627>,
    /*1*/ <-1.17956,19.14775,-0.18049>,<-1.17929,19.15117,-0.19184>,<-1.16932,19.14764,-0.18647>,
            
    /*2*/ <-1.11055,19.50696,-0.07277>,<-1.11036,19.50924,-0.08034>,<-1.10372,19.50689,-0.07675>,
            
    /*3*/ <-1.06085,19.88562,-0.05838>,<-1.06087,19.88579,-0.06233>,<-1.05746,19.88527,-0.06039>,
            
    /*4*/ <-1.08682,20.25847,-0.13517>

    /* stem 0.26.12*/ 
    /*0*/ <-1.24415,19.30869,-0.19705>,
    /*1*/ <-1.24977,19.30615,-0.1992>,<-1.24121,19.31343,-0.20043>,<-1.24148,19.30649,-0.19153>,
            
    /*2*/ <-1.43491,19.55912,-0.00762>,<-1.4292,19.56397,-0.00844>,<-1.42939,19.55934,-0.0025>,
            
    /*3*/ <-1.57287,19.85199,0.16733>,<-1.56972,19.85392,0.16661>,<-1.57,19.8519,0.16977>,
            
    /*4*/ <-1.7273,20.16242,0.28836>

    /* stem 0.26.13*/ 
    /*0*/ <-1.33781,19.56016,-0.21189>,
    /*1*/ <-1.33706,19.5601,-0.21787>,<-1.33406,19.56336,-0.20842>,<-1.3423,19.55701,-0.20937>,
            
    /*2*/ <-1.54561,19.8347,-0.24453>,<-1.54361,19.83688,-0.23823>,<-1.5491,19.83265,-0.23887>,
            
    /*3*/ <-1.66375,20.15981,-0.23038>,<-1.66238,20.16019,-0.2272>,<-1.66564,20.15902,-0.22756>,
            
    /*4*/ <-1.76023,20.4914,-0.2455>

    /* stem 0.26.14*/ 
    /*0*/ <-1.38715,19.72702,-0.2197>,
    /*1*/ <-1.38169,19.7286,-0.22034>,<-1.39023,19.72906,-0.21534>,<-1.38952,19.72339,-0.22343>,
            
    /*2*/ <-1.4797,19.98436,-0.40782>,<-1.48539,19.98466,-0.40449>,<-1.48492,19.98089,-0.40988>,
            
    /*3*/ <-1.55595,20.25976,-0.57613>,<-1.55881,20.25998,-0.5745>,<-1.55865,20.25829,-0.57733>,
            
    /*4*/ <-1.64124,20.5742,-0.63977>

    /* stem 0.26.15*/ 
    /*0*/ <-1.45384,19.95258,-0.23027>,
    /*1*/ <-1.45222,19.9533,-0.22527>,<-1.45879,19.95388,-0.23166>,<-1.45052,19.95057,-0.23387>,
            
    /*2*/ <-1.35669,20.24207,-0.29943>,<-1.36107,20.24246,-0.30369>,<-1.35556,20.24026,-0.30516>,
            
    /*3*/ <-1.32273,20.54519,-0.37075>,<-1.32501,20.54498,-0.37279>,<-1.32212,20.54445,-0.37366>,
            
    /*4*/ <-1.36567,20.83722,-0.47609>

    /* stem 0.26.16*/ 
    /*0*/ <-1.51703,20.16628,-0.24027>,
    /*1*/ <-1.52104,20.16521,-0.23765>,<-1.51748,20.16826,-0.24474>,<-1.51258,20.16535,-0.23843>,
            
    /*2*/ <-1.51303,20.43548,-0.1191>,<-1.51065,20.43751,-0.12383>,<-1.50738,20.43557,-0.11962>,
            
    /*3*/ <-1.51405,20.71275,-0.01758>,<-1.51286,20.71365,-0.01999>,<-1.51122,20.71286,-0.01782>,
            
    /*4*/ <-1.53608,20.99831,0.05407>

    /* stem 0.26.17*/ 
    /*0*/ <-1.57868,20.37477,-0.25004>,
    /*1*/ <-1.58174,20.37372,-0.25322>,<-1.57581,20.37821,-0.25071>,<-1.5785,20.37238,-0.24619>,
            
    /*2*/ <-1.76259,20.54857,-0.13531>,<-1.75863,20.55157,-0.13363>,<-1.76043,20.54768,-0.13062>,
            
    /*3*/ <-1.90692,20.7675,-0.04298>,<-1.90469,20.7687,-0.04229>,<-1.90593,20.76716,-0.04057>,
            
    /*4*/ <-1.98609,21.02834,0.01149>

    /* stem 0.26.18*/ 
    /*0*/ <-1.64563,20.60118,-0.26064>,
    /*1*/ <-1.64433,20.60147,-0.2628>,<-1.64508,20.60263,-0.25863>,<-1.64748,20.59946,-0.2605>,
            
    /*2*/ <-1.81595,20.77834,-0.34215>,<-1.81646,20.77911,-0.33937>,<-1.81806,20.777,-0.34062>,
            
    /*3*/ <-1.98974,20.96355,-0.39328>,<-1.98988,20.96381,-0.39184>,<-1.99075,20.96282,-0.39249>,
            
    /*4*/ <-2.15456,21.16339,-0.39214>

    /* stem 0.26.19*/ 
    /*0*/ <-1.69999,20.78501,-0.26925>,
    /*1*/ <-1.69925,20.78524,-0.26899>,<-1.70066,20.7853,-0.26888>,<-1.70006,20.7845,-0.26988>,
            
    /*2*/ <-1.70443,20.97428,-0.42248>,<-1.70537,20.97432,-0.42241>,<-1.70497,20.97379,-0.42307>,
            
    /*3*/ <-1.76334,21.17482,-0.54768>,<-1.7638,21.17475,-0.54758>,<-1.76361,21.17456,-0.54797>,
            
    /*4*/ <-1.83754,21.38579,-0.64417>

    /* stem 0.27*/ 
    /*0*/ <0,17.36706,0>,
    /*1*/ <0.03748,17.36706,-0.00262>,<0.01374,17.38492,0.03006>,<-0.02898,17.3781,0.0212>,
            <-0.03165,17.35602,-0.01696>,<0.00942,17.34919,-0.03168>,
    /*2*/ <-0.02428,18.59018,-0.7062>,<-0.0401,18.60209,-0.68441>,<-0.06858,18.59754,-0.69032>,
            <-0.07036,18.58282,-0.71575>,<-0.04298,18.57827,-0.72557>,
    /*3*/ <-0.07579,19.88701,-1.26336>,<-0.08366,19.89173,-1.25185>,<-0.09792,19.88993,-1.25504>,
            <-0.09886,19.8841,-1.26852>,<-0.08518,19.8823,-1.27367>,
    /*4*/ <-0.11654,21.24002,-1.66656>

    /* stem 0.27.0*/ 
    /*0*/ <-0.00538,17.50065,-0.07694>,
    /*1*/ <-0.00224,17.50606,-0.06778>,<-0.01465,17.50365,-0.08225>,<0.00074,17.49225,-0.0808>,
            
    /*2*/ <0.28801,17.85818,-0.37945>,<0.27974,17.85658,-0.3891>,<0.29,17.84897,-0.38813>,
            
    /*3*/ <0.43911,18.28412,-0.69765>,<0.43454,18.28263,-0.70188>,<0.4404,18.28011,-0.70247>,
            
    /*4*/ <0.43844,18.78484,-0.93045>

    /* stem 0.27.1*/ 
    /*0*/ <-0.01538,17.7489,-0.21992>,
    /*1*/ <-0.02451,17.7512,-0.21528>,<-0.01505,17.74704,-0.23025>,<-0.00657,17.74846,-0.21423>,
            
    /*2*/ <0.06259,18.26556,-0.30692>,<0.0689,18.26279,-0.3169>,<0.07455,18.26373,-0.30622>,
            
    /*3*/ <0.17314,18.77949,-0.37279>,<0.17632,18.7782,-0.37778>,<0.17907,18.7783,-0.37238>,
            
    /*4*/ <0.23918,19.29488,-0.47481>

    /* stem 0.27.2*/ 
    /*0*/ <-0.0207,17.88103,-0.29602>,
    /*1*/ <-0.02757,17.87707,-0.30241>,<-0.0123,17.88548,-0.29969>,<-0.02222,17.88054,-0.28596>,
            
    /*2*/ <-0.27257,18.33267,-0.31569>,<-0.26239,18.33828,-0.31387>,<-0.26901,18.33499,-0.30472>,
            
    /*3*/ <-0.46627,18.80924,-0.37343>,<-0.46095,18.81156,-0.37248>,<-0.46461,18.81062,-0.36797>,
            
    /*4*/ <-0.59719,19.29185,-0.5065>

    /* stem 0.27.3*/ 
    /*0*/ <-0.02905,18.08844,-0.41548>,
    /*1*/ <-0.02356,18.08462,-0.4225>,<-0.02587,18.09611,-0.41046>,<-0.03773,18.0846,-0.41348>,
            
    /*2*/ <-0.23716,18.39123,-0.75216>,<-0.2387,18.39888,-0.74414>,<-0.2466,18.39121,-0.74615>,
            
    /*3*/ <-0.37824,18.71165,-1.10579>,<-0.37908,18.7156,-1.10192>,<-0.38326,18.71217,-1.10336>,
            
    /*4*/ <-0.5201,19.08347,-1.40632>

    /* stem 0.27.4*/ 
    /*0*/ <-0.03595,18.25962,-0.51407>,
    /*1*/ <-0.0273,18.26159,-0.51126>,<-0.04277,18.26581,-0.5128>,<-0.03777,18.25146,-0.51814>,
            
    /*2*/ <0.0658,18.4548,-0.94346>,<0.05549,18.45762,-0.94449>,<0.05882,18.44806,-0.94805>,
            
    /*3*/ <0.22339,18.73498,-1.30154>,<0.21837,18.73662,-1.3025>,<0.2203,18.7323,-1.30503>,
            
    /*4*/ <0.33345,19.09825,-1.59944>

    /* stem 0.27.5*/ 
    /*0*/ <-0.04728,18.54096,-0.6761>,
    /*1*/ <-0.04856,18.54519,-0.66867>,<-0.05366,18.54041,-0.68192>,<-0.03961,18.53728,-0.67772>,
            
    /*2*/ <0.09611,18.93045,-0.86627>,<0.09271,18.92726,-0.8751>,<0.10207,18.92518,-0.8723>,
            
    /*3*/ <0.20099,19.33611,-1.04648>,<0.1993,19.3346,-1.05094>,<0.2041,19.3339,-1.04971>,
            
    /*4*/ <0.3169,19.74892,-1.20275>

    /* stem 0.27.6*/ 
    /*0*/ <-0.05067,18.63716,-0.72467>,
    /*1*/ <-0.05908,18.63722,-0.72394>,<-0.0471,18.63719,-0.73231>,<-0.04584,18.63707,-0.71775>,
            
    /*2*/ <-0.0529,19.08503,-0.72101>,<-0.04491,19.08501,-0.72659>,<-0.04407,19.08493,-0.71688>,
            
    /*3*/ <-0.01349,19.51936,-0.82525>,<-0.00952,19.51839,-0.82791>,<-0.00908,19.51948,-0.82318>,
            
    /*4*/ <-0.0222,19.95769,-0.91523>

    /* stem 0.27.7*/ 
    /*0*/ <-0.05635,18.82568,-0.80579>,
    /*1*/ <-0.05879,18.82259,-0.8128>,<-0.05006,18.83069,-0.80557>,<-0.06019,18.82376,-0.79899>,
            
    /*2*/ <-0.32329,19.15925,-0.86605>,<-0.31748,19.16465,-0.86123>,<-0.32423,19.16003,-0.85685>,
            
    /*3*/ <-0.55812,19.51954,-0.90497>,<-0.55496,19.5219,-0.90251>,<-0.55851,19.51982,-0.90035>,
            
    /*4*/ <-0.74669,19.90238,-0.96838>

    /* stem 0.27.8*/ 
    /*0*/ <-0.06363,19.06766,-0.90991>,
    /*1*/ <-0.05715,19.06631,-0.91352>,<-0.06401,19.07319,-0.90481>,<-0.06972,19.06349,-0.91142>,
            
    /*2*/ <-0.16764,19.33132,-1.20669>,<-0.17222,19.3359,-1.20089>,<-0.17602,19.32944,-1.2053>,
            
    /*3*/ <-0.22228,19.6702,-1.43152>,<-0.22445,19.67205,-1.42824>,<-0.22659,19.66972,-1.43123>,
            
    /*4*/ <-0.28409,20.04968,-1.57582>

    /* stem 0.27.9*/ 
    /*0*/ <-0.06872,19.23698,-0.98277>,
    /*1*/ <-0.06376,19.23916,-0.97805>,<-0.07492,19.24056,-0.98338>,<-0.06748,19.23122,-0.98688>,
            
    /*2*/ <0.09593,19.47051,-1.2564>,<0.08849,19.47145,-1.25995>,<0.09345,19.46522,-1.26228>,
            
    /*3*/ <0.22635,19.76913,-1.47995>,<0.22259,19.76953,-1.48165>,<0.22539,19.76701,-1.48338>,
            
    /*4*/ <0.33853,20.08356,-1.69219>

    /* stem 0.27.10*/ 
    /*0*/ <-0.07465,19.43391,-1.06751>,
    /*1*/ <-0.07837,19.43605,-1.06227>,<-0.07731,19.43381,-1.07375>,<-0.06826,19.43185,-1.06652>,
            
    /*2*/ <0.04543,19.78873,-1.12152>,<0.04613,19.78724,-1.12917>,<0.05217,19.78593,-1.12435>,
            
    /*3*/ <0.14765,20.1483,-1.1794>,<0.14801,20.1476,-1.18323>,<0.15108,20.14711,-1.18085>,
            
    /*4*/ <0.28373,20.492,-1.26162>

    /* stem 0.27.11*/ 
    /*0*/ <-0.0813,19.65511,-1.1627>,
    /*1*/ <-0.08724,19.65409,-1.16466>,<-0.07695,19.65727,-1.16677>,<-0.07971,19.65398,-1.15667>,
            
    /*2*/ <-0.1718,19.99211,-1.07749>,<-0.16494,19.99423,-1.0789>,<-0.16678,19.99203,-1.07217>,
            
    /*3*/ <-0.20743,20.34972,-1.0828>,<-0.20387,20.35008,-1.08358>,<-0.20499,20.35002,-1.08009>,
            
    /*4*/ <-0.16015,20.70086,-1.14382>

    /* stem 0.27.12*/ 
    /*0*/ <-0.08518,19.78386,-1.2181>,
    /*1*/ <-0.0844,19.7815,-1.22365>,<-0.08094,19.78753,-1.21574>,<-0.09019,19.78256,-1.21491>,
            
    /*2*/ <-0.24501,20.05766,-1.36153>,<-0.2427,20.06168,-1.35626>,<-0.24887,20.05836,-1.35571>,
            
    /*3*/ <-0.32176,20.36396,-1.5075>,<-0.32048,20.36564,-1.5047>,<-0.32387,20.36474,-1.5048>,
            
    /*4*/ <-0.33374,20.68184,-1.64852>

    /* stem 0.27.13*/ 
    /*0*/ <-0.09067,20.00131,-1.29662>,
    /*1*/ <-0.08504,20.00126,-1.29721>,<-0.09308,20.00468,-1.29276>,<-0.09389,19.998,-1.2999>,
            
    /*2*/ <-0.10763,20.24251,-1.52038>,<-0.113,20.24479,-1.51742>,<-0.11353,20.24034,-1.52217>,
            
    /*3*/ <-0.10114,20.4979,-1.72786>,<-0.10382,20.49913,-1.72645>,<-0.1041,20.49708,-1.72898>,
            
    /*4*/ <-0.0923,20.78432,-1.89038>

    /* stem 0.27.14*/ 
    /*0*/ <-0.09644,20.27769,-1.37916>,
    /*1*/ <-0.09478,20.27912,-1.3745>,<-0.10067,20.27985,-1.38116>,<-0.09388,20.27411,-1.38183>,
            
    /*2*/ <0.07693,20.49707,-1.50434>,<0.07301,20.49756,-1.50879>,<0.07754,20.49373,-1.50923>,
            
    /*3*/ <0.22328,20.7373,-1.62548>,<0.22126,20.73746,-1.62765>,<0.2237,20.73579,-1.62801>,
            
    /*4*/ <0.36085,20.9785,-1.75501>

    /* stem 0.27.15*/ 
    /*0*/ <-0.10071,20.48203,-1.44019>,
    /*1*/ <-0.10477,20.48268,-1.43775>,<-0.1007,20.48238,-1.44496>,<-0.09665,20.48104,-1.43786>,
            
    /*2*/ <-0.04608,20.76523,-1.41773>,<-0.04337,20.76503,-1.42253>,<-0.04067,20.76414,-1.4178>,
            
    /*3*/ <0.03118,21.0443,-1.42122>,<0.03248,21.04392,-1.42363>,<0.03384,21.04358,-1.42125>,
            
    /*4*/ <0.08248,21.32869,-1.43177>

    /* stem 0.27.16*/ 
    /*0*/ <-0.10491,20.68344,-1.50034>,
    /*1*/ <-0.10803,20.68248,-1.50333>,<-0.1009,20.68474,-1.50167>,<-0.10581,20.68309,-1.49602>,
            
    /*2*/ <-0.18997,20.94228,-1.49889>,<-0.18522,20.94379,-1.49778>,<-0.18849,20.94269,-1.49402>,
            
    /*3*/ <-0.25869,21.20597,-1.5019>,<-0.25629,21.20662,-1.50134>,<-0.25796,21.2062,-1.49946>,
            
    /*4*/ <-0.29663,21.47407,-1.5324>

    /* stem 0.27.17*/ 
    /*0*/ <-0.10979,20.91681,-1.57004>,
    /*1*/ <-0.1082,20.91612,-1.57247>,<-0.10869,20.91874,-1.56803>,<-0.11248,20.91558,-1.56961>,
            
    /*2*/ <-0.21608,21.10835,-1.69657>,<-0.21641,21.1101,-1.69361>,<-0.21894,21.108,-1.69466>,
            
    /*3*/ <-0.27777,21.31975,-1.82074>,<-0.27792,21.32059,-1.81924>,<-0.27929,21.31979,-1.81992>,
            
    /*4*/ <-0.31198,21.53378,-1.95103>

    /* stem 0.27.18*/ 
    /*0*/ <-0.11406,21.12148,-1.63116>,
    /*1*/ <-0.11303,21.1216,-1.63082>,<-0.11486,21.12207,-1.63071>,<-0.1143,21.12076,-1.63195>,
            
    /*2*/ <-0.08021,21.2896,-1.79311>,<-0.08144,21.28991,-1.79303>,<-0.08106,21.28903,-1.79386>,
            
    /*3*/ <-0.05499,21.48222,-1.92686>,<-0.05561,21.48235,-1.9268>,<-0.0554,21.48199,-1.92728>,
            
    /*4*/ <-0.01766,21.68799,-2.03589>

    /* stem 0.28*/ 
    /*0*/ <0,18.03939,0>,
    /*1*/ <0.01017,18.03939,0.03325>,<-0.02425,18.05593,0.01865>,<-0.02515,18.04961,-0.02173>,
            <0.0087,18.02917,-0.03208>,<0.03053,18.02286,0.0019>,
    /*2*/ <0.64313,19.19194,-0.17238>,<0.62018,19.20296,-0.18212>,<0.61958,19.19875,-0.20904>,
            <0.64215,19.18513,-0.21594>,<0.6567,19.18092,-0.19328>,
    /*3*/ <1.14383,20.41394,-0.33758>,<1.1318,20.41831,-0.34228>,<1.13171,20.41664,-0.35581>,
            <1.14368,20.41125,-0.35946>,<1.15116,20.40958,-0.3482>,
    /*4*/ <1.50545,21.68888,-0.46026>

    /* stem 0.28.0*/ 
    /*0*/ <0.08583,18.19484,-0.02624>,
    /*1*/ <0.07827,18.19981,-0.02153>,<0.08781,18.19672,-0.03607>,<0.0914,18.18801,-0.02112>,
            
    /*2*/ <0.41222,18.57151,0.11497>,<0.41859,18.56944,0.10528>,<0.42098,18.56363,0.11524>,
            
    /*3*/ <0.7669,18.93698,0.21212>,<0.76976,18.93557,0.20718>,<0.77114,18.93289,0.21224>,
            
    /*4*/ <1.02579,19.38477,0.22889>

    /* stem 0.28.1*/ 
    /*0*/ <0.17519,18.3567,-0.05356>,
    /*1*/ <0.16905,18.35885,-0.06091>,<0.18475,18.35537,-0.05538>,<0.17178,18.35588,-0.04439>,
            
    /*2*/ <0.25352,18.8487,0.01628>,<0.26399,18.84638,0.01996>,<0.25534,18.84672,0.02729>,
            
    /*3*/ <0.38188,19.33391,0.04927>,<0.38705,19.33245,0.05108>,<0.38288,19.3333,0.05482>,
            
    /*4*/ <0.54546,19.80952,0.04259>

    /* stem 0.28.2*/ 
    /*0*/ <0.30313,18.58842,-0.09268>,
    /*1*/ <0.30739,18.58481,-0.10008>,<0.3081,18.59249,-0.08598>,<0.29389,18.58796,-0.09196>,
            
    /*2*/ <0.26708,19.00849,-0.32556>,<0.26755,19.01361,-0.31616>,<0.25808,19.01059,-0.32015>,
            
    /*3*/ <0.24887,19.44409,-0.53057>,<0.24913,19.4464,-0.52575>,<0.24437,19.44519,-0.52789>,
            
    /*4*/ <0.35926,19.89444,-0.66098>

    /* stem 0.28.3*/ 
    /*0*/ <0.38993,18.74562,-0.11921>,
    /*1*/ <0.39735,18.74211,-0.11574>,<0.38591,18.75247,-0.11515>,<0.38652,18.74229,-0.12675>,
            
    /*2*/ <0.65293,19.0425,-0.36602>,<0.6453,19.04941,-0.36562>,<0.64571,19.04262,-0.37335>,
            
    /*3*/ <0.79749,19.42423,-0.59615>,<0.793,19.42655,-0.59518>,<0.79359,19.42375,-0.59946>,
            
    /*4*/ <0.85687,19.86154,-0.75059>

    /* stem 0.28.4*/ 
    /*0*/ <0.4788,18.9066,-0.14638>,
    /*1*/ <0.47808,18.9084,-0.13806>,<0.47532,18.91179,-0.15221>,<0.48302,18.89959,-0.14889>,
            
    /*2*/ <0.86266,19.14543,-0.15884>,<0.86082,19.14769,-0.16827>,<0.86595,19.13956,-0.16606>,
            
    /*3*/ <1.21091,19.42884,-0.21512>,<1.20954,19.42965,-0.21979>,<1.21268,19.42599,-0.21874>,
            
    /*4*/ <1.49055,19.77897,-0.27548>

    /* stem 0.28.5*/ 
    /*0*/ <0.57076,19.07315,-0.1745>,
    /*1*/ <0.56364,19.07715,-0.1741>,<0.5749,19.07287,-0.18154>,<0.57374,19.06944,-0.16786>,
            
    /*2*/ <0.77774,19.44188,-0.06466>,<0.78524,19.43902,-0.06962>,<0.78447,19.43674,-0.0605>,
            
    /*3*/ <0.91475,19.85481,-0.03992>,<0.91861,19.8537,-0.04239>,<0.91866,19.8534,-0.03769>,
            
    /*4*/ <1.055,20.26853,-0.04475>

    /* stem 0.28.6*/ 
    /*0*/ <0.65898,19.2468,-0.20147>,
    /*1*/ <0.65658,19.24685,-0.20888>,<0.6665,19.24795,-0.1998>,<0.65385,19.2456,-0.19573>,
            
    /*2*/ <0.58868,19.66152,-0.18119>,<0.59529,19.66225,-0.17513>,<0.58686,19.66068,-0.17242>,
            
    /*3*/ <0.55076,20.08009,-0.19924>,<0.55407,20.08055,-0.19622>,<0.5498,20.08022,-0.19484>,
            
    /*4*/ <0.56964,20.49724,-0.14076>

    /* stem 0.28.7*/ 
    /*0*/ <0.76136,19.49499,-0.23277>,
    /*1*/ <0.76704,19.4922,-0.23635>,<0.76236,19.4983,-0.22637>,<0.75468,19.49448,-0.2356>,
            
    /*2*/ <0.81804,19.8415,-0.42335>,<0.81492,19.84556,-0.4167>,<0.80979,19.84302,-0.42285>,
            
    /*3*/ <0.89648,20.18725,-0.60685>,<0.89495,20.18937,-0.60357>,<0.89241,20.18827,-0.60672>,
            
    /*4*/ <0.933,20.53591,-0.79877>

    /* stem 0.28.8*/ 
    /*0*/ <0.80024,19.58924,-0.24466>,
    /*1*/ <0.80491,19.58797,-0.23949>,<0.79531,19.59425,-0.24382>,<0.8005,19.5855,-0.25066>,
            
    /*2*/ <1.04648,19.85331,-0.39544>,<1.04008,19.8575,-0.39833>,<1.04354,19.85167,-0.40289>,
            
    /*3*/ <1.20927,20.17109,-0.55738>,<1.20557,20.17246,-0.55845>,<1.20769,20.17008,-0.56101>,
            
    /*4*/ <1.353,20.51395,-0.67913>

    /* stem 0.28.9*/ 
    /*0*/ <0.87604,19.773,-0.26783>,
    /*1*/ <0.87279,19.77503,-0.26233>,<0.87425,19.77535,-0.27385>,<0.88108,19.7686,-0.26732>,
            
    /*2*/ <1.11674,20.05777,-0.22548>,<1.11772,20.05799,-0.23316>,<1.12227,20.05349,-0.22881>,
            
    /*3*/ <1.25769,20.40059,-0.17345>,<1.25828,20.40094,-0.17726>,<1.26105,20.39946,-0.175>,
            
    /*4*/ <1.37946,20.75551,-0.1631>

    /* stem 0.28.10*/ 
    /*0*/ <0.94357,19.9367,-0.28848>,
    /*1*/ <0.93798,19.93872,-0.29078>,<0.94861,19.9362,-0.29235>,<0.94412,19.93519,-0.28231>,
            
    /*2*/ <1.03173,20.27891,-0.21466>,<1.03883,20.27723,-0.21571>,<1.03583,20.27656,-0.20901>,
            
    /*3*/ <1.16238,20.61517,-0.22831>,<1.16576,20.61385,-0.22888>,<1.16458,20.61445,-0.22545>,
            
    /*4*/ <1.28956,20.9456,-0.29806>

    /* stem 0.28.11*/ 
    /*0*/ <1.01764,20.11627,-0.31113>,
    /*1*/ <1.01819,20.1153,-0.31704>,<1.02238,20.11821,-0.30795>,<1.01237,20.11531,-0.30839>,
            
    /*2*/ <0.92614,20.44269,-0.3771>,<0.92894,20.44463,-0.37103>,<0.92227,20.4427,-0.37133>,
            
    /*3*/ <0.88995,20.7839,-0.41786>,<0.89142,20.78444,-0.41476>,<0.88798,20.78405,-0.41501>,
            
    /*4*/ <0.88534,21.12935,-0.42353>

    /* stem 0.28.12*/ 
    /*0*/ <1.09609,20.30645,-0.33511>,
    /*1*/ <1.10128,20.30426,-0.33557>,<1.095,20.31029,-0.33112>,<1.09201,20.30481,-0.33864>,
            
    /*2*/ <1.18297,20.54531,-0.54368>,<1.17878,20.54934,-0.54071>,<1.17679,20.54568,-0.54573>,
            
    /*3*/ <1.27325,20.81735,-0.70492>,<1.27106,20.81909,-0.70325>,<1.27022,20.81769,-0.70607>,
            
    /*4*/ <1.37376,21.11261,-0.80899>

    /* stem 0.28.13*/ 
    /*0*/ <1.16636,20.50449,-0.35659>,
    /*1*/ <1.16807,20.50443,-0.3516>,<1.16242,20.5077,-0.35799>,<1.16859,20.50133,-0.36018>,
            
    /*2*/ <1.37386,20.72803,-0.42162>,<1.3701,20.7302,-0.42588>,<1.37421,20.72596,-0.42733>,
            
    /*3*/ <1.49416,21.00021,-0.51681>,<1.49182,21.00059,-0.51872>,<1.49434,20.99915,-0.51966>,
            
    /*4*/ <1.54987,21.29565,-0.59989>

    /* stem 0.28.14*/ 
    /*0*/ <1.22174,20.69794,-0.37352>,
    /*1*/ <1.21776,20.6993,-0.37098>,<1.22227,20.69936,-0.37821>,<1.2252,20.69516,-0.37139>,
            
    /*2*/ <1.36006,20.94278,-0.28206>,<1.36307,20.94281,-0.28688>,<1.36502,20.94001,-0.28234>,
            
    /*3*/ <1.47039,21.21012,-0.22146>,<1.47186,21.21008,-0.22389>,<1.47302,21.20906,-0.22151>,
            
    /*4*/ <1.53494,21.49776,-0.20012>

    /* stem 0.28.15*/ 
    /*0*/ <1.30258,20.9803,-0.39824>,
    /*1*/ <1.29954,20.9809,-0.40139>,<1.30688,20.98054,-0.39924>,<1.30133,20.97947,-0.39409>,
            
    /*2*/ <1.29832,21.24767,-0.34775>,<1.30321,21.24743,-0.34632>,<1.29951,21.24672,-0.34289>,
            
    /*3*/ <1.32143,21.51849,-0.33915>,<1.32388,21.51827,-0.33845>,<1.32205,21.51837,-0.33667>,
            
    /*4*/ <1.36728,21.78453,-0.37264>

    /* stem 0.28.16*/ 
    /*0*/ <1.34215,21.11851,-0.41034>,
    /*1*/ <1.34424,21.11761,-0.41384>,<1.34418,21.12009,-0.40705>,<1.33804,21.11785,-0.41013>,
            
    /*2*/ <1.29993,21.35917,-0.50091>,<1.29989,21.36082,-0.49638>,<1.29579,21.35933,-0.49844>,
            
    /*3*/ <1.26969,21.59704,-0.60235>,<1.26966,21.59799,-0.60014>,<1.2676,21.59729,-0.60117>,
            
    /*4*/ <1.25221,21.84118,-0.6918>

    /* stem 0.28.17*/ 
    /*0*/ <1.41175,21.36161,-0.43162>,
    /*1*/ <1.41447,21.36092,-0.43062>,<1.41001,21.36344,-0.43004>,<1.41078,21.36047,-0.43419>,
            
    /*2*/ <1.50481,21.54944,-0.54905>,<1.50184,21.55112,-0.54867>,<1.50235,21.54914,-0.55143>,
            
    /*3*/ <1.57916,21.7599,-0.63819>,<1.5776,21.76057,-0.63791>,<1.57796,21.75981,-0.63941>,
            
    /*4*/ <1.6432,21.98273,-0.7013>

    /* stem 0.28.18*/ 
    /*0*/ <1.47318,21.57618,-0.4504>,
    /*1*/ <1.47309,21.57629,-0.44938>,<1.47262,21.57675,-0.45103>,<1.47384,21.57549,-0.45078>,
            
    /*2*/ <1.63308,21.73066,-0.45285>,<1.63277,21.73097,-0.45395>,<1.63358,21.73013,-0.45378>,
            
    /*3*/ <1.72979,21.9284,-0.4846>,<1.72955,21.92844,-0.48514>,<1.73008,21.92819,-0.48507>,
            
    /*4*/ <1.79148,22.13899,-0.52043>

    /* stem 0.29*/ 
    /*0*/ <0,18.44569,0>,
    /*1*/ <-0.02865,18.44569,0.01654>,<-0.02248,18.46142,-0.01848>,<0.01476,18.45541,-0.02796>,
            <0.0316,18.43597,0.0012>,<0.00477,18.42996,0.02871>,
    /*2*/ <0.30108,19.55481,0.56559>,<0.30519,19.56529,0.54224>,<0.33001,19.56129,0.53592>,
            <0.34124,19.54833,0.55536>,<0.32335,19.54432,0.5737>,
    /*3*/ <0.56425,20.73077,0.99937>,<0.56604,20.73492,0.98722>,<0.57855,20.73333,0.98424>,
            <0.58451,20.7282,0.99455>,<0.57567,20.72661,1.0039>,
    /*4*/ <0.75746,21.95766,1.31196>

    /* stem 0.29.0*/ 
    /*0*/ <0.03296,18.55987,0.05709>,
    /*1*/ <0.02693,18.56464,0.05104>,<0.04247,18.56218,0.05734>,<0.02949,18.5528,0.06289>,
            
    /*2*/ <-0.06248,18.90211,0.41141>,<-0.05212,18.90047,0.4156>,<-0.06077,18.89422,0.41931>,
            
    /*3*/ <-0.08559,19.28294,0.73723>,<-0.08035,19.28179,0.739>,<-0.08478,19.27936,0.74152>,
            
    /*4*/ <-0.06508,19.7013,1.01319>

    /* stem 0.29.1*/ 
    /*0*/ <0.08999,18.75742,0.15586>,
    /*1*/ <0.09548,18.75946,0.14861>,<0.09368,18.75641,0.16436>,<0.08081,18.75638,0.15462>,
            
    /*2*/ <0.02889,19.23051,0.23492>,<0.0277,19.22847,0.24543>,<0.01911,19.22845,0.23893>,
            
    /*3*/ <-0.01396,19.67674,0.41833>,<-0.01449,19.67468,0.42328>,<-0.01885,19.67552,0.42024>,
            
    /*4*/ <-0.08825,20.10648,0.6277>

    /* stem 0.29.2*/ 
    /*0*/ <0.14635,18.95266,0.25349>,
    /*1*/ <0.15417,18.94922,0.25587>,<0.14099,18.95616,0.25963>,<0.14389,18.95262,0.24496>,
            
    /*2*/ <0.35299,19.3656,0.19464>,<0.3442,19.37023,0.19715>,<0.34613,19.36787,0.18737>,
            
    /*3*/ <0.53325,19.79371,0.16249>,<0.52872,19.79574,0.16377>,<0.52985,19.7949,0.15884>,
            
    /*4*/ <0.691,20.23172,0.16054>

    /* stem 0.29.3*/ 
    /*0*/ <0.18663,19.09218,0.32325>,
    /*1*/ <0.18498,19.08881,0.33094>,<0.18261,19.09931,0.32075>,<0.19229,19.08842,0.31805>,
            
    /*2*/ <0.51698,19.33981,0.50869>,<0.51539,19.34681,0.5019>,<0.52185,19.33955,0.5001>,
            
    /*3*/ <0.78046,19.65655,0.69608>,<0.77931,19.65969,0.69245>,<0.78322,19.65671,0.69199>,
            
    /*4*/ <0.97801,20.03051,0.85773>

    /* stem 0.29.4*/ 
    /*0*/ <0.25155,19.31709,0.4357>,
    /*1*/ <0.24376,19.31879,0.43679>,<0.2559,19.32135,0.43043>,<0.25499,19.31112,0.43987>,
            
    /*2*/ <0.35123,19.59722,0.74884>,<0.35932,19.59892,0.7446>,<0.35872,19.59211,0.75089>,
            
    /*3*/ <0.468,19.90113,1.03261>,<0.47198,19.9018,1.0303>,<0.47178,19.89867,1.03373>,
            
    /*4*/ <0.63152,20.22601,1.26587>

    /* stem 0.29.5*/ 
    /*0*/ <0.30395,19.4986,0.52645>,
    /*1*/ <0.30209,19.50234,0.52005>,<0.31119,19.49857,0.5289>,<0.29857,19.49489,0.53042>,
            
    /*2*/ <0.22929,19.84417,0.74386>,<0.23536,19.84166,0.74976>,<0.22694,19.83921,0.75077>,
            
    /*3*/ <0.20123,20.20928,0.93855>,<0.20428,20.20798,0.94147>,<0.20001,20.20723,0.94227>,
            
    /*4*/ <0.16837,20.60051,1.07185>

    /* stem 0.29.6*/ 
    /*0*/ <0.33666,19.63124,0.58311>,
    /*1*/ <0.34298,19.63129,0.57933>,<0.33678,19.63105,0.59047>,<0.33023,19.63138,0.57954>,
            
    /*2*/ <0.34384,20.0343,0.59097>,<0.33971,20.03413,0.5984>,<0.33534,20.03435,0.59111>,
            
    /*3*/ <0.40644,20.43128,0.61504>,<0.40441,20.43139,0.61878>,<0.40224,20.43195,0.61517>,
            
    /*4*/ <0.46664,20.82056,0.70194>

    /* stem 0.29.7*/ 
    /*0*/ <0.39242,19.88976,0.67968>,
    /*1*/ <0.39689,19.88713,0.68413>,<0.38757,19.89406,0.68185>,<0.39279,19.88808,0.67307>,
            
    /*2*/ <0.62902,20.18218,0.62122>,<0.62281,20.18679,0.61971>,<0.62628,20.18281,0.61385>,
            
    /*3*/ <0.83312,20.49932,0.56788>,<0.82981,20.50135,0.56716>,<0.83174,20.49961,0.56419>,
            
    /*4*/ <0.96699,20.8553,0.58572>

    /* stem 0.29.8*/ 
    /*0*/ <0.42829,20.05607,0.74181>,
    /*1*/ <0.42463,20.0549,0.74705>,<0.42667,20.06085,0.73773>,<0.43356,20.05245,0.74066>,
            
    /*2*/ <0.62931,20.28961,0.93963>,<0.63068,20.29358,0.93341>,<0.63526,20.28797,0.93537>,
            
    /*3*/ <0.83163,20.56683,1.06918>,<0.83189,20.56827,1.06573>,<0.83446,20.56583,1.06694>,
            
    /*4*/ <0.99957,20.85817,1.21362>

    /* stem 0.29.9*/ 
    /*0*/ <0.46544,20.22835,0.80617>,
    /*1*/ <0.45985,20.23021,0.8044>,<0.47045,20.23135,0.80423>,<0.46603,20.22347,0.80988>,
            
    /*2*/ <0.4434,20.44046,1.08516>,<0.45046,20.44122,1.08505>,<0.44751,20.43597,1.08882>,
            
    /*3*/ <0.42319,20.69221,1.32868>,<0.42672,20.69259,1.32861>,<0.42522,20.69029,1.33086>,
            
    /*4*/ <0.40101,21.01113,1.47321>

    /* stem 0.29.10*/ 
    /*0*/ <0.50612,20.41696,0.87663>,
    /*1*/ <0.50702,20.41879,0.87122>,<0.51041,20.41717,0.8805>,<0.50094,20.41491,0.87817>,
            
    /*2*/ <0.41135,20.72657,0.9615>,<0.41361,20.72549,0.96769>,<0.4073,20.72399,0.96614>,
            
    /*3*/ <0.369,21.04832,1.04243>,<0.37016,21.04772,1.0455>,<0.36689,21.04745,1.04487>,
            
    /*4*/ <0.33197,21.37229,1.11781>

    /* stem 0.29.11*/ 
    /*0*/ <0.55846,20.65963,0.96728>,
    /*1*/ <0.56365,20.65877,0.96658>,<0.55667,20.66136,0.97197>,<0.55506,20.65876,0.9633>,
            
    /*2*/ <0.59776,20.95559,0.87139>,<0.59311,20.95731,0.87499>,<0.59203,20.95558,0.8692>,
            
    /*3*/ <0.64748,21.25828,0.80687>,<0.64514,21.25907,0.80869>,<0.64464,21.25852,0.80572>,
            
    /*4*/ <0.68544,21.56672,0.76439>

    /* stem 0.29.12*/ 
    /*0*/ <0.59114,20.84655,1.02388>,
    /*1*/ <0.59265,20.84516,1.02839>,<0.58726,20.84961,1.0234>,<0.5935,20.84489,1.01984>,
            
    /*2*/ <0.77556,21.07985,1.03789>,<0.77197,21.08282,1.03456>,<0.77613,21.07967,1.03219>,
            
    /*3*/ <0.90899,21.3449,1.0067>,<0.90683,21.34581,1.00504>,<0.90911,21.34452,1.00386>,
            
    /*4*/ <1.05503,21.60175,0.97034>

    /* stem 0.29.13*/ 
    /*0*/ <0.61244,20.98886,1.06077>,
    /*1*/ <0.60844,20.98881,1.06326>,<0.61308,20.9921,1.05742>,<0.61579,20.98567,1.06164>,
            
    /*2*/ <0.72741,21.16465,1.25463>,<0.7305,21.16684,1.25073>,<0.7323,21.16256,1.25355>,
            
    /*3*/ <0.83271,21.37434,1.4179>,<0.83417,21.37526,1.4158>,<0.83524,21.37342,1.41748>,
            
    /*4*/ <0.8844,21.62945,1.53569>

    /* stem 0.29.14*/ 
    /*0*/ <0.65562,21.27736,1.13557>,
    /*1*/ <0.65274,21.27852,1.13275>,<0.6595,21.27896,1.1354>,<0.65463,21.27459,1.13857>,
            
    /*2*/ <0.57971,21.4744,1.29023>,<0.58422,21.47469,1.29199>,<0.58097,21.47178,1.29411>,
            
    /*3*/ <0.51156,21.68485,1.42985>,<0.51382,21.68501,1.43074>,<0.51214,21.68369,1.4319>,
            
    /*4*/ <0.46873,21.91838,1.53987>

    /* stem 0.29.15*/ 
    /*0*/ <0.68396,21.46667,1.18466>,
    /*1*/ <0.68605,21.46719,1.18144>,<0.68544,21.46763,1.1881>,<0.68039,21.46519,1.18443>,
            
    /*2*/ <0.59268,21.69359,1.15902>,<0.59227,21.69388,1.16347>,<0.58891,21.69225,1.16102>,
            
    /*3*/ <0.52065,21.92862,1.15223>,<0.52049,21.92865,1.15446>,<0.51873,21.92807,1.15321>,
            
    /*4*/ <0.47951,22.17072,1.1652>

    /* stem 0.29.16*/ 
    /*0*/ <0.70739,21.62319,1.22524>,
    /*1*/ <0.71019,21.62254,1.22613>,<0.70539,21.62425,1.22721>,<0.7066,21.62278,1.22237>,
            
    /*2*/ <0.7758,21.84031,1.17627>,<0.7726,21.84145,1.17699>,<0.77341,21.84047,1.17376>,
            
    /*3*/ <0.87078,22.05188,1.15956>,<0.86925,22.05261,1.15991>,<0.86969,22.05227,1.15826>,
            
    /*4*/ <0.99371,22.24937,1.16502>

    /* stem 0.29.17*/ 
    /*0*/ <0.74508,21.87499,1.29052>,
    /*1*/ <0.74499,21.87482,1.29124>,<0.74467,21.87552,1.29021>,<0.74559,21.87463,1.29011>,
            
    /*2*/ <0.8909,22.01901,1.34402>,<0.89068,22.01948,1.34334>,<0.8913,22.01889,1.34327>,
            
    /*3*/ <1.03223,22.17206,1.38252>,<1.0321,22.17227,1.38217>,<1.03241,22.17199,1.38214>,
            
    /*4*/ <1.13738,22.35248,1.41804>

    /* stem 0.30*/ 
    /*0*/ <0,19.14435,0>,
    /*1*/ <-0.02057,19.14435,-0.02206>,<0.01181,19.15869,-0.02376>,<0.02787,19.15321,0.00738>,
            <0.00541,19.13548,0.02832>,<-0.02453,19.13,0.01013>,
    /*2*/ <-0.44997,20.17753,0.39211>,<-0.42838,20.18709,0.39097>,<-0.41767,20.18344,0.41173>,
            <-0.43265,20.17162,0.4257>,<-0.45261,20.16796,0.41357>,
    /*3*/ <-0.7887,21.27297,0.72173>,<-0.77754,21.27676,0.72082>,<-0.77232,21.27531,0.73133>,
            <-0.78026,21.27063,0.73873>,<-0.79038,21.26918,0.7328>,
    /*4*/ <-1.03208,22.41586,0.96243>

    /* stem 0.30.0*/ 
    /*0*/ <-0.04816,19.25841,0.04491>,
    /*1*/ <-0.04403,19.26275,0.03832>,<-0.04648,19.26055,0.05339>,<-0.05397,19.25193,0.04302>,
            
    /*2*/ <-0.39127,19.57443,0.02994>,<-0.3929,19.57296,0.03998>,<-0.39789,19.56721,0.03307>,
            
    /*3*/ <-0.71477,19.91048,0.02965>,<-0.71559,19.90974,0.03467>,<-0.71832,19.90711,0.03121>,
            
    /*4*/ <-0.98219,20.29165,0.05844>

    /* stem 0.30.1*/ 
    /*0*/ <-0.11205,19.4097,0.10448>,
    /*1*/ <-0.10442,19.41158,0.10789>,<-0.11868,19.4079,0.10958>,<-0.11303,19.40963,0.09598>,
            
    /*2*/ <-0.21901,19.84946,0.11599>,<-0.22852,19.84701,0.11711>,<-0.22475,19.84816,0.10804>,
            
    /*3*/ <-0.39366,20.26365,0.17367>,<-0.39818,20.26171,0.17415>,<-0.39652,20.26303,0.16969>,
            
    /*4*/ <-0.57133,20.66901,0.26853>

    /* stem 0.30.2*/ 
    /*0*/ <-0.19434,19.60459,0.18122>,
    /*1*/ <-0.19485,19.60144,0.18869>,<-0.2011,19.60621,0.17703>,<-0.18706,19.60613,0.17795>,
            
    /*2*/ <-0.20335,20.00301,0.3549>,<-0.20752,20.00619,0.34713>,<-0.19816,20.00614,0.34775>,
            
    /*3*/ <-0.33219,20.38684,0.5129>,<-0.33417,20.3879,0.50878>,<-0.3297,20.38906,0.5096>,
            
    /*4*/ <-0.44343,20.75956,0.70649>

    /* stem 0.30.3*/ 
    /*0*/ <-0.25076,19.73821,0.23384>,
    /*1*/ <-0.25795,19.73513,0.23395>,<-0.24924,19.74443,0.22934>,<-0.24509,19.73508,0.23822>,
            
    /*2*/ <-0.36018,19.99246,0.55288>,<-0.35438,19.99866,0.5498>,<-0.35161,19.99243,0.55572>,
            
    /*3*/ <-0.43456,20.32701,0.80092>,<-0.43142,20.32938,0.7987>,<-0.43027,20.32695,0.80233>,
            
    /*4*/ <-0.49233,20.68231,1.02213>

    /* stem 0.30.4*/ 
    /*0*/ <-0.33832,19.94558,0.31549>,
    /*1*/ <-0.3409,19.94713,0.30877>,<-0.33336,19.95001,0.31864>,<-0.3407,19.93959,0.31905>,
            
    /*2*/ <-0.63797,20.16281,0.4755>,<-0.63295,20.16472,0.48208>,<-0.63784,20.15778,0.48235>,
            
    /*3*/ <-0.82221,20.49553,0.6088>,<-0.81924,20.49599,0.6118>,<-0.82275,20.49373,0.61261>,
            
    /*4*/ <-0.96323,20.83185,0.78146>

    /* stem 0.30.5*/ 
    /*0*/ <-0.3851,20.05637,0.35911>,
    /*1*/ <-0.37968,20.05986,0.35608>,<-0.38592,20.05653,0.36618>,<-0.3897,20.05274,0.35507>,
            
    /*2*/ <-0.60602,20.37949,0.32407>,<-0.61019,20.37727,0.3308>,<-0.6127,20.37474,0.3234>,
            
    /*3*/ <-0.75833,20.74085,0.33247>,<-0.76046,20.7399,0.33585>,<-0.76212,20.73929,0.33214>,
            
    /*4*/ <-0.87059,21.11664,0.35355>

    /* stem 0.30.6*/ 
    /*0*/ <-0.48266,20.32463,0.45009>,
    /*1*/ <-0.47811,20.32468,0.45482>,<-0.48903,20.32447,0.45167>,<-0.48085,20.32475,0.44379>,
            
    /*2*/ <-0.48783,20.69349,0.4576>,<-0.49511,20.69336,0.4555>,<-0.48965,20.69354,0.45024>,
            
    /*3*/ <-0.52706,21.0545,0.52127>,<-0.53069,21.05431,0.52023>,<-0.52802,21.05506,0.51765>,
            
    /*4*/ <-0.58669,21.4186,0.53615>

    /* stem 0.30.7*/ 
    /*0*/ <-0.54505,20.52239,0.50827>,
    /*1*/ <-0.54805,20.52002,0.51311>,<-0.54819,20.52519,0.50376>,<-0.53891,20.52195,0.50794>,
            
    /*2*/ <-0.51623,20.82752,0.68085>,<-0.51633,20.83097,0.67463>,<-0.51014,20.82881,0.67741>,
            
    /*3*/ <-0.50555,21.14964,0.82216>,<-0.5056,21.15108,0.81891>,<-0.50249,21.1503,0.82046>,
            
    /*4*/ <-0.53423,21.48165,0.9348>

    /* stem 0.30.8*/ 
    /*0*/ <-0.60505,20.71256,0.56422>,
    /*1*/ <-0.61033,20.71152,0.56209>,<-0.6019,20.71695,0.56212>,<-0.60292,20.70922,0.56844>,
            
    /*2*/ <-0.74133,20.91698,0.7922>,<-0.73571,20.9206,0.79222>,<-0.73639,20.91545,0.79643>,
            
    /*3*/ <-0.8454,21.17784,0.97547>,<-0.8424,21.17928,0.97516>,<-0.84302,21.17723,0.97773>,
            
    /*4*/ <-0.92126,21.44443,1.16418>

    /* stem 0.30.9*/ 
    /*0*/ <-0.68841,20.97682,0.64196>,
    /*1*/ <-0.68801,20.97842,0.63694>,<-0.68551,20.97913,0.64571>,<-0.69172,20.9729,0.64322>,
            
    /*2*/ <-0.91598,21.18572,0.68676>,<-0.91431,21.1862,0.69261>,<-0.91845,21.18204,0.69095>,
            
    /*3*/ <-1.09286,21.44175,0.67859>,<-1.09226,21.44228,0.68153>,<-1.09467,21.44059,0.68075>,
            
    /*4*/ <-1.2466,21.71316,0.66867>

    /* stem 0.30.10*/ 
    /*0*/ <-0.73701,21.13087,0.68728>,
    /*1*/ <-0.73229,21.13245,0.68698>,<-0.73951,21.13127,0.69157>,<-0.73924,21.12889,0.68328>,
            
    /*2*/ <-0.82958,21.40303,0.60606>,<-0.83439,21.40224,0.60912>,<-0.83421,21.40065,0.60359>,
            
    /*3*/ <-0.9352,21.6798,0.56704>,<-0.93751,21.67916,0.56862>,<-0.93756,21.67874,0.56577>,
            
    /*4*/ <-1.03881,21.95988,0.56024>

    /* stem 0.30.11*/ 
    /*0*/ <-0.81148,21.40835,0.75672>,
    /*1*/ <-0.80997,21.40782,0.7609>,<-0.81569,21.40971,0.75602>,<-0.80879,21.40751,0.75324>,
            
    /*2*/ <-0.72624,21.66979,0.76171>,<-0.73005,21.67104,0.75846>,<-0.72545,21.66958,0.75661>,
            
    /*3*/ <-0.72043,21.94407,0.78238>,<-0.72241,21.94425,0.78073>,<-0.71998,21.94427,0.77984>,
            
    /*4*/ <-0.76759,22.21259,0.81867>

    /* stem 0.30.12*/ 
    /*0*/ <-0.84538,21.56317,0.78833>,
    /*1*/ <-0.84882,21.56198,0.79044>,<-0.84574,21.56566,0.78496>,<-0.84159,21.56186,0.78959>,
            
    /*2*/ <-0.82586,21.77338,0.94367>,<-0.82381,21.77583,0.94002>,<-0.82104,21.77329,0.9431>,
            
    /*3*/ <-0.81203,22.01608,1.04245>,<-0.81102,22.01687,1.04039>,<-0.80961,22.01606,1.04219>,
            
    /*4*/ <-0.81292,22.27039,1.10605>

    /* stem 0.30.13*/ 
    /*0*/ <-0.8893,21.76373,0.82928>,
    /*1*/ <-0.89202,21.76369,0.82655>,<-0.88607,21.76578,0.82876>,<-0.8898,21.76172,0.83254>,
            
    /*2*/ <-0.99786,21.95877,0.93113>,<-0.99388,21.96016,0.93261>,<-0.99638,21.95746,0.93513>,
            
    /*3*/ <-1.08421,22.18203,0.98379>,<-1.08219,22.18266,0.9845>,<-1.08364,22.18176,0.98593>,
            
    /*4*/ <-1.15879,22.40959,1.03738>

    /* stem 0.30.14*/ 
    /*0*/ <-0.92922,21.94608,0.86651>,
    /*1*/ <-0.92745,21.94707,0.8636>,<-0.92806,21.94707,0.86972>,<-0.93216,21.94411,0.86622>,
            
    /*2*/ <-1.05537,22.13797,0.8515>,<-1.05578,22.13797,0.85558>,<-1.05851,22.13599,0.85325>,
            
    /*3*/ <-1.12449,22.35699,0.84458>,<-1.12468,22.357,0.84662>,<-1.12627,22.35646,0.84545>,
            
    /*4*/ <-1.15544,22.58491,0.84289>

    /* stem 0.30.15*/ 
    /*0*/ <-0.96012,22.08721,0.89533>,
    /*1*/ <-0.95743,22.0876,0.89631>,<-0.96237,22.08754,0.89712>,<-0.96057,22.0865,0.89256>,
            
    /*2*/ <-0.96963,22.29898,0.84302>,<-0.97292,22.29894,0.84355>,<-0.97172,22.29824,0.84052>,
            
    /*3*/ <-0.9529,22.51608,0.8336>,<-0.95454,22.51623,0.83386>,<-0.95396,22.51611,0.8323>,
            
    /*4*/ <-0.93128,22.72862,0.87812>

    /* stem 0.30.16*/ 
    /*0*/ <-1.0159,22.34194,0.94734>,
    /*1*/ <-1.01595,22.3418,0.94797>,<-1.0164,22.3422,0.94702>,<-1.01534,22.34183,0.94703>,
            
    /*2*/ <-0.95303,22.52295,0.99331>,<-0.95333,22.52322,0.99268>,<-0.95262,22.52297,0.99268>,
            
    /*3*/ <-0.87935,22.70007,1.03838>,<-0.87949,22.70021,1.03806>,<-0.87915,22.70007,1.03806>,
            
    /*4*/ <-0.84987,22.89274,1.0675>

    /* stem 0.31*/ 
    /*0*/ <0,19.5684,0>,
    /*1*/ <0.01588,19.5684,-0.02355>,<0.0243,19.58191,0.00581>,<-0.00086,19.57675,0.02713>,
            <-0.02484,19.56005,0.01096>,<-0.01449,19.5549,-0.02036>,
    /*2*/ <-0.46154,20.55478,-0.33415>,<-0.45592,20.56378,-0.31458>,<-0.4727,20.56034,-0.30036>,
            <-0.48868,20.54921,-0.31114>,<-0.48178,20.54577,-0.33202>,
    /*3*/ <-0.84083,21.6006,-0.57856>,<-0.83763,21.60416,-0.56852>,<-0.84617,21.6028,-0.56151>,
            <-0.85464,21.59839,-0.56722>,<-0.85134,21.59703,-0.57776>,
    /*4*/ <-1.11693,22.69172,-0.75338>

    /* stem 0.31.0*/ 
    /*0*/ <-0.07066,19.71603,-0.04766>,
    /*1*/ <-0.06381,19.72007,-0.04529>,<-0.07805,19.71823,-0.04459>,<-0.07012,19.70979,-0.0531>,
            
    /*2*/ <-0.11961,20.0044,-0.37902>,<-0.1291,20.00317,-0.37854>,<-0.12382,19.99755,-0.38422>,
            
    /*3*/ <-0.14774,20.36652,-0.62896>,<-0.15252,20.3662,-0.62893>,<-0.14998,20.36402,-0.63237>,
            
    /*4*/ <-0.2216,20.7797,-0.76686>

    /* stem 0.31.1*/ 
    /*0*/ <-0.1301,19.84021,-0.08775>,
    /*1*/ <-0.13161,19.84197,-0.08008>,<-0.1361,19.83998,-0.09306>,<-0.12259,19.83869,-0.09012>,
            
    /*2*/ <-0.07307,20.25951,-0.16697>,<-0.07607,20.25818,-0.17563>,<-0.06706,20.25733,-0.17367>,
            
    /*3*/ <-0.14838,20.67604,-0.24296>,<-0.14989,20.67502,-0.24721>,<-0.14542,20.67596,-0.24651>,
            
    /*4*/ <-0.24907,21.08425,-0.33577>

    /* stem 0.31.2*/ 
    /*0*/ <-0.22056,20.02921,-0.14877>,
    /*1*/ <-0.22748,20.02626,-0.14767>,<-0.21871,20.03211,-0.15554>,<-0.21551,20.02926,-0.14311>,
            
    /*2*/ <-0.36388,20.39713,-0.0275>,<-0.35803,20.40103,-0.03275>,<-0.3559,20.39913,-0.02446>,
            
    /*3*/ <-0.49008,20.7656,0.11018>,<-0.48718,20.7676,0.10756>,<-0.48604,20.76646,0.11164>,
            
    /*4*/ <-0.63683,21.13288,0.22883>

    /* stem 0.31.3*/ 
    /*0*/ <-0.29208,20.17862,-0.19701>,
    /*1*/ <-0.29369,20.17576,-0.20349>,<-0.28761,20.18434,-0.19657>,<-0.29494,20.17577,-0.19097>,
            
    /*2*/ <-0.60548,20.42337,-0.23273>,<-0.60143,20.42909,-0.22811>,<-0.60632,20.42338,-0.22438>,
            
    /*3*/ <-0.85674,20.73141,-0.27311>,<-0.85423,20.73379,-0.27073>,<-0.85729,20.73153,-0.26896>,
            
    /*4*/ <-1.01003,21.08713,-0.36957>

    /* stem 0.31.4*/ 
    /*0*/ <-0.37335,20.34842,-0.25183>,
    /*1*/ <-0.36776,20.34988,-0.2556>,<-0.37565,20.35296,-0.24717>,<-0.37665,20.34243,-0.25272>,
            
    /*2*/ <-0.59214,20.51108,-0.52163>,<-0.5974,20.51313,-0.51601>,<-0.59807,20.50611,-0.51971>,
            
    /*3*/ <-0.8284,20.76859,-0.68104>,<-0.83032,20.769,-0.67758>,<-0.83152,20.76627,-0.68021>,
            
    /*4*/ <-1.05104,21.07654,-0.7348>

    /* stem 0.31.5*/ 
    /*0*/ <-0.44469,20.49747,-0.29995>,
    /*1*/ <-0.44084,20.50069,-0.2957>,<-0.4512,20.49725,-0.29898>,<-0.44205,20.49447,-0.30518>,
            
    /*2*/ <-0.48235,20.80932,-0.49508>,<-0.48925,20.80703,-0.49726>,<-0.48315,20.80518,-0.5014>,
            
    /*3*/ <-0.49712,21.13329,-0.67178>,<-0.5006,21.13246,-0.67305>,<-0.49755,21.13149,-0.6751>,
            
    /*4*/ <-0.55213,21.48253,-0.77941>

    /* stem 0.31.6*/ 
    /*0*/ <-0.50767,20.65419,-0.34243>,
    /*1*/ <-0.51109,20.65423,-0.33719>,<-0.51033,20.65563,-0.34791>,<-0.5016,20.6527,-0.3422>,
            
    /*2*/ <-0.42814,20.99679,-0.28846>,<-0.42763,20.99773,-0.29561>,<-0.42181,20.99578,-0.2918>,
            
    /*3*/ <-0.37557,21.34896,-0.29806>,<-0.37541,21.34885,-0.30166>,<-0.3724,21.34846,-0.29971>,
            
    /*4*/ <-0.35445,21.70191,-0.33833>

    /* stem 0.31.7*/ 
    /*0*/ <-0.59227,20.89074,-0.39949>,
    /*1*/ <-0.59733,20.88851,-0.40121>,<-0.58913,20.89396,-0.40314>,<-0.59034,20.88974,-0.39412>,
            
    /*2*/ <-0.75347,21.16459,-0.29276>,<-0.748,21.16823,-0.29404>,<-0.74881,21.16541,-0.28803>,
            
    /*3*/ <-0.87762,21.47181,-0.24037>,<-0.87466,21.47316,-0.24113>,<-0.87536,21.47233,-0.23796>,
            
    /*4*/ <-1.01678,21.77603,-0.25807>

    /* stem 0.31.8*/ 
    /*0*/ <-0.66394,21.09116,-0.44783>,
    /*1*/ <-0.66312,21.09019,-0.45308>,<-0.66194,21.09564,-0.44557>,<-0.66676,21.08765,-0.44485>,
            
    /*2*/ <-0.93136,21.24585,-0.52217>,<-0.93058,21.24948,-0.51716>,<-0.93379,21.24416,-0.51668>,
            
    /*3*/ <-1.13457,21.48169,-0.5863>,<-1.13375,21.48314,-0.58366>,<-1.13611,21.4811,-0.58365>,
            
    /*4*/ <-1.24507,21.77227,-0.65183>

    /* stem 0.31.9*/ 
    /*0*/ <-0.74376,21.31437,-0.50167>,
    /*1*/ <-0.73907,21.31588,-0.50237>,<-0.74665,21.31667,-0.49834>,<-0.74556,21.31055,-0.50431>,
            
    /*2*/ <-0.8329,21.50494,-0.71316>,<-0.83795,21.50547,-0.71047>,<-0.83723,21.50139,-0.71446>,
            
    /*3*/ <-0.90991,21.74941,-0.86522>,<-0.91238,21.74955,-0.86376>,<-0.91224,21.74807,-0.86622>,
            
    /*4*/ <-0.96462,22.0105,-0.9984>

    /* stem 0.31.10*/ 
    /*0*/ <-0.8097,21.49875,-0.54615>,
    /*1*/ <-0.80844,21.50022,-0.54194>,<-0.81406,21.49934,-0.5476>,<-0.8066,21.4967,-0.54891>,
            
    /*2*/ <-0.73925,21.75092,-0.65154>,<-0.74299,21.75034,-0.65532>,<-0.73801,21.74858,-0.65619>,
            
    /*3*/ <-0.69997,22.01473,-0.74344>,<-0.70186,22.01437,-0.7453>,<-0.69931,22.0138,-0.74586>,
            
    /*4*/ <-0.7136,22.29165,-0.79541>

    /* stem 0.31.11*/ 
    /*0*/ <-0.86869,21.69153,-0.58594>,
    /*1*/ <-0.87226,21.69103,-0.58363>,<-0.86892,21.69307,-0.58993>,<-0.86489,21.69048,-0.58426>,
            
    /*2*/ <-0.8447,21.93829,-0.4902>,<-0.84247,21.93966,-0.4944>,<-0.83978,21.93793,-0.49062>,
            
    /*3*/ <-0.84233,22.20388,-0.47531>,<-0.84124,22.20401,-0.47752>,<-0.83987,22.20388,-0.47547>,
            
    /*4*/ <-0.82289,22.46888,-0.46641>

    /* stem 0.31.12*/ 
    /*0*/ <-0.90438,21.83532,-0.61001>,
    /*1*/ <-0.90709,21.83418,-0.61277>,<-0.90131,21.83771,-0.61107>,<-0.90474,21.83406,-0.60619>,
            
    /*2*/ <-1.04657,22.03893,-0.55787>,<-1.04271,22.04128,-0.55673>,<-1.045,22.03885,-0.55348>,
            
    /*3*/ <-1.17104,22.25429,-0.50713>,<-1.16904,22.25534,-0.50659>,<-1.17026,22.25424,-0.50494>,
            
    /*4*/ <-1.2748,22.47785,-0.44624>

    /* stem 0.31.13*/ 
    /*0*/ <-0.95473,22.03818,-0.64397>,
    /*1*/ <-0.95277,22.03814,-0.6471>,<-0.95373,22.04039,-0.6412>,<-0.95768,22.036,-0.64362>,
            
    /*2*/ <-1.09062,22.20992,-0.7341>,<-1.09127,22.21142,-0.73017>,<-1.0939,22.20849,-0.73178>,
            
    /*3*/ <-1.21592,22.40546,-0.78183>,<-1.21603,22.4059,-0.77976>,<-1.21754,22.40471,-0.78067>,
            
    /*4*/ <-1.28894,22.62868,-0.81173>

    /* stem 0.31.14*/ 
    /*0*/ <-1.01089,22.26446,-0.68185>,
    /*1*/ <-1.00787,22.26537,-0.68085>,<-1.01356,22.26544,-0.68017>,<-1.01123,22.26256,-0.68454>,
            
    /*2*/ <-1.02189,22.44366,-0.80538>,<-1.02568,22.4437,-0.80492>,<-1.02413,22.44178,-0.80784>,
            
    /*3*/ <-1.08005,22.64056,-0.87901>,<-1.08188,22.64019,-0.87858>,<-1.0812,22.63974,-0.88031>,
            
    /*4*/ <-1.11913,22.84522,-0.94245>

    /* stem 0.31.15*/ 
    /*0*/ <-1.05494,22.44193,-0.71156>,
    /*1*/ <-1.0552,22.44222,-0.70943>,<-1.05651,22.44252,-0.71294>,<-1.05311,22.44105,-0.71232>,
            
    /*2*/ <-0.97283,22.62718,-0.72536>,<-0.9737,22.62737,-0.7277>,<-0.97143,22.6264,-0.72729>,
            
    /*3*/ <-0.91526,22.82051,-0.74918>,<-0.91573,22.82051,-0.75034>,<-0.91454,22.82018,-0.75015>,
            
    /*4*/ <-0.89158,23.02173,-0.76246>

    /* stem 0.31.16*/ 
    /*0*/ <-1.09914,22.62002,-0.74138>,
    /*1*/ <-1.09974,22.61989,-0.74129>,<-1.09896,22.62031,-0.7419>,<-1.09872,22.61986,-0.74095>,
            
    /*2*/ <-1.12456,22.78619,-0.6567>,<-1.12404,22.78647,-0.6571>,<-1.12388,22.78617,-0.65647>,
            
    /*3*/ <-1.12293,22.96746,-0.60579>,<-1.12266,22.96753,-0.60602>,<-1.12259,22.96743,-0.60568>,
            
    /*4*/ <-1.13451,23.15303,-0.57656>

    /* stem 0.32*/ 
    /*0*/ <0,20.13002,0>,
    /*1*/ <0.02434,20.13002,0.00935>,<-0.00017,20.14242,0.02294>,<-0.02445,20.13769,0.00483>,
            <-0.01494,20.12236,-0.01995>,<0.01522,20.11762,-0.01716>,
    /*2*/ <0.20734,21.05367,-0.49162>,<0.19099,21.06193,-0.48255>,<0.1748,21.05878,-0.49463>,
            <0.18115,21.04856,-0.51115>,<0.20125,21.0454,-0.50929>,
    /*3*/ <0.35061,22.03297,-0.88911>,<0.34228,22.03625,-0.88417>,<0.33425,22.035,-0.89036>,
            <0.33761,22.03095,-0.89912>,<0.34772,22.0297,-0.89835>,
    /*4*/ <0.45211,23.0547,-1.17779>

    /* stem 0.32.0*/ 
    /*0*/ <0.01915,20.22256,-0.04988>,
    /*1*/ <0.01843,20.22632,-0.04318>,<0.01381,20.22344,-0.05538>,<0.0252,20.21793,-0.05108>,
            
    /*2*/ <0.23396,20.5469,-0.20306>,<0.23087,20.54498,-0.2112>,<0.23847,20.54131,-0.20833>,
            
    /*3*/ <0.40931,20.90796,-0.3172>,<0.40793,20.90733,-0.32139>,<0.41191,20.9058,-0.32011>,
            
    /*4*/ <0.56556,21.2698,-0.457>

    /* stem 0.32.1*/ 
    /*0*/ <0.06629,20.45043,-0.1727>,
    /*1*/ <0.05926,20.45201,-0.17247>,<0.06972,20.45014,-0.17904>,<0.0699,20.44913,-0.16659>,
            
    /*2*/ <0.14937,20.83749,-0.14228>,<0.15634,20.83625,-0.14666>,<0.15647,20.83557,-0.13836>,
            
    /*3*/ <0.21784,21.22707,-0.1735>,<0.2213,21.22631,-0.17571>,<0.2215,21.2266,-0.17156>,
            
    /*4*/ <0.28249,21.61556,-0.22356>

    /* stem 0.32.2*/ 
    /*0*/ <0.09249,20.57706,-0.24095>,
    /*1*/ <0.09009,20.57436,-0.24688>,<0.09926,20.57843,-0.24026>,<0.08813,20.57839,-0.23572>,
            
    /*2*/ <0.0334,20.9303,-0.38316>,<0.03951,20.93301,-0.37874>,<0.03209,20.93298,-0.37572>,
            
    /*3*/ <0.06802,21.28991,-0.51833>,<0.07108,21.29057,-0.51583>,<0.06733,21.29137,-0.51466>,
            
    /*4*/ <0.14001,21.64253,-0.65611>

    /* stem 0.32.3*/ 
    /*0*/ <0.14504,20.831,-0.37783>,
    /*1*/ <0.15028,20.82848,-0.3805>,<0.14558,20.8357,-0.37352>,<0.13925,20.82883,-0.37948>,
            
    /*2*/ <0.13184,21.07495,-0.64481>,<0.12871,21.07976,-0.64016>,<0.12449,21.07518,-0.64413>,
            
    /*3*/ <0.15874,21.38902,-0.82312>,<0.15714,21.39079,-0.8203>,<0.15507,21.38941,-0.82303>,
            
    /*4*/ <0.2739,21.70323,-0.95998>

    /* stem 0.32.4*/ 
    /*0*/ <0.16994,20.95135,-0.4427>,
    /*1*/ <0.17433,20.95265,-0.43861>,<0.1653,20.95528,-0.44358>,<0.17018,20.94613,-0.44592>,
            
    /*2*/ <0.35771,21.11481,-0.6898>,<0.35169,21.11656,-0.69312>,<0.35494,21.11046,-0.69468>,
            
    /*3*/ <0.50321,21.38574,-0.8572>,<0.5001,21.3865,-0.85872>,<0.50237,21.38429,-0.86032>,
            
    /*4*/ <0.63047,21.69568,-0.96017>

    /* stem 0.32.5*/ 
    /*0*/ <0.198,21.09829,-0.51582>,
    /*1*/ <0.19499,21.10055,-0.51135>,<0.19613,21.09906,-0.52129>,<0.20289,21.09525,-0.5148>,
            
    /*2*/ <0.37694,21.38374,-0.53463>,<0.3777,21.38275,-0.54125>,<0.38221,21.38021,-0.53692>,
            
    /*3*/ <0.47431,21.69376,-0.62534>,<0.47446,21.69279,-0.62857>,<0.47718,21.69251,-0.6266>,
            
    /*4*/ <0.53679,21.99694,-0.75987>

    /* stem 0.32.6*/ 
    /*0*/ <0.23293,21.32424,-0.60681>,
    /*1*/ <0.22786,21.32428,-0.60866>,<0.23706,21.325,-0.61021>,<0.23388,21.32345,-0.60155>,
            
    /*2*/ <0.2135,21.63758,-0.55783>,<0.21963,21.63806,-0.55886>,<0.21751,21.63703,-0.55309>,
            
    /*3*/ <0.22027,21.95467,-0.53734>,<0.22334,21.95466,-0.53788>,<0.22227,21.95449,-0.53495>,
            
    /*4*/ <0.23972,22.27115,-0.55748>

    /* stem 0.32.7*/ 
    /*0*/ <0.25255,21.45114,-0.65791>,
    /*1*/ <0.25303,21.44915,-0.66265>,<0.25657,21.45345,-0.65566>,<0.24804,21.4508,-0.65542>,
            
    /*2*/ <0.16605,21.71789,-0.78207>,<0.16841,21.72075,-0.77741>,<0.16273,21.71898,-0.77725>,
            
    /*3*/ <0.1684,21.99563,-0.91168>,<0.16962,21.99678,-0.90923>,<0.16666,21.99667,-0.90951>,
            
    /*4*/ <0.22341,22.28648,-0.99277>

    /* stem 0.32.8*/ 
    /*0*/ <0.28167,21.63952,-0.73378>,
    /*1*/ <0.28638,21.63866,-0.73411>,<0.28011,21.64348,-0.73155>,<0.27852,21.63643,-0.73567>,
            
    /*2*/ <0.29344,21.78372,-0.98541>,<0.28926,21.78694,-0.98371>,<0.2882,21.78224,-0.98645>,
            
    /*3*/ <0.29644,21.97402,-1.20477>,<0.29433,21.97541,-1.20361>,<0.29382,21.97336,-1.2054>,
            
    /*4*/ <0.25663,22.20758,-1.37295>

    /* stem 0.32.9*/ 
    /*0*/ <0.30469,21.78846,-0.79375>,
    /*1*/ <0.30627,21.78984,-0.78974>,<0.30085,21.7902,-0.79539>,<0.30696,21.78535,-0.79613>,
            
    /*2*/ <0.45017,21.99015,-0.91642>,<0.44656,21.9904,-0.92019>,<0.45063,21.98716,-0.92068>,
            
    /*3*/ <0.51643,22.21419,-1.06656>,<0.51436,22.21378,-1.06811>,<0.51667,22.2127,-1.0687>,
            
    /*4*/ <0.54174,22.45406,-1.20331>

    /* stem 0.32.10*/ 
    /*0*/ <0.33406,21.97843,-0.87026>,
    /*1*/ <0.33061,21.97975,-0.8683>,<0.3344,21.97886,-0.8744>,<0.33716,21.97668,-0.86807>,
            
    /*2*/ <0.44075,22.21378,-0.83546>,<0.44327,22.21319,-0.83953>,<0.44511,22.21173,-0.83531>,
            
    /*3*/ <0.53302,22.45751,-0.83009>,<0.53423,22.45711,-0.83213>,<0.53528,22.45667,-0.83>,
            
    /*4*/ <0.5719,22.70836,-0.88922>

    /* stem 0.32.11*/ 
    /*0*/ <0.35207,22.12226,-0.91718>,
    /*1*/ <0.34927,22.1218,-0.91989>,<0.3557,22.1233,-0.91826>,<0.35124,22.12169,-0.91338>,
            
    /*2*/ <0.28883,22.36168,-0.89611>,<0.29311,22.36268,-0.89502>,<0.29014,22.3616,-0.89177>,
            
    /*3*/ <0.25816,22.60828,-0.90073>,<0.26034,22.60857,-0.90019>,<0.25878,22.60841,-0.89856>,
            
    /*4*/ <0.24425,22.85471,-0.92945>

    /* stem 0.32.12*/ 
    /*0*/ <0.38051,22.38735,-0.99127>,
    /*1*/ <0.3823,22.38637,-0.99408>,<0.38183,22.38973,-0.98911>,<0.3774,22.38595,-0.99061>,
            
    /*2*/ <0.2824,22.55078,-1.1134>,<0.28209,22.55302,-1.11008>,<0.27913,22.5505,-1.11108>,
            
    /*3*/ <0.24385,22.75545,-1.20224>,<0.24381,22.75625,-1.2004>,<0.24212,22.75557,-1.20124>,
            
    /*4*/ <0.25341,22.96811,-1.27906>

    /* stem 0.32.13*/ 
    /*0*/ <0.39306,22.50428,-1.02395>,
    /*1*/ <0.39616,22.50424,-1.02287>,<0.39091,22.50641,-1.02269>,<0.3921,22.50217,-1.02628>,
            
    /*2*/ <0.44938,22.64831,-1.17563>,<0.44587,22.64976,-1.17551>,<0.44667,22.64693,-1.1779>,
            
    /*3*/ <0.47206,22.8397,-1.27477>,<0.47023,22.84008,-1.27446>,<0.47076,22.8392,-1.27605>,
            
    /*4*/ <0.50915,23.04802,-1.3204>

    /* stem 0.32.14*/ 
    /*0*/ <0.41899,22.746,-1.09151>,
    /*1*/ <0.41876,22.74673,-1.089>,<0.4171,22.7466,-1.09323>,<0.42111,22.74467,-1.0923>,
            
    /*2*/ <0.50978,22.91582,-1.13032>,<0.50868,22.91573,-1.13314>,<0.51135,22.91445,-1.13252>,
            
    /*3*/ <0.57782,23.09495,-1.17339>,<0.57724,23.09484,-1.17478>,<0.57865,23.09437,-1.17451>,
            
    /*4*/ <0.61001,23.28753,-1.19356>

    /* stem 0.32.15*/ 
    /*0*/ <0.44558,22.99384,-1.16078>,
    /*1*/ <0.44507,22.99391,-1.16073>,<0.44581,22.99395,-1.16123>,<0.44586,22.99366,-1.16038>,
            
    /*2*/ <0.4734,23.1589,-1.10727>,<0.47389,23.15892,-1.10761>,<0.47393,23.15873,-1.10705>,
            
    /*3*/ <0.53421,23.3214,-1.079>,<0.53444,23.32135,-1.07918>,<0.53446,23.32129,-1.07889>,
            
    /*4*/ <0.6094,23.47924,-1.06117>

    /* stem 0.33*/ 
    /*0*/ <0,20.89617,0>,
    /*1*/ <-0.00319,20.89617,0.02271>,<-0.01969,20.90707,0.00439>,<-0.00898,20.90291,-0.02>,
            <0.01414,20.88943,-0.01675>,<0.01772,20.88526,0.00965>,
    /*2*/ <0.47633,21.73303,0.08239>,<0.46533,21.7403,0.07017>,<0.47247,21.73752,0.05391>,
            <0.48789,21.72853,0.05608>,<0.49027,21.72575,0.07368>,
    /*3*/ <0.85641,22.62032,0.12808>,<0.85053,22.6232,0.12192>,<0.85425,22.6221,0.11381>,
            <0.86242,22.61854,0.11496>,<0.86376,22.61744,0.12378>,
    /*4*/ <1.13192,23.54605,0.15908>

    /* stem 0.33.0*/ 
    /*0*/ <0.08141,21.03856,0.01144>,
    /*1*/ <0.07564,21.04181,0.01214>,<0.08528,21.03976,0.00615>,<0.08332,21.03412,0.01603>,
            
    /*2*/ <0.25246,21.31108,0.20093>,<0.25889,21.30971,0.19694>,<0.25758,21.30596,0.20352>,
            
    /*3*/ <0.35387,21.6338,0.3565>,<0.35729,21.63359,0.35475>,<0.35682,21.63205,0.35824>,
            
    /*4*/ <0.44863,21.97957,0.46052>

    /* stem 0.33.1*/ 
    /*0*/ <0.1418,21.14418,0.01993>,
    /*1*/ <0.14018,21.1456,0.01386>,<0.148,21.14354,0.02154>,<0.13722,21.14342,0.02438>,
            
    /*2*/ <0.15733,21.49988,0.09393>,<0.16254,21.49851,0.09905>,<0.15535,21.49843,0.10095>,
            
    /*3*/ <0.22151,21.8559,0.12662>,<0.22413,21.85521,0.12917>,<0.22061,21.85575,0.13023>,
            
    /*4*/ <0.30929,22.19872,0.21171>

    /* stem 0.33.2*/ 
    /*0*/ <0.25008,21.33358,0.03515>,
    /*1*/ <0.25464,21.33123,0.03195>,<0.25098,21.3353,0.04087>,<0.24463,21.33421,0.03263>,
            
    /*2*/ <0.34005,21.6489,-0.07573>,<0.33761,21.65161,-0.06979>,<0.33338,21.65089,-0.07528>,
            
    /*3*/ <0.43736,21.97388,-0.1453>,<0.43605,21.97494,-0.14225>,<0.43404,21.97493,-0.1451>,
            
    /*4*/ <0.54926,22.299,-0.18529>

    /* stem 0.33.3*/ 
    /*0*/ <0.33305,21.4787,0.04681>,
    /*1*/ <0.33644,21.47644,0.05085>,<0.32947,21.48298,0.04813>,<0.33325,21.47668,0.04144>,
            
    /*2*/ <0.57223,21.69855,-0.02514>,<0.56759,21.70291,-0.02695>,<0.57011,21.69871,-0.03141>,
            
    /*3*/ <0.769,21.96165,-0.07943>,<0.76636,21.96348,-0.08025>,<0.76799,21.96178,-0.08258>,
            
    /*4*/ <0.92525,22.25377,-0.11156>

    /* stem 0.33.4*/ 
    /*0*/ <0.43451,21.65615,0.06107>,
    /*1*/ <0.43188,21.65729,0.06561>,<0.43408,21.65943,0.05683>,<0.43756,21.65174,0.06075>,
            
    /*2*/ <0.68223,21.82204,0.16685>,<0.68369,21.82347,0.161>,<0.68601,21.81834,0.16361>,
            
    /*3*/ <0.88477,22.04924,0.25203>,<0.88537,22.04985,0.24905>,<0.88707,22.04775,0.25058>,
            
    /*4*/ <1.05349,22.30235,0.33835>

    /* stem 0.33.5*/ 
    /*0*/ <0.50106,21.78593,0.07042>,
    /*1*/ <0.49666,21.78791,0.06873>,<0.50539,21.78672,0.06781>,<0.50113,21.78316,0.07472>,
            
    /*2*/ <0.54962,22.04,0.23132>,<0.55544,22.03921,0.23071>,<0.5526,22.03684,0.23532>,
            
    /*3*/ <0.58438,22.30397,0.37874>,<0.58731,22.30373,0.37852>,<0.58591,22.3026,0.38086>,
            
    /*4*/ <0.65672,22.59445,0.43487>

    /* stem 0.33.6*/ 
    /*0*/ <0.59937,22.01608,0.08424>,
    /*1*/ <0.59995,22.01612,0.07959>,<0.60299,22.01702,0.08705>,<0.59517,22.01512,0.08607>,
            
    /*2*/ <0.53317,22.29269,0.07479>,<0.5352,22.2933,0.07977>,<0.52999,22.29203,0.07911>,
            
    /*3*/ <0.50757,22.57598,0.08686>,<0.50862,22.57598,0.08935>,<0.50595,22.57575,0.08902>,
            
    /*4*/ <0.46769,22.85768,0.08804>

    /* stem 0.33.7*/ 
    /*0*/ <0.65551,22.1475,0.09213>,
    /*1*/ <0.65957,22.14579,0.09161>,<0.65453,22.14985,0.09576>,<0.65242,22.14686,0.089>,
            
    /*2*/ <0.73824,22.37501,-0.03434>,<0.73488,22.37771,-0.03157>,<0.73347,22.37572,-0.03608>,
            
    /*3*/ <0.80083,22.62262,-0.13188>,<0.79905,22.62367,-0.13037>,<0.79843,22.6229,-0.13273>,
            
    /*4*/ <0.8683,22.87986,-0.19413>

    /* stem 0.33.8*/ 
    /*0*/ <0.74896,22.36627,0.10526>,
    /*1*/ <0.75012,22.36554,0.10906>,<0.74671,22.36952,0.10442>,<0.75004,22.36375,0.1023>,
            
    /*2*/ <0.96087,22.50162,0.06892>,<0.9586,22.50428,0.06583>,<0.96081,22.50042,0.06441>,
            
    /*3*/ <1.11429,22.6923,-0.0014>,<1.11261,22.69315,-0.00279>,<1.11415,22.6916,-0.00362>,
            
    /*4*/ <1.21195,22.92362,-0.04002>

    /* stem 0.33.9*/ 
    /*0*/ <0.81446,22.51961,0.11446>,
    /*1*/ <0.8115,22.52075,0.11649>,<0.81516,22.52118,0.11111>,<0.81671,22.5169,0.11579>,
            
    /*2*/ <0.94982,22.68679,0.22248>,<0.95226,22.68707,0.21889>,<0.95329,22.68422,0.22201>,
            
    /*3*/ <1.04971,22.89064,0.30161>,<1.05091,22.89077,0.2998>,<1.05168,22.88972,0.30154>,
            
    /*4*/ <1.14445,23.11022,0.3297>

    /* stem 0.33.10*/ 
    /*0*/ <0.89732,22.75472,0.12611>,
    /*1*/ <0.89505,22.75549,0.12375>,<0.90053,22.75565,0.12573>,<0.89638,22.75302,0.12886>,
            
    /*2*/ <0.85305,22.94562,0.22764>,<0.8567,22.94572,0.22896>,<0.85393,22.94397,0.23105>,
            
    /*3*/ <0.83819,23.15315,0.30102>,<0.84003,23.15308,0.30162>,<0.8386,23.15255,0.30282>,
            
    /*4*/ <0.82205,23.35923,0.37837>

    /* stem 0.33.11*/ 
    /*0*/ <0.94635,22.92011,0.133>,
    /*1*/ <0.94794,22.91975,0.13037>,<0.94782,22.92096,0.13559>,<0.9433,22.91961,0.13305>,
            
    /*2*/ <0.91463,23.11865,0.08421>,<0.91455,23.11946,0.08769>,<0.91154,23.11856,0.08599>,
            
    /*3*/ <0.9053,23.3193,0.03529>,<0.90526,23.31973,0.03702>,<0.90374,23.31944,0.03614>,
            
    /*4*/ <0.90554,23.5226,-0.00318>

    /* stem 0.33.12*/ 
    /*0*/ <0.98508,23.05074,0.13844>,
    /*1*/ <0.98769,23.04993,0.13937>,<0.98336,23.0523,0.14016>,<0.98419,23.05,0.1358>,
            
    /*2*/ <1.06375,23.21532,0.06678>,<1.06087,23.21689,0.06731>,<1.06142,23.21537,0.06441>,
            
    /*3*/ <1.09896,23.40589,0.03566>,<1.09738,23.40625,0.03603>,<1.09781,23.40591,0.03446>,
            
    /*4*/ <1.10168,23.59911,0.00209>

    /* stem 0.33.13*/ 
    /*0*/ <1.03625,23.22335,0.14564>,
    /*1*/ <1.03598,23.22332,0.14823>,<1.03485,23.22501,0.14419>,<1.03793,23.22171,0.14449>,
            
    /*2*/ <1.16777,23.34737,0.16265>,<1.16702,23.3485,0.15996>,<1.16907,23.3463,0.16015>,
            
    /*3*/ <1.28411,23.48591,0.17781>,<1.28369,23.48642,0.17646>,<1.28483,23.48545,0.17657>,
            
    /*4*/ <1.37784,23.6414,0.18164>

    /* stem 0.33.14*/ 
    /*0*/ <1.09567,23.42375,0.15399>,
    /*1*/ <1.0947,23.42403,0.15411>,<1.09623,23.42419,0.15327>,<1.09607,23.42303,0.15457>,
            
    /*2*/ <1.14284,23.53829,0.26272>,<1.14385,23.5384,0.26216>,<1.14374,23.53763,0.26302>,
            
    /*3*/ <1.19871,23.67656,0.33297>,<1.19918,23.67654,0.33263>,<1.19918,23.67628,0.33315>,
            
    /*4*/ <1.24403,23.81607,0.40808>

    /* stem 0.34*/ 
    /*0*/ <0,21.42309,0>,
    /*1*/ <-0.02073,21.42309,0.00181>,<-0.0079,21.43299,-0.01651>,<0.01585,21.42921,-0.01202>,
            <0.01769,21.41698,0.00909>,<-0.00491,21.4132,0.01763>,
    /*2*/ <0.02525,22.19957,0.4478>,<0.03381,22.20617,0.43558>,<0.04964,22.20365,0.43858>,
            <0.05087,22.19549,0.45265>,<0.0358,22.19297,0.45835>,
    /*3*/ <0.06311,23.02284,0.80097>,<0.06736,23.02545,0.79452>,<0.07529,23.02446,0.79615>,
            <0.07594,23.02123,0.80361>,<0.06842,23.02023,0.80659>,
    /*4*/ <0.09243,23.88177,1.05654>

    /* stem 0.34.0*/ 
    /*0*/ <0.00686,21.55948,0.07845>,
    /*1*/ <0.00507,21.56242,0.07349>,<0.01223,21.56072,0.08091>,<0.00329,21.5553,0.08094>,
            
    /*2*/ <-0.14121,21.80464,0.2727>,<-0.13643,21.8035,0.27765>,<-0.14239,21.79989,0.27766>,
            
    /*3*/ <-0.23386,22.08562,0.45174>,<-0.23141,22.08494,0.45412>,<-0.23462,22.08363,0.4545>,
            
    /*4*/ <-0.31673,22.36945,0.63155>

    /* stem 0.34.1*/ 
    /*0*/ <0.01375,21.69638,0.15718>,
    /*1*/ <0.01871,21.69764,0.15456>,<0.01339,21.69664,0.16291>,<0.00916,21.69486,0.15407>,
            
    /*2*/ <-0.07498,22.01701,0.13512>,<-0.07853,22.01634,0.14069>,<-0.08135,22.01516,0.1348>,
            
    /*3*/ <-0.13005,22.34385,0.1701>,<-0.13177,22.34328,0.17288>,<-0.13333,22.34333,0.16995>,
            
    /*4*/ <-0.18034,22.66974,0.21943>

    /* stem 0.34.2*/ 
    /*0*/ <0.01857,21.7921,0.21224>,
    /*1*/ <0.02238,21.78994,0.21566>,<0.01377,21.79402,0.21428>,<0.01956,21.79234,0.20678>,
            
    /*2*/ <0.15417,22.08434,0.25169>,<0.14843,22.08705,0.25078>,<0.15229,22.08594,0.24578>,
            
    /*3*/ <0.25461,22.36644,0.37575>,<0.2517,22.36771,0.37527>,<0.25393,22.36792,0.37298>,
            
    /*4*/ <0.31666,22.64867,0.52366>

    /* stem 0.34.3*/ 
    /*0*/ <0.02759,21.97131,0.31531>,
    /*1*/ <0.02471,21.96926,0.31911>,<0.02599,21.9756,0.31287>,<0.03206,21.96906,0.31394>,
            
    /*2*/ <0.17544,22.14305,0.52392>,<0.17629,22.14727,0.51975>,<0.18034,22.14291,0.52047>,
            
    /*3*/ <0.32944,22.35744,0.68373>,<0.32957,22.35917,0.6813>,<0.33176,22.3572,0.68185>,
            
    /*4*/ <0.45851,22.58171,0.85063>

    /* stem 0.34.4*/ 
    /*0*/ <0.03649,22.14828,0.41709>,
    /*1*/ <0.03197,22.1493,0.41571>,<0.04004,22.15145,0.41628>,<0.03746,22.14408,0.41928>,
            
    /*2*/ <-0.01779,22.27248,0.67535>,<-0.01241,22.27392,0.67573>,<-0.01413,22.269,0.67773>,
            
    /*3*/ <0.00113,22.44957,0.90694>,<0.00386,22.44991,0.90647>,<0.00298,22.44784,0.90812>,
            
    /*4*/ <0.02533,22.68411,1.0784>

    /* stem 0.34.5*/ 
    /*0*/ <0.04408,22.33277,0.50383>,
    /*1*/ <0.04466,22.33451,0.49974>,<0.04713,22.3335,0.50703>,<0.04045,22.3303,0.50473>,
            
    /*2*/ <-0.09091,22.56088,0.57832>,<-0.08926,22.56021,0.58318>,<-0.09371,22.55807,0.58164>,
            
    /*3*/ <-0.15845,22.80919,0.67618>,<-0.15748,22.80855,0.6785>,<-0.15997,22.80809,0.67796>,
            
    /*4*/ <-0.22293,23.05484,0.78259>

    /* stem 0.34.6*/ 
    /*0*/ <0.05222,22.54936,0.59691>,
    /*1*/ <0.05629,22.54939,0.59648>,<0.05054,22.55009,0.60056>,<0.04984,22.54861,0.59367>,
            
    /*2*/ <0.04769,22.80017,0.54359>,<0.04386,22.80063,0.54631>,<0.04339,22.79965,0.54171>,
            
    /*3*/ <0.01481,23.05397,0.52321>,<0.01292,23.05385,0.52461>,<0.01268,23.05363,0.52227>,
            
    /*4*/ <-0.00758,23.30925,0.53181>

    /* stem 0.34.7*/ 
    /*0*/ <0.06032,22.76481,0.68949>,
    /*1*/ <0.0615,22.76339,0.6927>,<0.05692,22.76625,0.68924>,<0.06254,22.76479,0.68652>,
            
    /*2*/ <0.14681,22.97646,0.75441>,<0.14375,22.97837,0.7521>,<0.1475,22.9774,0.75029>,
            
    /*3*/ <0.19199,23.20436,0.80581>,<0.19037,23.20497,0.80456>,<0.19234,23.20477,0.80374>,
            
    /*4*/ <0.24086,23.4361,0.82726>

    /* stem 0.34.8*/ 
    /*0*/ <0.06781,22.96401,0.77509>,
    /*1*/ <0.06495,22.96341,0.77674>,<0.06809,22.96675,0.77316>,<0.07039,22.96189,0.77536>,
            
    /*2*/ <0.14167,23.0778,0.94869>,<0.14376,23.08002,0.9463>,<0.1453,23.07678,0.94777>,
            
    /*3*/ <0.17055,23.24506,1.0889>,<0.17155,23.24603,1.08755>,<0.17247,23.24484,1.08877>,
            
    /*4*/ <0.17861,23.42783,1.21158>

    /* stem 0.34.9*/ 
    /*0*/ <0.07299,23.13668,0.83432>,
    /*1*/ <0.07083,23.13736,0.83225>,<0.07568,23.13818,0.83428>,<0.07247,23.13452,0.83643>,
            
    /*2*/ <-0.00575,23.27931,0.95987>,<-0.00253,23.27986,0.96123>,<-0.00466,23.27742,0.96266>,
            
    /*3*/ <-0.06363,23.43255,1.0844>,<-0.06197,23.43271,1.08499>,<-0.06309,23.43162,1.08581>,
            
    /*4*/ <-0.08994,23.61408,1.1774>

    /* stem 0.34.10*/ 
    /*0*/ <0.07724,23.29938,0.88284>,
    /*1*/ <0.07874,23.30003,0.88056>,<0.07815,23.30017,0.88538>,<0.07483,23.29796,0.88259>,
            
    /*2*/ <-0.01807,23.4652,0.86482>,<-0.01846,23.46529,0.86804>,<-0.02067,23.46382,0.86618>,
            
    /*3*/ <-0.11928,23.62864,0.8683>,<-0.11939,23.62854,0.86991>,<-0.12053,23.62786,0.86897>,
            
    /*4*/ <-0.18889,23.80694,0.85428>

    /* stem 0.34.11*/ 
    /*0*/ <0.08112,23.4482,0.92723>,
    /*1*/ <0.08355,23.4479,0.92802>,<0.07932,23.44901,0.92888>,<0.0805,23.4477,0.92478>,
            
    /*2*/ <0.1182,23.61855,0.88375>,<0.11538,23.61928,0.88432>,<0.11616,23.61841,0.88159>,
            
    /*3*/ <0.17647,23.78551,0.8535>,<0.17511,23.78604,0.85376>,<0.17551,23.78565,0.85238>,
            
    /*4*/ <0.23179,23.95588,0.8398>

    /* stem 0.34.12*/ 
    /*0*/ <0.08466,23.58363,0.96762>,
    /*1*/ <0.0844,23.58296,0.96987>,<0.08311,23.58514,0.96665>,<0.08645,23.58279,0.96633>,
            
    /*2*/ <0.18046,23.71251,1.01819>,<0.1796,23.71396,1.01604>,<0.18183,23.71239,1.01583>,
            
    /*3*/ <0.25227,23.85754,1.06469>,<0.25178,23.85815,1.06357>,<0.25301,23.85756,1.06354>,
            
    /*4*/ <0.3018,24.012,1.1098>

    /* stem 0.34.13*/ 
    /*0*/ <0.08913,23.75504,1.01874>,
    /*1*/ <0.08811,23.75503,1.01886>,<0.08956,23.7557,1.01808>,<0.08972,23.7544,1.01927>,
            
    /*2*/ <0.10103,23.85963,1.1312>,<0.10199,23.86007,1.13068>,<0.1021,23.85921,1.13148>,
            
    /*3*/ <0.10931,23.98539,1.21975>,<0.10979,23.98557,1.21945>,<0.10985,23.98523,1.21993>,
            
    /*4*/ <0.11014,24.11856,1.29715>

    /* stem 0.35*/ 
    /*0*/ <0,21.8956,0>,
    /*1*/ <-0.00585,21.8956,-0.018>,<0.01302,21.9046,-0.01038>,<0.0139,21.90117,0.01159>,
            <-0.00443,21.89004,0.01754>,<-0.01664,21.8866,-0.00075>,
    /*2*/ <-0.4003,22.61753,0.1168>,<-0.38772,22.62353,0.12188>,<-0.38714,22.62124,0.13652>,
            <-0.39936,22.61382,0.14049>,<-0.4075,22.61153,0.1283>,
    /*3*/ <-0.71237,23.38296,0.22483>,<-0.70578,23.38534,0.22727>,<-0.7056,23.38443,0.23463>,
            <-0.71208,23.38149,0.23674>,<-0.71626,23.38059,0.23068>,
    /*4*/ <-0.9378,24.18155,0.30471>

    /* stem 0.35.0*/ 
    /*0*/ <-0.06535,22.01462,0.02123>,
    /*1*/ <-0.06132,22.01731,0.01862>,<-0.06606,22.01531,0.02665>,<-0.06868,22.01125,0.01843>,
            
    /*2*/ <-0.26328,22.26221,-0.03803>,<-0.26644,22.26088,-0.03268>,<-0.26819,22.25817,-0.03816>,
            
    /*3*/ <-0.4142,22.53709,-0.11019>,<-0.41601,22.53679,-0.10759>,<-0.41697,22.53554,-0.11035>,
            
    /*4*/ <-0.4881,22.84694,-0.15783>

    /* stem 0.35.1*/ 
    /*0*/ <-0.12669,22.12632,0.04116>,
    /*1*/ <-0.12332,22.12748,0.04506>,<-0.13189,22.12638,0.04207>,<-0.12486,22.12511,0.03636>,
            
    /*2*/ <-0.13523,22.42854,-0.03649>,<-0.14094,22.42781,-0.03848>,<-0.13626,22.42696,-0.04229>,
            
    /*3*/ <-0.12649,22.73599,-0.08715>,<-0.12935,22.73591,-0.08819>,<-0.12702,22.73553,-0.09012>,
            
    /*4*/ <-0.18165,23.04082,-0.12692>

    /* stem 0.35.2*/ 
    /*0*/ <-0.20708,22.27273,0.06728>,
    /*1*/ <-0.2093,22.27079,0.0713>,<-0.20975,22.27371,0.06319>,<-0.20219,22.27369,0.06736>,
            
    /*2*/ <-0.26402,22.54658,0.17189>,<-0.26431,22.54852,0.16648>,<-0.25928,22.54851,0.16926>,
            
    /*3*/ <-0.38817,22.81137,0.23206>,<-0.3882,22.81201,0.22926>,<-0.38592,22.81271,0.23087>,
            
    /*4*/ <-0.47607,23.09374,0.2749>

    /* stem 0.35.3*/ 
    /*0*/ <-0.29535,22.43349,0.09597>,
    /*1*/ <-0.29927,22.43166,0.09422>,<-0.29313,22.43687,0.09365>,<-0.29366,22.43195,0.10003>,
            
    /*2*/ <-0.45107,22.62751,0.23247>,<-0.44698,22.63099,0.23209>,<-0.44734,22.62771,0.23635>,
            
    /*3*/ <-0.5947,22.85135,0.3315>,<-0.59251,22.8529,0.33121>,<-0.59294,22.8516,0.33352>,
            
    /*4*/ <-0.71534,23.09977,0.39711>

    /* stem 0.35.4*/ 
    /*0*/ <-0.37131,22.57182,0.12065>,
    /*1*/ <-0.37101,22.57275,0.11636>,<-0.36905,22.5742,0.12357>,<-0.37386,22.56852,0.122>,
            
    /*2*/ <-0.58025,22.74327,0.14022>,<-0.57895,22.74424,0.14503>,<-0.58215,22.74045,0.14398>,
            
    /*3*/ <-0.75955,22.94114,0.18732>,<-0.75866,22.9414,0.18968>,<-0.76056,22.93979,0.18921>,
            
    /*4*/ <-0.85237,23.18858,0.24719>

    /* stem 0.35.5*/ 
    /*0*/ <-0.4505,22.7494,0.14638>,
    /*1*/ <-0.44677,22.75097,0.14605>,<-0.45285,22.75038,0.14954>,<-0.45189,22.74684,0.14353>,
            
    /*2*/ <-0.54268,22.94783,0.01486>,<-0.54674,22.94743,0.01719>,<-0.54609,22.94508,0.01318>,
            
    /*3*/ <-0.65047,23.16427,-0.06721>,<-0.65238,23.16383,-0.06591>,<-0.65225,23.16305,-0.06812>,
            
    /*4*/ <-0.74729,23.4004,-0.06956>

    /* stem 0.35.6*/ 
    /*0*/ <-0.50359,22.87879,0.16362>,
    /*1*/ <-0.50234,22.87882,0.16725>,<-0.50726,22.87957,0.16285>,<-0.50116,22.87799,0.16077>,
            
    /*2*/ <-0.44839,23.11579,0.14568>,<-0.45167,23.11629,0.14274>,<-0.4476,23.11524,0.14136>,
            
    /*3*/ <-0.40264,23.35527,0.14064>,<-0.40427,23.35556,0.13917>,<-0.40221,23.35515,0.13847>,
            
    /*4*/ <-0.42161,23.5956,0.17759>

    /* stem 0.35.7*/ 
    /*0*/ <-0.57881,23.06215,0.18807>,
    /*1*/ <-0.58152,23.0608,0.18984>,<-0.57934,23.06369,0.18496>,<-0.57557,23.06196,0.1894>,
            
    /*2*/ <-0.61195,23.26153,0.29364>,<-0.6105,23.26345,0.29039>,<-0.60799,23.2623,0.29335>,
            
    /*3*/ <-0.67211,23.46656,0.37299>,<-0.67136,23.46743,0.37132>,<-0.67017,23.46715,0.37294>,
            
    /*4*/ <-0.7238,23.68802,0.39233>

    /* stem 0.35.8*/ 
    /*0*/ <-0.6532,23.24349,0.21224>,
    /*1*/ <-0.65535,23.24292,0.20994>,<-0.65114,23.24592,0.21193>,<-0.65312,23.24164,0.21485>,
            
    /*2*/ <-0.79242,23.37255,0.30713>,<-0.78961,23.37455,0.30845>,<-0.79093,23.3717,0.3104>,
            
    /*3*/ <-0.91863,23.527,0.37942>,<-0.91716,23.52793,0.38004>,<-0.91802,23.52672,0.38113>,
            
    /*4*/ <-1.03336,23.69459,0.44101>

    /* stem 0.35.9*/ 
    /*0*/ <-0.74439,23.50227,0.24187>,
    /*1*/ <-0.74301,23.50288,0.23954>,<-0.74373,23.50352,0.24424>,<-0.74644,23.5004,0.24181>,
            
    /*2*/ <-0.86839,23.64078,0.2021>,<-0.86887,23.64121,0.20523>,<-0.87067,23.63913,0.20361>,
            
    /*3*/ <-0.97303,23.79804,0.18074>,<-0.97319,23.79815,0.18233>,<-0.97426,23.79733,0.18148>,
            
    /*4*/ <-1.07544,23.95797,0.19178>

    /* stem 0.35.10*/ 
    /*0*/ <-0.77912,23.62423,0.25315>,
    /*1*/ <-0.77676,23.62482,0.25402>,<-0.78119,23.62474,0.2546>,<-0.7794,23.62313,0.25084>,
            
    /*2*/ <-0.79042,23.78725,0.17786>,<-0.79338,23.7872,0.17825>,<-0.79218,23.78613,0.17574>,
            
    /*3*/ <-0.80641,23.95024,0.10332>,<-0.80788,23.95019,0.10352>,<-0.80729,23.94967,0.10226>,
            
    /*4*/ <-0.84067,24.12169,0.0608>

    /* stem 0.35.11*/ 
    /*0*/ <-0.81605,23.75394,0.26515>,
    /*1*/ <-0.81626,23.75366,0.2675>,<-0.81786,23.75484,0.26389>,<-0.81403,23.75332,0.26405>,
            
    /*2*/ <-0.75534,23.90971,0.29054>,<-0.75641,23.91049,0.28813>,<-0.75386,23.90948,0.28824>,
            
    /*3*/ <-0.73349,24.07241,0.33029>,<-0.73404,24.07278,0.32908>,<-0.73269,24.07258,0.32919>,
            
    /*4*/ <-0.74098,24.2347,0.37699>

    /* stem 0.35.12*/ 
    /*0*/ <-0.87973,23.97761,0.28584>,
    /*1*/ <-0.88127,23.97715,0.28602>,<-0.87933,23.97864,0.28468>,<-0.8786,23.97703,0.28683>,
            
    /*2*/ <-0.90397,24.09236,0.38002>,<-0.90267,24.09335,0.37913>,<-0.90219,24.09227,0.38056>,
            
    /*3*/ <-0.92222,24.22518,0.44838>,<-0.92155,24.22555,0.44785>,<-0.92133,24.22516,0.44866>,
            
    /*4*/ <-0.95725,24.35839,0.50866>

    /* stem 0.35.13*/ 
    /*0*/ <-0.92635,24.14134,0.30099>,
    /*1*/ <-0.92646,24.14134,0.30069>,<-0.92613,24.14155,0.30108>,<-0.92647,24.14114,0.3012>,
            
    /*2*/ <-1.02332,24.23158,0.33494>,<-1.0231,24.23172,0.33519>,<-1.02332,24.23144,0.33528>,
            
    /*3*/ <-1.09839,24.34575,0.33913>,<-1.09827,24.34581,0.33925>,<-1.09842,24.34572,0.3393>,
            
    /*4*/ <-1.17351,24.45958,0.3489>

    /* stem 0.36*/ 
    /*0*/ <0,22.34716,0>,
    /*1*/ <0.01471,22.34716,-0.00884>,<0.01183,22.35532,0.00938>,<-0.0074,22.35221,0.01464>,
            <-0.0164,22.34212,-0.00034>,<-0.00273,22.339,-0.01485>,
    /*2*/ <-0.18927,23.01665,-0.33722>,<-0.19119,23.0221,-0.32507>,<-0.20401,23.02002,-0.32156>,
            <-0.21001,23.01329,-0.33155>,<-0.2009,23.01121,-0.34122>,
    /*3*/ <-0.35188,23.7265,-0.59673>,<-0.35269,23.72865,-0.59041>,<-0.35916,23.72783,-0.58875>,
            <-0.36234,23.72516,-0.59405>,<-0.35784,23.72434,-0.59898>,
    /*4*/ <-0.47097,24.46708,-0.78383>

    /* stem 0.36.0*/ 
    /*0*/ <-0.03003,22.44814,-0.04998>,
    /*1*/ <-0.02688,22.45059,-0.04693>,<-0.03486,22.44946,-0.05017>,<-0.02834,22.44439,-0.05283>,
            
    /*2*/ <0.03372,22.64434,-0.26768>,<0.02841,22.64359,-0.26983>,<0.03275,22.6402,-0.27161>,
            
    /*3*/ <0.09114,22.90031,-0.41128>,<0.08854,22.9002,-0.41254>,<0.09082,22.89897,-0.41382>,
            
    /*4*/ <0.0925,23.17659,-0.52802>

    /* stem 0.36.1*/ 
    /*0*/ <-0.07155,22.58778,-0.11908>,
    /*1*/ <-0.07427,22.58882,-0.11535>,<-0.07337,22.58792,-0.12345>,<-0.06701,22.5866,-0.11844>,
            
    /*2*/ <0.0015,22.86464,-0.13878>,<0.00211,22.86405,-0.14418>,<0.00634,22.86316,-0.14084>,
            
    /*3*/ <0.03737,23.14209,-0.20329>,<0.03761,23.14146,-0.20594>,<0.03983,23.14154,-0.20435>,
            
    /*4*/ <0.0183,23.42641,-0.23469>

    /* stem 0.36.2*/ 
    /*0*/ <-0.11577,22.73649,-0.19267>,
    /*1*/ <-0.1197,22.73477,-0.1938>,<-0.11308,22.73811,-0.19581>,<-0.11453,22.7366,-0.18841>,
            
    /*2*/ <-0.23418,22.98129,-0.16563>,<-0.22976,22.98352,-0.16698>,<-0.23073,22.98251,-0.16204>,
            
    /*3*/ <-0.34512,23.23042,-0.14791>,<-0.34288,23.23147,-0.14859>,<-0.3434,23.23106,-0.14612>,
            
    /*4*/ <-0.42891,23.48914,-0.17556>

    /* stem 0.36.3*/ 
    /*0*/ <-0.16803,22.91224,-0.27965>,
    /*1*/ <-0.16731,22.91063,-0.28335>,<-0.16588,22.9155,-0.27838>,<-0.1709,22.91061,-0.27722>,
            
    /*2*/ <-0.34361,23.06771,-0.38489>,<-0.34266,23.07095,-0.38158>,<-0.346,23.06769,-0.38081>,
            
    /*3*/ <-0.48111,23.2644,-0.47742>,<-0.48041,23.26575,-0.47561>,<-0.48238,23.26446,-0.47542>,
            
    /*4*/ <-0.58509,23.47031,-0.59054>

    /* stem 0.36.4*/ 
    /*0*/ <-0.20816,23.05753,-0.34644>,
    /*1*/ <-0.20442,23.05817,-0.34695>,<-0.21025,23.05996,-0.34434>,<-0.20981,23.05445,-0.34801>,
            
    /*2*/ <-0.25541,23.18753,-0.54724>,<-0.25929,23.18872,-0.54551>,<-0.259,23.18505,-0.54795>,
            
    /*3*/ <-0.27731,23.34675,-0.73016>,<-0.27926,23.3474,-0.72937>,<-0.27916,23.34574,-0.73083>,
            
    /*4*/ <-0.29889,23.54495,-0.87049>

    /* stem 0.36.5*/ 
    /*0*/ <-0.24663,23.23071,-0.41047>,
    /*1*/ <-0.24563,23.23207,-0.40738>,<-0.24979,23.23152,-0.41182>,<-0.24448,23.22852,-0.41221>,
            
    /*2*/ <-0.1531,23.41002,-0.51734>,<-0.15587,23.40966,-0.5203>,<-0.15234,23.40766,-0.52056>,
            
    /*3*/ <-0.0851,23.60345,-0.61858>,<-0.08651,23.6032,-0.62002>,<-0.08465,23.60242,-0.62027>,
            
    /*4*/ <-0.03984,23.80759,-0.71122>

    /* stem 0.36.6*/ 
    /*0*/ <-0.28074,23.38422,-0.46723>,
    /*1*/ <-0.28351,23.38424,-0.46551>,<-0.28085,23.38406,-0.47048>,<-0.27787,23.38436,-0.4657>,
            
    /*2*/ <-0.28725,23.5993,-0.47638>,<-0.28547,23.59918,-0.4797>,<-0.28349,23.59937,-0.47651>,
            
    /*3*/ <-0.27328,23.81337,-0.49752>,<-0.27239,23.81315,-0.49916>,<-0.2714,23.81325,-0.49756>,
            
    /*4*/ <-0.31052,24.01864,-0.55043>

    /* stem 0.36.7*/ 
    /*0*/ <-0.30347,23.48652,-0.50505>,
    /*1*/ <-0.30552,23.48533,-0.50702>,<-0.30104,23.48809,-0.50612>,<-0.30384,23.48613,-0.50202>,
            
    /*2*/ <-0.4143,23.66053,-0.49737>,<-0.41131,23.66237,-0.49677>,<-0.41318,23.66106,-0.49404>,
            
    /*3*/ <-0.47118,23.85695,-0.52695>,<-0.46952,23.85749,-0.52661>,<-0.47069,23.85735,-0.52528>,
            
    /*4*/ <-0.50044,24.06112,-0.53907>

    /* stem 0.36.8*/ 
    /*0*/ <-0.34108,23.65582,-0.56765>,
    /*1*/ <-0.33954,23.65531,-0.56994>,<-0.34061,23.65812,-0.56613>,<-0.34309,23.65402,-0.56689>,
            
    /*2*/ <-0.46688,23.75195,-0.67574>,<-0.46759,23.75382,-0.6732>,<-0.46924,23.75109,-0.67371>,
            
    /*3*/ <-0.55264,23.87128,-0.79834>,<-0.55305,23.87225,-0.79712>,<-0.55405,23.87107,-0.79757>,
            
    /*4*/ <-0.63389,24.01021,-0.90262>

    /* stem 0.36.9*/ 
    /*0*/ <-0.36897,23.80555,-0.61407>,
    /*1*/ <-0.36659,23.80611,-0.61331>,<-0.37098,23.80641,-0.61274>,<-0.36934,23.80412,-0.61617>,
            
    /*2*/ <-0.37031,23.95416,-0.71374>,<-0.37323,23.95435,-0.71336>,<-0.37214,23.95283,-0.71564>,
            
    /*3*/ <-0.3881,24.12223,-0.77237>,<-0.38955,24.12218,-0.7721>,<-0.38903,24.12178,-0.77343>,
            
    /*4*/ <-0.41009,24.29882,-0.79067>

    /* stem 0.36.10*/ 
    /*0*/ <-0.40099,24.01318,-0.66735>,
    /*1*/ <-0.40126,24.0137,-0.66519>,<-0.40271,24.01339,-0.66878>,<-0.39899,24.01247,-0.66809>,
            
    /*2*/ <-0.35774,24.16612,-0.69662>,<-0.35871,24.16591,-0.69902>,<-0.35623,24.1653,-0.69856>,
            
    /*3*/ <-0.33636,24.32281,-0.72974>,<-0.33686,24.32263,-0.73093>,<-0.33558,24.3225,-0.73073>,
            
    /*4*/ <-0.33183,24.48015,-0.76635>

    /* stem 0.36.11*/ 
    /*0*/ <-0.43106,24.20823,-0.71741>,
    /*1*/ <-0.43298,24.208,-0.71714>,<-0.43038,24.20886,-0.71912>,<-0.42982,24.20782,-0.71595>,
            
    /*2*/ <-0.44214,24.34532,-0.67052>,<-0.4404,24.3459,-0.67185>,<-0.44003,24.34521,-0.66973>,
            
    /*3*/ <-0.45156,24.48759,-0.64234>,<-0.45069,24.48779,-0.64302>,<-0.45051,24.48758,-0.64193>,
            
    /*4*/ <-0.47274,24.62733,-0.60883>

    /* stem 0.36.12*/ 
    /*0*/ <-0.45544,24.36636,-0.75799>,
    /*1*/ <-0.45569,24.36614,-0.75869>,<-0.45481,24.36681,-0.75792>,<-0.45583,24.36613,-0.75735>,
            
    /*2*/ <-0.53137,24.47422,-0.76521>,<-0.53078,24.47467,-0.76469>,<-0.53146,24.47422,-0.76431>,
            
    /*3*/ <-0.59377,24.59058,-0.7703>,<-0.59346,24.59076,-0.77004>,<-0.59382,24.59058,-0.76985>,
            
    /*4*/ <-0.63472,24.71592,-0.77852>

    /* stem 0.37*/ 
    /*0*/ <0,22.94898,0>,
    /*1*/ <0.01032,22.94898,0.01069>,<-0.00561,22.95605,0.0118>,<-0.01379,22.95335,-0.00339>,
            <-0.00291,22.94462,-0.0139>,<0.01199,22.94192,-0.0052>,
    /*2*/ <0.25575,23.54823,-0.23321>,<0.24513,23.55294,-0.23246>,<0.23968,23.55114,-0.2426>,
            <0.24693,23.54532,-0.2496>,<0.25687,23.54352,-0.2438>,
    /*3*/ <0.44946,24.18359,-0.42715>,<0.44397,24.18545,-0.42661>,<0.44131,24.18474,-0.43174>,
            <0.44516,24.18243,-0.43546>,<0.45019,24.18172,-0.43262>,
    /*4*/ <0.58878,24.84647,-0.56857>

    /* stem 0.37.0*/ 
    /*0*/ <0.04419,23.05538,-0.04267>,
    /*1*/ <0.04225,23.05748,-0.03945>,<0.04308,23.0562,-0.04675>,<0.04724,23.05246,-0.04181>,
            
    /*2*/ <0.22887,23.24788,-0.05292>,<0.22943,23.24703,-0.05779>,<0.2322,23.24454,-0.0545>,
            
    /*3*/ <0.38822,23.46149,-0.06277>,<0.38855,23.46114,-0.06521>,<0.39009,23.46007,-0.06357>,
            
    /*4*/ <0.47963,23.70837,-0.10624>

    /* stem 0.37.1*/ 
    /*0*/ <0.08916,23.16367,-0.0861>,
    /*1*/ <0.08548,23.16457,-0.08767>,<0.0925,23.16383,-0.08848>,<0.0895,23.16261,-0.08216>,
            
    /*2*/ <0.11991,23.41103,-0.0237>,<0.12459,23.41054,-0.02424>,<0.12259,23.40973,-0.02002>,
            
    /*3*/ <0.13874,23.66278,0.02294>,<0.14109,23.66266,0.02269>,<0.14011,23.66234,0.02482>,
            
    /*4*/ <0.19126,23.91383,0.00703>

    /* stem 0.37.2*/ 
    /*0*/ <0.15636,23.32547,-0.15099>,
    /*1*/ <0.15654,23.32399,-0.15448>,<0.15948,23.32689,-0.14938>,<0.15306,23.32551,-0.14912>,
            
    /*2*/ <0.10604,23.5416,-0.24757>,<0.10801,23.54353,-0.24417>,<0.10373,23.54261,-0.244>,
            
    /*3*/ <0.09635,23.76838,-0.33179>,<0.09735,23.7691,-0.32999>,<0.09517,23.76898,-0.33005>,
            
    /*4*/ <0.10419,23.99823,-0.40726>

    /* stem 0.37.3*/ 
    /*0*/ <0.21942,23.4773,-0.21189>,
    /*1*/ <0.22264,23.47592,-0.212>,<0.21888,23.48037,-0.21028>,<0.21673,23.47561,-0.21339>,
            
    /*2*/ <0.26199,23.58612,-0.40765>,<0.25948,23.58909,-0.40651>,<0.25805,23.58591,-0.40858>,
            
    /*3*/ <0.28237,23.7503,-0.5651>,<0.28103,23.75144,-0.5641>,<0.28039,23.75015,-0.56552>,
            
    /*4*/ <0.33543,23.92712,-0.69866>

    /* stem 0.37.4*/ 
    /*0*/ <0.26722,23.60736,-0.25805>,
    /*1*/ <0.26837,23.6079,-0.25503>,<0.26466,23.60907,-0.25916>,<0.26864,23.6051,-0.25996>,
            
    /*2*/ <0.40229,23.75804,-0.33441>,<0.39981,23.75881,-0.33717>,<0.40246,23.75616,-0.3377>,
            
    /*3*/ <0.50594,23.93416,-0.40514>,<0.50461,23.93443,-0.40646>,<0.50613,23.93338,-0.40685>,
            
    /*4*/ <0.55662,24.12967,-0.48279>

    /* stem 0.37.5*/ 
    /*0*/ <0.31061,23.74718,-0.29995>,
    /*1*/ <0.3082,23.74835,-0.29851>,<0.31082,23.7474,-0.30297>,<0.31279,23.74578,-0.29837>,
            
    /*2*/ <0.4081,23.92521,-0.27861>,<0.40985,23.92458,-0.28158>,<0.41116,23.92349,-0.27851>,
            
    /*3*/ <0.47224,24.11857,-0.28658>,<0.47309,24.11824,-0.28807>,<0.47391,24.11803,-0.28653>,
            
    /*4*/ <0.54212,24.3016,-0.34432>

    /* stem 0.37.6*/ 
    /*0*/ <0.37158,23.94369,-0.35883>,
    /*1*/ <0.36967,23.9437,-0.36075>,<0.37419,23.94398,-0.35951>,<0.37089,23.94337,-0.35623>,
            
    /*2*/ <0.3539,24.12906,-0.34195>,<0.35692,24.12924,-0.34112>,<0.35472,24.12883,-0.33893>,
            
    /*3*/ <0.35408,24.31601,-0.33956>,<0.35559,24.31601,-0.33915>,<0.35448,24.316,-0.33805>,
            
    /*4*/ <0.36903,24.50241,-0.33671>

    /* stem 0.37.7*/ 
    /*0*/ <0.41179,24.07327,-0.39766>,
    /*1*/ <0.41297,24.07231,-0.39964>,<0.41309,24.07443,-0.39587>,<0.4093,24.07307,-0.39747>,
            
    /*2*/ <0.39369,24.22511,-0.48415>,<0.39377,24.22653,-0.48164>,<0.39124,24.22562,-0.4827>,
            
    /*3*/ <0.39134,24.38536,-0.55623>,<0.39139,24.38596,-0.55492>,<0.39011,24.38566,-0.55553>,
            
    /*4*/ <0.40593,24.55025,-0.61515>

    /* stem 0.37.8*/ 
    /*0*/ <0.47247,24.30643,-0.45626>,
    /*1*/ <0.47447,24.30615,-0.45554>,<0.47123,24.30795,-0.45542>,<0.47172,24.30518,-0.45783>,
            
    /*2*/ <0.52643,24.40796,-0.56142>,<0.52427,24.40916,-0.56134>,<0.5246,24.40731,-0.56295>,
            
    /*3*/ <0.58114,24.53048,-0.64046>,<0.58004,24.53103,-0.64038>,<0.58029,24.5303,-0.64134>,
            
    /*4*/ <0.62531,24.66934,-0.69568>

    /* stem 0.37.9*/ 
    /*0*/ <0.49842,24.42689,-0.48132>,
    /*1*/ <0.49826,24.42732,-0.47941>,<0.49733,24.42785,-0.48263>,<0.49966,24.42549,-0.4819>,
            
    /*2*/ <0.60382,24.52679,-0.49372>,<0.6032,24.52715,-0.49587>,<0.60476,24.52557,-0.49539>,
            
    /*3*/ <0.68854,24.64463,-0.50645>,<0.6882,24.64476,-0.50752>,<0.68911,24.64413,-0.50729>,
            
    /*4*/ <0.76382,24.76701,-0.53118>

    /* stem 0.37.10*/ 
    /*0*/ <0.54266,24.63231,-0.52404>,
    /*1*/ <0.54111,24.63268,-0.52388>,<0.54337,24.63244,-0.52546>,<0.54349,24.63182,-0.52277>,
            
    /*2*/ <0.57313,24.75439,-0.49747>,<0.57464,24.75423,-0.49852>,<0.57473,24.75382,-0.49672>,
            
    /*3*/ <0.6032,24.87904,-0.50729>,<0.60392,24.87883,-0.50783>,<0.60403,24.87888,-0.50691>,
            
    /*4*/ <0.63204,25.00205,-0.5313>

    /* stem 0.37.11*/ 
    /*0*/ <0.56399,24.73136,-0.54463>,
    /*1*/ <0.56368,24.73126,-0.54543>,<0.56482,24.73154,-0.54451>,<0.56346,24.73127,-0.54396>,
            
    /*2*/ <0.53807,24.84873,-0.55011>,<0.53882,24.84892,-0.5495>,<0.53792,24.84874,-0.54913>,
            
    /*3*/ <0.51359,24.96258,-0.57995>,<0.51396,24.96274,-0.57966>,<0.5135,24.96269,-0.57947>,
            
    /*4*/ <0.50273,25.07769,-0.61327>

    /* stem 0.38*/ 
    /*0*/ <0,23.56193,0>,
    /*1*/ <-0.00578,23.56193,0.0089>,<-0.00912,23.56698,-0.00201>,<0.00015,23.56505,-0.01014>,
            <0.0092,23.55882,-0.00426>,<0.00554,23.55689,0.00751>,
    /*2*/ <0.25151,24.08932,0.17177>,<0.24929,24.09268,0.16449>,<0.25546,24.09139,0.15907>,
            <0.2615,24.08724,0.163>,<0.25906,24.08595,0.17084>,
    /*3*/ <0.45572,24.64848,0.30017>,<0.45446,24.64981,0.29644>,<0.45761,24.6493,0.29376>,
            <0.46081,24.64766,0.29584>,<0.45964,24.64715,0.2998>,
    /*4*/ <0.60413,25.23187,0.39232>

    /* stem 0.38.0*/ 
    /*0*/ <0.0445,23.65384,0.0289>,
    /*1*/ <0.04194,23.65534,0.02806>,<0.04719,23.65451,0.02755>,<0.04437,23.65166,0.03108>,
            
    /*2*/ <0.08452,23.81746,0.19291>,<0.08802,23.81691,0.19257>,<0.08614,23.81501,0.19492>,
            
    /*3*/ <0.1385,23.99588,0.33611>,<0.14023,23.99555,0.33588>,<0.13933,23.99476,0.3372>,
            
    /*4*/ <0.17835,24.21039,0.42318>

    /* stem 0.38.1*/ 
    /*0*/ <0.11407,23.79751,0.07408>,
    /*1*/ <0.11456,23.79813,0.07133>,<0.11625,23.79696,0.07583>,<0.11139,23.79743,0.07507>,
            
    /*2*/ <0.12755,24.01329,0.12374>,<0.12868,24.01251,0.12673>,<0.12544,24.01283,0.12623>,
            
    /*3*/ <0.1794,24.2257,0.16005>,<0.17997,24.22531,0.16154>,<0.17839,24.22573,0.16136>,
            
    /*4*/ <0.26956,24.4193,0.22036>

    /* stem 0.38.2*/ 
    /*0*/ <0.15099,23.87376,0.09805>,
    /*1*/ <0.15347,23.87269,0.09761>,<0.15023,23.87445,0.10059>,<0.14926,23.87413,0.09596>,
            
    /*2*/ <0.23176,24.07039,0.06732>,<0.2296,24.07157,0.06931>,<0.22896,24.07135,0.06622>,
            
    /*3*/ <0.30101,24.27195,0.03995>,<0.2999,24.27247,0.04095>,<0.29958,24.27237,0.0394>,
            
    /*4*/ <0.37643,24.47304,0.03854>

    /* stem 0.38.3*/ 
    /*0*/ <0.23195,24.04096,0.15063>,
    /*1*/ <0.23254,24.03998,0.15283>,<0.23022,24.04274,0.15048>,<0.23308,24.04016,0.14857>,
            
    /*2*/ <0.3737,24.17883,0.17583>,<0.37216,24.18067,0.17426>,<0.37407,24.17895,0.17299>,
            
    /*3*/ <0.48797,24.34248,0.17902>,<0.48701,24.34317,0.17821>,<0.48808,24.34244,0.17759>,
            
    /*4*/ <0.58192,24.51772,0.1932>

    /* stem 0.38.4*/ 
    /*0*/ <0.29922,24.21056,0.19432>,
    /*1*/ <0.29738,24.21093,0.19555>,<0.29956,24.21172,0.19243>,<0.30072,24.20902,0.19497>,
            
    /*2*/ <0.3885,24.33967,0.29091>,<0.38995,24.3402,0.28883>,<0.39072,24.3384,0.29053>,
            
    /*3*/ <0.44983,24.5052,0.34371>,<0.45048,24.50532,0.3426>,<0.45106,24.50478,0.34363>,
            
    /*4*/ <0.47373,24.67982,0.39715>

    /* stem 0.38.5*/ 
    /*0*/ <0.3491,24.34842,0.22671>,
    /*1*/ <0.34778,24.34922,0.22534>,<0.35112,24.34851,0.22636>,<0.34839,24.34754,0.22842>,
            
    /*2*/ <0.35567,24.50064,0.30718>,<0.35789,24.50016,0.30785>,<0.35607,24.49951,0.30923>,
            
    /*3*/ <0.37917,24.65998,0.36819>,<0.38028,24.6597,0.36851>,<0.37939,24.65954,0.36927>,
            
    /*4*/ <0.42712,24.82457,0.38485>

    /* stem 0.38.6*/ 
    /*0*/ <0.40868,24.51312,0.2654>,
    /*1*/ <0.40966,24.51313,0.26384>,<0.40954,24.5132,0.26702>,<0.40685,24.51302,0.26533>,
            
    /*2*/ <0.40115,24.67081,0.26052>,<0.40107,24.67086,0.26264>,<0.39928,24.67074,0.26152>,
            
    /*3*/ <0.42128,24.82704,0.27193>,<0.42124,24.82697,0.27298>,<0.42035,24.82712,0.27243>,
            
    /*4*/ <0.46329,24.97386,0.31244>

    /* stem 0.38.7*/ 
    /*0*/ <0.47563,24.7201,0.30888>,
    /*1*/ <0.47706,24.71966,0.30936>,<0.47464,24.72078,0.30989>,<0.47519,24.71985,0.30739>,
            
    /*2*/ <0.52697,24.84557,0.27321>,<0.52535,24.84631,0.27357>,<0.52572,24.84569,0.2719>,
            
    /*3*/ <0.56956,24.97907,0.27029>,<0.56872,24.97934,0.27048>,<0.56898,24.97924,0.26961>,
            
    /*4*/ <0.60574,25.11414,0.28022>

    /* stem 0.38.8*/ 
    /*0*/ <0.50829,24.85016,0.33009>,
    /*1*/ <0.50812,24.84997,0.33148>,<0.50743,24.85104,0.32938>,<0.50931,24.84946,0.3294>,
            
    /*2*/ <0.58985,24.94763,0.35393>,<0.58939,24.94834,0.35253>,<0.59064,24.94729,0.35254>,
            
    /*3*/ <0.65753,25.05794,0.35707>,<0.65721,25.05816,0.35635>,<0.6579,25.05773,0.35638>,
            
    /*4*/ <0.7239,25.16728,0.37565>

    /* stem 0.38.9*/ 
    /*0*/ <0.5499,25.0159,0.35711>,
    /*1*/ <0.54872,25.01617,0.35728>,<0.55053,25.01646,0.35623>,<0.55045,25.01507,0.35782>,
            
    /*2*/ <0.5788,25.09954,0.43129>,<0.58001,25.09973,0.43059>,<0.57995,25.09881,0.43166>,
            
    /*3*/ <0.61245,25.19138,0.4927>,<0.61303,25.19143,0.49232>,<0.61303,25.19104,0.4929>,
            
    /*4*/ <0.64118,25.29227,0.54093>

    /* stem 0.38.10*/ 
    /*0*/ <0.58674,25.16263,0.38104>,
    /*1*/ <0.58661,25.16273,0.38065>,<0.58713,25.16274,0.38116>,<0.58649,25.16242,0.3813>,
            
    /*2*/ <0.54961,25.25248,0.41571>,<0.54996,25.25249,0.41606>,<0.54953,25.25228,0.41615>,
            
    /*3*/ <0.51929,25.34251,0.45611>,<0.51947,25.3425,0.45627>,<0.51925,25.3424,0.45632>,
            
    /*4*/ <0.5179,25.43794,0.49545>

    /* stem 0.39*/ 
    /*0*/ <0,24.0391,0>,
    /*1*/ <-0.00459,24.0391,-0.00167>,<-0.00004,24.04143,-0.0043>,<0.00456,24.04054,-0.00098>,
            <0.00286,24.03767,0.00369>,<-0.00279,24.03678,0.00326>,
    /*2*/ <-0.09613,24.51041,0.25458>,<-0.09309,24.51195,0.25283>,<-0.09002,24.51136,0.25504>,
            <-0.09116,24.50945,0.25815>,<-0.09493,24.50886,0.25787>,
    /*3*/ <-0.16832,25.01011,0.45769>,<-0.16678,25.01072,0.45674>,<-0.16525,25.01049,0.45787>,
            <-0.16585,25.00973,0.45952>,<-0.16775,25.0095,0.45941>,
    /*4*/ <-0.22017,25.53146,0.60492>

    /* stem 0.39.0*/ 
    /*0*/ <-0.01572,24.1187,0.04318>,
    /*1*/ <-0.01561,24.11939,0.04195>,<-0.01489,24.11906,0.04428>,<-0.01666,24.11765,0.04333>,
            
    /*2*/ <-0.1606,24.25726,0.10684>,<-0.16011,24.25704,0.10839>,<-0.1613,24.2561,0.10776>,
            
    /*3*/ <-0.2784,24.42243,0.16194>,<-0.27817,24.42234,0.16272>,<-0.27884,24.42195,0.16244>,
            
    /*4*/ <-0.39323,24.59071,0.2142>

    /* stem 0.39.1*/ 
    /*0*/ <-0.03915,24.23738,0.10757>,
    /*1*/ <-0.03786,24.23767,0.10751>,<-0.03979,24.23745,0.10873>,<-0.03981,24.23702,0.10648>,
            
    /*2*/ <-0.08306,24.42845,0.07133>,<-0.08434,24.4283,0.07214>,<-0.08436,24.42802,0.07064>,
            
    /*3*/ <-0.10926,24.62591,0.07748>,<-0.10989,24.62582,0.07789>,<-0.10993,24.62584,0.07713>,
            
    /*4*/ <-0.15247,24.81921,0.10059>

    /* stem 0.39.2*/ 
    /*0*/ <-0.0555,24.32014,0.15247>,
    /*1*/ <-0.05504,24.31966,0.15354>,<-0.05668,24.32056,0.15243>,<-0.05476,24.32021,0.15145>,
            
    /*2*/ <0.00422,24.49379,0.20762>,<0.00313,24.49439,0.20687>,<0.00441,24.49416,0.20622>,
            
    /*3*/ <0.01979,24.66994,0.28169>,<0.01922,24.67016,0.28129>,<0.0199,24.67021,0.28102>,
            
    /*4*/ <0.02882,24.84366,0.36227>

    /* stem 0.39.3*/ 
    /*0*/ <-0.08448,24.46692,0.2321>,
    /*1*/ <-0.08541,24.46647,0.2326>,<-0.08458,24.46782,0.2314>,<-0.08345,24.46647,0.23231>,
            
    /*2*/ <-0.06514,24.5769,0.37093>,<-0.06459,24.5778,0.37014>,<-0.06384,24.57691,0.37074>,
            
    /*3*/ <-0.04589,24.71333,0.48403>,<-0.04563,24.71369,0.48355>,<-0.04524,24.71332,0.48393>,
            
    /*4*/ <-0.05055,24.85555,0.59119>

    /* stem 0.39.4*/ 
    /*0*/ <-0.10635,24.60046,0.2922>,
    /*1*/ <-0.1071,24.60064,0.29149>,<-0.10545,24.60099,0.29214>,<-0.1065,24.59976,0.29296>,
            
    /*2*/ <-0.17027,24.71973,0.38887>,<-0.16916,24.71997,0.38931>,<-0.16987,24.71915,0.38985>,
            
    /*3*/ <-0.20735,24.84941,0.48628>,<-0.20677,24.84946,0.48644>,<-0.20714,24.84911,0.48676>,
            
    /*4*/ <-0.24119,25.00082,0.54602>

    /* stem 0.39.5*/ 
    /*0*/ <-0.12711,24.74113,0.34922>,
    /*1*/ <-0.12663,24.7415,0.34849>,<-0.12688,24.74138,0.3501>,<-0.12781,24.74052,0.34907>,
            
    /*2*/ <-0.22709,24.8581,0.34203>,<-0.22725,24.85802,0.3431>,<-0.22787,24.85745,0.34241>,
            
    /*3*/ <-0.31131,24.98444,0.31671>,<-0.31144,24.98447,0.31724>,<-0.31176,24.98419,0.3169>,
            
    /*4*/ <-0.39872,25.10925,0.294>

    /* stem 0.39.6*/ 
    /*0*/ <-0.15831,24.95261,0.43494>,
    /*1*/ <-0.15755,24.95262,0.4352>,<-0.1589,24.9528,0.43544>,<-0.15847,24.95242,0.43418>,
            
    /*2*/ <-0.14631,25.08287,0.39915>,<-0.14721,25.083,0.3993>,<-0.14692,25.08274,0.39846>,
            
    /*3*/ <-0.15068,25.21841,0.39634>,<-0.15113,25.2184,0.39643>,<-0.15098,25.21839,0.39599>,
            
    /*4*/ <-0.16428,25.35259,0.41069>

    /* stem 0.39.7*/ 
    /*0*/ <-0.17502,25.09049,0.48086>,
    /*1*/ <-0.17508,25.09029,0.48154>,<-0.1755,25.09093,0.48057>,<-0.17447,25.09025,0.48047>,
            
    /*2*/ <-0.10686,25.18776,0.51612>,<-0.10714,25.18819,0.51548>,<-0.10646,25.18773,0.51541>,
            
    /*3*/ <-0.07499,25.30222,0.55128>,<-0.07516,25.30237,0.55093>,<-0.07476,25.30226,0.55094>,
            
    /*4*/ <-0.05309,25.41912,0.58601>

    /* stem 0.39.8*/ 
    /*0*/ <-0.18484,25.18641,0.50784>,
    /*1*/ <-0.18549,25.18632,0.50791>,<-0.18461,25.18686,0.50743>,<-0.18442,25.18604,0.50819>,
            
    /*2*/ <-0.18684,25.26566,0.59237>,<-0.18626,25.26602,0.59205>,<-0.18613,25.26548,0.59256>,
            
    /*3*/ <-0.19602,25.35149,0.66967>,<-0.19573,25.35167,0.6695>,<-0.19567,25.35142,0.66978>,
            
    /*4*/ <-0.21801,25.44428,0.73548>

    /* stem 0.39.9*/ 
    /*0*/ <-0.20227,25.35665,0.55574>,
    /*1*/ <-0.20246,25.35677,0.55524>,<-0.20182,25.35689,0.55592>,<-0.20253,25.35629,0.55605>,
            
    /*2*/ <-0.25797,25.43201,0.59517>,<-0.25754,25.43209,0.59562>,<-0.25802,25.43169,0.59571>,
            
    /*3*/ <-0.29724,25.5208,0.62528>,<-0.29702,25.52083,0.6255>,<-0.29729,25.52068,0.62557>,
            
    /*4*/ <-0.31935,25.61976,0.63235>

    /* stem 0.39.10*/ 
    /*0*/ <-0.21556,25.48645,0.59225>,
    /*1*/ <-0.21545,25.48648,0.59218>,<-0.21557,25.48647,0.59239>,<-0.21567,25.48639,0.59219>,
            
    /*2*/ <-0.24882,25.56928,0.57544>,<-0.2489,25.56928,0.57558>,<-0.24897,25.56922,0.57544>,
            
    /*3*/ <-0.27581,25.65584,0.58099>,<-0.27585,25.65583,0.58106>,<-0.27589,25.65582,0.581>,
            
    /*4*/ <-0.30035,25.73852,0.60952>

    }
    normal_vectors { 10851
    /* stem 0*/ 
    /*0*/<-0,-1,-0>,
    /*1*/<0.93308,0.35494,-0.05813>,<0.86193,0.33604,0.37967>,<0.84708,0.32532,0.42028>,
            <0.85654,0.33091,0.39602>,<0.62722,0.35494,0.69327>,<0.24057,0.33604,0.91061>,
            <0.19956,0.32532,0.92431>,<0.22442,0.33091,0.91659>,<-0.15096,0.35494,0.92262>,
            <-0.56195,0.33604,0.75584>,<-0.59823,0.32532,0.73232>,<-0.57669,0.33091,0.74694>,
            <-0.81546,0.35494,0.45722>,<-0.94131,0.33604,0.03191>,<-0.94554,0.32532,-0.01113>,
            <-0.94355,0.33091,0.01483>,<-0.8659,0.35494,-0.35247>,<-0.61184,0.33604,-0.71605>,
            <-0.58084,0.32532,-0.74619>,<-0.59989,0.33091,-0.72844>,<-0.2643,0.35494,-0.89675>,
            <0.17836,0.33604,-0.92481>,<0.22125,0.32532,-0.91936>,<0.1955,0.33091,-0.92319>,
            <0.53632,0.35494,-0.76576>,<0.83424,0.33604,-0.43716>,<0.85673,0.32532,-0.40023>,
            <0.84367,0.33091,-0.42275>,
    /*2*/<0.9371,0.34414,-0.05836>,<0.86527,0.32568,0.38111>,<0.85014,0.31521,0.42179>,
            <0.85974,0.32067,0.39751>,<0.6299,0.34414,0.69627>,<0.24153,0.32568,0.91411>,
            <0.20028,0.31521,0.92765>,<0.22525,0.32067,0.92002>,<-0.15163,0.34414,0.92659>,
            <-0.56409,0.32568,0.75877>,<-0.60039,0.31521,0.73496>,<-0.57886,0.32067,0.74973>,
            <-0.81898,0.34414,0.45917>,<-0.94494,0.32568,0.03206>,<-0.94896,0.31521,-0.01116>,
            <-0.94707,0.32067,0.01488>,<-0.86962,0.34414,-0.35402>,<-0.61422,0.32568,-0.71879>,
            <-0.58294,0.31521,-0.74888>,<-0.60212,0.32067,-0.73117>,<-0.26542,0.34414,-0.90062>,
            <0.17901,0.32568,-0.92838>,<0.22205,0.31521,-0.92268>,<0.19624,0.32067,-0.92664>,
            <0.53865,0.34414,-0.76904>,<0.83745,0.32568,-0.43888>,<0.85982,0.31521,-0.40168>,
            <0.84683,0.32067,-0.42433>,
    /*3*/<0.94619,0.3182,-0.05886>,<0.8728,0.30083,0.38434>,<0.85704,0.29099,0.42521>,
            <0.86696,0.29612,0.40087>,<0.63596,0.3182,0.70307>,<0.24369,0.30083,0.92202>,
            <0.20191,0.29099,0.93518>,<0.22712,0.29612,0.92775>,<-0.15316,0.3182,0.93557>,
            <-0.56892,0.30083,0.7654>,<-0.60526,0.29099,0.74093>,<-0.58374,0.29612,0.75602>,
            <-0.82695,0.3182,0.46357>,<-0.95313,0.30083,0.03242>,<-0.95666,0.29099,-0.01125>,
            <-0.95503,0.29612,0.01499>,<-0.87803,0.3182,-0.35751>,<-0.61961,0.30083,-0.72497>,
            <-0.58767,0.29099,-0.75496>,<-0.60717,0.29612,-0.73733>,<-0.26793,0.3182,-0.90937>,
            <0.18049,0.30083,-0.93644>,<0.22384,0.29099,-0.93017>,<0.19791,0.29612,-0.93442>,
            <0.54392,0.3182,-0.77646>,<0.84467,0.30083,-0.44275>,<0.8668,0.29099,-0.40494>,
            <0.85395,0.29612,-0.42787>,
    /*4*/<0.95917,0.27649,-0.05958>,<0.88351,0.26103,0.38894>,<0.86683,0.25229,0.43006>,
            <0.8772,0.25684,0.40564>,<0.64461,0.27649,0.71276>,<0.24678,0.26103,0.93326>,
            <0.20422,0.25229,0.94585>,<0.22978,0.25684,0.93874>,<-0.15535,0.27649,0.94838>,
            <-0.57579,0.26103,0.77481>,<-0.61217,0.25229,0.7494>,<-0.59067,0.25684,0.76495>,
            <-0.83833,0.27649,0.46985>,<-0.96477,0.26103,0.03292>,<-0.96758,0.25229,-0.01137>,
            <-0.96634,0.25684,0.01513>,<-0.89003,0.27649,-0.36249>,<-0.62726,0.26103,-0.73376>,
            <-0.59439,0.25229,-0.76358>,<-0.61433,0.25684,-0.74608>,<-0.27152,0.27649,-0.92186>,
            <0.18259,0.26103,-0.94791>,<0.22639,0.25229,-0.94079>,<0.20028,0.25684,-0.94547>,
            <0.55145,0.27649,-0.78705>,<0.85494,0.26103,-0.44826>,<0.8767,0.25229,-0.40958>,
            <0.86407,0.25684,-0.43291>,
    /*5*/<0.97589,0.20971,-0.0605>,<0.89725,0.19761,0.39483>,<0.87936,0.19081,0.43626>,
            <0.89033,0.19434,0.41175>,<0.65576,0.20971,0.72526>,<0.25074,0.19761,0.94767>,
            <0.20719,0.19081,0.95951>,<0.23319,0.19434,0.95281>,<-0.15817,0.20971,0.96489>,
            <-0.58459,0.19761,0.7869>,<-0.621,0.19081,0.76023>,<-0.59955,0.19434,0.77638>,
            <-0.853,0.20971,0.47793>,<-0.97971,0.19761,0.03357>,<-0.98156,0.19081,-0.01152>,
            <-0.98081,0.19434,0.01532>,<-0.9055,0.20971,-0.36891>,<-0.63709,0.19761,-0.74503>,
            <-0.60299,0.19081,-0.7746>,<-0.62351,0.19434,-0.75728>,<-0.27614,0.20971,-0.93796>,
            <0.18527,0.19761,-0.96261>,<0.22965,0.19081,-0.95439>,<0.20331,0.19434,-0.95963>,
            <0.56116,0.20971,-0.8007>,<0.86812,0.19761,-0.45533>,<0.88935,0.19081,-0.4155>,
            <0.87703,0.19434,-0.43936>,
    /*6*/<0.99025,0.12513,-0.06129>,<0.90899,0.11772,0.39986>,<0.89002,0.11356,0.44154>,
            <0.90152,0.11572,0.41697>,<0.66533,0.12513,0.73599>,<0.25412,0.11772,0.95998>,
            <0.20971,0.11356,0.97115>,<0.23609,0.11572,0.96482>,<-0.1606,0.12513,0.97906>,
            <-0.5921,0.11772,0.79722>,<-0.62852,0.11356,0.76946>,<-0.60712,0.11572,0.78614>,
            <-0.86559,0.12513,0.48487>,<-0.99246,0.11772,0.03414>,<-0.99346,0.11356,-0.01165>,
            <-0.99316,0.11572,0.01548>,<-0.91877,0.12513,-0.37443>,<-0.64548,0.11772,-0.75465>,
            <-0.6103,0.11356,-0.78398>,<-0.63133,0.11572,-0.76683>,<-0.2801,0.12513,-0.95178>,
            <0.18756,0.11772,-0.97517>,<0.23242,0.11356,-0.96596>,<0.20591,0.11572,-0.97171>,
            <0.56949,0.12513,-0.81242>,<0.87936,0.11772,-0.46137>,<0.90013,0.11356,-0.42055>,
            <0.88809,0.11572,-0.44486>,
    /*7*/<0.99667,0.05345,-0.06163>,<0.91422,0.05025,0.40209>,<0.89477,0.04845,0.44389>,
            <0.90651,0.04939,0.41929>,<0.6696,0.05345,0.7408>,<0.25564,0.05025,0.96546>,
            <0.21083,0.04845,0.97632>,<0.23738,0.04939,0.97016>,<-0.16169,0.05345,0.98539>,
            <-0.59544,0.05025,0.80183>,<-0.63187,0.04845,0.77356>,<-0.6105,0.04939,0.79048>,
            <-0.87122,0.05345,0.48797>,<-0.99814,0.05025,0.0344>,<-0.99876,0.04845,-0.01171>,
            <-0.99866,0.04939,0.01555>,<-0.92471,0.05345,-0.37691>,<-0.64922,0.05025,-0.75894>,
            <-0.61356,0.04845,-0.78816>,<-0.63481,0.04939,-0.77109>,<-0.28187,0.05345,-0.95796>,
            <0.18857,0.05025,-0.98077>,<0.23366,0.04845,-0.97111>,<0.20706,0.04939,-0.97708>,
            <0.57322,0.05345,-0.81765>,<0.88437,0.05025,-0.46407>,<0.90493,0.04845,-0.4228>,
            <0.89301,0.04939,-0.44731>,
    /*8*/<0.99791,0.01937,-0.0617>,<0.91523,0.01821,0.40252>,<0.89568,0.01755,0.44435>,
            <0.90747,0.01789,0.41974>,<0.67042,0.01937,0.74173>,<0.25594,0.01821,0.96652>,
            <0.21105,0.01755,0.97732>,<0.23763,0.01789,0.97119>,<-0.1619,0.01937,0.98662>,
            <-0.59608,0.01821,0.80272>,<-0.63251,0.01755,0.77435>,<-0.61115,0.01789,0.79132>,
            <-0.87231,0.01937,0.48857>,<-0.99924,0.01821,0.03445>,<-0.99978,0.01755,-0.01172>,
            <-0.99972,0.01789,0.01556>,<-0.92585,0.01937,-0.37739>,<-0.64995,0.01821,-0.75976>,
            <-0.61419,0.01755,-0.78896>,<-0.63548,0.01789,-0.77191>,<-0.28221,0.01937,-0.95916>,
            <0.18877,0.01821,-0.98185>,<0.2339,0.01755,-0.9721>,<0.20729,0.01789,-0.97812>,
            <0.57395,0.01937,-0.81866>,<0.88534,0.01821,-0.46459>,<0.90585,0.01755,-0.42323>,
            <0.89396,0.01789,-0.44778>,
    /*9*/<0.99802,0.01258,-0.06171>,<0.91532,0.01183,0.40256>,<0.89576,0.0114,0.44438>,
            <0.90755,0.01162,0.41978>,<0.6705,0.01258,0.74181>,<0.25596,0.01183,0.96661>,
            <0.21107,0.0114,0.97741>,<0.23765,0.01162,0.97128>,<-0.16192,0.01258,0.98672>,
            <-0.59614,0.01183,0.80279>,<-0.63257,0.0114,0.77442>,<-0.6112,0.01162,0.79139>,
            <-0.87241,0.01258,0.48862>,<-0.99934,0.01183,0.03445>,<-0.99987,0.0114,-0.01172>,
            <-0.99981,0.01162,0.01556>,<-0.92595,0.01258,-0.37743>,<-0.65001,0.01183,-0.75983>,
            <-0.61424,0.0114,-0.78903>,<-0.63554,0.01162,-0.77198>,<-0.28224,0.01258,-0.95926>,
            <0.18878,0.01183,-0.98195>,<0.23392,0.0114,-0.97219>,<0.2073,0.01162,-0.97821>,
            <0.57401,0.01258,-0.81875>,<0.88542,0.01183,-0.46464>,<0.90593,0.0114,-0.42327>,
            <0.89405,0.01162,-0.44782>,
    /*10*/<0.99802,0.01258,-0.06171>,<0.91532,0.01183,0.40256>,<0.89576,0.0114,0.44438>,
            <0.90755,0.01162,0.41978>,<0.6705,0.01258,0.74181>,<0.25596,0.01183,0.96661>,
            <0.21107,0.0114,0.97741>,<0.23765,0.01162,0.97128>,<-0.16192,0.01258,0.98672>,
            <-0.59614,0.01183,0.80279>,<-0.63257,0.0114,0.77442>,<-0.6112,0.01162,0.79139>,
            <-0.87241,0.01258,0.48862>,<-0.99934,0.01183,0.03445>,<-0.99987,0.0114,-0.01172>,
            <-0.99981,0.01162,0.01556>,<-0.92595,0.01258,-0.37743>,<-0.65001,0.01183,-0.75983>,
            <-0.61424,0.0114,-0.78903>,<-0.63554,0.01162,-0.77198>,<-0.28224,0.01258,-0.95926>,
            <0.18878,0.01183,-0.98195>,<0.23392,0.0114,-0.97219>,<0.2073,0.01162,-0.97821>,
            <0.57401,0.01258,-0.81875>,<0.88542,0.01183,-0.46464>,<0.90593,0.0114,-0.42327>,
            <0.89405,0.01162,-0.44782>,
    /*11*/<0,1,0>

    /* stem 0.0*/ 
    /*0*/<-0.48719,-0.86603,0.11248>,
    /*1*/<0.23003,0.00905,0.97314>,<-0.72788,0.48455,0.48517>,<-0.67285,0.30293,-0.67491>,
            <0.31908,-0.28482,-0.90392>,<0.87709,-0.46645,0.11464>,
    /*2*/<0.22986,0.00917,0.97318>,<-0.75388,0.43602,0.49148>,<-0.68883,0.27288,-0.6716>,
            <0.33437,-0.25446,-0.90744>,<0.90214,-0.41747,0.10891>,
    /*3*/<0.22879,0.00969,0.97343>,<-0.79764,0.33494,0.50158>,<-0.71627,0.21064,-0.66527>,
            <0.35966,-0.19123,-0.91328>,<0.94372,-0.31548,0.09932>,
    /*4*/<0.27945,0.95799,-0.06452>

    /* stem 0.0.0*/ 
    /*0*/<-0.63582,-0.60995,-0.47295>,
    /*1*/<-0.76658,0.49196,0.41271>,<0.37428,0.30244,-0.87661>,<0.40729,-0.78003,0.47505>,
            
    /*2*/<-0.81338,0.43942,0.38121>,<0.36383,0.28926,-0.88541>,<0.46317,-0.71629,0.52192>,
            
    /*3*/<-0.8532,0.39004,0.34628>,<0.29808,0.18713,-0.93602>,<0.5766,-0.56293,0.59215>,
            
    /*4*/<0.46966,0.86109,0.19478>

    /* stem 0.0.1*/ 
    /*0*/<0.02805,-0.95784,-0.28593>,
    /*1*/<-0.5723,0.22667,-0.7881>,<0.99569,0.05876,-0.07182>,<-0.42405,-0.26296,0.86662>,
            
    /*2*/<-0.57234,0.21469,-0.79141>,<0.99635,0.03434,-0.07813>,<-0.42426,-0.22662,0.87673>,
            
    /*3*/<-0.56578,0.2332,-0.79089>,<0.98612,-0.12559,-0.1086>,<-0.4043,-0.0909,0.9101>,
            
    /*4*/<0.27795,0.95386,0.11359>

    /* stem 0.0.2*/ 
    /*0*/<-0.04604,-0.9027,0.4278>,
    /*1*/<0.51455,-0.38154,-0.76789>,<0.48492,0.36132,0.79643>,<-0.9984,0.04129,-0.03852>,
            
    /*2*/<0.51599,-0.37476,-0.77027>,<0.47747,0.29546,0.82748>,<-0.99282,0.1023,-0.06203>,
            
    /*3*/<0.51215,-0.40539,-0.7572>,<0.47666,0.26623,0.8378>,<-0.98308,0.16006,-0.08904>,
            
    /*4*/<0.17408,0.88947,-0.42255>

    /* stem 0.0.3*/ 
    /*0*/<-0.59535,-0.53971,0.59521>,
    /*1*/<0.80802,-0.38982,0.44175>,<-0.40264,0.84544,0.35088>,<-0.39157,-0.4431,-0.80643>,
            
    /*2*/<0.80978,-0.38737,0.44069>,<-0.46158,0.79163,0.40034>,<-0.3416,-0.38673,-0.85659>,
            
    /*3*/<0.82607,-0.36089,0.43286>,<-0.56662,0.66708,0.48368>,<-0.25243,-0.286,-0.92438>,
            
    /*4*/<0.49719,0.80391,-0.3264>

    /* stem 0.0.4*/ 
    /*0*/<-0.83914,-0.54375,-0.01375>,
    /*1*/<-0.14629,0.21548,0.96549>,<-0.36926,0.6019,-0.70807>,<0.5349,-0.80485,-0.2571>,
            
    /*2*/<-0.08958,0.26951,0.95882>,<-0.49505,0.51223,-0.70181>,<0.58915,-0.76164,-0.26984>,
            
    /*3*/<0.00211,0.34701,0.93786>,<-0.67946,0.33463,-0.65297>,<0.68488,-0.66497,-0.29791>,
            
    /*4*/<0.52872,0.78271,-0.32836>

    /* stem 0.0.5*/ 
    /*0*/<-0.40485,-0.73532,-0.54351>,
    /*1*/<-0.86904,0.49469,-0.00787>,<0.67702,0.16739,-0.71668>,<0.20131,-0.6452,0.73702>,
            
    /*2*/<-0.90714,0.41901,-0.03904>,<0.65415,0.09581,-0.75027>,<0.26954,-0.50107,0.82236>,
            
    /*3*/<-0.94551,0.31595,-0.07868>,<0.59844,0.0007,-0.80117>,<0.35486,-0.29648,0.88667>,
            
    /*4*/<0.27091,0.95048,0.15228>

    /* stem 0.0.6*/ 
    /*0*/<-0.12114,-0.99241,0.02098>,
    /*1*/<-0.23872,0.01626,-0.97095>,<0.95493,-0.10303,0.27837>,<-0.71346,0.10938,0.69211>,
            
    /*2*/<-0.23491,0.03221,-0.97148>,<0.94584,-0.16329,0.28058>,<-0.70495,0.15284,0.69259>,
            
    /*3*/<-0.21714,0.08462,-0.97247>,<0.91677,-0.28217,0.28268>,<-0.69032,0.21804,0.68987>,
            
    /*4*/<0.3523,0.93524,0.03489>

    /* stem 0.0.7*/ 
    /*0*/<-0.10278,-0.74197,0.66251>,
    /*1*/<0.7651,-0.47953,-0.42974>,<0.16988,0.64889,0.74167>,<-0.93265,-0.15255,-0.32694>,
            
    /*2*/<0.76689,-0.47181,-0.43506>,<0.16016,0.59867,0.78482>,<-0.92625,-0.10735,-0.36129>,
            
    /*3*/<0.77405,-0.44672,-0.44866>,<0.13523,0.48693,0.86291>,<-0.90626,-0.01949,-0.42226>,
            
    /*4*/<0.23336,0.86938,-0.43557>

    /* stem 0.0.8*/ 
    /*0*/<-0.78624,-0.39826,0.47246>,
    /*1*/<0.58941,-0.224,0.77616>,<-0.4619,0.88614,-0.03759>,<-0.1098,-0.65317,-0.74921>,
            
    /*2*/<0.61185,-0.20906,0.76285>,<-0.5169,0.85603,-0.00458>,<-0.08051,-0.63403,-0.76911>,
            
    /*3*/<0.60059,-0.23026,0.76568>,<-0.62723,0.77687,0.05538>,<0.04312,-0.53648,-0.84281>,
            
    /*4*/<0.68506,0.68275,-0.25406>

    /* stem 0.0.9*/ 
    /*0*/<-0.8292,-0.46822,-0.30529>,
    /*1*/<-0.49562,0.3865,0.7778>,<0.04388,0.50157,-0.86401>,<0.47029,-0.8776,0.09303>,
            
    /*2*/<-0.51616,0.37078,0.77208>,<-0.0273,0.4473,-0.89397>,<0.56995,-0.81249,0.12253>,
            
    /*3*/<-0.54203,0.34874,0.76458>,<-0.14988,0.35068,-0.92442>,<0.70998,-0.68569,0.16046>,
            
    /*4*/<0.62714,0.77066,0.11305>

    /* stem 0.0.10*/ 
    /*0*/<-0.20331,-0.93469,-0.29157>,
    /*1*/<-0.84838,0.32321,-0.41927>,<0.84744,-0.01086,-0.53078>,<0.00544,-0.29166,0.95651>,
            
    /*2*/<-0.85003,0.31638,-0.42112>,<0.83837,-0.05568,-0.54226>,<0.01847,-0.24061,0.97045>,
            
    /*3*/<-0.85374,0.30242,-0.42388>,<0.81525,-0.14416,-0.56088>,<0.04616,-0.13782,0.98938>,
            
    /*4*/<0.28496,0.95576,0.07299>

    /* stem 0.0.11*/ 
    /*0*/<0.28369,-0.93757,0.20118>,
    /*1*/<0.15631,-0.15422,-0.97559>,<0.73774,0.35435,0.57461>,<-0.90029,-0.1795,0.39655>,
            
    /*2*/<0.1654,-0.18818,-0.96811>,<0.73832,0.35268,0.57488>,<-0.91051,-0.14434,0.38748>,
            
    /*3*/<0.18078,-0.26902,-0.94602>,<0.74099,0.35489,0.57007>,<-0.92756,-0.06629,0.36775>,
            
    /*4*/<-0.16563,0.9208,-0.35311>

    /* stem 0.0.12*/ 
    /*0*/<-0.32737,-0.79756,0.50668>,
    /*1*/<0.92352,-0.383,-0.02052>,<-0.27596,0.59961,0.75121>,<-0.64043,-0.19924,-0.74173>,
            
    /*2*/<0.95109,-0.30489,-0.04967>,<-0.31943,0.47188,0.82177>,<-0.62911,-0.14523,-0.76363>,
            
    /*3*/<0.97812,-0.18953,-0.08584>,<-0.37843,0.27494,0.88386>,<-0.59708,-0.06458,-0.79958>,
            
    /*4*/<0.1464,0.9766,-0.15751>

    /* stem 0.0.13*/ 
    /*0*/<-0.81005,-0.5487,0.20673>,
    /*1*/<0.26187,-0.00987,0.96505>,<-0.57899,0.73476,-0.3534>,<0.33464,-0.71303,-0.61612>,
            
    /*2*/<0.2966,0.02484,0.95468>,<-0.67569,0.66054,-0.32731>,<0.38535,-0.66718,-0.63748>,
            
    /*3*/<0.3027,0.0133,0.95299>,<-0.77515,0.56072,-0.2911>,<0.48951,-0.56066,-0.66786>,
            
    /*4*/<0.58731,0.79846,-0.1324>

    /* stem 0.0.14*/ 
    /*0*/<-0.58134,-0.65538,-0.4822>,
    /*1*/<-0.80181,0.38725,0.45513>,<0.31052,0.37736,-0.87246>,<0.50373,-0.75059,0.42764>,
            
    /*2*/<-0.86013,0.29959,0.41282>,<0.29428,0.34623,-0.8908>,<0.58134,-0.63783,0.50518>,
            
    /*3*/<-0.91799,0.18443,0.35112>,<0.25357,0.29105,-0.92249>,<0.67308,-0.45819,0.58054>,
            
    /*4*/<0.26443,0.9109,0.31676>

    /* stem 0.0.15*/ 
    /*0*/<0.11101,-0.94115,-0.31923>,
    /*1*/<-0.61942,0.19261,-0.76107>,<0.9821,0.1581,-0.10242>,<-0.36504,-0.33071,0.87027>,
            
    /*2*/<-0.61949,0.20075,-0.7589>,<0.98724,0.10697,-0.11794>,<-0.36713,-0.28794,0.88448>,
            
    /*3*/<-0.62005,0.24691,-0.74469>,<0.98953,0.05679,-0.13272>,<-0.37121,-0.28366,0.88416>,
            
    /*4*/<-0.0002,0.93518,0.35418>

    /* stem 0.0.16*/ 
    /*0*/<0.0857,-0.91253,0.39993>,
    /*1*/<0.52703,-0.29254,-0.79791>,<0.46747,0.39759,0.78955>,<-0.9963,-0.08591,-0.00003>,
            
    /*2*/<0.52339,-0.25075,-0.81436>,<0.47166,0.36495,0.80271>,<-0.99549,-0.09478,0.0034>,
            
    /*3*/<0.51849,-0.16971,-0.83807>,<0.47656,0.28656,0.83113>,<-0.99533,-0.09656,0.00191>,
            
    /*4*/<-0.09329,0.972,-0.21569>

    /* stem 0.0.17*/ 
    /*0*/<-0.51139,-0.6394,0.57414>,
    /*1*/<0.85956,-0.31599,0.40162>,<-0.48974,0.76991,0.40914>,<-0.35919,-0.44062,-0.8227>,
            
    /*2*/<0.87285,-0.29563,0.38824>,<-0.53207,0.7145,0.4543>,<-0.33511,-0.40164,-0.85228>,
            
    /*3*/<0.89247,-0.25961,0.36891>,<-0.62272,0.5649,0.5414>,<-0.27183,-0.28495,-0.91919>,
            
    /*4*/<0.364,0.88597,-0.28735>

    /* stem 0.0.18*/ 
    /*0*/<-0.8547,-0.51736,-0.04269>,
    /*1*/<-0.13666,0.1583,0.97789>,<-0.35518,0.65504,-0.66691>,<0.50939,-0.80272,-0.31011>,
            
    /*2*/<-0.1123,0.18332,0.97662>,<-0.48145,0.55978,-0.67442>,<0.60292,-0.72991,-0.32206>,
            
    /*3*/<-0.13966,0.12521,0.98225>,<-0.59675,0.45994,-0.65753>,<0.75442,-0.57384,-0.31867>,
            
    /*4*/<0.54694,0.83358,0.07749>

    /* stem 0.0.19*/ 
    /*0*/<-0.25813,-0.79142,-0.5541>,
    /*1*/<-0.95654,0.28781,0.04679>,<0.58694,0.33363,-0.73769>,<0.37486,-0.60532,0.70219>,
            
    /*2*/<-0.94003,0.33468,0.06577>,<0.54656,0.21097,-0.81041>,<0.41058,-0.5317,0.74075>,
            
    /*3*/<-0.91112,0.40116,0.09451>,<0.46599,0.02131,-0.88453>,<0.45627,-0.40616,0.79174>,
            
    /*4*/<0.42692,0.89106,0.15413>

    /* stem 0.0.20*/ 
    /*0*/<0.21709,-0.97312,-0.07692>,
    /*1*/<-0.27495,0.02155,-0.96122>,<0.94678,0.19807,0.25373>,<-0.67621,-0.2,0.70904>,
            
    /*2*/<-0.27607,0.03726,-0.96042>,<0.96078,0.12006,0.24998>,<-0.68436,-0.13786,0.71599>,
            
    /*3*/<-0.27335,0.07244,-0.95918>,<0.96741,-0.07258,0.24258>,<-0.68674,0.01786,0.72669>,
            
    /*4*/<0.18809,0.98155,0.03432>

    /* stem 0.0.21*/ 
    /*0*/<-0.06681,-0.90969,0.40988>,
    /*1*/<0.8357,-0.26965,-0.47844>,<0.05545,0.41285,0.90911>,<-0.88982,-0.12508,-0.43884>,
            
    /*2*/<0.83397,-0.28529,-0.47234>,<0.05097,0.37964,0.92373>,<-0.88508,-0.07573,-0.45924>,
            
    /*3*/<0.82744,-0.32714,-0.45642>,<0.05487,0.37134,0.92688>,<-0.87834,-0.02598,-0.47733>,
            
    /*4*/<0.18048,0.90077,-0.39501>

    /* stem 0.0.22*/ 
    /*0*/<-0.57914,-0.72765,0.36758>,
    /*1*/<0.65308,-0.13426,0.74529>,<-0.74775,0.656,0.10261>,<0.10609,-0.5074,-0.85516>,
            
    /*2*/<0.659,-0.12404,0.74185>,<-0.79435,0.59364,0.12885>,<0.141,-0.45297,-0.88031>,
            
    /*3*/<0.66683,-0.10811,0.73733>,<-0.86594,0.46976,0.1717>,<0.20415,-0.34398,-0.91651>,
            
    /*4*/<0.36779,0.90845,-0.19863>

    /* stem 0.0.23*/ 
    /*0*/<-0.67563,-0.68522,-0.27203>,
    /*1*/<-0.53876,0.21758,0.81388>,<-0.15575,0.50102,-0.85131>,<0.70767,-0.70525,0.04273>,
            
    /*2*/<-0.49301,0.27965,0.82386>,<-0.2565,0.39362,-0.88276>,<0.75362,-0.65562,0.04718>,
            
    /*3*/<-0.44668,0.31996,0.83552>,<-0.40147,0.1855,-0.89689>,<0.86808,-0.4938,0.05092>,
            
    /*4*/<0.38807,0.91479,-0.11211>

    /* stem 0.0.24*/ 
    /*0*/<-0.0702,-0.91471,-0.39797>,
    /*1*/<-0.89318,0.2408,-0.37979>,<0.83111,0.17315,-0.52846>,<0.06342,-0.39634,0.91591>,
            
    /*2*/<-0.89366,0.23611,-0.38161>,<0.82718,0.10842,-0.55138>,<0.07263,-0.32777,0.94196>,
            
    /*3*/<-0.88025,0.3052,-0.36335>,<0.80801,0.00148,-0.58916>,<0.07265,-0.28656,0.9553>,
            
    /*4*/<0.27688,0.91531,0.29248>

    /* stem 0.0.25*/ 
    /*0*/<0.24794,-0.95858,0.1402>,
    /*1*/<0.13953,-0.10136,-0.98502>,<0.7579,0.28824,0.58524>,<-0.90214,-0.16865,0.39711>,
            
    /*2*/<0.14322,-0.16413,-0.97599>,<0.76688,0.21084,0.60617>,<-0.92729,-0.02387,0.37358>,
            
    /*3*/<0.14767,-0.26556,-0.95272>,<0.783,0.14841,0.60405>,<-0.92975,0.13468,0.34268>,
            
    /*4*/<0.03683,0.95097,-0.30709>

    /* stem 0.0.26*/ 
    /*0*/<-0.22351,-0.85502,0.46795>,
    /*1*/<0.95813,-0.27943,-0.06252>,<-0.31802,0.52166,0.79166>,<-0.6371,-0.23072,-0.73544>,
            
    /*2*/<0.96544,-0.25007,-0.07344>,<-0.33919,0.44136,0.83076>,<-0.62764,-0.17753,-0.75799>,
            
    /*3*/<0.97313,-0.21419,-0.08457>,<-0.37147,0.30519,0.87685>,<-0.60182,-0.07771,-0.79484>,
            
    /*4*/<0.19462,0.96357,-0.18344>

    /* stem 0.0.27*/ 
    /*0*/<-0.6034,-0.77992,0.16625>,
    /*1*/<0.29126,-0.01775,0.95648>,<-0.78649,0.55401,-0.27296>,<0.50046,-0.5295,-0.68496>,
            
    /*2*/<0.26354,-0.0702,0.96209>,<-0.82806,0.49025,-0.27199>,<0.57813,-0.41489,-0.70259>,
            
    /*3*/<0.23221,-0.11984,0.96525>,<-0.85604,0.44858,-0.25683>,<0.62762,-0.32114,-0.70919>,
            
    /*4*/<0.48835,0.87261,-0.0085>

    /* stem 0.0.28*/ 
    /*0*/<-0.49757,-0.76367,-0.41139>,
    /*1*/<-0.82654,0.27479,0.49124>,<0.18679,0.36953,-0.91025>,<0.64076,-0.64277,0.41984>,
            
    /*2*/<-0.87533,0.18214,0.44791>,<0.19167,0.38208,-0.90404>,<0.67947,-0.56637,0.46641>,
            
    /*3*/<-0.90958,0.09676,0.40411>,<0.17534,0.33534,-0.92564>,<0.73803,-0.43045,0.51965>,
            
    /*4*/<0.24341,0.92081,0.30472>

    /* stem 0.1*/ 
    /*0*/<-0.21919,-0.86603,-0.4494>,
    /*1*/<-0.89646,0.00905,0.44304>,<-0.63648,0.48455,-0.60009>,<0.50625,0.30292,-0.80743>,
            <0.95252,-0.28483,0.10756>,<0.0856,-0.46646,0.88039>,
    /*2*/<-0.89653,0.00916,0.44288>,<-0.64847,0.43601,-0.624>,<0.49944,0.27287,-0.82226>,
            <0.9594,-0.25446,0.12167>,<0.09681,-0.41747,0.90352>,
    /*3*/<-0.89701,0.00969,0.4419>,<-0.66816,0.33493,-0.66437>,<0.48709,0.21064,-0.84757>,
            <0.97078,-0.19124,0.145>,<0.11552,-0.31548,0.94187>,
    /*4*/<0.12573,0.95799,0.25778>

    /* stem 0.1.0*/ 
    /*0*/<0.1026,-0.75564,-0.6469>,
    /*1*/<-0.57288,0.49311,-0.65471>,<0.98993,0.14147,0.0039>,<-0.41947,-0.61677,0.66607>,
            
    /*2*/<-0.57456,0.4211,-0.70182>,<0.99559,0.09042,-0.02489>,<-0.43282,-0.49581,0.75289>,
            
    /*3*/<-0.57099,0.34333,-0.74571>,<0.99572,-0.00623,-0.09224>,<-0.42207,-0.31695,0.84935>,
            
    /*4*/<0.10113,0.93511,0.33962>

    /* stem 0.1.1*/ 
    /*0*/<0.08116,-0.97233,-0.21907>,
    /*1*/<0.64075,0.22678,-0.73349>,<0.33934,-0.17199,0.92481>,<-0.982,-0.03198,-0.18618>,
            
    /*2*/<0.64003,0.23202,-0.73248>,<0.3373,-0.15481,0.92858>,<-0.98007,-0.05448,-0.19103>,
            
    /*3*/<0.63357,0.28929,-0.71757>,<0.34096,-0.17726,0.92321>,<-0.97564,-0.08887,-0.20055>,
            
    /*4*/<-0.16758,0.94055,0.29543>

    /* stem 0.1.2*/ 
    /*0*/<-0.38171,-0.92007,-0.08812>,
    /*1*/<0.86361,-0.3814,0.32971>,<-0.71918,0.24452,0.65038>,<-0.13553,0.15835,-0.97804>,
            
    /*2*/<0.85123,-0.41455,0.3218>,<-0.74846,0.18397,0.63715>,<-0.09694,0.2561,-0.96178>,
            
    /*3*/<0.83724,-0.44686,0.31519>,<-0.7867,0.07897,0.61226>,<-0.04422,0.38893,-0.9202>,
            
    /*4*/<0.32211,0.86305,0.38909>

    /* stem 0.1.3*/ 
    /*0*/<-0.59906,-0.65283,-0.46362>,
    /*1*/<-0.24956,-0.38895,0.88681>,<-0.52583,0.76231,-0.37734>,<0.78926,-0.35824,-0.49873>,
            
    /*2*/<-0.24064,-0.37773,0.8941>,<-0.54781,0.73772,-0.39455>,<0.80136,-0.34362,-0.48964>,
            
    /*3*/<-0.23798,-0.38003,0.89384>,<-0.60445,0.66051,-0.44538>,<0.8574,-0.26159,-0.44322>,
            
    /*4*/<0.39057,0.79261,0.46821>

    /* stem 0.1.4*/ 
    /*0*/<-0.17003,-0.51229,-0.84181>,
    /*1*/<-0.97369,0.21524,0.07481>,<0.61253,0.61915,-0.49138>,<0.36508,-0.82258,0.43598>,
            
    /*2*/<-0.98485,0.17277,0.01466>,<0.61205,0.6186,-0.49267>,<0.37207,-0.78216,0.4998>,
            
    /*3*/<-0.99117,0.11042,-0.07341>,<0.61642,0.56907,-0.54423>,<0.38123,-0.66743,0.63969>,
            
    /*4*/<-0.00576,0.76201,0.64754>

    /* stem 0.1.5*/ 
    /*0*/<0.36323,-0.77206,-0.52152>,
    /*1*/<-0.18725,0.49497,-0.8485>,<0.88033,0.11286,0.46074>,<-0.70142,-0.59011,0.39973>,
            
    /*2*/<-0.1846,0.48865,-0.85273>,<0.89274,0.08387,0.4427>,<-0.71589,-0.55529,0.42325>,
            
    /*3*/<-0.17573,0.42159,-0.88959>,<0.92029,-0.02634,0.39034>,<-0.76274,-0.37799,0.52474>,
            
    /*4*/<-0.01834,0.93359,0.35787>

    /* stem 0.1.6*/ 
    /*0*/<-0.05858,-0.98915,-0.13475>,
    /*1*/<0.89245,0.01623,-0.45085>,<-0.05745,-0.12387,0.99063>,<-0.83367,0.13016,-0.53671>,
            
    /*2*/<0.89706,0.09435,-0.43171>,<-0.05729,-0.21447,0.97505>,<-0.83412,0.14046,-0.5334>,
            
    /*3*/<0.89836,0.1539,-0.41143>,<-0.07385,-0.36065,0.92977>,<-0.82945,0.22825,-0.50982>,
            
    /*4*/<0.07017,0.90049,0.42918>

    /* stem 0.1.7*/ 
    /*0*/<-0.55759,-0.82258,-0.11157>,
    /*1*/<0.58999,-0.47893,0.65003>,<-0.79803,0.50566,0.32781>,<0.22066,-0.00811,-0.97532>,
            
    /*2*/<0.60311,-0.45655,0.65408>,<-0.82575,0.46318,0.32188>,<0.23271,0.01315,-0.97246>,
            
    /*3*/<0.6435,-0.35356,0.6789>,<-0.91019,0.29143,0.29433>,<0.26101,0.08219,-0.96183>,
            
    /*4*/<0.20747,0.96054,0.18523>

    /* stem 0.1.8*/ 
    /*0*/<-0.51368,-0.5971,-0.61612>,
    /*1*/<-0.6246,-0.22251,0.74857>,<-0.18773,0.78426,-0.59135>,<0.8239,-0.54831,-0.14335>,
            
    /*2*/<-0.63079,-0.23253,0.74029>,<-0.22806,0.72131,-0.65398>,<0.87776,-0.47245,-0.0796>,
            
    /*3*/<-0.62413,-0.20593,0.75369>,<-0.28103,0.63249,-0.72179>,<0.9121,-0.40952,-0.01919>,
            
    /*4*/<0.38909,0.78201,0.4869>

    /* stem 0.1.9*/ 
    /*0*/<0.02773,-0.59602,-0.80249>,
    /*1*/<-0.86874,0.38745,-0.3085>,<0.86257,0.4241,-0.27589>,<0.00555,-0.79822,0.60234>,
            
    /*2*/<-0.87313,0.33587,-0.35333>,<0.87219,0.34794,-0.34383>,<0.00587,-0.67827,0.73479>,
            
    /*3*/<-0.87362,0.25276,-0.41582>,<0.86282,0.2051,-0.46203>,<0.01653,-0.44138,0.89717>,
            
    /*4*/<0.06192,0.93833,0.34014>

    /* stem 0.1.10*/ 
    /*0*/<0.18274,-0.94256,-0.2796>,
    /*1*/<0.21809,0.32327,-0.92083>,<0.71887,-0.05828,0.69269>,<-0.94101,-0.24413,0.23433>,
            
    /*2*/<0.21834,0.32498,-0.92017>,<0.72736,-0.12028,0.67563>,<-0.94907,-0.18515,0.2549>,
            
    /*3*/<0.22319,0.36582,-0.90353>,<0.73408,-0.28056,0.61839>,<-0.95177,-0.06925,0.2989>,
            
    /*4*/<0.12839,0.89247,0.43244>

    /* stem 0.1.11*/ 
    /*0*/<-0.1364,-0.94864,0.28543>,
    /*1*/<0.98578,-0.15413,-0.06689>,<-0.39833,0.32329,0.85838>,<-0.58444,-0.14826,-0.79777>,
            
    /*2*/<0.98355,-0.16929,-0.06304>,<-0.40252,0.30014,0.86481>,<-0.57857,-0.10982,-0.80821>,
            
    /*3*/<0.98388,-0.16745,-0.06278>,<-0.41175,0.23387,0.88078>,<-0.56947,-0.04486,-0.82079>,
            
    /*4*/<0.14784,0.98008,-0.13263>

    /* stem 0.1.12*/ 
    /*0*/<-0.74421,-0.66026,-0.10102>,
    /*1*/<0.22903,-0.38399,0.89448>,<-0.65146,0.75566,-0.06769>,<0.43866,-0.35727,-0.82458>,
            
    /*2*/<0.2407,-0.36973,0.89742>,<-0.71591,0.69353,-0.08049>,<0.48629,-0.30494,-0.81886>,
            
    /*3*/<0.27911,-0.31583,0.90683>,<-0.79815,0.59469,-0.09639>,<0.53105,-0.26121,-0.80607>,
            
    /*4*/<0.55095,0.83114,0.0752>

    /* stem 0.1.13*/ 
    /*0*/<-0.39422,-0.5141,-0.76177>,
    /*1*/<-0.88134,-0.01013,0.47237>,<0.22793,0.75331,-0.6169>,<0.66191,-0.73209,0.16097>,
            
    /*2*/<-0.87701,0.00208,0.48047>,<0.1731,0.63516,-0.75273>,<0.73657,-0.62186,0.266>,
            
    /*3*/<-0.86479,0.03751,0.50073>,<0.075,0.42821,-0.90056>,<0.79855,-0.4472,0.4029>,
            
    /*4*/<0.26042,0.90259,0.34281>

    /* stem 0.1.14*/ 
    /*0*/<0.33261,-0.66129,-0.67235>,
    /*1*/<-0.62379,0.38729,-0.67889>,<0.92264,0.3722,0.10096>,<-0.30598,-0.74534,0.59232>,
            
    /*2*/<-0.59429,0.32266,-0.73669>,<0.91638,0.38494,0.10991>,<-0.33596,-0.69413,0.63664>,
            
    /*3*/<-0.57508,0.31908,-0.75331>,<0.9578,0.28434,0.04215>,<-0.37261,-0.58542,0.72003>,
            
    /*4*/<-0.1182,0.8373,0.53381>

    /* stem 0.1.15*/ 
    /*0*/<0.32614,-0.94491,0.02774>,
    /*1*/<0.6023,0.19261,-0.77468>,<0.32471,0.14697,0.93432>,<-0.93391,-0.31958,-0.16023>,
            
    /*2*/<0.59968,0.20581,-0.77333>,<0.34915,0.05794,0.93527>,<-0.9571,-0.24516,-0.15444>,
            
    /*3*/<0.59725,0.21936,-0.77148>,<0.38007,-0.07864,0.92161>,<-0.98201,-0.12078,-0.14513>,
            
    /*4*/<-0.10487,0.97662,0.18764>

    /* stem 0.1.16*/ 
    /*0*/<-0.35433,-0.92776,0.11706>,
    /*1*/<0.8959,-0.29243,0.33443>,<-0.68329,0.3494,0.64112>,<-0.20518,-0.0375,-0.97801>,
            
    /*2*/<0.87383,-0.34724,0.34036>,<-0.67336,0.37046,0.6398>,<-0.18981,-0.00545,-0.98181>,
            
    /*3*/<0.8795,-0.32336,0.34917>,<-0.72594,0.23539,0.64622>,<-0.16293,0.10546,-0.98098>,
            
    /*4*/<0.20938,0.96742,0.14235>

    /* stem 0.1.17*/ 
    /*0*/<-0.66768,-0.64603,-0.36994>,
    /*1*/<-0.19803,-0.31596,0.92788>,<-0.5144,0.76465,-0.3882>,<0.72629,-0.43528,-0.532>,
            
    /*2*/<-0.18617,-0.29762,0.93636>,<-0.58638,0.68307,-0.43541>,<0.78233,-0.36585,-0.5041>,
            
    /*3*/<-0.16574,-0.25491,0.95265>,<-0.69136,0.51432,-0.50745>,<0.86279,-0.23961,-0.44516>,
            
    /*4*/<0.32342,0.9046,0.27767>

    /* stem 0.1.18*/ 
    /*0*/<-0.1672,-0.70025,-0.69404>,
    /*1*/<-0.98346,0.15954,0.08579>,<0.5373,0.53094,-0.65529>,<0.44958,-0.67614,0.58371>,
            
    /*2*/<-0.97932,0.17699,0.098>,<0.52268,0.46035,-0.71755>,<0.46697,-0.62186,0.62867>,
            
    /*3*/<-0.98321,0.15766,0.09184>,<0.49718,0.36446,-0.78739>,<0.49078,-0.50651,0.70893>,
            
    /*4*/<0.1339,0.88303,0.44982>

    /* stem 0.1.19*/ 
    /*0*/<0.29125,-0.88916,-0.35293>,
    /*1*/<-0.25947,0.28846,-0.92167>,<0.92466,0.17657,0.33737>,<-0.67111,-0.44698,0.59146>,
            
    /*2*/<-0.24052,0.1969,-0.95046>,<0.92943,0.1584,0.33326>,<-0.70583,-0.33819,0.62243>,
            
    /*3*/<-0.22313,0.12562,-0.96666>,<0.94936,0.06815,0.30671>,<-0.72529,-0.17481,0.66587>,
            
    /*4*/<-0.03417,0.98767,0.15276>

    /* stem 0.1.20*/ 
    /*0*/<0.05012,-0.99695,0.05989>,
    /*1*/<0.87523,0.02169,-0.48322>,<-0.02204,0.06554,0.99761>,<-0.8542,-0.0672,-0.51559>,
            
    /*2*/<0.87401,-0.03175,-0.48487>,<-0.02507,0.02278,0.99943>,<-0.85398,0.03041,-0.51942>,
            
    /*3*/<0.86892,-0.08953,-0.48679>,<-0.02968,-0.0861,0.99584>,<-0.84031,0.19581,-0.5055>,
            
    /*4*/<0.20281,0.96575,0.16183>

    /* stem 0.1.21*/ 
    /*0*/<-0.55842,-0.80492,0.20069>,
    /*1*/<0.65512,-0.27034,0.7055>,<-0.7668,0.59823,0.23266>,<0.12281,-0.31185,-0.94216>,
            
    /*2*/<0.66861,-0.24526,0.702>,<-0.81238,0.52815,0.24717>,<0.14856,-0.26412,-0.95298>,
            
    /*3*/<0.67243,-0.24127,0.69973>,<-0.87515,0.40755,0.2608>,<0.21008,-0.14766,-0.96647>,
            
    /*4*/<0.36814,0.92972,0.01013>

    /* stem 0.1.22*/ 
    /*0*/<-0.58666,-0.61002,-0.53263>,
    /*1*/<-0.57864,-0.13504,0.80432>,<-0.19212,0.74908,-0.63401>,<0.7823,-0.60204,-0.15984>,
            
    /*2*/<-0.60032,-0.16069,0.78345>,<-0.19942,0.74058,-0.64169>,<0.81188,-0.56914,-0.13014>,
            
    /*3*/<-0.61993,-0.18032,0.76366>,<-0.24018,0.68133,-0.69145>,<0.87155,-0.48588,-0.06572>,
            
    /*4*/<0.39585,0.7679,0.50362>

    /* stem 0.1.23*/ 
    /*0*/<0.09896,-0.7098,-0.69742>,
    /*1*/<-0.91412,0.21774,-0.34201>,<0.79784,0.47946,-0.36546>,<0.11435,-0.68338,0.72105>,
            
    /*2*/<-0.91508,0.22655,-0.33363>,<0.79942,0.46763,-0.37716>,<0.11409,-0.68014,0.72415>,
            
    /*3*/<-0.9148,0.18153,-0.36082>,<0.81528,0.37967,-0.43723>,<0.10327,-0.55082,0.82821>,
            
    /*4*/<-0.06957,0.90109,0.42801>

    /* stem 0.1.24*/ 
    /*0*/<0.37091,-0.91509,-0.15821>,
    /*1*/<0.16913,0.24081,-0.95572>,<0.70226,0.17223,0.69078>,<-0.87854,-0.39541,0.268>,
            
    /*2*/<0.19262,0.14857,-0.96996>,<0.70919,0.14628,0.68967>,<-0.91952,-0.27774,0.2781>,
            
    /*3*/<0.21155,0.06348,-0.9753>,<0.73142,0.08305,0.67685>,<-0.94527,-0.12784,0.30019>,
            
    /*4*/<-0.09441,0.99444,0.04667>

    /* stem 0.1.25*/ 
    /*0*/<-0.08173,-0.96072,0.26522>,
    /*1*/<0.99116,-0.10135,-0.08558>,<-0.40032,0.2814,0.8721>,<-0.58929,-0.16179,-0.79156>,
            
    /*2*/<0.99241,-0.08274,-0.09096>,<-0.40057,0.27861,0.87288>,<-0.59041,-0.1777,-0.7873>,
            
    /*3*/<0.99435,-0.03643,-0.09968>,<-0.40471,0.21676,0.88838>,<-0.5906,-0.16163,-0.79062>,
            
    /*4*/<-0.00208,0.98608,-0.16625>

    /* stem 0.1.26*/ 
    /*0*/<-0.52127,-0.84684,-0.10551>,
    /*1*/<0.27678,-0.27904,0.91953>,<-0.83435,0.53568,-0.13002>,<0.56538,-0.24395,-0.78793>,
            
    /*2*/<0.28537,-0.26184,0.92196>,<-0.86208,0.48806,-0.13645>,<0.58196,-0.2123,-0.78501>,
            
    /*3*/<0.2791,-0.27947,0.9187>,<-0.89497,0.42119,-0.14702>,<0.6241,-0.1287,-0.77068>,
            
    /*4*/<0.36383,0.90689,0.21257>

    /* stem 0.1.27*/ 
    /*0*/<-0.37436,-0.63232,-0.67825>,
    /*1*/<-0.86633,-0.01836,0.49913>,<0.15052,0.68234,-0.71537>,<0.71874,-0.65904,0.22154>,
            
    /*2*/<-0.85499,0.00155,0.51865>,<0.1363,0.65949,-0.73925>,<0.72113,-0.65518,0.22519>,
            
    /*3*/<-0.83392,0.03938,0.55049>,<0.08331,0.56113,-0.82353>,<0.75831,-0.59341,0.26987>,
            
    /*4*/<0.36798,0.80796,0.46022>

    /* stem 0.1.28*/ 
    /*0*/<0.30814,-0.74697,-0.58914>,
    /*1*/<-0.66471,0.27506,-0.69463>,<0.92156,0.38816,-0.00836>,<-0.25782,-0.66086,0.70484>,
            
    /*2*/<-0.67917,0.32607,-0.65757>,<0.94343,0.32601,-0.06039>,<-0.2612,-0.64676,0.71657>,
            
    /*3*/<-0.68651,0.31372,-0.65596>,<0.96563,0.22739,-0.12594>,<-0.28554,-0.54166,0.79062>,
            
    /*4*/<-0.11371,0.89378,0.43385>

    /* stem 0.2*/ 
    /*0*/<0.38857,-0.86603,-0.31466>,
    /*1*/<-0.63334,0.00904,-0.77382>,<0.44154,0.48454,-0.75516>,<0.90062,0.30292,0.31164>,
            <0.10947,-0.28484,0.9523>,<-0.83857,-0.46646,0.28145>,
    /*2*/<-0.6332,0.00915,-0.77393>,<0.46214,0.43601,-0.77222>,<0.91353,0.27286,0.30167>,
            <0.09727,-0.25447,0.96218>,<-0.85858,-0.41748,0.29758>,
    /*3*/<-0.63235,0.00968,-0.77462>,<0.49704,0.33492,-0.80049>,<0.93542,0.21063,0.28394>,
            <0.0771,-0.19125,0.97851>,<-0.89175,-0.31549,0.32443>,
    /*4*/<-0.22289,0.95799,0.18049>

    /* stem 0.2.0*/ 
    /*0*/<0.75406,-0.64893,0.10144>,
    /*1*/<0.50827,0.49227,-0.70663>,<0.09085,0.26762,0.95923>,<-0.6169,-0.74459,-0.25499>,
            
    /*2*/<0.5172,0.48353,-0.7062>,<0.14032,0.21723,0.96598>,<-0.67846,-0.68778,-0.25815>,
            
    /*3*/<0.54347,0.44959,-0.70888>,<0.22553,0.12629,0.96602>,<-0.78805,-0.5599,-0.2559>,
            
    /*4*/<-0.52829,0.84557,0.07698>

    /* stem 0.2.1*/ 
    /*0*/<0.08886,-0.95341,0.28829>,
    /*1*/<0.85994,0.22664,0.45731>,<-0.86519,0.07738,0.49544>,<0.00316,-0.28164,-0.95952>,
            
    /*2*/<0.86073,0.21993,0.4591>,<-0.86139,0.03046,0.50702>,<-0.0039,-0.22837,-0.97357>,
            
    /*3*/<0.85939,0.22772,0.45782>,<-0.85391,-0.01834,0.52009>,<-0.00868,-0.18666,-0.98239>,
            
    /*4*/<-0.15642,0.96663,-0.20287>

    /* stem 0.2.2*/ 
    /*0*/<-0.12546,-0.90639,-0.40338>,
    /*1*/<-0.12602,-0.38152,0.91573>,<-0.78762,0.34484,-0.51063>,<0.91656,0.05781,-0.3957>,
            
    /*2*/<-0.12761,-0.41925,0.89886>,<-0.78977,0.31499,-0.52636>,<0.92309,0.12603,-0.36335>,
            
    /*3*/<-0.13151,-0.43506,0.89075>,<-0.78944,0.20057,-0.58013>,<0.91646,0.25691,-0.30675>,
            
    /*4*/<-0.18592,0.90027,0.39363>

    /* stem 0.2.3*/ 
    /*0*/<0.2799,-0.55456,-0.78366>,
    /*1*/<-0.91994,-0.38971,-0.04294>,<0.21286,0.83601,-0.50574>,<0.70059,-0.43346,0.56682>,
            
    /*2*/<-0.92445,-0.37981,-0.0336>,<0.24346,0.78015,-0.57628>,<0.68084,-0.3821,0.62487>,
            
    /*3*/<-0.94215,-0.3352,-0.00175>,<0.29509,0.65762,-0.69315>,<0.64215,-0.30253,0.70436>,
            
    /*4*/<-0.25127,0.8092,0.5311>

    /* stem 0.2.4*/ 
    /*0*/<0.73855,-0.57289,-0.35545>,
    /*1*/<-0.29158,0.2157,-0.93191>,<0.66604,0.58455,0.46334>,<-0.39146,-0.78706,0.47675>,
            
    /*2*/<-0.27567,0.19913,-0.9404>,<0.72255,0.53249,0.44089>,<-0.46392,-0.72051,0.51541>,
            
    /*3*/<-0.23973,0.14353,-0.96017>,<0.84072,0.37626,0.38937>,<-0.62091,-0.50491,0.59962>,
            
    /*4*/<-0.33491,0.92761,0.16545>

    /* stem 0.2.5*/ 
    /*0*/<0.55015,-0.83181,0.0736>,
    /*1*/<0.78494,0.49541,-0.37207>,<-0.16232,-0.01088,0.98668>,<-0.63522,-0.46548,-0.61629>,
            
    /*2*/<0.76947,0.51938,-0.3717>,<-0.13052,-0.05866,0.98971>,<-0.65184,-0.44216,-0.61611>,
            
    /*3*/<0.76209,0.53076,-0.37084>,<-0.07446,-0.15257,0.98548>,<-0.70316,-0.36073,-0.61273>,
            
    /*4*/<-0.49102,0.85703,0.15618>

    /* stem 0.2.6*/ 
    /*0*/<0.05637,-0.99777,-0.03573>,
    /*1*/<0.64052,0.0163,0.76777>,<-0.98382,-0.05408,0.17079>,<0.34201,0.06051,-0.93774>,
            
    /*2*/<0.62122,0.10106,0.77709>,<-0.96624,-0.1948,0.16859>,<0.32863,0.1091,-0.93814>,
            
    /*3*/<0.59281,0.19148,0.78225>,<-0.9191,-0.36577,0.14651>,<0.3171,0.1946,-0.92821>,
            
    /*4*/<-0.4017,0.91211,0.08177>

    /* stem 0.2.7*/ 
    /*0*/<-0.11808,-0.78212,-0.61183>,
    /*1*/<-0.49988,-0.47923,0.72143>,<-0.4913,0.58712,-0.64337>,<0.99385,-0.09017,-0.0642>,
            
    /*2*/<-0.50035,-0.50993,0.69973>,<-0.49219,0.54523,-0.67858>,<0.99984,-0.01584,-0.00791>,
            
    /*3*/<-0.50602,-0.51291,0.69345>,<-0.49279,0.4564,-0.74085>,<0.99542,0.07555,0.05853>,
            
    /*4*/<-0.10842,0.85065,0.51443>

    /* stem 0.2.8*/ 
    /*0*/<0.49856,-0.44926,-0.74135>,
    /*1*/<-0.86999,-0.22362,-0.43945>,<0.4568,0.86516,-0.20699>,<0.40199,-0.63144,0.6631>,
            
    /*2*/<-0.86177,-0.23446,-0.44986>,<0.54598,0.78173,-0.30134>,<0.32562,-0.53048,0.78266>,
            
    /*3*/<-0.81193,-0.30599,-0.49714>,<0.63879,0.64949,-0.41244>,<0.15885,-0.33118,0.9301>,
            
    /*4*/<-0.56038,0.79019,0.24816>

    /* stem 0.2.9*/ 
    /*0*/<0.70162,-0.68373,-0.20061>,
    /*1*/<0.10583,0.3881,-0.91552>,<0.54879,0.35148,0.75848>,<-0.67027,-0.72432,0.16152>,
            
    /*2*/<0.10317,0.39177,-0.91426>,<0.58945,0.30789,0.74683>,<-0.70723,-0.68482,0.17565>,
            
    /*3*/<0.14198,0.32779,-0.93402>,<0.64103,0.24547,0.7272>,<-0.80321,-0.55819,0.20805>,
            
    /*4*/<-0.45276,0.87985,0.14446>

    /* stem 0.2.10*/ 
    /*0*/<0.31388,-0.94339,0.1072>,
    /*1*/<0.94629,0.32327,0.00541>,<-0.51105,-0.06482,0.8571>,<-0.44218,-0.23758,-0.86489>,
            
    /*2*/<0.9559,0.29366,0.00415>,<-0.49249,-0.14246,0.85858>,<-0.47838,-0.131,-0.86832>,
            
    /*3*/<0.96955,0.24488,0.0008>,<-0.46968,-0.18226,0.86382>,<-0.50551,-0.04162,-0.86181>,
            
    /*4*/<-0.21881,0.97432,0.05311>

    /* stem 0.2.11*/ 
    /*0*/<-0.0868,-0.98606,-0.14195>,
    /*1*/<0.2853,-0.15388,0.946>,<-0.96846,0.1238,-0.21625>,<0.68507,0.05172,-0.72664>,
            
    /*2*/<0.28324,-0.19612,0.93878>,<-0.96901,0.11721,-0.21744>,<0.68949,0.10032,-0.71732>,
            
    /*3*/<0.28443,-0.245,0.92686>,<-0.97116,0.04014,-0.23502>,<0.68552,0.22771,-0.69153>,
            
    /*4*/<-0.11566,0.94641,0.30154>

    /* stem 0.2.12*/ 
    /*0*/<0.08215,-0.8056,-0.58674>,
    /*1*/<-0.82113,-0.38295,0.42319>,<-0.08016,0.58737,-0.80534>,<0.89951,-0.1869,0.39491>,
            
    /*2*/<-0.83381,-0.31268,0.45497>,<-0.06658,0.45249,-0.88928>,<0.89736,-0.11802,0.42522>,
            
    /*3*/<-0.84381,-0.2171,0.49076>,<-0.03678,0.26318,-0.96405>,<0.87859,-0.02541,0.4769>,
            
    /*4*/<-0.10983,0.97184,0.2085>

    /* stem 0.2.13*/ 
    /*0*/<0.55,-0.6953,-0.46266>,
    /*1*/<-0.65777,-0.00883,-0.75316>,<0.77294,0.6342,-0.01872>,<-0.12702,-0.61039,0.78185>,
            
    /*2*/<-0.66343,0.00265,-0.74823>,<0.83097,0.55281,-0.06233>,<-0.16934,-0.53824,0.82561>,
            
    /*3*/<-0.66579,0.00186,-0.74613>,<0.92733,0.34749,-0.13899>,<-0.25788,-0.32986,0.90812>,
            
    /*4*/<-0.1927,0.97025,0.14655>

    /* stem 0.2.14*/ 
    /*0*/<0.74366,-0.64009,0.19303>,
    /*1*/<0.52108,0.38714,-0.76066>,<0.08845,0.39027,0.91644>,<-0.62543,-0.76371,-0.15991>,
            
    /*2*/<0.5392,0.36947,-0.7568>,<0.11402,0.36492,0.92403>,<-0.6707,-0.72174,-0.17101>,
            
    /*3*/<0.55161,0.35941,-0.75269>,<0.16379,0.31519,0.93479>,<-0.72948,-0.65878,-0.18402>,
            
    /*4*/<-0.63894,0.7626,-0.10098>

    /* stem 0.2.15*/ 
    /*0*/<0.0348,-0.93774,0.34558>,
    /*1*/<0.8904,0.19255,0.41245>,<-0.83815,0.16768,0.51903>,<-0.05299,-0.34042,-0.93878>,
            
    /*2*/<0.89166,0.1725,0.41856>,<-0.83779,0.13655,0.52864>,<-0.05533,-0.2894,-0.95561>,
            
    /*3*/<0.89624,0.10217,0.43164>,<-0.83466,0.07807,0.54521>,<-0.06092,-0.15961,-0.9853>,
            
    /*4*/<-0.00682,0.99611,-0.08782>

    /* stem 0.2.16*/ 
    /*0*/<-0.33849,-0.88338,-0.32412>,
    /*1*/<-0.12332,-0.29276,0.9482>,<-0.74238,0.46819,-0.47923>,<0.87278,-0.15696,-0.46219>,
            
    /*2*/<-0.1167,-0.27325,0.95484>,<-0.75235,0.44207,-0.4884>,<0.87515,-0.1499,-0.46006>,
            
    /*3*/<-0.11366,-0.27978,0.95331>,<-0.78144,0.30892,-0.54214>,<0.90766,-0.00316,-0.4197>,
            
    /*4*/<-0.00135,0.94892,0.31551>

    /* stem 0.2.17*/ 
    /*0*/<0.19357,-0.59815,-0.77765>,
    /*1*/<-0.94853,-0.31629,0.01608>,<0.25092,0.80046,-0.54434>,<0.69359,-0.47175,0.54441>,
            
    /*2*/<-0.95313,-0.3011,0.02954>,<0.27468,0.73464,-0.62036>,<0.68157,-0.41573,0.60219>,
            
    /*3*/<-0.94536,-0.32577,0.01292>,<0.29865,0.65032,-0.6985>,<0.64187,-0.31084,0.70098>,
            
    /*4*/<-0.32051,0.77175,0.54925>

    /* stem 0.2.18*/ 
    /*0*/<0.75943,-0.55816,-0.33424>,
    /*1*/<-0.30567,0.15858,-0.93884>,<0.64475,0.63239,0.4294>,<-0.35469,-0.7795,0.51631>,
            
    /*2*/<-0.31533,0.16994,-0.93364>,<0.72555,0.56275,0.39609>,<-0.41841,-0.71999,0.55367>,
            
    /*3*/<-0.32425,0.17503,-0.92964>,<0.84153,0.42803,0.32957>,<-0.52658,-0.58871,0.6133>,
            
    /*4*/<-0.44429,0.84406,0.30028>

    /* stem 0.2.19*/ 
    /*0*/<0.43607,-0.85756,0.27282>,
    /*1*/<0.83949,0.28825,-0.46061>,<-0.1502,0.23689,0.95986>,<-0.69816,-0.5077,-0.50479>,
            
    /*2*/<0.84621,0.27348,-0.45731>,<-0.12991,0.18853,0.97344>,<-0.72841,-0.44535,-0.52066>,
            
    /*3*/<0.85742,0.24479,-0.45267>,<-0.09161,0.10054,0.99071>,<-0.77508,-0.32708,-0.54061>,
            
    /*4*/<-0.28632,0.95536,-0.07284>

    /* stem 0.2.20*/ 
    /*0*/<-0.16225,-0.97285,0.16506>,
    /*1*/<0.66849,0.02153,0.74341>,<-0.96202,0.19903,0.18683>,<0.29679,-0.201,-0.93355>,
            
    /*2*/<0.65956,-0.03882,0.75065>,<-0.96133,0.20223,0.18695>,<0.30881,-0.14456,-0.94007>,
            
    /*3*/<0.65364,-0.08508,0.75201>,<-0.96736,0.16232,0.19458>,<0.31547,-0.0574,-0.9472>,
            
    /*4*/<0.11494,0.99337,0.00181>

    /* stem 0.2.21*/ 
    /*0*/<-0.30349,-0.81662,-0.49095>,
    /*1*/<-0.54017,-0.27028,0.79697>,<-0.40544,0.58238,-0.70459>,<0.95164,-0.29589,-0.08263>,
            
    /*2*/<-0.53624,-0.25725,0.80391>,<-0.41711,0.54941,-0.724>,<0.95876,-0.27502,-0.07169>,
            
    /*3*/<-0.50685,-0.167,0.8457>,<-0.44302,0.4776,-0.7587>,<0.95312,-0.29332,-0.07433>,
            
    /*4*/<0.34934,0.89104,0.28984>

    /* stem 0.2.22*/ 
    /*0*/<0.37657,-0.66168,-0.64836>,
    /*1*/<-0.9138,-0.13471,-0.38317>,<0.59713,0.71191,-0.36962>,<0.30927,-0.5642,0.76552>,
            
    /*2*/<-0.93262,-0.09471,-0.3482>,<0.61753,0.67088,-0.41058>,<0.30814,-0.56053,0.76867>,
            
    /*3*/<-0.94233,-0.075,-0.32617>,<0.64216,0.61388,-0.45911>,<0.29495,-0.52506,0.79833>,
            
    /*4*/<-0.29177,0.76941,0.56822>

    /* stem 0.2.23*/ 
    /*0*/<0.65405,-0.75259,-0.0764>,
    /*1*/<0.12793,0.21801,-0.96753>,<0.5747,0.43787,0.69137>,<-0.71534,-0.64125,0.27764>,
            
    /*2*/<0.16599,0.1658,-0.97209>,<0.58471,0.42451,0.69131>,<-0.76698,-0.57764,0.27942>,
            
    /*3*/<0.20439,0.11347,-0.97229>,<0.66221,0.27267,0.69794>,<-0.87946,-0.37126,0.29786>,
            
    /*4*/<-0.22626,0.97225,0.0594>

    /* stem 0.2.24*/ 
    /*0*/<0.23191,-0.8687,0.4377>,
    /*1*/<0.96931,0.2405,-0.05091>,<-0.53975,0.26575,0.79877>,<-0.43402,-0.48954,-0.75629>,
            
    /*2*/<0.98032,0.19365,-0.03838>,<-0.5288,0.17686,0.83012>,<-0.46836,-0.3547,-0.80921>,
            
    /*3*/<0.9902,0.13782,-0.02266>,<-0.4935,0.04928,0.86835>,<-0.50118,-0.16886,-0.8487>,
            
    /*4*/<-0.12515,0.98945,-0.07301>

    /* stem 0.2.25*/ 
    /*0*/<-0.18087,-0.98206,-0.05327>,
    /*1*/<0.30573,-0.10129,0.94672>,<-0.96101,0.19405,-0.19697>,<0.65868,-0.07432,-0.74874>,
            
    /*2*/<0.30523,-0.10365,0.94662>,<-0.96943,0.13857,-0.2025>,<0.6658,-0.01601,-0.74595>,
            
    /*3*/<0.30367,-0.08604,0.94888>,<-0.97705,0.02083,-0.21201>,<0.67094,0.08365,-0.73678>,
            
    /*4*/<-0.06964,0.99279,0.09759>

    /* stem 0.2.26*/ 
    /*0*/<-0.09508,-0.77184,-0.62867>,
    /*1*/<-0.83332,-0.2796,0.47687>,<-0.05364,0.63827,-0.76794>,<0.88832,-0.34765,0.30005>,
            
    /*2*/<-0.8336,-0.27978,0.47628>,<-0.05117,0.53383,-0.84404>,<0.89914,-0.23753,0.36759>,
            
    /*3*/<-0.826,-0.3374,0.45154>,<-0.04984,0.39535,-0.91718>,<0.87788,-0.04581,0.47669>,
            
    /*4*/<-0.25033,0.89759,0.36286>

    /* stem 0.2.27*/ 
    /*0*/<0.59158,-0.6059,-0.5319>,
    /*1*/<-0.68148,-0.0182,-0.73161>,<0.71361,0.70054,0.00127>,<-0.03741,-0.67693,0.73509>,
            
    /*2*/<-0.71194,0.03813,-0.70121>,<0.81518,0.57155,-0.09385>,<-0.07996,-0.59786,0.79761>,
            
    /*3*/<-0.71767,-0.00146,-0.69638>,<0.88945,0.41707,-0.1869>,<-0.18499,-0.41289,0.8918>,
            
    /*4*/<-0.35934,0.90754,0.21737>

    /* stem 0.2.28*/ 
    /*0*/<0.55025,-0.83137,0.07775>,
    /*1*/<0.52717,0.27548,-0.80387>,<0.29544,0.28263,0.9126>,<-0.82501,-0.55449,-0.10907>,
            
    /*2*/<0.51254,0.30697,-0.80192>,<0.35964,0.1685,0.91775>,<-0.87401,-0.47501,-0.10235>,
            
    /*3*/<0.5045,0.29606,-0.81107>,<0.44217,-0.03522,0.89624>,<-0.96285,-0.2582,-0.07903>,
            
    /*4*/<-0.13515,0.96797,0.21157>

    /* stem 0.3*/ 
    /*0*/<0.39401,-0.86603,0.30783>,
    /*1*/<0.61152,0.00903,-0.79118>,<0.83513,0.48453,0.26035>,<-0.10106,0.30291,0.94765>,
            <-0.90327,-0.28485,0.32089>,<-0.46287,-0.46647,-0.75376>,
    /*2*/<0.61166,0.00914,-0.79107>,<0.85639,0.436,0.27658>,<-0.08843,0.27285,0.95798>,
            <-0.91563,-0.25448,0.31122>,<-0.48309,-0.41749,-0.76963>,
    /*3*/<0.61252,0.00967,-0.79039>,<0.89178,0.33491,0.30424>,<-0.06624,0.21062,0.97532>,
            <-0.93608,-0.19126,0.29524>,<-0.51671,-0.3155,-0.79591>,
    /*4*/<-0.226,0.95799,-0.17657>

    /* stem 0.3.0*/ 
    /*0*/<0.07493,-0.653,0.75364>,
    /*1*/<0.80283,0.49229,0.33633>,<-0.9138,0.2637,0.30893>,<0.10921,-0.74062,-0.66299>,
            
    /*2*/<0.81416,0.43302,0.38684>,<-0.91256,0.21988,0.34481>,<0.10033,-0.64174,-0.76033>,
            
    /*3*/<0.82229,0.35081,0.44807>,<-0.89894,0.14191,0.41446>,<0.0733,-0.47428,-0.87732>,
            
    /*4*/<-0.11422,0.89851,-0.42382>

    /* stem 0.3.1*/ 
    /*0*/<-0.21977,-0.96159,0.16444>,
    /*1*/<-0.25247,0.22667,0.94068>,<-0.68684,0.04098,-0.72565>,<0.94445,-0.24517,-0.21887>,
            
    /*2*/<-0.25337,0.22561,0.94069>,<-0.69955,-0.10036,-0.7075>,<0.96038,-0.10725,-0.25722>,
            
    /*3*/<-0.26204,0.28723,0.92132>,<-0.70411,-0.28652,-0.64972>,<0.96075,0.02141,-0.27657>,
            
    /*4*/<-0.10958,0.91832,-0.38036>

    /* stem 0.3.2*/ 
    /*0*/<0.36714,-0.90879,-0.19826>,
    /*1*/<-0.92062,-0.38151,0.08309>,<0.32514,0.33298,-0.8851>,<0.58694,0.06968,0.80663>,
            
    /*2*/<-0.90703,-0.41311,0.0815>,<0.36297,0.26116,-0.89445>,<0.54265,0.17821,0.82083>,
            
    /*3*/<-0.8897,-0.44994,0.07739>,<0.41455,0.14096,-0.89905>,<0.46689,0.33058,0.8202>,
            
    /*4*/<-0.46839,0.87206,-0.14189>

    /* stem 0.3.3*/ 
    /*0*/<0.79279,-0.59737,0.12098>,
    /*1*/<-0.16485,-0.38938,-0.90621>,<0.58285,0.80652,0.09908>,<-0.43637,-0.4033,0.80432>,
            
    /*2*/<-0.14831,-0.40439,-0.90248>,<0.62713,0.771,0.11076>,<-0.49782,-0.35149,0.79286>,
            
    /*3*/<-0.13947,-0.39898,-0.90629>,<0.76202,0.6265,0.16379>,<-0.62787,-0.20212,0.75162>,
            
    /*4*/<-0.43921,0.85028,-0.29003>

    /* stem 0.3.4*/ 
    /*0*/<0.53212,-0.37294,0.7601>,
    /*1*/<0.84228,0.21416,-0.49466>,<-0.40847,0.67961,0.60932>,<-0.44605,-0.8852,-0.13214>,
            
    /*2*/<0.86659,0.18799,-0.46225>,<-0.36917,0.63313,0.68034>,<-0.5223,-0.8191,-0.23724>,
            
    /*3*/<0.90649,0.13279,-0.4008>,<-0.28688,0.5153,0.80757>,<-0.64365,-0.63728,-0.42379>,
            
    /*4*/<-0.28121,0.82346,-0.49278>

    /* stem 0.3.5*/ 
    /*0*/<-0.1374,-0.75194,0.64475>,
    /*1*/<0.54055,0.49479,0.68043>,<-0.98808,0.144,-0.05445>,<0.45067,-0.6216,-0.64072>,
            
    /*2*/<0.53955,0.48214,0.69024>,<-0.99514,0.09649,-0.01963>,<0.45688,-0.56318,-0.68854>,
            
    /*3*/<0.54414,0.43513,0.71734>,<-0.9972,-0.03973,0.06337>,<0.45105,-0.38013,-0.8075>,
            
    /*4*/<-0.16859,0.91664,-0.36243>

    /* stem 0.3.6*/ 
    /*0*/<0.09209,-0.99248,0.08059>,
    /*1*/<-0.60434,0.01624,0.79656>,<-0.38467,-0.10256,-0.91734>,<0.98692,0.10886,0.11895>,
            
    /*2*/<-0.60016,-0.00071,0.79988>,<-0.35603,-0.22069,-0.90804>,<0.96472,0.24617,0.09341>,
            
    /*3*/<-0.56644,-0.07807,0.8204>,<-0.32289,-0.36104,-0.87487>,<0.88471,0.46307,0.05336>,
            
    /*4*/<-0.52314,0.83101,-0.18909>

    /* stem 0.3.7*/ 
    /*0*/<0.56823,-0.78601,-0.24354>,
    /*1*/<-0.81537,-0.47921,-0.32486>,<0.52132,0.58032,-0.62566>,<0.2812,-0.08334,0.95602>,
            
    /*2*/<-0.81549,-0.479,-0.32486>,<0.52661,0.57309,-0.62789>,<0.27614,-0.07621,0.95809>,
            
    /*3*/<-0.81079,-0.48755,-0.32389>,<0.54466,0.545,-0.63744>,<0.2539,-0.03906,0.96644>,
            
    /*4*/<-0.56841,0.80827,0.15367>

    /* stem 0.3.8*/ 
    /*0*/<0.74725,-0.57801,0.32791>,
    /*1*/<0.23314,-0.22267,-0.94661>,<0.41213,0.79661,0.44224>,<-0.66203,-0.56097,0.49702>,
            
    /*2*/<0.26231,-0.25301,-0.93123>,<0.45422,0.75758,0.46878>,<-0.73927,-0.49267,0.45909>,
            
    /*3*/<0.28652,-0.26148,-0.9217>,<0.54706,0.64864,0.52915>,<-0.84414,-0.36764,0.3902>,
            
    /*4*/<-0.44805,0.81993,-0.35633>

    /* stem 0.3.9*/ 
    /*0*/<0.34621,-0.65934,0.66739>,
    /*1*/<0.91592,0.38791,-0.10304>,<-0.62718,0.37366,0.68339>,<-0.29645,-0.74688,-0.59522>,
            
    /*2*/<0.95276,0.30087,-0.04156>,<-0.6199,0.34505,0.70475>,<-0.33616,-0.63689,-0.69381>,
            
    /*3*/<0.97997,0.19677,0.0306>,<-0.58977,0.22961,0.77424>,<-0.40532,-0.4092,-0.81748>,
            
    /*4*/<-0.15771,0.95171,-0.26339>

    /* stem 0.3.10*/ 
    /*0*/<-0.33863,-0.86457,0.37128>,
    /*1*/<0.20984,0.3227,0.92295>,<-0.89598,0.18636,-0.4031>,<0.69363,-0.48991,-0.52807>,
            
    /*2*/<0.21502,0.33474,0.91745>,<-0.8933,0.1926,-0.40611>,<0.68632,-0.50859,-0.51991>,
            
    /*3*/<0.21727,0.35278,0.91013>,<-0.91176,0.1376,-0.387>,<0.69968,-0.47264,-0.53578>,
            
    /*4*/<0.22003,0.89177,-0.39539>

    /* stem 0.3.11*/ 
    /*0*/<0.0713,-0.97784,-0.19685>,
    /*1*/<-0.85723,-0.15396,0.49138>,<-0.01452,0.20348,-0.97897>,<0.87019,-0.02811,0.49191>,
            
    /*2*/<-0.85507,-0.17365,0.48857>,<-0.00952,0.16665,-0.98597>,<0.86468,0.02891,0.50149>,
            
    /*3*/<-0.85834,-0.16241,0.4867>,<0.00456,0.05361,-0.99855>,<0.85109,0.12996,0.50868>,
            
    /*4*/<-0.17543,0.98399,-0.03133>

    /* stem 0.3.12*/ 
    /*0*/<0.63069,-0.76872,-0.10632>,
    /*1*/<-0.59736,-0.38321,-0.70449>,<0.72553,0.63977,-0.25358>,<-0.14191,-0.23981,0.96039>,
            
    /*2*/<-0.61482,-0.35436,-0.70457>,<0.79204,0.5522,-0.26029>,<-0.18067,-0.17639,0.9676>,
            
    /*3*/<-0.62273,-0.34554,-0.70201>,<0.8929,0.37442,-0.25007>,<-0.27556,-0.00482,0.96127>,
            
    /*4*/<-0.32835,0.92178,-0.20618>

    /* stem 0.3.13*/ 
    /*0*/<0.60128,-0.65974,0.45078>,
    /*1*/<0.5857,-0.00909,-0.81048>,<0.16729,0.66233,0.7303>,<-0.76594,-0.63904,0.07047>,
            
    /*2*/<0.55487,0.0421,-0.83087>,<0.2567,0.55079,0.79419>,<-0.81845,-0.57267,0.04678>,
            
    /*3*/<0.54481,0.02651,-0.83814>,<0.35135,0.39552,0.8486>,<-0.91354,-0.4063,-0.01911>,
            
    /*4*/<-0.29134,0.92221,-0.25425>

    /* stem 0.3.14*/ 
    /*0*/<0.03535,-0.70905,0.70427>,
    /*1*/<0.85798,0.38761,0.33709>,<-0.87277,0.32672,0.36267>,<0.01403,-0.69923,-0.71476>,
            
    /*2*/<0.85473,0.40571,0.32378>,<-0.86753,0.24959,0.43022>,<0.00231,-0.64154,-0.76709>,
            
    /*3*/<0.85653,0.40876,0.31507>,<-0.83641,0.09467,0.53987>,<-0.03201,-0.48984,-0.87123>,
            
    /*4*/<-0.2591,0.88981,-0.37565>

    /* stem 0.3.15*/ 
    /*0*/<-0.15886,-0.97507,0.15494>,
    /*1*/<-0.20278,0.1928,0.96006>,<-0.73351,0.01876,-0.67942>,<0.93964,-0.19099,-0.2839>,
            
    /*2*/<-0.1914,0.26461,0.94517>,<-0.74256,-0.02413,-0.66935>,<0.9357,-0.21855,-0.27695>,
            
    /*3*/<-0.19834,0.23803,0.95079>,<-0.74133,-0.05305,-0.66904>,<0.94621,-0.16447,-0.27863>,
            
    /*4*/<0.05638,0.99072,-0.12365>

    /* stem 0.3.16*/ 
    /*0*/<0.28515,-0.94831,-0.13931>,
    /*1*/<-0.95196,-0.2923,0.09131>,<0.36275,0.24837,-0.89818>,<0.58325,0.06377,0.80979>,
            
    /*2*/<-0.97719,-0.19186,0.09104>,<0.38905,0.12244,-0.91304>,<0.58053,0.08747,0.80953>,
            
    /*3*/<-0.99188,-0.09313,0.08658>,<0.43259,-0.05451,-0.89994>,<0.5602,0.16833,0.81108>,
            
    /*4*/<-0.11774,0.97589,-0.18376>

    /* stem 0.3.17*/ 
    /*0*/<0.69638,-0.71329,0.07922>,
    /*1*/<-0.2283,-0.3155,-0.92105>,<0.69754,0.70495,0.1284>,<-0.48366,-0.37467,0.79101>,
            
    /*2*/<-0.26012,-0.26107,-0.92961>,<0.80502,0.57524,0.14508>,<-0.53722,-0.29163,0.79142>,
            
    /*3*/<-0.29544,-0.19988,-0.93422>,<0.91058,0.37766,0.16796>,<-0.62097,-0.15834,0.76767>,
            
    /*4*/<-0.2968,0.94849,-0.11083>

    /* stem 0.3.18*/ 
    /*0*/<0.49593,-0.56079,0.663>,
    /*1*/<0.84604,0.15858,-0.50899>,<-0.27195,0.63083,0.7267>,<-0.58423,-0.77794,-0.23128>,
            
    /*2*/<0.88343,0.09653,-0.45851>,<-0.25211,0.59022,0.76687>,<-0.65028,-0.68302,-0.33259>,
            
    /*3*/<0.93173,-0.02354,-0.3624>,<-0.21282,0.49964,0.83968>,<-0.73288,-0.46359,-0.49798>,
            
    /*4*/<-0.07063,0.88436,-0.46143>

    /* stem 0.3.19*/ 
    /*0*/<-0.19595,-0.84077,0.50469>,
    /*1*/<0.63784,0.28813,0.71424>,<-0.96292,0.26446,0.05329>,<0.32906,-0.53552,-0.77778>,
            
    /*2*/<0.63447,0.25409,0.72999>,<-0.97699,0.19665,0.08259>,<0.34554,-0.43536,-0.83131>,
            
    /*3*/<0.62649,0.15769,0.76331>,<-0.98351,0.13339,0.12217>,<0.36275,-0.27241,-0.89118>,
            
    /*4*/<0.10365,0.9755,-0.19404>

    /* stem 0.3.20*/ 
    /*0*/<-0.27068,-0.94699,-0.17304>,
    /*1*/<-0.57348,0.02136,0.81894>,<-0.37896,0.27675,-0.88306>,<0.95789,-0.27907,0.0676>,
            
    /*2*/<-0.57931,-0.01053,0.81504>,<-0.3884,0.2248,-0.89365>,<0.97749,-0.19493,0.08077>,
            
    /*3*/<-0.5866,-0.11006,0.80236>,<-0.40404,0.16879,-0.89903>,<0.99377,-0.03974,0.10409>,
            
    /*4*/<-0.04598,0.98007,0.19325>

    /* stem 0.3.21*/ 
    /*0*/<0.37432,-0.89136,-0.25566>,
    /*1*/<-0.89782,-0.26978,-0.34804>,<0.65413,0.45536,-0.60396>,<0.23625,-0.16785,0.95708>,
            
    /*2*/<-0.90145,-0.25952,-0.34646>,<0.67757,0.39975,-0.61732>,<0.22002,-0.12119,0.96794>,
            
    /*3*/<-0.91261,-0.2175,-0.34617>,<0.73352,0.23474,-0.63785>,<0.18395,0.00268,0.98293>,
            
    /*4*/<-0.18901,0.98108,-0.04196>

    /* stem 0.3.22*/ 
    /*0*/<0.65287,-0.72516,0.21888>,
    /*1*/<0.1682,-0.13429,-0.97656>,<0.54823,0.6583,0.51583>,<-0.72926,-0.50976,0.45643>,
            
    /*2*/<0.15792,-0.11853,-0.98031>,<0.6003,0.594,0.53554>,<-0.76838,-0.45862,0.44638>,
            
    /*3*/<0.12453,-0.06249,-0.99025>,<0.67235,0.48816,0.55646>,<-0.80512,-0.40823,0.43027>,
            
    /*4*/<-0.49023,0.86826,-0.07609>

    /* stem 0.3.23*/ 
    /*0*/<0.20998,-0.65581,0.72513>,
    /*1*/<0.97158,0.21737,-0.09367>,<-0.57114,0.52485,0.63114>,<-0.40452,-0.7295,-0.55154>,
            
    /*2*/<0.96218,0.24803,-0.11268>,<-0.53894,0.40312,0.73962>,<-0.44653,-0.63956,-0.62576>,
            
    /*3*/<0.94932,0.28123,-0.14035>,<-0.46726,0.22079,0.85611>,<-0.4918,-0.48674,-0.72195>,
            
    /*4*/<-0.31133,0.89656,-0.31505>

    /* stem 0.3.24*/ 
    /*0*/<-0.39561,-0.85794,0.32776>,
    /*1*/<0.26778,0.24042,0.933>,<-0.89156,0.28369,-0.35306>,<0.63137,-0.50764,-0.58624>,
            
    /*2*/<0.26313,0.22771,0.9375>,<-0.91003,0.23859,-0.33901>,<0.6541,-0.45039,-0.6077>,
            
    /*3*/<0.24573,0.16442,0.95529>,<-0.92827,0.19041,-0.31947>,<0.69061,-0.33758,-0.63961>,
            
    /*4*/<0.24125,0.95652,-0.16394>

    /* stem 0.3.25*/ 
    /*0*/<-0.10592,-0.92225,-0.3718>,
    /*1*/<-0.85294,-0.1016,0.51203>,<-0.01419,0.38117,-0.9244>,<0.86914,-0.26205,0.41943>,
            
    /*2*/<-0.85106,-0.06569,0.52094>,<-0.02266,0.28933,-0.95696>,<0.87706,-0.20512,0.43439>,
            
    /*3*/<-0.84842,-0.0194,0.52897>,<-0.03029,0.12705,-0.99143>,<0.88254,-0.08904,0.46174>,
            
    /*4*/<0.01334,0.99859,0.05141>

    /* stem 0.3.26*/ 
    /*0*/<0.50195,-0.85682,-0.11788>,
    /*1*/<-0.6519,-0.27881,-0.70519>,<0.81684,0.51919,-0.25142>,<-0.17277,-0.22701,0.95845>,
            
    /*2*/<-0.64618,-0.29024,-0.70584>,<0.84724,0.46656,-0.25398>,<-0.20659,-0.16159,0.96499>,
            
    /*3*/<-0.63935,-0.30229,-0.707>,<0.91806,0.31053,-0.24645>,<-0.27627,0.01004,0.96103>,
            
    /*4*/<-0.24737,0.94991,-0.19097>

    /* stem 0.3.27*/ 
    /*0*/<0.53332,-0.75562,0.38027>,
    /*1*/<0.55995,-0.0178,-0.82834>,<0.26561,0.57919,0.77071>,<-0.83022,-0.55478,0.05431>,
            
    /*2*/<0.54272,0.00913,-0.83986>,<0.29217,0.54168,0.78817>,<-0.83828,-0.54297,0.0497>,
            
    /*3*/<0.54196,0.00331,-0.8404>,<0.33404,0.46847,0.8179>,<-0.88455,-0.46603,0.01997>,
            
    /*4*/<-0.38262,0.87637,-0.29252>

    /* stem 0.3.28*/ 
    /*0*/<-0.00211,-0.76968,0.63843>,
    /*1*/<0.90192,0.27495,0.33307>,<-0.82499,0.36283,0.4333>,<-0.07693,-0.63573,-0.76806>,
            
    /*2*/<0.90493,0.22932,0.35849>,<-0.83011,0.29149,0.47533>,<-0.07957,-0.52264,-0.84883>,
            
    /*3*/<0.906,0.14542,0.39752>,<-0.82173,0.19753,0.53454>,<-0.08381,-0.34125,-0.93623>,
            
    /*4*/<0.01394,0.95949,-0.2814>

    /* stem 0.4*/ 
    /*0*/<-0.21131,-0.86603,0.45315>,
    /*1*/<0.90846,0.00902,0.41788>,<-0.06582,0.48452,0.8723>,<-0.94609,0.3029,0.11471>,
            <-0.51586,-0.28486,-0.80793>,<0.63032,-0.46648,-0.62056>,
    /*2*/<0.90838,0.00913,0.41804>,<-0.07685,0.43599,0.89667>,<-0.95332,0.27284,0.12934>,
            <-0.50922,-0.25449,-0.82215>,<0.64123,-0.4175,-0.64383>,
    /*3*/<0.90792,0.00966,0.41903>,<-0.09583,0.3349,0.93737>,<-0.96523,0.21061,0.15486>,
            <-0.49825,-0.19127,-0.84567>,<0.65927,-0.31551,-0.68251>,
    /*4*/<0.12121,0.95799,-0.25993>

    /* stem 0.4.0*/ 
    /*0*/<-0.768,-0.60609,0.20698>,
    /*1*/<-0.14672,0.49192,0.85819>,<-0.45624,0.30565,-0.83572>,<0.62102,-0.78332,-0.02734>,
            
    /*2*/<-0.16753,0.47143,0.86585>,<-0.49975,0.26372,-0.82504>,<0.68841,-0.72367,-0.04887>,
            
    /*3*/<-0.21337,0.4159,0.88402>,<-0.56229,0.20339,-0.80154>,<0.79296,-0.60301,-0.08713>,
            
    /*4*/<0.52471,0.82657,-0.20361>

    /* stem 0.4.1*/ 
    /*0*/<-0.21079,-0.96407,-0.16167>,
    /*1*/<-0.97336,0.22669,-0.03452>,<0.5497,0.0279,-0.8349>,<0.42859,-0.23206,0.87319>,
            
    /*2*/<-0.9779,0.20566,-0.03768>,<0.54948,0.02741,-0.83506>,<0.43268,-0.21044,0.87665>,
            
    /*3*/<-0.97816,0.20427,-0.03856>,<0.53675,-0.03505,-0.84301>,<0.44837,-0.14709,0.88166>,
            
    /*4*/<0.21629,0.97624,0.01281>

    /* stem 0.4.2*/ 
    /*0*/<0.21706,-0.9166,0.33576>,
    /*1*/<-0.2876,-0.38145,-0.87851>,<0.94955,0.2829,0.13535>,<-0.667,0.11988,0.73535>,
            
    /*2*/<-0.28652,-0.36349,-0.88644>,<0.96915,0.15119,0.19466>,<-0.67478,0.2378,0.69866>,
            
    /*3*/<-0.28079,-0.33574,-0.89913>,<0.96434,-0.02293,0.26366>,<-0.67948,0.37961,0.62786>,
            
    /*4*/<0.18304,0.90207,-0.39084>

    /* stem 0.4.3*/ 
    /*0*/<0.01527,-0.65457,0.75585>,
    /*1*/<0.84625,-0.38894,-0.36413>,<0.03771,0.7608,0.64788>,<-0.88431,-0.35671,-0.30125>,
            
    /*2*/<0.84588,-0.3973,-0.35586>,<0.03326,0.7135,0.69987>,<-0.88404,-0.29845,-0.35972>,
            
    /*3*/<0.85615,-0.33551,-0.39299>,<0.02704,0.58474,0.81077>,<-0.87566,-0.22817,-0.42563>,
            
    /*4*/<0.02381,0.868,-0.49599>

    /* stem 0.4.4*/ 
    /*0*/<-0.55528,-0.49883,0.66546>,
    /*1*/<0.67096,0.21513,0.7096>,<-0.75962,0.62609,-0.17606>,<0.10144,-0.82974,-0.54886>,
            
    /*2*/<0.65917,0.20167,0.72445>,<-0.79074,0.5953,-0.14266>,<0.14293,-0.78682,-0.60041>,
            
    /*3*/<0.62359,0.15579,0.76607>,<-0.83539,0.54232,-0.08949>,<0.22551,-0.68565,-0.69212>,
            
    /*4*/<0.4822,0.73943,-0.46981>

    /* stem 0.4.5*/ 
    /*0*/<-0.58241,-0.80526,0.11117>,
    /*1*/<-0.54198,0.49519,0.679>,<-0.24355,0.0519,-0.9685>,<0.79884,-0.52869,0.28696>,
            
    /*2*/<-0.55127,0.48069,0.68194>,<-0.26974,0.00966,-0.96288>,<0.83639,-0.47317,0.2767>,
            
    /*3*/<-0.57413,0.43351,0.69458>,<-0.32087,-0.08209,-0.94356>,<0.91088,-0.33292,0.24385>,
            
    /*4*/<0.30844,0.91687,-0.25341>

    /* stem 0.4.6*/ 
    /*0*/<-0.05866,-0.99223,0.10976>,
    /*1*/<-0.91209,0.01624,-0.40968>,<0.8072,-0.10436,-0.58098>,<0.10622,0.11067,0.98816>,
            
    /*2*/<-0.91383,-0.007,-0.40604>,<0.80653,-0.12459,-0.57792>,<0.10855,0.15435,0.98204>,
            
    /*3*/<-0.91337,-0.01069,-0.40699>,<0.79888,-0.22554,-0.55761>,<0.12199,0.25679,0.95874>,
            
    /*4*/<0.14843,0.9338,-0.32554>

    /* stem 0.4.7*/ 
    /*0*/<0.4131,-0.76474,0.49448>,
    /*1*/<0.13276,-0.47939,-0.8675>,<0.70879,0.61552,0.3446>,<-0.85086,-0.1189,0.51176>,
            
    /*2*/<0.10207,-0.39226,-0.91417>,<0.76105,0.5124,0.39781>,<-0.85762,-0.09936,0.50459>,
            
    /*3*/<0.05997,-0.22587,-0.97231>,<0.81971,0.30335,0.48585>,<-0.87467,-0.05608,0.48147>,
            
    /*4*/<-0.12618,0.97876,-0.16159>

    /* stem 0.4.8*/ 
    /*0*/<-0.1604,-0.61957,0.76838>,
    /*1*/<0.97486,-0.22236,0.01448>,<-0.34544,0.76884,0.5381>,<-0.62582,-0.53259,-0.56982>,
            
    /*2*/<0.97682,-0.21391,0.00766>,<-0.36501,0.70515,0.6079>,<-0.61591,-0.47335,-0.62976>,
            
    /*3*/<0.98798,-0.15133,-0.03162>,<-0.39133,0.55929,0.73079>,<-0.59441,-0.38681,-0.70502>,
            
    /*4*/<0.06054,0.86883,-0.49139>

    /* stem 0.4.9*/ 
    /*0*/<-0.74973,-0.47004,0.4658>,
    /*1*/<0.30775,0.3865,0.86943>,<-0.65536,0.50063,-0.56557>,<0.3643,-0.87667,-0.31423>,
            
    /*2*/<0.287,0.36729,0.88472>,<-0.71932,0.44874,-0.53029>,<0.4502,-0.8107,-0.37427>,
            
    /*3*/<0.27624,0.36319,0.88982>,<-0.81266,0.36194,-0.4567>,<0.54673,-0.70964,-0.4444>,
            
    /*4*/<0.50694,0.72354,-0.46851>

    /* stem 0.4.10*/ 
    /*0*/<-0.36737,-0.92874,-0.04983>,
    /*1*/<-0.85261,0.32316,0.41063>,<0.11404,0.01612,-0.99335>,<0.7467,-0.31875,0.58382>,
            
    /*2*/<-0.85564,0.31506,0.41063>,<0.09839,-0.03026,-0.99469>,<0.76751,-0.26492,0.58373>,
            
    /*3*/<-0.85114,0.33791,0.40172>,<0.04449,-0.20928,-0.97684>,<0.82051,-0.11573,0.5598>,
            
    /*4*/<0.23786,0.91325,-0.33076>

    /* stem 0.4.11*/ 
    /*0*/<0.24906,-0.96837,-0.01503>,
    /*1*/<-0.67192,-0.15402,-0.72443>,<0.93876,0.25262,-0.23433>,<-0.2723,-0.07738,0.9591>,
            
    /*2*/<-0.6848,-0.10294,-0.72142>,<0.9417,0.24057,-0.23521>,<-0.26409,-0.11668,0.95742>,
            
    /*3*/<-0.69216,-0.04179,-0.72054>,<0.95794,0.16548,-0.23444>,<-0.26604,-0.10206,0.95854>,
            
    /*4*/<-0.09048,0.99541,0.03115>

    /* stem 0.4.12*/ 
    /*0*/<0.37371,-0.67411,0.63711>,
    /*1*/<0.55114,-0.38391,-0.74085>,<0.36471,0.74314,0.56101>,<-0.92396,-0.34458,0.166>,
            
    /*2*/<0.54733,-0.37233,-0.74953>,<0.39192,0.68418,0.61507>,<-0.94763,-0.29327,0.12648>,
            
    /*3*/<0.53355,-0.30163,-0.79015>,<0.44477,0.52883,0.72285>,<-0.97648,-0.20609,0.06332>,
            
    /*4*/<-0.17839,0.90391,-0.38876>

    /* stem 0.4.13*/ 
    /*0*/<-0.35577,-0.45651,0.81549>,
    /*1*/<0.92182,-0.01055,0.38746>,<-0.60282,0.78059,0.1652>,<-0.31135,-0.76022,-0.57019>,
            
    /*2*/<0.91747,-0.0182,0.39739>,<-0.64421,0.72582,0.24121>,<-0.27586,-0.69726,-0.66162>,
            
    /*3*/<0.91043,-0.02779,0.41273>,<-0.70573,0.60226,0.37314>,<-0.20568,-0.55917,-0.80313>,
            
    /*4*/<0.27564,0.80655,-0.52297>

    /* stem 0.4.14*/ 
    /*0*/<-0.67333,-0.71308,0.19532>,
    /*1*/<-0.13547,0.38765,0.9118>,<-0.55372,0.32256,-0.76769>,<0.70357,-0.69498,-0.14828>,
            
    /*2*/<-0.14038,0.38157,0.91362>,<-0.60243,0.26148,-0.75413>,<0.75787,-0.62983,-0.17012>,
            
    /*3*/<-0.15157,0.36115,0.92011>,<-0.67672,0.15518,-0.7197>,<0.84041,-0.50008,-0.20885>,
            
    /*4*/<0.38598,0.8855,-0.25865>

    /* stem 0.4.15*/ 
    /*0*/<-0.18571,-0.96248,-0.19787>,
    /*1*/<-0.98107,0.19271,0.01893>,<0.50974,0.08495,-0.85612>,<0.47525,-0.25737,0.84137>,
            
    /*2*/<-0.98994,0.14118,0.009>,<0.51168,0.10369,-0.8529>,<0.47913,-0.22449,0.84855>,
            
    /*3*/<-0.99312,0.1166,0.0106>,<0.5101,0.12871,-0.85043>,<0.485,-0.22507,0.84505>,
            
    /*4*/<0.13771,0.96412,0.22696>

    /* stem 0.4.16*/ 
    /*0*/<0.46402,-0.87556,0.13445>,
    /*1*/<-0.30496,-0.2928,-0.90624>,<0.86887,0.48424,0.10281>,<-0.57364,-0.17309,0.80061>,
            
    /*2*/<-0.30913,-0.28008,-0.90884>,<0.90628,0.40566,0.11875>,<-0.60139,-0.10477,0.79205>,
            
    /*3*/<-0.31661,-0.24898,-0.9153>,<0.94796,0.28597,0.13998>,<-0.63551,-0.01702,0.77191>,
            
    /*4*/<-0.21383,0.96115,-0.17456>

    /* stem 0.4.17*/ 
    /*0*/<0.08003,-0.71262,0.69697>,
    /*1*/<0.84608,-0.3155,-0.42965>,<0.03172,0.70561,0.70789>,<-0.87946,-0.37533,-0.29269>,
            
    /*2*/<0.84506,-0.30709,-0.43769>,<0.03245,0.69972,0.71368>,<-0.87921,-0.37775,-0.29033>,
            
    /*3*/<0.84195,-0.28771,-0.45644>,<0.04009,0.6418,0.76582>,<-0.88576,-0.33651,-0.31968>,
            
    /*4*/<-0.04666,0.81358,-0.57958>

    /* stem 0.4.18*/ 
    /*0*/<-0.5017,-0.61134,0.61201>,
    /*1*/<0.68605,0.15893,0.70998>,<-0.79801,0.5989,-0.0671>,<0.12225,-0.7453,-0.65543>,
            
    /*2*/<0.70884,0.20016,0.67638>,<-0.84864,0.52897,0.00103>,<0.14023,-0.71189,-0.68814>,
            
    /*3*/<0.73419,0.24133,0.63461>,<-0.90088,0.42412,0.09238>,<0.17123,-0.65054,-0.73992>,
            
    /*4*/<0.25168,0.77282,-0.58258>

    /* stem 0.4.19*/ 
    /*0*/<-0.59034,-0.79624,-0.13227>,
    /*1*/<-0.5521,0.28781,0.78253>,<-0.22462,0.32746,-0.91778>,<0.78866,-0.59916,0.13792>,
            
    /*2*/<-0.59376,0.22875,0.77144>,<-0.20813,0.35468,-0.91153>,<0.81061,-0.56684,0.14695>,
            
    /*3*/<-0.61568,0.19816,0.76267>,<-0.23355,0.30831,-0.92217>,<0.85811,-0.48878,0.1573>,
            
    /*4*/<0.44073,0.8934,0.08713>

    /* stem 0.4.20*/ 
    /*0*/<0.06958,-0.97522,-0.21>,
    /*1*/<-0.9267,0.02153,-0.37519>,<0.78344,0.19016,-0.59166>,<0.14187,-0.19212,0.97106>,
            
    /*2*/<-0.92663,0.02352,-0.37525>,<0.78804,0.13306,-0.60108>,<0.14074,-0.13691,0.98053>,
            
    /*3*/<-0.92538,0.05101,-0.37558>,<0.78917,0.00895,-0.61411>,<0.13984,-0.0405,0.98935>,
            
    /*4*/<0.07745,0.99698,-0.00506>

    /* stem 0.4.21*/ 
    /*0*/<0.29501,-0.90529,0.30565>,
    /*1*/<0.13742,-0.26972,-0.95308>,<0.74699,0.42369,0.51235>,<-0.89024,-0.13606,0.43469>,
            
    /*2*/<0.12659,-0.21338,-0.96873>,<0.77372,0.33378,0.53846>,<-0.8982,-0.10105,0.42782>,
            
    /*3*/<0.11894,-0.16866,-0.97847>,<0.79215,0.2125,0.57213>,<-0.91452,-0.02454,0.40381>,
            
    /*4*/<-0.07236,0.97761,-0.19761>

    /* stem 0.4.22*/ 
    /*0*/<-0.05607,-0.6714,0.73897>,
    /*1*/<0.9893,-0.13465,-0.05613>,<-0.37529,0.70431,0.60258>,<-0.61291,-0.55649,-0.56095>,
            
    /*2*/<0.99101,-0.08763,-0.10112>,<-0.37517,0.65793,0.65297>,<-0.61331,-0.55397,-0.56301>,
            
    /*3*/<0.9893,-0.06072,-0.13264>,<-0.37658,0.56915,0.73093>,<-0.61711,-0.49418,-0.61234>,
            
    /*4*/<0.00597,0.82632,-0.56317>

    /* stem 0.4.23*/ 
    /*0*/<-0.6176,-0.69744,0.36354>,
    /*1*/<0.30954,0.21763,0.92565>,<-0.7764,0.49047,-0.39578>,<0.47881,-0.69461,-0.5369>,
            
    /*2*/<0.31001,0.22019,0.92488>,<-0.85299,0.38206,-0.35558>,<0.5463,-0.5913,-0.59323>,
            
    /*3*/<0.31122,0.21981,0.92457>,<-0.93232,0.22571,-0.28256>,<0.62628,-0.4293,-0.65075>,
            
    /*4*/<0.24839,0.92317,-0.29337>

    /* stem 0.4.24*/ 
    /*0*/<-0.41075,-0.85458,-0.31776>,
    /*1*/<-0.84883,0.2404,0.47084>,<0.14606,0.28908,-0.9461>,<0.71067,-0.51307,0.48136>,
            
    /*2*/<-0.87313,0.18087,0.4527>,<0.143,0.28102,-0.94899>,<0.7372,-0.44651,0.50712>,
            
    /*3*/<-0.90255,0.08131,0.42283>,<0.13459,0.28146,-0.95009>,<0.77155,-0.3454,0.53424>,
            
    /*4*/<0.17345,0.9371,0.30292>

    /* stem 0.4.25*/ 
    /*0*/<0.2873,-0.94845,-0.1338>,
    /*1*/<-0.69043,-0.10153,-0.71624>,<0.91907,0.31784,-0.23299>,<-0.23402,-0.19859,0.95174>,
            
    /*2*/<-0.69584,-0.08206,-0.71349>,<0.92413,0.30075,-0.23567>,<-0.23332,-0.20083,0.95144>,
            
    /*3*/<-0.69998,-0.06011,-0.71163>,<0.94168,0.23406,-0.24178>,<-0.24377,-0.15566,0.95726>,
            
    /*4*/<-0.16497,0.98358,0.07323>

    /* stem 0.4.26*/ 
    /*0*/<0.37103,-0.76426,0.52748>,
    /*1*/<0.53986,-0.27958,-0.79397>,<0.3806,0.64706,0.66065>,<-0.92584,-0.35641,0.12568>,
            
    /*2*/<0.54812,-0.30812,-0.77758>,<0.40009,0.58578,0.70483>,<-0.96185,-0.26482,0.06866>,
            
    /*3*/<0.55815,-0.32484,-0.76351>,<0.43152,0.46165,0.77503>,<-0.99232,-0.12285,-0.01462>,
            
    /*4*/<-0.05466,0.90731,-0.41689>

    /* stem 0.4.27*/ 
    /*0*/<-0.25301,-0.74941,0.61186>,
    /*1*/<0.933,-0.01806,0.35944>,<-0.68922,0.58508,0.42738>,<-0.24181,-0.56119,-0.79158>,
            
    /*2*/<0.93728,-0.0005,0.34859>,<-0.71052,0.51826,0.476>,<-0.23087,-0.5105,-0.82831>,
            
    /*3*/<0.93936,0.00336,0.3429>,<-0.73988,0.38615,0.55088>,<-0.20317,-0.38308,-0.90109>,
            
    /*4*/<0.13802,0.93182,-0.33564>

    /* stem 0.4.28*/ 
    /*0*/<-0.51391,-0.83968,0.1756>,
    /*1*/<-0.12183,0.27487,0.95373>,<-0.67387,0.26941,-0.68798>,<0.7968,-0.54247,-0.26613>,
            
    /*2*/<-0.13319,0.25428,0.95792>,<-0.68023,0.258,-0.68609>,<0.81544,-0.51089,-0.27213>,
            
    /*3*/<-0.13495,0.25325,0.95794>,<-0.70552,0.21133,-0.67644>,<0.84041,-0.46244,-0.28259>,
            
    /*4*/<0.40242,0.89293,-0.20182>

    /* stem 0.5*/ 
    /*0*/<-0.48907,-0.86603,-0.10396>,
    /*1*/<-0.20282,0.009,0.97918>,<-0.86476,0.48451,0.13209>,<-0.32461,0.30288,-0.89604>,
            <0.67117,-0.28487,-0.68439>,<0.74644,-0.4665,0.47456>,
    /*2*/<-0.20299,0.00912,0.97914>,<-0.89098,0.43597,0.12682>,<-0.34049,0.27283,-0.8998>,
            <0.68652,-0.25451,-0.68111>,<0.77157,-0.41752,0.47997>,
    /*3*/<-0.20406,0.00964,0.97891>,<-0.93491,0.33488,0.11748>,<-0.36803,0.21059,-0.90565>,
            <0.71191,-0.19128,-0.67572>,<0.81331,-0.31553,0.48884>,
    /*4*/<0.28054,0.95799,0.05963>

    /* stem 0.5.0*/ 
    /*0*/<-0.37994,-0.6171,-0.68908>,
    /*1*/<-0.86916,0.492,0.04998>,<0.70593,0.29637,-0.64329>,<0.17215,-0.77389,0.60948>,
            
    /*2*/<-0.89882,0.4383,0.00493>,<0.69464,0.2685,-0.66737>,<0.21148,-0.69566,0.68653>,
            
    /*3*/<-0.92818,0.36876,-0.04999>,<0.66011,0.19618,-0.7251>,<0.27869,-0.54806,0.78865>,
            
    /*4*/<0.2943,0.86381,0.40893>

    /* stem 0.5.1*/ 
    /*0*/<0.17218,-0.95253,-0.25107>,
    /*1*/<-0.18581,0.2266,-0.9561>,<0.92887,0.0808,0.36149>,<-0.74708,-0.28513,0.60048>,
            
    /*2*/<-0.17275,0.15651,-0.97245>,<0.92289,0.11684,0.36691>,<-0.75491,-0.25084,0.60596>,
            
    /*3*/<-0.16273,0.06634,-0.98444>,<0.9163,0.16004,0.36712>,<-0.75832,-0.20369,0.61924>,
            
    /*4*/<-0.19795,0.97758,0.07183>

    /* stem 0.5.2*/ 
    /*0*/<-0.30396,-0.92003,0.2473>,
    /*1*/<0.7915,-0.38143,-0.47754>,<0.06996,0.24522,0.96694>,<-0.85439,0.1576,-0.49515>,
            
    /*2*/<0.80212,-0.34741,-0.4857>,<0.06307,0.22151,0.97312>,<-0.85761,0.1473,-0.49275>,
            
    /*3*/<0.81613,-0.30038,-0.49366>,<0.05452,0.20888,0.97642>,<-0.86553,0.11356,-0.48781>,
            
    /*4*/<0.21169,0.95257,-0.21862>

    /* stem 0.5.3*/ 
    /*0*/<-0.72865,-0.66132,0.17815>,
    /*1*/<0.54511,-0.3889,0.7427>,<-0.6295,0.75485,0.1842>,<0.10121,-0.35068,-0.93101>,
            
    /*2*/<0.50156,-0.43841,0.74581>,<-0.68083,0.70876,0.18475>,<0.20076,-0.25513,-0.94584>,
            
    /*3*/<0.42415,-0.51243,0.74667>,<-0.7552,0.629,0.18451>,<0.34794,-0.09968,-0.9322>,
            
    /*4*/<0.61932,0.75142,0.22764>

    /* stem 0.5.4*/ 
    /*0*/<-0.79141,-0.44688,-0.4171>,
    /*1*/<-0.54036,0.21472,0.81357>,<0.04196,0.65056,-0.75829>,<0.51656,-0.85503,-0.04571>,
            
    /*2*/<-0.60679,0.15429,0.77974>,<-0.00566,0.60577,-0.79562>,<0.6477,-0.7612,0.03248>,
            
    /*3*/<-0.65343,0.12968,0.7458>,<-0.08886,0.53619,-0.83941>,<0.75392,-0.64895,0.10232>,
            
    /*4*/<0.59076,0.72765,0.34861>

    /* stem 0.5.5*/ 
    /*0*/<-0.14971,-0.7449,-0.65017>,
    /*1*/<-0.7842,0.49472,-0.37454>,<0.91398,0.15412,-0.37535>,<-0.12637,-0.63187,0.76471>,
            
    /*2*/<-0.78183,0.50245,-0.36918>,<0.90363,0.10363,-0.41559>,<-0.11407,-0.59019,0.79916>,
            
    /*3*/<-0.77077,0.53239,-0.34997>,<0.87065,-0.00007,-0.4919>,<-0.09007,-0.51511,0.85238>,
            
    /*4*/<0.35881,0.79895,0.48264>

    /* stem 0.5.6*/ 
    /*0*/<-0.08434,-0.99611,-0.02546>,
    /*1*/<0.19373,0.01625,-0.98092>,<0.75065,-0.07276,0.65668>,<-0.94247,0.07908,0.32482>,
            
    /*2*/<0.18125,-0.04471,-0.98242>,<0.74383,-0.11058,0.65915>,<-0.92891,0.18033,0.32342>,
            
    /*3*/<0.17019,-0.08844,-0.98143>,<0.74096,-0.16023,0.65215>,<-0.90522,0.27025,0.32792>,
            
    /*4*/<0.25947,0.96522,-0.03198>

    /* stem 0.5.7*/ 
    /*0*/<-0.44116,-0.8351,0.32862>,
    /*1*/<0.87553,-0.47886,-0.06439>,<-0.24994,0.47341,0.84464>,<-0.61564,0.02427,-0.78765>,
            
    /*2*/<0.88674,-0.45698,-0.06977>,<-0.28238,0.41249,0.86609>,<-0.59706,0.06529,-0.79953>,
            
    /*3*/<0.89128,-0.44768,-0.0721>,<-0.34481,0.29608,0.89076>,<-0.54083,0.17392,-0.82295>,
            
    /*4*/<0.4663,0.88395,-0.03471>

    /* stem 0.5.8*/ 
    /*0*/<-0.78418,-0.62032,0.01626>,
    /*1*/<0.20516,-0.22237,0.95313>,<-0.60272,0.76829,-0.21552>,<0.41509,-0.53206,-0.73798>,
            
    /*2*/<0.16791,-0.2578,0.9515>,<-0.63054,0.74469,-0.21876>,<0.48347,-0.47511,-0.73521>,
            
    /*3*/<0.13611,-0.27716,0.95113>,<-0.7142,0.66033,-0.23214>,<0.5899,-0.36428,-0.72063>,
            
    /*4*/<0.57362,0.80638,0.14393>

    /* stem 0.5.9*/ 
    /*0*/<-0.61306,-0.61142,-0.50033>,
    /*1*/<-0.77799,0.38755,0.49451>,<0.3019,0.41268,-0.85939>,<0.48974,-0.78661,0.37602>,
            
    /*2*/<-0.76515,0.40123,0.50356>,<0.27195,0.38233,-0.8831>,<0.50762,-0.76918,0.38818>,
            
    /*3*/<-0.82355,0.31971,0.46855>,<0.23655,0.34257,-0.90923>,<0.59745,-0.65242,0.46626>,
            
    /*4*/<0.38741,0.83326,0.39445>

    /* stem 0.5.10*/ 
    /*0*/<-0.03236,-0.92832,-0.37037>,
    /*1*/<-0.59192,0.32313,-0.73839>,<0.99359,0.01782,-0.11165>,<-0.40096,-0.32051,0.8582>,
            
    /*2*/<-0.60124,0.26269,-0.75466>,<0.99101,-0.04582,-0.12568>,<-0.39263,-0.19542,0.8987>,
            
    /*3*/<-0.60954,0.19084,-0.76944>,<0.98346,-0.09631,-0.15341>,<-0.37111,-0.07325,0.9257>,
            
    /*4*/<0.11288,0.9847,0.13272>

    /* stem 0.5.11*/ 
    /*0*/<0.14348,-0.94779,0.28478>,
    /*1*/<0.55419,-0.15419,-0.81799>,<0.43078,0.32578,0.8416>,<-0.9881,-0.15086,-0.02985>,
            
    /*2*/<0.56354,-0.21298,-0.79816>,<0.42671,0.36823,0.82603>,<-0.99013,-0.13532,-0.03651>,
            
    /*3*/<0.56466,-0.24253,-0.78888>,<0.43193,0.31039,0.84681>,<-0.99736,-0.04597,-0.05618>,
            
    /*4*/<0.03534,0.96993,-0.24079>

    /* stem 0.5.12*/ 
    /*0*/<-0.53641,-0.67757,0.50316>,
    /*1*/<0.84584,-0.38389,0.37039>,<-0.46716,0.73993,0.48401>,<-0.36704,-0.34134,-0.86532>,
            
    /*2*/<0.82034,-0.42016,0.38795>,<-0.51192,0.68988,0.51187>,<-0.30023,-0.25359,-0.91954>,
            
    /*3*/<0.80574,-0.43054,0.40672>,<-0.59744,0.57231,0.56172>,<-0.20069,-0.1223,-0.97199>,
            
    /*4*/<0.50953,0.84466,-0.16407>

    /* stem 0.5.13*/ 
    /*0*/<-0.69234,-0.70901,-0.13407>,
    /*1*/<-0.17148,-0.00875,0.98515>,<-0.51275,0.62257,-0.59118>,<0.69909,-0.5986,-0.39109>,
            
    /*2*/<-0.15617,0.00783,0.9877>,<-0.53112,0.6039,-0.59433>,<0.70152,-0.59589,-0.39087>,
            
    /*3*/<-0.1104,0.07375,0.99115>,<-0.6361,0.47773,-0.60593>,<0.74922,-0.53163,-0.39503>,
            
    /*4*/<0.49035,0.86929,-0.06235>

    /* stem 0.5.14*/ 
    /*0*/<-0.36806,-0.80175,-0.47088>,
    /*1*/<-0.91873,0.38825,0.07209>,<0.57154,0.21202,-0.79271>,<0.35501,-0.58324,0.73062>,
            
    /*2*/<-0.94033,0.33613,0.05287>,<0.55354,0.15146,-0.81893>,<0.40069,-0.47282,0.78478>,
            
    /*3*/<-0.94851,0.31429,0.0394>,<0.50455,0.04528,-0.8622>,<0.45076,-0.34011,0.82531>,
            
    /*4*/<0.34201,0.92267,0.17805>

    /* stem 0.5.15*/ 
    /*0*/<0.14349,-0.964,-0.22388>,
    /*1*/<-0.23908,0.19272,-0.95168>,<0.9499,0.07842,0.30255>,<-0.71384,-0.25081,0.65385>,
            
    /*2*/<-0.23867,0.19109,-0.95211>,<0.95599,0.02485,0.29235>,<-0.71863,-0.19604,0.66719>,
            
    /*3*/<-0.23629,0.20808,-0.94914>,<0.95899,-0.09434,0.26729>,<-0.7193,-0.09415,0.68829>,
            
    /*4*/<0.11775,0.97334,0.19685>

    /* stem 0.5.16*/ 
    /*0*/<-0.03853,-0.88317,0.46746>,
    /*1*/<0.81449,-0.29278,-0.50088>,<0.09478,0.46861,0.8783>,<-0.90847,-0.15742,-0.38717>,
            
    /*2*/<0.81448,-0.28861,-0.50332>,<0.09494,0.4839,0.86996>,<-0.90933,-0.17698,-0.37656>,
            
    /*3*/<0.81173,-0.30779,-0.49635>,<0.09341,0.458,0.88403>,<-0.90796,-0.13126,-0.39797>,
            
    /*4*/<0.12501,0.8997,-0.41822>

    /* stem 0.5.17*/ 
    /*0*/<-0.74204,-0.55964,0.36903>,
    /*1*/<0.60952,-0.31657,0.72683>,<-0.54817,0.82594,0.13161>,<-0.04599,-0.4978,-0.86607>,
            
    /*2*/<0.63776,-0.28534,0.71543>,<-0.64597,0.74288,0.17568>,<0.00958,-0.43719,-0.89932>,
            
    /*3*/<0.64837,-0.28552,0.70576>,<-0.79836,0.55766,0.22722>,<0.15705,-0.25126,-0.95509>,
            
    /*4*/<0.46536,0.8851,-0.00614>

    /* stem 0.5.18*/ 
    /*0*/<-0.77047,-0.4836,-0.41535>,
    /*1*/<-0.53705,0.15806,0.82861>,<-0.01376,0.67199,-0.74044>,<0.56658,-0.82014,-0.07967>,
            
    /*2*/<-0.54911,0.14757,0.82262>,<-0.08556,0.6119,-0.78629>,<0.65868,-0.75152,-0.03694>,
            
    /*3*/<-0.61147,0.07208,0.78798>,<-0.16783,0.54529,-0.82128>,<0.79319,-0.60715,0.04702>,
            
    /*4*/<0.46697,0.78432,0.40839>

    /* stem 0.5.19*/ 
    /*0*/<-0.1312,-0.91287,-0.3866>,
    /*1*/<-0.88581,0.28858,-0.3634>,<0.82814,0.12021,-0.54748>,<0.06032,-0.39036,0.91868>,
            
    /*2*/<-0.89417,0.21651,-0.3919>,<0.82966,0.15086,-0.53749>,<0.06156,-0.34859,0.93525>,
            
    /*3*/<-0.90124,0.10958,-0.41923>,<0.82936,0.1337,-0.54248>,<0.07359,-0.22421,0.97176>,
            
    /*4*/<0.00683,0.9889,0.14844>

    /* stem 0.5.20*/ 
    /*0*/<0.14887,-0.98882,0.00888>,
    /*1*/<0.15759,0.02162,-0.98727>,<0.76499,0.1276,0.63128>,<-0.92556,-0.12938,0.35581>,
            
    /*2*/<0.15836,0.00766,-0.98735>,<0.77021,0.06328,0.63464>,<-0.93266,-0.05073,0.35718>,
            
    /*3*/<0.15156,-0.08942,-0.98439>,<0.77613,0.00112,0.63057>,<-0.93133,0.10797,0.3478>,
            
    /*4*/<0.13309,0.97825,-0.15909>

    /* stem 0.5.21*/ 
    /*0*/<-0.22574,-0.89411,0.38679>,
    /*1*/<0.95953,-0.26978,-0.0807>,<-0.32467,0.44939,0.83225>,<-0.63039,-0.16189,-0.75921>,
            
    /*2*/<0.96891,-0.23159,-0.08705>,<-0.36178,0.31461,0.87757>,<-0.61639,-0.06289,-0.78492>,
            
    /*3*/<0.97659,-0.19377,-0.0934>,<-0.40474,0.11547,0.90711>,<-0.57211,0.09813,-0.81428>,
            
    /*4*/<0.20688,0.97735,0.04468>

    /* stem 0.5.22*/ 
    /*0*/<-0.79801,-0.58546,0.14286>,
    /*1*/<0.27766,-0.13521,0.95112>,<-0.59652,0.76502,-0.24273>,<0.33451,-0.61832,-0.71119>,
            
    /*2*/<0.32294,-0.09211,0.94193>,<-0.67257,0.70489,-0.22534>,<0.3584,-0.59547,-0.719>,
            
    /*3*/<0.38485,-0.02991,0.9225>,<-0.79821,0.5716,-0.19006>,<0.42009,-0.52512,-0.74012>,
            
    /*4*/<0.52292,0.82515,-0.21375>

    /* stem 0.5.23*/ 
    /*0*/<-0.45121,-0.79216,-0.41095>,
    /*1*/<-0.83256,0.21825,0.50913>,<0.14904,0.3938,-0.90703>,<0.69226,-0.5967,0.40586>,
            
    /*2*/<-0.85489,0.16841,0.49072>,<0.13249,0.3509,-0.92699>,<0.73659,-0.50606,0.44871>,
            
    /*3*/<-0.89852,0.02108,0.43844>,<0.10801,0.33074,-0.93752>,<0.78955,-0.33723,0.51273>,
            
    /*4*/<0.07331,0.93213,0.35462>

    /* stem 0.5.24*/ 
    /*0*/<0.07946,-0.92512,-0.37126>,
    /*1*/<-0.64883,0.24084,-0.72181>,<0.97939,0.14673,-0.13879>,<-0.33208,-0.36984,0.86772>,
            
    /*2*/<-0.64899,0.22269,-0.72748>,<0.98419,0.07817,-0.15895>,<-0.33371,-0.28399,0.89888>,
            
    /*3*/<-0.64068,0.26744,-0.71973>,<0.97621,-0.06679,-0.2063>,<-0.32992,-0.18224,0.92625>,
            
    /*4*/<0.20599,0.94617,0.24965>

    /* stem 0.5.25*/ 
    /*0*/<0.25705,-0.92278,0.28707>,
    /*1*/<0.54217,-0.10161,-0.8341>,<0.41832,0.38001,0.82499>,<-0.96535,-0.26093,0.00368>,
            
    /*2*/<0.54207,-0.09976,-0.83439>,<0.43007,0.3279,0.84114>,<-0.97766,-0.21002,-0.00904>,
            
    /*3*/<0.5428,-0.1018,-0.83367>,<0.4469,0.23025,0.86444>,<-0.9934,-0.10987,-0.0328>,
            
    /*4*/<-0.05883,0.98353,-0.17092>

    /* stem 0.5.26*/ 
    /*0*/<-0.43594,-0.73756,0.51571>,
    /*1*/<0.89523,-0.27946,0.34707>,<-0.54112,0.67631,0.4998>,<-0.34736,-0.38542,-0.85486>,
            
    /*2*/<0.90803,-0.25661,0.33111>,<-0.54802,0.6639,0.50882>,<-0.35299,-0.39585,-0.84776>,
            
    /*3*/<0.94085,-0.18783,0.282>,<-0.56713,0.62113,0.5409>,<-0.36621,-0.42099,-0.82986>,
            
    /*4*/<0.26483,0.79265,-0.54915>

    /* stem 0.5.27*/ 
    /*0*/<-0.78452,-0.6074,-0.12488>,
    /*1*/<-0.13977,-0.01825,0.99002>,<-0.44946,0.6995,-0.55559>,<0.59604,-0.67598,-0.43334>,
            
    /*2*/<-0.12009,0.00746,0.99274>,<-0.56376,0.589,-0.57901>,<0.68324,-0.58772,-0.43332>,
            
    /*3*/<-0.09152,0.04131,0.99495>,<-0.70508,0.39977,-0.58571>,<0.79988,-0.43362,-0.41493>,
            
    /*4*/<0.40661,0.91357,-0.00826>

    /* stem 0.5.28*/ 
    /*0*/<-0.27947,-0.78011,-0.55975>,
    /*1*/<-0.95649,0.2754,0.09632>,<0.54728,0.35098,-0.7598>,<0.41042,-0.62299,0.66591>,
            
    /*2*/<-0.96034,0.26434,0.0887>,<0.54622,0.34775,-0.76205>,<0.41525,-0.60879,0.67597>,
            
    /*3*/<-0.96887,0.23695,0.07168>,<0.5331,0.28991,-0.79483>,<0.44183,-0.52507,0.72738>,
            
    /*4*/<0.22525,0.89094,0.39431>

    /* stem 0.6*/ 
    /*0*/<-0.00873,-0.86603,-0.49992>,
    /*1*/<-0.9997,0.00898,0.02264>,<-0.32324,0.48448,-0.81289>,<0.80006,0.30286,-0.51787>,
            <0.81782,-0.2849,0.5>,<-0.29449,-0.46652,0.83405>,
    /*2*/<-0.99971,0.0091,0.02246>,<-0.324,0.43595,-0.83963>,<0.80014,0.2728,-0.53418>,
            <0.81809,-0.25453,0.51569>,<-0.2941,-0.41754,0.85975>,
    /*3*/<-0.99973,0.00962,0.02137>,<-0.32478,0.33486,-0.88453>,<0.79965,0.21057,-0.56233>,
            <0.81855,-0.19131,0.54165>,<-0.29336,-0.31555,0.90242>,
    /*4*/<0.00501,0.95799,0.28676>

    /* stem 0.6.0*/ 
    /*0*/<0.49866,-0.6804,-0.53703>,
    /*1*/<-0.24353,0.49248,-0.83556>,<0.83731,0.23582,0.49325>,<-0.60546,-0.71238,0.35488>,
            
    /*2*/<-0.23227,0.47039,-0.85134>,<0.8706,0.17931,0.45816>,<-0.65127,-0.63714,0.41219>,
            
    /*3*/<-0.22473,0.48134,-0.84724>,<0.9408,-0.00404,0.33894>,<-0.70694,-0.46712,0.53108>,
            
    /*4*/<-0.01817,0.84994,0.52657>

    /* stem 0.6.1*/ 
    /*0*/<0.17101,-0.9732,-0.15374>,
    /*1*/<0.89068,0.22673,-0.39406>,<-0.08502,-0.16226,0.98308>,<-0.80964,-0.04181,-0.58544>,
            
    /*2*/<0.87892,0.28482,-0.38258>,<-0.07504,-0.20353,0.97619>,<-0.80604,-0.05817,-0.589>,
            
    /*3*/<0.86109,0.36421,-0.3548>,<-0.05926,-0.30393,0.95085>,<-0.80849,-0.04017,-0.58713>,
            
    /*4*/<-0.26057,0.90207,0.34405>

    /* stem 0.6.2*/ 
    /*0*/<-0.3028,-0.92046,-0.24712>,
    /*1*/<0.64329,-0.38146,0.66383>,<-0.92894,0.23779,0.28377>,<0.29266,0.16498,-0.94187>,
            
    /*2*/<0.64083,-0.39017,0.66114>,<-0.94381,0.19252,0.26863>,<0.30801,0.22018,-0.92555>,
            
    /*3*/<0.64877,-0.29434,0.70175>,<-0.97496,0.02732,0.22068>,<0.322,0.28422,-0.90307>,
            
    /*4*/<-0.0409,0.95624,0.2897>

    /* stem 0.6.3*/ 
    /*0*/<-0.28627,-0.70424,-0.64969>,
    /*1*/<-0.60144,-0.38858,0.69805>,<-0.34035,0.71387,-0.61201>,<0.94839,-0.30905,-0.07106>,
            
    /*2*/<-0.59992,-0.36768,0.71057>,<-0.36887,0.59082,-0.71754>,<0.98046,-0.19672,-0.00036>,
            
    /*3*/<-0.59779,-0.2826,0.75019>,<-0.39708,0.39798,-0.827>,<0.99178,-0.09469,0.08604>,
            
    /*4*/<0.07226,0.94067,0.33154>

    /* stem 0.6.4*/ 
    /*0*/<0.19382,-0.53042,-0.82528>,
    /*1*/<-0.91401,0.21535,-0.34381>,<0.76664,0.60936,-0.20235>,<0.14293,-0.81256,0.56508>,
            
    /*2*/<-0.91191,0.20091,-0.35785>,<0.80437,0.50477,-0.31336>,<0.12688,-0.69843,0.70434>,
            
    /*3*/<-0.90875,0.19074,-0.3712>,<0.81597,0.33218,-0.47313>,<0.09753,-0.50514,0.85751>,
            
    /*4*/<0.00198,0.89407,0.44793>

    /* stem 0.6.5*/ 
    /*0*/<0.36892,-0.83949,-0.39894>,
    /*1*/<0.19029,0.49542,-0.84755>,<0.68801,-0.03313,0.72494>,<-0.8867,-0.4432,0.13168>,
            
    /*2*/<0.19692,0.47667,-0.85674>,<0.70033,-0.06671,0.7107>,<-0.90677,-0.39154,0.15642>,
            
    /*3*/<0.20598,0.4424,-0.87284>,<0.72304,-0.13665,0.67716>,<-0.93558,-0.28644,0.2065>,
            
    /*4*/<-0.13404,0.90677,0.39975>

    /* stem 0.6.6*/ 
    /*0*/<0.00771,-0.99949,-0.03107>,
    /*1*/<0.99935,0.01626,-0.03233>,<-0.47134,-0.0235,0.88164>,<-0.52818,0.02984,-0.84861>,
            
    /*2*/<0.99399,0.10746,-0.02093>,<-0.46247,-0.11994,0.87848>,<-0.52933,0.03416,-0.84773>,
            
    /*3*/<0.98153,0.19128,-0.00423>,<-0.45734,-0.25511,0.85192>,<-0.53004,0.08516,-0.84369>,
            
    /*4*/<-0.17192,0.95305,0.24927>

    /* stem 0.6.7*/ 
    /*0*/<-0.46566,-0.81994,-0.33295>,
    /*1*/<0.26003,-0.479,0.83842>,<-0.85826,0.51184,-0.03766>,<0.60868,-0.01443,-0.79328>,
            
    /*2*/<0.26917,-0.45765,0.84741>,<-0.88757,0.45668,-0.06057>,<0.62479,0.02125,-0.78051>,
            
    /*3*/<0.27256,-0.45102,0.84987>,<-0.93031,0.35025,-0.10884>,<0.66499,0.12251,-0.73674>,
            
    /*4*/<0.2101,0.87886,0.42832>

    /* stem 0.6.8*/ 
    /*0*/<-0.19895,-0.60838,-0.76831>,
    /*1*/<-0.8825,-0.22245,0.41437>,<0.07714,0.77662,-0.62523>,<0.80981,-0.54056,0.22804>,
            
    /*2*/<-0.88682,-0.2432,0.39295>,<0.07102,0.73918,-0.66976>,<0.82508,-0.48232,0.29429>,
            
    /*3*/<-0.89159,-0.23826,0.3851>,<0.0573,0.62747,-0.77653>,<0.83905,-0.36918,0.39963>,
            
    /*4*/<0.03645,0.83665,0.54653>

    /* stem 0.6.9*/ 
    /*0*/<0.33547,-0.62579,-0.70416>,
    /*1*/<-0.65673,0.38763,-0.64688>,<0.91161,0.40153,0.08794>,<-0.26232,-0.7753,0.57454>,
            
    /*2*/<-0.65102,0.36671,-0.6646>,<0.94725,0.31979,0.02118>,<-0.2973,-0.6782,0.67206>,
            
    /*3*/<-0.64013,0.2792,-0.71574>,<0.9774,0.19499,-0.08169>,<-0.347,-0.45818,0.81833>,
            
    /*4*/<-0.0953,0.93676,0.33676>

    /* stem 0.6.10*/ 
    /*0*/<0.40011,-0.91365,-0.07177>,
    /*1*/<0.58597,0.32302,-0.74316>,<0.31071,0.06964,0.94795>,<-0.90549,-0.37254,-0.2032>,
            
    /*2*/<0.57093,0.36769,-0.73406>,<0.34978,-0.02392,0.93653>,<-0.92581,-0.32556,-0.19203>,
            
    /*3*/<0.55522,0.41055,-0.72331>,<0.39582,-0.16571,0.90325>,<-0.95887,-0.22607,-0.17163>,
            
    /*4*/<-0.22697,0.91517,0.33308>

    /* stem 0.6.11*/ 
    /*0*/<-0.20452,-0.97499,0.08693>,
    /*1*/<0.92139,-0.15401,0.35683>,<-0.74817,0.22021,0.62591>,<-0.16876,-0.04493,-0.98463>,
            
    /*2*/<0.92293,-0.13685,0.35983>,<-0.77892,0.0784,0.6222>,<-0.15938,0.08025,-0.98395>,
            
    /*3*/<0.92519,-0.05088,0.37608>,<-0.7892,-0.10485,0.60512>,<-0.13311,0.17677,-0.97521>,
            
    /*4*/<-0.07527,0.98511,0.15457>

    /* stem 0.6.12*/ 
    /*0*/<-0.61604,-0.67341,-0.40867>,
    /*1*/<-0.17061,-0.38395,0.90746>,<-0.57315,0.74376,-0.34398>,<0.75706,-0.34527,-0.55466>,
            
    /*2*/<-0.16428,-0.37376,0.91286>,<-0.62049,0.68593,-0.38013>,<0.796,-0.29382,-0.5292>,
            
    /*3*/<-0.14371,-0.33228,0.93217>,<-0.6909,0.57744,-0.43499>,<0.84189,-0.2266,-0.48977>,
            
    /*4*/<0.40638,0.85047,0.334>

    /* stem 0.6.13*/ 
    /*0*/<-0.02812,-0.65894,-0.75167>,
    /*1*/<-0.99845,-0.00911,0.05485>,<0.46229,0.66292,-0.58892>,<0.53676,-0.63968,0.55018>,
            
    /*2*/<-0.99736,0.01186,0.07166>,<0.46095,0.59069,-0.66228>,<0.54447,-0.58527,0.60084>,
            
    /*3*/<-0.99426,0.04492,0.09708>,<0.44907,0.45623,-0.76824>,<0.55058,-0.48305,0.68083>,
            
    /*4*/<0.09356,0.87528,0.47448>

    /* stem 0.6.14*/ 
    /*0*/<0.38557,-0.79673,-0.46535>,
    /*1*/<-0.27699,0.38823,-0.87895>,<0.89732,0.21949,0.38294>,<-0.62854,-0.59076,0.50591>,
            
    /*2*/<-0.26878,0.36463,-0.89151>,<0.91625,0.17324,0.3612>,<-0.65668,-0.52236,0.54398>,
            
    /*3*/<-0.25712,0.3158,-0.91332>,<0.9486,0.06359,0.31002>,<-0.69762,-0.36212,0.61822>,
            
    /*4*/<-0.08346,0.94601,0.31321>

    /* stem 0.6.15*/ 
    /*0*/<0.24194,-0.96767,0.07131>,
    /*1*/<0.87358,0.19272,-0.44691>,<-0.07671,0.06138,0.99516>,<-0.80195,-0.23379,-0.54975>,
            
    /*2*/<0.85977,0.25636,-0.44166>,<-0.04667,-0.05039,0.99764>,<-0.81665,-0.18816,-0.54559>,
            
    /*3*/<0.84404,0.31437,-0.43447>,<-0.0142,-0.20468,0.97873>,<-0.83705,-0.09064,-0.53957>,
            
    /*4*/<-0.21029,0.94574,0.24769>

    /* stem 0.6.16*/ 
    /*0*/<-0.27546,-0.95005,-0.14671>,
    /*1*/<0.66995,-0.29233,0.68243>,<-0.93073,0.23373,0.28126>,<0.26652,0.07837,-0.96064>,
            
    /*2*/<0.67609,-0.25445,0.69149>,<-0.95388,0.1415,0.26475>,<0.2748,0.13285,-0.95228>,
            
    /*3*/<0.6782,-0.23832,0.69516>,<-0.9703,0.03776,0.23892>,<0.29461,0.22066,-0.92979>,
            
    /*4*/<0.08707,0.95443,0.28547>

    /* stem 0.6.17*/ 
    /*0*/<-0.43822,-0.65659,-0.61389>,
    /*1*/<-0.5717,-0.31591,0.7572>,<-0.30814,0.75604,-0.57746>,<0.88888,-0.42658,-0.16708>,
            
    /*2*/<-0.56605,-0.30221,0.76698>,<-0.34453,0.69064,-0.63586>,<0.92027,-0.37048,-0.1259>,
            
    /*3*/<-0.55948,-0.28265,0.77916>,<-0.39123,0.58352,-0.71165>,<0.95715,-0.28359,-0.05871>,
            
    /*4*/<0.24464,0.84133,0.482>

    /* stem 0.6.18*/ 
    /*0*/<0.17363,-0.63222,-0.75508>,
    /*1*/<-0.92778,0.15905,-0.33752>,<0.75093,0.58436,-0.30761>,<0.17332,-0.73054,0.66051>,
            
    /*2*/<-0.92643,0.15198,-0.34441>,<0.76858,0.52353,-0.3677>,<0.16202,-0.66336,0.73055>,
            
    /*3*/<-0.92786,0.17567,-0.32895>,<0.77989,0.4288,-0.45596>,<0.14648,-0.58758,0.79579>,
            
    /*4*/<-0.0268,0.80053,0.5987>

    /* stem 0.6.19*/ 
    /*0*/<0.58783,-0.79675,-0.14018>,
    /*1*/<0.15321,0.28779,-0.94536>,<0.60472,0.32678,0.72631>,<-0.76976,-0.59853,0.22187>,
            
    /*2*/<0.14299,0.30533,-0.94145>,<0.64301,0.27085,0.71636>,<-0.79539,-0.55996,0.23195>,
            
    /*3*/<0.15098,0.28658,-0.94608>,<0.68144,0.20767,0.7018>,<-0.84323,-0.4774,0.24709>,
            
    /*4*/<-0.41266,0.89759,0.15504>

    /* stem 0.6.20*/ 
    /*0*/<0.02738,-0.98216,0.18605>,
    /*1*/<0.9974,0.02155,-0.0688>,<-0.44393,0.16137,0.88141>,<-0.55402,-0.1633,-0.81633>,
            
    /*2*/<0.99754,0.01696,-0.06804>,<-0.44416,0.11621,0.88838>,<-0.55609,-0.11345,-0.82334>,
            
    /*3*/<0.99735,0.0301,-0.06629>,<-0.44196,-0.00481,0.89702>,<-0.55987,-0.00599,-0.82856>,
            
    /*4*/<-0.03615,0.99624,0.0787>

    /* stem 0.6.21*/ 
    /*0*/<-0.5537,-0.82948,-0.07335>,
    /*1*/<0.2953,-0.27024,0.91639>,<-0.81765,0.56396,-0.11576>,<0.53326,-0.27737,-0.79918>,
            
    /*2*/<0.30106,-0.25838,0.91793>,<-0.85544,0.50296,-0.12348>,<0.56151,-0.22621,-0.79595>,
            
    /*3*/<0.29932,-0.26361,0.91702>,<-0.90438,0.40427,-0.13661>,<0.61349,-0.12247,-0.78015>,
            
    /*4*/<0.33452,0.92417,0.18441>

    /* stem 0.6.22*/ 
    /*0*/<-0.21418,-0.76417,-0.60842>,
    /*1*/<-0.86497,-0.13407,0.48359>,<0.0439,0.61995,-0.78341>,<0.82525,-0.47096,0.31171>,
            
    /*2*/<-0.86525,-0.13335,0.48328>,<0.02982,0.51876,-0.8544>,<0.85175,-0.36719,0.37376>,
            
    /*3*/<-0.86644,-0.13346,0.48111>,<0.00575,0.35816,-0.93364>,<0.86473,-0.20643,0.45786>,
            
    /*4*/<0.00873,0.95472,0.29736>

    /* stem 0.6.23*/ 
    /*0*/<0.4201,-0.66943,-0.61268>,
    /*1*/<-0.68414,0.21744,-0.69619>,<0.857,0.51402,0.03648>,<-0.18096,-0.71855,0.67152>,
            
    /*2*/<-0.65828,0.16791,-0.73381>,<0.86571,0.49986,0.02635>,<-0.22018,-0.65759,0.72048>,
            
    /*3*/<-0.60355,0.06424,-0.79474>,<0.88861,0.45866,0.00081>,<-0.29815,-0.51052,0.80652>,
            
    /*4*/<-0.40287,0.86945,0.28593>

    /* stem 0.6.24*/ 
    /*0*/<0.34619,-0.93757,-0.03332>,
    /*1*/<0.55758,0.24089,-0.7944>,<0.36988,0.11057,0.92247>,<-0.93407,-0.33358,-0.12744>,
            
    /*2*/<0.55374,0.25788,-0.79175>,<0.39715,0.01999,0.91754>,<-0.95799,-0.26194,-0.11683>,
            
    /*3*/<0.55182,0.26198,-0.79175>,<0.42857,-0.10823,0.897>,<-0.98561,-0.1359,-0.10049>,
            
    /*4*/<-0.10805,0.96944,0.22027>

    /* stem 0.6.25*/ 
    /*0*/<-0.14464,-0.98584,0.08486>,
    /*1*/<0.9342,-0.10124,0.34209>,<-0.75036,0.17142,0.63842>,<-0.18111,-0.05159,-0.98211>,
            
    /*2*/<0.93595,-0.04376,0.34942>,<-0.76813,0.01081,0.6402>,<-0.18488,0.04612,-0.98168>,
            
    /*3*/<0.92188,0.09553,0.3755>,<-0.75295,-0.25575,0.60635>,<-0.17496,0.17375,-0.96912>,
            
    /*4*/<-0.27827,0.92974,0.24113>

    /* stem 0.6.26*/ 
    /*0*/<-0.59751,-0.73993,-0.30902>,
    /*1*/<-0.13692,-0.27958,0.95031>,<-0.61085,0.67371,-0.41591>,<0.7567,-0.38306,-0.52978>,
            
    /*2*/<-0.15771,-0.31153,0.93706>,<-0.63203,0.64392,-0.43117>,<0.80214,-0.32201,-0.50288>,
            
    /*3*/<-0.17999,-0.34155,0.92247>,<-0.6985,0.51769,-0.49406>,<0.88623,-0.15894,-0.43513>,
            
    /*4*/<0.2243,0.89715,0.38054>

    /* stem 0.6.27*/ 
    /*0*/<-0.05776,-0.57108,-0.81886>,
    /*1*/<-0.99607,-0.01829,0.08669>,<0.44245,0.72242,-0.53136>,<0.55414,-0.69898,0.45206>,
            
    /*2*/<-0.99682,-0.03128,0.07331>,<0.44455,0.66375,-0.6015>,<0.56282,-0.62807,0.53736>,
            
    /*3*/<-0.99743,-0.04066,0.05899>,<0.43906,0.54672,-0.71297>,<0.56318,-0.49871,0.65888>,
            
    /*4*/<-0.00282,0.8413,0.54056>

    /* stem 0.6.28*/ 
    /*0*/<0.42989,-0.81402,-0.39061>,
    /*1*/<-0.30887,0.27533,-0.91038>,<0.88852,0.30734,0.34071>,<-0.58132,-0.57949,0.57119>,
            
    /*2*/<-0.30827,0.27402,-0.91098>,<0.90761,0.26743,0.3236>,<-0.60027,-0.53886,0.59102>,
            
    /*3*/<-0.3072,0.27171,-0.91203>,<0.92891,0.21694,0.30009>,<-0.62294,-0.48531,0.61353>,
            
    /*4*/<-0.30805,0.87938,0.36303>

    /* stem 0.7*/ 
    /*0*/<0.48515,-0.86603,-0.12096>,
    /*1*/<-0.24693,0.00896,-0.96899>,<0.71936,0.48446,-0.49782>,<0.68458,0.30283,0.66305>,
            <-0.3032,-0.28492,0.90934>,<-0.8789,-0.46655,-0.09933>,
    /*2*/<-0.24676,0.00907,-0.96904>,<0.74524,0.43592,-0.50457>,<0.7005,0.27278,0.65947>,
            <-0.31843,-0.25456,0.91313>,<-0.90386,-0.41756,-0.09317>,
    /*3*/<-0.2457,0.00959,-0.9693>,<0.78881,0.33483,-0.51543>,<0.72781,0.21054,0.65265>,
            <-0.34363,-0.19133,0.91941>,<-0.94528,-0.31558,-0.08284>,
    /*4*/<-0.27828,0.95799,0.06938>

    /* stem 0.7.0*/ 
    /*0*/<0.62585,-0.71822,0.3041>,
    /*1*/<0.75944,0.49277,-0.42477>,<-0.25261,0.19224,0.94828>,<-0.52147,-0.66821,-0.53062>,
            
    /*2*/<0.77433,0.47376,-0.41948>,<-0.21903,0.14575,0.96477>,<-0.57399,-0.60478,-0.55206>,
            
    /*3*/<0.80364,0.42995,-0.41147>,<-0.15915,0.06869,0.98486>,<-0.65941,-0.48052,-0.57817>,
            
    /*4*/<-0.47002,0.87818,-0.08877>

    /* stem 0.7.1*/ 
    /*0*/<0.22594,-0.96873,0.1025>,
    /*1*/<0.58403,0.22669,0.77943>,<-0.96867,-0.20275,0.14342>,<0.37938,-0.0014,-0.92524>,
            
    /*2*/<0.58106,0.23623,0.77882>,<-0.95935,-0.24103,0.14681>,<0.3712,0.02674,-0.92817>,
            
    /*3*/<0.5832,0.22825,0.7796>,<-0.94047,-0.30523,0.1495>,<0.35008,0.09914,-0.93146>,
            
    /*4*/<-0.34056,0.94013,0.01302>

    /* stem 0.7.2*/ 
    /*0*/<-0.0636,-0.87464,-0.48059>,
    /*1*/<-0.50028,-0.38182,0.77713>,<-0.49668,0.45205,-0.74092>,<0.99843,-0.05,-0.02509>,
            
    /*2*/<-0.50092,-0.38979,0.77275>,<-0.49607,0.46061,-0.73603>,<0.99839,-0.05069,-0.02541>,
            
    /*3*/<-0.49901,-0.36565,0.78568>,<-0.50215,0.40197,-0.76568>,<0.99981,-0.01458,-0.01321>,
            
    /*4*/<-0.01227,0.92302,0.38455>

    /* stem 0.7.3*/ 
    /*0*/<0.5849,-0.54719,-0.59873>,
    /*1*/<-0.81556,-0.3898,-0.42768>,<0.40161,0.84071,-0.36321>,<0.40051,-0.43833,0.80465>,
            
    /*2*/<-0.82181,-0.38258,-0.42222>,<0.44365,0.80077,-0.40241>,<0.3685,-0.40226,0.83809>,
            
    /*3*/<-0.82685,-0.37606,-0.41821>,<0.51872,0.71548,-0.46799>,<0.29865,-0.32208,0.89837>,
            
    /*4*/<-0.54521,0.74424,0.38581>

    /* stem 0.7.4*/ 
    /*0*/<0.82688,-0.56233,-0.00669>,
    /*1*/<0.12956,0.21559,-0.96785>,<0.39835,0.59096,0.70148>,<-0.54682,-0.79369,0.26652>,
            
    /*2*/<0.13127,0.21494,-0.96776>,<0.49168,0.51061,0.70536>,<-0.6424,-0.71416,0.27803>,
            
    /*3*/<0.14577,0.18919,-0.97106>,<0.6339,0.35077,0.6893>,<-0.79926,-0.52453,0.29335>,
            
    /*4*/<-0.42218,0.90337,0.07541>

    /* stem 0.7.5*/ 
    /*0*/<0.47041,-0.83713,0.27915>,
    /*1*/<0.86865,0.49539,-0.00531>,<-0.55558,-0.02604,0.83106>,<-0.32375,-0.45036,-0.83208>,
            
    /*2*/<0.87598,0.48234,-0.00207>,<-0.53566,-0.06571,0.84188>,<-0.35317,-0.39862,-0.84639>,
            
    /*3*/<0.88196,0.47133,0.00083>,<-0.48721,-0.15357,0.85968>,<-0.40783,-0.2993,-0.86261>,
            
    /*4*/<-0.46668,0.88382,-0.03266>

    /* stem 0.7.6*/ 
    /*0*/<-0.1384,-0.98932,0.04567>,
    /*1*/<0.25759,0.01618,0.96612>,<-0.95562,0.12907,-0.26482>,<0.70116,-0.12289,-0.70233>,
            
    /*2*/<0.2573,0.01671,0.96619>,<-0.96116,0.07986,-0.26419>,<0.70523,-0.07416,-0.70509>,
            
    /*3*/<0.25609,0.03599,0.96598>,<-0.96536,-0.00932,-0.26076>,<0.70802,-0.00428,-0.70618>,
            
    /*4*/<-0.04899,0.99816,-0.03585>

    /* stem 0.7.7*/ 
    /*0*/<0.29801,-0.85254,-0.42937>,
    /*1*/<-0.75902,-0.47877,0.44122>,<-0.12762,0.4173,-0.89976>,<0.87996,0.08056,0.46816>,
            
    /*2*/<-0.75985,-0.47681,0.4419>,<-0.11704,0.38923,-0.91368>,<0.87055,0.10731,0.48024>,
            
    /*3*/<-0.79834,-0.38166,0.46581>,<-0.06992,0.23896,-0.96851>,<0.85313,0.16091,0.49627>,
            
    /*4*/<-0.27138,0.95578,0.11328>

    /* stem 0.7.8*/ 
    /*0*/<0.68503,-0.64338,-0.34175>,
    /*1*/<-0.60211,-0.22221,-0.76687>,<0.65494,0.75142,-0.08008>,<-0.06809,-0.51488,0.85455>,
            
    /*2*/<-0.61902,-0.20205,-0.75894>,<0.70659,0.6998,-0.10494>,<-0.09792,-0.48003,0.87177>,
            
    /*3*/<-0.67447,-0.12803,-0.72711>,<0.77701,0.6126,-0.1448>,<-0.11667,-0.46709,0.87648>,
            
    /*4*/<-0.48042,0.78394,0.39324>

    /* stem 0.7.9*/ 
    /*0*/<0.794,-0.5679,0.21693>,
    /*1*/<0.48234,0.3872,-0.78577>,<0.06376,0.44361,0.89395>,<-0.56365,-0.81825,-0.11298>,
            
    /*2*/<0.54813,0.32042,-0.77258>,<0.10176,0.40221,0.90987>,<-0.67999,-0.71759,-0.15057>,
            
    /*3*/<0.61221,0.25582,-0.74817>,<0.1851,0.31683,0.93025>,<-0.81097,-0.55572,-0.18304>,
            
    /*4*/<-0.49853,0.85837,-0.1211>

    /* stem 0.7.10*/ 
    /*0*/<0.19185,-0.92849,0.31796>,
    /*1*/<0.8557,0.32311,0.40419>,<-0.84394,0.01711,0.53616>,<-0.01597,-0.31983,-0.94734>,
            
    /*2*/<0.86857,0.27549,0.41194>,<-0.83235,-0.06332,0.55062>,<-0.04565,-0.19151,-0.98043>,
            
    /*3*/<0.8745,0.24159,0.42058>,<-0.78732,-0.22409,0.57438>,<-0.09851,0.00109,-0.99514>,
            
    /*4*/<-0.3163,0.94402,0.09371>

    /* stem 0.7.11*/ 
    /*0*/<-0.13546,-0.97424,-0.18029>,
    /*1*/<-0.14039,-0.15404,0.97804>,<-0.77758,0.22426,-0.58744>,<0.92091,-0.04905,-0.38669>,
            
    /*2*/<-0.14056,-0.14917,0.97877>,<-0.78316,0.16494,-0.59955>,<0.9254,0.00598,-0.37895>,
            
    /*3*/<-0.14232,-0.13296,0.98085>,<-0.78549,0.05598,-0.61634>,<0.92638,0.09847,-0.36349>,
            
    /*4*/<-0.09301,0.98886,0.11623>

    /* stem 0.7.12*/ 
    /*0*/<0.28148,-0.72025,-0.63404>,
    /*1*/<-0.92273,-0.38362,0.03747>,<0.22432,0.69711,-0.68097>,<0.69235,-0.29796,0.65717>,
            
    /*2*/<-0.91611,-0.39992,0.02839>,<0.27871,0.59672,-0.75249>,<0.64976,-0.17192,0.74045>,
            
    /*3*/<-0.9139,-0.40566,0.01535>,<0.3191,0.48259,-0.81565>,<0.58671,-0.05904,0.80764>,
            
    /*4*/<-0.37211,0.85915,0.35129>

    /* stem 0.7.13*/ 
    /*0*/<0.774,-0.59701,-0.21097>,
    /*1*/<-0.27839,-0.00956,-0.96042>,<0.62572,0.70581,0.33213>,<-0.36391,-0.68346,0.63281>,
            
    /*2*/<-0.27829,-0.00885,-0.96046>,<0.69462,0.64529,0.31797>,<-0.42918,-0.62209,0.65484>,
            
    /*3*/<-0.27962,-0.0043,-0.9601>,<0.80418,0.5206,0.28684>,<-0.53474,-0.49912,0.68186>,
            
    /*4*/<-0.49914,0.85541,0.13829>

    /* stem 0.7.14*/ 
    /*0*/<0.58366,-0.68322,0.43881>,
    /*1*/<0.79383,0.3874,-0.46879>,<-0.27294,0.35216,0.89526>,<-0.53325,-0.72509,-0.43577>,
            
    /*2*/<0.79864,0.38125,-0.46565>,<-0.23231,0.29538,0.9267>,<-0.58383,-0.66404,-0.46711>,
            
    /*3*/<0.81449,0.35524,-0.45871>,<-0.15536,0.18591,0.97021>,<-0.67529,-0.52615,-0.51686>,
            
    /*4*/<-0.44112,0.88201,-0.16573>

    /* stem 0.7.15*/ 
    /*0*/<-0.0222,-0.96605,0.25738>,
    /*1*/<0.63202,0.19268,0.75062>,<-0.98671,0.06908,0.14705>,<0.35516,-0.24154,-0.90306>,
            
    /*2*/<0.63037,0.19852,0.75048>,<-0.98336,-0.07123,0.1671>,<0.33808,-0.11148,-0.93449>,
            
    /*3*/<0.65271,0.13167,0.74608>,<-0.95008,-0.2474,0.19011>,<0.29827,0.13999,-0.94416>,
            
    /*4*/<-0.26417,0.94823,0.17628>

    /* stem 0.7.16*/ 
    /*0*/<-0.0364,-0.92891,-0.36852>,
    /*1*/<-0.51342,-0.29249,0.80675>,<-0.48525,0.34517,-0.80336>,<0.99943,-0.0334,0.00426>,
            
    /*2*/<-0.51459,-0.26931,0.81405>,<-0.48592,0.28178,-0.82733>,<0.99983,0.00779,0.0166>,
            
    /*3*/<-0.52373,-0.18687,0.83114>,<-0.47907,0.13317,-0.86762>,<0.99662,0.07336,0.03686>,
            
    /*4*/<-0.09587,0.99055,0.09808>

    /* stem 0.7.17*/ 
    /*0*/<0.50483,-0.57765,-0.64145>,
    /*1*/<-0.86643,-0.31646,-0.3862>,<0.44542,0.81434,-0.37209>,<0.41062,-0.48598,0.7715>,
            
    /*2*/<-0.89987,-0.26358,-0.3475>,<0.51112,0.72643,-0.4594>,<0.3879,-0.44145,0.80911>,
            
    /*3*/<-0.90752,-0.25766,-0.33168>,<0.56559,0.63278,-0.52887>,<0.33173,-0.36139,0.87141>,
            
    /*4*/<-0.45345,0.77358,0.44268>

    /* stem 0.7.18*/ 
    /*0*/<0.6935,-0.72003,-0.02495>,
    /*1*/<0.12072,0.15964,-0.97977>,<0.54697,0.51333,0.66129>,<-0.68181,-0.65832,0.31898>,
            
    /*2*/<0.09427,0.19461,-0.97634>,<0.60776,0.44634,0.65681>,<-0.71077,-0.62381,0.32506>,
            
    /*3*/<0.10857,0.14224,-0.98386>,<0.68398,0.33529,0.64789>,<-0.81899,-0.46445,0.33695>,
            
    /*4*/<-0.3665,0.93035,-0.0114>

    /* stem 0.7.19*/ 
    /*0*/<0.26449,-0.77518,0.57372>,
    /*1*/<0.95563,0.28763,-0.06359>,<-0.58069,0.35334,0.73345>,<-0.38025,-0.6254,-0.68139>,
            
    /*2*/<0.95565,0.28768,-0.06306>,<-0.56119,0.28343,0.77764>,<-0.40683,-0.55679,-0.7242>,
            
    /*3*/<0.94944,0.30591,-0.0706>,<-0.52226,0.18097,0.83336>,<-0.43362,-0.46928,-0.76926>,
            
    /*4*/<-0.32457,0.88223,-0.34106>

    /* stem 0.7.20*/ 
    /*0*/<-0.30682,-0.94563,0.1079>,
    /*1*/<0.29227,0.02128,0.9561>,<-0.92806,0.28013,-0.24543>,<0.6419,-0.28259,-0.71282>,
            
    /*2*/<0.29275,0.02452,0.95588>,<-0.94235,0.23165,-0.24148>,<0.65382,-0.23712,-0.71854>,
            
    /*3*/<0.29588,0.11017,0.94885>,<-0.97412,0.05479,-0.21928>,<0.66707,-0.1472,-0.73031>,
            
    /*4*/<-0.04109,0.98249,-0.18173>

    /* stem 0.7.21*/ 
    /*0*/<-0.05831,-0.82491,-0.56225>,
    /*1*/<-0.82644,-0.27027,0.49391>,<-0.07065,0.57061,-0.81817>,<0.89824,-0.28409,0.33534>,
            
    /*2*/<-0.82675,-0.26169,0.498>,<-0.07102,0.50221,-0.86183>,<0.90223,-0.22184,0.36982>,
            
    /*3*/<-0.82847,-0.22954,0.51083>,<-0.07174,0.39478,-0.91597>,<0.89935,-0.14694,0.4118>,
            
    /*4*/<-0.01851,0.93506,0.354>

    /* stem 0.7.22*/ 
    /*0*/<0.55084,-0.75648,-0.35259>,
    /*1*/<-0.66579,-0.13414,-0.73398>,<0.76744,0.62786,-0.12975>,<-0.11235,-0.47902,0.87059>,
            
    /*2*/<-0.65187,-0.15835,-0.74161>,<0.80899,0.56892,-0.14785>,<-0.16565,-0.39526,0.90351>,
            
    /*3*/<-0.65913,-0.13207,-0.74034>,<0.86878,0.45961,-0.18434>,<-0.21719,-0.30965,0.92571>,
            
    /*4*/<-0.36045,0.90505,0.22575>

    /* stem 0.7.23*/ 
    /*0*/<0.56715,-0.80884,0.1553>,
    /*1*/<0.52525,0.21832,-0.82246>,<0.27867,0.37324,0.88489>,<-0.81484,-0.57598,-0.06542>,
            
    /*2*/<0.53808,0.19519,-0.81998>,<0.3101,0.317,0.8963>,<-0.86391,-0.49783,-0.07632>,
            
    /*3*/<0.53336,0.21261,-0.81873>,<0.3687,0.21588,0.90413>,<-0.90793,-0.4103,-0.08557>,
            
    /*4*/<-0.41255,0.91082,0.01422>

    /* stem 0.7.24*/ 
    /*0*/<0.01009,-0.85303,0.52176>,
    /*1*/<0.90011,0.24034,0.36338>,<-0.82719,0.29148,0.4804>,<-0.07311,-0.51561,-0.8537>,
            
    /*2*/<0.90162,0.22015,0.37231>,<-0.829,0.21456,0.51645>,<-0.07975,-0.41998,-0.90402>,
            
    /*3*/<0.90295,0.1961,0.38238>,<-0.81873,0.12817,0.55969>,<-0.08563,-0.30652,-0.94801>,
            
    /*4*/<-0.07234,0.95359,-0.29228>

    /* stem 0.7.25*/ 
    /*0*/<-0.08833,-0.98898,-0.11881>,
    /*1*/<-0.12336,-0.10142,0.98717>,<-0.79344,0.14794,-0.5904>,<0.91841,-0.02848,-0.3946>,
            
    /*2*/<-0.13186,-0.04511,0.99024>,<-0.79422,-0.0157,-0.60743>,<0.91418,0.07275,-0.39873>,
            
    /*3*/<-0.12524,-0.04224,0.99123>,<-0.77505,-0.16445,-0.61013>,<0.89801,0.2242,-0.37858>,
            
    /*4*/<-0.25788,0.96348,0.07209>

    /* stem 0.7.26*/ 
    /*0*/<0.18387,-0.78247,-0.59493>,
    /*1*/<-0.95677,-0.27966,0.07986>,<0.27891,0.62548,-0.72869>,<0.67532,-0.33499,0.65706>,
            
    /*2*/<-0.94583,-0.32017,0.05392>,<0.28624,0.60447,-0.74343>,<0.65792,-0.27481,0.70116>,
            
    /*3*/<-0.93946,-0.34077,0.03601>,<0.31342,0.51876,-0.7954>,<0.62537,-0.16447,0.7628>,
            
    /*4*/<-0.28889,0.88612,0.36241>

    /* stem 0.7.27*/ 
    /*0*/<0.60296,-0.77775,-0.17762>,
    /*1*/<-0.30802,-0.01762,-0.95122>,<0.78922,0.55647,0.25976>,<-0.48674,-0.5317,0.69309>,
            
    /*2*/<-0.31013,-0.01401,-0.95059>,<0.8228,0.50972,0.25136>,<-0.51648,-0.48804,0.70361>,
            
    /*3*/<-0.32563,0.02149,-0.94525>,<0.89494,0.38374,0.22766>,<-0.56779,-0.39613,0.72159>,
            
    /*4*/<-0.33852,0.92519,0.17158>

    /* stem 0.7.28*/ 
    /*0*/<0.50663,-0.75946,0.4081>,
    /*1*/<0.81791,0.27468,-0.50554>,<-0.17395,0.37416,0.9109>,<-0.64478,-0.64761,-0.40603>,
            
    /*2*/<0.82967,0.2486,-0.49985>,<-0.1233,0.25287,0.95961>,<-0.73189,-0.5059,-0.45652>,
            
    /*3*/<0.82665,0.26637,-0.49568>,<-0.02646,0.07186,0.99706>,<-0.79915,-0.33632,-0.49824>,
            
    /*4*/<-0.36249,0.93195,-0.00867>

    /* stem 0.8*/ 
    /*0*/<0.227,-0.86603,0.4455>,
    /*1*/<0.88862,0.00893,-0.45856>,<0.64688,0.48444,0.58895>,<-0.49206,0.30281,0.8162>,
            <-0.95423,-0.28494,-0.09086>,<-0.10092,-0.46657,-0.87871>,
    /*2*/<0.8887,0.00905,-0.45841>,<0.65929,0.4359,0.61264>,<-0.48498,0.27276,0.8309>,
            <-0.96135,-0.25458,-0.10485>,<-0.11254,-0.41759,-0.90164>,
    /*3*/<0.88919,0.00956,-0.45744>,<0.67967,0.33481,0.65265>,<-0.4722,0.21052,0.85599>,
            <-0.97314,-0.19136,-0.12799>,<-0.13192,-0.3156,-0.93968>,
    /*4*/<-0.13021,0.95799,-0.25554>

    /* stem 0.8.0*/ 
    /*0*/<-0.21023,-0.68217,0.70032>,
    /*1*/<0.58514,0.49247,0.64427>,<-0.96942,0.23389,-0.07427>,<0.38918,-0.71047,-0.58632>,
            
    /*2*/<0.58071,0.46007,0.67165>,<-0.98288,0.18128,-0.03293>,<0.40772,-0.6289,-0.662>,
            
    /*3*/<0.57527,0.40523,0.71053>,<-0.99552,0.08113,0.04848>,<0.42103,-0.46905,-0.77635>,
            
    /*4*/<-0.01814,0.89327,-0.44916>

    /* stem 0.8.1*/ 
    /*0*/<-0.24679,-0.96609,0.07591>,
    /*1*/<-0.62655,0.22665,0.7457>,<-0.32266,0.01606,-0.94638>,<0.95493,-0.2203,0.19892>,
            
    /*2*/<-0.64046,0.12212,0.75822>,<-0.32431,0.0007,-0.94595>,<0.97524,-0.09925,0.19764>,
            
    /*3*/<-0.64208,-0.07487,0.76297>,<-0.346,0.03719,-0.9375>,<0.982,0.05871,0.17953>,
            
    /*4*/<-0.11415,0.985,0.12941>

    /* stem 0.8.2*/ 
    /*0*/<0.42954,-0.90025,-0.071>,
    /*1*/<-0.86955,-0.38165,-0.31341>,<0.65071,0.37125,-0.66238>,<0.20894,0.03114,0.97743>,
            
    /*2*/<-0.89576,-0.32078,-0.30777>,<0.66287,0.34143,-0.66635>,<0.22105,-0.00019,0.97526>,
            
    /*3*/<-0.90323,-0.30221,-0.30471>,<0.70686,0.24612,-0.66316>,<0.19265,0.08165,0.97786>,
            
    /*4*/<-0.33107,0.93523,-0.12548>

    /* stem 0.8.3*/ 
    /*0*/<0.63279,-0.63017,0.44995>,
    /*1*/<0.23391,-0.38919,-0.89097>,<0.5137,0.78121,0.35471>,<-0.76209,-0.37761,0.52596>,
            
    /*2*/<0.24689,-0.40336,-0.8811>,<0.52476,0.76973,0.36352>,<-0.78651,-0.35214,0.50734>,
            
    /*3*/<0.22248,-0.37586,-0.89957>,<0.55645,0.737,0.38365>,<-0.7918,-0.34652,0.50296>,
            
    /*4*/<-0.59919,0.70391,-0.38142>

    /* stem 0.8.4*/ 
    /*0*/<0.17165,-0.43365,0.88458>,
    /*1*/<0.97236,0.21459,-0.09205>,<-0.61795,0.65621,0.43304>,<-0.35831,-0.86094,-0.3611>,
            
    /*2*/<0.98638,0.16201,-0.02857>,<-0.61616,0.60293,0.50677>,<-0.38421,-0.76589,-0.51556>,
            
    /*3*/<0.99305,0.10395,0.05512>,<-0.59605,0.48959,0.63642>,<-0.40518,-0.57823,-0.70816>,
            
    /*4*/<-0.03515,0.83968,-0.54194>

    /* stem 0.8.5*/ 
    /*0*/<-0.31754,-0.78756,0.52813>,
    /*1*/<0.2017,0.49497,0.84517>,<-0.90011,0.08606,-0.42708>,<0.70556,-0.56329,-0.42999>,
            
    /*2*/<0.20142,0.49554,0.84491>,<-0.91806,0.03346,-0.39502>,<0.72154,-0.51282,-0.46518>,
            
    /*3*/<0.20377,0.45539,0.86666>,<-0.94153,-0.12442,-0.31311>,<0.74702,-0.31598,-0.58491>,
            
    /*4*/<-0.12376,0.91365,-0.3872>

    /* stem 0.8.6*/ 
    /*0*/<0.03647,-0.99549,0.08757>,
    /*1*/<-0.88426,0.01616,0.46672>,<0.03812,-0.07873,-0.99617>,<0.84532,0.08487,0.52748>,
            
    /*2*/<-0.88489,0.1136,0.45173>,<0.03329,-0.15106,-0.98796>,<0.84445,0.06071,0.53219>,
            
    /*3*/<-0.88135,0.21698,0.41969>,<0.04119,-0.31642,-0.94772>,<0.84812,0.11779,0.51655>,
            
    /*4*/<0.03298,0.91133,-0.41035>

    /* stem 0.8.7*/ 
    /*0*/<0.61143,-0.79077,0.0291>,
    /*1*/<-0.60155,-0.47928,-0.63908>,<0.74372,0.57166,-0.34652>,<-0.15575,-0.07482,0.98496>,
            
    /*2*/<-0.6099,-0.46587,-0.64108>,<0.78757,0.51307,-0.34132>,<-0.18652,-0.02691,0.98208>,
            
    /*3*/<-0.63614,-0.41007,-0.65358>,<0.87298,0.36776,-0.32042>,<-0.23968,0.06323,0.96879>,
            
    /*4*/<-0.33917,0.92187,-0.18741>

    /* stem 0.8.8*/ 
    /*0*/<0.62831,-0.43695,0.64366>,
    /*1*/<0.61077,-0.22378,-0.75953>,<0.09985,0.87045,0.48203>,<-0.72446,-0.63704,0.26332>,
            
    /*2*/<0.60732,-0.21969,-0.76348>,<0.1482,0.83036,0.53717>,<-0.77173,-0.59751,0.21776>,
            
    /*3*/<0.63148,-0.25874,-0.73095>,<0.22065,0.74808,0.62585>,<-0.87301,-0.4792,0.09066>,
            
    /*4*/<-0.32293,0.70892,-0.62702>

    /* stem 0.8.9*/ 
    /*0*/<-0.11796,-0.55907,0.82069>,
    /*1*/<0.8929,0.30749,0.32891>,<-0.82295,0.52059,0.22746>,<-0.06737,-0.81584,-0.57434>,
            
    /*2*/<0.89457,0.32521,0.30657>,<-0.82909,0.48558,0.27718>,<-0.06629,-0.79695,-0.6004>,
            
    /*3*/<0.89732,0.294,0.32922>,<-0.83579,0.41655,0.35768>,<-0.05923,-0.70086,-0.71083>,
            
    /*4*/<0.05651,0.7786,-0.62497>

    /* stem 0.8.10*/ 
    /*0*/<-0.25124,-0.93154,0.26288>,
    /*1*/<-0.20148,0.32305,0.92469>,<-0.71606,0.00391,-0.69803>,<0.92299,-0.30675,-0.23236>,
            
    /*2*/<-0.20367,0.29056,0.93493>,<-0.7286,-0.09728,-0.678>,<0.94556,-0.17421,-0.27488>,
            
    /*3*/<-0.20156,0.22885,0.95237>,<-0.73688,-0.2544,-0.62633>,<0.94073,0.04642,-0.33597>,
            
    /*4*/<-0.22003,0.94668,-0.23534>

    /* stem 0.8.11*/ 
    /*0*/<0.15768,-0.98639,-0.04665>,
    /*1*/<-0.98463,-0.15402,0.08231>,<0.41409,0.11616,-0.90279>,<0.56715,0.05909,0.82149>,
            
    /*2*/<-0.97752,-0.19202,0.08709>,<0.4373,0.03219,-0.89874>,<0.54614,0.18604,0.81678>,
            
    /*3*/<-0.95768,-0.26799,0.10507>,<0.47501,-0.12977,-0.87036>,<0.48495,0.42449,0.76461>,
            
    /*4*/<-0.33389,0.84811,-0.41137>

    /* stem 0.8.12*/ 
    /*0*/<0.53656,-0.81664,0.21262>,
    /*1*/<-0.24301,-0.38297,-0.89122>,<0.81658,0.5696,0.09352>,<-0.58505,-0.16916,0.79316>,
            
    /*2*/<-0.26218,-0.35411,-0.8977>,<0.82142,0.56234,0.09513>,<-0.57136,-0.19112,0.79813>,
            
    /*3*/<-0.26554,-0.36319,-0.89307>,<0.87421,0.46861,0.12714>,<-0.62439,-0.08101,0.7769>,
            
    /*4*/<-0.30475,0.89359,-0.32958>

    /* stem 0.8.13*/ 
    /*0*/<0.40268,-0.52964,0.74655>,
    /*1*/<0.87304,-0.01007,-0.48754>,<-0.21066,0.74513,0.63277>,<-0.67093,-0.72381,-0.16109>,
            
    /*2*/<0.88108,-0.02681,-0.4722>,<-0.17579,0.66579,0.72513>,<-0.73236,-0.62773,-0.26382>,
            
    /*3*/<0.88056,0.00123,-0.47394>,<-0.09563,0.48034,0.87185>,<-0.79308,-0.46208,-0.39688>,
            
    /*4*/<-0.24979,0.8936,-0.37294>

    /* stem 0.8.14*/ 
    /*0*/<-0.11438,-0.81346,0.57026>,
    /*1*/<0.63405,0.38829,0.66874>,<-0.97869,0.1938,0.06784>,<0.34705,-0.56495,-0.74859>,
            
    /*2*/<0.63253,0.40981,0.65724>,<-0.98732,0.09098,0.13007>,<0.34457,-0.48751,-0.80226>,
            
    /*3*/<0.6374,0.40631,0.6547>,<-0.97726,-0.04037,0.20817>,<0.33773,-0.3482,-0.87447>,
            
    /*4*/<-0.15818,0.91822,-0.3631>

    /* stem 0.8.15*/ 
    /*0*/<-0.17015,-0.97991,0.10402>,
    /*1*/<-0.58981,0.19274,0.7842>,<-0.38618,-0.02375,-0.92212>,<0.97954,-0.14859,0.13575>,
            
    /*2*/<-0.58276,0.22922,0.77965>,<-0.38958,-0.03981,-0.92013>,<0.97583,-0.16887,0.1387>,
            
    /*3*/<-0.57839,0.2698,0.76985>,<-0.39592,-0.0994,-0.91289>,<0.97893,-0.15084,0.13766>,
            
    /*4*/<0.14714,0.96349,-0.2237>

    /* stem 0.8.16*/ 
    /*0*/<0.32286,-0.94616,-0.02338>,
    /*1*/<-0.90137,-0.29239,-0.31944>,<0.70317,0.26356,-0.66037>,<0.19151,0.04842,0.98029>,
            
    /*2*/<-0.91974,-0.21492,-0.32845>,<0.73733,0.1384,-0.6612>,<0.1849,0.09443,0.97821>,
            
    /*3*/<-0.93411,-0.09195,-0.34493>,<0.77136,-0.04638,-0.63471>,<0.16284,0.15777,0.97396>,
            
    /*4*/<0.00711,0.98499,-0.17245>

    /* stem 0.8.17*/ 
    /*0*/<0.52458,-0.76681,0.36989>,
    /*1*/<0.18289,-0.3152,-0.93123>,<0.62257,0.64708,0.4401>,<-0.81619,-0.31621,0.48358>,
            
    /*2*/<0.1817,-0.31282,-0.93227>,<0.64021,0.62005,0.45351>,<-0.83211,-0.29076,0.47229>,
            
    /*3*/<0.19713,-0.35617,-0.91339>,<0.67958,0.5429,0.49338>,<-0.89367,-0.16916,0.41561>,
            
    /*4*/<-0.25344,0.85454,-0.45336>

    /* stem 0.8.18*/ 
    /*0*/<0.16716,-0.53696,0.82688>,
    /*1*/<0.9819,0.15839,-0.10382>,<-0.55779,0.64442,0.52306>,<-0.4275,-0.79192,-0.43602>,
            
    /*2*/<0.97057,0.19227,-0.14499>,<-0.53974,0.5952,0.59533>,<-0.43685,-0.77205,-0.46163>,
            
    /*3*/<0.96187,0.20795,-0.17766>,<-0.49992,0.48849,0.71516>,<-0.47462,-0.68534,-0.55232>,
            
    /*4*/<-0.24818,0.77276,-0.58416>

    /* stem 0.8.19*/ 
    /*0*/<-0.25058,-0.90197,0.35164>,
    /*1*/<0.27526,0.28848,0.91707>,<-0.93931,0.14766,-0.30965>,<0.66909,-0.41802,-0.61448>,
            
    /*2*/<0.27897,0.31957,0.90557>,<-0.95838,0.0644,-0.27815>,<0.67733,-0.36702,-0.63759>,
            
    /*3*/<0.28112,0.32752,0.90205>,<-0.96951,-0.02522,-0.24374>,<0.69038,-0.28377,-0.66548>,
            
    /*4*/<0.04255,0.94587,-0.32174>

    /* stem 0.8.20*/ 
    /*0*/<-0.086,-0.98905,-0.11991>,
    /*1*/<-0.86644,0.02154,0.49882>,<0.00904,0.12615,-0.99197>,<0.8591,-0.12811,0.49552>,
            
    /*2*/<-0.85881,0.09026,0.50428>,<0.00147,0.07931,-0.99685>,<0.85628,-0.14917,0.49451>,
            
    /*3*/<-0.85474,0.12997,0.50252>,<-0.00001,-0.00854,-0.99996>,<0.86089,-0.10191,0.49848>,
            
    /*4*/<0.07752,0.99552,-0.05417>

    /* stem 0.8.21*/ 
    /*0*/<0.52533,-0.83356,-0.17089>,
    /*1*/<-0.66707,-0.27026,-0.69424>,<0.78957,0.55784,-0.25571>,<-0.13277,-0.27129,0.9533>,
            
    /*2*/<-0.70388,-0.19211,-0.68385>,<0.84196,0.46176,-0.27907>,<-0.14093,-0.24984,0.95798>,
            
    /*3*/<-0.73259,-0.11971,-0.67006>,<0.92932,0.22661,-0.29157>,<-0.18733,-0.085,0.97861>,
            
    /*4*/<-0.11087,0.99082,-0.07738>

    /* stem 0.8.22*/ 
    /*0*/<0.57387,-0.63925,0.5119>,
    /*1*/<0.56473,-0.13492,-0.81417>,<0.22263,0.72863,0.64772>,<-0.79846,-0.58134,0.15655>,
            
    /*2*/<0.58843,-0.17724,-0.78889>,<0.26116,0.6642,0.70045>,<-0.87592,-0.47548,0.08173>,
            
    /*3*/<0.62101,-0.23195,-0.7487>,<0.32757,0.51886,0.78961>,<-0.96211,-0.26902,-0.04447>,
            
    /*4*/<-0.12504,0.90032,-0.41688>

    /* stem 0.8.23*/ 
    /*0*/<-0.09992,-0.68628,0.72044>,
    /*1*/<0.92002,0.21749,0.32597>,<-0.78849,0.50002,0.35813>,<-0.12963,-0.70443,-0.69783>,
            
    /*2*/<0.91987,0.23869,0.31123>,<-0.80054,0.40256,0.44393>,<-0.13279,-0.6285,-0.76639>,
            
    /*3*/<0.92311,0.23116,0.30731>,<-0.79462,0.26368,0.54686>,<-0.13102,-0.48015,-0.86735>,
            
    /*4*/<-0.04905,0.90874,-0.41447>

    /* stem 0.8.24*/ 
    /*0*/<-0.50246,-0.85503,0.12828>,
    /*1*/<-0.15164,0.24029,0.95878>,<-0.65611,0.28826,-0.69745>,<0.8172,-0.51247,-0.26375>,
            
    /*2*/<-0.17708,0.18929,0.96582>,<-0.66093,0.27894,-0.69668>,<0.84999,-0.45295,-0.26899>,
            
    /*3*/<-0.21463,0.09381,0.97218>,<-0.67972,0.24206,-0.69238>,<0.90525,-0.31924,-0.28037>,
            
    /*4*/<0.26797,0.96323,0.01962>

    /* stem 0.8.25*/ 
    /*0*/<0.06069,-0.92103,-0.38473>,
    /*1*/<-0.98933,-0.10303,0.10302>,<0.37773,0.38234,-0.84329>,<0.61073,-0.26609,0.74579>,
            
    /*2*/<-0.9867,-0.1312,0.096>,<0.39033,0.30661,-0.86812>,<0.60387,-0.16055,0.78074>,
            
    /*3*/<-0.97523,-0.20624,0.07989>,<0.38776,0.24493,-0.88862>,<0.58326,-0.0256,0.81188>,
            
    /*4*/<-0.24179,0.95498,0.17189>

    /* stem 0.8.26*/ 
    /*0*/<0.503,-0.85775,0.10613>,
    /*1*/<-0.29172,-0.28064,-0.91441>,<0.84859,0.51578,0.11777>,<-0.5615,-0.22724,0.79566>,
            
    /*2*/<-0.30411,-0.252,-0.9187>,<0.88785,0.44204,0.12773>,<-0.58304,-0.18029,0.79218>,
            
    /*3*/<-0.31679,-0.21721,-0.92329>,<0.93831,0.31296,0.14709>,<-0.62285,-0.08646,0.77755>,
            
    /*4*/<-0.23487,0.96148,-0.1428>

    /* stem 0.8.27*/ 
    /*0*/<0.33694,-0.73128,0.59304>,
    /*1*/<0.8581,-0.01913,-0.51313>,<-0.09485,0.60132,0.79336>,<-0.76445,-0.57957,-0.28235>,
            
    /*2*/<0.8637,-0.03805,-0.50257>,<-0.07305,0.52324,0.84905>,<-0.80412,-0.48313,-0.34637>,
            
    /*3*/<0.87184,-0.06998,-0.48477>,<-0.03479,0.39338,0.91872>,<-0.84156,-0.32032,-0.43495>,
            
    /*4*/<-0.0977,0.93411,-0.34337>

    /* stem 0.9*/ 
    /*0*/<-0.38302,-0.86603,0.32139>,
    /*1*/<0.64669,0.0089,0.7627>,<-0.42835,0.4844,0.7628>,<-0.90599,0.30277,-0.29583>,
            <-0.12614,-0.28498,-0.9502>,<0.83347,-0.46661,-0.29599>,
    /*2*/<0.64655,0.00901,0.76281>,<-0.44865,0.43586,0.78022>,<-0.91872,0.27272,-0.28563>,
            <-0.11411,-0.25462,-0.96029>,<0.8532,-0.41763,-0.31247>,
    /*3*/<0.64573,0.00952,0.76351>,<-0.48304,0.33477,0.80907>,<-0.94028,0.21048,-0.26753>,
            <-0.09421,-0.1914,-0.97698>,<0.88591,-0.31564,-0.33991>,
    /*4*/<0.2197,0.95799,-0.18435>

    /* stem 0.9.0*/ 
    /*0*/<-0.65569,-0.75317,0.05302>,
    /*1*/<-0.49673,0.49299,0.71429>,<-0.23258,0.14503,-0.9617>,<0.74451,-0.62056,0.24618>,
            
    /*2*/<-0.48578,0.50741,0.71173>,<-0.27135,0.09818,-0.95746>,<0.77178,-0.58862,0.24057>,
            
    /*3*/<-0.52962,0.44664,0.72112>,<-0.28423,0.09201,-0.95433>,<0.82247,-0.51776,0.23552>,
            
    /*4*/<0.50482,0.86287,-0.02469>

    /* stem 0.9.1*/ 
    /*0*/<-0.09259,-0.95286,-0.28895>,
    /*1*/<-0.86782,0.2265,-0.44225>,<0.8566,0.07943,-0.50983>,<0.01335,-0.28396,0.95874>,
            
    /*2*/<-0.86972,0.21102,-0.44616>,<0.85417,0.04787,-0.51779>,<0.0186,-0.23704,0.97132>,
            
    /*3*/<-0.86892,0.21309,-0.44674>,<0.84421,-0.02426,-0.53547>,<0.02913,-0.1666,0.98559>,
            
    /*4*/<0.17748,0.97371,0.14279>

    /* stem 0.9.2*/ 
    /*0*/<0.13181,-0.9065,0.40109>,
    /*1*/<0.11004,-0.38164,-0.91774>,<0.79651,0.34418,0.4971>,<-0.90957,0.05821,0.41145>,
            
    /*2*/<0.10698,-0.30284,-0.94702>,<0.80962,0.25209,0.53007>,<-0.91007,0.07162,0.40821>,
            
    /*3*/<0.10743,-0.22875,-0.96754>,<0.8044,0.09991,0.58562>,<-0.91204,0.15207,0.38087>,
            
    /*4*/<0.13431,0.96435,-0.22803>

    /* stem 0.9.3*/ 
    /*0*/<-0.29034,-0.61555,0.73267>,
    /*1*/<0.92069,-0.38932,0.0274>,<-0.22462,0.79275,0.56665>,<-0.68946,-0.38941,-0.61074>,
            
    /*2*/<0.92823,-0.37179,0.01268>,<-0.25474,0.73124,0.63276>,<-0.67223,-0.34022,-0.65753>,
            
    /*3*/<0.94,-0.34107,-0.00833>,<-0.30782,0.60261,0.73628>,<-0.63008,-0.24137,-0.73806>,
            
    /*4*/<0.29421,0.84325,-0.44985>

    /* stem 0.9.4*/ 
    /*0*/<-0.79821,-0.47696,0.36793>,
    /*1*/<0.3082,0.2149,0.92673>,<-0.59635,0.63677,-0.48877>,<0.30619,-0.84089,-0.44627>,
            
    /*2*/<0.31858,0.2274,0.92021>,<-0.71514,0.54452,-0.43826>,<0.40063,-0.76156,-0.50943>,
            
    /*3*/<0.32522,0.21986,0.91972>,<-0.86175,0.37813,-0.33824>,<0.54768,-0.58377,-0.59938>,
            
    /*4*/<0.39076,0.86505,-0.31464>

    /* stem 0.9.5*/ 
    /*0*/<-0.53008,-0.84795,-0.0003>,
    /*1*/<-0.77857,0.4954,0.38523>,<0.11247,-0.06114,-0.99177>,<0.67799,-0.41524,0.60655>,
            
    /*2*/<-0.79856,0.46339,0.38415>,<0.12995,-0.03043,-0.99105>,<0.67903,-0.41311,0.60685>,
            
    /*3*/<-0.81629,0.43229,0.38315>,<0.12666,-0.04121,-0.99109>,<0.70173,-0.37219,0.6075>,
            
    /*4*/<0.44999,0.8924,-0.03375>

    /* stem 0.9.6*/ 
    /*0*/<0.08462,-0.99281,-0.08467>,
    /*1*/<-0.65488,0.01611,-0.75556>,<0.97731,0.10641,-0.18316>,<-0.32432,-0.10037,0.94061>,
            
    /*2*/<-0.6548,0.02703,-0.75532>,<0.98107,0.05327,-0.18616>,<-0.32509,-0.05824,0.94389>,
            
    /*3*/<-0.65452,0.02705,-0.75556>,<0.98159,-0.03472,-0.18783>,<-0.3258,0.02999,0.94496>,
            
    /*4*/<0.06903,0.99643,-0.04852>

    /* stem 0.9.7*/ 
    /*0*/<-0.01464,-0.83569,0.54901>,
    /*1*/<0.4883,-0.47898,-0.72948>,<0.51169,0.47164,0.71814>,<-0.99967,0.02581,-0.00079>,
            
    /*2*/<0.48828,-0.48302,-0.72683>,<0.5115,0.49184,0.7046>,<-0.9999,0.00975,0.01023>,
            
    /*3*/<0.47713,-0.52143,-0.70743>,<0.50158,0.42598,0.75297>,<-0.99094,0.12342,-0.05303>,
            
    /*4*/<0.26795,0.82678,-0.4946>

    /* stem 0.9.8*/ 
    /*0*/<-0.48219,-0.51653,0.70759>,
    /*1*/<0.87743,-0.2232,0.42462>,<-0.48658,0.83228,0.26561>,<-0.38023,-0.59771,-0.7058>,
            
    /*2*/<0.88187,-0.21611,0.41904>,<-0.5424,0.77005,0.3359>,<-0.33926,-0.5375,-0.77201>,
            
    /*3*/<0.89606,-0.18436,0.40385>,<-0.65159,0.59365,0.47224>,<-0.25228,-0.38797,-0.88647>,
            
    /*4*/<0.31842,0.8777,-0.35813>

    /* stem 0.9.9*/ 
    /*0*/<-0.65437,-0.74095,0.15096>,
    /*1*/<-0.1209,0.30879,0.94341>,<-0.57816,0.37251,-0.72592>,<0.71333,-0.66515,-0.22078>,
            
    /*2*/<-0.1275,0.29997,0.94539>,<-0.61737,0.32125,-0.71809>,<0.75982,-0.60612,-0.23513>,
            
    /*3*/<-0.12221,0.3111,0.94249>,<-0.67263,0.24567,-0.69801>,<0.80516,-0.53828,-0.24893>,
            
    /*4*/<0.49059,0.84013,-0.2313>

    /* stem 0.9.10*/ 
    /*0*/<-0.30584,-0.90777,-0.28706>,
    /*1*/<-0.94636,0.32287,0.01243>,<0.54699,0.08696,-0.83261>,<0.406,-0.39016,0.8264>,
            
    /*2*/<-0.95918,0.28273,0.00596>,<0.53272,0.02504,-0.84592>,<0.43851,-0.28874,0.85108>,
            
    /*3*/<-0.98144,0.19167,-0.00609>,<0.51394,0.00716,-0.8578>,<0.46989,-0.17758,0.86468>,
            
    /*4*/<0.13167,0.98297,0.12817>

    /* stem 0.9.11*/ 
    /*0*/<0.13037,-0.98333,0.12678>,
    /*1*/<-0.30205,-0.15405,-0.94076>,<0.96768,0.16065,0.19441>,<-0.66843,0.01454,0.74363>,
            
    /*2*/<-0.30202,-0.14398,-0.94237>,<0.97395,0.0984,0.20428>,<-0.67149,0.06705,0.73797>,
            
    /*3*/<-0.30062,-0.17412,-0.93772>,<0.9762,0.065,0.20692>,<-0.67566,0.12984,0.72569>,
            
    /*4*/<-0.04158,0.97491,-0.21868>

    /* stem 0.9.12*/ 
    /*0*/<-0.03045,-0.77161,0.63537>,
    /*1*/<0.81332,-0.38332,-0.4377>,<0.09707,0.63585,0.76568>,<-0.90974,-0.23611,-0.3415>,
            
    /*2*/<0.81555,-0.35925,-0.45367>,<0.0939,0.5792,0.80976>,<-0.90902,-0.20099,-0.36507>,
            
    /*3*/<0.81821,-0.32998,-0.4708>,<0.08298,0.47224,0.87756>,<-0.90142,-0.12275,-0.41517>,
            
    /*4*/<0.12115,0.89788,-0.42324>

    /* stem 0.9.13*/ 
    /*0*/<-0.55074,-0.68258,0.48039>,
    /*1*/<0.6708,-0.00902,0.74158>,<-0.76421,0.64449,0.02497>,<0.10503,-0.62106,-0.7767>,
            
    /*2*/<0.70728,0.05417,0.70485>,<-0.82164,0.56371,0.08446>,<0.11724,-0.59688,-0.79371>,
            
    /*3*/<0.74068,0.11258,0.66236>,<-0.907,0.37877,0.18406>,<0.16267,-0.47513,-0.86475>,
            
    /*4*/<0.18299,0.91989,-0.34686>

    /* stem 0.9.14*/ 
    /*0*/<-0.58327,-0.81214,0.01491>,
    /*1*/<-0.50897,0.38825,0.76825>,<-0.28475,0.19588,-0.93838>,<0.80595,-0.5671,0.16981>,
            
    /*2*/<-0.52753,0.35816,0.77035>,<-0.30257,0.16627,-0.93851>,<0.84462,-0.50822,0.16831>,
            
    /*3*/<-0.56616,0.28777,0.77243>,<-0.30896,0.17141,-0.9355>,<0.88304,-0.43991,0.16344>,
            
    /*4*/<0.43608,0.89842,0.05178>

    /* stem 0.9.15*/ 
    /*0*/<-0.06163,-0.95063,-0.30413>,
    /*1*/<-0.89732,0.19252,-0.39717>,<0.82699,0.12875,-0.54728>,<0.07161,-0.30154,0.95076>,
            
    /*2*/<-0.89818,0.1836,-0.39946>,<0.82449,0.075,-0.56088>,<0.07815,-0.23926,0.96781>,
            
    /*3*/<-0.88906,0.22014,-0.40139>,<0.79944,-0.10841,-0.59088>,<0.10522,-0.09688,0.98972>,
            
    /*4*/<0.28905,0.95721,-0.01403>

    /* stem 0.9.16*/ 
    /*0*/<0.07057,-0.94898,0.30735>,
    /*1*/<0.10866,-0.2924,-0.9501>,<0.8036,0.24296,0.54332>,<-0.91372,0.06899,0.40045>,
            
    /*2*/<0.10876,-0.3045,-0.94628>,<0.80472,0.20192,0.55825>,<-0.91524,0.12296,0.38368>,
            
    /*3*/<0.10873,-0.31753,-0.94199>,<0.78988,0.05489,0.6108>,<-0.89691,0.28614,0.33717>,
            
    /*4*/<0.30366,0.91068,-0.28009>

    /* stem 0.9.17*/ 
    /*0*/<-0.20402,-0.66399,0.71937>,
    /*1*/<0.94824,-0.31593,-0.0321>,<-0.25676,0.74979,0.60982>,<-0.68733,-0.42036,-0.59235>,
            
    /*2*/<0.95642,-0.28717,-0.05291>,<-0.28427,0.66418,0.69142>,<-0.67607,-0.35718,-0.64447>,
            
    /*3*/<0.94376,-0.32834,-0.0388>,<-0.31719,0.54665,0.77496>,<-0.62254,-0.20458,-0.75537>,
            
    /*4*/<0.36973,0.84103,-0.39493>

    /* stem 0.9.18*/ 
    /*0*/<-0.61678,-0.71589,0.32724>,
    /*1*/<0.321,0.15958,0.93354>,<-0.77827,0.51706,-0.3563>,<0.46973,-0.66218,-0.58385>,
            
    /*2*/<0.3166,0.15356,0.93605>,<-0.82049,0.46203,-0.33664>,<0.51435,-0.60148,-0.61128>,
            
    /*3*/<0.31744,0.17035,0.93285>,<-0.9245,0.26352,-0.27541>,<0.60049,-0.41998,-0.68046>,
            
    /*4*/<0.17104,0.95251,-0.25193>

    /* stem 0.9.19*/ 
    /*0*/<-0.43435,-0.86564,-0.24903>,
    /*1*/<-0.83142,0.28821,0.47506>,<0.12608,0.22255,-0.96673>,<0.71403,-0.49345,0.49666>,
            
    /*2*/<-0.83904,0.27176,0.47133>,<0.11401,0.19485,-0.97419>,<0.73484,-0.44962,0.50779>,
            
    /*3*/<-0.87506,0.16264,0.45586>,<0.09703,0.16016,-0.98231>,<0.78408,-0.3055,0.54027>,
            
    /*4*/<0.14602,0.97653,0.15833>

    /* stem 0.9.20*/ 
    /*0*/<0.0376,-0.99776,-0.05535>,
    /*1*/<-0.68055,0.02158,-0.73239>,<0.97378,0.05553,-0.22061>,<-0.29398,-0.05741,0.95409>,
            
    /*2*/<-0.68306,0.06852,-0.72714>,<0.97376,0.05854,-0.21991>,<-0.29353,-0.10767,0.94987>,
            
    /*3*/<-0.67871,0.09817,-0.72782>,<0.97491,0.06272,-0.21359>,<-0.29697,-0.14145,0.94435>,
            
    /*4*/<-0.03094,0.99121,0.12862>

    /* stem 0.9.21*/ 
    /*0*/<0.33373,-0.80228,0.49494>,
    /*1*/<0.52608,-0.27047,-0.80628>,<0.40984,0.60158,0.68566>,<-0.94243,-0.31546,0.11096>,
            
    /*2*/<0.52222,-0.2542,-0.81405>,<0.43514,0.52697,0.73004>,<-0.96371,-0.25416,0.08161>,
            
    /*3*/<0.51976,-0.24795,-0.81754>,<0.46612,0.35002,0.81254>,<-0.99672,-0.08053,0.0075>,
            
    /*4*/<0.03349,0.95621,-0.29077>

    /* stem 0.9.22*/ 
    /*0*/<-0.33744,-0.76598,0.54719>,
    /*1*/<0.92013,-0.13411,0.36793>,<-0.63732,0.618,0.46032>,<-0.27629,-0.4691,-0.83881>,
            
    /*2*/<0.93641,-0.08838,0.33961>,<-0.65727,0.56541,0.4983>,<-0.27386,-0.45972,-0.84479>,
            
    /*3*/<0.93245,-0.11158,0.34365>,<-0.68355,0.49168,0.53946>,<-0.24057,-0.36703,-0.89856>,
            
    /*4*/<0.32309,0.88182,-0.34351>

    /* stem 0.9.23*/ 
    /*0*/<-0.66652,-0.74079,0.08356>,
    /*1*/<-0.11104,0.21782,0.96965>,<-0.576,0.44978,-0.68258>,<0.69968,-0.65355,-0.28865>,
            
    /*2*/<-0.14596,0.17177,0.97426>,<-0.58814,0.4342,-0.68232>,<0.74999,-0.59371,-0.29159>,
            
    /*3*/<-0.21107,0.07443,0.97463>,<-0.60601,0.41502,-0.67861>,<0.82972,-0.47509,-0.29299>,
            
    /*4*/<0.46758,0.87812,0.1013>

    /* stem 0.9.24*/ 
    /*0*/<-0.24367,-0.92672,-0.28604>,
    /*1*/<-0.96829,0.24072,0.06682>,<0.49243,0.14229,-0.85864>,<0.48043,-0.36564,0.79718>,
            
    /*2*/<-0.96978,0.23504,0.06537>,<0.48146,0.09262,-0.87156>,<0.49578,-0.31078,0.81094>,
            
    /*3*/<-0.97266,0.22357,0.06288>,<0.47577,0.0792,-0.876>,<0.50224,-0.2851,0.81637>,
            
    /*4*/<0.22024,0.9453,0.24064>

    /* stem 0.9.25*/ 
    /*0*/<0.21855,-0.97513,0.03677>,
    /*1*/<-0.32212,-0.10273,-0.94111>,<0.95751,0.22629,0.17881>,<-0.63855,-0.10944,0.76176>,
            
    /*2*/<-0.31636,-0.13213,-0.93939>,<0.95862,0.22124,0.17916>,<-0.64634,-0.07517,0.75934>,
            
    /*3*/<-0.32098,-0.12231,-0.93915>,<0.96299,0.2037,0.17652>,<-0.64565,-0.06738,0.76066>,
            
    /*4*/<-0.18487,0.98239,-0.02691>

    /* stem 0.9.26*/ 
    /*0*/<0.03953,-0.83389,0.55051>,
    /*1*/<0.82523,-0.28018,-0.4904>,<0.0749,0.55495,0.82851>,<-0.90057,-0.2655,-0.34422>,
            
    /*2*/<0.82577,-0.25587,-0.50263>,<0.07591,0.48286,0.8724>,<-0.9036,-0.21555,-0.37019>,
            
    /*3*/<0.82575,-0.24024,-0.51032>,<0.07318,0.3773,0.9232>,<-0.90008,-0.12663,-0.41691>,
            
    /*4*/<0.07392,0.93478,-0.34744>

    /* stem 0.9.27*/ 
    /*0*/<-0.44606,-0.79756,0.40612>,
    /*1*/<0.69317,-0.01866,0.72054>,<-0.83657,0.53349,0.12468>,<0.14566,-0.51079,-0.84728>,
            
    /*2*/<0.68495,-0.03268,0.72785>,<-0.82758,0.54902,0.11698>,<0.14488,-0.51214,-0.8466>,
            
    /*3*/<0.68615,-0.03181,0.72677>,<-0.8311,0.54278,0.12112>,<0.14691,-0.5066,-0.84957>,
            
    /*4*/<0.43402,0.80775,-0.39894>

    /* stem 0.10*/ 
    /*0*/<-0.39932,-0.86603,-0.30091>,
    /*1*/<-0.5977,0.00886,0.80167>,<-0.83963,0.48436,-0.2458>,<0.08442,0.30274,-0.94933>,
            <0.89745,-0.28502,-0.33667>,<0.47588,-0.46665,0.74551>,
    /*2*/<-0.59784,0.00897,0.80157>,<-0.86116,0.43582,-0.26165>,<0.07162,0.27268,-0.95944>,
            <0.90999,-0.25466,-0.32721>,<0.49637,-0.41767,0.76103>,
    /*3*/<-0.5987,0.00948,0.80092>,<-0.89701,0.33473,-0.28867>,<0.04915,0.21044,-0.97637>,
            <0.93073,-0.19144,-0.31158>,<0.53047,-0.31568,0.78673>,
    /*4*/<0.22905,0.95799,0.1726>

    /* stem 0.10.0*/ 
    /*0*/<-0.13345,-0.69656,-0.70497>,
    /*1*/<-0.80824,0.49255,-0.32273>,<0.90106,0.21794,-0.37497>,<-0.08973,-0.69436,0.71401>,
            
    /*2*/<-0.79688,0.53085,-0.28842>,<0.88755,0.1637,-0.43066>,<-0.083,-0.67688,0.7314>,
            
    /*3*/<-0.7956,0.54104,-0.27258>,<0.85635,0.06613,-0.51214>,<-0.05262,-0.59312,0.80339>,
            
    /*4*/<0.31464,0.7997,0.51136>

    /* stem 0.10.1*/ 
    /*0*/<0.10972,-0.97403,-0.19805>,
    /*1*/<0.23687,0.22663,-0.94474>,<0.7161,-0.053,0.69598>,<-0.95549,-0.15128,0.2533>,
            
    /*2*/<0.24041,0.25032,-0.93784>,<0.71727,-0.1962,0.6686>,<-0.95579,-0.03954,0.29137>,
            
    /*3*/<0.23782,0.25805,-0.9364>,<0.69958,-0.36702,0.6131>,<-0.93433,0.12986,0.3319>,
            
    /*4*/<0.28512,0.91177,0.2956>

    /* stem 0.10.2*/ 
    /*0*/<-0.3583,-0.9037,0.2344>,
    /*1*/<0.91894,-0.38169,-0.09934>,<-0.30015,0.35687,0.88462>,<-0.61061,0.04544,-0.79063>,
            
    /*2*/<0.90564,-0.41357,-0.09372>,<-0.31361,0.32877,0.89082>,<-0.58472,0.10591,-0.80429>,
            
    /*3*/<0.87906,-0.4689,-0.08601>,<-0.31409,0.31212,0.89662>,<-0.55405,0.17645,-0.81357>,
            
    /*4*/<0.48568,0.86289,-0.13974>

    /* stem 0.10.3*/ 
    /*0*/<-0.73193,-0.66494,-0.14879>,
    /*1*/<0.18004,-0.38896,0.90349>,<-0.65211,0.75152,-0.09983>,<0.48869,-0.34746,-0.80028>,
            
    /*2*/<0.2202,-0.32586,0.91942>,<-0.7776,0.61517,-0.13>,<0.54654,-0.26388,-0.79477>,
            
    /*3*/<0.27963,-0.20545,0.93787>,<-0.91917,0.35203,-0.17665>,<0.63569,-0.12487,-0.76178>,
            
    /*4*/<0.21395,0.97221,0.09502>

    /* stem 0.10.4*/ 
    /*0*/<-0.54216,-0.43225,-0.72057>,
    /*1*/<-0.83364,0.21454,0.50894>,<0.36629,0.65677,-0.65916>,<0.47955,-0.86159,0.16643>,
            
    /*2*/<-0.83999,0.20818,0.50108>,<0.32183,0.60887,-0.72505>,<0.53868,-0.80882,0.23586>,
            
    /*3*/<-0.85437,0.19075,0.48339>,<0.25565,0.5431,-0.7998>,<0.61039,-0.7202,0.32975>,
            
    /*4*/<0.4476,0.69009,0.5687>

    /* stem 0.10.5*/ 
    /*0*/<0.08169,-0.77458,-0.62718>,
    /*1*/<-0.55199,0.49484,-0.67114>,<0.99406,0.10855,0.00732>,<-0.4439,-0.58604,0.67787>,
            
    /*2*/<-0.55185,0.47265,-0.68707>,<0.99752,0.06726,-0.02061>,<-0.44722,-0.52401,0.72485>,
            
    /*3*/<-0.55046,0.39191,-0.73716>,<0.99694,0.0711,-0.03246>,<-0.44765,-0.44226,0.77718>,
            
    /*4*/<-0.08928,0.89329,0.44052>

    /* stem 0.10.6*/ 
    /*0*/<-0.07967,-0.99444,-0.06892>,
    /*1*/<0.59023,0.01608,-0.80708>,<0.40179,-0.08792,0.9115>,<-0.99025,0.09391,-0.10289>,
            
    /*2*/<0.59546,0.03973,-0.8024>,<0.38741,-0.19053,0.90201>,<-0.98148,0.17008,-0.08816>,
            
    /*3*/<0.61301,0.13324,-0.77876>,<0.36683,-0.30637,0.87839>,<-0.97582,0.19546,-0.09778>,
            
    /*4*/<0.09328,0.94335,0.31843>

    /* stem 0.10.7*/ 
    /*0*/<-0.56801,-0.77143,0.28681>,
    /*1*/<0.82084,-0.47946,0.31038>,<-0.49242,0.60481,0.62588>,<-0.31588,-0.10832,-0.9426>,
            
    /*2*/<0.85356,-0.42748,0.29782>,<-0.54009,0.53273,0.65154>,<-0.30385,-0.08556,-0.94887>,
            
    /*3*/<0.87662,-0.3855,0.28796>,<-0.59973,0.43691,0.67039>,<-0.26768,-0.03198,-0.96298>,
            
    /*4*/<0.45276,0.88318,-0.12248>

    /* stem 0.10.8*/ 
    /*0*/<-0.69576,-0.64437,-0.31732>,
    /*1*/<-0.21714,-0.22228,0.9505>,<-0.47531,0.75059,-0.45901>,<0.7077,-0.51419,-0.48454>,
            
    /*2*/<-0.21577,-0.21979,0.95139>,<-0.52746,0.69578,-0.48752>,<0.75818,-0.45912,-0.46301>,
            
    /*3*/<-0.21224,-0.20912,0.95458>,<-0.62446,0.56159,-0.54282>,<0.8477,-0.33259,-0.41326>,
            
    /*4*/<0.38789,0.87893,0.27753>

    /* stem 0.10.9*/ 
    /*0*/<-0.26256,-0.59557,-0.75919>,
    /*1*/<-0.94667,0.30772,0.09554>,<0.62923,0.49675,-0.59776>,<0.32314,-0.79152,0.51872>,
            
    /*2*/<-0.96539,0.25471,0.05611>,<0.61487,0.41195,-0.67248>,<0.3738,-0.66133,0.65032>,
            
    /*3*/<-0.96914,0.24515,0.02589>,<0.55084,0.23625,-0.80048>,<0.42823,-0.4631,0.77599>,
            
    /*4*/<0.28017,0.9059,0.31757>

    /* stem 0.10.10*/ 
    /*0*/<0.11302,-0.93109,-0.34685>,
    /*1*/<-0.22428,0.323,-0.91944>,<0.94933,0.00589,0.31422>,<-0.72749,-0.30883,0.61269>,
            
    /*2*/<-0.21432,0.24299,-0.94606>,<0.94526,0.04438,0.32329>,<-0.735,-0.2666,0.62346>,
            
    /*3*/<-0.21055,0.17694,-0.96144>,<0.95016,-0.01315,0.31148>,<-0.73644,-0.14479,0.66083>,
            
    /*4*/<0.066,0.98209,0.17645>

    /* stem 0.10.11*/ 
    /*0*/<0.0295,-0.93684,0.34852>,
    /*1*/<0.84782,-0.15441,-0.5073>,<0.03397,0.35609,0.93383>,<-0.88242,-0.18162,-0.43399>,
            
    /*2*/<0.84813,-0.147,-0.50899>,<0.03336,0.29713,0.95425>,<-0.88402,-0.12919,-0.44924>,
            
    /*3*/<0.85177,-0.08141,-0.51756>,<0.03323,0.15331,0.98762>,<-0.88213,-0.05096,-0.46823>,
            
    /*4*/<-0.00273,0.99807,-0.062>

    /* stem 0.10.12*/ 
    /*0*/<-0.63384,-0.76333,0.12478>,
    /*1*/<0.60948,-0.3834,0.69393>,<-0.71532,0.64657,0.26507>,<0.11928,-0.24699,-0.96165>,
            
    /*2*/<0.58835,-0.40999,0.69696>,<-0.7213,0.63957,0.26586>,<0.1474,-0.21416,-0.96561>,
            
    /*3*/<0.57143,-0.43234,0.69753>,<-0.74111,0.61423,0.27106>,<0.18267,-0.16521,-0.96919>,
            
    /*4*/<0.61163,0.79109,-0.00934>

    /* stem 0.10.13*/ 
    /*0*/<-0.60355,-0.66725,-0.43647>,
    /*1*/<-0.57161,-0.00915,0.82047>,<-0.18542,0.65651,-0.73118>,<0.76972,-0.63333,-0.08012>,
            
    /*2*/<-0.58039,-0.02198,0.81405>,<-0.23162,0.59102,-0.77269>,<0.83117,-0.55465,-0.03896>,
            
    /*3*/<-0.60594,-0.06656,0.79272>,<-0.28695,0.51236,-0.80941>,<0.90268,-0.42955,0.02572>,
            
    /*4*/<0.34518,0.85234,0.3929>

    /* stem 0.10.14*/ 
    /*0*/<-0.03865,-0.69832,-0.71474>,
    /*1*/<-0.8638,0.38742,-0.3221>,<0.8669,0.33746,-0.36688>,<-0.00229,-0.71034,0.70386>,
            
    /*2*/<-0.8639,0.38534,-0.32433>,<0.86331,0.24906,-0.43893>,<0.01379,-0.62391,0.78137>,
            
    /*3*/<-0.86978,0.36573,-0.33125>,<0.82594,0.05461,-0.5611>,<0.06149,-0.40785,0.91098>,
            
    /*4*/<0.26471,0.93022,0.25422>

    /* stem 0.10.15*/ 
    /*0*/<0.26752,-0.95445,-0.13211>,
    /*1*/<0.18525,0.19253,-0.96365>,<0.72317,0.11568,0.68092>,<-0.91395,-0.28845,0.28546>,
            
    /*2*/<0.17608,0.24231,-0.95409>,<0.74366,0.03937,0.66739>,<-0.91972,-0.26202,0.29234>,
            
    /*3*/<0.16889,0.29478,-0.94052>,<0.76086,-0.07971,0.644>,<-0.9324,-0.19595,0.30369>,
            
    /*4*/<-0.07368,0.95643,0.28251>

    /* stem 0.10.16*/ 
    /*0*/<-0.25308,-0.91511,0.3139>,
    /*1*/<0.94997,-0.29267,-0.10904>,<-0.30642,0.39005,0.86831>,<-0.63837,-0.07864,-0.7657>,
            
    /*2*/<0.9489,-0.29658,-0.10779>,<-0.32291,0.33878,0.88372>,<-0.62379,-0.02225,-0.78128>,
            
    /*3*/<0.95439,-0.27893,-0.1065>,<-0.36719,0.19165,0.91019>,<-0.58847,0.10798,-0.80127>,
            
    /*4*/<0.26711,0.96344,0.02082>

    /* stem 0.10.17*/ 
    /*0*/<-0.73577,-0.6758,-0.04399>,
    /*1*/<0.24451,-0.31585,0.91676>,<-0.66336,0.73963,-0.11357>,<0.4338,-0.41005,-0.80229>,
            
    /*2*/<0.24539,-0.31291,0.91754>,<-0.7696,0.62301,-0.13991>,<0.5297,-0.2868,-0.79822>,
            
    /*3*/<0.27352,-0.22002,0.93636>,<-0.90983,0.38008,-0.16656>,<0.63162,-0.14037,-0.76246>,
            
    /*4*/<0.25039,0.96628,0.06013>

    /* stem 0.10.18*/ 
    /*0*/<-0.47544,-0.67024,-0.56985>,
    /*1*/<-0.8373,0.15924,0.52303>,<0.19842,0.55568,-0.80737>,<0.64843,-0.70147,0.29578>,
            
    /*2*/<-0.85676,0.12623,0.50003>,<0.18417,0.52924,-0.82825>,<0.68451,-0.64392,0.34179>,
            
    /*3*/<-0.8794,0.08444,0.46854>,<0.15754,0.4839,-0.86083>,<0.7296,-0.55291,0.40245>,
            
    /*4*/<0.31352,0.81878,0.48095>

    /* stem 0.10.19*/ 
    /*0*/<0.12664,-0.87549,-0.46635>,
    /*1*/<-0.64978,0.28825,-0.70334>,<0.97332,0.20416,-0.10473>,<-0.32606,-0.47497,0.81737>,
            
    /*2*/<-0.64767,0.34878,-0.6774>,<0.98228,0.08846,-0.16525>,<-0.32264,-0.42136,0.84756>,
            
    /*3*/<-0.66219,0.34054,-0.66749>,<0.96728,-0.09564,-0.23499>,<-0.30625,-0.22592,0.92475>,
            
    /*4*/<0.21435,0.96378,0.15872>

    /* stem 0.10.20*/ 
    /*0*/<0.23797,-0.96056,0.14385>,
    /*1*/<0.55938,0.0213,-0.82864>,<0.40464,0.23925,0.88263>,<-0.96869,-0.24167,-0.05681>,
            
    /*2*/<0.56109,0.01094,-0.82768>,<0.41604,0.16771,0.89375>,<-0.98513,-0.15944,-0.06398>,
            
    /*3*/<0.56732,0.04146,-0.82245>,<0.42965,-0.05801,0.90113>,<-0.99775,0.03053,-0.05961>,
            
    /*4*/<0.12122,0.97674,0.17688>

    /* stem 0.10.21*/ 
    /*0*/<-0.40832,-0.79814,0.44299>,
    /*1*/<0.90395,-0.27053,0.33119>,<-0.57316,0.60691,0.55059>,<-0.32287,-0.3209,-0.89038>,
            
    /*2*/<0.88097,-0.31542,0.35269>,<-0.57502,0.60345,0.55245>,<-0.29571,-0.2744,-0.91502>,
            
    /*3*/<0.8811,-0.31377,0.35385>,<-0.59703,0.55784,0.57652>,<-0.27429,-0.22757,-0.93433>,
            
    /*4*/<0.38485,0.8604,-0.33407>

    /* stem 0.10.22*/ 
    /*0*/<-0.63343,-0.74569,-0.20669>,
    /*1*/<-0.15137,-0.13426,0.97932>,<-0.57468,0.63861,-0.51177>,<0.73824,-0.49001,-0.46357>,
            
    /*2*/<-0.14327,-0.11507,0.98297>,<-0.66116,0.50794,-0.55215>,<0.81097,-0.37405,-0.44991>,
            
    /*3*/<-0.11366,-0.03667,0.99284>,<-0.74972,0.32831,-0.57457>,<0.86818,-0.27353,-0.41407>,
            
    /*4*/<0.33248,0.94296,0.01692>

    /* stem 0.10.23*/ 
    /*0*/<-0.22773,-0.7027,-0.67406>,
    /*1*/<-0.9698,0.21757,0.1102>,<0.547,0.48573,-0.6818>,<0.42712,-0.68998,0.58438>,
            
    /*2*/<-0.98244,0.17104,0.07455>,<0.54243,0.45941,-0.70336>,<0.44471,-0.61979,0.6466>,
            
    /*3*/<-0.99473,0.10032,0.02135>,<0.53108,0.42774,-0.73143>,<0.46524,-0.51302,0.72136>,
            
    /*4*/<0.06133,0.8508,0.5219>

    /* stem 0.10.24*/ 
    /*0*/<0.25173,-0.91752,-0.30787>,
    /*1*/<-0.2831,0.24065,-0.92841>,<0.94107,0.16613,0.2946>,<-0.66268,-0.38962,0.63957>,
            
    /*2*/<-0.27947,0.19896,-0.93932>,<0.9571,0.07976,0.27856>,<-0.68617,-0.26184,0.67868>,
            
    /*3*/<-0.26151,0.2287,-0.93771>,<0.96405,-0.15157,0.21826>,<-0.68549,-0.06645,0.72504>,
            
    /*4*/<0.25046,0.93956,0.23345>

    /* stem 0.10.25*/ 
    /*0*/<0.03675,-0.96571,0.257>,
    /*1*/<0.8444,-0.10252,-0.52581>,<0.04009,0.2633,0.96388>,<-0.88505,-0.14604,-0.44199>,
            
    /*2*/<0.84545,-0.12959,-0.51809>,<0.03994,0.28624,0.95733>,<-0.88504,-0.14197,-0.44334>,
            
    /*3*/<0.84129,-0.1943,-0.50447>,<0.03854,0.2669,0.96295>,<-0.88356,-0.05735,-0.46479>,
            
    /*4*/<0.14112,0.96484,-0.22175>

    /* stem 0.10.26*/ 
    /*0*/<-0.60927,-0.74287,0.27739>,
    /*1*/<0.66361,-0.28072,0.69341>,<-0.70733,0.66947,0.22691>,<0.05,-0.3811,-0.92318>,
            
    /*2*/<0.66513,-0.27811,0.693>,<-0.75605,0.60742,0.24379>,<0.09235,-0.31934,-0.94313>,
            
    /*3*/<0.67824,-0.25087,0.69069>,<-0.83185,0.48466,0.27044>,<0.15526,-0.22367,-0.96222>,
            
    /*4*/<0.40934,0.90605,-0.10732>

    /* stem 0.10.27*/ 
    /*0*/<-0.50559,-0.7889,-0.3493>,
    /*1*/<-0.54638,-0.01907,0.83732>,<-0.30374,0.54285,-0.78298>,<0.85193,-0.52096,-0.05309>,
            
    /*2*/<-0.52722,0.0174,0.84955>,<-0.34404,0.47735,-0.80857>,<0.8706,-0.49003,-0.04392>,
            
    /*3*/<-0.53854,-0.04089,0.84161>,<-0.3893,0.37508,-0.84129>,<0.94235,-0.33449,0.0091>,
            
    /*4*/<0.18622,0.93973,0.28676>

    /* stem 0.11*/ 
    /*0*/<0.20337,-0.86603,-0.45677>,
    /*1*/<-0.91557,0.00883,-0.40206>,<0.05063,0.48434,-0.87341>,<0.94399,0.30271,-0.1313>,
            <0.52993,-0.28504,0.7987>,<-0.61935,-0.46667,0.63137>,
    /*2*/<-0.9155,0.00895,-0.40221>,<0.06123,0.4358,-0.89796>,<0.95096,0.27266,-0.14605>,
            <0.52354,-0.25468,0.81305>,<-0.62986,-0.41769,0.65483>,
    /*3*/<-0.91507,0.00946,-0.40319>,<0.07949,0.3347,-0.93897>,<0.96241,0.21041,-0.17176>,
            <0.51297,-0.19147,0.83678>,<-0.64723,-0.31571,0.69384>,
    /*4*/<-0.11665,0.95799,0.26201>

    /* stem 0.11.0*/ 
    /*0*/<0.5687,-0.75174,-0.33387>,
    /*1*/<0.13334,0.49295,-0.85978>,<0.62904,0.14709,0.76333>,<-0.77549,-0.62271,0.10415>,
            
    /*2*/<0.13588,0.48931,-0.86146>,<0.68395,0.05288,0.72761>,<-0.83349,-0.53063,0.154>,
            
    /*3*/<0.13614,0.48383,-0.86451>,<0.76228,-0.12508,0.63504>,<-0.90536,-0.34423,0.24864>,
            
    /*4*/<-0.10109,0.87906,0.46586>

    /* stem 0.11.1*/ 
    /*0*/<0.21815,-0.97483,0.04598>,
    /*1*/<0.97381,0.22662,0.0184>,<-0.51396,-0.06684,0.8552>,<-0.46484,-0.13745,-0.87466>,
            
    /*2*/<0.97166,0.23565,0.01882>,<-0.50517,-0.10784,0.85626>,<-0.47296,-0.10592,-0.87469>,
            
    /*3*/<0.96082,0.2759,0.02659>,<-0.47311,-0.24223,0.84705>,<-0.49868,-0.01509,-0.86665>,
            
    /*4*/<-0.29949,0.92847,0.21966>

    /* stem 0.11.2*/ 
    /*0*/<-0.32539,-0.90027,-0.28919>,
    /*1*/<0.30363,-0.38174,0.87298>,<-0.92434,0.37106,-0.0889>,<0.62812,0.03115,-0.7775>,
            
    /*2*/<0.30384,-0.3791,0.87405>,<-0.94389,0.31093,-0.11133>,<0.64443,0.09047,-0.75929>,
            
    /*3*/<0.30272,-0.37899,0.87448>,<-0.95766,0.25765,-0.12846>,<0.65925,0.14218,-0.73836>,
            
    /*4*/<0.20329,0.91836,0.33953>

    /* stem 0.11.3*/ 
    /*0*/<-0.13595,-0.51274,-0.84771>,
    /*1*/<-0.83896,-0.39013,0.3794>,<-0.03387,0.86144,-0.50672>,<0.8759,-0.45972,0.14649>,
            
    /*2*/<-0.83856,-0.34544,0.4213>,<-0.04912,0.74517,-0.66506>,<0.89818,-0.37213,0.23406>,
            
    /*3*/<-0.83035,-0.26594,0.48969>,<-0.06276,0.5892,-0.80555>,<0.89346,-0.30577,0.329>,
            
    /*4*/<0.1042,0.82437,0.55638>

    /* stem 0.11.4*/ 
    /*0*/<0.44596,-0.64192,-0.62375>,
    /*1*/<-0.68241,0.21612,-0.69829>,<0.84112,0.53748,0.06026>,<-0.16874,-0.73915,0.65206>,
            
    /*2*/<-0.6665,0.18178,-0.72301>,<0.87813,0.47803,0.01919>,<-0.22101,-0.64878,0.72817>,
            
    /*3*/<-0.65999,0.19406,-0.72578>,<0.93569,0.34468,-0.07542>,<-0.27608,-0.51847,0.8093>,
            
    /*4*/<-0.17963,0.87022,0.45875>

    /* stem 0.11.5*/ 
    /*0*/<0.51484,-0.83519,-0.19338>,
    /*1*/<0.53064,0.49527,-0.68784>,<0.30939,-0.0205,0.95071>,<-0.85152,-0.45614,-0.25856>,
            
    /*2*/<0.52431,0.50814,-0.68329>,<0.34496,-0.08431,0.93482>,<-0.88068,-0.40727,-0.24194>,
            
    /*3*/<0.52513,0.50288,-0.68655>,<0.39469,-0.18306,0.90039>,<-0.93093,-0.30173,-0.20574>,
            
    /*4*/<-0.30629,0.8782,0.36736>

    /* stem 0.11.6*/ 
    /*0*/<-0.00355,-0.99953,0.03052>,
    /*1*/<0.91956,0.0161,0.39263>,<-0.80003,0.02852,0.59928>,<-0.11944,-0.0225,-0.99259>,
            
    /*2*/<0.91944,0.06895,0.38714>,<-0.80064,0.03679,0.59801>,<-0.11725,-0.0841,-0.98953>,
            
    /*3*/<0.9188,0.04752,0.39185>,<-0.80491,0.02567,0.59284>,<-0.11052,-0.05076,-0.99258>,
            
    /*4*/<0.02375,0.99917,0.03301>

    /* stem 0.11.7*/ 
    /*0*/<-0.36383,-0.7901,-0.49334>,
    /*1*/<-0.11811,-0.47935,0.86964>,<-0.73679,0.57282,-0.35918>,<0.86289,-0.07611,-0.49962>,
            
    /*2*/<-0.10908,-0.44927,0.88671>,<-0.7641,0.50695,-0.39894>,<0.87626,-0.03763,-0.48036>,
            
    /*3*/<-0.08103,-0.34653,0.93453>,<-0.79334,0.41014,-0.44989>,<0.88054,-0.0454,-0.47178>,
            
    /*4*/<0.26328,0.92117,0.28657>

    /* stem 0.11.8*/ 
    /*0*/<0.1178,-0.49314,-0.86194>,
    /*1*/<-0.97472,-0.2234,0.00304>,<0.31802,0.84436,-0.43119>,<0.65414,-0.6102,0.44695>,
            
    /*2*/<-0.97016,-0.24177,-0.01846>,<0.34345,0.78375,-0.51748>,<0.63808,-0.52901,0.55946>,
            
    /*3*/<-0.97631,-0.21594,-0.01391>,<0.36952,0.6713,-0.64251>,<0.60173,-0.43802,0.66788>,
            
    /*4*/<-0.13374,0.77127,0.6223>

    /* stem 0.11.9*/ 
    /*0*/<0.72485,-0.54317,-0.42374>,
    /*1*/<-0.30635,0.30733,-0.90094>,<0.6819,0.5302,0.50388>,<-0.39126,-0.82576,0.40624>,
            
    /*2*/<-0.30219,0.30385,-0.90352>,<0.7291,0.48995,0.47787>,<-0.44075,-0.78281,0.43927>,
            
    /*3*/<-0.28363,0.27848,-0.91761>,<0.81755,0.39356,0.42038>,<-0.54813,-0.66019,0.51352>,
            
    /*4*/<-0.46874,0.81039,0.3515>

    /* stem 0.11.10*/ 
    /*0*/<0.41409,-0.89621,0.15919>,
    /*1*/<0.84506,0.32274,-0.42627>,<-0.14063,0.11763,0.98305>,<-0.71333,-0.42111,-0.5602>,
            
    /*2*/<0.85166,0.30636,-0.42522>,<-0.11656,0.05085,0.99188>,<-0.7496,-0.3393,-0.56831>,
            
    /*3*/<0.86347,0.27099,-0.42543>,<-0.07618,-0.04674,0.996>,<-0.7954,-0.2042,-0.57065>,
            
    /*4*/<-0.23929,0.96852,0.06857>

    /* stem 0.11.11*/ 
    /*0*/<-0.2321,-0.97269,0.00245>,
    /*1*/<0.68429,-0.15418,0.71272>,<-0.93972,0.23217,0.25103>,<0.26038,-0.05725,-0.96381>,
            
    /*2*/<0.68474,-0.1483,0.71354>,<-0.95678,0.15467,0.24628>,<0.27117,0.01523,-0.96241>,
            
    /*3*/<0.68683,-0.11526,0.71762>,<-0.96894,0.0571,0.24062>,<0.28393,0.07909,-0.95558>,
            
    /*4*/<0.05169,0.99527,0.08223>

    /* stem 0.11.12*/ 
    /*0*/<-0.25295,-0.77048,-0.58513>,
    /*1*/<-0.53913,-0.38336,0.74992>,<-0.42241,0.6373,-0.64453>,<0.96689,-0.23765,-0.09302>,
            
    /*2*/<-0.54365,-0.40072,0.73748>,<-0.42775,0.61724,-0.66034>,<0.97761,-0.20015,-0.06491>,
            
    /*3*/<-0.547,-0.41404,0.72757>,<-0.44276,0.54479,-0.71216>,<0.99371,-0.11176,-0.00663>,
            
    /*4*/<0.0469,0.85136,0.52249>

    /* stem 0.11.13*/ 
    /*0*/<0.27576,-0.70717,-0.65105>,
    /*1*/<-0.92793,-0.00888,-0.37266>,<0.68429,0.62404,-0.37726>,<0.23786,-0.60034,0.76356>,
            
    /*2*/<-0.928,-0.00857,-0.37248>,<0.68792,0.61489,-0.38559>,<0.23453,-0.59131,0.77159>,
            
    /*3*/<-0.93962,0.04388,-0.33941>,<0.71938,0.51168,-0.46977>,<0.22464,-0.53545,0.81414>,
            
    /*4*/<-0.08786,0.85012,0.51921>

    /* stem 0.11.14*/ 
    /*0*/<0.53453,-0.80317,-0.26306>,
    /*1*/<0.12059,0.38815,-0.91367>,<0.65808,0.20977,0.72313>,<-0.78981,-0.58119,0.19602>,
            
    /*2*/<0.11541,0.39649,-0.91076>,<0.66898,0.19332,0.7177>,<-0.79505,-0.57296,0.19902>,
            
    /*3*/<0.14715,0.31975,-0.93601>,<0.69571,0.13362,0.70579>,<-0.86826,-0.43764,0.23365>,
            
    /*4*/<-0.27531,0.94646,0.16857>

    /* stem 0.11.15*/ 
    /*0*/<0.18807,-0.97939,0.07369>,
    /*1*/<0.98063,0.19267,-0.03519>,<-0.4747,-0.01794,0.87996>,<-0.5098,-0.15456,-0.84629>,
            
    /*2*/<0.98145,0.18852,-0.03497>,<-0.46522,-0.0811,0.88147>,<-0.52428,-0.08795,-0.84699>,
            
    /*3*/<0.98478,0.16997,-0.03618>,<-0.44987,-0.1495,0.88049>,<-0.53826,-0.00033,-0.84278>,
            
    /*4*/<-0.14395,0.98363,0.10837>

    /* stem 0.11.16*/ 
    /*0*/<-0.41414,-0.89743,-0.152>,
    /*1*/<0.32029,-0.2928,0.90093>,<-0.89466,0.43654,-0.09497>,<0.58284,-0.12538,-0.80286>,
            
    /*2*/<0.3399,-0.2119,0.91628>,<-0.94753,0.29891,-0.11336>,<0.59669,-0.06792,-0.79959>,
            
    /*3*/<0.35504,-0.10267,0.9292>,<-0.98664,0.02746,-0.16059>,<0.62177,0.09399,-0.77754>,
            
    /*4*/<-0.13453,0.98126,0.13795>

    /* stem 0.11.17*/ 
    /*0*/<-0.17198,-0.61034,-0.77324>,
    /*1*/<-0.83793,-0.31631,0.44476>,<-0.0262,0.79169,-0.61035>,<0.86761,-0.46303,0.18125>,
            
    /*2*/<-0.8361,-0.30198,0.45798>,<-0.03814,0.72975,-0.68265>,<0.88129,-0.41067,0.23383>,
            
    /*3*/<-0.83462,-0.24496,0.49336>,<-0.05808,0.53744,-0.8413>,<0.90008,-0.27093,0.34125>,
            
    /*4*/<0.01702,0.91707,0.39836>

    /* stem 0.11.18*/ 
    /*0*/<0.51543,-0.57365,-0.6366>,
    /*1*/<-0.69842,0.15859,-0.69789>,<0.77819,0.62303,0.07915>,<-0.09009,-0.77012,0.63151>,
            
    /*2*/<-0.6934,0.15124,-0.7045>,<0.82443,0.56524,0.02859>,<-0.13551,-0.70589,0.69524>,
            
    /*3*/<-0.69729,0.16769,-0.6969>,<0.89198,0.44677,-0.06902>,<-0.197,-0.59824,0.77672>,
            
    /*4*/<-0.27584,0.81759,0.50543>

    /* stem 0.11.19*/ 
    /*0*/<0.54206,-0.83719,0.07271>,
    /*1*/<0.53877,0.28798,-0.79171>,<0.28111,0.2699,0.92094>,<-0.83064,-0.54126,-0.13068>,
            
    /*2*/<0.55036,0.26697,-0.79109>,<0.30215,0.23137,0.92476>,<-0.86559,-0.48247,-0.13406>,
            
    /*3*/<0.55323,0.26646,-0.78926>,<0.35209,0.13712,0.92587>,<-0.9129,-0.3858,-0.13332>,
            
    /*4*/<-0.36665,0.92723,0.07627>

    /* stem 0.11.20*/ 
    /*0*/<-0.01152,-0.99738,0.07137>,
    /*1*/<0.93274,0.02154,0.3599>,<-0.77846,0.06027,0.6248>,<-0.15406,-0.06221,-0.9861>,
            
    /*2*/<0.92806,0.12124,0.35213>,<-0.77392,0.00328,0.63328>,<-0.14934,-0.10278,-0.98343>,
            
    /*3*/<0.91429,0.19524,0.35491>,<-0.78267,-0.02195,0.62205>,<-0.13509,-0.15414,-0.97877>,
            
    /*4*/<-0.11473,0.98082,-0.15758>

    /* stem 0.11.21*/ 
    /*0*/<-0.51822,-0.80147,-0.29849>,
    /*1*/<-0.11939,-0.2705,0.95529>,<-0.66825,0.60262,-0.43622>,<0.79771,-0.31656,-0.51328>,
            
    /*2*/<-0.13376,-0.3002,0.94445>,<-0.69353,0.5565,-0.45752>,<0.84113,-0.24003,-0.48465>,
            
    /*3*/<-0.16452,-0.37264,0.91328>,<-0.72384,0.49815,-0.47739>,<0.89733,-0.11014,-0.4274>,
            
    /*4*/<0.26052,0.85118,0.45566>

    /* stem 0.11.22*/ 
    /*0*/<0.04495,-0.68009,-0.73175>,
    /*1*/<-0.98818,-0.13469,0.07323>,<0.36517,0.69724,-0.61686>,<0.62214,-0.5495,0.55766>,
            
    /*2*/<-0.98546,-0.16123,0.05361>,<0.38149,0.62265,-0.6832>,<0.61606,-0.44714,0.64849>,
            
    /*3*/<-0.98747,-0.15059,0.04713>,<0.3923,0.48907,-0.77904>,<0.59327,-0.32103,0.73822>,
            
    /*4*/<-0.08222,0.89742,0.43344>

    /* stem 0.11.23*/ 
    /*0*/<0.52822,-0.76822,-0.36169>,
    /*1*/<-0.32504,0.21798,-0.92023>,<0.83803,0.42106,0.34701>,<-0.52299,-0.62449,0.58008>,
            
    /*2*/<-0.3199,0.20895,-0.92413>,<0.86726,0.37382,0.32882>,<-0.55629,-0.56881,0.6058>,
            
    /*3*/<-0.31156,0.19218,-0.93059>,<0.91489,0.27938,0.29141>,<-0.61001,-0.45581,0.64817>,
            
    /*4*/<-0.30037,0.91387,0.27316>

    /* stem 0.11.24*/ 
    /*0*/<0.31853,-0.94291,0.0973>,
    /*1*/<0.84118,0.24077,-0.48419>,<-0.04845,0.09282,0.9945>,<-0.79864,-0.31607,-0.51212>,
            
    /*2*/<0.85127,0.2061,-0.48255>,<-0.04261,0.07025,0.99662>,<-0.81561,-0.25894,-0.51742>,
            
    /*3*/<0.85915,0.17629,-0.4804>,<-0.0165,-0.09928,0.99492>,<-0.86277,-0.06328,-0.50162>,
            
    /*4*/<-0.06001,0.96712,0.24715>

    /* stem 0.11.25*/ 
    /*0*/<-0.30557,-0.93849,0.16085>,
    /*1*/<0.70265,-0.10251,0.70411>,<-0.90691,0.34285,0.24489>,<0.20907,-0.22556,-0.95153>,
            
    /*2*/<0.68558,-0.18272,0.70469>,<-0.9283,0.28179,0.24261>,<0.25483,-0.08149,-0.96355>,
            
    /*3*/<0.65761,-0.29012,0.69526>,<-0.96191,0.13834,0.23578>,<0.30549,0.17068,-0.93677>,
            
    /*4*/<0.1241,0.93806,0.3235>

    /* stem 0.11.26*/ 
    /*0*/<-0.29592,-0.82236,-0.48595>,
    /*1*/<-0.52684,-0.28072,0.80227>,<-0.42471,0.5715,-0.70214>,<0.9543,-0.28314,-0.09561>,
            
    /*2*/<-0.51607,-0.25389,0.81805>,<-0.4253,0.56992,-0.70307>,<0.94471,-0.30896,-0.10986>,
            
    /*3*/<-0.48291,-0.16755,0.85949>,<-0.4545,0.50696,-0.73241>,<0.93596,-0.32972,-0.12354>,
            
    /*4*/<0.35025,0.88919,0.29438>

    /* stem 0.11.27*/ 
    /*0*/<0.25037,-0.7269,-0.63948>,
    /*1*/<-0.93881,-0.01912,-0.34392>,<0.67486,0.60538,-0.422>,<0.26303,-0.5836,0.76826>,
            
    /*2*/<-0.94901,0.03828,-0.31292>,<0.71141,0.47,-0.52249>,<0.25663,-0.50266,0.82552>,
            
    /*3*/<-0.95719,0.0421,-0.2864>,<0.74031,0.23107,-0.6313>,<0.22671,-0.26888,0.93611>,
            
    /*4*/<-0.05588,0.9893,0.1348>

    /* stem 0.12*/ 
    /*0*/<0.49081,-0.86603,0.0954>,
    /*1*/<0.18582,0.00879,-0.98254>,<0.86244,0.48429,-0.14714>,<0.34032,0.30267,0.89027>,
            <-0.659,-0.28509,0.69602>,<-0.75449,-0.46671,-0.46144>,
    /*2*/<0.18599,0.0089,-0.98251>,<0.88874,0.43575,-0.14233>,<0.35625,0.27261,0.89374>,
            <-0.67442,-0.25473,0.69302>,<-0.77972,-0.41774,-0.46641>,
    /*3*/<0.18703,0.00941,-0.98231>,<0.9328,0.33465,-0.13376>,<0.38387,0.21036,0.89911>,
            <-0.69992,-0.19151,0.68806>,<-0.82164,-0.31576,-0.47456>,
    /*4*/<-0.28153,0.95799,-0.05472>

    /* stem 0.12.0*/ 
    /*0*/<0.43498,-0.70988,0.55396>,
    /*1*/<0.86789,0.49261,-0.06405>,<-0.63589,0.20234,0.74478>,<-0.24199,-0.67864,-0.69346>,
            
    /*2*/<0.90424,0.42555,-0.0354>,<-0.60746,0.12384,0.78464>,<-0.31821,-0.53771,-0.78077>,
            
    /*3*/<0.92959,0.36859,-0.00247>,<-0.51313,-0.07035,0.85542>,<-0.43826,-0.28429,-0.85271>,
            
    /*4*/<-0.37599,0.92656,0.01073>

    /* stem 0.12.1*/ 
    /*0*/<0.1328,-0.97175,0.19511>,
    /*1*/<0.20015,0.22656,0.95321>,<-0.94205,-0.17802,-0.28433>,<0.73888,-0.02641,-0.67332>,
            
    /*2*/<0.19772,0.2327,0.95224>,<-0.92445,-0.26826,-0.27099>,<0.71925,0.05492,-0.69258>,
            
    /*3*/<0.1956,0.23738,0.95152>,<-0.86623,-0.43651,-0.24313>,<0.65995,0.21771,-0.71908>,
            
    /*4*/<-0.51248,0.8531,-0.09788>

    /* stem 0.12.2*/ 
    /*0*/<0.13233,-0.86818,-0.47828>,
    /*1*/<-0.78172,-0.38201,0.49293>,<-0.13949,0.46813,-0.87258>,<0.91821,-0.06647,0.39047>,
            
    /*2*/<-0.78211,-0.38111,0.493>,<-0.12887,0.41704,-0.89971>,<0.90981,-0.01464,0.41476>,
            
    /*3*/<-0.75982,-0.44612,0.47292>,<-0.10103,0.32104,-0.94166>,<0.86203,0.14813,0.48473>,
            
    /*4*/<-0.43654,0.85613,0.27654>

    /* stem 0.12.3*/ 
    /*0*/<0.73398,-0.64762,-0.20461>,
    /*1*/<-0.55791,-0.38914,-0.73301>,<0.61287,0.76664,-0.19146>,<-0.07145,-0.36295,0.92907>,
            
    /*2*/<-0.57948,-0.36811,-0.72712>,<0.64074,0.74126,-0.19994>,<-0.07673,-0.35737,0.93081>,
            
    /*3*/<-0.62778,-0.30906,-0.71441>,<0.7533,0.61539,-0.23201>,<-0.12615,-0.28357,0.95062>,
            
    /*4*/<-0.48947,0.86465,0.11311>

    /* stem 0.12.4*/ 
    /*0*/<0.70681,-0.64394,0.29287>,
    /*1*/<0.52693,0.2161,-0.82198>,<0.13222,0.53593,0.83384>,<-0.67494,-0.73764,-0.01841>,
            
    /*2*/<0.51818,0.22724,-0.82453>,<0.19757,0.46681,0.862>,<-0.73311,-0.67923,-0.03456>,
            
    /*3*/<0.47698,0.28015,-0.83307>,<0.30503,0.34628,0.88716>,<-0.79272,-0.60711,-0.05484>,
            
    /*4*/<-0.60306,0.79738,-0.02244>

    /* stem 0.12.5*/ 
    /*0*/<0.20881,-0.77961,0.59043>,
    /*1*/<0.7903,0.49483,0.36135>,<-0.89445,0.09999,0.43584>,<0.09952,-0.57752,-0.81029>,
            
    /*2*/<0.79683,0.46902,0.38089>,<-0.89805,0.11663,0.42414>,<0.09766,-0.56768,-0.81744>,
            
    /*3*/<0.80679,0.42121,0.41433>,<-0.89673,0.0979,0.43161>,<0.08575,-0.50206,-0.86057>,
            
    /*4*/<-0.17823,0.87132,-0.45721>

    /* stem 0.12.6*/ 
    /*0*/<0.0822,-0.99634,0.02352>,
    /*1*/<-0.17654,0.01606,0.98416>,<-0.76215,-0.07069,-0.64353>,<0.93688,0.07662,-0.34115>,
            
    /*2*/<-0.17481,0.00377,0.9846>,<-0.75683,-0.11238,-0.64388>,<0.93012,0.13076,-0.34319>,
            
    /*3*/<-0.19266,0.05651,0.97964>,<-0.73242,-0.24899,-0.6337>,<0.91302,0.2106,-0.34935>,
            
    /*4*/<-0.30602,0.93555,-0.17633>

    /* stem 0.12.7*/ 
    /*0*/<0.45232,-0.85332,-0.25935>,
    /*1*/<-0.8743,-0.47891,0.07903>,<0.26623,0.4142,-0.87038>,<0.59817,0.08338,0.79702>,
            
    /*2*/<-0.86421,-0.49759,0.0745>,<0.27885,0.3928,-0.87633>,<0.57597,0.12378,0.80805>,
            
    /*3*/<-0.85925,-0.50651,0.07169>,<0.34042,0.28833,-0.89498>,<0.51494,0.24062,0.82276>,
            
    /*4*/<-0.50568,0.8622,-0.03002>

    /* stem 0.12.8*/ 
    /*0*/<0.8675,-0.49098,-0.07989>,
    /*1*/<-0.22221,-0.22343,-0.94905>,<0.48976,0.84543,0.21305>,<-0.2864,-0.61133,0.73774>,
            
    /*2*/<-0.23334,-0.21456,-0.94843>,<0.55897,0.8023,0.20943>,<-0.34097,-0.57337,0.74497>,
            
    /*3*/<-0.21996,-0.23549,-0.94666>,<0.70184,0.67984,0.21271>,<-0.50256,-0.42816,0.75107>,
            
    /*4*/<-0.58134,0.8055,-0.11496>

    /* stem 0.12.9*/ 
    /*0*/<0.57387,-0.56079,0.59682>,
    /*1*/<0.80898,0.30743,-0.50104>,<-0.32624,0.51946,0.78976>,<-0.4951,-0.81481,-0.30159>,
            
    /*2*/<0.80108,0.31599,-0.50835>,<-0.29929,0.49192,0.81758>,<-0.51526,-0.79509,-0.31991>,
            
    /*3*/<0.81972,0.28719,-0.49556>,<-0.23275,0.40292,0.88514>,<-0.61063,-0.68141,-0.4035>,
            
    /*4*/<-0.44441,0.80979,-0.38307>

    /* stem 0.12.10*/ 
    /*0*/<-0.05868,-0.89748,0.43712>,
    /*1*/<0.60542,0.32269,0.72756>,<-0.98973,0.11438,0.08572>,<0.38557,-0.41794,-0.8226>,
            
    /*2*/<0.60378,0.29129,0.74202>,<-0.98948,0.11724,0.08474>,<0.38819,-0.38921,-0.83536>,
            
    /*3*/<0.604,0.27728,0.74719>,<-0.99007,0.10588,0.09241>,<0.38729,-0.36336,-0.84734>,
            
    /*4*/<0.03831,0.92031,-0.38932>

    /* stem 0.12.11*/ 
    /*0*/<0.02327,-0.98398,-0.17678>,
    /*1*/<-0.54107,-0.15415,0.82673>,<-0.4578,0.15367,-0.87567>,<0.99838,0.02132,0.05269>,
            
    /*2*/<-0.54182,-0.11054,0.8332>,<-0.4582,0.12606,-0.87987>,<0.9987,0.00539,0.05062>,
            
    /*3*/<-0.54186,-0.1417,0.82844>,<-0.45373,0.10419,-0.88503>,<0.99626,0.05761,0.06435>,
            
    /*4*/<-0.13052,0.9749,0.18039>

    /* stem 0.12.12*/ 
    /*0*/<0.52208,-0.72686,-0.44621>,
    /*1*/<-0.85202,-0.3837,-0.35615>,<0.49644,0.68977,-0.52704>,<0.3446,-0.29079,0.89258>,
            
    /*2*/<-0.89843,-0.29639,-0.32399>,<0.56727,0.56805,-0.59626>,<0.32883,-0.2494,0.91086>,
            
    /*3*/<-0.94374,-0.17964,-0.27763>,<0.64072,0.41292,-0.64728>,<0.29706,-0.21443,0.93047>,
            
    /*4*/<-0.24033,0.92338,0.29936>

    /* stem 0.12.13*/ 
    /*0*/<0.77858,-0.61304,0.13418>,
    /*1*/<0.15385,-0.00958,-0.98805>,<0.44067,0.69524,0.56785>,<-0.61067,-0.67294,0.41742>,
            
    /*2*/<0.17252,-0.03087,-0.98452>,<0.51182,0.62414,0.59033>,<-0.70697,-0.58096,0.40333>,
            
    /*3*/<0.19022,-0.04245,-0.98082>,<0.60874,0.51213,0.60594>,<-0.80975,-0.45253,0.37354>,
            
    /*4*/<-0.50189,0.8548,-0.13199>

    /* stem 0.12.14*/ 
    /*0*/<0.3567,-0.72795,0.58554>,
    /*1*/<0.91755,0.38757,-0.08885>,<-0.60297,0.30644,0.73656>,<-0.32192,-0.67901,-0.65978>,
            
    /*2*/<0.89255,0.43468,-0.12>,<-0.56993,0.24758,0.7835>,<-0.33134,-0.66466,-0.66965>,
            
    /*3*/<0.87008,0.47058,-0.14665>,<-0.51461,0.14692,0.84474>,<-0.36781,-0.6035,-0.70747>,
            
    /*4*/<-0.47371,0.80253,-0.36269>

    /* stem 0.12.15*/ 
    /*0*/<-0.26125,-0.93162,0.25266>,
    /*1*/<0.25645,0.19227,0.94724>,<-0.93187,0.18377,-0.31279>,<0.68075,-0.35707,-0.6396>,
            
    /*2*/<0.25933,0.20012,0.94483>,<-0.92355,0.20983,-0.32097>,<0.6703,-0.39167,-0.63031>,
            
    /*3*/<0.26391,0.22078,0.93894>,<-0.91789,0.22467,-0.32711>,<0.66039,-0.42705,-0.61766>,
            
    /*4*/<0.30927,0.90061,-0.30538>

    /* stem 0.12.16*/ 
    /*0*/<0.06838,-0.90459,-0.42075>,
    /*1*/<-0.80588,-0.29283,0.5146>,<-0.10759,0.41873,-0.90172>,<0.91209,-0.10763,0.39562>,
            
    /*2*/<-0.80045,-0.32465,0.50387>,<-0.09389,0.35334,-0.93077>,<0.90017,-0.00748,0.43547>,
            
    /*3*/<-0.79817,-0.34589,0.49323>,<-0.07294,0.23184,-0.97002>,<0.8673,0.13343,0.47956>,
            
    /*4*/<-0.28915,0.93984,0.18194>

    /* stem 0.12.17*/ 
    /*0*/<0.61473,-0.76648,-0.18604>,
    /*1*/<-0.62111,-0.31534,-0.71748>,<0.72989,0.64734,-0.21958>,<-0.12101,-0.31674,0.94076>,
            
    /*2*/<-0.59516,-0.36046,-0.71822>,<0.79878,0.56042,-0.21883>,<-0.21567,-0.17816,0.96007>,
            
    /*3*/<-0.55,-0.42704,-0.71773>,<0.89455,0.3937,-0.21159>,<-0.35212,0.05437,0.93437>,
            
    /*4*/<-0.36124,0.88433,-0.29575>

    /* stem 0.12.18*/ 
    /*0*/<0.55172,-0.79471,0.25304>,
    /*1*/<0.53943,0.1173,-0.83382>,<0.273,0.46582,0.84171>,<-0.82333,-0.56741,-0.0129>,
            
    /*2*/<0.54871,0.10201,-0.82976>,<0.29219,0.43427,0.85208>,<-0.85324,-0.52086,-0.02626>,
            
    /*3*/<0.5207,0.16493,-0.83766>,<0.35958,0.32494,0.87471>,<-0.88234,-0.46901,-0.0388>,
            
    /*4*/<-0.47043,0.88214,-0.02288>

    /* stem 0.12.19*/ 
    /*0*/<0.02391,-0.80729,0.58967>,
    /*1*/<0.89279,0.28767,0.34664>,<-0.83589,0.31276,0.45108>,<-0.05737,-0.58473,-0.80919>,
            
    /*2*/<0.8934,0.22822,0.38699>,<-0.83467,0.33094,0.44022>,<-0.05419,-0.54354,-0.83763>,
            
    /*3*/<0.88671,0.10062,0.45125>,<-0.8388,0.30934,0.44802>,<-0.04327,-0.3949,-0.9177>,
            
    /*4*/<0.13066,0.94694,-0.29364>

    /* stem 0.12.20*/ 
    /*0*/<-0.15779,-0.98744,-0.00756>,
    /*1*/<-0.14031,0.02136,0.98988>,<-0.77468,0.13503,-0.61777>,<0.91803,-0.13733,-0.37196>,
            
    /*2*/<-0.13573,0.04018,0.98993>,<-0.76842,0.16362,-0.61868>,<0.90938,-0.18538,-0.37236>,
            
    /*3*/<-0.13701,0.01591,0.99044>,<-0.77219,0.10283,-0.62702>,<0.92256,-0.09753,-0.37334>,
            
    /*4*/<-0.01889,0.99927,0.03312>

    /* stem 0.12.21*/ 
    /*0*/<0.21611,-0.88884,-0.40406>,
    /*1*/<-0.9579,-0.27006,0.09742>,<0.30741,0.46043,-0.83277>,<0.64639,-0.17349,0.74303>,
            
    /*2*/<-0.97598,-0.17043,0.13572>,<0.31542,0.38788,-0.86606>,<0.64916,-0.19854,0.73429>,
            
    /*3*/<-0.984,-0.06662,0.16526>,<0.33962,0.26645,-0.90203>,<0.64598,-0.18163,0.74143>,
            
    /*4*/<-0.03445,0.97571,0.21633>

    /* stem 0.12.22*/ 
    /*0*/<0.78501,-0.60071,-0.15136>,
    /*1*/<-0.29393,-0.13528,-0.9462>,<0.61411,0.75507,0.22964>,<-0.33492,-0.60851,0.71941>,
            
    /*2*/<-0.33796,-0.08903,-0.93694>,<0.7015,0.68125,0.20927>,<-0.3683,-0.57415,0.73123>,
            
    /*3*/<-0.38625,-0.04059,-0.9215>,<0.8311,0.52802,0.17455>,<-0.45157,-0.47192,0.75722>,
            
    /*4*/<-0.47026,0.86833,0.15769>

    /* stem 0.12.23*/ 
    /*0*/<0.4906,-0.72656,0.48106>,
    /*1*/<0.82346,0.21764,-0.52397>,<-0.17727,0.46362,0.86812>,<-0.65531,-0.66775,-0.3531>,
            
    /*2*/<0.83115,0.20495,-0.5169>,<-0.15849,0.43106,0.88829>,<-0.68382,-0.62306,-0.37972>,
            
    /*3*/<0.84849,0.17071,-0.50092>,<-0.1174,0.35144,0.92882>,<-0.7432,-0.50813,-0.43527>,
            
    /*4*/<-0.32649,0.89222,-0.31201>

    /* stem 0.12.24*/ 
    /*0*/<-0.17818,-0.87347,0.45311>,
    /*1*/<0.66172,0.23909,0.71061>,<-0.96094,0.25601,0.10512>,<0.30177,-0.48262,-0.8222>,
            
    /*2*/<0.65812,0.18432,0.73>,<-0.97444,0.18486,0.12766>,<0.32119,-0.35768,-0.87687>,
            
    /*3*/<0.65307,0.10567,0.74989>,<-0.98473,0.00147,0.17408>,<0.32518,-0.09293,-0.94108>,
            
    /*4*/<-0.11808,0.993,0.00019>

    /* stem 0.12.25*/ 
    /*0*/<-0.24458,-0.93053,-0.27256>,
    /*1*/<-0.52846,-0.10468,0.84248>,<-0.43831,0.35967,-0.82372>,<0.96895,-0.24671,-0.01633>,
            
    /*2*/<-0.53956,-0.15192,0.82813>,<-0.43556,0.37401,-0.81878>,<0.9767,-0.21457,-0.00479>,
            
    /*3*/<-0.54354,-0.17653,0.82061>,<-0.44755,0.31116,-0.83838>,<0.992,-0.12535,0.01508>,
            
    /*4*/<0.06486,0.9721,0.22541>

    /* stem 0.12.26*/ 
    /*0*/<0.42869,-0.72561,-0.53825>,
    /*1*/<-0.89953,-0.28231,-0.33339>,<0.52682,0.68568,-0.50231>,<0.37101,-0.40049,0.83783>,
            
    /*2*/<-0.88142,-0.31577,-0.35127>,<0.55446,0.64441,-0.5266>,<0.32783,-0.32631,0.88659>,
            
    /*3*/<-0.88634,-0.29567,-0.35634>,<0.62571,0.50931,-0.59084>,<0.26471,-0.20748,0.94175>,
            
    /*4*/<-0.33554,0.90987,0.24405>

    /* stem 0.13*/ 
    /*0*/<0.01745,-0.86603,0.4997>,
    /*1*/<0.99916,0.00873,-0.03994>,<0.33738,0.48424,0.80727>,<-0.79089,0.30261,0.5319>,
            <-0.82642,-0.28515,-0.48551>,<0.27989,-0.46677,-0.83892>,
    /*2*/<0.99917,0.00884,-0.03977>,<0.33861,0.43569,0.83398>,<-0.79069,0.27255,0.5482>,
            <-0.82697,-0.25479,-0.5012>,<0.27906,-0.4178,-0.86462>,
    /*3*/<0.99921,0.00935,-0.03871>,<0.34017,0.33459,0.87882>,<-0.78971,0.2103,0.57631>,
            <-0.82788,-0.19158,-0.52718>,<0.27757,-0.31582,-0.90731>,
    /*4*/<-0.01001,0.95799,-0.28663>

    /* stem 0.13.0*/ 
    /*0*/<-0.44658,-0.7071,0.54824>,
    /*1*/<0.25765,0.49254,0.83127>,<-0.86664,0.20562,-0.4546>,<0.61917,-0.68204,-0.38917>,
            
    /*2*/<0.25979,0.4985,0.82705>,<-0.89697,0.15057,-0.41566>,<0.64372,-0.63446,-0.42788>,
            
    /*3*/<0.26412,0.50699,0.82049>,<-0.93119,0.07568,-0.3566>,<0.67294,-0.56526,-0.47711>,
            
    /*4*/<0.24162,0.79104,-0.56203>

    /* stem 0.13.1*/ 
    /*0*/<-0.22641,-0.97352,0.03168>,
    /*1*/<-0.88326,0.22653,0.41053>,<0.09187,-0.04598,-0.99471>,<0.79652,-0.1585,0.58347>,
            
    /*2*/<-0.87084,0.28131,0.40312>,<0.07159,-0.12203,-0.98994>,<0.80272,-0.13809,0.58015>,
            
    /*3*/<-0.85696,0.33608,0.39074>,<0.05401,-0.21723,-0.97463>,<0.80929,-0.09777,0.57921>,
            
    /*4*/<0.2596,0.93971,-0.22261>

    /* stem 0.13.2*/ 
    /*0*/<0.41564,-0.90137,0.12154>,
    /*1*/<-0.65553,-0.3818,-0.65155>,<0.87188,0.36658,-0.32473>,<-0.22571,0.03552,0.97355>,
            
    /*2*/<-0.66606,-0.34132,-0.66323>,<0.92513,0.23511,-0.29808>,<-0.24979,0.12846,0.95974>,
            
    /*3*/<-0.67816,-0.26885,-0.68397>,<0.96642,0.05513,-0.251>,<-0.28927,0.23451,0.92808>,
            
    /*4*/<-0.06655,0.95906,-0.27526>

    /* stem 0.13.3*/ 
    /*0*/<0.48439,-0.52388,0.70065>,
    /*1*/<0.58785,-0.39009,-0.7087>,<0.25891,0.85489,0.44959>,<-0.85757,-0.4531,0.24347>,
            
    /*2*/<0.55089,-0.34228,-0.76116>,<0.30217,0.80998,0.50262>,<-0.85848,-0.4517,0.24284>,
            
    /*3*/<0.48369,-0.24904,-0.83906>,<0.40648,0.66526,0.62626>,<-0.89415,-0.39389,0.21294>,
            
    /*4*/<-0.38805,0.82786,-0.40506>

    /* stem 0.13.4*/ 
    /*0*/<-0.22908,-0.40438,0.88544>,
    /*1*/<0.9202,0.2143,0.32758>,<-0.7366,0.66795,0.10612>,<-0.17851,-0.87326,-0.45337>,
            
    /*2*/<0.91054,0.18491,0.36977>,<-0.76174,0.62447,0.17262>,<-0.14844,-0.80673,-0.57197>,
            
    /*3*/<0.88021,0.1075,0.46224>,<-0.78688,0.55573,0.26831>,<-0.08473,-0.65337,-0.75228>,
            
    /*4*/<0.29369,0.76947,-0.56715>

    /* stem 0.13.5*/ 
    /*0*/<-0.47784,-0.80156,0.35939>,
    /*1*/<-0.17471,0.49495,0.85118>,<-0.6523,0.05922,-0.75565>,<0.83753,-0.5365,-0.10345>,
            
    /*2*/<-0.15616,0.52902,0.83412>,<-0.67582,0.02103,-0.73676>,<0.8402,-0.53173,-0.10637>,
            
    /*3*/<-0.1654,0.51692,0.8399>,<-0.68649,-0.00479,-0.72712>,<0.86144,-0.49364,-0.11936>,
            
    /*4*/<0.39651,0.84321,-0.36302>

    /* stem 0.13.6*/ 
    /*0*/<-0.00046,-0.98662,0.16303>,
    /*1*/<-0.99868,0.01593,0.04881>,<0.45539,-0.13815,-0.87951>,<0.5433,0.14382,0.82713>,
            
    /*2*/<-0.99804,0.0491,0.03886>,<0.45488,-0.22022,-0.8629>,<0.54695,0.1904,0.81522>,
            
    /*3*/<-0.99429,0.10551,0.01569>,<0.45036,-0.36564,-0.81454>,<0.54825,0.27854,0.78857>,
            
    /*4*/<0.10715,0.89333,-0.43645>

    /* stem 0.13.7*/ 
    /*0*/<0.48725,-0.81402,0.31615>,
    /*1*/<-0.27462,-0.47925,-0.83361>,<0.8509,0.52503,0.01755>,<-0.58686,-0.02812,0.8092>,
            
    /*2*/<-0.29727,-0.42422,-0.85537>,<0.89946,0.43417,0.04975>,<-0.60223,0.01021,0.79826>,
            
    /*3*/<-0.31675,-0.36639,-0.87489>,<0.94828,0.3,0.10378>,<-0.63633,0.08688,0.76651>,
            
    /*4*/<-0.20121,0.92502,-0.32225>

    /* stem 0.13.8*/ 
    /*0*/<0.26384,-0.51012,0.81863>,
    /*1*/<0.87483,-0.22333,-0.42989>,<-0.09201,0.8356,0.54158>,<-0.7885,-0.60128,-0.12932>,
            
    /*2*/<0.87723,-0.23365,-0.41938>,<-0.07483,0.73512,0.67379>,<-0.83583,-0.48231,-0.26221>,
            
    /*3*/<0.88364,-0.24483,-0.39904>,<-0.0455,0.52663,0.84888>,<-0.85035,-0.26122,-0.4568>,
            
    /*4*/<0.07624,0.90462,-0.41934>

    /* stem 0.13.9*/ 
    /*0*/<-0.41221,-0.61059,0.67621>,
    /*1*/<0.66987,0.30776,0.67569>,<-0.86805,0.48615,-0.10073>,<0.207,-0.78085,-0.58943>,
            
    /*2*/<0.66019,0.28627,0.69441>,<-0.90108,0.43033,-0.05356>,<0.2471,-0.7067,-0.66296>,
            
    /*3*/<0.64707,0.25817,0.71739>,<-0.94538,0.32412,0.03451>,<0.30155,-0.56663,-0.76681>,
            
    /*4*/<0.20181,0.85923,-0.47011>

    /* stem 0.13.10*/ 
    /*0*/<-0.4219,-0.90482,0.05738>,
    /*1*/<-0.57286,0.32271,0.75345>,<-0.31554,0.09506,-0.94414>,<0.89734,-0.39859,0.18947>,
            
    /*2*/<-0.57453,0.31882,0.75383>,<-0.35501,-0.03109,-0.93435>,<0.94768,-0.2736,0.16446>,
            
    /*3*/<-0.57624,0.31036,0.75606>,<-0.40617,-0.19611,-0.89251>,<0.98704,-0.09522,0.12916>,
            
    /*4*/<0.08642,0.94758,-0.3076>

    /* stem 0.13.11*/ 
    /*0*/<0.14759,-0.98689,0.06537>,
    /*1*/<-0.92703,-0.15419,-0.34181>,<0.76283,0.07866,-0.64179>,<0.1611,0.09625,0.98223>,
            
    /*2*/<-0.92665,-0.15646,-0.34182>,<0.77606,0.00087,-0.63066>,<0.15399,0.17728,0.97204>,
            
    /*3*/<-0.92665,-0.08585,-0.36598>,<0.78382,-0.16587,-0.59843>,<0.14375,0.2693,0.95227>,
            
    /*4*/<0.10196,0.95113,-0.29147>

    /* stem 0.13.12*/ 
    /*0*/<0.51003,-0.75462,0.41282>,
    /*1*/<0.15569,-0.38356,-0.9103>,<0.64887,0.65737,0.38318>,<-0.81518,-0.25811,0.51852>,
            
    /*2*/<0.1682,-0.40882,-0.89698>,<0.67627,0.6093,0.41401>,<-0.85881,-0.18307,0.47846>,
            
    /*3*/<0.16345,-0.37637,-0.91194>,<0.72534,0.50847,0.46404>,<-0.89228,-0.11447,0.43673>,
            
    /*4*/<-0.30293,0.88471,-0.3543>

    /* stem 0.13.13*/ 
    /*0*/<0.03996,-0.67629,0.73556>,
    /*1*/<0.99736,-0.00916,-0.07197>,<-0.45111,0.6494,0.6122>,<-0.54708,-0.62625,-0.55544>,
            
    /*2*/<0.9979,-0.04765,-0.04394>,<-0.45966,0.57672,0.67536>,<-0.55178,-0.51628,-0.65498>,
            
    /*3*/<0.99854,-0.04972,-0.02095>,<-0.46657,0.36679,0.80485>,<-0.54676,-0.29799,-0.78247>,
            
    /*4*/<0.01265,0.96931,-0.24553>

    /* stem 0.13.14*/ 
    /*0*/<-0.43829,-0.76188,0.47691>,
    /*1*/<0.2926,0.38778,0.87408>,<-0.87869,0.26654,-0.39605>,<0.59507,-0.63871,-0.48779>,
            
    /*2*/<0.28168,0.36527,0.88726>,<-0.89002,0.245,-0.3845>,<0.61827,-0.59525,-0.51325>,
            
    /*3*/<0.27096,0.34651,0.89806>,<-0.92839,0.15274,-0.33876>,<0.6611,-0.48385,-0.57344>,
            
    /*4*/<0.19775,0.89403,-0.402>

    /* stem 0.13.15*/ 
    /*0*/<-0.19715,-0.98007,0.02435>,
    /*1*/<-0.86601,0.19257,0.46145>,<0.03928,-0.02582,-0.99889>,<0.83073,-0.14688,0.53695>,
            
    /*2*/<-0.86852,0.17362,0.46425>,<0.03115,-0.11076,-0.99336>,<0.84955,-0.04336,0.52573>,
            
    /*3*/<-0.8683,0.19024,0.45811>,<0.0105,-0.22906,-0.97336>,<0.85819,0.05819,0.51002>,
            
    /*4*/<0.1034,0.95787,-0.26795>

    /* stem 0.13.16*/ 
    /*0*/<0.30747,-0.9452,0.10977>,
    /*1*/<-0.68188,-0.29261,-0.67039>,<0.91444,0.26945,-0.30199>,<-0.23871,0.04208,0.97018>,
            
    /*2*/<-0.67559,-0.32204,-0.66323>,<0.94065,0.18975,-0.28137>,<-0.26796,0.15597,0.95072>,
            
    /*3*/<-0.66348,-0.3782,-0.64556>,<0.96543,0.0679,-0.25166>,<-0.30559,0.33012,0.89311>,
            
    /*4*/<-0.12827,0.88731,-0.44298>

    /* stem 0.13.17*/ 
    /*0*/<0.34766,-0.7453,0.56891>,
    /*1*/<0.55919,-0.31551,-0.76665>,<0.36724,0.67147,0.64363>,<-0.93333,-0.3412,0.11175>,
            
    /*2*/<0.56963,-0.34829,-0.74446>,<0.37915,0.63525,0.67283>,<-0.96031,-0.27228,0.06055>,
            
    /*3*/<0.57222,-0.32693,-0.75212>,<0.40932,0.53931,0.73593>,<-0.98082,-0.19481,0.00684>,
            
    /*4*/<-0.1765,0.87922,-0.44252>

    /* stem 0.13.18*/ 
    /*0*/<-0.20655,-0.61138,0.76391>,
    /*1*/<0.93434,0.11605,0.33697>,<-0.72033,0.62636,0.29797>,<-0.20995,-0.73044,-0.64991>,
            
    /*2*/<0.93255,0.1091,0.34416>,<-0.73829,0.57558,0.35163>,<-0.19611,-0.67302,-0.71316>,
            
    /*3*/<0.93164,0.11837,0.34356>,<-0.77131,0.41768,0.48024>,<-0.17322,-0.52104,-0.83577>,
            
    /*4*/<0.03607,0.8965,-0.44158>

    /* stem 0.13.19*/ 
    /*0*/<-0.56733,-0.80847,0.15657>,
    /*1*/<-0.13694,0.28767,0.94789>,<-0.6287,0.31116,-0.71268>,<0.77665,-0.58314,-0.23824>,
            
    /*2*/<-0.09651,0.35665,0.92924>,<-0.68297,0.23609,-0.69124>,<0.78272,-0.57323,-0.24238>,
            
    /*3*/<-0.07946,0.37122,0.92514>,<-0.73725,0.13164,-0.66267>,<0.8307,-0.48814,-0.2677>,
            
    /*4*/<0.34877,0.90069,-0.25906>

    /* stem 0.13.20*/ 
    /*0*/<-0.0444,-0.93353,-0.35574>,
    /*1*/<-0.99597,0.02095,0.08722>,<0.43435,0.30863,-0.84622>,<0.56247,-0.31175,0.7658>,
            
    /*2*/<-0.99712,-0.01847,0.07351>,<0.4341,0.31037,-0.84571>,<0.56231,-0.27447,0.78005>,
            
    /*3*/<-0.99605,-0.06476,0.06072>,<0.42994,0.31365,-0.84663>,<0.56518,-0.23086,0.79201>,
            
    /*4*/<-0.05495,0.94692,0.31675>

    /* stem 0.13.21*/ 
    /*0*/<0.43817,-0.89063,0.12161>,
    /*1*/<-0.31037,-0.27006,-0.91145>,<0.88248,0.45665,0.1127>,<-0.58042,-0.16971,0.79644>,
            
    /*2*/<-0.32108,-0.24078,-0.91593>,<0.91176,0.39233,0.12157>,<-0.59432,-0.13324,0.79312>,
            
    /*3*/<-0.3299,-0.21116,-0.9201>,<0.94905,0.28253,0.13959>,<-0.62345,-0.05288,0.78007>,
            
    /*4*/<-0.2092,0.96568,-0.15395>

    /* stem 0.13.22*/ 
    /*0*/<0.22535,-0.76337,0.60538>,
    /*1*/<0.85646,-0.13431,-0.49843>,<-0.0304,0.62055,0.78358>,<-0.83025,-0.47204,-0.29641>,
            
    /*2*/<0.85863,-0.14366,-0.49204>,<-0.02123,0.57575,0.81735>,<-0.84483,-0.41719,-0.33499>,
            
    /*3*/<0.86759,-0.21402,-0.44886>,<-0.00877,0.5398,0.84175>,<-0.8587,-0.3126,-0.40611>,
            
    /*4*/<0.01392,0.83848,-0.54476>

    /* stem 0.13.23*/ 
    /*0*/<-0.40473,-0.67494,0.61697>,
    /*1*/<0.69604,0.21728,0.68433>,<-0.86039,0.50935,-0.01717>,<0.17181,-0.71418,-0.67855>,
            
    /*2*/<0.70325,0.24588,0.66707>,<-0.9197,0.38563,0.07383>,<0.20049,-0.62079,-0.7579>,
            
    /*3*/<0.71065,0.2389,0.66174>,<-0.95457,0.23829,0.1789>,<0.24773,-0.46251,-0.8513>,
            
    /*4*/<0.12125,0.91162,-0.39274>

    /* stem 0.13.24*/ 
    /*0*/<-0.31318,-0.94752,0.06423>,
    /*1*/<-0.54415,0.24001,0.80392>,<-0.39844,0.07538,-0.91409>,<0.94762,-0.30016,0.10914>,
            
    /*2*/<-0.55068,0.21547,0.80643>,<-0.4062,0.04567,-0.91264>,<0.96354,-0.2461,0.10504>,
            
    /*3*/<-0.56445,0.1399,0.81353>,<-0.4168,0.02337,-0.9087>,<0.98433,-0.14755,0.09658>,
            
    /*4*/<0.11112,0.99352,-0.02401>

    /* stem 0.13.25*/ 
    /*0*/<0.20933,-0.9321,-0.29558>,
    /*1*/<-0.93979,-0.10456,-0.32538>,<0.70481,0.35614,-0.61352>,<0.23303,-0.24295,0.94163>,
            
    /*2*/<-0.95076,-0.01184,-0.30971>,<0.723,0.22399,-0.65353>,<0.23258,-0.20289,0.95118>,
            
    /*3*/<-0.95379,0.0646,-0.29346>,<0.73725,0.05248,-0.67358>,<0.21819,-0.10811,0.9699>,
            
    /*4*/<0.03066,0.99817,0.05217>

    /* stem 0.13.26*/ 
    /*0*/<0.38442,-0.86993,0.30895>,
    /*1*/<0.12302,-0.2826,-0.95132>,<0.73036,0.49194,0.4739>,<-0.85427,-0.20732,0.4767>,
            
    /*2*/<0.11436,-0.26006,-0.9588>,<0.74515,0.45734,0.48538>,<-0.85925,-0.19481,0.473>,
            
    /*3*/<0.10288,-0.2221,-0.96958>,<0.77855,0.35512,0.51744>,<-0.88065,-0.12985,0.45563>,
            
    /*4*/<-0.19315,0.95534,-0.22366>

    /* stem 0.14*/ 
    /*0*/<-0.48296,-0.86603,0.12941>,
    /*1*/<0.26365,0.00868,0.96458>,<-0.71072,0.48419,0.51034>,<-0.6962,0.30256,-0.65097>,
            <0.28713,-0.2852,-0.91445>,<0.88035,-0.46682,0.08401>,
    /*2*/<0.26348,0.00879,0.96462>,<-0.73646,0.43564,0.51754>,<-0.71204,0.2725,-0.6471>,
            <0.3023,-0.25484,-0.91852>,<0.90521,-0.41785,0.07742>,
    /*3*/<0.26247,0.00929,0.9649>,<-0.7798,0.33454,0.52915>,<-0.73921,0.21025,-0.63982>,
            <0.32741,-0.19163,-0.92524>,<0.94648,-0.31587,0.06636>,
    /*4*/<0.27703,0.95799,-0.07423>

    /* stem 0.14.0*/ 
    /*0*/<-0.63404,-0.7091,-0.3085>,
    /*1*/<-0.75204,0.49254,0.43801>,<0.24582,0.20321,-0.94778>,<0.5206,-0.67965,0.51677>,
            
    /*2*/<-0.80593,0.42572,0.4114>,<0.2582,0.2227,-0.94007>,<0.5561,-0.63122,0.54066>,
            
    /*3*/<-0.86089,0.34056,0.378>,<0.2468,0.198,-0.94862>,<0.62808,-0.52135,0.57768>,
            
    /*4*/<0.41843,0.87904,0.22849>

    /* stem 0.14.1*/ 
    /*0*/<-0.20567,-0.97166,-0.11652>,
    /*1*/<-0.59777,0.22648,-0.76901>,<0.97117,-0.17895,-0.15753>,<-0.36876,-0.02564,0.92917>,
            
    /*2*/<-0.60265,0.20708,-0.77067>,<0.96585,-0.20436,-0.15928>,<-0.3585,0.01924,0.93333>,
            
    /*3*/<-0.6219,0.11769,-0.7742>,<0.97222,-0.16465,-0.16635>,<-0.34519,0.06869,0.93602>,
            
    /*4*/<0.10277,0.99417,-0.03278>

    /* stem 0.14.2*/ 
    /*0*/<0.0242,-0.8892,0.45688>,
    /*1*/<0.48702,-0.38194,-0.78545>,<0.51219,0.41006,0.75466>,<-0.99975,-0.00825,0.02058>,
            
    /*2*/<0.48908,-0.34834,-0.79966>,<0.51282,0.34298,0.78701>,<-0.99962,0.02653,0.00712>,
            
    /*3*/<0.48733,-0.3731,-0.7895>,<0.51017,0.29625,0.80744>,<-0.99498,0.09575,-0.02902>,
            
    /*4*/<0.13151,0.8931,-0.4302>

    /* stem 0.14.3*/ 
    /*0*/<-0.56125,-0.7037,0.43567>,
    /*1*/<0.82266,-0.38879,0.41482>,<-0.51121,0.71422,0.47807>,<-0.29899,-0.30981,-0.90256>,
            
    /*2*/<0.83529,-0.36975,0.40691>,<-0.55788,0.65387,0.51111>,<-0.27028,-0.26476,-0.92566>,
            
    /*3*/<0.85651,-0.3302,0.39669>,<-0.66449,0.48365,0.56969>,<-0.19525,-0.13009,-0.97209>,
            
    /*4*/<0.38322,0.91808,-0.10139>

    /* stem 0.14.4*/ 
    /*0*/<-0.90475,-0.42555,-0.01825>,
    /*1*/<-0.1123,0.21443,0.97026>,<-0.28805,0.65949,-0.69433>,<0.42032,-0.86453,-0.27553>,
            
    /*2*/<-0.1265,0.204,0.97076>,<-0.39878,0.5864,-0.70506>,<0.55048,-0.78498,-0.28421>,
            
    /*3*/<-0.10593,0.23733,0.96564>,<-0.58156,0.43942,-0.68461>,<0.69575,-0.65825,-0.28746>,
            
    /*4*/<0.60628,0.7756,-0.17569>

    /* stem 0.14.5*/ 
    /*0*/<-0.43726,-0.76164,-0.47823>,
    /*1*/<-0.86883,0.49463,0.02192>,<0.62961,0.12917,-0.7661>,<0.24881,-0.60709,0.75468>,
            
    /*2*/<-0.87704,0.4802,0.01469>,<0.60777,0.0851,-0.78954>,<0.28198,-0.55013,0.78603>,
            
    /*3*/<-0.85264,0.52194,0.02415>,<0.53534,-0.03286,-0.844>,<0.32853,-0.47033,0.81906>,
            
    /*4*/<0.56492,0.79832,0.20869>

    /* stem 0.14.6*/ 
    /*0*/<0.1632,-0.98504,-0.05532>,
    /*1*/<-0.27455,0.01587,-0.96144>,<0.95644,0.15182,0.24935>,<-0.68543,-0.14626,0.71329>,
            
    /*2*/<-0.2703,-0.02525,-0.96244>,<0.95949,0.13045,0.24972>,<-0.69487,-0.08373,0.71424>,
            
    /*3*/<-0.27114,-0.09413,-0.95793>,<0.96367,-0.01253,0.26681>,<-0.69335,0.13389,0.70806>,
            
    /*4*/<0.19897,0.96171,-0.18848>

    /* stem 0.14.7*/ 
    /*0*/<-0.14201,-0.78274,0.60592>,
    /*1*/<0.75006,-0.47951,-0.45551>,<0.1869,0.58576,0.78864>,<-0.93389,-0.08937,-0.3462>,
            
    /*2*/<0.74665,-0.49078,-0.44905>,<0.15062,0.48522,0.86132>,<-0.90774,0.0326,-0.41827>,
            
    /*3*/<0.76556,-0.45809,-0.45174>,<0.09714,0.31617,0.94372>,<-0.85352,0.16037,-0.49577>,
            
    /*4*/<0.33379,0.90624,-0.25944>

    /* stem 0.14.8*/ 
    /*0*/<-0.76615,-0.41244,0.49286>,
    /*1*/<0.61584,-0.22404,0.75534>,<-0.47388,0.88048,-0.01434>,<-0.12554,-0.64759,-0.75158>,
            
    /*2*/<0.66513,-0.1831,0.72393>,<-0.57399,0.81707,0.05404>,<-0.08629,-0.61367,-0.78483>,
            
    /*3*/<0.7368,-0.1133,0.66655>,<-0.73599,0.65328,0.17763>,<-0.00166,-0.52038,-0.85393>,
            
    /*4*/<0.43678,0.80438,-0.40275>

    /* stem 0.14.9*/ 
    /*0*/<-0.75355,-0.60714,-0.25208>,
    /*1*/<-0.5077,0.30772,0.80471>,<-0.09406,0.48859,-0.86743>,<0.6178,-0.78338,0.06809>,
            
    /*2*/<-0.53609,0.28383,0.79502>,<-0.08811,0.49415,-0.8649>,<0.63947,-0.76496,0.07684>,
            
    /*3*/<-0.59455,0.22778,0.77112>,<-0.11322,0.45844,-0.88148>,<0.72825,-0.67523,0.11712>,
            
    /*4*/<0.55699,0.78638,0.26714>

    /* stem 0.14.10*/ 
    /*0*/<-0.18338,-0.92223,-0.34039>,
    /*1*/<-0.86278,0.3228,-0.38911>,<0.83925,0.04087,-0.5422>,<0.0274,-0.34421,0.93849>,
            
    /*2*/<-0.87523,0.25777,-0.4093>,<0.83995,0.04858,-0.54048>,<0.03427,-0.28657,0.95745>,
            
    /*3*/<-0.88739,0.17829,-0.42514>,<0.83304,0.006,-0.55319>,<0.05909,-0.16422,0.98465>,
            
    /*4*/<0.12915,0.98687,0.09702>

    /* stem 0.14.11*/ 
    /*0*/<0.01384,-0.98635,0.16405>,
    /*1*/<0.1242,-0.15425,-0.98019>,<0.79696,0.11679,0.59264>,<-0.92145,0.058,0.38414>,
            
    /*2*/<0.12885,-0.09585,-0.98702>,<0.79729,0.03407,0.60264>,<-0.92008,0.08153,0.38316>,
            
    /*3*/<0.13152,-0.07716,-0.98831>,<0.78711,-0.04648,0.61506>,<-0.91741,0.14417,0.37091>,
            
    /*4*/<0.14739,0.98353,-0.10465>

    /* stem 0.14.12*/ 
    /*0*/<-0.25056,-0.67973,0.68934>,
    /*1*/<0.92172,-0.38413,-0.05371>,<-0.19734,0.73766,0.64569>,<-0.71921,-0.33953,-0.60618>,
            
    /*2*/<0.94251,-0.31568,-0.10963>,<-0.21429,0.66858,0.7121>,<-0.71868,-0.33447,-0.60962>,
            
    /*3*/<0.94989,-0.2753,-0.14806>,<-0.24888,0.55015,0.79712>,<-0.70254,-0.2579,-0.66327>,
            
    /*4*/<0.22382,0.86385,-0.45129>

    /* stem 0.14.13*/ 
    /*0*/<-0.78326,-0.5781,0.22868>,
    /*1*/<0.29492,-0.0099,0.95547>,<-0.61589,0.71736,-0.32569>,<0.33691,-0.69569,-0.63443>,
            
    /*2*/<0.30499,0.00163,0.95235>,<-0.69789,0.64775,-0.30557>,<0.40192,-0.63467,-0.66004>,
            
    /*3*/<0.32072,0.02083,0.94695>,<-0.8216,0.50568,-0.26317>,<0.50887,-0.51004,-0.69348>,
            
    /*4*/<0.47664,0.85974,-0.18348>

    /* stem 0.14.14*/ 
    /*0*/<-0.52509,-0.82576,-0.20591>,
    /*1*/<-0.78616,0.38814,0.48093>,<0.12368,0.17317,-0.9771>,<0.6731,-0.54461,0.50033>,
            
    /*2*/<-0.76014,0.4333,0.48419>,<0.06699,0.08401,-0.99421>,<0.70348,-0.50139,0.50371>,
            
    /*3*/<-0.76929,0.41177,0.4885>,<0.02295,0.01551,-0.99962>,<0.7533,-0.40906,0.51498>,
            
    /*4*/<0.40787,0.91212,0.0409>

    /* stem 0.14.15*/ 
    /*0*/<-0.06781,-0.98005,-0.18684>,
    /*1*/<-0.64445,0.19245,-0.74003>,<0.98214,-0.02565,-0.1864>,<-0.33634,-0.14728,0.93015>,
            
    /*2*/<-0.64708,0.1399,-0.74948>,<0.98317,0.00527,-0.18263>,<-0.33646,-0.12546,0.9333>,
            
    /*3*/<-0.64983,0.14338,-0.74644>,<0.98126,-0.01706,-0.19195>,<-0.32978,-0.10626,0.93806>,
            
    /*4*/<0.1104,0.98097,0.15972>

    /* stem 0.14.16*/ 
    /*0*/<-0.03112,-0.94416,0.328>,
    /*1*/<0.49977,-0.29271,-0.8152>,<0.50014,0.27566,0.8209>,<-0.99929,0.03568,-0.01217>,
            
    /*2*/<0.51016,-0.21607,-0.83249>,<0.49679,0.16005,0.85299>,<-0.99712,0.07366,-0.01776>,
            
    /*3*/<0.51362,-0.20449,-0.83329>,<0.48469,0.10379,0.86851>,<-0.99213,0.11892,-0.03918>,
            
    /*4*/<0.1269,0.96094,-0.24597>

    /* stem 0.14.17*/ 
    /*0*/<-0.38015,-0.83004,0.40807>,
    /*1*/<0.9032,-0.22663,0.36451>,<-0.62982,0.5606,0.53764>,<-0.26597,-0.31779,-0.91009>,
            
    /*2*/<0.8797,-0.27601,0.38723>,<-0.6216,0.5754,0.53153>,<-0.24755,-0.2849,-0.92604>,
            
    /*3*/<0.83415,-0.36743,0.41134>,<-0.67043,0.50085,0.54743>,<-0.16237,-0.11045,-0.98053>,
            
    /*4*/<0.46696,0.8839,-0.02594>

    /* stem 0.14.18*/ 
    /*0*/<-0.69547,-0.71853,-0.00532>,
    /*1*/<-0.11886,0.11666,0.98603>,<-0.54693,0.54301,-0.63719>,<0.67915,-0.64586,-0.34874>,
            
    /*2*/<-0.08365,0.1721,0.98152>,<-0.64559,0.42757,-0.63277>,<0.72783,-0.58254,-0.36182>,
            
    /*3*/<-0.04439,0.21996,0.9745>,<-0.75236,0.25494,-0.60742>,<0.80578,-0.45929,-0.37386>,
            
    /*4*/<0.36731,0.9131,-0.177>

    /* stem 0.14.19*/ 
    /*0*/<-0.28913,-0.87183,-0.39536>,
    /*1*/<-0.95438,0.28796,0.07895>,<0.51893,0.21085,-0.82841>,<0.44095,-0.48224,0.75697>,
            
    /*2*/<-0.95484,0.28665,0.07814>,<0.50084,0.14651,-0.85305>,<0.46446,-0.41765,0.78093>,
            
    /*3*/<-0.96172,0.2639,0.07384>,<0.46779,0.04612,-0.88264>,<0.50123,-0.29286,0.81425>,
            
    /*4*/<0.24346,0.96143,0.12796>

    /* stem 0.14.20*/ 
    /*0*/<0.28841,-0.9514,-0.10802>,
    /*1*/<-0.30869,0.02096,-0.95093>,<0.9371,0.26483,0.22737>,<-0.63382,-0.26794,0.72558>,
            
    /*2*/<-0.31909,0.05915,-0.94588>,<0.94612,0.23502,0.22276>,<-0.63166,-0.27594,0.72447>,
            
    /*3*/<-0.32481,0.09543,-0.94095>,<0.96408,0.15452,0.21603>,<-0.64221,-0.23209,0.73055>,
            
    /*4*/<-0.12841,0.98259,0.13425>

    /* stem 0.14.21*/ 
    /*0*/<0.02507,-0.85962,0.51032>,
    /*1*/<0.81799,-0.27039,-0.50772>,<0.08825,0.51568,0.85222>,<-0.9067,-0.22939,-0.35394>,
            
    /*2*/<0.81844,-0.26076,-0.51201>,<0.08735,0.45854,0.88437>,<-0.90801,-0.18028,-0.37818>,
            
    /*3*/<0.80863,-0.31748,-0.4953>,<0.07511,0.34861,0.93426>,<-0.89116,-0.01203,-0.45353>,
            
    /*4*/<0.2738,0.91527,-0.2955>

    /* stem 0.14.22*/ 
    /*0*/<-0.51053,-0.79705,0.32262>,
    /*1*/<0.67809,-0.13417,0.72263>,<-0.79568,0.58334,0.16311>,<0.12695,-0.43456,-0.89165>,
            
    /*2*/<0.67806,-0.13358,0.72277>,<-0.83384,0.52089,0.1827>,<0.16044,-0.3712,-0.91459>,
            
    /*3*/<0.69057,-0.09717,0.71671>,<-0.89177,0.39631,0.21836>,<0.20477,-0.28164,-0.93742>,
            
    /*4*/<0.28785,0.93753,-0.19541>

    /* stem 0.14.23*/ 
    /*0*/<-0.70816,-0.65182,-0.27138>,
    /*1*/<-0.51095,0.21638,0.83193>,<-0.158,0.52698,-0.83507>,<0.67953,-0.73361,0.00719>,
            
    /*2*/<-0.46506,0.26328,0.84522>,<-0.21617,0.47591,-0.85252>,<0.68821,-0.72546,0.00864>,
            
    /*3*/<-0.42845,0.29156,0.85523>,<-0.31541,0.36806,-0.87467>,<0.75854,-0.65141,0.01694>,
            
    /*4*/<0.58383,0.81059,0.04566>

    /* stem 0.14.24*/ 
    /*0*/<-0.0123,-0.8453,-0.53415>,
    /*1*/<-0.9064,0.23805,-0.34896>,<0.81884,0.30122,-0.48864>,<0.0877,-0.52992,0.8435>,
            
    /*2*/<-0.90809,0.16675,-0.38415>,<0.81999,0.28488,-0.49646>,<0.08314,-0.44431,0.89201>,
            
    /*3*/<-0.9054,0.14237,-0.39998>,<0.81805,0.20204,-0.53849>,<0.08932,-0.33337,0.93856>,
            
    /*4*/<0.06403,0.9484,0.31054>

    /* stem 0.14.25*/ 
    /*0*/<0.36871,-0.91899,0.13967>,
    /*1*/<0.10609,-0.10599,-0.98869>,<0.74577,0.3837,0.5446>,<-0.85361,-0.27337,0.44343>,
            
    /*2*/<0.10577,-0.10491,-0.98884>,<0.7573,0.35251,0.54976>,<-0.86472,-0.24307,0.43952>,
            
    /*3*/<0.12402,-0.17714,-0.97634>,<0.76672,0.32785,0.55195>,<-0.89541,-0.14821,0.41985>,
            
    /*4*/<-0.20966,0.93791,-0.27633>

    /* stem 0.15*/ 
    /*0*/<-0.23474,-0.86603,-0.44147>,
    /*1*/<-0.88056,0.00864,0.47385>,<-0.65715,0.48415,-0.57772>,<0.47766,0.30252,-0.82482>,
            <0.95559,-0.28524,0.07404>,<0.11617,-0.46686,0.87667>,
    /*2*/<-0.88064,0.00875,0.4737>,<-0.66995,0.4356,-0.60118>,<0.47033,0.27246,-0.83938>,
            <0.96297,-0.25488,0.08792>,<0.12819,-0.41789,0.89941>,
    /*3*/<-0.88113,0.00925,0.47278>,<-0.69101,0.3345,-0.64079>,<0.45713,0.21021,-0.8642>,
            <0.97518,-0.19167,0.11087>,<0.14824,-0.31592,0.93713>,
    /*4*/<0.13465,0.95799,0.25323>

    /* stem 0.15.0*/ 
    /*0*/<0.30884,-0.59592,-0.74128>,
    /*1*/<-0.59708,0.49165,-0.63386>,<0.93781,0.31373,0.14864>,<-0.34769,-0.79195,0.50192>,
            
    /*2*/<-0.5961,0.49012,-0.63597>,<0.96765,0.24082,0.07527>,<-0.37002,-0.72211,0.5845>,
            
    /*3*/<-0.59661,0.45422,-0.66162>,<0.98946,0.14134,-0.03157>,<-0.39694,-0.58054,0.71092>,
            
    /*4*/<-0.05285,0.83515,0.54748>

    /* stem 0.15.1*/ 
    /*0*/<0.18003,-0.97425,-0.13572>,
    /*1*/<0.61399,0.22646,-0.75613>,<0.35557,-0.05658,0.93294>,<-0.9736,-0.14803,-0.17377>,
            
    /*2*/<0.61275,0.23846,-0.75344>,<0.36397,-0.11169,0.92469>,<-0.98063,-0.10573,-0.16486>,
            
    /*3*/<0.6129,0.26965,-0.74273>,<0.37507,-0.26746,0.88757>,<-0.99137,0.01524,-0.13022>,
            
    /*4*/<0.03947,0.9219,0.38541>

    /* stem 0.15.2*/ 
    /*0*/<-0.43385,-0.89527,0.10131>,
    /*1*/<0.87482,-0.38192,0.29804>,<-0.63015,0.38966,0.67162>,<-0.23501,0.01219,-0.97192>,
            
    /*2*/<0.91034,-0.28922,0.29602>,<-0.66801,0.29034,0.68517>,<-0.23363,0.01936,-0.97213>,
            
    /*3*/<0.93985,-0.17094,0.29575>,<-0.71552,0.16229,0.67948>,<-0.22015,0.03017,-0.975>,
            
    /*4*/<0.16469,0.98631,-0.00796>

    /* stem 0.15.3*/ 
    /*0*/<-0.64991,-0.62155,-0.43738>,
    /*1*/<-0.21842,-0.38941,0.89479>,<-0.51275,0.78793,-0.34095>,<0.74554,-0.38478,-0.54417>,
            
    /*2*/<-0.25024,-0.4265,0.86919>,<-0.52908,0.77054,-0.35546>,<0.79722,-0.33255,-0.50383>,
            
    /*3*/<-0.26555,-0.40619,0.87435>,<-0.63168,0.61524,-0.47166>,<0.89139,-0.18277,-0.41474>,
            
    /*4*/<0.24791,0.87662,0.41241>

    /* stem 0.15.4*/ 
    /*0*/<-0.17817,-0.38009,-0.90763>,
    /*1*/<-0.97072,0.21409,0.10897>,<0.61972,0.67696,-0.39708>,<0.35491,-0.8827,0.30804>,
            
    /*2*/<-0.98045,0.18422,0.06914>,<0.61253,0.61353,-0.49838>,<0.39011,-0.79795,0.45945>,
            
    /*3*/<-0.99006,0.14056,0.00585>,<0.57877,0.52888,-0.62074>,<0.41466,-0.65554,0.63113>,
            
    /*4*/<0.07889,0.75242,0.65394>

    /* stem 0.15.5*/ 
    /*0*/<0.10839,-0.84839,-0.51816>,
    /*1*/<-0.2149,0.49523,-0.84176>,<0.94696,-0.06291,0.31513>,<-0.73443,-0.41381,0.53794>,
            
    /*2*/<-0.20999,0.42276,-0.88158>,<0.94664,-0.05692,0.31724>,<-0.74424,-0.34602,0.5713>,
            
    /*3*/<-0.2091,0.35875,-0.90971>,<0.94966,-0.05973,0.30754>,<-0.74163,-0.27891,0.61007>,
            
    /*4*/<-0.04389,0.92392,0.38005>

    /* stem 0.15.6*/ 
    /*0*/<-0.03902,-0.99529,-0.08877>,
    /*1*/<0.87598,0.01592,-0.48209>,<-0.02081,-0.0808,0.99651>,<-0.85432,0.08646,-0.5125>,
            
    /*2*/<0.87755,0.04501,-0.47738>,<-0.02241,-0.13117,0.99111>,<-0.85408,0.10713,-0.509>,
            
    /*3*/<0.87885,0.06037,-0.47327>,<-0.03078,-0.21751,0.97557>,<-0.8489,0.17847,-0.49752>,
            
    /*4*/<0.09947,0.95968,0.2629>

    /* stem 0.15.7*/ 
    /*0*/<-0.50116,-0.84847,-0.17009>,
    /*1*/<0.61168,-0.47904,0.62957>,<-0.83362,0.4318,0.34443>,<0.23273,0.06552,-0.97033>,
            
    /*2*/<0.59769,-0.50366,0.62377>,<-0.83783,0.42489,0.34278>,<0.25175,0.09663,-0.96296>,
            
    /*3*/<0.59803,-0.49837,0.62768>,<-0.89859,0.31236,0.30817>,<0.29783,0.20792,-0.9317>,
            
    /*4*/<0.2915,0.87991,0.37522>

    /* stem 0.15.8*/ 
    /*0*/<-0.59382,-0.51353,-0.61941>,
    /*1*/<-0.59789,-0.22334,0.76984>,<-0.15689,0.83377,-0.52935>,<0.76745,-0.59947,-0.22726>,
            
    /*2*/<-0.58671,-0.21008,0.78207>,<-0.20092,0.79127,-0.57752>,<0.80039,-0.56651,-0.19607>,
            
    /*3*/<-0.57128,-0.19214,0.79795>,<-0.27294,0.70642,-0.65305>,<0.85593,-0.49884,-0.13616>,
            
    /*4*/<0.45714,0.73305,0.50365>

    /* stem 0.15.9*/ 
    /*0*/<0.08598,-0.59023,-0.80264>,
    /*1*/<-0.89836,0.30758,-0.31361>,<0.82237,0.50027,-0.27099>,<0.07416,-0.79534,0.60161>,
            
    /*2*/<-0.89666,0.35732,-0.26139>,<0.82614,0.42355,-0.37162>,<0.07907,-0.76309,0.64143>,
            
    /*3*/<-0.89492,0.39716,-0.20345>,<0.80103,0.23857,-0.54903>,<0.11429,-0.62745,0.77022>,
            
    /*4*/<0.25212,0.84034,0.47986>

    /* stem 0.15.10*/ 
    /*0*/<0.18881,-0.94066,-0.28196>,
    /*1*/<0.18577,0.32289,-0.92803>,<0.73998,-0.0452,0.6711>,<-0.92972,-0.25796,0.26283>,
            
    /*2*/<0.18137,0.33896,-0.92315>,<0.73465,-0.02464,0.678>,<-0.92168,-0.2953,0.25162>,
            
    /*3*/<0.19123,0.30078,-0.93433>,<0.73213,-0.03431,0.6803>,<-0.93373,-0.24687,0.25924>,
            
    /*4*/<-0.10783,0.96957,0.21979>

    /* stem 0.15.11*/ 
    /*0*/<-0.12631,-0.94855,0.29034>,
    /*1*/<0.9828,-0.15453,-0.10113>,<-0.36815,0.32316,0.8718>,<-0.61202,-0.14894,-0.77669>,
            
    /*2*/<0.99174,-0.0587,-0.11404>,<-0.37583,0.19089,0.90681>,<-0.61326,-0.11253,-0.78182>,
            
    /*3*/<0.99197,0.02478,-0.12399>,<-0.39151,0.01763,0.92001>,<-0.60309,-0.02198,-0.79737>,
            
    /*4*/<-0.00091,0.99952,0.03108>

    /* stem 0.15.12*/ 
    /*0*/<-0.50867,-0.83257,-0.21928>,
    /*1*/<0.25816,-0.3831,0.8869>,<-0.83609,0.54176,-0.0863>,<0.58837,-0.14158,-0.7961>,
            
    /*2*/<0.25857,-0.38108,0.88765>,<-0.87394,0.47371,-0.10881>,<0.62243,-0.07255,-0.77931>,
            
    /*3*/<0.26158,-0.36692,0.89272>,<-0.91541,0.37893,-0.13579>,<0.66,0.0065,-0.75124>,
            
    /*4*/<0.29978,0.91196,0.28012>

    /* stem 0.15.13*/ 
    /*0*/<-0.39435,-0.59069,-0.70397>,
    /*1*/<-0.86468,-0.00982,0.50223>,<0.17343,0.70958,-0.68294>,<0.69925,-0.68776,0.195>,
            
    /*2*/<-0.87044,-0.02126,0.49182>,<0.14657,0.65242,-0.74355>,<0.74011,-0.61899,0.26283>,
            
    /*3*/<-0.87868,-0.03754,0.47594>,<0.08945,0.48166,-0.87178>,<0.81183,-0.42683,0.39844>,
            
    /*4*/<0.14129,0.92082,0.3635>

    /* stem 0.15.14*/ 
    /*0*/<0.32095,-0.65007,-0.68877>,
    /*1*/<-0.64705,0.38694,-0.65696>,<0.92096,0.38164,0.07869>,<-0.28037,-0.75548,0.59215>,
            
    /*2*/<-0.64649,0.386,-0.65807>,<0.93039,0.36182,0.05883>,<-0.28941,-0.73473,0.61353>,
            
    /*3*/<-0.6438,0.38324,-0.66231>,<0.97168,0.23318,-0.03828>,<-0.31974,-0.60837,0.72639>,
            
    /*4*/<-0.03985,0.85486,0.51732>

    /* stem 0.15.15*/ 
    /*0*/<0.28039,-0.95966,-0.02088>,
    /*1*/<0.57535,0.1923,-0.79498>,<0.37372,0.09602,0.92256>,<-0.95464,-0.26925,-0.12716>,
            
    /*2*/<0.58726,0.15327,-0.79476>,<0.36457,0.1312,0.92189>,<-0.95577,-0.26501,-0.12758>,
            
    /*3*/<0.61359,0.01411,-0.7895>,<0.35645,0.18079,0.91665>,<-0.97438,-0.17755,-0.13805>,
            
    /*4*/<-0.07341,0.98206,-0.1737>

    /* stem 0.15.16*/ 
    /*0*/<-0.37776,-0.89245,0.24664>,
    /*1*/<0.90705,-0.29309,0.30225>,<-0.62083,0.44791,0.64339>,<-0.27882,-0.13734,-0.95047>,
            
    /*2*/<0.88651,-0.34683,0.3063>,<-0.65754,0.37845,0.65147>,<-0.22522,-0.00968,-0.97426>,
            
    /*3*/<0.83986,-0.44619,0.3091>,<-0.68459,0.29732,0.66553>,<-0.14494,0.16537,-0.97552>,
            
    /*4*/<0.48244,0.86678,0.12627>

    /* stem 0.15.17*/ 
    /*0*/<-0.49787,-0.8212,-0.27886>,
    /*1*/<-0.15191,-0.22672,0.96204>,<-0.65816,0.5728,-0.4886>,<0.81971,-0.33017,-0.46804>,
            
    /*2*/<-0.15282,-0.22761,0.96169>,<-0.69771,0.49398,-0.51882>,<0.86009,-0.24773,-0.44595>,
            
    /*3*/<-0.16324,-0.27431,0.94768>,<-0.74569,0.35799,-0.56195>,<0.92128,-0.06448,-0.38351>,
            
    /*4*/<0.09942,0.93295,0.346>

    /* stem 0.15.18*/ 
    /*0*/<-0.14761,-0.56701,-0.81038>,
    /*1*/<-0.98752,0.11569,0.10683>,<0.52391,0.65431,-0.54534>,<0.46645,-0.75911,0.45407>,
            
    /*2*/<-0.9987,0.0429,0.02761>,<0.52397,0.63996,-0.56206>,<0.47261,-0.6805,0.55996>,
            
    /*3*/<-0.99754,-0.02901,-0.06384>,<0.52944,0.56796,-0.63017>,<0.47327,-0.52479,0.70754>,
            
    /*4*/<-0.07397,0.82936,0.5538>

    /* stem 0.15.19*/ 
    /*0*/<0.36617,-0.85009,-0.3785>,
    /*1*/<-0.29191,0.28783,-0.91211>,<0.90832,0.24909,0.33602>,<-0.62337,-0.52076,0.58328>,
            
    /*2*/<-0.26635,0.23349,-0.93517>,<0.88997,0.29144,0.35073>,<-0.63016,-0.50746,0.58769>,
            
    /*3*/<-0.24037,0.16977,-0.95572>,<0.8865,0.29724,0.35463>,<-0.65371,-0.4508,0.60782>,
            
    /*4*/<-0.34503,0.90905,0.23363>

    /* stem 0.15.20*/ 
    /*0*/<0.09246,-0.98774,0.12576>,
    /*1*/<0.85761,0.02116,-0.51387>,<0.0076,0.13319,0.99106>,<-0.86693,-0.13591,-0.47954>,
            
    /*2*/<0.8583,0.01102,-0.51303>,<0.00932,0.09714,0.99523>,<-0.8706,-0.08963,-0.48376>,
            
    /*3*/<0.85849,-0.01002,-0.51273>,<0.01133,0.00446,0.99993>,<-0.87341,0.02449,-0.48638>,
            
    /*4*/<0.06592,0.99617,0.05753>

    /* stem 0.15.21*/ 
    /*0*/<-0.51423,-0.8408,0.16917>,
    /*1*/<0.67885,-0.27052,0.68263>,<-0.79211,0.54647,0.2719>,<0.12275,-0.26044,-0.95766>,
            
    /*2*/<0.67551,-0.27678,0.68343>,<-0.83257,0.47872,0.27866>,<0.16187,-0.18411,-0.96948>,
            
    /*3*/<0.67394,-0.27537,0.68555>,<-0.88807,0.35912,0.28698>,<0.21897,-0.06611,-0.97349>,
            
    /*4*/<0.33081,0.94233,0.05077>

    /* stem 0.15.22*/ 
    /*0*/<-0.48395,-0.74836,-0.4536>,
    /*1*/<-0.55125,-0.1345,0.82342>,<-0.30646,0.63572,-0.70848>,<0.86653,-0.48759,-0.10669>,
            
    /*2*/<-0.50615,-0.04654,0.86119>,<-0.37207,0.5402,-0.75481>,<0.8751,-0.47294,-0.10255>,
            
    /*3*/<-0.44709,0.05905,0.89254>,<-0.46128,0.34951,-0.81552>,<0.91612,-0.39244,-0.08191>,
            
    /*4*/<0.3346,0.93812,0.08924>

    /* stem 0.15.23*/ 
    /*0*/<0.01166,-0.81146,-0.5843>,
    /*1*/<-0.92508,0.21703,-0.31165>,<0.79128,0.36858,-0.48787>,<0.13363,-0.57393,0.80793>,
            
    /*2*/<-0.92198,0.25244,-0.29364>,<0.78981,0.27029,-0.55059>,<0.14266,-0.51134,0.84745>,
            
    /*3*/<-0.92441,0.24999,-0.28803>,<0.77589,0.15409,-0.61176>,<0.14958,-0.3918,0.90781>,
            
    /*4*/<0.10216,0.93874,0.32915>

    /* stem 0.15.24*/ 
    /*0*/<0.40739,-0.89894,-0.16106>,
    /*1*/<0.13679,0.23765,-0.96167>,<0.71157,0.20546,0.67191>,<-0.85206,-0.43496,0.29122>,
            
    /*2*/<0.13971,0.22909,-0.96333>,<0.73328,0.14733,0.66378>,<-0.87782,-0.36918,0.30519>,
            
    /*3*/<0.14743,0.19929,-0.96879>,<0.75596,0.08471,0.64912>,<-0.90617,-0.27547,0.32091>,
            
    /*4*/<-0.21701,0.9661,0.13989>

    /* stem 0.15.25*/ 
    /*0*/<-0.08647,-0.98168,0.1698>,
    /*1*/<0.98723,-0.10637,-0.11861>,<-0.37699,0.19108,0.90629>,<-0.60995,-0.0815,-0.78824>,
            
    /*2*/<0.989,-0.07829,-0.12547>,<-0.3764,0.21618,0.90088>,<-0.61369,-0.13527,-0.77787>,
            
    /*3*/<0.99045,-0.0517,-0.12777>,<-0.37935,0.19513,0.90444>,<-0.61337,-0.14013,-0.77727>,
            
    /*4*/<0.03675,0.98878,-0.14476>

    /* stem 0.16*/ 
    /*0*/<0.37735,-0.86603,-0.32803>,
    /*1*/<-0.65976,0.00857,-0.75143>,<0.41512,0.48408,-0.77029>,<0.91116,0.30245,0.27985>,
            <0.14285,-0.28531,0.94773>,<-0.82804,-0.46693,0.31037>,
    /*2*/<-0.65963,0.00868,-0.75154>,<0.4351,0.43553,-0.78804>,<0.9237,0.27239,0.26943>,
            <0.13099,-0.25495,0.95804>,<-0.8475,-0.41796,0.3272>,
    /*3*/<-0.65885,0.00918,-0.75222>,<0.46895,0.33442,-0.81747>,<0.94491,0.21013,0.25099>,
            <0.11136,-0.19175,0.97511>,<-0.87975,-0.31599,0.35523>,
    /*4*/<-0.21645,0.95799,0.18816>

    /* stem 0.16.0*/ 
    /*0*/<0.7871,-0.60389,0.12565>,
    /*1*/<0.48339,0.49167,-0.72429>,<0.0748,0.30722,0.94869>,<-0.57578,-0.7854,-0.22721>,
            
    /*2*/<0.5432,0.42482,-0.7242>,<0.12637,0.24436,0.96141>,<-0.70665,-0.66309,-0.24689>,
            
    /*3*/<0.62146,0.32126,-0.71455>,<0.21172,0.1657,0.96318>,<-0.84667,-0.46926,-0.25089>,
            
    /*4*/<-0.42363,0.90547,-0.02561>

    /* stem 0.16.1*/ 
    /*0*/<0.22361,-0.97382,0.04082>,
    /*1*/<0.8745,0.22641,0.42895>,<-0.8095,-0.15451,0.56643>,<-0.06998,-0.05021,-0.99628>,
            
    /*2*/<0.87436,0.22633,0.42926>,<-0.79775,-0.20777,0.56606>,<-0.08469,0.0023,-0.9964>,
            
    /*3*/<0.89793,0.14726,0.41478>,<-0.77885,-0.27808,0.56219>,<-0.11971,0.15544,-0.98057>,
            
    /*4*/<-0.17812,0.94669,0.26841>

    /* stem 0.16.2*/ 
    /*0*/<-0.08932,-0.91363,-0.39662>,
    /*1*/<-0.09441,-0.38184,0.91939>,<-0.81041,0.30455,-0.50048>,<0.90679,0.09745,-0.41016>,
            
    /*2*/<-0.09551,-0.37229,0.92319>,<-0.81271,0.22304,-0.5383>,<0.9075,0.1718,-0.38331>,
            
    /*3*/<-0.09519,-0.40904,0.90754>,<-0.81459,0.18738,-0.54893>,<0.9056,0.24104,-0.34899>,
            
    /*4*/<-0.04955,0.8875,0.45814>

    /* stem 0.16.3*/ 
    /*0*/<0.26053,-0.5743,-0.77608>,
    /*1*/<-0.92083,-0.38979,-0.01125>,<0.20117,0.82264,-0.53179>,<0.71395,-0.42024,0.56007>,
            
    /*2*/<-0.94972,-0.30664,0.06329>,<0.23165,0.71922,-0.65503>,<0.70951,-0.38795,0.5883>,
            
    /*3*/<-0.97134,-0.17283,0.16321>,<0.28767,0.46573,-0.83686>,<0.69323,-0.27111,0.66778>,
            
    /*4*/<-0.0653,0.94737,0.31342>

    /* stem 0.16.4*/ 
    /*0*/<0.78279,-0.49123,-0.38201>,
    /*1*/<-0.32404,0.21487,-0.92132>,<0.61652,0.6297,0.47263>,<-0.30953,-0.83387,0.45701>,
            
    /*2*/<-0.30989,0.20246,-0.92897>,<0.68578,0.57647,0.44428>,<-0.39177,-0.77062,0.50265>,
            
    /*3*/<-0.31438,0.21892,-0.92371>,<0.80637,0.45854,0.3735>,<-0.49906,-0.66056,0.56089>,
            
    /*4*/<-0.49935,0.77556,0.38622>

    /* stem 0.16.5*/ 
    /*0*/<0.61358,-0.73228,0.29543>,
    /*1*/<0.77127,0.49435,-0.40096>,<-0.26448,0.17115,0.94908>,<-0.52007,-0.64964,-0.55452>,
            
    /*2*/<0.79315,0.46406,-0.39441>,<-0.22708,0.11323,0.96727>,<-0.5864,-0.56461,-0.58081>,
            
    /*3*/<0.82508,0.41212,-0.38651>,<-0.15859,0.02178,0.98711>,<-0.67978,-0.41651,-0.60367>,
            
    /*4*/<-0.43089,0.90163,-0.03727>

    /* stem 0.16.6*/ 
    /*0*/<0.08672,-0.99404,-0.06607>,
    /*1*/<0.66673,0.01583,0.74513>,<-0.97485,-0.09136,0.20329>,<0.30626,0.09686,-0.94701>,
            
    /*2*/<0.66343,0.03392,0.74747>,<-0.96825,-0.15305,0.19764>,<0.299,0.13958,-0.94399>,
            
    /*3*/<0.65706,0.05731,0.75166>,<-0.94717,-0.26419,0.18184>,<0.28306,0.22702,-0.93185>,
            
    /*4*/<-0.28944,0.93955,0.18295>

    /* stem 0.16.7*/ 
    /*0*/<-0.21157,-0.74665,-0.63067>,
    /*1*/<-0.47395,-0.47983,0.73833>,<-0.50026,0.64202,-0.58099>,<0.97872,-0.14627,-0.14389>,
            
    /*2*/<-0.46567,-0.43845,0.76871>,<-0.51554,0.58915,-0.62219>,<0.98189,-0.13276,-0.13519>,
            
    /*3*/<-0.45446,-0.36711,0.8116>,<-0.53624,0.46562,-0.70402>,<0.99171,-0.07837,-0.10182>,
            
    /*4*/<0.07282,0.90509,0.41893>

    /* stem 0.16.8*/ 
    /*0*/<0.4724,-0.4485,-0.75874>,
    /*1*/<-0.88459,-0.22383,-0.40915>,<0.44914,0.8653,-0.22255>,<0.42546,-0.63199,0.64775>,
            
    /*2*/<-0.91652,-0.17705,-0.35866>,<0.51313,0.79135,-0.33236>,<0.40397,-0.59267,0.69681>,
            
    /*3*/<-0.95106,-0.11378,-0.28728>,<0.61263,0.60006,-0.51441>,<0.34907,-0.46708,0.81239>,
            
    /*4*/<-0.2218,0.85976,0.46001>

    /* stem 0.16.9*/ 
    /*0*/<0.65618,-0.7373,-0.16067>,
    /*1*/<0.10457,0.30856,-0.94544>,<0.58746,0.37616,0.71652>,<-0.70577,-0.66927,0.23229>,
            
    /*2*/<0.08021,0.35166,-0.93268>,<0.67639,0.26004,0.68911>,<-0.75768,-0.59779,0.26184>,
            
    /*3*/<0.06075,0.35338,-0.9335>,<0.77737,0.06917,0.62523>,<-0.85416,-0.40745,0.32311>,
            
    /*4*/<-0.19967,0.93689,0.28699>

    /* stem 0.16.10*/ 
    /*0*/<0.30236,-0.87409,0.3802>,
    /*1*/<0.94615,0.32236,-0.02954>,<-0.56,0.16716,0.81145>,<-0.39243,-0.47138,-0.78981>,
            
    /*2*/<0.93063,0.36321,-0.04465>,<-0.54201,0.12126,0.83157>,<-0.39524,-0.46545,-0.79192>,
            
    /*3*/<0.92822,0.36896,-0.04772>,<-0.51426,0.03627,0.85687>,<-0.4238,-0.38794,-0.81848>,
            
    /*4*/<-0.32777,0.92712,-0.1817>

    /* stem 0.16.11*/ 
    /*0*/<-0.3466,-0.93699,-0.04378>,
    /*1*/<0.31985,-0.15466,0.93476>,<-0.92074,0.35544,-0.16096>,<0.60803,-0.18147,-0.7729>,
            
    /*2*/<0.31682,-0.16675,0.93371>,<-0.94589,0.27524,-0.17185>,<0.63398,-0.08727,-0.76841>,
            
    /*3*/<0.31368,-0.13806,0.93944>,<-0.97734,0.09435,-0.18946>,<0.65816,0.06319,-0.75022>,
            
    /*4*/<-0.03531,0.9921,0.12038>

    /* stem 0.16.12*/ 
    /*0*/<-0.05165,-0.70584,-0.70648>,
    /*1*/<-0.80507,-0.38399,0.45213>,<-0.10825,0.71199,-0.6938>,<0.91437,-0.31358,0.2561>,
            
    /*2*/<-0.80539,-0.36574,0.46646>,<-0.10991,0.65362,-0.7488>,<0.91762,-0.27002,0.29167>,
            
    /*3*/<-0.80663,-0.30413,0.50681>,<-0.11174,0.54005,-0.83418>,<0.91621,-0.21783,0.3363>,
            
    /*4*/<0.02571,0.8763,0.48108>

    /* stem 0.16.13*/ 
    /*0*/<0.63338,-0.51504,-0.57756>,
    /*1*/<-0.68408,-0.01036,-0.72933>,<0.65578,0.75259,0.05968>,<0.01554,-0.73184,0.68129>,
            
    /*2*/<-0.67174,-0.02342,-0.74042>,<0.70434,0.70951,0.02254>,<-0.04211,-0.67617,0.73554>,
            
    /*3*/<-0.63733,-0.06298,-0.76801>,<0.77791,0.62723,-0.03785>,<-0.15243,-0.55206,0.81975>,
            
    /*4*/<-0.53734,0.77892,0.32334>

    /* stem 0.16.14*/ 
    /*0*/<0.68355,-0.72524,0.08237>,
    /*1*/<0.49501,0.3874,-0.77774>,<0.20652,0.30925,0.92829>,<-0.71518,-0.68217,-0.15219>,
            
    /*2*/<0.52758,0.34669,-0.77554>,<0.22345,0.28733,0.9314>,<-0.76729,-0.62103,-0.15999>,
            
    /*3*/<0.52004,0.36678,-0.77138>,<0.29046,0.2058,0.93449>,<-0.81712,-0.55327,-0.16187>,
            
    /*4*/<-0.57237,0.81534,0.08727>

    /* stem 0.16.15*/ 
    /*0*/<0.15283,-0.98149,0.11538>,
    /*1*/<0.90358,0.1924,0.38279>,<-0.79789,-0.04689,0.60097>,<-0.1087,-0.12614,-0.98604>,
            
    /*2*/<0.88986,0.2527,0.37986>,<-0.78177,-0.1249,0.61093>,<-0.11391,-0.10917,-0.98747>,
            
    /*3*/<0.88364,0.27702,0.37742>,<-0.75255,-0.25429,0.60745>,<-0.13934,-0.00351,-0.99024>,
            
    /*4*/<-0.2995,0.94621,0.12241>

    /* stem 0.16.16*/ 
    /*0*/<-0.10217,-0.94599,-0.30769>,
    /*1*/<-0.09192,-0.29276,0.95176>,<-0.81078,0.26432,-0.52228>,<0.90469,0.04691,-0.42347>,
            
    /*2*/<-0.09202,-0.28998,0.9526>,<-0.81374,0.22786,-0.5347>,<0.90697,0.08105,-0.41332>,
            
    /*3*/<-0.10214,-0.23637,0.96628>,<-0.80876,0.05515,-0.58554>,<0.89999,0.19781,-0.38845>,
            
    /*4*/<-0.2288,0.96006,0.16107>

    /* stem 0.16.17*/ 
    /*0*/<0.14254,-0.77005,-0.62186>,
    /*1*/<-0.97144,-0.22709,0.06884>,<0.31614,0.63561,-0.70431>,<0.65256,-0.39372,0.64742>,
            
    /*2*/<-0.9733,-0.21705,0.07467>,<0.32904,0.57626,-0.7481>,<0.64577,-0.34217,0.68257>,
            
    /*3*/<-0.96348,-0.26136,0.05832>,<0.3543,0.46604,-0.81073>,<0.6105,-0.18789,0.7694>,
            
    /*4*/<-0.29534,0.90267,0.31298>

    /* stem 0.16.18*/ 
    /*0*/<0.58724,-0.75539,-0.29075>,
    /*1*/<-0.32513,0.11685,-0.93842>,<0.8003,0.50788,0.31871>,<-0.48636,-0.61035,0.62524>,
            
    /*2*/<-0.27431,0.03587,-0.96097>,<0.80843,0.49629,0.31645>,<-0.55469,-0.52258,0.64748>,
            
    /*3*/<-0.2195,-0.04314,-0.97466>,<0.8527,0.42429,0.30477>,<-0.64073,-0.36434,0.67581>,
            
    /*4*/<-0.38349,0.92269,0.03981>

    /* stem 0.16.19*/ 
    /*0*/<0.46388,-0.83231,0.30346>,
    /*1*/<0.82303,0.28764,-0.48978>,<-0.13842,0.27704,0.95084>,<-0.69331,-0.54907,-0.46675>,
            
    /*2*/<0.83345,0.26738,-0.4836>,<-0.12847,0.25655,0.95796>,<-0.7144,-0.50866,-0.48051>,
            
    /*3*/<0.84784,0.23313,-0.47624>,<-0.07872,0.10399,0.99146>,<-0.79625,-0.32383,-0.511>,
            
    /*4*/<-0.22839,0.97324,0.02525>

    /* stem 0.16.20*/ 
    /*0*/<-0.19649,-0.958,0.20887>,
    /*1*/<0.6942,0.02092,0.71948>,<-0.94598,0.24641,0.21071>,<0.25542,-0.24959,-0.93406>,
            
    /*2*/<0.69646,0.08187,0.71291>,<-0.965,0.11388,0.23625>,<0.25642,-0.18013,-0.94963>,
            
    /*3*/<0.70464,0.07687,0.70539>,<-0.96644,-0.05529,0.25087>,<0.2652,-0.00174,-0.96419>,
            
    /*4*/<-0.08193,0.99361,0.0776>

    /* stem 0.16.21*/ 
    /*0*/<-0.13738,-0.90823,-0.39527>,
    /*1*/<-0.51332,-0.27016,0.81457>,<-0.47527,0.416,-0.77528>,<0.99109,-0.12925,-0.03207>,
            
    /*2*/<-0.51365,-0.26903,0.81473>,<-0.48043,0.3428,-0.80726>,<0.99846,-0.05515,-0.00616>,
            
    /*3*/<-0.5142,-0.25981,0.81737>,<-0.48422,0.29663,-0.82313>,<0.99975,-0.01951,0.01083>,
            
    /*4*/<0.0599,0.94075,0.33377>

    /* stem 0.16.22*/ 
    /*0*/<0.36029,-0.62492,-0.69258>,
    /*1*/<-0.92648,-0.13527,-0.35119>,<0.56891,0.73857,-0.36175>,<0.35104,-0.59198,0.72549>,
            
    /*2*/<-0.94405,-0.08684,-0.31815>,<0.62365,0.62735,-0.46636>,<0.33208,-0.52135,0.78608>,
            
    /*3*/<-0.95909,-0.04197,-0.27997>,<0.67497,0.44979,-0.58489>,<0.28494,-0.39242,0.87454>,
            
    /*4*/<-0.16274,0.90609,0.39055>

    /* stem 0.16.23*/ 
    /*0*/<0.71293,-0.69658,-0.08063>,
    /*1*/<0.09453,0.21682,-0.97162>,<0.54835,0.49042,0.67735>,<-0.65421,-0.69617,0.29556>,
            
    /*2*/<0.09234,0.21964,-0.9712>,<0.58168,0.45536,0.67402>,<-0.68476,-0.66378,0.30084>,
            
    /*3*/<0.0957,0.21506,-0.9719>,<0.6445,0.37875,0.6642>,<-0.75067,-0.58218,0.31234>,
            
    /*4*/<-0.52872,0.84044,0.11881>

    /* stem 0.16.24*/ 
    /*0*/<0.24537,-0.95647,0.15799>,
    /*1*/<0.96786,0.23762,-0.08239>,<-0.44922,0.03515,0.89273>,<-0.5207,-0.26472,-0.81166>,
            
    /*2*/<0.96808,0.23679,-0.08215>,<-0.42779,-0.08161,0.90019>,<-0.55611,-0.1504,-0.81739>,
            
    /*3*/<0.97862,0.18523,-0.08936>,<-0.39463,-0.17906,0.90123>,<-0.58364,0.00218,-0.81201>,
            
    /*4*/<-0.11845,0.98447,0.12958>

    /* stem 0.16.25*/ 
    /*0*/<-0.35907,-0.93304,0.02237>,
    /*1*/<0.33793,-0.10617,0.93516>,<-0.92183,0.35233,-0.16155>,<0.58536,-0.24236,-0.77371>,
            
    /*2*/<0.36075,-0.02042,0.93244>,<-0.95419,0.25778,-0.15189>,<0.58782,-0.23171,-0.7751>,
            
    /*3*/<0.37502,0.1043,0.92113>,<-0.99006,0.00064,-0.14067>,<0.59936,-0.10675,-0.79333>,
            
    /*4*/<-0.1429,0.98514,-0.09525>

    /* stem 0.17*/ 
    /*0*/<0.40451,-0.86603,0.29389>,
    /*1*/<0.58378,0.00852,-0.81187>,<0.84395,0.48402,0.23122>,<-0.06768,0.3024,0.95078>,
            <-0.89128,-0.28536,0.3524>,<-0.48866,-0.46699,-0.73698>,
    /*2*/<0.58391,0.00863,-0.81177>,<0.86574,0.43548,0.24669>,<-0.05471,0.27234,0.96065>,
            <-0.904,-0.255,0.34316>,<-0.50944,-0.41801,-0.75216>,
    /*3*/<0.58475,0.00912,-0.81116>,<0.90202,0.33436,0.27305>,<-0.03198,0.21007,0.97716>,
            <-0.92505,-0.1918,0.32787>,<-0.54401,-0.31605,-0.77728>,
    /*4*/<-0.23203,0.95799,-0.16858>

    /* stem 0.17.0*/ 
    /*0*/<0.08861,-0.64009,0.76317>,
    /*1*/<0.81422,0.49191,0.30834>,<-0.90413,0.27563,0.32645>,<0.08795,-0.75332,-0.65174>,
            
    /*2*/<0.81624,0.48359,0.31606>,<-0.89396,0.18697,0.40729>,<0.06266,-0.66304,-0.74596>,
            
    /*3*/<0.81996,0.4745,0.32019>,<-0.86248,0.10237,0.49562>,<0.03742,-0.55956,-0.82795>,
            
    /*4*/<-0.23816,0.7979,-0.55375>

    /* stem 0.17.1*/ 
    /*0*/<-0.14063,-0.9714,0.19133>,
    /*1*/<-0.22012,0.22634,0.94885>,<-0.72412,-0.02334,-0.68928>,<0.94734,-0.18152,-0.2638>,
            
    /*2*/<-0.22287,0.27392,0.93557>,<-0.7345,-0.15827,-0.65989>,<0.95092,-0.10127,-0.29238>,
            
    /*3*/<-0.22173,0.30517,0.92612>,<-0.72839,-0.29878,-0.61658>,<0.94839,0.01402,-0.3168>,
            
    /*4*/<-0.14416,0.93774,-0.31601>

    /* stem 0.17.2*/ 
    /*0*/<0.33049,-0.8785,-0.34498>,
    /*1*/<-0.91678,-0.38215,0.11605>,<0.25231,0.44138,-0.86112>,<0.65724,-0.04,0.75262>,
            
    /*2*/<-0.91601,-0.38434,0.11493>,<0.31041,0.32103,-0.89475>,<0.6155,0.09054,0.78292>,
            
    /*3*/<-0.92104,-0.37322,0.11134>,<0.34708,0.21263,-0.91342>,<0.56658,0.18046,0.804>,
            
    /*4*/<-0.35717,0.9292,0.09492>

    /* stem 0.17.3*/ 
    /*0*/<0.8688,-0.49409,0.0327>,
    /*1*/<-0.19652,-0.39041,-0.89942>,<0.48472,0.87174,0.07152>,<-0.3071,-0.47058,0.82719>,
            
    /*2*/<-0.23195,-0.35712,-0.9048>,<0.61621,0.78315,0.0834>,<-0.38691,-0.40264,0.82957>,
            
    /*3*/<-0.27839,-0.30845,-0.90959>,<0.77952,0.61797,0.10229>,<-0.51088,-0.29068,0.80901>,
            
    /*4*/<-0.538,0.83604,-0.10767>

    /* stem 0.17.4*/ 
    /*0*/<0.55778,-0.38501,0.73528>,
    /*1*/<0.82478,0.21407,-0.52336>,<-0.38021,0.67513,0.63217>,<-0.45659,-0.8809,-0.12466>,
            
    /*2*/<0.8703,0.16761,-0.46312>,<-0.36139,0.65265,0.66592>,<-0.52414,-0.82081,-0.22704>,
            
    /*3*/<0.93737,0.07069,-0.34109>,<-0.32548,0.59111,0.738>,<-0.6264,-0.65546,-0.4219>,
            
    /*4*/<-0.18466,0.7702,-0.61048>

    /* stem 0.17.5*/ 
    /*0*/<-0.14245,-0.73655,0.66121>,
    /*1*/<0.56411,0.49431,0.66139>,<-0.98547,0.16534,-0.03891>,<0.4244,-0.64389,-0.63662>,
            
    /*2*/<0.55902,0.44312,0.70082>,<-0.98912,0.14503,-0.0246>,<0.43818,-0.57346,-0.6922>,
            
    /*3*/<0.55354,0.43932,0.70753>,<-0.99685,0.07153,0.03436>,<0.44145,-0.49153,-0.75068>,
            
    /*4*/<-0.03514,0.82879,-0.55846>

    /* stem 0.17.6*/ 
    /*0*/<0.01161,-0.99976,0.01884>,
    /*1*/<-0.57554,0.0158,0.81762>,<-0.42052,-0.0149,-0.90716>,<0.99581,0.02032,0.08914>,
            
    /*2*/<-0.58175,0.07831,0.80959>,<-0.41912,-0.12015,-0.89995>,<0.99483,0.06011,0.0819>,
            
    /*3*/<-0.5885,0.14409,0.79556>,<-0.40034,-0.26362,-0.87763>,<0.98735,0.13943,0.07554>,
            
    /*4*/<-0.14472,0.95036,-0.27544>

    /* stem 0.17.7*/ 
    /*0*/<0.54373,-0.82429,-0.15778>,
    /*1*/<-0.82581,-0.47936,-0.29708>,<0.55376,0.50108,-0.66503>,<0.26061,-0.00439,0.96543>,
            
    /*2*/<-0.83787,-0.45876,-0.29583>,<0.59213,0.44183,-0.67392>,<0.23823,0.03631,0.97053>,
            
    /*3*/<-0.84635,-0.44302,-0.29567>,<0.66409,0.3193,-0.67605>,<0.17701,0.14484,0.97349>,
            
    /*4*/<-0.43786,0.89027,-0.12525>

    /* stem 0.17.8*/ 
    /*0*/<0.71882,-0.64519,0.25889>,
    /*1*/<0.18147,-0.17533,-0.96764>,<0.48175,0.73745,0.47337>,<-0.67821,-0.54867,0.48887>,
            
    /*2*/<0.17946,-0.17138,-0.96872>,<0.55863,0.6537,0.5105>,<-0.75277,-0.4646,0.46635>,
            
    /*3*/<0.14265,-0.10837,-0.98382>,<0.6511,0.53164,0.54169>,<-0.80383,-0.406,0.43476>,
            
    /*4*/<-0.52963,0.84157,-0.1061>

    /* stem 0.17.9*/ 
    /*0*/<0.30193,-0.72464,0.61946>,
    /*1*/<0.94477,0.30841,-0.11085>,<-0.5714,0.38912,0.72256>,<-0.37963,-0.68253,-0.62453>,
            
    /*2*/<0.95958,0.26638,-0.09086>,<-0.54902,0.28373,0.78618>,<-0.43779,-0.53982,-0.71899>,
            
    /*3*/<0.97804,0.20027,-0.05765>,<-0.50546,0.21707,0.8351>,<-0.47686,-0.39861,-0.7834>,
            
    /*4*/<-0.17586,0.90816,-0.37989>

    /* stem 0.17.10*/ 
    /*0*/<-0.09345,-0.93353,0.34609>,
    /*1*/<0.24017,0.32271,0.91552>,<-0.95601,-0.00568,-0.29327>,<0.71777,-0.29784,-0.62936>,
            
    /*2*/<0.23911,0.32541,0.91484>,<-0.95731,-0.12822,-0.25906>,<0.71326,-0.18331,-0.67651>,
            
    /*3*/<0.23861,0.33668,0.91089>,<-0.95237,-0.20601,-0.22486>,<0.71105,-0.11244,-0.69409>,
            
    /*4*/<-0.09045,0.94093,-0.32631>

    /* stem 0.17.11*/ 
    /*0*/<0.05953,-0.9766,-0.20668>,
    /*1*/<-0.8395,-0.15447,0.52094>,<-0.0491,0.21058,-0.97634>,<0.88738,-0.03623,0.45961>,
            
    /*2*/<-0.83752,-0.16706,0.52025>,<-0.02327,0.08284,-0.99629>,<0.87544,0.10881,0.47092>,
            
    /*3*/<-0.85745,-0.11489,0.50158>,<0.02353,-0.18181,-0.98305>,<0.82969,0.309,0.4649>,
            
    /*4*/<-0.23413,0.91832,-0.31917>

    /* stem 0.17.12*/ 
    /*0*/<0.67081,-0.71444,-0.199>,
    /*1*/<-0.62155,-0.38399,-0.68281>,<0.6603,0.70298,-0.26422>,<-0.05229,-0.30458,0.95105>,
            
    /*2*/<-0.66162,-0.33539,-0.67065>,<0.69835,0.65919,-0.2789>,<-0.0495,-0.3077,0.9502>,
            
    /*3*/<-0.71645,-0.24451,-0.65339>,<0.82651,0.4664,-0.31519>,<-0.09512,-0.2,0.97517>,
            
    /*4*/<-0.30912,0.94997,0.04471>

    /* stem 0.17.13*/ 
    /*0*/<0.63188,-0.6384,0.4395>,
    /*1*/<0.55728,-0.00957,-0.83027>,<0.17772,0.67762,0.71361>,<-0.74763,-0.6553,0.10788>,
            
    /*2*/<0.56932,-0.02476,-0.82174>,<0.21268,0.63485,0.74279>,<-0.79841,-0.59764,0.07323>,
            
    /*3*/<0.57609,-0.02506,-0.817>,<0.2933,0.51565,0.80503>,<-0.88071,-0.47351,0.01213>,
            
    /*4*/<-0.39233,0.87236,-0.29166>

    /* stem 0.17.14*/ 
    /*0*/<0.02416,-0.66415,0.74721>,
    /*1*/<0.86949,0.38694,0.30701>,<-0.86196,0.3693,0.34733>,<-0.00801,-0.74315,-0.66908>,
            
    /*2*/<0.87148,0.36793,0.32427>,<-0.86213,0.32145,0.39166>,<-0.01343,-0.67868,-0.73432>,
            
    /*3*/<0.86447,0.3942,0.31192>,<-0.84475,0.20372,0.49487>,<-0.02676,-0.58108,-0.81341>,
            
    /*4*/<-0.23321,0.8116,-0.53565>

    /* stem 0.17.15*/ 
    /*0*/<-0.18663,-0.97034,0.15362>,
    /*1*/<-0.16901,0.19228,0.96668>,<-0.75159,0.04712,-0.65795>,<0.92426,-0.22039,-0.31174>,
            
    /*2*/<-0.16928,0.13039,0.9769>,<-0.75553,-0.02903,-0.65446>,<0.93999,-0.07949,-0.33181>,
            
    /*3*/<-0.17998,0.14478,0.97296>,<-0.76236,-0.17354,-0.62345>,<0.93579,0.04798,-0.34928>,
            
    /*4*/<-0.121,0.96321,-0.23996>

    /* stem 0.17.16*/ 
    /*0*/<0.24213,-0.90784,-0.34233>,
    /*1*/<-0.9478,-0.29306,0.12564>,<0.28589,0.40996,-0.86614>,<0.65722,-0.09933,0.74712>,
            
    /*2*/<-0.94764,-0.29369,0.12542>,<0.28505,0.41312,-0.86492>,<0.65791,-0.10188,0.74617>,
            
    /*3*/<-0.96147,-0.23237,0.14692>,<0.29319,0.3617,-0.88499>,<0.6613,-0.11105,0.74186>,
            
    /*4*/<-0.12576,0.95343,0.27413>

    /* stem 0.17.17*/ 
    /*0*/<0.64644,-0.76295,-0.00533>,
    /*1*/<-0.28562,-0.22717,-0.93103>,<0.75076,0.6434,0.14966>,<-0.47746,-0.40167,0.78146>,
            
    /*2*/<-0.27922,-0.23531,-0.93095>,<0.76766,0.62295,0.15044>,<-0.50057,-0.37284,0.7813>,
            
    /*3*/<-0.2582,-0.26359,-0.92944>,<0.77392,0.61578,0.14785>,<-0.52724,-0.33714,0.77997>,
            
    /*4*/<-0.61933,0.78073,-0.08296>

    /* stem 0.17.18*/ 
    /*0*/<0.44793,-0.68546,0.57403>,
    /*1*/<0.84105,0.11637,-0.52829>,<-0.169,0.57132,0.80314>,<-0.6805,-0.67476,-0.28568>,
            
    /*2*/<0.85275,0.09659,-0.51332>,<-0.16149,0.55802,0.81396>,<-0.70008,-0.64223,-0.31213>,
            
    /*3*/<0.86421,0.07726,-0.49717>,<-0.15364,0.54628,0.82339>,<-0.71768,-0.60958,-0.33666>,
            
    /*4*/<-0.3786,0.73986,-0.55613>

    /* stem 0.17.19*/ 
    /*0*/<-0.0354,-0.91365,0.40497>,
    /*1*/<0.66139,0.28812,0.69249>,<-0.97934,0.11764,0.16447>,<0.31861,-0.38873,-0.86451>,
            
    /*2*/<0.66318,0.24055,0.70875>,<-0.98118,0.07716,0.177>,<0.32096,-0.30105,-0.89797>,
            
    /*3*/<0.66431,0.19234,0.72228>,<-0.97918,0.02617,0.20132>,<0.31428,-0.20056,-0.9279>,
            
    /*4*/<-0.03778,0.97542,-0.21707>

    /* stem 0.17.20*/ 
    /*0*/<-0.15542,-0.98429,-0.08377>,
    /*1*/<-0.54546,0.02104,0.83788>,<-0.43854,0.15087,-0.88596>,<0.98685,-0.15382,0.04962>,
            
    /*2*/<-0.54366,0.0502,0.8378>,<-0.4486,0.07048,-0.89095>,<0.99348,-0.10309,0.04865>,
            
    /*3*/<-0.5426,0.0805,0.83612>,<-0.45461,-0.03413,-0.89003>,<0.99823,-0.02821,0.05227>,
            
    /*4*/<0.01492,0.99668,-0.08006>

    /* stem 0.17.21*/ 
    /*0*/<0.3481,-0.91623,-0.19836>,
    /*1*/<-0.9091,-0.27016,-0.31708>,<0.65659,0.39513,-0.64247>,<0.24622,-0.10839,0.96314>,
            
    /*2*/<-0.9115,-0.26273,-0.31646>,<0.67724,0.34166,-0.65162>,<0.23118,-0.0613,0.97098>,
            
    /*3*/<-0.89533,-0.3101,-0.31971>,<0.68946,0.30118,-0.65874>,<0.1973,0.02462,0.98003>,
            
    /*4*/<-0.39602,0.91804,0.01918>

    /* stem 0.17.22*/ 
    /*0*/<0.7415,-0.6418,0.19562>,
    /*1*/<0.1344,-0.13563,-0.9816>,<0.49545,0.72605,0.47685>,<-0.64168,-0.58018,0.50163>,
            
    /*2*/<0.11408,-0.11127,-0.98722>,<0.56704,0.65676,0.49713>,<-0.68831,-0.53124,0.49398>,
            
    /*3*/<0.10347,-0.10514,-0.98906>,<0.66044,0.54071,0.521>,<-0.7752,-0.42319,0.46902>,
            
    /*4*/<-0.48452,0.85833,-0.16888>

    /* stem 0.17.23*/ 
    /*0*/<0.23262,-0.63133,0.73981>,
    /*1*/<0.96856,0.21505,-0.12512>,<-0.5547,0.54109,0.63208>,<-0.41596,-0.75041,-0.51368>,
            
    /*2*/<0.97182,0.20506,-0.11629>,<-0.54033,0.48462,0.68789>,<-0.44093,-0.68593,-0.57886>,
            
    /*3*/<0.98458,0.15668,-0.07777>,<-0.52103,0.4498,0.7254>,<-0.46332,-0.59921,-0.6529>,
            
    /*4*/<-0.1201,0.78593,-0.60654>

    /* stem 0.17.24*/ 
    /*0*/<-0.1866,-0.93623,0.29775>,
    /*1*/<0.29807,0.23665,0.92474>,<-0.95933,0.11055,-0.25976>,<0.66228,-0.34205,-0.66662>,
            
    /*2*/<0.29795,0.2364,0.92485>,<-0.969,0.04595,-0.24275>,<0.67039,-0.27822,-0.68787>,
            
    /*3*/<0.29591,0.25727,0.91992>,<-0.97407,-0.10214,-0.20187>,<0.67366,-0.15186,-0.72327>,
            
    /*4*/<-0.1396,0.95933,-0.24536>

    /* stem 0.18*/ 
    /*0*/<-0.19537,-0.86603,0.46025>,
    /*1*/<0.92237,0.00847,0.38621>,<-0.03546,0.48397,0.87437>,<-0.94165,0.30234,0.14796>,
            <-0.54387,-0.28541,-0.78914>,<0.60815,-0.46704,-0.64189>,
    /*2*/<0.92231,0.00857,0.38637>,<-0.04563,0.43542,0.89907>,<-0.94834,0.27228,0.16282>,
            <-0.53773,-0.25506,-0.80361>,<0.61827,-0.41807,-0.66555>,
    /*3*/<0.9219,0.00906,0.38731>,<-0.06315,0.33431,0.94035>,<-0.95932,0.21002,0.18868>,
            <-0.52757,-0.19186,-0.82756>,<0.63497,-0.31611,-0.7049>,
    /*4*/<0.11206,0.95799,-0.264>

    /* stem 0.18.0*/ 
    /*0*/<-0.76549,-0.60094,0.23002>,
    /*1*/<-0.11699,0.49161,0.86292>,<-0.48005,0.3096,-0.82079>,<0.61398,-0.7879,-0.04722>,
            
    /*2*/<-0.14341,0.4666,0.87276>,<-0.50946,0.28208,-0.81295>,<0.67238,-0.7373,-0.06553>,
            
    /*3*/<-0.20084,0.39747,0.89537>,<-0.5728,0.21183,-0.79185>,<0.79527,-0.59622,-0.10983>,
            
    /*4*/<0.48103,0.85346,-0.20055>

    /* stem 0.18.1*/ 
    /*0*/<-0.2162,-0.96362,-0.15715>,
    /*1*/<-0.97407,0.22623,-0.00058>,<0.52068,0.02992,-0.85323>,<0.45814,-0.235,0.85725>,
            
    /*2*/<-0.97475,0.22331,-0.0011>,<0.51178,-0.0159,-0.85897>,<0.46998,-0.18665,0.86272>,
            
    /*3*/<-0.96832,0.24957,-0.00813>,<0.47258,-0.2073,-0.85656>,<0.51613,-0.02921,0.85601>,
            
    /*4*/<0.26695,0.92955,-0.25431>

    /* stem 0.18.2*/ 
    /*0*/<0.19591,-0.91936,0.34118>,
    /*1*/<-0.31774,-0.38188,-0.86788>,<0.96056,0.25433,0.11245>,<-0.6471,0.1476,0.74798>,
            
    /*2*/<-0.31837,-0.37513,-0.87058>,<0.96881,0.21124,0.12956>,<-0.65266,0.18464,0.73481>,
            
    /*3*/<-0.3193,-0.33433,-0.88672>,<0.97947,0.11473,0.16578>,<-0.65881,0.23971,0.7131>,
            
    /*4*/<0.00958,0.94507,-0.32673>

    /* stem 0.18.3*/ 
    /*0*/<0.13101,-0.54051,0.83107>,
    /*1*/<0.83241,-0.39011,-0.3936>,<0.0474,0.84465,0.53322>,<-0.88263,-0.44288,-0.15755>,
            
    /*2*/<0.82983,-0.35182,-0.43313>,<0.06223,0.76085,0.64594>,<-0.8963,-0.38716,-0.21624>,
            
    /*3*/<0.82008,-0.36142,-0.44367>,<0.06143,0.5856,0.80827>,<-0.90099,-0.20289,-0.38346>,
            
    /*4*/<0.18791,0.84948,-0.49303>

    /* stem 0.18.4*/ 
    /*0*/<-0.51523,-0.52639,0.67636>,
    /*1*/<0.69493,0.21507,0.68617>,<-0.7807,0.61133,-0.12952>,<0.09685,-0.8151,-0.57117>,
            
    /*2*/<0.6569,0.15866,0.7371>,<-0.81165,0.57555,-0.09988>,<0.17337,-0.73047,-0.66057>,
            
    /*3*/<0.60541,0.10225,0.78931>,<-0.86404,0.50196,-0.03835>,<0.26698,-0.58868,-0.763>,
            
    /*4*/<0.42018,0.80915,-0.41076>

    /* stem 0.18.5*/ 
    /*0*/<-0.67748,-0.7355,0.00833>,
    /*1*/<-0.51755,0.49428,0.69845>,<-0.18246,0.16674,-0.96897>,<0.71443,-0.64537,0.27035>,
            
    /*2*/<-0.56139,0.42637,0.70926>,<-0.22325,0.09759,-0.96986>,<0.81721,-0.51183,0.26495>,
            
    /*3*/<-0.60994,0.33922,0.71617>,<-0.29711,0.00133,-0.95484>,<0.91684,-0.32217,0.23581>,
            
    /*4*/<0.31485,0.93829,-0.14311>

    /* stem 0.18.6*/ 
    /*0*/<-0.07183,-0.98549,0.15378>,
    /*1*/<-0.92574,0.01567,-0.37783>,<0.78401,-0.14421,-0.60377>,<0.14325,0.14937,0.97835>,
            
    /*2*/<-0.92933,-0.04946,-0.36593>,<0.78377,-0.1225,-0.60885>,<0.14263,0.19231,0.97091>,
            
    /*3*/<-0.93156,-0.11358,-0.3454>,<0.77945,-0.1186,-0.61514>,<0.15162,0.25263,0.95561>,
            
    /*4*/<-0.02915,0.96462,-0.26203>

    /* stem 0.18.7*/ 
    /*0*/<0.38997,-0.78278,0.48496>,
    /*1*/<0.10291,-0.47967,-0.87139>,<0.73663,0.58555,0.33839>,<-0.84772,-0.08947,0.52284>,
            
    /*2*/<0.10191,-0.4763,-0.87335>,<0.75409,0.54737,0.36295>,<-0.86317,-0.05318,0.50211>,
            
    /*3*/<0.09072,-0.44256,-0.89214>,<0.77769,0.48779,0.39655>,<-0.87401,-0.02794,0.4851>,
            
    /*4*/<-0.28432,0.86034,-0.42306>

    /* stem 0.18.8*/ 
    /*0*/<-0.06252,-0.51137,0.85708>,
    /*1*/<0.98347,-0.17627,-0.04151>,<-0.34186,0.82118,0.45694>,<-0.64031,-0.63429,-0.43323>,
            
    /*2*/<0.98728,-0.12994,-0.09159>,<-0.34851,0.73706,0.57904>,<-0.64482,-0.58599,-0.49073>,
            
    /*3*/<0.98539,-0.08982,-0.14468>,<-0.35051,0.57939,0.73583>,<-0.64174,-0.47333,-0.60344>,
            
    /*4*/<0.00784,0.8403,-0.54206>

    /* stem 0.18.9*/ 
    /*0*/<-0.63926,-0.6316,0.43865>,
    /*1*/<0.32123,0.30775,0.8956>,<-0.76082,0.47049,-0.44698>,<0.45276,-0.76522,-0.45766>,
            
    /*2*/<0.32167,0.30922,0.89494>,<-0.81344,0.41036,-0.41222>,<0.50096,-0.70762,-0.49831>,
            
    /*3*/<0.32867,0.321,0.88822>,<-0.88953,0.30156,-0.34321>,<0.56753,-0.60697,-0.55632>,
            
    /*4*/<0.3691,0.81853,-0.4402>

    /* stem 0.18.10*/ 
    /*0*/<-0.35674,-0.93415,-0.00987>,
    /*1*/<-0.83806,0.32267,0.43993>,<0.06952,-0.00872,-0.99754>,<0.77582,-0.29488,0.55781>,
            
    /*2*/<-0.84303,0.30762,0.44121>,<0.05099,-0.07176,-0.99612>,<0.80393,-0.21789,0.55337>,
            
    /*3*/<-0.84882,0.2874,0.44375>,<0.01544,-0.18357,-0.98288>,<0.84077,-0.08517,0.53466>,
            
    /*4*/<0.18587,0.95397,-0.23537>

    /* stem 0.18.11*/ 
    /*0*/<0.33208,-0.93633,-0.1141>,
    /*1*/<-0.69721,-0.1548,-0.69995>,<0.89754,0.35704,-0.25875>,<-0.20703,-0.18334,0.961>,
            
    /*2*/<-0.69153,-0.17558,-0.70068>,<0.91853,0.29766,-0.2602>,<-0.23148,-0.10198,0.96748>,
            
    /*3*/<-0.67658,-0.22981,-0.69959>,<0.92938,0.25366,-0.26815>,<-0.25876,-0.00486,0.96593>,
            
    /*4*/<-0.29624,0.95134,-0.08485>

    /* stem 0.18.12*/ 
    /*0*/<0.3462,-0.71338,0.60929>,
    /*1*/<0.52551,-0.38404,-0.75918>,<0.40546,0.70406,0.58302>,<-0.93788,-0.30576,0.16399>,
            
    /*2*/<0.51973,-0.36165,-0.77401>,<0.43677,0.62362,0.64833>,<-0.96233,-0.24249,0.123>,
            
    /*3*/<0.51139,-0.31604,-0.79912>,<0.47377,0.48106,0.73765>,<-0.98765,-0.14661,0.05533>,
            
    /*4*/<-0.1225,0.90271,-0.41245>

    /* stem 0.18.13*/ 
    /*0*/<-0.27087,-0.68795,0.67331>,
    /*1*/<0.93423,-0.00928,0.35654>,<-0.67144,0.63985,0.37384>,<-0.25742,-0.61694,-0.74372>,
            
    /*2*/<0.928,-0.02729,0.37158>,<-0.6836,0.61162,0.39827>,<-0.2403,-0.57117,-0.78487>,
            
    /*3*/<0.92459,-0.02938,0.37983>,<-0.72347,0.49837,0.47772>,<-0.20568,-0.45161,-0.86818>,
            
    /*4*/<0.18699,0.89013,-0.41558>

    /* stem 0.18.14*/ 
    /*0*/<-0.60565,-0.75731,0.24428>,
    /*1*/<-0.10434,0.38753,0.91593>,<-0.62458,0.27201,-0.73206>,<0.74081,-0.64467,-0.18867>,
            
    /*2*/<-0.13597,0.33962,0.93068>,<-0.63668,0.25399,-0.7281>,<0.78831,-0.58,-0.20532>,
            
    /*3*/<-0.17872,0.26767,0.94679>,<-0.65712,0.22942,-0.71802>,<0.84587,-0.4805,-0.23155>,
            
    /*4*/<0.4334,0.89092,-0.13573>

    /* stem 0.18.15*/ 
    /*0*/<-0.18762,-0.9818,-0.02938>,
    /*1*/<-0.97996,0.19229,0.052>,<0.45248,-0.05324,-0.89019>,<0.53112,-0.12001,0.83875>,
            
    /*2*/<-0.96351,0.26236,0.05302>,<0.44114,-0.09455,-0.89244>,<0.52357,-0.14757,0.8391>,
            
    /*3*/<-0.94069,0.33654,0.04288>,<0.40296,-0.27167,-0.87396>,<0.56053,-0.0537,0.82639>,
            
    /*4*/<0.3096,0.90257,-0.29918>

    /* stem 0.18.16*/ 
    /*0*/<0.29919,-0.93291,0.20039>,
    /*1*/<-0.33504,-0.29295,-0.8955>,<0.93899,0.32931,0.09924>,<-0.60969,-0.01846,0.79242>,
            
    /*2*/<-0.3394,-0.28191,-0.8974>,<0.92959,0.35619,0.09484>,<-0.59669,-0.05643,0.80048>,
            
    /*3*/<-0.34519,-0.26805,-0.89944>,<0.92605,0.36618,0.0914>,<-0.58733,-0.08031,0.80536>,
            
    /*4*/<-0.32701,0.93207,-0.15593>

    /* stem 0.18.17*/ 
    /*0*/<0.08278,-0.83455,0.54468>,
    /*1*/<0.84334,-0.22672,-0.4872>,<0.03661,0.55405,0.83168>,<-0.88153,-0.31143,-0.35485>,
            
    /*2*/<0.83402,-0.13626,-0.53464>,<0.05286,0.47472,0.87855>,<-0.8804,-0.31897,-0.35092>,
            
    /*3*/<0.81854,-0.04565,-0.57263>,<0.0632,0.33328,0.94071>,<-0.88807,-0.26994,-0.3721>,
            
    /*4*/<-0.11895,0.95811,-0.26052>

    /* stem 0.18.18*/ 
    /*0*/<-0.42427,-0.72821,0.53824>,
    /*1*/<0.70371,0.11661,0.70086>,<-0.84423,0.53405,0.04548>,<0.14847,-0.63702,-0.75642>,
            
    /*2*/<0.72678,0.17369,0.66454>,<-0.88268,0.45843,0.10352>,<0.15644,-0.61395,-0.77369>,
            
    /*3*/<0.75228,0.24578,0.61128>,<-0.91792,0.35941,0.16805>,<0.16937,-0.59009,-0.78937>,
            
    /*4*/<0.17953,0.80263,-0.56882>

    /* stem 0.18.19*/ 
    /*0*/<-0.52148,-0.85215,-0.0436>,
    /*1*/<-0.52526,0.28768,0.80084>,<-0.3127,0.24553,-0.91757>,<0.84758,-0.51748,0.11753>,
            
    /*2*/<-0.57498,0.18015,0.79808>,<-0.31415,0.24331,-0.91766>,<0.90196,-0.41045,0.13416>,
            
    /*3*/<-0.61632,0.06113,0.78512>,<-0.33825,0.19497,-0.92064>,<0.96149,-0.23889,0.13587>,
            
    /*4*/<0.17561,0.98106,0.08175>

    /* stem 0.18.20*/ 
    /*0*/<0.09174,-0.95205,-0.29187>,
    /*1*/<-0.93937,0.02079,-0.34227>,<0.7563,0.2629,-0.59907>,<0.1814,-0.26636,0.94665>,
            
    /*2*/<-0.93215,-0.06065,-0.35697>,<0.76087,0.23849,-0.60349>,<0.16466,-0.1613,0.97307>,
            
    /*3*/<-0.9194,-0.14075,-0.36727>,<0.76773,0.16312,-0.61966>,<0.1509,-0.00435,0.98854>,
            
    /*4*/<-0.14981,0.98857,-0.01696>

    /* stem 0.18.21*/ 
    /*0*/<0.36515,-0.88287,0.29532>,
    /*1*/<0.1039,-0.2704,-0.95713>,<0.74573,0.47238,0.46984>,<-0.85619,-0.18611,0.48198>,
            
    /*2*/<0.09849,-0.25296,-0.96245>,<0.76402,0.42479,0.48563>,<-0.86709,-0.1549,0.47346>,
            
    /*3*/<0.09793,-0.26484,-0.95931>,<0.79323,0.30576,0.5266>,<-0.90043,-0.02142,0.43447>,
            
    /*4*/<-0.05854,0.94982,-0.30726>

    /* stem 0.18.22*/ 
    /*0*/<-0.04437,-0.73334,0.67842>,
    /*1*/<0.9868,-0.13495,-0.08956>,<-0.35686,0.64994,0.67099>,<-0.6292,-0.50272,-0.59278>,
            
    /*2*/<0.98738,-0.1265,-0.09533>,<-0.36216,0.59499,0.71752>,<-0.62862,-0.45445,-0.63112>,
            
    /*3*/<0.98817,-0.11375,-0.10281>,<-0.36913,0.48499,0.7928>,<-0.6216,-0.35636,-0.69758>,
            
    /*4*/<0.05892,0.89754,-0.43699>

    /* stem 0.18.23*/ 
    /*0*/<-0.60863,-0.69353,0.38547>,
    /*1*/<0.33978,0.21544,0.9155>,<-0.78864,0.49171,-0.36914>,<0.45491,-0.70025,-0.55019>,
            
    /*2*/<0.31374,0.17993,0.9323>,<-0.80439,0.4718,-0.36105>,<0.49962,-0.64685,-0.57616>,
            
    /*3*/<0.28465,0.14279,0.94794>,<-0.84796,0.40966,-0.33636>,<0.56771,-0.54487,-0.61711>,
            
    /*4*/<0.44921,0.85546,-0.25768>

    /* stem 0.18.24*/ 
    /*0*/<-0.29815,-0.95321,-0.04996>,
    /*1*/<-0.83431,0.23587,0.49829>,<0.01646,0.04822,-0.9987>,<0.81873,-0.2813,0.50056>,
            
    /*2*/<-0.8357,0.23079,0.49834>,<0.00572,0.00752,-0.99996>,<0.83265,-0.23595,0.50102>,
            
    /*3*/<-0.84175,0.20136,0.50091>,<-0.01221,-0.06376,-0.99789>,<0.8568,-0.13486,0.49769>,
            
    /*4*/<0.14676,0.98437,-0.09734>

    /* stem 0.19*/ 
    /*0*/<-0.4924,-0.86603,-0.08682>,
    /*1*/<-0.16887,0.00839,0.9856>,<-0.85997,0.4839,0.16213>,<-0.35603,0.30227,-0.88424>,
            <0.64653,-0.28549,-0.70746>,<0.7622,-0.46711,0.44817>,
    /*2*/<-0.16903,0.0085,0.98557>,<-0.88633,0.43535,0.15778>,<-0.37201,0.27221,-0.88742>,
            <0.66201,-0.25513,-0.70473>,<0.78754,-0.41814,0.4527>,
    /*3*/<-0.17003,0.00899,0.9854>,<-0.93048,0.33423,0.14999>,<-0.39967,0.20994,-0.89229>,
            <0.68765,-0.19194,-0.70021>,<0.82964,-0.31618,0.46013>,
    /*4*/<0.28245,0.95799,0.0498>

    /* stem 0.19.0*/ 
    /*0*/<-0.40541,-0.62072,-0.67108>,
    /*1*/<-0.86709,0.4917,0.0799>,<0.6808,0.29293,-0.67135>,<0.19517,-0.77104,0.60614>,
            
    /*2*/<-0.88433,0.46308,0.0593>,<0.64863,0.22301,-0.7277>,<0.25487,-0.67857,0.6889>,
            
    /*3*/<-0.89705,0.44005,0.04062>,<0.5603,0.07344,-0.82503>,<0.35444,-0.49984,0.79027>,
            
    /*4*/<0.43736,0.86622,0.24162>

    /* stem 0.19.1*/ 
    /*0*/<0.10524,-0.9635,-0.24615>,
    /*1*/<-0.21856,0.22616,-0.94925>,<0.94842,0.0305,0.31555>,<-0.73215,-0.23572,0.63906>,
            
    /*2*/<-0.21812,0.22753,-0.94903>,<0.95277,-0.03685,0.30146>,<-0.7343,-0.17072,0.65701>,
            
    /*3*/<-0.21776,0.22508,-0.94969>,<0.94995,-0.14796,0.27514>,<-0.72996,-0.05651,0.68115>,
            
    /*4*/<0.15376,0.971,0.1831>

    /* stem 0.19.2*/ 
    /*0*/<-0.25587,-0.9144,0.3137>,
    /*1*/<0.77391,-0.38197,-0.50514>,<0.1196,0.29919,0.94667>,<-0.88797,0.10256,-0.44832>,
            
    /*2*/<0.77446,-0.38025,-0.50559>,<0.11507,0.28357,0.95202>,<-0.88399,0.1166,-0.45274>,
            
    /*3*/<0.76783,-0.39582,-0.50374>,<0.07702,0.18646,0.97944>,<-0.84642,0.23425,-0.47822>,
            
    /*4*/<0.42804,0.89765,-0.10493>

    /* stem 0.19.3*/ 
    /*0*/<-0.72936,-0.6492,0.2158>,
    /*1*/<0.57036,-0.38936,0.72325>,<-0.61123,0.76507,0.20267>,<0.0565,-0.36179,-0.93054>,
            
    /*2*/<0.59585,-0.35998,0.7179>,<-0.68086,0.69809,0.22159>,<0.09318,-0.31899,-0.94316>,
            
    /*3*/<0.66136,-0.26163,0.70296>,<-0.80148,0.54069,0.25551>,<0.14618,-0.25844,-0.9549>,
            
    /*4*/<0.41562,0.89518,-0.161>

    /* stem 0.19.4*/ 
    /*0*/<-0.81666,-0.41071,-0.40543>,
    /*1*/<-0.51201,0.21422,0.83184>,<0.04403,0.66535,-0.74523>,<0.48535,-0.87083,-0.07798>,
            
    /*2*/<-0.45594,0.26029,0.8511>,<-0.10348,0.57771,-0.80966>,<0.56884,-0.82031,-0.05928>,
            
    /*3*/<-0.37886,0.2983,0.87606>,<-0.28016,0.45289,-0.8464>,<0.67451,-0.73769,-0.02916>,
            
    /*4*/<0.71763,0.69266,0.07234>

    /* stem 0.19.5*/ 
    /*0*/<-0.28931,-0.82337,-0.48822>,
    /*1*/<-0.79608,0.49484,-0.34841>,<0.85875,0.01055,-0.51228>,<-0.05658,-0.48805,0.87098>,
            
    /*2*/<-0.81296,0.45294,-0.36597>,<0.8427,-0.04648,-0.53637>,<-0.02158,-0.39078,0.92023>,
            
    /*3*/<-0.83374,0.39729,-0.38345>,<0.78149,-0.21238,-0.58665>,<0.07247,-0.17092,0.98262>,
            
    /*4*/<0.40971,0.91221,0.00095>

    /* stem 0.19.6*/ 
    /*0*/<0.08147,-0.99667,0.00429>,
    /*1*/<0.15817,0.01566,-0.98729>,<0.77217,0.07282,0.63122>,<-0.93204,-0.06767,0.35597>,
            
    /*2*/<0.15806,0.01499,-0.98732>,<0.76826,0.10562,0.63137>,<-0.92883,-0.09989,0.3568>,
            
    /*3*/<0.15428,-0.0509,-0.98672>,<0.76434,0.04948,0.64291>,<-0.93555,0.02857,0.35204>,
            
    /*4*/<0.14968,0.98346,-0.10196>

    /* stem 0.19.7*/ 
    /*0*/<-0.38805,-0.78685,0.47988>,
    /*1*/<0.8722,-0.4797,-0.09564>,<-0.16755,0.57834,0.7984>,<-0.69661,-0.08234,-0.71271>,
            
    /*2*/<0.88335,-0.45646,-0.10649>,<-0.19324,0.52573,0.82841>,<-0.68349,-0.05094,-0.72818>,
            
    /*3*/<0.89594,-0.4287,-0.11626>,<-0.28009,0.3583,0.8906>,<-0.62302,0.09579,-0.77632>,
            
    /*4*/<0.42481,0.90217,-0.07502>

    /* stem 0.19.8*/ 
    /*0*/<-0.80834,-0.57869,0.10814>,
    /*1*/<0.26135,-0.17584,0.94909>,<-0.58153,0.78276,-0.22159>,<0.33683,-0.59501,-0.72973>,
            
    /*2*/<0.27026,-0.1679,0.94803>,<-0.62455,0.7503,-0.21677>,<0.36901,-0.56866,-0.73516>,
            
    /*3*/<0.25512,-0.18879,0.9483>,<-0.71141,0.67041,-0.2108>,<0.47384,-0.46826,-0.7458>,
            
    /*4*/<0.62448,0.78028,0.03452>

    /* stem 0.19.9*/ 
    /*0*/<-0.53164,-0.75146,-0.39072>,
    /*1*/<-0.8007,0.3085,0.51352>,<0.17596,0.36076,-0.91591>,<0.63556,-0.65397,0.41034>,
            
    /*2*/<-0.81023,0.29319,0.50752>,<0.14856,0.31386,-0.93778>,<0.67629,-0.59299,0.43703>,
            
    /*3*/<-0.83009,0.25243,0.49721>,<0.08402,0.18365,-0.97939>,<0.7661,-0.42088,0.48575>,
            
    /*4*/<0.30675,0.94632,0.10189>

    /* stem 0.19.10*/ 
    /*0*/<0.11165,-0.871,-0.47844>,
    /*1*/<-0.61841,0.32217,-0.71678>,<0.98224,0.17323,-0.07211>,<-0.36608,-0.47784,0.79853>,
            
    /*2*/<-0.61778,0.3126,-0.72154>,<0.98735,0.12804,-0.09348>,<-0.37002,-0.42376,0.82675>,
            
    /*3*/<-0.61417,0.33949,-0.71242>,<0.98884,0.01114,-0.14855>,<-0.36923,-0.3328,0.8677>,
            
    /*4*/<0.13123,0.91937,0.37085>

    /* stem 0.19.11*/ 
    /*0*/<0.09356,-0.96495,0.24521>,
    /*1*/<0.5258,-0.15466,-0.83643>,<0.46799,0.26641,0.84262>,<-0.99566,-0.09245,-0.0111>,
            
    /*2*/<0.52809,-0.13933,-0.83768>,<0.46444,0.12294,0.87703>,<-0.99902,0.03687,-0.02429>,
            
    /*3*/<0.51679,-0.17334,-0.83838>,<0.44609,-0.06266,0.89279>,<-0.96453,0.25784,-0.05656>,
            
    /*4*/<0.34585,0.93693,-0.05053>

    /* stem 0.19.12*/ 
    /*0*/<-0.50447,-0.77917,0.37203>,
    /*1*/<0.85783,-0.38365,0.34197>,<-0.53107,0.62532,0.57179>,<-0.31678,-0.22624,-0.92112>,
            
    /*2*/<0.84714,-0.40137,0.34821>,<-0.55943,0.58464,0.58756>,<-0.28004,-0.16664,-0.94541>,
            
    /*3*/<0.81811,-0.44888,0.35944>,<-0.61541,0.49653,0.61215>,<-0.19431,-0.02964,-0.98049>,
            
    /*4*/<0.53453,0.84393,-0.04548>

    /* stem 0.19.13*/ 
    /*0*/<-0.84382,-0.52106,-0.12832>,
    /*1*/<-0.1365,-0.01044,0.99058>,<-0.37169,0.74935,-0.54801>,<0.52464,-0.72876,-0.44007>,
            
    /*2*/<-0.12569,-0.00017,0.99207>,<-0.45642,0.68785,-0.56439>,<0.59634,-0.67451,-0.43522>,
            
    /*3*/<-0.09441,0.03241,0.99501>,<-0.58533,0.57128,-0.57535>,<0.69048,-0.58805,-0.42124>,
            
    /*4*/<0.62395,0.7814,0.00986>

    /* stem 0.19.14*/ 
    /*0*/<-0.36617,-0.7253,-0.58297>,
    /*1*/<-0.91602,0.38724,0.10462>,<0.59134,0.30903,-0.74487>,<0.33175,-0.68227,0.65149>,
            
    /*2*/<-0.91863,0.38189,0.10137>,<0.55185,0.20594,-0.80812>,<0.38981,-0.57933,0.71583>,
            
    /*3*/<-0.94177,0.32595,0.08256>,<0.50021,0.13089,-0.85596>,<0.44554,-0.43971,0.77984>,
            
    /*4*/<0.2753,0.90603,0.32143>

    /* stem 0.19.15*/ 
    /*0*/<0.01751,-0.98005,-0.198>,
    /*1*/<-0.27131,0.19218,-0.94311>,<0.9689,-0.02591,0.24609>,<-0.69793,-0.14755,0.70081>,
            
    /*2*/<-0.27589,0.1651,-0.9469>,<0.96187,-0.13467,0.23804>,<-0.68576,-0.01121,0.72775>,
            
    /*3*/<-0.28054,0.13413,-0.95042>,<0.93453,-0.28635,0.21132>,<-0.64824,0.16992,0.74223>,
            
    /*4*/<0.33953,0.94032,0.02275>

    /* stem 0.19.16*/ 
    /*0*/<0.05672,-0.88676,0.45873>,
    /*1*/<0.82557,-0.21089,-0.52341>,<0.07242,0.46747,0.88104>,<-0.89906,-0.23991,-0.36625>,
            
    /*2*/<0.81907,-0.12196,-0.56058>,<0.0844,0.3937,0.91536>,<-0.89755,-0.25267,-0.36132>,
            
    /*3*/<0.8086,-0.03289,-0.58744>,<0.08897,0.24809,0.96464>,<-0.90423,-0.19713,-0.37883>,
            
    /*4*/<-0.0714,0.98335,-0.16709>

    /* stem 0.19.17*/ 
    /*0*/<-0.6435,-0.66426,0.38034>,
    /*1*/<0.66517,-0.2279,0.71106>,<-0.66058,0.7355,0.15059>,<0.00739,-0.49523,-0.86873>,
            
    /*2*/<0.69957,-0.18568,0.69001>,<-0.70333,0.68784,0.17944>,<0.01348,-0.48669,-0.87347>,
            
    /*3*/<0.74118,-0.12678,0.65923>,<-0.78985,0.56553,0.23728>,<0.05111,-0.42212,-0.9051>,
            
    /*4*/<0.40269,0.86159,-0.30903>

    /* stem 0.19.18*/ 
    /*0*/<-0.66936,-0.66471,-0.33184>,
    /*1*/<-0.52438,0.11611,0.84353>,<-0.1839,0.5877,-0.7879>,<0.72053,-0.69166,-0.04956>,
            
    /*2*/<-0.56745,0.06605,0.82075>,<-0.18778,0.58338,-0.79019>,<0.76815,-0.63996,-0.02005>,
            
    /*3*/<-0.64905,-0.06431,0.75802>,<-0.20944,0.54279,-0.81333>,<0.87961,-0.47028,0.07162>,
            
    /*4*/<0.26749,0.85792,0.43867>

    /* stem 0.19.19*/ 
    /*0*/<-0.0891,-0.86629,-0.49154>,
    /*1*/<-0.8984,0.28765,-0.33188>,<0.82143,0.22081,-0.52583>,<0.07857,-0.49284,0.86656>,
            
    /*2*/<-0.88642,0.35399,-0.29826>,<0.80972,0.15502,-0.56598>,<0.07951,-0.49075,0.86766>,
            
    /*3*/<-0.87994,0.38238,-0.28195>,<0.79233,0.05793,-0.60734>,<0.09179,-0.42561,0.90024>,
            
    /*4*/<0.23457,0.91226,0.33579>

    /* stem 0.19.20*/ 
    /*0*/<0.22185,-0.97499,0.01298>,
    /*1*/<0.12272,0.0208,-0.99222>,<0.77424,0.1903,0.60361>,<-0.9009,-0.19373,0.38838>,
            
    /*2*/<0.12454,-0.01858,-0.99204>,<0.78355,0.10275,0.61277>,<-0.91928,-0.06438,0.3883>,
            
    /*3*/<0.13117,-0.00641,-0.99134>,<0.79389,-0.03722,0.60692>,<-0.92172,0.06098,0.38304>,
            
    /*4*/<0.07851,0.99562,0.05085>

    /* stem 0.19.21*/ 
    /*0*/<-0.22888,-0.92061,0.31636>,
    /*1*/<0.95608,-0.27029,-0.11339>,<-0.31157,0.38271,0.86975>,<-0.64049,-0.09623,-0.76192>,
            
    /*2*/<0.95243,-0.28406,-0.1104>,<-0.33414,0.31323,0.88896>,<-0.62043,-0.01068,-0.78419>,
            
    /*3*/<0.97006,-0.21719,-0.10866>,<-0.37203,0.14335,0.91709>,<-0.59146,0.08976,-0.80132>,
            
    /*4*/<0.1439,0.98942,0.01836>

    /* stem 0.19.22*/ 
    /*0*/<-0.58248,-0.80988,0.06937>,
    /*1*/<0.30733,-0.13651,0.94176>,<-0.80326,0.56559,-0.18679>,<0.50139,-0.42147,-0.75562>,
            
    /*2*/<0.2811,-0.18871,0.94094>,<-0.84187,0.50396,-0.19308>,<0.57392,-0.30775,-0.75888>,
            
    /*3*/<0.25347,-0.22988,0.93963>,<-0.9035,0.38118,-0.19595>,<0.65154,-0.14193,-0.74522>,
            
    /*4*/<0.29453,0.94478,0.14371>

    /* stem 0.19.23*/ 
    /*0*/<-0.53544,-0.62417,-0.56896>,
    /*1*/<-0.81648,0.21409,0.53621>,<0.22511,0.54534,-0.80742>,<0.59382,-0.75657,0.27382>,
            
    /*2*/<-0.81204,0.22056,0.54032>,<0.18271,0.48746,-0.85382>,<0.63645,-0.70571,0.3113>,
            
    /*3*/<-0.82478,0.18717,0.53358>,<0.098,0.33851,-0.93584>,<0.74751,-0.52623,0.40534>,
            
    /*4*/<0.31178,0.91701,0.24877>

    /* stem 0.20*/ 
    /*0*/<-0.02617,-0.86603,-0.49931>,
    /*1*/<-0.99833,0.00832,0.05713>,<-0.35143,0.48382,-0.8015>,<0.78148,0.3022,-0.54586>,
            <0.83476,-0.28556,0.47077>,<-0.26522,-0.46719,0.84344>,
    /*2*/<-0.99834,0.00842,0.05697>,<-0.35312,0.43527,-0.82816>,<0.78099,0.27213,-0.56214>,
            <0.83559,-0.25521,0.48647>,<-0.26395,-0.41822,0.86915>,
    /*3*/<-0.99839,0.00891,0.05596>,<-0.35546,0.33415,-0.87292>,<0.77952,0.20986,-0.59018>,
            <0.83696,-0.19202,0.51248>,<-0.26171,-0.31626,0.91186>,
    /*4*/<0.01501,0.95799,0.28641>

    /* stem 0.20.0*/ 
    /*0*/<0.30775,-0.77399,-0.55338>,
    /*1*/<-0.27103,0.49278,-0.82687>,<0.92257,0.11229,0.36912>,<-0.65824,-0.58824,0.46978>,
            
    /*2*/<-0.26515,0.46171,-0.84648>,<0.94297,0.04052,0.33039>,<-0.687,-0.48898,0.53752>,
            
    /*3*/<-0.25828,0.46141,-0.84876>,<0.96614,-0.10836,0.23418>,<-0.70246,-0.33675,0.62702>,
            
    /*4*/<0.08401,0.87167,0.48283>

    /* stem 0.20.1*/ 
    /*0*/<0.20374,-0.97557,-0.08215>,
    /*1*/<0.87621,0.22619,-0.42556>,<-0.06467,-0.08982,0.99386>,<-0.81593,-0.11533,-0.56653>,
            
    /*2*/<0.86078,0.29466,-0.41501>,<-0.04734,-0.15216,0.98722>,<-0.81462,-0.12097,-0.56724>,
            
    /*3*/<0.86047,0.30546,-0.40778>,<-0.04766,-0.18906,0.98081>,<-0.81589,-0.09557,-0.57026>,
            
    /*4*/<-0.19423,0.96868,0.1547>

    /* stem 0.20.2*/ 
    /*0*/<-0.48336,-0.87491,-0.02999>,
    /*1*/<0.66711,-0.38233,0.63937>,<-0.82276,0.45083,0.34614>,<0.16598,-0.0498,-0.98487>,
            
    /*2*/<0.68879,-0.32609,0.64748>,<-0.87646,0.34058,0.34033>,<0.18525,0.00608,-0.98267>,
            
    /*3*/<0.71193,-0.21587,0.66825>,<-0.95165,0.07984,0.29662>,<0.22425,0.15397,-0.96229>,
            
    /*4*/<-0.00601,0.96899,0.24701>

    /* stem 0.20.3*/ 
    /*0*/<-0.40341,-0.62228,-0.67084>,
    /*1*/<-0.57623,-0.38959,0.71846>,<-0.32112,0.78718,-0.52653>,<0.90592,-0.38437,-0.17767>,
            
    /*2*/<-0.55929,-0.34946,0.75171>,<-0.36454,0.71308,-0.59886>,<0.92748,-0.34386,-0.14678>,
            
    /*3*/<-0.5389,-0.30264,0.78613>,<-0.42406,0.54742,-0.72146>,<0.97255,-0.22405,-0.0629>,
            
    /*4*/<0.14043,0.88769,0.4385>

    /* stem 0.20.4*/ 
    /*0*/<0.12571,-0.61814,-0.77595>,
    /*1*/<-0.92508,0.21564,-0.31261>,<0.77347,0.55437,-0.30727>,<0.14896,-0.75699,0.63622>,
            
    /*2*/<-0.92521,0.21874,-0.31006>,<0.78328,0.50648,-0.36047>,<0.14463,-0.71199,0.68714>,
            
    /*3*/<-0.92462,0.24624,-0.29059>,<0.79208,0.37002,-0.48549>,<0.14279,-0.6005,0.78678>,
            
    /*4*/<0.08227,0.8425,0.53238>

    /* stem 0.20.5*/ 
    /*0*/<0.53299,-0.77457,-0.34055>,
    /*1*/<0.15958,0.49445,-0.85443>,<0.63362,0.10818,0.76604>,<-0.80432,-0.58647,0.09549>,
            
    /*2*/<0.17909,0.44689,-0.87648>,<0.67145,0.02521,0.74062>,<-0.87489,-0.45984,0.15201>,
            
    /*3*/<0.21657,0.30717,-0.92668>,<0.71621,-0.04035,0.69671>,<-0.9416,-0.24727,0.22858>,
            
    /*4*/<-0.12777,0.97471,0.18333>

    /* stem 0.20.6*/ 
    /*0*/<0.01655,-0.99307,0.11633>,
    /*1*/<0.99755,0.01558,-0.06822>,<-0.44184,0.10397,0.89105>,<-0.55605,-0.09898,-0.82523>,
            
    /*2*/<0.99721,0.03595,-0.06548>,<-0.44535,-0.03019,0.89485>,<-0.56677,0.01218,-0.82379>,
            
    /*3*/<0.99689,0.0432,-0.06588>,<-0.43674,-0.19306,0.87863>,<-0.56214,0.16998,-0.80939>,
            
    /*4*/<-0.00393,0.96685,0.25531>

    /* stem 0.20.7*/ 
    /*0*/<-0.45972,-0.82605,-0.32605>,
    /*1*/<0.28871,-0.47948,0.8287>,<-0.86786,0.49663,-0.01357>,<0.58859,-0.00019,-0.80843>,
            
    /*2*/<0.31488,-0.40793,0.857>,<-0.91828,0.39296,-0.04837>,<0.59999,0.03364,-0.7993>,
            
    /*3*/<0.34913,-0.22675,0.90923>,<-0.97908,0.16651,-0.11693>,<0.62164,0.07815,-0.7794>,
            
    /*4*/<0.01975,0.99178,0.12641>

    /* stem 0.20.8*/ 
    /*0*/<-0.2004,-0.72606,-0.65778>,
    /*1*/<-0.86659,-0.17487,0.46739>,<0.04183,0.66962,-0.74153>,<0.82884,-0.47993,0.28757>,
            
    /*2*/<-0.84568,-0.08993,0.52606>,<0.00908,0.58259,-0.81272>,<0.83227,-0.4709,0.29255>,
            
    /*3*/<-0.82736,-0.07194,0.55704>,<-0.02174,0.41037,-0.91166>,<0.87168,-0.32079,0.3705>,
            
    /*4*/<0.0395,0.94561,0.32289>

    /* stem 0.20.9*/ 
    /*0*/<0.4336,-0.56944,-0.69838>,
    /*1*/<-0.68162,0.30724,-0.66408>,<0.84975,0.51374,0.11831>,<-0.17687,-0.80949,0.55986>,
            
    /*2*/<-0.67328,0.2925,-0.67907>,<0.87719,0.47369,0.0784>,<-0.21066,-0.75666,0.61894>,
            
    /*3*/<-0.62886,0.20107,-0.75107>,<0.89402,0.44624,0.03999>,<-0.28097,-0.63565,0.71903>,
            
    /*4*/<-0.42581,0.7975,0.4274>

    /* stem 0.20.10*/ 
    /*0*/<0.41617,-0.90667,-0.06894>,
    /*1*/<0.55982,0.32236,-0.76333>,<0.33454,0.08959,0.93811>,<-0.90269,-0.39381,-0.1734>,
            
    /*2*/<0.57278,0.29294,-0.76558>,<0.3316,0.09719,0.9384>,<-0.91215,-0.37173,-0.17261>,
            
    /*3*/<0.60319,0.18489,-0.77587>,<0.33945,0.06412,0.93844>,<-0.9587,-0.22963,-0.16782>,
            
    /*4*/<-0.12165,0.99214,0.02919>

    /* stem 0.20.11*/ 
    /*0*/<-0.21189,-0.96898,0.12716>,
    /*1*/<0.93322,-0.15471,0.3243>,<-0.71962,0.24922,0.6481>,<-0.20941,-0.07535,-0.97492>,
            
    /*2*/<0.94736,-0.05382,0.31561>,<-0.73002,0.1643,0.66338>,<-0.2107,-0.08984,-0.97341>,
            
    /*3*/<0.94737,-0.04136,0.31744>,<-0.74405,0.10334,0.66008>,<-0.19606,-0.04394,-0.97961>,
            
    /*4*/<0.14856,0.98874,-0.01805>

    /* stem 0.20.12*/ 
    /*0*/<-0.60606,-0.6925,-0.39132>,
    /*1*/<-0.13941,-0.38427,0.91264>,<-0.60191,0.72518,-0.3344>,<0.7532,-0.32733,-0.57056>,
            
    /*2*/<-0.1003,-0.33405,0.9372>,<-0.63952,0.68227,-0.35429>,<0.74872,-0.33294,-0.57321>,
            
    /*3*/<-0.04955,-0.26644,0.96258>,<-0.69303,0.60893,-0.3859>,<0.75255,-0.32649,-0.5719>,
            
    /*4*/<0.5244,0.81733,0.2387>

    /* stem 0.20.13*/ 
    /*0*/<-0.04866,-0.71928,-0.69301>,
    /*1*/<-0.99601,-0.0092,0.08876>,<0.43766,0.61305,-0.65774>,<0.55928,-0.58997,0.58235>,
            
    /*2*/<-0.99504,0.00379,0.09937>,<0.43547,0.57812,-0.69004>,<0.56196,-0.56688,0.60236>,
            
    /*3*/<-0.98406,0.09102,0.15278>,<0.41506,0.44139,-0.79555>,<0.57136,-0.51198,0.64142>,
            
    /*4*/<0.22968,0.86881,0.43866>

    /* stem 0.20.14*/ 
    /*0*/<0.3594,-0.80184,-0.47737>,
    /*1*/<-0.30717,0.38769,-0.86911>,<0.91394,0.21132,0.34648>,<-0.61365,-0.58367,0.53175>,
            
    /*2*/<-0.29536,0.33524,-0.89464>,<0.93735,0.14012,0.31896>,<-0.65638,-0.46267,0.5959>,
            
    /*3*/<-0.28035,0.2686,-0.92155>,<0.96625,0.01582,0.25711>,<-0.68797,-0.26773,0.67455>,
            
    /*4*/<-0.0177,0.96395,0.26549>

    /* stem 0.20.15*/ 
    /*0*/<0.16612,-0.98253,-0.08386>,
    /*1*/<0.85811,0.19214,-0.47616>,<-0.01151,-0.08059,0.99668>,<-0.84974,-0.09296,-0.51894>,
            
    /*2*/<0.85543,0.22914,-0.46448>,<0.00485,-0.22595,0.97413>,<-0.87047,0.00667,-0.49217>,
            
    /*3*/<0.85053,0.26589,-0.45376>,<0.0232,-0.36941,0.92898>,<-0.87532,0.12059,-0.46827>,
            
    /*4*/<-0.07417,0.92075,0.38304>

    /* stem 0.20.16*/ 
    /*0*/<-0.46477,-0.86332,0.19663>,
    /*1*/<0.69587,-0.21109,0.68644>,<-0.82089,0.50838,0.26019>,<0.13367,-0.28122,-0.95029>,
            
    /*2*/<0.6648,-0.28436,0.69078>,<-0.8496,0.45828,0.26108>,<0.20013,-0.15759,-0.96701>,
            
    /*3*/<0.62725,-0.35274,0.69436>,<-0.90441,0.33541,0.2637>,<0.2804,0.03593,-0.95921>,
            
    /*4*/<0.31216,0.92983,0.19486>

    /* stem 0.20.17*/ 
    /*0*/<-0.49968,-0.68079,-0.53558>,
    /*1*/<-0.54334,-0.22785,0.808>,<-0.30579,0.72186,-0.62082>,<0.85833,-0.48148,-0.17732>,
            
    /*2*/<-0.5099,-0.1707,0.84313>,<-0.35738,0.65208,-0.66863>,<0.86986,-0.46368,-0.16833>,
            
    /*3*/<-0.46208,-0.08084,0.88315>,<-0.46173,0.44173,-0.76921>,<0.93038,-0.34313,-0.12905>,
            
    /*4*/<0.25578,0.94873,0.18572>

    /* stem 0.20.18*/ 
    /*0*/<0.14732,-0.72398,-0.6739>,
    /*1*/<-0.93971,0.11644,-0.32155>,<0.73808,0.5378,-0.40745>,<0.19896,-0.64111,0.74121>,
            
    /*2*/<-0.94223,0.1631,-0.29259>,<0.75507,0.42433,-0.49982>,<0.20074,-0.57199,0.79532>,
            
    /*3*/<-0.94349,0.2102,-0.25622>,<0.75585,0.31282,-0.57519>,<0.1885,-0.50785,0.84057>,
            
    /*4*/<0.0437,0.85056,0.52406>

    /* stem 0.20.19*/ 
    /*0*/<0.49968,-0.84599,-0.18604>,
    /*1*/<0.12105,0.28749,-0.9501>,<0.67742,0.25547,0.68981>,<-0.80741,-0.52781,0.26362>,
            
    /*2*/<0.12991,0.26007,-0.95681>,<0.72295,0.14215,0.67612>,<-0.87015,-0.39011,0.3011>,
            
    /*3*/<0.13378,0.26031,-0.95621>,<0.77094,0.02207,0.63653>,<-0.90841,-0.26559,0.32288>,
            
    /*4*/<-0.21377,0.94374,0.2523>

    /* stem 0.20.20*/ 
    /*0*/<0.03957,-0.96937,0.2424>,
    /*1*/<0.99439,0.02072,-0.10376>,<-0.41479,0.21051,0.88523>,<-0.5803,-0.2141,-0.78576>,
            
    /*2*/<0.99508,-0.00491,-0.09894>,<-0.41511,0.18515,0.89073>,<-0.58139,-0.16312,-0.79711>,
            
    /*3*/<0.99506,-0.02621,-0.09571>,<-0.41373,0.10652,0.90415>,<-0.58352,-0.06276,-0.80967>,
            
    /*4*/<0.02358,0.99887,-0.04115>

    /* stem 0.20.21*/ 
    /*0*/<-0.41546,-0.90085,-0.12591>,
    /*1*/<0.32563,-0.27096,0.90584>,<-0.89579,0.43298,-0.10039>,<0.5767,-0.14784,-0.80346>,
            
    /*2*/<0.337,-0.23414,0.91192>,<-0.93034,0.34902,-0.11248>,<0.59269,-0.09914,-0.79931>,
            
    /*3*/<0.34374,-0.20868,0.91559>,<-0.9572,0.25973,-0.12774>,<0.61739,-0.03607,-0.78583>,
            
    /*4*/<0.23094,0.96103,0.15195>

    /* stem 0.20.22*/ 
    /*0*/<-0.24333,-0.7533,-0.611>,
    /*1*/<-0.84839,-0.1368,0.5114>,<0.01927,0.62845,-0.77761>,<0.83129,-0.48492,0.27167>,
            
    /*2*/<-0.85317,-0.15669,0.49755>,<0.01232,0.59656,-0.80247>,<0.84587,-0.43356,0.31069>,
            
    /*3*/<-0.85931,-0.18629,0.47632>,<0.00178,0.56261,-0.82672>,<0.85871,-0.36911,0.35549>,
            
    /*4*/<0.11163,0.82408,0.55537>

    /* stem 0.20.23*/ 
    /*0*/<0.4429,-0.61198,-0.65523>,
    /*1*/<-0.70582,0.21361,-0.67542>,<0.83157,0.55348,0.04633>,<-0.12679,-0.76567,0.63062>,
            
    /*2*/<-0.6957,0.1881,-0.69327>,<0.88498,0.46531,-0.01706>,<-0.18388,-0.6578,0.73041>,
            
    /*3*/<-0.67977,0.14658,-0.71863>,<0.94368,0.3061,-0.12558>,<-0.26123,-0.4523,0.85275>,
            
    /*4*/<-0.17174,0.92954,0.3263>

    /* stem 0.21*/ 
    /*0*/<0.48063,-0.86603,-0.13782>,
    /*1*/<-0.28019,0.00823,-0.95991>,<0.70196,0.48373,-0.52274>,<0.70772,0.30211,0.63865>,
            <-0.27088,-0.28565,0.91925>,<-0.88144,-0.46728,-0.06871>,
    /*2*/<-0.28004,0.00833,-0.95995>,<0.72755,0.43518,-0.53037>,<0.72347,0.27204,0.6345>,
            <-0.28599,-0.2553,0.9236>,<-0.90621,-0.41831,-0.06168>,
    /*3*/<-0.27908,0.00881,-0.96023>,<0.77062,0.33405,-0.54272>,<0.75045,0.20976,0.62676>,
            <-0.31103,-0.19212,0.93078>,<-0.94733,-0.31636,-0.04989>,
    /*4*/<-0.27569,0.95799,0.07905>

    /* stem 0.21.0*/ 
    /*0*/<0.65814,-0.62427,0.42088>,
    /*1*/<0.7444,0.49165,-0.45183>,<-0.3142,0.28975,0.90406>,<-0.44435,-0.76797,-0.46128>,
            
    /*2*/<0.78314,0.44923,-0.42998>,<-0.29902,0.27129,0.91487>,<-0.49878,-0.70898,-0.49857>,
            
    /*3*/<0.82776,0.39124,-0.40218>,<-0.21615,0.13171,0.96744>,<-0.64464,-0.51418,-0.56574>,
            
    /*4*/<-0.42699,0.90202,-0.06357>

    /* stem 0.21.1*/ 
    /*0*/<-0.03164,-0.9532,0.30068>,
    /*1*/<0.61288,0.22596,0.75718>,<-0.98999,0.07753,0.11795>,<0.37778,-0.28315,-0.88154>,
            
    /*2*/<0.61247,0.19538,0.76597>,<-0.99013,0.074,0.11905>,<0.37945,-0.24897,-0.89108>,
            
    /*3*/<0.61398,0.15001,0.77494>,<-0.99107,0.00489,0.13329>,<0.3749,-0.13441,-0.91727>,
            
    /*4*/<-0.08293,0.99169,-0.09833>

    /* stem 0.21.2*/ 
    /*0*/<-0.09257,-0.8705,-0.48338>,
    /*1*/<-0.47283,-0.38243,0.79384>,<-0.52116,0.46199,-0.7176>,<0.99594,-0.06116,-0.06601>,
            
    /*2*/<-0.47278,-0.38215,0.794>,<-0.52089,0.46426,-0.71634>,<0.99569,-0.06371,-0.06743>,
            
    /*3*/<-0.47373,-0.33954,0.81258>,<-0.52802,0.34685,-0.77517>,<0.99901,0.0142,-0.04227>,
            
    /*4*/<-0.07853,0.95024,0.30145>

    /* stem 0.21.3*/ 
    /*0*/<0.56204,-0.51342,-0.64847>,
    /*1*/<-0.82962,-0.3904,-0.39915>,<0.36713,0.86079,-0.3525>,<0.45066,-0.45959,0.7653>,
            
    /*2*/<-0.80573,-0.41636,-0.42123>,<0.41815,0.81797,-0.39507>,<0.38069,-0.38974,0.83855>,
            
    /*3*/<-0.7883,-0.42295,-0.44688>,<0.54338,0.68742,-0.48187>,<0.2438,-0.24348,0.93877>,
            
    /*4*/<-0.55425,0.79493,0.24677>

    /* stem 0.21.4*/ 
    /*0*/<0.78362,-0.61903,-0.05233>,
    /*1*/<0.09656,0.21561,-0.97169>,<0.47424,0.5537,0.68448>,<-0.58714,-0.7564,0.28831>,
            
    /*2*/<0.11296,0.19802,-0.97367>,<0.53868,0.49036,0.68511>,<-0.67178,-0.67785,0.29872>,
            
    /*3*/<0.17269,0.10401,-0.97947>,<0.62595,0.38939,0.67569>,<-0.82306,-0.48039,0.30298>,
            
    /*4*/<-0.4063,0.91094,-0.07151>

    /* stem 0.21.5*/ 
    /*0*/<0.46863,-0.81108,0.35006>,
    /*1*/<0.86834,0.49466,-0.03605>,<-0.56366,0.03894,0.82509>,<-0.31438,-0.51681,-0.79629>,
            
    /*2*/<0.87282,0.48689,-0.03353>,<-0.53299,-0.02152,0.84585>,<-0.3545,-0.45092,-0.81915>,
            
    /*3*/<0.87426,0.48438,-0.03235>,<-0.46671,-0.13414,0.87418>,<-0.42042,-0.33415,-0.84356>,
            
    /*4*/<-0.48503,0.87332,-0.04533>

    /* stem 0.21.6*/ 
    /*0*/<-0.01276,-0.99983,0.01299>,
    /*1*/<0.2902,0.01557,0.95684>,<-0.97366,0.01632,-0.22744>,<0.68371,-0.01135,-0.72966>,
            
    /*2*/<0.28994,-0.02196,0.95679>,<-0.97353,0.029,-0.22672>,<0.6846,0.01337,-0.7288>,
            
    /*3*/<0.29671,-0.13724,0.94505>,<-0.9742,0.03347,-0.22317>,<0.68427,0.12436,-0.71855>,
            
    /*4*/<-0.0376,0.96947,0.2423>

    /* stem 0.21.7*/ 
    /*0*/<0.22459,-0.8306,-0.50957>,
    /*1*/<-0.74257,-0.47951,0.46761>,<-0.17897,0.48494,-0.85604>,<0.91697,0.01145,0.39879>,
            
    /*2*/<-0.75536,-0.4349,0.49019>,<-0.16547,0.42765,-0.88867>,<0.91398,0.02516,0.40498>,
            
    /*3*/<-0.76755,-0.38983,0.50882>,<-0.12171,0.29548,-0.94757>,<0.88965,0.11561,0.44177>,
            
    /*4*/<-0.32236,0.91762,0.23249>

    /* stem 0.21.8*/ 
    /*0*/<0.69211,-0.54741,-0.47045>,
    /*1*/<-0.65094,-0.17614,-0.73841>,<0.5968,0.80138,-0.04022>,<0.0402,-0.61422,0.78811>,
            
    /*2*/<-0.70584,-0.11472,-0.69902>,<0.68014,0.72529,-0.10665>,<0.02079,-0.5896,0.80743>,
            
    /*3*/<-0.74549,-0.07867,-0.66186>,<0.76422,0.62046,-0.17605>,<-0.02875,-0.52812,0.84868>,
            
    /*4*/<-0.49085,0.76892,0.40966>

    /* stem 0.21.9*/ 
    /*0*/<0.72537,-0.65878,0.19963>,
    /*1*/<0.49413,0.30779,-0.81308>,<0.15636,0.44888,0.87981>,<-0.66497,-0.74351,-0.07072>,
            
    /*2*/<0.50567,0.29537,-0.81059>,<0.19795,0.40412,0.89303>,<-0.72114,-0.68777,-0.08322>,
            
    /*3*/<0.51735,0.28343,-0.80748>,<0.28992,0.29113,0.9117>,<-0.82219,-0.56034,-0.1001>,
            
    /*4*/<-0.49551,0.86837,-0.02031>

    /* stem 0.21.10*/ 
    /*0*/<0.16911,-0.91154,0.37484>,
    /*1*/<0.86967,0.3223,0.3739>,<-0.83629,0.07538,0.54309>,<-0.03671,-0.37973,-0.92437>,
            
    /*2*/<0.87927,0.25369,0.40315>,<-0.84157,0.12795,0.52477>,<-0.03738,-0.36231,-0.93131>,
            
    /*3*/<0.88957,0.14909,0.43179>,<-0.84344,0.12927,0.52144>,<-0.04841,-0.2602,-0.96434>,
            
    /*4*/<-0.03196,0.9832,-0.1797>

    /* stem 0.21.11*/ 
    /*0*/<0.03016,-0.98686,-0.15875>,
    /*1*/<-0.10739,-0.15469,0.98211>,<-0.80722,0.07607,-0.58533>,<0.91402,0.09784,-0.39369>,
            
    /*2*/<-0.1108,-0.1252,0.98592>,<-0.80424,0.01641,-0.59408>,<0.91147,0.12772,-0.39103>,
            
    /*3*/<-0.11332,-0.12018,0.98626>,<-0.79872,-0.02433,-0.60121>,<0.90934,0.16356,-0.38254>,
            
    /*4*/<-0.11868,0.98333,0.13778>

    /* stem 0.21.12*/ 
    /*0*/<0.24365,-0.68993,-0.68164>,
    /*1*/<-0.92056,-0.38439,0.06938>,<0.18958,0.72759,-0.6593>,<0.72631,-0.32998,0.60298>,
            
    /*2*/<-0.93435,-0.34169,0.10115>,<0.21209,0.65568,-0.72464>,<0.71898,-0.29606,0.62882>,
            
    /*3*/<-0.94576,-0.29565,0.13468>,<0.235,0.58639,-0.7752>,<0.70741,-0.27528,0.65099>,
            
    /*4*/<-0.17632,0.80804,0.56213>

    /* stem 0.21.13*/ 
    /*0*/<0.68319,-0.69949,-0.20967>,
    /*1*/<-0.31058,-0.00941,-0.9505>,<0.72291,0.63009,0.28353>,<-0.42526,-0.60745,0.67094>,
            
    /*2*/<-0.33766,0.0269,-0.94088>,<0.78305,0.56358,0.26309>,<-0.45144,-0.57374,0.68339>,
            
    /*3*/<-0.39498,0.13045,-0.90938>,<0.90248,0.38007,0.20268>,<-0.50164,-0.49181,0.71167>,
            
    /*4*/<-0.2979,0.8936,0.33575>

    /* stem 0.21.14*/ 
    /*0*/<0.53649,-0.81547,0.21721>,
    /*1*/<0.77786,0.38768,-0.49461>,<-0.11758,0.18994,0.97473>,<-0.67034,-0.56231,-0.48419>,
            
    /*2*/<0.77971,0.38485,-0.4939>,<-0.08626,0.13549,0.98702>,<-0.70659,-0.50628,-0.49438>,
            
    /*3*/<0.82764,0.2762,-0.4886>,<-0.05318,0.09002,0.99452>,<-0.77917,-0.35012,-0.51991>,
            
    /*4*/<-0.23793,0.96592,-0.10193>

    /* stem 0.21.15*/ 
    /*0*/<0.00029,-0.98323,0.18239>,
    /*1*/<0.67569,0.14069,0.72364>,<-0.97625,0.04527,0.21188>,<0.30056,-0.16783,-0.93888>,
            
    /*2*/<0.67577,0.13603,0.72445>,<-0.97617,0.01461,0.21653>,<0.29945,-0.13259,-0.94486>,
            
    /*3*/<0.67599,0.12966,0.72542>,<-0.97213,-0.06245,0.22598>,<0.29315,-0.04921,-0.9548>,
            
    /*4*/<-0.12872,0.9906,-0.04629>

    /* stem 0.21.16*/ 
    /*0*/<-0.16955,-0.92289,-0.34574>,
    /*1*/<-0.51313,-0.21086,0.83201>,<-0.47001,0.38962,-0.79202>,<0.98622,-0.16199,-0.03371>,
            
    /*2*/<-0.51533,-0.22799,0.82611>,<-0.47357,0.36233,-0.80277>,<0.99293,-0.11737,-0.01757>,
            
    /*3*/<-0.51783,-0.23229,0.82334>,<-0.47859,0.23054,-0.84723>,<0.9996,0.02105,0.01884>,
            
    /*4*/<-0.11316,0.97437,0.19441>

    /* stem 0.21.17*/ 
    /*0*/<0.37716,-0.81874,-0.43291>,
    /*1*/<-0.90926,-0.22713,-0.3488>,<0.61341,0.57572,-0.54062>,<0.28909,-0.33392,0.89718>,
            
    /*2*/<-0.89457,-0.25775,-0.36511>,<0.60393,0.59389,-0.53157>,<0.28248,-0.32187,0.90366>,
            
    /*3*/<-0.88529,-0.278,-0.3728>,<0.62083,0.55943,-0.54919>,<0.26007,-0.2653,0.92843>,
            
    /*4*/<-0.39289,0.86577,0.30997>

    /* stem 0.21.18*/ 
    /*0*/<0.7609,-0.64881,0.00811>,
    /*1*/<0.10158,0.1159,-0.98805>,<0.49681,0.59962,0.62741>,<-0.61191,-0.70399,0.3605>,
            
    /*2*/<0.07746,0.14767,-0.986>,<0.59597,0.5002,0.62818>,<-0.6779,-0.63389,0.37234>,
            
    /*3*/<0.06563,0.14583,-0.98713>,<0.70627,0.3569,0.6114>,<-0.78486,-0.48957,0.37989>,
            
    /*4*/<-0.43451,0.89859,0.06116>

    /* stem 0.21.19*/ 
    /*0*/<0.28762,-0.79725,0.53073>,
    /*1*/<0.95306,0.28708,-0.09621>,<-0.54456,0.32544,0.77301>,<-0.41352,-0.5986,-0.68606>,
            
    /*2*/<0.95631,0.27778,-0.0912>,<-0.52896,0.27189,0.80391>,<-0.43681,-0.5368,-0.72183>,
            
    /*3*/<0.95598,0.27956,-0.08916>,<-0.48565,0.14086,0.86273>,<-0.48123,-0.40639,-0.7767>,
            
    /*4*/<-0.29874,0.93003,-0.21398>

    /* stem 0.21.20*/ 
    /*0*/<-0.06585,-0.99709,0.03833>,
    /*1*/<0.32381,0.02041,0.9459>,<-0.97884,0.06259,-0.19482>,<0.6561,-0.06679,-0.75171>,
            
    /*2*/<0.32357,0.02141,0.94596>,<-0.98079,0.01275,-0.19464>,<0.65665,-0.018,-0.75398>,
            
    /*3*/<0.32,0.06863,0.94493>,<-0.97915,-0.06919,-0.19097>,<0.6579,0.0169,-0.75292>,
            
    /*4*/<-0.09219,0.99219,-0.084>

    /* stem 0.21.21*/ 
    /*0*/<-0.01819,-0.87087,-0.49118>,
    /*1*/<-0.80917,-0.27283,0.5204>,<-0.10386,0.4931,-0.86375>,<0.91321,-0.21169,0.34819>,
            
    /*2*/<-0.80907,-0.2568,0.52865>,<-0.10453,0.46729,-0.8779>,<0.91354,-0.20155,0.3533>,
            
    /*3*/<-0.80816,-0.252,0.53232>,<-0.09784,0.36517,-0.92579>,<0.91316,-0.10202,0.39463>,
            
    /*4*/<-0.12169,0.94817,0.29353>

    /* stem 0.21.22*/ 
    /*0*/<0.56821,-0.71416,-0.4088>,
    /*1*/<-0.68809,-0.13834,-0.71232>,<0.73478,0.66435,-0.13688>,<-0.04837,-0.5239,0.85041>,
            
    /*2*/<-0.70811,-0.10699,-0.69795>,<0.77867,0.60407,-0.16965>,<-0.0678,-0.49249,0.86767>,
            
    /*3*/<-0.71814,-0.09458,-0.68944>,<0.82536,0.52608,-0.20498>,<-0.10885,-0.42956,0.89646>,
            
    /*4*/<-0.43954,0.84367,0.30826>

    /* stem 0.22*/ 
    /*0*/<0.2424,-0.86603,0.43731>,
    /*1*/<0.8723,0.00815,-0.48891>,<0.66727,0.48366,0.56641>,<-0.46306,0.30203,0.83328>,
            <-0.95661,-0.28573,-0.05711>,<-0.13131,-0.46735,-0.87426>,
    /*2*/<0.87238,0.00826,-0.48877>,<0.68046,0.4351,0.58963>,<-0.45547,0.27196,0.84769>,
            <-0.96424,-0.25538,-0.07086>,<-0.14374,-0.41839,-0.89682>,
    /*3*/<0.87286,0.00873,-0.4879>,<0.70218,0.33397,0.62881>,<-0.44187,0.20968,0.87223>,
            <-0.97688,-0.1922,-0.09365>,<-0.16448,-0.31644,-0.93424>,
    /*4*/<-0.13904,0.95799,-0.25084>

    /* stem 0.22.0*/ 
    /*0*/<-0.13704,-0.71486,0.68571>,
    /*1*/<0.6068,0.49225,0.62408>,<-0.98062,0.1959,-0.00211>,<0.37674,-0.67292,-0.63659>,
            
    /*2*/<0.60598,0.47831,0.63561>,<-0.98949,0.1378,0.04377>,<0.38328,-0.60376,-0.69898>,
            
    /*3*/<0.60959,0.37247,0.69977>,<-0.99162,0.08674,0.0957>,<0.39331,-0.4417,-0.80636>,
            
    /*4*/<0.04113,0.92782,-0.37076>

    /* stem 0.22.1*/ 
    /*0*/<-0.11972,-0.97549,0.1846>,
    /*1*/<-0.60119,0.22603,0.76647>,<-0.38179,-0.11938,-0.91651>,<0.98551,-0.0861,0.14615>,
            
    /*2*/<-0.59836,0.24392,0.7632>,<-0.38075,-0.11371,-0.91766>,<0.98245,-0.10975,0.15083>,
            
    /*3*/<-0.59366,0.29655,0.74809>,<-0.38752,-0.16933,-0.90618>,<0.9827,-0.10781,0.15059>,
            
    /*4*/<0.13088,0.94207,-0.30884>

    /* stem 0.22.2*/ 
    /*0*/<0.38918,-0.91942,0.05665>,
    /*1*/<-0.8794,-0.38215,-0.28393>,<0.68045,0.25325,-0.68764>,<0.1908,0.14814,0.97039>,
            
    /*2*/<-0.88502,-0.36689,-0.28658>,<0.70469,0.1958,-0.68196>,<0.1758,0.19118,0.96568>,
            
    /*3*/<-0.89443,-0.33678,-0.29423>,<0.74237,0.09221,-0.66362>,<0.14772,0.26429,0.95306>,
            
    /*4*/<-0.26045,0.93351,-0.24643>

    /* stem 0.22.3*/ 
    /*0*/<0.6857,-0.59416,0.42047>,
    /*1*/<0.20287,-0.38988,-0.89824>,<0.49561,0.80839,0.31761>,<-0.71272,-0.40617,0.57189>,
            
    /*2*/<0.20446,-0.39113,-0.89734>,<0.52818,0.77803,0.34014>,<-0.74679,-0.37296,0.55064>,
            
    /*3*/<0.17692,-0.33785,-0.92442>,<0.64315,0.63819,0.42317>,<-0.81837,-0.27801,0.50297>,
            
    /*4*/<-0.4025,0.85656,-0.32295>

    /* stem 0.22.4*/ 
    /*0*/<0.19951,-0.41486,0.88774>,
    /*1*/<0.96872,0.21415,-0.12537>,<-0.60601,0.66361,0.43859>,<-0.36682,-0.86923,-0.3315>,
            
    /*2*/<0.95667,0.24286,-0.16065>,<-0.57399,0.58654,0.5714>,<-0.4024,-0.81619,-0.41462>,
            
    /*3*/<0.95993,0.22204,-0.17101>,<-0.5102,0.4704,0.72001>,<-0.45895,-0.68294,-0.56829>,
            
    /*4*/<-0.21914,0.77885,-0.58768>

    /* stem 0.22.5*/ 
    /*0*/<-0.2329,-0.81202,0.53515>,
    /*1*/<0.23041,0.49457,0.83804>,<-0.93138,0.03679,-0.36218>,<0.7057,-0.51484,-0.48674>,
            
    /*2*/<0.22828,0.48465,0.8444>,<-0.93964,0.00313,-0.34216>,<0.71572,-0.47202,-0.51472>,
            
    /*3*/<0.22314,0.50008,0.83674>,<-0.95506,-0.1525,-0.25416>,<0.72256,-0.3391,-0.60243>,
            
    /*4*/<-0.15325,0.85395,-0.49728>

    /* stem 0.22.6*/ 
    /*0*/<0.02682,-0.99758,0.06418>,
    /*1*/<-0.86732,0.01544,0.49751>,<0.00272,-0.05741,-0.99835>,<0.86406,0.06212,0.49954>,
            
    /*2*/<-0.86696,0.03847,0.49688>,<0.0033,-0.04222,-0.9991>,<0.86456,0.02385,0.50197>,
            
    /*3*/<-0.86356,0.12979,0.48726>,<0.00019,-0.08051,-0.99675>,<0.86126,-0.02863,0.50736>,
            
    /*4*/<0.1397,0.98027,-0.1398>

    /* stem 0.22.7*/ 
    /*0*/<0.45312,-0.88827,0.0752>,
    /*1*/<-0.64653,-0.37839,-0.66244>,<0.85297,0.41592,-0.31537>,<-0.21549,-0.01977,0.97631>,
            
    /*2*/<-0.66371,-0.33501,-0.66877>,<0.88736,0.34203,-0.30921>,<-0.22695,0.01196,0.97383>,
            
    /*3*/<-0.67405,-0.30478,-0.67288>,<0.93089,0.22526,-0.28759>,<-0.26159,0.09927,0.96006>,
            
    /*4*/<-0.24079,0.94546,-0.21936>

    /* stem 0.22.8*/ 
    /*0*/<0.53735,-0.65087,0.5363>,
    /*1*/<0.57365,-0.17553,-0.80007>,<0.24038,0.73294,0.63641>,<-0.82463,-0.54456,0.15308>,
            
    /*2*/<0.57996,-0.18637,-0.79304>,<0.28499,0.66039,0.69474>,<-0.8834,-0.4586,0.09635>,
            
    /*3*/<0.58688,-0.18218,-0.78891>,<0.36653,0.46218,0.80749>,<-0.96563,-0.2597,-0.01033>,
            
    /*4*/<-0.12937,0.94392,-0.30378>

    /* stem 0.22.9*/ 
    /*0*/<-0.08394,-0.56876,0.81821>,
    /*1*/<0.90373,0.30711,0.29824>,<-0.81556,0.51406,0.26571>,<-0.08653,-0.81006,-0.57993>,
            
    /*2*/<0.90296,0.29128,0.31594>,<-0.8244,0.46508,0.3226>,<-0.08224,-0.74793,-0.65866>,
            
    /*3*/<0.90168,0.25117,0.35198>,<-0.8295,0.36279,0.42464>,<-0.07558,-0.60198,-0.79492>,
            
    /*4*/<0.0101,0.84967,-0.52721>

    /* stem 0.22.10*/ 
    /*0*/<-0.35961,-0.90175,0.23985>,
    /*1*/<-0.16851,0.32216,0.93157>,<-0.70667,0.1028,-0.70004>,<0.88216,-0.40744,-0.23619>,
            
    /*2*/<-0.16864,0.32202,0.93159>,<-0.71177,0.08971,-0.69666>,<0.88717,-0.39421,-0.23986>,
            
    /*3*/<-0.16423,0.33478,0.92787>,<-0.70698,0.09805,-0.7004>,<0.87904,-0.41599,-0.23292>,
            
    /*4*/<0.40038,0.88014,-0.25505>

    /* stem 0.22.11*/ 
    /*0*/<0.11503,-0.93726,-0.3291>,
    /*1*/<-0.98078,-0.1551,0.11835>,<0.34902,0.35428,-0.86757>,<0.62956,-0.1812,0.75553>,
            
    /*2*/<-0.98579,-0.11164,0.1255>,<0.36238,0.24438,-0.89942>,<0.62759,-0.11415,0.77013>,
            
    /*3*/<-0.98736,-0.0897,0.13067>,<0.37762,0.10208,-0.92032>,<0.60981,0.0067,0.79252>,
            
    /*4*/<-0.11675,0.99294,0.02095>

    /* stem 0.22.12*/ 
    /*0*/<0.62158,-0.76907,0.14887>,
    /*1*/<-0.27403,-0.38393,-0.88177>,<0.76789,0.6386,0.05029>,<-0.50568,-0.24007,0.82865>,
            
    /*2*/<-0.30402,-0.319,-0.89767>,<0.86602,0.4937,0.07926>,<-0.54828,-0.1542,0.82196>,
            
    /*3*/<-0.33318,-0.26026,-0.90623>,<0.95493,0.26714,0.12937>,<-0.62534,0.01267,0.78025>,
            
    /*4*/<-0.14709,0.95973,-0.23935>

    /* stem 0.22.13*/ 
    /*0*/<0.35673,-0.70193,0.61648>,
    /*1*/<0.85631,-0.00944,-0.51638>,<-0.11255,0.62799,0.77004>,<-0.75043,-0.6054,-0.2652>,
            
    /*2*/<0.85255,0.00068,-0.52264>,<-0.0862,0.56607,0.81984>,<-0.77679,-0.55192,-0.30329>,
            
    /*3*/<0.83951,0.04461,-0.54151>,<-0.02399,0.39782,0.91715>,<-0.82494,-0.42547,-0.37209>,
            
    /*4*/<-0.26247,0.92572,-0.2723>

    /* stem 0.22.14*/ 
    /*0*/<-0.25824,-0.69589,0.67011>,
    /*1*/<0.65794,0.38687,0.6461>,<-0.94047,0.33933,-0.01926>,<0.28731,-0.71332,-0.63924>,
            
    /*2*/<0.65311,0.37035,0.66052>,<-0.94886,0.3157,0.00077>,<0.30047,-0.67394,-0.67493>,
            
    /*3*/<0.63462,0.25911,0.7281>,<-0.96662,0.25287,0.04115>,<0.35085,-0.50108,-0.79109>,
            
    /*4*/<0.17461,0.92969,-0.32432>

    /* stem 0.22.15*/ 
    /*0*/<-0.24569,-0.96932,-0.00687>,
    /*1*/<-0.55269,0.14056,0.82145>,<-0.41014,0.11666,-0.90453>,<0.96733,-0.23948,0.08321>,
            
    /*2*/<-0.55898,0.05519,0.82734>,<-0.41364,0.05178,-0.90897>,<0.99263,-0.08533,0.08601>,
            
    /*3*/<-0.57158,0.02326,0.82022>,<-0.42504,-0.12542,-0.89644>,<0.9909,0.11671,0.06709>,
            
    /*4*/<-0.14813,0.97008,-0.19236>

    /* stem 0.22.16*/ 
    /*0*/<0.31709,-0.89387,-0.31694>,
    /*1*/<-0.92621,-0.21108,-0.31238>,<0.64413,0.4536,-0.61591>,<0.27637,-0.22642,0.934>,
            
    /*2*/<-0.90308,-0.27661,-0.32853>,<0.65108,0.43788,-0.61996>,<0.24286,-0.14709,0.95884>,
            
    /*3*/<-0.87944,-0.33221,-0.34092>,<0.67748,0.36756,-0.63712>,<0.19773,-0.01808,0.98009>,
            
    /*4*/<-0.36515,0.92977,0.04677>

    /* stem 0.22.17*/ 
    /*0*/<0.6247,-0.73394,0.26663>,
    /*1*/<0.13466,-0.2277,-0.96437>,<0.59269,0.67316,0.44224>,<-0.7384,-0.43249,0.51742>,
            
    /*2*/<0.13431,-0.22732,-0.96451>,<0.59087,0.67525,0.44148>,<-0.73628,-0.43499,0.51834>,
            
    /*3*/<0.08125,-0.15073,-0.98523>,<0.66485,0.58765,0.46113>,<-0.74582,-0.41774,0.51889>,
            
    /*4*/<-0.51334,0.85417,-0.08287>

    /* stem 0.22.18*/ 
    /*0*/<0.16325,-0.64714,0.74469>,
    /*1*/<0.9856,0.11583,-0.12322>,<-0.49987,0.60079,0.62385>,<-0.48858,-0.70531,-0.51364>,
            
    /*2*/<0.99195,0.08579,-0.09313>,<-0.49787,0.58668,0.6387>,<-0.49671,-0.66265,-0.5605>,
            
    /*3*/<0.99993,-0.00944,-0.00743>,<-0.49399,0.57127,0.65546>,<-0.50257,-0.553,-0.66454>,
            
    /*4*/<0.09365,0.79012,-0.60576>

    /* stem 0.22.19*/ 
    /*0*/<-0.23072,-0.90458,0.35848>,
    /*1*/<0.3068,0.28751,0.90731>,<-0.95149,0.14038,-0.27377>,<0.64857,-0.41269,-0.63956>,
            
    /*2*/<0.30315,0.26672,0.91486>,<-0.95922,0.10517,-0.26236>,<0.66051,-0.35714,-0.66044>,
            
    /*3*/<0.30032,0.25241,0.91984>,<-0.9723,0.02149,-0.23276>,<0.67222,-0.25849,-0.69376>,
            
    /*4*/<0.02813,0.96113,-0.27466>

    /* stem 0.22.20*/ 
    /*0*/<-0.13617,-0.97203,-0.19136>,
    /*1*/<-0.84857,0.01883,0.52874>,<-0.01689,0.1993,-0.97979>,<0.86707,-0.20667,0.45331>,
            
    /*2*/<-0.84,0.0776,0.53702>,<-0.02711,0.14728,-0.98872>,<0.86604,-0.21263,0.4525>,
            
    /*3*/<-0.82809,0.16092,0.53701>,<-0.04595,-0.01736,-0.99879>,<0.88127,-0.13464,0.45303>,
            
    /*4*/<0.12749,0.98236,-0.13681>

    /* stem 0.22.21*/ 
    /*0*/<0.51345,-0.83876,-0.18126>,
    /*1*/<-0.68818,-0.27462,-0.67155>,<0.78781,0.54556,-0.28588>,<-0.10159,-0.26772,0.95813>,
            
    /*2*/<-0.66291,-0.326,-0.674>,<0.82288,0.49022,-0.28732>,<-0.16444,-0.15988,0.97334>,
            
    /*3*/<-0.62003,-0.40556,-0.67163>,<0.87629,0.3853,-0.28924>,<-0.25846,0.02514,0.96569>,
            
    /*4*/<-0.4022,0.88956,-0.21663>

    /* stem 0.23*/ 
    /*0*/<-0.37157,-0.86603,0.33457>,
    /*1*/<0.67257,0.00808,0.73999>,<-0.40182,0.48359,0.77761>,<-0.91612,0.30196,-0.26372>,
            <-0.15957,-0.2858,-0.94491>,<0.82229,-0.46742,-0.32459>,
    /*2*/<0.67245,0.00819,0.7401>,<-0.42147,0.43503,0.79568>,<-0.92845,0.27189,-0.25308>,
            <-0.14789,-0.25545,-0.95544>,<0.84148,-0.41846,-0.34177>,
    /*3*/<0.67172,0.00865,0.74075>,<-0.45476,0.33389,0.82566>,<-0.9493,0.20961,-0.23431>,
            <-0.12852,-0.19227,-0.97289>,<0.87328,-0.31652,-0.3704>,
    /*4*/<0.21314,0.95799,-0.19191>

    /* stem 0.23.0*/ 
    /*0*/<-0.75748,-0.65005,-0.06053>,
    /*1*/<-0.47123,0.49175,0.73221>,<-0.14282,0.26601,-0.95333>,<0.63003,-0.74404,0.2224>,
            
    /*2*/<-0.50209,0.46017,0.73222>,<-0.17239,0.23464,-0.95667>,<0.69404,-0.68328,0.2268>,
            
    /*3*/<-0.52348,0.44312,0.72775>,<-0.27733,0.10461,-0.95506>,<0.81647,-0.5362,0.21416>,
            
    /*4*/<0.48918,0.85275,-0.18309>

    /* stem 0.23.1*/ 
    /*0*/<-0.19253,-0.97559,-0.10564>,
    /*1*/<-0.88217,0.22599,-0.41316>,<0.81285,-0.09096,-0.57533>,<0.07336,-0.1146,0.9907>,
            
    /*2*/<-0.86787,0.2756,-0.41334>,<0.79,-0.18747,-0.58374>,<0.08847,-0.07083,0.99356>,
            
    /*3*/<-0.85459,0.31407,-0.41356>,<0.75095,-0.3168,-0.5794>,<0.1123,0.0218,0.99344>,
            
    /*4*/<0.36827,0.92394,-0.10347>

    /* stem 0.23.2*/ 
    /*0*/<0.19186,-0.89775,0.39652>,
    /*1*/<0.07773,-0.38236,-0.92074>,<0.8063,0.38016,0.45316>,<-0.88801,0.0208,0.45936>,
            
    /*2*/<0.07615,-0.36145,-0.92928>,<0.81774,0.31326,0.48288>,<-0.89436,0.06827,0.44211>,
            
    /*3*/<0.08526,-0.28977,-0.95329>,<0.81992,0.10134,0.56344>,<-0.89344,0.20647,0.39891>,
            
    /*4*/<0.22149,0.95034,-0.21863>

    /* stem 0.23.3*/ 
    /*0*/<-0.23076,-0.53647,0.81176>,
    /*1*/<0.92067,-0.39032,-0.00468>,<-0.18139,0.84697,0.49974>,<-0.73453,-0.44562,-0.51175>,
            
    /*2*/<0.91739,-0.39799,0.00279>,<-0.24341,0.74659,0.61916>,<-0.69624,-0.32423,-0.64041>,
            
    /*3*/<0.93123,-0.36441,0.00393>,<-0.32589,0.54083,0.77543>,<-0.60372,-0.1568,-0.78162>,
            
    /*4*/<0.30938,0.88657,-0.34392>

    /* stem 0.23.4*/ 
    /*0*/<-0.76608,-0.50663,0.39554>,
    /*1*/<0.33964,0.21474,0.91571>,<-0.63735,0.62165,-0.45533>,<0.31331,-0.82608,-0.46843>,
            
    /*2*/<0.30667,0.18274,0.93411>,<-0.69634,0.57271,-0.43257>,<0.40957,-0.75024,-0.51903>,
            
    /*3*/<0.22728,0.10024,0.96866>,<-0.75691,0.51989,-0.39598>,<0.54639,-0.6081,-0.5759>,
            
    /*4*/<0.59873,0.78795,-0.14374>

    /* stem 0.23.5*/ 
    /*0*/<-0.59531,-0.78278,-0.18127>,
    /*1*/<-0.76462,0.49432,0.41352>,<0.18558,0.09395,-0.97813>,<0.59104,-0.57249,0.56826>,
            
    /*2*/<-0.74453,0.52129,0.41707>,<0.15161,0.05036,-0.98716>,<0.60489,-0.55563,0.57042>,
            
    /*3*/<-0.72241,0.55079,0.41805>,<0.09444,-0.02994,-0.99508>,<0.64142,-0.50587,0.57678>,
            
    /*4*/<0.59658,0.80237,-0.01739>

    /* stem 0.23.6*/ 
    /*0*/<0.0956,-0.99033,-0.10052>,
    /*1*/<-0.68088,0.01533,-0.73223>,<0.96882,0.12214,-0.21557>,<-0.28985,-0.11765,0.94981>,
            
    /*2*/<-0.67363,-0.09709,-0.73267>,<0.96818,0.12552,-0.21649>,<-0.30896,-0.01055,0.95102>,
            
    /*3*/<-0.66188,-0.18855,-0.72551>,<0.97958,0.00459,-0.201>,<-0.30709,0.20366,0.92964>,
            
    /*4*/<0.06842,0.95391,-0.29219>

    /* stem 0.23.7*/ 
    /*0*/<0.17264,-0.83385,0.52429>,
    /*1*/<0.49907,-0.3788,-0.77938>,<0.48357,0.54079,0.68826>,<-0.98606,-0.14547,0.08074>,
            
    /*2*/<0.49912,-0.36664,-0.78515>,<0.49345,0.45142,0.74346>,<-0.9971,-0.06411,0.04109>,
            
    /*3*/<0.50174,-0.35081,-0.79069>,<0.48585,0.25173,0.83701>,<-0.99166,0.12175,-0.04222>,
            
    /*4*/<0.23307,0.93404,-0.27064>

    /* stem 0.23.8*/ 
    /*0*/<-0.39968,-0.66157,0.63449>,
    /*1*/<0.90858,-0.1755,0.37907>,<-0.57112,0.72468,0.38556>,<-0.32963,-0.53624,-0.77704>,
            
    /*2*/<0.92763,-0.13948,0.34648>,<-0.58666,0.69577,0.41441>,<-0.33262,-0.54201,-0.77174>,
            
    /*3*/<0.93106,-0.13651,0.33837>,<-0.60356,0.66132,0.44539>,<-0.32009,-0.51222,-0.79698>,
            
    /*4*/<0.36806,0.73652,-0.56751>

    /* stem 0.23.9*/ 
    /*0*/<-0.65003,-0.7399,0.17324>,
    /*1*/<-0.08841,0.3082,0.94721>,<-0.60267,0.37304,-0.70543>,<0.70369,-0.66687,-0.24514>,
            
    /*2*/<-0.09263,0.30215,0.94875>,<-0.66451,0.28479,-0.69089>,<0.7707,-0.57556,-0.2734>,
            
    /*3*/<-0.09951,0.28655,0.95288>,<-0.74435,0.15077,-0.65055>,<0.85243,-0.42129,-0.30965>,
            
    /*4*/<0.30689,0.9239,-0.22855>

    /* stem 0.23.10*/ 
    /*0*/<-0.31447,-0.90108,-0.2986>,
    /*1*/<-0.94563,0.32207,0.04536>,<0.52372,0.10449,-0.84546>,<0.42794,-0.40929,0.80582>,
            
    /*2*/<-0.93706,0.34567,0.04934>,<0.49658,0.02423,-0.86765>,<0.45147,-0.35424,0.81895>,
            
    /*3*/<-0.90477,0.42259,0.05297>,<0.4251,-0.14934,-0.89274>,<0.48911,-0.25814,0.83315>,
            
    /*4*/<0.46718,0.88298,-0.04564>

    /* stem 0.23.11*/ 
    /*0*/<0.17608,-0.9786,0.10647>,
    /*1*/<-0.33485,-0.15489,-0.92945>,<0.96774,0.19761,0.15632>,<-0.63624,-0.0241,0.77111>,
            
    /*2*/<-0.33319,-0.10631,-0.93685>,<0.98293,0.05817,0.17452>,<-0.63739,0.06418,0.76786>,
            
    /*3*/<-0.33651,-0.11376,-0.93478>,<0.9813,-0.04891,0.18615>,<-0.64396,0.18041,0.74348>,
            
    /*4*/<0.06431,0.97547,-0.21052>

    /* stem 0.23.12*/ 
    /*0*/<0.03479,-0.73374,0.67854>,
    /*1*/<0.79727,-0.38419,-0.46556>,<0.12264,0.68153,0.72144>,<-0.92057,-0.28353,-0.26864>,
            
    /*2*/<0.7979,-0.32821,-0.50561>,<0.1287,0.60116,0.7887>,<-0.92321,-0.25481,-0.28767>,
            
    /*3*/<0.79383,-0.2464,-0.55599>,<0.12789,0.48436,0.86547>,<-0.92201,-0.22131,-0.31768>,
            
    /*4*/<-0.05905,0.89458,-0.44298>

    /* stem 0.23.13*/ 
    /*0*/<-0.63956,-0.47426,0.60501>,
    /*1*/<0.69649,-0.01088,0.71749>,<-0.63128,0.77218,-0.07228>,<-0.05331,-0.75248,-0.65646>,
            
    /*2*/<0.70451,-0.00158,0.70969>,<-0.69639,0.71751,-0.01512>,<-0.00475,-0.70409,-0.7101>,
            
    /*3*/<0.70644,-0.00254,0.70777>,<-0.76475,0.64174,0.05768>,<0.06777,-0.62723,-0.77588>,
            
    /*4*/<0.5162,0.70591,-0.485>

    /* stem 0.23.14*/ 
    /*0*/<-0.70474,-0.70329,-0.09339>,
    /*1*/<-0.48161,0.38688,0.78637>,<-0.20038,0.33191,-0.92178>,<0.69494,-0.70587,0.13713>,
            
    /*2*/<-0.44443,0.43261,0.78443>,<-0.28239,0.24704,-0.92694>,<0.73448,-0.66546,0.13307>,
            
    /*3*/<-0.42624,0.43843,0.79126>,<-0.38516,0.12115,-0.91486>,<0.82784,-0.54764,0.12153>,
            
    /*4*/<0.48716,0.86034,-0.14995>

    /* stem 0.23.15*/ 
    /*0*/<0.01546,-0.92096,-0.38935>,
    /*1*/<-0.92511,0.1402,-0.35286>,<0.79112,0.25489,-0.55601>,<0.13371,-0.37843,0.91592>,
            
    /*2*/<-0.92511,0.13615,-0.35444>,<0.79284,0.20202,-0.57497>,<0.13531,-0.32169,0.93713>,
            
    /*3*/<-0.92957,0.08377,-0.359>,<0.79499,0.0437,-0.60505>,<0.1458,-0.10683,0.98353>,
            
    /*4*/<0.04877,0.99758,-0.0495>

    /* stem 0.23.16*/ 
    /*0*/<0.23603,-0.94314,0.23406>,
    /*1*/<0.0969,-0.21082,-0.97271>,<0.78666,0.33232,0.52031>,<-0.88779,-0.10461,0.44821>,
            
    /*2*/<0.10416,-0.23814,-0.96563>,<0.78113,0.3547,0.51383>,<-0.88912,-0.09985,0.44666>,
            
    /*3*/<0.08989,-0.21265,-0.97299>,<0.77954,0.36937,0.50586>,<-0.87629,-0.14107,0.46067>,
            
    /*4*/<-0.30891,0.93409,-0.179>

    /* stem 0.23.17*/ 
    /*0*/<-0.11413,-0.71858,0.68602>,
    /*1*/<0.96991,-0.22783,-0.08579>,<-0.29521,0.68796,0.66299>,<-0.6727,-0.44754,-0.58922>,
            
    /*2*/<0.97865,-0.16057,-0.1283>,<-0.30722,0.57444,0.7587>,<-0.6736,-0.39443,-0.62505>,
            
    /*3*/<0.97545,-0.1653,-0.1455>,<-0.32543,0.41767,0.84832>,<-0.65162,-0.2387,-0.72001>,
            
    /*4*/<0.19311,0.92415,-0.32964>

    /* stem 0.23.18*/ 
    /*0*/<-0.72724,-0.59925,0.3347>,
    /*1*/<0.34194,0.1155,0.9326>,<-0.68217,0.63388,-0.36447>,<0.35276,-0.73906,-0.57389>,
            
    /*2*/<0.3707,0.14878,0.91676>,<-0.75782,0.56453,-0.32714>,<0.3905,-0.699,-0.59909>,
            
    /*3*/<0.34957,0.09374,0.93221>,<-0.82887,0.48274,-0.28271>,<0.49947,-0.56927,-0.65304>,
            
    /*4*/<0.52345,0.83653,-0.1619>

    /* stem 0.23.19*/ 
    /*0*/<-0.49991,-0.78102,-0.37429>,
    /*1*/<-0.81447,0.28685,0.50434>,<0.16332,0.34554,-0.92408>,<0.65962,-0.61916,0.42608>,
            
    /*2*/<-0.79791,0.31662,0.51292>,<0.11613,0.26765,-0.95649>,<0.69215,-0.57088,0.44162>,
            
    /*3*/<-0.81703,0.26114,0.51406>,<0.0556,0.1528,-0.98669>,<0.77581,-0.40086,0.48726>,
            
    /*4*/<0.26,0.95842,0.1176>

    /* stem 0.23.20*/ 
    /*0*/<0.05345,-0.9958,-0.07431>,
    /*1*/<-0.70568,0.01892,-0.70828>,<0.96456,0.0746,-0.25312>,<-0.25951,-0.08179,0.96227>,
            
    /*2*/<-0.70555,0.01267,-0.70855>,<0.96634,0.03918,-0.25428>,<-0.2604,-0.04009,0.96467>,
            
    /*3*/<-0.70599,0.00007,-0.70823>,<0.9659,-0.05328,-0.25339>,<-0.25736,0.06513,0.96412>,
            
    /*4*/<0.09026,0.99043,-0.10442>

    /* stem 0.23.21*/ 
    /*0*/<0.11807,-0.91744,0.37996>,
    /*1*/<0.49978,-0.2747,-0.82144>,<0.49296,0.38729,0.7791>,<-0.99312,-0.10961,0.0411>,
            
    /*2*/<0.49905,-0.26503,-0.82505>,<0.49659,0.35285,0.79303>,<-0.99591,-0.08447,0.03192>,
            
    /*3*/<0.49669,-0.32712,-0.80393>,<0.49874,0.30951,0.80961>,<-0.99975,0.01923,-0.01162>,
            
    /*4*/<0.10587,0.91024,-0.40031>

    /* stem 0.24*/ 
    /*0*/<-0.40958,-0.86603,-0.28679>,
    /*1*/<-0.56978,0.00797,0.82176>,<-0.84813,0.48347,-0.21664>,<0.05082,0.30185,-0.952>,
            <0.88474,-0.28591,-0.36808>,<0.50119,-0.46754,0.72816>,
    /*2*/<-0.56991,0.00807,0.82167>,<-0.87015,0.43491,-0.23172>,<0.03769,0.27177,-0.96162>,
            <0.89764,-0.25557,-0.35907>,<0.52225,-0.41858,0.743>,
    /*3*/<-0.5707,0.00853,0.82111>,<-0.90683,0.33377,-0.2574>,<0.01472,0.20948,-0.9777>,
            <0.91901,-0.1924,-0.34411>,<0.55732,-0.31664,0.76755>,
    /*4*/<0.23494,0.95799,0.1645>

    /* stem 0.24.0*/ 
    /*0*/<-0.20584,-0.7403,-0.63998>,
    /*1*/<-0.81881,0.4923,-0.29529>,<0.87371,0.16272,-0.45842>,<-0.05063,-0.63964,0.76701>,
            
    /*2*/<-0.82629,0.47032,-0.3099>,<0.85946,0.09942,-0.50144>,<-0.02374,-0.55773,0.82968>,
            
    /*3*/<-0.81644,0.49213,-0.30204>,<0.81399,-0.01487,-0.58069>,<0.01047,-0.45922,0.88826>,
            
    /*4*/<0.39868,0.82023,0.41022>

    /* stem 0.24.1*/ 
    /*0*/<0.10113,-0.97412,-0.20212>,
    /*1*/<0.20384,0.22588,-0.95259>,<0.74019,-0.05514,0.67013>,<-0.94612,-0.15064,0.28663>,
            
    /*2*/<0.20447,0.19486,-0.95928>,<0.74165,-0.09126,0.66455>,<-0.9503,-0.08331,0.29999>,
            
    /*3*/<0.20578,0.20391,-0.95712>,<0.74549,-0.1656,0.64562>,<-0.94888,-0.01816,0.3151>,
            
    /*4*/<0.05703,0.96558,0.25376>

    /* stem 0.24.2*/ 
    /*0*/<-0.31834,-0.8716,0.37279>,
    /*1*/<0.91442,-0.38263,-0.13201>,<-0.23078,0.45905,0.85791>,<-0.67714,-0.05861,-0.73352>,
            
    /*2*/<0.91926,-0.3695,-0.13572>,<-0.25256,0.40265,0.87982>,<-0.66274,-0.01372,-0.74872>,
            
    /*3*/<0.94104,-0.30157,-0.15326>,<-0.27955,0.32307,0.90415>,<-0.65358,-0.00321,-0.75685>,
            
    /*4*/<0.20958,0.94782,-0.24024>

    /* stem 0.24.3*/ 
    /*0*/<-0.85832,-0.51235,-0.02808>,
    /*1*/<0.21169,-0.39053,0.89592>,<-0.50416,0.86127,-0.06345>,<0.30988,-0.46035,-0.8319>,
            
    /*2*/<0.21872,-0.38364,0.89721>,<-0.59988,0.7965,-0.07567>,<0.39287,-0.39528,-0.83031>,
            
    /*3*/<0.22135,-0.37616,0.89973>,<-0.73366,0.67251,-0.09733>,<0.52463,-0.27987,-0.80401>,
            
    /*4*/<0.58972,0.78413,0.19334>

    /* stem 0.24.4*/ 
    /*0*/<-0.53811,-0.60285,-0.58908>,
    /*1*/<-0.81603,0.21534,0.5364>,<0.24322,0.56466,-0.78867>,<0.5836,-0.7679,0.26409>,
            
    /*2*/<-0.82826,0.19936,0.52368>,<0.22011,0.53295,-0.81702>,<0.62184,-0.7214,0.3048>,
            
    /*3*/<-0.84301,0.1801,0.50685>,<0.1698,0.45937,-0.87186>,<0.68524,-0.62534,0.37337>,
            
    /*4*/<0.41575,0.80091,0.43093>

    /* stem 0.24.5*/ 
    /*0*/<-0.00499,-0.80387,-0.59478>,
    /*1*/<-0.57461,0.4944,-0.65222>,<0.99608,0.05397,-0.07012>,<-0.42137,-0.53235,0.7342>,
            
    /*2*/<-0.57549,0.47184,-0.66796>,<0.99607,0.04467,-0.07644>,<-0.42129,-0.50046,0.75634>,
            
    /*3*/<-0.56925,0.4815,-0.66642>,<0.9882,-0.06154,-0.14027>,<-0.40756,-0.40703,0.81745>,
            
    /*4*/<0.23745,0.85477,0.46151>

    /* stem 0.24.6*/ 
    /*0*/<-0.12735,-0.98713,-0.09674>,
    /*1*/<0.56193,0.01521,-0.82704>,<0.42858,-0.13618,0.89318>,<-0.98801,0.14041,-0.06423>,
            
    /*2*/<0.56124,0.0103,-0.82759>,<0.42424,-0.16349,0.89067>,<-0.98315,0.17258,-0.06031>,
            
    /*3*/<0.55985,0.00307,-0.82859>,<0.40886,-0.23914,0.88071>,<-0.96578,0.25506,-0.04703>,
            
    /*4*/<0.28665,0.93974,0.18632>

    /* stem 0.24.7*/ 
    /*0*/<-0.48178,-0.80269,0.35154>,
    /*1*/<0.87169,-0.37909,0.31056>,<-0.53162,0.59233,0.60541>,<-0.33067,-0.19759,-0.92283>,
            
    /*2*/<0.85222,-0.41628,0.3169>,<-0.59385,0.50411,0.62707>,<-0.25856,-0.0643,-0.96385>,
            
    /*3*/<0.8514,-0.4074,0.33037>,<-0.6672,0.35637,0.6541>,<-0.1756,0.06792,-0.98212>,
            
    /*4*/<0.39149,0.92015,-0.00735>

    /* stem 0.24.8*/ 
    /*0*/<-0.82548,-0.51117,-0.23933>,
    /*1*/<-0.16427,-0.17652,0.97049>,<-0.37611,0.82104,-0.42946>,<0.55632,-0.63465,-0.53641>,
            
    /*2*/<-0.16101,-0.17235,0.97179>,<-0.47262,0.74704,-0.46751>,<0.64937,-0.55975,-0.51479>,
            
    /*3*/<-0.16732,-0.17893,0.96953>,<-0.61239,0.59705,-0.51818>,<0.79441,-0.40247,-0.4549>,
            
    /*4*/<0.45896,0.85001,0.25853>

    /* stem 0.24.9*/ 
    /*0*/<-0.29005,-0.60119,-0.74461>,
    /*1*/<-0.94301,0.30724,0.12783>,<0.60584,0.49233,-0.62495>,<0.34271,-0.78809,0.51135>,
            
    /*2*/<-0.9199,0.35373,0.1693>,<0.56504,0.41577,-0.71264>,<0.36594,-0.75364,0.546>,
            
    /*3*/<-0.90322,0.37639,0.20623>,<0.49257,0.28974,-0.82062>,<0.42321,-0.65504,0.62595>,
            
    /*4*/<0.40241,0.80123,0.44282>

    /* stem 0.24.10*/ 
    /*0*/<0.18322,-0.91199,-0.36701>,
    /*1*/<-0.25666,0.32205,-0.91127>,<0.94869,0.07375,0.30748>,<-0.69549,-0.37861,0.6107>,
            
    /*2*/<-0.25089,0.2819,-0.92606>,<0.95089,0.06135,0.3034>,<-0.70556,-0.32608,0.62917>,
            
    /*3*/<-0.24769,0.22642,-0.94201>,<0.95921,-0.0687,0.27421>,<-0.71089,-0.14182,0.68886>,
            
    /*4*/<0.15163,0.97347,0.17136>

    /* stem 0.24.11*/ 
    /*0*/<-0.09979,-0.98483,0.14199>,
    /*1*/<0.83052,-0.15499,-0.53499>,<0.06101,0.14255,0.98791>,<-0.88967,0.03076,-0.45556>,
            
    /*2*/<0.83196,-0.13983,-0.53692>,<0.0599,0.13014,0.98968>,<-0.88997,0.02804,-0.45517>,
            
    /*3*/<0.83475,-0.1137,-0.53877>,<0.05697,0.11775,0.99141>,<-0.89042,0.01437,-0.45491>,
            
    /*4*/<0.05542,0.99186,-0.11461>

    /* stem 0.24.12*/ 
    /*0*/<-0.55801,-0.82874,0.04265>,
    /*1*/<0.63229,-0.38374,0.67302>,<-0.77989,0.54805,0.30234>,<0.15782,-0.14914,-0.97614>,
            
    /*2*/<0.64814,-0.35556,0.67342>,<-0.81546,0.49221,0.30456>,<0.17375,-0.11974,-0.97748>,
            
    /*3*/<0.65964,-0.33283,0.67387>,<-0.85643,0.41845,0.30237>,<0.20471,-0.06916,-0.97638>,
            
    /*4*/<0.42835,0.90245,0.04579>

    /* stem 0.24.13*/ 
    /*0*/<-0.74083,-0.45764,-0.49167>,
    /*1*/<-0.54248,-0.01105,0.83999>,<-0.05965,0.77959,-0.62344>,<0.61559,-0.76023,-0.20762>,
            
    /*2*/<-0.58895,-0.06186,0.8058>,<-0.11838,0.71973,-0.68408>,<0.74495,-0.65722,-0.11452>,
            
    /*3*/<-0.66816,-0.15178,0.72837>,<-0.20095,0.63333,-0.74734>,<0.88117,-0.47178,0.03114>,
            
    /*4*/<0.30466,0.78619,0.53767>

    /* stem 0.24.14*/ 
    /*0*/<0.02484,-0.71848,-0.6951>,
    /*1*/<-0.90658,0.28132,-0.31459>,<0.81816,0.41829,-0.39453>,<0.08798,-0.68673,0.72157>,
            
    /*2*/<-0.90588,0.28919,-0.30944>,<0.82088,0.34221,-0.45722>,<0.09391,-0.61968,0.77922>,
            
    /*3*/<-0.89892,0.33149,-0.28645>,<0.80014,0.16952,-0.57535>,<0.11034,-0.48745,0.86615>,
            
    /*4*/<0.24004,0.88778,0.39271>

    /* stem 0.24.15*/ 
    /*0*/<0.19818,-0.97444,-0.10584>,
    /*1*/<0.13686,0.14036,-0.9806>,<0.7702,0.09414,0.63081>,<-0.91055,-0.21736,0.35164>,
            
    /*2*/<0.14058,0.07173,-0.98747>,<0.77453,0.04443,0.63097>,<-0.92796,-0.09743,0.35972>,
            
    /*3*/<0.14496,0.02842,-0.98903>,<0.78434,-0.05505,0.61788>,<-0.92697,0.04364,0.37258>,
            
    /*4*/<0.08995,0.99399,0.06247>

    /* stem 0.24.16*/ 
    /*0*/<-0.16244,-0.92365,0.34712>,
    /*1*/<0.96947,-0.21113,-0.12471>,<-0.32011,0.38744,0.86454>,<-0.64656,-0.16034,-0.74583>,
            
    /*2*/<0.96803,-0.21885,-0.12259>,<-0.33733,0.31593,0.88679>,<-0.63398,-0.07934,-0.76927>,
            
    /*3*/<0.96648,-0.22699,-0.11998>,<-0.34098,0.27888,0.89775>,<-0.62337,-0.03516,-0.78113>,
            
    /*4*/<0.19699,0.94659,-0.25529>

    /* stem 0.24.17*/ 
    /*0*/<-0.74975,-0.6573,0.07636>,
    /*1*/<0.30197,-0.2283,0.92558>,<-0.65639,0.74069,-0.14331>,<0.36717,-0.50121,-0.78357>,
            
    /*2*/<0.31285,-0.21007,0.92628>,<-0.77895,0.60942,-0.14779>,<0.46105,-0.37989,-0.80194>,
            
    /*3*/<0.31158,-0.2202,0.92435>,<-0.89251,0.42787,-0.14267>,<0.59006,-0.19292,-0.78397>,
            
    /*4*/<0.36675,0.92022,0.1367>

    /* stem 0.24.18*/ 
    /*0*/<-0.43913,-0.72647,-0.52859>,
    /*1*/<-0.83214,0.11612,0.54228>,<0.13173,0.53518,-0.8344>,<0.70776,-0.63913,0.30098>,
            
    /*2*/<-0.81779,0.14288,0.5575>,<0.10054,0.48266,-0.87002>,<0.72494,-0.61155,0.31696>,
            
    /*3*/<-0.80682,0.15951,0.56886>,<0.04352,0.36949,-0.92821>,<0.77546,-0.51635,0.36339>,
            
    /*4*/<0.35856,0.88743,0.28966>

    /* stem 0.24.19*/ 
    /*0*/<0.18664,-0.82935,-0.52664>,
    /*1*/<-0.67398,0.28588,-0.68119>,<0.95547,0.27971,-0.09401>,<-0.28381,-0.55528,0.78174>,
            
    /*2*/<-0.67325,0.28187,-0.68358>,<0.96274,0.24535,-0.11375>,<-0.2905,-0.51729,0.80499>,
            
    /*3*/<-0.67184,0.26848,-0.69032>,<0.97551,0.14949,-0.16135>,<-0.30205,-0.4083,0.86143>,
            
    /*4*/<-0.01142,0.93528,0.35373>

    /* stem 0.24.20*/ 
    /*0*/<0.1689,-0.98164,0.08866>,
    /*1*/<0.5316,0.01569,-0.84685>,<0.45274,0.15786,0.87756>,<-0.9847,-0.17151,-0.03089>,
            
    /*2*/<0.53485,-0.0087,-0.8449>,<0.45393,0.14842,0.87859>,<-0.98987,-0.13777,-0.03436>,
            
    /*3*/<0.53631,-0.04975,-0.84255>,<0.45927,0.09626,0.88307>,<-0.99824,-0.04419,-0.03945>,
            
    /*4*/<0.01739,0.99752,-0.06819>

    /* stem 0.25*/ 
    /*0*/<0.1873,-0.86603,-0.46359>,
    /*1*/<-0.92885,0.00788,-0.37037>,<0.02032,0.48339,-0.87517>,<0.93905,0.30176,-0.16468>,
            <0.55769,-0.286,0.77922>,<-0.59674,-0.46762,0.6521>,
    /*2*/<-0.92879,0.00798,-0.37051>,<0.03005,0.43483,-0.90001>,<0.94547,0.27169,-0.17964>,
            <0.55181,-0.25565,0.79382>,<-0.60646,-0.41867,0.67596>,
    /*3*/<-0.92843,0.00844,-0.3714>,<0.04683,0.33368,-0.94152>,<0.95597,0.20939,-0.20562>,
            <0.54204,-0.19248,0.81801>,<-0.6225,-0.31673,0.71566>,
    /*4*/<-0.10744,0.95799,0.26592>

    /* stem 0.25.0*/ 
    /*0*/<0.64202,-0.69961,-0.31362>,
    /*1*/<0.10312,0.49198,-0.86448>,<0.59922,0.21386,0.77149>,<-0.71557,-0.69143,0.09945>,
            
    /*2*/<0.1203,0.47366,-0.87245>,<0.58481,0.23002,0.77787>,<-0.71803,-0.68874,0.10033>,
            
    /*3*/<0.15125,0.44453,-0.8829>,<0.57941,0.22927,0.78212>,<-0.74434,-0.6593,0.10621>,
            
    /*4*/<-0.59838,0.76026,0.25287>

    /* stem 0.25.1*/ 
    /*0*/<0.21912,-0.96542,0.14127>,
    /*1*/<0.97405,0.22575,-0.01626>,<-0.50328,0.01923,0.86391>,<-0.47524,-0.22527,-0.85053>,
            
    /*2*/<0.94784,0.31778,-0.02476>,<-0.47923,-0.05259,0.87611>,<-0.46923,-0.24279,-0.84904>,
            
    /*3*/<0.93847,0.34429,-0.02718>,<-0.4564,-0.15995,0.87528>,<-0.49042,-0.16454,-0.85581>,
            
    /*4*/<-0.27109,0.95943,0.07747>

    /* stem 0.25.2*/ 
    /*0*/<-0.4308,-0.87303,-0.22853>,
    /*1*/<0.33428,-0.38267,0.86129>,<-0.8897,0.45535,-0.03283>,<0.56416,-0.055,-0.82383>,
            
    /*2*/<0.34377,-0.34513,0.87333>,<-0.93967,0.33503,-0.06903>,<0.59016,0.031,-0.80669>,
            
    /*3*/<0.36185,-0.26278,0.89443>,<-0.96969,0.22126,-0.10364>,<0.61403,0.06004,-0.787>,
            
    /*4*/<0.20635,0.9658,0.15702>

    /* stem 0.25.3*/ 
    /*0*/<-0.07715,-0.62827,-0.77416>,
    /*1*/<-0.82594,-0.3898,0.40728>,<-0.06919,0.78215,-0.61923>,<0.89668,-0.37977,0.22747>,
            
    /*2*/<-0.82612,-0.38091,0.41526>,<-0.07108,0.72428,-0.68584>,<0.90247,-0.32647,0.28102>,
            
    /*3*/<-0.82878,-0.3494,0.43709>,<-0.07073,0.60094,-0.79616>,<0.90038,-0.23356,0.36712>,
            
    /*4*/<-0.04939,0.84323,0.53528>

    /* stem 0.25.4*/ 
    /*0*/<0.54095,-0.46059,-0.70373>,
    /*1*/<-0.70678,0.21436,-0.67418>,<0.74757,0.64398,0.16258>,<-0.05154,-0.84918,0.52558>,
            
    /*2*/<-0.66726,0.16827,-0.72557>,<0.77099,0.62146,0.13912>,<-0.12049,-0.78723,0.60477>,
            
    /*3*/<-0.62296,0.13657,-0.77024>,<0.8401,0.53816,0.06789>,<-0.22135,-0.66116,0.71685>,
            
    /*4*/<-0.41922,0.76954,0.48173>

    /* stem 0.25.5*/ 
    /*0*/<0.64959,-0.75823,-0.05579>,
    /*1*/<0.50584,0.49403,-0.70715>,<0.22892,0.13381,0.9642>,<-0.74752,-0.61295,-0.25596>,
            
    /*2*/<0.49184,0.51231,-0.70401>,<0.26699,0.08787,0.95969>,<-0.77079,-0.58557,-0.25097>,
            
    /*3*/<0.53095,0.45332,-0.71595>,<0.29293,0.05927,0.9543>,<-0.83364,-0.49584,-0.24328>,
            
    /*4*/<-0.46583,0.88187,0.07281>

    /* stem 0.25.6*/ 
    /*0*/<-0.0528,-0.98563,0.16045>,
    /*1*/<0.93303,0.01513,0.35949>,<-0.77495,0.14812,0.61442>,<-0.15705,-0.14405,-0.97703>,
            
    /*2*/<0.93082,-0.06085,0.36038>,<-0.78195,0.09943,0.61536>,<-0.14589,-0.01705,-0.98915>,
            
    /*3*/<0.9264,-0.10456,0.36172>,<-0.78029,0.02237,0.62502>,<-0.1439,0.10114,-0.98441>,
            
    /*4*/<0.0525,0.99535,0.08072>

    /* stem 0.25.7*/ 
    /*0*/<-0.20715,-0.89316,-0.39918>,
    /*1*/<-0.10811,-0.37857,0.91924>,<-0.78585,0.40017,-0.47148>,<0.89796,-0.00439,-0.44006>,
            
    /*2*/<-0.10882,-0.38216,0.91766>,<-0.79722,0.32352,-0.50969>,<0.90982,0.07914,-0.40738>,
            
    /*3*/<-0.11238,-0.37457,0.92036>,<-0.80346,0.19249,-0.56339>,<0.91424,0.20043,-0.35213>,
            
    /*4*/<-0.10626,0.92754,0.35829>

    /* stem 0.25.8*/ 
    /*0*/<0.0531,-0.53695,-0.84194>,
    /*1*/<-0.9826,-0.1764,0.05807>,<0.33517,0.8071,-0.48606>,<0.64642,-0.62047,0.44401>,
            
    /*2*/<-0.98519,-0.13464,0.10617>,<0.33761,0.74348,-0.57728>,<0.64879,-0.5914,0.47888>,
            
    /*3*/<-0.97834,-0.02001,0.20605>,<0.32349,0.54028,-0.77682>,<0.66157,-0.49927,0.55951>,
            
    /*4*/<0.1649,0.87584,0.45356>

    /* stem 0.25.9*/ 
    /*0*/<0.65477,-0.60719,-0.45011>,
    /*1*/<-0.33659,0.30722,-0.89012>,<0.74995,0.48805,0.44652>,<-0.42569,-0.78384,0.45209>,
            
    /*2*/<-0.32992,0.29786,-0.89578>,<0.82751,0.39535,0.39865>,<-0.50518,-0.68661,0.52284>,
            
    /*3*/<-0.32123,0.27998,-0.90467>,<0.91574,0.25575,0.30986>,<-0.60092,-0.52155,0.6057>,
            
    /*4*/<-0.29877,0.88269,0.36277>

    /* stem 0.25.10*/ 
    /*0*/<0.35425,-0.93515,-0.00182>,
    /*1*/<0.83048,0.32214,-0.45446>,<-0.04999,-0.01422,0.99865>,<-0.78711,-0.29045,-0.54416>,
            
    /*2*/<0.85366,0.24552,-0.45934>,<-0.04747,-0.02369,0.99859>,<-0.81248,-0.20374,-0.54623>,
            
    /*3*/<0.87538,0.12355,-0.46737>,<-0.03467,-0.02772,0.99901>,<-0.84265,-0.07743,-0.53287>,
            
    /*4*/<-0.06835,0.99728,0.02767>

    /* stem 0.25.11*/ 
    /*0*/<-0.11016,-0.98691,-0.11778>,
    /*1*/<0.70778,-0.15504,0.68921>,<-0.95775,0.08016,0.27621>,<0.252,0.09305,-0.96324>,
            
    /*2*/<0.70701,-0.13335,0.69451>,<-0.96609,-0.02468,0.25701>,<0.25083,0.17557,-0.95198>,
            
    /*3*/<0.70012,-0.06849,0.71073>,<-0.95977,-0.16309,0.22855>,<0.25772,0.24892,-0.93361>,
            
    /*4*/<-0.16109,0.96686,0.19806>

    /* stem 0.25.12*/ 
    /*0*/<-0.16904,-0.8278,-0.53495>,
    /*1*/<-0.51353,-0.38378,0.76746>,<-0.46969,0.54967,-0.69084>,<0.98629,-0.15085,-0.0669>,
            
    /*2*/<-0.51068,-0.37287,0.77471>,<-0.46669,0.56132,-0.68346>,<0.98142,-0.17362,-0.08164>,
            
    /*3*/<-0.50612,-0.3714,0.7784>,<-0.47649,0.45285,-0.75358>,<0.99787,-0.05697,-0.03164>,
            
    /*4*/<-0.07974,0.91158,0.40332>

    /* stem 0.25.13*/ 
    /*0*/<0.25529,-0.69981,-0.66715>,
    /*1*/<-0.94013,-0.00966,-0.34069>,<0.66868,0.62958,-0.3956>,<0.26689,-0.60742,0.7482>,
            
    /*2*/<-0.93011,-0.03926,-0.36517>,<0.67528,0.6138,-0.40896>,<0.2496,-0.56326,0.78768>,
            
    /*3*/<-0.92161,-0.05795,-0.38378>,<0.69691,0.55527,-0.45386>,<0.2221,-0.48258,0.84723>,
            
    /*4*/<-0.25182,0.83098,0.49603>

    /* stem 0.25.14*/ 
    /*0*/<0.62274,-0.76732,-0.15304>,
    /*1*/<0.103,0.28154,-0.95401>,<0.61427,0.36685,0.69864>,<-0.72826,-0.63485,0.25807>,
            
    /*2*/<0.12575,0.24591,-0.9611>,<0.64043,0.32794,0.69448>,<-0.78136,-0.56212,0.2711>,
            
    /*3*/<0.15151,0.20359,-0.96726>,<0.69417,0.2397,0.67873>,<-0.8544,-0.42847,0.29396>,
            
    /*4*/<-0.35331,0.9269,0.12661>

    /* stem 0.25.15*/ 
    /*0*/<0.14481,-0.98152,0.12508>,
    /*1*/<0.98628,0.14034,-0.08697>,<-0.43568,0.05612,0.89835>,<-0.55312,-0.17937,-0.81356>,
            
    /*2*/<0.99515,0.04151,-0.08918>,<-0.43659,0.01762,0.89949>,<-0.56132,-0.03922,-0.82667>,
            
    /*3*/<0.99705,0.02784,-0.07152>,<-0.42213,-0.15751,0.89275>,<-0.57574,0.14085,-0.80541>,
            
    /*4*/<-0.08939,0.95599,0.27946>

    /* stem 0.25.16*/ 
    /*0*/<-0.30989,-0.9445,-0.10902>,
    /*1*/<0.33922,-0.21104,0.91673>,<-0.93672,0.32763,-0.12333>,<0.60283,-0.10036,-0.79153>,
            
    /*2*/<0.3321,-0.23932,0.91238>,<-0.94698,0.29389,-0.12986>,<0.62139,-0.03792,-0.78259>,
            
    /*3*/<0.32334,-0.29768,0.89824>,<-0.9706,0.18219,-0.15731>,<0.65214,0.13606,-0.74578>,
            
    /*4*/<0.03055,0.9392,0.342>

    /* stem 0.25.17*/ 
    /*0*/<-0.14765,-0.77858,-0.60993>,
    /*1*/<-0.83448,-0.22766,0.50182>,<-0.04013,0.62533,-0.77933>,<0.87709,-0.38457,0.28777>,
            
    /*2*/<-0.83921,-0.26895,0.47264>,<-0.0412,0.61151,-0.79016>,<0.88388,-0.33109,0.33036>,
            
    /*3*/<-0.8414,-0.31732,0.43745>,<-0.0437,0.55245,-0.8324>,<0.88805,-0.22037,0.40349>,
            
    /*4*/<-0.08074,0.86065,0.50275>

    /* stem 0.25.18*/ 
    /*0*/<0.44007,-0.69671,-0.56651>,
    /*1*/<-0.71568,0.11592,-0.68874>,<0.82662,0.56143,-0.03857>,<-0.11825,-0.66578,0.73671>,
            
    /*2*/<-0.71026,0.10601,-0.69591>,<0.84433,0.53254,-0.05924>,<-0.14032,-0.62725,0.76607>,
            
    /*3*/<-0.71421,0.11688,-0.6901>,<0.86831,0.48734,-0.09245>,<-0.16044,-0.59111,0.79047>,
            
    /*4*/<-0.34958,0.77705,0.52344>

    /* stem 0.25.19*/ 
    /*0*/<0.40475,-0.91238,-0.06112>,
    /*1*/<0.51276,0.28618,-0.80943>,<0.39585,0.11909,0.91056>,<-0.91358,-0.39407,-0.10038>,
            
    /*2*/<0.51923,0.26361,-0.81296>,<0.42173,0.03335,0.90611>,<-0.95391,-0.28748,-0.08605>,
            
    /*3*/<0.51929,0.26395,-0.81281>,<0.44911,-0.03306,0.89286>,<-0.97242,-0.21963,-0.07852>,
            
    /*4*/<-0.27443,0.94856,0.1579>

    /* stem 0.25.20*/ 
    /*0*/<-0.07908,-0.95904,0.27199>,
    /*1*/<0.94476,0.01576,0.32739>,<-0.74792,0.23821,0.61958>,<-0.19665,-0.25172,-0.94761>,
            
    /*2*/<0.94159,-0.02066,0.33612>,<-0.74826,0.23537,0.62025>,<-0.19208,-0.2128,-0.95803>,
            
    /*3*/<0.92964,-0.12344,0.34718>,<-0.75254,0.20234,0.62669>,<-0.17482,-0.07649,-0.98163>,
            
    /*4*/<0.20773,0.97808,-0.01461>

    /* stem 0.26*/ 
    /*0*/<0.49384,-0.86603,0.07822>,
    /*1*/<0.15199,0.00778,-0.98835>,<0.85737,0.48329,-0.17706>,<0.37176,0.30166,0.87795>,
            <-0.63374,-0.2861,0.71869>,<-0.76956,-0.46773,-0.43474>,
    /*2*/<0.15214,0.00788,-0.98833>,<0.88376,0.43472,-0.17317>,<0.38778,0.27159,0.88083>,
            <-0.64929,-0.25575,0.71625>,<-0.79501,-0.41877,-0.43885>,
    /*3*/<0.15307,0.00833,-0.98818>,<0.92797,0.33357,-0.16616>,<0.41544,0.20928,0.88522>,
            <-0.67508,-0.19259,0.71217>,<-0.83731,-0.31684,-0.44555>,
    /*4*/<-0.28327,0.95799,-0.04487>

    /* stem 0.26.0*/ 
    /*0*/<0.44851,-0.69585,0.56091>,
    /*1*/<0.86557,0.49189,-0.09398>,<-0.61966,0.2181,0.75396>,<-0.25504,-0.69584,-0.67139>,
            
    /*2*/<0.85242,0.51282,-0.10198>,<-0.5512,0.09709,0.82871>,<-0.32735,-0.60482,-0.72597>,
            
    /*3*/<0.86102,0.49628,-0.11111>,<-0.44945,-0.03485,0.89263>,<-0.42244,-0.44578,-0.7892>,
            
    /*4*/<-0.46513,0.86974,-0.16493>

    /* stem 0.26.1*/ 
    /*0*/<-0.05348,-0.96987,0.23768>,
    /*1*/<0.23472,0.2257,0.9455>,<-0.95743,-0.01097,-0.28845>,<0.72379,-0.19518,-0.66184>,
            
    /*2*/<0.23991,0.1573,0.95797>,<-0.95712,-0.05819,-0.2838>,<0.72604,-0.07762,-0.68325>,
            
    /*3*/<0.24387,0.10215,0.96441>,<-0.95869,-0.10289,-0.26521>,<0.7132,0.0205,-0.70066>,
            
    /*4*/<-0.08528,0.99214,-0.09161>

    /* stem 0.26.2*/ 
    /*0*/<0.23811,-0.91188,-0.33433>,
    /*1*/<-0.76476,-0.38249,0.5185>,<-0.14022,0.31487,-0.93872>,<0.90021,0.08585,0.4269>,
            
    /*2*/<-0.7507,-0.41996,0.50998>,<-0.11025,0.24435,-0.9634>,<0.86473,0.1995,0.46092>,
            
    /*3*/<-0.76786,-0.40276,0.49817>,<-0.02924,0.04719,-0.99846>,<0.79022,0.3707,0.48798>,
            
    /*4*/<-0.44633,0.89103,-0.08279>

    /* stem 0.26.3*/ 
    /*0*/<0.78089,-0.52171,-0.34355>,
    /*1*/<-0.58287,-0.39055,-0.71255>,<0.48944,0.85574,-0.16779>,<0.07795,-0.45485,0.88715>,
            
    /*2*/<-0.55862,-0.40939,-0.72135>,<0.52707,0.83059,-0.17979>,<0.01634,-0.411,0.91149>,
            
    /*3*/<-0.59845,-0.36401,-0.71369>,<0.6215,0.75328,-0.21517>,<-0.03847,-0.37441,0.92647>,
            
    /*4*/<-0.63453,0.71897,0.28364>

    /* stem 0.26.4*/ 
    /*0*/<0.78572,-0.5155,0.34193>,
    /*1*/<0.49812,0.21467,-0.84011>,<0.05472,0.61687,0.78516>,<-0.56825,-0.82144,0.04825>,
            
    /*2*/<0.50543,0.20883,-0.83722>,<0.11459,0.56871,0.81452>,<-0.63941,-0.76855,0.02213>,
            
    /*3*/<0.51918,0.19493,-0.83214>,<0.23909,0.4445,0.86328>,<-0.77793,-0.62777,-0.02715>,
            
    /*4*/<-0.53178,0.83212,-0.1574>

    /* stem 0.26.5*/ 
    /*0*/<0.24475,-0.79039,0.56159>,
    /*1*/<0.80254,0.49419,0.33422>,<-0.87277,0.08007,0.48151>,<0.06547,-0.55888,-0.82666>,
            
    /*2*/<0.82906,0.42433,0.36414>,<-0.85717,0.00178,0.51503>,<0.02092,-0.41251,-0.91071>,
            
    /*3*/<0.86001,0.3098,0.40548>,<-0.82897,-0.03856,0.55796>,<-0.03448,-0.25301,-0.96685>,
            
    /*4*/<-0.17399,0.9553,-0.23903>

    /* stem 0.26.6*/ 
    /*0*/<-0.0699,-0.99755,-0.0012>,
    /*1*/<-0.14103,0.01513,0.98989>,<-0.78397,0.06211,-0.61769>,<0.92634,-0.05803,-0.37218>,
            
    /*2*/<-0.13565,-0.04434,0.98976>,<-0.78096,-0.00209,-0.62457>,<0.92676,0.0692,-0.36923>,
            
    /*3*/<-0.12137,-0.14858,0.98142>,<-0.78584,-0.05874,-0.61563>,<0.9045,0.22563,-0.36191>,
            
    /*4*/<-0.2017,0.96398,0.17338>

    /* stem 0.26.7*/ 
    /*0*/<0.32909,-0.87678,-0.35064>,
    /*1*/<-0.91989,-0.37874,0.1018>,<0.26451,0.44805,-0.85398>,<0.64911,-0.0526,0.75887>,
            
    /*2*/<-0.92755,-0.35736,0.10926>,<0.27455,0.41991,-0.86504>,<0.64683,-0.04542,0.76128>,
            
    /*3*/<-0.93241,-0.34294,0.11407>,<0.30876,0.33198,-0.89133>,<0.62231,0.03019,0.78219>,
            
    /*4*/<-0.33906,0.92911,0.14764>

    /* stem 0.26.8*/ 
    /*0*/<0.7985,-0.59037,-0.11776>,
    /*1*/<-0.27733,-0.17612,-0.94449>,<0.59611,0.77501,0.20977>,<-0.33376,-0.58782,0.73694>,
            
    /*2*/<-0.31369,-0.14048,-0.93907>,<0.6729,0.71307,0.1968>,<-0.36701,-0.55608,0.7457>,
            
    /*3*/<-0.37603,-0.06813,-0.9241>,<0.81434,0.55627,0.16559>,<-0.43998,-0.47034,0.76498>,
            
    /*4*/<-0.47722,0.86135,0.17416>

    /* stem 0.26.9*/ 
    /*0*/<0.53891,-0.75036,0.38282>,
    /*1*/<0.79195,0.30804,-0.52719>,<-0.1605,0.36152,0.91845>,<-0.64142,-0.65567,-0.39834>,
            
    /*2*/<0.79863,0.29737,-0.52322>,<-0.12628,0.3034,0.94446>,<-0.68741,-0.58844,-0.42568>,
            
    /*3*/<0.81463,0.26555,-0.51562>,<-0.06319,0.1932,0.97912>,<-0.76438,-0.44418,-0.46737>,
            
    /*4*/<-0.3528,0.92546,-0.13806>

    /* stem 0.26.10*/ 
    /*0*/<-0.11422,-0.86556,0.48761>,
    /*1*/<0.63083,0.32159,0.70614>,<-0.97949,0.18335,0.08353>,<0.35075,-0.48913,-0.79858>,
            
    /*2*/<0.63016,0.28332,0.72293>,<-0.98642,0.12408,0.10759>,<0.35876,-0.39296,-0.84668>,
            
    /*3*/<0.62544,0.25946,0.73587>,<-0.98271,-0.06779,0.17232>,<0.34238,-0.17997,-0.92216>,
            
    /*4*/<-0.23642,0.95974,-0.15169>

    /* stem 0.26.11*/ 
    /*0*/<-0.17793,-0.94109,-0.28757>,
    /*1*/<-0.51071,-0.15546,0.84558>,<-0.47092,0.34366,-0.81249>,<0.98482,-0.1713,-0.02793>,
            
    /*2*/<-0.50191,-0.06235,0.86267>,<-0.49569,0.22647,-0.83845>,<0.98893,-0.14614,-0.02586>,
            
    /*3*/<-0.49432,0.086,0.86502>,<-0.50867,-0.0494,-0.85954>,<0.99938,-0.02554,-0.02406>,
            
    /*4*/<-0.07106,0.97799,-0.19617>

    /* stem 0.26.12*/ 
    /*0*/<0.50905,-0.68626,-0.51953>,
    /*1*/<-0.8634,-0.38473,-0.32638>,<0.44805,0.73081,-0.51494>,<0.40631,-0.33389,0.85055>,
            
    /*2*/<-0.89592,-0.33284,-0.29419>,<0.48499,0.67331,-0.55807>,<0.40201,-0.32507,0.85599>,
            
    /*3*/<-0.91151,-0.30773,-0.27286>,<0.54322,0.57449,-0.61227>,<0.36343,-0.2525,0.89675>,
            
    /*4*/<-0.42582,0.84331,0.32788>

    /* stem 0.26.13*/ 
    /*0*/<0.6023,-0.79396,0.08286>,
    /*1*/<0.11981,-0.00539,-0.99278>,<0.61785,0.53606,0.57524>,<-0.74817,-0.51682,0.4161>,
            
    /*2*/<0.1032,0.03388,-0.99408>,<0.70133,0.40117,0.58923>,<-0.80338,-0.41989,0.42223>,
            
    /*3*/<0.09678,0.03011,-0.99485>,<0.76709,0.26038,0.58632>,<-0.87092,-0.27492,0.40733>,
            
    /*4*/<-0.27846,0.95917,-0.0495>

    /* stem 0.26.14*/ 
    /*0*/<0.28981,-0.77215,0.5655>,
    /*1*/<0.95276,0.28146,-0.11412>,<-0.54041,0.36117,0.75995>,<-0.41735,-0.62932,-0.65557>,
            
    /*2*/<0.96298,0.25223,-0.09513>,<-0.5368,0.34917,0.76806>,<-0.4307,-0.58869,-0.68407>,
            
    /*3*/<0.96909,0.2339,-0.07852>,<-0.50484,0.19986,0.83976>,<-0.48897,-0.42374,-0.76247>,
            
    /*4*/<-0.25139,0.94862,-0.19216>

    /* stem 0.26.15*/ 
    /*0*/<-0.30687,-0.92315,0.23156>,
    /*1*/<0.30781,0.13985,0.94111>,<-0.93175,0.24972,-0.26359>,<0.62913,-0.37395,-0.68144>,
            
    /*2*/<0.31116,0.16177,0.93649>,<-0.9569,0.15766,-0.2439>,<0.64396,-0.30463,-0.7018>,
            
    /*3*/<0.30946,0.27433,0.91048>,<-0.98092,-0.06247,-0.18409>,<0.65811,-0.19772,-0.72649>,
            
    /*4*/<-0.13539,0.9338,-0.3312>

    /* stem 0.26.16*/ 
    /*0*/<-0.02262,-0.91425,-0.40452>,
    /*1*/<-0.81659,-0.21138,0.53711>,<-0.09083,0.40989,-0.9076>,<0.9078,-0.1833,0.37722>,
            
    /*2*/<-0.81668,-0.20621,0.53899>,<-0.09099,0.38006,-0.92048>,<0.90836,-0.15823,0.3871>,
            
    /*3*/<-0.81702,-0.19989,0.54086>,<-0.08829,0.2975,-0.95063>,<0.90706,-0.08119,0.41309>,
            
    /*4*/<-0.07916,0.96611,0.24568>

    /* stem 0.26.17*/ 
    /*0*/<0.65464,-0.62812,-0.42061>,
    /*1*/<-0.67709,-0.22861,-0.69949>,<0.63043,0.76263,-0.14474>,<0.03597,-0.52377,0.8511>,
            
    /*2*/<-0.69428,-0.2058,-0.68965>,<0.70098,0.68844,-0.18625>,<-0.0077,-0.46733,0.88405>,
            
    /*3*/<-0.73042,-0.13714,-0.66909>,<0.83662,0.47786,-0.26778>,<-0.09427,-0.32376,0.94143>,
            
    /*4*/<-0.28882,0.93786,0.19234>

    /* stem 0.26.18*/ 
    /*0*/<0.6612,-0.6835,0.30927>,
    /*1*/<0.51154,0.1143,-0.85162>,<0.21447,0.57086,0.79254>,<-0.7325,-0.67846,0.05605>,
            
    /*2*/<0.4813,0.1478,-0.86401>,<0.24968,0.53574,0.80663>,<-0.73573,-0.67504,0.0551>,
            
    /*3*/<0.4032,0.23964,-0.88318>,<0.353,0.42418,0.83394>,<-0.75628,-0.65218,0.05199>,
            
    /*4*/<-0.6351,0.77243,0.00152>

    /* stem 0.26.19*/ 
    /*0*/<0.02026,-0.77646,0.62984>,
    /*1*/<0.90463,0.28331,0.3184>,<-0.82098,0.34749,0.45303>,<-0.08372,-0.62821,-0.77353>,
            
    /*2*/<0.89561,0.34625,0.27928>,<-0.81027,0.24706,0.53144>,<-0.09348,-0.58866,-0.80296>,
            
    /*3*/<0.88195,0.41025,0.23207>,<-0.77452,0.08865,0.62631>,<-0.11172,-0.49754,-0.86022>,
            
    /*4*/<-0.30366,0.86662,-0.39593>

    /* stem 0.27*/ 
    /*0*/<0.03488,-0.86603,0.49878>,
    /*1*/<0.99722,0.00768,-0.07418>,<0.36539,0.48319,0.79562>,<-0.77182,0.30156,0.55979>,
            <-0.84283,-0.2862,-0.45577>,<0.25049,-0.46783,-0.84758>,
    /*2*/<0.99723,0.00778,-0.07403>,<0.36753,0.43462,0.82221>,<-0.77102,0.27148,0.57604>,
            <-0.84395,-0.25586,-0.47147>,<0.24877,-0.41888,-0.8733>,
    /*3*/<0.99729,0.00822,-0.0731>,<0.37065,0.33346,0.86685>,<-0.76907,0.20917,0.60397>,
            <-0.84577,-0.19271,-0.49753>,<0.24578,-0.31695,-0.91604>,
    /*4*/<-0.02001,0.95799,-0.2861>

    /* stem 0.27.0*/ 
    /*0*/<-0.52715,-0.64048,0.55848>,
    /*1*/<0.28679,0.49146,0.82233>,<-0.83192,0.27482,-0.48206>,<0.55572,-0.75342,-0.35148>,
            
    /*2*/<0.28886,0.49774,0.81781>,<-0.89126,0.18209,-0.41532>,<0.6045,-0.67316,-0.42596>,
            
    /*3*/<0.2933,0.45446,0.8411>,<-0.95853,-0.00058,-0.285>,<0.67769,-0.44321,-0.58677>,
            
    /*4*/<0.00076,0.90944,-0.41582>

    /* stem 0.27.1*/ 
    /*0*/<-0.1587,-0.97256,0.17009>,
    /*1*/<-0.86905,0.22561,0.44028>,<0.03204,-0.17067,-0.98481>,<0.84017,-0.03566,0.54116>,
            
    /*2*/<-0.86735,0.23398,0.43928>,<0.03661,-0.14821,-0.98828>,<0.83505,-0.06669,0.54611>,
            
    /*3*/<-0.87024,0.22115,0.4402>,<0.03797,-0.15722,-0.98683>,<0.83765,-0.04464,0.54439>,
            
    /*4*/<0.11895,0.9746,-0.18973>

    /* stem 0.27.2*/ 
    /*0*/<0.47789,-0.87791,0.02977>,
    /*1*/<-0.67786,-0.38281,-0.62767>,<0.82131,0.44234,-0.36026>,<-0.15286,-0.04225,0.98734>,
            
    /*2*/<-0.68352,-0.36975,-0.62935>,<0.8518,0.38446,-0.35585>,<-0.17363,0.00417,0.9848>,
            
    /*3*/<-0.68755,-0.35836,-0.63155>,<0.90846,0.25139,-0.33392>,<-0.22288,0.12763,0.96645>,
            
    /*4*/<-0.25751,0.93027,-0.2613>

    /* stem 0.27.3*/ 
    /*0*/<0.42498,-0.61275,0.66628>,
    /*1*/<0.56379,-0.39002,-0.72803>,<0.32535,0.79424,0.51316>,<-0.89741,-0.39229,0.2019>,
            
    /*2*/<0.58273,-0.42507,-0.69264>,<0.33295,0.78054,0.52906>,<-0.92639,-0.34583,0.14904>,
            
    /*3*/<0.58773,-0.41573,-0.69407>,<0.36335,0.72047,0.59068>,<-0.95277,-0.28974,0.09102>,
            
    /*4*/<-0.28078,0.74318,-0.60732>

    /* stem 0.27.4*/ 
    /*0*/<-0.19893,-0.40182,0.89385>,
    /*1*/<0.93089,0.21389,0.29614>,<-0.73215,0.66854,0.13041>,<-0.19491,-0.87469,-0.44377>,
            
    /*2*/<0.90964,0.15895,0.38378>,<-0.7386,0.65781,0.14746>,<-0.15851,-0.81793,-0.55305>,
            
    /*3*/<0.87413,0.11681,0.47144>,<-0.78138,0.57827,0.23463>,<-0.09668,-0.68346,-0.72356>,
            
    /*4*/<0.23372,0.75363,-0.61434>

    /* stem 0.27.5*/ 
    /*0*/<-0.31598,-0.84703,0.42743>,
    /*1*/<-0.14632,0.49442,0.85682>,<-0.73539,-0.05887,-0.67509>,<0.88769,-0.41949,-0.18984>,
            
    /*2*/<-0.15519,0.46528,0.87145>,<-0.74034,-0.07457,-0.66809>,<0.90284,-0.37465,-0.211>,
            
    /*3*/<-0.16879,0.41339,0.89477>,<-0.74124,-0.06419,-0.66816>,<0.91392,-0.33201,-0.23348>,
            
    /*4*/<0.25289,0.90702,-0.33671>

    /* stem 0.27.6*/ 
    /*0*/<-0.00755,-0.99995,-0.00709>,
    /*1*/<-0.99623,0.01319,0.08577>,<0.42399,0.00951,-0.90562>,<0.57238,-0.00386,0.81998>,
            
    /*2*/<-0.99524,0.05947,0.07718>,<0.42285,-0.1171,-0.8986>,<0.58084,0.07195,0.81083>,
            
    /*3*/<-0.99543,0.05259,0.07969>,<0.41878,-0.20237,-0.88525>,<0.57503,0.16754,0.80079>,
            
    /*4*/<-0.02569,0.97936,-0.20048>

    /* stem 0.27.7*/ 
    /*0*/<0.61498,-0.77794,0.12885>,
    /*1*/<-0.3073,-0.37947,-0.87268>,<0.7782,0.62748,0.026>,<-0.48237,-0.2335,0.84427>,
            
    /*2*/<-0.32752,-0.35071,-0.87735>,<0.80511,0.59233,0.03077>,<-0.48728,-0.22607,0.84348>,
            
    /*3*/<-0.34787,-0.3196,-0.88139>,<0.86061,0.50724,0.04544>,<-0.52073,-0.17061,0.8365>,
            
    /*4*/<-0.43923,0.88535,-0.15244>

    /* stem 0.27.8*/ 
    /*0*/<0.26401,-0.64471,0.71739>,
    /*1*/<0.85813,-0.17587,-0.48238>,<-0.05289,0.73728,0.67352>,<-0.81008,-0.54957,-0.20431>,
            
    /*2*/<0.85884,-0.1774,-0.48054>,<-0.03327,0.65217,0.75734>,<-0.84249,-0.45904,-0.28194>,
            
    /*3*/<0.85521,-0.12093,-0.50398>,<0.0096,0.46542,0.88504>,<-0.86529,-0.3262,-0.38062>,
            
    /*4*/<-0.14536,0.92367,-0.35455>

    /* stem 0.27.9*/ 
    /*0*/<-0.40786,-0.58667,0.69962>,
    /*1*/<0.69274,0.30696,0.6526>,<-0.86022,0.50208,-0.08911>,<0.17488,-0.79839,-0.57619>,
            
    /*2*/<0.67794,0.27521,0.68166>,<-0.88898,0.45543,-0.04799>,<0.21875,-0.72414,-0.65404>,
            
    /*3*/<0.6598,0.2441,0.71069>,<-0.92119,0.38871,0.01757>,<0.26645,-0.61914,-0.7387>,
            
    /*4*/<0.28756,0.79629,-0.5322>

    /* stem 0.27.10*/ 
    /*0*/<-0.32385,-0.93383,0.15195>,
    /*1*/<-0.54725,0.32189,0.77259>,<-0.39064,-0.00791,-0.92051>,<0.9437,-0.29725,0.14519>,
            
    /*2*/<-0.55323,0.30316,0.77591>,<-0.39345,-0.01678,-0.91919>,<0.95261,-0.26959,0.14093>,
            
    /*3*/<-0.5408,0.33689,0.77074>,<-0.4019,-0.03642,-0.91496>,<0.94828,-0.28309,0.14359>,
            
    /*4*/<0.35625,0.90988,-0.2126>

    /* stem 0.27.11*/ 
    /*0*/<0.24094,-0.94018,-0.24086>,
    /*1*/<-0.93877,-0.15557,-0.30742>,<0.68511,0.34604,-0.64099>,<0.24941,-0.17389,0.95266>,
            
    /*2*/<-0.94313,-0.12772,-0.30692>,<0.71981,0.20943,-0.66183>,<0.237,-0.06445,0.96937>,
            
    /*3*/<-0.94738,-0.01525,-0.31976>,<0.74265,-0.06799,-0.66622>,<0.21255,0.09528,0.97249>,
            
    /*4*/<0.12607,0.97706,-0.17167>

    /* stem 0.27.12*/ 
    /*0*/<0.46085,-0.79141,0.4016>,
    /*1*/<0.12478,-0.38419,-0.91478>,<0.69418,0.6075,0.38608>,<-0.82702,-0.20949,0.52169>,
            
    /*2*/<0.12784,-0.39179,-0.91113>,<0.73335,0.52149,0.43616>,<-0.87092,-0.11043,0.47885>,
            
    /*3*/<0.13477,-0.39809,-0.90739>,<0.77998,0.35669,0.5142>,<-0.91798,0.05951,0.39215>,
            
    /*4*/<-0.03363,0.91122,-0.41055>

    /* stem 0.27.13*/ 
    /*0*/<0.06289,-0.7323,0.67807>,
    /*1*/<0.99425,-0.00581,-0.10695>,<-0.42642,0.59887,0.67787>,<-0.5689,-0.58047,-0.58258>,
            
    /*2*/<0.99606,-0.03743,-0.0804>,<-0.42632,0.59124,0.6846>,<-0.57002,-0.54228,-0.61726>,
            
    /*3*/<0.99631,-0.06582,-0.05501>,<-0.42894,0.5246,0.73539>,<-0.57202,-0.44425,-0.68952>,
            
    /*4*/<0.03254,0.86906,-0.49364>

    /* stem 0.27.14*/ 
    /*0*/<-0.56234,-0.71302,0.41878>,
    /*1*/<0.32588,0.28102,0.90268>,<-0.81753,0.42328,-0.39049>,<0.5011,-0.69231,-0.51923>,
            
    /*2*/<0.32096,0.27386,0.90664>,<-0.84131,0.39054,-0.37374>,<0.52918,-0.65289,-0.54195>,
            
    /*3*/<0.32327,0.28001,0.90393>,<-0.87225,0.34418,-0.34744>,<0.55663,-0.61081,-0.5631>,
            
    /*4*/<0.45083,0.78883,-0.41773>

    /* stem 0.27.15*/ 
    /*0*/<-0.19821,-0.97751,-0.07203>,
    /*1*/<-0.84832,0.14003,0.51063>,<0.00226,0.07863,-0.9969>,<0.84934,-0.20251,0.48746>,
            
    /*2*/<-0.83807,0.18785,0.5122>,<-0.00753,0.03974,-0.99918>,<0.84741,-0.21095,0.48724>,
            
    /*3*/<-0.83596,0.20343,0.50969>,<-0.01294,-0.01346,-0.99983>,<0.85347,-0.17397,0.49124>,
            
    /*4*/<0.17278,0.98438,-0.03366>

    /* stem 0.27.16*/ 
    /*0*/<0.30456,-0.95241,-0.01263>,
    /*1*/<-0.70653,-0.2113,-0.6754>,<0.90556,0.29925,-0.30068>,<-0.20397,-0.07249,0.97629>,
            
    /*2*/<-0.70901,-0.20222,-0.67558>,<0.914,0.2723,-0.30077>,<-0.20898,-0.05438,0.97641>,
            
    /*3*/<-0.71217,-0.18558,-0.67703>,<0.93868,0.17777,-0.29543>,<-0.22619,0.02433,0.97378>,
            
    /*4*/<-0.14307,0.98294,-0.11562>

    /* stem 0.27.17*/ 
    /*0*/<0.42438,-0.75901,0.49377>,
    /*1*/<0.53061,-0.22904,-0.81608>,<0.36655,0.64584,0.66973>,<-0.90218,-0.40783,0.14052>,
            
    /*2*/<0.54325,-0.26197,-0.79765>,<0.38485,0.60056,0.70087>,<-0.93954,-0.32977,0.09228>,
            
    /*3*/<0.56428,-0.32634,-0.75835>,<0.41027,0.53939,0.73534>,<-0.97884,-0.204,0.01613>,
            
    /*4*/<-0.13302,0.84491,-0.5181>

    /* stem 0.27.18*/ 
    /*0*/<-0.14057,-0.71241,0.68754>,
    /*1*/<0.94459,0.11317,0.30813>,<-0.72945,0.54502,0.41334>,<-0.21448,-0.65488,-0.72466>,
            
    /*2*/<0.94357,0.10584,0.3138>,<-0.74031,0.49531,0.45455>,<-0.20688,-0.59865,-0.77383>,
            
    /*3*/<0.93782,0.06106,0.3417>,<-0.74848,0.4287,0.50596>,<-0.18794,-0.48727,-0.85279>,
            
    /*4*/<0.1597,0.87252,-0.46175>

    /* stem 0.28*/ 
    /*0*/<-0.47815,-0.86603,0.14619>,
    /*1*/<0.29653,0.00754,0.955>,<-0.69311,0.48305,0.53503>,<-0.71914,0.30142,-0.62609>,
            <0.25442,-0.28634,-0.92373>,<0.88213,-0.46797,0.05343>,
    /*2*/<0.29638,0.00764,0.95504>,<-0.71853,0.43448,0.54309>,<-0.73479,0.27134,-0.62166>,
            <0.26947,-0.256,-0.92836>,<0.90681,-0.41902,0.04597>,
    /*3*/<0.29551,0.00808,0.95531>,<-0.7613,0.33331,0.55617>,<-0.76155,0.20903,-0.61348>,
            <0.29446,-0.19285,-0.936>,<0.9478,-0.3171,0.03344>,
    /*4*/<0.27427,0.95799,-0.08385>

    /* stem 0.28.0*/ 
    /*0*/<-0.63986,-0.72078,-0.26656>,
    /*1*/<-0.73697,0.4919,0.46357>,<0.19897,0.18815,-0.96177>,<0.5506,-0.66587,0.50345>,
            
    /*2*/<-0.71406,0.51763,0.47135>,<0.1729,0.16028,-0.97181>,<0.55344,-0.66299,0.50412>,
            
    /*3*/<-0.73359,0.48863,0.47231>,<0.11109,0.06898,-0.99141>,<0.64744,-0.54741,0.53025>,
            
    /*4*/<0.49524,0.86803,0.03548>

    /* stem 0.28.1*/ 
    /*0*/<-0.16386,-0.97523,-0.14857>,
    /*1*/<-0.62475,0.22552,-0.74754>,<0.97435,-0.12894,-0.18443>,<-0.3464,-0.07755,0.93488>,
            
    /*2*/<-0.6256,0.2211,-0.74815>,<0.96539,-0.1793,-0.18942>,<-0.33435,-0.02337,0.94216>,
            
    /*3*/<-0.62807,0.21135,-0.74891>,<0.94228,-0.27074,-0.19701>,<-0.3077,0.07774,0.9483>,
            
    /*4*/<0.32111,0.94687,-0.01816>

    /* stem 0.28.2*/ 
    /*0*/<0.08076,-0.87719,0.47329>,
    /*1*/<0.4591,-0.38293,-0.80162>,<0.5356,0.44415,0.71823>,<-0.99625,-0.04433,0.07427>,
            
    /*2*/<0.45874,-0.37286,-0.80656>,<0.53786,0.41501,0.7338>,<-0.99759,-0.02472,0.06476>,
            
    /*3*/<0.46014,-0.35614,-0.81328>,<0.52722,0.26055,0.8088>,<-0.99276,0.11933,0.01336>,
            
    /*4*/<0.23214,0.93272,-0.27596>

    /* stem 0.28.3*/ 
    /*0*/<-0.55246,-0.64059,0.53333>,
    /*1*/<0.83612,-0.38992,0.38583>,<-0.44674,0.77185,0.4524>,<-0.37883,-0.3697,-0.84841>,
            
    /*2*/<0.89755,-0.29572,0.32703>,<-0.50642,0.68102,0.52891>,<-0.37743,-0.36521,-0.85098>,
            
    /*3*/<0.96328,-0.13067,0.23454>,<-0.6049,0.46285,0.64797>,<-0.36137,-0.31265,-0.87844>,
            
    /*4*/<0.13311,0.93492,-0.32895>

    /* stem 0.28.4*/ 
    /*0*/<-0.84988,-0.52547,0.03982>,
    /*1*/<-0.07967,0.21462,0.97344>,<-0.40252,0.61138,-0.68131>,<0.49826,-0.81606,-0.29288>,
            
    /*2*/<-0.06099,0.22941,0.97142>,<-0.46461,0.56967,-0.67795>,<0.53924,-0.78737,-0.29878>,
            
    /*3*/<-0.05158,0.23027,0.97176>,<-0.58306,0.46912,-0.6633>,<0.65082,-0.68935,-0.31817>,
            
    /*4*/<0.61806,0.77574,-0.12737>

    /* stem 0.28.5*/ 
    /*0*/<-0.48466,-0.83797,-0.25083>,
    /*1*/<-0.86783,0.49429,0.0504>,<0.50924,-0.02964,-0.86011>,<0.36766,-0.44898,0.8144>,
            
    /*2*/<-0.91307,0.40586,0.03974>,<0.49659,-0.06348,-0.86566>,<0.42491,-0.32544,0.84471>,
            
    /*3*/<-0.94789,0.31718,0.03002>,<0.45878,-0.12281,-0.88002>,<0.49562,-0.17725,0.85026>,
            
    /*4*/<0.31513,0.94899,-0.01087>

    /* stem 0.28.6*/ 
    /*0*/<0.16315,-0.98478,-0.05991>,
    /*1*/<-0.30865,0.01299,-0.95109>,<0.96462,0.15301,0.2147>,<-0.65899,-0.14777,0.7375>,
            
    /*2*/<-0.30453,-0.0276,-0.9521>,<0.96792,0.12987,0.21508>,<-0.66862,-0.08398,0.73885>,
            
    /*3*/<-0.30443,0.03978,-0.9517>,<0.97881,0.02182,0.20361>,<-0.67179,-0.04155,0.73957>,
            
    /*4*/<0.04299,0.99018,0.13301>

    /* stem 0.28.7*/ 
    /*0*/<-0.1324,-0.87208,0.47112>,
    /*1*/<0.78207,-0.37901,-0.49469>,<0.13842,0.45981,0.87716>,<-0.91808,-0.06492,-0.39106>,
            
    /*2*/<0.77794,-0.40221,-0.48274>,<0.13737,0.45412,0.88029>,<-0.91279,-0.03638,-0.4068>,
            
    /*3*/<0.77661,-0.39427,-0.49136>,<0.1421,0.46055,0.87618>,<-0.91731,-0.05126,-0.39486>,
            
    /*4*/<0.09609,0.87017,-0.48329>

    /* stem 0.28.8*/ 
    /*0*/<-0.6214,-0.67711,0.3942>,
    /*1*/<0.66289,-0.17573,0.7278>,<-0.69261,0.71196,0.11581>,<0.04097,-0.52397,-0.85075>,
            
    /*2*/<0.70724,-0.11034,0.69831>,<-0.75998,0.62824,0.16655>,<0.05585,-0.49886,-0.86488>,
            
    /*3*/<0.74295,-0.05834,0.6668>,<-0.83892,0.49593,0.22421>,<0.1018,-0.42293,-0.90042>,
            
    /*4*/<0.37185,0.87599,-0.30718>

    /* stem 0.28.9*/ 
    /*0*/<-0.64723,-0.75529,-0.10308>,
    /*1*/<-0.48086,0.30791,0.82095>,<-0.26328,0.35588,-0.89668>,<0.75571,-0.65029,0.07757>,
            
    /*2*/<-0.53623,0.21494,0.81625>,<-0.285,0.31613,-0.9049>,<0.84688,-0.52202,0.10147>,
            
    /*3*/<-0.57941,0.14631,0.8018>,<-0.34527,0.22101,-0.91211>,<0.93003,-0.35096,0.10901>,
            
    /*4*/<0.321,0.94653,0.03236>

    /* stem 0.28.10*/ 
    /*0*/<-0.25457,-0.94426,-0.20874>,
    /*1*/<-0.87572,0.32188,-0.35988>,<0.79259,-0.07363,-0.6053>,<0.08763,-0.23156,0.96887>,
            
    /*2*/<-0.87494,0.3234,-0.36039>,<0.76407,-0.18777,-0.6172>,<0.12827,-0.12362,0.984>,
            
    /*3*/<-0.88574,0.29821,-0.35571>,<0.70475,-0.34084,-0.62222>,<0.18931,0.05912,0.98014>,
            
    /*4*/<0.34717,0.91724,-0.19533>

    /* stem 0.28.11*/ 
    /*0*/<0.26601,-0.94709,0.17962>,
    /*1*/<0.08851,-0.15559,-0.98385>,<0.78458,0.32647,0.52711>,<-0.87773,-0.15436,0.4536>,
            
    /*2*/<0.08554,-0.13275,-0.98745>,<0.80331,0.24448,0.54307>,<-0.88959,-0.0944,0.44689>,
            
    /*3*/<0.08213,-0.06245,-0.99466>,<0.82193,0.09524,0.56157>,<-0.90164,-0.01573,0.43219>,
            
    /*4*/<-0.01286,0.99967,-0.02216>

    /* stem 0.28.12*/ 
    /*0*/<-0.25373,-0.73099,0.63347>,
    /*1*/<0.91919,-0.38461,-0.08468>,<-0.19281,0.68424,0.70331>,<-0.72202,-0.28707,-0.62951>,
            
    /*2*/<0.92267,-0.37477,-0.09075>,<-0.21625,0.62376,0.75111>,<-0.70651,-0.23324,-0.66816>,
            
    /*3*/<0.92851,-0.35818,-0.09788>,<-0.26556,0.48775,0.83161>,<-0.66406,-0.11239,-0.73918>,
            
    /*4*/<0.31099,0.89596,-0.31708>

    /* stem 0.28.13*/ 
    /*0*/<-0.66176,-0.71696,0.21919>,
    /*1*/<0.32789,-0.00597,0.9447>,<-0.74379,0.61269,-0.26719>,<0.42708,-0.5946,-0.68121>,
            
    /*2*/<0.36804,0.06478,0.92755>,<-0.84415,0.48593,-0.22646>,<0.46452,-0.53283,-0.70733>,
            
    /*3*/<0.41657,0.15197,0.89631>,<-0.95407,0.25375,-0.15928>,<0.53552,-0.39181,-0.74814>,
            
    /*4*/<0.18097,0.94813,-0.26135>

    /* stem 0.28.14*/ 
    /*0*/<-0.47676,-0.82495,-0.30359>,
    /*1*/<-0.80659,0.2816,0.51973>,<0.10999,0.29271,-0.94985>,<0.70453,-0.56059,0.43517>,
            
    /*2*/<-0.81951,0.25533,0.51304>,<0.08959,0.24784,-0.96465>,<0.74183,-0.49066,0.45711>,
            
    /*3*/<-0.84301,0.19189,0.50251>,<0.04573,0.14085,-0.98897>,<0.81087,-0.31842,0.49102>,
            
    /*4*/<0.21369,0.97402,0.07499>

    /* stem 0.28.15*/ 
    /*0*/<0.00822,-0.98111,-0.19325>,
    /*1*/<-0.68828,0.13995,-0.71182>,<0.97231,0.05825,-0.22634>,<-0.28416,-0.18227,0.94129>,
            
    /*2*/<-0.69045,0.11112,-0.7148>,<0.97271,-0.00437,-0.23197>,<-0.28087,-0.0905,0.95547>,
            
    /*3*/<-0.69648,0.0565,-0.71534>,<0.96239,-0.12641,-0.24046>,<-0.26286,0.08681,0.96092>,
            
    /*4*/<0.16473,0.97813,-0.12699>

    /* stem 0.28.16*/ 
    /*0*/<0.16739,-0.92591,0.33864>,
    /*1*/<0.4987,-0.21151,-0.84057>,<0.48536,0.38128,0.7868>,<-0.98674,-0.15494,0.04835>,
            
    /*2*/<0.50443,-0.24694,-0.82739>,<0.48409,0.39162,0.78249>,<-0.99073,-0.13042,0.03804>,
            
    /*3*/<0.50511,-0.27413,-0.81836>,<0.48991,0.36977,0.78947>,<-0.99646,-0.08058,0.02382>,
            
    /*4*/<-0.06436,0.93542,-0.34764>

    /* stem 0.28.17*/ 
    /*0*/<-0.37979,-0.78367,0.49155>,
    /*1*/<0.91458,-0.22879,0.33347>,<-0.58386,0.61826,0.52617>,<-0.32601,-0.37976,-0.86573>,
            
    /*2*/<0.92161,-0.21125,0.32559>,<-0.61459,0.55324,0.56232>,<-0.30754,-0.33004,-0.89246>,
            
    /*3*/<0.93036,-0.18622,0.31584>,<-0.66006,0.43314,0.61377>,<-0.26963,-0.23515,-0.93381>,
            
    /*4*/<0.27035,0.92661,-0.26136>

    /* stem 0.28.18*/ 
    /*0*/<-0.71942,-0.69444,0.01406>,
    /*1*/<-0.08773,0.11313,0.9897>,<-0.55106,0.56058,-0.61812>,<0.6421,-0.67051,-0.37164>,
            
    /*2*/<-0.06834,0.14644,0.98686>,<-0.66434,0.42104,-0.61756>,<0.72443,-0.56575,-0.39387>,
            
    /*3*/<-0.04201,0.17897,0.98296>,<-0.78471,0.21011,-0.58317>,<0.82851,-0.38595,-0.40573>,
            
    /*4*/<0.27739,0.9474,-0.15963>

    /* stem 0.29*/ 
    /*0*/<-0.25,-0.86603,-0.43301>,
    /*1*/<-0.86384,0.00746,0.50371>,<-0.67726,0.48297,-0.55504>,<0.44825,0.30134,-0.84159>,
            <0.95726,-0.28643,0.04006>,<0.14635,-0.46805,0.8715>,
    /*2*/<-0.86391,0.00755,0.50358>,<-0.69083,0.43439,-0.57798>,<0.44041,0.27126,-0.85584>,
            <0.96516,-0.25609,0.05369>,<0.15918,-0.41911,0.89388>,
    /*3*/<-0.86437,0.00798,0.5028>,<-0.71318,0.33322,-0.61671>,<0.42642,0.20893,-0.88006>,
            <0.97824,-0.19294,0.07633>,<0.18061,-0.31719,0.931>,
    /*4*/<0.1434,0.95799,0.24838>

    /* stem 0.29.0*/ 
    /*0*/<0.18221,-0.67579,-0.71422>,
    /*1*/<-0.6179,0.49157,-0.61365>,<0.97036,0.23983,0.02973>,<-0.35601,-0.71822,0.59784>,
            
    /*2*/<-0.61745,0.49062,-0.61486>,<0.98233,0.18611,-0.01973>,<-0.36403,-0.66562,0.65149>,
            
    /*3*/<-0.61876,0.47135,-0.62846>,<0.99029,0.09317,-0.10317>,<-0.37144,-0.55129,0.74707>,
            
    /*4*/<0.03686,0.83698,0.54599>

    /* stem 0.29.1*/ 
    /*0*/<0.13393,-0.97568,-0.17352>,
    /*1*/<0.58769,0.22545,-0.77704>,<0.39532,-0.10151,0.91292>,<-0.98559,-0.10513,-0.13253>,
            
    /*2*/<0.5838,0.29201,-0.75756>,<0.41033,-0.20328,0.88899>,<-0.98998,-0.07288,-0.12094>,
            
    /*3*/<0.57442,0.39772,-0.71544>,<0.41303,-0.31711,0.85372>,<-0.98928,-0.06252,-0.13201>,
            
    /*4*/<-0.14993,0.89111,0.42831>

    /* stem 0.29.2*/ 
    /*0*/<-0.43275,-0.89212,0.12984>,
    /*1*/<0.88425,-0.3829,0.26737>,<-0.60152,0.39958,0.69175>,<-0.27449,0.00032,-0.96159>,
            
    /*2*/<0.88999,-0.37007,0.2664>,<-0.61818,0.36492,0.6962>,<-0.26484,0.02276,-0.96402>,
            
    /*3*/<0.90157,-0.34143,0.2657>,<-0.65042,0.29161,0.70137>,<-0.24514,0.06781,-0.96711>,
            
    /*4*/<0.34461,0.93874,-0.00249>

    /* stem 0.29.3*/ 
    /*0*/<-0.73238,-0.55214,-0.39844>,
    /*1*/<-0.18734,-0.39052,0.90133>,<-0.46515,0.8368,-0.28879>,<0.66633,-0.43585,-0.60501>,
            
    /*2*/<-0.18491,-0.38719,0.90327>,<-0.52868,0.7817,-0.33081>,<0.72705,-0.37929,-0.5723>,
            
    /*3*/<-0.16824,-0.35329,0.92026>,<-0.64219,0.64736,-0.41051>,<0.816,-0.27624,-0.50778>,
            
    /*4*/<0.43533,0.8239,0.36288>

    /* stem 0.29.4*/ 
    /*0*/<-0.24288,-0.64615,-0.72354>,
    /*1*/<-0.96636,0.21532,0.14068>,<0.54164,0.53347,-0.64964>,<0.42925,-0.73675,0.52245>,
            
    /*2*/<-0.96412,0.22145,0.14637>,<0.53156,0.50488,-0.6801>,<0.43866,-0.71376,0.54601>,
            
    /*3*/<-0.94517,0.26993,0.18385>,<0.49563,0.41748,-0.76161>,<0.45579,-0.67128,0.5845>,
            
    /*4*/<0.37272,0.75381,0.54116>

    /* stem 0.29.5*/ 
    /*0*/<0.17691,-0.82668,-0.53414>,
    /*1*/<-0.24458,0.49414,-0.83427>,<0.94651,0.0015,0.32266>,<-0.7052,-0.48041,0.52145>,
            
    /*2*/<-0.24168,0.46865,-0.84968>,<0.95216,-0.03308,0.3038>,<-0.71513,-0.4212,0.55783>,
            
    /*3*/<-0.23494,0.37041,-0.89867>,<0.95642,-0.03867,0.28943>,<-0.72541,-0.31422,0.61241>,
            
    /*4*/<-0.08065,0.94537,0.31585>

    /* stem 0.29.6*/ 
    /*0*/<-0.00737,-0.99964,-0.02576>,
    /*1*/<0.85791,0.013,-0.51364>,<0.01606,-0.01979,0.99968>,<-0.87384,0.02505,-0.48557>,
            
    /*2*/<0.8541,-0.0446,-0.51819>,<0.01436,-0.03646,0.99923>,<-0.86908,0.09996,-0.48447>,
            
    /*3*/<0.85362,-0.06053,-0.51738>,<0.00875,-0.13227,0.99117>,<-0.85914,0.20913,-0.46705>,
            
    /*4*/<0.15446,0.96491,0.21235>

    /* stem 0.29.7*/ 
    /*0*/<-0.61376,-0.77283,0.16137>,
    /*1*/<0.65864,-0.37968,0.64964>,<-0.70555,0.63413,0.31637>,<0.05792,-0.24057,-0.9689>,
            
    /*2*/<0.67408,-0.35767,0.64628>,<-0.73462,0.59605,0.32413>,<0.06966,-0.22318,-0.97229>,
            
    /*3*/<0.69709,-0.31674,0.64323>,<-0.83095,0.44352,0.33588>,<0.1288,-0.10661,-0.98592>,
            
    /*4*/<0.35581,0.93318,0.05072>

    /* stem 0.29.8*/ 
    /*0*/<-0.55569,-0.63996,-0.53073>,
    /*1*/<-0.55991,-0.17603,0.80964>,<-0.24474,0.74067,-0.62571>,<0.81451,-0.55328,-0.17451>,
            
    /*2*/<-0.51974,-0.11933,0.84595>,<-0.30243,0.67537,-0.67262>,<0.82559,-0.53896,-0.16709>,
            
    /*3*/<-0.49368,-0.0951,0.86443>,<-0.35946,0.59266,-0.72079>,<0.86371,-0.48525,-0.13616>,
            
    /*4*/<0.45584,0.79528,0.39966>

    /* stem 0.29.9*/ 
    /*0*/<0.05218,-0.60053,-0.7979>,
    /*1*/<-0.90866,0.30692,-0.2831>,<0.81318,0.49248,-0.31016>,<0.09456,-0.78887,0.60724>,
            
    /*2*/<-0.90776,0.28132,-0.31118>,<0.8171,0.46505,-0.3407>,<0.09027,-0.73797,0.66876>,
            
    /*3*/<-0.905,0.1929,-0.37917>,<0.83106,0.36193,-0.42231>,<0.07658,-0.54647,0.83397>,
            
    /*4*/<-0.06845,0.9097,0.40959>

    /* stem 0.29.10*/ 
    /*0*/<0.28494,-0.92138,-0.26435>,
    /*1*/<0.15288,0.32162,-0.93444>,<0.74035,0.04273,0.67086>,<-0.89816,-0.34844,0.26815>,
            
    /*2*/<0.15868,0.29153,-0.94331>,<0.75107,-0.00554,0.6602>,<-0.91784,-0.27065,0.29037>,
            
    /*3*/<0.16446,0.25112,-0.95388>,<0.76471,-0.05254,0.64223>,<-0.9313,-0.18201,0.31552>,
            
    /*4*/<-0.10967,0.96938,0.21973>

    /* stem 0.29.11*/ 
    /*0*/<-0.1143,-0.94569,0.30432>,
    /*1*/<0.97852,-0.15576,-0.13505>,<-0.33664,0.33041,0.88176>,<-0.63995,-0.15863,-0.75187>,
            
    /*2*/<0.97644,-0.17141,-0.13112>,<-0.3428,0.29446,0.89207>,<-0.63341,-0.10667,-0.76643>,
            
    /*3*/<0.97776,-0.16334,-0.13158>,<-0.35148,0.21843,0.91036>,<-0.62396,-0.03852,-0.78051>,
            
    /*4*/<0.12655,0.98257,-0.13619>

    /* stem 0.29.12*/ 
    /*0*/<-0.61611,-0.78679,-0.03696>,
    /*1*/<0.30837,-0.27716,0.91>,<-0.77797,0.62081,-0.09669>,<0.47988,-0.33054,-0.81269>,
            
    /*2*/<0.36265,-0.18966,0.91242>,<-0.83901,0.53643,-0.09112>,<0.48008,-0.32936,-0.81305>,
            
    /*3*/<0.41029,-0.10242,0.90618>,<-0.8786,0.46669,-0.10132>,<0.47572,-0.34975,-0.80707>,
            
    /*4*/<0.49284,0.8622,-0.11711>

    /* stem 0.29.13*/ 
    /*0*/<-0.41157,-0.61517,-0.67244>,
    /*1*/<-0.84651,-0.00663,0.53233>,<0.13918,0.69109,-0.70924>,<0.71411,-0.67432,0.18799>,
            
    /*2*/<-0.84427,-0.00196,0.53591>,<0.11219,0.6433,-0.75735>,<0.74224,-0.62991,0.22866>,
            
    /*3*/<-0.85148,-0.02802,0.52363>,<0.05925,0.50971,-0.85831>,<0.8135,-0.46981,0.34279>,
            
    /*4*/<0.17621,0.89257,0.41506>

    /* stem 0.29.14*/ 
    /*0*/<0.28269,-0.7499,-0.59811>,
    /*1*/<-0.68832,0.28104,-0.66876>,<0.92178,0.38575,-0.03904>,<-0.23799,-0.65476,0.71739>,
            
    /*2*/<-0.68219,0.2621,-0.68259>,<0.9278,0.36965,-0.05051>,<-0.25055,-0.62019,0.74336>,
            
    /*3*/<-0.67195,0.22831,-0.70452>,<0.94974,0.29903,-0.09263>,<-0.27959,-0.51554,0.80997>,
            
    /*4*/<-0.16727,0.89356,0.41661>

    /* stem 0.29.15*/ 
    /*0*/<0.37686,-0.92133,0.09551>,
    /*1*/<0.5378,0.13948,-0.83146>,<0.38002,0.25336,0.8896>,<-0.92374,-0.37834,-0.05965>,
            
    /*2*/<0.53778,0.14011,-0.83136>,<0.39659,0.2071,0.89433>,<-0.94096,-0.3328,-0.06201>,
            
    /*3*/<0.53863,0.13852,-0.83108>,<0.4281,0.09791,0.89841>,<-0.97301,-0.22177,-0.06384>,
            
    /*4*/<-0.16449,0.98519,0.04841>

    /* stem 0.29.16*/ 
    /*0*/<-0.2858,-0.93434,0.21288>,
    /*1*/<0.93089,-0.21243,0.29719>,<-0.66491,0.35742,0.65585>,<-0.26229,-0.13293,-0.95579>,
            
    /*2*/<0.90557,-0.29115,0.30849>,<-0.66473,0.35733,0.65609>,<-0.23182,-0.05675,-0.9711>,
            
    /*3*/<0.841,-0.43962,0.31537>,<-0.64964,0.37138,0.66336>,<-0.18132,0.07669,-0.98043>,
            
    /*4*/<0.53168,0.84658,0.02482>

    /* stem 0.29.17*/ 
    /*0*/<-0.68869,-0.68048,-0.25032>,
    /*1*/<-0.12072,-0.23123,0.96538>,<-0.55747,0.71875,-0.41548>,<0.6806,-0.48513,-0.54902>,
            
    /*2*/<-0.09653,-0.20574,0.97383>,<-0.58183,0.69462,-0.42305>,<0.6799,-0.48585,-0.54926>,
            
    /*3*/<-0.06449,-0.1708,0.98319>,<-0.6658,0.59393,-0.45161>,<0.7309,-0.41826,-0.5393>,
            
    /*4*/<0.49633,0.85155,0.16884>

    /* stem 0.30*/ 
    /*0*/<0.36568,-0.86603,-0.341>,
    /*1*/<-0.68506,0.0073,-0.72845>,<0.38853,0.48281,-0.78482>,<0.92092,0.30118,0.24738>,
            <0.17637,-0.28658,0.94168>,<-0.81617,-0.46821,0.33858>,
    /*2*/<-0.68495,0.00739,-0.72855>,<0.40783,0.43423,-0.80319>,<0.93304,0.2711,0.23654>,
            <0.16487,-0.25625,0.95245>,<-0.8351,-0.41927,0.35612>,
    /*3*/<-0.6843,0.00781,-0.72916>,<0.44052,0.33305,-0.83368>,<0.95348,0.20876,0.21747>,
            <0.14573,-0.19311,0.97029>,<-0.86647,-0.31736,0.38537>,
    /*4*/<-0.20975,0.95799,0.1956>

    /* stem 0.30.0*/ 
    /*0*/<0.74112,-0.67098,0.02268>,
    /*1*/<0.459,0.49144,-0.74014>,<0.18386,0.24474,0.952>,<-0.657,-0.72338,-0.21229>,
            
    /*2*/<0.47201,0.47888,-0.74019>,<0.19767,0.23121,0.95261>,<-0.68418,-0.69755,-0.2129>,
            
    /*3*/<0.50396,0.44487,-0.74035>,<0.2439,0.17568,0.95376>,<-0.76451,-0.60863,-0.21233>,
            
    /*4*/<-0.56991,0.81973,0.05699>

    /* stem 0.30.1*/ 
    /*0*/<0.24751,-0.96867,-0.02038>,
    /*1*/<0.88905,0.22529,0.39854>,<-0.77722,-0.20461,0.59503>,<-0.11651,-0.00236,-0.99319>,
            
    /*2*/<0.87537,0.26562,0.40394>,<-0.75224,-0.29158,0.59087>,<-0.13328,0.04091,-0.99023>,
            
    /*3*/<0.86358,0.29517,0.40879>,<-0.71373,-0.40312,0.57278>,<-0.15785,0.12493,-0.97953>,
            
    /*4*/<-0.38704,0.89733,0.21213>

    /* stem 0.30.2*/ 
    /*0*/<0.01995,-0.9214,-0.38811>,
    /*1*/<-0.06315,-0.38283,0.92166>,<-0.83273,0.20532,-0.51421>,<0.8955,0.19472,-0.4002>,
            
    /*2*/<-0.06199,-0.38997,0.91874>,<-0.81781,0.10074,-0.56661>,<0.87969,0.31278,-0.3582>,
            
    /*3*/<-0.05329,-0.43472,0.89899>,<-0.80788,0.02777,-0.58869>,<0.85463,0.42215,-0.30232>,
            
    /*4*/<-0.2563,0.85491,0.45104>

    /* stem 0.30.3*/ 
    /*0*/<0.24773,-0.60686,-0.75522>,
    /*1*/<-0.92049,-0.39025,0.01982>,<0.1923,0.79853,-0.57041>,<0.72361,-0.39704,0.56458>,
            
    /*2*/<-0.93803,-0.34089,0.06236>,<0.22219,0.7135,-0.66449>,<0.71444,-0.35336,0.60392>,
            
    /*3*/<-0.95598,-0.26657,0.12264>,<0.26032,0.58384,-0.769>,<0.69251,-0.30177,0.65525>,
            
    /*4*/<-0.14265,0.83943,0.5244>

    /* stem 0.30.4*/ 
    /*0*/<0.73895,-0.5362,-0.40797>,
    /*1*/<-0.35492,0.21457,-0.90994>,<0.66907,0.60533,0.4312>,<-0.32764,-0.8101,0.48619>,
            
    /*2*/<-0.34439,0.20078,-0.91711>,<0.78305,0.49053,0.38239>,<-0.44595,-0.68738,0.57327>,
            
    /*3*/<-0.35722,0.23927,-0.90285>,<0.90471,0.32356,0.27714>,<-0.55239,-0.54613,0.62977>,
            
    /*4*/<-0.35177,0.83526,0.4226>

    /* stem 0.30.5*/ 
    /*0*/<0.57141,-0.81635,0.08403>,
    /*1*/<0.75786,0.494,-0.42616>,<-0.11877,0.02644,0.99257>,<-0.64945,-0.50564,-0.56793>,
            
    /*2*/<0.79593,0.42819,-0.42796>,<-0.10076,-0.01044,0.99486>,<-0.71054,-0.40346,-0.5765>,
            
    /*3*/<0.84359,0.32006,-0.43119>,<-0.06543,-0.05366,0.99641>,<-0.78504,-0.24966,-0.5669>,
            
    /*4*/<-0.28065,0.95845,0.05107>

    /* stem 0.30.6*/ 
    /*0*/<0.02222,-0.99968,-0.0118>,
    /*1*/<0.69347,0.01284,0.72037>,<-0.97046,-0.01848,0.24054>,<0.2766,0.02341,-0.9607>,
            
    /*2*/<0.69664,-0.01835,0.71719>,<-0.96925,-0.07711,0.2337>,<0.2711,0.11465,-0.9557>,
            
    /*3*/<0.69297,0.01653,0.72078>,<-0.96129,-0.14724,0.23291>,<0.2699,0.14877,-0.95133>,
            
    /*4*/<-0.15746,0.98652,0.04454>

    /* stem 0.30.7*/ 
    /*0*/<-0.08762,-0.87204,-0.48152>,
    /*1*/<-0.48608,-0.37921,0.78735>,<-0.50894,0.4597,-0.72777>,<0.99656,-0.0652,-0.05114>,
            
    /*2*/<-0.48548,-0.35866,0.79729>,<-0.51275,0.41357,-0.75236>,<0.9985,-0.03862,-0.03885>,
            
    /*3*/<-0.48638,-0.32789,0.80989>,<-0.51244,0.3065,-0.80216>,<0.99924,0.03874,-0.00474>,
            
    /*4*/<-0.08439,0.94196,0.32494>

    /* stem 0.30.8*/ 
    /*0*/<0.39614,-0.61201,-0.68448>,
    /*1*/<-0.9148,-0.17629,-0.36339>,<0.54209,0.76038,-0.35773>,<0.36588,-0.57351,0.73295>,
            
    /*2*/<-0.92388,-0.15703,-0.34898>,<0.58721,0.68679,-0.42837>,<0.33998,-0.51446,0.78724>,
            
    /*3*/<-0.9451,-0.10377,-0.30988>,<0.63066,0.5853,-0.5096>,<0.30845,-0.46795,0.82818>,
            
    /*4*/<-0.23169,0.79463,0.56114>

    /* stem 0.30.9*/ 
    /*0*/<0.72993,-0.66588,-0.15427>,
    /*1*/<0.07193,0.30716,-0.94893>,<0.54612,0.4423,0.71142>,<-0.6304,-0.7382,0.24012>,
            
    /*2*/<0.1481,0.21571,-0.96516>,<0.55455,0.43239,0.711>,<-0.72509,-0.64314,0.2462>,
            
    /*3*/<0.23226,0.11249,-0.96613>,<0.58409,0.40041,0.70605>,<-0.82627,-0.49944,0.26044>,
            
    /*4*/<-0.49125,0.87022,-0.03723>

    /* stem 0.30.10*/ 
    /*0*/<0.32043,-0.90761,0.27124>,
    /*1*/<0.94496,0.32137,-0.06149>,<-0.50231,0.08593,0.86041>,<-0.44799,-0.39215,-0.80344>,
            
    /*2*/<0.94025,0.3345,-0.06355>,<-0.48117,0.02252,0.87634>,<-0.46795,-0.34291,-0.81452>,
            
    /*3*/<0.93587,0.3463,-0.06495>,<-0.44258,-0.08399,0.89279>,<-0.50112,-0.24755,-0.82921>,
            
    /*4*/<-0.34167,0.93954,-0.0231>

    /* stem 0.30.11*/ 
    /*0*/<-0.3063,-0.9519,-0.00802>,
    /*1*/<0.33972,-0.11149,0.93389>,<-0.93802,0.30886,-0.15725>,<0.60328,-0.18188,-0.77651>,
            
    /*2*/<0.34077,-0.09493,0.93534>,<-0.96988,0.17559,-0.16882>,<0.62273,-0.06444,-0.77978>,
            
    /*3*/<0.34083,-0.07249,0.93733>,<-0.98184,-0.04786,-0.18357>,<0.63666,0.13637,-0.75899>,
            
    /*4*/<-0.16965,0.97593,0.13703>

    /* stem 0.30.12*/ 
    /*0*/<-0.08322,-0.80506,-0.58732>,
    /*1*/<-0.81743,-0.27722,0.50493>,<-0.08366,0.59724,-0.79769>,<0.90243,-0.30709,0.30219>,
            
    /*2*/<-0.8168,-0.22864,0.52968>,<-0.09216,0.49464,-0.8642>,<0.90996,-0.24923,0.33145>,
            
    /*3*/<-0.8139,-0.1613,0.55817>,<-0.09529,0.31855,-0.9431>,<0.9115,-0.14154,0.38618>,
            
    /*4*/<-0.00775,0.96933,0.24563>

    /* stem 0.30.13*/ 
    /*0*/<0.43508,-0.79507,-0.42257>,
    /*1*/<-0.70831,-0.00584,-0.70588>,<0.83463,0.53435,-0.13364>,<-0.13317,-0.516,0.84617>,
            
    /*2*/<-0.69231,-0.0466,-0.72009>,<0.86985,0.46808,-0.1558>,<-0.18392,-0.40962,0.89352>,
            
    /*3*/<-0.67883,-0.07008,-0.73094>,<0.90553,0.37745,-0.19375>,<-0.23156,-0.29299,0.92765>,
            
    /*4*/<-0.30751,0.92703,0.21458>

    /* stem 0.30.14*/ 
    /*0*/<0.55334,-0.83102,0.05678>,
    /*1*/<0.49739,0.2813,-0.82065>,<0.32381,0.28348,0.90265>,<-0.82974,-0.55196,-0.08287>,
            
    /*2*/<0.52668,0.21616,-0.82212>,<0.35104,0.22079,0.90996>,<-0.90017,-0.42603,-0.09047>,
            
    /*3*/<0.56297,0.11052,-0.81905>,<0.40116,0.11551,0.9087>,<-0.9732,-0.2116,-0.09007>,
            
    /*4*/<-0.13163,0.99123,-0.01156>

    /* stem 0.30.15*/ 
    /*0*/<0.05176,-0.96874,0.24261>,
    /*1*/<0.93086,0.13892,0.33794>,<-0.77848,0.11738,0.6166>,<-0.15306,-0.24347,-0.95775>,
            
    /*2*/<0.93552,0.0413,0.35085>,<-0.77896,0.1056,0.61811>,<-0.14939,-0.1345,-0.97959>,
            
    /*3*/<0.9302,-0.11086,0.3499>,<-0.78153,0.02627,0.62331>,<-0.15038,0.10163,-0.98339>,
            
    /*4*/<0.10316,0.9732,0.20551>

    /* stem 0.30.16*/ 
    /*0*/<-0.31923,-0.91905,-0.23116>,
    /*1*/<-0.08099,-0.21544,0.97315>,<-0.77666,0.39449,-0.4911>,<0.85871,-0.17601,-0.48129>,
            
    /*2*/<-0.08072,-0.21483,0.97331>,<-0.76814,0.41725,-0.48566>,<0.85007,-0.19929,-0.48751>,
            
    /*3*/<-0.0712,-0.17778,0.98149>,<-0.79828,0.32482,-0.50719>,<0.86354,-0.14263,-0.48369>,
            
    /*4*/<0.14952,0.97749,0.14887>

    /* stem 0.31*/ 
    /*0*/<0.41452,-0.86603,0.2796>,
    /*1*/<0.55573,0.0072,-0.83133>,<0.85215,0.48271,0.20206>,<-0.03383,0.30108,0.953>,
            <-0.87782,-0.28668,0.38372>,<-0.51346,-0.46831,-0.71906>,
    /*2*/<0.55585,0.00729,-0.83125>,<0.87439,0.43412,0.21673>,<-0.02054,0.27099,0.96236>,
            <-0.89091,-0.25635,0.37493>,<-0.53481,-0.41937,-0.73356>,
    /*3*/<0.55657,0.00771,-0.83077>,<0.91144,0.33294,0.24172>,<0.00262,0.20866,0.97799>,
            <-0.91261,-0.19322,0.36029>,<-0.57037,-0.31747,-0.75755>,
    /*4*/<-0.23777,0.95799,-0.16038>

    /* stem 0.31.0*/ 
    /*0*/<0.12109,-0.64641,0.75332>,
    /*1*/<0.82458,0.49122,0.28065>,<-0.89101,0.26898,0.36572>,<0.06415,-0.74807,-0.66051>,
            
    /*2*/<0.83994,0.41984,0.34386>,<-0.8895,0.24586,0.38516>,<0.05549,-0.65717,-0.7517>,
            
    /*3*/<0.85064,0.32098,0.4164>,<-0.8777,0.12685,0.46212>,<0.01473,-0.43621,-0.89972>,
            
    /*4*/<-0.16183,0.93703,-0.30948>

    /* stem 0.31.1*/ 
    /*0*/<-0.13481,-0.97131,0.19591>,
    /*1*/<-0.18702,0.22521,0.95619>,<-0.74777,-0.02366,-0.66353>,<0.93731,-0.18346,-0.29631>,
            
    /*2*/<-0.18394,0.18585,0.96521>,<-0.7467,-0.13205,-0.65192>,<0.94297,-0.03396,-0.33115>,
            
    /*3*/<-0.18506,0.15895,0.96979>,<-0.74195,-0.27399,-0.61192>,<0.92275,0.13215,-0.36203>,
            
    /*4*/<-0.23502,0.94913,-0.20955>

    /* stem 0.31.2*/ 
    /*0*/<0.33583,-0.89557,-0.29184>,
    /*1*/<-0.91192,-0.38307,0.14716>,<0.24191,0.38745,-0.88958>,<0.66383,0.0121,0.74779>,
            
    /*2*/<-0.91413,-0.37685,0.14954>,<0.23664,0.40268,-0.88422>,<0.67192,-0.00934,0.74056>,
            
    /*3*/<-0.90934,-0.38888,0.14792>,<0.23382,0.40501,-0.88391>,<0.66984,0.00017,0.74251>,
            
    /*4*/<-0.36091,0.88695,0.28821>

    /* stem 0.31.3*/ 
    /*0*/<0.78236,-0.61785,0.07864>,
    /*1*/<-0.22624,-0.39025,-0.89248>,<0.61011,0.79003,0.06006>,<-0.39812,-0.38854,0.83099>,
            
    /*2*/<-0.24896,-0.36535,-0.89696>,<0.6902,0.72008,0.0715>,<-0.44786,-0.33755,0.82794>,
            
    /*3*/<-0.26669,-0.34764,-0.8989>,<0.83337,0.54123,0.11207>,<-0.57394,-0.17251,0.80052>,
            
    /*4*/<-0.38562,0.88896,-0.24707>

    /* stem 0.31.4*/ 
    /*0*/<0.58018,-0.42156,0.6969>,
    /*1*/<0.80673,0.21383,-0.55087>,<-0.33653,0.66055,0.67113>,<-0.48064,-0.8668,-0.1328>,
            
    /*2*/<0.77238,0.2532,-0.5825>,<-0.22807,0.56339,0.79408>,<-0.56249,-0.80361,-0.19449>,
            
    /*3*/<0.69846,0.32449,-0.63786>,<-0.01632,0.34786,0.9374>,<-0.69413,-0.66051,-0.2862>,
            
    /*4*/<-0.57612,0.8046,-0.1439>

    /* stem 0.31.5*/ 
    /*0*/<0.10878,-0.83758,0.53538>,
    /*1*/<0.58536,0.49403,0.64287>,<-0.98902,-0.02873,0.14494>,<0.40173,-0.4504,-0.79734>,
            
    /*2*/<0.58992,0.45066,0.67>,<-0.99157,-0.00088,0.12957>,<0.40098,-0.43372,-0.80691>,
            
    /*3*/<0.60155,0.36339,0.7114>,<-0.98986,-0.03406,0.13793>,<0.38859,-0.3147,-0.866>,
            
    /*4*/<-0.14525,0.94687,-0.28694>

    /* stem 0.31.6*/ 
    /*0*/<-0.22994,-0.96281,-0.14185>,
    /*1*/<-0.54446,0.01256,0.83869>,<-0.42352,0.23608,-0.87458>,<0.97203,-0.2317,0.03839>,
            
    /*2*/<-0.53822,0.05726,0.84086>,<-0.44333,0.1446,-0.88462>,<0.98195,-0.18509,0.03901>,
            
    /*3*/<-0.53143,0.11482,0.83928>,<-0.46109,-0.00598,-0.88733>,<0.99478,-0.09199,0.0442>,
            
    /*4*/<0.05623,0.99253,-0.10826>

    /* stem 0.31.7*/ 
    /*0*/<0.47085,-0.82142,-0.32183>,
    /*1*/<-0.8766,-0.37958,-0.29579>,<0.53886,0.56182,-0.62769>,<0.32961,-0.16805,0.92904>,
            
    /*2*/<-0.89124,-0.34893,-0.28971>,<0.58816,0.4725,-0.65636>,<0.30329,-0.10589,0.947>,
            
    /*3*/<-0.88619,-0.36499,-0.28541>,<0.65625,0.33086,-0.67813>,<0.22467,0.05194,0.97305>,
            
    /*4*/<-0.42033,0.90573,-0.05446>

    /* stem 0.31.8*/ 
    /*0*/<0.84338,-0.48889,0.22294>,
    /*1*/<0.14787,-0.17704,-0.97303>,<0.36505,0.83191,0.41792>,<-0.52726,-0.64656,0.55132>,
            
    /*2*/<0.13831,-0.16663,-0.97627>,<0.48073,0.74646,0.4601>,<-0.63086,-0.56465,0.53216>,
            
    /*3*/<0.13271,-0.16159,-0.97789>,<0.66222,0.53336,0.52629>,<-0.80873,-0.3547,0.4692>,
            
    /*4*/<-0.347,0.91364,-0.2118>

    /* stem 0.31.9*/ 
    /*0*/<0.30931,-0.6355,0.70744>,
    /*1*/<0.94085,0.30694,-0.14349>,<-0.58208,0.46669,0.66587>,<-0.36392,-0.76303,-0.53418>,
            
    /*2*/<0.95357,0.27604,-0.12042>,<-0.5619,0.39784,0.72526>,<-0.408,-0.66805,-0.6223>,
            
    /*3*/<0.97454,0.21069,-0.07668>,<-0.52219,0.31982,0.79059>,<-0.4559,-0.51765,-0.72401>,
            
    /*4*/<-0.17805,0.87664,-0.44698>

    /* stem 0.31.10*/ 
    /*0*/<-0.24667,-0.89004,0.38338>,
    /*1*/<0.27276,0.32119,0.90688>,<-0.94002,0.13101,-0.31496>,<0.6713,-0.43759,-0.59822>,
            
    /*2*/<0.26909,0.30157,0.91468>,<-0.94927,0.09136,-0.30089>,<0.68475,-0.37899,-0.62248>,
            
    /*3*/<0.26625,0.23661,0.93441>,<-0.96331,-0.01646,-0.2679>,<0.70378,-0.20468,-0.68029>,
            
    /*4*/<-0.04685,0.98272,-0.17909>

    /* stem 0.31.11*/ 
    /*0*/<-0.09924,-0.92979,-0.35446>,
    /*1*/<-0.83334,-0.11166,0.54137>,<-0.05273,0.36566,-0.92925>,<0.88767,-0.23902,0.3936>,
            
    /*2*/<-0.83395,-0.06841,0.54759>,<-0.05894,0.21486,-0.97486>,<0.90127,-0.13238,0.41253>,
            
    /*3*/<-0.83107,0.00926,0.5561>,<-0.06458,0.0551,-0.99639>,<0.89577,-0.04866,0.44184>,
            
    /*4*/<0.06868,0.99697,0.03647>

    /* stem 0.31.12*/ 
    /*0*/<0.55322,-0.80541,-0.21274>,
    /*1*/<-0.67584,-0.27726,-0.68291>,<0.75877,0.59673,-0.26109>,<-0.09173,-0.30667,0.94739>,
            
    /*2*/<-0.68624,-0.26041,-0.67916>,<0.7789,0.56655,-0.26895>,<-0.10023,-0.29254,0.95099>,
            
    /*3*/<-0.71762,-0.20371,-0.66598>,<0.81486,0.50517,-0.28427>,<-0.10504,-0.28752,0.952>,
            
    /*4*/<-0.41257,0.87973,0.23635>

    /* stem 0.31.13*/ 
    /*0*/<0.57937,-0.72533,0.37178>,
    /*1*/<0.52812,-0.00625,-0.84915>,<0.26684,0.60487,0.75029>,<-0.80398,-0.58733,0.09307>,
            
    /*2*/<0.49915,0.03956,-0.86561>,<0.325,0.52927,0.78374>,<-0.82858,-0.5537,0.08292>,
            
    /*3*/<0.47603,0.06329,-0.87715>,<0.41719,0.36094,0.83407>,<-0.90995,-0.41187,0.04856>,
            
    /*4*/<-0.3059,0.94304,-0.13079>

    /* stem 0.31.14*/ 
    /*0*/<0.05969,-0.81954,0.5699>,
    /*1*/<0.91156,0.28117,0.29999>,<-0.80792,0.30003,0.50719>,<-0.10455,-0.56876,-0.81583>,
            
    /*2*/<0.90342,0.3218,0.28332>,<-0.79405,0.1622,0.58581>,<-0.1299,-0.47658,-0.86948>,
            
    /*3*/<0.90799,0.31433,0.27704>,<-0.76241,0.0436,0.64562>,<-0.14681,-0.34403,-0.92741>,
            
    /*4*/<-0.1748,0.94099,-0.2898>

    /* stem 0.31.15*/ 
    /*0*/<-0.40517,-0.91116,0.07494>,
    /*1*/<-0.11944,0.13789,0.98322>,<-0.72292,0.27317,-0.63464>,<0.84668,-0.40133,-0.34938>,
            
    /*2*/<-0.11681,0.14637,0.98231>,<-0.74564,0.21514,-0.63067>,<0.86568,-0.35195,-0.35598>,
            
    /*3*/<-0.12089,0.11782,0.98565>,<-0.77614,0.1071,-0.6214>,<0.90448,-0.21489,-0.36842>,
            
    /*4*/<0.11616,0.9913,-0.06187>

    /* stem 0.31.16*/ 
    /*0*/<0.13291,-0.88329,-0.44959>,
    /*1*/<-0.96641,-0.21548,0.14009>,<0.29192,0.46935,-0.83336>,<0.67405,-0.25095,0.69475>,
            
    /*2*/<-0.97666,-0.13157,0.16979>,<0.29919,0.36449,-0.88184>,<0.67386,-0.22775,0.70288>,
            
    /*3*/<-0.979,-0.0684,0.19203>,<0.31801,0.21223,-0.92403>,<0.66403,-0.14051,0.73438>,
            
    /*4*/<-0.06261,0.98584,0.15554>

    /* stem 0.32*/ 
    /*0*/<-0.17918,-0.86603,0.46679>,
    /*1*/<0.93501,0.00706,0.35455>,<-0.00521,0.48257,0.87584>,<-0.93621,0.30094,0.18149>,
            <-0.57138,-0.28683,-0.76893>,<0.5851,-0.46845,-0.66197>,
    /*2*/<0.93496,0.00715,0.35468>,<-0.01451,0.43398,0.90081>,<-0.94234,0.27085,0.19654>,
            <-0.56576,-0.25649,-0.78366>,<0.59443,-0.41952,-0.68605>,
    /*3*/<0.93465,0.00756,0.35548>,<-0.03051,0.33279,0.94251>,<-0.95235,0.20851,0.22261>,
            <-0.55637,-0.19337,-0.80812>,<0.60981,-0.31762,-0.72612>,
    /*4*/<0.10278,0.95799,-0.26775>

    /* stem 0.32.0*/ 
    /*0*/<-0.51496,-0.76982,0.37709>,
    /*1*/<-0.08922,0.49191,0.86606>,<-0.68867,0.11825,-0.71537>,<0.7874,-0.59595,-0.15765>,
            
    /*2*/<-0.12401,0.43032,0.89412>,<-0.68877,0.1187,-0.7152>,<0.82547,-0.53469,-0.18086>,
            
    /*3*/<-0.14685,0.38708,0.91028>,<-0.708,0.0893,-0.70055>,<0.86119,-0.46029,-0.21561>,
            
    /*4*/<0.37278,0.86773,-0.32874>

    /* stem 0.32.1*/ 
    /*0*/<-0.22107,-0.97227,-0.07623>,
    /*1*/<-0.97379,0.22507,0.03279>,<0.47616,-0.03314,-0.87874>,<0.50165,-0.17426,0.84733>,
            
    /*2*/<-0.97911,0.20054,0.03347>,<0.46755,-0.08743,-0.87963>,<0.51941,-0.09553,0.84917>,
            
    /*3*/<-0.98444,0.17212,0.03532>,<0.44881,-0.1594,-0.8793>,<0.53899,0.00496,0.8423>,
            
    /*4*/<0.15686,0.97957,-0.12588>

    /* stem 0.32.2*/ 
    /*0*/<0.14921,-0.92141,0.3588>,
    /*1*/<-0.34722,-0.38303,-0.85599>,<0.97434,0.20253,0.0982>,<-0.62981,0.1971,0.75133>,
            
    /*2*/<-0.34605,-0.34273,-0.87337>,<0.98538,0.09287,0.14283>,<-0.63047,0.26623,0.72913>,
            
    /*3*/<-0.34014,-0.29174,-0.89398>,<0.97672,-0.05755,0.20666>,<-0.63299,0.36589,0.68224>,
            
    /*4*/<0.18478,0.91332,-0.36292>

    /* stem 0.32.3*/ 
    /*0*/<0.04612,-0.67879,0.73289>,
    /*1*/<0.81905,-0.39,-0.42079>,<0.08496,0.73765,0.66981>,<-0.90482,-0.33565,-0.26198>,
            
    /*2*/<0.82202,-0.36148,-0.44002>,<0.07966,0.62196,0.77899>,<-0.91183,-0.23922,-0.33367>,
            
    /*3*/<0.81009,-0.39815,-0.43038>,<0.05934,0.44555,0.89329>,<-0.87666,-0.03062,-0.48014>,
            
    /*4*/<0.32309,0.86633,-0.38089>

    /* stem 0.32.4*/ 
    /*0*/<-0.527,-0.46356,0.7123>,
    /*1*/<0.71801,0.21401,0.66231>,<-0.7523,0.64226,-0.14682>,<0.04351,-0.84815,-0.52797>,
            
    /*2*/<0.68895,0.16401,0.70601>,<-0.82165,0.56425,-0.08073>,<0.14346,-0.73082,-0.66733>,
            
    /*3*/<0.62687,0.06752,0.77619>,<-0.89528,0.44462,0.02813>,<0.27915,-0.50142,-0.81893>,
            
    /*4*/<0.36658,0.88432,-0.28915>

    /* stem 0.32.5*/ 
    /*0*/<-0.5363,-0.84156,0.06456>,
    /*1*/<-0.51287,0.39227,0.7636>,<-0.31738,0.13712,-0.93833>,<0.83953,-0.51483,0.17361>,
            
    /*2*/<-0.51468,0.38916,0.76398>,<-0.37581,0.00766,-0.92667>,<0.90957,-0.38957,0.14466>,
            
    /*3*/<-0.50955,0.41038,0.75627>,<-0.46014,-0.18982,-0.86732>,<0.97302,-0.20751,0.10089>,
            
    /*4*/<0.1822,0.90074,-0.39429>

    /* stem 0.32.6*/ 
    /*0*/<0.05053,-0.98614,-0.15806>,
    /*1*/<-0.93945,0.0125,-0.34245>,<0.76347,0.14571,-0.62919>,<0.17513,-0.14145,0.97433>,
            
    /*2*/<-0.93951,0.02725,-0.34145>,<0.76615,0.08965,-0.63638>,<0.17553,-0.10018,0.97936>,
            
    /*3*/<-0.93907,0.03906,-0.3415>,<0.76689,-0.02295,-0.64137>,<0.1758,0.00077,0.98442>,
            
    /*4*/<0.0559,0.9963,-0.06533>

    /* stem 0.32.7*/ 
    /*0*/<0.2831,-0.87416,0.39458>,
    /*1*/<0.09184,-0.37941,-0.92066>,<0.77833,0.45416,0.43352>,<-0.87493,-0.06005,0.4805>,
            
    /*2*/<0.09394,-0.40027,-0.91157>,<0.79698,0.35547,0.48834>,<-0.90054,0.06718,0.42954>,
            
    /*3*/<0.11138,-0.35574,-0.92793>,<0.80675,0.13904,0.57431>,<-0.90705,0.23021,0.3525>,
            
    /*4*/<0.17997,0.94605,-0.26946>

    /* stem 0.32.8*/ 
    /*0*/<-0.02973,-0.4988,0.86621>,
    /*1*/<0.98137,-0.17706,-0.07464>,<-0.32537,0.82691,0.45864>,<-0.6555,-0.6416,-0.39833>,
            
    /*2*/<0.98238,-0.16162,-0.09381>,<-0.33006,0.7765,0.53676>,<-0.65717,-0.60231,-0.45316>,
            
    /*3*/<0.98182,-0.07497,-0.17437>,<-0.3234,0.62792,0.7079>,<-0.6571,-0.53368,-0.53236>,
            
    /*4*/<-0.13172,0.80385,-0.58006>

    /* stem 0.32.9*/ 
    /*0*/<-0.52089,-0.7241,0.45205>,
    /*1*/<0.35085,0.30735,0.88456>,<-0.84619,0.38862,-0.3646>,<0.50385,-0.68415,-0.52733>,
            
    /*2*/<0.37507,0.36749,0.85105>,<-0.91746,0.27152,-0.29077>,<0.53055,-0.62645,-0.57103>,
            
    /*3*/<0.40537,0.4216,0.81113>,<-0.97965,0.09222,-0.17829>,<0.57522,-0.50266,-0.64533>,
            
    /*4*/<0.09347,0.86739,-0.48877>

    /* stem 0.32.10*/ 
    /*0*/<-0.41801,-0.89931,-0.12846>,
    /*1*/<-0.8224,0.32112,0.46962>,<0.08452,0.10814,-0.99054>,<0.74458,-0.41485,0.52297>,
            
    /*2*/<-0.82607,0.31249,0.46899>,<0.06565,0.06057,-0.996>,<0.76964,-0.35942,0.5277>,
            
    /*3*/<-0.83685,0.27434,0.47372>,<0.01944,-0.10438,-0.99435>,<0.84158,-0.15639,0.51699>,
            
    /*4*/<0.14468,0.96372,-0.22429>

    /* stem 0.32.11*/ 
    /*0*/<0.24698,-0.96464,-0.09205>,
    /*1*/<-0.71452,-0.11157,-0.69066>,<0.92339,0.26809,-0.27472>,<-0.21277,-0.14128,0.96683>,
            
    /*2*/<-0.71505,-0.10679,-0.69087>,<0.94088,0.19497,-0.27702>,<-0.22469,-0.07225,0.97175>,
            
    /*3*/<-0.7145,-0.11128,-0.69073>,<0.95804,0.07583,-0.27641>,<-0.24389,0.05144,0.96844>,
            
    /*4*/<-0.05972,0.99107,-0.1192>

    /* stem 0.32.12*/ 
    /*0*/<0.43866,-0.72484,0.53121>,
    /*1*/<0.51289,-0.27782,-0.81226>,<0.37787,0.689,0.61846>,<-0.8975,-0.40005,0.18564>,
            
    /*2*/<0.5112,-0.26919,-0.81621>,<0.42715,0.56537,0.70562>,<-0.9527,-0.27741,0.12408>,
            
    /*3*/<0.51226,-0.28557,-0.80996>,<0.47675,0.35982,0.80202>,<-0.9983,-0.05795,0.00625>,
            
    /*4*/<0.04483,0.93806,-0.34357>

    /* stem 0.32.13*/ 
    /*0*/<-0.25045,-0.66504,0.70356>,
    /*1*/<0.94625,-0.00665,0.32338>,<-0.65342,0.65505,0.3794>,<-0.28903,-0.63832,-0.71345>,
            
    /*2*/<0.95055,0.01623,0.31016>,<-0.69871,0.52726,0.48353>,<-0.27402,-0.53087,-0.80193>,
            
    /*3*/<0.94894,-0.02718,0.31429>,<-0.72942,0.33411,0.59692>,<-0.21915,-0.29424,-0.93027>,
            
    /*4*/<0.17602,0.96191,-0.20916>

    /* stem 0.32.14*/ 
    /*0*/<-0.46302,-0.86206,0.20609>,
    /*1*/<-0.08792,0.28087,0.95571>,<-0.71657,0.23286,-0.6575>,<0.81068,-0.5022,-0.30097>,
            
    /*2*/<-0.09115,0.27371,0.95748>,<-0.73789,0.18745,-0.64836>,<0.83559,-0.45031,-0.31467>,
            
    /*3*/<-0.11065,0.19599,0.97434>,<-0.76801,0.10722,-0.6314>,<0.89215,-0.29132,-0.34527>,
            
    /*4*/<0.16347,0.98163,-0.0984>

    /* stem 0.32.15*/ 
    /*0*/<-0.16024,-0.93901,-0.30427>,
    /*1*/<-0.98532,0.13557,0.10376>,<0.44424,0.20764,-0.87151>,<0.54155,-0.34044,0.76865>,
            
    /*2*/<-0.96473,0.23172,0.12488>,<0.41774,0.1124,-0.90158>,<0.54239,-0.33805,0.76911>,
            
    /*3*/<-0.91795,0.36871,0.14639>,<0.38381,-0.02856,-0.92297>,<0.53398,-0.33671,0.77556>,
            
    /*4*/<0.42697,0.89854,0.10162>

    /* stem 0.33*/ 
    /*0*/<-0.49513,-0.86603,-0.06959>,
    /*1*/<-0.13525,0.00685,0.99079>,<-0.85469,0.48237,0.19193>,<-0.38756,0.30074,-0.87141>,
            <0.62057,-0.28703,-0.72973>,<0.77651,-0.46866,0.42118>,
    /*2*/<-0.13538,0.00694,0.99077>,<-0.88109,0.43377,0.18849>,<-0.4036,0.27064,-0.87399>,
            <0.6362,-0.2567,-0.72757>,<0.80208,-0.41973,0.42486>,
    /*3*/<-0.13621,0.00734,0.99065>,<-0.9253,0.33257,0.18227>,<-0.43122,0.20829,-0.87787>,
            <0.66217,-0.19359,-0.72392>,<0.84461,-0.31784,0.43084>,
    /*4*/<0.28401,0.95799,0.03992>

    /* stem 0.33.0*/ 
    /*0*/<-0.46842,-0.72408,-0.50625>,
    /*1*/<-0.86412,0.49148,0.10833>,<0.58379,0.18352,-0.79089>,<0.2887,-0.66208,0.6916>,
            
    /*2*/<-0.91612,0.39701,0.05574>,<0.58671,0.1926,-0.78656>,<0.32675,-0.57754,0.74812>,
            
    /*3*/<-0.95942,0.28197,-0.00072>,<0.57131,0.15532,-0.8059>,<0.39634,-0.42294,0.81489>,
            
    /*4*/<0.24812,0.92781,0.27859>

    /* stem 0.33.1*/ 
    /*0*/<-0.04567,-0.97562,-0.21465>,
    /*1*/<-0.25058,0.22494,-0.9416>,<0.96308,-0.0945,0.25208>,<-0.71169,-0.11317,0.69332>,
            
    /*2*/<-0.25741,0.18044,-0.94931>,<0.9589,-0.13968,0.24698>,<-0.70404,-0.02251,0.7098>,
            
    /*3*/<-0.24879,0.21364,-0.9447>,<0.94629,-0.23404,0.22308>,<-0.69347,0.03878,0.71944>,
            
    /*4*/<0.23982,0.94358,0.22836>

    /* stem 0.33.2*/ 
    /*0*/<-0.25116,-0.91554,0.31418>,
    /*1*/<0.75551,-0.38324,-0.53135>,<0.15001,0.2896,0.94532>,<-0.90113,0.10961,-0.41945>,
            
    /*2*/<0.7615,-0.36445,-0.53601>,<0.13447,0.23641,0.9623>,<-0.89189,0.14472,-0.42846>,
            
    /*3*/<0.77027,-0.33895,-0.54019>,<0.10318,0.14189,0.98449>,<-0.86916,0.21383,-0.4459>,
            
    /*4*/<0.32776,0.93728,-0.11865>

    /* stem 0.33.3*/ 
    /*0*/<-0.71208,-0.6653,0.22433>,
    /*1*/<0.59419,-0.39018,0.70335>,<-0.6204,0.75,0.22936>,<0.03848,-0.34835,-0.93657>,
            
    /*2*/<0.61711,-0.36315,0.69806>,<-0.68344,0.68673,0.24762>,<0.07235,-0.30779,-0.9487>,
            
    /*3*/<0.65506,-0.30947,0.68929>,<-0.78742,0.55278,0.27277>,<0.13697,-0.22706,-0.9642>,
            
    /*4*/<0.4733,0.87602,-0.09258>

    /* stem 0.33.4*/ 
    /*0*/<-0.78864,-0.52203,-0.32484>,
    /*1*/<-0.4841,0.21426,0.84838>,<-0.07452,0.61292,-0.78662>,<0.57201,-0.81831,-0.05624>,
            
    /*2*/<-0.50956,0.19063,0.83905>,<-0.13479,0.55915,-0.81804>,<0.66671,-0.74504,-0.02057>,
            
    /*3*/<-0.55823,0.13962,0.81785>,<-0.21906,0.48325,-0.84763>,<0.79003,-0.61206,0.03502>,
            
    /*4*/<0.53032,0.80108,0.27755>

    /* stem 0.33.5*/ 
    /*0*/<-0.16904,-0.82975,-0.53193>,
    /*1*/<-0.85951,0.39206,-0.3279>,<0.84741,0.15888,-0.50661>,<0.01494,-0.53701,0.84344>,
            
    /*2*/<-0.86636,0.35699,-0.34924>,<0.84854,0.16721,-0.50201>,<0.01881,-0.50996,0.86>,
            
    /*3*/<-0.87537,0.30677,-0.37365>,<0.83693,0.04743,-0.54525>,<0.05827,-0.34432,0.93704>,
            
    /*4*/<0.23262,0.95535,0.18218>

    /* stem 0.33.6*/ 
    /*0*/<0.23399,-0.97198,0.0223>,
    /*1*/<0.122,0.01224,-0.99245>,<0.77225,0.20534,0.60122>,<-0.8981,-0.2016,0.39087>,
            
    /*2*/<0.11979,0.03248,-0.99227>,<0.7869,0.13003,0.60323>,<-0.90759,-0.14663,0.39343>,
            
    /*3*/<0.12041,0.03722,-0.99203>,<0.79305,0.08602,0.60305>,<-0.91469,-0.10689,0.38976>,
            
    /*4*/<-0.13948,0.99022,-0.0013>

    /* stem 0.33.7*/ 
    /*0*/<-0.293,-0.83719,0.4618>,
    /*1*/<0.91751,-0.37977,-0.11807>,<-0.21889,0.53367,0.81687>,<-0.69387,-0.1403,-0.7063>,
            
    /*2*/<0.93075,-0.3395,-0.13579>,<-0.23688,0.47613,0.84687>,<-0.68905,-0.12157,-0.71444>,
            
    /*3*/<0.94417,-0.29175,-0.15308>,<-0.27469,0.36136,0.89105>,<-0.66862,-0.05368,-0.74167>,
            
    /*4*/<0.25214,0.94026,-0.22875>

    /* stem 0.33.8*/ 
    /*0*/<-0.83109,-0.53468,0.153>,
    /*1*/<0.2932,-0.17698,0.93953>,<-0.55159,0.80781,-0.20783>,<0.2716,-0.62233,-0.73413>,
            
    /*2*/<0.36943,-0.10164,0.92368>,<-0.68291,0.70998,-0.17191>,<0.3074,-0.58624,-0.74956>,
            
    /*3*/<0.44745,-0.03549,0.89361>,<-0.86304,0.49105,-0.11847>,<0.41688,-0.4423,-0.7941>,
            
    /*4*/<0.3868,0.91033,-0.14729>

    /* stem 0.33.9*/ 
    /*0*/<-0.57058,-0.69142,-0.44315>,
    /*1*/<-0.78302,0.30702,0.54094>,<0.18989,0.41971,-0.88757>,<0.60206,-0.71591,0.35356>,
            
    /*2*/<-0.81156,0.26227,0.5221>,<0.15977,0.3668,-0.91648>,<0.66961,-0.62227,0.40546>,
            
    /*3*/<-0.82519,0.25047,0.5063>,<0.07431,0.21996,-0.97268>,<0.76009,-0.45795,0.46102>,
            
    /*4*/<0.3892,0.9134,0.11931>

    /* stem 0.33.10*/ 
    /*0*/<0.19377,-0.86266,-0.46719>,
    /*1*/<-0.67486,0.23343,-0.70005>,<0.9534,0.28038,-0.11142>,<-0.2815,-0.50066,0.81859>,
            
    /*2*/<-0.67319,0.2188,-0.70636>,<0.96755,0.20968,-0.141>,<-0.2935,-0.41662,0.8604>,
            
    /*3*/<-0.67191,0.20862,-0.71065>,<0.97392,0.14473,-0.17473>,<-0.30315,-0.33922,0.89053>,
            
    /*4*/<-0.07654,0.93479,0.34685>

    /* stem 0.33.11*/ 
    /*0*/<0.15843,-0.96084,0.22737>,
    /*1*/<0.5122,-0.11186,-0.85155>,<0.47332,0.2808,0.83493>,<-0.98789,-0.15458,0.01322>,
            
    /*2*/<0.51557,-0.14586,-0.84434>,<0.47545,0.25864,0.84086>,<-0.99514,-0.0985,-0.00065>,
            
    /*3*/<0.51653,-0.16995,-0.83923>,<0.48291,0.2028,0.85186>,<-0.99972,-0.01817,-0.01499>,
            
    /*4*/<0.00371,0.98175,-0.19014>

    /* stem 0.33.12*/ 
    /*0*/<-0.39258,-0.84254,0.3688>,
    /*1*/<0.9066,-0.2774,0.31802>,<-0.59386,0.54257,0.5941>,<-0.30696,-0.25278,-0.91754>,
            
    /*2*/<0.93057,-0.20433,0.3038>,<-0.65128,0.39641,0.64707>,<-0.29009,-0.17711,-0.94047>,
            
    /*3*/<0.9607,-0.04841,0.27334>,<-0.70157,0.19221,0.68619>,<-0.25339,-0.12895,-0.95873>,
            
    /*4*/<0.0185,0.98529,-0.16987>

    /* stem 0.33.13*/ 
    /*0*/<-0.72536,-0.6832,-0.08419>,
    /*1*/<-0.1025,-0.00674,0.99471>,<-0.53256,0.64061,-0.55317>,<0.64549,-0.62405,-0.44033>,
            
    /*2*/<-0.10671,-0.01114,0.99423>,<-0.56529,0.607,-0.55856>,<0.68261,-0.58582,-0.43688>,
            
    /*3*/<-0.09797,0.00545,0.99517>,<-0.64733,0.5076,-0.5686>,<0.75131,-0.50035,-0.43034>,
            
    /*4*/<0.51574,0.85635,0.02588>

    /* stem 0.33.14*/ 
    /*0*/<-0.29008,-0.69379,-0.65917>,
    /*1*/<-0.95177,0.27845,0.12886>,<0.5583,0.4386,-0.70422>,<0.39524,-0.7128,0.5794>,
            
    /*2*/<-0.94649,0.29226,0.13691>,<0.52452,0.33946,-0.7808>,<0.43712,-0.63038,0.64151>,
            
    /*3*/<-0.95162,0.27655,0.13393>,<0.48377,0.26396,-0.83444>,<0.46899,-0.53501,0.70272>,
            
    /*4*/<0.27305,0.84705,0.45601>

    /* stem 0.34*/ 
    /*0*/<-0.04358,-0.86603,-0.4981>,
    /*1*/<-0.99583,0.0067,0.09101>,<-0.37928,0.48221,-0.7897>,<0.76189,0.30058,-0.57374>,
            <0.85062,-0.28718,0.44043>,<-0.23571,-0.46881,0.85127>,
    /*2*/<-0.99584,0.00678,0.09088>,<-0.38186,0.43361,-0.81619>,<0.76079,0.27049,-0.58994>,
            <0.85203,-0.25686,0.45614>,<-0.23355,-0.41988,0.87701>,
    /*3*/<-0.99591,0.00717,0.09007>,<-0.38575,0.33241,-0.86064>,<0.75836,0.20812,-0.61771>,
            <0.85432,-0.19375,0.48228>,<-0.22981,-0.318,0.91982>,
    /*4*/<0.025,0.95799,0.28571>

    /* stem 0.34.0*/ 
    /*0*/<0.42444,-0.70279,-0.57091>,
    /*1*/<-0.3001,0.49126,-0.81768>,<0.88691,0.20943,0.41174>,<-0.59421,-0.68844,0.4159>,
            
    /*2*/<-0.29136,0.46976,-0.83333>,<0.91295,0.15609,0.37704>,<-0.63005,-0.61669,0.47195>,
            
    /*3*/<-0.28394,0.44978,-0.8468>,<0.94052,0.0958,0.32597>,<-0.66091,-0.53149,0.52982>,
            
    /*4*/<-0.2411,0.82278,0.51468>

    /* stem 0.34.1*/ 
    /*0*/<0.27608,-0.9592,0.06092>,
    /*1*/<0.86068,0.2247,-0.45687>,<-0.06506,0.05057,0.9966>,<-0.80039,-0.25872,-0.54078>,
            
    /*2*/<0.864,0.21005,-0.45758>,<-0.05017,-0.02668,0.99838>,<-0.82523,-0.16771,-0.53932>,
            
    /*3*/<0.86652,0.19899,-0.45776>,<-0.02468,-0.12338,0.99205>,<-0.84473,-0.05895,-0.53194>,
            
    /*4*/<-0.14585,0.97857,0.14534>

    /* stem 0.34.2*/ 
    /*0*/<-0.40999,-0.90487,-0.11455>,
    /*1*/<0.68791,-0.38341,0.61626>,<-0.86141,0.35001,0.36806>,<0.18051,0.04888,-0.98236>,
            
    /*2*/<0.67056,-0.43566,0.60046>,<-0.89734,0.27671,0.34383>,<0.2352,0.18225,-0.95471>,
            
    /*3*/<0.65069,-0.47356,0.59359>,<-0.94388,0.1364,0.30082>,<0.29415,0.35275,-0.88828>,
            
    /*4*/<0.19487,0.86676,0.45907>

    /* stem 0.34.3*/ 
    /*0*/<-0.48628,-0.56203,-0.66907>,
    /*1*/<-0.5511,-0.39084,0.73724>,<-0.30566,0.82996,-0.46663>,<0.86495,-0.42965,-0.25934>,
            
    /*2*/<-0.51339,-0.33784,0.78885>,<-0.35204,0.77796,-0.52044>,<0.86733,-0.42625,-0.25701>,
            
    /*3*/<-0.48027,-0.30311,0.82308>,<-0.40157,0.7056,-0.58384>,<0.89094,-0.39125,-0.23052>,
            
    /*4*/<0.41641,0.72654,0.54657>

    /* stem 0.34.4*/ 
    /*0*/<0.17579,-0.42354,-0.88866>,
    /*1*/<-0.93571,0.21365,-0.2807>,<0.73378,0.65955,-0.16298>,<0.19902,-0.86617,0.45841>,
            
    /*2*/<-0.94066,0.25897,-0.21929>,<0.75329,0.58352,-0.30341>,<0.2009,-0.82652,0.52584>,
            
    /*3*/<-0.94956,0.26486,-0.16786>,<0.74935,0.42796,-0.5053>,<0.21206,-0.68776,0.69427>,
            
    /*4*/<0.07775,0.80579,0.58708>

    /* stem 0.34.5*/ 
    /*0*/<0.49172,-0.82435,-0.28046>,
    /*1*/<0.12617,0.39189,-0.91132>,<0.6787,0.16819,0.7149>,<-0.81287,-0.54666,0.20099>,
            
    /*2*/<0.12648,0.39262,-0.91096>,<0.72561,0.06452,0.68508>,<-0.85995,-0.44855,0.24349>,
            
    /*3*/<0.12107,0.4068,-0.90546>,<0.77189,-0.04698,0.63402>,<-0.89661,-0.34535,0.27718>,
            
    /*4*/<-0.23354,0.89436,0.38154>

    /* stem 0.34.6*/ 
    /*0*/<0.02824,-0.97797,0.20683>,
    /*1*/<0.99448,0.01211,-0.1042>,<-0.41138,0.18242,0.89302>,<-0.58355,-0.17894,-0.79212>,
            
    /*2*/<0.99175,0.06536,-0.11027>,<-0.40632,0.10612,0.90755>,<-0.5864,-0.15573,-0.79491>,
            
    /*3*/<0.98809,0.10472,-0.11279>,<-0.40238,-0.01456,0.91536>,<-0.58991,-0.07449,-0.80402>,
            
    /*4*/<-0.0821,0.99608,0.03296>

    /* stem 0.34.7*/ 
    /*0*/<-0.36059,-0.89454,-0.26416>,
    /*1*/<0.32052,-0.37966,0.86783>,<-0.9166,0.39448,-0.06499>,<0.6017,-0.00088,-0.79872>,
            
    /*2*/<0.33482,-0.32614,0.88404>,<-0.94665,0.31022,-0.08724>,<0.60984,0.03073,-0.79193>,
            
    /*3*/<0.35823,-0.21714,0.90803>,<-0.96749,0.2244,-0.11667>,<0.61528,0.00698,-0.78828>,
            
    /*4*/<0.20741,0.97364,0.09493>

    /* stem 0.34.8*/ 
    /*0*/<-0.34391,-0.5183,-0.783>,
    /*1*/<-0.84953,-0.17718,0.4969>,<0.0842,0.8166,-0.57104>,<0.77057,-0.63152,0.08606>,
            
    /*2*/<-0.85734,-0.20158,0.47364>,<0.0606,0.73659,-0.67361>,<0.82505,-0.52496,0.20908>,
            
    /*3*/<-0.87054,-0.23341,0.43322>,<0.01975,0.60517,-0.79585>,<0.85587,-0.35993,0.3714>,
            
    /*4*/<0.03215,0.82847,0.55911>

    /* stem 0.34.9*/ 
    /*0*/<0.37587,-0.69127,-0.61714>,
    /*1*/<-0.70616,0.22314,-0.67197>,<0.87182,0.48974,-0.00953>,<-0.17126,-0.70256,0.69071>,
            
    /*2*/<-0.71273,0.23867,-0.65959>,<0.89102,0.45201,-0.04206>,<-0.1812,-0.67951,0.71094>,
            
    /*3*/<-0.7169,0.24424,-0.653>,<0.9364,0.32707,-0.12722>,<-0.21572,-0.56269,0.79802>,
            
    /*4*/<-0.1315,0.88385,0.4489>

    /* stem 0.34.10*/ 
    /*0*/<0.50137,-0.86096,0.08586>,
    /*1*/<0.53039,0.23324,-0.81503>,<0.3215,0.283,0.90363>,<-0.85922,-0.50366,-0.08985>,
            
    /*2*/<0.50661,0.27483,-0.8172>,<0.34293,0.24896,0.90577>,<-0.85537,-0.51021,-0.0896>,
            
    /*3*/<0.52534,0.23698,-0.81723>,<0.35796,0.21507,0.90863>,<-0.89218,-0.44068,-0.09908>,
            
    /*4*/<-0.36005,0.92976,-0.07695>

    /* stem 0.34.11*/ 
    /*0*/<-0.19735,-0.94924,0.24493>,
    /*1*/<0.94496,-0.11212,0.30737>,<-0.69997,0.31584,0.64054>,<-0.24217,-0.19012,-0.95143>,
            
    /*2*/<0.92806,-0.18436,0.3236>,<-0.69294,0.33864,0.63652>,<-0.22734,-0.14262,-0.96332>,
            
    /*3*/<0.90618,-0.26185,0.33209>,<-0.69443,0.32507,0.64195>,<-0.20855,-0.04945,-0.97676>,
            
    /*4*/<0.3122,0.94708,-0.07467>

    /* stem 0.34.12*/ 
    /*0*/<-0.57008,-0.76815,-0.29147>,
    /*1*/<-0.10545,-0.27793,0.95479>,<-0.64859,0.64237,-0.40828>,<0.76205,-0.35364,-0.54242>,
            
    /*2*/<-0.10096,-0.26917,0.95779>,<-0.68989,0.57975,-0.43353>,<0.7972,-0.29738,-0.5254>,
            
    /*3*/<-0.09578,-0.25551,0.96205>,<-0.75191,0.4575,-0.47469>,<0.85268,-0.18853,-0.48723>,
            
    /*4*/<0.2937,0.91626,0.27242>

    /* stem 0.34.13*/ 
    /*0*/<-0.08165,-0.67901,-0.72957>,
    /*1*/<-0.99249,-0.00851,0.12202>,<0.41939,0.64222,-0.64161>,<0.57365,-0.6292,0.52443>,
            
    /*2*/<-0.99283,-0.01224,0.11889>,<0.41737,0.57759,-0.70156>,<0.58417,-0.56068,0.58685>,
            
    /*3*/<-0.99394,-0.03234,0.10508>,<0.40732,0.48542,-0.7736>,<0.58824,-0.44812,0.67317>,
            
    /*4*/<0.00313,0.86445,0.50271>

    /* stem 0.35*/ 
    /*0*/<0.47553,-0.86603,-0.15451>,
    /*1*/<-0.31261,0.00655,-0.94986>,<0.68422,0.48207,-0.54723>,<0.7305,0.30044,0.61327>,
            <-0.23772,-0.28733,0.92786>,<-0.88239,-0.46896,-0.0382>,
    /*2*/<-0.31249,0.00664,-0.9499>,<0.70944,0.43347,-0.5557>,<0.74604,0.27034,0.60856>,
            <-0.25271,-0.257,0.93278>,<-0.907,-0.42003,-0.0303>,
    /*3*/<-0.31173,0.00702,-0.95015>,<0.75186,0.33225,-0.56948>,<0.77254,0.20797,0.59995>,
            <-0.27769,-0.19391,0.9409>,<-0.94788,-0.31816,-0.01702>,
    /*4*/<-0.27277,0.95799,0.08863>

    /* stem 0.35.0*/ 
    /*0*/<0.62217,-0.76229,0.17839>,
    /*1*/<0.72946,0.49152,-0.47571>,<-0.13193,0.12976,0.98273>,<-0.60815,-0.60826,-0.51007>,
            
    /*2*/<0.78382,0.41745,-0.45974>,<-0.14579,0.15337,0.97735>,<-0.64292,-0.55663,-0.52614>,
            
    /*3*/<0.86857,0.24623,-0.43006>,<-0.1487,0.15298,0.97698>,<-0.73024,-0.3858,-0.56383>,
            
    /*4*/<-0.22444,0.96283,-0.15025>

    /* stem 0.35.1*/ 
    /*0*/<0.03456,-0.96577,0.2571>,
    /*1*/<0.6386,0.22463,0.73603>,<-0.9852,0.01601,0.17064>,<0.34602,-0.22431,-0.91102>,
            
    /*2*/<0.64019,0.16611,0.75004>,<-0.98524,0.03959,0.16656>,<0.34713,-0.18918,-0.91854>,
            
    /*3*/<0.63907,0.15909,0.75252>,<-0.98219,-0.03963,0.18368>,<0.33429,-0.10487,-0.93662>,
            
    /*4*/<-0.1731,0.97718,-0.12314>

    /* stem 0.35.2*/ 
    /*0*/<0.18572,-0.92142,-0.34133>,
    /*1*/<-0.44664,-0.38344,0.80838>,<-0.53664,0.20142,-0.81942>,<0.98018,0.1974,0.01674>,
            
    /*2*/<-0.44556,-0.38741,0.80708>,<-0.50186,0.09817,-0.85936>,<0.94953,0.31023,0.0463>,
            
    /*3*/<-0.46902,-0.33554,0.81697>,<-0.46641,-0.0053,-0.88455>,<0.9316,0.35587,0.07398>,
            
    /*4*/<-0.29685,0.9434,0.14792>

    /* stem 0.35.3*/ 
    /*0*/<0.53959,-0.68807,-0.48518>,
    /*1*/<-0.84223,-0.39023,-0.37198>,<0.47437,0.72848,-0.49425>,<0.35899,-0.32694,0.87421>,
            
    /*2*/<-0.84511,-0.38574,-0.37013>,<0.51788,0.67351,-0.52743>,<0.32344,-0.27335,0.90591>,
            
    /*3*/<-0.86134,-0.35586,-0.36257>,<0.59886,0.548,-0.584>,<0.25918,-0.17642,0.94958>,
            
    /*4*/<-0.4298,0.87335,0.2292>

    /* stem 0.35.4*/ 
    /*0*/<0.77182,-0.63043,-0.08278>,
    /*1*/<0.06385,0.21471,-0.97459>,<0.50931,0.5446,0.66634>,<-0.58567,-0.7491,0.30959>,
            
    /*2*/<0.04526,0.23442,-0.97108>,<0.5725,0.48812,0.65877>,<-0.62675,-0.71085,0.31917>,
            
    /*3*/<0.02698,0.2491,-0.9681>,<0.7193,0.297,0.62802>,<-0.75704,-0.53941,0.36868>,
            
    /*4*/<-0.34239,0.91447,0.21569>

    /* stem 0.35.5*/ 
    /*0*/<0.37087,-0.77324,0.51436>,
    /*1*/<0.91646,0.39152,-0.08254>,<-0.58031,0.24514,0.77662>,<-0.34205,-0.62435,-0.70228>,
            
    /*2*/<0.9108,0.4035,-0.08739>,<-0.54544,0.16436,0.82188>,<-0.379,-0.55797,-0.73826>,
            
    /*3*/<0.91343,0.39643,-0.09216>,<-0.45919,-0.0332,0.88772>,<-0.47945,-0.35554,-0.80232>,
            
    /*4*/<-0.37447,0.92719,-0.00971>

    /* stem 0.35.6*/ 
    /*0*/<-0.22283,-0.97128,0.08347>,
    /*1*/<0.32537,0.012,0.94551>,<-0.95712,0.20761,-0.20204>,<0.63525,-0.20435,-0.74478>,
            
    /*2*/<0.32027,-0.01411,0.94722>,<-0.95934,0.19755,-0.20159>,<0.64335,-0.16829,-0.74685>,
            
    /*3*/<0.31745,-0.07948,0.94494>,<-0.974,0.07724,-0.21296>,<0.66166,0.02313,-0.74945>,
            
    /*4*/<-0.0761,0.98476,0.1564>

    /* stem 0.35.7*/ 
    /*0*/<0.13743,-0.87835,-0.45783>,
    /*1*/<-0.77327,-0.3798,0.50774>,<-0.15124,0.44283,-0.88376>,<0.92239,-0.0495,0.38307>,
            
    /*2*/<-0.76922,-0.39743,0.50035>,<-0.13747,0.38917,-0.91085>,<0.90881,0.02385,0.41653>,
            
    /*3*/<-0.79503,-0.32734,0.51067>,<-0.09668,0.2063,-0.9737>,<0.88115,0.1333,0.45365>,
            
    /*4*/<-0.23062,0.96912,0.08734>

    /* stem 0.35.8*/ 
    /*0*/<0.64926,-0.60994,-0.45435>,
    /*1*/<-0.67505,-0.17675,-0.71629>,<0.64145,0.76134,-0.09439>,<0.02382,-0.5754,0.81753>,
            
    /*2*/<-0.66629,-0.18664,-0.72196>,<0.6856,0.71807,-0.11971>,<-0.02626,-0.52149,0.85285>,
            
    /*3*/<-0.65921,-0.19088,-0.72733>,<0.75189,0.63932,-0.16104>,<-0.09993,-0.43663,0.89407>,
            
    /*4*/<-0.54391,0.7887,0.28654>

    /* stem 0.35.9*/ 
    /*0*/<0.65712,-0.72648,0.20105>,
    /*1*/<0.49611,0.22323,-0.83907>,<0.23619,0.45756,0.85724>,<-0.74188,-0.6702,-0.0211>,
            
    /*2*/<0.49801,0.22106,-0.83852>,<0.28,0.40117,0.87216>,<-0.78994,-0.61236,-0.03161>,
            
    /*3*/<0.46539,0.27641,-0.84084>,<0.37113,0.27935,0.88556>,<-0.83982,-0.54111,-0.04348>,
            
    /*4*/<-0.53625,0.84233,0.054>

    /* stem 0.35.10*/ 
    /*0*/<0.07158,-0.90393,0.42166>,
    /*1*/<0.91326,0.23337,0.33392>,<-0.80376,0.20259,0.5594>,<-0.11053,-0.423,-0.89936>,
            
    /*2*/<0.91292,0.23704,0.33226>,<-0.80319,0.19537,0.56278>,<-0.11087,-0.41942,-0.901>,
            
    /*3*/<0.91015,0.25171,0.32903>,<-0.79543,0.0971,0.59821>,<-0.12463,-0.33758,-0.93301>,
            
    /*4*/<-0.18607,0.95408,-0.23474>

    /* stem 0.35.11*/ 
    /*0*/<-0.35985,-0.92232,-0.14087>,
    /*1*/<-0.08659,-0.11233,0.98989>,<-0.75855,0.3817,-0.52811>,<0.8502,-0.2564,-0.4598>,
            
    /*2*/<-0.0979,-0.16705,0.98108>,<-0.77573,0.3171,-0.54562>,<0.88831,-0.13527,-0.43887>,
            
    /*3*/<-0.11074,-0.25069,0.96171>,<-0.80025,0.19384,-0.56747>,<0.91606,0.07198,-0.39453>,
            
    /*4*/<-0.04477,0.95874,0.28074>

    /* stem 0.35.12*/ 
    /*0*/<0.15431,-0.76492,-0.62537>,
    /*1*/<-0.95387,-0.2788,0.11136>,<0.25135,0.64522,-0.72147>,<0.70087,-0.35822,0.61681>,
            
    /*2*/<-0.96061,-0.245,0.13116>,<0.26818,0.56193,-0.7825>,<0.69529,-0.30515,0.65073>,
            
    /*3*/<-0.95808,-0.25504,0.13053>,<0.28553,0.46767,-0.83652>,<0.6705,-0.20444,0.71318>,
            
    /*4*/<-0.23637,0.88489,0.40137>

    /* stem 0.35.13*/ 
    /*0*/<0.70862,-0.65993,-0.24971>,
    /*1*/<-0.34117,-0.0095,-0.93995>,<0.70491,0.65613,0.26945>,<-0.36538,-0.64509,0.67108>,
            
    /*2*/<-0.29837,-0.06978,-0.9519>,<0.76027,0.59346,0.26421>,<-0.47621,-0.52711,0.70383>,
            
    /*3*/<-0.25676,-0.11034,-0.96015>,<0.81635,0.52432,0.24222>,<-0.56104,-0.41221,0.71785>,
            
    /*4*/<-0.54961,0.83242,0.07071>

    /* stem 0.36*/ 
    /*0*/<0.25752,-0.86603,0.42858>,
    /*1*/<0.85524,0.00641,-0.5182>,<0.68716,0.48192,0.54365>,<-0.43318,0.30029,0.84981>,
            <-0.95752,-0.28748,-0.02283>,<-0.16123,-0.46911,-0.8683>,
    /*2*/<0.8553,0.00649,-0.51809>,<0.70108,0.43332,0.56632>,<-0.4251,0.27019,0.86388>,
            <-0.96569,-0.25715,-0.03634>,<-0.17446,-0.42018,-0.89051>,
    /*3*/<0.8557,0.00686,-0.51742>,<0.72405,0.33209,0.60454>,<-0.41076,0.20781,0.88775>,
            <-0.97922,-0.19407,-0.05886>,<-0.19661,-0.31832,-0.92737>,
    /*4*/<-0.14771,0.95799,-0.24584>

    /* stem 0.36.0*/ 
    /*0*/<-0.20559,-0.64877,0.73268>,
    /*1*/<0.62856,0.49079,0.60335>,<-0.96298,0.26629,-0.04202>,<0.33785,-0.74624,-0.57357>,
            
    /*2*/<0.6131,0.39401,0.68473>,<-0.96919,0.24485,-0.02682>,<0.3783,-0.63295,-0.67547>,
            
    /*3*/<0.58538,0.30295,0.75203>,<-0.98914,0.14003,0.04463>,<0.39891,-0.43111,-0.80933>,
            
    /*4*/<0.0078,0.92286,-0.38505>

    /* stem 0.36.1*/ 
    /*0*/<-0.26086,-0.96227,0.07732>,
    /*1*/<-0.57344,0.22447,0.78789>,<-0.38275,0.0353,-0.92318>,<0.9605,-0.2439,0.13401>,
            
    /*2*/<-0.5714,0.23981,0.78485>,<-0.40138,-0.05632,-0.91418>,<0.97813,-0.16982,0.12009>,
            
    /*3*/<-0.57363,0.15387,0.80453>,<-0.4189,-0.1328,-0.89827>,<0.99494,-0.00431,0.10035>,
            
    /*4*/<-0.06959,0.99202,-0.1051>

    /* stem 0.36.2*/ 
    /*0*/<0.42372,-0.90007,-0.10169>,
    /*1*/<-0.88835,-0.38369,-0.25222>,<0.60354,0.36995,-0.70631>,<0.27792,0.02837,0.96018>,
            
    /*2*/<-0.88947,-0.38118,-0.2521>,<0.61175,0.35271,-0.70807>,<0.27122,0.04329,0.96154>,
            
    /*3*/<-0.90142,-0.35098,-0.25349>,<0.6581,0.24647,-0.71145>,<0.24412,0.12091,0.96218>,
            
    /*4*/<-0.31147,0.94471,-0.10255>

    /* stem 0.36.3*/ 
    /*0*/<0.68498,-0.60904,0.39985>,
    /*1*/<0.1726,-0.39076,-0.90417>,<0.52044,0.79636,0.30813>,<-0.70397,-0.39589,0.58966>,
            
    /*2*/<0.15431,-0.36704,-0.91732>,<0.58953,0.72666,0.35273>,<-0.74982,-0.34399,0.5652>,
            
    /*3*/<0.15383,-0.37459,-0.91434>,<0.66827,0.62059,0.41022>,<-0.83387,-0.23431,0.49975>,
            
    /*4*/<-0.4038,0.7993,-0.44504>

    /* stem 0.36.4*/ 
    /*0*/<0.204,-0.53142,0.82218>,
    /*1*/<0.97564,0.17017,-0.13846>,<-0.54687,0.63823,0.54185>,<-0.43198,-0.80006,-0.4163>,
            
    /*2*/<0.98736,0.13094,-0.08934>,<-0.54407,0.62282,0.56222>,<-0.44573,-0.74922,-0.4899>,
            
    /*3*/<0.99525,0.09179,-0.03246>,<-0.53677,0.53511,0.65233>,<-0.47035,-0.6169,-0.63103>,
            
    /*4*/<-0.08333,0.8134,-0.5757>

    /* stem 0.36.5*/ 
    /*0*/<-0.40599,-0.77998,0.47624>,
    /*1*/<0.28645,0.39142,0.87449>,<-0.89224,0.23591,-0.38505>,<0.61204,-0.61531,-0.49678>,
            
    /*2*/<0.28157,0.37954,0.88129>,<-0.91051,0.19606,-0.36406>,<0.635,-0.56466,-0.52719>,
            
    /*3*/<0.27405,0.35738,0.89285>,<-0.93921,0.11947,-0.32188>,<0.6694,-0.46454,-0.57975>,
            
    /*4*/<0.19929,0.89438,-0.40047>

    /* stem 0.36.6*/ 
    /*0*/<0.02165,-0.99862,0.04782>,
    /*1*/<-0.84888,0.01195,0.52845>,<-0.03324,-0.04348,-0.9985>,<0.88179,0.04664,0.46933>,
            
    /*2*/<-0.84869,0.0595,0.52553>,<-0.034,-0.06595,-0.99724>,<0.88152,0.02178,0.47164>,
            
    /*3*/<-0.84607,0.04783,0.53092>,<-0.01918,-0.16641,-0.98587>,<0.87862,0.13929,0.45676>,
            
    /*4*/<-0.17722,0.95367,-0.2431>

    /* stem 0.36.7*/ 
    /*0*/<0.53022,-0.84674,-0.04356>,
    /*1*/<-0.66887,-0.38009,-0.63886>,<0.78461,0.51496,-0.34526>,<-0.12367,-0.12221,0.98477>,
            
    /*2*/<-0.68411,-0.34116,-0.64468>,<0.86432,0.37218,-0.33828>,<-0.16557,-0.01373,0.9861>,
            
    /*3*/<-0.71744,-0.22257,-0.6601>,<0.93136,0.1745,-0.31955>,<-0.21949,0.06186,0.97365>,
            
    /*4*/<-0.14518,0.98746,-0.06193>

    /* stem 0.36.8*/ 
    /*0*/<0.66159,-0.50326,0.5559>,
    /*1*/<0.54581,-0.17736,-0.81892>,<0.16456,0.82433,0.54166>,<-0.72004,-0.63961,0.26914>,
            
    /*2*/<0.59333,-0.22958,-0.77153>,<0.1867,0.80064,0.56932>,<-0.79847,-0.5711,0.19051>,
            
    /*3*/<0.62888,-0.24253,-0.73871>,<0.24184,0.72925,0.64008>,<-0.87529,-0.47469,0.09242>,
            
    /*4*/<-0.42069,0.72343,-0.54742>

    /* stem 0.36.9*/ 
    /*0*/<0.01634,-0.82843,0.55986>,
    /*1*/<0.92886,0.22365,0.29531>,<-0.78485,0.34028,0.5179>,<-0.14424,-0.55208,-0.82122>,
            
    /*2*/<0.92963,0.21429,0.29978>,<-0.78641,0.24055,0.56895>,<-0.15598,-0.44532,-0.88168>,
            
    /*3*/<0.93433,0.17727,0.30919>,<-0.7674,0.06145,0.63822>,<-0.17528,-0.22596,-0.95824>,
            
    /*4*/<-0.11849,0.98783,-0.10079>

    /* stem 0.36.10*/ 
    /*0*/<-0.26874,-0.94428,0.19006>,
    /*1*/<-0.12056,0.23342,0.96487>,<-0.76531,0.09456,-0.63667>,<0.88961,-0.31487,-0.33084>,
            
    /*2*/<-0.12185,0.22738,0.96615>,<-0.77767,0.03945,-0.62744>,<0.90354,-0.25437,-0.34484>,
            
    /*3*/<-0.12293,0.22476,0.96663>,<-0.794,-0.06171,-0.60477>,<0.9181,-0.1501,-0.36683>,
            
    /*4*/<0.02747,0.97465,-0.22206>

    /* stem 0.36.11*/ 
    /*0*/<0.0674,-0.94453,-0.32142>,
    /*1*/<-0.98404,-0.11242,0.13796>,<0.34743,0.32842,-0.87831>,<0.6357,-0.2033,0.74468>,
            
    /*2*/<-0.98479,-0.10296,0.13995>,<0.35299,0.26996,-0.89583>,<0.6338,-0.15373,0.75807>,
            
    /*3*/<-0.98194,-0.13551,0.13204>,<0.35276,0.24284,-0.90365>,<0.6264,-0.09443,0.77376>,
            
    /*4*/<-0.15015,0.96124,0.23124>

    /* stem 0.36.12*/ 
    /*0*/<0.57349,-0.81762,0.05111>,
    /*1*/<-0.32191,-0.27993,-0.90444>,<0.81207,0.57732,0.08511>,<-0.49354,-0.29258,0.81903>,
            
    /*2*/<-0.33698,-0.25432,-0.90651>,<0.8449,0.52763,0.088>,<-0.50863,-0.26721,0.81847>,
            
    /*3*/<-0.36036,-0.20448,-0.91013>,<0.91203,0.39812,0.09846>,<-0.54914,-0.18691,0.81456>,
            
    /*4*/<-0.31067,0.94836,-0.06399>

    /* stem 0.37*/ 
    /*0*/<-0.35967,-0.86603,0.34733>,
    /*1*/<0.69721,0.0062,0.71684>,<-0.37523,0.48171,0.79193>,<-0.92556,0.30008,-0.23083>,
            <-0.19324,-0.28769,-0.93803>,<0.80969,-0.46932,-0.35234>,
    /*2*/<0.69713,0.00628,0.71692>,<-0.39418,0.4331,0.81058>,<-0.93745,0.26998,-0.21979>,
            <-0.18191,-0.25737,-0.94904>,<0.82837,-0.4204,-0.37024>,
    /*3*/<0.69659,0.00664,0.71744>,<-0.42623,0.33187,0.84154>,<-0.95746,0.20759,-0.20046>,
            <-0.16299,-0.19429,-0.96731>,<0.85932,-0.31854,-0.40013>,
    /*4*/<0.20631,0.95799,-0.19923>

    /* stem 0.37.0*/ 
    /*0*/<-0.69668,-0.71588,0.04645>,
    /*1*/<-0.44698,0.49103,0.74773>,<-0.25421,0.19342,-0.94761>,<0.71243,-0.67289,0.19913>,
            
    /*2*/<-0.4791,0.45366,0.75144>,<-0.26376,0.18194,-0.94727>,<0.75544,-0.6247,0.19761>,
            
    /*3*/<-0.52906,0.37738,0.76005>,<-0.32346,0.07728,-0.94308>,<0.87767,-0.44578,0.17599>,
            
    /*4*/<0.33968,0.92704,-0.15879>

    /* stem 0.37.1*/ 
    /*0*/<-0.12922,-0.96038,-0.24694>,
    /*1*/<-0.89675,0.22429,-0.3815>,<0.81467,0.04459,-0.57821>,<0.08414,-0.25356,0.96365>,
            
    /*2*/<-0.90211,0.18313,-0.39072>,<0.81496,0.04927,-0.57743>,<0.0873,-0.21698,0.97226>,
            
    /*3*/<-0.90532,0.15234,-0.39647>,<0.80448,-0.07093,-0.58973>,<0.11669,-0.06885,0.99078>,
            
    /*4*/<0.19959,0.97778,-0.06406>

    /* stem 0.37.2*/ 
    /*0*/<0.2084,-0.89715,0.38947>,
    /*1*/<0.04588,-0.38388,-0.92224>,<0.82145,0.38089,0.42444>,<-0.8706,0.01705,0.4917>,
            
    /*2*/<0.04458,-0.36521,-0.92986>,<0.83488,0.30418,0.45875>,<-0.8791,0.07699,0.47038>,
            
    /*3*/<0.04507,-0.32963,-0.94303>,<0.84282,0.18794,0.50432>,<-0.88707,0.15651,0.4343>,
            
    /*4*/<0.03267,0.94796,-0.31672>

    /* stem 0.37.3*/ 
    /*0*/<-0.17733,-0.48137,0.85839>,
    /*1*/<0.91948,-0.39153,-0.03559>,<-0.15247,0.87753,0.45463>,<-0.76427,-0.4786,-0.43224>,
            
    /*2*/<0.93665,-0.33551,-0.10062>,<-0.17445,0.79459,0.58155>,<-0.76029,-0.43954,-0.4783>,
            
    /*3*/<0.93708,-0.32021,-0.13909>,<-0.20656,0.66619,0.7166>,<-0.73215,-0.33655,-0.59219>,
            
    /*4*/<0.2376,0.77418,-0.58667>

    /* stem 0.37.4*/ 
    /*0*/<-0.62098,-0.69502,0.3624>,
    /*1*/<0.35356,0.1709,0.91967>,<-0.77927,0.52536,-0.34167>,<0.43511,-0.68573,-0.58348>,
            
    /*2*/<0.35126,0.16801,0.92108>,<-0.82626,0.46563,-0.31699>,<0.48165,-0.62369,-0.61565>,
            
    /*3*/<0.36445,0.20983,0.90727>,<-0.92438,0.29325,-0.24398>,<0.55303,-0.49065,-0.67337>,
            
    /*4*/<0.23609,0.9048,-0.3544>

    /* stem 0.37.5*/ 
    /*0*/<-0.48557,-0.86848,-0.09987>,
    /*1*/<-0.78808,0.39173,0.47484>,<0.0744,0.07843,-0.99414>,<0.72091,-0.45723,0.52079>,
            
    /*2*/<-0.80935,0.3439,0.47611>,<0.05131,0.01826,-0.99852>,<0.77385,-0.35045,0.52757>,
            
    /*3*/<-0.80733,0.36734,0.46183>,<-0.02724,-0.15618,-0.98735>,<0.83491,-0.20077,0.51247>,
            
    /*4*/<0.3383,0.89824,-0.28056>

    /* stem 0.37.6*/ 
    /*0*/<0.08773,-0.9914,-0.09715>,
    /*1*/<-0.7065,0.0117,-0.70762>,<0.96114,0.11454,-0.25117>,<-0.25592,-0.11187,0.9602>,
            
    /*2*/<-0.70632,0.01071,-0.70781>,<0.96529,0.06208,-0.25371>,<-0.25777,-0.05838,0.96444>,
            
    /*3*/<-0.70486,0.03848,-0.70831>,<0.9657,-0.02831,-0.25813>,<-0.2596,0.00419,0.96571>,
            
    /*4*/<0.07656,0.997,0.01181>

    /* stem 0.37.7*/ 
    /*0*/<0.10751,-0.86799,0.48481>,
    /*1*/<0.47232,-0.38019,-0.79521>,<0.52046,0.46862,0.7138>,<-0.99431,-0.07608,0.07451>,
            
    /*2*/<0.4721,-0.36812,-0.801>,<0.52473,0.41566,0.74289>,<-0.99794,-0.03378,0.05446>,
            
    /*3*/<0.47344,-0.34451,-0.81066>,<0.52529,0.30741,0.79346>,<-0.99859,0.0511,0.01457>,
            
    /*4*/<0.08528,0.93685,-0.33917>

    /* stem 0.37.8*/ 
    /*0*/<-0.33777,-0.65283,0.67803>,
    /*1*/<0.93334,-0.12722,0.33571>,<-0.57945,0.71434,0.39238>,<-0.34925,-0.57816,-0.7374>,
            
    /*2*/<0.92409,-0.14873,0.35204>,<-0.61008,0.66058,0.43753>,<-0.31515,-0.50303,-0.80476>,
            
    /*3*/<0.91664,-0.15847,0.36695>,<-0.66651,0.52941,0.52487>,<-0.25283,-0.35802,-0.89883>,
            
    /*4*/<0.28765,0.89043,-0.3527>

    /* stem 0.37.9*/ 
    /*0*/<-0.72391,-0.68348,0.09387>,
    /*1*/<-0.07813,0.22277,0.97174>,<-0.54935,0.49607,-0.6724>,<0.63723,-0.70964,-0.30059>,
            
    /*2*/<-0.09381,0.2037,0.97453>,<-0.59388,0.4459,-0.66969>,<0.70038,-0.64237,-0.31118>,
            
    /*3*/<-0.09234,0.21308,0.97266>,<-0.67012,0.35249,-0.65322>,<0.76794,-0.55373,-0.32194>,
            
    /*4*/<0.516,0.84048,-0.16531>

    /* stem 0.37.10*/ 
    /*0*/<-0.24503,-0.94742,-0.20581>,
    /*1*/<-0.96739,0.23298,0.09942>,<0.44517,0.08293,-0.8916>,<0.52526,-0.30412,0.79474>,
            
    /*2*/<-0.96651,0.23678,0.09895>,<0.42217,-0.0398,-0.90564>,<0.56188,-0.18896,0.80535>,
            
    /*3*/<-0.96501,0.24297,0.09863>,<0.37487,-0.20637,-0.90382>,<0.5951,-0.02544,0.80325>,
            
    /*4*/<0.22019,0.9575,-0.18629>

    /* stem 0.37.11*/ 
    /*0*/<0.21371,-0.97603,0.0411>,
    /*1*/<-0.35482,-0.11433,-0.92792>,<0.96506,0.21976,0.14273>,<-0.61176,-0.09846,0.78489>,
            
    /*2*/<-0.33764,-0.21056,-0.91742>,<0.96243,0.23274,0.13987>,<-0.63363,-0.01811,0.77343>,
            
    /*3*/<-0.32476,-0.29778,-0.89769>,<0.97081,0.19283,0.14265>,<-0.64574,0.11236,0.75525>,
            
    /*4*/<-0.09103,0.95595,-0.27904>

    /* stem 0.38*/ 
    /*0*/<-0.41934,-0.86603,-0.27232>,
    /*1*/<-0.54219,0.00503,0.84024>,<-0.85661,0.48055,-0.18784>,<0.01614,0.29892,-0.95414>,
            <0.86996,-0.28886,-0.39967>,<0.52489,-0.47049,0.70932>,
    /*2*/<-0.54228,0.00509,0.84018>,<-0.87899,0.43191,-0.20208>,<0.00273,0.26879,-0.96319>,
            <0.88328,-0.25856,-0.39111>,<0.54658,-0.4216,0.72354>,
    /*3*/<-0.54279,0.00538,0.83985>,<-0.91624,0.33061,-0.22627>,<-0.02048,0.20633,-0.97827>,
            <0.90546,-0.19555,-0.3767>,<0.58279,-0.3198,0.74705>,
    /*4*/<0.24053,0.95799,0.1562>

    /* stem 0.38.0*/ 
    /*0*/<-0.17748,-0.69172,-0.70001>,
    /*1*/<-0.82943,0.4902,-0.26786>,<0.87351,0.22108,-0.4337>,<-0.04176,-0.70222,0.71073>,
            
    /*2*/<-0.83141,0.48349,-0.27387>,<0.86523,0.18518,-0.46593>,<-0.0293,-0.66088,0.74992>,
            
    /*3*/<-0.85888,0.39619,-0.32459>,<0.84713,0.11124,-0.51961>,<0.00917,-0.49972,0.86614>,
            
    /*4*/<0.16586,0.91446,0.36913>

    /* stem 0.38.1*/ 
    /*0*/<-0.05932,-0.97088,-0.23211>,
    /*1*/<0.17138,0.22335,-0.95955>,<0.76639,-0.18917,0.61389>,<-0.937,-0.02169,0.34865>,
            
    /*2*/<0.16277,0.17702,-0.97065>,<0.75951,-0.23412,0.6069>,<-0.92673,0.07126,0.36891>,
            
    /*3*/<0.1687,0.17137,-0.97066>,<0.72605,-0.38381,0.57057>,<-0.88593,0.21896,0.40889>,
            
    /*4*/<0.40712,0.87328,0.26766>

    /* stem 0.38.2*/ 
    /*0*/<-0.36836,-0.91882,0.14171>,
    /*1*/<0.90876,-0.38467,-0.16184>,<-0.27605,0.25809,0.92584>,<-0.62802,0.13829,-0.76581>,
            
    /*2*/<0.91716,-0.36274,-0.16502>,<-0.28103,0.24473,0.92797>,<-0.63126,0.12969,-0.76465>,
            
    /*3*/<0.92411,-0.34393,-0.16651>,<-0.30638,0.1836,0.93404>,<-0.61612,0.17332,-0.76835>,
            
    /*4*/<0.3551,0.9348,-0.00728>

    /* stem 0.38.3*/ 
    /*0*/<-0.70917,-0.69492,-0.11904>,
    /*1*/<0.23997,-0.39111,0.88851>,<-0.69061,0.72083,-0.05889>,<0.45947,-0.32105,-0.82814>,
            
    /*2*/<0.29384,-0.32589,0.89858>,<-0.75599,0.65146,-0.06391>,<0.46523,-0.31319,-0.82793>,
            
    /*3*/<0.34564,-0.25861,0.90203>,<-0.84421,0.5299,-0.08069>,<0.504,-0.26003,-0.82363>,
            
    /*4*/<0.47272,0.87803,0.07486>

    /* stem 0.38.4*/ 
    /*0*/<-0.49103,-0.6992,-0.51962>,
    /*1*/<-0.81706,0.17023,0.55085>,<0.15457,0.52107,-0.8394>,<0.66847,-0.68278,0.29488>,
            
    /*2*/<-0.82475,0.15414,0.54408>,<0.10414,0.4097,-0.90626>,<0.74723,-0.55848,0.3602>,
            
    /*3*/<-0.85616,0.0538,0.5139>,<0.0349,0.29585,-0.9546>,<0.82418,-0.34114,0.45206>,
            
    /*4*/<0.12628,0.94801,0.2921>

    /* stem 0.38.5*/ 
    /*0*/<-0.04322,-0.88036,-0.47234>,
    /*1*/<-0.63984,0.39092,-0.66165>,<0.98454,0.04676,-0.16881>,<-0.34418,-0.42718,0.8361>,
            
    /*2*/<-0.6422,0.37286,-0.66974>,<0.98157,-0.00463,-0.19106>,<-0.33747,-0.35902,0.87018>,
            
    /*3*/<-0.65758,0.31074,-0.68632>,<0.96038,-0.14801,-0.23615>,<-0.29832,-0.15167,0.94234>,
            
    /*4*/<0.27574,0.95663,0.09398>

    /* stem 0.38.6*/ 
    /*0*/<0.05178,-0.99836,0.02431>,
    /*1*/<0.53091,0.01078,-0.84736>,<0.46665,0.04959,0.88305>,<-0.99816,-0.04877,-0.03598>,
            
    /*2*/<0.53049,0.00227,-0.84769>,<0.46312,-0.03422,0.88563>,<-0.99852,0.04396,-0.03188>,
            
    /*3*/<0.54081,0.03242,-0.84052>,<0.44023,-0.23401,0.86686>,<-0.97792,0.20848,-0.01451>,
            
    /*4*/<0.26807,0.92953,0.25319>

    /* stem 0.38.7*/ 
    /*0*/<-0.35941,-0.89718,0.2567>,
    /*1*/<0.91267,-0.27493,0.30241>,<-0.62816,0.43952,0.64206>,<-0.28048,-0.15453,-0.94734>,
            
    /*2*/<0.91114,-0.27919,0.3031>,<-0.66982,0.34366,0.65821>,<-0.24786,-0.05078,-0.96746>,
            
    /*3*/<0.91144,-0.27534,0.30572>,<-0.71445,0.19774,0.67117>,<-0.19577,0.08864,-0.97664>,
            
    /*4*/<0.26147,0.96252,0.07203>

    /* stem 0.38.8*/ 
    /*0*/<-0.63161,-0.75476,-0.17721>,
    /*1*/<-0.11822,-0.12745,0.98477>,<-0.60068,0.62466,-0.49897>,<0.72581,-0.48895,-0.48386>,
            
    /*2*/<-0.07818,-0.06656,0.99471>,<-0.66395,0.54578,-0.51116>,<0.74111,-0.46669,-0.48266>,
            
    /*3*/<-0.06816,-0.05712,0.99604>,<-0.70178,0.48603,-0.52085>,<0.77524,-0.42017,-0.47165>,
            
    /*4*/<0.51316,0.84556,0.14729>

    /* stem 0.38.9*/ 
    /*0*/<-0.25707,-0.72279,-0.64147>,
    /*1*/<-0.96464,0.22225,0.14166>,<0.51848,0.46012,-0.72074>,<0.44889,-0.67473,0.58587>,
            
    /*2*/<-0.96074,0.23364,0.14963>,<0.50249,0.41161,-0.76031>,<0.46406,-0.63734,0.61518>,
            
    /*3*/<-0.96247,0.2271,0.14862>,<0.47212,0.32069,-0.82113>,<0.4965,-0.54049,0.67923>,
            
    /*4*/<0.24546,0.87455,0.41822>

    /* stem 0.38.10*/ 
    /*0*/<0.35888,-0.86985,-0.33848>,
    /*1*/<-0.31437,0.23023,-0.92096>,<0.91771,0.26504,0.29591>,<-0.6048,-0.49173,0.62643>,
            
    /*2*/<-0.32515,0.25989,-0.90925>,<0.9308,0.23245,0.28209>,<-0.60603,-0.48821,0.62799>,
            
    /*3*/<-0.33616,0.32209,-0.88502>,<0.97242,0.07112,0.22212>,<-0.62503,-0.39469,0.67346>,
            
    /*4*/<-0.01388,0.92492,0.37991>

    /* stem 0.39*/ 
    /*0*/<0.17101,-0.86603,-0.46985>,
    /*1*/<-0.9402,0.00259,-0.34061>,<-0.00919,0.47812,-0.87825>,<0.93381,0.29648,-0.20023>,
            <0.58561,-0.2913,0.75644>,<-0.57259,-0.47294,0.66968>,
    /*2*/<-0.94018,0.00262,-0.34066>,<-0.00037,0.42941,-0.90311>,<0.93954,0.26631,-0.21528>,
            <0.58029,-0.26104,0.77144>,<-0.58165,-0.4241,0.69414>,
    /*3*/<-0.94008,0.00277,-0.34096>,<0.01472,0.32799,-0.94457>,<0.9489,0.20372,-0.241>,
            <0.57114,-0.19816,0.79658>,<-0.59652,-0.32242,0.73499>,
    /*4*/<-0.09809,0.95799,0.26951>

    /* stem 0.39.0*/ 
    /*0*/<0.68915,-0.65658,-0.30655>,
    /*1*/<0.07567,0.48866,-0.86919>,<0.5838,0.25655,0.7703>,<-0.66412,-0.74078,0.10096>,
            
    /*2*/<0.10996,0.44718,-0.88766>,<0.60633,0.22945,0.76139>,<-0.72651,-0.67517,0.12779>,
            
    /*3*/<0.15002,0.3963,-0.90578>,<0.63271,0.20525,0.74669>,<-0.78652,-0.59629,0.16072>,
            
    /*4*/<-0.5456,0.80099,0.24644>

    /* stem 0.39.1*/ 
    /*0*/<0.22455,-0.9574,0.18157>,
    /*1*/<0.97394,0.2213,-0.04974>,<-0.48127,0.05535,0.87482>,<-0.49416,-0.2703,-0.82629>,
            
    /*2*/<0.9829,0.17757,-0.0487>,<-0.4727,-0.01486,0.8811>,<-0.5193,-0.15593,-0.84025>,
            
    /*3*/<0.98309,0.17785,-0.04354>,<-0.44112,-0.14149,0.88622>,<-0.54254,-0.03025,-0.83949>,
            
    /*4*/<-0.21457,0.96982,0.11583>

    /* stem 0.39.2*/ 
    /*0*/<-0.30989,-0.90739,-0.28391>,
    /*1*/<0.36186,-0.38659,0.8483>,<-0.94158,0.33496,-0.03511>,<0.58175,0.05758,-0.81132>,
            
    /*2*/<0.36153,-0.38748,0.84803>,<-0.96842,0.23762,-0.07551>,<0.60415,0.16053,-0.78054>,
            
    /*3*/<0.35855,-0.3984,0.84423>,<-0.98551,0.12401,-0.11574>,<0.62762,0.28045,-0.72625>,
            
    /*4*/<0.04792,0.90524,0.42219>

    /* stem 0.39.3*/ 
    /*0*/<-0.11199,-0.619,-0.77737>,
    /*1*/<-0.8117,-0.39268,0.43238>,<-0.08993,0.78671,-0.61073>,<0.90235,-0.39006,0.18335>,
            
    /*2*/<-0.80817,-0.35207,0.47213>,<-0.10207,0.71949,-0.68697>,<0.90884,-0.35857,0.21316>,
            
    /*3*/<-0.80266,-0.34333,0.48772>,<-0.10948,0.62248,-0.77494>,<0.91565,-0.27516,0.29303>,
            
    /*4*/<-0.02784,0.7976,0.60255>

    /* stem 0.39.4*/ 
    /*0*/<0.38132,-0.7165,-0.58414>,
    /*1*/<-0.71973,0.16889,-0.6734>,<0.86196,0.50428,-0.05229>,<-0.14463,-0.66867,0.72936>,
            
    /*2*/<-0.73503,0.20867,-0.64513>,<0.89076,0.44276,-0.10249>,<-0.15323,-0.64443,0.74916>,
            
    /*3*/<-0.73768,0.17867,-0.65108>,<0.92687,0.33415,-0.17105>,<-0.19677,-0.51162,0.83638>,
            
    /*4*/<-0.2051,0.91095,0.35791>

    /* stem 0.39.5*/ 
    /*0*/<0.6511,-0.75775,0.04353>,
    /*1*/<0.50122,0.38898,-0.77296>,<0.23996,0.26259,0.93459>,<-0.74519,-0.6469,-0.1619>,
            
    /*2*/<0.55538,0.32124,-0.76704>,<0.21959,0.29222,0.9308>,<-0.77559,-0.60814,-0.16917>,
            
    /*3*/<0.5958,0.26197,-0.7592>,<0.20123,0.31842,0.92635>,<-0.80037,-0.57541,-0.16826>,
            
    /*4*/<-0.56618,0.8107,-0.14901>

    /* stem 0.39.6*/ 
    /*0*/<-0.08472,-0.96046,0.26523>,
    /*1*/<0.9452,0.00881,0.32639>,<-0.74585,0.23949,0.62157>,<-0.19884,-0.24262,-0.94953>,
            
    /*2*/<0.94526,0.0228,0.32551>,<-0.75769,0.11547,0.64232>,<-0.20153,-0.13358,-0.97033>,
            
    /*3*/<0.94433,0.04893,0.32534>,<-0.752,-0.07541,0.65484>,<-0.19656,0.03175,-0.97998>,
            
    /*4*/<-0.09845,0.98944,0.10642>

    /* stem 0.39.7*/ 
    /*0*/<-0.55044,-0.78618,-0.28095>,
    /*1*/<-0.08953,-0.27677,0.95675>,<-0.6724,0.61851,-0.40659>,<0.7651,-0.33721,-0.54855>,
            
    /*2*/<-0.08858,-0.27352,0.95778>,<-0.73564,0.4999,-0.45709>,<0.82743,-0.21604,-0.51835>,
            
    /*3*/<-0.08946,-0.26891,0.959>,<-0.79605,0.33938,-0.50113>,<0.88683,-0.06489,-0.45752>,
            
    /*4*/<0.17659,0.94298,0.28216>

    /* stem 0.39.8*/ 
    /*0*/<0.01353,-0.68439,-0.72899>,
    /*1*/<-0.98605,-0.12892,0.10532>,<0.34917,0.68767,-0.63655>,<0.6368,-0.55489,0.53534>,
            
    /*2*/<-0.9851,-0.14823,0.08725>,<0.35113,0.6685,-0.65561>,<0.63511,-0.51721,0.5737>,
            
    /*3*/<-0.97817,-0.20365,0.04138>,<0.35682,0.62352,-0.69564>,<0.62283,-0.41737,0.66173>,
            
    /*4*/<-0.19159,0.8004,0.56802>

    /* stem 0.39.9*/ 
    /*0*/<0.54661,-0.74047,-0.39106>,
    /*1*/<-0.354,0.22103,-0.90875>,<0.83314,0.44154,0.33304>,<-0.48207,-0.6586,0.57781>,
            
    /*2*/<-0.34132,0.19584,-0.91932>,<0.87338,0.37624,0.30927>,<-0.53668,-0.57094,0.62129>,
            
    /*3*/<-0.30729,0.08842,-0.9475>,<0.92911,0.25497,0.26786>,<-0.63804,-0.33993,0.69091>,
            
    /*4*/<-0.21802,0.97358,0.06785>

    /* stem 0.39.10*/ 
    /*0*/<0.36698,-0.91172,0.18463>,
    /*1*/<0.82701,0.22952,-0.51321>,<-0.04527,0.18129,0.98239>,<-0.7823,-0.4094,-0.46947>,
            
    /*2*/<0.81859,0.25721,-0.51358>,<-0.00567,0.06342,0.99797>,<-0.81939,-0.32284,-0.47369>,
            
    /*3*/<0.79464,0.34209,-0.50151>,<0.07321,-0.17634,0.9816>,<-0.86722,-0.16985,-0.46807>,
            
    /*4*/<-0.2698,0.91035,0.31379>

    }
    face_indices { 17942
    /* stem 0*/ 
    /*0*/ <0,1,2>,<0,2,3>,<0,3,4>,<0,4,5>,<0,5,6>,
            <0,6,7>,<0,7,8>,<0,8,9>,<0,9,10>,<0,10,11>,<0,11,12>,
            <0,12,13>,<0,13,14>,<0,14,15>,<0,15,16>,<0,16,17>,<0,17,18>,
            <0,18,19>,<0,19,20>,<0,20,21>,<0,21,22>,<0,22,23>,<0,23,24>,
            <0,24,25>,<0,25,26>,<0,26,27>,<0,27,28>,<0,28,1>,
    /*1*/ <1,29,2>,<2,29,30>,<2,30,3>,<3,30,31>,<3,31,4>,
            <4,31,32>,<4,32,5>,<5,32,33>,<5,33,6>,<6,33,34>,<6,34,7>,
            <7,34,35>,<7,35,8>,<8,35,36>,<8,36,9>,<9,36,37>,<9,37,10>,
            <10,37,38>,<10,38,11>,<11,38,39>,<11,39,12>,<12,39,40>,<12,40,13>,
            <13,40,41>,<13,41,14>,<14,41,42>,<14,42,15>,<15,42,43>,<15,43,16>,
            <16,43,44>,<16,44,17>,<17,44,45>,<17,45,18>,<18,45,46>,<18,46,19>,
            <19,46,47>,<19,47,20>,<20,47,48>,<20,48,21>,<21,48,49>,<21,49,22>,
            <22,49,50>,<22,50,23>,<23,50,51>,<23,51,24>,<24,51,52>,<24,52,25>,
            <25,52,53>,<25,53,26>,<26,53,54>,<26,54,27>,<27,54,55>,<27,55,28>,
            <28,55,56>,<28,56,1>,<1,56,29>,
    /*2*/ <29,57,30>,<30,57,58>,<30,58,31>,<31,58,59>,<31,59,32>,
            <32,59,60>,<32,60,33>,<33,60,61>,<33,61,34>,<34,61,62>,<34,62,35>,
            <35,62,63>,<35,63,36>,<36,63,64>,<36,64,37>,<37,64,65>,<37,65,38>,
            <38,65,66>,<38,66,39>,<39,66,67>,<39,67,40>,<40,67,68>,<40,68,41>,
            <41,68,69>,<41,69,42>,<42,69,70>,<42,70,43>,<43,70,71>,<43,71,44>,
            <44,71,72>,<44,72,45>,<45,72,73>,<45,73,46>,<46,73,74>,<46,74,47>,
            <47,74,75>,<47,75,48>,<48,75,76>,<48,76,49>,<49,76,77>,<49,77,50>,
            <50,77,78>,<50,78,51>,<51,78,79>,<51,79,52>,<52,79,80>,<52,80,53>,
            <53,80,81>,<53,81,54>,<54,81,82>,<54,82,55>,<55,82,83>,<55,83,56>,
            <56,83,84>,<56,84,29>,<29,84,57>,
    /*3*/ <57,85,58>,<58,85,86>,<58,86,59>,<59,86,87>,<59,87,60>,
            <60,87,88>,<60,88,61>,<61,88,89>,<61,89,62>,<62,89,90>,<62,90,63>,
            <63,90,91>,<63,91,64>,<64,91,92>,<64,92,65>,<65,92,93>,<65,93,66>,
            <66,93,94>,<66,94,67>,<67,94,95>,<67,95,68>,<68,95,96>,<68,96,69>,
            <69,96,97>,<69,97,70>,<70,97,98>,<70,98,71>,<71,98,99>,<71,99,72>,
            <72,99,100>,<72,100,73>,<73,100,101>,<73,101,74>,<74,101,102>,<74,102,75>,
            <75,102,103>,<75,103,76>,<76,103,104>,<76,104,77>,<77,104,105>,<77,105,78>,
            <78,105,106>,<78,106,79>,<79,106,107>,<79,107,80>,<80,107,108>,<80,108,81>,
            <81,108,109>,<81,109,82>,<82,109,110>,<82,110,83>,<83,110,111>,<83,111,84>,
            <84,111,112>,<84,112,57>,<57,112,85>,
    /*4*/ <85,113,86>,<86,113,114>,<86,114,87>,<87,114,115>,<87,115,88>,
            <88,115,116>,<88,116,89>,<89,116,117>,<89,117,90>,<90,117,118>,<90,118,91>,
            <91,118,119>,<91,119,92>,<92,119,120>,<92,120,93>,<93,120,121>,<93,121,94>,
            <94,121,122>,<94,122,95>,<95,122,123>,<95,123,96>,<96,123,124>,<96,124,97>,
            <97,124,125>,<97,125,98>,<98,125,126>,<98,126,99>,<99,126,127>,<99,127,100>,
            <100,127,128>,<100,128,101>,<101,128,129>,<101,129,102>,<102,129,130>,<102,130,103>,
            <103,130,131>,<103,131,104>,<104,131,132>,<104,132,105>,<105,132,133>,<105,133,106>,
            <106,133,134>,<106,134,107>,<107,134,135>,<107,135,108>,<108,135,136>,<108,136,109>,
            <109,136,137>,<109,137,110>,<110,137,138>,<110,138,111>,<111,138,139>,<111,139,112>,
            <112,139,140>,<112,140,85>,<85,140,113>,
    /*5*/ <113,141,114>,<114,141,142>,<114,142,115>,<115,142,143>,<115,143,116>,
            <116,143,144>,<116,144,117>,<117,144,145>,<117,145,118>,<118,145,146>,<118,146,119>,
            <119,146,147>,<119,147,120>,<120,147,148>,<120,148,121>,<121,148,149>,<121,149,122>,
            <122,149,150>,<122,150,123>,<123,150,151>,<123,151,124>,<124,151,152>,<124,152,125>,
            <125,152,153>,<125,153,126>,<126,153,154>,<126,154,127>,<127,154,155>,<127,155,128>,
            <128,155,156>,<128,156,129>,<129,156,157>,<129,157,130>,<130,157,158>,<130,158,131>,
            <131,158,159>,<131,159,132>,<132,159,160>,<132,160,133>,<133,160,161>,<133,161,134>,
            <134,161,162>,<134,162,135>,<135,162,163>,<135,163,136>,<136,163,164>,<136,164,137>,
            <137,164,165>,<137,165,138>,<138,165,166>,<138,166,139>,<139,166,167>,<139,167,140>,
            <140,167,168>,<140,168,113>,<113,168,141>,
    /*6*/ <141,169,142>,<142,169,170>,<142,170,143>,<143,170,171>,<143,171,144>,
            <144,171,172>,<144,172,145>,<145,172,173>,<145,173,146>,<146,173,174>,<146,174,147>,
            <147,174,175>,<147,175,148>,<148,175,176>,<148,176,149>,<149,176,177>,<149,177,150>,
            <150,177,178>,<150,178,151>,<151,178,179>,<151,179,152>,<152,179,180>,<152,180,153>,
            <153,180,181>,<153,181,154>,<154,181,182>,<154,182,155>,<155,182,183>,<155,183,156>,
            <156,183,184>,<156,184,157>,<157,184,185>,<157,185,158>,<158,185,186>,<158,186,159>,
            <159,186,187>,<159,187,160>,<160,187,188>,<160,188,161>,<161,188,189>,<161,189,162>,
            <162,189,190>,<162,190,163>,<163,190,191>,<163,191,164>,<164,191,192>,<164,192,165>,
            <165,192,193>,<165,193,166>,<166,193,194>,<166,194,167>,<167,194,195>,<167,195,168>,
            <168,195,196>,<168,196,141>,<141,196,169>,
    /*7*/ <169,197,170>,<170,197,198>,<170,198,171>,<171,198,199>,<171,199,172>,
            <172,199,200>,<172,200,173>,<173,200,201>,<173,201,174>,<174,201,202>,<174,202,175>,
            <175,202,203>,<175,203,176>,<176,203,204>,<176,204,177>,<177,204,205>,<177,205,178>,
            <178,205,206>,<178,206,179>,<179,206,207>,<179,207,180>,<180,207,208>,<180,208,181>,
            <181,208,209>,<181,209,182>,<182,209,210>,<182,210,183>,<183,210,211>,<183,211,184>,
            <184,211,212>,<184,212,185>,<185,212,213>,<185,213,186>,<186,213,214>,<186,214,187>,
            <187,214,215>,<187,215,188>,<188,215,216>,<188,216,189>,<189,216,217>,<189,217,190>,
            <190,217,218>,<190,218,191>,<191,218,219>,<191,219,192>,<192,219,220>,<192,220,193>,
            <193,220,221>,<193,221,194>,<194,221,222>,<194,222,195>,<195,222,223>,<195,223,196>,
            <196,223,224>,<196,224,169>,<169,224,197>,
    /*8*/ <197,225,198>,<198,225,226>,<198,226,199>,<199,226,227>,<199,227,200>,
            <200,227,228>,<200,228,201>,<201,228,229>,<201,229,202>,<202,229,230>,<202,230,203>,
            <203,230,231>,<203,231,204>,<204,231,232>,<204,232,205>,<205,232,233>,<205,233,206>,
            <206,233,234>,<206,234,207>,<207,234,235>,<207,235,208>,<208,235,236>,<208,236,209>,
            <209,236,237>,<209,237,210>,<210,237,238>,<210,238,211>,<211,238,239>,<211,239,212>,
            <212,239,240>,<212,240,213>,<213,240,241>,<213,241,214>,<214,241,242>,<214,242,215>,
            <215,242,243>,<215,243,216>,<216,243,244>,<216,244,217>,<217,244,245>,<217,245,218>,
            <218,245,246>,<218,246,219>,<219,246,247>,<219,247,220>,<220,247,248>,<220,248,221>,
            <221,248,249>,<221,249,222>,<222,249,250>,<222,250,223>,<223,250,251>,<223,251,224>,
            <224,251,252>,<224,252,197>,<197,252,225>,
    /*9*/ <225,253,226>,<226,253,254>,<226,254,227>,<227,254,255>,<227,255,228>,
            <228,255,256>,<228,256,229>,<229,256,257>,<229,257,230>,<230,257,258>,<230,258,231>,
            <231,258,259>,<231,259,232>,<232,259,260>,<232,260,233>,<233,260,261>,<233,261,234>,
            <234,261,262>,<234,262,235>,<235,262,263>,<235,263,236>,<236,263,264>,<236,264,237>,
            <237,264,265>,<237,265,238>,<238,265,266>,<238,266,239>,<239,266,267>,<239,267,240>,
            <240,267,268>,<240,268,241>,<241,268,269>,<241,269,242>,<242,269,270>,<242,270,243>,
            <243,270,271>,<243,271,244>,<244,271,272>,<244,272,245>,<245,272,273>,<245,273,246>,
            <246,273,274>,<246,274,247>,<247,274,275>,<247,275,248>,<248,275,276>,<248,276,249>,
            <249,276,277>,<249,277,250>,<250,277,278>,<250,278,251>,<251,278,279>,<251,279,252>,
            <252,279,280>,<252,280,225>,<225,280,253>,
    /*10*/ <253,281,254>,<254,281,255>,<255,281,256>,<256,281,257>,<257,281,258>,
            <258,281,259>,<259,281,260>,<260,281,261>,<261,281,262>,<262,281,263>,<263,281,264>,
            <264,281,265>,<265,281,266>,<266,281,267>,<267,281,268>,<268,281,269>,<269,281,270>,
            <270,281,271>,<271,281,272>,<272,281,273>,<273,281,274>,<274,281,275>,<275,281,276>,
            <276,281,277>,<277,281,278>,<278,281,279>,<279,281,280>,<280,281,253>

    /* stem 0.0*/ 
    /*0*/ <282,283,284>,<282,284,285>,<282,285,286>,<282,286,287>,<282,287,283>,
            
    /*1*/ <283,288,284>,<284,288,289>,<284,289,285>,<285,289,290>,<285,290,286>,
            <286,290,291>,<286,291,287>,<287,291,292>,<287,292,283>,<283,292,288>,
    /*2*/ <288,293,289>,<289,293,294>,<289,294,290>,<290,294,295>,<290,295,291>,
            <291,295,296>,<291,296,292>,<292,296,297>,<292,297,288>,<288,297,293>,
    /*3*/ <293,298,294>,<294,298,295>,<295,298,296>,<296,298,297>,<297,298,293>
            

    /* stem 0.0.0*/ 
    /*0*/ <299,300,301>,<299,301,302>,<299,302,300>,
    /*1*/ <300,303,301>,<301,303,304>,<301,304,302>,<302,304,305>,<302,305,300>,
            <300,305,303>,
    /*2*/ <303,306,304>,<304,306,307>,<304,307,305>,<305,307,308>,<305,308,303>,
            <303,308,306>,
    /*3*/ <306,309,307>,<307,309,308>,<308,309,306>

    /* stem 0.0.1*/ 
    /*0*/ <310,311,312>,<310,312,313>,<310,313,311>,
    /*1*/ <311,314,312>,<312,314,315>,<312,315,313>,<313,315,316>,<313,316,311>,
            <311,316,314>,
    /*2*/ <314,317,315>,<315,317,318>,<315,318,316>,<316,318,319>,<316,319,314>,
            <314,319,317>,
    /*3*/ <317,320,318>,<318,320,319>,<319,320,317>

    /* stem 0.0.2*/ 
    /*0*/ <321,322,323>,<321,323,324>,<321,324,322>,
    /*1*/ <322,325,323>,<323,325,326>,<323,326,324>,<324,326,327>,<324,327,322>,
            <322,327,325>,
    /*2*/ <325,328,326>,<326,328,329>,<326,329,327>,<327,329,330>,<327,330,325>,
            <325,330,328>,
    /*3*/ <328,331,329>,<329,331,330>,<330,331,328>

    /* stem 0.0.3*/ 
    /*0*/ <332,333,334>,<332,334,335>,<332,335,333>,
    /*1*/ <333,336,334>,<334,336,337>,<334,337,335>,<335,337,338>,<335,338,333>,
            <333,338,336>,
    /*2*/ <336,339,337>,<337,339,340>,<337,340,338>,<338,340,341>,<338,341,336>,
            <336,341,339>,
    /*3*/ <339,342,340>,<340,342,341>,<341,342,339>

    /* stem 0.0.4*/ 
    /*0*/ <343,344,345>,<343,345,346>,<343,346,344>,
    /*1*/ <344,347,345>,<345,347,348>,<345,348,346>,<346,348,349>,<346,349,344>,
            <344,349,347>,
    /*2*/ <347,350,348>,<348,350,351>,<348,351,349>,<349,351,352>,<349,352,347>,
            <347,352,350>,
    /*3*/ <350,353,351>,<351,353,352>,<352,353,350>

    /* stem 0.0.5*/ 
    /*0*/ <354,355,356>,<354,356,357>,<354,357,355>,
    /*1*/ <355,358,356>,<356,358,359>,<356,359,357>,<357,359,360>,<357,360,355>,
            <355,360,358>,
    /*2*/ <358,361,359>,<359,361,362>,<359,362,360>,<360,362,363>,<360,363,358>,
            <358,363,361>,
    /*3*/ <361,364,362>,<362,364,363>,<363,364,361>

    /* stem 0.0.6*/ 
    /*0*/ <365,366,367>,<365,367,368>,<365,368,366>,
    /*1*/ <366,369,367>,<367,369,370>,<367,370,368>,<368,370,371>,<368,371,366>,
            <366,371,369>,
    /*2*/ <369,372,370>,<370,372,373>,<370,373,371>,<371,373,374>,<371,374,369>,
            <369,374,372>,
    /*3*/ <372,375,373>,<373,375,374>,<374,375,372>

    /* stem 0.0.7*/ 
    /*0*/ <376,377,378>,<376,378,379>,<376,379,377>,
    /*1*/ <377,380,378>,<378,380,381>,<378,381,379>,<379,381,382>,<379,382,377>,
            <377,382,380>,
    /*2*/ <380,383,381>,<381,383,384>,<381,384,382>,<382,384,385>,<382,385,380>,
            <380,385,383>,
    /*3*/ <383,386,384>,<384,386,385>,<385,386,383>

    /* stem 0.0.8*/ 
    /*0*/ <387,388,389>,<387,389,390>,<387,390,388>,
    /*1*/ <388,391,389>,<389,391,392>,<389,392,390>,<390,392,393>,<390,393,388>,
            <388,393,391>,
    /*2*/ <391,394,392>,<392,394,395>,<392,395,393>,<393,395,396>,<393,396,391>,
            <391,396,394>,
    /*3*/ <394,397,395>,<395,397,396>,<396,397,394>

    /* stem 0.0.9*/ 
    /*0*/ <398,399,400>,<398,400,401>,<398,401,399>,
    /*1*/ <399,402,400>,<400,402,403>,<400,403,401>,<401,403,404>,<401,404,399>,
            <399,404,402>,
    /*2*/ <402,405,403>,<403,405,406>,<403,406,404>,<404,406,407>,<404,407,402>,
            <402,407,405>,
    /*3*/ <405,408,406>,<406,408,407>,<407,408,405>

    /* stem 0.0.10*/ 
    /*0*/ <409,410,411>,<409,411,412>,<409,412,410>,
    /*1*/ <410,413,411>,<411,413,414>,<411,414,412>,<412,414,415>,<412,415,410>,
            <410,415,413>,
    /*2*/ <413,416,414>,<414,416,417>,<414,417,415>,<415,417,418>,<415,418,413>,
            <413,418,416>,
    /*3*/ <416,419,417>,<417,419,418>,<418,419,416>

    /* stem 0.0.11*/ 
    /*0*/ <420,421,422>,<420,422,423>,<420,423,421>,
    /*1*/ <421,424,422>,<422,424,425>,<422,425,423>,<423,425,426>,<423,426,421>,
            <421,426,424>,
    /*2*/ <424,427,425>,<425,427,428>,<425,428,426>,<426,428,429>,<426,429,424>,
            <424,429,427>,
    /*3*/ <427,430,428>,<428,430,429>,<429,430,427>

    /* stem 0.0.12*/ 
    /*0*/ <431,432,433>,<431,433,434>,<431,434,432>,
    /*1*/ <432,435,433>,<433,435,436>,<433,436,434>,<434,436,437>,<434,437,432>,
            <432,437,435>,
    /*2*/ <435,438,436>,<436,438,439>,<436,439,437>,<437,439,440>,<437,440,435>,
            <435,440,438>,
    /*3*/ <438,441,439>,<439,441,440>,<440,441,438>

    /* stem 0.0.13*/ 
    /*0*/ <442,443,444>,<442,444,445>,<442,445,443>,
    /*1*/ <443,446,444>,<444,446,447>,<444,447,445>,<445,447,448>,<445,448,443>,
            <443,448,446>,
    /*2*/ <446,449,447>,<447,449,450>,<447,450,448>,<448,450,451>,<448,451,446>,
            <446,451,449>,
    /*3*/ <449,452,450>,<450,452,451>,<451,452,449>

    /* stem 0.0.14*/ 
    /*0*/ <453,454,455>,<453,455,456>,<453,456,454>,
    /*1*/ <454,457,455>,<455,457,458>,<455,458,456>,<456,458,459>,<456,459,454>,
            <454,459,457>,
    /*2*/ <457,460,458>,<458,460,461>,<458,461,459>,<459,461,462>,<459,462,457>,
            <457,462,460>,
    /*3*/ <460,463,461>,<461,463,462>,<462,463,460>

    /* stem 0.0.15*/ 
    /*0*/ <464,465,466>,<464,466,467>,<464,467,465>,
    /*1*/ <465,468,466>,<466,468,469>,<466,469,467>,<467,469,470>,<467,470,465>,
            <465,470,468>,
    /*2*/ <468,471,469>,<469,471,472>,<469,472,470>,<470,472,473>,<470,473,468>,
            <468,473,471>,
    /*3*/ <471,474,472>,<472,474,473>,<473,474,471>

    /* stem 0.0.16*/ 
    /*0*/ <475,476,477>,<475,477,478>,<475,478,476>,
    /*1*/ <476,479,477>,<477,479,480>,<477,480,478>,<478,480,481>,<478,481,476>,
            <476,481,479>,
    /*2*/ <479,482,480>,<480,482,483>,<480,483,481>,<481,483,484>,<481,484,479>,
            <479,484,482>,
    /*3*/ <482,485,483>,<483,485,484>,<484,485,482>

    /* stem 0.0.17*/ 
    /*0*/ <486,487,488>,<486,488,489>,<486,489,487>,
    /*1*/ <487,490,488>,<488,490,491>,<488,491,489>,<489,491,492>,<489,492,487>,
            <487,492,490>,
    /*2*/ <490,493,491>,<491,493,494>,<491,494,492>,<492,494,495>,<492,495,490>,
            <490,495,493>,
    /*3*/ <493,496,494>,<494,496,495>,<495,496,493>

    /* stem 0.0.18*/ 
    /*0*/ <497,498,499>,<497,499,500>,<497,500,498>,
    /*1*/ <498,501,499>,<499,501,502>,<499,502,500>,<500,502,503>,<500,503,498>,
            <498,503,501>,
    /*2*/ <501,504,502>,<502,504,505>,<502,505,503>,<503,505,506>,<503,506,501>,
            <501,506,504>,
    /*3*/ <504,507,505>,<505,507,506>,<506,507,504>

    /* stem 0.0.19*/ 
    /*0*/ <508,509,510>,<508,510,511>,<508,511,509>,
    /*1*/ <509,512,510>,<510,512,513>,<510,513,511>,<511,513,514>,<511,514,509>,
            <509,514,512>,
    /*2*/ <512,515,513>,<513,515,516>,<513,516,514>,<514,516,517>,<514,517,512>,
            <512,517,515>,
    /*3*/ <515,518,516>,<516,518,517>,<517,518,515>

    /* stem 0.0.20*/ 
    /*0*/ <519,520,521>,<519,521,522>,<519,522,520>,
    /*1*/ <520,523,521>,<521,523,524>,<521,524,522>,<522,524,525>,<522,525,520>,
            <520,525,523>,
    /*2*/ <523,526,524>,<524,526,527>,<524,527,525>,<525,527,528>,<525,528,523>,
            <523,528,526>,
    /*3*/ <526,529,527>,<527,529,528>,<528,529,526>

    /* stem 0.0.21*/ 
    /*0*/ <530,531,532>,<530,532,533>,<530,533,531>,
    /*1*/ <531,534,532>,<532,534,535>,<532,535,533>,<533,535,536>,<533,536,531>,
            <531,536,534>,
    /*2*/ <534,537,535>,<535,537,538>,<535,538,536>,<536,538,539>,<536,539,534>,
            <534,539,537>,
    /*3*/ <537,540,538>,<538,540,539>,<539,540,537>

    /* stem 0.0.22*/ 
    /*0*/ <541,542,543>,<541,543,544>,<541,544,542>,
    /*1*/ <542,545,543>,<543,545,546>,<543,546,544>,<544,546,547>,<544,547,542>,
            <542,547,545>,
    /*2*/ <545,548,546>,<546,548,549>,<546,549,547>,<547,549,550>,<547,550,545>,
            <545,550,548>,
    /*3*/ <548,551,549>,<549,551,550>,<550,551,548>

    /* stem 0.0.23*/ 
    /*0*/ <552,553,554>,<552,554,555>,<552,555,553>,
    /*1*/ <553,556,554>,<554,556,557>,<554,557,555>,<555,557,558>,<555,558,553>,
            <553,558,556>,
    /*2*/ <556,559,557>,<557,559,560>,<557,560,558>,<558,560,561>,<558,561,556>,
            <556,561,559>,
    /*3*/ <559,562,560>,<560,562,561>,<561,562,559>

    /* stem 0.0.24*/ 
    /*0*/ <563,564,565>,<563,565,566>,<563,566,564>,
    /*1*/ <564,567,565>,<565,567,568>,<565,568,566>,<566,568,569>,<566,569,564>,
            <564,569,567>,
    /*2*/ <567,570,568>,<568,570,571>,<568,571,569>,<569,571,572>,<569,572,567>,
            <567,572,570>,
    /*3*/ <570,573,571>,<571,573,572>,<572,573,570>

    /* stem 0.0.25*/ 
    /*0*/ <574,575,576>,<574,576,577>,<574,577,575>,
    /*1*/ <575,578,576>,<576,578,579>,<576,579,577>,<577,579,580>,<577,580,575>,
            <575,580,578>,
    /*2*/ <578,581,579>,<579,581,582>,<579,582,580>,<580,582,583>,<580,583,578>,
            <578,583,581>,
    /*3*/ <581,584,582>,<582,584,583>,<583,584,581>

    /* stem 0.0.26*/ 
    /*0*/ <585,586,587>,<585,587,588>,<585,588,586>,
    /*1*/ <586,589,587>,<587,589,590>,<587,590,588>,<588,590,591>,<588,591,586>,
            <586,591,589>,
    /*2*/ <589,592,590>,<590,592,593>,<590,593,591>,<591,593,594>,<591,594,589>,
            <589,594,592>,
    /*3*/ <592,595,593>,<593,595,594>,<594,595,592>

    /* stem 0.0.27*/ 
    /*0*/ <596,597,598>,<596,598,599>,<596,599,597>,
    /*1*/ <597,600,598>,<598,600,601>,<598,601,599>,<599,601,602>,<599,602,597>,
            <597,602,600>,
    /*2*/ <600,603,601>,<601,603,604>,<601,604,602>,<602,604,605>,<602,605,600>,
            <600,605,603>,
    /*3*/ <603,606,604>,<604,606,605>,<605,606,603>

    /* stem 0.0.28*/ 
    /*0*/ <607,608,609>,<607,609,610>,<607,610,608>,
    /*1*/ <608,611,609>,<609,611,612>,<609,612,610>,<610,612,613>,<610,613,608>,
            <608,613,611>,
    /*2*/ <611,614,612>,<612,614,615>,<612,615,613>,<613,615,616>,<613,616,611>,
            <611,616,614>,
    /*3*/ <614,617,615>,<615,617,616>,<616,617,614>

    /* stem 0.1*/ 
    /*0*/ <618,619,620>,<618,620,621>,<618,621,622>,<618,622,623>,<618,623,619>,
            
    /*1*/ <619,624,620>,<620,624,625>,<620,625,621>,<621,625,626>,<621,626,622>,
            <622,626,627>,<622,627,623>,<623,627,628>,<623,628,619>,<619,628,624>,
    /*2*/ <624,629,625>,<625,629,630>,<625,630,626>,<626,630,631>,<626,631,627>,
            <627,631,632>,<627,632,628>,<628,632,633>,<628,633,624>,<624,633,629>,
    /*3*/ <629,634,630>,<630,634,631>,<631,634,632>,<632,634,633>,<633,634,629>
            

    /* stem 0.1.0*/ 
    /*0*/ <635,636,637>,<635,637,638>,<635,638,636>,
    /*1*/ <636,639,637>,<637,639,640>,<637,640,638>,<638,640,641>,<638,641,636>,
            <636,641,639>,
    /*2*/ <639,642,640>,<640,642,643>,<640,643,641>,<641,643,644>,<641,644,639>,
            <639,644,642>,
    /*3*/ <642,645,643>,<643,645,644>,<644,645,642>

    /* stem 0.1.1*/ 
    /*0*/ <646,647,648>,<646,648,649>,<646,649,647>,
    /*1*/ <647,650,648>,<648,650,651>,<648,651,649>,<649,651,652>,<649,652,647>,
            <647,652,650>,
    /*2*/ <650,653,651>,<651,653,654>,<651,654,652>,<652,654,655>,<652,655,650>,
            <650,655,653>,
    /*3*/ <653,656,654>,<654,656,655>,<655,656,653>

    /* stem 0.1.2*/ 
    /*0*/ <657,658,659>,<657,659,660>,<657,660,658>,
    /*1*/ <658,661,659>,<659,661,662>,<659,662,660>,<660,662,663>,<660,663,658>,
            <658,663,661>,
    /*2*/ <661,664,662>,<662,664,665>,<662,665,663>,<663,665,666>,<663,666,661>,
            <661,666,664>,
    /*3*/ <664,667,665>,<665,667,666>,<666,667,664>

    /* stem 0.1.3*/ 
    /*0*/ <668,669,670>,<668,670,671>,<668,671,669>,
    /*1*/ <669,672,670>,<670,672,673>,<670,673,671>,<671,673,674>,<671,674,669>,
            <669,674,672>,
    /*2*/ <672,675,673>,<673,675,676>,<673,676,674>,<674,676,677>,<674,677,672>,
            <672,677,675>,
    /*3*/ <675,678,676>,<676,678,677>,<677,678,675>

    /* stem 0.1.4*/ 
    /*0*/ <679,680,681>,<679,681,682>,<679,682,680>,
    /*1*/ <680,683,681>,<681,683,684>,<681,684,682>,<682,684,685>,<682,685,680>,
            <680,685,683>,
    /*2*/ <683,686,684>,<684,686,687>,<684,687,685>,<685,687,688>,<685,688,683>,
            <683,688,686>,
    /*3*/ <686,689,687>,<687,689,688>,<688,689,686>

    /* stem 0.1.5*/ 
    /*0*/ <690,691,692>,<690,692,693>,<690,693,691>,
    /*1*/ <691,694,692>,<692,694,695>,<692,695,693>,<693,695,696>,<693,696,691>,
            <691,696,694>,
    /*2*/ <694,697,695>,<695,697,698>,<695,698,696>,<696,698,699>,<696,699,694>,
            <694,699,697>,
    /*3*/ <697,700,698>,<698,700,699>,<699,700,697>

    /* stem 0.1.6*/ 
    /*0*/ <701,702,703>,<701,703,704>,<701,704,702>,
    /*1*/ <702,705,703>,<703,705,706>,<703,706,704>,<704,706,707>,<704,707,702>,
            <702,707,705>,
    /*2*/ <705,708,706>,<706,708,709>,<706,709,707>,<707,709,710>,<707,710,705>,
            <705,710,708>,
    /*3*/ <708,711,709>,<709,711,710>,<710,711,708>

    /* stem 0.1.7*/ 
    /*0*/ <712,713,714>,<712,714,715>,<712,715,713>,
    /*1*/ <713,716,714>,<714,716,717>,<714,717,715>,<715,717,718>,<715,718,713>,
            <713,718,716>,
    /*2*/ <716,719,717>,<717,719,720>,<717,720,718>,<718,720,721>,<718,721,716>,
            <716,721,719>,
    /*3*/ <719,722,720>,<720,722,721>,<721,722,719>

    /* stem 0.1.8*/ 
    /*0*/ <723,724,725>,<723,725,726>,<723,726,724>,
    /*1*/ <724,727,725>,<725,727,728>,<725,728,726>,<726,728,729>,<726,729,724>,
            <724,729,727>,
    /*2*/ <727,730,728>,<728,730,731>,<728,731,729>,<729,731,732>,<729,732,727>,
            <727,732,730>,
    /*3*/ <730,733,731>,<731,733,732>,<732,733,730>

    /* stem 0.1.9*/ 
    /*0*/ <734,735,736>,<734,736,737>,<734,737,735>,
    /*1*/ <735,738,736>,<736,738,739>,<736,739,737>,<737,739,740>,<737,740,735>,
            <735,740,738>,
    /*2*/ <738,741,739>,<739,741,742>,<739,742,740>,<740,742,743>,<740,743,738>,
            <738,743,741>,
    /*3*/ <741,744,742>,<742,744,743>,<743,744,741>

    /* stem 0.1.10*/ 
    /*0*/ <745,746,747>,<745,747,748>,<745,748,746>,
    /*1*/ <746,749,747>,<747,749,750>,<747,750,748>,<748,750,751>,<748,751,746>,
            <746,751,749>,
    /*2*/ <749,752,750>,<750,752,753>,<750,753,751>,<751,753,754>,<751,754,749>,
            <749,754,752>,
    /*3*/ <752,755,753>,<753,755,754>,<754,755,752>

    /* stem 0.1.11*/ 
    /*0*/ <756,757,758>,<756,758,759>,<756,759,757>,
    /*1*/ <757,760,758>,<758,760,761>,<758,761,759>,<759,761,762>,<759,762,757>,
            <757,762,760>,
    /*2*/ <760,763,761>,<761,763,764>,<761,764,762>,<762,764,765>,<762,765,760>,
            <760,765,763>,
    /*3*/ <763,766,764>,<764,766,765>,<765,766,763>

    /* stem 0.1.12*/ 
    /*0*/ <767,768,769>,<767,769,770>,<767,770,768>,
    /*1*/ <768,771,769>,<769,771,772>,<769,772,770>,<770,772,773>,<770,773,768>,
            <768,773,771>,
    /*2*/ <771,774,772>,<772,774,775>,<772,775,773>,<773,775,776>,<773,776,771>,
            <771,776,774>,
    /*3*/ <774,777,775>,<775,777,776>,<776,777,774>

    /* stem 0.1.13*/ 
    /*0*/ <778,779,780>,<778,780,781>,<778,781,779>,
    /*1*/ <779,782,780>,<780,782,783>,<780,783,781>,<781,783,784>,<781,784,779>,
            <779,784,782>,
    /*2*/ <782,785,783>,<783,785,786>,<783,786,784>,<784,786,787>,<784,787,782>,
            <782,787,785>,
    /*3*/ <785,788,786>,<786,788,787>,<787,788,785>

    /* stem 0.1.14*/ 
    /*0*/ <789,790,791>,<789,791,792>,<789,792,790>,
    /*1*/ <790,793,791>,<791,793,794>,<791,794,792>,<792,794,795>,<792,795,790>,
            <790,795,793>,
    /*2*/ <793,796,794>,<794,796,797>,<794,797,795>,<795,797,798>,<795,798,793>,
            <793,798,796>,
    /*3*/ <796,799,797>,<797,799,798>,<798,799,796>

    /* stem 0.1.15*/ 
    /*0*/ <800,801,802>,<800,802,803>,<800,803,801>,
    /*1*/ <801,804,802>,<802,804,805>,<802,805,803>,<803,805,806>,<803,806,801>,
            <801,806,804>,
    /*2*/ <804,807,805>,<805,807,808>,<805,808,806>,<806,808,809>,<806,809,804>,
            <804,809,807>,
    /*3*/ <807,810,808>,<808,810,809>,<809,810,807>

    /* stem 0.1.16*/ 
    /*0*/ <811,812,813>,<811,813,814>,<811,814,812>,
    /*1*/ <812,815,813>,<813,815,816>,<813,816,814>,<814,816,817>,<814,817,812>,
            <812,817,815>,
    /*2*/ <815,818,816>,<816,818,819>,<816,819,817>,<817,819,820>,<817,820,815>,
            <815,820,818>,
    /*3*/ <818,821,819>,<819,821,820>,<820,821,818>

    /* stem 0.1.17*/ 
    /*0*/ <822,823,824>,<822,824,825>,<822,825,823>,
    /*1*/ <823,826,824>,<824,826,827>,<824,827,825>,<825,827,828>,<825,828,823>,
            <823,828,826>,
    /*2*/ <826,829,827>,<827,829,830>,<827,830,828>,<828,830,831>,<828,831,826>,
            <826,831,829>,
    /*3*/ <829,832,830>,<830,832,831>,<831,832,829>

    /* stem 0.1.18*/ 
    /*0*/ <833,834,835>,<833,835,836>,<833,836,834>,
    /*1*/ <834,837,835>,<835,837,838>,<835,838,836>,<836,838,839>,<836,839,834>,
            <834,839,837>,
    /*2*/ <837,840,838>,<838,840,841>,<838,841,839>,<839,841,842>,<839,842,837>,
            <837,842,840>,
    /*3*/ <840,843,841>,<841,843,842>,<842,843,840>

    /* stem 0.1.19*/ 
    /*0*/ <844,845,846>,<844,846,847>,<844,847,845>,
    /*1*/ <845,848,846>,<846,848,849>,<846,849,847>,<847,849,850>,<847,850,845>,
            <845,850,848>,
    /*2*/ <848,851,849>,<849,851,852>,<849,852,850>,<850,852,853>,<850,853,848>,
            <848,853,851>,
    /*3*/ <851,854,852>,<852,854,853>,<853,854,851>

    /* stem 0.1.20*/ 
    /*0*/ <855,856,857>,<855,857,858>,<855,858,856>,
    /*1*/ <856,859,857>,<857,859,860>,<857,860,858>,<858,860,861>,<858,861,856>,
            <856,861,859>,
    /*2*/ <859,862,860>,<860,862,863>,<860,863,861>,<861,863,864>,<861,864,859>,
            <859,864,862>,
    /*3*/ <862,865,863>,<863,865,864>,<864,865,862>

    /* stem 0.1.21*/ 
    /*0*/ <866,867,868>,<866,868,869>,<866,869,867>,
    /*1*/ <867,870,868>,<868,870,871>,<868,871,869>,<869,871,872>,<869,872,867>,
            <867,872,870>,
    /*2*/ <870,873,871>,<871,873,874>,<871,874,872>,<872,874,875>,<872,875,870>,
            <870,875,873>,
    /*3*/ <873,876,874>,<874,876,875>,<875,876,873>

    /* stem 0.1.22*/ 
    /*0*/ <877,878,879>,<877,879,880>,<877,880,878>,
    /*1*/ <878,881,879>,<879,881,882>,<879,882,880>,<880,882,883>,<880,883,878>,
            <878,883,881>,
    /*2*/ <881,884,882>,<882,884,885>,<882,885,883>,<883,885,886>,<883,886,881>,
            <881,886,884>,
    /*3*/ <884,887,885>,<885,887,886>,<886,887,884>

    /* stem 0.1.23*/ 
    /*0*/ <888,889,890>,<888,890,891>,<888,891,889>,
    /*1*/ <889,892,890>,<890,892,893>,<890,893,891>,<891,893,894>,<891,894,889>,
            <889,894,892>,
    /*2*/ <892,895,893>,<893,895,896>,<893,896,894>,<894,896,897>,<894,897,892>,
            <892,897,895>,
    /*3*/ <895,898,896>,<896,898,897>,<897,898,895>

    /* stem 0.1.24*/ 
    /*0*/ <899,900,901>,<899,901,902>,<899,902,900>,
    /*1*/ <900,903,901>,<901,903,904>,<901,904,902>,<902,904,905>,<902,905,900>,
            <900,905,903>,
    /*2*/ <903,906,904>,<904,906,907>,<904,907,905>,<905,907,908>,<905,908,903>,
            <903,908,906>,
    /*3*/ <906,909,907>,<907,909,908>,<908,909,906>

    /* stem 0.1.25*/ 
    /*0*/ <910,911,912>,<910,912,913>,<910,913,911>,
    /*1*/ <911,914,912>,<912,914,915>,<912,915,913>,<913,915,916>,<913,916,911>,
            <911,916,914>,
    /*2*/ <914,917,915>,<915,917,918>,<915,918,916>,<916,918,919>,<916,919,914>,
            <914,919,917>,
    /*3*/ <917,920,918>,<918,920,919>,<919,920,917>

    /* stem 0.1.26*/ 
    /*0*/ <921,922,923>,<921,923,924>,<921,924,922>,
    /*1*/ <922,925,923>,<923,925,926>,<923,926,924>,<924,926,927>,<924,927,922>,
            <922,927,925>,
    /*2*/ <925,928,926>,<926,928,929>,<926,929,927>,<927,929,930>,<927,930,925>,
            <925,930,928>,
    /*3*/ <928,931,929>,<929,931,930>,<930,931,928>

    /* stem 0.1.27*/ 
    /*0*/ <932,933,934>,<932,934,935>,<932,935,933>,
    /*1*/ <933,936,934>,<934,936,937>,<934,937,935>,<935,937,938>,<935,938,933>,
            <933,938,936>,
    /*2*/ <936,939,937>,<937,939,940>,<937,940,938>,<938,940,941>,<938,941,936>,
            <936,941,939>,
    /*3*/ <939,942,940>,<940,942,941>,<941,942,939>

    /* stem 0.1.28*/ 
    /*0*/ <943,944,945>,<943,945,946>,<943,946,944>,
    /*1*/ <944,947,945>,<945,947,948>,<945,948,946>,<946,948,949>,<946,949,944>,
            <944,949,947>,
    /*2*/ <947,950,948>,<948,950,951>,<948,951,949>,<949,951,952>,<949,952,947>,
            <947,952,950>,
    /*3*/ <950,953,951>,<951,953,952>,<952,953,950>

    /* stem 0.2*/ 
    /*0*/ <954,955,956>,<954,956,957>,<954,957,958>,<954,958,959>,<954,959,955>,
            
    /*1*/ <955,960,956>,<956,960,961>,<956,961,957>,<957,961,962>,<957,962,958>,
            <958,962,963>,<958,963,959>,<959,963,964>,<959,964,955>,<955,964,960>,
    /*2*/ <960,965,961>,<961,965,966>,<961,966,962>,<962,966,967>,<962,967,963>,
            <963,967,968>,<963,968,964>,<964,968,969>,<964,969,960>,<960,969,965>,
    /*3*/ <965,970,966>,<966,970,967>,<967,970,968>,<968,970,969>,<969,970,965>
            

    /* stem 0.2.0*/ 
    /*0*/ <971,972,973>,<971,973,974>,<971,974,972>,
    /*1*/ <972,975,973>,<973,975,976>,<973,976,974>,<974,976,977>,<974,977,972>,
            <972,977,975>,
    /*2*/ <975,978,976>,<976,978,979>,<976,979,977>,<977,979,980>,<977,980,975>,
            <975,980,978>,
    /*3*/ <978,981,979>,<979,981,980>,<980,981,978>

    /* stem 0.2.1*/ 
    /*0*/ <982,983,984>,<982,984,985>,<982,985,983>,
    /*1*/ <983,986,984>,<984,986,987>,<984,987,985>,<985,987,988>,<985,988,983>,
            <983,988,986>,
    /*2*/ <986,989,987>,<987,989,990>,<987,990,988>,<988,990,991>,<988,991,986>,
            <986,991,989>,
    /*3*/ <989,992,990>,<990,992,991>,<991,992,989>

    /* stem 0.2.2*/ 
    /*0*/ <993,994,995>,<993,995,996>,<993,996,994>,
    /*1*/ <994,997,995>,<995,997,998>,<995,998,996>,<996,998,999>,<996,999,994>,
            <994,999,997>,
    /*2*/ <997,1000,998>,<998,1000,1001>,<998,1001,999>,<999,1001,1002>,<999,1002,997>,
            <997,1002,1000>,
    /*3*/ <1000,1003,1001>,<1001,1003,1002>,<1002,1003,1000>

    /* stem 0.2.3*/ 
    /*0*/ <1004,1005,1006>,<1004,1006,1007>,<1004,1007,1005>,
    /*1*/ <1005,1008,1006>,<1006,1008,1009>,<1006,1009,1007>,<1007,1009,1010>,<1007,1010,1005>,
            <1005,1010,1008>,
    /*2*/ <1008,1011,1009>,<1009,1011,1012>,<1009,1012,1010>,<1010,1012,1013>,<1010,1013,1008>,
            <1008,1013,1011>,
    /*3*/ <1011,1014,1012>,<1012,1014,1013>,<1013,1014,1011>

    /* stem 0.2.4*/ 
    /*0*/ <1015,1016,1017>,<1015,1017,1018>,<1015,1018,1016>,
    /*1*/ <1016,1019,1017>,<1017,1019,1020>,<1017,1020,1018>,<1018,1020,1021>,<1018,1021,1016>,
            <1016,1021,1019>,
    /*2*/ <1019,1022,1020>,<1020,1022,1023>,<1020,1023,1021>,<1021,1023,1024>,<1021,1024,1019>,
            <1019,1024,1022>,
    /*3*/ <1022,1025,1023>,<1023,1025,1024>,<1024,1025,1022>

    /* stem 0.2.5*/ 
    /*0*/ <1026,1027,1028>,<1026,1028,1029>,<1026,1029,1027>,
    /*1*/ <1027,1030,1028>,<1028,1030,1031>,<1028,1031,1029>,<1029,1031,1032>,<1029,1032,1027>,
            <1027,1032,1030>,
    /*2*/ <1030,1033,1031>,<1031,1033,1034>,<1031,1034,1032>,<1032,1034,1035>,<1032,1035,1030>,
            <1030,1035,1033>,
    /*3*/ <1033,1036,1034>,<1034,1036,1035>,<1035,1036,1033>

    /* stem 0.2.6*/ 
    /*0*/ <1037,1038,1039>,<1037,1039,1040>,<1037,1040,1038>,
    /*1*/ <1038,1041,1039>,<1039,1041,1042>,<1039,1042,1040>,<1040,1042,1043>,<1040,1043,1038>,
            <1038,1043,1041>,
    /*2*/ <1041,1044,1042>,<1042,1044,1045>,<1042,1045,1043>,<1043,1045,1046>,<1043,1046,1041>,
            <1041,1046,1044>,
    /*3*/ <1044,1047,1045>,<1045,1047,1046>,<1046,1047,1044>

    /* stem 0.2.7*/ 
    /*0*/ <1048,1049,1050>,<1048,1050,1051>,<1048,1051,1049>,
    /*1*/ <1049,1052,1050>,<1050,1052,1053>,<1050,1053,1051>,<1051,1053,1054>,<1051,1054,1049>,
            <1049,1054,1052>,
    /*2*/ <1052,1055,1053>,<1053,1055,1056>,<1053,1056,1054>,<1054,1056,1057>,<1054,1057,1052>,
            <1052,1057,1055>,
    /*3*/ <1055,1058,1056>,<1056,1058,1057>,<1057,1058,1055>

    /* stem 0.2.8*/ 
    /*0*/ <1059,1060,1061>,<1059,1061,1062>,<1059,1062,1060>,
    /*1*/ <1060,1063,1061>,<1061,1063,1064>,<1061,1064,1062>,<1062,1064,1065>,<1062,1065,1060>,
            <1060,1065,1063>,
    /*2*/ <1063,1066,1064>,<1064,1066,1067>,<1064,1067,1065>,<1065,1067,1068>,<1065,1068,1063>,
            <1063,1068,1066>,
    /*3*/ <1066,1069,1067>,<1067,1069,1068>,<1068,1069,1066>

    /* stem 0.2.9*/ 
    /*0*/ <1070,1071,1072>,<1070,1072,1073>,<1070,1073,1071>,
    /*1*/ <1071,1074,1072>,<1072,1074,1075>,<1072,1075,1073>,<1073,1075,1076>,<1073,1076,1071>,
            <1071,1076,1074>,
    /*2*/ <1074,1077,1075>,<1075,1077,1078>,<1075,1078,1076>,<1076,1078,1079>,<1076,1079,1074>,
            <1074,1079,1077>,
    /*3*/ <1077,1080,1078>,<1078,1080,1079>,<1079,1080,1077>

    /* stem 0.2.10*/ 
    /*0*/ <1081,1082,1083>,<1081,1083,1084>,<1081,1084,1082>,
    /*1*/ <1082,1085,1083>,<1083,1085,1086>,<1083,1086,1084>,<1084,1086,1087>,<1084,1087,1082>,
            <1082,1087,1085>,
    /*2*/ <1085,1088,1086>,<1086,1088,1089>,<1086,1089,1087>,<1087,1089,1090>,<1087,1090,1085>,
            <1085,1090,1088>,
    /*3*/ <1088,1091,1089>,<1089,1091,1090>,<1090,1091,1088>

    /* stem 0.2.11*/ 
    /*0*/ <1092,1093,1094>,<1092,1094,1095>,<1092,1095,1093>,
    /*1*/ <1093,1096,1094>,<1094,1096,1097>,<1094,1097,1095>,<1095,1097,1098>,<1095,1098,1093>,
            <1093,1098,1096>,
    /*2*/ <1096,1099,1097>,<1097,1099,1100>,<1097,1100,1098>,<1098,1100,1101>,<1098,1101,1096>,
            <1096,1101,1099>,
    /*3*/ <1099,1102,1100>,<1100,1102,1101>,<1101,1102,1099>

    /* stem 0.2.12*/ 
    /*0*/ <1103,1104,1105>,<1103,1105,1106>,<1103,1106,1104>,
    /*1*/ <1104,1107,1105>,<1105,1107,1108>,<1105,1108,1106>,<1106,1108,1109>,<1106,1109,1104>,
            <1104,1109,1107>,
    /*2*/ <1107,1110,1108>,<1108,1110,1111>,<1108,1111,1109>,<1109,1111,1112>,<1109,1112,1107>,
            <1107,1112,1110>,
    /*3*/ <1110,1113,1111>,<1111,1113,1112>,<1112,1113,1110>

    /* stem 0.2.13*/ 
    /*0*/ <1114,1115,1116>,<1114,1116,1117>,<1114,1117,1115>,
    /*1*/ <1115,1118,1116>,<1116,1118,1119>,<1116,1119,1117>,<1117,1119,1120>,<1117,1120,1115>,
            <1115,1120,1118>,
    /*2*/ <1118,1121,1119>,<1119,1121,1122>,<1119,1122,1120>,<1120,1122,1123>,<1120,1123,1118>,
            <1118,1123,1121>,
    /*3*/ <1121,1124,1122>,<1122,1124,1123>,<1123,1124,1121>

    /* stem 0.2.14*/ 
    /*0*/ <1125,1126,1127>,<1125,1127,1128>,<1125,1128,1126>,
    /*1*/ <1126,1129,1127>,<1127,1129,1130>,<1127,1130,1128>,<1128,1130,1131>,<1128,1131,1126>,
            <1126,1131,1129>,
    /*2*/ <1129,1132,1130>,<1130,1132,1133>,<1130,1133,1131>,<1131,1133,1134>,<1131,1134,1129>,
            <1129,1134,1132>,
    /*3*/ <1132,1135,1133>,<1133,1135,1134>,<1134,1135,1132>

    /* stem 0.2.15*/ 
    /*0*/ <1136,1137,1138>,<1136,1138,1139>,<1136,1139,1137>,
    /*1*/ <1137,1140,1138>,<1138,1140,1141>,<1138,1141,1139>,<1139,1141,1142>,<1139,1142,1137>,
            <1137,1142,1140>,
    /*2*/ <1140,1143,1141>,<1141,1143,1144>,<1141,1144,1142>,<1142,1144,1145>,<1142,1145,1140>,
            <1140,1145,1143>,
    /*3*/ <1143,1146,1144>,<1144,1146,1145>,<1145,1146,1143>

    /* stem 0.2.16*/ 
    /*0*/ <1147,1148,1149>,<1147,1149,1150>,<1147,1150,1148>,
    /*1*/ <1148,1151,1149>,<1149,1151,1152>,<1149,1152,1150>,<1150,1152,1153>,<1150,1153,1148>,
            <1148,1153,1151>,
    /*2*/ <1151,1154,1152>,<1152,1154,1155>,<1152,1155,1153>,<1153,1155,1156>,<1153,1156,1151>,
            <1151,1156,1154>,
    /*3*/ <1154,1157,1155>,<1155,1157,1156>,<1156,1157,1154>

    /* stem 0.2.17*/ 
    /*0*/ <1158,1159,1160>,<1158,1160,1161>,<1158,1161,1159>,
    /*1*/ <1159,1162,1160>,<1160,1162,1163>,<1160,1163,1161>,<1161,1163,1164>,<1161,1164,1159>,
            <1159,1164,1162>,
    /*2*/ <1162,1165,1163>,<1163,1165,1166>,<1163,1166,1164>,<1164,1166,1167>,<1164,1167,1162>,
            <1162,1167,1165>,
    /*3*/ <1165,1168,1166>,<1166,1168,1167>,<1167,1168,1165>

    /* stem 0.2.18*/ 
    /*0*/ <1169,1170,1171>,<1169,1171,1172>,<1169,1172,1170>,
    /*1*/ <1170,1173,1171>,<1171,1173,1174>,<1171,1174,1172>,<1172,1174,1175>,<1172,1175,1170>,
            <1170,1175,1173>,
    /*2*/ <1173,1176,1174>,<1174,1176,1177>,<1174,1177,1175>,<1175,1177,1178>,<1175,1178,1173>,
            <1173,1178,1176>,
    /*3*/ <1176,1179,1177>,<1177,1179,1178>,<1178,1179,1176>

    /* stem 0.2.19*/ 
    /*0*/ <1180,1181,1182>,<1180,1182,1183>,<1180,1183,1181>,
    /*1*/ <1181,1184,1182>,<1182,1184,1185>,<1182,1185,1183>,<1183,1185,1186>,<1183,1186,1181>,
            <1181,1186,1184>,
    /*2*/ <1184,1187,1185>,<1185,1187,1188>,<1185,1188,1186>,<1186,1188,1189>,<1186,1189,1184>,
            <1184,1189,1187>,
    /*3*/ <1187,1190,1188>,<1188,1190,1189>,<1189,1190,1187>

    /* stem 0.2.20*/ 
    /*0*/ <1191,1192,1193>,<1191,1193,1194>,<1191,1194,1192>,
    /*1*/ <1192,1195,1193>,<1193,1195,1196>,<1193,1196,1194>,<1194,1196,1197>,<1194,1197,1192>,
            <1192,1197,1195>,
    /*2*/ <1195,1198,1196>,<1196,1198,1199>,<1196,1199,1197>,<1197,1199,1200>,<1197,1200,1195>,
            <1195,1200,1198>,
    /*3*/ <1198,1201,1199>,<1199,1201,1200>,<1200,1201,1198>

    /* stem 0.2.21*/ 
    /*0*/ <1202,1203,1204>,<1202,1204,1205>,<1202,1205,1203>,
    /*1*/ <1203,1206,1204>,<1204,1206,1207>,<1204,1207,1205>,<1205,1207,1208>,<1205,1208,1203>,
            <1203,1208,1206>,
    /*2*/ <1206,1209,1207>,<1207,1209,1210>,<1207,1210,1208>,<1208,1210,1211>,<1208,1211,1206>,
            <1206,1211,1209>,
    /*3*/ <1209,1212,1210>,<1210,1212,1211>,<1211,1212,1209>

    /* stem 0.2.22*/ 
    /*0*/ <1213,1214,1215>,<1213,1215,1216>,<1213,1216,1214>,
    /*1*/ <1214,1217,1215>,<1215,1217,1218>,<1215,1218,1216>,<1216,1218,1219>,<1216,1219,1214>,
            <1214,1219,1217>,
    /*2*/ <1217,1220,1218>,<1218,1220,1221>,<1218,1221,1219>,<1219,1221,1222>,<1219,1222,1217>,
            <1217,1222,1220>,
    /*3*/ <1220,1223,1221>,<1221,1223,1222>,<1222,1223,1220>

    /* stem 0.2.23*/ 
    /*0*/ <1224,1225,1226>,<1224,1226,1227>,<1224,1227,1225>,
    /*1*/ <1225,1228,1226>,<1226,1228,1229>,<1226,1229,1227>,<1227,1229,1230>,<1227,1230,1225>,
            <1225,1230,1228>,
    /*2*/ <1228,1231,1229>,<1229,1231,1232>,<1229,1232,1230>,<1230,1232,1233>,<1230,1233,1228>,
            <1228,1233,1231>,
    /*3*/ <1231,1234,1232>,<1232,1234,1233>,<1233,1234,1231>

    /* stem 0.2.24*/ 
    /*0*/ <1235,1236,1237>,<1235,1237,1238>,<1235,1238,1236>,
    /*1*/ <1236,1239,1237>,<1237,1239,1240>,<1237,1240,1238>,<1238,1240,1241>,<1238,1241,1236>,
            <1236,1241,1239>,
    /*2*/ <1239,1242,1240>,<1240,1242,1243>,<1240,1243,1241>,<1241,1243,1244>,<1241,1244,1239>,
            <1239,1244,1242>,
    /*3*/ <1242,1245,1243>,<1243,1245,1244>,<1244,1245,1242>

    /* stem 0.2.25*/ 
    /*0*/ <1246,1247,1248>,<1246,1248,1249>,<1246,1249,1247>,
    /*1*/ <1247,1250,1248>,<1248,1250,1251>,<1248,1251,1249>,<1249,1251,1252>,<1249,1252,1247>,
            <1247,1252,1250>,
    /*2*/ <1250,1253,1251>,<1251,1253,1254>,<1251,1254,1252>,<1252,1254,1255>,<1252,1255,1250>,
            <1250,1255,1253>,
    /*3*/ <1253,1256,1254>,<1254,1256,1255>,<1255,1256,1253>

    /* stem 0.2.26*/ 
    /*0*/ <1257,1258,1259>,<1257,1259,1260>,<1257,1260,1258>,
    /*1*/ <1258,1261,1259>,<1259,1261,1262>,<1259,1262,1260>,<1260,1262,1263>,<1260,1263,1258>,
            <1258,1263,1261>,
    /*2*/ <1261,1264,1262>,<1262,1264,1265>,<1262,1265,1263>,<1263,1265,1266>,<1263,1266,1261>,
            <1261,1266,1264>,
    /*3*/ <1264,1267,1265>,<1265,1267,1266>,<1266,1267,1264>

    /* stem 0.2.27*/ 
    /*0*/ <1268,1269,1270>,<1268,1270,1271>,<1268,1271,1269>,
    /*1*/ <1269,1272,1270>,<1270,1272,1273>,<1270,1273,1271>,<1271,1273,1274>,<1271,1274,1269>,
            <1269,1274,1272>,
    /*2*/ <1272,1275,1273>,<1273,1275,1276>,<1273,1276,1274>,<1274,1276,1277>,<1274,1277,1272>,
            <1272,1277,1275>,
    /*3*/ <1275,1278,1276>,<1276,1278,1277>,<1277,1278,1275>

    /* stem 0.2.28*/ 
    /*0*/ <1279,1280,1281>,<1279,1281,1282>,<1279,1282,1280>,
    /*1*/ <1280,1283,1281>,<1281,1283,1284>,<1281,1284,1282>,<1282,1284,1285>,<1282,1285,1280>,
            <1280,1285,1283>,
    /*2*/ <1283,1286,1284>,<1284,1286,1287>,<1284,1287,1285>,<1285,1287,1288>,<1285,1288,1283>,
            <1283,1288,1286>,
    /*3*/ <1286,1289,1287>,<1287,1289,1288>,<1288,1289,1286>

    /* stem 0.3*/ 
    /*0*/ <1290,1291,1292>,<1290,1292,1293>,<1290,1293,1294>,<1290,1294,1295>,<1290,1295,1291>,
            
    /*1*/ <1291,1296,1292>,<1292,1296,1297>,<1292,1297,1293>,<1293,1297,1298>,<1293,1298,1294>,
            <1294,1298,1299>,<1294,1299,1295>,<1295,1299,1300>,<1295,1300,1291>,<1291,1300,1296>,
    /*2*/ <1296,1301,1297>,<1297,1301,1302>,<1297,1302,1298>,<1298,1302,1303>,<1298,1303,1299>,
            <1299,1303,1304>,<1299,1304,1300>,<1300,1304,1305>,<1300,1305,1296>,<1296,1305,1301>,
    /*3*/ <1301,1306,1302>,<1302,1306,1303>,<1303,1306,1304>,<1304,1306,1305>,<1305,1306,1301>
            

    /* stem 0.3.0*/ 
    /*0*/ <1307,1308,1309>,<1307,1309,1310>,<1307,1310,1308>,
    /*1*/ <1308,1311,1309>,<1309,1311,1312>,<1309,1312,1310>,<1310,1312,1313>,<1310,1313,1308>,
            <1308,1313,1311>,
    /*2*/ <1311,1314,1312>,<1312,1314,1315>,<1312,1315,1313>,<1313,1315,1316>,<1313,1316,1311>,
            <1311,1316,1314>,
    /*3*/ <1314,1317,1315>,<1315,1317,1316>,<1316,1317,1314>

    /* stem 0.3.1*/ 
    /*0*/ <1318,1319,1320>,<1318,1320,1321>,<1318,1321,1319>,
    /*1*/ <1319,1322,1320>,<1320,1322,1323>,<1320,1323,1321>,<1321,1323,1324>,<1321,1324,1319>,
            <1319,1324,1322>,
    /*2*/ <1322,1325,1323>,<1323,1325,1326>,<1323,1326,1324>,<1324,1326,1327>,<1324,1327,1322>,
            <1322,1327,1325>,
    /*3*/ <1325,1328,1326>,<1326,1328,1327>,<1327,1328,1325>

    /* stem 0.3.2*/ 
    /*0*/ <1329,1330,1331>,<1329,1331,1332>,<1329,1332,1330>,
    /*1*/ <1330,1333,1331>,<1331,1333,1334>,<1331,1334,1332>,<1332,1334,1335>,<1332,1335,1330>,
            <1330,1335,1333>,
    /*2*/ <1333,1336,1334>,<1334,1336,1337>,<1334,1337,1335>,<1335,1337,1338>,<1335,1338,1333>,
            <1333,1338,1336>,
    /*3*/ <1336,1339,1337>,<1337,1339,1338>,<1338,1339,1336>

    /* stem 0.3.3*/ 
    /*0*/ <1340,1341,1342>,<1340,1342,1343>,<1340,1343,1341>,
    /*1*/ <1341,1344,1342>,<1342,1344,1345>,<1342,1345,1343>,<1343,1345,1346>,<1343,1346,1341>,
            <1341,1346,1344>,
    /*2*/ <1344,1347,1345>,<1345,1347,1348>,<1345,1348,1346>,<1346,1348,1349>,<1346,1349,1344>,
            <1344,1349,1347>,
    /*3*/ <1347,1350,1348>,<1348,1350,1349>,<1349,1350,1347>

    /* stem 0.3.4*/ 
    /*0*/ <1351,1352,1353>,<1351,1353,1354>,<1351,1354,1352>,
    /*1*/ <1352,1355,1353>,<1353,1355,1356>,<1353,1356,1354>,<1354,1356,1357>,<1354,1357,1352>,
            <1352,1357,1355>,
    /*2*/ <1355,1358,1356>,<1356,1358,1359>,<1356,1359,1357>,<1357,1359,1360>,<1357,1360,1355>,
            <1355,1360,1358>,
    /*3*/ <1358,1361,1359>,<1359,1361,1360>,<1360,1361,1358>

    /* stem 0.3.5*/ 
    /*0*/ <1362,1363,1364>,<1362,1364,1365>,<1362,1365,1363>,
    /*1*/ <1363,1366,1364>,<1364,1366,1367>,<1364,1367,1365>,<1365,1367,1368>,<1365,1368,1363>,
            <1363,1368,1366>,
    /*2*/ <1366,1369,1367>,<1367,1369,1370>,<1367,1370,1368>,<1368,1370,1371>,<1368,1371,1366>,
            <1366,1371,1369>,
    /*3*/ <1369,1372,1370>,<1370,1372,1371>,<1371,1372,1369>

    /* stem 0.3.6*/ 
    /*0*/ <1373,1374,1375>,<1373,1375,1376>,<1373,1376,1374>,
    /*1*/ <1374,1377,1375>,<1375,1377,1378>,<1375,1378,1376>,<1376,1378,1379>,<1376,1379,1374>,
            <1374,1379,1377>,
    /*2*/ <1377,1380,1378>,<1378,1380,1381>,<1378,1381,1379>,<1379,1381,1382>,<1379,1382,1377>,
            <1377,1382,1380>,
    /*3*/ <1380,1383,1381>,<1381,1383,1382>,<1382,1383,1380>

    /* stem 0.3.7*/ 
    /*0*/ <1384,1385,1386>,<1384,1386,1387>,<1384,1387,1385>,
    /*1*/ <1385,1388,1386>,<1386,1388,1389>,<1386,1389,1387>,<1387,1389,1390>,<1387,1390,1385>,
            <1385,1390,1388>,
    /*2*/ <1388,1391,1389>,<1389,1391,1392>,<1389,1392,1390>,<1390,1392,1393>,<1390,1393,1388>,
            <1388,1393,1391>,
    /*3*/ <1391,1394,1392>,<1392,1394,1393>,<1393,1394,1391>

    /* stem 0.3.8*/ 
    /*0*/ <1395,1396,1397>,<1395,1397,1398>,<1395,1398,1396>,
    /*1*/ <1396,1399,1397>,<1397,1399,1400>,<1397,1400,1398>,<1398,1400,1401>,<1398,1401,1396>,
            <1396,1401,1399>,
    /*2*/ <1399,1402,1400>,<1400,1402,1403>,<1400,1403,1401>,<1401,1403,1404>,<1401,1404,1399>,
            <1399,1404,1402>,
    /*3*/ <1402,1405,1403>,<1403,1405,1404>,<1404,1405,1402>

    /* stem 0.3.9*/ 
    /*0*/ <1406,1407,1408>,<1406,1408,1409>,<1406,1409,1407>,
    /*1*/ <1407,1410,1408>,<1408,1410,1411>,<1408,1411,1409>,<1409,1411,1412>,<1409,1412,1407>,
            <1407,1412,1410>,
    /*2*/ <1410,1413,1411>,<1411,1413,1414>,<1411,1414,1412>,<1412,1414,1415>,<1412,1415,1410>,
            <1410,1415,1413>,
    /*3*/ <1413,1416,1414>,<1414,1416,1415>,<1415,1416,1413>

    /* stem 0.3.10*/ 
    /*0*/ <1417,1418,1419>,<1417,1419,1420>,<1417,1420,1418>,
    /*1*/ <1418,1421,1419>,<1419,1421,1422>,<1419,1422,1420>,<1420,1422,1423>,<1420,1423,1418>,
            <1418,1423,1421>,
    /*2*/ <1421,1424,1422>,<1422,1424,1425>,<1422,1425,1423>,<1423,1425,1426>,<1423,1426,1421>,
            <1421,1426,1424>,
    /*3*/ <1424,1427,1425>,<1425,1427,1426>,<1426,1427,1424>

    /* stem 0.3.11*/ 
    /*0*/ <1428,1429,1430>,<1428,1430,1431>,<1428,1431,1429>,
    /*1*/ <1429,1432,1430>,<1430,1432,1433>,<1430,1433,1431>,<1431,1433,1434>,<1431,1434,1429>,
            <1429,1434,1432>,
    /*2*/ <1432,1435,1433>,<1433,1435,1436>,<1433,1436,1434>,<1434,1436,1437>,<1434,1437,1432>,
            <1432,1437,1435>,
    /*3*/ <1435,1438,1436>,<1436,1438,1437>,<1437,1438,1435>

    /* stem 0.3.12*/ 
    /*0*/ <1439,1440,1441>,<1439,1441,1442>,<1439,1442,1440>,
    /*1*/ <1440,1443,1441>,<1441,1443,1444>,<1441,1444,1442>,<1442,1444,1445>,<1442,1445,1440>,
            <1440,1445,1443>,
    /*2*/ <1443,1446,1444>,<1444,1446,1447>,<1444,1447,1445>,<1445,1447,1448>,<1445,1448,1443>,
            <1443,1448,1446>,
    /*3*/ <1446,1449,1447>,<1447,1449,1448>,<1448,1449,1446>

    /* stem 0.3.13*/ 
    /*0*/ <1450,1451,1452>,<1450,1452,1453>,<1450,1453,1451>,
    /*1*/ <1451,1454,1452>,<1452,1454,1455>,<1452,1455,1453>,<1453,1455,1456>,<1453,1456,1451>,
            <1451,1456,1454>,
    /*2*/ <1454,1457,1455>,<1455,1457,1458>,<1455,1458,1456>,<1456,1458,1459>,<1456,1459,1454>,
            <1454,1459,1457>,
    /*3*/ <1457,1460,1458>,<1458,1460,1459>,<1459,1460,1457>

    /* stem 0.3.14*/ 
    /*0*/ <1461,1462,1463>,<1461,1463,1464>,<1461,1464,1462>,
    /*1*/ <1462,1465,1463>,<1463,1465,1466>,<1463,1466,1464>,<1464,1466,1467>,<1464,1467,1462>,
            <1462,1467,1465>,
    /*2*/ <1465,1468,1466>,<1466,1468,1469>,<1466,1469,1467>,<1467,1469,1470>,<1467,1470,1465>,
            <1465,1470,1468>,
    /*3*/ <1468,1471,1469>,<1469,1471,1470>,<1470,1471,1468>

    /* stem 0.3.15*/ 
    /*0*/ <1472,1473,1474>,<1472,1474,1475>,<1472,1475,1473>,
    /*1*/ <1473,1476,1474>,<1474,1476,1477>,<1474,1477,1475>,<1475,1477,1478>,<1475,1478,1473>,
            <1473,1478,1476>,
    /*2*/ <1476,1479,1477>,<1477,1479,1480>,<1477,1480,1478>,<1478,1480,1481>,<1478,1481,1476>,
            <1476,1481,1479>,
    /*3*/ <1479,1482,1480>,<1480,1482,1481>,<1481,1482,1479>

    /* stem 0.3.16*/ 
    /*0*/ <1483,1484,1485>,<1483,1485,1486>,<1483,1486,1484>,
    /*1*/ <1484,1487,1485>,<1485,1487,1488>,<1485,1488,1486>,<1486,1488,1489>,<1486,1489,1484>,
            <1484,1489,1487>,
    /*2*/ <1487,1490,1488>,<1488,1490,1491>,<1488,1491,1489>,<1489,1491,1492>,<1489,1492,1487>,
            <1487,1492,1490>,
    /*3*/ <1490,1493,1491>,<1491,1493,1492>,<1492,1493,1490>

    /* stem 0.3.17*/ 
    /*0*/ <1494,1495,1496>,<1494,1496,1497>,<1494,1497,1495>,
    /*1*/ <1495,1498,1496>,<1496,1498,1499>,<1496,1499,1497>,<1497,1499,1500>,<1497,1500,1495>,
            <1495,1500,1498>,
    /*2*/ <1498,1501,1499>,<1499,1501,1502>,<1499,1502,1500>,<1500,1502,1503>,<1500,1503,1498>,
            <1498,1503,1501>,
    /*3*/ <1501,1504,1502>,<1502,1504,1503>,<1503,1504,1501>

    /* stem 0.3.18*/ 
    /*0*/ <1505,1506,1507>,<1505,1507,1508>,<1505,1508,1506>,
    /*1*/ <1506,1509,1507>,<1507,1509,1510>,<1507,1510,1508>,<1508,1510,1511>,<1508,1511,1506>,
            <1506,1511,1509>,
    /*2*/ <1509,1512,1510>,<1510,1512,1513>,<1510,1513,1511>,<1511,1513,1514>,<1511,1514,1509>,
            <1509,1514,1512>,
    /*3*/ <1512,1515,1513>,<1513,1515,1514>,<1514,1515,1512>

    /* stem 0.3.19*/ 
    /*0*/ <1516,1517,1518>,<1516,1518,1519>,<1516,1519,1517>,
    /*1*/ <1517,1520,1518>,<1518,1520,1521>,<1518,1521,1519>,<1519,1521,1522>,<1519,1522,1517>,
            <1517,1522,1520>,
    /*2*/ <1520,1523,1521>,<1521,1523,1524>,<1521,1524,1522>,<1522,1524,1525>,<1522,1525,1520>,
            <1520,1525,1523>,
    /*3*/ <1523,1526,1524>,<1524,1526,1525>,<1525,1526,1523>

    /* stem 0.3.20*/ 
    /*0*/ <1527,1528,1529>,<1527,1529,1530>,<1527,1530,1528>,
    /*1*/ <1528,1531,1529>,<1529,1531,1532>,<1529,1532,1530>,<1530,1532,1533>,<1530,1533,1528>,
            <1528,1533,1531>,
    /*2*/ <1531,1534,1532>,<1532,1534,1535>,<1532,1535,1533>,<1533,1535,1536>,<1533,1536,1531>,
            <1531,1536,1534>,
    /*3*/ <1534,1537,1535>,<1535,1537,1536>,<1536,1537,1534>

    /* stem 0.3.21*/ 
    /*0*/ <1538,1539,1540>,<1538,1540,1541>,<1538,1541,1539>,
    /*1*/ <1539,1542,1540>,<1540,1542,1543>,<1540,1543,1541>,<1541,1543,1544>,<1541,1544,1539>,
            <1539,1544,1542>,
    /*2*/ <1542,1545,1543>,<1543,1545,1546>,<1543,1546,1544>,<1544,1546,1547>,<1544,1547,1542>,
            <1542,1547,1545>,
    /*3*/ <1545,1548,1546>,<1546,1548,1547>,<1547,1548,1545>

    /* stem 0.3.22*/ 
    /*0*/ <1549,1550,1551>,<1549,1551,1552>,<1549,1552,1550>,
    /*1*/ <1550,1553,1551>,<1551,1553,1554>,<1551,1554,1552>,<1552,1554,1555>,<1552,1555,1550>,
            <1550,1555,1553>,
    /*2*/ <1553,1556,1554>,<1554,1556,1557>,<1554,1557,1555>,<1555,1557,1558>,<1555,1558,1553>,
            <1553,1558,1556>,
    /*3*/ <1556,1559,1557>,<1557,1559,1558>,<1558,1559,1556>

    /* stem 0.3.23*/ 
    /*0*/ <1560,1561,1562>,<1560,1562,1563>,<1560,1563,1561>,
    /*1*/ <1561,1564,1562>,<1562,1564,1565>,<1562,1565,1563>,<1563,1565,1566>,<1563,1566,1561>,
            <1561,1566,1564>,
    /*2*/ <1564,1567,1565>,<1565,1567,1568>,<1565,1568,1566>,<1566,1568,1569>,<1566,1569,1564>,
            <1564,1569,1567>,
    /*3*/ <1567,1570,1568>,<1568,1570,1569>,<1569,1570,1567>

    /* stem 0.3.24*/ 
    /*0*/ <1571,1572,1573>,<1571,1573,1574>,<1571,1574,1572>,
    /*1*/ <1572,1575,1573>,<1573,1575,1576>,<1573,1576,1574>,<1574,1576,1577>,<1574,1577,1572>,
            <1572,1577,1575>,
    /*2*/ <1575,1578,1576>,<1576,1578,1579>,<1576,1579,1577>,<1577,1579,1580>,<1577,1580,1575>,
            <1575,1580,1578>,
    /*3*/ <1578,1581,1579>,<1579,1581,1580>,<1580,1581,1578>

    /* stem 0.3.25*/ 
    /*0*/ <1582,1583,1584>,<1582,1584,1585>,<1582,1585,1583>,
    /*1*/ <1583,1586,1584>,<1584,1586,1587>,<1584,1587,1585>,<1585,1587,1588>,<1585,1588,1583>,
            <1583,1588,1586>,
    /*2*/ <1586,1589,1587>,<1587,1589,1590>,<1587,1590,1588>,<1588,1590,1591>,<1588,1591,1586>,
            <1586,1591,1589>,
    /*3*/ <1589,1592,1590>,<1590,1592,1591>,<1591,1592,1589>

    /* stem 0.3.26*/ 
    /*0*/ <1593,1594,1595>,<1593,1595,1596>,<1593,1596,1594>,
    /*1*/ <1594,1597,1595>,<1595,1597,1598>,<1595,1598,1596>,<1596,1598,1599>,<1596,1599,1594>,
            <1594,1599,1597>,
    /*2*/ <1597,1600,1598>,<1598,1600,1601>,<1598,1601,1599>,<1599,1601,1602>,<1599,1602,1597>,
            <1597,1602,1600>,
    /*3*/ <1600,1603,1601>,<1601,1603,1602>,<1602,1603,1600>

    /* stem 0.3.27*/ 
    /*0*/ <1604,1605,1606>,<1604,1606,1607>,<1604,1607,1605>,
    /*1*/ <1605,1608,1606>,<1606,1608,1609>,<1606,1609,1607>,<1607,1609,1610>,<1607,1610,1605>,
            <1605,1610,1608>,
    /*2*/ <1608,1611,1609>,<1609,1611,1612>,<1609,1612,1610>,<1610,1612,1613>,<1610,1613,1608>,
            <1608,1613,1611>,
    /*3*/ <1611,1614,1612>,<1612,1614,1613>,<1613,1614,1611>

    /* stem 0.3.28*/ 
    /*0*/ <1615,1616,1617>,<1615,1617,1618>,<1615,1618,1616>,
    /*1*/ <1616,1619,1617>,<1617,1619,1620>,<1617,1620,1618>,<1618,1620,1621>,<1618,1621,1616>,
            <1616,1621,1619>,
    /*2*/ <1619,1622,1620>,<1620,1622,1623>,<1620,1623,1621>,<1621,1623,1624>,<1621,1624,1619>,
            <1619,1624,1622>,
    /*3*/ <1622,1625,1623>,<1623,1625,1624>,<1624,1625,1622>

    /* stem 0.4*/ 
    /*0*/ <1626,1627,1628>,<1626,1628,1629>,<1626,1629,1630>,<1626,1630,1631>,<1626,1631,1627>,
            
    /*1*/ <1627,1632,1628>,<1628,1632,1633>,<1628,1633,1629>,<1629,1633,1634>,<1629,1634,1630>,
            <1630,1634,1635>,<1630,1635,1631>,<1631,1635,1636>,<1631,1636,1627>,<1627,1636,1632>,
    /*2*/ <1632,1637,1633>,<1633,1637,1638>,<1633,1638,1634>,<1634,1638,1639>,<1634,1639,1635>,
            <1635,1639,1640>,<1635,1640,1636>,<1636,1640,1641>,<1636,1641,1632>,<1632,1641,1637>,
    /*3*/ <1637,1642,1638>,<1638,1642,1639>,<1639,1642,1640>,<1640,1642,1641>,<1641,1642,1637>
            

    /* stem 0.4.0*/ 
    /*0*/ <1643,1644,1645>,<1643,1645,1646>,<1643,1646,1644>,
    /*1*/ <1644,1647,1645>,<1645,1647,1648>,<1645,1648,1646>,<1646,1648,1649>,<1646,1649,1644>,
            <1644,1649,1647>,
    /*2*/ <1647,1650,1648>,<1648,1650,1651>,<1648,1651,1649>,<1649,1651,1652>,<1649,1652,1647>,
            <1647,1652,1650>,
    /*3*/ <1650,1653,1651>,<1651,1653,1652>,<1652,1653,1650>

    /* stem 0.4.1*/ 
    /*0*/ <1654,1655,1656>,<1654,1656,1657>,<1654,1657,1655>,
    /*1*/ <1655,1658,1656>,<1656,1658,1659>,<1656,1659,1657>,<1657,1659,1660>,<1657,1660,1655>,
            <1655,1660,1658>,
    /*2*/ <1658,1661,1659>,<1659,1661,1662>,<1659,1662,1660>,<1660,1662,1663>,<1660,1663,1658>,
            <1658,1663,1661>,
    /*3*/ <1661,1664,1662>,<1662,1664,1663>,<1663,1664,1661>

    /* stem 0.4.2*/ 
    /*0*/ <1665,1666,1667>,<1665,1667,1668>,<1665,1668,1666>,
    /*1*/ <1666,1669,1667>,<1667,1669,1670>,<1667,1670,1668>,<1668,1670,1671>,<1668,1671,1666>,
            <1666,1671,1669>,
    /*2*/ <1669,1672,1670>,<1670,1672,1673>,<1670,1673,1671>,<1671,1673,1674>,<1671,1674,1669>,
            <1669,1674,1672>,
    /*3*/ <1672,1675,1673>,<1673,1675,1674>,<1674,1675,1672>

    /* stem 0.4.3*/ 
    /*0*/ <1676,1677,1678>,<1676,1678,1679>,<1676,1679,1677>,
    /*1*/ <1677,1680,1678>,<1678,1680,1681>,<1678,1681,1679>,<1679,1681,1682>,<1679,1682,1677>,
            <1677,1682,1680>,
    /*2*/ <1680,1683,1681>,<1681,1683,1684>,<1681,1684,1682>,<1682,1684,1685>,<1682,1685,1680>,
            <1680,1685,1683>,
    /*3*/ <1683,1686,1684>,<1684,1686,1685>,<1685,1686,1683>

    /* stem 0.4.4*/ 
    /*0*/ <1687,1688,1689>,<1687,1689,1690>,<1687,1690,1688>,
    /*1*/ <1688,1691,1689>,<1689,1691,1692>,<1689,1692,1690>,<1690,1692,1693>,<1690,1693,1688>,
            <1688,1693,1691>,
    /*2*/ <1691,1694,1692>,<1692,1694,1695>,<1692,1695,1693>,<1693,1695,1696>,<1693,1696,1691>,
            <1691,1696,1694>,
    /*3*/ <1694,1697,1695>,<1695,1697,1696>,<1696,1697,1694>

    /* stem 0.4.5*/ 
    /*0*/ <1698,1699,1700>,<1698,1700,1701>,<1698,1701,1699>,
    /*1*/ <1699,1702,1700>,<1700,1702,1703>,<1700,1703,1701>,<1701,1703,1704>,<1701,1704,1699>,
            <1699,1704,1702>,
    /*2*/ <1702,1705,1703>,<1703,1705,1706>,<1703,1706,1704>,<1704,1706,1707>,<1704,1707,1702>,
            <1702,1707,1705>,
    /*3*/ <1705,1708,1706>,<1706,1708,1707>,<1707,1708,1705>

    /* stem 0.4.6*/ 
    /*0*/ <1709,1710,1711>,<1709,1711,1712>,<1709,1712,1710>,
    /*1*/ <1710,1713,1711>,<1711,1713,1714>,<1711,1714,1712>,<1712,1714,1715>,<1712,1715,1710>,
            <1710,1715,1713>,
    /*2*/ <1713,1716,1714>,<1714,1716,1717>,<1714,1717,1715>,<1715,1717,1718>,<1715,1718,1713>,
            <1713,1718,1716>,
    /*3*/ <1716,1719,1717>,<1717,1719,1718>,<1718,1719,1716>

    /* stem 0.4.7*/ 
    /*0*/ <1720,1721,1722>,<1720,1722,1723>,<1720,1723,1721>,
    /*1*/ <1721,1724,1722>,<1722,1724,1725>,<1722,1725,1723>,<1723,1725,1726>,<1723,1726,1721>,
            <1721,1726,1724>,
    /*2*/ <1724,1727,1725>,<1725,1727,1728>,<1725,1728,1726>,<1726,1728,1729>,<1726,1729,1724>,
            <1724,1729,1727>,
    /*3*/ <1727,1730,1728>,<1728,1730,1729>,<1729,1730,1727>

    /* stem 0.4.8*/ 
    /*0*/ <1731,1732,1733>,<1731,1733,1734>,<1731,1734,1732>,
    /*1*/ <1732,1735,1733>,<1733,1735,1736>,<1733,1736,1734>,<1734,1736,1737>,<1734,1737,1732>,
            <1732,1737,1735>,
    /*2*/ <1735,1738,1736>,<1736,1738,1739>,<1736,1739,1737>,<1737,1739,1740>,<1737,1740,1735>,
            <1735,1740,1738>,
    /*3*/ <1738,1741,1739>,<1739,1741,1740>,<1740,1741,1738>

    /* stem 0.4.9*/ 
    /*0*/ <1742,1743,1744>,<1742,1744,1745>,<1742,1745,1743>,
    /*1*/ <1743,1746,1744>,<1744,1746,1747>,<1744,1747,1745>,<1745,1747,1748>,<1745,1748,1743>,
            <1743,1748,1746>,
    /*2*/ <1746,1749,1747>,<1747,1749,1750>,<1747,1750,1748>,<1748,1750,1751>,<1748,1751,1746>,
            <1746,1751,1749>,
    /*3*/ <1749,1752,1750>,<1750,1752,1751>,<1751,1752,1749>

    /* stem 0.4.10*/ 
    /*0*/ <1753,1754,1755>,<1753,1755,1756>,<1753,1756,1754>,
    /*1*/ <1754,1757,1755>,<1755,1757,1758>,<1755,1758,1756>,<1756,1758,1759>,<1756,1759,1754>,
            <1754,1759,1757>,
    /*2*/ <1757,1760,1758>,<1758,1760,1761>,<1758,1761,1759>,<1759,1761,1762>,<1759,1762,1757>,
            <1757,1762,1760>,
    /*3*/ <1760,1763,1761>,<1761,1763,1762>,<1762,1763,1760>

    /* stem 0.4.11*/ 
    /*0*/ <1764,1765,1766>,<1764,1766,1767>,<1764,1767,1765>,
    /*1*/ <1765,1768,1766>,<1766,1768,1769>,<1766,1769,1767>,<1767,1769,1770>,<1767,1770,1765>,
            <1765,1770,1768>,
    /*2*/ <1768,1771,1769>,<1769,1771,1772>,<1769,1772,1770>,<1770,1772,1773>,<1770,1773,1768>,
            <1768,1773,1771>,
    /*3*/ <1771,1774,1772>,<1772,1774,1773>,<1773,1774,1771>

    /* stem 0.4.12*/ 
    /*0*/ <1775,1776,1777>,<1775,1777,1778>,<1775,1778,1776>,
    /*1*/ <1776,1779,1777>,<1777,1779,1780>,<1777,1780,1778>,<1778,1780,1781>,<1778,1781,1776>,
            <1776,1781,1779>,
    /*2*/ <1779,1782,1780>,<1780,1782,1783>,<1780,1783,1781>,<1781,1783,1784>,<1781,1784,1779>,
            <1779,1784,1782>,
    /*3*/ <1782,1785,1783>,<1783,1785,1784>,<1784,1785,1782>

    /* stem 0.4.13*/ 
    /*0*/ <1786,1787,1788>,<1786,1788,1789>,<1786,1789,1787>,
    /*1*/ <1787,1790,1788>,<1788,1790,1791>,<1788,1791,1789>,<1789,1791,1792>,<1789,1792,1787>,
            <1787,1792,1790>,
    /*2*/ <1790,1793,1791>,<1791,1793,1794>,<1791,1794,1792>,<1792,1794,1795>,<1792,1795,1790>,
            <1790,1795,1793>,
    /*3*/ <1793,1796,1794>,<1794,1796,1795>,<1795,1796,1793>

    /* stem 0.4.14*/ 
    /*0*/ <1797,1798,1799>,<1797,1799,1800>,<1797,1800,1798>,
    /*1*/ <1798,1801,1799>,<1799,1801,1802>,<1799,1802,1800>,<1800,1802,1803>,<1800,1803,1798>,
            <1798,1803,1801>,
    /*2*/ <1801,1804,1802>,<1802,1804,1805>,<1802,1805,1803>,<1803,1805,1806>,<1803,1806,1801>,
            <1801,1806,1804>,
    /*3*/ <1804,1807,1805>,<1805,1807,1806>,<1806,1807,1804>

    /* stem 0.4.15*/ 
    /*0*/ <1808,1809,1810>,<1808,1810,1811>,<1808,1811,1809>,
    /*1*/ <1809,1812,1810>,<1810,1812,1813>,<1810,1813,1811>,<1811,1813,1814>,<1811,1814,1809>,
            <1809,1814,1812>,
    /*2*/ <1812,1815,1813>,<1813,1815,1816>,<1813,1816,1814>,<1814,1816,1817>,<1814,1817,1812>,
            <1812,1817,1815>,
    /*3*/ <1815,1818,1816>,<1816,1818,1817>,<1817,1818,1815>

    /* stem 0.4.16*/ 
    /*0*/ <1819,1820,1821>,<1819,1821,1822>,<1819,1822,1820>,
    /*1*/ <1820,1823,1821>,<1821,1823,1824>,<1821,1824,1822>,<1822,1824,1825>,<1822,1825,1820>,
            <1820,1825,1823>,
    /*2*/ <1823,1826,1824>,<1824,1826,1827>,<1824,1827,1825>,<1825,1827,1828>,<1825,1828,1823>,
            <1823,1828,1826>,
    /*3*/ <1826,1829,1827>,<1827,1829,1828>,<1828,1829,1826>

    /* stem 0.4.17*/ 
    /*0*/ <1830,1831,1832>,<1830,1832,1833>,<1830,1833,1831>,
    /*1*/ <1831,1834,1832>,<1832,1834,1835>,<1832,1835,1833>,<1833,1835,1836>,<1833,1836,1831>,
            <1831,1836,1834>,
    /*2*/ <1834,1837,1835>,<1835,1837,1838>,<1835,1838,1836>,<1836,1838,1839>,<1836,1839,1834>,
            <1834,1839,1837>,
    /*3*/ <1837,1840,1838>,<1838,1840,1839>,<1839,1840,1837>

    /* stem 0.4.18*/ 
    /*0*/ <1841,1842,1843>,<1841,1843,1844>,<1841,1844,1842>,
    /*1*/ <1842,1845,1843>,<1843,1845,1846>,<1843,1846,1844>,<1844,1846,1847>,<1844,1847,1842>,
            <1842,1847,1845>,
    /*2*/ <1845,1848,1846>,<1846,1848,1849>,<1846,1849,1847>,<1847,1849,1850>,<1847,1850,1845>,
            <1845,1850,1848>,
    /*3*/ <1848,1851,1849>,<1849,1851,1850>,<1850,1851,1848>

    /* stem 0.4.19*/ 
    /*0*/ <1852,1853,1854>,<1852,1854,1855>,<1852,1855,1853>,
    /*1*/ <1853,1856,1854>,<1854,1856,1857>,<1854,1857,1855>,<1855,1857,1858>,<1855,1858,1853>,
            <1853,1858,1856>,
    /*2*/ <1856,1859,1857>,<1857,1859,1860>,<1857,1860,1858>,<1858,1860,1861>,<1858,1861,1856>,
            <1856,1861,1859>,
    /*3*/ <1859,1862,1860>,<1860,1862,1861>,<1861,1862,1859>

    /* stem 0.4.20*/ 
    /*0*/ <1863,1864,1865>,<1863,1865,1866>,<1863,1866,1864>,
    /*1*/ <1864,1867,1865>,<1865,1867,1868>,<1865,1868,1866>,<1866,1868,1869>,<1866,1869,1864>,
            <1864,1869,1867>,
    /*2*/ <1867,1870,1868>,<1868,1870,1871>,<1868,1871,1869>,<1869,1871,1872>,<1869,1872,1867>,
            <1867,1872,1870>,
    /*3*/ <1870,1873,1871>,<1871,1873,1872>,<1872,1873,1870>

    /* stem 0.4.21*/ 
    /*0*/ <1874,1875,1876>,<1874,1876,1877>,<1874,1877,1875>,
    /*1*/ <1875,1878,1876>,<1876,1878,1879>,<1876,1879,1877>,<1877,1879,1880>,<1877,1880,1875>,
            <1875,1880,1878>,
    /*2*/ <1878,1881,1879>,<1879,1881,1882>,<1879,1882,1880>,<1880,1882,1883>,<1880,1883,1878>,
            <1878,1883,1881>,
    /*3*/ <1881,1884,1882>,<1882,1884,1883>,<1883,1884,1881>

    /* stem 0.4.22*/ 
    /*0*/ <1885,1886,1887>,<1885,1887,1888>,<1885,1888,1886>,
    /*1*/ <1886,1889,1887>,<1887,1889,1890>,<1887,1890,1888>,<1888,1890,1891>,<1888,1891,1886>,
            <1886,1891,1889>,
    /*2*/ <1889,1892,1890>,<1890,1892,1893>,<1890,1893,1891>,<1891,1893,1894>,<1891,1894,1889>,
            <1889,1894,1892>,
    /*3*/ <1892,1895,1893>,<1893,1895,1894>,<1894,1895,1892>

    /* stem 0.4.23*/ 
    /*0*/ <1896,1897,1898>,<1896,1898,1899>,<1896,1899,1897>,
    /*1*/ <1897,1900,1898>,<1898,1900,1901>,<1898,1901,1899>,<1899,1901,1902>,<1899,1902,1897>,
            <1897,1902,1900>,
    /*2*/ <1900,1903,1901>,<1901,1903,1904>,<1901,1904,1902>,<1902,1904,1905>,<1902,1905,1900>,
            <1900,1905,1903>,
    /*3*/ <1903,1906,1904>,<1904,1906,1905>,<1905,1906,1903>

    /* stem 0.4.24*/ 
    /*0*/ <1907,1908,1909>,<1907,1909,1910>,<1907,1910,1908>,
    /*1*/ <1908,1911,1909>,<1909,1911,1912>,<1909,1912,1910>,<1910,1912,1913>,<1910,1913,1908>,
            <1908,1913,1911>,
    /*2*/ <1911,1914,1912>,<1912,1914,1915>,<1912,1915,1913>,<1913,1915,1916>,<1913,1916,1911>,
            <1911,1916,1914>,
    /*3*/ <1914,1917,1915>,<1915,1917,1916>,<1916,1917,1914>

    /* stem 0.4.25*/ 
    /*0*/ <1918,1919,1920>,<1918,1920,1921>,<1918,1921,1919>,
    /*1*/ <1919,1922,1920>,<1920,1922,1923>,<1920,1923,1921>,<1921,1923,1924>,<1921,1924,1919>,
            <1919,1924,1922>,
    /*2*/ <1922,1925,1923>,<1923,1925,1926>,<1923,1926,1924>,<1924,1926,1927>,<1924,1927,1922>,
            <1922,1927,1925>,
    /*3*/ <1925,1928,1926>,<1926,1928,1927>,<1927,1928,1925>

    /* stem 0.4.26*/ 
    /*0*/ <1929,1930,1931>,<1929,1931,1932>,<1929,1932,1930>,
    /*1*/ <1930,1933,1931>,<1931,1933,1934>,<1931,1934,1932>,<1932,1934,1935>,<1932,1935,1930>,
            <1930,1935,1933>,
    /*2*/ <1933,1936,1934>,<1934,1936,1937>,<1934,1937,1935>,<1935,1937,1938>,<1935,1938,1933>,
            <1933,1938,1936>,
    /*3*/ <1936,1939,1937>,<1937,1939,1938>,<1938,1939,1936>

    /* stem 0.4.27*/ 
    /*0*/ <1940,1941,1942>,<1940,1942,1943>,<1940,1943,1941>,
    /*1*/ <1941,1944,1942>,<1942,1944,1945>,<1942,1945,1943>,<1943,1945,1946>,<1943,1946,1941>,
            <1941,1946,1944>,
    /*2*/ <1944,1947,1945>,<1945,1947,1948>,<1945,1948,1946>,<1946,1948,1949>,<1946,1949,1944>,
            <1944,1949,1947>,
    /*3*/ <1947,1950,1948>,<1948,1950,1949>,<1949,1950,1947>

    /* stem 0.4.28*/ 
    /*0*/ <1951,1952,1953>,<1951,1953,1954>,<1951,1954,1952>,
    /*1*/ <1952,1955,1953>,<1953,1955,1956>,<1953,1956,1954>,<1954,1956,1957>,<1954,1957,1952>,
            <1952,1957,1955>,
    /*2*/ <1955,1958,1956>,<1956,1958,1959>,<1956,1959,1957>,<1957,1959,1960>,<1957,1960,1955>,
            <1955,1960,1958>,
    /*3*/ <1958,1961,1959>,<1959,1961,1960>,<1960,1961,1958>

    /* stem 0.5*/ 
    /*0*/ <1962,1963,1964>,<1962,1964,1965>,<1962,1965,1966>,<1962,1966,1967>,<1962,1967,1963>,
            
    /*1*/ <1963,1968,1964>,<1964,1968,1969>,<1964,1969,1965>,<1965,1969,1970>,<1965,1970,1966>,
            <1966,1970,1971>,<1966,1971,1967>,<1967,1971,1972>,<1967,1972,1963>,<1963,1972,1968>,
    /*2*/ <1968,1973,1969>,<1969,1973,1974>,<1969,1974,1970>,<1970,1974,1975>,<1970,1975,1971>,
            <1971,1975,1976>,<1971,1976,1972>,<1972,1976,1977>,<1972,1977,1968>,<1968,1977,1973>,
    /*3*/ <1973,1978,1974>,<1974,1978,1975>,<1975,1978,1976>,<1976,1978,1977>,<1977,1978,1973>
            

    /* stem 0.5.0*/ 
    /*0*/ <1979,1980,1981>,<1979,1981,1982>,<1979,1982,1980>,
    /*1*/ <1980,1983,1981>,<1981,1983,1984>,<1981,1984,1982>,<1982,1984,1985>,<1982,1985,1980>,
            <1980,1985,1983>,
    /*2*/ <1983,1986,1984>,<1984,1986,1987>,<1984,1987,1985>,<1985,1987,1988>,<1985,1988,1983>,
            <1983,1988,1986>,
    /*3*/ <1986,1989,1987>,<1987,1989,1988>,<1988,1989,1986>

    /* stem 0.5.1*/ 
    /*0*/ <1990,1991,1992>,<1990,1992,1993>,<1990,1993,1991>,
    /*1*/ <1991,1994,1992>,<1992,1994,1995>,<1992,1995,1993>,<1993,1995,1996>,<1993,1996,1991>,
            <1991,1996,1994>,
    /*2*/ <1994,1997,1995>,<1995,1997,1998>,<1995,1998,1996>,<1996,1998,1999>,<1996,1999,1994>,
            <1994,1999,1997>,
    /*3*/ <1997,2000,1998>,<1998,2000,1999>,<1999,2000,1997>

    /* stem 0.5.2*/ 
    /*0*/ <2001,2002,2003>,<2001,2003,2004>,<2001,2004,2002>,
    /*1*/ <2002,2005,2003>,<2003,2005,2006>,<2003,2006,2004>,<2004,2006,2007>,<2004,2007,2002>,
            <2002,2007,2005>,
    /*2*/ <2005,2008,2006>,<2006,2008,2009>,<2006,2009,2007>,<2007,2009,2010>,<2007,2010,2005>,
            <2005,2010,2008>,
    /*3*/ <2008,2011,2009>,<2009,2011,2010>,<2010,2011,2008>

    /* stem 0.5.3*/ 
    /*0*/ <2012,2013,2014>,<2012,2014,2015>,<2012,2015,2013>,
    /*1*/ <2013,2016,2014>,<2014,2016,2017>,<2014,2017,2015>,<2015,2017,2018>,<2015,2018,2013>,
            <2013,2018,2016>,
    /*2*/ <2016,2019,2017>,<2017,2019,2020>,<2017,2020,2018>,<2018,2020,2021>,<2018,2021,2016>,
            <2016,2021,2019>,
    /*3*/ <2019,2022,2020>,<2020,2022,2021>,<2021,2022,2019>

    /* stem 0.5.4*/ 
    /*0*/ <2023,2024,2025>,<2023,2025,2026>,<2023,2026,2024>,
    /*1*/ <2024,2027,2025>,<2025,2027,2028>,<2025,2028,2026>,<2026,2028,2029>,<2026,2029,2024>,
            <2024,2029,2027>,
    /*2*/ <2027,2030,2028>,<2028,2030,2031>,<2028,2031,2029>,<2029,2031,2032>,<2029,2032,2027>,
            <2027,2032,2030>,
    /*3*/ <2030,2033,2031>,<2031,2033,2032>,<2032,2033,2030>

    /* stem 0.5.5*/ 
    /*0*/ <2034,2035,2036>,<2034,2036,2037>,<2034,2037,2035>,
    /*1*/ <2035,2038,2036>,<2036,2038,2039>,<2036,2039,2037>,<2037,2039,2040>,<2037,2040,2035>,
            <2035,2040,2038>,
    /*2*/ <2038,2041,2039>,<2039,2041,2042>,<2039,2042,2040>,<2040,2042,2043>,<2040,2043,2038>,
            <2038,2043,2041>,
    /*3*/ <2041,2044,2042>,<2042,2044,2043>,<2043,2044,2041>

    /* stem 0.5.6*/ 
    /*0*/ <2045,2046,2047>,<2045,2047,2048>,<2045,2048,2046>,
    /*1*/ <2046,2049,2047>,<2047,2049,2050>,<2047,2050,2048>,<2048,2050,2051>,<2048,2051,2046>,
            <2046,2051,2049>,
    /*2*/ <2049,2052,2050>,<2050,2052,2053>,<2050,2053,2051>,<2051,2053,2054>,<2051,2054,2049>,
            <2049,2054,2052>,
    /*3*/ <2052,2055,2053>,<2053,2055,2054>,<2054,2055,2052>

    /* stem 0.5.7*/ 
    /*0*/ <2056,2057,2058>,<2056,2058,2059>,<2056,2059,2057>,
    /*1*/ <2057,2060,2058>,<2058,2060,2061>,<2058,2061,2059>,<2059,2061,2062>,<2059,2062,2057>,
            <2057,2062,2060>,
    /*2*/ <2060,2063,2061>,<2061,2063,2064>,<2061,2064,2062>,<2062,2064,2065>,<2062,2065,2060>,
            <2060,2065,2063>,
    /*3*/ <2063,2066,2064>,<2064,2066,2065>,<2065,2066,2063>

    /* stem 0.5.8*/ 
    /*0*/ <2067,2068,2069>,<2067,2069,2070>,<2067,2070,2068>,
    /*1*/ <2068,2071,2069>,<2069,2071,2072>,<2069,2072,2070>,<2070,2072,2073>,<2070,2073,2068>,
            <2068,2073,2071>,
    /*2*/ <2071,2074,2072>,<2072,2074,2075>,<2072,2075,2073>,<2073,2075,2076>,<2073,2076,2071>,
            <2071,2076,2074>,
    /*3*/ <2074,2077,2075>,<2075,2077,2076>,<2076,2077,2074>

    /* stem 0.5.9*/ 
    /*0*/ <2078,2079,2080>,<2078,2080,2081>,<2078,2081,2079>,
    /*1*/ <2079,2082,2080>,<2080,2082,2083>,<2080,2083,2081>,<2081,2083,2084>,<2081,2084,2079>,
            <2079,2084,2082>,
    /*2*/ <2082,2085,2083>,<2083,2085,2086>,<2083,2086,2084>,<2084,2086,2087>,<2084,2087,2082>,
            <2082,2087,2085>,
    /*3*/ <2085,2088,2086>,<2086,2088,2087>,<2087,2088,2085>

    /* stem 0.5.10*/ 
    /*0*/ <2089,2090,2091>,<2089,2091,2092>,<2089,2092,2090>,
    /*1*/ <2090,2093,2091>,<2091,2093,2094>,<2091,2094,2092>,<2092,2094,2095>,<2092,2095,2090>,
            <2090,2095,2093>,
    /*2*/ <2093,2096,2094>,<2094,2096,2097>,<2094,2097,2095>,<2095,2097,2098>,<2095,2098,2093>,
            <2093,2098,2096>,
    /*3*/ <2096,2099,2097>,<2097,2099,2098>,<2098,2099,2096>

    /* stem 0.5.11*/ 
    /*0*/ <2100,2101,2102>,<2100,2102,2103>,<2100,2103,2101>,
    /*1*/ <2101,2104,2102>,<2102,2104,2105>,<2102,2105,2103>,<2103,2105,2106>,<2103,2106,2101>,
            <2101,2106,2104>,
    /*2*/ <2104,2107,2105>,<2105,2107,2108>,<2105,2108,2106>,<2106,2108,2109>,<2106,2109,2104>,
            <2104,2109,2107>,
    /*3*/ <2107,2110,2108>,<2108,2110,2109>,<2109,2110,2107>

    /* stem 0.5.12*/ 
    /*0*/ <2111,2112,2113>,<2111,2113,2114>,<2111,2114,2112>,
    /*1*/ <2112,2115,2113>,<2113,2115,2116>,<2113,2116,2114>,<2114,2116,2117>,<2114,2117,2112>,
            <2112,2117,2115>,
    /*2*/ <2115,2118,2116>,<2116,2118,2119>,<2116,2119,2117>,<2117,2119,2120>,<2117,2120,2115>,
            <2115,2120,2118>,
    /*3*/ <2118,2121,2119>,<2119,2121,2120>,<2120,2121,2118>

    /* stem 0.5.13*/ 
    /*0*/ <2122,2123,2124>,<2122,2124,2125>,<2122,2125,2123>,
    /*1*/ <2123,2126,2124>,<2124,2126,2127>,<2124,2127,2125>,<2125,2127,2128>,<2125,2128,2123>,
            <2123,2128,2126>,
    /*2*/ <2126,2129,2127>,<2127,2129,2130>,<2127,2130,2128>,<2128,2130,2131>,<2128,2131,2126>,
            <2126,2131,2129>,
    /*3*/ <2129,2132,2130>,<2130,2132,2131>,<2131,2132,2129>

    /* stem 0.5.14*/ 
    /*0*/ <2133,2134,2135>,<2133,2135,2136>,<2133,2136,2134>,
    /*1*/ <2134,2137,2135>,<2135,2137,2138>,<2135,2138,2136>,<2136,2138,2139>,<2136,2139,2134>,
            <2134,2139,2137>,
    /*2*/ <2137,2140,2138>,<2138,2140,2141>,<2138,2141,2139>,<2139,2141,2142>,<2139,2142,2137>,
            <2137,2142,2140>,
    /*3*/ <2140,2143,2141>,<2141,2143,2142>,<2142,2143,2140>

    /* stem 0.5.15*/ 
    /*0*/ <2144,2145,2146>,<2144,2146,2147>,<2144,2147,2145>,
    /*1*/ <2145,2148,2146>,<2146,2148,2149>,<2146,2149,2147>,<2147,2149,2150>,<2147,2150,2145>,
            <2145,2150,2148>,
    /*2*/ <2148,2151,2149>,<2149,2151,2152>,<2149,2152,2150>,<2150,2152,2153>,<2150,2153,2148>,
            <2148,2153,2151>,
    /*3*/ <2151,2154,2152>,<2152,2154,2153>,<2153,2154,2151>

    /* stem 0.5.16*/ 
    /*0*/ <2155,2156,2157>,<2155,2157,2158>,<2155,2158,2156>,
    /*1*/ <2156,2159,2157>,<2157,2159,2160>,<2157,2160,2158>,<2158,2160,2161>,<2158,2161,2156>,
            <2156,2161,2159>,
    /*2*/ <2159,2162,2160>,<2160,2162,2163>,<2160,2163,2161>,<2161,2163,2164>,<2161,2164,2159>,
            <2159,2164,2162>,
    /*3*/ <2162,2165,2163>,<2163,2165,2164>,<2164,2165,2162>

    /* stem 0.5.17*/ 
    /*0*/ <2166,2167,2168>,<2166,2168,2169>,<2166,2169,2167>,
    /*1*/ <2167,2170,2168>,<2168,2170,2171>,<2168,2171,2169>,<2169,2171,2172>,<2169,2172,2167>,
            <2167,2172,2170>,
    /*2*/ <2170,2173,2171>,<2171,2173,2174>,<2171,2174,2172>,<2172,2174,2175>,<2172,2175,2170>,
            <2170,2175,2173>,
    /*3*/ <2173,2176,2174>,<2174,2176,2175>,<2175,2176,2173>

    /* stem 0.5.18*/ 
    /*0*/ <2177,2178,2179>,<2177,2179,2180>,<2177,2180,2178>,
    /*1*/ <2178,2181,2179>,<2179,2181,2182>,<2179,2182,2180>,<2180,2182,2183>,<2180,2183,2178>,
            <2178,2183,2181>,
    /*2*/ <2181,2184,2182>,<2182,2184,2185>,<2182,2185,2183>,<2183,2185,2186>,<2183,2186,2181>,
            <2181,2186,2184>,
    /*3*/ <2184,2187,2185>,<2185,2187,2186>,<2186,2187,2184>

    /* stem 0.5.19*/ 
    /*0*/ <2188,2189,2190>,<2188,2190,2191>,<2188,2191,2189>,
    /*1*/ <2189,2192,2190>,<2190,2192,2193>,<2190,2193,2191>,<2191,2193,2194>,<2191,2194,2189>,
            <2189,2194,2192>,
    /*2*/ <2192,2195,2193>,<2193,2195,2196>,<2193,2196,2194>,<2194,2196,2197>,<2194,2197,2192>,
            <2192,2197,2195>,
    /*3*/ <2195,2198,2196>,<2196,2198,2197>,<2197,2198,2195>

    /* stem 0.5.20*/ 
    /*0*/ <2199,2200,2201>,<2199,2201,2202>,<2199,2202,2200>,
    /*1*/ <2200,2203,2201>,<2201,2203,2204>,<2201,2204,2202>,<2202,2204,2205>,<2202,2205,2200>,
            <2200,2205,2203>,
    /*2*/ <2203,2206,2204>,<2204,2206,2207>,<2204,2207,2205>,<2205,2207,2208>,<2205,2208,2203>,
            <2203,2208,2206>,
    /*3*/ <2206,2209,2207>,<2207,2209,2208>,<2208,2209,2206>

    /* stem 0.5.21*/ 
    /*0*/ <2210,2211,2212>,<2210,2212,2213>,<2210,2213,2211>,
    /*1*/ <2211,2214,2212>,<2212,2214,2215>,<2212,2215,2213>,<2213,2215,2216>,<2213,2216,2211>,
            <2211,2216,2214>,
    /*2*/ <2214,2217,2215>,<2215,2217,2218>,<2215,2218,2216>,<2216,2218,2219>,<2216,2219,2214>,
            <2214,2219,2217>,
    /*3*/ <2217,2220,2218>,<2218,2220,2219>,<2219,2220,2217>

    /* stem 0.5.22*/ 
    /*0*/ <2221,2222,2223>,<2221,2223,2224>,<2221,2224,2222>,
    /*1*/ <2222,2225,2223>,<2223,2225,2226>,<2223,2226,2224>,<2224,2226,2227>,<2224,2227,2222>,
            <2222,2227,2225>,
    /*2*/ <2225,2228,2226>,<2226,2228,2229>,<2226,2229,2227>,<2227,2229,2230>,<2227,2230,2225>,
            <2225,2230,2228>,
    /*3*/ <2228,2231,2229>,<2229,2231,2230>,<2230,2231,2228>

    /* stem 0.5.23*/ 
    /*0*/ <2232,2233,2234>,<2232,2234,2235>,<2232,2235,2233>,
    /*1*/ <2233,2236,2234>,<2234,2236,2237>,<2234,2237,2235>,<2235,2237,2238>,<2235,2238,2233>,
            <2233,2238,2236>,
    /*2*/ <2236,2239,2237>,<2237,2239,2240>,<2237,2240,2238>,<2238,2240,2241>,<2238,2241,2236>,
            <2236,2241,2239>,
    /*3*/ <2239,2242,2240>,<2240,2242,2241>,<2241,2242,2239>

    /* stem 0.5.24*/ 
    /*0*/ <2243,2244,2245>,<2243,2245,2246>,<2243,2246,2244>,
    /*1*/ <2244,2247,2245>,<2245,2247,2248>,<2245,2248,2246>,<2246,2248,2249>,<2246,2249,2244>,
            <2244,2249,2247>,
    /*2*/ <2247,2250,2248>,<2248,2250,2251>,<2248,2251,2249>,<2249,2251,2252>,<2249,2252,2247>,
            <2247,2252,2250>,
    /*3*/ <2250,2253,2251>,<2251,2253,2252>,<2252,2253,2250>

    /* stem 0.5.25*/ 
    /*0*/ <2254,2255,2256>,<2254,2256,2257>,<2254,2257,2255>,
    /*1*/ <2255,2258,2256>,<2256,2258,2259>,<2256,2259,2257>,<2257,2259,2260>,<2257,2260,2255>,
            <2255,2260,2258>,
    /*2*/ <2258,2261,2259>,<2259,2261,2262>,<2259,2262,2260>,<2260,2262,2263>,<2260,2263,2258>,
            <2258,2263,2261>,
    /*3*/ <2261,2264,2262>,<2262,2264,2263>,<2263,2264,2261>

    /* stem 0.5.26*/ 
    /*0*/ <2265,2266,2267>,<2265,2267,2268>,<2265,2268,2266>,
    /*1*/ <2266,2269,2267>,<2267,2269,2270>,<2267,2270,2268>,<2268,2270,2271>,<2268,2271,2266>,
            <2266,2271,2269>,
    /*2*/ <2269,2272,2270>,<2270,2272,2273>,<2270,2273,2271>,<2271,2273,2274>,<2271,2274,2269>,
            <2269,2274,2272>,
    /*3*/ <2272,2275,2273>,<2273,2275,2274>,<2274,2275,2272>

    /* stem 0.5.27*/ 
    /*0*/ <2276,2277,2278>,<2276,2278,2279>,<2276,2279,2277>,
    /*1*/ <2277,2280,2278>,<2278,2280,2281>,<2278,2281,2279>,<2279,2281,2282>,<2279,2282,2277>,
            <2277,2282,2280>,
    /*2*/ <2280,2283,2281>,<2281,2283,2284>,<2281,2284,2282>,<2282,2284,2285>,<2282,2285,2280>,
            <2280,2285,2283>,
    /*3*/ <2283,2286,2284>,<2284,2286,2285>,<2285,2286,2283>

    /* stem 0.5.28*/ 
    /*0*/ <2287,2288,2289>,<2287,2289,2290>,<2287,2290,2288>,
    /*1*/ <2288,2291,2289>,<2289,2291,2292>,<2289,2292,2290>,<2290,2292,2293>,<2290,2293,2288>,
            <2288,2293,2291>,
    /*2*/ <2291,2294,2292>,<2292,2294,2295>,<2292,2295,2293>,<2293,2295,2296>,<2293,2296,2291>,
            <2291,2296,2294>,
    /*3*/ <2294,2297,2295>,<2295,2297,2296>,<2296,2297,2294>

    /* stem 0.6*/ 
    /*0*/ <2298,2299,2300>,<2298,2300,2301>,<2298,2301,2302>,<2298,2302,2303>,<2298,2303,2299>,
            
    /*1*/ <2299,2304,2300>,<2300,2304,2305>,<2300,2305,2301>,<2301,2305,2306>,<2301,2306,2302>,
            <2302,2306,2307>,<2302,2307,2303>,<2303,2307,2308>,<2303,2308,2299>,<2299,2308,2304>,
    /*2*/ <2304,2309,2305>,<2305,2309,2310>,<2305,2310,2306>,<2306,2310,2311>,<2306,2311,2307>,
            <2307,2311,2312>,<2307,2312,2308>,<2308,2312,2313>,<2308,2313,2304>,<2304,2313,2309>,
    /*3*/ <2309,2314,2310>,<2310,2314,2311>,<2311,2314,2312>,<2312,2314,2313>,<2313,2314,2309>
            

    /* stem 0.6.0*/ 
    /*0*/ <2315,2316,2317>,<2315,2317,2318>,<2315,2318,2316>,
    /*1*/ <2316,2319,2317>,<2317,2319,2320>,<2317,2320,2318>,<2318,2320,2321>,<2318,2321,2316>,
            <2316,2321,2319>,
    /*2*/ <2319,2322,2320>,<2320,2322,2323>,<2320,2323,2321>,<2321,2323,2324>,<2321,2324,2319>,
            <2319,2324,2322>,
    /*3*/ <2322,2325,2323>,<2323,2325,2324>,<2324,2325,2322>

    /* stem 0.6.1*/ 
    /*0*/ <2326,2327,2328>,<2326,2328,2329>,<2326,2329,2327>,
    /*1*/ <2327,2330,2328>,<2328,2330,2331>,<2328,2331,2329>,<2329,2331,2332>,<2329,2332,2327>,
            <2327,2332,2330>,
    /*2*/ <2330,2333,2331>,<2331,2333,2334>,<2331,2334,2332>,<2332,2334,2335>,<2332,2335,2330>,
            <2330,2335,2333>,
    /*3*/ <2333,2336,2334>,<2334,2336,2335>,<2335,2336,2333>

    /* stem 0.6.2*/ 
    /*0*/ <2337,2338,2339>,<2337,2339,2340>,<2337,2340,2338>,
    /*1*/ <2338,2341,2339>,<2339,2341,2342>,<2339,2342,2340>,<2340,2342,2343>,<2340,2343,2338>,
            <2338,2343,2341>,
    /*2*/ <2341,2344,2342>,<2342,2344,2345>,<2342,2345,2343>,<2343,2345,2346>,<2343,2346,2341>,
            <2341,2346,2344>,
    /*3*/ <2344,2347,2345>,<2345,2347,2346>,<2346,2347,2344>

    /* stem 0.6.3*/ 
    /*0*/ <2348,2349,2350>,<2348,2350,2351>,<2348,2351,2349>,
    /*1*/ <2349,2352,2350>,<2350,2352,2353>,<2350,2353,2351>,<2351,2353,2354>,<2351,2354,2349>,
            <2349,2354,2352>,
    /*2*/ <2352,2355,2353>,<2353,2355,2356>,<2353,2356,2354>,<2354,2356,2357>,<2354,2357,2352>,
            <2352,2357,2355>,
    /*3*/ <2355,2358,2356>,<2356,2358,2357>,<2357,2358,2355>

    /* stem 0.6.4*/ 
    /*0*/ <2359,2360,2361>,<2359,2361,2362>,<2359,2362,2360>,
    /*1*/ <2360,2363,2361>,<2361,2363,2364>,<2361,2364,2362>,<2362,2364,2365>,<2362,2365,2360>,
            <2360,2365,2363>,
    /*2*/ <2363,2366,2364>,<2364,2366,2367>,<2364,2367,2365>,<2365,2367,2368>,<2365,2368,2363>,
            <2363,2368,2366>,
    /*3*/ <2366,2369,2367>,<2367,2369,2368>,<2368,2369,2366>

    /* stem 0.6.5*/ 
    /*0*/ <2370,2371,2372>,<2370,2372,2373>,<2370,2373,2371>,
    /*1*/ <2371,2374,2372>,<2372,2374,2375>,<2372,2375,2373>,<2373,2375,2376>,<2373,2376,2371>,
            <2371,2376,2374>,
    /*2*/ <2374,2377,2375>,<2375,2377,2378>,<2375,2378,2376>,<2376,2378,2379>,<2376,2379,2374>,
            <2374,2379,2377>,
    /*3*/ <2377,2380,2378>,<2378,2380,2379>,<2379,2380,2377>

    /* stem 0.6.6*/ 
    /*0*/ <2381,2382,2383>,<2381,2383,2384>,<2381,2384,2382>,
    /*1*/ <2382,2385,2383>,<2383,2385,2386>,<2383,2386,2384>,<2384,2386,2387>,<2384,2387,2382>,
            <2382,2387,2385>,
    /*2*/ <2385,2388,2386>,<2386,2388,2389>,<2386,2389,2387>,<2387,2389,2390>,<2387,2390,2385>,
            <2385,2390,2388>,
    /*3*/ <2388,2391,2389>,<2389,2391,2390>,<2390,2391,2388>

    /* stem 0.6.7*/ 
    /*0*/ <2392,2393,2394>,<2392,2394,2395>,<2392,2395,2393>,
    /*1*/ <2393,2396,2394>,<2394,2396,2397>,<2394,2397,2395>,<2395,2397,2398>,<2395,2398,2393>,
            <2393,2398,2396>,
    /*2*/ <2396,2399,2397>,<2397,2399,2400>,<2397,2400,2398>,<2398,2400,2401>,<2398,2401,2396>,
            <2396,2401,2399>,
    /*3*/ <2399,2402,2400>,<2400,2402,2401>,<2401,2402,2399>

    /* stem 0.6.8*/ 
    /*0*/ <2403,2404,2405>,<2403,2405,2406>,<2403,2406,2404>,
    /*1*/ <2404,2407,2405>,<2405,2407,2408>,<2405,2408,2406>,<2406,2408,2409>,<2406,2409,2404>,
            <2404,2409,2407>,
    /*2*/ <2407,2410,2408>,<2408,2410,2411>,<2408,2411,2409>,<2409,2411,2412>,<2409,2412,2407>,
            <2407,2412,2410>,
    /*3*/ <2410,2413,2411>,<2411,2413,2412>,<2412,2413,2410>

    /* stem 0.6.9*/ 
    /*0*/ <2414,2415,2416>,<2414,2416,2417>,<2414,2417,2415>,
    /*1*/ <2415,2418,2416>,<2416,2418,2419>,<2416,2419,2417>,<2417,2419,2420>,<2417,2420,2415>,
            <2415,2420,2418>,
    /*2*/ <2418,2421,2419>,<2419,2421,2422>,<2419,2422,2420>,<2420,2422,2423>,<2420,2423,2418>,
            <2418,2423,2421>,
    /*3*/ <2421,2424,2422>,<2422,2424,2423>,<2423,2424,2421>

    /* stem 0.6.10*/ 
    /*0*/ <2425,2426,2427>,<2425,2427,2428>,<2425,2428,2426>,
    /*1*/ <2426,2429,2427>,<2427,2429,2430>,<2427,2430,2428>,<2428,2430,2431>,<2428,2431,2426>,
            <2426,2431,2429>,
    /*2*/ <2429,2432,2430>,<2430,2432,2433>,<2430,2433,2431>,<2431,2433,2434>,<2431,2434,2429>,
            <2429,2434,2432>,
    /*3*/ <2432,2435,2433>,<2433,2435,2434>,<2434,2435,2432>

    /* stem 0.6.11*/ 
    /*0*/ <2436,2437,2438>,<2436,2438,2439>,<2436,2439,2437>,
    /*1*/ <2437,2440,2438>,<2438,2440,2441>,<2438,2441,2439>,<2439,2441,2442>,<2439,2442,2437>,
            <2437,2442,2440>,
    /*2*/ <2440,2443,2441>,<2441,2443,2444>,<2441,2444,2442>,<2442,2444,2445>,<2442,2445,2440>,
            <2440,2445,2443>,
    /*3*/ <2443,2446,2444>,<2444,2446,2445>,<2445,2446,2443>

    /* stem 0.6.12*/ 
    /*0*/ <2447,2448,2449>,<2447,2449,2450>,<2447,2450,2448>,
    /*1*/ <2448,2451,2449>,<2449,2451,2452>,<2449,2452,2450>,<2450,2452,2453>,<2450,2453,2448>,
            <2448,2453,2451>,
    /*2*/ <2451,2454,2452>,<2452,2454,2455>,<2452,2455,2453>,<2453,2455,2456>,<2453,2456,2451>,
            <2451,2456,2454>,
    /*3*/ <2454,2457,2455>,<2455,2457,2456>,<2456,2457,2454>

    /* stem 0.6.13*/ 
    /*0*/ <2458,2459,2460>,<2458,2460,2461>,<2458,2461,2459>,
    /*1*/ <2459,2462,2460>,<2460,2462,2463>,<2460,2463,2461>,<2461,2463,2464>,<2461,2464,2459>,
            <2459,2464,2462>,
    /*2*/ <2462,2465,2463>,<2463,2465,2466>,<2463,2466,2464>,<2464,2466,2467>,<2464,2467,2462>,
            <2462,2467,2465>,
    /*3*/ <2465,2468,2466>,<2466,2468,2467>,<2467,2468,2465>

    /* stem 0.6.14*/ 
    /*0*/ <2469,2470,2471>,<2469,2471,2472>,<2469,2472,2470>,
    /*1*/ <2470,2473,2471>,<2471,2473,2474>,<2471,2474,2472>,<2472,2474,2475>,<2472,2475,2470>,
            <2470,2475,2473>,
    /*2*/ <2473,2476,2474>,<2474,2476,2477>,<2474,2477,2475>,<2475,2477,2478>,<2475,2478,2473>,
            <2473,2478,2476>,
    /*3*/ <2476,2479,2477>,<2477,2479,2478>,<2478,2479,2476>

    /* stem 0.6.15*/ 
    /*0*/ <2480,2481,2482>,<2480,2482,2483>,<2480,2483,2481>,
    /*1*/ <2481,2484,2482>,<2482,2484,2485>,<2482,2485,2483>,<2483,2485,2486>,<2483,2486,2481>,
            <2481,2486,2484>,
    /*2*/ <2484,2487,2485>,<2485,2487,2488>,<2485,2488,2486>,<2486,2488,2489>,<2486,2489,2484>,
            <2484,2489,2487>,
    /*3*/ <2487,2490,2488>,<2488,2490,2489>,<2489,2490,2487>

    /* stem 0.6.16*/ 
    /*0*/ <2491,2492,2493>,<2491,2493,2494>,<2491,2494,2492>,
    /*1*/ <2492,2495,2493>,<2493,2495,2496>,<2493,2496,2494>,<2494,2496,2497>,<2494,2497,2492>,
            <2492,2497,2495>,
    /*2*/ <2495,2498,2496>,<2496,2498,2499>,<2496,2499,2497>,<2497,2499,2500>,<2497,2500,2495>,
            <2495,2500,2498>,
    /*3*/ <2498,2501,2499>,<2499,2501,2500>,<2500,2501,2498>

    /* stem 0.6.17*/ 
    /*0*/ <2502,2503,2504>,<2502,2504,2505>,<2502,2505,2503>,
    /*1*/ <2503,2506,2504>,<2504,2506,2507>,<2504,2507,2505>,<2505,2507,2508>,<2505,2508,2503>,
            <2503,2508,2506>,
    /*2*/ <2506,2509,2507>,<2507,2509,2510>,<2507,2510,2508>,<2508,2510,2511>,<2508,2511,2506>,
            <2506,2511,2509>,
    /*3*/ <2509,2512,2510>,<2510,2512,2511>,<2511,2512,2509>

    /* stem 0.6.18*/ 
    /*0*/ <2513,2514,2515>,<2513,2515,2516>,<2513,2516,2514>,
    /*1*/ <2514,2517,2515>,<2515,2517,2518>,<2515,2518,2516>,<2516,2518,2519>,<2516,2519,2514>,
            <2514,2519,2517>,
    /*2*/ <2517,2520,2518>,<2518,2520,2521>,<2518,2521,2519>,<2519,2521,2522>,<2519,2522,2517>,
            <2517,2522,2520>,
    /*3*/ <2520,2523,2521>,<2521,2523,2522>,<2522,2523,2520>

    /* stem 0.6.19*/ 
    /*0*/ <2524,2525,2526>,<2524,2526,2527>,<2524,2527,2525>,
    /*1*/ <2525,2528,2526>,<2526,2528,2529>,<2526,2529,2527>,<2527,2529,2530>,<2527,2530,2525>,
            <2525,2530,2528>,
    /*2*/ <2528,2531,2529>,<2529,2531,2532>,<2529,2532,2530>,<2530,2532,2533>,<2530,2533,2528>,
            <2528,2533,2531>,
    /*3*/ <2531,2534,2532>,<2532,2534,2533>,<2533,2534,2531>

    /* stem 0.6.20*/ 
    /*0*/ <2535,2536,2537>,<2535,2537,2538>,<2535,2538,2536>,
    /*1*/ <2536,2539,2537>,<2537,2539,2540>,<2537,2540,2538>,<2538,2540,2541>,<2538,2541,2536>,
            <2536,2541,2539>,
    /*2*/ <2539,2542,2540>,<2540,2542,2543>,<2540,2543,2541>,<2541,2543,2544>,<2541,2544,2539>,
            <2539,2544,2542>,
    /*3*/ <2542,2545,2543>,<2543,2545,2544>,<2544,2545,2542>

    /* stem 0.6.21*/ 
    /*0*/ <2546,2547,2548>,<2546,2548,2549>,<2546,2549,2547>,
    /*1*/ <2547,2550,2548>,<2548,2550,2551>,<2548,2551,2549>,<2549,2551,2552>,<2549,2552,2547>,
            <2547,2552,2550>,
    /*2*/ <2550,2553,2551>,<2551,2553,2554>,<2551,2554,2552>,<2552,2554,2555>,<2552,2555,2550>,
            <2550,2555,2553>,
    /*3*/ <2553,2556,2554>,<2554,2556,2555>,<2555,2556,2553>

    /* stem 0.6.22*/ 
    /*0*/ <2557,2558,2559>,<2557,2559,2560>,<2557,2560,2558>,
    /*1*/ <2558,2561,2559>,<2559,2561,2562>,<2559,2562,2560>,<2560,2562,2563>,<2560,2563,2558>,
            <2558,2563,2561>,
    /*2*/ <2561,2564,2562>,<2562,2564,2565>,<2562,2565,2563>,<2563,2565,2566>,<2563,2566,2561>,
            <2561,2566,2564>,
    /*3*/ <2564,2567,2565>,<2565,2567,2566>,<2566,2567,2564>

    /* stem 0.6.23*/ 
    /*0*/ <2568,2569,2570>,<2568,2570,2571>,<2568,2571,2569>,
    /*1*/ <2569,2572,2570>,<2570,2572,2573>,<2570,2573,2571>,<2571,2573,2574>,<2571,2574,2569>,
            <2569,2574,2572>,
    /*2*/ <2572,2575,2573>,<2573,2575,2576>,<2573,2576,2574>,<2574,2576,2577>,<2574,2577,2572>,
            <2572,2577,2575>,
    /*3*/ <2575,2578,2576>,<2576,2578,2577>,<2577,2578,2575>

    /* stem 0.6.24*/ 
    /*0*/ <2579,2580,2581>,<2579,2581,2582>,<2579,2582,2580>,
    /*1*/ <2580,2583,2581>,<2581,2583,2584>,<2581,2584,2582>,<2582,2584,2585>,<2582,2585,2580>,
            <2580,2585,2583>,
    /*2*/ <2583,2586,2584>,<2584,2586,2587>,<2584,2587,2585>,<2585,2587,2588>,<2585,2588,2583>,
            <2583,2588,2586>,
    /*3*/ <2586,2589,2587>,<2587,2589,2588>,<2588,2589,2586>

    /* stem 0.6.25*/ 
    /*0*/ <2590,2591,2592>,<2590,2592,2593>,<2590,2593,2591>,
    /*1*/ <2591,2594,2592>,<2592,2594,2595>,<2592,2595,2593>,<2593,2595,2596>,<2593,2596,2591>,
            <2591,2596,2594>,
    /*2*/ <2594,2597,2595>,<2595,2597,2598>,<2595,2598,2596>,<2596,2598,2599>,<2596,2599,2594>,
            <2594,2599,2597>,
    /*3*/ <2597,2600,2598>,<2598,2600,2599>,<2599,2600,2597>

    /* stem 0.6.26*/ 
    /*0*/ <2601,2602,2603>,<2601,2603,2604>,<2601,2604,2602>,
    /*1*/ <2602,2605,2603>,<2603,2605,2606>,<2603,2606,2604>,<2604,2606,2607>,<2604,2607,2602>,
            <2602,2607,2605>,
    /*2*/ <2605,2608,2606>,<2606,2608,2609>,<2606,2609,2607>,<2607,2609,2610>,<2607,2610,2605>,
            <2605,2610,2608>,
    /*3*/ <2608,2611,2609>,<2609,2611,2610>,<2610,2611,2608>

    /* stem 0.6.27*/ 
    /*0*/ <2612,2613,2614>,<2612,2614,2615>,<2612,2615,2613>,
    /*1*/ <2613,2616,2614>,<2614,2616,2617>,<2614,2617,2615>,<2615,2617,2618>,<2615,2618,2613>,
            <2613,2618,2616>,
    /*2*/ <2616,2619,2617>,<2617,2619,2620>,<2617,2620,2618>,<2618,2620,2621>,<2618,2621,2616>,
            <2616,2621,2619>,
    /*3*/ <2619,2622,2620>,<2620,2622,2621>,<2621,2622,2619>

    /* stem 0.6.28*/ 
    /*0*/ <2623,2624,2625>,<2623,2625,2626>,<2623,2626,2624>,
    /*1*/ <2624,2627,2625>,<2625,2627,2628>,<2625,2628,2626>,<2626,2628,2629>,<2626,2629,2624>,
            <2624,2629,2627>,
    /*2*/ <2627,2630,2628>,<2628,2630,2631>,<2628,2631,2629>,<2629,2631,2632>,<2629,2632,2627>,
            <2627,2632,2630>,
    /*3*/ <2630,2633,2631>,<2631,2633,2632>,<2632,2633,2630>

    /* stem 0.7*/ 
    /*0*/ <2634,2635,2636>,<2634,2636,2637>,<2634,2637,2638>,<2634,2638,2639>,<2634,2639,2635>,
            
    /*1*/ <2635,2640,2636>,<2636,2640,2641>,<2636,2641,2637>,<2637,2641,2642>,<2637,2642,2638>,
            <2638,2642,2643>,<2638,2643,2639>,<2639,2643,2644>,<2639,2644,2635>,<2635,2644,2640>,
    /*2*/ <2640,2645,2641>,<2641,2645,2646>,<2641,2646,2642>,<2642,2646,2647>,<2642,2647,2643>,
            <2643,2647,2648>,<2643,2648,2644>,<2644,2648,2649>,<2644,2649,2640>,<2640,2649,2645>,
    /*3*/ <2645,2650,2646>,<2646,2650,2647>,<2647,2650,2648>,<2648,2650,2649>,<2649,2650,2645>
            

    /* stem 0.7.0*/ 
    /*0*/ <2651,2652,2653>,<2651,2653,2654>,<2651,2654,2652>,
    /*1*/ <2652,2655,2653>,<2653,2655,2656>,<2653,2656,2654>,<2654,2656,2657>,<2654,2657,2652>,
            <2652,2657,2655>,
    /*2*/ <2655,2658,2656>,<2656,2658,2659>,<2656,2659,2657>,<2657,2659,2660>,<2657,2660,2655>,
            <2655,2660,2658>,
    /*3*/ <2658,2661,2659>,<2659,2661,2660>,<2660,2661,2658>

    /* stem 0.7.1*/ 
    /*0*/ <2662,2663,2664>,<2662,2664,2665>,<2662,2665,2663>,
    /*1*/ <2663,2666,2664>,<2664,2666,2667>,<2664,2667,2665>,<2665,2667,2668>,<2665,2668,2663>,
            <2663,2668,2666>,
    /*2*/ <2666,2669,2667>,<2667,2669,2670>,<2667,2670,2668>,<2668,2670,2671>,<2668,2671,2666>,
            <2666,2671,2669>,
    /*3*/ <2669,2672,2670>,<2670,2672,2671>,<2671,2672,2669>

    /* stem 0.7.2*/ 
    /*0*/ <2673,2674,2675>,<2673,2675,2676>,<2673,2676,2674>,
    /*1*/ <2674,2677,2675>,<2675,2677,2678>,<2675,2678,2676>,<2676,2678,2679>,<2676,2679,2674>,
            <2674,2679,2677>,
    /*2*/ <2677,2680,2678>,<2678,2680,2681>,<2678,2681,2679>,<2679,2681,2682>,<2679,2682,2677>,
            <2677,2682,2680>,
    /*3*/ <2680,2683,2681>,<2681,2683,2682>,<2682,2683,2680>

    /* stem 0.7.3*/ 
    /*0*/ <2684,2685,2686>,<2684,2686,2687>,<2684,2687,2685>,
    /*1*/ <2685,2688,2686>,<2686,2688,2689>,<2686,2689,2687>,<2687,2689,2690>,<2687,2690,2685>,
            <2685,2690,2688>,
    /*2*/ <2688,2691,2689>,<2689,2691,2692>,<2689,2692,2690>,<2690,2692,2693>,<2690,2693,2688>,
            <2688,2693,2691>,
    /*3*/ <2691,2694,2692>,<2692,2694,2693>,<2693,2694,2691>

    /* stem 0.7.4*/ 
    /*0*/ <2695,2696,2697>,<2695,2697,2698>,<2695,2698,2696>,
    /*1*/ <2696,2699,2697>,<2697,2699,2700>,<2697,2700,2698>,<2698,2700,2701>,<2698,2701,2696>,
            <2696,2701,2699>,
    /*2*/ <2699,2702,2700>,<2700,2702,2703>,<2700,2703,2701>,<2701,2703,2704>,<2701,2704,2699>,
            <2699,2704,2702>,
    /*3*/ <2702,2705,2703>,<2703,2705,2704>,<2704,2705,2702>

    /* stem 0.7.5*/ 
    /*0*/ <2706,2707,2708>,<2706,2708,2709>,<2706,2709,2707>,
    /*1*/ <2707,2710,2708>,<2708,2710,2711>,<2708,2711,2709>,<2709,2711,2712>,<2709,2712,2707>,
            <2707,2712,2710>,
    /*2*/ <2710,2713,2711>,<2711,2713,2714>,<2711,2714,2712>,<2712,2714,2715>,<2712,2715,2710>,
            <2710,2715,2713>,
    /*3*/ <2713,2716,2714>,<2714,2716,2715>,<2715,2716,2713>

    /* stem 0.7.6*/ 
    /*0*/ <2717,2718,2719>,<2717,2719,2720>,<2717,2720,2718>,
    /*1*/ <2718,2721,2719>,<2719,2721,2722>,<2719,2722,2720>,<2720,2722,2723>,<2720,2723,2718>,
            <2718,2723,2721>,
    /*2*/ <2721,2724,2722>,<2722,2724,2725>,<2722,2725,2723>,<2723,2725,2726>,<2723,2726,2721>,
            <2721,2726,2724>,
    /*3*/ <2724,2727,2725>,<2725,2727,2726>,<2726,2727,2724>

    /* stem 0.7.7*/ 
    /*0*/ <2728,2729,2730>,<2728,2730,2731>,<2728,2731,2729>,
    /*1*/ <2729,2732,2730>,<2730,2732,2733>,<2730,2733,2731>,<2731,2733,2734>,<2731,2734,2729>,
            <2729,2734,2732>,
    /*2*/ <2732,2735,2733>,<2733,2735,2736>,<2733,2736,2734>,<2734,2736,2737>,<2734,2737,2732>,
            <2732,2737,2735>,
    /*3*/ <2735,2738,2736>,<2736,2738,2737>,<2737,2738,2735>

    /* stem 0.7.8*/ 
    /*0*/ <2739,2740,2741>,<2739,2741,2742>,<2739,2742,2740>,
    /*1*/ <2740,2743,2741>,<2741,2743,2744>,<2741,2744,2742>,<2742,2744,2745>,<2742,2745,2740>,
            <2740,2745,2743>,
    /*2*/ <2743,2746,2744>,<2744,2746,2747>,<2744,2747,2745>,<2745,2747,2748>,<2745,2748,2743>,
            <2743,2748,2746>,
    /*3*/ <2746,2749,2747>,<2747,2749,2748>,<2748,2749,2746>

    /* stem 0.7.9*/ 
    /*0*/ <2750,2751,2752>,<2750,2752,2753>,<2750,2753,2751>,
    /*1*/ <2751,2754,2752>,<2752,2754,2755>,<2752,2755,2753>,<2753,2755,2756>,<2753,2756,2751>,
            <2751,2756,2754>,
    /*2*/ <2754,2757,2755>,<2755,2757,2758>,<2755,2758,2756>,<2756,2758,2759>,<2756,2759,2754>,
            <2754,2759,2757>,
    /*3*/ <2757,2760,2758>,<2758,2760,2759>,<2759,2760,2757>

    /* stem 0.7.10*/ 
    /*0*/ <2761,2762,2763>,<2761,2763,2764>,<2761,2764,2762>,
    /*1*/ <2762,2765,2763>,<2763,2765,2766>,<2763,2766,2764>,<2764,2766,2767>,<2764,2767,2762>,
            <2762,2767,2765>,
    /*2*/ <2765,2768,2766>,<2766,2768,2769>,<2766,2769,2767>,<2767,2769,2770>,<2767,2770,2765>,
            <2765,2770,2768>,
    /*3*/ <2768,2771,2769>,<2769,2771,2770>,<2770,2771,2768>

    /* stem 0.7.11*/ 
    /*0*/ <2772,2773,2774>,<2772,2774,2775>,<2772,2775,2773>,
    /*1*/ <2773,2776,2774>,<2774,2776,2777>,<2774,2777,2775>,<2775,2777,2778>,<2775,2778,2773>,
            <2773,2778,2776>,
    /*2*/ <2776,2779,2777>,<2777,2779,2780>,<2777,2780,2778>,<2778,2780,2781>,<2778,2781,2776>,
            <2776,2781,2779>,
    /*3*/ <2779,2782,2780>,<2780,2782,2781>,<2781,2782,2779>

    /* stem 0.7.12*/ 
    /*0*/ <2783,2784,2785>,<2783,2785,2786>,<2783,2786,2784>,
    /*1*/ <2784,2787,2785>,<2785,2787,2788>,<2785,2788,2786>,<2786,2788,2789>,<2786,2789,2784>,
            <2784,2789,2787>,
    /*2*/ <2787,2790,2788>,<2788,2790,2791>,<2788,2791,2789>,<2789,2791,2792>,<2789,2792,2787>,
            <2787,2792,2790>,
    /*3*/ <2790,2793,2791>,<2791,2793,2792>,<2792,2793,2790>

    /* stem 0.7.13*/ 
    /*0*/ <2794,2795,2796>,<2794,2796,2797>,<2794,2797,2795>,
    /*1*/ <2795,2798,2796>,<2796,2798,2799>,<2796,2799,2797>,<2797,2799,2800>,<2797,2800,2795>,
            <2795,2800,2798>,
    /*2*/ <2798,2801,2799>,<2799,2801,2802>,<2799,2802,2800>,<2800,2802,2803>,<2800,2803,2798>,
            <2798,2803,2801>,
    /*3*/ <2801,2804,2802>,<2802,2804,2803>,<2803,2804,2801>

    /* stem 0.7.14*/ 
    /*0*/ <2805,2806,2807>,<2805,2807,2808>,<2805,2808,2806>,
    /*1*/ <2806,2809,2807>,<2807,2809,2810>,<2807,2810,2808>,<2808,2810,2811>,<2808,2811,2806>,
            <2806,2811,2809>,
    /*2*/ <2809,2812,2810>,<2810,2812,2813>,<2810,2813,2811>,<2811,2813,2814>,<2811,2814,2809>,
            <2809,2814,2812>,
    /*3*/ <2812,2815,2813>,<2813,2815,2814>,<2814,2815,2812>

    /* stem 0.7.15*/ 
    /*0*/ <2816,2817,2818>,<2816,2818,2819>,<2816,2819,2817>,
    /*1*/ <2817,2820,2818>,<2818,2820,2821>,<2818,2821,2819>,<2819,2821,2822>,<2819,2822,2817>,
            <2817,2822,2820>,
    /*2*/ <2820,2823,2821>,<2821,2823,2824>,<2821,2824,2822>,<2822,2824,2825>,<2822,2825,2820>,
            <2820,2825,2823>,
    /*3*/ <2823,2826,2824>,<2824,2826,2825>,<2825,2826,2823>

    /* stem 0.7.16*/ 
    /*0*/ <2827,2828,2829>,<2827,2829,2830>,<2827,2830,2828>,
    /*1*/ <2828,2831,2829>,<2829,2831,2832>,<2829,2832,2830>,<2830,2832,2833>,<2830,2833,2828>,
            <2828,2833,2831>,
    /*2*/ <2831,2834,2832>,<2832,2834,2835>,<2832,2835,2833>,<2833,2835,2836>,<2833,2836,2831>,
            <2831,2836,2834>,
    /*3*/ <2834,2837,2835>,<2835,2837,2836>,<2836,2837,2834>

    /* stem 0.7.17*/ 
    /*0*/ <2838,2839,2840>,<2838,2840,2841>,<2838,2841,2839>,
    /*1*/ <2839,2842,2840>,<2840,2842,2843>,<2840,2843,2841>,<2841,2843,2844>,<2841,2844,2839>,
            <2839,2844,2842>,
    /*2*/ <2842,2845,2843>,<2843,2845,2846>,<2843,2846,2844>,<2844,2846,2847>,<2844,2847,2842>,
            <2842,2847,2845>,
    /*3*/ <2845,2848,2846>,<2846,2848,2847>,<2847,2848,2845>

    /* stem 0.7.18*/ 
    /*0*/ <2849,2850,2851>,<2849,2851,2852>,<2849,2852,2850>,
    /*1*/ <2850,2853,2851>,<2851,2853,2854>,<2851,2854,2852>,<2852,2854,2855>,<2852,2855,2850>,
            <2850,2855,2853>,
    /*2*/ <2853,2856,2854>,<2854,2856,2857>,<2854,2857,2855>,<2855,2857,2858>,<2855,2858,2853>,
            <2853,2858,2856>,
    /*3*/ <2856,2859,2857>,<2857,2859,2858>,<2858,2859,2856>

    /* stem 0.7.19*/ 
    /*0*/ <2860,2861,2862>,<2860,2862,2863>,<2860,2863,2861>,
    /*1*/ <2861,2864,2862>,<2862,2864,2865>,<2862,2865,2863>,<2863,2865,2866>,<2863,2866,2861>,
            <2861,2866,2864>,
    /*2*/ <2864,2867,2865>,<2865,2867,2868>,<2865,2868,2866>,<2866,2868,2869>,<2866,2869,2864>,
            <2864,2869,2867>,
    /*3*/ <2867,2870,2868>,<2868,2870,2869>,<2869,2870,2867>

    /* stem 0.7.20*/ 
    /*0*/ <2871,2872,2873>,<2871,2873,2874>,<2871,2874,2872>,
    /*1*/ <2872,2875,2873>,<2873,2875,2876>,<2873,2876,2874>,<2874,2876,2877>,<2874,2877,2872>,
            <2872,2877,2875>,
    /*2*/ <2875,2878,2876>,<2876,2878,2879>,<2876,2879,2877>,<2877,2879,2880>,<2877,2880,2875>,
            <2875,2880,2878>,
    /*3*/ <2878,2881,2879>,<2879,2881,2880>,<2880,2881,2878>

    /* stem 0.7.21*/ 
    /*0*/ <2882,2883,2884>,<2882,2884,2885>,<2882,2885,2883>,
    /*1*/ <2883,2886,2884>,<2884,2886,2887>,<2884,2887,2885>,<2885,2887,2888>,<2885,2888,2883>,
            <2883,2888,2886>,
    /*2*/ <2886,2889,2887>,<2887,2889,2890>,<2887,2890,2888>,<2888,2890,2891>,<2888,2891,2886>,
            <2886,2891,2889>,
    /*3*/ <2889,2892,2890>,<2890,2892,2891>,<2891,2892,2889>

    /* stem 0.7.22*/ 
    /*0*/ <2893,2894,2895>,<2893,2895,2896>,<2893,2896,2894>,
    /*1*/ <2894,2897,2895>,<2895,2897,2898>,<2895,2898,2896>,<2896,2898,2899>,<2896,2899,2894>,
            <2894,2899,2897>,
    /*2*/ <2897,2900,2898>,<2898,2900,2901>,<2898,2901,2899>,<2899,2901,2902>,<2899,2902,2897>,
            <2897,2902,2900>,
    /*3*/ <2900,2903,2901>,<2901,2903,2902>,<2902,2903,2900>

    /* stem 0.7.23*/ 
    /*0*/ <2904,2905,2906>,<2904,2906,2907>,<2904,2907,2905>,
    /*1*/ <2905,2908,2906>,<2906,2908,2909>,<2906,2909,2907>,<2907,2909,2910>,<2907,2910,2905>,
            <2905,2910,2908>,
    /*2*/ <2908,2911,2909>,<2909,2911,2912>,<2909,2912,2910>,<2910,2912,2913>,<2910,2913,2908>,
            <2908,2913,2911>,
    /*3*/ <2911,2914,2912>,<2912,2914,2913>,<2913,2914,2911>

    /* stem 0.7.24*/ 
    /*0*/ <2915,2916,2917>,<2915,2917,2918>,<2915,2918,2916>,
    /*1*/ <2916,2919,2917>,<2917,2919,2920>,<2917,2920,2918>,<2918,2920,2921>,<2918,2921,2916>,
            <2916,2921,2919>,
    /*2*/ <2919,2922,2920>,<2920,2922,2923>,<2920,2923,2921>,<2921,2923,2924>,<2921,2924,2919>,
            <2919,2924,2922>,
    /*3*/ <2922,2925,2923>,<2923,2925,2924>,<2924,2925,2922>

    /* stem 0.7.25*/ 
    /*0*/ <2926,2927,2928>,<2926,2928,2929>,<2926,2929,2927>,
    /*1*/ <2927,2930,2928>,<2928,2930,2931>,<2928,2931,2929>,<2929,2931,2932>,<2929,2932,2927>,
            <2927,2932,2930>,
    /*2*/ <2930,2933,2931>,<2931,2933,2934>,<2931,2934,2932>,<2932,2934,2935>,<2932,2935,2930>,
            <2930,2935,2933>,
    /*3*/ <2933,2936,2934>,<2934,2936,2935>,<2935,2936,2933>

    /* stem 0.7.26*/ 
    /*0*/ <2937,2938,2939>,<2937,2939,2940>,<2937,2940,2938>,
    /*1*/ <2938,2941,2939>,<2939,2941,2942>,<2939,2942,2940>,<2940,2942,2943>,<2940,2943,2938>,
            <2938,2943,2941>,
    /*2*/ <2941,2944,2942>,<2942,2944,2945>,<2942,2945,2943>,<2943,2945,2946>,<2943,2946,2941>,
            <2941,2946,2944>,
    /*3*/ <2944,2947,2945>,<2945,2947,2946>,<2946,2947,2944>

    /* stem 0.7.27*/ 
    /*0*/ <2948,2949,2950>,<2948,2950,2951>,<2948,2951,2949>,
    /*1*/ <2949,2952,2950>,<2950,2952,2953>,<2950,2953,2951>,<2951,2953,2954>,<2951,2954,2949>,
            <2949,2954,2952>,
    /*2*/ <2952,2955,2953>,<2953,2955,2956>,<2953,2956,2954>,<2954,2956,2957>,<2954,2957,2952>,
            <2952,2957,2955>,
    /*3*/ <2955,2958,2956>,<2956,2958,2957>,<2957,2958,2955>

    /* stem 0.7.28*/ 
    /*0*/ <2959,2960,2961>,<2959,2961,2962>,<2959,2962,2960>,
    /*1*/ <2960,2963,2961>,<2961,2963,2964>,<2961,2964,2962>,<2962,2964,2965>,<2962,2965,2960>,
            <2960,2965,2963>,
    /*2*/ <2963,2966,2964>,<2964,2966,2967>,<2964,2967,2965>,<2965,2967,2968>,<2965,2968,2963>,
            <2963,2968,2966>,
    /*3*/ <2966,2969,2967>,<2967,2969,2968>,<2968,2969,2966>

    /* stem 0.8*/ 
    /*0*/ <2970,2971,2972>,<2970,2972,2973>,<2970,2973,2974>,<2970,2974,2975>,<2970,2975,2971>,
            
    /*1*/ <2971,2976,2972>,<2972,2976,2977>,<2972,2977,2973>,<2973,2977,2978>,<2973,2978,2974>,
            <2974,2978,2979>,<2974,2979,2975>,<2975,2979,2980>,<2975,2980,2971>,<2971,2980,2976>,
    /*2*/ <2976,2981,2977>,<2977,2981,2982>,<2977,2982,2978>,<2978,2982,2983>,<2978,2983,2979>,
            <2979,2983,2984>,<2979,2984,2980>,<2980,2984,2985>,<2980,2985,2976>,<2976,2985,2981>,
    /*3*/ <2981,2986,2982>,<2982,2986,2983>,<2983,2986,2984>,<2984,2986,2985>,<2985,2986,2981>
            

    /* stem 0.8.0*/ 
    /*0*/ <2987,2988,2989>,<2987,2989,2990>,<2987,2990,2988>,
    /*1*/ <2988,2991,2989>,<2989,2991,2992>,<2989,2992,2990>,<2990,2992,2993>,<2990,2993,2988>,
            <2988,2993,2991>,
    /*2*/ <2991,2994,2992>,<2992,2994,2995>,<2992,2995,2993>,<2993,2995,2996>,<2993,2996,2991>,
            <2991,2996,2994>,
    /*3*/ <2994,2997,2995>,<2995,2997,2996>,<2996,2997,2994>

    /* stem 0.8.1*/ 
    /*0*/ <2998,2999,3000>,<2998,3000,3001>,<2998,3001,2999>,
    /*1*/ <2999,3002,3000>,<3000,3002,3003>,<3000,3003,3001>,<3001,3003,3004>,<3001,3004,2999>,
            <2999,3004,3002>,
    /*2*/ <3002,3005,3003>,<3003,3005,3006>,<3003,3006,3004>,<3004,3006,3007>,<3004,3007,3002>,
            <3002,3007,3005>,
    /*3*/ <3005,3008,3006>,<3006,3008,3007>,<3007,3008,3005>

    /* stem 0.8.2*/ 
    /*0*/ <3009,3010,3011>,<3009,3011,3012>,<3009,3012,3010>,
    /*1*/ <3010,3013,3011>,<3011,3013,3014>,<3011,3014,3012>,<3012,3014,3015>,<3012,3015,3010>,
            <3010,3015,3013>,
    /*2*/ <3013,3016,3014>,<3014,3016,3017>,<3014,3017,3015>,<3015,3017,3018>,<3015,3018,3013>,
            <3013,3018,3016>,
    /*3*/ <3016,3019,3017>,<3017,3019,3018>,<3018,3019,3016>

    /* stem 0.8.3*/ 
    /*0*/ <3020,3021,3022>,<3020,3022,3023>,<3020,3023,3021>,
    /*1*/ <3021,3024,3022>,<3022,3024,3025>,<3022,3025,3023>,<3023,3025,3026>,<3023,3026,3021>,
            <3021,3026,3024>,
    /*2*/ <3024,3027,3025>,<3025,3027,3028>,<3025,3028,3026>,<3026,3028,3029>,<3026,3029,3024>,
            <3024,3029,3027>,
    /*3*/ <3027,3030,3028>,<3028,3030,3029>,<3029,3030,3027>

    /* stem 0.8.4*/ 
    /*0*/ <3031,3032,3033>,<3031,3033,3034>,<3031,3034,3032>,
    /*1*/ <3032,3035,3033>,<3033,3035,3036>,<3033,3036,3034>,<3034,3036,3037>,<3034,3037,3032>,
            <3032,3037,3035>,
    /*2*/ <3035,3038,3036>,<3036,3038,3039>,<3036,3039,3037>,<3037,3039,3040>,<3037,3040,3035>,
            <3035,3040,3038>,
    /*3*/ <3038,3041,3039>,<3039,3041,3040>,<3040,3041,3038>

    /* stem 0.8.5*/ 
    /*0*/ <3042,3043,3044>,<3042,3044,3045>,<3042,3045,3043>,
    /*1*/ <3043,3046,3044>,<3044,3046,3047>,<3044,3047,3045>,<3045,3047,3048>,<3045,3048,3043>,
            <3043,3048,3046>,
    /*2*/ <3046,3049,3047>,<3047,3049,3050>,<3047,3050,3048>,<3048,3050,3051>,<3048,3051,3046>,
            <3046,3051,3049>,
    /*3*/ <3049,3052,3050>,<3050,3052,3051>,<3051,3052,3049>

    /* stem 0.8.6*/ 
    /*0*/ <3053,3054,3055>,<3053,3055,3056>,<3053,3056,3054>,
    /*1*/ <3054,3057,3055>,<3055,3057,3058>,<3055,3058,3056>,<3056,3058,3059>,<3056,3059,3054>,
            <3054,3059,3057>,
    /*2*/ <3057,3060,3058>,<3058,3060,3061>,<3058,3061,3059>,<3059,3061,3062>,<3059,3062,3057>,
            <3057,3062,3060>,
    /*3*/ <3060,3063,3061>,<3061,3063,3062>,<3062,3063,3060>

    /* stem 0.8.7*/ 
    /*0*/ <3064,3065,3066>,<3064,3066,3067>,<3064,3067,3065>,
    /*1*/ <3065,3068,3066>,<3066,3068,3069>,<3066,3069,3067>,<3067,3069,3070>,<3067,3070,3065>,
            <3065,3070,3068>,
    /*2*/ <3068,3071,3069>,<3069,3071,3072>,<3069,3072,3070>,<3070,3072,3073>,<3070,3073,3068>,
            <3068,3073,3071>,
    /*3*/ <3071,3074,3072>,<3072,3074,3073>,<3073,3074,3071>

    /* stem 0.8.8*/ 
    /*0*/ <3075,3076,3077>,<3075,3077,3078>,<3075,3078,3076>,
    /*1*/ <3076,3079,3077>,<3077,3079,3080>,<3077,3080,3078>,<3078,3080,3081>,<3078,3081,3076>,
            <3076,3081,3079>,
    /*2*/ <3079,3082,3080>,<3080,3082,3083>,<3080,3083,3081>,<3081,3083,3084>,<3081,3084,3079>,
            <3079,3084,3082>,
    /*3*/ <3082,3085,3083>,<3083,3085,3084>,<3084,3085,3082>

    /* stem 0.8.9*/ 
    /*0*/ <3086,3087,3088>,<3086,3088,3089>,<3086,3089,3087>,
    /*1*/ <3087,3090,3088>,<3088,3090,3091>,<3088,3091,3089>,<3089,3091,3092>,<3089,3092,3087>,
            <3087,3092,3090>,
    /*2*/ <3090,3093,3091>,<3091,3093,3094>,<3091,3094,3092>,<3092,3094,3095>,<3092,3095,3090>,
            <3090,3095,3093>,
    /*3*/ <3093,3096,3094>,<3094,3096,3095>,<3095,3096,3093>

    /* stem 0.8.10*/ 
    /*0*/ <3097,3098,3099>,<3097,3099,3100>,<3097,3100,3098>,
    /*1*/ <3098,3101,3099>,<3099,3101,3102>,<3099,3102,3100>,<3100,3102,3103>,<3100,3103,3098>,
            <3098,3103,3101>,
    /*2*/ <3101,3104,3102>,<3102,3104,3105>,<3102,3105,3103>,<3103,3105,3106>,<3103,3106,3101>,
            <3101,3106,3104>,
    /*3*/ <3104,3107,3105>,<3105,3107,3106>,<3106,3107,3104>

    /* stem 0.8.11*/ 
    /*0*/ <3108,3109,3110>,<3108,3110,3111>,<3108,3111,3109>,
    /*1*/ <3109,3112,3110>,<3110,3112,3113>,<3110,3113,3111>,<3111,3113,3114>,<3111,3114,3109>,
            <3109,3114,3112>,
    /*2*/ <3112,3115,3113>,<3113,3115,3116>,<3113,3116,3114>,<3114,3116,3117>,<3114,3117,3112>,
            <3112,3117,3115>,
    /*3*/ <3115,3118,3116>,<3116,3118,3117>,<3117,3118,3115>

    /* stem 0.8.12*/ 
    /*0*/ <3119,3120,3121>,<3119,3121,3122>,<3119,3122,3120>,
    /*1*/ <3120,3123,3121>,<3121,3123,3124>,<3121,3124,3122>,<3122,3124,3125>,<3122,3125,3120>,
            <3120,3125,3123>,
    /*2*/ <3123,3126,3124>,<3124,3126,3127>,<3124,3127,3125>,<3125,3127,3128>,<3125,3128,3123>,
            <3123,3128,3126>,
    /*3*/ <3126,3129,3127>,<3127,3129,3128>,<3128,3129,3126>

    /* stem 0.8.13*/ 
    /*0*/ <3130,3131,3132>,<3130,3132,3133>,<3130,3133,3131>,
    /*1*/ <3131,3134,3132>,<3132,3134,3135>,<3132,3135,3133>,<3133,3135,3136>,<3133,3136,3131>,
            <3131,3136,3134>,
    /*2*/ <3134,3137,3135>,<3135,3137,3138>,<3135,3138,3136>,<3136,3138,3139>,<3136,3139,3134>,
            <3134,3139,3137>,
    /*3*/ <3137,3140,3138>,<3138,3140,3139>,<3139,3140,3137>

    /* stem 0.8.14*/ 
    /*0*/ <3141,3142,3143>,<3141,3143,3144>,<3141,3144,3142>,
    /*1*/ <3142,3145,3143>,<3143,3145,3146>,<3143,3146,3144>,<3144,3146,3147>,<3144,3147,3142>,
            <3142,3147,3145>,
    /*2*/ <3145,3148,3146>,<3146,3148,3149>,<3146,3149,3147>,<3147,3149,3150>,<3147,3150,3145>,
            <3145,3150,3148>,
    /*3*/ <3148,3151,3149>,<3149,3151,3150>,<3150,3151,3148>

    /* stem 0.8.15*/ 
    /*0*/ <3152,3153,3154>,<3152,3154,3155>,<3152,3155,3153>,
    /*1*/ <3153,3156,3154>,<3154,3156,3157>,<3154,3157,3155>,<3155,3157,3158>,<3155,3158,3153>,
            <3153,3158,3156>,
    /*2*/ <3156,3159,3157>,<3157,3159,3160>,<3157,3160,3158>,<3158,3160,3161>,<3158,3161,3156>,
            <3156,3161,3159>,
    /*3*/ <3159,3162,3160>,<3160,3162,3161>,<3161,3162,3159>

    /* stem 0.8.16*/ 
    /*0*/ <3163,3164,3165>,<3163,3165,3166>,<3163,3166,3164>,
    /*1*/ <3164,3167,3165>,<3165,3167,3168>,<3165,3168,3166>,<3166,3168,3169>,<3166,3169,3164>,
            <3164,3169,3167>,
    /*2*/ <3167,3170,3168>,<3168,3170,3171>,<3168,3171,3169>,<3169,3171,3172>,<3169,3172,3167>,
            <3167,3172,3170>,
    /*3*/ <3170,3173,3171>,<3171,3173,3172>,<3172,3173,3170>

    /* stem 0.8.17*/ 
    /*0*/ <3174,3175,3176>,<3174,3176,3177>,<3174,3177,3175>,
    /*1*/ <3175,3178,3176>,<3176,3178,3179>,<3176,3179,3177>,<3177,3179,3180>,<3177,3180,3175>,
            <3175,3180,3178>,
    /*2*/ <3178,3181,3179>,<3179,3181,3182>,<3179,3182,3180>,<3180,3182,3183>,<3180,3183,3178>,
            <3178,3183,3181>,
    /*3*/ <3181,3184,3182>,<3182,3184,3183>,<3183,3184,3181>

    /* stem 0.8.18*/ 
    /*0*/ <3185,3186,3187>,<3185,3187,3188>,<3185,3188,3186>,
    /*1*/ <3186,3189,3187>,<3187,3189,3190>,<3187,3190,3188>,<3188,3190,3191>,<3188,3191,3186>,
            <3186,3191,3189>,
    /*2*/ <3189,3192,3190>,<3190,3192,3193>,<3190,3193,3191>,<3191,3193,3194>,<3191,3194,3189>,
            <3189,3194,3192>,
    /*3*/ <3192,3195,3193>,<3193,3195,3194>,<3194,3195,3192>

    /* stem 0.8.19*/ 
    /*0*/ <3196,3197,3198>,<3196,3198,3199>,<3196,3199,3197>,
    /*1*/ <3197,3200,3198>,<3198,3200,3201>,<3198,3201,3199>,<3199,3201,3202>,<3199,3202,3197>,
            <3197,3202,3200>,
    /*2*/ <3200,3203,3201>,<3201,3203,3204>,<3201,3204,3202>,<3202,3204,3205>,<3202,3205,3200>,
            <3200,3205,3203>,
    /*3*/ <3203,3206,3204>,<3204,3206,3205>,<3205,3206,3203>

    /* stem 0.8.20*/ 
    /*0*/ <3207,3208,3209>,<3207,3209,3210>,<3207,3210,3208>,
    /*1*/ <3208,3211,3209>,<3209,3211,3212>,<3209,3212,3210>,<3210,3212,3213>,<3210,3213,3208>,
            <3208,3213,3211>,
    /*2*/ <3211,3214,3212>,<3212,3214,3215>,<3212,3215,3213>,<3213,3215,3216>,<3213,3216,3211>,
            <3211,3216,3214>,
    /*3*/ <3214,3217,3215>,<3215,3217,3216>,<3216,3217,3214>

    /* stem 0.8.21*/ 
    /*0*/ <3218,3219,3220>,<3218,3220,3221>,<3218,3221,3219>,
    /*1*/ <3219,3222,3220>,<3220,3222,3223>,<3220,3223,3221>,<3221,3223,3224>,<3221,3224,3219>,
            <3219,3224,3222>,
    /*2*/ <3222,3225,3223>,<3223,3225,3226>,<3223,3226,3224>,<3224,3226,3227>,<3224,3227,3222>,
            <3222,3227,3225>,
    /*3*/ <3225,3228,3226>,<3226,3228,3227>,<3227,3228,3225>

    /* stem 0.8.22*/ 
    /*0*/ <3229,3230,3231>,<3229,3231,3232>,<3229,3232,3230>,
    /*1*/ <3230,3233,3231>,<3231,3233,3234>,<3231,3234,3232>,<3232,3234,3235>,<3232,3235,3230>,
            <3230,3235,3233>,
    /*2*/ <3233,3236,3234>,<3234,3236,3237>,<3234,3237,3235>,<3235,3237,3238>,<3235,3238,3233>,
            <3233,3238,3236>,
    /*3*/ <3236,3239,3237>,<3237,3239,3238>,<3238,3239,3236>

    /* stem 0.8.23*/ 
    /*0*/ <3240,3241,3242>,<3240,3242,3243>,<3240,3243,3241>,
    /*1*/ <3241,3244,3242>,<3242,3244,3245>,<3242,3245,3243>,<3243,3245,3246>,<3243,3246,3241>,
            <3241,3246,3244>,
    /*2*/ <3244,3247,3245>,<3245,3247,3248>,<3245,3248,3246>,<3246,3248,3249>,<3246,3249,3244>,
            <3244,3249,3247>,
    /*3*/ <3247,3250,3248>,<3248,3250,3249>,<3249,3250,3247>

    /* stem 0.8.24*/ 
    /*0*/ <3251,3252,3253>,<3251,3253,3254>,<3251,3254,3252>,
    /*1*/ <3252,3255,3253>,<3253,3255,3256>,<3253,3256,3254>,<3254,3256,3257>,<3254,3257,3252>,
            <3252,3257,3255>,
    /*2*/ <3255,3258,3256>,<3256,3258,3259>,<3256,3259,3257>,<3257,3259,3260>,<3257,3260,3255>,
            <3255,3260,3258>,
    /*3*/ <3258,3261,3259>,<3259,3261,3260>,<3260,3261,3258>

    /* stem 0.8.25*/ 
    /*0*/ <3262,3263,3264>,<3262,3264,3265>,<3262,3265,3263>,
    /*1*/ <3263,3266,3264>,<3264,3266,3267>,<3264,3267,3265>,<3265,3267,3268>,<3265,3268,3263>,
            <3263,3268,3266>,
    /*2*/ <3266,3269,3267>,<3267,3269,3270>,<3267,3270,3268>,<3268,3270,3271>,<3268,3271,3266>,
            <3266,3271,3269>,
    /*3*/ <3269,3272,3270>,<3270,3272,3271>,<3271,3272,3269>

    /* stem 0.8.26*/ 
    /*0*/ <3273,3274,3275>,<3273,3275,3276>,<3273,3276,3274>,
    /*1*/ <3274,3277,3275>,<3275,3277,3278>,<3275,3278,3276>,<3276,3278,3279>,<3276,3279,3274>,
            <3274,3279,3277>,
    /*2*/ <3277,3280,3278>,<3278,3280,3281>,<3278,3281,3279>,<3279,3281,3282>,<3279,3282,3277>,
            <3277,3282,3280>,
    /*3*/ <3280,3283,3281>,<3281,3283,3282>,<3282,3283,3280>

    /* stem 0.8.27*/ 
    /*0*/ <3284,3285,3286>,<3284,3286,3287>,<3284,3287,3285>,
    /*1*/ <3285,3288,3286>,<3286,3288,3289>,<3286,3289,3287>,<3287,3289,3290>,<3287,3290,3285>,
            <3285,3290,3288>,
    /*2*/ <3288,3291,3289>,<3289,3291,3292>,<3289,3292,3290>,<3290,3292,3293>,<3290,3293,3288>,
            <3288,3293,3291>,
    /*3*/ <3291,3294,3292>,<3292,3294,3293>,<3293,3294,3291>

    /* stem 0.9*/ 
    /*0*/ <3295,3296,3297>,<3295,3297,3298>,<3295,3298,3299>,<3295,3299,3300>,<3295,3300,3296>,
            
    /*1*/ <3296,3301,3297>,<3297,3301,3302>,<3297,3302,3298>,<3298,3302,3303>,<3298,3303,3299>,
            <3299,3303,3304>,<3299,3304,3300>,<3300,3304,3305>,<3300,3305,3296>,<3296,3305,3301>,
    /*2*/ <3301,3306,3302>,<3302,3306,3307>,<3302,3307,3303>,<3303,3307,3308>,<3303,3308,3304>,
            <3304,3308,3309>,<3304,3309,3305>,<3305,3309,3310>,<3305,3310,3301>,<3301,3310,3306>,
    /*3*/ <3306,3311,3307>,<3307,3311,3308>,<3308,3311,3309>,<3309,3311,3310>,<3310,3311,3306>
            

    /* stem 0.9.0*/ 
    /*0*/ <3312,3313,3314>,<3312,3314,3315>,<3312,3315,3313>,
    /*1*/ <3313,3316,3314>,<3314,3316,3317>,<3314,3317,3315>,<3315,3317,3318>,<3315,3318,3313>,
            <3313,3318,3316>,
    /*2*/ <3316,3319,3317>,<3317,3319,3320>,<3317,3320,3318>,<3318,3320,3321>,<3318,3321,3316>,
            <3316,3321,3319>,
    /*3*/ <3319,3322,3320>,<3320,3322,3321>,<3321,3322,3319>

    /* stem 0.9.1*/ 
    /*0*/ <3323,3324,3325>,<3323,3325,3326>,<3323,3326,3324>,
    /*1*/ <3324,3327,3325>,<3325,3327,3328>,<3325,3328,3326>,<3326,3328,3329>,<3326,3329,3324>,
            <3324,3329,3327>,
    /*2*/ <3327,3330,3328>,<3328,3330,3331>,<3328,3331,3329>,<3329,3331,3332>,<3329,3332,3327>,
            <3327,3332,3330>,
    /*3*/ <3330,3333,3331>,<3331,3333,3332>,<3332,3333,3330>

    /* stem 0.9.2*/ 
    /*0*/ <3334,3335,3336>,<3334,3336,3337>,<3334,3337,3335>,
    /*1*/ <3335,3338,3336>,<3336,3338,3339>,<3336,3339,3337>,<3337,3339,3340>,<3337,3340,3335>,
            <3335,3340,3338>,
    /*2*/ <3338,3341,3339>,<3339,3341,3342>,<3339,3342,3340>,<3340,3342,3343>,<3340,3343,3338>,
            <3338,3343,3341>,
    /*3*/ <3341,3344,3342>,<3342,3344,3343>,<3343,3344,3341>

    /* stem 0.9.3*/ 
    /*0*/ <3345,3346,3347>,<3345,3347,3348>,<3345,3348,3346>,
    /*1*/ <3346,3349,3347>,<3347,3349,3350>,<3347,3350,3348>,<3348,3350,3351>,<3348,3351,3346>,
            <3346,3351,3349>,
    /*2*/ <3349,3352,3350>,<3350,3352,3353>,<3350,3353,3351>,<3351,3353,3354>,<3351,3354,3349>,
            <3349,3354,3352>,
    /*3*/ <3352,3355,3353>,<3353,3355,3354>,<3354,3355,3352>

    /* stem 0.9.4*/ 
    /*0*/ <3356,3357,3358>,<3356,3358,3359>,<3356,3359,3357>,
    /*1*/ <3357,3360,3358>,<3358,3360,3361>,<3358,3361,3359>,<3359,3361,3362>,<3359,3362,3357>,
            <3357,3362,3360>,
    /*2*/ <3360,3363,3361>,<3361,3363,3364>,<3361,3364,3362>,<3362,3364,3365>,<3362,3365,3360>,
            <3360,3365,3363>,
    /*3*/ <3363,3366,3364>,<3364,3366,3365>,<3365,3366,3363>

    /* stem 0.9.5*/ 
    /*0*/ <3367,3368,3369>,<3367,3369,3370>,<3367,3370,3368>,
    /*1*/ <3368,3371,3369>,<3369,3371,3372>,<3369,3372,3370>,<3370,3372,3373>,<3370,3373,3368>,
            <3368,3373,3371>,
    /*2*/ <3371,3374,3372>,<3372,3374,3375>,<3372,3375,3373>,<3373,3375,3376>,<3373,3376,3371>,
            <3371,3376,3374>,
    /*3*/ <3374,3377,3375>,<3375,3377,3376>,<3376,3377,3374>

    /* stem 0.9.6*/ 
    /*0*/ <3378,3379,3380>,<3378,3380,3381>,<3378,3381,3379>,
    /*1*/ <3379,3382,3380>,<3380,3382,3383>,<3380,3383,3381>,<3381,3383,3384>,<3381,3384,3379>,
            <3379,3384,3382>,
    /*2*/ <3382,3385,3383>,<3383,3385,3386>,<3383,3386,3384>,<3384,3386,3387>,<3384,3387,3382>,
            <3382,3387,3385>,
    /*3*/ <3385,3388,3386>,<3386,3388,3387>,<3387,3388,3385>

    /* stem 0.9.7*/ 
    /*0*/ <3389,3390,3391>,<3389,3391,3392>,<3389,3392,3390>,
    /*1*/ <3390,3393,3391>,<3391,3393,3394>,<3391,3394,3392>,<3392,3394,3395>,<3392,3395,3390>,
            <3390,3395,3393>,
    /*2*/ <3393,3396,3394>,<3394,3396,3397>,<3394,3397,3395>,<3395,3397,3398>,<3395,3398,3393>,
            <3393,3398,3396>,
    /*3*/ <3396,3399,3397>,<3397,3399,3398>,<3398,3399,3396>

    /* stem 0.9.8*/ 
    /*0*/ <3400,3401,3402>,<3400,3402,3403>,<3400,3403,3401>,
    /*1*/ <3401,3404,3402>,<3402,3404,3405>,<3402,3405,3403>,<3403,3405,3406>,<3403,3406,3401>,
            <3401,3406,3404>,
    /*2*/ <3404,3407,3405>,<3405,3407,3408>,<3405,3408,3406>,<3406,3408,3409>,<3406,3409,3404>,
            <3404,3409,3407>,
    /*3*/ <3407,3410,3408>,<3408,3410,3409>,<3409,3410,3407>

    /* stem 0.9.9*/ 
    /*0*/ <3411,3412,3413>,<3411,3413,3414>,<3411,3414,3412>,
    /*1*/ <3412,3415,3413>,<3413,3415,3416>,<3413,3416,3414>,<3414,3416,3417>,<3414,3417,3412>,
            <3412,3417,3415>,
    /*2*/ <3415,3418,3416>,<3416,3418,3419>,<3416,3419,3417>,<3417,3419,3420>,<3417,3420,3415>,
            <3415,3420,3418>,
    /*3*/ <3418,3421,3419>,<3419,3421,3420>,<3420,3421,3418>

    /* stem 0.9.10*/ 
    /*0*/ <3422,3423,3424>,<3422,3424,3425>,<3422,3425,3423>,
    /*1*/ <3423,3426,3424>,<3424,3426,3427>,<3424,3427,3425>,<3425,3427,3428>,<3425,3428,3423>,
            <3423,3428,3426>,
    /*2*/ <3426,3429,3427>,<3427,3429,3430>,<3427,3430,3428>,<3428,3430,3431>,<3428,3431,3426>,
            <3426,3431,3429>,
    /*3*/ <3429,3432,3430>,<3430,3432,3431>,<3431,3432,3429>

    /* stem 0.9.11*/ 
    /*0*/ <3433,3434,3435>,<3433,3435,3436>,<3433,3436,3434>,
    /*1*/ <3434,3437,3435>,<3435,3437,3438>,<3435,3438,3436>,<3436,3438,3439>,<3436,3439,3434>,
            <3434,3439,3437>,
    /*2*/ <3437,3440,3438>,<3438,3440,3441>,<3438,3441,3439>,<3439,3441,3442>,<3439,3442,3437>,
            <3437,3442,3440>,
    /*3*/ <3440,3443,3441>,<3441,3443,3442>,<3442,3443,3440>

    /* stem 0.9.12*/ 
    /*0*/ <3444,3445,3446>,<3444,3446,3447>,<3444,3447,3445>,
    /*1*/ <3445,3448,3446>,<3446,3448,3449>,<3446,3449,3447>,<3447,3449,3450>,<3447,3450,3445>,
            <3445,3450,3448>,
    /*2*/ <3448,3451,3449>,<3449,3451,3452>,<3449,3452,3450>,<3450,3452,3453>,<3450,3453,3448>,
            <3448,3453,3451>,
    /*3*/ <3451,3454,3452>,<3452,3454,3453>,<3453,3454,3451>

    /* stem 0.9.13*/ 
    /*0*/ <3455,3456,3457>,<3455,3457,3458>,<3455,3458,3456>,
    /*1*/ <3456,3459,3457>,<3457,3459,3460>,<3457,3460,3458>,<3458,3460,3461>,<3458,3461,3456>,
            <3456,3461,3459>,
    /*2*/ <3459,3462,3460>,<3460,3462,3463>,<3460,3463,3461>,<3461,3463,3464>,<3461,3464,3459>,
            <3459,3464,3462>,
    /*3*/ <3462,3465,3463>,<3463,3465,3464>,<3464,3465,3462>

    /* stem 0.9.14*/ 
    /*0*/ <3466,3467,3468>,<3466,3468,3469>,<3466,3469,3467>,
    /*1*/ <3467,3470,3468>,<3468,3470,3471>,<3468,3471,3469>,<3469,3471,3472>,<3469,3472,3467>,
            <3467,3472,3470>,
    /*2*/ <3470,3473,3471>,<3471,3473,3474>,<3471,3474,3472>,<3472,3474,3475>,<3472,3475,3470>,
            <3470,3475,3473>,
    /*3*/ <3473,3476,3474>,<3474,3476,3475>,<3475,3476,3473>

    /* stem 0.9.15*/ 
    /*0*/ <3477,3478,3479>,<3477,3479,3480>,<3477,3480,3478>,
    /*1*/ <3478,3481,3479>,<3479,3481,3482>,<3479,3482,3480>,<3480,3482,3483>,<3480,3483,3478>,
            <3478,3483,3481>,
    /*2*/ <3481,3484,3482>,<3482,3484,3485>,<3482,3485,3483>,<3483,3485,3486>,<3483,3486,3481>,
            <3481,3486,3484>,
    /*3*/ <3484,3487,3485>,<3485,3487,3486>,<3486,3487,3484>

    /* stem 0.9.16*/ 
    /*0*/ <3488,3489,3490>,<3488,3490,3491>,<3488,3491,3489>,
    /*1*/ <3489,3492,3490>,<3490,3492,3493>,<3490,3493,3491>,<3491,3493,3494>,<3491,3494,3489>,
            <3489,3494,3492>,
    /*2*/ <3492,3495,3493>,<3493,3495,3496>,<3493,3496,3494>,<3494,3496,3497>,<3494,3497,3492>,
            <3492,3497,3495>,
    /*3*/ <3495,3498,3496>,<3496,3498,3497>,<3497,3498,3495>

    /* stem 0.9.17*/ 
    /*0*/ <3499,3500,3501>,<3499,3501,3502>,<3499,3502,3500>,
    /*1*/ <3500,3503,3501>,<3501,3503,3504>,<3501,3504,3502>,<3502,3504,3505>,<3502,3505,3500>,
            <3500,3505,3503>,
    /*2*/ <3503,3506,3504>,<3504,3506,3507>,<3504,3507,3505>,<3505,3507,3508>,<3505,3508,3503>,
            <3503,3508,3506>,
    /*3*/ <3506,3509,3507>,<3507,3509,3508>,<3508,3509,3506>

    /* stem 0.9.18*/ 
    /*0*/ <3510,3511,3512>,<3510,3512,3513>,<3510,3513,3511>,
    /*1*/ <3511,3514,3512>,<3512,3514,3515>,<3512,3515,3513>,<3513,3515,3516>,<3513,3516,3511>,
            <3511,3516,3514>,
    /*2*/ <3514,3517,3515>,<3515,3517,3518>,<3515,3518,3516>,<3516,3518,3519>,<3516,3519,3514>,
            <3514,3519,3517>,
    /*3*/ <3517,3520,3518>,<3518,3520,3519>,<3519,3520,3517>

    /* stem 0.9.19*/ 
    /*0*/ <3521,3522,3523>,<3521,3523,3524>,<3521,3524,3522>,
    /*1*/ <3522,3525,3523>,<3523,3525,3526>,<3523,3526,3524>,<3524,3526,3527>,<3524,3527,3522>,
            <3522,3527,3525>,
    /*2*/ <3525,3528,3526>,<3526,3528,3529>,<3526,3529,3527>,<3527,3529,3530>,<3527,3530,3525>,
            <3525,3530,3528>,
    /*3*/ <3528,3531,3529>,<3529,3531,3530>,<3530,3531,3528>

    /* stem 0.9.20*/ 
    /*0*/ <3532,3533,3534>,<3532,3534,3535>,<3532,3535,3533>,
    /*1*/ <3533,3536,3534>,<3534,3536,3537>,<3534,3537,3535>,<3535,3537,3538>,<3535,3538,3533>,
            <3533,3538,3536>,
    /*2*/ <3536,3539,3537>,<3537,3539,3540>,<3537,3540,3538>,<3538,3540,3541>,<3538,3541,3536>,
            <3536,3541,3539>,
    /*3*/ <3539,3542,3540>,<3540,3542,3541>,<3541,3542,3539>

    /* stem 0.9.21*/ 
    /*0*/ <3543,3544,3545>,<3543,3545,3546>,<3543,3546,3544>,
    /*1*/ <3544,3547,3545>,<3545,3547,3548>,<3545,3548,3546>,<3546,3548,3549>,<3546,3549,3544>,
            <3544,3549,3547>,
    /*2*/ <3547,3550,3548>,<3548,3550,3551>,<3548,3551,3549>,<3549,3551,3552>,<3549,3552,3547>,
            <3547,3552,3550>,
    /*3*/ <3550,3553,3551>,<3551,3553,3552>,<3552,3553,3550>

    /* stem 0.9.22*/ 
    /*0*/ <3554,3555,3556>,<3554,3556,3557>,<3554,3557,3555>,
    /*1*/ <3555,3558,3556>,<3556,3558,3559>,<3556,3559,3557>,<3557,3559,3560>,<3557,3560,3555>,
            <3555,3560,3558>,
    /*2*/ <3558,3561,3559>,<3559,3561,3562>,<3559,3562,3560>,<3560,3562,3563>,<3560,3563,3558>,
            <3558,3563,3561>,
    /*3*/ <3561,3564,3562>,<3562,3564,3563>,<3563,3564,3561>

    /* stem 0.9.23*/ 
    /*0*/ <3565,3566,3567>,<3565,3567,3568>,<3565,3568,3566>,
    /*1*/ <3566,3569,3567>,<3567,3569,3570>,<3567,3570,3568>,<3568,3570,3571>,<3568,3571,3566>,
            <3566,3571,3569>,
    /*2*/ <3569,3572,3570>,<3570,3572,3573>,<3570,3573,3571>,<3571,3573,3574>,<3571,3574,3569>,
            <3569,3574,3572>,
    /*3*/ <3572,3575,3573>,<3573,3575,3574>,<3574,3575,3572>

    /* stem 0.9.24*/ 
    /*0*/ <3576,3577,3578>,<3576,3578,3579>,<3576,3579,3577>,
    /*1*/ <3577,3580,3578>,<3578,3580,3581>,<3578,3581,3579>,<3579,3581,3582>,<3579,3582,3577>,
            <3577,3582,3580>,
    /*2*/ <3580,3583,3581>,<3581,3583,3584>,<3581,3584,3582>,<3582,3584,3585>,<3582,3585,3580>,
            <3580,3585,3583>,
    /*3*/ <3583,3586,3584>,<3584,3586,3585>,<3585,3586,3583>

    /* stem 0.9.25*/ 
    /*0*/ <3587,3588,3589>,<3587,3589,3590>,<3587,3590,3588>,
    /*1*/ <3588,3591,3589>,<3589,3591,3592>,<3589,3592,3590>,<3590,3592,3593>,<3590,3593,3588>,
            <3588,3593,3591>,
    /*2*/ <3591,3594,3592>,<3592,3594,3595>,<3592,3595,3593>,<3593,3595,3596>,<3593,3596,3591>,
            <3591,3596,3594>,
    /*3*/ <3594,3597,3595>,<3595,3597,3596>,<3596,3597,3594>

    /* stem 0.9.26*/ 
    /*0*/ <3598,3599,3600>,<3598,3600,3601>,<3598,3601,3599>,
    /*1*/ <3599,3602,3600>,<3600,3602,3603>,<3600,3603,3601>,<3601,3603,3604>,<3601,3604,3599>,
            <3599,3604,3602>,
    /*2*/ <3602,3605,3603>,<3603,3605,3606>,<3603,3606,3604>,<3604,3606,3607>,<3604,3607,3602>,
            <3602,3607,3605>,
    /*3*/ <3605,3608,3606>,<3606,3608,3607>,<3607,3608,3605>

    /* stem 0.9.27*/ 
    /*0*/ <3609,3610,3611>,<3609,3611,3612>,<3609,3612,3610>,
    /*1*/ <3610,3613,3611>,<3611,3613,3614>,<3611,3614,3612>,<3612,3614,3615>,<3612,3615,3610>,
            <3610,3615,3613>,
    /*2*/ <3613,3616,3614>,<3614,3616,3617>,<3614,3617,3615>,<3615,3617,3618>,<3615,3618,3613>,
            <3613,3618,3616>,
    /*3*/ <3616,3619,3617>,<3617,3619,3618>,<3618,3619,3616>

    /* stem 0.10*/ 
    /*0*/ <3620,3621,3622>,<3620,3622,3623>,<3620,3623,3624>,<3620,3624,3625>,<3620,3625,3621>,
            
    /*1*/ <3621,3626,3622>,<3622,3626,3627>,<3622,3627,3623>,<3623,3627,3628>,<3623,3628,3624>,
            <3624,3628,3629>,<3624,3629,3625>,<3625,3629,3630>,<3625,3630,3621>,<3621,3630,3626>,
    /*2*/ <3626,3631,3627>,<3627,3631,3632>,<3627,3632,3628>,<3628,3632,3633>,<3628,3633,3629>,
            <3629,3633,3634>,<3629,3634,3630>,<3630,3634,3635>,<3630,3635,3626>,<3626,3635,3631>,
    /*3*/ <3631,3636,3632>,<3632,3636,3633>,<3633,3636,3634>,<3634,3636,3635>,<3635,3636,3631>
            

    /* stem 0.10.0*/ 
    /*0*/ <3637,3638,3639>,<3637,3639,3640>,<3637,3640,3638>,
    /*1*/ <3638,3641,3639>,<3639,3641,3642>,<3639,3642,3640>,<3640,3642,3643>,<3640,3643,3638>,
            <3638,3643,3641>,
    /*2*/ <3641,3644,3642>,<3642,3644,3645>,<3642,3645,3643>,<3643,3645,3646>,<3643,3646,3641>,
            <3641,3646,3644>,
    /*3*/ <3644,3647,3645>,<3645,3647,3646>,<3646,3647,3644>

    /* stem 0.10.1*/ 
    /*0*/ <3648,3649,3650>,<3648,3650,3651>,<3648,3651,3649>,
    /*1*/ <3649,3652,3650>,<3650,3652,3653>,<3650,3653,3651>,<3651,3653,3654>,<3651,3654,3649>,
            <3649,3654,3652>,
    /*2*/ <3652,3655,3653>,<3653,3655,3656>,<3653,3656,3654>,<3654,3656,3657>,<3654,3657,3652>,
            <3652,3657,3655>,
    /*3*/ <3655,3658,3656>,<3656,3658,3657>,<3657,3658,3655>

    /* stem 0.10.2*/ 
    /*0*/ <3659,3660,3661>,<3659,3661,3662>,<3659,3662,3660>,
    /*1*/ <3660,3663,3661>,<3661,3663,3664>,<3661,3664,3662>,<3662,3664,3665>,<3662,3665,3660>,
            <3660,3665,3663>,
    /*2*/ <3663,3666,3664>,<3664,3666,3667>,<3664,3667,3665>,<3665,3667,3668>,<3665,3668,3663>,
            <3663,3668,3666>,
    /*3*/ <3666,3669,3667>,<3667,3669,3668>,<3668,3669,3666>

    /* stem 0.10.3*/ 
    /*0*/ <3670,3671,3672>,<3670,3672,3673>,<3670,3673,3671>,
    /*1*/ <3671,3674,3672>,<3672,3674,3675>,<3672,3675,3673>,<3673,3675,3676>,<3673,3676,3671>,
            <3671,3676,3674>,
    /*2*/ <3674,3677,3675>,<3675,3677,3678>,<3675,3678,3676>,<3676,3678,3679>,<3676,3679,3674>,
            <3674,3679,3677>,
    /*3*/ <3677,3680,3678>,<3678,3680,3679>,<3679,3680,3677>

    /* stem 0.10.4*/ 
    /*0*/ <3681,3682,3683>,<3681,3683,3684>,<3681,3684,3682>,
    /*1*/ <3682,3685,3683>,<3683,3685,3686>,<3683,3686,3684>,<3684,3686,3687>,<3684,3687,3682>,
            <3682,3687,3685>,
    /*2*/ <3685,3688,3686>,<3686,3688,3689>,<3686,3689,3687>,<3687,3689,3690>,<3687,3690,3685>,
            <3685,3690,3688>,
    /*3*/ <3688,3691,3689>,<3689,3691,3690>,<3690,3691,3688>

    /* stem 0.10.5*/ 
    /*0*/ <3692,3693,3694>,<3692,3694,3695>,<3692,3695,3693>,
    /*1*/ <3693,3696,3694>,<3694,3696,3697>,<3694,3697,3695>,<3695,3697,3698>,<3695,3698,3693>,
            <3693,3698,3696>,
    /*2*/ <3696,3699,3697>,<3697,3699,3700>,<3697,3700,3698>,<3698,3700,3701>,<3698,3701,3696>,
            <3696,3701,3699>,
    /*3*/ <3699,3702,3700>,<3700,3702,3701>,<3701,3702,3699>

    /* stem 0.10.6*/ 
    /*0*/ <3703,3704,3705>,<3703,3705,3706>,<3703,3706,3704>,
    /*1*/ <3704,3707,3705>,<3705,3707,3708>,<3705,3708,3706>,<3706,3708,3709>,<3706,3709,3704>,
            <3704,3709,3707>,
    /*2*/ <3707,3710,3708>,<3708,3710,3711>,<3708,3711,3709>,<3709,3711,3712>,<3709,3712,3707>,
            <3707,3712,3710>,
    /*3*/ <3710,3713,3711>,<3711,3713,3712>,<3712,3713,3710>

    /* stem 0.10.7*/ 
    /*0*/ <3714,3715,3716>,<3714,3716,3717>,<3714,3717,3715>,
    /*1*/ <3715,3718,3716>,<3716,3718,3719>,<3716,3719,3717>,<3717,3719,3720>,<3717,3720,3715>,
            <3715,3720,3718>,
    /*2*/ <3718,3721,3719>,<3719,3721,3722>,<3719,3722,3720>,<3720,3722,3723>,<3720,3723,3718>,
            <3718,3723,3721>,
    /*3*/ <3721,3724,3722>,<3722,3724,3723>,<3723,3724,3721>

    /* stem 0.10.8*/ 
    /*0*/ <3725,3726,3727>,<3725,3727,3728>,<3725,3728,3726>,
    /*1*/ <3726,3729,3727>,<3727,3729,3730>,<3727,3730,3728>,<3728,3730,3731>,<3728,3731,3726>,
            <3726,3731,3729>,
    /*2*/ <3729,3732,3730>,<3730,3732,3733>,<3730,3733,3731>,<3731,3733,3734>,<3731,3734,3729>,
            <3729,3734,3732>,
    /*3*/ <3732,3735,3733>,<3733,3735,3734>,<3734,3735,3732>

    /* stem 0.10.9*/ 
    /*0*/ <3736,3737,3738>,<3736,3738,3739>,<3736,3739,3737>,
    /*1*/ <3737,3740,3738>,<3738,3740,3741>,<3738,3741,3739>,<3739,3741,3742>,<3739,3742,3737>,
            <3737,3742,3740>,
    /*2*/ <3740,3743,3741>,<3741,3743,3744>,<3741,3744,3742>,<3742,3744,3745>,<3742,3745,3740>,
            <3740,3745,3743>,
    /*3*/ <3743,3746,3744>,<3744,3746,3745>,<3745,3746,3743>

    /* stem 0.10.10*/ 
    /*0*/ <3747,3748,3749>,<3747,3749,3750>,<3747,3750,3748>,
    /*1*/ <3748,3751,3749>,<3749,3751,3752>,<3749,3752,3750>,<3750,3752,3753>,<3750,3753,3748>,
            <3748,3753,3751>,
    /*2*/ <3751,3754,3752>,<3752,3754,3755>,<3752,3755,3753>,<3753,3755,3756>,<3753,3756,3751>,
            <3751,3756,3754>,
    /*3*/ <3754,3757,3755>,<3755,3757,3756>,<3756,3757,3754>

    /* stem 0.10.11*/ 
    /*0*/ <3758,3759,3760>,<3758,3760,3761>,<3758,3761,3759>,
    /*1*/ <3759,3762,3760>,<3760,3762,3763>,<3760,3763,3761>,<3761,3763,3764>,<3761,3764,3759>,
            <3759,3764,3762>,
    /*2*/ <3762,3765,3763>,<3763,3765,3766>,<3763,3766,3764>,<3764,3766,3767>,<3764,3767,3762>,
            <3762,3767,3765>,
    /*3*/ <3765,3768,3766>,<3766,3768,3767>,<3767,3768,3765>

    /* stem 0.10.12*/ 
    /*0*/ <3769,3770,3771>,<3769,3771,3772>,<3769,3772,3770>,
    /*1*/ <3770,3773,3771>,<3771,3773,3774>,<3771,3774,3772>,<3772,3774,3775>,<3772,3775,3770>,
            <3770,3775,3773>,
    /*2*/ <3773,3776,3774>,<3774,3776,3777>,<3774,3777,3775>,<3775,3777,3778>,<3775,3778,3773>,
            <3773,3778,3776>,
    /*3*/ <3776,3779,3777>,<3777,3779,3778>,<3778,3779,3776>

    /* stem 0.10.13*/ 
    /*0*/ <3780,3781,3782>,<3780,3782,3783>,<3780,3783,3781>,
    /*1*/ <3781,3784,3782>,<3782,3784,3785>,<3782,3785,3783>,<3783,3785,3786>,<3783,3786,3781>,
            <3781,3786,3784>,
    /*2*/ <3784,3787,3785>,<3785,3787,3788>,<3785,3788,3786>,<3786,3788,3789>,<3786,3789,3784>,
            <3784,3789,3787>,
    /*3*/ <3787,3790,3788>,<3788,3790,3789>,<3789,3790,3787>

    /* stem 0.10.14*/ 
    /*0*/ <3791,3792,3793>,<3791,3793,3794>,<3791,3794,3792>,
    /*1*/ <3792,3795,3793>,<3793,3795,3796>,<3793,3796,3794>,<3794,3796,3797>,<3794,3797,3792>,
            <3792,3797,3795>,
    /*2*/ <3795,3798,3796>,<3796,3798,3799>,<3796,3799,3797>,<3797,3799,3800>,<3797,3800,3795>,
            <3795,3800,3798>,
    /*3*/ <3798,3801,3799>,<3799,3801,3800>,<3800,3801,3798>

    /* stem 0.10.15*/ 
    /*0*/ <3802,3803,3804>,<3802,3804,3805>,<3802,3805,3803>,
    /*1*/ <3803,3806,3804>,<3804,3806,3807>,<3804,3807,3805>,<3805,3807,3808>,<3805,3808,3803>,
            <3803,3808,3806>,
    /*2*/ <3806,3809,3807>,<3807,3809,3810>,<3807,3810,3808>,<3808,3810,3811>,<3808,3811,3806>,
            <3806,3811,3809>,
    /*3*/ <3809,3812,3810>,<3810,3812,3811>,<3811,3812,3809>

    /* stem 0.10.16*/ 
    /*0*/ <3813,3814,3815>,<3813,3815,3816>,<3813,3816,3814>,
    /*1*/ <3814,3817,3815>,<3815,3817,3818>,<3815,3818,3816>,<3816,3818,3819>,<3816,3819,3814>,
            <3814,3819,3817>,
    /*2*/ <3817,3820,3818>,<3818,3820,3821>,<3818,3821,3819>,<3819,3821,3822>,<3819,3822,3817>,
            <3817,3822,3820>,
    /*3*/ <3820,3823,3821>,<3821,3823,3822>,<3822,3823,3820>

    /* stem 0.10.17*/ 
    /*0*/ <3824,3825,3826>,<3824,3826,3827>,<3824,3827,3825>,
    /*1*/ <3825,3828,3826>,<3826,3828,3829>,<3826,3829,3827>,<3827,3829,3830>,<3827,3830,3825>,
            <3825,3830,3828>,
    /*2*/ <3828,3831,3829>,<3829,3831,3832>,<3829,3832,3830>,<3830,3832,3833>,<3830,3833,3828>,
            <3828,3833,3831>,
    /*3*/ <3831,3834,3832>,<3832,3834,3833>,<3833,3834,3831>

    /* stem 0.10.18*/ 
    /*0*/ <3835,3836,3837>,<3835,3837,3838>,<3835,3838,3836>,
    /*1*/ <3836,3839,3837>,<3837,3839,3840>,<3837,3840,3838>,<3838,3840,3841>,<3838,3841,3836>,
            <3836,3841,3839>,
    /*2*/ <3839,3842,3840>,<3840,3842,3843>,<3840,3843,3841>,<3841,3843,3844>,<3841,3844,3839>,
            <3839,3844,3842>,
    /*3*/ <3842,3845,3843>,<3843,3845,3844>,<3844,3845,3842>

    /* stem 0.10.19*/ 
    /*0*/ <3846,3847,3848>,<3846,3848,3849>,<3846,3849,3847>,
    /*1*/ <3847,3850,3848>,<3848,3850,3851>,<3848,3851,3849>,<3849,3851,3852>,<3849,3852,3847>,
            <3847,3852,3850>,
    /*2*/ <3850,3853,3851>,<3851,3853,3854>,<3851,3854,3852>,<3852,3854,3855>,<3852,3855,3850>,
            <3850,3855,3853>,
    /*3*/ <3853,3856,3854>,<3854,3856,3855>,<3855,3856,3853>

    /* stem 0.10.20*/ 
    /*0*/ <3857,3858,3859>,<3857,3859,3860>,<3857,3860,3858>,
    /*1*/ <3858,3861,3859>,<3859,3861,3862>,<3859,3862,3860>,<3860,3862,3863>,<3860,3863,3858>,
            <3858,3863,3861>,
    /*2*/ <3861,3864,3862>,<3862,3864,3865>,<3862,3865,3863>,<3863,3865,3866>,<3863,3866,3861>,
            <3861,3866,3864>,
    /*3*/ <3864,3867,3865>,<3865,3867,3866>,<3866,3867,3864>

    /* stem 0.10.21*/ 
    /*0*/ <3868,3869,3870>,<3868,3870,3871>,<3868,3871,3869>,
    /*1*/ <3869,3872,3870>,<3870,3872,3873>,<3870,3873,3871>,<3871,3873,3874>,<3871,3874,3869>,
            <3869,3874,3872>,
    /*2*/ <3872,3875,3873>,<3873,3875,3876>,<3873,3876,3874>,<3874,3876,3877>,<3874,3877,3872>,
            <3872,3877,3875>,
    /*3*/ <3875,3878,3876>,<3876,3878,3877>,<3877,3878,3875>

    /* stem 0.10.22*/ 
    /*0*/ <3879,3880,3881>,<3879,3881,3882>,<3879,3882,3880>,
    /*1*/ <3880,3883,3881>,<3881,3883,3884>,<3881,3884,3882>,<3882,3884,3885>,<3882,3885,3880>,
            <3880,3885,3883>,
    /*2*/ <3883,3886,3884>,<3884,3886,3887>,<3884,3887,3885>,<3885,3887,3888>,<3885,3888,3883>,
            <3883,3888,3886>,
    /*3*/ <3886,3889,3887>,<3887,3889,3888>,<3888,3889,3886>

    /* stem 0.10.23*/ 
    /*0*/ <3890,3891,3892>,<3890,3892,3893>,<3890,3893,3891>,
    /*1*/ <3891,3894,3892>,<3892,3894,3895>,<3892,3895,3893>,<3893,3895,3896>,<3893,3896,3891>,
            <3891,3896,3894>,
    /*2*/ <3894,3897,3895>,<3895,3897,3898>,<3895,3898,3896>,<3896,3898,3899>,<3896,3899,3894>,
            <3894,3899,3897>,
    /*3*/ <3897,3900,3898>,<3898,3900,3899>,<3899,3900,3897>

    /* stem 0.10.24*/ 
    /*0*/ <3901,3902,3903>,<3901,3903,3904>,<3901,3904,3902>,
    /*1*/ <3902,3905,3903>,<3903,3905,3906>,<3903,3906,3904>,<3904,3906,3907>,<3904,3907,3902>,
            <3902,3907,3905>,
    /*2*/ <3905,3908,3906>,<3906,3908,3909>,<3906,3909,3907>,<3907,3909,3910>,<3907,3910,3905>,
            <3905,3910,3908>,
    /*3*/ <3908,3911,3909>,<3909,3911,3910>,<3910,3911,3908>

    /* stem 0.10.25*/ 
    /*0*/ <3912,3913,3914>,<3912,3914,3915>,<3912,3915,3913>,
    /*1*/ <3913,3916,3914>,<3914,3916,3917>,<3914,3917,3915>,<3915,3917,3918>,<3915,3918,3913>,
            <3913,3918,3916>,
    /*2*/ <3916,3919,3917>,<3917,3919,3920>,<3917,3920,3918>,<3918,3920,3921>,<3918,3921,3916>,
            <3916,3921,3919>,
    /*3*/ <3919,3922,3920>,<3920,3922,3921>,<3921,3922,3919>

    /* stem 0.10.26*/ 
    /*0*/ <3923,3924,3925>,<3923,3925,3926>,<3923,3926,3924>,
    /*1*/ <3924,3927,3925>,<3925,3927,3928>,<3925,3928,3926>,<3926,3928,3929>,<3926,3929,3924>,
            <3924,3929,3927>,
    /*2*/ <3927,3930,3928>,<3928,3930,3931>,<3928,3931,3929>,<3929,3931,3932>,<3929,3932,3927>,
            <3927,3932,3930>,
    /*3*/ <3930,3933,3931>,<3931,3933,3932>,<3932,3933,3930>

    /* stem 0.10.27*/ 
    /*0*/ <3934,3935,3936>,<3934,3936,3937>,<3934,3937,3935>,
    /*1*/ <3935,3938,3936>,<3936,3938,3939>,<3936,3939,3937>,<3937,3939,3940>,<3937,3940,3935>,
            <3935,3940,3938>,
    /*2*/ <3938,3941,3939>,<3939,3941,3942>,<3939,3942,3940>,<3940,3942,3943>,<3940,3943,3938>,
            <3938,3943,3941>,
    /*3*/ <3941,3944,3942>,<3942,3944,3943>,<3943,3944,3941>

    /* stem 0.11*/ 
    /*0*/ <3945,3946,3947>,<3945,3947,3948>,<3945,3948,3949>,<3945,3949,3950>,<3945,3950,3946>,
            
    /*1*/ <3946,3951,3947>,<3947,3951,3952>,<3947,3952,3948>,<3948,3952,3953>,<3948,3953,3949>,
            <3949,3953,3954>,<3949,3954,3950>,<3950,3954,3955>,<3950,3955,3946>,<3946,3955,3951>,
    /*2*/ <3951,3956,3952>,<3952,3956,3957>,<3952,3957,3953>,<3953,3957,3958>,<3953,3958,3954>,
            <3954,3958,3959>,<3954,3959,3955>,<3955,3959,3960>,<3955,3960,3951>,<3951,3960,3956>,
    /*3*/ <3956,3961,3957>,<3957,3961,3958>,<3958,3961,3959>,<3959,3961,3960>,<3960,3961,3956>
            

    /* stem 0.11.0*/ 
    /*0*/ <3962,3963,3964>,<3962,3964,3965>,<3962,3965,3963>,
    /*1*/ <3963,3966,3964>,<3964,3966,3967>,<3964,3967,3965>,<3965,3967,3968>,<3965,3968,3963>,
            <3963,3968,3966>,
    /*2*/ <3966,3969,3967>,<3967,3969,3970>,<3967,3970,3968>,<3968,3970,3971>,<3968,3971,3966>,
            <3966,3971,3969>,
    /*3*/ <3969,3972,3970>,<3970,3972,3971>,<3971,3972,3969>

    /* stem 0.11.1*/ 
    /*0*/ <3973,3974,3975>,<3973,3975,3976>,<3973,3976,3974>,
    /*1*/ <3974,3977,3975>,<3975,3977,3978>,<3975,3978,3976>,<3976,3978,3979>,<3976,3979,3974>,
            <3974,3979,3977>,
    /*2*/ <3977,3980,3978>,<3978,3980,3981>,<3978,3981,3979>,<3979,3981,3982>,<3979,3982,3977>,
            <3977,3982,3980>,
    /*3*/ <3980,3983,3981>,<3981,3983,3982>,<3982,3983,3980>

    /* stem 0.11.2*/ 
    /*0*/ <3984,3985,3986>,<3984,3986,3987>,<3984,3987,3985>,
    /*1*/ <3985,3988,3986>,<3986,3988,3989>,<3986,3989,3987>,<3987,3989,3990>,<3987,3990,3985>,
            <3985,3990,3988>,
    /*2*/ <3988,3991,3989>,<3989,3991,3992>,<3989,3992,3990>,<3990,3992,3993>,<3990,3993,3988>,
            <3988,3993,3991>,
    /*3*/ <3991,3994,3992>,<3992,3994,3993>,<3993,3994,3991>

    /* stem 0.11.3*/ 
    /*0*/ <3995,3996,3997>,<3995,3997,3998>,<3995,3998,3996>,
    /*1*/ <3996,3999,3997>,<3997,3999,4000>,<3997,4000,3998>,<3998,4000,4001>,<3998,4001,3996>,
            <3996,4001,3999>,
    /*2*/ <3999,4002,4000>,<4000,4002,4003>,<4000,4003,4001>,<4001,4003,4004>,<4001,4004,3999>,
            <3999,4004,4002>,
    /*3*/ <4002,4005,4003>,<4003,4005,4004>,<4004,4005,4002>

    /* stem 0.11.4*/ 
    /*0*/ <4006,4007,4008>,<4006,4008,4009>,<4006,4009,4007>,
    /*1*/ <4007,4010,4008>,<4008,4010,4011>,<4008,4011,4009>,<4009,4011,4012>,<4009,4012,4007>,
            <4007,4012,4010>,
    /*2*/ <4010,4013,4011>,<4011,4013,4014>,<4011,4014,4012>,<4012,4014,4015>,<4012,4015,4010>,
            <4010,4015,4013>,
    /*3*/ <4013,4016,4014>,<4014,4016,4015>,<4015,4016,4013>

    /* stem 0.11.5*/ 
    /*0*/ <4017,4018,4019>,<4017,4019,4020>,<4017,4020,4018>,
    /*1*/ <4018,4021,4019>,<4019,4021,4022>,<4019,4022,4020>,<4020,4022,4023>,<4020,4023,4018>,
            <4018,4023,4021>,
    /*2*/ <4021,4024,4022>,<4022,4024,4025>,<4022,4025,4023>,<4023,4025,4026>,<4023,4026,4021>,
            <4021,4026,4024>,
    /*3*/ <4024,4027,4025>,<4025,4027,4026>,<4026,4027,4024>

    /* stem 0.11.6*/ 
    /*0*/ <4028,4029,4030>,<4028,4030,4031>,<4028,4031,4029>,
    /*1*/ <4029,4032,4030>,<4030,4032,4033>,<4030,4033,4031>,<4031,4033,4034>,<4031,4034,4029>,
            <4029,4034,4032>,
    /*2*/ <4032,4035,4033>,<4033,4035,4036>,<4033,4036,4034>,<4034,4036,4037>,<4034,4037,4032>,
            <4032,4037,4035>,
    /*3*/ <4035,4038,4036>,<4036,4038,4037>,<4037,4038,4035>

    /* stem 0.11.7*/ 
    /*0*/ <4039,4040,4041>,<4039,4041,4042>,<4039,4042,4040>,
    /*1*/ <4040,4043,4041>,<4041,4043,4044>,<4041,4044,4042>,<4042,4044,4045>,<4042,4045,4040>,
            <4040,4045,4043>,
    /*2*/ <4043,4046,4044>,<4044,4046,4047>,<4044,4047,4045>,<4045,4047,4048>,<4045,4048,4043>,
            <4043,4048,4046>,
    /*3*/ <4046,4049,4047>,<4047,4049,4048>,<4048,4049,4046>

    /* stem 0.11.8*/ 
    /*0*/ <4050,4051,4052>,<4050,4052,4053>,<4050,4053,4051>,
    /*1*/ <4051,4054,4052>,<4052,4054,4055>,<4052,4055,4053>,<4053,4055,4056>,<4053,4056,4051>,
            <4051,4056,4054>,
    /*2*/ <4054,4057,4055>,<4055,4057,4058>,<4055,4058,4056>,<4056,4058,4059>,<4056,4059,4054>,
            <4054,4059,4057>,
    /*3*/ <4057,4060,4058>,<4058,4060,4059>,<4059,4060,4057>

    /* stem 0.11.9*/ 
    /*0*/ <4061,4062,4063>,<4061,4063,4064>,<4061,4064,4062>,
    /*1*/ <4062,4065,4063>,<4063,4065,4066>,<4063,4066,4064>,<4064,4066,4067>,<4064,4067,4062>,
            <4062,4067,4065>,
    /*2*/ <4065,4068,4066>,<4066,4068,4069>,<4066,4069,4067>,<4067,4069,4070>,<4067,4070,4065>,
            <4065,4070,4068>,
    /*3*/ <4068,4071,4069>,<4069,4071,4070>,<4070,4071,4068>

    /* stem 0.11.10*/ 
    /*0*/ <4072,4073,4074>,<4072,4074,4075>,<4072,4075,4073>,
    /*1*/ <4073,4076,4074>,<4074,4076,4077>,<4074,4077,4075>,<4075,4077,4078>,<4075,4078,4073>,
            <4073,4078,4076>,
    /*2*/ <4076,4079,4077>,<4077,4079,4080>,<4077,4080,4078>,<4078,4080,4081>,<4078,4081,4076>,
            <4076,4081,4079>,
    /*3*/ <4079,4082,4080>,<4080,4082,4081>,<4081,4082,4079>

    /* stem 0.11.11*/ 
    /*0*/ <4083,4084,4085>,<4083,4085,4086>,<4083,4086,4084>,
    /*1*/ <4084,4087,4085>,<4085,4087,4088>,<4085,4088,4086>,<4086,4088,4089>,<4086,4089,4084>,
            <4084,4089,4087>,
    /*2*/ <4087,4090,4088>,<4088,4090,4091>,<4088,4091,4089>,<4089,4091,4092>,<4089,4092,4087>,
            <4087,4092,4090>,
    /*3*/ <4090,4093,4091>,<4091,4093,4092>,<4092,4093,4090>

    /* stem 0.11.12*/ 
    /*0*/ <4094,4095,4096>,<4094,4096,4097>,<4094,4097,4095>,
    /*1*/ <4095,4098,4096>,<4096,4098,4099>,<4096,4099,4097>,<4097,4099,4100>,<4097,4100,4095>,
            <4095,4100,4098>,
    /*2*/ <4098,4101,4099>,<4099,4101,4102>,<4099,4102,4100>,<4100,4102,4103>,<4100,4103,4098>,
            <4098,4103,4101>,
    /*3*/ <4101,4104,4102>,<4102,4104,4103>,<4103,4104,4101>

    /* stem 0.11.13*/ 
    /*0*/ <4105,4106,4107>,<4105,4107,4108>,<4105,4108,4106>,
    /*1*/ <4106,4109,4107>,<4107,4109,4110>,<4107,4110,4108>,<4108,4110,4111>,<4108,4111,4106>,
            <4106,4111,4109>,
    /*2*/ <4109,4112,4110>,<4110,4112,4113>,<4110,4113,4111>,<4111,4113,4114>,<4111,4114,4109>,
            <4109,4114,4112>,
    /*3*/ <4112,4115,4113>,<4113,4115,4114>,<4114,4115,4112>

    /* stem 0.11.14*/ 
    /*0*/ <4116,4117,4118>,<4116,4118,4119>,<4116,4119,4117>,
    /*1*/ <4117,4120,4118>,<4118,4120,4121>,<4118,4121,4119>,<4119,4121,4122>,<4119,4122,4117>,
            <4117,4122,4120>,
    /*2*/ <4120,4123,4121>,<4121,4123,4124>,<4121,4124,4122>,<4122,4124,4125>,<4122,4125,4120>,
            <4120,4125,4123>,
    /*3*/ <4123,4126,4124>,<4124,4126,4125>,<4125,4126,4123>

    /* stem 0.11.15*/ 
    /*0*/ <4127,4128,4129>,<4127,4129,4130>,<4127,4130,4128>,
    /*1*/ <4128,4131,4129>,<4129,4131,4132>,<4129,4132,4130>,<4130,4132,4133>,<4130,4133,4128>,
            <4128,4133,4131>,
    /*2*/ <4131,4134,4132>,<4132,4134,4135>,<4132,4135,4133>,<4133,4135,4136>,<4133,4136,4131>,
            <4131,4136,4134>,
    /*3*/ <4134,4137,4135>,<4135,4137,4136>,<4136,4137,4134>

    /* stem 0.11.16*/ 
    /*0*/ <4138,4139,4140>,<4138,4140,4141>,<4138,4141,4139>,
    /*1*/ <4139,4142,4140>,<4140,4142,4143>,<4140,4143,4141>,<4141,4143,4144>,<4141,4144,4139>,
            <4139,4144,4142>,
    /*2*/ <4142,4145,4143>,<4143,4145,4146>,<4143,4146,4144>,<4144,4146,4147>,<4144,4147,4142>,
            <4142,4147,4145>,
    /*3*/ <4145,4148,4146>,<4146,4148,4147>,<4147,4148,4145>

    /* stem 0.11.17*/ 
    /*0*/ <4149,4150,4151>,<4149,4151,4152>,<4149,4152,4150>,
    /*1*/ <4150,4153,4151>,<4151,4153,4154>,<4151,4154,4152>,<4152,4154,4155>,<4152,4155,4150>,
            <4150,4155,4153>,
    /*2*/ <4153,4156,4154>,<4154,4156,4157>,<4154,4157,4155>,<4155,4157,4158>,<4155,4158,4153>,
            <4153,4158,4156>,
    /*3*/ <4156,4159,4157>,<4157,4159,4158>,<4158,4159,4156>

    /* stem 0.11.18*/ 
    /*0*/ <4160,4161,4162>,<4160,4162,4163>,<4160,4163,4161>,
    /*1*/ <4161,4164,4162>,<4162,4164,4165>,<4162,4165,4163>,<4163,4165,4166>,<4163,4166,4161>,
            <4161,4166,4164>,
    /*2*/ <4164,4167,4165>,<4165,4167,4168>,<4165,4168,4166>,<4166,4168,4169>,<4166,4169,4164>,
            <4164,4169,4167>,
    /*3*/ <4167,4170,4168>,<4168,4170,4169>,<4169,4170,4167>

    /* stem 0.11.19*/ 
    /*0*/ <4171,4172,4173>,<4171,4173,4174>,<4171,4174,4172>,
    /*1*/ <4172,4175,4173>,<4173,4175,4176>,<4173,4176,4174>,<4174,4176,4177>,<4174,4177,4172>,
            <4172,4177,4175>,
    /*2*/ <4175,4178,4176>,<4176,4178,4179>,<4176,4179,4177>,<4177,4179,4180>,<4177,4180,4175>,
            <4175,4180,4178>,
    /*3*/ <4178,4181,4179>,<4179,4181,4180>,<4180,4181,4178>

    /* stem 0.11.20*/ 
    /*0*/ <4182,4183,4184>,<4182,4184,4185>,<4182,4185,4183>,
    /*1*/ <4183,4186,4184>,<4184,4186,4187>,<4184,4187,4185>,<4185,4187,4188>,<4185,4188,4183>,
            <4183,4188,4186>,
    /*2*/ <4186,4189,4187>,<4187,4189,4190>,<4187,4190,4188>,<4188,4190,4191>,<4188,4191,4186>,
            <4186,4191,4189>,
    /*3*/ <4189,4192,4190>,<4190,4192,4191>,<4191,4192,4189>

    /* stem 0.11.21*/ 
    /*0*/ <4193,4194,4195>,<4193,4195,4196>,<4193,4196,4194>,
    /*1*/ <4194,4197,4195>,<4195,4197,4198>,<4195,4198,4196>,<4196,4198,4199>,<4196,4199,4194>,
            <4194,4199,4197>,
    /*2*/ <4197,4200,4198>,<4198,4200,4201>,<4198,4201,4199>,<4199,4201,4202>,<4199,4202,4197>,
            <4197,4202,4200>,
    /*3*/ <4200,4203,4201>,<4201,4203,4202>,<4202,4203,4200>

    /* stem 0.11.22*/ 
    /*0*/ <4204,4205,4206>,<4204,4206,4207>,<4204,4207,4205>,
    /*1*/ <4205,4208,4206>,<4206,4208,4209>,<4206,4209,4207>,<4207,4209,4210>,<4207,4210,4205>,
            <4205,4210,4208>,
    /*2*/ <4208,4211,4209>,<4209,4211,4212>,<4209,4212,4210>,<4210,4212,4213>,<4210,4213,4208>,
            <4208,4213,4211>,
    /*3*/ <4211,4214,4212>,<4212,4214,4213>,<4213,4214,4211>

    /* stem 0.11.23*/ 
    /*0*/ <4215,4216,4217>,<4215,4217,4218>,<4215,4218,4216>,
    /*1*/ <4216,4219,4217>,<4217,4219,4220>,<4217,4220,4218>,<4218,4220,4221>,<4218,4221,4216>,
            <4216,4221,4219>,
    /*2*/ <4219,4222,4220>,<4220,4222,4223>,<4220,4223,4221>,<4221,4223,4224>,<4221,4224,4219>,
            <4219,4224,4222>,
    /*3*/ <4222,4225,4223>,<4223,4225,4224>,<4224,4225,4222>

    /* stem 0.11.24*/ 
    /*0*/ <4226,4227,4228>,<4226,4228,4229>,<4226,4229,4227>,
    /*1*/ <4227,4230,4228>,<4228,4230,4231>,<4228,4231,4229>,<4229,4231,4232>,<4229,4232,4227>,
            <4227,4232,4230>,
    /*2*/ <4230,4233,4231>,<4231,4233,4234>,<4231,4234,4232>,<4232,4234,4235>,<4232,4235,4230>,
            <4230,4235,4233>,
    /*3*/ <4233,4236,4234>,<4234,4236,4235>,<4235,4236,4233>

    /* stem 0.11.25*/ 
    /*0*/ <4237,4238,4239>,<4237,4239,4240>,<4237,4240,4238>,
    /*1*/ <4238,4241,4239>,<4239,4241,4242>,<4239,4242,4240>,<4240,4242,4243>,<4240,4243,4238>,
            <4238,4243,4241>,
    /*2*/ <4241,4244,4242>,<4242,4244,4245>,<4242,4245,4243>,<4243,4245,4246>,<4243,4246,4241>,
            <4241,4246,4244>,
    /*3*/ <4244,4247,4245>,<4245,4247,4246>,<4246,4247,4244>

    /* stem 0.11.26*/ 
    /*0*/ <4248,4249,4250>,<4248,4250,4251>,<4248,4251,4249>,
    /*1*/ <4249,4252,4250>,<4250,4252,4253>,<4250,4253,4251>,<4251,4253,4254>,<4251,4254,4249>,
            <4249,4254,4252>,
    /*2*/ <4252,4255,4253>,<4253,4255,4256>,<4253,4256,4254>,<4254,4256,4257>,<4254,4257,4252>,
            <4252,4257,4255>,
    /*3*/ <4255,4258,4256>,<4256,4258,4257>,<4257,4258,4255>

    /* stem 0.11.27*/ 
    /*0*/ <4259,4260,4261>,<4259,4261,4262>,<4259,4262,4260>,
    /*1*/ <4260,4263,4261>,<4261,4263,4264>,<4261,4264,4262>,<4262,4264,4265>,<4262,4265,4260>,
            <4260,4265,4263>,
    /*2*/ <4263,4266,4264>,<4264,4266,4267>,<4264,4267,4265>,<4265,4267,4268>,<4265,4268,4263>,
            <4263,4268,4266>,
    /*3*/ <4266,4269,4267>,<4267,4269,4268>,<4268,4269,4266>

    /* stem 0.12*/ 
    /*0*/ <4270,4271,4272>,<4270,4272,4273>,<4270,4273,4274>,<4270,4274,4275>,<4270,4275,4271>,
            
    /*1*/ <4271,4276,4272>,<4272,4276,4277>,<4272,4277,4273>,<4273,4277,4278>,<4273,4278,4274>,
            <4274,4278,4279>,<4274,4279,4275>,<4275,4279,4280>,<4275,4280,4271>,<4271,4280,4276>,
    /*2*/ <4276,4281,4277>,<4277,4281,4282>,<4277,4282,4278>,<4278,4282,4283>,<4278,4283,4279>,
            <4279,4283,4284>,<4279,4284,4280>,<4280,4284,4285>,<4280,4285,4276>,<4276,4285,4281>,
    /*3*/ <4281,4286,4282>,<4282,4286,4283>,<4283,4286,4284>,<4284,4286,4285>,<4285,4286,4281>
            

    /* stem 0.12.0*/ 
    /*0*/ <4287,4288,4289>,<4287,4289,4290>,<4287,4290,4288>,
    /*1*/ <4288,4291,4289>,<4289,4291,4292>,<4289,4292,4290>,<4290,4292,4293>,<4290,4293,4288>,
            <4288,4293,4291>,
    /*2*/ <4291,4294,4292>,<4292,4294,4295>,<4292,4295,4293>,<4293,4295,4296>,<4293,4296,4291>,
            <4291,4296,4294>,
    /*3*/ <4294,4297,4295>,<4295,4297,4296>,<4296,4297,4294>

    /* stem 0.12.1*/ 
    /*0*/ <4298,4299,4300>,<4298,4300,4301>,<4298,4301,4299>,
    /*1*/ <4299,4302,4300>,<4300,4302,4303>,<4300,4303,4301>,<4301,4303,4304>,<4301,4304,4299>,
            <4299,4304,4302>,
    /*2*/ <4302,4305,4303>,<4303,4305,4306>,<4303,4306,4304>,<4304,4306,4307>,<4304,4307,4302>,
            <4302,4307,4305>,
    /*3*/ <4305,4308,4306>,<4306,4308,4307>,<4307,4308,4305>

    /* stem 0.12.2*/ 
    /*0*/ <4309,4310,4311>,<4309,4311,4312>,<4309,4312,4310>,
    /*1*/ <4310,4313,4311>,<4311,4313,4314>,<4311,4314,4312>,<4312,4314,4315>,<4312,4315,4310>,
            <4310,4315,4313>,
    /*2*/ <4313,4316,4314>,<4314,4316,4317>,<4314,4317,4315>,<4315,4317,4318>,<4315,4318,4313>,
            <4313,4318,4316>,
    /*3*/ <4316,4319,4317>,<4317,4319,4318>,<4318,4319,4316>

    /* stem 0.12.3*/ 
    /*0*/ <4320,4321,4322>,<4320,4322,4323>,<4320,4323,4321>,
    /*1*/ <4321,4324,4322>,<4322,4324,4325>,<4322,4325,4323>,<4323,4325,4326>,<4323,4326,4321>,
            <4321,4326,4324>,
    /*2*/ <4324,4327,4325>,<4325,4327,4328>,<4325,4328,4326>,<4326,4328,4329>,<4326,4329,4324>,
            <4324,4329,4327>,
    /*3*/ <4327,4330,4328>,<4328,4330,4329>,<4329,4330,4327>

    /* stem 0.12.4*/ 
    /*0*/ <4331,4332,4333>,<4331,4333,4334>,<4331,4334,4332>,
    /*1*/ <4332,4335,4333>,<4333,4335,4336>,<4333,4336,4334>,<4334,4336,4337>,<4334,4337,4332>,
            <4332,4337,4335>,
    /*2*/ <4335,4338,4336>,<4336,4338,4339>,<4336,4339,4337>,<4337,4339,4340>,<4337,4340,4335>,
            <4335,4340,4338>,
    /*3*/ <4338,4341,4339>,<4339,4341,4340>,<4340,4341,4338>

    /* stem 0.12.5*/ 
    /*0*/ <4342,4343,4344>,<4342,4344,4345>,<4342,4345,4343>,
    /*1*/ <4343,4346,4344>,<4344,4346,4347>,<4344,4347,4345>,<4345,4347,4348>,<4345,4348,4343>,
            <4343,4348,4346>,
    /*2*/ <4346,4349,4347>,<4347,4349,4350>,<4347,4350,4348>,<4348,4350,4351>,<4348,4351,4346>,
            <4346,4351,4349>,
    /*3*/ <4349,4352,4350>,<4350,4352,4351>,<4351,4352,4349>

    /* stem 0.12.6*/ 
    /*0*/ <4353,4354,4355>,<4353,4355,4356>,<4353,4356,4354>,
    /*1*/ <4354,4357,4355>,<4355,4357,4358>,<4355,4358,4356>,<4356,4358,4359>,<4356,4359,4354>,
            <4354,4359,4357>,
    /*2*/ <4357,4360,4358>,<4358,4360,4361>,<4358,4361,4359>,<4359,4361,4362>,<4359,4362,4357>,
            <4357,4362,4360>,
    /*3*/ <4360,4363,4361>,<4361,4363,4362>,<4362,4363,4360>

    /* stem 0.12.7*/ 
    /*0*/ <4364,4365,4366>,<4364,4366,4367>,<4364,4367,4365>,
    /*1*/ <4365,4368,4366>,<4366,4368,4369>,<4366,4369,4367>,<4367,4369,4370>,<4367,4370,4365>,
            <4365,4370,4368>,
    /*2*/ <4368,4371,4369>,<4369,4371,4372>,<4369,4372,4370>,<4370,4372,4373>,<4370,4373,4368>,
            <4368,4373,4371>,
    /*3*/ <4371,4374,4372>,<4372,4374,4373>,<4373,4374,4371>

    /* stem 0.12.8*/ 
    /*0*/ <4375,4376,4377>,<4375,4377,4378>,<4375,4378,4376>,
    /*1*/ <4376,4379,4377>,<4377,4379,4380>,<4377,4380,4378>,<4378,4380,4381>,<4378,4381,4376>,
            <4376,4381,4379>,
    /*2*/ <4379,4382,4380>,<4380,4382,4383>,<4380,4383,4381>,<4381,4383,4384>,<4381,4384,4379>,
            <4379,4384,4382>,
    /*3*/ <4382,4385,4383>,<4383,4385,4384>,<4384,4385,4382>

    /* stem 0.12.9*/ 
    /*0*/ <4386,4387,4388>,<4386,4388,4389>,<4386,4389,4387>,
    /*1*/ <4387,4390,4388>,<4388,4390,4391>,<4388,4391,4389>,<4389,4391,4392>,<4389,4392,4387>,
            <4387,4392,4390>,
    /*2*/ <4390,4393,4391>,<4391,4393,4394>,<4391,4394,4392>,<4392,4394,4395>,<4392,4395,4390>,
            <4390,4395,4393>,
    /*3*/ <4393,4396,4394>,<4394,4396,4395>,<4395,4396,4393>

    /* stem 0.12.10*/ 
    /*0*/ <4397,4398,4399>,<4397,4399,4400>,<4397,4400,4398>,
    /*1*/ <4398,4401,4399>,<4399,4401,4402>,<4399,4402,4400>,<4400,4402,4403>,<4400,4403,4398>,
            <4398,4403,4401>,
    /*2*/ <4401,4404,4402>,<4402,4404,4405>,<4402,4405,4403>,<4403,4405,4406>,<4403,4406,4401>,
            <4401,4406,4404>,
    /*3*/ <4404,4407,4405>,<4405,4407,4406>,<4406,4407,4404>

    /* stem 0.12.11*/ 
    /*0*/ <4408,4409,4410>,<4408,4410,4411>,<4408,4411,4409>,
    /*1*/ <4409,4412,4410>,<4410,4412,4413>,<4410,4413,4411>,<4411,4413,4414>,<4411,4414,4409>,
            <4409,4414,4412>,
    /*2*/ <4412,4415,4413>,<4413,4415,4416>,<4413,4416,4414>,<4414,4416,4417>,<4414,4417,4412>,
            <4412,4417,4415>,
    /*3*/ <4415,4418,4416>,<4416,4418,4417>,<4417,4418,4415>

    /* stem 0.12.12*/ 
    /*0*/ <4419,4420,4421>,<4419,4421,4422>,<4419,4422,4420>,
    /*1*/ <4420,4423,4421>,<4421,4423,4424>,<4421,4424,4422>,<4422,4424,4425>,<4422,4425,4420>,
            <4420,4425,4423>,
    /*2*/ <4423,4426,4424>,<4424,4426,4427>,<4424,4427,4425>,<4425,4427,4428>,<4425,4428,4423>,
            <4423,4428,4426>,
    /*3*/ <4426,4429,4427>,<4427,4429,4428>,<4428,4429,4426>

    /* stem 0.12.13*/ 
    /*0*/ <4430,4431,4432>,<4430,4432,4433>,<4430,4433,4431>,
    /*1*/ <4431,4434,4432>,<4432,4434,4435>,<4432,4435,4433>,<4433,4435,4436>,<4433,4436,4431>,
            <4431,4436,4434>,
    /*2*/ <4434,4437,4435>,<4435,4437,4438>,<4435,4438,4436>,<4436,4438,4439>,<4436,4439,4434>,
            <4434,4439,4437>,
    /*3*/ <4437,4440,4438>,<4438,4440,4439>,<4439,4440,4437>

    /* stem 0.12.14*/ 
    /*0*/ <4441,4442,4443>,<4441,4443,4444>,<4441,4444,4442>,
    /*1*/ <4442,4445,4443>,<4443,4445,4446>,<4443,4446,4444>,<4444,4446,4447>,<4444,4447,4442>,
            <4442,4447,4445>,
    /*2*/ <4445,4448,4446>,<4446,4448,4449>,<4446,4449,4447>,<4447,4449,4450>,<4447,4450,4445>,
            <4445,4450,4448>,
    /*3*/ <4448,4451,4449>,<4449,4451,4450>,<4450,4451,4448>

    /* stem 0.12.15*/ 
    /*0*/ <4452,4453,4454>,<4452,4454,4455>,<4452,4455,4453>,
    /*1*/ <4453,4456,4454>,<4454,4456,4457>,<4454,4457,4455>,<4455,4457,4458>,<4455,4458,4453>,
            <4453,4458,4456>,
    /*2*/ <4456,4459,4457>,<4457,4459,4460>,<4457,4460,4458>,<4458,4460,4461>,<4458,4461,4456>,
            <4456,4461,4459>,
    /*3*/ <4459,4462,4460>,<4460,4462,4461>,<4461,4462,4459>

    /* stem 0.12.16*/ 
    /*0*/ <4463,4464,4465>,<4463,4465,4466>,<4463,4466,4464>,
    /*1*/ <4464,4467,4465>,<4465,4467,4468>,<4465,4468,4466>,<4466,4468,4469>,<4466,4469,4464>,
            <4464,4469,4467>,
    /*2*/ <4467,4470,4468>,<4468,4470,4471>,<4468,4471,4469>,<4469,4471,4472>,<4469,4472,4467>,
            <4467,4472,4470>,
    /*3*/ <4470,4473,4471>,<4471,4473,4472>,<4472,4473,4470>

    /* stem 0.12.17*/ 
    /*0*/ <4474,4475,4476>,<4474,4476,4477>,<4474,4477,4475>,
    /*1*/ <4475,4478,4476>,<4476,4478,4479>,<4476,4479,4477>,<4477,4479,4480>,<4477,4480,4475>,
            <4475,4480,4478>,
    /*2*/ <4478,4481,4479>,<4479,4481,4482>,<4479,4482,4480>,<4480,4482,4483>,<4480,4483,4478>,
            <4478,4483,4481>,
    /*3*/ <4481,4484,4482>,<4482,4484,4483>,<4483,4484,4481>

    /* stem 0.12.18*/ 
    /*0*/ <4485,4486,4487>,<4485,4487,4488>,<4485,4488,4486>,
    /*1*/ <4486,4489,4487>,<4487,4489,4490>,<4487,4490,4488>,<4488,4490,4491>,<4488,4491,4486>,
            <4486,4491,4489>,
    /*2*/ <4489,4492,4490>,<4490,4492,4493>,<4490,4493,4491>,<4491,4493,4494>,<4491,4494,4489>,
            <4489,4494,4492>,
    /*3*/ <4492,4495,4493>,<4493,4495,4494>,<4494,4495,4492>

    /* stem 0.12.19*/ 
    /*0*/ <4496,4497,4498>,<4496,4498,4499>,<4496,4499,4497>,
    /*1*/ <4497,4500,4498>,<4498,4500,4501>,<4498,4501,4499>,<4499,4501,4502>,<4499,4502,4497>,
            <4497,4502,4500>,
    /*2*/ <4500,4503,4501>,<4501,4503,4504>,<4501,4504,4502>,<4502,4504,4505>,<4502,4505,4500>,
            <4500,4505,4503>,
    /*3*/ <4503,4506,4504>,<4504,4506,4505>,<4505,4506,4503>

    /* stem 0.12.20*/ 
    /*0*/ <4507,4508,4509>,<4507,4509,4510>,<4507,4510,4508>,
    /*1*/ <4508,4511,4509>,<4509,4511,4512>,<4509,4512,4510>,<4510,4512,4513>,<4510,4513,4508>,
            <4508,4513,4511>,
    /*2*/ <4511,4514,4512>,<4512,4514,4515>,<4512,4515,4513>,<4513,4515,4516>,<4513,4516,4511>,
            <4511,4516,4514>,
    /*3*/ <4514,4517,4515>,<4515,4517,4516>,<4516,4517,4514>

    /* stem 0.12.21*/ 
    /*0*/ <4518,4519,4520>,<4518,4520,4521>,<4518,4521,4519>,
    /*1*/ <4519,4522,4520>,<4520,4522,4523>,<4520,4523,4521>,<4521,4523,4524>,<4521,4524,4519>,
            <4519,4524,4522>,
    /*2*/ <4522,4525,4523>,<4523,4525,4526>,<4523,4526,4524>,<4524,4526,4527>,<4524,4527,4522>,
            <4522,4527,4525>,
    /*3*/ <4525,4528,4526>,<4526,4528,4527>,<4527,4528,4525>

    /* stem 0.12.22*/ 
    /*0*/ <4529,4530,4531>,<4529,4531,4532>,<4529,4532,4530>,
    /*1*/ <4530,4533,4531>,<4531,4533,4534>,<4531,4534,4532>,<4532,4534,4535>,<4532,4535,4530>,
            <4530,4535,4533>,
    /*2*/ <4533,4536,4534>,<4534,4536,4537>,<4534,4537,4535>,<4535,4537,4538>,<4535,4538,4533>,
            <4533,4538,4536>,
    /*3*/ <4536,4539,4537>,<4537,4539,4538>,<4538,4539,4536>

    /* stem 0.12.23*/ 
    /*0*/ <4540,4541,4542>,<4540,4542,4543>,<4540,4543,4541>,
    /*1*/ <4541,4544,4542>,<4542,4544,4545>,<4542,4545,4543>,<4543,4545,4546>,<4543,4546,4541>,
            <4541,4546,4544>,
    /*2*/ <4544,4547,4545>,<4545,4547,4548>,<4545,4548,4546>,<4546,4548,4549>,<4546,4549,4544>,
            <4544,4549,4547>,
    /*3*/ <4547,4550,4548>,<4548,4550,4549>,<4549,4550,4547>

    /* stem 0.12.24*/ 
    /*0*/ <4551,4552,4553>,<4551,4553,4554>,<4551,4554,4552>,
    /*1*/ <4552,4555,4553>,<4553,4555,4556>,<4553,4556,4554>,<4554,4556,4557>,<4554,4557,4552>,
            <4552,4557,4555>,
    /*2*/ <4555,4558,4556>,<4556,4558,4559>,<4556,4559,4557>,<4557,4559,4560>,<4557,4560,4555>,
            <4555,4560,4558>,
    /*3*/ <4558,4561,4559>,<4559,4561,4560>,<4560,4561,4558>

    /* stem 0.12.25*/ 
    /*0*/ <4562,4563,4564>,<4562,4564,4565>,<4562,4565,4563>,
    /*1*/ <4563,4566,4564>,<4564,4566,4567>,<4564,4567,4565>,<4565,4567,4568>,<4565,4568,4563>,
            <4563,4568,4566>,
    /*2*/ <4566,4569,4567>,<4567,4569,4570>,<4567,4570,4568>,<4568,4570,4571>,<4568,4571,4566>,
            <4566,4571,4569>,
    /*3*/ <4569,4572,4570>,<4570,4572,4571>,<4571,4572,4569>

    /* stem 0.12.26*/ 
    /*0*/ <4573,4574,4575>,<4573,4575,4576>,<4573,4576,4574>,
    /*1*/ <4574,4577,4575>,<4575,4577,4578>,<4575,4578,4576>,<4576,4578,4579>,<4576,4579,4574>,
            <4574,4579,4577>,
    /*2*/ <4577,4580,4578>,<4578,4580,4581>,<4578,4581,4579>,<4579,4581,4582>,<4579,4582,4577>,
            <4577,4582,4580>,
    /*3*/ <4580,4583,4581>,<4581,4583,4582>,<4582,4583,4580>

    /* stem 0.13*/ 
    /*0*/ <4584,4585,4586>,<4584,4586,4587>,<4584,4587,4588>,<4584,4588,4589>,<4584,4589,4585>,
            
    /*1*/ <4585,4590,4586>,<4586,4590,4591>,<4586,4591,4587>,<4587,4591,4592>,<4587,4592,4588>,
            <4588,4592,4593>,<4588,4593,4589>,<4589,4593,4594>,<4589,4594,4585>,<4585,4594,4590>,
    /*2*/ <4590,4595,4591>,<4591,4595,4596>,<4591,4596,4592>,<4592,4596,4597>,<4592,4597,4593>,
            <4593,4597,4598>,<4593,4598,4594>,<4594,4598,4599>,<4594,4599,4590>,<4590,4599,4595>,
    /*3*/ <4595,4600,4596>,<4596,4600,4597>,<4597,4600,4598>,<4598,4600,4599>,<4599,4600,4595>
            

    /* stem 0.13.0*/ 
    /*0*/ <4601,4602,4603>,<4601,4603,4604>,<4601,4604,4602>,
    /*1*/ <4602,4605,4603>,<4603,4605,4606>,<4603,4606,4604>,<4604,4606,4607>,<4604,4607,4602>,
            <4602,4607,4605>,
    /*2*/ <4605,4608,4606>,<4606,4608,4609>,<4606,4609,4607>,<4607,4609,4610>,<4607,4610,4605>,
            <4605,4610,4608>,
    /*3*/ <4608,4611,4609>,<4609,4611,4610>,<4610,4611,4608>

    /* stem 0.13.1*/ 
    /*0*/ <4612,4613,4614>,<4612,4614,4615>,<4612,4615,4613>,
    /*1*/ <4613,4616,4614>,<4614,4616,4617>,<4614,4617,4615>,<4615,4617,4618>,<4615,4618,4613>,
            <4613,4618,4616>,
    /*2*/ <4616,4619,4617>,<4617,4619,4620>,<4617,4620,4618>,<4618,4620,4621>,<4618,4621,4616>,
            <4616,4621,4619>,
    /*3*/ <4619,4622,4620>,<4620,4622,4621>,<4621,4622,4619>

    /* stem 0.13.2*/ 
    /*0*/ <4623,4624,4625>,<4623,4625,4626>,<4623,4626,4624>,
    /*1*/ <4624,4627,4625>,<4625,4627,4628>,<4625,4628,4626>,<4626,4628,4629>,<4626,4629,4624>,
            <4624,4629,4627>,
    /*2*/ <4627,4630,4628>,<4628,4630,4631>,<4628,4631,4629>,<4629,4631,4632>,<4629,4632,4627>,
            <4627,4632,4630>,
    /*3*/ <4630,4633,4631>,<4631,4633,4632>,<4632,4633,4630>

    /* stem 0.13.3*/ 
    /*0*/ <4634,4635,4636>,<4634,4636,4637>,<4634,4637,4635>,
    /*1*/ <4635,4638,4636>,<4636,4638,4639>,<4636,4639,4637>,<4637,4639,4640>,<4637,4640,4635>,
            <4635,4640,4638>,
    /*2*/ <4638,4641,4639>,<4639,4641,4642>,<4639,4642,4640>,<4640,4642,4643>,<4640,4643,4638>,
            <4638,4643,4641>,
    /*3*/ <4641,4644,4642>,<4642,4644,4643>,<4643,4644,4641>

    /* stem 0.13.4*/ 
    /*0*/ <4645,4646,4647>,<4645,4647,4648>,<4645,4648,4646>,
    /*1*/ <4646,4649,4647>,<4647,4649,4650>,<4647,4650,4648>,<4648,4650,4651>,<4648,4651,4646>,
            <4646,4651,4649>,
    /*2*/ <4649,4652,4650>,<4650,4652,4653>,<4650,4653,4651>,<4651,4653,4654>,<4651,4654,4649>,
            <4649,4654,4652>,
    /*3*/ <4652,4655,4653>,<4653,4655,4654>,<4654,4655,4652>

    /* stem 0.13.5*/ 
    /*0*/ <4656,4657,4658>,<4656,4658,4659>,<4656,4659,4657>,
    /*1*/ <4657,4660,4658>,<4658,4660,4661>,<4658,4661,4659>,<4659,4661,4662>,<4659,4662,4657>,
            <4657,4662,4660>,
    /*2*/ <4660,4663,4661>,<4661,4663,4664>,<4661,4664,4662>,<4662,4664,4665>,<4662,4665,4660>,
            <4660,4665,4663>,
    /*3*/ <4663,4666,4664>,<4664,4666,4665>,<4665,4666,4663>

    /* stem 0.13.6*/ 
    /*0*/ <4667,4668,4669>,<4667,4669,4670>,<4667,4670,4668>,
    /*1*/ <4668,4671,4669>,<4669,4671,4672>,<4669,4672,4670>,<4670,4672,4673>,<4670,4673,4668>,
            <4668,4673,4671>,
    /*2*/ <4671,4674,4672>,<4672,4674,4675>,<4672,4675,4673>,<4673,4675,4676>,<4673,4676,4671>,
            <4671,4676,4674>,
    /*3*/ <4674,4677,4675>,<4675,4677,4676>,<4676,4677,4674>

    /* stem 0.13.7*/ 
    /*0*/ <4678,4679,4680>,<4678,4680,4681>,<4678,4681,4679>,
    /*1*/ <4679,4682,4680>,<4680,4682,4683>,<4680,4683,4681>,<4681,4683,4684>,<4681,4684,4679>,
            <4679,4684,4682>,
    /*2*/ <4682,4685,4683>,<4683,4685,4686>,<4683,4686,4684>,<4684,4686,4687>,<4684,4687,4682>,
            <4682,4687,4685>,
    /*3*/ <4685,4688,4686>,<4686,4688,4687>,<4687,4688,4685>

    /* stem 0.13.8*/ 
    /*0*/ <4689,4690,4691>,<4689,4691,4692>,<4689,4692,4690>,
    /*1*/ <4690,4693,4691>,<4691,4693,4694>,<4691,4694,4692>,<4692,4694,4695>,<4692,4695,4690>,
            <4690,4695,4693>,
    /*2*/ <4693,4696,4694>,<4694,4696,4697>,<4694,4697,4695>,<4695,4697,4698>,<4695,4698,4693>,
            <4693,4698,4696>,
    /*3*/ <4696,4699,4697>,<4697,4699,4698>,<4698,4699,4696>

    /* stem 0.13.9*/ 
    /*0*/ <4700,4701,4702>,<4700,4702,4703>,<4700,4703,4701>,
    /*1*/ <4701,4704,4702>,<4702,4704,4705>,<4702,4705,4703>,<4703,4705,4706>,<4703,4706,4701>,
            <4701,4706,4704>,
    /*2*/ <4704,4707,4705>,<4705,4707,4708>,<4705,4708,4706>,<4706,4708,4709>,<4706,4709,4704>,
            <4704,4709,4707>,
    /*3*/ <4707,4710,4708>,<4708,4710,4709>,<4709,4710,4707>

    /* stem 0.13.10*/ 
    /*0*/ <4711,4712,4713>,<4711,4713,4714>,<4711,4714,4712>,
    /*1*/ <4712,4715,4713>,<4713,4715,4716>,<4713,4716,4714>,<4714,4716,4717>,<4714,4717,4712>,
            <4712,4717,4715>,
    /*2*/ <4715,4718,4716>,<4716,4718,4719>,<4716,4719,4717>,<4717,4719,4720>,<4717,4720,4715>,
            <4715,4720,4718>,
    /*3*/ <4718,4721,4719>,<4719,4721,4720>,<4720,4721,4718>

    /* stem 0.13.11*/ 
    /*0*/ <4722,4723,4724>,<4722,4724,4725>,<4722,4725,4723>,
    /*1*/ <4723,4726,4724>,<4724,4726,4727>,<4724,4727,4725>,<4725,4727,4728>,<4725,4728,4723>,
            <4723,4728,4726>,
    /*2*/ <4726,4729,4727>,<4727,4729,4730>,<4727,4730,4728>,<4728,4730,4731>,<4728,4731,4726>,
            <4726,4731,4729>,
    /*3*/ <4729,4732,4730>,<4730,4732,4731>,<4731,4732,4729>

    /* stem 0.13.12*/ 
    /*0*/ <4733,4734,4735>,<4733,4735,4736>,<4733,4736,4734>,
    /*1*/ <4734,4737,4735>,<4735,4737,4738>,<4735,4738,4736>,<4736,4738,4739>,<4736,4739,4734>,
            <4734,4739,4737>,
    /*2*/ <4737,4740,4738>,<4738,4740,4741>,<4738,4741,4739>,<4739,4741,4742>,<4739,4742,4737>,
            <4737,4742,4740>,
    /*3*/ <4740,4743,4741>,<4741,4743,4742>,<4742,4743,4740>

    /* stem 0.13.13*/ 
    /*0*/ <4744,4745,4746>,<4744,4746,4747>,<4744,4747,4745>,
    /*1*/ <4745,4748,4746>,<4746,4748,4749>,<4746,4749,4747>,<4747,4749,4750>,<4747,4750,4745>,
            <4745,4750,4748>,
    /*2*/ <4748,4751,4749>,<4749,4751,4752>,<4749,4752,4750>,<4750,4752,4753>,<4750,4753,4748>,
            <4748,4753,4751>,
    /*3*/ <4751,4754,4752>,<4752,4754,4753>,<4753,4754,4751>

    /* stem 0.13.14*/ 
    /*0*/ <4755,4756,4757>,<4755,4757,4758>,<4755,4758,4756>,
    /*1*/ <4756,4759,4757>,<4757,4759,4760>,<4757,4760,4758>,<4758,4760,4761>,<4758,4761,4756>,
            <4756,4761,4759>,
    /*2*/ <4759,4762,4760>,<4760,4762,4763>,<4760,4763,4761>,<4761,4763,4764>,<4761,4764,4759>,
            <4759,4764,4762>,
    /*3*/ <4762,4765,4763>,<4763,4765,4764>,<4764,4765,4762>

    /* stem 0.13.15*/ 
    /*0*/ <4766,4767,4768>,<4766,4768,4769>,<4766,4769,4767>,
    /*1*/ <4767,4770,4768>,<4768,4770,4771>,<4768,4771,4769>,<4769,4771,4772>,<4769,4772,4767>,
            <4767,4772,4770>,
    /*2*/ <4770,4773,4771>,<4771,4773,4774>,<4771,4774,4772>,<4772,4774,4775>,<4772,4775,4770>,
            <4770,4775,4773>,
    /*3*/ <4773,4776,4774>,<4774,4776,4775>,<4775,4776,4773>

    /* stem 0.13.16*/ 
    /*0*/ <4777,4778,4779>,<4777,4779,4780>,<4777,4780,4778>,
    /*1*/ <4778,4781,4779>,<4779,4781,4782>,<4779,4782,4780>,<4780,4782,4783>,<4780,4783,4778>,
            <4778,4783,4781>,
    /*2*/ <4781,4784,4782>,<4782,4784,4785>,<4782,4785,4783>,<4783,4785,4786>,<4783,4786,4781>,
            <4781,4786,4784>,
    /*3*/ <4784,4787,4785>,<4785,4787,4786>,<4786,4787,4784>

    /* stem 0.13.17*/ 
    /*0*/ <4788,4789,4790>,<4788,4790,4791>,<4788,4791,4789>,
    /*1*/ <4789,4792,4790>,<4790,4792,4793>,<4790,4793,4791>,<4791,4793,4794>,<4791,4794,4789>,
            <4789,4794,4792>,
    /*2*/ <4792,4795,4793>,<4793,4795,4796>,<4793,4796,4794>,<4794,4796,4797>,<4794,4797,4792>,
            <4792,4797,4795>,
    /*3*/ <4795,4798,4796>,<4796,4798,4797>,<4797,4798,4795>

    /* stem 0.13.18*/ 
    /*0*/ <4799,4800,4801>,<4799,4801,4802>,<4799,4802,4800>,
    /*1*/ <4800,4803,4801>,<4801,4803,4804>,<4801,4804,4802>,<4802,4804,4805>,<4802,4805,4800>,
            <4800,4805,4803>,
    /*2*/ <4803,4806,4804>,<4804,4806,4807>,<4804,4807,4805>,<4805,4807,4808>,<4805,4808,4803>,
            <4803,4808,4806>,
    /*3*/ <4806,4809,4807>,<4807,4809,4808>,<4808,4809,4806>

    /* stem 0.13.19*/ 
    /*0*/ <4810,4811,4812>,<4810,4812,4813>,<4810,4813,4811>,
    /*1*/ <4811,4814,4812>,<4812,4814,4815>,<4812,4815,4813>,<4813,4815,4816>,<4813,4816,4811>,
            <4811,4816,4814>,
    /*2*/ <4814,4817,4815>,<4815,4817,4818>,<4815,4818,4816>,<4816,4818,4819>,<4816,4819,4814>,
            <4814,4819,4817>,
    /*3*/ <4817,4820,4818>,<4818,4820,4819>,<4819,4820,4817>

    /* stem 0.13.20*/ 
    /*0*/ <4821,4822,4823>,<4821,4823,4824>,<4821,4824,4822>,
    /*1*/ <4822,4825,4823>,<4823,4825,4826>,<4823,4826,4824>,<4824,4826,4827>,<4824,4827,4822>,
            <4822,4827,4825>,
    /*2*/ <4825,4828,4826>,<4826,4828,4829>,<4826,4829,4827>,<4827,4829,4830>,<4827,4830,4825>,
            <4825,4830,4828>,
    /*3*/ <4828,4831,4829>,<4829,4831,4830>,<4830,4831,4828>

    /* stem 0.13.21*/ 
    /*0*/ <4832,4833,4834>,<4832,4834,4835>,<4832,4835,4833>,
    /*1*/ <4833,4836,4834>,<4834,4836,4837>,<4834,4837,4835>,<4835,4837,4838>,<4835,4838,4833>,
            <4833,4838,4836>,
    /*2*/ <4836,4839,4837>,<4837,4839,4840>,<4837,4840,4838>,<4838,4840,4841>,<4838,4841,4836>,
            <4836,4841,4839>,
    /*3*/ <4839,4842,4840>,<4840,4842,4841>,<4841,4842,4839>

    /* stem 0.13.22*/ 
    /*0*/ <4843,4844,4845>,<4843,4845,4846>,<4843,4846,4844>,
    /*1*/ <4844,4847,4845>,<4845,4847,4848>,<4845,4848,4846>,<4846,4848,4849>,<4846,4849,4844>,
            <4844,4849,4847>,
    /*2*/ <4847,4850,4848>,<4848,4850,4851>,<4848,4851,4849>,<4849,4851,4852>,<4849,4852,4847>,
            <4847,4852,4850>,
    /*3*/ <4850,4853,4851>,<4851,4853,4852>,<4852,4853,4850>

    /* stem 0.13.23*/ 
    /*0*/ <4854,4855,4856>,<4854,4856,4857>,<4854,4857,4855>,
    /*1*/ <4855,4858,4856>,<4856,4858,4859>,<4856,4859,4857>,<4857,4859,4860>,<4857,4860,4855>,
            <4855,4860,4858>,
    /*2*/ <4858,4861,4859>,<4859,4861,4862>,<4859,4862,4860>,<4860,4862,4863>,<4860,4863,4858>,
            <4858,4863,4861>,
    /*3*/ <4861,4864,4862>,<4862,4864,4863>,<4863,4864,4861>

    /* stem 0.13.24*/ 
    /*0*/ <4865,4866,4867>,<4865,4867,4868>,<4865,4868,4866>,
    /*1*/ <4866,4869,4867>,<4867,4869,4870>,<4867,4870,4868>,<4868,4870,4871>,<4868,4871,4866>,
            <4866,4871,4869>,
    /*2*/ <4869,4872,4870>,<4870,4872,4873>,<4870,4873,4871>,<4871,4873,4874>,<4871,4874,4869>,
            <4869,4874,4872>,
    /*3*/ <4872,4875,4873>,<4873,4875,4874>,<4874,4875,4872>

    /* stem 0.13.25*/ 
    /*0*/ <4876,4877,4878>,<4876,4878,4879>,<4876,4879,4877>,
    /*1*/ <4877,4880,4878>,<4878,4880,4881>,<4878,4881,4879>,<4879,4881,4882>,<4879,4882,4877>,
            <4877,4882,4880>,
    /*2*/ <4880,4883,4881>,<4881,4883,4884>,<4881,4884,4882>,<4882,4884,4885>,<4882,4885,4880>,
            <4880,4885,4883>,
    /*3*/ <4883,4886,4884>,<4884,4886,4885>,<4885,4886,4883>

    /* stem 0.13.26*/ 
    /*0*/ <4887,4888,4889>,<4887,4889,4890>,<4887,4890,4888>,
    /*1*/ <4888,4891,4889>,<4889,4891,4892>,<4889,4892,4890>,<4890,4892,4893>,<4890,4893,4888>,
            <4888,4893,4891>,
    /*2*/ <4891,4894,4892>,<4892,4894,4895>,<4892,4895,4893>,<4893,4895,4896>,<4893,4896,4891>,
            <4891,4896,4894>,
    /*3*/ <4894,4897,4895>,<4895,4897,4896>,<4896,4897,4894>

    /* stem 0.14*/ 
    /*0*/ <4898,4899,4900>,<4898,4900,4901>,<4898,4901,4902>,<4898,4902,4903>,<4898,4903,4899>,
            
    /*1*/ <4899,4904,4900>,<4900,4904,4905>,<4900,4905,4901>,<4901,4905,4906>,<4901,4906,4902>,
            <4902,4906,4907>,<4902,4907,4903>,<4903,4907,4908>,<4903,4908,4899>,<4899,4908,4904>,
    /*2*/ <4904,4909,4905>,<4905,4909,4910>,<4905,4910,4906>,<4906,4910,4911>,<4906,4911,4907>,
            <4907,4911,4912>,<4907,4912,4908>,<4908,4912,4913>,<4908,4913,4904>,<4904,4913,4909>,
    /*3*/ <4909,4914,4910>,<4910,4914,4911>,<4911,4914,4912>,<4912,4914,4913>,<4913,4914,4909>
            

    /* stem 0.14.0*/ 
    /*0*/ <4915,4916,4917>,<4915,4917,4918>,<4915,4918,4916>,
    /*1*/ <4916,4919,4917>,<4917,4919,4920>,<4917,4920,4918>,<4918,4920,4921>,<4918,4921,4916>,
            <4916,4921,4919>,
    /*2*/ <4919,4922,4920>,<4920,4922,4923>,<4920,4923,4921>,<4921,4923,4924>,<4921,4924,4919>,
            <4919,4924,4922>,
    /*3*/ <4922,4925,4923>,<4923,4925,4924>,<4924,4925,4922>

    /* stem 0.14.1*/ 
    /*0*/ <4926,4927,4928>,<4926,4928,4929>,<4926,4929,4927>,
    /*1*/ <4927,4930,4928>,<4928,4930,4931>,<4928,4931,4929>,<4929,4931,4932>,<4929,4932,4927>,
            <4927,4932,4930>,
    /*2*/ <4930,4933,4931>,<4931,4933,4934>,<4931,4934,4932>,<4932,4934,4935>,<4932,4935,4930>,
            <4930,4935,4933>,
    /*3*/ <4933,4936,4934>,<4934,4936,4935>,<4935,4936,4933>

    /* stem 0.14.2*/ 
    /*0*/ <4937,4938,4939>,<4937,4939,4940>,<4937,4940,4938>,
    /*1*/ <4938,4941,4939>,<4939,4941,4942>,<4939,4942,4940>,<4940,4942,4943>,<4940,4943,4938>,
            <4938,4943,4941>,
    /*2*/ <4941,4944,4942>,<4942,4944,4945>,<4942,4945,4943>,<4943,4945,4946>,<4943,4946,4941>,
            <4941,4946,4944>,
    /*3*/ <4944,4947,4945>,<4945,4947,4946>,<4946,4947,4944>

    /* stem 0.14.3*/ 
    /*0*/ <4948,4949,4950>,<4948,4950,4951>,<4948,4951,4949>,
    /*1*/ <4949,4952,4950>,<4950,4952,4953>,<4950,4953,4951>,<4951,4953,4954>,<4951,4954,4949>,
            <4949,4954,4952>,
    /*2*/ <4952,4955,4953>,<4953,4955,4956>,<4953,4956,4954>,<4954,4956,4957>,<4954,4957,4952>,
            <4952,4957,4955>,
    /*3*/ <4955,4958,4956>,<4956,4958,4957>,<4957,4958,4955>

    /* stem 0.14.4*/ 
    /*0*/ <4959,4960,4961>,<4959,4961,4962>,<4959,4962,4960>,
    /*1*/ <4960,4963,4961>,<4961,4963,4964>,<4961,4964,4962>,<4962,4964,4965>,<4962,4965,4960>,
            <4960,4965,4963>,
    /*2*/ <4963,4966,4964>,<4964,4966,4967>,<4964,4967,4965>,<4965,4967,4968>,<4965,4968,4963>,
            <4963,4968,4966>,
    /*3*/ <4966,4969,4967>,<4967,4969,4968>,<4968,4969,4966>

    /* stem 0.14.5*/ 
    /*0*/ <4970,4971,4972>,<4970,4972,4973>,<4970,4973,4971>,
    /*1*/ <4971,4974,4972>,<4972,4974,4975>,<4972,4975,4973>,<4973,4975,4976>,<4973,4976,4971>,
            <4971,4976,4974>,
    /*2*/ <4974,4977,4975>,<4975,4977,4978>,<4975,4978,4976>,<4976,4978,4979>,<4976,4979,4974>,
            <4974,4979,4977>,
    /*3*/ <4977,4980,4978>,<4978,4980,4979>,<4979,4980,4977>

    /* stem 0.14.6*/ 
    /*0*/ <4981,4982,4983>,<4981,4983,4984>,<4981,4984,4982>,
    /*1*/ <4982,4985,4983>,<4983,4985,4986>,<4983,4986,4984>,<4984,4986,4987>,<4984,4987,4982>,
            <4982,4987,4985>,
    /*2*/ <4985,4988,4986>,<4986,4988,4989>,<4986,4989,4987>,<4987,4989,4990>,<4987,4990,4985>,
            <4985,4990,4988>,
    /*3*/ <4988,4991,4989>,<4989,4991,4990>,<4990,4991,4988>

    /* stem 0.14.7*/ 
    /*0*/ <4992,4993,4994>,<4992,4994,4995>,<4992,4995,4993>,
    /*1*/ <4993,4996,4994>,<4994,4996,4997>,<4994,4997,4995>,<4995,4997,4998>,<4995,4998,4993>,
            <4993,4998,4996>,
    /*2*/ <4996,4999,4997>,<4997,4999,5000>,<4997,5000,4998>,<4998,5000,5001>,<4998,5001,4996>,
            <4996,5001,4999>,
    /*3*/ <4999,5002,5000>,<5000,5002,5001>,<5001,5002,4999>

    /* stem 0.14.8*/ 
    /*0*/ <5003,5004,5005>,<5003,5005,5006>,<5003,5006,5004>,
    /*1*/ <5004,5007,5005>,<5005,5007,5008>,<5005,5008,5006>,<5006,5008,5009>,<5006,5009,5004>,
            <5004,5009,5007>,
    /*2*/ <5007,5010,5008>,<5008,5010,5011>,<5008,5011,5009>,<5009,5011,5012>,<5009,5012,5007>,
            <5007,5012,5010>,
    /*3*/ <5010,5013,5011>,<5011,5013,5012>,<5012,5013,5010>

    /* stem 0.14.9*/ 
    /*0*/ <5014,5015,5016>,<5014,5016,5017>,<5014,5017,5015>,
    /*1*/ <5015,5018,5016>,<5016,5018,5019>,<5016,5019,5017>,<5017,5019,5020>,<5017,5020,5015>,
            <5015,5020,5018>,
    /*2*/ <5018,5021,5019>,<5019,5021,5022>,<5019,5022,5020>,<5020,5022,5023>,<5020,5023,5018>,
            <5018,5023,5021>,
    /*3*/ <5021,5024,5022>,<5022,5024,5023>,<5023,5024,5021>

    /* stem 0.14.10*/ 
    /*0*/ <5025,5026,5027>,<5025,5027,5028>,<5025,5028,5026>,
    /*1*/ <5026,5029,5027>,<5027,5029,5030>,<5027,5030,5028>,<5028,5030,5031>,<5028,5031,5026>,
            <5026,5031,5029>,
    /*2*/ <5029,5032,5030>,<5030,5032,5033>,<5030,5033,5031>,<5031,5033,5034>,<5031,5034,5029>,
            <5029,5034,5032>,
    /*3*/ <5032,5035,5033>,<5033,5035,5034>,<5034,5035,5032>

    /* stem 0.14.11*/ 
    /*0*/ <5036,5037,5038>,<5036,5038,5039>,<5036,5039,5037>,
    /*1*/ <5037,5040,5038>,<5038,5040,5041>,<5038,5041,5039>,<5039,5041,5042>,<5039,5042,5037>,
            <5037,5042,5040>,
    /*2*/ <5040,5043,5041>,<5041,5043,5044>,<5041,5044,5042>,<5042,5044,5045>,<5042,5045,5040>,
            <5040,5045,5043>,
    /*3*/ <5043,5046,5044>,<5044,5046,5045>,<5045,5046,5043>

    /* stem 0.14.12*/ 
    /*0*/ <5047,5048,5049>,<5047,5049,5050>,<5047,5050,5048>,
    /*1*/ <5048,5051,5049>,<5049,5051,5052>,<5049,5052,5050>,<5050,5052,5053>,<5050,5053,5048>,
            <5048,5053,5051>,
    /*2*/ <5051,5054,5052>,<5052,5054,5055>,<5052,5055,5053>,<5053,5055,5056>,<5053,5056,5051>,
            <5051,5056,5054>,
    /*3*/ <5054,5057,5055>,<5055,5057,5056>,<5056,5057,5054>

    /* stem 0.14.13*/ 
    /*0*/ <5058,5059,5060>,<5058,5060,5061>,<5058,5061,5059>,
    /*1*/ <5059,5062,5060>,<5060,5062,5063>,<5060,5063,5061>,<5061,5063,5064>,<5061,5064,5059>,
            <5059,5064,5062>,
    /*2*/ <5062,5065,5063>,<5063,5065,5066>,<5063,5066,5064>,<5064,5066,5067>,<5064,5067,5062>,
            <5062,5067,5065>,
    /*3*/ <5065,5068,5066>,<5066,5068,5067>,<5067,5068,5065>

    /* stem 0.14.14*/ 
    /*0*/ <5069,5070,5071>,<5069,5071,5072>,<5069,5072,5070>,
    /*1*/ <5070,5073,5071>,<5071,5073,5074>,<5071,5074,5072>,<5072,5074,5075>,<5072,5075,5070>,
            <5070,5075,5073>,
    /*2*/ <5073,5076,5074>,<5074,5076,5077>,<5074,5077,5075>,<5075,5077,5078>,<5075,5078,5073>,
            <5073,5078,5076>,
    /*3*/ <5076,5079,5077>,<5077,5079,5078>,<5078,5079,5076>

    /* stem 0.14.15*/ 
    /*0*/ <5080,5081,5082>,<5080,5082,5083>,<5080,5083,5081>,
    /*1*/ <5081,5084,5082>,<5082,5084,5085>,<5082,5085,5083>,<5083,5085,5086>,<5083,5086,5081>,
            <5081,5086,5084>,
    /*2*/ <5084,5087,5085>,<5085,5087,5088>,<5085,5088,5086>,<5086,5088,5089>,<5086,5089,5084>,
            <5084,5089,5087>,
    /*3*/ <5087,5090,5088>,<5088,5090,5089>,<5089,5090,5087>

    /* stem 0.14.16*/ 
    /*0*/ <5091,5092,5093>,<5091,5093,5094>,<5091,5094,5092>,
    /*1*/ <5092,5095,5093>,<5093,5095,5096>,<5093,5096,5094>,<5094,5096,5097>,<5094,5097,5092>,
            <5092,5097,5095>,
    /*2*/ <5095,5098,5096>,<5096,5098,5099>,<5096,5099,5097>,<5097,5099,5100>,<5097,5100,5095>,
            <5095,5100,5098>,
    /*3*/ <5098,5101,5099>,<5099,5101,5100>,<5100,5101,5098>

    /* stem 0.14.17*/ 
    /*0*/ <5102,5103,5104>,<5102,5104,5105>,<5102,5105,5103>,
    /*1*/ <5103,5106,5104>,<5104,5106,5107>,<5104,5107,5105>,<5105,5107,5108>,<5105,5108,5103>,
            <5103,5108,5106>,
    /*2*/ <5106,5109,5107>,<5107,5109,5110>,<5107,5110,5108>,<5108,5110,5111>,<5108,5111,5106>,
            <5106,5111,5109>,
    /*3*/ <5109,5112,5110>,<5110,5112,5111>,<5111,5112,5109>

    /* stem 0.14.18*/ 
    /*0*/ <5113,5114,5115>,<5113,5115,5116>,<5113,5116,5114>,
    /*1*/ <5114,5117,5115>,<5115,5117,5118>,<5115,5118,5116>,<5116,5118,5119>,<5116,5119,5114>,
            <5114,5119,5117>,
    /*2*/ <5117,5120,5118>,<5118,5120,5121>,<5118,5121,5119>,<5119,5121,5122>,<5119,5122,5117>,
            <5117,5122,5120>,
    /*3*/ <5120,5123,5121>,<5121,5123,5122>,<5122,5123,5120>

    /* stem 0.14.19*/ 
    /*0*/ <5124,5125,5126>,<5124,5126,5127>,<5124,5127,5125>,
    /*1*/ <5125,5128,5126>,<5126,5128,5129>,<5126,5129,5127>,<5127,5129,5130>,<5127,5130,5125>,
            <5125,5130,5128>,
    /*2*/ <5128,5131,5129>,<5129,5131,5132>,<5129,5132,5130>,<5130,5132,5133>,<5130,5133,5128>,
            <5128,5133,5131>,
    /*3*/ <5131,5134,5132>,<5132,5134,5133>,<5133,5134,5131>

    /* stem 0.14.20*/ 
    /*0*/ <5135,5136,5137>,<5135,5137,5138>,<5135,5138,5136>,
    /*1*/ <5136,5139,5137>,<5137,5139,5140>,<5137,5140,5138>,<5138,5140,5141>,<5138,5141,5136>,
            <5136,5141,5139>,
    /*2*/ <5139,5142,5140>,<5140,5142,5143>,<5140,5143,5141>,<5141,5143,5144>,<5141,5144,5139>,
            <5139,5144,5142>,
    /*3*/ <5142,5145,5143>,<5143,5145,5144>,<5144,5145,5142>

    /* stem 0.14.21*/ 
    /*0*/ <5146,5147,5148>,<5146,5148,5149>,<5146,5149,5147>,
    /*1*/ <5147,5150,5148>,<5148,5150,5151>,<5148,5151,5149>,<5149,5151,5152>,<5149,5152,5147>,
            <5147,5152,5150>,
    /*2*/ <5150,5153,5151>,<5151,5153,5154>,<5151,5154,5152>,<5152,5154,5155>,<5152,5155,5150>,
            <5150,5155,5153>,
    /*3*/ <5153,5156,5154>,<5154,5156,5155>,<5155,5156,5153>

    /* stem 0.14.22*/ 
    /*0*/ <5157,5158,5159>,<5157,5159,5160>,<5157,5160,5158>,
    /*1*/ <5158,5161,5159>,<5159,5161,5162>,<5159,5162,5160>,<5160,5162,5163>,<5160,5163,5158>,
            <5158,5163,5161>,
    /*2*/ <5161,5164,5162>,<5162,5164,5165>,<5162,5165,5163>,<5163,5165,5166>,<5163,5166,5161>,
            <5161,5166,5164>,
    /*3*/ <5164,5167,5165>,<5165,5167,5166>,<5166,5167,5164>

    /* stem 0.14.23*/ 
    /*0*/ <5168,5169,5170>,<5168,5170,5171>,<5168,5171,5169>,
    /*1*/ <5169,5172,5170>,<5170,5172,5173>,<5170,5173,5171>,<5171,5173,5174>,<5171,5174,5169>,
            <5169,5174,5172>,
    /*2*/ <5172,5175,5173>,<5173,5175,5176>,<5173,5176,5174>,<5174,5176,5177>,<5174,5177,5172>,
            <5172,5177,5175>,
    /*3*/ <5175,5178,5176>,<5176,5178,5177>,<5177,5178,5175>

    /* stem 0.14.24*/ 
    /*0*/ <5179,5180,5181>,<5179,5181,5182>,<5179,5182,5180>,
    /*1*/ <5180,5183,5181>,<5181,5183,5184>,<5181,5184,5182>,<5182,5184,5185>,<5182,5185,5180>,
            <5180,5185,5183>,
    /*2*/ <5183,5186,5184>,<5184,5186,5187>,<5184,5187,5185>,<5185,5187,5188>,<5185,5188,5183>,
            <5183,5188,5186>,
    /*3*/ <5186,5189,5187>,<5187,5189,5188>,<5188,5189,5186>

    /* stem 0.14.25*/ 
    /*0*/ <5190,5191,5192>,<5190,5192,5193>,<5190,5193,5191>,
    /*1*/ <5191,5194,5192>,<5192,5194,5195>,<5192,5195,5193>,<5193,5195,5196>,<5193,5196,5191>,
            <5191,5196,5194>,
    /*2*/ <5194,5197,5195>,<5195,5197,5198>,<5195,5198,5196>,<5196,5198,5199>,<5196,5199,5194>,
            <5194,5199,5197>,
    /*3*/ <5197,5200,5198>,<5198,5200,5199>,<5199,5200,5197>

    /* stem 0.15*/ 
    /*0*/ <5201,5202,5203>,<5201,5203,5204>,<5201,5204,5205>,<5201,5205,5206>,<5201,5206,5202>,
            
    /*1*/ <5202,5207,5203>,<5203,5207,5208>,<5203,5208,5204>,<5204,5208,5209>,<5204,5209,5205>,
            <5205,5209,5210>,<5205,5210,5206>,<5206,5210,5211>,<5206,5211,5202>,<5202,5211,5207>,
    /*2*/ <5207,5212,5208>,<5208,5212,5213>,<5208,5213,5209>,<5209,5213,5214>,<5209,5214,5210>,
            <5210,5214,5215>,<5210,5215,5211>,<5211,5215,5216>,<5211,5216,5207>,<5207,5216,5212>,
    /*3*/ <5212,5217,5213>,<5213,5217,5214>,<5214,5217,5215>,<5215,5217,5216>,<5216,5217,5212>
            

    /* stem 0.15.0*/ 
    /*0*/ <5218,5219,5220>,<5218,5220,5221>,<5218,5221,5219>,
    /*1*/ <5219,5222,5220>,<5220,5222,5223>,<5220,5223,5221>,<5221,5223,5224>,<5221,5224,5219>,
            <5219,5224,5222>,
    /*2*/ <5222,5225,5223>,<5223,5225,5226>,<5223,5226,5224>,<5224,5226,5227>,<5224,5227,5222>,
            <5222,5227,5225>,
    /*3*/ <5225,5228,5226>,<5226,5228,5227>,<5227,5228,5225>

    /* stem 0.15.1*/ 
    /*0*/ <5229,5230,5231>,<5229,5231,5232>,<5229,5232,5230>,
    /*1*/ <5230,5233,5231>,<5231,5233,5234>,<5231,5234,5232>,<5232,5234,5235>,<5232,5235,5230>,
            <5230,5235,5233>,
    /*2*/ <5233,5236,5234>,<5234,5236,5237>,<5234,5237,5235>,<5235,5237,5238>,<5235,5238,5233>,
            <5233,5238,5236>,
    /*3*/ <5236,5239,5237>,<5237,5239,5238>,<5238,5239,5236>

    /* stem 0.15.2*/ 
    /*0*/ <5240,5241,5242>,<5240,5242,5243>,<5240,5243,5241>,
    /*1*/ <5241,5244,5242>,<5242,5244,5245>,<5242,5245,5243>,<5243,5245,5246>,<5243,5246,5241>,
            <5241,5246,5244>,
    /*2*/ <5244,5247,5245>,<5245,5247,5248>,<5245,5248,5246>,<5246,5248,5249>,<5246,5249,5244>,
            <5244,5249,5247>,
    /*3*/ <5247,5250,5248>,<5248,5250,5249>,<5249,5250,5247>

    /* stem 0.15.3*/ 
    /*0*/ <5251,5252,5253>,<5251,5253,5254>,<5251,5254,5252>,
    /*1*/ <5252,5255,5253>,<5253,5255,5256>,<5253,5256,5254>,<5254,5256,5257>,<5254,5257,5252>,
            <5252,5257,5255>,
    /*2*/ <5255,5258,5256>,<5256,5258,5259>,<5256,5259,5257>,<5257,5259,5260>,<5257,5260,5255>,
            <5255,5260,5258>,
    /*3*/ <5258,5261,5259>,<5259,5261,5260>,<5260,5261,5258>

    /* stem 0.15.4*/ 
    /*0*/ <5262,5263,5264>,<5262,5264,5265>,<5262,5265,5263>,
    /*1*/ <5263,5266,5264>,<5264,5266,5267>,<5264,5267,5265>,<5265,5267,5268>,<5265,5268,5263>,
            <5263,5268,5266>,
    /*2*/ <5266,5269,5267>,<5267,5269,5270>,<5267,5270,5268>,<5268,5270,5271>,<5268,5271,5266>,
            <5266,5271,5269>,
    /*3*/ <5269,5272,5270>,<5270,5272,5271>,<5271,5272,5269>

    /* stem 0.15.5*/ 
    /*0*/ <5273,5274,5275>,<5273,5275,5276>,<5273,5276,5274>,
    /*1*/ <5274,5277,5275>,<5275,5277,5278>,<5275,5278,5276>,<5276,5278,5279>,<5276,5279,5274>,
            <5274,5279,5277>,
    /*2*/ <5277,5280,5278>,<5278,5280,5281>,<5278,5281,5279>,<5279,5281,5282>,<5279,5282,5277>,
            <5277,5282,5280>,
    /*3*/ <5280,5283,5281>,<5281,5283,5282>,<5282,5283,5280>

    /* stem 0.15.6*/ 
    /*0*/ <5284,5285,5286>,<5284,5286,5287>,<5284,5287,5285>,
    /*1*/ <5285,5288,5286>,<5286,5288,5289>,<5286,5289,5287>,<5287,5289,5290>,<5287,5290,5285>,
            <5285,5290,5288>,
    /*2*/ <5288,5291,5289>,<5289,5291,5292>,<5289,5292,5290>,<5290,5292,5293>,<5290,5293,5288>,
            <5288,5293,5291>,
    /*3*/ <5291,5294,5292>,<5292,5294,5293>,<5293,5294,5291>

    /* stem 0.15.7*/ 
    /*0*/ <5295,5296,5297>,<5295,5297,5298>,<5295,5298,5296>,
    /*1*/ <5296,5299,5297>,<5297,5299,5300>,<5297,5300,5298>,<5298,5300,5301>,<5298,5301,5296>,
            <5296,5301,5299>,
    /*2*/ <5299,5302,5300>,<5300,5302,5303>,<5300,5303,5301>,<5301,5303,5304>,<5301,5304,5299>,
            <5299,5304,5302>,
    /*3*/ <5302,5305,5303>,<5303,5305,5304>,<5304,5305,5302>

    /* stem 0.15.8*/ 
    /*0*/ <5306,5307,5308>,<5306,5308,5309>,<5306,5309,5307>,
    /*1*/ <5307,5310,5308>,<5308,5310,5311>,<5308,5311,5309>,<5309,5311,5312>,<5309,5312,5307>,
            <5307,5312,5310>,
    /*2*/ <5310,5313,5311>,<5311,5313,5314>,<5311,5314,5312>,<5312,5314,5315>,<5312,5315,5310>,
            <5310,5315,5313>,
    /*3*/ <5313,5316,5314>,<5314,5316,5315>,<5315,5316,5313>

    /* stem 0.15.9*/ 
    /*0*/ <5317,5318,5319>,<5317,5319,5320>,<5317,5320,5318>,
    /*1*/ <5318,5321,5319>,<5319,5321,5322>,<5319,5322,5320>,<5320,5322,5323>,<5320,5323,5318>,
            <5318,5323,5321>,
    /*2*/ <5321,5324,5322>,<5322,5324,5325>,<5322,5325,5323>,<5323,5325,5326>,<5323,5326,5321>,
            <5321,5326,5324>,
    /*3*/ <5324,5327,5325>,<5325,5327,5326>,<5326,5327,5324>

    /* stem 0.15.10*/ 
    /*0*/ <5328,5329,5330>,<5328,5330,5331>,<5328,5331,5329>,
    /*1*/ <5329,5332,5330>,<5330,5332,5333>,<5330,5333,5331>,<5331,5333,5334>,<5331,5334,5329>,
            <5329,5334,5332>,
    /*2*/ <5332,5335,5333>,<5333,5335,5336>,<5333,5336,5334>,<5334,5336,5337>,<5334,5337,5332>,
            <5332,5337,5335>,
    /*3*/ <5335,5338,5336>,<5336,5338,5337>,<5337,5338,5335>

    /* stem 0.15.11*/ 
    /*0*/ <5339,5340,5341>,<5339,5341,5342>,<5339,5342,5340>,
    /*1*/ <5340,5343,5341>,<5341,5343,5344>,<5341,5344,5342>,<5342,5344,5345>,<5342,5345,5340>,
            <5340,5345,5343>,
    /*2*/ <5343,5346,5344>,<5344,5346,5347>,<5344,5347,5345>,<5345,5347,5348>,<5345,5348,5343>,
            <5343,5348,5346>,
    /*3*/ <5346,5349,5347>,<5347,5349,5348>,<5348,5349,5346>

    /* stem 0.15.12*/ 
    /*0*/ <5350,5351,5352>,<5350,5352,5353>,<5350,5353,5351>,
    /*1*/ <5351,5354,5352>,<5352,5354,5355>,<5352,5355,5353>,<5353,5355,5356>,<5353,5356,5351>,
            <5351,5356,5354>,
    /*2*/ <5354,5357,5355>,<5355,5357,5358>,<5355,5358,5356>,<5356,5358,5359>,<5356,5359,5354>,
            <5354,5359,5357>,
    /*3*/ <5357,5360,5358>,<5358,5360,5359>,<5359,5360,5357>

    /* stem 0.15.13*/ 
    /*0*/ <5361,5362,5363>,<5361,5363,5364>,<5361,5364,5362>,
    /*1*/ <5362,5365,5363>,<5363,5365,5366>,<5363,5366,5364>,<5364,5366,5367>,<5364,5367,5362>,
            <5362,5367,5365>,
    /*2*/ <5365,5368,5366>,<5366,5368,5369>,<5366,5369,5367>,<5367,5369,5370>,<5367,5370,5365>,
            <5365,5370,5368>,
    /*3*/ <5368,5371,5369>,<5369,5371,5370>,<5370,5371,5368>

    /* stem 0.15.14*/ 
    /*0*/ 