
// Glenn's POV-Ray Scene File - "After The Jam"
// created 19-Mar-06
// last update 29-Apr-06
//
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 
// You are free:
// - to copy, distribute, display, and perform the work
// - to make derivative works
// - to make commercial use of the work
// Under the following conditions:
// - Attribution. You must give the original author credit.
// - For any reuse or distribution, you must make clear to others the license terms of this work.
// - Any of these conditions can be waived if you get permission from the copyright holder.
// Your fair use and other rights are in no way affected by the above. 
//
//
// This is the main scene file.
//
//
// Scene uses RH coordinate system, Z = up.
// Scene origin in the center of the room on the floor
// with +X towards the right, and +Y heading away from the camera.


//===============================================
//             Scene Switches
//===============================================

// Set this to 2 for best render
#declare Radios       = 2; // 0=off, 1=quick, 2=best radiosity

// Set these to 1 for best render
#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare City         = 1; // 0=off, 1=detailed buildings
#declare DoStudio     = 1; // 0=off, 1=detailed studio
#declare Furnishings  = 1; // 0=off, 1=detailed furniture and decorations
#declare Equipment    = 1; // 0=off, 1=detailed electronics and studio equipment
#declare Instruments  = 1; // 0=off, 1=musical instruments
#declare Music        = 1; // 0=off, 1=musical visualizations
#declare FocalBlur    = 1; // 0=off, 1=camera with focal blur


// Leave these at 0
#declare RenderMe     = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog        = 0; // 0=no fog, 1=fog


#declare My_Cam = 1;
// 1=	Render_Cam
// 8=	Special_Cam

//===============================================
//             Global Settings
//===============================================

#version 3.5;

global_settings {
	assumed_gamma 1
	adc_bailout 1/255 // default 1/255
//	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 30
	number_of_waves 13 // for ripple texture
	noise_generator 2


#switch (Radios)
#case (1)
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
// QUICK TEST
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 0.75       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 20             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .6  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 5      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.08  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.02  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 2    // CHANGE - default 3, 1 or 2 is often sufficient
  }
#break
#case (2)
// FINAL RENDER
//	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
//	ambient_light <0.02,0.02,0.02> // test
	ambient_light <0.06,0.06,0.06> // test
  radiosity{
//    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
    adc_bailout 0.01/0.2// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object      TEST
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 0.55       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
//		brightness 0.95       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity      TEST, washes out music
//    count 20             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    count 60             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out   TEST
//    count 20             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out   PATCH TEST
//    error_bound 2.4      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    error_bound 0.4      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows  TEST
//    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    gray_threshold 0.0   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed   PATCH TEST
    low_error_factor .5  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 5      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
//    nearest_count 1      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20  PATCH TEST
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.06  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.01  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 3    // CHANGE - default 3, 1 or 2 is often sufficient
		save_file "MainSceneRadiosity"
  }
   // end radiosity section
#break
#else
#end
}


//===============================================
//             Includes
//===============================================

#include "GIncludeRH.inc" // Glenn's standard includes
#if (City=1)
	#include "City.inc"
#end
#if (DoStudio=1)
	#include "Studio.inc"
#end
#if (Furnishings=1)
	#include "Furnishings.inc"
#end
#if (Equipment=1)
	#include "AudioEquipment.inc"
#end
#if (Music=1)
	#include "DrumSet_Sounds.inc"
	#include "Guitar_Sounds.inc"
	#include "Piano_Sounds.inc"
	#include "Trumpet_Sounds.inc"
#end
#if (Instruments=1)
	#include "Piano.inc"
	#include "Trumpet.inc"
	#include "Guitar.inc"
	#include "DrumSet.inc"
#end

//===============================================
//             Variables
//===============================================

#declare CamPos = <-8*Feet, 0*Feet, 5*Feet>; // Camera Position
//sphere { <0,0,0>,1 scale 6*Feet texture{pigment{color Green}} translate CamPos }
//cylinder { CamPos,<-2*Feet,0*Feet,16*Feet>,24 texture{pigment{color Green}} }

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <16/9, 0.0,  0.0>  // aspect ratio 16:9=1.78 widescreen
//		right     < 4/3, 0.0,  0.0>  // aspect ratio  4:3=1.33 normal
		right     < 1.0, 0.0,  0.0>  // aspect ratio  1:1=1.00 square
//		right     < 7/8, 0.0,  0.0>  // aspect ratio  7:8=0.87 vertical format
//		right     < 4/5, 0.0,  0.0>  // aspect ratio  4:5=0.80 vertical
//		right     < 3/4, 0.0,  0.0>  // aspect ratio  3:4=0.75 vertical
//	angle 54 // use for 4:3
//	angle 40 // use for 4:5
	angle 50 // use for 1:1
	location CamPos
	look_at <1*Feet,15*Feet,6*Feet> // main render
//	look_at <45*Feet,280*Feet,61*Feet> // look further right
//	look_at <-45*Feet,280*Feet,61*Feet> // look further left
// Focal Blur Section
	#if (FocalBlur=1)
	aperture 1.5 // 9 is too blurry, 1.5 is good
	blur_samples 40
	confidence 0.99
	variance 1/20000
	focal_point <-3*Feet,12*Feet,50>
	#end
// <-2*Feet,15*Feet,50> too far from camera for ap 1.5, looks unreal like diorama
// <-4*Feet,8*Feet,50> too close to camera for ap 1.5, most of scene is blurry

}
#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <4/3,     0.0,  0.0>
	angle 65 // render view
	location CamPos // main render
//	look_at <1*Feet,15*Feet,6*Feet> // main render
//	look_at <20*Feet,1*Feet,6*Feet> // E Wall
//	location <10*Feet,-10*Feet,6*Feet>
//	look_at <-20*Feet,6*Feet,6*Feet> // W Wall
	location <0*Feet,10*Feet,6*Feet>
	look_at <-0*Feet,-20*Feet,6*Feet> // S Wall
}

camera {
#switch (My_Cam)
#case (1) Render_Cam
#break
#else Special_Cam
#end
}

//===============================================
//             Textures
//===============================================

#declare TestWhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient 0 diffuse 0 }
	}
//sphere { <0,0,0>,5*Feet translate <3*Feet,16*Feet,3*Feet> texture {TestWhiteTex } } // test

//===============================================
//             Lighting
//===============================================

/*
#declare Moon =
	light_source {
		<0,0,0>
		color rgb <0.584,0.539,0.543>*0.6 // bluish
	}

object { Moon
	translate <0,0,5*Miles> // noon at Equator: directly overhead
	rotate y*-33 // towards left
  rotate z*40 // behind camera
}
*/

//light_source { 0,0.5 translate <8*Feet,0,8*Feet> } // test only

light_source // FRONT Spot
//	{ <0,0,0>, <1.22,1.14,0.68>*1.2
//	{ <0,0,0>, <1.02,1.04,0.48>*1.2 // deep yellow
//	{ <0,0,0>, <1.02,1.04,0.48>*0.65 // deep yellow, dim test
//	{ <0,0,0>, <1.02,0.94,0.78>*3.6 // paler yellow, too bright?
//	{ <0,0,0>, <1.02,0.94,0.78>*2.4 // paler yellow, test, a bit too dim
	{ <0,0,0>, <1.02,0.94,0.78>*3.0 // paler yellow, test, a bit too dim
//		spotlight point_at <1*Feet,3*Feet,-10*Feet> radius 8 falloff 36 tightness 10 // need more drum light
		spotlight point_at <1*Feet,3*Feet,-10*Feet> radius 8 falloff 44 tightness 10 // test
		translate <4.5*Feet,9*Feet,12*Feet>
/*
		#if (Furnishings=1)
			looks_like { object { StudioLight } }
		#end
*/
	}


light_source // LEFT color spot
//	{ <0,0,0> , <1.13,1.08,0.83>*.8
//	{ <0,0,0> , <1.13,0.308,0.93>*1.2 // rich scarlet
//	{ <0,0,0> , <1.13,0.308,0.93>*0.55 // rich scarlet, too dim
//	{ <0,0,0> , <1.13,0.608,0.93>*1.2 // pale scarlet
	{ <0,0,0> , <1.13,0.608,0.93>*4.5 // TEST

		spotlight point_at <2*Feet,0*Feet,-10*Feet> radius 13 falloff 36 tightness 6
		translate <-6*Feet,10*Feet,12*Feet>
	}


light_source // Brick Fill R
//	{ <0,0,0>, <1.12,0.54,0.50>*1.2
//	{ <0,0,0>, <1.00,0.84,0.70>*1.15 // too bright?
//	{ <0,0,0>, <1.00,0.84,0.70>*0.75 // test, still too bright
	{ <0,0,0>, <1.00,0.84,0.70>*0.50 // test
		spotlight point_at <-3*Feet,4*Feet,-10*Feet> radius 7 falloff 58 tightness 10
//		translate <0.5*Feet,17*Feet,13*Feet> // 1st pillar
		translate <7.0*Feet,17*Feet,13*Feet> // 2nd pillar
//		translate <14.0*Feet,17*Feet,13*Feet> // 3rd pillar
/*
		#if (Furnishings=1)
			looks_like { object { StudioLight } }
		#end
*/
	}

light_source // Brick Fill L
//	{ <0,0,0>, <1.12,0.54,0.50>*1.2
	{ <0,0,0>, <1.00,0.84,0.70>*1.15
		spotlight point_at <-3*Feet,4*Feet,-10*Feet> radius 7 falloff 58 tightness 10
//		translate <0.5*Feet,17*Feet,13*Feet>
		translate <-7.0*Feet,17*Feet,13*Feet>
/*
		#if (Furnishings=1)
			looks_like { object { StudioLight } }
		#end
*/
	}

#if ( DoFog )
fog {
	fog_type 2 // ground fog
	fog_alt 150*Feet
	up <0,0,1>
	distance 5000*Feet // extremely thin
	color rgbt<.45,.47,.50,.2> // nice blue-green haze
}

#end

//===============================================
//             Environment
//===============================================

//background { color rgb <0.576,0.667,0.832>*.97 } // deep blue grey
background { color rgb <0.576,0.667,0.832>*.07 } // dark blue grey

sky_sphere {
	pigment {
		gradient z
		color_map {
			[ 0.50 rgb <0.636,0.667,0.832>*.087 ]
//			[ 0.51 rgb <0.376,0.437,0.632>*.0004 ]
//			[ 0.65 rgb <0.376,0.437,0.632>*.034 ]
			[ 0.65 rgb <0.376,0.437,0.632>*.004 ]
			[ 0.75 rgb <0.176,0.167,0.532>*.004 ]
		}
		turbulence 0.1
	}
	scale 2
	translate -1
}

#declare GroundPlane =
	plane { z,-0.1
		pigment {
			bozo
			color_map {
				[ 0.0 rgb<0.45,0.38,0.26>*0.4 ]
				[ 1.0 rgb<0.45,0.38,0.26> ]
			}
		}
		scale 7*Feet
	}




//===============================================
//             Object Groups
//===============================================



//===============================================
//             Object Placement
//===============================================

/*
light_group {
#if (AreaSun =1)
	object { FillLight }
#end

global_lights on
} // light group
*/

#if (City=1)
	#declare GDL = -10*Feet; // Ground Level
	object { GroundPlane translate <0,0,GDL> }
	object { JazzClub rotate z*0 translate <-12*Feet,40*Feet,GDL> }
	object { NightBuildingRow() rotate z*0 translate <50*Feet,34*Feet,GDL> }
	object { NightBuildingRow() rotate z*0 translate <100*Feet,234*Feet,GDL> }
	object { NightBuildingRow() rotate z*0 translate <-10*Feet,234*Feet,GDL> }
#end                                            

#if (DoStudio=1)
	object { Studio rotate z*0 translate <-20*Feet,-19.5*Feet,0> }
#end

#if (Furnishings=1)
	object { FiveDollarChair rotate z*-130 translate <14.5*Feet,13*Feet,0> }
	object { FiveDollarChair rotate z*-5 translate <9.4*Feet,18*Feet,0> }
	object { FileCabinet rotate z*0 translate <11.2*Feet,17*Feet,0> }
	object { FileCabinet rotate z*0 translate <13*Feet,17*Feet,0> }
//	object { Radiator scale <.85,.85,0.85> translate <-7*Feet,19*Feet,-0.1> }
	object { Radiator scale <.85,.85,0.85> translate <-6*Feet,19.8*Feet,-0.1> }
	object { CrumpledPaper(40,seed(20439)) scale <0.77,0.77,0.66> translate <15.4*Feet,17.5*Feet,1.5> }

	object { CrumpledPaper(20,seed(56097)) scale <0.50,0.59,0.26> translate <10.0*Feet,18.7*Feet,1.0> }
	object { StubbedCigarette rotate z*-145 translate <12.8*Feet,16.6*Feet,0.18> }

	object { PushBroom rotate <0,-16,81> translate <13*Feet,15.8*Feet,0> }
	object { PipeGroup translate <18*Feet,19*Feet,0> }
//	object { Bucket translate <17.5*Feet,18*Feet,0> } // right
	object { Bucket translate <16.2*Feet,19.2*Feet,0> } // left
	object { CardboardBoxStack rotate z*0 translate <17*Feet,17.5*Feet,0> }

	// West Wall
	object { FileCabinet rotate z*90 translate <-17*Feet,14*Feet,0> }
	object { FileCabinet rotate z*90 translate <-17*Feet,12*Feet,0> }
	object { FiveDollarChair rotate z*45 translate <-14.5*Feet,13*Feet,0> }
	object { FiveDollarChair rotate z*125 translate <-16.5*Feet,8*Feet,0> }
light_group {
	object { Kitchenette rotate z*90 translate <-20*Feet+25,-4*Feet,0> } // W wall
	light_source { <0,0,0>,1.2
		spotlight point_at <-6*Feet,3*Feet,-10*Feet> radius 6 falloff 43 tightness 6
		translate <-10*Feet,-8*Feet,10*Feet> }
}
	// East Wall
light_group {
	object { Kitchenette rotate z*-90 translate <20*Feet-25,0,0> } // E wall	
	light_source { <0,0,0>,1.2
		spotlight point_at <6*Feet,3*Feet,-10*Feet> radius 6 falloff 43 tightness 6
		translate <10*Feet,-6*Feet,10*Feet> }
}
	// South Wall
light_group {
	object { Kitchenette rotate z*180 translate <10*Feet+25,-10*Feet+25,0> } // S wall
	light_source { <0,0,0>,1.2
		spotlight point_at <0*Feet,-6*Feet,-10*Feet> radius 6 falloff 43 tightness 6
		translate <8*Feet,0*Feet,10*Feet> }
}
#end

#if (Equipment=1)
	object { MicrophoneGroup(52,75) rotate z*-10 translate <12*Feet,14*Feet,0> } // set it aside
#end

#if (Instruments=1)
object { Piano rotate z*-60 translate <-7.5*Feet,10.5*Feet,0> }
	#if (Furnishings=1)
//		object { AshtrayGroup rotate z*-13 translate <55,10,39.5> rotate z*-60 translate <-7.5*Feet,10.5*Feet,0> } // right
		object { AshtrayGroup rotate z*-13 translate <15,10,39.5> rotate z*-60 translate <-7.5*Feet,10.5*Feet,0> } // left
	#end
object { Trumpet rotate <-65,-6.7,-105> translate <35,45,39.85> rotate z*-60 translate <-7.5*Feet,10.5*Feet,0> }
object { GuitarStand                                             rotate <0,0.4,-25> translate <4.6*Feet,11.8*Feet,-0.11> }
object { ElecGuitar   rotate <0,-90+16, 90> translate <0.0,-3,6> rotate <0,1.2,-25> translate <4.6*Feet,11.8*Feet,-0.06> }
object { PluggedCable rotate <0,-90+16, 90> translate <0.0,-3,6> rotate <0,1.2,-25> translate <4.6*Feet,11.8*Feet,-0.06> }
object { GuitarCable  rotate <0,     0,-45> translate <4.9,-4,0> rotate <0,1.2,-25> translate <4.6*Feet,11.8*Feet,-0.06> }
object { DrumSet rotate z*0 translate <4*Feet,14*Feet,0> }
#end

#if (Music=1)
	object { DrumBeatGroup translate <4*Feet,14.0*Feet,30> }
	object { GuitarSoundGroup translate <5.3*Feet,12*Feet,0> }
	object { PianoSoundGroup(40,seed(70720),3*Feet) rotate z*-60 translate <-4.5*Feet,11*Feet,40> }
	object { TrumpetSoundGroup translate <-4.1*Feet,9.5*Feet,41.2> }
//	object { TestSphereWhite scale <1,1,10> translate <0,0,0> translate <-4.2*Feet,9.5*Feet,41.2> }
#end


// Extras, ignore these
//object { ElecGuitar rotate <90,-90,0> rotate <-7,0,30> translate <-1*Feet,11*Feet,4> }



