
// POV-Ray Object File - Audio Equipment
// created 19-Mar-06
// last update 13-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Microphone
// MicrophoneStand
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare EChromeTex =
	texture {
		pigment { color rgb <0.427,0.647,0.827>*0.3 }
//		finish { ambient .10 specular .79 roughness .025 metallic reflection 0.48 }
		finish { specular 0.99 roughness .005 reflection 0.48 metallic 0.3 brilliance 8 }
	}
#declare BlackChromeTex =
	texture {
		pigment { color rgb <0.427,0.547,0.527>*0.03 }
//		finish { ambient .10 specular .79 roughness .025 metallic reflection 0.48 }
		finish { specular 0.99 roughness .005 reflection 0.48 metallic 0.3 brilliance 8 }
	}
#declare StainlessTex =
	texture {
		pigment { color rgb <0.427,0.647,0.827> }
//		finish { ambient .10 specular .55 roughness .085 metallic }
		finish { specular 0.99 roughness .005 reflection 0.48 metallic 0.3 brilliance 8 }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Microphone
//===============================================

#declare Microphone01 =
	union {
		cone { <0,0,-6>,0.36,<0,0,0>,0.6 }
		sphere { <0,0,0>,0.9
			texture {
				pigment {
					bozo
					color_map {
						[ 0.0 rgb<1,1,1>*.16 ]
						[ 0.4 rgb<1,1,1>*.84 ]
					}
					scale 0.13
				}
			}
		}
		box { <0,-0.3,-2.5>,<1.7,0.3,-3.8> }
		translate <-1.4,0,3.0>
//		texture { EChromeTex }
		texture { BlackChromeTex }
	} // end union

#macro MicrophoneStand(ZHeight)
	union {
		difference {
			sphere { <0,0,0>,5.8 scale <1,1,.17> }
			box { <-20,-20,-20>,<20,20,0.13> }
			texture { EChromeTex }
		} // end difference
		cylinder { <0,0,0>,<0,0,3>,0.58 }
		cylinder { <0,0,0>,<0,0,ZHeight>,0.38 }
		cylinder { <0,0,0>,<0,0,30>,0.44 }
		cylinder { <0,0,28.5>,<0,0,30>,0.58 }
//		texture { EChromeTex }
		texture { BlackChromeTex }
	} // end union
#end

#macro MicrophoneGroup(ZHeight,YDownAngle)
	union {
		object { MicrophoneStand(ZHeight) }
		object { Microphone01 rotate y*YDownAngle translate <0,0,ZHeight> }
	} // end union
#end

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  <2*Feet, -14*Feet, 5.5*Feet> // overall
		look_at <1*Feet,1*Feet,2.5*Feet>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

//MicrophoneGroup(ZHeight,YDownAngle)
object { MicrophoneGroup(52,75) translate <0,0,0> }
object { MicrophoneGroup(38,47) rotate z*24 translate <18,24,0> }

#end

