
// POV-Ray Object File - Drum Set Sound Visualization
// created 13-Apr-06
// last update 29-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// DrumBeatGroup
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here

	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================

#if (RenderMe = 1)
	#local Radios=0;
#end

//===============================================
//             Textures
//===============================================

#declare DBP = color rgb<1.00,.13,0.17>; // basic DrumBeatPigment
/*
#declare DrumBeatTexS =
	texture {
		pigment { DBP }
	}
*/
#macro DrumBeatTex(Maj,Min,Density,BaseHeight)
		#declare D=Density;
		#declare DBGrayVal=(DBP.red+DBP.green+DBP.blue)/3;
		#declare DesatCol=
			rgb<DBGrayVal,DBGrayVal,DBGrayVal>*(1-(BaseHeight+10)/120)
			+DBP*((BaseHeight+10)/120);
		pigment {
			spherical // 1=origin, 0=outer
			color_map {
				[ 0 rgbt<.17,.13,1.00,1.0> ] // outer, Maj, clear
				[ 0.20 color DesatCol transmit 1-D ] // Min
				[ 0.22 color DesatCol*1.5 transmit 1-D ] // Min
				[ 0.24 color DesatCol transmit 1-D ] // Min
				[ 0.50 color DesatCol transmit 1 ] // clear
				[ 1.00 color DesatCol transmit 1 ] // Clear at center
			}
			scale Maj
		}
		#if (Radios)
			finish { ambient 20 diffuse 0 }
		#else
			finish { ambient .6 diffuse 0.4 }
		#end
#end

//===============================================
//             Macros
//===============================================

#macro DrumBeat(Maj,Min,Density,BaseHeight)
	disc {
		<0,0,0>,z, //center, axis
		Maj,Min //outer dia, hole dia
//		texture { DrumBeatTexS }
		texture { DrumBeatTex(Maj,Min,Density,BaseHeight) }
		no_shadow
	}
#end
#macro DrumBeat1(Maj,Min,Density,BaseHeight)
	difference {
		cylinder {
			<0,0,0>,<0,0,0.3+0.05*Maj>,Maj
		}
		cylinder {
			<0,0,-1>,<0,0,1.3+0.05*Maj>,Min
		}
//		texture { DrumBeatTexS }
		texture { DrumBeatTex(Maj,Min,Density,BaseHeight) }
		no_shadow
		no_reflection
	}
#end

//===============================================
//             Sound Rings
//===============================================

#declare BRS=seed(20495);

#declare DrumBeatGroup =
	#union {
		#local BeatN = 0;
		#while (BeatN < 20)
			#local BeatZ = BeatN*8; // height of this beat
			#local Maj = 5.0+0.030*BeatZ+0.004*pow(BeatZ,2);
			#local Min = 1.5+0.023*BeatZ;
			#local Density = 1-(14*Feet-BeatZ)/(14*Feet)*0.75;
			object { DrumBeat(Maj,Min*0.5,Density,BeatZ)
				rotate x*(33-BeatN*2)
				translate <
					-0.3*BeatZ-rand(BRS)*0.2*BeatZ,
					BeatZ*0.2+rand(BRS)*0.5*BeatZ-0.005*pow(BeatZ,2),
					BeatZ
					>
			}
			#local BeatN=BeatN+1;
		#end
	} // end union

		

//===============================================
//             Testing Area
//===============================================

#if (RenderMe = 1)

#local Radios=0;
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 44
		location  <1*Feet, -15*Feet, 5.5*Feet> // overall
		look_at <0*Feet,8*Feet,3*Feet>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <12*Feet,30*Feet,5*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*1.3
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

object { DrumBeatGroup rotate z*20 translate <0,40*Feet,0> }

#end

