
// POV-Ray Object File - Guitar
// created 19-Mar-06
// last update 29-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// ElecGuitar - a Fender Stratocaster
// GuitarStand
// CablePlug
// GuitarCable
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Guitar origin is at the base of the body
// with the neck extending into +x
// and the top side facing +z
// GuitarStand height in +z, with guitar facing -y
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare GuitarTex =
	texture {
//		pigment { color rgb<.227,.207,.996>*0.85 } // too striking yet plain; blue jean blue
//		pigment { color rgb<.127,.107,.596>*0.85 } // a tiny bit too much putty purple, take some red out 
//		pigment { color rgb<.107,.107,.596>*0.65 } // still too much like slate blue, needs darker & richer 
		pigment { color rgb<.047,.047,.596>*0.35 } // just right.
		finish { specular 0.93 roughness 0.023 diffuse 0.4 ambient 0.05 reflection 0.142 }
	}
#declare GPickGuardTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.5 rgb<1,1,1> ]
				[ 0.5 rgb<1,1,1>*0.1 ]
			}
			scale <1,1,0.13>
			translate <0,0,0.05>
		}
		finish { specular 0.80 roughness 0.063 diffuse 0.6 ambient 0.15 }
	}

#local Darkness = 1.32;

#declare NeckWoodTex =
	texture {
		pigment {
			wood // z-axis
			color_map {
/*
// too saturated and zebra
				[ 0.00 color rgb <0.760, 0.352, 0.125>*Darkness ]
				[ 0.20 color rgb <1.000, 0.675, 0.250>*Darkness ]
				[ 0.80 color rgb <1.000, 0.645, 0.304>*Darkness ]
				[ 1.00 color rgb <0.740, 0.352, 0.125>*Darkness ]
*/
				[ 0.00 color rgb <0.760, 0.532, 0.325>*Darkness ]
				[ 0.20 color rgb <1.000, 0.625, 0.420>*Darkness ]
				[ 0.80 color rgb <1.000, 0.605, 0.464>*Darkness ]
				[ 1.00 color rgb <0.740, 0.552, 0.325>*Darkness ]
			}
			scale 0.5
			rotate <0,89,-2>
			turbulence 0.025
			omega 0.45
			lambda 2.3
			warp {
				black_hole <8,2,0>, 6 strength 1 inverse
				repeat <31,0,0> turbulence <6,3,0>
			}
		}
	}

#declare SingleStringTex =
	texture {
		pigment { rgb<1,1,1>*0.55 }
		finish { specular 0.80 roughness 0.014 metallic reflection 0.18 }
	}
#declare CoilStringTex =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.6 rgb<1,1,1>*0.55 ]
				[ 0.7 rgb<1,1,1>*0.08 ]
			}
			scale 0.08
		}
		finish { specular 0.80 roughness 0.014 metallic reflection 0.18 }
	}

#declare FretTex =
	texture {
		pigment { rgb<1,1,1>*0.50 }
		finish { specular 0.93 roughness 0.023 diffuse 0.6 ambient 0.15 }
	}
#declare GIvoryTex =
	texture {
		pigment { rgb<1.00,.952,0.867> }
		finish { specular 0.93 roughness 0.023 diffuse 0.6 ambient 0.15 }
	}
#declare GChromeTex =
	texture {
		pigment { color rgb<.875,.858,.987>*.2 }
		finish { specular 0.99 roughness .005 reflection 0.48 metallic 0.3 brilliance 8 }
	}
#declare StandMetalTex =
	texture {
		pigment { color rgb<.875,.858,.987>*.85 }
		finish { specular 0.95 roughness .018 metallic 0.3 brilliance 8 }
	}
#declare BlackPlasticTex =
	texture {
		pigment { rgb<.025,.025,.045> }
		finish { ambient 0.10 diffuse 0.6 specular 0.32 roughness 0.053 }
	}
#declare BlackCableTex =
	texture {
		pigment { rgb<.0145,.0125,.0125> }
		finish { ambient 0.10 diffuse 0.6 specular 0.22 roughness 0.086 }
	}

//===============================================
//             Macros
//===============================================


//===============================================
//             Guitar Stand
//===============================================

#declare GStandLeg =
	union {
		cylinder { <0,0,0>,<11,0,0>,0.45
			texture { StandMetalTex }
		}
		superellipsoid {
			<0.3,0.8> scale <1.8/2,1.1/2,1.1/2>
			translate <11,0,0>
			texture { BlackPlasticTex }
		}
	} // end union

#declare GuitarStandShaftGroup =
	union {
		cylinder { // main
			<0,0,0>,<0,0,27>,0.85
			texture { StandMetalTex }
		}
		cylinder { // top cap
			<0,0,27>,<0,0,28.5>,1.00
			texture { BlackPlasticTex }
		}
		difference {
			torus { 2.0,0.33 rotate x*90 }
			box { <-3,-3,-1>,<3,0,1> }
			translate <0,-2.0-0.9,26>
			texture { BlackPlasticTex }
		} // end difference
	} // end union
#declare StandBottomHook =
	sphere_sweep {
		cubic_spline
		6,
		<0.0, 0.0, 2.0>,0.45,
		<0.0, 0.0, 0.0>,0.45,
		<0.0,-0.5,-2.0>,0.45,
		<0.0,-1.8,-2.6>,0.45,
		<0.0,-3.2,-2.0>,0.45,
		<0.0,-3.9,-1.0>,0.55
		texture { BlackPlasticTex }
	}

#declare GuitarStand =
	union {
		object { GuitarStandShaftGroup rotate x*-12 translate <0,0,4.3> }
		superellipsoid { // base joint
			<0.5,0.5>
			scale <3/2,3/2,2/2>
			translate <0,0,4.3>
			texture { BlackPlasticTex }
		}
		object { GStandLeg rotate <0,18,  90> translate <0,0,4.3> }
		object { GStandLeg rotate <0,18, -30> translate <0,0,4.3> }
		object { GStandLeg rotate <0,18,-150> translate <0,0,4.3> }
		superellipsoid { // lower arm
			<0.25,0.25>
			scale <10/2,2/2,2/2>
			translate <0,-0.3,8>
			texture { BlackPlasticTex }
		}
		object { StandBottomHook rotate z*-10 translate <-3.5,-1.2,7.65> }
		object { StandBottomHook rotate z*10 translate < 3.5,-1.2,7.65> }
	} // end union
                                        
//===============================================
//             Guitar
//===============================================


//----------------- Body ----------------------

#declare GBodyShape =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Guitar_Body_HFMap.png" // top
			smooth
			water_level 60/255
			scale <20,-1.2,14>
			translate <0,0.25,0>
			texture { GuitarTex }
		}
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Guitar_Body_HFMap.png" // bottom
			smooth
			water_level 60/255
			scale <20,1.2,14>
			translate <0,-0.35,0>
			texture { GuitarTex }
		}
		rotate x*-90
		translate <0.0,-6.8,0>
	} // end union
#declare GPickGuard =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "Guitar_PickGuard_HFMap.png"
		smooth
		water_level 1/255
		scale <20,-1,14>
		rotate x*-90
		translate <0.0,-6.8,0.0>
		texture { GPickGuardTex }
	}
#declare GKnob =
	union {
		cylinder { <0,0,0>,<0,0,0.35>,0.26 }
		cylinder { <0,0,-0.5>,<0,0,0>,0.20 }
		cone { <0,0,0>,0.48,<0,0,0.2>,0.2 }
		texture { GIvoryTex }
	} // end union
#declare GPickup =
	union {
		box { <-0.30,-1.1,0.0>,<0.30,1.1,0.16> }
		cylinder { <0,-1.1,0>,<0,-1.1,0.16>,0.30 }
		cylinder { <0, 1.1,0>,<0, 1.1,0.16>,0.30 }
		#local PN=0;
		#while (PN<6)
			cylinder { <0,0,0>,<0,0,.20>,.092 translate <0,-1.0+0.38*PN,0> texture { GChromeTex } }
			#local PN=PN+1;
		#end
		texture { GIvoryTex }
	} // end union
#declare GPlug =
	difference {
		sphere { <0,0,0>,0.60 scale <1,2,.18> }
		cylinder { <0,0,-0.3>,<0,0,2.1>,0.40 rotate x*60 }
		texture { GChromeTex }
	} // end difference
#declare GSwitch =
	union {
		box { <-0.05,-0.5,-0.2>,<0.05,0.5,0.05> }
		cone { <0,0,0>,0.18,<0,0,0.3>,0.06 rotate x*40 translate <0,-0.5,0.15> texture { GIvoryTex } }
		sphere { <0,0,0>,0.15 scale <1,1,0.5> translate <0,0.84,0.0> }
		sphere { <0,0,0>,0.15 scale <1,1,0.5> translate <0,-0.84,0.0> }
		texture { GChromeTex }                                       
	} // end union

//----------------- Head ----------------------

#declare GHeadShape =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Guitar_Head_HFMap.png"
			smooth
			water_level 2/255
			scale <6.5,-0.25,5.0>
			texture { NeckWoodTex }
		}
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Guitar_Head_HFMap.png"
			smooth
			water_level 2/255
			scale <6.5,0.25,5.0>
			translate <0,-0.06,0>
			texture { NeckWoodTex }
		}
		rotate x*-90
		translate <0,-2.8,0>
	} // end union

#macro StringTuner(Angle)
	union {
		superellipsoid { // handle
			<0.45,0.65>
			scale <0.6/2,0.4/2,0.25/2>
			rotate y*Angle
			translate <0.3,0.9,-0.6>
		}
		cylinder { <0,0,0>,<0,0.8,0>,0.15 translate <0.3,0,-0.6> } // shaft
		cylinder { <0,0,-0.6>,<0,0,0.5>,0.12 } // string axle
//		cylinder { <0,0,-0.6>,<0,0,0.2>,0.20 } // base
		torus { 0.17,0.07 rotate x*90 scale <1,1,.3> translate <0,0,0.25> }
		texture { GChromeTex }
	} // end union
#end

//----------------- Neck ----------------------

#declare GNeckShape =
	union {
	// If you really want the full guitar model, contact me
	text {
		ttf "arialbd.ttf"
		"?" 1,0.24*x
		rotate x*0
		scale <10,10,1>
		rotate z*-90
		translate <6,3,1>
		texture { GuitarTex }
	}
	} // end union

#declare STL=25.5;
#declare SixStrings =
	union {
	} // end union
#declare StringAnchor =
	union {

		texture { GChromeTex }
	} // end union


//----------------- Groups ----------------------

#declare StringGroup =
	union {
		object { SixStrings }
		object { StringAnchor }
	} // end union

#declare GBodyGroup =
	union {
		object { GBodyShape }
		object { GPickGuard }
		object { GPickup translate <13.0,0,1.0> }
		object { GPickup translate <10.5,0,1.0> }
		object { GPickup rotate z*-10 translate <8.4,0,1.0> }
		object { GKnob translate <8.0,-2.0,1.05> }
		object { GKnob translate <7.2,-3.6,1.05> }
		object { GKnob translate <6.1,-4.7,1.05> }
		object { GSwitch rotate z*-45 translate <9.0,-3.5,1.0> }
		object { GPlug rotate z*-45 translate <4.5,-3.8,1.00> }
	} // end union

#declare GHeadGroup =
	union {
		object { GHeadShape }
		object { StringTuner(0)  rotate z*-15 translate <1.0+0.8*0,-0.5+0.23*5,0> } // coil
		object { StringTuner(10) rotate z*-15 translate <1.0+0.8*1,-0.5+0.23*4,0> }
		object { StringTuner(81) rotate z*-15 translate <1.0+0.8*2,-0.5+0.23*3,0> }
		object { StringTuner(22) rotate z*-15 translate <1.0+0.8*3,-0.5+0.23*2,0> }
		object { StringTuner(40) rotate z*-15 translate <1.0+0.8*4,-0.5+0.23*1,0> }
		object { StringTuner(76) rotate z*-15 translate <1.0+0.8*5,-0.5+0.23*0,0> } // single
		box { <-0.08,-0.7,0>,<0.03,0.7,0.45> translate <0,0,0> texture { GIvoryTex } }

	} // end union

#declare GNeckGroup =
	union {
		object { GNeckShape }
//		object { FretGroup translate <0,0,0.0> }
//		object { NeckPips }
		object { GHeadGroup rotate y*8 translate <18,0,-0.3> }
	} // end union

#declare ElecGuitar =
	union {
		object { GBodyGroup translate <-1.5,0,0> }
		object { GNeckGroup translate <12.5,0,1.2> }
		object { StringGroup translate <12.5-7.5,0,1.3> } 
	}

//===============================================
//             Cable
//===============================================

// Cable is intended to be plugged into the guitar which
// is resting on its stand.
#declare CablePlug =
	union {
		cylinder { <-1.5,0,0>,<0,0,0>,0.125 texture { GChromeTex } }
		torus { 0.16,0.05 rotate z*90 translate <0.05,0,0> texture { GChromeTex } }
		cylinder { <0.10,0,0>,<1.8,0,0>,0.20 texture { BlackPlasticTex } }
		sphere { <0,0,0>,0.20 translate <1.8,0,0> texture { BlackPlasticTex } }
	} // end union

#declare CR=0.142; // cable radius
#declare CH=8.15; // cable end height
#declare GuitarCable =
	sphere_sweep {
		cubic_spline
		10,
		<-1,0,CH+1>,CR,
		<0,0,CH>,CR,
//		<1.1,-0.4,CH-1.5>,CR,
		<1.1,0.1,CH-0.6>,CR,
		<4,-1.0,5>,CR,
//		<7,-6.0,1.5>,CR,
		<7,-1.0,1.5>,CR,
		<13,2.0,0.7>,CR,
		<3.0*Feet,1.3*Feet,0.7>,CR,
		<5.0*Feet,3.3*Feet,0.7>,CR,
		<7.4*Feet,8.0*Feet,1.0>,CR,
		<9.0*Feet,3*Feet,1.5>,CR
		texture { BlackCableTex }
	}

#declare PluggedCable =
//	union {
		object { CablePlug rotate <0,-25,-135> translate <3.05,-3.65,0.9> }
//	} // end union

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  <1*Feet, -7*Feet, 2.5*Feet> // overall
		look_at <1.6*Feet,20,18>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }
/*
object { ElecGuitar rotate z*0 translate <0,0,2> }
object { ElecGuitar rotate <90,-90,0> translate <0,14,3> }
object { ElecGuitar scale 3 rotate <90,-90,0> translate <14,18,-80> }
object { ElecGuitar scale 3 rotate <90,-90,-90> translate <25,18,-80> }

object { ElecGuitar scale 2 rotate <90,-90,-50> translate <30,18,0> }
object { ElecGuitar scale 2 rotate <90,-90,-102> translate <40,10,-8> }
*/
object { GuitarStand scale 1 rotate <0,0,0> translate <10,15,0> }
object { ElecGuitar rotate <0,-90+16,90> translate <0,-3,6> translate <10,15,0> }
object { PluggedCable rotate <0,-90+16,90> translate <0,-3,6> translate <10,15,0> }
object { GuitarCable rotate <0,0,-45> translate <4.9,-4,0> translate <10,15,0> }

object { GuitarStand scale 1 rotate <0,0,70> translate <-10,70,0> }
object { ElecGuitar rotate <0,-90+16,90> translate <0,-3,6> rotate <0,0,70> translate <-10,70,0> }

object { GuitarStand scale 1.0 rotate <0,0,-70> translate <50,40,0> }

object { ElecGuitar scale 4 rotate <90,-90,-45> translate <4*Feet,6*Feet,5> }
object { PluggedCable scale 4 rotate <90,-90,-45> translate <4*Feet,6*Feet,5> } 

#end

