
// POV-Ray Object File - Electric Guitar Sound Visualization
// created 13-Apr-06
// last update 25-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// GuitarSoundGroup
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here

	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================

#if (RenderMe = 1)
	#local Radios=0;
#end

//===============================================
//             Textures
//===============================================

//#declare EGP = color rgb<0.17,1.00,.17>; // basic riff color
#declare EGP = color rgb<0.17,0.75,.03>; // basic riff color

#macro GuitarRiffTex(R,G,B,Height,Density)
	#local EGGrayVal=(EGP.red+EGP.green+EGP.blue)/3;
		#declare DesatCol=
			rgb<EGGrayVal,EGGrayVal,EGGrayVal>;
//	texture {
//		pigment { EGP + <R,G,B> transmit 0.8 } // test
		pigment {
			gradient z
			color_map {
				[ 0.08 DesatCol + <R,G,B> transmit 1.0 ]
				[ 0.95 EGP + <R,G,B> transmit 0.99*(1-Density) ]
			}
			scale Height
		}
		#if (Radios)
			finish { ambient 20 diffuse 0 }
		#else
			finish { ambient 1.0 diffuse 0.4 }
		#end
//	}
#end

//===============================================
//             Macros
//===============================================


//===============================================
//             Sounds
//===============================================

#declare EGRS=seed(20495);

#declare EGA1 = // wiggly
	array[9] {
		< 0,-4,-2>
		< 0, 0,0>
		< 2,-0.9*Feet,6>
		<26,-1.8*Feet,3.4*Feet>
		< 7, 1.1*Feet, 5.5*Feet>
		<34,-2.2*Feet,8.4*Feet>
		<-5, 0.6*Feet,11.0*Feet>
		<24,-0.6*Feet,12.8*Feet>
		<38,-2.1*Feet,12.0*Feet>
	}
#macro EGSpline1(RadFactor,Density)
	sphere_sweep {
		b_spline
		9,
		EGA1[0],RadFactor*0.4,
		EGA1[1],RadFactor*0.5,
		EGA1[2],RadFactor*1.0,
		EGA1[3],RadFactor*3,
		EGA1[4],RadFactor*4.5,
		EGA1[5],RadFactor*2.6,
		EGA1[6],RadFactor*1.1,
		EGA1[7],RadFactor*0.5,
		EGA1[8],RadFactor*0.1
		tolerance 1.0e-2
//		texture { GuitarRiffTex1 }
		#local EGSH1=13*Feet;
		texture { GuitarRiffTex(0.1,-0.1,0.3,EGSH1,Density) }
		no_shadow
		no_reflection
	}
#end
#declare EGNote1 =
	union {
		object { EGSpline1(0.40,1.00) } // inner
		object { EGSpline1(0.52,0.50) }
		object { EGSpline1(0.65,0.16) }
		object { EGSpline1(0.80,0.08) }
		object { EGSpline1(1.00,0.04) }
		object { EGSpline1(1.20,0.02) } // outer
	} // end union

#declare EGA2 = // S-shaped
	array[6] {
		<  0,-4,-7>
		<  0, 0,0>
		< -2,-1.1*Feet, 1.6*Feet>
		< 24, 2.1*Feet, 3.5*Feet>
		<-22, 0.6*Feet, 7.0*Feet>
		<  8,-2.1*Feet, 9.0*Feet>
	}
//#declare EGShape2 =
#macro EGSpline2(RadFactor,Density) // S-shaped
	sphere_sweep {
		b_spline
		6,
		EGA2[0],RadFactor*0.4,
		EGA2[1],RadFactor*0.5,
		EGA2[2],RadFactor*1.0,
		EGA2[3],RadFactor*2.5,
		EGA2[4],RadFactor*1.1,
		EGA2[5],RadFactor*0.1
		tolerance 1.0e-2
//		texture { GuitarRiffTex2 }
		#local EGSH2=9*Feet;
		texture { GuitarRiffTex(0.2,0.1,0.2,EGSH2,Density) }
		no_shadow
		no_reflection
	}
#end
#declare EGNote2 = // S-shaped
	union {
		object { EGSpline2(0.30,1.000) } // inner
		object { EGSpline2(0.45,0.400) }
		object { EGSpline2(0.61,0.200) }
		object { EGSpline2(0.76,0.140) }
		object { EGSpline2(0.94,0.086) }
		object { EGSpline2(1.15,0.042) } // outer

	} // end union


//#macro SparkSphere(SRad)
#declare SparkSphere =
	sphere {
		<0,0,0>,1
		texture {
			pigment {
				cylindrical
				color_map {
					[ 0.1 EGP+<.2,-0.13,.4> transmit 1.0 ] // outside edge
					[ 0.9 EGP+<.02,-0.08,.5> transmit 0.1 ] // center
				}
			}
			#if (Radios)
				finish { ambient 20 diffuse 0 }
			#else
				finish { ambient 1.0 diffuse 0.4 }
			#end
		}
	}
//#end

#declare XFadePig =
	pigment {
		gradient x
		color_map {
			[ 0.0 EGP+<.2,-0.13,.4> ]
			[ 0.9 EGP+<.2,-0.13,.4> transmit 1 ]
		}
	}
#declare SparkSpikeX =
//	box { <0,-0.05,-0.05>,<2,0.05,0.05>
	box { <0,0,-0.2>,<3,0.001,0.2>
		texture {
			pigment {
				gradient z
				pigment_map {
					[ 0.0 rgbt<1,1,1,1> ]
					[ 0.4 XFadePig ]
					[ 0.6 XFadePig ]
					[ 1.0 rgbt<1,1,1,1> ]
				}
				translate <0,0,-0.5>
				scale <3,.4,.4>*1.01
			}
			#if (Radios)
				finish { ambient 20 diffuse 0 }
			#else
				finish { ambient 1.0 diffuse 0.4 }
			#end
		}
	}
#macro Spark(Spin,Tilt)
	union {
		object { SparkSphere scale 1 }
		object { SparkSpikeX rotate y*0+Tilt }
		object { SparkSpikeX rotate y*90+Tilt }
		object { SparkSpikeX rotate y*180+Tilt }
		object { SparkSpikeX rotate y*270+Tilt }
		rotate z*Spin
	} // end union
#end
#declare GuitarSoundGroup =
	#union {
		object { EGNote1 scale 0.5 rotate x*-6 translate <0,-2,12>}
		object { Spark(-50,45) scale 0.6 translate <12,2,5.7*Feet> translate <-1,0,18> }

		object { EGNote2 translate <-1,0,18> }
		object { Spark(-50,45) scale 1.5 translate <-9.5, 4, 6.8*Feet> translate <-1,0,18> }

	} // end union

		

//===============================================
//             Testing Area
//===============================================

#if (RenderMe = 1)

#local Radios=0;
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 44
		location  <1*Feet, -20*Feet, 5.5*Feet> // overall
		look_at <0*Feet,2*Feet,6*Feet>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

//background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <12*Feet,3*Feet,5*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*1.3
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

object { GuitarSoundGroup rotate z*50 translate <-4*Feet,0,2> }
//object { GuitarSoundGroup rotate z*0 translate <-4*Feet,0,2> }
//object { GuitarSoundGroup rotate z*90 translate <4*Feet,0,2> }

#end

