
// POV-Ray Object File - Piano Sound Visualization
// created 21-Apr-06
// last update 28-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// PianoSoundGroup
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here

	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================

#if (RenderMe = 1)
	#local Radios=0;
#end

//===============================================
//             Textures
//===============================================

#macro PianoNoteTex(RSeed,Density,BaseHeight)
//	texture {
		#local BL=0.3+rand(RSeed)*0.6; // Blue Level
		#local BH=BaseHeight;
		#local D=Density;
		pigment {
			gradient z
			color_map {
				[ 0.00 rgbt<1.00,1.00,1.00,1.0> ] // bottom, clear
				[ 0.20 rgbt<1.00,1.00,1.00,0.97> ]
				[ 0.55 rgbt<0.70,0.70,1.00,max(.85-BH*.002,1-D)> ]
				[ 0.80 rgbt<0.36,0.36,1.00,1-D> ]
				[ 0.82 rgbt<2.00,2.00,2.00,1-D> ]
				[ 0.87 rgbt<BL*0.1+rand(RSeed)*0.3,BL*0.1+rand(RSeed)*0.3,BL,1-D> ] // top head
			}
		}
		#if (Radios)
//			finish { ambient 30 diffuse 0 }
			finish { ambient 10+BaseHeight*0.4 diffuse 0 } // higher = more saturated
		#else
//			finish { ambient 1 diffuse 0 }
			finish { ambient .8 diffuse 0.4 }
		#end
//	}
#end

#declare ClearTex =
	texture { pigment { rgbt<1,1,1,1> } }

//===============================================
//             Macros
//===============================================


//===============================================
//             Sounds
//===============================================

#macro PianoNote(RSeed,Density,BaseHeight)
	difference {
		superellipsoid {
			<0.3,0.3>
			scale 0.5 translate 0.5
			texture { PianoNoteTex(rand(RSeed),Density,BaseHeight) }
		}
		box { <-1,0,-1>,<1,1,1> rotate z*25 texture { ClearTex } }
	} // end difference
#end

// PNN = number of piano notes per vertial column
#macro PianoSoundGroup(PNN,RSeed,WaveHeight)
	union {
//		#local MR=6; // max rows
		#local MR=3; // max columns
		#local TR=0; // this column

		#while (TR<MR)
			#local WH=WaveHeight;
			#local PNC=0;
			#local PInc=3.5;
			#while (PNC<PNN)
				#local PCH = PNC*PInc; // Current Height
				#declare Density=0.24-0.20*(8*Feet-PCH)/(8*Feet); // density increases with height, .24 at top
//				#declare Density=.2;
				object { PianoNote(rand(RSeed),Density,PCH)
					scale <
						0.5+0.05*PNC,
						0.5+0.05*PNC,
						2.5+PNC*0.50+rand(RSeed)*5
					>
					translate <
						(WH/5*PCH/30) * sin((PCH/WaveHeight)*(2*pi))+rand(RSeed),
//						TR*2.0+PCH*TR*0.1+rand(RSeed)*PCH*0.2,
						TR*4.0+PCH*TR*0.1+rand(RSeed)*PCH*0.2-PCH*PCH*0.006,
						PCH+rand(RSeed)*2+rand(RSeed)*PCH*0.05
					>
				}
				#local PNC=PNC+1;
			#end
			#local TR=TR+1;
		#end

	object { PianoNote(rand(RSeed),0.06,20) scale <0.93,0.93,8> rotate x*11 translate <-16,0,53> } // off note
	} // end union
#end


//===============================================
//             Testing Area
//===============================================

#if (RenderMe = 1)

#local Radios=0;
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 50
		location  <.5*Feet, -8*Feet, 2.5*Feet> // overall
		look_at <0*Feet,0*Feet,3*Feet>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <12*Feet,-30*Feet,5*Feet>, 1.0
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,1.03>*1.0
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

object { PianoSoundGroup(40,seed(70720),3*Feet) rotate z*-30 translate <0,0,3> }


#end

