
// POV-Ray Object File - Trumpet
// created 8-Apr-06
// last update 13-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Trumpet
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare TrumpetTex =
	texture {
		pigment { color rgb<.967,.957,.296>*0.3645 }
		finish { ambient 0.0 diffuse 0.5 specular 0.93 roughness 0.023 metallic reflection 0.642 }
	}
#declare TrumpetSilverTex =
	texture {
		pigment { color rgb<.967,.757,.706>*0.605 }
		finish { ambient 0.10 diffuse 0.5 specular 0.93 roughness 0.023 metallic reflection 0.342 }
	}
#declare TBlackTex =
	texture {
		pigment { color rgb<0,0,0> }
	}
#declare WhiteIvoryTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.3 rgb<1,1,1>*1.4 ]
				[ 0.8 rgb<1,1,1>*0.7 ]
			}
			scale 0.12
		}
		finish { specular 0.30 roughness 0.08 }
	}
#declare TestWhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Trumpet
//===============================================

// Trumpet origin at base of bell, keys in +z, bell extends into +X
#declare TubeRad = 0.26;
#declare TrumpetBell =
	union {
		difference {
			sor { // <Rad,Y-Dim>, first & last for slope only
				11,
				<TubeRad,-1.00>
				<TubeRad,0.00>
				<0.30,4.00>
				<0.40,8.00>
				<0.50,12.00>
				<0.60,14.00>
				<0.75,15.00>
				<1.15,16.00>
				<1.90,17.00>
				<2.30,17.40>
				<2.90,18.00>
				sturm
			}
			sor { // <Rad,Y-Dim>, first & last for slope only
				11,
				<TubeRad,-1.00>
				<TubeRad,0.00>
				<0.30,4.00>
				<0.40,8.00>
				<0.50,12.00>
				<0.60,14.00>
				<0.75,15.00>
				<1.15,16.00>
				<1.90,17.00>
				<2.30,17.40>
				<2.90,18.00>
				sturm
				translate <0,0.12,0>
			}
		} // end difference
		torus {
			2.30,0.08
			translate <0,17.40-0.08,0>
		}
		texture { TrumpetTex }
	} // end union

#macro HalfTorus(Maj,Min)
	difference {
		torus { Maj,Min }
		box { <0,-Maj-Min-1,-Maj-Min-1>,<Maj+Min+1,Maj+Min+1,Maj+Min+1> }
		texture { TrumpetTex }
	} // end difference
#end
#macro QtrTorus(Maj,Min)
	difference {
		torus { Maj,Min }
		box { <0,-Maj-Min-1,-Maj-Min-1>,<Maj+Min+1,Maj+Min+1,Maj+Min+1> }
		box { <-Maj-Min-1,-Maj-Min-1,-Maj-Min-1>,<Maj+Min+1,Maj+Min+1,0> }
		texture { TrumpetTex }
	} // end difference
#end

#declare KeyAssy =
	union {
		cylinder { // main
			<0,0,-4>,<0,0,0>,0.35
		}
		torus { 0.35,0.08 rotate x*90 translate <0,0,0> }
		torus { 0.35,0.08 rotate x*90 translate <0,0,-4> }
		cylinder { <0,0,-0.1>,<0,0,0>,0.35 texture { TBlackTex } }
		cylinder { <0,0,0>,<0,0,0.5>,0.10 texture { TrumpetSilverTex } }
		cylinder { <0,0,0.5>,<0,0,0.75>,0.27 texture { WhiteIvoryTex } }
		torus { 0.27,0.084 rotate x*90 translate <0,0,0.70> texture {TrumpetSilverTex } } 
		torus { 0.27,0.104 rotate x*90 translate <0,0,0.55> texture {TrumpetSilverTex } } 
		texture { TrumpetTex }
	} // end union

#macro TTube(Length,TubeRad)
	cylinder { <0,0,0>,<Length,0,0>,TubeRad texture { TrumpetTex } }
#end

#declare LeftTor =
	object { HalfTorus(1.5,TubeRad) }
//#declare BotTube =
//	cylinder { <0,0,0>,<4.7,0,0>,TubeRad texture { TrumpetTex } }
#declare FrontLoop =
	object { HalfTorus(0.4,TubeRad) texture { TrumpetTex } }
#declare RightTor =
	object { HalfTorus(1.1,TubeRad) texture { TrumpetTex } }

//#declare TopTube =
//	cylinder { <-14,0,0>,<0,0,0>,TubeRad texture { TrumpetTex } }

#macro U_Group(Maj,TubeRad,Length)
	union {
		object { HalfTorus(Maj,TubeRad) }
		object { TTube(Length,TubeRad) translate <0,0,Maj> }
		object { TTube(Length,TubeRad) translate <0,0,-Maj> }
	} // end union
#end

#declare TMouthPiece =
	sor { // <Rad,Y-Dim>, first & last for slope only
		14,
		<0.20,-0.20>
		<0.44,0.02>
		<0.44,0.30>
		<0.38,0.33>
		<0.34,0.48>
		<0.34,0.75>
		<0.30,0.85>
		<0.18,1.00>
		<0.18,1.28>
		<0.24,1.38>
		<0.19,1.46>
		<0.21,1.62>
		<0.21,2.60>
		<0.21,3.00>
		texture { TrumpetSilverTex }
	}

#declare Trumpet =
	union {
		object { TrumpetBell rotate z*-90 }
		object { LeftTor translate <0,0,-1.5> rotate x*-16 }
		object { TTube(4.7,TubeRad) translate <0,0,-3.0> rotate x*-16 } // Bot Tube

//		object { FrontLoop scale x*-1 translate <0,0,0.4> rotate x*16 translate <10.6,0,-3.0> }

		object { TMouthPiece rotate z*-90 translate <-4.2,-1.7,0> }
		object { TTube(-14,TubeRad) translate <12,-1.7,0> }
		object { RightTor scale <-1,1,1> translate <0,0,-1.1> rotate x*-10 translate <12,-1.7,0> }
		object { TTube(-5.75,TubeRad) translate <0,0,-2.2> rotate x*-10 translate <12,-1.7,0> }
		object { QtrTorus(0.6,TubeRad) translate <0,0,-0.6> rotate x*90 translate <0,0,-2.2> rotate x*-10 translate <12-5.75,-1.7,0> }

		object { KeyAssy translate <3.75,-1.0,0.5> }
		object { KeyAssy translate <4.75,-1.0,0.5> }
		object { KeyAssy translate <5.75,-1.0,0.5> }

		object { U_Group(0.45,TubeRad,2.5) translate <1.2,-1.0,-2.2> } // rearmost
		object { U_Group(0.45,TubeRad,1.5) rotate z*45 translate <3.9,-2.0,-2.2> } // short
		object { U_Group(0.60,TubeRad,5.8) scale <-1,1,1> translate <10.7,-1.0,-2.2> } // front
	} // end union

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  <0.5*Feet, -5*Feet, 2.5*Feet> // overall
		look_at <12,0,20>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

#object { Trumpet rotate z*0 translate <0,0,10> }
#object { Trumpet rotate z*50 translate <0,10,15> }
#object { Trumpet rotate z*-130 translate <30,30,20> }
#object { Trumpet rotate <0,20,-50> translate <10,30,30> }
#object { KeyAssy scale 8 rotate <100,10,30> translate <-5,30,30> }
#end

