#include "colors.inc"
#include "textures.inc"

global_settings {assumed_gamma 1.0}
background {rgb <1,0.9,0.9>}
camera {location <0,8,-20> look_at <0, 8, 0>}
light_source {<500,500,-500> color White}

//DMFWood6 texture from texture.inc
#declare HarpTexture = texture {DMFWood6 rotate x*90}; 

#declare CutIn =
union {
  cylinder {<0, 0.5, 0>, <0, 8, 0>, 0.166}
  sphere {<0, 8, 0>, 0.166}
}

#declare CutIn2 =
union {
  cylinder {<0, -0.75, 0>, <0, -2.5, 0>, 0.25}
  sphere {<0, -0.75, 0>, 0.25}
}

#declare BasicPost = 
union {
  cylinder {<0, 0, 0>, <0, 9, 0>, 0.5}
  lathe {
    quadratic_spline
    10,
    <0,0>, <0.75,0>, <0.5,0.5>, <0.5,7>, <0.5, 8>, <0.75,8.5>, <0.5,9>, <1,10>, <1,10.5>, <0, 10.5>
  }
}

#declare PostBase =
difference{
  union{
    prism {
      linear_sweep
      linear_spline
      0,
      3,
      7,
      <-0.8,0>, <-0.4,0.8>, <0.4,0.8>, <0.8,0>, <0.4,-0.8>, <-0.4,-0.8>, <-0.8,0>
      translate y*-3
    }
    prism {
      conic_sweep
      linear_spline
      0,
      1,
      7,
      <-1,0>, <-0.5,1>, <0.5,1>, <1,0>, <0.5,-1>, <-0.5,-1>, <-1,0>
      rotate x*180
      scale <1, 2, 1>
      translate y*-1
    }
    prism {
      conic_sweep
      linear_spline
      0,
      1,
      7,
      <-1,0>, <-0.5,1>, <0.5,1>, <1,0>, <0.5,-1>, <-0.5,-1>, <-1,0>
      scale <1, 2, 1>
      translate y*-2
    }
    rotate y*30
  }
  object {CutIn2 translate x*0.8 rotate y*60}
  object {CutIn2 translate x*0.8 rotate y*120}
  object {CutIn2 translate x*0.8 rotate y*180}
  object {CutIn2 translate x*0.8 rotate y*240}
  object {CutIn2 translate x*0.8 rotate y*300}
  object {CutIn2 translate x*0.8}
}  

#declare Post =
union{
  difference {
    object {BasicPost}
    object {CutIn translate x*0.5 rotate y*60}
    object {CutIn translate x*0.5 rotate y*120}
    object {CutIn translate x*0.5 rotate y*180}
    object {CutIn translate x*0.5 rotate y*240}
    object {CutIn translate x*0.5 rotate y*300}
    object {CutIn translate x*0.5}
  }
  object {PostBase}
  translate y*3
}

#declare HarpBack = 
difference {
  cone {<0, 0, 0>, 2, <0, 10, 0>, 0.5}
  box {<-2.1, -0.1, -2.1>, <0, 10.1, 2.1>}
}

#declare HarpBase =
union {
  difference {
    cylinder {<0, 0, 0>, <0, -0.5, 0>, 2.1}
    box {<-2.1, -0.6, -2.1>, <-0.5, 0.1, 2.1>} 
    translate x*1.2
  }
  cylinder {<0, 0, 0>, <0, -0.5, 0>, 1.5 translate x*0.25}
}

#macro BuildSwoop (p0, p1, p2, p3, p4, p5, p6, Part)
  #if (Part = 1)
    #declare HarpSweep = 
    union {
  #end
  #if (Part = 2)
    #declare Buffers =
    union {
  #end
  #if (Part = 3)
    #declare Keys =
    union {
  #end
  #if (Part = 4)
    #declare Strings = 
    union {
  #end
  #local Segment = 0;
  #while (Segment <= 3)
    #local S = 0;
    #if (Part > 1)
      #if (Segment = 0)
        #local S = 0.5;
      #end
    #end
    #while (S < 1)
      #local h1 = 2*pow(S, 3) - 3*pow(S, 2) + 1;
      #local h2 = -2*pow(S, 3) + 3*pow(S, 2);
      #local h3 = pow(S, 3) - 2*pow(S, 2) + S;
      #local h4 = pow(S, 3) - pow(S, 2);
      #switch (Segment)
        #case (0) 
          #local t1 = 0.5*(p2-p0);
          #local t2 = 0.5*(p3-p1);
          #local Point = h1*p1 + h2*p2 + h3*t1 + h4*t2;
          #if (Part = 1)
            #local Incr = (p1.x + p2.x)/80;
          #end
          #if (Part > 1)
            #local Incr = (p1.x + p2.x)/20;
          #end
        #break
        #case (1) 
          #local t1 = 0.5*(p3-p1);
          #local t2 = 0.5*(p4-p2);
          #local Point = h1*p2 + h2*p3 + h3*t1 + h4*t2;
          #if (Part = 1)
            #local Incr = (p2.x + p3.x)/400;
          #end
          #if (Part > 1)
            #local Incr = (p2.x + p3.x)/66;
          #end
        #break
        #case (2) 
          #local t1 = 0.5*(p4-p2);
          #local t2 = 0.5*(p5-p3);
          #local Point = h1*p3 + h2*p4 + h3*t1 + h4*t2;
          #if (Part = 1)
            #local Incr = (p3.x + p4.x)/750;
          #end
          #if (Part > 1)
            #local Incr = (p3.x + p4.x)/150;
          #end
        #break 
        #case (3) 
          #local t1 = 0.5*(p5-p3);
          #local t2 = 0.5*(p6-p4);
          #local Point = h1*p4 + h2*p5 + h3*t1 + h4*t2;
          #if (Part = 1)
            #local Incr = (p4.x + p5.x)/400;
          #end
          #if (Part > 1)
            #local Incr = p4.x + p5.x;
          #end
        #break 
      #end
      #if (Part= 1)
        sphere {Point, 0.25}
        box {<Point.x - 0.125, Point.y - 1, Point.z - 0.125>, <Point.x, Point.y, Point.z + 0.125> }
      #end
      #if (Part = 2)
        cone {<Point.x, Point.y - 0.75, Point.z - 0.125>, 0.1, <Point.x, Point.y - 0.75, Point.z - 0.25>, 0.05}
      #end 
      #if (Part = 3)
        prism {
          linear_sweep
          linear_spline
          0,
          0.05,
          5,
          <-0.05, 0>, <0.05, 0>, <0.1, -0.125>, <-0.1, -0.125>, <-0.05, 0>
          rotate z*rand(MySeed)*360
          translate <Point.x, Point.y, Point.z-0.25>
        }
      #end
      #if (Part = 4)
        #local BaseY = 1.5*Point.x;
        cylinder {<Point.x, BaseY, 0>, <Point.x, Point.y, Point.z-0.25>, 0.01}
      #end
      #local S=S+Incr;
    #end
    #local Segment = Segment + 1;
  #end
  }
#end

#declare p0 = <-1, 12, 0>;
#declare p1 = <0, 12, 0>;
#declare p2 = <2, 12, 0>;
#declare p3 = <3.2, 8.5, 0>;
#declare p4 = <6.4, 11.5, 0>;
#declare p5 = <6.4, 10.5, 0>;
#declare p6 = <5.4, 9, 0>;

BuildSwoop (p0, p1, p2, p3, p4, p5, p6, 1)


#declare Harp =
union {
  union {
    object {Post}
    object {HarpBack
      matrix <  1,  0,  0,
                0.5,  1,  0,
                0,  0,  1, 
                1.2,  0,  0 >
    }
    object {HarpBase}
    translate y*0.5 
  }
  object {HarpSweep}
}

BuildSwoop (p0, p1, p2, p3, p4, p5, p6, 2)

#declare MySeed = seed(6573);
BuildSwoop (p0, p1, p2, p3, p4, p5, p6, 3)

BuildSwoop (p0, p1, p2, p3, p4, p5, p6, 4)

#declare FullHarp =
union {
  object {Harp
    texture {HarpTexture}
  }
  object {Buffers
    texture {
      pigment {Black}
      finish {
        specular 0.9
        roughness 0.01
      }
    }
  }
  object {Keys
    texture{
      pigment {BrightGold}
      finish {
        metallic
        specular 1
        roughness 0.0001
      }
    }
  }
  object {Strings
    texture{
       pigment {BrightGold}
       finish {
         metallic
         specular 1
         roughness 0.0001
       }
    }
  }
}

//object {FullHarp scale 4 rotate z*-15}
object {FullHarp}