#version unofficial megapov 1.21;

#include "colors.inc"
#include "Maketree.pov"
#include "txttree.inc"
#include "Flowers.pov"
#include "MorningGlory1.inc"
#include "MorningGlory2.inc"
#include "MorningGlory3.inc"
#include "MorningGlory4.inc"
#include "MorningGlory5.inc"

//camera { location <0,30,-30> look_at 0 }
//light_source { <-100,100,-100> color White }
//background {rgb 0.8}

//Vine variables
//#declare VineSegments = 100; //number of point in vine spline
//#declare VineLengthBasic = 10; //basic length of vine segment between spline points
//#declare VineLengthVariation = 2; //units variation of basic length (plus or minus)
//#declare VineThickness = 0.1; //vine thickness
//#declare LeafFrequency = 1; //number of leaves per vine segment; set to zero to turn off leaves/flowers
//#declare LeafScale = 1; //relative size of leaves
//#declare FlowerProbability = 0.1; //percent probability that a flower will appear instead of a leaf
//#declare FlowerScale = 1; //relative size of flowers

//Bounding box for vine
//#declare MinX = -650;
//#declare MaxX = 650;
//#declare MinY = 0;
//#declare MaxY = 20;
//#declare MinZ = -650;
//#declare MaxZ = -400;

//Random seed declarations
//#declare Xseed = seed(102);
//#declare Yseed = seed(98);
//#declare Zseed = seed(85);
//#declare AngleSeed = seed(6432);
//#declare VarSeed = seed(53421);
//#declare LeafRotSeed = seed(4562);
//#declare FlowerSeed = seed(91);

//#declare ShowBox = true; //display visual bounding box?
//#declare ShowVines = false; //draw vines?


//********************Begin Vine Macro********************
#macro DrawVines ()

//**************Short detour to create leaves*************
  #declare dofile = false;
  #declare ffname="leaf.inc"
  #declare txtLeaf=texture{txtLeaf_0};
  
  #declare Leaf=object{MakeLeaf(0.3,10,5,2,0.4,3,100,1,0,1,0,0,3,0.12,10,dofile,ffname)} //Calls Gilles Tran's Makeleaf macro
//******************End of Leaves*************************


//***********Visual bounding box**************************
  #declare LineThickness = 1;
  #if (ShowBox)
    sphere {<MinX, MaxY, MaxZ>, LineThickness pigment {Red}}
    sphere {<MinX, MaxY, MinZ>, LineThickness pigment {Red}}
    sphere {<MaxX, MaxY, MaxZ>, LineThickness pigment {Red}}
    sphere {<MaxX, MaxY, MinZ>, LineThickness pigment {Red}}
    sphere {<MinX, MinY, MaxZ>, LineThickness pigment {Red}}
    sphere {<MinX, MinY, MinZ>, LineThickness pigment {Red}}
    sphere {<MaxX, MinY, MaxZ>, LineThickness pigment {Red}}
    sphere {<MaxX, MinY, MinZ>, LineThickness pigment {Red}}
    cylinder {<MinX, MaxY, MaxZ>, <MinX, MaxY, MinZ>, LineThickness pigment {Red}}
    cylinder {<MaxX, MaxY, MaxZ>, <MaxX, MaxY, MinZ>, LineThickness pigment {Red}}
    cylinder {<MinX, MaxY, MaxZ>, <MaxX, MaxY, MaxZ>, LineThickness pigment {Red}}
    cylinder {<MinX, MaxY, MinZ>, <MaxX, MaxY, MinZ>, LineThickness pigment {Red}}
    cylinder {<MinX, MinY, MaxZ>, <MinX, MinY, MinZ>, LineThickness pigment {Red}}
    cylinder {<MaxX, MinY, MaxZ>, <MaxX, MinY, MinZ>, LineThickness pigment {Red}}
    cylinder {<MinX, MinY, MaxZ>, <MaxX, MinY, MaxZ>, LineThickness pigment {Red}}
    cylinder {<MinX, MinY, MinZ>, <MaxX, MinY, MinZ>, LineThickness pigment {Red}}
    cylinder {<MinX, MaxY, MaxZ>, <MinX, MinY, MaxZ>, LineThickness pigment {Red}}
    cylinder {<MaxX, MaxY, MaxZ>, <MaxX, MinY, MaxZ>, LineThickness pigment {Red}}
    cylinder {<MaxX, MaxY, MinZ>, <MaxX, MinY, MinZ>, LineThickness pigment {Red}}
    cylinder {<MinX, MaxY, MinZ>, <MinX, MinY, MinZ>, LineThickness pigment {Red}}
  #end

//****************Begin Vine Spline***********************

  #if (ShowVines = true)

    //Calculate total variance between bounding points
    #declare XVar = MaxX - MinX;
    #declare YVar = MaxY - MinY;
    #declare ZVar = MaxZ - MinZ;
    
    #declare MinEdge = false; //toggles whether max edge found
    #declare MaxEdge = false; //toggles whether min edge found
    
    //Begin spline creation
    #declare SplineCount = 1;
    #declare VineSpline =
    spline {
      cubic_spline
      
      //Initial control point
      #declare XPoint = (rand(Xseed)+MinX/XVar)*XVar;
      #declare YPoint = (rand(Yseed)+MinY/YVar)*YVar;
      #declare ZPoint = (rand(Zseed)+MinZ/ZVar)*ZVar;
      
      SplineCount-1, <XPoint, YPoint, ZPoint>
      
      #while (SplineCount <= VineSegments)
    
        #if (MaxEdge) //redirect vine away from max edge
          #declare Rangle = (rand(AngleSeed) - 1)*90;
          #declare MaxEdge = false;
        #else
          #if (MinEdge) //redirect vine away from min edge
            #declare Rangle = rand(AngleSeed)*90;
            #declare MinEdge = false;
          #else //pick a random direction!
            #declare Rangle = (rand(AngleSeed)*90) - 45;
          #end
        #end
        #declare VineLengthVar = (rand(VarSeed)*VineLengthVariation*2) - VineLengthVariation;
        #declare VineLength = VineLengthBasic + VineLengthVar;
        #declare XPoint = XPoint + VineLength*cos(Rangle);
        #declare YPoint = (rand(Yseed)+MinY/YVar)*YVar;
        #declare ZPoint = ZPoint + VineLength*sin(Rangle);
        
        //Keep vine within bounds
        #if (XPoint > MaxX)
          #declare XPoint = MaxX;
          #declare MaxEdge = true;
        #end
        #if (XPoint < MinX)
          #declare XPoint = MinX;
          #declare MinEdge = true;
        #end
        #if (ZPoint > MaxZ)
          #declare ZPoint = MaxZ;
          #declare MaxEdge = true;
        #end
        #if (ZPoint < MinZ)
          #declare ZPoint = MinZ;
          #declare MinEdge = true;
        #end
        
        SplineCount, <XPoint, YPoint, ZPoint>
        
        #declare SplineCount = SplineCount + 1;
      #end
      
      //Final control point
      #declare XPoint = XPoint + VineLength*cos(Rangle);
      #declare YPoint = (rand(Yseed)+MinY/YVar)*YVar;
      #declare ZPoint = ZPoint + VineLength*sin(Rangle);
    
      SplineCount, <XPoint, YPoint, ZPoint>
    }
    
    //Draw vine along spline
    #declare VineCount = 0;
    #if (LeafFrequency > 0)
      #declare LeafFraction = 1/LeafFrequency;
    #else
      #declare LeafFraction = VineSegments + 1;
    #end
    #declare LeafToggle = LeafFraction;
    #declare VineIncr = 0.75/(VineLengthBasic + VineLengthVariation)*VineThickness;
    
    #while (VineCount < VineSegments + 1)
      sphere {VineSpline(VineCount), VineThickness texture{txtLeaf}}
      #if (VineCount >= LeafToggle) //add leaf?
        #declare xLeafRot = rand(LeafRotSeed)*360;
        #declare yLeafRot = rand(LeafRotSeed)*360;
        #declare zLeafRot = rand(LeafRotSeed)*360;
        #declare AddFlower = rand(FlowerSeed);
        #if (AddFlower <= FlowerProbability) //add flower?
          CreateFlower() //macro in flowers.pov
          object {MorningGlory scale FlowerScale rotate <(xLeafRot/2)-90, (yLeafRot/2)-90, (zLeafRot/2)-90> translate VineSpline(VineCount)}
        #else
          object {Leaf texture {txtLeaf} scale LeafScale rotate <xLeafRot, yLeafRot, zLeafRot> translate VineSpline(VineCount)}
        #end
        #declare LeafToggle = LeafToggle + LeafFraction;
      #end
      #declare VineCount = VineCount + VineIncr;
    #end
    
  #end  //end if

#end //end macro