#version unofficial megapov 1.21;

global_settings {
    radiosity {
      pretrace_start 0.1
      pretrace_end   0.1 //0.1
      count 150 //150
      always_sample off
           
      nearest_count 5
      error_bound .35 //.15 for pretrace, .35 for render
      recursion_limit 1

      low_error_factor .1
      gray_threshold 0.8
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2
      
      normal on
      adaptive 1
      
      load_file "music_rad.rad"
      
      }
    
      adc_bailout 0.02
      max_trace_level 8
      ambient_light 0
      
  }

#include "tex.inc"
#include "window_macro.inc"

////////////////////////////////////Lights//////////////////////////////////

#declare simple_lights = 0;

#if ( simple_lights = 1)

light_source{ //sunlight
  12*<-25,70,80> 
  color rgb 1.8 
  //area_light <20,0,0> <0,20,0> 8, 8 orient jitter adaptive 1
  }

light_source{ 12*<-13,7,-7> color rgb .6 }
light_source{ 12*<-19,7,-7> color rgb .6 }

#else

light_source{ //sunlight
  12*<-15,70,80>
  color rgb 3.1*<255/255,237/255,207/255>
  cylinder
  point_at <-150,40,0>
  radius 90
  falloff 120 
  area_light <20,0,0> <0,20,0> 3, 3 circular orient jitter adaptive 1 //3x3
  max_trace_level 3
  }
  
light_source{ //kitchen window
  <-170,60,-9>
  color rgb 1.2*<255/255,237/255,207/255>
  area_light <36,0,0> <0,36,0>, 6, 6 circular orient jitter adaptive 1 //6x6
  media_interaction off
  max_trace_level 2
  }

light_source{ //doorwall
  <-65,39.5,20>
  color rgb .25*<255/255,237/255,207/255>
  area_light <60,0,0> <0,60,0>, 6, 6 circular orient jitter adaptive 1 //6x6
  media_interaction off
  max_trace_level 2
  }        
  
light_source{ 
  <-65,70,-20> 
  color rgb .05*<255/255,237/255,207/255> 
  area_light <0,20,0> <0,0,20>, 3, 3 circular orient jitter adaptive 1 //3x3
  media_interaction off
  max_trace_level 2 
  }
  
#end

////////////////////////////////////Camera///////////////////////////////////

camera{            
  right 1.66*x
  up y

  //playing around camera
  //location <-110,80,-90>
  //look_at <-200,50,-50>
  //angle 65
  
  //"official" camera
  location <-220,10,-100>
  look_at <-20,30,24>
  angle 65
  
  focal_point <-185,1,-83>
  aperture .6
  blur_samples 50 //60

  }

////////////////////////////////////Objects///////////////////////////////////
  
sky_sphere{
   pigment{
     gradient y
     color_map{
       [0.0 color rgb 1 ]
       [0.5 color rgb 1 ]
       [1.0 color rgb <.1,.45,1> ]
       }
     scale 2
     translate -1
     }
}


#declare flowers = 1;
#include "house.inc"

object{ dust }



object{ walls }
object{ baseboard_molding }
object{ tile_floor }
object{ ceiling texture{ ceiling_tex }}
object{ cabinets }
object{ fridge }
object{ stove }
object{ picture }
object{ countertop }
object{ table translate 12*<-5,0,-6> }
object{ chairs translate 12*<-5,0,-6> }
object{ kitchen_lamp no_shadow}
object{ doorwall }
object{ kitchen_window photons{ pass_through } }
object{ outlets }
object{ curtains }
object{ heat_vent }
object{ drums photons{ target reflection on refraction off } }     
object{ extra_drums }
object{ faucet }
object{ rand_plant }
object{ mixer }
object{ soap_bottle }
object{ ptowel_roll }
object{ soccer_ball }





   