// Copyright (C) 2006 by Christian Frschlin

#include "colors.inc"
#include "metals.inc"
#include "stones.inc"
#include "strings.inc"
#include "stars.inc"
#include "rand.inc"
#include "woods.inc"
#include "shapes.inc"

#include "tones.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 10
}


//I used this slighly odd scale factor to preserve the
//the absolute scale while fiddling with tones.inc, because
//I really did not want to describe the rest of the scene
//as a parameter of the bar lengths. 
#declare UNITSPERMETER = 0.8 * 5000 / 3800;

#declare SONICSPEEDCOPPER = 3800;

// Return length of oscillator in POVRAY units
#declare BLADE_LENGTH = function(tone, octave)
{
  0.5 * WAVE_LENGTH(tone, octave, SONICSPEEDCOPPER) * UNITSPERMETER
}


#declare relthickness = 0.82;
#declare absthickness = 0.1;
#declare mountradius = 0.1;
#declare mountspace = 0.7;


#macro blade(tone, octave)
  #local length = BLADE_LENGTH(tone, octave);
  union
  {
    difference
    {
      intersection
      {
        cylinder {0, length*z, 1}
        plane    {-y, -relthickness}
        translate -z*length/2    
        translate -y*relthickness
        scale <1, absthickness / (1-relthickness), 1>     
      }
      text {ttf "arial.ttf" TONENAME(tone) 0.04 0.0 rotate 90*x scale 0.8 translate <-0.25,absthickness,-0.25>}    
    }
    sphere {0, mountradius translate <0,(absthickness+mountradius),-length/2 + mountspace>}
    sphere {0, mountradius translate <0,(absthickness+mountradius), length/2 - mountspace>}
  }
#end

#macro woodblock(length, angle1, angle2)
  intersection
  {
    object{Round_Box_Union(<0,0,-50>, <1.2, 0.3, length+50>, 0.05) translate -0.6*x}
    plane {-z, 0 rotate angle1*y}
    plane { z, 0 rotate angle2*y translate length*z}
  }
  texture {T_Wood3 scale 2}
  rotate 90*y
#end



#declare GLOCKENSPIEL = union
{
  // Wooden frame
  difference
  {
    union
    {
      object {woodblock(12.5,11,11) rotate -11*y translate <-1.5,0,-2.8>}
      object {woodblock(12.5,-11,-11) rotate  11*y translate <-1.5,0, 2.8>}
      object {woodblock(4.2,11,-11) rotate  90*y translate <-0.925,0, 2.1>}
    }
    box {<0,0.29,-0.015>, <20,0.31,0.015>}
    cutaway_textures
  }
    
  // Metal bars 
  union
  {
    object {blade(TONED,3) translate 0.0*x}
    object {blade(TONEE,3) translate 1.5*x}
    object {blade(TONEG,3) translate 3.0*x}
    object {blade(TONEA,3) translate 4.5*x}
    object {blade(TONEB,3) translate 6.0*x}
    object {blade(TONED,4) translate 7.5*x}
    object {blade(TONEE,4) translate 9.0*x}
    texture {T_Copper_3A}
    translate 0.32*y
  }
  
}


// Mallet

#macro MALLET(transparency)
  union
  {
    cylinder {0, 6*z, 0.1}
    sphere {6*z, 0.4}
    texture
    {
      average
      texture_map
      {
        [transparency pigment {color rgbt 1}]
        [(1-transparency) T_Wood3 scale 2]
      }
    }
  }
#end

// Toy

#declare r1 = 2.9;
#declare r2 = 0.3;

#declare smalltorus = torus {1,0.25  rotate 90*z translate - (r1 + 1 - 0.25  -r2) * z texture {T_Wood7}}
#declare smalltorusnormal = normal {bozo 0.5 scale 0.06}

#declare TOY= union
{ 
  union
  {
    torus {r1, r2}
    sphere {(r1+r2) * <sin(0.5),0,cos(0.5)>, r2/2}
    sphere {(r1+r2) * <sin(-0.5),0,cos(-0.5)>, r2/2}
    texture {T_Wood7 rotate y*30 rotate 3*x}
  }
  
  union
  {
    sphere {<0,0,r1>, 1.2 texture {T_Wood7} pigment {color rgbt <1,0,0,0.1>} normal {smalltorusnormal}}
    object {smalltorus pigment {color rgbt <1,0,0,0.1>} normal {smalltorusnormal} rotate 18 * y}
    object {smalltorus pigment {color rgbt <0,0,1,0.1>} normal {smalltorusnormal} rotate  6 * y}
    object {smalltorus pigment {color rgbt <1,1,0,0.1>} normal {smalltorusnormal} rotate -6 * y}
    object {smalltorus pigment {color rgbt <0,1,0,0.1>} normal {smalltorusnormal} rotate -18 * y}    
  }
}

// Chain parts

#declare link = union
{
  difference
  {
    union
    {
      torus {0.8,0.2}
      torus {0.8,0.2 translate z}
    }
    box {<-10,-10,0>, <10,10,1>}
  }
  cylinder {-0.8*x,-0.8*x+z,0.2}  
  cylinder { 0.8*x, 0.8*x+z,0.2}
  scale 0.5  
}

#declare linkpair = union
{
  object {link}
  object {link rotate 20*z translate z}
}


// -------------------- Actual Scene --------------------------------------------

camera {
  location  <-0.1, 4.5,-3.2>
  look_at   <-0.3, 0.5,-0.2>
  angle 80
}


light_source {<-20,  70, 30> color White area_light 3*x, 3*z, 4,4 }
//light_source {<-20,  70, 30> color White}

#declare woodpolish = 
  texture {T_Wood14 scale 0.3}
  texture
  {
    pigment {color rgbt 1}
    finish {reflection 0.05 irid {0.1 thickness 0.01}}
  }

// Floor
plane 
{
  y, 0 
  texture 
  {
    checker
    texture {woodpolish scale 0.3 rotate 90*y}
    texture {woodpolish scale 0.3}
    scale 5
  }
}

// Dummy walls and ceiling, just for metal reflections
difference
{
  box {0,   1}
  box {0.1, 0.9}
  hollow
  translate -0.5
  scale 300
  pigment {color White}
}

//Glockenspiel
object
{
  GLOCKENSPIEL
  translate <-4.5,0,0>
}

//Mallet
object
{
  // Simulate some kind of motion blur
  union
  {
    merge
    {
      #declare a = 5;
      #while (a < 10)    
        object {MALLET(1.0 - (a-4)/12) no_shadow rotate a * x}
        #declare a = a + 0.5;
      #end
    }
    object {MALLET(0.0) rotate 10 * x}
  }
  rotate -35*z
  translate <0,2,-6>
  rotate -40*y  
  translate <-0.9,0,-0.3>
}

//Toy
object 
{
  TOY
  scale 0.6
  rotate -90*y
  rotate -25*x
  rotate 2*z
  rotate 10*y
  translate <3,0.9,4>
}

//Chain
union
{
  //Visible Chain Segment 1
  union
  {
    object{linkpair translate -4*z}
    object{linkpair translate -2*z}
    object{linkpair}
    union
    {
      object{linkpair}
      object{linkpair translate 2*z}
      rotate -30*y translate 2*z
    }
    
    //Label tag
    union
    {
      difference      
      {
        box
        {
          0, 1
          pigment {image_map{sys "toddlermean.bmp"} rotate 90*x }
          scale <2.5,0.001,1.5>
          normal {crackle 0.5 scale 0.5}
        }
        sphere {<0.25, 0, 0.75>, 0.15}
      }
      torus 
      {
        0.5, 0.02
        rotate 80*x
        scale <1,0.3,1>
        rotate -10*z
        translate <-0.25, 0.09, 0.75>
        pigment {color rgbt <1,1,1,0.7>}
        interior {ior 1.4}
      }
      rotate -2*z
      rotate -35*y
      translate <0.7,0,3>      
    }        
    
    rotate 50*y
    translate <-6,0.1,4>
  }
  //Visible Chain Segment 2
  union
  {
    object{linkpair}
    object{linkpair rotate -25*y translate 2*z}
    rotate -88*y
    translate <3.0,0.1,-2.9>
  }
  texture {T_Chrome_3C}
}