// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.6;

#include "colors.inc"
#include "golds.inc"
#include "metals.inc"

#declare R = seed(0);

#declare T_venyl=texture{
    pigment {color rgb <0.001,0.001,0.003>}
    finish{phong 0.9 roughness 0.3}
}; 

#declare T_NadelPlastik_1=texture{
    pigment {color rgb <0.5,0,0>}
    finish{phong 0.4 roughness 0.7}
}; 

#declare T_NadelPlastik_2=texture{
    pigment {color rgb <0.5,0.3,0>}
    finish{phong 0.4 roughness 0.7}
};

#declare T_dark_plasik=texture{
    pigment {color rgb 0.01}
    finish{phong 0.4 reflection 0.1}
}; 

#declare T_dark_plasik_2=texture{
    pigment {color rgb 0.01}
    finish{phong 0.2 phong_size 0.6 reflection 0.05 roughness 0.5}
};            

#declare T_Metall_1 =texture{ T_Silver_5E};   
 
#declare T_dark_Metall= texture{
    pigment {color rgb 0.01}
    finish{phong 0.3 phong_size 1.6 reflection 0.25 roughness 0.1}
};            


global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <-8,17, -35.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.1,0,  0>
  angle 20

}


sphere {0,1000 
        pigment {
                image_map {
                        jpeg "IMG.jpg"  
                        map_type 1 
                        interpolate 2       
                         
                        }
                }
        inverse
        }
        
        
                  


light_source {
  <40, 80, -60>                // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <15, 0, 0> <0, 0, 15> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
 
}

#declare Schalter1=union {
intersection {
  box{<-4,0,-2>,<4,0.2,2>}
  box{<-4,0,-2>,<4,0.21,2> rotate <0,60,0>}
  box{<-4,0,-2>,<4,0.21,2> rotate <0,120,0>}
}
torus{1.7,0.2 translate<0,0.2,0>}
cylinder {<0,0.1,0>,<0,0.4,0>1.7}
difference{
  cone {<0,0.3,0>,1.6,<0,0.9,0>,1.2}
  cone {<0,0.3,0>,0.6,<0,0.91,0>,1}
}
union {
  cone {<0,0,0>,0.3,<0,3,0>,0.5}
  sphere {<0,3,0>,0.5}  
  sphere{<0,-0.3,0>0.8}
  rotate<25,0,0>  
  rotate <0,180,0>*floor(rand(R)*10)
}
texture{T_Metall_1} 
}


       
#declare Schalter2=union {              
union {              
  cone{<0,0,0>,1.7,<0,1,0>,1 }
  cylinder{<0,1,0><0,1.8,0>1}    
  #declare Count = 0;
  #while (Count < 10)
    cylinder{<1,0.7,0><1,1.5,0>0.1 rotate <0,360,0>*Count/10}
    sphere {<1,1.5,0>0.1  rotate <0,360,0>*Count/10}  
  #declare Count = Count+1;   
  #end
  texture {T_dark_plasik}
}
difference{
  union {
    cylinder{ <0,1.9,0><0,1.8,0>0.9 }
    torus{0.9,0.1 translate<0,1.8,0>}
    torus{1.7,0.02 translate<0,0,0>}
    texture{T_Silver_2B} 
  }
  union {
    cylinder{<0,1.9,0.4><0,1.9,1>0.1}
    sphere {<0,1.9,0.4>0.1}  
    texture {T_dark_plasik}
  }
}
rotate <0,60,0>*rand(R)
}           

     

#declare display2= union {
 union {
  torus{1,0.05}                    
  torus{0.1,0.05 translate <1,0,0>}
  cylinder {<1,-0.05,0><1,0.05,0>0.1}  
  torus{0.1,0.05 translate <-1,0,0>}  
  cylinder {<-1,-0.05,0><-1,0.05,0>0.1}
  intersection {
   union {
    torus{0.2,0.05 }
    cylinder {<0,-0.05,0><0,0.05,0>0.2}
    translate <0,0,-1>
    }
   cylinder {<0,-1,0><0,1,0>1}
   }
 rotate <-90,0,0>
 texture {T_dark_plasik}
 } 
 difference {
  union {
   torus{0.9,0.05 rotate <90,0,0> translate <0,0,-0.05>}
   cylinder {<0,0,0><0,0,-0.1>0.9}
   cylinder {<0,0,0><0,0,-0.05>0.95}
  }
  cylinder {<0,0,1><0,0,-0.05>0.85}
 
 texture {
  pigment {color rgbf 0.95}
  finish {phong 0.5}
  }                 
  interior {ior 2}
 }
 
 cylinder {<0.5,0.5,-0.01><0.5,0.5,0.01>0.5
  pigment  {image_map {jpeg "disp.jpg"}} 
  translate <-0.5,-0.5,-0.01>
  scale 1.9 
 }
 
}        

#declare display1=union {
 box {0,1
  pigment {
  image_map {jpeg "disp.jpg"} 
 
  }
 scale <2,1,0.05>
 translate <0,0,-0.05>
 }
 difference {
  box{<0,0,0><2,1,-0.5>}
  box{<0.1,0.1,0.1><1.9,0.9,-0.4>}
  texture {
   pigment {color rgbf <0.9,0.9,0.8,0.9>}
   finish {reflection 0.05 phong 0.5} 
  } 
  interior{ior 0.7}
 } 
 intersection {
  sphere {0,1}
  box{<-1,0,-1><1,1,0>}
  scale <0.3,0.2,0.1>
  texture{T_Metall_1}
  translate <1,0.1,-0.2>
 }
 cylinder {<0,0,0><0,1,0>,0.05 
  pigment {color rgb <1,0,0>} 
  scale 0.5
  rotate <0,0,1>*35
  translate <1,0.15,-0.15>
 }
}     

#declare button1 = union{
 
 difference {
  union {
   cylinder {<0,0,0,><0,0,-0.2>0.4}             
   cylinder {<0,0,0,><0,0,-0.1>0.5}
   torus {0.5,0.1 rotate <90,0,0> translate <0,0,-0.1>}
   cylinder {<0,0,0,><0,0,-0.1>0.6}
  }
  sphere {<0,0,-0.2>,0.05}
  texture {T_Metall_1}
 }
 scale 0.5
}         
 
 
#declare Brand = union{
 
text {
  ttf             
  "RAGE.TTF",  
  "Julius G.06",     
  2,              // the extrusion depth
  0               // inter-character spacing

 texture{T_Gold_2B}
 translate <0,0,-0.05>
}


}
 
#declare sockel = union{
union {
 box {<0,0,1><5,1,-1>}
 cylinder{ <0,0.9,1><5,0.9,1>0.1}
 cylinder{ <0,0.9,-1><5,0.9,-1>0.1}
 box {<0,0,1.1><5,0.9,-1.1>} 
                             
 cylinder {<0,0,0><0,0.9,0>1.1}
 cylinder {<0,0,0><0,1,0>1}
 torus{1,0.1 translate<0,0.9,0>}
 
 difference{
  union{ 
   cone {<0,1,0>0.6<0,1.1,0>0.5} 
   difference{
     torus{0.475,0.025 translate<0,1.1,0>}
     plane{y,0.9}
   } 
   cylinder {<0,0.8,0><0,1.125,0>0.475}
  }
  cylinder{<0,0.8,0><0,1.3,0>0.2}
 } 
 texture{T_dark_plasik_2} 
 }

union {
 difference {
  cylinder{<0,0.8,0><0,1.095,0>0.2}
  intersection {
   box{<-4,1,-0.05>,<4,2,0.05>}
   box{<-4,1,-0.05>,<4,2.1,0.05> rotate <0,60,0>}
   box{<-4,1,-0.05>,<4,2.1,0.05> rotate <0,120,0>}
  }   
 }
 texture{T_Silver_2B}  
}    
translate <-4,0,0>
}


union {
//Fuss
                
object {sockel rotate <0,30,0>}
object {sockel rotate <0,-90,0>}
object {sockel translate <-0.5,0,0> rotate <0,150,0>}
 
union {             
cone {<0,1,0>1,<0,1.4,0>0.7}
cylinder {<0,1,0>,<0,2,0>0.8}
cylinder {<0,1,0>,<0,2.02,0>0.78}
torus {0.79,0.01 translate <0,2.01,0>} 
texture{T_dark_plasik_2} 
translate <-4.5,0,0> rotate <0,150,0>
}         

      

#declare Schraube=union {
 cylinder {<0,-0.05,0><0,0.155,0>0.015}
 cylinder {<0,0,0><0,-0.03,0>0.04}
 
 difference {
  sphere {<0,0,0>0.045 scale<1,0.5,1> translate <0,0.155,0> }
  plane {-y,-0.155}
  box{ <0.01,0.156,1><-0.01,1,-1> rotate<0,180,0>*rand(R)} 
 }
texture{T_Metall_1}
} 

#declare Nadel =  union {
   union {
    box{<-0.05,0,0.2><0.05,-0.1,-0.15>}
    box{<-0.15,0.1,-0.2><0.15,0,0.2>  } 
 
    texture {T_NadelPlastik_1}   
   }
   object {Schraube translate <0.1,0,0.08>}
   object {Schraube translate <-0.1,0,0.08>}
   object {Schraube translate <0.1,0,-0.08>}
   object {Schraube translate <-0.1,0,-0.08>}
  
   difference {
    box{<-0.2,-0.1,0.1><0.2,-0.3,-0.4>}
    plane {y,-0.3 rotate <20,0,0> }
    plane {-y,0 translate <0,-0.2,0> rotate <-20,0,0> }
    plane {x,0 translate <-0.1,0,0> rotate <0,-20,0>}
    plane {-x,0 translate <0.1,0,0> rotate <0,20,0>}
    plane {z,-0.3}
   texture {T_NadelPlastik_2}
   translate <0,0.15,-0.22>
   }
    cylinder {<0,-0.15,-0.3> <0,-0.2,-0.4>0.005 pigment  {color rgb 0.01}}
  }

               
//Arm
               
union{               
union {
 box {<0,0,1><3,1,-1>}
 cylinder{ <0,0.9,1><3,0.9,1>0.1}
 cylinder{ <0,0.9,-1><3,0.9,-1>0.1}
 box {<0,0,1.1><3,0.9,-1.1>}                              
 cylinder {<0,0,0><0,0.9,0>1.1}
 cylinder {<0,0,0><0,1,0>1}
 torus{1,0.1 translate<0,0.9,0>}
 cylinder {<3,0,0><3,0.9,0>1.1}
 cylinder {<3,0,0><3,1,0>1}
 torus{1,0.1 translate<3,0.9,0>}
 texture{T_dark_plasik_2}
}

object {Schalter1 scale 0.075 translate <1,1,0.7>}
object {Schalter1 scale 0.075 translate <1.5,1,0.7>}
object {Schalter2 scale 0.15 translate <2,1,0.7>}

union {
 difference {
  torus{0.7,0.1}
  plane {x,0}
  }
 sphere {<0,0,0.7>0.1}
 sphere {<0,0,-0.7>0.1}
 cylinder {<0,0,0.7><0,-1,0.7>0.1}
 cylinder {<0,0,-0.7><0,-1,-0.7>0.1}
 translate <0,1.5,0>
 rotate<0,45,0>
 texture{T_Metall_1}
}
union {

union {
cylinder {<0,0.5,0><0,1.5,0>0.1}
difference {
 union {
  box{ <0.3,1.5,0.2><-0.3,1.9,-0.2>}
  cylinder {<0.3,1.9,0><-0.3,1.9,0>0.2}
 }
 box{<0.2,1.6,1><-0.2,2.5,-1>}  
} 
cylinder {<0.28,1.9,0><-0.28,1.9,0>0.15 }
texture{T_dark_Metall}
}
cylinder {<0.32,1.9,0><-0.32,1.9,0>0.05 texture{T_Metall_1} } 

union{ 
 union {
  cylinder {<0,1.9,0.5><0,1.9,-4.95> 0.1}  
  sphere {<0,1.9,0.5> 0.1} 
  sphere {<0,1.9,-4.95> 0.1} 

  difference{  
   union {
   cylinder {<0,1.95,-5.2><0,1.85,-5.2>0.2}
   torus {0.2,0.05 translate <0,1.9,-5.2>}
   }   
   union {
    cylinder {<0.1,1,0.1><0.1,-0.05,0.1>0.05}
    cylinder {<0.1,1,0.1><0.1,-0.1,0.1>0.04}
     box{<0.15,1,0.1><0.05,-0.05,-0.1>}
     box{<0.14,1,0.1><0.06,-0.1,-0.1>}
    cylinder {<0.1,1,-0.1><0.1,-0.05,-0.1>0.05}
    cylinder {<0.1,1,-0.1><0.1,-0.1,-0.1>0.04}
    
    cylinder {<-0.1,1,-0.1><-0.1,-0.05,-0.1>0.05}
    cylinder {<-0.1,1,-0.1><-0.1,-0.1,-0.1>0.04}   
     box{<-0.15,1,0.1><-0.05,-0.05,-0.1>}
     box{<-0.14,1,0.1><-0.06,-0.1,-0.1>}
    cylinder {<-0.1,1,0.1><-0.1,-0.05,0.1>0.05}
    cylinder {<-0.1,1,0.1><-0.1,-0.1,0.1>0.04}
     
        
    rotate <0,15,0>
    translate  <0,1.95,-5.2>
   }
  }
  texture{T_dark_Metall}
 }      
 
 object {Nadel
  rotate <0,15,0>
  translate  <0,1.95,-5.2> 
  translate <0,-0.15,0>
 }    
 
 union {
  cylinder {<0,1.9,0.5><0,1.9,1.5>0.05}  
  sphere {<0,1.9,1.5> 0.05}
  cylinder {<0,1.9,1><0,1.9,1.3>0.5} 
  cone{<0,1.9,0.7>0.2<0,1.9,1>0.5}
  cone{<0,1.9,1.3>0.5<0,1.9,1.4>0.2}
  texture{T_Metall_1} 
 }
rotate <0,-15,0> 
}
translate<0,-0.1,0> 
rotate <0,-40,0> 
}
 
translate <-3,0,0>
rotate<0,0,0>     
translate <0,0,4>
rotate <0,180,0>
}  
 
  
 //Teller
cone {<0,1.1,0>3.2<0,1.3,0>3 texture{T_Silver_5C normal{spiral1 60 0.3} rotate <90,0,0>}}
cylinder{<0,1.3,0><0,1.4,0>2.9 texture{T_Silver_5A}}
union {
cylinder{<0,1.3,0><0,1.7,0>0.1 } 
sphere{<0,1.7,0>0.1}
texture{T_Silver_5A}
}    
difference{
 union { 
  cylinder {<0,1.45,0><0,1.5,0>2.8}
  torus {2.8,0.025 translate <0,1.475,0>}
 }
 cylinder {<0,-1,0><0,2,0>,0.11}
 torus {0.3,0.01 translate <0,1.5,0>}
 torus {0.33,0.01 translate <0,1.5,0>}
 torus {1.2,0.01 translate <0,1.5,0>}
 texture {T_venyl}
}                        
disc{<0,1.501,0>,y,2.7,1.25 
 
 texture{
 pigment {color rgb 0.01}
  normal {onion 0.2 scale 0.3 translate <0,1.4,0>}
  finish {reflection 0.2 phong 0.25 phong_size 2.5}
 }
}
disc{<0,1.501,0>,y,1,0.35 
 texture { 
  pigment{
   image_map {  jpeg "label.jpg"   map_type 0 } 
   rotate -<90,0,0> translate <-0.5,0,-0.5> scale 2
  }
 }
}

  
rotate <0,-90,0> 
}
    
    



/*
plane {   

y,00
  //y,-0.01
  pigment { color rgb 0.9}
}
   
union {   
difference{  
 box {<-20,0,8><20,2,10>}
 cylinder {<-20,2,8><20,2,8>2}
} 
box {<-20,0,10><20,4,20>}

pigment {color rgb 1} 
}    
 */
union { 
difference {
 union {
  box {<-5,0,-5>,<5,-10,8>}
  box {<-7,-2,-5>,<7,-10,8>}
  cylinder {<-5,-2,-5> <-5,-2,8> 2}
  cylinder {<5,-2,-5> <5,-2,8> 2}
  }

  box {<-5,-2.5,-6>,<5,-0.5,-4.5>}
  cylinder {<-5,-1.5,-6><-5,-1.5,-4.5>1}
  cylinder {<5,-1.5,-6><5,-1.5,-4.5>1}   
pigment {color rgb 1}
}

union {
cylinder {<-5,0,-4.5> <-5,0,7.5> 0.2}
cylinder {<5,0,-4.5> <5,0,7.5> 0.2}
sphere {<-5,0,-4.5>0.2}
sphere {<-5,0,7.5> 0.2}
sphere {<5,0,-4.5>0.2}
sphere {<5,0,7.5> 0.2}
texture {T_Metall_1}
}  

object {Schalter1 scale 0.075  rotate <-90,0,0> translate <0,-1.5,-4.5>}  
object {Schalter1 scale 0.075  rotate <-90,0,0> translate <-0.5,-1.5,-4.5>}
object {Schalter1 scale 0.075  rotate <0,180,0>  rotate <-90,0,0> translate <-1,-1.5,-4.5>}
object {Schalter2 scale 0.15  rotate <-90,0,0> translate <1,-1.3,-4.5>}
object {Schalter2 scale <0.1,0.15,0.1> rotate <0,-30,0> rotate <-90,0,0> translate <1.3,-1.9,-4.5>}
object {Schalter2 scale <0.1,0.15,0.1>  rotate <-90,0,0> translate <0.7,-1.9,-4.5>}
object {display2 scale 0.5 translate <-3.5,-1.5,-4.5> }
object {display2 scale 0.5 translate <-2,-1.5,-4.5> } 
object {button1 scale 1 translate <-5,-1.5,-4.5> } 

object {Brand scale <1,1,0.5> scale 0.6 translate <2,-2,-4.5> }

translate <0.75,0,-0.5>
}   




     


  
  


        