/*
   ----------------         Music - IRTC Competition            ------------------------ 
   ----------------               outpour.pov                   ------------------------
   ----------------              30.April 2006                  ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

// render with aspect ratio 16:9 (+w1024 +h576)

#version 3.5;

#declare substi    = 1;  // rendering without the files for the various meshes and image maps requires substi set to 1
 
#declare ground    = 1;
#declare grass     = 1;
#declare trees1    = 1;
#declare trees2    = 1;
#declare trees3    = 1;
#declare figures   = 1;
#declare flowers   = 1;

#declare Save_Rad  = 1;  // 1=save rad; 2=load rad data; 0=no rad storing
#declare RAD       = 1;  // radiosity quality settings 0=out; 1=test; 2=final; 4=partial render
                
global_settings {
        #declare a_g = 2.2;
        assumed_gamma a_g
        max_trace_level 128
        noise_generator 2  
        #if(RAD > 0)
                radiosity {
                        #if (Save_Rad != 2)
                                pretrace_start 0.08
                                pretrace_end   0.04/RAD
                                low_error_factor 0.5
                        #else
                                pretrace_start 1
                                pretrace_end   1    
                        #end
                        error_bound 2/RAD 
                        count 40*RAD                                   
                        recursion_limit 2
                        nearest_count RAD+1      
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1.9     
                        adc_bailout 2/255
                        normal on
                        media off
                        #if (Save_Rad = 1)
                                save_file "outpour.rad"
                        #else
                                #if (Save_Rad = 2)
                                        load_file "outpour.rad" 
                                        always_sample off
                                #end
                        #end                           
                }
        #end
}        

#if (RAD > 0)
        #default {finish {ambient 0}}
#end

#include "colors.inc"
#include "functions.inc"

//---------------------------------------
// Camera
//---------------------------------------

#declare cam_loc = <0,1.5,-8>;
#declare lookat = <1,0.5,0>;
#declare cam_ang = 67;

#declare cam_mirror = 1;                                                 // 1 for normal / -1 for mirror image
#declare cam_z = 0.5*image_width/image_height/tan(radians(cam_ang*0.5)); // amount of camera zoom
#declare cam_a = cam_mirror*image_width/image_height;                    // camera aspect ratio
#declare cam_s = y;                                                      // camera sky vector
#declare cam_d = vnormalize (lookat-cam_loc);                            // camera direction vector
#declare cam_r = vnormalize (vcross(cam_s,cam_d));                       // camera right vector
#declare cam_up = vnormalize (vcross(cam_d,cam_r));                      // camera up vector
#declare cam_dir = cam_d*cam_z;                                          // direction vector scaled
#declare cam_right = cam_r*cam_a;                                        // right vector scaled

camera {
        location cam_loc
        up cam_up
        right cam_right
        direction cam_dir 
}              

//---------------------------------------
// Sun
//---------------------------------------

#declare yLight = 60;
#declare xLight = -30;

#declare SunColor = rgb <255,187,117>/255;
light_source {
        z*-1500
        #if (substi != 1) 
                color SunColor*2.2*1.1
        #else
                color SunColor*1.5
        #end 
        rotate x*-xLight rotate y*yLight
        area_light <20,0,0> <0,20,0> 3,3 adaptive 0 jitter circular orient
}

//---------------------------------------
// Sky
//---------------------------------------

#if (substi != 1) 
        #declare sky_amb = 5;
#else
        #declare sky_amb = 2;
#end
        
#declare Pane = union {triangle {0,x,x+y} triangle {0,y,x+y}}
#declare Panoramic = 
union {
        object {Pane texture {pigment {image_map {jpeg "0001"}} finish {ambient sky_amb diffuse 0}}}
        object {Pane texture {pigment {image_map {jpeg "0002"}} finish {ambient sky_amb diffuse 0}} rotate y*90  translate x}
        object {Pane texture {pigment {image_map {jpeg "0003"}} finish {ambient sky_amb diffuse 0}} rotate y*180 translate x-z}
        object {Pane texture {pigment {image_map {jpeg "0004"}} finish {ambient sky_amb diffuse 0}} rotate y*270 translate -z}
        object {Pane texture {pigment {image_map {jpeg "0005"}} finish {ambient sky_amb diffuse 0}} rotate -x*90 translate y}
        translate z*0.5-x*0.5+y*-0.48
        rotate y*yLight
        scale <640/480,1,640/480>*7000
}

object {Panoramic} 
                           
//---------------------------------------
// Ground
//---------------------------------------

#declare ground_tex =
texture {
        pigment_pattern { 
                gradient x
                turbulence 0.00012
                omega 2
                color_map {
                        [0.010 rgb 0.0]
                        [0.013 rgb 1.0]
                        [0.018 rgb 1.0]
                        [0.022 rgb 0.6]
                        [0.027 rgb 1.0]                    
                        [0.030 rgb 1.0]
                        [0.037 rgb 0.0]
                        [0.062 rgb 0.0]
                        [0.063 rgb 0.8]                    
                        [0.070 rgb 0.8]
                        [0.071 rgb 0.0]                    
                }
        }            
        texture_map {
                [0.0    pigment {
                                granite 
                                color_map {
                                        [0 rgb <201,199*0.8,179*0.6>/255]
                                        [1 rgb <201,199,179>*0.4/255]
                                }
                        }  
                        finish {ambient 0 diffuse 0.75*0.85}
                        scale 2/500*0.3
                ]
                [0.75   pigment {
                                granite 
                                color_map {
                                        [0 rgb <201,199*0.8,179*0.6>/255]
                                        [1 rgb <201,199,179>*0.4/255]
                                }
                        }  
                        finish {ambient 0 diffuse 0.75*0.85}
                        scale 2/500*0.25
                ]
                [1.0    pigment {
                                granite 
                                color_map {
                                        [0.5 rgb <201,199*0.8,179*0.6>/255]
                                        [1 rgb <201,199,179>*0.4/255]
                                }
                        }  
                        finish {ambient 0 diffuse 0.75*0.85}
                        scale 2/500*1.2
                ]
        }
        rotate y*-20
        translate x*0.5
}

#declare fak = 0.038;
#declare fek = 200;
#declare P = function {pattern {bumps scale 0.1}}
#declare f_pigm2 = function {pigment {bumps}}
#declare Ground =
isosurface {
        function {
                y
                -P(x,0,z)
                -f_noise3d(x*250*fek,y*250*fek,z*250*fek)*fak*0.5
                -f_pigm2(x*75*fek,y*75*fek,z*75*fek).x*fak*1.5
                +f_pigm2(x*150*fek,y*150*fek,z*150*fek).z*fak*1.5                
        }
        contained_by {box {0,1}}
        texture {ground_tex}        
        translate <-0.5,0,0>
        scale <50,0.5,50>  
        translate -z*10
}        

#if (ground)
        object {Ground}
#end 

plane { 
        y,-0.0001 hollow
        texture {
                ground_tex
                translate <-0.5,0,0>
                scale <50,0.5,50>  
                translate z*-10                                  
        }
}                                                   

//---------------------------------------
// Grass
//--------------------------------------- 

#include "transforms.inc"
#debug "grass planting\n"

#declare cam_ang = 68.5;
#declare cam_mirror = 1;                                                 // 1 for normal / -1 for mirror image
#declare back_dist = 0.1;                                                // needed for planting from camera location
#declare cam_z = 0.5*16/9/tan(radians(cam_ang*0.5));                     // the amount of camera zoom
#declare cam_ang_up = degrees(2*atan2(0.5/cam_z,1));                     // camera angle in cam_up direction                                               
#declare cam_a = cam_mirror*16/9;                                        // camera aspect ratio
#declare cam_s = y;                                                      // camera sky vector
#declare cam_d = vnormalize (lookat-cam_loc);                            // camera direction vector
#declare cam_r = vnormalize (vcross(cam_s,cam_d));                       // camera right vector
#declare cam_up = vnormalize (vcross(cam_d,cam_r));                      // camera up vector
#declare cam_dir = cam_d*cam_z;                                          // direction vector scaled
#declare cam_right = cam_r*cam_a;                                        // right vector scaled

#declare fz = vlength(cam_dir);
#declare fx = vlength(cam_right)/2;
#declare fy = vlength(cam_up)/2; 

#macro OrientZ(p1,p2,cs)        
        #local nz = vnormalize(p2-p1);
        #local nx = vnormalize(vcross(cs,nz)); 
        #local ny = vcross(nz,nx);
        matrix <nx.x,nx.y,nx.z,ny.x,ny.y,ny.z,nz.x,nz.y,nz.z,p1.x,p1.y,p1.z>          
#end

#declare view_area =
box { 
        <0,0,0> <1,1,0.1>
        pigment {color rgb 1}
        translate <-0.5,-0.5,0>
        scale 2*<cam_mirror*fx,fy,0.5>
        translate fz*z
        scale back_dist
        OrientZ (cam_loc,lookat,cam_up) 
}

#if (grass)
#include "grass2_file_c.inc"

#declare trace_func = 
function {
        pigment {
                gradient x
                turbulence 0.00012
                omega 2
                color_map {
                        [0.0100 rgb 0.0]
                        [0.0150 rgb 1.0]
                        [0.0180 rgb 1.0]
                        [0.0225 rgb 0.6]
                        [0.0270 rgb 1.0]                    
                        [0.0300 rgb 1.0]
                        [0.0350 rgb 0.0]
                        [0.0620 rgb 0.0]
                        [0.0650 rgb 0.8]                    
                        [0.0680 rgb 0.8]
                        [0.0710 rgb 0.0]
                        [0.1380 rgb 0.0]
                        [0.1400 rgb 1.0]
                        [0.9200 rgb 1.0]
                        [0.9500 rgb 0.0]                    
                }
                rotate x*90
                rotate y*-20
                scale <50,0.5,50>  
                translate z*-10
        }
}

#declare R2 = seed(0);
#declare Pig0 = function {pigment {bumps color_map {[0 rgb 0][1 rgb 1]} translate 0.5 scale 3}}  
#declare Pig1 = function {pigment {bumps color_map {[0 rgb 0][1 rgb 1]} scale 3}}

#declare q = 0;
#declare p = 0;
        
#declare i = 1;
#declare rd = seed(6);
#declare rd1 = seed(0);
#declare rg = seed(0);
#while (i < 1800000)  
        #declare Norm = <0,0,0>;
        #declare Start = <25-50*rand(rd),20,rand(rd)*50-10>; 
        #declare Inter = trace (Ground,Start,-y,Norm);         
        #declare traced_color = trace_func(Inter.x,0,Inter.z);        
        #declare PMap = Pig0(Inter.x,0,Inter.z);
        #declare RMap = Pig1(Inter.x,0,Inter.z);
        #declare ad = (PMap.gray*40)+(rand(R2)*10-5);
        #declare ae = (RMap.gray*360)+(rand(R2)*20-10)+90;     
        #declare Norm1 = <0,0,0>;
        #declare Norm2 = <0,0,0>;
        #declare Inter2 = trace (view_area,Inter,cam_loc-Inter,Norm1);
        #declare Inter3 = trace (Ground,Inter,cam_loc-Inter,Norm2);
        #declare p = p+1;
        #if (((vlength(Norm1) > 0) & (vlength(Inter-cam_loc) > vlength(Inter-Inter2)) & (vlength(Norm2) = 0)) & ((vlength(Norm) > 0) & (traced_color.gray < 0.72)))
                object {grass[int(rand(rg)*3)] rotate y*360*rand(rd) rotate <ad,ae,0> scale (0.8+rand(rd)*1.2)*(1-traced_color.gray)*0.7 translate Inter}
                #declare q = q+1;
        #end
        #declare i = i+1;
        #if(mod(i,5000) = 0)
                #debug concat(str(i,0,0)," grass trials\n")
        #end        
#end
#debug concat(str(q,0,0)," grass objects planted.\n")
#debug concat(str(p,0,0)," grass objects looked to plant.\n")
#end  

//---------------------------------------
// Trees
//---------------------------------------

#debug "tree1 planting\n"
#include "tree1c.inc"

#declare tree_trans = 
transform {
        rotate y*-20  
        translate -z*10
}

#if (trees1)
#declare i=0;
#declare rd=seed(25);
#declare rt=seed(6);
#while (i < 45)   
        #declare ad = rand(rd)*16;
        #declare ae = rand(rd)*360;
        #declare tt = int(rand(rt)*3);
        #if (i = 5) 
                #declare tu = 3; 
        #else 
                #declare tu = tt; 
        #end                                  
        object {tree1[tu] rotate y*360*rand(rd) rotate <ad,ae,0> scale 0.75+rand(rd)*0.5 translate <(0.0475+0.0010+0.001*rand(rd))*50,0,rand(rd)*0.04-10+i*3> transform {tree_trans}}
        object {tree1[tt] rotate y*360*rand(rd) rotate <ad,ae,0> scale (0.25+rand(rd)*0.167)*(1.73-0.1) translate <(-0.0475+0.001*rand(rd))*50,0,rand(rd)*0.04-10+i*3> transform {tree_trans}}                                  
        #declare i=i+1;
#end
#end

#if (trees2)
#debug "tree2 planting\n"
#declare R2 = seed(1);
        
#declare i=1;
#declare rd=seed(1);
#declare rd1=seed(0);
#while (i < 7000)  
        #declare Norm = <0,0,0>;
        #declare Start = <200-300*rand(rd),0,rand(rd)*200+50>; 
        #declare ad = rand(R2)*12;
        #declare ae = rand(R2)*360;                                                           
        object {tree1[int(rand(rt)*3)] rotate y*360*rand(rd) rotate <ad,ae,0> scale 0.8+rand(rd)*1.2 translate Start}
        #declare i=i+1;
#end
#end

#if (trees3)
#debug "tree3 planting\n"
#include "shrub1_file.inc"
#include "tree3_file.inc"
#declare i=0;
#declare rd=seed(24);
#declare rt=seed(7);
#while (i < 90)   
        #declare ad = rand(rd)*16;
        #declare ae = rand(rd)*360;                                  
        object {shrub1 rotate y*360*rand(rd) rotate <ad,ae,0> scale (0.75+rand(rd)*0.5)*2 translate <(0.137+0.001*rand(rd))*50,0,rand(rd)*0.04-10+i*1.0> transform {tree_trans}}
        #declare ad = rand(rd)*16;
        #declare ae = rand(rd)*360;                                  
        object {shrub1 rotate y*360*rand(rd) rotate <ad,ae,0> scale 0.75+rand(rd)*0.5 translate <(-0.00+0.001*rand(rd))*50,0,rand(rd)*0.04-10+i*2.0> transform {tree_trans}}
        #declare ad = rand(rd)*6;
        #declare ae = rand(rd)*360;
        #declare tt = int(rand(rt)*3);
        object {tree3[tt] rotate y*360*rand(rd) rotate <ad,ae,0> scale 0.7+rand(rd)*0.5 translate <(0.23+0.001*rand(rd))*50,0,rand(rd)*0.04-10+i*1.5> transform {tree_trans}}                                  
        #declare ad = rand(rd)*6;
        #declare ae = rand(rd)*360;
        #declare tt = int(rand(rt)*3);
        object {tree3[tt] rotate y*360*rand(rd) rotate <ad,ae,0> scale 0.7+rand(rd)*0.5 translate <(0.33+0.001*rand(rd))*50,0,rand(rd)*0.04-10+i*1.5> transform {tree_trans}}                                  
        #declare ad = rand(rd)*16;
        #declare ae = rand(rd)*360;                                  
        object {shrub1 rotate y*360*rand(rd) rotate <ad,ae,0> scale (0.75+rand(rd)*0.5)*2 translate <(0.28+0.001*rand(rd))*50,0,rand(rd)*0.04-10+i*0.6> transform {tree_trans}}
        #declare i=i+1;
#end
object {shrub1 rotate y*90 rotate <0,0,0> scale 1.75 translate <-2.57159-0.25,0.35205,-1.71853>}
#end

//---------------------------------------
// Figures
//---------------------------------------

#if (figures)
#debug "figures\n"
#include "violin_file.inc"     
#include "widow7_file.inc"
#include "peacock_file.inc"
#end

//---------------------------------------
// Flowers
//---------------------------------------

#if (flowers)
#debug "flower planting\n"
#include "flower1_file.inc"
#include "veg_flower1.inc"
#include "veg_flower2.inc"

#include "flower3_file.inc"
#include "veg_flower3.inc" 

#include "flower4_file.inc"
#include "veg_flower4.inc" 

#include "flower5_file.inc"
#end