//_________________________________________________________________________________ 

//Bounding Box....... from x,y,z=(-8.52213,-11.01403,-2.911502)
//                      to x,y,z=(11.29606,9.094435,30.58234)
//Bounding Box size.... dx,dy,dz=(19.8182,20.10847,33.49384)
//Bounding box diagonal.......... 43.80581
//Bounding box center..... x,y,z=(1.386967,-0.9597979,13.83542)
//Memory allocated for geometry.. 20684944 Bytes
// 
//-------------------------------------------------

#declare tree1 = array[4];

#if (substi != 1) 
//Map definitions =================
#declare p_map1=pigment {image_map{tga "EU23brk" interpolate 2}} 
#declare p_map2=normal {bump_map{tga "EU23brk" bump_size -3 interpolate 2}}
#declare p_map3=pigment {image_map{tga "EU23brn" interpolate 2}} 
#declare p_map4=normal {bump_map{tga "EU23brn" bump_size -3 interpolate 2}}
#declare p_map5=pigment {image_map{tga "EU23lef4" interpolate 2}}                    
#declare p_map6=normal {bump_map{tga "EU23lef4" bump_size 2 interpolate 2}}

#declare p_map7=pigment {image_map{tga "EU23lef4_2" interpolate 2}}
 
//Material definitions =============================

#declare Trunk_col= 
texture{pigment{p_map1} 
        normal{p_map2} 
        finish{specular 0.8 roughness 0.005 ambient 0 diffuse 0.65}}

//================================================== 
#declare Branch_col= 
texture{pigment{p_map3} 
        normal{p_map4} 
        finish{specular 0.8 roughness 0.005 ambient 0 diffuse 0.65}}
//================================================== 
#declare Leaf_col1=
texture{pigment{p_map5} 
        normal{p_map6} 
        finish{specular 1.8 roughness 0.025 ambient 0 diffuse 0.9}}
#declare Leaf_col2b= 
texture{pigment {color rgbt 1}  
        finish{ambient 0}}
#declare Leaf_col= 
texture{image_pattern{png "EU23lef4_alpha.png"}
texture_map{[0.0 Leaf_col2b]
            [0.9 Leaf_col1]
           }}
//================================================== 
#declare Bark_col= 
texture{pigment{p_map1} 
        normal{p_map2} 
        finish{specular 0.64 roughness 0.005 ambient 0 diffuse 0.65}}
//================================================== 

#declare Trunk_col_trunk = 
texture{pigment{p_map1} 
        normal{p_map2} 
        finish{specular 0.64 roughness 0.005 ambient 0 diffuse 0.65}}
        
#declare Branch_col_b1_B = 
texture{pigment{p_map3} 
        normal{p_map4} 
        finish{specular 0.64 roughness 0.005 ambient 0 diffuse 0.9}}

#declare Leaf_col3=
texture{pigment{p_map7} 
        normal{p_map6} 
        finish{specular 1.8 roughness 0.025 ambient 0 diffuse 0.9}}
                
#declare Leaf_col2 = 
texture{image_pattern{png "EU23lef4_alpha.png"}
texture_map{[0.0 Leaf_col2b]
            [0.9 Leaf_col3]
           }}

//-------------------------------------------------

#include "EU23m_pov.inc"

#declare tree1[1] = object {EU23m double_illuminate hollow scale 0.51 rotate -x*90 translate 0.2*y}
//-------------------------------------------------

#include "EU23y_pov.inc"

#declare tree1[2] = object {EU23y double_illuminate hollow scale 0.68 rotate -x*90 translate 0.25*y}
//-------------------------------------------------
#end

#declare S = 
function {
	spline {
    	        natural_spline
    	       -0.25*0.3, <-1*-0.25,-2,0>
    	        0.00*0.3, <-1*0,     0,0>
    	        0.25*0.3, <-1*0.15,  2,0>
    	        0.50*0.3, <-1*0,     4,0>
    	        0.75*0.3, <-1*-0.2,  6,0>
    	        1.00*0.3, <-1*0,     8,0>
    	        1.00,     <-1*0,     8,0>
    	        1.25,     <-1*0.25, 10,0>    	        
        }
}

#macro Trunk3 (baseRadius,topRadius,heightY,S)

	#local Pa = 
	pigment {
	        image_map {tga "EU23brk" map_type 2 interpolate 2}
	}
	
	#local F = 
	function {
		pigment {Pa scale <0.65,0.13,0.65>}	
	}	
        
        #declare F_R = function {F(x,y,z).x}
	#declare F_G = function {F(x,y,z).y}
	#declare F_B = function {F(x,y,z).z}
	
	#declare FP = 
	pigment {
	        average
	        pigment_map {
	                [1      function {F_R(x-S(y).x,y,z-S(y).z)} color_map {[0 rgb 0][1 rgb 3*x]}]
	                [1      function {F_G(x-S(y).x,y,z-S(y).z)} color_map {[0 rgb 0][1 rgb 3*y]}]
	                [1      function {F_B(x-S(y).x,y,z-S(y).z)} color_map {[0 rgb 0][1 rgb 3*z]}]
	        }
	}        

	#local F1 = function {x*x+z*z-(baseRadius*baseRadius)+((baseRadius-topRadius)*y)+F(x,y,z).grey*0.002}
	
	isosurface {
		function {F1(x-S(y).x,y,z-S(y).z)}
		max_gradient 5
		contained_by {box {<-2,0,-2>,<2,1,2>}}
		pigment {FP}
		finish {specular 0.8 roughness 0.005 ambient 0 diffuse 0.65}
		scale <1,heightY,1> 
	}
#end

#if (substi != 1)
#declare Trunk_col= 
texture {
        pigment {color rgbt 1}  
        finish {ambient 0}
}
        
#include "EU23a_pov.inc"
#end

#declare tree1[3] = 
union {
        #if (substi != 1) object {EU23a double_illuminate hollow scale 0.3 rotate -x*90 translate 0.2*y} #end
        object {Trunk3 (0.11,0.09,8,S) double_illuminate hollow translate <-0.4,0,0>}
}

//==================================================
#if (substi != 1)
#declare Trunk_col= 
texture{pigment{p_map1} 
        normal{p_map2} 
        finish{specular 0.8 roughness 0.005 ambient 0 diffuse 0.65}}

#include "EU23a_pov.inc"

#declare tree1[0] = object {EU23a double_illuminate hollow scale 0.3 rotate -x*90 translate 0.2*y} 

#else
        #declare tree1[0] = object {cylinder {0,y*30.58234,0.4 scale 0.3 translate 0.2*y pigment {color rgb <139,125,126>/255*1.15} finish {specular 0.8 roughness 0.005 ambient 0 diffuse 0.65}}}
        #declare tree1[1] = object {cylinder {0,y*10.185,0.34 scale 0.51 translate 0.2*y pigment {color rgb <139,125,126>/255*1.15} finish {specular 0.8 roughness 0.005 ambient 0 diffuse 0.65}}}
        #declare tree1[2] = object {cylinder {0,y*6.453278,0.16 scale 0.68 translate 0.25*y pigment {color rgb <139,125,126>/255*1.15} finish {specular 0.8 roughness 0.005 ambient 0 diffuse 0.65}}}
#end