// Persistence of Vision Ray Tracer Scene Description File
// File: haze.pov
// Vers: 3.6
// Desc:
// Date:
// Auth: Iacopo Mochi

// Standard pre-defined colors
//
#include "colors.inc"


// several different gold colors, finishes and textures
#include "golds.inc"

// various metal colors, finishes and textures
// brass, copper, chrome, silver
#include "metals.inc"

// various (mostly layered) wood textures
// T_Wood1 - T_Wood35
#include "woods.inc"
// a lot of stone textures
// T_Stone1 - T_Stone44
#include "stones.inc"

global_settings {
   photons {
     count 10000
     media 100
   }
 }

camera {
  location <0, 10, 0>
  look_at <0.0, 0, 0>
  right x*image_width/image_height
  //aperture 1.0 // [0...N] larger is narrower depth of field (blurrier)
  //blur_samples 10 // number of rays per pixel for sampling
  //focal_point <0,0,0> // point that is in focus <X,Y,Z>
  //confidence 0.95 // [0...<1] when to move on while sampling (smaller is less accurate)
  //variance 1/200 // [0...1] how precise to calculate (smaller is more accurate)
}

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  0*x // light's position (translated below)
  color rgb 0.7 // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4 // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0 // 0,1,2,3...
  jitter // adds random softening of light
  circular // make the shape of the light circular
  orient // orient light
  media_interaction off
  translate <-25, 15, -25> // <x y z> position of light
}
/*
// create a regular point light source
light_source {
  0*x // light's position (translated below)
  color rgb <2,.5,.5> // light's color
  translate <-100, 80,100>
}
*/
 // radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08 // start pretrace at this size
    pretrace_end 0.04 // end pretrace at this size
    count 35 // higher -> higher quality (1..1600) [35]
    nearest_count 5 // higher -> higher quality (1..10) [5]
    error_bound 1.8 // higher -> smoother, less accurate [1.8]
    recursion_limit 3 // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5 // reduce error_bound during last pretrace step
    gray_threshold 0.0 // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015 // reuse of old radiosity samples [0.015]
    brightness 1 // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on // take surface normals into account [off]
    media off // take media into account [off]
    //save_file "file_name" // save radiosity data
    //load_file "file_name" // load saved radiosity data
    //always_sample off // turn sampling in final trace off [on]
    //max_sample 1.0 // maximum brightness of samples
  }
}


// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.6
// Desc:
// Date:
// Auth:

#include "colors.inc"

#include "stones.inc"

/*
light_source {
 0*x                 // light's position (translated below)
 color rgb 1.0       // light's color
 area_light
 <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
 4, 4                // total number of lights in grid (4x*4z = 16 lights)
 adaptive 0          // 0,1,2,3...
 jitter              // adds random softening of light
 circular            // make the shape of the light circular
 orient              // orient light
 translate <10, 16, 10>   // <x y z> position of light
}
*/              /*
light_source {
 0*x                 // light's position (translated below)
 color rgb 1.0       // light's color
 area_light
 <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
 4, 4                // total number of lights in grid (4x*4z = 16 lights)
 adaptive 0          // 0,1,2,3...
 jitter              // adds random softening of light
 circular            // make the shape of the light circular
 orient              // orient light
 translate <0, 60, 10>   // <x y z> position of light
}    */


/*
light_source {
 0*x                  // light's position (translated below)
 color rgb <.4,.4,.4>    // light's color
 translate <0, 14, 0>
 media_interaction off
} 
*/
light_source {
 0*x                  // light's position (translated below)
 color rgb <.4,.4,.4>    // light's color
 translate <50, 60, 50>
 media_interaction off
}
light_source {
 0*x                  // light's position (translated below)
 color rgb <.4,.4,.4>    // light's color
 translate <-50, 60, -50>
 media_interaction off
}


 #declare r=4/sin(pi/8);
 #declare j=15*pi/6;        #declare i=1+15*1/6;
// create a regular point light source
light_source {
 0*x                  // light's position (translated below)
 color rgb <1,1,1>    // light's color 
 spotlight
 //translate <r*i*cos(j),100-19,10+r*i*sin(j)>
 translate <0,68,0>
 point_at <0, 19, 0>      // direction of spotlight
  radius 1                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 10              // intensity falloff radius (outer, in degrees)
  media_interaction on            
    photons {
     refraction on
     reflection on
   }
        
}


#declare colonna=
cylinder{<0,0,0>,<0,15,0>,1
       texture{T_Stone24} }

#declare blocco=
union{
box{<-5,-5,-1>,<5,1,1>
       texture{T_Stone22}
   }
object{colonna         translate x*5}
       }
             #declare vasca=
union{
union{
     object{blocco
               translate <0,0,-5/tan(pi/8)>}       object{blocco
               rotate <0,-45,0>
               translate <5+5*cos(pi/4),0,-5*sin(pi/4)-5>}          }
union{
     object{blocco
               translate <0,0,-5/tan(pi/8)>}       object{blocco
               rotate <0,-45,0>
               translate <5+5*cos(pi/4),0,-5*sin(pi/4)-5>}          rotate <0,90,0>       
                         }
union{
     object{blocco
               translate <0,0,-5/tan(pi/8)>}       object{blocco
               rotate <0,-45,0>
               translate <5+5*cos(pi/4),0,-5*sin(pi/4)-5>}          rotate <0,180,0>     
                          }                                          union{
     object{blocco
               translate <0,0,-5/tan(pi/8)>}       object{blocco
               rotate <0,-45,0>
               translate <5+5*cos(pi/4),0,-5*sin(pi/4)-5>}          rotate <0,270,0>     
                          }                }

#declare acqua=  difference{
       cylinder{<0,-5,0>,<0,0.8,0>,5/sin(pi/8)}
       object{vasca scale 1.05}                   
               texture{
                        pigment{
                                color rgbt <1,1,1.8,1>    
                                }
                        normal { bumps 0.1 } 
                        finish{reflection 0.4}   
                        }        
                     hollow
                       interior{ 
                           media{ 
                                scattering { 2, rgb<.05,.05,.05> extinction 0.01 }
                                samples 30,100
                                     }
                     
                               ior 1.33}
                           
                        }
               #declare foro=
       cylinder{<0,100,0>,<0,19,0>,0.4}
#declare i=1;
#declare j=0;

#while (j<8*pi)
 #declare fori=
               union{
                       object{foro}
                       cylinder{<r*i*cos(j),100,r*i*sin(j)>,<0,19,0>,0.4}
                       }
 #declare foro=object{fori}                               
 #declare j=j+pi/6;       
#declare i=i+1/6;
#end                     
#declare nebbia=        
union{
       cylinder{<0,-25,0>,<0,50,0>,5/sin(pi/8)+1}
       //sphere{<0,19,0>,1+5/sin(pi/8)}
       pigment { rgbt 1 }
      hollow
  interior{ 
    media{ 
    scattering { 2, rgb<0.2,0.2,0.1> extinction 0.01 }
      samples 30,100
    }
  }
  }              
  
#declare roof=union{
difference{
       cylinder{<0,15,0>,<0,19,0>,5/sin(pi/8)+1}
       cylinder{<0,14,0>,<0,29,0>,5/sin(pi/8)-1}
       texture{T_Stone20}
        }
difference{                                        
                sphere{<0,19,0>,5/sin(pi/8)+1}         
                sphere{<0,19,0>,5/sin(pi/8)}                   
                object{foro}
   
                      plane{y,19}
       scale<1,1.5,1>
       translate -19/2*y              texture{T_Stone5}
}            }  


#declare archi=
       union{
             cylinder{<30,14,0>,<-30,14,0>,8}                                     
cylinder{<30,14,0>,<-30,14,0>,8
                       rotate<0,45,0>
                       }
             cylinder{<30,14,0>,<-30,14,0>,8
                       rotate<0,90,0>
                       }
             cylinder{<30,14,0>,<-30,14,0>,8
                       rotate<0,135,0>
                       }                                       }                         
                    // Ottima    
                    
camera {
 location  <25.0, 14.0, -30.0>
 look_at   <0.0, 16.0,  0.0>
 right     x*image_width/image_height
} 

/*
// alto
camera {
 location  <100, 65.0, 0.0>
 look_at   <0.0, 60.0,  0.0>
 
}
*/

object{vasca
       scale<2,1,2>}  
      
object{acqua
       scale<2,1,2>
       photons {
                target 
                refraction on
                reflection on
                collect on
                pass_through
                }}        
       
difference{        
        object{roof
        scale<2,1,2>}
        object{archi}
        }                      
     
object{nebbia
        scale<2,1,2>
        photons{collect off}}
     
difference{        
        box{<70,-20,70>,<-70,60,-70>
        texture{T_Stone3} 
                }
        box{<69,-19,69>,<-69,40,-69>
        texture{T_Stone3} 
                }
        cylinder{<0,0,0>,<0,200,0>,10}   
                   scale<2,1,2>
                                    
                }
intersection{                                    
box{<99,-19,99>,<-99,-18,-99>}
cylinder{<0,-20,0>,<0,-10,0>,90}   
        texture{pigment{color rgb<0.0,0.8,1>}}
        //translate -y*1
                }              

box{<-200,71,-200>,<200,72,200>
        pigment{color rgb <54,54,54>}
        }                
