global_settings {
   adc_bailout 0.0039216
   ambient_light rgb <1.5, 1.5, 1.5>
   max_trace_level 10
   noise_generator 2
}

media {
   density {
      planar
      turbulence <0.5, 0.5, 0.5>
      
      color_map {
         [ 0 color rgb <0.266667, 0.266667, 0.266667>      ]
         [ 0.05 color rgb <0.964706, 0.964706, 0.964706>   ]
         [ 0.1 color rgb <0.552941, 0.552941, 0.552941>    ]
         [ 0.15 color rgb <0.45098, 0.45098, 0.45098>      ]
         [ 0.2 color rgb <0.890196, 0.890196, 0.890196>    ]
         [ 0.25 color rgbt <0.25098, 0.25098, 0.25098, 1>  ]
         [ 1 color rgb <0.266667, 0.266667, 0.266667>      ]
      }
      scale <3, 4, 3>
   }
   intervals 20
   
   scattering {
      1, rgb <0.02, 0.02, 0.02>
   }
}

media {
   density {
      planar
      turbulence <0.4, 0.4, 0.4>
      octaves 7
      omega 0.7
      lambda 2.3
      
      color_map {
         [ 0 color rgb <0.266667, 0.266667, 0.266667>      ]
         [ 0.05 color rgb <0.964706, 0.964706, 0.964706>   ]
         [ 0.1 color rgb <0.552941, 0.552941, 0.552941>    ]
         [ 0.15 color rgb <0.45098, 0.45098, 0.45098>      ]
         [ 0.2 color rgb <0.890196, 0.890196, 0.890196>    ]
         [ 0.25 color rgbt <0.25098, 0.25098, 0.25098, 1>  ]
         [ 1 color rgb <0.266667, 0.266667, 0.266667>      ]
      }
      scale 4
      translate <4, 2, -2>
   }
   intervals 20
   
   scattering {
      1, rgb <0.02, 0.02, 0.02>
   }
}

//the light from the light bulb
light_source {
   <0, 2.3, 0>, rgb <0.7, 0.7, 0.7>
   fade_distance 3
   fade_power 1
   media_interaction off
   media_attenuation off
}

//Some fill lights
light_source {
   <-4.6, 9.6, -5>, rgb <0.14, 0.14, 0.14>
   fade_distance 1
   fade_power 1
   media_interaction off
}

light_source {
   <6.8, 8.5, -5>, rgb <0.14, 0.14, 0.14>
   fade_distance 1
   fade_power 1
   media_interaction off
}

/*Try these cameras too
camera {
   perspective
   location <-0.017427, 13.3501, -24.9646>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 3.3156, 0>
   angle 40
}

camera {
   perspective
   location <14.8519, 1.91806, 4.40296>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 2.98091, 1.05561>
   angle 50
}

camera {
   perspective
   location <-14.125, 10.822, -18.999>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 3.3156, 0>
   angle 55
}
*/
camera {
   perspective
   location <-13.773, 0.26594, -13.471>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <-3.6946, 6.65835, 0>
   angle 55
}

//The complete concert hall
union {
   box {
      <-15, -7.5, -20>, <15, 7.5, 20>    
      translate <0, 6, -5>
      hollow
}

   superellipsoid {
      <0.2, 0.1>    
      scale <16, 3, 0.3>
      translate <0, 12.1, 8.2>
   }
   texture {
   pigment {
      cells
      turbulence 1
      octaves 8
      omega 0.78
      lambda 2.5
      
      color_map {
         [ 0 color rgb <0, 0.380392, 0.631373>         ]
         [ 0.1 color rgb <0, 0.411765, 0.686275>       ]
         [ 0.5 color rgb <0, 0.380392, 0.635294>       ]
         [ 0.52 color rgb <0, 0.34902, 0.580392>       ]
         [ 0.6 color rgb <0, 0.388235, 0.647059>       ]
         [ 0.7 color rgb <0, 0.380392, 0.631373>       ]
         [ 0.8 color rgb <0.0235294, 0.352941, 0.615686> ]
         [ 1 color rgb <0, 0.380392, 0.631373>         ]
       }
     }      finish {
         ambient rgb <0.1, 0.1, 0.1>
      }
   }
 }

//Some used textures
#declare UCapa=
texture {
  pigment {color rgbt <0.42353,0.26275,0.05098,.2>
   }
  }

#declare TMaderaBarniz=
texture {
  pigment{
  gradient x
  color_map {
       [0  color rgb <1,0.94902,0.78039> ]
       [.5 color rgb <1,0.92549,0.85882> ]
       [.6 color rgb <1,0.90196,0.67059> ]
       [.6 color rgb <.8,0.64314,0.27451>]
       [1  color rgb <1,0.94902,0.78039> ]
     }
   }
}
texture {
  pigment{
  wood
  turbulence <0.01,0.01,0>
  color_map { 
       [0  color rgbt <1,0.91373,0.78431,.4>      ]
       [.2 color rgbt <0.96471,0.83922,0.60784,.4>]
       [.3 color rgbt <0.55882,0.47255,0.33922,.4>]
       [.4 color rgbt <0.33922,0.29216,0.22549,.4>]
       [.5 color rgbt <0.55882,0.47255,0.33922,.4>]
       [.6 color rgbt <0.96471,0.83922,0.60784,.4>]
       [.7 color rgbt <0.96471,0.83922,0.60784,.4>]
       [.8 color rgbt <0.96471,0.83922,0.60784,.4>]
       [1  color rgbt <1,0.91373,0.78431,.4>      ]
     }
  }
}

texture {
  pigment{
  wood
  turbulence x*1
  color_map { 
       [0  color rgbt <1,0.91373,0.78431,.7>      ]
       [.2 color rgbt <0.96471,0.83922,0.60784,.7>]
       [.3 color rgbt <0.55882,0.47255,0.33922,.7>]
       [.4 color rgbt <0.33922,0.29216,0.22549,.7>]
       [.5 color rgbt <0.55882,0.47255,0.33922,.7>]
       [.6 color rgbt <0.96471,0.83922,0.60784,.8>]
       [.7 color rgbt <1,1,1,1>]
       [.8 color rgbt <1,1,1,1>]
       [1  color rgbt <1,1,1,1>]
     }
  }
}

texture {
  pigment{
  bumps
  turbulence .2
  color_map {
       [0   color rgb <1,0.91373,0.78431> ]
       [.05   color rgb <1,0.91373,0.78431> ]
       [.08   color rgb <1,0.91373,0.78431> ]
       [.08 color rgb <0.96471,0.83922,0.60784>]
       [.1 color rgb <0.96471,0.83922,0.60784>]
       [.13 color rgb <0.96471,0.83922,0.60784>]
       [.16 color rgb <1,0.84706,0.48627> ]
       [.17  color rgb <1,0.84706,0.48627> ]
       [.19  color rgb <.6,0.50588,0.2902> ]
       [.2 color rgbt<1,1,1,1>     ]
       [1   color rgbt<1,1,1,1>     ]
   }
  }
 }
texture {
   UCapa
}


#declare MaderaT_0 = texture {
   pigment {
      bozo
      turbulence <0.04, 0.04, 0.04>
      scale <0.05, 0.05, 1>      
      color_map {
         [ 0 color rgb <0.37647, 0.24706, 0.12941>      ]
         [ 0.25 color rgb <0.37647, 0.24706, 0.12941>   ]
         [ 0.4 color rgb <0.40392, 0.30196, 0.18824>    ]
         [ 0.5 color rgb <0.37647, 0.24706, 0.12941>    ]
         [ 0.7 color rgb <1, 0.85098, 0.709804>         ]
         [ 0.98 color rgb <0.937255, 0.709804, 0.368627>]
         [ 1 color rgb <0.560784, 0.435294, 0.356863>   ]
      }
   }
}

texture {
   pigment {
      wood
      turbulence <0.01, 0.01, 0.01>      
      color_map {
         [ 0 color rgbt <0.32549, 0.18039, 0.14902, 0.1>    ]
         [ 0.3 color rgbt <0.44314, 0.23922, 0.18431, 0.1>  ]
         [ 0.7 color rgbt <0.47059, 0.27451, 0.19216, 0.1>  ]
         [ 1 color rgbt <0.32549, 0.18039, 0.14902, 0.1>    ]
      }
   }
}

texture {
   pigment {
      bozo
      turbulence <0.04, 0.04, 0.04>      
      color_map {
         [ 0 color rgbt <0.45098, 0.247059, 0.121569, 0.1>       ]
         [ 0.07 color rgbt <0.396078, 0.262745, 0.117647, 0.1>   ]
         [ 0.14 color rgbt <0.321569, 0.188235, 0.117647, 0.1>   ]
         [ 0.2 color rgbt <0.32549, 0.203922, 0.109804, 0.1>     ]
         [ 0.2 color rgbt <1, 1, 1, 1>         ]
         [ 0.98 color rgbt <1, 1, 1, 1>        ]
         [ 1 color rgbt <1, 1, 1, 1>           ]
      }
      frequency 1.5
   }
   scale <0.1, 0.1, 1>
   scale 3
}

texture {
   pigment {
      gradient <1, 1, 1>
      turbulence <0.5, 0.5, 0.5>
      omega 0.6      
      color_map {
         [ 0 color rgbt <0.69804, 0.50588, 0.38824, 0.7>       ]
         [ 0.5 color rgbt <0.69804, 0.50588, 0.38824, 0.7>     ]
         [ 0.53 color rgbt <0.32549, 0.18039, 0.14902, 0.5>    ]
         [ 0.54 color rgbt <0.32549, 0.18039, 0.14902, 0.5>    ]
         [ 0.54 color rgbt <1, 1, 1, 1>        ]
         [ 0.9 color rgbt <1, 1, 1, 1>         ]
         [ 1 color rgbt <0.69804, 0.50588, 0.38824, 0.7>       ]
      }
      scale 7
      translate x*3.3
   }
}

#declare MaderaTarima = texture {
   pigment {
      bozo
      turbulence <0.04, 0.04, 0.04>
      scale <0.05, 0.05, 1>      
      color_map {
         [ 0 color rgb <0.75294, 0.49412, 0.25882>       ]
         [ 0.25 color rgb <0.75294, 0.49412, 0.25882>    ]
         [ 0.4 color rgb <0.80784, 0.60392, 0.37648>     ]
         [ 0.5 color rgb <0.75294, 0.49412, 0.25882>     ]
         [ 0.7 color rgb <2, 1.70196, 1.41961>           ]
         [ 0.98 color rgb <1.87451, 1.41961, 0.737254>   ]
         [ 1 color rgb <1.12157, 0.870588, 0.713726>     ]
      }
   }
}

texture {
   pigment {
      wood
      turbulence <0.01, 0.01, 0.01>      
      color_map {
         [ 0 color rgbt <0.65098, 0.36078, 0.29804, 0.1>    ]
         [ 0.3 color rgbt <0.88628, 0.47844, 0.36862, 0.1>  ]
         [ 0.7 color rgbt <0.94118, 0.54902, 0.38432, 0.1>  ]
         [ 1 color rgbt <0.65098, 0.36078, 0.29804, 0.1>    ]
      }
   }
}

texture {
   pigment {
      bozo
      turbulence <0.04, 0.04, 0.04>      
      color_map {
         [ 0 color rgbt <0.90196, 0.49412, 0.24314, 0.1>        ]
         [ 0.07 color rgbt <0.34118, 0.18431, 0.086275, 0.6>    ]
         [ 0.14 color rgbt <0.64314, 0.37647, 0.23529, 0.1>     ]
         [ 0.2 color rgbt <0.65098, 0.40784, 0.21961, 0.1>      ]
         [ 0.2 color rgbt <1, 1, 1, 1>         ]
         [ 0.98 color rgbt <1, 1, 1, 1>        ]
         [ 1 color rgbt <1, 1, 1, 1>           ]
      }
      frequency 1.5
   }
   scale <0.1, 0.1, 1>
   scale 3
}

texture {
   pigment {
      color rgbt <1, 0.72549, 0.46667, 0.76>
   }
}

#declare TAluces = texture {
   pigment {
      color rgb <0.196078, 0.196078, 0.196078>
   }   
   finish {
      phong 1      
      reflection {
         rgb <0.105882, 0.105882, 0.105882>
      }
   }   
}

#declare Ma = texture {
   MaderaTarima
   scale <0.8, 0.4, 0.08>
}

#declare MaderaFinal = texture {
   cells
   scale <0.4, 2, 5>
   translate z*3   
   texture_map {
      [ 0 Ma
      rotate <5, -5, 0>
      translate x*(-20)
      ]
      [ 0.2 Ma
      rotate <5, -5, 0>
      translate x*(-20)
      ]
      [ 0.2 Ma
      rotate <5, 10, 0>
      ]
      [ 0.4 Ma
      rotate <5, 10, 0>
      ]
      [ 0.4 Ma
      rotate <5, -15, 0>
      translate <7, 0, 5>
      ]
      [ 0.6 Ma
      rotate <5, -15, 0>
      translate <7, 0, 5>
      ]
      [ 0.6 Ma
      rotate <5, 50, 3>
      ]
      [ 0.8 Ma
      rotate <5, 50, 3>
      ]
      [ 0.8 Ma
      rotate <5, 140, 4>
      ]
      [ 1 Ma
      rotate <5, 140, 4>
      ]
   }
}

#declare Ma2 = texture {
   MaderaT_0   
   finish {
      ambient rgb <0.23, 0.23, 0.23>
      diffuse 0.6
   }
   scale <0.8, 0.4, 0.08>
   rotate <0, 0, 0>
}

#declare MaderaFinal2 = texture {
   cells
   scale <0.4, 2, 5>
   rotate <0, 0, 0>
   translate z*3
   
   texture_map {
      [ 0 Ma2
      rotate <5, -5, 0>
      translate x*(-20)
      ]
      [ 0.2 Ma2
      rotate <5, -5, 0>
      translate x*(-20)
      ]
      [ 0.2 Ma2
      rotate <5, 10, 0>
      ]
      [ 0.4 Ma2
      rotate <5, 10, 0>
      ]
      [ 0.4 Ma2
      rotate <5, -15, 0>
      translate <7, 0, 5>
      ]
      [ 0.6 Ma2
      rotate <5, -15, 0>
      translate <7, 0, 5>
      ]
      [ 0.6 Ma2
      rotate <5, 50, 3>
      ]
      [ 0.8 Ma2
      rotate <5, 50, 3>
      ]
      [ 0.8 Ma2
      rotate <5, 140, 4>
      ]
      [ 1 Ma2
      rotate <5, 140, 4>
      ]
   }
}

box {
   <-15, -7.5, -20>, <15, 7.5, 20>
   
   texture {
      MaderaFinal2
   }
   scale 1
   rotate <0, 0, 0>
   translate <0, 20.9, -5>
}

box {
   <-15, -7.5, -20>, <15, 7.5, 20>
   
   pigment {
      brick
      color rgbt <0.25882, 0.12549, 0, 0.5>
      color rgbt <1, 1, 1, 1>
      brick_size <4, 0.4, 5>
      mortar 0.02
      rotate <90, 90, 0>
      translate z*(-0.01)
   }
   translate <0, 20.898, -5>
}

//The light bulb
#declare Aros = torus {
   0.1, 0.03
   scale <2, 0.8, 2>
   rotate <0, 0, 0>
   translate y*(-0.2)
}

#declare Bombillo = merge {
   merge {
      cylinder {
         <0, 0.3, 0>, <0, -0.3, 0>, 0.2
         translate y*(-0.2)
      }
      
      object {
         Aros
         translate y*(-0.03)
      }
      
      object {
         Aros
         translate y*(-0.13)
      }
      
      object {
         Aros
         translate y*(-0.23)
      }
      
      pigment {
         color rgb <0.360784, 0.360784, 0.360784>
      }
      
      finish {
         phong 1
         metallic 1
         
         reflection {
            rgb <0.223529, 0.223529, 0.223529>
         }
      }
   }
   
   sphere {
      <0, 0, 0>, 0.6
      translate y*0.8
   }
   
   sor {
      8,
      <0.00818669, -0.670495>, <0.0107993, -0.250451>, <0.227939, -0.170641>, <0.27083, 0.0753228>, <0.3119, 0.223283>, <0.478171, 0.420485>, <0.59721, 0.757435>, <0.545944, 1.34146>
   }
   
   pigment {
      color rgbt <1, 1, 1, 0.8>
   }
   
   interior {
      ior 0.98
   }
}

//Arms
#declare Mano = union {
   sphere_sweep {
      cubic_spline,
      5,
      <-2.05003e-14, -14.6832, -0.888125>,0.3
      <0, 1.90588, -1.82212>,0.35
      <0, -0.356911, -1.42224>,0.375
      <0, -0.206629, 1.7683>,0.4
      <1.63238e-14, 3.04671, 18.2999>,0.38393
   }
   
   torus {
      0.407664, 0.167924
      translate <0, 2.5854, -1.88775>
   }
   
   blob {
      threshold 0.5
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.3,
         strength 1
         translate <0, 0.0901785, -0.398385>
         rotate x*(-26.2)
      }
      
      sphere {
         <0, 0, 0>, 0.571592,
         strength 1
         translate <0, -0.507198, -0.0815573>
      }
      
      cylinder {
         <0, 0.68258, -0.010499>, <0, -0.5, 0>, 0.27,
         strength 1
      }
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.3,
         strength 0.8
         translate <0, 0.109993, 0.355082>
         rotate x*19.8
      }
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.25,
         strength 1
         rotate x*119.2
         translate <0, -0.489742, -0.443601>
      }
      
      cylinder {
         <0, 0.691151, -0.010687>, <0, -0.5, 0>, 0.35,
         strength 1
         rotate x*83.9
         translate <0, -0.447705, 0.246935>
      }
      scale 1
      rotate x*(-10.2)
      translate <0, 3.60099, -1.9108>
   }
}

#declare ManoD = union {
   sphere_sweep {
      cubic_spline,
      5,
      <-2.05003e-14, 6.3168, -1.96888>,0.3
      <-0.0541502, 2.44738, -1.82212>,0.35
      <-1.5, -0.356911, -1.38891>,0.375
      <0, -0.206629, 1.7683>,0.4
      <6.2663, 3.04671, 17.5457>,0.38393
   }
   
   torus {
      0.522534, 0.225359
      scale 1
      rotate <0, 0, 0>
      translate <0, 2.5854, -1.88775>
   }
   
   blob {
      threshold 0.5
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.3,
         strength 1
         translate <0, 0.0901785, -0.398385>
         rotate x*(-26.2)
      }
      
      sphere {
         <0, 0, 0>, 0.571592,
         strength 1
         translate <0, -0.507198, -0.0815573>
      }
      
      cylinder {
         <0, 0.68258, -0.010499>, <0, -0.5, 0>, 0.27,
         strength 1
      }
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.3,
         strength 0.8
         translate <0, 0.109993, 0.355082>
         rotate x*19.8
      }
      
      cylinder {
         <0, 0.5, 0>, <0, -0.5, 0>, 0.25,
         strength 1
         rotate x*119.2
         translate <0, -0.489742, -0.443601>
      }
      
      cylinder {
         <0, 0.691151, -0.010687>, <0, -0.5, 0>, 0.35,
         strength 1
         rotate x*83.9
         translate <0, -0.447705, 0.246935>
      }
      scale 1
      rotate x*(-10.2)
      translate <0, 3.60099, -1.9108>
   }
}

//Complete light bulb
#declare BomFinal = merge {
   difference {
      object {
         Bombillo         
         finish {
            ambient rgb <1, 1, 1>
            diffuse 0.5
            phong 1            
            reflection {
               rgb <0.141176, 0.141176, 0.141176>
            }
         }
      }
      
      object {
         Bombillo         
         finish {
            ambient rgb <0.745098, 0.745098, 0.745098>
            diffuse 0.5
            phong 1            
            reflection {
               rgb <0.141176, 0.141176, 0.141176>
            }
         }
         scale 0.9
         translate y*0.1
      }
   }
   
   object {
      Mano      
      pigment {
         color rgb <1, 1, 0.815686>
      }
      scale 0.15
      translate <0, 0.263902, -0.509704>
   }
   
   object {
      ManoD      
      pigment {
         color rgb <1, 1, 0.815686>
      }
      scale 0.15
      rotate <169, 44, -105.7>
      translate <0, 0.0290291, 0.489747>
   }
}

//Wooden platform
#declare Tarima = union {
   cylinder {
      <0, 0.5, 0>, <0, -0.5, 0>, 5
      scale <1, 1, 0.5>
   }
   
   box {
      <-5, -0.5, -5>, <5, 0.5, 5>
      translate z*5
   }
}

//Stage monitor
#declare Monitor = union {
   difference {
      difference {
         superellipsoid {
            <0.1, 0.1>
            scale <1, 1.3, 1>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         superellipsoid {
            <0.1, 0.1>
            
            pigment {
               color rgb <0.14902, 0.14902, 0.14902>
            }
            
            finish {
               phong 1
            }
            scale <0.8, 1.1, 0.8>
            rotate <0, 0, 0>
            translate z*(-1.5)
         }
         
         superellipsoid {
            //*PMName Agarradera
            <1, 0.2>
            scale 0.5
            rotate <0, 0, 0>
            translate <-1.2, 0.4, 0>
         }
         
         superellipsoid {
            //*PMName Agarradera
            <1, 0.2>
            scale 0.5
            rotate <0, 0, 0>
            translate <1.2, 0.4, 0>
         }
      }
      
      box {
         <-1, -1, -1>, <1, 1, 1>
         scale 2
         rotate x*33.9
         translate <0, -2.0721, 1.71484>
      }
   }
   
   difference {
      superellipsoid {
         <0.15, 0.15>
         scale 0.6
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      superellipsoid {
         //*PMName Agarradera
         <1, 0.2>
         scale 0.49
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-1, -1, -1>, <1, 1, 1>
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.82)
      }
      scale 0.8
      translate <-1.2, 0.4, 0>
   }
   
   difference {
      superellipsoid {
         <0.15, 0.15>
         scale 0.6
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      superellipsoid {
         //*PMName Agarradera
         <1, 0.2>
         scale 0.49
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-1, -1, -1>, <1, 1, 1>
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.82)
      }
      scale 0.8
      rotate z*180
      translate <1.2, 0.4, 0>
   }
   
   superellipsoid {
      <0.2, 0.2>
      scale <0.03, 0.1, 0.5>
      rotate <0, 0, 0>
      translate <-1.05, 0.4, 0>
   }
   
   superellipsoid {
      <0.2, 0.2>
      scale <0.03, 0.1, 0.5>
      rotate <0, 0, 0>
      translate <1.05, 0.4, 0>
   }
   
   pigment {
      color rgb <0.14902, 0.14902, 0.14902>
   }
   
   finish {
      phong 0.8
   }
   
   normal {
      bump_map {
         png
         "Colision.png"
         map_type 0
         bump_size 0.1
      }
   }
   rotate <-123.9, 0, -180>
   translate z*(-7)
}

//The lights begin here
#declare BomCil = cylinder {
   <0, 0.89, 0>, <0, -0.8, 0>, 0.37
}

#declare DifEsf = difference {
   sphere {
      <0, 0, 0>, 0.5
   }
   
   box {
      <-1, -1, -1>, <1, 1, 1>
      translate x*0.75
   }
}

#declare Soporte = union {
   cylinder {
      <0, 0.35, 0>, <0, -0.35, 0>, 0.2
      translate y*1.6
   }
   
   superellipsoid {
      <0.2, 0.2>
      scale <0.5, 0.2, 0.32>
      rotate y*90
      translate y*1.85
   }
   
   sphere {
      <0, 0, 0>, 0.4
      scale <1, 0.1, 1>
      translate y*1.39
   }
   
   difference {
      superellipsoid {
         <0.2, 0.2>
      }
      
      superellipsoid {
         <0.2, 0.2>
         scale <0.8, 0.8, 1.4>
      }
      
      box {
         <-1.4, -1, -1.4>, <1.4, 1, 1.4>
         translate y*(-1.5)
      }
      
      box {
         <-1.4, -1, -1.4>, <1.4, 1, 1.4>
         scale <1, 1.2, 1>
         translate z*(-1.6)
      }
      
      box {
         <-1.4, -1, -1.4>, <1.4, 1, 1.4>
         scale <1, 1.2, 1>
         translate z*1.6
      }
      scale <0.7, 1, 1>
      translate y*0.35
   }
   
   object {
      DifEsf
      scale 0.5
      translate x*(-0.58)
   }
   
   object {
      DifEsf
      scale 0.5
      rotate y*180
      translate x*0.58
   }
   
   cylinder {
      <0, 0.1, 0>, <0, -0.1, 0>, 0.1
      rotate z*90
      translate x*0.5
   }
   
   cylinder {
      <0, 0.1, 0>, <0, -0.1, 0>, 0.1
      rotate z*90
      translate x*(-0.5)
   }
   
   texture {
      TAluces
   }
}

#declare LuzCilAzul = union {
   difference {
      superellipsoid {
         <1, 0.5>
         scale <0.54, 0.54, 1>
         rotate x*90
      }
      
      cylinder {
         <0, 1.2, 0>, <0, -0.8, 0>, 0.26
      }
      
      texture {
         TAluces
      }
   }
   
   object {
      BomCil
      
      pigment {
         color rgb <0.709804, 0.847059, 1>
      }
      
      finish {
         ambient rgb <0.7, 1, 1.5>
         diffuse 0
      }
      scale <0.7, 1, 0.7>
      translate y*0.03
   }
   
   light_source {
      <0, 0.93, 0>, rgb <2, 4, 9>
      spotlight
      radius 9
      falloff 12
      point_at <0, 15, 0>
   }
   rotate x*180
}

#declare LuzCilRojo = union {
   difference {
      superellipsoid {
         <1, 0.5>
         scale <0.54, 0.54, 1>
         rotate x*90
      }
      
      cylinder {
         <0, 1.2, 0>, <0, -0.8, 0>, 0.26
      }
      
      texture {
         TAluces
      }
   }
   
   object {
      BomCil
      
      pigment {
         color rgb <1, 0.3, 0.3>
      }
      
      finish {
         ambient rgb <2, 1, 0.8>
         diffuse 0
      }
      scale <0.7, 1, 0.7>
      translate y*0.03
   }
   
   light_source {
      <0, 0.93, 0>, rgb <7, 2, 2>
      spotlight
      radius 9
      falloff 12
      point_at <0, 15, 0>
   }
   rotate x*180
}

//The poster
#declare Tablas = box {
   <-2, -3, -0.5>, <2, 3, 0.5>
   texture {TMaderaBarniz
     rotate x*95
   }
   scale <1, 1.1, 0.5>
}

#declare Cartel = union {
   object {
      Tablas
      rotate x*15
   }
   
   object {
      Tablas
      scale 1
      rotate x*(-15)
      translate z*2.19
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-3, -0.0774798, -2.91968>, <-1, -0.627773, -2.97688>, <1, 0.737854, -3.05119>, <3, -0.709516, -2.45221>,
      <-3, 0, -1>, <-1, -0.406126, -1.02708>, <1, 0, -1>, <3, 0, -1>,
      <-3, 0, 1>, <-1, -0.379051, 1.02708>, <1, -0.324901, 1>, <3, 0, 1>,
      <-3, 0, 3>, <-1, -0.135375, 3>, <1, 0, 3>, <3, -0.243676, 3>
      
      texture {
         pigment {
            uv_mapping            
            image_map {
               png
               "Cartel02.png"
               map_type 0
            }
            scale 1.2
            rotate x*180
            translate x*1.1
         }
      }
      
      finish {
         ambient rgb <0.16, 0.16, 0.16>
         diffuse 0.6
      }
      scale <0.6, 1, 1>
      rotate x*105
      translate z*(-0.3)
   }
}

//The theater curtain
#declare Cortina = union {
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-3, 0, -3>, <-0.87088, -2.61647, -3>, <0.18979, 1.6, -3>, <3, 0, -3>,
      <-3, 0, -1>, <-0.700837, -2.39329, -1>, <-0.426679, 1.78327, -1>, <3, 0, -1>,
      <-3, 0, 1>, <-0.431423, -2.1332, 1>, <-0.549537, 2.22273, 1>, <3, 0, 1>,
      <-3, 0, 3>, <-0.268973, -1.91456, 3>, <-0.616204, 2.8392, 3>, <3, 0, 3>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-3, 0, -3>, <-0.87088, -2.61647, -3>, <0.18979, 1.6, -3>, <3, 0, -3>,
      <-3, 0, -1>, <-0.700837, -2.39329, -1>, <-0.426679, 1.78327, -1>, <3, 0, -1>,
      <-3, 0, 1>, <-0.431423, -2.1332, 1>, <-0.549537, 2.22273, 1>, <3, 0, 1>,
      <-3, 0, 3>, <-0.268973, -1.91456, 3>, <-0.616204, 2.8392, 3>, <3, 0, 3>
      translate <5.98793, 0.00387671, 0>
   }
   
   bicubic_patch {
      type 0
      u_steps 3
      v_steps 3
      <-3, 0, -3>, <-0.87088, -2.61647, -3>, <0.18979, 1.6, -3>, <3, 0, -3>,
      <-3, 0, -1>, <-0.700837, -2.39329, -1>, <-0.426679, 1.78327, -1>, <3, 0, -1>,
      <-3, 0, 1>, <-0.431423, -2.1332, 1>, <-0.549537, 2.22273, 1>, <3, 0, 1>,
      <-3, 0, 3>, <-0.268973, -1.91456, 3>, <-0.616204, 2.8392, 3>, <3, 0, 3>
      translate <-5.99707, -0.00142399, 0>
   }
   
   pigment {
      color rgb <0.6, 0.129412, 0>
   }
}

//A screw
#declare Tornillo = sphere {
   <0, 0, 0>, 0.5
   scale <0.2, 1, 1>
}

//The metal structure
#declare Perlin = prism {
   linear_spline
   linear_sweep
   -10, 10,
   7,
   <1.5, 1>, <1.5, 0.5>, <0, 0.5>, <0, -1>, <-0.5, -1>, <-0.5, 1>, <1.5, 1>
   scale <0.7, 1, 0.7>
   translate <-0.5, 0, 0.15>
}

#declare Estructura = union {
   object {
      Tornillo
      translate <-5.87, -29, -5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, -29, 5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, -19, -5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, -19, 5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, -9, -5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, -9, 5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 1, -5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 1, 5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 11, -5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 11, 5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 21, -5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 21, 5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 31, 5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 31, -5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 41, 5.2>
   }
   
   object {
      Tornillo
      translate <-5.87, 41, -5.2>
   }
   
   union {
      object {
         Perlin
         scale <1, 0.7, 1>
         rotate x*45
         translate <-4, -24, 0>
      }
      
      object {
         Perlin
         scale <1, 0.7, 1>
         rotate x*45
         translate <-4, -14, 0>
      }
      
      object {
         Perlin
         scale <1, 0.7, 1>
         rotate x*45
         translate <-4, -4, 0>
      }
      
      object {
         Perlin
         scale <1, 0.7, 1>
         rotate x*45
         translate <-4, 6, 0>
      }
      
      object {
         Perlin
         scale <1, 0.7, 1>
         rotate x*45
         translate <-4, 16, 0>
      }
      
      object {
         Perlin
         scale <1, 0.7, 1>
         rotate x*45
         translate <-4, 26, 0>
      }
      
      object {
         Perlin
         scale <1, 0.7, 1>
         rotate x*45
         translate <-4, 36, 0>
      }
   }
   
   union {
      object {
         Perlin
         scale <1, 3.6, 1>
         rotate y*(-90)
         translate <-5, 6, -5>
      }
      
      object {
         Perlin
         scale <1, 3.6, 1>
         translate <-5, 6, 5>
      }
      
      object {
         Perlin
         scale <1, 0.55, 1>
         rotate x*90
         translate <-4.5, -19, 0>
      }
      
      object {
         Perlin
         scale <1, 0.55, 1>
         rotate x*90
         translate <-4.5, -9, 0>
      }
      
      object {
         Perlin
         scale <1, 0.55, 1>
         rotate x*90
         translate <-4.5, 1, 0>
      }
      
      object {
         Perlin
         scale <1, 0.55, 1>
         rotate x*90
         translate <-4.5, 11, 0>
      }
      
      object {
         Perlin
         scale <1, 0.55, 1>
         rotate x*90
         translate <-4.5, 21, 0>
      }
      
      object {
         Perlin
         scale <1, 0.55, 1>
         rotate x*90
         translate <-4.5, 31, 0>
      }
      
      object {
         Perlin
         scale <1, 0.55, 1>
         rotate x*90
         translate <-4.5, 41, 0>
      }
   }
}

#declare EstructuraCompleta = union {
   superellipsoid {
      <0.05, 0.02>
      scale <8, 8, 0.5>
      rotate x*90
      translate y*(-30)
   }
   
   object {
      //*PMName Tornillo
      Tornillo
      rotate z*90
      translate <6.5, -29.5, 6.5>
   }
   
   object {
      //*PMName Tornillo
      Tornillo
      rotate z*90
      translate <-6.5, -29.5, 6.5>
   }
   
   object {
      //*PMName Tornillo
      Tornillo
      rotate z*90
      translate <6.5, -29.5, -6.5>
   }
   
   object {
      //*PMName Tornillo
      Tornillo
      rotate z*90
      translate <-6.5, -29.5, -6.5>
   }
   
   object {
      Estructura
   }
   
   object {
      Estructura
      rotate y*180
   }
   
   object {
      Estructura
      rotate y*90
   }
   
   object {
      Estructura
      rotate y*(-90)
   }
}

//The complete structure
#declare EstTotal = union {
   object {
      EstructuraCompleta
      scale 0.15
      rotate z*90
      translate <6.1, 10.85, 2.28>
   }
   
   object {
      EstructuraCompleta
      scale 0.15
      rotate <180, 0, 90>
      translate <-6.1, 10.85, 2.28>
   }
   
   object {
      EstructuraCompleta
      scale 0.15
      translate <9.7, 5.5, 2.3>
   }
   
   object {
      EstructuraCompleta
      scale 0.15
      translate <-9.7, 5.5, 2.3>
   }
   
   difference {
      object {
         EstructuraCompleta
         scale <0.15, 0.18, 0.15>
         rotate <-90, 0, 90>
      }
      
      box {
         <-2, -2, -2>, <2, 2, 2>
         translate z*(-6)
      }
      translate <-5.22, 10.85, 5.66>
   }
   
   difference {
      object {
         EstructuraCompleta
         scale <0.15, 0.18, 0.15>
         rotate <-90, 0, 90>
      }
      
      box {
         <-2, -2, -2>, <2, 2, 2>
         translate z*(-6)
      }
      translate <5.22, 10.85, 5.66>
   }
}

//Stands and microphones
#declare Tubo = cylinder {
   <0, 5, 0>, <0, -5, 0>, 0.2
   translate y*5
}

#declare Mic = union {
   cone {
      <0, 4, 0>, 1,
      <0, -3.3, 0>, 0.7
      
      pigment {
         color rgb <0.0941176, 0.0941176, 0.0941176>
      }
      
      finish {
         phong 1
         
         reflection {
            rgb <0.101961, 0.101961, 0.101961>
            metallic 1
         }
      }
   }
   
   sphere {
      <0, 0, 0>, 1.7
      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01
         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      
      normal {
         quilted
         1
         control0 -1
         control1 -1
         scale 0.4
      }
      translate y*5
   }
   
   superellipsoid {
      <0.2, 0.2>
      
      pigment {
         color rgb <0.0941176, 0.0941176, 0.0941176>
      }
      
      finish {
         phong 1
         
         reflection {
            rgb <0.101961, 0.101961, 0.101961>
            metallic 1
         }
      }
      scale <1.1, 1.3, 1.1>
      translate y*(-3.7)
   }
}

#declare Microfono = union {
   object {
      Tubo
      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01
         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale <0.7, 0.5, 0.7>
   }
   
   object {
      Tubo
      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01
         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale <0.44, 0.7, 0.44>
      translate y*3
   }
   
   object {
      Tubo
      
      pigment {
         color rgb <0.0901961, 0.0901961, 0.0901961>
      }
      
      finish {
         specular 0.3
      }
      scale <1, 0.1, 1>
      translate y*5
   }
   
   object {
      Tubo
      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01
         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale 0.3
      rotate <120, 120, 0>
   }
   
   object {
      Tubo
      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01
         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale 0.3
      rotate <120, -120, 0>
   }
   
   object {
      Tubo
      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01
         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale 0.3
      rotate x*120
   }
   
   object {
      Mic
      scale 0.16
      rotate x*85
      translate y*10
   }
}

#declare Microfono2 = union {
   object {
      Tubo      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01
         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale <0.7, 0.5, 0.7>
   }
   
   object {
      Tubo      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01
         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale <0.44, 0.7, 0.44>
      rotate x*30
      translate <0, 3, -1.5>
   }
   
   object {
      Tubo
      
      pigment {
         color rgb <0.0901961, 0.0901961, 0.0901961>
      }
      
      finish {
         specular 0.3
      }
      scale <1, 0.1, 1>
      translate y*5
   }
   
   object {
      Tubo      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale 0.3
      rotate <120, 120, 0>
   }
   
   object {
      Tubo
      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale 0.3
      rotate <120, -120, 0>
   }
   
   object {
      Tubo
      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
      scale 0.3
      rotate x*120
   }
   
   object {
      Mic
      scale 0.16
      rotate x*85
      translate <0, 9, 2>
   }
   
   prism {
      linear_spline
      linear_sweep
      -0.2, 0.2,
      7,
      <0.3, 1>, <0.8, -0.6>, <0.35, -1>, <-0.35, -1>, <-0.8, -0.6>, <-0.3, 1>, <0.3, 1>
      
      pigment {
         color rgb <0.0901961, 0.0901961, 0.0901961>
      }
      
      finish {
         specular 0.3
      }
      scale 0.6
      rotate <0, 60, 90>
      translate <0, 3.11011, -1.43065>
   }
}

//Here is something that in the main picture is not seen, if you try other camera you'll see this cable
#declare Espiga = difference {
   union {
      sor {
         8,
         <0.259272, -0.671751>, <0.405719, -0.147834>, <0.557437, 0.152513>, <0.628229, 0.735702>, <0.583307, 0.803109>, <0.629521, 0.867446>, <0.606066, 2.11421>, <0.447834, 2.59099>
         scale <0.9, 1.2, 0.9>
         translate y*(-2)
      }
      
      cylinder {
         <0, 1, 0>, <0, -1, 0>, 0.2
         translate y*1.3
      }
      
      sor {
         7,
         <0.68502, -0.12393>, <0.2, 0.3>, <0.091388, 0.42012>, <0.2, 0.553905>, <0.143298, 0.693445>, <0.0563155, 0.870879>, <0.0680155, 1.1051>
         translate y*2
      }
      
      pigment {
         color rgb <0.0862745, 0.0862745, 0.0862745>
      }
      
      finish {
         specular 1
         roughness 0.01
         
         reflection {
            rgb <0.52549, 0.52549, 0.52549>
         }
      }
   }
   
   torus {
      2, 0.05
      
      pigment {
         color rgb <0.133333, 0.133333, 0.133333>
      }
      scale <0.1, 1, 0.1>
      translate y*2.25
   }
}

#declare Cable = union {
   sphere_sweep {
      cubic_spline,
      33,
      <1.10803, -7.09939, 19.2522>,0.3
      <0.664559, -0.58055, 14.3729>,0.350012
      <0.347405, 3.82351, 11.8257>,0.350024
      <0.0450083, 8.06906, 10.5078>,0.350049
      <0.0675124, 11.1987, 10.2228>,0.350073
      <0.0689189, 13.6287, 9.51511>,0.350075
      <0.0703255, 14.0676, 7.81188>,0.350076
      <0.0731385, 13.6435, 5.55412>,0.350079
      <0.0787645, 11.3092, 4.4794>,0.350085
      <0.0843905, 8.48019, 5.5088>,0.350092
      <0.0900166, 6.99556, 6.47401>,0.350098
      <0.135025, 4.98189, 6.61111>,0.350146
      <0.180033, 3.0914, 5.87031>,0.350195
      <0.534232, -1.49244, 3.5538>,0.350391
      <0.720133, -4.56453, 0.617838>,0.350781
      <0, -5.02831, -3.78955>,0.351562
      <0, -3.27267, -6.03814>,0.353125
      <0, -0.444703, -5.74392>,0.35625
      <0, 1.31395, -4.13096>,0.359375
      <0, 1.541, -1.59905>,0.3625
      <0, -0.526129, 0.76041>,0.36875
      <0, -3.91857, 1.15846>,0.375
      <0, -7.88552, -0.295175>,0.38125
      <0, -9.31475, -2.0392>,0.3875
      <0, -9.93406, -6.08962>,0.39375
      <0, -8.50262, -10.03>,0.396875
      <0, -5.5815, -14.3217>,0.398438
      <0, -0.218219, -18.5125>,0.399219
      <0, 6.60761, -17.8213>,0.399609
      <0, 9.37746, -18.6904>,0.399805
      <0, 7.61852, -21.9116>,0.399902
      <0, -1.14268, -24.1324>,0.4
      <-1.22922e-14, -30.6455, -12.1195>,0.5
      
      pigment {
         color rgb <0.109804, 0.109804, 0.109804>
      }
      
      finish {
         specular 0.4
      }
   }
   
   object {
      Espiga
      scale 1.2
      rotate <144.1, 5.9, 0>
      translate <0.760292, -1.71484, 15.2679>
   }
}

//The Milo begin here
#declare PAgarradera = difference {
   prism {
      cubic_spline
      linear_sweep
      0, 1,
      7,
      <-1.2, -1.2>, <-1.2, 1.2>, <1.2, 1>, <1.2, -1>, <-1.2, -1.2>, <-1.2, 1.2>, <1.2, 1>
   }
   
   box {
      <-2, -1, -1>, <2, 1, 1>
      rotate y*5.7
      translate <0, 0.5, 2.26>
   }
   
   box {
      <-2, -1, -1>, <2, 1, 1>
      rotate y*(-5.7)
      translate <0, 0.5, -2.26>
   }
   
   box {
      <-2, -1, -1>, <2, 1, 1>
      rotate y*90
      translate <2.4, 0.5, 0>
   }
   
   box {
      <-2, -1, -1>, <2, 1, 1>
      rotate y*90
      translate <-2.4, 0.5, 0>
   }
}

//Milo is a model of loudspeaker from Meyer Sound, I tried to make something similar with CSG
#declare MiloBasico = union {
   difference {
      prism {
         linear_spline
         linear_sweep
         -6, 6,
         9,
         <1.8, 1.6>, <2, 1.4>, <2, -1.4>, <1.8, -1.6>, <-1.8, -2>, <-2, -1.8>, <-2, 1.8>, <-1.8, 2>, <1.8, 1.6>
      }
      
      object {
         PAgarradera
         translate y*5.7
      }
      
      object {
         PAgarradera
         scale <0.8, 1, 0.8>
         translate y*5.5
      }
      
      object {
         PAgarradera
         translate y*(-6.7)
      }
      
      object {
         PAgarradera
         scale <0.8, 1, 0.8>
         translate y*(-5.5)
      }
   }
   
   superellipsoid {
      <0.1, 0.2>
      scale <1.45, 0.06, 0.2>
      translate y*5.945
   }
   
   superellipsoid {
      <0.1, 0.2>
      scale <1.45, 0.06, 0.2>
      translate y*(-5.945)
   }
   scale <1.4, 1, 1>
   translate x*(-20)
}

#declare Driver = difference {
   prism {
      linear_spline
      conic_sweep
      0.1, 1,
      5,
      <1.3, 1>, <1.3, -1>, <-1.3, -1>, <-1.3, 1>, <1.3, 1>
      scale <0.9, 1.5, 1.5>
      rotate z*90
      translate <-21.305, 0.9, 0>
   }
   
   box {
      <-1, -0.04, -1.8>, <1, 0.04, 1.8>
      rotate x*90
      translate <-21.5, 0.9, 0>
   }
   
   box {
      <-1, -0.04, -1.8>, <1, 0.04, 1.8>
      rotate x*90
      translate <-21.5, 0.9, -0.5>
   }
   
   box {
      <-1, -0.04, -1.8>, <1, 0.04, 1.8>
      rotate x*90
      translate <-21.5, 0.9, 0.5>
   }
}

#declare Driver2 = difference {
   prism {
      linear_spline
      conic_sweep
      0.1, 1,
      5,
      <1.3, 1>, <1.3, -1>, <-1.3, -1>, <-1.3, 1>, <1.3, 1>
      scale <0.9, 1.5, 1.5>
      rotate z*90
      translate <-21.305, 0.9, 0>
   }
   
   box {
      <-1, -0.04, -1.8>, <1, 0.04, 1.8>
      rotate x*90
      translate <-21.5, 0.9, 0>
   }
   
   box {
      <-1, -0.04, -1.8>, <1, 0.04, 1.8>
      rotate x*90
      translate <-21.5, 0.9, -0.5>
   }
   
   box {
      <-1, -0.04, -1.8>, <1, 0.04, 1.8>
      rotate x*90
      translate <-21.5, 0.9, -1>
   }
   
   box {
      <-1, -0.04, -1.8>, <1, 0.04, 1.8>
      rotate x*90
      translate <-21.5, 0.9, 0.5>
   }
   
   box {
      <-1, -0.04, -1.8>, <1, 0.04, 1.8>
      rotate x*90
      translate <-21.5, 0.9, 1>
   }
}

#declare Milo = union {
   difference {
      object {
         MiloBasico
      }
      
      object {
         Driver
         scale <1, 1, 1.1>
      }
      
      object {
         Driver2
         scale <0.5, 0.6, 1.1>
         translate <-11.4, -1.8, 0>
      }
      
      cone {
         <0, 0.5, 0>, 0,
         <0, -0.5, 0>, 1.3
         rotate z*(-90)
         translate <-22.306, -4, 0>
      }
      
      cone {
         <0, 0.5, 0>, 0,
         <0, -0.5, 0>, 1.3
         rotate z*(-90)
         translate <-22.306, 4, 0>
      }
      
      cylinder {
         <-1.5, 0, 0>, <1.5, 0, 0>, 0.34
         translate <-21.5, 5.4, 1.2>
      }
      
      cylinder {
         <-1.5, 0, 0>, <1.5, 0, 0>, 0.34
         translate <-21.5, -5.4, 1.2>
      }
      
      cylinder {
         <-1.5, 0, 0>, <1.5, 0, 0>, 0.34
         translate <-21.5, 5.4, -1.2>
      }
      
      cylinder {
         <-1.5, 0, 0>, <1.5, 0, 0>, 0.34
         translate <-21.5, -5.4, -1.2>
      }
   }
   
   sphere {
      <0, 0, 0>, 0.8
      scale <1, 1.2, 1.2>
      translate <-21.7, 4, 0>
   }
   
   sphere {
      <0, 0, 0>, 0.8
      scale <1, 1.2, 1.2>
      translate <-21.7, -4, 0>
   }
   
   torus {
      1.25, 0.07
      rotate z*90
      translate <-22.78, -4, 0>
   }
   
   torus {
      1.25, 0.07
      rotate z*90
      translate <-22.78, 4, 0>
   }
   
   pigment {
      color rgb <0.0431373, 0.0392157, 0.0156863>
   }
   
   finish {
      specular 1.5
   }
}

#declare MG = intersection {
   difference {
      superellipsoid {
         <0.03, 0.03>
      }
      
      superellipsoid {
         <0.05, 0.05>
         scale 0.9
      }
   }
   
   box {
      <-1.3, -0.15, -1.3>, <1.3, 0.15, 1.3>
   }
   
   pigment {
      color rgb <0.0431373, 0.0392157, 0.0156863>
   }
   
   finish {
      specular 0.7
   }
}

#declare Cuerda = cylinder {
   <0, 2, 0>, <0, -2, 0>, 0.03
   
   pigment {
      color rgb <0.454902, 0.454902, 0.454902>
   }
   
   finish {
      specular 1
      roughness 0.01      
      reflection {
         rgb <0.52549, 0.52549, 0.52549>
      }
   }
   translate y*2
}

#declare MG_3DM = union {
   object {
      MG
      scale <1.2, 1, 1>
   }
   
   intersection {
      object {
         MG
         matrix < 1, 0, 0.1,
                  0, 1, 0,
                  0.1, 0, 1,
                  0, 0, 0 >
         scale <0.9, 1, 0.9>
         rotate y*45
      }
      
      superellipsoid {
         <0.03, 0.03>
         scale <1.2, 1, 1>
      }
   }
   
   object {
      Cuerda
      scale <1, 0.7, 1>
      rotate x*50
      translate <1.1, 0.12, -0.96>
   }
   
   object {
      Cuerda
      scale <1, 0.7, 1>
      rotate x*50
      translate <-1.1, 0.12, -0.96>
   }
}

#declare MiloCurvilinearArray = union {
   object {
      Milo
      scale 0.3
      rotate <0, -90, 90>
      translate y*1.25
   }
   
   object {
      Milo
      scale 0.3
      rotate <0, -90, 90>
   }
   
   object {
      Milo
      scale 0.3
      rotate <0, -79, 90>
   }
   
   object {
      Milo
      scale 0.3
      rotate <0, -68, 90>
   }
   
   object {
      Milo
      scale 0.3
      rotate <0, -57, 90>
   }
   
   object {
      MG_3DM
      scale <1.5, 1.2, 1.3>
      translate <0, 2.1, -6.2>
   }
}

//The fence
#declare Esquina = intersection {
   torus {
      1.5, 0.2
   }
   
   box {
      <-1, -0.5, -1>, <1, 0.5, 1>
      translate <-1, 0, 1>
   }
}

#declare TuboBaranda = cylinder {
   <0, 2, 0>, <0, -2, 0>, 0.2
}

#declare Baranda = union {
   object {
      Esquina
      rotate x*(-90)
      translate <-4, 2, 0>
   }
   
   object {
      Esquina
      rotate <-90, 180, 0>
      translate <4, 2, 0>
   }
   
   object {
      Esquina
      rotate x*90
      translate <-4, -2, 0>
   }
   
   object {
      Esquina
      rotate <90, 180, 0>
      translate <4, -2, 0>
   }
   
   object {
      TuboBaranda
      translate x*(-5.5)
   }
   
   object {
      TuboBaranda
      scale <0.8, 1.7, 0.8>
      translate x*1
   }
   
   object {
      TuboBaranda
      scale <0.8, 1.7, 0.8>
      translate x*(-1)
   }
   
   object {
      TuboBaranda
      scale <0.8, 1.7, 0.8>
      translate x*3
   }
   
   object {
      TuboBaranda
      scale <0.8, 1.7, 0.8>
      translate x*(-3)
   }
   
   object {
      TuboBaranda
      translate x*5.5
   }
   
   object {
      TuboBaranda
      scale <1, 2, 1>
      rotate z*90
      translate y*3.5
   }
   
   object {
      TuboBaranda
      scale <1, 2, 1>
      rotate z*90
      translate y*(-3.5)
   }
   
   object {
      TuboBaranda
      scale <0.8, 0.3, 0.8>
      translate <-3.7, -4.2, 0>
   }
   
   object {
      TuboBaranda
      scale <0.8, 0.3, 0.8>
      translate <3.7, -4.2, 0>
   }
   
   pigment {
      color rgb <0.572549, 0.572549, 0.572549>
   }
   
   finish {
      metallic 1
      specular 1
      roughness 0.05      
      reflection {
         rgb <0.0941176, 0.0941176, 0.0941176>
      }
   }
}

//The group of lights turned off
#declare LucesTraseras = difference {
   superellipsoid {
      <0.8, 0.05>
      scale <0.54, 0.54, 1>
      rotate x*90
   }
   
   cylinder {
      <0, 1.2, 0>, <0, -0.8, 0>, 0.4
      
      pigment {
         color rgb <0.219608, 0.219608, 0.219608>
      }
      
      finish {
         specular 1         
         reflection {
            rgb <0.06, 0.06, 0.06>
         }
      }
      scale <1, 0.2, 1>
      translate y*1
   }
   
   texture {
      TAluces
   }
   rotate x*180
}


                                     //The complete scene




union {
   superellipsoid {
      <0.1, 0.1>
      
      texture {
         TAluces
      }
      scale <4.5, 0.1, 0.26>
      translate y*0.62
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*80
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*1
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*40
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*2
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*75
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*3
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*60
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*(-1)
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*70
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*(-2)
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*70
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*(-3)
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*64
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
   }
   
   difference {
      superellipsoid {
         <0.1, 0.2>
      }
      
      superellipsoid {
         <0.1, 0.2>
         scale <0.98, 0.9, 1.4>
      }
      
      box {
         <-1.4, -1, -1.4>, <1.4, 1, 1.4>
         translate y*(-1.5)
      }
      
      box {
         <-1.4, -1, -1.4>, <1.4, 1, 1.4>
         scale <1, 1.2, 1>
         translate z*(-1.6)
      }
      
      box {
         <-1.4, -1, -1.4>, <1.4, 1, 1.4>
         scale <1, 1.2, 1>
         translate z*1.6
      }
      texture {TAluces}
      scale <3.7, 0.62, 0.5>
      rotate x*180
      translate y*0.23
   }
   translate <0, 9.28, 7>
}

union {
   superellipsoid {
      <0.1, 0.1>
      
      texture {
         TAluces
      }
      scale <4.5, 0.1, 0.26>
      translate y*0.62
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*50
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*1
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*20
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*2
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*20
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*3
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*60
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*(-1)
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*70
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*(-2)
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*70
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
      translate x*(-3)
   }
   
   union {
      object {
         LucesTraseras
         scale <1, 0.5, 1>
         rotate x*80
      }
      
      object {
         Soporte
         scale <1, 0.6, 1>
      }
      scale 0.43
   }
   
   difference {
      superellipsoid {
         <0.1, 0.2>
      }
      
      superellipsoid {
         <0.1, 0.2>
         scale <0.98, 0.9, 1.4>
      }
      
      box {
         <-1.4, -1, -1.4>, <1.4, 1, 1.4>
         translate y*(-1.5)
      }
      
      box {
         <-1.4, -1, -1.4>, <1.4, 1, 1.4>
         scale <1, 1.2, 1>
         translate z*(-1.6)
      }
      
      box {
         <-1.4, -1, -1.4>, <1.4, 1, 1.4>
         scale <1, 1.2, 1>
         translate z*1.6
      }
      texture {
         TAluces
      }
      scale <3.7, 0.62, 0.5>
      rotate x*180
      translate y*0.23
   }
   rotate y*180
   translate <0, 9.28, -0.9>
}

union {   
   object {
      Baranda
      scale 0.24
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*3
      translate <-3, 0, 0.1>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*(-4)
      translate <3, 0, 0.2>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*(-6)
      translate <5.9, 0, 0.45>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*(-7)
      translate <8.8, 0, 0.8>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*(-10)
      translate <11.74, 0, 1.24>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*(-15)
      translate <14.54, 0, 1.88>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*15
      translate <-14.54, 0, 1.88>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*(-20)
      translate <17.32, 0, 2.76>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*20
      translate <-17.32, 0, 2.76>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*10
      translate <-11.74, 0, 1.24>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*7
      translate <-8.8, 0, 0.8>
   }
   
   object {
      Baranda
      scale 0.24
      rotate y*6
      translate <-5.9, 0, 0.45>
   }
   scale 0.7
   translate <0, 0.105, -7>
}

object {
   MiloCurvilinearArray
   scale 0.5
   translate <-5, 9.2994, 0.8>
}

object {
   MiloCurvilinearArray
   scale 0.5
   translate <5, 9.2994, 0.8>
}

object {
   Tarima   
   texture {
      MaderaFinal
   }
   scale <3, 2, 3>
   translate z*2.6
}

object {
   Tarima   
   pigment {
      brick
      color rgbt <0.25882, 0.12549, 0, 0.5>
      color rgbt <1, 1, 1, 1>
      brick_size <4, 0.4, 5>
      mortar 0.02
      rotate <90, 90, 0>
      translate z*(-0.01)
   }
   scale <3*1.0001,2*1.0001,3*1.0001>
   translate z*2.6
   no_shadow
}

object {
   Monitor
   scale 0.4
   rotate y*27
   translate <-0.757858, 1.23191, -0.725156>
}

object {
   Monitor
   scale 0.4
   rotate y*(-27)
   translate <0.75786, 1.2319, -0.72516>
}

union {
   object {
      LuzCilRojo
      rotate x*35      //you can rotate this for rotate only the ngle of the light
   }
   
   object {
      Soporte
   }
   rotate y*(-103)         //this to rotate around the whole light
   scale 0.5
   translate <-5, 9, -1>
}

union {
   object {
      LuzCilAzul
      rotate x*35      //you can rotate this for rotate only the ngle of the light
   }
   
   object {
      Soporte
   }
   rotate y*103          //this to rotate around the whole light
   scale 0.5
   translate <5, 9, -1>
}

union {
   object {
      LuzCilRojo      //you can rotate this for rotate only the ngle of the light
      rotate x*61
   }
   
   object {
      Soporte
   }
   rotate y*(-30)      //this to rotate around the whole light
   scale 0.5
   translate <5, 9, 7>
}

union {
   object {
      LuzCilAzul
      rotate x*75      //you can rotate this for rotate only the ngle of the light
   }
   
   object {
      Soporte
   }
   rotate y*28        //this to rotate around the whole light
   scale 0.5
   translate <-5, 9, 7>
}

//The floor
box {
   //*PMName Piso
   <-5, -0.5, -7>, <5, 0.5, 7>   
   texture {
      MaderaFinal2
      scale 0.4
      rotate y*90
   }
   scale <4, 1, 3>
   translate <0, -1.2, -5>
}

object {
   Cartel
   scale 0.3
   rotate y*50
   translate <-10.2, 0.277, -7>
}

object {
   Cortina
   scale <1, 1.5, 2>
   rotate <90, 175, 0>
   translate <10, 7.0559, 10>
}

object {
   Cortina
   scale <1, 1.5, 2>
   rotate <90, 180, 0>
   translate <-7.04005, 7.0559, 9.28328>
}

object {
   EstTotal
   texture {
   pigment {
      agate
      agate_turb 0.5      
      color_map {
         [ 0 color rgb <0.360784, 0.360784, 0.360784>     ]
         [ 0.1 color rgb <0.435294, 0.435294, 0.435294>   ]
         [ 0.2 color rgb <0.635294, 0.635294, 0.635294>   ]
         [ 0.5 color rgb <0.431373, 0.431373, 0.431373>   ]
         [ 0.75 color rgb <0.607843, 0.607843, 0.607843>  ]
         [ 0.8 color rgb <0.372549, 0.372549, 0.372549>   ]
         [ 1 color rgb <0.423529, 0.423529, 0.423529>     ]
      }
   }
   
   finish {
      specular 1
      roughness 0.2
      
      reflection {
         rgb <0.380392, 0.380392, 0.380392>
      }
   }
}
   translate z*(-3.2)
}

object {
   BomFinal
   scale 0.75
   rotate y*(-84.1)
   translate y*1.74
}

object {
   Cable
   scale 0.1
   rotate z*90
   translate <10.8866, 1.04, 3.06592>
}

object {
   Cable
   scale 0.1
   rotate z*90
   translate <11.7941, 1.04, 6.14891>
}

object {
   Microfono2
   scale 0.15
   translate <0, 1.23, -2.5>
}

object {
   Microfono2
   scale 0.15
   rotate y*(-40)
   translate <-5, 1.23, 0>
}

object {
   Microfono
   scale 0.15
   translate <3.47, 1.23, -1>
}