// Persistence of Vision Ray Tracer Include File
// File: sky.inc
// Vers: 3.6
// Desc: Various components describing the sky around the megalithic site.
// Date: 21-June-2006
// Auth: Rick Wedgeworth
//
// Note: The units are in meters.

// ===== Set some useful constants ====


// ===== Build some textures ====
#declare CentralFogMat = material {
   texture {
      pigment {
         rgbt <1,1,1,1>
      }
      finish {
         ambient 0.2
         diffuse 0
      }
   }
   interior {
      fade_distance 2.0
      fade_power 0.5
      fade_color  <0.7,0.6,0.5>

      media {
         intervals 30
         ratio 0.9
         samples 2,4
         confidence 0.9
         variance 1.0/128.0
         method 1
         absorption <0.04,0.05,0.06>
         emission <0.11,0.1,0.1>
         density {            
            spherical
            density_map {
               [0.0 color 0 ]
               [1.0 color 1 ]
            }
            scale 30
         }         
         density {            
            bozo
            turbulence 2
            density_map {
               [0.0 color 0 ]
               [1.0 color 0.7 ]
            }
            scale 2
         }
      }
   }
}

#declare OminousFogMat = material {
   texture {
      pigment {
         rgbt <1,1,1,1>
      }
      finish {
         ambient 0.2
         diffuse 0
      }
   }
   interior {
      fade_distance 120
      fade_power 10
      fade_color <1,1,1>

      media {
         intervals 30
         ratio 0.9
         samples 2,4
         confidence 0.9
         variance 1.0/128.0
         method 1
         absorption <0.6,0.7,0.3>
         emission <0.0,0.0,0.0>
         density {            
            spherical
            density_map {
               [0.0 color 0 ]
               [1.0 color 1 ]
            }
            scale 40
         }         
         density {            
            bozo
            turbulence 2
            density_map {
               [0.0 color 0 ]
               [1.0 color 0.1 ]
            }
            scale 10
         }
      }
   }
}

#declare RayTexture1 =
  texture {
    pigment { 
      bozo
      turbulence 0.3
      color_map {
        [ 0.0  color rgbt <1.00,1.00,1.00,1.00> ]
        [ 0.1  color rgbt <1.00,1.00,1.00,0.95> ]
        [ 0.2  color rgbt <0.99,1.00,1.00,0.93> ]
        [ 0.3  color rgbt <0.99,1.00,1.00,1.00> ]
        [ 0.6  color rgbt <0.98,0.98,1.00,1.00> ]
        [ 1.0  color rgbt <1.00,1.00,0.99,0.95> ]
      }
      scale <1,2,1>
    }
    finish { ambient 0.5 }
  }


#declare RayTexture1 =
  texture {
    pigment { 
      bozo
      turbulence 0.3
      color_map {
        [ 0.0  color rgbt <1.00,1.00,1.00,1.00> ]
        [ 0.1  color rgbt <1.00,1.00,1.00,0.95> ]
        [ 0.2  color rgbt <0.99,1.00,1.00,0.93> ]
        [ 0.3  color rgbt <0.99,1.00,1.00,1.00> ]
        [ 0.6  color rgbt <0.98,0.98,1.00,1.00> ]
        [ 1.0  color rgbt <1.00,1.00,0.99,0.95> ]
      }
      scale <1,2,1>
    }
    finish { ambient 0.5 }
  }


#declare RayTexture2 =
  texture {
    pigment { 
      bozo
      turbulence 0.3
      color_map {
        [ 0.0  color rgbt <1.00,1.00,1.00,1.00> ]
        [ 0.3  color rgbt <1.00,1.00,1.00,0.97> ]
        [ 0.4  color rgbt <0.99,1.00,1.00,1.00> ]
        [ 0.7  color rgbt <0.99,1.00,1.00,0.95> ]
        [ 0.9  color rgbt <0.98,0.98,1.00,1.00> ]
        [ 1.0  color rgbt <1.00,1.00,0.99,0.97> ]
      }
      scale <1,5,1>
    }
    finish { ambient 0.7 }
  }

#declare RayTexture3 =
  texture {
    pigment { 
      bozo
      turbulence 0.3
      color_map {
        [ 0.0  color rgbt <1.00,1.00,1.00,1.00> ]
        [ 0.6  color rgbt <1.00,1.00,1.00,0.99> ]
        [ 0.7  color rgbt <0.99,1.00,1.00,0.99> ]
        [ 0.8  color rgbt <0.99,1.00,1.00,1.00> ]
        [ 0.9  color rgbt <0.98,0.98,1.00,1.00> ]
        [ 1.0  color rgbt <1.00,1.00,0.99,0.99> ]
      }
      scale <1,3,1>
    }
    finish { ambient 0.2 }
  }
  
#declare RayTexture4 =
  texture {
    pigment { 
      bozo
      turbulence 0.3
      color_map {
        [ 0.0  color rgbt <1.00,1.00,1.00,1.00> ]
        [ 0.6  color rgbt <1.00,1.00,1.00,0.99> ]
        [ 0.7  color rgbt <1.00,1.00,1.00,0.99> ]
        [ 0.8  color rgbt <1.00,1.00,1.00,1.00> ]
        [ 0.9  color rgbt <1.00,1.00,1.00,1.00> ]
        [ 1.0  color rgbt <1.00,1.00,1.00,0.99> ]
      }
      scale <1,3,1>
    }
    finish { ambient 0.1 }
  }


// ===== Build some interesting objects ====

#declare CentralFog = sphere {
   <0,0,0>, 25
   hollow
   material {
     CentralFogMat
   }
}

#declare OminousFog = sphere {
   <0,0,0>, 70
   hollow
   material {
     OminousFogMat
   }
   translate <0,0,20>
   scale <1,3,5>
   translate <0,0,70>
}

#declare Ray = cylinder {
  <0,0,0>,<0,80,0>,0.8
}

#declare Ray1 = object {
  Ray
  texture { RayTexture1 }
}

#declare Ray2 = object {
  Ray
  texture { RayTexture2 }
}

#declare Ray3 = object {
  Ray
  texture { RayTexture3 }
}

#declare Ray4 = object {
  Ray
  texture { RayTexture4 }
}


#declare Bird = blob {
  sphere { < 0.0,0.0,0.0>,0.5, 1.0 }
  sphere { <-0.2,0.0,0.0>,0.4, 1.0 }
  sphere { <-0.4,0.0,0.0>,0.3, 1.0 }
  sphere { <-0.6,0.0,0.0>,0.2, 1.0 }

  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.2, 0.20> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.3, 0.25> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.4, 0.30> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.5, 0.35> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.6, 0.40> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.7, 0.45> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.6, 0.50> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.5, 0.55> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.4, 0.60> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate <-0.2,0.3, 0.65> }

  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.2, 0.20> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.3, 0.25> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.4, 0.30> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.5, 0.35> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.6, 0.40> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.7, 0.45> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.6, 0.50> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.5, 0.55> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.4, 0.60> }
  sphere { < 0.0,0.0,0.0>,0.3, 1.0 scale <1.0,1.0,0.2> translate < 0.2,0.3, 0.65> }
}

// ===== Build main objects ====

#declare cluster=0.75;
#declare Beam = union {
  object { Ray1 scale <0.5,1.0,0.5> translate < 1.1*cluster,0, 2.1*cluster> }
  object { Ray4 scale <1.5,0.1,0.3> translate < 0.2*cluster,0, 6.0*cluster> }
  object { Ray4 scale <0.7,1.1,0.9> translate < 2.9*cluster,0, 4.3*cluster> }
  object { Ray1 scale <0.5,0.7,1.5> translate < 4.3*cluster,0, 3.0*cluster> }
  object { Ray3 scale <0.2,0.9,1.2> translate < 5.1*cluster,0, 0.1*cluster> }
  object { Ray2 scale <1.1,0.8,0.9> translate < 4.1*cluster,0,-3.2*cluster> }
  object { Ray1 scale <0.5,0.9,0.1> translate < 3.2*cluster,0,-4.0*cluster> }
  object { Ray4 scale <1.0,1.1,0.3> translate < 0.1*cluster,0,-5.1*cluster> }
  object { Ray3 scale <0.1,0.9,0.5> translate <-3.2*cluster,0,-4.2*cluster> }
  object { Ray1 scale <1.0,0.8,0.9> translate <-3.9*cluster,0,-2.8*cluster> }
  object { Ray3 scale <0.9,1.1,1.1> translate <-5.3*cluster,0,-0.2*cluster> }
  object { Ray2 scale <0.3,0.8,0.8> translate <-4.1*cluster,0, 3.1*cluster> }
  object { Ray4 scale <0.5,0.9,0.7> translate <-3.2*cluster,0, 4.0*cluster> }
  rotate <0,10,0>
}

#declare Flock = union {
  object { Bird scale 0.2 rotate <0,150,0> translate <-10,22.0,10.3> }
  object { Bird scale 0.2 rotate <0,100,0> translate <-10,21.3, 9.7> }
  object { Bird scale 0.2 rotate <0, 90,0> translate <-10,19.6,10.2> }
  object { Bird scale 0.2 rotate <0,120,0> translate <-10,19.2,10.5> }
  object { Bird scale 0.2 rotate <0,110,0> translate <-10,20.3,10.6> }
  object { Bird scale 0.2 rotate <0, 90,0> translate <-10,20.1,10.0> }
  object { Bird scale 0.2 rotate <0,130,0> translate <-10,20.1,12.2> }
  object { Bird scale 0.2 rotate <0,160,0> translate <-10,19.9,10.2> }
  object { Bird scale 0.2 rotate <0, 90,0> translate <-10,20.1,11.2> }
  object { Bird scale 0.2 rotate <0,120,0> translate <-10,20.4,10.0> }
  object { Bird scale 0.2 rotate <0,130,0> translate <-10,20.1,10.7> }
  object { Bird scale 0.2 rotate <0, 90,0> translate <-10,20.2,10.9> }
  object { Bird scale 0.2 rotate <0,150,0> translate <-10,19.4, 9.1> }
  translate <-10,10,20>
}
