// Persistence of Vision Ray Tracer Include File
// File: stones.inc
// Vers: 3.6
// Desc: Various components describing the stones around the megalithic site.
// Date: 21-June-2006
// Auth: Rick Wedgeworth
//
// Note: The units are in meters.

// ===== Set some useful constants ====

#declare NearGroundGirth  =  96.0;
#declare NearGroundHeight =   3.5;
#declare FarGroundGirth   = 760.0;
#declare FarGroundHeight  =  40.0;

// ===== Create some macros ====

#macro makeStone(front, back)
  union {
    height_field { jpeg front water_level 0.1 smooth translate <0,-0.1,0> scale <1,1.111,1> }
    difference {
      box {<0.001,0.001,0.001>,<0.999,0.898,0.999>}
      intersection {
        box { <0,0.0,0>,<1,0.9,1> } 
        height_field { jpeg back smooth }
      }
      translate <0,-0.899,0> 
      scale <1,1.111,1>
    }
    rotate <-90,0,0>
    translate <-0.5,0.0,0.5>
  }
#end

#macro makeFallenStone(front)
  object {
    height_field { jpeg front water_level 0.1 smooth translate <0,-0.1,0> scale <1,1.111,1> }
    translate <-0.5,0.0,-0.5>
  }
#end


// ===== Build some textures ====

#declare SarsenTexture = 
texture {
  pigment {
    bozo
    turbulence 0.3
    color_map { 
        [0.00 color < 0.65, 0.62, 0.58 > ]
        [0.30 color < 0.92, 0.96, 0.96 > ]
        [0.70 color < 0.62, 0.66, 0.66 > ]
        [1.00 color < 0.82, 0.87, 0.84 > ]
    }
    scale 3
  }
  finish { ambient 0.20 }
}
texture {
  pigment {
    bozo
    turbulence 0.3
    color_map { 
        [0.00 color rgbf < 0.82, 0.86, 0.76, 1.0 > ]
        [0.30 color rgbf < 0.55, 0.52, 0.48, 1.0 > ]
        [0.70 color rgbf < 0.82, 0.87, 0.84, 1.0 > ]
        [1.00 color rgbf < 0.32, 0.36, 0.26, 1.0 > ]
    }
    scale 0.2
  }
  finish { ambient 0.2 }
}
texture {
  pigment {
    bozo
    turbulence 0.7
    color_map { 
        [0.00 color rgbf < 0.52, 0.56, 0.46, 0.5 > ]
        [0.30 color rgbf < 0.75, 0.72, 0.68, 0.9 > ]
        [0.35 color rgbf < 0.51, 0.52, 0.42, 0.8 > ]
        [0.40 color rgbf < 0.75, 0.72, 0.58, 0.9 > ]
        [0.70 color rgbf < 0.72, 0.77, 0.64, 0.9 > ]
        [1.00 color rgbf < 0.62, 0.66, 0.56, 0.7 > ]
    }
    scale 0.01
  }
  finish { ambient 0.1 }
}
texture {
  pigment {
    bozo
    turbulence 0.5
    color_map { 
        [0.00 color rgbf < 0.42, 0.46, 0.36, 1.0 > ]
        [0.30 color rgbf < 0.75, 0.72, 0.58, 1.0 > ]
        [0.70 color rgbf < 0.82, 0.87, 0.74, 1.0 > ]
        [1.00 color rgbf < 0.72, 0.76, 0.46, 1.0 > ]
    }
    scale 3
  }
  normal { wrinkles 0.1 }
  finish { ambient 0.2 }
}
texture {
  pigment {
    bozo
    turbulence 0.1
    
      pigment_map {
        [0.0
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.50 color rgbf < 1.00, 1.00, 1.00, 0.90 > ]
                [0.60 color rgbf < 0.70, 0.65, 0.10, 0.00 > ]
                [0.90 color rgbf < 0.70, 0.65, 0.10, 0.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale 1/2
        ]
        [0.10 
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.50 color rgbf < 1.00, 1.00, 1.00, 0.90 > ]
                [0.60 color rgbf < 0.50, 0.30, 0.10, 0.00 > ]
                [0.90 color rgbf < 0.50, 0.30, 0.10, 0.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale 1/2
        ]
        [0.20 
              agate
              turbulence 0.5
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.50 color rgbf < 1.00, 1.00, 1.00, 0.90 > ]
                [0.60 color rgbf < 0.70, 0.80, 0.65, 0.00 > ]
                [0.90 color rgbf < 0.70, 0.80, 0.65, 0.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale 1/12
        ]
        [0.80 
              agate
              turbulence 0.0
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.10 color rgbf < 0.15, 0.15, 0.20, 0.00 > ]
                [0.90 color rgbf < 0.15, 0.15, 0.20, 0.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale 1/1
        ]
        [1.0 
              agate
              turbulence 0.5
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.80 color rgbf < 1.00, 1.00, 1.00, 0.90 > ]
                [0.85 color rgbf < 0.70, 0.55, 0.25, 0.00 > ]
                [0.95 color rgbf < 0.70, 0.55, 0.25, 0.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale 1/2
        ]
      }
    scale 5
  }
  normal { wrinkles 0.1 }
  finish { ambient 0.25 }
}


// ===== Build some interesting objects ====

#declare Sarsen01 = object { 
  makeStone("sarsen01F.jpg","sarsen01B.jpg") 
  scale <2.11,4.1,1.05>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.13> 
  rotate <0,6,0>
}

#declare Sarsen02 = object { 
  makeStone("sarsen02F.jpg","sarsen02B.jpg") 
  scale <2.37,4.1,1.58>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.13> 
  rotate <0,18,0>
}

#declare Sarsen03 = object { 
  makeStone("sarsen03F.jpg","sarsen03B.jpg") 
  scale <1.84,4.1,1.32>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.13> 
  rotate <0,30,0>
}

#declare Sarsen04 = object { 
  makeStone("sarsen04F.jpg","sarsen04B.jpg") 
  scale <1.97,4.1,0.92>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.26> 
  rotate <0,42,0>
}

#declare Sarsen05 = object { 
  makeStone("sarsen05F.jpg","sarsen05B.jpg") 
  scale <1.58,4.1,1.05>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.26> 
  rotate <0,54,0>
}

#declare Sarsen06 = object { 
  makeStone("sarsen06F.jpg","sarsen06B.jpg") 
  scale <2.11,4.1,1.05>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.13> 
  rotate <0,66,0>
}

#declare Sarsen07 = object { 
  makeStone("sarsen06F.jpg","sarsen06B.jpg") 
  scale <1.97,4.1,1.05>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.13> 
  rotate <0,78,0>
}

#declare Sarsen10 = object { 
  makeStone("sarsen06F.jpg","sarsen06B.jpg") 
  scale <2.5,4.1,1.05>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.00> 
  rotate <0,114,0>
}

#declare Sarsen11 = object { 
  makeStone("sarsen06F.jpg","sarsen06B.jpg") 
  scale <1.18,4.1,0.66>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.26> 
  rotate <0,126,0>
}

#declare Sarsen16 = object { 
  makeStone("sarsen06F.jpg","sarsen06B.jpg") 
  scale <2.11,4.1,1.71>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.00> 
  rotate <0,186,0>
}

#declare Sarsen21 = object { 
  makeStone("sarsen04F.jpg","sarsen04B.jpg") 
  scale <1.58,4.1,1.32>
  texture { SarsenTexture }
  rotate <0,20,0> 
  translate <0,0,-15.13> 
  rotate <0,246,0>
}

#declare Sarsen22 = object { 
  makeStone("sarsen22F.jpg","sarsen22B.jpg") 
  scale <1.84,4.3,1.05>
  texture { SarsenTexture }
  rotate <0,30,0> 
  translate <0,-0.2,-14.87> 
  rotate <0,258,0>
}

#declare Sarsen23 = object { 
  makeStone("sarsen23F.jpg","sarsen23B.jpg") 
  scale <2.11,4.1,0.79>
  texture { SarsenTexture }
  rotate <0,10,5> 
  translate <0,0,-15.39> 
  rotate <0,270,0>
}

#declare Sarsen25 = object { 
  makeFallenStone("sarsen25F.jpg") 
  scale <2.24,1.1,4.4>
  texture { SarsenTexture }
  rotate <0,0,3> 
  rotate <0,-110,0> 
  translate <0,-0.3,-15.53> 
  rotate <0,290,0>
}

#declare Sarsen26 = object { 
  makeFallenStone("sarsen26F.jpg") 
  scale <2.24,0.8,4.1>
  texture { SarsenTexture }
  rotate <-2,0,-3> 
  rotate <0,-90,0> 
  translate <0,-0.3,-15.83> 
  rotate <0,306,0>
}

#declare Sarsen27 = object { 
  makeStone("sarsen27F.jpg","sarsen27B.jpg") 
  scale <2.24,4.1,1.18>
  texture { SarsenTexture }
  rotate <0,5,0> 
  translate <0,0,-15.13> 
  rotate <0,318,0>
}

#declare Sarsen28 = object { 
  makeStone("sarsen28F.jpg","sarsen28B.jpg") 
  scale <2.24,4.1,1.32>
  texture { SarsenTexture }
  rotate <0,10,20> 
  translate <0,0,-14.80> 
  rotate <0,330,0>
}

#declare Sarsen29 = object { 
  makeStone("sarsen06F.jpg","sarsen06B.jpg") 
  scale <2.11,4.1,1.18>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.13> 
  rotate <0,342,0>
}

#declare Sarsen30 = object { 
  makeStone("sarsen06F.jpg","sarsen06B.jpg") 
  scale <2.5,4.1,1.32>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-15.13> 
  rotate <0,354,0>
}

#declare SarsenLintel01 = object { 
  makeStone("sarsenLintel01F.jpg","sarsenLintel01B.jpg") 
  translate <-0.5,0.0,0.0>
  scale <3.29,0.80,1.0>
  texture { SarsenTexture }
  rotate <0,5,0> 
  translate <0,4.1,-15.13> 
  rotate <0,6,0>
}

#declare SarsenLintel04 = object { 
  makeStone("sarsenLintel01F.jpg","sarsenLintel01B.jpg") 
  translate <-0.5,0.0,0.0>
  scale <3.29,0.80,1.0>
  texture { SarsenTexture }
  rotate <0,5,0> 
  translate <0,4.05,-15.26> 
  rotate <0,42,0>
}

#declare SarsenLintel06 = object { 
  makeStone("sarsenLintel01F.jpg","sarsenLintel01B.jpg") 
  translate <-0.5,0.0,0.0>
  scale <3.29,0.80,1.0>
  texture { SarsenTexture }
  rotate <0,5,0> 
  translate <0,4.1,-15.13> 
  rotate <0,66,0>
}

#declare SarsenLintel21 = object { 
  makeStone("sarsenLintel01F.jpg","sarsenLintel01B.jpg") 
  translate <-0.5,0.0,0.0>
  scale <4.29,0.80,1.0>
  texture { SarsenTexture }
  rotate <0,5,0> 
  translate <0.7,4.05,-14.86> 
  rotate <0,246,0>
}

#declare SarsenLintel29 = object { 
  makeStone("sarsenLintel01F.jpg","sarsenLintel01B.jpg") 
  translate <-0.5,0.0,0.0>
  scale <3.29,0.80,1.0>
  texture { SarsenTexture }
  rotate <0,5,0> 
  translate <0,4.1,-15.00> 
  rotate <0,342,0>
}

#declare SarsenLintel30 = object { 
  makeStone("sarsenLintel01F.jpg","sarsenLintel01B.jpg") 
  translate <-0.5,0.0,0.0>
  scale <3.29,0.80,1.0>
  texture { SarsenTexture }
  rotate <0,5,0> 
  translate <0,4.1,-15.13> 
  rotate <0,354,0>
}

#declare Orthostat51 = object { 
  makeStone("sarsen51F.jpg","sarsen51B.jpg") 
  scale <2.93,6.1,1.32>
  texture { SarsenTexture }
  rotate <0,-90,0> 
  translate <-8.42,0,-5> 
  rotate <0,0,0>
}

#declare Orthostat52 = object { 
  makeStone("sarsen52F.jpg","sarsen52B.jpg") 
  scale <2.96,6.1,1.58>
  texture { SarsenTexture }
  rotate <0,-90,0> 
  translate <-8.42,0,-2.37> 
  rotate <0,0,0>
}

#declare Orthostat53 = object { 
  makeStone("sarsen51F.jpg","sarsen51B.jpg") 
  scale <2.91,6.8,1.32>
  texture { SarsenTexture }
  rotate <0,180,0> 
  translate <0,0,-8.42> 
  rotate <0,114,0>
}

#declare Orthostat54 = object { 
  makeStone("sarsen52F.jpg","sarsen52B.jpg") 
  scale <3.07,6.8,1.84>
  texture { SarsenTexture }
  rotate <0,180,0> 
  translate <0,0,-8.42> 
  rotate <0,131,0>
}

#declare Orthostat56 = object { 
  makeStone("sarsen06F.jpg","sarsen06B.jpg") 
  scale <2.84,7.3,1.05>
  texture { SarsenTexture }
  rotate <0,0,0> 
  translate <0,0,-8.42> 
  rotate <0,190,0>
}

#declare Orthostat57 = object { 
  makeStone("sarsen06F.jpg","sarsen06B.jpg") 
  scale <3.27,6.7,1.05>
  texture { SarsenTexture }
  rotate <0,15,0> 
  translate <0.1,0,-8.92> 
  rotate <0,228,0>
}

#declare Orthostat58 = object { 
  makeStone("sarsen58F.jpg","sarsen58B.jpg") 
  scale <3.14,6.7,1.32>
  texture { SarsenTexture }
  rotate <0,15,0> 
  translate <0,0,-8.42> 
  rotate <0,246,0>
}

#declare Orthostat59 = object { 
  makeStone("sarsen59F.jpg","sarsen59B.jpg") 
  scale <2.89,6.1,1.58>
  texture { SarsenTexture }
  rotate <0,270,0>
  rotate <0,0,80>
  translate <8.42,0.00,-0.84> 
  rotate <0,0,0>
}

#declare Orthostat60 = object { 
  makeStone("sarsen60F.jpg","sarsen60B.jpg") 
  scale <3.11,6.1,1.45>
  texture { SarsenTexture }
  rotate <0,285,0> 
  translate <8.42,0,-5> 
  rotate <0,0,0>
}

#declare TrilithonLintel51 = object { 
  makeStone("sarsenLintel01F.jpg","sarsenLintel01B.jpg") 
  translate <0.5,0.0,0.0>
  scale <5.39,1,1.32>
  texture { SarsenTexture }
  rotate <0,-90,0> 
  translate <-8.42,6.0,-6.315> 
  rotate <0,0,0>
}

#declare TrilithonLintel53 = object { 
  makeStone("sarsenLintel01F.jpg","sarsenLintel01B.jpg") 
  translate <0.5,0.0,0.0>
  scale <4.61,1,1.32>
  texture { SarsenTexture }
  rotate <0,10,0> 
  translate <-3.555,6.55,-7.76> 
  rotate <0,114,0>
}

#declare TrilithonLintel57 = object { 
  makeStone("sarsenLintel57F.jpg","sarsenLintel57B.jpg") 
  translate <0.5,0.0,0.0>
  scale <5.14,1,1.25>
  texture { SarsenTexture }
  rotate <0,15,0> 
  translate <-3.955,6.55,-7.895> 
  rotate <0,228,0>
}

#declare AltarStone = object { 
  makeFallenStone("sarsen25F.jpg") 
  scale <4.47,1.1,4.0>
  texture { SarsenTexture }
  rotate <0,-10,0> 
  translate <0,-0.2,2.63> 
  rotate <0,0,0>
}

#declare Bluestone31 = object { makeStone("sarsen06F.jpg","sarsen06B.jpg") scale <1.05,2.1,0.39> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,6,0> }
#declare Bluestone33 = object { makeStone("sarsen01F.jpg","sarsen01B.jpg") scale <0.53,1.7,0.39> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,66,0> }
#declare Bluestone34 = object { makeStone("sarsen06F.jpg","sarsen06B.jpg") scale <0.66,1.7,0.79> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,104,0> }
#declare Bluestone35 = object { makeStone("sarsen01F.jpg","sarsen01B.jpg") scale <0.26,1.0,0.26> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,108,0> }
#declare Bluestone37 = object { makeStone("sarsen06F.jpg","sarsen06B.jpg") scale <1.05,2.0,0.39> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,144,0> }
#declare Bluestone38 = object { makeStone("sarsen01F.jpg","sarsen01B.jpg") scale <0.92,2.0,0.53> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,154,0> }
#declare Bluestone39 = object { makeStone("sarsen06F.jpg","sarsen06B.jpg") scale <0.39,1.0,0.53> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,163,0> }
#declare Bluestone46 = object { makeStone("sarsen01F.jpg","sarsen01B.jpg") scale <0.66,2.0,0.26> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,329,0> }
#declare Bluestone47 = object { makeStone("sarsen06F.jpg","sarsen06B.jpg") scale <0.79,2.0,0.39> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,336,0> }
#declare Bluestone49 = object { makeStone("sarsen01F.jpg","sarsen01B.jpg") scale <0.79,1.9,0.39> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-11.71> rotate <0,354,0> }

#declare Bluestone61 = object { makeStone("sarsen06F.jpg","sarsen06B.jpg") scale <1.19,2.1,0.53> texture { SarsenTexture } rotate <0,-90,0> rotate <-5,0,0> translate <-5.79,0,-5.26> rotate <0,0,0> }
#declare Bluestone62 = object { makeStone("sarsen01F.jpg","sarsen01B.jpg") scale <0.53,1.9,0.53> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-5.79> rotate <0,84,0> }
#declare Bluestone63 = object { makeStone("sarsen06F.jpg","sarsen06B.jpg") scale <0.79,2.0,0.53> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-5.79> rotate <0,94,0> }
#declare Bluestone64 = object { makeStone("sarsen01F.jpg","sarsen01B.jpg") scale <0.26,1.6,0.26> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-5.79> rotate <0,132,0> }
#declare Bluestone65 = object { makeStone("sarsen06F.jpg","sarsen06B.jpg") scale <0.79,2.1,0.26> texture { SarsenTexture } rotate <0,0,0>  rotate <-3,0,0> translate <0,0,-5.79> rotate <0,150,0> }
#declare Bluestone68 = object { makeStone("sarsen01F.jpg","sarsen01B.jpg") scale <0.79,1.7,0.79> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-5.79> rotate <0,200,0> }
#declare Bluestone69 = object { makeStone("sarsen06F.jpg","sarsen06B.jpg") scale <0.66,2.0,0.66> texture { SarsenTexture } rotate <0,0,0> translate <0,0,-5.79> rotate <0,228,0> }
#declare Bluestone70 = object { makeStone("sarsen01F.jpg","sarsen01B.jpg") scale <0.79,2.1,0.53> texture { SarsenTexture } rotate <0,0,0>  rotate <0,0,10> translate <0,0,-5.79> rotate <0,246,0> }


// ===== Build main objects ====

#declare Megaliths = union {
  object { Sarsen01 }
  object { Sarsen02 }
  object { Sarsen03 }
  object { Sarsen04 }
  object { Sarsen05 }
  object { Sarsen06 }
  object { Sarsen07 }
  object { Sarsen10 }
  object { Sarsen11 }
  object { Sarsen16 }
  object { Sarsen21 }
  object { Sarsen22 }
  object { Sarsen23 }
  object { Sarsen25 }
  object { Sarsen26 }
  object { Sarsen27 }
  object { Sarsen28 }
  object { Sarsen29 }
  object { Sarsen30 }

  object { SarsenLintel01 } 
  object { SarsenLintel04 }
  object { SarsenLintel06 }
  object { SarsenLintel21 }
  object { SarsenLintel29 }
  object { SarsenLintel30 }

  object { Orthostat51 }
  object { Orthostat52 }
  object { Orthostat53 }
  object { Orthostat54 }
  object { Orthostat56 }
  object { Orthostat57 }
  object { Orthostat58 }
  object { Orthostat59 }
  object { Orthostat60 }

  object { TrilithonLintel51 }
  object { TrilithonLintel53 }
  object { TrilithonLintel57 }

  object { AltarStone }

  object { Bluestone31 }
  object { Bluestone33 }
  object { Bluestone34 }
  object { Bluestone35 }
  object { Bluestone37 }
  object { Bluestone38 }
  object { Bluestone39 }
  object { Bluestone46 }
  object { Bluestone47 }
  object { Bluestone49 }
  object { Bluestone61 }
  object { Bluestone62 }
  object { Bluestone63 }
  object { Bluestone64 }
  object { Bluestone65 }
  object { Bluestone68 }
  object { Bluestone69 }
  object { Bluestone70 }
}
