// Persistence Of Vision raytracer version 3.0 file.
// by Simon Smith

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"

#declare starx = 0.0
#declare stary = 0.0
#declare starz = 0.0

#declare starr = 0.8
#declare starg = 0.8
#declare starb = 0.67

#declare camerax = starx-0.5
#declare cameray = stary-0.5
#declare cameraz = starz-12.0


camera {
   location <camerax, cameray, cameraz>
   direction <0.0, 0.0, 1.67>
   up <0.2, 0.9, 0.0>
   right <4/3, 0.0, 0.0>
   look_at <starx+0.05, stary+0.05, starz> }

// A light source isn't really needed in this scene, but PoVRay whinges without it

// The star //////////

light_source { <starx, stary, starz>
   rgb <starr, starg, starb>
   shadowless
   looks_like {
      sphere { <starx, stary, starz> 0.1
      texture {
         pigment {
            wood
            scale <1.67, 2.5, 2>
            color_map {
               [0.00, 0.10 color rgbt <1.00, 0.90, 0.90, 0.00> color rgbt <1.00, 0.90, 0.80, 0.00> ]
               [0.10, 0.12 color rgbt <1.00, 0.80, 0.80, 0.00> color rgbt <1.00, 0.90, 0.25, 0.00> ]
               [0.12, 0.14 color rgbt <1.00, 0.90, 0.25, 0.00> color rgbt <0.90, 0.67, 0.15, 0.00> ]
               [0.14, 0.26 color rgbt <0.90, 0.67, 0.15, 0.00> color rgbt <0.90, 0.25, 0.00, 0.00> ]
               [0.26, 0.40 color rgbt <0.90, 0.25, 0.00, 0.00> color rgbt <0.75, 1.00, 0.00, 1.00> ]
               [0.40, 1.00 color rgbt <0.75, 1.00, 0.00, 1.00> color rgbt <0.75, 1.00, 0.00, 0.75> ]
            }
         }
         finish {
            ambient 0.9
         }
      }
      }
   }
}

// As is common for astronomical images, we use 'false colour' to highlight the different features.
// I've based these colours on the ones used in the Cat's Eye Nebula

#declare inner = texture {
    pigment {
      bozo
      turbulence 0.70
      octaves 3
      scale <0.33, 0.50, 0.33>
      color_map {
         [0.00, 0.12 color rgbt <0.80, 0.70, 0.15, 0.85> color rgbt <0.80, 0.70, 0.15, 0.80> ]
         [0.12, 0.24 color rgbt <0.80, 0.70, 0.15, 0.80> color rgbt <0.80, 0.60, 0.20, 0.75> ]
         [0.24, 0.48 color rgbt <0.80, 0.60, 0.20, 0.75> color rgbt <0.80, 0.70, 0.20, 0.55> ]
         [0.48, 0.50 color rgbt <0.80, 0.70, 0.20, 0.55> color rgbt <0.80, 0.65, 0.15, 0.35> ]
         [0.50, 0.52 color rgbt <0.80, 0.70, 0.20, 0.35> color rgbt <0.80, 0.65, 0.15, 0.55> ]
         [0.52, 0.76 color rgbt <0.80, 0.60, 0.20, 0.55> color rgbt <0.80, 0.70, 0.20, 0.75> ]
         [0.76, 0.88 color rgbt <0.80, 0.70, 0.15, 0.75> color rgbt <0.80, 0.60, 0.20, 0.80> ]
         [0.88, 1.00 color rgbt <0.80, 0.70, 0.15, 0.80> color rgbt <0.80, 0.70, 0.15, 0.85> ]
      }
   }
   finish { ambient 0.9 }
}

#declare middle = texture {
    pigment {
      bozo
      turbulence 0.65
      octaves 3
      scale <0.50, 1.75, 0.50>
      color_map {
         [0.00, 0.12 color rgbt <0.25, 0.40, 0.00, 0.90> color rgbt <0.30, 0.45, 0.00, 0.85> ]
         [0.12, 0.24 color rgbt <0.30, 0.45, 0.00, 0.85> color rgbt <0.30, 0.50, 0.00, 0.80> ]
         [0.24, 0.48 color rgbt <0.30, 0.50, 0.00, 0.80> color rgbt <0.35, 0.55, 0.00, 0.70> ]
         [0.48, 0.50 color rgbt <0.35, 0.55, 0.00, 0.70> color rgbt <0.35, 0.55, 0.00, 0.50> ]
         [0.50, 0.52 color rgbt <0.35, 0.65, 0.00, 0.50> color rgbt <0.35, 0.55, 0.00, 0.70> ]
         [0.52, 0.76 color rgbt <0.35, 0.55, 0.00, 0.70> color rgbt <0.30, 0.50, 0.00, 0.80> ]
         [0.76, 0.88 color rgbt <0.30, 0.50, 0.00, 0.80> color rgbt <0.30, 0.45, 0.00, 0.85> ]
         [0.88, 1.00 color rgbt <0.30, 0.45, 0.00, 0.85> color rgbt <0.25, 0.40, 0.00, 0.90> ]
      }
   }
   finish { ambient 0.9 }
}

#declare outer = texture {
    pigment {
      bozo
      turbulence 0.67
      octaves 4
      scale <0.33, 1.50, 0.33>
      color_map {
         [0.00, 0.20 color rgbt <0.70, 0.25, 0.25, 0.85> color rgbt <0.70, 0.25, 0.25, 0.80> ]
         [0.20, 0.45 color rgbt <0.70, 0.20, 0.20, 0.80> color rgbt <0.70, 0.25, 0.25, 0.65> ]
         [0.45, 0.50 color rgbt <0.70, 0.20, 0.20, 0.65> color rgbt <0.70, 0.25, 0.25, 0.40> ]
         [0.50, 0.55 color rgbt <0.70, 0.20, 0.20, 0.40> color rgbt <0.70, 0.25, 0.25, 0.65> ]
         [0.55, 0.80 color rgbt <0.70, 0.20, 0.20, 0.65> color rgbt <0.70, 0.25, 0.25, 0.80> ]
         [0.80, 1.00 color rgbt <0.70, 0.25, 0.25, 0.80> color rgbt <0.70, 0.25, 0.25, 0.85> ]
      }
   }
   finish { ambient 0.9 }
}

// The starlight should be bright enough to 'burn through' the thin shell of pigment
// between the star and the viewpoint. We fudge this by making the nebula textures
// more transparent near the star using a texturemap. Then we fill in the 'hole'
// with much brighter colours for the star itself. This could have been done with either
// the 'wood' or 'onion' textures. I wanted to choose 'onion' as it looks the same from
// all directions. Wood is easier, in some ways, but if I move the viewpoint I'd have to
// realign it with the camera.

#declare burn = texture {
   pigment {
      onion
      scale <10.5, 11.5, 10.0>
      color_map {
         [0.00, 0.05 color rgbt <0.0, 0.0, 0.0, 1.0> color rgbt <0.0, 0.0, 0.0, 1.0> ]
         [0.05, 1.00 color rgbt <0.6, 0.8, 0.2, 1.0> color rgbt <0.8, 1.0, 0.0, 0.75> ]
      }
   }
   finish {
      ambient 0.9
   }
}

#declare fade = texture {
   pigment {
      color rgbt <0.0, 0.0, 0.0, 1.0>
   }
   finish {
      ambient 0.9
   }
}

// The nebula shell textures //////////

#declare inner_shell = texture {
   wood
   scale <9.0, 2.5, 3.0>
   texture_map {
      [0.00 burn scale <1, 1, 10> ]
      [0.20 inner scale 0.2 ]
      [0.60 inner scale 0.2 ]
      [0.80 middle scale 0.5 ]
      [1.00 fade ]
   }
}

#declare ring_shell = texture {
   wood
   scale <9.0, 2.5, 3.0>
   texture_map {
      [0.00 burn scale <1, 1, 10> ]
      [0.10 burn scale 0.5 ]
      [0.20 inner scale 0.2 ]
      [0.60 inner scale 0.2 ]
      [0.80 middle scale 0.5 ]
      [1.00 fade ]
   }
}

#declare middle_shell = texture {
   wood
   scale <12.0, 15.0, 15.0>
   texture_map {
      [0.00 burn scale <1, 1, 10> ]
      [0.10 burn scale 0.5 ]
      [0.20 fade ]
      [0.40 inner scale 0.5 ]
      [0.70 middle scale 0.2 ]
      [0.80 middle scale 0.2 ]
      [1.00 fade ]
   }
}

#declare outer_shell = texture {
   wood
   scale <10, 3.5, 4>
   texture_map {
      [0.00 burn scale <1, 1, 10> ]
      [0.10 burn scale 0.5 ]
      [0.20 fade ]
      [0.30 fade ]
      [0.50 middle scale 0.2 ]
      [0.60 outer scale 0.2 ]
      [0.90 outer scale 0.2 ]
      [1.00 fade ]
   }
}

// The nebula shell shapes //////////

#declare blob1 = object {

   blob {
       threshold 0.1

       sphere { <0, 0, 0>, 1, strength 0.5 scale <3.4, 2.1, 1.9> }

       sphere { <3, 0.1,-0.1>, 0.75, strength 0.68 }
       sphere { <-3, 0.0, 0.0>, 0.62, strength 0.23 }

       sphere { <3.4, 0.41, 0.40>, 0.5, strength 0.11 }
       sphere { <3.3, 0.40, -0.39>, 0.5, strength 0.11 }
       sphere { <3.4, -0.42, 0.41>, 0.5, strength 0.09 }
       sphere { <3.3, -0.40, -0.39>, 0.5, strength 0.10 }

       sphere { <3.4, 0.52, 0.2>, 0.51, strength 0.10 }
       sphere { <3.4, -0.1, 0.51>, 0.48, strength 0.11 }
       sphere { <3.2, -0.49, 0.1>, 0.52, strength 0.10 }
       sphere { <3.3, 0.1, -0.50>, 0.48, strength 0.09 }

       cylinder { <-4, 0.1, 1.78> <4, 0, 1.8>, 0.55, strength 0.06 }
       cylinder { <-4,-0.2, -1.8> <4, 0, -1.7>, 0.5, strength 0.04 }
       cylinder { <-4, 1.76, 0.2> <4, 1.8, -0.2>, 0.45, strength 0.05 }
       cylinder { <-4, -1.7, 0.1> <4, -1.76, 0>, 0.45, strength 0.07 }

       cylinder { <3.2, 0.7, 0.78> <0.2, 1.4, 1.3>, 0.52, strength -0.15 }
       cylinder { <3, 0.7, -0.76> <0.1, 1.5, -1.6>, 0.55, strength -0.13 }
       cylinder { <2.5, -0.76, 0.85> <-0.5, -1.4, 1.7>, 0.51, strength 0.04 }
       cylinder { <3, -0.76, -0.78> <0.2, -1.5, -1.6>, 0.6, strength -0.14 }

       cylinder { <-3, 0.78, 0.72> <0.1, 1.7, 1.3>, 0.52, strength -0.13 }
       cylinder { <-3.2, 0.79, -0.79> <0, 1.7, -1.5>, 0.51, strength 0.04 }
       cylinder { <-3.5, -0.85, 0.76> <-0.2, -1.5, 1.4>, 0.47, strength -0.17 }
       cylinder { <-3, -0.77, -0.72> <0, -1.4, -1.5>, 0.49, strength -0.16 }

   }
   sturm
}

#declare blob2 = object {

   blob {
       threshold 0.1

       sphere { <0, 0, 0>, 1, strength 0.5 scale <3.6, 3.1, 2.9> }

       sphere { <3, 0.0, 0.2>, 0.75, strength 0.68 }
       sphere { <-3, 0.2, -0.2>, 0.72, strength 0.77 }

       cylinder { <-4, 0.2, 1.78> <4, 0, 1.9>, 0.58, strength 0.06 }
       cylinder { <-4,-0.1, -1.8> <4, 0, -1.6>, 0.52, strength 0.04 }
       cylinder { <-4, 1.74, 0.2> <4, 1.7, -0.2>, 0.45, strength 0.05 }
       cylinder { <-4, -1.6, 0.1> <4, -1.8, 0>, 0.45, strength 0.07 }

       cylinder { <3.2, 0.73, 0.78> <0.2, 1.5, 1.3>, 0.53, strength 0.05 }
       cylinder { <3, 0.76, -0.76> <0.1, 1.5, -1.5>, 0.54, strength -0.13 }
       cylinder { <2.5, -0.72, 0.85> <-0.5, -1.3, 1.7>, 0.53, strength 0.04 }
       cylinder { <3, -0.73, -0.78> <0.2, -1.8, -1.4>, 0.49, strength -0.15 }

       cylinder { <-3, 0.76, 0.77> <0.2, 1.8, 1.3>, 0.57, strength -0.12 }
       cylinder { <-3.3, 0.73, -0.77> <-0.2, 1.8, -1.2>, 0.46, strength -0.12 }
       cylinder { <-3.1, -0.82, 0.77> <0.2, -1.4, 1.3>, 0.53, strength 0.06 }
       cylinder { <-3.2, -0.72, -0.74> <0.1 -1.3, -1.7>, 0.45, strength -0.17 }

   }
   sturm
}

#declare shell1a = object { blob1
    scale <0.8, 0.4, 0.45> 
      translate <starx, stary, starz>
}

#declare shell1b = object { shell1a scale <-1.02, 0.99, 1.01> rotate <1, 2, -2> }

#declare ring = object {

   blob {
       threshold 0.1

       sphere { < 0.2, 0.0, 1.20>, 0.37, strength 0.15 rotate <  0, 1, 0> }
       sphere { < 0.0, 0.2, 1.28>, 0.36, strength 0.16 rotate < 14, 0, 0> }
       sphere { < 0.0, 0.0, 1.15>, 0.37, strength 0.17 rotate < 30, 0, 0> }
       sphere { < 0.2, 0.0, 1.22>, 0.34, strength 0.16 rotate < 45, 0, 1> }
       sphere { < 0.0, 0.0, 1.20>, 0.35, strength 0.15 rotate < 62, 0, 0> }
       sphere { < 0.1, 0.0, 1.20>, 0.36, strength 0.16 rotate < 75,-1, 0> }
       sphere { < 0.0, 0.0, 1.26>, 0.37, strength 0.16 rotate < 90, 0, 0> }
       sphere { < 0.0, 0.0, 1.15>, 0.34, strength 0.17 rotate <104, 0, 1> }
       sphere { < 0.1, 0.0, 1.24>, 0.35, strength 0.16 rotate <120, 0, 0> }
       sphere { < 0.1,-0.1, 1.21>, 0.37, strength 0.16 rotate <136, 1, 0> }
       sphere { < 0.1, 0.0, 1.20>, 0.34, strength 0.16 rotate <150, 1, 0> }
       sphere { < 0.2, 0.0, 1.15>, 0.37, strength 0.15 rotate <165, 0, 0> }
       sphere { < 0.0, 0.1, 1.20>, 0.35, strength 0.16 rotate <181, 0, 1> }
       sphere { < 0.0, 0.2, 1.25>, 0.36, strength 0.17 rotate <195, 0, 0> }
       sphere { < 0.0, 0.1, 1.20>, 0.34, strength 0.16 rotate <210, 0, 0> }
       sphere { <-0.1, 0.0, 1.20>, 0.36, strength 0.16 rotate <224,-1, 0> }
       sphere { < 0.0, 0.0, 1.20>, 0.35, strength 0.16 rotate <240, 0, 0> }
       sphere { <-0.1, 0.0, 1.23>, 0.36, strength 0.16 rotate <255, 0, 0> }
       sphere { < 0.0, 0.1, 1.27>, 0.37, strength 0.17 rotate <270, 0, 2> }
       sphere { < 0.0, 0.0, 1.20>, 0.36, strength 0.16 rotate <284, 0, 0> }
       sphere { < 0.1, 0.0, 1.20>, 0.35, strength 0.16 rotate <300,-1, 0> }
       sphere { < 0.0,-0.1, 1.18>, 0.37, strength 0.15 rotate <316, 0, 1> }
       sphere { < 0.0, 0.2, 1.25>, 0.38, strength 0.16 rotate <331,-1, 0> }
       sphere { < 0.0, 0.1, 1.25>, 0.35, strength 0.16 rotate <345, 0, 0> }
       }
   rotate <0.0, 0.0, 90.0>
   translate <starx, stary, starz>
   rotate <0.0, 1.0, 88.0>
   rotate <0.0, 5.0, 0.0>
   sturm
}

#declare shell2 = object {
   merge {
     object { blob2 translate <0.89, 0.01, 0.01> }
     object { blob2 translate <-0.9, -0.01, -0.01> }
   }
}

// The scene //////////

object { shell1a translate <0.9, 0.0, 0.01> texture { inner_shell rotate <1, 0, 1> } }
object { shell1b translate <-0.91, -0.02, 0.0> texture { inner_shell rotate <0, 2, -1> } }
object { ring translate <-0.03, -0.03, 0.02> texture { ring_shell scale <0.75, 0.75, 12> rotate <1, 2, 91> } }
object { shell2 scale <1.00, 0.55, 0.55> rotate <1, 2, 2> texture { outer_shell rotate <-2, 12, 10> } }

// End of file //////////