#declare UnitsPMM = 19.64/800; // based on shoulder height of roe deer @ 800mm

union {
    #declare T_Road_Rough = 
    texture {
        pigment {
            crackle
            color_map {
                [0 rgb 0.1]
                [1 rgb 0.2]
            }
        }
        normal {
            crackle 0.2
            bump_size 1
        }
        finish {
            ambient 0
            diffuse 1
        }
        scale 10*UnitsPMM
    }
    #declare T_Road_Smooth = 
    texture {
        pigment {
            crackle
            color_map {
                [0 rgb 0.05]
                [1 rgb 0.15]
            }
        }
        normal {
            crackle 0.2
            bump_size 0.75
        }
        finish {
            ambient 0
            diffuse 1
        }
        scale 10*UnitsPMM
    }
    box {
        <-2700*UnitsPMM,0,-100>,<2700*UnitsPMM,-1,100>
        // add worn lines down the length of the road
        texture {
            gradient x
            texture_map {
                [0.14 T_Road_Rough scale 1/(2700*UnitsPMM)]
                [0.18 T_Road_Smooth scale 1/(2700*UnitsPMM)]
                [0.29 T_Road_Smooth scale 1/(2700*UnitsPMM)]
                [0.41 T_Road_Rough scale 1/(2700*UnitsPMM)]
                [0.59 T_Road_Rough scale 1/(2700*UnitsPMM)]
                [0.73 T_Road_Smooth scale 1/(2700*UnitsPMM)]
                [0.84 T_Road_Smooth scale 1/(2700*UnitsPMM)]
                [0.88 T_Road_Rough scale 1/(2700*UnitsPMM)]
            }
            turbulence 0.05
            scale 2700*UnitsPMM
        }
    }
    
    #declare T_White_Line =
    texture {
        pigment {
            granite
            color_map {
                [0 rgb 0.8]
                [1 rgb 0.9]
            }
        }
        normal {
            granite 0.5
            bump_size 0.5
            scale 20
        }
        finish {
            ambient 0
            diffuse 1
        }
        scale 2*UnitsPMM
    }
    object {
        #include "White_Line.pov"
        scale <1,0.1,1>
        translate <0,0,20>
    }
    
    #declare T_Kerb_Granite = 
    texture {
        pigment {
            granite
            color_map {
                [0 rgb <73,74,79>/255]
                [1 rgb <174,175,180>/255]
            }
        }
        normal {
            granite 0.2
            bump_size 0.2
        }
        finish {
            ambient 0
            diffuse 1
        }
        scale 3*UnitsPMM
    }
    
    #declare O_Kerb_Stone = object { #include "Kerb_Stone.pov" }
    
    #declare position = -100;
    #declare shift_seed = seed(436238176);
    #while(position < 100)
        object {
            O_Kerb_Stone
            scale 0.5
            translate <-2775*UnitsPMM+rand(shift_seed)*0.25,rand(shift_seed)*0.25,position+rand(shift_seed)*0.125>
        }
        #declare position = position+20.25;
    #end
    
    #declare T_Pavement_Rough = 
    texture {
        pigment {
            crackle
            color_map {
                [0 rgb 0.2]
                [1 rgb 0.3]
            }
        }
        normal {
            crackle 0.2
            bump_size 1
        }
        finish {
            ambient 0
            diffuse 1
        }
        scale 12*UnitsPMM
    }
    box {
        <-2700*UnitsPMM-3,3.75,-100>,<-100-1250*UnitsPMM,-1,100>
        texture { T_Pavement_Rough }
    }
    translate <1250*UnitsPMM,0,0>
}

#declare T_Deer =
texture {
    pigment {
        granite
        color_map {
            [0 rgb <121,106,75>/255]
            [1 rgb <129,118,100>/255]
        }
    }
    finish {
        ambient 0.2
        diffuse 1
    }
}

#include "Deer_silhouette3.pov"


#if(FOG)
sphere {
    <0,0,0>,
    100
    hollow
    texture { 
        pigment {
            color rgbt 1
        }
        finish {
            ambient 0
            diffuse 0
        }
    }
    interior {
        media {
            method 3
            samples SAMPLE_MIN,SAMPLE_MAX
            intervals INTERVALS
            emission 0.001
            scattering { 5, 0.0015 eccentricity 0.55 }
        }
    }
}
#end

camera {
    location <0,20,-60>
    look_at <0,16,0>
}

light_source {
    <600*UnitsPMM,500*UnitsPMM,60>,
    rgb <1,1,0.7>*2
    spotlight
    point_at <0,0,-60>
    radius 10
    falloff 40
}

light_source {
    <-600*UnitsPMM,500*UnitsPMM,60>,
    rgb <1,1,0.7>*2
    spotlight
    point_at <-1200*UnitsPMM,0,-60>
    radius 10
    falloff 40
}