/*

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
}

background { color <0.749,0.890,1.000> }

camera {  //  Camera StdCam
  location  <     -6.768,     -10.951,       3.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.40735,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         65.50000    // Vertical      49.125
  look_at   <      0.263,       2.467,       5.000>
}


light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  photons {
  }
  translate  <-1000.0, -2000.0, 1000.0>
} 

*/

//
// ********  MATERIALS  *******
//

#include "medhouse5.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare LintelBeam1_1 = object {
  box { // LintelBeam1_1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.08, 5.0, 0.08>
    translate  <-1.9, 4.35, 2.82>
    material {
      DMFWood4HorBeams
      // Transform to world space
    }
  }
}
#declare CSG006 = difference {
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.24, 1.0, 1.0>
    translate  0.01*x
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    material {
      T_Wood7
    }
    photons {
      collect off
    }
    scale <0.6, 1.01, 0.3>
    rotate -60.0*y
    translate  <0.0, -0.01, 2.0>
  }
  photons {
    collect off
  }
}
#declare CSG005 = union {
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.25, 1.0, 1.0>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, -1.0>
    material {
      T_Wood7
    }
    photons {
      collect off
    }
    scale <0.05, 0.99, 0.1>
    translate  <0.01, 0.01, 2.0>
  }
  photons {
    collect off
  }
}
#declare Gable1 = difference {
  object { CSG005 }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    material {
      T_Wood7
    }
    photons {
      collect off
    }
    scale <0.6, 1.01, 0.3>
    rotate -60.0*y
    translate  <0.0, -0.01, 2.0>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    translate  <-0.99, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.151, 0.08, 0.375>
    translate  <0.0, -0.01, 0.05>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.2, 0.15>
    rotate -90.0*x
    translate  <-0.15, -0.01, 0.8>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.18, 0.08, 0.15>
    rotate 20.0*y
    translate  <0.0, -0.01, 0.8>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.2, 0.15>
    rotate -90.0*x
    translate  <0.0, -0.01, 1.2>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.23, 1.0, 0.905>
    translate  <0.01, 0.05, -0.01>
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.13, 1.0, 0.18>
    translate  <-0.09, 0.05, 1.599>
    material {
      T_Wood7
      // Transform to world space
      translate  <-2.0, -1.0, -6.1>
      rotate -90.0*z
    }
  }
  material {
    TopFloorPanelling
  }
  photons {
    collect off
  }
}
#declare CSG009 = difference {
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.24, 1.0, 1.0>
    translate  0.01*x
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    material {
      T_Wood7
    }
    photons {
      collect off
    }
    scale <0.6, 1.01, 0.3>
    rotate -60.0*y
    translate  <0.0, -0.01, 2.0>
  }
  photons {
    collect off
  }
}
#declare CSG008 = union {
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.25, 1.0, 1.0>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, -1.0>
    material {
      T_Wood7
    }
    photons {
      collect off
    }
    scale <0.05, 0.99, 0.1>
    translate  <0.01, 0.01, 2.0>
  }
  photons {
    collect off
  }
}
#declare Gable3 = difference {
  object { CSG008 }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    material {
      T_Wood7
    }
    photons {
      collect off
    }
    scale <0.6, 1.01, 0.3>
    rotate -60.0*y
    translate  <0.0, -0.01, 2.0>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    translate  <-0.99, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.151, 0.08, 0.375>
    translate  <0.0, -0.01, 0.05>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.2, 0.15>
    rotate -90.0*x
    translate  <-0.15, -0.01, 0.8>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.18, 0.08, 0.15>
    rotate 20.0*y
    translate  <0.0, -0.01, 0.8>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.2, 0.15>
    rotate -90.0*x
    translate  <0.0, -0.01, 1.2>
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.23, 1.0, 0.905>
    translate  <0.01, 0.05, -0.01>
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.13, 1.0, 0.18>
    translate  <-0.09, 0.05, 1.599>
    material {
      T_Wood7
      // Transform to world space
      translate  <2.0, -4.0, -6.1>
      rotate 90.0*z
    }
  }
  material {
    TopFloorPanelling
  }
  photons {
    collect off
  }
}
#declare LintelBeam2_1 = object {
  box { // LintelBeam2_1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    photons {
      collect off
    }
    scale <0.08, 5.2, 0.08>
    translate  <-1.9, 9.3, 2.82>
    material {
      DMFWood4HorBeams
      // Transform to world space
      translate  -2.95*z
    }
  }
}
#declare ShadeStrut1 = object {
  cylinder { // ShadeStrut1
    <0,0,1>, <0,0,0>, 1 
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.8>
    rotate 40.0*x
    translate  <-1.0, -1.0, 6.6>
  }
}
#declare Glass1 = difference {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.005, 0.48, 0.47>
    rotate -10.0*y
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    photons {
      collect off
    }
    scale <0.01, 0.1, 0.49>
    rotate <-10.0, -10.0, 0.0>
    translate  <0.0, 0.48, 0.01>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    photons {
      collect off
    }
    scale <0.01, 0.1, 0.49>
    rotate <10.0, -10.0, 0.0>
    translate  <0.0, -0.48, 0.01>
  }
  photons {
    collect off
  }
  translate  <-0.48, 0.0, -0.57>
}




//
// ********  OBJECTS  *******
//
/*

plane { // Plane001
  z,0
  material {
    NeutralGray
  }
  photons {
    collect off
  }
}

*/


#declare GroundFloor_Dif = difference {
  box { // GroundFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.95, 0.15, 1.5>
    translate  1.5*z
  }
  box { // GroundFloor_Door
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.45, 0.2, 1.2>
    translate  <-0.2, 0.0, 1.2>
  }
  box { // GroundFloor_Window1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.37, 0.2, 0.7>
    translate  <-1.2, 0.0, 1.0>
  }
  box { // GroundFloor_Window2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.37, 0.2, 0.7>
    translate  <1.2, 0.0, 1.0>
  }
  photons {
    collect off
  }
  material {
    White_Plaster
    // Transform to world space
  }
}
#declare DoorDif = difference {
  box { // Door
    <-1, -1, -1>, <1, 1, 1>
    rotate <-0.0, -0.0, 0.0>
    photons {
      collect off
    }
    scale <0.385, 0.03, 0.93>
    translate  1.035*z
  }
  box { // Door1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.04, 0.2>
    translate  1.5*z
  }
  material {
    WoodPanels2
  }
  photons {
    collect off
  }
}
#declare DoorHandle = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.04, 0.04, 0.15>
    translate  <0.3, 0.0, 0.7>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.008, 0.008, 0.15>
    rotate -90.0*x
    translate  <0.3, 0.0, 0.9>
  }
  sphere { // Sphere003
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.03, 0.01, 0.05>
    translate  <0.3, -0.08, 0.9>
  }
  sphere { // Sphere004
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.03, 0.01, 0.05>
    translate  <0.3, 0.08, 0.9>
  }
  photons {
    collect off
  }
  material {
    Brass_Metal
    // Transform to world space
    translate  <0.59246, 0.0, -0.0>
    rotate 20.0*z
    translate  -0.392456*x
    translate  -0.392456*x
  }
}
#declare DoorWindow = difference {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.21, 0.035, 0.21>
    translate  1.29*z
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.09, 0.0351, 0.09>
    translate  <-0.1, 0.0, 1.31>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.09, 0.0351, 0.09>
    translate  <-0.1, 0.0, 1.51>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.09, 0.0351, 0.09>
    translate  <0.1, 0.0, 1.31>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.09, 0.0351, 0.09>
    translate  <0.1, 0.0, 1.51>
  }
  photons {
    collect off
  }
  material {
    DMFWood6
    // Transform to world space
    translate  <0.59246, 0.0, -0.0>
    rotate 20.0*z
    translate  -0.392456*x
    translate  -0.392456*x
  }
}
#declare MainDoor = union {
  object { DoorDif }
  box { // MainDoor_WindowPane
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.25, 0.001, 0.22>
    translate  1.28*z
    material {
      WindowGlass
      // Transform to world space
      translate  <0.59246, 0.0, -0.0>
      rotate 20.0*z
      translate  -0.392456*x
      translate  -0.392456*x
    }
  }
  object { DoorHandle }
  object { DoorWindow }
  translate  0.392456*x
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -20.0*z
  translate  <-0.59246, 0.0, 0.0>
}
#declare Group_GroundFloorDoor = union {
  box { // GroundFloor_DoorSill
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.45, 0.2, 0.05>
    translate  <-0.2, 0.0, 0.05>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // GroundFloor_DoorVert1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.03, 0.1, 1.2>
    translate  <-0.62, 0.0, 1.2>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_DoorVert2
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.03, 0.1, 1.2>
    translate  <0.22, 0.0, 1.2>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_DoorUpper
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.45, 0.1, 0.03>
    translate  <-0.2, 0.0, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { MainDoor }
  box { // GroundFloor_DoorVert3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.185>
    translate  2.0*z
  }
  box { // GroundFloor_DoorVert4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.185>
    translate  <-0.2, 0.0, 2.0>
  }
  box { // GroundFloor_DoorVert5
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.185>
    translate  <-0.4, 0.0, 2.0>
  }
  box { // GroundFloor_DoorVert6
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.4, 0.01, 0.01>
    translate  <-0.2, 0.0, 2.2>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  photons {
    collect off
  }
}
#declare Window0_1_1 = union {
  box { // Win1Vert13
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.655>
    translate  <-1.4, -0.5, 1.06>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.54, 0.06, 0.0>
      rotate 32.035397*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert14
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.655>
    translate  <-1.06, -0.5, 1.06>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.54, 0.06, 0.0>
      rotate 32.035397*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor23
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.54, 0.06, 0.0>
      rotate 32.035397*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor24
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 1.06>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.54, 0.06, 0.0>
      rotate 32.035397*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor25
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.54, 0.06, 0.0>
      rotate 32.035397*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane7
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.163, 0.001, 0.64>
    translate  <-1.23, -0.5, 1.075>
    material {
      WindowGlass
      // Transform to world space
      translate  <1.54, 0.06, 0.0>
      rotate 32.035397*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor26
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 1.5>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.54, 0.06, 0.0>
      rotate 32.035397*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -32.035397*z
  translate  <-1.54, -0.06, 0.0>
}
#declare Window0_1_2 = union {
  box { // Win1Vert15
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.655>
    translate  <-1.38, -0.5, 1.06>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.86, 0.06, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert16
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.655>
    translate  <-1.04, -0.5, 1.06>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.86, 0.06, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor27
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.86, 0.06, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor28
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.86, 0.06, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor29
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 1.5>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.86, 0.06, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane8
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.163, 0.001, 0.64>
    translate  <-1.21, -0.5, 1.075>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.86, 0.06, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor30
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 1.06>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.86, 0.06, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <-0.86, -0.06, 0.0>
}
#declare Group_GroundFloor_Window1 = union {
  box { // Window1_Sill
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.35, 0.2, 0.03>
    translate  <-1.2, 0.0, 1.0>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // GroundFloor_Window1Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.7>
    translate  <-1.57, 0.0, 1.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_Window1Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.7>
    translate  <-0.83, 0.0, 1.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_Window1Upper
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.37, 0.1, 0.015>
    translate  <-1.2, 0.0, 2.4>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { Window0_1_1 }
  object { Window0_1_2 }
  photons {
    collect off
  }
}
#declare Window0_2_1 = union {
  box { // Win1Vert17
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.655>
    translate  <-1.4, -0.5, 1.06>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.86, 0.06, 0.0>
      rotate 25.016874*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert18
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.655>
    translate  <-1.06, -0.5, 1.06>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.86, 0.06, 0.0>
      rotate 25.016874*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor31
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.86, 0.06, 0.0>
      rotate 25.016874*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor32
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 1.06>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.86, 0.06, 0.0>
      rotate 25.016874*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor33
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.86, 0.06, 0.0>
      rotate 25.016874*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane9
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.163, 0.001, 0.64>
    translate  <-1.23, -0.5, 1.075>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.86, 0.06, 0.0>
      rotate 25.016874*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor34
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 1.5>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.86, 0.06, 0.0>
      rotate 25.016874*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -25.016874*z
  translate  <0.86, -0.06, 0.0>
}
#declare Window0_2_2 = union {
  box { // Win1Vert19
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.655>
    translate  <-1.38, -0.5, 1.06>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.54, 0.06, 0.0>
      rotate -52.403969*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert20
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.655>
    translate  <-1.04, -0.5, 1.06>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.54, 0.06, 0.0>
      rotate -52.403969*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor35
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 2.37>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.54, 0.06, 0.0>
      rotate -52.403969*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor36
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.54, 0.06, 0.0>
      rotate -52.403969*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor37
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 1.5>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.54, 0.06, 0.0>
      rotate -52.403969*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane10
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.163, 0.001, 0.64>
    translate  <-1.21, -0.5, 1.075>
    material {
      WindowGlass
      // Transform to world space
      translate  <-1.54, 0.06, 0.0>
      rotate -52.403969*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor38
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 1.06>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.54, 0.06, 0.0>
      rotate -52.403969*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate 52.403969*z
  translate  <1.54, -0.06, 0.0>
}
#declare Group_GroundFloor_Window2 = union {
  box { // Window2_Sill
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.35, 0.2, 0.03>
    translate  <1.2, 0.0, 1.0>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // GroundFloor_Window2Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.7>
    translate  <0.83, 0.0, 1.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_Window2Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.7>
    translate  <1.57, 0.0, 1.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_Window2Upper
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.358, 0.1, 0.015>
    translate  <1.2, 0.0, 2.4>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { Window0_2_1 }
  object { Window0_2_2 }
  photons {
    collect off
  }
}
#declare Group_GroundFloor_DoorAndWindows = union {
  object { Group_GroundFloorDoor }
  object { Group_GroundFloor_Window1 }
  object { Group_GroundFloor_Window2 }
  box { // GroundFloor_DoorWindowsHor1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.43, 0.05, 0.03>
    translate  <-0.2, 0.0, 2.0>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // GroundFloor_WindowPane3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.42, 0.001, 0.185>
    translate  <-0.2, 0.0, 2.0>
    material {
      WindowGlass
      // Transform to world space
    }
  }
  photons {
    collect off
  }
}
#declare BasementDif = difference {
  box { // Basement
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <1.99, 4.81, 0.65>
    translate  <0.0, 4.62, -1.0>
    material {
      BrickWall
      // Transform to world space
    }
  }
  box { // Basement1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <1.9, 4.67, 0.66>
    translate  <0.0, 4.62, -1.0>
    material {
      BrickWall
      // Transform to world space
    }
  }
  box { // Basement2
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.45, 0.2, 0.2>
    translate  <-0.2, 0.1, 0.0>
    material {
      BrickWall
      // Transform to world space
    }
  }
  photons {
    collect off
  }
}
#declare Group_GroundFloor = union {
  box { // GroundFloor_WestWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.03, 4.7, 1.5>
    translate  <-1.95, 4.7, 1.5>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  box { // GroundFloor_EastWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.03, 4.7, 1.5>
    translate  <1.95, 4.7, 1.5>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  object { GroundFloor_Dif }
  object { Group_GroundFloor_DoorAndWindows }
  box { // GroundFloor_VertStrut1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.1, 0.1, 1.5>
    translate  <-1.91, -0.1, 0.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_VertStrut2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.1, 0.1, 1.5>
    translate  <1.91, -0.1, 0.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // FloorBoards0
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <1.9, 4.65, 0.05>
    translate  -0.09*z
    material {
      WoodPanels2
      // Transform to world space
    }
  }
  object { BasementDif }
  photons {
    collect off
  }
}
#declare Window1_1 = union {
  box { // Win1Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.4, 0.65, 0.0>
      rotate 39.036903*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.4, 0.65, 0.0>
      rotate 39.036903*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.4, 0.65, 0.0>
      rotate 39.036903*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.4, 0.65, 0.0>
      rotate 39.036903*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.4, 0.65, 0.0>
      rotate 39.036903*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <1.4, 0.65, 0.0>
      rotate 39.036903*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -39.036903*z
  translate  <-1.4, -0.65, 0.0>
}
#declare Group_Window1 = union {
  box { // Floor1Sill1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.2, 0.2, 0.025>
    translate  <-1.22, -0.55, 3.95>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <-1.43, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <-1.01, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1Upper1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.21, 0.2, 0.015>
    translate  <-1.22, -0.5, 5.26>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { Window1_1 }
  photons {
    collect off
  }
}
#declare Window1_2_1 = union {
  box { // Win1Vert5
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      rotate 36.901627*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert6
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      rotate 36.901627*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor7
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      rotate 36.901627*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor8
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      rotate 36.901627*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor9
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      rotate 36.901627*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      rotate 36.901627*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor10
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.65, 0.0>
      rotate 36.901627*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -36.901627*z
  translate  <-0.75, -0.65, 0.0>
}
#declare Window1_2_2 = union {
  box { // Win1Vert7
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      rotate -18.018057*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert8
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      rotate -18.018057*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor11
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      rotate -18.018057*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor12
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      rotate -18.018057*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor13
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      rotate -18.018057*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      rotate -18.018057*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor14
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.65, 0.0>
      rotate -18.018057*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate 18.018057*z
  translate  <-0.05, -0.65, 0.0>
}
#declare Group_Window2 = union {
  box { // Floor1Sill2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.38, 0.2, 0.025>
    translate  <-0.38, -0.55, 3.95>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1Vert3
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <-0.78, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1Upper2
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.37, 0.2, 0.015>
    translate  <-0.38, -0.5, 5.26>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { Window1_2_1 }
  object { Window1_2_2 }
  photons {
    collect off
  }
}
#declare Window1_3_1 = union {
  box { // Win1Vert9
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert10
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor15
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor16
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor17
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane5
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor18
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.65, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <0.05, -0.65, 0.0>
}
#declare Window1_3_2 = union {
  box { // Win1Vert11
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert12
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor19
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor20
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor21
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane6
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor22
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.65, 0.0>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <0.75, -0.65, 0.0>
}
#declare Group_Window3 = union {
  box { // Floor1Sill3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.38, 0.2, 0.025>
    translate  <0.38, -0.55, 3.95>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1Upper3
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.37, 0.2, 0.015>
    translate  <0.38, -0.5, 5.26>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1Vert4
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <0.78, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  object { Window1_3_1 }
  object { Window1_3_2 }
  photons {
    collect off
  }
}
#declare Window1_4 = union {
  box { // Win1Vert3
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.6, 0.65, 0.0>
      rotate -20.688345*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert4
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.025, 0.615>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.6, 0.65, 0.0>
      rotate -20.688345*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor4
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.6, 0.65, 0.0>
      rotate -20.688345*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor5
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.6, 0.65, 0.0>
      rotate -20.688345*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor6
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.6, 0.65, 0.0>
      rotate -20.688345*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.165, 0.001, 0.6>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-1.6, 0.65, 0.0>
      rotate -20.688345*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate 20.688345*z
  translate  <1.6, -0.65, 0.0>
}
#declare Group_Window4 = union {
  box { // Floor1Sill4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.19, 0.2, 0.025>
    translate  <1.42, -0.55, 3.95>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1Upper4
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.21, 0.2, 0.015>
    translate  <1.42, -0.5, 5.26>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1Vert5
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <1.21, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1Vert6
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <1.63, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  object { Window1_4 }
  photons {
    collect off
  }
}
#declare Group_Floor1_Windows = union {
  object { Group_Window1 }
  object { Group_Window2 }
  object { Group_Window3 }
  object { Group_Window4 }
  photons {
    collect off
  }
}
#declare FirstFloor = difference {
  box { // Floor1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <1.95, 0.15, 1.5>
    translate  <0.0, -0.5, 3.0>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  box { // Floor1Window1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.195, 0.25, 0.635>
    translate  <-1.22, -0.5, 3.98>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  box { // Floor1Window2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.365, 0.25, 0.635>
    translate  <-0.4, -0.5, 3.98>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  box { // Floor1Window3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.365, 0.25, 0.635>
    translate  <0.4, -0.5, 3.98>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  box { // Floor1Window4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.198, 0.25, 0.635>
    translate  <1.42, -0.5, 3.98>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  photons {
    collect off
  }
}
#declare Floor1_Lintels = union {
  box { // LintelSupport1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 0.5, 0.1>
    translate  <0.0, -0.2, 3.0>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { LintelBeam1_1 }
  object { // LintelBeam1_2 -> LintelBeam1_1
    LintelBeam1_1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <0.76, 0.0, -0.0>
  }
  object { // LintelBeam1_3 -> LintelBeam1_1
    LintelBeam1_1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <1.52, 0.0, -0.0>
  }
  object { // LintelBeam1_4 -> LintelBeam1_1
    LintelBeam1_1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <2.28, 0.0, -0.0>
  }
  object { // LintelBeam1_5 -> LintelBeam1_1
    LintelBeam1_1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <3.04, 0.0, -0.0>
  }
  object { // LintelBeam1_6 -> LintelBeam1_1
    LintelBeam1_1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <3.8, 0.0, -0.0>
  }
  photons {
    collect off
  }
}
#declare Group_Floor1 = union {
  object { Group_Floor1_Windows }
  box { // Floor1_HorStrut3
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 0.15, 0.05>
    translate  <0.0, -0.6, 5.65>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { FirstFloor }
  box { // Floor1_WestWall
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.03, 5.0, 1.54>
    translate  <-1.95, 4.4, 3.0>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  box { // Floor1_EastWall
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.03, 5.0, 1.54>
    translate  <1.95, 4.4, 3.0>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  object { Floor1_Lintels }
  box { // FloorBoards1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 4.5, 0.1>
    translate  <0.0, 4.8, 3.0>
    material {
      WoodPanels2
      // Transform to world space
    }
  }
  box { // Floor1_VertStrut2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.05, 0.1, 1.325>
    translate  <-0.9, -0.6, 3.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1_VertStrut3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.05, 0.1, 1.325>
    translate  <0.9, -0.6, 3.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1_HorStrut1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 0.1, 0.05>
    translate  <0.0, -0.6, 3.9>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1_VertStrut1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.05, 0.1, 1.325>
    translate  <-1.95, -0.6, 3.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1_VertStrut4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.05, 0.1, 1.325>
    translate  <1.95, -0.6, 3.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1_DiagStrut4
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.05, 0.09, 0.6>
    rotate -50.0*y
    translate  <1.45, -0.6, 3.5>
  }
  box { // Floor1_DiagStrut1
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.05, 0.09, 0.6>
    rotate 50.0*y
    translate  <-1.45, -0.6, 3.5>
  }
  box { // Floor1_DiagStrut2
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.05, 0.09, 0.6>
    rotate -50.0*y
    translate  <-0.45, -0.6, 3.5>
  }
  box { // Floor1_DiagStrut3
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.05, 0.09, 0.6>
    rotate 50.0*y
    translate  <0.45, -0.6, 3.5>
  }
  box { // Floor1_HorStrut2
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 0.1, 0.05>
    translate  <0.0, -0.6, 5.31>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1_VertStrutCentre
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.05, 0.1, 1.325>
    translate  <0.0, -0.6, 3.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // FloorCeiling1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    photons {
      collect off
    }
    scale <1.97, 4.9, 0.1>
    translate  <0.0, 9.3, 5.9>
    material {
      WoodPanels2
      // Transform to world space
    }
  }
  photons {
    collect off
  }
}
#declare FrontonWest = difference {
  box { // Toit1
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, -0.0, -0.0>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.2, 0.05, 2.06>
    translate  <-0.2, 0.0, -1.0>
  }
  box { // Toit2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    photons {
      collect off
    }
    scale <0.2, 0.07, 0.5>
    rotate -30.0*y
    translate  <-0.215574, 0.0, 3.147859>
  }
  cylinder { // Toit3
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.394072, -0.073341, 2.093101>
  }
  cylinder { // Toit4
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.124101, -0.073341, -1.235394>
  }
  cylinder { // Toit5
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.395649, -0.073341, -0.506861>
  }
  box { // Toit6
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.116267, 0.07, 1.3>
    translate  <0.109936, -0.0, 0.792097>
  }
  translate  <0.2, 0.0, 1.0>
  material {
    DMFWood6
  }
  photons {
    collect off
  }
  rotate 30.0*y
  translate  <-2.06, 0.0, 0.0>
}
#declare FrontonDeckW = union {
  box { // RoofDeckW
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.15, 2.09>
  }
  box { // RoofDeckW1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.1, 2.1>
  }
  material {
    DMFWood6
  }
  photons {
    collect off
  }
  rotate 30.0*y
  translate  -2.105*x
}
#declare FrontonDeckE = union {
  box { // RoofDeckE
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.15, 2.09>
  }
  box { // RoofDeckE1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.1, 2.1>
  }
  material {
    DMFWood6
  }
  photons {
    collect off
  }
  rotate -30.0*y
  translate  2.105*x
}
#declare RoofDeco = lathe {
  quadratic_spline
  6  // control points
  <-0.097239, -0.014381>,
  <0.014831, 0.0>,
  <0.055544, 0.060157>,
  <0.020576, 0.10181>,
  <0.075263, 0.1262>,
  <0.003121, 0.40632>
  rotate <90,0,90>
  photons {
    collect off
  }
  translate  3.6*z
  material {
    DMFWood6
    // Transform to world space
    translate  <0.0, 1.2, -6.0>
  }
}
#declare FrontonEast = difference {
  box { // Toit7
    <-1, -1, -1>, <1, 1, 1>
    rotate <0.0, -0.0, -0.0>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.2, 0.05, 2.06>
    translate  <-0.2, 0.0, -1.0>
  }
  box { // Toit8
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    photons {
      collect off
    }
    scale <0.2, 0.07, 0.5>
    rotate -30.0*y
    translate  <-0.215574, 0.0, 3.147859>
  }
  cylinder { // Toit9
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.394072, -0.073341, 2.093101>
  }
  cylinder { // Toit10
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.124101, -0.073341, -1.235394>
  }
  cylinder { // Toit11
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.4, 0.15>
    rotate -90.0*x
    translate  <0.395649, -0.073341, -0.506861>
  }
  box { // Toit12
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.116267, 0.07, 1.3>
    translate  <0.109936, -0.0, 0.792097>
  }
  translate  <0.2, 0.0, 1.0>
  material {
    DMFWood6
  }
  photons {
    collect off
  }
  scale <-1.0, 1.0, 1.0>
  rotate -30.0*y
  translate  <2.06, 0.0, 0.0>
}
#declare Fronton = union {
  object { FrontonWest }
  object { FrontonDeckW }
  object { FrontonDeckE }
  object { RoofDeco }
  object { FrontonEast }
  photons {
    collect off
  }
  translate  <0.0, -1.2, 6.0>
}
#declare TopFloor = difference {
  box { // Floor2_1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <2.0, 0.15, 1.7>
  }
  box { // Floor2_2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <1.0, 0.151, 2.01>
    rotate -30.0*y
    translate  2.0*x
  }
  box { // Floor2_3
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <1.0, 0.151, 2.01>
    rotate 30.0*y
    translate  -2.0*x
  }
  photons {
    collect off
  }
  translate  6.0*z
}
#declare TopFloorDif = difference {
  object { TopFloor }
  box { // UpperHoistWindows
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.4, 0.25, 0.5>
    translate  <0.0, -0.034658, 7.8>
  }
  box { // UpperWindows
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.25, 0.25, 0.35>
    translate  <-0.4, -0.034658, 6.7>
  }
  material {
    TopFloorPanelling
  }
  photons {
    collect off
  }
  translate  -0.96*y
}
#declare Group_Chimney = union {
  box { // Chimney
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.2, 0.2, 1.1>
    translate  <1.7, 3.0, 6.0>
    material {
      BrickWall
      // Transform to world space
    }
  }
  cylinder { // ChimneyStrut
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 1.7>
    rotate 85.57518*y
    translate  <0.0, 3.0, 7.7>
    material {
      Brass_Metal
      // Transform to world space
    }
  }
  box { // ChimneyTop
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.22, 0.22, 0.05>
    translate  <1.7, 3.0, 8.2>
    material {
      BrickWall
      // Transform to world space
    }
  }
  cone { // ChimneyTube
    <0,0,0>, 0.13, <0,0,1>, 0.1
    open
    material {
      Rust
    }
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.35>
    rotate <-3.0, 5.0, 0.0>
    translate  <1.7, 3.0, 8.2>
  }
  photons {
    collect off
  }
}
#declare Group_Chimney1 = union {
  box { // Chimney1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.2, 1.3>
    translate  <-1.7, 1.7, 7.3>
    material {
      BrickWall
      // Transform to world space
      translate  -5.0*y
    }
  }
  cylinder { // ChimneyStrut1
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 1.7>
    rotate -90.0*y
    translate  <0.0, 1.7, 8.0>
    material {
      Brass_Metal
      // Transform to world space
      translate  -5.0*y
    }
  }
  box { // ChimneyTop1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.22, 0.22, 0.05>
    translate  <-1.7, 1.7, 8.6>
    material {
      BrickWall
      // Transform to world space
      translate  -5.0*y
    }
  }
  cone { // ChimneyTube1
    <0,0,0>, 0.13, <0,0,1>, 0.1
    open
    material {
      Rust
    }
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.35>
    rotate <3.0, -4.0, 0.0>
    translate  <-1.7, 1.7, 8.6>
  }
  photons {
    collect off
  }
  translate  5.0*y
}
#declare ToBeDifferencedFromRoof = union {
  object { CSG006 }
  object { // CSG007 -> CSG006
    CSG006
    photons {
      collect off
    }
    scale -1.0
    rotate -180.0*x
  }
  material {
    TopFloorPanelling
  }
  photons {
    collect off
  }
  rotate 90.0*z
  translate  <2.0, 1.0, 6.1>
}
#declare RoofDif1 = difference {
  box { // RoofEast
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <2.03, 5.3, 0.01>
    rotate 60.0*y
    translate  <2.02, 9.4, 6.0>
    material {
      Rust
      // Transform to world space
    }
  }
  object { ToBeDifferencedFromRoof }
  photons {
    collect off
  }
}
#declare GableRoof1 = union {
  box { // GableRoofElement1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.55, 1.05, 0.01>
    rotate -60.0*y
    translate  <0.0, -0.05, 2.0>
    material {
      Rust
      // Transform to world space
      translate  <-2.0, -1.0, -6.1>
      rotate -90.0*z
    }
  }
  box { // GableRoofElement2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <-0.55, -1.05, -0.01>
    rotate <-180.0, 60.0, 0.0>
    translate  <0.0, -0.05, 2.0>
    material {
      Rust
      // Transform to world space
      translate  <-2.0, -1.0, -6.1>
      rotate -90.0*z
    }
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.03, 0.02, 2.1>
    rotate -90.0*x
    translate  <0.0, -0.05, 2.0>
    material {
      Rust
      // Transform to world space
      translate  <-2.0, -1.0, -6.1>
      rotate -90.0*z
    }
  }
  photons {
    collect off
  }
}
#declare GableElements1 = union {
  object { Gable1 }
  object { // Gable2 -> Gable1
    Gable1
    photons {
      collect off
    }
    scale <-1.0, 1.0, 1.0>
  }
  object { GableRoof1 }
  photons {
    collect off
  }
}
#declare RoofGableDif1 = difference {
  object { GableElements1 }
  box { // RoofCut1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    material {
      Rust
    }
    photons {
      collect off
    }
    scale <0.58, 1.0, 1.5>
    rotate -30.0*x
    translate  0.025*y
  }
  photons {
    collect off
  }
}
#declare RoofGable1 = union {
  object { RoofGableDif1 }
  box { // GableDoor
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      TopFloorPanelling
    }
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.32, 0.02, 0.71>
    rotate 26.847452*z
    translate  <-0.32, 0.075, 0.0>
  }
  photons {
    collect off
  }
  rotate 90.0*z
  translate  <2.0, 1.0, 6.1>
}
#declare ToBeDifferencedFromRoof1 = union {
  object { CSG009 }
  object { // CSG010 -> CSG009
    CSG009
    photons {
      collect off
    }
    scale -1.0
    rotate -180.0*x
  }
  material {
    TopFloorPanelling
  }
  photons {
    collect off
  }
  rotate -90.0*z
  translate  <-2.0, 4.0, 6.1>
}
#declare RoofDif2 = difference {
  box { // RoofWest
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <2.03, 5.3, 0.01>
    rotate -60.0*y
    translate  <-2.02, 9.4, 6.0>
    material {
      Rust
      // Transform to world space
    }
  }
  object { ToBeDifferencedFromRoof1 }
  photons {
    collect off
  }
}
#declare GableRoof2 = union {
  box { // GableRoofElement3
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.55, 1.05, 0.01>
    rotate -60.0*y
    translate  <0.0, -0.05, 2.0>
    material {
      Rust
      // Transform to world space
      translate  <2.0, -4.0, -6.1>
      rotate 90.0*z
    }
  }
  box { // GableRoofElement4
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <-0.55, -1.05, -0.01>
    rotate <-180.0, 60.0, 0.0>
    translate  <0.0, -0.05, 2.0>
    material {
      Rust
      // Transform to world space
      translate  <2.0, -4.0, -6.1>
      rotate 90.0*z
    }
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.03, 0.02, 2.1>
    rotate -90.0*x
    translate  <0.0, -0.05, 2.0>
    material {
      Rust
      // Transform to world space
      translate  <2.0, -4.0, -6.1>
      rotate 90.0*z
    }
  }
  photons {
    collect off
  }
}
#declare GableElements2 = union {
  object { Gable3 }
  object { // Gable4 -> Gable3
    Gable3
    photons {
      collect off
    }
    scale -1.0
    rotate -180.0*x
  }
  object { GableRoof2 }
  photons {
    collect off
  }
}
#declare RoofGableDif2 = difference {
  object { GableElements2 }
  box { // RoofCut2
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    material {
      Rust
    }
    photons {
      collect off
    }
    scale <0.58, 0.9, 1.4>
    rotate -30.0*x
    translate  0.025*y
  }
  photons {
    collect off
  }
}
#declare RoofGable2 = union {
  object { RoofGableDif2 }
  box { // GableDoor1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      TopFloorPanelling
    }
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.32, 0.02, 0.71>
    rotate 34.248997*z
    translate  <-0.32, 0.075, 0.0>
  }
  photons {
    collect off
  }
  rotate -90.0*z
  translate  <-2.0, 4.0, 6.1>
}
#declare Group_Roof = union {
  object { Fronton }
  object { TopFloorDif }
  object { Group_Chimney }
  object { Group_Chimney1 }
  object { RoofDif1 }
  object { RoofGable1 }
  object { RoofDif2 }
  object { RoofGable2 }
  photons {
    collect off
  }
}
#declare BackwallTopFloorDif = difference {
  box { // BackwallTopFloor
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <2.0, 0.05, 1.7>
    translate  9.35*y
  }
  box { // BackwallTopFloor1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <1.0, 0.1, 2.01>
    rotate -30.0*y
    translate  <2.0, 9.35, 0.0>
  }
  box { // BackwallTopFloor2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <1.0, 0.1, 2.01>
    rotate 30.0*y
    translate  <-2.0, 9.35, 0.0>
  }
  photons {
    collect off
  }
  translate  6.0*z
  material {
    White_Plaster
    // Transform to world space
  }
}
#declare Group_Backwall = union {
  box { // BackwallGroundFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 0.05, 1.5>
    translate  <0.0, 9.35, 1.5>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  box { // BackwallFirstFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 0.05, 1.5>
    translate  <0.0, 9.35, 4.5>
    material {
      White_Plaster
      // Transform to world space
    }
  }
  object { BackwallTopFloorDif }
  photons {
    collect off
  }
}
#declare Floor2_Lintels = union {
  box { // LintelSupport2
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <2.0, 0.4, 0.1>
    translate  <0.0, -0.35, 3.0>
  }
  object { LintelBeam2_1 }
  object { // LintelBeam2_2 -> LintelBeam2_1
    LintelBeam2_1
    photons {
      collect off
    }
    translate  <0.76, -0.0, -0.0>
  }
  object { // LintelBeam2_3 -> LintelBeam2_1
    LintelBeam2_1
    photons {
      collect off
    }
    translate  <1.52, -0.0, -0.0>
  }
  object { // LintelBeam2_4 -> LintelBeam2_1
    LintelBeam2_1
    photons {
      collect off
    }
    translate  <2.28, -0.0, -0.0>
  }
  object { // LintelBeam2_5 -> LintelBeam2_1
    LintelBeam2_1
    photons {
      collect off
    }
    translate  <3.04, -0.0, -0.0>
  }
  object { // LintelBeam2_6 -> LintelBeam2_1
    LintelBeam2_1
    photons {
      collect off
    }
    translate  <3.8, -0.0, -0.0>
  }
  photons {
    collect off
  }
  translate  2.95*z
}
#declare Floor2_WindowShade = difference {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <1.1, 0.02, 0.3>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    photons {
      collect off
    }
    scale <0.15, 0.051, 0.35>
    rotate -17.0*y
    translate  0.85*x
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, -1.0>
    photons {
      collect off
    }
    scale <0.15, 0.051, 0.35>
    rotate 17.0*y
    translate  -0.85*x
  }
  rotate -0.0*x
  translate  <0.0, 0.048515, -0.088718>
  material {
    TopFloorPanelling
  }
  photons {
    collect off
  }
  rotate -45.0*x
  translate  <0.0, -1.1, 7.697038>
}
#declare Group_Floor2 = union {
  box { // Floor2_VertStrutCentre
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.05, 0.1, 1.73>
    translate  <0.0, -1.14, 6.0>
  }
  box { // Floor2_HorStrut2
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.38, 0.2, 0.03>
    translate  <0.0, -0.9, 8.9>
  }
  box { // Floor2_VertStrutCentre1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.03, 0.12, 0.97>
    translate  <0.0, -1.0, 9.4>
  }
  box { // Floor2_VertStrutCentre2
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.02, 0.15, 0.72>
    translate  <0.0, -1.0, 9.4>
  }
  object { Floor2_Lintels }
  box { // Floor2_DiagStrut1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.05, 0.09, 0.66>
    rotate <-0.0, 64.0, -0.0>
    translate  <-1.17, -0.95, 6.0>
  }
  box { // Floor2_DiagStrut2
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.05, 0.09, 0.66>
    rotate -64.0*y
    translate  <1.17, -0.95, 6.0>
  }
  box { // HoistBeam
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.08, 5.6, 0.08>
    translate  <0.0, 9.4, 9.2>
  }
  box { // Floor2_HorStrut1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <1.5, 0.1, 0.05>
    translate  <0.0, -1.0, 6.6>
  }
  box { // UpperWindowShutter1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      TopFloorPanelling
    }
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.173, 0.02, 0.495>
    rotate 24.593946*z
    translate  <-0.398685, -1.05, 7.802161>
  }
  box { // UpperWindowShutter2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    material {
      TopFloorPanelling
    }
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (-90.0 to     0.0)
    // Translation fixed
    scale <0.173, 0.02, 0.495>
    rotate -3.935173*z
    translate  <0.39829, -1.05, 7.801051>
  }
  box { // Floor2_HorStrut3
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <1.0, 0.1, 0.05>
    translate  <0.0, -1.0, 7.65>
  }
  box { // Floor2_WindowVert
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.03, 0.1, 0.4>
    translate  <-0.4, -1.0, 6.68>
  }
  box { // Floor2_WindowPane
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.26, 0.001, 0.36>
    translate  <-0.4, -1.0, 6.69>
    material {
      WindowGlass
      // Transform to world space
    }
  }
  object { Floor2_WindowShade }
  object { ShadeStrut1 }
  object { // ShadeStrut2 -> ShadeStrut1
    ShadeStrut1
    photons {
      collect off
    }
    rotate 0.0*x
    translate  <1.0, -0.0, 0.0>
  }
  object { // ShadeStrut3 -> ShadeStrut1
    ShadeStrut1
    photons {
      collect off
    }
    rotate 0.0*x
    translate  <2.0, -0.0, 0.0>
  }
  photons {
    collect off
  }
}
#declare CSG001 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 0.1>
    translate  -0.15*z
  }
  torus { // Torus002
    0.2, 0.05  rotate -x*90
    photons {
      collect off
    }
    translate  -0.1*z
  }
  photons {
    collect off
  }
}
#declare CSG002 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.5, 0.5, 0.2>
    translate  -0.37*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate -90.0*x
    translate  <0.72, -0.55, -0.17>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate -90.0*x
    translate  <-0.72, -0.55, -0.17>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.55, 0.72, -0.17>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.55, -0.72, -0.17>
  }
  cone { // Cone001
    <0,0,0>, 0.5, <0,0,1>, 0.2
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.5>
    translate  -0.7*z
    material {
      White_Paint
      // Transform to world space
      translate  <0.0, 0.705, -3.45>
      rotate -90.0*z
      scale 1.0/0.3
      translate  2.0*x
      translate  2.0*x
    }
  }
  photons {
    collect off
  }
}
#declare Top = union {
  torus { // Torus001
    0.2, 0.05  rotate -x*90
    photons {
      collect off
    }
  }
  object { CSG001 }
  torus { // Torus003
    0.175, 0.02  rotate -x*90
    photons {
      collect off
    }
    translate  -0.15*z
  }
  object { CSG002 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate -90.0*x
    translate  <0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate -90.0*x
    translate  <-0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.48, 0.48, -0.57>
  }
  photons {
    collect off
  }
}
#declare LampHolder = union {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <-170.0, 10.0, 0.0>
    translate  <0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <-170.0, -10.0, 0.0>
    translate  <-0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <170.0, -10.0, 0.0>
    translate  <-0.48, 0.48, -0.57>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <170.0, 10.0, 0.0>
    translate  <0.48, 0.48, -0.57>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate -90.0*x
    translate  <-0.315, -0.32, -1.5>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate -90.0*x
    translate  <0.315, -0.32, -1.5>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.315, -0.32, -1.5>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.315, 0.315, -1.5>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -45.0>
    translate  -1.75*z
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -135.0>
    translate  -1.75*z
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -225.0>
    translate  -1.75*z
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -315.0>
    translate  -1.75*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.05
    translate  -1.75*z
  }
  photons {
    collect off
  }
}
#declare LampArm = union {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.8>
  }
  cone { // Cone002
    <0,0,0>, 0.06, <0,0,1>, 0.02
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.2>
    translate  0.2*z
  }
  photons {
    collect off
  }
}
#declare Tor1 = difference {
  torus { // Torus004
    0.1, 0.03  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.06, 0.05, 0.12>
    translate  0.06*x
  }
  photons {
    collect off
  }
  translate  1.0*z
}
#declare Tor2 = difference {
  torus { // Torus005
    0.15, 0.03  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.09, 0.05, 0.17>
    translate  -0.09*x
  }
  photons {
    collect off
  }
  translate  0.95*z
}
#declare Tor3 = difference {
  torus { // Torus006
    0.2, 0.03  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.12, 0.054545, 0.250909>
    translate  0.12*x
  }
  photons {
    collect off
  }
  translate  1.0*z
}
#declare GallowDif = difference {
  torus { // Torus007
    1.5, 0.03  rotate -x*90
    photons {
      collect off
    }
    scale <0.8, 0.5, 1.0>
    rotate -90.0*x
    translate  <0.75, 0.0, 0.01>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.8, 0.05, 1.0>
    translate  -0.05*x
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.3, 0.05, 0.5>
    translate  <0.75, 0.0, -0.5>
  }
  photons {
    collect off
  }
  translate  0.4*z
}
#declare Gallow = union {
  object { Tor1 }
  object { Tor2 }
  object { Tor3 }
  sphere { // Sphere002
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.055
    translate  0.92*z
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.03, 0.03, 2.0>
    rotate 90.0*y
    translate  1.2*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 0.05, 1.0>
    translate  <2.0, 0.0, 0.4>
  }
  object { GallowDif }
  photons {
    collect off
  }
  translate  -0.4*z
}
#declare LampGlass = union {
  object { Glass1 }
  object { // Glass2 -> Glass1
    Glass1
    photons {
      collect off
    }
    rotate -90.0*z
  }
  object { // Glass3 -> Glass1
    Glass1
    photons {
      collect off
    }
    rotate 180.0*z
  }
  object { // Glass4 -> Glass1
    Glass1
    photons {
      collect off
    }
    rotate 90.0*z
  }
  photons {
    collect off
  }
  material {
    T_Yellow_Glass
    // Transform to world space
    translate  <0.0, 0.705, -3.45>
    rotate -90.0*z
    scale 1.0/0.3
    translate  2.0*x
    translate  2.0*x
  }
}
#declare StreetLamp = union {
  object { Top }
  object { LampHolder }
  object { LampArm }
  object { Gallow }
  object { LampGlass }
  translate  -2.0*x
  photons {
    collect off
  }
  scale 0.3
  rotate 90.0*z
  translate  <0.0, -0.705, 3.45>
  material {
    DarkBlue_Paint
    // Transform to world space
  }
}


#declare mh5 = 
union { // MedievalHouse5
  object { Group_GroundFloor }
  object { Group_Floor1 }
  object { Group_Roof }
  object { Group_Backwall }
  object { Group_Floor2 }
  object { StreetLamp }
  photons {
    collect off
  }
}


