// Something Wicked This Way Comes

// HEADER
#version 3.6;
global_settings { assumed_gamma 2 
radiosity { pretrace_start 0.08 pretrace_end 0.04 count 35 nearest_count 5 error_bound 1.8 recursion_limit 3
low_error_factor .5  gray_threshold 0.0 minimum_reuse 0.015 brightness .5 adc_bailout 0.01/2 } }
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "stones.inc"
#include "functions.inc"
#declare it = seed(0);  

// CAMERA
#declare looking_at = <0,3,0>;
#declare camera_location= <-8,1,-10>; 
camera {ultra_wide_angle angle 75 location camera_location right x*image_width/image_height look_at looking_at
focal_point looking_at-y aperture 0.07 blur_samples 25 }   
                
// SKY
background { rgb <0,0,.2> }

// FOG
fog  { fog_type 2 distance 10 color .4 fog_offset .5  fog_alt .5 turbulence 2 }
fog  { fog_type 1 distance 20 color .2 } 
    
// STONEROAD
#declare rr =  texture { T_Chrome_1A  normal { bumps 0.5 scale 0.15}  finish { diffuse 0.8 phong .5} }
#declare qq = isosurface { function { f_rounded_box(x,y,z,0.3,1.4,0.9,0.9)-(f_noise3d(x,y,z))*.15}contained_by{box {<-2,-1,-1>,<2,1,1>}} } 
#declare rock = object {qq texture{rr} scale .1 translate <0,0,-2>} 
#declare strip = union{
#declare n = -15;
#while (n<40)
object {rock translate <n,.03*rand(it),0> }
#declare n=n+.29;
#end }
#declare m=15;
#while (m>-15)
object {strip translate <-1+2*rand(it),0,m>}
#declare m=m-.2;
#end

// HOUSES
#include "medhouse1.pov"
#include "medhouse2.pov"         
#include "medhouse5.pov"         
#declare neighbourhood = union{
object {mh1 rotate <-90,180,0>}
object {mh2 rotate <-90,180,0> translate <4,0,0>}
object {mh5 rotate <-90,180,0> translate <-4,0,0>} }
#declare block = union {
object {neighbourhood translate <4,0,0>}
object {neighbourhood translate <16,0,0>}
object {neighbourhood translate <24,0,0>}  }
object {block}
object {block translate <-6,0,20> }

// STREET LIGHT
light_source{<0,3.2,-1.3> color White+Yellow*2 area_light <.05, 0, 0> <0, 0, .05> 2, 2 adaptive 0 jitter circular orient }
sphere {0,.031 texture {pigment {color (White+Yellow)} finish {ambient 1 diffuse 1}} no_shadow translate <0,3.2,-1.3> }
light_source{<4,3.2,-1.4> color (White+Yellow)*2 area_light <.05, 0, 0> <0, 0, .05> 2, 2 adaptive 0 jitter circular orient }
sphere {0,.031 texture {pigment {color (White+Yellow)} finish {ambient 1 diffuse 1}} no_shadow translate <4,3.2,-1.4> }
light_source{<12,3.2,-1.3> color (White+Yellow)*2 area_light <.05, 0, 0> <0, 0, .05> 2, 2 adaptive 0 jitter circular orient }
sphere {0,.031 texture {pigment {color (White+Yellow)} finish {ambient 1 diffuse 1}} no_shadow translate <12,3.2,-1.3> }

// INTERIOR LIGHT
light_source{<0,4.5,2> color (White+Yellow) area_light <.05, 0, 0> <0, 0, .05> 2, 2 adaptive 0 jitter circular orient }
light_source{<12,4.5,2> color (White+Yellow) area_light <.05, 0, 0> <0, 0, .05> 2, 2 adaptive 0 jitter circular orient }
light_source{<-6,4.5,22> color (White+Yellow) area_light <.05, 0, 0> <0, 0, .05> 2, 2 adaptive 0 jitter circular orient }
      
// TREES                                                            
#include "t1"
object {TREE scale <5,5,5> translate <-5,0,0>}
object {TREE scale <4,6,4> rotate y*120 translate <-6.5,-.5,3>} 
#declare dirtpile = isosurface
{ function{ f_torus2( x,y,z, -0.75, 0.65, 0.02) } contained_by {box {<-1,-1,-1>*1,<1,1,1>*1}}
threshold 0.16  max_gradient 5 texture{rr} scale .5 }
object {dirtpile translate <-5,0,0>}
object {dirtpile translate <-6.5,0,3>}

// BARRELS
#include "barrel.pov"
object {bins rotate <90,15,0> scale <.08,.1,.08> translate <-2.5,.56,.25>}  
object {bins rotate <90,15,0> scale <.08,.1,.08> translate <14,.56,-.5>}
object {bins rotate <90,15,0> scale <.08,.1,.08> translate <17.5,.56,-.55>}

// DUDE
#include "bmpeople.inc"
#include "sample.cdf" 
Blob_Man(Male,2)
object {BlobMan scale .03 rotate <0,30,0> translate <-2,2,13>} 

// WEEDS
#include "weed.pov"
object {weed scale .2 rotate y*35 translate <-5,0,0>}
object {weed scale .25 translate <-5,-.25,-.25>}
object {weed scale .3 rotate y*-35 translate <-6.5,-.5,3>}
object {weed scale .25 translate <-6.5,-.5,3.1>}
