#version 3.6;

//------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "functions.inc"
#include "math.inc"
#include "transforms.inc"
//------------------------------------------------------------------------

#declare Radiosity=on;

global_settings {
  assumed_gamma 1.0
  //max_trace_level 25
  #if (Radiosity)
    radiosity {
      count 1500                      // higher -> higher quality (1..1600) [35]
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 0.5                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}

#default {
  texture {
    pigment {rgb 1}
    #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 0.9
        specular 0.3
      }
    #else
      finish {
        ambient 0.1
        diffuse 0.9
        specular 0.3
      }
    #end
  }
}

// ----------------------------------------


//--------------------------------------------------------------------------
//---------------------------- objects in scene ----------------------------
//--------------------------------------------------------------------------

#declare typo_rayon = 0.3;
#declare typo_z = 16;

//-[ P ]--------------------------------------------------------------------
#declare lettre_P =
union	{
	// --- Face avant ---
	sphere	 { <typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
        cylinder { <typo_rayon, typo_rayon, typo_rayon>, <typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
	sphere	 { <typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
        cylinder { <typo_rayon, 20-typo_rayon, typo_rayon>, <14, 20-typo_rayon, typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <14,14,typo_rayon>
        	}
        cylinder { <20-typo_rayon, 14, typo_rayon>, <20-typo_rayon, 11, typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <14,11,typo_rayon>
        	}
        cylinder { <14, 5+typo_rayon, typo_rayon>, <6-typo_rayon, 5+typo_rayon, typo_rayon>, typo_rayon }
	sphere	 { <6-typo_rayon, 5+typo_rayon, typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, 5+typo_rayon, typo_rayon>, <6-typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
	sphere	 { <6-typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, typo_rayon, typo_rayon>, <typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
        sphere	 { <6-typo_rayon, 11-typo_rayon, typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, 11-typo_rayon, typo_rayon>, <6-typo_rayon, 14+typo_rayon, typo_rayon>, typo_rayon }
        sphere 	 { <6-typo_rayon, 14+typo_rayon, typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, 14+typo_rayon, typo_rayon>, <13+typo_rayon, 14+typo_rayon, typo_rayon>, typo_rayon }
         intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <1+(typo_rayon*2), typo_rayon*2, 1+(typo_rayon*2)> }
        	rotate x*-90
        	translate <13,13,typo_rayon>
        	}
        cylinder { <14+typo_rayon, 13, typo_rayon>, <14+typo_rayon, 12, typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <1+(typo_rayon*2), typo_rayon*2, 1+(typo_rayon*2)> }
        	rotate x*90
        	translate <13,12,typo_rayon>
        	}
        cylinder { <13, 11-typo_rayon, typo_rayon>, <6-typo_rayon, 11-typo_rayon, typo_rayon>, typo_rayon }
	// --- Face ariere ---
	sphere	 { <typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <typo_rayon, typo_rayon, typo_z-typo_rayon>, <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	sphere	 { <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, <14, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <14,14,typo_z-typo_rayon>
        	}
        cylinder { <20-typo_rayon, 14, typo_z-typo_rayon>, <20-typo_rayon, 11, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <14,11,typo_z-typo_rayon>
        	}
        cylinder { <14, 5+typo_rayon, typo_z-typo_rayon>, <6-typo_rayon, 5+typo_rayon, typo_z-typo_rayon>, typo_rayon }
	sphere	 { <6-typo_rayon, 5+typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, 5+typo_rayon, typo_z-typo_rayon>, <6-typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
	sphere	 { <6-typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, typo_rayon, typo_z-typo_rayon>, <typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
        sphere	 { <6-typo_rayon, 11-typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <6-+typo_rayon, 11-typo_rayon, typo_z-typo_rayon>, <6-typo_rayon, 14+typo_rayon, typo_z-typo_rayon>, typo_rayon }
        sphere 	 { <6-typo_rayon, 14+typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, 14+typo_rayon, typo_z-typo_rayon>, <13+typo_rayon, 14+typo_rayon, typo_z-typo_rayon>, typo_rayon }
         intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <1+(typo_rayon*2), typo_rayon*2, 1+(typo_rayon*2)> }
        	rotate x*-90
        	translate <13,13,typo_z-typo_rayon>
        	}
        cylinder { <14+typo_rayon, 13, typo_z-typo_rayon>, <14+typo_rayon, 12, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <1+(typo_rayon*2), typo_rayon*2, 1+(typo_rayon*2)> }
        	rotate x*90
        	translate <13,12,typo_z-typo_rayon>
        	}
        cylinder { <13, 11-typo_rayon, typo_z-typo_rayon>, <6-typo_rayon, 11-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	// --- Jonction Face avant / arriere ---
        cylinder { <typo_rayon, typo_rayon, typo_rayon>, <typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <typo_rayon, 20-typo_rayon, typo_rayon>, <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, 5+typo_rayon, typo_rayon>, <6-typo_rayon, 5+typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, typo_rayon, typo_rayon>, <6-typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, 11-typo_rayon, typo_rayon>, <6-typo_rayon, 11-typo_rayon, typo_z-typo_rayon>, typo_rayon }
        cylinder { <6-typo_rayon, 14+typo_rayon, typo_rayon>, <6-typo_rayon, 14+typo_rayon, typo_z-typo_rayon>, typo_rayon }
	// --- remplisage ---
	difference {
		union	{	// --- LE PLEIN ---
			box { <typo_rayon, 0, typo_rayon>, <6-typo_rayon, 20, typo_z-typo_rayon> }
			box { <typo_rayon, 5, typo_rayon>, <14, 20, typo_z-typo_rayon> }
			box { <typo_rayon, 11, typo_rayon>, <20, 14, typo_z-typo_rayon> }     
			cylinder { <14, 14, typo_rayon>, <14, 14, typo_z-typo_rayon>, 6 }
			cylinder { <14, 11, typo_rayon>, <14, 11, typo_z-typo_rayon>, 6 }
	                box { <0, typo_rayon, typo_rayon>, <6, 20-typo_rayon, typo_z-typo_rayon> }
	
	                box { <typo_rayon, typo_rayon, 0>, <6-typo_rayon, 20-typo_rayon, typo_z> }
	                box { <typo_rayon, 5+typo_rayon, 0>, <14, 11-typo_rayon, typo_z> }
	                box { <typo_rayon, 14+typo_rayon, 0>, <14, 20-typo_rayon, typo_z> }
	                box { <14+typo_rayon, 11, 0>, <20-typo_rayon, 14, typo_z> }
	                cylinder { <14, 14, 0>, <14, 14, typo_z>, 6-typo_rayon }
	                cylinder { <14, 11, 0>, <14, 11, typo_z>, 6-typo_rayon }
	                }
		box { <6, 11, -1>, <13, 14, typo_z+1> }
		box { <6-typo_rayon, 11-typo_rayon, -1>, <13, 14+typo_rayon, typo_rayon> }
		box { <6-typo_rayon, 11-typo_rayon, typo_z-typo_rayon>, <13, 14+typo_rayon, typo_z*2> }
		box { <10, 12, -1>, <14, 13, typo_z+1> }
		box { <10, 12, -1>, <14+typo_rayon, 13, typo_rayon> }
		box { <10, 12, typo_z-typo_rayon>, <14+typo_rayon, 13, typo_z*2> }
		cylinder { <13, 13, -1>, <13, 13, typo_z*2>, 1 }
		cylinder { <13, 13, -1>, <13, 13, typo_rayon>, 1+typo_rayon }
		cylinder { <13, 13, typo_z-typo_rayon>, <13, 13, typo_z*2>, 1+typo_rayon }
		cylinder { <13, 12, -1>, <13, 12, typo_z*2>, 1 }
		cylinder { <13, 12, -1>, <13, 12, typo_rayon>, 1+typo_rayon }
		cylinder { <13, 12, typo_z-typo_rayon>, <13, 12, typo_z*2>, 1+typo_rayon }
		}
        
	}



//-[ O ]--------------------------------------------------------------------
#declare lettre_O =
union	{
	// --- Face avant ---
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <14,14,typo_rayon>
        	}
        cylinder { <20-typo_rayon, 14, typo_rayon>, <20-typo_rayon, 6, typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <14,6,typo_rayon>
        	}
        cylinder { <14, typo_rayon, typo_rayon>, <6, typo_rayon, typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <(6+(typo_rayon*2))*-1, typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <6,14,typo_rayon>
        	}
        cylinder { <typo_rayon, 6, typo_rayon>, <typo_rayon, 14, typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <(6+(typo_rayon*2))*-1, typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <6,6,typo_rayon>
        	}
        cylinder { <6, 20-typo_rayon, typo_rayon>, <14, 20-typo_rayon, typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <13,13,typo_rayon>
        	}
        cylinder { <14+typo_rayon, 13, typo_rayon>, <14+typo_rayon, 7, typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <13,7,typo_rayon>
        	}
        cylinder { <13, 6-typo_rayon, typo_rayon>, <7, 6-typo_rayon, typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <(6+(typo_rayon*2))*-1, typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <7,13,typo_rayon>
        	}
        cylinder { <6-typo_rayon, 7, typo_rayon>, <6-typo_rayon, 13, typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <(6+(typo_rayon*2))*-1, typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <7,7,typo_rayon>
        	}
        cylinder { <7, 14+typo_rayon, typo_rayon>, <13, 14+typo_rayon, typo_rayon>, typo_rayon }

	// --- Face arriere ---
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <14,14,typo_z-typo_rayon>
        	}
        cylinder { <20-typo_rayon, 14, typo_z-typo_rayon>, <20-typo_rayon, 6, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <14,6,typo_z-typo_rayon>
        	}
        cylinder { <14, typo_rayon, typo_z-typo_rayon>, <6, typo_rayon, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <(6+(typo_rayon*2))*-1, typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <6,14,typo_z-typo_rayon>
        	}
        cylinder { <typo_rayon, 6, typo_z-typo_rayon>, <typo_rayon, 14, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 6-typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <(6+(typo_rayon*2))*-1, typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <6,6,typo_z-typo_rayon>
        	}
        cylinder { <6, 20-typo_rayon, typo_z-typo_rayon>, <14, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <13,13,typo_z-typo_rayon>
        	}
        cylinder { <14+typo_rayon, 13, typo_z-typo_rayon>, <14+typo_rayon, 7, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <6+(typo_rayon*2), typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <13,7,typo_z-typo_rayon>
        	}
        cylinder { <13, 6-typo_rayon, typo_z-typo_rayon>, <7, 6-typo_rayon, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <(6+(typo_rayon*2))*-1, typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*-90
        	translate <7,13,typo_z-typo_rayon>
        	}
        cylinder { <6-typo_rayon, 7, typo_z-typo_rayon>, <6-typo_rayon, 13, typo_z-typo_rayon>, typo_rayon }
        intersection {
        	torus { 1+typo_rayon, typo_rayon }
        	box { <0, -typo_rayon*2, 0>, <(6+(typo_rayon*2))*-1, typo_rayon*2, 6+(typo_rayon*2)> }
        	rotate x*90
        	translate <7,7,typo_z-typo_rayon>
        	}
        cylinder { <7, 14+typo_rayon, typo_z-typo_rayon>, <13, 14+typo_rayon, typo_z-typo_rayon>, typo_rayon }
	// --- remplisage ---
	difference {
        	union	{
        		box { <0, 6, typo_rayon>, <20, 14, typo_z-typo_rayon> }
        		box { <6, 0, typo_rayon>, <14, 20, typo_z-typo_rayon> }
                        cylinder { <14, 14, typo_rayon>, <14, 14, typo_z-typo_rayon>, 6 }
                        cylinder { < 6, 14, typo_rayon>, < 6, 14, typo_z-typo_rayon>, 6 }
                        cylinder { <14,  6, typo_rayon>, <14,  6, typo_z-typo_rayon>, 6 }
                        cylinder { < 6,  6, typo_rayon>, < 6,  6, typo_z-typo_rayon>, 6 }
        		box { <0+typo_rayon, 6, 0>, <20-typo_rayon, 14, typo_z> }
        		box { <6, 0+typo_rayon, 0>, <14, 20-typo_rayon, typo_z> }
                        cylinder { <14, 14, 0>, <14, 14, typo_z>, 6-typo_rayon }
                        cylinder { < 6, 14, 0>, < 6, 14, typo_z>, 6-typo_rayon }
                        cylinder { <14,  6, 0>, <14,  6, typo_z>, 6-typo_rayon }
                        cylinder { < 6,  6, 0>, < 6,  6, typo_z>, 6-typo_rayon }
        		}
		box { <7, 6, -1>, <13, 14, typo_z*2> }
		box { <6, 7, -1>, <14, 13, typo_z*2> }
                cylinder { <13, 13, -1>, <13, 13, typo_z*2>, 1 }
                cylinder { < 7, 13, -1>, < 7, 13, typo_z*2>, 1 }
                cylinder { <13,  7, -1>, <13,  7, typo_z*2>, 1 }
                cylinder { < 7,  7, -1>, < 7,  7, typo_z*2>, 1 }
		box { <7, 6-typo_rayon, -1>, <13, 14+typo_rayon, typo_rayon> }
		box { <6-typo_rayon, 7, -1>, <14+typo_rayon, 13, typo_rayon> }
                cylinder { <13, 13, -1>, <13, 13, typo_rayon>, 1+typo_rayon }
                cylinder { < 7, 13, -1>, < 7, 13, typo_rayon>, 1+typo_rayon }
                cylinder { <13,  7, -1>, <13,  7, typo_rayon>, 1+typo_rayon }
                cylinder { < 7,  7, -1>, < 7,  7, typo_rayon>, 1+typo_rayon }
		box { <7, 6-typo_rayon, typo_z-typo_rayon>, <13, 14+typo_rayon, typo_z*2> }
		box { <6-typo_rayon, 7, typo_z-typo_rayon>, <14+typo_rayon, 13, typo_z*2> }
                cylinder { <13, 13, typo_z-typo_rayon>, <13, 13, typo_z*2>, 1+typo_rayon }
                cylinder { < 7, 13, typo_z-typo_rayon>, < 7, 13, typo_z*2>, 1+typo_rayon }
                cylinder { <13,  7, typo_z-typo_rayon>, <13,  7, typo_z*2>, 1+typo_rayon }
                cylinder { < 7,  7, typo_z-typo_rayon>, < 7,  7, typo_z*2>, 1+typo_rayon }
		}

	}





//-[ V ]--------------------------------------------------------------------
#declare lettre_V =
union	{
	union	{
		// --- Face avant ---
		sphere	 { <typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, typo_rayon, typo_rayon>, <typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
		sphere	 { <typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, 20-typo_rayon, typo_rayon>, <7-typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
		sphere	 { <7-typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, 20-typo_rayon, typo_rayon>, <7-typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
		sphere	 { <7-typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, typo_rayon, typo_rayon>, <typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
		// --- Face arriere ---
		sphere	 { <typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, typo_rayon, typo_z-typo_rayon>, <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
		sphere	 { <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, <7-typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
		sphere	 { <7-typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, <7-typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
		sphere	 { <7-typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, typo_rayon, typo_z-typo_rayon>, <typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
		// --- Jonction Face avant / arriere ---
	        cylinder { <typo_rayon, typo_rayon, typo_rayon>, <typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, 20-typo_rayon, typo_rayon>, <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, 20-typo_rayon, typo_rayon>, <7-typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, typo_rayon, typo_rayon>, <7-typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        box { <typo_rayon,0,typo_rayon>, <7-typo_rayon,20,typo_z-typo_rayon> }
	        box { <0,typo_rayon,typo_rayon>, <7,20-typo_rayon,typo_z-typo_rayon> }
	        box { <typo_rayon,typo_rayon,0>, <7-typo_rayon,20-typo_rayon,typo_z> }
		matrix
			<
			1,    0, 0,       // the first 3 lines form a rotation matrix
			-0.5, 0, 0,         // since it is not orthogonal, shearing occurs
			0,    0, 0,
			10,   0, 0          // the last 3 values contain the translation
			>
		}
	union	{
		// --- Face avant ---
		sphere	 { <typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, typo_rayon, typo_rayon>, <typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
		sphere	 { <typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, 20-typo_rayon, typo_rayon>, <7-typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
		sphere	 { <7-typo_rayon, 20-typo_rayon, typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, 20-typo_rayon, typo_rayon>, <7-typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
		sphere	 { <7-typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, typo_rayon, typo_rayon>, <typo_rayon, typo_rayon, typo_rayon>, typo_rayon }
		// --- Face arriere ---
		sphere	 { <typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, typo_rayon, typo_z-typo_rayon>, <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
		sphere	 { <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, <7-typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
		sphere	 { <7-typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, <7-typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
		sphere	 { <7-typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, typo_rayon, typo_z-typo_rayon>, <typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
		// --- Jonction Face avant / arriere ---
	        cylinder { <typo_rayon, typo_rayon, typo_rayon>, <typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <typo_rayon, 20-typo_rayon, typo_rayon>, <typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, 20-typo_rayon, typo_rayon>, <7-typo_rayon, 20-typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        cylinder { <7-typo_rayon, typo_rayon, typo_rayon>, <7-typo_rayon, typo_rayon, typo_z-typo_rayon>, typo_rayon }
	        box { <typo_rayon,0,typo_rayon>, <7-typo_rayon,20,typo_z-typo_rayon> }
	        box { <0,typo_rayon,typo_rayon>, <7,20-typo_rayon,typo_z-typo_rayon> }
	        box { <typo_rayon,typo_rayon,0>, <7-typo_rayon,20-typo_rayon,typo_z> }
		matrix
			<
			1,    0, 0,       // the first 3 lines form a rotation matrix
			0.5,  0, 0,         // since it is not orthogonal, shearing occurs
			0,    0, 0,
			10,   0, 0          // the last 3 values contain the translation
			>
		}
	}



// ----------------------------------------

camera {
  right x*image_width/image_height 
  direction z*2
  location  <-15,128,-55>
  look_at   <0,0,10>
}


light_source {
  0*x                 // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <32, 0, 0> <0, 0, 32> // lights spread out across this distance (x * z)
  16, 16                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 3          // 0,1,2,3...
  //jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <50,100,-80>    // <x y z> position of light
}



background { color rgb <0.9, 0.9, 1.0> }

union	{
	object { lettre_P }
	//object { lettre_O translate x*21 }
	object { lettre_V translate x*40 }
         texture{ Chrome_Metal
                  finish { diffuse 0.9 phong 1 }
                  scale 0.5 translate<0,1,0>
                } // end of texture ---------------------------  
	translate x*-30
	rotate x*90
	translate y*typo_z+0.3
	}
 
 
#declare trou = 14 ;
#declare diam = 8 ;

union {
	difference {
		plane { y, 0 }
		cylinder { <0, -10000, 0>, <0, 1, 0>, trou } 
		cylinder { <0, -diam, 0>, <0, 100, 0>, trou+diam } 
		}
	torus { trou+diam, diam translate <0,-diam,0>} 
	translate <1,0,16>
	texture {  
		pigment{ color rgb 0.4 }
                normal { bumps 0.02 scale 4 }
 		finish { diffuse 1
 			ambient 0 
 			//phong 0.5 
 			reflection 0.4
 			}
		} 
	}
 
 
 
 