
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : DownTheDrain.pov
 Version     : 3.6.1c / MegaPOV 1.21
 Description : IRTC entry (Sept/Oct 2006: Absence)
               When the K'taah drained the world's oceans for their hydroponic tanks, 
               it turned out to be a great inconvenience for everybody.
               (However, this was nothing compared to when they flushed back their recycled sludge,
               before leaving...)
               
               Note: Beware that not everything is included with this scene!
               
 Date        : September/October 2006
 Author      : Thomas A. M. de Groot
 E-mail      : t.degroot@inter.nl.net
 
 Copyright (C) 2006. All rights reserved.
 Use and/or modification of this scene is free, except for commercial purposes.
 Commercial distribution is not allowed without written permission from the author.
**********************************************************************************/

// Render settings (right-click on on of the lines below):
// +w1024 +h576 +a0.3 +am2 +r2 +j
// +w1536 +h864 +a0.3 +am2 +r2 +j
// +w2048 +h1152 +a0.3 +am2 +r2 +j

//--------------------------------------------------------------------------------
// Note:
// POV-Ray(tm) file generated by Daylon Leveller(tm) 2.5, build 1928
// on Sun Sep 24 10:58:07 2006
//--------------------------------------------------------------------------------

#include "colors.inc"
#include "metals2.inc"	//with all ambient=0
#include "rand.inc"
#include "transforms.inc"
#include "textures.inc"	  
#include "functions.inc"  

default {texture {pigment {rgb <1,1,0> } } }
default {finish {ambient 0 } }
#declare MPov = 1;	//Megapov on/off
#declare Rad = 1;	//radiosity on/off
#declare RadSave = 0;	//radiosity save on/off (not used)
#declare SkySphere = 0;	//sky_sphere on/off

#declare PoF = 0;	//Norbert Kern's position_finder on/off
#declare HF = 1;	//landscape on/off
#declare TestTex = 0;	//landscape texture in test phase on/off
#declare Trees = 1;	//Trees on/off
#declare Lighthouse = 1;	//Lighthouse on/off
#declare Light_on = 0;	//spot_light in lighthouse on/off
#declare RuinedColonnade = 1;	//colonnade on/off
#declare Lobster = 1;	//lobster on/off
#declare BeachShells = 1;	//shells on/off
#declare BeachRocks = 1;	//rockss on/off
#declare Wreck = 1;	//wreck on/off
#declare Anchor = 1;	//anchor on/off
#declare Gulls = 1;	//sea gulls on/off
#declare SanJuan = 1;	//San Juan ship on/off
#declare Woodpiece = 1;	//piece of worn wood on/off
#declare Drain = 0;	//drain on/off (cancelled at later stage)
#declare Pilotis = 1;	//pilotis on/off
#declare Starship = 1;	//starship on/off
#declare Clouds_on = 1; //clouds on/off
#declare LightMedInt = 1;	//sunlight's media_interaction on/off

#if (MPov)
  #version unofficial megapov 1.21;
  #include "tone_mapping.inc"	     // MegaPOV include file for Clip_Colors()
#else
  #version 3.6;
#end

global_settings {
  #if (MPov)
  Clip_Colors()			     // MegaPOV: tone mapping for antialiasing like in version 3.5 (smoother transitions)
  exposure 1
  exposure_gain 1.6
  #end
  assumed_gamma 1.0
  noise_generator 2
  max_trace_level 10
  #if (Rad)
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.02           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 1             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1.0                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
  #end
}

// A multiplicator for size and position:
#declare M = 10;
#declare cam_loc = <47.500000, 1.2100000, -45.500000>*M;
#declare lookat  = <198.8288, 4.5187, -146.7784>*M;
#declare Sunpos = <-100000.0, 50000.0, -50000.0>;

camera {
  cylinder 1
	location cam_loc
	sky <0.01, 0.99, 0>
	//direction <0.83599358797, 0.00822654460, -0.54862976074> //as calculated by Leveller
	//up <-0.00687535928, 0.99987199691, 0.00451622474>        //as calculated by Leveller
	//right <-0.38903697359, 0.00000248784, -0.59280851717>    //as calculated by Leveller
  right     x*image_width/image_height
  look_at lookat
	angle 75.000
}

//---------------------------------------
// Common stuff (cf Gilles Tran)
//---------------------------------------
#declare C_Sun_Yellowish = rgb <0.959,0.861,0.687>; // hazy midday
#declare C_SkyBlue_05 = rgb <91,113,171>/255;
#declare C_SkyBlue_06 = rgb <161,184,213>/255;
//#declare C_Sun=rgb <237,194,117>/255; // redish yellow
#declare C_Sun = C_Sun_Yellowish;

//Needed for the clouds:
#macro GammaColor(Color,Gamma)
    rgb <pow(Color.red,Gamma),pow(Color.green,Gamma),pow(Color.blue,Gamma)>
#end

//---------------------------------------
// Sky (Gilles Tran)
//---------------------------------------
#if (SkySphere)
  #declare P_Sky = 
  pigment{
    gradient z
    pigment_map{
        [0 pigment_pattern {function{max(0,min(1,y))}} color_map {[0 C_SkyBlue_06*2][0.5 C_SkyBlue_05*2]}]
        [1 pigment_pattern {function{max(0,min(1,y))}} color_map {[0 C_SkyBlue_06][0.5 C_SkyBlue_05]}]
    }
    scale <1,1,2>
    translate -z
  }

  sky_sphere {
    pigment {P_Sky}
  }

#else
#declare LocalTransmit = 0.4;
  #declare BlueSkySphere = 
  texture {      
    pigment {
      gradient y
      pigment_map {
        [0 pigment_pattern {function{max(0,min(1,y))}} color_map {[0 C_SkyBlue_06*2 transmit LocalTransmit][0.5 C_SkyBlue_05*2 transmit LocalTransmit]}]
        [1 pigment_pattern {function{max(0,min(1,y))}} color_map {[0 C_SkyBlue_06 transmit LocalTransmit][0.5 C_SkyBlue_05 transmit LocalTransmit]}]
      }
    }      
    finish {
      ambient 1.0
      diffuse 0.0
    }
  }

  #declare CosmosSkySphere = 
  texture {      
    pigment {
      color rgbt <0,0,0,1>
    }      
    finish {
      ambient 0.0
      diffuse 0.0
    }
  }

sphere {
  <0,0,0>,1
  texture { BlueSkySphere }
  interior_texture { CosmosSkySphere } //using inverse puts the inside of the sphere outside
  no_shadow
  no_reflection
  inverse // no need for hollow
  scale 5000
}

#end	//of SkySphere

//---------------------------------------
// Sun and fogs (Gilles Tran)
//---------------------------------------

#if (RadSave)
// point_light Sun:
light_source {
  <0.0, 0.0, 0.0>
  C_Sun*2
  translate  Sunpos
}
#else
//area_light Sun:
light_source {
  <0.0, 0.0, 0.0>
  C_Sun*2
  area_light <1.000, 0.000, 0.000>, <0.000, 1.000, 0.000>, 3, 3
  adaptive 1
  jitter
  orient
  circular
  media_interaction LightMedInt
  //looks_like {sphere {0, 1} texture {pigment {color rgb <1, 0, 0>} finish {ambient 1 diffuse 1 brilliance 0} } }
  scale 1000.0
  translate  Sunpos
}
#end

// distance fog;
fog {C_SkyBlue_06*1.2 fog_type 2 distance 900 fog_alt 30 fog_offset -5 turbulence 0.2} 

//======================================================================================================================================
// Here are the textures 
// (landscape texturing partly based on Rune S. Johansen's slopemt.pov in the POV-Ray demo's)

// A simple green texture for grass, plants, trees, etc.
#declare Vege_Texture =
texture {
   pigment {color <0.1,0.6,0.1>*0.5}
}

#declare GreenFungus =
  texture {
    pigment {
      agate
      color_map {
        [ 0.000000  rgb <0.00, 0.1875, 0.0>*0.5 filter 0.2 ]
        [ 0.099644  rgb <0.15, 0.1875, 0.0>*0.5 filter 0.3 ]
        [ 0.500000  rgb <0.25, 0.1875, 0.0>*0.5 filter 0.1 ]
        [ 0.594306  rgb <0.30, 0.1875, 0.0>*0.5 filter 0.9]
        [ 0.594306  rgb <0.30, 0.1875, 0.0>*0.5 filter 1.0 transmit 0.0]
        [ 1.000000  rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
      }
      warp {turbulence 0.9}
    }   
    normal {
      agate, 1.0
      agate_turb 0.8
      //bump_size 1.0
      slope_map {
        [0    <0.5, 1>]   // start in middle and slope up
        [0.25 <1.0, 0>]   // flat slope at top of wave
        [0.5  <0.5,-1>]   // slope down at mid point
        [0.75 <0.0, 0>]   // flat slope at bottom
        [1    <0.5, 1>]   // finish in middle and slope up
      }
      warp {turbulence 0.9}
    }   
    finish {
      ambient 0.0
      specular 0.3525
      roughness 0.006
    }
    scale 0.0001
  }

//sand texture based on isocacti.pov
#declare LightSand =
	texture {
		pigment {
		  granite
		  color_map {
		    [0.0 rgb < 1, 0.9, 0.65>]
		    [0.2 rgb < 1, 0.9, 0.65>*0.1]
		    [0.4 rgb < 1, 0.9, 0.65>*0.5]
		    [0.6 rgb < 1, 0.9, 0.65>]
		    [0.8 rgb < 1, 0.9, 0.65>*0.01]
		    [1.0 rgb < 1, 0.9, 0.65>]
		  }
		}
		normal {
		  granite 5 
		  bump_size 2
		}
		finish {
			brilliance 1
			specular 0.3
			roughness 0.005
		}
		scale 1/10e6
	}
texture {GreenFungus}

// A dark colored sand texture (TdG 2004; changed here):
#declare TdG_DarkSand = 
  texture {      
    pigment {
      waves
      color_map {
               [ 0.000000  rgbft <1.0, 0.816993, 0.479133, 0.0, 0.0> ]
               [ 0.049822  rgbft <0.939815, 0.699074, 0.518519, 0.0, 0.0>*0.1 ]
               [ 0.096085  rgbft <0.991333, 0.730905, 0.383667, 0.0, 0.0>*0.1 ]
               [ 0.149466  rgbft <0.990941, 0.863911, 0.446526, 0.0, 0.0>*0.1 ]
               [ 0.416370  rgbft <0.925926, 0.739198, 0.407407, 0.0, 0.0>*0.1 ]
               [ 1.000000  rgbft <1.0, 0.971785, 0.729133, 0.0, 0.0> ]
      }
      turbulence 1.0 //5
      lambda 6.0
      frequency 6.0
      ramp_wave
      //warp {turbulence <1.0, 1.0, 0.5> }//<5.0, 2.0, 1.0>
    }      
    normal{
      waves //, 0.2
      //warp {turbulence <0.5, 1.0, 1.0> }//<1.0, 5.0, 2.0>
    }     
    finish {
      ambient 0
      specular 0.4
      roughness 0.006
    }
    scale 0.02
  }

#declare TdG_BottomSand =
  texture {
    slope {
      -y*0.5, 0.0 , 0.5
      altitude y, 0.0 , 0.25
    }
      texture_map {
        [0.0 TdG_DarkSand]
        [1.0 LightSand]
      }
  }

// Sandstone macro based on PM2Ring's sandstone texture:
#macro Sandstone()
//Default parameter values:
#ifndef(RandNr)			#local RandNr = 2;							#end
#ifndef(Transmit)		#local Transmit = 0.8;					#end
#ifndef(Norm)				#local Norm = false;						#end
#ifndef(Pattern)		#local Pattern = 2;							#end
#ifndef(Turb)				#local Turb = 0.2;							#end
#ifndef(Tscale)			#local Tscale = 0.8;						#end
#ifndef(Trot)				#local Trot = <1, 7.5, 2.5>;		#end
#ifndef(Ttrans)			#local Ttrans = <1, 2, 1>;			#end

#local Seed = seed(RandNr);

//---The textures----------------------------------------------

#local Sandy = color rgb<1, .9, RRand(0.5,0.7,Seed)>;

#local CM_Sandstone =
colour_map{
  [0.3 rgbt <1, 1, 1, 1.2*Transmit>]
  [0.4 rgbt <1, 0, 0, Transmit>]
  [0.41 rgbt <0.5, 0.3, 0.1, .5*Transmit>]
  [0.42 rgbt <1, 0, 0, .75*Transmit>]
  [0.6 rgbt <1, 0.5, 0, Transmit>]
  [0.7 rgbt <1, 1, 1, .5*Transmit>]
}

#local NSand = 
normal{granite 0.125 scale 1.5E-3}

#local FSandstone =
finish {
  ambient 0.0
  diffuse RRand(0.5, 0.8, Seed) 
  //specular 0.01 roughness 1e-3
  brilliance 2
}

#local TSandstone_base =
texture{
  pigment {Sandy}
  #if (Norm)
    normal{NSand .5}
  #end
  finish{FSandstone}
}

//-------------------------------------------------------------
#local TStain = 
texture{
  pigment{
    #switch (Pattern)
    #case (1)
      agate    //maybe try something derived from f_Height
    #break
    #case (2)
      wrinkles  //good!
    #break
    #case (3)
      wood
    #break
    #case (4)
      marble
    #break
    #case (5)
      gradient <.3, 2, .1>
    #end
    turbulence RRand(Turb-0.1,Turb+0.1,Seed)
    colour_map{CM_Sandstone}
    //scallop_wave

    scale Tscale
    rotate Trot
    translate Ttrans
  }
  finish{FSandstone}
}

//-------------------------------------------------------------
//Final (layered) texture:

#declare TSandstone =
  texture{TSandstone_base}
  texture{TStain}

#end //of Sandstone macro

//======================================================================================================================================
// Now for the slope pattern textures (thanks to Rune S. Johansen's slopemt.pov in the POV-Ray demo's, including the comment lines).
// Before looking into these, try having a look at the texture of the height_field.

#declare RandNr = 10;
Sandstone()
#declare Sandstone_Texture1 = texture {TSandstone}

#declare RandNr = 5;
Sandstone()
#declare Sandstone_Texture2 = texture {TSandstone}

#declare RandNr = 15;
Sandstone()
#declare Sandstone_Texture3 = texture {TSandstone}

// A texture that has vegetation on the middle-high areas,
// and rock on the steepest and higher areas.
// Notice how the altitude values fit to the pattern values in the texture_map of the height_field.

#declare Vege2Rock_Texture2 =
texture {
   slope {
      -y*3, 0, 0.5
      altitude y, 0.030, 0.050
   } 
   texture_map {
      [0.45, Vege_Texture]
      [0.55, Sandstone_Texture1]
      [0.65, Sandstone_Texture2]
      [0.65, Sandstone_Texture3]
   }
}

// A rock texture for the high areas,
// Notice how the altitude values fit to the pattern values
// in the texture_map of the height_field below.
// The altitude values have been switched around because we
// want the snow near the top and not near the bottom (no snow here though).

#declare TopRock_Texture =
texture {
   slope {
      -y*2, 0, 0.5
      altitude y, 1.00, 0.050
   }
   texture_map {
      [0.99, Sandstone_Texture1]
      [0.70, Sandstone_Texture2]
   }
}

//======================================================================================================================================

#if (HF)
#debug "The height_fields used.\n"

// A water texture by Gilles Tran:
// ==============================
#declare fWater = 0.01; //filter
#declare tWater = 0.0; //transmit
#declare colWater = rgb <0.0,  64,  0.0>/255;
#declare Rip = 500; //ripple size (default = 1)
#declare matWater = 
material {
  texture {
    pigment {rgbft<colWater.red,colWater.green,colWater.blue,fWater,tWater>}
    normal {
      pigment_pattern {
        bozo
        color_map {
          [0.45 Black]
          [0.55 White]
        }
      }
      normal_map {
        [0 waves frequency 400 bump_size 0.01 turbulence 0.1]
        [1 
           function {
              f_noise3d( x*1, y*5, z*5)*0.8
             +f_noise3d( x*10, y*50, z*50)*0.2
             +f_noise3d( x*100, y*200, z*200)*0.2
           }
           bump_size 0.004
        ]
      }
    }
    finish {
      ambient 0
      diffuse 0.2
      specular 1
      roughness 1/500
      metallic
      brilliance 2
      reflection {
        0.6, 1
        fresnel on 
      }
      conserve_energy
    }
  }
  interior {
    ior 1.33
  }
} 


#declare HFs =
union {
  height_field {
	  png "Peakland.ter_hf.png"
	  smooth
    double_illuminate
    translate <-.5, 0.0000, -.5> //center the heightfield
    scale <511.000, 25.000, 511.000>*M
  }
  height_field {
	  png "RippledTerrain2.png"
	  smooth
    double_illuminate
	  translate <-.5, 0.0000, -.5> //center the heightfield
	  //rotate -90*y
	  scale <40, 0.05, 40>
	  rotate -3*x
	  rotate 2*z
    translate <478.165, 10.305, -459.112>
  }
  //a water body:
  box { <-500, -1, -500>, <500, 0, 500>
    material {matWater scale Rip}
    translate <560.624, 2.910, -696.937>	//translates to Drain centre, and a little lower than Drain top
  }
  #if (TestTex)
    texture {pigment {rgb <1,1,0> } }
  #else
    texture {
      gradient y
      scale 11
      // Notice the values in this texture_map, then compare them to the altitude values
      // in the slope pattern textures above.
      texture_map { 
        [0.0000, TdG_DarkSand]   // At the bottom of the estuary...
        [0.0025, TdG_BottomSand] // we want...
        [0.0030, LightSand]      // some plain sand.
         
        [0.030, Vege2Rock_Texture2] // Then some vegetation,
        [0.050, Vege2Rock_Texture2] // and rock.
         
        [0.050, TopRock_Texture] // Then plain rock
        [1.000, TopRock_Texture] // at the top.
      }
      scale <511.000, 25.000, 511.000>*M
    }
  #end	//of TextTex
}	//end of HFs union

// Take out the drain hole:
#declare Landscape =
#if (Drain)
  difference {
    object {HFs}
    cylinder { <0, 10, 0>, <0, -10, 0>, 9.9
      translate <560.624, 0.712, -696.937>	//location of the Drain
    }
  }
#else
  object {HFs}
#end

object {Landscape}

#end	//of HF

//coodinate axes for easier orientation:
/*union {
  cylinder { <0, 0, 0>, <1, 0, 0>, 0.05 pigment{Red}}//x
  cylinder { <0, 0, 0>, <0, 0, 1>, 0.05 pigment{Green}}//z
  translate <478.165, 10.5, -459.112>
}*/

//==================================================================================================================================
//Planting trees:

#if (Trees)
#debug "Trees.\n"
#include "Peakland.ter_array.pov"
#end //of Trees

//==================================================================================================================================
//Lighthouse (by Bob Hughes, 2000; http://news.povray.org/povray.text.scene-files/thread/%3C39a8ab59%40news.povray.org%3E/?ttop=216446&toff=350):

#declare Standalone = 0;
#if (Lighthouse)
#debug "Lighthouse.\n"
#include "lighthouse.pov"

object {Lighthouse_etc
  scale 0.3
  rotate 90*y
  translate <1036.798, 42.430, -961.689>
}

//atmosphere:
/*media { 
	method 3
  intervals 3 // raise this if more lights are used
  scattering { 5, rgb .01 extinction .75 eccentricity .25}
  samples 6, 6
  density {rgb 0.01}
}*/
#end //of Lighthouse

//==================================================================================================================================
// Ruined colonnade:

#if (RuinedColonnade)
#debug "Colonnade.\n"
#include "IonianColumnSegment.inc"

/*object {Colonnade
  scale 0.9
  rotate 0*y
  translate <514.107, 9.9, -468.321>
}*/

// Scattered segments:
#declare R = seed(163);
#declare Xpos = 450;
#declare Zpos = -500;

#declare Segments =
union {
  #while (Xpos < 550)
    #while (Zpos < -400)
      #declare Norm = <0, 0, 0>;
      #declare Start = <Xpos, 20, Zpos>;
      #declare Pos = trace (
        Landscape,      // object to test
        Start,           // starting point
        -y,              // direction
        Norm );          // normal
      #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
        object {IonianColumnSegment
          translate -0.5*y
          scale 0.8
          rotate RRand(0, 360, R)*y
          rotate <RRand(0, 45, R), 0, RRand(0, 45, R)>
          translate Pos
          material {
            TdG_FungyLimestone
            scale RRand(0.8, 1.2, R)
            rotate RRand(0, 360, R)
            translate RRand(-1, 1, R)
          }
        }
      #end // end of Norm
      #declare Zpos = Zpos + RRand(10, 16, R);
    #end //of Zpos
    #declare Zpos = -500;
    #declare Xpos = Xpos + RRand(10, 16, R);
  #end //of Xpos
}

object {Segments}

#end	//of RuinedColonnade

//==================================================================================================================================
// Lobster:

#if (Lobster)
#include "LOBSTER__POV_geom.inc"

object {LOBSTER__
  translate <-191.1269, 354.4212*1.29, -136.7504>
  scale 0.001
  rotate -100*y
  translate <479.116, 10.20, -462.000>
}

#end	//of Lobster

//==================================================================================================================================
// shells:

#if (BeachShells)
#debug "Shells on the sand.\n"
#include "Lamellibranch.inc"

#declare T = 0;
#declare R = seed(T);
#declare P = 0.95;
#declare Xpos = 450;
#declare Zpos = -500;

#declare Shells =
  union {
    #while (T < 3)
      #while (Xpos < 600)
        #while (Zpos < -300)
          #declare Norm = <0, 0, 0>;
          #declare Start = <Xpos, 20, Zpos>;
          #declare Pos = trace (
            Landscape,      // object to test
            Start,           // starting point
            -y,              // direction
            Norm );          // normal
          #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
            #declare Dis = Prob(P, R);
            object {Lamellibranch
              #if (Dis)
                scale RRand(0.003, 0.005, R)
              #else
                scale <1, -1, 1>
                translate 7*y
                scale RRand(0.003, 0.005, R)
                rotate <RRand(-5, 5, R), 0, RRand(-5, 5, R)>
              #end
              rotate RRand(0, 360, R)*y
              Reorient_Trans(y, Norm)	
              translate Pos
            }
          #end // end of Norm
          #declare Zpos = Zpos + RRand(1, 2, R);
        #end //of Zpos
        #declare Zpos = -500;
        #declare Xpos = Xpos + RRand(1, 2, R);
      #end //of Xpos
      #declare T = T+1;
      #declare R = seed(T);
      #declare Xpos = 450;
      #declare Zpos = -500;
    #end //of T
  }
  
object {Shells}

#end //of BeachShells

//==================================================================================================================================
// rocks:

#if (BeachRocks)
#debug "Rocks on the sand.\n"
#include "JVSrock001.inc"

#declare R = seed(164); //163
#declare Xpos = 350;
#declare Zpos = -500;

#declare Rocks =
union {
//#while (T < 3)
  #while (Xpos < 600)
    #while (Zpos < -300)
      #declare Norm = <0, 0, 0>;
      #declare Start = <Xpos, 20, Zpos>;
      #declare Pos = trace (
        Landscape,      // object to test
        Start,           // starting point
        -y,              // direction
        Norm );          // normal
      #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
        object {JVSrock001
          translate RRand(-0.1, 0.1, R)*y
          scale RRand(0.05, 0.2, R)
          rotate RRand(0, 360, R)
          translate Pos
          texture {
            Sandstone_Texture2
            scale RRand(0.3, 1.0, R)
            rotate RRand(0, 360, R)
            translate RRand(-1, 1, R)
          }
          texture {GreenFungus
            scale RRand(10000.0, 12000.0, R)
            rotate RRand(0, 360, R)
          }
        }
      #end // end of Norm
      #declare Zpos = Zpos + RRand(1.8, 3.0, R);
    #end //of Zpos
    #declare Zpos = -500;
    #declare Xpos = Xpos + RRand(2, 2.5, R);
  #end //of Xpos
  //#declare T = T+1;
  //#declare R = seed(T);
  //#declare Xpos = 450;
  //#declare Zpos = -500;
//#end //of T
}

object {Rocks}

#end //of BeachRocks

//==================================================================================================================================
// Wreck:

#if (Wreck)
#debug "Wreck on the sand.\n"
#include "ShipHull_POV_geom.inc"

object {ShipHull_
  scale 0.5
  rotate -20*y
  rotate -30*z
  translate <643.574, 0.000, -543.869>
}

#end	//of Wreck

//==================================================================================================================================
// Anchor:

#if (Anchor)
#debug "Anchor on the sand.\n"
#include "PlechtAnker.inc"

object {PlechtAnker
  scale 0.4
  rotate 45*y
  translate <487.129, 10.580, -460.041>
}

#end	//of Anchor

//==================================================================================================================================
// Sea gulls:

#if (Gulls)
#debug "Sea gulls in the sky.\n"
#include "Random3Dgulls_mcr.inc"

// Note: original wingspan about 5 POV units.
RandObject (false, 				// Goal = true: cubical space; false: spherical space
            false, 				// GoalArea = true: draws the boundary cube
            200, 					// SpaLi = boundary limits
            250, 					// Number = number of objects
            500, 					// SeedNumber = a number for the random generator
            20, 					// MaxRot = maximum and minimum rotation in x- and z-directions (y=360)
            0.05, 				// MinScale = minimum scaling of the object
            0.06, 				// MaxScale = maximum scaling of the object
            false, 				// Moray = true: if you want to use the macro in Moray
            <624, 180, -550> // Trans = a final, vector translation of the group
           )

object { RandomGroup }

#end //of Gulls

//==================================================================================================================================
// San Juan ship:

#if (SanJuan)
#debug "San Juan stranded.\n"
#include "SanJuan_H_sansvoiles_POV_geom.inc"

object {SanJuan_H_sansvoiles_
  scale 0.08
  rotate -20*z
  rotate -70*y
  //translate <626.482, 0.602, -681.903>
  translate <582.431, 2.5, -607.131>
}

#end	//of SanJuan

//==================================================================================================================================
// Piece of wood:

#if (Woodpiece)
#debug "Piece of drift wood.\n"
#include "WornWood_POV_geom.inc"

#declare P_WoodGrain8A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
}
#declare P_WoodGrain8B =
pigment {
    wood
    turbulence <0.04, 0.04, 1>
    octaves 4
    scale <0.05, 0.05, 1> * 0.66
}

#declare M_Wood8A = 
color_map { 
    [0.0 color rgb <0.45, 0.30, 0.15>*0.1]
    [0.9 color rgb <0.20, 0.15, 0.05>*0.1]
    [1.0 color rgb <0.45, 0.30, 0.15>*0.1]
}
#declare M_Wood8B = 
color_map { 
    [0.0 color rgb <0.60, 0.35, 0.20>*0.1 transmit 0.30]
    [0.5 color rgb <0.60, 0.35, 0.20>*0.1 transmit 0.80]
    [1.0 color rgb <1.00, 1.00, 1.00>*0.1 transmit 1.00] 
}

#declare N_Wood8A =
normal {
    wood, 5
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
}
#declare N_Wood8B =
normal {
    wood, 5
    turbulence <0.04, 0.04, 1>
    octaves 4
    scale <0.05, 0.05, 1> * 0.66
}

// Dark brown. Walnut? Based on T_Wood8 in woods.inc   
#declare T_Wood8   =
    texture { pigment { P_WoodGrain8A  color_map { M_Wood8A }} normal { N_Wood8A }} 
    texture { pigment { P_WoodGrain8B  color_map { M_Wood8B }} normal { N_Wood8B }}
    //texture { GreenFungus scale <10,1,1>*5000 }

//-------------------------------------------------------------------
object {WornWood_
  scale 0.1
  texture {T_Wood8
    scale <0.1, 1, 1>
    rotate 89*x
    rotate 90*z
  }
  rotate -3.5*z
  rotate 40*x
  rotate -90*y
  translate <477.165, 10.20, -459.112>
}

#end	//of Woodpiece

//==================================================================================================================================
// Drain:

#if (Drain)
#debug "Drain.\n"
/*#include "Drain_POV_geom.inc"

object {Drain_
  scale 10
  translate <560.624, 2.915, -696.937>	//y=0.912 is the bottom depth here
}*/

#end	//of Drain

//==================================================================================================================================
// Pilotis:

#if (Pilotis)
#debug "Jetty and the male figure.\n"
#include "Pilotis_POV_geom.inc"//wooden jetty
#include "My_first_POV_geom.inc"//Poser model

#declare Xpos = 541.558;
#declare Ypos = 10.312;
#declare Zpos = -461.186;

#declare Jetty =
object {Pilotis_
  scale 1
  rotate 110*y
  translate <Xpos, Ypos, Zpos>
}

object {Jetty}

#declare Norm = <0, 0, 0>;
#declare Start = <Xpos, 40, Zpos>;
#declare Pos =
  trace (
    Jetty,      // object to test
    Start,           // starting point
    -y,              // direction
    Norm );          // normal
    
#if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
  object {My_first_
    scale 2.5/0.3
    rotate -135*y
    translate Pos
  }
#end

#end	//of Pilotis

//==================================================================================================================================
// Starship:

#if (Starship)
#debug "Starship.\n"
#include "greebles.inc"

#declare Seed=seed(841);
#declare R = .015;
#declare DefHeight = .03*.1;
#declare Height = R*2*.4;
#declare Detail = 8;
#declare AdjustDetail = 1;			//boolean
#declare GreebleConstrain = 1;	//boolean
#declare GreebleHeight = 3;
#declare Diepte = 8;						//maximum recursion levels

#declare Points = array[11] {<-3, 0>, <-3, 0.5>, <-2, 1>, <-2, 1.5>, <-2.5, 2>, <-2, 2.5>, <-1.5, 2>, <-1, 2>, <-0.5, 3>, <0, 3>, <0, 0>}
#declare Edges = array[11] {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}
#declare BevelEdges = array[11] {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}
	
#declare ShipSegment = 
union {
	GreebledRoundPrism (
	                   Points,	//Points: prism points
	                   Diepte,	//Diepte: maximum recursion-depth
	                   R,				//Radius: greeblecell-bevelwidth
	                   0.125,		//Bevel: bevel width
	                   0.125,		//BevelHeight: bevel height
	                   3,				//PrismHeight: height of the prism
	                   0				//Mirrored (boolean): if true then PrismHeight*2
	                   ) 
	  }
	  
#declare AlienShip =
union {
	object {ShipSegment}
	object {ShipSegment scale <-1,1,1>}
	object {ShipSegment scale <1,-1,1>}
	object {ShipSegment scale <-1,-1,1>}

	object {ShipSegment scale <1,1,-1>}
	object {ShipSegment scale <-1,1,-1>}
	object {ShipSegment scale <1,-1,-1>}
	object {ShipSegment scale <-1,-1,-1>}

	pigment {rgb <0.6, 0.7, 0.6>}
}

#declare ScaleFactor = 100;
object {AlienShip
  scale 10*ScaleFactor
  rotate 39*y
  rotate 2*z
  translate <100, 20, -100>*ScaleFactor
}

object {AlienShip
  scale 10*ScaleFactor
  rotate 12*y
  rotate -1*z
  translate <300, 20, -100>*ScaleFactor
}

#end	//of Starship

//==================================================================================================================================
// Clouds:

#if (Clouds_on)
#declare rd=seed(10);
#declare Intervals = 3; 		// cloud media intervals 1 for tests and 3 or 5 (slower!) for the final render

    #declare Cloud = 
    box {0, 1
        texture {
          pigment {Clear} 
          finish {ambient 0 diffuse 0}
        }
        // uncomment next line for testing the media box positions:
        //texture{pigment { color rgbt <1.0,0.0,0.0,0.5> } finish {ambient 0 diffuse 1}} 
        hollow
        interior {
            media {
                scattering {1, GammaColor(C_Sun,0.3)*0.0003} //0.0003
                absorption (1-C_SkyBlue_06)*0.0009  //0.0007 for very bright, hardly visible clouds merging with the fog
                intervals Intervals
                density {
                  //density_file df3 "Gilles Tran\MakeClouds\Version 2\df3 files\cloud_01.df3"
                  density_file df3 "Cloud_01_HiRes.df3"
                  interpolate 1
                }
            }
        }
        translate -0.5
        scale <1.33,-1,1>
        //scale <1,1,-1>
        //rotate <90,0,0>
        
    }

   //object {Cloud scale <1,1,1>*2000 translate <-1000, 250, -1300>}
//object {Cloud scale <2, 1, 1>*2000 rotate 45*y translate <1500, 200, -1500>}
object {Cloud scale <4.5, 4, 4.5>*1000 rotate -45*y translate <4500, 1000, -3000>}
   //object {Cloud scale <1,1,1>*1500 rotate 45*y translate <800,1000,200>}

#end	//of Clouds_on

//==================================================================================================================================
//position finder:

#if (PoF)
//#declare Standalone = 0;
#include "position_finder.pov"//has been updated with new features by me

#declare x_pos = 42;       // between 0 for left and 100 for right image edge
#declare y_pos = 57;       // between 0 for sky and 100 for lower image egde 

#declare mirror  = -1;		//1 for normal / -1 for mirror image or along -z
#declare cam_ang = 75;
#declare sign_scale = 5;
#declare sign_rot = 90;

#declare areal = object {Landscape}
   
pos_finder (areal, mirror, cam_loc, lookat, cam_ang, x_pos, y_pos, sign_scale, sign_rot)

#end	//of PoF

