// Persistence of Vision Ray Tracer Scene Description File
// File: rf_filing_cabinet.inc
// Vers: 3.6
// Desc: filing cabinet 
// Date: Dec 4, 2005, Nov 16,2006
// Auth: Rob Fitzel
// Units: inches
// Macro filing_cabinet (xl,zl,num_shelves,xfrm)

#include "metals.inc"

#declare included_rf_filing_cabinet = 1;


#declare t_filing_cabinet_blue = 
texture {
    pigment {rgb (1.1*<0.306,0.286,0.631>+<0.508,0.490,0.671>)/2}
  //pigment {rgb <0.508,0.490,0.671>} 
 // finish {specular 0.8 roughness 0.001 ambient rgb 0 diffuse 0.5} 
 // finish {ambient rgb 0 diffuse 0.5 specular 1 roughness 0.05 metallic brilliance 1 }  
    finish {ambient rgb 0.1 diffuse 0.3 specular 0.5 roughness 0.05 metallic brilliance 1 }

  
//  normal {bumps 0.1  scale 0.01}
};
#declare t_filing_cabinet_metal = texture {pigment {rgb 0.5} finish {phong 1 phong_size 120 reflection 0.1}};

#declare filing_cabinet_door = 
union {
  box {<0,0,0>,<20,9,0.5>      } 
  box {<9,7,0>,<11,8,-0.01> pigment {rgb 0.6}} // label
  union {  // handle
    box {<0,9,0>,<20,9.05,1> }
    box {<0,9,1>,<20,9.8,1.1> }
    box {<0,9.8,1.1>,<20,9.9,0> }
 //   texture {t_filing_cabinet_metal}
  }

};
#macro filing_cabinet (xl,zl,num_shelves,xfrm)
union {
  box   {<-0.1,0,-0.1>,<20.1,1,20.1> translate <0,3+num_shelves*10,0>} // top 
  cylinder {<10,0,0>,<10,0,-0.2> 0.3 translate <0,3.5+num_shelves*10,0>  texture {T_Chrome_4A}} 
  box   {<0,0,1>,<0.5,3+num_shelves*10,19.5> }   // sides
  box   {<19.5,0,1>,<20,3+num_shelves*10,19.5>}
  box   {<0,0,1>,<20,3,20>} // bottom
  box   {<0,3,19>,<20,3+num_shelves*10,20>}
  // doors 
  #local i=0;
  #while (i<num_shelves) 
    union {filing_cabinet_door translate <0,3+10*i,0>}
    #local i=i+1;
  #end
  texture {t_filing_cabinet_blue}
  scale <1/20,1,1/20>
  scale 1/12
  scale <xl,1,zl> 
  transform {xfrm}
}
#end  