// Persistence of Vision Ray Tracer Scene Description File
// File: rf_mcc_objs.inc
// Vers: 3.6
// Desc: Misc objects in the Mission Control Center
// Date: Nov 12, 2006 
// Auth: Rob Fitzel
// Unit: feet

#ifndef (Metals_Inc_Temp)
  #include "metals.inc"
#end 
#include "shapes.inc" 
#include "rand.inc" 
#include "rf_mcc_textures.inc" 
#ifndef (included_rf_water_bottle2)
  #include "rf_water_bottle2.inc" // yes, they allow food and drink into the WFCR
#end
#ifndef (included_rf_popcan)
  #include "rf_popcan.inc"
#end 

#include "rf_binders.inc"

#declare garbage_seed = seed(83863);

// tall microphone/light ?
#declare mcc_tall_lamp = 
union { 
  cylinder {<0,0,0>,<0,0.1,0>,0.5}
  cylinder {<0,0,0>,<0,9,0> 0.05}
  cylinder {<0,9,0>,<0,9.2,0>,0.01}
  sphere {0,0.3 clipped_by {plane {y,0}} translate <0,9.5,0>}
  texture {T_Chrome_3B}
  };

#declare mcc_short_lamp =
union { 
  cylinder {<0,0,0>,<0,0.1,0>,0.5}
  cylinder {<0,0,0>,<0,3,0> 0.05} 
  union {
    cone {<0,0,-0.5>,0.2,<0,0,0.1> 0.25}
    cone {<0,0,0.1>,0.4,<0,0,0.6> 0.5}
    rotate -x*45
    translate <0,3,0>
    }
  texture {pigment {rgb 0} finish {phong 1 phong_size 100}}
  };

#declare thermostat =
union {
  box{<0,0,0>,<0.01,0.4,0.4> pigment {rgb 0.7}} // back plate
  box{<0,0.05,0.05>,<0.2,0.35,0.35> pigment {rgb 0.7}} // body
  box{<0,0.07,0.07>,<0.21,0.33,0.33> pigment {rgb 0}}
  };

#declare metallic_light_switch =
union {
  box{<0,0,0>,<0.01,0.4,0.2> texture {T_Chrome_3C}}
  box{<0,0.15,0.09>,<0.05,0.25,0.11> pigment {rgb 0} }

}; 

#declare t_ceiling_projector_gray = texture {pigment {rgb 0.6} finish {specular 0.8 roughness 0.001}};


#declare ceiling_projector =
union {  
  union {
    union {Round_Box_Merge(<-1,0,-1.5*10>,<1,0.8,1.5*10>,0.2) scale <1,1,0.1> texture {t_ceiling_projector_gray}}
    
    box {<-0.7,0.2,-1.5>,<-0.65,0.7,-1.5001> pigment {rgb 0.4}}
    box {<-0.6,0.2,-1.5>,<-0.55,0.7,-1.5001> pigment {rgb 0.4}}
    box {<-0.5,0.2,-1.5>,<-0.45,0.7,-1.5001> pigment {rgb 0.4}}

    box {<-0.6,0.5,-1.4>,< 0.6,0.9,-1.2>  texture {t_ceiling_projector_gray}} 
    box {<-0.6,0.5,-1.2>,<0.6,0.9,1.4>  texture {pigment {rgb 0}}} 
    box {<-0.1,0.2,-1.6>,<0.1,0.6,-1.5> pigment {rgb 0}}
    box {<-1,0,1.5>,<1,0.8,1.55> pigment {rgb 0}}
    
    box {<-1.01,0.2,-0.7>,   <1.01,0.6,0.4> pigment {rgb 0} } // black box on either side  
    // black box wiring
    torus {1,0.02 scale <1.3,1,0.2> pigment {rgb 0.7} rotate -x*30 translate <0,0.3,0>}
    torus {1,0.02 scale <1.3,1,0.2> pigment {rgb 0.7} rotate -x*50 translate <0,0.4,-0.3>}
    torus {1,0.02 scale <1.3,1,0.4> pigment {rgb 0.7} rotate -x*80 translate <0,0.5,0.1>}
    torus {1,0.02 scale <1.3,1,0.45> pigment {rgb 0.4} rotate -x*90 translate <0,0.5,0.1>}  
    torus {0.5,0.02 rotate x*10 translate <0,0.9,0> pigment {rgb 0.7}}
    torus {0.3,0.02 rotate z*10 translate <0,0.9,0> pigment {rgb 0.7}} 
    torus {0.5,0.02 scale <2,1,0.3> rotate x*80 rotate z*80 rotate y*0 translate <0,1,0> pigment {rgb 0.7}}
    
    // top mount
    cylinder {<0,0.5,0>,<0,1.2,0>,0.3 pigment {rgb 0}}
    cylinder {<0,0.4,0>,<0,1,0>,0.25 translate z*0.4 texture {T_Chrome_3C}} 
    cylinder {<0,0,0>,<0,1,0>,0.1 texture {T_Chrome_3C} translate <-0.5,0,1.2>}
    cylinder {<0,0,0>,<0,1,0>,0.1 texture {T_Chrome_3C} translate < 0.5,0,1.2>}
    
    scale <1,0.7,0.8> // subjective
  }
  
  // mount to ceiling
  cylinder {<0,0.5,0>,<0,6,0> 0.1 pigment {rgb 0}}  
  no_shadow
};







#declare t_short_shelving_unit = texture {pigment {rgb 0.1}}; //TODO: make black 

// measures 36"x26"x12 
/*
#declare long_shelving_unit =
union {
  box {<0,0,0>,<36,0.5,11>} // base  
  box {<0,12.5,0>,<36,13,11>} // shelf
  box {<0,25,0>,<36,26,11>} // top
  box {<0,0,11>,<36,26,10>} // back
  box {<0,0,0>,<1,26,11>} // sides
  box {<36,0,0>,<35,26,11>}
  texture {t_short_shelving_unit} 
  scale 1/12
  }; 
*/
// xl - x length, bsd - seed, xfrm - transformation  
#macro shelving_unit(xl,bsd,xfrm) 
  #local i=1.1;
  #local sc = 1;
  #local tsc = sc;
  union {
    box {<0,0,0>,<xl,0.5,11>} // base  
    box {<0,12.5,0>,<xl,13,11>} // shelf
    box {<0,25,0>,<xl,26,11>} // top
    box {<0,0,11>,<xl,26,10>} // back
    box {<0,0,0>,<1,26,11>} // sides
    box {<xl,0,0>,<xl-1,26,11>} 
    
    #while (i<xl-3) // need better
      #local sc = RRand(1.5,3.5,bsd);
     // box {<0,0,0>,<sc,11.5,6> translate <tsc,0.5,RRand(-0.5,2,bsd)> pigment {rgb  <0.8,0.784,0.678>}}
      object {binder_spine  scale <sc,1,1> translate <tsc,0.5,RRand(-0.5,2,bsd)> texture {t_binder_cover}}
      #local tsc = tsc+sc;
      #local i=i+sc;
    #end 
    #local i=1.1;
    #local tsc = 1;
    #while (i<xl-3) // need better
      #local sc = RRand(1.5,3.5,bsd);
   // box {<0,0,0>,<sc,11.5,6> translate <tsc,13,RRand(-0.5,2,bsd)> pigment {rgb  <0.8,0.784,0.678>}} 
      object {binder_spine scale <sc,1,1>  translate <tsc,13,RRand(-0.5,2,bsd)> texture {t_binder_cover}}
      #local tsc = tsc+sc;
      #local i=i+sc;
    #end     
    
    texture {t_short_shelving_unit} 
    scale 1/12  
    transform {xfrm}
    }
#end  

#declare short_shelving_unit = 
union {
  box {<0,0,0>,<24,0.5,11>} // base  
  box {<0,12.5,0>,<24,13,11>} // shelf
  box {<0,25,0>,<24,26,11>} // top
  box {<0,0,11>,<24,26,10>} // back
  box {<0,0,0>,<1,26,11>} // sides
  box {<24,0,0>,<23,26,11>}
  texture {t_short_shelving_unit} 
  scale 1/12
  }; 

// must be #included after rf_mcc_computer pod
          



#declare pod_end_table =  // make a macro
union { 
  #local bsd = seed(3888); 
  shelving_unit(24, bsd, transform {scale 12*<1,1,-1> translate <0,0,11>})
 // object {short_shelving_unit scale 12*<1,1,-1> translate <0,0,11>}
  box {<0,0,0>,<24,26,-25> texture {t_pod_blue_dark} } 
  box {<0,26,11>,<24,27,-25> pigment {rgb 0}}
  union {Round_Box_Merge(<0,0,14>,<24,10,-25>, 0.5)  texture {t_pod_desktop} scale <1,0.1,1> translate <0,28,0>}
  scale 1/12
};  


//#declare sheet_of_paper = box {<0,0,0>,<8.5,0.0001,11> scale 1/12 texture {t_white_paper_text scale 1/12}};

#declare sheet_of_white_paper = union { 
 // box {<0,0,0>,<1,0.0001,1> texture {t_white_paper } scale <8.5,1,11>} 
  
  box {<0,0,0>,<8.5,0.0001,11>  texture {t_white_paper}}
//  box {<2,0.0001,1>,<7.5,0.0002,10> texture {t_paper_text}}
  scale 1/12
};
 
#declare sheet_of_blue_paper = union {
  //box {<0,0,0>,<1,0.0001,1> texture {t_blue_paper } scale <8.5,1,11>} 

  box {<0,0,0>,<8.5,0.0001,11>  texture {t_blue_paper}}
 // box {<2,0.0001,1>,<7.5,0.0002,10> texture {t_paper_text}}
  scale 1/12
}; 
                                
                                 
#declare sticky_note = 
union {
  bicubic_patch {
   type 1 flatness 0.001
   u_steps 4 v_steps 4
   <0,0,0>,<1,0,0>,<2,0.0,0>,<3,0.3,0>
   <0,0,1>,<1,0,1>,<2,0.01,1>,<3,0.1,1>
   <0,0,2>,<1,0,2>,<2,0,2>,<3,0,2>
   <0,0,3>,<1,0,3>,<2,0,3>,<3,0,3>
   }
  
 // pigment {rgb <1.0,1.341>} //??
  pigment {rgb <0.82,0.898,0.357>}
  translate <0,0.5,0> 
  scale 3/4
  scale 1/12
}; 

#declare computer_cable = 
// cord - connects <0,0,0> and <0,0,24>
sphere_sweep {
  //linear_spline                 // linear curve
  cubic_spline                // alternative spline curves
  //b_spline
  6,
  <0, 0, -20>,0.2                            // number of specified sphere positions
  <0, 0,  0>, 0.2                // position, radius
  <-8, 0, 6>, 0.2                 // ...
  < 3, 0, 18>, 0.2
  < 0, 0, 24>, 0.2
  < 0, 0, 30>, 0.2
  //tolerance 0.001             // optional 
  scale 1/12
  translate <0,0,0>
}; 


#declare t_garbage_can_metal = texture {pigment {rgb 0.2} };
#declare t_garbage_bag       = texture {pigment {rgb 0} finish{specular 0.9 roughness 0.2} normal {crackle scale 0.2}}; 
#declare t_garbage_can =
texture {
  gradient y
  texture_map {
    [0.9 t_garbage_can_metal]
    [0.9 t_garbage_bag]
  }
  rotate z*10
};

#declare garbage_can = 
  union {
    cone {<0,0,0>,0.5,<0,1.5,0>, 0.6 open texture {t_garbage_can scale 1.5}  } 
    #local i=0;
    #while (i<7)
      popcan(1,can_open transform {scale cm_to_feet rotate x*RRand(30,90,garbage_seed) rotate y*rand(garbage_seed)*360 translate <0,RRand(1,1.4,garbage_seed),0>})
      object {water_bottle2 scale 1/12 rotate x*RRand(-90,90,garbage_seed) rotate y*rand(garbage_seed)*360 translate <0,RRand(1,1.3,garbage_seed),0>}
      #local i=i+1;
    #end
  };


#macro mini_flag(img,xfrm)  // inches
union { 
  union {
    cylinder {<0,0,0>,<0,0.25,0>,1}  
    cylinder {<0,0.25,0>,<0,0.5,0>,0.75}
    sphere {<0,0,0>, 0.4 scale <1,0.5,1> translate y*0.5}  
    texture {pigment {rgb <0.463,0.435,0.353>} finish {phong 1 phong_size 150}}
  }  
  union {
    cylinder {<0,0,0>,<0,4,0>,0.05 pigment {rgb <0.616,0.525,0.365>}} // post 
    cone {<0,8,0>,0.1<0,8.5,0>,0.05 pigment {rgb <0.616,0.525,0.365>}}  
    texture {pigment {rgb <0.616,0.525,0.365>} finish {phong 0.7 phong_size 50}}
  }
  cylinder {<0,4,0>,<0,8,0>,0.05 pigment {rgb 1}} // cloth wraparound

  bicubic_patch {
     type 1 flatness 0.001
     u_steps 4 v_steps 4 
     uv_vectors <0,1>,<1,1>,<1,0>,<0,0>
     <0,21,0>,<0,16,8>,<-5,8,9>,<-8,0,11>   
     <0,14,0>,<6,11,1>,<5,3,10>,<-3,-5,13>    
     <0,7,0>,<8,6,2>,<9,-1,9>,<4,-2,10>
     <0,0,0>,<9.5,-1,0>,<14,-6,8>,<11,-11,11> 
     uv_mapping 
     pigment {image_map{png img} }
     finish {ambient rgb 0.8} 
     scale 0.18
     translate y*4
    } 
  scale 1/12 // convert to feet
  transform {xfrm}
  }
#end  


#macro wall_mounted_camera(rot, xfrm)
  union {
    box {<-0.3,-0.5,0>,<0.3,0.5,0.1>}
    box {<-0.2,-0.1,0>,<0.2,0.3,2> rotate -x*15 clipped_by {plane {y,0.5}} }  
    union {
      cylinder {<0,0,0>,<0,0.1,0> 0.5 } 
      cylinder {<0,0.1,0>,<0,0.2,0> 0.3 pigment {rgb 0} }
      cylinder {<0,0.2,0>,<0,0.8,0> 0.4}
      
      
      union { 
        cylinder {<-0.5,-0.3,0>,<0.5,-0.3,0> 0.1 } // bolts
        box {<-0.4,-0.45,-0.3>,<0.4,-0.15,0.3> pigment {rgb 0.5} }
        cylinder {<0,0,-0.3>,<0,0,0.3> 0.2  pigment {rgb 0.4}} 
        cylinder {<0,0,0.3>,<0,0,0.305> 0.2   } 
        cylinder {<0,0,0.3>,<0,0,0.45>  0.15  }
        cylinder {<0,0,0.45>,<0,0,1>  0.2  } 
        cone     {<0,0,1>,0.2,<0,0,1.2>,0.3 }
        pigment {rgb 0} 
        rotate y*rot
        translate y*1
        }
        
      translate <0,0.5,1.5>       
      }
      
    
    texture {pigment {rgb 0.5}} 
    scale 0.5
    transform {xfrm}
  }
#end   

#local red_flower   = sphere {0,0.15 texture {pigment {rgb <0.7,0.4,0.4>} normal {bumps 2 scale 0.05} }};
#local white_flower = sphere {0,0.15 texture {pigment {rgb <0.7,0.7,0.7>} normal {bumps 2 scale 0.05} }};
#local blue_flower  = sphere {0,0.15 texture {pigment {rgb <0.4,0.4,0.7>} normal {bumps 2 scale 0.05} }};
#local fsd = seed(98113);
#include "rand.inc"

#declare quick_vase = 
union {
  sphere {0 1 scale <0.3,1,0.3>   translate y*0.6 clipped_by {plane {-y,0.1}} clipped_by {plane {y,1.4}} }
  #local i=0;
  #while (i<8)
    object {red_flower translate <RRand(0.1,0.7,fsd),RRand(1.6,1.9,fsd),0> rotate y*360*rand(fsd)}
    object {white_flower translate <RRand(0.1,0.7,fsd),RRand(1.5,2,fsd),0> rotate y*360*rand(fsd)}
    object {blue_flower translate <RRand(0.1,0.7,fsd),RRand(1.6,2,fsd),0> rotate y*360*rand(fsd)}

    #local i=i+1;
  #end
  
  texture {pigment {rgb <0.1,0.1,0.4>}}
  };


#macro tv1(xd,yd, img_idx, xfrm)
  #local t_tv1= texture {pigment{rgb 0.1} finish {specular 0.1 roughness 0.1}};
  #local max_tv_img = 8;
  #local tv_idx = mod(img_idx,max_tv_img);
  #local t_screen_img = concat("mcc_img",str(tv_idx,-2,0),".png"); 
  #local t_screen = texture{pigment{image_map{png t_screen_img  } rotate y*180} finish {ambient 1 phong 0.5 phong_size 100 reflection 0.2}};
  
  union {
    difference {  
      object  {Round_Box_Union(<0,0,0>,<xd,yd,-6>,xd*0.05)  texture {t_tv1}} 
      box {<1,3,1>,<xd-1,yd-1,-0.1>}
      texture {t_screen scale <xd-2,yd-4,1> translate <1,3,0>}
    }
      object {Round_Cylinder_Union(<0,yd*0.2,0>,<0,yd*0.75,-0.5> xd/2.1 xd*0.05) scale <1,1,1.2> clipped_by {plane{z,0}} scale <1,1,0.8> translate <xd/2,0,-6> } 
      box {<xd/2-xd*0.2,0,-6>,<xd/2+xd*0.2,yd*0.4,-12>}
      sphere {0,0.9*xd/2 clipped_by {plane{z,0}} scale <1,0.7,0.5> translate <xd/2,yd*0.5,-6> clipped_by {plane {-y,yd*0.75}} }
      texture {t_tv1}
    transform {xfrm}  
  }
#end 



#declare office_printer =  // units: feet
union { 
  difference { 
    union {
      box{<0,-1,0>,<2,3,3>}  // main body
      box{<1.4,0,2.6>,<1.8,0.01,2.9> translate y*3 pigment {rgb 0.5}}
      box{<2,2,0.5>,<2.05,2.7,2.4>}  
      box{<2,0.5,0.5>,<2.05,1.9,2.4>} 
      box{<0.5,2,3>,<1.7,2.6,3.05>}
      
    }
    intersection { 
      box {<-0.2,-0.2,-0.2>,<0.2,0,0.2>  }
      sphere {0 0.1} 
      translate <2,2.5,1.5> 
      } 
      
    intersection { 
      box {<-0.2,-0.2,-0.2>,<0.2,0,0.2>  }
      sphere {0 0.1} 
      translate <2,1.7,1.5> 
      } 
    intersection { 
      box {<-0.2,-0.2,-0.2>,<0.2,0,0.2>  }
      sphere {0 0.1} 
      translate <1.1,2.5,3> 
      }        
  //  sphere {0 0.1 translate <2,2.5,1.5> clipped_by {plane {y,2.5}}}
  }
  cylinder {<1,0,0>,<1,0,2.5> 1 clipped_by {plane {x,1}} scale <1,0.3,1> translate y*3} 
  cylinder {<2,0,0>,<2,0,2.5> 1 clipped_by {plane {x,2}} scale <1,0.1,1> translate y*3}  
  
  pigment {rgb <0.747,0.731,0.727>} 
  translate y*0.5 // needs to be a bit higher
  };    
  
  
#macro computer_mouse(rot,xfrm)
union { 
  union {
    torus {1 0.2 pigment {rgb 0.7} rotate z*90 scale <1,1,0.6>*0.8 translate y*-0.86 clipped_by {plane {-y,0}} }
    object {computer_cable translate <0,0.05,0.3> pigment {rgb 0.5} }
    rotate y*rot
    }
  object {Round_Box_Union(<-0.5,0,-0.4>,<0.5,5,0.4>,0.1) scale <1,0.001,1> pigment {rgb <0.2,0.2,0.6>}}
  transform {xfrm} 
} 
#end

#declare paper_shelf =
union {
  box {<0,0,0>,<12,0.1,12>}
  box {<0,0,0>,<0.1,1,12>}
  box {<12,0,0>,<11.9,1,12>}
  rotate x*5
};

#declare paper_shelves = 
union { 
  box {<0,0,12>,<12,15,12.1>} // back
  box {<0,0,0>,<12,1,12>} // base
  #local i=0;
  #while (i<5)
    object {paper_shelf translate y*(3*i+3)}
    #local i=i+1;
  #end 
  pigment {rgb <0.749,0.71,0.671>} 
  scale 1/12
};



#declare gc_plaque_round_part =
  prism {
    cubic_spline
   -0.1, // sweep the following shape from here ...
    0.1, // ... up through here
    6, // the number of points making up the shape ...
    < 0, -5>, // point#1 (control point... not on curve)
    < 0,  5>, // point#2  ... THIS POINT ...
    <-9,  0>, // point#3
    < 0, -5>, // point#4
    < 0,  5>, // point#5 ... MUST MATCH THIS POINT
    <-9,  0>  // point#6 (control point... not on curve)

    rotate -z*90
    translate y*1
  };

#declare gc_plaque = 
union {  
  object {gc_plaque_round_part pigment {rgb <0.5,0.8,0.9>} }
  object {gc_plaque_round_part translate y*1  pigment {rgb <0.5,0.8,0.9>/2} scale <1.1,0.8,0.8>}
  box{<0,-0.7,-6>,<0.3,0,6> pigment {rgb <0.3,0.2,0>} }
  translate y*0.7
  scale 1/12
  }

#macro paper_tray(p_height,xfrm) // units: feet
  union {
    box {<0,0,0>,<9.5,0.5,12> } // base 
    difference {
      box {<0,0,0>,<9.5,2,0.5> }
      box {<2.5,1,-0.1>,<7,1.5,0.6>}
    }
    difference {  
      box {<0,0,12>,<9.5,2,11.5>}
      box {<2.5,1,12.1>,<7,1.5,11.4>}
    }
    
    #if (p_height > 0)
      box {<0.5,0.5,0.5>,<9,0.5+p_height,11.5> texture {t_white_paper } }
    #end
    
    pigment {rgb 0.1}
    scale 1/12 
    transform {xfrm}
  }
#end

#declare screen_wipe_box =
union {
  box {<0,0,0>,<4,4,4> pigment {rgb <0.012,0.506,0.459>}} 
  box {<4,0,0>,<18,4,4> pigment {rgb 1}}
  box {<1,0,0>,<17,2.5,0.001> pigment {rgb 0.9} rotate x*30 translate <0,4,2>}  
  scale 1/12
  }


#declare magnetic_clip = 
union {
  cylinder {<0,0,0>,<0,0,-0.1> 0.5}
  cylinder {<0,0,-0.1>,<0,0,-0.8> 0.2}
  union {
    cylinder {<-2,0,0>,<2,0,0> 0.25}
    box {<-1.8,0,-0.2>,<1.8,-1.5,-0.19> }
    rotate -x*50
    translate -z*1
    } 
    box {<0,0,0>,<1,1,0.001>  scale <8.5,11,1> texture {t_white_paper rotate -x*90} rotate z*2 translate <-4,-12,0>} 
  texture {T_Chrome_2B} 
  scale 1/12

}